/* Generated by wayland-scanner 1.22.0 */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_SERVER_PROTOCOL_H
#define ORG_KDE_KWIN_OUTPUTDEVICE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_org_kde_kwin_outputdevice The org_kde_kwin_outputdevice protocol
 * @section page_ifaces_org_kde_kwin_outputdevice Interfaces
 * - @subpage page_iface_org_kde_kwin_outputdevice - output configuration representation
 * @section page_copyright_org_kde_kwin_outputdevice Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct org_kde_kwin_outputdevice;

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_INTERFACE
#define ORG_KDE_KWIN_OUTPUTDEVICE_INTERFACE
/**
 * @page page_iface_org_kde_kwin_outputdevice org_kde_kwin_outputdevice
 * @section page_iface_org_kde_kwin_outputdevice_desc Description
 *
 * An outputdevice describes a display device available to the compositor.
 * outputdevice is similar to wl_output, but focuses on output
 * configuration management.
 *
 * A client can query all global outputdevice objects to enlist all
 * available display devices, even those that may currently not be
 * represented by the compositor as a wl_output.
 *
 * The client sends configuration changes to the server through the
 * outputconfiguration interface, and the server applies the configuration
 * changes to the hardware and signals changes to the outputdevices
 * accordingly.
 *
 * This object is published as global during start up for every available
 * display devices, or when one later becomes available, for example by
 * being hotplugged via a physical connector.
 * @section page_iface_org_kde_kwin_outputdevice_api API
 * See @ref iface_org_kde_kwin_outputdevice.
 */
/**
 * @defgroup iface_org_kde_kwin_outputdevice The org_kde_kwin_outputdevice interface
 *
 * An outputdevice describes a display device available to the compositor.
 * outputdevice is similar to wl_output, but focuses on output
 * configuration management.
 *
 * A client can query all global outputdevice objects to enlist all
 * available display devices, even those that may currently not be
 * represented by the compositor as a wl_output.
 *
 * The client sends configuration changes to the server through the
 * outputconfiguration interface, and the server applies the configuration
 * changes to the hardware and signals changes to the outputdevices
 * accordingly.
 *
 * This object is published as global during start up for every available
 * display devices, or when one later becomes available, for example by
 * being hotplugged via a physical connector.
 */
extern const struct wl_interface org_kde_kwin_outputdevice_interface;
#endif

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * subpixel geometry information
 *
 * This enumeration describes how the physical pixels on an output are
 * laid out.
 */
enum org_kde_kwin_outputdevice_subpixel {
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_UNKNOWN = 0,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_NONE = 1,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_HORIZONTAL_RGB = 2,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_HORIZONTAL_BGR = 3,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_VERTICAL_RGB = 4,
	ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_VERTICAL_BGR = 5,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_SUBPIXEL_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * transform from framebuffer to output
 *
 * This describes the transform, that a compositor will apply to a
 * surface to compensate for the rotation or mirroring of an
 * output device.
 *
 * The flipped values correspond to an initial flip around a
 * vertical axis followed by rotation.
 *
 * The purpose is mainly to allow clients to render accordingly and
 * tell the compositor, so that for fullscreen surfaces, the
 * compositor is still able to scan out directly client surfaces.
 */
enum org_kde_kwin_outputdevice_transform {
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_NORMAL = 0,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_90 = 1,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_180 = 2,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_270 = 3,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_FLIPPED = 4,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_FLIPPED_90 = 5,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_FLIPPED_180 = 6,
	ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_FLIPPED_270 = 7,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_TRANSFORM_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_MODE_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_MODE_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * mode information
 *
 * These flags describe properties of an output mode. They are
 * used in the flags bitfield of the mode event.
 */
enum org_kde_kwin_outputdevice_mode {
	/**
	 * indicates this is the current mode
	 */
	ORG_KDE_KWIN_OUTPUTDEVICE_MODE_CURRENT = 0x1,
	/**
	 * indicates this is the preferred mode
	 */
	ORG_KDE_KWIN_OUTPUTDEVICE_MODE_PREFERRED = 0x2,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_MODE_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * describes enabled state
 *
 * Describes whether a device is enabled, i.e. device is used to
 * display content by the compositor. This wraps a boolean around
 * an int to avoid a boolean trap.
 */
enum org_kde_kwin_outputdevice_enablement {
	ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_DISABLED = 0,
	ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_ENABLED = 1,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_ENABLEMENT_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * describes capabilities of the outputdevice
 *
 * Describes what capabilities this device has.
 */
enum org_kde_kwin_outputdevice_capability {
	/**
	 * if this outputdevice can use overscan
	 */
	ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_OVERSCAN = 1,
	/**
	 * if this outputdevice supports variable refresh rate
	 * @since 4
	 */
	ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_VRR = 2,
};
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_VRR_SINCE_VERSION 4
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITY_ENUM */

#ifndef ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_ENUM
#define ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum org_kde_kwin_outputdevice_vrr_policy {
	ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_NEVER = 0,
	ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_ALWAYS = 1,
	ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_AUTOMATIC = 2,
};
#endif /* ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_ENUM */

#define ORG_KDE_KWIN_OUTPUTDEVICE_GEOMETRY 0
#define ORG_KDE_KWIN_OUTPUTDEVICE_MODE 1
#define ORG_KDE_KWIN_OUTPUTDEVICE_DONE 2
#define ORG_KDE_KWIN_OUTPUTDEVICE_SCALE 3
#define ORG_KDE_KWIN_OUTPUTDEVICE_EDID 4
#define ORG_KDE_KWIN_OUTPUTDEVICE_ENABLED 5
#define ORG_KDE_KWIN_OUTPUTDEVICE_UUID 6
#define ORG_KDE_KWIN_OUTPUTDEVICE_SCALEF 7
#define ORG_KDE_KWIN_OUTPUTDEVICE_COLORCURVES 8
#define ORG_KDE_KWIN_OUTPUTDEVICE_SERIAL_NUMBER 9
#define ORG_KDE_KWIN_OUTPUTDEVICE_EISA_ID 10
#define ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITIES 11
#define ORG_KDE_KWIN_OUTPUTDEVICE_OVERSCAN 12
#define ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY 13

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_EDID_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_ENABLED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_UUID_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_SCALEF_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_COLORCURVES_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_SERIAL_NUMBER_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_EISA_ID_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITIES_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_OVERSCAN_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_kwin_outputdevice
 */
#define ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY_SINCE_VERSION 4


/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an geometry event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x position within the global compositor space
 * @param y y position within the global compositor space
 * @param physical_width width in millimeters of the output
 * @param physical_height height in millimeters of the output
 * @param subpixel subpixel orientation of the output
 * @param make textual description of the manufacturer
 * @param model textual description of the model
 * @param transform transform that maps framebuffer to output
 */
static inline void
org_kde_kwin_outputdevice_send_geometry(struct wl_resource *resource_, int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, int32_t subpixel, const char *make, const char *model, int32_t transform)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_GEOMETRY, x, y, physical_width, physical_height, subpixel, make, model, transform);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an mode event to the client owning the resource.
 * @param resource_ The client's resource
 * @param flags bitfield of mode flags
 * @param width width of the mode in hardware units
 * @param height height of the mode in hardware units
 * @param refresh vertical refresh rate in mHz
 * @param mode_id Per outputdevice unique id to identify a mode
 */
static inline void
org_kde_kwin_outputdevice_send_mode(struct wl_resource *resource_, uint32_t flags, int32_t width, int32_t height, int32_t refresh, int32_t mode_id)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_MODE, flags, width, height, refresh, mode_id);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_kwin_outputdevice_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_DONE);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an scale event to the client owning the resource.
 * @param resource_ The client's resource
 * @param factor scaling factor of output
 */
static inline void
org_kde_kwin_outputdevice_send_scale(struct wl_resource *resource_, int32_t factor)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_SCALE, factor);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an edid event to the client owning the resource.
 * @param resource_ The client's resource
 * @param raw base64-encoded EDID string
 */
static inline void
org_kde_kwin_outputdevice_send_edid(struct wl_resource *resource_, const char *raw)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_EDID, raw);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an enabled event to the client owning the resource.
 * @param resource_ The client's resource
 * @param enabled output enabled state
 */
static inline void
org_kde_kwin_outputdevice_send_enabled(struct wl_resource *resource_, int32_t enabled)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_ENABLED, enabled);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an uuid event to the client owning the resource.
 * @param resource_ The client's resource
 * @param uuid output devices ID
 */
static inline void
org_kde_kwin_outputdevice_send_uuid(struct wl_resource *resource_, const char *uuid)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_UUID, uuid);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an scalef event to the client owning the resource.
 * @param resource_ The client's resource
 * @param factor scaling factor of output
 */
static inline void
org_kde_kwin_outputdevice_send_scalef(struct wl_resource *resource_, wl_fixed_t factor)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_SCALEF, factor);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an colorcurves event to the client owning the resource.
 * @param resource_ The client's resource
 * @param red red color ramp
 * @param green green color ramp
 * @param blue blue color ramp
 */
static inline void
org_kde_kwin_outputdevice_send_colorcurves(struct wl_resource *resource_, struct wl_array *red, struct wl_array *green, struct wl_array *blue)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_COLORCURVES, red, green, blue);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an serial_number event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serialNumber textual representation of serial number
 */
static inline void
org_kde_kwin_outputdevice_send_serial_number(struct wl_resource *resource_, const char *serialNumber)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_SERIAL_NUMBER, serialNumber);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an eisa_id event to the client owning the resource.
 * @param resource_ The client's resource
 * @param eisaId textual representation of EISA identifier
 */
static inline void
org_kde_kwin_outputdevice_send_eisa_id(struct wl_resource *resource_, const char *eisaId)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_EISA_ID, eisaId);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an capabilities event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_kwin_outputdevice_send_capabilities(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_CAPABILITIES, flags);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an overscan event to the client owning the resource.
 * @param resource_ The client's resource
 * @param overscan amount of overscan of the monitor
 */
static inline void
org_kde_kwin_outputdevice_send_overscan(struct wl_resource *resource_, uint32_t overscan)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_OVERSCAN, overscan);
}

/**
 * @ingroup iface_org_kde_kwin_outputdevice
 * Sends an vrr_policy event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_kwin_outputdevice_send_vrr_policy(struct wl_resource *resource_, uint32_t vrr_policy)
{
	wl_resource_post_event(resource_, ORG_KDE_KWIN_OUTPUTDEVICE_VRR_POLICY, vrr_policy);
}

#ifdef  __cplusplus
}
#endif

#endif
