// This file is generated by kconfig_compiler_kf6 from knights.kcfg.
// All changes you do to this file will be lost.
#ifndef SETTINGS_H
#define SETTINGS_H

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

class Settings : public KConfigSkeleton
{
  public:
    class EnumAnimationSpeed
    {
      public:
      enum type { Instant, Fast, Normal, Slow, COUNT };
    };
    class EnumBorderDisplayType
    {
      public:
      enum type { None, Border, Notation, COUNT };
    };
    class EnumPlayer1Protocol
    {
      public:
      enum type { Local, XBoard, COUNT };
    };
    class EnumPlayer2Protocol
    {
      public:
      enum type { Local, XBoard, Fics, COUNT };
    };
    class EnumColor
    {
      public:
      enum type { NoColor, White, Black, COUNT };
    };

    static Settings *self();
    ~Settings() override;

    /**
      Set Theme file for the board
    */
    static
    void setTheme( const QString & v )
    {
      if (!self()->isThemeImmutable())
        self()->mTheme = v;
    }

    /**
      Get Theme file for the board
    */
    static
    QString theme()
    {
      return self()->mTheme;
    }

    /**
      Is Theme file for the board Immutable
    */
    static
    bool isThemeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "Theme" ) );
    }

    /**
      Set whether to show a confirmation dialog before discarding game history
    */
    static
    void setAskDiscard( bool v )
    {
      if (!self()->isAskDiscardImmutable())
        self()->mAskDiscard = v;
    }

    /**
      Get whether to show a confirmation dialog before discarding game history
    */
    static
    bool askDiscard()
    {
      return self()->mAskDiscard;
    }

    /**
      Is whether to show a confirmation dialog before discarding game history Immutable
    */
    static
    bool isAskDiscardImmutable()
    {
      return self()->isImmutable( QStringLiteral( "askDiscard" ) );
    }

    /**
      Set internal variable controlling the confirm dialog
    */
    static
    void setDontAskInternal( const QString & v )
    {
      if (!self()->isDontAskInternalImmutable())
        self()->mDontAskInternal = v;
    }

    /**
      Get internal variable controlling the confirm dialog
    */
    static
    QString dontAskInternal()
    {
      return self()->mDontAskInternal;
    }

    /**
      Is internal variable controlling the confirm dialog Immutable
    */
    static
    bool isDontAskInternalImmutable()
    {
      return self()->isImmutable( QStringLiteral( "dontAskInternal" ) );
    }

    /**
      Set Moves animation speed
    */
    static
    void setAnimationSpeed( int v )
    {
      if (!self()->isAnimationSpeedImmutable())
        self()->mAnimationSpeed = v;
    }

    /**
      Get Moves animation speed
    */
    static
    int animationSpeed()
    {
      return self()->mAnimationSpeed;
    }

    /**
      Is Moves animation speed Immutable
    */
    static
    bool isAnimationSpeedImmutable()
    {
      return self()->isImmutable( QStringLiteral( "animationSpeed" ) );
    }

    /**
      Set whether the Board is animated during rotating and resizing
    */
    static
    void setAnimateBoard( bool v )
    {
      if (!self()->isAnimateBoardImmutable())
        self()->mAnimateBoard = v;
    }

    /**
      Get whether the Board is animated during rotating and resizing
    */
    static
    bool animateBoard()
    {
      return self()->mAnimateBoard;
    }

    /**
      Is whether the Board is animated during rotating and resizing Immutable
    */
    static
    bool isAnimateBoardImmutable()
    {
      return self()->isImmutable( QStringLiteral( "animateBoard" ) );
    }

    /**
      Set whether to rotate the board when in local two-player mode
    */
    static
    void setFlipBoard( bool v )
    {
      if (!self()->isFlipBoardImmutable())
        self()->mFlipBoard = v;
    }

    /**
      Get whether to rotate the board when in local two-player mode
    */
    static
    bool flipBoard()
    {
      return self()->mFlipBoard;
    }

    /**
      Is whether to rotate the board when in local two-player mode Immutable
    */
    static
    bool isFlipBoardImmutable()
    {
      return self()->isImmutable( QStringLiteral( "flipBoard" ) );
    }

    /**
      Set whether to play move sounds
    */
    static
    void setPlaySounds( bool v )
    {
      if (!self()->isPlaySoundsImmutable())
        self()->mPlaySounds = v;
    }

    /**
      Get whether to play move sounds
    */
    static
    bool playSounds()
    {
      return self()->mPlaySounds;
    }

    /**
      Is whether to play move sounds Immutable
    */
    static
    bool isPlaySoundsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "playSounds" ) );
    }

    /**
      Set chessboard border type
    */
    static
    void setBorderDisplayType( int v )
    {
      if (!self()->isBorderDisplayTypeImmutable())
        self()->mBorderDisplayType = v;
    }

    /**
      Get chessboard border type
    */
    static
    int borderDisplayType()
    {
      return self()->mBorderDisplayType;
    }

    /**
      Is chessboard border type Immutable
    */
    static
    bool isBorderDisplayTypeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "borderDisplayType" ) );
    }

    /**
      Set show check marker
    */
    static
    void setShowDanger( bool v )
    {
      if (!self()->isShowDangerImmutable())
        self()->mShowDanger = v;
    }

    /**
      Get show check marker
    */
    static
    bool showDanger()
    {
      return self()->mShowDanger;
    }

    /**
      Is show check marker Immutable
    */
    static
    bool isShowDangerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showDanger" ) );
    }

    /**
      Set show legal moves marker
    */
    static
    void setShowMarker( bool v )
    {
      if (!self()->isShowMarkerImmutable())
        self()->mShowMarker = v;
    }

    /**
      Get show legal moves marker
    */
    static
    bool showMarker()
    {
      return self()->mShowMarker;
    }

    /**
      Is show legal moves marker Immutable
    */
    static
    bool isShowMarkerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showMarker" ) );
    }

    /**
      Set show opponents move marker
    */
    static
    void setShowMotion( bool v )
    {
      if (!self()->isShowMotionImmutable())
        self()->mShowMotion = v;
    }

    /**
      Get show opponents move marker
    */
    static
    bool showMotion()
    {
      return self()->mShowMotion;
    }

    /**
      Is show opponents move marker Immutable
    */
    static
    bool isShowMotionImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showMotion" ) );
    }

    /**
      Set show clocks when time control is in use
    */
    static
    void setShowClock( bool v )
    {
      if (!self()->isShowClockImmutable())
        self()->mShowClock = v;
    }

    /**
      Get show clocks when time control is in use
    */
    static
    bool showClock()
    {
      return self()->mShowClock;
    }

    /**
      Is show clocks when time control is in use Immutable
    */
    static
    bool isShowClockImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showClock" ) );
    }

    /**
      Set show chat window, if supported by the protocol
    */
    static
    void setShowChat( bool v )
    {
      if (!self()->isShowChatImmutable())
        self()->mShowChat = v;
    }

    /**
      Get show chat window, if supported by the protocol
    */
    static
    bool showChat()
    {
      return self()->mShowChat;
    }

    /**
      Is show chat window, if supported by the protocol Immutable
    */
    static
    bool isShowChatImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showChat" ) );
    }

    /**
      Set show the text console, if supported by the protocol
    */
    static
    void setShowConsole( bool v )
    {
      if (!self()->isShowConsoleImmutable())
        self()->mShowConsole = v;
    }

    /**
      Get show the text console, if supported by the protocol
    */
    static
    bool showConsole()
    {
      return self()->mShowConsole;
    }

    /**
      Is show the text console, if supported by the protocol Immutable
    */
    static
    bool isShowConsoleImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showConsole" ) );
    }

    /**
      Set show move history
    */
    static
    void setShowHistory( bool v )
    {
      if (!self()->isShowHistoryImmutable())
        self()->mShowHistory = v;
    }

    /**
      Get show move history
    */
    static
    bool showHistory()
    {
      return self()->mShowHistory;
    }

    /**
      Is show move history Immutable
    */
    static
    bool isShowHistoryImmutable()
    {
      return self()->isImmutable( QStringLiteral( "showHistory" ) );
    }

    /**
      Set initial time limit for both players
    */
    static
    void setTimeLimit( int v )
    {
      if (!self()->isTimeLimitImmutable())
        self()->mTimeLimit = v;
    }

    /**
      Get initial time limit for both players
    */
    static
    int timeLimit()
    {
      return self()->mTimeLimit;
    }

    /**
      Is initial time limit for both players Immutable
    */
    static
    bool isTimeLimitImmutable()
    {
      return self()->isImmutable( QStringLiteral( "timeLimit" ) );
    }

    /**
      Set time increment per move (for Incremental time control)
    */
    static
    void setTimeIncrement( int v )
    {
      if (!self()->isTimeIncrementImmutable())
        self()->mTimeIncrement = v;
    }

    /**
      Get time increment per move (for Incremental time control)
    */
    static
    int timeIncrement()
    {
      return self()->mTimeIncrement;
    }

    /**
      Is time increment per move (for Incremental time control) Immutable
    */
    static
    bool isTimeIncrementImmutable()
    {
      return self()->isImmutable( QStringLiteral( "timeIncrement" ) );
    }

    /**
      Set the number of moves the player has to make in the specified time (for Conventional time control)
    */
    static
    void setNumberOfMoves( int v )
    {
      if (!self()->isNumberOfMovesImmutable())
        self()->mNumberOfMoves = v;
    }

    /**
      Get the number of moves the player has to make in the specified time (for Conventional time control)
    */
    static
    int numberOfMoves()
    {
      return self()->mNumberOfMoves;
    }

    /**
      Is the number of moves the player has to make in the specified time (for Conventional time control) Immutable
    */
    static
    bool isNumberOfMovesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "numberOfMoves" ) );
    }

    /**
      Set whether time limits are enabled and displayed
    */
    static
    void setTimeEnabled( bool v )
    {
      if (!self()->isTimeEnabledImmutable())
        self()->mTimeEnabled = v;
    }

    /**
      Get whether time limits are enabled and displayed
    */
    static
    bool timeEnabled()
    {
      return self()->mTimeEnabled;
    }

    /**
      Is whether time limits are enabled and displayed Immutable
    */
    static
    bool isTimeEnabledImmutable()
    {
      return self()->isImmutable( QStringLiteral( "timeEnabled" ) );
    }

    /**
      Set protocol to be used for player 1
    */
    static
    void setPlayer1Protocol( int v )
    {
      if (!self()->isPlayer1ProtocolImmutable())
        self()->mPlayer1Protocol = v;
    }

    /**
      Get protocol to be used for player 1
    */
    static
    int player1Protocol()
    {
      return self()->mPlayer1Protocol;
    }

    /**
      Is protocol to be used for player 1 Immutable
    */
    static
    bool isPlayer1ProtocolImmutable()
    {
      return self()->isImmutable( QStringLiteral( "player1Protocol" ) );
    }

    /**
      Set protocol to be used for player 1
    */
    static
    void setPlayer2Protocol( int v )
    {
      if (!self()->isPlayer2ProtocolImmutable())
        self()->mPlayer2Protocol = v;
    }

    /**
      Get protocol to be used for player 1
    */
    static
    int player2Protocol()
    {
      return self()->mPlayer2Protocol;
    }

    /**
      Is protocol to be used for player 1 Immutable
    */
    static
    bool isPlayer2ProtocolImmutable()
    {
      return self()->isImmutable( QStringLiteral( "player2Protocol" ) );
    }

    /**
      Set the local human player's color in a game against a computer or over the Internet.
    */
    static
    void setColor( int v )
    {
      if (!self()->isColorImmutable())
        self()->mColor = v;
    }

    /**
      Get the local human player's color in a game against a computer or over the Internet.
    */
    static
    int color()
    {
      return self()->mColor;
    }

    /**
      Is the local human player's color in a game against a computer or over the Internet. Immutable
    */
    static
    bool isColorImmutable()
    {
      return self()->isImmutable( QStringLiteral( "color" ) );
    }

    /**
      Set list of programs to run for playing against the computer
    */
    static
    void setPrograms( const QStringList & v )
    {
      if (!self()->isProgramsImmutable())
        self()->mPrograms = v;
    }

    /**
      Get list of programs to run for playing against the computer
    */
    static
    QStringList programs()
    {
      return self()->mPrograms;
    }

    /**
      Is list of programs to run for playing against the computer Immutable
    */
    static
    bool isProgramsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "programs" ) );
    }

    /**
      Set the last selected program for player 1
    */
    static
    void setPlayer1Program( const QString & v )
    {
      if (!self()->isPlayer1ProgramImmutable())
        self()->mPlayer1Program = v;
    }

    /**
      Get the last selected program for player 1
    */
    static
    QString player1Program()
    {
      return self()->mPlayer1Program;
    }

    /**
      Is the last selected program for player 1 Immutable
    */
    static
    bool isPlayer1ProgramImmutable()
    {
      return self()->isImmutable( QStringLiteral( "player1Program" ) );
    }

    /**
      Set the last selected program for player 2
    */
    static
    void setPlayer2Program( const QString & v )
    {
      if (!self()->isPlayer2ProgramImmutable())
        self()->mPlayer2Program = v;
    }

    /**
      Get the last selected program for player 2
    */
    static
    QString player2Program()
    {
      return self()->mPlayer2Program;
    }

    /**
      Is the last selected program for player 2 Immutable
    */
    static
    bool isPlayer2ProgramImmutable()
    {
      return self()->isImmutable( QStringLiteral( "player2Program" ) );
    }

    /**
      Set the search depth of computer engines, when the difficulty is set to Configurable
    */
    static
    void setComputerSearchDepth( int v )
    {
      if (!self()->isComputerSearchDepthImmutable())
        self()->mComputerSearchDepth = v;
    }

    /**
      Get the search depth of computer engines, when the difficulty is set to Configurable
    */
    static
    int computerSearchDepth()
    {
      return self()->mComputerSearchDepth;
    }

    /**
      Is the search depth of computer engines, when the difficulty is set to Configurable Immutable
    */
    static
    bool isComputerSearchDepthImmutable()
    {
      return self()->isImmutable( QStringLiteral( "computerSearchDepth" ) );
    }

    /**
      Set the memory size used by computer engines, when the difficulty is set to Configurable
    */
    static
    void setComputerMemorySize( int v )
    {
      if (!self()->isComputerMemorySizeImmutable())
        self()->mComputerMemorySize = v;
    }

    /**
      Get the memory size used by computer engines, when the difficulty is set to Configurable
    */
    static
    int computerMemorySize()
    {
      return self()->mComputerMemorySize;
    }

    /**
      Is the memory size used by computer engines, when the difficulty is set to Configurable Immutable
    */
    static
    bool isComputerMemorySizeImmutable()
    {
      return self()->isImmutable( QStringLiteral( "computerMemorySize" ) );
    }

    /**
      Set list of servers for playing over the Internet
    */
    static
    void setServers( const QStringList & v )
    {
      if (!self()->isServersImmutable())
        self()->mServers = v;
    }

    /**
      Get list of servers for playing over the Internet
    */
    static
    QStringList servers()
    {
      return self()->mServers;
    }

    /**
      Is list of servers for playing over the Internet Immutable
    */
    static
    bool isServersImmutable()
    {
      return self()->isImmutable( QStringLiteral( "servers" ) );
    }

    /**
      Set the last selected server
    */
    static
    void setCurrentServer( const QString & v )
    {
      if (!self()->isCurrentServerImmutable())
        self()->mCurrentServer = v;
    }

    /**
      Get the last selected server
    */
    static
    QString currentServer()
    {
      return self()->mCurrentServer;
    }

    /**
      Is the last selected server Immutable
    */
    static
    bool isCurrentServerImmutable()
    {
      return self()->isImmutable( QStringLiteral( "currentServer" ) );
    }

    /**
      Set username for the Free Internet Chess Server
    */
    static
    void setFicsUsername( const QString & v )
    {
      if (!self()->isFicsUsernameImmutable())
        self()->mFicsUsername = v;
    }

    /**
      Get username for the Free Internet Chess Server
    */
    static
    QString ficsUsername()
    {
      return self()->mFicsUsername;
    }

    /**
      Is username for the Free Internet Chess Server Immutable
    */
    static
    bool isFicsUsernameImmutable()
    {
      return self()->isImmutable( QStringLiteral( "ficsUsername" ) );
    }

    /**
      Set whether to log in as guest
    */
    static
    void setGuest( bool v )
    {
      if (!self()->isGuestImmutable())
        self()->mGuest = v;
    }

    /**
      Get whether to log in as guest
    */
    static
    bool guest()
    {
      return self()->mGuest;
    }

    /**
      Is whether to log in as guest Immutable
    */
    static
    bool isGuestImmutable()
    {
      return self()->isImmutable( QStringLiteral( "guest" ) );
    }

    /**
      Set whether to log in to chess server automatically
    */
    static
    void setAutoLogin( bool v )
    {
      if (!self()->isAutoLoginImmutable())
        self()->mAutoLogin = v;
    }

    /**
      Get whether to log in to chess server automatically
    */
    static
    bool autoLogin()
    {
      return self()->mAutoLogin;
    }

    /**
      Is whether to log in to chess server automatically Immutable
    */
    static
    bool isAutoLoginImmutable()
    {
      return self()->isImmutable( QStringLiteral( "autoLogin" ) );
    }

    /**
      Set delay before a computer's move is reported, in milliseconds
    */
    static
    void setComputerDelay( int v )
    {
      if (!self()->isComputerDelayImmutable())
        self()->mComputerDelay = v;
    }

    /**
      Get delay before a computer's move is reported, in milliseconds
    */
    static
    int computerDelay()
    {
      return self()->mComputerDelay;
    }

    /**
      Is delay before a computer's move is reported, in milliseconds Immutable
    */
    static
    bool isComputerDelayImmutable()
    {
      return self()->isImmutable( QStringLiteral( "computerDelay" ) );
    }

    /**
      Set stored configurations of engine-specific settings
    */
    static
    void setEngineConfigurations( const QStringList & v )
    {
      if (!self()->isEngineConfigurationsImmutable())
        self()->mEngineConfigurations = v;
    }

    /**
      Get stored configurations of engine-specific settings
    */
    static
    QStringList engineConfigurations()
    {
      return self()->mEngineConfigurations;
    }

    /**
      Is stored configurations of engine-specific settings Immutable
    */
    static
    bool isEngineConfigurationsImmutable()
    {
      return self()->isImmutable( QStringLiteral( "engineConfigurations" ) );
    }

    /**
      Set whether opponent's moves are spoken
    */
    static
    void setSpeakOpponentsMoves( bool v )
    {
      if (!self()->isSpeakOpponentsMovesImmutable())
        self()->mSpeakOpponentsMoves = v;
    }

    /**
      Get whether opponent's moves are spoken
    */
    static
    bool speakOpponentsMoves()
    {
      return self()->mSpeakOpponentsMoves;
    }

    /**
      Is whether opponent's moves are spoken Immutable
    */
    static
    bool isSpeakOpponentsMovesImmutable()
    {
      return self()->isImmutable( QStringLiteral( "speakOpponentsMoves" ) );
    }

    /**
      Set whether commands over D-Bus are accepted
    */
    static
    void setAllowExternalControl( bool v )
    {
      if (!self()->isAllowExternalControlImmutable())
        self()->mAllowExternalControl = v;
    }

    /**
      Get whether commands over D-Bus are accepted
    */
    static
    bool allowExternalControl()
    {
      return self()->mAllowExternalControl;
    }

    /**
      Is whether commands over D-Bus are accepted Immutable
    */
    static
    bool isAllowExternalControlImmutable()
    {
      return self()->isImmutable( QStringLiteral( "allowExternalControl" ) );
    }

  protected:
    Settings();
    friend class SettingsHelper;


    // KGameTheme
    QString mTheme;

    // Notification Messages
    bool mAskDiscard;
    QString mDontAskInternal;

    // Preferences
    int mAnimationSpeed;
    bool mAnimateBoard;
    bool mFlipBoard;
    bool mPlaySounds;
    int mBorderDisplayType;
    bool mShowDanger;
    bool mShowMarker;
    bool mShowMotion;
    bool mShowClock;
    bool mShowChat;
    bool mShowConsole;
    bool mShowHistory;

    // Time Control
    int mTimeLimit;
    int mTimeIncrement;
    int mNumberOfMoves;
    bool mTimeEnabled;

    // Protocols
    int mPlayer1Protocol;
    int mPlayer2Protocol;
    int mColor;
    QStringList mPrograms;
    QString mPlayer1Program;
    QString mPlayer2Program;
    int mComputerSearchDepth;
    int mComputerMemorySize;
    QStringList mServers;
    QString mCurrentServer;
    QString mFicsUsername;
    bool mGuest;
    bool mAutoLogin;
    int mComputerDelay;
    QStringList mEngineConfigurations;

    // Accessibility
    bool mSpeakOpponentsMoves;
    bool mAllowExternalControl;

  private:
};

#endif

