#ifndef SBK_KSTATUSBARJOBTRACKERWRAPPER_H
#define SBK_KSTATUSBARJOBTRACKERWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kstatusbarjobtracker.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KStatusBarJobTrackerWrapper : public KStatusBarJobTracker
{
public:
    KStatusBarJobTrackerWrapper(::QWidget * parent = nullptr, bool button = true);
    KStatusBarJobTrackerWrapper(const KStatusBarJobTrackerWrapper &) = delete;
    KStatusBarJobTrackerWrapper& operator=(const KStatusBarJobTrackerWrapper &) = delete;
    KStatusBarJobTrackerWrapper(KStatusBarJobTrackerWrapper &&) = delete;
    KStatusBarJobTrackerWrapper& operator=(KStatusBarJobTrackerWrapper &&) = delete;
    ~KStatusBarJobTrackerWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void description(::KJob * job, const ::QString & title, const ::std::pair<QString,QString> & field1, const ::std::pair<QString,QString> & field2) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void finished(::KJob * job) override;
    void infoMessage(::KJob * job, const ::QString & message) override;
    void percent(::KJob * job, unsigned long percent) override;
    void processedAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount) override;
    void registerJob(::KJob * job) override;
    void resumed(::KJob * job) override;
    void slotClean(::KJob * job) override;
    void slotResume(::KJob * job) override;
    void slotStop(::KJob * job) override;
    void slotSuspend(::KJob * job) override;
    void speed(::KJob * job, unsigned long value) override;
    void suspended(::KJob * job) override;
    void timerEvent(::QTimerEvent * event) override;
    void totalAmount(::KJob * job, ::KJob::Unit unit, qulonglong amount) override;
    void unregisterJob(::KJob * job) override;
    void warning(::KJob * job, const ::QString & message) override;
    ::QWidget * widget(::KJob * job) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 24> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KSTATUSBARJOBTRACKERWRAPPER_H
