
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kwordmacroexpander_wrapper.h"

// Wrappers providing overrides
#include "kmacroexpanderbase_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qchar.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KWordMacroExpander_Type = nullptr;
static PyTypeObject *Sbk_KWordMacroExpander_TypeF(void)
{
    return _Sbk_KWordMacroExpander_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KWordMacroExpanderWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KWordMacroExpanderWrapper::KWordMacroExpanderWrapper(::QChar c) : KWordMacroExpander(c)
{
}

int KWordMacroExpanderWrapper::expandEscapedMacro(const ::QString & str, int pos, ::QStringList & ret)
{
    static const char *funcName = "expandEscapedMacro";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWordMacroExpander_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWordMacroExpander::expandEscapedMacro(str, pos, ret);
    }
    return KMacroExpanderBaseWrapper::sbk_o_expandEscapedMacro("KWordMacroExpander", funcName, gil, pyOverride, str, pos, ret);
}

bool KWordMacroExpanderWrapper::expandMacro(const ::QString & str, ::QStringList & ret)
{
    static const char *funcName = "expandMacro";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWordMacroExpander_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KWordMacroExpander.expandMacro");
        return false;
    }
    return sbk_o_expandMacro("KWordMacroExpander", funcName, gil, pyOverride, str, ret);
}

bool KWordMacroExpanderWrapper::sbk_o_expandMacro(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & str, ::QStringList & ret)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &str),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &ret)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &str),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &ret)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int KWordMacroExpanderWrapper::expandPlainMacro(const ::QString & str, int pos, ::QStringList & ret)
{
    static const char *funcName = "expandPlainMacro";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KWordMacroExpander_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KWordMacroExpander::expandPlainMacro(str, pos, ret);
    }
    return KMacroExpanderBaseWrapper::sbk_o_expandEscapedMacro("KWordMacroExpander", funcName, gil, pyOverride, str, pos, ret);
}

KWordMacroExpanderWrapper::~KWordMacroExpanderWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KWordMacroExpander_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KWordMacroExpander_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("KWordMacroExpander");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KWordMacroExpander >()))
        return -1;

    KWordMacroExpanderWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);

    if (PyArg_ParseTuple(args, "|O:KWordMacroExpander", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KWordMacroExpander::KWordMacroExpander(QChar=)
    if (numArgs == 0) {
        overloadId = 0; // KWordMacroExpander(QChar)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[0])))) {
        overloadId = 0; // KWordMacroExpander(QChar)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);
            }
        }
        ::QChar cppArg0 = QLatin1Char('%');
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KWordMacroExpander(QChar)
            cptr = new KWordMacroExpanderWrapper(cppArg0);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KWordMacroExpander >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KWordMacroExpanderFunc_expandEscapedMacro(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWordMacroExpander *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "expandEscapedMacro", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMacroExpanderBase::expandEscapedMacro(QString,int,QStringList&)->int
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        overloadId = 0; // expandEscapedMacro(QString,int,QStringList&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "expandEscapedMacro", errInfo, SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // expandEscapedMacro(QString,int,QStringList&)
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWordMacroExpander::expandEscapedMacro(cppArg0, cppArg1, cppArg2)
                : cppSelf->expandEscapedMacro(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KWordMacroExpanderFunc_expandMacro(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWordMacroExpander *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "expandMacro", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KWordMacroExpander::expandMacro(QString,QStringList&)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))) {
        overloadId = 0; // expandMacro(QString,QStringList&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "expandMacro", errInfo, SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QStringList cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // expandMacro(QString,QStringList&)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("KWordMacroExpander.expandMacro");
                return {};
            }
            bool cppResult = cppSelf->expandMacro(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KWordMacroExpanderFunc_expandPlainMacro(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWordMacroExpander *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "expandPlainMacro", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KMacroExpanderBase::expandPlainMacro(QString,int,QStringList&)->int
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[2])))) {
        overloadId = 0; // expandPlainMacro(QString,int,QStringList&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "expandPlainMacro", errInfo, SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStringList cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // expandPlainMacro(QString,int,QStringList&)
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KWordMacroExpander::expandPlainMacro(cppArg0, cppArg1, cppArg2)
                : cppSelf->expandPlainMacro(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KWordMacroExpander_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KWordMacroExpander_methods[] = {
    {"expandEscapedMacro", reinterpret_cast<PyCFunction>(Sbk_KWordMacroExpanderFunc_expandEscapedMacro), METH_VARARGS, nullptr},
    {"expandMacro", reinterpret_cast<PyCFunction>(Sbk_KWordMacroExpanderFunc_expandMacro), METH_VARARGS, nullptr},
    {"expandPlainMacro", reinterpret_cast<PyCFunction>(Sbk_KWordMacroExpanderFunc_expandPlainMacro), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KWordMacroExpander_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KWordMacroExpander *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KWordMacroExpanderWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KWordMacroExpander_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KWordMacroExpander_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KWordMacroExpander_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KWordMacroExpander_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KWordMacroExpander_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KWordMacroExpander_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KWordMacroExpander_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KWordMacroExpander_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KWordMacroExpander_spec = {
    "1:KCoreAddons.KWordMacroExpander",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KWordMacroExpander_slots
};

} //extern "C"

static void *Sbk_KWordMacroExpander_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::KMacroExpanderBase >())
        return dynamic_cast< ::KWordMacroExpander *>(reinterpret_cast< ::KMacroExpanderBase *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KWordMacroExpander_PythonToCpp_KWordMacroExpander_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KWordMacroExpander_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KWordMacroExpander_PythonToCpp_KWordMacroExpander_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KWordMacroExpander_TypeF()))
        return KWordMacroExpander_PythonToCpp_KWordMacroExpander_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KWordMacroExpander_PTR_CppToPython_KWordMacroExpander(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KWordMacroExpander_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::KWordMacroExpander *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_KWordMacroExpander_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KWordMacroExpander_SignatureStrings[] = {
    "KCoreAddons.KWordMacroExpander(self,c:QChar=QLatin1Char('%'))",
    "KCoreAddons.KWordMacroExpander.expandEscapedMacro(self,str:QString,pos:int,ret:QStringList)->int",
    "KCoreAddons.KWordMacroExpander.expandMacro(self,str:QString,ret:QStringList)->bool",
    "KCoreAddons.KWordMacroExpander.expandPlainMacro(self,str:QString,pos:int,ret:QStringList)->int",
    nullptr}; // Sentinel
#else
static constexpr size_t KWordMacroExpander_SignatureByteSize = 139;
static constexpr uint8_t KWordMacroExpander_SignatureBytes[139] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x0e,
    0xcf, 0x2f, 0x4a, 0xf1, 0x4d, 0x4c, 0x2e, 0xca, 0x77, 0xad, 0x28, 0x48, 0xcc, 0x4b, 0x49, 0x2d,
    0xd2, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0x49, 0xb6, 0x0a, 0x74, 0xce, 0x48, 0x2c, 0xb2, 0x0d, 0xf4,
    0x49, 0x2c, 0xc9, 0xcc, 0x33, 0x04, 0xb1, 0x35, 0xd4, 0x55, 0xd5, 0x35, 0x35, 0xb9, 0xbc, 0xf1,
    0xea, 0xd6, 0x4b, 0x05, 0x33, 0x5c, 0x8b, 0x93, 0x13, 0x0b, 0x52, 0x21, 0x52, 0x10, 0x03, 0x8b,
    0x4b, 0x8a, 0xac, 0x02, 0x83, 0x4b, 0x8a, 0x32, 0xf3, 0xd2, 0x75, 0x0a, 0xf2, 0x8b, 0xad, 0x32,
    0xf3, 0x4a, 0x74, 0x8a, 0x52, 0x4b, 0x60, 0x62, 0x3e, 0x99, 0xc5, 0x25, 0x9a, 0xba, 0x76, 0x40,
    0x51, 0xe2, 0x2c, 0xc0, 0x61, 0x32, 0xa6, 0x89, 0x49, 0xf9, 0xf9, 0x39, 0xc4, 0x19, 0x19, 0x90,
    0x93, 0x98, 0x99, 0x47, 0x96, 0x8b, 0x01, 0xb9, 0x2b, 0x7b, 0x38
};
#endif

PyTypeObject *init_KWordMacroExpander(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX].type;

    Shiboken::AutoDecRef Sbk_KWordMacroExpander_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KMacroExpanderBase_IDX]))));

    _Sbk_KWordMacroExpander_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KWordMacroExpander",
        "KWordMacroExpander*",
        &Sbk_KWordMacroExpander_spec,
        &Shiboken::callCppDestructor< KWordMacroExpander >,
        Sbk_KWordMacroExpander_Type_bases.object(),
        0);
    auto *pyType = Sbk_KWordMacroExpander_TypeF(); // references _Sbk_KWordMacroExpander_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KWordMacroExpander_SignatureStrings);
#else
    InitSignatureBytes(pyType, KWordMacroExpander_SignatureBytes, KWordMacroExpander_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KWordMacroExpander_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KWordMacroExpander_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KWordMacroExpander_PythonToCpp_KWordMacroExpander_PTR,
        is_KWordMacroExpander_PythonToCpp_KWordMacroExpander_PTR_Convertible,
        KWordMacroExpander_PTR_CppToPython_KWordMacroExpander);

    Shiboken::Conversions::registerConverterName(converter, "KWordMacroExpander");
    Shiboken::Conversions::registerConverterName(converter, "KWordMacroExpander*");
    Shiboken::Conversions::registerConverterName(converter, "KWordMacroExpander&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KWordMacroExpander).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KWordMacroExpanderWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KWordMacroExpander_TypeF(), &Sbk_KWordMacroExpander_typeDiscovery);

    qRegisterMetaType< ::KWordMacroExpander *>();

    return pyType;
}
