
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kprocesslist_kprocessinfo_wrapper.h"

// Argument includes
#include <QString>
#include <kprocesslist.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

using namespace KProcessList;

extern "C" {
static PyTypeObject *_Sbk_KProcessList_KProcessInfo_Type = nullptr;
static PyTypeObject *Sbk_KProcessList_KProcessInfo_TypeF(void)
{
    return _Sbk_KProcessList_KProcessInfo_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KProcessList_KProcessInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KProcessList::KProcessInfo >()))
        return -1;

    ::KProcessList::KProcessInfo *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    if (numArgs == 2)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]);

    if (PyArg_UnpackTuple(args, "KProcessInfo", 0, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KProcessInfo::KProcessInfo()
    // 1: KProcessInfo::KProcessInfo(KProcessList::KProcessInfo)
    // 2: KProcessInfo::KProcessInfo(qint64,QString,QString,QString)
    // 3: KProcessInfo::KProcessInfo(qint64,QString,QString)
    if (numArgs == 0) {
        overloadId = 0; // KProcessInfo()
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 3; // KProcessInfo(qint64,QString,QString)
        } else if (numArgs == 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
            overloadId = 2; // KProcessInfo(qint64,QString,QString,QString)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), (pyArgs[0])))) {
        overloadId = 1; // KProcessInfo(KProcessList::KProcessInfo)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KProcessInfo()
        {

            // KProcessInfo()
            cptr = new ::KProcessList::KProcessInfo();
            break;
        }
        case 1: // KProcessInfo(const KProcessList::KProcessInfo &other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KProcessList::KProcessInfo cppArg0_local;
            ::KProcessList::KProcessInfo *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KProcessInfo(KProcessList::KProcessInfo)
                cptr = new ::KProcessList::KProcessInfo(*cppArg0);
            }
            break;
        }
        case 2: // KProcessInfo(qint64 pid, const QString &command, const QString &name, const QString &user)
        {
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KProcessInfo(qint64,QString,QString,QString)
                cptr = new ::KProcessList::KProcessInfo(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 3: // KProcessInfo(qint64 pid, const QString &command, const QString &user)
        {
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KProcessInfo(qint64,QString,QString)
                cptr = new ::KProcessList::KProcessInfo(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KProcessList::KProcessInfo >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KProcessList_KProcessInfoFunc_command(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcessList::KProcessInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // command()const
        QString cppResult = const_cast<const ::KProcessList::KProcessInfo *>(cppSelf)->command();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessList_KProcessInfoFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcessList::KProcessInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::KProcessList::KProcessInfo *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessList_KProcessInfoFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcessList::KProcessInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::KProcessList::KProcessInfo *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessList_KProcessInfoFunc_pid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcessList::KProcessInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // pid()const
        qint64 cppResult = const_cast<const ::KProcessList::KProcessInfo *>(cppSelf)->pid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessList_KProcessInfoFunc_user(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcessList::KProcessInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // user()const
        QString cppResult = const_cast<const ::KProcessList::KProcessInfo *>(cppSelf)->user();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessList_KProcessInfo__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KProcessList::KProcessInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KProcessList_KProcessInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KProcessList_KProcessInfo_methods[] = {
    {"command", reinterpret_cast<PyCFunction>(Sbk_KProcessList_KProcessInfoFunc_command), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_KProcessList_KProcessInfoFunc_isValid), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KProcessList_KProcessInfoFunc_name), METH_NOARGS, nullptr},
    {"pid", reinterpret_cast<PyCFunction>(Sbk_KProcessList_KProcessInfoFunc_pid), METH_NOARGS, nullptr},
    {"user", reinterpret_cast<PyCFunction>(Sbk_KProcessList_KProcessInfoFunc_user), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KProcessList_KProcessInfo__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KProcessList_KProcessInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KProcessList_KProcessInfo_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KProcessList_KProcessInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KProcessList_KProcessInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KProcessList_KProcessInfo_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KProcessList_KProcessInfo_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KProcessList_KProcessInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KProcessList_KProcessInfo_spec = {
    "1:KCoreAddons.KProcessList.KProcessInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KProcessList_KProcessInfo_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KProcessInfo_PythonToCpp_KProcessInfo_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KProcessList_KProcessInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KProcessInfo_PythonToCpp_KProcessInfo_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KProcessList_KProcessInfo_TypeF()))
        return KProcessInfo_PythonToCpp_KProcessInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KProcessInfo_PTR_CppToPython_KProcessInfo(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KProcessList_KProcessInfo_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KProcessList_KProcessInfo_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KProcessInfo_COPY_CppToPython_KProcessInfo(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KProcessList::KProcessInfo *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KProcessList_KProcessInfo_TypeF(), new ::KProcessList::KProcessInfo(*source), true, true);
}

// Python to C++ copy conversion.
static void KProcessInfo_PythonToCpp_KProcessInfo_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KProcessList::KProcessInfo *>(cppOut) = *reinterpret_cast< ::KProcessList::KProcessInfo *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KProcessInfo_PythonToCpp_KProcessInfo_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KProcessList_KProcessInfo_TypeF()))
        return KProcessInfo_PythonToCpp_KProcessInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KProcessList_KProcessInfo_SignatureStrings[] = {
    "3:KCoreAddons.KProcessList.KProcessInfo(self)",
    "2:KCoreAddons.KProcessList.KProcessInfo(self,other:KCoreAddons.KProcessList.KProcessInfo)",
    "1:KCoreAddons.KProcessList.KProcessInfo(self,pid:qint64,command:QString,name:QString,user:QString)",
    "0:KCoreAddons.KProcessList.KProcessInfo(self,pid:qint64,command:QString,user:QString)",
    "KCoreAddons.KProcessList.KProcessInfo.command(self)->QString",
    "KCoreAddons.KProcessList.KProcessInfo.isValid(self)->bool",
    "KCoreAddons.KProcessList.KProcessInfo.name(self)->QString",
    "KCoreAddons.KProcessList.KProcessInfo.pid(self)->qint64",
    "KCoreAddons.KProcessList.KProcessInfo.user(self)->QString",
    "KCoreAddons.KProcessList.KProcessInfo.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t KProcessList_KProcessInfo_SignatureByteSize = 176;
static constexpr uint8_t KProcessList_KProcessInfo_SignatureBytes[176] = {
    0x78, 0xda, 0xad, 0x90, 0x3d, 0x0b, 0xc2, 0x30, 0x14, 0x45, 0xf7, 0xfc, 0x12, 0x0b, 0x31, 0xf8,
    0x85, 0x43, 0x07, 0x41, 0x9c, 0xa4, 0x0e, 0x4a, 0xc1, 0x35, 0xc4, 0x26, 0xd5, 0x40, 0x9b, 0x17,
    0xf3, 0xe2, 0xd0, 0x7f, 0x6f, 0x4b, 0x63, 0xc5, 0x2d, 0x2d, 0x8e, 0x17, 0xde, 0x39, 0xf7, 0x71,
    0xd7, 0x69, 0x76, 0x00, 0xa7, 0xf6, 0x52, 0x82, 0x41, 0x96, 0x9d, 0x1d, 0x14, 0x0a, 0xf1, 0xa4,
    0xd1, 0x0f, 0xe1, 0x68, 0x4a, 0x98, 0xa1, 0xaa, 0xca, 0x84, 0xac, 0x46, 0x5c, 0x53, 0xf0, 0x0f,
    0xe5, 0xe2, 0x80, 0x84, 0x2c, 0xc7, 0x98, 0xad, 0x96, 0xe9, 0x53, 0x1b, 0xbf, 0xdd, 0xd0, 0x02,
    0xea, 0x5a, 0x18, 0x99, 0x5e, 0x72, 0xef, 0xb4, 0xb9, 0x53, 0x23, 0x6a, 0x35, 0x84, 0x17, 0xb6,
    0x0f, 0x84, 0x90, 0x90, 0xc5, 0x9f, 0x2a, 0x7e, 0xad, 0x51, 0x4e, 0x16, 0x1c, 0xfd, 0x8c, 0xf3,
    0x5d, 0xa0, 0x23, 0x61, 0x8d, 0x57, 0x51, 0xe9, 0x01, 0xbe, 0x01, 0x54, 0x91, 0x64, 0xb7, 0xc6,
    0xb4, 0x4e, 0xfb, 0xed, 0xeb, 0x67, 0x88, 0xe4, 0xba, 0x71, 0xa6, 0x35, 0x72, 0x5e, 0x80, 0x6d,
    0x38, 0xff, 0xd0, 0xbe, 0xb1, 0x2d, 0xcc, 0x78, 0xde, 0x46, 0xf2, 0x06, 0x44, 0x45, 0xf6, 0xe6
};
#endif

PyTypeObject *init_KProcessList_KProcessInfo(PyObject *enclosingClass)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX].type;

    Shiboken::AutoDecRef Sbk_KProcessList_KProcessInfo_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KProcessList_KProcessInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "KProcessInfo",
        "KProcessList::KProcessInfo",
        &Sbk_KProcessList_KProcessInfo_spec,
        &Shiboken::callCppDestructor< ::KProcessList::KProcessInfo >,
        Sbk_KProcessList_KProcessInfo_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = Sbk_KProcessList_KProcessInfo_TypeF(); // references _Sbk_KProcessList_KProcessInfo_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KProcessList_KProcessInfo_SignatureStrings);
#else
    InitSignatureBytes(pyType, KProcessList_KProcessInfo_SignatureBytes, KProcessList_KProcessInfo_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KProcessList_KProcessInfo_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KProcessList_KProcessInfo_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KProcessInfo_PythonToCpp_KProcessInfo_PTR,
        is_KProcessInfo_PythonToCpp_KProcessInfo_PTR_Convertible,
        KProcessInfo_PTR_CppToPython_KProcessInfo,
        KProcessInfo_COPY_CppToPython_KProcessInfo);

    Shiboken::Conversions::registerConverterName(converter, "KProcessList::KProcessInfo");
    Shiboken::Conversions::registerConverterName(converter, "KProcessList::KProcessInfo*");
    Shiboken::Conversions::registerConverterName(converter, "KProcessList::KProcessInfo&");
    Shiboken::Conversions::registerConverterAlias(converter, "KProcessInfo");
    Shiboken::Conversions::registerConverterAlias(converter, "KProcessInfo*");
    Shiboken::Conversions::registerConverterAlias(converter, "KProcessInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KProcessList::KProcessInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KProcessInfo_PythonToCpp_KProcessInfo_COPY,
        is_KProcessInfo_PythonToCpp_KProcessInfo_COPY_Convertible);

    qRegisterMetaType< ::KProcessList::KProcessInfo >("KProcessInfo");
    qRegisterMetaType< ::KProcessList::KProcessInfo >("KProcessList::KProcessInfo");

    return pyType;
}
