
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kprocess_wrapper.h"

// Wrappers providing overrides
#include "ksignalhandler_wrapper.h"
#include "kprocess_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <kprocess.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KProcess_Type = nullptr;
static PyTypeObject *Sbk_KProcess_TypeF(void)
{
    return _Sbk_KProcess_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KProcessWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KProcessWrapper::KProcessWrapper(::QObject * parent) : KProcess(parent)
{
}

bool KProcessWrapper::atEnd() const
{
    static const char *funcName = "atEnd";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::atEnd();
    }
    return sbk_o_atEnd("KProcess", funcName, gil, pyOverride);
}

bool KProcessWrapper::sbk_o_atEnd(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 KProcessWrapper::bytesAvailable() const
{
    static const char *funcName = "bytesAvailable";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::bytesAvailable();
    }
    return sbk_o_bytesAvailable("KProcess", funcName, gil, pyOverride);
}

qint64 KProcessWrapper::sbk_o_bytesAvailable(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 KProcessWrapper::bytesToWrite() const
{
    static const char *funcName = "bytesToWrite";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QProcess::bytesToWrite();
    }
    return KProcessWrapper::sbk_o_bytesAvailable("KProcess", funcName, gil, pyOverride);
}

bool KProcessWrapper::canReadLine() const
{
    static const char *funcName = "canReadLine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::canReadLine();
    }
    return KProcessWrapper::sbk_o_atEnd("KProcess", funcName, gil, pyOverride);
}

void KProcessWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KProcess", funcName, gil, pyOverride, event);
}

void KProcessWrapper::close()
{
    static const char *funcName = "close";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QProcess::close();
    }
    sbk_o_close("KProcess", funcName, gil, pyOverride);
}

void KProcessWrapper::sbk_o_close(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KProcessWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KProcess", funcName, gil, pyOverride, signal);
}

void KProcessWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KProcess", funcName, gil, pyOverride, event);
}

void KProcessWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KProcess", funcName, gil, pyOverride, signal);
}

bool KProcessWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KProcess", funcName, gil, pyOverride, event);
}

bool KProcessWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KProcess", funcName, gil, pyOverride, watched, event);
}

bool KProcessWrapper::isSequential() const
{
    static const char *funcName = "isSequential";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QProcess::isSequential();
    }
    return KProcessWrapper::sbk_o_atEnd("KProcess", funcName, gil, pyOverride);
}

bool KProcessWrapper::open(::QFlags<QIODeviceBase::OpenModeFlag> mode)
{
    static const char *funcName = "open";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QProcess::open(mode);
    }
    return sbk_o_open("KProcess", funcName, gil, pyOverride, mode);
}

bool KProcessWrapper::sbk_o_open(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QFlags<QIODeviceBase::OpenModeFlag> mode)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, &mode)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, &mode)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 KProcessWrapper::pos() const
{
    static const char *funcName = "pos";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::pos();
    }
    return KProcessWrapper::sbk_o_bytesAvailable("KProcess", funcName, gil, pyOverride);
}

qint64 KProcessWrapper::readData(char * data, qint64 maxlen)
{
    static const char *funcName = "readData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QProcess::readData(data, maxlen);
    }
    return sbk_o_readData("KProcess", funcName, gil, pyOverride, data, maxlen);
}

qint64 KProcessWrapper::sbk_o_readData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, char * data, qint64 maxlen)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
        maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult.object())) {
        cppResult = PyBytes_Size(pyResult.object());
        memcpy(data, PyBytes_AsString(pyResult.object()), cppResult);
    } else if (Shiboken::String::check(pyResult.object())) {
        cppResult = Shiboken::String::len(pyResult.object());
        memcpy(data, Shiboken::String::toCString(pyResult.object()), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================
    // End of code injection

    return cppResult;
}

qint64 KProcessWrapper::readLineData(char * data, qint64 maxlen)
{
    static const char *funcName = "readLineData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::readLineData(data, maxlen);
    }
    return sbk_o_readLineData("KProcess", funcName, gil, pyOverride, data, maxlen);
}

qint64 KProcessWrapper::sbk_o_readLineData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, char * data, qint64 maxlen)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
        maxlen
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }

    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    qint64 cppResult = 0;
    if (PyBytes_Check(pyResult.object())) {
        cppResult = PyBytes_Size(pyResult.object());
        memcpy(data, PyBytes_AsString(pyResult.object()), cppResult);
    } else if (Shiboken::String::check(pyResult.object())) {
        cppResult = Shiboken::String::len(pyResult.object());
        memcpy(data, Shiboken::String::toCString(pyResult.object()), cppResult);
    }
    // END of custom code block [file: ../glue/qtcore.cpp (return-readData)]
    // ========================================================================
    // End of code injection

    return cppResult;
}

bool KProcessWrapper::reset()
{
    static const char *funcName = "reset";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::reset();
    }
    return KProcessWrapper::sbk_o_atEnd("KProcess", funcName, gil, pyOverride);
}

bool KProcessWrapper::seek(qint64 pos)
{
    static const char *funcName = "seek";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::seek(pos);
    }
    return sbk_o_seek("KProcess", funcName, gil, pyOverride, pos);
}

bool KProcessWrapper::sbk_o_seek(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, qint64 pos)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &pos)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
        pos
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 KProcessWrapper::size() const
{
    static const char *funcName = "size";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::size();
    }
    return KProcessWrapper::sbk_o_bytesAvailable("KProcess", funcName, gil, pyOverride);
}

qint64 KProcessWrapper::skipData(qint64 maxSize)
{
    static const char *funcName = "skipData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QIODevice::skipData(maxSize);
    }
    return sbk_o_skipData("KProcess", funcName, gil, pyOverride, maxSize);
}

qint64 KProcessWrapper::sbk_o_skipData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, qint64 maxSize)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &maxSize)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(L)",
        maxSize
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KProcessWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KProcess", funcName, gil, pyOverride, event);
}

bool KProcessWrapper::waitForBytesWritten(int msecs)
{
    static const char *funcName = "waitForBytesWritten";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QProcess::waitForBytesWritten(msecs);
    }
    return sbk_o_waitForBytesWritten("KProcess", funcName, gil, pyOverride, msecs);
}

bool KProcessWrapper::sbk_o_waitForBytesWritten(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int msecs)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &msecs)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
        msecs
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KProcessWrapper::waitForReadyRead(int msecs)
{
    static const char *funcName = "waitForReadyRead";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QProcess::waitForReadyRead(msecs);
    }
    return sbk_o_waitForReadyRead("KProcess", funcName, gil, pyOverride, msecs);
}

bool KProcessWrapper::sbk_o_waitForReadyRead(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, int msecs)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &msecs)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
        msecs
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

qint64 KProcessWrapper::writeData(const char * data, qint64 len)
{
    static const char *funcName = "writeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KProcess_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QProcess::writeData(data, len);
    }
    return sbk_o_writeData("KProcess", funcName, gil, pyOverride, data, len);
}

qint64 KProcessWrapper::sbk_o_writeData(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const char * data, qint64 len)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &len)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NL)",
        Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), data),
        len
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return 0;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "qint64", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    qint64 cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *KProcessWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KProcess::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KProcessWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KProcess::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KProcessWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KProcessWrapper *>(this));
    }
    return KProcess::qt_metacast(_clname);
}

KProcessWrapper::~KProcessWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KProcess_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KProcess_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KProcess >()))
        return -1;

    KProcessWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KProcess", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KProcess::KProcess(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KProcess(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KProcess(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KProcess(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KProcessWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KProcessWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KProcess >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KProcessFunc_clearEnvironment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearEnvironment()
        cppSelf->clearEnvironment();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KProcessFunc_clearProgram(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearProgram()
        cppSelf->clearProgram();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KProcessFunc_execute(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    ::KProcess *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "execute", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:execute", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KProcess::execute(QString,const QStringList&=,int=)->int
    // 1: static KProcess::execute(QStringList,int=)->int
    // 2: KProcess::execute(int=)->int
    if (numArgs == 0) {
        overloadId = 2; // execute(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // execute(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // execute(QStringList,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // execute(QStringList,int)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // execute(QString,QStringList,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // execute(QString,QStringList,int)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
                overloadId = 0; // execute(QString,QStringList,int)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "execute", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // execute(const QString &exe, const QStringList &args, int msecs)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"args", 1}, {"msecs", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "execute", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1 = QStringList();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = -1;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // execute(QString,QStringList,int)
                int cppResult = ::KProcess::execute(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // execute(const QStringList &argv, int msecs)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"msecs", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "execute", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
                }
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = -1;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // execute(QStringList,int)
                int cppResult = ::KProcess::execute(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // execute(int msecs)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"msecs", 0}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "execute", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
                }
            }
            int cppArg0 = -1;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // execute(int)
                int cppResult = cppSelf->execute(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessFunc_outputChannelMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // outputChannelMode()const
        KProcess::OutputChannelMode cppResult = const_cast<const ::KProcess *>(cppSelf)->outputChannelMode();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_OutputChannelMode_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessFunc_program(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // program()const
        QStringList cppResult = const_cast<const ::KProcess *>(cppSelf)->program();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessFunc_setEnv(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setEnv", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:setEnv", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KProcess::setEnv(QString,QString,bool=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setEnv(QString,QString,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // setEnv(QString,QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setEnv", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"overwrite", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setEnv", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = true;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEnv(QString,QString,bool)
            cppSelf->setEnv(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KProcessFunc_setNextOpenMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KProcess::setNextOpenMode(QFlags<QIODeviceBase::OpenModeFlag>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_QIODeviceBase_OpenModeFlag_IDX])))->flagsConverter, (pyArg)))) {
        overloadId = 0; // setNextOpenMode(QFlags<QIODeviceBase::OpenModeFlag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setNextOpenMode", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    // Call function/method
    {
        ::QFlags<QIODeviceBase::OpenModeFlag> cppArg0 = QFlags<QIODeviceBase::OpenModeFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setNextOpenMode(QFlags<QIODeviceBase::OpenModeFlag>)
            cppSelf->setNextOpenMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KProcessFunc_setOutputChannelMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KProcess::setOutputChannelMode(KProcess::OutputChannelMode)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_OutputChannelMode_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setOutputChannelMode(KProcess::OutputChannelMode)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOutputChannelMode", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    // Call function/method
    {
        ::KProcess::OutputChannelMode cppArg0{KProcess::SeparateChannels};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOutputChannelMode(KProcess::OutputChannelMode)
            cppSelf->setOutputChannelMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KProcessFunc_setProgram(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setProgram", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setProgram", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KProcess::setProgram(QString,const QStringList&=)
    // 1: KProcess::setProgram(QStringList)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[0])))) {
        overloadId = 1; // setProgram(QStringList)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setProgram(QString,QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))) {
            overloadId = 0; // setProgram(QString,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setProgram", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setProgram(const QString &exe, const QStringList &args)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"args", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "setProgram", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1 = QStringList();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setProgram(QString,QStringList)
                cppSelf->setProgram(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setProgram(const QStringList &argv)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setProgram", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setProgram(QStringList)
                cppSelf->setProgram(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KProcessFunc_setShellCommand(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KProcess::setShellCommand(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setShellCommand(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShellCommand", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShellCommand(QString)
            cppSelf->setShellCommand(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KProcessFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // start()
        cppSelf->start();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KProcessFunc_startDetached(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    ::KProcess *cppSelf = nullptr;
    SBK_UNUSED(cppSelf)
    if (self)
        cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "startDetached", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    if (PyArg_ParseTuple(args, "|OO:startDetached", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KProcess::startDetached()->int
    // 1: static KProcess::startDetached(QString,const QStringList&=)->int
    // 2: static KProcess::startDetached(QStringList)->int
    if (numArgs == 0) {
        overloadId = 0; // startDetached()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[0])))) {
        overloadId = 2; // startDetached(QStringList)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // startDetached(QString,QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1])))) {
            overloadId = 1; // startDetached(QString,QStringList)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "startDetached", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // startDetached()
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "startDetached", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
            }

            // startDetached()
            int cppResult = cppSelf->startDetached();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            break;
        }
        case 1: // startDetached(const QString &exe, const QStringList &args)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"args", 1}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "startDetached", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QStringList cppArg1 = QStringList();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // startDetached(QString,QStringList)
                int cppResult = ::KProcess::startDetached(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 2: // startDetached(const QStringList &argv)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "startDetached", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);
            }
            ::QStringList cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // startDetached(QStringList)
                int cppResult = ::KProcess::startDetached(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KProcessFunc_unsetEnv(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KProcess::unsetEnv(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // unsetEnv(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unsetEnv", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unsetEnv(QString)
            cppSelf->unsetEnv(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyMethodDef Sbk_KProcessMethod_execute = {"execute", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_execute), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr};

static PyMethodDef Sbk_KProcessMethod_startDetached = {"startDetached", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_startDetached), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr};


static const char *Sbk_KProcess_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KProcess_EnumFlagInfo[] = {
    "OutputChannelMode:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KProcess_methods[] = {
    {"clearEnvironment", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_clearEnvironment), METH_NOARGS, nullptr},
    {"clearProgram", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_clearProgram), METH_NOARGS, nullptr},
    {"execute", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_execute), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"outputChannelMode", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_outputChannelMode), METH_NOARGS, nullptr},
    {"program", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_program), METH_NOARGS, nullptr},
    {"setEnv", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_setEnv), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setNextOpenMode", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_setNextOpenMode), METH_O, nullptr},
    {"setOutputChannelMode", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_setOutputChannelMode), METH_O, nullptr},
    {"setProgram", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_setProgram), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setShellCommand", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_setShellCommand), METH_O, nullptr},
    {"start", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_start), METH_NOARGS, nullptr},
    {"startDetached", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_startDetached), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"unsetEnv", reinterpret_cast<PyCFunction>(Sbk_KProcessFunc_unsetEnv), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_KProcess_getattro(PyObject *self, PyObject *name)
{
    PySide::Feature::Select(self);
    // Search the method in the instance dict
    auto *ob_dict = SbkObject_GetDict_NoRef(self);
    if (auto *meth = PyDict_GetItem(ob_dict, name)) {
        Py_INCREF(meth);
        return meth;
    }
    // Search the method in the type dict
    if (Shiboken::Object::isUserType(self)) {
        Shiboken::AutoDecRef tmp(_Pep_PrivateMangle(self, name));
        Shiboken::AutoDecRef tpDict(PepType_GetDict(Py_TYPE(self)));
        if (auto *meth = PyDict_GetItem(tpDict.object(), tmp)) {
            if (std::strcmp(Py_TYPE(meth)->tp_name, "compiled_function") == 0) {
                auto descrGetFunc = reinterpret_cast<descrgetfunc>(PepType_GetSlot(Py_TYPE(meth), Py_tp_descr_get));
                ;
                return descrGetFunc(meth, self, nullptr);
            }
            return PyFunction_Check(meth) ? PyMethod_New(meth, self)
                                          : PySide::getHiddenDataFromQObject(reinterpret_cast< ::QObject *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), reinterpret_cast<SbkObject *>(self))), self, name);
        }
    }
    static PyMethodDef non_static_Sbk_KProcessMethod_execute = {
        Sbk_KProcessMethod_execute.ml_name,
        Sbk_KProcessMethod_execute.ml_meth,
        Sbk_KProcessMethod_execute.ml_flags & (~METH_STATIC),
        Sbk_KProcessMethod_execute.ml_doc,
    };
    if (Shiboken::String::compare(name, "execute") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_KProcessMethod_execute, self, 0);
    static PyMethodDef non_static_Sbk_KProcessMethod_startDetached = {
        Sbk_KProcessMethod_startDetached.ml_name,
        Sbk_KProcessMethod_startDetached.ml_meth,
        Sbk_KProcessMethod_startDetached.ml_flags & (~METH_STATIC),
        Sbk_KProcessMethod_startDetached.ml_doc,
    };
    if (Shiboken::String::compare(name, "startDetached") == 0)
        return PyCFunction_NewEx(&non_static_Sbk_KProcessMethod_startDetached, self, 0);
    return PySide::getHiddenDataFromQObject(reinterpret_cast< ::QObject *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), reinterpret_cast<SbkObject *>(self))), self, name);
}

static int Sbk_KProcess_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KProcessWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_KProcessFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), pyArg)
                    && !SbkObject_TypeCheck(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KProcess *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    static PyObject *attrName = Shiboken::PyMagicName::rlshift();
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, "O", self);
            if (Shiboken::Errors::occurred() != nullptr && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (pyResult == nullptr) {
        // Overloaded function decisor
        // 0: KProcess::operator<<(QString)->KProcess&
        // 1: KProcess::operator<<(QStringList)->KProcess&
        if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
            overloadId = 1; // operator<<(QStringList)
        } else if (!isReverse
            && (pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
            overloadId = 0; // operator<<(QString)
        }

        if (isReverse && overloadId == -1) {
            Shiboken::Errors::setReverseOperatorNotImplemented();
            return {};
        }

        // Function signature not found.
        if (overloadId == -1)
            return Shiboken::returnWrongArguments(pyArg, "operator<<", errInfo, SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]);

        // Call function/method
        switch (overloadId) {
            case 0: // operator<<(const QString &arg)
            {
                ::QString cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (Shiboken::Errors::occurred() == nullptr) {
                    // operator<<(QString)
                    KProcess & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), &cppResult);
                }
                break;
            }
            case 1: // operator<<(const QStringList &args)
            {
                ::QStringList cppArg0;
                pythonToCpp(pyArg, &cppArg0);

                if (Shiboken::Errors::occurred() == nullptr) {
                    // operator<<(QStringList)
                    KProcess & cppResult = (*cppSelf) << cppArg0;
                    pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX]), &cppResult);
                }
                break;
            }
        }

    } // End of "if (!pyResult)"

    return Sbk_ReturnFromPython_Result(pyResult);
}

} // extern "C"

static int Sbk_KProcess_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KProcess_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_KProcessSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::KProcess *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QProcess_IDX]))
        return static_cast< ::QProcess *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODevice_IDX]))
        return static_cast< ::QIODevice *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODeviceBase_IDX]))
        return static_cast< ::QIODeviceBase *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KProcess_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_getattro,    reinterpret_cast<void *>(Sbk_KProcess_getattro)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KProcess_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KProcess_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KProcess_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KProcess_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KProcess_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    // type supports number protocol
    {Py_nb_lshift,      reinterpret_cast<void *>(Sbk_KProcessFunc___lshift__)},
    {0, nullptr}
};
static PyType_Spec Sbk_KProcess_spec = {
    "1:KCoreAddons.KProcess",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KProcess_slots
};

} //extern "C"

static void *Sbk_KProcess_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KProcess *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KProcess_OutputChannelMode(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KProcess::OutputChannelMode>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KProcess::OutputChannelMode *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KProcess_OutputChannelMode_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KProcess_OutputChannelMode_IDX])))
        return Enum_PythonToCpp_KProcess_OutputChannelMode;
    return {};
}

static PyObject *KProcess_OutputChannelMode_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KProcess::OutputChannelMode>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KProcess::OutputChannelMode *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KProcess_PythonToCpp_KProcess_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KProcess_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KProcess_PythonToCpp_KProcess_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KProcess_TypeF()))
        return KProcess_PythonToCpp_KProcess_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KProcess_PTR_CppToPython_KProcess(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KProcess *>(const_cast<void *>(cppIn)), Sbk_KProcess_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KProcess_SignatureStrings[] = {
    "KCoreAddons.KProcess(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KCoreAddons.KProcess.clearEnvironment(self)",
    "KCoreAddons.KProcess.clearProgram(self)",
    "2:KCoreAddons.KProcess.execute(exe:QString,args:QStringList=QStringList(),msecs:int=-1)->int",
    "1:KCoreAddons.KProcess.execute(argv:QStringList,msecs:int=-1)->int",
    "0:KCoreAddons.KProcess.execute(self,msecs:int=-1)->int",
    "KCoreAddons.KProcess.outputChannelMode(self)->KCoreAddons.KProcess.OutputChannelMode",
    "KCoreAddons.KProcess.program(self)->QStringList",
    "KCoreAddons.KProcess.setEnv(self,name:QString,value:QString,overwrite:bool=true)",
    "KCoreAddons.KProcess.setNextOpenMode(self,mode:PySide6.QtCore.QIODeviceBase.OpenModeFlag)",
    "KCoreAddons.KProcess.setOutputChannelMode(self,mode:KCoreAddons.KProcess.OutputChannelMode)",
    "1:KCoreAddons.KProcess.setProgram(self,exe:QString,args:QStringList=QStringList())",
    "0:KCoreAddons.KProcess.setProgram(self,argv:QStringList)",
    "KCoreAddons.KProcess.setShellCommand(self,cmd:QString)",
    "KCoreAddons.KProcess.start(self)",
    "2:KCoreAddons.KProcess.startDetached(self)->int",
    "1:KCoreAddons.KProcess.startDetached(exe:QString,args:QStringList=QStringList())->int",
    "0:KCoreAddons.KProcess.startDetached(argv:QStringList)->int",
    "KCoreAddons.KProcess.unsetEnv(self,name:QString)",
    "1:KCoreAddons.KProcess.__lshift__(self,arg:QString)->KCoreAddons.KProcess",
    "0:KCoreAddons.KProcess.__lshift__(self,args:QStringList)->KCoreAddons.KProcess",
    nullptr}; // Sentinel
#else
static constexpr size_t KProcess_SignatureByteSize = 372;
static constexpr uint8_t KProcess_SignatureBytes[372] = {
    0x78, 0xda, 0x95, 0x93, 0x5f, 0x6b, 0xc2, 0x30, 0x14, 0xc5, 0xdf, 0xfd, 0x24, 0x16, 0x6a, 0x99,
    0x7b, 0xd8, 0x43, 0xa1, 0xc2, 0xa6, 0x1b, 0x0c, 0xb7, 0x55, 0xf1, 0x03, 0x48, 0x4c, 0xaf, 0x6d,
    0x46, 0xfe, 0x94, 0xe4, 0xb6, 0x73, 0xdf, 0x7e, 0x99, 0x5d, 0xb5, 0xd6, 0xa4, 0xb8, 0xa7, 0x24,
    0x70, 0xce, 0x8f, 0xe4, 0xe4, 0xdc, 0xe5, 0x5c, 0x69, 0x78, 0xcc, 0x32, 0x25, 0x4d, 0xb4, 0x5c,
    0x69, 0x45, 0xc1, 0x98, 0xb1, 0x01, 0xbe, 0x0f, 0x4b, 0xa2, 0x41, 0x62, 0xbc, 0xfa, 0xde, 0xb0,
    0x0c, 0x1e, 0xa2, 0x35, 0xfe, 0x2a, 0xa3, 0x75, 0xba, 0xfb, 0x04, 0x8a, 0x89, 0xac, 0x38, 0x2f,
    0x51, 0x07, 0xa3, 0xa5, 0x03, 0x10, 0x51, 0x0e, 0x44, 0x3f, 0xcb, 0x9a, 0x69, 0x25, 0x85, 0xa5,
    0x1c, 0x89, 0x43, 0x5a, 0x7b, 0xc8, 0x35, 0x11, 0x7f, 0xba, 0xfb, 0xd8, 0xa9, 0x84, 0x03, 0xd0,
    0x0a, 0x61, 0x6c, 0xd7, 0x78, 0xbd, 0x41, 0xcd, 0x64, 0x1e, 0x12, 0x9d, 0x9b, 0xf6, 0xf0, 0xc6,
    0x0c, 0x26, 0x9d, 0xfd, 0x38, 0x08, 0x85, 0x01, 0x6a, 0x62, 0x26, 0x31, 0x99, 0x4c, 0x83, 0xc9,
    0xcc, 0x6e, 0x46, 0xd3, 0x61, 0xb8, 0x05, 0xd6, 0x5d, 0xa0, 0x0b, 0x71, 0x37, 0x8c, 0x38, 0xc6,
    0xe7, 0xb0, 0x39, 0x4d, 0xaa, 0xc2, 0xb2, 0xc2, 0x79, 0x41, 0xa4, 0x04, 0xfe, 0xae, 0xb2, 0xc6,
    0x6e, 0x1d, 0x4e, 0x75, 0xda, 0x57, 0xbb, 0xa1, 0x65, 0x37, 0xce, 0xc9, 0xac, 0xf3, 0x1c, 0xb7,
    0xde, 0x00, 0xda, 0xdf, 0x6a, 0x2e, 0x2e, 0x89, 0x38, 0xc7, 0x5b, 0x13, 0x5e, 0x9d, 0x4f, 0xaa,
    0x06, 0xfd, 0xa5, 0x19, 0x42, 0xbc, 0x53, 0x8a, 0x27, 0xa8, 0x2b, 0x08, 0xbc, 0xc0, 0x0f, 0x38,
    0x60, 0x5a, 0x82, 0x3c, 0xbd, 0x29, 0x14, 0x76, 0x77, 0xd5, 0xa7, 0xd7, 0x74, 0x01, 0x35, 0xa3,
    0xf0, 0x44, 0x0c, 0x44, 0xad, 0xfe, 0x85, 0x93, 0xdc, 0x4f, 0x4e, 0x9d, 0x91, 0x35, 0xf8, 0xdb,
    0x52, 0x0b, 0x7c, 0x2d, 0xb0, 0xf4, 0x6e, 0x15, 0xc3, 0xdb, 0xab, 0x16, 0xf8, 0x5a, 0xd1, 0x47,
    0xf6, 0x0b, 0xe6, 0x7f, 0xe7, 0xa6, 0x00, 0xce, 0xe7, 0x4a, 0x08, 0x22, 0xb3, 0xc6, 0x4b, 0x45,
    0xd6, 0x5a, 0x7d, 0x36, 0x24, 0x1a, 0x87, 0xc7, 0xe8, 0x28, 0x59, 0x00, 0x12, 0x5a, 0x40, 0xd6,
    0x56, 0x64, 0x60, 0x32, 0x2e, 0xf5, 0xff, 0x48, 0x64, 0x70, 0x58, 0x2e, 0xa9, 0x57, 0xa1, 0x0c,
    0x4c, 0x4c, 0x25, 0x7d, 0x75, 0xf5, 0x7e, 0xeb, 0x76, 0xcb, 0x4d, 0xc1, 0xf6, 0xb8, 0xdd, 0x9e,
    0xfe, 0xe0, 0xe4, 0x71, 0x4f, 0x9a, 0xef, 0xda, 0x0e, 0x92, 0xe9, 0x5d, 0xdc, 0x89, 0xfb, 0x01,
    0xa7, 0x19, 0xf6, 0xb3
};
#endif

PyTypeObject *init_KProcess(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX].type;

    Shiboken::AutoDecRef Sbk_KProcess_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QProcess_IDX]))));

    _Sbk_KProcess_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KProcess",
        "KProcess*",
        &Sbk_KProcess_spec,
        &Shiboken::callCppDestructor< KProcess >,
        Sbk_KProcess_Type_bases.object(),
        0);
    auto *pyType = Sbk_KProcess_TypeF(); // references _Sbk_KProcess_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KProcess_SignatureStrings);
#else
    InitSignatureBytes(pyType, KProcess_SignatureBytes, KProcess_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KProcess_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KProcess_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KProcess_PythonToCpp_KProcess_PTR,
        is_KProcess_PythonToCpp_KProcess_PTR_Convertible,
        KProcess_PTR_CppToPython_KProcess);

    Shiboken::Conversions::registerConverterName(converter, "KProcess");
    Shiboken::Conversions::registerConverterName(converter, "KProcess*");
    Shiboken::Conversions::registerConverterName(converter, "KProcess&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KProcess).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KProcessWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QIODevice_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_KProcess_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_KProcess_TypeF(), &Sbk_KProcessSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KProcess_TypeF(), &Sbk_KProcess_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KProcess_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'OutputChannelMode'.
    const char *OutputChannelMode_Initializer[] = {
        "SeparateChannels",
        "MergedChannels",
        "ForwardedChannels",
        "OnlyStdoutChannel",
        "OnlyStderrChannel",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t OutputChannelMode_InitializerValues[] = {
        uint8_t(KProcess::OutputChannelMode::SeparateChannels),  //  0x00  0
        uint8_t(KProcess::OutputChannelMode::MergedChannels),    //  0x01  1
        uint8_t(KProcess::OutputChannelMode::ForwardedChannels), //  0x02  2
        uint8_t(KProcess::OutputChannelMode::OnlyStdoutChannel), //  0x04  4
        uint8_t(KProcess::OutputChannelMode::OnlyStderrChannel)  //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KProcess_TypeF(),
        "1:KCoreAddons.KProcess.OutputChannelMode",
        OutputChannelMode_Initializer, OutputChannelMode_InitializerValues);
    SbkKCoreAddonsTypeStructs[SBK_KProcess_OutputChannelMode_IDX].type = EType;
    // Register converter for enum 'KProcess::OutputChannelMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KProcess_OutputChannelMode_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KProcess_OutputChannelMode,
            is_Enum_PythonToCpp_KProcess_OutputChannelMode_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KProcess::OutputChannelMode");
        Shiboken::Conversions::registerConverterAlias(converter, "OutputChannelMode");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'OutputChannelMode' enum.

    qRegisterMetaType< ::KProcess::OutputChannelMode >("KProcess::OutputChannelMode");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KProcess::staticMetaObject, sizeof(KProcessWrapper));

    return pyType;
}
