#ifndef SBK_KMACROEXPANDERBASEWRAPPER_H
#define SBK_KMACROEXPANDERBASEWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kmacroexpander.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

class KMacroExpanderBaseWrapper : public KMacroExpanderBase
{
public:
    KMacroExpanderBaseWrapper(::QChar c = QLatin1Char('%'));
    KMacroExpanderBaseWrapper(const KMacroExpanderBaseWrapper &) = delete;
    KMacroExpanderBaseWrapper& operator=(const KMacroExpanderBaseWrapper &) = delete;
    KMacroExpanderBaseWrapper(KMacroExpanderBaseWrapper &&) = delete;
    KMacroExpanderBaseWrapper& operator=(KMacroExpanderBaseWrapper &&) = delete;
    ~KMacroExpanderBaseWrapper() override;

    int expandEscapedMacro(const ::QString & str, int pos, ::QStringList & ret) override;
    static int sbk_o_expandEscapedMacro(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QString & str, int pos, ::QStringList & ret);
    int expandPlainMacro(const ::QString & str, int pos, ::QStringList & ret) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 2> m_PyMethodCache = {nullptr, nullptr};
};

#endif // SBK_KMACROEXPANDERBASEWRAPPER_H
