#ifndef SBK_KJOBUIDELEGATEWRAPPER_H
#define SBK_KJOBUIDELEGATEWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kjobuidelegate.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KJobUiDelegateWrapper : public KJobUiDelegate
{
public:
    KJobUiDelegateWrapper(::QFlags<KJobUiDelegate::Flag> flags = {KJobUiDelegate::AutoHandlingDisabled});
    KJobUiDelegateWrapper(const KJobUiDelegateWrapper &) = delete;
    KJobUiDelegateWrapper& operator=(const KJobUiDelegateWrapper &) = delete;
    KJobUiDelegateWrapper(KJobUiDelegateWrapper &&) = delete;
    KJobUiDelegateWrapper& operator=(KJobUiDelegateWrapper &&) = delete;
    ~KJobUiDelegateWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool setJob(::KJob * job) override;
    static bool sbk_o_setJob(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job);
    void showErrorMessage() override;
    static void sbk_o_showErrorMessage(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride);
    void slotWarning(::KJob * job, const ::QString & message) override;
    static void sbk_o_slotWarning(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, const ::QString & message);
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 10> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KJOBUIDELEGATEWRAPPER_H
