
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kcoreaddons_wrapper.h"

// Argument includes
#include <QString>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KCoreAddons_Type = nullptr;
static PyTypeObject *Sbk_KCoreAddons_TypeF(void)
{
    return _Sbk_KCoreAddons_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KCoreAddons_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KCoreAddons");
    return -1;
}

static PyObject *Sbk_KCoreAddonsFunc_version(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // version()
        unsigned int cppResult = ::KCoreAddons::version();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCoreAddonsFunc_versionString(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // versionString()
        QString cppResult = ::KCoreAddons::versionString();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KCoreAddons_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KCoreAddons_methods[] = {
    {"version", reinterpret_cast<PyCFunction>(Sbk_KCoreAddonsFunc_version), METH_NOARGS|METH_STATIC, nullptr},
    {"versionString", reinterpret_cast<PyCFunction>(Sbk_KCoreAddonsFunc_versionString), METH_NOARGS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KCoreAddons_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KCoreAddons_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KCoreAddons_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KCoreAddons_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KCoreAddons_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KCoreAddons_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KCoreAddons_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KCoreAddons_spec = {
    "1:KCoreAddons.KCoreAddons",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KCoreAddons_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKCoreAddons_SignatureStrings[] = {
    "KCoreAddons.KCoreAddons.version()->unsigned int",
    "KCoreAddons.KCoreAddons.versionString()->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKCoreAddons_SignatureByteSize = 62;
static constexpr uint8_t KCoreAddonsKCoreAddons_SignatureBytes[62] = {
    0x78, 0xda, 0xf3, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x46,
    0x62, 0x97, 0xa5, 0x16, 0x15, 0x67, 0xe6, 0xe7, 0x69, 0x68, 0xea, 0xda, 0x95, 0xe6, 0x15, 0x67,
    0xa6, 0xe7, 0xa5, 0xa6, 0x28, 0x64, 0xe6, 0x95, 0x70, 0x79, 0xe3, 0x57, 0x1f, 0x5c, 0x52, 0x94,
    0x99, 0x97, 0x0e, 0xd2, 0x15, 0x08, 0x61, 0x72, 0x01, 0x00, 0xc0, 0xdc, 0x23, 0x0c
};
#endif

PyTypeObject *init_KCoreAddonsKCoreAddons(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKCoreAddons_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKCoreAddons_IDX].type;

    Shiboken::AutoDecRef Sbk_KCoreAddons_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KCoreAddons_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KCoreAddons",
        "KCoreAddons",
        &Sbk_KCoreAddons_spec,
        nullptr,
        Sbk_KCoreAddons_Type_bases.object(),
        0);
    auto *pyType = Sbk_KCoreAddons_TypeF(); // references _Sbk_KCoreAddons_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKCoreAddons_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKCoreAddons_SignatureBytes, KCoreAddonsKCoreAddons_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KCoreAddons_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKCoreAddons_IDX].type = pyType;



    return pyType;
}
