/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// CSINodeSpecApplyConfiguration represents a declarative configuration of the CSINodeSpec type for use
// with apply.
//
// CSINodeSpec holds information about the specification of all CSI drivers installed on a node
type CSINodeSpecApplyConfiguration struct {
	// drivers is a list of information of all CSI Drivers existing on a node.
	// If all drivers in the list are uninstalled, this can become empty.
	Drivers []CSINodeDriverApplyConfiguration `json:"drivers,omitempty"`
}

// CSINodeSpecApplyConfiguration constructs a declarative configuration of the CSINodeSpec type for use with
// apply.
func CSINodeSpec() *CSINodeSpecApplyConfiguration {
	return &CSINodeSpecApplyConfiguration{}
}

// WithDrivers adds the given value to the Drivers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Drivers field.
func (b *CSINodeSpecApplyConfiguration) WithDrivers(values ...*CSINodeDriverApplyConfiguration) *CSINodeSpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithDrivers")
		}
		b.Drivers = append(b.Drivers, *values[i])
	}
	return b
}
