/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// DeviceAttributeApplyConfiguration represents a declarative configuration of the DeviceAttribute type for use
// with apply.
type DeviceAttributeApplyConfiguration struct {
	IntValue     *int64  `json:"int,omitempty"`
	BoolValue    *bool   `json:"bool,omitempty"`
	StringValue  *string `json:"string,omitempty"`
	VersionValue *string `json:"version,omitempty"`
}

// DeviceAttributeApplyConfiguration constructs a declarative configuration of the DeviceAttribute type for use with
// apply.
func DeviceAttribute() *DeviceAttributeApplyConfiguration {
	return &DeviceAttributeApplyConfiguration{}
}

// WithIntValue sets the IntValue field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the IntValue field is set to the value of the last call.
func (b *DeviceAttributeApplyConfiguration) WithIntValue(value int64) *DeviceAttributeApplyConfiguration {
	b.IntValue = &value
	return b
}

// WithBoolValue sets the BoolValue field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BoolValue field is set to the value of the last call.
func (b *DeviceAttributeApplyConfiguration) WithBoolValue(value bool) *DeviceAttributeApplyConfiguration {
	b.BoolValue = &value
	return b
}

// WithStringValue sets the StringValue field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the StringValue field is set to the value of the last call.
func (b *DeviceAttributeApplyConfiguration) WithStringValue(value string) *DeviceAttributeApplyConfiguration {
	b.StringValue = &value
	return b
}

// WithVersionValue sets the VersionValue field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the VersionValue field is set to the value of the last call.
func (b *DeviceAttributeApplyConfiguration) WithVersionValue(value string) *DeviceAttributeApplyConfiguration {
	b.VersionValue = &value
	return b
}
