// Copyright 2020 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: networking/v1alpha3/workload_group.proto

// $schema: istio.networking.v1alpha3.WorkloadGroup
// $title: Workload Group
// $description: Describes a collection of workload instances.
// $location: https://istio.io/docs/reference/config/networking/workload-group.html
// $aliases: [/docs/reference/config/networking/v1alpha3/workload-group]

// `WorkloadGroup` describes a collection of workload instances.
// It provides a specification that the workload instances can use to bootstrap
// their proxies, including the metadata and identity. It is only intended to
// be used with non-k8s workloads like Virtual Machines, and is meant to mimic
// the existing sidecar injection and deployment specification model used for
// Kubernetes workloads to bootstrap Istio proxies.
//
// The following example declares a workload group representing a collection
// of workloads that will be registered under `reviews` in namespace
// `bookinfo`. The set of labels will be associated with each workload
// instance during the bootstrap process, and the ports 3550 and 8080
// will be associated with the workload group and use service account `default`.
// `app.kubernetes.io/version` is just an arbitrary example of a label.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: WorkloadGroup
// metadata:
//   name: reviews
//   namespace: bookinfo
// spec:
//   metadata:
//     labels:
//       app.kubernetes.io/name: reviews
//       app.kubernetes.io/version: "1.3.4"
//   template:
//     ports:
//       grpc: 3550
//       http: 8080
//     serviceAccount: default
//   probe:
//     initialDelaySeconds: 5
//     timeoutSeconds: 3
//     periodSeconds: 4
//     successThreshold: 3
//     failureThreshold: 3
//     httpGet:
//      path: /foo/bar
//      host: 127.0.0.1
//      port: 3100
//      scheme: HTTPS
//      httpHeaders:
//      - name: Lit-Header
//        value: Im-The-Best
// ```
//

package v1alpha3

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `WorkloadGroup` enables specifying the properties of a single workload for bootstrap and
// provides a template for `WorkloadEntry`, similar to how `Deployment` specifies properties
// of workloads via `Pod` templates. A `WorkloadGroup` can have more than one `WorkloadEntry`.
// `WorkloadGroup` has no relationship to resources which control service registry like `ServiceEntry`
// and as such doesn't configure host name for these workloads.
//
// <!-- crd generation tags
// +cue-gen:WorkloadGroup:groupName:networking.istio.io
// +cue-gen:WorkloadGroup:versions:v1,v1beta1,v1alpha3
// +cue-gen:WorkloadGroup:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:WorkloadGroup:subresource:status
// +cue-gen:WorkloadGroup:scope:Namespaced
// +cue-gen:WorkloadGroup:resource:categories=istio-io,networking-istio-io,shortNames=wg,plural=workloadgroups
// +cue-gen:WorkloadGroup:printerColumn:name=Age,type=date,JSONPath=.metadata.creationTimestamp,description="CreationTimestamp is a timestamp
// representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations.
// Clients may not set this value. It is represented in RFC3339 form and is in UTC.
// Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata"
// +cue-gen:WorkloadGroup:preserveUnknownFields:false
// +cue-gen:WorkloadGroup:spec:required
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
type WorkloadGroup struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Metadata that will be used for all corresponding `WorkloadEntries`.
	// User labels for a workload group should be set here in `metadata` rather than in `template`.
	Metadata *WorkloadGroup_ObjectMeta `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Template to be used for the generation of `WorkloadEntry` resources that belong to this `WorkloadGroup`.
	// Please note that `address` and `labels` fields should not be set in the template, and an empty `serviceAccount`
	// should default to `default`. The workload identities (mTLS certificates) will be bootstrapped using the
	// specified service account's token. Workload entries in this group will be in the same namespace as the
	// workload group, and inherit the labels and annotations from the above `metadata` field.
	// +protoc-gen-crd:validation:IgnoreSubValidation:["Address is required"]
	Template *WorkloadEntry `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	// `ReadinessProbe` describes the configuration the user must provide for healthchecking on their workload.
	// This configuration mirrors K8S in both syntax and logic for the most part.
	Probe         *ReadinessProbe `protobuf:"bytes,3,opt,name=probe,proto3" json:"probe,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkloadGroup) Reset() {
	*x = WorkloadGroup{}
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadGroup) ProtoMessage() {}

func (x *WorkloadGroup) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadGroup.ProtoReflect.Descriptor instead.
func (*WorkloadGroup) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_group_proto_rawDescGZIP(), []int{0}
}

func (x *WorkloadGroup) GetMetadata() *WorkloadGroup_ObjectMeta {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *WorkloadGroup) GetTemplate() *WorkloadEntry {
	if x != nil {
		return x.Template
	}
	return nil
}

func (x *WorkloadGroup) GetProbe() *ReadinessProbe {
	if x != nil {
		return x.Probe
	}
	return nil
}

type ReadinessProbe struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Number of seconds after the container has started before readiness probes are initiated.
	// +kubebuilder:validation:Minimum=0
	InitialDelaySeconds int32 `protobuf:"varint,2,opt,name=initial_delay_seconds,json=initialDelaySeconds,proto3" json:"initial_delay_seconds,omitempty"`
	// Number of seconds after which the probe times out.
	// Defaults to 1 second. Minimum value is 1 second.
	// +kubebuilder:validation:Minimum=0
	TimeoutSeconds int32 `protobuf:"varint,3,opt,name=timeout_seconds,json=timeoutSeconds,proto3" json:"timeout_seconds,omitempty"`
	// How often (in seconds) to perform the probe.
	// Default to 10 seconds. Minimum value is 1 second.
	// +kubebuilder:validation:Minimum=0
	PeriodSeconds int32 `protobuf:"varint,4,opt,name=period_seconds,json=periodSeconds,proto3" json:"period_seconds,omitempty"`
	// Minimum consecutive successes for the probe to be considered successful after having failed.
	// Defaults to 1 second.
	// +kubebuilder:validation:Minimum=0
	SuccessThreshold int32 `protobuf:"varint,5,opt,name=success_threshold,json=successThreshold,proto3" json:"success_threshold,omitempty"`
	// Minimum consecutive failures for the probe to be considered failed after having succeeded.
	// Defaults to 3 seconds.
	// +kubebuilder:validation:Minimum=0
	FailureThreshold int32 `protobuf:"varint,6,opt,name=failure_threshold,json=failureThreshold,proto3" json:"failure_threshold,omitempty"`
	// Users can only provide one configuration for healthchecks (tcp, http, exec),
	// and this is expressed as a oneof. All of the other configuration values
	// hold true for any of the healthcheck methods.
	//
	// Types that are valid to be assigned to HealthCheckMethod:
	//
	//	*ReadinessProbe_HttpGet
	//	*ReadinessProbe_TcpSocket
	//	*ReadinessProbe_Exec
	//	*ReadinessProbe_Grpc
	HealthCheckMethod isReadinessProbe_HealthCheckMethod `protobuf_oneof:"health_check_method"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *ReadinessProbe) Reset() {
	*x = ReadinessProbe{}
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadinessProbe) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadinessProbe) ProtoMessage() {}

func (x *ReadinessProbe) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadinessProbe.ProtoReflect.Descriptor instead.
func (*ReadinessProbe) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_group_proto_rawDescGZIP(), []int{1}
}

func (x *ReadinessProbe) GetInitialDelaySeconds() int32 {
	if x != nil {
		return x.InitialDelaySeconds
	}
	return 0
}

func (x *ReadinessProbe) GetTimeoutSeconds() int32 {
	if x != nil {
		return x.TimeoutSeconds
	}
	return 0
}

func (x *ReadinessProbe) GetPeriodSeconds() int32 {
	if x != nil {
		return x.PeriodSeconds
	}
	return 0
}

func (x *ReadinessProbe) GetSuccessThreshold() int32 {
	if x != nil {
		return x.SuccessThreshold
	}
	return 0
}

func (x *ReadinessProbe) GetFailureThreshold() int32 {
	if x != nil {
		return x.FailureThreshold
	}
	return 0
}

func (x *ReadinessProbe) GetHealthCheckMethod() isReadinessProbe_HealthCheckMethod {
	if x != nil {
		return x.HealthCheckMethod
	}
	return nil
}

func (x *ReadinessProbe) GetHttpGet() *HTTPHealthCheckConfig {
	if x != nil {
		if x, ok := x.HealthCheckMethod.(*ReadinessProbe_HttpGet); ok {
			return x.HttpGet
		}
	}
	return nil
}

func (x *ReadinessProbe) GetTcpSocket() *TCPHealthCheckConfig {
	if x != nil {
		if x, ok := x.HealthCheckMethod.(*ReadinessProbe_TcpSocket); ok {
			return x.TcpSocket
		}
	}
	return nil
}

func (x *ReadinessProbe) GetExec() *ExecHealthCheckConfig {
	if x != nil {
		if x, ok := x.HealthCheckMethod.(*ReadinessProbe_Exec); ok {
			return x.Exec
		}
	}
	return nil
}

func (x *ReadinessProbe) GetGrpc() *GrpcHealthCheckConfig {
	if x != nil {
		if x, ok := x.HealthCheckMethod.(*ReadinessProbe_Grpc); ok {
			return x.Grpc
		}
	}
	return nil
}

type isReadinessProbe_HealthCheckMethod interface {
	isReadinessProbe_HealthCheckMethod()
}

type ReadinessProbe_HttpGet struct {
	// `httpGet` is performed to a given endpoint
	// and the status/able to connect determines health.
	HttpGet *HTTPHealthCheckConfig `protobuf:"bytes,7,opt,name=http_get,json=httpGet,proto3,oneof"`
}

type ReadinessProbe_TcpSocket struct {
	// Health is determined by if the proxy is able to connect.
	TcpSocket *TCPHealthCheckConfig `protobuf:"bytes,8,opt,name=tcp_socket,json=tcpSocket,proto3,oneof"`
}

type ReadinessProbe_Exec struct {
	// Health is determined by how the command that is executed exited.
	Exec *ExecHealthCheckConfig `protobuf:"bytes,9,opt,name=exec,proto3,oneof"`
}

type ReadinessProbe_Grpc struct {
	// GRPC call is made and response/error is used to determine health.
	Grpc *GrpcHealthCheckConfig `protobuf:"bytes,10,opt,name=grpc,proto3,oneof"`
}

func (*ReadinessProbe_HttpGet) isReadinessProbe_HealthCheckMethod() {}

func (*ReadinessProbe_TcpSocket) isReadinessProbe_HealthCheckMethod() {}

func (*ReadinessProbe_Exec) isReadinessProbe_HealthCheckMethod() {}

func (*ReadinessProbe_Grpc) isReadinessProbe_HealthCheckMethod() {}

type HTTPHealthCheckConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path to access on the HTTP server.
	Path string `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	// Port on which the endpoint lives.
	// +kubebuilder:validation:XValidation:message="port must be between 1-65535",rule="0 < self && self <= 65535"
	Port uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Host name to connect to, defaults to the pod IP. You probably want to set
	// "Host" in httpHeaders instead.
	Host string `protobuf:"bytes,3,opt,name=host,proto3" json:"host,omitempty"`
	// HTTP or HTTPS, defaults to HTTP
	// +kubebuilder:validation:XValidation:message="scheme must be one of [HTTP, HTTPS]",rule="self in [”, 'HTTP', 'HTTPS']"
	Scheme string `protobuf:"bytes,4,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// Headers the proxy will pass on to make the request.
	// Allows repeated headers.
	HttpHeaders   []*HTTPHeader `protobuf:"bytes,5,rep,name=http_headers,json=httpHeaders,proto3" json:"http_headers,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPHealthCheckConfig) Reset() {
	*x = HTTPHealthCheckConfig{}
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPHealthCheckConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHealthCheckConfig) ProtoMessage() {}

func (x *HTTPHealthCheckConfig) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHealthCheckConfig.ProtoReflect.Descriptor instead.
func (*HTTPHealthCheckConfig) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_group_proto_rawDescGZIP(), []int{2}
}

func (x *HTTPHealthCheckConfig) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *HTTPHealthCheckConfig) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *HTTPHealthCheckConfig) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *HTTPHealthCheckConfig) GetScheme() string {
	if x != nil {
		return x.Scheme
	}
	return ""
}

func (x *HTTPHealthCheckConfig) GetHttpHeaders() []*HTTPHeader {
	if x != nil {
		return x.HttpHeaders
	}
	return nil
}

type GrpcHealthCheckConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Port on which the endpoint lives.
	// +kubebuilder:validation:XValidation:message="port must be between 1-65535",rule="0 < self && self <= 65535"
	Port uint32 `protobuf:"varint,1,opt,name=port,proto3" json:"port,omitempty"`
	// Service is the fully qualified name of the service to send the grpc health check request
	Service       string `protobuf:"bytes,2,opt,name=service,proto3" json:"service,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GrpcHealthCheckConfig) Reset() {
	*x = GrpcHealthCheckConfig{}
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GrpcHealthCheckConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GrpcHealthCheckConfig) ProtoMessage() {}

func (x *GrpcHealthCheckConfig) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GrpcHealthCheckConfig.ProtoReflect.Descriptor instead.
func (*GrpcHealthCheckConfig) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_group_proto_rawDescGZIP(), []int{3}
}

func (x *GrpcHealthCheckConfig) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *GrpcHealthCheckConfig) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

type HTTPHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The header field name
	// +kubebuilder:validation:Pattern=^[-_A-Za-z0-9]+$
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The header field value
	Value         string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *HTTPHeader) Reset() {
	*x = HTTPHeader{}
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *HTTPHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HTTPHeader) ProtoMessage() {}

func (x *HTTPHeader) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HTTPHeader.ProtoReflect.Descriptor instead.
func (*HTTPHeader) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_group_proto_rawDescGZIP(), []int{4}
}

func (x *HTTPHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *HTTPHeader) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type TCPHealthCheckConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Host to connect to, defaults to localhost
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Port of host
	// +kubebuilder:validation:XValidation:message="port must be between 1-65535",rule="0 < self && self <= 65535"
	Port          uint32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TCPHealthCheckConfig) Reset() {
	*x = TCPHealthCheckConfig{}
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TCPHealthCheckConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TCPHealthCheckConfig) ProtoMessage() {}

func (x *TCPHealthCheckConfig) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TCPHealthCheckConfig.ProtoReflect.Descriptor instead.
func (*TCPHealthCheckConfig) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_group_proto_rawDescGZIP(), []int{5}
}

func (x *TCPHealthCheckConfig) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *TCPHealthCheckConfig) GetPort() uint32 {
	if x != nil {
		return x.Port
	}
	return 0
}

type ExecHealthCheckConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Command to run. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
	// +protoc-gen-crd:list-value-validation:MinLength=1
	Command       []string `protobuf:"bytes,1,rep,name=command,proto3" json:"command,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ExecHealthCheckConfig) Reset() {
	*x = ExecHealthCheckConfig{}
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecHealthCheckConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecHealthCheckConfig) ProtoMessage() {}

func (x *ExecHealthCheckConfig) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecHealthCheckConfig.ProtoReflect.Descriptor instead.
func (*ExecHealthCheckConfig) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_group_proto_rawDescGZIP(), []int{6}
}

func (x *ExecHealthCheckConfig) GetCommand() []string {
	if x != nil {
		return x.Command
	}
	return nil
}

// `ObjectMeta` describes metadata that will be attached to a `WorkloadEntry`.
// It is a subset of the supported Kubernetes metadata.
type WorkloadGroup_ObjectMeta struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Labels to attach
	// +kubebuilder:validation:MaxProperties=256
	Labels map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Annotations to attach
	// +kubebuilder:validation:MaxProperties=256
	Annotations   map[string]string `protobuf:"bytes,2,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkloadGroup_ObjectMeta) Reset() {
	*x = WorkloadGroup_ObjectMeta{}
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadGroup_ObjectMeta) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadGroup_ObjectMeta) ProtoMessage() {}

func (x *WorkloadGroup_ObjectMeta) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_workload_group_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadGroup_ObjectMeta.ProtoReflect.Descriptor instead.
func (*WorkloadGroup_ObjectMeta) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_workload_group_proto_rawDescGZIP(), []int{0, 0}
}

func (x *WorkloadGroup_ObjectMeta) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *WorkloadGroup_ObjectMeta) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

var File_networking_v1alpha3_workload_group_proto protoreflect.FileDescriptor

const file_networking_v1alpha3_workload_group_proto_rawDesc = "" +
	"\n" +
	"(networking/v1alpha3/workload_group.proto\x12\x19istio.networking.v1alpha3\x1a\x1fgoogle/api/field_behavior.proto\x1a(networking/v1alpha3/workload_entry.proto\"\xb8\x04\n" +
	"\rWorkloadGroup\x12O\n" +
	"\bmetadata\x18\x01 \x01(\v23.istio.networking.v1alpha3.WorkloadGroup.ObjectMetaR\bmetadata\x12J\n" +
	"\btemplate\x18\x02 \x01(\v2(.istio.networking.v1alpha3.WorkloadEntryB\x04\xe2A\x01\x02R\btemplate\x12?\n" +
	"\x05probe\x18\x03 \x01(\v2).istio.networking.v1alpha3.ReadinessProbeR\x05probe\x1a\xc8\x02\n" +
	"\n" +
	"ObjectMeta\x12W\n" +
	"\x06labels\x18\x01 \x03(\v2?.istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.LabelsEntryR\x06labels\x12f\n" +
	"\vannotations\x18\x02 \x03(\v2D.istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.AnnotationsEntryR\vannotations\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a>\n" +
	"\x10AnnotationsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xb6\x04\n" +
	"\x0eReadinessProbe\x122\n" +
	"\x15initial_delay_seconds\x18\x02 \x01(\x05R\x13initialDelaySeconds\x12'\n" +
	"\x0ftimeout_seconds\x18\x03 \x01(\x05R\x0etimeoutSeconds\x12%\n" +
	"\x0eperiod_seconds\x18\x04 \x01(\x05R\rperiodSeconds\x12+\n" +
	"\x11success_threshold\x18\x05 \x01(\x05R\x10successThreshold\x12+\n" +
	"\x11failure_threshold\x18\x06 \x01(\x05R\x10failureThreshold\x12M\n" +
	"\bhttp_get\x18\a \x01(\v20.istio.networking.v1alpha3.HTTPHealthCheckConfigH\x00R\ahttpGet\x12P\n" +
	"\n" +
	"tcp_socket\x18\b \x01(\v2/.istio.networking.v1alpha3.TCPHealthCheckConfigH\x00R\ttcpSocket\x12F\n" +
	"\x04exec\x18\t \x01(\v20.istio.networking.v1alpha3.ExecHealthCheckConfigH\x00R\x04exec\x12F\n" +
	"\x04grpc\x18\n" +
	" \x01(\v20.istio.networking.v1alpha3.GrpcHealthCheckConfigH\x00R\x04grpcB\x15\n" +
	"\x13health_check_method\"\xbb\x01\n" +
	"\x15HTTPHealthCheckConfig\x12\x12\n" +
	"\x04path\x18\x01 \x01(\tR\x04path\x12\x18\n" +
	"\x04port\x18\x02 \x01(\rB\x04\xe2A\x01\x02R\x04port\x12\x12\n" +
	"\x04host\x18\x03 \x01(\tR\x04host\x12\x16\n" +
	"\x06scheme\x18\x04 \x01(\tR\x06scheme\x12H\n" +
	"\fhttp_headers\x18\x05 \x03(\v2%.istio.networking.v1alpha3.HTTPHeaderR\vhttpHeaders\"E\n" +
	"\x15GrpcHealthCheckConfig\x12\x12\n" +
	"\x04port\x18\x01 \x01(\rR\x04port\x12\x18\n" +
	"\aservice\x18\x02 \x01(\tR\aservice\"6\n" +
	"\n" +
	"HTTPHeader\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\"D\n" +
	"\x14TCPHealthCheckConfig\x12\x12\n" +
	"\x04host\x18\x01 \x01(\tR\x04host\x12\x18\n" +
	"\x04port\x18\x02 \x01(\rB\x04\xe2A\x01\x02R\x04port\"7\n" +
	"\x15ExecHealthCheckConfig\x12\x1e\n" +
	"\acommand\x18\x01 \x03(\tB\x04\xe2A\x01\x02R\acommandB\"Z istio.io/api/networking/v1alpha3b\x06proto3"

var (
	file_networking_v1alpha3_workload_group_proto_rawDescOnce sync.Once
	file_networking_v1alpha3_workload_group_proto_rawDescData []byte
)

func file_networking_v1alpha3_workload_group_proto_rawDescGZIP() []byte {
	file_networking_v1alpha3_workload_group_proto_rawDescOnce.Do(func() {
		file_networking_v1alpha3_workload_group_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_workload_group_proto_rawDesc), len(file_networking_v1alpha3_workload_group_proto_rawDesc)))
	})
	return file_networking_v1alpha3_workload_group_proto_rawDescData
}

var file_networking_v1alpha3_workload_group_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_networking_v1alpha3_workload_group_proto_goTypes = []any{
	(*WorkloadGroup)(nil),            // 0: istio.networking.v1alpha3.WorkloadGroup
	(*ReadinessProbe)(nil),           // 1: istio.networking.v1alpha3.ReadinessProbe
	(*HTTPHealthCheckConfig)(nil),    // 2: istio.networking.v1alpha3.HTTPHealthCheckConfig
	(*GrpcHealthCheckConfig)(nil),    // 3: istio.networking.v1alpha3.GrpcHealthCheckConfig
	(*HTTPHeader)(nil),               // 4: istio.networking.v1alpha3.HTTPHeader
	(*TCPHealthCheckConfig)(nil),     // 5: istio.networking.v1alpha3.TCPHealthCheckConfig
	(*ExecHealthCheckConfig)(nil),    // 6: istio.networking.v1alpha3.ExecHealthCheckConfig
	(*WorkloadGroup_ObjectMeta)(nil), // 7: istio.networking.v1alpha3.WorkloadGroup.ObjectMeta
	nil,                              // 8: istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.LabelsEntry
	nil,                              // 9: istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.AnnotationsEntry
	(*WorkloadEntry)(nil),            // 10: istio.networking.v1alpha3.WorkloadEntry
}
var file_networking_v1alpha3_workload_group_proto_depIdxs = []int32{
	7,  // 0: istio.networking.v1alpha3.WorkloadGroup.metadata:type_name -> istio.networking.v1alpha3.WorkloadGroup.ObjectMeta
	10, // 1: istio.networking.v1alpha3.WorkloadGroup.template:type_name -> istio.networking.v1alpha3.WorkloadEntry
	1,  // 2: istio.networking.v1alpha3.WorkloadGroup.probe:type_name -> istio.networking.v1alpha3.ReadinessProbe
	2,  // 3: istio.networking.v1alpha3.ReadinessProbe.http_get:type_name -> istio.networking.v1alpha3.HTTPHealthCheckConfig
	5,  // 4: istio.networking.v1alpha3.ReadinessProbe.tcp_socket:type_name -> istio.networking.v1alpha3.TCPHealthCheckConfig
	6,  // 5: istio.networking.v1alpha3.ReadinessProbe.exec:type_name -> istio.networking.v1alpha3.ExecHealthCheckConfig
	3,  // 6: istio.networking.v1alpha3.ReadinessProbe.grpc:type_name -> istio.networking.v1alpha3.GrpcHealthCheckConfig
	4,  // 7: istio.networking.v1alpha3.HTTPHealthCheckConfig.http_headers:type_name -> istio.networking.v1alpha3.HTTPHeader
	8,  // 8: istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.labels:type_name -> istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.LabelsEntry
	9,  // 9: istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.annotations:type_name -> istio.networking.v1alpha3.WorkloadGroup.ObjectMeta.AnnotationsEntry
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_networking_v1alpha3_workload_group_proto_init() }
func file_networking_v1alpha3_workload_group_proto_init() {
	if File_networking_v1alpha3_workload_group_proto != nil {
		return
	}
	file_networking_v1alpha3_workload_entry_proto_init()
	file_networking_v1alpha3_workload_group_proto_msgTypes[1].OneofWrappers = []any{
		(*ReadinessProbe_HttpGet)(nil),
		(*ReadinessProbe_TcpSocket)(nil),
		(*ReadinessProbe_Exec)(nil),
		(*ReadinessProbe_Grpc)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_workload_group_proto_rawDesc), len(file_networking_v1alpha3_workload_group_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_networking_v1alpha3_workload_group_proto_goTypes,
		DependencyIndexes: file_networking_v1alpha3_workload_group_proto_depIdxs,
		MessageInfos:      file_networking_v1alpha3_workload_group_proto_msgTypes,
	}.Build()
	File_networking_v1alpha3_workload_group_proto = out.File
	file_networking_v1alpha3_workload_group_proto_goTypes = nil
	file_networking_v1alpha3_workload_group_proto_depIdxs = nil
}
