// Copyright 2018 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        (unknown)
// source: networking/v1alpha3/sidecar.proto

// $schema: istio.networking.v1alpha3.Sidecar
// $title: Sidecar
// $description: Configuration affecting network reachability of a sidecar.
// $location: https://istio.io/docs/reference/config/networking/sidecar.html
// $aliases: [/docs/reference/config/networking/v1alpha3/sidecar]

// `Sidecar` describes the configuration of the sidecar proxy that mediates
// inbound and outbound communication to the workload instance it is attached to. By
// default, Istio will program all sidecar proxies in the mesh with the
// necessary configuration required to reach every workload instance in the mesh, as
// well as accept traffic on all the ports associated with the
// workload. The `Sidecar` configuration provides a way to fine tune the set of
// ports, protocols that the proxy will accept when forwarding traffic to
// and from the workload.
//
// One the common usages of `Sidecar` is to limit the set of configuration for outbound traffic.
// This configuration scoping, among [other options](/docs/ops/configuration/mesh/configuration-scoping/), is useful to prune
// out unneeded configuration, to improve scalability of the mesh.
// A common misunderstanding is that restricting the configuration amounts to *blocking* the traffic.
// If requests are sent to destinations not included in the scoping, the traffic will be treated as
// [unmatched traffic](/docs/ops/configuration/traffic-management/traffic-routing/#unmatched-traffic), which is often still allowed.
// The sidecar is not able to enforce an outbound traffic restriction (see [Egress Gateways](/docs/tasks/traffic-management/egress/egress-gateway/) for how to achieve this).
//
// Services and configuration in a mesh are organized into one or more
// namespaces (e.g., a Kubernetes namespace or a CF org/space). A `Sidecar`
// configuration in a namespace will apply to one or more workload instances in the same
// namespace, selected using the `workloadSelector` field. In the absence of a
// `workloadSelector`, it will apply to all workload instances in the same
// namespace. When determining the `Sidecar` configuration to be applied to a
// workload instance, preference will be given to the resource with a
// `workloadSelector` that selects this workload instance, over a `Sidecar` configuration
// without any `workloadSelector`.
//
// **NOTE 1**: *_Each namespace can have only one `Sidecar`
// configuration without any `workloadSelector`_ that specifies the
// default for all pods in that namespace*. It is recommended to use
// the name `default` for the namespace-wide sidecar. The behavior of
// the system is undefined if more than one selector-less `Sidecar`
// configurations exist in a given namespace. The behavior of the
// system is undefined if two or more `Sidecar` configurations with a
// `workloadSelector` select the same workload instance.
//
// **NOTE 2**: *_A `Sidecar` configuration in the `MeshConfig`
// [root namespace](https://istio.io/docs/reference/config/istio.mesh.v1alpha1/#MeshConfig)
// will be applied by default to all namespaces without a `Sidecar`
// configuration_*. This global default `Sidecar` configuration should not have
// any `workloadSelector`.
//
// **NOTE 3**: *_A `Sidecar` is not applicable to gateways, even though gateways are istio-proxies_*.
//
// The example below declares a global default `Sidecar` configuration
// in the root namespace called `istio-config`, that configures
// sidecars in all namespaces to configure egress traffic only to other
// workloads in the same namespace as well as to services in the
// `istio-system` namespace.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Sidecar
// metadata:
//   name: default
//   namespace: istio-config
// spec:
//   egress:
//   - hosts:
//     - "./*"
//     - "istio-system/*"
// ```
//
// The example below declares a `Sidecar` configuration in the
// `prod-us1` namespace that overrides the global default defined
// above, and configures the sidecars in the namespace to configure egress
// traffic to public services in the `prod-us1`, `prod-apis`, and the
// `istio-system` namespaces.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Sidecar
// metadata:
//   name: default
//   namespace: prod-us1
// spec:
//   egress:
//   - hosts:
//     - "prod-us1/*"
//     - "prod-apis/*"
//     - "istio-system/*"
// ```
//
// The following example declares a `Sidecar` configuration in the
// `prod-us1` namespace for all pods with labels `app: ratings`
// belonging to the `ratings.prod-us1` service.  The workload accepts
// inbound HTTP traffic on port 9080. The traffic is then forwarded to
// the attached workload instance listening on a Unix domain
// socket. In the egress direction, in addition to the `istio-system`
// namespace, the sidecar proxies only HTTP traffic bound for port
// 9080 for services in the `prod-us1` namespace.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Sidecar
// metadata:
//   name: ratings
//   namespace: prod-us1
// spec:
//   workloadSelector:
//     labels:
//       app: ratings
//   ingress:
//   - port:
//       number: 9080
//       protocol: HTTP
//       name: somename
//     defaultEndpoint: unix:///var/run/someuds.sock
//   egress:
//   - port:
//       number: 9080
//       protocol: HTTP
//       name: egresshttp
//     hosts:
//     - "prod-us1/*"
//   - hosts:
//     - "istio-system/*"
// ```
//
// If the workload is deployed without IPTables-based traffic capture,
// the `Sidecar` configuration is the only way to configure the ports
// on the proxy attached to the workload instance. The following
// example declares a `Sidecar` configuration in the `prod-us1`
// namespace for all pods with labels `app: productpage` belonging to
// the `productpage.prod-us1` service. Assuming that these pods are
// deployed without IPtable rules (i.e. the `istio-init` container)
// and the proxy metadata `ISTIO_META_INTERCEPTION_MODE` is set to
// `NONE`, the specification, below, allows such pods to receive HTTP
// traffic on port 9080 (wrapped inside Istio mutual TLS) and forward
// it to the application listening on `127.0.0.1:8080`. It also allows
// the application to communicate with a backing MySQL database on
// `127.0.0.1:3306`, that then gets proxied to the externally hosted
// MySQL service at `mysql.foo.com:3306`.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Sidecar
// metadata:
//   name: no-ip-tables
//   namespace: prod-us1
// spec:
//   workloadSelector:
//     labels:
//       app: productpage
//   ingress:
//   - port:
//       number: 9080 # binds to proxy_instance_ip:9080 (0.0.0.0:9080, if no unicast IP is available for the instance)
//       protocol: HTTP
//       name: somename
//     defaultEndpoint: 127.0.0.1:8080
//     captureMode: NONE # not needed if metadata is set for entire proxy
//   egress:
//   - port:
//       number: 3306
//       protocol: MYSQL
//       name: egressmysql
//     captureMode: NONE # not needed if metadata is set for entire proxy
//     bind: 127.0.0.1
//     hosts:
//     - "*/mysql.foo.com"
// ```
//
// And the associated service entry for routing to `mysql.foo.com:3306`
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: ServiceEntry
// metadata:
//   name: external-svc-mysql
//   namespace: ns1
// spec:
//   hosts:
//   - mysql.foo.com
//   ports:
//   - number: 3306
//     name: mysql
//     protocol: MYSQL
//   location: MESH_EXTERNAL
//   resolution: DNS
// ```
//
// It is also possible to mix and match traffic capture modes in a single
// proxy. For example, consider a setup where internal services are on the
// `192.168.0.0/16` subnet. So, IP tables are setup on the VM to capture all
// outbound traffic on `192.168.0.0/16` subnet. Assume that the VM has an
// additional network interface on `172.16.0.0/16` subnet for inbound
// traffic. The following `Sidecar` configuration allows the VM to expose a
// listener on `172.16.1.32:80` (the VM's IP) for traffic arriving from the
// `172.16.0.0/16` subnet.
//
// **NOTE**: The `ISTIO_META_INTERCEPTION_MODE` metadata on the
// proxy in the VM should contain `REDIRECT` or `TPROXY` as its value,
// implying that IP tables based traffic capture is active.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Sidecar
// metadata:
//   name: partial-ip-tables
//   namespace: prod-us1
// spec:
//   workloadSelector:
//     labels:
//       app: productpage
//   ingress:
//   - bind: 172.16.1.32
//     port:
//       number: 80 # binds to 172.16.1.32:80
//       protocol: HTTP
//       name: somename
//     defaultEndpoint: 127.0.0.1:8080
//     captureMode: NONE
//   egress:
//     # use the system detected defaults
//     # sets up configuration to handle outbound traffic to services
//     # in 192.168.0.0/16 subnet, based on information provided by the
//     # service registry
//   - captureMode: IPTABLES
//     hosts:
//     - "*/*"
// ```
//
// The following example declares a `Sidecar` configuration in the
// `prod-us1` namespace for all pods with labels `app: ratings`
// belonging to the `ratings.prod-us1` service.  The service accepts
// inbound HTTPS traffic on port 8443 and the sidecar proxy terminates
// one way TLS using the given server certificates.
// The traffic is then forwarded to the attached workload instance
// listening on a Unix domain socket.
// It is expected that PeerAuthentication policy would be configured
// in order to set mTLS mode to "DISABLE" on specific
// ports.
// In this example, the mTLS mode is disabled on PORT 80.
// This feature is currently experimental.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Sidecar
// metadata:
//   name: ratings
//   namespace: prod-us1
// spec:
//   workloadSelector:
//     labels:
//       app: ratings
//   ingress:
//   - port:
//       number: 80
//       protocol: HTTPS
//       name: somename
//     defaultEndpoint: unix:///var/run/someuds.sock
//     tls:
//       mode: SIMPLE
//       privateKey: "/etc/certs/privatekey.pem"
//       serverCertificate: "/etc/certs/servercert.pem"
// ---
// apiVersion: v1
// kind: Service
// metadata:
//   name: ratings
//   labels:
//     app: ratings
//     service: ratings
// spec:
//   ports:
//   - port: 8443
//     name: https
//     targetPort: 80
//   selector:
//     app: ratings
// ---
// apiVersion: security.istio.io/v1
// kind: PeerAuthentication
// metadata:
//   name: ratings-peer-auth
//   namespace: prod-us1
// spec:
//   selector:
//     matchLabels:
//       app: ratings
//   mtls:
//     mode: STRICT
//   portLevelMtls:
//     80:
//       mode: DISABLE
// ```
//
// In addition to configuring traffic capture and how traffic is forwarded to the app,
// it's possible to control inbound connection pool settings. By default, Istio pushes
// connection pool settings from `DestinationRules` to both clients (for outbound
// connections to the service) as well as servers (for inbound connections to a service
// instance). Using the `InboundConnectionPool` and per-port `ConnectionPool` settings
// in a `Sidecar` allow you to control those connection pools for the server separately
// from the settings pushed to all clients.
//
// ```yaml
// apiVersion: networking.istio.io/v1
// kind: Sidecar
// metadata:
//   name: connection-pool-settings
//   namespace: prod-us1
// spec:
//   workloadSelector:
//     labels:
//       app: productpage
//   inboundConnectionPool:
//       http:
//         http1MaxPendingRequests: 1024
//         http2MaxRequests: 1024
//         maxRequestsPerConnection: 1024
//         maxRetries: 100
//   ingress:
//   - port:
//       number: 80
//       protocol: HTTP
//       name: somename
//     connectionPool:
//       http:
//         http1MaxPendingRequests: 1024
//         http2MaxRequests: 1024
//         maxRequestsPerConnection: 1024
//         maxRetries: 100
//       tcp:
//         maxConnections: 100
// ```

package v1alpha3

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// `CaptureMode` describes how traffic to a listener is expected to be
// captured. Applicable only when the listener is bound to an IP.
type CaptureMode int32

const (
	// The default capture mode defined by the environment.
	CaptureMode_DEFAULT CaptureMode = 0
	// Capture traffic using IPtables redirection.
	CaptureMode_IPTABLES CaptureMode = 1
	// No traffic capture. When used in an egress listener, the application is
	// expected to explicitly communicate with the listener port or Unix
	// domain socket. When used in an ingress listener, care needs to be taken
	// to ensure that the listener port is not in use by other processes on
	// the host.
	CaptureMode_NONE CaptureMode = 2
)

// Enum value maps for CaptureMode.
var (
	CaptureMode_name = map[int32]string{
		0: "DEFAULT",
		1: "IPTABLES",
		2: "NONE",
	}
	CaptureMode_value = map[string]int32{
		"DEFAULT":  0,
		"IPTABLES": 1,
		"NONE":     2,
	}
)

func (x CaptureMode) Enum() *CaptureMode {
	p := new(CaptureMode)
	*p = x
	return p
}

func (x CaptureMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CaptureMode) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_sidecar_proto_enumTypes[0].Descriptor()
}

func (CaptureMode) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_sidecar_proto_enumTypes[0]
}

func (x CaptureMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CaptureMode.Descriptor instead.
func (CaptureMode) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_sidecar_proto_rawDescGZIP(), []int{0}
}

type OutboundTrafficPolicy_Mode int32

const (
	// In `REGISTRY_ONLY` mode, unknown outbound traffic will be dropped.
	// Traffic destinations must be explicitly declared into the service registry through `ServiceEntry` configurations.
	//
	// Note: Istio [does not offer an outbound traffic security policy](https://istio.io/latest/docs/ops/best-practices/security/#understand-traffic-capture-limitations).
	// This option does not act as one, or as any form of an outbound firewall.
	// Instead, this option exists primarily to offer users a way to detect missing `ServiceEntry` configurations by explicitly failing.
	OutboundTrafficPolicy_REGISTRY_ONLY OutboundTrafficPolicy_Mode = 0
	// In `ALLOW_ANY` mode, any traffic to unknown destinations will be allowed.
	// Unknown destination traffic will have limited functionality, however, such as reduced observability.
	// This mode allows users that do not have all possible egress destinations registered through `ServiceEntry` configurations to still connect
	// to arbitrary destinations.
	OutboundTrafficPolicy_ALLOW_ANY OutboundTrafficPolicy_Mode = 1
)

// Enum value maps for OutboundTrafficPolicy_Mode.
var (
	OutboundTrafficPolicy_Mode_name = map[int32]string{
		0: "REGISTRY_ONLY",
		1: "ALLOW_ANY",
	}
	OutboundTrafficPolicy_Mode_value = map[string]int32{
		"REGISTRY_ONLY": 0,
		"ALLOW_ANY":     1,
	}
)

func (x OutboundTrafficPolicy_Mode) Enum() *OutboundTrafficPolicy_Mode {
	p := new(OutboundTrafficPolicy_Mode)
	*p = x
	return p
}

func (x OutboundTrafficPolicy_Mode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutboundTrafficPolicy_Mode) Descriptor() protoreflect.EnumDescriptor {
	return file_networking_v1alpha3_sidecar_proto_enumTypes[1].Descriptor()
}

func (OutboundTrafficPolicy_Mode) Type() protoreflect.EnumType {
	return &file_networking_v1alpha3_sidecar_proto_enumTypes[1]
}

func (x OutboundTrafficPolicy_Mode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutboundTrafficPolicy_Mode.Descriptor instead.
func (OutboundTrafficPolicy_Mode) EnumDescriptor() ([]byte, []int) {
	return file_networking_v1alpha3_sidecar_proto_rawDescGZIP(), []int{4, 0}
}

// `Sidecar` describes the configuration of the sidecar proxy that mediates
// inbound and outbound communication of the workload instance to which it is
// attached.
//
// <!-- crd generation tags
// +cue-gen:Sidecar:groupName:networking.istio.io
// +cue-gen:Sidecar:versions:v1,v1beta1,v1alpha3
// +cue-gen:Sidecar:annotations:helm.sh/resource-policy=keep
// +cue-gen:Sidecar:labels:app=istio-pilot,chart=istio,heritage=Tiller,release=istio
// +cue-gen:Sidecar:subresource:status
// +cue-gen:Sidecar:scope:Namespaced
// +cue-gen:Sidecar:resource:categories=istio-io,networking-istio-io
// +cue-gen:Sidecar:preserveUnknownFields:false
// -->
//
// <!-- go code generation tags
// +kubetype-gen
// +kubetype-gen:groupVersion=networking.istio.io/v1alpha3
// +genclient
// +k8s:deepcopy-gen=true
// -->
type Sidecar struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Criteria used to select the specific set of pods/VMs on which this
	// `Sidecar` configuration should be applied. If omitted, the `Sidecar`
	// configuration will be applied to all workload instances in the same namespace.
	WorkloadSelector *WorkloadSelector `protobuf:"bytes,1,opt,name=workload_selector,json=workloadSelector,proto3" json:"workload_selector,omitempty"`
	// Ingress specifies the configuration of the sidecar for processing
	// inbound traffic to the attached workload instance. If omitted, Istio will
	// automatically configure the sidecar based on the information about the workload
	// obtained from the orchestration platform (e.g., exposed ports, services,
	// etc.). If specified, inbound ports are configured if and only if the
	// workload instance is associated with a service.
	Ingress []*IstioIngressListener `protobuf:"bytes,2,rep,name=ingress,proto3" json:"ingress,omitempty"`
	// Egress specifies the configuration of the sidecar for processing
	// outbound traffic from the attached workload instance to other
	// services in the mesh. If not specified, inherits the system
	// detected defaults from the namespace-wide or the global default Sidecar.
	Egress []*IstioEgressListener `protobuf:"bytes,3,rep,name=egress,proto3" json:"egress,omitempty"`
	// Settings controlling the volume of connections Envoy will accept from the network.
	// This default will apply for all inbound listeners and can be overridden per-port
	// in the `Ingress` field. This configuration mirrors the `DestinationRule`'s
	// [`connectionPool`](https://istio.io/latest/docs/reference/config/networking/destination-rule/#ConnectionPoolSettings) field.
	//
	// By default, Istio applies a service's `DestinationRule` to client sidecars
	// for outbound traffic directed at the service -- the usual case folks think
	// of when configuring a `DestinationRule` -- but also to the server's inbound
	// sidecar. The `Sidecar`'s connection pool configures the server's inbound
	// sidecar directly, so its settings can be different than clients'. This is
	// valuable, for example, when you have many clients calling few servers: a
	// `DestinationRule` can limit the concurrency of any single client, while
	// the `Sidecar` allows you to configure much higher concurrency on the server
	// side.
	//
	// Connection pool settings for a server's inbound sidecar are configured in the
	// following precedence, highest to lowest:
	// - per-port `ConnectionPool` from the `Sidecar`
	// - top level `InboundConnectionPool` from the `Sidecar`
	// - per-port `TrafficPolicy.ConnectionPool` from the `DestinationRule`
	// - top level `TrafficPolicy.ConnectionPool` from the `DestinationRule`
	// - default connection pool settings (essentially unlimited)
	//
	// In every case, the connection pool settings are overridden, not merged.
	InboundConnectionPool *ConnectionPoolSettings `protobuf:"bytes,7,opt,name=inbound_connection_pool,json=inboundConnectionPool,proto3" json:"inbound_connection_pool,omitempty"`
	// Set the default behavior of the sidecar for handling outbound
	// traffic from the application.
	//
	// Default mode is `ALLOW_ANY`, which means outbound traffic to unknown destinations will be allowed.
	OutboundTrafficPolicy *OutboundTrafficPolicy `protobuf:"bytes,4,opt,name=outbound_traffic_policy,json=outboundTrafficPolicy,proto3" json:"outbound_traffic_policy,omitempty"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Sidecar) Reset() {
	*x = Sidecar{}
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Sidecar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sidecar) ProtoMessage() {}

func (x *Sidecar) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Sidecar.ProtoReflect.Descriptor instead.
func (*Sidecar) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_sidecar_proto_rawDescGZIP(), []int{0}
}

func (x *Sidecar) GetWorkloadSelector() *WorkloadSelector {
	if x != nil {
		return x.WorkloadSelector
	}
	return nil
}

func (x *Sidecar) GetIngress() []*IstioIngressListener {
	if x != nil {
		return x.Ingress
	}
	return nil
}

func (x *Sidecar) GetEgress() []*IstioEgressListener {
	if x != nil {
		return x.Egress
	}
	return nil
}

func (x *Sidecar) GetInboundConnectionPool() *ConnectionPoolSettings {
	if x != nil {
		return x.InboundConnectionPool
	}
	return nil
}

func (x *Sidecar) GetOutboundTrafficPolicy() *OutboundTrafficPolicy {
	if x != nil {
		return x.OutboundTrafficPolicy
	}
	return nil
}

// `IstioIngressListener` specifies the properties of an inbound
// traffic listener on the sidecar proxy attached to a workload instance.
type IstioIngressListener struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The port associated with the listener.
	Port *SidecarPort `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	// The IP(IPv4 or IPv6) to which the listener should be bound.
	// Unix domain socket addresses are not allowed in
	// the bind field for ingress listeners. If omitted, Istio will
	// automatically configure the defaults based on imported services
	// and the workload instances to which this configuration is applied
	// to.
	Bind string `protobuf:"bytes,2,opt,name=bind,proto3" json:"bind,omitempty"`
	// The captureMode option dictates how traffic to the listener is
	// expected to be captured (or not).
	CaptureMode CaptureMode `protobuf:"varint,3,opt,name=capture_mode,json=captureMode,proto3,enum=istio.networking.v1alpha3.CaptureMode" json:"capture_mode,omitempty"`
	// The IP endpoint or Unix domain socket to which
	// traffic should be forwarded to. This configuration can be used to
	// redirect traffic arriving at the bind `IP:Port` on the sidecar to a `localhost:port`
	// or Unix domain socket where the application workload instance is listening for
	// connections. Arbitrary IPs are not supported. Format should be one of
	// `127.0.0.1:PORT`, `[::1]:PORT` (forward to localhost),
	// `0.0.0.0:PORT`, `[::]:PORT` (forward to the instance IP),
	// or `unix:///path/to/socket` (forward to Unix domain socket).
	DefaultEndpoint string `protobuf:"bytes,4,opt,name=default_endpoint,json=defaultEndpoint,proto3" json:"default_endpoint,omitempty"`
	// Set of TLS related options that will enable TLS termination on the
	// sidecar for requests originating from outside the mesh.
	// Currently supports only SIMPLE and MUTUAL TLS modes.
	Tls *ServerTLSSettings `protobuf:"bytes,7,opt,name=tls,proto3" json:"tls,omitempty"`
	// Settings controlling the volume of connections Envoy will accept from the network.
	// This setting overrides the top-level default `inboundConnectionPool` to configure
	// specific settings for this port. This configuration mirrors the `DestinationRule`'s
	// [`PortTrafficPolicy.connectionPool`](https://istio.io/latest/docs/reference/config/networking/destination-rule/#TrafficPolicy-PortTrafficPolicy) field.
	// This port level connection pool has the highest precedence in configuration,
	// overriding both the `Sidecar`'s top level `InboundConnectionPool` as well as any
	// connection pooling settings from the `DestinationRule`.
	ConnectionPool *ConnectionPoolSettings `protobuf:"bytes,8,opt,name=connection_pool,json=connectionPool,proto3" json:"connection_pool,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *IstioIngressListener) Reset() {
	*x = IstioIngressListener{}
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IstioIngressListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstioIngressListener) ProtoMessage() {}

func (x *IstioIngressListener) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstioIngressListener.ProtoReflect.Descriptor instead.
func (*IstioIngressListener) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_sidecar_proto_rawDescGZIP(), []int{1}
}

func (x *IstioIngressListener) GetPort() *SidecarPort {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *IstioIngressListener) GetBind() string {
	if x != nil {
		return x.Bind
	}
	return ""
}

func (x *IstioIngressListener) GetCaptureMode() CaptureMode {
	if x != nil {
		return x.CaptureMode
	}
	return CaptureMode_DEFAULT
}

func (x *IstioIngressListener) GetDefaultEndpoint() string {
	if x != nil {
		return x.DefaultEndpoint
	}
	return ""
}

func (x *IstioIngressListener) GetTls() *ServerTLSSettings {
	if x != nil {
		return x.Tls
	}
	return nil
}

func (x *IstioIngressListener) GetConnectionPool() *ConnectionPoolSettings {
	if x != nil {
		return x.ConnectionPool
	}
	return nil
}

// `IstioEgressListener` specifies the properties of an outbound traffic
// listener on the sidecar proxy attached to a workload instance.
type IstioEgressListener struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The port associated with the listener. If using Unix domain socket,
	// use 0 as the port number, with a valid protocol. The port if
	// specified, will be used as the default destination port associated
	// with the imported hosts. If the port is omitted, Istio will infer the
	// listener ports based on the imported hosts. Note that when multiple
	// egress listeners are specified, where one or more listeners have
	// specific ports while others have no port, the hosts exposed on a
	// listener port will be based on the listener with the most specific
	// port.
	Port *SidecarPort `protobuf:"bytes,1,opt,name=port,proto3" json:"port,omitempty"`
	// The IP(IPv4 or IPv6) or the Unix domain socket to which the listener should be bound
	// to. Port MUST be specified if bind is not empty. Format: IPv4 or IPv6 address formats or
	// `unix:///path/to/uds` or `unix://@foobar` (Linux abstract namespace). If
	// omitted, Istio will automatically configure the defaults based on imported
	// services, the workload instances to which this configuration is applied to and
	// the captureMode. If captureMode is `NONE`, bind will default to
	// 127.0.0.1.
	Bind string `protobuf:"bytes,2,opt,name=bind,proto3" json:"bind,omitempty"`
	// When the bind address is an IP, the captureMode option dictates
	// how traffic to the listener is expected to be captured (or not).
	// captureMode must be DEFAULT or `NONE` for Unix domain socket binds.
	CaptureMode CaptureMode `protobuf:"varint,3,opt,name=capture_mode,json=captureMode,proto3,enum=istio.networking.v1alpha3.CaptureMode" json:"capture_mode,omitempty"`
	// One or more service hosts exposed by the listener
	// in `namespace/dnsName` format. Services in the specified namespace
	// matching `dnsName` will be exposed.
	// The corresponding service can be a service in the service registry
	// (e.g., a Kubernetes or cloud foundry service) or a service specified
	// using a `ServiceEntry` or `VirtualService` configuration. Any
	// associated `DestinationRule` in the same namespace will also be used.
	//
	// The `dnsName` should be specified using FQDN format, optionally including
	// a wildcard character in the left-most component (e.g., `prod/*.example.com`).
	// Set the `dnsName` to `*` to select all services from the specified namespace
	// (e.g., `prod/*`).
	//
	// The `namespace` can be set to `*`, `.`, or `~`, representing any, the current,
	// or no namespace, respectively. For example, `*/foo.example.com` selects the
	// service from any available namespace while `./foo.example.com` only selects
	// the service from the namespace of the sidecar. If a host is set to `*/*`,
	// Istio will configure the sidecar to be able to reach every service in the
	// mesh that is exported to the sidecar's namespace. The value `~/*` can be used
	// to completely trim the configuration for sidecars that simply receive traffic
	// and respond, but make no outbound connections of their own.
	//
	// NOTE: Only services and configuration artifacts exported to the sidecar's
	// namespace (e.g., `exportTo` value of `*`) can be referenced.
	// Private configurations (e.g., `exportTo` set to `.`) will
	// not be available. Refer to the `exportTo` setting in `VirtualService`,
	// `DestinationRule`, and `ServiceEntry` configurations for details.
	Hosts         []string `protobuf:"bytes,4,rep,name=hosts,proto3" json:"hosts,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *IstioEgressListener) Reset() {
	*x = IstioEgressListener{}
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IstioEgressListener) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IstioEgressListener) ProtoMessage() {}

func (x *IstioEgressListener) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IstioEgressListener.ProtoReflect.Descriptor instead.
func (*IstioEgressListener) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_sidecar_proto_rawDescGZIP(), []int{2}
}

func (x *IstioEgressListener) GetPort() *SidecarPort {
	if x != nil {
		return x.Port
	}
	return nil
}

func (x *IstioEgressListener) GetBind() string {
	if x != nil {
		return x.Bind
	}
	return ""
}

func (x *IstioEgressListener) GetCaptureMode() CaptureMode {
	if x != nil {
		return x.CaptureMode
	}
	return CaptureMode_DEFAULT
}

func (x *IstioEgressListener) GetHosts() []string {
	if x != nil {
		return x.Hosts
	}
	return nil
}

// `WorkloadSelector` specifies the criteria used to determine if the
// `Gateway`, `Sidecar`, `EnvoyFilter`, `ServiceEntry`, or `DestinationRule`
// configuration can be applied to a proxy. The matching criteria
// includes the metadata associated with a proxy, workload instance
// info such as labels attached to the pod/VM, or any other info that
// the proxy provides to Istio during the initial handshake. If
// multiple conditions are specified, all conditions need to match in
// order for the workload instance to be selected. Currently, only
// label based selection mechanism is supported.
type WorkloadSelector struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// One or more labels that indicate a specific set of pods/VMs
	// on which the configuration should be applied. The scope of
	// label search is restricted to the configuration namespace in which the
	// the resource is present.
	// +kubebuilder:validation:MaxProperties=256
	// +protoc-gen-crd:map-value-validation:MaxLength=63
	// +protoc-gen-crd:map-value-validation:XValidation:message="wildcard is not supported in selector",rule="!self.contains('*')"
	Labels        map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *WorkloadSelector) Reset() {
	*x = WorkloadSelector{}
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WorkloadSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WorkloadSelector) ProtoMessage() {}

func (x *WorkloadSelector) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WorkloadSelector.ProtoReflect.Descriptor instead.
func (*WorkloadSelector) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_sidecar_proto_rawDescGZIP(), []int{3}
}

func (x *WorkloadSelector) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// `OutboundTrafficPolicy` sets the default behavior of the sidecar for
// handling unknown outbound traffic from the application.
type OutboundTrafficPolicy struct {
	state protoimpl.MessageState     `protogen:"open.v1"`
	Mode  OutboundTrafficPolicy_Mode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.networking.v1alpha3.OutboundTrafficPolicy_Mode" json:"mode,omitempty"`
	// Specifies the details of the egress proxy to which unknown
	// traffic should be forwarded to from the sidecar. Valid only if
	// the mode is set to ALLOW_ANY. If not specified when the mode is
	// ALLOW_ANY, the sidecar will send the unknown traffic directly to
	// the IP requested by the application.
	//
	// ** NOTE 1**: The specified egress host must be imported in the
	// egress section for the traffic forwarding to work.
	//
	// ** NOTE 2**: An Envoy based egress gateway is unlikely to be able
	// to handle plain text TCP connections forwarded from the sidecar.
	// Envoy's dynamic forward proxy can handle only HTTP and TLS
	// connections.
	// $hide_from_docs
	EgressProxy   *Destination `protobuf:"bytes,2,opt,name=egress_proxy,json=egressProxy,proto3" json:"egress_proxy,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OutboundTrafficPolicy) Reset() {
	*x = OutboundTrafficPolicy{}
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutboundTrafficPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutboundTrafficPolicy) ProtoMessage() {}

func (x *OutboundTrafficPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutboundTrafficPolicy.ProtoReflect.Descriptor instead.
func (*OutboundTrafficPolicy) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_sidecar_proto_rawDescGZIP(), []int{4}
}

func (x *OutboundTrafficPolicy) GetMode() OutboundTrafficPolicy_Mode {
	if x != nil {
		return x.Mode
	}
	return OutboundTrafficPolicy_REGISTRY_ONLY
}

func (x *OutboundTrafficPolicy) GetEgressProxy() *Destination {
	if x != nil {
		return x.EgressProxy
	}
	return nil
}

// Port describes the properties of a specific port of a service.
type SidecarPort struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A valid non-negative integer port number.
	Number uint32 `protobuf:"varint,1,opt,name=number,proto3" json:"number,omitempty"`
	// The protocol exposed on the port.
	// MUST be one of HTTP|HTTPS|GRPC|HTTP2|MONGO|TCP|TLS.
	// TLS can be either used to terminate non-HTTP based connections on a specific port
	// or to route traffic based on SNI header to the destination without terminating the TLS connection.
	Protocol string `protobuf:"bytes,2,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// Label assigned to the port.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Has no effect, only for backwards compatibility
	// received. Applicable only when used with ServiceEntries.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in networking/v1alpha3/sidecar.proto.
	TargetPort    uint32 `protobuf:"varint,4,opt,name=target_port,json=targetPort,proto3" json:"target_port,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SidecarPort) Reset() {
	*x = SidecarPort{}
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SidecarPort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SidecarPort) ProtoMessage() {}

func (x *SidecarPort) ProtoReflect() protoreflect.Message {
	mi := &file_networking_v1alpha3_sidecar_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SidecarPort.ProtoReflect.Descriptor instead.
func (*SidecarPort) Descriptor() ([]byte, []int) {
	return file_networking_v1alpha3_sidecar_proto_rawDescGZIP(), []int{5}
}

func (x *SidecarPort) GetNumber() uint32 {
	if x != nil {
		return x.Number
	}
	return 0
}

func (x *SidecarPort) GetProtocol() string {
	if x != nil {
		return x.Protocol
	}
	return ""
}

func (x *SidecarPort) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Deprecated: Marked as deprecated in networking/v1alpha3/sidecar.proto.
func (x *SidecarPort) GetTargetPort() uint32 {
	if x != nil {
		return x.TargetPort
	}
	return 0
}

var File_networking_v1alpha3_sidecar_proto protoreflect.FileDescriptor

const file_networking_v1alpha3_sidecar_proto_rawDesc = "" +
	"\n" +
	"!networking/v1alpha3/sidecar.proto\x12\x19istio.networking.v1alpha3\x1a\x1fgoogle/api/field_behavior.proto\x1a*networking/v1alpha3/destination_rule.proto\x1a!networking/v1alpha3/gateway.proto\x1a)networking/v1alpha3/virtual_service.proto\"\xe2\x03\n" +
	"\aSidecar\x12X\n" +
	"\x11workload_selector\x18\x01 \x01(\v2+.istio.networking.v1alpha3.WorkloadSelectorR\x10workloadSelector\x12I\n" +
	"\aingress\x18\x02 \x03(\v2/.istio.networking.v1alpha3.IstioIngressListenerR\aingress\x12F\n" +
	"\x06egress\x18\x03 \x03(\v2..istio.networking.v1alpha3.IstioEgressListenerR\x06egress\x12i\n" +
	"\x17inbound_connection_pool\x18\a \x01(\v21.istio.networking.v1alpha3.ConnectionPoolSettingsR\x15inboundConnectionPool\x12h\n" +
	"\x17outbound_traffic_policy\x18\x04 \x01(\v20.istio.networking.v1alpha3.OutboundTrafficPolicyR\x15outboundTrafficPolicyJ\x04\b\x05\x10\x06J\x04\b\x06\x10\aR\tlocalhost\"\xa0\x03\n" +
	"\x14IstioIngressListener\x12@\n" +
	"\x04port\x18\x01 \x01(\v2&.istio.networking.v1alpha3.SidecarPortB\x04\xe2A\x01\x02R\x04port\x12\x12\n" +
	"\x04bind\x18\x02 \x01(\tR\x04bind\x12I\n" +
	"\fcapture_mode\x18\x03 \x01(\x0e2&.istio.networking.v1alpha3.CaptureModeR\vcaptureMode\x12)\n" +
	"\x10default_endpoint\x18\x04 \x01(\tR\x0fdefaultEndpoint\x12>\n" +
	"\x03tls\x18\a \x01(\v2,.istio.networking.v1alpha3.ServerTLSSettingsR\x03tls\x12Z\n" +
	"\x0fconnection_pool\x18\b \x01(\v21.istio.networking.v1alpha3.ConnectionPoolSettingsR\x0econnectionPoolJ\x04\b\x05\x10\x06J\x04\b\x06\x10\aR\x14localhost_client_tls\"\xee\x01\n" +
	"\x13IstioEgressListener\x12:\n" +
	"\x04port\x18\x01 \x01(\v2&.istio.networking.v1alpha3.SidecarPortR\x04port\x12\x12\n" +
	"\x04bind\x18\x02 \x01(\tR\x04bind\x12I\n" +
	"\fcapture_mode\x18\x03 \x01(\x0e2&.istio.networking.v1alpha3.CaptureModeR\vcaptureMode\x12\x1a\n" +
	"\x05hosts\x18\x04 \x03(\tB\x04\xe2A\x01\x02R\x05hostsJ\x04\b\x05\x10\x06J\x04\b\x06\x10\aR\x14localhost_server_tls\"\x9e\x01\n" +
	"\x10WorkloadSelector\x12O\n" +
	"\x06labels\x18\x01 \x03(\v27.istio.networking.v1alpha3.WorkloadSelector.LabelsEntryR\x06labels\x1a9\n" +
	"\vLabelsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\"\xd7\x01\n" +
	"\x15OutboundTrafficPolicy\x12I\n" +
	"\x04mode\x18\x01 \x01(\x0e25.istio.networking.v1alpha3.OutboundTrafficPolicy.ModeR\x04mode\x12I\n" +
	"\fegress_proxy\x18\x02 \x01(\v2&.istio.networking.v1alpha3.DestinationR\vegressProxy\"(\n" +
	"\x04Mode\x12\x11\n" +
	"\rREGISTRY_ONLY\x10\x00\x12\r\n" +
	"\tALLOW_ANY\x10\x01\"z\n" +
	"\vSidecarPort\x12\x16\n" +
	"\x06number\x18\x01 \x01(\rR\x06number\x12\x1a\n" +
	"\bprotocol\x18\x02 \x01(\tR\bprotocol\x12\x12\n" +
	"\x04name\x18\x03 \x01(\tR\x04name\x12#\n" +
	"\vtarget_port\x18\x04 \x01(\rB\x02\x18\x01R\n" +
	"targetPort*2\n" +
	"\vCaptureMode\x12\v\n" +
	"\aDEFAULT\x10\x00\x12\f\n" +
	"\bIPTABLES\x10\x01\x12\b\n" +
	"\x04NONE\x10\x02B\"Z istio.io/api/networking/v1alpha3b\x06proto3"

var (
	file_networking_v1alpha3_sidecar_proto_rawDescOnce sync.Once
	file_networking_v1alpha3_sidecar_proto_rawDescData []byte
)

func file_networking_v1alpha3_sidecar_proto_rawDescGZIP() []byte {
	file_networking_v1alpha3_sidecar_proto_rawDescOnce.Do(func() {
		file_networking_v1alpha3_sidecar_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_sidecar_proto_rawDesc), len(file_networking_v1alpha3_sidecar_proto_rawDesc)))
	})
	return file_networking_v1alpha3_sidecar_proto_rawDescData
}

var file_networking_v1alpha3_sidecar_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_networking_v1alpha3_sidecar_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_networking_v1alpha3_sidecar_proto_goTypes = []any{
	(CaptureMode)(0),                // 0: istio.networking.v1alpha3.CaptureMode
	(OutboundTrafficPolicy_Mode)(0), // 1: istio.networking.v1alpha3.OutboundTrafficPolicy.Mode
	(*Sidecar)(nil),                 // 2: istio.networking.v1alpha3.Sidecar
	(*IstioIngressListener)(nil),    // 3: istio.networking.v1alpha3.IstioIngressListener
	(*IstioEgressListener)(nil),     // 4: istio.networking.v1alpha3.IstioEgressListener
	(*WorkloadSelector)(nil),        // 5: istio.networking.v1alpha3.WorkloadSelector
	(*OutboundTrafficPolicy)(nil),   // 6: istio.networking.v1alpha3.OutboundTrafficPolicy
	(*SidecarPort)(nil),             // 7: istio.networking.v1alpha3.SidecarPort
	nil,                             // 8: istio.networking.v1alpha3.WorkloadSelector.LabelsEntry
	(*ConnectionPoolSettings)(nil),  // 9: istio.networking.v1alpha3.ConnectionPoolSettings
	(*ServerTLSSettings)(nil),       // 10: istio.networking.v1alpha3.ServerTLSSettings
	(*Destination)(nil),             // 11: istio.networking.v1alpha3.Destination
}
var file_networking_v1alpha3_sidecar_proto_depIdxs = []int32{
	5,  // 0: istio.networking.v1alpha3.Sidecar.workload_selector:type_name -> istio.networking.v1alpha3.WorkloadSelector
	3,  // 1: istio.networking.v1alpha3.Sidecar.ingress:type_name -> istio.networking.v1alpha3.IstioIngressListener
	4,  // 2: istio.networking.v1alpha3.Sidecar.egress:type_name -> istio.networking.v1alpha3.IstioEgressListener
	9,  // 3: istio.networking.v1alpha3.Sidecar.inbound_connection_pool:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings
	6,  // 4: istio.networking.v1alpha3.Sidecar.outbound_traffic_policy:type_name -> istio.networking.v1alpha3.OutboundTrafficPolicy
	7,  // 5: istio.networking.v1alpha3.IstioIngressListener.port:type_name -> istio.networking.v1alpha3.SidecarPort
	0,  // 6: istio.networking.v1alpha3.IstioIngressListener.capture_mode:type_name -> istio.networking.v1alpha3.CaptureMode
	10, // 7: istio.networking.v1alpha3.IstioIngressListener.tls:type_name -> istio.networking.v1alpha3.ServerTLSSettings
	9,  // 8: istio.networking.v1alpha3.IstioIngressListener.connection_pool:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings
	7,  // 9: istio.networking.v1alpha3.IstioEgressListener.port:type_name -> istio.networking.v1alpha3.SidecarPort
	0,  // 10: istio.networking.v1alpha3.IstioEgressListener.capture_mode:type_name -> istio.networking.v1alpha3.CaptureMode
	8,  // 11: istio.networking.v1alpha3.WorkloadSelector.labels:type_name -> istio.networking.v1alpha3.WorkloadSelector.LabelsEntry
	1,  // 12: istio.networking.v1alpha3.OutboundTrafficPolicy.mode:type_name -> istio.networking.v1alpha3.OutboundTrafficPolicy.Mode
	11, // 13: istio.networking.v1alpha3.OutboundTrafficPolicy.egress_proxy:type_name -> istio.networking.v1alpha3.Destination
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_networking_v1alpha3_sidecar_proto_init() }
func file_networking_v1alpha3_sidecar_proto_init() {
	if File_networking_v1alpha3_sidecar_proto != nil {
		return
	}
	file_networking_v1alpha3_destination_rule_proto_init()
	file_networking_v1alpha3_gateway_proto_init()
	file_networking_v1alpha3_virtual_service_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_networking_v1alpha3_sidecar_proto_rawDesc), len(file_networking_v1alpha3_sidecar_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_networking_v1alpha3_sidecar_proto_goTypes,
		DependencyIndexes: file_networking_v1alpha3_sidecar_proto_depIdxs,
		EnumInfos:         file_networking_v1alpha3_sidecar_proto_enumTypes,
		MessageInfos:      file_networking_v1alpha3_sidecar_proto_msgTypes,
	}.Build()
	File_networking_v1alpha3_sidecar_proto = out.File
	file_networking_v1alpha3_sidecar_proto_goTypes = nil
	file_networking_v1alpha3_sidecar_proto_depIdxs = nil
}
