#ifndef INCLUDED_SUPPORT_H_
#define INCLUDED_SUPPORT_H_

#include <string>
#include <system_error>
#include <filesystem>
#include <stack>
#include <unordered_set>

class Support
{
    std::stack<std::filesystem::path> d_dirStack;

    protected:
        using Set = std::unordered_set<std::string>;
    
        using DirEntry = std::filesystem::directory_entry;
        using Path = std::filesystem::path;

        static std::error_code s_errorCode;

        void pushCwd();                         // push the CWD on the stack
        void pushDir(DirEntry const &dir);      // push dir on the stack
        void pushDir(Path const &dir);          // (2) push dir on the stack
        void popDir();                          // return to the prev. path
                                                // (ignored at empty stack,
                                                // the last element is kept)
        Path const &top() const;

        void createSymlink(Path const &dest, Path const &link) const;
        bool createDir(Path const &dir) const;
        bool createDirs(Path const &dir) const;

        void setCwd(std::string const &dir) const;
        bool exists(std::string const &fname) const;

        bool younger(std::string const &srcFile,        // also if objFile 
                     std::string const &objFile) const; // doesn't exist
                                                            
};


#endif

