/* plist.c generated by valac 0.56.17, the Vala compiler
 * generated from plist.vala, do not modify */

/* 
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include "libutil.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PLIST_0_PROPERTY,
	PLIST_NUM_PROPERTIES
};
static GParamSpec* plist_properties[PLIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _PListPrivate {
	GeeMap* map;
};

static gint PList_private_offset;
static gpointer plist_parent_class = NULL;

static void plist_finalize (GObject * obj);
static GType plist_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

GQuark
plist_parse_error_quark (void)
{
	return g_quark_from_static_string ("plist-parse-error-quark");
}

static GType
plist_parse_error_get_type_once (void)
{
	static const GEnumValue values[] = {{PLIST_PARSE_ERROR_FAILED, "PLIST_PARSE_ERROR_FAILED", "failed"}, {0, NULL, NULL}};
	GType plist_parse_error_type_id;
	plist_parse_error_type_id = g_enum_register_static ("PListParseError", values);
	return plist_parse_error_type_id;
}

GType
plist_parse_error_get_type (void)
{
	static volatile gsize plist_parse_error_type_id__once = 0;
	if (g_once_init_enter (&plist_parse_error_type_id__once)) {
		GType plist_parse_error_type_id;
		plist_parse_error_type_id = plist_parse_error_get_type_once ();
		g_once_init_leave (&plist_parse_error_type_id__once, plist_parse_error_type_id);
	}
	return plist_parse_error_type_id__once;
}

static inline gpointer
plist_get_instance_private (PList* self)
{
	return G_STRUCT_MEMBER_P (self, PList_private_offset);
}

gchar*
plist_get (PList* self,
           const gchar* key)
{
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->map;
	_tmp1_ = gee_map_get (_tmp0_, key);
	result = (gchar*) _tmp1_;
	return result;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

PList*
plist_construct (GType object_type,
                 const gchar* str,
                 GError** error)
{
	PList * self = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gchar* key = NULL;
	gchar* value = NULL;
	gint index = 0;
	gint _tmp24_;
	gint _tmp25_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (str != NULL, NULL);
	self = (PList*) g_object_new (object_type, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	key = NULL;
	value = NULL;
	{
		gboolean _tmp1_ = FALSE;
		index = 0;
		_tmp1_ = TRUE;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			if (!_tmp1_) {
				gint _tmp2_;
				_tmp2_ = index;
				index = _tmp2_ + 1;
			}
			_tmp1_ = FALSE;
			_tmp3_ = strlen (str);
			_tmp4_ = _tmp3_;
			if (!(index < _tmp4_)) {
				break;
			}
			switch (string_get (str, (glong) index)) {
				case '\\':
				{
					gint _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					GString* _tmp9_;
					_tmp5_ = index;
					index = _tmp5_ + 1;
					_tmp6_ = strlen (str);
					_tmp7_ = _tmp6_;
					if (index == _tmp7_) {
						GError* _tmp8_;
						_tmp8_ = g_error_new_literal (PLIST_PARSE_ERROR, PLIST_PARSE_ERROR_FAILED, "");
						_inner_error0_ = _tmp8_;
						if (_inner_error0_->domain == PLIST_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (value);
							_g_free0 (key);
							_g_string_free0 (builder);
							_g_object_unref0 (self);
							return NULL;
						} else {
							_g_free0 (value);
							_g_free0 (key);
							_g_string_free0 (builder);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp9_ = builder;
					g_string_append_c (_tmp9_, string_get (str, (glong) index));
					break;
				}
				case ',':
				{
					const gchar* _tmp10_;
					GString* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					GString* _tmp15_;
					GeeMap* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					_tmp10_ = key;
					if (_tmp10_ == NULL) {
						GError* _tmp11_;
						_tmp11_ = g_error_new_literal (PLIST_PARSE_ERROR, PLIST_PARSE_ERROR_FAILED, "");
						_inner_error0_ = _tmp11_;
						if (_inner_error0_->domain == PLIST_PARSE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_free0 (value);
							_g_free0 (key);
							_g_string_free0 (builder);
							_g_object_unref0 (self);
							return NULL;
						} else {
							_g_free0 (value);
							_g_free0 (key);
							_g_string_free0 (builder);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
					_tmp12_ = builder;
					_tmp13_ = _tmp12_->str;
					_tmp14_ = g_strdup (_tmp13_);
					_g_free0 (value);
					value = _tmp14_;
					_tmp15_ = builder;
					g_string_erase (_tmp15_, (gssize) 0, (gssize) -1);
					_tmp16_ = self->priv->map;
					_tmp17_ = key;
					_tmp18_ = value;
					gee_map_set (_tmp16_, _tmp17_, _tmp18_);
					_g_free0 (key);
					key = NULL;
					break;
				}
				case '=':
				{
					GString* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					GString* _tmp22_;
					_tmp19_ = builder;
					_tmp20_ = _tmp19_->str;
					_tmp21_ = g_strdup (_tmp20_);
					_g_free0 (key);
					key = _tmp21_;
					_tmp22_ = builder;
					g_string_erase (_tmp22_, (gssize) 0, (gssize) -1);
					_g_free0 (value);
					value = NULL;
					break;
				}
				default:
				{
					GString* _tmp23_;
					_tmp23_ = builder;
					g_string_append_c (_tmp23_, string_get (str, (glong) index));
					break;
				}
			}
		}
	}
	_tmp24_ = strlen (str);
	_tmp25_ = _tmp24_;
	if (index == _tmp25_) {
		const gchar* _tmp26_;
		GString* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		GeeMap* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp26_ = key;
		if (_tmp26_ == NULL) {
			GError* _tmp27_;
			_tmp27_ = g_error_new_literal (PLIST_PARSE_ERROR, PLIST_PARSE_ERROR_FAILED, "");
			_inner_error0_ = _tmp27_;
			if (_inner_error0_->domain == PLIST_PARSE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (value);
				_g_free0 (key);
				_g_string_free0 (builder);
				_g_object_unref0 (self);
				return NULL;
			} else {
				_g_free0 (value);
				_g_free0 (key);
				_g_string_free0 (builder);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		_tmp28_ = builder;
		_tmp29_ = _tmp28_->str;
		_tmp30_ = g_strdup (_tmp29_);
		_g_free0 (value);
		value = _tmp30_;
		_tmp31_ = self->priv->map;
		_tmp32_ = key;
		_tmp33_ = value;
		gee_map_set (_tmp31_, _tmp32_, _tmp33_);
	}
	_g_free0 (value);
	_g_free0 (key);
	_g_string_free0 (builder);
	return self;
}

PList*
plist_new (const gchar* str,
           GError** error)
{
	return plist_construct (TYPE_PLIST, str, error);
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

gchar*
plist_escape (const gchar* str)
{
	GString* builder = NULL;
	GString* _tmp0_;
	gint index = 0;
	gunichar uc = 0U;
	GString* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	index = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		GString* _tmp6_;
		_tmp2_ = string_get_next_char (str, &index, &_tmp1_);
		uc = _tmp1_;
		if (!_tmp2_) {
			break;
		}
		if (uc == ((gunichar) ',')) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = uc == ((gunichar) '\\');
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = uc == ((gunichar) '=');
		}
		if (_tmp3_) {
			GString* _tmp5_;
			_tmp5_ = builder;
			g_string_append (_tmp5_, "\\");
		}
		_tmp6_ = builder;
		g_string_append_unichar (_tmp6_, uc);
	}
	_tmp7_ = builder;
	_tmp8_ = _tmp7_->str;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	_g_string_free0 (builder);
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
plist_to_string (PList* self)
{
	GeeArrayList* props = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* keys = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeMap* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp28_;
	gint _tmp29_ = 0;
	gpointer* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	props = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	keys = _tmp1_;
	_tmp2_ = keys;
	_tmp3_ = self->priv->map;
	_tmp4_ = gee_map_get_keys (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	gee_array_list_add_all (_tmp2_, (GeeCollection*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = keys;
	gee_list_sort ((GeeList*) _tmp7_, NULL, NULL, NULL);
	{
		GeeArrayList* _key_list = NULL;
		GeeArrayList* _tmp8_;
		gint _key_size = 0;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _key_index = 0;
		_tmp8_ = keys;
		_key_list = _tmp8_;
		_tmp9_ = _key_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_key_size = _tmp11_;
		_key_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gchar* key = NULL;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			gchar* value = NULL;
			GeeMap* _tmp16_;
			const gchar* _tmp17_;
			gpointer _tmp18_;
			GeeArrayList* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_key_index = _key_index + 1;
			_tmp12_ = _key_index;
			_tmp13_ = _key_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _key_list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _key_index);
			key = (gchar*) _tmp15_;
			_tmp16_ = self->priv->map;
			_tmp17_ = key;
			_tmp18_ = gee_map_get (_tmp16_, _tmp17_);
			value = (gchar*) _tmp18_;
			_tmp19_ = props;
			_tmp20_ = key;
			_tmp21_ = plist_escape (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = value;
			_tmp24_ = plist_escape (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("%s=%s", _tmp22_, _tmp25_);
			_tmp27_ = _tmp26_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp22_);
			_g_free0 (value);
			_g_free0 (key);
		}
	}
	_tmp28_ = props;
	_tmp30_ = gee_collection_to_array ((GeeCollection*) _tmp28_, &_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp31__length1 = _tmp29_;
	_tmp32_ = _vala_g_strjoinv (",", _tmp31_, (gint) _tmp29_);
	_tmp33_ = _tmp32_;
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp33_;
	_g_object_unref0 (keys);
	_g_object_unref0 (props);
	return result;
}

static void
plist_class_init (PListClass * klass,
                  gpointer klass_data)
{
	plist_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PList_private_offset);
	G_OBJECT_CLASS (klass)->finalize = plist_finalize;
}

static void
plist_instance_init (PList * self,
                     gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = plist_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->map = (GeeMap*) _tmp0_;
}

static void
plist_finalize (GObject * obj)
{
	PList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLIST, PList);
	_g_object_unref0 (self->priv->map);
	G_OBJECT_CLASS (plist_parent_class)->finalize (obj);
}

static GType
plist_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) plist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PList), 0, (GInstanceInitFunc) plist_instance_init, NULL };
	GType plist_type_id;
	plist_type_id = g_type_register_static (G_TYPE_OBJECT, "PList", &g_define_type_info, 0);
	PList_private_offset = g_type_add_instance_private (plist_type_id, sizeof (PListPrivate));
	return plist_type_id;
}

GType
plist_get_type (void)
{
	static volatile gsize plist_type_id__once = 0;
	if (g_once_init_enter (&plist_type_id__once)) {
		GType plist_type_id;
		plist_type_id = plist_get_type_once ();
		g_once_init_leave (&plist_type_id__once, plist_type_id);
	}
	return plist_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

