/* engine.c generated by valac 0.56.17, the Vala compiler
 * generated from engine.vala, do not modify */

/* 
 * Copyright (C) 2011-2017 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2017 Red Hat, Inc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#include <ibus.h>
#include <glib-object.h>
#include <libskk/libskk.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libutil.h>
#include <config.h>
#include <locale.h>
#include <stdio.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SKK_ENGINE (skk_engine_get_type ())
#define SKK_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SKK_ENGINE, SkkEngine))
#define SKK_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SKK_ENGINE, SkkEngineClass))
#define IS_SKK_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SKK_ENGINE))
#define IS_SKK_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SKK_ENGINE))
#define SKK_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SKK_ENGINE, SkkEngineClass))

typedef struct _SkkEngine SkkEngine;
typedef struct _SkkEngineClass SkkEngineClass;
typedef struct _SkkEnginePrivate SkkEnginePrivate;
enum  {
	SKK_ENGINE_0_PROPERTY,
	SKK_ENGINE_NUM_PROPERTIES
};
static GParamSpec* skk_engine_properties[SKK_ENGINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SkkEngine {
	IBusEngine parent_instance;
	SkkEnginePrivate * priv;
};

struct _SkkEngineClass {
	IBusEngineClass parent_class;
};

struct _SkkEnginePrivate {
	SkkContext* context;
	IBusLookupTable* lookup_table;
	guint page_start;
	gboolean lookup_table_visible;
	gboolean show_annotation;
	IBusProperty* input_mode_prop;
	IBusPropList* prop_list;
	gboolean properties_registered;
	GeeMap* input_mode_props;
	GeeMap* input_mode_symbols;
	GeeMap* name_input_modes;
	gchar** LOOKUP_TABLE_LABELS;
	gint LOOKUP_TABLE_LABELS_length1;
	gint _LOOKUP_TABLE_LABELS_size_;
};

static gint SkkEngine_private_offset;
static gpointer skk_engine_parent_class = NULL;
static gboolean skk_engine_ibus;
static Preferences* skk_engine_preferences;
static Preferences* skk_engine_preferences = NULL;
static GeeArrayList* skk_engine_dictionaries;
static GeeArrayList* skk_engine_dictionaries = NULL;
static gboolean skk_engine_ibus = FALSE;

VALA_EXTERN GType skk_engine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SkkEngine, g_object_unref)
static gboolean _skk_engine_retrieve_surrounding_text (SkkEngine* self,
                                                gchar** text,
                                                guint* cursor_pos);
static gboolean _skk_engine_delete_surrounding_text (SkkEngine* self,
                                              gint offset,
                                              guint nchars);
static void skk_engine_populate_lookup_table (SkkEngine* self);
static void skk_engine_set_lookup_table_cursor_pos (SkkEngine* self);
static void skk_engine_update_preedit (SkkEngine* self);
static void skk_engine_update_candidates (SkkEngine* self);
static void skk_engine_update_input_mode (SkkEngine* self);
static SkkDict* skk_engine_parse_dict_from_plist (PList* plist,
                                           GError** error);
static void skk_engine_reload_dictionaries (void);
static void skk_engine_apply_preferences (SkkEngine* self);
static IBusProperty* skk_engine_register_input_mode_property (SkkEngine* self,
                                                       SkkInputMode mode,
                                                       const gchar* name,
                                                       const gchar* label,
                                                       const gchar* symbol);
static gboolean skk_engine_process_lookup_table_key_event (SkkEngine* self,
                                                    guint keyval,
                                                    guint keycode,
                                                    guint state);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gboolean skk_engine_real_process_key_event (IBusEngine* base,
                                            guint keyval,
                                            guint keycode,
                                            guint state);
static void skk_engine_real_enable (IBusEngine* base);
static void skk_engine_real_disable (IBusEngine* base);
static void skk_engine_real_reset (IBusEngine* base);
static void skk_engine_real_focus_in (IBusEngine* base);
static void skk_engine_real_focus_out (IBusEngine* base);
static void skk_engine_real_property_activate (IBusEngine* base,
                                        const gchar* prop_name,
                                        guint prop_state);
static void skk_engine_real_candidate_clicked (IBusEngine* base,
                                        guint index,
                                        guint button,
                                        guint state);
static void skk_engine_real_cursor_up (IBusEngine* base);
static void skk_engine_real_cursor_down (IBusEngine* base);
static void skk_engine_real_page_up (IBusEngine* base);
static void skk_engine_real_page_down (IBusEngine* base);
static gint skk_engine_main (gchar** args,
                      gint args_length1);
static void __lambda4_ (void);
static void ___lambda4__ibus_bus_disconnected (IBusBus* _sender,
                                        gpointer self);
static void __lambda5_ (const gchar* name,
                 GVariant* value);
static void ___lambda5__preferences_value_changed (Preferences* _sender,
                                            const gchar* name,
                                            GVariant* value,
                                            gpointer self);
VALA_EXTERN SkkEngine* skk_engine_new (void);
VALA_EXTERN SkkEngine* skk_engine_construct (GType object_type);
static GObject * skk_engine_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
static void _skk_engine___lambda6_ (SkkEngine* self,
                             const gchar* name,
                             GVariant* value);
static void __skk_engine___lambda6__preferences_value_changed (Preferences* _sender,
                                                        const gchar* name,
                                                        GVariant* value,
                                                        gpointer self);
static void _skk_engine___lambda7_ (SkkEngine* self);
static void __skk_engine___lambda7__g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self);
static void _skk_engine___lambda8_ (SkkEngine* self,
                             GObject* s,
                             GParamSpec* p);
static void __skk_engine___lambda8__g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self);
static void _skk_engine___lambda9_ (SkkEngine* self);
static void __skk_engine___lambda9__skk_candidate_list_populated (SkkCandidateList* _sender,
                                                           gpointer self);
static void _skk_engine___lambda10_ (SkkEngine* self);
static void __skk_engine___lambda10__g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self);
static void _skk_engine___lambda11_ (SkkEngine* self);
static void __skk_engine___lambda11__skk_candidate_list_selected (SkkCandidateList* _sender,
                                                           SkkCandidate* candidate,
                                                           gpointer self);
static gboolean __skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text (SkkContext* _sender,
                                                                                       gchar** text,
                                                                                       guint* cursor_pos,
                                                                                       gpointer self);
static gboolean __skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text (SkkContext* _sender,
                                                                                   gint offset,
                                                                                   guint nchars,
                                                                                   gpointer self);
static void skk_engine_finalize (GObject * obj);
static GType skk_engine_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry SKK_ENGINE_options[2] = {{"ibus", 'i', (gint) 0, G_OPTION_ARG_NONE, &skk_engine_ibus, N_ ("Component is executed by IBus"), NULL}, {NULL}};

static inline gpointer
skk_engine_get_instance_private (SkkEngine* self)
{
	return G_STRUCT_MEMBER_P (self, SkkEngine_private_offset);
}

static gboolean
_skk_engine_retrieve_surrounding_text (SkkEngine* self,
                                       gchar** text,
                                       guint* cursor_pos)
{
	gchar* _vala_text = NULL;
	guint _vala_cursor_pos = 0U;
	IBusText* _text = NULL;
	guint _cursor_pos = 0U;
	guint anchor_pos = 0U;
	IBusText* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ibus_engine_get_surrounding_text ((IBusEngine*) self, &_tmp0_, &_tmp1_, &_tmp2_);
	_text = _tmp0_;
	_cursor_pos = _tmp1_;
	anchor_pos = _tmp2_;
	_tmp3_ = _text->text;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_text);
	_vala_text = _tmp4_;
	_vala_cursor_pos = _cursor_pos;
	result = TRUE;
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	if (cursor_pos) {
		*cursor_pos = _vala_cursor_pos;
	}
	return result;
}

static gboolean
_skk_engine_delete_surrounding_text (SkkEngine* self,
                                     gint offset,
                                     guint nchars)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ibus_engine_delete_surrounding_text ((IBusEngine*) self, offset, nchars);
	result = TRUE;
	return result;
}

static void
skk_engine_populate_lookup_table (SkkEngine* self)
{
	IBusLookupTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->lookup_table;
	ibus_lookup_table_clear (_tmp0_);
	{
		gint i = 0;
		i = (gint) self->priv->page_start;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				SkkContext* _tmp3_;
				SkkCandidateList* _tmp4_;
				SkkCandidateList* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				IBusText* text = NULL;
				SkkContext* _tmp8_;
				SkkCandidateList* _tmp9_;
				SkkCandidateList* _tmp10_;
				SkkCandidate* _tmp11_;
				SkkCandidate* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				IBusText* _tmp15_;
				IBusText* _tmp16_;
				IBusLookupTable* _tmp17_;
				IBusText* _tmp18_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->context;
				_tmp4_ = skk_context_get_candidates (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = skk_candidate_list_get_size (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->context;
				_tmp9_ = skk_context_get_candidates (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = skk_candidate_list_get (_tmp10_, i);
				_tmp12_ = _tmp11_;
				_tmp13_ = skk_candidate_get_output (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = ibus_text_new_from_string (_tmp14_);
				g_object_ref_sink (_tmp15_);
				_tmp16_ = _tmp15_;
				_g_object_unref0 (_tmp12_);
				text = _tmp16_;
				_tmp17_ = self->priv->lookup_table;
				_tmp18_ = text;
				ibus_lookup_table_append_candidate (_tmp17_, _tmp18_);
				_g_object_unref0 (text);
			}
		}
	}
}

static void
skk_engine_set_lookup_table_cursor_pos (SkkEngine* self)
{
	IBusText* empty_text = NULL;
	IBusText* _tmp0_;
	gint cursor_pos = 0;
	SkkContext* _tmp1_;
	SkkCandidateList* _tmp2_;
	SkkCandidateList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	SkkContext* _tmp6_;
	SkkCandidateList* _tmp7_;
	SkkCandidateList* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ibus_text_new_from_static_string ("");
	g_object_ref_sink (_tmp0_);
	empty_text = _tmp0_;
	_tmp1_ = self->priv->context;
	_tmp2_ = skk_context_get_candidates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = skk_candidate_list_get_cursor_pos (_tmp3_);
	_tmp5_ = _tmp4_;
	cursor_pos = _tmp5_;
	_tmp6_ = self->priv->context;
	_tmp7_ = skk_context_get_candidates (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = skk_candidate_list_get_page_visible (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		IBusLookupTable* _tmp11_;
		SkkContext* _tmp12_;
		SkkCandidateList* _tmp13_;
		SkkCandidateList* _tmp14_;
		guint _tmp15_;
		guint _tmp16_;
		IBusLookupTable* _tmp17_;
		SkkCandidate* candidate = NULL;
		SkkContext* _tmp18_;
		SkkCandidateList* _tmp19_;
		SkkCandidateList* _tmp20_;
		SkkCandidate* _tmp21_;
		gboolean _tmp22_ = FALSE;
		_tmp11_ = self->priv->lookup_table;
		_tmp12_ = self->priv->context;
		_tmp13_ = skk_context_get_candidates (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = skk_candidate_list_get_page_start (_tmp14_);
		_tmp16_ = _tmp15_;
		ibus_lookup_table_set_cursor_pos (_tmp11_, cursor_pos - _tmp16_);
		_tmp17_ = self->priv->lookup_table;
		ibus_engine_update_lookup_table_fast ((IBusEngine*) self, _tmp17_, TRUE);
		_tmp18_ = self->priv->context;
		_tmp19_ = skk_context_get_candidates (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = skk_candidate_list_get (_tmp20_, -1);
		candidate = _tmp21_;
		if (self->priv->show_annotation) {
			SkkCandidate* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			_tmp23_ = candidate;
			_tmp24_ = skk_candidate_get_annotation (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp22_ = _tmp25_ != NULL;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			IBusText* text = NULL;
			SkkCandidate* _tmp26_;
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			IBusText* _tmp29_;
			IBusText* _tmp30_;
			_tmp26_ = candidate;
			_tmp27_ = skk_candidate_get_annotation (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = ibus_text_new_from_string (_tmp28_);
			g_object_ref_sink (_tmp29_);
			text = _tmp29_;
			_tmp30_ = text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp30_, TRUE);
			_g_object_unref0 (text);
		} else {
			IBusText* _tmp31_;
			_tmp31_ = empty_text;
			ibus_engine_update_auxiliary_text ((IBusEngine*) self, _tmp31_, FALSE);
		}
		self->priv->lookup_table_visible = TRUE;
		_g_object_unref0 (candidate);
	} else {
		if (self->priv->lookup_table_visible) {
			ibus_engine_hide_lookup_table ((IBusEngine*) self);
			ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
			self->priv->lookup_table_visible = FALSE;
		}
	}
	_g_object_unref0 (empty_text);
}

static void
skk_engine_update_preedit (SkkEngine* self)
{
	IBusText* text = NULL;
	SkkContext* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	IBusText* _tmp3_;
	guint underline_offset = 0U;
	guint underline_nchars = 0U;
	SkkContext* _tmp4_;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	IBusText* _tmp8_;
	IBusText* _tmp9_;
	IBusText* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_preedit (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ibus_text_new_from_string (_tmp2_);
	g_object_ref_sink (_tmp3_);
	text = _tmp3_;
	_tmp4_ = self->priv->context;
	skk_context_get_preedit_underline (_tmp4_, &_tmp5_, &_tmp6_);
	underline_offset = _tmp5_;
	underline_nchars = _tmp6_;
	if (((guint) 0) < underline_nchars) {
		IBusText* _tmp7_;
		_tmp7_ = text;
		ibus_text_append_attribute (_tmp7_, (guint) IBUS_ATTR_TYPE_UNDERLINE, (guint) IBUS_ATTR_UNDERLINE_SINGLE, (guint) ((gint) underline_offset), (gint) (underline_offset + underline_nchars));
	}
	_tmp8_ = text;
	_tmp9_ = text;
	_tmp10_ = text;
	ibus_engine_update_preedit_text ((IBusEngine*) self, _tmp8_, ibus_text_get_length (_tmp9_), ibus_text_get_length (_tmp10_) > ((guint) 0));
	_g_object_unref0 (text);
}

static void
skk_engine_update_candidates (SkkEngine* self)
{
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	SkkContext* _tmp3_;
	SkkCandidateList* _tmp4_;
	SkkCandidateList* _tmp5_;
	IBusLookupTable* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_set_page_start (_tmp2_, self->priv->page_start);
	_tmp3_ = self->priv->context;
	_tmp4_ = skk_context_get_candidates (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->lookup_table;
	skk_candidate_list_set_page_size (_tmp5_, ibus_lookup_table_get_page_size (_tmp6_));
	skk_engine_populate_lookup_table (self);
	skk_engine_set_lookup_table_cursor_pos (self);
}

static void
skk_engine_update_input_mode (SkkEngine* self)
{
	GeeMapIterator* iter = NULL;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_;
	IBusText* symbol = NULL;
	GeeMap* _tmp13_;
	SkkContext* _tmp14_;
	SkkInputMode _tmp15_;
	SkkInputMode _tmp16_;
	gpointer _tmp17_;
	gchar* _tmp18_;
	IBusText* _tmp19_;
	IBusText* _tmp20_;
	IBusText* label = NULL;
	IBusText* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	IBusText* _tmp25_;
	IBusText* _tmp26_;
	IBusProperty* _tmp27_;
	IBusText* _tmp28_;
	IBusProperty* _tmp29_;
	IBusText* _tmp30_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_mode_props;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		SkkInputMode input_mode = 0;
		GeeMapIterator* _tmp3_;
		gpointer _tmp4_;
		IBusProperty* prop = NULL;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		SkkContext* _tmp7_;
		SkkInputMode _tmp8_;
		SkkInputMode _tmp9_;
		_tmp2_ = iter;
		if (!gee_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = gee_map_iterator_get_key (_tmp3_);
		input_mode = (SkkInputMode) ((gintptr) _tmp4_);
		_tmp5_ = iter;
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
		prop = (IBusProperty*) _tmp6_;
		_tmp7_ = self->priv->context;
		_tmp8_ = skk_context_get_input_mode (_tmp7_);
		_tmp9_ = _tmp8_;
		if (input_mode == _tmp9_) {
			IBusProperty* _tmp10_;
			_tmp10_ = prop;
			ibus_property_set_state (_tmp10_, PROP_STATE_CHECKED);
		} else {
			IBusProperty* _tmp11_;
			_tmp11_ = prop;
			ibus_property_set_state (_tmp11_, PROP_STATE_UNCHECKED);
		}
		if (self->priv->properties_registered) {
			IBusProperty* _tmp12_;
			_tmp12_ = prop;
			ibus_engine_update_property ((IBusEngine*) self, _tmp12_);
		}
		_g_object_unref0 (prop);
	}
	_tmp13_ = self->priv->input_mode_symbols;
	_tmp14_ = self->priv->context;
	_tmp15_ = skk_context_get_input_mode (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = gee_map_get (_tmp13_, (gpointer) ((gintptr) _tmp16_));
	_tmp18_ = (gchar*) _tmp17_;
	_tmp19_ = ibus_text_new_from_string (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_tmp20_ = _tmp19_;
	_g_free0 (_tmp18_);
	symbol = _tmp20_;
	_tmp21_ = symbol;
	_tmp22_ = _tmp21_->text;
	_tmp23_ = g_strdup_printf (_ ("Input Mode (%s)"), _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = ibus_text_new_from_string (_tmp24_);
	g_object_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp24_);
	label = _tmp26_;
	_tmp27_ = self->priv->input_mode_prop;
	_tmp28_ = label;
	ibus_property_set_label (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->input_mode_prop;
	_tmp30_ = symbol;
	ibus_property_set_symbol (_tmp29_, _tmp30_);
	if (self->priv->properties_registered) {
		IBusProperty* _tmp31_;
		_tmp31_ = self->priv->input_mode_prop;
		ibus_engine_update_property ((IBusEngine*) self, _tmp31_);
	}
	_g_object_unref0 (label);
	_g_object_unref0 (symbol);
	_g_object_unref0 (iter);
}

static SkkDict*
skk_engine_parse_dict_from_plist (PList* plist,
                                  GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* encoding = NULL;
	gchar* _tmp3_;
	gchar* type = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	SkkDict* result;
	g_return_val_if_fail (plist != NULL, NULL);
	_tmp1_ = plist_get (plist, "encoding");
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("EUC-JP");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	encoding = _tmp3_;
	_tmp4_ = plist_get (plist, "type");
	type = _tmp4_;
	_tmp5_ = type;
	if (g_strcmp0 (_tmp5_, "file") == 0) {
		gchar* file = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* mode = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp6_ = plist_get (plist, "file");
		file = _tmp6_;
		_tmp7_ = file;
		if (_tmp7_ == NULL) {
			result = NULL;
			_g_free0 (file);
			_g_free0 (type);
			_g_free0 (encoding);
			_g_free0 (_tmp0_);
			return result;
		}
		_tmp9_ = plist_get (plist, "mode");
		_tmp8_ = _tmp9_;
		if (_tmp8_ == NULL) {
			gchar* _tmp10_;
			_tmp10_ = g_strdup ("readonly");
			_g_free0 (_tmp8_);
			_tmp8_ = _tmp10_;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		mode = _tmp11_;
		_tmp12_ = mode;
		if (g_strcmp0 (_tmp12_, "readonly") == 0) {
			const gchar* _tmp13_;
			_tmp13_ = file;
			if (g_str_has_suffix (_tmp13_, ".cdb")) {
				SkkCdbDict* _tmp14_ = NULL;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				SkkCdbDict* _tmp17_;
				SkkCdbDict* _tmp18_;
				_tmp15_ = file;
				_tmp16_ = encoding;
				_tmp17_ = skk_cdb_dict_new (_tmp15_, _tmp16_, &_inner_error0_);
				_tmp14_ = _tmp17_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (mode);
					_g_free0 (_tmp8_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp0_);
					return NULL;
				}
				_tmp18_ = _tmp14_;
				_tmp14_ = NULL;
				result = (SkkDict*) _tmp18_;
				_g_object_unref0 (_tmp14_);
				_g_free0 (mode);
				_g_free0 (_tmp8_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp0_);
				return result;
			} else {
				SkkFileDict* _tmp19_ = NULL;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				SkkFileDict* _tmp22_;
				SkkFileDict* _tmp23_;
				_tmp20_ = file;
				_tmp21_ = encoding;
				_tmp22_ = skk_file_dict_new (_tmp20_, _tmp21_, &_inner_error0_);
				_tmp19_ = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (mode);
					_g_free0 (_tmp8_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp0_);
					return NULL;
				}
				_tmp23_ = _tmp19_;
				_tmp19_ = NULL;
				result = (SkkDict*) _tmp23_;
				_g_object_unref0 (_tmp19_);
				_g_free0 (mode);
				_g_free0 (_tmp8_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp0_);
				return result;
			}
		} else {
			const gchar* _tmp24_;
			_tmp24_ = mode;
			if (g_strcmp0 (_tmp24_, "readwrite") == 0) {
				SkkUserDict* _tmp25_ = NULL;
				const gchar* _tmp26_;
				const gchar* _tmp27_;
				SkkUserDict* _tmp28_;
				SkkUserDict* _tmp29_;
				_tmp26_ = file;
				_tmp27_ = encoding;
				_tmp28_ = skk_user_dict_new (_tmp26_, _tmp27_, &_inner_error0_);
				_tmp25_ = _tmp28_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (mode);
					_g_free0 (_tmp8_);
					_g_free0 (file);
					_g_free0 (type);
					_g_free0 (encoding);
					_g_free0 (_tmp0_);
					return NULL;
				}
				_tmp29_ = _tmp25_;
				_tmp25_ = NULL;
				result = (SkkDict*) _tmp29_;
				_g_object_unref0 (_tmp25_);
				_g_free0 (mode);
				_g_free0 (_tmp8_);
				_g_free0 (file);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp0_);
				return result;
			}
		}
		_g_free0 (mode);
		_g_free0 (_tmp8_);
		_g_free0 (file);
	} else {
		const gchar* _tmp30_;
		_tmp30_ = type;
		if (g_strcmp0 (_tmp30_, "server") == 0) {
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* host = NULL;
			gchar* _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* port = NULL;
			gchar* _tmp38_;
			SkkSkkServ* _tmp39_ = NULL;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			SkkSkkServ* _tmp43_;
			SkkSkkServ* _tmp44_;
			_tmp32_ = plist_get (plist, "host");
			_tmp31_ = _tmp32_;
			if (_tmp31_ == NULL) {
				gchar* _tmp33_;
				_tmp33_ = g_strdup ("localhost");
				_g_free0 (_tmp31_);
				_tmp31_ = _tmp33_;
			}
			_tmp34_ = _tmp31_;
			_tmp31_ = NULL;
			host = _tmp34_;
			_tmp36_ = plist_get (plist, "port");
			_tmp35_ = _tmp36_;
			if (_tmp35_ == NULL) {
				gchar* _tmp37_;
				_tmp37_ = g_strdup ("1178");
				_g_free0 (_tmp35_);
				_tmp35_ = _tmp37_;
			}
			_tmp38_ = _tmp35_;
			_tmp35_ = NULL;
			port = _tmp38_;
			_tmp40_ = host;
			_tmp41_ = port;
			_tmp42_ = encoding;
			_tmp43_ = skk_skk_serv_new (_tmp40_, (guint16) atoi (_tmp41_), _tmp42_, &_inner_error0_);
			_tmp39_ = _tmp43_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (port);
				_g_free0 (_tmp35_);
				_g_free0 (host);
				_g_free0 (_tmp31_);
				_g_free0 (type);
				_g_free0 (encoding);
				_g_free0 (_tmp0_);
				return NULL;
			}
			_tmp44_ = _tmp39_;
			_tmp39_ = NULL;
			result = (SkkDict*) _tmp44_;
			_g_object_unref0 (_tmp39_);
			_g_free0 (port);
			_g_free0 (_tmp35_);
			_g_free0 (host);
			_g_free0 (_tmp31_);
			_g_free0 (type);
			_g_free0 (encoding);
			_g_free0 (_tmp0_);
			return result;
		}
	}
	result = NULL;
	_g_free0 (type);
	_g_free0 (encoding);
	_g_free0 (_tmp0_);
	return result;
}

static void
skk_engine_reload_dictionaries (void)
{
	GeeArrayList* _tmp0_;
	GVariant* variant = NULL;
	Preferences* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gchar** strv = NULL;
	GVariant* _tmp4_;
	gsize _tmp5_ = 0;
	gchar** _tmp6_;
	gint strv_length1;
	gint _strv_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	_tmp0_ = skk_engine_dictionaries;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = skk_engine_preferences;
	_tmp2_ = preferences_get (_tmp1_, "dictionaries");
	variant = _tmp2_;
	_tmp3_ = variant;
	_vala_assert (_tmp3_ != NULL, "variant != null");
	_tmp4_ = variant;
	_tmp6_ = g_variant_dup_strv (_tmp4_, &_tmp5_);
	strv = _tmp6_;
	strv_length1 = _tmp5_;
	_strv_size_ = strv_length1;
	_tmp7_ = strv;
	_tmp7__length1 = strv_length1;
	{
		gchar** str_collection = NULL;
		gint str_collection_length1 = 0;
		gint _str_collection_size_ = 0;
		gint str_it = 0;
		str_collection = _tmp7_;
		str_collection_length1 = _tmp7__length1;
		for (str_it = 0; str_it < str_collection_length1; str_it = str_it + 1) {
			gchar* _tmp8_;
			gchar* str = NULL;
			_tmp8_ = g_strdup (str_collection[str_it]);
			str = _tmp8_;
			{
				{
					PList* plist = NULL;
					const gchar* _tmp9_;
					PList* _tmp10_;
					SkkDict* dict = NULL;
					PList* _tmp11_;
					SkkDict* _tmp12_;
					SkkDict* _tmp13_;
					_tmp9_ = str;
					_tmp10_ = plist_new (_tmp9_, &_inner_error0_);
					plist = _tmp10_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == PLIST_PARSE_ERROR) {
							goto __catch0_plist_parse_error;
						}
						goto __catch0_g_error;
					}
					_tmp11_ = plist;
					_tmp12_ = skk_engine_parse_dict_from_plist (_tmp11_, &_inner_error0_);
					dict = _tmp12_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (plist);
						if (_inner_error0_->domain == PLIST_PARSE_ERROR) {
							goto __catch0_plist_parse_error;
						}
						goto __catch0_g_error;
					}
					_tmp13_ = dict;
					if (_tmp13_ != NULL) {
						GeeArrayList* _tmp14_;
						SkkDict* _tmp15_;
						_tmp14_ = skk_engine_dictionaries;
						_tmp15_ = dict;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
					}
					_g_object_unref0 (dict);
					_g_object_unref0 (plist);
				}
				goto __finally0;
				__catch0_plist_parse_error:
				{
					GError* e = NULL;
					const gchar* _tmp16_;
					GError* _tmp17_;
					const gchar* _tmp18_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp16_ = str;
					_tmp17_ = e;
					_tmp18_ = _tmp17_->message;
					g_warning ("engine.vala:293: can't parse plist \"%s\": %s", _tmp16_, _tmp18_);
					_g_error_free0 (e);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					const gchar* _tmp19_;
					GError* _tmp20_;
					const gchar* _tmp21_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp19_ = str;
					_tmp20_ = e;
					_tmp21_ = _tmp20_->message;
					g_warning ("engine.vala:296: can't open dictionary \"%s\": %s", _tmp19_, _tmp21_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (str);
					strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
					_g_variant_unref0 (variant);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_free0 (str);
			}
		}
	}
	strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
	_g_variant_unref0 (variant);
}

static void
skk_engine_apply_preferences (SkkEngine* self)
{
	GVariant* variant = NULL;
	Preferences* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	SkkContext* _tmp3_;
	GVariant* _tmp4_;
	gsize _tmp5_ = 0;
	const gchar** _tmp6_;
	const gchar** _tmp7_;
	gint _tmp7__length1;
	Preferences* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	SkkContext* _tmp11_;
	GVariant* _tmp12_;
	Preferences* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	IBusLookupTable* _tmp16_;
	GVariant* _tmp17_;
	Preferences* _tmp18_;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	Preferences* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	SkkContext* _tmp25_;
	GVariant* _tmp26_;
	Preferences* _tmp27_;
	GVariant* _tmp28_;
	GVariant* _tmp29_;
	GVariant* _tmp30_;
	Preferences* _tmp31_;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	SkkContext* _tmp34_;
	GVariant* _tmp35_;
	Preferences* _tmp36_;
	GVariant* _tmp37_;
	GVariant* _tmp38_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = skk_engine_preferences;
	_tmp1_ = preferences_get (_tmp0_, "auto_start_henkan_keywords");
	_g_variant_unref0 (variant);
	variant = _tmp1_;
	_tmp2_ = variant;
	_vala_assert (_tmp2_ != NULL, "variant != null");
	_tmp3_ = self->priv->context;
	_tmp4_ = variant;
	_tmp6_ = g_variant_get_strv (_tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	skk_context_set_auto_start_henkan_keywords (_tmp3_, _tmp7_, _tmp5_);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp8_ = skk_engine_preferences;
	_tmp9_ = preferences_get (_tmp8_, "period_style");
	_g_variant_unref0 (variant);
	variant = _tmp9_;
	_tmp10_ = variant;
	_vala_assert (_tmp10_ != NULL, "variant != null");
	_tmp11_ = self->priv->context;
	_tmp12_ = variant;
	skk_context_set_period_style (_tmp11_, (SkkPeriodStyle) g_variant_get_int32 (_tmp12_));
	_tmp13_ = skk_engine_preferences;
	_tmp14_ = preferences_get (_tmp13_, "page_size");
	_g_variant_unref0 (variant);
	variant = _tmp14_;
	_tmp15_ = variant;
	_vala_assert (_tmp15_ != NULL, "variant != null");
	_tmp16_ = self->priv->lookup_table;
	_tmp17_ = variant;
	ibus_lookup_table_set_page_size (_tmp16_, (guint) g_variant_get_int32 (_tmp17_));
	_tmp18_ = skk_engine_preferences;
	_tmp19_ = preferences_get (_tmp18_, "pagination_start");
	_g_variant_unref0 (variant);
	variant = _tmp19_;
	_tmp20_ = variant;
	_vala_assert (_tmp20_ != NULL, "variant != null");
	_tmp21_ = variant;
	self->priv->page_start = (guint) g_variant_get_int32 (_tmp21_);
	_tmp22_ = skk_engine_preferences;
	_tmp23_ = preferences_get (_tmp22_, "initial_input_mode");
	_g_variant_unref0 (variant);
	variant = _tmp23_;
	_tmp24_ = variant;
	_vala_assert (_tmp24_ != NULL, "variant != null");
	_tmp25_ = self->priv->context;
	_tmp26_ = variant;
	skk_context_set_input_mode (_tmp25_, (SkkInputMode) g_variant_get_int32 (_tmp26_));
	_tmp27_ = skk_engine_preferences;
	_tmp28_ = preferences_get (_tmp27_, "show_annotation");
	_g_variant_unref0 (variant);
	variant = _tmp28_;
	_tmp29_ = variant;
	_vala_assert (_tmp29_ != NULL, "variant != null");
	_tmp30_ = variant;
	self->priv->show_annotation = g_variant_get_boolean (_tmp30_);
	_tmp31_ = skk_engine_preferences;
	_tmp32_ = preferences_get (_tmp31_, "egg_like_newline");
	_g_variant_unref0 (variant);
	variant = _tmp32_;
	_tmp33_ = variant;
	_vala_assert (_tmp33_ != NULL, "variant != null");
	_tmp34_ = self->priv->context;
	_tmp35_ = variant;
	skk_context_set_egg_like_newline (_tmp34_, g_variant_get_boolean (_tmp35_));
	_tmp36_ = skk_engine_preferences;
	_tmp37_ = preferences_get (_tmp36_, "typing_rule");
	_g_variant_unref0 (variant);
	variant = _tmp37_;
	_tmp38_ = variant;
	_vala_assert (_tmp38_ != NULL, "variant != null");
	{
		SkkRule* _tmp39_ = NULL;
		GVariant* _tmp40_;
		const gchar* _tmp41_;
		SkkRule* _tmp42_;
		SkkContext* _tmp43_;
		_tmp40_ = variant;
		_tmp41_ = g_variant_get_string (_tmp40_, NULL);
		_tmp42_ = skk_rule_new (_tmp41_, &_inner_error0_);
		_tmp39_ = _tmp42_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
				goto __catch0_skk_rule_parse_error;
			}
			_g_variant_unref0 (variant);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp43_ = self->priv->context;
		skk_context_set_typing_rule (_tmp43_, _tmp39_);
		_g_object_unref0 (_tmp39_);
	}
	goto __finally0;
	__catch0_skk_rule_parse_error:
	{
		GError* e = NULL;
		GVariant* _tmp44_;
		const gchar* _tmp45_;
		GError* _tmp46_;
		const gchar* _tmp47_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = variant;
		_tmp45_ = g_variant_get_string (_tmp44_, NULL);
		_tmp46_ = e;
		_tmp47_ = _tmp46_->message;
		g_warning ("engine.vala:338: can't load typing rule %s: %s", _tmp45_, _tmp47_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_variant_unref0 (variant);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_variant_unref0 (variant);
}

static IBusProperty*
skk_engine_register_input_mode_property (SkkEngine* self,
                                         SkkInputMode mode,
                                         const gchar* name,
                                         const gchar* label,
                                         const gchar* symbol)
{
	IBusProperty* prop = NULL;
	IBusText* _tmp0_;
	IBusText* _tmp1_;
	IBusProperty* _tmp2_;
	IBusProperty* _tmp3_;
	GeeMap* _tmp4_;
	GeeMap* _tmp5_;
	GeeMap* _tmp6_;
	IBusProperty* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	_tmp0_ = ibus_text_new_from_string (label);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = ibus_property_new (name, PROP_TYPE_RADIO, _tmp1_, NULL, NULL, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	prop = _tmp3_;
	_tmp4_ = self->priv->input_mode_props;
	gee_map_set (_tmp4_, (gpointer) ((gintptr) mode), prop);
	_tmp5_ = self->priv->input_mode_symbols;
	gee_map_set (_tmp5_, (gpointer) ((gintptr) mode), symbol);
	_tmp6_ = self->priv->name_input_modes;
	gee_map_set (_tmp6_, name, (gpointer) ((gintptr) mode));
	result = prop;
	return result;
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
skk_engine_process_lookup_table_key_event (SkkEngine* self,
                                           guint keyval,
                                           guint keycode,
                                           guint state)
{
	guint page_size = 0U;
	IBusLookupTable* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lookup_table;
	page_size = ibus_lookup_table_get_page_size (_tmp0_);
	if (state == ((guint) 0)) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp2_ = g_unichar_to_string ((gunichar) keyval);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->LOOKUP_TABLE_LABELS;
		_tmp4__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
		_tmp1_ = _vala_string_array_contains (_tmp4_, _tmp4__length1, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* label = NULL;
		gchar* _tmp5_;
		_tmp5_ = g_unichar_to_string (g_unichar_tolower ((gunichar) keyval));
		label = _tmp5_;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gchar** _tmp8_;
					gint _tmp8__length1;
					gchar** _tmp9_;
					gint _tmp9__length1;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = index;
						index = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp8__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					if (!(index < MIN ((gint) page_size, _tmp8__length1))) {
						break;
					}
					_tmp9_ = self->priv->LOOKUP_TABLE_LABELS;
					_tmp9__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
					_tmp10_ = _tmp9_[index];
					_tmp11_ = label;
					if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
						SkkContext* _tmp12_;
						SkkCandidateList* _tmp13_;
						SkkCandidateList* _tmp14_;
						_tmp12_ = self->priv->context;
						_tmp13_ = skk_context_get_candidates (_tmp12_);
						_tmp14_ = _tmp13_;
						result = skk_candidate_list_select_at (_tmp14_, (guint) index);
						_g_free0 (label);
						return result;
					}
				}
			}
		}
		result = FALSE;
		_g_free0 (label);
		return result;
	}
	if (state == ((guint) 0)) {
		gboolean retval = FALSE;
		retval = FALSE;
		switch (keyval) {
			case IBUS_Page_Up:
			case IBUS_KP_Page_Up:
			{
				SkkContext* _tmp15_;
				SkkCandidateList* _tmp16_;
				SkkCandidateList* _tmp17_;
				_tmp15_ = self->priv->context;
				_tmp16_ = skk_context_get_candidates (_tmp15_);
				_tmp17_ = _tmp16_;
				retval = skk_candidate_list_page_up (_tmp17_);
				break;
			}
			case IBUS_Page_Down:
			case IBUS_KP_Page_Down:
			{
				SkkContext* _tmp18_;
				SkkCandidateList* _tmp19_;
				SkkCandidateList* _tmp20_;
				_tmp18_ = self->priv->context;
				_tmp19_ = skk_context_get_candidates (_tmp18_);
				_tmp20_ = _tmp19_;
				retval = skk_candidate_list_page_down (_tmp20_);
				break;
			}
			case IBUS_Up:
			case IBUS_Left:
			{
				SkkContext* _tmp21_;
				SkkCandidateList* _tmp22_;
				SkkCandidateList* _tmp23_;
				_tmp21_ = self->priv->context;
				_tmp22_ = skk_context_get_candidates (_tmp21_);
				_tmp23_ = _tmp22_;
				retval = skk_candidate_list_cursor_up (_tmp23_);
				break;
			}
			case IBUS_Down:
			case IBUS_Right:
			{
				SkkContext* _tmp24_;
				SkkCandidateList* _tmp25_;
				SkkCandidateList* _tmp26_;
				_tmp24_ = self->priv->context;
				_tmp25_ = skk_context_get_candidates (_tmp24_);
				_tmp26_ = _tmp25_;
				retval = skk_candidate_list_cursor_down (_tmp26_);
				break;
			}
			default:
			{
				break;
			}
		}
		if (retval) {
			skk_engine_set_lookup_table_cursor_pos (self);
			skk_engine_update_preedit (self);
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
skk_engine_real_process_key_event (IBusEngine* base,
                                   guint keyval,
                                   guint keycode,
                                   guint state)
{
	SkkEngine * self;
	guint _state = 0U;
	gboolean _tmp0_ = FALSE;
	SkkContext* _tmp1_;
	SkkCandidateList* _tmp2_;
	SkkCandidateList* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	SkkModifierType modifiers = 0U;
	SkkKeyEvent* key = NULL;
	gboolean retval = FALSE;
	SkkContext* _tmp11_;
	SkkKeyEvent* _tmp12_;
	gchar* output = NULL;
	SkkContext* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (SkkEngine*) base;
	_state = state & (((IBUS_CONTROL_MASK | IBUS_MOD1_MASK) | IBUS_MOD5_MASK) | IBUS_RELEASE_MASK);
	_tmp1_ = self->priv->context;
	_tmp2_ = skk_context_get_candidates (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = skk_candidate_list_get_page_visible (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp0_ = skk_engine_process_lookup_table_key_event (self, keyval, keycode, _state);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	modifiers = (SkkModifierType) _state;
	{
		SkkKeyEvent* _tmp6_ = NULL;
		SkkKeyEvent* _tmp7_;
		SkkKeyEvent* _tmp9_;
		_tmp7_ = skk_key_event_new_from_x_keysym (keyval, modifiers, &_inner_error0_);
		_tmp6_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp8_ = FALSE;
			if (_inner_error0_->domain == SKK_KEY_EVENT_FORMAT_ERROR) {
				goto __catch0_skk_key_event_format_error;
			}
			_g_object_unref0 (key);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
		_tmp9_ = _tmp6_;
		_tmp6_ = NULL;
		_g_object_unref0 (key);
		key = _tmp9_;
		_g_object_unref0 (_tmp6_);
	}
	goto __finally0;
	__catch0_skk_key_event_format_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_object_unref0 (key);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		_g_object_unref0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	_tmp11_ = self->priv->context;
	_tmp12_ = key;
	retval = skk_context_process_key_event (_tmp11_, _tmp12_);
	_tmp13_ = self->priv->context;
	_tmp14_ = skk_context_poll_output (_tmp13_);
	output = _tmp14_;
	_tmp15_ = output;
	_tmp16_ = strlen (_tmp15_);
	_tmp17_ = _tmp16_;
	if (_tmp17_ > 0) {
		IBusText* text = NULL;
		const gchar* _tmp18_;
		IBusText* _tmp19_;
		IBusText* _tmp20_;
		_tmp18_ = output;
		_tmp19_ = ibus_text_new_from_string (_tmp18_);
		g_object_ref_sink (_tmp19_);
		text = _tmp19_;
		_tmp20_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp20_);
		_g_object_unref0 (text);
	}
	result = retval;
	_g_free0 (output);
	_g_object_unref0 (key);
	return result;
}

static void
skk_engine_real_enable (IBusEngine* base)
{
	SkkEngine * self;
	SkkContext* _tmp0_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	ibus_engine_get_surrounding_text ((IBusEngine*) self, NULL, NULL, NULL);
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->enable (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}

static void
skk_engine_real_disable (IBusEngine* base)
{
	SkkEngine * self;
	self = (SkkEngine*) base;
	g_signal_emit_by_name ((IBusEngine*) self, "focus-out");
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->disable (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}

static void
skk_engine_real_reset (IBusEngine* base)
{
	SkkEngine * self;
	SkkContext* _tmp0_;
	IBusText* empty_text = NULL;
	IBusText* _tmp1_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	_tmp1_ = ibus_text_new_from_static_string ("");
	g_object_ref_sink (_tmp1_);
	empty_text = _tmp1_;
	ibus_engine_update_preedit_text ((IBusEngine*) self, empty_text, (guint) 0, FALSE);
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->reset (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
	_g_object_unref0 (empty_text);
}

static void
skk_engine_real_focus_in (IBusEngine* base)
{
	SkkEngine * self;
	IBusPropList* _tmp0_;
	self = (SkkEngine*) base;
	skk_engine_update_input_mode (self);
	_tmp0_ = self->priv->prop_list;
	ibus_engine_register_properties ((IBusEngine*) self, _tmp0_);
	self->priv->properties_registered = TRUE;
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->focus_in (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}

static void
skk_engine_real_focus_out (IBusEngine* base)
{
	SkkEngine * self;
	SkkContext* _tmp0_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	skk_context_reset (_tmp0_);
	ibus_engine_hide_preedit_text ((IBusEngine*) self);
	ibus_engine_hide_lookup_table ((IBusEngine*) self);
	self->priv->properties_registered = FALSE;
	IBUS_ENGINE_CLASS (skk_engine_parent_class)->focus_out (G_TYPE_CHECK_INSTANCE_CAST (self, IBUS_TYPE_ENGINE, IBusEngine));
}

static void
skk_engine_real_property_activate (IBusEngine* base,
                                   const gchar* prop_name,
                                   guint prop_state)
{
	SkkEngine * self;
	GError* _inner_error0_ = NULL;
	self = (SkkEngine*) base;
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "setup") == 0) {
		gchar* filename = NULL;
		gchar* _tmp0_;
		_tmp0_ = g_build_filename (LIBEXECDIR, "ibus-setup-skk", NULL);
		filename = _tmp0_;
		{
			const gchar* _tmp1_;
			_tmp1_ = filename;
			g_spawn_command_line_async (_tmp1_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_SPAWN_ERROR) {
					goto __catch0_g_spawn_error;
				}
				_g_free0 (filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		goto __finally0;
		__catch0_g_spawn_error:
		{
			GError* e = NULL;
			const gchar* _tmp2_;
			GError* _tmp3_;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = filename;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_warning ("engine.vala:495: can't spawn %s: %s", _tmp2_, _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (filename);
	} else {
		gboolean _tmp5_ = FALSE;
		if (g_str_has_prefix (prop_name, "InputMode.")) {
			_tmp5_ = prop_state == ((guint) PROP_STATE_CHECKED);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			SkkContext* _tmp6_;
			GeeMap* _tmp7_;
			gpointer _tmp8_;
			_tmp6_ = self->priv->context;
			_tmp7_ = self->priv->name_input_modes;
			_tmp8_ = gee_map_get (_tmp7_, prop_name);
			skk_context_set_input_mode (_tmp6_, (SkkInputMode) ((gintptr) _tmp8_));
		}
	}
}

static void
skk_engine_real_candidate_clicked (IBusEngine* base,
                                   guint index,
                                   guint button,
                                   guint state)
{
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_select_at (_tmp2_, index);
}

static void
skk_engine_real_cursor_up (IBusEngine* base)
{
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_cursor_up (_tmp2_);
}

static void
skk_engine_real_cursor_down (IBusEngine* base)
{
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_cursor_down (_tmp2_);
}

static void
skk_engine_real_page_up (IBusEngine* base)
{
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_page_up (_tmp2_);
}

static void
skk_engine_real_page_down (IBusEngine* base)
{
	SkkEngine * self;
	SkkContext* _tmp0_;
	SkkCandidateList* _tmp1_;
	SkkCandidateList* _tmp2_;
	self = (SkkEngine*) base;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_get_candidates (_tmp0_);
	_tmp2_ = _tmp1_;
	skk_candidate_list_page_down (_tmp2_);
}

static void
__lambda4_ (void)
{
	ibus_quit ();
}

static void
___lambda4__ibus_bus_disconnected (IBusBus* _sender,
                                   gpointer self)
{
	__lambda4_ ();
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda5_ (const gchar* name,
            GVariant* value)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	if (g_strcmp0 (name, "dictionaries") == 0) {
		skk_engine_reload_dictionaries ();
	}
}

static void
___lambda5__preferences_value_changed (Preferences* _sender,
                                       const gchar* name,
                                       GVariant* value,
                                       gpointer self)
{
	__lambda5_ (name, value);
}

static gint
skk_engine_main (gchar** args,
                 gint args_length1)
{
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusBus* bus = NULL;
	IBusBus* _tmp8_;
	IBusBus* _tmp9_;
	IBusBus* _tmp11_;
	IBusConfig* config = NULL;
	IBusBus* _tmp12_;
	IBusConfig* _tmp13_;
	IBusConfig* _tmp14_;
	IBusConfig* _tmp15_;
	Preferences* _tmp16_;
	GeeArrayList* _tmp17_;
	Preferences* _tmp18_;
	IBusFactory* factory = NULL;
	IBusBus* _tmp19_;
	GDBusConnection* _tmp20_;
	IBusFactory* _tmp21_;
	IBusFactory* _tmp22_;
	GError* _inner_error0_ = NULL;
	gint result;
	ibus_init ();
	skk_init ();
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = g_option_context_new ("- ibus skk");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, SKK_ENGINE_options, "ibus-skk");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = ibus_bus_new ();
	g_object_ref_sink (_tmp8_);
	bus = _tmp8_;
	_tmp9_ = bus;
	if (!ibus_bus_is_connected (_tmp9_)) {
		FILE* _tmp10_;
		_tmp10_ = stderr;
		fprintf (_tmp10_, "Can not connect to ibus-daemon!\n");
		result = 1;
		_g_object_unref0 (bus);
		_g_option_context_free0 (context);
		return result;
	}
	_tmp11_ = bus;
	g_signal_connect (_tmp11_, "disconnected", (GCallback) ___lambda4__ibus_bus_disconnected, NULL);
	_tmp12_ = bus;
	_tmp13_ = ibus_bus_get_config (_tmp12_);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	config = _tmp14_;
	_tmp15_ = config;
	_tmp16_ = preferences_new (_tmp15_);
	_g_object_unref0 (skk_engine_preferences);
	skk_engine_preferences = _tmp16_;
	_tmp17_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (skk_engine_dictionaries);
	skk_engine_dictionaries = _tmp17_;
	skk_engine_reload_dictionaries ();
	_tmp18_ = skk_engine_preferences;
	g_signal_connect (_tmp18_, "value-changed", (GCallback) ___lambda5__preferences_value_changed, NULL);
	_tmp19_ = bus;
	_tmp20_ = ibus_bus_get_connection (_tmp19_);
	_tmp21_ = ibus_factory_new (_tmp20_);
	g_object_ref_sink (_tmp21_);
	factory = _tmp21_;
	_tmp22_ = factory;
	ibus_factory_add_engine (_tmp22_, "skk", TYPE_SKK_ENGINE);
	if (skk_engine_ibus) {
		IBusBus* _tmp23_;
		_tmp23_ = bus;
		ibus_bus_request_name (_tmp23_, "org.freedesktop.IBus.SKK", (guint32) 0);
	} else {
		IBusComponent* component = NULL;
		IBusComponent* _tmp24_;
		IBusEngineDesc* engine = NULL;
		gchar* _tmp25_;
		gchar* _tmp26_;
		IBusEngineDesc* _tmp27_;
		IBusEngineDesc* _tmp28_;
		IBusComponent* _tmp29_;
		IBusEngineDesc* _tmp30_;
		IBusBus* _tmp31_;
		IBusComponent* _tmp32_;
		_tmp24_ = ibus_component_new ("org.freedesktop.IBus.SKK", N_ ("SKK"), PACKAGE_VERSION, "GPL", "Daiki Ueno <ueno@unixuser.org>", "http://code.google.com/p/ibus/", "", "ibus-skk");
		g_object_ref_sink (_tmp24_);
		component = _tmp24_;
		_tmp25_ = g_strdup_printf ("%s/icons/ibus-skk.svg", PACKAGE_DATADIR);
		_tmp26_ = _tmp25_;
		_tmp27_ = ibus_engine_desc_new ("skk", "SKK", "SKK Input Method", "ja", "GPL", "Daiki Ueno <ueno@unixuser.org>", _tmp26_, "us");
		g_object_ref_sink (_tmp27_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		engine = _tmp28_;
		_tmp29_ = component;
		_tmp30_ = engine;
		ibus_component_add_engine (_tmp29_, _tmp30_);
		_tmp31_ = bus;
		_tmp32_ = component;
		ibus_bus_register_component (_tmp31_, _tmp32_);
		_g_object_unref0 (engine);
		_g_object_unref0 (component);
	}
	ibus_main ();
	result = 0;
	_g_object_unref0 (factory);
	_g_object_unref0 (config);
	_g_object_unref0 (bus);
	_g_option_context_free0 (context);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return skk_engine_main (argv, argc);
}

SkkEngine*
skk_engine_construct (GType object_type)
{
	SkkEngine * self = NULL;
	self = (SkkEngine*) g_object_new (object_type, NULL);
	return self;
}

SkkEngine*
skk_engine_new (void)
{
	return skk_engine_construct (TYPE_SKK_ENGINE);
}

static void
_skk_engine___lambda6_ (SkkEngine* self,
                        const gchar* name,
                        GVariant* value)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	skk_engine_apply_preferences (self);
	if (g_strcmp0 (name, "dictionaries") == 0) {
		SkkContext* _tmp0_;
		GeeArrayList* _tmp1_;
		gint _tmp2_ = 0;
		gpointer* _tmp3_;
		SkkDict** _tmp4_;
		gint _tmp4__length1;
		_tmp0_ = self->priv->context;
		_tmp1_ = skk_engine_dictionaries;
		_tmp3_ = gee_collection_to_array ((GeeCollection*) _tmp1_, &_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp4__length1 = _tmp2_;
		skk_context_set_dictionaries (_tmp0_, _tmp4_, _tmp2_);
		_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	}
}

static void
__skk_engine___lambda6__preferences_value_changed (Preferences* _sender,
                                                   const gchar* name,
                                                   GVariant* value,
                                                   gpointer self)
{
	_skk_engine___lambda6_ ((SkkEngine*) self, name, value);
}

static void
_skk_engine___lambda7_ (SkkEngine* self)
{
	skk_engine_update_preedit (self);
}

static void
__skk_engine___lambda7__g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self)
{
	_skk_engine___lambda7_ ((SkkEngine*) self);
}

static void
_skk_engine___lambda8_ (SkkEngine* self,
                        GObject* s,
                        GParamSpec* p)
{
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	skk_engine_update_input_mode (self);
}

static void
__skk_engine___lambda8__g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self)
{
	_skk_engine___lambda8_ ((SkkEngine*) self, _sender, pspec);
}

static void
_skk_engine___lambda9_ (SkkEngine* self)
{
	skk_engine_populate_lookup_table (self);
}

static void
__skk_engine___lambda9__skk_candidate_list_populated (SkkCandidateList* _sender,
                                                      gpointer self)
{
	_skk_engine___lambda9_ ((SkkEngine*) self);
}

static void
_skk_engine___lambda10_ (SkkEngine* self)
{
	skk_engine_set_lookup_table_cursor_pos (self);
}

static void
__skk_engine___lambda10__g_object_notify (GObject* _sender,
                                          GParamSpec* pspec,
                                          gpointer self)
{
	_skk_engine___lambda10_ ((SkkEngine*) self);
}

static void
_skk_engine___lambda11_ (SkkEngine* self)
{
	gchar* output = NULL;
	SkkContext* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	_tmp0_ = self->priv->context;
	_tmp1_ = skk_context_poll_output (_tmp0_);
	output = _tmp1_;
	_tmp2_ = output;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		IBusText* text = NULL;
		const gchar* _tmp5_;
		IBusText* _tmp6_;
		IBusText* _tmp7_;
		_tmp5_ = output;
		_tmp6_ = ibus_text_new_from_string (_tmp5_);
		g_object_ref_sink (_tmp6_);
		text = _tmp6_;
		_tmp7_ = text;
		ibus_engine_commit_text ((IBusEngine*) self, _tmp7_);
		_g_object_unref0 (text);
	}
	if (self->priv->lookup_table_visible) {
		ibus_engine_hide_lookup_table ((IBusEngine*) self);
		ibus_engine_hide_auxiliary_text ((IBusEngine*) self);
		self->priv->lookup_table_visible = FALSE;
	}
	_g_free0 (output);
}

static void
__skk_engine___lambda11__skk_candidate_list_selected (SkkCandidateList* _sender,
                                                      SkkCandidate* candidate,
                                                      gpointer self)
{
	_skk_engine___lambda11_ ((SkkEngine*) self);
}

static gboolean
__skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text (SkkContext* _sender,
                                                                              gchar** text,
                                                                              guint* cursor_pos,
                                                                              gpointer self)
{
	gboolean result;
	result = _skk_engine_retrieve_surrounding_text ((SkkEngine*) self, text, cursor_pos);
	return result;
}

static gboolean
__skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text (SkkContext* _sender,
                                                                          gint offset,
                                                                          guint nchars,
                                                                          gpointer self)
{
	gboolean result;
	result = _skk_engine_delete_surrounding_text ((SkkEngine*) self, offset, nchars);
	return result;
}

static GObject *
skk_engine_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SkkEngine * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	IBusLookupTable* _tmp1_;
	IBusLookupTable* _tmp10_;
	IBusPropList* _tmp11_;
	IBusPropList* props = NULL;
	IBusPropList* _tmp12_;
	IBusProperty* prop = NULL;
	IBusProperty* _tmp13_;
	IBusPropList* _tmp14_;
	IBusProperty* _tmp15_;
	IBusProperty* _tmp16_;
	IBusPropList* _tmp17_;
	IBusProperty* _tmp18_;
	IBusProperty* _tmp19_;
	IBusPropList* _tmp20_;
	IBusProperty* _tmp21_;
	IBusProperty* _tmp22_;
	IBusPropList* _tmp23_;
	IBusProperty* _tmp24_;
	IBusProperty* _tmp25_;
	IBusPropList* _tmp26_;
	IBusProperty* _tmp27_;
	IBusText* _tmp28_;
	IBusText* _tmp29_;
	IBusText* _tmp30_;
	IBusText* _tmp31_;
	IBusPropList* _tmp32_;
	IBusProperty* _tmp33_;
	IBusPropList* _tmp34_;
	IBusProperty* _tmp35_;
	IBusProperty* _tmp36_;
	IBusProperty* _tmp37_;
	IBusText* _tmp38_;
	IBusText* _tmp39_;
	IBusText* _tmp40_;
	IBusText* _tmp41_;
	IBusProperty* _tmp42_;
	IBusPropList* _tmp43_;
	IBusProperty* _tmp44_;
	GeeArrayList* _tmp45_;
	gint _tmp46_ = 0;
	gpointer* _tmp47_;
	SkkDict** _tmp48_;
	gint _tmp48__length1;
	SkkContext* _tmp49_;
	Preferences* _tmp50_;
	SkkContext* _tmp51_;
	SkkContext* _tmp52_;
	SkkContext* _tmp53_;
	SkkCandidateList* _tmp54_;
	SkkCandidateList* _tmp55_;
	SkkContext* _tmp56_;
	SkkCandidateList* _tmp57_;
	SkkCandidateList* _tmp58_;
	SkkContext* _tmp59_;
	SkkCandidateList* _tmp60_;
	SkkCandidateList* _tmp61_;
	SkkContext* _tmp62_;
	SkkContext* _tmp63_;
	parent_class = G_OBJECT_CLASS (skk_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SKK_ENGINE, SkkEngine);
	_tmp0_ = self->priv->LOOKUP_TABLE_LABELS;
	_tmp0__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
	_tmp1_ = ibus_lookup_table_new ((guint) _tmp0__length1, (guint) 0, TRUE, FALSE);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->lookup_table);
	self->priv->lookup_table = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gchar** _tmp4_;
				gint _tmp4__length1;
				IBusText* text = NULL;
				gchar** _tmp5_;
				gint _tmp5__length1;
				const gchar* _tmp6_;
				IBusText* _tmp7_;
				IBusLookupTable* _tmp8_;
				IBusText* _tmp9_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp4__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				if (!(i < _tmp4__length1)) {
					break;
				}
				_tmp5_ = self->priv->LOOKUP_TABLE_LABELS;
				_tmp5__length1 = self->priv->LOOKUP_TABLE_LABELS_length1;
				_tmp6_ = _tmp5_[i];
				_tmp7_ = ibus_text_new_from_string (_tmp6_);
				g_object_ref_sink (_tmp7_);
				text = _tmp7_;
				_tmp8_ = self->priv->lookup_table;
				_tmp9_ = text;
				ibus_lookup_table_set_label (_tmp8_, (guint) i, _tmp9_);
				_g_object_unref0 (text);
			}
		}
	}
	_tmp10_ = self->priv->lookup_table;
	ibus_lookup_table_set_orientation (_tmp10_, (gint) IBUS_ORIENTATION_HORIZONTAL);
	_tmp11_ = ibus_prop_list_new ();
	g_object_ref_sink (_tmp11_);
	_g_object_unref0 (self->priv->prop_list);
	self->priv->prop_list = _tmp11_;
	_tmp12_ = ibus_prop_list_new ();
	g_object_ref_sink (_tmp12_);
	props = _tmp12_;
	_tmp13_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_HIRAGANA, "InputMode.Hiragana", _ ("Hiragana"), "あ");
	_g_object_unref0 (prop);
	prop = _tmp13_;
	_tmp14_ = props;
	_tmp15_ = prop;
	ibus_prop_list_append (_tmp14_, _tmp15_);
	_tmp16_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_KATAKANA, "InputMode.Katakana", _ ("Katakana"), "ア");
	_g_object_unref0 (prop);
	prop = _tmp16_;
	_tmp17_ = props;
	_tmp18_ = prop;
	ibus_prop_list_append (_tmp17_, _tmp18_);
	_tmp19_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_HANKAKU_KATAKANA, "InputMode.HankakuKatakana", _ ("Halfwidth Katakana"), "_ｱ");
	_g_object_unref0 (prop);
	prop = _tmp19_;
	_tmp20_ = props;
	_tmp21_ = prop;
	ibus_prop_list_append (_tmp20_, _tmp21_);
	_tmp22_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_LATIN, "InputMode.Latin", _ ("Latin"), "_A");
	_g_object_unref0 (prop);
	prop = _tmp22_;
	_tmp23_ = props;
	_tmp24_ = prop;
	ibus_prop_list_append (_tmp23_, _tmp24_);
	_tmp25_ = skk_engine_register_input_mode_property (self, SKK_INPUT_MODE_WIDE_LATIN, "InputMode.WideLatin", _ ("Wide Latin"), "Ａ");
	_g_object_unref0 (prop);
	prop = _tmp25_;
	_tmp26_ = props;
	_tmp27_ = prop;
	ibus_prop_list_append (_tmp26_, _tmp27_);
	_tmp28_ = ibus_text_new_from_string ("あ");
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	_tmp30_ = ibus_text_new_from_string (_ ("Switch input mode"));
	g_object_ref_sink (_tmp30_);
	_tmp31_ = _tmp30_;
	_tmp32_ = props;
	_tmp33_ = ibus_property_new ("InputMode", PROP_TYPE_MENU, _tmp29_, NULL, _tmp31_, TRUE, TRUE, PROP_STATE_UNCHECKED, _tmp32_);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (prop);
	prop = _tmp33_;
	_g_object_unref0 (_tmp31_);
	_g_object_unref0 (_tmp29_);
	_tmp34_ = self->priv->prop_list;
	_tmp35_ = prop;
	ibus_prop_list_append (_tmp34_, _tmp35_);
	_tmp36_ = prop;
	_tmp37_ = _g_object_ref0 (_tmp36_);
	_g_object_unref0 (self->priv->input_mode_prop);
	self->priv->input_mode_prop = _tmp37_;
	_tmp38_ = ibus_text_new_from_string (_ ("Setup"));
	g_object_ref_sink (_tmp38_);
	_tmp39_ = _tmp38_;
	_tmp40_ = ibus_text_new_from_string (_ ("Configure SKK"));
	g_object_ref_sink (_tmp40_);
	_tmp41_ = _tmp40_;
	_tmp42_ = ibus_property_new ("setup", PROP_TYPE_NORMAL, _tmp39_, "gtk-preferences", _tmp41_, TRUE, TRUE, PROP_STATE_UNCHECKED, NULL);
	g_object_ref_sink (_tmp42_);
	_g_object_unref0 (prop);
	prop = _tmp42_;
	_g_object_unref0 (_tmp41_);
	_g_object_unref0 (_tmp39_);
	_tmp43_ = self->priv->prop_list;
	_tmp44_ = prop;
	ibus_prop_list_append (_tmp43_, _tmp44_);
	_tmp45_ = skk_engine_dictionaries;
	_tmp47_ = gee_collection_to_array ((GeeCollection*) _tmp45_, &_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp48__length1 = _tmp46_;
	_tmp49_ = skk_context_new (_tmp48_, _tmp46_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp49_;
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_object_unref), NULL);
	skk_engine_apply_preferences (self);
	_tmp50_ = skk_engine_preferences;
	g_signal_connect_object (_tmp50_, "value-changed", (GCallback) __skk_engine___lambda6__preferences_value_changed, self, 0);
	_tmp51_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp51_, "notify::preedit", (GCallback) __skk_engine___lambda7__g_object_notify, self, 0);
	_tmp52_ = self->priv->context;
	g_signal_connect_object ((GObject*) _tmp52_, "notify::input-mode", (GCallback) __skk_engine___lambda8__g_object_notify, self, 0);
	_tmp53_ = self->priv->context;
	_tmp54_ = skk_context_get_candidates (_tmp53_);
	_tmp55_ = _tmp54_;
	g_signal_connect_object (_tmp55_, "populated", (GCallback) __skk_engine___lambda9__skk_candidate_list_populated, self, 0);
	_tmp56_ = self->priv->context;
	_tmp57_ = skk_context_get_candidates (_tmp56_);
	_tmp58_ = _tmp57_;
	g_signal_connect_object ((GObject*) _tmp58_, "notify::cursor-pos", (GCallback) __skk_engine___lambda10__g_object_notify, self, 0);
	_tmp59_ = self->priv->context;
	_tmp60_ = skk_context_get_candidates (_tmp59_);
	_tmp61_ = _tmp60_;
	g_signal_connect_object (_tmp61_, "selected", (GCallback) __skk_engine___lambda11__skk_candidate_list_selected, self, 0);
	skk_engine_update_candidates (self);
	skk_engine_update_input_mode (self);
	_tmp62_ = self->priv->context;
	g_signal_connect_object (_tmp62_, "retrieve-surrounding-text", (GCallback) __skk_engine_retrieve_surrounding_text_skk_context_retrieve_surrounding_text, self, 0);
	_tmp63_ = self->priv->context;
	g_signal_connect_object (_tmp63_, "delete-surrounding-text", (GCallback) __skk_engine_delete_surrounding_text_skk_context_delete_surrounding_text, self, 0);
	_g_object_unref0 (prop);
	_g_object_unref0 (props);
	return obj;
}

static void
skk_engine_class_init (SkkEngineClass * klass,
                       gpointer klass_data)
{
	skk_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SkkEngine_private_offset);
	((IBusEngineClass *) klass)->process_key_event = (gboolean (*) (IBusEngine*, guint, guint, guint)) skk_engine_real_process_key_event;
	((IBusEngineClass *) klass)->enable = (void (*) (IBusEngine*)) skk_engine_real_enable;
	((IBusEngineClass *) klass)->disable = (void (*) (IBusEngine*)) skk_engine_real_disable;
	((IBusEngineClass *) klass)->reset = (void (*) (IBusEngine*)) skk_engine_real_reset;
	((IBusEngineClass *) klass)->focus_in = (void (*) (IBusEngine*)) skk_engine_real_focus_in;
	((IBusEngineClass *) klass)->focus_out = (void (*) (IBusEngine*)) skk_engine_real_focus_out;
	((IBusEngineClass *) klass)->property_activate = (void (*) (IBusEngine*, const gchar*, guint)) skk_engine_real_property_activate;
	((IBusEngineClass *) klass)->candidate_clicked = (void (*) (IBusEngine*, guint, guint, guint)) skk_engine_real_candidate_clicked;
	((IBusEngineClass *) klass)->cursor_up = (void (*) (IBusEngine*)) skk_engine_real_cursor_up;
	((IBusEngineClass *) klass)->cursor_down = (void (*) (IBusEngine*)) skk_engine_real_cursor_down;
	((IBusEngineClass *) klass)->page_up = (void (*) (IBusEngine*)) skk_engine_real_page_up;
	((IBusEngineClass *) klass)->page_down = (void (*) (IBusEngine*)) skk_engine_real_page_down;
	G_OBJECT_CLASS (klass)->constructor = skk_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = skk_engine_finalize;
}

static void
skk_engine_instance_init (SkkEngine * self,
                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** _tmp17_;
	self->priv = skk_engine_get_instance_private (self);
	self->priv->properties_registered = FALSE;
	_tmp0_ = gee_hash_map_new (SKK_TYPE_INPUT_MODE, NULL, NULL, IBUS_TYPE_PROPERTY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->input_mode_props = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (SKK_TYPE_INPUT_MODE, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->input_mode_symbols = (GeeMap*) _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, SKK_TYPE_INPUT_MODE, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->name_input_modes = (GeeMap*) _tmp2_;
	_tmp3_ = g_strdup ("a");
	_tmp4_ = g_strdup ("s");
	_tmp5_ = g_strdup ("d");
	_tmp6_ = g_strdup ("f");
	_tmp7_ = g_strdup ("j");
	_tmp8_ = g_strdup ("k");
	_tmp9_ = g_strdup ("l");
	_tmp10_ = g_strdup ("q");
	_tmp11_ = g_strdup ("w");
	_tmp12_ = g_strdup ("e");
	_tmp13_ = g_strdup ("r");
	_tmp14_ = g_strdup ("u");
	_tmp15_ = g_strdup ("i");
	_tmp16_ = g_strdup ("o");
	_tmp17_ = g_new0 (gchar*, 14 + 1);
	_tmp17_[0] = _tmp3_;
	_tmp17_[1] = _tmp4_;
	_tmp17_[2] = _tmp5_;
	_tmp17_[3] = _tmp6_;
	_tmp17_[4] = _tmp7_;
	_tmp17_[5] = _tmp8_;
	_tmp17_[6] = _tmp9_;
	_tmp17_[7] = _tmp10_;
	_tmp17_[8] = _tmp11_;
	_tmp17_[9] = _tmp12_;
	_tmp17_[10] = _tmp13_;
	_tmp17_[11] = _tmp14_;
	_tmp17_[12] = _tmp15_;
	_tmp17_[13] = _tmp16_;
	self->priv->LOOKUP_TABLE_LABELS = _tmp17_;
	self->priv->LOOKUP_TABLE_LABELS_length1 = 14;
	self->priv->_LOOKUP_TABLE_LABELS_size_ = self->priv->LOOKUP_TABLE_LABELS_length1;
}

static void
skk_engine_finalize (GObject * obj)
{
	SkkEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SKK_ENGINE, SkkEngine);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->lookup_table);
	_g_object_unref0 (self->priv->input_mode_prop);
	_g_object_unref0 (self->priv->prop_list);
	_g_object_unref0 (self->priv->input_mode_props);
	_g_object_unref0 (self->priv->input_mode_symbols);
	_g_object_unref0 (self->priv->name_input_modes);
	self->priv->LOOKUP_TABLE_LABELS = (_vala_array_free (self->priv->LOOKUP_TABLE_LABELS, self->priv->LOOKUP_TABLE_LABELS_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (skk_engine_parent_class)->finalize (obj);
}

static GType
skk_engine_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SkkEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkEngine), 0, (GInstanceInitFunc) skk_engine_instance_init, NULL };
	GType skk_engine_type_id;
	skk_engine_type_id = g_type_register_static (IBUS_TYPE_ENGINE, "SkkEngine", &g_define_type_info, 0);
	SkkEngine_private_offset = g_type_add_instance_private (skk_engine_type_id, sizeof (SkkEnginePrivate));
	return skk_engine_type_id;
}

GType
skk_engine_get_type (void)
{
	static volatile gsize skk_engine_type_id__once = 0;
	if (g_once_init_enter (&skk_engine_type_id__once)) {
		GType skk_engine_type_id;
		skk_engine_type_id = skk_engine_get_type_once ();
		g_once_init_leave (&skk_engine_type_id__once, skk_engine_type_id);
	}
	return skk_engine_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

