/* emojierapp.c generated by valac 0.56.18, the Vala compiler
 * generated from emojierapp.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright (c) 2017 Peng Wu <alexepico@gmail.com>
 * Copyright (c) 2017-2021 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <config.h>
#include <stdio.h>
#include <gdk/gdkwayland.h>
#include <ibus.h>

#define IBUS_EMOJIER_BUTTON_CLOSE_BUTTON ((guint) 1000)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EMOJI_APPLICATION (emoji_application_get_type ())
#define EMOJI_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EMOJI_APPLICATION, EmojiApplication))
#define EMOJI_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EMOJI_APPLICATION, EmojiApplicationClass))
#define IS_EMOJI_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EMOJI_APPLICATION))
#define IS_EMOJI_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EMOJI_APPLICATION))
#define EMOJI_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EMOJI_APPLICATION, EmojiApplicationClass))

typedef struct _EmojiApplication EmojiApplication;
typedef struct _EmojiApplicationClass EmojiApplicationClass;
typedef struct _EmojiApplicationPrivate EmojiApplicationPrivate;

#define TYPE_IBUS_EMOJIER (ibus_emojier_get_type ())
#define IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IBUS_EMOJIER, IBusEmojier))
#define IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IBUS_EMOJIER, IBusEmojierClass))
#define IS_IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IBUS_EMOJIER))
#define IS_IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IBUS_EMOJIER))
#define IBUS_EMOJIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IBUS_EMOJIER, IBusEmojierClass))

typedef struct _IBusEmojier IBusEmojier;
typedef struct _IBusEmojierClass IBusEmojierClass;
enum  {
	EMOJI_APPLICATION_0_PROPERTY,
	EMOJI_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* emoji_application_properties[EMOJI_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))

struct _EmojiApplication {
	GtkApplication parent_instance;
	EmojiApplicationPrivate * priv;
};

struct _EmojiApplicationClass {
	GtkApplicationClass parent_class;
};

struct _EmojiApplicationPrivate {
	IBusEmojier* m_emojier;
	GSettings* m_settings_emoji;
	GApplicationCommandLine* m_command_line;
};

VALA_EXTERN gchar* emoji_font;
gchar* emoji_font = NULL;
VALA_EXTERN gchar* annotation_lang;
gchar* annotation_lang = NULL;
VALA_EXTERN gboolean partial_match;
gboolean partial_match = FALSE;
VALA_EXTERN gint partial_match_length;
gint partial_match_length = -1;
VALA_EXTERN gint partial_match_condition;
gint partial_match_condition = -1;
static gint EmojiApplication_private_offset;
static gpointer emoji_application_parent_class = NULL;

VALA_EXTERN GType emoji_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EmojiApplication, g_object_unref)
VALA_EXTERN GType ibus_emojier_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (IBusEmojier, g_object_unref)
static EmojiApplication* emoji_application_new (void);
static EmojiApplication* emoji_application_construct (GType object_type);
static void emoji_application_save_selected_string (EmojiApplication* self,
                                             const gchar* selected_string,
                                             gboolean cancelled);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void emoji_application_show_dialog (EmojiApplication* self,
                                    GApplicationCommandLine* command_line);
VALA_EXTERN void ibus_emojier_reset (IBusEmojier* self);
VALA_EXTERN void ibus_emojier_set_annotation (IBusEmojier* self,
                                  const gchar* annotation);
VALA_EXTERN void emoji_application_candidate_clicked_lookup_table (EmojiApplication* self,
                                                       guint index,
                                                       guint button,
                                                       guint state);
VALA_EXTERN guint ibus_emojier_get_number_of_candidates (IBusEmojier* self);
VALA_EXTERN void ibus_emojier_set_cursor_pos (IBusEmojier* self,
                                  guint cursor_pos);
VALA_EXTERN gboolean ibus_emojier_has_variants (IBusEmojier* self,
                                    guint index,
                                    gboolean need_commit_signal);
VALA_EXTERN gchar* ibus_emojier_get_current_candidate (IBusEmojier* self);
VALA_EXTERN void emoji_application_activate_dialog (EmojiApplication* self,
                                        GApplicationCommandLine* command_line);
static gint _emoji_application_command_line (EmojiApplication* self,
                                      GApplicationCommandLine* command_line);
VALA_EXTERN void ibus_emojier_set_emoji_font (const gchar* emoji_font);
VALA_EXTERN gboolean ibus_emojier_is_running (IBusEmojier* self);
VALA_EXTERN void ibus_emojier_present_centralize (IBusEmojier* self,
                                      GdkEvent* event);
static void _vala_GdkEvent_free (GdkEvent* self);
VALA_EXTERN void ibus_emojier_set_annotation_lang (const gchar* lang);
VALA_EXTERN void ibus_emojier_set_partial_match (gboolean has_partial_match);
VALA_EXTERN void ibus_emojier_set_partial_match_length (gint length);
VALA_EXTERN void ibus_emojier_set_partial_match_condition (gint condition);
VALA_EXTERN void ibus_emojier_set_favorites (gchar** unowned_favorites,
                                 gint unowned_favorites_length1,
                                 gchar** unowned_favorite_annotations,
                                 gint unowned_favorite_annotations_length1);
VALA_EXTERN void ibus_emojier_load_unicode_dict (void);
VALA_EXTERN IBusEmojier* ibus_emojier_new (gboolean is_wayland);
VALA_EXTERN IBusEmojier* ibus_emojier_construct (GType object_type,
                                     gboolean is_wayland);
static void ___lambda26_ (EmojiApplication* self,
                   guint i,
                   guint b,
                   guint s);
static void ____lambda26__ibus_emojier_candidate_clicked (IBusEmojier* _sender,
                                                   guint index,
                                                   guint button,
                                                   guint state,
                                                   gpointer self);
static void ___lambda27_ (EmojiApplication* self);
static void ____lambda27__ibus_emojier_cancel (IBusEmojier* _sender,
                                        gpointer self);
static void ___lambda28_ (EmojiApplication* self);
VALA_EXTERN gchar* ibus_emojier_get_selected_string (IBusEmojier* self);
static void ____lambda28__ibus_emojier_commit_text (IBusEmojier* _sender,
                                             const gchar* text,
                                             gpointer self);
static gint emoji_application_real_command_line (GApplication* base,
                                          GApplicationCommandLine* command_line);
static void emoji_application_real_shutdown (GApplication* base);
static gint emoji_application_main (gchar** args,
                             gint args_length1);
static void emoji_application_finalize (GObject * obj);
static GType emoji_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
emoji_application_get_instance_private (EmojiApplication* self)
{
	return G_STRUCT_MEMBER_P (self, EmojiApplication_private_offset);
}

static EmojiApplication*
emoji_application_construct (GType object_type)
{
	EmojiApplication * self = NULL;
	self = (EmojiApplication*) g_object_new (object_type, "application-id", "org.freedesktop.IBus.Panel.Emojier", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	g_application_set_inactivity_timeout ((GApplication*) self, (guint) 100000);
	return self;
}

static EmojiApplication*
emoji_application_new (void)
{
	return emoji_application_construct (TYPE_EMOJI_APPLICATION);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
emoji_application_save_selected_string (EmojiApplication* self,
                                        const gchar* selected_string,
                                        gboolean cancelled)
{
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	GtkClipboard* _tmp3_;
	GtkClipboard* _tmp4_;
	gchar** emojier_favorites = NULL;
	GSettings* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint emojier_favorites_length1;
	gint _emojier_favorites_size_;
	gboolean has_favorite = FALSE;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GApplicationCommandLine* _tmp13_;
	g_return_if_fail (self != NULL);
	if (cancelled) {
		GApplicationCommandLine* _tmp0_;
		_tmp0_ = self->priv->m_command_line;
		g_application_command_line_print (_tmp0_, "%s\n", _ ("Canceled to choose an emoji."));
		return;
	}
	g_return_if_fail (selected_string != NULL);
	_tmp1_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = clipboard;
	gtk_clipboard_set_text (_tmp3_, selected_string, -1);
	_tmp4_ = clipboard;
	gtk_clipboard_store (_tmp4_);
	_tmp5_ = self->priv->m_settings_emoji;
	_tmp7_ = _tmp6_ = g_settings_get_strv (_tmp5_, "favorites");
	emojier_favorites = _tmp7_;
	emojier_favorites_length1 = _vala_array_length (_tmp6_);
	_emojier_favorites_size_ = emojier_favorites_length1;
	has_favorite = FALSE;
	_tmp8_ = emojier_favorites;
	_tmp8__length1 = emojier_favorites_length1;
	{
		gchar** favorite_collection = NULL;
		gint favorite_collection_length1 = 0;
		gint _favorite_collection_size_ = 0;
		gint favorite_it = 0;
		favorite_collection = _tmp8_;
		favorite_collection_length1 = _tmp8__length1;
		for (favorite_it = 0; favorite_it < favorite_collection_length1; favorite_it = favorite_it + 1) {
			const gchar* favorite = NULL;
			favorite = favorite_collection[favorite_it];
			{
				const gchar* _tmp9_;
				_tmp9_ = favorite;
				if (g_strcmp0 (_tmp9_, selected_string) == 0) {
					has_favorite = TRUE;
					break;
				}
			}
		}
	}
	if (!has_favorite) {
		gchar* _tmp10_;
		GSettings* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		_tmp10_ = g_strdup (selected_string);
		_vala_array_add1 (&emojier_favorites, &emojier_favorites_length1, &_emojier_favorites_size_, _tmp10_);
		_tmp11_ = self->priv->m_settings_emoji;
		_tmp12_ = emojier_favorites;
		_tmp12__length1 = emojier_favorites_length1;
		g_settings_set_strv (_tmp11_, "favorites", _tmp12_);
	}
	_tmp13_ = self->priv->m_command_line;
	g_application_command_line_print (_tmp13_, "%s\n", _ ("Copied an emoji to your clipboard."));
	emojier_favorites = (_vala_array_free (emojier_favorites, emojier_favorites_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (clipboard);
}

static void
emoji_application_show_dialog (EmojiApplication* self,
                               GApplicationCommandLine* command_line)
{
	GApplicationCommandLine* _tmp0_;
	IBusEmojier* _tmp1_;
	IBusEmojier* _tmp2_;
	IBusEmojier* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command_line != NULL);
	_tmp0_ = _g_object_ref0 (command_line);
	_g_object_unref0 (self->priv->m_command_line);
	self->priv->m_command_line = _tmp0_;
	_tmp1_ = self->priv->m_emojier;
	ibus_emojier_reset (_tmp1_);
	_tmp2_ = self->priv->m_emojier;
	ibus_emojier_set_annotation (_tmp2_, "");
	_tmp3_ = self->priv->m_emojier;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
}

void
emoji_application_candidate_clicked_lookup_table (EmojiApplication* self,
                                                  guint index,
                                                  guint button,
                                                  guint state)
{
	GApplicationCommandLine* _tmp0_;
	IBusEmojier* _tmp2_;
	gboolean show_candidate = FALSE;
	guint ncandidates = 0U;
	IBusEmojier* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gchar* emoji = NULL;
	IBusEmojier* _tmp7_;
	gchar* _tmp8_;
	IBusEmojier* _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_command_line;
	if (_tmp0_ == NULL) {
		return;
	}
	if (button == IBUS_EMOJIER_BUTTON_CLOSE_BUTTON) {
		IBusEmojier* _tmp1_;
		_tmp1_ = self->priv->m_emojier;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
		emoji_application_save_selected_string (self, NULL, TRUE);
		_g_object_unref0 (self->priv->m_command_line);
		self->priv->m_command_line = NULL;
		return;
	}
	_tmp2_ = self->priv->m_emojier;
	if (_tmp2_ == NULL) {
		return;
	}
	show_candidate = FALSE;
	_tmp3_ = self->priv->m_emojier;
	ncandidates = ibus_emojier_get_number_of_candidates (_tmp3_);
	if (ncandidates > ((guint) 0)) {
		_tmp4_ = ncandidates >= index;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		IBusEmojier* _tmp5_;
		IBusEmojier* _tmp6_;
		_tmp5_ = self->priv->m_emojier;
		ibus_emojier_set_cursor_pos (_tmp5_, index);
		_tmp6_ = self->priv->m_emojier;
		show_candidate = ibus_emojier_has_variants (_tmp6_, index, FALSE);
	} else {
		return;
	}
	if (show_candidate) {
		return;
	}
	_tmp7_ = self->priv->m_emojier;
	_tmp8_ = ibus_emojier_get_current_candidate (_tmp7_);
	emoji = _tmp8_;
	_tmp9_ = self->priv->m_emojier;
	gtk_widget_hide ((GtkWidget*) _tmp9_);
	_tmp10_ = emoji;
	emoji_application_save_selected_string (self, _tmp10_, FALSE);
	_g_object_unref0 (self->priv->m_command_line);
	self->priv->m_command_line = NULL;
	_g_free0 (emoji);
}

void
emoji_application_activate_dialog (EmojiApplication* self,
                                   GApplicationCommandLine* command_line)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (command_line != NULL);
	g_application_hold ((GApplication*) self);
	emoji_application_show_dialog (self, command_line);
	g_application_release ((GApplication*) self);
}

static void
_vala_GdkEvent_free (GdkEvent* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}

static void
___lambda26_ (EmojiApplication* self,
              guint i,
              guint b,
              guint s)
{
	emoji_application_candidate_clicked_lookup_table (self, i, b, s);
}

static void
____lambda26__ibus_emojier_candidate_clicked (IBusEmojier* _sender,
                                              guint index,
                                              guint button,
                                              guint state,
                                              gpointer self)
{
	___lambda26_ ((EmojiApplication*) self, index, button, state);
}

static void
___lambda27_ (EmojiApplication* self)
{
	GApplicationCommandLine* _tmp0_;
	IBusEmojier* _tmp1_;
	_tmp0_ = self->priv->m_command_line;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_emojier;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	emoji_application_save_selected_string (self, NULL, TRUE);
	_g_object_unref0 (self->priv->m_command_line);
	self->priv->m_command_line = NULL;
}

static void
____lambda27__ibus_emojier_cancel (IBusEmojier* _sender,
                                   gpointer self)
{
	___lambda27_ ((EmojiApplication*) self);
}

static void
___lambda28_ (EmojiApplication* self)
{
	GApplicationCommandLine* _tmp0_;
	IBusEmojier* _tmp1_;
	gchar* selected_string = NULL;
	IBusEmojier* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	_tmp0_ = self->priv->m_command_line;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_emojier;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->m_emojier;
	_tmp3_ = ibus_emojier_get_selected_string (_tmp2_);
	selected_string = _tmp3_;
	_tmp4_ = selected_string;
	emoji_application_save_selected_string (self, _tmp4_, FALSE);
	_g_object_unref0 (self->priv->m_command_line);
	self->priv->m_command_line = NULL;
	_g_free0 (selected_string);
}

static void
____lambda28__ibus_emojier_commit_text (IBusEmojier* _sender,
                                        const gchar* text,
                                        gpointer self)
{
	___lambda28_ ((EmojiApplication*) self);
}

static gint
_emoji_application_command_line (EmojiApplication* self,
                                 GApplicationCommandLine* command_line)
{
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	static const GOptionEntry options[6] = {{"font", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &emoji_font, N_ ("\"FONT\" for emoji characters on emoji dialog"), N_ ("FONT")}, {"lang", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, &annotation_lang, N_ ("\"LANG\" for annotations on emoji dialog. E.g. \"en\""), N_ ("LANG")}, {"partial-match", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &partial_match, N_ ("Emoji annotations can be match partially"), NULL}, {"partial-match-length", (gchar) 0, (gint) 0, G_OPTION_ARG_INT, &partial_match_length, N_ ("Match with the length of the specified integer"), NULL}, {"partial-match-condition", (gchar) 0, (gint) 0, G_OPTION_ARG_INT, &partial_match_condition, N_ ("Match with the condition of the specified integer"), NULL}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp3_;
	GOptionContext* _tmp4_;
	gchar** args = NULL;
	gint _tmp5_ = 0;
	gchar** _tmp6_;
	gint args_length1;
	gint _args_size_;
	const gchar** _args = NULL;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _args_length1;
	gint __args_size_;
	gboolean _tmp22_ = FALSE;
	IBusEmojier* _tmp23_;
	const gchar* _tmp31_;
	const gchar* _tmp34_;
	const gchar* _tmp38_;
	GSettings* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	GSettings* _tmp44_;
	gchar** _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	IBusEmojier* _tmp48_;
	GError* _inner_error0_ = NULL;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_string (_tmp0_, "font");
	_tmp2_ = _tmp1_;
	ibus_emojier_set_emoji_font (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_option_context_new (NULL);
	option = _tmp3_;
	_tmp4_ = option;
	g_option_context_add_main_entries (_tmp4_, options, GETTEXT_PACKAGE);
	_tmp6_ = g_application_command_line_get_arguments (command_line, &_tmp5_);
	args = _tmp6_;
	args_length1 = _tmp5_;
	_args_size_ = args_length1;
	_tmp7_ = args;
	_tmp7__length1 = args_length1;
	_tmp8_ = g_new0 (gchar*, _tmp7__length1 + 1);
	_args = _tmp8_;
	_args_length1 = _tmp7__length1;
	__args_size_ = _args_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gchar** _tmp11_;
				gint _tmp11__length1;
				const gchar** _tmp12_;
				gint _tmp12__length1;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = args;
				_tmp11__length1 = args_length1;
				if (!(i < _tmp11__length1)) {
					break;
				}
				_tmp12_ = _args;
				_tmp12__length1 = _args_length1;
				_tmp13_ = args;
				_tmp13__length1 = args_length1;
				_tmp14_ = _tmp13_[i];
				_tmp12_[i] = _tmp14_;
			}
		}
	}
	_g_free0 (emoji_font);
	emoji_font = NULL;
	_g_free0 (annotation_lang);
	annotation_lang = NULL;
	{
		gchar** tmp = NULL;
		const gchar** _tmp15_;
		gint _tmp15__length1;
		gint tmp_length1;
		gint _tmp_size_;
		GOptionContext* _tmp16_;
		_tmp15_ = _args;
		_tmp15__length1 = _args_length1;
		tmp = _tmp15_;
		tmp_length1 = _tmp15__length1;
		_tmp_size_ = tmp_length1;
		_tmp16_ = option;
		g_option_context_parse (_tmp16_, (gint*) (&tmp_length1), &tmp, &_inner_error0_);
		_tmp_size_ = tmp_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp17_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_args = (g_free (_args), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp17_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp18_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = stderr;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		fprintf (_tmp18_, "%s\n", _tmp20_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp21_ = -1;
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp21_;
	}
	_tmp23_ = self->priv->m_emojier;
	if (_tmp23_ != NULL) {
		IBusEmojier* _tmp24_;
		_tmp24_ = self->priv->m_emojier;
		_tmp22_ = ibus_emojier_is_running (_tmp24_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		GdkEvent* event = NULL;
		GdkEvent* _tmp25_;
		GdkEvent* _tmp26_;
		GdkEventKey* _tmp27_;
		GdkEventKey* _tmp28_;
		IBusEmojier* _tmp29_;
		GdkEvent* _tmp30_;
		_tmp25_ = gdk_event_new (GDK_KEY_PRESS);
		event = _tmp25_;
		_tmp26_ = event;
		_tmp27_ = (GdkEventKey *) (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp28_->time = (guint32) GDK_CURRENT_TIME;
		_tmp29_ = self->priv->m_emojier;
		_tmp30_ = event;
		ibus_emojier_present_centralize (_tmp29_, _tmp30_);
		result = EXIT_SUCCESS;
		__vala_GdkEvent_free0 (event);
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp31_ = annotation_lang;
	if (_tmp31_ == NULL) {
		GSettings* _tmp32_;
		gchar* _tmp33_;
		_tmp32_ = self->priv->m_settings_emoji;
		_tmp33_ = g_settings_get_string (_tmp32_, "lang");
		_g_free0 (annotation_lang);
		annotation_lang = _tmp33_;
	}
	_tmp34_ = annotation_lang;
	ibus_emojier_set_annotation_lang (_tmp34_);
	ibus_emojier_set_partial_match (partial_match);
	if (partial_match_length > 0) {
		ibus_emojier_set_partial_match_length (partial_match_length);
	} else {
		GSettings* _tmp35_;
		_tmp35_ = self->priv->m_settings_emoji;
		ibus_emojier_set_partial_match_length (g_settings_get_int (_tmp35_, "partial-match-length"));
	}
	if (partial_match_condition > 2) {
		GSettings* _tmp36_;
		g_warning ("emojierapp.vala:190: Need condition between 0 and 2.");
		_tmp36_ = self->priv->m_settings_emoji;
		ibus_emojier_set_partial_match_condition (g_settings_get_int (_tmp36_, "partial-match-condition"));
	} else {
		if (partial_match_condition >= 0) {
			ibus_emojier_set_partial_match_condition (partial_match_condition);
		} else {
			GSettings* _tmp37_;
			_tmp37_ = self->priv->m_settings_emoji;
			ibus_emojier_set_partial_match_condition (g_settings_get_int (_tmp37_, "partial-match-condition"));
		}
	}
	_tmp38_ = emoji_font;
	if (_tmp38_ != NULL) {
		const gchar* _tmp39_;
		_tmp39_ = emoji_font;
		ibus_emojier_set_emoji_font (_tmp39_);
	}
	_tmp40_ = self->priv->m_settings_emoji;
	_tmp42_ = _tmp41_ = g_settings_get_strv (_tmp40_, "favorites");
	_tmp43_ = _tmp42_;
	_tmp43__length1 = _vala_array_length (_tmp41_);
	_tmp44_ = self->priv->m_settings_emoji;
	_tmp46_ = _tmp45_ = g_settings_get_strv (_tmp44_, "favorite-annotations");
	_tmp47_ = _tmp46_;
	_tmp47__length1 = _vala_array_length (_tmp45_);
	ibus_emojier_set_favorites (_tmp43_, (gint) _vala_array_length (_tmp41_), _tmp47_, (gint) _vala_array_length (_tmp45_));
	_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
	ibus_emojier_load_unicode_dict ();
	_tmp48_ = self->priv->m_emojier;
	if (_tmp48_ == NULL) {
		gboolean is_wayland = FALSE;
		GType instance_type = 0UL;
		GdkDisplay* _tmp49_;
		GType wayland_type = 0UL;
		IBusEmojier* _tmp50_;
		IBusEmojier* _tmp51_;
		IBusEmojier* _tmp52_;
		IBusEmojier* _tmp53_;
		IBusEmojier* _tmp54_;
		is_wayland = FALSE;
		_tmp49_ = gdk_display_get_default ();
		instance_type = G_TYPE_FROM_INSTANCE ((GObject*) _tmp49_);
		wayland_type = gdk_wayland_display_get_type ();
		is_wayland = g_type_is_a (instance_type, wayland_type);
		_tmp50_ = ibus_emojier_new (is_wayland);
		g_object_ref_sink (_tmp50_);
		_g_object_unref0 (self->priv->m_emojier);
		self->priv->m_emojier = _tmp50_;
		_tmp51_ = self->priv->m_emojier;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp51_);
		_tmp52_ = self->priv->m_emojier;
		g_signal_connect_object (_tmp52_, "candidate-clicked", (GCallback) ____lambda26__ibus_emojier_candidate_clicked, self, 0);
		_tmp53_ = self->priv->m_emojier;
		g_signal_connect_object (_tmp53_, "cancel", (GCallback) ____lambda27__ibus_emojier_cancel, self, 0);
		_tmp54_ = self->priv->m_emojier;
		g_signal_connect_object (_tmp54_, "commit-text", (GCallback) ____lambda28__ibus_emojier_commit_text, self, 0);
	}
	emoji_application_activate_dialog (self, command_line);
	result = EXIT_SUCCESS;
	_args = (g_free (_args), NULL);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_option_context_free0 (option);
	return result;
}

static gint
emoji_application_real_command_line (GApplication* base,
                                     GApplicationCommandLine* command_line)
{
	EmojiApplication * self;
	gint _result_ = 0;
	gint result;
	self = (EmojiApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	g_application_hold ((GApplication*) self);
	_result_ = _emoji_application_command_line (self, command_line);
	g_application_release ((GApplication*) self);
	result = _result_;
	return result;
}

static void
emoji_application_real_shutdown (GApplication* base)
{
	EmojiApplication * self;
	IBusEmojier* _tmp0_;
	self = (EmojiApplication*) base;
	G_APPLICATION_CLASS (emoji_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	_tmp0_ = self->priv->m_emojier;
	gtk_application_remove_window ((GtkApplication*) self, (GtkWindow*) _tmp0_);
	_g_object_unref0 (self->priv->m_emojier);
	self->priv->m_emojier = NULL;
}

static gint
emoji_application_main (gchar** args,
                        gint args_length1)
{
	EmojiApplication* app = NULL;
	EmojiApplication* _tmp0_;
	gint status = 0;
	gint result;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	ibus_init ();
	gtk_init ((gint*) (&args_length1), &args);
	_tmp0_ = emoji_application_new ();
	app = _tmp0_;
	status = g_application_run ((GApplication*) app, (gint) args_length1, args);
	result = status;
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return emoji_application_main (argv, argc);
}

static void
emoji_application_class_init (EmojiApplicationClass * klass,
                              gpointer klass_data)
{
	emoji_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EmojiApplication_private_offset);
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) emoji_application_real_command_line;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) emoji_application_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = emoji_application_finalize;
}

static void
emoji_application_instance_init (EmojiApplication * self,
                                 gpointer klass)
{
	GSettings* _tmp0_;
	self->priv = emoji_application_get_instance_private (self);
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.panel.emoji");
	self->priv->m_settings_emoji = _tmp0_;
	self->priv->m_command_line = NULL;
}

static void
emoji_application_finalize (GObject * obj)
{
	EmojiApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EMOJI_APPLICATION, EmojiApplication);
	_g_object_unref0 (self->priv->m_emojier);
	_g_object_unref0 (self->priv->m_settings_emoji);
	_g_object_unref0 (self->priv->m_command_line);
	G_OBJECT_CLASS (emoji_application_parent_class)->finalize (obj);
}

static GType
emoji_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EmojiApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) emoji_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EmojiApplication), 0, (GInstanceInitFunc) emoji_application_instance_init, NULL };
	GType emoji_application_type_id;
	emoji_application_type_id = g_type_register_static (gtk_application_get_type (), "EmojiApplication", &g_define_type_info, 0);
	EmojiApplication_private_offset = g_type_add_instance_private (emoji_application_type_id, sizeof (EmojiApplicationPrivate));
	return emoji_application_type_id;
}

GType
emoji_application_get_type (void)
{
	static volatile gsize emoji_application_type_id__once = 0;
	if (g_once_init_enter (&emoji_application_type_id__once)) {
		GType emoji_application_type_id;
		emoji_application_type_id = emoji_application_get_type_once ();
		g_once_init_leave (&emoji_application_type_id__once, emoji_application_type_id);
	}
	return emoji_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

