#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1912
#define LARGE_STATE_COUNT 38
#define SYMBOL_COUNT 278
#define ALIAS_COUNT 8
#define TOKEN_COUNT 120
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 36
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 119

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_LF = 2,
  anon_sym_SEMI = 3,
  anon_sym_NULL = 4,
  anon_sym_package = 5,
  anon_sym_import = 6,
  anon_sym_DOT = 7,
  sym_blank_identifier = 8,
  anon_sym_LPAREN = 9,
  anon_sym_RPAREN = 10,
  anon_sym_const = 11,
  anon_sym_COMMA = 12,
  anon_sym_EQ = 13,
  anon_sym_var = 14,
  anon_sym_func = 15,
  anon_sym_LBRACK = 16,
  anon_sym_RBRACK = 17,
  anon_sym_DOT_DOT_DOT = 18,
  anon_sym_type = 19,
  anon_sym_STAR = 20,
  anon_sym_struct = 21,
  anon_sym_PIPE = 22,
  anon_sym_TILDE = 23,
  anon_sym_LBRACE = 24,
  anon_sym_RBRACE = 25,
  anon_sym_interface = 26,
  anon_sym_map = 27,
  anon_sym_chan = 28,
  anon_sym_LT_DASH = 29,
  anon_sym_COLON_EQ = 30,
  anon_sym_PLUS_PLUS = 31,
  anon_sym_DASH_DASH = 32,
  anon_sym_STAR_EQ = 33,
  anon_sym_SLASH_EQ = 34,
  anon_sym_PERCENT_EQ = 35,
  anon_sym_LT_LT_EQ = 36,
  anon_sym_GT_GT_EQ = 37,
  anon_sym_AMP_EQ = 38,
  anon_sym_AMP_CARET_EQ = 39,
  anon_sym_PLUS_EQ = 40,
  anon_sym_DASH_EQ = 41,
  anon_sym_PIPE_EQ = 42,
  anon_sym_CARET_EQ = 43,
  anon_sym_COLON = 44,
  anon_sym_fallthrough = 45,
  anon_sym_break = 46,
  anon_sym_continue = 47,
  anon_sym_goto = 48,
  anon_sym_return = 49,
  anon_sym_go = 50,
  anon_sym_defer = 51,
  anon_sym_if = 52,
  anon_sym_else = 53,
  anon_sym_for = 54,
  anon_sym_range = 55,
  anon_sym_switch = 56,
  anon_sym_case = 57,
  anon_sym_default = 58,
  anon_sym_select = 59,
  anon_sym_new = 60,
  anon_sym_make = 61,
  anon_sym_PLUS = 62,
  anon_sym_DASH = 63,
  anon_sym_BANG = 64,
  anon_sym_CARET = 65,
  anon_sym_AMP = 66,
  anon_sym_SLASH = 67,
  anon_sym_PERCENT = 68,
  anon_sym_LT_LT = 69,
  anon_sym_GT_GT = 70,
  anon_sym_AMP_CARET = 71,
  anon_sym_EQ_EQ = 72,
  anon_sym_BANG_EQ = 73,
  anon_sym_LT = 74,
  anon_sym_LT_EQ = 75,
  anon_sym_GT = 76,
  anon_sym_GT_EQ = 77,
  anon_sym_AMP_AMP = 78,
  anon_sym_PIPE_PIPE = 79,
  sym_raw_string_literal = 80,
  anon_sym_DQUOTE = 81,
  anon_sym_DQUOTE2 = 82,
  sym__interpreted_string_literal_basic_content = 83,
  sym_escape_sequence = 84,
  sym_int_literal = 85,
  sym_float_literal = 86,
  sym_imaginary_literal = 87,
  sym_rune_literal = 88,
  sym_nil = 89,
  sym_true = 90,
  sym_false = 91,
  sym_iota = 92,
  sym_comment = 93,
  anon_sym_templ = 94,
  anon_sym_AT = 95,
  anon_sym_LBRACE_BANG = 96,
  anon_sym_children_DOT_DOT_DOT = 97,
  anon_sym_LT_SLASH = 98,
  anon_sym_SLASH_GT = 99,
  anon_sym_LT_BANG = 100,
  anon_sym_html = 101,
  anon_sym_style = 102,
  anon_sym_if2 = 103,
  anon_sym_else2 = 104,
  anon_sym_css = 105,
  sym_css_property_name = 106,
  anon_sym_script = 107,
  sym_element_identifier = 108,
  sym_attribute_name = 109,
  sym_attribute_value = 110,
  anon_sym_SQUOTE = 111,
  aux_sym_quoted_attribute_value_token1 = 112,
  aux_sym_quoted_attribute_value_token2 = 113,
  sym_css_property_value = 114,
  sym_element_text = 115,
  sym_element_comment = 116,
  sym_style_element_text = 117,
  sym_script_block_text = 118,
  sym_script_element_text = 119,
  sym_source_file = 120,
  sym_package_clause = 121,
  sym_import_declaration = 122,
  sym_import_spec = 123,
  sym_dot = 124,
  sym_import_spec_list = 125,
  sym__declaration = 126,
  sym_const_declaration = 127,
  sym_const_spec = 128,
  sym_var_declaration = 129,
  sym_var_spec = 130,
  sym_function_declaration = 131,
  sym_method_declaration = 132,
  sym_type_parameter_list = 133,
  sym_parameter_list = 134,
  sym_parameter_declaration = 135,
  sym_variadic_parameter_declaration = 136,
  sym_type_alias = 137,
  sym_type_declaration = 138,
  sym_type_spec = 139,
  sym_expression_list = 140,
  sym_parenthesized_type = 141,
  sym__simple_type = 142,
  sym_generic_type = 143,
  sym_type_arguments = 144,
  sym_pointer_type = 145,
  sym_array_type = 146,
  sym_implicit_length_array_type = 147,
  sym_slice_type = 148,
  sym_struct_type = 149,
  sym_union_type = 150,
  sym_negated_type = 151,
  sym_field_declaration_list = 152,
  sym_field_declaration = 153,
  sym_interface_type = 154,
  sym__interface_body = 155,
  sym_struct_elem = 156,
  sym_struct_term = 157,
  sym_method_spec = 158,
  sym_map_type = 159,
  sym_channel_type = 160,
  sym_function_type = 161,
  sym_block = 162,
  sym__statement_list = 163,
  sym__statement = 164,
  sym_empty_statement = 165,
  sym__simple_statement = 166,
  sym_expression_statement = 167,
  sym_send_statement = 168,
  sym_receive_statement = 169,
  sym_inc_statement = 170,
  sym_dec_statement = 171,
  sym_assignment_statement = 172,
  sym_short_var_declaration = 173,
  sym_labeled_statement = 174,
  sym_empty_labeled_statement = 175,
  sym_fallthrough_statement = 176,
  sym_break_statement = 177,
  sym_continue_statement = 178,
  sym_goto_statement = 179,
  sym_return_statement = 180,
  sym_go_statement = 181,
  sym_defer_statement = 182,
  sym_if_statement = 183,
  sym_for_statement = 184,
  sym_for_clause = 185,
  sym_range_clause = 186,
  sym_expression_switch_statement = 187,
  sym_expression_case = 188,
  sym_default_case = 189,
  sym_type_switch_statement = 190,
  sym__type_switch_header = 191,
  sym_type_case = 192,
  sym_select_statement = 193,
  sym_communication_case = 194,
  sym__expression = 195,
  sym_parenthesized_expression = 196,
  sym_call_expression = 197,
  sym_variadic_argument = 198,
  sym_special_argument_list = 199,
  sym_argument_list = 200,
  sym_selector_expression = 201,
  sym_index_expression = 202,
  sym_slice_expression = 203,
  sym_type_assertion_expression = 204,
  sym_type_conversion_expression = 205,
  sym_composite_literal = 206,
  sym_literal_value = 207,
  sym_literal_element = 208,
  sym_keyed_element = 209,
  sym_func_literal = 210,
  sym_unary_expression = 211,
  sym_binary_expression = 212,
  sym_qualified_type = 213,
  sym_interpreted_string_literal = 214,
  sym_expression = 215,
  sym_component_declaration = 216,
  sym_component_block = 217,
  sym__component_node = 218,
  sym_component_if_statement = 219,
  sym_component_for_statement = 220,
  sym_component_switch_statement = 221,
  sym_component_switch_expression_case = 222,
  sym_component_switch_default_case = 223,
  sym_component_import = 224,
  sym_component_render = 225,
  sym_component_children_expression = 226,
  sym_element = 227,
  sym_tag_start = 228,
  sym_tag_end = 229,
  sym_self_closing_tag = 230,
  sym_doctype = 231,
  sym_style_element = 232,
  sym__attribute = 233,
  sym_attribute = 234,
  sym_spread_attributes = 235,
  sym_conditional_attribute_block = 236,
  sym_conditional_attribute_if_statement = 237,
  sym_css_declaration = 238,
  sym__css_block = 239,
  sym_css_property = 240,
  sym_dynamic_class_attribute_value = 241,
  sym_script_declaration = 242,
  sym_script_block = 243,
  sym_script_element = 244,
  sym__component_identifier = 245,
  sym__css_identifier = 246,
  sym__script_identifier = 247,
  sym_quoted_attribute_value = 248,
  aux_sym_source_file_repeat1 = 249,
  aux_sym_import_spec_list_repeat1 = 250,
  aux_sym_const_declaration_repeat1 = 251,
  aux_sym_const_spec_repeat1 = 252,
  aux_sym_var_declaration_repeat1 = 253,
  aux_sym_type_parameter_list_repeat1 = 254,
  aux_sym_parameter_list_repeat1 = 255,
  aux_sym_parameter_declaration_repeat1 = 256,
  aux_sym_type_declaration_repeat1 = 257,
  aux_sym_expression_list_repeat1 = 258,
  aux_sym_type_arguments_repeat1 = 259,
  aux_sym_field_declaration_list_repeat1 = 260,
  aux_sym_field_declaration_repeat1 = 261,
  aux_sym_interface_type_repeat1 = 262,
  aux_sym_struct_elem_repeat1 = 263,
  aux_sym__statement_list_repeat1 = 264,
  aux_sym_expression_switch_statement_repeat1 = 265,
  aux_sym_type_switch_statement_repeat1 = 266,
  aux_sym_select_statement_repeat1 = 267,
  aux_sym_argument_list_repeat1 = 268,
  aux_sym_literal_value_repeat1 = 269,
  aux_sym_interpreted_string_literal_repeat1 = 270,
  aux_sym_component_block_repeat1 = 271,
  aux_sym_component_switch_statement_repeat1 = 272,
  aux_sym_tag_start_repeat1 = 273,
  aux_sym_style_element_repeat1 = 274,
  aux_sym_conditional_attribute_block_repeat1 = 275,
  aux_sym__css_block_repeat1 = 276,
  aux_sym_dynamic_class_attribute_value_repeat1 = 277,
  alias_sym_component_identifier = 278,
  alias_sym_constraint_elem = 279,
  alias_sym_css_identifier = 280,
  alias_sym_field_identifier = 281,
  alias_sym_label_name = 282,
  alias_sym_package_identifier = 283,
  alias_sym_script_identifier = 284,
  alias_sym_type_identifier = 285,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_LF] = "\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_NULL] = "\0",
  [anon_sym_package] = "package",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [sym_blank_identifier] = "blank_identifier",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_const] = "const",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_var] = "var",
  [anon_sym_func] = "func",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_type] = "type",
  [anon_sym_STAR] = "*",
  [anon_sym_struct] = "struct",
  [anon_sym_PIPE] = "|",
  [anon_sym_TILDE] = "~",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_interface] = "interface",
  [anon_sym_map] = "map",
  [anon_sym_chan] = "chan",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_AMP_CARET_EQ] = "&^=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_COLON] = ":",
  [anon_sym_fallthrough] = "fallthrough",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_goto] = "goto",
  [anon_sym_return] = "return",
  [anon_sym_go] = "go",
  [anon_sym_defer] = "defer",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_range] = "range",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_select] = "select",
  [anon_sym_new] = "identifier",
  [anon_sym_make] = "identifier",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_BANG] = "!",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_AMP_CARET] = "&^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [sym_raw_string_literal] = "raw_string_literal",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_DQUOTE2] = "\"",
  [sym__interpreted_string_literal_basic_content] = "_interpreted_string_literal_basic_content",
  [sym_escape_sequence] = "escape_sequence",
  [sym_int_literal] = "int_literal",
  [sym_float_literal] = "float_literal",
  [sym_imaginary_literal] = "imaginary_literal",
  [sym_rune_literal] = "rune_literal",
  [sym_nil] = "nil",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_iota] = "iota",
  [sym_comment] = "comment",
  [anon_sym_templ] = "templ",
  [anon_sym_AT] = "@",
  [anon_sym_LBRACE_BANG] = "{!",
  [anon_sym_children_DOT_DOT_DOT] = "children...",
  [anon_sym_LT_SLASH] = "</",
  [anon_sym_SLASH_GT] = "/>",
  [anon_sym_LT_BANG] = "<!",
  [anon_sym_html] = "html",
  [anon_sym_style] = "style",
  [anon_sym_if2] = "if",
  [anon_sym_else2] = "else",
  [anon_sym_css] = "css",
  [sym_css_property_name] = "css_property_name",
  [anon_sym_script] = "script",
  [sym_element_identifier] = "element_identifier",
  [sym_attribute_name] = "attribute_name",
  [sym_attribute_value] = "attribute_value",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_quoted_attribute_value_token1] = "attribute_value",
  [aux_sym_quoted_attribute_value_token2] = "attribute_value",
  [sym_css_property_value] = "css_property_value",
  [sym_element_text] = "element_text",
  [sym_element_comment] = "element_comment",
  [sym_style_element_text] = "style_element_text",
  [sym_script_block_text] = "script_block_text",
  [sym_script_element_text] = "script_element_text",
  [sym_source_file] = "source_file",
  [sym_package_clause] = "package_clause",
  [sym_import_declaration] = "import_declaration",
  [sym_import_spec] = "import_spec",
  [sym_dot] = "dot",
  [sym_import_spec_list] = "import_spec_list",
  [sym__declaration] = "_declaration",
  [sym_const_declaration] = "const_declaration",
  [sym_const_spec] = "const_spec",
  [sym_var_declaration] = "var_declaration",
  [sym_var_spec] = "var_spec",
  [sym_function_declaration] = "function_declaration",
  [sym_method_declaration] = "method_declaration",
  [sym_type_parameter_list] = "type_parameter_list",
  [sym_parameter_list] = "parameter_list",
  [sym_parameter_declaration] = "parameter_declaration",
  [sym_variadic_parameter_declaration] = "variadic_parameter_declaration",
  [sym_type_alias] = "type_alias",
  [sym_type_declaration] = "type_declaration",
  [sym_type_spec] = "type_spec",
  [sym_expression_list] = "expression_list",
  [sym_parenthesized_type] = "parenthesized_type",
  [sym__simple_type] = "_simple_type",
  [sym_generic_type] = "generic_type",
  [sym_type_arguments] = "type_arguments",
  [sym_pointer_type] = "pointer_type",
  [sym_array_type] = "array_type",
  [sym_implicit_length_array_type] = "implicit_length_array_type",
  [sym_slice_type] = "slice_type",
  [sym_struct_type] = "struct_type",
  [sym_union_type] = "union_type",
  [sym_negated_type] = "negated_type",
  [sym_field_declaration_list] = "field_declaration_list",
  [sym_field_declaration] = "field_declaration",
  [sym_interface_type] = "interface_type",
  [sym__interface_body] = "_interface_body",
  [sym_struct_elem] = "struct_elem",
  [sym_struct_term] = "struct_term",
  [sym_method_spec] = "method_spec",
  [sym_map_type] = "map_type",
  [sym_channel_type] = "channel_type",
  [sym_function_type] = "function_type",
  [sym_block] = "block",
  [sym__statement_list] = "_statement_list",
  [sym__statement] = "_statement",
  [sym_empty_statement] = "empty_statement",
  [sym__simple_statement] = "_simple_statement",
  [sym_expression_statement] = "expression_statement",
  [sym_send_statement] = "send_statement",
  [sym_receive_statement] = "receive_statement",
  [sym_inc_statement] = "inc_statement",
  [sym_dec_statement] = "dec_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym_short_var_declaration] = "short_var_declaration",
  [sym_labeled_statement] = "labeled_statement",
  [sym_empty_labeled_statement] = "labeled_statement",
  [sym_fallthrough_statement] = "fallthrough_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_goto_statement] = "goto_statement",
  [sym_return_statement] = "return_statement",
  [sym_go_statement] = "go_statement",
  [sym_defer_statement] = "defer_statement",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_for_clause] = "for_clause",
  [sym_range_clause] = "range_clause",
  [sym_expression_switch_statement] = "expression_switch_statement",
  [sym_expression_case] = "expression_case",
  [sym_default_case] = "default_case",
  [sym_type_switch_statement] = "type_switch_statement",
  [sym__type_switch_header] = "_type_switch_header",
  [sym_type_case] = "type_case",
  [sym_select_statement] = "select_statement",
  [sym_communication_case] = "communication_case",
  [sym__expression] = "_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_call_expression] = "call_expression",
  [sym_variadic_argument] = "variadic_argument",
  [sym_special_argument_list] = "argument_list",
  [sym_argument_list] = "argument_list",
  [sym_selector_expression] = "selector_expression",
  [sym_index_expression] = "index_expression",
  [sym_slice_expression] = "slice_expression",
  [sym_type_assertion_expression] = "type_assertion_expression",
  [sym_type_conversion_expression] = "type_conversion_expression",
  [sym_composite_literal] = "composite_literal",
  [sym_literal_value] = "literal_value",
  [sym_literal_element] = "literal_element",
  [sym_keyed_element] = "keyed_element",
  [sym_func_literal] = "func_literal",
  [sym_unary_expression] = "unary_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_qualified_type] = "qualified_type",
  [sym_interpreted_string_literal] = "interpreted_string_literal",
  [sym_expression] = "expression",
  [sym_component_declaration] = "component_declaration",
  [sym_component_block] = "component_block",
  [sym__component_node] = "_component_node",
  [sym_component_if_statement] = "component_if_statement",
  [sym_component_for_statement] = "component_for_statement",
  [sym_component_switch_statement] = "component_switch_statement",
  [sym_component_switch_expression_case] = "component_switch_expression_case",
  [sym_component_switch_default_case] = "component_switch_default_case",
  [sym_component_import] = "component_import",
  [sym_component_render] = "component_render",
  [sym_component_children_expression] = "component_children_expression",
  [sym_element] = "element",
  [sym_tag_start] = "tag_start",
  [sym_tag_end] = "tag_end",
  [sym_self_closing_tag] = "self_closing_tag",
  [sym_doctype] = "doctype",
  [sym_style_element] = "style_element",
  [sym__attribute] = "_attribute",
  [sym_attribute] = "attribute",
  [sym_spread_attributes] = "spread_attributes",
  [sym_conditional_attribute_block] = "conditional_attribute_block",
  [sym_conditional_attribute_if_statement] = "conditional_attribute_if_statement",
  [sym_css_declaration] = "css_declaration",
  [sym__css_block] = "_css_block",
  [sym_css_property] = "css_property",
  [sym_dynamic_class_attribute_value] = "dynamic_class_attribute_value",
  [sym_script_declaration] = "script_declaration",
  [sym_script_block] = "script_block",
  [sym_script_element] = "script_element",
  [sym__component_identifier] = "_component_identifier",
  [sym__css_identifier] = "_css_identifier",
  [sym__script_identifier] = "_script_identifier",
  [sym_quoted_attribute_value] = "quoted_attribute_value",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_import_spec_list_repeat1] = "import_spec_list_repeat1",
  [aux_sym_const_declaration_repeat1] = "const_declaration_repeat1",
  [aux_sym_const_spec_repeat1] = "const_spec_repeat1",
  [aux_sym_var_declaration_repeat1] = "var_declaration_repeat1",
  [aux_sym_type_parameter_list_repeat1] = "type_parameter_list_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_parameter_declaration_repeat1] = "parameter_declaration_repeat1",
  [aux_sym_type_declaration_repeat1] = "type_declaration_repeat1",
  [aux_sym_expression_list_repeat1] = "expression_list_repeat1",
  [aux_sym_type_arguments_repeat1] = "type_arguments_repeat1",
  [aux_sym_field_declaration_list_repeat1] = "field_declaration_list_repeat1",
  [aux_sym_field_declaration_repeat1] = "field_declaration_repeat1",
  [aux_sym_interface_type_repeat1] = "interface_type_repeat1",
  [aux_sym_struct_elem_repeat1] = "struct_elem_repeat1",
  [aux_sym__statement_list_repeat1] = "_statement_list_repeat1",
  [aux_sym_expression_switch_statement_repeat1] = "expression_switch_statement_repeat1",
  [aux_sym_type_switch_statement_repeat1] = "type_switch_statement_repeat1",
  [aux_sym_select_statement_repeat1] = "select_statement_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_literal_value_repeat1] = "literal_value_repeat1",
  [aux_sym_interpreted_string_literal_repeat1] = "interpreted_string_literal_repeat1",
  [aux_sym_component_block_repeat1] = "component_block_repeat1",
  [aux_sym_component_switch_statement_repeat1] = "component_switch_statement_repeat1",
  [aux_sym_tag_start_repeat1] = "tag_start_repeat1",
  [aux_sym_style_element_repeat1] = "style_element_repeat1",
  [aux_sym_conditional_attribute_block_repeat1] = "conditional_attribute_block_repeat1",
  [aux_sym__css_block_repeat1] = "_css_block_repeat1",
  [aux_sym_dynamic_class_attribute_value_repeat1] = "dynamic_class_attribute_value_repeat1",
  [alias_sym_component_identifier] = "component_identifier",
  [alias_sym_constraint_elem] = "constraint_elem",
  [alias_sym_css_identifier] = "css_identifier",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_label_name] = "label_name",
  [alias_sym_package_identifier] = "package_identifier",
  [alias_sym_script_identifier] = "script_identifier",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_LF] = anon_sym_LF,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_NULL] = anon_sym_NULL,
  [anon_sym_package] = anon_sym_package,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_blank_identifier] = sym_blank_identifier,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_func] = anon_sym_func,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_map] = anon_sym_map,
  [anon_sym_chan] = anon_sym_chan,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_AMP_CARET_EQ] = anon_sym_AMP_CARET_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_fallthrough] = anon_sym_fallthrough,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_goto] = anon_sym_goto,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_go] = anon_sym_go,
  [anon_sym_defer] = anon_sym_defer,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_range] = anon_sym_range,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_select] = anon_sym_select,
  [anon_sym_new] = sym_identifier,
  [anon_sym_make] = sym_identifier,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_AMP_CARET] = anon_sym_AMP_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [sym_raw_string_literal] = sym_raw_string_literal,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_DQUOTE2] = anon_sym_DQUOTE,
  [sym__interpreted_string_literal_basic_content] = sym__interpreted_string_literal_basic_content,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_int_literal] = sym_int_literal,
  [sym_float_literal] = sym_float_literal,
  [sym_imaginary_literal] = sym_imaginary_literal,
  [sym_rune_literal] = sym_rune_literal,
  [sym_nil] = sym_nil,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_iota] = sym_iota,
  [sym_comment] = sym_comment,
  [anon_sym_templ] = anon_sym_templ,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_LBRACE_BANG] = anon_sym_LBRACE_BANG,
  [anon_sym_children_DOT_DOT_DOT] = anon_sym_children_DOT_DOT_DOT,
  [anon_sym_LT_SLASH] = anon_sym_LT_SLASH,
  [anon_sym_SLASH_GT] = anon_sym_SLASH_GT,
  [anon_sym_LT_BANG] = anon_sym_LT_BANG,
  [anon_sym_html] = anon_sym_html,
  [anon_sym_style] = anon_sym_style,
  [anon_sym_if2] = anon_sym_if,
  [anon_sym_else2] = anon_sym_else,
  [anon_sym_css] = anon_sym_css,
  [sym_css_property_name] = sym_css_property_name,
  [anon_sym_script] = anon_sym_script,
  [sym_element_identifier] = sym_element_identifier,
  [sym_attribute_name] = sym_attribute_name,
  [sym_attribute_value] = sym_attribute_value,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_quoted_attribute_value_token1] = sym_attribute_value,
  [aux_sym_quoted_attribute_value_token2] = sym_attribute_value,
  [sym_css_property_value] = sym_css_property_value,
  [sym_element_text] = sym_element_text,
  [sym_element_comment] = sym_element_comment,
  [sym_style_element_text] = sym_style_element_text,
  [sym_script_block_text] = sym_script_block_text,
  [sym_script_element_text] = sym_script_element_text,
  [sym_source_file] = sym_source_file,
  [sym_package_clause] = sym_package_clause,
  [sym_import_declaration] = sym_import_declaration,
  [sym_import_spec] = sym_import_spec,
  [sym_dot] = sym_dot,
  [sym_import_spec_list] = sym_import_spec_list,
  [sym__declaration] = sym__declaration,
  [sym_const_declaration] = sym_const_declaration,
  [sym_const_spec] = sym_const_spec,
  [sym_var_declaration] = sym_var_declaration,
  [sym_var_spec] = sym_var_spec,
  [sym_function_declaration] = sym_function_declaration,
  [sym_method_declaration] = sym_method_declaration,
  [sym_type_parameter_list] = sym_type_parameter_list,
  [sym_parameter_list] = sym_parameter_list,
  [sym_parameter_declaration] = sym_parameter_declaration,
  [sym_variadic_parameter_declaration] = sym_variadic_parameter_declaration,
  [sym_type_alias] = sym_type_alias,
  [sym_type_declaration] = sym_type_declaration,
  [sym_type_spec] = sym_type_spec,
  [sym_expression_list] = sym_expression_list,
  [sym_parenthesized_type] = sym_parenthesized_type,
  [sym__simple_type] = sym__simple_type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_pointer_type] = sym_pointer_type,
  [sym_array_type] = sym_array_type,
  [sym_implicit_length_array_type] = sym_implicit_length_array_type,
  [sym_slice_type] = sym_slice_type,
  [sym_struct_type] = sym_struct_type,
  [sym_union_type] = sym_union_type,
  [sym_negated_type] = sym_negated_type,
  [sym_field_declaration_list] = sym_field_declaration_list,
  [sym_field_declaration] = sym_field_declaration,
  [sym_interface_type] = sym_interface_type,
  [sym__interface_body] = sym__interface_body,
  [sym_struct_elem] = sym_struct_elem,
  [sym_struct_term] = sym_struct_term,
  [sym_method_spec] = sym_method_spec,
  [sym_map_type] = sym_map_type,
  [sym_channel_type] = sym_channel_type,
  [sym_function_type] = sym_function_type,
  [sym_block] = sym_block,
  [sym__statement_list] = sym__statement_list,
  [sym__statement] = sym__statement,
  [sym_empty_statement] = sym_empty_statement,
  [sym__simple_statement] = sym__simple_statement,
  [sym_expression_statement] = sym_expression_statement,
  [sym_send_statement] = sym_send_statement,
  [sym_receive_statement] = sym_receive_statement,
  [sym_inc_statement] = sym_inc_statement,
  [sym_dec_statement] = sym_dec_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym_short_var_declaration] = sym_short_var_declaration,
  [sym_labeled_statement] = sym_labeled_statement,
  [sym_empty_labeled_statement] = sym_labeled_statement,
  [sym_fallthrough_statement] = sym_fallthrough_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_goto_statement] = sym_goto_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_go_statement] = sym_go_statement,
  [sym_defer_statement] = sym_defer_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_for_clause] = sym_for_clause,
  [sym_range_clause] = sym_range_clause,
  [sym_expression_switch_statement] = sym_expression_switch_statement,
  [sym_expression_case] = sym_expression_case,
  [sym_default_case] = sym_default_case,
  [sym_type_switch_statement] = sym_type_switch_statement,
  [sym__type_switch_header] = sym__type_switch_header,
  [sym_type_case] = sym_type_case,
  [sym_select_statement] = sym_select_statement,
  [sym_communication_case] = sym_communication_case,
  [sym__expression] = sym__expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_variadic_argument] = sym_variadic_argument,
  [sym_special_argument_list] = sym_argument_list,
  [sym_argument_list] = sym_argument_list,
  [sym_selector_expression] = sym_selector_expression,
  [sym_index_expression] = sym_index_expression,
  [sym_slice_expression] = sym_slice_expression,
  [sym_type_assertion_expression] = sym_type_assertion_expression,
  [sym_type_conversion_expression] = sym_type_conversion_expression,
  [sym_composite_literal] = sym_composite_literal,
  [sym_literal_value] = sym_literal_value,
  [sym_literal_element] = sym_literal_element,
  [sym_keyed_element] = sym_keyed_element,
  [sym_func_literal] = sym_func_literal,
  [sym_unary_expression] = sym_unary_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_qualified_type] = sym_qualified_type,
  [sym_interpreted_string_literal] = sym_interpreted_string_literal,
  [sym_expression] = sym_expression,
  [sym_component_declaration] = sym_component_declaration,
  [sym_component_block] = sym_component_block,
  [sym__component_node] = sym__component_node,
  [sym_component_if_statement] = sym_component_if_statement,
  [sym_component_for_statement] = sym_component_for_statement,
  [sym_component_switch_statement] = sym_component_switch_statement,
  [sym_component_switch_expression_case] = sym_component_switch_expression_case,
  [sym_component_switch_default_case] = sym_component_switch_default_case,
  [sym_component_import] = sym_component_import,
  [sym_component_render] = sym_component_render,
  [sym_component_children_expression] = sym_component_children_expression,
  [sym_element] = sym_element,
  [sym_tag_start] = sym_tag_start,
  [sym_tag_end] = sym_tag_end,
  [sym_self_closing_tag] = sym_self_closing_tag,
  [sym_doctype] = sym_doctype,
  [sym_style_element] = sym_style_element,
  [sym__attribute] = sym__attribute,
  [sym_attribute] = sym_attribute,
  [sym_spread_attributes] = sym_spread_attributes,
  [sym_conditional_attribute_block] = sym_conditional_attribute_block,
  [sym_conditional_attribute_if_statement] = sym_conditional_attribute_if_statement,
  [sym_css_declaration] = sym_css_declaration,
  [sym__css_block] = sym__css_block,
  [sym_css_property] = sym_css_property,
  [sym_dynamic_class_attribute_value] = sym_dynamic_class_attribute_value,
  [sym_script_declaration] = sym_script_declaration,
  [sym_script_block] = sym_script_block,
  [sym_script_element] = sym_script_element,
  [sym__component_identifier] = sym__component_identifier,
  [sym__css_identifier] = sym__css_identifier,
  [sym__script_identifier] = sym__script_identifier,
  [sym_quoted_attribute_value] = sym_quoted_attribute_value,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_import_spec_list_repeat1] = aux_sym_import_spec_list_repeat1,
  [aux_sym_const_declaration_repeat1] = aux_sym_const_declaration_repeat1,
  [aux_sym_const_spec_repeat1] = aux_sym_const_spec_repeat1,
  [aux_sym_var_declaration_repeat1] = aux_sym_var_declaration_repeat1,
  [aux_sym_type_parameter_list_repeat1] = aux_sym_type_parameter_list_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_parameter_declaration_repeat1] = aux_sym_parameter_declaration_repeat1,
  [aux_sym_type_declaration_repeat1] = aux_sym_type_declaration_repeat1,
  [aux_sym_expression_list_repeat1] = aux_sym_expression_list_repeat1,
  [aux_sym_type_arguments_repeat1] = aux_sym_type_arguments_repeat1,
  [aux_sym_field_declaration_list_repeat1] = aux_sym_field_declaration_list_repeat1,
  [aux_sym_field_declaration_repeat1] = aux_sym_field_declaration_repeat1,
  [aux_sym_interface_type_repeat1] = aux_sym_interface_type_repeat1,
  [aux_sym_struct_elem_repeat1] = aux_sym_struct_elem_repeat1,
  [aux_sym__statement_list_repeat1] = aux_sym__statement_list_repeat1,
  [aux_sym_expression_switch_statement_repeat1] = aux_sym_expression_switch_statement_repeat1,
  [aux_sym_type_switch_statement_repeat1] = aux_sym_type_switch_statement_repeat1,
  [aux_sym_select_statement_repeat1] = aux_sym_select_statement_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_literal_value_repeat1] = aux_sym_literal_value_repeat1,
  [aux_sym_interpreted_string_literal_repeat1] = aux_sym_interpreted_string_literal_repeat1,
  [aux_sym_component_block_repeat1] = aux_sym_component_block_repeat1,
  [aux_sym_component_switch_statement_repeat1] = aux_sym_component_switch_statement_repeat1,
  [aux_sym_tag_start_repeat1] = aux_sym_tag_start_repeat1,
  [aux_sym_style_element_repeat1] = aux_sym_style_element_repeat1,
  [aux_sym_conditional_attribute_block_repeat1] = aux_sym_conditional_attribute_block_repeat1,
  [aux_sym__css_block_repeat1] = aux_sym__css_block_repeat1,
  [aux_sym_dynamic_class_attribute_value_repeat1] = aux_sym_dynamic_class_attribute_value_repeat1,
  [alias_sym_component_identifier] = alias_sym_component_identifier,
  [alias_sym_constraint_elem] = alias_sym_constraint_elem,
  [alias_sym_css_identifier] = alias_sym_css_identifier,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_label_name] = alias_sym_label_name,
  [alias_sym_package_identifier] = alias_sym_package_identifier,
  [alias_sym_script_identifier] = alias_sym_script_identifier,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LF] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_NULL] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_package] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_blank_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_map] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chan] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallthrough] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_goto] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_go] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_defer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_range] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_select] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_make] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [sym_raw_string_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE2] = {
    .visible = true,
    .named = false,
  },
  [sym__interpreted_string_literal_basic_content] = {
    .visible = false,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_imaginary_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_rune_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_iota] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_templ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_children_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_html] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_style] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_css] = {
    .visible = true,
    .named = false,
  },
  [sym_css_property_name] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_script] = {
    .visible = true,
    .named = false,
  },
  [sym_element_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_quoted_attribute_value_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_quoted_attribute_value_token2] = {
    .visible = true,
    .named = true,
  },
  [sym_css_property_value] = {
    .visible = true,
    .named = true,
  },
  [sym_element_text] = {
    .visible = true,
    .named = true,
  },
  [sym_element_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_style_element_text] = {
    .visible = true,
    .named = true,
  },
  [sym_script_block_text] = {
    .visible = true,
    .named = true,
  },
  [sym_script_element_text] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_package_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_import_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_import_spec_list] = {
    .visible = true,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_const_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_const_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_var_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_function_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_method_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_parameter_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_type_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_type_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_list] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_type] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_type] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_pointer_type] = {
    .visible = true,
    .named = true,
  },
  [sym_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_implicit_length_array_type] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_type] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_type] = {
    .visible = true,
    .named = true,
  },
  [sym_union_type] = {
    .visible = true,
    .named = true,
  },
  [sym_negated_type] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration_list] = {
    .visible = true,
    .named = true,
  },
  [sym_field_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_type] = {
    .visible = true,
    .named = true,
  },
  [sym__interface_body] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_elem] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_term] = {
    .visible = true,
    .named = true,
  },
  [sym_method_spec] = {
    .visible = true,
    .named = true,
  },
  [sym_map_type] = {
    .visible = true,
    .named = true,
  },
  [sym_channel_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__statement_list] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_empty_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_statement] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_send_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_receive_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_inc_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dec_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_short_var_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_labeled_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_fallthrough_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_goto_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_go_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_defer_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_range_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_case] = {
    .visible = true,
    .named = true,
  },
  [sym_default_case] = {
    .visible = true,
    .named = true,
  },
  [sym_type_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__type_switch_header] = {
    .visible = false,
    .named = true,
  },
  [sym_type_case] = {
    .visible = true,
    .named = true,
  },
  [sym_select_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_communication_case] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variadic_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_special_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_index_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_assertion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_conversion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_composite_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_value] = {
    .visible = true,
    .named = true,
  },
  [sym_literal_element] = {
    .visible = true,
    .named = true,
  },
  [sym_keyed_element] = {
    .visible = true,
    .named = true,
  },
  [sym_func_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_type] = {
    .visible = true,
    .named = true,
  },
  [sym_interpreted_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_component_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_component_block] = {
    .visible = true,
    .named = true,
  },
  [sym__component_node] = {
    .visible = false,
    .named = true,
  },
  [sym_component_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_component_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_component_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_component_switch_expression_case] = {
    .visible = true,
    .named = true,
  },
  [sym_component_switch_default_case] = {
    .visible = true,
    .named = true,
  },
  [sym_component_import] = {
    .visible = true,
    .named = true,
  },
  [sym_component_render] = {
    .visible = true,
    .named = true,
  },
  [sym_component_children_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_element] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_start] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_end] = {
    .visible = true,
    .named = true,
  },
  [sym_self_closing_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_doctype] = {
    .visible = true,
    .named = true,
  },
  [sym_style_element] = {
    .visible = true,
    .named = true,
  },
  [sym__attribute] = {
    .visible = false,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_spread_attributes] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_attribute_block] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_attribute_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_css_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__css_block] = {
    .visible = false,
    .named = true,
  },
  [sym_css_property] = {
    .visible = true,
    .named = true,
  },
  [sym_dynamic_class_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [sym_script_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_script_block] = {
    .visible = true,
    .named = true,
  },
  [sym_script_element] = {
    .visible = true,
    .named = true,
  },
  [sym__component_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__css_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__script_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_attribute_value] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_spec_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_const_spec_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_var_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_field_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_elem_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__statement_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_expression_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_select_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_literal_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interpreted_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_component_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_component_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tag_start_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_style_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_conditional_attribute_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__css_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dynamic_class_attribute_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_component_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_constraint_elem] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_css_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_label_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_package_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_script_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_arguments = 3,
  field_body = 4,
  field_capacity = 5,
  field_channel = 6,
  field_communication = 7,
  field_condition = 8,
  field_consequence = 9,
  field_element = 10,
  field_end = 11,
  field_expression = 12,
  field_field = 13,
  field_function = 14,
  field_index = 15,
  field_initializer = 16,
  field_key = 17,
  field_label = 18,
  field_left = 19,
  field_length = 20,
  field_name = 21,
  field_operand = 22,
  field_operator = 23,
  field_package = 24,
  field_parameters = 25,
  field_path = 26,
  field_receiver = 27,
  field_result = 28,
  field_right = 29,
  field_start = 30,
  field_tag = 31,
  field_type = 32,
  field_type_arguments = 33,
  field_type_parameters = 34,
  field_update = 35,
  field_value = 36,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_capacity] = "capacity",
  [field_channel] = "channel",
  [field_communication] = "communication",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_element] = "element",
  [field_end] = "end",
  [field_expression] = "expression",
  [field_field] = "field",
  [field_function] = "function",
  [field_index] = "index",
  [field_initializer] = "initializer",
  [field_key] = "key",
  [field_label] = "label",
  [field_left] = "left",
  [field_length] = "length",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_package] = "package",
  [field_parameters] = "parameters",
  [field_path] = "path",
  [field_receiver] = "receiver",
  [field_result] = "result",
  [field_right] = "right",
  [field_start] = "start",
  [field_tag] = "tag",
  [field_type] = "type",
  [field_type_arguments] = "type_arguments",
  [field_type_parameters] = "type_parameters",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [3] = {.index = 0, .length = 1},
  [4] = {.index = 1, .length = 1},
  [5] = {.index = 2, .length = 1},
  [6] = {.index = 3, .length = 2},
  [7] = {.index = 5, .length = 1},
  [9] = {.index = 6, .length = 1},
  [10] = {.index = 7, .length = 2},
  [11] = {.index = 9, .length = 2},
  [12] = {.index = 11, .length = 2},
  [16] = {.index = 11, .length = 2},
  [17] = {.index = 9, .length = 2},
  [18] = {.index = 13, .length = 2},
  [19] = {.index = 13, .length = 2},
  [20] = {.index = 15, .length = 2},
  [21] = {.index = 17, .length = 2},
  [22] = {.index = 19, .length = 1},
  [23] = {.index = 20, .length = 2},
  [24] = {.index = 22, .length = 2},
  [25] = {.index = 24, .length = 2},
  [26] = {.index = 26, .length = 1},
  [27] = {.index = 17, .length = 2},
  [28] = {.index = 19, .length = 1},
  [29] = {.index = 27, .length = 1},
  [31] = {.index = 28, .length = 1},
  [32] = {.index = 29, .length = 2},
  [33] = {.index = 31, .length = 1},
  [34] = {.index = 32, .length = 1},
  [35] = {.index = 33, .length = 2},
  [36] = {.index = 35, .length = 3},
  [37] = {.index = 38, .length = 2},
  [38] = {.index = 40, .length = 2},
  [39] = {.index = 42, .length = 2},
  [40] = {.index = 44, .length = 3},
  [41] = {.index = 47, .length = 2},
  [42] = {.index = 49, .length = 3},
  [43] = {.index = 52, .length = 1},
  [44] = {.index = 53, .length = 3},
  [45] = {.index = 56, .length = 3},
  [46] = {.index = 59, .length = 3},
  [47] = {.index = 62, .length = 3},
  [48] = {.index = 65, .length = 3},
  [49] = {.index = 68, .length = 1},
  [50] = {.index = 69, .length = 2},
  [51] = {.index = 71, .length = 2},
  [52] = {.index = 73, .length = 3},
  [53] = {.index = 52, .length = 1},
  [54] = {.index = 76, .length = 2},
  [55] = {.index = 17, .length = 2},
  [56] = {.index = 76, .length = 2},
  [57] = {.index = 78, .length = 2},
  [58] = {.index = 80, .length = 1},
  [59] = {.index = 81, .length = 1},
  [60] = {.index = 82, .length = 1},
  [61] = {.index = 83, .length = 3},
  [62] = {.index = 86, .length = 1},
  [63] = {.index = 87, .length = 1},
  [64] = {.index = 88, .length = 2},
  [65] = {.index = 90, .length = 1},
  [66] = {.index = 91, .length = 2},
  [67] = {.index = 93, .length = 3},
  [68] = {.index = 96, .length = 3},
  [69] = {.index = 71, .length = 2},
  [70] = {.index = 99, .length = 3},
  [71] = {.index = 102, .length = 2},
  [72] = {.index = 104, .length = 4},
  [73] = {.index = 108, .length = 4},
  [74] = {.index = 112, .length = 4},
  [75] = {.index = 116, .length = 4},
  [76] = {.index = 120, .length = 4},
  [77] = {.index = 124, .length = 2},
  [78] = {.index = 124, .length = 2},
  [79] = {.index = 87, .length = 1},
  [80] = {.index = 126, .length = 3},
  [81] = {.index = 99, .length = 3},
  [82] = {.index = 129, .length = 3},
  [83] = {.index = 132, .length = 2},
  [84] = {.index = 134, .length = 3},
  [85] = {.index = 137, .length = 3},
  [86] = {.index = 140, .length = 2},
  [87] = {.index = 142, .length = 2},
  [88] = {.index = 144, .length = 2},
  [89] = {.index = 146, .length = 2},
  [90] = {.index = 148, .length = 1},
  [91] = {.index = 149, .length = 1},
  [92] = {.index = 150, .length = 2},
  [93] = {.index = 152, .length = 2},
  [94] = {.index = 154, .length = 2},
  [95] = {.index = 156, .length = 2},
  [96] = {.index = 158, .length = 4},
  [97] = {.index = 162, .length = 5},
  [98] = {.index = 167, .length = 5},
  [99] = {.index = 172, .length = 4},
  [100] = {.index = 176, .length = 3},
  [101] = {.index = 179, .length = 2},
  [102] = {.index = 181, .length = 1},
  [103] = {.index = 182, .length = 3},
  [104] = {.index = 185, .length = 4},
  [105] = {.index = 189, .length = 2},
  [106] = {.index = 191, .length = 2},
  [107] = {.index = 193, .length = 2},
  [108] = {.index = 195, .length = 1},
  [109] = {.index = 196, .length = 3},
  [110] = {.index = 199, .length = 2},
  [111] = {.index = 201, .length = 2},
  [112] = {.index = 203, .length = 2},
  [113] = {.index = 205, .length = 3},
  [114] = {.index = 208, .length = 4},
  [115] = {.index = 212, .length = 3},
  [116] = {.index = 215, .length = 3},
  [117] = {.index = 218, .length = 3},
  [118] = {.index = 221, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_path, 0},
  [1] =
    {field_name, 0},
  [2] =
    {field_parameters, 1},
  [3] =
    {field_operand, 1},
    {field_operator, 0},
  [5] =
    {field_value, 1},
  [6] =
    {field_body, 1},
  [7] =
    {field_arguments, 1},
    {field_function, 0},
  [9] =
    {field_type, 0},
    {field_type_arguments, 1},
  [11] =
    {field_body, 1},
    {field_type, 0},
  [13] =
    {field_name, 0},
    {field_path, 1},
  [15] =
    {field_name, 0},
    {field_name, 1},
  [17] =
    {field_name, 0},
    {field_type, 1},
  [19] =
    {field_type, 0},
  [20] =
    {field_name, 1},
    {field_parameters, 2},
  [22] =
    {field_parameters, 1},
    {field_result, 2},
  [24] =
    {field_body, 2},
    {field_parameters, 1},
  [26] =
    {field_element, 2},
  [27] =
    {field_label, 0},
  [28] =
    {field_value, 2},
  [29] =
    {field_condition, 1},
    {field_consequence, 2},
  [31] =
    {field_right, 1},
  [32] =
    {field_body, 2},
  [33] =
    {field_name, 2},
    {field_package, 0},
  [35] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [38] =
    {field_left, 0},
    {field_right, 2},
  [40] =
    {field_field, 2},
    {field_operand, 0},
  [42] =
    {field_channel, 0},
    {field_value, 2},
  [44] =
    {field_arguments, 2},
    {field_function, 0},
    {field_type_arguments, 1},
  [47] =
    {field_name, 0},
    {field_value, 2},
  [49] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 2},
  [52] =
    {field_type, 1},
  [53] =
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [56] =
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 3},
  [59] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [62] =
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
  [65] =
    {field_body, 3},
    {field_parameters, 1},
    {field_result, 2},
  [68] =
    {field_element, 3},
  [69] =
    {field_element, 3},
    {field_length, 1},
  [71] =
    {field_name, 0},
    {field_type, 2},
  [73] =
    {field_name, 0},
    {field_type, 2},
    {field_type_parameters, 1},
  [76] =
    {field_tag, 1},
    {field_type, 0},
  [78] =
    {field_name, 0},
    {field_parameters, 1},
  [80] =
    {field_update, 2},
  [81] =
    {field_condition, 1},
  [82] =
    {field_initializer, 0},
  [83] =
    {field_alias, 1, .inherited = true},
    {field_initializer, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [86] =
    {field_right, 0},
  [87] =
    {field_name, 1},
  [88] =
    {field_operand, 2},
    {field_type, 0},
  [90] =
    {field_operand, 0},
  [91] =
    {field_index, 2},
    {field_operand, 0},
  [93] =
    {field_name, 0},
    {field_type, 1},
    {field_value, 3},
  [96] =
    {field_name, 0},
    {field_name, 1},
    {field_value, 3},
  [99] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_type, 2},
  [102] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [104] =
    {field_name, 1},
    {field_parameters, 3},
    {field_result, 4},
    {field_type_parameters, 2},
  [108] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 3},
    {field_type_parameters, 2},
  [112] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
    {field_result, 3},
  [116] =
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
    {field_result, 4},
  [120] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
  [124] =
    {field_tag, 2},
    {field_type, 1},
  [126] =
    {field_name, 0},
    {field_tag, 2},
    {field_type, 1},
  [129] =
    {field_name, 0},
    {field_parameters, 1},
    {field_result, 2},
  [132] =
    {field_key, 2},
    {field_value, 4},
  [134] =
    {field_condition, 3},
    {field_consequence, 4},
    {field_initializer, 1},
  [137] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [140] =
    {field_condition, 1},
    {field_update, 3},
  [142] =
    {field_left, 0},
    {field_right, 3},
  [144] =
    {field_initializer, 0},
    {field_update, 3},
  [146] =
    {field_condition, 2},
    {field_initializer, 0},
  [148] =
    {field_initializer, 1},
  [149] =
    {field_communication, 1},
  [150] =
    {field_name, 2},
    {field_receiver, 1},
  [152] =
    {field_operand, 0},
    {field_type, 3},
  [154] =
    {field_end, 3},
    {field_operand, 0},
  [156] =
    {field_operand, 0},
    {field_start, 2},
  [158] =
    {field_name, 0},
    {field_name, 1},
    {field_type, 2},
    {field_value, 4},
  [162] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 3},
    {field_result, 4},
    {field_type_parameters, 2},
  [167] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
    {field_receiver, 1},
    {field_result, 4},
  [172] =
    {field_name, 0},
    {field_name, 1, .inherited = true},
    {field_tag, 3},
    {field_type, 2},
  [176] =
    {field_condition, 2},
    {field_initializer, 0},
    {field_update, 4},
  [179] =
    {field_initializer, 1},
    {field_value, 3},
  [181] =
    {field_value, 0},
  [182] =
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [185] =
    {field_alternative, 6},
    {field_condition, 3},
    {field_consequence, 4},
    {field_initializer, 1},
  [189] =
    {field_type, 1},
    {field_type, 2},
  [191] =
    {field_arguments, 2},
    {field_name, 1},
  [193] =
    {field_body, 2},
    {field_name, 1},
  [195] =
    {field_expression, 1},
  [196] =
    {field_capacity, 5},
    {field_end, 3},
    {field_operand, 0},
  [199] =
    {field_alias, 0},
    {field_value, 2},
  [201] =
    {field_initializer, 0},
    {field_value, 2},
  [203] =
    {field_name, 3},
    {field_package, 1},
  [205] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [208] =
    {field_capacity, 6},
    {field_end, 4},
    {field_operand, 0},
    {field_start, 2},
  [212] =
    {field_arguments, 4},
    {field_name, 3},
    {field_package, 1},
  [215] =
    {field_body, 4},
    {field_name, 3},
    {field_package, 1},
  [218] =
    {field_alias, 2},
    {field_initializer, 0},
    {field_value, 4},
  [221] =
    {field_arguments, 4},
    {field_body, 5},
    {field_name, 3},
    {field_package, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_type_identifier,
  },
  [2] = {
    [1] = alias_sym_package_identifier,
  },
  [8] = {
    [1] = alias_sym_label_name,
  },
  [11] = {
    [0] = alias_sym_type_identifier,
  },
  [12] = {
    [0] = alias_sym_type_identifier,
  },
  [13] = {
    [0] = alias_sym_component_identifier,
  },
  [14] = {
    [0] = alias_sym_css_identifier,
  },
  [15] = {
    [0] = alias_sym_script_identifier,
  },
  [19] = {
    [0] = alias_sym_package_identifier,
  },
  [27] = {
    [0] = alias_sym_type_identifier,
  },
  [28] = {
    [0] = alias_sym_type_identifier,
  },
  [29] = {
    [0] = alias_sym_label_name,
  },
  [30] = {
    [0] = alias_sym_constraint_elem,
  },
  [35] = {
    [0] = alias_sym_package_identifier,
    [2] = alias_sym_type_identifier,
  },
  [38] = {
    [2] = alias_sym_field_identifier,
  },
  [47] = {
    [2] = alias_sym_field_identifier,
  },
  [51] = {
    [0] = alias_sym_type_identifier,
  },
  [52] = {
    [0] = alias_sym_type_identifier,
  },
  [53] = {
    [1] = alias_sym_type_identifier,
  },
  [54] = {
    [0] = alias_sym_type_identifier,
  },
  [55] = {
    [0] = alias_sym_field_identifier,
  },
  [57] = {
    [0] = alias_sym_field_identifier,
  },
  [75] = {
    [2] = alias_sym_field_identifier,
  },
  [76] = {
    [2] = alias_sym_field_identifier,
  },
  [77] = {
    [1] = alias_sym_type_identifier,
  },
  [79] = {
    [1] = alias_sym_field_identifier,
  },
  [80] = {
    [0] = alias_sym_field_identifier,
  },
  [81] = {
    [0] = alias_sym_field_identifier,
  },
  [82] = {
    [0] = alias_sym_field_identifier,
  },
  [98] = {
    [2] = alias_sym_field_identifier,
  },
  [99] = {
    [0] = alias_sym_field_identifier,
  },
  [112] = {
    [1] = alias_sym_package_identifier,
  },
  [115] = {
    [1] = alias_sym_package_identifier,
  },
  [116] = {
    [1] = alias_sym_package_identifier,
  },
  [118] = {
    [1] = alias_sym_package_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__simple_type, 2,
    sym__simple_type,
    alias_sym_constraint_elem,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 12,
  [14] = 12,
  [15] = 12,
  [16] = 12,
  [17] = 12,
  [18] = 12,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 22,
  [24] = 22,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 26,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 26,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 33,
  [37] = 33,
  [38] = 38,
  [39] = 39,
  [40] = 39,
  [41] = 39,
  [42] = 39,
  [43] = 39,
  [44] = 39,
  [45] = 45,
  [46] = 46,
  [47] = 45,
  [48] = 45,
  [49] = 45,
  [50] = 46,
  [51] = 46,
  [52] = 46,
  [53] = 45,
  [54] = 46,
  [55] = 46,
  [56] = 45,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 61,
  [64] = 64,
  [65] = 61,
  [66] = 66,
  [67] = 67,
  [68] = 61,
  [69] = 61,
  [70] = 67,
  [71] = 71,
  [72] = 61,
  [73] = 66,
  [74] = 74,
  [75] = 61,
  [76] = 67,
  [77] = 67,
  [78] = 66,
  [79] = 66,
  [80] = 62,
  [81] = 81,
  [82] = 71,
  [83] = 67,
  [84] = 67,
  [85] = 67,
  [86] = 66,
  [87] = 87,
  [88] = 66,
  [89] = 67,
  [90] = 62,
  [91] = 61,
  [92] = 66,
  [93] = 71,
  [94] = 66,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 98,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 104,
  [106] = 106,
  [107] = 96,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 98,
  [114] = 114,
  [115] = 95,
  [116] = 102,
  [117] = 103,
  [118] = 108,
  [119] = 104,
  [120] = 120,
  [121] = 121,
  [122] = 98,
  [123] = 97,
  [124] = 95,
  [125] = 125,
  [126] = 126,
  [127] = 114,
  [128] = 128,
  [129] = 129,
  [130] = 114,
  [131] = 104,
  [132] = 102,
  [133] = 104,
  [134] = 103,
  [135] = 135,
  [136] = 102,
  [137] = 95,
  [138] = 96,
  [139] = 109,
  [140] = 140,
  [141] = 141,
  [142] = 128,
  [143] = 121,
  [144] = 103,
  [145] = 102,
  [146] = 114,
  [147] = 114,
  [148] = 98,
  [149] = 98,
  [150] = 95,
  [151] = 104,
  [152] = 114,
  [153] = 108,
  [154] = 109,
  [155] = 102,
  [156] = 128,
  [157] = 157,
  [158] = 121,
  [159] = 95,
  [160] = 103,
  [161] = 103,
  [162] = 162,
  [163] = 163,
  [164] = 163,
  [165] = 163,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 163,
  [174] = 174,
  [175] = 170,
  [176] = 176,
  [177] = 167,
  [178] = 171,
  [179] = 179,
  [180] = 174,
  [181] = 176,
  [182] = 182,
  [183] = 169,
  [184] = 168,
  [185] = 185,
  [186] = 182,
  [187] = 169,
  [188] = 188,
  [189] = 163,
  [190] = 163,
  [191] = 191,
  [192] = 171,
  [193] = 169,
  [194] = 182,
  [195] = 195,
  [196] = 169,
  [197] = 170,
  [198] = 182,
  [199] = 182,
  [200] = 200,
  [201] = 201,
  [202] = 174,
  [203] = 203,
  [204] = 179,
  [205] = 166,
  [206] = 171,
  [207] = 171,
  [208] = 172,
  [209] = 185,
  [210] = 174,
  [211] = 167,
  [212] = 179,
  [213] = 167,
  [214] = 168,
  [215] = 179,
  [216] = 182,
  [217] = 188,
  [218] = 172,
  [219] = 201,
  [220] = 171,
  [221] = 201,
  [222] = 174,
  [223] = 167,
  [224] = 182,
  [225] = 169,
  [226] = 166,
  [227] = 166,
  [228] = 163,
  [229] = 169,
  [230] = 230,
  [231] = 168,
  [232] = 188,
  [233] = 163,
  [234] = 174,
  [235] = 167,
  [236] = 236,
  [237] = 201,
  [238] = 179,
  [239] = 174,
  [240] = 179,
  [241] = 166,
  [242] = 170,
  [243] = 179,
  [244] = 201,
  [245] = 188,
  [246] = 246,
  [247] = 171,
  [248] = 171,
  [249] = 249,
  [250] = 169,
  [251] = 170,
  [252] = 191,
  [253] = 182,
  [254] = 174,
  [255] = 166,
  [256] = 170,
  [257] = 179,
  [258] = 176,
  [259] = 168,
  [260] = 260,
  [261] = 201,
  [262] = 185,
  [263] = 167,
  [264] = 167,
  [265] = 188,
  [266] = 168,
  [267] = 172,
  [268] = 172,
  [269] = 269,
  [270] = 191,
  [271] = 171,
  [272] = 188,
  [273] = 236,
  [274] = 170,
  [275] = 171,
  [276] = 170,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 296,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 314,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 314,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 296,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 335,
  [337] = 335,
  [338] = 283,
  [339] = 289,
  [340] = 285,
  [341] = 286,
  [342] = 287,
  [343] = 288,
  [344] = 282,
  [345] = 284,
  [346] = 293,
  [347] = 291,
  [348] = 320,
  [349] = 309,
  [350] = 303,
  [351] = 311,
  [352] = 317,
  [353] = 324,
  [354] = 330,
  [355] = 331,
  [356] = 329,
  [357] = 301,
  [358] = 327,
  [359] = 316,
  [360] = 297,
  [361] = 323,
  [362] = 308,
  [363] = 306,
  [364] = 305,
  [365] = 307,
  [366] = 304,
  [367] = 299,
  [368] = 298,
  [369] = 292,
  [370] = 333,
  [371] = 290,
  [372] = 315,
  [373] = 319,
  [374] = 300,
  [375] = 295,
  [376] = 326,
  [377] = 322,
  [378] = 328,
  [379] = 294,
  [380] = 302,
  [381] = 283,
  [382] = 285,
  [383] = 287,
  [384] = 289,
  [385] = 286,
  [386] = 288,
  [387] = 284,
  [388] = 388,
  [389] = 389,
  [390] = 293,
  [391] = 391,
  [392] = 389,
  [393] = 323,
  [394] = 308,
  [395] = 327,
  [396] = 324,
  [397] = 304,
  [398] = 303,
  [399] = 297,
  [400] = 311,
  [401] = 291,
  [402] = 329,
  [403] = 315,
  [404] = 309,
  [405] = 292,
  [406] = 333,
  [407] = 294,
  [408] = 290,
  [409] = 306,
  [410] = 330,
  [411] = 307,
  [412] = 305,
  [413] = 295,
  [414] = 317,
  [415] = 298,
  [416] = 322,
  [417] = 316,
  [418] = 331,
  [419] = 326,
  [420] = 301,
  [421] = 328,
  [422] = 300,
  [423] = 302,
  [424] = 320,
  [425] = 319,
  [426] = 299,
  [427] = 304,
  [428] = 283,
  [429] = 429,
  [430] = 289,
  [431] = 299,
  [432] = 284,
  [433] = 330,
  [434] = 326,
  [435] = 435,
  [436] = 389,
  [437] = 389,
  [438] = 293,
  [439] = 306,
  [440] = 297,
  [441] = 319,
  [442] = 295,
  [443] = 301,
  [444] = 444,
  [445] = 316,
  [446] = 315,
  [447] = 317,
  [448] = 324,
  [449] = 449,
  [450] = 288,
  [451] = 329,
  [452] = 292,
  [453] = 453,
  [454] = 331,
  [455] = 323,
  [456] = 456,
  [457] = 457,
  [458] = 287,
  [459] = 300,
  [460] = 303,
  [461] = 286,
  [462] = 302,
  [463] = 285,
  [464] = 283,
  [465] = 320,
  [466] = 327,
  [467] = 322,
  [468] = 328,
  [469] = 290,
  [470] = 389,
  [471] = 311,
  [472] = 309,
  [473] = 333,
  [474] = 389,
  [475] = 308,
  [476] = 307,
  [477] = 291,
  [478] = 298,
  [479] = 305,
  [480] = 294,
  [481] = 481,
  [482] = 388,
  [483] = 449,
  [484] = 457,
  [485] = 288,
  [486] = 486,
  [487] = 286,
  [488] = 453,
  [489] = 285,
  [490] = 289,
  [491] = 284,
  [492] = 287,
  [493] = 293,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 496,
  [498] = 495,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 494,
  [503] = 496,
  [504] = 504,
  [505] = 505,
  [506] = 504,
  [507] = 495,
  [508] = 494,
  [509] = 283,
  [510] = 510,
  [511] = 510,
  [512] = 512,
  [513] = 504,
  [514] = 510,
  [515] = 306,
  [516] = 294,
  [517] = 297,
  [518] = 303,
  [519] = 292,
  [520] = 317,
  [521] = 327,
  [522] = 323,
  [523] = 290,
  [524] = 444,
  [525] = 291,
  [526] = 526,
  [527] = 284,
  [528] = 528,
  [529] = 322,
  [530] = 311,
  [531] = 298,
  [532] = 299,
  [533] = 444,
  [534] = 288,
  [535] = 287,
  [536] = 286,
  [537] = 444,
  [538] = 526,
  [539] = 285,
  [540] = 300,
  [541] = 444,
  [542] = 526,
  [543] = 302,
  [544] = 328,
  [545] = 326,
  [546] = 546,
  [547] = 546,
  [548] = 548,
  [549] = 444,
  [550] = 324,
  [551] = 308,
  [552] = 307,
  [553] = 388,
  [554] = 289,
  [555] = 329,
  [556] = 319,
  [557] = 304,
  [558] = 330,
  [559] = 331,
  [560] = 333,
  [561] = 295,
  [562] = 305,
  [563] = 301,
  [564] = 309,
  [565] = 320,
  [566] = 316,
  [567] = 315,
  [568] = 528,
  [569] = 546,
  [570] = 570,
  [571] = 570,
  [572] = 570,
  [573] = 570,
  [574] = 570,
  [575] = 283,
  [576] = 570,
  [577] = 481,
  [578] = 578,
  [579] = 570,
  [580] = 580,
  [581] = 581,
  [582] = 293,
  [583] = 583,
  [584] = 283,
  [585] = 570,
  [586] = 586,
  [587] = 587,
  [588] = 324,
  [589] = 589,
  [590] = 590,
  [591] = 590,
  [592] = 304,
  [593] = 320,
  [594] = 315,
  [595] = 322,
  [596] = 283,
  [597] = 319,
  [598] = 292,
  [599] = 599,
  [600] = 295,
  [601] = 590,
  [602] = 323,
  [603] = 603,
  [604] = 604,
  [605] = 290,
  [606] = 330,
  [607] = 331,
  [608] = 329,
  [609] = 327,
  [610] = 301,
  [611] = 603,
  [612] = 326,
  [613] = 613,
  [614] = 317,
  [615] = 599,
  [616] = 328,
  [617] = 586,
  [618] = 302,
  [619] = 619,
  [620] = 288,
  [621] = 287,
  [622] = 286,
  [623] = 300,
  [624] = 285,
  [625] = 316,
  [626] = 308,
  [627] = 604,
  [628] = 291,
  [629] = 619,
  [630] = 305,
  [631] = 631,
  [632] = 632,
  [633] = 303,
  [634] = 297,
  [635] = 635,
  [636] = 311,
  [637] = 309,
  [638] = 333,
  [639] = 599,
  [640] = 307,
  [641] = 604,
  [642] = 481,
  [643] = 643,
  [644] = 288,
  [645] = 645,
  [646] = 619,
  [647] = 294,
  [648] = 287,
  [649] = 306,
  [650] = 650,
  [651] = 651,
  [652] = 286,
  [653] = 586,
  [654] = 603,
  [655] = 298,
  [656] = 299,
  [657] = 285,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 662,
  [663] = 661,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 667,
  [670] = 670,
  [671] = 388,
  [672] = 664,
  [673] = 673,
  [674] = 659,
  [675] = 658,
  [676] = 667,
  [677] = 666,
  [678] = 678,
  [679] = 679,
  [680] = 664,
  [681] = 658,
  [682] = 661,
  [683] = 673,
  [684] = 666,
  [685] = 685,
  [686] = 660,
  [687] = 687,
  [688] = 659,
  [689] = 667,
  [690] = 662,
  [691] = 512,
  [692] = 658,
  [693] = 693,
  [694] = 662,
  [695] = 661,
  [696] = 666,
  [697] = 658,
  [698] = 388,
  [699] = 659,
  [700] = 700,
  [701] = 667,
  [702] = 658,
  [703] = 664,
  [704] = 704,
  [705] = 667,
  [706] = 666,
  [707] = 679,
  [708] = 659,
  [709] = 709,
  [710] = 660,
  [711] = 661,
  [712] = 664,
  [713] = 673,
  [714] = 664,
  [715] = 659,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 723,
  [731] = 723,
  [732] = 723,
  [733] = 733,
  [734] = 717,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 726,
  [740] = 740,
  [741] = 741,
  [742] = 729,
  [743] = 743,
  [744] = 726,
  [745] = 718,
  [746] = 741,
  [747] = 747,
  [748] = 748,
  [749] = 740,
  [750] = 725,
  [751] = 720,
  [752] = 752,
  [753] = 747,
  [754] = 723,
  [755] = 733,
  [756] = 747,
  [757] = 720,
  [758] = 758,
  [759] = 759,
  [760] = 724,
  [761] = 721,
  [762] = 724,
  [763] = 763,
  [764] = 729,
  [765] = 726,
  [766] = 728,
  [767] = 736,
  [768] = 768,
  [769] = 718,
  [770] = 770,
  [771] = 738,
  [772] = 717,
  [773] = 724,
  [774] = 743,
  [775] = 721,
  [776] = 721,
  [777] = 733,
  [778] = 778,
  [779] = 736,
  [780] = 736,
  [781] = 781,
  [782] = 738,
  [783] = 718,
  [784] = 727,
  [785] = 743,
  [786] = 786,
  [787] = 728,
  [788] = 729,
  [789] = 736,
  [790] = 717,
  [791] = 728,
  [792] = 717,
  [793] = 793,
  [794] = 738,
  [795] = 724,
  [796] = 728,
  [797] = 797,
  [798] = 741,
  [799] = 716,
  [800] = 743,
  [801] = 726,
  [802] = 727,
  [803] = 724,
  [804] = 729,
  [805] = 725,
  [806] = 768,
  [807] = 758,
  [808] = 720,
  [809] = 736,
  [810] = 721,
  [811] = 811,
  [812] = 717,
  [813] = 725,
  [814] = 793,
  [815] = 748,
  [816] = 738,
  [817] = 740,
  [818] = 718,
  [819] = 740,
  [820] = 729,
  [821] = 728,
  [822] = 723,
  [823] = 781,
  [824] = 743,
  [825] = 781,
  [826] = 826,
  [827] = 725,
  [828] = 748,
  [829] = 726,
  [830] = 721,
  [831] = 720,
  [832] = 793,
  [833] = 740,
  [834] = 834,
  [835] = 512,
  [836] = 716,
  [837] = 837,
  [838] = 738,
  [839] = 747,
  [840] = 725,
  [841] = 747,
  [842] = 718,
  [843] = 747,
  [844] = 740,
  [845] = 743,
  [846] = 758,
  [847] = 720,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 852,
  [857] = 853,
  [858] = 851,
  [859] = 850,
  [860] = 853,
  [861] = 850,
  [862] = 852,
  [863] = 851,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 866,
  [868] = 868,
  [869] = 869,
  [870] = 869,
  [871] = 854,
  [872] = 868,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 874,
  [877] = 875,
  [878] = 874,
  [879] = 879,
  [880] = 855,
  [881] = 873,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 895,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 889,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 885,
  [918] = 886,
  [919] = 919,
  [920] = 899,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 901,
  [926] = 926,
  [927] = 913,
  [928] = 915,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 947,
  [956] = 956,
  [957] = 957,
  [958] = 958,
  [959] = 959,
  [960] = 948,
  [961] = 326,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 304,
  [967] = 330,
  [968] = 299,
  [969] = 326,
  [970] = 304,
  [971] = 330,
  [972] = 950,
  [973] = 299,
  [974] = 974,
  [975] = 951,
  [976] = 976,
  [977] = 945,
  [978] = 978,
  [979] = 952,
  [980] = 931,
  [981] = 974,
  [982] = 976,
  [983] = 953,
  [984] = 868,
  [985] = 954,
  [986] = 956,
  [987] = 987,
  [988] = 988,
  [989] = 989,
  [990] = 957,
  [991] = 958,
  [992] = 959,
  [993] = 962,
  [994] = 994,
  [995] = 933,
  [996] = 989,
  [997] = 963,
  [998] = 964,
  [999] = 946,
  [1000] = 944,
  [1001] = 943,
  [1002] = 1002,
  [1003] = 988,
  [1004] = 942,
  [1005] = 965,
  [1006] = 934,
  [1007] = 935,
  [1008] = 978,
  [1009] = 941,
  [1010] = 987,
  [1011] = 936,
  [1012] = 1012,
  [1013] = 868,
  [1014] = 930,
  [1015] = 940,
  [1016] = 1016,
  [1017] = 939,
  [1018] = 938,
  [1019] = 937,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 1023,
  [1024] = 1022,
  [1025] = 875,
  [1026] = 1026,
  [1027] = 875,
  [1028] = 1023,
  [1029] = 1029,
  [1030] = 1029,
  [1031] = 1022,
  [1032] = 1032,
  [1033] = 1023,
  [1034] = 926,
  [1035] = 897,
  [1036] = 924,
  [1037] = 900,
  [1038] = 907,
  [1039] = 914,
  [1040] = 1040,
  [1041] = 902,
  [1042] = 912,
  [1043] = 893,
  [1044] = 923,
  [1045] = 894,
  [1046] = 898,
  [1047] = 916,
  [1048] = 896,
  [1049] = 929,
  [1050] = 1050,
  [1051] = 1050,
  [1052] = 906,
  [1053] = 904,
  [1054] = 921,
  [1055] = 905,
  [1056] = 908,
  [1057] = 887,
  [1058] = 888,
  [1059] = 910,
  [1060] = 1040,
  [1061] = 922,
  [1062] = 911,
  [1063] = 868,
  [1064] = 1064,
  [1065] = 895,
  [1066] = 919,
  [1067] = 903,
  [1068] = 1068,
  [1069] = 1064,
  [1070] = 868,
  [1071] = 890,
  [1072] = 864,
  [1073] = 865,
  [1074] = 1074,
  [1075] = 875,
  [1076] = 875,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 908,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 887,
  [1090] = 888,
  [1091] = 1091,
  [1092] = 900,
  [1093] = 903,
  [1094] = 890,
  [1095] = 904,
  [1096] = 906,
  [1097] = 1097,
  [1098] = 1098,
  [1099] = 1099,
  [1100] = 895,
  [1101] = 1101,
  [1102] = 907,
  [1103] = 866,
  [1104] = 921,
  [1105] = 910,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 896,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 911,
  [1113] = 912,
  [1114] = 894,
  [1115] = 914,
  [1116] = 893,
  [1117] = 1117,
  [1118] = 869,
  [1119] = 1119,
  [1120] = 1120,
  [1121] = 902,
  [1122] = 916,
  [1123] = 905,
  [1124] = 919,
  [1125] = 1125,
  [1126] = 922,
  [1127] = 898,
  [1128] = 923,
  [1129] = 924,
  [1130] = 1101,
  [1131] = 926,
  [1132] = 1109,
  [1133] = 897,
  [1134] = 929,
  [1135] = 1109,
  [1136] = 1136,
  [1137] = 1068,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1068,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1147,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 1154,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1165,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1068,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1180,
  [1181] = 1181,
  [1182] = 1166,
  [1183] = 1183,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 873,
  [1187] = 1187,
  [1188] = 1068,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 865,
  [1192] = 1155,
  [1193] = 1157,
  [1194] = 864,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1197,
  [1198] = 1163,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1201,
  [1202] = 1164,
  [1203] = 1203,
  [1204] = 1165,
  [1205] = 1200,
  [1206] = 1206,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1210,
  [1211] = 1211,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1215,
  [1216] = 1216,
  [1217] = 1068,
  [1218] = 1218,
  [1219] = 1219,
  [1220] = 1097,
  [1221] = 1199,
  [1222] = 1222,
  [1223] = 1200,
  [1224] = 1119,
  [1225] = 1225,
  [1226] = 1165,
  [1227] = 1164,
  [1228] = 1199,
  [1229] = 1163,
  [1230] = 1230,
  [1231] = 1110,
  [1232] = 1232,
  [1233] = 1233,
  [1234] = 1157,
  [1235] = 1155,
  [1236] = 1236,
  [1237] = 1237,
  [1238] = 1166,
  [1239] = 1239,
  [1240] = 1240,
  [1241] = 1241,
  [1242] = 1242,
  [1243] = 1243,
  [1244] = 1206,
  [1245] = 1245,
  [1246] = 1246,
  [1247] = 1247,
  [1248] = 1207,
  [1249] = 1249,
  [1250] = 1250,
  [1251] = 1251,
  [1252] = 1252,
  [1253] = 1253,
  [1254] = 1254,
  [1255] = 1255,
  [1256] = 1256,
  [1257] = 1257,
  [1258] = 1258,
  [1259] = 1259,
  [1260] = 1260,
  [1261] = 1261,
  [1262] = 1262,
  [1263] = 1263,
  [1264] = 1264,
  [1265] = 1265,
  [1266] = 1189,
  [1267] = 1267,
  [1268] = 1268,
  [1269] = 1245,
  [1270] = 1246,
  [1271] = 1271,
  [1272] = 1272,
  [1273] = 1273,
  [1274] = 1274,
  [1275] = 1258,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1278,
  [1279] = 1247,
  [1280] = 1280,
  [1281] = 1249,
  [1282] = 1282,
  [1283] = 1267,
  [1284] = 1265,
  [1285] = 1257,
  [1286] = 1286,
  [1287] = 1264,
  [1288] = 1263,
  [1289] = 1289,
  [1290] = 1290,
  [1291] = 1291,
  [1292] = 885,
  [1293] = 1255,
  [1294] = 1294,
  [1295] = 1295,
  [1296] = 1260,
  [1297] = 1263,
  [1298] = 1264,
  [1299] = 1299,
  [1300] = 1300,
  [1301] = 1289,
  [1302] = 899,
  [1303] = 1267,
  [1304] = 886,
  [1305] = 1260,
  [1306] = 1255,
  [1307] = 1300,
  [1308] = 1265,
  [1309] = 1309,
  [1310] = 1310,
  [1311] = 1291,
  [1312] = 1258,
  [1313] = 1313,
  [1314] = 1257,
  [1315] = 1315,
  [1316] = 915,
  [1317] = 1317,
  [1318] = 1318,
  [1319] = 1319,
  [1320] = 1319,
  [1321] = 1318,
  [1322] = 1322,
  [1323] = 1086,
  [1324] = 1324,
  [1325] = 1325,
  [1326] = 1326,
  [1327] = 1327,
  [1328] = 1328,
  [1329] = 1329,
  [1330] = 1329,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 1333,
  [1334] = 1334,
  [1335] = 1335,
  [1336] = 1336,
  [1337] = 1337,
  [1338] = 1331,
  [1339] = 1319,
  [1340] = 913,
  [1341] = 1331,
  [1342] = 1342,
  [1343] = 1343,
  [1344] = 1084,
  [1345] = 1117,
  [1346] = 1346,
  [1347] = 1347,
  [1348] = 1117,
  [1349] = 1084,
  [1350] = 1331,
  [1351] = 1086,
  [1352] = 1319,
  [1353] = 1209,
  [1354] = 1209,
  [1355] = 1347,
  [1356] = 1347,
  [1357] = 1357,
  [1358] = 1357,
  [1359] = 1346,
  [1360] = 1360,
  [1361] = 889,
  [1362] = 978,
  [1363] = 1363,
  [1364] = 1346,
  [1365] = 1347,
  [1366] = 1117,
  [1367] = 1084,
  [1368] = 1331,
  [1369] = 1369,
  [1370] = 1370,
  [1371] = 989,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 1374,
  [1375] = 1086,
  [1376] = 1319,
  [1377] = 901,
  [1378] = 1346,
  [1379] = 1379,
  [1380] = 294,
  [1381] = 1381,
  [1382] = 1382,
  [1383] = 1383,
  [1384] = 1384,
  [1385] = 292,
  [1386] = 915,
  [1387] = 1387,
  [1388] = 1346,
  [1389] = 1347,
  [1390] = 291,
  [1391] = 1117,
  [1392] = 1084,
  [1393] = 1393,
  [1394] = 1331,
  [1395] = 1086,
  [1396] = 1319,
  [1397] = 1397,
  [1398] = 1398,
  [1399] = 1333,
  [1400] = 1400,
  [1401] = 1383,
  [1402] = 1402,
  [1403] = 1403,
  [1404] = 290,
  [1405] = 1405,
  [1406] = 1406,
  [1407] = 1336,
  [1408] = 1408,
  [1409] = 1409,
  [1410] = 1410,
  [1411] = 1411,
  [1412] = 1334,
  [1413] = 1413,
  [1414] = 1414,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1417,
  [1418] = 1418,
  [1419] = 1325,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1422,
  [1423] = 1423,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1426,
  [1427] = 1427,
  [1428] = 1346,
  [1429] = 1333,
  [1430] = 1357,
  [1431] = 1398,
  [1432] = 1347,
  [1433] = 1117,
  [1434] = 1084,
  [1435] = 1331,
  [1436] = 1436,
  [1437] = 901,
  [1438] = 1438,
  [1439] = 1086,
  [1440] = 1319,
  [1441] = 1398,
  [1442] = 1442,
  [1443] = 1443,
  [1444] = 1444,
  [1445] = 1445,
  [1446] = 1403,
  [1447] = 1447,
  [1448] = 1448,
  [1449] = 1449,
  [1450] = 944,
  [1451] = 1451,
  [1452] = 1452,
  [1453] = 1453,
  [1454] = 1454,
  [1455] = 1455,
  [1456] = 915,
  [1457] = 875,
  [1458] = 963,
  [1459] = 1459,
  [1460] = 1280,
  [1461] = 962,
  [1462] = 1462,
  [1463] = 1463,
  [1464] = 1274,
  [1465] = 1463,
  [1466] = 1466,
  [1467] = 1467,
  [1468] = 1467,
  [1469] = 1469,
  [1470] = 1470,
  [1471] = 1278,
  [1472] = 1277,
  [1473] = 1462,
  [1474] = 1276,
  [1475] = 1273,
  [1476] = 959,
  [1477] = 958,
  [1478] = 957,
  [1479] = 865,
  [1480] = 956,
  [1481] = 954,
  [1482] = 1274,
  [1483] = 1273,
  [1484] = 953,
  [1485] = 1462,
  [1486] = 952,
  [1487] = 951,
  [1488] = 950,
  [1489] = 1489,
  [1490] = 1454,
  [1491] = 1272,
  [1492] = 948,
  [1493] = 1276,
  [1494] = 1449,
  [1495] = 1495,
  [1496] = 1451,
  [1497] = 1277,
  [1498] = 1498,
  [1499] = 1278,
  [1500] = 947,
  [1501] = 1501,
  [1502] = 946,
  [1503] = 1503,
  [1504] = 1495,
  [1505] = 1505,
  [1506] = 1506,
  [1507] = 1501,
  [1508] = 1508,
  [1509] = 1449,
  [1510] = 1282,
  [1511] = 1511,
  [1512] = 1280,
  [1513] = 1513,
  [1514] = 1495,
  [1515] = 1515,
  [1516] = 1516,
  [1517] = 1517,
  [1518] = 1518,
  [1519] = 1519,
  [1520] = 1282,
  [1521] = 943,
  [1522] = 942,
  [1523] = 1519,
  [1524] = 964,
  [1525] = 1519,
  [1526] = 1495,
  [1527] = 1527,
  [1528] = 1528,
  [1529] = 1513,
  [1530] = 1324,
  [1531] = 941,
  [1532] = 930,
  [1533] = 1511,
  [1534] = 1449,
  [1535] = 864,
  [1536] = 940,
  [1537] = 1537,
  [1538] = 1538,
  [1539] = 939,
  [1540] = 1501,
  [1541] = 938,
  [1542] = 1542,
  [1543] = 1326,
  [1544] = 937,
  [1545] = 936,
  [1546] = 935,
  [1547] = 934,
  [1548] = 1335,
  [1549] = 1272,
  [1550] = 933,
  [1551] = 974,
  [1552] = 1449,
  [1553] = 1511,
  [1554] = 1554,
  [1555] = 1511,
  [1556] = 976,
  [1557] = 1449,
  [1558] = 1513,
  [1559] = 1519,
  [1560] = 945,
  [1561] = 1495,
  [1562] = 1495,
  [1563] = 1511,
  [1564] = 1564,
  [1565] = 1363,
  [1566] = 1495,
  [1567] = 931,
  [1568] = 865,
  [1569] = 1569,
  [1570] = 901,
  [1571] = 987,
  [1572] = 1379,
  [1573] = 1400,
  [1574] = 988,
  [1575] = 1402,
  [1576] = 1405,
  [1577] = 1518,
  [1578] = 1513,
  [1579] = 1579,
  [1580] = 965,
  [1581] = 1519,
  [1582] = 1527,
  [1583] = 1408,
  [1584] = 1584,
  [1585] = 1518,
  [1586] = 1527,
  [1587] = 1587,
  [1588] = 1372,
  [1589] = 1513,
  [1590] = 1495,
  [1591] = 1451,
  [1592] = 1449,
  [1593] = 1593,
  [1594] = 1420,
  [1595] = 1421,
  [1596] = 1268,
  [1597] = 1374,
  [1598] = 1422,
  [1599] = 1599,
  [1600] = 1519,
  [1601] = 1601,
  [1602] = 1444,
  [1603] = 1448,
  [1604] = 1445,
  [1605] = 1513,
  [1606] = 1436,
  [1607] = 1449,
  [1608] = 1608,
  [1609] = 1511,
  [1610] = 1418,
  [1611] = 1417,
  [1612] = 1180,
  [1613] = 1613,
  [1614] = 1614,
  [1615] = 1614,
  [1616] = 1614,
  [1617] = 1617,
  [1618] = 1613,
  [1619] = 1619,
  [1620] = 1620,
  [1621] = 1621,
  [1622] = 1622,
  [1623] = 1623,
  [1624] = 1614,
  [1625] = 1617,
  [1626] = 1613,
  [1627] = 1627,
  [1628] = 1620,
  [1629] = 1623,
  [1630] = 1630,
  [1631] = 1631,
  [1632] = 1614,
  [1633] = 1633,
  [1634] = 1634,
  [1635] = 1635,
  [1636] = 1617,
  [1637] = 1637,
  [1638] = 1638,
  [1639] = 1639,
  [1640] = 1640,
  [1641] = 1641,
  [1642] = 1638,
  [1643] = 1621,
  [1644] = 1635,
  [1645] = 1645,
  [1646] = 1646,
  [1647] = 1647,
  [1648] = 1648,
  [1649] = 1649,
  [1650] = 1634,
  [1651] = 1651,
  [1652] = 1614,
  [1653] = 1641,
  [1654] = 1621,
  [1655] = 1655,
  [1656] = 1621,
  [1657] = 1651,
  [1658] = 1658,
  [1659] = 1658,
  [1660] = 1622,
  [1661] = 1661,
  [1662] = 1662,
  [1663] = 1663,
  [1664] = 1641,
  [1665] = 1665,
  [1666] = 1646,
  [1667] = 1667,
  [1668] = 1668,
  [1669] = 1627,
  [1670] = 1655,
  [1671] = 1630,
  [1672] = 1672,
  [1673] = 1639,
  [1674] = 1641,
  [1675] = 1622,
  [1676] = 1651,
  [1677] = 1621,
  [1678] = 1622,
  [1679] = 1679,
  [1680] = 1641,
  [1681] = 1681,
  [1682] = 1179,
  [1683] = 1683,
  [1684] = 1684,
  [1685] = 1640,
  [1686] = 1681,
  [1687] = 1622,
  [1688] = 1684,
  [1689] = 1689,
  [1690] = 1690,
  [1691] = 1649,
  [1692] = 1638,
  [1693] = 1693,
  [1694] = 1638,
  [1695] = 1690,
  [1696] = 1645,
  [1697] = 1697,
  [1698] = 1693,
  [1699] = 1658,
  [1700] = 1651,
  [1701] = 1701,
  [1702] = 1702,
  [1703] = 1633,
  [1704] = 1651,
  [1705] = 1633,
  [1706] = 1706,
  [1707] = 1707,
  [1708] = 1623,
  [1709] = 1709,
  [1710] = 1621,
  [1711] = 1649,
  [1712] = 1158,
  [1713] = 1713,
  [1714] = 1622,
  [1715] = 1655,
  [1716] = 1156,
  [1717] = 1631,
  [1718] = 1713,
  [1719] = 1651,
  [1720] = 1707,
  [1721] = 1627,
  [1722] = 1641,
  [1723] = 1630,
  [1724] = 1724,
  [1725] = 1702,
  [1726] = 1627,
  [1727] = 1639,
  [1728] = 1630,
  [1729] = 1630,
  [1730] = 1627,
  [1731] = 1630,
  [1732] = 1638,
  [1733] = 1733,
  [1734] = 1645,
  [1735] = 1637,
  [1736] = 1140,
  [1737] = 1737,
  [1738] = 1738,
  [1739] = 1739,
  [1740] = 1627,
  [1741] = 1638,
  [1742] = 1709,
  [1743] = 1637,
  [1744] = 1620,
  [1745] = 1745,
  [1746] = 1746,
  [1747] = 1747,
  [1748] = 1748,
  [1749] = 1749,
  [1750] = 1750,
  [1751] = 1751,
  [1752] = 1752,
  [1753] = 1751,
  [1754] = 1754,
  [1755] = 1755,
  [1756] = 1756,
  [1757] = 1757,
  [1758] = 1758,
  [1759] = 1759,
  [1760] = 1760,
  [1761] = 1748,
  [1762] = 1762,
  [1763] = 1763,
  [1764] = 1764,
  [1765] = 1765,
  [1766] = 1750,
  [1767] = 1756,
  [1768] = 1768,
  [1769] = 1769,
  [1770] = 1770,
  [1771] = 1749,
  [1772] = 1772,
  [1773] = 1757,
  [1774] = 1758,
  [1775] = 1775,
  [1776] = 1776,
  [1777] = 1750,
  [1778] = 1778,
  [1779] = 1760,
  [1780] = 1780,
  [1781] = 1781,
  [1782] = 1756,
  [1783] = 1769,
  [1784] = 1784,
  [1785] = 1785,
  [1786] = 1749,
  [1787] = 1756,
  [1788] = 1788,
  [1789] = 1749,
  [1790] = 1790,
  [1791] = 1757,
  [1792] = 1769,
  [1793] = 1793,
  [1794] = 1785,
  [1795] = 1795,
  [1796] = 1748,
  [1797] = 1748,
  [1798] = 1798,
  [1799] = 1799,
  [1800] = 1800,
  [1801] = 1801,
  [1802] = 1802,
  [1803] = 1803,
  [1804] = 1804,
  [1805] = 1805,
  [1806] = 1806,
  [1807] = 1807,
  [1808] = 1778,
  [1809] = 1747,
  [1810] = 1772,
  [1811] = 1811,
  [1812] = 1812,
  [1813] = 1812,
  [1814] = 1814,
  [1815] = 1776,
  [1816] = 1816,
  [1817] = 1756,
  [1818] = 1769,
  [1819] = 1819,
  [1820] = 1811,
  [1821] = 1749,
  [1822] = 1754,
  [1823] = 1768,
  [1824] = 1824,
  [1825] = 1751,
  [1826] = 1826,
  [1827] = 1801,
  [1828] = 1828,
  [1829] = 1829,
  [1830] = 1798,
  [1831] = 1746,
  [1832] = 1804,
  [1833] = 1763,
  [1834] = 1834,
  [1835] = 1745,
  [1836] = 1804,
  [1837] = 1805,
  [1838] = 1807,
  [1839] = 1778,
  [1840] = 1765,
  [1841] = 1811,
  [1842] = 1812,
  [1843] = 1843,
  [1844] = 1756,
  [1845] = 1769,
  [1846] = 1765,
  [1847] = 1847,
  [1848] = 1785,
  [1849] = 1772,
  [1850] = 1807,
  [1851] = 1851,
  [1852] = 1752,
  [1853] = 1853,
  [1854] = 1763,
  [1855] = 1855,
  [1856] = 1814,
  [1857] = 1745,
  [1858] = 1858,
  [1859] = 1746,
  [1860] = 1860,
  [1861] = 1798,
  [1862] = 1862,
  [1863] = 1805,
  [1864] = 1748,
  [1865] = 1865,
  [1866] = 1866,
  [1867] = 1860,
  [1868] = 1868,
  [1869] = 1776,
  [1870] = 1748,
  [1871] = 1868,
  [1872] = 1749,
  [1873] = 1873,
  [1874] = 1754,
  [1875] = 1875,
  [1876] = 1876,
  [1877] = 1801,
  [1878] = 1851,
  [1879] = 1875,
  [1880] = 1873,
  [1881] = 1881,
  [1882] = 1882,
  [1883] = 1819,
  [1884] = 1799,
  [1885] = 1885,
  [1886] = 1853,
  [1887] = 1756,
  [1888] = 1780,
  [1889] = 1770,
  [1890] = 1769,
  [1891] = 1860,
  [1892] = 1851,
  [1893] = 1875,
  [1894] = 1873,
  [1895] = 1895,
  [1896] = 1896,
  [1897] = 1799,
  [1898] = 1898,
  [1899] = 1853,
  [1900] = 1759,
  [1901] = 1780,
  [1902] = 1770,
  [1903] = 1760,
  [1904] = 1759,
  [1905] = 1752,
  [1906] = 1829,
  [1907] = 1814,
  [1908] = 1868,
  [1909] = 1868,
  [1910] = 1868,
  [1911] = 1868,
};

static inline bool sym_rune_literal_character_set_1(int32_t c) {
  return (c < 'f'
    ? (c < '\\'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '\\' || (c >= 'a' && c <= 'b')))
    : (c <= 'f' || (c < 't'
      ? (c < 'r'
        ? c == 'n'
        : c <= 'r')
      : (c <= 't' || c == 'v'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(82);
      if (!eof && lookahead == 0) ADVANCE(85);
      if (lookahead == '!') ADVANCE(135);
      if (lookahead == '"') ADVANCE(222);
      if (lookahead == '%') ADVANCE(145);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(155);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '@') ADVANCE(244);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '\\') ADVANCE(40);
      if (lookahead == ']') ADVANCE(94);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'c') ADVANCE(192);
      if (lookahead == 'e') ADVANCE(195);
      if (lookahead == 'i') ADVANCE(190);
      if (lookahead == 's') ADVANCE(183);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(106);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(80)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 1:
      if (!eof && lookahead == 0) ADVANCE(85);
      if (lookahead == '\n') ADVANCE(83);
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '%') ADVANCE(145);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(38);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == 'e') ADVANCE(198);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(106);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 2:
      if (!eof && lookahead == 0) ADVANCE(85);
      if (lookahead == '\n') ADVANCE(83);
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '%') ADVANCE(144);
      if (lookahead == '&') ADVANCE(140);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(160);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(164);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(106);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(32)
      if (lookahead == '"') ADVANCE(222);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\\') ADVANCE(40);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(226);
      if (lookahead != 0) ADVANCE(227);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(22);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(168);
      if (lookahead == ':') ADVANCE(123);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == ']') ADVANCE(94);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '}') ADVANCE(106);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(170);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(168);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '}') ADVANCE(106);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(170);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(168);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'c') ADVANCE(192);
      if (lookahead == '}') ADVANCE(106);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(170);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '%') ADVANCE(144);
      if (lookahead == '&') ADVANCE(140);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(158);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(164);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == ']') ADVANCE(94);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(106);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '%') ADVANCE(145);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(38);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == 'i') ADVANCE(46);
      if (lookahead == 's') ADVANCE(43);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(99);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8)
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '%') ADVANCE(145);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(130);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(38);
      if (lookahead == '<') ADVANCE(159);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == 'e') ADVANCE(198);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(106);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '%') ADVANCE(144);
      if (lookahead == '&') ADVANCE(140);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(141);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(160);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(164);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == ']') ADVANCE(94);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(100);
      if (lookahead == '}') ADVANCE(106);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '/') ADVANCE(273);
      if (lookahead == '{') ADVANCE(105);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11)
      if (lookahead != 0 &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(276);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '/') ADVANCE(285);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(286);
      if (lookahead != 0) ADVANCE(287);
      END_STATE();
    case 13:
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '/') ADVANCE(280);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(281);
      if (lookahead != 0) ADVANCE(282);
      END_STATE();
    case 14:
      if (lookahead == '\'') ADVANCE(235);
      END_STATE();
    case 15:
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '<') ADVANCE(154);
      if (lookahead == '@') ADVANCE(244);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '}') ADVANCE(106);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 16:
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '@') ADVANCE(244);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '{') ADVANCE(103);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(241);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(241);
      if (lookahead == '>') ADVANCE(248);
      END_STATE();
    case 19:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(236);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 20:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead != 0) ADVANCE(20);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(108);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(232);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(95);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(246);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(24);
      END_STATE();
    case 26:
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '<') ADVANCE(154);
      if (lookahead == '@') ADVANCE(244);
      if (lookahead == 'e') ADVANCE(198);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '}') ADVANCE(106);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(26)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 27:
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '<') ADVANCE(156);
      if (lookahead == '@') ADVANCE(244);
      if (lookahead == 'e') ADVANCE(198);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == '{') ADVANCE(103);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(27)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 28:
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '=') ADVANCE(91);
      if (lookahead == '{') ADVANCE(104);
      if (lookahead == '}') ADVANCE(107);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(28)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(272);
      END_STATE();
    case 29:
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == 'i') ADVANCE(45);
      if (lookahead == '{') ADVANCE(102);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(29)
      END_STATE();
    case 30:
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == 's') ADVANCE(259);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 31:
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '}') ADVANCE(106);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(31)
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(255);
      END_STATE();
    case 32:
      if (lookahead == '/') ADVANCE(17);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(32)
      END_STATE();
    case 33:
      if (lookahead == '/') ADVANCE(17);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(33)
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 34:
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '=') ADVANCE(91);
      if (lookahead == '>') ADVANCE(162);
      if (lookahead == 'i') ADVANCE(269);
      if (lookahead == '{') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(34)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '<') ADVANCE(272);
      END_STATE();
    case 35:
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '=') ADVANCE(91);
      if (lookahead == '>') ADVANCE(162);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(35)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '<') ADVANCE(272);
      END_STATE();
    case 36:
      if (lookahead == '/') ADVANCE(18);
      if (lookahead == '>') ADVANCE(162);
      if (lookahead == 'e') ADVANCE(270);
      if (lookahead == 'i') ADVANCE(269);
      if (lookahead == '{') ADVANCE(104);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(36)
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '<' &&
          lookahead != '=') ADVANCE(272);
      END_STATE();
    case 37:
      if (lookahead == '=') ADVANCE(153);
      END_STATE();
    case 38:
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 39:
      if (lookahead == '=') ADVANCE(152);
      END_STATE();
    case 40:
      if (lookahead == 'U') ADVANCE(76);
      if (lookahead == 'u') ADVANCE(68);
      if (lookahead == 'x') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(230);
      if (lookahead != 0) ADVANCE(228);
      END_STATE();
    case 41:
      if (lookahead == '\\') ADVANCE(58);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(14);
      END_STATE();
    case 42:
      if (lookahead == '`') ADVANCE(220);
      if (lookahead != 0) ADVANCE(42);
      END_STATE();
    case 43:
      if (lookahead == 'c') ADVANCE(50);
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(250);
      END_STATE();
    case 45:
      if (lookahead == 'f') ADVANCE(253);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(125);
      END_STATE();
    case 47:
      if (lookahead == 'i') ADVANCE(49);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(44);
      END_STATE();
    case 49:
      if (lookahead == 'p') ADVANCE(51);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(256);
      END_STATE();
    case 52:
      if (lookahead == 'y') ADVANCE(48);
      END_STATE();
    case 53:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      END_STATE();
    case 54:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(53);
      if (lookahead == '_') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 55:
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(14);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(56);
      END_STATE();
    case 58:
      if (sym_rune_literal_character_set_1(lookahead)) ADVANCE(14);
      if (lookahead == 'U') ADVANCE(77);
      if (lookahead == 'u') ADVANCE(69);
      if (lookahead == 'x') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(57);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(232);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(228);
      END_STATE();
    case 62:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(14);
      END_STATE();
    case 63:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 64:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(61);
      END_STATE();
    case 65:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(62);
      END_STATE();
    case 66:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(64);
      END_STATE();
    case 67:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(65);
      END_STATE();
    case 68:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(66);
      END_STATE();
    case 69:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 70:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 71:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(69);
      END_STATE();
    case 72:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(70);
      END_STATE();
    case 73:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(71);
      END_STATE();
    case 74:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(72);
      END_STATE();
    case 75:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(73);
      END_STATE();
    case 76:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(74);
      END_STATE();
    case 77:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(75);
      END_STATE();
    case 78:
      if (eof) ADVANCE(82);
      if (!eof && lookahead == 0) ADVANCE(85);
      if (lookahead == '\n') ADVANCE(83);
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(168);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(98);
      if (lookahead == '}') ADVANCE(106);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(78)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(170);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 79:
      if (eof) ADVANCE(82);
      if (!eof && lookahead == 0) ADVANCE(85);
      if (lookahead == '\n') ADVANCE(83);
      if (lookahead == '!') ADVANCE(37);
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '%') ADVANCE(145);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(86);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(157);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(106);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(79)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 80:
      if (eof) ADVANCE(82);
      if (!eof && lookahead == 0) ADVANCE(85);
      if (lookahead == '!') ADVANCE(135);
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '%') ADVANCE(145);
      if (lookahead == '&') ADVANCE(139);
      if (lookahead == '\'') ADVANCE(277);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(97);
      if (lookahead == '+') ADVANCE(129);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(143);
      if (lookahead == '0') ADVANCE(208);
      if (lookahead == ':') ADVANCE(124);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(155);
      if (lookahead == '=') ADVANCE(92);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '@') ADVANCE(244);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == ']') ADVANCE(94);
      if (lookahead == '^') ADVANCE(137);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'c') ADVANCE(192);
      if (lookahead == 'e') ADVANCE(195);
      if (lookahead == 'i') ADVANCE(190);
      if (lookahead == 's') ADVANCE(183);
      if (lookahead == '{') ADVANCE(103);
      if (lookahead == '|') ADVANCE(99);
      if (lookahead == '}') ADVANCE(106);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(80)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 81:
      if (eof) ADVANCE(82);
      if (lookahead == '!') ADVANCE(134);
      if (lookahead == '"') ADVANCE(221);
      if (lookahead == '&') ADVANCE(138);
      if (lookahead == '\'') ADVANCE(41);
      if (lookahead == '(') ADVANCE(88);
      if (lookahead == ')') ADVANCE(89);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(128);
      if (lookahead == ',') ADVANCE(90);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '0') ADVANCE(168);
      if (lookahead == ':') ADVANCE(123);
      if (lookahead == ';') ADVANCE(84);
      if (lookahead == '<') ADVANCE(21);
      if (lookahead == '=') ADVANCE(91);
      if (lookahead == '[') ADVANCE(93);
      if (lookahead == ']') ADVANCE(94);
      if (lookahead == '^') ADVANCE(136);
      if (lookahead == '`') ADVANCE(42);
      if (lookahead == 'i') ADVANCE(191);
      if (lookahead == 's') ADVANCE(184);
      if (lookahead == '{') ADVANCE(102);
      if (lookahead == '|') ADVANCE(98);
      if (lookahead == '~') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(81)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(170);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LF);
      if (lookahead == '\n') ADVANCE(83);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_NULL);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(23);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(152);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(121);
      if (lookahead == '|') ADVANCE(167);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(167);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead == '!') ADVANCE(245);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(272);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(276);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(272);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_AMP_CARET_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(110);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(153);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(122);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(166);
      if (lookahead == '=') ADVANCE(117);
      if (lookahead == '^') ADVANCE(151);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(166);
      if (lookahead == '^') ADVANCE(150);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(241);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(241);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(20);
      if (lookahead == '/') ADVANCE(241);
      if (lookahead == '=') ADVANCE(113);
      if (lookahead == '>') ADVANCE(248);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_AMP_CARET);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(249);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(249);
      if (lookahead == '-') ADVANCE(108);
      if (lookahead == '/') ADVANCE(247);
      if (lookahead == '<') ADVANCE(147);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '!') ADVANCE(249);
      if (lookahead == '/') ADVANCE(247);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(108);
      if (lookahead == '<') ADVANCE(147);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '-') ADVANCE(108);
      if (lookahead == '<') ADVANCE(146);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(147);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(146);
      if (lookahead == '=') ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(165);
      if (lookahead == '>') ADVANCE(149);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(165);
      if (lookahead == '>') ADVANCE(148);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(233);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(181);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(207);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(179);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(173);
      if (lookahead == '_') ADVANCE(211);
      if (lookahead == 'i') ADVANCE(219);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(233);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(207);
      if (lookahead == '_') ADVANCE(211);
      if (lookahead == 'i') ADVANCE(219);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(233);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(207);
      if (lookahead == '_') ADVANCE(215);
      if (lookahead == 'i') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(170);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(207);
      if (lookahead == '_') ADVANCE(218);
      if (lookahead == 'i') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(171);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '_') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(171);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(174);
      if (lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(214);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(209);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(176);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(177);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(213);
      if (lookahead == 'i') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      if (lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      if (lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(210);
      if (lookahead == 'i') ADVANCE(219);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(180);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(210);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(180);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(216);
      if (lookahead == 'i') ADVANCE(219);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(201);
      if (lookahead == 't') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(254);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(253);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(196);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(203);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(193);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(176);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(174);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(177);
      if (lookahead == '_') ADVANCE(212);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(174);
      if (lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(176);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(180);
      if (('2' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '8' ||
          lookahead == '9') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(169);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(174);
      if (lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(178);
      if (lookahead == '8' ||
          lookahead == '9' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(175);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(170);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(177);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(171);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(sym_raw_string_literal);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_DQUOTE2);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(225);
      if (lookahead == '/') ADVANCE(227);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(227);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(224);
      if (lookahead == '/') ADVANCE(227);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(225);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '*') ADVANCE(224);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(225);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead == '/') ADVANCE(223);
      if (lookahead == '\t' ||
          (11 <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(226);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(227);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym__interpreted_string_literal_basic_content);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(227);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(228);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(229);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == '_') ADVANCE(60);
      if (lookahead == 'i') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(231);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (lookahead == '_') ADVANCE(59);
      if (lookahead == 'i') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(232);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_float_literal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (lookahead == 'i') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(232);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_imaginary_literal);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_rune_literal);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(282);
      if (lookahead == '\'') ADVANCE(241);
      if (lookahead != 0) ADVANCE(237);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\n') ADVANCE(287);
      if (lookahead == '"') ADVANCE(241);
      if (lookahead != 0) ADVANCE(238);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '\t' ||
          (11 <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == '"' ||
          lookahead == '\'' ||
          ('<' <= lookahead && lookahead <= '>')) ADVANCE(241);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(239);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(276);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(241);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(287);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(282);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_LBRACE_BANG);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_children_DOT_DOT_DOT);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_LT_SLASH);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_SLASH_GT);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_LT_BANG);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_style);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_style);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_style);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_if2);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_else2);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_css_property_name);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(255);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_script);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_script);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_script);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(219);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == 'c') ADVANCE(264);
      if (lookahead == 't') ADVANCE(266);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == 'e') ADVANCE(251);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == 'i') ADVANCE(263);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == 'l') ADVANCE(260);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == 'p') ADVANCE(265);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == 'r') ADVANCE(261);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == 't') ADVANCE(257);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == 'y') ADVANCE(262);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_element_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(267);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead == 'e') ADVANCE(254);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(272);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead == 'f') ADVANCE(253);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(272);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead == 'l') ADVANCE(271);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(272);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead == 's') ADVANCE(268);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_attribute_name);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '/' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(272);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_attribute_value);
      if (lookahead == '*') ADVANCE(275);
      if (lookahead == '/') ADVANCE(239);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(276);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_attribute_value);
      if (lookahead == '*') ADVANCE(274);
      if (lookahead == '/') ADVANCE(240);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == '"' ||
          lookahead == '\'' ||
          ('<' <= lookahead && lookahead <= '>')) ADVANCE(20);
      if (lookahead != 0) ADVANCE(275);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_attribute_value);
      if (lookahead == '*') ADVANCE(274);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == '"' ||
          lookahead == '\'' ||
          ('<' <= lookahead && lookahead <= '>')) ADVANCE(20);
      if (lookahead != 0) ADVANCE(275);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_attribute_value);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != '"' &&
          lookahead != '\'' &&
          (lookahead < '<' || '>' < lookahead)) ADVANCE(276);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(20);
      if (lookahead == '*') ADVANCE(278);
      if (lookahead == '/') ADVANCE(243);
      if (lookahead != 0) ADVANCE(279);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '\'') ADVANCE(20);
      if (lookahead == '*') ADVANCE(278);
      if (lookahead != 0) ADVANCE(279);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '*') ADVANCE(279);
      if (lookahead == '/') ADVANCE(237);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(282);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead == '/') ADVANCE(280);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(281);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(282);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token1);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(282);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '*') ADVANCE(283);
      if (lookahead == '/') ADVANCE(242);
      if (lookahead != 0) ADVANCE(284);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '"') ADVANCE(20);
      if (lookahead == '*') ADVANCE(283);
      if (lookahead != 0) ADVANCE(284);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '*') ADVANCE(284);
      if (lookahead == '/') ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(287);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead == '/') ADVANCE(285);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(286);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(287);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(aux_sym_quoted_attribute_value_token2);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(287);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '_') ADVANCE(1);
      if (lookahead == 'b') ADVANCE(2);
      if (lookahead == 'c') ADVANCE(3);
      if (lookahead == 'd') ADVANCE(4);
      if (lookahead == 'f') ADVANCE(5);
      if (lookahead == 'g') ADVANCE(6);
      if (lookahead == 'h') ADVANCE(7);
      if (lookahead == 'i') ADVANCE(8);
      if (lookahead == 'm') ADVANCE(9);
      if (lookahead == 'n') ADVANCE(10);
      if (lookahead == 'p') ADVANCE(11);
      if (lookahead == 'r') ADVANCE(12);
      if (lookahead == 's') ADVANCE(13);
      if (lookahead == 't') ADVANCE(14);
      if (lookahead == 'v') ADVANCE(15);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0)
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_blank_identifier);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(16);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(17);
      if (lookahead == 'h') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 5:
      if (lookahead == 'a') ADVANCE(22);
      if (lookahead == 'o') ADVANCE(23);
      if (lookahead == 'u') ADVANCE(24);
      END_STATE();
    case 6:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 7:
      if (lookahead == 't') ADVANCE(26);
      END_STATE();
    case 8:
      if (lookahead == 'm') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(30);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'i') ADVANCE(32);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'e') ADVANCE(35);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(36);
      if (lookahead == 't') ADVANCE(37);
      if (lookahead == 'w') ADVANCE(38);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(39);
      if (lookahead == 'r') ADVANCE(40);
      if (lookahead == 'y') ADVANCE(41);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(42);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 17:
      if (lookahead == 's') ADVANCE(44);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(45);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(46);
      END_STATE();
    case 20:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 21:
      if (lookahead == 'f') ADVANCE(48);
      END_STATE();
    case 22:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 23:
      if (lookahead == 'r') ADVANCE(50);
      END_STATE();
    case 24:
      if (lookahead == 'n') ADVANCE(51);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_go);
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 26:
      if (lookahead == 'm') ADVANCE(53);
      END_STATE();
    case 27:
      if (lookahead == 'p') ADVANCE(54);
      END_STATE();
    case 28:
      if (lookahead == 't') ADVANCE(55);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 30:
      if (lookahead == 'k') ADVANCE(57);
      if (lookahead == 'p') ADVANCE(58);
      END_STATE();
    case 31:
      if (lookahead == 'w') ADVANCE(59);
      END_STATE();
    case 32:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 33:
      if (lookahead == 'c') ADVANCE(61);
      END_STATE();
    case 34:
      if (lookahead == 'n') ADVANCE(62);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 36:
      if (lookahead == 'l') ADVANCE(64);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(65);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 39:
      if (lookahead == 'm') ADVANCE(67);
      END_STATE();
    case 40:
      if (lookahead == 'u') ADVANCE(68);
      END_STATE();
    case 41:
      if (lookahead == 'p') ADVANCE(69);
      END_STATE();
    case 42:
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(71);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 45:
      if (lookahead == 'n') ADVANCE(73);
      END_STATE();
    case 46:
      if (lookahead == 's') ADVANCE(74);
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_css);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(76);
      if (lookahead == 'e') ADVANCE(77);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(78);
      if (lookahead == 's') ADVANCE(79);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 51:
      if (lookahead == 'c') ADVANCE(80);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(81);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 54:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 55:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 56:
      if (lookahead == 'a') ADVANCE(85);
      END_STATE();
    case 57:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_map);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 61:
      if (lookahead == 'k') ADVANCE(87);
      END_STATE();
    case 62:
      if (lookahead == 'g') ADVANCE(88);
      END_STATE();
    case 63:
      if (lookahead == 'u') ADVANCE(89);
      END_STATE();
    case 64:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 65:
      if (lookahead == 'u') ADVANCE(91);
      END_STATE();
    case 66:
      if (lookahead == 't') ADVANCE(92);
      END_STATE();
    case 67:
      if (lookahead == 'p') ADVANCE(93);
      END_STATE();
    case 68:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 69:
      if (lookahead == 'e') ADVANCE(95);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 71:
      if (lookahead == 'k') ADVANCE(96);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_chan);
      END_STATE();
    case 74:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 75:
      if (lookahead == 'i') ADVANCE(98);
      END_STATE();
    case 76:
      if (lookahead == 'u') ADVANCE(99);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(100);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(101);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(102);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_goto);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_html);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_iota);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_make);
      END_STATE();
    case 87:
      if (lookahead == 'a') ADVANCE(105);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(106);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(107);
      END_STATE();
    case 90:
      if (lookahead == 'c') ADVANCE(108);
      END_STATE();
    case 91:
      if (lookahead == 'c') ADVANCE(109);
      END_STATE();
    case 92:
      if (lookahead == 'c') ADVANCE(110);
      END_STATE();
    case 93:
      if (lookahead == 'l') ADVANCE(111);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 98:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 99:
      if (lookahead == 'l') ADVANCE(113);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_defer);
      END_STATE();
    case 101:
      if (lookahead == 'h') ADVANCE(114);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 104:
      if (lookahead == 'f') ADVANCE(116);
      END_STATE();
    case 105:
      if (lookahead == 'g') ADVANCE(117);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_range);
      END_STATE();
    case 107:
      if (lookahead == 'n') ADVANCE(118);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(119);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 110:
      if (lookahead == 'h') ADVANCE(121);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_templ);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(122);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 114:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 116:
      if (lookahead == 'a') ADVANCE(125);
      END_STATE();
    case 117:
      if (lookahead == 'e') ADVANCE(126);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_select);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 122:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 124:
      if (lookahead == 'o') ADVANCE(128);
      END_STATE();
    case 125:
      if (lookahead == 'c') ADVANCE(129);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_package);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 128:
      if (lookahead == 'u') ADVANCE(130);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 130:
      if (lookahead == 'g') ADVANCE(132);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 132:
      if (lookahead == 'h') ADVANCE(133);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_fallthrough);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 81},
  [2] = {.lex_state = 81},
  [3] = {.lex_state = 81},
  [4] = {.lex_state = 5},
  [5] = {.lex_state = 5},
  [6] = {.lex_state = 5},
  [7] = {.lex_state = 5},
  [8] = {.lex_state = 5},
  [9] = {.lex_state = 5},
  [10] = {.lex_state = 5},
  [11] = {.lex_state = 5},
  [12] = {.lex_state = 5},
  [13] = {.lex_state = 5},
  [14] = {.lex_state = 5},
  [15] = {.lex_state = 5},
  [16] = {.lex_state = 5},
  [17] = {.lex_state = 5},
  [18] = {.lex_state = 5},
  [19] = {.lex_state = 5},
  [20] = {.lex_state = 5},
  [21] = {.lex_state = 4},
  [22] = {.lex_state = 4},
  [23] = {.lex_state = 4},
  [24] = {.lex_state = 4},
  [25] = {.lex_state = 4},
  [26] = {.lex_state = 4},
  [27] = {.lex_state = 4},
  [28] = {.lex_state = 4},
  [29] = {.lex_state = 4},
  [30] = {.lex_state = 4},
  [31] = {.lex_state = 4},
  [32] = {.lex_state = 4},
  [33] = {.lex_state = 4},
  [34] = {.lex_state = 4},
  [35] = {.lex_state = 4},
  [36] = {.lex_state = 4},
  [37] = {.lex_state = 4},
  [38] = {.lex_state = 78},
  [39] = {.lex_state = 4},
  [40] = {.lex_state = 4},
  [41] = {.lex_state = 4},
  [42] = {.lex_state = 4},
  [43] = {.lex_state = 4},
  [44] = {.lex_state = 4},
  [45] = {.lex_state = 4},
  [46] = {.lex_state = 4},
  [47] = {.lex_state = 4},
  [48] = {.lex_state = 4},
  [49] = {.lex_state = 4},
  [50] = {.lex_state = 4},
  [51] = {.lex_state = 4},
  [52] = {.lex_state = 4},
  [53] = {.lex_state = 4},
  [54] = {.lex_state = 4},
  [55] = {.lex_state = 4},
  [56] = {.lex_state = 4},
  [57] = {.lex_state = 4},
  [58] = {.lex_state = 4},
  [59] = {.lex_state = 4},
  [60] = {.lex_state = 4},
  [61] = {.lex_state = 4},
  [62] = {.lex_state = 6},
  [63] = {.lex_state = 4},
  [64] = {.lex_state = 4},
  [65] = {.lex_state = 4},
  [66] = {.lex_state = 4},
  [67] = {.lex_state = 4},
  [68] = {.lex_state = 4},
  [69] = {.lex_state = 4},
  [70] = {.lex_state = 4},
  [71] = {.lex_state = 4},
  [72] = {.lex_state = 4},
  [73] = {.lex_state = 4},
  [74] = {.lex_state = 4},
  [75] = {.lex_state = 4},
  [76] = {.lex_state = 4},
  [77] = {.lex_state = 4},
  [78] = {.lex_state = 4},
  [79] = {.lex_state = 4},
  [80] = {.lex_state = 6},
  [81] = {.lex_state = 4},
  [82] = {.lex_state = 4},
  [83] = {.lex_state = 4},
  [84] = {.lex_state = 4},
  [85] = {.lex_state = 4},
  [86] = {.lex_state = 4},
  [87] = {.lex_state = 4},
  [88] = {.lex_state = 4},
  [89] = {.lex_state = 4},
  [90] = {.lex_state = 6},
  [91] = {.lex_state = 4},
  [92] = {.lex_state = 4},
  [93] = {.lex_state = 4},
  [94] = {.lex_state = 4},
  [95] = {.lex_state = 4},
  [96] = {.lex_state = 4},
  [97] = {.lex_state = 4},
  [98] = {.lex_state = 4},
  [99] = {.lex_state = 4},
  [100] = {.lex_state = 4},
  [101] = {.lex_state = 4},
  [102] = {.lex_state = 4},
  [103] = {.lex_state = 4},
  [104] = {.lex_state = 4},
  [105] = {.lex_state = 4},
  [106] = {.lex_state = 4},
  [107] = {.lex_state = 4},
  [108] = {.lex_state = 4},
  [109] = {.lex_state = 4},
  [110] = {.lex_state = 4},
  [111] = {.lex_state = 4},
  [112] = {.lex_state = 4},
  [113] = {.lex_state = 4},
  [114] = {.lex_state = 4},
  [115] = {.lex_state = 4},
  [116] = {.lex_state = 4},
  [117] = {.lex_state = 4},
  [118] = {.lex_state = 4},
  [119] = {.lex_state = 4},
  [120] = {.lex_state = 4},
  [121] = {.lex_state = 4},
  [122] = {.lex_state = 4},
  [123] = {.lex_state = 4},
  [124] = {.lex_state = 4},
  [125] = {.lex_state = 4},
  [126] = {.lex_state = 4},
  [127] = {.lex_state = 4},
  [128] = {.lex_state = 4},
  [129] = {.lex_state = 4},
  [130] = {.lex_state = 4},
  [131] = {.lex_state = 4},
  [132] = {.lex_state = 4},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 4},
  [135] = {.lex_state = 4},
  [136] = {.lex_state = 4},
  [137] = {.lex_state = 4},
  [138] = {.lex_state = 4},
  [139] = {.lex_state = 4},
  [140] = {.lex_state = 4},
  [141] = {.lex_state = 4},
  [142] = {.lex_state = 4},
  [143] = {.lex_state = 4},
  [144] = {.lex_state = 4},
  [145] = {.lex_state = 4},
  [146] = {.lex_state = 4},
  [147] = {.lex_state = 4},
  [148] = {.lex_state = 4},
  [149] = {.lex_state = 4},
  [150] = {.lex_state = 4},
  [151] = {.lex_state = 4},
  [152] = {.lex_state = 4},
  [153] = {.lex_state = 4},
  [154] = {.lex_state = 4},
  [155] = {.lex_state = 4},
  [156] = {.lex_state = 4},
  [157] = {.lex_state = 4},
  [158] = {.lex_state = 4},
  [159] = {.lex_state = 4},
  [160] = {.lex_state = 4},
  [161] = {.lex_state = 4},
  [162] = {.lex_state = 4},
  [163] = {.lex_state = 4},
  [164] = {.lex_state = 4},
  [165] = {.lex_state = 4},
  [166] = {.lex_state = 4},
  [167] = {.lex_state = 4},
  [168] = {.lex_state = 4},
  [169] = {.lex_state = 4},
  [170] = {.lex_state = 4},
  [171] = {.lex_state = 4},
  [172] = {.lex_state = 4},
  [173] = {.lex_state = 4},
  [174] = {.lex_state = 4},
  [175] = {.lex_state = 4},
  [176] = {.lex_state = 4},
  [177] = {.lex_state = 4},
  [178] = {.lex_state = 4},
  [179] = {.lex_state = 4},
  [180] = {.lex_state = 4},
  [181] = {.lex_state = 4},
  [182] = {.lex_state = 4},
  [183] = {.lex_state = 4},
  [184] = {.lex_state = 4},
  [185] = {.lex_state = 4},
  [186] = {.lex_state = 4},
  [187] = {.lex_state = 4},
  [188] = {.lex_state = 4},
  [189] = {.lex_state = 4},
  [190] = {.lex_state = 4},
  [191] = {.lex_state = 4},
  [192] = {.lex_state = 4},
  [193] = {.lex_state = 4},
  [194] = {.lex_state = 4},
  [195] = {.lex_state = 4},
  [196] = {.lex_state = 4},
  [197] = {.lex_state = 4},
  [198] = {.lex_state = 4},
  [199] = {.lex_state = 4},
  [200] = {.lex_state = 4},
  [201] = {.lex_state = 4},
  [202] = {.lex_state = 4},
  [203] = {.lex_state = 4},
  [204] = {.lex_state = 4},
  [205] = {.lex_state = 4},
  [206] = {.lex_state = 4},
  [207] = {.lex_state = 4},
  [208] = {.lex_state = 4},
  [209] = {.lex_state = 4},
  [210] = {.lex_state = 4},
  [211] = {.lex_state = 4},
  [212] = {.lex_state = 4},
  [213] = {.lex_state = 4},
  [214] = {.lex_state = 4},
  [215] = {.lex_state = 4},
  [216] = {.lex_state = 4},
  [217] = {.lex_state = 4},
  [218] = {.lex_state = 4},
  [219] = {.lex_state = 4},
  [220] = {.lex_state = 4},
  [221] = {.lex_state = 4},
  [222] = {.lex_state = 4},
  [223] = {.lex_state = 4},
  [224] = {.lex_state = 4},
  [225] = {.lex_state = 4},
  [226] = {.lex_state = 4},
  [227] = {.lex_state = 4},
  [228] = {.lex_state = 4},
  [229] = {.lex_state = 4},
  [230] = {.lex_state = 4},
  [231] = {.lex_state = 4},
  [232] = {.lex_state = 4},
  [233] = {.lex_state = 4},
  [234] = {.lex_state = 4},
  [235] = {.lex_state = 4},
  [236] = {.lex_state = 4},
  [237] = {.lex_state = 4},
  [238] = {.lex_state = 4},
  [239] = {.lex_state = 4},
  [240] = {.lex_state = 4},
  [241] = {.lex_state = 4},
  [242] = {.lex_state = 4},
  [243] = {.lex_state = 4},
  [244] = {.lex_state = 4},
  [245] = {.lex_state = 4},
  [246] = {.lex_state = 4},
  [247] = {.lex_state = 4},
  [248] = {.lex_state = 4},
  [249] = {.lex_state = 4},
  [250] = {.lex_state = 4},
  [251] = {.lex_state = 4},
  [252] = {.lex_state = 4},
  [253] = {.lex_state = 4},
  [254] = {.lex_state = 4},
  [255] = {.lex_state = 4},
  [256] = {.lex_state = 4},
  [257] = {.lex_state = 4},
  [258] = {.lex_state = 4},
  [259] = {.lex_state = 4},
  [260] = {.lex_state = 4},
  [261] = {.lex_state = 4},
  [262] = {.lex_state = 4},
  [263] = {.lex_state = 4},
  [264] = {.lex_state = 4},
  [265] = {.lex_state = 4},
  [266] = {.lex_state = 4},
  [267] = {.lex_state = 4},
  [268] = {.lex_state = 4},
  [269] = {.lex_state = 4},
  [270] = {.lex_state = 4},
  [271] = {.lex_state = 4},
  [272] = {.lex_state = 4},
  [273] = {.lex_state = 4},
  [274] = {.lex_state = 4},
  [275] = {.lex_state = 4},
  [276] = {.lex_state = 4},
  [277] = {.lex_state = 4},
  [278] = {.lex_state = 81},
  [279] = {.lex_state = 7},
  [280] = {.lex_state = 79},
  [281] = {.lex_state = 79},
  [282] = {.lex_state = 79},
  [283] = {.lex_state = 79},
  [284] = {.lex_state = 79},
  [285] = {.lex_state = 79},
  [286] = {.lex_state = 79},
  [287] = {.lex_state = 79},
  [288] = {.lex_state = 79},
  [289] = {.lex_state = 79},
  [290] = {.lex_state = 79},
  [291] = {.lex_state = 79},
  [292] = {.lex_state = 1},
  [293] = {.lex_state = 79},
  [294] = {.lex_state = 1},
  [295] = {.lex_state = 79},
  [296] = {.lex_state = 8},
  [297] = {.lex_state = 79},
  [298] = {.lex_state = 79},
  [299] = {.lex_state = 79},
  [300] = {.lex_state = 79},
  [301] = {.lex_state = 79},
  [302] = {.lex_state = 79},
  [303] = {.lex_state = 79},
  [304] = {.lex_state = 79},
  [305] = {.lex_state = 79},
  [306] = {.lex_state = 79},
  [307] = {.lex_state = 79},
  [308] = {.lex_state = 79},
  [309] = {.lex_state = 79},
  [310] = {.lex_state = 8},
  [311] = {.lex_state = 79},
  [312] = {.lex_state = 8},
  [313] = {.lex_state = 8},
  [314] = {.lex_state = 8},
  [315] = {.lex_state = 79},
  [316] = {.lex_state = 79},
  [317] = {.lex_state = 79},
  [318] = {.lex_state = 8},
  [319] = {.lex_state = 79},
  [320] = {.lex_state = 79},
  [321] = {.lex_state = 8},
  [322] = {.lex_state = 79},
  [323] = {.lex_state = 79},
  [324] = {.lex_state = 79},
  [325] = {.lex_state = 8},
  [326] = {.lex_state = 79},
  [327] = {.lex_state = 79},
  [328] = {.lex_state = 79},
  [329] = {.lex_state = 79},
  [330] = {.lex_state = 79},
  [331] = {.lex_state = 79},
  [332] = {.lex_state = 8},
  [333] = {.lex_state = 79},
  [334] = {.lex_state = 8},
  [335] = {.lex_state = 8},
  [336] = {.lex_state = 8},
  [337] = {.lex_state = 8},
  [338] = {.lex_state = 8},
  [339] = {.lex_state = 8},
  [340] = {.lex_state = 8},
  [341] = {.lex_state = 8},
  [342] = {.lex_state = 8},
  [343] = {.lex_state = 8},
  [344] = {.lex_state = 8},
  [345] = {.lex_state = 8},
  [346] = {.lex_state = 8},
  [347] = {.lex_state = 8},
  [348] = {.lex_state = 8},
  [349] = {.lex_state = 8},
  [350] = {.lex_state = 8},
  [351] = {.lex_state = 8},
  [352] = {.lex_state = 8},
  [353] = {.lex_state = 8},
  [354] = {.lex_state = 8},
  [355] = {.lex_state = 8},
  [356] = {.lex_state = 8},
  [357] = {.lex_state = 8},
  [358] = {.lex_state = 8},
  [359] = {.lex_state = 8},
  [360] = {.lex_state = 8},
  [361] = {.lex_state = 8},
  [362] = {.lex_state = 8},
  [363] = {.lex_state = 8},
  [364] = {.lex_state = 8},
  [365] = {.lex_state = 8},
  [366] = {.lex_state = 8},
  [367] = {.lex_state = 8},
  [368] = {.lex_state = 8},
  [369] = {.lex_state = 8},
  [370] = {.lex_state = 8},
  [371] = {.lex_state = 8},
  [372] = {.lex_state = 8},
  [373] = {.lex_state = 8},
  [374] = {.lex_state = 8},
  [375] = {.lex_state = 8},
  [376] = {.lex_state = 8},
  [377] = {.lex_state = 8},
  [378] = {.lex_state = 8},
  [379] = {.lex_state = 8},
  [380] = {.lex_state = 8},
  [381] = {.lex_state = 9},
  [382] = {.lex_state = 9},
  [383] = {.lex_state = 9},
  [384] = {.lex_state = 9},
  [385] = {.lex_state = 9},
  [386] = {.lex_state = 9},
  [387] = {.lex_state = 9},
  [388] = {.lex_state = 9},
  [389] = {.lex_state = 79},
  [390] = {.lex_state = 9},
  [391] = {.lex_state = 79},
  [392] = {.lex_state = 79},
  [393] = {.lex_state = 9},
  [394] = {.lex_state = 9},
  [395] = {.lex_state = 9},
  [396] = {.lex_state = 9},
  [397] = {.lex_state = 9},
  [398] = {.lex_state = 9},
  [399] = {.lex_state = 9},
  [400] = {.lex_state = 9},
  [401] = {.lex_state = 9},
  [402] = {.lex_state = 9},
  [403] = {.lex_state = 9},
  [404] = {.lex_state = 9},
  [405] = {.lex_state = 9},
  [406] = {.lex_state = 9},
  [407] = {.lex_state = 9},
  [408] = {.lex_state = 9},
  [409] = {.lex_state = 9},
  [410] = {.lex_state = 9},
  [411] = {.lex_state = 9},
  [412] = {.lex_state = 9},
  [413] = {.lex_state = 9},
  [414] = {.lex_state = 9},
  [415] = {.lex_state = 9},
  [416] = {.lex_state = 9},
  [417] = {.lex_state = 9},
  [418] = {.lex_state = 9},
  [419] = {.lex_state = 9},
  [420] = {.lex_state = 9},
  [421] = {.lex_state = 9},
  [422] = {.lex_state = 9},
  [423] = {.lex_state = 9},
  [424] = {.lex_state = 9},
  [425] = {.lex_state = 9},
  [426] = {.lex_state = 9},
  [427] = {.lex_state = 10},
  [428] = {.lex_state = 10},
  [429] = {.lex_state = 79},
  [430] = {.lex_state = 10},
  [431] = {.lex_state = 10},
  [432] = {.lex_state = 10},
  [433] = {.lex_state = 10},
  [434] = {.lex_state = 10},
  [435] = {.lex_state = 79},
  [436] = {.lex_state = 7},
  [437] = {.lex_state = 7},
  [438] = {.lex_state = 10},
  [439] = {.lex_state = 10},
  [440] = {.lex_state = 10},
  [441] = {.lex_state = 10},
  [442] = {.lex_state = 10},
  [443] = {.lex_state = 10},
  [444] = {.lex_state = 7},
  [445] = {.lex_state = 10},
  [446] = {.lex_state = 10},
  [447] = {.lex_state = 10},
  [448] = {.lex_state = 10},
  [449] = {.lex_state = 79},
  [450] = {.lex_state = 10},
  [451] = {.lex_state = 10},
  [452] = {.lex_state = 10},
  [453] = {.lex_state = 79},
  [454] = {.lex_state = 10},
  [455] = {.lex_state = 10},
  [456] = {.lex_state = 7},
  [457] = {.lex_state = 79},
  [458] = {.lex_state = 10},
  [459] = {.lex_state = 10},
  [460] = {.lex_state = 10},
  [461] = {.lex_state = 10},
  [462] = {.lex_state = 10},
  [463] = {.lex_state = 10},
  [464] = {.lex_state = 2},
  [465] = {.lex_state = 10},
  [466] = {.lex_state = 10},
  [467] = {.lex_state = 10},
  [468] = {.lex_state = 10},
  [469] = {.lex_state = 10},
  [470] = {.lex_state = 79},
  [471] = {.lex_state = 10},
  [472] = {.lex_state = 10},
  [473] = {.lex_state = 10},
  [474] = {.lex_state = 79},
  [475] = {.lex_state = 10},
  [476] = {.lex_state = 10},
  [477] = {.lex_state = 10},
  [478] = {.lex_state = 10},
  [479] = {.lex_state = 10},
  [480] = {.lex_state = 10},
  [481] = {.lex_state = 2},
  [482] = {.lex_state = 2},
  [483] = {.lex_state = 79},
  [484] = {.lex_state = 79},
  [485] = {.lex_state = 2},
  [486] = {.lex_state = 7},
  [487] = {.lex_state = 2},
  [488] = {.lex_state = 79},
  [489] = {.lex_state = 2},
  [490] = {.lex_state = 2},
  [491] = {.lex_state = 2},
  [492] = {.lex_state = 2},
  [493] = {.lex_state = 2},
  [494] = {.lex_state = 7},
  [495] = {.lex_state = 7},
  [496] = {.lex_state = 7},
  [497] = {.lex_state = 7},
  [498] = {.lex_state = 7},
  [499] = {.lex_state = 7},
  [500] = {.lex_state = 2},
  [501] = {.lex_state = 2},
  [502] = {.lex_state = 7},
  [503] = {.lex_state = 7},
  [504] = {.lex_state = 7},
  [505] = {.lex_state = 79},
  [506] = {.lex_state = 7},
  [507] = {.lex_state = 7},
  [508] = {.lex_state = 7},
  [509] = {.lex_state = 7},
  [510] = {.lex_state = 7},
  [511] = {.lex_state = 7},
  [512] = {.lex_state = 2},
  [513] = {.lex_state = 7},
  [514] = {.lex_state = 7},
  [515] = {.lex_state = 2},
  [516] = {.lex_state = 2},
  [517] = {.lex_state = 2},
  [518] = {.lex_state = 2},
  [519] = {.lex_state = 2},
  [520] = {.lex_state = 2},
  [521] = {.lex_state = 2},
  [522] = {.lex_state = 2},
  [523] = {.lex_state = 2},
  [524] = {.lex_state = 7},
  [525] = {.lex_state = 2},
  [526] = {.lex_state = 7},
  [527] = {.lex_state = 7},
  [528] = {.lex_state = 7},
  [529] = {.lex_state = 2},
  [530] = {.lex_state = 2},
  [531] = {.lex_state = 2},
  [532] = {.lex_state = 2},
  [533] = {.lex_state = 7},
  [534] = {.lex_state = 7},
  [535] = {.lex_state = 7},
  [536] = {.lex_state = 7},
  [537] = {.lex_state = 7},
  [538] = {.lex_state = 7},
  [539] = {.lex_state = 7},
  [540] = {.lex_state = 2},
  [541] = {.lex_state = 7},
  [542] = {.lex_state = 7},
  [543] = {.lex_state = 2},
  [544] = {.lex_state = 2},
  [545] = {.lex_state = 2},
  [546] = {.lex_state = 7},
  [547] = {.lex_state = 7},
  [548] = {.lex_state = 7},
  [549] = {.lex_state = 7},
  [550] = {.lex_state = 2},
  [551] = {.lex_state = 2},
  [552] = {.lex_state = 2},
  [553] = {.lex_state = 10},
  [554] = {.lex_state = 7},
  [555] = {.lex_state = 2},
  [556] = {.lex_state = 2},
  [557] = {.lex_state = 2},
  [558] = {.lex_state = 2},
  [559] = {.lex_state = 2},
  [560] = {.lex_state = 2},
  [561] = {.lex_state = 2},
  [562] = {.lex_state = 2},
  [563] = {.lex_state = 2},
  [564] = {.lex_state = 2},
  [565] = {.lex_state = 2},
  [566] = {.lex_state = 2},
  [567] = {.lex_state = 2},
  [568] = {.lex_state = 7},
  [569] = {.lex_state = 7},
  [570] = {.lex_state = 10},
  [571] = {.lex_state = 10},
  [572] = {.lex_state = 10},
  [573] = {.lex_state = 10},
  [574] = {.lex_state = 10},
  [575] = {.lex_state = 10},
  [576] = {.lex_state = 10},
  [577] = {.lex_state = 10},
  [578] = {.lex_state = 7},
  [579] = {.lex_state = 10},
  [580] = {.lex_state = 7},
  [581] = {.lex_state = 7},
  [582] = {.lex_state = 7},
  [583] = {.lex_state = 10},
  [584] = {.lex_state = 10},
  [585] = {.lex_state = 10},
  [586] = {.lex_state = 7},
  [587] = {.lex_state = 15, .external_lex_state = 2},
  [588] = {.lex_state = 7},
  [589] = {.lex_state = 7},
  [590] = {.lex_state = 7},
  [591] = {.lex_state = 7},
  [592] = {.lex_state = 7},
  [593] = {.lex_state = 7},
  [594] = {.lex_state = 7},
  [595] = {.lex_state = 7},
  [596] = {.lex_state = 10},
  [597] = {.lex_state = 7},
  [598] = {.lex_state = 7},
  [599] = {.lex_state = 16, .external_lex_state = 2},
  [600] = {.lex_state = 7},
  [601] = {.lex_state = 7},
  [602] = {.lex_state = 7},
  [603] = {.lex_state = 7},
  [604] = {.lex_state = 16, .external_lex_state = 2},
  [605] = {.lex_state = 7},
  [606] = {.lex_state = 7},
  [607] = {.lex_state = 7},
  [608] = {.lex_state = 7},
  [609] = {.lex_state = 7},
  [610] = {.lex_state = 7},
  [611] = {.lex_state = 7},
  [612] = {.lex_state = 7},
  [613] = {.lex_state = 7},
  [614] = {.lex_state = 7},
  [615] = {.lex_state = 16, .external_lex_state = 2},
  [616] = {.lex_state = 7},
  [617] = {.lex_state = 7},
  [618] = {.lex_state = 7},
  [619] = {.lex_state = 10},
  [620] = {.lex_state = 10},
  [621] = {.lex_state = 10},
  [622] = {.lex_state = 10},
  [623] = {.lex_state = 7},
  [624] = {.lex_state = 10},
  [625] = {.lex_state = 7},
  [626] = {.lex_state = 7},
  [627] = {.lex_state = 16, .external_lex_state = 2},
  [628] = {.lex_state = 7},
  [629] = {.lex_state = 10},
  [630] = {.lex_state = 7},
  [631] = {.lex_state = 10},
  [632] = {.lex_state = 10},
  [633] = {.lex_state = 7},
  [634] = {.lex_state = 7},
  [635] = {.lex_state = 10},
  [636] = {.lex_state = 7},
  [637] = {.lex_state = 7},
  [638] = {.lex_state = 7},
  [639] = {.lex_state = 16, .external_lex_state = 2},
  [640] = {.lex_state = 7},
  [641] = {.lex_state = 16, .external_lex_state = 2},
  [642] = {.lex_state = 10},
  [643] = {.lex_state = 7},
  [644] = {.lex_state = 10},
  [645] = {.lex_state = 7},
  [646] = {.lex_state = 10},
  [647] = {.lex_state = 7},
  [648] = {.lex_state = 10},
  [649] = {.lex_state = 7},
  [650] = {.lex_state = 7},
  [651] = {.lex_state = 15, .external_lex_state = 2},
  [652] = {.lex_state = 10},
  [653] = {.lex_state = 7},
  [654] = {.lex_state = 7},
  [655] = {.lex_state = 7},
  [656] = {.lex_state = 7},
  [657] = {.lex_state = 10},
  [658] = {.lex_state = 10},
  [659] = {.lex_state = 10},
  [660] = {.lex_state = 7},
  [661] = {.lex_state = 15, .external_lex_state = 2},
  [662] = {.lex_state = 10},
  [663] = {.lex_state = 15, .external_lex_state = 2},
  [664] = {.lex_state = 10},
  [665] = {.lex_state = 7},
  [666] = {.lex_state = 15, .external_lex_state = 2},
  [667] = {.lex_state = 10},
  [668] = {.lex_state = 7},
  [669] = {.lex_state = 10},
  [670] = {.lex_state = 7},
  [671] = {.lex_state = 10},
  [672] = {.lex_state = 10},
  [673] = {.lex_state = 7},
  [674] = {.lex_state = 10},
  [675] = {.lex_state = 10},
  [676] = {.lex_state = 10},
  [677] = {.lex_state = 15, .external_lex_state = 2},
  [678] = {.lex_state = 10},
  [679] = {.lex_state = 16, .external_lex_state = 2},
  [680] = {.lex_state = 10},
  [681] = {.lex_state = 10},
  [682] = {.lex_state = 15, .external_lex_state = 2},
  [683] = {.lex_state = 7},
  [684] = {.lex_state = 15, .external_lex_state = 2},
  [685] = {.lex_state = 7},
  [686] = {.lex_state = 7},
  [687] = {.lex_state = 7},
  [688] = {.lex_state = 10},
  [689] = {.lex_state = 10},
  [690] = {.lex_state = 10},
  [691] = {.lex_state = 10},
  [692] = {.lex_state = 10},
  [693] = {.lex_state = 10},
  [694] = {.lex_state = 10},
  [695] = {.lex_state = 15, .external_lex_state = 2},
  [696] = {.lex_state = 15, .external_lex_state = 2},
  [697] = {.lex_state = 10},
  [698] = {.lex_state = 10},
  [699] = {.lex_state = 10},
  [700] = {.lex_state = 7},
  [701] = {.lex_state = 10},
  [702] = {.lex_state = 10},
  [703] = {.lex_state = 10},
  [704] = {.lex_state = 7},
  [705] = {.lex_state = 10},
  [706] = {.lex_state = 15, .external_lex_state = 2},
  [707] = {.lex_state = 15, .external_lex_state = 2},
  [708] = {.lex_state = 10},
  [709] = {.lex_state = 10},
  [710] = {.lex_state = 7},
  [711] = {.lex_state = 15, .external_lex_state = 2},
  [712] = {.lex_state = 10},
  [713] = {.lex_state = 7},
  [714] = {.lex_state = 10},
  [715] = {.lex_state = 10},
  [716] = {.lex_state = 10},
  [717] = {.lex_state = 10},
  [718] = {.lex_state = 7},
  [719] = {.lex_state = 7},
  [720] = {.lex_state = 7},
  [721] = {.lex_state = 7},
  [722] = {.lex_state = 7},
  [723] = {.lex_state = 7},
  [724] = {.lex_state = 7},
  [725] = {.lex_state = 7},
  [726] = {.lex_state = 7},
  [727] = {.lex_state = 7},
  [728] = {.lex_state = 7},
  [729] = {.lex_state = 10},
  [730] = {.lex_state = 7},
  [731] = {.lex_state = 7},
  [732] = {.lex_state = 7},
  [733] = {.lex_state = 7},
  [734] = {.lex_state = 10},
  [735] = {.lex_state = 10},
  [736] = {.lex_state = 7},
  [737] = {.lex_state = 7},
  [738] = {.lex_state = 10},
  [739] = {.lex_state = 7},
  [740] = {.lex_state = 7},
  [741] = {.lex_state = 7},
  [742] = {.lex_state = 10},
  [743] = {.lex_state = 10},
  [744] = {.lex_state = 7},
  [745] = {.lex_state = 7},
  [746] = {.lex_state = 7},
  [747] = {.lex_state = 7},
  [748] = {.lex_state = 10},
  [749] = {.lex_state = 7},
  [750] = {.lex_state = 7},
  [751] = {.lex_state = 7},
  [752] = {.lex_state = 7},
  [753] = {.lex_state = 7},
  [754] = {.lex_state = 7},
  [755] = {.lex_state = 7},
  [756] = {.lex_state = 7},
  [757] = {.lex_state = 7},
  [758] = {.lex_state = 7},
  [759] = {.lex_state = 10},
  [760] = {.lex_state = 7},
  [761] = {.lex_state = 7},
  [762] = {.lex_state = 7},
  [763] = {.lex_state = 7},
  [764] = {.lex_state = 10},
  [765] = {.lex_state = 7},
  [766] = {.lex_state = 7},
  [767] = {.lex_state = 7},
  [768] = {.lex_state = 10},
  [769] = {.lex_state = 7},
  [770] = {.lex_state = 7},
  [771] = {.lex_state = 10},
  [772] = {.lex_state = 10},
  [773] = {.lex_state = 7},
  [774] = {.lex_state = 10},
  [775] = {.lex_state = 7},
  [776] = {.lex_state = 7},
  [777] = {.lex_state = 7},
  [778] = {.lex_state = 10},
  [779] = {.lex_state = 7},
  [780] = {.lex_state = 7},
  [781] = {.lex_state = 10},
  [782] = {.lex_state = 10},
  [783] = {.lex_state = 7},
  [784] = {.lex_state = 7},
  [785] = {.lex_state = 10},
  [786] = {.lex_state = 7},
  [787] = {.lex_state = 7},
  [788] = {.lex_state = 10},
  [789] = {.lex_state = 7},
  [790] = {.lex_state = 10},
  [791] = {.lex_state = 7},
  [792] = {.lex_state = 10},
  [793] = {.lex_state = 10},
  [794] = {.lex_state = 10},
  [795] = {.lex_state = 7},
  [796] = {.lex_state = 7},
  [797] = {.lex_state = 10},
  [798] = {.lex_state = 7},
  [799] = {.lex_state = 10},
  [800] = {.lex_state = 10},
  [801] = {.lex_state = 7},
  [802] = {.lex_state = 7},
  [803] = {.lex_state = 7},
  [804] = {.lex_state = 10},
  [805] = {.lex_state = 7},
  [806] = {.lex_state = 10},
  [807] = {.lex_state = 7},
  [808] = {.lex_state = 7},
  [809] = {.lex_state = 7},
  [810] = {.lex_state = 7},
  [811] = {.lex_state = 10},
  [812] = {.lex_state = 10},
  [813] = {.lex_state = 7},
  [814] = {.lex_state = 10},
  [815] = {.lex_state = 10},
  [816] = {.lex_state = 10},
  [817] = {.lex_state = 7},
  [818] = {.lex_state = 7},
  [819] = {.lex_state = 7},
  [820] = {.lex_state = 10},
  [821] = {.lex_state = 7},
  [822] = {.lex_state = 7},
  [823] = {.lex_state = 10},
  [824] = {.lex_state = 10},
  [825] = {.lex_state = 10},
  [826] = {.lex_state = 7},
  [827] = {.lex_state = 7},
  [828] = {.lex_state = 10},
  [829] = {.lex_state = 7},
  [830] = {.lex_state = 7},
  [831] = {.lex_state = 7},
  [832] = {.lex_state = 10},
  [833] = {.lex_state = 7},
  [834] = {.lex_state = 7},
  [835] = {.lex_state = 10},
  [836] = {.lex_state = 10},
  [837] = {.lex_state = 7},
  [838] = {.lex_state = 10},
  [839] = {.lex_state = 7},
  [840] = {.lex_state = 7},
  [841] = {.lex_state = 7},
  [842] = {.lex_state = 7},
  [843] = {.lex_state = 7},
  [844] = {.lex_state = 7},
  [845] = {.lex_state = 10},
  [846] = {.lex_state = 7},
  [847] = {.lex_state = 7},
  [848] = {.lex_state = 10},
  [849] = {.lex_state = 10},
  [850] = {.lex_state = 79},
  [851] = {.lex_state = 79},
  [852] = {.lex_state = 79},
  [853] = {.lex_state = 79},
  [854] = {.lex_state = 79},
  [855] = {.lex_state = 79},
  [856] = {.lex_state = 7},
  [857] = {.lex_state = 7},
  [858] = {.lex_state = 7},
  [859] = {.lex_state = 7},
  [860] = {.lex_state = 79},
  [861] = {.lex_state = 79},
  [862] = {.lex_state = 79},
  [863] = {.lex_state = 79},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 16, .external_lex_state = 2},
  [867] = {.lex_state = 15, .external_lex_state = 2},
  [868] = {.lex_state = 79},
  [869] = {.lex_state = 15, .external_lex_state = 2},
  [870] = {.lex_state = 16, .external_lex_state = 2},
  [871] = {.lex_state = 7},
  [872] = {.lex_state = 79},
  [873] = {.lex_state = 15, .external_lex_state = 2},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 79},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 79},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 7},
  [880] = {.lex_state = 7},
  [881] = {.lex_state = 16, .external_lex_state = 2},
  [882] = {.lex_state = 7},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 0},
  [885] = {.lex_state = 15, .external_lex_state = 2},
  [886] = {.lex_state = 16, .external_lex_state = 2},
  [887] = {.lex_state = 79},
  [888] = {.lex_state = 79},
  [889] = {.lex_state = 26, .external_lex_state = 2},
  [890] = {.lex_state = 79},
  [891] = {.lex_state = 7},
  [892] = {.lex_state = 7},
  [893] = {.lex_state = 79},
  [894] = {.lex_state = 79},
  [895] = {.lex_state = 79},
  [896] = {.lex_state = 79},
  [897] = {.lex_state = 79},
  [898] = {.lex_state = 79},
  [899] = {.lex_state = 15, .external_lex_state = 2},
  [900] = {.lex_state = 79},
  [901] = {.lex_state = 26, .external_lex_state = 2},
  [902] = {.lex_state = 79},
  [903] = {.lex_state = 79},
  [904] = {.lex_state = 79},
  [905] = {.lex_state = 79},
  [906] = {.lex_state = 79},
  [907] = {.lex_state = 79},
  [908] = {.lex_state = 79},
  [909] = {.lex_state = 27, .external_lex_state = 2},
  [910] = {.lex_state = 79},
  [911] = {.lex_state = 79},
  [912] = {.lex_state = 79},
  [913] = {.lex_state = 27, .external_lex_state = 2},
  [914] = {.lex_state = 79},
  [915] = {.lex_state = 26, .external_lex_state = 2},
  [916] = {.lex_state = 79},
  [917] = {.lex_state = 16, .external_lex_state = 2},
  [918] = {.lex_state = 15, .external_lex_state = 2},
  [919] = {.lex_state = 79},
  [920] = {.lex_state = 16, .external_lex_state = 2},
  [921] = {.lex_state = 79},
  [922] = {.lex_state = 79},
  [923] = {.lex_state = 79},
  [924] = {.lex_state = 79},
  [925] = {.lex_state = 27, .external_lex_state = 2},
  [926] = {.lex_state = 79},
  [927] = {.lex_state = 26, .external_lex_state = 2},
  [928] = {.lex_state = 27, .external_lex_state = 2},
  [929] = {.lex_state = 79},
  [930] = {.lex_state = 16, .external_lex_state = 2},
  [931] = {.lex_state = 16, .external_lex_state = 2},
  [932] = {.lex_state = 7},
  [933] = {.lex_state = 16, .external_lex_state = 2},
  [934] = {.lex_state = 16, .external_lex_state = 2},
  [935] = {.lex_state = 16, .external_lex_state = 2},
  [936] = {.lex_state = 16, .external_lex_state = 2},
  [937] = {.lex_state = 16, .external_lex_state = 2},
  [938] = {.lex_state = 16, .external_lex_state = 2},
  [939] = {.lex_state = 16, .external_lex_state = 2},
  [940] = {.lex_state = 16, .external_lex_state = 2},
  [941] = {.lex_state = 16, .external_lex_state = 2},
  [942] = {.lex_state = 16, .external_lex_state = 2},
  [943] = {.lex_state = 16, .external_lex_state = 2},
  [944] = {.lex_state = 16, .external_lex_state = 2},
  [945] = {.lex_state = 15, .external_lex_state = 2},
  [946] = {.lex_state = 16, .external_lex_state = 2},
  [947] = {.lex_state = 16, .external_lex_state = 2},
  [948] = {.lex_state = 16, .external_lex_state = 2},
  [949] = {.lex_state = 7},
  [950] = {.lex_state = 16, .external_lex_state = 2},
  [951] = {.lex_state = 16, .external_lex_state = 2},
  [952] = {.lex_state = 16, .external_lex_state = 2},
  [953] = {.lex_state = 16, .external_lex_state = 2},
  [954] = {.lex_state = 16, .external_lex_state = 2},
  [955] = {.lex_state = 15, .external_lex_state = 2},
  [956] = {.lex_state = 16, .external_lex_state = 2},
  [957] = {.lex_state = 16, .external_lex_state = 2},
  [958] = {.lex_state = 16, .external_lex_state = 2},
  [959] = {.lex_state = 16, .external_lex_state = 2},
  [960] = {.lex_state = 15, .external_lex_state = 2},
  [961] = {.lex_state = 16, .external_lex_state = 2},
  [962] = {.lex_state = 16, .external_lex_state = 2},
  [963] = {.lex_state = 16, .external_lex_state = 2},
  [964] = {.lex_state = 16, .external_lex_state = 2},
  [965] = {.lex_state = 15, .external_lex_state = 2},
  [966] = {.lex_state = 16, .external_lex_state = 2},
  [967] = {.lex_state = 16, .external_lex_state = 2},
  [968] = {.lex_state = 16, .external_lex_state = 2},
  [969] = {.lex_state = 15, .external_lex_state = 2},
  [970] = {.lex_state = 15, .external_lex_state = 2},
  [971] = {.lex_state = 15, .external_lex_state = 2},
  [972] = {.lex_state = 15, .external_lex_state = 2},
  [973] = {.lex_state = 15, .external_lex_state = 2},
  [974] = {.lex_state = 15, .external_lex_state = 2},
  [975] = {.lex_state = 15, .external_lex_state = 2},
  [976] = {.lex_state = 16, .external_lex_state = 2},
  [977] = {.lex_state = 16, .external_lex_state = 2},
  [978] = {.lex_state = 16, .external_lex_state = 2},
  [979] = {.lex_state = 15, .external_lex_state = 2},
  [980] = {.lex_state = 15, .external_lex_state = 2},
  [981] = {.lex_state = 16, .external_lex_state = 2},
  [982] = {.lex_state = 15, .external_lex_state = 2},
  [983] = {.lex_state = 15, .external_lex_state = 2},
  [984] = {.lex_state = 7},
  [985] = {.lex_state = 15, .external_lex_state = 2},
  [986] = {.lex_state = 15, .external_lex_state = 2},
  [987] = {.lex_state = 16, .external_lex_state = 2},
  [988] = {.lex_state = 16, .external_lex_state = 2},
  [989] = {.lex_state = 16, .external_lex_state = 2},
  [990] = {.lex_state = 15, .external_lex_state = 2},
  [991] = {.lex_state = 15, .external_lex_state = 2},
  [992] = {.lex_state = 15, .external_lex_state = 2},
  [993] = {.lex_state = 15, .external_lex_state = 2},
  [994] = {.lex_state = 79},
  [995] = {.lex_state = 15, .external_lex_state = 2},
  [996] = {.lex_state = 15, .external_lex_state = 2},
  [997] = {.lex_state = 15, .external_lex_state = 2},
  [998] = {.lex_state = 15, .external_lex_state = 2},
  [999] = {.lex_state = 15, .external_lex_state = 2},
  [1000] = {.lex_state = 15, .external_lex_state = 2},
  [1001] = {.lex_state = 15, .external_lex_state = 2},
  [1002] = {.lex_state = 16, .external_lex_state = 2},
  [1003] = {.lex_state = 15, .external_lex_state = 2},
  [1004] = {.lex_state = 15, .external_lex_state = 2},
  [1005] = {.lex_state = 16, .external_lex_state = 2},
  [1006] = {.lex_state = 15, .external_lex_state = 2},
  [1007] = {.lex_state = 15, .external_lex_state = 2},
  [1008] = {.lex_state = 15, .external_lex_state = 2},
  [1009] = {.lex_state = 15, .external_lex_state = 2},
  [1010] = {.lex_state = 15, .external_lex_state = 2},
  [1011] = {.lex_state = 15, .external_lex_state = 2},
  [1012] = {.lex_state = 16, .external_lex_state = 2},
  [1013] = {.lex_state = 7},
  [1014] = {.lex_state = 15, .external_lex_state = 2},
  [1015] = {.lex_state = 15, .external_lex_state = 2},
  [1016] = {.lex_state = 7},
  [1017] = {.lex_state = 15, .external_lex_state = 2},
  [1018] = {.lex_state = 15, .external_lex_state = 2},
  [1019] = {.lex_state = 15, .external_lex_state = 2},
  [1020] = {.lex_state = 78},
  [1021] = {.lex_state = 34},
  [1022] = {.lex_state = 34},
  [1023] = {.lex_state = 34},
  [1024] = {.lex_state = 34},
  [1025] = {.lex_state = 81},
  [1026] = {.lex_state = 78},
  [1027] = {.lex_state = 81},
  [1028] = {.lex_state = 34},
  [1029] = {.lex_state = 7},
  [1030] = {.lex_state = 7},
  [1031] = {.lex_state = 34},
  [1032] = {.lex_state = 79},
  [1033] = {.lex_state = 34},
  [1034] = {.lex_state = 81},
  [1035] = {.lex_state = 81},
  [1036] = {.lex_state = 81},
  [1037] = {.lex_state = 81},
  [1038] = {.lex_state = 81},
  [1039] = {.lex_state = 81},
  [1040] = {.lex_state = 7},
  [1041] = {.lex_state = 81},
  [1042] = {.lex_state = 81},
  [1043] = {.lex_state = 81},
  [1044] = {.lex_state = 81},
  [1045] = {.lex_state = 81},
  [1046] = {.lex_state = 81},
  [1047] = {.lex_state = 81},
  [1048] = {.lex_state = 81},
  [1049] = {.lex_state = 81},
  [1050] = {.lex_state = 7},
  [1051] = {.lex_state = 7},
  [1052] = {.lex_state = 81},
  [1053] = {.lex_state = 81},
  [1054] = {.lex_state = 81},
  [1055] = {.lex_state = 81},
  [1056] = {.lex_state = 81},
  [1057] = {.lex_state = 81},
  [1058] = {.lex_state = 81},
  [1059] = {.lex_state = 81},
  [1060] = {.lex_state = 7},
  [1061] = {.lex_state = 81},
  [1062] = {.lex_state = 81},
  [1063] = {.lex_state = 79},
  [1064] = {.lex_state = 7},
  [1065] = {.lex_state = 81},
  [1066] = {.lex_state = 81},
  [1067] = {.lex_state = 81},
  [1068] = {.lex_state = 81},
  [1069] = {.lex_state = 7},
  [1070] = {.lex_state = 79},
  [1071] = {.lex_state = 81},
  [1072] = {.lex_state = 79},
  [1073] = {.lex_state = 79},
  [1074] = {.lex_state = 79},
  [1075] = {.lex_state = 78},
  [1076] = {.lex_state = 78},
  [1077] = {.lex_state = 79},
  [1078] = {.lex_state = 7},
  [1079] = {.lex_state = 78},
  [1080] = {.lex_state = 78},
  [1081] = {.lex_state = 78},
  [1082] = {.lex_state = 78},
  [1083] = {.lex_state = 78},
  [1084] = {.lex_state = 81},
  [1085] = {.lex_state = 78},
  [1086] = {.lex_state = 81},
  [1087] = {.lex_state = 79},
  [1088] = {.lex_state = 79},
  [1089] = {.lex_state = 78},
  [1090] = {.lex_state = 78},
  [1091] = {.lex_state = 1},
  [1092] = {.lex_state = 78},
  [1093] = {.lex_state = 78},
  [1094] = {.lex_state = 78},
  [1095] = {.lex_state = 78},
  [1096] = {.lex_state = 78},
  [1097] = {.lex_state = 78},
  [1098] = {.lex_state = 79},
  [1099] = {.lex_state = 1},
  [1100] = {.lex_state = 78},
  [1101] = {.lex_state = 7},
  [1102] = {.lex_state = 78},
  [1103] = {.lex_state = 7},
  [1104] = {.lex_state = 78},
  [1105] = {.lex_state = 78},
  [1106] = {.lex_state = 79},
  [1107] = {.lex_state = 79},
  [1108] = {.lex_state = 78},
  [1109] = {.lex_state = 11},
  [1110] = {.lex_state = 78},
  [1111] = {.lex_state = 79},
  [1112] = {.lex_state = 78},
  [1113] = {.lex_state = 78},
  [1114] = {.lex_state = 78},
  [1115] = {.lex_state = 78},
  [1116] = {.lex_state = 78},
  [1117] = {.lex_state = 81},
  [1118] = {.lex_state = 7},
  [1119] = {.lex_state = 78},
  [1120] = {.lex_state = 79},
  [1121] = {.lex_state = 78},
  [1122] = {.lex_state = 78},
  [1123] = {.lex_state = 78},
  [1124] = {.lex_state = 78},
  [1125] = {.lex_state = 79},
  [1126] = {.lex_state = 78},
  [1127] = {.lex_state = 78},
  [1128] = {.lex_state = 78},
  [1129] = {.lex_state = 78},
  [1130] = {.lex_state = 7},
  [1131] = {.lex_state = 78},
  [1132] = {.lex_state = 11},
  [1133] = {.lex_state = 78},
  [1134] = {.lex_state = 78},
  [1135] = {.lex_state = 11},
  [1136] = {.lex_state = 7},
  [1137] = {.lex_state = 81},
  [1138] = {.lex_state = 79},
  [1139] = {.lex_state = 79},
  [1140] = {.lex_state = 79},
  [1141] = {.lex_state = 81},
  [1142] = {.lex_state = 79},
  [1143] = {.lex_state = 79},
  [1144] = {.lex_state = 79},
  [1145] = {.lex_state = 79},
  [1146] = {.lex_state = 79},
  [1147] = {.lex_state = 79},
  [1148] = {.lex_state = 79},
  [1149] = {.lex_state = 79},
  [1150] = {.lex_state = 79},
  [1151] = {.lex_state = 79},
  [1152] = {.lex_state = 7},
  [1153] = {.lex_state = 7},
  [1154] = {.lex_state = 79},
  [1155] = {.lex_state = 7},
  [1156] = {.lex_state = 79},
  [1157] = {.lex_state = 7},
  [1158] = {.lex_state = 79},
  [1159] = {.lex_state = 7},
  [1160] = {.lex_state = 79},
  [1161] = {.lex_state = 79},
  [1162] = {.lex_state = 79},
  [1163] = {.lex_state = 7},
  [1164] = {.lex_state = 7},
  [1165] = {.lex_state = 7},
  [1166] = {.lex_state = 7},
  [1167] = {.lex_state = 7},
  [1168] = {.lex_state = 78},
  [1169] = {.lex_state = 79},
  [1170] = {.lex_state = 79},
  [1171] = {.lex_state = 7},
  [1172] = {.lex_state = 81},
  [1173] = {.lex_state = 7},
  [1174] = {.lex_state = 79},
  [1175] = {.lex_state = 7},
  [1176] = {.lex_state = 79},
  [1177] = {.lex_state = 7},
  [1178] = {.lex_state = 79},
  [1179] = {.lex_state = 79},
  [1180] = {.lex_state = 79},
  [1181] = {.lex_state = 79},
  [1182] = {.lex_state = 7},
  [1183] = {.lex_state = 79},
  [1184] = {.lex_state = 79},
  [1185] = {.lex_state = 79},
  [1186] = {.lex_state = 7},
  [1187] = {.lex_state = 79},
  [1188] = {.lex_state = 81},
  [1189] = {.lex_state = 78},
  [1190] = {.lex_state = 79},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 7},
  [1193] = {.lex_state = 7},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 79},
  [1196] = {.lex_state = 36},
  [1197] = {.lex_state = 79},
  [1198] = {.lex_state = 7},
  [1199] = {.lex_state = 7},
  [1200] = {.lex_state = 7},
  [1201] = {.lex_state = 79},
  [1202] = {.lex_state = 7},
  [1203] = {.lex_state = 78},
  [1204] = {.lex_state = 7},
  [1205] = {.lex_state = 7},
  [1206] = {.lex_state = 28},
  [1207] = {.lex_state = 28},
  [1208] = {.lex_state = 79},
  [1209] = {.lex_state = 34},
  [1210] = {.lex_state = 78},
  [1211] = {.lex_state = 79},
  [1212] = {.lex_state = 7},
  [1213] = {.lex_state = 7},
  [1214] = {.lex_state = 79},
  [1215] = {.lex_state = 7},
  [1216] = {.lex_state = 79},
  [1217] = {.lex_state = 81},
  [1218] = {.lex_state = 7},
  [1219] = {.lex_state = 79},
  [1220] = {.lex_state = 78},
  [1221] = {.lex_state = 7},
  [1222] = {.lex_state = 7},
  [1223] = {.lex_state = 7},
  [1224] = {.lex_state = 78},
  [1225] = {.lex_state = 7},
  [1226] = {.lex_state = 7},
  [1227] = {.lex_state = 7},
  [1228] = {.lex_state = 7},
  [1229] = {.lex_state = 7},
  [1230] = {.lex_state = 79},
  [1231] = {.lex_state = 78},
  [1232] = {.lex_state = 7},
  [1233] = {.lex_state = 79},
  [1234] = {.lex_state = 7},
  [1235] = {.lex_state = 7},
  [1236] = {.lex_state = 79},
  [1237] = {.lex_state = 78},
  [1238] = {.lex_state = 7},
  [1239] = {.lex_state = 36},
  [1240] = {.lex_state = 79},
  [1241] = {.lex_state = 79},
  [1242] = {.lex_state = 79},
  [1243] = {.lex_state = 79},
  [1244] = {.lex_state = 28},
  [1245] = {.lex_state = 78},
  [1246] = {.lex_state = 78},
  [1247] = {.lex_state = 36},
  [1248] = {.lex_state = 28},
  [1249] = {.lex_state = 36},
  [1250] = {.lex_state = 28},
  [1251] = {.lex_state = 78},
  [1252] = {.lex_state = 34},
  [1253] = {.lex_state = 78},
  [1254] = {.lex_state = 78},
  [1255] = {.lex_state = 78},
  [1256] = {.lex_state = 34},
  [1257] = {.lex_state = 78},
  [1258] = {.lex_state = 78},
  [1259] = {.lex_state = 78},
  [1260] = {.lex_state = 78},
  [1261] = {.lex_state = 78},
  [1262] = {.lex_state = 78},
  [1263] = {.lex_state = 35},
  [1264] = {.lex_state = 35},
  [1265] = {.lex_state = 35},
  [1266] = {.lex_state = 78},
  [1267] = {.lex_state = 35},
  [1268] = {.lex_state = 34},
  [1269] = {.lex_state = 78},
  [1270] = {.lex_state = 78},
  [1271] = {.lex_state = 7},
  [1272] = {.lex_state = 34},
  [1273] = {.lex_state = 34},
  [1274] = {.lex_state = 34},
  [1275] = {.lex_state = 78},
  [1276] = {.lex_state = 34},
  [1277] = {.lex_state = 34},
  [1278] = {.lex_state = 34},
  [1279] = {.lex_state = 34},
  [1280] = {.lex_state = 34},
  [1281] = {.lex_state = 34},
  [1282] = {.lex_state = 34},
  [1283] = {.lex_state = 35},
  [1284] = {.lex_state = 35},
  [1285] = {.lex_state = 78},
  [1286] = {.lex_state = 7},
  [1287] = {.lex_state = 35},
  [1288] = {.lex_state = 35},
  [1289] = {.lex_state = 78},
  [1290] = {.lex_state = 78},
  [1291] = {.lex_state = 0},
  [1292] = {.lex_state = 7},
  [1293] = {.lex_state = 78},
  [1294] = {.lex_state = 78},
  [1295] = {.lex_state = 78},
  [1296] = {.lex_state = 78},
  [1297] = {.lex_state = 35},
  [1298] = {.lex_state = 35},
  [1299] = {.lex_state = 7},
  [1300] = {.lex_state = 78},
  [1301] = {.lex_state = 78},
  [1302] = {.lex_state = 7},
  [1303] = {.lex_state = 35},
  [1304] = {.lex_state = 7},
  [1305] = {.lex_state = 78},
  [1306] = {.lex_state = 78},
  [1307] = {.lex_state = 78},
  [1308] = {.lex_state = 35},
  [1309] = {.lex_state = 35},
  [1310] = {.lex_state = 0},
  [1311] = {.lex_state = 0},
  [1312] = {.lex_state = 78},
  [1313] = {.lex_state = 7},
  [1314] = {.lex_state = 78},
  [1315] = {.lex_state = 78},
  [1316] = {.lex_state = 78},
  [1317] = {.lex_state = 7},
  [1318] = {.lex_state = 7},
  [1319] = {.lex_state = 3},
  [1320] = {.lex_state = 3},
  [1321] = {.lex_state = 7},
  [1322] = {.lex_state = 78},
  [1323] = {.lex_state = 81},
  [1324] = {.lex_state = 78},
  [1325] = {.lex_state = 78},
  [1326] = {.lex_state = 78},
  [1327] = {.lex_state = 7},
  [1328] = {.lex_state = 7},
  [1329] = {.lex_state = 0},
  [1330] = {.lex_state = 0},
  [1331] = {.lex_state = 3},
  [1332] = {.lex_state = 78},
  [1333] = {.lex_state = 8},
  [1334] = {.lex_state = 78},
  [1335] = {.lex_state = 78},
  [1336] = {.lex_state = 78},
  [1337] = {.lex_state = 7},
  [1338] = {.lex_state = 3},
  [1339] = {.lex_state = 3},
  [1340] = {.lex_state = 9},
  [1341] = {.lex_state = 3},
  [1342] = {.lex_state = 7},
  [1343] = {.lex_state = 0},
  [1344] = {.lex_state = 81},
  [1345] = {.lex_state = 81},
  [1346] = {.lex_state = 0},
  [1347] = {.lex_state = 0},
  [1348] = {.lex_state = 81},
  [1349] = {.lex_state = 81},
  [1350] = {.lex_state = 3},
  [1351] = {.lex_state = 81},
  [1352] = {.lex_state = 3},
  [1353] = {.lex_state = 35},
  [1354] = {.lex_state = 28},
  [1355] = {.lex_state = 0},
  [1356] = {.lex_state = 0},
  [1357] = {.lex_state = 0},
  [1358] = {.lex_state = 0},
  [1359] = {.lex_state = 0},
  [1360] = {.lex_state = 3},
  [1361] = {.lex_state = 9},
  [1362] = {.lex_state = 7},
  [1363] = {.lex_state = 78},
  [1364] = {.lex_state = 0},
  [1365] = {.lex_state = 0},
  [1366] = {.lex_state = 81},
  [1367] = {.lex_state = 81},
  [1368] = {.lex_state = 3},
  [1369] = {.lex_state = 7},
  [1370] = {.lex_state = 7},
  [1371] = {.lex_state = 7},
  [1372] = {.lex_state = 78},
  [1373] = {.lex_state = 31},
  [1374] = {.lex_state = 78},
  [1375] = {.lex_state = 81},
  [1376] = {.lex_state = 3},
  [1377] = {.lex_state = 78},
  [1378] = {.lex_state = 0},
  [1379] = {.lex_state = 78},
  [1380] = {.lex_state = 78},
  [1381] = {.lex_state = 0},
  [1382] = {.lex_state = 78},
  [1383] = {.lex_state = 31},
  [1384] = {.lex_state = 78},
  [1385] = {.lex_state = 78},
  [1386] = {.lex_state = 9},
  [1387] = {.lex_state = 29},
  [1388] = {.lex_state = 0},
  [1389] = {.lex_state = 0},
  [1390] = {.lex_state = 78},
  [1391] = {.lex_state = 81},
  [1392] = {.lex_state = 81},
  [1393] = {.lex_state = 8},
  [1394] = {.lex_state = 3},
  [1395] = {.lex_state = 81},
  [1396] = {.lex_state = 3},
  [1397] = {.lex_state = 0},
  [1398] = {.lex_state = 8},
  [1399] = {.lex_state = 8},
  [1400] = {.lex_state = 78},
  [1401] = {.lex_state = 31},
  [1402] = {.lex_state = 78},
  [1403] = {.lex_state = 31},
  [1404] = {.lex_state = 78},
  [1405] = {.lex_state = 78},
  [1406] = {.lex_state = 8},
  [1407] = {.lex_state = 78},
  [1408] = {.lex_state = 78},
  [1409] = {.lex_state = 78},
  [1410] = {.lex_state = 78},
  [1411] = {.lex_state = 78},
  [1412] = {.lex_state = 78},
  [1413] = {.lex_state = 0},
  [1414] = {.lex_state = 0},
  [1415] = {.lex_state = 78},
  [1416] = {.lex_state = 78},
  [1417] = {.lex_state = 78},
  [1418] = {.lex_state = 78},
  [1419] = {.lex_state = 78},
  [1420] = {.lex_state = 78},
  [1421] = {.lex_state = 78},
  [1422] = {.lex_state = 78},
  [1423] = {.lex_state = 78},
  [1424] = {.lex_state = 78},
  [1425] = {.lex_state = 29},
  [1426] = {.lex_state = 78},
  [1427] = {.lex_state = 78},
  [1428] = {.lex_state = 0},
  [1429] = {.lex_state = 8},
  [1430] = {.lex_state = 0},
  [1431] = {.lex_state = 8},
  [1432] = {.lex_state = 0},
  [1433] = {.lex_state = 81},
  [1434] = {.lex_state = 81},
  [1435] = {.lex_state = 3},
  [1436] = {.lex_state = 78},
  [1437] = {.lex_state = 9},
  [1438] = {.lex_state = 0},
  [1439] = {.lex_state = 81},
  [1440] = {.lex_state = 3},
  [1441] = {.lex_state = 8},
  [1442] = {.lex_state = 0},
  [1443] = {.lex_state = 0},
  [1444] = {.lex_state = 78},
  [1445] = {.lex_state = 78},
  [1446] = {.lex_state = 31},
  [1447] = {.lex_state = 78},
  [1448] = {.lex_state = 78},
  [1449] = {.lex_state = 0},
  [1450] = {.lex_state = 7},
  [1451] = {.lex_state = 0},
  [1452] = {.lex_state = 7},
  [1453] = {.lex_state = 7},
  [1454] = {.lex_state = 7},
  [1455] = {.lex_state = 0},
  [1456] = {.lex_state = 78},
  [1457] = {.lex_state = 0},
  [1458] = {.lex_state = 7},
  [1459] = {.lex_state = 78},
  [1460] = {.lex_state = 28},
  [1461] = {.lex_state = 7},
  [1462] = {.lex_state = 30},
  [1463] = {.lex_state = 81},
  [1464] = {.lex_state = 35},
  [1465] = {.lex_state = 81},
  [1466] = {.lex_state = 0},
  [1467] = {.lex_state = 81},
  [1468] = {.lex_state = 81},
  [1469] = {.lex_state = 0},
  [1470] = {.lex_state = 0},
  [1471] = {.lex_state = 28},
  [1472] = {.lex_state = 28},
  [1473] = {.lex_state = 30},
  [1474] = {.lex_state = 28},
  [1475] = {.lex_state = 35},
  [1476] = {.lex_state = 7},
  [1477] = {.lex_state = 7},
  [1478] = {.lex_state = 7},
  [1479] = {.lex_state = 81},
  [1480] = {.lex_state = 7},
  [1481] = {.lex_state = 7},
  [1482] = {.lex_state = 28},
  [1483] = {.lex_state = 28},
  [1484] = {.lex_state = 7},
  [1485] = {.lex_state = 30},
  [1486] = {.lex_state = 7},
  [1487] = {.lex_state = 7},
  [1488] = {.lex_state = 7},
  [1489] = {.lex_state = 7},
  [1490] = {.lex_state = 7},
  [1491] = {.lex_state = 28},
  [1492] = {.lex_state = 7},
  [1493] = {.lex_state = 35},
  [1494] = {.lex_state = 0},
  [1495] = {.lex_state = 0},
  [1496] = {.lex_state = 0},
  [1497] = {.lex_state = 35},
  [1498] = {.lex_state = 7},
  [1499] = {.lex_state = 35},
  [1500] = {.lex_state = 7},
  [1501] = {.lex_state = 0},
  [1502] = {.lex_state = 7},
  [1503] = {.lex_state = 78},
  [1504] = {.lex_state = 0},
  [1505] = {.lex_state = 7},
  [1506] = {.lex_state = 78},
  [1507] = {.lex_state = 0},
  [1508] = {.lex_state = 7},
  [1509] = {.lex_state = 0},
  [1510] = {.lex_state = 28},
  [1511] = {.lex_state = 0},
  [1512] = {.lex_state = 35},
  [1513] = {.lex_state = 0},
  [1514] = {.lex_state = 0},
  [1515] = {.lex_state = 0},
  [1516] = {.lex_state = 78},
  [1517] = {.lex_state = 7},
  [1518] = {.lex_state = 0},
  [1519] = {.lex_state = 0},
  [1520] = {.lex_state = 35},
  [1521] = {.lex_state = 7},
  [1522] = {.lex_state = 7},
  [1523] = {.lex_state = 0},
  [1524] = {.lex_state = 7},
  [1525] = {.lex_state = 0},
  [1526] = {.lex_state = 0},
  [1527] = {.lex_state = 0},
  [1528] = {.lex_state = 0},
  [1529] = {.lex_state = 0},
  [1530] = {.lex_state = 78},
  [1531] = {.lex_state = 7},
  [1532] = {.lex_state = 7},
  [1533] = {.lex_state = 0},
  [1534] = {.lex_state = 0},
  [1535] = {.lex_state = 81},
  [1536] = {.lex_state = 7},
  [1537] = {.lex_state = 0},
  [1538] = {.lex_state = 0},
  [1539] = {.lex_state = 7},
  [1540] = {.lex_state = 0},
  [1541] = {.lex_state = 7},
  [1542] = {.lex_state = 0},
  [1543] = {.lex_state = 78},
  [1544] = {.lex_state = 7},
  [1545] = {.lex_state = 7},
  [1546] = {.lex_state = 7},
  [1547] = {.lex_state = 7},
  [1548] = {.lex_state = 78},
  [1549] = {.lex_state = 35},
  [1550] = {.lex_state = 7},
  [1551] = {.lex_state = 7},
  [1552] = {.lex_state = 0},
  [1553] = {.lex_state = 0},
  [1554] = {.lex_state = 0},
  [1555] = {.lex_state = 0},
  [1556] = {.lex_state = 7},
  [1557] = {.lex_state = 0},
  [1558] = {.lex_state = 0},
  [1559] = {.lex_state = 0},
  [1560] = {.lex_state = 7},
  [1561] = {.lex_state = 0},
  [1562] = {.lex_state = 0},
  [1563] = {.lex_state = 0},
  [1564] = {.lex_state = 7},
  [1565] = {.lex_state = 78},
  [1566] = {.lex_state = 0},
  [1567] = {.lex_state = 7},
  [1568] = {.lex_state = 0},
  [1569] = {.lex_state = 7},
  [1570] = {.lex_state = 78},
  [1571] = {.lex_state = 7},
  [1572] = {.lex_state = 78},
  [1573] = {.lex_state = 78},
  [1574] = {.lex_state = 7},
  [1575] = {.lex_state = 78},
  [1576] = {.lex_state = 78},
  [1577] = {.lex_state = 0},
  [1578] = {.lex_state = 0},
  [1579] = {.lex_state = 81, .external_lex_state = 3},
  [1580] = {.lex_state = 7},
  [1581] = {.lex_state = 0},
  [1582] = {.lex_state = 0},
  [1583] = {.lex_state = 78},
  [1584] = {.lex_state = 0},
  [1585] = {.lex_state = 0},
  [1586] = {.lex_state = 0},
  [1587] = {.lex_state = 0},
  [1588] = {.lex_state = 78},
  [1589] = {.lex_state = 0},
  [1590] = {.lex_state = 0},
  [1591] = {.lex_state = 0},
  [1592] = {.lex_state = 0},
  [1593] = {.lex_state = 7},
  [1594] = {.lex_state = 78},
  [1595] = {.lex_state = 78},
  [1596] = {.lex_state = 28},
  [1597] = {.lex_state = 78},
  [1598] = {.lex_state = 78},
  [1599] = {.lex_state = 0},
  [1600] = {.lex_state = 0},
  [1601] = {.lex_state = 0},
  [1602] = {.lex_state = 78},
  [1603] = {.lex_state = 78},
  [1604] = {.lex_state = 78},
  [1605] = {.lex_state = 0},
  [1606] = {.lex_state = 78},
  [1607] = {.lex_state = 0},
  [1608] = {.lex_state = 7},
  [1609] = {.lex_state = 0},
  [1610] = {.lex_state = 78},
  [1611] = {.lex_state = 78},
  [1612] = {.lex_state = 81},
  [1613] = {.lex_state = 0, .external_lex_state = 4},
  [1614] = {.lex_state = 0},
  [1615] = {.lex_state = 0},
  [1616] = {.lex_state = 0},
  [1617] = {.lex_state = 0, .external_lex_state = 5},
  [1618] = {.lex_state = 0, .external_lex_state = 4},
  [1619] = {.lex_state = 0},
  [1620] = {.lex_state = 0, .external_lex_state = 5},
  [1621] = {.lex_state = 81},
  [1622] = {.lex_state = 0},
  [1623] = {.lex_state = 0, .external_lex_state = 4},
  [1624] = {.lex_state = 0},
  [1625] = {.lex_state = 0, .external_lex_state = 5},
  [1626] = {.lex_state = 0, .external_lex_state = 4},
  [1627] = {.lex_state = 7},
  [1628] = {.lex_state = 0, .external_lex_state = 5},
  [1629] = {.lex_state = 0, .external_lex_state = 4},
  [1630] = {.lex_state = 0},
  [1631] = {.lex_state = 7},
  [1632] = {.lex_state = 0},
  [1633] = {.lex_state = 81},
  [1634] = {.lex_state = 7},
  [1635] = {.lex_state = 7},
  [1636] = {.lex_state = 0, .external_lex_state = 5},
  [1637] = {.lex_state = 7},
  [1638] = {.lex_state = 0},
  [1639] = {.lex_state = 81},
  [1640] = {.lex_state = 0, .external_lex_state = 6},
  [1641] = {.lex_state = 0},
  [1642] = {.lex_state = 0},
  [1643] = {.lex_state = 81},
  [1644] = {.lex_state = 7},
  [1645] = {.lex_state = 0},
  [1646] = {.lex_state = 81},
  [1647] = {.lex_state = 7},
  [1648] = {.lex_state = 81},
  [1649] = {.lex_state = 13},
  [1650] = {.lex_state = 7},
  [1651] = {.lex_state = 0},
  [1652] = {.lex_state = 0},
  [1653] = {.lex_state = 0},
  [1654] = {.lex_state = 81},
  [1655] = {.lex_state = 7},
  [1656] = {.lex_state = 81},
  [1657] = {.lex_state = 0},
  [1658] = {.lex_state = 12},
  [1659] = {.lex_state = 12},
  [1660] = {.lex_state = 0},
  [1661] = {.lex_state = 81},
  [1662] = {.lex_state = 7},
  [1663] = {.lex_state = 0},
  [1664] = {.lex_state = 0},
  [1665] = {.lex_state = 0},
  [1666] = {.lex_state = 81},
  [1667] = {.lex_state = 0},
  [1668] = {.lex_state = 7},
  [1669] = {.lex_state = 7},
  [1670] = {.lex_state = 7},
  [1671] = {.lex_state = 0},
  [1672] = {.lex_state = 7},
  [1673] = {.lex_state = 81},
  [1674] = {.lex_state = 0},
  [1675] = {.lex_state = 0},
  [1676] = {.lex_state = 0},
  [1677] = {.lex_state = 81},
  [1678] = {.lex_state = 0},
  [1679] = {.lex_state = 0},
  [1680] = {.lex_state = 0},
  [1681] = {.lex_state = 81},
  [1682] = {.lex_state = 81},
  [1683] = {.lex_state = 7},
  [1684] = {.lex_state = 81},
  [1685] = {.lex_state = 0, .external_lex_state = 6},
  [1686] = {.lex_state = 81},
  [1687] = {.lex_state = 0},
  [1688] = {.lex_state = 81},
  [1689] = {.lex_state = 81},
  [1690] = {.lex_state = 81},
  [1691] = {.lex_state = 13},
  [1692] = {.lex_state = 0},
  [1693] = {.lex_state = 0},
  [1694] = {.lex_state = 0},
  [1695] = {.lex_state = 81},
  [1696] = {.lex_state = 0},
  [1697] = {.lex_state = 7},
  [1698] = {.lex_state = 0},
  [1699] = {.lex_state = 12},
  [1700] = {.lex_state = 0},
  [1701] = {.lex_state = 0},
  [1702] = {.lex_state = 0},
  [1703] = {.lex_state = 81},
  [1704] = {.lex_state = 0},
  [1705] = {.lex_state = 81},
  [1706] = {.lex_state = 7},
  [1707] = {.lex_state = 0},
  [1708] = {.lex_state = 0, .external_lex_state = 4},
  [1709] = {.lex_state = 0},
  [1710] = {.lex_state = 81},
  [1711] = {.lex_state = 13},
  [1712] = {.lex_state = 81},
  [1713] = {.lex_state = 0},
  [1714] = {.lex_state = 0},
  [1715] = {.lex_state = 7},
  [1716] = {.lex_state = 81},
  [1717] = {.lex_state = 7},
  [1718] = {.lex_state = 0},
  [1719] = {.lex_state = 0},
  [1720] = {.lex_state = 0},
  [1721] = {.lex_state = 7},
  [1722] = {.lex_state = 0},
  [1723] = {.lex_state = 0},
  [1724] = {.lex_state = 0},
  [1725] = {.lex_state = 0},
  [1726] = {.lex_state = 7},
  [1727] = {.lex_state = 81},
  [1728] = {.lex_state = 0},
  [1729] = {.lex_state = 0},
  [1730] = {.lex_state = 7},
  [1731] = {.lex_state = 0},
  [1732] = {.lex_state = 0},
  [1733] = {.lex_state = 7},
  [1734] = {.lex_state = 0},
  [1735] = {.lex_state = 7},
  [1736] = {.lex_state = 81},
  [1737] = {.lex_state = 0},
  [1738] = {.lex_state = 31},
  [1739] = {.lex_state = 0},
  [1740] = {.lex_state = 7},
  [1741] = {.lex_state = 0},
  [1742] = {.lex_state = 0},
  [1743] = {.lex_state = 7},
  [1744] = {.lex_state = 0, .external_lex_state = 5},
  [1745] = {.lex_state = 0},
  [1746] = {.lex_state = 33},
  [1747] = {.lex_state = 78},
  [1748] = {.lex_state = 0},
  [1749] = {.lex_state = 0},
  [1750] = {.lex_state = 0},
  [1751] = {.lex_state = 0},
  [1752] = {.lex_state = 0},
  [1753] = {.lex_state = 0},
  [1754] = {.lex_state = 0},
  [1755] = {.lex_state = 0},
  [1756] = {.lex_state = 0},
  [1757] = {.lex_state = 7},
  [1758] = {.lex_state = 7},
  [1759] = {.lex_state = 0},
  [1760] = {.lex_state = 0},
  [1761] = {.lex_state = 0},
  [1762] = {.lex_state = 0},
  [1763] = {.lex_state = 0},
  [1764] = {.lex_state = 81},
  [1765] = {.lex_state = 0},
  [1766] = {.lex_state = 0},
  [1767] = {.lex_state = 0},
  [1768] = {.lex_state = 0},
  [1769] = {.lex_state = 7},
  [1770] = {.lex_state = 0},
  [1771] = {.lex_state = 0},
  [1772] = {.lex_state = 0},
  [1773] = {.lex_state = 7},
  [1774] = {.lex_state = 7},
  [1775] = {.lex_state = 81},
  [1776] = {.lex_state = 81},
  [1777] = {.lex_state = 0},
  [1778] = {.lex_state = 8},
  [1779] = {.lex_state = 0},
  [1780] = {.lex_state = 0},
  [1781] = {.lex_state = 0},
  [1782] = {.lex_state = 0},
  [1783] = {.lex_state = 7},
  [1784] = {.lex_state = 0},
  [1785] = {.lex_state = 0},
  [1786] = {.lex_state = 0},
  [1787] = {.lex_state = 0},
  [1788] = {.lex_state = 0},
  [1789] = {.lex_state = 0},
  [1790] = {.lex_state = 0},
  [1791] = {.lex_state = 7},
  [1792] = {.lex_state = 7},
  [1793] = {.lex_state = 81},
  [1794] = {.lex_state = 0},
  [1795] = {.lex_state = 0},
  [1796] = {.lex_state = 0},
  [1797] = {.lex_state = 0},
  [1798] = {.lex_state = 7},
  [1799] = {.lex_state = 0},
  [1800] = {.lex_state = 0},
  [1801] = {.lex_state = 0},
  [1802] = {.lex_state = 0},
  [1803] = {.lex_state = 81},
  [1804] = {.lex_state = 8},
  [1805] = {.lex_state = 8},
  [1806] = {.lex_state = 81},
  [1807] = {.lex_state = 8},
  [1808] = {.lex_state = 8},
  [1809] = {.lex_state = 78},
  [1810] = {.lex_state = 0},
  [1811] = {.lex_state = 8},
  [1812] = {.lex_state = 8},
  [1813] = {.lex_state = 8},
  [1814] = {.lex_state = 0},
  [1815] = {.lex_state = 81},
  [1816] = {.lex_state = 0},
  [1817] = {.lex_state = 0},
  [1818] = {.lex_state = 7},
  [1819] = {.lex_state = 0},
  [1820] = {.lex_state = 8},
  [1821] = {.lex_state = 0},
  [1822] = {.lex_state = 0},
  [1823] = {.lex_state = 0},
  [1824] = {.lex_state = 0},
  [1825] = {.lex_state = 0},
  [1826] = {.lex_state = 0},
  [1827] = {.lex_state = 0},
  [1828] = {.lex_state = 81},
  [1829] = {.lex_state = 7},
  [1830] = {.lex_state = 7},
  [1831] = {.lex_state = 33},
  [1832] = {.lex_state = 8},
  [1833] = {.lex_state = 0},
  [1834] = {.lex_state = 0},
  [1835] = {.lex_state = 0},
  [1836] = {.lex_state = 8},
  [1837] = {.lex_state = 8},
  [1838] = {.lex_state = 8},
  [1839] = {.lex_state = 8},
  [1840] = {.lex_state = 0},
  [1841] = {.lex_state = 8},
  [1842] = {.lex_state = 8},
  [1843] = {.lex_state = 0},
  [1844] = {.lex_state = 0},
  [1845] = {.lex_state = 7},
  [1846] = {.lex_state = 0},
  [1847] = {.lex_state = 81},
  [1848] = {.lex_state = 0},
  [1849] = {.lex_state = 0},
  [1850] = {.lex_state = 8},
  [1851] = {.lex_state = 33},
  [1852] = {.lex_state = 0},
  [1853] = {.lex_state = 0},
  [1854] = {.lex_state = 0},
  [1855] = {.lex_state = 7},
  [1856] = {.lex_state = 0},
  [1857] = {.lex_state = 0},
  [1858] = {.lex_state = 0},
  [1859] = {.lex_state = 33},
  [1860] = {.lex_state = 81},
  [1861] = {.lex_state = 7},
  [1862] = {.lex_state = 7},
  [1863] = {.lex_state = 8},
  [1864] = {.lex_state = 0},
  [1865] = {.lex_state = 81},
  [1866] = {.lex_state = 7},
  [1867] = {.lex_state = 81},
  [1868] = {.lex_state = 0},
  [1869] = {.lex_state = 81},
  [1870] = {.lex_state = 0},
  [1871] = {.lex_state = 0},
  [1872] = {.lex_state = 0},
  [1873] = {.lex_state = 0},
  [1874] = {.lex_state = 0},
  [1875] = {.lex_state = 0},
  [1876] = {.lex_state = 0},
  [1877] = {.lex_state = 0},
  [1878] = {.lex_state = 33},
  [1879] = {.lex_state = 0},
  [1880] = {.lex_state = 0},
  [1881] = {.lex_state = 81},
  [1882] = {.lex_state = 0},
  [1883] = {.lex_state = 0},
  [1884] = {.lex_state = 0},
  [1885] = {.lex_state = 0},
  [1886] = {.lex_state = 0},
  [1887] = {.lex_state = 0},
  [1888] = {.lex_state = 0},
  [1889] = {.lex_state = 0},
  [1890] = {.lex_state = 7},
  [1891] = {.lex_state = 81},
  [1892] = {.lex_state = 33},
  [1893] = {.lex_state = 0},
  [1894] = {.lex_state = 0},
  [1895] = {.lex_state = 0},
  [1896] = {.lex_state = 81},
  [1897] = {.lex_state = 0},
  [1898] = {.lex_state = 0},
  [1899] = {.lex_state = 0},
  [1900] = {.lex_state = 0},
  [1901] = {.lex_state = 0},
  [1902] = {.lex_state = 0},
  [1903] = {.lex_state = 0},
  [1904] = {.lex_state = 0},
  [1905] = {.lex_state = 0},
  [1906] = {.lex_state = 7},
  [1907] = {.lex_state = 0},
  [1908] = {.lex_state = 0},
  [1909] = {.lex_state = 0},
  [1910] = {.lex_state = 0},
  [1911] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_NULL] = ACTIONS(1),
    [anon_sym_package] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_blank_identifier] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_map] = ACTIONS(1),
    [anon_sym_chan] = ACTIONS(1),
    [anon_sym_LT_DASH] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_AMP_CARET_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_fallthrough] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_goto] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_go] = ACTIONS(1),
    [anon_sym_defer] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_range] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_select] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_make] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_AMP_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [sym_raw_string_literal] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE2] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_iota] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_templ] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_LBRACE_BANG] = ACTIONS(1),
    [anon_sym_children_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_LT_SLASH] = ACTIONS(1),
    [anon_sym_SLASH_GT] = ACTIONS(1),
    [anon_sym_LT_BANG] = ACTIONS(1),
    [anon_sym_html] = ACTIONS(1),
    [anon_sym_style] = ACTIONS(1),
    [anon_sym_if2] = ACTIONS(1),
    [anon_sym_else2] = ACTIONS(1),
    [anon_sym_css] = ACTIONS(1),
    [anon_sym_script] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_css_property_value] = ACTIONS(1),
    [sym_element_text] = ACTIONS(1),
    [sym_element_comment] = ACTIONS(1),
    [sym_style_element_text] = ACTIONS(1),
    [sym_script_block_text] = ACTIONS(1),
    [sym_script_element_text] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1858),
    [sym_package_clause] = STATE(1322),
    [sym_import_declaration] = STATE(1322),
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_function_declaration] = STATE(1322),
    [sym_method_declaration] = STATE(1322),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement] = STATE(1459),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_component_declaration] = STATE(1322),
    [sym_css_declaration] = STATE(1322),
    [sym_script_declaration] = STATE(1322),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [anon_sym_templ] = ACTIONS(75),
    [anon_sym_css] = ACTIONS(77),
    [anon_sym_script] = ACTIONS(79),
  },
  [2] = {
    [sym_package_clause] = STATE(1459),
    [sym_import_declaration] = STATE(1459),
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_function_declaration] = STATE(1459),
    [sym_method_declaration] = STATE(1459),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement] = STATE(1459),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_component_declaration] = STATE(1459),
    [sym_css_declaration] = STATE(1459),
    [sym_script_declaration] = STATE(1459),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(81),
    [sym_identifier] = ACTIONS(83),
    [anon_sym_SEMI] = ACTIONS(86),
    [anon_sym_package] = ACTIONS(89),
    [anon_sym_import] = ACTIONS(92),
    [anon_sym_LPAREN] = ACTIONS(95),
    [anon_sym_const] = ACTIONS(98),
    [anon_sym_var] = ACTIONS(101),
    [anon_sym_func] = ACTIONS(104),
    [anon_sym_LBRACK] = ACTIONS(107),
    [anon_sym_type] = ACTIONS(110),
    [anon_sym_STAR] = ACTIONS(113),
    [anon_sym_struct] = ACTIONS(116),
    [anon_sym_TILDE] = ACTIONS(119),
    [anon_sym_LBRACE] = ACTIONS(122),
    [anon_sym_interface] = ACTIONS(125),
    [anon_sym_map] = ACTIONS(128),
    [anon_sym_chan] = ACTIONS(131),
    [anon_sym_LT_DASH] = ACTIONS(134),
    [anon_sym_fallthrough] = ACTIONS(137),
    [anon_sym_break] = ACTIONS(140),
    [anon_sym_continue] = ACTIONS(143),
    [anon_sym_goto] = ACTIONS(146),
    [anon_sym_return] = ACTIONS(149),
    [anon_sym_go] = ACTIONS(152),
    [anon_sym_defer] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(158),
    [anon_sym_for] = ACTIONS(161),
    [anon_sym_switch] = ACTIONS(164),
    [anon_sym_select] = ACTIONS(167),
    [anon_sym_new] = ACTIONS(170),
    [anon_sym_make] = ACTIONS(170),
    [anon_sym_PLUS] = ACTIONS(173),
    [anon_sym_DASH] = ACTIONS(173),
    [anon_sym_BANG] = ACTIONS(173),
    [anon_sym_CARET] = ACTIONS(173),
    [anon_sym_AMP] = ACTIONS(173),
    [sym_raw_string_literal] = ACTIONS(176),
    [anon_sym_DQUOTE] = ACTIONS(179),
    [sym_int_literal] = ACTIONS(182),
    [sym_float_literal] = ACTIONS(182),
    [sym_imaginary_literal] = ACTIONS(182),
    [sym_rune_literal] = ACTIONS(176),
    [sym_nil] = ACTIONS(182),
    [sym_true] = ACTIONS(182),
    [sym_false] = ACTIONS(182),
    [sym_iota] = ACTIONS(182),
    [sym_comment] = ACTIONS(3),
    [anon_sym_templ] = ACTIONS(185),
    [anon_sym_css] = ACTIONS(188),
    [anon_sym_script] = ACTIONS(191),
  },
  [3] = {
    [sym_package_clause] = STATE(1332),
    [sym_import_declaration] = STATE(1332),
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_function_declaration] = STATE(1332),
    [sym_method_declaration] = STATE(1332),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement] = STATE(1459),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_component_declaration] = STATE(1332),
    [sym_css_declaration] = STATE(1332),
    [sym_script_declaration] = STATE(1332),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(194),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_package] = ACTIONS(11),
    [anon_sym_import] = ACTIONS(13),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(21),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
    [anon_sym_templ] = ACTIONS(75),
    [anon_sym_css] = ACTIONS(77),
    [anon_sym_script] = ACTIONS(79),
  },
  [4] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1564),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1564),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(200),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(202),
    [anon_sym_default] = ACTIONS(202),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1489),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1489),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(204),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(206),
    [anon_sym_default] = ACTIONS(206),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1498),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1498),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(208),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(210),
    [anon_sym_default] = ACTIONS(210),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1505),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1505),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(212),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(214),
    [anon_sym_default] = ACTIONS(214),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1569),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1569),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(216),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(218),
    [anon_sym_default] = ACTIONS(218),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement] = STATE(1195),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1593),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(222),
    [anon_sym_default] = ACTIONS(222),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement] = STATE(1195),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1517),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(226),
    [anon_sym_default] = ACTIONS(226),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement] = STATE(1178),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(228),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_case] = ACTIONS(230),
    [anon_sym_default] = ACTIONS(230),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1787),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1787),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(232),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1817),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1817),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(234),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1767),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1767),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(236),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1756),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1756),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(238),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1844),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1844),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(240),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1782),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1782),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(242),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement_list] = STATE(1887),
    [sym__statement] = STATE(1120),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_empty_labeled_statement] = STATE(1887),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(196),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_RBRACE] = ACTIONS(244),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement] = STATE(1195),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym__declaration] = STATE(1139),
    [sym_const_declaration] = STATE(1139),
    [sym_var_declaration] = STATE(1139),
    [sym_type_declaration] = STATE(1139),
    [sym_expression_list] = STATE(878),
    [sym_parenthesized_type] = STATE(1652),
    [sym__simple_type] = STATE(1652),
    [sym_generic_type] = STATE(1323),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1323),
    [sym_implicit_length_array_type] = STATE(1654),
    [sym_slice_type] = STATE(1323),
    [sym_struct_type] = STATE(1323),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1323),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1139),
    [sym__statement] = STATE(1178),
    [sym_empty_statement] = STATE(1139),
    [sym__simple_statement] = STATE(1139),
    [sym_expression_statement] = STATE(1140),
    [sym_send_statement] = STATE(1140),
    [sym_inc_statement] = STATE(1140),
    [sym_dec_statement] = STATE(1140),
    [sym_assignment_statement] = STATE(1140),
    [sym_short_var_declaration] = STATE(1140),
    [sym_labeled_statement] = STATE(1139),
    [sym_fallthrough_statement] = STATE(1139),
    [sym_break_statement] = STATE(1139),
    [sym_continue_statement] = STATE(1139),
    [sym_goto_statement] = STATE(1139),
    [sym_return_statement] = STATE(1139),
    [sym_go_statement] = STATE(1139),
    [sym_defer_statement] = STATE(1139),
    [sym_if_statement] = STATE(1139),
    [sym_for_statement] = STATE(1139),
    [sym_expression_switch_statement] = STATE(1139),
    [sym_type_switch_statement] = STATE(1139),
    [sym_select_statement] = STATE(1139),
    [sym__expression] = STATE(282),
    [sym_parenthesized_expression] = STATE(322),
    [sym_call_expression] = STATE(322),
    [sym_selector_expression] = STATE(322),
    [sym_index_expression] = STATE(322),
    [sym_slice_expression] = STATE(322),
    [sym_type_assertion_expression] = STATE(322),
    [sym_type_conversion_expression] = STATE(322),
    [sym_composite_literal] = STATE(322),
    [sym_func_literal] = STATE(322),
    [sym_unary_expression] = STATE(322),
    [sym_binary_expression] = STATE(322),
    [sym_qualified_type] = STATE(1141),
    [sym_interpreted_string_literal] = STATE(322),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_SEMI] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_var] = ACTIONS(19),
    [anon_sym_func] = ACTIONS(198),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_type] = ACTIONS(25),
    [anon_sym_STAR] = ACTIONS(27),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(41),
    [anon_sym_fallthrough] = ACTIONS(43),
    [anon_sym_break] = ACTIONS(45),
    [anon_sym_continue] = ACTIONS(47),
    [anon_sym_goto] = ACTIONS(49),
    [anon_sym_return] = ACTIONS(51),
    [anon_sym_go] = ACTIONS(53),
    [anon_sym_defer] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_for] = ACTIONS(59),
    [anon_sym_switch] = ACTIONS(61),
    [anon_sym_select] = ACTIONS(63),
    [anon_sym_new] = ACTIONS(65),
    [anon_sym_make] = ACTIONS(65),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(67),
    [anon_sym_BANG] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [sym_raw_string_literal] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(71),
    [sym_int_literal] = ACTIONS(73),
    [sym_float_literal] = ACTIONS(73),
    [sym_imaginary_literal] = ACTIONS(73),
    [sym_rune_literal] = ACTIONS(69),
    [sym_nil] = ACTIONS(73),
    [sym_true] = ACTIONS(73),
    [sym_false] = ACTIONS(73),
    [sym_iota] = ACTIONS(73),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_expression_list] = STATE(883),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym_block] = STATE(1151),
    [sym__simple_statement] = STATE(1800),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym_for_clause] = STATE(1689),
    [sym_range_clause] = STATE(1689),
    [sym__expression] = STATE(313),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(33),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_range] = ACTIONS(258),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_expression_list] = STATE(883),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1800),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym_for_clause] = STATE(1633),
    [sym_range_clause] = STATE(1633),
    [sym__expression] = STATE(321),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_component_block] = STATE(1003),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(270),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_range] = ACTIONS(258),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_expression_list] = STATE(883),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1800),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym_for_clause] = STATE(1705),
    [sym_range_clause] = STATE(1705),
    [sym__expression] = STATE(314),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_component_block] = STATE(988),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(272),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_range] = ACTIONS(258),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_expression_list] = STATE(883),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1800),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym_for_clause] = STATE(1703),
    [sym_range_clause] = STATE(1703),
    [sym__expression] = STATE(325),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_component_block] = STATE(1574),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_SEMI] = ACTIONS(248),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(274),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_range] = ACTIONS(258),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_expression_list] = STATE(884),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1795),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__type_switch_header] = STATE(1793),
    [sym__expression] = STATE(334),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(276),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_expression_list] = STATE(876),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1873),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(335),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(278),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_expression_list] = STATE(874),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1847),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(344),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(280),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_expression_list] = STATE(876),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1894),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(337),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(282),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym_expression_list] = STATE(874),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1775),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(344),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(284),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_expression_list] = STATE(874),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1881),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(344),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(286),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_expression_list] = STATE(874),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1803),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(344),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(288),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym_expression_list] = STATE(876),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1880),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(336),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_LBRACE] = ACTIONS(290),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_expression_list] = STATE(876),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1875),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(296),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_expression_list] = STATE(876),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1876),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(318),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_expression_list] = STATE(876),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1802),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(310),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_expression_list] = STATE(876),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1893),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(332),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_expression_list] = STATE(876),
    [sym_parenthesized_type] = STATE(1616),
    [sym__simple_type] = STATE(1616),
    [sym_generic_type] = STATE(1395),
    [sym_pointer_type] = STATE(1034),
    [sym_array_type] = STATE(1395),
    [sym_implicit_length_array_type] = STATE(1621),
    [sym_slice_type] = STATE(1395),
    [sym_struct_type] = STATE(1395),
    [sym_union_type] = STATE(1027),
    [sym_negated_type] = STATE(1027),
    [sym_interface_type] = STATE(1034),
    [sym_map_type] = STATE(1395),
    [sym_channel_type] = STATE(1034),
    [sym_function_type] = STATE(1034),
    [sym__simple_statement] = STATE(1879),
    [sym_expression_statement] = STATE(1736),
    [sym_send_statement] = STATE(1736),
    [sym_inc_statement] = STATE(1736),
    [sym_dec_statement] = STATE(1736),
    [sym_assignment_statement] = STATE(1736),
    [sym_short_var_declaration] = STATE(1736),
    [sym__expression] = STATE(312),
    [sym_parenthesized_expression] = STATE(377),
    [sym_call_expression] = STATE(377),
    [sym_selector_expression] = STATE(377),
    [sym_index_expression] = STATE(377),
    [sym_slice_expression] = STATE(377),
    [sym_type_assertion_expression] = STATE(377),
    [sym_type_conversion_expression] = STATE(377),
    [sym_composite_literal] = STATE(377),
    [sym_func_literal] = STATE(377),
    [sym_unary_expression] = STATE(377),
    [sym_binary_expression] = STATE(377),
    [sym_qualified_type] = STATE(1217),
    [sym_interpreted_string_literal] = STATE(377),
    [sym_identifier] = ACTIONS(246),
    [anon_sym_LPAREN] = ACTIONS(250),
    [anon_sym_func] = ACTIONS(252),
    [anon_sym_LBRACK] = ACTIONS(23),
    [anon_sym_STAR] = ACTIONS(254),
    [anon_sym_struct] = ACTIONS(29),
    [anon_sym_TILDE] = ACTIONS(31),
    [anon_sym_interface] = ACTIONS(35),
    [anon_sym_map] = ACTIONS(37),
    [anon_sym_chan] = ACTIONS(39),
    [anon_sym_LT_DASH] = ACTIONS(256),
    [anon_sym_new] = ACTIONS(260),
    [anon_sym_make] = ACTIONS(260),
    [anon_sym_PLUS] = ACTIONS(262),
    [anon_sym_DASH] = ACTIONS(262),
    [anon_sym_BANG] = ACTIONS(262),
    [anon_sym_CARET] = ACTIONS(262),
    [anon_sym_AMP] = ACTIONS(262),
    [sym_raw_string_literal] = ACTIONS(264),
    [anon_sym_DQUOTE] = ACTIONS(266),
    [sym_int_literal] = ACTIONS(268),
    [sym_float_literal] = ACTIONS(268),
    [sym_imaginary_literal] = ACTIONS(268),
    [sym_rune_literal] = ACTIONS(264),
    [sym_nil] = ACTIONS(268),
    [sym_true] = ACTIONS(268),
    [sym_false] = ACTIONS(268),
    [sym_iota] = ACTIONS(268),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 27,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(294), 1,
      anon_sym_LF,
    ACTIONS(298), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(304), 1,
      anon_sym_STAR,
    ACTIONS(306), 1,
      anon_sym_TILDE,
    ACTIONS(308), 1,
      anon_sym_LT_DASH,
    ACTIONS(316), 1,
      anon_sym_DQUOTE,
    ACTIONS(318), 1,
      sym_comment,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1150), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(296), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(312), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 9,
      sym_raw_string_literal,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_rune_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [119] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(324), 1,
      anon_sym_COMMA,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(332), 1,
      anon_sym_RBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1378), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1555), 1,
      sym_keyed_element,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [245] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(346), 1,
      anon_sym_COMMA,
    ACTIONS(348), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1364), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1563), 1,
      sym_keyed_element,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [371] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(350), 1,
      anon_sym_COMMA,
    ACTIONS(352), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1346), 1,
      sym_literal_element,
    STATE(1533), 1,
      sym_keyed_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [497] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(354), 1,
      anon_sym_COMMA,
    ACTIONS(356), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1388), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1609), 1,
      sym_keyed_element,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [623] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(358), 1,
      anon_sym_COMMA,
    ACTIONS(360), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1359), 1,
      sym_literal_element,
    STATE(1553), 1,
      sym_keyed_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [749] = 31,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(362), 1,
      anon_sym_COMMA,
    ACTIONS(364), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1428), 1,
      sym_literal_element,
    STATE(1511), 1,
      sym_keyed_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [875] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(366), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [998] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(368), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1121] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(370), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1244] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(372), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1367] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(374), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1490] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(376), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1613] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1736] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(380), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1859] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(382), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [1982] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(384), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2105] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(386), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2228] = 30,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      anon_sym_RBRACE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2351] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1469), 1,
      sym_literal_element,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1667), 1,
      sym_keyed_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2471] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(635), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1554), 1,
      sym_literal_value,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1663), 1,
      sym_literal_element,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2588] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    STATE(499), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1619), 1,
      sym_expression_list,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1614), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1898), 2,
      sym_send_statement,
      sym_receive_statement,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2703] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(410), 1,
      sym_identifier,
    ACTIONS(412), 1,
      anon_sym_RBRACK,
    ACTIONS(414), 1,
      anon_sym_STAR,
    STATE(771), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1587), 1,
      sym_parameter_declaration,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1381), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2817] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(418), 1,
      anon_sym_RPAREN,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [2931] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(426), 1,
      anon_sym_RBRACE,
    ACTIONS(428), 1,
      anon_sym_children_DOT_DOT_DOT,
    STATE(748), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3045] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(430), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3159] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(436), 1,
      anon_sym_LBRACE,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(583), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1895), 1,
      sym_expression_list,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3273] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(442), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3387] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(444), 1,
      anon_sym_RPAREN,
    STATE(585), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1504), 1,
      sym_variadic_argument,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3501] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(446), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3615] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(448), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3729] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(450), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3843] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(452), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [3957] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(454), 1,
      anon_sym_COMMA,
    ACTIONS(456), 1,
      anon_sym_RBRACE,
    ACTIONS(458), 1,
      sym_raw_string_literal,
    STATE(629), 1,
      sym__expression,
    STATE(799), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [4075] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(460), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4189] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(462), 1,
      anon_sym_RPAREN,
    STATE(570), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1495), 1,
      sym_variadic_argument,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4303] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      anon_sym_range,
    STATE(577), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1612), 1,
      sym_expression_list,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4417] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(466), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4531] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(468), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4645] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(470), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4759] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(472), 1,
      anon_sym_RPAREN,
    STATE(574), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1561), 1,
      sym_variadic_argument,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4873] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(474), 1,
      anon_sym_RPAREN,
    STATE(579), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1590), 1,
      sym_variadic_argument,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [4987] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      anon_sym_RBRACE,
    ACTIONS(478), 1,
      anon_sym_children_DOT_DOT_DOT,
    STATE(815), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5101] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(464), 1,
      anon_sym_range,
    STATE(577), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1682), 1,
      sym_expression_list,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5215] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(480), 1,
      anon_sym_COMMA,
    ACTIONS(482), 1,
      anon_sym_RBRACE,
    ACTIONS(484), 1,
      sym_raw_string_literal,
    STATE(619), 1,
      sym__expression,
    STATE(836), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [5333] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(486), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5447] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(488), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5561] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(490), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5675] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(492), 1,
      anon_sym_RPAREN,
    STATE(573), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1514), 1,
      sym_variadic_argument,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5789] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_RBRACK,
    ACTIONS(496), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(782), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [5903] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(498), 1,
      anon_sym_RPAREN,
    STATE(571), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1566), 1,
      sym_variadic_argument,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6017] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(500), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6131] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(502), 1,
      anon_sym_RBRACE,
    ACTIONS(504), 1,
      anon_sym_children_DOT_DOT_DOT,
    STATE(828), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6245] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(506), 1,
      anon_sym_RPAREN,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6359] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(508), 1,
      anon_sym_RPAREN,
    STATE(576), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1562), 1,
      sym_variadic_argument,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6473] = 29,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(510), 1,
      anon_sym_COMMA,
    ACTIONS(512), 1,
      anon_sym_RBRACE,
    ACTIONS(514), 1,
      sym_raw_string_literal,
    STATE(646), 1,
      sym__expression,
    STATE(716), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [6591] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(516), 1,
      anon_sym_RPAREN,
    STATE(572), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1526), 1,
      sym_variadic_argument,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6705] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(518), 1,
      sym_identifier,
    ACTIONS(520), 1,
      anon_sym_COLON,
    STATE(675), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1291), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6816] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(577), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1682), 1,
      sym_expression_list,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [6927] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(494), 1,
      anon_sym_RBRACK,
    ACTIONS(518), 1,
      sym_identifier,
    STATE(782), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1291), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7038] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(522), 1,
      anon_sym_RBRACK,
    STATE(664), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7149] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1243), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7260] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1242), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7371] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(536), 1,
      anon_sym_RBRACK,
    STATE(703), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7482] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(538), 1,
      anon_sym_RBRACK,
    STATE(667), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7593] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(540), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7704] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(542), 1,
      anon_sym_RBRACK,
    STATE(838), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7815] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(494), 1,
      anon_sym_RBRACK,
    STATE(782), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [7926] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(502), 1,
      anon_sym_RBRACE,
    STATE(828), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8037] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(642), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1682), 1,
      sym_expression_list,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8148] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    ACTIONS(544), 1,
      anon_sym_LBRACE,
    STATE(814), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8259] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(642), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1612), 1,
      sym_expression_list,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8370] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1241), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8481] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1240), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8592] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(546), 1,
      anon_sym_SEMI,
    STATE(811), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8703] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(548), 1,
      anon_sym_RBRACK,
    STATE(680), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8814] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(550), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [8925] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(518), 1,
      sym_identifier,
    ACTIONS(552), 1,
      anon_sym_COLON,
    STATE(697), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1291), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9036] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(554), 1,
      anon_sym_RBRACK,
    STATE(676), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9147] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(556), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9258] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    ACTIONS(558), 1,
      anon_sym_LBRACE,
    STATE(793), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9369] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(560), 1,
      anon_sym_RBRACK,
    STATE(738), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9480] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(577), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1788), 1,
      sym_expression_list,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9591] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(562), 1,
      anon_sym_RBRACE,
    ACTIONS(564), 1,
      sym_raw_string_literal,
    STATE(709), 1,
      sym__expression,
    STATE(849), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [9706] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(566), 1,
      anon_sym_RBRACK,
    STATE(712), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9817] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(412), 1,
      anon_sym_RBRACK,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(518), 1,
      sym_identifier,
    STATE(771), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1311), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [9928] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(518), 1,
      sym_identifier,
    ACTIONS(568), 1,
      anon_sym_COLON,
    STATE(658), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1291), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10039] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(631), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1612), 1,
      sym_expression_list,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10150] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(632), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1679), 1,
      sym_variadic_argument,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10261] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(570), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10372] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_raw_string_literal,
    ACTIONS(572), 1,
      anon_sym_RBRACE,
    STATE(709), 1,
      sym__expression,
    STATE(849), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [10487] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(577), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    STATE(1882), 1,
      sym_expression_list,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10598] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(574), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10709] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(576), 1,
      anon_sym_RBRACK,
    STATE(816), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10820] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(578), 1,
      anon_sym_RBRACK,
    STATE(701), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [10931] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(580), 1,
      anon_sym_RBRACK,
    STATE(794), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11042] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(582), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11153] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(584), 1,
      anon_sym_SEMI,
    STATE(759), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11264] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(586), 1,
      anon_sym_RBRACK,
    STATE(689), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11375] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(518), 1,
      sym_identifier,
    ACTIONS(588), 1,
      anon_sym_COLON,
    STATE(681), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1291), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11486] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1179), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11597] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1180), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11708] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1201), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11819] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1197), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [11930] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_raw_string_literal,
    ACTIONS(590), 1,
      anon_sym_RBRACE,
    STATE(709), 1,
      sym__expression,
    STATE(849), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [12045] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_raw_string_literal,
    ACTIONS(592), 1,
      anon_sym_RBRACE,
    STATE(709), 1,
      sym__expression,
    STATE(849), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [12160] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(594), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12271] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(596), 1,
      anon_sym_RBRACK,
    STATE(705), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12382] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(598), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12493] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(600), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12604] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(602), 1,
      anon_sym_RBRACK,
    STATE(714), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12715] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(604), 1,
      anon_sym_RBRACK,
    STATE(672), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12826] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(518), 1,
      sym_identifier,
    ACTIONS(606), 1,
      anon_sym_COLON,
    STATE(692), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1291), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [12937] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(412), 1,
      anon_sym_RBRACK,
    STATE(771), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13048] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(608), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13159] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    ACTIONS(610), 1,
      anon_sym_LBRACE,
    STATE(832), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13270] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(577), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1612), 1,
      sym_expression_list,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13381] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(612), 1,
      anon_sym_RBRACK,
    STATE(669), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13492] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_raw_string_literal,
    ACTIONS(614), 1,
      anon_sym_RBRACE,
    STATE(709), 1,
      sym__expression,
    STATE(849), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [13607] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1187), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13718] = 28,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_raw_string_literal,
    ACTIONS(616), 1,
      anon_sym_RBRACE,
    STATE(709), 1,
      sym__expression,
    STATE(849), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [13833] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(518), 1,
      sym_identifier,
    ACTIONS(618), 1,
      anon_sym_COLON,
    STATE(702), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1291), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [13944] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(620), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14055] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(622), 1,
      anon_sym_RPAREN,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14166] = 26,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(481), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1184), 1,
      sym_expression_list,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14277] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    STATE(386), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1615), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14385] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(450), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14493] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_func,
    ACTIONS(644), 1,
      sym_identifier,
    STATE(288), 1,
      sym__expression,
    STATE(1141), 1,
      sym_qualified_type,
    STATE(1654), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(69), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1652), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1323), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(322), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14601] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(699), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14709] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14817] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(845), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [14925] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(492), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15033] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    ACTIONS(646), 1,
      anon_sym_chan,
    STATE(554), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1614), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15141] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    STATE(384), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15249] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(553), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15357] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(485), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15465] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(624), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15573] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    ACTIONS(646), 1,
      anon_sym_chan,
    STATE(384), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1615), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15681] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(825), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15789] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [15897] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16005] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(432), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16113] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(657), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16221] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(823), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16329] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(652), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16437] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(648), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16545] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(824), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16653] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(691), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16761] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(622), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16869] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(621), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [16977] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(820), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17085] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(644), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17193] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(620), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17301] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(694), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17409] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17517] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    STATE(535), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1614), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17625] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    STATE(536), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1614), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17733] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(735), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17841] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    STATE(383), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1615), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [17949] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(646), 1,
      anon_sym_chan,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18057] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    STATE(385), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1615), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18165] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_func,
    ACTIONS(644), 1,
      sym_identifier,
    STATE(286), 1,
      sym__expression,
    STATE(1141), 1,
      sym_qualified_type,
    STATE(1654), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(69), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1652), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1323), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(322), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18273] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(848), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18381] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(648), 1,
      anon_sym_STAR,
    STATE(772), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1470), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18489] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    STATE(382), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1615), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18597] = 27,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(340), 1,
      sym_rune_literal,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(564), 1,
      sym_raw_string_literal,
    STATE(709), 1,
      sym__expression,
    STATE(849), 1,
      sym_interpreted_string_literal,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 11,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
  [18709] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    STATE(387), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1615), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18817] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(674), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [18925] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LPAREN,
    ACTIONS(252), 1,
      anon_sym_func,
    ACTIONS(254), 1,
      anon_sym_STAR,
    ACTIONS(256), 1,
      anon_sym_LT_DASH,
    ACTIONS(266), 1,
      anon_sym_DQUOTE,
    STATE(339), 1,
      sym__expression,
    STATE(1217), 1,
      sym_qualified_type,
    STATE(1621), 1,
      sym_implicit_length_array_type,
    ACTIONS(260), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(264), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(262), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1395), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(268), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(377), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19033] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(414), 1,
      anon_sym_STAR,
    ACTIONS(518), 1,
      sym_identifier,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19141] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(698), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19249] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(512), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19357] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_func,
    ACTIONS(644), 1,
      sym_identifier,
    STATE(285), 1,
      sym__expression,
    STATE(1141), 1,
      sym_qualified_type,
    STATE(1654), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(69), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1652), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1323), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(322), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19465] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    STATE(384), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1615), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19573] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_func,
    ACTIONS(644), 1,
      sym_identifier,
    STATE(284), 1,
      sym__expression,
    STATE(1141), 1,
      sym_qualified_type,
    STATE(1654), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(69), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1652), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1323), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(322), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19681] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19789] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(743), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [19897] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(432), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20005] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(487), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20113] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(742), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20221] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(624), 1,
      sym_identifier,
    ACTIONS(626), 1,
      anon_sym_LPAREN,
    ACTIONS(628), 1,
      anon_sym_func,
    ACTIONS(630), 1,
      anon_sym_STAR,
    ACTIONS(632), 1,
      anon_sym_LT_DASH,
    ACTIONS(640), 1,
      anon_sym_DQUOTE,
    STATE(388), 1,
      sym__expression,
    STATE(1188), 1,
      sym_qualified_type,
    STATE(1656), 1,
      sym_implicit_length_array_type,
    ACTIONS(634), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(638), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1615), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(636), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1375), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(642), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(416), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20329] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(648), 1,
      anon_sym_STAR,
    STATE(717), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1470), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20437] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    STATE(554), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20545] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(648), 1,
      anon_sym_STAR,
    STATE(734), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1470), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20653] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(463), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20761] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    STATE(554), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1614), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20869] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(461), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [20977] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(458), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21085] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(688), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21193] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(715), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21301] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    STATE(534), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1614), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21409] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_func,
    ACTIONS(644), 1,
      sym_identifier,
    STATE(287), 1,
      sym__expression,
    STATE(1141), 1,
      sym_qualified_type,
    STATE(1654), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(69), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1652), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1323), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(322), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21517] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(678), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21625] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(785), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21733] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(788), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21841] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LPAREN,
    ACTIONS(252), 1,
      anon_sym_func,
    ACTIONS(254), 1,
      anon_sym_STAR,
    ACTIONS(256), 1,
      anon_sym_LT_DASH,
    ACTIONS(266), 1,
      anon_sym_DQUOTE,
    STATE(343), 1,
      sym__expression,
    STATE(1217), 1,
      sym_qualified_type,
    STATE(1621), 1,
      sym_implicit_length_array_type,
    ACTIONS(260), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(264), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1616), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(262), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1395), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(268), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(377), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [21949] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(489), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22057] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_func,
    ACTIONS(644), 1,
      sym_identifier,
    STATE(289), 1,
      sym__expression,
    STATE(1141), 1,
      sym_qualified_type,
    STATE(1654), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(69), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1652), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1323), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(322), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22165] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(806), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22273] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(648), 1,
      anon_sym_STAR,
    STATE(790), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1470), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22381] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    STATE(527), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1614), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22489] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(390), 1,
      sym_identifier,
    ACTIONS(392), 1,
      anon_sym_LPAREN,
    ACTIONS(394), 1,
      anon_sym_func,
    ACTIONS(396), 1,
      anon_sym_STAR,
    ACTIONS(398), 1,
      anon_sym_LT_DASH,
    ACTIONS(406), 1,
      anon_sym_DQUOTE,
    STATE(539), 1,
      sym__expression,
    STATE(1172), 1,
      sym_qualified_type,
    STATE(1710), 1,
      sym_implicit_length_array_type,
    ACTIONS(400), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(404), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1614), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(402), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1351), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(408), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(595), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22597] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(432), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22705] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(659), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22813] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    ACTIONS(646), 1,
      anon_sym_chan,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [22921] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(491), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23029] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(648), 1,
      anon_sym_STAR,
    STATE(792), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1470), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23137] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(804), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23245] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(500), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23353] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23461] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23569] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(501), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23677] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LPAREN,
    ACTIONS(252), 1,
      anon_sym_func,
    ACTIONS(254), 1,
      anon_sym_STAR,
    ACTIONS(256), 1,
      anon_sym_LT_DASH,
    ACTIONS(266), 1,
      anon_sym_DQUOTE,
    STATE(342), 1,
      sym__expression,
    STATE(1217), 1,
      sym_qualified_type,
    STATE(1621), 1,
      sym_implicit_length_array_type,
    ACTIONS(260), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(264), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1616), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(262), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1395), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(268), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(377), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23785] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    ACTIONS(646), 1,
      anon_sym_chan,
    STATE(490), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [23893] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(662), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24001] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LPAREN,
    ACTIONS(252), 1,
      anon_sym_func,
    ACTIONS(254), 1,
      anon_sym_STAR,
    ACTIONS(256), 1,
      anon_sym_LT_DASH,
    ACTIONS(266), 1,
      anon_sym_DQUOTE,
    STATE(341), 1,
      sym__expression,
    STATE(1217), 1,
      sym_qualified_type,
    STATE(1621), 1,
      sym_implicit_length_array_type,
    ACTIONS(260), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(264), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1616), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(262), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1395), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(268), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(377), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24109] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LPAREN,
    ACTIONS(252), 1,
      anon_sym_func,
    ACTIONS(254), 1,
      anon_sym_STAR,
    ACTIONS(256), 1,
      anon_sym_LT_DASH,
    ACTIONS(266), 1,
      anon_sym_DQUOTE,
    STATE(340), 1,
      sym__expression,
    STATE(1217), 1,
      sym_qualified_type,
    STATE(1621), 1,
      sym_implicit_length_array_type,
    ACTIONS(260), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(264), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1616), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(262), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1395), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(268), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(377), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24217] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    STATE(708), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24325] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_func,
    ACTIONS(644), 1,
      sym_identifier,
    ACTIONS(646), 1,
      anon_sym_chan,
    STATE(289), 1,
      sym__expression,
    STATE(1141), 1,
      sym_qualified_type,
    STATE(1654), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(69), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1652), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1323), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(322), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24433] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LPAREN,
    ACTIONS(252), 1,
      anon_sym_func,
    ACTIONS(254), 1,
      anon_sym_STAR,
    ACTIONS(256), 1,
      anon_sym_LT_DASH,
    ACTIONS(266), 1,
      anon_sym_DQUOTE,
    STATE(345), 1,
      sym__expression,
    STATE(1217), 1,
      sym_qualified_type,
    STATE(1621), 1,
      sym_implicit_length_array_type,
    ACTIONS(260), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(264), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1616), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(262), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1395), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(268), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(377), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24541] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(781), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24649] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(774), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24757] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(778), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24865] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(648), 1,
      anon_sym_STAR,
    STATE(812), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1470), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [24973] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(835), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25081] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LPAREN,
    ACTIONS(252), 1,
      anon_sym_func,
    ACTIONS(254), 1,
      anon_sym_STAR,
    ACTIONS(256), 1,
      anon_sym_LT_DASH,
    ACTIONS(266), 1,
      anon_sym_DQUOTE,
    STATE(339), 1,
      sym__expression,
    STATE(1217), 1,
      sym_qualified_type,
    STATE(1621), 1,
      sym_implicit_length_array_type,
    ACTIONS(260), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(264), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1616), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(262), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1395), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(268), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(377), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25189] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(490), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25297] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(729), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25405] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(800), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25513] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(671), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25621] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(292), 1,
      sym_identifier,
    ACTIONS(300), 1,
      anon_sym_func,
    ACTIONS(524), 1,
      anon_sym_LPAREN,
    ACTIONS(526), 1,
      anon_sym_STAR,
    ACTIONS(528), 1,
      anon_sym_LT_DASH,
    ACTIONS(534), 1,
      anon_sym_DQUOTE,
    STATE(482), 1,
      sym__expression,
    STATE(1137), 1,
      sym_qualified_type,
    STATE(1677), 1,
      sym_implicit_length_array_type,
    ACTIONS(310), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(532), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1624), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(530), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1439), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(314), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(529), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25729] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(797), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25837] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(690), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [25945] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(15), 1,
      anon_sym_LPAREN,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_STAR,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(41), 1,
      anon_sym_LT_DASH,
    ACTIONS(71), 1,
      anon_sym_DQUOTE,
    ACTIONS(198), 1,
      anon_sym_func,
    ACTIONS(644), 1,
      sym_identifier,
    STATE(289), 1,
      sym__expression,
    STATE(1141), 1,
      sym_qualified_type,
    STATE(1654), 1,
      sym_implicit_length_array_type,
    ACTIONS(65), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(69), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(67), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1323), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(73), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(322), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [26053] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(764), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [26161] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(328), 1,
      anon_sym_STAR,
    ACTIONS(334), 1,
      anon_sym_LT_DASH,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    STATE(768), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(338), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [26269] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(416), 1,
      sym_identifier,
    ACTIONS(420), 1,
      anon_sym_STAR,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(646), 1,
      anon_sym_chan,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [26377] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(320), 1,
      sym_identifier,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(422), 1,
      anon_sym_LT_DASH,
    ACTIONS(648), 1,
      anon_sym_STAR,
    STATE(430), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1310), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(424), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [26485] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(246), 1,
      sym_identifier,
    ACTIONS(250), 1,
      anon_sym_LPAREN,
    ACTIONS(252), 1,
      anon_sym_func,
    ACTIONS(254), 1,
      anon_sym_STAR,
    ACTIONS(256), 1,
      anon_sym_LT_DASH,
    ACTIONS(266), 1,
      anon_sym_DQUOTE,
    ACTIONS(646), 1,
      anon_sym_chan,
    STATE(339), 1,
      sym__expression,
    STATE(1217), 1,
      sym_qualified_type,
    STATE(1621), 1,
      sym_implicit_length_array_type,
    ACTIONS(260), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(264), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1616), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(262), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1395), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(268), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(377), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [26593] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(23), 1,
      anon_sym_LBRACK,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(326), 1,
      anon_sym_func,
    ACTIONS(342), 1,
      anon_sym_DQUOTE,
    ACTIONS(432), 1,
      sym_identifier,
    ACTIONS(434), 1,
      anon_sym_STAR,
    ACTIONS(438), 1,
      anon_sym_LT_DASH,
    STATE(693), 1,
      sym__expression,
    STATE(1068), 1,
      sym_qualified_type,
    STATE(1643), 1,
      sym_implicit_length_array_type,
    ACTIONS(336), 2,
      anon_sym_new,
      anon_sym_make,
    ACTIONS(340), 2,
      sym_raw_string_literal,
      sym_rune_literal,
    STATE(1027), 2,
      sym_union_type,
      sym_negated_type,
    STATE(1632), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1034), 4,
      sym_pointer_type,
      sym_interface_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(440), 5,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
    STATE(1086), 5,
      sym_generic_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_map_type,
    ACTIONS(344), 7,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
    STATE(467), 12,
      sym_parenthesized_expression,
      sym_call_expression,
      sym_selector_expression,
      sym_index_expression,
      sym_slice_expression,
      sym_type_assertion_expression,
      sym_type_conversion_expression,
      sym_composite_literal,
      sym_func_literal,
      sym_unary_expression,
      sym_binary_expression,
      sym_interpreted_string_literal,
  [26701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 16,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_TILDE,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_CARET,
      anon_sym_AMP,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
      sym_rune_literal,
    ACTIONS(650), 34,
      anon_sym_package,
      anon_sym_import,
      anon_sym_const,
      anon_sym_var,
      anon_sym_func,
      anon_sym_type,
      anon_sym_struct,
      anon_sym_interface,
      anon_sym_map,
      anon_sym_chan,
      anon_sym_fallthrough,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_goto,
      anon_sym_return,
      anon_sym_go,
      anon_sym_defer,
      anon_sym_if,
      anon_sym_for,
      anon_sym_switch,
      anon_sym_select,
      anon_sym_new,
      anon_sym_make,
      sym_identifier,
      sym_int_literal,
      sym_float_literal,
      sym_imaginary_literal,
      sym_nil,
      sym_true,
      sym_false,
      sym_iota,
      anon_sym_templ,
      anon_sym_css,
      anon_sym_script,
  [26759] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_struct,
    ACTIONS(31), 1,
      anon_sym_TILDE,
    ACTIONS(35), 1,
      anon_sym_interface,
    ACTIONS(37), 1,
      anon_sym_map,
    ACTIONS(39), 1,
      anon_sym_chan,
    ACTIONS(330), 1,
      anon_sym_LBRACE,
    ACTIONS(652), 1,
      sym_identifier,
    ACTIONS(654), 1,
      anon_sym_DOT,
    ACTIONS(657), 1,
      anon_sym_LPAREN,
    ACTIONS(661), 1,
      anon_sym_COMMA,
    ACTIONS(664), 1,
      anon_sym_func,
    ACTIONS(666), 1,
      anon_sym_LBRACK,
    ACTIONS(669), 1,
      anon_sym_RBRACK,
    ACTIONS(672), 1,
      anon_sym_STAR,
    ACTIONS(675), 1,
      anon_sym_PIPE,
    ACTIONS(678), 1,
      anon_sym_LT_DASH,
    STATE(466), 1,
      sym_literal_value,
    STATE(643), 1,
      aux_sym_parameter_declaration_repeat1,
    STATE(1066), 1,
      sym_type_arguments,
    STATE(1397), 2,
      sym_parenthesized_type,
      sym__simple_type,
    STATE(1027), 3,
      sym_union_type,
      sym_negated_type,
      sym_qualified_type,
    ACTIONS(682), 4,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    STATE(1034), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(680), 13,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26861] = 10,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LF,
    ACTIONS(684), 1,
      anon_sym_DOT,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(690), 1,
      anon_sym_LBRACE,
    ACTIONS(692), 1,
      anon_sym_COLON,
    STATE(327), 1,
      sym_literal_value,
    STATE(1066), 1,
      sym_type_arguments,
    ACTIONS(675), 2,
      anon_sym_LPAREN,
      anon_sym_PIPE,
    ACTIONS(682), 40,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [26932] = 10,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LF,
    ACTIONS(684), 1,
      anon_sym_DOT,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(690), 1,
      anon_sym_LBRACE,
    ACTIONS(694), 1,
      anon_sym_COLON,
    STATE(327), 1,
      sym_literal_value,
    STATE(1066), 1,
      sym_type_arguments,
    ACTIONS(675), 2,
      anon_sym_LPAREN,
      anon_sym_PIPE,
    ACTIONS(682), 40,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27003] = 19,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_LF,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(704), 1,
      anon_sym_COMMA,
    ACTIONS(708), 1,
      anon_sym_LBRACK,
    ACTIONS(714), 1,
      anon_sym_LT_DASH,
    ACTIONS(716), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(718), 1,
      anon_sym_DASH_DASH,
    ACTIONS(722), 1,
      anon_sym_AMP_AMP,
    ACTIONS(724), 1,
      anon_sym_PIPE_PIPE,
    STATE(323), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1728), 1,
      sym_type_arguments,
    ACTIONS(712), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(698), 5,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
    ACTIONS(720), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(710), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(706), 13,
      anon_sym_EQ,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [27091] = 9,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LF,
    ACTIONS(684), 1,
      anon_sym_DOT,
    ACTIONS(687), 1,
      anon_sym_LBRACK,
    ACTIONS(690), 1,
      anon_sym_LBRACE,
    STATE(327), 1,
      sym_literal_value,
    STATE(1066), 1,
      sym_type_arguments,
    ACTIONS(675), 2,
      anon_sym_LPAREN,
      anon_sym_PIPE,
    ACTIONS(682), 40,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27159] = 8,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(708), 1,
      anon_sym_LBRACK,
    ACTIONS(726), 1,
      anon_sym_LF,
    STATE(323), 1,
      sym_argument_list,
    STATE(1728), 1,
      sym_type_arguments,
    ACTIONS(728), 41,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27224] = 9,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(708), 1,
      anon_sym_LBRACK,
    ACTIONS(726), 1,
      anon_sym_LF,
    STATE(323), 1,
      sym_argument_list,
    STATE(1728), 1,
      sym_type_arguments,
    ACTIONS(710), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(728), 34,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27291] = 10,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(708), 1,
      anon_sym_LBRACK,
    ACTIONS(726), 1,
      anon_sym_LF,
    STATE(323), 1,
      sym_argument_list,
    STATE(1728), 1,
      sym_type_arguments,
    ACTIONS(712), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(710), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(728), 30,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27360] = 11,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(708), 1,
      anon_sym_LBRACK,
    ACTIONS(726), 1,
      anon_sym_LF,
    STATE(323), 1,
      sym_argument_list,
    STATE(1728), 1,
      sym_type_arguments,
    ACTIONS(712), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(720), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(710), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(728), 24,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27431] = 12,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(708), 1,
      anon_sym_LBRACK,
    ACTIONS(722), 1,
      anon_sym_AMP_AMP,
    ACTIONS(726), 1,
      anon_sym_LF,
    STATE(323), 1,
      sym_argument_list,
    STATE(1728), 1,
      sym_type_arguments,
    ACTIONS(712), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(720), 6,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
    ACTIONS(710), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(728), 23,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PIPE_PIPE,
  [27504] = 8,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LPAREN,
    ACTIONS(708), 1,
      anon_sym_LBRACK,
    ACTIONS(730), 1,
      anon_sym_LF,
    STATE(323), 1,
      sym_argument_list,
    STATE(1728), 1,
      sym_type_arguments,
    ACTIONS(732), 41,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27569] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(734), 1,
      anon_sym_LF,
    ACTIONS(736), 45,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27623] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_LF,
    ACTIONS(740), 45,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27677] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(742), 1,
      anon_sym_LF,
    ACTIONS(744), 45,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_else,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27731] = 5,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LF,
    ACTIONS(746), 1,
      anon_sym_LPAREN,
    STATE(323), 1,
      sym_special_argument_list,
    ACTIONS(682), 43,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27789] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_LF,
    ACTIONS(750), 45,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_else,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27843] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(752), 1,
      anon_sym_LF,
    ACTIONS(754), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [27896] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(889), 1,
      sym_component_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [27987] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(784), 1,
      anon_sym_LF,
    ACTIONS(786), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28040] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(788), 1,
      anon_sym_LF,
    ACTIONS(790), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28093] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_LF,
    ACTIONS(794), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28146] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(796), 1,
      anon_sym_LF,
    ACTIONS(798), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28199] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(800), 1,
      anon_sym_LF,
    ACTIONS(802), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28252] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(804), 1,
      anon_sym_LF,
    ACTIONS(806), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28305] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(808), 1,
      anon_sym_LF,
    ACTIONS(810), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28358] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(812), 1,
      anon_sym_LF,
    ACTIONS(814), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28411] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(816), 1,
      anon_sym_LF,
    ACTIONS(818), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28464] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(820), 1,
      anon_sym_LF,
    ACTIONS(822), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28517] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(824), 1,
      anon_sym_LF,
    ACTIONS(826), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28570] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(828), 1,
      anon_sym_LF,
    ACTIONS(830), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28623] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(832), 1,
      anon_sym_LF,
    ACTIONS(834), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28676] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1099), 1,
      sym_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [28767] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(836), 1,
      anon_sym_LF,
    ACTIONS(838), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [28820] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(272), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(909), 1,
      sym_component_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [28911] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(33), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1169), 1,
      sym_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [29002] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(272), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(977), 1,
      sym_component_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [29093] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(840), 1,
      anon_sym_LF,
    ACTIONS(842), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29146] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(844), 1,
      anon_sym_LF,
    ACTIONS(846), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29199] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(848), 1,
      anon_sym_LF,
    ACTIONS(850), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29252] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(852), 1,
      anon_sym_LBRACE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1196), 1,
      sym_conditional_attribute_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [29343] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(854), 1,
      anon_sym_LF,
    ACTIONS(856), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29396] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(858), 1,
      anon_sym_LF,
    ACTIONS(860), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29449] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(270), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(945), 1,
      sym_component_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [29540] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(680), 1,
      anon_sym_LF,
    ACTIONS(682), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29593] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(862), 1,
      anon_sym_LF,
    ACTIONS(864), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29646] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(866), 1,
      anon_sym_LF,
    ACTIONS(868), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29699] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1560), 1,
      sym_component_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [29790] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(870), 1,
      anon_sym_LF,
    ACTIONS(872), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29843] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(874), 1,
      anon_sym_LF,
    ACTIONS(876), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29896] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(878), 1,
      anon_sym_LF,
    ACTIONS(880), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [29949] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(882), 1,
      anon_sym_LF,
    ACTIONS(884), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30002] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(886), 1,
      anon_sym_LF,
    ACTIONS(888), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30055] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(890), 1,
      anon_sym_LF,
    ACTIONS(892), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30108] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 1,
      anon_sym_LBRACE,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1361), 1,
      sym_component_block,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [30199] = 3,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(894), 1,
      anon_sym_LF,
    ACTIONS(896), 44,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_EQ,
      anon_sym_LBRACK,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_case,
      anon_sym_default,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT,
      anon_sym_LT_EQ,
      anon_sym_GT,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30252] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(898), 1,
      anon_sym_DOT,
    ACTIONS(900), 1,
      anon_sym_LBRACE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [30340] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(902), 1,
      anon_sym_LBRACE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [30428] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(904), 1,
      anon_sym_LBRACE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [30516] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_SEMI,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LT_DASH,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(906), 1,
      anon_sym_LBRACE,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [30604] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_DOT,
    ACTIONS(669), 1,
      anon_sym_LPAREN,
    ACTIONS(675), 1,
      anon_sym_PIPE,
    ACTIONS(908), 1,
      anon_sym_LBRACK,
    STATE(358), 1,
      sym_literal_value,
    STATE(1066), 1,
      sym_type_arguments,
    ACTIONS(682), 13,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30667] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    STATE(361), 1,
      sym_argument_list,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(732), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(730), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30728] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    STATE(361), 1,
      sym_argument_list,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(728), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(726), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30791] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    STATE(361), 1,
      sym_argument_list,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(728), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(726), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30856] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    STATE(361), 1,
      sym_argument_list,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(726), 20,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [30925] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    STATE(361), 1,
      sym_argument_list,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(726), 19,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_PIPE,
  [30996] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(696), 1,
      anon_sym_LBRACE,
    ACTIONS(706), 1,
      anon_sym_EQ,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 1,
      anon_sym_COMMA,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    ACTIONS(772), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(774), 1,
      anon_sym_DASH_DASH,
    ACTIONS(780), 1,
      anon_sym_AMP_AMP,
    ACTIONS(782), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(911), 1,
      anon_sym_LT_DASH,
    STATE(361), 1,
      sym_argument_list,
    STATE(864), 1,
      aux_sym_expression_list_repeat1,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(778), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(766), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(776), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(764), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(770), 12,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [31081] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(756), 1,
      anon_sym_DOT,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(762), 1,
      anon_sym_LBRACK,
    STATE(361), 1,
      sym_argument_list,
    STATE(1630), 1,
      sym_type_arguments,
    ACTIONS(728), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(726), 24,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31142] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      anon_sym_LPAREN,
    STATE(361), 1,
      sym_special_argument_list,
    ACTIONS(682), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 26,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31196] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(738), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31245] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(860), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(858), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31294] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(832), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31343] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(808), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31392] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(836), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(850), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(848), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31490] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(866), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31539] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(888), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(886), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(892), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(890), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31637] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(882), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(800), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31735] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(874), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(846), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(844), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31833] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(784), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31882] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(862), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(828), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [31980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(820), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(818), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(816), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32078] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(826), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(824), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(812), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32176] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(794), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(792), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32225] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(790), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(788), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32274] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(742), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32323] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(896), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(894), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(736), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(734), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32421] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(840), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32470] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(854), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32519] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(796), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32568] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(754), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(752), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32617] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(872), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(870), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32666] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(880), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(878), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(748), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(804), 27,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LT_DASH,
      anon_sym_COLON_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32862] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(654), 1,
      anon_sym_DOT,
    ACTIONS(669), 1,
      anon_sym_LPAREN,
    ACTIONS(675), 1,
      anon_sym_PIPE,
    ACTIONS(908), 1,
      anon_sym_LBRACK,
    ACTIONS(915), 1,
      anon_sym_LBRACE,
    STATE(395), 1,
      sym_literal_value,
    STATE(1066), 1,
      sym_type_arguments,
    ACTIONS(682), 13,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32923] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_DOT,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1671), 1,
      sym_type_arguments,
    ACTIONS(728), 7,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(923), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(726), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [32981] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_EQ,
    ACTIONS(917), 1,
      anon_sym_DOT,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1671), 1,
      sym_type_arguments,
    ACTIONS(929), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(925), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(927), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(923), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(726), 15,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33045] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_DOT,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1671), 1,
      sym_type_arguments,
    ACTIONS(732), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(730), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33101] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_DOT,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1671), 1,
      sym_type_arguments,
    ACTIONS(728), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(925), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(923), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(726), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33161] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(728), 1,
      anon_sym_EQ,
    ACTIONS(917), 1,
      anon_sym_DOT,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(931), 1,
      anon_sym_AMP_AMP,
    STATE(393), 1,
      sym_argument_list,
    STATE(1671), 1,
      sym_type_arguments,
    ACTIONS(929), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(925), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(927), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(923), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(726), 14,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_PIPE,
  [33227] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_DOT,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    STATE(393), 1,
      sym_argument_list,
    STATE(1671), 1,
      sym_type_arguments,
    ACTIONS(728), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(726), 19,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33283] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_DOT,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      anon_sym_LBRACK,
    ACTIONS(931), 1,
      anon_sym_AMP_AMP,
    ACTIONS(935), 1,
      anon_sym_EQ,
    ACTIONS(937), 1,
      anon_sym_PIPE_PIPE,
    STATE(393), 1,
      sym_argument_list,
    STATE(1671), 1,
      sym_type_arguments,
    ACTIONS(929), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(925), 4,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
    ACTIONS(927), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(923), 7,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
    ACTIONS(933), 13,
      anon_sym_COMMA,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [33351] = 19,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(939), 1,
      sym_identifier,
    ACTIONS(941), 1,
      anon_sym_LF,
    ACTIONS(945), 1,
      anon_sym_LPAREN,
    ACTIONS(947), 1,
      anon_sym_func,
    ACTIONS(949), 1,
      anon_sym_LBRACK,
    ACTIONS(951), 1,
      anon_sym_STAR,
    ACTIONS(953), 1,
      anon_sym_struct,
    ACTIONS(955), 1,
      anon_sym_TILDE,
    ACTIONS(957), 1,
      anon_sym_interface,
    ACTIONS(959), 1,
      anon_sym_map,
    ACTIONS(961), 1,
      anon_sym_chan,
    ACTIONS(963), 1,
      anon_sym_LT_DASH,
    STATE(905), 1,
      sym_parameter_list,
    STATE(908), 1,
      sym__simple_type,
    STATE(1794), 1,
      sym_parenthesized_type,
    STATE(875), 3,
      sym_union_type,
      sym_negated_type,
      sym_qualified_type,
    STATE(926), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(943), 10,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
  [33428] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 1,
      anon_sym_LPAREN,
    STATE(393), 1,
      sym_special_argument_list,
    ACTIONS(682), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(680), 21,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33477] = 25,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(953), 1,
      anon_sym_struct,
    ACTIONS(955), 1,
      anon_sym_TILDE,
    ACTIONS(957), 1,
      anon_sym_interface,
    ACTIONS(967), 1,
      sym_identifier,
    ACTIONS(969), 1,
      anon_sym_LF,
    ACTIONS(973), 1,
      anon_sym_DOT,
    ACTIONS(975), 1,
      anon_sym_LPAREN,
    ACTIONS(977), 1,
      anon_sym_COMMA,
    ACTIONS(979), 1,
      anon_sym_func,
    ACTIONS(981), 1,
      anon_sym_LBRACK,
    ACTIONS(983), 1,
      anon_sym_STAR,
    ACTIONS(985), 1,
      anon_sym_PIPE,
    ACTIONS(987), 1,
      anon_sym_map,
    ACTIONS(989), 1,
      anon_sym_chan,
    ACTIONS(991), 1,
      anon_sym_LT_DASH,
    ACTIONS(993), 1,
      sym_raw_string_literal,
    ACTIONS(995), 1,
      anon_sym_DQUOTE,
    STATE(650), 1,
      aux_sym_field_declaration_repeat1,
    STATE(919), 1,
      sym_type_arguments,
    STATE(1382), 1,
      sym_interpreted_string_literal,
    STATE(1081), 2,
      sym_parenthesized_type,
      sym__simple_type,
    ACTIONS(971), 3,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_RBRACE,
    STATE(877), 3,
      sym_union_type,
      sym_negated_type,
      sym_qualified_type,
    STATE(926), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
  [33566] = 19,
    ACTIONS(318), 1,
      sym_comment,
    ACTIONS(941), 1,
      anon_sym_LF,
    ACTIONS(945), 1,
      anon_sym_LPAREN,
    ACTIONS(953), 1,
      anon_sym_struct,
    ACTIONS(955), 1,
      anon_sym_TILDE,
    ACTIONS(957), 1,
      anon_sym_interface,
    ACTIONS(967), 1,
      sym_identifier,
    ACTIONS(979), 1,
      anon_sym_func,
    ACTIONS(983), 1,
      anon_sym_STAR,
    ACTIONS(987), 1,
      anon_sym_map,
    ACTIONS(989), 1,
      anon_sym_chan,
    ACTIONS(991), 1,
      anon_sym_LT_DASH,
    ACTIONS(997), 1,
      anon_sym_LBRACK,
    STATE(905), 1,
      sym_parameter_list,
    STATE(908), 1,
      sym__simple_type,
    STATE(1794), 1,
      sym_parenthesized_type,
    STATE(877), 3,
      sym_union_type,
      sym_negated_type,
      sym_qualified_type,
    STATE(926), 9,
      sym_generic_type,
      sym_pointer_type,
      sym_array_type,
      sym_slice_type,
      sym_struct_type,
      sym_interface_type,
      sym_map_type,
      sym_channel_type,
      sym_function_type,
    ACTIONS(943), 10,
      anon_sym_SEMI,
      anon_sym_NULL,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
      sym_raw_string_literal,
      anon_sym_DQUOTE,
  [33643] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(864), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(862), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(830), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(828), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(876), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(874), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33775] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(868), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(866), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33819] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(814), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(812), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33863] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(808), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33907] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(784), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(838), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(836), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [33995] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(740), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(738), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(884), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(882), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34083] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(842), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(840), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34127] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(834), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_AMP_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(832), 22,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_COLON_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_AMP_CARET_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
  [34171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 14,
      anon_sym_EQ,
      anon_sym_STAR,
      anon_sym_PIPE,
  