#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 269
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 110
#define ALIAS_COUNT 0
#define TOKEN_COUNT 46
#define EXTERNAL_TOKEN_COUNT 16
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 1

enum ts_symbol_identifiers {
  aux_sym_block_comment_token1 = 1,
  aux_sym_block_comment_token2 = 2,
  aux_sym_knot_header_token1 = 3,
  aux_sym_gather_mark_token1 = 4,
  sym_option_mark = 5,
  aux_sym_label_token1 = 6,
  aux_sym_label_token2 = 7,
  aux_sym_code_text_token1 = 8,
  aux_sym_list_token1 = 9,
  sym_hide_start = 10,
  sym_hide_end = 11,
  aux_sym_condition_block_token1 = 12,
  aux_sym_condition_block_token2 = 13,
  aux_sym_tag_token1 = 14,
  sym_tag_remainder = 15,
  sym_tag_delimiter = 16,
  sym_boolean = 17,
  anon_sym_DQUOTE = 18,
  aux_sym_string_token1 = 19,
  aux_sym_string_token2 = 20,
  sym_ref = 21,
  sym_number = 22,
  sym_assignment = 23,
  sym_dot = 24,
  sym_block_remainder = 25,
  sym_vocabulary = 26,
  sym_identifier = 27,
  aux_sym_other_token1 = 28,
  aux_sym_word_other_token1 = 29,
  sym_arrow = 30,
  sym_double_arrow = 31,
  sym_back_arrow = 32,
  sym_block_comment_start = 33,
  sym_block_comment_end = 34,
  sym_line_comment = 35,
  sym_glue = 36,
  sym_line_start = 37,
  sym_stitch_start = 38,
  sym_knot_start = 39,
  sym_function_start = 40,
  sym_var_start = 41,
  sym_const_start = 42,
  sym_list_start = 43,
  sym_empty_line = 44,
  sym_line_end = 45,
  sym_program = 46,
  sym_block_comment = 47,
  sym_knot = 48,
  sym_knot_header = 49,
  sym_stitch = 50,
  sym_stitch_header = 51,
  sym_weave_body = 52,
  sym_weave_body_line = 53,
  sym_function = 54,
  sym_gather_text = 55,
  sym_gather_mark = 56,
  sym_option_text = 57,
  sym_option_words = 58,
  sym_default_option_mark = 59,
  sym_divert_or_thread = 60,
  sym_label = 61,
  sym_code_text = 62,
  sym_var_line = 63,
  sym_const_line = 64,
  sym_list_line = 65,
  sym_list = 66,
  sym_marked_identifier = 67,
  sym_mark_start = 68,
  sym_mark_end = 69,
  sym_dialog_text = 70,
  sym_text = 71,
  sym_words = 72,
  sym_divert_chain = 73,
  sym_divert = 74,
  sym_divert_continue = 75,
  sym_divert_return = 76,
  sym_thread = 77,
  sym_function_header = 78,
  sym_arguments = 79,
  sym_argument = 80,
  sym_condition_text = 81,
  sym_condition_block = 82,
  sym_condition_block_content = 83,
  sym_condition_block_nested = 84,
  sym_inline_block = 85,
  sym_identifier_path = 86,
  sym_tag = 87,
  sym_value = 88,
  sym_string = 89,
  sym_other = 90,
  sym_word_other = 91,
  aux_sym_program_repeat1 = 92,
  aux_sym_block_comment_repeat1 = 93,
  aux_sym_knot_repeat1 = 94,
  aux_sym_weave_body_repeat1 = 95,
  aux_sym_gather_mark_repeat1 = 96,
  aux_sym_option_text_repeat1 = 97,
  aux_sym_list_repeat1 = 98,
  aux_sym_text_repeat1 = 99,
  aux_sym_words_repeat1 = 100,
  aux_sym_divert_chain_repeat1 = 101,
  aux_sym_arguments_repeat1 = 102,
  aux_sym_condition_block_repeat1 = 103,
  aux_sym_condition_block_content_repeat1 = 104,
  aux_sym_inline_block_repeat1 = 105,
  aux_sym_identifier_path_repeat1 = 106,
  aux_sym_string_repeat1 = 107,
  aux_sym_other_repeat1 = 108,
  aux_sym_word_other_repeat1 = 109,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [aux_sym_block_comment_token1] = "block_comment_token1",
  [aux_sym_block_comment_token2] = "block_comment_token2",
  [aux_sym_knot_header_token1] = "knot_header_token1",
  [aux_sym_gather_mark_token1] = "gather_mark_token1",
  [sym_option_mark] = "option_mark",
  [aux_sym_label_token1] = "label_token1",
  [aux_sym_label_token2] = "label_token2",
  [aux_sym_code_text_token1] = "code_text_token1",
  [aux_sym_list_token1] = "list_token1",
  [sym_hide_start] = "hide_start",
  [sym_hide_end] = "hide_end",
  [aux_sym_condition_block_token1] = "condition_block_token1",
  [aux_sym_condition_block_token2] = "condition_block_token2",
  [aux_sym_tag_token1] = "tag_token1",
  [sym_tag_remainder] = "tag_remainder",
  [sym_tag_delimiter] = "tag_delimiter",
  [sym_boolean] = "boolean",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [aux_sym_string_token2] = "string_token2",
  [sym_ref] = "ref",
  [sym_number] = "number",
  [sym_assignment] = "assignment",
  [sym_dot] = "dot",
  [sym_block_remainder] = "block_remainder",
  [sym_vocabulary] = "vocabulary",
  [sym_identifier] = "identifier",
  [aux_sym_other_token1] = "other_token1",
  [aux_sym_word_other_token1] = "word_other_token1",
  [sym_arrow] = "arrow",
  [sym_double_arrow] = "double_arrow",
  [sym_back_arrow] = "back_arrow",
  [sym_block_comment_start] = "block_comment_start",
  [sym_block_comment_end] = "block_comment_end",
  [sym_line_comment] = "line_comment",
  [sym_glue] = "glue",
  [sym_line_start] = "line_start",
  [sym_stitch_start] = "stitch_start",
  [sym_knot_start] = "knot_start",
  [sym_function_start] = "function_start",
  [sym_var_start] = "var_start",
  [sym_const_start] = "const_start",
  [sym_list_start] = "list_start",
  [sym_empty_line] = "",
  [sym_line_end] = "line_end",
  [sym_program] = "program",
  [sym_block_comment] = "block_comment",
  [sym_knot] = "knot",
  [sym_knot_header] = "knot_header",
  [sym_stitch] = "stitch",
  [sym_stitch_header] = "stitch_header",
  [sym_weave_body] = "weave_body",
  [sym_weave_body_line] = "weave_body_line",
  [sym_function] = "function",
  [sym_gather_text] = "gather_text",
  [sym_gather_mark] = "gather_mark",
  [sym_option_text] = "option_text",
  [sym_option_words] = "option_words",
  [sym_default_option_mark] = "default_option_mark",
  [sym_divert_or_thread] = "divert_or_thread",
  [sym_label] = "label",
  [sym_code_text] = "code_text",
  [sym_var_line] = "var_line",
  [sym_const_line] = "const_line",
  [sym_list_line] = "list_line",
  [sym_list] = "list",
  [sym_marked_identifier] = "marked_identifier",
  [sym_mark_start] = "mark_start",
  [sym_mark_end] = "mark_end",
  [sym_dialog_text] = "dialog_text",
  [sym_text] = "text",
  [sym_words] = "words",
  [sym_divert_chain] = "divert_chain",
  [sym_divert] = "divert",
  [sym_divert_continue] = "divert_continue",
  [sym_divert_return] = "divert_return",
  [sym_thread] = "thread",
  [sym_function_header] = "function_header",
  [sym_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_condition_text] = "condition_text",
  [sym_condition_block] = "condition_block",
  [sym_condition_block_content] = "condition_block_content",
  [sym_condition_block_nested] = "condition_block",
  [sym_inline_block] = "inline_block",
  [sym_identifier_path] = "identifier_path",
  [sym_tag] = "tag",
  [sym_value] = "value",
  [sym_string] = "string",
  [sym_other] = "other",
  [sym_word_other] = "word_other",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym_block_comment_repeat1] = "block_comment_repeat1",
  [aux_sym_knot_repeat1] = "knot_repeat1",
  [aux_sym_weave_body_repeat1] = "weave_body_repeat1",
  [aux_sym_gather_mark_repeat1] = "gather_mark_repeat1",
  [aux_sym_option_text_repeat1] = "option_text_repeat1",
  [aux_sym_list_repeat1] = "list_repeat1",
  [aux_sym_text_repeat1] = "text_repeat1",
  [aux_sym_words_repeat1] = "words_repeat1",
  [aux_sym_divert_chain_repeat1] = "divert_chain_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [aux_sym_condition_block_repeat1] = "condition_block_repeat1",
  [aux_sym_condition_block_content_repeat1] = "condition_block_content_repeat1",
  [aux_sym_inline_block_repeat1] = "inline_block_repeat1",
  [aux_sym_identifier_path_repeat1] = "identifier_path_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_other_repeat1] = "other_repeat1",
  [aux_sym_word_other_repeat1] = "word_other_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [aux_sym_block_comment_token1] = aux_sym_block_comment_token1,
  [aux_sym_block_comment_token2] = aux_sym_block_comment_token2,
  [aux_sym_knot_header_token1] = aux_sym_knot_header_token1,
  [aux_sym_gather_mark_token1] = aux_sym_gather_mark_token1,
  [sym_option_mark] = sym_option_mark,
  [aux_sym_label_token1] = aux_sym_label_token1,
  [aux_sym_label_token2] = aux_sym_label_token2,
  [aux_sym_code_text_token1] = aux_sym_code_text_token1,
  [aux_sym_list_token1] = aux_sym_list_token1,
  [sym_hide_start] = sym_hide_start,
  [sym_hide_end] = sym_hide_end,
  [aux_sym_condition_block_token1] = aux_sym_condition_block_token1,
  [aux_sym_condition_block_token2] = aux_sym_condition_block_token2,
  [aux_sym_tag_token1] = aux_sym_tag_token1,
  [sym_tag_remainder] = sym_tag_remainder,
  [sym_tag_delimiter] = sym_tag_delimiter,
  [sym_boolean] = sym_boolean,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [sym_ref] = sym_ref,
  [sym_number] = sym_number,
  [sym_assignment] = sym_assignment,
  [sym_dot] = sym_dot,
  [sym_block_remainder] = sym_block_remainder,
  [sym_vocabulary] = sym_vocabulary,
  [sym_identifier] = sym_identifier,
  [aux_sym_other_token1] = aux_sym_other_token1,
  [aux_sym_word_other_token1] = aux_sym_word_other_token1,
  [sym_arrow] = sym_arrow,
  [sym_double_arrow] = sym_double_arrow,
  [sym_back_arrow] = sym_back_arrow,
  [sym_block_comment_start] = sym_block_comment_start,
  [sym_block_comment_end] = sym_block_comment_end,
  [sym_line_comment] = sym_line_comment,
  [sym_glue] = sym_glue,
  [sym_line_start] = sym_line_start,
  [sym_stitch_start] = sym_stitch_start,
  [sym_knot_start] = sym_knot_start,
  [sym_function_start] = sym_function_start,
  [sym_var_start] = sym_var_start,
  [sym_const_start] = sym_const_start,
  [sym_list_start] = sym_list_start,
  [sym_empty_line] = sym_empty_line,
  [sym_line_end] = sym_line_end,
  [sym_program] = sym_program,
  [sym_block_comment] = sym_block_comment,
  [sym_knot] = sym_knot,
  [sym_knot_header] = sym_knot_header,
  [sym_stitch] = sym_stitch,
  [sym_stitch_header] = sym_stitch_header,
  [sym_weave_body] = sym_weave_body,
  [sym_weave_body_line] = sym_weave_body_line,
  [sym_function] = sym_function,
  [sym_gather_text] = sym_gather_text,
  [sym_gather_mark] = sym_gather_mark,
  [sym_option_text] = sym_option_text,
  [sym_option_words] = sym_option_words,
  [sym_default_option_mark] = sym_default_option_mark,
  [sym_divert_or_thread] = sym_divert_or_thread,
  [sym_label] = sym_label,
  [sym_code_text] = sym_code_text,
  [sym_var_line] = sym_var_line,
  [sym_const_line] = sym_const_line,
  [sym_list_line] = sym_list_line,
  [sym_list] = sym_list,
  [sym_marked_identifier] = sym_marked_identifier,
  [sym_mark_start] = sym_mark_start,
  [sym_mark_end] = sym_mark_end,
  [sym_dialog_text] = sym_dialog_text,
  [sym_text] = sym_text,
  [sym_words] = sym_words,
  [sym_divert_chain] = sym_divert_chain,
  [sym_divert] = sym_divert,
  [sym_divert_continue] = sym_divert_continue,
  [sym_divert_return] = sym_divert_return,
  [sym_thread] = sym_thread,
  [sym_function_header] = sym_function_header,
  [sym_arguments] = sym_arguments,
  [sym_argument] = sym_argument,
  [sym_condition_text] = sym_condition_text,
  [sym_condition_block] = sym_condition_block,
  [sym_condition_block_content] = sym_condition_block_content,
  [sym_condition_block_nested] = sym_condition_block,
  [sym_inline_block] = sym_inline_block,
  [sym_identifier_path] = sym_identifier_path,
  [sym_tag] = sym_tag,
  [sym_value] = sym_value,
  [sym_string] = sym_string,
  [sym_other] = sym_other,
  [sym_word_other] = sym_word_other,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym_block_comment_repeat1] = aux_sym_block_comment_repeat1,
  [aux_sym_knot_repeat1] = aux_sym_knot_repeat1,
  [aux_sym_weave_body_repeat1] = aux_sym_weave_body_repeat1,
  [aux_sym_gather_mark_repeat1] = aux_sym_gather_mark_repeat1,
  [aux_sym_option_text_repeat1] = aux_sym_option_text_repeat1,
  [aux_sym_list_repeat1] = aux_sym_list_repeat1,
  [aux_sym_text_repeat1] = aux_sym_text_repeat1,
  [aux_sym_words_repeat1] = aux_sym_words_repeat1,
  [aux_sym_divert_chain_repeat1] = aux_sym_divert_chain_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [aux_sym_condition_block_repeat1] = aux_sym_condition_block_repeat1,
  [aux_sym_condition_block_content_repeat1] = aux_sym_condition_block_content_repeat1,
  [aux_sym_inline_block_repeat1] = aux_sym_inline_block_repeat1,
  [aux_sym_identifier_path_repeat1] = aux_sym_identifier_path_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_other_repeat1] = aux_sym_other_repeat1,
  [aux_sym_word_other_repeat1] = aux_sym_word_other_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_block_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_knot_header_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gather_mark_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_option_mark] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_label_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_label_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_code_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_hide_start] = {
    .visible = true,
    .named = true,
  },
  [sym_hide_end] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_condition_block_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_condition_block_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tag_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_tag_remainder] = {
    .visible = true,
    .named = true,
  },
  [sym_tag_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_dot] = {
    .visible = true,
    .named = true,
  },
  [sym_block_remainder] = {
    .visible = true,
    .named = true,
  },
  [sym_vocabulary] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_other_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_word_other_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_double_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_back_arrow] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment_start] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment_end] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_glue] = {
    .visible = true,
    .named = true,
  },
  [sym_line_start] = {
    .visible = true,
    .named = true,
  },
  [sym_stitch_start] = {
    .visible = true,
    .named = true,
  },
  [sym_knot_start] = {
    .visible = true,
    .named = true,
  },
  [sym_function_start] = {
    .visible = true,
    .named = true,
  },
  [sym_var_start] = {
    .visible = true,
    .named = true,
  },
  [sym_const_start] = {
    .visible = true,
    .named = true,
  },
  [sym_list_start] = {
    .visible = true,
    .named = true,
  },
  [sym_empty_line] = {
    .visible = true,
    .named = false,
  },
  [sym_line_end] = {
    .visible = true,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_knot] = {
    .visible = true,
    .named = true,
  },
  [sym_knot_header] = {
    .visible = true,
    .named = true,
  },
  [sym_stitch] = {
    .visible = true,
    .named = true,
  },
  [sym_stitch_header] = {
    .visible = true,
    .named = true,
  },
  [sym_weave_body] = {
    .visible = true,
    .named = true,
  },
  [sym_weave_body_line] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_gather_text] = {
    .visible = true,
    .named = true,
  },
  [sym_gather_mark] = {
    .visible = true,
    .named = true,
  },
  [sym_option_text] = {
    .visible = true,
    .named = true,
  },
  [sym_option_words] = {
    .visible = true,
    .named = true,
  },
  [sym_default_option_mark] = {
    .visible = true,
    .named = true,
  },
  [sym_divert_or_thread] = {
    .visible = true,
    .named = true,
  },
  [sym_label] = {
    .visible = true,
    .named = true,
  },
  [sym_code_text] = {
    .visible = true,
    .named = true,
  },
  [sym_var_line] = {
    .visible = true,
    .named = true,
  },
  [sym_const_line] = {
    .visible = true,
    .named = true,
  },
  [sym_list_line] = {
    .visible = true,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym_marked_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_mark_start] = {
    .visible = true,
    .named = true,
  },
  [sym_mark_end] = {
    .visible = true,
    .named = true,
  },
  [sym_dialog_text] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym_words] = {
    .visible = true,
    .named = true,
  },
  [sym_divert_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_divert] = {
    .visible = true,
    .named = true,
  },
  [sym_divert_continue] = {
    .visible = true,
    .named = true,
  },
  [sym_divert_return] = {
    .visible = true,
    .named = true,
  },
  [sym_thread] = {
    .visible = true,
    .named = true,
  },
  [sym_function_header] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_text] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_block] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_block_content] = {
    .visible = true,
    .named = true,
  },
  [sym_condition_block_nested] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_block] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_path] = {
    .visible = true,
    .named = true,
  },
  [sym_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_other] = {
    .visible = true,
    .named = true,
  },
  [sym_word_other] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_comment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_knot_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_weave_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_gather_mark_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_option_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_words_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_divert_chain_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_condition_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_condition_block_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_identifier_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_other_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_word_other_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 13,
  [19] = 14,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 30,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 36,
  [46] = 46,
  [47] = 47,
  [48] = 40,
  [49] = 34,
  [50] = 50,
  [51] = 51,
  [52] = 39,
  [53] = 53,
  [54] = 54,
  [55] = 16,
  [56] = 56,
  [57] = 20,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 35,
  [62] = 44,
  [63] = 60,
  [64] = 53,
  [65] = 58,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 59,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 54,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 56,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 93,
  [97] = 29,
  [98] = 33,
  [99] = 99,
  [100] = 95,
  [101] = 101,
  [102] = 35,
  [103] = 103,
  [104] = 104,
  [105] = 42,
  [106] = 36,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 41,
  [115] = 115,
  [116] = 107,
  [117] = 113,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 107,
  [122] = 113,
  [123] = 107,
  [124] = 113,
  [125] = 113,
  [126] = 126,
  [127] = 127,
  [128] = 103,
  [129] = 36,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 35,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 126,
  [158] = 101,
  [159] = 112,
  [160] = 120,
  [161] = 161,
  [162] = 162,
  [163] = 109,
  [164] = 118,
  [165] = 165,
  [166] = 166,
  [167] = 35,
  [168] = 36,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 134,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 175,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 174,
  [197] = 194,
  [198] = 195,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 221,
  [242] = 214,
  [243] = 243,
  [244] = 203,
  [245] = 236,
  [246] = 239,
  [247] = 243,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 232,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 209,
  [260] = 210,
  [261] = 212,
  [262] = 226,
  [263] = 230,
  [264] = 231,
  [265] = 240,
  [266] = 266,
  [267] = 267,
  [268] = 268,
};

static TSCharacterRange extras_character_set_1[] = {
  {'\t', '\t'}, {0x0b, '\f'}, {' ', ' '}, {0xa0, 0xa0}, {0x1680, 0x1680}, {0x2000, 0x200a}, {0x2028, 0x2029}, {0x202f, 0x202f},
  {0x205f, 0x205f}, {0x3000, 0x3000},
};

static TSCharacterRange sym_vocabulary_character_set_1[] = {
  {'-', '-'}, {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb2, 0xb3}, {0xb5, 0xb5},
  {0xb9, 0xba}, {0xbc, 0xbe}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec},
  {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37a, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c},
  {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea},
  {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x660, 0x669}, {0x66e, 0x66f}, {0x671, 0x6d3}, {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6fc},
  {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5}, {0x7b1, 0x7b1}, {0x7c0, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa},
  {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828}, {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e},
  {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950}, {0x958, 0x961}, {0x966, 0x96f}, {0x971, 0x980}, {0x985, 0x98c},
  {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd},
  {0x9df, 0x9e1}, {0x9e6, 0x9f1}, {0x9f4, 0x9f9}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30},
  {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa6f}, {0xa72, 0xa74}, {0xa85, 0xa8d},
  {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0}, {0xae0, 0xae1},
  {0xae6, 0xaef}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb66, 0xb6f}, {0xb71, 0xb77}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0},
  {0xbe6, 0xbf2}, {0xc05, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d},
  {0xc60, 0xc61}, {0xc66, 0xc6f}, {0xc78, 0xc7e}, {0xc80, 0xc80}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3},
  {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1}, {0xce6, 0xcef}, {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10},
  {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd58, 0xd61}, {0xd66, 0xd78}, {0xd7a, 0xd7f}, {0xd85, 0xd96},
  {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xde6, 0xdef}, {0xe01, 0xe30}, {0xe32, 0xe33}, {0xe40, 0xe46},
  {0xe50, 0xe59}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb3},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf20, 0xf33}, {0xf40, 0xf47},
  {0xf49, 0xf6c}, {0xf88, 0xf8c}, {0x1000, 0x102a}, {0x103f, 0x1049}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066},
  {0x106e, 0x1070}, {0x1075, 0x1081}, {0x108e, 0x108e}, {0x1090, 0x1099}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa},
  {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0},
  {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a},
  {0x1369, 0x137c}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea},
  {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7},
  {0x17dc, 0x17dc}, {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x1810, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x1884}, {0x1887, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a16},
  {0x1a20, 0x1a54}, {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b83, 0x1ba0},
  {0x1bae, 0x1be5}, {0x1c00, 0x1c23}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec},
  {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d},
  {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe},
  {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2070, 0x2071},
  {0x2074, 0x2079}, {0x207f, 0x2089}, {0x2090, 0x209c}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2119, 0x211d},
  {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e},
  {0x2150, 0x2189}, {0x2460, 0x249b}, {0x24ea, 0x24ff}, {0x2776, 0x2793}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2cfd, 0x2cfd},
  {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae},
  {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2e2f, 0x2e2f}, {0x3005, 0x3007},
  {0x3021, 0x3029}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f},
  {0x3131, 0x318e}, {0x3192, 0x3195}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3220, 0x3229}, {0x3248, 0x324f}, {0x3251, 0x325f}, {0x3280, 0x3289},
  {0x32b1, 0x32bf}, {0x3400, 0x3400}, {0x4dbf, 0x4dbf}, {0x4e00, 0x4e00}, {0x9fff, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b},
  {0xa640, 0xa66e}, {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3},
  {0xa7d5, 0xa7d9}, {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa830, 0xa835}, {0xa840, 0xa873}, {0xa882, 0xa8b3},
  {0xa8d0, 0xa8d9}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa8fe}, {0xa900, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76},
  {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xabf0, 0xabf9}, {0xac00, 0xac00}, {0xd7a3, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e},
  {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74},
  {0xfe76, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7},
  {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa},
  {0x10107, 0x10133}, {0x10140, 0x10178}, {0x1018a, 0x1018b}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e1, 0x102fb}, {0x10300, 0x10323}, {0x1032d, 0x1034a},
  {0x10350, 0x10375}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3},
  {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1},
  {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0},
  {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10858, 0x10876},
  {0x10879, 0x1089e}, {0x108a7, 0x108af}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x108fb, 0x1091b},
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb2, 0xb3}, {0xb5, 0xb5}, {0xb9, 0xba},
  {0xbc, 0xbe}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee},
  {0x370, 0x374}, {0x376, 0x377}, {0x37a, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1},
  {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2},
  {0x620, 0x64a}, {0x660, 0x669}, {0x66e, 0x66f}, {0x671, 0x6d3}, {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6fc}, {0x6ff, 0x6ff},
  {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5}, {0x7b1, 0x7b1}, {0x7c0, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815},
  {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828}, {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9},
  {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950}, {0x958, 0x961}, {0x966, 0x96f}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990},
  {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1},
  {0x9e6, 0x9f1}, {0x9f4, 0x9f9}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33},
  {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa6f}, {0xa72, 0xa74}, {0xa85, 0xa8d}, {0xa8f, 0xa91},
  {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0}, {0xae0, 0xae1}, {0xae6, 0xaef},
  {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3d, 0xb3d},
  {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb66, 0xb6f}, {0xb71, 0xb77}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xbe6, 0xbf2},
  {0xc05, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61},
  {0xc66, 0xc6f}, {0xc78, 0xc7e}, {0xc80, 0xc80}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9},
  {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1}, {0xce6, 0xcef}, {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a},
  {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd58, 0xd61}, {0xd66, 0xd78}, {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1},
  {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xde6, 0xdef}, {0xe01, 0xe30}, {0xe32, 0xe33}, {0xe40, 0xe46}, {0xe50, 0xe59},
  {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb3}, {0xebd, 0xebd},
  {0xec0, 0xec4}, {0xec6, 0xec6}, {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf20, 0xf33}, {0xf40, 0xf47}, {0xf49, 0xf6c},
  {0xf88, 0xf8c}, {0x1000, 0x102a}, {0x103f, 0x1049}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070},
  {0x1075, 0x1081}, {0x108e, 0x108e}, {0x1090, 0x1099}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248},
  {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5},
  {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1369, 0x137c},
  {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8},
  {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc},
  {0x17e0, 0x17e9}, {0x17f0, 0x17f9}, {0x1810, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x1884}, {0x1887, 0x18a8}, {0x18aa, 0x18aa}, {0x18b0, 0x18f5},
  {0x1900, 0x191e}, {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b83, 0x1ba0}, {0x1bae, 0x1be5},
  {0x1c00, 0x1c23}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3},
  {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa}, {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57},
  {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4},
  {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2070, 0x2071}, {0x2074, 0x2079},
  {0x207f, 0x2089}, {0x2090, 0x209c}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2119, 0x211d}, {0x2124, 0x2124},
  {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2150, 0x2189},
  {0x2460, 0x249b}, {0x24ea, 0x24ff}, {0x2776, 0x2793}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2cfd, 0x2cfd}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2e2f, 0x2e2f}, {0x3005, 0x3007}, {0x3021, 0x3029},
  {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e},
  {0x3192, 0x3195}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3220, 0x3229}, {0x3248, 0x324f}, {0x3251, 0x325f}, {0x3280, 0x3289}, {0x32b1, 0x32bf},
  {0x3400, 0x3400}, {0x4dbf, 0x4dbf}, {0x4e00, 0x4e00}, {0x9fff, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa830, 0xa835}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8d0, 0xa8d9},
  {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa8fe}, {0xa900, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9d9},
  {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a},
  {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1}, {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea},
  {0xaaf2, 0xaaf4}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69},
  {0xab70, 0xabe2}, {0xabf0, 0xabf9}, {0xac00, 0xac00}, {0xd7a3, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9},
  {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdfb}, {0xfe70, 0xfe74}, {0xfe76, 0xfefc},
  {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc},
  {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10107, 0x10133},
  {0x10140, 0x10178}, {0x1018a, 0x1018b}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e1, 0x102fb}, {0x10300, 0x10323}, {0x1032d, 0x1034a}, {0x10350, 0x10375},
  {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb},
  {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1},
  {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba},
  {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10858, 0x10876}, {0x10879, 0x1089e},
  {0x108a7, 0x108af}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x108fb, 0x1091b},
};

static TSCharacterRange aux_sym_other_token1_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '/'}, {':', '@'}, {'[', '^'}, {'`', '`'}, {'{', 0xa9}, {0xab, 0xb1},
  {0xb4, 0xb4}, {0xb6, 0xb8}, {0xbb, 0xbb}, {0xbf, 0xbf}, {0xd7, 0xd7}, {0xf7, 0xf7}, {0x2c2, 0x2c5}, {0x2d2, 0x2df},
  {0x2e5, 0x2eb}, {0x2ed, 0x2ed}, {0x2ef, 0x36f}, {0x375, 0x375}, {0x378, 0x379}, {0x37e, 0x37e}, {0x380, 0x385}, {0x387, 0x387},
  {0x38b, 0x38b}, {0x38d, 0x38d}, {0x3a2, 0x3a2}, {0x3f6, 0x3f6}, {0x482, 0x489}, {0x530, 0x530}, {0x557, 0x558}, {0x55a, 0x55f},
  {0x589, 0x5cf}, {0x5eb, 0x5ee}, {0x5f3, 0x61f}, {0x64b, 0x65f}, {0x66a, 0x66d}, {0x670, 0x670}, {0x6d4, 0x6d4}, {0x6d6, 0x6e4},
  {0x6e7, 0x6ed}, {0x6fd, 0x6fe}, {0x700, 0x70f}, {0x711, 0x711}, {0x730, 0x74c}, {0x7a6, 0x7b0}, {0x7b2, 0x7bf}, {0x7eb, 0x7f3},
  {0x7f6, 0x7f9}, {0x7fb, 0x7ff}, {0x816, 0x819}, {0x81b, 0x823}, {0x825, 0x827}, {0x829, 0x83f}, {0x859, 0x85f}, {0x86b, 0x86f},
  {0x888, 0x888}, {0x88f, 0x89f}, {0x8ca, 0x903}, {0x93a, 0x93c}, {0x93e, 0x94f}, {0x951, 0x957}, {0x962, 0x965}, {0x970, 0x970},
  {0x981, 0x984}, {0x98d, 0x98e}, {0x991, 0x992}, {0x9a9, 0x9a9}, {0x9b1, 0x9b1}, {0x9b3, 0x9b5}, {0x9ba, 0x9bc}, {0x9be, 0x9cd},
  {0x9cf, 0x9db}, {0x9de, 0x9de}, {0x9e2, 0x9e5}, {0x9f2, 0x9f3}, {0x9fa, 0x9fb}, {0x9fd, 0xa04}, {0xa0b, 0xa0e}, {0xa11, 0xa12},
  {0xa29, 0xa29}, {0xa31, 0xa31}, {0xa34, 0xa34}, {0xa37, 0xa37}, {0xa3a, 0xa58}, {0xa5d, 0xa5d}, {0xa5f, 0xa65}, {0xa70, 0xa71},
  {0xa75, 0xa84}, {0xa8e, 0xa8e}, {0xa92, 0xa92}, {0xaa9, 0xaa9}, {0xab1, 0xab1}, {0xab4, 0xab4}, {0xaba, 0xabc}, {0xabe, 0xacf},
  {0xad1, 0xadf}, {0xae2, 0xae5}, {0xaf0, 0xaf8}, {0xafa, 0xb04}, {0xb0d, 0xb0e}, {0xb11, 0xb12}, {0xb29, 0xb29}, {0xb31, 0xb31},
  {0xb34, 0xb34}, {0xb3a, 0xb3c}, {0xb3e, 0xb5b}, {0xb5e, 0xb5e}, {0xb62, 0xb65}, {0xb70, 0xb70}, {0xb78, 0xb82}, {0xb84, 0xb84},
  {0xb8b, 0xb8d}, {0xb91, 0xb91}, {0xb96, 0xb98}, {0xb9b, 0xb9b}, {0xb9d, 0xb9d}, {0xba0, 0xba2}, {0xba5, 0xba7}, {0xbab, 0xbad},
  {0xbba, 0xbcf}, {0xbd1, 0xbe5}, {0xbf3, 0xc04}, {0xc0d, 0xc0d}, {0xc11, 0xc11}, {0xc29, 0xc29}, {0xc3a, 0xc3c}, {0xc3e, 0xc57},
  {0xc5b, 0xc5c}, {0xc5e, 0xc5f}, {0xc62, 0xc65}, {0xc70, 0xc77}, {0xc7f, 0xc7f}, {0xc81, 0xc84}, {0xc8d, 0xc8d}, {0xc91, 0xc91},
  {0xca9, 0xca9}, {0xcb4, 0xcb4}, {0xcba, 0xcbc}, {0xcbe, 0xcdc}, {0xcdf, 0xcdf}, {0xce2, 0xce5}, {0xcf0, 0xcf0}, {0xcf3, 0xd03},
  {0xd0d, 0xd0d}, {0xd11, 0xd11}, {0xd3b, 0xd3c}, {0xd3e, 0xd4d}, {0xd4f, 0xd53}, {0xd57, 0xd57}, {0xd62, 0xd65}, {0xd79, 0xd79},
  {0xd80, 0xd84}, {0xd97, 0xd99}, {0xdb2, 0xdb2}, {0xdbc, 0xdbc}, {0xdbe, 0xdbf}, {0xdc7, 0xde5}, {0xdf0, 0xe00}, {0xe31, 0xe31},
  {0xe34, 0xe3f}, {0xe47, 0xe4f}, {0xe5a, 0xe80}, {0xe83, 0xe83}, {0xe85, 0xe85}, {0xe8b, 0xe8b}, {0xea4, 0xea4}, {0xea6, 0xea6},
  {0xeb1, 0xeb1}, {0xeb4, 0xebc}, {0xebe, 0xebf}, {0xec5, 0xec5}, {0xec7, 0xecf}, {0xeda, 0xedb}, {0xee0, 0xeff}, {0xf01, 0xf1f},
  {0xf34, 0xf3f}, {0xf48, 0xf48}, {0xf6d, 0xf87}, {0xf8d, 0xfff}, {0x102b, 0x103e}, {0x104a, 0x104f}, {0x1056, 0x1059}, {0x105e, 0x1060},
  {0x1062, 0x1064}, {0x1067, 0x106d}, {0x1071, 0x1074}, {0x1082, 0x108d}, {0x108f, 0x108f}, {0x109a, 0x109f}, {0x10c6, 0x10c6}, {0x10c8, 0x10cc},
  {0x10ce, 0x10cf}, {0x10fb, 0x10fb}, {0x1249, 0x1249}, {0x124e, 0x124f}, {0x1257, 0x1257}, {0x1259, 0x1259}, {0x125e, 0x125f}, {0x1289, 0x1289},
  {0x128e, 0x128f}, {0x12b1, 0x12b1}, {0x12b6, 0x12b7}, {0x12bf, 0x12bf}, {0x12c1, 0x12c1}, {0x12c6, 0x12c7}, {0x12d7, 0x12d7}, {0x1311, 0x1311},
  {0x1316, 0x1317}, {0x135b, 0x1368}, {0x137d, 0x137f}, {0x1390, 0x139f}, {0x13f6, 0x13f7}, {0x13fe, 0x1400}, {0x166d, 0x166e}, {0x1680, 0x1680},
  {0x169b, 0x169f}, {0x16eb, 0x16ed}, {0x16f9, 0x16ff}, {0x1712, 0x171e}, {0x1732, 0x173f}, {0x1752, 0x175f}, {0x176d, 0x176d}, {0x1771, 0x177f},
  {0x17b4, 0x17d6}, {0x17d8, 0x17db}, {0x17dd, 0x17df}, {0x17ea, 0x17ef}, {0x17fa, 0x180f}, {0x181a, 0x181f}, {0x1879, 0x187f}, {0x1885, 0x1886},
  {0x18a9, 0x18a9}, {0x18ab, 0x18af}, {0x18f6, 0x18ff}, {0x191f, 0x1945}, {0x196e, 0x196f}, {0x1975, 0x197f}, {0x19ac, 0x19af}, {0x19ca, 0x19cf},
  {0x19db, 0x19ff}, {0x1a17, 0x1a1f}, {0x1a55, 0x1a7f}, {0x1a8a, 0x1a8f}, {0x1a9a, 0x1aa6}, {0x1aa8, 0x1b04}, {0x1b34, 0x1b44}, {0x1b4d, 0x1b4f},
  {0x1b5a, 0x1b82}, {0x1ba1, 0x1bad}, {0x1be6, 0x1bff}, {0x1c24, 0x1c3f}, {0x1c4a, 0x1c4c}, {0x1c7e, 0x1c7f}, {0x1c89, 0x1c8f}, {0x1cbb, 0x1cbc},
  {0x1cc0, 0x1ce8}, {0x1ced, 0x1ced}, {0x1cf4, 0x1cf4}, {0x1cf7, 0x1cf9}, {0x1cfb, 0x1cff}, {0x1dc0, 0x1dff}, {0x1f16, 0x1f17}, {0x1f1e, 0x1f1f},
  {0x1f46, 0x1f47}, {0x1f4e, 0x1f4f}, {0x1f58, 0x1f58}, {0x1f5a, 0x1f5a}, {0x1f5c, 0x1f5c}, {0x1f5e, 0x1f5e}, {0x1f7e, 0x1f7f}, {0x1fb5, 0x1fb5},
  {0x1fbd, 0x1fbd}, {0x1fbf, 0x1fc1}, {0x1fc5, 0x1fc5}, {0x1fcd, 0x1fcf}, {0x1fd4, 0x1fd5}, {0x1fdc, 0x1fdf}, {0x1fed, 0x1ff1}, {0x1ff5, 0x1ff5},
  {0x1ffd, 0x206f}, {0x2072, 0x2073}, {0x207a, 0x207e}, {0x208a, 0x208f}, {0x209d, 0x2101}, {0x2103, 0x2106}, {0x2108, 0x2109}, {0x2114, 0x2114},
  {0x2116, 0x2118}, {0x211e, 0x2123}, {0x2125, 0x2125}, {0x2127, 0x2127}, {0x2129, 0x2129}, {0x212e, 0x212e}, {0x213a, 0x213b}, {0x2140, 0x2144},
  {0x214a, 0x214d}, {0x214f, 0x214f}, {0x218a, 0x245f}, {0x249c, 0x24e9}, {0x2500, 0x2775}, {0x2794, 0x2bff}, {0x2ce5, 0x2cea}, {0x2cef, 0x2cf1},
  {0x2cf4, 0x2cfc}, {0x2cfe, 0x2cff}, {0x2d26, 0x2d26}, {0x2d28, 0x2d2c}, {0x2d2e, 0x2d2f}, {0x2d68, 0x2d6e}, {0x2d70, 0x2d7f}, {0x2d97, 0x2d9f},
  {0x2da7, 0x2da7}, {0x2daf, 0x2daf}, {0x2db7, 0x2db7}, {0x2dbf, 0x2dbf}, {0x2dc7, 0x2dc7}, {0x2dcf, 0x2dcf}, {0x2dd7, 0x2dd7}, {0x2ddf, 0x2e2e},
  {0x2e30, 0x3004}, {0x3008, 0x3020}, {0x302a, 0x3030}, {0x3036, 0x3037}, {0x303d, 0x3040}, {0x3097, 0x309c}, {0x30a0, 0x30a0}, {0x30fb, 0x30fb},
  {0x3100, 0x3104}, {0x3130, 0x3130}, {0x318f, 0x3191}, {0x3196, 0x319f}, {0x31c0, 0x31ef}, {0x3200, 0x321f}, {0x322a, 0x3247}, {0x3250, 0x3250},
  {0x3260, 0x327f}, {0x328a, 0x32b0}, {0x32c0, 0x33ff}, {0x3401, 0x4dbe}, {0x4dc0, 0x4dff}, {0x4e01, 0x9ffe}, {0xa48d, 0xa4cf}, {0xa4fe, 0xa4ff},
  {0xa60d, 0xa60f}, {0xa62c, 0xa63f}, {0xa66f, 0xa67e}, {0xa69e, 0xa69f}, {0xa6f0, 0xa716}, {0xa720, 0xa721}, {0xa789, 0xa78a}, {0xa7cb, 0xa7cf},
  {0xa7d2, 0xa7d2}, {0xa7d4, 0xa7d4}, {0xa7da, 0xa7f1}, {0xa802, 0xa802}, {0xa806, 0xa806}, {0xa80b, 0xa80b}, {0xa823, 0xa82f}, {0xa836, 0xa83f},
  {0xa874, 0xa881}, {0xa8b4, 0xa8cf}, {0xa8da, 0xa8f1}, {0xa8f8, 0xa8fa}, {0xa8fc, 0xa8fc}, {0xa8ff, 0xa8ff}, {0xa926, 0xa92f}, {0xa947, 0xa95f},
  {0xa97d, 0xa983}, {0xa9b3, 0xa9ce}, {0xa9da, 0xa9df}, {0xa9e5, 0xa9e5}, {0xa9ff, 0xa9ff}, {0xaa29, 0xaa3f}, {0xaa43, 0xaa43}, {0xaa4c, 0xaa4f},
  {0xaa5a, 0xaa5f}, {0xaa77, 0xaa79}, {0xaa7b, 0xaa7d}, {0xaab0, 0xaab0}, {0xaab2, 0xaab4}, {0xaab7, 0xaab8}, {0xaabe, 0xaabf}, {0xaac1, 0xaac1},
  {0xaac3, 0xaada}, {0xaade, 0xaadf}, {0xaaeb, 0xaaf1}, {0xaaf5, 0xab00}, {0xab07, 0xab08}, {0xab0f, 0xab10}, {0xab17, 0xab1f}, {0xab27, 0xab27},
  {0xab2f, 0xab2f}, {0xab5b, 0xab5b}, {0xab6a, 0xab6f}, {0xabe3, 0xabef}, {0xabfa, 0xabff}, {0xac01, 0xd7a2}, {0xd7a4, 0xd7af}, {0xd7c7, 0xd7ca},
  {0xd7fc, 0xf8ff}, {0xfa6e, 0xfa6f}, {0xfada, 0xfaff}, {0xfb07, 0xfb12}, {0xfb18, 0xfb1c}, {0xfb1e, 0xfb1e}, {0xfb29, 0xfb29}, {0xfb37, 0xfb37},
  {0xfb3d, 0xfb3d}, {0xfb3f, 0xfb3f}, {0xfb42, 0xfb42}, {0xfb45, 0xfb45}, {0xfbb2, 0xfbd2}, {0xfd3e, 0xfd4f}, {0xfd90, 0xfd91}, {0xfdc8, 0xfdef},
  {0xfdfc, 0xfe6f}, {0xfe75, 0xfe75}, {0xfefd, 0xff0f}, {0xff1a, 0xff20}, {0xff3b, 0xff40}, {0xff5b, 0xff65}, {0xffbf, 0xffc1}, {0xffc8, 0xffc9},
  {0xffd0, 0xffd1}, {0xffd8, 0xffd9}, {0xffdd, 0xffff}, {0x1000c, 0x1000c}, {0x10027, 0x10027}, {0x1003b, 0x1003b}, {0x1003e, 0x1003e}, {0x1004e, 0x1004f},
  {0x1005e, 0x1007f}, {0x100fb, 0x10106}, {0x10134, 0x1013f}, {0x10179, 0x10189}, {0x1018c, 0x1027f}, {0x1029d, 0x1029f}, {0x102d1, 0x102e0}, {0x102fc, 0x102ff},
  {0x10324, 0x1032c}, {0x1034b, 0x1034f}, {0x10376, 0x1037f}, {0x1039e, 0x1039f}, {0x103c4, 0x103c7}, {0x103d0, 0x103d0}, {0x103d6, 0x103ff}, {0x1049e, 0x1049f},
  {0x104aa, 0x104af}, {0x104d4, 0x104d7}, {0x104fc, 0x104ff}, {0x10528, 0x1052f}, {0x10564, 0x1056f}, {0x1057b, 0x1057b}, {0x1058b, 0x1058b}, {0x10593, 0x10593},
  {0x10596, 0x10596}, {0x105a2, 0x105a2}, {0x105b2, 0x105b2}, {0x105ba, 0x105ba}, {0x105bd, 0x105ff}, {0x10737, 0x1073f}, {0x10756, 0x1075f}, {0x10768, 0x1077f},
  {0x10786, 0x10786}, {0x107b1, 0x107b1}, {0x107bb, 0x107ff}, {0x10806, 0x10807}, {0x10809, 0x10809}, {0x10836, 0x10836}, {0x10839, 0x1083b}, {0x1083d, 0x1083e},
  {0x10856, 0x10857}, {0x10877, 0x10878}, {0x1089f, 0x108a6}, {0x108b0, 0x108df}, {0x108f3, 0x108f3}, {0x108f6, 0x108fa}, {0x1091c, 0x10ffff},
};

static TSCharacterRange aux_sym_word_other_token1_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '/'}, {':', '@'}, {'\\', '\\'}, {'^', '^'}, {'`', '`'}, {'{', 0xa9},
  {0xab, 0xb1}, {0xb4, 0xb4}, {0xb6, 0xb8}, {0xbb, 0xbb}, {0xbf, 0xbf}, {0xd7, 0xd7}, {0xf7, 0xf7}, {0x2c2, 0x2c5},
  {0x2d2, 0x2df}, {0x2e5, 0x2eb}, {0x2ed, 0x2ed}, {0x2ef, 0x36f}, {0x375, 0x375}, {0x378, 0x379}, {0x37e, 0x37e}, {0x380, 0x385},
  {0x387, 0x387}, {0x38b, 0x38b}, {0x38d, 0x38d}, {0x3a2, 0x3a2}, {0x3f6, 0x3f6}, {0x482, 0x489}, {0x530, 0x530}, {0x557, 0x558},
  {0x55a, 0x55f}, {0x589, 0x5cf}, {0x5eb, 0x5ee}, {0x5f3, 0x61f}, {0x64b, 0x65f}, {0x66a, 0x66d}, {0x670, 0x670}, {0x6d4, 0x6d4},
  {0x6d6, 0x6e4}, {0x6e7, 0x6ed}, {0x6fd, 0x6fe}, {0x700, 0x70f}, {0x711, 0x711}, {0x730, 0x74c}, {0x7a6, 0x7b0}, {0x7b2, 0x7bf},
  {0x7eb, 0x7f3}, {0x7f6, 0x7f9}, {0x7fb, 0x7ff}, {0x816, 0x819}, {0x81b, 0x823}, {0x825, 0x827}, {0x829, 0x83f}, {0x859, 0x85f},
  {0x86b, 0x86f}, {0x888, 0x888}, {0x88f, 0x89f}, {0x8ca, 0x903}, {0x93a, 0x93c}, {0x93e, 0x94f}, {0x951, 0x957}, {0x962, 0x965},
  {0x970, 0x970}, {0x981, 0x984}, {0x98d, 0x98e}, {0x991, 0x992}, {0x9a9, 0x9a9}, {0x9b1, 0x9b1}, {0x9b3, 0x9b5}, {0x9ba, 0x9bc},
  {0x9be, 0x9cd}, {0x9cf, 0x9db}, {0x9de, 0x9de}, {0x9e2, 0x9e5}, {0x9f2, 0x9f3}, {0x9fa, 0x9fb}, {0x9fd, 0xa04}, {0xa0b, 0xa0e},
  {0xa11, 0xa12}, {0xa29, 0xa29}, {0xa31, 0xa31}, {0xa34, 0xa34}, {0xa37, 0xa37}, {0xa3a, 0xa58}, {0xa5d, 0xa5d}, {0xa5f, 0xa65},
  {0xa70, 0xa71}, {0xa75, 0xa84}, {0xa8e, 0xa8e}, {0xa92, 0xa92}, {0xaa9, 0xaa9}, {0xab1, 0xab1}, {0xab4, 0xab4}, {0xaba, 0xabc},
  {0xabe, 0xacf}, {0xad1, 0xadf}, {0xae2, 0xae5}, {0xaf0, 0xaf8}, {0xafa, 0xb04}, {0xb0d, 0xb0e}, {0xb11, 0xb12}, {0xb29, 0xb29},
  {0xb31, 0xb31}, {0xb34, 0xb34}, {0xb3a, 0xb3c}, {0xb3e, 0xb5b}, {0xb5e, 0xb5e}, {0xb62, 0xb65}, {0xb70, 0xb70}, {0xb78, 0xb82},
  {0xb84, 0xb84}, {0xb8b, 0xb8d}, {0xb91, 0xb91}, {0xb96, 0xb98}, {0xb9b, 0xb9b}, {0xb9d, 0xb9d}, {0xba0, 0xba2}, {0xba5, 0xba7},
  {0xbab, 0xbad}, {0xbba, 0xbcf}, {0xbd1, 0xbe5}, {0xbf3, 0xc04}, {0xc0d, 0xc0d}, {0xc11, 0xc11}, {0xc29, 0xc29}, {0xc3a, 0xc3c},
  {0xc3e, 0xc57}, {0xc5b, 0xc5c}, {0xc5e, 0xc5f}, {0xc62, 0xc65}, {0xc70, 0xc77}, {0xc7f, 0xc7f}, {0xc81, 0xc84}, {0xc8d, 0xc8d},
  {0xc91, 0xc91}, {0xca9, 0xca9}, {0xcb4, 0xcb4}, {0xcba, 0xcbc}, {0xcbe, 0xcdc}, {0xcdf, 0xcdf}, {0xce2, 0xce5}, {0xcf0, 0xcf0},
  {0xcf3, 0xd03}, {0xd0d, 0xd0d}, {0xd11, 0xd11}, {0xd3b, 0xd3c}, {0xd3e, 0xd4d}, {0xd4f, 0xd53}, {0xd57, 0xd57}, {0xd62, 0xd65},
  {0xd79, 0xd79}, {0xd80, 0xd84}, {0xd97, 0xd99}, {0xdb2, 0xdb2}, {0xdbc, 0xdbc}, {0xdbe, 0xdbf}, {0xdc7, 0xde5}, {0xdf0, 0xe00},
  {0xe31, 0xe31}, {0xe34, 0xe3f}, {0xe47, 0xe4f}, {0xe5a, 0xe80}, {0xe83, 0xe83}, {0xe85, 0xe85}, {0xe8b, 0xe8b}, {0xea4, 0xea4},
  {0xea6, 0xea6}, {0xeb1, 0xeb1}, {0xeb4, 0xebc}, {0xebe, 0xebf}, {0xec5, 0xec5}, {0xec7, 0xecf}, {0xeda, 0xedb}, {0xee0, 0xeff},
  {0xf01, 0xf1f}, {0xf34, 0xf3f}, {0xf48, 0xf48}, {0xf6d, 0xf87}, {0xf8d, 0xfff}, {0x102b, 0x103e}, {0x104a, 0x104f}, {0x1056, 0x1059},
  {0x105e, 0x1060}, {0x1062, 0x1064}, {0x1067, 0x106d}, {0x1071, 0x1074}, {0x1082, 0x108d}, {0x108f, 0x108f}, {0x109a, 0x109f}, {0x10c6, 0x10c6},
  {0x10c8, 0x10cc}, {0x10ce, 0x10cf}, {0x10fb, 0x10fb}, {0x1249, 0x1249}, {0x124e, 0x124f}, {0x1257, 0x1257}, {0x1259, 0x1259}, {0x125e, 0x125f},
  {0x1289, 0x1289}, {0x128e, 0x128f}, {0x12b1, 0x12b1}, {0x12b6, 0x12b7}, {0x12bf, 0x12bf}, {0x12c1, 0x12c1}, {0x12c6, 0x12c7}, {0x12d7, 0x12d7},
  {0x1311, 0x1311}, {0x1316, 0x1317}, {0x135b, 0x1368}, {0x137d, 0x137f}, {0x1390, 0x139f}, {0x13f6, 0x13f7}, {0x13fe, 0x1400}, {0x166d, 0x166e},
  {0x1680, 0x1680}, {0x169b, 0x169f}, {0x16eb, 0x16ed}, {0x16f9, 0x16ff}, {0x1712, 0x171e}, {0x1732, 0x173f}, {0x1752, 0x175f}, {0x176d, 0x176d},
  {0x1771, 0x177f}, {0x17b4, 0x17d6}, {0x17d8, 0x17db}, {0x17dd, 0x17df}, {0x17ea, 0x17ef}, {0x17fa, 0x180f}, {0x181a, 0x181f}, {0x1879, 0x187f},
  {0x1885, 0x1886}, {0x18a9, 0x18a9}, {0x18ab, 0x18af}, {0x18f6, 0x18ff}, {0x191f, 0x1945}, {0x196e, 0x196f}, {0x1975, 0x197f}, {0x19ac, 0x19af},
  {0x19ca, 0x19cf}, {0x19db, 0x19ff}, {0x1a17, 0x1a1f}, {0x1a55, 0x1a7f}, {0x1a8a, 0x1a8f}, {0x1a9a, 0x1aa6}, {0x1aa8, 0x1b04}, {0x1b34, 0x1b44},
  {0x1b4d, 0x1b4f}, {0x1b5a, 0x1b82}, {0x1ba1, 0x1bad}, {0x1be6, 0x1bff}, {0x1c24, 0x1c3f}, {0x1c4a, 0x1c4c}, {0x1c7e, 0x1c7f}, {0x1c89, 0x1c8f},
  {0x1cbb, 0x1cbc}, {0x1cc0, 0x1ce8}, {0x1ced, 0x1ced}, {0x1cf4, 0x1cf4}, {0x1cf7, 0x1cf9}, {0x1cfb, 0x1cff}, {0x1dc0, 0x1dff}, {0x1f16, 0x1f17},
  {0x1f1e, 0x1f1f}, {0x1f46, 0x1f47}, {0x1f4e, 0x1f4f}, {0x1f58, 0x1f58}, {0x1f5a, 0x1f5a}, {0x1f5c, 0x1f5c}, {0x1f5e, 0x1f5e}, {0x1f7e, 0x1f7f},
  {0x1fb5, 0x1fb5}, {0x1fbd, 0x1fbd}, {0x1fbf, 0x1fc1}, {0x1fc5, 0x1fc5}, {0x1fcd, 0x1fcf}, {0x1fd4, 0x1fd5}, {0x1fdc, 0x1fdf}, {0x1fed, 0x1ff1},
  {0x1ff5, 0x1ff5}, {0x1ffd, 0x206f}, {0x2072, 0x2073}, {0x207a, 0x207e}, {0x208a, 0x208f}, {0x209d, 0x2101}, {0x2103, 0x2106}, {0x2108, 0x2109},
  {0x2114, 0x2114}, {0x2116, 0x2118}, {0x211e, 0x2123}, {0x2125, 0x2125}, {0x2127, 0x2127}, {0x2129, 0x2129}, {0x212e, 0x212e}, {0x213a, 0x213b},
  {0x2140, 0x2144}, {0x214a, 0x214d}, {0x214f, 0x214f}, {0x218a, 0x245f}, {0x249c, 0x24e9}, {0x2500, 0x2775}, {0x2794, 0x2bff}, {0x2ce5, 0x2cea},
  {0x2cef, 0x2cf1}, {0x2cf4, 0x2cfc}, {0x2cfe, 0x2cff}, {0x2d26, 0x2d26}, {0x2d28, 0x2d2c}, {0x2d2e, 0x2d2f}, {0x2d68, 0x2d6e}, {0x2d70, 0x2d7f},
  {0x2d97, 0x2d9f}, {0x2da7, 0x2da7}, {0x2daf, 0x2daf}, {0x2db7, 0x2db7}, {0x2dbf, 0x2dbf}, {0x2dc7, 0x2dc7}, {0x2dcf, 0x2dcf}, {0x2dd7, 0x2dd7},
  {0x2ddf, 0x2e2e}, {0x2e30, 0x3004}, {0x3008, 0x3020}, {0x302a, 0x3030}, {0x3036, 0x3037}, {0x303d, 0x3040}, {0x3097, 0x309c}, {0x30a0, 0x30a0},
  {0x30fb, 0x30fb}, {0x3100, 0x3104}, {0x3130, 0x3130}, {0x318f, 0x3191}, {0x3196, 0x319f}, {0x31c0, 0x31ef}, {0x3200, 0x321f}, {0x322a, 0x3247},
  {0x3250, 0x3250}, {0x3260, 0x327f}, {0x328a, 0x32b0}, {0x32c0, 0x33ff}, {0x3401, 0x4dbe}, {0x4dc0, 0x4dff}, {0x4e01, 0x9ffe}, {0xa48d, 0xa4cf},
  {0xa4fe, 0xa4ff}, {0xa60d, 0xa60f}, {0xa62c, 0xa63f}, {0xa66f, 0xa67e}, {0xa69e, 0xa69f}, {0xa6f0, 0xa716}, {0xa720, 0xa721}, {0xa789, 0xa78a},
  {0xa7cb, 0xa7cf}, {0xa7d2, 0xa7d2}, {0xa7d4, 0xa7d4}, {0xa7da, 0xa7f1}, {0xa802, 0xa802}, {0xa806, 0xa806}, {0xa80b, 0xa80b}, {0xa823, 0xa82f},
  {0xa836, 0xa83f}, {0xa874, 0xa881}, {0xa8b4, 0xa8cf}, {0xa8da, 0xa8f1}, {0xa8f8, 0xa8fa}, {0xa8fc, 0xa8fc}, {0xa8ff, 0xa8ff}, {0xa926, 0xa92f},
  {0xa947, 0xa95f}, {0xa97d, 0xa983}, {0xa9b3, 0xa9ce}, {0xa9da, 0xa9df}, {0xa9e5, 0xa9e5}, {0xa9ff, 0xa9ff}, {0xaa29, 0xaa3f}, {0xaa43, 0xaa43},
  {0xaa4c, 0xaa4f}, {0xaa5a, 0xaa5f}, {0xaa77, 0xaa79}, {0xaa7b, 0xaa7d}, {0xaab0, 0xaab0}, {0xaab2, 0xaab4}, {0xaab7, 0xaab8}, {0xaabe, 0xaabf},
  {0xaac1, 0xaac1}, {0xaac3, 0xaada}, {0xaade, 0xaadf}, {0xaaeb, 0xaaf1}, {0xaaf5, 0xab00}, {0xab07, 0xab08}, {0xab0f, 0xab10}, {0xab17, 0xab1f},
  {0xab27, 0xab27}, {0xab2f, 0xab2f}, {0xab5b, 0xab5b}, {0xab6a, 0xab6f}, {0xabe3, 0xabef}, {0xabfa, 0xabff}, {0xac01, 0xd7a2}, {0xd7a4, 0xd7af},
  {0xd7c7, 0xd7ca}, {0xd7fc, 0xf8ff}, {0xfa6e, 0xfa6f}, {0xfada, 0xfaff}, {0xfb07, 0xfb12}, {0xfb18, 0xfb1c}, {0xfb1e, 0xfb1e}, {0xfb29, 0xfb29},
  {0xfb37, 0xfb37}, {0xfb3d, 0xfb3d}, {0xfb3f, 0xfb3f}, {0xfb42, 0xfb42}, {0xfb45, 0xfb45}, {0xfbb2, 0xfbd2}, {0xfd3e, 0xfd4f}, {0xfd90, 0xfd91},
  {0xfdc8, 0xfdef}, {0xfdfc, 0xfe6f}, {0xfe75, 0xfe75}, {0xfefd, 0xff0f}, {0xff1a, 0xff20}, {0xff3b, 0xff40}, {0xff5b, 0xff65}, {0xffbf, 0xffc1},
  {0xffc8, 0xffc9}, {0xffd0, 0xffd1}, {0xffd8, 0xffd9}, {0xffdd, 0xffff}, {0x1000c, 0x1000c}, {0x10027, 0x10027}, {0x1003b, 0x1003b}, {0x1003e, 0x1003e},
  {0x1004e, 0x1004f}, {0x1005e, 0x1007f}, {0x100fb, 0x10106}, {0x10134, 0x1013f}, {0x10179, 0x10189}, {0x1018c, 0x1027f}, {0x1029d, 0x1029f}, {0x102d1, 0x102e0},
  {0x102fc, 0x102ff}, {0x10324, 0x1032c}, {0x1034b, 0x1034f}, {0x10376, 0x1037f}, {0x1039e, 0x1039f}, {0x103c4, 0x103c7}, {0x103d0, 0x103d0}, {0x103d6, 0x103ff},
  {0x1049e, 0x1049f}, {0x104aa, 0x104af}, {0x104d4, 0x104d7}, {0x104fc, 0x104ff}, {0x10528, 0x1052f}, {0x10564, 0x1056f}, {0x1057b, 0x1057b}, {0x1058b, 0x1058b},
  {0x10593, 0x10593}, {0x10596, 0x10596}, {0x105a2, 0x105a2}, {0x105b2, 0x105b2}, {0x105ba, 0x105ba}, {0x105bd, 0x105ff}, {0x10737, 0x1073f}, {0x10756, 0x1075f},
  {0x10768, 0x1077f}, {0x10786, 0x10786}, {0x107b1, 0x107b1}, {0x107bb, 0x107ff}, {0x10806, 0x10807}, {0x10809, 0x10809}, {0x10836, 0x10836}, {0x10839, 0x1083b},
  {0x1083d, 0x1083e}, {0x10856, 0x10857}, {0x10877, 0x10878}, {0x1089f, 0x108a6}, {0x108b0, 0x108df}, {0x108f3, 0x108f3}, {0x108f6, 0x108fa}, {0x1091c, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(17);
      ADVANCE_MAP(
        '"', 38,
        '#', 33,
        '(', 25,
        ')', 26,
        ',', 28,
        '-', 22,
        '.', 45,
        ':', 36,
        '=', 21,
        '[', 29,
        '\\', 15,
        ']', 30,
        'f', 49,
        'r', 50,
        't', 54,
        '{', 31,
        '}', 32,
        '~', 27,
        '*', 24,
        '+', 24,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(0);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(38);
      if (lookahead == '=') ADVANCE(44);
      if (lookahead == 'f') ADVANCE(49);
      if (lookahead == 't') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(1);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(38);
      if (lookahead == '\\') ADVANCE(15);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(39);
      END_STATE();
    case 3:
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') SKIP(3);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(59);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(48);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(58);
      END_STATE();
    case 4:
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') SKIP(4);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(60);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(48);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(58);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '~') ADVANCE(27);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') SKIP(5);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(61);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(48);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(58);
      END_STATE();
    case 6:
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') SKIP(6);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(62);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(48);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(58);
      END_STATE();
    case 7:
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == ')') ADVANCE(26);
      if (lookahead == ',') ADVANCE(28);
      if (lookahead == '=') ADVANCE(21);
      if (lookahead == 'r') ADVANCE(50);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(7);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 8:
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '[') ADVANCE(29);
      if (lookahead == ']') ADVANCE(30);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') SKIP(8);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(65);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(48);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(64);
      END_STATE();
    case 9:
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == '=') ADVANCE(21);
      if (set_contains(extras_character_set_1, 10, lookahead)) SKIP(9);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 10:
      if (lookahead == '*') ADVANCE(16);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(19);
      if (lookahead != 0) ADVANCE(18);
      END_STATE();
    case 11:
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '[') ADVANCE(29);
      if (lookahead == ']') ADVANCE(30);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') SKIP(11);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(66);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(48);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(64);
      END_STATE();
    case 12:
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') SKIP(12);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(63);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(48);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(58);
      END_STATE();
    case 13:
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '}') ADVANCE(32);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(46);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(47);
      END_STATE();
    case 14:
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(34);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ':') ADVANCE(35);
      END_STATE();
    case 15:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(41);
      END_STATE();
    case 16:
      if (lookahead != 0 &&
          lookahead != '/') ADVANCE(20);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(aux_sym_block_comment_token1);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(aux_sym_block_comment_token1);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(19);
      if (lookahead != 0 &&
          lookahead != '*') ADVANCE(18);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(aux_sym_block_comment_token2);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(aux_sym_knot_header_token1);
      if (lookahead == '=') ADVANCE(21);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(aux_sym_gather_mark_token1);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(aux_sym_gather_mark_token1);
      if (set_contains(sym_vocabulary_character_set_1, 477, lookahead)) ADVANCE(48);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(sym_option_mark);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(aux_sym_label_token1);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(aux_sym_label_token2);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(aux_sym_code_text_token1);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(aux_sym_list_token1);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(sym_hide_start);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(sym_hide_end);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(aux_sym_condition_block_token1);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(aux_sym_condition_block_token2);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(aux_sym_tag_token1);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(sym_tag_remainder);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(34);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ':') ADVANCE(35);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(sym_tag_remainder);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != ':') ADVANCE(35);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(sym_tag_delimiter);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(sym_boolean);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(40);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(39);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_ref);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(43);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_assignment);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_dot);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_block_remainder);
      if (set_contains(extras_character_set_1, 10, lookahead)) ADVANCE(46);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(47);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(sym_block_remainder);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '{' &&
          lookahead != '}') ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(sym_vocabulary);
      if (set_contains(sym_vocabulary_character_set_1, 477, lookahead)) ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(53);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(52);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(37);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(42);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(55);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(56);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(51);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(51);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_1, 476, lookahead)) ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_other_token1);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(aux_sym_other_token1);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(59);
      if ((!eof && set_contains(aux_sym_other_token1_character_set_1, 479, lookahead))) ADVANCE(58);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_other_token1);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(60);
      if ((!eof && set_contains(aux_sym_other_token1_character_set_1, 479, lookahead))) ADVANCE(58);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_other_token1);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '-') ADVANCE(23);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '~') ADVANCE(27);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(24);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(61);
      if ((!eof && set_contains(aux_sym_other_token1_character_set_1, 479, lookahead))) ADVANCE(58);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(aux_sym_other_token1);
      if (lookahead == '#') ADVANCE(33);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(62);
      if ((!eof && set_contains(aux_sym_other_token1_character_set_1, 479, lookahead))) ADVANCE(58);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(aux_sym_other_token1);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(63);
      if ((!eof && set_contains(aux_sym_other_token1_character_set_1, 479, lookahead))) ADVANCE(58);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(aux_sym_word_other_token1);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(aux_sym_word_other_token1);
      if (lookahead == '(') ADVANCE(25);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == '*' ||
          lookahead == '+') ADVANCE(24);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(65);
      if ((!eof && set_contains(aux_sym_word_other_token1_character_set_1, 480, lookahead))) ADVANCE(64);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_word_other_token1);
      if (lookahead == '-') ADVANCE(48);
      if (lookahead == '{') ADVANCE(31);
      if (lookahead == 0xa0 ||
          lookahead == 0x1680 ||
          (0x2000 <= lookahead && lookahead <= 0x200a) ||
          lookahead == 0x2028 ||
          lookahead == 0x2029 ||
          lookahead == 0x202f ||
          lookahead == 0x205f ||
          lookahead == 0x3000) ADVANCE(66);
      if ((!eof && set_contains(aux_sym_word_other_token1_character_set_1, 480, lookahead))) ADVANCE(64);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 2},
  [2] = {.lex_state = 5, .external_lex_state = 3},
  [3] = {.lex_state = 5, .external_lex_state = 3},
  [4] = {.lex_state = 8, .external_lex_state = 3},
  [5] = {.lex_state = 4, .external_lex_state = 3},
  [6] = {.lex_state = 6, .external_lex_state = 3},
  [7] = {.lex_state = 11, .external_lex_state = 3},
  [8] = {.lex_state = 0, .external_lex_state = 2},
  [9] = {.lex_state = 0, .external_lex_state = 4},
  [10] = {.lex_state = 0, .external_lex_state = 4},
  [11] = {.lex_state = 11, .external_lex_state = 3},
  [12] = {.lex_state = 11, .external_lex_state = 3},
  [13] = {.lex_state = 0, .external_lex_state = 4},
  [14] = {.lex_state = 0, .external_lex_state = 4},
  [15] = {.lex_state = 0, .external_lex_state = 2},
  [16] = {.lex_state = 6, .external_lex_state = 3},
  [17] = {.lex_state = 8, .external_lex_state = 3},
  [18] = {.lex_state = 0, .external_lex_state = 2},
  [19] = {.lex_state = 0, .external_lex_state = 2},
  [20] = {.lex_state = 6, .external_lex_state = 3},
  [21] = {.lex_state = 8, .external_lex_state = 3},
  [22] = {.lex_state = 3, .external_lex_state = 3},
  [23] = {.lex_state = 0, .external_lex_state = 5},
  [24] = {.lex_state = 3, .external_lex_state = 3},
  [25] = {.lex_state = 3, .external_lex_state = 3},
  [26] = {.lex_state = 0, .external_lex_state = 5},
  [27] = {.lex_state = 11, .external_lex_state = 3},
  [28] = {.lex_state = 11, .external_lex_state = 3},
  [29] = {.lex_state = 6, .external_lex_state = 3},
  [30] = {.lex_state = 13, .external_lex_state = 6},
  [31] = {.lex_state = 11, .external_lex_state = 3},
  [32] = {.lex_state = 11, .external_lex_state = 3},
  [33] = {.lex_state = 6, .external_lex_state = 3},
  [34] = {.lex_state = 11, .external_lex_state = 3},
  [35] = {.lex_state = 11, .external_lex_state = 3},
  [36] = {.lex_state = 11, .external_lex_state = 3},
  [37] = {.lex_state = 12, .external_lex_state = 7},
  [38] = {.lex_state = 13, .external_lex_state = 6},
  [39] = {.lex_state = 13, .external_lex_state = 6},
  [40] = {.lex_state = 13, .external_lex_state = 6},
  [41] = {.lex_state = 6, .external_lex_state = 3},
  [42] = {.lex_state = 6, .external_lex_state = 3},
  [43] = {.lex_state = 0, .external_lex_state = 4},
  [44] = {.lex_state = 13, .external_lex_state = 6},
  [45] = {.lex_state = 6, .external_lex_state = 3},
  [46] = {.lex_state = 0, .external_lex_state = 4},
  [47] = {.lex_state = 0, .external_lex_state = 4},
  [48] = {.lex_state = 13, .external_lex_state = 6},
  [49] = {.lex_state = 6, .external_lex_state = 3},
  [50] = {.lex_state = 0, .external_lex_state = 4},
  [51] = {.lex_state = 12, .external_lex_state = 8},
  [52] = {.lex_state = 13, .external_lex_state = 6},
  [53] = {.lex_state = 0, .external_lex_state = 4},
  [54] = {.lex_state = 0, .external_lex_state = 4},
  [55] = {.lex_state = 12, .external_lex_state = 7},
  [56] = {.lex_state = 0, .external_lex_state = 4},
  [57] = {.lex_state = 12, .external_lex_state = 7},
  [58] = {.lex_state = 0, .external_lex_state = 4},
  [59] = {.lex_state = 0, .external_lex_state = 4},
  [60] = {.lex_state = 0, .external_lex_state = 4},
  [61] = {.lex_state = 6, .external_lex_state = 3},
  [62] = {.lex_state = 13, .external_lex_state = 6},
  [63] = {.lex_state = 0, .external_lex_state = 2},
  [64] = {.lex_state = 0, .external_lex_state = 2},
  [65] = {.lex_state = 0, .external_lex_state = 2},
  [66] = {.lex_state = 0, .external_lex_state = 9},
  [67] = {.lex_state = 7, .external_lex_state = 6},
  [68] = {.lex_state = 0, .external_lex_state = 2},
  [69] = {.lex_state = 0, .external_lex_state = 2},
  [70] = {.lex_state = 7, .external_lex_state = 6},
  [71] = {.lex_state = 0, .external_lex_state = 2},
  [72] = {.lex_state = 0, .external_lex_state = 2},
  [73] = {.lex_state = 13, .external_lex_state = 6},
  [74] = {.lex_state = 0, .external_lex_state = 2},
  [75] = {.lex_state = 0, .external_lex_state = 2},
  [76] = {.lex_state = 0, .external_lex_state = 2},
  [77] = {.lex_state = 0, .external_lex_state = 2},
  [78] = {.lex_state = 0, .external_lex_state = 9},
  [79] = {.lex_state = 0, .external_lex_state = 9},
  [80] = {.lex_state = 0, .external_lex_state = 9},
  [81] = {.lex_state = 0, .external_lex_state = 2},
  [82] = {.lex_state = 0, .external_lex_state = 9},
  [83] = {.lex_state = 0, .external_lex_state = 9},
  [84] = {.lex_state = 0, .external_lex_state = 10},
  [85] = {.lex_state = 0, .external_lex_state = 11},
  [86] = {.lex_state = 0, .external_lex_state = 11},
  [87] = {.lex_state = 7, .external_lex_state = 6},
  [88] = {.lex_state = 7, .external_lex_state = 6},
  [89] = {.lex_state = 13, .external_lex_state = 6},
  [90] = {.lex_state = 0, .external_lex_state = 11},
  [91] = {.lex_state = 0, .external_lex_state = 11},
  [92] = {.lex_state = 13, .external_lex_state = 6},
  [93] = {.lex_state = 1, .external_lex_state = 12},
  [94] = {.lex_state = 7, .external_lex_state = 6},
  [95] = {.lex_state = 1, .external_lex_state = 12},
  [96] = {.lex_state = 1, .external_lex_state = 12},
  [97] = {.lex_state = 12, .external_lex_state = 7},
  [98] = {.lex_state = 12, .external_lex_state = 7},
  [99] = {.lex_state = 7, .external_lex_state = 6},
  [100] = {.lex_state = 1, .external_lex_state = 12},
  [101] = {.lex_state = 0, .external_lex_state = 10},
  [102] = {.lex_state = 12, .external_lex_state = 7},
  [103] = {.lex_state = 9, .external_lex_state = 12},
  [104] = {.lex_state = 7, .external_lex_state = 6},
  [105] = {.lex_state = 12, .external_lex_state = 7},
  [106] = {.lex_state = 12, .external_lex_state = 7},
  [107] = {.lex_state = 13, .external_lex_state = 12},
  [108] = {.lex_state = 9, .external_lex_state = 6},
  [109] = {.lex_state = 12, .external_lex_state = 7},
  [110] = {.lex_state = 13, .external_lex_state = 12},
  [111] = {.lex_state = 0, .external_lex_state = 10},
  [112] = {.lex_state = 0, .external_lex_state = 10},
  [113] = {.lex_state = 13, .external_lex_state = 12},
  [114] = {.lex_state = 12, .external_lex_state = 7},
  [115] = {.lex_state = 9, .external_lex_state = 6},
  [116] = {.lex_state = 13, .external_lex_state = 12},
  [117] = {.lex_state = 13, .external_lex_state = 12},
  [118] = {.lex_state = 12, .external_lex_state = 7},
  [119] = {.lex_state = 7, .external_lex_state = 6},
  [120] = {.lex_state = 12, .external_lex_state = 7},
  [121] = {.lex_state = 13, .external_lex_state = 12},
  [122] = {.lex_state = 13, .external_lex_state = 12},
  [123] = {.lex_state = 13, .external_lex_state = 12},
  [124] = {.lex_state = 13, .external_lex_state = 12},
  [125] = {.lex_state = 13, .external_lex_state = 12},
  [126] = {.lex_state = 0, .external_lex_state = 10},
  [127] = {.lex_state = 7, .external_lex_state = 6},
  [128] = {.lex_state = 9, .external_lex_state = 12},
  [129] = {.lex_state = 13, .external_lex_state = 6},
  [130] = {.lex_state = 13, .external_lex_state = 6},
  [131] = {.lex_state = 7, .external_lex_state = 6},
  [132] = {.lex_state = 2, .external_lex_state = 12},
  [133] = {.lex_state = 0, .external_lex_state = 6},
  [134] = {.lex_state = 0, .external_lex_state = 10},
  [135] = {.lex_state = 7, .external_lex_state = 6},
  [136] = {.lex_state = 2, .external_lex_state = 12},
  [137] = {.lex_state = 10, .external_lex_state = 13},
  [138] = {.lex_state = 0, .external_lex_state = 6},
  [139] = {.lex_state = 2, .external_lex_state = 12},
  [140] = {.lex_state = 9, .external_lex_state = 12},
  [141] = {.lex_state = 9, .external_lex_state = 14},
  [142] = {.lex_state = 7, .external_lex_state = 6},
  [143] = {.lex_state = 13, .external_lex_state = 6},
  [144] = {.lex_state = 0, .external_lex_state = 11},
  [145] = {.lex_state = 0, .external_lex_state = 11},
  [146] = {.lex_state = 10, .external_lex_state = 13},
  [147] = {.lex_state = 10, .external_lex_state = 13},
  [148] = {.lex_state = 7, .external_lex_state = 12},
  [149] = {.lex_state = 7, .external_lex_state = 6},
  [150] = {.lex_state = 0, .external_lex_state = 10},
  [151] = {.lex_state = 0, .external_lex_state = 10},
  [152] = {.lex_state = 0, .external_lex_state = 6},
  [153] = {.lex_state = 10, .external_lex_state = 13},
  [154] = {.lex_state = 0, .external_lex_state = 9},
  [155] = {.lex_state = 7, .external_lex_state = 6},
  [156] = {.lex_state = 0, .external_lex_state = 14},
  [157] = {.lex_state = 0, .external_lex_state = 6},
  [158] = {.lex_state = 0, .external_lex_state = 6},
  [159] = {.lex_state = 0, .external_lex_state = 6},
  [160] = {.lex_state = 13, .external_lex_state = 6},
  [161] = {.lex_state = 13, .external_lex_state = 6},
  [162] = {.lex_state = 7, .external_lex_state = 6},
  [163] = {.lex_state = 13, .external_lex_state = 6},
  [164] = {.lex_state = 13, .external_lex_state = 6},
  [165] = {.lex_state = 2, .external_lex_state = 12},
  [166] = {.lex_state = 0, .external_lex_state = 6},
  [167] = {.lex_state = 13, .external_lex_state = 12},
  [168] = {.lex_state = 13, .external_lex_state = 12},
  [169] = {.lex_state = 0, .external_lex_state = 9},
  [170] = {.lex_state = 13, .external_lex_state = 6},
  [171] = {.lex_state = 13, .external_lex_state = 12},
  [172] = {.lex_state = 9, .external_lex_state = 6},
  [173] = {.lex_state = 0, .external_lex_state = 6},
  [174] = {.lex_state = 0, .external_lex_state = 15},
  [175] = {.lex_state = 0, .external_lex_state = 15},
  [176] = {.lex_state = 0, .external_lex_state = 6},
  [177] = {.lex_state = 0, .external_lex_state = 6},
  [178] = {.lex_state = 9, .external_lex_state = 12},
  [179] = {.lex_state = 9, .external_lex_state = 12},
  [180] = {.lex_state = 7, .external_lex_state = 6},
  [181] = {.lex_state = 0, .external_lex_state = 6},
  [182] = {.lex_state = 0, .external_lex_state = 6},
  [183] = {.lex_state = 7, .external_lex_state = 6},
  [184] = {.lex_state = 7, .external_lex_state = 6},
  [185] = {.lex_state = 9, .external_lex_state = 12},
  [186] = {.lex_state = 9, .external_lex_state = 12},
  [187] = {.lex_state = 0, .external_lex_state = 6},
  [188] = {.lex_state = 7, .external_lex_state = 6},
  [189] = {.lex_state = 0, .external_lex_state = 6},
  [190] = {.lex_state = 0, .external_lex_state = 15},
  [191] = {.lex_state = 0, .external_lex_state = 15},
  [192] = {.lex_state = 7, .external_lex_state = 6},
  [193] = {.lex_state = 7, .external_lex_state = 6},
  [194] = {.lex_state = 0, .external_lex_state = 15},
  [195] = {.lex_state = 0, .external_lex_state = 15},
  [196] = {.lex_state = 0, .external_lex_state = 15},
  [197] = {.lex_state = 0, .external_lex_state = 15},
  [198] = {.lex_state = 0, .external_lex_state = 15},
  [199] = {.lex_state = 0, .external_lex_state = 6},
  [200] = {.lex_state = 9, .external_lex_state = 12},
  [201] = {.lex_state = 0, .external_lex_state = 6},
  [202] = {.lex_state = 0, .external_lex_state = 6},
  [203] = {.lex_state = 0, .external_lex_state = 6},
  [204] = {.lex_state = 9, .external_lex_state = 12},
  [205] = {.lex_state = 14, .external_lex_state = 12},
  [206] = {.lex_state = 9, .external_lex_state = 12},
  [207] = {.lex_state = 0, .external_lex_state = 6},
  [208] = {.lex_state = 0, .external_lex_state = 6},
  [209] = {.lex_state = 1, .external_lex_state = 12},
  [210] = {.lex_state = 1, .external_lex_state = 12},
  [211] = {.lex_state = 0, .external_lex_state = 6},
  [212] = {.lex_state = 1, .external_lex_state = 12},
  [213] = {.lex_state = 0, .external_lex_state = 6},
  [214] = {.lex_state = 0, .external_lex_state = 6},
  [215] = {.lex_state = 0, .external_lex_state = 15},
  [216] = {.lex_state = 0, .external_lex_state = 6},
  [217] = {.lex_state = 0, .external_lex_state = 6},
  [218] = {.lex_state = 9, .external_lex_state = 12},
  [219] = {.lex_state = 0, .external_lex_state = 6},
  [220] = {.lex_state = 0, .external_lex_state = 15},
  [221] = {.lex_state = 0, .external_lex_state = 12},
  [222] = {.lex_state = 0, .external_lex_state = 6},
  [223] = {.lex_state = 9, .external_lex_state = 12},
  [224] = {.lex_state = 0, .external_lex_state = 6},
  [225] = {.lex_state = 0, .external_lex_state = 6},
  [226] = {.lex_state = 0, .external_lex_state = 6},
  [227] = {.lex_state = 0, .external_lex_state = 6},
  [228] = {.lex_state = 0, .external_lex_state = 6},
  [229] = {.lex_state = 0, .external_lex_state = 6},
  [230] = {.lex_state = 9, .external_lex_state = 12},
  [231] = {.lex_state = 9, .external_lex_state = 12},
  [232] = {.lex_state = 9, .external_lex_state = 12},
  [233] = {.lex_state = 0, .external_lex_state = 6},
  [234] = {.lex_state = 0, .external_lex_state = 6},
  [235] = {.lex_state = 0, .external_lex_state = 6},
  [236] = {.lex_state = 0, .external_lex_state = 6},
  [237] = {.lex_state = 0, .external_lex_state = 6},
  [238] = {.lex_state = 0, .external_lex_state = 6},
  [239] = {.lex_state = 9, .external_lex_state = 12},
  [240] = {.lex_state = 9, .external_lex_state = 12},
  [241] = {.lex_state = 0, .external_lex_state = 12},
  [242] = {.lex_state = 0, .external_lex_state = 6},
  [243] = {.lex_state = 0, .external_lex_state = 6},
  [244] = {.lex_state = 0, .external_lex_state = 6},
  [245] = {.lex_state = 0, .external_lex_state = 6},
  [246] = {.lex_state = 9, .external_lex_state = 12},
  [247] = {.lex_state = 0, .external_lex_state = 6},
  [248] = {.lex_state = 0, .external_lex_state = 6},
  [249] = {.lex_state = 0, .external_lex_state = 6},
  [250] = {.lex_state = 9, .external_lex_state = 12},
  [251] = {.lex_state = 0, .external_lex_state = 6},
  [252] = {.lex_state = 9, .external_lex_state = 12},
  [253] = {.lex_state = 0, .external_lex_state = 6},
  [254] = {.lex_state = 0, .external_lex_state = 6},
  [255] = {.lex_state = 0, .external_lex_state = 6},
  [256] = {.lex_state = 0, .external_lex_state = 12},
  [257] = {.lex_state = 0, .external_lex_state = 6},
  [258] = {.lex_state = 0, .external_lex_state = 6},
  [259] = {.lex_state = 1, .external_lex_state = 12},
  [260] = {.lex_state = 1, .external_lex_state = 12},
  [261] = {.lex_state = 1, .external_lex_state = 12},
  [262] = {.lex_state = 0, .external_lex_state = 6},
  [263] = {.lex_state = 9, .external_lex_state = 12},
  [264] = {.lex_state = 9, .external_lex_state = 12},
  [265] = {.lex_state = 9, .external_lex_state = 12},
  [266] = {.lex_state = 9, .external_lex_state = 12},
  [267] = {(TSStateId)(-1)},
  [268] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_block_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [aux_sym_knot_header_token1] = ACTIONS(1),
    [aux_sym_gather_mark_token1] = ACTIONS(1),
    [sym_option_mark] = ACTIONS(1),
    [aux_sym_label_token1] = ACTIONS(1),
    [aux_sym_label_token2] = ACTIONS(1),
    [aux_sym_code_text_token1] = ACTIONS(1),
    [aux_sym_list_token1] = ACTIONS(1),
    [sym_hide_start] = ACTIONS(1),
    [sym_hide_end] = ACTIONS(1),
    [aux_sym_condition_block_token1] = ACTIONS(1),
    [aux_sym_condition_block_token2] = ACTIONS(1),
    [aux_sym_tag_token1] = ACTIONS(1),
    [sym_tag_delimiter] = ACTIONS(1),
    [sym_boolean] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym_string_token2] = ACTIONS(1),
    [sym_ref] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_assignment] = ACTIONS(1),
    [sym_dot] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [sym_arrow] = ACTIONS(1),
    [sym_double_arrow] = ACTIONS(1),
    [sym_back_arrow] = ACTIONS(1),
    [sym_block_comment_start] = ACTIONS(3),
    [sym_block_comment_end] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(5),
    [sym_glue] = ACTIONS(1),
    [sym_line_start] = ACTIONS(1),
    [sym_stitch_start] = ACTIONS(1),
    [sym_knot_start] = ACTIONS(1),
    [sym_function_start] = ACTIONS(1),
    [sym_var_start] = ACTIONS(1),
    [sym_const_start] = ACTIONS(1),
    [sym_list_start] = ACTIONS(1),
    [sym_empty_line] = ACTIONS(1),
    [sym_line_end] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(256),
    [sym_block_comment] = STATE(1),
    [sym_knot] = STATE(154),
    [sym_knot_header] = STATE(9),
    [sym_weave_body] = STATE(80),
    [sym_weave_body_line] = STATE(64),
    [sym_function] = STATE(154),
    [sym_var_line] = STATE(64),
    [sym_const_line] = STATE(64),
    [sym_list_line] = STATE(64),
    [sym_function_header] = STATE(15),
    [aux_sym_program_repeat1] = STATE(83),
    [aux_sym_weave_body_repeat1] = STATE(18),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_block_comment_start] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(5),
    [sym_line_start] = ACTIONS(9),
    [sym_knot_start] = ACTIONS(11),
    [sym_function_start] = ACTIONS(13),
    [sym_var_start] = ACTIONS(15),
    [sym_const_start] = ACTIONS(17),
    [sym_list_start] = ACTIONS(19),
    [sym_empty_line] = ACTIONS(21),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      aux_sym_gather_mark_token1,
    ACTIONS(25), 1,
      sym_option_mark,
    ACTIONS(27), 1,
      aux_sym_code_text_token1,
    ACTIONS(29), 1,
      aux_sym_condition_block_token1,
    ACTIONS(31), 1,
      aux_sym_tag_token1,
    ACTIONS(33), 1,
      sym_vocabulary,
    ACTIONS(35), 1,
      aux_sym_other_token1,
    ACTIONS(37), 1,
      sym_arrow,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(41), 1,
      sym_back_arrow,
    ACTIONS(43), 1,
      sym_glue,
    ACTIONS(45), 1,
      sym_line_end,
    STATE(2), 1,
      sym_block_comment,
    STATE(4), 1,
      aux_sym_option_text_repeat1,
    STATE(5), 1,
      sym_gather_mark,
    STATE(16), 1,
      aux_sym_text_repeat1,
    STATE(23), 1,
      sym_text,
    STATE(24), 1,
      aux_sym_gather_mark_repeat1,
    STATE(29), 1,
      aux_sym_other_repeat1,
    STATE(37), 1,
      sym_condition_block,
    STATE(84), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(229), 1,
      sym_divert_return,
    STATE(42), 2,
      sym_inline_block,
      sym_other,
    STATE(217), 2,
      sym_divert_chain,
      sym_thread,
    STATE(251), 3,
      sym_divert_or_thread,
      sym_condition_text,
      sym_tag,
    STATE(245), 4,
      sym_gather_text,
      sym_option_text,
      sym_code_text,
      sym_dialog_text,
  [95] = 29,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      aux_sym_gather_mark_token1,
    ACTIONS(25), 1,
      sym_option_mark,
    ACTIONS(27), 1,
      aux_sym_code_text_token1,
    ACTIONS(29), 1,
      aux_sym_condition_block_token1,
    ACTIONS(31), 1,
      aux_sym_tag_token1,
    ACTIONS(33), 1,
      sym_vocabulary,
    ACTIONS(35), 1,
      aux_sym_other_token1,
    ACTIONS(37), 1,
      sym_arrow,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(41), 1,
      sym_back_arrow,
    ACTIONS(43), 1,
      sym_glue,
    ACTIONS(47), 1,
      sym_line_end,
    STATE(3), 1,
      sym_block_comment,
    STATE(4), 1,
      aux_sym_option_text_repeat1,
    STATE(5), 1,
      sym_gather_mark,
    STATE(16), 1,
      aux_sym_text_repeat1,
    STATE(23), 1,
      sym_text,
    STATE(24), 1,
      aux_sym_gather_mark_repeat1,
    STATE(29), 1,
      aux_sym_other_repeat1,
    STATE(37), 1,
      sym_condition_block,
    STATE(84), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(229), 1,
      sym_divert_return,
    STATE(42), 2,
      sym_inline_block,
      sym_other,
    STATE(217), 2,
      sym_divert_chain,
      sym_thread,
    STATE(251), 3,
      sym_divert_or_thread,
      sym_condition_text,
      sym_tag,
    STATE(236), 4,
      sym_gather_text,
      sym_option_text,
      sym_code_text,
      sym_dialog_text,
  [190] = 25,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_option_mark,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(41), 1,
      sym_back_arrow,
    ACTIONS(49), 1,
      aux_sym_label_token1,
    ACTIONS(53), 1,
      aux_sym_condition_block_token1,
    ACTIONS(55), 1,
      aux_sym_word_other_token1,
    ACTIONS(57), 1,
      sym_arrow,
    ACTIONS(59), 1,
      sym_glue,
    ACTIONS(61), 1,
      sym_line_end,
    STATE(4), 1,
      sym_block_comment,
    STATE(7), 1,
      sym_label,
    STATE(12), 1,
      aux_sym_words_repeat1,
    STATE(17), 1,
      aux_sym_option_text_repeat1,
    STATE(26), 1,
      sym_words,
    STATE(27), 1,
      aux_sym_word_other_repeat1,
    STATE(84), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(222), 1,
      sym_option_words,
    STATE(229), 1,
      sym_divert_return,
    STATE(31), 2,
      sym_inline_block,
      sym_word_other,
    STATE(217), 2,
      sym_divert_chain,
      sym_thread,
    STATE(225), 2,
      sym_default_option_mark,
      sym_divert_or_thread,
    ACTIONS(51), 3,
      sym_hide_start,
      sym_hide_end,
      sym_vocabulary,
  [271] = 25,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      aux_sym_condition_block_token1,
    ACTIONS(31), 1,
      aux_sym_tag_token1,
    ACTIONS(33), 1,
      sym_vocabulary,
    ACTIONS(35), 1,
      aux_sym_other_token1,
    ACTIONS(37), 1,
      sym_arrow,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(41), 1,
      sym_back_arrow,
    ACTIONS(43), 1,
      sym_glue,
    ACTIONS(63), 1,
      aux_sym_label_token1,
    ACTIONS(65), 1,
      sym_line_end,
    STATE(5), 1,
      sym_block_comment,
    STATE(6), 1,
      sym_label,
    STATE(16), 1,
      aux_sym_text_repeat1,
    STATE(23), 1,
      sym_text,
    STATE(29), 1,
      aux_sym_other_repeat1,
    STATE(37), 1,
      sym_condition_block,
    STATE(84), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(229), 1,
      sym_divert_return,
    STATE(253), 1,
      sym_dialog_text,
    STATE(42), 2,
      sym_inline_block,
      sym_other,
    STATE(217), 2,
      sym_divert_chain,
      sym_thread,
    STATE(251), 3,
      sym_divert_or_thread,
      sym_condition_text,
      sym_tag,
  [351] = 23,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(29), 1,
      aux_sym_condition_block_token1,
    ACTIONS(31), 1,
      aux_sym_tag_token1,
    ACTIONS(33), 1,
      sym_vocabulary,
    ACTIONS(35), 1,
      aux_sym_other_token1,
    ACTIONS(37), 1,
      sym_arrow,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(41), 1,
      sym_back_arrow,
    ACTIONS(43), 1,
      sym_glue,
    ACTIONS(67), 1,
      sym_line_end,
    STATE(6), 1,
      sym_block_comment,
    STATE(16), 1,
      aux_sym_text_repeat1,
    STATE(23), 1,
      sym_text,
    STATE(29), 1,
      aux_sym_other_repeat1,
    STATE(37), 1,
      sym_condition_block,
    STATE(84), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(229), 1,
      sym_divert_return,
    STATE(233), 1,
      sym_dialog_text,
    STATE(42), 2,
      sym_inline_block,
      sym_other,
    STATE(217), 2,
      sym_divert_chain,
      sym_thread,
    STATE(251), 3,
      sym_divert_or_thread,
      sym_condition_text,
      sym_tag,
  [425] = 21,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(41), 1,
      sym_back_arrow,
    ACTIONS(53), 1,
      aux_sym_condition_block_token1,
    ACTIONS(55), 1,
      aux_sym_word_other_token1,
    ACTIONS(57), 1,
      sym_arrow,
    ACTIONS(59), 1,
      sym_glue,
    ACTIONS(69), 1,
      sym_line_end,
    STATE(7), 1,
      sym_block_comment,
    STATE(12), 1,
      aux_sym_words_repeat1,
    STATE(26), 1,
      sym_words,
    STATE(27), 1,
      aux_sym_word_other_repeat1,
    STATE(84), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(229), 1,
      sym_divert_return,
    STATE(248), 1,
      sym_option_words,
    STATE(31), 2,
      sym_inline_block,
      sym_word_other,
    STATE(217), 2,
      sym_divert_chain,
      sym_thread,
    STATE(225), 2,
      sym_default_option_mark,
      sym_divert_or_thread,
    ACTIONS(51), 3,
      sym_hide_start,
      sym_hide_end,
      sym_vocabulary,
  [494] = 18,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_line_start,
    ACTIONS(11), 1,
      sym_knot_start,
    ACTIONS(13), 1,
      sym_function_start,
    ACTIONS(15), 1,
      sym_var_start,
    ACTIONS(17), 1,
      sym_const_start,
    ACTIONS(19), 1,
      sym_list_start,
    ACTIONS(71), 1,
      ts_builtin_sym_end,
    ACTIONS(73), 1,
      sym_empty_line,
    STATE(8), 1,
      sym_block_comment,
    STATE(9), 1,
      sym_knot_header,
    STATE(15), 1,
      sym_function_header,
    STATE(18), 1,
      aux_sym_weave_body_repeat1,
    STATE(78), 1,
      sym_weave_body,
    STATE(82), 1,
      aux_sym_program_repeat1,
    STATE(154), 2,
      sym_knot,
      sym_function,
    STATE(64), 4,
      sym_weave_body_line,
      sym_var_line,
      sym_const_line,
      sym_list_line,
  [553] = 16,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(77), 1,
      sym_line_start,
    ACTIONS(79), 1,
      sym_stitch_start,
    ACTIONS(81), 1,
      sym_var_start,
    ACTIONS(83), 1,
      sym_const_start,
    ACTIONS(85), 1,
      sym_list_start,
    ACTIONS(87), 1,
      sym_empty_line,
    STATE(9), 1,
      sym_block_comment,
    STATE(10), 1,
      sym_stitch_header,
    STATE(13), 1,
      aux_sym_weave_body_repeat1,
    STATE(85), 1,
      aux_sym_knot_repeat1,
    STATE(86), 1,
      sym_weave_body,
    STATE(144), 1,
      sym_stitch,
    ACTIONS(75), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
    STATE(53), 4,
      sym_weave_body_line,
      sym_var_line,
      sym_const_line,
      sym_list_line,
  [607] = 12,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(77), 1,
      sym_line_start,
    ACTIONS(81), 1,
      sym_var_start,
    ACTIONS(83), 1,
      sym_const_start,
    ACTIONS(85), 1,
      sym_list_start,
    ACTIONS(87), 1,
      sym_empty_line,
    STATE(10), 1,
      sym_block_comment,
    STATE(13), 1,
      aux_sym_weave_body_repeat1,
    STATE(145), 1,
      sym_weave_body,
    ACTIONS(89), 4,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
    STATE(53), 4,
      sym_weave_body_line,
      sym_var_line,
      sym_const_line,
      sym_list_line,
  [650] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(94), 1,
      aux_sym_condition_block_token1,
    ACTIONS(97), 1,
      aux_sym_word_other_token1,
    ACTIONS(102), 1,
      sym_glue,
    STATE(27), 1,
      aux_sym_word_other_repeat1,
    STATE(11), 2,
      sym_block_comment,
      aux_sym_words_repeat1,
    STATE(31), 2,
      sym_inline_block,
      sym_word_other,
    ACTIONS(91), 3,
      sym_hide_start,
      sym_hide_end,
      sym_vocabulary,
    ACTIONS(100), 4,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_line_end,
  [688] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(53), 1,
      aux_sym_condition_block_token1,
    ACTIONS(55), 1,
      aux_sym_word_other_token1,
    ACTIONS(59), 1,
      sym_glue,
    STATE(11), 1,
      aux_sym_words_repeat1,
    STATE(12), 1,
      sym_block_comment,
    STATE(27), 1,
      aux_sym_word_other_repeat1,
    STATE(31), 2,
      sym_inline_block,
      sym_word_other,
    ACTIONS(51), 3,
      sym_hide_start,
      sym_hide_end,
      sym_vocabulary,
    ACTIONS(105), 4,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_line_end,
  [728] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(77), 1,
      sym_line_start,
    ACTIONS(81), 1,
      sym_var_start,
    ACTIONS(83), 1,
      sym_const_start,
    ACTIONS(85), 1,
      sym_list_start,
    ACTIONS(87), 1,
      sym_empty_line,
    STATE(13), 1,
      sym_block_comment,
    STATE(14), 1,
      aux_sym_weave_body_repeat1,
    ACTIONS(107), 4,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
    STATE(53), 4,
      sym_weave_body_line,
      sym_var_line,
      sym_const_line,
      sym_list_line,
  [768] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(111), 1,
      sym_line_start,
    ACTIONS(114), 1,
      sym_var_start,
    ACTIONS(117), 1,
      sym_const_start,
    ACTIONS(120), 1,
      sym_list_start,
    ACTIONS(123), 1,
      sym_empty_line,
    STATE(14), 2,
      sym_block_comment,
      aux_sym_weave_body_repeat1,
    ACTIONS(109), 4,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
    STATE(53), 4,
      sym_weave_body_line,
      sym_var_line,
      sym_const_line,
      sym_list_line,
  [806] = 12,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_line_start,
    ACTIONS(15), 1,
      sym_var_start,
    ACTIONS(17), 1,
      sym_const_start,
    ACTIONS(19), 1,
      sym_list_start,
    ACTIONS(73), 1,
      sym_empty_line,
    STATE(15), 1,
      sym_block_comment,
    STATE(18), 1,
      aux_sym_weave_body_repeat1,
    STATE(169), 1,
      sym_weave_body,
    ACTIONS(126), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
    STATE(64), 4,
      sym_weave_body_line,
      sym_var_line,
      sym_const_line,
      sym_list_line,
  [848] = 12,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(33), 1,
      sym_vocabulary,
    ACTIONS(35), 1,
      aux_sym_other_token1,
    ACTIONS(43), 1,
      sym_glue,
    ACTIONS(128), 1,
      aux_sym_condition_block_token1,
    ACTIONS(130), 1,
      aux_sym_tag_token1,
    STATE(16), 1,
      sym_block_comment,
    STATE(20), 1,
      aux_sym_text_repeat1,
    STATE(29), 1,
      aux_sym_other_repeat1,
    STATE(42), 2,
      sym_inline_block,
      sym_other,
    ACTIONS(132), 4,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_line_end,
  [889] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(134), 1,
      sym_option_mark,
    STATE(17), 2,
      sym_block_comment,
      aux_sym_option_text_repeat1,
    ACTIONS(139), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
    ACTIONS(137), 6,
      aux_sym_label_token1,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_word_other_token1,
  [918] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(9), 1,
      sym_line_start,
    ACTIONS(15), 1,
      sym_var_start,
    ACTIONS(17), 1,
      sym_const_start,
    ACTIONS(19), 1,
      sym_list_start,
    ACTIONS(73), 1,
      sym_empty_line,
    STATE(18), 1,
      sym_block_comment,
    STATE(19), 1,
      aux_sym_weave_body_repeat1,
    ACTIONS(107), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
    STATE(64), 4,
      sym_weave_body_line,
      sym_var_line,
      sym_const_line,
      sym_list_line,
  [957] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(141), 1,
      sym_line_start,
    ACTIONS(144), 1,
      sym_var_start,
    ACTIONS(147), 1,
      sym_const_start,
    ACTIONS(150), 1,
      sym_list_start,
    ACTIONS(153), 1,
      sym_empty_line,
    STATE(19), 2,
      sym_block_comment,
      aux_sym_weave_body_repeat1,
    ACTIONS(109), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
    STATE(64), 4,
      sym_weave_body_line,
      sym_var_line,
      sym_const_line,
      sym_list_line,
  [994] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(156), 1,
      aux_sym_condition_block_token1,
    ACTIONS(159), 1,
      aux_sym_tag_token1,
    ACTIONS(161), 1,
      sym_vocabulary,
    ACTIONS(164), 1,
      aux_sym_other_token1,
    ACTIONS(169), 1,
      sym_glue,
    STATE(29), 1,
      aux_sym_other_repeat1,
    STATE(20), 2,
      sym_block_comment,
      aux_sym_text_repeat1,
    STATE(42), 2,
      sym_inline_block,
      sym_other,
    ACTIONS(167), 4,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_line_end,
  [1033] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(21), 1,
      sym_block_comment,
    ACTIONS(174), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
    ACTIONS(172), 7,
      sym_option_mark,
      aux_sym_label_token1,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_word_other_token1,
  [1059] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(176), 1,
      aux_sym_gather_mark_token1,
    STATE(22), 2,
      sym_block_comment,
      aux_sym_gather_mark_repeat1,
    ACTIONS(179), 5,
      aux_sym_label_token1,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
      aux_sym_other_token1,
    ACTIONS(181), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1087] = 13,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(37), 1,
      sym_arrow,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(41), 1,
      sym_back_arrow,
    ACTIONS(183), 1,
      aux_sym_tag_token1,
    ACTIONS(185), 1,
      sym_line_end,
    STATE(23), 1,
      sym_block_comment,
    STATE(84), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(229), 1,
      sym_divert_return,
    STATE(217), 2,
      sym_divert_chain,
      sym_thread,
    STATE(254), 2,
      sym_divert_or_thread,
      sym_tag,
  [1129] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(23), 1,
      aux_sym_gather_mark_token1,
    STATE(22), 1,
      aux_sym_gather_mark_repeat1,
    STATE(24), 1,
      sym_block_comment,
    ACTIONS(187), 5,
      aux_sym_label_token1,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
      aux_sym_other_token1,
    ACTIONS(189), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1159] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(25), 1,
      sym_block_comment,
    ACTIONS(193), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
    ACTIONS(191), 6,
      aux_sym_gather_mark_token1,
      aux_sym_label_token1,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
      aux_sym_other_token1,
  [1184] = 12,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(41), 1,
      sym_back_arrow,
    ACTIONS(57), 1,
      sym_arrow,
    ACTIONS(195), 1,
      sym_line_end,
    STATE(26), 1,
      sym_block_comment,
    STATE(84), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(229), 1,
      sym_divert_return,
    STATE(217), 2,
      sym_divert_chain,
      sym_thread,
    STATE(238), 2,
      sym_default_option_mark,
      sym_divert_or_thread,
  [1223] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(55), 1,
      aux_sym_word_other_token1,
    STATE(27), 1,
      sym_block_comment,
    STATE(28), 1,
      aux_sym_word_other_repeat1,
    ACTIONS(197), 4,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
    ACTIONS(199), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1252] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(203), 1,
      aux_sym_word_other_token1,
    STATE(28), 2,
      sym_block_comment,
      aux_sym_word_other_repeat1,
    ACTIONS(201), 4,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
    ACTIONS(206), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1279] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(35), 1,
      aux_sym_other_token1,
    STATE(29), 1,
      sym_block_comment,
    STATE(33), 1,
      aux_sym_other_repeat1,
    ACTIONS(208), 3,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
    ACTIONS(210), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1307] = 13,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(214), 1,
      aux_sym_condition_block_token2,
    ACTIONS(216), 1,
      sym_block_remainder,
    ACTIONS(218), 1,
      sym_line_end,
    STATE(30), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(113), 1,
      aux_sym_inline_block_repeat1,
    STATE(130), 1,
      sym_inline_block,
    STATE(161), 1,
      sym_condition_block,
    STATE(170), 1,
      sym_condition_block_nested,
    STATE(226), 1,
      sym_condition_block_content,
  [1347] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(31), 1,
      sym_block_comment,
    ACTIONS(220), 5,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_word_other_token1,
    ACTIONS(222), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1371] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(32), 1,
      sym_block_comment,
    ACTIONS(224), 5,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_word_other_token1,
    ACTIONS(226), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1395] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(230), 1,
      aux_sym_other_token1,
    STATE(33), 2,
      sym_block_comment,
      aux_sym_other_repeat1,
    ACTIONS(228), 3,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
    ACTIONS(233), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1421] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(34), 1,
      sym_block_comment,
    ACTIONS(235), 5,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_word_other_token1,
    ACTIONS(237), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1445] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(35), 1,
      sym_block_comment,
    ACTIONS(239), 5,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_word_other_token1,
    ACTIONS(241), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1469] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(36), 1,
      sym_block_comment,
    ACTIONS(243), 5,
      sym_hide_start,
      sym_hide_end,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_word_other_token1,
    ACTIONS(245), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1493] = 12,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(247), 1,
      aux_sym_condition_block_token1,
    ACTIONS(249), 1,
      sym_vocabulary,
    ACTIONS(251), 1,
      aux_sym_other_token1,
    ACTIONS(253), 1,
      sym_glue,
    ACTIONS(255), 1,
      sym_line_end,
    STATE(37), 1,
      sym_block_comment,
    STATE(55), 1,
      aux_sym_text_repeat1,
    STATE(97), 1,
      aux_sym_other_repeat1,
    STATE(201), 1,
      sym_text,
    STATE(105), 2,
      sym_inline_block,
      sym_other,
  [1531] = 13,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(216), 1,
      sym_block_remainder,
    ACTIONS(257), 1,
      aux_sym_condition_block_token2,
    ACTIONS(259), 1,
      sym_line_end,
    STATE(38), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(122), 1,
      aux_sym_inline_block_repeat1,
    STATE(130), 1,
      sym_inline_block,
    STATE(161), 1,
      sym_condition_block,
    STATE(170), 1,
      sym_condition_block_nested,
    STATE(262), 1,
      sym_condition_block_content,
  [1571] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(261), 1,
      aux_sym_condition_block_token2,
    ACTIONS(263), 1,
      sym_block_remainder,
    ACTIONS(265), 1,
      sym_line_end,
    STATE(39), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(161), 1,
      sym_condition_block,
    STATE(224), 1,
      sym_condition_block_content,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [1606] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(263), 1,
      sym_block_remainder,
    ACTIONS(265), 1,
      sym_line_end,
    ACTIONS(267), 1,
      aux_sym_condition_block_token2,
    STATE(40), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(161), 1,
      sym_condition_block,
    STATE(224), 1,
      sym_condition_block_content,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [1641] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(41), 1,
      sym_block_comment,
    ACTIONS(269), 4,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
      aux_sym_other_token1,
    ACTIONS(271), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1664] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(42), 1,
      sym_block_comment,
    ACTIONS(273), 4,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
      aux_sym_other_token1,
    ACTIONS(275), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1687] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(43), 1,
      sym_block_comment,
    ACTIONS(277), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [1708] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(263), 1,
      sym_block_remainder,
    ACTIONS(265), 1,
      sym_line_end,
    ACTIONS(279), 1,
      aux_sym_condition_block_token2,
    STATE(44), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(161), 1,
      sym_condition_block,
    STATE(224), 1,
      sym_condition_block_content,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [1743] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(45), 1,
      sym_block_comment,
    ACTIONS(243), 4,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
      aux_sym_other_token1,
    ACTIONS(245), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1766] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(46), 1,
      sym_block_comment,
    ACTIONS(281), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [1787] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(47), 1,
      sym_block_comment,
    ACTIONS(283), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [1808] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(263), 1,
      sym_block_remainder,
    ACTIONS(265), 1,
      sym_line_end,
    ACTIONS(285), 1,
      aux_sym_condition_block_token2,
    STATE(48), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(161), 1,
      sym_condition_block,
    STATE(224), 1,
      sym_condition_block_content,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [1843] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(49), 1,
      sym_block_comment,
    ACTIONS(235), 4,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
      aux_sym_other_token1,
    ACTIONS(237), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [1866] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(50), 1,
      sym_block_comment,
    ACTIONS(287), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [1887] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(247), 1,
      aux_sym_condition_block_token1,
    ACTIONS(249), 1,
      sym_vocabulary,
    ACTIONS(251), 1,
      aux_sym_other_token1,
    ACTIONS(253), 1,
      sym_glue,
    STATE(51), 1,
      sym_block_comment,
    STATE(55), 1,
      aux_sym_text_repeat1,
    STATE(97), 1,
      aux_sym_other_repeat1,
    STATE(211), 1,
      sym_text,
    STATE(105), 2,
      sym_inline_block,
      sym_other,
  [1922] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(263), 1,
      sym_block_remainder,
    ACTIONS(265), 1,
      sym_line_end,
    ACTIONS(289), 1,
      aux_sym_condition_block_token2,
    STATE(52), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(161), 1,
      sym_condition_block,
    STATE(224), 1,
      sym_condition_block_content,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [1957] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(53), 1,
      sym_block_comment,
    ACTIONS(291), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [1978] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(54), 1,
      sym_block_comment,
    ACTIONS(293), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [1999] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(132), 1,
      sym_line_end,
    ACTIONS(247), 1,
      aux_sym_condition_block_token1,
    ACTIONS(249), 1,
      sym_vocabulary,
    ACTIONS(251), 1,
      aux_sym_other_token1,
    ACTIONS(253), 1,
      sym_glue,
    STATE(55), 1,
      sym_block_comment,
    STATE(57), 1,
      aux_sym_text_repeat1,
    STATE(97), 1,
      aux_sym_other_repeat1,
    STATE(105), 2,
      sym_inline_block,
      sym_other,
  [2034] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(56), 1,
      sym_block_comment,
    ACTIONS(295), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2055] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(167), 1,
      sym_line_end,
    ACTIONS(297), 1,
      aux_sym_condition_block_token1,
    ACTIONS(300), 1,
      sym_vocabulary,
    ACTIONS(303), 1,
      aux_sym_other_token1,
    ACTIONS(306), 1,
      sym_glue,
    STATE(97), 1,
      aux_sym_other_repeat1,
    STATE(57), 2,
      sym_block_comment,
      aux_sym_text_repeat1,
    STATE(105), 2,
      sym_inline_block,
      sym_other,
  [2088] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(58), 1,
      sym_block_comment,
    ACTIONS(309), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2109] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(59), 1,
      sym_block_comment,
    ACTIONS(311), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2130] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(60), 1,
      sym_block_comment,
    ACTIONS(313), 9,
      sym_line_start,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2151] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(61), 1,
      sym_block_comment,
    ACTIONS(239), 4,
      aux_sym_condition_block_token1,
      aux_sym_tag_token1,
      sym_vocabulary,
      aux_sym_other_token1,
    ACTIONS(241), 5,
      sym_arrow,
      sym_double_arrow,
      sym_back_arrow,
      sym_glue,
      sym_line_end,
  [2174] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(263), 1,
      sym_block_remainder,
    ACTIONS(265), 1,
      sym_line_end,
    ACTIONS(315), 1,
      aux_sym_condition_block_token2,
    STATE(62), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(161), 1,
      sym_condition_block,
    STATE(224), 1,
      sym_condition_block_content,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [2209] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(63), 1,
      sym_block_comment,
    ACTIONS(313), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2229] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(64), 1,
      sym_block_comment,
    ACTIONS(291), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2249] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(65), 1,
      sym_block_comment,
    ACTIONS(309), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2269] = 9,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(317), 1,
      ts_builtin_sym_end,
    ACTIONS(319), 1,
      sym_knot_start,
    ACTIONS(322), 1,
      sym_function_start,
    STATE(9), 1,
      sym_knot_header,
    STATE(15), 1,
      sym_function_header,
    STATE(66), 2,
      sym_block_comment,
      aux_sym_program_repeat1,
    STATE(154), 2,
      sym_knot,
      sym_function,
  [2299] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(325), 1,
      aux_sym_knot_header_token1,
    ACTIONS(327), 1,
      aux_sym_label_token1,
    ACTIONS(329), 1,
      aux_sym_label_token2,
    ACTIONS(331), 1,
      sym_ref,
    ACTIONS(333), 1,
      sym_identifier,
    ACTIONS(335), 1,
      sym_line_end,
    STATE(67), 1,
      sym_block_comment,
    STATE(127), 1,
      sym_argument,
    STATE(162), 1,
      sym_arguments,
  [2333] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(68), 1,
      sym_block_comment,
    ACTIONS(337), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2353] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(69), 1,
      sym_block_comment,
    ACTIONS(311), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2373] = 11,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(331), 1,
      sym_ref,
    ACTIONS(333), 1,
      sym_identifier,
    ACTIONS(339), 1,
      aux_sym_knot_header_token1,
    ACTIONS(341), 1,
      aux_sym_label_token1,
    ACTIONS(343), 1,
      aux_sym_label_token2,
    ACTIONS(345), 1,
      sym_line_end,
    STATE(70), 1,
      sym_block_comment,
    STATE(127), 1,
      sym_argument,
    STATE(149), 1,
      sym_arguments,
  [2407] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(71), 1,
      sym_block_comment,
    ACTIONS(347), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2427] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(72), 1,
      sym_block_comment,
    ACTIONS(349), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2447] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(263), 1,
      sym_block_remainder,
    ACTIONS(265), 1,
      sym_line_end,
    STATE(73), 1,
      sym_block_comment,
    STATE(89), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(161), 1,
      sym_condition_block,
    STATE(224), 1,
      sym_condition_block_content,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [2479] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(74), 1,
      sym_block_comment,
    ACTIONS(293), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2499] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(75), 1,
      sym_block_comment,
    ACTIONS(351), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2519] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(76), 1,
      sym_block_comment,
    ACTIONS(353), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2539] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(77), 1,
      sym_block_comment,
    ACTIONS(355), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2559] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      sym_knot_start,
    ACTIONS(13), 1,
      sym_function_start,
    ACTIONS(357), 1,
      ts_builtin_sym_end,
    STATE(9), 1,
      sym_knot_header,
    STATE(15), 1,
      sym_function_header,
    STATE(78), 1,
      sym_block_comment,
    STATE(79), 1,
      aux_sym_program_repeat1,
    STATE(154), 2,
      sym_knot,
      sym_function,
  [2591] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      sym_knot_start,
    ACTIONS(13), 1,
      sym_function_start,
    ACTIONS(359), 1,
      ts_builtin_sym_end,
    STATE(9), 1,
      sym_knot_header,
    STATE(15), 1,
      sym_function_header,
    STATE(66), 1,
      aux_sym_program_repeat1,
    STATE(79), 1,
      sym_block_comment,
    STATE(154), 2,
      sym_knot,
      sym_function,
  [2623] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      sym_knot_start,
    ACTIONS(13), 1,
      sym_function_start,
    ACTIONS(71), 1,
      ts_builtin_sym_end,
    STATE(9), 1,
      sym_knot_header,
    STATE(15), 1,
      sym_function_header,
    STATE(80), 1,
      sym_block_comment,
    STATE(82), 1,
      aux_sym_program_repeat1,
    STATE(154), 2,
      sym_knot,
      sym_function,
  [2655] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(81), 1,
      sym_block_comment,
    ACTIONS(295), 8,
      sym_line_start,
      sym_knot_start,
      sym_function_start,
      sym_var_start,
      sym_const_start,
      sym_list_start,
      sym_empty_line,
      ts_builtin_sym_end,
  [2675] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      sym_knot_start,
    ACTIONS(13), 1,
      sym_function_start,
    ACTIONS(357), 1,
      ts_builtin_sym_end,
    STATE(9), 1,
      sym_knot_header,
    STATE(15), 1,
      sym_function_header,
    STATE(66), 1,
      aux_sym_program_repeat1,
    STATE(82), 1,
      sym_block_comment,
    STATE(154), 2,
      sym_knot,
      sym_function,
  [2707] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(11), 1,
      sym_knot_start,
    ACTIONS(13), 1,
      sym_function_start,
    ACTIONS(71), 1,
      ts_builtin_sym_end,
    STATE(9), 1,
      sym_knot_header,
    STATE(15), 1,
      sym_function_header,
    STATE(66), 1,
      aux_sym_program_repeat1,
    STATE(83), 1,
      sym_block_comment,
    STATE(154), 2,
      sym_knot,
      sym_function,
  [2739] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(361), 1,
      sym_arrow,
    ACTIONS(363), 1,
      sym_line_end,
    STATE(84), 1,
      sym_block_comment,
    STATE(111), 1,
      aux_sym_divert_chain_repeat1,
    STATE(151), 1,
      sym_divert,
    STATE(156), 1,
      sym_divert_continue,
    STATE(208), 1,
      sym_divert_return,
  [2770] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_stitch_start,
    STATE(10), 1,
      sym_stitch_header,
    STATE(85), 1,
      sym_block_comment,
    STATE(91), 1,
      aux_sym_knot_repeat1,
    STATE(144), 1,
      sym_stitch,
    ACTIONS(365), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
  [2797] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_stitch_start,
    STATE(10), 1,
      sym_stitch_header,
    STATE(86), 1,
      sym_block_comment,
    STATE(90), 1,
      aux_sym_knot_repeat1,
    STATE(144), 1,
      sym_stitch,
    ACTIONS(365), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
  [2824] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(331), 1,
      sym_ref,
    ACTIONS(333), 1,
      sym_identifier,
    ACTIONS(367), 1,
      aux_sym_knot_header_token1,
    ACTIONS(369), 1,
      aux_sym_label_token2,
    ACTIONS(371), 1,
      sym_line_end,
    STATE(87), 1,
      sym_block_comment,
    STATE(127), 1,
      sym_argument,
    STATE(155), 1,
      sym_arguments,
  [2855] = 10,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(331), 1,
      sym_ref,
    ACTIONS(333), 1,
      sym_identifier,
    ACTIONS(339), 1,
      aux_sym_knot_header_token1,
    ACTIONS(343), 1,
      aux_sym_label_token2,
    ACTIONS(345), 1,
      sym_line_end,
    STATE(88), 1,
      sym_block_comment,
    STATE(127), 1,
      sym_argument,
    STATE(149), 1,
      sym_arguments,
  [2886] = 9,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(212), 1,
      aux_sym_condition_block_token1,
    ACTIONS(263), 1,
      sym_block_remainder,
    ACTIONS(373), 1,
      sym_line_end,
    STATE(89), 1,
      sym_block_comment,
    STATE(92), 1,
      aux_sym_condition_block_content_repeat1,
    STATE(161), 1,
      sym_condition_block,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [2915] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_stitch_start,
    STATE(10), 1,
      sym_stitch_header,
    STATE(90), 1,
      sym_block_comment,
    STATE(91), 1,
      aux_sym_knot_repeat1,
    STATE(144), 1,
      sym_stitch,
    ACTIONS(375), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
  [2942] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(379), 1,
      sym_stitch_start,
    STATE(10), 1,
      sym_stitch_header,
    STATE(144), 1,
      sym_stitch,
    STATE(91), 2,
      sym_block_comment,
      aux_sym_knot_repeat1,
    ACTIONS(377), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
  [2967] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(382), 1,
      aux_sym_condition_block_token1,
    ACTIONS(385), 1,
      sym_block_remainder,
    ACTIONS(388), 1,
      sym_line_end,
    STATE(161), 1,
      sym_condition_block,
    STATE(92), 2,
      sym_block_comment,
      aux_sym_condition_block_content_repeat1,
    STATE(170), 2,
      sym_condition_block_nested,
      sym_inline_block,
  [2994] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(392), 1,
      anon_sym_DQUOTE,
    STATE(93), 1,
      sym_block_comment,
    STATE(243), 1,
      sym_value,
    STATE(258), 1,
      sym_string,
    ACTIONS(390), 3,
      sym_boolean,
      sym_number,
      sym_identifier,
  [3018] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(331), 1,
      sym_ref,
    ACTIONS(333), 1,
      sym_identifier,
    STATE(94), 1,
      sym_block_comment,
    STATE(135), 1,
      sym_argument,
    ACTIONS(394), 3,
      sym_line_end,
      aux_sym_knot_header_token1,
      aux_sym_label_token2,
  [3042] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(392), 1,
      anon_sym_DQUOTE,
    STATE(95), 1,
      sym_block_comment,
    STATE(214), 1,
      sym_value,
    STATE(258), 1,
      sym_string,
    ACTIONS(390), 3,
      sym_boolean,
      sym_number,
      sym_identifier,
  [3066] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(392), 1,
      anon_sym_DQUOTE,
    STATE(96), 1,
      sym_block_comment,
    STATE(247), 1,
      sym_value,
    STATE(258), 1,
      sym_string,
    ACTIONS(390), 3,
      sym_boolean,
      sym_number,
      sym_identifier,
  [3090] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(251), 1,
      aux_sym_other_token1,
    STATE(97), 1,
      sym_block_comment,
    STATE(98), 1,
      aux_sym_other_repeat1,
    ACTIONS(208), 2,
      aux_sym_condition_block_token1,
      sym_vocabulary,
    ACTIONS(210), 2,
      sym_glue,
      sym_line_end,
  [3114] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(396), 1,
      aux_sym_other_token1,
    ACTIONS(228), 2,
      aux_sym_condition_block_token1,
      sym_vocabulary,
    ACTIONS(233), 2,
      sym_glue,
      sym_line_end,
    STATE(98), 2,
      sym_block_comment,
      aux_sym_other_repeat1,
  [3136] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(331), 1,
      sym_ref,
    ACTIONS(333), 1,
      sym_identifier,
    STATE(99), 1,
      sym_block_comment,
    STATE(135), 1,
      sym_argument,
    ACTIONS(399), 3,
      sym_line_end,
      aux_sym_knot_header_token1,
      aux_sym_label_token2,
  [3160] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(392), 1,
      anon_sym_DQUOTE,
    STATE(100), 1,
      sym_block_comment,
    STATE(242), 1,
      sym_value,
    STATE(258), 1,
      sym_string,
    ACTIONS(390), 3,
      sym_boolean,
      sym_number,
      sym_identifier,
  [3184] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(401), 1,
      sym_dot,
    STATE(101), 1,
      sym_block_comment,
    STATE(112), 1,
      aux_sym_identifier_path_repeat1,
    ACTIONS(403), 3,
      sym_arrow,
      sym_double_arrow,
      sym_line_end,
  [3205] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(102), 1,
      sym_block_comment,
    ACTIONS(241), 2,
      sym_glue,
      sym_line_end,
    ACTIONS(239), 3,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_other_token1,
  [3224] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(405), 1,
      aux_sym_label_token1,
    ACTIONS(407), 1,
      sym_identifier,
    STATE(103), 1,
      sym_block_comment,
    STATE(166), 1,
      sym_marked_identifier,
    STATE(203), 1,
      sym_list,
    STATE(206), 1,
      sym_mark_start,
  [3249] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(409), 1,
      aux_sym_list_token1,
    STATE(104), 1,
      sym_block_comment,
    STATE(119), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(394), 3,
      sym_line_end,
      aux_sym_knot_header_token1,
      aux_sym_label_token2,
  [3270] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(105), 1,
      sym_block_comment,
    ACTIONS(275), 2,
      sym_glue,
      sym_line_end,
    ACTIONS(273), 3,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_other_token1,
  [3289] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(106), 1,
      sym_block_comment,
    ACTIONS(245), 2,
      sym_glue,
      sym_line_end,
    ACTIONS(243), 3,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_other_token1,
  [3308] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(413), 1,
      aux_sym_condition_block_token2,
    ACTIONS(415), 1,
      sym_block_remainder,
    STATE(107), 1,
      sym_block_comment,
    STATE(117), 1,
      aux_sym_inline_block_repeat1,
    STATE(171), 1,
      sym_inline_block,
  [3333] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(405), 1,
      aux_sym_label_token1,
    ACTIONS(407), 1,
      sym_identifier,
    ACTIONS(417), 1,
      sym_line_end,
    STATE(108), 1,
      sym_block_comment,
    STATE(181), 1,
      sym_marked_identifier,
    STATE(206), 1,
      sym_mark_start,
  [3358] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(109), 1,
      sym_block_comment,
    ACTIONS(421), 2,
      sym_glue,
      sym_line_end,
    ACTIONS(419), 3,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_other_token1,
  [3377] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(423), 1,
      aux_sym_condition_block_token1,
    ACTIONS(426), 1,
      aux_sym_condition_block_token2,
    ACTIONS(428), 1,
      sym_block_remainder,
    STATE(171), 1,
      sym_inline_block,
    STATE(110), 2,
      sym_block_comment,
      aux_sym_inline_block_repeat1,
  [3400] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(431), 1,
      sym_arrow,
    STATE(151), 1,
      sym_divert,
    ACTIONS(434), 2,
      sym_double_arrow,
      sym_line_end,
    STATE(111), 2,
      sym_block_comment,
      aux_sym_divert_chain_repeat1,
  [3421] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(436), 1,
      sym_dot,
    STATE(112), 2,
      sym_block_comment,
      aux_sym_identifier_path_repeat1,
    ACTIONS(439), 3,
      sym_arrow,
      sym_double_arrow,
      sym_line_end,
  [3440] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(415), 1,
      sym_block_remainder,
    ACTIONS(441), 1,
      aux_sym_condition_block_token2,
    STATE(110), 1,
      aux_sym_inline_block_repeat1,
    STATE(113), 1,
      sym_block_comment,
    STATE(171), 1,
      sym_inline_block,
  [3465] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(114), 1,
      sym_block_comment,
    ACTIONS(271), 2,
      sym_glue,
      sym_line_end,
    ACTIONS(269), 3,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_other_token1,
  [3484] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(405), 1,
      aux_sym_label_token1,
    ACTIONS(407), 1,
      sym_identifier,
    ACTIONS(443), 1,
      sym_line_end,
    STATE(115), 1,
      sym_block_comment,
    STATE(181), 1,
      sym_marked_identifier,
    STATE(206), 1,
      sym_mark_start,
  [3509] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(415), 1,
      sym_block_remainder,
    ACTIONS(445), 1,
      aux_sym_condition_block_token2,
    STATE(116), 1,
      sym_block_comment,
    STATE(124), 1,
      aux_sym_inline_block_repeat1,
    STATE(171), 1,
      sym_inline_block,
  [3534] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(415), 1,
      sym_block_remainder,
    ACTIONS(447), 1,
      aux_sym_condition_block_token2,
    STATE(110), 1,
      aux_sym_inline_block_repeat1,
    STATE(117), 1,
      sym_block_comment,
    STATE(171), 1,
      sym_inline_block,
  [3559] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(118), 1,
      sym_block_comment,
    ACTIONS(451), 2,
      sym_glue,
      sym_line_end,
    ACTIONS(449), 3,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_other_token1,
  [3578] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(455), 1,
      aux_sym_list_token1,
    STATE(119), 2,
      sym_block_comment,
      aux_sym_arguments_repeat1,
    ACTIONS(453), 3,
      sym_line_end,
      aux_sym_knot_header_token1,
      aux_sym_label_token2,
  [3597] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(120), 1,
      sym_block_comment,
    ACTIONS(460), 2,
      sym_glue,
      sym_line_end,
    ACTIONS(458), 3,
      aux_sym_condition_block_token1,
      sym_vocabulary,
      aux_sym_other_token1,
  [3616] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(214), 1,
      aux_sym_condition_block_token2,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(415), 1,
      sym_block_remainder,
    STATE(113), 1,
      aux_sym_inline_block_repeat1,
    STATE(121), 1,
      sym_block_comment,
    STATE(171), 1,
      sym_inline_block,
  [3641] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(415), 1,
      sym_block_remainder,
    ACTIONS(462), 1,
      aux_sym_condition_block_token2,
    STATE(110), 1,
      aux_sym_inline_block_repeat1,
    STATE(122), 1,
      sym_block_comment,
    STATE(171), 1,
      sym_inline_block,
  [3666] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(415), 1,
      sym_block_remainder,
    ACTIONS(464), 1,
      aux_sym_condition_block_token2,
    STATE(123), 1,
      sym_block_comment,
    STATE(125), 1,
      aux_sym_inline_block_repeat1,
    STATE(171), 1,
      sym_inline_block,
  [3691] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(415), 1,
      sym_block_remainder,
    ACTIONS(466), 1,
      aux_sym_condition_block_token2,
    STATE(110), 1,
      aux_sym_inline_block_repeat1,
    STATE(124), 1,
      sym_block_comment,
    STATE(171), 1,
      sym_inline_block,
  [3716] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(411), 1,
      aux_sym_condition_block_token1,
    ACTIONS(415), 1,
      sym_block_remainder,
    ACTIONS(468), 1,
      aux_sym_condition_block_token2,
    STATE(110), 1,
      aux_sym_inline_block_repeat1,
    STATE(125), 1,
      sym_block_comment,
    STATE(171), 1,
      sym_inline_block,
  [3741] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(401), 1,
      sym_dot,
    STATE(101), 1,
      aux_sym_identifier_path_repeat1,
    STATE(126), 1,
      sym_block_comment,
    ACTIONS(470), 3,
      sym_arrow,
      sym_double_arrow,
      sym_line_end,
  [3762] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(474), 1,
      aux_sym_list_token1,
    STATE(104), 1,
      aux_sym_arguments_repeat1,
    STATE(127), 1,
      sym_block_comment,
    ACTIONS(472), 3,
      sym_line_end,
      aux_sym_knot_header_token1,
      aux_sym_label_token2,
  [3783] = 8,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(405), 1,
      aux_sym_label_token1,
    ACTIONS(407), 1,
      sym_identifier,
    STATE(128), 1,
      sym_block_comment,
    STATE(166), 1,
      sym_marked_identifier,
    STATE(206), 1,
      sym_mark_start,
    STATE(244), 1,
      sym_list,
  [3808] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(129), 1,
      sym_block_comment,
    ACTIONS(243), 2,
      aux_sym_condition_block_token1,
      aux_sym_condition_block_token2,
    ACTIONS(245), 2,
      sym_line_end,
      sym_block_remainder,
  [3826] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(478), 1,
      sym_block_remainder,
    ACTIONS(480), 1,
      sym_line_end,
    STATE(130), 1,
      sym_block_comment,
    ACTIONS(476), 2,
      aux_sym_condition_block_token1,
      aux_sym_condition_block_token2,
  [3846] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(131), 1,
      sym_block_comment,
    ACTIONS(482), 4,
      sym_line_end,
      aux_sym_knot_header_token1,
      aux_sym_label_token2,
      aux_sym_list_token1,
  [3862] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(484), 1,
      anon_sym_DQUOTE,
    ACTIONS(486), 1,
      aux_sym_string_token1,
    ACTIONS(488), 1,
      aux_sym_string_token2,
    STATE(132), 1,
      sym_block_comment,
    STATE(136), 1,
      aux_sym_string_repeat1,
  [3884] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(490), 1,
      aux_sym_label_token2,
    STATE(133), 1,
      sym_block_comment,
    STATE(177), 1,
      sym_mark_end,
    ACTIONS(492), 2,
      sym_line_end,
      aux_sym_list_token1,
  [3904] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(134), 1,
      sym_block_comment,
    ACTIONS(439), 4,
      sym_arrow,
      sym_double_arrow,
      sym_line_end,
      sym_dot,
  [3920] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(135), 1,
      sym_block_comment,
    ACTIONS(453), 4,
      sym_line_end,
      aux_sym_knot_header_token1,
      aux_sym_label_token2,
      aux_sym_list_token1,
  [3936] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(486), 1,
      aux_sym_string_token1,
    ACTIONS(488), 1,
      aux_sym_string_token2,
    ACTIONS(494), 1,
      anon_sym_DQUOTE,
    STATE(136), 1,
      sym_block_comment,
    STATE(139), 1,
      aux_sym_string_repeat1,
  [3958] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(496), 1,
      aux_sym_block_comment_token1,
    ACTIONS(498), 1,
      aux_sym_block_comment_token2,
    ACTIONS(500), 1,
      sym_block_comment_end,
    STATE(137), 1,
      sym_block_comment,
    STATE(146), 1,
      aux_sym_block_comment_repeat1,
  [3980] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(490), 1,
      aux_sym_label_token2,
    STATE(138), 1,
      sym_block_comment,
    STATE(182), 1,
      sym_mark_end,
    ACTIONS(502), 2,
      sym_line_end,
      aux_sym_list_token1,
  [4000] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(504), 1,
      anon_sym_DQUOTE,
    ACTIONS(506), 1,
      aux_sym_string_token1,
    ACTIONS(509), 1,
      aux_sym_string_token2,
    STATE(139), 2,
      sym_block_comment,
      aux_sym_string_repeat1,
  [4020] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(405), 1,
      aux_sym_label_token1,
    ACTIONS(407), 1,
      sym_identifier,
    STATE(140), 1,
      sym_block_comment,
    STATE(181), 1,
      sym_marked_identifier,
    STATE(206), 1,
      sym_mark_start,
  [4042] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(512), 1,
      sym_identifier,
    STATE(141), 1,
      sym_block_comment,
    STATE(150), 1,
      sym_identifier_path,
    ACTIONS(514), 2,
      sym_double_arrow,
      sym_line_end,
  [4062] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(142), 1,
      sym_block_comment,
    ACTIONS(516), 4,
      sym_line_end,
      aux_sym_knot_header_token1,
      aux_sym_label_token2,
      aux_sym_list_token1,
  [4078] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(143), 1,
      sym_block_comment,
    ACTIONS(239), 2,
      aux_sym_condition_block_token1,
      aux_sym_condition_block_token2,
    ACTIONS(241), 2,
      sym_line_end,
      sym_block_remainder,
  [4096] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(144), 1,
      sym_block_comment,
    ACTIONS(518), 4,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
  [4112] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(145), 1,
      sym_block_comment,
    ACTIONS(520), 4,
      sym_stitch_start,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
  [4128] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(522), 1,
      aux_sym_block_comment_token1,
    ACTIONS(525), 1,
      aux_sym_block_comment_token2,
    ACTIONS(528), 1,
      sym_block_comment_end,
    STATE(146), 2,
      sym_block_comment,
      aux_sym_block_comment_repeat1,
  [4148] = 7,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(496), 1,
      aux_sym_block_comment_token1,
    ACTIONS(498), 1,
      aux_sym_block_comment_token2,
    ACTIONS(530), 1,
      sym_block_comment_end,
    STATE(137), 1,
      aux_sym_block_comment_repeat1,
    STATE(147), 1,
      sym_block_comment,
  [4170] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(331), 1,
      sym_ref,
    ACTIONS(333), 1,
      sym_identifier,
    STATE(135), 1,
      sym_argument,
    STATE(148), 1,
      sym_block_comment,
  [4189] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(367), 1,
      aux_sym_knot_header_token1,
    ACTIONS(369), 1,
      aux_sym_label_token2,
    ACTIONS(371), 1,
      sym_line_end,
    STATE(149), 1,
      sym_block_comment,
  [4208] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(150), 1,
      sym_block_comment,
    ACTIONS(532), 3,
      sym_arrow,
      sym_double_arrow,
      sym_line_end,
  [4223] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(151), 1,
      sym_block_comment,
    ACTIONS(534), 3,
      sym_arrow,
      sym_double_arrow,
      sym_line_end,
  [4238] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(536), 1,
      aux_sym_list_token1,
    ACTIONS(539), 1,
      sym_line_end,
    STATE(152), 2,
      sym_block_comment,
      aux_sym_list_repeat1,
  [4255] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(543), 1,
      aux_sym_block_comment_token2,
    STATE(153), 1,
      sym_block_comment,
    ACTIONS(541), 2,
      sym_block_comment_end,
      aux_sym_block_comment_token1,
  [4272] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(154), 1,
      sym_block_comment,
    ACTIONS(545), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
  [4287] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(547), 1,
      aux_sym_knot_header_token1,
    ACTIONS(549), 1,
      aux_sym_label_token2,
    ACTIONS(551), 1,
      sym_line_end,
    STATE(155), 1,
      sym_block_comment,
  [4306] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(39), 1,
      sym_double_arrow,
    ACTIONS(553), 1,
      sym_line_end,
    STATE(156), 1,
      sym_block_comment,
    STATE(257), 1,
      sym_divert_return,
  [4325] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(470), 1,
      sym_line_end,
    ACTIONS(555), 1,
      sym_dot,
    STATE(157), 1,
      sym_block_comment,
    STATE(158), 1,
      aux_sym_identifier_path_repeat1,
  [4344] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(403), 1,
      sym_line_end,
    ACTIONS(555), 1,
      sym_dot,
    STATE(158), 1,
      sym_block_comment,
    STATE(159), 1,
      aux_sym_identifier_path_repeat1,
  [4363] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(439), 1,
      sym_line_end,
    ACTIONS(557), 1,
      sym_dot,
    STATE(159), 2,
      sym_block_comment,
      aux_sym_identifier_path_repeat1,
  [4380] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(458), 1,
      aux_sym_condition_block_token1,
    STATE(160), 1,
      sym_block_comment,
    ACTIONS(460), 2,
      sym_line_end,
      sym_block_remainder,
  [4397] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(560), 1,
      aux_sym_condition_block_token1,
    STATE(161), 1,
      sym_block_comment,
    ACTIONS(562), 2,
      sym_line_end,
      sym_block_remainder,
  [4414] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(339), 1,
      aux_sym_knot_header_token1,
    ACTIONS(343), 1,
      aux_sym_label_token2,
    ACTIONS(345), 1,
      sym_line_end,
    STATE(162), 1,
      sym_block_comment,
  [4433] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(419), 1,
      aux_sym_condition_block_token1,
    STATE(163), 1,
      sym_block_comment,
    ACTIONS(421), 2,
      sym_line_end,
      sym_block_remainder,
  [4450] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(449), 1,
      aux_sym_condition_block_token1,
    STATE(164), 1,
      sym_block_comment,
    ACTIONS(451), 2,
      sym_line_end,
      sym_block_remainder,
  [4467] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(566), 1,
      aux_sym_string_token1,
    STATE(165), 1,
      sym_block_comment,
    ACTIONS(564), 2,
      anon_sym_DQUOTE,
      aux_sym_string_token2,
  [4484] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(568), 1,
      aux_sym_list_token1,
    ACTIONS(570), 1,
      sym_line_end,
    STATE(166), 1,
      sym_block_comment,
    STATE(173), 1,
      aux_sym_list_repeat1,
  [4503] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      sym_block_remainder,
    STATE(167), 1,
      sym_block_comment,
    ACTIONS(239), 2,
      aux_sym_condition_block_token1,
      aux_sym_condition_block_token2,
  [4520] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(245), 1,
      sym_block_remainder,
    STATE(168), 1,
      sym_block_comment,
    ACTIONS(243), 2,
      aux_sym_condition_block_token1,
      aux_sym_condition_block_token2,
  [4537] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(169), 1,
      sym_block_comment,
    ACTIONS(572), 3,
      sym_knot_start,
      sym_function_start,
      ts_builtin_sym_end,
  [4552] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(574), 1,
      aux_sym_condition_block_token1,
    STATE(170), 1,
      sym_block_comment,
    ACTIONS(480), 2,
      sym_line_end,
      sym_block_remainder,
  [4569] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(478), 1,
      sym_block_remainder,
    STATE(171), 1,
      sym_block_comment,
    ACTIONS(476), 2,
      aux_sym_condition_block_token1,
      aux_sym_condition_block_token2,
  [4586] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(512), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_line_end,
    STATE(150), 1,
      sym_identifier_path,
    STATE(172), 1,
      sym_block_comment,
  [4605] = 6,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(417), 1,
      sym_line_end,
    ACTIONS(578), 1,
      aux_sym_list_token1,
    STATE(152), 1,
      aux_sym_list_repeat1,
    STATE(173), 1,
      sym_block_comment,
  [4624] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(580), 1,
      sym_line_start,
    STATE(174), 1,
      sym_block_comment,
    STATE(194), 1,
      aux_sym_condition_block_repeat1,
  [4640] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(582), 1,
      sym_line_start,
    STATE(175), 1,
      sym_block_comment,
    STATE(190), 1,
      aux_sym_condition_block_repeat1,
  [4656] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(176), 1,
      sym_block_comment,
    ACTIONS(584), 2,
      sym_line_end,
      aux_sym_list_token1,
  [4670] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(177), 1,
      sym_block_comment,
    ACTIONS(502), 2,
      sym_line_end,
      aux_sym_list_token1,
  [4684] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(512), 1,
      sym_identifier,
    STATE(150), 1,
      sym_identifier_path,
    STATE(178), 1,
      sym_block_comment,
  [4700] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(586), 1,
      sym_identifier,
    STATE(179), 1,
      sym_block_comment,
    STATE(255), 1,
      sym_identifier_path,
  [4716] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(588), 1,
      aux_sym_knot_header_token1,
    ACTIONS(590), 1,
      sym_line_end,
    STATE(180), 1,
      sym_block_comment,
  [4732] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(181), 1,
      sym_block_comment,
    ACTIONS(539), 2,
      sym_line_end,
      aux_sym_list_token1,
  [4746] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(182), 1,
      sym_block_comment,
    ACTIONS(592), 2,
      sym_line_end,
      aux_sym_list_token1,
  [4760] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(594), 1,
      aux_sym_knot_header_token1,
    ACTIONS(596), 1,
      sym_line_end,
    STATE(183), 1,
      sym_block_comment,
  [4776] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(598), 1,
      aux_sym_knot_header_token1,
    ACTIONS(600), 1,
      sym_line_end,
    STATE(184), 1,
      sym_block_comment,
  [4792] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(602), 1,
      aux_sym_knot_header_token1,
    ACTIONS(604), 1,
      sym_identifier,
    STATE(185), 1,
      sym_block_comment,
  [4808] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(606), 1,
      aux_sym_knot_header_token1,
    ACTIONS(608), 1,
      sym_identifier,
    STATE(186), 1,
      sym_block_comment,
  [4824] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    STATE(187), 1,
      sym_block_comment,
    ACTIONS(439), 2,
      sym_line_end,
      sym_dot,
  [4838] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(339), 1,
      aux_sym_knot_header_token1,
    ACTIONS(345), 1,
      sym_line_end,
    STATE(188), 1,
      sym_block_comment,
  [4854] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(610), 1,
      sym_tag_delimiter,
    ACTIONS(612), 1,
      sym_line_end,
    STATE(189), 1,
      sym_block_comment,
  [4870] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(614), 1,
      sym_line_start,
    STATE(190), 2,
      sym_block_comment,
      aux_sym_condition_block_repeat1,
  [4884] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(617), 1,
      sym_line_start,
    STATE(190), 1,
      aux_sym_condition_block_repeat1,
    STATE(191), 1,
      sym_block_comment,
  [4900] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(547), 1,
      aux_sym_knot_header_token1,
    ACTIONS(551), 1,
      sym_line_end,
    STATE(192), 1,
      sym_block_comment,
  [4916] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(367), 1,
      aux_sym_knot_header_token1,
    ACTIONS(371), 1,
      sym_line_end,
    STATE(193), 1,
      sym_block_comment,
  [4932] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(619), 1,
      sym_line_start,
    STATE(190), 1,
      aux_sym_condition_block_repeat1,
    STATE(194), 1,
      sym_block_comment,
  [4948] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(619), 1,
      sym_line_start,
    STATE(191), 1,
      aux_sym_condition_block_repeat1,
    STATE(195), 1,
      sym_block_comment,
  [4964] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(621), 1,
      sym_line_start,
    STATE(196), 1,
      sym_block_comment,
    STATE(197), 1,
      aux_sym_condition_block_repeat1,
  [4980] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      sym_line_start,
    STATE(190), 1,
      aux_sym_condition_block_repeat1,
    STATE(197), 1,
      sym_block_comment,
  [4996] = 5,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      sym_line_start,
    STATE(175), 1,
      aux_sym_condition_block_repeat1,
    STATE(198), 1,
      sym_block_comment,
  [5012] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(371), 1,
      sym_line_end,
    STATE(199), 1,
      sym_block_comment,
  [5025] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(625), 1,
      sym_identifier,
    STATE(200), 1,
      sym_block_comment,
  [5038] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(627), 1,
      sym_line_end,
    STATE(201), 1,
      sym_block_comment,
  [5051] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(629), 1,
      sym_line_end,
    STATE(202), 1,
      sym_block_comment,
  [5064] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(631), 1,
      sym_line_end,
    STATE(203), 1,
      sym_block_comment,
  [5077] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(633), 1,
      sym_identifier,
    STATE(204), 1,
      sym_block_comment,
  [5090] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(635), 1,
      sym_tag_remainder,
    STATE(205), 1,
      sym_block_comment,
  [5103] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(637), 1,
      sym_identifier,
    STATE(206), 1,
      sym_block_comment,
  [5116] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(639), 1,
      sym_line_end,
    STATE(207), 1,
      sym_block_comment,
  [5129] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(553), 1,
      sym_line_end,
    STATE(208), 1,
      sym_block_comment,
  [5142] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(641), 1,
      sym_assignment,
    STATE(209), 1,
      sym_block_comment,
  [5155] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(643), 1,
      sym_assignment,
    STATE(210), 1,
      sym_block_comment,
  [5168] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(645), 1,
      sym_line_end,
    STATE(211), 1,
      sym_block_comment,
  [5181] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(647), 1,
      sym_assignment,
    STATE(212), 1,
      sym_block_comment,
  [5194] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(600), 1,
      sym_line_end,
    STATE(213), 1,
      sym_block_comment,
  [5207] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(649), 1,
      sym_line_end,
    STATE(214), 1,
      sym_block_comment,
  [5220] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(651), 1,
      sym_line_start,
    STATE(215), 1,
      sym_block_comment,
  [5233] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(345), 1,
      sym_line_end,
    STATE(216), 1,
      sym_block_comment,
  [5246] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(653), 1,
      sym_line_end,
    STATE(217), 1,
      sym_block_comment,
  [5259] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(655), 1,
      sym_identifier,
    STATE(218), 1,
      sym_block_comment,
  [5272] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(657), 1,
      sym_line_end,
    STATE(219), 1,
      sym_block_comment,
  [5285] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(659), 1,
      sym_line_start,
    STATE(220), 1,
      sym_block_comment,
  [5298] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(661), 1,
      aux_sym_label_token2,
    STATE(221), 1,
      sym_block_comment,
  [5311] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(69), 1,
      sym_line_end,
    STATE(222), 1,
      sym_block_comment,
  [5324] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(663), 1,
      sym_identifier,
    STATE(223), 1,
      sym_block_comment,
  [5337] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(665), 1,
      sym_line_end,
    STATE(224), 1,
      sym_block_comment,
  [5350] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(195), 1,
      sym_line_end,
    STATE(225), 1,
      sym_block_comment,
  [5363] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(667), 1,
      sym_line_end,
    STATE(226), 1,
      sym_block_comment,
  [5376] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(590), 1,
      sym_line_end,
    STATE(227), 1,
      sym_block_comment,
  [5389] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(669), 1,
      sym_line_end,
    STATE(228), 1,
      sym_block_comment,
  [5402] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(363), 1,
      sym_line_end,
    STATE(229), 1,
      sym_block_comment,
  [5415] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(671), 1,
      sym_identifier,
    STATE(230), 1,
      sym_block_comment,
  [5428] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(673), 1,
      sym_identifier,
    STATE(231), 1,
      sym_block_comment,
  [5441] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(675), 1,
      sym_identifier,
    STATE(232), 1,
      sym_block_comment,
  [5454] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(677), 1,
      sym_line_end,
    STATE(233), 1,
      sym_block_comment,
  [5467] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(679), 1,
      sym_line_end,
    STATE(234), 1,
      sym_block_comment,
  [5480] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(551), 1,
      sym_line_end,
    STATE(235), 1,
      sym_block_comment,
  [5493] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(681), 1,
      sym_line_end,
    STATE(236), 1,
      sym_block_comment,
  [5506] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(683), 1,
      sym_line_end,
    STATE(237), 1,
      sym_block_comment,
  [5519] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(685), 1,
      sym_line_end,
    STATE(238), 1,
      sym_block_comment,
  [5532] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(687), 1,
      sym_identifier,
    STATE(239), 1,
      sym_block_comment,
  [5545] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(689), 1,
      sym_identifier,
    STATE(240), 1,
      sym_block_comment,
  [5558] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(691), 1,
      aux_sym_label_token2,
    STATE(241), 1,
      sym_block_comment,
  [5571] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(693), 1,
      sym_line_end,
    STATE(242), 1,
      sym_block_comment,
  [5584] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(695), 1,
      sym_line_end,
    STATE(243), 1,
      sym_block_comment,
  [5597] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(697), 1,
      sym_line_end,
    STATE(244), 1,
      sym_block_comment,
  [5610] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(699), 1,
      sym_line_end,
    STATE(245), 1,
      sym_block_comment,
  [5623] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(701), 1,
      sym_identifier,
    STATE(246), 1,
      sym_block_comment,
  [5636] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(703), 1,
      sym_line_end,
    STATE(247), 1,
      sym_block_comment,
  [5649] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(705), 1,
      sym_line_end,
    STATE(248), 1,
      sym_block_comment,
  [5662] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(707), 1,
      sym_line_end,
    STATE(249), 1,
      sym_block_comment,
  [5675] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(709), 1,
      sym_identifier,
    STATE(250), 1,
      sym_block_comment,
  [5688] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(185), 1,
      sym_line_end,
    STATE(251), 1,
      sym_block_comment,
  [5701] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(711), 1,
      sym_identifier,
    STATE(252), 1,
      sym_block_comment,
  [5714] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_line_end,
    STATE(253), 1,
      sym_block_comment,
  [5727] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(713), 1,
      sym_line_end,
    STATE(254), 1,
      sym_block_comment,
  [5740] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(715), 1,
      sym_line_end,
    STATE(255), 1,
      sym_block_comment,
  [5753] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(717), 1,
      ts_builtin_sym_end,
    STATE(256), 1,
      sym_block_comment,
  [5766] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(719), 1,
      sym_line_end,
    STATE(257), 1,
      sym_block_comment,
  [5779] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(721), 1,
      sym_line_end,
    STATE(258), 1,
      sym_block_comment,
  [5792] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(723), 1,
      sym_assignment,
    STATE(259), 1,
      sym_block_comment,
  [5805] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(725), 1,
      sym_assignment,
    STATE(260), 1,
      sym_block_comment,
  [5818] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(727), 1,
      sym_assignment,
    STATE(261), 1,
      sym_block_comment,
  [5831] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(729), 1,
      sym_line_end,
    STATE(262), 1,
      sym_block_comment,
  [5844] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(731), 1,
      sym_identifier,
    STATE(263), 1,
      sym_block_comment,
  [5857] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(733), 1,
      sym_identifier,
    STATE(264), 1,
      sym_block_comment,
  [5870] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(735), 1,
      sym_identifier,
    STATE(265), 1,
      sym_block_comment,
  [5883] = 4,
    ACTIONS(3), 1,
      sym_block_comment_start,
    ACTIONS(5), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      sym_identifier,
    STATE(266), 1,
      sym_block_comment,
  [5896] = 1,
    ACTIONS(739), 1,
      ts_builtin_sym_end,
  [5900] = 1,
    ACTIONS(741), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 95,
  [SMALL_STATE(4)] = 190,
  [SMALL_STATE(5)] = 271,
  [SMALL_STATE(6)] = 351,
  [SMALL_STATE(7)] = 425,
  [SMALL_STATE(8)] = 494,
  [SMALL_STATE(9)] = 553,
  [SMALL_STATE(10)] = 607,
  [SMALL_STATE(11)] = 650,
  [SMALL_STATE(12)] = 688,
  [SMALL_STATE(13)] = 728,
  [SMALL_STATE(14)] = 768,
  [SMALL_STATE(15)] = 806,
  [SMALL_STATE(16)] = 848,
  [SMALL_STATE(17)] = 889,
  [SMALL_STATE(18)] = 918,
  [SMALL_STATE(19)] = 957,
  [SMALL_STATE(20)] = 994,
  [SMALL_STATE(21)] = 1033,
  [SMALL_STATE(22)] = 1059,
  [SMALL_STATE(23)] = 1087,
  [SMALL_STATE(24)] = 1129,
  [SMALL_STATE(25)] = 1159,
  [SMALL_STATE(26)] = 1184,
  [SMALL_STATE(27)] = 1223,
  [SMALL_STATE(28)] = 1252,
  [SMALL_STATE(29)] = 1279,
  [SMALL_STATE(30)] = 1307,
  [SMALL_STATE(31)] = 1347,
  [SMALL_STATE(32)] = 1371,
  [SMALL_STATE(33)] = 1395,
  [SMALL_STATE(34)] = 1421,
  [SMALL_STATE(35)] = 1445,
  [SMALL_STATE(36)] = 1469,
  [SMALL_STATE(37)] = 1493,
  [SMALL_STATE(38)] = 1531,
  [SMALL_STATE(39)] = 1571,
  [SMALL_STATE(40)] = 1606,
  [SMALL_STATE(41)] = 1641,
  [SMALL_STATE(42)] = 1664,
  [SMALL_STATE(43)] = 1687,
  [SMALL_STATE(44)] = 1708,
  [SMALL_STATE(45)] = 1743,
  [SMALL_STATE(46)] = 1766,
  [SMALL_STATE(47)] = 1787,
  [SMALL_STATE(48)] = 1808,
  [SMALL_STATE(49)] = 1843,
  [SMALL_STATE(50)] = 1866,
  [SMALL_STATE(51)] = 1887,
  [SMALL_STATE(52)] = 1922,
  [SMALL_STATE(53)] = 1957,
  [SMALL_STATE(54)] = 1978,
  [SMALL_STATE(55)] = 1999,
  [SMALL_STATE(56)] = 2034,
  [SMALL_STATE(57)] = 2055,
  [SMALL_STATE(58)] = 2088,
  [SMALL_STATE(59)] = 2109,
  [SMALL_STATE(60)] = 2130,
  [SMALL_STATE(61)] = 2151,
  [SMALL_STATE(62)] = 2174,
  [SMALL_STATE(63)] = 2209,
  [SMALL_STATE(64)] = 2229,
  [SMALL_STATE(65)] = 2249,
  [SMALL_STATE(66)] = 2269,
  [SMALL_STATE(67)] = 2299,
  [SMALL_STATE(68)] = 2333,
  [SMALL_STATE(69)] = 2353,
  [SMALL_STATE(70)] = 2373,
  [SMALL_STATE(71)] = 2407,
  [SMALL_STATE(72)] = 2427,
  [SMALL_STATE(73)] = 2447,
  [SMALL_STATE(74)] = 2479,
  [SMALL_STATE(75)] = 2499,
  [SMALL_STATE(76)] = 2519,
  [SMALL_STATE(77)] = 2539,
  [SMALL_STATE(78)] = 2559,
  [SMALL_STATE(79)] = 2591,
  [SMALL_STATE(80)] = 2623,
  [SMALL_STATE(81)] = 2655,
  [SMALL_STATE(82)] = 2675,
  [SMALL_STATE(83)] = 2707,
  [SMALL_STATE(84)] = 2739,
  [SMALL_STATE(85)] = 2770,
  [SMALL_STATE(86)] = 2797,
  [SMALL_STATE(87)] = 2824,
  [SMALL_STATE(88)] = 2855,
  [SMALL_STATE(89)] = 2886,
  [SMALL_STATE(90)] = 2915,
  [SMALL_STATE(91)] = 2942,
  [SMALL_STATE(92)] = 2967,
  [SMALL_STATE(93)] = 2994,
  [SMALL_STATE(94)] = 3018,
  [SMALL_STATE(95)] = 3042,
  [SMALL_STATE(96)] = 3066,
  [SMALL_STATE(97)] = 3090,
  [SMALL_STATE(98)] = 3114,
  [SMALL_STATE(99)] = 3136,
  [SMALL_STATE(100)] = 3160,
  [SMALL_STATE(101)] = 3184,
  [SMALL_STATE(102)] = 3205,
  [SMALL_STATE(103)] = 3224,
  [SMALL_STATE(104)] = 3249,
  [SMALL_STATE(105)] = 3270,
  [SMALL_STATE(106)] = 3289,
  [SMALL_STATE(107)] = 3308,
  [SMALL_STATE(108)] = 3333,
  [SMALL_STATE(109)] = 3358,
  [SMALL_STATE(110)] = 3377,
  [SMALL_STATE(111)] = 3400,
  [SMALL_STATE(112)] = 3421,
  [SMALL_STATE(113)] = 3440,
  [SMALL_STATE(114)] = 3465,
  [SMALL_STATE(115)] = 3484,
  [SMALL_STATE(116)] = 3509,
  [SMALL_STATE(117)] = 3534,
  [SMALL_STATE(118)] = 3559,
  [SMALL_STATE(119)] = 3578,
  [SMALL_STATE(120)] = 3597,
  [SMALL_STATE(121)] = 3616,
  [SMALL_STATE(122)] = 3641,
  [SMALL_STATE(123)] = 3666,
  [SMALL_STATE(124)] = 3691,
  [SMALL_STATE(125)] = 3716,
  [SMALL_STATE(126)] = 3741,
  [SMALL_STATE(127)] = 3762,
  [SMALL_STATE(128)] = 3783,
  [SMALL_STATE(129)] = 3808,
  [SMALL_STATE(130)] = 3826,
  [SMALL_STATE(131)] = 3846,
  [SMALL_STATE(132)] = 3862,
  [SMALL_STATE(133)] = 3884,
  [SMALL_STATE(134)] = 3904,
  [SMALL_STATE(135)] = 3920,
  [SMALL_STATE(136)] = 3936,
  [SMALL_STATE(137)] = 3958,
  [SMALL_STATE(138)] = 3980,
  [SMALL_STATE(139)] = 4000,
  [SMALL_STATE(140)] = 4020,
  [SMALL_STATE(141)] = 4042,
  [SMALL_STATE(142)] = 4062,
  [SMALL_STATE(143)] = 4078,
  [SMALL_STATE(144)] = 4096,
  [SMALL_STATE(145)] = 4112,
  [SMALL_STATE(146)] = 4128,
  [SMALL_STATE(147)] = 4148,
  [SMALL_STATE(148)] = 4170,
  [SMALL_STATE(149)] = 4189,
  [SMALL_STATE(150)] = 4208,
  [SMALL_STATE(151)] = 4223,
  [SMALL_STATE(152)] = 4238,
  [SMALL_STATE(153)] = 4255,
  [SMALL_STATE(154)] = 4272,
  [SMALL_STATE(155)] = 4287,
  [SMALL_STATE(156)] = 4306,
  [SMALL_STATE(157)] = 4325,
  [SMALL_STATE(158)] = 4344,
  [SMALL_STATE(159)] = 4363,
  [SMALL_STATE(160)] = 4380,
  [SMALL_STATE(161)] = 4397,
  [SMALL_STATE(162)] = 4414,
  [SMALL_STATE(163)] = 4433,
  [SMALL_STATE(164)] = 4450,
  [SMALL_STATE(165)] = 4467,
  [SMALL_STATE(166)] = 4484,
  [SMALL_STATE(167)] = 4503,
  [SMALL_STATE(168)] = 4520,
  [SMALL_STATE(169)] = 4537,
  [SMALL_STATE(170)] = 4552,
  [SMALL_STATE(171)] = 4569,
  [SMALL_STATE(172)] = 4586,
  [SMALL_STATE(173)] = 4605,
  [SMALL_STATE(174)] = 4624,
  [SMALL_STATE(175)] = 4640,
  [SMALL_STATE(176)] = 4656,
  [SMALL_STATE(177)] = 4670,
  [SMALL_STATE(178)] = 4684,
  [SMALL_STATE(179)] = 4700,
  [SMALL_STATE(180)] = 4716,
  [SMALL_STATE(181)] = 4732,
  [SMALL_STATE(182)] = 4746,
  [SMALL_STATE(183)] = 4760,
  [SMALL_STATE(184)] = 4776,
  [SMALL_STATE(185)] = 4792,
  [SMALL_STATE(186)] = 4808,
  [SMALL_STATE(187)] = 4824,
  [SMALL_STATE(188)] = 4838,
  [SMALL_STATE(189)] = 4854,
  [SMALL_STATE(190)] = 4870,
  [SMALL_STATE(191)] = 4884,
  [SMALL_STATE(192)] = 4900,
  [SMALL_STATE(193)] = 4916,
  [SMALL_STATE(194)] = 4932,
  [SMALL_STATE(195)] = 4948,
  [SMALL_STATE(196)] = 4964,
  [SMALL_STATE(197)] = 4980,
  [SMALL_STATE(198)] = 4996,
  [SMALL_STATE(199)] = 5012,
  [SMALL_STATE(200)] = 5025,
  [SMALL_STATE(201)] = 5038,
  [SMALL_STATE(202)] = 5051,
  [SMALL_STATE(203)] = 5064,
  [SMALL_STATE(204)] = 5077,
  [SMALL_STATE(205)] = 5090,
  [SMALL_STATE(206)] = 5103,
  [SMALL_STATE(207)] = 5116,
  [SMALL_STATE(208)] = 5129,
  [SMALL_STATE(209)] = 5142,
  [SMALL_STATE(210)] = 5155,
  [SMALL_STATE(211)] = 5168,
  [SMALL_STATE(212)] = 5181,
  [SMALL_STATE(213)] = 5194,
  [SMALL_STATE(214)] = 5207,
  [SMALL_STATE(215)] = 5220,
  [SMALL_STATE(216)] = 5233,
  [SMALL_STATE(217)] = 5246,
  [SMALL_STATE(218)] = 5259,
  [SMALL_STATE(219)] = 5272,
  [SMALL_STATE(220)] = 5285,
  [SMALL_STATE(221)] = 5298,
  [SMALL_STATE(222)] = 5311,
  [SMALL_STATE(223)] = 5324,
  [SMALL_STATE(224)] = 5337,
  [SMALL_STATE(225)] = 5350,
  [SMALL_STATE(226)] = 5363,
  [SMALL_STATE(227)] = 5376,
  [SMALL_STATE(228)] = 5389,
  [SMALL_STATE(229)] = 5402,
  [SMALL_STATE(230)] = 5415,
  [SMALL_STATE(231)] = 5428,
  [SMALL_STATE(232)] = 5441,
  [SMALL_STATE(233)] = 5454,
  [SMALL_STATE(234)] = 5467,
  [SMALL_STATE(235)] = 5480,
  [SMALL_STATE(236)] = 5493,
  [SMALL_STATE(237)] = 5506,
  [SMALL_STATE(238)] = 5519,
  [SMALL_STATE(239)] = 5532,
  [SMALL_STATE(240)] = 5545,
  [SMALL_STATE(241)] = 5558,
  [SMALL_STATE(242)] = 5571,
  [SMALL_STATE(243)] = 5584,
  [SMALL_STATE(244)] = 5597,
  [SMALL_STATE(245)] = 5610,
  [SMALL_STATE(246)] = 5623,
  [SMALL_STATE(247)] = 5636,
  [SMALL_STATE(248)] = 5649,
  [SMALL_STATE(249)] = 5662,
  [SMALL_STATE(250)] = 5675,
  [SMALL_STATE(251)] = 5688,
  [SMALL_STATE(252)] = 5701,
  [SMALL_STATE(253)] = 5714,
  [SMALL_STATE(254)] = 5727,
  [SMALL_STATE(255)] = 5740,
  [SMALL_STATE(256)] = 5753,
  [SMALL_STATE(257)] = 5766,
  [SMALL_STATE(258)] = 5779,
  [SMALL_STATE(259)] = 5792,
  [SMALL_STATE(260)] = 5805,
  [SMALL_STATE(261)] = 5818,
  [SMALL_STATE(262)] = 5831,
  [SMALL_STATE(263)] = 5844,
  [SMALL_STATE(264)] = 5857,
  [SMALL_STATE(265)] = 5870,
  [SMALL_STATE(266)] = 5883,
  [SMALL_STATE(267)] = 5896,
  [SMALL_STATE(268)] = 5900,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 0, 0, 0),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(25),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(21),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(51),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(30),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(41),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [39] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [41] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(32),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_option_text, 1, 0, 0),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gather_text, 1, 0, 0),
  [67] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gather_text, 2, 0, 0),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_option_text, 2, 0, 0),
  [71] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 1, 0, 0),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [75] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_knot, 1, 0, 0),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [89] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stitch, 1, 0, 0),
  [91] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_words_repeat1, 2, 0, 0), SHIFT_REPEAT(31),
  [94] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_words_repeat1, 2, 0, 0), SHIFT_REPEAT(116),
  [97] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_words_repeat1, 2, 0, 0), SHIFT_REPEAT(32),
  [100] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_words_repeat1, 2, 0, 0),
  [102] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_words_repeat1, 2, 0, 0), SHIFT_REPEAT(31),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_words, 1, 0, 0),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_weave_body, 1, 0, 0),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0),
  [111] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(3),
  [114] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(263),
  [117] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(264),
  [120] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(265),
  [123] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(53),
  [126] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 1, 0, 0),
  [128] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [130] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_text, 1, 0, 0),
  [132] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_text, 1, 0, 0),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_option_text_repeat1, 2, 0, 0), SHIFT_REPEAT(21),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_option_text_repeat1, 2, 0, 0),
  [139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_option_text_repeat1, 2, 0, 0),
  [141] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(2),
  [144] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(230),
  [147] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(231),
  [150] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(240),
  [153] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 2, 0, 0), SHIFT_REPEAT(64),
  [156] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(121),
  [159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0),
  [161] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(42),
  [164] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(41),
  [167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0),
  [169] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(42),
  [172] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_option_text_repeat1, 1, 0, 0),
  [174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_option_text_repeat1, 1, 0, 0),
  [176] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_gather_mark_repeat1, 2, 0, 0), SHIFT_REPEAT(25),
  [179] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_gather_mark_repeat1, 2, 0, 0),
  [181] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_gather_mark_repeat1, 2, 0, 0),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dialog_text, 1, 0, 0),
  [187] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gather_mark, 1, 0, 0),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gather_mark, 1, 0, 0),
  [191] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_gather_mark_repeat1, 1, 0, 0),
  [193] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_gather_mark_repeat1, 1, 0, 0),
  [195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_option_words, 1, 0, 0),
  [197] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_word_other, 1, 0, 0),
  [199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_word_other, 1, 0, 0),
  [201] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_word_other_repeat1, 2, 0, 0),
  [203] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_word_other_repeat1, 2, 0, 0), SHIFT_REPEAT(32),
  [206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_word_other_repeat1, 2, 0, 0),
  [208] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_other, 1, 0, 0),
  [210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_other, 1, 0, 0),
  [212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(38),
  [214] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [220] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_words_repeat1, 1, 0, 0),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_words_repeat1, 1, 0, 0),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_word_other_repeat1, 1, 0, 0),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_word_other_repeat1, 1, 0, 0),
  [228] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_other_repeat1, 2, 0, 0),
  [230] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_other_repeat1, 2, 0, 0), SHIFT_REPEAT(41),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_other_repeat1, 2, 0, 0),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_label, 3, 0, 0),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_label, 3, 0, 0),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inline_block, 2, 0, 0),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline_block, 2, 0, 0),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_inline_block, 3, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inline_block, 3, 0, 0),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [249] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [251] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [255] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_text, 1, 0, 0),
  [257] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [261] = {.entry = {.count = 1, .reusable = false}}, SHIFT(164),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [267] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_other_repeat1, 1, 0, 0),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_other_repeat1, 1, 0, 0),
  [273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 1, 0, 0),
  [275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 1, 0, 0),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_knot_header, 3, 0, 0),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_knot_header, 4, 0, 0),
  [283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stitch_header, 3, 0, 0),
  [285] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_knot_header, 5, 0, 0),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [291] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_weave_body_repeat1, 1, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_weave_body_line, 2, 0, 0),
  [295] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_weave_body_line, 3, 0, 0),
  [297] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(107),
  [300] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(105),
  [303] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(114),
  [306] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_text_repeat1, 2, 0, 0), SHIFT_REPEAT(105),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_var_line, 5, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_line, 5, 0, 0),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_line, 5, 0, 0),
  [315] = {.entry = {.count = 1, .reusable = false}}, SHIFT(160),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0),
  [319] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(185),
  [322] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 2, 0, 0), SHIFT_REPEAT(186),
  [325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [331] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 4, 0, 0),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 5, 0, 0),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 3, 0, 0),
  [351] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 6, 0, 0),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 7, 0, 0),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 8, 0, 0),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 2, 0, 0),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_program, 3, 0, 0),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [363] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_divert_chain, 1, 0, 0),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_knot, 2, 0, 0),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_block_content, 1, 0, 0),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_knot, 3, 0, 0),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_knot_repeat1, 2, 0, 0),
  [379] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_knot_repeat1, 2, 0, 0), SHIFT_REPEAT(218),
  [382] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_condition_block_content_repeat1, 2, 0, 0), SHIFT_REPEAT(38),
  [385] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_condition_block_content_repeat1, 2, 0, 0), SHIFT_REPEAT(170),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_condition_block_content_repeat1, 2, 0, 0),
  [390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2, 0, 0),
  [396] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_other_repeat1, 2, 0, 0), SHIFT_REPEAT(114),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3, 0, 0),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_path, 2, 0, 0),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 2, 0, 0),
  [419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_block, 5, 0, 0),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_block, 5, 0, 0),
  [423] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_inline_block_repeat1, 2, 0, 0), SHIFT_REPEAT(123),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_inline_block_repeat1, 2, 0, 0),
  [428] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_inline_block_repeat1, 2, 0, 0), SHIFT_REPEAT(171),
  [431] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_divert_chain_repeat1, 2, 0, 0), SHIFT_REPEAT(178),
  [434] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_divert_chain_repeat1, 2, 0, 0),
  [436] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_identifier_path_repeat1, 2, 0, 0), SHIFT_REPEAT(246),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_identifier_path_repeat1, 2, 0, 0),
  [441] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 3, 0, 0),
  [445] = {.entry = {.count = 1, .reusable = false}}, SHIFT(35),
  [447] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [449] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_block, 6, 0, 0),
  [451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_block, 6, 0, 0),
  [453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2, 0, 0),
  [455] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2, 0, 0), SHIFT_REPEAT(148),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_block, 4, 0, 0),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_block, 4, 0, 0),
  [462] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [464] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [466] = {.entry = {.count = 1, .reusable = false}}, SHIFT(36),
  [468] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [470] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_path, 1, 0, 0),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 1, 0, 0),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [476] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_inline_block_repeat1, 1, 0, 0),
  [478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_inline_block_repeat1, 1, 0, 0),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_condition_block_content_repeat1, 1, 0, 0),
  [482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 2, 0, 0),
  [484] = {.entry = {.count = 1, .reusable = false}}, SHIFT(234),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [488] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_marked_identifier, 1, 0, 0),
  [494] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [498] = {.entry = {.count = 1, .reusable = false}}, SHIFT(153),
  [500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_marked_identifier, 2, 0, 0),
  [504] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [506] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(165),
  [509] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(165),
  [512] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [514] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_divert_continue, 1, 0, 0),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1, 0, 0),
  [518] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_knot_repeat1, 1, 0, 0),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stitch, 2, 0, 0),
  [522] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_comment_repeat1, 2, 0, 0), SHIFT_REPEAT(153),
  [525] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_comment_repeat1, 2, 0, 0), SHIFT_REPEAT(153),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_comment_repeat1, 2, 0, 0),
  [530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_divert, 2, 0, 0),
  [534] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_divert_chain_repeat1, 1, 0, 0),
  [536] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0), SHIFT_REPEAT(140),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_list_repeat1, 2, 0, 0),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_comment_repeat1, 1, 0, 0),
  [543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_comment_repeat1, 1, 0, 0),
  [545] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_program_repeat1, 1, 0, 0),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_divert_chain, 2, 0, 0),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [557] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_identifier_path_repeat1, 2, 0, 0), SHIFT_REPEAT(239),
  [560] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_condition_block_nested, 1, 0, 0),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_block_nested, 1, 0, 0),
  [564] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 1, 0, 0),
  [566] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 1, 0, 0),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [570] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list, 1, 0, 0),
  [572] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function, 2, 0, 0),
  [574] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_condition_block_content_repeat1, 1, 0, 0),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_default_option_mark, 1, 0, 0),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mark_end, 1, 0, 0),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_marked_identifier, 3, 0, 0),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [612] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 2, 0, 0),
  [614] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_condition_block_repeat1, 2, 0, 0), SHIFT_REPEAT(73),
  [617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_condition_text, 2, 0, 0),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_code_text, 2, 0, 0),
  [647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_condition_block_repeat1, 3, 0, 0),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_divert_or_thread, 1, 0, 0),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [657] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_divert_return, 1, 0, 0),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_condition_block_repeat1, 2, 0, 0),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [669] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tag, 4, 0, 0),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gather_text, 3, 0, 0),
  [679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_option_words, 2, 0, 0),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_option_text, 3, 0, 0),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mark_start, 1, 0, 0),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dialog_text, 2, 0, 0),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_thread, 2, 0, 0),
  [717] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [719] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_divert_chain, 3, 0, 0),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 0),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [739] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_comment, 3, 0, 0),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_comment, 2, 0, 0),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_arrow = 0,
  ts_external_token_double_arrow = 1,
  ts_external_token_back_arrow = 2,
  ts_external_token_block_comment_start = 3,
  ts_external_token_block_comment_end = 4,
  ts_external_token_line_comment = 5,
  ts_external_token_glue = 6,
  ts_external_token_line_start = 7,
  ts_external_token_stitch_start = 8,
  ts_external_token_knot_start = 9,
  ts_external_token_function_start = 10,
  ts_external_token_var_start = 11,
  ts_external_token_const_start = 12,
  ts_external_token_list_start = 13,
  ts_external_token_empty_line = 14,
  ts_external_token_line_end = 15,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_arrow] = sym_arrow,
  [ts_external_token_double_arrow] = sym_double_arrow,
  [ts_external_token_back_arrow] = sym_back_arrow,
  [ts_external_token_block_comment_start] = sym_block_comment_start,
  [ts_external_token_block_comment_end] = sym_block_comment_end,
  [ts_external_token_line_comment] = sym_line_comment,
  [ts_external_token_glue] = sym_glue,
  [ts_external_token_line_start] = sym_line_start,
  [ts_external_token_stitch_start] = sym_stitch_start,
  [ts_external_token_knot_start] = sym_knot_start,
  [ts_external_token_function_start] = sym_function_start,
  [ts_external_token_var_start] = sym_var_start,
  [ts_external_token_const_start] = sym_const_start,
  [ts_external_token_list_start] = sym_list_start,
  [ts_external_token_empty_line] = sym_empty_line,
  [ts_external_token_line_end] = sym_line_end,
};

static const bool ts_external_scanner_states[16][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_arrow] = true,
    [ts_external_token_double_arrow] = true,
    [ts_external_token_back_arrow] = true,
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_block_comment_end] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_glue] = true,
    [ts_external_token_line_start] = true,
    [ts_external_token_stitch_start] = true,
    [ts_external_token_knot_start] = true,
    [ts_external_token_function_start] = true,
    [ts_external_token_var_start] = true,
    [ts_external_token_const_start] = true,
    [ts_external_token_list_start] = true,
    [ts_external_token_empty_line] = true,
    [ts_external_token_line_end] = true,
  },
  [2] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_line_start] = true,
    [ts_external_token_knot_start] = true,
    [ts_external_token_function_start] = true,
    [ts_external_token_var_start] = true,
    [ts_external_token_const_start] = true,
    [ts_external_token_list_start] = true,
    [ts_external_token_empty_line] = true,
  },
  [3] = {
    [ts_external_token_arrow] = true,
    [ts_external_token_double_arrow] = true,
    [ts_external_token_back_arrow] = true,
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_glue] = true,
    [ts_external_token_line_end] = true,
  },
  [4] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_line_start] = true,
    [ts_external_token_stitch_start] = true,
    [ts_external_token_knot_start] = true,
    [ts_external_token_function_start] = true,
    [ts_external_token_var_start] = true,
    [ts_external_token_const_start] = true,
    [ts_external_token_list_start] = true,
    [ts_external_token_empty_line] = true,
  },
  [5] = {
    [ts_external_token_arrow] = true,
    [ts_external_token_double_arrow] = true,
    [ts_external_token_back_arrow] = true,
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_line_end] = true,
  },
  [6] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_line_end] = true,
  },
  [7] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_glue] = true,
    [ts_external_token_line_end] = true,
  },
  [8] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_glue] = true,
  },
  [9] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_knot_start] = true,
    [ts_external_token_function_start] = true,
  },
  [10] = {
    [ts_external_token_arrow] = true,
    [ts_external_token_double_arrow] = true,
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_line_end] = true,
  },
  [11] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_stitch_start] = true,
    [ts_external_token_knot_start] = true,
    [ts_external_token_function_start] = true,
  },
  [12] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
  },
  [13] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_block_comment_end] = true,
    [ts_external_token_line_comment] = true,
  },
  [14] = {
    [ts_external_token_double_arrow] = true,
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_line_end] = true,
  },
  [15] = {
    [ts_external_token_block_comment_start] = true,
    [ts_external_token_line_comment] = true,
    [ts_external_token_line_start] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_ink_external_scanner_create(void);
void tree_sitter_ink_external_scanner_destroy(void *);
bool tree_sitter_ink_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_ink_external_scanner_serialize(void *, char *);
void tree_sitter_ink_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_ink(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_ink_external_scanner_create,
      tree_sitter_ink_external_scanner_destroy,
      tree_sitter_ink_external_scanner_scan,
      tree_sitter_ink_external_scanner_serialize,
      tree_sitter_ink_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
