#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1110
#define LARGE_STATE_COUNT 240
#define SYMBOL_COUNT 187
#define ALIAS_COUNT 5
#define TOKEN_COUNT 81
#define EXTERNAL_TOKEN_COUNT 9
#define FIELD_COUNT 37
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 92

enum ts_symbol_identifiers {
  sym_symbol = 1,
  aux_sym_comment_token1 = 2,
  aux_sym_comment_token2 = 3,
  anon_sym_LPAREN = 4,
  anon_sym_RPAREN = 5,
  anon_sym_AMP = 6,
  anon_sym_LBRACK = 7,
  anon_sym_RBRACK = 8,
  anon_sym_COLON = 9,
  anon_sym_LBRACE = 10,
  anon_sym_RBRACE = 11,
  anon_sym_or = 12,
  anon_sym_where = 13,
  anon_sym_catch = 14,
  anon_sym_DOT_DOT_DOT = 15,
  anon_sym_fnl_SLASHdocstring = 16,
  anon_sym_DQUOTE = 17,
  anon_sym_fnl_SLASHarglist = 18,
  anon_sym_COLONuntil = 19,
  anon_sym_COLONinto = 20,
  anon_sym_case = 21,
  anon_sym_match = 22,
  anon_sym_case_DASHtry = 23,
  anon_sym_match_DASHtry = 24,
  anon_sym_if = 25,
  anon_sym_fn = 26,
  anon_sym_lambda = 27,
  anon_sym_u03bb = 28,
  anon_sym_macro = 29,
  anon_sym_hashfn = 30,
  anon_sym_each = 31,
  anon_sym_collect = 32,
  anon_sym_icollect = 33,
  anon_sym_accumulate = 34,
  anon_sym_for = 35,
  anon_sym_fcollect = 36,
  anon_sym_faccumulate = 37,
  anon_sym_local = 38,
  anon_sym_var = 39,
  anon_sym_global = 40,
  anon_sym_set = 41,
  anon_sym_let = 42,
  anon_sym_import_DASHmacros = 43,
  anon_sym_quote = 44,
  anon_sym_unquote = 45,
  sym_nil = 46,
  anon_sym_true = 47,
  anon_sym_false = 48,
  anon_sym_POUND = 49,
  anon_sym_QMARK_DOT = 50,
  anon_sym_TILDE_EQ = 51,
  anon_sym_COLON2 = 52,
  anon_sym_DOLLAR_DOT_DOT_DOT = 53,
  anon_sym_DOT_DOT_DOT2 = 54,
  anon_sym_DOT_DOT = 55,
  anon_sym_DOT = 56,
  anon_sym_nil = 57,
  anon_sym_true2 = 58,
  anon_sym_false2 = 59,
  aux_sym__colon_string_token1 = 60,
  aux_sym__double_quote_string_content_token1 = 61,
  sym_escape_sequence = 62,
  sym_number = 63,
  sym_symbol_option = 64,
  aux_sym__multi_symbol_fragment_token1 = 65,
  anon_sym_POUND2 = 66,
  anon_sym_QMARK_DOT2 = 67,
  anon_sym_TILDE_EQ2 = 68,
  anon_sym_DOLLAR_DOT_DOT_DOT2 = 69,
  anon_sym_DOT_DOT2 = 70,
  anon_sym_DOT2 = 71,
  sym__hashfn_reader_macro_char = 72,
  sym__quote_reader_macro_char = 73,
  sym__quasi_quote_reader_macro_char = 74,
  sym__unquote_reader_macro_char = 75,
  sym___reader_macro_count = 76,
  sym___colon_string_start_mark = 77,
  sym___colon_string_end_mark = 78,
  sym_shebang = 79,
  sym___token_count = 80,
  sym_program = 81,
  sym_comment = 82,
  sym__sexp = 83,
  sym_hashfn_reader_macro = 84,
  sym_quote_reader_macro = 85,
  sym_quasi_quote_reader_macro = 86,
  sym_unquote_reader_macro = 87,
  sym__reader_macro = 88,
  sym__list_content = 89,
  sym_list = 90,
  sym__binding = 91,
  sym_list_binding = 92,
  sym_rest_binding = 93,
  sym_sequence_binding = 94,
  sym__table_binding_key = 95,
  sym_table_binding_pair = 96,
  sym_table_binding = 97,
  sym_binding_pair = 98,
  sym__literal_binding = 99,
  sym_case_guard_or_special = 100,
  sym_case_guard = 101,
  sym__case_lhs = 102,
  sym_case_pair = 103,
  sym_case_catch = 104,
  sym_if_pair = 105,
  sym__function_identifier = 106,
  sym_sequence_arguments = 107,
  sym__table_metadata_key_docstring = 108,
  sym__table_metadata_docstring = 109,
  sym__table_metadata_key_arglist = 110,
  sym__table_metadata_arglist = 111,
  sym__table_metadata_generic = 112,
  sym_table_metadata_pair = 113,
  sym_table_metadata = 114,
  sym__function_inner_body_all = 115,
  sym__function_inner_body_docstring = 116,
  sym__function_inner_body_metadata = 117,
  sym__function_inner_body_generic = 118,
  sym__function_inner_body = 119,
  sym__function_body = 120,
  sym__iter_option_legacy = 121,
  sym__iter_option_lhs = 122,
  sym_iter_option = 123,
  sym__iter_body = 124,
  sym__each_iter_body = 125,
  sym__collect_iter_body = 126,
  sym_accumulator_pair = 127,
  sym__accumulate_iter_body = 128,
  sym__fiter_body = 129,
  sym__fcollect_iter_body = 130,
  sym__faccumulate_iter_body = 131,
  sym__set_binding_pair_key = 132,
  sym__set_binding_pair = 133,
  sym_let_vars = 134,
  sym_case_form = 135,
  sym_match_form = 136,
  sym_case_try_form = 137,
  sym_match_try_form = 138,
  sym_if_form = 139,
  sym_fn_form = 140,
  sym_lambda_form = 141,
  sym_macro_form = 142,
  sym_hashfn_form = 143,
  sym_each_form = 144,
  sym_collect_form = 145,
  sym_icollect_form = 146,
  sym_accumulate_form = 147,
  sym_for_form = 148,
  sym_fcollect_form = 149,
  sym_faccumulate_form = 150,
  sym_local_form = 151,
  sym_var_form = 152,
  sym_global_form = 153,
  sym_set_form = 154,
  sym_let_form = 155,
  sym_import_macros_form = 156,
  sym_quote_form = 157,
  sym_unquote_form = 158,
  sym__form = 159,
  sym_sequence = 160,
  sym_table_pair = 161,
  sym_table = 162,
  sym__literal = 163,
  sym_boolean = 164,
  sym__colon_string = 165,
  sym__double_quote_string_content = 166,
  sym__double_quote_string = 167,
  sym_string = 168,
  sym_multi_symbol = 169,
  sym_multi_symbol_method = 170,
  sym__multi_symbol_fragment = 171,
  sym__special_override_symbol = 172,
  aux_sym_program_repeat1 = 173,
  aux_sym__list_content_repeat1 = 174,
  aux_sym_list_binding_repeat1 = 175,
  aux_sym_table_binding_repeat1 = 176,
  aux_sym_case_guard_repeat1 = 177,
  aux_sym_case_catch_repeat1 = 178,
  aux_sym_table_metadata_repeat1 = 179,
  aux_sym__iter_body_repeat1 = 180,
  aux_sym__iter_body_repeat2 = 181,
  aux_sym_let_vars_repeat1 = 182,
  aux_sym_if_form_repeat1 = 183,
  aux_sym_table_repeat1 = 184,
  aux_sym__double_quote_string_repeat1 = 185,
  aux_sym_multi_symbol_repeat1 = 186,
  alias_sym_boolean_binding = 187,
  alias_sym_docstring = 188,
  alias_sym_nil_binding = 189,
  alias_sym_number_binding = 190,
  alias_sym_string_binding = 191,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_symbol] = "symbol",
  [aux_sym_comment_token1] = ";",
  [aux_sym_comment_token2] = "comment_body",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_AMP] = "symbol_option",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COLON] = ":",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_or] = "symbol",
  [anon_sym_where] = "symbol",
  [anon_sym_catch] = "symbol",
  [anon_sym_DOT_DOT_DOT] = "symbol_binding",
  [anon_sym_fnl_SLASHdocstring] = "string_content",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_fnl_SLASHarglist] = "string_content",
  [anon_sym_COLONuntil] = "symbol_option",
  [anon_sym_COLONinto] = "symbol_option",
  [anon_sym_case] = "symbol",
  [anon_sym_match] = "symbol",
  [anon_sym_case_DASHtry] = "symbol",
  [anon_sym_match_DASHtry] = "symbol",
  [anon_sym_if] = "symbol",
  [anon_sym_fn] = "symbol",
  [anon_sym_lambda] = "symbol",
  [anon_sym_u03bb] = "symbol",
  [anon_sym_macro] = "symbol",
  [anon_sym_hashfn] = "symbol",
  [anon_sym_each] = "symbol",
  [anon_sym_collect] = "symbol",
  [anon_sym_icollect] = "symbol",
  [anon_sym_accumulate] = "symbol",
  [anon_sym_for] = "symbol",
  [anon_sym_fcollect] = "symbol",
  [anon_sym_faccumulate] = "symbol",
  [anon_sym_local] = "symbol",
  [anon_sym_var] = "symbol",
  [anon_sym_global] = "symbol",
  [anon_sym_set] = "symbol",
  [anon_sym_let] = "symbol",
  [anon_sym_import_DASHmacros] = "symbol",
  [anon_sym_quote] = "symbol",
  [anon_sym_unquote] = "symbol",
  [sym_nil] = "nil",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_POUND] = "string_content",
  [anon_sym_QMARK_DOT] = "string_content",
  [anon_sym_TILDE_EQ] = "string_content",
  [anon_sym_COLON2] = ":",
  [anon_sym_DOLLAR_DOT_DOT_DOT] = "string_content",
  [anon_sym_DOT_DOT_DOT2] = "string_content",
  [anon_sym_DOT_DOT] = "string_content",
  [anon_sym_DOT] = ".",
  [anon_sym_nil] = "string_content",
  [anon_sym_true2] = "string_content",
  [anon_sym_false2] = "string_content",
  [aux_sym__colon_string_token1] = "string_content",
  [aux_sym__double_quote_string_content_token1] = "_double_quote_string_content_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym_number] = "number",
  [sym_symbol_option] = "symbol_option",
  [aux_sym__multi_symbol_fragment_token1] = "symbol_fragment",
  [anon_sym_POUND2] = "symbol",
  [anon_sym_QMARK_DOT2] = "symbol",
  [anon_sym_TILDE_EQ2] = "symbol",
  [anon_sym_DOLLAR_DOT_DOT_DOT2] = "symbol",
  [anon_sym_DOT_DOT2] = "symbol",
  [anon_sym_DOT2] = "symbol",
  [sym__hashfn_reader_macro_char] = "#",
  [sym__quote_reader_macro_char] = "'",
  [sym__quasi_quote_reader_macro_char] = "`",
  [sym__unquote_reader_macro_char] = ",",
  [sym___reader_macro_count] = "__reader_macro_count",
  [sym___colon_string_start_mark] = "__colon_string_start_mark",
  [sym___colon_string_end_mark] = "__colon_string_end_mark",
  [sym_shebang] = "shebang",
  [sym___token_count] = "__token_count",
  [sym_program] = "program",
  [sym_comment] = "comment",
  [sym__sexp] = "_sexp",
  [sym_hashfn_reader_macro] = "hashfn_reader_macro",
  [sym_quote_reader_macro] = "quote_reader_macro",
  [sym_quasi_quote_reader_macro] = "quasi_quote_reader_macro",
  [sym_unquote_reader_macro] = "unquote_reader_macro",
  [sym__reader_macro] = "_reader_macro",
  [sym__list_content] = "_list_content",
  [sym_list] = "list",
  [sym__binding] = "_binding",
  [sym_list_binding] = "list_binding",
  [sym_rest_binding] = "rest_binding",
  [sym_sequence_binding] = "sequence_binding",
  [sym__table_binding_key] = "_table_binding_key",
  [sym_table_binding_pair] = "table_binding_pair",
  [sym_table_binding] = "table_binding",
  [sym_binding_pair] = "binding_pair",
  [sym__literal_binding] = "_literal_binding",
  [sym_case_guard_or_special] = "case_guard_or_special",
  [sym_case_guard] = "case_guard",
  [sym__case_lhs] = "_case_lhs",
  [sym_case_pair] = "case_pair",
  [sym_case_catch] = "case_catch",
  [sym_if_pair] = "if_pair",
  [sym__function_identifier] = "_function_identifier",
  [sym_sequence_arguments] = "sequence_arguments",
  [sym__table_metadata_key_docstring] = "string",
  [sym__table_metadata_docstring] = "_table_metadata_docstring",
  [sym__table_metadata_key_arglist] = "string",
  [sym__table_metadata_arglist] = "_table_metadata_arglist",
  [sym__table_metadata_generic] = "_table_metadata_generic",
  [sym_table_metadata_pair] = "table_metadata_pair",
  [sym_table_metadata] = "table_metadata",
  [sym__function_inner_body_all] = "_function_inner_body_all",
  [sym__function_inner_body_docstring] = "_function_inner_body_docstring",
  [sym__function_inner_body_metadata] = "_function_inner_body_metadata",
  [sym__function_inner_body_generic] = "_function_inner_body_generic",
  [sym__function_inner_body] = "_function_inner_body",
  [sym__function_body] = "_function_body",
  [sym__iter_option_legacy] = "_iter_option_legacy",
  [sym__iter_option_lhs] = "_iter_option_lhs",
  [sym_iter_option] = "iter_option",
  [sym__iter_body] = "_iter_body",
  [sym__each_iter_body] = "iter_body",
  [sym__collect_iter_body] = "iter_body",
  [sym_accumulator_pair] = "accumulator_pair",
  [sym__accumulate_iter_body] = "iter_body",
  [sym__fiter_body] = "_fiter_body",
  [sym__fcollect_iter_body] = "for_iter_body",
  [sym__faccumulate_iter_body] = "for_iter_body",
  [sym__set_binding_pair_key] = "_set_binding_pair_key",
  [sym__set_binding_pair] = "binding_pair",
  [sym_let_vars] = "let_vars",
  [sym_case_form] = "case_form",
  [sym_match_form] = "match_form",
  [sym_case_try_form] = "case_try_form",
  [sym_match_try_form] = "match_try_form",
  [sym_if_form] = "if_form",
  [sym_fn_form] = "fn_form",
  [sym_lambda_form] = "lambda_form",
  [sym_macro_form] = "macro_form",
  [sym_hashfn_form] = "hashfn_form",
  [sym_each_form] = "each_form",
  [sym_collect_form] = "collect_form",
  [sym_icollect_form] = "icollect_form",
  [sym_accumulate_form] = "accumulate_form",
  [sym_for_form] = "for_form",
  [sym_fcollect_form] = "fcollect_form",
  [sym_faccumulate_form] = "faccumulate_form",
  [sym_local_form] = "local_form",
  [sym_var_form] = "var_form",
  [sym_global_form] = "global_form",
  [sym_set_form] = "set_form",
  [sym_let_form] = "let_form",
  [sym_import_macros_form] = "import_macros_form",
  [sym_quote_form] = "quote_form",
  [sym_unquote_form] = "unquote_form",
  [sym__form] = "_form",
  [sym_sequence] = "sequence",
  [sym_table_pair] = "table_pair",
  [sym_table] = "table",
  [sym__literal] = "_literal",
  [sym_boolean] = "boolean",
  [sym__colon_string] = "_colon_string",
  [sym__double_quote_string_content] = "_double_quote_string_content",
  [sym__double_quote_string] = "_double_quote_string",
  [sym_string] = "string",
  [sym_multi_symbol] = "multi_symbol",
  [sym_multi_symbol_method] = "multi_symbol_method",
  [sym__multi_symbol_fragment] = "_multi_symbol_fragment",
  [sym__special_override_symbol] = "_special_override_symbol",
  [aux_sym_program_repeat1] = "program_repeat1",
  [aux_sym__list_content_repeat1] = "_list_content_repeat1",
  [aux_sym_list_binding_repeat1] = "list_binding_repeat1",
  [aux_sym_table_binding_repeat1] = "table_binding_repeat1",
  [aux_sym_case_guard_repeat1] = "case_guard_repeat1",
  [aux_sym_case_catch_repeat1] = "case_catch_repeat1",
  [aux_sym_table_metadata_repeat1] = "table_metadata_repeat1",
  [aux_sym__iter_body_repeat1] = "_iter_body_repeat1",
  [aux_sym__iter_body_repeat2] = "_iter_body_repeat2",
  [aux_sym_let_vars_repeat1] = "let_vars_repeat1",
  [aux_sym_if_form_repeat1] = "if_form_repeat1",
  [aux_sym_table_repeat1] = "table_repeat1",
  [aux_sym__double_quote_string_repeat1] = "_double_quote_string_repeat1",
  [aux_sym_multi_symbol_repeat1] = "multi_symbol_repeat1",
  [alias_sym_boolean_binding] = "boolean_binding",
  [alias_sym_docstring] = "docstring",
  [alias_sym_nil_binding] = "nil_binding",
  [alias_sym_number_binding] = "number_binding",
  [alias_sym_string_binding] = "string_binding",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_symbol] = sym_symbol,
  [aux_sym_comment_token1] = aux_sym_comment_token1,
  [aux_sym_comment_token2] = aux_sym_comment_token2,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_AMP] = sym_symbol_option,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_or] = sym_symbol,
  [anon_sym_where] = sym_symbol,
  [anon_sym_catch] = sym_symbol,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_fnl_SLASHdocstring] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_fnl_SLASHarglist] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_COLONuntil] = sym_symbol_option,
  [anon_sym_COLONinto] = sym_symbol_option,
  [anon_sym_case] = sym_symbol,
  [anon_sym_match] = sym_symbol,
  [anon_sym_case_DASHtry] = sym_symbol,
  [anon_sym_match_DASHtry] = sym_symbol,
  [anon_sym_if] = sym_symbol,
  [anon_sym_fn] = sym_symbol,
  [anon_sym_lambda] = sym_symbol,
  [anon_sym_u03bb] = sym_symbol,
  [anon_sym_macro] = sym_symbol,
  [anon_sym_hashfn] = sym_symbol,
  [anon_sym_each] = sym_symbol,
  [anon_sym_collect] = sym_symbol,
  [anon_sym_icollect] = sym_symbol,
  [anon_sym_accumulate] = sym_symbol,
  [anon_sym_for] = sym_symbol,
  [anon_sym_fcollect] = sym_symbol,
  [anon_sym_faccumulate] = sym_symbol,
  [anon_sym_local] = sym_symbol,
  [anon_sym_var] = sym_symbol,
  [anon_sym_global] = sym_symbol,
  [anon_sym_set] = sym_symbol,
  [anon_sym_let] = sym_symbol,
  [anon_sym_import_DASHmacros] = sym_symbol,
  [anon_sym_quote] = sym_symbol,
  [anon_sym_unquote] = sym_symbol,
  [sym_nil] = sym_nil,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_POUND] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_QMARK_DOT] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_TILDE_EQ] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_COLON2] = anon_sym_COLON,
  [anon_sym_DOLLAR_DOT_DOT_DOT] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_DOT_DOT_DOT2] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_DOT_DOT] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_nil] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_true2] = anon_sym_fnl_SLASHdocstring,
  [anon_sym_false2] = anon_sym_fnl_SLASHdocstring,
  [aux_sym__colon_string_token1] = anon_sym_fnl_SLASHdocstring,
  [aux_sym__double_quote_string_content_token1] = aux_sym__double_quote_string_content_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_number] = sym_number,
  [sym_symbol_option] = sym_symbol_option,
  [aux_sym__multi_symbol_fragment_token1] = aux_sym__multi_symbol_fragment_token1,
  [anon_sym_POUND2] = sym_symbol,
  [anon_sym_QMARK_DOT2] = sym_symbol,
  [anon_sym_TILDE_EQ2] = sym_symbol,
  [anon_sym_DOLLAR_DOT_DOT_DOT2] = sym_symbol,
  [anon_sym_DOT_DOT2] = sym_symbol,
  [anon_sym_DOT2] = sym_symbol,
  [sym__hashfn_reader_macro_char] = sym__hashfn_reader_macro_char,
  [sym__quote_reader_macro_char] = sym__quote_reader_macro_char,
  [sym__quasi_quote_reader_macro_char] = sym__quasi_quote_reader_macro_char,
  [sym__unquote_reader_macro_char] = sym__unquote_reader_macro_char,
  [sym___reader_macro_count] = sym___reader_macro_count,
  [sym___colon_string_start_mark] = sym___colon_string_start_mark,
  [sym___colon_string_end_mark] = sym___colon_string_end_mark,
  [sym_shebang] = sym_shebang,
  [sym___token_count] = sym___token_count,
  [sym_program] = sym_program,
  [sym_comment] = sym_comment,
  [sym__sexp] = sym__sexp,
  [sym_hashfn_reader_macro] = sym_hashfn_reader_macro,
  [sym_quote_reader_macro] = sym_quote_reader_macro,
  [sym_quasi_quote_reader_macro] = sym_quasi_quote_reader_macro,
  [sym_unquote_reader_macro] = sym_unquote_reader_macro,
  [sym__reader_macro] = sym__reader_macro,
  [sym__list_content] = sym__list_content,
  [sym_list] = sym_list,
  [sym__binding] = sym__binding,
  [sym_list_binding] = sym_list_binding,
  [sym_rest_binding] = sym_rest_binding,
  [sym_sequence_binding] = sym_sequence_binding,
  [sym__table_binding_key] = sym__table_binding_key,
  [sym_table_binding_pair] = sym_table_binding_pair,
  [sym_table_binding] = sym_table_binding,
  [sym_binding_pair] = sym_binding_pair,
  [sym__literal_binding] = sym__literal_binding,
  [sym_case_guard_or_special] = sym_case_guard_or_special,
  [sym_case_guard] = sym_case_guard,
  [sym__case_lhs] = sym__case_lhs,
  [sym_case_pair] = sym_case_pair,
  [sym_case_catch] = sym_case_catch,
  [sym_if_pair] = sym_if_pair,
  [sym__function_identifier] = sym__function_identifier,
  [sym_sequence_arguments] = sym_sequence_arguments,
  [sym__table_metadata_key_docstring] = sym_string,
  [sym__table_metadata_docstring] = sym__table_metadata_docstring,
  [sym__table_metadata_key_arglist] = sym_string,
  [sym__table_metadata_arglist] = sym__table_metadata_arglist,
  [sym__table_metadata_generic] = sym__table_metadata_generic,
  [sym_table_metadata_pair] = sym_table_metadata_pair,
  [sym_table_metadata] = sym_table_metadata,
  [sym__function_inner_body_all] = sym__function_inner_body_all,
  [sym__function_inner_body_docstring] = sym__function_inner_body_docstring,
  [sym__function_inner_body_metadata] = sym__function_inner_body_metadata,
  [sym__function_inner_body_generic] = sym__function_inner_body_generic,
  [sym__function_inner_body] = sym__function_inner_body,
  [sym__function_body] = sym__function_body,
  [sym__iter_option_legacy] = sym__iter_option_legacy,
  [sym__iter_option_lhs] = sym__iter_option_lhs,
  [sym_iter_option] = sym_iter_option,
  [sym__iter_body] = sym__iter_body,
  [sym__each_iter_body] = sym__each_iter_body,
  [sym__collect_iter_body] = sym__each_iter_body,
  [sym_accumulator_pair] = sym_accumulator_pair,
  [sym__accumulate_iter_body] = sym__each_iter_body,
  [sym__fiter_body] = sym__fiter_body,
  [sym__fcollect_iter_body] = sym__fcollect_iter_body,
  [sym__faccumulate_iter_body] = sym__fcollect_iter_body,
  [sym__set_binding_pair_key] = sym__set_binding_pair_key,
  [sym__set_binding_pair] = sym_binding_pair,
  [sym_let_vars] = sym_let_vars,
  [sym_case_form] = sym_case_form,
  [sym_match_form] = sym_match_form,
  [sym_case_try_form] = sym_case_try_form,
  [sym_match_try_form] = sym_match_try_form,
  [sym_if_form] = sym_if_form,
  [sym_fn_form] = sym_fn_form,
  [sym_lambda_form] = sym_lambda_form,
  [sym_macro_form] = sym_macro_form,
  [sym_hashfn_form] = sym_hashfn_form,
  [sym_each_form] = sym_each_form,
  [sym_collect_form] = sym_collect_form,
  [sym_icollect_form] = sym_icollect_form,
  [sym_accumulate_form] = sym_accumulate_form,
  [sym_for_form] = sym_for_form,
  [sym_fcollect_form] = sym_fcollect_form,
  [sym_faccumulate_form] = sym_faccumulate_form,
  [sym_local_form] = sym_local_form,
  [sym_var_form] = sym_var_form,
  [sym_global_form] = sym_global_form,
  [sym_set_form] = sym_set_form,
  [sym_let_form] = sym_let_form,
  [sym_import_macros_form] = sym_import_macros_form,
  [sym_quote_form] = sym_quote_form,
  [sym_unquote_form] = sym_unquote_form,
  [sym__form] = sym__form,
  [sym_sequence] = sym_sequence,
  [sym_table_pair] = sym_table_pair,
  [sym_table] = sym_table,
  [sym__literal] = sym__literal,
  [sym_boolean] = sym_boolean,
  [sym__colon_string] = sym__colon_string,
  [sym__double_quote_string_content] = sym__double_quote_string_content,
  [sym__double_quote_string] = sym__double_quote_string,
  [sym_string] = sym_string,
  [sym_multi_symbol] = sym_multi_symbol,
  [sym_multi_symbol_method] = sym_multi_symbol_method,
  [sym__multi_symbol_fragment] = sym__multi_symbol_fragment,
  [sym__special_override_symbol] = sym__special_override_symbol,
  [aux_sym_program_repeat1] = aux_sym_program_repeat1,
  [aux_sym__list_content_repeat1] = aux_sym__list_content_repeat1,
  [aux_sym_list_binding_repeat1] = aux_sym_list_binding_repeat1,
  [aux_sym_table_binding_repeat1] = aux_sym_table_binding_repeat1,
  [aux_sym_case_guard_repeat1] = aux_sym_case_guard_repeat1,
  [aux_sym_case_catch_repeat1] = aux_sym_case_catch_repeat1,
  [aux_sym_table_metadata_repeat1] = aux_sym_table_metadata_repeat1,
  [aux_sym__iter_body_repeat1] = aux_sym__iter_body_repeat1,
  [aux_sym__iter_body_repeat2] = aux_sym__iter_body_repeat2,
  [aux_sym_let_vars_repeat1] = aux_sym_let_vars_repeat1,
  [aux_sym_if_form_repeat1] = aux_sym_if_form_repeat1,
  [aux_sym_table_repeat1] = aux_sym_table_repeat1,
  [aux_sym__double_quote_string_repeat1] = aux_sym__double_quote_string_repeat1,
  [aux_sym_multi_symbol_repeat1] = aux_sym_multi_symbol_repeat1,
  [alias_sym_boolean_binding] = alias_sym_boolean_binding,
  [alias_sym_docstring] = alias_sym_docstring,
  [alias_sym_nil_binding] = alias_sym_nil_binding,
  [alias_sym_number_binding] = alias_sym_number_binding,
  [alias_sym_string_binding] = alias_sym_string_binding,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_symbol] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_comment_token1] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_where] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_fnl_SLASHdocstring] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fnl_SLASHarglist] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONuntil] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLONinto] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_case_DASHtry] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_match_DASHtry] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u03bb] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_macro] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_hashfn] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_each] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_collect] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_icollect] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_accumulate] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_fcollect] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_faccumulate] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_local] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_global] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import_DASHmacros] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_quote] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_unquote] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_DOT_DOT_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT_DOT2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nil] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_false2] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__colon_string_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__double_quote_string_content_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_symbol_option] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__multi_symbol_fragment_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK_DOT2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE_EQ2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR_DOT_DOT_DOT2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT_DOT2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT2] = {
    .visible = true,
    .named = true,
  },
  [sym__hashfn_reader_macro_char] = {
    .visible = true,
    .named = false,
  },
  [sym__quote_reader_macro_char] = {
    .visible = true,
    .named = false,
  },
  [sym__quasi_quote_reader_macro_char] = {
    .visible = true,
    .named = false,
  },
  [sym__unquote_reader_macro_char] = {
    .visible = true,
    .named = false,
  },
  [sym___reader_macro_count] = {
    .visible = false,
    .named = true,
  },
  [sym___colon_string_start_mark] = {
    .visible = false,
    .named = true,
  },
  [sym___colon_string_end_mark] = {
    .visible = false,
    .named = true,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [sym___token_count] = {
    .visible = false,
    .named = true,
  },
  [sym_program] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__sexp] = {
    .visible = false,
    .named = true,
  },
  [sym_hashfn_reader_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_quote_reader_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_quasi_quote_reader_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_unquote_reader_macro] = {
    .visible = true,
    .named = true,
  },
  [sym__reader_macro] = {
    .visible = false,
    .named = true,
  },
  [sym__list_content] = {
    .visible = false,
    .named = true,
  },
  [sym_list] = {
    .visible = true,
    .named = true,
  },
  [sym__binding] = {
    .visible = false,
    .named = true,
  },
  [sym_list_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_binding] = {
    .visible = true,
    .named = true,
  },
  [sym__table_binding_key] = {
    .visible = false,
    .named = true,
  },
  [sym_table_binding_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_table_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_binding_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__literal_binding] = {
    .visible = false,
    .named = true,
  },
  [sym_case_guard_or_special] = {
    .visible = true,
    .named = true,
  },
  [sym_case_guard] = {
    .visible = true,
    .named = true,
  },
  [sym__case_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_case_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_case_catch] = {
    .visible = true,
    .named = true,
  },
  [sym_if_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__function_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_sequence_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__table_metadata_key_docstring] = {
    .visible = true,
    .named = true,
  },
  [sym__table_metadata_docstring] = {
    .visible = false,
    .named = true,
  },
  [sym__table_metadata_key_arglist] = {
    .visible = true,
    .named = true,
  },
  [sym__table_metadata_arglist] = {
    .visible = false,
    .named = true,
  },
  [sym__table_metadata_generic] = {
    .visible = false,
    .named = true,
  },
  [sym_table_metadata_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_table_metadata] = {
    .visible = true,
    .named = true,
  },
  [sym__function_inner_body_all] = {
    .visible = false,
    .named = true,
  },
  [sym__function_inner_body_docstring] = {
    .visible = false,
    .named = true,
  },
  [sym__function_inner_body_metadata] = {
    .visible = false,
    .named = true,
  },
  [sym__function_inner_body_generic] = {
    .visible = false,
    .named = true,
  },
  [sym__function_inner_body] = {
    .visible = false,
    .named = true,
  },
  [sym__function_body] = {
    .visible = false,
    .named = true,
  },
  [sym__iter_option_legacy] = {
    .visible = false,
    .named = true,
  },
  [sym__iter_option_lhs] = {
    .visible = false,
    .named = true,
  },
  [sym_iter_option] = {
    .visible = true,
    .named = true,
  },
  [sym__iter_body] = {
    .visible = false,
    .named = true,
  },
  [sym__each_iter_body] = {
    .visible = true,
    .named = true,
  },
  [sym__collect_iter_body] = {
    .visible = true,
    .named = true,
  },
  [sym_accumulator_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__accumulate_iter_body] = {
    .visible = true,
    .named = true,
  },
  [sym__fiter_body] = {
    .visible = false,
    .named = true,
  },
  [sym__fcollect_iter_body] = {
    .visible = true,
    .named = true,
  },
  [sym__faccumulate_iter_body] = {
    .visible = true,
    .named = true,
  },
  [sym__set_binding_pair_key] = {
    .visible = false,
    .named = true,
  },
  [sym__set_binding_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_let_vars] = {
    .visible = true,
    .named = true,
  },
  [sym_case_form] = {
    .visible = true,
    .named = true,
  },
  [sym_match_form] = {
    .visible = true,
    .named = true,
  },
  [sym_case_try_form] = {
    .visible = true,
    .named = true,
  },
  [sym_match_try_form] = {
    .visible = true,
    .named = true,
  },
  [sym_if_form] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_form] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_form] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_form] = {
    .visible = true,
    .named = true,
  },
  [sym_hashfn_form] = {
    .visible = true,
    .named = true,
  },
  [sym_each_form] = {
    .visible = true,
    .named = true,
  },
  [sym_collect_form] = {
    .visible = true,
    .named = true,
  },
  [sym_icollect_form] = {
    .visible = true,
    .named = true,
  },
  [sym_accumulate_form] = {
    .visible = true,
    .named = true,
  },
  [sym_for_form] = {
    .visible = true,
    .named = true,
  },
  [sym_fcollect_form] = {
    .visible = true,
    .named = true,
  },
  [sym_faccumulate_form] = {
    .visible = true,
    .named = true,
  },
  [sym_local_form] = {
    .visible = true,
    .named = true,
  },
  [sym_var_form] = {
    .visible = true,
    .named = true,
  },
  [sym_global_form] = {
    .visible = true,
    .named = true,
  },
  [sym_set_form] = {
    .visible = true,
    .named = true,
  },
  [sym_let_form] = {
    .visible = true,
    .named = true,
  },
  [sym_import_macros_form] = {
    .visible = true,
    .named = true,
  },
  [sym_quote_form] = {
    .visible = true,
    .named = true,
  },
  [sym_unquote_form] = {
    .visible = true,
    .named = true,
  },
  [sym__form] = {
    .visible = false,
    .named = true,
  },
  [sym_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_table_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_table] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym__colon_string] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quote_string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quote_string] = {
    .visible = false,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_multi_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_multi_symbol_method] = {
    .visible = true,
    .named = true,
  },
  [sym__multi_symbol_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym__special_override_symbol] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_program_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__list_content_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_list_binding_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_binding_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_guard_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_catch_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_metadata_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__iter_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__iter_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_let_vars_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_form_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_table_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quote_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_multi_symbol_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_boolean_binding] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_docstring] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_nil_binding] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_number_binding] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_string_binding] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_accumulator_binding = 1,
  field_accumulator_value = 2,
  field_args = 3,
  field_base = 4,
  field_binding = 5,
  field_body = 6,
  field_call = 7,
  field_catch = 8,
  field_close = 9,
  field_colon = 10,
  field_condition = 11,
  field_content = 12,
  field_docstring = 13,
  field_else = 14,
  field_expression = 15,
  field_from = 16,
  field_guard = 17,
  field_imports = 18,
  field_index = 19,
  field_item = 20,
  field_iter_body = 21,
  field_iterator = 22,
  field_key = 23,
  field_lhs = 24,
  field_macro = 25,
  field_member = 26,
  field_metadata = 27,
  field_method = 28,
  field_module = 29,
  field_name = 30,
  field_open = 31,
  field_option = 32,
  field_rhs = 33,
  field_step = 34,
  field_to = 35,
  field_value = 36,
  field_vars = 37,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_accumulator_binding] = "accumulator_binding",
  [field_accumulator_value] = "accumulator_value",
  [field_args] = "args",
  [field_base] = "base",
  [field_binding] = "binding",
  [field_body] = "body",
  [field_call] = "call",
  [field_catch] = "catch",
  [field_close] = "close",
  [field_colon] = "colon",
  [field_condition] = "condition",
  [field_content] = "content",
  [field_docstring] = "docstring",
  [field_else] = "else",
  [field_expression] = "expression",
  [field_from] = "from",
  [field_guard] = "guard",
  [field_imports] = "imports",
  [field_index] = "index",
  [field_item] = "item",
  [field_iter_body] = "iter_body",
  [field_iterator] = "iterator",
  [field_key] = "key",
  [field_lhs] = "lhs",
  [field_macro] = "macro",
  [field_member] = "member",
  [field_metadata] = "metadata",
  [field_method] = "method",
  [field_module] = "module",
  [field_name] = "name",
  [field_open] = "open",
  [field_option] = "option",
  [field_rhs] = "rhs",
  [field_step] = "step",
  [field_to] = "to",
  [field_value] = "value",
  [field_vars] = "vars",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 2},
  [3] = {.index = 2, .length = 3},
  [4] = {.index = 5, .length = 2},
  [5] = {.index = 7, .length = 2},
  [6] = {.index = 9, .length = 2},
  [7] = {.index = 11, .length = 1},
  [8] = {.index = 12, .length = 1},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 1},
  [11] = {.index = 16, .length = 2},
  [12] = {.index = 18, .length = 1},
  [16] = {.index = 19, .length = 1},
  [19] = {.index = 20, .length = 2},
  [20] = {.index = 22, .length = 4},
  [21] = {.index = 26, .length = 3},
  [22] = {.index = 29, .length = 2},
  [23] = {.index = 31, .length = 2},
  [24] = {.index = 33, .length = 2},
  [25] = {.index = 35, .length = 3},
  [26] = {.index = 38, .length = 2},
  [27] = {.index = 40, .length = 1},
  [28] = {.index = 41, .length = 2},
  [29] = {.index = 38, .length = 2},
  [30] = {.index = 43, .length = 4},
  [31] = {.index = 47, .length = 2},
  [32] = {.index = 49, .length = 3},
  [33] = {.index = 52, .length = 2},
  [34] = {.index = 54, .length = 3},
  [35] = {.index = 57, .length = 2},
  [36] = {.index = 59, .length = 2},
  [37] = {.index = 61, .length = 1},
  [38] = {.index = 62, .length = 4},
  [39] = {.index = 66, .length = 8},
  [40] = {.index = 74, .length = 1},
  [41] = {.index = 75, .length = 9},
  [42] = {.index = 84, .length = 1},
  [43] = {.index = 85, .length = 9},
  [44] = {.index = 94, .length = 11},
  [45] = {.index = 105, .length = 2},
  [46] = {.index = 107, .length = 5},
  [47] = {.index = 112, .length = 4},
  [48] = {.index = 116, .length = 4},
  [49] = {.index = 120, .length = 5},
  [50] = {.index = 125, .length = 4},
  [51] = {.index = 129, .length = 3},
  [52] = {.index = 132, .length = 5},
  [53] = {.index = 137, .length = 4},
  [54] = {.index = 141, .length = 2},
  [55] = {.index = 143, .length = 2},
  [56] = {.index = 145, .length = 2},
  [57] = {.index = 147, .length = 5},
  [58] = {.index = 152, .length = 2},
  [59] = {.index = 154, .length = 2},
  [60] = {.index = 156, .length = 10},
  [61] = {.index = 166, .length = 2},
  [62] = {.index = 168, .length = 3},
  [63] = {.index = 171, .length = 10},
  [64] = {.index = 181, .length = 7},
  [65] = {.index = 188, .length = 12},
  [66] = {.index = 33, .length = 2},
  [67] = {.index = 200, .length = 2},
  [68] = {.index = 202, .length = 5},
  [69] = {.index = 207, .length = 5},
  [70] = {.index = 212, .length = 3},
  [71] = {.index = 215, .length = 5},
  [72] = {.index = 220, .length = 4},
  [73] = {.index = 13, .length = 2},
  [74] = {.index = 224, .length = 5},
  [75] = {.index = 224, .length = 5},
  [76] = {.index = 229, .length = 3},
  [77] = {.index = 232, .length = 1},
  [78] = {.index = 233, .length = 3},
  [79] = {.index = 236, .length = 5},
  [80] = {.index = 241, .length = 4},
  [81] = {.index = 245, .length = 4},
  [82] = {.index = 249, .length = 7},
  [83] = {.index = 256, .length = 1},
  [84] = {.index = 31, .length = 2},
  [85] = {.index = 35, .length = 3},
  [86] = {.index = 257, .length = 2},
  [87] = {.index = 259, .length = 2},
  [88] = {.index = 261, .length = 5},
  [89] = {.index = 266, .length = 5},
  [90] = {.index = 271, .length = 2},
  [91] = {.index = 273, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_content, 0, .inherited = true},
    {field_open, 0, .inherited = true},
  [2] =
    {field_close, 0, .inherited = true},
    {field_content, 0, .inherited = true},
    {field_open, 0, .inherited = true},
  [5] =
    {field_body, 1},
    {field_colon, 0},
  [7] =
    {field_expression, 1},
    {field_macro, 0},
  [9] =
    {field_close, 1},
    {field_open, 0},
  [11] =
    {field_call, 0},
  [12] =
    {field_item, 0},
  [13] =
    {field_content, 1},
    {field_open, 0},
  [15] =
    {field_key, 0},
  [16] =
    {field_base, 0},
    {field_member, 1, .inherited = true},
  [18] =
    {field_args, 0},
  [19] =
    {field_lhs, 0},
  [20] =
    {field_call, 0},
    {field_item, 1, .inherited = true},
  [22] =
    {field_call, 1, .inherited = true},
    {field_close, 2},
    {field_item, 1, .inherited = true},
    {field_open, 0},
  [26] =
    {field_close, 2},
    {field_item, 1, .inherited = true},
    {field_open, 0},
  [29] =
    {field_item, 0, .inherited = true},
    {field_item, 1, .inherited = true},
  [31] =
    {field_content, 2},
    {field_open, 0},
  [33] =
    {field_key, 0},
    {field_value, 1},
  [35] =
    {field_close, 2},
    {field_content, 1},
    {field_open, 0},
  [38] =
    {field_base, 0},
    {field_method, 2},
  [40] =
    {field_member, 1},
  [41] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [43] =
    {field_call, 1},
    {field_close, 3},
    {field_item, 2},
    {field_open, 0},
  [47] =
    {field_condition, 0},
    {field_expression, 1},
  [49] =
    {field_call, 1},
    {field_close, 3},
    {field_open, 0},
  [52] =
    {field_args, 1},
    {field_name, 0},
  [54] =
    {field_docstring, 0, .inherited = true},
    {field_item, 0, .inherited = true},
    {field_metadata, 0, .inherited = true},
  [57] =
    {field_docstring, 0, .inherited = true},
    {field_item, 0, .inherited = true},
  [59] =
    {field_item, 0, .inherited = true},
    {field_metadata, 0, .inherited = true},
  [61] =
    {field_item, 0, .inherited = true},
  [62] =
    {field_args, 0},
    {field_docstring, 1, .inherited = true},
    {field_item, 1, .inherited = true},
    {field_metadata, 1, .inherited = true},
  [66] =
    {field_args, 2, .inherited = true},
    {field_call, 1},
    {field_close, 3},
    {field_docstring, 2, .inherited = true},
    {field_item, 2, .inherited = true},
    {field_metadata, 2, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_open, 0},
  [74] =
    {field_binding, 0},
  [75] =
    {field_binding, 2, .inherited = true},
    {field_call, 1},
    {field_close, 2, .inherited = true},
    {field_close, 3},
    {field_iter_body, 2},
    {field_iterator, 2, .inherited = true},
    {field_open, 0},
    {field_open, 2, .inherited = true},
    {field_option, 2, .inherited = true},
  [84] =
    {field_accumulator_binding, 0},
  [85] =
    {field_call, 1},
    {field_close, 3},
    {field_from, 2, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_iter_body, 2},
    {field_open, 0},
    {field_option, 2, .inherited = true},
    {field_step, 2, .inherited = true},
    {field_to, 2, .inherited = true},
  [94] =
    {field_call, 1},
    {field_close, 2, .inherited = true},
    {field_close, 3},
    {field_from, 2, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_iter_body, 2},
    {field_open, 0},
    {field_open, 2, .inherited = true},
    {field_option, 2, .inherited = true},
    {field_step, 2, .inherited = true},
    {field_to, 2, .inherited = true},
  [105] =
    {field_lhs, 0},
    {field_rhs, 1},
  [107] =
    {field_call, 1},
    {field_close, 3},
    {field_lhs, 2, .inherited = true},
    {field_open, 0},
    {field_rhs, 2, .inherited = true},
  [112] =
    {field_call, 1},
    {field_close, 3},
    {field_open, 0},
    {field_vars, 2},
  [116] =
    {field_call, 1},
    {field_close, 4},
    {field_item, 2},
    {field_open, 0},
  [120] =
    {field_call, 1},
    {field_catch, 3},
    {field_close, 4},
    {field_item, 2},
    {field_open, 0},
  [125] =
    {field_call, 1},
    {field_close, 4},
    {field_else, 3},
    {field_open, 0},
  [129] =
    {field_close, 2},
    {field_item, 1},
    {field_open, 0},
  [132] =
    {field_args, 1},
    {field_docstring, 2, .inherited = true},
    {field_item, 2, .inherited = true},
    {field_metadata, 2, .inherited = true},
    {field_name, 0},
  [137] =
    {field_close, 0, .inherited = true},
    {field_content, 0, .inherited = true},
    {field_key, 0},
    {field_open, 0, .inherited = true},
  [141] =
    {field_key, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [143] =
    {field_item, 1, .inherited = true},
    {field_metadata, 0},
  [145] =
    {field_docstring, 0},
    {field_item, 1, .inherited = true},
  [147] =
    {field_binding, 1, .inherited = true},
    {field_close, 2},
    {field_iterator, 1, .inherited = true},
    {field_open, 0},
    {field_option, 1, .inherited = true},
  [152] =
    {field_binding, 0, .inherited = true},
    {field_iterator, 1},
  [154] =
    {field_binding, 0, .inherited = true},
    {field_binding, 1, .inherited = true},
  [156] =
    {field_binding, 2, .inherited = true},
    {field_call, 1},
    {field_close, 2, .inherited = true},
    {field_close, 4},
    {field_item, 3, .inherited = true},
    {field_iter_body, 2},
    {field_iterator, 2, .inherited = true},
    {field_open, 0},
    {field_open, 2, .inherited = true},
    {field_option, 2, .inherited = true},
  [166] =
    {field_accumulator_binding, 0},
    {field_accumulator_value, 1},
  [168] =
    {field_from, 1},
    {field_index, 0},
    {field_to, 2},
  [171] =
    {field_call, 1},
    {field_close, 4},
    {field_from, 2, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_item, 3, .inherited = true},
    {field_iter_body, 2},
    {field_open, 0},
    {field_option, 2, .inherited = true},
    {field_step, 2, .inherited = true},
    {field_to, 2, .inherited = true},
  [181] =
    {field_close, 2},
    {field_from, 1, .inherited = true},
    {field_index, 1, .inherited = true},
    {field_open, 0},
    {field_option, 1, .inherited = true},
    {field_step, 1, .inherited = true},
    {field_to, 1, .inherited = true},
  [188] =
    {field_call, 1},
    {field_close, 2, .inherited = true},
    {field_close, 4},
    {field_from, 2, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_item, 3, .inherited = true},
    {field_iter_body, 2},
    {field_open, 0},
    {field_open, 2, .inherited = true},
    {field_option, 2, .inherited = true},
    {field_step, 2, .inherited = true},
    {field_to, 2, .inherited = true},
  [200] =
    {field_close, 2},
    {field_open, 0},
  [202] =
    {field_call, 1},
    {field_close, 4},
    {field_item, 3, .inherited = true},
    {field_open, 0},
    {field_vars, 2},
  [207] =
    {field_call, 1},
    {field_close, 4},
    {field_imports, 2},
    {field_module, 3},
    {field_open, 0},
  [212] =
    {field_call, 1},
    {field_close, 2},
    {field_open, 0},
  [215] =
    {field_call, 1},
    {field_catch, 4},
    {field_close, 5},
    {field_item, 2},
    {field_open, 0},
  [220] =
    {field_close, 3},
    {field_item, 1, .inherited = true},
    {field_item, 2},
    {field_open, 0},
  [224] =
    {field_close, 0, .inherited = true},
    {field_content, 0, .inherited = true},
    {field_key, 0},
    {field_open, 0, .inherited = true},
    {field_value, 1},
  [229] =
    {field_docstring, 0},
    {field_item, 2, .inherited = true},
    {field_metadata, 1},
  [232] =
    {field_option, 0},
  [233] =
    {field_binding, 0, .inherited = true},
    {field_iterator, 1},
    {field_option, 2, .inherited = true},
  [236] =
    {field_binding, 2, .inherited = true},
    {field_close, 3},
    {field_iterator, 2, .inherited = true},
    {field_open, 0},
    {field_option, 2, .inherited = true},
  [241] =
    {field_from, 1},
    {field_index, 0},
    {field_step, 3},
    {field_to, 2},
  [245] =
    {field_from, 1},
    {field_index, 0},
    {field_option, 3, .inherited = true},
    {field_to, 2},
  [249] =
    {field_close, 3},
    {field_from, 2, .inherited = true},
    {field_index, 2, .inherited = true},
    {field_open, 0},
    {field_option, 2, .inherited = true},
    {field_step, 2, .inherited = true},
    {field_to, 2, .inherited = true},
  [256] =
    {field_guard, 0},
  [257] =
    {field_option, 0},
    {field_value, 1},
  [259] =
    {field_option, 0, .inherited = true},
    {field_option, 1, .inherited = true},
  [261] =
    {field_from, 1},
    {field_index, 0},
    {field_option, 4, .inherited = true},
    {field_step, 3},
    {field_to, 2},
  [266] =
    {field_call, 1},
    {field_close, 4},
    {field_guard, 3, .inherited = true},
    {field_item, 2},
    {field_open, 0},
  [271] =
    {field_guard, 0, .inherited = true},
    {field_guard, 1, .inherited = true},
  [273] =
    {field_call, 1},
    {field_close, 3},
    {field_item, 2, .inherited = true},
    {field_open, 0},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_symbol,
  },
  [9] = {
    [1] = anon_sym_fnl_SLASHdocstring,
  },
  [11] = {
    [0] = aux_sym__multi_symbol_fragment_token1,
  },
  [13] = {
    [0] = alias_sym_nil_binding,
  },
  [14] = {
    [0] = alias_sym_number_binding,
  },
  [15] = {
    [0] = anon_sym_DOT_DOT_DOT,
  },
  [17] = {
    [0] = alias_sym_boolean_binding,
  },
  [18] = {
    [0] = alias_sym_string_binding,
  },
  [23] = {
    [2] = anon_sym_fnl_SLASHdocstring,
  },
  [25] = {
    [1] = anon_sym_fnl_SLASHdocstring,
  },
  [26] = {
    [0] = aux_sym__multi_symbol_fragment_token1,
  },
  [43] = {
    [2] = sym__fcollect_iter_body,
  },
  [56] = {
    [0] = alias_sym_docstring,
  },
  [62] = {
    [0] = anon_sym_DOT_DOT_DOT,
  },
  [63] = {
    [2] = sym__fcollect_iter_body,
  },
  [66] = {
    [1] = anon_sym_DOT_DOT_DOT,
  },
  [74] = {
    [1] = alias_sym_docstring,
  },
  [76] = {
    [0] = alias_sym_docstring,
  },
  [80] = {
    [0] = anon_sym_DOT_DOT_DOT,
  },
  [81] = {
    [0] = anon_sym_DOT_DOT_DOT,
  },
  [88] = {
    [0] = anon_sym_DOT_DOT_DOT,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__fiter_body, 2,
    sym__fiter_body,
    sym__fcollect_iter_body,
  sym_boolean, 2,
    sym_boolean,
    alias_sym_boolean_binding,
  sym_string, 3,
    sym_string,
    alias_sym_docstring,
    alias_sym_string_binding,
  aux_sym__double_quote_string_repeat1, 2,
    aux_sym__double_quote_string_repeat1,
    anon_sym_fnl_SLASHdocstring,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 5,
  [6] = 5,
  [7] = 5,
  [8] = 5,
  [9] = 5,
  [10] = 10,
  [11] = 11,
  [12] = 11,
  [13] = 11,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 16,
  [18] = 18,
  [19] = 18,
  [20] = 20,
  [21] = 18,
  [22] = 22,
  [23] = 23,
  [24] = 22,
  [25] = 25,
  [26] = 22,
  [27] = 27,
  [28] = 23,
  [29] = 29,
  [30] = 23,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 22,
  [35] = 29,
  [36] = 23,
  [37] = 22,
  [38] = 29,
  [39] = 29,
  [40] = 23,
  [41] = 31,
  [42] = 29,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 47,
  [55] = 53,
  [56] = 56,
  [57] = 57,
  [58] = 47,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 47,
  [68] = 57,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 44,
  [74] = 74,
  [75] = 75,
  [76] = 43,
  [77] = 44,
  [78] = 75,
  [79] = 56,
  [80] = 74,
  [81] = 72,
  [82] = 82,
  [83] = 71,
  [84] = 70,
  [85] = 56,
  [86] = 44,
  [87] = 53,
  [88] = 43,
  [89] = 75,
  [90] = 74,
  [91] = 72,
  [92] = 71,
  [93] = 70,
  [94] = 57,
  [95] = 69,
  [96] = 66,
  [97] = 65,
  [98] = 59,
  [99] = 63,
  [100] = 60,
  [101] = 61,
  [102] = 62,
  [103] = 62,
  [104] = 104,
  [105] = 63,
  [106] = 61,
  [107] = 65,
  [108] = 60,
  [109] = 66,
  [110] = 59,
  [111] = 57,
  [112] = 53,
  [113] = 113,
  [114] = 59,
  [115] = 60,
  [116] = 61,
  [117] = 62,
  [118] = 56,
  [119] = 44,
  [120] = 43,
  [121] = 75,
  [122] = 63,
  [123] = 74,
  [124] = 72,
  [125] = 69,
  [126] = 65,
  [127] = 71,
  [128] = 70,
  [129] = 129,
  [130] = 66,
  [131] = 69,
  [132] = 69,
  [133] = 70,
  [134] = 66,
  [135] = 65,
  [136] = 63,
  [137] = 47,
  [138] = 62,
  [139] = 61,
  [140] = 60,
  [141] = 59,
  [142] = 71,
  [143] = 72,
  [144] = 74,
  [145] = 145,
  [146] = 57,
  [147] = 75,
  [148] = 43,
  [149] = 53,
  [150] = 56,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 151,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 151,
  [161] = 161,
  [162] = 151,
  [163] = 155,
  [164] = 151,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 166,
  [175] = 167,
  [176] = 168,
  [177] = 170,
  [178] = 178,
  [179] = 179,
  [180] = 178,
  [181] = 181,
  [182] = 172,
  [183] = 183,
  [184] = 169,
  [185] = 171,
  [186] = 178,
  [187] = 167,
  [188] = 170,
  [189] = 168,
  [190] = 168,
  [191] = 167,
  [192] = 170,
  [193] = 193,
  [194] = 165,
  [195] = 195,
  [196] = 165,
  [197] = 197,
  [198] = 178,
  [199] = 167,
  [200] = 168,
  [201] = 168,
  [202] = 170,
  [203] = 178,
  [204] = 169,
  [205] = 171,
  [206] = 193,
  [207] = 170,
  [208] = 178,
  [209] = 195,
  [210] = 165,
  [211] = 195,
  [212] = 171,
  [213] = 173,
  [214] = 166,
  [215] = 181,
  [216] = 179,
  [217] = 181,
  [218] = 172,
  [219] = 197,
  [220] = 169,
  [221] = 173,
  [222] = 171,
  [223] = 166,
  [224] = 165,
  [225] = 167,
  [226] = 195,
  [227] = 181,
  [228] = 178,
  [229] = 170,
  [230] = 168,
  [231] = 167,
  [232] = 169,
  [233] = 195,
  [234] = 172,
  [235] = 181,
  [236] = 173,
  [237] = 166,
  [238] = 173,
  [239] = 172,
  [240] = 240,
  [241] = 240,
  [242] = 242,
  [243] = 240,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 247,
  [249] = 249,
  [250] = 246,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 254,
  [256] = 256,
  [257] = 256,
  [258] = 258,
  [259] = 258,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 262,
  [264] = 261,
  [265] = 265,
  [266] = 260,
  [267] = 265,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 291,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 271,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 292,
  [309] = 309,
  [310] = 256,
  [311] = 293,
  [312] = 298,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 300,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 303,
  [325] = 325,
  [326] = 304,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 306,
  [334] = 334,
  [335] = 307,
  [336] = 297,
  [337] = 290,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 260,
  [343] = 313,
  [344] = 344,
  [345] = 272,
  [346] = 289,
  [347] = 314,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 270,
  [352] = 315,
  [353] = 275,
  [354] = 316,
  [355] = 317,
  [356] = 318,
  [357] = 320,
  [358] = 323,
  [359] = 274,
  [360] = 325,
  [361] = 328,
  [362] = 329,
  [363] = 276,
  [364] = 268,
  [365] = 280,
  [366] = 282,
  [367] = 284,
  [368] = 288,
  [369] = 330,
  [370] = 331,
  [371] = 332,
  [372] = 334,
  [373] = 286,
  [374] = 295,
  [375] = 296,
  [376] = 301,
  [377] = 302,
  [378] = 338,
  [379] = 339,
  [380] = 340,
  [381] = 381,
  [382] = 341,
  [383] = 348,
  [384] = 384,
  [385] = 385,
  [386] = 273,
  [387] = 350,
  [388] = 277,
  [389] = 344,
  [390] = 278,
  [391] = 384,
  [392] = 256,
  [393] = 385,
  [394] = 349,
  [395] = 381,
  [396] = 287,
  [397] = 285,
  [398] = 283,
  [399] = 281,
  [400] = 305,
  [401] = 269,
  [402] = 309,
  [403] = 279,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 262,
  [410] = 410,
  [411] = 265,
  [412] = 246,
  [413] = 413,
  [414] = 414,
  [415] = 247,
  [416] = 416,
  [417] = 405,
  [418] = 404,
  [419] = 414,
  [420] = 420,
  [421] = 405,
  [422] = 422,
  [423] = 405,
  [424] = 416,
  [425] = 416,
  [426] = 414,
  [427] = 240,
  [428] = 404,
  [429] = 414,
  [430] = 404,
  [431] = 405,
  [432] = 414,
  [433] = 416,
  [434] = 416,
  [435] = 404,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 436,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 256,
  [445] = 272,
  [446] = 446,
  [447] = 437,
  [448] = 442,
  [449] = 443,
  [450] = 443,
  [451] = 442,
  [452] = 452,
  [453] = 438,
  [454] = 440,
  [455] = 440,
  [456] = 436,
  [457] = 436,
  [458] = 436,
  [459] = 440,
  [460] = 460,
  [461] = 408,
  [462] = 443,
  [463] = 442,
  [464] = 258,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 381,
  [469] = 309,
  [470] = 470,
  [471] = 440,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 305,
  [476] = 476,
  [477] = 477,
  [478] = 344,
  [479] = 479,
  [480] = 442,
  [481] = 385,
  [482] = 384,
  [483] = 407,
  [484] = 406,
  [485] = 443,
  [486] = 410,
  [487] = 407,
  [488] = 488,
  [489] = 406,
  [490] = 410,
  [491] = 491,
  [492] = 492,
  [493] = 408,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 496,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 496,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 522,
  [524] = 522,
  [525] = 525,
  [526] = 522,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 522,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 508,
  [539] = 533,
  [540] = 533,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 544,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 546,
  [550] = 550,
  [551] = 547,
  [552] = 552,
  [553] = 546,
  [554] = 550,
  [555] = 552,
  [556] = 544,
  [557] = 550,
  [558] = 552,
  [559] = 559,
  [560] = 547,
  [561] = 550,
  [562] = 562,
  [563] = 544,
  [564] = 552,
  [565] = 544,
  [566] = 550,
  [567] = 567,
  [568] = 552,
  [569] = 569,
  [570] = 569,
  [571] = 569,
  [572] = 569,
  [573] = 569,
  [574] = 574,
  [575] = 240,
  [576] = 240,
  [577] = 240,
  [578] = 247,
  [579] = 254,
  [580] = 246,
  [581] = 581,
  [582] = 258,
  [583] = 262,
  [584] = 240,
  [585] = 256,
  [586] = 240,
  [587] = 587,
  [588] = 261,
  [589] = 262,
  [590] = 265,
  [591] = 265,
  [592] = 268,
  [593] = 303,
  [594] = 296,
  [595] = 295,
  [596] = 467,
  [597] = 446,
  [598] = 472,
  [599] = 286,
  [600] = 284,
  [601] = 282,
  [602] = 280,
  [603] = 305,
  [604] = 276,
  [605] = 605,
  [606] = 274,
  [607] = 302,
  [608] = 309,
  [609] = 273,
  [610] = 256,
  [611] = 611,
  [612] = 441,
  [613] = 479,
  [614] = 272,
  [615] = 277,
  [616] = 275,
  [617] = 270,
  [618] = 350,
  [619] = 349,
  [620] = 269,
  [621] = 348,
  [622] = 341,
  [623] = 381,
  [624] = 340,
  [625] = 278,
  [626] = 384,
  [627] = 477,
  [628] = 272,
  [629] = 297,
  [630] = 385,
  [631] = 476,
  [632] = 339,
  [633] = 338,
  [634] = 271,
  [635] = 474,
  [636] = 334,
  [637] = 384,
  [638] = 279,
  [639] = 281,
  [640] = 385,
  [641] = 332,
  [642] = 331,
  [643] = 330,
  [644] = 329,
  [645] = 328,
  [646] = 325,
  [647] = 323,
  [648] = 320,
  [649] = 318,
  [650] = 317,
  [651] = 473,
  [652] = 470,
  [653] = 316,
  [654] = 315,
  [655] = 290,
  [656] = 291,
  [657] = 657,
  [658] = 305,
  [659] = 283,
  [660] = 344,
  [661] = 285,
  [662] = 287,
  [663] = 292,
  [664] = 611,
  [665] = 288,
  [666] = 314,
  [667] = 611,
  [668] = 309,
  [669] = 381,
  [670] = 313,
  [671] = 307,
  [672] = 293,
  [673] = 673,
  [674] = 289,
  [675] = 344,
  [676] = 298,
  [677] = 300,
  [678] = 301,
  [679] = 304,
  [680] = 306,
  [681] = 681,
  [682] = 681,
  [683] = 681,
  [684] = 681,
  [685] = 681,
  [686] = 681,
  [687] = 681,
  [688] = 681,
  [689] = 689,
  [690] = 472,
  [691] = 467,
  [692] = 692,
  [693] = 477,
  [694] = 441,
  [695] = 695,
  [696] = 446,
  [697] = 657,
  [698] = 479,
  [699] = 470,
  [700] = 473,
  [701] = 474,
  [702] = 702,
  [703] = 476,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 704,
  [708] = 704,
  [709] = 247,
  [710] = 246,
  [711] = 711,
  [712] = 711,
  [713] = 711,
  [714] = 253,
  [715] = 715,
  [716] = 256,
  [717] = 249,
  [718] = 251,
  [719] = 258,
  [720] = 252,
  [721] = 721,
  [722] = 247,
  [723] = 246,
  [724] = 254,
  [725] = 254,
  [726] = 726,
  [727] = 727,
  [728] = 262,
  [729] = 729,
  [730] = 730,
  [731] = 727,
  [732] = 730,
  [733] = 727,
  [734] = 256,
  [735] = 735,
  [736] = 735,
  [737] = 727,
  [738] = 735,
  [739] = 735,
  [740] = 730,
  [741] = 730,
  [742] = 727,
  [743] = 735,
  [744] = 258,
  [745] = 730,
  [746] = 265,
  [747] = 747,
  [748] = 748,
  [749] = 747,
  [750] = 747,
  [751] = 344,
  [752] = 261,
  [753] = 747,
  [754] = 309,
  [755] = 262,
  [756] = 747,
  [757] = 265,
  [758] = 758,
  [759] = 384,
  [760] = 748,
  [761] = 747,
  [762] = 748,
  [763] = 381,
  [764] = 748,
  [765] = 748,
  [766] = 747,
  [767] = 767,
  [768] = 747,
  [769] = 769,
  [770] = 305,
  [771] = 748,
  [772] = 772,
  [773] = 773,
  [774] = 748,
  [775] = 775,
  [776] = 776,
  [777] = 748,
  [778] = 385,
  [779] = 309,
  [780] = 384,
  [781] = 329,
  [782] = 330,
  [783] = 331,
  [784] = 332,
  [785] = 334,
  [786] = 338,
  [787] = 787,
  [788] = 339,
  [789] = 340,
  [790] = 790,
  [791] = 341,
  [792] = 348,
  [793] = 276,
  [794] = 268,
  [795] = 293,
  [796] = 269,
  [797] = 349,
  [798] = 298,
  [799] = 280,
  [800] = 350,
  [801] = 270,
  [802] = 297,
  [803] = 292,
  [804] = 422,
  [805] = 282,
  [806] = 291,
  [807] = 284,
  [808] = 328,
  [809] = 286,
  [810] = 381,
  [811] = 271,
  [812] = 325,
  [813] = 274,
  [814] = 273,
  [815] = 305,
  [816] = 277,
  [817] = 323,
  [818] = 295,
  [819] = 300,
  [820] = 275,
  [821] = 344,
  [822] = 822,
  [823] = 296,
  [824] = 385,
  [825] = 278,
  [826] = 301,
  [827] = 320,
  [828] = 318,
  [829] = 317,
  [830] = 279,
  [831] = 302,
  [832] = 316,
  [833] = 315,
  [834] = 314,
  [835] = 290,
  [836] = 420,
  [837] = 281,
  [838] = 838,
  [839] = 289,
  [840] = 313,
  [841] = 283,
  [842] = 842,
  [843] = 272,
  [844] = 844,
  [845] = 254,
  [846] = 303,
  [847] = 285,
  [848] = 307,
  [849] = 287,
  [850] = 850,
  [851] = 288,
  [852] = 306,
  [853] = 304,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 504,
  [859] = 859,
  [860] = 860,
  [861] = 861,
  [862] = 862,
  [863] = 516,
  [864] = 514,
  [865] = 494,
  [866] = 495,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 873,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 872,
  [879] = 875,
  [880] = 873,
  [881] = 877,
  [882] = 882,
  [883] = 877,
  [884] = 873,
  [885] = 875,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 872,
  [891] = 891,
  [892] = 886,
  [893] = 893,
  [894] = 891,
  [895] = 872,
  [896] = 889,
  [897] = 897,
  [898] = 261,
  [899] = 887,
  [900] = 876,
  [901] = 882,
  [902] = 876,
  [903] = 893,
  [904] = 904,
  [905] = 886,
  [906] = 891,
  [907] = 891,
  [908] = 889,
  [909] = 887,
  [910] = 882,
  [911] = 893,
  [912] = 886,
  [913] = 882,
  [914] = 889,
  [915] = 893,
  [916] = 876,
  [917] = 877,
  [918] = 873,
  [919] = 875,
  [920] = 887,
  [921] = 876,
  [922] = 893,
  [923] = 265,
  [924] = 886,
  [925] = 262,
  [926] = 891,
  [927] = 882,
  [928] = 872,
  [929] = 875,
  [930] = 873,
  [931] = 877,
  [932] = 887,
  [933] = 889,
  [934] = 268,
  [935] = 935,
  [936] = 936,
  [937] = 935,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 948,
  [949] = 949,
  [950] = 950,
  [951] = 951,
  [952] = 949,
  [953] = 948,
  [954] = 943,
  [955] = 940,
  [956] = 936,
  [957] = 935,
  [958] = 943,
  [959] = 947,
  [960] = 948,
  [961] = 949,
  [962] = 935,
  [963] = 936,
  [964] = 951,
  [965] = 940,
  [966] = 950,
  [967] = 947,
  [968] = 946,
  [969] = 945,
  [970] = 970,
  [971] = 944,
  [972] = 946,
  [973] = 945,
  [974] = 944,
  [975] = 938,
  [976] = 951,
  [977] = 939,
  [978] = 941,
  [979] = 942,
  [980] = 980,
  [981] = 981,
  [982] = 982,
  [983] = 941,
  [984] = 939,
  [985] = 950,
  [986] = 986,
  [987] = 950,
  [988] = 951,
  [989] = 949,
  [990] = 948,
  [991] = 943,
  [992] = 935,
  [993] = 936,
  [994] = 940,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 947,
  [1001] = 946,
  [1002] = 945,
  [1003] = 944,
  [1004] = 938,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 981,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 942,
  [1011] = 941,
  [1012] = 939,
  [1013] = 315,
  [1014] = 986,
  [1015] = 950,
  [1016] = 951,
  [1017] = 949,
  [1018] = 948,
  [1019] = 943,
  [1020] = 938,
  [1021] = 942,
  [1022] = 936,
  [1023] = 940,
  [1024] = 1024,
  [1025] = 947,
  [1026] = 946,
  [1027] = 945,
  [1028] = 944,
  [1029] = 938,
  [1030] = 939,
  [1031] = 381,
  [1032] = 309,
  [1033] = 305,
  [1034] = 344,
  [1035] = 385,
  [1036] = 384,
  [1037] = 302,
  [1038] = 301,
  [1039] = 296,
  [1040] = 295,
  [1041] = 286,
  [1042] = 284,
  [1043] = 282,
  [1044] = 280,
  [1045] = 276,
  [1046] = 274,
  [1047] = 275,
  [1048] = 270,
  [1049] = 350,
  [1050] = 349,
  [1051] = 269,
  [1052] = 348,
  [1053] = 341,
  [1054] = 340,
  [1055] = 339,
  [1056] = 338,
  [1057] = 334,
  [1058] = 332,
  [1059] = 331,
  [1060] = 330,
  [1061] = 329,
  [1062] = 328,
  [1063] = 325,
  [1064] = 323,
  [1065] = 320,
  [1066] = 318,
  [1067] = 317,
  [1068] = 316,
  [1069] = 297,
  [1070] = 314,
  [1071] = 313,
  [1072] = 307,
  [1073] = 306,
  [1074] = 304,
  [1075] = 303,
  [1076] = 300,
  [1077] = 298,
  [1078] = 293,
  [1079] = 292,
  [1080] = 291,
  [1081] = 290,
  [1082] = 941,
  [1083] = 289,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 288,
  [1087] = 287,
  [1088] = 285,
  [1089] = 283,
  [1090] = 281,
  [1091] = 279,
  [1092] = 278,
  [1093] = 277,
  [1094] = 273,
  [1095] = 272,
  [1096] = 271,
  [1097] = 942,
  [1098] = 1008,
  [1099] = 705,
  [1100] = 1009,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 981,
  [1109] = 1109,
};

static TSCharacterRange aux_sym__colon_string_token1_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '!'}, {'#', '&'}, {'*', '+'}, {'-', ':'}, {'<', '?'}, {'A', 'Z'},
  {'\\', '\\'}, {'^', '_'}, {'a', 'z'}, {'|', '|'}, {0x7f, 0x10ffff},
};

static TSCharacterRange sym_symbol_option_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '!'}, {'#', '&'}, {'*', '+'}, {'-', '-'}, {'/', '9'}, {'<', '?'},
  {'A', 'Z'}, {'\\', '\\'}, {'^', '_'}, {'a', 'z'}, {'|', '|'}, {0x7f, 0x10ffff},
};

static TSCharacterRange sym_symbol_character_set_1[] = {
  {0, 0x08}, {0x0e, 0x1f}, {'!', '!'}, {'$', '&'}, {'*', '+'}, {'-', '-'}, {'/', '9'}, {'<', '?'},
  {'A', 'Z'}, {'\\', '\\'}, {'^', '_'}, {'a', 'z'}, {'|', '|'}, {0x7f, 0x10ffff},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 86,
        '#', 97,
        '$', 258,
        '&', 75,
        '(', 72,
        ')', 73,
        '.', 113,
        '0', 246,
        ':', 103,
        ';', 68,
        '?', 259,
        '[', 76,
        '\\', 280,
        ']', 77,
        'f', 264,
        'n', 270,
        't', 276,
        '{', 80,
        '}', 81,
        '~', 40,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(62);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`') ADVANCE(290);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 75,
        '(', 72,
        '.', 297,
        '0', 246,
        ':', 78,
        ';', 68,
        '?', 262,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 75,
        '(', 72,
        '.', 114,
        '0', 246,
        ':', 102,
        ';', 68,
        '?', 262,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        ')', 73,
        '.', 297,
        '0', 246,
        ':', 103,
        ';', 68,
        '?', 262,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        ')', 73,
        '.', 297,
        '0', 246,
        ':', 79,
        ';', 68,
        '?', 262,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        ')', 73,
        '.', 297,
        '0', 246,
        ':', 78,
        ';', 68,
        '?', 262,
        '[', 76,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != ']' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        ')', 73,
        '.', 114,
        '0', 246,
        ':', 103,
        ';', 68,
        '?', 262,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        ')', 73,
        '.', 114,
        '0', 246,
        ':', 78,
        ';', 68,
        '?', 262,
        '[', 76,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != ']' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        '.', 297,
        '0', 246,
        ':', 78,
        ';', 68,
        '?', 262,
        '[', 76,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '}', 81,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != ']' &&
          lookahead != '`') ADVANCE(290);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '"', 86,
        '#', 98,
        '$', 127,
        '&', 207,
        '(', 72,
        ')', 73,
        '.', 115,
        '0', 129,
        ':', 104,
        ';', 68,
        '?', 131,
        '[', 76,
        ']', 77,
        'f', 141,
        'n', 158,
        't', 179,
        '{', 80,
        '~', 40,
        '+', 133,
        '-', 133,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(207);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '"', 86,
        '#', 98,
        '$', 127,
        '&', 207,
        '(', 72,
        '.', 115,
        '0', 129,
        ':', 105,
        ';', 68,
        '?', 131,
        '[', 76,
        'f', 140,
        'n', 158,
        't', 179,
        '{', 80,
        '}', 81,
        '~', 40,
        '+', 133,
        '-', 133,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != ']' &&
          lookahead != '`') ADVANCE(207);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '"', 86,
        '#', 98,
        '$', 127,
        '&', 207,
        '.', 116,
        ':', 105,
        ';', 68,
        '?', 131,
        'f', 141,
        'n', 158,
        't', 179,
        '}', 81,
        '~', 40,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '"', 86,
        '#', 98,
        '$', 127,
        '(', 72,
        ')', 73,
        '.', 115,
        '0', 129,
        ':', 105,
        ';', 68,
        '?', 131,
        '[', 76,
        ']', 77,
        'f', 141,
        'n', 158,
        't', 179,
        '{', 80,
        '~', 40,
        '+', 133,
        '-', 133,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (lookahead != 0 &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(207);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '"', 86,
        '#', 98,
        '$', 128,
        '.', 116,
        ':', 105,
        ';', 68,
        '?', 132,
        'f', 144,
        'n', 161,
        't', 181,
        '}', 81,
        '~', 40,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(218);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == '&') ADVANCE(257);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(68);
      if (lookahead == '}') ADVANCE(81);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(14);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        '"', 86,
        '&', 74,
        '(', 72,
        '.', 36,
        '0', 246,
        ':', 78,
        ';', 68,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '"', 86,
        '(', 72,
        ')', 73,
        '.', 55,
        '0', 246,
        ':', 78,
        ';', 68,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '}', 81,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        '"', 86,
        '(', 72,
        ')', 73,
        '.', 55,
        '0', 246,
        ':', 78,
        ';', 68,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        '"', 86,
        '(', 72,
        ')', 73,
        '.', 117,
        '0', 246,
        ':', 102,
        ';', 68,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '}', 81,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          (lookahead < '\'' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '@' &&
          lookahead != '`' &&
          lookahead != '}' &&
          lookahead != '~') ADVANCE(290);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == ':') ADVANCE(102);
      if (lookahead == ';') ADVANCE(68);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '}') ADVANCE(81);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(68);
      if (lookahead == '[') ADVANCE(76);
      if (lookahead == '}') ADVANCE(81);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(68);
      if (lookahead == '}') ADVANCE(81);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == ';') ADVANCE(221);
      if (lookahead == '\\') ADVANCE(50);
      if (lookahead == 'f') ADVANCE(230);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(220);
      if (lookahead != 0) ADVANCE(239);
      END_STATE();
    case 23:
      if (lookahead == '"') ADVANCE(86);
      if (lookahead == ';') ADVANCE(221);
      if (lookahead == '\\') ADVANCE(50);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(220);
      if (lookahead != 0) ADVANCE(239);
      END_STATE();
    case 24:
      ADVANCE_MAP(
        '#', 98,
        '$', 127,
        '.', 116,
        ':', 105,
        ';', 68,
        '?', 131,
        'f', 141,
        'n', 158,
        't', 179,
        '~', 40,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(39);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 25:
      ADVANCE_MAP(
        '#', 98,
        '$', 128,
        '&', 207,
        '.', 116,
        ':', 104,
        ';', 68,
        '?', 132,
        ']', 77,
        'f', 144,
        'n', 161,
        't', 181,
        '~', 40,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(29);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(218);
      END_STATE();
    case 26:
      ADVANCE_MAP(
        '#', 98,
        '$', 128,
        ')', 73,
        '.', 116,
        ':', 105,
        ';', 68,
        '?', 132,
        'f', 144,
        'n', 161,
        't', 181,
        '~', 40,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(218);
      END_STATE();
    case 27:
      ADVANCE_MAP(
        '#', 98,
        '$', 128,
        '.', 116,
        ':', 105,
        ';', 68,
        '?', 132,
        'f', 143,
        'n', 161,
        't', 181,
        '~', 40,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(37);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(218);
      END_STATE();
    case 28:
      if (lookahead == '&') ADVANCE(257);
      if (lookahead == '.') ADVANCE(112);
      if (lookahead == ':') ADVANCE(103);
      if (lookahead == ';') ADVANCE(68);
      if (lookahead == ']') ADVANCE(77);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(29);
      END_STATE();
    case 29:
      if (lookahead == '&') ADVANCE(257);
      if (lookahead == ':') ADVANCE(42);
      if (lookahead == ';') ADVANCE(68);
      if (lookahead == ']') ADVANCE(77);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(29);
      END_STATE();
    case 30:
      if (lookahead == ')') ADVANCE(73);
      if (lookahead == ';') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(30);
      END_STATE();
    case 31:
      if (lookahead == '.') ADVANCE(106);
      END_STATE();
    case 32:
      if (lookahead == '.') ADVANCE(82);
      END_STATE();
    case 33:
      if (lookahead == '.') ADVANCE(295);
      END_STATE();
    case 34:
      if (lookahead == '.') ADVANCE(31);
      END_STATE();
    case 35:
      if (lookahead == '.') ADVANCE(33);
      END_STATE();
    case 36:
      if (lookahead == '.') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(250);
      END_STATE();
    case 37:
      if (lookahead == ';') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(37);
      END_STATE();
    case 38:
      if (lookahead == ';') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(37);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(291);
      END_STATE();
    case 39:
      if (lookahead == ';') ADVANCE(68);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(39);
      if ((!eof && set_contains(sym_symbol_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 40:
      if (lookahead == '=') ADVANCE(101);
      END_STATE();
    case 41:
      if (lookahead == '=') ADVANCE(294);
      END_STATE();
    case 42:
      if (lookahead == 'i') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 43:
      if (lookahead == 'i') ADVANCE(44);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 45:
      if (lookahead == 'n') ADVANCE(48);
      END_STATE();
    case 46:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 47:
      if (lookahead == 'o') ADVANCE(92);
      END_STATE();
    case 48:
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 49:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 50:
      if (lookahead == 'u') ADVANCE(51);
      if (lookahead == 'x') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(244);
      if (lookahead != 0) ADVANCE(240);
      END_STATE();
    case 51:
      if (lookahead == '{') ADVANCE(59);
      END_STATE();
    case 52:
      if (lookahead == '}') ADVANCE(240);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 53:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(254);
      END_STATE();
    case 54:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(256);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(250);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(254);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(240);
      END_STATE();
    case 58:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(252);
      END_STATE();
    case 59:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 60:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(256);
      END_STATE();
    case 61:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(57);
      END_STATE();
    case 62:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 75,
        '(', 72,
        ')', 73,
        '.', 297,
        '0', 246,
        ':', 79,
        ';', 68,
        '?', 262,
        '[', 76,
        '\\', 280,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '}', 81,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(62);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`') ADVANCE(290);
      END_STATE();
    case 63:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        ')', 73,
        '.', 297,
        '0', 246,
        ':', 78,
        ';', 68,
        '?', 262,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '}', 81,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`') ADVANCE(290);
      END_STATE();
    case 64:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        ')', 73,
        '.', 297,
        '0', 246,
        ':', 102,
        ';', 68,
        '?', 262,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '}', 81,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`') ADVANCE(290);
      END_STATE();
    case 65:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 86,
        '#', 292,
        '$', 263,
        '&', 257,
        '(', 72,
        ')', 73,
        '.', 114,
        '0', 246,
        ':', 102,
        ';', 68,
        '?', 262,
        '[', 76,
        ']', 77,
        'f', 265,
        'n', 271,
        't', 277,
        '{', 80,
        '}', 81,
        '~', 41,
        '+', 260,
        '-', 260,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`') ADVANCE(290);
      END_STATE();
    case 66:
      if (eof) ADVANCE(67);
      ADVANCE_MAP(
        '"', 86,
        '#', 98,
        '$', 127,
        '&', 207,
        '(', 72,
        ')', 73,
        '.', 115,
        '0', 129,
        ':', 105,
        ';', 68,
        '?', 131,
        '[', 76,
        ']', 77,
        'f', 141,
        'n', 158,
        't', 179,
        '{', 80,
        '}', 81,
        '~', 40,
        '+', 133,
        '-', 133,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(63);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (lookahead != 0 &&
          (lookahead < '&' || ')' < lookahead) &&
          (lookahead < '+' || '.' < lookahead) &&
          lookahead != '?' &&
          lookahead != '@' &&
          lookahead != '`') ADVANCE(207);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == ';') ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_comment_token1);
      if (lookahead == ';') ADVANCE(69);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(71);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_comment_token2);
      if (lookahead == ';') ADVANCE(69);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(70);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead)) ADVANCE(71);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym_comment_token2);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(71);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_AMP);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_AMP);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(257);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == 'i') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_fnl_SLASHdocstring);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_fnl_SLASHdocstring);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_fnl_SLASHdocstring);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_fnl_SLASHarglist);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_fnl_SLASHarglist);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_fnl_SLASHarglist);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_COLONuntil);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_COLONuntil);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_COLONinto);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_COLONinto);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_nil);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_true);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_false);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_POUND);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_COLON2);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_COLON2);
      if (lookahead == 'i') ADVANCE(45);
      if (lookahead == 'u') ADVANCE(46);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_COLON2);
      if (lookahead == 'i') ADVANCE(172);
      if (lookahead == 'u') ADVANCE(173);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_COLON2);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOT_DOT_DOT);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOT_DOT_DOT);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT2);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT2);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(108);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(109);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(250);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(250);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(111);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(250);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_nil);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_nil);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_nil);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_true2);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_true2);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_true2);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_false2);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_false2);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_false2);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(137);
      if (lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(137);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(208);
      if (lookahead == ':') ADVANCE(218);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(199);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(130);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(208);
      if (lookahead == ':') ADVANCE(218);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(130);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(100);
      if (lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(100);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(212);
      if (lookahead == '0') ADVANCE(129);
      if (lookahead == ':') ADVANCE(218);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(215);
      if (lookahead == ':') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(107);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(210);
      if (lookahead == ':') ADVANCE(218);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.') ADVANCE(135);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '/') ADVANCE(142);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '/') ADVANCE(145);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'a') ADVANCE(163);
      if (lookahead == 'n') ADVANCE(166);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'a') ADVANCE(163);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'a') ADVANCE(180);
      if (lookahead == 'd') ADVANCE(177);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'a') ADVANCE(167);
      if (lookahead == 'n') ADVANCE(169);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'a') ADVANCE(167);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'a') ADVANCE(182);
      if (lookahead == 'd') ADVANCE(178);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'c') ADVANCE(185);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'c') ADVANCE(189);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'e') ADVANCE(121);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'e') ADVANCE(124);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'e') ADVANCE(123);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'e') ADVANCE(126);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'g') ADVANCE(83);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'g') ADVANCE(84);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'g') ADVANCE(170);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'g') ADVANCE(171);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'i') ADVANCE(165);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'i') ADVANCE(174);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'i') ADVANCE(164);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'i') ADVANCE(175);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'i') ADVANCE(187);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'i') ADVANCE(168);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'i') ADVANCE(190);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(186);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(118);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(91);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(138);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(188);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(120);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(139);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(160);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'l') ADVANCE(162);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'n') ADVANCE(191);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'n') ADVANCE(192);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'n') ADVANCE(152);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'n') ADVANCE(153);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'o') ADVANCE(93);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'o') ADVANCE(146);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'o') ADVANCE(147);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'r') ADVANCE(197);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'r') ADVANCE(154);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'r') ADVANCE(198);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'r') ADVANCE(155);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'r') ADVANCE(157);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'r') ADVANCE(159);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 's') ADVANCE(195);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 's') ADVANCE(149);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 's') ADVANCE(193);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 's') ADVANCE(151);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 's') ADVANCE(196);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 's') ADVANCE(194);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 't') ADVANCE(176);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 't') ADVANCE(156);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 't') ADVANCE(87);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 't') ADVANCE(88);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 't') ADVANCE(183);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 't') ADVANCE(184);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'u') ADVANCE(148);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'u') ADVANCE(150);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(203);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(205);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(216);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(217);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(204);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == '.' ||
          lookahead == ':') ADVANCE(218);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(201);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(209);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(211);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(211);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(209);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(214);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(211);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(217);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(217);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym__colon_string_token1);
      if ((!eof && set_contains(aux_sym__colon_string_token1_character_set_1, 13, lookahead))) ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == '/') ADVANCE(222);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == ';') ADVANCE(221);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(220);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == ';') ADVANCE(221);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'a') ADVANCE(233);
      if (lookahead == 'd') ADVANCE(232);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'c') ADVANCE(235);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'g') ADVANCE(85);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'g') ADVANCE(229);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'i') ADVANCE(231);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'i') ADVANCE(236);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'l') ADVANCE(219);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'l') ADVANCE(227);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'n') ADVANCE(228);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'n') ADVANCE(224);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'o') ADVANCE(223);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'r') ADVANCE(225);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 'r') ADVANCE(226);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 's') ADVANCE(238);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 's') ADVANCE(237);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 't') ADVANCE(89);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead == 't') ADVANCE(234);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(aux_sym__double_quote_string_content_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(239);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(240);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(245);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(242);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(241);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_escape_sequence);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(284);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(247);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(249);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(247);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(251);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(248);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(250);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(250);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(252);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(252);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(253);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(254);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(255);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(256);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_symbol_option);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(257);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '.') ADVANCE(34);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '.') ADVANCE(99);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '.') ADVANCE(55);
      if (lookahead == '0') ADVANCE(246);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(247);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '.') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(248);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '.') ADVANCE(293);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '.') ADVANCE(35);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'a') ADVANCE(272);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'a') ADVANCE(275);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(122);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(125);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(95);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'e') ADVANCE(96);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'i') ADVANCE(273);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'i') ADVANCE(274);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'l') ADVANCE(278);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'l') ADVANCE(119);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'l') ADVANCE(94);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'l') ADVANCE(279);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'r') ADVANCE(281);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'r') ADVANCE(282);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 's') ADVANCE(267);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 's') ADVANCE(269);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'u') ADVANCE(283);
      if (lookahead == 'x') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(243);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == '"' ||
          ('\'' <= lookahead && lookahead <= ')') ||
          lookahead == ',' ||
          lookahead == '.' ||
          lookahead == ':' ||
          lookahead == ';' ||
          lookahead == '@' ||
          lookahead == '[' ||
          lookahead == ']' ||
          lookahead == '`' ||
          lookahead == '{' ||
          lookahead == '}' ||
          lookahead == '~') ADVANCE(240);
      if (lookahead != 0) ADVANCE(245);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'u') ADVANCE(266);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == 'u') ADVANCE(268);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '{') ADVANCE(59);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(286);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(253);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_symbol);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(255);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_symbol);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(253);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_symbol);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(245);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_symbol);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(255);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_symbol);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(287);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_symbol);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(290);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(aux_sym__multi_symbol_fragment_token1);
      if ((!eof && set_contains(sym_symbol_option_character_set_1, 14, lookahead))) ADVANCE(291);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_POUND2);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_QMARK_DOT2);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ2);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOT_DOT_DOT2);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(anon_sym_DOT_DOT2);
      if (lookahead == '.') ADVANCE(82);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(anon_sym_DOT2);
      if (lookahead == '.') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(250);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'c', 2,
        'e', 3,
        'f', 4,
        'g', 5,
        'h', 6,
        'i', 7,
        'l', 8,
        'm', 9,
        'o', 10,
        'q', 11,
        's', 12,
        'u', 13,
        'v', 14,
        'w', 15,
        0x3bb, 16,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'c') ADVANCE(17);
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(20);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(21);
      if (lookahead == 'c') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      if (lookahead == 'o') ADVANCE(24);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(25);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(26);
      END_STATE();
    case 7:
      if (lookahead == 'c') ADVANCE(27);
      if (lookahead == 'f') ADVANCE(28);
      if (lookahead == 'm') ADVANCE(29);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'e') ADVANCE(31);
      if (lookahead == 'o') ADVANCE(32);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 10:
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 11:
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(37);
      END_STATE();
    case 14:
      if (lookahead == 'a') ADVANCE(38);
      END_STATE();
    case 15:
      if (lookahead == 'h') ADVANCE(39);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_u03bb);
      END_STATE();
    case 17:
      if (lookahead == 'c') ADVANCE(40);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(41);
      if (lookahead == 't') ADVANCE(42);
      END_STATE();
    case 19:
      if (lookahead == 'l') ADVANCE(43);
      END_STATE();
    case 20:
      if (lookahead == 'c') ADVANCE(44);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(45);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(46);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 24:
      if (lookahead == 'r') ADVANCE(47);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(48);
      END_STATE();
    case 26:
      if (lookahead == 's') ADVANCE(49);
      END_STATE();
    case 27:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(51);
      END_STATE();
    case 30:
      if (lookahead == 'm') ADVANCE(52);
      END_STATE();
    case 31:
      if (lookahead == 't') ADVANCE(53);
      END_STATE();
    case 32:
      if (lookahead == 'c') ADVANCE(54);
      END_STATE();
    case 33:
      if (lookahead == 'c') ADVANCE(55);
      if (lookahead == 't') ADVANCE(56);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 35:
      if (lookahead == 'o') ADVANCE(57);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 37:
      if (lookahead == 'q') ADVANCE(59);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(61);
      END_STATE();
    case 40:
      if (lookahead == 'u') ADVANCE(62);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 42:
      if (lookahead == 'c') ADVANCE(64);
      END_STATE();
    case 43:
      if (lookahead == 'l') ADVANCE(65);
      END_STATE();
    case 44:
      if (lookahead == 'h') ADVANCE(66);
      END_STATE();
    case 45:
      if (lookahead == 'c') ADVANCE(67);
      END_STATE();
    case 46:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 48:
      if (lookahead == 'b') ADVANCE(69);
      END_STATE();
    case 49:
      if (lookahead == 'h') ADVANCE(70);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 51:
      if (lookahead == 'o') ADVANCE(72);
      END_STATE();
    case 52:
      if (lookahead == 'b') ADVANCE(73);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 54:
      if (lookahead == 'a') ADVANCE(74);
      END_STATE();
    case 55:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 56:
      if (lookahead == 'c') ADVANCE(76);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_set);
      END_STATE();
    case 59:
      if (lookahead == 'u') ADVANCE(78);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 61:
      if (lookahead == 'r') ADVANCE(79);
      END_STATE();
    case 62:
      if (lookahead == 'm') ADVANCE(80);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_case);
      if (lookahead == '-') ADVANCE(81);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(82);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_each);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 70:
      if (lookahead == 'f') ADVANCE(87);
      END_STATE();
    case 71:
      if (lookahead == 'l') ADVANCE(88);
      END_STATE();
    case 72:
      if (lookahead == 'r') ADVANCE(89);
      END_STATE();
    case 73:
      if (lookahead == 'd') ADVANCE(90);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(91);
      END_STATE();
    case 75:
      if (lookahead == 'o') ADVANCE(92);
      END_STATE();
    case 76:
      if (lookahead == 'h') ADVANCE(93);
      END_STATE();
    case 77:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 78:
      if (lookahead == 'o') ADVANCE(95);
      END_STATE();
    case 79:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 80:
      if (lookahead == 'u') ADVANCE(97);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 83:
      if (lookahead == 'c') ADVANCE(99);
      END_STATE();
    case 84:
      if (lookahead == 'm') ADVANCE(100);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(101);
      END_STATE();
    case 86:
      if (lookahead == 'l') ADVANCE(102);
      END_STATE();
    case 87:
      if (lookahead == 'n') ADVANCE(103);
      END_STATE();
    case 88:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 89:
      if (lookahead == 't') ADVANCE(105);
      END_STATE();
    case 90:
      if (lookahead == 'a') ADVANCE(106);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_local);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_macro);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_match);
      if (lookahead == '-') ADVANCE(107);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_quote);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(108);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_where);
      END_STATE();
    case 97:
      if (lookahead == 'l') ADVANCE(109);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(110);
      END_STATE();
    case 99:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 100:
      if (lookahead == 'u') ADVANCE(112);
      END_STATE();
    case 101:
      if (lookahead == 'c') ADVANCE(113);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_global);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_hashfn);
      END_STATE();
    case 104:
      if (lookahead == 'c') ADVANCE(114);
      END_STATE();
    case 105:
      if (lookahead == '-') ADVANCE(115);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_lambda);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(117);
      END_STATE();
    case 109:
      if (lookahead == 'a') ADVANCE(118);
      END_STATE();
    case 110:
      if (lookahead == 'y') ADVANCE(119);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_collect);
      END_STATE();
    case 112:
      if (lookahead == 'l') ADVANCE(120);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(122);
      END_STATE();
    case 115:
      if (lookahead == 'm') ADVANCE(123);
      END_STATE();
    case 116:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_unquote);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_case_DASHtry);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(126);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_fcollect);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_icollect);
      END_STATE();
    case 123:
      if (lookahead == 'a') ADVANCE(127);
      END_STATE();
    case 124:
      if (lookahead == 'y') ADVANCE(128);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(129);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(130);
      END_STATE();
    case 127:
      if (lookahead == 'c') ADVANCE(131);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_match_DASHtry);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_accumulate);
      END_STATE();
    case 130:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 131:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_faccumulate);
      END_STATE();
    case 133:
      if (lookahead == 'o') ADVANCE(134);
      END_STATE();
    case 134:
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_import_DASHmacros);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 63, .external_lex_state = 2},
  [2] = {.lex_state = 63, .external_lex_state = 3},
  [3] = {.lex_state = 63, .external_lex_state = 3},
  [4] = {.lex_state = 63, .external_lex_state = 3},
  [5] = {.lex_state = 63, .external_lex_state = 3},
  [6] = {.lex_state = 63, .external_lex_state = 3},
  [7] = {.lex_state = 63, .external_lex_state = 3},
  [8] = {.lex_state = 63, .external_lex_state = 3},
  [9] = {.lex_state = 63, .external_lex_state = 3},
  [10] = {.lex_state = 63, .external_lex_state = 3},
  [11] = {.lex_state = 63, .external_lex_state = 3},
  [12] = {.lex_state = 63, .external_lex_state = 3},
  [13] = {.lex_state = 63, .external_lex_state = 3},
  [14] = {.lex_state = 63, .external_lex_state = 3},
  [15] = {.lex_state = 63, .external_lex_state = 3},
  [16] = {.lex_state = 4, .external_lex_state = 3},
  [17] = {.lex_state = 4, .external_lex_state = 3},
  [18] = {.lex_state = 63, .external_lex_state = 3},
  [19] = {.lex_state = 63, .external_lex_state = 3},
  [20] = {.lex_state = 63, .external_lex_state = 3},
  [21] = {.lex_state = 63, .external_lex_state = 3},
  [22] = {.lex_state = 63, .external_lex_state = 3},
  [23] = {.lex_state = 63, .external_lex_state = 3},
  [24] = {.lex_state = 63, .external_lex_state = 3},
  [25] = {.lex_state = 63, .external_lex_state = 3},
  [26] = {.lex_state = 63, .external_lex_state = 3},
  [27] = {.lex_state = 63, .external_lex_state = 3},
  [28] = {.lex_state = 63, .external_lex_state = 3},
  [29] = {.lex_state = 63, .external_lex_state = 3},
  [30] = {.lex_state = 63, .external_lex_state = 3},
  [31] = {.lex_state = 4, .external_lex_state = 3},
  [32] = {.lex_state = 63, .external_lex_state = 3},
  [33] = {.lex_state = 63, .external_lex_state = 3},
  [34] = {.lex_state = 63, .external_lex_state = 3},
  [35] = {.lex_state = 63, .external_lex_state = 3},
  [36] = {.lex_state = 63, .external_lex_state = 3},
  [37] = {.lex_state = 63, .external_lex_state = 3},
  [38] = {.lex_state = 63, .external_lex_state = 3},
  [39] = {.lex_state = 63, .external_lex_state = 3},
  [40] = {.lex_state = 63, .external_lex_state = 3},
  [41] = {.lex_state = 4, .external_lex_state = 3},
  [42] = {.lex_state = 63, .external_lex_state = 3},
  [43] = {.lex_state = 63, .external_lex_state = 3},
  [44] = {.lex_state = 63, .external_lex_state = 3},
  [45] = {.lex_state = 63, .external_lex_state = 3},
  [46] = {.lex_state = 63, .external_lex_state = 3},
  [47] = {.lex_state = 63, .external_lex_state = 3},
  [48] = {.lex_state = 63, .external_lex_state = 3},
  [49] = {.lex_state = 63, .external_lex_state = 3},
  [50] = {.lex_state = 63, .external_lex_state = 3},
  [51] = {.lex_state = 63, .external_lex_state = 3},
  [52] = {.lex_state = 63, .external_lex_state = 3},
  [53] = {.lex_state = 63, .external_lex_state = 3},
  [54] = {.lex_state = 63, .external_lex_state = 3},
  [55] = {.lex_state = 63, .external_lex_state = 3},
  [56] = {.lex_state = 63, .external_lex_state = 3},
  [57] = {.lex_state = 63, .external_lex_state = 3},
  [58] = {.lex_state = 63, .external_lex_state = 3},
  [59] = {.lex_state = 63, .external_lex_state = 3},
  [60] = {.lex_state = 63, .external_lex_state = 3},
  [61] = {.lex_state = 63, .external_lex_state = 3},
  [62] = {.lex_state = 63, .external_lex_state = 3},
  [63] = {.lex_state = 63, .external_lex_state = 3},
  [64] = {.lex_state = 63, .external_lex_state = 3},
  [65] = {.lex_state = 63, .external_lex_state = 3},
  [66] = {.lex_state = 63, .external_lex_state = 3},
  [67] = {.lex_state = 63, .external_lex_state = 3},
  [68] = {.lex_state = 63, .external_lex_state = 3},
  [69] = {.lex_state = 63, .external_lex_state = 3},
  [70] = {.lex_state = 63, .external_lex_state = 3},
  [71] = {.lex_state = 63, .external_lex_state = 3},
  [72] = {.lex_state = 63, .external_lex_state = 3},
  [73] = {.lex_state = 63, .external_lex_state = 3},
  [74] = {.lex_state = 63, .external_lex_state = 3},
  [75] = {.lex_state = 63, .external_lex_state = 3},
  [76] = {.lex_state = 63, .external_lex_state = 3},
  [77] = {.lex_state = 63, .external_lex_state = 3},
  [78] = {.lex_state = 63, .external_lex_state = 3},
  [79] = {.lex_state = 63, .external_lex_state = 3},
  [80] = {.lex_state = 63, .external_lex_state = 3},
  [81] = {.lex_state = 63, .external_lex_state = 3},
  [82] = {.lex_state = 63, .external_lex_state = 3},
  [83] = {.lex_state = 63, .external_lex_state = 3},
  [84] = {.lex_state = 63, .external_lex_state = 3},
  [85] = {.lex_state = 63, .external_lex_state = 3},
  [86] = {.lex_state = 63, .external_lex_state = 3},
  [87] = {.lex_state = 63, .external_lex_state = 3},
  [88] = {.lex_state = 63, .external_lex_state = 3},
  [89] = {.lex_state = 63, .external_lex_state = 3},
  [90] = {.lex_state = 63, .external_lex_state = 3},
  [91] = {.lex_state = 63, .external_lex_state = 3},
  [92] = {.lex_state = 63, .external_lex_state = 3},
  [93] = {.lex_state = 63, .external_lex_state = 3},
  [94] = {.lex_state = 63, .external_lex_state = 3},
  [95] = {.lex_state = 63, .external_lex_state = 3},
  [96] = {.lex_state = 63, .external_lex_state = 3},
  [97] = {.lex_state = 63, .external_lex_state = 3},
  [98] = {.lex_state = 63, .external_lex_state = 3},
  [99] = {.lex_state = 63, .external_lex_state = 3},
  [100] = {.lex_state = 63, .external_lex_state = 3},
  [101] = {.lex_state = 63, .external_lex_state = 3},
  [102] = {.lex_state = 63, .external_lex_state = 3},
  [103] = {.lex_state = 63, .external_lex_state = 3},
  [104] = {.lex_state = 63, .external_lex_state = 3},
  [105] = {.lex_state = 63, .external_lex_state = 3},
  [106] = {.lex_state = 63, .external_lex_state = 3},
  [107] = {.lex_state = 63, .external_lex_state = 3},
  [108] = {.lex_state = 63, .external_lex_state = 3},
  [109] = {.lex_state = 63, .external_lex_state = 3},
  [110] = {.lex_state = 63, .external_lex_state = 3},
  [111] = {.lex_state = 63, .external_lex_state = 3},
  [112] = {.lex_state = 63, .external_lex_state = 3},
  [113] = {.lex_state = 63, .external_lex_state = 3},
  [114] = {.lex_state = 63, .external_lex_state = 3},
  [115] = {.lex_state = 63, .external_lex_state = 3},
  [116] = {.lex_state = 63, .external_lex_state = 3},
  [117] = {.lex_state = 63, .external_lex_state = 3},
  [118] = {.lex_state = 63, .external_lex_state = 3},
  [119] = {.lex_state = 63, .external_lex_state = 3},
  [120] = {.lex_state = 63, .external_lex_state = 3},
  [121] = {.lex_state = 63, .external_lex_state = 3},
  [122] = {.lex_state = 63, .external_lex_state = 3},
  [123] = {.lex_state = 63, .external_lex_state = 3},
  [124] = {.lex_state = 63, .external_lex_state = 3},
  [125] = {.lex_state = 63, .external_lex_state = 3},
  [126] = {.lex_state = 63, .external_lex_state = 3},
  [127] = {.lex_state = 63, .external_lex_state = 3},
  [128] = {.lex_state = 63, .external_lex_state = 3},
  [129] = {.lex_state = 63, .external_lex_state = 3},
  [130] = {.lex_state = 63, .external_lex_state = 3},
  [131] = {.lex_state = 63, .external_lex_state = 3},
  [132] = {.lex_state = 63, .external_lex_state = 3},
  [133] = {.lex_state = 63, .external_lex_state = 3},
  [134] = {.lex_state = 63, .external_lex_state = 3},
  [135] = {.lex_state = 63, .external_lex_state = 3},
  [136] = {.lex_state = 63, .external_lex_state = 3},
  [137] = {.lex_state = 63, .external_lex_state = 3},
  [138] = {.lex_state = 63, .external_lex_state = 3},
  [139] = {.lex_state = 63, .external_lex_state = 3},
  [140] = {.lex_state = 63, .external_lex_state = 3},
  [141] = {.lex_state = 63, .external_lex_state = 3},
  [142] = {.lex_state = 63, .external_lex_state = 3},
  [143] = {.lex_state = 63, .external_lex_state = 3},
  [144] = {.lex_state = 63, .external_lex_state = 3},
  [145] = {.lex_state = 63, .external_lex_state = 3},
  [146] = {.lex_state = 63, .external_lex_state = 3},
  [147] = {.lex_state = 63, .external_lex_state = 3},
  [148] = {.lex_state = 63, .external_lex_state = 3},
  [149] = {.lex_state = 63, .external_lex_state = 3},
  [150] = {.lex_state = 63, .external_lex_state = 3},
  [151] = {.lex_state = 63, .external_lex_state = 3},
  [152] = {.lex_state = 63, .external_lex_state = 3},
  [153] = {.lex_state = 63, .external_lex_state = 3},
  [154] = {.lex_state = 63, .external_lex_state = 3},
  [155] = {.lex_state = 63, .external_lex_state = 3},
  [156] = {.lex_state = 63, .external_lex_state = 3},
  [157] = {.lex_state = 63, .external_lex_state = 3},
  [158] = {.lex_state = 63, .external_lex_state = 3},
  [159] = {.lex_state = 63, .external_lex_state = 3},
  [160] = {.lex_state = 63, .external_lex_state = 3},
  [161] = {.lex_state = 63, .external_lex_state = 3},
  [162] = {.lex_state = 63, .external_lex_state = 3},
  [163] = {.lex_state = 63, .external_lex_state = 3},
  [164] = {.lex_state = 63, .external_lex_state = 3},
  [165] = {.lex_state = 63, .external_lex_state = 3},
  [166] = {.lex_state = 63, .external_lex_state = 3},
  [167] = {.lex_state = 63, .external_lex_state = 3},
  [168] = {.lex_state = 63, .external_lex_state = 3},
  [169] = {.lex_state = 63, .external_lex_state = 3},
  [170] = {.lex_state = 63, .external_lex_state = 3},
  [171] = {.lex_state = 63, .external_lex_state = 3},
  [172] = {.lex_state = 63, .external_lex_state = 3},
  [173] = {.lex_state = 63, .external_lex_state = 3},
  [174] = {.lex_state = 63, .external_lex_state = 3},
  [175] = {.lex_state = 63, .external_lex_state = 3},
  [176] = {.lex_state = 63, .external_lex_state = 3},
  [177] = {.lex_state = 63, .external_lex_state = 3},
  [178] = {.lex_state = 63, .external_lex_state = 3},
  [179] = {.lex_state = 63, .external_lex_state = 3},
  [180] = {.lex_state = 63, .external_lex_state = 3},
  [181] = {.lex_state = 63, .external_lex_state = 3},
  [182] = {.lex_state = 63, .external_lex_state = 3},
  [183] = {.lex_state = 63, .external_lex_state = 3},
  [184] = {.lex_state = 63, .external_lex_state = 3},
  [185] = {.lex_state = 63, .external_lex_state = 3},
  [186] = {.lex_state = 63, .external_lex_state = 3},
  [187] = {.lex_state = 63, .external_lex_state = 3},
  [188] = {.lex_state = 63, .external_lex_state = 3},
  [189] = {.lex_state = 63, .external_lex_state = 3},
  [190] = {.lex_state = 63, .external_lex_state = 3},
  [191] = {.lex_state = 63, .external_lex_state = 3},
  [192] = {.lex_state = 63, .external_lex_state = 3},
  [193] = {.lex_state = 63, .external_lex_state = 3},
  [194] = {.lex_state = 63, .external_lex_state = 3},
  [195] = {.lex_state = 63, .external_lex_state = 3},
  [196] = {.lex_state = 63, .external_lex_state = 3},
  [197] = {.lex_state = 63, .external_lex_state = 3},
  [198] = {.lex_state = 63, .external_lex_state = 3},
  [199] = {.lex_state = 63, .external_lex_state = 3},
  [200] = {.lex_state = 63, .external_lex_state = 3},
  [201] = {.lex_state = 63, .external_lex_state = 3},
  [202] = {.lex_state = 63, .external_lex_state = 3},
  [203] = {.lex_state = 63, .external_lex_state = 3},
  [204] = {.lex_state = 63, .external_lex_state = 3},
  [205] = {.lex_state = 63, .external_lex_state = 3},
  [206] = {.lex_state = 63, .external_lex_state = 3},
  [207] = {.lex_state = 63, .external_lex_state = 3},
  [208] = {.lex_state = 63, .external_lex_state = 3},
  [209] = {.lex_state = 63, .external_lex_state = 3},
  [210] = {.lex_state = 63, .external_lex_state = 3},
  [211] = {.lex_state = 63, .external_lex_state = 3},
  [212] = {.lex_state = 63, .external_lex_state = 3},
  [213] = {.lex_state = 63, .external_lex_state = 3},
  [214] = {.lex_state = 63, .external_lex_state = 3},
  [215] = {.lex_state = 63, .external_lex_state = 3},
  [216] = {.lex_state = 63, .external_lex_state = 3},
  [217] = {.lex_state = 63, .external_lex_state = 3},
  [218] = {.lex_state = 63, .external_lex_state = 3},
  [219] = {.lex_state = 63, .external_lex_state = 3},
  [220] = {.lex_state = 63, .external_lex_state = 3},
  [221] = {.lex_state = 63, .external_lex_state = 3},
  [222] = {.lex_state = 63, .external_lex_state = 3},
  [223] = {.lex_state = 63, .external_lex_state = 3},
  [224] = {.lex_state = 63, .external_lex_state = 3},
  [225] = {.lex_state = 63, .external_lex_state = 3},
  [226] = {.lex_state = 63, .external_lex_state = 3},
  [227] = {.lex_state = 63, .external_lex_state = 3},
  [228] = {.lex_state = 63, .external_lex_state = 3},
  [229] = {.lex_state = 63, .external_lex_state = 3},
  [230] = {.lex_state = 63, .external_lex_state = 3},
  [231] = {.lex_state = 63, .external_lex_state = 3},
  [232] = {.lex_state = 63, .external_lex_state = 3},
  [233] = {.lex_state = 63, .external_lex_state = 3},
  [234] = {.lex_state = 63, .external_lex_state = 3},
  [235] = {.lex_state = 63, .external_lex_state = 3},
  [236] = {.lex_state = 63, .external_lex_state = 3},
  [237] = {.lex_state = 63, .external_lex_state = 3},
  [238] = {.lex_state = 63, .external_lex_state = 3},
  [239] = {.lex_state = 63, .external_lex_state = 3},
  [240] = {.lex_state = 66, .external_lex_state = 4},
  [241] = {.lex_state = 9, .external_lex_state = 4},
  [242] = {.lex_state = 10, .external_lex_state = 4},
  [243] = {.lex_state = 66, .external_lex_state = 4},
  [244] = {.lex_state = 66, .external_lex_state = 4},
  [245] = {.lex_state = 63, .external_lex_state = 3},
  [246] = {.lex_state = 65, .external_lex_state = 3},
  [247] = {.lex_state = 6, .external_lex_state = 3},
  [248] = {.lex_state = 65, .external_lex_state = 3},
  [249] = {.lex_state = 4, .external_lex_state = 3},
  [250] = {.lex_state = 6, .external_lex_state = 3},
  [251] = {.lex_state = 4, .external_lex_state = 3},
  [252] = {.lex_state = 4, .external_lex_state = 3},
  [253] = {.lex_state = 4, .external_lex_state = 3},
  [254] = {.lex_state = 6, .external_lex_state = 3},
  [255] = {.lex_state = 65, .external_lex_state = 3},
  [256] = {.lex_state = 6, .external_lex_state = 3},
  [257] = {.lex_state = 65, .external_lex_state = 3},
  [258] = {.lex_state = 6, .external_lex_state = 3},
  [259] = {.lex_state = 65, .external_lex_state = 3},
  [260] = {.lex_state = 6, .external_lex_state = 3},
  [261] = {.lex_state = 3, .external_lex_state = 3},
  [262] = {.lex_state = 63, .external_lex_state = 5},
  [263] = {.lex_state = 4, .external_lex_state = 5},
  [264] = {.lex_state = 64, .external_lex_state = 3},
  [265] = {.lex_state = 63, .external_lex_state = 5},
  [266] = {.lex_state = 2, .external_lex_state = 3},
  [267] = {.lex_state = 4, .external_lex_state = 5},
  [268] = {.lex_state = 63, .external_lex_state = 3},
  [269] = {.lex_state = 4, .external_lex_state = 3},
  [270] = {.lex_state = 63, .external_lex_state = 3},
  [271] = {.lex_state = 4, .external_lex_state = 3},
  [272] = {.lex_state = 4, .external_lex_state = 3},
  [273] = {.lex_state = 4, .external_lex_state = 3},
  [274] = {.lex_state = 63, .external_lex_state = 3},
  [275] = {.lex_state = 63, .external_lex_state = 3},
  [276] = {.lex_state = 63, .external_lex_state = 3},
  [277] = {.lex_state = 4, .external_lex_state = 3},
  [278] = {.lex_state = 4, .external_lex_state = 3},
  [279] = {.lex_state = 4, .external_lex_state = 3},
  [280] = {.lex_state = 63, .external_lex_state = 3},
  [281] = {.lex_state = 4, .external_lex_state = 3},
  [282] = {.lex_state = 63, .external_lex_state = 3},
  [283] = {.lex_state = 4, .external_lex_state = 3},
  [284] = {.lex_state = 63, .external_lex_state = 3},
  [285] = {.lex_state = 4, .external_lex_state = 3},
  [286] = {.lex_state = 63, .external_lex_state = 3},
  [287] = {.lex_state = 4, .external_lex_state = 3},
  [288] = {.lex_state = 4, .external_lex_state = 3},
  [289] = {.lex_state = 4, .external_lex_state = 3},
  [290] = {.lex_state = 4, .external_lex_state = 3},
  [291] = {.lex_state = 4, .external_lex_state = 3},
  [292] = {.lex_state = 4, .external_lex_state = 3},
  [293] = {.lex_state = 4, .external_lex_state = 3},
  [294] = {.lex_state = 63, .external_lex_state = 3},
  [295] = {.lex_state = 63, .external_lex_state = 3},
  [296] = {.lex_state = 63, .external_lex_state = 3},
  [297] = {.lex_state = 4, .external_lex_state = 3},
  [298] = {.lex_state = 4, .external_lex_state = 3},
  [299] = {.lex_state = 63, .external_lex_state = 3},
  [300] = {.lex_state = 4, .external_lex_state = 3},
  [301] = {.lex_state = 63, .external_lex_state = 3},
  [302] = {.lex_state = 63, .external_lex_state = 3},
  [303] = {.lex_state = 4, .external_lex_state = 3},
  [304] = {.lex_state = 4, .external_lex_state = 3},
  [305] = {.lex_state = 63, .external_lex_state = 3},
  [306] = {.lex_state = 4, .external_lex_state = 3},
  [307] = {.lex_state = 4, .external_lex_state = 3},
  [308] = {.lex_state = 63, .external_lex_state = 3},
  [309] = {.lex_state = 63, .external_lex_state = 3},
  [310] = {.lex_state = 63, .external_lex_state = 3},
  [311] = {.lex_state = 63, .external_lex_state = 3},
  [312] = {.lex_state = 63, .external_lex_state = 3},
  [313] = {.lex_state = 4, .external_lex_state = 3},
  [314] = {.lex_state = 4, .external_lex_state = 3},
  [315] = {.lex_state = 4, .external_lex_state = 3},
  [316] = {.lex_state = 4, .external_lex_state = 3},
  [317] = {.lex_state = 4, .external_lex_state = 3},
  [318] = {.lex_state = 4, .external_lex_state = 3},
  [319] = {.lex_state = 63, .external_lex_state = 3},
  [320] = {.lex_state = 4, .external_lex_state = 3},
  [321] = {.lex_state = 4, .external_lex_state = 3},
  [322] = {.lex_state = 4, .external_lex_state = 3},
  [323] = {.lex_state = 4, .external_lex_state = 3},
  [324] = {.lex_state = 63, .external_lex_state = 3},
  [325] = {.lex_state = 4, .external_lex_state = 3},
  [326] = {.lex_state = 63, .external_lex_state = 3},
  [327] = {.lex_state = 4, .external_lex_state = 3},
  [328] = {.lex_state = 4, .external_lex_state = 3},
  [329] = {.lex_state = 4, .external_lex_state = 3},
  [330] = {.lex_state = 4, .external_lex_state = 3},
  [331] = {.lex_state = 4, .external_lex_state = 3},
  [332] = {.lex_state = 4, .external_lex_state = 3},
  [333] = {.lex_state = 63, .external_lex_state = 3},
  [334] = {.lex_state = 4, .external_lex_state = 3},
  [335] = {.lex_state = 63, .external_lex_state = 3},
  [336] = {.lex_state = 63, .external_lex_state = 3},
  [337] = {.lex_state = 63, .external_lex_state = 3},
  [338] = {.lex_state = 4, .external_lex_state = 3},
  [339] = {.lex_state = 4, .external_lex_state = 3},
  [340] = {.lex_state = 4, .external_lex_state = 3},
  [341] = {.lex_state = 4, .external_lex_state = 3},
  [342] = {.lex_state = 65, .external_lex_state = 3},
  [343] = {.lex_state = 63, .external_lex_state = 3},
  [344] = {.lex_state = 63, .external_lex_state = 3},
  [345] = {.lex_state = 63, .external_lex_state = 3},
  [346] = {.lex_state = 63, .external_lex_state = 3},
  [347] = {.lex_state = 63, .external_lex_state = 3},
  [348] = {.lex_state = 4, .external_lex_state = 3},
  [349] = {.lex_state = 4, .external_lex_state = 3},
  [350] = {.lex_state = 4, .external_lex_state = 3},
  [351] = {.lex_state = 4, .external_lex_state = 3},
  [352] = {.lex_state = 63, .external_lex_state = 3},
  [353] = {.lex_state = 4, .external_lex_state = 3},
  [354] = {.lex_state = 63, .external_lex_state = 3},
  [355] = {.lex_state = 63, .external_lex_state = 3},
  [356] = {.lex_state = 63, .external_lex_state = 3},
  [357] = {.lex_state = 63, .external_lex_state = 3},
  [358] = {.lex_state = 63, .external_lex_state = 3},
  [359] = {.lex_state = 4, .external_lex_state = 3},
  [360] = {.lex_state = 63, .external_lex_state = 3},
  [361] = {.lex_state = 63, .external_lex_state = 3},
  [362] = {.lex_state = 63, .external_lex_state = 3},
  [363] = {.lex_state = 4, .external_lex_state = 3},
  [364] = {.lex_state = 4, .external_lex_state = 3},
  [365] = {.lex_state = 4, .external_lex_state = 3},
  [366] = {.lex_state = 4, .external_lex_state = 3},
  [367] = {.lex_state = 4, .external_lex_state = 3},
  [368] = {.lex_state = 63, .external_lex_state = 3},
  [369] = {.lex_state = 63, .external_lex_state = 3},
  [370] = {.lex_state = 63, .external_lex_state = 3},
  [371] = {.lex_state = 63, .external_lex_state = 3},
  [372] = {.lex_state = 63, .external_lex_state = 3},
  [373] = {.lex_state = 4, .external_lex_state = 3},
  [374] = {.lex_state = 4, .external_lex_state = 3},
  [375] = {.lex_state = 4, .external_lex_state = 3},
  [376] = {.lex_state = 4, .external_lex_state = 3},
  [377] = {.lex_state = 4, .external_lex_state = 3},
  [378] = {.lex_state = 63, .external_lex_state = 3},
  [379] = {.lex_state = 63, .external_lex_state = 3},
  [380] = {.lex_state = 63, .external_lex_state = 3},
  [381] = {.lex_state = 63, .external_lex_state = 3},
  [382] = {.lex_state = 63, .external_lex_state = 3},
  [383] = {.lex_state = 63, .external_lex_state = 3},
  [384] = {.lex_state = 4, .external_lex_state = 3},
  [385] = {.lex_state = 4, .external_lex_state = 3},
  [386] = {.lex_state = 63, .external_lex_state = 3},
  [387] = {.lex_state = 63, .external_lex_state = 3},
  [388] = {.lex_state = 63, .external_lex_state = 3},
  [389] = {.lex_state = 4, .external_lex_state = 3},
  [390] = {.lex_state = 63, .external_lex_state = 3},
  [391] = {.lex_state = 63, .external_lex_state = 3},
  [392] = {.lex_state = 4, .external_lex_state = 3},
  [393] = {.lex_state = 63, .external_lex_state = 3},
  [394] = {.lex_state = 63, .external_lex_state = 3},
  [395] = {.lex_state = 4, .external_lex_state = 3},
  [396] = {.lex_state = 63, .external_lex_state = 3},
  [397] = {.lex_state = 63, .external_lex_state = 3},
  [398] = {.lex_state = 63, .external_lex_state = 3},
  [399] = {.lex_state = 63, .external_lex_state = 3},
  [400] = {.lex_state = 4, .external_lex_state = 3},
  [401] = {.lex_state = 63, .external_lex_state = 3},
  [402] = {.lex_state = 4, .external_lex_state = 3},
  [403] = {.lex_state = 63, .external_lex_state = 3},
  [404] = {.lex_state = 16},
  [405] = {.lex_state = 16},
  [406] = {.lex_state = 4, .external_lex_state = 3},
  [407] = {.lex_state = 4, .external_lex_state = 3},
  [408] = {.lex_state = 4, .external_lex_state = 3},
  [409] = {.lex_state = 1, .external_lex_state = 5},
  [410] = {.lex_state = 4, .external_lex_state = 3},
  [411] = {.lex_state = 1, .external_lex_state = 5},
  [412] = {.lex_state = 7, .external_lex_state = 3},
  [413] = {.lex_state = 7, .external_lex_state = 3},
  [414] = {.lex_state = 16},
  [415] = {.lex_state = 7, .external_lex_state = 3},
  [416] = {.lex_state = 16},
  [417] = {.lex_state = 16},
  [418] = {.lex_state = 16},
  [419] = {.lex_state = 16},
  [420] = {.lex_state = 4, .external_lex_state = 3},
  [421] = {.lex_state = 16},
  [422] = {.lex_state = 4, .external_lex_state = 3},
  [423] = {.lex_state = 16},
  [424] = {.lex_state = 16},
  [425] = {.lex_state = 16},
  [426] = {.lex_state = 16},
  [427] = {.lex_state = 12, .external_lex_state = 6},
  [428] = {.lex_state = 16},
  [429] = {.lex_state = 16},
  [430] = {.lex_state = 16},
  [431] = {.lex_state = 16},
  [432] = {.lex_state = 16},
  [433] = {.lex_state = 16},
  [434] = {.lex_state = 16},
  [435] = {.lex_state = 16},
  [436] = {.lex_state = 16},
  [437] = {.lex_state = 15},
  [438] = {.lex_state = 15},
  [439] = {.lex_state = 16},
  [440] = {.lex_state = 16},
  [441] = {.lex_state = 63, .external_lex_state = 3},
  [442] = {.lex_state = 16},
  [443] = {.lex_state = 16},
  [444] = {.lex_state = 7, .external_lex_state = 3},
  [445] = {.lex_state = 1, .external_lex_state = 3},
  [446] = {.lex_state = 63, .external_lex_state = 3},
  [447] = {.lex_state = 15},
  [448] = {.lex_state = 16},
  [449] = {.lex_state = 16},
  [450] = {.lex_state = 16},
  [451] = {.lex_state = 16},
  [452] = {.lex_state = 63, .external_lex_state = 3},
  [453] = {.lex_state = 15},
  [454] = {.lex_state = 16},
  [455] = {.lex_state = 16},
  [456] = {.lex_state = 16},
  [457] = {.lex_state = 16},
  [458] = {.lex_state = 16},
  [459] = {.lex_state = 16},
  [460] = {.lex_state = 16},
  [461] = {.lex_state = 1, .external_lex_state = 3},
  [462] = {.lex_state = 16},
  [463] = {.lex_state = 16},
  [464] = {.lex_state = 7, .external_lex_state = 3},
  [465] = {.lex_state = 16},
  [466] = {.lex_state = 16},
  [467] = {.lex_state = 63, .external_lex_state = 3},
  [468] = {.lex_state = 1, .external_lex_state = 3},
  [469] = {.lex_state = 1, .external_lex_state = 3},
  [470] = {.lex_state = 63, .external_lex_state = 3},
  [471] = {.lex_state = 16},
  [472] = {.lex_state = 63, .external_lex_state = 3},
  [473] = {.lex_state = 63, .external_lex_state = 3},
  [474] = {.lex_state = 63, .external_lex_state = 3},
  [475] = {.lex_state = 1, .external_lex_state = 3},
  [476] = {.lex_state = 63, .external_lex_state = 3},
  [477] = {.lex_state = 63, .external_lex_state = 3},
  [478] = {.lex_state = 1, .external_lex_state = 3},
  [479] = {.lex_state = 63, .external_lex_state = 3},
  [480] = {.lex_state = 16},
  [481] = {.lex_state = 1, .external_lex_state = 3},
  [482] = {.lex_state = 1, .external_lex_state = 3},
  [483] = {.lex_state = 1, .external_lex_state = 3},
  [484] = {.lex_state = 1, .external_lex_state = 3},
  [485] = {.lex_state = 16},
  [486] = {.lex_state = 1, .external_lex_state = 3},
  [487] = {.lex_state = 63, .external_lex_state = 3},
  [488] = {.lex_state = 63, .external_lex_state = 3},
  [489] = {.lex_state = 63, .external_lex_state = 3},
  [490] = {.lex_state = 63, .external_lex_state = 3},
  [491] = {.lex_state = 63, .external_lex_state = 3},
  [492] = {.lex_state = 63, .external_lex_state = 3},
  [493] = {.lex_state = 63, .external_lex_state = 3},
  [494] = {.lex_state = 63, .external_lex_state = 3},
  [495] = {.lex_state = 63, .external_lex_state = 3},
  [496] = {.lex_state = 15},
  [497] = {.lex_state = 63, .external_lex_state = 3},
  [498] = {.lex_state = 63, .external_lex_state = 3},
  [499] = {.lex_state = 15},
  [500] = {.lex_state = 63, .external_lex_state = 3},
  [501] = {.lex_state = 63, .external_lex_state = 3},
  [502] = {.lex_state = 63, .external_lex_state = 3},
  [503] = {.lex_state = 63, .external_lex_state = 3},
  [504] = {.lex_state = 63, .external_lex_state = 3},
  [505] = {.lex_state = 63, .external_lex_state = 3},
  [506] = {.lex_state = 63, .external_lex_state = 3},
  [507] = {.lex_state = 63, .external_lex_state = 3},
  [508] = {.lex_state = 15},
  [509] = {.lex_state = 63, .external_lex_state = 3},
  [510] = {.lex_state = 15},
  [511] = {.lex_state = 63, .external_lex_state = 3},
  [512] = {.lex_state = 63, .external_lex_state = 3},
  [513] = {.lex_state = 63, .external_lex_state = 3},
  [514] = {.lex_state = 63, .external_lex_state = 3},
  [515] = {.lex_state = 63, .external_lex_state = 3},
  [516] = {.lex_state = 63, .external_lex_state = 3},
  [517] = {.lex_state = 63, .external_lex_state = 3},
  [518] = {.lex_state = 63, .external_lex_state = 3},
  [519] = {.lex_state = 63, .external_lex_state = 3},
  [520] = {.lex_state = 63, .external_lex_state = 3},
  [521] = {.lex_state = 63, .external_lex_state = 3},
  [522] = {.lex_state = 16},
  [523] = {.lex_state = 16},
  [524] = {.lex_state = 16},
  [525] = {.lex_state = 16},
  [526] = {.lex_state = 16},
  [527] = {.lex_state = 63, .external_lex_state = 3},
  [528] = {.lex_state = 16},
  [529] = {.lex_state = 16},
  [530] = {.lex_state = 63, .external_lex_state = 3},
  [531] = {.lex_state = 16},
  [532] = {.lex_state = 16},
  [533] = {.lex_state = 16},
  [534] = {.lex_state = 16},
  [535] = {.lex_state = 16},
  [536] = {.lex_state = 16},
  [537] = {.lex_state = 16},
  [538] = {.lex_state = 16},
  [539] = {.lex_state = 16},
  [540] = {.lex_state = 16},
  [541] = {.lex_state = 16},
  [542] = {.lex_state = 16},
  [543] = {.lex_state = 16},
  [544] = {.lex_state = 16},
  [545] = {.lex_state = 16},
  [546] = {.lex_state = 16},
  [547] = {.lex_state = 16},
  [548] = {.lex_state = 16},
  [549] = {.lex_state = 16},
  [550] = {.lex_state = 16},
  [551] = {.lex_state = 16},
  [552] = {.lex_state = 16},
  [553] = {.lex_state = 16},
  [554] = {.lex_state = 16},
  [555] = {.lex_state = 16},
  [556] = {.lex_state = 16},
  [557] = {.lex_state = 16},
  [558] = {.lex_state = 16},
  [559] = {.lex_state = 16},
  [560] = {.lex_state = 16},
  [561] = {.lex_state = 16},
  [562] = {.lex_state = 16},
  [563] = {.lex_state = 16},
  [564] = {.lex_state = 16},
  [565] = {.lex_state = 16},
  [566] = {.lex_state = 16},
  [567] = {.lex_state = 16},
  [568] = {.lex_state = 16},
  [569] = {.lex_state = 16},
  [570] = {.lex_state = 16},
  [571] = {.lex_state = 16},
  [572] = {.lex_state = 16},
  [573] = {.lex_state = 16},
  [574] = {.lex_state = 11, .external_lex_state = 6},
  [575] = {.lex_state = 25, .external_lex_state = 6},
  [576] = {.lex_state = 25, .external_lex_state = 6},
  [577] = {.lex_state = 13, .external_lex_state = 6},
  [578] = {.lex_state = 18},
  [579] = {.lex_state = 18},
  [580] = {.lex_state = 18},
  [581] = {.lex_state = 27, .external_lex_state = 6},
  [582] = {.lex_state = 18},
  [583] = {.lex_state = 15, .external_lex_state = 7},
  [584] = {.lex_state = 26, .external_lex_state = 6},
  [585] = {.lex_state = 18},
  [586] = {.lex_state = 24, .external_lex_state = 6},
  [587] = {.lex_state = 27},
  [588] = {.lex_state = 18},
  [589] = {.lex_state = 16, .external_lex_state = 7},
  [590] = {.lex_state = 15, .external_lex_state = 7},
  [591] = {.lex_state = 16, .external_lex_state = 7},
  [592] = {.lex_state = 16},
  [593] = {.lex_state = 16},
  [594] = {.lex_state = 16},
  [595] = {.lex_state = 16},
  [596] = {.lex_state = 15},
  [597] = {.lex_state = 15},
  [598] = {.lex_state = 15},
  [599] = {.lex_state = 16},
  [600] = {.lex_state = 16},
  [601] = {.lex_state = 16},
  [602] = {.lex_state = 16},
  [603] = {.lex_state = 15},
  [604] = {.lex_state = 16},
  [605] = {.lex_state = 63},
  [606] = {.lex_state = 16},
  [607] = {.lex_state = 16},
  [608] = {.lex_state = 15},
  [609] = {.lex_state = 16},
  [610] = {.lex_state = 16},
  [611] = {.lex_state = 26, .external_lex_state = 6},
  [612] = {.lex_state = 15},
  [613] = {.lex_state = 15},
  [614] = {.lex_state = 16},
  [615] = {.lex_state = 16},
  [616] = {.lex_state = 16},
  [617] = {.lex_state = 16},
  [618] = {.lex_state = 16},
  [619] = {.lex_state = 16},
  [620] = {.lex_state = 16},
  [621] = {.lex_state = 16},
  [622] = {.lex_state = 16},
  [623] = {.lex_state = 16},
  [624] = {.lex_state = 16},
  [625] = {.lex_state = 16},
  [626] = {.lex_state = 16},
  [627] = {.lex_state = 15},
  [628] = {.lex_state = 15},
  [629] = {.lex_state = 16},
  [630] = {.lex_state = 16},
  [631] = {.lex_state = 15},
  [632] = {.lex_state = 16},
  [633] = {.lex_state = 16},
  [634] = {.lex_state = 16},
  [635] = {.lex_state = 15},
  [636] = {.lex_state = 16},
  [637] = {.lex_state = 15},
  [638] = {.lex_state = 16},
  [639] = {.lex_state = 16},
  [640] = {.lex_state = 15},
  [641] = {.lex_state = 16},
  [642] = {.lex_state = 16},
  [643] = {.lex_state = 16},
  [644] = {.lex_state = 16},
  [645] = {.lex_state = 16},
  [646] = {.lex_state = 16},
  [647] = {.lex_state = 16},
  [648] = {.lex_state = 16},
  [649] = {.lex_state = 16},
  [650] = {.lex_state = 16},
  [651] = {.lex_state = 15},
  [652] = {.lex_state = 15},
  [653] = {.lex_state = 16},
  [654] = {.lex_state = 16},
  [655] = {.lex_state = 16},
  [656] = {.lex_state = 16},
  [657] = {.lex_state = 15},
  [658] = {.lex_state = 16},
  [659] = {.lex_state = 16},
  [660] = {.lex_state = 15},
  [661] = {.lex_state = 16},
  [662] = {.lex_state = 16},
  [663] = {.lex_state = 16},
  [664] = {.lex_state = 26, .external_lex_state = 6},
  [665] = {.lex_state = 16},
  [666] = {.lex_state = 16},
  [667] = {.lex_state = 26, .external_lex_state = 6},
  [668] = {.lex_state = 16},
  [669] = {.lex_state = 15},
  [670] = {.lex_state = 16},
  [671] = {.lex_state = 16},
  [672] = {.lex_state = 16},
  [673] = {.lex_state = 63},
  [674] = {.lex_state = 16},
  [675] = {.lex_state = 16},
  [676] = {.lex_state = 16},
  [677] = {.lex_state = 16},
  [678] = {.lex_state = 16},
  [679] = {.lex_state = 16},
  [680] = {.lex_state = 16},
  [681] = {.lex_state = 26},
  [682] = {.lex_state = 26},
  [683] = {.lex_state = 26},
  [684] = {.lex_state = 26},
  [685] = {.lex_state = 26},
  [686] = {.lex_state = 26},
  [687] = {.lex_state = 26},
  [688] = {.lex_state = 26},
  [689] = {.lex_state = 16},
  [690] = {.lex_state = 16},
  [691] = {.lex_state = 16},
  [692] = {.lex_state = 16},
  [693] = {.lex_state = 16},
  [694] = {.lex_state = 16},
  [695] = {.lex_state = 16},
  [696] = {.lex_state = 16},
  [697] = {.lex_state = 16},
  [698] = {.lex_state = 16},
  [699] = {.lex_state = 16},
  [700] = {.lex_state = 16},
  [701] = {.lex_state = 16},
  [702] = {.lex_state = 16},
  [703] = {.lex_state = 16},
  [704] = {.lex_state = 63},
  [705] = {.lex_state = 16},
  [706] = {.lex_state = 63},
  [707] = {.lex_state = 63},
  [708] = {.lex_state = 63},
  [709] = {.lex_state = 19},
  [710] = {.lex_state = 19},
  [711] = {.lex_state = 63},
  [712] = {.lex_state = 63},
  [713] = {.lex_state = 63},
  [714] = {.lex_state = 4},
  [715] = {.lex_state = 4},
  [716] = {.lex_state = 19},
  [717] = {.lex_state = 4},
  [718] = {.lex_state = 4},
  [719] = {.lex_state = 19},
  [720] = {.lex_state = 4},
  [721] = {.lex_state = 4},
  [722] = {.lex_state = 28},
  [723] = {.lex_state = 28},
  [724] = {.lex_state = 28},
  [725] = {.lex_state = 19},
  [726] = {.lex_state = 22},
  [727] = {.lex_state = 19},
  [728] = {.lex_state = 14, .external_lex_state = 7},
  [729] = {.lex_state = 63},
  [730] = {.lex_state = 19},
  [731] = {.lex_state = 19},
  [732] = {.lex_state = 19},
  [733] = {.lex_state = 19},
  [734] = {.lex_state = 28},
  [735] = {.lex_state = 19},
  [736] = {.lex_state = 19},
  [737] = {.lex_state = 19},
  [738] = {.lex_state = 19},
  [739] = {.lex_state = 19},
  [740] = {.lex_state = 19},
  [741] = {.lex_state = 19},
  [742] = {.lex_state = 19},
  [743] = {.lex_state = 19},
  [744] = {.lex_state = 28},
  [745] = {.lex_state = 19},
  [746] = {.lex_state = 14, .external_lex_state = 7},
  [747] = {.lex_state = 23},
  [748] = {.lex_state = 23},
  [749] = {.lex_state = 23},
  [750] = {.lex_state = 23},
  [751] = {.lex_state = 14},
  [752] = {.lex_state = 6},
  [753] = {.lex_state = 23},
  [754] = {.lex_state = 14},
  [755] = {.lex_state = 4, .external_lex_state = 7},
  [756] = {.lex_state = 23},
  [757] = {.lex_state = 4, .external_lex_state = 7},
  [758] = {.lex_state = 63},
  [759] = {.lex_state = 14},
  [760] = {.lex_state = 23},
  [761] = {.lex_state = 23},
  [762] = {.lex_state = 23},
  [763] = {.lex_state = 14},
  [764] = {.lex_state = 23},
  [765] = {.lex_state = 23},
  [766] = {.lex_state = 23},
  [767] = {.lex_state = 23},
  [768] = {.lex_state = 23},
  [769] = {.lex_state = 63, .external_lex_state = 7},
  [770] = {.lex_state = 14},
  [771] = {.lex_state = 23},
  [772] = {.lex_state = 14},
  [773] = {.lex_state = 63, .external_lex_state = 7},
  [774] = {.lex_state = 23},
  [775] = {.lex_state = 14},
  [776] = {.lex_state = 14},
  [777] = {.lex_state = 23},
  [778] = {.lex_state = 14},
  [779] = {.lex_state = 4},
  [780] = {.lex_state = 4},
  [781] = {.lex_state = 4},
  [782] = {.lex_state = 4},
  [783] = {.lex_state = 4},
  [784] = {.lex_state = 4},
  [785] = {.lex_state = 4},
  [786] = {.lex_state = 4},
  [787] = {.lex_state = 63, .external_lex_state = 7},
  [788] = {.lex_state = 4},
  [789] = {.lex_state = 4},
  [790] = {.lex_state = 63},
  [791] = {.lex_state = 4},
  [792] = {.lex_state = 4},
  [793] = {.lex_state = 4},
  [794] = {.lex_state = 4},
  [795] = {.lex_state = 4},
  [796] = {.lex_state = 4},
  [797] = {.lex_state = 4},
  [798] = {.lex_state = 4},
  [799] = {.lex_state = 4},
  [800] = {.lex_state = 4},
  [801] = {.lex_state = 4},
  [802] = {.lex_state = 4},
  [803] = {.lex_state = 4},
  [804] = {.lex_state = 4},
  [805] = {.lex_state = 4},
  [806] = {.lex_state = 4},
  [807] = {.lex_state = 4},
  [808] = {.lex_state = 4},
  [809] = {.lex_state = 4},
  [810] = {.lex_state = 4},
  [811] = {.lex_state = 4},
  [812] = {.lex_state = 4},
  [813] = {.lex_state = 4},
  [814] = {.lex_state = 4},
  [815] = {.lex_state = 4},
  [816] = {.lex_state = 4},
  [817] = {.lex_state = 4},
  [818] = {.lex_state = 4},
  [819] = {.lex_state = 4},
  [820] = {.lex_state = 4},
  [821] = {.lex_state = 4},
  [822] = {.lex_state = 63},
  [823] = {.lex_state = 4},
  [824] = {.lex_state = 4},
  [825] = {.lex_state = 4},
  [826] = {.lex_state = 4},
  [827] = {.lex_state = 4},
  [828] = {.lex_state = 4},
  [829] = {.lex_state = 4},
  [830] = {.lex_state = 4},
  [831] = {.lex_state = 4},
  [832] = {.lex_state = 4},
  [833] = {.lex_state = 4},
  [834] = {.lex_state = 4},
  [835] = {.lex_state = 4},
  [836] = {.lex_state = 4},
  [837] = {.lex_state = 4},
  [838] = {.lex_state = 63},
  [839] = {.lex_state = 4},
  [840] = {.lex_state = 4},
  [841] = {.lex_state = 4},
  [842] = {.lex_state = 63},
  [843] = {.lex_state = 4},
  [844] = {.lex_state = 63},
  [845] = {.lex_state = 19},
  [846] = {.lex_state = 4},
  [847] = {.lex_state = 4},
  [848] = {.lex_state = 4},
  [849] = {.lex_state = 4},
  [850] = {.lex_state = 63, .external_lex_state = 7},
  [851] = {.lex_state = 4},
  [852] = {.lex_state = 4},
  [853] = {.lex_state = 4},
  [854] = {.lex_state = 63},
  [855] = {.lex_state = 63},
  [856] = {.lex_state = 23},
  [857] = {.lex_state = 23},
  [858] = {.lex_state = 63},
  [859] = {.lex_state = 63},
  [860] = {.lex_state = 63},
  [861] = {.lex_state = 63},
  [862] = {.lex_state = 63},
  [863] = {.lex_state = 63},
  [864] = {.lex_state = 63},
  [865] = {.lex_state = 63},
  [866] = {.lex_state = 63},
  [867] = {.lex_state = 19},
  [868] = {.lex_state = 63},
  [869] = {.lex_state = 63},
  [870] = {.lex_state = 63},
  [871] = {.lex_state = 63},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 38},
  [874] = {.lex_state = 38},
  [875] = {.lex_state = 38},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 38},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 38},
  [880] = {.lex_state = 38},
  [881] = {.lex_state = 38},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 38},
  [884] = {.lex_state = 38},
  [885] = {.lex_state = 38},
  [886] = {.lex_state = 19},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 19},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 19},
  [898] = {.lex_state = 19},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 19},
  [905] = {.lex_state = 19},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 19},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 38},
  [918] = {.lex_state = 38},
  [919] = {.lex_state = 38},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 19, .external_lex_state = 7},
  [924] = {.lex_state = 19},
  [925] = {.lex_state = 19, .external_lex_state = 7},
  [926] = {.lex_state = 0},
  [927] = {.lex_state = 0},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 38},
  [930] = {.lex_state = 38},
  [931] = {.lex_state = 38},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 0},
  [934] = {.lex_state = 19},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 0},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 0},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 0},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 0},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 0},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 0},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 0},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 70},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 0},
  [1010] = {.lex_state = 0},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 19},
  [1014] = {.lex_state = 0},
  [1015] = {.lex_state = 0},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 0},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 19},
  [1032] = {.lex_state = 19},
  [1033] = {.lex_state = 19},
  [1034] = {.lex_state = 19},
  [1035] = {.lex_state = 19},
  [1036] = {.lex_state = 19},
  [1037] = {.lex_state = 19},
  [1038] = {.lex_state = 19},
  [1039] = {.lex_state = 19},
  [1040] = {.lex_state = 19},
  [1041] = {.lex_state = 19},
  [1042] = {.lex_state = 19},
  [1043] = {.lex_state = 19},
  [1044] = {.lex_state = 19},
  [1045] = {.lex_state = 19},
  [1046] = {.lex_state = 19},
  [1047] = {.lex_state = 19},
  [1048] = {.lex_state = 19},
  [1049] = {.lex_state = 19},
  [1050] = {.lex_state = 19},
  [1051] = {.lex_state = 19},
  [1052] = {.lex_state = 19},
  [1053] = {.lex_state = 19},
  [1054] = {.lex_state = 19},
  [1055] = {.lex_state = 19},
  [1056] = {.lex_state = 19},
  [1057] = {.lex_state = 19},
  [1058] = {.lex_state = 19},
  [1059] = {.lex_state = 19},
  [1060] = {.lex_state = 19},
  [1061] = {.lex_state = 19},
  [1062] = {.lex_state = 19},
  [1063] = {.lex_state = 19},
  [1064] = {.lex_state = 19},
  [1065] = {.lex_state = 19},
  [1066] = {.lex_state = 19},
  [1067] = {.lex_state = 19},
  [1068] = {.lex_state = 19},
  [1069] = {.lex_state = 19},
  [1070] = {.lex_state = 19},
  [1071] = {.lex_state = 19},
  [1072] = {.lex_state = 19},
  [1073] = {.lex_state = 19},
  [1074] = {.lex_state = 19},
  [1075] = {.lex_state = 19},
  [1076] = {.lex_state = 19},
  [1077] = {.lex_state = 19},
  [1078] = {.lex_state = 19},
  [1079] = {.lex_state = 19},
  [1080] = {.lex_state = 19},
  [1081] = {.lex_state = 19},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 19},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 19},
  [1087] = {.lex_state = 19},
  [1088] = {.lex_state = 19},
  [1089] = {.lex_state = 19},
  [1090] = {.lex_state = 19},
  [1091] = {.lex_state = 19},
  [1092] = {.lex_state = 19},
  [1093] = {.lex_state = 19},
  [1094] = {.lex_state = 19},
  [1095] = {.lex_state = 19},
  [1096] = {.lex_state = 19},
  [1097] = {.lex_state = 0},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 19},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_symbol] = ACTIONS(1),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_where] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_COLONuntil] = ACTIONS(1),
    [anon_sym_COLONinto] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_case_DASHtry] = ACTIONS(1),
    [anon_sym_match_DASHtry] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_lambda] = ACTIONS(1),
    [anon_sym_u03bb] = ACTIONS(1),
    [anon_sym_macro] = ACTIONS(1),
    [anon_sym_hashfn] = ACTIONS(1),
    [anon_sym_each] = ACTIONS(1),
    [anon_sym_collect] = ACTIONS(1),
    [anon_sym_icollect] = ACTIONS(1),
    [anon_sym_accumulate] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_fcollect] = ACTIONS(1),
    [anon_sym_faccumulate] = ACTIONS(1),
    [anon_sym_local] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_global] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_import_DASHmacros] = ACTIONS(1),
    [anon_sym_quote] = ACTIONS(1),
    [anon_sym_unquote] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_QMARK_DOT] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_COLON2] = ACTIONS(1),
    [anon_sym_DOLLAR_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT2] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_nil] = ACTIONS(1),
    [anon_sym_true2] = ACTIONS(1),
    [anon_sym_false2] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym_symbol_option] = ACTIONS(1),
    [anon_sym_POUND2] = ACTIONS(1),
    [anon_sym_QMARK_DOT2] = ACTIONS(1),
    [anon_sym_TILDE_EQ2] = ACTIONS(1),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(1),
    [anon_sym_DOT_DOT2] = ACTIONS(1),
    [anon_sym_DOT2] = ACTIONS(1),
    [sym__hashfn_reader_macro_char] = ACTIONS(1),
    [sym__quote_reader_macro_char] = ACTIONS(1),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(1),
    [sym__unquote_reader_macro_char] = ACTIONS(1),
    [sym___reader_macro_count] = ACTIONS(1),
    [sym___colon_string_start_mark] = ACTIONS(1),
    [sym___colon_string_end_mark] = ACTIONS(1),
    [sym_shebang] = ACTIONS(1),
    [sym___token_count] = ACTIONS(1),
  },
  [1] = {
    [sym_program] = STATE(1085),
    [sym_comment] = STATE(1),
    [sym__sexp] = STATE(503),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_program_repeat1] = STATE(113),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
    [sym_shebang] = ACTIONS(37),
  },
  [2] = {
    [sym_comment] = STATE(2),
    [sym__sexp] = STATE(64),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym__list_content] = STATE(1020),
    [sym_list] = STATE(386),
    [sym__binding] = STATE(697),
    [sym_list_binding] = STATE(701),
    [sym_sequence_binding] = STATE(701),
    [sym_table_binding] = STATE(701),
    [sym__literal_binding] = STATE(701),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(489),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(487),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_list_binding_repeat1] = STATE(539),
    [sym_symbol] = ACTIONS(39),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_case] = ACTIONS(49),
    [anon_sym_match] = ACTIONS(51),
    [anon_sym_case_DASHtry] = ACTIONS(53),
    [anon_sym_match_DASHtry] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_fn] = ACTIONS(59),
    [anon_sym_lambda] = ACTIONS(61),
    [anon_sym_u03bb] = ACTIONS(61),
    [anon_sym_macro] = ACTIONS(63),
    [anon_sym_hashfn] = ACTIONS(65),
    [anon_sym_each] = ACTIONS(67),
    [anon_sym_collect] = ACTIONS(69),
    [anon_sym_icollect] = ACTIONS(71),
    [anon_sym_accumulate] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_fcollect] = ACTIONS(77),
    [anon_sym_faccumulate] = ACTIONS(79),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_var] = ACTIONS(83),
    [anon_sym_global] = ACTIONS(85),
    [anon_sym_set] = ACTIONS(87),
    [anon_sym_let] = ACTIONS(89),
    [anon_sym_import_DASHmacros] = ACTIONS(91),
    [anon_sym_quote] = ACTIONS(93),
    [anon_sym_unquote] = ACTIONS(95),
    [sym_nil] = ACTIONS(97),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(99),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [3] = {
    [sym_comment] = STATE(3),
    [sym__sexp] = STATE(64),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym__list_content] = STATE(1004),
    [sym_list] = STATE(386),
    [sym__binding] = STATE(697),
    [sym_list_binding] = STATE(701),
    [sym_sequence_binding] = STATE(701),
    [sym_table_binding] = STATE(701),
    [sym__literal_binding] = STATE(701),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(489),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(487),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_list_binding_repeat1] = STATE(540),
    [sym_symbol] = ACTIONS(39),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(101),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_case] = ACTIONS(103),
    [anon_sym_match] = ACTIONS(105),
    [anon_sym_case_DASHtry] = ACTIONS(107),
    [anon_sym_match_DASHtry] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_fn] = ACTIONS(113),
    [anon_sym_lambda] = ACTIONS(115),
    [anon_sym_u03bb] = ACTIONS(115),
    [anon_sym_macro] = ACTIONS(117),
    [anon_sym_hashfn] = ACTIONS(119),
    [anon_sym_each] = ACTIONS(121),
    [anon_sym_collect] = ACTIONS(123),
    [anon_sym_icollect] = ACTIONS(125),
    [anon_sym_accumulate] = ACTIONS(127),
    [anon_sym_for] = ACTIONS(129),
    [anon_sym_fcollect] = ACTIONS(131),
    [anon_sym_faccumulate] = ACTIONS(133),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_var] = ACTIONS(137),
    [anon_sym_global] = ACTIONS(139),
    [anon_sym_set] = ACTIONS(141),
    [anon_sym_let] = ACTIONS(143),
    [anon_sym_import_DASHmacros] = ACTIONS(145),
    [anon_sym_quote] = ACTIONS(147),
    [anon_sym_unquote] = ACTIONS(149),
    [sym_nil] = ACTIONS(97),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(99),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [4] = {
    [sym_comment] = STATE(4),
    [sym__sexp] = STATE(64),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym__list_content] = STATE(1020),
    [sym_list] = STATE(386),
    [sym__binding] = STATE(697),
    [sym_list_binding] = STATE(701),
    [sym_sequence_binding] = STATE(701),
    [sym_table_binding] = STATE(701),
    [sym__literal_binding] = STATE(701),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(489),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(487),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_list_binding_repeat1] = STATE(533),
    [sym_symbol] = ACTIONS(39),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(41),
    [anon_sym_RPAREN] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(45),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(47),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_case] = ACTIONS(49),
    [anon_sym_match] = ACTIONS(51),
    [anon_sym_case_DASHtry] = ACTIONS(53),
    [anon_sym_match_DASHtry] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_fn] = ACTIONS(59),
    [anon_sym_lambda] = ACTIONS(61),
    [anon_sym_u03bb] = ACTIONS(61),
    [anon_sym_macro] = ACTIONS(63),
    [anon_sym_hashfn] = ACTIONS(65),
    [anon_sym_each] = ACTIONS(67),
    [anon_sym_collect] = ACTIONS(69),
    [anon_sym_icollect] = ACTIONS(71),
    [anon_sym_accumulate] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_fcollect] = ACTIONS(77),
    [anon_sym_faccumulate] = ACTIONS(79),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_var] = ACTIONS(83),
    [anon_sym_global] = ACTIONS(85),
    [anon_sym_set] = ACTIONS(87),
    [anon_sym_let] = ACTIONS(89),
    [anon_sym_import_DASHmacros] = ACTIONS(91),
    [anon_sym_quote] = ACTIONS(93),
    [anon_sym_unquote] = ACTIONS(95),
    [sym_nil] = ACTIONS(97),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(99),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [5] = {
    [sym_comment] = STATE(5),
    [sym__sexp] = STATE(64),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym__list_content] = STATE(975),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(151),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_case] = ACTIONS(153),
    [anon_sym_match] = ACTIONS(155),
    [anon_sym_case_DASHtry] = ACTIONS(157),
    [anon_sym_match_DASHtry] = ACTIONS(159),
    [anon_sym_if] = ACTIONS(161),
    [anon_sym_fn] = ACTIONS(163),
    [anon_sym_lambda] = ACTIONS(165),
    [anon_sym_u03bb] = ACTIONS(165),
    [anon_sym_macro] = ACTIONS(167),
    [anon_sym_hashfn] = ACTIONS(169),
    [anon_sym_each] = ACTIONS(171),
    [anon_sym_collect] = ACTIONS(173),
    [anon_sym_icollect] = ACTIONS(175),
    [anon_sym_accumulate] = ACTIONS(177),
    [anon_sym_for] = ACTIONS(179),
    [anon_sym_fcollect] = ACTIONS(181),
    [anon_sym_faccumulate] = ACTIONS(183),
    [anon_sym_local] = ACTIONS(185),
    [anon_sym_var] = ACTIONS(187),
    [anon_sym_global] = ACTIONS(189),
    [anon_sym_set] = ACTIONS(191),
    [anon_sym_let] = ACTIONS(193),
    [anon_sym_import_DASHmacros] = ACTIONS(195),
    [anon_sym_quote] = ACTIONS(197),
    [anon_sym_unquote] = ACTIONS(199),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [6] = {
    [sym_comment] = STATE(6),
    [sym__sexp] = STATE(64),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym__list_content] = STATE(1020),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(43),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_case] = ACTIONS(49),
    [anon_sym_match] = ACTIONS(51),
    [anon_sym_case_DASHtry] = ACTIONS(53),
    [anon_sym_match_DASHtry] = ACTIONS(55),
    [anon_sym_if] = ACTIONS(57),
    [anon_sym_fn] = ACTIONS(59),
    [anon_sym_lambda] = ACTIONS(61),
    [anon_sym_u03bb] = ACTIONS(61),
    [anon_sym_macro] = ACTIONS(63),
    [anon_sym_hashfn] = ACTIONS(65),
    [anon_sym_each] = ACTIONS(67),
    [anon_sym_collect] = ACTIONS(69),
    [anon_sym_icollect] = ACTIONS(71),
    [anon_sym_accumulate] = ACTIONS(73),
    [anon_sym_for] = ACTIONS(75),
    [anon_sym_fcollect] = ACTIONS(77),
    [anon_sym_faccumulate] = ACTIONS(79),
    [anon_sym_local] = ACTIONS(81),
    [anon_sym_var] = ACTIONS(83),
    [anon_sym_global] = ACTIONS(85),
    [anon_sym_set] = ACTIONS(87),
    [anon_sym_let] = ACTIONS(89),
    [anon_sym_import_DASHmacros] = ACTIONS(91),
    [anon_sym_quote] = ACTIONS(93),
    [anon_sym_unquote] = ACTIONS(95),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [7] = {
    [sym_comment] = STATE(7),
    [sym__sexp] = STATE(64),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym__list_content] = STATE(1004),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(101),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_case] = ACTIONS(103),
    [anon_sym_match] = ACTIONS(105),
    [anon_sym_case_DASHtry] = ACTIONS(107),
    [anon_sym_match_DASHtry] = ACTIONS(109),
    [anon_sym_if] = ACTIONS(111),
    [anon_sym_fn] = ACTIONS(113),
    [anon_sym_lambda] = ACTIONS(115),
    [anon_sym_u03bb] = ACTIONS(115),
    [anon_sym_macro] = ACTIONS(117),
    [anon_sym_hashfn] = ACTIONS(119),
    [anon_sym_each] = ACTIONS(121),
    [anon_sym_collect] = ACTIONS(123),
    [anon_sym_icollect] = ACTIONS(125),
    [anon_sym_accumulate] = ACTIONS(127),
    [anon_sym_for] = ACTIONS(129),
    [anon_sym_fcollect] = ACTIONS(131),
    [anon_sym_faccumulate] = ACTIONS(133),
    [anon_sym_local] = ACTIONS(135),
    [anon_sym_var] = ACTIONS(137),
    [anon_sym_global] = ACTIONS(139),
    [anon_sym_set] = ACTIONS(141),
    [anon_sym_let] = ACTIONS(143),
    [anon_sym_import_DASHmacros] = ACTIONS(145),
    [anon_sym_quote] = ACTIONS(147),
    [anon_sym_unquote] = ACTIONS(149),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [8] = {
    [sym_comment] = STATE(8),
    [sym__sexp] = STATE(64),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym__list_content] = STATE(1029),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(201),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_case] = ACTIONS(203),
    [anon_sym_match] = ACTIONS(205),
    [anon_sym_case_DASHtry] = ACTIONS(207),
    [anon_sym_match_DASHtry] = ACTIONS(209),
    [anon_sym_if] = ACTIONS(211),
    [anon_sym_fn] = ACTIONS(213),
    [anon_sym_lambda] = ACTIONS(215),
    [anon_sym_u03bb] = ACTIONS(215),
    [anon_sym_macro] = ACTIONS(217),
    [anon_sym_hashfn] = ACTIONS(219),
    [anon_sym_each] = ACTIONS(221),
    [anon_sym_collect] = ACTIONS(223),
    [anon_sym_icollect] = ACTIONS(225),
    [anon_sym_accumulate] = ACTIONS(227),
    [anon_sym_for] = ACTIONS(229),
    [anon_sym_fcollect] = ACTIONS(231),
    [anon_sym_faccumulate] = ACTIONS(233),
    [anon_sym_local] = ACTIONS(235),
    [anon_sym_var] = ACTIONS(237),
    [anon_sym_global] = ACTIONS(239),
    [anon_sym_set] = ACTIONS(241),
    [anon_sym_let] = ACTIONS(243),
    [anon_sym_import_DASHmacros] = ACTIONS(245),
    [anon_sym_quote] = ACTIONS(247),
    [anon_sym_unquote] = ACTIONS(249),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [9] = {
    [sym_comment] = STATE(9),
    [sym__sexp] = STATE(64),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym__list_content] = STATE(938),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(251),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [anon_sym_case] = ACTIONS(253),
    [anon_sym_match] = ACTIONS(255),
    [anon_sym_case_DASHtry] = ACTIONS(257),
    [anon_sym_match_DASHtry] = ACTIONS(259),
    [anon_sym_if] = ACTIONS(261),
    [anon_sym_fn] = ACTIONS(263),
    [anon_sym_lambda] = ACTIONS(265),
    [anon_sym_u03bb] = ACTIONS(265),
    [anon_sym_macro] = ACTIONS(267),
    [anon_sym_hashfn] = ACTIONS(269),
    [anon_sym_each] = ACTIONS(271),
    [anon_sym_collect] = ACTIONS(273),
    [anon_sym_icollect] = ACTIONS(275),
    [anon_sym_accumulate] = ACTIONS(277),
    [anon_sym_for] = ACTIONS(279),
    [anon_sym_fcollect] = ACTIONS(281),
    [anon_sym_faccumulate] = ACTIONS(283),
    [anon_sym_local] = ACTIONS(285),
    [anon_sym_var] = ACTIONS(287),
    [anon_sym_global] = ACTIONS(289),
    [anon_sym_set] = ACTIONS(291),
    [anon_sym_let] = ACTIONS(293),
    [anon_sym_import_DASHmacros] = ACTIONS(295),
    [anon_sym_quote] = ACTIONS(297),
    [anon_sym_unquote] = ACTIONS(299),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [10] = {
    [sym_comment] = STATE(10),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym__table_metadata_key_docstring] = STATE(729),
    [sym__table_metadata_docstring] = STATE(862),
    [sym__table_metadata_key_arglist] = STATE(758),
    [sym__table_metadata_arglist] = STATE(860),
    [sym__table_metadata_generic] = STATE(861),
    [sym_table_metadata_pair] = STATE(868),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(153),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_metadata_repeat1] = STATE(605),
    [aux_sym_table_repeat1] = STATE(40),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(303),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(305),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [11] = {
    [sym_comment] = STATE(11),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym__binding] = STATE(657),
    [sym_list_binding] = STATE(635),
    [sym_sequence_binding] = STATE(635),
    [sym_table_binding] = STATE(635),
    [sym__literal_binding] = STATE(635),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(484),
    [sym__colon_string] = STATE(482),
    [sym__double_quote_string] = STATE(481),
    [sym_string] = STATE(483),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(94),
    [aux_sym_list_binding_repeat1] = STATE(499),
    [sym_symbol] = ACTIONS(307),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_RBRACK] = ACTIONS(313),
    [anon_sym_COLON] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [sym_nil] = ACTIONS(321),
    [anon_sym_true] = ACTIONS(323),
    [anon_sym_false] = ACTIONS(323),
    [sym_number] = ACTIONS(325),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [12] = {
    [sym_comment] = STATE(12),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym__binding] = STATE(657),
    [sym_list_binding] = STATE(635),
    [sym_sequence_binding] = STATE(635),
    [sym_table_binding] = STATE(635),
    [sym__literal_binding] = STATE(635),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(484),
    [sym__colon_string] = STATE(482),
    [sym__double_quote_string] = STATE(481),
    [sym_string] = STATE(483),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(68),
    [aux_sym_list_binding_repeat1] = STATE(496),
    [sym_symbol] = ACTIONS(307),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_RBRACK] = ACTIONS(327),
    [anon_sym_COLON] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [sym_nil] = ACTIONS(321),
    [anon_sym_true] = ACTIONS(323),
    [anon_sym_false] = ACTIONS(323),
    [sym_number] = ACTIONS(325),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [13] = {
    [sym_comment] = STATE(13),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym__binding] = STATE(657),
    [sym_list_binding] = STATE(635),
    [sym_sequence_binding] = STATE(635),
    [sym_table_binding] = STATE(635),
    [sym__literal_binding] = STATE(635),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(484),
    [sym__colon_string] = STATE(482),
    [sym__double_quote_string] = STATE(481),
    [sym_string] = STATE(483),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(68),
    [aux_sym_list_binding_repeat1] = STATE(510),
    [sym_symbol] = ACTIONS(307),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_RBRACK] = ACTIONS(327),
    [anon_sym_COLON] = ACTIONS(315),
    [anon_sym_LBRACE] = ACTIONS(317),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(319),
    [sym_nil] = ACTIONS(321),
    [anon_sym_true] = ACTIONS(323),
    [anon_sym_false] = ACTIONS(323),
    [sym_number] = ACTIONS(325),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [14] = {
    [sym_comment] = STATE(14),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_table_metadata] = STATE(159),
    [sym__function_inner_body_all] = STATE(995),
    [sym__function_inner_body_docstring] = STATE(996),
    [sym__function_inner_body_metadata] = STATE(997),
    [sym__function_inner_body_generic] = STATE(998),
    [sym__function_inner_body] = STATE(999),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(25),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(104),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(329),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [15] = {
    [sym_comment] = STATE(15),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_table_metadata] = STATE(159),
    [sym__function_inner_body_all] = STATE(995),
    [sym__function_inner_body_docstring] = STATE(996),
    [sym__function_inner_body_metadata] = STATE(997),
    [sym__function_inner_body_generic] = STATE(998),
    [sym__function_inner_body] = STATE(1102),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(25),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(104),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [16] = {
    [sym_comment] = STATE(16),
    [sym__sexp] = STATE(252),
    [sym_hashfn_reader_macro] = STATE(277),
    [sym_quote_reader_macro] = STATE(277),
    [sym_quasi_quote_reader_macro] = STATE(277),
    [sym_unquote_reader_macro] = STATE(277),
    [sym__reader_macro] = STATE(273),
    [sym_list] = STATE(273),
    [sym__iter_option_legacy] = STATE(322),
    [sym__iter_option_lhs] = STATE(31),
    [sym_iter_option] = STATE(422),
    [sym_case_form] = STATE(278),
    [sym_match_form] = STATE(278),
    [sym_case_try_form] = STATE(278),
    [sym_match_try_form] = STATE(278),
    [sym_if_form] = STATE(278),
    [sym_fn_form] = STATE(278),
    [sym_lambda_form] = STATE(278),
    [sym_macro_form] = STATE(278),
    [sym_hashfn_form] = STATE(278),
    [sym_each_form] = STATE(278),
    [sym_collect_form] = STATE(278),
    [sym_icollect_form] = STATE(278),
    [sym_accumulate_form] = STATE(278),
    [sym_for_form] = STATE(278),
    [sym_fcollect_form] = STATE(278),
    [sym_faccumulate_form] = STATE(278),
    [sym_local_form] = STATE(278),
    [sym_var_form] = STATE(278),
    [sym_global_form] = STATE(278),
    [sym_set_form] = STATE(278),
    [sym_let_form] = STATE(278),
    [sym_import_macros_form] = STATE(278),
    [sym_quote_form] = STATE(278),
    [sym_unquote_form] = STATE(278),
    [sym__form] = STATE(273),
    [sym_sequence] = STATE(273),
    [sym_table] = STATE(273),
    [sym__literal] = STATE(273),
    [sym_boolean] = STATE(297),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(297),
    [sym_multi_symbol] = STATE(261),
    [sym_multi_symbol_method] = STATE(273),
    [sym__special_override_symbol] = STATE(273),
    [aux_sym__iter_body_repeat2] = STATE(251),
    [sym_symbol] = ACTIONS(335),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(339),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_COLON] = ACTIONS(343),
    [anon_sym_LBRACE] = ACTIONS(345),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_COLONuntil] = ACTIONS(351),
    [anon_sym_COLONinto] = ACTIONS(351),
    [sym_nil] = ACTIONS(353),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(353),
    [sym_symbol_option] = ACTIONS(357),
    [anon_sym_POUND2] = ACTIONS(347),
    [anon_sym_QMARK_DOT2] = ACTIONS(347),
    [anon_sym_TILDE_EQ2] = ACTIONS(347),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(347),
    [anon_sym_DOT_DOT2] = ACTIONS(359),
    [anon_sym_DOT2] = ACTIONS(359),
    [sym__hashfn_reader_macro_char] = ACTIONS(361),
    [sym__quote_reader_macro_char] = ACTIONS(363),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(365),
    [sym__unquote_reader_macro_char] = ACTIONS(367),
  },
  [17] = {
    [sym_comment] = STATE(17),
    [sym__sexp] = STATE(720),
    [sym_hashfn_reader_macro] = STATE(816),
    [sym_quote_reader_macro] = STATE(816),
    [sym_quasi_quote_reader_macro] = STATE(816),
    [sym_unquote_reader_macro] = STATE(816),
    [sym__reader_macro] = STATE(814),
    [sym_list] = STATE(814),
    [sym__iter_option_legacy] = STATE(322),
    [sym__iter_option_lhs] = STATE(41),
    [sym_iter_option] = STATE(804),
    [sym_case_form] = STATE(825),
    [sym_match_form] = STATE(825),
    [sym_case_try_form] = STATE(825),
    [sym_match_try_form] = STATE(825),
    [sym_if_form] = STATE(825),
    [sym_fn_form] = STATE(825),
    [sym_lambda_form] = STATE(825),
    [sym_macro_form] = STATE(825),
    [sym_hashfn_form] = STATE(825),
    [sym_each_form] = STATE(825),
    [sym_collect_form] = STATE(825),
    [sym_icollect_form] = STATE(825),
    [sym_accumulate_form] = STATE(825),
    [sym_for_form] = STATE(825),
    [sym_fcollect_form] = STATE(825),
    [sym_faccumulate_form] = STATE(825),
    [sym_local_form] = STATE(825),
    [sym_var_form] = STATE(825),
    [sym_global_form] = STATE(825),
    [sym_set_form] = STATE(825),
    [sym_let_form] = STATE(825),
    [sym_import_macros_form] = STATE(825),
    [sym_quote_form] = STATE(825),
    [sym_unquote_form] = STATE(825),
    [sym__form] = STATE(814),
    [sym_sequence] = STATE(814),
    [sym_table] = STATE(814),
    [sym__literal] = STATE(814),
    [sym_boolean] = STATE(802),
    [sym__colon_string] = STATE(780),
    [sym__double_quote_string] = STATE(824),
    [sym_string] = STATE(802),
    [sym_multi_symbol] = STATE(752),
    [sym_multi_symbol_method] = STATE(814),
    [sym__special_override_symbol] = STATE(814),
    [aux_sym__iter_body_repeat2] = STATE(718),
    [sym_symbol] = ACTIONS(369),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(373),
    [anon_sym_RBRACK] = ACTIONS(339),
    [anon_sym_COLON] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [anon_sym_COLONuntil] = ACTIONS(351),
    [anon_sym_COLONinto] = ACTIONS(351),
    [sym_nil] = ACTIONS(383),
    [anon_sym_true] = ACTIONS(385),
    [anon_sym_false] = ACTIONS(385),
    [sym_number] = ACTIONS(383),
    [sym_symbol_option] = ACTIONS(357),
    [anon_sym_POUND2] = ACTIONS(379),
    [anon_sym_QMARK_DOT2] = ACTIONS(379),
    [anon_sym_TILDE_EQ2] = ACTIONS(379),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(379),
    [anon_sym_DOT_DOT2] = ACTIONS(387),
    [anon_sym_DOT2] = ACTIONS(387),
    [sym__hashfn_reader_macro_char] = ACTIONS(389),
    [sym__quote_reader_macro_char] = ACTIONS(391),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(393),
    [sym__unquote_reader_macro_char] = ACTIONS(395),
  },
  [18] = {
    [sym_comment] = STATE(18),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym__table_binding_key] = STATE(775),
    [sym_table_binding_pair] = STATE(790),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(518),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_binding_repeat1] = STATE(704),
    [aux_sym_table_repeat1] = STATE(40),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(397),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(401),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [19] = {
    [sym_comment] = STATE(19),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym__table_binding_key] = STATE(775),
    [sym_table_binding_pair] = STATE(790),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(518),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_binding_repeat1] = STATE(707),
    [aux_sym_table_repeat1] = STATE(23),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(397),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(401),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [20] = {
    [sym_comment] = STATE(20),
    [sym__sexp] = STATE(721),
    [sym_hashfn_reader_macro] = STATE(816),
    [sym_quote_reader_macro] = STATE(816),
    [sym_quasi_quote_reader_macro] = STATE(816),
    [sym_unquote_reader_macro] = STATE(816),
    [sym__reader_macro] = STATE(814),
    [sym_list] = STATE(814),
    [sym__binding] = STATE(527),
    [sym_list_binding] = STATE(474),
    [sym_sequence_binding] = STATE(474),
    [sym_table_binding] = STATE(474),
    [sym__literal_binding] = STATE(474),
    [sym_case_form] = STATE(825),
    [sym_match_form] = STATE(825),
    [sym_case_try_form] = STATE(825),
    [sym_match_try_form] = STATE(825),
    [sym_if_form] = STATE(825),
    [sym_fn_form] = STATE(825),
    [sym_lambda_form] = STATE(825),
    [sym_macro_form] = STATE(825),
    [sym_hashfn_form] = STATE(825),
    [sym_each_form] = STATE(825),
    [sym_collect_form] = STATE(825),
    [sym_icollect_form] = STATE(825),
    [sym_accumulate_form] = STATE(825),
    [sym_for_form] = STATE(825),
    [sym_fcollect_form] = STATE(825),
    [sym_faccumulate_form] = STATE(825),
    [sym_local_form] = STATE(825),
    [sym_var_form] = STATE(825),
    [sym_global_form] = STATE(825),
    [sym_set_form] = STATE(825),
    [sym_let_form] = STATE(825),
    [sym_import_macros_form] = STATE(825),
    [sym_quote_form] = STATE(825),
    [sym_unquote_form] = STATE(825),
    [sym__form] = STATE(814),
    [sym_sequence] = STATE(814),
    [sym_table] = STATE(814),
    [sym__literal] = STATE(814),
    [sym_boolean] = STATE(406),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(407),
    [sym_multi_symbol] = STATE(752),
    [sym_multi_symbol_method] = STATE(814),
    [sym__special_override_symbol] = STATE(814),
    [aux_sym__iter_body_repeat1] = STATE(245),
    [sym_symbol] = ACTIONS(405),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(407),
    [anon_sym_LBRACK] = ACTIONS(409),
    [anon_sym_COLON] = ACTIONS(411),
    [anon_sym_LBRACE] = ACTIONS(413),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_nil] = ACTIONS(415),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(417),
    [sym_symbol_option] = ACTIONS(419),
    [anon_sym_POUND2] = ACTIONS(379),
    [anon_sym_QMARK_DOT2] = ACTIONS(379),
    [anon_sym_TILDE_EQ2] = ACTIONS(379),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(379),
    [anon_sym_DOT_DOT2] = ACTIONS(387),
    [anon_sym_DOT2] = ACTIONS(387),
    [sym__hashfn_reader_macro_char] = ACTIONS(389),
    [sym__quote_reader_macro_char] = ACTIONS(391),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(393),
    [sym__unquote_reader_macro_char] = ACTIONS(395),
  },
  [21] = {
    [sym_comment] = STATE(21),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym__table_binding_key] = STATE(775),
    [sym_table_binding_pair] = STATE(790),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(518),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_binding_repeat1] = STATE(708),
    [aux_sym_table_repeat1] = STATE(40),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(397),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(401),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [22] = {
    [sym_comment] = STATE(22),
    [sym__sexp] = STATE(160),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(27),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(421),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [23] = {
    [sym_comment] = STATE(23),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(32),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(423),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [24] = {
    [sym_comment] = STATE(24),
    [sym__sexp] = STATE(151),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(27),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(425),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [25] = {
    [sym_comment] = STATE(25),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_table_metadata] = STATE(152),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(45),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(427),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(331),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [26] = {
    [sym_comment] = STATE(26),
    [sym__sexp] = STATE(156),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(27),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(429),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [27] = {
    [sym_comment] = STATE(27),
    [sym__sexp] = STATE(183),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(27),
    [sym_symbol] = ACTIONS(431),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(434),
    [anon_sym_RPAREN] = ACTIONS(437),
    [anon_sym_LBRACK] = ACTIONS(439),
    [anon_sym_COLON] = ACTIONS(442),
    [anon_sym_LBRACE] = ACTIONS(445),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(448),
    [anon_sym_DQUOTE] = ACTIONS(451),
    [sym_nil] = ACTIONS(454),
    [anon_sym_true] = ACTIONS(457),
    [anon_sym_false] = ACTIONS(457),
    [sym_number] = ACTIONS(454),
    [sym_symbol_option] = ACTIONS(460),
    [anon_sym_POUND2] = ACTIONS(448),
    [anon_sym_QMARK_DOT2] = ACTIONS(448),
    [anon_sym_TILDE_EQ2] = ACTIONS(448),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(448),
    [anon_sym_DOT_DOT2] = ACTIONS(463),
    [anon_sym_DOT2] = ACTIONS(463),
    [sym__hashfn_reader_macro_char] = ACTIONS(466),
    [sym__quote_reader_macro_char] = ACTIONS(469),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(472),
    [sym__unquote_reader_macro_char] = ACTIONS(475),
  },
  [28] = {
    [sym_comment] = STATE(28),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(32),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(478),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [29] = {
    [sym_comment] = STATE(29),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(36),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(480),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [30] = {
    [sym_comment] = STATE(30),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(32),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(482),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [31] = {
    [sym_comment] = STATE(31),
    [sym__sexp] = STATE(420),
    [sym_hashfn_reader_macro] = STATE(277),
    [sym_quote_reader_macro] = STATE(277),
    [sym_quasi_quote_reader_macro] = STATE(277),
    [sym_unquote_reader_macro] = STATE(277),
    [sym__reader_macro] = STATE(273),
    [sym_list] = STATE(273),
    [sym_case_form] = STATE(278),
    [sym_match_form] = STATE(278),
    [sym_case_try_form] = STATE(278),
    [sym_match_try_form] = STATE(278),
    [sym_if_form] = STATE(278),
    [sym_fn_form] = STATE(278),
    [sym_lambda_form] = STATE(278),
    [sym_macro_form] = STATE(278),
    [sym_hashfn_form] = STATE(278),
    [sym_each_form] = STATE(278),
    [sym_collect_form] = STATE(278),
    [sym_icollect_form] = STATE(278),
    [sym_accumulate_form] = STATE(278),
    [sym_for_form] = STATE(278),
    [sym_fcollect_form] = STATE(278),
    [sym_faccumulate_form] = STATE(278),
    [sym_local_form] = STATE(278),
    [sym_var_form] = STATE(278),
    [sym_global_form] = STATE(278),
    [sym_set_form] = STATE(278),
    [sym_let_form] = STATE(278),
    [sym_import_macros_form] = STATE(278),
    [sym_quote_form] = STATE(278),
    [sym_unquote_form] = STATE(278),
    [sym__form] = STATE(273),
    [sym_sequence] = STATE(273),
    [sym_table] = STATE(273),
    [sym__literal] = STATE(273),
    [sym_boolean] = STATE(297),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(297),
    [sym_multi_symbol] = STATE(261),
    [sym_multi_symbol_method] = STATE(273),
    [sym__special_override_symbol] = STATE(273),
    [sym_symbol] = ACTIONS(335),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_RPAREN] = ACTIONS(484),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_COLON] = ACTIONS(343),
    [anon_sym_LBRACE] = ACTIONS(345),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [anon_sym_COLONuntil] = ACTIONS(484),
    [anon_sym_COLONinto] = ACTIONS(484),
    [sym_nil] = ACTIONS(353),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(353),
    [sym_symbol_option] = ACTIONS(486),
    [anon_sym_POUND2] = ACTIONS(347),
    [anon_sym_QMARK_DOT2] = ACTIONS(347),
    [anon_sym_TILDE_EQ2] = ACTIONS(347),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(347),
    [anon_sym_DOT_DOT2] = ACTIONS(359),
    [anon_sym_DOT2] = ACTIONS(359),
    [sym__hashfn_reader_macro_char] = ACTIONS(361),
    [sym__quote_reader_macro_char] = ACTIONS(363),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(365),
    [sym__unquote_reader_macro_char] = ACTIONS(367),
  },
  [32] = {
    [sym_comment] = STATE(32),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(32),
    [sym_symbol] = ACTIONS(488),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(491),
    [anon_sym_LBRACK] = ACTIONS(494),
    [anon_sym_COLON] = ACTIONS(497),
    [anon_sym_LBRACE] = ACTIONS(500),
    [anon_sym_RBRACE] = ACTIONS(503),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(505),
    [anon_sym_DQUOTE] = ACTIONS(508),
    [sym_nil] = ACTIONS(511),
    [anon_sym_true] = ACTIONS(514),
    [anon_sym_false] = ACTIONS(514),
    [sym_number] = ACTIONS(511),
    [sym_symbol_option] = ACTIONS(517),
    [anon_sym_POUND2] = ACTIONS(505),
    [anon_sym_QMARK_DOT2] = ACTIONS(505),
    [anon_sym_TILDE_EQ2] = ACTIONS(505),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(505),
    [anon_sym_DOT_DOT2] = ACTIONS(520),
    [anon_sym_DOT2] = ACTIONS(520),
    [sym__hashfn_reader_macro_char] = ACTIONS(523),
    [sym__quote_reader_macro_char] = ACTIONS(526),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(529),
    [sym__unquote_reader_macro_char] = ACTIONS(532),
  },
  [33] = {
    [sym_comment] = STATE(33),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(535),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(538),
    [anon_sym_RPAREN] = ACTIONS(541),
    [anon_sym_LBRACK] = ACTIONS(543),
    [anon_sym_RBRACK] = ACTIONS(541),
    [anon_sym_COLON] = ACTIONS(546),
    [anon_sym_LBRACE] = ACTIONS(549),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(552),
    [anon_sym_DQUOTE] = ACTIONS(555),
    [sym_nil] = ACTIONS(558),
    [anon_sym_true] = ACTIONS(561),
    [anon_sym_false] = ACTIONS(561),
    [sym_number] = ACTIONS(558),
    [sym_symbol_option] = ACTIONS(564),
    [anon_sym_POUND2] = ACTIONS(552),
    [anon_sym_QMARK_DOT2] = ACTIONS(552),
    [anon_sym_TILDE_EQ2] = ACTIONS(552),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(552),
    [anon_sym_DOT_DOT2] = ACTIONS(567),
    [anon_sym_DOT2] = ACTIONS(567),
    [sym__hashfn_reader_macro_char] = ACTIONS(570),
    [sym__quote_reader_macro_char] = ACTIONS(573),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(576),
    [sym__unquote_reader_macro_char] = ACTIONS(579),
  },
  [34] = {
    [sym_comment] = STATE(34),
    [sym__sexp] = STATE(164),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(27),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(582),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [35] = {
    [sym_comment] = STATE(35),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(28),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(584),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [36] = {
    [sym_comment] = STATE(36),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(32),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(586),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [37] = {
    [sym_comment] = STATE(37),
    [sym__sexp] = STATE(162),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(27),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(588),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [38] = {
    [sym_comment] = STATE(38),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(40),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(399),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [39] = {
    [sym_comment] = STATE(39),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(30),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(590),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [40] = {
    [sym_comment] = STATE(40),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(32),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(592),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [41] = {
    [sym_comment] = STATE(41),
    [sym__sexp] = STATE(836),
    [sym_hashfn_reader_macro] = STATE(816),
    [sym_quote_reader_macro] = STATE(816),
    [sym_quasi_quote_reader_macro] = STATE(816),
    [sym_unquote_reader_macro] = STATE(816),
    [sym__reader_macro] = STATE(814),
    [sym_list] = STATE(814),
    [sym_case_form] = STATE(825),
    [sym_match_form] = STATE(825),
    [sym_case_try_form] = STATE(825),
    [sym_match_try_form] = STATE(825),
    [sym_if_form] = STATE(825),
    [sym_fn_form] = STATE(825),
    [sym_lambda_form] = STATE(825),
    [sym_macro_form] = STATE(825),
    [sym_hashfn_form] = STATE(825),
    [sym_each_form] = STATE(825),
    [sym_collect_form] = STATE(825),
    [sym_icollect_form] = STATE(825),
    [sym_accumulate_form] = STATE(825),
    [sym_for_form] = STATE(825),
    [sym_fcollect_form] = STATE(825),
    [sym_faccumulate_form] = STATE(825),
    [sym_local_form] = STATE(825),
    [sym_var_form] = STATE(825),
    [sym_global_form] = STATE(825),
    [sym_set_form] = STATE(825),
    [sym_let_form] = STATE(825),
    [sym_import_macros_form] = STATE(825),
    [sym_quote_form] = STATE(825),
    [sym_unquote_form] = STATE(825),
    [sym__form] = STATE(814),
    [sym_sequence] = STATE(814),
    [sym_table] = STATE(814),
    [sym__literal] = STATE(814),
    [sym_boolean] = STATE(802),
    [sym__colon_string] = STATE(780),
    [sym__double_quote_string] = STATE(824),
    [sym_string] = STATE(802),
    [sym_multi_symbol] = STATE(752),
    [sym_multi_symbol_method] = STATE(814),
    [sym__special_override_symbol] = STATE(814),
    [sym_symbol] = ACTIONS(369),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(373),
    [anon_sym_RBRACK] = ACTIONS(484),
    [anon_sym_COLON] = ACTIONS(375),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [anon_sym_COLONuntil] = ACTIONS(484),
    [anon_sym_COLONinto] = ACTIONS(484),
    [sym_nil] = ACTIONS(383),
    [anon_sym_true] = ACTIONS(385),
    [anon_sym_false] = ACTIONS(385),
    [sym_number] = ACTIONS(383),
    [sym_symbol_option] = ACTIONS(419),
    [anon_sym_POUND2] = ACTIONS(379),
    [anon_sym_QMARK_DOT2] = ACTIONS(379),
    [anon_sym_TILDE_EQ2] = ACTIONS(379),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(379),
    [anon_sym_DOT_DOT2] = ACTIONS(387),
    [anon_sym_DOT2] = ACTIONS(387),
    [sym__hashfn_reader_macro_char] = ACTIONS(389),
    [sym__quote_reader_macro_char] = ACTIONS(391),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(393),
    [sym__unquote_reader_macro_char] = ACTIONS(395),
  },
  [42] = {
    [sym_comment] = STATE(42),
    [sym__sexp] = STATE(158),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table_pair] = STATE(500),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_table_repeat1] = STATE(23),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(403),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [43] = {
    [sym_comment] = STATE(43),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(594),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [44] = {
    [sym_comment] = STATE(44),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(596),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [45] = {
    [sym_comment] = STATE(45),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(598),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [46] = {
    [sym_comment] = STATE(46),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(600),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [47] = {
    [sym_comment] = STATE(47),
    [sym__sexp] = STATE(183),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(37),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [48] = {
    [sym_comment] = STATE(48),
    [sym__sexp] = STATE(509),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_case_guard_repeat1] = STATE(51),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(602),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [49] = {
    [sym_comment] = STATE(49),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(604),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [50] = {
    [sym_comment] = STATE(50),
    [sym__sexp] = STATE(503),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_program_repeat1] = STATE(145),
    [ts_builtin_sym_end] = ACTIONS(606),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [51] = {
    [sym_comment] = STATE(51),
    [sym__sexp] = STATE(509),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_case_guard_repeat1] = STATE(52),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(608),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [52] = {
    [sym_comment] = STATE(52),
    [sym__sexp] = STATE(509),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_case_guard_repeat1] = STATE(52),
    [sym_symbol] = ACTIONS(610),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(613),
    [anon_sym_RPAREN] = ACTIONS(616),
    [anon_sym_LBRACK] = ACTIONS(618),
    [anon_sym_COLON] = ACTIONS(621),
    [anon_sym_LBRACE] = ACTIONS(624),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(627),
    [anon_sym_DQUOTE] = ACTIONS(630),
    [sym_nil] = ACTIONS(633),
    [anon_sym_true] = ACTIONS(636),
    [anon_sym_false] = ACTIONS(636),
    [sym_number] = ACTIONS(633),
    [sym_symbol_option] = ACTIONS(639),
    [anon_sym_POUND2] = ACTIONS(627),
    [anon_sym_QMARK_DOT2] = ACTIONS(627),
    [anon_sym_TILDE_EQ2] = ACTIONS(627),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(627),
    [anon_sym_DOT_DOT2] = ACTIONS(642),
    [anon_sym_DOT2] = ACTIONS(642),
    [sym__hashfn_reader_macro_char] = ACTIONS(645),
    [sym__quote_reader_macro_char] = ACTIONS(648),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(651),
    [sym__unquote_reader_macro_char] = ACTIONS(654),
  },
  [53] = {
    [sym_comment] = STATE(53),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(68),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(327),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [54] = {
    [sym_comment] = STATE(54),
    [sym__sexp] = STATE(183),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(24),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [55] = {
    [sym_comment] = STATE(55),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(57),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(657),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [56] = {
    [sym_comment] = STATE(56),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(659),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [57] = {
    [sym_comment] = STATE(57),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(661),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [58] = {
    [sym_comment] = STATE(58),
    [sym__sexp] = STATE(183),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(34),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [59] = {
    [sym_comment] = STATE(59),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(70),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(663),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [60] = {
    [sym_comment] = STATE(60),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(71),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(665),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [61] = {
    [sym_comment] = STATE(61),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(72),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(667),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [62] = {
    [sym_comment] = STATE(62),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(74),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(669),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [63] = {
    [sym_comment] = STATE(63),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(75),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(671),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [64] = {
    [sym_comment] = STATE(64),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(129),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(673),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [65] = {
    [sym_comment] = STATE(65),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(43),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(675),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [66] = {
    [sym_comment] = STATE(66),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(77),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(677),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [67] = {
    [sym_comment] = STATE(67),
    [sym__sexp] = STATE(183),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(26),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [68] = {
    [sym_comment] = STATE(68),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(679),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [69] = {
    [sym_comment] = STATE(69),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(79),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(681),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [70] = {
    [sym_comment] = STATE(70),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(683),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [71] = {
    [sym_comment] = STATE(71),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(685),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [72] = {
    [sym_comment] = STATE(72),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(687),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [73] = {
    [sym_comment] = STATE(73),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(689),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [74] = {
    [sym_comment] = STATE(74),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(691),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [75] = {
    [sym_comment] = STATE(75),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(693),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [76] = {
    [sym_comment] = STATE(76),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(695),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [77] = {
    [sym_comment] = STATE(77),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(697),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [78] = {
    [sym_comment] = STATE(78),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(699),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [79] = {
    [sym_comment] = STATE(79),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(701),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [80] = {
    [sym_comment] = STATE(80),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(703),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [81] = {
    [sym_comment] = STATE(81),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(705),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [82] = {
    [sym_comment] = STATE(82),
    [sym__sexp] = STATE(503),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_program_repeat1] = STATE(82),
    [ts_builtin_sym_end] = ACTIONS(707),
    [sym_symbol] = ACTIONS(709),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(712),
    [anon_sym_LBRACK] = ACTIONS(715),
    [anon_sym_COLON] = ACTIONS(718),
    [anon_sym_LBRACE] = ACTIONS(721),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(724),
    [anon_sym_DQUOTE] = ACTIONS(727),
    [sym_nil] = ACTIONS(730),
    [anon_sym_true] = ACTIONS(733),
    [anon_sym_false] = ACTIONS(733),
    [sym_number] = ACTIONS(730),
    [sym_symbol_option] = ACTIONS(736),
    [anon_sym_POUND2] = ACTIONS(724),
    [anon_sym_QMARK_DOT2] = ACTIONS(724),
    [anon_sym_TILDE_EQ2] = ACTIONS(724),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(724),
    [anon_sym_DOT_DOT2] = ACTIONS(739),
    [anon_sym_DOT2] = ACTIONS(739),
    [sym__hashfn_reader_macro_char] = ACTIONS(742),
    [sym__quote_reader_macro_char] = ACTIONS(745),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(748),
    [sym__unquote_reader_macro_char] = ACTIONS(751),
  },
  [83] = {
    [sym_comment] = STATE(83),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(754),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [84] = {
    [sym_comment] = STATE(84),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(756),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [85] = {
    [sym_comment] = STATE(85),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(758),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [86] = {
    [sym_comment] = STATE(86),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(760),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [87] = {
    [sym_comment] = STATE(87),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(146),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(762),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [88] = {
    [sym_comment] = STATE(88),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(764),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [89] = {
    [sym_comment] = STATE(89),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(766),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [90] = {
    [sym_comment] = STATE(90),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(768),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [91] = {
    [sym_comment] = STATE(91),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(770),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [92] = {
    [sym_comment] = STATE(92),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(772),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [93] = {
    [sym_comment] = STATE(93),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(774),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [94] = {
    [sym_comment] = STATE(94),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(776),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [95] = {
    [sym_comment] = STATE(95),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(85),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(778),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [96] = {
    [sym_comment] = STATE(96),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(86),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(780),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [97] = {
    [sym_comment] = STATE(97),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(88),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(782),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [98] = {
    [sym_comment] = STATE(98),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(84),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(784),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [99] = {
    [sym_comment] = STATE(99),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(89),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(786),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [100] = {
    [sym_comment] = STATE(100),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(83),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(788),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [101] = {
    [sym_comment] = STATE(101),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(81),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(790),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [102] = {
    [sym_comment] = STATE(102),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(90),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(792),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [103] = {
    [sym_comment] = STATE(103),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(80),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(794),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [104] = {
    [sym_comment] = STATE(104),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(796),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [105] = {
    [sym_comment] = STATE(105),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(78),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(798),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [106] = {
    [sym_comment] = STATE(106),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(91),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(800),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [107] = {
    [sym_comment] = STATE(107),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(76),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(802),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [108] = {
    [sym_comment] = STATE(108),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(92),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(804),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [109] = {
    [sym_comment] = STATE(109),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(73),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(806),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [110] = {
    [sym_comment] = STATE(110),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(93),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(808),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [111] = {
    [sym_comment] = STATE(111),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(810),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [112] = {
    [sym_comment] = STATE(112),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(94),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(313),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [113] = {
    [sym_comment] = STATE(113),
    [sym__sexp] = STATE(503),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_program_repeat1] = STATE(82),
    [ts_builtin_sym_end] = ACTIONS(606),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [114] = {
    [sym_comment] = STATE(114),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(133),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(812),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [115] = {
    [sym_comment] = STATE(115),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(142),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(814),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [116] = {
    [sym_comment] = STATE(116),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(143),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(816),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [117] = {
    [sym_comment] = STATE(117),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(144),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(818),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [118] = {
    [sym_comment] = STATE(118),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(820),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [119] = {
    [sym_comment] = STATE(119),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(822),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [120] = {
    [sym_comment] = STATE(120),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(824),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [121] = {
    [sym_comment] = STATE(121),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(826),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [122] = {
    [sym_comment] = STATE(122),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(147),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(828),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [123] = {
    [sym_comment] = STATE(123),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(830),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [124] = {
    [sym_comment] = STATE(124),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(832),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [125] = {
    [sym_comment] = STATE(125),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(56),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(834),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [126] = {
    [sym_comment] = STATE(126),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(148),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(836),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [127] = {
    [sym_comment] = STATE(127),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(838),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [128] = {
    [sym_comment] = STATE(128),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(840),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [129] = {
    [sym_comment] = STATE(129),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(842),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [130] = {
    [sym_comment] = STATE(130),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(44),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(844),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [131] = {
    [sym_comment] = STATE(131),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(118),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(846),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [132] = {
    [sym_comment] = STATE(132),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(150),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(848),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [133] = {
    [sym_comment] = STATE(133),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(850),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [134] = {
    [sym_comment] = STATE(134),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(119),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(852),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [135] = {
    [sym_comment] = STATE(135),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(120),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(854),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [136] = {
    [sym_comment] = STATE(136),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(121),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(856),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [137] = {
    [sym_comment] = STATE(137),
    [sym__sexp] = STATE(183),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_if_pair] = STATE(515),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_if_form_repeat1] = STATE(22),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [138] = {
    [sym_comment] = STATE(138),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(123),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(858),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [139] = {
    [sym_comment] = STATE(139),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(124),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(860),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [140] = {
    [sym_comment] = STATE(140),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(127),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(862),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [141] = {
    [sym_comment] = STATE(141),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(128),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(864),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [142] = {
    [sym_comment] = STATE(142),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(866),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [143] = {
    [sym_comment] = STATE(143),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(868),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [144] = {
    [sym_comment] = STATE(144),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(870),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [145] = {
    [sym_comment] = STATE(145),
    [sym__sexp] = STATE(503),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym_program_repeat1] = STATE(82),
    [ts_builtin_sym_end] = ACTIONS(872),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [146] = {
    [sym_comment] = STATE(146),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(874),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [147] = {
    [sym_comment] = STATE(147),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(876),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [148] = {
    [sym_comment] = STATE(148),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(878),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [149] = {
    [sym_comment] = STATE(149),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(111),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(880),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [150] = {
    [sym_comment] = STATE(150),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(33),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(882),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [151] = {
    [sym_comment] = STATE(151),
    [sym__sexp] = STATE(507),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(884),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [152] = {
    [sym_comment] = STATE(152),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(49),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [153] = {
    [sym_comment] = STATE(153),
    [sym__sexp] = STATE(869),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_RBRACE] = ACTIONS(896),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(910),
    [sym__quote_reader_macro_char] = ACTIONS(912),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(914),
    [sym__unquote_reader_macro_char] = ACTIONS(916),
  },
  [154] = {
    [sym_comment] = STATE(154),
    [sym__sexp] = STATE(869),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_RBRACE] = ACTIONS(896),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(910),
    [sym__quote_reader_macro_char] = ACTIONS(912),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(914),
    [sym__unquote_reader_macro_char] = ACTIONS(916),
  },
  [155] = {
    [sym_comment] = STATE(155),
    [sym__sexp] = STATE(689),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_RBRACK] = ACTIONS(920),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [156] = {
    [sym_comment] = STATE(156),
    [sym__sexp] = STATE(507),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(932),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [157] = {
    [sym_comment] = STATE(157),
    [sym__sexp] = STATE(702),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_RPAREN] = ACTIONS(934),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [158] = {
    [sym_comment] = STATE(158),
    [sym__sexp] = STATE(517),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(936),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [159] = {
    [sym_comment] = STATE(159),
    [sym__sexp] = STATE(452),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [aux_sym__list_content_repeat1] = STATE(46),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [160] = {
    [sym_comment] = STATE(160),
    [sym__sexp] = STATE(507),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(938),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [161] = {
    [sym_comment] = STATE(161),
    [sym__sexp] = STATE(1024),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_RPAREN] = ACTIONS(940),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [162] = {
    [sym_comment] = STATE(162),
    [sym__sexp] = STATE(507),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(952),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [163] = {
    [sym_comment] = STATE(163),
    [sym__sexp] = STATE(689),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_RPAREN] = ACTIONS(920),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [164] = {
    [sym_comment] = STATE(164),
    [sym__sexp] = STATE(507),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_RPAREN] = ACTIONS(954),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [165] = {
    [sym_comment] = STATE(165),
    [sym__sexp] = STATE(418),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [166] = {
    [sym_comment] = STATE(166),
    [sym__sexp] = STATE(948),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [167] = {
    [sym_comment] = STATE(167),
    [sym__sexp] = STATE(403),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [168] = {
    [sym_comment] = STATE(168),
    [sym__sexp] = STATE(399),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [169] = {
    [sym_comment] = STATE(169),
    [sym__sexp] = STATE(442),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [170] = {
    [sym_comment] = STATE(170),
    [sym__sexp] = STATE(398),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [171] = {
    [sym_comment] = STATE(171),
    [sym__sexp] = STATE(449),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [172] = {
    [sym_comment] = STATE(172),
    [sym__sexp] = STATE(1030),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [173] = {
    [sym_comment] = STATE(173),
    [sym__sexp] = STATE(967),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [174] = {
    [sym_comment] = STATE(174),
    [sym__sexp] = STATE(953),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [175] = {
    [sym_comment] = STATE(175),
    [sym__sexp] = STATE(279),
    [sym_hashfn_reader_macro] = STATE(277),
    [sym_quote_reader_macro] = STATE(277),
    [sym_quasi_quote_reader_macro] = STATE(277),
    [sym_unquote_reader_macro] = STATE(277),
    [sym__reader_macro] = STATE(273),
    [sym_list] = STATE(273),
    [sym_case_form] = STATE(278),
    [sym_match_form] = STATE(278),
    [sym_case_try_form] = STATE(278),
    [sym_match_try_form] = STATE(278),
    [sym_if_form] = STATE(278),
    [sym_fn_form] = STATE(278),
    [sym_lambda_form] = STATE(278),
    [sym_macro_form] = STATE(278),
    [sym_hashfn_form] = STATE(278),
    [sym_each_form] = STATE(278),
    [sym_collect_form] = STATE(278),
    [sym_icollect_form] = STATE(278),
    [sym_accumulate_form] = STATE(278),
    [sym_for_form] = STATE(278),
    [sym_fcollect_form] = STATE(278),
    [sym_faccumulate_form] = STATE(278),
    [sym_local_form] = STATE(278),
    [sym_var_form] = STATE(278),
    [sym_global_form] = STATE(278),
    [sym_set_form] = STATE(278),
    [sym_let_form] = STATE(278),
    [sym_import_macros_form] = STATE(278),
    [sym_quote_form] = STATE(278),
    [sym_unquote_form] = STATE(278),
    [sym__form] = STATE(273),
    [sym_sequence] = STATE(273),
    [sym_table] = STATE(273),
    [sym__literal] = STATE(273),
    [sym_boolean] = STATE(297),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(297),
    [sym_multi_symbol] = STATE(261),
    [sym_multi_symbol_method] = STATE(273),
    [sym__special_override_symbol] = STATE(273),
    [sym_symbol] = ACTIONS(335),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_COLON] = ACTIONS(956),
    [anon_sym_LBRACE] = ACTIONS(345),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_nil] = ACTIONS(353),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(353),
    [sym_symbol_option] = ACTIONS(486),
    [anon_sym_POUND2] = ACTIONS(347),
    [anon_sym_QMARK_DOT2] = ACTIONS(347),
    [anon_sym_TILDE_EQ2] = ACTIONS(347),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(347),
    [anon_sym_DOT_DOT2] = ACTIONS(359),
    [anon_sym_DOT2] = ACTIONS(359),
    [sym__hashfn_reader_macro_char] = ACTIONS(361),
    [sym__quote_reader_macro_char] = ACTIONS(363),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(365),
    [sym__unquote_reader_macro_char] = ACTIONS(367),
  },
  [176] = {
    [sym_comment] = STATE(176),
    [sym__sexp] = STATE(281),
    [sym_hashfn_reader_macro] = STATE(277),
    [sym_quote_reader_macro] = STATE(277),
    [sym_quasi_quote_reader_macro] = STATE(277),
    [sym_unquote_reader_macro] = STATE(277),
    [sym__reader_macro] = STATE(273),
    [sym_list] = STATE(273),
    [sym_case_form] = STATE(278),
    [sym_match_form] = STATE(278),
    [sym_case_try_form] = STATE(278),
    [sym_match_try_form] = STATE(278),
    [sym_if_form] = STATE(278),
    [sym_fn_form] = STATE(278),
    [sym_lambda_form] = STATE(278),
    [sym_macro_form] = STATE(278),
    [sym_hashfn_form] = STATE(278),
    [sym_each_form] = STATE(278),
    [sym_collect_form] = STATE(278),
    [sym_icollect_form] = STATE(278),
    [sym_accumulate_form] = STATE(278),
    [sym_for_form] = STATE(278),
    [sym_fcollect_form] = STATE(278),
    [sym_faccumulate_form] = STATE(278),
    [sym_local_form] = STATE(278),
    [sym_var_form] = STATE(278),
    [sym_global_form] = STATE(278),
    [sym_set_form] = STATE(278),
    [sym_let_form] = STATE(278),
    [sym_import_macros_form] = STATE(278),
    [sym_quote_form] = STATE(278),
    [sym_unquote_form] = STATE(278),
    [sym__form] = STATE(273),
    [sym_sequence] = STATE(273),
    [sym_table] = STATE(273),
    [sym__literal] = STATE(273),
    [sym_boolean] = STATE(297),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(297),
    [sym_multi_symbol] = STATE(261),
    [sym_multi_symbol_method] = STATE(273),
    [sym__special_override_symbol] = STATE(273),
    [sym_symbol] = ACTIONS(335),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_COLON] = ACTIONS(956),
    [anon_sym_LBRACE] = ACTIONS(345),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_nil] = ACTIONS(353),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(353),
    [sym_symbol_option] = ACTIONS(486),
    [anon_sym_POUND2] = ACTIONS(347),
    [anon_sym_QMARK_DOT2] = ACTIONS(347),
    [anon_sym_TILDE_EQ2] = ACTIONS(347),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(347),
    [anon_sym_DOT_DOT2] = ACTIONS(359),
    [anon_sym_DOT2] = ACTIONS(359),
    [sym__hashfn_reader_macro_char] = ACTIONS(361),
    [sym__quote_reader_macro_char] = ACTIONS(363),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(365),
    [sym__unquote_reader_macro_char] = ACTIONS(367),
  },
  [177] = {
    [sym_comment] = STATE(177),
    [sym__sexp] = STATE(283),
    [sym_hashfn_reader_macro] = STATE(277),
    [sym_quote_reader_macro] = STATE(277),
    [sym_quasi_quote_reader_macro] = STATE(277),
    [sym_unquote_reader_macro] = STATE(277),
    [sym__reader_macro] = STATE(273),
    [sym_list] = STATE(273),
    [sym_case_form] = STATE(278),
    [sym_match_form] = STATE(278),
    [sym_case_try_form] = STATE(278),
    [sym_match_try_form] = STATE(278),
    [sym_if_form] = STATE(278),
    [sym_fn_form] = STATE(278),
    [sym_lambda_form] = STATE(278),
    [sym_macro_form] = STATE(278),
    [sym_hashfn_form] = STATE(278),
    [sym_each_form] = STATE(278),
    [sym_collect_form] = STATE(278),
    [sym_icollect_form] = STATE(278),
    [sym_accumulate_form] = STATE(278),
    [sym_for_form] = STATE(278),
    [sym_fcollect_form] = STATE(278),
    [sym_faccumulate_form] = STATE(278),
    [sym_local_form] = STATE(278),
    [sym_var_form] = STATE(278),
    [sym_global_form] = STATE(278),
    [sym_set_form] = STATE(278),
    [sym_let_form] = STATE(278),
    [sym_import_macros_form] = STATE(278),
    [sym_quote_form] = STATE(278),
    [sym_unquote_form] = STATE(278),
    [sym__form] = STATE(273),
    [sym_sequence] = STATE(273),
    [sym_table] = STATE(273),
    [sym__literal] = STATE(273),
    [sym_boolean] = STATE(297),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(297),
    [sym_multi_symbol] = STATE(261),
    [sym_multi_symbol_method] = STATE(273),
    [sym__special_override_symbol] = STATE(273),
    [sym_symbol] = ACTIONS(335),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_COLON] = ACTIONS(956),
    [anon_sym_LBRACE] = ACTIONS(345),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_nil] = ACTIONS(353),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(353),
    [sym_symbol_option] = ACTIONS(486),
    [anon_sym_POUND2] = ACTIONS(347),
    [anon_sym_QMARK_DOT2] = ACTIONS(347),
    [anon_sym_TILDE_EQ2] = ACTIONS(347),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(347),
    [anon_sym_DOT_DOT2] = ACTIONS(359),
    [anon_sym_DOT2] = ACTIONS(359),
    [sym__hashfn_reader_macro_char] = ACTIONS(361),
    [sym__quote_reader_macro_char] = ACTIONS(363),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(365),
    [sym__unquote_reader_macro_char] = ACTIONS(367),
  },
  [178] = {
    [sym_comment] = STATE(178),
    [sym__sexp] = STATE(285),
    [sym_hashfn_reader_macro] = STATE(277),
    [sym_quote_reader_macro] = STATE(277),
    [sym_quasi_quote_reader_macro] = STATE(277),
    [sym_unquote_reader_macro] = STATE(277),
    [sym__reader_macro] = STATE(273),
    [sym_list] = STATE(273),
    [sym_case_form] = STATE(278),
    [sym_match_form] = STATE(278),
    [sym_case_try_form] = STATE(278),
    [sym_match_try_form] = STATE(278),
    [sym_if_form] = STATE(278),
    [sym_fn_form] = STATE(278),
    [sym_lambda_form] = STATE(278),
    [sym_macro_form] = STATE(278),
    [sym_hashfn_form] = STATE(278),
    [sym_each_form] = STATE(278),
    [sym_collect_form] = STATE(278),
    [sym_icollect_form] = STATE(278),
    [sym_accumulate_form] = STATE(278),
    [sym_for_form] = STATE(278),
    [sym_fcollect_form] = STATE(278),
    [sym_faccumulate_form] = STATE(278),
    [sym_local_form] = STATE(278),
    [sym_var_form] = STATE(278),
    [sym_global_form] = STATE(278),
    [sym_set_form] = STATE(278),
    [sym_let_form] = STATE(278),
    [sym_import_macros_form] = STATE(278),
    [sym_quote_form] = STATE(278),
    [sym_unquote_form] = STATE(278),
    [sym__form] = STATE(273),
    [sym_sequence] = STATE(273),
    [sym_table] = STATE(273),
    [sym__literal] = STATE(273),
    [sym_boolean] = STATE(297),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(297),
    [sym_multi_symbol] = STATE(261),
    [sym_multi_symbol_method] = STATE(273),
    [sym__special_override_symbol] = STATE(273),
    [sym_symbol] = ACTIONS(335),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_COLON] = ACTIONS(956),
    [anon_sym_LBRACE] = ACTIONS(345),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_nil] = ACTIONS(353),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(353),
    [sym_symbol_option] = ACTIONS(486),
    [anon_sym_POUND2] = ACTIONS(347),
    [anon_sym_QMARK_DOT2] = ACTIONS(347),
    [anon_sym_TILDE_EQ2] = ACTIONS(347),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(347),
    [anon_sym_DOT_DOT2] = ACTIONS(359),
    [anon_sym_DOT2] = ACTIONS(359),
    [sym__hashfn_reader_macro_char] = ACTIONS(361),
    [sym__quote_reader_macro_char] = ACTIONS(363),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(365),
    [sym__unquote_reader_macro_char] = ACTIONS(367),
  },
  [179] = {
    [sym_comment] = STATE(179),
    [sym__sexp] = STATE(197),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [180] = {
    [sym_comment] = STATE(180),
    [sym__sexp] = STATE(397),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [181] = {
    [sym_comment] = STATE(181),
    [sym__sexp] = STATE(952),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [182] = {
    [sym_comment] = STATE(182),
    [sym__sexp] = STATE(939),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [183] = {
    [sym_comment] = STATE(183),
    [sym__sexp] = STATE(507),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [184] = {
    [sym_comment] = STATE(184),
    [sym__sexp] = STATE(480),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [185] = {
    [sym_comment] = STATE(185),
    [sym__sexp] = STATE(485),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [186] = {
    [sym_comment] = STATE(186),
    [sym__sexp] = STATE(661),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [187] = {
    [sym_comment] = STATE(187),
    [sym__sexp] = STATE(1091),
    [sym_hashfn_reader_macro] = STATE(1093),
    [sym_quote_reader_macro] = STATE(1093),
    [sym_quasi_quote_reader_macro] = STATE(1093),
    [sym_unquote_reader_macro] = STATE(1093),
    [sym__reader_macro] = STATE(1094),
    [sym_list] = STATE(1094),
    [sym_case_form] = STATE(1092),
    [sym_match_form] = STATE(1092),
    [sym_case_try_form] = STATE(1092),
    [sym_match_try_form] = STATE(1092),
    [sym_if_form] = STATE(1092),
    [sym_fn_form] = STATE(1092),
    [sym_lambda_form] = STATE(1092),
    [sym_macro_form] = STATE(1092),
    [sym_hashfn_form] = STATE(1092),
    [sym_each_form] = STATE(1092),
    [sym_collect_form] = STATE(1092),
    [sym_icollect_form] = STATE(1092),
    [sym_accumulate_form] = STATE(1092),
    [sym_for_form] = STATE(1092),
    [sym_fcollect_form] = STATE(1092),
    [sym_faccumulate_form] = STATE(1092),
    [sym_local_form] = STATE(1092),
    [sym_var_form] = STATE(1092),
    [sym_global_form] = STATE(1092),
    [sym_set_form] = STATE(1092),
    [sym_let_form] = STATE(1092),
    [sym_import_macros_form] = STATE(1092),
    [sym_quote_form] = STATE(1092),
    [sym_unquote_form] = STATE(1092),
    [sym__form] = STATE(1094),
    [sym_sequence] = STATE(1094),
    [sym_table] = STATE(1094),
    [sym__literal] = STATE(1094),
    [sym_boolean] = STATE(1069),
    [sym__colon_string] = STATE(1036),
    [sym__double_quote_string] = STATE(1035),
    [sym_string] = STATE(1069),
    [sym_multi_symbol] = STATE(898),
    [sym_multi_symbol_method] = STATE(1094),
    [sym__special_override_symbol] = STATE(1094),
    [sym_symbol] = ACTIONS(958),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(960),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [anon_sym_LBRACE] = ACTIONS(966),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(968),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [sym_nil] = ACTIONS(972),
    [anon_sym_true] = ACTIONS(974),
    [anon_sym_false] = ACTIONS(974),
    [sym_number] = ACTIONS(972),
    [sym_symbol_option] = ACTIONS(976),
    [anon_sym_POUND2] = ACTIONS(968),
    [anon_sym_QMARK_DOT2] = ACTIONS(968),
    [anon_sym_TILDE_EQ2] = ACTIONS(968),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(968),
    [anon_sym_DOT_DOT2] = ACTIONS(978),
    [anon_sym_DOT2] = ACTIONS(978),
    [sym__hashfn_reader_macro_char] = ACTIONS(980),
    [sym__quote_reader_macro_char] = ACTIONS(982),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(984),
    [sym__unquote_reader_macro_char] = ACTIONS(986),
  },
  [188] = {
    [sym_comment] = STATE(188),
    [sym__sexp] = STATE(659),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [189] = {
    [sym_comment] = STATE(189),
    [sym__sexp] = STATE(639),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [190] = {
    [sym_comment] = STATE(190),
    [sym__sexp] = STATE(1090),
    [sym_hashfn_reader_macro] = STATE(1093),
    [sym_quote_reader_macro] = STATE(1093),
    [sym_quasi_quote_reader_macro] = STATE(1093),
    [sym_unquote_reader_macro] = STATE(1093),
    [sym__reader_macro] = STATE(1094),
    [sym_list] = STATE(1094),
    [sym_case_form] = STATE(1092),
    [sym_match_form] = STATE(1092),
    [sym_case_try_form] = STATE(1092),
    [sym_match_try_form] = STATE(1092),
    [sym_if_form] = STATE(1092),
    [sym_fn_form] = STATE(1092),
    [sym_lambda_form] = STATE(1092),
    [sym_macro_form] = STATE(1092),
    [sym_hashfn_form] = STATE(1092),
    [sym_each_form] = STATE(1092),
    [sym_collect_form] = STATE(1092),
    [sym_icollect_form] = STATE(1092),
    [sym_accumulate_form] = STATE(1092),
    [sym_for_form] = STATE(1092),
    [sym_fcollect_form] = STATE(1092),
    [sym_faccumulate_form] = STATE(1092),
    [sym_local_form] = STATE(1092),
    [sym_var_form] = STATE(1092),
    [sym_global_form] = STATE(1092),
    [sym_set_form] = STATE(1092),
    [sym_let_form] = STATE(1092),
    [sym_import_macros_form] = STATE(1092),
    [sym_quote_form] = STATE(1092),
    [sym_unquote_form] = STATE(1092),
    [sym__form] = STATE(1094),
    [sym_sequence] = STATE(1094),
    [sym_table] = STATE(1094),
    [sym__literal] = STATE(1094),
    [sym_boolean] = STATE(1069),
    [sym__colon_string] = STATE(1036),
    [sym__double_quote_string] = STATE(1035),
    [sym_string] = STATE(1069),
    [sym_multi_symbol] = STATE(898),
    [sym_multi_symbol_method] = STATE(1094),
    [sym__special_override_symbol] = STATE(1094),
    [sym_symbol] = ACTIONS(958),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(960),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [anon_sym_LBRACE] = ACTIONS(966),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(968),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [sym_nil] = ACTIONS(972),
    [anon_sym_true] = ACTIONS(974),
    [anon_sym_false] = ACTIONS(974),
    [sym_number] = ACTIONS(972),
    [sym_symbol_option] = ACTIONS(976),
    [anon_sym_POUND2] = ACTIONS(968),
    [anon_sym_QMARK_DOT2] = ACTIONS(968),
    [anon_sym_TILDE_EQ2] = ACTIONS(968),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(968),
    [anon_sym_DOT_DOT2] = ACTIONS(978),
    [anon_sym_DOT2] = ACTIONS(978),
    [sym__hashfn_reader_macro_char] = ACTIONS(980),
    [sym__quote_reader_macro_char] = ACTIONS(982),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(984),
    [sym__unquote_reader_macro_char] = ACTIONS(986),
  },
  [191] = {
    [sym_comment] = STATE(191),
    [sym__sexp] = STATE(638),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [192] = {
    [sym_comment] = STATE(192),
    [sym__sexp] = STATE(1089),
    [sym_hashfn_reader_macro] = STATE(1093),
    [sym_quote_reader_macro] = STATE(1093),
    [sym_quasi_quote_reader_macro] = STATE(1093),
    [sym_unquote_reader_macro] = STATE(1093),
    [sym__reader_macro] = STATE(1094),
    [sym_list] = STATE(1094),
    [sym_case_form] = STATE(1092),
    [sym_match_form] = STATE(1092),
    [sym_case_try_form] = STATE(1092),
    [sym_match_try_form] = STATE(1092),
    [sym_if_form] = STATE(1092),
    [sym_fn_form] = STATE(1092),
    [sym_lambda_form] = STATE(1092),
    [sym_macro_form] = STATE(1092),
    [sym_hashfn_form] = STATE(1092),
    [sym_each_form] = STATE(1092),
    [sym_collect_form] = STATE(1092),
    [sym_icollect_form] = STATE(1092),
    [sym_accumulate_form] = STATE(1092),
    [sym_for_form] = STATE(1092),
    [sym_fcollect_form] = STATE(1092),
    [sym_faccumulate_form] = STATE(1092),
    [sym_local_form] = STATE(1092),
    [sym_var_form] = STATE(1092),
    [sym_global_form] = STATE(1092),
    [sym_set_form] = STATE(1092),
    [sym_let_form] = STATE(1092),
    [sym_import_macros_form] = STATE(1092),
    [sym_quote_form] = STATE(1092),
    [sym_unquote_form] = STATE(1092),
    [sym__form] = STATE(1094),
    [sym_sequence] = STATE(1094),
    [sym_table] = STATE(1094),
    [sym__literal] = STATE(1094),
    [sym_boolean] = STATE(1069),
    [sym__colon_string] = STATE(1036),
    [sym__double_quote_string] = STATE(1035),
    [sym_string] = STATE(1069),
    [sym_multi_symbol] = STATE(898),
    [sym_multi_symbol_method] = STATE(1094),
    [sym__special_override_symbol] = STATE(1094),
    [sym_symbol] = ACTIONS(958),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(960),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [anon_sym_LBRACE] = ACTIONS(966),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(968),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [sym_nil] = ACTIONS(972),
    [anon_sym_true] = ACTIONS(974),
    [anon_sym_false] = ACTIONS(974),
    [sym_number] = ACTIONS(972),
    [sym_symbol_option] = ACTIONS(976),
    [anon_sym_POUND2] = ACTIONS(968),
    [anon_sym_QMARK_DOT2] = ACTIONS(968),
    [anon_sym_TILDE_EQ2] = ACTIONS(968),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(968),
    [anon_sym_DOT_DOT2] = ACTIONS(978),
    [anon_sym_DOT2] = ACTIONS(978),
    [sym__hashfn_reader_macro_char] = ACTIONS(980),
    [sym__quote_reader_macro_char] = ACTIONS(982),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(984),
    [sym__unquote_reader_macro_char] = ACTIONS(986),
  },
  [193] = {
    [sym_comment] = STATE(193),
    [sym__sexp] = STATE(705),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [194] = {
    [sym_comment] = STATE(194),
    [sym__sexp] = STATE(435),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [195] = {
    [sym_comment] = STATE(195),
    [sym__sexp] = STATE(414),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [196] = {
    [sym_comment] = STATE(196),
    [sym__sexp] = STATE(404),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [197] = {
    [sym_comment] = STATE(197),
    [sym__sexp] = STATE(16),
    [sym_hashfn_reader_macro] = STATE(277),
    [sym_quote_reader_macro] = STATE(277),
    [sym_quasi_quote_reader_macro] = STATE(277),
    [sym_unquote_reader_macro] = STATE(277),
    [sym__reader_macro] = STATE(273),
    [sym_list] = STATE(273),
    [sym_case_form] = STATE(278),
    [sym_match_form] = STATE(278),
    [sym_case_try_form] = STATE(278),
    [sym_match_try_form] = STATE(278),
    [sym_if_form] = STATE(278),
    [sym_fn_form] = STATE(278),
    [sym_lambda_form] = STATE(278),
    [sym_macro_form] = STATE(278),
    [sym_hashfn_form] = STATE(278),
    [sym_each_form] = STATE(278),
    [sym_collect_form] = STATE(278),
    [sym_icollect_form] = STATE(278),
    [sym_accumulate_form] = STATE(278),
    [sym_for_form] = STATE(278),
    [sym_fcollect_form] = STATE(278),
    [sym_faccumulate_form] = STATE(278),
    [sym_local_form] = STATE(278),
    [sym_var_form] = STATE(278),
    [sym_global_form] = STATE(278),
    [sym_set_form] = STATE(278),
    [sym_let_form] = STATE(278),
    [sym_import_macros_form] = STATE(278),
    [sym_quote_form] = STATE(278),
    [sym_unquote_form] = STATE(278),
    [sym__form] = STATE(273),
    [sym_sequence] = STATE(273),
    [sym_table] = STATE(273),
    [sym__literal] = STATE(273),
    [sym_boolean] = STATE(297),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(297),
    [sym_multi_symbol] = STATE(261),
    [sym_multi_symbol_method] = STATE(273),
    [sym__special_override_symbol] = STATE(273),
    [sym_symbol] = ACTIONS(335),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_COLON] = ACTIONS(956),
    [anon_sym_LBRACE] = ACTIONS(345),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_nil] = ACTIONS(353),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(353),
    [sym_symbol_option] = ACTIONS(486),
    [anon_sym_POUND2] = ACTIONS(347),
    [anon_sym_QMARK_DOT2] = ACTIONS(347),
    [anon_sym_TILDE_EQ2] = ACTIONS(347),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(347),
    [anon_sym_DOT_DOT2] = ACTIONS(359),
    [anon_sym_DOT2] = ACTIONS(359),
    [sym__hashfn_reader_macro_char] = ACTIONS(361),
    [sym__quote_reader_macro_char] = ACTIONS(363),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(365),
    [sym__unquote_reader_macro_char] = ACTIONS(367),
  },
  [198] = {
    [sym_comment] = STATE(198),
    [sym__sexp] = STATE(1088),
    [sym_hashfn_reader_macro] = STATE(1093),
    [sym_quote_reader_macro] = STATE(1093),
    [sym_quasi_quote_reader_macro] = STATE(1093),
    [sym_unquote_reader_macro] = STATE(1093),
    [sym__reader_macro] = STATE(1094),
    [sym_list] = STATE(1094),
    [sym_case_form] = STATE(1092),
    [sym_match_form] = STATE(1092),
    [sym_case_try_form] = STATE(1092),
    [sym_match_try_form] = STATE(1092),
    [sym_if_form] = STATE(1092),
    [sym_fn_form] = STATE(1092),
    [sym_lambda_form] = STATE(1092),
    [sym_macro_form] = STATE(1092),
    [sym_hashfn_form] = STATE(1092),
    [sym_each_form] = STATE(1092),
    [sym_collect_form] = STATE(1092),
    [sym_icollect_form] = STATE(1092),
    [sym_accumulate_form] = STATE(1092),
    [sym_for_form] = STATE(1092),
    [sym_fcollect_form] = STATE(1092),
    [sym_faccumulate_form] = STATE(1092),
    [sym_local_form] = STATE(1092),
    [sym_var_form] = STATE(1092),
    [sym_global_form] = STATE(1092),
    [sym_set_form] = STATE(1092),
    [sym_let_form] = STATE(1092),
    [sym_import_macros_form] = STATE(1092),
    [sym_quote_form] = STATE(1092),
    [sym_unquote_form] = STATE(1092),
    [sym__form] = STATE(1094),
    [sym_sequence] = STATE(1094),
    [sym_table] = STATE(1094),
    [sym__literal] = STATE(1094),
    [sym_boolean] = STATE(1069),
    [sym__colon_string] = STATE(1036),
    [sym__double_quote_string] = STATE(1035),
    [sym_string] = STATE(1069),
    [sym_multi_symbol] = STATE(898),
    [sym_multi_symbol_method] = STATE(1094),
    [sym__special_override_symbol] = STATE(1094),
    [sym_symbol] = ACTIONS(958),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(960),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [anon_sym_LBRACE] = ACTIONS(966),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(968),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [sym_nil] = ACTIONS(972),
    [anon_sym_true] = ACTIONS(974),
    [anon_sym_false] = ACTIONS(974),
    [sym_number] = ACTIONS(972),
    [sym_symbol_option] = ACTIONS(976),
    [anon_sym_POUND2] = ACTIONS(968),
    [anon_sym_QMARK_DOT2] = ACTIONS(968),
    [anon_sym_TILDE_EQ2] = ACTIONS(968),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(968),
    [anon_sym_DOT_DOT2] = ACTIONS(978),
    [anon_sym_DOT2] = ACTIONS(978),
    [sym__hashfn_reader_macro_char] = ACTIONS(980),
    [sym__quote_reader_macro_char] = ACTIONS(982),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(984),
    [sym__unquote_reader_macro_char] = ACTIONS(986),
  },
  [199] = {
    [sym_comment] = STATE(199),
    [sym__sexp] = STATE(638),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(910),
    [sym__quote_reader_macro_char] = ACTIONS(912),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(914),
    [sym__unquote_reader_macro_char] = ACTIONS(916),
  },
  [200] = {
    [sym_comment] = STATE(200),
    [sym__sexp] = STATE(639),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(910),
    [sym__quote_reader_macro_char] = ACTIONS(912),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(914),
    [sym__unquote_reader_macro_char] = ACTIONS(916),
  },
  [201] = {
    [sym_comment] = STATE(201),
    [sym__sexp] = STATE(837),
    [sym_hashfn_reader_macro] = STATE(816),
    [sym_quote_reader_macro] = STATE(816),
    [sym_quasi_quote_reader_macro] = STATE(816),
    [sym_unquote_reader_macro] = STATE(816),
    [sym__reader_macro] = STATE(814),
    [sym_list] = STATE(814),
    [sym_case_form] = STATE(825),
    [sym_match_form] = STATE(825),
    [sym_case_try_form] = STATE(825),
    [sym_match_try_form] = STATE(825),
    [sym_if_form] = STATE(825),
    [sym_fn_form] = STATE(825),
    [sym_lambda_form] = STATE(825),
    [sym_macro_form] = STATE(825),
    [sym_hashfn_form] = STATE(825),
    [sym_each_form] = STATE(825),
    [sym_collect_form] = STATE(825),
    [sym_icollect_form] = STATE(825),
    [sym_accumulate_form] = STATE(825),
    [sym_for_form] = STATE(825),
    [sym_fcollect_form] = STATE(825),
    [sym_faccumulate_form] = STATE(825),
    [sym_local_form] = STATE(825),
    [sym_var_form] = STATE(825),
    [sym_global_form] = STATE(825),
    [sym_set_form] = STATE(825),
    [sym_let_form] = STATE(825),
    [sym_import_macros_form] = STATE(825),
    [sym_quote_form] = STATE(825),
    [sym_unquote_form] = STATE(825),
    [sym__form] = STATE(814),
    [sym_sequence] = STATE(814),
    [sym_table] = STATE(814),
    [sym__literal] = STATE(814),
    [sym_boolean] = STATE(802),
    [sym__colon_string] = STATE(780),
    [sym__double_quote_string] = STATE(824),
    [sym_string] = STATE(802),
    [sym_multi_symbol] = STATE(752),
    [sym_multi_symbol_method] = STATE(814),
    [sym__special_override_symbol] = STATE(814),
    [sym_symbol] = ACTIONS(369),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(373),
    [anon_sym_COLON] = ACTIONS(988),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [sym_nil] = ACTIONS(383),
    [anon_sym_true] = ACTIONS(385),
    [anon_sym_false] = ACTIONS(385),
    [sym_number] = ACTIONS(383),
    [sym_symbol_option] = ACTIONS(419),
    [anon_sym_POUND2] = ACTIONS(379),
    [anon_sym_QMARK_DOT2] = ACTIONS(379),
    [anon_sym_TILDE_EQ2] = ACTIONS(379),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(379),
    [anon_sym_DOT_DOT2] = ACTIONS(387),
    [anon_sym_DOT2] = ACTIONS(387),
    [sym__hashfn_reader_macro_char] = ACTIONS(389),
    [sym__quote_reader_macro_char] = ACTIONS(391),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(393),
    [sym__unquote_reader_macro_char] = ACTIONS(395),
  },
  [202] = {
    [sym_comment] = STATE(202),
    [sym__sexp] = STATE(659),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(910),
    [sym__quote_reader_macro_char] = ACTIONS(912),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(914),
    [sym__unquote_reader_macro_char] = ACTIONS(916),
  },
  [203] = {
    [sym_comment] = STATE(203),
    [sym__sexp] = STATE(661),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(892),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(910),
    [sym__quote_reader_macro_char] = ACTIONS(912),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(914),
    [sym__unquote_reader_macro_char] = ACTIONS(916),
  },
  [204] = {
    [sym_comment] = STATE(204),
    [sym__sexp] = STATE(463),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [205] = {
    [sym_comment] = STATE(205),
    [sym__sexp] = STATE(462),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [206] = {
    [sym_comment] = STATE(206),
    [sym__sexp] = STATE(1099),
    [sym_hashfn_reader_macro] = STATE(1093),
    [sym_quote_reader_macro] = STATE(1093),
    [sym_quasi_quote_reader_macro] = STATE(1093),
    [sym_unquote_reader_macro] = STATE(1093),
    [sym__reader_macro] = STATE(1094),
    [sym_list] = STATE(1094),
    [sym_case_form] = STATE(1092),
    [sym_match_form] = STATE(1092),
    [sym_case_try_form] = STATE(1092),
    [sym_match_try_form] = STATE(1092),
    [sym_if_form] = STATE(1092),
    [sym_fn_form] = STATE(1092),
    [sym_lambda_form] = STATE(1092),
    [sym_macro_form] = STATE(1092),
    [sym_hashfn_form] = STATE(1092),
    [sym_each_form] = STATE(1092),
    [sym_collect_form] = STATE(1092),
    [sym_icollect_form] = STATE(1092),
    [sym_accumulate_form] = STATE(1092),
    [sym_for_form] = STATE(1092),
    [sym_fcollect_form] = STATE(1092),
    [sym_faccumulate_form] = STATE(1092),
    [sym_local_form] = STATE(1092),
    [sym_var_form] = STATE(1092),
    [sym_global_form] = STATE(1092),
    [sym_set_form] = STATE(1092),
    [sym_let_form] = STATE(1092),
    [sym_import_macros_form] = STATE(1092),
    [sym_quote_form] = STATE(1092),
    [sym_unquote_form] = STATE(1092),
    [sym__form] = STATE(1094),
    [sym_sequence] = STATE(1094),
    [sym_table] = STATE(1094),
    [sym__literal] = STATE(1094),
    [sym_boolean] = STATE(1069),
    [sym__colon_string] = STATE(1036),
    [sym__double_quote_string] = STATE(1035),
    [sym_string] = STATE(1069),
    [sym_multi_symbol] = STATE(898),
    [sym_multi_symbol_method] = STATE(1094),
    [sym__special_override_symbol] = STATE(1094),
    [sym_symbol] = ACTIONS(958),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(960),
    [anon_sym_LBRACK] = ACTIONS(962),
    [anon_sym_COLON] = ACTIONS(964),
    [anon_sym_LBRACE] = ACTIONS(966),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(968),
    [anon_sym_DQUOTE] = ACTIONS(970),
    [sym_nil] = ACTIONS(972),
    [anon_sym_true] = ACTIONS(974),
    [anon_sym_false] = ACTIONS(974),
    [sym_number] = ACTIONS(972),
    [sym_symbol_option] = ACTIONS(976),
    [anon_sym_POUND2] = ACTIONS(968),
    [anon_sym_QMARK_DOT2] = ACTIONS(968),
    [anon_sym_TILDE_EQ2] = ACTIONS(968),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(968),
    [anon_sym_DOT_DOT2] = ACTIONS(978),
    [anon_sym_DOT2] = ACTIONS(978),
    [sym__hashfn_reader_macro_char] = ACTIONS(980),
    [sym__quote_reader_macro_char] = ACTIONS(982),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(984),
    [sym__unquote_reader_macro_char] = ACTIONS(986),
  },
  [207] = {
    [sym_comment] = STATE(207),
    [sym__sexp] = STATE(841),
    [sym_hashfn_reader_macro] = STATE(816),
    [sym_quote_reader_macro] = STATE(816),
    [sym_quasi_quote_reader_macro] = STATE(816),
    [sym_unquote_reader_macro] = STATE(816),
    [sym__reader_macro] = STATE(814),
    [sym_list] = STATE(814),
    [sym_case_form] = STATE(825),
    [sym_match_form] = STATE(825),
    [sym_case_try_form] = STATE(825),
    [sym_match_try_form] = STATE(825),
    [sym_if_form] = STATE(825),
    [sym_fn_form] = STATE(825),
    [sym_lambda_form] = STATE(825),
    [sym_macro_form] = STATE(825),
    [sym_hashfn_form] = STATE(825),
    [sym_each_form] = STATE(825),
    [sym_collect_form] = STATE(825),
    [sym_icollect_form] = STATE(825),
    [sym_accumulate_form] = STATE(825),
    [sym_for_form] = STATE(825),
    [sym_fcollect_form] = STATE(825),
    [sym_faccumulate_form] = STATE(825),
    [sym_local_form] = STATE(825),
    [sym_var_form] = STATE(825),
    [sym_global_form] = STATE(825),
    [sym_set_form] = STATE(825),
    [sym_let_form] = STATE(825),
    [sym_import_macros_form] = STATE(825),
    [sym_quote_form] = STATE(825),
    [sym_unquote_form] = STATE(825),
    [sym__form] = STATE(814),
    [sym_sequence] = STATE(814),
    [sym_table] = STATE(814),
    [sym__literal] = STATE(814),
    [sym_boolean] = STATE(802),
    [sym__colon_string] = STATE(780),
    [sym__double_quote_string] = STATE(824),
    [sym_string] = STATE(802),
    [sym_multi_symbol] = STATE(752),
    [sym_multi_symbol_method] = STATE(814),
    [sym__special_override_symbol] = STATE(814),
    [sym_symbol] = ACTIONS(369),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(373),
    [anon_sym_COLON] = ACTIONS(988),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [sym_nil] = ACTIONS(383),
    [anon_sym_true] = ACTIONS(385),
    [anon_sym_false] = ACTIONS(385),
    [sym_number] = ACTIONS(383),
    [sym_symbol_option] = ACTIONS(419),
    [anon_sym_POUND2] = ACTIONS(379),
    [anon_sym_QMARK_DOT2] = ACTIONS(379),
    [anon_sym_TILDE_EQ2] = ACTIONS(379),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(379),
    [anon_sym_DOT_DOT2] = ACTIONS(387),
    [anon_sym_DOT2] = ACTIONS(387),
    [sym__hashfn_reader_macro_char] = ACTIONS(389),
    [sym__quote_reader_macro_char] = ACTIONS(391),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(393),
    [sym__unquote_reader_macro_char] = ACTIONS(395),
  },
  [208] = {
    [sym_comment] = STATE(208),
    [sym__sexp] = STATE(847),
    [sym_hashfn_reader_macro] = STATE(816),
    [sym_quote_reader_macro] = STATE(816),
    [sym_quasi_quote_reader_macro] = STATE(816),
    [sym_unquote_reader_macro] = STATE(816),
    [sym__reader_macro] = STATE(814),
    [sym_list] = STATE(814),
    [sym_case_form] = STATE(825),
    [sym_match_form] = STATE(825),
    [sym_case_try_form] = STATE(825),
    [sym_match_try_form] = STATE(825),
    [sym_if_form] = STATE(825),
    [sym_fn_form] = STATE(825),
    [sym_lambda_form] = STATE(825),
    [sym_macro_form] = STATE(825),
    [sym_hashfn_form] = STATE(825),
    [sym_each_form] = STATE(825),
    [sym_collect_form] = STATE(825),
    [sym_icollect_form] = STATE(825),
    [sym_accumulate_form] = STATE(825),
    [sym_for_form] = STATE(825),
    [sym_fcollect_form] = STATE(825),
    [sym_faccumulate_form] = STATE(825),
    [sym_local_form] = STATE(825),
    [sym_var_form] = STATE(825),
    [sym_global_form] = STATE(825),
    [sym_set_form] = STATE(825),
    [sym_let_form] = STATE(825),
    [sym_import_macros_form] = STATE(825),
    [sym_quote_form] = STATE(825),
    [sym_unquote_form] = STATE(825),
    [sym__form] = STATE(814),
    [sym_sequence] = STATE(814),
    [sym_table] = STATE(814),
    [sym__literal] = STATE(814),
    [sym_boolean] = STATE(802),
    [sym__colon_string] = STATE(780),
    [sym__double_quote_string] = STATE(824),
    [sym_string] = STATE(802),
    [sym_multi_symbol] = STATE(752),
    [sym_multi_symbol_method] = STATE(814),
    [sym__special_override_symbol] = STATE(814),
    [sym_symbol] = ACTIONS(369),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(373),
    [anon_sym_COLON] = ACTIONS(988),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [sym_nil] = ACTIONS(383),
    [anon_sym_true] = ACTIONS(385),
    [anon_sym_false] = ACTIONS(385),
    [sym_number] = ACTIONS(383),
    [sym_symbol_option] = ACTIONS(419),
    [anon_sym_POUND2] = ACTIONS(379),
    [anon_sym_QMARK_DOT2] = ACTIONS(379),
    [anon_sym_TILDE_EQ2] = ACTIONS(379),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(379),
    [anon_sym_DOT_DOT2] = ACTIONS(387),
    [anon_sym_DOT2] = ACTIONS(387),
    [sym__hashfn_reader_macro_char] = ACTIONS(389),
    [sym__quote_reader_macro_char] = ACTIONS(391),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(393),
    [sym__unquote_reader_macro_char] = ACTIONS(395),
  },
  [209] = {
    [sym_comment] = STATE(209),
    [sym__sexp] = STATE(429),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [210] = {
    [sym_comment] = STATE(210),
    [sym__sexp] = STATE(428),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [211] = {
    [sym_comment] = STATE(211),
    [sym__sexp] = STATE(419),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [212] = {
    [sym_comment] = STATE(212),
    [sym__sexp] = STATE(443),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [213] = {
    [sym_comment] = STATE(213),
    [sym__sexp] = STATE(1025),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [214] = {
    [sym_comment] = STATE(214),
    [sym__sexp] = STATE(1018),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [215] = {
    [sym_comment] = STATE(215),
    [sym__sexp] = STATE(949),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [216] = {
    [sym_comment] = STATE(216),
    [sym__sexp] = STATE(219),
    [sym_hashfn_reader_macro] = STATE(388),
    [sym_quote_reader_macro] = STATE(388),
    [sym_quasi_quote_reader_macro] = STATE(388),
    [sym_unquote_reader_macro] = STATE(388),
    [sym__reader_macro] = STATE(386),
    [sym_list] = STATE(386),
    [sym_case_form] = STATE(390),
    [sym_match_form] = STATE(390),
    [sym_case_try_form] = STATE(390),
    [sym_match_try_form] = STATE(390),
    [sym_if_form] = STATE(390),
    [sym_fn_form] = STATE(390),
    [sym_lambda_form] = STATE(390),
    [sym_macro_form] = STATE(390),
    [sym_hashfn_form] = STATE(390),
    [sym_each_form] = STATE(390),
    [sym_collect_form] = STATE(390),
    [sym_icollect_form] = STATE(390),
    [sym_accumulate_form] = STATE(390),
    [sym_for_form] = STATE(390),
    [sym_fcollect_form] = STATE(390),
    [sym_faccumulate_form] = STATE(390),
    [sym_local_form] = STATE(390),
    [sym_var_form] = STATE(390),
    [sym_global_form] = STATE(390),
    [sym_set_form] = STATE(390),
    [sym_let_form] = STATE(390),
    [sym_import_macros_form] = STATE(390),
    [sym_quote_form] = STATE(390),
    [sym_unquote_form] = STATE(390),
    [sym__form] = STATE(386),
    [sym_sequence] = STATE(386),
    [sym_table] = STATE(386),
    [sym__literal] = STATE(386),
    [sym_boolean] = STATE(336),
    [sym__colon_string] = STATE(391),
    [sym__double_quote_string] = STATE(393),
    [sym_string] = STATE(336),
    [sym_multi_symbol] = STATE(264),
    [sym_multi_symbol_method] = STATE(386),
    [sym__special_override_symbol] = STATE(386),
    [sym_symbol] = ACTIONS(7),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_COLON] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(17),
    [anon_sym_DQUOTE] = ACTIONS(19),
    [sym_nil] = ACTIONS(21),
    [anon_sym_true] = ACTIONS(23),
    [anon_sym_false] = ACTIONS(23),
    [sym_number] = ACTIONS(21),
    [sym_symbol_option] = ACTIONS(25),
    [anon_sym_POUND2] = ACTIONS(17),
    [anon_sym_QMARK_DOT2] = ACTIONS(17),
    [anon_sym_TILDE_EQ2] = ACTIONS(17),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(17),
    [anon_sym_DOT_DOT2] = ACTIONS(27),
    [anon_sym_DOT2] = ACTIONS(27),
    [sym__hashfn_reader_macro_char] = ACTIONS(29),
    [sym__quote_reader_macro_char] = ACTIONS(31),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(33),
    [sym__unquote_reader_macro_char] = ACTIONS(35),
  },
  [217] = {
    [sym_comment] = STATE(217),
    [sym__sexp] = STATE(1017),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [218] = {
    [sym_comment] = STATE(218),
    [sym__sexp] = STATE(1012),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [219] = {
    [sym_comment] = STATE(219),
    [sym__sexp] = STATE(17),
    [sym_hashfn_reader_macro] = STATE(277),
    [sym_quote_reader_macro] = STATE(277),
    [sym_quasi_quote_reader_macro] = STATE(277),
    [sym_unquote_reader_macro] = STATE(277),
    [sym__reader_macro] = STATE(273),
    [sym_list] = STATE(273),
    [sym_case_form] = STATE(278),
    [sym_match_form] = STATE(278),
    [sym_case_try_form] = STATE(278),
    [sym_match_try_form] = STATE(278),
    [sym_if_form] = STATE(278),
    [sym_fn_form] = STATE(278),
    [sym_lambda_form] = STATE(278),
    [sym_macro_form] = STATE(278),
    [sym_hashfn_form] = STATE(278),
    [sym_each_form] = STATE(278),
    [sym_collect_form] = STATE(278),
    [sym_icollect_form] = STATE(278),
    [sym_accumulate_form] = STATE(278),
    [sym_for_form] = STATE(278),
    [sym_fcollect_form] = STATE(278),
    [sym_faccumulate_form] = STATE(278),
    [sym_local_form] = STATE(278),
    [sym_var_form] = STATE(278),
    [sym_global_form] = STATE(278),
    [sym_set_form] = STATE(278),
    [sym_let_form] = STATE(278),
    [sym_import_macros_form] = STATE(278),
    [sym_quote_form] = STATE(278),
    [sym_unquote_form] = STATE(278),
    [sym__form] = STATE(273),
    [sym_sequence] = STATE(273),
    [sym_table] = STATE(273),
    [sym__literal] = STATE(273),
    [sym_boolean] = STATE(297),
    [sym__colon_string] = STATE(384),
    [sym__double_quote_string] = STATE(385),
    [sym_string] = STATE(297),
    [sym_multi_symbol] = STATE(261),
    [sym_multi_symbol_method] = STATE(273),
    [sym__special_override_symbol] = STATE(273),
    [sym_symbol] = ACTIONS(335),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(337),
    [anon_sym_LBRACK] = ACTIONS(341),
    [anon_sym_COLON] = ACTIONS(956),
    [anon_sym_LBRACE] = ACTIONS(345),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(347),
    [anon_sym_DQUOTE] = ACTIONS(349),
    [sym_nil] = ACTIONS(353),
    [anon_sym_true] = ACTIONS(355),
    [anon_sym_false] = ACTIONS(355),
    [sym_number] = ACTIONS(353),
    [sym_symbol_option] = ACTIONS(486),
    [anon_sym_POUND2] = ACTIONS(347),
    [anon_sym_QMARK_DOT2] = ACTIONS(347),
    [anon_sym_TILDE_EQ2] = ACTIONS(347),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(347),
    [anon_sym_DOT_DOT2] = ACTIONS(359),
    [anon_sym_DOT2] = ACTIONS(359),
    [sym__hashfn_reader_macro_char] = ACTIONS(361),
    [sym__quote_reader_macro_char] = ACTIONS(363),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(365),
    [sym__unquote_reader_macro_char] = ACTIONS(367),
  },
  [220] = {
    [sym_comment] = STATE(220),
    [sym__sexp] = STATE(451),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [221] = {
    [sym_comment] = STATE(221),
    [sym__sexp] = STATE(947),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [222] = {
    [sym_comment] = STATE(222),
    [sym__sexp] = STATE(450),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [223] = {
    [sym_comment] = STATE(223),
    [sym__sexp] = STATE(960),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [224] = {
    [sym_comment] = STATE(224),
    [sym__sexp] = STATE(430),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [225] = {
    [sym_comment] = STATE(225),
    [sym__sexp] = STATE(830),
    [sym_hashfn_reader_macro] = STATE(816),
    [sym_quote_reader_macro] = STATE(816),
    [sym_quasi_quote_reader_macro] = STATE(816),
    [sym_unquote_reader_macro] = STATE(816),
    [sym__reader_macro] = STATE(814),
    [sym_list] = STATE(814),
    [sym_case_form] = STATE(825),
    [sym_match_form] = STATE(825),
    [sym_case_try_form] = STATE(825),
    [sym_match_try_form] = STATE(825),
    [sym_if_form] = STATE(825),
    [sym_fn_form] = STATE(825),
    [sym_lambda_form] = STATE(825),
    [sym_macro_form] = STATE(825),
    [sym_hashfn_form] = STATE(825),
    [sym_each_form] = STATE(825),
    [sym_collect_form] = STATE(825),
    [sym_icollect_form] = STATE(825),
    [sym_accumulate_form] = STATE(825),
    [sym_for_form] = STATE(825),
    [sym_fcollect_form] = STATE(825),
    [sym_faccumulate_form] = STATE(825),
    [sym_local_form] = STATE(825),
    [sym_var_form] = STATE(825),
    [sym_global_form] = STATE(825),
    [sym_set_form] = STATE(825),
    [sym_let_form] = STATE(825),
    [sym_import_macros_form] = STATE(825),
    [sym_quote_form] = STATE(825),
    [sym_unquote_form] = STATE(825),
    [sym__form] = STATE(814),
    [sym_sequence] = STATE(814),
    [sym_table] = STATE(814),
    [sym__literal] = STATE(814),
    [sym_boolean] = STATE(802),
    [sym__colon_string] = STATE(780),
    [sym__double_quote_string] = STATE(824),
    [sym_string] = STATE(802),
    [sym_multi_symbol] = STATE(752),
    [sym_multi_symbol_method] = STATE(814),
    [sym__special_override_symbol] = STATE(814),
    [sym_symbol] = ACTIONS(369),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(373),
    [anon_sym_COLON] = ACTIONS(988),
    [anon_sym_LBRACE] = ACTIONS(377),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(379),
    [anon_sym_DQUOTE] = ACTIONS(381),
    [sym_nil] = ACTIONS(383),
    [anon_sym_true] = ACTIONS(385),
    [anon_sym_false] = ACTIONS(385),
    [sym_number] = ACTIONS(383),
    [sym_symbol_option] = ACTIONS(419),
    [anon_sym_POUND2] = ACTIONS(379),
    [anon_sym_QMARK_DOT2] = ACTIONS(379),
    [anon_sym_TILDE_EQ2] = ACTIONS(379),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(379),
    [anon_sym_DOT_DOT2] = ACTIONS(387),
    [anon_sym_DOT2] = ACTIONS(387),
    [sym__hashfn_reader_macro_char] = ACTIONS(389),
    [sym__quote_reader_macro_char] = ACTIONS(391),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(393),
    [sym__unquote_reader_macro_char] = ACTIONS(395),
  },
  [226] = {
    [sym_comment] = STATE(226),
    [sym__sexp] = STATE(432),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [227] = {
    [sym_comment] = STATE(227),
    [sym__sexp] = STATE(961),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [228] = {
    [sym_comment] = STATE(228),
    [sym__sexp] = STATE(661),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [229] = {
    [sym_comment] = STATE(229),
    [sym__sexp] = STATE(659),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [230] = {
    [sym_comment] = STATE(230),
    [sym__sexp] = STATE(639),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [231] = {
    [sym_comment] = STATE(231),
    [sym__sexp] = STATE(638),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [232] = {
    [sym_comment] = STATE(232),
    [sym__sexp] = STATE(448),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [233] = {
    [sym_comment] = STATE(233),
    [sym__sexp] = STATE(426),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(918),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(922),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(924),
    [sym__quote_reader_macro_char] = ACTIONS(926),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(928),
    [sym__unquote_reader_macro_char] = ACTIONS(930),
  },
  [234] = {
    [sym_comment] = STATE(234),
    [sym__sexp] = STATE(984),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [235] = {
    [sym_comment] = STATE(235),
    [sym__sexp] = STATE(989),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [236] = {
    [sym_comment] = STATE(236),
    [sym__sexp] = STATE(959),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [237] = {
    [sym_comment] = STATE(237),
    [sym__sexp] = STATE(990),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [238] = {
    [sym_comment] = STATE(238),
    [sym__sexp] = STATE(1000),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
  [239] = {
    [sym_comment] = STATE(239),
    [sym__sexp] = STATE(977),
    [sym_hashfn_reader_macro] = STATE(615),
    [sym_quote_reader_macro] = STATE(615),
    [sym_quasi_quote_reader_macro] = STATE(615),
    [sym_unquote_reader_macro] = STATE(615),
    [sym__reader_macro] = STATE(609),
    [sym_list] = STATE(609),
    [sym_case_form] = STATE(625),
    [sym_match_form] = STATE(625),
    [sym_case_try_form] = STATE(625),
    [sym_match_try_form] = STATE(625),
    [sym_if_form] = STATE(625),
    [sym_fn_form] = STATE(625),
    [sym_lambda_form] = STATE(625),
    [sym_macro_form] = STATE(625),
    [sym_hashfn_form] = STATE(625),
    [sym_each_form] = STATE(625),
    [sym_collect_form] = STATE(625),
    [sym_icollect_form] = STATE(625),
    [sym_accumulate_form] = STATE(625),
    [sym_for_form] = STATE(625),
    [sym_fcollect_form] = STATE(625),
    [sym_faccumulate_form] = STATE(625),
    [sym_local_form] = STATE(625),
    [sym_var_form] = STATE(625),
    [sym_global_form] = STATE(625),
    [sym_set_form] = STATE(625),
    [sym_let_form] = STATE(625),
    [sym_import_macros_form] = STATE(625),
    [sym_quote_form] = STATE(625),
    [sym_unquote_form] = STATE(625),
    [sym__form] = STATE(609),
    [sym_sequence] = STATE(609),
    [sym_table] = STATE(609),
    [sym__literal] = STATE(609),
    [sym_boolean] = STATE(629),
    [sym__colon_string] = STATE(626),
    [sym__double_quote_string] = STATE(630),
    [sym_string] = STATE(629),
    [sym_multi_symbol] = STATE(588),
    [sym_multi_symbol_method] = STATE(609),
    [sym__special_override_symbol] = STATE(609),
    [sym_symbol] = ACTIONS(886),
    [aux_sym_comment_token1] = ACTIONS(3),
    [anon_sym_LPAREN] = ACTIONS(888),
    [anon_sym_LBRACK] = ACTIONS(890),
    [anon_sym_COLON] = ACTIONS(942),
    [anon_sym_LBRACE] = ACTIONS(894),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(898),
    [anon_sym_DQUOTE] = ACTIONS(900),
    [sym_nil] = ACTIONS(902),
    [anon_sym_true] = ACTIONS(904),
    [anon_sym_false] = ACTIONS(904),
    [sym_number] = ACTIONS(902),
    [sym_symbol_option] = ACTIONS(906),
    [anon_sym_POUND2] = ACTIONS(898),
    [anon_sym_QMARK_DOT2] = ACTIONS(898),
    [anon_sym_TILDE_EQ2] = ACTIONS(898),
    [anon_sym_DOLLAR_DOT_DOT_DOT2] = ACTIONS(898),
    [anon_sym_DOT_DOT2] = ACTIONS(908),
    [anon_sym_DOT2] = ACTIONS(908),
    [sym__hashfn_reader_macro_char] = ACTIONS(944),
    [sym__quote_reader_macro_char] = ACTIONS(946),
    [sym__quasi_quote_reader_macro_char] = ACTIONS(948),
    [sym__unquote_reader_macro_char] = ACTIONS(950),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(996), 1,
      anon_sym_TILDE_EQ,
    ACTIONS(998), 1,
      sym___colon_string_start_mark,
    STATE(240), 1,
      sym_comment,
    ACTIONS(994), 11,
      anon_sym_POUND,
      anon_sym_QMARK_DOT,
      anon_sym_COLON2,
      anon_sym_DOLLAR_DOT_DOT_DOT,
      anon_sym_DOT_DOT_DOT2,
      anon_sym_DOT_DOT,
      anon_sym_DOT,
      anon_sym_nil,
      anon_sym_true2,
      anon_sym_false2,
      aux_sym__colon_string_token1,
    ACTIONS(990), 12,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
    ACTIONS(992), 14,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol_option,
      sym_symbol,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
  [56] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1002), 1,
      anon_sym_TILDE_EQ,
    ACTIONS(1004), 1,
      sym___colon_string_start_mark,
    STATE(241), 1,
      sym_comment,
    ACTIONS(990), 10,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1000), 11,
      anon_sym_POUND,
      anon_sym_QMARK_DOT,
      anon_sym_COLON2,
      anon_sym_DOLLAR_DOT_DOT_DOT,
      anon_sym_DOT_DOT_DOT2,
      anon_sym_DOT_DOT,
      anon_sym_DOT,
      anon_sym_nil,
      anon_sym_true2,
      anon_sym_false2,
      aux_sym__colon_string_token1,
    ACTIONS(992), 16,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol_option,
      sym_symbol,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
  [112] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(996), 1,
      anon_sym_TILDE_EQ,
    ACTIONS(1006), 1,
      anon_sym_fnl_SLASHdocstring,
    ACTIONS(1008), 1,
      anon_sym_fnl_SLASHarglist,
    ACTIONS(1010), 1,
      sym___colon_string_start_mark,
    STATE(242), 1,
      sym_comment,
    ACTIONS(990), 9,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
    ACTIONS(994), 11,
      anon_sym_POUND,
      anon_sym_QMARK_DOT,
      anon_sym_COLON2,
      anon_sym_DOLLAR_DOT_DOT_DOT,
      anon_sym_DOT_DOT_DOT2,
      anon_sym_DOT_DOT,
      anon_sym_DOT,
      anon_sym_nil,
      anon_sym_true2,
      anon_sym_false2,
      aux_sym__colon_string_token1,
    ACTIONS(992), 14,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol_option,
      sym_symbol,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
  [171] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1014), 1,
      anon_sym_TILDE_EQ,
    ACTIONS(1016), 1,
      sym___colon_string_start_mark,
    STATE(243), 1,
      sym_comment,
    ACTIONS(990), 9,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1012), 11,
      anon_sym_POUND,
      anon_sym_QMARK_DOT,
      anon_sym_COLON2,
      anon_sym_DOLLAR_DOT_DOT_DOT,
      anon_sym_DOT_DOT_DOT2,
      anon_sym_DOT_DOT,
      anon_sym_DOT,
      anon_sym_nil,
      anon_sym_true2,
      anon_sym_false2,
      aux_sym__colon_string_token1,
    ACTIONS(992), 14,
      anon_sym_COLON,
      anon_sym_DOT_DOT_DOT,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol_option,
      sym_symbol,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
  [224] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(996), 1,
      anon_sym_TILDE_EQ,
    ACTIONS(998), 1,
      sym___colon_string_start_mark,
    STATE(244), 1,
      sym_comment,
    ACTIONS(1020), 2,
      anon_sym_RBRACE,
      anon_sym_DQUOTE,
    ACTIONS(1018), 3,
      anon_sym_COLON,
      sym_symbol_option,
      sym_symbol,
    ACTIONS(990), 7,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
    ACTIONS(992), 11,
      anon_sym_DOT_DOT_DOT,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(994), 11,
      anon_sym_POUND,
      anon_sym_QMARK_DOT,
      anon_sym_COLON2,
      anon_sym_DOLLAR_DOT_DOT_DOT,
      anon_sym_DOT_DOT_DOT2,
      anon_sym_DOT_DOT,
      anon_sym_DOT,
      anon_sym_nil,
      anon_sym_true2,
      anon_sym_false2,
      aux_sym__colon_string_token1,
  [281] = 19,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1022), 1,
      sym_symbol,
    ACTIONS(1025), 1,
      anon_sym_LPAREN,
    ACTIONS(1028), 1,
      anon_sym_LBRACK,
    ACTIONS(1031), 1,
      anon_sym_COLON,
    ACTIONS(1034), 1,
      anon_sym_LBRACE,
    ACTIONS(1039), 1,
      anon_sym_DQUOTE,
    ACTIONS(1042), 1,
      sym_nil,
    ACTIONS(1048), 1,
      sym_number,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(527), 1,
      sym__binding,
    ACTIONS(1045), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(1051), 2,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    STATE(245), 2,
      sym_comment,
      aux_sym__iter_body_repeat1,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
    ACTIONS(1037), 10,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_DOT_DOT_DOT,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [354] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1057), 1,
      anon_sym_DOT,
    STATE(246), 1,
      sym_comment,
    STATE(248), 1,
      aux_sym_multi_symbol_repeat1,
    ACTIONS(1055), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1053), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLON2,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [398] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1063), 1,
      anon_sym_DOT,
    STATE(247), 2,
      sym_comment,
      aux_sym_multi_symbol_repeat1,
    ACTIONS(1059), 9,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      anon_sym_COLON2,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1061), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [440] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1066), 1,
      anon_sym_DOT,
    STATE(248), 2,
      sym_comment,
      aux_sym_multi_symbol_repeat1,
    ACTIONS(1059), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1061), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLON2,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [482] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1073), 1,
      sym_symbol_option,
    STATE(31), 1,
      sym__iter_option_lhs,
    STATE(249), 1,
      sym_comment,
    STATE(253), 1,
      aux_sym__iter_body_repeat2,
    STATE(322), 1,
      sym__iter_option_legacy,
    STATE(422), 1,
      sym_iter_option,
    ACTIONS(351), 2,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
    ACTIONS(1069), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1071), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [534] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1075), 1,
      anon_sym_DOT,
    STATE(247), 1,
      aux_sym_multi_symbol_repeat1,
    STATE(250), 1,
      sym_comment,
    ACTIONS(1055), 9,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      anon_sym_COLON2,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1053), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [578] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1073), 1,
      sym_symbol_option,
    STATE(31), 1,
      sym__iter_option_lhs,
    STATE(251), 1,
      sym_comment,
    STATE(253), 1,
      aux_sym__iter_body_repeat2,
    STATE(322), 1,
      sym__iter_option_legacy,
    STATE(422), 1,
      sym_iter_option,
    ACTIONS(351), 2,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
    ACTIONS(1077), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1079), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [630] = 10,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1073), 1,
      sym_symbol_option,
    STATE(31), 1,
      sym__iter_option_lhs,
    STATE(249), 1,
      aux_sym__iter_body_repeat2,
    STATE(252), 1,
      sym_comment,
    STATE(322), 1,
      sym__iter_option_legacy,
    STATE(422), 1,
      sym_iter_option,
    ACTIONS(351), 2,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
    ACTIONS(1081), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1083), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [682] = 9,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1092), 1,
      sym_symbol_option,
    STATE(31), 1,
      sym__iter_option_lhs,
    STATE(322), 1,
      sym__iter_option_legacy,
    STATE(422), 1,
      sym_iter_option,
    ACTIONS(1089), 2,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
    STATE(253), 2,
      sym_comment,
      aux_sym__iter_body_repeat2,
    ACTIONS(1085), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1087), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [732] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1075), 1,
      anon_sym_DOT,
    ACTIONS(1099), 1,
      anon_sym_COLON2,
    STATE(250), 1,
      aux_sym_multi_symbol_repeat1,
    STATE(254), 1,
      sym_comment,
    ACTIONS(1095), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1097), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [778] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1057), 1,
      anon_sym_DOT,
    ACTIONS(1101), 1,
      anon_sym_COLON2,
    STATE(246), 1,
      aux_sym_multi_symbol_repeat1,
    STATE(255), 1,
      sym_comment,
    ACTIONS(1095), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1097), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [824] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(256), 1,
      sym_comment,
    ACTIONS(1103), 10,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      anon_sym_COLON2,
      anon_sym_DOT,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1105), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [863] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(257), 1,
      sym_comment,
    ACTIONS(1103), 9,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DOT,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1105), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLON2,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [902] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(258), 1,
      sym_comment,
    ACTIONS(1107), 10,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      anon_sym_COLON2,
      anon_sym_DOT,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1109), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [941] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(259), 1,
      sym_comment,
    ACTIONS(1107), 9,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DOT,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1109), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLON2,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [980] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1115), 1,
      anon_sym_COLON2,
    ACTIONS(1117), 1,
      anon_sym_DOT,
    STATE(260), 1,
      sym_comment,
    STATE(723), 1,
      aux_sym_multi_symbol_repeat1,
    ACTIONS(1097), 4,
      anon_sym_RBRACK,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
    ACTIONS(1111), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1113), 13,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1027] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1119), 1,
      anon_sym_COLON2,
    STATE(261), 1,
      sym_comment,
    ACTIONS(1095), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1097), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1067] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1125), 1,
      sym___colon_string_end_mark,
    STATE(262), 1,
      sym_comment,
    ACTIONS(1123), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1121), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1107] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1127), 1,
      sym___colon_string_end_mark,
    STATE(263), 1,
      sym_comment,
    ACTIONS(1123), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1121), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1147] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1129), 1,
      anon_sym_COLON2,
    STATE(264), 1,
      sym_comment,
    ACTIONS(1095), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1097), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1187] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1135), 1,
      sym___colon_string_end_mark,
    STATE(265), 1,
      sym_comment,
    ACTIONS(1133), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1131), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1227] = 8,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1057), 1,
      anon_sym_DOT,
    ACTIONS(1101), 1,
      anon_sym_COLON2,
    ACTIONS(1111), 1,
      anon_sym_AMP,
    STATE(246), 1,
      aux_sym_multi_symbol_repeat1,
    STATE(266), 1,
      sym_comment,
    ACTIONS(1095), 9,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol_option,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1097), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1273] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1137), 1,
      sym___colon_string_end_mark,
    STATE(267), 1,
      sym_comment,
    ACTIONS(1133), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1131), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1313] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(268), 1,
      sym_comment,
    ACTIONS(1141), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1139), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1350] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(269), 1,
      sym_comment,
    ACTIONS(1143), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1145), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1387] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(270), 1,
      sym_comment,
    ACTIONS(1149), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1147), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1424] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(271), 1,
      sym_comment,
    ACTIONS(992), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(990), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1461] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(272), 1,
      sym_comment,
    ACTIONS(1151), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1153), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1498] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(273), 1,
      sym_comment,
    ACTIONS(1095), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1097), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1535] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(274), 1,
      sym_comment,
    ACTIONS(1157), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1155), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1572] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(275), 1,
      sym_comment,
    ACTIONS(1161), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1159), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1609] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(276), 1,
      sym_comment,
    ACTIONS(1165), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1163), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1646] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(277), 1,
      sym_comment,
    ACTIONS(1167), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1169), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1683] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(278), 1,
      sym_comment,
    ACTIONS(1171), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1173), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1720] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(279), 1,
      sym_comment,
    ACTIONS(1175), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1177), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1757] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(280), 1,
      sym_comment,
    ACTIONS(1181), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1179), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1794] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(281), 1,
      sym_comment,
    ACTIONS(1183), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1185), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1831] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(282), 1,
      sym_comment,
    ACTIONS(1189), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1187), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1868] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(283), 1,
      sym_comment,
    ACTIONS(1191), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1193), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1905] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(284), 1,
      sym_comment,
    ACTIONS(1197), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1195), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1942] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(285), 1,
      sym_comment,
    ACTIONS(1199), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1201), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [1979] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(286), 1,
      sym_comment,
    ACTIONS(1205), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1203), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2016] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(287), 1,
      sym_comment,
    ACTIONS(1207), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1209), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2053] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(288), 1,
      sym_comment,
    ACTIONS(1211), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1213), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2090] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(289), 1,
      sym_comment,
    ACTIONS(1215), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1217), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2127] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(290), 1,
      sym_comment,
    ACTIONS(1219), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1221), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2164] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(291), 1,
      sym_comment,
    ACTIONS(1223), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1225), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2201] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(292), 1,
      sym_comment,
    ACTIONS(1227), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1229), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2238] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(293), 1,
      sym_comment,
    ACTIONS(1231), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1233), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2275] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(294), 1,
      sym_comment,
    ACTIONS(1223), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1225), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2312] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(295), 1,
      sym_comment,
    ACTIONS(1237), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1235), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2349] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(296), 1,
      sym_comment,
    ACTIONS(1241), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1239), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2386] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(297), 1,
      sym_comment,
    ACTIONS(1243), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(427), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2423] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(298), 1,
      sym_comment,
    ACTIONS(1245), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1247), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2460] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(299), 1,
      sym_comment,
    ACTIONS(992), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(990), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2497] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(300), 1,
      sym_comment,
    ACTIONS(1249), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1251), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2534] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(301), 1,
      sym_comment,
    ACTIONS(1255), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1253), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2571] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(302), 1,
      sym_comment,
    ACTIONS(1259), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1257), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2608] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(303), 1,
      sym_comment,
    ACTIONS(1261), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1263), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2645] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(304), 1,
      sym_comment,
    ACTIONS(1265), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1267), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2682] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(305), 1,
      sym_comment,
    ACTIONS(1271), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1269), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2719] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(306), 1,
      sym_comment,
    ACTIONS(1273), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1275), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2756] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(307), 1,
      sym_comment,
    ACTIONS(1277), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1279), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2793] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(308), 1,
      sym_comment,
    ACTIONS(1227), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1229), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2830] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(309), 1,
      sym_comment,
    ACTIONS(1283), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1281), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2867] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(310), 1,
      sym_comment,
    ACTIONS(1103), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1105), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2904] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(311), 1,
      sym_comment,
    ACTIONS(1231), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1233), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2941] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(312), 1,
      sym_comment,
    ACTIONS(1245), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1247), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [2978] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(313), 1,
      sym_comment,
    ACTIONS(1285), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1287), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3015] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(314), 1,
      sym_comment,
    ACTIONS(1289), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1291), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3052] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(315), 1,
      sym_comment,
    ACTIONS(1293), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1295), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3089] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(316), 1,
      sym_comment,
    ACTIONS(1297), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1299), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3126] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(317), 1,
      sym_comment,
    ACTIONS(1301), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1303), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3163] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(318), 1,
      sym_comment,
    ACTIONS(1305), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1307), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3200] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(319), 1,
      sym_comment,
    ACTIONS(1249), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1251), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3237] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(320), 1,
      sym_comment,
    ACTIONS(1309), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1311), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3274] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(321), 1,
      sym_comment,
    ACTIONS(1313), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1315), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3311] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(322), 1,
      sym_comment,
    ACTIONS(1317), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1319), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3348] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(323), 1,
      sym_comment,
    ACTIONS(1321), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1323), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3385] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(324), 1,
      sym_comment,
    ACTIONS(1261), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1263), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3422] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(325), 1,
      sym_comment,
    ACTIONS(1325), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1327), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3459] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(326), 1,
      sym_comment,
    ACTIONS(1265), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1267), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3496] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(327), 1,
      sym_comment,
    ACTIONS(1317), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1319), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3533] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(328), 1,
      sym_comment,
    ACTIONS(1329), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1331), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3570] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(329), 1,
      sym_comment,
    ACTIONS(1333), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1335), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3607] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(330), 1,
      sym_comment,
    ACTIONS(1337), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1339), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3644] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(331), 1,
      sym_comment,
    ACTIONS(1341), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1343), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3681] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(332), 1,
      sym_comment,
    ACTIONS(1345), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1347), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3718] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(333), 1,
      sym_comment,
    ACTIONS(1273), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1275), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3755] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(334), 1,
      sym_comment,
    ACTIONS(1349), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1351), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3792] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(335), 1,
      sym_comment,
    ACTIONS(1277), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1279), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3829] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(336), 1,
      sym_comment,
    ACTIONS(1243), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(427), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3866] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(337), 1,
      sym_comment,
    ACTIONS(1219), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1221), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3903] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(338), 1,
      sym_comment,
    ACTIONS(1353), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1355), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3940] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(339), 1,
      sym_comment,
    ACTIONS(1357), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1359), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [3977] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(340), 1,
      sym_comment,
    ACTIONS(1361), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1363), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4014] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(341), 1,
      sym_comment,
    ACTIONS(1365), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1367), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4051] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1057), 1,
      anon_sym_DOT,
    ACTIONS(1101), 1,
      anon_sym_COLON2,
    STATE(246), 1,
      aux_sym_multi_symbol_repeat1,
    STATE(342), 1,
      sym_comment,
    ACTIONS(1095), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1097), 15,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4094] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(343), 1,
      sym_comment,
    ACTIONS(1285), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1287), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4131] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(344), 1,
      sym_comment,
    ACTIONS(1371), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1369), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4168] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(345), 1,
      sym_comment,
    ACTIONS(1151), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1153), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4205] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(346), 1,
      sym_comment,
    ACTIONS(1215), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1217), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4242] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(347), 1,
      sym_comment,
    ACTIONS(1289), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1291), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4279] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(348), 1,
      sym_comment,
    ACTIONS(1373), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1375), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4316] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(349), 1,
      sym_comment,
    ACTIONS(1377), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1379), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4353] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(350), 1,
      sym_comment,
    ACTIONS(1381), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1383), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4390] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(351), 1,
      sym_comment,
    ACTIONS(1149), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1147), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4427] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(352), 1,
      sym_comment,
    ACTIONS(1293), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1295), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4464] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(353), 1,
      sym_comment,
    ACTIONS(1161), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1159), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4501] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(354), 1,
      sym_comment,
    ACTIONS(1297), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1299), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4538] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(355), 1,
      sym_comment,
    ACTIONS(1301), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1303), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4575] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(356), 1,
      sym_comment,
    ACTIONS(1305), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1307), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4612] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(357), 1,
      sym_comment,
    ACTIONS(1309), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1311), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4649] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(358), 1,
      sym_comment,
    ACTIONS(1321), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1323), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4686] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(359), 1,
      sym_comment,
    ACTIONS(1157), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1155), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4723] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(360), 1,
      sym_comment,
    ACTIONS(1325), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1327), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4760] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(361), 1,
      sym_comment,
    ACTIONS(1329), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1331), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4797] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(362), 1,
      sym_comment,
    ACTIONS(1333), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1335), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4834] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(363), 1,
      sym_comment,
    ACTIONS(1165), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1163), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4871] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(364), 1,
      sym_comment,
    ACTIONS(1141), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1139), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4908] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(365), 1,
      sym_comment,
    ACTIONS(1181), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1179), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4945] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(366), 1,
      sym_comment,
    ACTIONS(1189), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1187), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [4982] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(367), 1,
      sym_comment,
    ACTIONS(1197), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1195), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5019] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(368), 1,
      sym_comment,
    ACTIONS(1211), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1213), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5056] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(369), 1,
      sym_comment,
    ACTIONS(1337), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1339), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5093] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(370), 1,
      sym_comment,
    ACTIONS(1341), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1343), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5130] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(371), 1,
      sym_comment,
    ACTIONS(1345), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1347), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5167] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(372), 1,
      sym_comment,
    ACTIONS(1349), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1351), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5204] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(373), 1,
      sym_comment,
    ACTIONS(1205), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1203), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5241] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(374), 1,
      sym_comment,
    ACTIONS(1237), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1235), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5278] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(375), 1,
      sym_comment,
    ACTIONS(1241), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1239), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5315] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(376), 1,
      sym_comment,
    ACTIONS(1255), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1253), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5352] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(377), 1,
      sym_comment,
    ACTIONS(1259), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1257), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5389] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(378), 1,
      sym_comment,
    ACTIONS(1353), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1355), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5426] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(379), 1,
      sym_comment,
    ACTIONS(1357), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1359), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5463] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(380), 1,
      sym_comment,
    ACTIONS(1361), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1363), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5500] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(381), 1,
      sym_comment,
    ACTIONS(1387), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1385), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5537] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(382), 1,
      sym_comment,
    ACTIONS(1365), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1367), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5574] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(383), 1,
      sym_comment,
    ACTIONS(1373), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1375), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5611] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(384), 1,
      sym_comment,
    ACTIONS(1389), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1391), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5648] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(385), 1,
      sym_comment,
    ACTIONS(1393), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1395), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5685] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(386), 1,
      sym_comment,
    ACTIONS(1095), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1097), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5722] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(387), 1,
      sym_comment,
    ACTIONS(1381), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1383), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5759] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(388), 1,
      sym_comment,
    ACTIONS(1167), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1169), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5796] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(389), 1,
      sym_comment,
    ACTIONS(1371), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1369), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5833] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(390), 1,
      sym_comment,
    ACTIONS(1171), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1173), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5870] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(391), 1,
      sym_comment,
    ACTIONS(1389), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1391), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5907] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(392), 1,
      sym_comment,
    ACTIONS(1103), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1105), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5944] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(393), 1,
      sym_comment,
    ACTIONS(1393), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1395), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [5981] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(394), 1,
      sym_comment,
    ACTIONS(1377), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1379), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6018] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(395), 1,
      sym_comment,
    ACTIONS(1387), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1385), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6055] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(396), 1,
      sym_comment,
    ACTIONS(1207), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1209), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6092] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(397), 1,
      sym_comment,
    ACTIONS(1199), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1201), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6129] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(398), 1,
      sym_comment,
    ACTIONS(1191), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1193), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6166] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(399), 1,
      sym_comment,
    ACTIONS(1183), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1185), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6203] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(400), 1,
      sym_comment,
    ACTIONS(1271), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1269), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6240] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(401), 1,
      sym_comment,
    ACTIONS(1143), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1145), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6277] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(402), 1,
      sym_comment,
    ACTIONS(1283), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1281), 18,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6314] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(403), 1,
      sym_comment,
    ACTIONS(1175), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1177), 19,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6351] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1401), 1,
      anon_sym_RPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(404), 1,
      sym_comment,
    STATE(405), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(976), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [6423] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1413), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(405), 1,
      sym_comment,
    STATE(466), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(1082), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [6495] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(406), 1,
      sym_comment,
    ACTIONS(427), 3,
      anon_sym_RBRACK,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
    ACTIONS(1415), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1417), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6533] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(407), 1,
      sym_comment,
    ACTIONS(427), 3,
      anon_sym_RBRACK,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
    ACTIONS(1419), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1421), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6571] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(408), 1,
      sym_comment,
    ACTIONS(427), 3,
      anon_sym_RBRACK,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
    ACTIONS(1423), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1425), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6609] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1427), 1,
      sym___colon_string_end_mark,
    STATE(409), 1,
      sym_comment,
    ACTIONS(1123), 9,
      anon_sym_AMP,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol_option,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1121), 15,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6647] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(410), 1,
      sym_comment,
    ACTIONS(427), 3,
      anon_sym_RBRACK,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
    ACTIONS(1429), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1431), 14,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6685] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1433), 1,
      sym___colon_string_end_mark,
    STATE(411), 1,
      sym_comment,
    ACTIONS(1133), 9,
      anon_sym_AMP,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol_option,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1131), 15,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6723] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1435), 1,
      anon_sym_DOT,
    STATE(412), 1,
      sym_comment,
    STATE(415), 1,
      aux_sym_multi_symbol_repeat1,
    ACTIONS(1055), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1053), 16,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6763] = 6,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1435), 1,
      anon_sym_DOT,
    STATE(412), 1,
      aux_sym_multi_symbol_repeat1,
    STATE(413), 1,
      sym_comment,
    ACTIONS(1111), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1113), 16,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6803] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1437), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(414), 1,
      sym_comment,
    STATE(425), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(966), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [6875] = 5,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1439), 1,
      anon_sym_DOT,
    STATE(415), 2,
      sym_comment,
      aux_sym_multi_symbol_repeat1,
    ACTIONS(1059), 7,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1061), 16,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_COLON,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [6913] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1442), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(416), 1,
      sym_comment,
    STATE(466), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(1021), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [6985] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1444), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(417), 1,
      sym_comment,
    STATE(466), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(941), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [7057] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1446), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(418), 1,
      sym_comment,
    STATE(423), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(1016), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [7129] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1448), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(419), 1,
      sym_comment,
    STATE(424), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(1015), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [7201] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(420), 1,
      sym_comment,
    ACTIONS(1450), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1452), 17,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [7237] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1454), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(421), 1,
      sym_comment,
    STATE(466), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(978), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [7309] = 4,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    STATE(422), 1,
      sym_comment,
    ACTIONS(1456), 8,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
      anon_sym_DOT_DOT2,
      anon_sym_DOT2,
    ACTIONS(1458), 17,
      sym__hashfn_reader_macro_char,
      sym__quote_reader_macro_char,
      sym__quasi_quote_reader_macro_char,
      sym__unquote_reader_macro_char,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_DOT_DOT_DOT,
      anon_sym_DQUOTE,
      anon_sym_COLONuntil,
      anon_sym_COLONinto,
      sym_symbol_option,
      anon_sym_POUND2,
      anon_sym_QMARK_DOT2,
      anon_sym_TILDE_EQ2,
      anon_sym_DOLLAR_DOT_DOT_DOT2,
  [7345] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1460), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(423), 1,
      sym_comment,
    STATE(466), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(1011), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [7417] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1462), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(424), 1,
      sym_comment,
    STATE(466), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(1010), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [7489] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1464), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(425), 1,
      sym_comment,
    STATE(466), 1,
      aux_sym_case_catch_repeat1,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(979), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [7561] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      anon_sym_LBRACK,
    ACTIONS(1405), 1,
      anon_sym_COLON,
    ACTIONS(1407), 1,
      anon_sym_LBRACE,
    ACTIONS(1409), 1,
      sym_nil,
    ACTIONS(1411), 1,
      sym_number,
    ACTIONS(1466), 1,
      anon_sym_RPAREN,
    STATE(157), 1,
      sym__case_lhs,
    STATE(391), 1,
      sym__colon_string,
    STATE(393), 1,
      sym__double_quote_string,
    STATE(416), 1,
      aux_sym_case_catch_repeat1,
    STATE(426), 1,
      sym_comment,
    STATE(470), 1,
      sym_string,
    STATE(473), 1,
      sym_boolean,
    STATE(695), 1,
      sym_case_pair,
    STATE(950), 1,
      sym_case_catch,
    ACTIONS(23), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(520), 2,
      sym__binding,
      sym_case_guard,
    STATE(474), 4,
      sym_list_binding,
      sym_sequence_binding,
      sym_table_binding,
      sym__literal_binding,
  [7633] = 7,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(1470), 1,
      anon_sym_TILDE_EQ,
    ACTIONS(1472), 1,
      sym___colon_string_start_mark,
    STATE(427), 1,
      sym_comment,
    ACTIONS(990), 6,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
    ACTIONS(992), 6,
      anon_sym_COLON,
      sym_nil,
      anon_sym_true,
      anon_sym_false,
      sym_number,
      sym_symbol,
    ACTIONS(1468), 11,
      anon_sym_POUND,
      anon_sym_QMARK_DOT,
      anon_sym_COLON2,
      anon_sym_DOLLAR_DOT_DOT_DOT,
      anon_sym_DOT_DOT_DOT2,
      anon_sym_DOT_DOT,
      anon_sym_DOT,
      anon_sym_nil,
      anon_sym_true2,
      anon_sym_false2,
      aux_sym__colon_string_token1,
  [7675] = 22,
    ACTIONS(3), 1,
      aux_sym_comment_token1,
    ACTIONS(19), 1,
      anon_sym_DQUOTE,
    ACTIONS(1397), 1,
      sym_symbol,
    ACTIONS(1399), 1,
      anon_sym_LPAREN,
    ACTIONS(1403), 1,
      a