#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 621
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 156
#define ALIAS_COUNT 17
#define TOKEN_COUNT 71
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 1
#define MAX_ALIAS_SEQUENCE_LENGTH 13
#define PRODUCTION_ID_COUNT 82

enum {
  sym_identifier = 1,
  sym_unique_id = 2,
  anon_sym_SEMI = 3,
  anon_sym_using = 4,
  anon_sym_EQ = 5,
  anon_sym_import = 6,
  anon_sym_DOT = 7,
  anon_sym_DOLLARimport = 8,
  anon_sym_LPAREN = 9,
  anon_sym_RPAREN = 10,
  anon_sym_namespace = 11,
  anon_sym_DOLLAR = 12,
  aux_sym_top_level_annotation_body_token1 = 13,
  anon_sym_COMMA = 14,
  anon_sym_annotation = 15,
  anon_sym_COLON = 16,
  anon_sym_STAR = 17,
  anon_sym_const = 18,
  anon_sym_enumerant = 19,
  anon_sym_field = 20,
  anon_sym_file = 21,
  anon_sym_method = 22,
  anon_sym_param = 23,
  anon_sym_enum = 24,
  anon_sym_group = 25,
  anon_sym_interface = 26,
  anon_sym_struct = 27,
  anon_sym_union = 28,
  anon_sym_LBRACK = 29,
  anon_sym_RBRACK = 30,
  anon_sym_LBRACE = 31,
  anon_sym_RBRACE = 32,
  anon_sym_extends = 33,
  anon_sym_DASH_GT = 34,
  anon_sym_AnyPointer = 35,
  anon_sym_Bool = 36,
  anon_sym_Int8 = 37,
  anon_sym_Int16 = 38,
  anon_sym_Int32 = 39,
  anon_sym_Int64 = 40,
  anon_sym_UInt8 = 41,
  anon_sym_UInt16 = 42,
  anon_sym_UInt32 = 43,
  anon_sym_UInt64 = 44,
  anon_sym_Float32 = 45,
  anon_sym_Float64 = 46,
  anon_sym_Text = 47,
  anon_sym_Data = 48,
  anon_sym_Void = 49,
  anon_sym_List = 50,
  sym_number = 51,
  sym__normal_version = 52,
  aux_sym__inline_version_token1 = 53,
  sym_float = 54,
  sym_true = 55,
  sym_false = 56,
  anon_sym_0x = 57,
  aux_sym_data_token1 = 58,
  sym_void = 59,
  anon_sym_embed = 60,
  anon_sym_DQUOTE = 61,
  anon_sym_SQUOTE = 62,
  anon_sym_BQUOTE = 63,
  sym_unescaped_double_string_fragment = 64,
  sym_unescaped_single_string_fragment = 65,
  sym_unescaped_block_string_fragment = 66,
  aux_sym__escape_sequence_token1 = 67,
  sym_escape_sequence = 68,
  sym__identifier_no_period = 69,
  sym_comment = 70,
  sym_message = 71,
  sym_statement = 72,
  sym_using_directive = 73,
  sym_replace_using = 74,
  sym_import_using = 75,
  sym_import = 76,
  sym_top_level_annotation = 77,
  sym_top_level_annotation_body = 78,
  sym_annotation = 79,
  sym_annotation_targets = 80,
  sym_annotation_target = 81,
  sym_annotation_literal = 82,
  sym_annotation_array = 83,
  sym__annotation_array_def = 84,
  sym_definition = 85,
  sym_struct = 86,
  sym_nested_struct = 87,
  sym_enum = 88,
  sym_nested_enum = 89,
  sym_enum_field = 90,
  sym_group = 91,
  sym_field = 92,
  sym_union = 93,
  sym_nested_union = 94,
  sym__unnamed_union = 95,
  sym__named_union = 96,
  sym_union_field = 97,
  sym_interface = 98,
  sym_method = 99,
  sym_method_parameters = 100,
  sym_parameters = 101,
  sym_parameter = 102,
  sym_return_type = 103,
  sym_named_return_types = 104,
  sym_unnamed_return_type = 105,
  sym_named_return_type = 106,
  sym_field_type = 107,
  sym_primitive_type = 108,
  sym_list_type = 109,
  sym_custom_type = 110,
  sym_const = 111,
  sym_const_value = 112,
  sym__same_scope_const_value = 113,
  sym_field_version = 114,
  sym__inline_version = 115,
  sym_boolean = 116,
  sym_data = 117,
  sym_const_list = 118,
  sym_struct_shorthand = 119,
  sym__internal_const_identifier = 120,
  sym_embedded_file = 121,
  sym_generics = 122,
  sym_implicit_generics = 123,
  sym_generic_parameters = 124,
  sym_string = 125,
  sym_concatenated_string = 126,
  sym_block_text = 127,
  sym__escape_sequence = 128,
  sym__annotation_definition_identifier = 129,
  sym__method_identifier = 130,
  aux_sym_message_repeat1 = 131,
  aux_sym_import_using_repeat1 = 132,
  aux_sym_top_level_annotation_body_repeat1 = 133,
  aux_sym_annotation_repeat1 = 134,
  aux_sym_annotation_targets_repeat1 = 135,
  aux_sym__annotation_call_repeat1 = 136,
  aux_sym_annotation_array_repeat1 = 137,
  aux_sym__annotation_array_def_repeat1 = 138,
  aux_sym__annotation_array_def_repeat2 = 139,
  aux_sym_struct_repeat1 = 140,
  aux_sym_enum_repeat1 = 141,
  aux_sym_group_repeat1 = 142,
  aux_sym__unnamed_union_repeat1 = 143,
  aux_sym_interface_repeat1 = 144,
  aux_sym_parameters_repeat1 = 145,
  aux_sym_named_return_type_repeat1 = 146,
  aux_sym_custom_type_repeat1 = 147,
  aux_sym_struct_shorthand_repeat1 = 148,
  aux_sym__internal_const_identifier_repeat1 = 149,
  aux_sym_generic_parameters_repeat1 = 150,
  aux_sym_string_repeat1 = 151,
  aux_sym_string_repeat2 = 152,
  aux_sym_concatenated_string_repeat1 = 153,
  aux_sym_block_text_repeat1 = 154,
  aux_sym_block_text_repeat2 = 155,
  alias_sym_annotation_identifier = 156,
  alias_sym_attribute = 157,
  alias_sym_enum_identifier = 158,
  alias_sym_enum_member = 159,
  alias_sym_extend_type = 160,
  alias_sym_field_identifier = 161,
  alias_sym_generic_identifier = 162,
  alias_sym_implicit_generic_parameters = 163,
  alias_sym_import_path = 164,
  alias_sym_local_const = 165,
  alias_sym_method_identifier = 166,
  alias_sym_namespace = 167,
  alias_sym_param_identifier = 168,
  alias_sym_property = 169,
  alias_sym_return_identifier = 170,
  alias_sym_type_definition = 171,
  alias_sym_type_identifier = 172,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "annotation_definition_identifier",
  [sym_unique_id] = "unique_id",
  [anon_sym_SEMI] = ";",
  [anon_sym_using] = "using",
  [anon_sym_EQ] = "=",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_DOLLARimport] = "$import",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_namespace] = "namespace",
  [anon_sym_DOLLAR] = "$",
  [aux_sym_top_level_annotation_body_token1] = "_type_identifier",
  [anon_sym_COMMA] = ",",
  [anon_sym_annotation] = "annotation",
  [anon_sym_COLON] = ":",
  [anon_sym_STAR] = "*",
  [anon_sym_const] = "const",
  [anon_sym_enumerant] = "enumerant",
  [anon_sym_field] = "field",
  [anon_sym_file] = "file",
  [anon_sym_method] = "method",
  [anon_sym_param] = "param",
  [anon_sym_enum] = "enum",
  [anon_sym_group] = "group",
  [anon_sym_interface] = "interface",
  [anon_sym_struct] = "struct",
  [anon_sym_union] = "union",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_extends] = "extends",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_AnyPointer] = "AnyPointer",
  [anon_sym_Bool] = "Bool",
  [anon_sym_Int8] = "Int8",
  [anon_sym_Int16] = "Int16",
  [anon_sym_Int32] = "Int32",
  [anon_sym_Int64] = "Int64",
  [anon_sym_UInt8] = "UInt8",
  [anon_sym_UInt16] = "UInt16",
  [anon_sym_UInt32] = "UInt32",
  [anon_sym_UInt64] = "UInt64",
  [anon_sym_Float32] = "Float32",
  [anon_sym_Float64] = "Float64",
  [anon_sym_Text] = "Text",
  [anon_sym_Data] = "Data",
  [anon_sym_Void] = "Void",
  [anon_sym_List] = "List",
  [sym_number] = "number",
  [sym__normal_version] = "_normal_version",
  [aux_sym__inline_version_token1] = "inline_field",
  [sym_float] = "float",
  [sym_true] = "true",
  [sym_false] = "false",
  [anon_sym_0x] = "data_hex",
  [aux_sym_data_token1] = "data_string",
  [sym_void] = "void",
  [anon_sym_embed] = "embed",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_BQUOTE] = "`",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_unescaped_single_string_fragment] = "string_fragment",
  [sym_unescaped_block_string_fragment] = "string_fragment",
  [aux_sym__escape_sequence_token1] = "_escape_sequence_token1",
  [sym_escape_sequence] = "escape_sequence",
  [sym__identifier_no_period] = "const_identifier",
  [sym_comment] = "comment",
  [sym_message] = "message",
  [sym_statement] = "statement",
  [sym_using_directive] = "using_directive",
  [sym_replace_using] = "replace_using",
  [sym_import_using] = "import_using",
  [sym_import] = "import",
  [sym_top_level_annotation] = "top_level_annotation",
  [sym_top_level_annotation_body] = "top_level_annotation_body",
  [sym_annotation] = "annotation",
  [sym_annotation_targets] = "annotation_targets",
  [sym_annotation_target] = "annotation_target",
  [sym_annotation_literal] = "annotation_literal",
  [sym_annotation_array] = "annotation_array",
  [sym__annotation_array_def] = "_annotation_array_def",
  [sym_definition] = "definition",
  [sym_struct] = "struct",
  [sym_nested_struct] = "nested_struct",
  [sym_enum] = "enum",
  [sym_nested_enum] = "nested_enum",
  [sym_enum_field] = "enum_field",
  [sym_group] = "group",
  [sym_field] = "field",
  [sym_union] = "union",
  [sym_nested_union] = "nested_union",
  [sym__unnamed_union] = "_unnamed_union",
  [sym__named_union] = "_named_union",
  [sym_union_field] = "union_field",
  [sym_interface] = "interface",
  [sym_method] = "method",
  [sym_method_parameters] = "method_parameters",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym_return_type] = "return_type",
  [sym_named_return_types] = "named_return_types",
  [sym_unnamed_return_type] = "unnamed_return_type",
  [sym_named_return_type] = "named_return_type",
  [sym_field_type] = "field_type",
  [sym_primitive_type] = "primitive_type",
  [sym_list_type] = "list_type",
  [sym_custom_type] = "custom_type",
  [sym_const] = "const",
  [sym_const_value] = "const_value",
  [sym__same_scope_const_value] = "_same_scope_const_value",
  [sym_field_version] = "field_version",
  [sym__inline_version] = "_inline_version",
  [sym_boolean] = "boolean",
  [sym_data] = "data",
  [sym_const_list] = "const_list",
  [sym_struct_shorthand] = "struct_shorthand",
  [sym__internal_const_identifier] = "_internal_const_identifier",
  [sym_embedded_file] = "embedded_file",
  [sym_generics] = "generics",
  [sym_implicit_generics] = "implicit_generics",
  [sym_generic_parameters] = "generic_parameters",
  [sym_string] = "string",
  [sym_concatenated_string] = "concatenated_string",
  [sym_block_text] = "block_text",
  [sym__escape_sequence] = "_escape_sequence",
  [sym__annotation_definition_identifier] = "_annotation_definition_identifier",
  [sym__method_identifier] = "_method_identifier",
  [aux_sym_message_repeat1] = "message_repeat1",
  [aux_sym_import_using_repeat1] = "import_using_repeat1",
  [aux_sym_top_level_annotation_body_repeat1] = "top_level_annotation_body_repeat1",
  [aux_sym_annotation_repeat1] = "annotation_repeat1",
  [aux_sym_annotation_targets_repeat1] = "annotation_targets_repeat1",
  [aux_sym__annotation_call_repeat1] = "_annotation_call_repeat1",
  [aux_sym_annotation_array_repeat1] = "annotation_array_repeat1",
  [aux_sym__annotation_array_def_repeat1] = "_annotation_array_def_repeat1",
  [aux_sym__annotation_array_def_repeat2] = "_annotation_array_def_repeat2",
  [aux_sym_struct_repeat1] = "struct_repeat1",
  [aux_sym_enum_repeat1] = "enum_repeat1",
  [aux_sym_group_repeat1] = "group_repeat1",
  [aux_sym__unnamed_union_repeat1] = "_unnamed_union_repeat1",
  [aux_sym_interface_repeat1] = "interface_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_named_return_type_repeat1] = "named_return_type_repeat1",
  [aux_sym_custom_type_repeat1] = "custom_type_repeat1",
  [aux_sym_struct_shorthand_repeat1] = "struct_shorthand_repeat1",
  [aux_sym__internal_const_identifier_repeat1] = "_internal_const_identifier_repeat1",
  [aux_sym_generic_parameters_repeat1] = "generic_parameters_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_concatenated_string_repeat1] = "concatenated_string_repeat1",
  [aux_sym_block_text_repeat1] = "block_text_repeat1",
  [aux_sym_block_text_repeat2] = "block_text_repeat2",
  [alias_sym_annotation_identifier] = "annotation_identifier",
  [alias_sym_attribute] = "attribute",
  [alias_sym_enum_identifier] = "enum_identifier",
  [alias_sym_enum_member] = "enum_member",
  [alias_sym_extend_type] = "extend_type",
  [alias_sym_field_identifier] = "field_identifier",
  [alias_sym_generic_identifier] = "generic_identifier",
  [alias_sym_implicit_generic_parameters] = "implicit_generic_parameters",
  [alias_sym_import_path] = "import_path",
  [alias_sym_local_const] = "local_const",
  [alias_sym_method_identifier] = "method_identifier",
  [alias_sym_namespace] = "namespace",
  [alias_sym_param_identifier] = "param_identifier",
  [alias_sym_property] = "property",
  [alias_sym_return_identifier] = "return_identifier",
  [alias_sym_type_definition] = "type_definition",
  [alias_sym_type_identifier] = "type_identifier",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [sym_unique_id] = sym_unique_id,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_DOLLARimport] = anon_sym_DOLLARimport,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_namespace] = anon_sym_namespace,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_top_level_annotation_body_token1] = aux_sym_top_level_annotation_body_token1,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_annotation] = anon_sym_annotation,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_enumerant] = anon_sym_enumerant,
  [anon_sym_field] = anon_sym_field,
  [anon_sym_file] = anon_sym_file,
  [anon_sym_method] = anon_sym_method,
  [anon_sym_param] = anon_sym_param,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_group] = anon_sym_group,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_AnyPointer] = anon_sym_AnyPointer,
  [anon_sym_Bool] = anon_sym_Bool,
  [anon_sym_Int8] = anon_sym_Int8,
  [anon_sym_Int16] = anon_sym_Int16,
  [anon_sym_Int32] = anon_sym_Int32,
  [anon_sym_Int64] = anon_sym_Int64,
  [anon_sym_UInt8] = anon_sym_UInt8,
  [anon_sym_UInt16] = anon_sym_UInt16,
  [anon_sym_UInt32] = anon_sym_UInt32,
  [anon_sym_UInt64] = anon_sym_UInt64,
  [anon_sym_Float32] = anon_sym_Float32,
  [anon_sym_Float64] = anon_sym_Float64,
  [anon_sym_Text] = anon_sym_Text,
  [anon_sym_Data] = anon_sym_Data,
  [anon_sym_Void] = anon_sym_Void,
  [anon_sym_List] = anon_sym_List,
  [sym_number] = sym_number,
  [sym__normal_version] = sym__normal_version,
  [aux_sym__inline_version_token1] = aux_sym__inline_version_token1,
  [sym_float] = sym_float,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [anon_sym_0x] = anon_sym_0x,
  [aux_sym_data_token1] = aux_sym_data_token1,
  [sym_void] = sym_void,
  [anon_sym_embed] = anon_sym_embed,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_single_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_unescaped_block_string_fragment] = sym_unescaped_double_string_fragment,
  [aux_sym__escape_sequence_token1] = aux_sym__escape_sequence_token1,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__identifier_no_period] = sym__identifier_no_period,
  [sym_comment] = sym_comment,
  [sym_message] = sym_message,
  [sym_statement] = sym_statement,
  [sym_using_directive] = sym_using_directive,
  [sym_replace_using] = sym_replace_using,
  [sym_import_using] = sym_import_using,
  [sym_import] = sym_import,
  [sym_top_level_annotation] = sym_top_level_annotation,
  [sym_top_level_annotation_body] = sym_top_level_annotation_body,
  [sym_annotation] = sym_annotation,
  [sym_annotation_targets] = sym_annotation_targets,
  [sym_annotation_target] = sym_annotation_target,
  [sym_annotation_literal] = sym_annotation_literal,
  [sym_annotation_array] = sym_annotation_array,
  [sym__annotation_array_def] = sym__annotation_array_def,
  [sym_definition] = sym_definition,
  [sym_struct] = sym_struct,
  [sym_nested_struct] = sym_nested_struct,
  [sym_enum] = sym_enum,
  [sym_nested_enum] = sym_nested_enum,
  [sym_enum_field] = sym_enum_field,
  [sym_group] = sym_group,
  [sym_field] = sym_field,
  [sym_union] = sym_union,
  [sym_nested_union] = sym_nested_union,
  [sym__unnamed_union] = sym__unnamed_union,
  [sym__named_union] = sym__named_union,
  [sym_union_field] = sym_union_field,
  [sym_interface] = sym_interface,
  [sym_method] = sym_method,
  [sym_method_parameters] = sym_method_parameters,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym_return_type] = sym_return_type,
  [sym_named_return_types] = sym_named_return_types,
  [sym_unnamed_return_type] = sym_unnamed_return_type,
  [sym_named_return_type] = sym_named_return_type,
  [sym_field_type] = sym_field_type,
  [sym_primitive_type] = sym_primitive_type,
  [sym_list_type] = sym_list_type,
  [sym_custom_type] = sym_custom_type,
  [sym_const] = sym_const,
  [sym_const_value] = sym_const_value,
  [sym__same_scope_const_value] = sym__same_scope_const_value,
  [sym_field_version] = sym_field_version,
  [sym__inline_version] = sym__inline_version,
  [sym_boolean] = sym_boolean,
  [sym_data] = sym_data,
  [sym_const_list] = sym_const_list,
  [sym_struct_shorthand] = sym_struct_shorthand,
  [sym__internal_const_identifier] = sym__internal_const_identifier,
  [sym_embedded_file] = sym_embedded_file,
  [sym_generics] = sym_generics,
  [sym_implicit_generics] = sym_implicit_generics,
  [sym_generic_parameters] = sym_generic_parameters,
  [sym_string] = sym_string,
  [sym_concatenated_string] = sym_concatenated_string,
  [sym_block_text] = sym_block_text,
  [sym__escape_sequence] = sym__escape_sequence,
  [sym__annotation_definition_identifier] = sym__annotation_definition_identifier,
  [sym__method_identifier] = sym__method_identifier,
  [aux_sym_message_repeat1] = aux_sym_message_repeat1,
  [aux_sym_import_using_repeat1] = aux_sym_import_using_repeat1,
  [aux_sym_top_level_annotation_body_repeat1] = aux_sym_top_level_annotation_body_repeat1,
  [aux_sym_annotation_repeat1] = aux_sym_annotation_repeat1,
  [aux_sym_annotation_targets_repeat1] = aux_sym_annotation_targets_repeat1,
  [aux_sym__annotation_call_repeat1] = aux_sym__annotation_call_repeat1,
  [aux_sym_annotation_array_repeat1] = aux_sym_annotation_array_repeat1,
  [aux_sym__annotation_array_def_repeat1] = aux_sym__annotation_array_def_repeat1,
  [aux_sym__annotation_array_def_repeat2] = aux_sym__annotation_array_def_repeat2,
  [aux_sym_struct_repeat1] = aux_sym_struct_repeat1,
  [aux_sym_enum_repeat1] = aux_sym_enum_repeat1,
  [aux_sym_group_repeat1] = aux_sym_group_repeat1,
  [aux_sym__unnamed_union_repeat1] = aux_sym__unnamed_union_repeat1,
  [aux_sym_interface_repeat1] = aux_sym_interface_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_named_return_type_repeat1] = aux_sym_named_return_type_repeat1,
  [aux_sym_custom_type_repeat1] = aux_sym_custom_type_repeat1,
  [aux_sym_struct_shorthand_repeat1] = aux_sym_struct_shorthand_repeat1,
  [aux_sym__internal_const_identifier_repeat1] = aux_sym__internal_const_identifier_repeat1,
  [aux_sym_generic_parameters_repeat1] = aux_sym_generic_parameters_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_concatenated_string_repeat1] = aux_sym_concatenated_string_repeat1,
  [aux_sym_block_text_repeat1] = aux_sym_block_text_repeat1,
  [aux_sym_block_text_repeat2] = aux_sym_block_text_repeat2,
  [alias_sym_annotation_identifier] = alias_sym_annotation_identifier,
  [alias_sym_attribute] = alias_sym_attribute,
  [alias_sym_enum_identifier] = alias_sym_enum_identifier,
  [alias_sym_enum_member] = alias_sym_enum_member,
  [alias_sym_extend_type] = alias_sym_extend_type,
  [alias_sym_field_identifier] = alias_sym_field_identifier,
  [alias_sym_generic_identifier] = alias_sym_generic_identifier,
  [alias_sym_implicit_generic_parameters] = alias_sym_implicit_generic_parameters,
  [alias_sym_import_path] = alias_sym_import_path,
  [alias_sym_local_const] = alias_sym_local_const,
  [alias_sym_method_identifier] = alias_sym_method_identifier,
  [alias_sym_namespace] = alias_sym_namespace,
  [alias_sym_param_identifier] = alias_sym_param_identifier,
  [alias_sym_property] = alias_sym_property,
  [alias_sym_return_identifier] = alias_sym_return_identifier,
  [alias_sym_type_definition] = alias_sym_type_definition,
  [alias_sym_type_identifier] = alias_sym_type_identifier,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_unique_id] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLARimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_namespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_top_level_annotation_body_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_annotation] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enumerant] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_field] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_file] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_method] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_param] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_group] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AnyPointer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UInt8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UInt16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UInt32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_UInt64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Float32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Float64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Text] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Data] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Void] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List] = {
    .visible = true,
    .named = false,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym__normal_version] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__inline_version_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_0x] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_data_token1] = {
    .visible = true,
    .named = true,
  },
  [sym_void] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_embed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_single_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_unescaped_block_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier_no_period] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_message] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_using_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_using] = {
    .visible = true,
    .named = true,
  },
  [sym_import_using] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_top_level_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_top_level_annotation_body] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_targets] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_target] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_array] = {
    .visible = true,
    .named = true,
  },
  [sym__annotation_array_def] = {
    .visible = false,
    .named = true,
  },
  [sym_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_struct] = {
    .visible = true,
    .named = true,
  },
  [sym_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_enum] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_field] = {
    .visible = true,
    .named = true,
  },
  [sym_group] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_union] = {
    .visible = true,
    .named = true,
  },
  [sym_nested_union] = {
    .visible = true,
    .named = true,
  },
  [sym__unnamed_union] = {
    .visible = false,
    .named = true,
  },
  [sym__named_union] = {
    .visible = false,
    .named = true,
  },
  [sym_union_field] = {
    .visible = true,
    .named = true,
  },
  [sym_interface] = {
    .visible = true,
    .named = true,
  },
  [sym_method] = {
    .visible = true,
    .named = true,
  },
  [sym_method_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym_named_return_types] = {
    .visible = true,
    .named = true,
  },
  [sym_unnamed_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym_named_return_type] = {
    .visible = true,
    .named = true,
  },
  [sym_field_type] = {
    .visible = true,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym_list_type] = {
    .visible = true,
    .named = true,
  },
  [sym_custom_type] = {
    .visible = true,
    .named = true,
  },
  [sym_const] = {
    .visible = true,
    .named = true,
  },
  [sym_const_value] = {
    .visible = true,
    .named = true,
  },
  [sym__same_scope_const_value] = {
    .visible = false,
    .named = true,
  },
  [sym_field_version] = {
    .visible = true,
    .named = true,
  },
  [sym__inline_version] = {
    .visible = false,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_data] = {
    .visible = true,
    .named = true,
  },
  [sym_const_list] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_shorthand] = {
    .visible = true,
    .named = true,
  },
  [sym__internal_const_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_embedded_file] = {
    .visible = true,
    .named = true,
  },
  [sym_generics] = {
    .visible = true,
    .named = true,
  },
  [sym_implicit_generics] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_concatenated_string] = {
    .visible = true,
    .named = true,
  },
  [sym_block_text] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__annotation_definition_identifier] = {
    .visible = false,
    .named = true,
  },
  [sym__method_identifier] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_message_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_using_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_top_level_annotation_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_targets_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__annotation_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_annotation_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__annotation_array_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__annotation_array_def_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unnamed_union_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_interface_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_named_return_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_custom_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_shorthand_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__internal_const_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_concatenated_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_text_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_annotation_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_enum_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_enum_member] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_extend_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_field_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_generic_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_implicit_generic_parameters] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_import_path] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_local_const] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_method_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_param_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_return_identifier] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_definition] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_identifier] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_annotation_call = 1,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_annotation_call] = "annotation_call",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [5] = {.index = 0, .length = 1},
  [7] = {.index = 1, .length = 2},
  [10] = {.index = 3, .length = 1},
  [14] = {.index = 4, .length = 1},
  [15] = {.index = 5, .length = 2},
  [16] = {.index = 7, .length = 1},
  [17] = {.index = 7, .length = 1},
  [18] = {.index = 8, .length = 1},
  [19] = {.index = 4, .length = 1},
  [21] = {.index = 9, .length = 3},
  [23] = {.index = 4, .length = 1},
  [27] = {.index = 12, .length = 1},
  [29] = {.index = 13, .length = 4},
  [30] = {.index = 7, .length = 1},
  [31] = {.index = 8, .length = 1},
  [35] = {.index = 17, .length = 1},
  [36] = {.index = 17, .length = 1},
  [37] = {.index = 18, .length = 5},
  [39] = {.index = 4, .length = 1},
  [43] = {.index = 23, .length = 1},
  [44] = {.index = 24, .length = 6},
  [45] = {.index = 24, .length = 6},
  [48] = {.index = 8, .length = 1},
  [49] = {.index = 8, .length = 1},
  [50] = {.index = 17, .length = 1},
  [51] = {.index = 4, .length = 1},
  [53] = {.index = 8, .length = 1},
  [56] = {.index = 30, .length = 7},
  [57] = {.index = 30, .length = 7},
  [58] = {.index = 23, .length = 1},
  [60] = {.index = 4, .length = 1},
  [61] = {.index = 12, .length = 1},
  [62] = {.index = 12, .length = 1},
  [63] = {.index = 23, .length = 1},
  [64] = {.index = 8, .length = 1},
  [65] = {.index = 37, .length = 8},
  [66] = {.index = 37, .length = 8},
  [67] = {.index = 45, .length = 1},
  [68] = {.index = 45, .length = 1},
  [70] = {.index = 17, .length = 1},
  [71] = {.index = 17, .length = 1},
  [72] = {.index = 17, .length = 1},
  [73] = {.index = 46, .length = 9},
  [75] = {.index = 46, .length = 9},
  [76] = {.index = 55, .length = 1},
  [77] = {.index = 23, .length = 1},
  [78] = {.index = 56, .length = 10},
  [79] = {.index = 56, .length = 10},
  [80] = {.index = 66, .length = 11},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_annotation_call, 1},
  [1] =
    {field_annotation_call, 0, .inherited = true},
    {field_annotation_call, 1, .inherited = true},
  [3] =
    {field_annotation_call, 0, .inherited = true},
  [4] =
    {field_annotation_call, 3, .inherited = true},
  [5] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
  [7] =
    {field_annotation_call, 2, .inherited = true},
  [8] =
    {field_annotation_call, 4, .inherited = true},
  [9] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
  [12] =
    {field_annotation_call, 5, .inherited = true},
  [13] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
    {field_annotation_call, 4},
  [17] =
    {field_annotation_call, 6, .inherited = true},
  [18] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
    {field_annotation_call, 4},
    {field_annotation_call, 5},
  [23] =
    {field_annotation_call, 7, .inherited = true},
  [24] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
    {field_annotation_call, 4},
    {field_annotation_call, 5},
    {field_annotation_call, 6},
  [30] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
    {field_annotation_call, 4},
    {field_annotation_call, 5},
    {field_annotation_call, 6},
    {field_annotation_call, 7},
  [37] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
    {field_annotation_call, 4},
    {field_annotation_call, 5},
    {field_annotation_call, 6},
    {field_annotation_call, 7},
    {field_annotation_call, 8},
  [45] =
    {field_annotation_call, 8, .inherited = true},
  [46] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
    {field_annotation_call, 4},
    {field_annotation_call, 5},
    {field_annotation_call, 6},
    {field_annotation_call, 7},
    {field_annotation_call, 8},
    {field_annotation_call, 9},
  [55] =
    {field_annotation_call, 9, .inherited = true},
  [56] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
    {field_annotation_call, 4},
    {field_annotation_call, 5},
    {field_annotation_call, 6},
    {field_annotation_call, 7},
    {field_annotation_call, 8},
    {field_annotation_call, 9},
    {field_annotation_call, 10},
  [66] =
    {field_annotation_call, 1},
    {field_annotation_call, 2},
    {field_annotation_call, 3},
    {field_annotation_call, 4},
    {field_annotation_call, 5},
    {field_annotation_call, 6},
    {field_annotation_call, 7},
    {field_annotation_call, 8},
    {field_annotation_call, 9},
    {field_annotation_call, 10},
    {field_annotation_call, 11},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [1] = alias_sym_import_path,
  },
  [2] = {
    [1] = alias_sym_type_identifier,
  },
  [3] = {
    [0] = alias_sym_type_definition,
    [2] = alias_sym_type_identifier,
  },
  [4] = {
    [0] = alias_sym_type_identifier,
  },
  [5] = {
    [1] = alias_sym_annotation_identifier,
  },
  [6] = {
    [1] = alias_sym_enum_identifier,
  },
  [8] = {
    [0] = alias_sym_generic_identifier,
  },
  [9] = {
    [0] = alias_sym_method_identifier,
  },
  [11] = {
    [0] = alias_sym_type_identifier,
    [3] = alias_sym_import_path,
  },
  [12] = {
    [2] = alias_sym_import_path,
  },
  [13] = {
    [2] = alias_sym_namespace,
  },
  [15] = {
    [1] = alias_sym_annotation_identifier,
  },
  [16] = {
    [1] = alias_sym_enum_identifier,
  },
  [17] = {
    [1] = alias_sym_type_identifier,
  },
  [19] = {
    [1] = alias_sym_enum_identifier,
  },
  [20] = {
    [1] = alias_sym_attribute,
  },
  [21] = {
    [1] = alias_sym_annotation_identifier,
  },
  [22] = {
    [0] = alias_sym_enum_member,
  },
  [23] = {
    [1] = alias_sym_type_identifier,
  },
  [24] = {
    [1] = alias_sym_generic_identifier,
  },
  [25] = {
    [0] = alias_sym_property,
  },
  [26] = {
    [2] = alias_sym_annotation_identifier,
  },
  [28] = {
    [1] = sym__identifier_no_period,
  },
  [29] = {
    [1] = alias_sym_annotation_identifier,
  },
  [30] = {
    [0] = alias_sym_enum_member,
  },
  [31] = {
    [1] = alias_sym_type_identifier,
  },
  [32] = {
    [2] = alias_sym_type_identifier,
  },
  [33] = {
    [1] = alias_sym_import_path,
    [5] = alias_sym_namespace,
  },
  [34] = {
    [1] = alias_sym_local_const,
  },
  [36] = {
    [1] = sym__identifier_no_period,
  },
  [37] = {
    [1] = alias_sym_annotation_identifier,
  },
  [38] = {
    [1] = alias_sym_implicit_generic_parameters,
  },
  [39] = {
    [2] = alias_sym_type_identifier,
  },
  [40] = {
    [3] = alias_sym_type_identifier,
  },
  [41] = {
    [1] = alias_sym_type_identifier,
    [4] = alias_sym_extend_type,
  },
  [42] = {
    [0] = alias_sym_field_identifier,
  },
  [43] = {
    [1] = sym__identifier_no_period,
  },
  [44] = {
    [1] = alias_sym_annotation_identifier,
    [3] = alias_sym_param_identifier,
  },
  [45] = {
    [1] = alias_sym_annotation_identifier,
  },
  [46] = {
    [1] = alias_sym_type_identifier,
    [5] = alias_sym_extend_type,
  },
  [47] = {
    [0] = alias_sym_param_identifier,
  },
  [48] = {
    [2] = alias_sym_type_identifier,
  },
  [49] = {
    [3] = alias_sym_type_identifier,
  },
  [50] = {
    [1] = alias_sym_type_identifier,
    [4] = alias_sym_extend_type,
  },
  [51] = {
    [0] = alias_sym_type_identifier,
  },
  [52] = {
    [0] = alias_sym_field_identifier,
    [4] = alias_sym_import_path,
  },
  [53] = {
    [0] = alias_sym_field_identifier,
  },
  [54] = {
    [2] = alias_sym_import_path,
    [7] = alias_sym_namespace,
  },
  [55] = {
    [1] = alias_sym_annotation_identifier,
  },
  [56] = {
    [1] = alias_sym_annotation_identifier,
    [3] = alias_sym_param_identifier,
  },
  [57] = {
    [1] = alias_sym_annotation_identifier,
    [4] = alias_sym_param_identifier,
  },
  [58] = {
    [1] = alias_sym_type_identifier,
    [5] = alias_sym_extend_type,
  },
  [59] = {
    [1] = alias_sym_type_identifier,
    [6] = alias_sym_extend_type,
  },
  [60] = {
    [0] = alias_sym_param_identifier,
  },
  [61] = {
    [2] = alias_sym_type_identifier,
  },
  [62] = {
    [3] = alias_sym_type_identifier,
  },
  [63] = {
    [1] = alias_sym_type_identifier,
    [4] = alias_sym_extend_type,
  },
  [64] = {
    [0] = alias_sym_type_identifier,
  },
  [65] = {
    [1] = alias_sym_annotation_identifier,
    [3] = alias_sym_param_identifier,
  },
  [66] = {
    [1] = alias_sym_annotation_identifier,
    [4] = alias_sym_param_identifier,
  },
  [67] = {
    [1] = alias_sym_type_identifier,
    [5] = alias_sym_extend_type,
  },
  [68] = {
    [1] = alias_sym_type_identifier,
    [6] = alias_sym_extend_type,
  },
  [69] = {
    [0] = alias_sym_return_identifier,
    [2] = alias_sym_type_identifier,
  },
  [70] = {
    [2] = alias_sym_type_identifier,
  },
  [71] = {
    [3] = alias_sym_type_identifier,
  },
  [72] = {
    [0] = alias_sym_field_identifier,
  },
  [73] = {
    [1] = alias_sym_annotation_identifier,
    [3] = alias_sym_param_identifier,
  },
  [74] = {
    [1] = alias_sym_property,
  },
  [75] = {
    [1] = alias_sym_annotation_identifier,
    [4] = alias_sym_param_identifier,
  },
  [76] = {
    [1] = alias_sym_type_identifier,
    [6] = alias_sym_extend_type,
  },
  [77] = {
    [3] = alias_sym_type_identifier,
  },
  [78] = {
    [1] = alias_sym_annotation_identifier,
    [3] = alias_sym_param_identifier,
  },
  [79] = {
    [1] = alias_sym_annotation_identifier,
    [4] = alias_sym_param_identifier,
  },
  [80] = {
    [1] = alias_sym_annotation_identifier,
    [4] = alias_sym_param_identifier,
  },
  [81] = {
    [1] = alias_sym_return_identifier,
    [3] = alias_sym_type_identifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_field_type, 2,
    sym_field_type,
    alias_sym_generic_identifier,
  sym_const_value, 2,
    sym_const_value,
    alias_sym_local_const,
  sym_generic_parameters, 2,
    sym_generic_parameters,
    alias_sym_implicit_generic_parameters,
  sym_string, 3,
    sym_string,
    alias_sym_import_path,
    alias_sym_namespace,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 27,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 251,
  [298] = 252,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 364,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 371,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 372,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 514,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 572,
};

static inline bool sym_escape_sequence_character_set_1(int32_t c) {
  return (c < 'a'
    ? (c < '?'
      ? (c < '\''
        ? c == '"'
        : c <= '\'')
      : (c <= '?' || c == '\\'))
    : (c <= 'b' || (c < 'r'
      ? (c < 'n'
        ? c == 'f'
        : c <= 'n')
      : (c <= 'r' || (c >= 't' && c <= 'v')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(55);
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '\'') ADVANCE(104);
      if (lookahead == '(') ADVANCE(62);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == '+') ADVANCE(23);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(57);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == '@') ADVANCE(40);
      if (lookahead == '[') ADVANCE(70);
      if (lookahead == '\\') SKIP(51)
      if (lookahead == ']') ADVANCE(71);
      if (lookahead == '`') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(150);
      if (lookahead == 'f') ADVANCE(139);
      if (lookahead == 'i') ADVANCE(151);
      if (lookahead == 'n') ADVANCE(140);
      if (lookahead == 't') ADVANCE(154);
      if (lookahead == 'v') ADVANCE(153);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '}') ADVANCE(73);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(13)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(13)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(15)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(116);
      if (lookahead == '\r') ADVANCE(116);
      if (lookahead == 'u') ADVANCE(35);
      if (lookahead == 'x') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(117);
      if (sym_escape_sequence_character_set_1(lookahead)) ADVANCE(118);
      if (lookahead != 0) ADVANCE(116);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(14)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(14)
      if (lookahead == '\r') SKIP(6)
      END_STATE();
    case 8:
      if (lookahead == '\n') SKIP(18)
      END_STATE();
    case 9:
      if (lookahead == '\n') SKIP(18)
      if (lookahead == '\r') SKIP(8)
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(19)
      END_STATE();
    case 11:
      if (lookahead == '\n') SKIP(19)
      if (lookahead == '\r') SKIP(10)
      END_STATE();
    case 12:
      if (lookahead == ' ') ADVANCE(17);
      if (lookahead == '"') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '$') ADVANCE(64);
      if (lookahead == '\'') ADVANCE(104);
      if (lookahead == '(') ADVANCE(62);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == '+') ADVANCE(23);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(24);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(57);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == '@') ADVANCE(26);
      if (lookahead == '[') ADVANCE(70);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(71);
      if (lookahead == '`') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(131);
      if (lookahead == 'f') ADVANCE(120);
      if (lookahead == 'i') ADVANCE(132);
      if (lookahead == 'n') ADVANCE(121);
      if (lookahead == 't') ADVANCE(135);
      if (lookahead == 'v') ADVANCE(134);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(13)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '$') ADVANCE(64);
      if (lookahead == '\'') ADVANCE(104);
      if (lookahead == '(') ADVANCE(62);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(57);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == '@') ADVANCE(26);
      if (lookahead == '[') ADVANCE(70);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == ']') ADVANCE(71);
      if (lookahead == '`') ADVANCE(105);
      if (lookahead == '{') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(14)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 15:
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '\'') ADVANCE(104);
      if (lookahead == '(') ADVANCE(62);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == '+') ADVANCE(23);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '0') ADVANCE(77);
      if (lookahead == '[') ADVANCE(70);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == ']') ADVANCE(71);
      if (lookahead == '`') ADVANCE(105);
      if (lookahead == 'e') ADVANCE(169);
      if (lookahead == 'f') ADVANCE(158);
      if (lookahead == 'i') ADVANCE(170);
      if (lookahead == 'n') ADVANCE(159);
      if (lookahead == 't') ADVANCE(173);
      if (lookahead == 'v') ADVANCE(172);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(15)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 16:
      if (lookahead == '"') ADVANCE(103);
      if (lookahead == '#') ADVANCE(106);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(107);
      if (lookahead != 0) ADVANCE(108);
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '$') ADVANCE(64);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == ';') ADVANCE(57);
      if (lookahead == '\\') SKIP(9)
      if (lookahead == ']') ADVANCE(71);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(18)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '\\') SKIP(11)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(19)
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '\\') SKIP(11)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(19)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(112);
      if (lookahead == '$') ADVANCE(115);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == ',') ADVANCE(115);
      if (lookahead == ';') ADVANCE(57);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == ']') ADVANCE(115);
      if (lookahead == '`') ADVANCE(105);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(113);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      if (lookahead != 0) ADVANCE(115);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(109);
      if (lookahead == '\'') ADVANCE(104);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(110);
      if (lookahead != 0) ADVANCE(111);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '0') ADVANCE(78);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '0') ADVANCE(79);
      if (lookahead == '>') ADVANCE(74);
      if (lookahead == 'i') ADVANCE(30);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 25:
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '0') ADVANCE(79);
      if (lookahead == 'i') ADVANCE(30);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 26:
      if (lookahead == '0') ADVANCE(38);
      END_STATE();
    case 27:
      if (lookahead == '>') ADVANCE(74);
      END_STATE();
    case 28:
      if (lookahead == 'f') ADVANCE(75);
      END_STATE();
    case 29:
      if (lookahead == 'm') ADVANCE(32);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(28);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 32:
      if (lookahead == 'p') ADVANCE(31);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(34);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(61);
      END_STATE();
    case 35:
      if (lookahead == '{') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 38:
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(45);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(12);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(118);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 50:
      if (eof) ADVANCE(55);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 51:
      if (eof) ADVANCE(55);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(50)
      END_STATE();
    case 52:
      if (eof) ADVANCE(55);
      if (lookahead == '\n') SKIP(54)
      END_STATE();
    case 53:
      if (eof) ADVANCE(55);
      if (lookahead == '\n') SKIP(54)
      if (lookahead == '\r') SKIP(52)
      END_STATE();
    case 54:
      if (eof) ADVANCE(55);
      if (lookahead == '"') ADVANCE(17);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead == '$') ADVANCE(65);
      if (lookahead == '(') ADVANCE(62);
      if (lookahead == ')') ADVANCE(63);
      if (lookahead == '*') ADVANCE(69);
      if (lookahead == ',') ADVANCE(67);
      if (lookahead == '.') ADVANCE(59);
      if (lookahead == ':') ADVANCE(68);
      if (lookahead == ';') ADVANCE(57);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == '@') ADVANCE(26);
      if (lookahead == '[') ADVANCE(70);
      if (lookahead == '\\') SKIP(53)
      if (lookahead == '}') ADVANCE(73);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(54)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_unique_id);
      if (lookahead == '_') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_DOLLARimport);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == 'i') ADVANCE(29);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_top_level_annotation_body_token1);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_number);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '0') ADVANCE(80);
      if (lookahead == 'X') ADVANCE(43);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'x') ADVANCE(95);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '0') ADVANCE(80);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '0') ADVANCE(80);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(43);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '_') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '_') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym__normal_version);
      if (lookahead == '!') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(85);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym__inline_version_token1);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(37);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(88);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '.') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_true);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '.') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_false);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_0x);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(81);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(aux_sym_data_token1);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_void);
      if (lookahead == '.') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_void);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_void);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_embed);
      if (lookahead == '.') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_embed);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_embed);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '\n') ADVANCE(108);
      if (lookahead == '#') ADVANCE(106);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(106);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '#') ADVANCE(106);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(107);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(108);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(108);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '\n') ADVANCE(111);
      if (lookahead == '#') ADVANCE(109);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(109);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead == '#') ADVANCE(109);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(110);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(111);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_unescaped_single_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(111);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_unescaped_block_string_fragment);
      if (lookahead == '\n') ADVANCE(115);
      if (lookahead == '#') ADVANCE(112);
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(112);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_unescaped_block_string_fragment);
      if (lookahead == '#') ADVANCE(112);
      if (lookahead == '$') ADVANCE(115);
      if (lookahead == ')') ADVANCE(115);
      if (lookahead == ',') ADVANCE(115);
      if (lookahead == ']') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) ADVANCE(113);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(115);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_unescaped_block_string_fragment);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(114);
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(115);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_unescaped_block_string_fragment);
      if (lookahead != 0 &&
          lookahead != ';' &&
          lookahead != '\\' &&
          lookahead != '`') ADVANCE(115);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(aux_sym__escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(119);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(118);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'a') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'a') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'b') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'd') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'd') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'e') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'e') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'e') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'f') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'i') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'l') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'm') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'n') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'o') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'r') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 's') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (lookahead == 'u') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(138);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(149);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(152);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(146);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(99);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(102);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(91);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(94);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(143);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(84);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(142);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(155);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(141);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(147);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(84);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(148);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(156);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(145);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(144);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(157);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'a') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'a') ADVANCE(171);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'b') ADVANCE(165);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'd') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'd') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'e') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'e') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'e') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'f') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'i') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'l') ADVANCE(174);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'm') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'n') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'n') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'o') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'r') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 's') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (lookahead == 'u') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym__identifier_no_period);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(176);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == '#') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(177);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'B') ADVANCE(2);
      if (lookahead == 'D') ADVANCE(3);
      if (lookahead == 'F') ADVANCE(4);
      if (lookahead == 'I') ADVANCE(5);
      if (lookahead == 'L') ADVANCE(6);
      if (lookahead == 'T') ADVANCE(7);
      if (lookahead == 'U') ADVANCE(8);
      if (lookahead == 'V') ADVANCE(9);
      if (lookahead == '\\') SKIP(10)
      if (lookahead == 'a') ADVANCE(11);
      if (lookahead == 'c') ADVANCE(12);
      if (lookahead == 'e') ADVANCE(13);
      if (lookahead == 'f') ADVANCE(14);
      if (lookahead == 'g') ADVANCE(15);
      if (lookahead == 'i') ADVANCE(16);
      if (lookahead == 'm') ADVANCE(17);
      if (lookahead == 'n') ADVANCE(18);
      if (lookahead == 'p') ADVANCE(19);
      if (lookahead == 's') ADVANCE(20);
      if (lookahead == 'u') ADVANCE(21);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\f' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == 'n') ADVANCE(22);
      END_STATE();
    case 2:
      if (lookahead == 'o') ADVANCE(23);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(24);
      END_STATE();
    case 4:
      if (lookahead == 'l') ADVANCE(25);
      END_STATE();
    case 5:
      if (lookahead == 'n') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'i') ADVANCE(27);
      END_STATE();
    case 7:
      if (lookahead == 'e') ADVANCE(28);
      END_STATE();
    case 8:
      if (lookahead == 'I') ADVANCE(29);
      END_STATE();
    case 9:
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 10:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(31)
      END_STATE();
    case 11:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 12:
      if (lookahead == 'o') ADVANCE(33);
      END_STATE();
    case 13:
      if (lookahead == 'n') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(35);
      END_STATE();
    case 14:
      if (lookahead == 'i') ADVANCE(36);
      END_STATE();
    case 15:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 16:
      if (lookahead == 'm') ADVANCE(38);
      if (lookahead == 'n') ADVANCE(39);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(41);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(42);
      END_STATE();
    case 20:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 21:
      if (lookahead == 'n') ADVANCE(44);
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 22:
      if (lookahead == 'y') ADVANCE(46);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(47);
      END_STATE();
    case 24:
      if (lookahead == 't') ADVANCE(48);
      END_STATE();
    case 25:
      if (lookahead == 'o') ADVANCE(49);
      END_STATE();
    case 26:
      if (lookahead == 't') ADVANCE(50);
      END_STATE();
    case 27:
      if (lookahead == 's') ADVANCE(51);
      END_STATE();
    case 28:
      if (lookahead == 'x') ADVANCE(52);
      END_STATE();
    case 29:
      if (lookahead == 'n') ADVANCE(53);
      END_STATE();
    case 30:
      if (lookahead == 'i') ADVANCE(54);
      END_STATE();
    case 31:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(55);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(56);
      END_STATE();
    case 34:
      if (lookahead == 'u') ADVANCE(57);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(58);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(59);
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 37:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 38:
      if (lookahead == 'p') ADVANCE(62);
      END_STATE();
    case 39:
      if (lookahead == 't') ADVANCE(63);
      END_STATE();
    case 40:
      if (lookahead == 't') ADVANCE(64);
      END_STATE();
    case 41:
      if (lookahead == 'm') ADVANCE(65);
      END_STATE();
    case 42:
      if (lookahead == 'r') ADVANCE(66);
      END_STATE();
    case 43:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 44:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 45:
      if (lookahead == 'i') ADVANCE(69);
      END_STATE();
    case 46:
      if (lookahead == 'P') ADVANCE(70);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(71);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(72);
      END_STATE();
    case 49:
      if (lookahead == 'a') ADVANCE(73);
      END_STATE();
    case 50:
      if (lookahead == '1') ADVANCE(74);
      if (lookahead == '3') ADVANCE(75);
      if (lookahead == '6') ADVANCE(76);
      if (lookahead == '8') ADVANCE(77);
      END_STATE();
    case 51:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 52:
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 53:
      if (lookahead == 't') ADVANCE(80);
      END_STATE();
    case 54:
      if (lookahead == 'd') ADVANCE(81);
      END_STATE();
    case 55:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 56:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 57:
      if (lookahead == 'm') ADVANCE(84);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(86);
      END_STATE();
    case 60:
      if (lookahead == 'e') ADVANCE(87);
      END_STATE();
    case 61:
      if (lookahead == 'u') ADVANCE(88);
      END_STATE();
    case 62:
      if (lookahead == 'o') ADVANCE(89);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 64:
      if (lookahead == 'h') ADVANCE(91);
      END_STATE();
    case 65:
      if (lookahead == 'e') ADVANCE(92);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(93);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(94);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(95);
      END_STATE();
    case 69:
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_Bool);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_Data);
      END_STATE();
    case 73:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 74:
      if (lookahead == '6') ADVANCE(99);
      END_STATE();
    case 75:
      if (lookahead == '2') ADVANCE(100);
      END_STATE();
    case 76:
      if (lookahead == '4') ADVANCE(101);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_Int8);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_List);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_Text);
      END_STATE();
    case 80:
      if (lookahead == '1') ADVANCE(102);
      if (lookahead == '3') ADVANCE(103);
      if (lookahead == '6') ADVANCE(104);
      if (lookahead == '8') ADVANCE(105);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_Void);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_enum);
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 85:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 86:
      if (lookahead == 'd') ADVANCE(110);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_file);
      END_STATE();
    case 88:
      if (lookahead == 'p') ADVANCE(111);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(112);
      END_STATE();
    case 90:
      if (lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 91:
      if (lookahead == 'o') ADVANCE(114);
      END_STATE();
    case 92:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 93:
      if (lookahead == 'm') ADVANCE(116);
      END_STATE();
    case 94:
      if (lookahead == 'c') ADVANCE(117);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(118);
      END_STATE();
    case 96:
      if (lookahead == 'g') ADVANCE(119);
      END_STATE();
    case 97:
      if (lookahead == 'i') ADVANCE(120);
      END_STATE();
    case 98:
      if (lookahead == '3') ADVANCE(121);
      if (lookahead == '6') ADVANCE(122);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_Int16);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_Int32);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_Int64);
      END_STATE();
    case 102:
      if (lookahead == '6') ADVANCE(123);
      END_STATE();
    case 103:
      if (lookahead == '2') ADVANCE(124);
      END_STATE();
    case 104:
      if (lookahead == '4') ADVANCE(125);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_UInt8);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(126);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 108:
      if (lookahead == 'r') ADVANCE(127);
      END_STATE();
    case 109:
      if (lookahead == 'd') ADVANCE(128);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_field);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_group);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 113:
      if (lookahead == 'f') ADVANCE(130);
      END_STATE();
    case 114:
      if (lookahead == 'd') ADVANCE(131);
      END_STATE();
    case 115:
      if (lookahead == 'p') ADVANCE(132);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_param);
      END_STATE();
    case 117:
      if (lookahead == 't') ADVANCE(133);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(134);
      END_STATE();
    case 121:
      if (lookahead == '2') ADVANCE(135);
      END_STATE();
    case 122:
      if (lookahead == '4') ADVANCE(136);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_UInt16);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_UInt32);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_UInt64);
      END_STATE();
    case 126:
      if (lookahead == 't') ADVANCE(137);
      END_STATE();
    case 127:
      if (lookahead == 'a') ADVANCE(138);
      END_STATE();
    case 128:
      if (lookahead == 's') ADVANCE(139);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 130:
      if (lookahead == 'a') ADVANCE(140);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_method);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(141);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 134:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_Float32);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_Float64);
      END_STATE();
    case 137:
      if (lookahead == 'i') ADVANCE(143);
      END_STATE();
    case 138:
      if (lookahead == 'n') ADVANCE(144);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 140:
      if (lookahead == 'c') ADVANCE(145);
      END_STATE();
    case 141:
      if (lookahead == 'c') ADVANCE(146);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(147);
      END_STATE();
    case 143:
      if (lookahead == 'o') ADVANCE(148);
      END_STATE();
    case 144:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 145:
      if (lookahead == 'e') ADVANCE(150);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(151);
      END_STATE();
    case 147:
      if (lookahead == 'r') ADVANCE(152);
      END_STATE();
    case 148:
      if (lookahead == 'n') ADVANCE(153);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_enumerant);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_namespace);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_AnyPointer);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_annotation);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 54},
  [2] = {.lex_state = 13},
  [3] = {.lex_state = 13},
  [4] = {.lex_state = 13},
  [5] = {.lex_state = 13},
  [6] = {.lex_state = 13},
  [7] = {.lex_state = 13},
  [8] = {.lex_state = 13},
  [9] = {.lex_state = 13},
  [10] = {.lex_state = 13},
  [11] = {.lex_state = 13},
  [12] = {.lex_state = 13},
  [13] = {.lex_state = 15},
  [14] = {.lex_state = 15},
  [15] = {.lex_state = 15},
  [16] = {.lex_state = 15},
  [17] = {.lex_state = 13},
  [18] = {.lex_state = 15},
  [19] = {.lex_state = 15},
  [20] = {.lex_state = 15},
  [21] = {.lex_state = 15},
  [22] = {.lex_state = 15},
  [23] = {.lex_state = 15},
  [24] = {.lex_state = 15},
  [25] = {.lex_state = 15},
  [26] = {.lex_state = 15},
  [27] = {.lex_state = 15},
  [28] = {.lex_state = 15},
  [29] = {.lex_state = 15},
  [30] = {.lex_state = 15},
  [31] = {.lex_state = 15},
  [32] = {.lex_state = 15},
  [33] = {.lex_state = 15},
  [34] = {.lex_state = 15},
  [35] = {.lex_state = 15},
  [36] = {.lex_state = 15},
  [37] = {.lex_state = 15},
  [38] = {.lex_state = 15},
  [39] = {.lex_state = 15},
  [40] = {.lex_state = 15},
  [41] = {.lex_state = 54},
  [42] = {.lex_state = 54},
  [43] = {.lex_state = 54},
  [44] = {.lex_state = 54},
  [45] = {.lex_state = 54},
  [46] = {.lex_state = 54},
  [47] = {.lex_state = 54},
  [48] = {.lex_state = 54},
  [49] = {.lex_state = 54},
  [50] = {.lex_state = 54},
  [51] = {.lex_state = 54},
  [52] = {.lex_state = 54},
  [53] = {.lex_state = 54},
  [54] = {.lex_state = 54},
  [55] = {.lex_state = 54},
  [56] = {.lex_state = 54},
  [57] = {.lex_state = 54},
  [58] = {.lex_state = 54},
  [59] = {.lex_state = 54},
  [60] = {.lex_state = 54},
  [61] = {.lex_state = 54},
  [62] = {.lex_state = 54},
  [63] = {.lex_state = 54},
  [64] = {.lex_state = 54},
  [65] = {.lex_state = 54},
  [66] = {.lex_state = 54},
  [67] = {.lex_state = 54},
  [68] = {.lex_state = 54},
  [69] = {.lex_state = 54},
  [70] = {.lex_state = 54},
  [71] = {.lex_state = 54},
  [72] = {.lex_state = 54},
  [73] = {.lex_state = 54},
  [74] = {.lex_state = 54},
  [75] = {.lex_state = 54},
  [76] = {.lex_state = 54},
  [77] = {.lex_state = 54},
  [78] = {.lex_state = 54},
  [79] = {.lex_state = 54},
  [80] = {.lex_state = 54},
  [81] = {.lex_state = 54},
  [82] = {.lex_state = 54},
  [83] = {.lex_state = 54},
  [84] = {.lex_state = 54},
  [85] = {.lex_state = 54},
  [86] = {.lex_state = 54},
  [87] = {.lex_state = 54},
  [88] = {.lex_state = 54},
  [89] = {.lex_state = 54},
  [90] = {.lex_state = 54},
  [91] = {.lex_state = 54},
  [92] = {.lex_state = 54},
  [93] = {.lex_state = 54},
  [94] = {.lex_state = 54},
  [95] = {.lex_state = 54},
  [96] = {.lex_state = 54},
  [97] = {.lex_state = 54},
  [98] = {.lex_state = 54},
  [99] = {.lex_state = 54},
  [100] = {.lex_state = 54},
  [101] = {.lex_state = 54},
  [102] = {.lex_state = 54},
  [103] = {.lex_state = 54},
  [104] = {.lex_state = 54},
  [105] = {.lex_state = 54},
  [106] = {.lex_state = 54},
  [107] = {.lex_state = 54},
  [108] = {.lex_state = 54},
  [109] = {.lex_state = 54},
  [110] = {.lex_state = 54},
  [111] = {.lex_state = 54},
  [112] = {.lex_state = 54},
  [113] = {.lex_state = 54},
  [114] = {.lex_state = 54},
  [115] = {.lex_state = 54},
  [116] = {.lex_state = 54},
  [117] = {.lex_state = 54},
  [118] = {.lex_state = 54},
  [119] = {.lex_state = 54},
  [120] = {.lex_state = 54},
  [121] = {.lex_state = 54},
  [122] = {.lex_state = 54},
  [123] = {.lex_state = 54},
  [124] = {.lex_state = 54},
  [125] = {.lex_state = 54},
  [126] = {.lex_state = 54},
  [127] = {.lex_state = 54},
  [128] = {.lex_state = 54},
  [129] = {.lex_state = 54},
  [130] = {.lex_state = 54},
  [131] = {.lex_state = 54},
  [132] = {.lex_state = 54},
  [133] = {.lex_state = 54},
  [134] = {.lex_state = 54},
  [135] = {.lex_state = 54},
  [136] = {.lex_state = 54},
  [137] = {.lex_state = 54},
  [138] = {.lex_state = 54},
  [139] = {.lex_state = 54},
  [140] = {.lex_state = 54},
  [141] = {.lex_state = 54},
  [142] = {.lex_state = 54},
  [143] = {.lex_state = 21},
  [144] = {.lex_state = 14},
  [145] = {.lex_state = 21},
  [146] = {.lex_state = 21},
  [147] = {.lex_state = 54},
  [148] = {.lex_state = 54},
  [149] = {.lex_state = 54},
  [150] = {.lex_state = 54},
  [151] = {.lex_state = 54},
  [152] = {.lex_state = 54},
  [153] = {.lex_state = 54},
  [154] = {.lex_state = 54},
  [155] = {.lex_state = 54},
  [156] = {.lex_state = 54},
  [157] = {.lex_state = 14},
  [158] = {.lex_state = 54},
  [159] = {.lex_state = 54},
  [160] = {.lex_state = 54},
  [161] = {.lex_state = 54},
  [162] = {.lex_state = 54},
  [163] = {.lex_state = 54},
  [164] = {.lex_state = 54},
  [165] = {.lex_state = 54},
  [166] = {.lex_state = 54},
  [167] = {.lex_state = 54},
  [168] = {.lex_state = 54},
  [169] = {.lex_state = 54},
  [170] = {.lex_state = 54},
  [171] = {.lex_state = 54},
  [172] = {.lex_state = 54},
  [173] = {.lex_state = 54},
  [174] = {.lex_state = 54},
  [175] = {.lex_state = 54},
  [176] = {.lex_state = 54},
  [177] = {.lex_state = 54},
  [178] = {.lex_state = 54},
  [179] = {.lex_state = 54},
  [180] = {.lex_state = 54},
  [181] = {.lex_state = 54},
  [182] = {.lex_state = 54},
  [183] = {.lex_state = 54},
  [184] = {.lex_state = 54},
  [185] = {.lex_state = 54},
  [186] = {.lex_state = 54},
  [187] = {.lex_state = 14},
  [188] = {.lex_state = 54},
  [189] = {.lex_state = 54},
  [190] = {.lex_state = 14},
  [191] = {.lex_state = 54},
  [192] = {.lex_state = 14},
  [193] = {.lex_state = 14},
  [194] = {.lex_state = 14},
  [195] = {.lex_state = 14},
  [196] = {.lex_state = 54},
  [197] = {.lex_state = 54},
  [198] = {.lex_state = 54},
  [199] = {.lex_state = 54},
  [200] = {.lex_state = 54},
  [201] = {.lex_state = 54},
  [202] = {.lex_state = 54},
  [203] = {.lex_state = 54},
  [204] = {.lex_state = 54},
  [205] = {.lex_state = 54},
  [206] = {.lex_state = 54},
  [207] = {.lex_state = 54},
  [208] = {.lex_state = 54},
  [209] = {.lex_state = 14},
  [210] = {.lex_state = 54},
  [211] = {.lex_state = 14},
  [212] = {.lex_state = 54},
  [213] = {.lex_state = 14},
  [214] = {.lex_state = 54},
  [215] = {.lex_state = 54},
  [216] = {.lex_state = 54},
  [217] = {.lex_state = 54},
  [218] = {.lex_state = 54},
  [219] = {.lex_state = 54},
  [220] = {.lex_state = 54},
  [221] = {.lex_state = 54},
  [222] = {.lex_state = 54},
  [223] = {.lex_state = 54},
  [224] = {.lex_state = 14},
  [225] = {.lex_state = 54},
  [226] = {.lex_state = 14},
  [227] = {.lex_state = 54},
  [228] = {.lex_state = 54},
  [229] = {.lex_state = 54},
  [230] = {.lex_state = 54},
  [231] = {.lex_state = 54},
  [232] = {.lex_state = 14},
  [233] = {.lex_state = 14},
  [234] = {.lex_state = 54},
  [235] = {.lex_state = 54},
  [236] = {.lex_state = 54},
  [237] = {.lex_state = 54},
  [238] = {.lex_state = 54},
  [239] = {.lex_state = 54},
  [240] = {.lex_state = 54},
  [241] = {.lex_state = 54},
  [242] = {.lex_state = 54},
  [243] = {.lex_state = 14},
  [244] = {.lex_state = 14},
  [245] = {.lex_state = 14},
  [246] = {.lex_state = 14},
  [247] = {.lex_state = 14},
  [248] = {.lex_state = 14},
  [249] = {.lex_state = 14},
  [250] = {.lex_state = 13},
  [251] = {.lex_state = 18},
  [252] = {.lex_state = 18},
  [253] = {.lex_state = 54},
  [254] = {.lex_state = 14},
  [255] = {.lex_state = 14},
  [256] = {.lex_state = 13},
  [257] = {.lex_state = 13},
  [258] = {.lex_state = 14},
  [259] = {.lex_state = 14},
  [260] = {.lex_state = 13},
  [261] = {.lex_state = 13},
  [262] = {.lex_state = 16},
  [263] = {.lex_state = 13},
  [264] = {.lex_state = 13},
  [265] = {.lex_state = 13},
  [266] = {.lex_state = 14},
  [267] = {.lex_state = 22},
  [268] = {.lex_state = 14},
  [269] = {.lex_state = 13},
  [270] = {.lex_state = 13},
  [271] = {.lex_state = 13},
  [272] = {.lex_state = 14},
  [273] = {.lex_state = 14},
  [274] = {.lex_state = 13},
  [275] = {.lex_state = 13},
  [276] = {.lex_state = 14},
  [277] = {.lex_state = 13},
  [278] = {.lex_state = 16},
  [279] = {.lex_state = 13},
  [280] = {.lex_state = 14},
  [281] = {.lex_state = 22},
  [282] = {.lex_state = 13},
  [283] = {.lex_state = 13},
  [284] = {.lex_state = 13},
  [285] = {.lex_state = 22},
  [286] = {.lex_state = 16},
  [287] = {.lex_state = 13},
  [288] = {.lex_state = 14},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 13},
  [291] = {.lex_state = 14},
  [292] = {.lex_state = 14},
  [293] = {.lex_state = 14},
  [294] = {.lex_state = 54},
  [295] = {.lex_state = 54},
  [296] = {.lex_state = 54},
  [297] = {.lex_state = 54},
  [298] = {.lex_state = 54},
  [299] = {.lex_state = 54},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 54},
  [302] = {.lex_state = 54},
  [303] = {.lex_state = 54},
  [304] = {.lex_state = 54},
  [305] = {.lex_state = 54},
  [306] = {.lex_state = 54},
  [307] = {.lex_state = 54},
  [308] = {.lex_state = 54},
  [309] = {.lex_state = 13},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 54},
  [312] = {.lex_state = 54},
  [313] = {.lex_state = 54},
  [314] = {.lex_state = 54},
  [315] = {.lex_state = 54},
  [316] = {.lex_state = 13},
  [317] = {.lex_state = 54},
  [318] = {.lex_state = 54},
  [319] = {.lex_state = 54},
  [320] = {.lex_state = 54},
  [321] = {.lex_state = 54},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 54},
  [324] = {.lex_state = 54},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 54},
  [327] = {.lex_state = 54},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 54},
  [330] = {.lex_state = 54},
  [331] = {.lex_state = 54},
  [332] = {.lex_state = 54},
  [333] = {.lex_state = 54},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 54},
  [337] = {.lex_state = 13},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 54},
  [340] = {.lex_state = 54},
  [341] = {.lex_state = 54},
  [342] = {.lex_state = 13},
  [343] = {.lex_state = 13},
  [344] = {.lex_state = 54},
  [345] = {.lex_state = 54},
  [346] = {.lex_state = 54},
  [347] = {.lex_state = 54},
  [348] = {.lex_state = 13},
  [349] = {.lex_state = 13},
  [350] = {.lex_state = 13},
  [351] = {.lex_state = 54},
  [352] = {.lex_state = 14},
  [353] = {.lex_state = 13},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 54},
  [357] = {.lex_state = 13},
  [358] = {.lex_state = 54},
  [359] = {.lex_state = 13},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 13},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 13},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 14},
  [368] = {.lex_state = 54},
  [369] = {.lex_state = 13},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 54},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 0},
  [386] = {.lex_state = 0},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 0},
  [389] = {.lex_state = 13},
  [390] = {.lex_state = 13},
  [391] = {.lex_state = 13},
  [392] = {.lex_state = 13},
  [393] = {.lex_state = 0},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 13},
  [396] = {.lex_state = 13},
  [397] = {.lex_state = 54},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 54},
  [401] = {.lex_state = 13},
  [402] = {.lex_state = 13},
  [403] = {.lex_state = 0},
  [404] = {.lex_state = 13},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 13},
  [408] = {.lex_state = 13},
  [409] = {.lex_state = 13},
  [410] = {.lex_state = 13},
  [411] = {.lex_state = 13},
  [412] = {.lex_state = 13},
  [413] = {.lex_state = 54},
  [414] = {.lex_state = 13},
  [415] = {.lex_state = 0},
  [416] = {.lex_state = 0},
  [417] = {.lex_state = 13},
  [418] = {.lex_state = 54},
  [419] = {.lex_state = 13},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 54},
  [422] = {.lex_state = 13},
  [423] = {.lex_state = 13},
  [424] = {.lex_state = 13},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 13},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 13},
  [430] = {.lex_state = 54},
  [431] = {.lex_state = 54},
  [432] = {.lex_state = 13},
  [433] = {.lex_state = 13},
  [434] = {.lex_state = 13},
  [435] = {.lex_state = 13},
  [436] = {.lex_state = 13},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 13},
  [439] = {.lex_state = 13},
  [440] = {.lex_state = 13},
  [441] = {.lex_state = 13},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 54},
  [445] = {.lex_state = 54},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 13},
  [451] = {.lex_state = 13},
  [452] = {.lex_state = 54},
  [453] = {.lex_state = 54},
  [454] = {.lex_state = 13},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 13},
  [457] = {.lex_state = 13},
  [458] = {.lex_state = 13},
  [459] = {.lex_state = 54},
  [460] = {.lex_state = 0},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 13},
  [464] = {.lex_state = 54},
  [465] = {.lex_state = 13},
  [466] = {.lex_state = 13},
  [467] = {.lex_state = 13},
  [468] = {.lex_state = 13},
  [469] = {.lex_state = 13},
  [470] = {.lex_state = 13},
  [471] = {.lex_state = 13},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 13},
  [474] = {.lex_state = 13},
  [475] = {.lex_state = 13},
  [476] = {.lex_state = 13},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 13},
  [480] = {.lex_state = 13},
  [481] = {.lex_state = 13},
  [482] = {.lex_state = 13},
  [483] = {.lex_state = 0},
  [484] = {.lex_state = 13},
  [485] = {.lex_state = 13},
  [486] = {.lex_state = 13},
  [487] = {.lex_state = 54},
  [488] = {.lex_state = 0},
  [489] = {.lex_state = 0},
  [490] = {.lex_state = 54},
  [491] = {.lex_state = 54},
  [492] = {.lex_state = 54},
  [493] = {.lex_state = 13},
  [494] = {.lex_state = 13},
  [495] = {.lex_state = 13},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 13},
  [498] = {.lex_state = 13},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 13},
  [501] = {.lex_state = 13},
  [502] = {.lex_state = 13},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 13},
  [505] = {.lex_state = 13},
  [506] = {.lex_state = 13},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 13},
  [509] = {.lex_state = 54},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 18},
  [513] = {.lex_state = 20},
  [514] = {.lex_state = 18},
  [515] = {.lex_state = 54},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 13},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 54},
  [520] = {.lex_state = 54},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 54},
  [523] = {.lex_state = 13},
  [524] = {.lex_state = 54},
  [525] = {.lex_state = 54},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 54},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 54},
  [530] = {.lex_state = 54},
  [531] = {.lex_state = 54},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 18},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 18},
  [536] = {.lex_state = 54},
  [537] = {.lex_state = 13},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 13},
  [541] = {.lex_state = 54},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 54},
  [547] = {.lex_state = 54},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 54},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 54},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 54},
  [564] = {.lex_state = 54},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 54},
  [568] = {.lex_state = 0},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 0},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 54},
  [574] = {.lex_state = 0},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 54},
  [580] = {.lex_state = 54},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 0},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 0},
  [586] = {.lex_state = 54},
  [587] = {.lex_state = 0},
  [588] = {.lex_state = 0},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 54},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 0},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 0},
  [602] = {.lex_state = 0},
  [603] = {.lex_state = 54},
  [604] = {.lex_state = 54},
  [605] = {.lex_state = 0},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 0},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 54},
  [612] = {.lex_state = 0},
  [613] = {.lex_state = 54},
  [614] = {.lex_state = 54},
  [615] = {.lex_state = 54},
  [616] = {.lex_state = 54},
  [617] = {.lex_state = 18},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 0},
  [620] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_DOLLARimport] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_namespace] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_annotation] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_enumerant] = ACTIONS(1),
    [anon_sym_field] = ACTIONS(1),
    [anon_sym_file] = ACTIONS(1),
    [anon_sym_method] = ACTIONS(1),
    [anon_sym_param] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_group] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_AnyPointer] = ACTIONS(1),
    [anon_sym_Bool] = ACTIONS(1),
    [anon_sym_Int8] = ACTIONS(1),
    [anon_sym_Int16] = ACTIONS(1),
    [anon_sym_Int32] = ACTIONS(1),
    [anon_sym_Int64] = ACTIONS(1),
    [anon_sym_UInt8] = ACTIONS(1),
    [anon_sym_UInt16] = ACTIONS(1),
    [anon_sym_UInt32] = ACTIONS(1),
    [anon_sym_UInt64] = ACTIONS(1),
    [anon_sym_Float32] = ACTIONS(1),
    [anon_sym_Float64] = ACTIONS(1),
    [anon_sym_Text] = ACTIONS(1),
    [anon_sym_Data] = ACTIONS(1),
    [anon_sym_Void] = ACTIONS(1),
    [anon_sym_List] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [sym__normal_version] = ACTIONS(1),
    [aux_sym__inline_version_token1] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [anon_sym_0x] = ACTIONS(1),
    [sym_void] = ACTIONS(1),
    [anon_sym_embed] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_message] = STATE(608),
    [sym_statement] = STATE(66),
    [sym_using_directive] = STATE(191),
    [sym_import] = STATE(191),
    [sym_top_level_annotation] = STATE(191),
    [sym_annotation] = STATE(191),
    [sym_definition] = STATE(191),
    [sym_struct] = STATE(198),
    [sym_enum] = STATE(198),
    [sym_interface] = STATE(198),
    [sym_const] = STATE(198),
    [aux_sym_message_repeat1] = STATE(66),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_unique_id] = ACTIONS(7),
    [anon_sym_using] = ACTIONS(9),
    [anon_sym_DOLLARimport] = ACTIONS(11),
    [anon_sym_DOLLAR] = ACTIONS(13),
    [anon_sym_annotation] = ACTIONS(15),
    [anon_sym_const] = ACTIONS(17),
    [anon_sym_enum] = ACTIONS(19),
    [anon_sym_interface] = ACTIONS(21),
    [anon_sym_struct] = ACTIONS(23),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_RPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(366), 1,
      sym_field_type,
    STATE(477), 1,
      sym_const_value,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(543), 1,
      sym_annotation_array,
    STATE(548), 1,
      sym_generic_parameters,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [102] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(53), 1,
      sym_identifier,
    ACTIONS(55), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(355), 1,
      sym_const_value,
    STATE(374), 1,
      sym_annotation_array,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(509), 1,
      aux_sym_struct_shorthand_repeat1,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [176] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(57), 1,
      sym_identifier,
    ACTIONS(59), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(477), 1,
      sym_const_value,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(606), 1,
      sym_annotation_array,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [247] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(57), 1,
      sym_identifier,
    ACTIONS(61), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(477), 1,
      sym_const_value,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(551), 1,
      sym_annotation_array,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [318] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(63), 1,
      sym_identifier,
    ACTIONS(65), 1,
      anon_sym_RBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(428), 1,
      sym_annotation_array,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    STATE(478), 2,
      sym__annotation_array_def,
      sym_const_value,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [387] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(477), 1,
      sym_const_value,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(576), 1,
      sym_annotation_array,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [458] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(57), 1,
      sym_identifier,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(477), 1,
      sym_const_value,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(574), 1,
      sym_annotation_array,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [529] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(57), 1,
      sym_identifier,
    ACTIONS(73), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(477), 1,
      sym_const_value,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(594), 1,
      sym_annotation_array,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [600] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(57), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(477), 1,
      sym_const_value,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(576), 1,
      sym_annotation_array,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [671] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(57), 1,
      sym_identifier,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(477), 1,
      sym_const_value,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(577), 1,
      sym_annotation_array,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [742] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_LBRACK,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(63), 1,
      sym_identifier,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(355), 1,
      sym_const_value,
    STATE(442), 1,
      sym_annotation_array,
    STATE(478), 1,
      sym__annotation_array_def,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [810] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(375), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    ACTIONS(79), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [874] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(375), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    ACTIONS(83), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [938] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_DOT,
    ACTIONS(87), 1,
      sym__identifier_no_period,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(340), 1,
      sym_const_value,
    STATE(444), 1,
      sym__same_scope_const_value,
    STATE(514), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1003] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    ACTIONS(85), 1,
      anon_sym_DOT,
    ACTIONS(87), 1,
      sym__identifier_no_period,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(514), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    STATE(444), 2,
      sym_const_value,
      sym__same_scope_const_value,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1066] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    ACTIONS(89), 1,
      sym_identifier,
    ACTIONS(91), 1,
      anon_sym_RPAREN,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(328), 1,
      sym_string,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(93), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(559), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1128] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(65), 1,
      anon_sym_RBRACK,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(507), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1190] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    ACTIONS(95), 1,
      anon_sym_RBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(375), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1252] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    ACTIONS(97), 1,
      anon_sym_RBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(375), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1314] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(384), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1373] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(488), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1432] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(510), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1491] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(591), 1,
      sym_const_value,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1550] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(405), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1609] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(495), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1668] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(377), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1727] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(528), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1786] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(434), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1845] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(364), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1904] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(448), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [1963] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(388), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2022] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    ACTIONS(87), 1,
      sym__identifier_no_period,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(376), 1,
      sym_const_value,
    STATE(514), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2081] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(480), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2140] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(425), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2199] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(568), 1,
      sym_const_value,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2258] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    STATE(542), 1,
      sym_const_value,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2317] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(516), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2376] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(375), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2435] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(41), 1,
      anon_sym_0x,
    ACTIONS(43), 1,
      anon_sym_embed,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    ACTIONS(51), 1,
      sym__identifier_no_period,
    ACTIONS(77), 1,
      anon_sym_LPAREN,
    ACTIONS(81), 1,
      anon_sym_LBRACK,
    STATE(209), 1,
      sym_string,
    STATE(244), 1,
      aux_sym_block_text_repeat2,
    STATE(518), 1,
      sym_const_value,
    STATE(535), 1,
      aux_sym__internal_const_identifier_repeat1,
    ACTIONS(39), 2,
      sym_true,
      sym_false,
    ACTIONS(37), 3,
      sym_number,
      sym_float,
      sym_void,
    STATE(268), 8,
      sym_boolean,
      sym_data,
      sym_const_list,
      sym_struct_shorthand,
      sym__internal_const_identifier,
      sym_embedded_file,
      sym_concatenated_string,
      sym_block_text,
  [2494] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(115), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(47), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [2551] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(117), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(53), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [2608] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(119), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(52), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [2665] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(121), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(47), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [2722] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(123), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(47), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [2779] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(117), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(47), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [2836] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(125), 1,
      sym_identifier,
    ACTIONS(128), 1,
      anon_sym_using,
    ACTIONS(131), 1,
      anon_sym_annotation,
    ACTIONS(134), 1,
      anon_sym_const,
    ACTIONS(137), 1,
      anon_sym_enum,
    ACTIONS(140), 1,
      anon_sym_interface,
    ACTIONS(143), 1,
      anon_sym_struct,
    ACTIONS(146), 1,
      anon_sym_union,
    ACTIONS(149), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(47), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [2893] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(151), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(49), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [2950] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(153), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(47), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3007] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(155), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(44), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3064] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(123), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(46), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3121] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(157), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(47), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3178] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(159), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(47), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3235] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(163), 1,
      anon_sym_import,
    ACTIONS(165), 1,
      anon_sym_union,
    STATE(359), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3276] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(167), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(41), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3333] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(101), 1,
      anon_sym_using,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(169), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(45), 3,
      sym_using_directive,
      sym_field,
      aux_sym_struct_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3390] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(366), 1,
      sym_field_type,
    STATE(595), 1,
      sym_generic_parameters,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3428] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    ACTIONS(165), 1,
      anon_sym_union,
    STATE(363), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3466] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(366), 1,
      sym_field_type,
    STATE(548), 1,
      sym_generic_parameters,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3504] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(363), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3539] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(171), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(71), 2,
      sym_field,
      aux_sym_group_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3592] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(173), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(70), 2,
      sym_field,
      aux_sym_group_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3645] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(553), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3680] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(545), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3715] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(486), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3750] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym_unique_id,
    ACTIONS(9), 1,
      anon_sym_using,
    ACTIONS(11), 1,
      anon_sym_DOLLARimport,
    ACTIONS(13), 1,
      anon_sym_DOLLAR,
    ACTIONS(15), 1,
      anon_sym_annotation,
    ACTIONS(17), 1,
      anon_sym_const,
    ACTIONS(19), 1,
      anon_sym_enum,
    ACTIONS(21), 1,
      anon_sym_interface,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(175), 1,
      ts_builtin_sym_end,
    STATE(72), 2,
      sym_statement,
      aux_sym_message_repeat1,
    STATE(198), 4,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_const,
    STATE(191), 5,
      sym_using_directive,
      sym_import,
      sym_top_level_annotation,
      sym_annotation,
      sym_definition,
  [3801] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(387), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3836] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(309), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [3871] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(177), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(61), 2,
      sym_field,
      aux_sym_group_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3924] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      sym_identifier,
    ACTIONS(103), 1,
      anon_sym_annotation,
    ACTIONS(105), 1,
      anon_sym_const,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(113), 1,
      anon_sym_union,
    ACTIONS(179), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(71), 2,
      sym_field,
      aux_sym_group_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [3977] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(181), 1,
      sym_identifier,
    ACTIONS(184), 1,
      anon_sym_annotation,
    ACTIONS(187), 1,
      anon_sym_const,
    ACTIONS(190), 1,
      anon_sym_enum,
    ACTIONS(193), 1,
      anon_sym_interface,
    ACTIONS(196), 1,
      anon_sym_struct,
    ACTIONS(199), 1,
      anon_sym_union,
    ACTIONS(202), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(234), 1,
      sym_enum,
    STATE(239), 1,
      sym_struct,
    STATE(240), 1,
      sym__named_union,
    STATE(71), 2,
      sym_field,
      aux_sym_group_repeat1,
    STATE(228), 7,
      sym_annotation,
      sym_nested_struct,
      sym_nested_enum,
      sym_group,
      sym_union,
      sym_interface,
      sym_const,
  [4030] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      ts_builtin_sym_end,
    ACTIONS(206), 1,
      sym_unique_id,
    ACTIONS(209), 1,
      anon_sym_using,
    ACTIONS(212), 1,
      anon_sym_DOLLARimport,
    ACTIONS(215), 1,
      anon_sym_DOLLAR,
    ACTIONS(218), 1,
      anon_sym_annotation,
    ACTIONS(221), 1,
      anon_sym_const,
    ACTIONS(224), 1,
      anon_sym_enum,
    ACTIONS(227), 1,
      anon_sym_interface,
    ACTIONS(230), 1,
      anon_sym_struct,
    STATE(72), 2,
      sym_statement,
      aux_sym_message_repeat1,
    STATE(198), 4,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_const,
    STATE(191), 5,
      sym_using_directive,
      sym_import,
      sym_top_level_annotation,
      sym_annotation,
      sym_definition,
  [4081] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(610), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [4116] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(35), 1,
      anon_sym_List,
    ACTIONS(161), 1,
      sym_identifier,
    STATE(502), 1,
      sym_field_type,
    STATE(271), 3,
      sym_primitive_type,
      sym_list_type,
      sym_custom_type,
    ACTIONS(33), 15,
      anon_sym_AnyPointer,
      anon_sym_Bool,
      anon_sym_Int8,
      anon_sym_Int16,
      anon_sym_Int32,
      anon_sym_Int64,
      anon_sym_UInt8,
      anon_sym_UInt16,
      anon_sym_UInt32,
      anon_sym_UInt64,
      anon_sym_Float32,
      anon_sym_Float64,
      anon_sym_Text,
      anon_sym_Data,
      anon_sym_Void,
  [4151] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_enum,
    STATE(534), 1,
      sym_annotation_target,
    ACTIONS(233), 12,
      anon_sym_annotation,
      anon_sym_STAR,
      anon_sym_const,
      anon_sym_enumerant,
      anon_sym_field,
      anon_sym_file,
      anon_sym_method,
      anon_sym_param,
      anon_sym_group,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
  [4175] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(235), 1,
      anon_sym_enum,
    STATE(462), 1,
      sym_annotation_target,
    ACTIONS(233), 12,
      anon_sym_annotation,
      anon_sym_STAR,
      anon_sym_const,
      anon_sym_enumerant,
      anon_sym_field,
      anon_sym_file,
      anon_sym_method,
      anon_sym_param,
      anon_sym_group,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
  [4199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(237), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(239), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4220] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(243), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4241] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(247), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4262] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(251), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4283] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(253), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(255), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(257), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(259), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(261), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(263), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(265), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(267), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(269), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(271), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4388] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(273), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(275), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4409] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(279), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4430] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(281), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(283), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(277), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(279), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4472] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(285), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(287), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(289), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(291), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(293), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(295), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4535] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(297), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(299), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4556] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(301), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(303), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4577] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(307), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4598] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(309), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(311), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4619] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(315), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4640] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(317), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(319), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4661] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(321), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(323), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4682] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(325), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(327), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4703] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(329), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(331), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4724] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(333), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(335), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(337), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(339), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4766] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(341), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(343), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4787] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(345), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(347), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4808] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(349), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(351), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4829] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(251), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(353), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(355), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4871] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(357), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(359), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4892] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(361), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(363), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(365), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(367), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(369), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(371), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4955] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(373), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(375), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4976] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(377), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(379), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [4997] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(241), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(243), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5018] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(383), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(385), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(387), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5060] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(391), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(393), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(395), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(397), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(399), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5123] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(401), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(403), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5144] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(405), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(407), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5165] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(409), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(411), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5186] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(413), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(415), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5207] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(417), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(419), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5228] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(423), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(425), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(427), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5270] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(429), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(431), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5291] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(433), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(435), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(437), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(439), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5333] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(441), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(443), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5354] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(445), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(447), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5375] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(449), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(451), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5396] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(453), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(455), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5417] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(381), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(383), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(457), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(459), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(461), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(463), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5480] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(465), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(467), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5501] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(469), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(471), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5522] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(473), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(475), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(477), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(479), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5564] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 4,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_DOLLARimport,
      anon_sym_RBRACE,
    ACTIONS(483), 9,
      anon_sym_using,
      anon_sym_DOLLAR,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [5585] = 5,
    ACTIONS(487), 1,
      sym_unescaped_block_string_fragment,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(489), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(145), 2,
      sym__escape_sequence,
      aux_sym_block_text_repeat1,
    ACTIONS(485), 7,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_BQUOTE,
      sym_identifier,
  [5609] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 12,
      sym_unique_id,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_extends,
      anon_sym_DASH_GT,
  [5627] = 5,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(497), 1,
      sym_unescaped_block_string_fragment,
    ACTIONS(500), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(145), 2,
      sym__escape_sequence,
      aux_sym_block_text_repeat1,
    ACTIONS(495), 7,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_BQUOTE,
      sym_identifier,
  [5651] = 5,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(505), 1,
      sym_unescaped_block_string_fragment,
    ACTIONS(507), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(143), 2,
      sym__escape_sequence,
      aux_sym_block_text_repeat1,
    ACTIONS(503), 7,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_BQUOTE,
      sym_identifier,
  [5675] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(511), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5704] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 1,
      sym_identifier,
    ACTIONS(516), 1,
      anon_sym_enum,
    ACTIONS(519), 1,
      anon_sym_interface,
    ACTIONS(522), 1,
      anon_sym_struct,
    ACTIONS(525), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5733] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(527), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(173), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5762] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(529), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5791] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(531), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(165), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5820] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(533), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(158), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5849] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(511), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(162), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5878] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(535), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(163), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5907] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(537), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5936] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(539), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [5965] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(545), 1,
      anon_sym_LPAREN,
    STATE(187), 1,
      sym_generics,
    STATE(213), 1,
      aux_sym__annotation_call_repeat1,
    STATE(275), 1,
      sym_annotation_literal,
    ACTIONS(541), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [5992] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(531), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6021] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(547), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(164), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6050] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(549), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(147), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6079] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(551), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(156), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6108] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(553), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6137] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(555), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6166] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(557), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6195] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(559), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6224] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(561), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6253] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(563), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(184), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6282] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(565), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6311] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(567), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(183), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6340] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(569), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6369] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(571), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(174), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6398] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(573), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(170), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6427] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(575), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6456] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6485] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(579), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(177), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6514] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(581), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6543] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(563), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6572] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(583), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(166), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6601] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(577), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(168), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6630] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(585), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(181), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6659] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(587), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6688] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(589), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(150), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6717] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(591), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6746] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(593), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(148), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6775] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(595), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(155), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6804] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(107), 1,
      anon_sym_enum,
    ACTIONS(109), 1,
      anon_sym_interface,
    ACTIONS(111), 1,
      anon_sym_struct,
    ACTIONS(509), 1,
      sym_identifier,
    ACTIONS(593), 1,
      anon_sym_RBRACE,
    STATE(362), 1,
      sym__method_identifier,
    STATE(176), 5,
      sym_struct,
      sym_enum,
      sym_interface,
      sym_method,
      aux_sym_interface_repeat1,
  [6833] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(599), 1,
      anon_sym_LPAREN,
    STATE(195), 1,
      aux_sym__annotation_call_repeat1,
    STATE(279), 1,
      sym_annotation_literal,
    ACTIONS(597), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [6857] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(605), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(208), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [6887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(609), 1,
      anon_sym_DOLLAR,
    ACTIONS(607), 9,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_using,
      anon_sym_DOLLARimport,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
  [6905] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(613), 1,
      anon_sym_LPAREN,
    STATE(233), 1,
      aux_sym__annotation_call_repeat1,
    STATE(277), 1,
      sym_annotation_literal,
    ACTIONS(611), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [6929] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 1,
      anon_sym_DOLLAR,
    ACTIONS(615), 9,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_using,
      anon_sym_DOLLARimport,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
  [6947] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(211), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(619), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [6969] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_DOT,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    STATE(243), 1,
      sym_generics,
    STATE(245), 1,
      aux_sym_custom_type_repeat1,
    ACTIONS(621), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [6993] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(629), 1,
      anon_sym_LPAREN,
    STATE(233), 1,
      aux_sym__annotation_call_repeat1,
    STATE(257), 1,
      sym_annotation_literal,
    ACTIONS(627), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [7017] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(633), 1,
      anon_sym_LPAREN,
    STATE(233), 1,
      aux_sym__annotation_call_repeat1,
    STATE(284), 1,
      sym_annotation_literal,
    ACTIONS(631), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [7041] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(635), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(208), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7071] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_DOLLAR,
    ACTIONS(637), 9,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_using,
      anon_sym_DOLLARimport,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
  [7089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(643), 1,
      anon_sym_DOLLAR,
    ACTIONS(641), 9,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_using,
      anon_sym_DOLLARimport,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
  [7107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 1,
      anon_sym_DOLLAR,
    ACTIONS(645), 9,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_using,
      anon_sym_DOLLARimport,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
  [7125] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(649), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(212), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7155] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(653), 1,
      anon_sym_DOLLAR,
    ACTIONS(651), 9,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_using,
      anon_sym_DOLLARimport,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
  [7173] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(205), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7203] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(657), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(196), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7233] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(659), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(188), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7263] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(661), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(208), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7293] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(665), 1,
      anon_sym_DOLLAR,
    ACTIONS(663), 9,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_using,
      anon_sym_DOLLARimport,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
  [7311] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(667), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(208), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7341] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 1,
      sym_identifier,
    ACTIONS(672), 1,
      anon_sym_union,
    ACTIONS(675), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(208), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7371] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(192), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(677), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [7393] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_DOLLAR,
    ACTIONS(679), 9,
      ts_builtin_sym_end,
      sym_unique_id,
      anon_sym_using,
      anon_sym_DOLLARimport,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
  [7411] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(685), 1,
      anon_sym_DQUOTE,
    ACTIONS(688), 1,
      anon_sym_SQUOTE,
    STATE(211), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
    ACTIONS(683), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [7433] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(691), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(208), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7463] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(543), 1,
      anon_sym_DOT,
    ACTIONS(693), 1,
      anon_sym_LPAREN,
    STATE(233), 1,
      aux_sym__annotation_call_repeat1,
    STATE(279), 1,
      sym_annotation_literal,
    ACTIONS(597), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [7487] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(601), 1,
      sym_identifier,
    ACTIONS(603), 1,
      anon_sym_union,
    ACTIONS(635), 1,
      anon_sym_RBRACE,
    STATE(231), 1,
      sym__unnamed_union,
    STATE(240), 1,
      sym__named_union,
    STATE(452), 1,
      sym_union,
    STATE(207), 2,
      sym_union_field,
      aux_sym__unnamed_union_repeat1,
    STATE(453), 2,
      sym_group,
      sym_nested_union,
  [7517] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 1,
      anon_sym_RBRACE,
    ACTIONS(695), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7534] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(701), 1,
      anon_sym_RBRACE,
    ACTIONS(699), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 1,
      anon_sym_RBRACE,
    ACTIONS(703), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7568] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(709), 1,
      anon_sym_RBRACE,
    ACTIONS(707), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(713), 1,
      anon_sym_RBRACE,
    ACTIONS(711), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7602] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(717), 1,
      anon_sym_RBRACE,
    ACTIONS(715), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7619] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 1,
      anon_sym_RBRACE,
    ACTIONS(719), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7636] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(725), 1,
      anon_sym_RBRACE,
    ACTIONS(723), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(729), 1,
      anon_sym_RBRACE,
    ACTIONS(727), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7670] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(731), 9,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_identifier,
  [7685] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(735), 1,
      anon_sym_RBRACE,
    ACTIONS(733), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7702] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(737), 9,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DQUOTE,
      anon_sym_SQUOTE,
      sym_identifier,
  [7717] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
    ACTIONS(739), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7734] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 1,
      anon_sym_RBRACE,
    ACTIONS(743), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7751] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(749), 1,
      anon_sym_RBRACE,
    ACTIONS(747), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7768] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(753), 1,
      anon_sym_RBRACE,
    ACTIONS(751), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(757), 1,
      anon_sym_RBRACE,
    ACTIONS(755), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7802] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    STATE(254), 1,
      sym_generics,
    ACTIONS(759), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [7821] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(763), 1,
      anon_sym_DOT,
    STATE(233), 1,
      aux_sym__annotation_call_repeat1,
    ACTIONS(761), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [7840] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 1,
      anon_sym_RBRACE,
    ACTIONS(766), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(772), 1,
      anon_sym_RBRACE,
    ACTIONS(770), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7874] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 1,
      anon_sym_RBRACE,
    ACTIONS(774), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7891] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(780), 1,
      anon_sym_RBRACE,
    ACTIONS(778), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(784), 1,
      anon_sym_RBRACE,
    ACTIONS(782), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7925] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(788), 1,
      anon_sym_RBRACE,
    ACTIONS(786), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7942] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(792), 1,
      anon_sym_RBRACE,
    ACTIONS(790), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 1,
      anon_sym_RBRACE,
    ACTIONS(794), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7976] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(800), 1,
      anon_sym_RBRACE,
    ACTIONS(798), 8,
      anon_sym_using,
      anon_sym_annotation,
      anon_sym_const,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      anon_sym_union,
      sym_identifier,
  [7993] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_DOT,
    STATE(249), 1,
      aux_sym_custom_type_repeat1,
    ACTIONS(802), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8011] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(49), 1,
      anon_sym_BQUOTE,
    STATE(247), 1,
      aux_sym_block_text_repeat2,
    ACTIONS(804), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8029] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_DOT,
    STATE(248), 1,
      aux_sym_custom_type_repeat1,
    ACTIONS(802), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8047] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 8,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8061] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(810), 1,
      anon_sym_BQUOTE,
    STATE(247), 1,
      aux_sym_block_text_repeat2,
    ACTIONS(808), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8079] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 1,
      anon_sym_DOT,
    STATE(248), 1,
      aux_sym_custom_type_repeat1,
    ACTIONS(813), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8097] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_DOT,
    STATE(248), 1,
      aux_sym_custom_type_repeat1,
    ACTIONS(818), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8115] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(822), 1,
      anon_sym_DOLLAR,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
    ACTIONS(820), 5,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8132] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      sym__identifier_no_period,
    ACTIONS(825), 5,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8149] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      sym__identifier_no_period,
    ACTIONS(831), 5,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8166] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 1,
      anon_sym_DOT,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_EQ,
    STATE(243), 1,
      sym_generics,
    STATE(245), 1,
      aux_sym_custom_type_repeat1,
    ACTIONS(621), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [8189] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(835), 7,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8202] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      sym_unique_id,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(841), 1,
      anon_sym_LBRACE,
    ACTIONS(843), 1,
      anon_sym_extends,
    STATE(352), 1,
      sym_generics,
    STATE(429), 1,
      aux_sym_annotation_repeat1,
  [8227] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8239] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8251] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(847), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(849), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8275] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(851), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8287] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(853), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8299] = 5,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(855), 1,
      anon_sym_DQUOTE,
    ACTIONS(857), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(859), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(278), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [8317] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8329] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8341] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(865), 1,
      anon_sym_SEMI,
    ACTIONS(867), 1,
      anon_sym_DASH_GT,
    STATE(337), 1,
      sym_generics,
    STATE(412), 1,
      aux_sym_annotation_repeat1,
  [8363] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(869), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8375] = 5,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(855), 1,
      anon_sym_SQUOTE,
    ACTIONS(871), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(873), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(281), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [8393] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8405] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8417] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(877), 1,
      anon_sym_SEMI,
    ACTIONS(879), 1,
      anon_sym_DASH_GT,
    STATE(361), 1,
      sym_generics,
    STATE(414), 1,
      aux_sym_annotation_repeat1,
  [8439] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(881), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8451] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(883), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8463] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(885), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8475] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(887), 1,
      sym_unique_id,
    ACTIONS(889), 1,
      anon_sym_LBRACE,
    STATE(369), 1,
      sym_generics,
    STATE(439), 1,
      aux_sym_annotation_repeat1,
  [8497] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(597), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8509] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(891), 6,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
      anon_sym_COLON,
      anon_sym_LBRACK,
      sym_identifier,
  [8521] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(893), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8533] = 5,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(895), 1,
      anon_sym_DQUOTE,
    ACTIONS(897), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(899), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(286), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [8551] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8563] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(901), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8575] = 5,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(895), 1,
      anon_sym_SQUOTE,
    ACTIONS(903), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(905), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(285), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [8593] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8605] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(907), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8617] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(909), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8629] = 5,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(911), 1,
      anon_sym_SQUOTE,
    ACTIONS(913), 1,
      sym_unescaped_single_string_fragment,
    ACTIONS(916), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(285), 2,
      sym__escape_sequence,
      aux_sym_string_repeat2,
  [8647] = 5,
    ACTIONS(491), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_DQUOTE,
    ACTIONS(921), 1,
      sym_unescaped_double_string_fragment,
    ACTIONS(924), 2,
      aux_sym__escape_sequence_token1,
      sym_escape_sequence,
    STATE(286), 2,
      sym__escape_sequence,
      aux_sym_string_repeat1,
  [8665] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(927), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [8677] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(929), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8689] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(931), 1,
      anon_sym_EQ,
    ACTIONS(933), 1,
      anon_sym_RPAREN,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    STATE(354), 1,
      sym_generics,
    STATE(416), 1,
      aux_sym_named_return_type_repeat1,
  [8711] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(937), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [8723] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(939), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8735] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(941), 1,
      anon_sym_LBRACE,
    ACTIONS(943), 1,
      anon_sym_extends,
    STATE(367), 1,
      sym_generics,
    STATE(469), 1,
      aux_sym_annotation_repeat1,
  [8757] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(945), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DOLLAR,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      sym_identifier,
  [8769] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_identifier,
    ACTIONS(949), 1,
      anon_sym_LPAREN,
    STATE(350), 1,
      sym_unnamed_return_type,
    STATE(497), 1,
      sym_return_type,
    STATE(523), 1,
      sym_named_return_types,
  [8788] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 1,
      anon_sym_RBRACE,
    ACTIONS(951), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8801] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(957), 1,
      anon_sym_RBRACE,
    ACTIONS(955), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8814] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      sym__identifier_no_period,
    ACTIONS(825), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      sym_identifier,
  [8829] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      sym__identifier_no_period,
    ACTIONS(831), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      sym_identifier,
  [8844] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(963), 1,
      anon_sym_RBRACE,
    ACTIONS(961), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8857] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      anon_sym_EQ,
    STATE(379), 1,
      sym_generics,
    ACTIONS(967), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [8874] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      anon_sym_RBRACE,
    ACTIONS(969), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8887] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_RBRACE,
    ACTIONS(973), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8900] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(979), 1,
      anon_sym_RBRACE,
    ACTIONS(977), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(983), 1,
      anon_sym_RBRACE,
    ACTIONS(981), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(987), 1,
      anon_sym_RBRACE,
    ACTIONS(985), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(991), 1,
      anon_sym_RBRACE,
    ACTIONS(989), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8952] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(995), 1,
      anon_sym_RBRACE,
    ACTIONS(993), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8965] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(999), 1,
      anon_sym_RBRACE,
    ACTIONS(997), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [8978] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1001), 1,
      anon_sym_EQ,
    STATE(316), 1,
      aux_sym_annotation_repeat1,
    ACTIONS(1003), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [8995] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 1,
      anon_sym_COLON,
    ACTIONS(1007), 1,
      sym__normal_version,
    ACTIONS(1009), 1,
      aux_sym__inline_version_token1,
    STATE(276), 1,
      sym__inline_version,
    STATE(592), 1,
      sym_field_version,
  [9014] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1011), 1,
      sym_identifier,
    ACTIONS(1013), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      anon_sym_LBRACK,
    STATE(357), 1,
      sym_method_parameters,
    STATE(464), 1,
      sym_implicit_generics,
  [9033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1019), 1,
      anon_sym_RBRACE,
    ACTIONS(1017), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9046] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1023), 1,
      anon_sym_RBRACE,
    ACTIONS(1021), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1027), 1,
      anon_sym_RBRACE,
    ACTIONS(1025), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9072] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1031), 1,
      anon_sym_RBRACE,
    ACTIONS(1029), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9085] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1033), 1,
      anon_sym_EQ,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
    ACTIONS(1035), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [9102] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1039), 1,
      anon_sym_RBRACE,
    ACTIONS(1037), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9115] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_identifier,
    ACTIONS(949), 1,
      anon_sym_LPAREN,
    STATE(350), 1,
      sym_unnamed_return_type,
    STATE(467), 1,
      sym_return_type,
    STATE(523), 1,
      sym_named_return_types,
  [9134] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1043), 1,
      anon_sym_RBRACE,
    ACTIONS(1041), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9147] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_RBRACE,
    ACTIONS(1045), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9160] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_identifier,
    ACTIONS(949), 1,
      anon_sym_LPAREN,
    STATE(350), 1,
      sym_unnamed_return_type,
    STATE(409), 1,
      sym_return_type,
    STATE(523), 1,
      sym_named_return_types,
  [9179] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1005), 1,
      anon_sym_COLON,
    ACTIONS(1007), 1,
      sym__normal_version,
    ACTIONS(1009), 1,
      aux_sym__inline_version_token1,
    STATE(276), 1,
      sym__inline_version,
    STATE(599), 1,
      sym_field_version,
  [9198] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1051), 1,
      anon_sym_RBRACE,
    ACTIONS(1049), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9211] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1055), 1,
      anon_sym_RBRACE,
    ACTIONS(1053), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9224] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym__normal_version,
    ACTIONS(1009), 1,
      aux_sym__inline_version_token1,
    ACTIONS(1057), 1,
      anon_sym_LBRACE,
    STATE(276), 1,
      sym__inline_version,
    STATE(596), 1,
      sym_field_version,
  [9243] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1061), 1,
      anon_sym_RBRACE,
    ACTIONS(1059), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9256] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1065), 1,
      anon_sym_RBRACE,
    ACTIONS(1063), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9269] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(1067), 1,
      anon_sym_RPAREN,
    STATE(192), 2,
      sym_string,
      aux_sym_concatenated_string_repeat1,
  [9286] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_identifier,
    ACTIONS(949), 1,
      anon_sym_LPAREN,
    STATE(350), 1,
      sym_unnamed_return_type,
    STATE(402), 1,
      sym_return_type,
    STATE(523), 1,
      sym_named_return_types,
  [9305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1071), 1,
      anon_sym_RBRACE,
    ACTIONS(1069), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9318] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_identifier,
    ACTIONS(949), 1,
      anon_sym_LPAREN,
    STATE(350), 1,
      sym_unnamed_return_type,
    STATE(476), 1,
      sym_return_type,
    STATE(523), 1,
      sym_named_return_types,
  [9337] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1075), 1,
      anon_sym_RBRACE,
    ACTIONS(1073), 4,
      anon_sym_enum,
      anon_sym_interface,
      anon_sym_struct,
      sym_identifier,
  [9350] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(947), 1,
      sym_identifier,
    ACTIONS(949), 1,
      anon_sym_LPAREN,
    STATE(350), 1,
      sym_unnamed_return_type,
    STATE(471), 1,
      sym_return_type,
    STATE(523), 1,
      sym_named_return_types,
  [9369] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1079), 1,
      anon_sym_COMMA,
    STATE(360), 1,
      aux_sym_generic_parameters_repeat1,
    ACTIONS(1077), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9383] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym__normal_version,
    ACTIONS(1009), 1,
      aux_sym__inline_version_token1,
    STATE(276), 1,
      sym__inline_version,
    STATE(501), 1,
      sym_field_version,
  [9399] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1081), 1,
      sym_identifier,
    ACTIONS(1083), 1,
      anon_sym_import,
    STATE(598), 2,
      sym_replace_using,
      sym_import_using,
  [9413] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1085), 1,
      anon_sym_SEMI,
    ACTIONS(1087), 1,
      anon_sym_DASH_GT,
    STATE(407), 1,
      aux_sym_annotation_repeat1,
  [9429] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1091), 1,
      anon_sym_COMMA,
    STATE(338), 1,
      aux_sym__annotation_array_def_repeat1,
    ACTIONS(1089), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9443] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1094), 1,
      sym_identifier,
    ACTIONS(1097), 1,
      anon_sym_RBRACE,
    STATE(339), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9457] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 1,
      sym_identifier,
    STATE(372), 1,
      aux_sym__annotation_array_def_repeat1,
    ACTIONS(1101), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [9471] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      sym_identifier,
    ACTIONS(1105), 1,
      anon_sym_RBRACE,
    STATE(347), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9485] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1107), 1,
      anon_sym_SEMI,
    ACTIONS(1109), 1,
      anon_sym_COLON,
    STATE(505), 1,
      aux_sym_annotation_repeat1,
  [9501] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1111), 1,
      anon_sym_SEMI,
    ACTIONS(1113), 1,
      anon_sym_DASH_GT,
    STATE(417), 1,
      aux_sym_annotation_repeat1,
  [9517] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      sym_identifier,
    ACTIONS(1115), 1,
      anon_sym_RBRACE,
    STATE(346), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9531] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      sym_identifier,
    ACTIONS(1117), 1,
      anon_sym_RBRACE,
    STATE(339), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9545] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      sym_identifier,
    ACTIONS(1119), 1,
      anon_sym_RBRACE,
    STATE(339), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9559] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      sym_identifier,
    ACTIONS(1121), 1,
      anon_sym_RBRACE,
    STATE(339), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9573] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1123), 1,
      anon_sym_SEMI,
    ACTIONS(1125), 1,
      anon_sym_EQ,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [9589] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1127), 1,
      anon_sym_SEMI,
    ACTIONS(1129), 1,
      anon_sym_COLON,
    STATE(463), 1,
      aux_sym_annotation_repeat1,
  [9605] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    STATE(540), 1,
      sym_generics,
    ACTIONS(1131), 2,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
  [9619] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      sym_identifier,
    ACTIONS(1105), 1,
      anon_sym_RBRACE,
    STATE(339), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9633] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(941), 1,
      anon_sym_LBRACE,
    ACTIONS(943), 1,
      anon_sym_extends,
    STATE(475), 1,
      aux_sym_annotation_repeat1,
  [9649] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1133), 1,
      sym_unique_id,
    ACTIONS(1135), 1,
      anon_sym_LBRACE,
    STATE(426), 1,
      aux_sym_annotation_repeat1,
  [9665] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(1137), 1,
      anon_sym_EQ,
    ACTIONS(1139), 1,
      anon_sym_RPAREN,
    STATE(403), 1,
      aux_sym_named_return_type_repeat1,
  [9681] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1143), 1,
      anon_sym_COMMA,
    STATE(371), 1,
      aux_sym__annotation_array_def_repeat2,
    ACTIONS(1141), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9695] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      sym_identifier,
    ACTIONS(1145), 1,
      anon_sym_RBRACE,
    STATE(351), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9709] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1147), 1,
      anon_sym_SEMI,
    ACTIONS(1149), 1,
      anon_sym_DASH_GT,
    STATE(411), 1,
      aux_sym_annotation_repeat1,
  [9725] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1151), 1,
      sym_identifier,
    ACTIONS(1153), 1,
      anon_sym_RPAREN,
    STATE(415), 1,
      sym_parameter,
    STATE(590), 1,
      sym_parameters,
  [9741] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1155), 1,
      anon_sym_SEMI,
    ACTIONS(1157), 1,
      anon_sym_EQ,
    STATE(436), 1,
      aux_sym_annotation_repeat1,
  [9757] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1161), 1,
      anon_sym_COMMA,
    STATE(360), 1,
      aux_sym_generic_parameters_repeat1,
    ACTIONS(1159), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9771] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1164), 1,
      anon_sym_SEMI,
    ACTIONS(1166), 1,
      anon_sym_DASH_GT,
    STATE(474), 1,
      aux_sym_annotation_repeat1,
  [9787] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1007), 1,
      sym__normal_version,
    ACTIONS(1009), 1,
      aux_sym__inline_version_token1,
    STATE(276), 1,
      sym__inline_version,
    STATE(311), 1,
      sym_field_version,
  [9803] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1168), 1,
      anon_sym_SEMI,
    ACTIONS(1170), 1,
      anon_sym_EQ,
    STATE(348), 1,
      aux_sym_annotation_repeat1,
  [9819] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 1,
      anon_sym_COMMA,
    STATE(372), 1,
      aux_sym__annotation_array_def_repeat1,
    ACTIONS(1101), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9833] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_COMMA,
    STATE(365), 1,
      aux_sym_annotation_array_repeat1,
    ACTIONS(1174), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9847] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1079), 1,
      anon_sym_COMMA,
    STATE(334), 1,
      aux_sym_generic_parameters_repeat1,
    ACTIONS(1179), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9861] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1181), 1,
      anon_sym_LBRACE,
    ACTIONS(1183), 1,
      anon_sym_extends,
    STATE(500), 1,
      aux_sym_annotation_repeat1,
  [9877] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      sym_identifier,
    ACTIONS(1185), 1,
      anon_sym_RBRACE,
    STATE(345), 2,
      sym_enum_field,
      aux_sym_enum_repeat1,
  [9891] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1187), 1,
      sym_unique_id,
    ACTIONS(1189), 1,
      anon_sym_LBRACE,
    STATE(485), 1,
      aux_sym_annotation_repeat1,
  [9907] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1193), 1,
      anon_sym_COMMA,
    STATE(370), 1,
      aux_sym__annotation_array_def_repeat2,
    ACTIONS(1191), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [9921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(370), 1,
      aux_sym__annotation_array_def_repeat2,
    ACTIONS(83), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [9933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(338), 1,
      aux_sym__annotation_array_def_repeat1,
    ACTIONS(1196), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [9945] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    ACTIONS(1198), 1,
      anon_sym_LPAREN,
    STATE(524), 1,
      sym_string,
  [9961] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1200), 1,
      anon_sym_RPAREN,
    ACTIONS(1202), 1,
      anon_sym_COMMA,
    STATE(380), 1,
      aux_sym_annotation_array_repeat1,
  [9974] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1191), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [9983] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1204), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      sym_identifier,
  [9992] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 1,
      anon_sym_RPAREN,
    ACTIONS(1172), 1,
      anon_sym_COMMA,
    STATE(447), 1,
      aux_sym__annotation_array_def_repeat1,
  [10005] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1206), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10014] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1208), 1,
      anon_sym_EQ,
    ACTIONS(1210), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [10025] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1202), 1,
      anon_sym_COMMA,
    ACTIONS(1212), 1,
      anon_sym_RPAREN,
    STATE(365), 1,
      aux_sym_annotation_array_repeat1,
  [10038] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1214), 1,
      anon_sym_RPAREN,
    ACTIONS(1216), 1,
      anon_sym_COMMA,
    STATE(381), 1,
      aux_sym_top_level_annotation_body_repeat1,
  [10051] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1202), 1,
      anon_sym_COMMA,
    ACTIONS(1212), 1,
      anon_sym_RBRACK,
    STATE(365), 1,
      aux_sym_annotation_array_repeat1,
  [10064] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(370), 1,
      aux_sym__annotation_array_def_repeat2,
    ACTIONS(83), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10075] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 1,
      anon_sym_RPAREN,
    ACTIONS(1172), 1,
      anon_sym_COMMA,
    STATE(447), 1,
      aux_sym__annotation_array_def_repeat1,
  [10088] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
    STATE(399), 1,
      aux_sym_named_return_type_repeat1,
  [10101] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(421), 1,
      sym_string,
  [10114] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1221), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10123] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(1223), 1,
      anon_sym_RPAREN,
    STATE(385), 1,
      aux_sym_named_return_type_repeat1,
  [10136] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1225), 1,
      anon_sym_LBRACE,
    STATE(433), 1,
      aux_sym_annotation_repeat1,
  [10149] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1227), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10162] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1229), 1,
      anon_sym_LBRACE,
    STATE(454), 1,
      aux_sym_annotation_repeat1,
  [10175] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(456), 1,
      aux_sym_annotation_repeat1,
  [10188] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(1223), 1,
      anon_sym_RPAREN,
    STATE(399), 1,
      aux_sym_named_return_type_repeat1,
  [10201] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(431), 1,
      sym_string,
  [10214] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1233), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10227] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1235), 3,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DASH_GT,
  [10236] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1239), 1,
      anon_sym_RBRACE,
    ACTIONS(1237), 2,
      anon_sym_union,
      sym_identifier,
  [10247] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1241), 1,
      anon_sym_RPAREN,
    ACTIONS(1243), 1,
      anon_sym_COMMA,
    STATE(460), 1,
      aux_sym_parameters_repeat1,
  [10260] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1245), 1,
      anon_sym_RPAREN,
    ACTIONS(1247), 1,
      anon_sym_COMMA,
    STATE(399), 1,
      aux_sym_named_return_type_repeat1,
  [10273] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1250), 1,
      sym_identifier,
    ACTIONS(1252), 1,
      anon_sym_RPAREN,
    STATE(555), 1,
      sym_named_return_type,
  [10286] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1254), 3,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_DOLLAR,
  [10295] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1256), 1,
      anon_sym_SEMI,
    STATE(465), 1,
      aux_sym_annotation_repeat1,
  [10308] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(1258), 1,
      anon_sym_RPAREN,
    STATE(399), 1,
      aux_sym_named_return_type_repeat1,
  [10321] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1260), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10334] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(1258), 1,
      anon_sym_RPAREN,
    STATE(393), 1,
      aux_sym_named_return_type_repeat1,
  [10347] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(581), 1,
      sym_string,
  [10360] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1262), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10373] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1264), 1,
      anon_sym_LBRACE,
    STATE(422), 1,
      aux_sym_annotation_repeat1,
  [10386] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1266), 1,
      anon_sym_SEMI,
    STATE(470), 1,
      aux_sym_annotation_repeat1,
  [10399] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1268), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10412] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1270), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10425] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1272), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1276), 1,
      anon_sym_RBRACE,
    ACTIONS(1274), 2,
      anon_sym_union,
      sym_identifier,
  [10449] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1278), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10462] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1243), 1,
      anon_sym_COMMA,
    ACTIONS(1280), 1,
      anon_sym_RPAREN,
    STATE(398), 1,
      aux_sym_parameters_repeat1,
  [10475] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(1139), 1,
      anon_sym_RPAREN,
    STATE(399), 1,
      aux_sym_named_return_type_repeat1,
  [10488] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1282), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10501] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1284), 1,
      sym_unique_id,
    ACTIONS(1286), 1,
      anon_sym_LPAREN,
    STATE(349), 1,
      sym_annotation_targets,
  [10514] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1288), 3,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DASH_GT,
  [10523] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(1290), 1,
      anon_sym_RPAREN,
    STATE(605), 1,
      sym_generics,
  [10536] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1292), 1,
      anon_sym_SEMI,
    ACTIONS(1294), 1,
      anon_sym_DOT,
    STATE(445), 1,
      aux_sym_import_using_repeat1,
  [10549] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1296), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10562] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1298), 1,
      anon_sym_LBRACE,
    STATE(390), 1,
      aux_sym_annotation_repeat1,
  [10575] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1300), 1,
      anon_sym_LBRACE,
    STATE(466), 1,
      aux_sym_annotation_repeat1,
  [10588] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1302), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10597] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1304), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10610] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    ACTIONS(1306), 1,
      anon_sym_COMMA,
    STATE(370), 1,
      aux_sym__annotation_array_def_repeat2,
  [10623] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1200), 1,
      anon_sym_RBRACK,
    ACTIONS(1202), 1,
      anon_sym_COMMA,
    STATE(382), 1,
      aux_sym_annotation_array_repeat1,
  [10636] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1308), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10649] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1312), 1,
      anon_sym_RBRACE,
    ACTIONS(1310), 2,
      anon_sym_union,
      sym_identifier,
  [10660] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 1,
      anon_sym_DOT,
    ACTIONS(1314), 1,
      anon_sym_SEMI,
    STATE(492), 1,
      aux_sym_import_using_repeat1,
  [10673] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1316), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10686] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1318), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10699] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1320), 1,
      anon_sym_SEMI,
    STATE(498), 1,
      aux_sym_annotation_repeat1,
  [10712] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1322), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10725] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1324), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10738] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1326), 1,
      anon_sym_RPAREN,
    ACTIONS(1328), 1,
      anon_sym_COMMA,
    STATE(381), 1,
      aux_sym_top_level_annotation_body_repeat1,
  [10751] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1189), 1,
      anon_sym_LBRACE,
    STATE(479), 1,
      aux_sym_annotation_repeat1,
  [10764] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1330), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10777] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1332), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10790] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1334), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10803] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1174), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10812] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1336), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [10821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1338), 1,
      anon_sym_COMMA,
    ACTIONS(1099), 2,
      anon_sym_RPAREN,
      sym_identifier,
  [10832] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 1,
      anon_sym_DOT,
    ACTIONS(1340), 1,
      anon_sym_SEMI,
    STATE(491), 1,
      aux_sym_import_using_repeat1,
  [10845] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(584), 1,
      sym_string,
  [10858] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 1,
      anon_sym_COMMA,
    ACTIONS(1196), 1,
      anon_sym_RPAREN,
    STATE(338), 1,
      aux_sym__annotation_array_def_repeat1,
  [10871] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1101), 1,
      anon_sym_RPAREN,
    ACTIONS(1172), 1,
      anon_sym_COMMA,
    STATE(447), 1,
      aux_sym__annotation_array_def_repeat1,
  [10884] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(607), 1,
      sym_string,
  [10897] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1342), 1,
      anon_sym_LBRACE,
    STATE(395), 1,
      aux_sym_annotation_repeat1,
  [10910] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1344), 1,
      anon_sym_LBRACE,
    STATE(404), 1,
      aux_sym_annotation_repeat1,
  [10923] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1348), 1,
      anon_sym_RBRACE,
    ACTIONS(1346), 2,
      anon_sym_union,
      sym_identifier,
  [10934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1352), 1,
      anon_sym_RBRACE,
    ACTIONS(1350), 2,
      anon_sym_union,
      sym_identifier,
  [10945] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1354), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10958] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(1356), 1,
      anon_sym_SEMI,
    STATE(585), 1,
      sym_generics,
  [10971] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1358), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [10984] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1360), 1,
      anon_sym_LBRACE,
    STATE(506), 1,
      aux_sym_annotation_repeat1,
  [10997] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1362), 1,
      anon_sym_LBRACE,
    STATE(410), 1,
      aux_sym_annotation_repeat1,
  [11010] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(55), 1,
      anon_sym_RPAREN,
    ACTIONS(1364), 1,
      sym_identifier,
    STATE(509), 1,
      aux_sym_struct_shorthand_repeat1,
  [11023] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1366), 1,
      anon_sym_RPAREN,
    ACTIONS(1368), 1,
      anon_sym_COMMA,
    STATE(460), 1,
      aux_sym_parameters_repeat1,
  [11036] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(273), 1,
      sym_string,
  [11049] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1371), 1,
      anon_sym_RPAREN,
    ACTIONS(1373), 1,
      anon_sym_COMMA,
    STATE(503), 1,
      aux_sym_annotation_targets_repeat1,
  [11062] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1375), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11075] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1013), 1,
      anon_sym_LPAREN,
    ACTIONS(1377), 1,
      sym_identifier,
    STATE(343), 1,
      sym_method_parameters,
  [11088] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1379), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11101] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1381), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11114] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1383), 1,
      anon_sym_SEMI,
    STATE(508), 1,
      aux_sym_annotation_repeat1,
  [11127] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1385), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11140] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1387), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11153] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1389), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11166] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1391), 1,
      anon_sym_SEMI,
    STATE(441), 1,
      aux_sym_annotation_repeat1,
  [11179] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(1393), 1,
      anon_sym_RPAREN,
    STATE(587), 1,
      sym_generics,
  [11192] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1395), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11205] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1397), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11218] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1399), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11231] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1401), 1,
      anon_sym_SEMI,
    STATE(493), 1,
      aux_sym_annotation_repeat1,
  [11244] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1141), 1,
      anon_sym_RPAREN,
    ACTIONS(1143), 1,
      anon_sym_COMMA,
    STATE(427), 1,
      aux_sym__annotation_array_def_repeat2,
  [11257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1403), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [11266] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1405), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11279] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1407), 1,
      anon_sym_SEMI,
    STATE(432), 1,
      aux_sym_annotation_repeat1,
  [11292] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1409), 1,
      anon_sym_LBRACE,
    STATE(494), 1,
      aux_sym_annotation_repeat1,
  [11305] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1411), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11318] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1413), 1,
      anon_sym_RPAREN,
    ACTIONS(1415), 1,
      anon_sym_COMMA,
    STATE(483), 1,
      aux_sym_annotation_targets_repeat1,
  [11331] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 3,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_COLON,
  [11340] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1420), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11353] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1422), 1,
      anon_sym_SEMI,
    STATE(435), 1,
      aux_sym_annotation_repeat1,
  [11366] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1426), 1,
      anon_sym_RBRACE,
    ACTIONS(1424), 2,
      anon_sym_union,
      sym_identifier,
  [11377] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1328), 1,
      anon_sym_COMMA,
    ACTIONS(1428), 1,
      anon_sym_RPAREN,
    STATE(437), 1,
      aux_sym_top_level_annotation_body_repeat1,
  [11390] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      anon_sym_RBRACK,
    ACTIONS(1430), 1,
      anon_sym_COMMA,
    STATE(370), 1,
      aux_sym__annotation_array_def_repeat2,
  [11403] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1432), 1,
      sym_identifier,
    ACTIONS(1435), 1,
      anon_sym_RPAREN,
    STATE(490), 1,
      aux_sym_struct_shorthand_repeat1,
  [11416] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1437), 1,
      anon_sym_SEMI,
    ACTIONS(1439), 1,
      anon_sym_DOT,
    STATE(491), 1,
      aux_sym_import_using_repeat1,
  [11429] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1294), 1,
      anon_sym_DOT,
    ACTIONS(1442), 1,
      anon_sym_SEMI,
    STATE(491), 1,
      aux_sym_import_using_repeat1,
  [11442] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1444), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11455] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1446), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11468] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1448), 1,
      anon_sym_SEMI,
    STATE(468), 1,
      aux_sym_annotation_repeat1,
  [11481] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_SQUOTE,
    STATE(544), 1,
      sym_string,
  [11494] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1450), 1,
      anon_sym_SEMI,
    STATE(440), 1,
      aux_sym_annotation_repeat1,
  [11507] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1452), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11520] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 1,
      anon_sym_LPAREN,
    ACTIONS(1454), 1,
      anon_sym_RPAREN,
    STATE(562), 1,
      sym_generics,
  [11533] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1456), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11546] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1458), 1,
      anon_sym_SEMI,
    STATE(473), 1,
      aux_sym_annotation_repeat1,
  [11559] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1460), 1,
      anon_sym_SEMI,
    STATE(482), 1,
      aux_sym_annotation_repeat1,
  [11572] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1373), 1,
      anon_sym_COMMA,
    ACTIONS(1462), 1,
      anon_sym_RPAREN,
    STATE(483), 1,
      aux_sym_annotation_targets_repeat1,
  [11585] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 3,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
      anon_sym_COLON,
  [11594] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1466), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11607] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1468), 1,
      anon_sym_LBRACE,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11620] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1470), 1,
      anon_sym_COMMA,
    ACTIONS(1472), 1,
      anon_sym_RBRACK,
    STATE(489), 1,
      aux_sym__annotation_array_def_repeat2,
  [11633] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(839), 1,
      anon_sym_DOLLAR,
    ACTIONS(1474), 1,
      anon_sym_SEMI,
    STATE(250), 1,
      aux_sym_annotation_repeat1,
  [11646] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1364), 1,
      sym_identifier,
    ACTIONS(1476), 1,
      anon_sym_RPAREN,
    STATE(490), 1,
      aux_sym_struct_shorthand_repeat1,
  [11659] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1478), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11667] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1480), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11675] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1482), 1,
      sym__identifier_no_period,
    STATE(512), 1,
      aux_sym__internal_const_identifier_repeat1,
  [11685] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1485), 1,
      aux_sym_top_level_annotation_body_token1,
    STATE(589), 1,
      sym_top_level_annotation_body,
  [11695] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1487), 1,
      sym__identifier_no_period,
    STATE(512), 1,
      aux_sym__internal_const_identifier_repeat1,
  [11705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1489), 1,
      sym_identifier,
    STATE(418), 1,
      sym__annotation_definition_identifier,
  [11715] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1491), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11723] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1493), 2,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
  [11731] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1495), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11739] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1497), 2,
      anon_sym_RPAREN,
      sym_identifier,
  [11747] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1151), 1,
      sym_identifier,
    STATE(538), 1,
      sym_parameter,
  [11757] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1499), 1,
      anon_sym_SEMI,
    ACTIONS(1501), 1,
      anon_sym_EQ,
  [11767] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1503), 2,
      anon_sym_LPAREN,
      sym_identifier,
  [11775] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 2,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
  [11783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1505), 1,
      anon_sym_SEMI,
    ACTIONS(1507), 1,
      anon_sym_DOT,
  [11793] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1509), 1,
      anon_sym_group,
    ACTIONS(1511), 1,
      anon_sym_union,
  [11803] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1513), 1,
      anon_sym_SEMI,
    ACTIONS(1515), 1,
      anon_sym_LPAREN,
  [11813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1517), 1,
      sym_unique_id,
    ACTIONS(1519), 1,
      anon_sym_COLON,
  [11823] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1521), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11831] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1523), 2,
      anon_sym_RBRACE,
      sym_identifier,
  [11839] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1525), 2,
      anon_sym_SEMI,
      anon_sym_DOT,
  [11847] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1527), 1,
      sym_identifier,
    ACTIONS(1529), 1,
      anon_sym_import,
  [11857] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1286), 1,
      anon_sym_LPAREN,
    STATE(342), 1,
      sym_annotation_targets,
  [11867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      sym__identifier_no_period,
  [11877] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1413), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1531), 1,
      sym__identifier_no_period,
    STATE(512), 1,
      aux_sym__internal_const_identifier_repeat1,
  [11895] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1533), 1,
      anon_sym_SEMI,
    ACTIONS(1535), 1,
      anon_sym_DOT,
  [11905] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1537), 2,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
  [11913] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1366), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1539), 1,
      sym__normal_version,
    ACTIONS(1541), 1,
      aux_sym__inline_version_token1,
  [11931] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1543), 2,
      anon_sym_SEMI,
      anon_sym_DOLLAR,
  [11939] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1545), 2,
      anon_sym_RBRACE,
      sym_identifier,
  [11947] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1547), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [11955] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
  [11962] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1549), 1,
      anon_sym_RPAREN,
  [11969] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1551), 1,
      anon_sym_RPAREN,
  [11976] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1553), 1,
      sym_identifier,
  [11983] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1555), 1,
      sym_identifier,
  [11990] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1557), 1,
      anon_sym_RPAREN,
  [11997] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1559), 1,
      sym_identifier,
  [12004] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1561), 1,
      anon_sym_LPAREN,
  [12011] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
  [12018] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1563), 1,
      anon_sym_LPAREN,
  [12025] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1565), 1,
      anon_sym_EQ,
  [12032] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1567), 1,
      anon_sym_LPAREN,
  [12039] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1569), 1,
      anon_sym_RPAREN,
  [12046] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1571), 1,
      anon_sym_EQ,
  [12053] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1573), 1,
      anon_sym_COLON,
  [12060] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1575), 1,
      aux_sym_data_token1,
  [12067] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1577), 1,
      anon_sym_RPAREN,
  [12074] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1579), 1,
      anon_sym_SEMI,
  [12081] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1581), 1,
      anon_sym_LPAREN,
  [12088] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1583), 1,
      anon_sym_RPAREN,
  [12095] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1585), 1,
      sym_identifier,
  [12102] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1587), 1,
      sym_identifier,
  [12109] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1589), 1,
      anon_sym_SEMI,
  [12116] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1591), 1,
      anon_sym_SEMI,
  [12123] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1593), 1,
      sym_identifier,
  [12130] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1595), 1,
      anon_sym_SEMI,
  [12137] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1597), 1,
      anon_sym_SEMI,
  [12144] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1599), 1,
      anon_sym_EQ,
  [12151] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1601), 1,
      anon_sym_LPAREN,
  [12158] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1603), 1,
      anon_sym_EQ,
  [12165] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1605), 1,
      sym_identifier,
  [12172] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1607), 1,
      anon_sym_RPAREN,
  [12179] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1609), 1,
      anon_sym_EQ,
  [12186] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(59), 1,
      anon_sym_RPAREN,
  [12193] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(73), 1,
      anon_sym_RPAREN,
  [12200] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1611), 1,
      anon_sym_COLON,
  [12207] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1613), 1,
      sym_identifier,
  [12214] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1615), 1,
      anon_sym_namespace,
  [12221] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1617), 1,
      anon_sym_RPAREN,
  [12228] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1057), 1,
      anon_sym_LBRACE,
  [12235] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1619), 1,
      anon_sym_SEMI,
  [12242] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_SEMI,
  [12249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1623), 1,
      anon_sym_SEMI,
  [12256] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1625), 1,
      sym_identifier,
  [12263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1627), 1,
      anon_sym_RPAREN,
  [12270] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1629), 1,
      anon_sym_COLON,
  [12277] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1631), 1,
      anon_sym_SEMI,
  [12284] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1633), 1,
      anon_sym_RPAREN,
  [12291] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      anon_sym_SEMI,
  [12298] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1637), 1,
      anon_sym_COLON,
  [12305] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1639), 1,
      anon_sym_namespace,
  [12312] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1641), 1,
      anon_sym_RPAREN,
  [12319] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      anon_sym_RBRACK,
  [12326] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1645), 1,
      anon_sym_COLON,
  [12333] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1647), 1,
      anon_sym_COLON,
  [12340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1649), 1,
      anon_sym_SEMI,
  [12347] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1651), 1,
      anon_sym_COLON,
  [12354] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1653), 1,
      anon_sym_EQ,
  [12361] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1655), 1,
      anon_sym_LPAREN,
  [12368] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1657), 1,
      anon_sym_EQ,
  [12375] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1659), 1,
      sym_identifier,
  [12382] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1661), 1,
      sym_identifier,
  [12389] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1663), 1,
      anon_sym_RPAREN,
  [12396] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1665), 1,
      anon_sym_RPAREN,
  [12403] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1667), 1,
      anon_sym_RPAREN,
  [12410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1669), 1,
      ts_builtin_sym_end,
  [12417] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1671), 1,
      anon_sym_EQ,
  [12424] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1673), 1,
      anon_sym_EQ,
  [12431] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1675), 1,
      sym_identifier,
  [12438] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1677), 1,
      anon_sym_SEMI,
  [12445] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1679), 1,
      sym_identifier,
  [12452] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1681), 1,
      sym_identifier,
  [12459] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1683), 1,
      sym_identifier,
  [12466] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1685), 1,
      sym_identifier,
  [12473] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1687), 1,
      sym__identifier_no_period,
  [12480] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1689), 1,
      anon_sym_SEMI,
  [12487] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1691), 1,
      anon_sym_SEMI,
  [12494] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1693), 1,
      anon_sym_EQ,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 102,
  [SMALL_STATE(4)] = 176,
  [SMALL_STATE(5)] = 247,
  [SMALL_STATE(6)] = 318,
  [SMALL_STATE(7)] = 387,
  [SMALL_STATE(8)] = 458,
  [SMALL_STATE(9)] = 529,
  [SMALL_STATE(10)] = 600,
  [SMALL_STATE(11)] = 671,
  [SMALL_STATE(12)] = 742,
  [SMALL_STATE(13)] = 810,
  [SMALL_STATE(14)] = 874,
  [SMALL_STATE(15)] = 938,
  [SMALL_STATE(16)] = 1003,
  [SMALL_STATE(17)] = 1066,
  [SMALL_STATE(18)] = 1128,
  [SMALL_STATE(19)] = 1190,
  [SMALL_STATE(20)] = 1252,
  [SMALL_STATE(21)] = 1314,
  [SMALL_STATE(22)] = 1373,
  [SMALL_STATE(23)] = 1432,
  [SMALL_STATE(24)] = 1491,
  [SMALL_STATE(25)] = 1550,
  [SMALL_STATE(26)] = 1609,
  [SMALL_STATE(27)] = 1668,
  [SMALL_STATE(28)] = 1727,
  [SMALL_STATE(29)] = 1786,
  [SMALL_STATE(30)] = 1845,
  [SMALL_STATE(31)] = 1904,
  [SMALL_STATE(32)] = 1963,
  [SMALL_STATE(33)] = 2022,
  [SMALL_STATE(34)] = 2081,
  [SMALL_STATE(35)] = 2140,
  [SMALL_STATE(36)] = 2199,
  [SMALL_STATE(37)] = 2258,
  [SMALL_STATE(38)] = 2317,
  [SMALL_STATE(39)] = 2376,
  [SMALL_STATE(40)] = 2435,
  [SMALL_STATE(41)] = 2494,
  [SMALL_STATE(42)] = 2551,
  [SMALL_STATE(43)] = 2608,
  [SMALL_STATE(44)] = 2665,
  [SMALL_STATE(45)] = 2722,
  [SMALL_STATE(46)] = 2779,
  [SMALL_STATE(47)] = 2836,
  [SMALL_STATE(48)] = 2893,
  [SMALL_STATE(49)] = 2950,
  [SMALL_STATE(50)] = 3007,
  [SMALL_STATE(51)] = 3064,
  [SMALL_STATE(52)] = 3121,
  [SMALL_STATE(53)] = 3178,
  [SMALL_STATE(54)] = 3235,
  [SMALL_STATE(55)] = 3276,
  [SMALL_STATE(56)] = 3333,
  [SMALL_STATE(57)] = 3390,
  [SMALL_STATE(58)] = 3428,
  [SMALL_STATE(59)] = 3466,
  [SMALL_STATE(60)] = 3504,
  [SMALL_STATE(61)] = 3539,
  [SMALL_STATE(62)] = 3592,
  [SMALL_STATE(63)] = 3645,
  [SMALL_STATE(64)] = 3680,
  [SMALL_STATE(65)] = 3715,
  [SMALL_STATE(66)] = 3750,
  [SMALL_STATE(67)] = 3801,
  [SMALL_STATE(68)] = 3836,
  [SMALL_STATE(69)] = 3871,
  [SMALL_STATE(70)] = 3924,
  [SMALL_STATE(71)] = 3977,
  [SMALL_STATE(72)] = 4030,
  [SMALL_STATE(73)] = 4081,
  [SMALL_STATE(74)] = 4116,
  [SMALL_STATE(75)] = 4151,
  [SMALL_STATE(76)] = 4175,
  [SMALL_STATE(77)] = 4199,
  [SMALL_STATE(78)] = 4220,
  [SMALL_STATE(79)] = 4241,
  [SMALL_STATE(80)] = 4262,
  [SMALL_STATE(81)] = 4283,
  [SMALL_STATE(82)] = 4304,
  [SMALL_STATE(83)] = 4325,
  [SMALL_STATE(84)] = 4346,
  [SMALL_STATE(85)] = 4367,
  [SMALL_STATE(86)] = 4388,
  [SMALL_STATE(87)] = 4409,
  [SMALL_STATE(88)] = 4430,
  [SMALL_STATE(89)] = 4451,
  [SMALL_STATE(90)] = 4472,
  [SMALL_STATE(91)] = 4493,
  [SMALL_STATE(92)] = 4514,
  [SMALL_STATE(93)] = 4535,
  [SMALL_STATE(94)] = 4556,
  [SMALL_STATE(95)] = 4577,
  [SMALL_STATE(96)] = 4598,
  [SMALL_STATE(97)] = 4619,
  [SMALL_STATE(98)] = 4640,
  [SMALL_STATE(99)] = 4661,
  [SMALL_STATE(100)] = 4682,
  [SMALL_STATE(101)] = 4703,
  [SMALL_STATE(102)] = 4724,
  [SMALL_STATE(103)] = 4745,
  [SMALL_STATE(104)] = 4766,
  [SMALL_STATE(105)] = 4787,
  [SMALL_STATE(106)] = 4808,
  [SMALL_STATE(107)] = 4829,
  [SMALL_STATE(108)] = 4850,
  [SMALL_STATE(109)] = 4871,
  [SMALL_STATE(110)] = 4892,
  [SMALL_STATE(111)] = 4913,
  [SMALL_STATE(112)] = 4934,
  [SMALL_STATE(113)] = 4955,
  [SMALL_STATE(114)] = 4976,
  [SMALL_STATE(115)] = 4997,
  [SMALL_STATE(116)] = 5018,
  [SMALL_STATE(117)] = 5039,
  [SMALL_STATE(118)] = 5060,
  [SMALL_STATE(119)] = 5081,
  [SMALL_STATE(120)] = 5102,
  [SMALL_STATE(121)] = 5123,
  [SMALL_STATE(122)] = 5144,
  [SMALL_STATE(123)] = 5165,
  [SMALL_STATE(124)] = 5186,
  [SMALL_STATE(125)] = 5207,
  [SMALL_STATE(126)] = 5228,
  [SMALL_STATE(127)] = 5249,
  [SMALL_STATE(128)] = 5270,
  [SMALL_STATE(129)] = 5291,
  [SMALL_STATE(130)] = 5312,
  [SMALL_STATE(131)] = 5333,
  [SMALL_STATE(132)] = 5354,
  [SMALL_STATE(133)] = 5375,
  [SMALL_STATE(134)] = 5396,
  [SMALL_STATE(135)] = 5417,
  [SMALL_STATE(136)] = 5438,
  [SMALL_STATE(137)] = 5459,
  [SMALL_STATE(138)] = 5480,
  [SMALL_STATE(139)] = 5501,
  [SMALL_STATE(140)] = 5522,
  [SMALL_STATE(141)] = 5543,
  [SMALL_STATE(142)] = 5564,
  [SMALL_STATE(143)] = 5585,
  [SMALL_STATE(144)] = 5609,
  [SMALL_STATE(145)] = 5627,
  [SMALL_STATE(146)] = 5651,
  [SMALL_STATE(147)] = 5675,
  [SMALL_STATE(148)] = 5704,
  [SMALL_STATE(149)] = 5733,
  [SMALL_STATE(150)] = 5762,
  [SMALL_STATE(151)] = 5791,
  [SMALL_STATE(152)] = 5820,
  [SMALL_STATE(153)] = 5849,
  [SMALL_STATE(154)] = 5878,
  [SMALL_STATE(155)] = 5907,
  [SMALL_STATE(156)] = 5936,
  [SMALL_STATE(157)] = 5965,
  [SMALL_STATE(158)] = 5992,
  [SMALL_STATE(159)] = 6021,
  [SMALL_STATE(160)] = 6050,
  [SMALL_STATE(161)] = 6079,
  [SMALL_STATE(162)] = 6108,
  [SMALL_STATE(163)] = 6137,
  [SMALL_STATE(164)] = 6166,
  [SMALL_STATE(165)] = 6195,
  [SMALL_STATE(166)] = 6224,
  [SMALL_STATE(167)] = 6253,
  [SMALL_STATE(168)] = 6282,
  [SMALL_STATE(169)] = 6311,
  [SMALL_STATE(170)] = 6340,
  [SMALL_STATE(171)] = 6369,
  [SMALL_STATE(172)] = 6398,
  [SMALL_STATE(173)] = 6427,
  [SMALL_STATE(174)] = 6456,
  [SMALL_STATE(175)] = 6485,
  [SMALL_STATE(176)] = 6514,
  [SMALL_STATE(177)] = 6543,
  [SMALL_STATE(178)] = 6572,
  [SMALL_STATE(179)] = 6601,
  [SMALL_STATE(180)] = 6630,
  [SMALL_STATE(181)] = 6659,
  [SMALL_STATE(182)] = 6688,
  [SMALL_STATE(183)] = 6717,
  [SMALL_STATE(184)] = 6746,
  [SMALL_STATE(185)] = 6775,
  [SMALL_STATE(186)] = 6804,
  [SMALL_STATE(187)] = 6833,
  [SMALL_STATE(188)] = 6857,
  [SMALL_STATE(189)] = 6887,
  [SMALL_STATE(190)] = 6905,
  [SMALL_STATE(191)] = 6929,
  [SMALL_STATE(192)] = 6947,
  [SMALL_STATE(193)] = 6969,
  [SMALL_STATE(194)] = 6993,
  [SMALL_STATE(195)] = 7017,
  [SMALL_STATE(196)] = 7041,
  [SMALL_STATE(197)] = 7071,
  [SMALL_STATE(198)] = 7089,
  [SMALL_STATE(199)] = 7107,
  [SMALL_STATE(200)] = 7125,
  [SMALL_STATE(201)] = 7155,
  [SMALL_STATE(202)] = 7173,
  [SMALL_STATE(203)] = 7203,
  [SMALL_STATE(204)] = 7233,
  [SMALL_STATE(205)] = 7263,
  [SMALL_STATE(206)] = 7293,
  [SMALL_STATE(207)] = 7311,
  [SMALL_STATE(208)] = 7341,
  [SMALL_STATE(209)] = 7371,
  [SMALL_STATE(210)] = 7393,
  [SMALL_STATE(211)] = 7411,
  [SMALL_STATE(212)] = 7433,
  [SMALL_STATE(213)] = 7463,
  [SMALL_STATE(214)] = 7487,
  [SMALL_STATE(215)] = 7517,
  [SMALL_STATE(216)] = 7534,
  [SMALL_STATE(217)] = 7551,
  [SMALL_STATE(218)] = 7568,
  [SMALL_STATE(219)] = 7585,
  [SMALL_STATE(220)] = 7602,
  [SMALL_STATE(221)] = 7619,
  [SMALL_STATE(222)] = 7636,
  [SMALL_STATE(223)] = 7653,
  [SMALL_STATE(224)] = 7670,
  [SMALL_STATE(225)] = 7685,
  [SMALL_STATE(226)] = 7702,
  [SMALL_STATE(227)] = 7717,
  [SMALL_STATE(228)] = 7734,
  [SMALL_STATE(229)] = 7751,
  [SMALL_STATE(230)] = 7768,
  [SMALL_STATE(231)] = 7785,
  [SMALL_STATE(232)] = 7802,
  [SMALL_STATE(233)] = 7821,
  [SMALL_STATE(234)] = 7840,
  [SMALL_STATE(235)] = 7857,
  [SMALL_STATE(236)] = 7874,
  [SMALL_STATE(237)] = 7891,
  [SMALL_STATE(238)] = 7908,
  [SMALL_STATE(239)] = 7925,
  [SMALL_STATE(240)] = 7942,
  [SMALL_STATE(241)] = 7959,
  [SMALL_STATE(242)] = 7976,
  [SMALL_STATE(243)] = 7993,
  [SMALL_STATE(244)] = 8011,
  [SMALL_STATE(245)] = 8029,
  [SMALL_STATE(246)] = 8047,
  [SMALL_STATE(247)] = 8061,
  [SMALL_STATE(248)] = 8079,
  [SMALL_STATE(249)] = 8097,
  [SMALL_STATE(250)] = 8115,
  [SMALL_STATE(251)] = 8132,
  [SMALL_STATE(252)] = 8149,
  [SMALL_STATE(253)] = 8166,
  [SMALL_STATE(254)] = 8189,
  [SMALL_STATE(255)] = 8202,
  [SMALL_STATE(256)] = 8227,
  [SMALL_STATE(257)] = 8239,
  [SMALL_STATE(258)] = 8251,
  [SMALL_STATE(259)] = 8263,
  [SMALL_STATE(260)] = 8275,
  [SMALL_STATE(261)] = 8287,
  [SMALL_STATE(262)] = 8299,
  [SMALL_STATE(263)] = 8317,
  [SMALL_STATE(264)] = 8329,
  [SMALL_STATE(265)] = 8341,
  [SMALL_STATE(266)] = 8363,
  [SMALL_STATE(267)] = 8375,
  [SMALL_STATE(268)] = 8393,
  [SMALL_STATE(269)] = 8405,
  [SMALL_STATE(270)] = 8417,
  [SMALL_STATE(271)] = 8439,
  [SMALL_STATE(272)] = 8451,
  [SMALL_STATE(273)] = 8463,
  [SMALL_STATE(274)] = 8475,
  [SMALL_STATE(275)] = 8497,
  [SMALL_STATE(276)] = 8509,
  [SMALL_STATE(277)] = 8521,
  [SMALL_STATE(278)] = 8533,
  [SMALL_STATE(279)] = 8551,
  [SMALL_STATE(280)] = 8563,
  [SMALL_STATE(281)] = 8575,
  [SMALL_STATE(282)] = 8593,
  [SMALL_STATE(283)] = 8605,
  [SMALL_STATE(284)] = 8617,
  [SMALL_STATE(285)] = 8629,
  [SMALL_STATE(286)] = 8647,
  [SMALL_STATE(287)] = 8665,
  [SMALL_STATE(288)] = 8677,
  [SMALL_STATE(289)] = 8689,
  [SMALL_STATE(290)] = 8711,
  [SMALL_STATE(291)] = 8723,
  [SMALL_STATE(292)] = 8735,
  [SMALL_STATE(293)] = 8757,
  [SMALL_STATE(294)] = 8769,
  [SMALL_STATE(295)] = 8788,
  [SMALL_STATE(296)] = 8801,
  [SMALL_STATE(297)] = 8814,
  [SMALL_STATE(298)] = 8829,
  [SMALL_STATE(299)] = 8844,
  [SMALL_STATE(300)] = 8857,
  [SMALL_STATE(301)] = 8874,
  [SMALL_STATE(302)] = 8887,
  [SMALL_STATE(303)] = 8900,
  [SMALL_STATE(304)] = 8913,
  [SMALL_STATE(305)] = 8926,
  [SMALL_STATE(306)] = 8939,
  [SMALL_STATE(307)] = 8952,
  [SMALL_STATE(308)] = 8965,
  [SMALL_STATE(309)] = 8978,
  [SMALL_STATE(310)] = 8995,
  [SMALL_STATE(311)] = 9014,
  [SMALL_STATE(312)] = 9033,
  [SMALL_STATE(313)] = 9046,
  [SMALL_STATE(314)] = 9059,
  [SMALL_STATE(315)] = 9072,
  [SMALL_STATE(316)] = 9085,
  [SMALL_STATE(317)] = 9102,
  [SMALL_STATE(318)] = 9115,
  [SMALL_STATE(319)] = 9134,
  [SMALL_STATE(320)] = 9147,
  [SMALL_STATE(321)] = 9160,
  [SMALL_STATE(322)] = 9179,
  [SMALL_STATE(323)] = 9198,
  [SMALL_STATE(324)] = 9211,
  [SMALL_STATE(325)] = 9224,
  [SMALL_STATE(326)] = 9243,
  [SMALL_STATE(327)] = 9256,
  [SMALL_STATE(328)] = 9269,
  [SMALL_STATE(329)] = 9286,
  [SMALL_STATE(330)] = 9305,
  [SMALL_STATE(331)] = 9318,
  [SMALL_STATE(332)] = 9337,
  [SMALL_STATE(333)] = 9350,
  [SMALL_STATE(334)] = 9369,
  [SMALL_STATE(335)] = 9383,
  [SMALL_STATE(336)] = 9399,
  [SMALL_STATE(337)] = 9413,
  [SMALL_STATE(338)] = 9429,
  [SMALL_STATE(339)] = 9443,
  [SMALL_STATE(340)] = 9457,
  [SMALL_STATE(341)] = 9471,
  [SMALL_STATE(342)] = 9485,
  [SMALL_STATE(343)] = 9501,
  [SMALL_STATE(344)] = 9517,
  [SMALL_STATE(345)] = 9531,
  [SMALL_STATE(346)] = 9545,
  [SMALL_STATE(347)] = 9559,
  [SMALL_STATE(348)] = 9573,
  [SMALL_STATE(349)] = 9589,
  [SMALL_STATE(350)] = 9605,
  [SMALL_STATE(351)] = 9619,
  [SMALL_STATE(352)] = 9633,
  [SMALL_STATE(353)] = 9649,
  [SMALL_STATE(354)] = 9665,
  [SMALL_STATE(355)] = 9681,
  [SMALL_STATE(356)] = 9695,
  [SMALL_STATE(357)] = 9709,
  [SMALL_STATE(358)] = 9725,
  [SMALL_STATE(359)] = 9741,
  [SMALL_STATE(360)] = 9757,
  [SMALL_STATE(361)] = 9771,
  [SMALL_STATE(362)] = 9787,
  [SMALL_STATE(363)] = 9803,
  [SMALL_STATE(364)] = 9819,
  [SMALL_STATE(365)] = 9833,
  [SMALL_STATE(366)] = 9847,
  [SMALL_STATE(367)] = 9861,
  [SMALL_STATE(368)] = 9877,
  [SMALL_STATE(369)] = 9891,
  [SMALL_STATE(370)] = 9907,
  [SMALL_STATE(371)] = 9921,
  [SMALL_STATE(372)] = 9933,
  [SMALL_STATE(373)] = 9945,
  [SMALL_STATE(374)] = 9961,
  [SMALL_STATE(375)] = 9974,
  [SMALL_STATE(376)] = 9983,
  [SMALL_STATE(377)] = 9992,
  [SMALL_STATE(378)] = 10005,
  [SMALL_STATE(379)] = 10014,
  [SMALL_STATE(380)] = 10025,
  [SMALL_STATE(381)] = 10038,
  [SMALL_STATE(382)] = 10051,
  [SMALL_STATE(383)] = 10064,
  [SMALL_STATE(384)] = 10075,
  [SMALL_STATE(385)] = 10088,
  [SMALL_STATE(386)] = 10101,
  [SMALL_STATE(387)] = 10114,
  [SMALL_STATE(388)] = 10123,
  [SMALL_STATE(389)] = 10136,
  [SMALL_STATE(390)] = 10149,
  [SMALL_STATE(391)] = 10162,
  [SMALL_STATE(392)] = 10175,
  [SMALL_STATE(393)] = 10188,
  [SMALL_STATE(394)] = 10201,
  [SMALL_STATE(395)] = 10214,
  [SMALL_STATE(396)] = 10227,
  [SMALL_STATE(397)] = 10236,
  [SMALL_STATE(398)] = 10247,
  [SMALL_STATE(399)] = 10260,
  [SMALL_STATE(400)] = 10273,
  [SMALL_STATE(401)] = 10286,
  [SMALL_STATE(402)] = 10295,
  [SMALL_STATE(403)] = 10308,
  [SMALL_STATE(404)] = 10321,
  [SMALL_STATE(405)] = 10334,
  [SMALL_STATE(406)] = 10347,
  [SMALL_STATE(407)] = 10360,
  [SMALL_STATE(408)] = 10373,
  [SMALL_STATE(409)] = 10386,
  [SMALL_STATE(410)] = 10399,
  [SMALL_STATE(411)] = 10412,
  [SMALL_STATE(412)] = 10425,
  [SMALL_STATE(413)] = 10438,
  [SMALL_STATE(414)] = 10449,
  [SMALL_STATE(415)] = 10462,
  [SMALL_STATE(416)] = 10475,
  [SMALL_STATE(417)] = 10488,
  [SMALL_STATE(418)] = 10501,
  [SMALL_STATE(419)] = 10514,
  [SMALL_STATE(420)] = 10523,
  [SMALL_STATE(421)] = 10536,
  [SMALL_STATE(422)] = 10549,
  [SMALL_STATE(423)] = 10562,
  [SMALL_STATE(424)] = 10575,
  [SMALL_STATE(425)] = 10588,
  [SMALL_STATE(426)] = 10597,
  [SMALL_STATE(427)] = 10610,
  [SMALL_STATE(428)] = 10623,
  [SMALL_STATE(429)] = 10636,
  [SMALL_STATE(430)] = 10649,
  [SMALL_STATE(431)] = 10660,
  [SMALL_STATE(432)] = 10673,
  [SMALL_STATE(433)] = 10686,
  [SMALL_STATE(434)] = 10699,
  [SMALL_STATE(435)] = 10712,
  [SMALL_STATE(436)] = 10725,
  [SMALL_STATE(437)] = 10738,
  [SMALL_STATE(438)] = 10751,
  [SMALL_STATE(439)] = 10764,
  [SMALL_STATE(440)] = 10777,
  [SMALL_STATE(441)] = 10790,
  [SMALL_STATE(442)] = 10803,
  [SMALL_STATE(443)] = 10812,
  [SMALL_STATE(444)] = 10821,
  [SMALL_STATE(445)] = 10832,
  [SMALL_STATE(446)] = 10845,
  [SMALL_STATE(447)] = 10858,
  [SMALL_STATE(448)] = 10871,
  [SMALL_STATE(449)] = 10884,
  [SMALL_STATE(450)] = 10897,
  [SMALL_STATE(451)] = 10910,
  [SMALL_STATE(452)] = 10923,
  [SMALL_STATE(453)] = 10934,
  [SMALL_STATE(454)] = 10945,
  [SMALL_STATE(455)] = 10958,
  [SMALL_STATE(456)] = 10971,
  [SMALL_STATE(457)] = 10984,
  [SMALL_STATE(458)] = 10997,
  [SMALL_STATE(459)] = 11010,
  [SMALL_STATE(460)] = 11023,
  [SMALL_STATE(461)] = 11036,
  [SMALL_STATE(462)] = 11049,
  [SMALL_STATE(463)] = 11062,
  [SMALL_STATE(464)] = 11075,
  [SMALL_STATE(465)] = 11088,
  [SMALL_STATE(466)] = 11101,
  [SMALL_STATE(467)] = 11114,
  [SMALL_STATE(468)] = 11127,
  [SMALL_STATE(469)] = 11140,
  [SMALL_STATE(470)] = 11153,
  [SMALL_STATE(471)] = 11166,
  [SMALL_STATE(472)] = 11179,
  [SMALL_STATE(473)] = 11192,
  [SMALL_STATE(474)] = 11205,
  [SMALL_STATE(475)] = 11218,
  [SMALL_STATE(476)] = 11231,
  [SMALL_STATE(477)] = 11244,
  [SMALL_STATE(478)] = 11257,
  [SMALL_STATE(479)] = 11266,
  [SMALL_STATE(480)] = 11279,
  [SMALL_STATE(481)] = 11292,
  [SMALL_STATE(482)] = 11305,
  [SMALL_STATE(483)] = 11318,
  [SMALL_STATE(484)] = 11331,
  [SMALL_STATE(485)] = 11340,
  [SMALL_STATE(486)] = 11353,
  [SMALL_STATE(487)] = 11366,
  [SMALL_STATE(488)] = 11377,
  [SMALL_STATE(489)] = 11390,
  [SMALL_STATE(490)] = 11403,
  [SMALL_STATE(491)] = 11416,
  [SMALL_STATE(492)] = 11429,
  [SMALL_STATE(493)] = 11442,
  [SMALL_STATE(494)] = 11455,
  [SMALL_STATE(495)] = 11468,
  [SMALL_STATE(496)] = 11481,
  [SMALL_STATE(497)] = 11494,
  [SMALL_STATE(498)] = 11507,
  [SMALL_STATE(499)] = 11520,
  [SMALL_STATE(500)] = 11533,
  [SMALL_STATE(501)] = 11546,
  [SMALL_STATE(502)] = 11559,
  [SMALL_STATE(503)] = 11572,
  [SMALL_STATE(504)] = 11585,
  [SMALL_STATE(505)] = 11594,
  [SMALL_STATE(506)] = 11607,
  [SMALL_STATE(507)] = 11620,
  [SMALL_STATE(508)] = 11633,
  [SMALL_STATE(509)] = 11646,
  [SMALL_STATE(510)] = 11659,
  [SMALL_STATE(511)] = 11667,
  [SMALL_STATE(512)] = 11675,
  [SMALL_STATE(513)] = 11685,
  [SMALL_STATE(514)] = 11695,
  [SMALL_STATE(515)] = 11705,
  [SMALL_STATE(516)] = 11715,
  [SMALL_STATE(517)] = 11723,
  [SMALL_STATE(518)] = 11731,
  [SMALL_STATE(519)] = 11739,
  [SMALL_STATE(520)] = 11747,
  [SMALL_STATE(521)] = 11757,
  [SMALL_STATE(522)] = 11767,
  [SMALL_STATE(523)] = 11775,
  [SMALL_STATE(524)] = 11783,
  [SMALL_STATE(525)] = 11793,
  [SMALL_STATE(526)] = 11803,
  [SMALL_STATE(527)] = 11813,
  [SMALL_STATE(528)] = 11823,
  [SMALL_STATE(529)] = 11831,
  [SMALL_STATE(530)] = 11839,
  [SMALL_STATE(531)] = 11847,
  [SMALL_STATE(532)] = 11857,
  [SMALL_STATE(533)] = 11867,
  [SMALL_STATE(534)] = 11877,
  [SMALL_STATE(535)] = 11885,
  [SMALL_STATE(536)] = 11895,
  [SMALL_STATE(537)] = 11905,
  [SMALL_STATE(538)] = 11913,
  [SMALL_STATE(539)] = 11921,
  [SMALL_STATE(540)] = 11931,
  [SMALL_STATE(541)] = 11939,
  [SMALL_STATE(542)] = 11947,
  [SMALL_STATE(543)] = 11955,
  [SMALL_STATE(544)] = 11962,
  [SMALL_STATE(545)] = 11969,
  [SMALL_STATE(546)] = 11976,
  [SMALL_STATE(547)] = 11983,
  [SMALL_STATE(548)] = 11990,
  [SMALL_STATE(549)] = 11997,
  [SMALL_STATE(550)] = 12004,
  [SMALL_STATE(551)] = 12011,
  [SMALL_STATE(552)] = 12018,
  [SMALL_STATE(553)] = 12025,
  [SMALL_STATE(554)] = 12032,
  [SMALL_STATE(555)] = 12039,
  [SMALL_STATE(556)] = 12046,
  [SMALL_STATE(557)] = 12053,
  [SMALL_STATE(558)] = 12060,
  [SMALL_STATE(559)] = 12067,
  [SMALL_STATE(560)] = 12074,
  [SMALL_STATE(561)] = 12081,
  [SMALL_STATE(562)] = 12088,
  [SMALL_STATE(563)] = 12095,
  [SMALL_STATE(564)] = 12102,
  [SMALL_STATE(565)] = 12109,
  [SMALL_STATE(566)] = 12116,
  [SMALL_STATE(567)] = 12123,
  [SMALL_STATE(568)] = 12130,
  [SMALL_STATE(569)] = 12137,
  [SMALL_STATE(570)] = 12144,
  [SMALL_STATE(571)] = 12151,
  [SMALL_STATE(572)] = 12158,
  [SMALL_STATE(573)] = 12165,
  [SMALL_STATE(574)] = 12172,
  [SMALL_STATE(575)] = 12179,
  [SMALL_STATE(576)] = 12186,
  [SMALL_STATE(577)] = 12193,
  [SMALL_STATE(578)] = 12200,
  [SMALL_STATE(579)] = 12207,
  [SMALL_STATE(580)] = 12214,
  [SMALL_STATE(581)] = 12221,
  [SMALL_STATE(582)] = 12228,
  [SMALL_STATE(583)] = 12235,
  [SMALL_STATE(584)] = 12242,
  [SMALL_STATE(585)] = 12249,
  [SMALL_STATE(586)] = 12256,
  [SMALL_STATE(587)] = 12263,
  [SMALL_STATE(588)] = 12270,
  [SMALL_STATE(589)] = 12277,
  [SMALL_STATE(590)] = 12284,
  [SMALL_STATE(591)] = 12291,
  [SMALL_STATE(592)] = 12298,
  [SMALL_STATE(593)] = 12305,
  [SMALL_STATE(594)] = 12312,
  [SMALL_STATE(595)] = 12319,
  [SMALL_STATE(596)] = 12326,
  [SMALL_STATE(597)] = 12333,
  [SMALL_STATE(598)] = 12340,
  [SMALL_STATE(599)] = 12347,
  [SMALL_STATE(600)] = 12354,
  [SMALL_STATE(601)] = 12361,
  [SMALL_STATE(602)] = 12368,
  [SMALL_STATE(603)] = 12375,
  [SMALL_STATE(604)] = 12382,
  [SMALL_STATE(605)] = 12389,
  [SMALL_STATE(606)] = 12396,
  [SMALL_STATE(607)] = 12403,
  [SMALL_STATE(608)] = 12410,
  [SMALL_STATE(609)] = 12417,
  [SMALL_STATE(610)] = 12424,
  [SMALL_STATE(611)] = 12431,
  [SMALL_STATE(612)] = 12438,
  [SMALL_STATE(613)] = 12445,
  [SMALL_STATE(614)] = 12452,
  [SMALL_STATE(615)] = 12459,
  [SMALL_STATE(616)] = 12466,
  [SMALL_STATE(617)] = 12473,
  [SMALL_STATE(618)] = 12480,
  [SMALL_STATE(619)] = 12487,
  [SMALL_STATE(620)] = 12494,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(513),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(554),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(268),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(558),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(461),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(570),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(620),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(572),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(575),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [79] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__annotation_array_def, 3),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__annotation_array_def, 2),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(33),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(298),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(556),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(559),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [99] = {.entry = {.count = 1, .reusable = false}}, SHIFT(310),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(515),
  [105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(615),
  [107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(614),
  [109] = {.entry = {.count = 1, .reusable = false}}, SHIFT(613),
  [111] = {.entry = {.count = 1, .reusable = false}}, SHIFT(611),
  [113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(582),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(310),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(336),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(515),
  [134] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(615),
  [137] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(614),
  [140] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(613),
  [143] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(611),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_struct_repeat1, 2), SHIFT_REPEAT(582),
  [149] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_repeat1, 2),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [161] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [165] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_message, 1),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [181] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_group_repeat1, 2), SHIFT_REPEAT(310),
  [184] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_group_repeat1, 2), SHIFT_REPEAT(515),
  [187] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_group_repeat1, 2), SHIFT_REPEAT(615),
  [190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_group_repeat1, 2), SHIFT_REPEAT(614),
  [193] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_group_repeat1, 2), SHIFT_REPEAT(613),
  [196] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_group_repeat1, 2), SHIFT_REPEAT(611),
  [199] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_group_repeat1, 2), SHIFT_REPEAT(582),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_group_repeat1, 2),
  [204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2),
  [206] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(583),
  [209] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(336),
  [212] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(373),
  [215] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(513),
  [218] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(515),
  [221] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(615),
  [224] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(614),
  [227] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(613),
  [230] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_message_repeat1, 2), SHIFT_REPEAT(611),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [235] = {.entry = {.count = 1, .reusable = false}}, SHIFT(511),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 9, .production_id = 50),
  [239] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 9, .production_id = 50),
  [241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 7, .production_id = 23),
  [243] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 7, .production_id = 23),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 11, .production_id = 59),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 11, .production_id = 59),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 6, .production_id = 23),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 6, .production_id = 23),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 11, .production_id = 67),
  [255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 11, .production_id = 67),
  [257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 10, .production_id = 46),
  [259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 10, .production_id = 46),
  [261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 11, .production_id = 46),
  [263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 11, .production_id = 46),
  [265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 6, .production_id = 2),
  [267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 6, .production_id = 2),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 6, .production_id = 17),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 6, .production_id = 17),
  [273] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 11, .production_id = 58),
  [275] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 11, .production_id = 58),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 6, .production_id = 23),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 6, .production_id = 23),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const, 8, .production_id = 36),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const, 8, .production_id = 36),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 6, .production_id = 2),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 6, .production_id = 2),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 4),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 4),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 12, .production_id = 67),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 12, .production_id = 67),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum, 6, .production_id = 16),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum, 6, .production_id = 16),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 12, .production_id = 68),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 12, .production_id = 68),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_using_directive, 3),
  [307] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_using_directive, 3),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 12, .production_id = 59),
  [311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 12, .production_id = 59),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 9, .production_id = 41),
  [315] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 9, .production_id = 41),
  [317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_using_directive, 3, .production_id = 2),
  [319] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_using_directive, 3, .production_id = 2),
  [321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 12, .production_id = 76),
  [323] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 12, .production_id = 76),
  [325] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum, 4, .production_id = 6),
  [327] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum, 4, .production_id = 6),
  [329] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum, 6, .production_id = 19),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum, 6, .production_id = 19),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum, 6, .production_id = 6),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum, 6, .production_id = 6),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum, 7, .production_id = 19),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum, 7, .production_id = 19),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 6),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 6),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 6, .production_id = 18),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 6, .production_id = 18),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 9, .production_id = 46),
  [351] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 9, .production_id = 46),
  [353] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum, 5, .production_id = 6),
  [355] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum, 5, .production_id = 6),
  [357] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 7, .production_id = 2),
  [359] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 7, .production_id = 2),
  [361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 4, .production_id = 2),
  [363] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 4, .production_id = 2),
  [365] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 7, .production_id = 31),
  [367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 7, .production_id = 31),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 11, .production_id = 68),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 11, .production_id = 68),
  [373] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 5, .production_id = 17),
  [375] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 5, .production_id = 17),
  [377] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 8, .production_id = 41),
  [379] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 8, .production_id = 41),
  [381] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 7, .production_id = 23),
  [383] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 7, .production_id = 23),
  [385] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 6, .production_id = 17),
  [387] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 6, .production_id = 17),
  [389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const, 9, .production_id = 43),
  [391] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const, 9, .production_id = 43),
  [393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 8, .production_id = 31),
  [395] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 8, .production_id = 31),
  [397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 4, .production_id = 2),
  [399] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 4, .production_id = 2),
  [401] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 5, .production_id = 2),
  [403] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 5, .production_id = 2),
  [405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 5, .production_id = 17),
  [407] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 5, .production_id = 17),
  [409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const, 8, .production_id = 28),
  [411] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const, 8, .production_id = 28),
  [413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 11, .production_id = 63),
  [415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 11, .production_id = 63),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 7, .production_id = 2),
  [419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 7, .production_id = 2),
  [421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 5, .production_id = 2),
  [423] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 5, .production_id = 2),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 13, .production_id = 76),
  [427] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 13, .production_id = 76),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 7, .production_id = 31),
  [431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 7, .production_id = 31),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum, 5, .production_id = 16),
  [435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enum, 5, .production_id = 16),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct, 8, .production_id = 31),
  [439] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct, 8, .production_id = 31),
  [441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 10, .production_id = 63),
  [443] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 10, .production_id = 63),
  [445] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 10, .production_id = 41),
  [447] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 10, .production_id = 41),
  [449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 10, .production_id = 50),
  [451] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 10, .production_id = 50),
  [453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 10, .production_id = 58),
  [455] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 10, .production_id = 58),
  [457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 8, .production_id = 35),
  [459] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 8, .production_id = 35),
  [461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 5),
  [463] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 5),
  [465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 7),
  [467] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 7),
  [469] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_interface, 10, .production_id = 59),
  [471] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_interface, 10, .production_id = 59),
  [473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 7, .production_id = 27),
  [475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 7, .production_id = 27),
  [477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 5, .production_id = 14),
  [479] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 5, .production_id = 14),
  [481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const, 7, .production_id = 28),
  [483] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const, 7, .production_id = 28),
  [485] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_text_repeat2, 2),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [489] = {.entry = {.count = 1, .reusable = false}}, SHIFT(145),
  [491] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generics, 3),
  [495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_text_repeat1, 2),
  [497] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_text_repeat1, 2), SHIFT_REPEAT(145),
  [500] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_text_repeat1, 2), SHIFT_REPEAT(145),
  [503] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_block_text_repeat2, 1),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [507] = {.entry = {.count = 1, .reusable = false}}, SHIFT(143),
  [509] = {.entry = {.count = 1, .reusable = false}}, SHIFT(539),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [513] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interface_repeat1, 2), SHIFT_REPEAT(539),
  [516] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interface_repeat1, 2), SHIFT_REPEAT(614),
  [519] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interface_repeat1, 2), SHIFT_REPEAT(613),
  [522] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_interface_repeat1, 2), SHIFT_REPEAT(611),
  [525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_interface_repeat1, 2),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 2, .production_id = 5),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 3, .production_id = 15),
  [599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [601] = {.entry = {.count = 1, .reusable = false}}, SHIFT(322),
  [603] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_top_level_annotation, 3),
  [609] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_top_level_annotation, 3),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 8, .production_id = 56),
  [613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 1),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 1),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_concatenated_string, 2),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_type, 1, .production_id = 4),
  [623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 9, .production_id = 66),
  [629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 4, .production_id = 21),
  [633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 10, .production_id = 54),
  [639] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 10, .production_id = 54),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition, 1),
  [643] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_definition, 1),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 8, .production_id = 33),
  [647] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 8, .production_id = 33),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_statement, 2),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_statement, 2),
  [655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 5, .production_id = 12),
  [665] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 5, .production_id = 12),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [669] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unnamed_union_repeat1, 2), SHIFT_REPEAT(322),
  [672] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unnamed_union_repeat1, 2), SHIFT_REPEAT(325),
  [675] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unnamed_union_repeat1, 2),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_value, 1),
  [679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 3, .production_id = 1),
  [681] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 3, .production_id = 1),
  [683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_concatenated_string_repeat1, 2),
  [685] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenated_string_repeat1, 2), SHIFT_REPEAT(262),
  [688] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_concatenated_string_repeat1, 2), SHIFT_REPEAT(267),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 7, .production_id = 52),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 7, .production_id = 52),
  [699] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_group, 6, .production_id = 4),
  [701] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_group, 6, .production_id = 4),
  [703] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 5, .production_id = 42),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 5, .production_id = 42),
  [707] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_union, 6, .production_id = 4),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_union, 6, .production_id = 4),
  [711] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_union, 7, .production_id = 64),
  [713] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_union, 7, .production_id = 64),
  [715] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_union, 5, .production_id = 4),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_union, 5, .production_id = 4),
  [719] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 6, .production_id = 52),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 6, .production_id = 52),
  [723] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_group, 6, .production_id = 51),
  [725] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_group, 6, .production_id = 51),
  [727] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_group, 5, .production_id = 4),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_group, 5, .production_id = 4),
  [731] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [733] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 7, .production_id = 42),
  [735] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 7, .production_id = 42),
  [737] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [739] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 6, .production_id = 53),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 6, .production_id = 53),
  [743] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 1),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 1),
  [747] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_union, 7, .production_id = 4),
  [749] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_union, 7, .production_id = 4),
  [751] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_field, 8, .production_id = 72),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field, 8, .production_id = 72),
  [755] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union, 1),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union, 1),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_custom_type_repeat1, 2, .production_id = 2),
  [761] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__annotation_call_repeat1, 2),
  [763] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__annotation_call_repeat1, 2), SHIFT_REPEAT(546),
  [766] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nested_enum, 1),
  [768] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nested_enum, 1),
  [770] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_union, 6, .production_id = 51),
  [772] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_union, 6, .production_id = 51),
  [774] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__unnamed_union, 4),
  [776] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unnamed_union, 4),
  [778] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_union, 7, .production_id = 51),
  [780] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_union, 7, .production_id = 51),
  [782] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_group, 7, .production_id = 51),
  [784] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_group, 7, .production_id = 51),
  [786] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nested_struct, 1),
  [788] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nested_struct, 1),
  [790] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union, 1, .production_id = 10),
  [792] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union, 1, .production_id = 10),
  [794] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__unnamed_union, 3),
  [796] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unnamed_union, 3),
  [798] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__named_union, 8, .production_id = 64),
  [800] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__named_union, 8, .production_id = 64),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_type, 2, .production_id = 4),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_text, 1),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__annotation_call_repeat1, 2, .production_id = 20),
  [808] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_text_repeat2, 2),
  [810] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_text_repeat2, 2), SHIFT_REPEAT(146),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_custom_type_repeat1, 2),
  [815] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_custom_type_repeat1, 2), SHIFT_REPEAT(579),
  [818] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_custom_type, 3, .production_id = 4),
  [820] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 2, .production_id = 7),
  [822] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 2, .production_id = 7), SHIFT_REPEAT(573),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__internal_const_identifier, 2),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [829] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__internal_const_identifier_repeat1, 1, .production_id = 4),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__internal_const_identifier, 1),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_custom_type_repeat1, 3, .production_id = 2),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [845] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 10, .production_id = 75),
  [847] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_shorthand, 2),
  [849] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_list, 5),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 12, .production_id = 80),
  [853] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 11, .production_id = 79),
  [855] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [859] = {.entry = {.count = 1, .reusable = false}}, SHIFT(278),
  [861] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 6, .production_id = 37),
  [863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_primitive_type, 1),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_list, 2),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [873] = {.entry = {.count = 1, .reusable = false}}, SHIFT(281),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 11, .production_id = 78),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [881] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_type, 1),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data, 2),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_embedded_file, 2),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_field_version, 1),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 9, .production_id = 65),
  [895] = {.entry = {.count = 1, .reusable = false}}, SHIFT(226),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [899] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [905] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 7, .production_id = 45),
  [909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 5, .production_id = 29),
  [911] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2),
  [913] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(285),
  [916] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2), SHIFT_REPEAT(285),
  [919] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2),
  [921] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(286),
  [924] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(286),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_repeat1, 10, .production_id = 73),
  [929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_shorthand, 3),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_return_type, 3, .production_id = 69),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_type, 4),
  [939] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_list, 3),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_list, 4),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [951] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 7, .production_id = 61),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 7, .production_id = 61),
  [955] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 8, .production_id = 40),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 8, .production_id = 40),
  [959] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__internal_const_identifier_repeat1, 1, .production_id = 4),
  [961] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 8, .production_id = 35),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 8, .production_id = 35),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_return_type_repeat1, 4, .production_id = 81),
  [969] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 7, .production_id = 40),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 7, .production_id = 40),
  [973] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 6, .production_id = 48),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 6, .production_id = 48),
  [977] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 8, .production_id = 70),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 8, .production_id = 70),
  [981] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 7),
  [983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 7),
  [985] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 7, .production_id = 27),
  [987] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 7, .production_id = 27),
  [989] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 7, .production_id = 32),
  [991] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 7, .production_id = 32),
  [993] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 5),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 5),
  [997] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 6, .production_id = 32),
  [999] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 6, .production_id = 32),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1003] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 3, .production_id = 47),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1007] = {.entry = {.count = 1, .reusable = false}}, SHIFT(276),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1017] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 6, .production_id = 40),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 6, .production_id = 40),
  [1021] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 9, .production_id = 77),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 9, .production_id = 77),
  [1025] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 8, .production_id = 71),
  [1027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 8, .production_id = 71),
  [1029] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 6),
  [1031] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 6),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 4, .production_id = 60),
  [1037] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 5, .production_id = 32),
  [1039] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 5, .production_id = 32),
  [1041] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 5, .production_id = 39),
  [1043] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 5, .production_id = 39),
  [1045] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 5, .production_id = 14),
  [1047] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 5, .production_id = 14),
  [1049] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 4),
  [1051] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 4),
  [1053] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 5, .production_id = 40),
  [1055] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 5, .production_id = 40),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1059] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 6, .production_id = 18),
  [1061] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 6, .production_id = 18),
  [1063] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 6, .production_id = 49),
  [1065] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 6, .production_id = 49),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [1069] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 4, .production_id = 32),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 4, .production_id = 32),
  [1073] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method, 7, .production_id = 62),
  [1075] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method, 7, .production_id = 62),
  [1077] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_parameters, 2, .production_id = 8),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1081] = {.entry = {.count = 1, .reusable = false}}, SHIFT(521),
  [1083] = {.entry = {.count = 1, .reusable = false}}, SHIFT(386),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1089] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__annotation_array_def_repeat1, 2),
  [1091] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__annotation_array_def_repeat1, 2), SHIFT_REPEAT(563),
  [1094] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_enum_repeat1, 2), SHIFT_REPEAT(335),
  [1097] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_repeat1, 2),
  [1099] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_shorthand_repeat1, 3, .production_id = 25),
  [1101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__annotation_array_def, 3, .production_id = 25),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 1),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_return_type, 4, .production_id = 69),
  [1141] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__annotation_array_def, 1),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_generic_parameters_repeat1, 2),
  [1161] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_generic_parameters_repeat1, 2), SHIFT_REPEAT(67),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_array_repeat1, 2),
  [1176] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_annotation_array_repeat1, 2), SHIFT_REPEAT(12),
  [1179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_generic_parameters, 1, .production_id = 8),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1191] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__annotation_array_def_repeat2, 2),
  [1193] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__annotation_array_def_repeat2, 2), SHIFT_REPEAT(39),
  [1196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__annotation_array_def, 4, .production_id = 25),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1204] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__same_scope_const_value, 2, .production_id = 34),
  [1206] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_array, 3),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1210] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_return_type_repeat1, 5, .production_id = 81),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_top_level_annotation_body_repeat1, 2),
  [1216] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_top_level_annotation_body_repeat1, 2), SHIFT_REPEAT(567),
  [1219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_return_type, 7, .production_id = 69),
  [1221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_generic_parameters_repeat1, 2, .production_id = 24),
  [1223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_return_type, 6, .production_id = 69),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_parameters, 3),
  [1237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_field, 8, .production_id = 53),
  [1239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_field, 8, .production_id = 53),
  [1241] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 2),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_return_type_repeat1, 2),
  [1247] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_named_return_type_repeat1, 2), SHIFT_REPEAT(586),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unnamed_return_type, 1, .production_id = 4),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1258] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_return_type, 5, .production_id = 69),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1274] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_field, 7, .production_id = 42),
  [1276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_field, 7, .production_id = 42),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 1),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1288] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_parameters, 2),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_using, 2, .production_id = 1),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__annotation_array_def_repeat1, 4, .production_id = 74),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1310] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_field, 6, .production_id = 53),
  [1312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_field, 6, .production_id = 53),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_array, 4),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_using, 3, .production_id = 1),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nested_union, 1),
  [1348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nested_union, 1),
  [1350] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_field, 1),
  [1352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_field, 1),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1356] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_using, 3, .production_id = 3),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [1366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2),
  [1368] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2), SHIFT_REPEAT(520),
  [1371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [1403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_array, 1),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_annotation_targets_repeat1, 2),
  [1415] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_annotation_targets_repeat1, 2), SHIFT_REPEAT(75),
  [1418] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_targets, 4),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1424] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_union_field, 5, .production_id = 42),
  [1426] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_field, 5, .production_id = 42),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1432] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_shorthand_repeat1, 2), SHIFT_REPEAT(602),
  [1435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_shorthand_repeat1, 2),
  [1437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_using_repeat1, 2),
  [1439] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_using_repeat1, 2), SHIFT_REPEAT(564),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_targets, 3),
  [1466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1478] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_top_level_annotation_body_repeat1, 4, .production_id = 55),
  [1480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_target, 1),
  [1482] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__internal_const_identifier_repeat1, 2), SHIFT_REPEAT(533),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_return_type_repeat1, 7, .production_id = 81),
  [1493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_return_types, 3),
  [1495] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_named_return_type_repeat1, 6, .production_id = 81),
  [1497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_shorthand_repeat1, 4, .production_id = 25),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_implicit_generics, 3, .production_id = 38),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_top_level_annotation_body, 1),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1521] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 6, .production_id = 60),
  [1523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_field, 4, .production_id = 30),
  [1525] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_using_repeat1, 2, .production_id = 2),
  [1527] = {.entry = {.count = 1, .reusable = false}}, SHIFT(455),
  [1529] = {.entry = {.count = 1, .reusable = false}}, SHIFT(446),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [1537] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_return_types, 2),
  [1539] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__method_identifier, 1, .production_id = 9),
  [1541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__method_identifier, 1, .production_id = 9),
  [1543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_type, 2),
  [1545] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_field, 3, .production_id = 22),
  [1547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 5, .production_id = 47),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [1579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_top_level_annotation_body, 3),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_top_level_annotation_body, 6, .production_id = 26),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_using, 4, .production_id = 11),
  [1623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_replace_using, 4, .production_id = 3),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1669] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_top_level_annotation_body, 4),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__internal_const_identifier_repeat1, 2, .production_id = 4),
  [1689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_top_level_annotation_body, 7, .production_id = 26),
  [1691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_top_level_annotation_body, 4, .production_id = 13),
  [1693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_capnp(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
