#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1063
#define LARGE_STATE_COUNT 12
#define SYMBOL_COUNT 114
#define ALIAS_COUNT 0
#define TOKEN_COUNT 70
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 3
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 8

enum ts_symbol_identifiers {
  anon_sym_SEMI = 1,
  anon_sym_LBRACE = 2,
  anon_sym_RBRACE = 3,
  anon_sym_COLON = 4,
  anon_sym_main = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_echo = 8,
  anon_sym_exit = 9,
  sym_reference = 10,
  anon_sym_EQ = 11,
  anon_sym_COMMA = 12,
  sym_preprocessor_directive = 13,
  sym_shebang = 14,
  anon_sym_pub = 15,
  anon_sym_fun = 16,
  anon_sym_return = 17,
  anon_sym_fail = 18,
  anon_sym_as = 19,
  anon_sym_import = 20,
  anon_sym_from = 21,
  anon_sym_STAR = 22,
  anon_sym_LBRACK = 23,
  anon_sym_RBRACK = 24,
  anon_sym_let = 25,
  anon_sym_if = 26,
  anon_sym_else = 27,
  anon_sym_then = 28,
  anon_sym_loop = 29,
  anon_sym_for = 30,
  anon_sym_in = 31,
  anon_sym_break = 32,
  anon_sym_continue = 33,
  sym_boolean = 34,
  sym_null = 35,
  sym_number = 36,
  anon_sym_Text = 37,
  anon_sym_Num = 38,
  anon_sym_Bool = 39,
  anon_sym_Null = 40,
  sym_status = 41,
  anon_sym_DASH = 42,
  anon_sym_not = 43,
  anon_sym_unsafe = 44,
  anon_sym_trust = 45,
  anon_sym_silent = 46,
  anon_sym_nameof = 47,
  anon_sym_SLASH = 48,
  anon_sym_PLUS = 49,
  anon_sym_PERCENT = 50,
  anon_sym_GT = 51,
  anon_sym_LT = 52,
  anon_sym_GT_EQ = 53,
  anon_sym_LT_EQ = 54,
  anon_sym_EQ_EQ = 55,
  anon_sym_BANG_EQ = 56,
  anon_sym_and = 57,
  anon_sym_or = 58,
  anon_sym_is = 59,
  sym_variable = 60,
  sym_string_content = 61,
  anon_sym_DQUOTE = 62,
  anon_sym_failed = 63,
  sym_handler_propagation = 64,
  sym_escape_sequence = 65,
  sym_command_content = 66,
  anon_sym_DOLLAR = 67,
  sym_command_option = 68,
  sym_comment = 69,
  sym_source_file = 70,
  sym__global_statement = 71,
  sym__statement = 72,
  sym_block = 73,
  sym_main_block = 74,
  sym_builtin = 75,
  sym_function_parameter_list_item = 76,
  sym_function_parameter_list = 77,
  sym_function_definition = 78,
  sym_function_control_flow = 79,
  sym_import_item = 80,
  sym_import_statement = 81,
  sym_subscript = 82,
  sym_subscript_expression = 83,
  sym_variable_init = 84,
  sym_variable_assignment = 85,
  sym_parentheses = 86,
  sym_if_cond = 87,
  sym_if_chain = 88,
  sym_if_ternary = 89,
  sym_loop_infinite = 90,
  sym_loop_iter = 91,
  sym_loop_control_flow = 92,
  sym_type_name_symbol = 93,
  sym_type_name = 94,
  sym_array = 95,
  sym_function_call = 96,
  sym_unop = 97,
  sym_binop = 98,
  sym_keyword_binop = 99,
  sym_string = 100,
  sym_handler_failed = 101,
  sym_handler = 102,
  sym_interpolation = 103,
  sym_command = 104,
  sym__expression = 105,
  aux_sym_source_file_repeat1 = 106,
  aux_sym_block_repeat1 = 107,
  aux_sym_function_parameter_list_repeat1 = 108,
  aux_sym_import_statement_repeat1 = 109,
  aux_sym_if_chain_repeat1 = 110,
  aux_sym_array_repeat1 = 111,
  aux_sym_string_repeat1 = 112,
  aux_sym_command_repeat1 = 113,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_SEMI] = ";",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_COLON] = ":",
  [anon_sym_main] = "main",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_echo] = "echo",
  [anon_sym_exit] = "exit",
  [sym_reference] = "reference",
  [anon_sym_EQ] = "=",
  [anon_sym_COMMA] = ",",
  [sym_preprocessor_directive] = "preprocessor_directive",
  [sym_shebang] = "shebang",
  [anon_sym_pub] = "pub",
  [anon_sym_fun] = "fun",
  [anon_sym_return] = "return",
  [anon_sym_fail] = "fail",
  [anon_sym_as] = "as",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_STAR] = "*",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_let] = "let",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_then] = "then",
  [anon_sym_loop] = "loop",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [sym_boolean] = "boolean",
  [sym_null] = "null",
  [sym_number] = "number",
  [anon_sym_Text] = "Text",
  [anon_sym_Num] = "Num",
  [anon_sym_Bool] = "Bool",
  [anon_sym_Null] = "Null",
  [sym_status] = "status",
  [anon_sym_DASH] = "-",
  [anon_sym_not] = "not",
  [anon_sym_unsafe] = "unsafe",
  [anon_sym_trust] = "trust",
  [anon_sym_silent] = "silent",
  [anon_sym_nameof] = "nameof",
  [anon_sym_SLASH] = "/",
  [anon_sym_PLUS] = "+",
  [anon_sym_PERCENT] = "%",
  [anon_sym_GT] = ">",
  [anon_sym_LT] = "<",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_is] = "is",
  [sym_variable] = "variable",
  [sym_string_content] = "string_content",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym_failed] = "failed",
  [sym_handler_propagation] = "handler_propagation",
  [sym_escape_sequence] = "escape_sequence",
  [sym_command_content] = "command_content",
  [anon_sym_DOLLAR] = "$",
  [sym_command_option] = "command_option",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__global_statement] = "_global_statement",
  [sym__statement] = "_statement",
  [sym_block] = "block",
  [sym_main_block] = "main_block",
  [sym_builtin] = "builtin",
  [sym_function_parameter_list_item] = "function_parameter_list_item",
  [sym_function_parameter_list] = "function_parameter_list",
  [sym_function_definition] = "function_definition",
  [sym_function_control_flow] = "function_control_flow",
  [sym_import_item] = "import_item",
  [sym_import_statement] = "import_statement",
  [sym_subscript] = "subscript",
  [sym_subscript_expression] = "subscript_expression",
  [sym_variable_init] = "variable_init",
  [sym_variable_assignment] = "variable_assignment",
  [sym_parentheses] = "parentheses",
  [sym_if_cond] = "if_cond",
  [sym_if_chain] = "if_chain",
  [sym_if_ternary] = "if_ternary",
  [sym_loop_infinite] = "loop_infinite",
  [sym_loop_iter] = "loop_iter",
  [sym_loop_control_flow] = "loop_control_flow",
  [sym_type_name_symbol] = "type_name_symbol",
  [sym_type_name] = "type_name",
  [sym_array] = "array",
  [sym_function_call] = "function_call",
  [sym_unop] = "unop",
  [sym_binop] = "binop",
  [sym_keyword_binop] = "keyword_binop",
  [sym_string] = "string",
  [sym_handler_failed] = "handler_failed",
  [sym_handler] = "handler",
  [sym_interpolation] = "interpolation",
  [sym_command] = "command",
  [sym__expression] = "_expression",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_function_parameter_list_repeat1] = "function_parameter_list_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_if_chain_repeat1] = "if_chain_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_command_repeat1] = "command_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_main] = anon_sym_main,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_echo] = anon_sym_echo,
  [anon_sym_exit] = anon_sym_exit,
  [sym_reference] = sym_reference,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_preprocessor_directive] = sym_preprocessor_directive,
  [sym_shebang] = sym_shebang,
  [anon_sym_pub] = anon_sym_pub,
  [anon_sym_fun] = anon_sym_fun,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_fail] = anon_sym_fail,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_then] = anon_sym_then,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [sym_boolean] = sym_boolean,
  [sym_null] = sym_null,
  [sym_number] = sym_number,
  [anon_sym_Text] = anon_sym_Text,
  [anon_sym_Num] = anon_sym_Num,
  [anon_sym_Bool] = anon_sym_Bool,
  [anon_sym_Null] = anon_sym_Null,
  [sym_status] = sym_status,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_unsafe] = anon_sym_unsafe,
  [anon_sym_trust] = anon_sym_trust,
  [anon_sym_silent] = anon_sym_silent,
  [anon_sym_nameof] = anon_sym_nameof,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_is] = anon_sym_is,
  [sym_variable] = sym_variable,
  [sym_string_content] = sym_string_content,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym_failed] = anon_sym_failed,
  [sym_handler_propagation] = sym_handler_propagation,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_command_content] = sym_command_content,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [sym_command_option] = sym_command_option,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__global_statement] = sym__global_statement,
  [sym__statement] = sym__statement,
  [sym_block] = sym_block,
  [sym_main_block] = sym_main_block,
  [sym_builtin] = sym_builtin,
  [sym_function_parameter_list_item] = sym_function_parameter_list_item,
  [sym_function_parameter_list] = sym_function_parameter_list,
  [sym_function_definition] = sym_function_definition,
  [sym_function_control_flow] = sym_function_control_flow,
  [sym_import_item] = sym_import_item,
  [sym_import_statement] = sym_import_statement,
  [sym_subscript] = sym_subscript,
  [sym_subscript_expression] = sym_subscript_expression,
  [sym_variable_init] = sym_variable_init,
  [sym_variable_assignment] = sym_variable_assignment,
  [sym_parentheses] = sym_parentheses,
  [sym_if_cond] = sym_if_cond,
  [sym_if_chain] = sym_if_chain,
  [sym_if_ternary] = sym_if_ternary,
  [sym_loop_infinite] = sym_loop_infinite,
  [sym_loop_iter] = sym_loop_iter,
  [sym_loop_control_flow] = sym_loop_control_flow,
  [sym_type_name_symbol] = sym_type_name_symbol,
  [sym_type_name] = sym_type_name,
  [sym_array] = sym_array,
  [sym_function_call] = sym_function_call,
  [sym_unop] = sym_unop,
  [sym_binop] = sym_binop,
  [sym_keyword_binop] = sym_keyword_binop,
  [sym_string] = sym_string,
  [sym_handler_failed] = sym_handler_failed,
  [sym_handler] = sym_handler,
  [sym_interpolation] = sym_interpolation,
  [sym_command] = sym_command,
  [sym__expression] = sym__expression,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_function_parameter_list_repeat1] = aux_sym_function_parameter_list_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_if_chain_repeat1] = aux_sym_if_chain_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_command_repeat1] = aux_sym_command_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_main] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_echo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exit] = {
    .visible = true,
    .named = false,
  },
  [sym_reference] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_preprocessor_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_shebang] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_pub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fun] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fail] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_then] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_Text] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Num] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Null] = {
    .visible = true,
    .named = false,
  },
  [sym_status] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsafe] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trust] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_silent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nameof] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_string_content] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_failed] = {
    .visible = true,
    .named = false,
  },
  [sym_handler_propagation] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_command_content] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [sym_command_option] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__global_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_main_block] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_list_item] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_control_flow] = {
    .visible = true,
    .named = true,
  },
  [sym_import_item] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_init] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_parentheses] = {
    .visible = true,
    .named = true,
  },
  [sym_if_cond] = {
    .visible = true,
    .named = true,
  },
  [sym_if_chain] = {
    .visible = true,
    .named = true,
  },
  [sym_if_ternary] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_infinite] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_iter] = {
    .visible = true,
    .named = true,
  },
  [sym_loop_control_flow] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_unop] = {
    .visible = true,
    .named = true,
  },
  [sym_binop] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_binop] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_handler_failed] = {
    .visible = true,
    .named = true,
  },
  [sym_handler] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_command] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_chain_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_command_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_body = 1,
  field_name = 2,
  field_parameters = 3,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body] = "body",
  [field_name] = "name",
  [field_parameters] = "parameters",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 3},
  [3] = {.index = 4, .length = 3},
  [4] = {.index = 7, .length = 3},
  [5] = {.index = 10, .length = 3},
  [6] = {.index = 13, .length = 3},
  [7] = {.index = 16, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_body, 3},
    {field_name, 1},
    {field_parameters, 2},
  [4] =
    {field_body, 4},
    {field_name, 2},
    {field_parameters, 3},
  [7] =
    {field_body, 5},
    {field_name, 3},
    {field_parameters, 4},
  [10] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
  [13] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
  [16] =
    {field_body, 7},
    {field_name, 3},
    {field_parameters, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 7,
  [13] = 8,
  [14] = 6,
  [15] = 11,
  [16] = 10,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 17,
  [21] = 21,
  [22] = 22,
  [23] = 22,
  [24] = 22,
  [25] = 17,
  [26] = 26,
  [27] = 17,
  [28] = 22,
  [29] = 22,
  [30] = 22,
  [31] = 22,
  [32] = 17,
  [33] = 22,
  [34] = 17,
  [35] = 17,
  [36] = 22,
  [37] = 37,
  [38] = 22,
  [39] = 17,
  [40] = 22,
  [41] = 17,
  [42] = 17,
  [43] = 17,
  [44] = 21,
  [45] = 45,
  [46] = 46,
  [47] = 21,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 51,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 45,
  [58] = 21,
  [59] = 59,
  [60] = 52,
  [61] = 55,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 63,
  [66] = 66,
  [67] = 67,
  [68] = 63,
  [69] = 54,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 63,
  [75] = 75,
  [76] = 63,
  [77] = 51,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 63,
  [84] = 63,
  [85] = 85,
  [86] = 63,
  [87] = 63,
  [88] = 88,
  [89] = 63,
  [90] = 63,
  [91] = 5,
  [92] = 63,
  [93] = 51,
  [94] = 45,
  [95] = 4,
  [96] = 63,
  [97] = 97,
  [98] = 79,
  [99] = 99,
  [100] = 100,
  [101] = 63,
  [102] = 102,
  [103] = 59,
  [104] = 104,
  [105] = 48,
  [106] = 49,
  [107] = 107,
  [108] = 50,
  [109] = 56,
  [110] = 110,
  [111] = 63,
  [112] = 63,
  [113] = 113,
  [114] = 114,
  [115] = 63,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 63,
  [124] = 82,
  [125] = 46,
  [126] = 45,
  [127] = 99,
  [128] = 67,
  [129] = 121,
  [130] = 7,
  [131] = 81,
  [132] = 10,
  [133] = 80,
  [134] = 78,
  [135] = 8,
  [136] = 62,
  [137] = 11,
  [138] = 85,
  [139] = 102,
  [140] = 97,
  [141] = 88,
  [142] = 66,
  [143] = 120,
  [144] = 116,
  [145] = 73,
  [146] = 64,
  [147] = 118,
  [148] = 117,
  [149] = 75,
  [150] = 100,
  [151] = 104,
  [152] = 107,
  [153] = 110,
  [154] = 113,
  [155] = 6,
  [156] = 114,
  [157] = 119,
  [158] = 72,
  [159] = 10,
  [160] = 8,
  [161] = 11,
  [162] = 6,
  [163] = 7,
  [164] = 21,
  [165] = 21,
  [166] = 52,
  [167] = 21,
  [168] = 45,
  [169] = 59,
  [170] = 49,
  [171] = 46,
  [172] = 56,
  [173] = 51,
  [174] = 54,
  [175] = 21,
  [176] = 51,
  [177] = 45,
  [178] = 48,
  [179] = 55,
  [180] = 50,
  [181] = 46,
  [182] = 116,
  [183] = 55,
  [184] = 73,
  [185] = 82,
  [186] = 79,
  [187] = 97,
  [188] = 99,
  [189] = 102,
  [190] = 121,
  [191] = 50,
  [192] = 100,
  [193] = 104,
  [194] = 107,
  [195] = 49,
  [196] = 48,
  [197] = 51,
  [198] = 81,
  [199] = 82,
  [200] = 113,
  [201] = 80,
  [202] = 62,
  [203] = 114,
  [204] = 4,
  [205] = 117,
  [206] = 56,
  [207] = 118,
  [208] = 119,
  [209] = 120,
  [210] = 66,
  [211] = 67,
  [212] = 78,
  [213] = 45,
  [214] = 72,
  [215] = 59,
  [216] = 75,
  [217] = 52,
  [218] = 46,
  [219] = 54,
  [220] = 51,
  [221] = 85,
  [222] = 110,
  [223] = 88,
  [224] = 45,
  [225] = 5,
  [226] = 64,
  [227] = 81,
  [228] = 73,
  [229] = 121,
  [230] = 120,
  [231] = 79,
  [232] = 78,
  [233] = 75,
  [234] = 66,
  [235] = 88,
  [236] = 97,
  [237] = 119,
  [238] = 5,
  [239] = 99,
  [240] = 100,
  [241] = 104,
  [242] = 102,
  [243] = 110,
  [244] = 72,
  [245] = 85,
  [246] = 107,
  [247] = 118,
  [248] = 113,
  [249] = 62,
  [250] = 80,
  [251] = 114,
  [252] = 117,
  [253] = 64,
  [254] = 116,
  [255] = 67,
  [256] = 4,
  [257] = 8,
  [258] = 10,
  [259] = 11,
  [260] = 6,
  [261] = 7,
  [262] = 21,
  [263] = 21,
  [264] = 99,
  [265] = 104,
  [266] = 120,
  [267] = 55,
  [268] = 268,
  [269] = 120,
  [270] = 50,
  [271] = 49,
  [272] = 48,
  [273] = 119,
  [274] = 118,
  [275] = 51,
  [276] = 45,
  [277] = 117,
  [278] = 113,
  [279] = 114,
  [280] = 119,
  [281] = 118,
  [282] = 116,
  [283] = 82,
  [284] = 51,
  [285] = 46,
  [286] = 59,
  [287] = 97,
  [288] = 114,
  [289] = 52,
  [290] = 54,
  [291] = 99,
  [292] = 117,
  [293] = 46,
  [294] = 116,
  [295] = 82,
  [296] = 100,
  [297] = 45,
  [298] = 56,
  [299] = 107,
  [300] = 107,
  [301] = 104,
  [302] = 97,
  [303] = 100,
  [304] = 113,
  [305] = 79,
  [306] = 102,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 85,
  [318] = 62,
  [319] = 121,
  [320] = 110,
  [321] = 81,
  [322] = 322,
  [323] = 323,
  [324] = 78,
  [325] = 72,
  [326] = 75,
  [327] = 64,
  [328] = 62,
  [329] = 120,
  [330] = 67,
  [331] = 73,
  [332] = 119,
  [333] = 118,
  [334] = 117,
  [335] = 66,
  [336] = 88,
  [337] = 337,
  [338] = 80,
  [339] = 339,
  [340] = 114,
  [341] = 116,
  [342] = 113,
  [343] = 110,
  [344] = 107,
  [345] = 5,
  [346] = 104,
  [347] = 4,
  [348] = 100,
  [349] = 99,
  [350] = 97,
  [351] = 82,
  [352] = 352,
  [353] = 353,
  [354] = 353,
  [355] = 353,
  [356] = 353,
  [357] = 353,
  [358] = 358,
  [359] = 358,
  [360] = 358,
  [361] = 361,
  [362] = 358,
  [363] = 358,
  [364] = 353,
  [365] = 358,
  [366] = 353,
  [367] = 358,
  [368] = 353,
  [369] = 353,
  [370] = 358,
  [371] = 358,
  [372] = 358,
  [373] = 358,
  [374] = 353,
  [375] = 353,
  [376] = 104,
  [377] = 114,
  [378] = 378,
  [379] = 379,
  [380] = 379,
  [381] = 378,
  [382] = 382,
  [383] = 378,
  [384] = 378,
  [385] = 379,
  [386] = 379,
  [387] = 378,
  [388] = 379,
  [389] = 379,
  [390] = 378,
  [391] = 379,
  [392] = 379,
  [393] = 382,
  [394] = 382,
  [395] = 382,
  [396] = 382,
  [397] = 382,
  [398] = 382,
  [399] = 382,
  [400] = 382,
  [401] = 382,
  [402] = 382,
  [403] = 382,
  [404] = 382,
  [405] = 379,
  [406] = 99,
  [407] = 113,
  [408] = 117,
  [409] = 82,
  [410] = 82,
  [411] = 119,
  [412] = 118,
  [413] = 120,
  [414] = 382,
  [415] = 116,
  [416] = 107,
  [417] = 97,
  [418] = 100,
  [419] = 419,
  [420] = 117,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 97,
  [426] = 426,
  [427] = 99,
  [428] = 428,
  [429] = 429,
  [430] = 100,
  [431] = 104,
  [432] = 107,
  [433] = 433,
  [434] = 419,
  [435] = 428,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 113,
  [440] = 423,
  [441] = 441,
  [442] = 437,
  [443] = 443,
  [444] = 438,
  [445] = 429,
  [446] = 429,
  [447] = 437,
  [448] = 438,
  [449] = 419,
  [450] = 436,
  [451] = 421,
  [452] = 116,
  [453] = 436,
  [454] = 437,
  [455] = 424,
  [456] = 429,
  [457] = 441,
  [458] = 443,
  [459] = 421,
  [460] = 422,
  [461] = 422,
  [462] = 423,
  [463] = 423,
  [464] = 423,
  [465] = 118,
  [466] = 119,
  [467] = 422,
  [468] = 421,
  [469] = 443,
  [470] = 441,
  [471] = 436,
  [472] = 268,
  [473] = 428,
  [474] = 424,
  [475] = 429,
  [476] = 120,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 437,
  [481] = 429,
  [482] = 437,
  [483] = 429,
  [484] = 437,
  [485] = 429,
  [486] = 426,
  [487] = 487,
  [488] = 433,
  [489] = 489,
  [490] = 490,
  [491] = 438,
  [492] = 429,
  [493] = 419,
  [494] = 428,
  [495] = 424,
  [496] = 419,
  [497] = 437,
  [498] = 436,
  [499] = 499,
  [500] = 423,
  [501] = 419,
  [502] = 424,
  [503] = 436,
  [504] = 436,
  [505] = 423,
  [506] = 443,
  [507] = 426,
  [508] = 428,
  [509] = 429,
  [510] = 441,
  [511] = 436,
  [512] = 437,
  [513] = 429,
  [514] = 423,
  [515] = 423,
  [516] = 438,
  [517] = 436,
  [518] = 433,
  [519] = 490,
  [520] = 426,
  [521] = 441,
  [522] = 433,
  [523] = 490,
  [524] = 436,
  [525] = 426,
  [526] = 423,
  [527] = 428,
  [528] = 490,
  [529] = 490,
  [530] = 426,
  [531] = 421,
  [532] = 433,
  [533] = 437,
  [534] = 490,
  [535] = 424,
  [536] = 422,
  [537] = 443,
  [538] = 438,
  [539] = 114,
  [540] = 419,
  [541] = 429,
  [542] = 438,
  [543] = 437,
  [544] = 424,
  [545] = 443,
  [546] = 424,
  [547] = 422,
  [548] = 421,
  [549] = 443,
  [550] = 441,
  [551] = 436,
  [552] = 423,
  [553] = 421,
  [554] = 437,
  [555] = 438,
  [556] = 422,
  [557] = 557,
  [558] = 437,
  [559] = 429,
  [560] = 490,
  [561] = 436,
  [562] = 423,
  [563] = 490,
  [564] = 437,
  [565] = 429,
  [566] = 438,
  [567] = 423,
  [568] = 441,
  [569] = 443,
  [570] = 490,
  [571] = 421,
  [572] = 422,
  [573] = 424,
  [574] = 422,
  [575] = 489,
  [576] = 421,
  [577] = 433,
  [578] = 423,
  [579] = 436,
  [580] = 443,
  [581] = 441,
  [582] = 436,
  [583] = 441,
  [584] = 428,
  [585] = 6,
  [586] = 11,
  [587] = 10,
  [588] = 8,
  [589] = 7,
  [590] = 7,
  [591] = 6,
  [592] = 11,
  [593] = 10,
  [594] = 8,
  [595] = 21,
  [596] = 6,
  [597] = 11,
  [598] = 21,
  [599] = 10,
  [600] = 8,
  [601] = 7,
  [602] = 59,
  [603] = 52,
  [604] = 56,
  [605] = 46,
  [606] = 51,
  [607] = 45,
  [608] = 48,
  [609] = 49,
  [610] = 55,
  [611] = 54,
  [612] = 88,
  [613] = 50,
  [614] = 82,
  [615] = 46,
  [616] = 113,
  [617] = 114,
  [618] = 116,
  [619] = 117,
  [620] = 118,
  [621] = 119,
  [622] = 268,
  [623] = 52,
  [624] = 120,
  [625] = 104,
  [626] = 100,
  [627] = 99,
  [628] = 97,
  [629] = 46,
  [630] = 4,
  [631] = 5,
  [632] = 85,
  [633] = 477,
  [634] = 110,
  [635] = 107,
  [636] = 75,
  [637] = 67,
  [638] = 66,
  [639] = 82,
  [640] = 62,
  [641] = 80,
  [642] = 81,
  [643] = 88,
  [644] = 48,
  [645] = 50,
  [646] = 121,
  [647] = 102,
  [648] = 54,
  [649] = 79,
  [650] = 73,
  [651] = 64,
  [652] = 72,
  [653] = 59,
  [654] = 78,
  [655] = 54,
  [656] = 88,
  [657] = 48,
  [658] = 50,
  [659] = 21,
  [660] = 104,
  [661] = 99,
  [662] = 100,
  [663] = 10,
  [664] = 107,
  [665] = 113,
  [666] = 114,
  [667] = 116,
  [668] = 117,
  [669] = 118,
  [670] = 119,
  [671] = 268,
  [672] = 21,
  [673] = 120,
  [674] = 477,
  [675] = 97,
  [676] = 8,
  [677] = 82,
  [678] = 7,
  [679] = 6,
  [680] = 11,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 683,
  [685] = 683,
  [686] = 681,
  [687] = 687,
  [688] = 687,
  [689] = 689,
  [690] = 682,
  [691] = 683,
  [692] = 681,
  [693] = 687,
  [694] = 689,
  [695] = 687,
  [696] = 682,
  [697] = 682,
  [698] = 698,
  [699] = 682,
  [700] = 687,
  [701] = 682,
  [702] = 687,
  [703] = 681,
  [704] = 687,
  [705] = 687,
  [706] = 689,
  [707] = 683,
  [708] = 708,
  [709] = 709,
  [710] = 682,
  [711] = 681,
  [712] = 689,
  [713] = 682,
  [714] = 687,
  [715] = 683,
  [716] = 683,
  [717] = 681,
  [718] = 682,
  [719] = 683,
  [720] = 683,
  [721] = 687,
  [722] = 683,
  [723] = 683,
  [724] = 681,
  [725] = 689,
  [726] = 687,
  [727] = 681,
  [728] = 683,
  [729] = 689,
  [730] = 682,
  [731] = 682,
  [732] = 683,
  [733] = 682,
  [734] = 687,
  [735] = 682,
  [736] = 687,
  [737] = 681,
  [738] = 682,
  [739] = 687,
  [740] = 45,
  [741] = 51,
  [742] = 683,
  [743] = 46,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 51,
  [749] = 46,
  [750] = 45,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 753,
  [755] = 755,
  [756] = 753,
  [757] = 751,
  [758] = 752,
  [759] = 752,
  [760] = 752,
  [761] = 755,
  [762] = 755,
  [763] = 753,
  [764] = 752,
  [765] = 752,
  [766] = 88,
  [767] = 48,
  [768] = 753,
  [769] = 752,
  [770] = 50,
  [771] = 755,
  [772] = 755,
  [773] = 752,
  [774] = 753,
  [775] = 752,
  [776] = 755,
  [777] = 777,
  [778] = 54,
  [779] = 779,
  [780] = 779,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 783,
  [785] = 779,
  [786] = 779,
  [787] = 783,
  [788] = 779,
  [789] = 783,
  [790] = 783,
  [791] = 779,
  [792] = 783,
  [793] = 779,
  [794] = 783,
  [795] = 779,
  [796] = 779,
  [797] = 783,
  [798] = 798,
  [799] = 783,
  [800] = 800,
  [801] = 801,
  [802] = 800,
  [803] = 800,
  [804] = 801,
  [805] = 800,
  [806] = 800,
  [807] = 800,
  [808] = 801,
  [809] = 801,
  [810] = 801,
  [811] = 811,
  [812] = 800,
  [813] = 801,
  [814] = 801,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 816,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 828,
  [830] = 823,
  [831] = 826,
  [832] = 828,
  [833] = 826,
  [834] = 828,
  [835] = 826,
  [836] = 82,
  [837] = 828,
  [838] = 825,
  [839] = 839,
  [840] = 839,
  [841] = 839,
  [842] = 823,
  [843] = 826,
  [844] = 827,
  [845] = 827,
  [846] = 826,
  [847] = 828,
  [848] = 828,
  [849] = 849,
  [850] = 823,
  [851] = 826,
  [852] = 825,
  [853] = 828,
  [854] = 827,
  [855] = 827,
  [856] = 828,
  [857] = 857,
  [858] = 823,
  [859] = 826,
  [860] = 826,
  [861] = 826,
  [862] = 823,
  [863] = 826,
  [864] = 825,
  [865] = 865,
  [866] = 828,
  [867] = 839,
  [868] = 868,
  [869] = 823,
  [870] = 870,
  [871] = 828,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 824,
  [877] = 825,
  [878] = 826,
  [879] = 827,
  [880] = 880,
  [881] = 875,
  [882] = 839,
  [883] = 883,
  [884] = 884,
  [885] = 827,
  [886] = 886,
  [887] = 823,
  [888] = 826,
  [889] = 826,
  [890] = 827,
  [891] = 891,
  [892] = 875,
  [893] = 824,
  [894] = 827,
  [895] = 823,
  [896] = 828,
  [897] = 825,
  [898] = 898,
  [899] = 839,
  [900] = 875,
  [901] = 824,
  [902] = 902,
  [903] = 824,
  [904] = 828,
  [905] = 905,
  [906] = 875,
  [907] = 824,
  [908] = 875,
  [909] = 824,
  [910] = 875,
  [911] = 824,
  [912] = 912,
  [913] = 875,
  [914] = 824,
  [915] = 875,
  [916] = 875,
  [917] = 824,
  [918] = 828,
  [919] = 919,
  [920] = 824,
  [921] = 875,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 924,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 925,
  [931] = 925,
  [932] = 924,
  [933] = 924,
  [934] = 934,
  [935] = 925,
  [936] = 924,
  [937] = 937,
  [938] = 924,
  [939] = 477,
  [940] = 925,
  [941] = 924,
  [942] = 942,
  [943] = 943,
  [944] = 925,
  [945] = 925,
  [946] = 924,
  [947] = 924,
  [948] = 925,
  [949] = 924,
  [950] = 925,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 925,
  [955] = 925,
  [956] = 925,
  [957] = 924,
  [958] = 925,
  [959] = 959,
  [960] = 924,
  [961] = 924,
  [962] = 925,
  [963] = 924,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 971,
  [973] = 973,
  [974] = 973,
  [975] = 971,
  [976] = 976,
  [977] = 970,
  [978] = 978,
  [979] = 979,
  [980] = 973,
  [981] = 981,
  [982] = 970,
  [983] = 983,
  [984] = 979,
  [985] = 979,
  [986] = 979,
  [987] = 973,
  [988] = 988,
  [989] = 989,
  [990] = 971,
  [991] = 991,
  [992] = 970,
  [993] = 973,
  [994] = 973,
  [995] = 979,
  [996] = 978,
  [997] = 978,
  [998] = 998,
  [999] = 999,
  [1000] = 988,
  [1001] = 971,
  [1002] = 988,
  [1003] = 971,
  [1004] = 988,
  [1005] = 971,
  [1006] = 988,
  [1007] = 971,
  [1008] = 988,
  [1009] = 971,
  [1010] = 988,
  [1011] = 971,
  [1012] = 988,
  [1013] = 971,
  [1014] = 988,
  [1015] = 971,
  [1016] = 988,
  [1017] = 988,
  [1018] = 988,
  [1019] = 971,
  [1020] = 988,
  [1021] = 971,
  [1022] = 978,
  [1023] = 973,
  [1024] = 970,
  [1025] = 1025,
  [1026] = 970,
  [1027] = 979,
  [1028] = 973,
  [1029] = 970,
  [1030] = 973,
  [1031] = 1031,
  [1032] = 978,
  [1033] = 979,
  [1034] = 978,
  [1035] = 1035,
  [1036] = 970,
  [1037] = 979,
  [1038] = 978,
  [1039] = 978,
  [1040] = 978,
  [1041] = 970,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 973,
  [1045] = 970,
  [1046] = 973,
  [1047] = 970,
  [1048] = 979,
  [1049] = 970,
  [1050] = 979,
  [1051] = 988,
  [1052] = 978,
  [1053] = 973,
  [1054] = 979,
  [1055] = 1055,
  [1056] = 970,
  [1057] = 978,
  [1058] = 1058,
  [1059] = 970,
  [1060] = 973,
  [1061] = 1061,
  [1062] = 973,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(125);
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 9,
        '$', 343,
        '%', 210,
        '(', 132,
        ')', 133,
        '*', 158,
        '+', 209,
        ',', 141,
        '-', 196,
        '/', 207,
        ':', 129,
        ';', 126,
        '<', 212,
        '=', 140,
        '>', 211,
        '?', 336,
        'B', 85,
        'N', 109,
        'T', 33,
        '[', 159,
        '\\', 338,
        ']', 160,
        'a', 71,
        'b', 92,
        'c', 81,
        'e', 30,
        'f', 22,
        'i', 46,
        'l', 34,
        'm', 26,
        'n', 23,
        'o', 90,
        'p', 110,
        'r', 35,
        's', 53,
        't', 51,
        'u', 76,
        '{', 127,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 8,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 140,
        '>', 211,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'b', 303,
        'c', 292,
        'e', 236,
        'f', 224,
        'i', 255,
        'l', 240,
        'n', 225,
        'o', 301,
        'r', 248,
        's', 262,
        't', 261,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 8,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 140,
        '>', 211,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'b', 303,
        'c', 292,
        'e', 235,
        'f', 224,
        'i', 255,
        'l', 240,
        'n', 225,
        'o', 301,
        'r', 248,
        's', 262,
        't', 261,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 8,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 20,
        '>', 211,
        '?', 336,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'b', 303,
        'c', 292,
        'e', 236,
        'f', 230,
        'i', 255,
        'l', 240,
        'n', 225,
        'o', 301,
        'r', 248,
        's', 262,
        't', 261,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 8,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 20,
        '>', 211,
        '?', 336,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'b', 303,
        'c', 292,
        'e', 235,
        'f', 230,
        'i', 255,
        'l', 240,
        'n', 225,
        'o', 301,
        'r', 248,
        's', 262,
        't', 261,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 140,
        '>', 211,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'e', 280,
        'f', 232,
        'i', 307,
        'n', 225,
        'o', 301,
        's', 262,
        't', 261,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 20,
        '>', 211,
        '?', 336,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'e', 280,
        'f', 233,
        'i', 307,
        'n', 225,
        'o', 301,
        's', 262,
        't', 261,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 19,
        '%', 210,
        '(', 132,
        ')', 133,
        '*', 158,
        '+', 208,
        ',', 141,
        '-', 195,
        '/', 207,
        ':', 129,
        ';', 126,
        '<', 212,
        '=', 140,
        '>', 211,
        '?', 336,
        '[', 159,
        ']', 160,
        'a', 71,
        'e', 60,
        'f', 27,
        'i', 95,
        'o', 90,
        't', 50,
        '{', 127,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(143);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(143);
      if (lookahead == '[') ADVANCE(118);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '"', 333,
        '#', 8,
        '$', 343,
        '(', 132,
        '+', 116,
        '-', 196,
        '/', 17,
        ';', 126,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'b', 303,
        'c', 292,
        'e', 236,
        'f', 224,
        'i', 256,
        'l', 240,
        'n', 225,
        'r', 248,
        's', 262,
        't', 302,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '"', 333,
        '#', 8,
        '$', 343,
        '(', 132,
        '+', 116,
        '-', 196,
        '/', 17,
        ';', 126,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'b', 303,
        'c', 292,
        'e', 235,
        'f', 224,
        'i', 256,
        'l', 240,
        'n', 225,
        'r', 248,
        's', 262,
        't', 302,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '"', 333,
        '$', 343,
        '(', 132,
        ')', 133,
        '+', 116,
        '-', 196,
        '/', 17,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        ']', 160,
        'f', 232,
        'n', 225,
        's', 262,
        't', 302,
        'u', 282,
        '{', 127,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '"', 333,
        '$', 343,
        '(', 132,
        '+', 116,
        '-', 196,
        '/', 17,
        ';', 126,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'e', 280,
        'f', 232,
        'n', 225,
        's', 262,
        't', 302,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(333);
      if (lookahead == '/') ADVANCE(331);
      if (lookahead == '\\') ADVANCE(338);
      if (lookahead == '{') ADVANCE(127);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(330);
      if (lookahead != 0) ADVANCE(332);
      END_STATE();
    case 15:
      if (lookahead == '$') ADVANCE(343);
      if (lookahead == '-') ADVANCE(344);
      if (lookahead == '/') ADVANCE(341);
      if (lookahead == '\\') ADVANCE(338);
      if (lookahead == '{') ADVANCE(127);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(340);
      if (lookahead != 0) ADVANCE(342);
      END_STATE();
    case 16:
      if (lookahead == ')') ADVANCE(133);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == 'r') ADVANCE(249);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 17:
      if (lookahead == '/') ADVANCE(346);
      END_STATE();
    case 18:
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '}') ADVANCE(128);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 19:
      if (lookahead == '=') ADVANCE(216);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 21:
      if (lookahead == ']') ADVANCE(142);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ') ADVANCE(21);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(56);
      if (lookahead == 'o') ADVANCE(91);
      if (lookahead == 'r') ADVANCE(83);
      if (lookahead == 'u') ADVANCE(72);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(70);
      if (lookahead == 'o') ADVANCE(101);
      if (lookahead == 'u') ADVANCE(66);
      END_STATE();
    case 24:
      if (lookahead == 'a') ADVANCE(59);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 26:
      if (lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 28:
      if (lookahead == 'a') ADVANCE(107);
      END_STATE();
    case 29:
      if (lookahead == 'b') ADVANCE(144);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(52);
      if (lookahead == 'l') ADVANCE(98);
      if (lookahead == 'x') ADVANCE(55);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(217);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(334);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(115);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(100);
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(47);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(165);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(178);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(178);
      if (lookahead == 's') ADVANCE(104);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(176);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(24);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(79);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(163);
      if (lookahead == 'm') ADVANCE(89);
      if (lookahead == 'n') ADVANCE(173);
      if (lookahead == 's') ADVANCE(221);
      END_STATE();
    case 47:
      if (lookahead == 'f') ADVANCE(138);
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 48:
      if (lookahead == 'f') ADVANCE(205);
      END_STATE();
    case 49:
      if (lookahead == 'f') ADVANCE(39);
      END_STATE();
    case 50:
      if (lookahead == 'h') ADVANCE(43);
      END_STATE();
    case 51:
      if (lookahead == 'h') ADVANCE(43);
      if (lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 52:
      if (lookahead == 'h') ADVANCE(80);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(67);
      if (lookahead == 't') ADVANCE(28);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(73);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(103);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(63);
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 57:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 58:
      if (lookahead == 'i') ADVANCE(68);
      END_STATE();
    case 59:
      if (lookahead == 'k') ADVANCE(174);
      END_STATE();
    case 60:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 61:
      if (lookahead == 'l') ADVANCE(189);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(191);
      END_STATE();
    case 63:
      if (lookahead == 'l') ADVANCE(150);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(180);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(62);
      if (lookahead == 'm') ADVANCE(187);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(64);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(45);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(41);
      END_STATE();
    case 69:
      if (lookahead == 'm') ADVANCE(157);
      END_STATE();
    case 70:
      if (lookahead == 'm') ADVANCE(44);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(31);
      if (lookahead == 's') ADVANCE(153);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(146);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(130);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(167);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(148);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(97);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(108);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 79:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(134);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 82:
      if (lookahead == 'o') ADVANCE(88);
      END_STATE();
    case 83:
      if (lookahead == 'o') ADVANCE(69);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(48);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(86);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(94);
      END_STATE();
    case 88:
      if (lookahead == 'p') ADVANCE(169);
      END_STATE();
    case 89:
      if (lookahead == 'p') ADVANCE(87);
      END_STATE();
    case 90:
      if (lookahead == 'r') ADVANCE(219);
      END_STATE();
    case 91:
      if (lookahead == 'r') ADVANCE(171);
      END_STATE();
    case 92:
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 93:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 94:
      if (lookahead == 'r') ADVANCE(105);
      END_STATE();
    case 95:
      if (lookahead == 's') ADVANCE(221);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(193);
      END_STATE();
    case 97:
      if (lookahead == 's') ADVANCE(25);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 99:
      if (lookahead == 's') ADVANCE(37);
      END_STATE();
    case 100:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 101:
      if (lookahead == 't') ADVANCE(197);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(185);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(201);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(155);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(203);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(57);
      END_STATE();
    case 109:
      if (lookahead == 'u') ADVANCE(65);
      END_STATE();
    case 110:
      if (lookahead == 'u') ADVANCE(29);
      END_STATE();
    case 111:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(96);
      END_STATE();
    case 113:
      if (lookahead == 'u') ADVANCE(93);
      END_STATE();
    case 114:
      if (lookahead == 'u') ADVANCE(40);
      END_STATE();
    case 115:
      if (lookahead == 'x') ADVANCE(102);
      END_STATE();
    case 116:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 117:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 118:
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != ' ' &&
          lookahead != ']') ADVANCE(21);
      END_STATE();
    case 119:
      if (eof) ADVANCE(125);
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 9,
        '$', 343,
        '%', 210,
        '(', 132,
        ')', 133,
        '*', 158,
        '+', 209,
        ',', 141,
        '-', 196,
        '/', 207,
        ':', 129,
        ';', 126,
        '<', 212,
        '=', 140,
        '>', 211,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        ']', 160,
        'a', 286,
        'b', 303,
        'c', 292,
        'e', 236,
        'f', 223,
        'i', 253,
        'l', 240,
        'm', 228,
        'n', 225,
        'o', 301,
        'p', 322,
        'r', 248,
        's', 262,
        't', 261,
        'u', 282,
        '{', 127,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(119);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 120:
      if (eof) ADVANCE(125);
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 9,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 140,
        '>', 211,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'b', 303,
        'c', 292,
        'e', 235,
        'f', 223,
        'i', 253,
        'l', 240,
        'm', 228,
        'n', 225,
        'o', 301,
        'p', 322,
        'r', 248,
        's', 262,
        't', 261,
        'u', 282,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(120);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 121:
      if (eof) ADVANCE(125);
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 9,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 20,
        '>', 211,
        '?', 336,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'b', 303,
        'c', 292,
        'e', 236,
        'f', 229,
        'i', 253,
        'l', 240,
        'm', 228,
        'n', 225,
        'o', 301,
        'p', 322,
        'r', 248,
        's', 262,
        't', 261,
        'u', 282,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(121);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 122:
      if (eof) ADVANCE(125);
      ADVANCE_MAP(
        '!', 19,
        '"', 333,
        '#', 9,
        '$', 343,
        '%', 210,
        '(', 132,
        '*', 158,
        '+', 209,
        '-', 196,
        '/', 207,
        ';', 126,
        '<', 212,
        '=', 20,
        '>', 211,
        '?', 336,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'a', 286,
        'b', 303,
        'c', 292,
        'e', 235,
        'f', 229,
        'i', 253,
        'l', 240,
        'm', 228,
        'n', 225,
        'o', 301,
        'p', 322,
        'r', 248,
        's', 262,
        't', 261,
        'u', 282,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(122);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('d' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 123:
      if (eof) ADVANCE(125);
      ADVANCE_MAP(
        '"', 333,
        '#', 9,
        '$', 343,
        '(', 132,
        '+', 116,
        '-', 196,
        '/', 17,
        ';', 126,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'b', 303,
        'c', 292,
        'e', 236,
        'f', 223,
        'i', 254,
        'l', 240,
        'm', 228,
        'n', 225,
        'p', 322,
        'r', 248,
        's', 262,
        't', 302,
        'u', 282,
        '}', 128,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(123);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 124:
      if (eof) ADVANCE(125);
      ADVANCE_MAP(
        '"', 333,
        '#', 9,
        '$', 343,
        '(', 132,
        '+', 116,
        '-', 196,
        '/', 17,
        ';', 126,
        'B', 295,
        'N', 321,
        'T', 239,
        '[', 159,
        'b', 303,
        'c', 292,
        'e', 235,
        'f', 223,
        'i', 254,
        'l', 240,
        'm', 228,
        'n', 225,
        'p', 322,
        'r', 248,
        's', 262,
        't', 302,
        'u', 282,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(124);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_main);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_main);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_echo);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_echo);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_exit);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_exit);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_reference);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_reference);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(215);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_preprocessor_directive);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_shebang);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_pub);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_pub);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_fun);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_fun);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_return);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_fail);
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_fail);
      if (lookahead == 'e') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_fail);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_as);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_import);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_let);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_else);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_then);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_then);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_loop);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_for);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_break);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_continue);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_boolean);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_boolean);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_null);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(184);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_Text);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_Text);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_Num);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_Num);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_Bool);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_Bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_Null);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_Null);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_status);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_status);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_unsafe);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_unsafe);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_trust);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_trust);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_silent);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_silent);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_nameof);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_nameof);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(346);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(182);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(213);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(214);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_is);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(265);
      if (lookahead == 'o') ADVANCE(300);
      if (lookahead == 'u') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(265);
      if (lookahead == 'o') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(281);
      if (lookahead == 'o') ADVANCE(312);
      if (lookahead == 'u') ADVANCE(278);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(269);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(267);
      if (lookahead == 'o') ADVANCE(300);
      if (lookahead == 'u') ADVANCE(283);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(267);
      if (lookahead == 'o') ADVANCE(300);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(319);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'a') ADVANCE(268);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'b') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'c') ADVANCE(260);
      if (lookahead == 'l') ADVANCE(310);
      if (lookahead == 'x') ADVANCE(266);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'c') ADVANCE(260);
      if (lookahead == 'x') ADVANCE(266);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(218);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'd') ADVANCE(335);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(327);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(311);
      if (lookahead == 'o') ADVANCE(293);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(179);
      if (lookahead == 's') ADVANCE(315);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(200);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(177);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(238);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(226);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(318);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(258);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(294);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(287);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'e') ADVANCE(290);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(164);
      if (lookahead == 'm') ADVANCE(299);
      if (lookahead == 's') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(164);
      if (lookahead == 'm') ADVANCE(299);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(164);
      if (lookahead == 's') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'f') ADVANCE(243);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'h') ADVANCE(291);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'h') ADVANCE(251);
      if (lookahead == 'r') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(277);
      if (lookahead == 't') ADVANCE(231);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(284);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(289);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(272);
      if (lookahead == 'l') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(314);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(274);
      if (lookahead == 'l') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'i') ADVANCE(279);
      if (lookahead == 'l') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'k') ADVANCE(175);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(152);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(151);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(309);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(271);
      if (lookahead == 'm') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(252);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(273);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(246);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'l') ADVANCE(310);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'm') ADVANCE(250);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(308);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(237);
      if (lookahead == 's') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(168);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(320);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(326);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'n') ADVANCE(317);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(288);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(298);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(296);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'o') ADVANCE(305);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'p') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'p') ADVANCE(297);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(172);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(220);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(323);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(247);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(285);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'r') ADVANCE(316);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(222);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(227);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(242);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 's') ADVANCE(245);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(202);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(325);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(324);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 't') ADVANCE(264);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(276);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(241);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(306);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(304);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'u') ADVANCE(244);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_variable);
      if (lookahead == 'x') ADVANCE(313);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_variable);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '\n') ADVANCE(332);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(329);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '/') ADVANCE(331);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(330);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(332);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead == '/') ADVANCE(329);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(332);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_string_content);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(332);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_failed);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_failed);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(328);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_handler_propagation);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(337);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_command_content);
      if (lookahead == '\n') ADVANCE(342);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(339);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_command_content);
      if (lookahead == '/') ADVANCE(341);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(340);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(342);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_command_content);
      if (lookahead == '/') ADVANCE(339);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(342);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_command_content);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '-' &&
          lookahead != '\\' &&
          lookahead != '{') ADVANCE(342);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_command_option);
      if (lookahead == '-') ADVANCE(345);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(345);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_command_option);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(345);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(346);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 123},
  [2] = {.lex_state = 123},
  [3] = {.lex_state = 123},
  [4] = {.lex_state = 119},
  [5] = {.lex_state = 119},
  [6] = {.lex_state = 122},
  [7] = {.lex_state = 122},
  [8] = {.lex_state = 122},
  [9] = {.lex_state = 119},
  [10] = {.lex_state = 122},
  [11] = {.lex_state = 122},
  [12] = {.lex_state = 121},
  [13] = {.lex_state = 121},
  [14] = {.lex_state = 121},
  [15] = {.lex_state = 121},
  [16] = {.lex_state = 121},
  [17] = {.lex_state = 10},
  [18] = {.lex_state = 119},
  [19] = {.lex_state = 119},
  [20] = {.lex_state = 10},
  [21] = {.lex_state = 120},
  [22] = {.lex_state = 10},
  [23] = {.lex_state = 10},
  [24] = {.lex_state = 10},
  [25] = {.lex_state = 10},
  [26] = {.lex_state = 10},
  [27] = {.lex_state = 10},
  [28] = {.lex_state = 10},
  [29] = {.lex_state = 10},
  [30] = {.lex_state = 10},
  [31] = {.lex_state = 10},
  [32] = {.lex_state = 10},
  [33] = {.lex_state = 10},
  [34] = {.lex_state = 10},
  [35] = {.lex_state = 10},
  [36] = {.lex_state = 10},
  [37] = {.lex_state = 119},
  [38] = {.lex_state = 10},
  [39] = {.lex_state = 10},
  [40] = {.lex_state = 10},
  [41] = {.lex_state = 10},
  [42] = {.lex_state = 10},
  [43] = {.lex_state = 10},
  [44] = {.lex_state = 120},
  [45] = {.lex_state = 120},
  [46] = {.lex_state = 120},
  [47] = {.lex_state = 119},
  [48] = {.lex_state = 120},
  [49] = {.lex_state = 120},
  [50] = {.lex_state = 120},
  [51] = {.lex_state = 120},
  [52] = {.lex_state = 120},
  [53] = {.lex_state = 120},
  [54] = {.lex_state = 120},
  [55] = {.lex_state = 120},
  [56] = {.lex_state = 120},
  [57] = {.lex_state = 120},
  [58] = {.lex_state = 119},
  [59] = {.lex_state = 120},
  [60] = {.lex_state = 119},
  [61] = {.lex_state = 119},
  [62] = {.lex_state = 120},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 120},
  [65] = {.lex_state = 10},
  [66] = {.lex_state = 120},
  [67] = {.lex_state = 120},
  [68] = {.lex_state = 10},
  [69] = {.lex_state = 119},
  [70] = {.lex_state = 10},
  [71] = {.lex_state = 10},
  [72] = {.lex_state = 120},
  [73] = {.lex_state = 120},
  [74] = {.lex_state = 10},
  [75] = {.lex_state = 120},
  [76] = {.lex_state = 10},
  [77] = {.lex_state = 119},
  [78] = {.lex_state = 120},
  [79] = {.lex_state = 119},
  [80] = {.lex_state = 120},
  [81] = {.lex_state = 120},
  [82] = {.lex_state = 120},
  [83] = {.lex_state = 10},
  [84] = {.lex_state = 10},
  [85] = {.lex_state = 120},
  [86] = {.lex_state = 10},
  [87] = {.lex_state = 10},
  [88] = {.lex_state = 120},
  [89] = {.lex_state = 10},
  [90] = {.lex_state = 10},
  [91] = {.lex_state = 120},
  [92] = {.lex_state = 10},
  [93] = {.lex_state = 119},
  [94] = {.lex_state = 119},
  [95] = {.lex_state = 120},
  [96] = {.lex_state = 10},
  [97] = {.lex_state = 120},
  [98] = {.lex_state = 120},
  [99] = {.lex_state = 120},
  [100] = {.lex_state = 120},
  [101] = {.lex_state = 10},
  [102] = {.lex_state = 120},
  [103] = {.lex_state = 119},
  [104] = {.lex_state = 120},
  [105] = {.lex_state = 119},
  [106] = {.lex_state = 119},
  [107] = {.lex_state = 120},
  [108] = {.lex_state = 119},
  [109] = {.lex_state = 119},
  [110] = {.lex_state = 120},
  [111] = {.lex_state = 10},
  [112] = {.lex_state = 10},
  [113] = {.lex_state = 120},
  [114] = {.lex_state = 120},
  [115] = {.lex_state = 10},
  [116] = {.lex_state = 120},
  [117] = {.lex_state = 120},
  [118] = {.lex_state = 120},
  [119] = {.lex_state = 120},
  [120] = {.lex_state = 120},
  [121] = {.lex_state = 120},
  [122] = {.lex_state = 10},
  [123] = {.lex_state = 10},
  [124] = {.lex_state = 120},
  [125] = {.lex_state = 119},
  [126] = {.lex_state = 119},
  [127] = {.lex_state = 119},
  [128] = {.lex_state = 119},
  [129] = {.lex_state = 119},
  [130] = {.lex_state = 4},
  [131] = {.lex_state = 119},
  [132] = {.lex_state = 4},
  [133] = {.lex_state = 119},
  [134] = {.lex_state = 119},
  [135] = {.lex_state = 4},
  [136] = {.lex_state = 119},
  [137] = {.lex_state = 4},
  [138] = {.lex_state = 119},
  [139] = {.lex_state = 119},
  [140] = {.lex_state = 119},
  [141] = {.lex_state = 119},
  [142] = {.lex_state = 119},
  [143] = {.lex_state = 119},
  [144] = {.lex_state = 119},
  [145] = {.lex_state = 119},
  [146] = {.lex_state = 119},
  [147] = {.lex_state = 119},
  [148] = {.lex_state = 119},
  [149] = {.lex_state = 119},
  [150] = {.lex_state = 119},
  [151] = {.lex_state = 119},
  [152] = {.lex_state = 119},
  [153] = {.lex_state = 119},
  [154] = {.lex_state = 119},
  [155] = {.lex_state = 4},
  [156] = {.lex_state = 119},
  [157] = {.lex_state = 119},
  [158] = {.lex_state = 119},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 3},
  [163] = {.lex_state = 3},
  [164] = {.lex_state = 2},
  [165] = {.lex_state = 2},
  [166] = {.lex_state = 2},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 2},
  [169] = {.lex_state = 2},
  [170] = {.lex_state = 2},
  [171] = {.lex_state = 2},
  [172] = {.lex_state = 2},
  [173] = {.lex_state = 2},
  [174] = {.lex_state = 2},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 2},
  [177] = {.lex_state = 2},
  [178] = {.lex_state = 2},
  [179] = {.lex_state = 2},
  [180] = {.lex_state = 2},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 2},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 2},
  [185] = {.lex_state = 2},
  [186] = {.lex_state = 2},
  [187] = {.lex_state = 2},
  [188] = {.lex_state = 2},
  [189] = {.lex_state = 2},
  [190] = {.lex_state = 2},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 2},
  [193] = {.lex_state = 2},
  [194] = {.lex_state = 2},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 2},
  [199] = {.lex_state = 2},
  [200] = {.lex_state = 2},
  [201] = {.lex_state = 2},
  [202] = {.lex_state = 2},
  [203] = {.lex_state = 2},
  [204] = {.lex_state = 2},
  [205] = {.lex_state = 2},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 2},
  [208] = {.lex_state = 2},
  [209] = {.lex_state = 2},
  [210] = {.lex_state = 2},
  [211] = {.lex_state = 2},
  [212] = {.lex_state = 2},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 2},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 2},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 2},
  [222] = {.lex_state = 2},
  [223] = {.lex_state = 2},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 2},
  [226] = {.lex_state = 2},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 1},
  [234] = {.lex_state = 1},
  [235] = {.lex_state = 1},
  [236] = {.lex_state = 1},
  [237] = {.lex_state = 1},
  [238] = {.lex_state = 1},
  [239] = {.lex_state = 1},
  [240] = {.lex_state = 1},
  [241] = {.lex_state = 1},
  [242] = {.lex_state = 1},
  [243] = {.lex_state = 1},
  [244] = {.lex_state = 1},
  [245] = {.lex_state = 1},
  [246] = {.lex_state = 1},
  [247] = {.lex_state = 1},
  [248] = {.lex_state = 1},
  [249] = {.lex_state = 1},
  [250] = {.lex_state = 1},
  [251] = {.lex_state = 1},
  [252] = {.lex_state = 1},
  [253] = {.lex_state = 1},
  [254] = {.lex_state = 1},
  [255] = {.lex_state = 1},
  [256] = {.lex_state = 1},
  [257] = {.lex_state = 6},
  [258] = {.lex_state = 6},
  [259] = {.lex_state = 6},
  [260] = {.lex_state = 6},
  [261] = {.lex_state = 6},
  [262] = {.lex_state = 5},
  [263] = {.lex_state = 5},
  [264] = {.lex_state = 123},
  [265] = {.lex_state = 124},
  [266] = {.lex_state = 123},
  [267] = {.lex_state = 5},
  [268] = {.lex_state = 123},
  [269] = {.lex_state = 124},
  [270] = {.lex_state = 5},
  [271] = {.lex_state = 5},
  [272] = {.lex_state = 5},
  [273] = {.lex_state = 123},
  [274] = {.lex_state = 123},
  [275] = {.lex_state = 5},
  [276] = {.lex_state = 5},
  [277] = {.lex_state = 123},
  [278] = {.lex_state = 123},
  [279] = {.lex_state = 124},
  [280] = {.lex_state = 124},
  [281] = {.lex_state = 124},
  [282] = {.lex_state = 123},
  [283] = {.lex_state = 124},
  [284] = {.lex_state = 5},
  [285] = {.lex_state = 5},
  [286] = {.lex_state = 5},
  [287] = {.lex_state = 124},
  [288] = {.lex_state = 123},
  [289] = {.lex_state = 5},
  [290] = {.lex_state = 5},
  [291] = {.lex_state = 124},
  [292] = {.lex_state = 124},
  [293] = {.lex_state = 5},
  [294] = {.lex_state = 124},
  [295] = {.lex_state = 124},
  [296] = {.lex_state = 124},
  [297] = {.lex_state = 5},
  [298] = {.lex_state = 5},
  [299] = {.lex_state = 124},
  [300] = {.lex_state = 123},
  [301] = {.lex_state = 123},
  [302] = {.lex_state = 123},
  [303] = {.lex_state = 123},
  [304] = {.lex_state = 124},
  [305] = {.lex_state = 5},
  [306] = {.lex_state = 5},
  [307] = {.lex_state = 123},
  [308] = {.lex_state = 123},
  [309] = {.lex_state = 123},
  [310] = {.lex_state = 123},
  [311] = {.lex_state = 123},
  [312] = {.lex_state = 123},
  [313] = {.lex_state = 123},
  [314] = {.lex_state = 123},
  [315] = {.lex_state = 123},
  [316] = {.lex_state = 123},
  [317] = {.lex_state = 5},
  [318] = {.lex_state = 5},
  [319] = {.lex_state = 5},
  [320] = {.lex_state = 5},
  [321] = {.lex_state = 5},
  [322] = {.lex_state = 123},
  [323] = {.lex_state = 123},
  [324] = {.lex_state = 5},
  [325] = {.lex_state = 5},
  [326] = {.lex_state = 5},
  [327] = {.lex_state = 5},
  [328] = {.lex_state = 123},
  [329] = {.lex_state = 5},
  [330] = {.lex_state = 5},
  [331] = {.lex_state = 5},
  [332] = {.lex_state = 5},
  [333] = {.lex_state = 5},
  [334] = {.lex_state = 5},
  [335] = {.lex_state = 5},
  [336] = {.lex_state = 5},
  [337] = {.lex_state = 123},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 123},
  [340] = {.lex_state = 5},
  [341] = {.lex_state = 5},
  [342] = {.lex_state = 5},
  [343] = {.lex_state = 123},
  [344] = {.lex_state = 5},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 5},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 5},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 123},
  [353] = {.lex_state = 13},
  [354] = {.lex_state = 13},
  [355] = {.lex_state = 13},
  [356] = {.lex_state = 13},
  [357] = {.lex_state = 13},
  [358] = {.lex_state = 13},
  [359] = {.lex_state = 13},
  [360] = {.lex_state = 13},
  [361] = {.lex_state = 13},
  [362] = {.lex_state = 13},
  [363] = {.lex_state = 13},
  [364] = {.lex_state = 13},
  [365] = {.lex_state = 13},
  [366] = {.lex_state = 13},
  [367] = {.lex_state = 13},
  [368] = {.lex_state = 13},
  [369] = {.lex_state = 13},
  [370] = {.lex_state = 13},
  [371] = {.lex_state = 13},
  [372] = {.lex_state = 13},
  [373] = {.lex_state = 13},
  [374] = {.lex_state = 13},
  [375] = {.lex_state = 13},
  [376] = {.lex_state = 11},
  [377] = {.lex_state = 11},
  [378] = {.lex_state = 12},
  [379] = {.lex_state = 12},
  [380] = {.lex_state = 12},
  [381] = {.lex_state = 12},
  [382] = {.lex_state = 12},
  [383] = {.lex_state = 12},
  [384] = {.lex_state = 12},
  [385] = {.lex_state = 12},
  [386] = {.lex_state = 12},
  [387] = {.lex_state = 12},
  [388] = {.lex_state = 12},
  [389] = {.lex_state = 12},
  [390] = {.lex_state = 12},
  [391] = {.lex_state = 12},
  [392] = {.lex_state = 12},
  [393] = {.lex_state = 12},
  [394] = {.lex_state = 12},
  [395] = {.lex_state = 12},
  [396] = {.lex_state = 12},
  [397] = {.lex_state = 12},
  [398] = {.lex_state = 12},
  [399] = {.lex_state = 12},
  [400] = {.lex_state = 12},
  [401] = {.lex_state = 12},
  [402] = {.lex_state = 12},
  [403] = {.lex_state = 12},
  [404] = {.lex_state = 12},
  [405] = {.lex_state = 12},
  [406] = {.lex_state = 11},
  [407] = {.lex_state = 11},
  [408] = {.lex_state = 11},
  [409] = {.lex_state = 11},
  [410] = {.lex_state = 11},
  [411] = {.lex_state = 11},
  [412] = {.lex_state = 11},
  [413] = {.lex_state = 11},
  [414] = {.lex_state = 12},
  [415] = {.lex_state = 11},
  [416] = {.lex_state = 11},
  [417] = {.lex_state = 11},
  [418] = {.lex_state = 11},
  [419] = {.lex_state = 12},
  [420] = {.lex_state = 10},
  [421] = {.lex_state = 12},
  [422] = {.lex_state = 12},
  [423] = {.lex_state = 12},
  [424] = {.lex_state = 12},
  [425] = {.lex_state = 10},
  [426] = {.lex_state = 12},
  [427] = {.lex_state = 10},
  [428] = {.lex_state = 12},
  [429] = {.lex_state = 12},
  [430] = {.lex_state = 10},
  [431] = {.lex_state = 10},
  [432] = {.lex_state = 10},
  [433] = {.lex_state = 12},
  [434] = {.lex_state = 12},
  [435] = {.lex_state = 12},
  [436] = {.lex_state = 12},
  [437] = {.lex_state = 12},
  [438] = {.lex_state = 12},
  [439] = {.lex_state = 10},
  [440] = {.lex_state = 12},
  [441] = {.lex_state = 12},
  [442] = {.lex_state = 12},
  [443] = {.lex_state = 12},
  [444] = {.lex_state = 12},
  [445] = {.lex_state = 12},
  [446] = {.lex_state = 12},
  [447] = {.lex_state = 12},
  [448] = {.lex_state = 12},
  [449] = {.lex_state = 12},
  [450] = {.lex_state = 12},
  [451] = {.lex_state = 12},
  [452] = {.lex_state = 10},
  [453] = {.lex_state = 12},
  [454] = {.lex_state = 12},
  [455] = {.lex_state = 12},
  [456] = {.lex_state = 12},
  [457] = {.lex_state = 12},
  [458] = {.lex_state = 12},
  [459] = {.lex_state = 12},
  [460] = {.lex_state = 12},
  [461] = {.lex_state = 12},
  [462] = {.lex_state = 12},
  [463] = {.lex_state = 12},
  [464] = {.lex_state = 12},
  [465] = {.lex_state = 10},
  [466] = {.lex_state = 10},
  [467] = {.lex_state = 12},
  [468] = {.lex_state = 12},
  [469] = {.lex_state = 12},
  [470] = {.lex_state = 12},
  [471] = {.lex_state = 12},
  [472] = {.lex_state = 10},
  [473] = {.lex_state = 12},
  [474] = {.lex_state = 12},
  [475] = {.lex_state = 12},
  [476] = {.lex_state = 10},
  [477] = {.lex_state = 10},
  [478] = {.lex_state = 12},
  [479] = {.lex_state = 12},
  [480] = {.lex_state = 12},
  [481] = {.lex_state = 12},
  [482] = {.lex_state = 12},
  [483] = {.lex_state = 12},
  [484] = {.lex_state = 12},
  [485] = {.lex_state = 12},
  [486] = {.lex_state = 12},
  [487] = {.lex_state = 12},
  [488] = {.lex_state = 12},
  [489] = {.lex_state = 12},
  [490] = {.lex_state = 12},
  [491] = {.lex_state = 12},
  [492] = {.lex_state = 12},
  [493] = {.lex_state = 12},
  [494] = {.lex_state = 12},
  [495] = {.lex_state = 12},
  [496] = {.lex_state = 12},
  [497] = {.lex_state = 12},
  [498] = {.lex_state = 12},
  [499] = {.lex_state = 12},
  [500] = {.lex_state = 12},
  [501] = {.lex_state = 12},
  [502] = {.lex_state = 12},
  [503] = {.lex_state = 12},
  [504] = {.lex_state = 12},
  [505] = {.lex_state = 12},
  [506] = {.lex_state = 12},
  [507] = {.lex_state = 12},
  [508] = {.lex_state = 12},
  [509] = {.lex_state = 12},
  [510] = {.lex_state = 12},
  [511] = {.lex_state = 12},
  [512] = {.lex_state = 12},
  [513] = {.lex_state = 12},
  [514] = {.lex_state = 12},
  [515] = {.lex_state = 12},
  [516] = {.lex_state = 12},
  [517] = {.lex_state = 12},
  [518] = {.lex_state = 12},
  [519] = {.lex_state = 12},
  [520] = {.lex_state = 12},
  [521] = {.lex_state = 12},
  [522] = {.lex_state = 12},
  [523] = {.lex_state = 12},
  [524] = {.lex_state = 12},
  [525] = {.lex_state = 12},
  [526] = {.lex_state = 12},
  [527] = {.lex_state = 12},
  [528] = {.lex_state = 12},
  [529] = {.lex_state = 12},
  [530] = {.lex_state = 12},
  [531] = {.lex_state = 12},
  [532] = {.lex_state = 12},
  [533] = {.lex_state = 12},
  [534] = {.lex_state = 12},
  [535] = {.lex_state = 12},
  [536] = {.lex_state = 12},
  [537] = {.lex_state = 12},
  [538] = {.lex_state = 12},
  [539] = {.lex_state = 10},
  [540] = {.lex_state = 12},
  [541] = {.lex_state = 12},
  [542] = {.lex_state = 12},
  [543] = {.lex_state = 12},
  [544] = {.lex_state = 12},
  [545] = {.lex_state = 12},
  [546] = {.lex_state = 12},
  [547] = {.lex_state = 12},
  [548] = {.lex_state = 12},
  [549] = {.lex_state = 12},
  [550] = {.lex_state = 12},
  [551] = {.lex_state = 12},
  [552] = {.lex_state = 12},
  [553] = {.lex_state = 12},
  [554] = {.lex_state = 12},
  [555] = {.lex_state = 12},
  [556] = {.lex_state = 12},
  [557] = {.lex_state = 12},
  [558] = {.lex_state = 12},
  [559] = {.lex_state = 12},
  [560] = {.lex_state = 12},
  [561] = {.lex_state = 12},
  [562] = {.lex_state = 12},
  [563] = {.lex_state = 12},
  [564] = {.lex_state = 12},
  [565] = {.lex_state = 12},
  [566] = {.lex_state = 12},
  [567] = {.lex_state = 12},
  [568] = {.lex_state = 12},
  [569] = {.lex_state = 12},
  [570] = {.lex_state = 12},
  [571] = {.lex_state = 12},
  [572] = {.lex_state = 12},
  [573] = {.lex_state = 12},
  [574] = {.lex_state = 12},
  [575] = {.lex_state = 12},
  [576] = {.lex_state = 12},
  [577] = {.lex_state = 12},
  [578] = {.lex_state = 12},
  [579] = {.lex_state = 12},
  [580] = {.lex_state = 12},
  [581] = {.lex_state = 12},
  [582] = {.lex_state = 12},
  [583] = {.lex_state = 12},
  [584] = {.lex_state = 12},
  [585] = {.lex_state = 7},
  [586] = {.lex_state = 7},
  [587] = {.lex_state = 7},
  [588] = {.lex_state = 7},
  [589] = {.lex_state = 7},
  [590] = {.lex_state = 7},
  [591] = {.lex_state = 7},
  [592] = {.lex_state = 7},
  [593] = {.lex_state = 7},
  [594] = {.lex_state = 7},
  [595] = {.lex_state = 7},
  [596] = {.lex_state = 7},
  [597] = {.lex_state = 7},
  [598] = {.lex_state = 7},
  [599] = {.lex_state = 7},
  [600] = {.lex_state = 7},
  [601] = {.lex_state = 7},
  [602] = {.lex_state = 7},
  [603] = {.lex_state = 7},
  [604] = {.lex_state = 7},
  [605] = {.lex_state = 7},
  [606] = {.lex_state = 7},
  [607] = {.lex_state = 7},
  [608] = {.lex_state = 7},
  [609] = {.lex_state = 7},
  [610] = {.lex_state = 7},
  [611] = {.lex_state = 7},
  [612] = {.lex_state = 7},
  [613] = {.lex_state = 7},
  [614] = {.lex_state = 7},
  [615] = {.lex_state = 7},
  [616] = {.lex_state = 7},
  [617] = {.lex_state = 7},
  [618] = {.lex_state = 7},
  [619] = {.lex_state = 7},
  [620] = {.lex_state = 7},
  [621] = {.lex_state = 7},
  [622] = {.lex_state = 7},
  [623] = {.lex_state = 7},
  [624] = {.lex_state = 7},
  [625] = {.lex_state = 7},
  [626] = {.lex_state = 7},
  [627] = {.lex_state = 7},
  [628] = {.lex_state = 7},
  [629] = {.lex_state = 7},
  [630] = {.lex_state = 7},
  [631] = {.lex_state = 7},
  [632] = {.lex_state = 7},
  [633] = {.lex_state = 7},
  [634] = {.lex_state = 7},
  [635] = {.lex_state = 7},
  [636] = {.lex_state = 7},
  [637] = {.lex_state = 7},
  [638] = {.lex_state = 7},
  [639] = {.lex_state = 7},
  [640] = {.lex_state = 7},
  [641] = {.lex_state = 7},
  [642] = {.lex_state = 7},
  [643] = {.lex_state = 7},
  [644] = {.lex_state = 7},
  [645] = {.lex_state = 7},
  [646] = {.lex_state = 7},
  [647] = {.lex_state = 7},
  [648] = {.lex_state = 7},
  [649] = {.lex_state = 7},
  [650] = {.lex_state = 7},
  [651] = {.lex_state = 7},
  [652] = {.lex_state = 7},
  [653] = {.lex_state = 7},
  [654] = {.lex_state = 7},
  [655] = {.lex_state = 7},
  [656] = {.lex_state = 7},
  [657] = {.lex_state = 7},
  [658] = {.lex_state = 7},
  [659] = {.lex_state = 7},
  [660] = {.lex_state = 13},
  [661] = {.lex_state = 13},
  [662] = {.lex_state = 13},
  [663] = {.lex_state = 7},
  [664] = {.lex_state = 13},
  [665] = {.lex_state = 13},
  [666] = {.lex_state = 13},
  [667] = {.lex_state = 13},
  [668] = {.lex_state = 13},
  [669] = {.lex_state = 13},
  [670] = {.lex_state = 13},
  [671] = {.lex_state = 13},
  [672] = {.lex_state = 7},
  [673] = {.lex_state = 13},
  [674] = {.lex_state = 13},
  [675] = {.lex_state = 13},
  [676] = {.lex_state = 7},
  [677] = {.lex_state = 13},
  [678] = {.lex_state = 7},
  [679] = {.lex_state = 7},
  [680] = {.lex_state = 7},
  [681] = {.lex_state = 7},
  [682] = {.lex_state = 7},
  [683] = {.lex_state = 7},
  [684] = {.lex_state = 7},
  [685] = {.lex_state = 7},
  [686] = {.lex_state = 7},
  [687] = {.lex_state = 7},
  [688] = {.lex_state = 7},
  [689] = {.lex_state = 7},
  [690] = {.lex_state = 7},
  [691] = {.lex_state = 7},
  [692] = {.lex_state = 7},
  [693] = {.lex_state = 7},
  [694] = {.lex_state = 7},
  [695] = {.lex_state = 7},
  [696] = {.lex_state = 7},
  [697] = {.lex_state = 7},
  [698] = {.lex_state = 7},
  [699] = {.lex_state = 7},
  [700] = {.lex_state = 7},
  [701] = {.lex_state = 7},
  [702] = {.lex_state = 7},
  [703] = {.lex_state = 7},
  [704] = {.lex_state = 7},
  [705] = {.lex_state = 7},
  [706] = {.lex_state = 7},
  [707] = {.lex_state = 7},
  [708] = {.lex_state = 7},
  [709] = {.lex_state = 13},
  [710] = {.lex_state = 7},
  [711] = {.lex_state = 7},
  [712] = {.lex_state = 7},
  [713] = {.lex_state = 7},
  [714] = {.lex_state = 7},
  [715] = {.lex_state = 7},
  [716] = {.lex_state = 7},
  [717] = {.lex_state = 7},
  [718] = {.lex_state = 7},
  [719] = {.lex_state = 7},
  [720] = {.lex_state = 7},
  [721] = {.lex_state = 7},
  [722] = {.lex_state = 7},
  [723] = {.lex_state = 7},
  [724] = {.lex_state = 7},
  [725] = {.lex_state = 7},
  [726] = {.lex_state = 7},
  [727] = {.lex_state = 7},
  [728] = {.lex_state = 7},
  [729] = {.lex_state = 7},
  [730] = {.lex_state = 7},
  [731] = {.lex_state = 7},
  [732] = {.lex_state = 7},
  [733] = {.lex_state = 7},
  [734] = {.lex_state = 7},
  [735] = {.lex_state = 7},
  [736] = {.lex_state = 7},
  [737] = {.lex_state = 7},
  [738] = {.lex_state = 7},
  [739] = {.lex_state = 7},
  [740] = {.lex_state = 7},
  [741] = {.lex_state = 7},
  [742] = {.lex_state = 7},
  [743] = {.lex_state = 7},
  [744] = {.lex_state = 7},
  [745] = {.lex_state = 7},
  [746] = {.lex_state = 7},
  [747] = {.lex_state = 7},
  [748] = {.lex_state = 7},
  [749] = {.lex_state = 7},
  [750] = {.lex_state = 7},
  [751] = {.lex_state = 7},
  [752] = {.lex_state = 7},
  [753] = {.lex_state = 7},
  [754] = {.lex_state = 7},
  [755] = {.lex_state = 7},
  [756] = {.lex_state = 7},
  [757] = {.lex_state = 7},
  [758] = {.lex_state = 7},
  [759] = {.lex_state = 7},
  [760] = {.lex_state = 7},
  [761] = {.lex_state = 7},
  [762] = {.lex_state = 7},
  [763] = {.lex_state = 7},
  [764] = {.lex_state = 7},
  [765] = {.lex_state = 7},
  [766] = {.lex_state = 7},
  [767] = {.lex_state = 7},
  [768] = {.lex_state = 7},
  [769] = {.lex_state = 7},
  [770] = {.lex_state = 7},
  [771] = {.lex_state = 7},
  [772] = {.lex_state = 7},
  [773] = {.lex_state = 7},
  [774] = {.lex_state = 7},
  [775] = {.lex_state = 7},
  [776] = {.lex_state = 7},
  [777] = {.lex_state = 7},
  [778] = {.lex_state = 7},
  [779] = {.lex_state = 15},
  [780] = {.lex_state = 15},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 15},
  [784] = {.lex_state = 15},
  [785] = {.lex_state = 15},
  [786] = {.lex_state = 15},
  [787] = {.lex_state = 15},
  [788] = {.lex_state = 15},
  [789] = {.lex_state = 15},
  [790] = {.lex_state = 15},
  [791] = {.lex_state = 15},
  [792] = {.lex_state = 15},
  [793] = {.lex_state = 15},
  [794] = {.lex_state = 15},
  [795] = {.lex_state = 15},
  [796] = {.lex_state = 15},
  [797] = {.lex_state = 15},
  [798] = {.lex_state = 15},
  [799] = {.lex_state = 15},
  [800] = {.lex_state = 14},
  [801] = {.lex_state = 14},
  [802] = {.lex_state = 14},
  [803] = {.lex_state = 14},
  [804] = {.lex_state = 14},
  [805] = {.lex_state = 14},
  [806] = {.lex_state = 14},
  [807] = {.lex_state = 14},
  [808] = {.lex_state = 14},
  [809] = {.lex_state = 14},
  [810] = {.lex_state = 14},
  [811] = {.lex_state = 14},
  [812] = {.lex_state = 14},
  [813] = {.lex_state = 14},
  [814] = {.lex_state = 14},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 15},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 14},
  [819] = {.lex_state = 0},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 16},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 0},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 18},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 0},
  [867] = {.lex_state = 0},
  [868] = {.lex_state = 18},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 0},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 0},
  [883] = {.lex_state = 0},
  [884] = {.lex_state = 16},
  [885] = {.lex_state = 0},
  [886] = {.lex_state = 0},
  [887] = {.lex_state = 0},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 0},
  [890] = {.lex_state = 0},
  [891] = {.lex_state = 0},
  [892] = {.lex_state = 0},
  [893] = {.lex_state = 0},
  [894] = {.lex_state = 0},
  [895] = {.lex_state = 0},
  [896] = {.lex_state = 0},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 0},
  [899] = {.lex_state = 0},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 0},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 0},
  [904] = {.lex_state = 0},
  [905] = {.lex_state = 0},
  [906] = {.lex_state = 0},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 0},
  [909] = {.lex_state = 0},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 0},
  [912] = {.lex_state = 0},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 0},
  [915] = {.lex_state = 0},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 0},
  [918] = {.lex_state = 0},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 0},
  [921] = {.lex_state = 0},
  [922] = {.lex_state = 0},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 18},
  [925] = {.lex_state = 0},
  [926] = {.lex_state = 18},
  [927] = {.lex_state = 18},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 0},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 18},
  [933] = {.lex_state = 18},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 0},
  [936] = {.lex_state = 18},
  [937] = {.lex_state = 0},
  [938] = {.lex_state = 18},
  [939] = {.lex_state = 0},
  [940] = {.lex_state = 0},
  [941] = {.lex_state = 18},
  [942] = {.lex_state = 0},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 18},
  [947] = {.lex_state = 18},
  [948] = {.lex_state = 0},
  [949] = {.lex_state = 18},
  [950] = {.lex_state = 0},
  [951] = {.lex_state = 0},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 0},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 18},
  [958] = {.lex_state = 0},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 18},
  [961] = {.lex_state = 18},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 18},
  [964] = {.lex_state = 0},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 18},
  [972] = {.lex_state = 18},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 18},
  [976] = {.lex_state = 0},
  [977] = {.lex_state = 0},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 0},
  [988] = {.lex_state = 18},
  [989] = {.lex_state = 18},
  [990] = {.lex_state = 18},
  [991] = {.lex_state = 0},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 18},
  [1001] = {.lex_state = 18},
  [1002] = {.lex_state = 18},
  [1003] = {.lex_state = 18},
  [1004] = {.lex_state = 18},
  [1005] = {.lex_state = 18},
  [1006] = {.lex_state = 18},
  [1007] = {.lex_state = 18},
  [1008] = {.lex_state = 18},
  [1009] = {.lex_state = 18},
  [1010] = {.lex_state = 18},
  [1011] = {.lex_state = 18},
  [1012] = {.lex_state = 18},
  [1013] = {.lex_state = 18},
  [1014] = {.lex_state = 18},
  [1015] = {.lex_state = 18},
  [1016] = {.lex_state = 18},
  [1017] = {.lex_state = 18},
  [1018] = {.lex_state = 18},
  [1019] = {.lex_state = 18},
  [1020] = {.lex_state = 18},
  [1021] = {.lex_state = 18},
  [1022] = {.lex_state = 0},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 0},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 18},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 0},
  [1042] = {.lex_state = 18},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 0},
  [1045] = {.lex_state = 0},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 0},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 18},
  [1052] = {.lex_state = 0},
  [1053] = {.lex_state = 0},
  [1054] = {.lex_state = 0},
  [1055] = {.lex_state = 18},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 18},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 18},
  [1062] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_main] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_echo] = ACTIONS(1),
    [anon_sym_exit] = ACTIONS(1),
    [sym_reference] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_preprocessor_directive] = ACTIONS(1),
    [sym_shebang] = ACTIONS(1),
    [anon_sym_pub] = ACTIONS(1),
    [anon_sym_fun] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_fail] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_then] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [sym_boolean] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_number] = ACTIONS(1),
    [anon_sym_Text] = ACTIONS(1),
    [anon_sym_Num] = ACTIONS(1),
    [anon_sym_Bool] = ACTIONS(1),
    [anon_sym_Null] = ACTIONS(1),
    [sym_status] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_unsafe] = ACTIONS(1),
    [anon_sym_trust] = ACTIONS(1),
    [anon_sym_silent] = ACTIONS(1),
    [anon_sym_nameof] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_failed] = ACTIONS(1),
    [sym_handler_propagation] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(1043),
    [sym__global_statement] = STATE(3),
    [sym__statement] = STATE(310),
    [sym_main_block] = STATE(310),
    [sym_builtin] = STATE(310),
    [sym_function_definition] = STATE(310),
    [sym_function_control_flow] = STATE(310),
    [sym_import_statement] = STATE(310),
    [sym_subscript_expression] = STATE(125),
    [sym_variable_init] = STATE(310),
    [sym_variable_assignment] = STATE(310),
    [sym_parentheses] = STATE(125),
    [sym_if_cond] = STATE(310),
    [sym_if_chain] = STATE(310),
    [sym_if_ternary] = STATE(125),
    [sym_loop_infinite] = STATE(310),
    [sym_loop_iter] = STATE(310),
    [sym_loop_control_flow] = STATE(310),
    [sym_type_name_symbol] = STATE(5),
    [sym_type_name] = STATE(125),
    [sym_array] = STATE(125),
    [sym_function_call] = STATE(125),
    [sym_unop] = STATE(125),
    [sym_binop] = STATE(125),
    [sym_keyword_binop] = STATE(125),
    [sym_string] = STATE(125),
    [sym_command] = STATE(125),
    [sym__expression] = STATE(125),
    [aux_sym_source_file_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_main] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [sym_preprocessor_directive] = ACTIONS(13),
    [sym_shebang] = ACTIONS(15),
    [anon_sym_pub] = ACTIONS(17),
    [anon_sym_fun] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_fail] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_loop] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_break] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(35),
    [sym_boolean] = ACTIONS(37),
    [sym_null] = ACTIONS(37),
    [sym_number] = ACTIONS(37),
    [anon_sym_Text] = ACTIONS(39),
    [anon_sym_Num] = ACTIONS(39),
    [anon_sym_Bool] = ACTIONS(39),
    [anon_sym_Null] = ACTIONS(39),
    [sym_status] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_unsafe] = ACTIONS(41),
    [anon_sym_trust] = ACTIONS(41),
    [anon_sym_silent] = ACTIONS(41),
    [anon_sym_nameof] = ACTIONS(41),
    [sym_variable] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym__global_statement] = STATE(2),
    [sym__statement] = STATE(310),
    [sym_main_block] = STATE(310),
    [sym_builtin] = STATE(310),
    [sym_function_definition] = STATE(310),
    [sym_function_control_flow] = STATE(310),
    [sym_import_statement] = STATE(310),
    [sym_subscript_expression] = STATE(125),
    [sym_variable_init] = STATE(310),
    [sym_variable_assignment] = STATE(310),
    [sym_parentheses] = STATE(125),
    [sym_if_cond] = STATE(310),
    [sym_if_chain] = STATE(310),
    [sym_if_ternary] = STATE(125),
    [sym_loop_infinite] = STATE(310),
    [sym_loop_iter] = STATE(310),
    [sym_loop_control_flow] = STATE(310),
    [sym_type_name_symbol] = STATE(5),
    [sym_type_name] = STATE(125),
    [sym_array] = STATE(125),
    [sym_function_call] = STATE(125),
    [sym_unop] = STATE(125),
    [sym_binop] = STATE(125),
    [sym_keyword_binop] = STATE(125),
    [sym_string] = STATE(125),
    [sym_command] = STATE(125),
    [sym__expression] = STATE(125),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(49),
    [anon_sym_main] = ACTIONS(51),
    [anon_sym_LPAREN] = ACTIONS(54),
    [anon_sym_echo] = ACTIONS(57),
    [anon_sym_exit] = ACTIONS(57),
    [sym_preprocessor_directive] = ACTIONS(60),
    [sym_shebang] = ACTIONS(63),
    [anon_sym_pub] = ACTIONS(66),
    [anon_sym_fun] = ACTIONS(69),
    [anon_sym_return] = ACTIONS(72),
    [anon_sym_fail] = ACTIONS(72),
    [anon_sym_import] = ACTIONS(75),
    [anon_sym_LBRACK] = ACTIONS(78),
    [anon_sym_let] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(84),
    [anon_sym_loop] = ACTIONS(87),
    [anon_sym_for] = ACTIONS(90),
    [anon_sym_break] = ACTIONS(93),
    [anon_sym_continue] = ACTIONS(93),
    [sym_boolean] = ACTIONS(96),
    [sym_null] = ACTIONS(96),
    [sym_number] = ACTIONS(96),
    [anon_sym_Text] = ACTIONS(99),
    [anon_sym_Num] = ACTIONS(99),
    [anon_sym_Bool] = ACTIONS(99),
    [anon_sym_Null] = ACTIONS(99),
    [sym_status] = ACTIONS(96),
    [anon_sym_DASH] = ACTIONS(102),
    [anon_sym_not] = ACTIONS(102),
    [anon_sym_unsafe] = ACTIONS(102),
    [anon_sym_trust] = ACTIONS(102),
    [anon_sym_silent] = ACTIONS(102),
    [anon_sym_nameof] = ACTIONS(102),
    [sym_variable] = ACTIONS(105),
    [anon_sym_DQUOTE] = ACTIONS(108),
    [anon_sym_DOLLAR] = ACTIONS(111),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym__global_statement] = STATE(2),
    [sym__statement] = STATE(310),
    [sym_main_block] = STATE(310),
    [sym_builtin] = STATE(310),
    [sym_function_definition] = STATE(310),
    [sym_function_control_flow] = STATE(310),
    [sym_import_statement] = STATE(310),
    [sym_subscript_expression] = STATE(125),
    [sym_variable_init] = STATE(310),
    [sym_variable_assignment] = STATE(310),
    [sym_parentheses] = STATE(125),
    [sym_if_cond] = STATE(310),
    [sym_if_chain] = STATE(310),
    [sym_if_ternary] = STATE(125),
    [sym_loop_infinite] = STATE(310),
    [sym_loop_iter] = STATE(310),
    [sym_loop_control_flow] = STATE(310),
    [sym_type_name_symbol] = STATE(5),
    [sym_type_name] = STATE(125),
    [sym_array] = STATE(125),
    [sym_function_call] = STATE(125),
    [sym_unop] = STATE(125),
    [sym_binop] = STATE(125),
    [sym_keyword_binop] = STATE(125),
    [sym_string] = STATE(125),
    [sym_command] = STATE(125),
    [sym__expression] = STATE(125),
    [aux_sym_source_file_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(114),
    [anon_sym_main] = ACTIONS(7),
    [anon_sym_LPAREN] = ACTIONS(9),
    [anon_sym_echo] = ACTIONS(11),
    [anon_sym_exit] = ACTIONS(11),
    [sym_preprocessor_directive] = ACTIONS(13),
    [sym_shebang] = ACTIONS(15),
    [anon_sym_pub] = ACTIONS(17),
    [anon_sym_fun] = ACTIONS(19),
    [anon_sym_return] = ACTIONS(21),
    [anon_sym_fail] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_LBRACK] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(27),
    [anon_sym_if] = ACTIONS(29),
    [anon_sym_loop] = ACTIONS(31),
    [anon_sym_for] = ACTIONS(33),
    [anon_sym_break] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(35),
    [sym_boolean] = ACTIONS(37),
    [sym_null] = ACTIONS(37),
    [sym_number] = ACTIONS(37),
    [anon_sym_Text] = ACTIONS(39),
    [anon_sym_Num] = ACTIONS(39),
    [anon_sym_Bool] = ACTIONS(39),
    [anon_sym_Null] = ACTIONS(39),
    [sym_status] = ACTIONS(37),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_not] = ACTIONS(41),
    [anon_sym_unsafe] = ACTIONS(41),
    [anon_sym_trust] = ACTIONS(41),
    [anon_sym_silent] = ACTIONS(41),
    [anon_sym_nameof] = ACTIONS(41),
    [sym_variable] = ACTIONS(43),
    [anon_sym_DQUOTE] = ACTIONS(45),
    [anon_sym_DOLLAR] = ACTIONS(47),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [ts_builtin_sym_end] = ACTIONS(116),
    [anon_sym_SEMI] = ACTIONS(116),
    [anon_sym_LBRACE] = ACTIONS(116),
    [anon_sym_COLON] = ACTIONS(116),
    [anon_sym_main] = ACTIONS(118),
    [anon_sym_LPAREN] = ACTIONS(116),
    [anon_sym_RPAREN] = ACTIONS(116),
    [anon_sym_echo] = ACTIONS(118),
    [anon_sym_exit] = ACTIONS(118),
    [anon_sym_EQ] = ACTIONS(118),
    [anon_sym_COMMA] = ACTIONS(116),
    [sym_preprocessor_directive] = ACTIONS(116),
    [sym_shebang] = ACTIONS(116),
    [anon_sym_pub] = ACTIONS(118),
    [anon_sym_fun] = ACTIONS(118),
    [anon_sym_return] = ACTIONS(118),
    [anon_sym_fail] = ACTIONS(118),
    [anon_sym_as] = ACTIONS(118),
    [anon_sym_import] = ACTIONS(118),
    [anon_sym_STAR] = ACTIONS(116),
    [anon_sym_LBRACK] = ACTIONS(116),
    [anon_sym_RBRACK] = ACTIONS(116),
    [anon_sym_let] = ACTIONS(118),
    [anon_sym_if] = ACTIONS(118),
    [anon_sym_then] = ACTIONS(118),
    [anon_sym_loop] = ACTIONS(118),
    [anon_sym_for] = ACTIONS(118),
    [anon_sym_break] = ACTIONS(118),
    [anon_sym_continue] = ACTIONS(118),
    [sym_boolean] = ACTIONS(118),
    [sym_null] = ACTIONS(118),
    [sym_number] = ACTIONS(118),
    [anon_sym_Text] = ACTIONS(118),
    [anon_sym_Num] = ACTIONS(118),
    [anon_sym_Bool] = ACTIONS(118),
    [anon_sym_Null] = ACTIONS(118),
    [sym_status] = ACTIONS(118),
    [anon_sym_DASH] = ACTIONS(118),
    [anon_sym_not] = ACTIONS(118),
    [anon_sym_unsafe] = ACTIONS(118),
    [anon_sym_trust] = ACTIONS(118),
    [anon_sym_silent] = ACTIONS(118),
    [anon_sym_nameof] = ACTIONS(118),
    [anon_sym_SLASH] = ACTIONS(118),
    [anon_sym_PLUS] = ACTIONS(118),
    [anon_sym_PERCENT] = ACTIONS(116),
    [anon_sym_GT] = ACTIONS(118),
    [anon_sym_LT] = ACTIONS(118),
    [anon_sym_GT_EQ] = ACTIONS(116),
    [anon_sym_LT_EQ] = ACTIONS(116),
    [anon_sym_EQ_EQ] = ACTIONS(116),
    [anon_sym_BANG_EQ] = ACTIONS(116),
    [anon_sym_and] = ACTIONS(118),
    [anon_sym_or] = ACTIONS(118),
    [anon_sym_is] = ACTIONS(118),
    [sym_variable] = ACTIONS(118),
    [anon_sym_DQUOTE] = ACTIONS(116),
    [anon_sym_DOLLAR] = ACTIONS(116),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [ts_builtin_sym_end] = ACTIONS(120),
    [anon_sym_SEMI] = ACTIONS(120),
    [anon_sym_LBRACE] = ACTIONS(120),
    [anon_sym_COLON] = ACTIONS(120),
    [anon_sym_main] = ACTIONS(122),
    [anon_sym_LPAREN] = ACTIONS(120),
    [anon_sym_RPAREN] = ACTIONS(120),
    [anon_sym_echo] = ACTIONS(122),
    [anon_sym_exit] = ACTIONS(122),
    [anon_sym_EQ] = ACTIONS(122),
    [anon_sym_COMMA] = ACTIONS(120),
    [sym_preprocessor_directive] = ACTIONS(120),
    [sym_shebang] = ACTIONS(120),
    [anon_sym_pub] = ACTIONS(122),
    [anon_sym_fun] = ACTIONS(122),
    [anon_sym_return] = ACTIONS(122),
    [anon_sym_fail] = ACTIONS(122),
    [anon_sym_as] = ACTIONS(122),
    [anon_sym_import] = ACTIONS(122),
    [anon_sym_STAR] = ACTIONS(120),
    [anon_sym_LBRACK] = ACTIONS(120),
    [anon_sym_let] = ACTIONS(122),
    [anon_sym_if] = ACTIONS(122),
    [anon_sym_then] = ACTIONS(122),
    [anon_sym_loop] = ACTIONS(122),
    [anon_sym_for] = ACTIONS(122),
    [anon_sym_break] = ACTIONS(122),
    [anon_sym_continue] = ACTIONS(122),
    [sym_boolean] = ACTIONS(122),
    [sym_null] = ACTIONS(122),
    [sym_number] = ACTIONS(122),
    [anon_sym_Text] = ACTIONS(122),
    [anon_sym_Num] = ACTIONS(122),
    [anon_sym_Bool] = ACTIONS(122),
    [anon_sym_Null] = ACTIONS(122),
    [sym_status] = ACTIONS(122),
    [anon_sym_DASH] = ACTIONS(122),
    [anon_sym_not] = ACTIONS(122),
    [anon_sym_unsafe] = ACTIONS(122),
    [anon_sym_trust] = ACTIONS(122),
    [anon_sym_silent] = ACTIONS(122),
    [anon_sym_nameof] = ACTIONS(122),
    [anon_sym_SLASH] = ACTIONS(122),
    [anon_sym_PLUS] = ACTIONS(122),
    [anon_sym_PERCENT] = ACTIONS(120),
    [anon_sym_GT] = ACTIONS(122),
    [anon_sym_LT] = ACTIONS(122),
    [anon_sym_GT_EQ] = ACTIONS(120),
    [anon_sym_LT_EQ] = ACTIONS(120),
    [anon_sym_EQ_EQ] = ACTIONS(120),
    [anon_sym_BANG_EQ] = ACTIONS(120),
    [anon_sym_and] = ACTIONS(122),
    [anon_sym_or] = ACTIONS(122),
    [anon_sym_is] = ACTIONS(122),
    [sym_variable] = ACTIONS(122),
    [anon_sym_DQUOTE] = ACTIONS(120),
    [anon_sym_DOLLAR] = ACTIONS(120),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_handler_failed] = STATE(80),
    [sym_handler] = STATE(78),
    [ts_builtin_sym_end] = ACTIONS(124),
    [anon_sym_SEMI] = ACTIONS(124),
    [anon_sym_main] = ACTIONS(126),
    [anon_sym_LPAREN] = ACTIONS(124),
    [anon_sym_echo] = ACTIONS(126),
    [anon_sym_exit] = ACTIONS(126),
    [sym_preprocessor_directive] = ACTIONS(124),
    [sym_shebang] = ACTIONS(124),
    [anon_sym_pub] = ACTIONS(126),
    [anon_sym_fun] = ACTIONS(126),
    [anon_sym_return] = ACTIONS(126),
    [anon_sym_fail] = ACTIONS(126),
    [anon_sym_as] = ACTIONS(126),
    [anon_sym_import] = ACTIONS(126),
    [anon_sym_STAR] = ACTIONS(124),
    [anon_sym_LBRACK] = ACTIONS(124),
    [anon_sym_let] = ACTIONS(126),
    [anon_sym_if] = ACTIONS(126),
    [anon_sym_else] = ACTIONS(126),
    [anon_sym_then] = ACTIONS(126),
    [anon_sym_loop] = ACTIONS(126),
    [anon_sym_for] = ACTIONS(126),
    [anon_sym_break] = ACTIONS(126),
    [anon_sym_continue] = ACTIONS(126),
    [sym_boolean] = ACTIONS(126),
    [sym_null] = ACTIONS(126),
    [sym_number] = ACTIONS(126),
    [anon_sym_Text] = ACTIONS(126),
    [anon_sym_Num] = ACTIONS(126),
    [anon_sym_Bool] = ACTIONS(126),
    [anon_sym_Null] = ACTIONS(126),
    [sym_status] = ACTIONS(126),
    [anon_sym_DASH] = ACTIONS(126),
    [anon_sym_not] = ACTIONS(126),
    [anon_sym_unsafe] = ACTIONS(126),
    [anon_sym_trust] = ACTIONS(126),
    [anon_sym_silent] = ACTIONS(126),
    [anon_sym_nameof] = ACTIONS(126),
    [anon_sym_SLASH] = ACTIONS(126),
    [anon_sym_PLUS] = ACTIONS(126),
    [anon_sym_PERCENT] = ACTIONS(124),
    [anon_sym_GT] = ACTIONS(126),
    [anon_sym_LT] = ACTIONS(126),
    [anon_sym_GT_EQ] = ACTIONS(124),
    [anon_sym_LT_EQ] = ACTIONS(124),
    [anon_sym_EQ_EQ] = ACTIONS(124),
    [anon_sym_BANG_EQ] = ACTIONS(124),
    [anon_sym_and] = ACTIONS(126),
    [anon_sym_or] = ACTIONS(126),
    [anon_sym_is] = ACTIONS(126),
    [sym_variable] = ACTIONS(126),
    [anon_sym_DQUOTE] = ACTIONS(124),
    [anon_sym_failed] = ACTIONS(128),
    [sym_handler_propagation] = ACTIONS(130),
    [anon_sym_DOLLAR] = ACTIONS(124),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_handler_failed] = STATE(80),
    [sym_handler] = STATE(81),
    [ts_builtin_sym_end] = ACTIONS(132),
    [anon_sym_SEMI] = ACTIONS(132),
    [anon_sym_main] = ACTIONS(134),
    [anon_sym_LPAREN] = ACTIONS(132),
    [anon_sym_echo] = ACTIONS(134),
    [anon_sym_exit] = ACTIONS(134),
    [sym_preprocessor_directive] = ACTIONS(132),
    [sym_shebang] = ACTIONS(132),
    [anon_sym_pub] = ACTIONS(134),
    [anon_sym_fun] = ACTIONS(134),
    [anon_sym_return] = ACTIONS(134),
    [anon_sym_fail] = ACTIONS(134),
    [anon_sym_as] = ACTIONS(134),
    [anon_sym_import] = ACTIONS(134),
    [anon_sym_STAR] = ACTIONS(132),
    [anon_sym_LBRACK] = ACTIONS(132),
    [anon_sym_let] = ACTIONS(134),
    [anon_sym_if] = ACTIONS(134),
    [anon_sym_else] = ACTIONS(134),
    [anon_sym_then] = ACTIONS(134),
    [anon_sym_loop] = ACTIONS(134),
    [anon_sym_for] = ACTIONS(134),
    [anon_sym_break] = ACTIONS(134),
    [anon_sym_continue] = ACTIONS(134),
    [sym_boolean] = ACTIONS(134),
    [sym_null] = ACTIONS(134),
    [sym_number] = ACTIONS(134),
    [anon_sym_Text] = ACTIONS(134),
    [anon_sym_Num] = ACTIONS(134),
    [anon_sym_Bool] = ACTIONS(134),
    [anon_sym_Null] = ACTIONS(134),
    [sym_status] = ACTIONS(134),
    [anon_sym_DASH] = ACTIONS(134),
    [anon_sym_not] = ACTIONS(134),
    [anon_sym_unsafe] = ACTIONS(134),
    [anon_sym_trust] = ACTIONS(134),
    [anon_sym_silent] = ACTIONS(134),
    [anon_sym_nameof] = ACTIONS(134),
    [anon_sym_SLASH] = ACTIONS(134),
    [anon_sym_PLUS] = ACTIONS(134),
    [anon_sym_PERCENT] = ACTIONS(132),
    [anon_sym_GT] = ACTIONS(134),
    [anon_sym_LT] = ACTIONS(134),
    [anon_sym_GT_EQ] = ACTIONS(132),
    [anon_sym_LT_EQ] = ACTIONS(132),
    [anon_sym_EQ_EQ] = ACTIONS(132),
    [anon_sym_BANG_EQ] = ACTIONS(132),
    [anon_sym_and] = ACTIONS(134),
    [anon_sym_or] = ACTIONS(134),
    [anon_sym_is] = ACTIONS(134),
    [sym_variable] = ACTIONS(134),
    [anon_sym_DQUOTE] = ACTIONS(132),
    [anon_sym_failed] = ACTIONS(128),
    [sym_handler_propagation] = ACTIONS(130),
    [anon_sym_DOLLAR] = ACTIONS(132),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_handler_failed] = STATE(80),
    [sym_handler] = STATE(102),
    [ts_builtin_sym_end] = ACTIONS(136),
    [anon_sym_SEMI] = ACTIONS(136),
    [anon_sym_main] = ACTIONS(138),
    [anon_sym_LPAREN] = ACTIONS(136),
    [anon_sym_echo] = ACTIONS(138),
    [anon_sym_exit] = ACTIONS(138),
    [sym_preprocessor_directive] = ACTIONS(136),
    [sym_shebang] = ACTIONS(136),
    [anon_sym_pub] = ACTIONS(138),
    [anon_sym_fun] = ACTIONS(138),
    [anon_sym_return] = ACTIONS(138),
    [anon_sym_fail] = ACTIONS(138),
    [anon_sym_as] = ACTIONS(138),
    [anon_sym_import] = ACTIONS(138),
    [anon_sym_STAR] = ACTIONS(136),
    [anon_sym_LBRACK] = ACTIONS(136),
    [anon_sym_let] = ACTIONS(138),
    [anon_sym_if] = ACTIONS(138),
    [anon_sym_else] = ACTIONS(138),
    [anon_sym_then] = ACTIONS(138),
    [anon_sym_loop] = ACTIONS(138),
    [anon_sym_for] = ACTIONS(138),
    [anon_sym_break] = ACTIONS(138),
    [anon_sym_continue] = ACTIONS(138),
    [sym_boolean] = ACTIONS(138),
    [sym_null] = ACTIONS(138),
    [sym_number] = ACTIONS(138),
    [anon_sym_Text] = ACTIONS(138),
    [anon_sym_Num] = ACTIONS(138),
    [anon_sym_Bool] = ACTIONS(138),
    [anon_sym_Null] = ACTIONS(138),
    [sym_status] = ACTIONS(138),
    [anon_sym_DASH] = ACTIONS(138),
    [anon_sym_not] = ACTIONS(138),
    [anon_sym_unsafe] = ACTIONS(138),
    [anon_sym_trust] = ACTIONS(138),
    [anon_sym_silent] = ACTIONS(138),
    [anon_sym_nameof] = ACTIONS(138),
    [anon_sym_SLASH] = ACTIONS(138),
    [anon_sym_PLUS] = ACTIONS(138),
    [anon_sym_PERCENT] = ACTIONS(136),
    [anon_sym_GT] = ACTIONS(138),
    [anon_sym_LT] = ACTIONS(138),
    [anon_sym_GT_EQ] = ACTIONS(136),
    [anon_sym_LT_EQ] = ACTIONS(136),
    [anon_sym_EQ_EQ] = ACTIONS(136),
    [anon_sym_BANG_EQ] = ACTIONS(136),
    [anon_sym_and] = ACTIONS(138),
    [anon_sym_or] = ACTIONS(138),
    [anon_sym_is] = ACTIONS(138),
    [sym_variable] = ACTIONS(138),
    [anon_sym_DQUOTE] = ACTIONS(136),
    [anon_sym_failed] = ACTIONS(128),
    [sym_handler_propagation] = ACTIONS(130),
    [anon_sym_DOLLAR] = ACTIONS(136),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [ts_builtin_sym_end] = ACTIONS(140),
    [anon_sym_SEMI] = ACTIONS(140),
    [anon_sym_LBRACE] = ACTIONS(140),
    [anon_sym_COLON] = ACTIONS(140),
    [anon_sym_main] = ACTIONS(142),
    [anon_sym_LPAREN] = ACTIONS(140),
    [anon_sym_RPAREN] = ACTIONS(140),
    [anon_sym_echo] = ACTIONS(142),
    [anon_sym_exit] = ACTIONS(142),
    [anon_sym_EQ] = ACTIONS(142),
    [anon_sym_COMMA] = ACTIONS(140),
    [sym_preprocessor_directive] = ACTIONS(140),
    [sym_shebang] = ACTIONS(140),
    [anon_sym_pub] = ACTIONS(142),
    [anon_sym_fun] = ACTIONS(142),
    [anon_sym_return] = ACTIONS(142),
    [anon_sym_fail] = ACTIONS(142),
    [anon_sym_as] = ACTIONS(142),
    [anon_sym_import] = ACTIONS(142),
    [anon_sym_STAR] = ACTIONS(140),
    [anon_sym_LBRACK] = ACTIONS(140),
    [anon_sym_let] = ACTIONS(142),
    [anon_sym_if] = ACTIONS(142),
    [anon_sym_then] = ACTIONS(142),
    [anon_sym_loop] = ACTIONS(142),
    [anon_sym_for] = ACTIONS(142),
    [anon_sym_break] = ACTIONS(142),
    [anon_sym_continue] = ACTIONS(142),
    [sym_boolean] = ACTIONS(142),
    [sym_null] = ACTIONS(142),
    [sym_number] = ACTIONS(142),
    [anon_sym_Text] = ACTIONS(142),
    [anon_sym_Num] = ACTIONS(142),
    [anon_sym_Bool] = ACTIONS(142),
    [anon_sym_Null] = ACTIONS(142),
    [sym_status] = ACTIONS(142),
    [anon_sym_DASH] = ACTIONS(142),
    [anon_sym_not] = ACTIONS(142),
    [anon_sym_unsafe] = ACTIONS(142),
    [anon_sym_trust] = ACTIONS(142),
    [anon_sym_silent] = ACTIONS(142),
    [anon_sym_nameof] = ACTIONS(142),
    [anon_sym_SLASH] = ACTIONS(142),
    [anon_sym_PLUS] = ACTIONS(142),
    [anon_sym_PERCENT] = ACTIONS(140),
    [anon_sym_GT] = ACTIONS(142),
    [anon_sym_LT] = ACTIONS(142),
    [anon_sym_GT_EQ] = ACTIONS(140),
    [anon_sym_LT_EQ] = ACTIONS(140),
    [anon_sym_EQ_EQ] = ACTIONS(140),
    [anon_sym_BANG_EQ] = ACTIONS(140),
    [anon_sym_and] = ACTIONS(142),
    [anon_sym_or] = ACTIONS(142),
    [anon_sym_is] = ACTIONS(142),
    [sym_variable] = ACTIONS(142),
    [anon_sym_DQUOTE] = ACTIONS(140),
    [anon_sym_DOLLAR] = ACTIONS(140),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_handler_failed] = STATE(80),
    [sym_handler] = STATE(64),
    [ts_builtin_sym_end] = ACTIONS(144),
    [anon_sym_SEMI] = ACTIONS(144),
    [anon_sym_main] = ACTIONS(146),
    [anon_sym_LPAREN] = ACTIONS(144),
    [anon_sym_echo] = ACTIONS(146),
    [anon_sym_exit] = ACTIONS(146),
    [sym_preprocessor_directive] = ACTIONS(144),
    [sym_shebang] = ACTIONS(144),
    [anon_sym_pub] = ACTIONS(146),
    [anon_sym_fun] = ACTIONS(146),
    [anon_sym_return] = ACTIONS(146),
    [anon_sym_fail] = ACTIONS(146),
    [anon_sym_as] = ACTIONS(146),
    [anon_sym_import] = ACTIONS(146),
    [anon_sym_STAR] = ACTIONS(144),
    [anon_sym_LBRACK] = ACTIONS(144),
    [anon_sym_let] = ACTIONS(146),
    [anon_sym_if] = ACTIONS(146),
    [anon_sym_else] = ACTIONS(146),
    [anon_sym_then] = ACTIONS(146),
    [anon_sym_loop] = ACTIONS(146),
    [anon_sym_for] = ACTIONS(146),
    [anon_sym_break] = ACTIONS(146),
    [anon_sym_continue] = ACTIONS(146),
    [sym_boolean] = ACTIONS(146),
    [sym_null] = ACTIONS(146),
    [sym_number] = ACTIONS(146),
    [anon_sym_Text] = ACTIONS(146),
    [anon_sym_Num] = ACTIONS(146),
    [anon_sym_Bool] = ACTIONS(146),
    [anon_sym_Null] = ACTIONS(146),
    [sym_status] = ACTIONS(146),
    [anon_sym_DASH] = ACTIONS(146),
    [anon_sym_not] = ACTIONS(146),
    [anon_sym_unsafe] = ACTIONS(146),
    [anon_sym_trust] = ACTIONS(146),
    [anon_sym_silent] = ACTIONS(146),
    [anon_sym_nameof] = ACTIONS(146),
    [anon_sym_SLASH] = ACTIONS(146),
    [anon_sym_PLUS] = ACTIONS(146),
    [anon_sym_PERCENT] = ACTIONS(144),
    [anon_sym_GT] = ACTIONS(146),
    [anon_sym_LT] = ACTIONS(146),
    [anon_sym_GT_EQ] = ACTIONS(144),
    [anon_sym_LT_EQ] = ACTIONS(144),
    [anon_sym_EQ_EQ] = ACTIONS(144),
    [anon_sym_BANG_EQ] = ACTIONS(144),
    [anon_sym_and] = ACTIONS(146),
    [anon_sym_or] = ACTIONS(146),
    [anon_sym_is] = ACTIONS(146),
    [sym_variable] = ACTIONS(146),
    [anon_sym_DQUOTE] = ACTIONS(144),
    [anon_sym_failed] = ACTIONS(128),
    [sym_handler_propagation] = ACTIONS(130),
    [anon_sym_DOLLAR] = ACTIONS(144),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_handler_failed] = STATE(80),
    [sym_handler] = STATE(72),
    [ts_builtin_sym_end] = ACTIONS(148),
    [anon_sym_SEMI] = ACTIONS(148),
    [anon_sym_main] = ACTIONS(150),
    [anon_sym_LPAREN] = ACTIONS(148),
    [anon_sym_echo] = ACTIONS(150),
    [anon_sym_exit] = ACTIONS(150),
    [sym_preprocessor_directive] = ACTIONS(148),
    [sym_shebang] = ACTIONS(148),
    [anon_sym_pub] = ACTIONS(150),
    [anon_sym_fun] = ACTIONS(150),
    [anon_sym_return] = ACTIONS(150),
    [anon_sym_fail] = ACTIONS(150),
    [anon_sym_as] = ACTIONS(150),
    [anon_sym_import] = ACTIONS(150),
    [anon_sym_STAR] = ACTIONS(148),
    [anon_sym_LBRACK] = ACTIONS(148),
    [anon_sym_let] = ACTIONS(150),
    [anon_sym_if] = ACTIONS(150),
    [anon_sym_else] = ACTIONS(150),
    [anon_sym_then] = ACTIONS(150),
    [anon_sym_loop] = ACTIONS(150),
    [anon_sym_for] = ACTIONS(150),
    [anon_sym_break] = ACTIONS(150),
    [anon_sym_continue] = ACTIONS(150),
    [sym_boolean] = ACTIONS(150),
    [sym_null] = ACTIONS(150),
    [sym_number] = ACTIONS(150),
    [anon_sym_Text] = ACTIONS(150),
    [anon_sym_Num] = ACTIONS(150),
    [anon_sym_Bool] = ACTIONS(150),
    [anon_sym_Null] = ACTIONS(150),
    [sym_status] = ACTIONS(150),
    [anon_sym_DASH] = ACTIONS(150),
    [anon_sym_not] = ACTIONS(150),
    [anon_sym_unsafe] = ACTIONS(150),
    [anon_sym_trust] = ACTIONS(150),
    [anon_sym_silent] = ACTIONS(150),
    [anon_sym_nameof] = ACTIONS(150),
    [anon_sym_SLASH] = ACTIONS(150),
    [anon_sym_PLUS] = ACTIONS(150),
    [anon_sym_PERCENT] = ACTIONS(148),
    [anon_sym_GT] = ACTIONS(150),
    [anon_sym_LT] = ACTIONS(150),
    [anon_sym_GT_EQ] = ACTIONS(148),
    [anon_sym_LT_EQ] = ACTIONS(148),
    [anon_sym_EQ_EQ] = ACTIONS(148),
    [anon_sym_BANG_EQ] = ACTIONS(148),
    [anon_sym_and] = ACTIONS(150),
    [anon_sym_or] = ACTIONS(150),
    [anon_sym_is] = ACTIONS(150),
    [sym_variable] = ACTIONS(150),
    [anon_sym_DQUOTE] = ACTIONS(148),
    [anon_sym_failed] = ACTIONS(128),
    [sym_handler_propagation] = ACTIONS(130),
    [anon_sym_DOLLAR] = ACTIONS(148),
    [sym_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(152), 1,
      anon_sym_failed,
    ACTIONS(154), 1,
      sym_handler_propagation,
    STATE(131), 1,
      sym_handler,
    STATE(133), 1,
      sym_handler_failed,
    ACTIONS(132), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(134), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [72] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(152), 1,
      anon_sym_failed,
    ACTIONS(154), 1,
      sym_handler_propagation,
    STATE(133), 1,
      sym_handler_failed,
    STATE(139), 1,
      sym_handler,
    ACTIONS(136), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [144] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(152), 1,
      anon_sym_failed,
    ACTIONS(154), 1,
      sym_handler_propagation,
    STATE(133), 1,
      sym_handler_failed,
    STATE(134), 1,
      sym_handler,
    ACTIONS(124), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [216] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(152), 1,
      anon_sym_failed,
    ACTIONS(154), 1,
      sym_handler_propagation,
    STATE(133), 1,
      sym_handler_failed,
    STATE(158), 1,
      sym_handler,
    ACTIONS(148), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [288] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(152), 1,
      anon_sym_failed,
    ACTIONS(154), 1,
      sym_handler_propagation,
    STATE(133), 1,
      sym_handler_failed,
    STATE(146), 1,
      sym_handler,
    ACTIONS(144), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [360] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      anon_sym_RBRACE,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(36), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [461] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    STATE(337), 1,
      sym_block,
    ACTIONS(190), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [530] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    STATE(311), 1,
      sym_block,
    ACTIONS(190), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [599] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(198), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(33), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [700] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 1,
      anon_sym_LPAREN,
    ACTIONS(202), 1,
      anon_sym_EQ,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    STATE(1056), 1,
      sym_subscript,
    ACTIONS(190), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [771] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(206), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [872] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(208), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [973] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(210), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1074] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(212), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(23), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1175] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(214), 1,
      anon_sym_RBRACE,
    ACTIONS(216), 1,
      anon_sym_LPAREN,
    ACTIONS(222), 1,
      sym_shebang,
    ACTIONS(228), 1,
      anon_sym_LBRACK,
    ACTIONS(231), 1,
      anon_sym_let,
    ACTIONS(234), 1,
      anon_sym_if,
    ACTIONS(237), 1,
      anon_sym_loop,
    ACTIONS(240), 1,
      anon_sym_for,
    ACTIONS(255), 1,
      sym_variable,
    ACTIONS(258), 1,
      anon_sym_DQUOTE,
    ACTIONS(261), 1,
      anon_sym_DOLLAR,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(219), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(225), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(243), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(246), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(249), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(252), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1276] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(264), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(29), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1377] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(266), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1478] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(268), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1579] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(270), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1680] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(272), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1781] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(274), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(38), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1882] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(276), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [1983] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(278), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(24), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2084] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(280), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(22), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2185] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(282), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2286] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    STATE(339), 1,
      sym_block,
    ACTIONS(190), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [2355] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(284), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2456] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(286), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(30), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2557] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(288), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(26), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2658] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(290), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(31), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2759] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(292), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(28), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2860] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(162), 1,
      sym_shebang,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(294), 1,
      anon_sym_RBRACE,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    STATE(40), 2,
      sym__statement,
      aux_sym_block_repeat1,
    ACTIONS(178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(477), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(181), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [2961] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 1,
      anon_sym_LPAREN,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(296), 1,
      anon_sym_EQ,
    STATE(1029), 1,
      sym_subscript,
    ACTIONS(190), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3032] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(298), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3098] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(310), 1,
      anon_sym_STAR,
    ACTIONS(312), 1,
      anon_sym_then,
    ACTIONS(316), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(308), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(320), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(314), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(318), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(306), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [3178] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(324), 1,
      anon_sym_EQ,
    STATE(982), 1,
      sym_subscript,
    ACTIONS(190), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3248] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(310), 1,
      anon_sym_STAR,
    ACTIONS(316), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(320), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 36,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [3320] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(330), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3386] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(310), 1,
      anon_sym_STAR,
    ACTIONS(316), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(320), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 36,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [3458] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(310), 1,
      anon_sym_STAR,
    ACTIONS(312), 1,
      anon_sym_then,
    ACTIONS(316), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(308), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(320), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(314), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(318), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [3538] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(310), 1,
      anon_sym_STAR,
    ACTIONS(312), 1,
      anon_sym_then,
    ACTIONS(316), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(308), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(320), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(314), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(318), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(338), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(340), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [3618] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(334), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3684] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(310), 1,
      anon_sym_STAR,
    ACTIONS(316), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(320), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(344), 36,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [3756] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(326), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3822] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(346), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(348), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [3888] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(310), 1,
      anon_sym_STAR,
    ACTIONS(312), 1,
      anon_sym_then,
    ACTIONS(316), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(308), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(320), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(314), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(318), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(298), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [3968] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(350), 1,
      anon_sym_EQ,
    STATE(992), 1,
      sym_subscript,
    ACTIONS(190), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4038] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(302), 1,
      anon_sym_LBRACK,
    ACTIONS(310), 1,
      anon_sym_STAR,
    ACTIONS(312), 1,
      anon_sym_then,
    ACTIONS(316), 1,
      anon_sym_SLASH,
    STATE(75), 1,
      sym_subscript,
    ACTIONS(308), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(320), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(314), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(318), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(352), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(354), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [4118] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_then,
    ACTIONS(364), 1,
      anon_sym_SLASH,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(356), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(368), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(362), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(366), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(338), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(340), 28,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [4197] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(326), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4262] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(372), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4323] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 1,
      sym_shebang,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(382), 1,
      anon_sym_let,
    ACTIONS(384), 1,
      anon_sym_if,
    ACTIONS(386), 1,
      anon_sym_loop,
    ACTIONS(388), 1,
      anon_sym_for,
    ACTIONS(398), 1,
      sym_variable,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(376), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(378), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(390), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(392), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(619), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(605), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [4418] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(406), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4479] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(156), 1,
      sym_shebang,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(416), 1,
      anon_sym_let,
    ACTIONS(418), 1,
      anon_sym_if,
    ACTIONS(420), 1,
      anon_sym_loop,
    ACTIONS(422), 1,
      anon_sym_for,
    ACTIONS(432), 1,
      sym_variable,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(410), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(412), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(424), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(426), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(408), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(171), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [4574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(440), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4635] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(444), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [4696] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(292), 1,
      sym_shebang,
    ACTIONS(446), 1,
      anon_sym_let,
    ACTIONS(448), 1,
      anon_sym_if,
    ACTIONS(450), 1,
      anon_sym_loop,
    ACTIONS(452), 1,
      anon_sym_for,
    ACTIONS(458), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(454), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(456), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(252), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(218), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [4791] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_SLASH,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(368), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(344), 35,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [4862] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_loop,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      sym_variable,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(264), 1,
      sym_shebang,
    STATE(5), 1,
      sym_type_name_symbol,
    STATE(18), 1,
      sym_type_name,
    ACTIONS(11), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(21), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(35), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(37), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(277), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(125), 11,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [4959] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_loop,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      sym_variable,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(264), 1,
      sym_shebang,
    STATE(5), 1,
      sym_type_name_symbol,
    STATE(19), 1,
      sym_type_name,
    ACTIONS(11), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(21), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(35), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(37), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(277), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(125), 11,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [5056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(124), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(462), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5178] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(198), 1,
      sym_shebang,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(472), 1,
      anon_sym_let,
    ACTIONS(474), 1,
      anon_sym_if,
    ACTIONS(476), 1,
      anon_sym_loop,
    ACTIONS(478), 1,
      anon_sym_for,
    ACTIONS(488), 1,
      sym_variable,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(466), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(468), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(480), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(482), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(668), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(285), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [5273] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(496), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5334] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(212), 1,
      sym_shebang,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(498), 1,
      anon_sym_let,
    ACTIONS(500), 1,
      anon_sym_if,
    ACTIONS(502), 1,
      anon_sym_loop,
    ACTIONS(504), 1,
      anon_sym_for,
    ACTIONS(508), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(410), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(412), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(506), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(426), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(205), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(171), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [5429] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_then,
    ACTIONS(364), 1,
      anon_sym_SLASH,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(356), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(368), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(362), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(366), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [5508] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(512), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(516), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_EQ,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5630] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(520), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(144), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5752] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [5813] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(264), 1,
      sym_shebang,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(530), 1,
      anon_sym_let,
    ACTIONS(532), 1,
      anon_sym_if,
    ACTIONS(534), 1,
      anon_sym_loop,
    ACTIONS(536), 1,
      anon_sym_for,
    ACTIONS(542), 1,
      sym_variable,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(35), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(526), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(528), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(538), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(277), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(615), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [5908] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 1,
      sym_shebang,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(546), 1,
      anon_sym_let,
    ACTIONS(548), 1,
      anon_sym_if,
    ACTIONS(550), 1,
      anon_sym_loop,
    ACTIONS(552), 1,
      anon_sym_for,
    ACTIONS(554), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(376), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(378), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(390), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(392), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(619), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(605), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [6003] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(558), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6064] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(546), 1,
      anon_sym_let,
    ACTIONS(548), 1,
      anon_sym_if,
    ACTIONS(550), 1,
      anon_sym_loop,
    ACTIONS(552), 1,
      anon_sym_for,
    ACTIONS(554), 1,
      sym_variable,
    ACTIONS(560), 1,
      sym_shebang,
    STATE(619), 1,
      sym__statement,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(376), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(378), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(390), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(562), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(633), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(743), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [6161] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(280), 1,
      sym_shebang,
    ACTIONS(564), 1,
      anon_sym_let,
    ACTIONS(566), 1,
      anon_sym_if,
    ACTIONS(568), 1,
      anon_sym_loop,
    ACTIONS(570), 1,
      anon_sym_for,
    ACTIONS(574), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(11), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(21), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(572), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(37), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(148), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(125), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [6256] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(200), 1,
      anon_sym_LPAREN,
    ACTIONS(190), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6319] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(530), 1,
      anon_sym_let,
    ACTIONS(532), 1,
      anon_sym_if,
    ACTIONS(534), 1,
      anon_sym_loop,
    ACTIONS(536), 1,
      anon_sym_for,
    ACTIONS(542), 1,
      sym_variable,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(576), 1,
      sym_shebang,
    STATE(277), 1,
      sym__statement,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(35), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(526), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(528), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(578), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(939), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(749), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [6416] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(274), 1,
      sym_shebang,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(580), 1,
      anon_sym_let,
    ACTIONS(582), 1,
      anon_sym_if,
    ACTIONS(584), 1,
      anon_sym_loop,
    ACTIONS(586), 1,
      anon_sym_for,
    ACTIONS(588), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(390), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(526), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(528), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(538), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(619), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(615), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [6511] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(122), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6572] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(168), 1,
      anon_sym_let,
    ACTIONS(170), 1,
      anon_sym_if,
    ACTIONS(172), 1,
      anon_sym_loop,
    ACTIONS(174), 1,
      anon_sym_for,
    ACTIONS(184), 1,
      sym_variable,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(290), 1,
      sym_shebang,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(160), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(164), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(176), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(456), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(420), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(218), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [6667] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(334), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6732] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_then,
    ACTIONS(364), 1,
      anon_sym_SLASH,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(356), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(368), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(362), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(366), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(298), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [6811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(116), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(118), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [6872] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(278), 1,
      sym_shebang,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(590), 1,
      anon_sym_let,
    ACTIONS(592), 1,
      anon_sym_if,
    ACTIONS(594), 1,
      anon_sym_loop,
    ACTIONS(596), 1,
      anon_sym_for,
    ACTIONS(600), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(466), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(468), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(598), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(482), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(334), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(285), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [6967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7028] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(516), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7211] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(472), 1,
      anon_sym_let,
    ACTIONS(474), 1,
      anon_sym_if,
    ACTIONS(476), 1,
      anon_sym_loop,
    ACTIONS(478), 1,
      anon_sym_for,
    ACTIONS(488), 1,
      sym_variable,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(614), 1,
      sym_shebang,
    STATE(345), 1,
      sym_type_name_symbol,
    STATE(668), 1,
      sym__statement,
    ACTIONS(466), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(468), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(480), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(616), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(674), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(293), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [7308] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(148), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7369] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_then,
    ACTIONS(364), 1,
      anon_sym_SLASH,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(356), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(368), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(362), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(366), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(352), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(354), 28,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [7448] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7509] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_SLASH,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(368), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 35,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [7580] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(330), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7645] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7706] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(364), 1,
      anon_sym_SLASH,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(368), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 35,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [7777] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(346), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(348), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(628), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [7903] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_loop,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      sym_variable,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(264), 1,
      sym_shebang,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(11), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(21), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(35), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(37), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(277), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(125), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [7998] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(560), 1,
      sym_shebang,
    ACTIONS(580), 1,
      anon_sym_let,
    ACTIONS(582), 1,
      anon_sym_if,
    ACTIONS(584), 1,
      anon_sym_loop,
    ACTIONS(586), 1,
      anon_sym_for,
    ACTIONS(588), 1,
      sym_variable,
    STATE(619), 1,
      sym__statement,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(390), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(526), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(528), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(630), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(633), 9,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(629), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [8095] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8217] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(294), 1,
      sym_shebang,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(648), 1,
      anon_sym_let,
    ACTIONS(650), 1,
      anon_sym_if,
    ACTIONS(652), 1,
      anon_sym_loop,
    ACTIONS(654), 1,
      anon_sym_for,
    ACTIONS(664), 1,
      sym_variable,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(642), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(644), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(656), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(658), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(117), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(46), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [8312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8373] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8495] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8556] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8617] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(692), 39,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8678] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(27), 1,
      anon_sym_let,
    ACTIONS(29), 1,
      anon_sym_if,
    ACTIONS(31), 1,
      anon_sym_loop,
    ACTIONS(33), 1,
      anon_sym_for,
    ACTIONS(43), 1,
      sym_variable,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(264), 1,
      sym_shebang,
    STATE(5), 1,
      sym_type_name_symbol,
    STATE(37), 1,
      sym_type_name,
    ACTIONS(11), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(21), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(35), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(37), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(277), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(125), 11,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [8775] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(286), 1,
      sym_shebang,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(694), 1,
      anon_sym_let,
    ACTIONS(696), 1,
      anon_sym_if,
    ACTIONS(698), 1,
      anon_sym_loop,
    ACTIONS(700), 1,
      anon_sym_for,
    ACTIONS(704), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(642), 2,
      anon_sym_echo,
      anon_sym_exit,
    ACTIONS(644), 2,
      anon_sym_return,
      anon_sym_fail,
    ACTIONS(702), 2,
      anon_sym_break,
      anon_sym_continue,
    ACTIONS(658), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(292), 10,
      sym__statement,
      sym_builtin,
      sym_function_control_flow,
      sym_variable_init,
      sym_variable_assignment,
      sym_if_cond,
      sym_if_chain,
      sym_loop_infinite,
      sym_loop_iter,
      sym_loop_control_flow,
    STATE(46), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [8870] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(706), 1,
      anon_sym_else,
    ACTIONS(522), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [8933] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(358), 1,
      anon_sym_STAR,
    ACTIONS(360), 1,
      anon_sym_then,
    ACTIONS(364), 1,
      anon_sym_SLASH,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(356), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(368), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(362), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(366), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 7,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(306), 28,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [9012] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    STATE(149), 1,
      sym_subscript,
    ACTIONS(298), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9077] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9137] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(444), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9197] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(692), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9257] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 1,
      anon_sym_failed,
    ACTIONS(710), 1,
      sym_handler_propagation,
    STATE(198), 1,
      sym_handler,
    STATE(201), 1,
      sym_handler_failed,
    ACTIONS(132), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(134), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(144), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9385] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 1,
      anon_sym_failed,
    ACTIONS(710), 1,
      sym_handler_propagation,
    STATE(201), 1,
      sym_handler_failed,
    STATE(226), 1,
      sym_handler,
    ACTIONS(144), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(520), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9513] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(512), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9573] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 1,
      anon_sym_failed,
    ACTIONS(710), 1,
      sym_handler_propagation,
    STATE(189), 1,
      sym_handler,
    STATE(201), 1,
      sym_handler_failed,
    ACTIONS(136), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9641] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(372), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9701] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 1,
      anon_sym_failed,
    ACTIONS(710), 1,
      sym_handler_propagation,
    STATE(201), 1,
      sym_handler_failed,
    STATE(214), 1,
      sym_handler,
    ACTIONS(148), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(558), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9829] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(148), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9889] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [9949] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 1,
      anon_sym_LPAREN,
    ACTIONS(190), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10011] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(440), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10071] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(462), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10251] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(406), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10311] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10371] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10431] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(496), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10491] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10611] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10671] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(628), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10731] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10791] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(708), 1,
      anon_sym_failed,
    ACTIONS(710), 1,
      sym_handler_propagation,
    STATE(201), 1,
      sym_handler_failed,
    STATE(212), 1,
      sym_handler,
    ACTIONS(124), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10859] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [10979] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(124), 14,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 38,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11039] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 1,
      anon_sym_failed,
    ACTIONS(714), 1,
      sym_handler_propagation,
    STATE(250), 1,
      sym_handler_failed,
    STATE(253), 1,
      sym_handler,
    ACTIONS(144), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11106] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 1,
      anon_sym_failed,
    ACTIONS(714), 1,
      sym_handler_propagation,
    STATE(242), 1,
      sym_handler,
    STATE(250), 1,
      sym_handler_failed,
    ACTIONS(136), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11173] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 1,
      anon_sym_failed,
    ACTIONS(714), 1,
      sym_handler_propagation,
    STATE(244), 1,
      sym_handler,
    STATE(250), 1,
      sym_handler_failed,
    ACTIONS(148), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11240] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 1,
      anon_sym_failed,
    ACTIONS(714), 1,
      sym_handler_propagation,
    STATE(232), 1,
      sym_handler,
    STATE(250), 1,
      sym_handler_failed,
    ACTIONS(124), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11307] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(712), 1,
      anon_sym_failed,
    ACTIONS(714), 1,
      sym_handler_propagation,
    STATE(227), 1,
      sym_handler,
    STATE(250), 1,
      sym_handler_failed,
    ACTIONS(132), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(134), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11374] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(716), 1,
      anon_sym_LPAREN,
    ACTIONS(718), 1,
      anon_sym_EQ,
    STATE(1036), 1,
      sym_subscript,
    ACTIONS(190), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11440] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(716), 1,
      anon_sym_LPAREN,
    ACTIONS(720), 1,
      anon_sym_EQ,
    STATE(1024), 1,
      sym_subscript,
    ACTIONS(190), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11506] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_STAR,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    ACTIONS(728), 1,
      anon_sym_then,
    ACTIONS(732), 1,
      anon_sym_SLASH,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(722), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(736), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(730), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(734), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(338), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(340), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [11581] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(738), 1,
      anon_sym_LPAREN,
    ACTIONS(740), 1,
      anon_sym_EQ,
    STATE(977), 1,
      sym_subscript,
    ACTIONS(190), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11646] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_STAR,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    ACTIONS(728), 1,
      anon_sym_then,
    ACTIONS(732), 1,
      anon_sym_SLASH,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(722), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(736), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(730), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(734), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(298), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [11721] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_STAR,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    ACTIONS(728), 1,
      anon_sym_then,
    ACTIONS(732), 1,
      anon_sym_SLASH,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(722), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(736), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(730), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(734), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(352), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(354), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [11796] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(330), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11857] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_STAR,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    ACTIONS(728), 1,
      anon_sym_then,
    ACTIONS(732), 1,
      anon_sym_SLASH,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(722), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(736), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(730), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(734), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(306), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [11932] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(346), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(348), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [11993] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(334), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12054] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_STAR,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    ACTIONS(732), 1,
      anon_sym_SLASH,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(736), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(344), 32,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [12121] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(738), 1,
      anon_sym_LPAREN,
    ACTIONS(742), 1,
      anon_sym_EQ,
    STATE(1059), 1,
      sym_subscript,
    ACTIONS(190), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12186] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_STAR,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    ACTIONS(728), 1,
      anon_sym_then,
    ACTIONS(732), 1,
      anon_sym_SLASH,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(722), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(736), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(730), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(734), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [12261] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(298), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12322] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_STAR,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    ACTIONS(732), 1,
      anon_sym_SLASH,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(736), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 32,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [12389] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(326), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12450] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(724), 1,
      anon_sym_STAR,
    ACTIONS(726), 1,
      anon_sym_LBRACK,
    ACTIONS(732), 1,
      anon_sym_SLASH,
    STATE(216), 1,
      sym_subscript,
    ACTIONS(736), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 32,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [12517] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_SEMI,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 1,
      anon_sym_then,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(746), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(754), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(304), 5,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(758), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(306), 24,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [12593] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12649] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(326), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12709] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(462), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12765] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12821] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(516), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12877] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [12989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(148), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(692), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13101] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 31,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [13167] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13223] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13279] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13335] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(330), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13395] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 31,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [13461] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 1,
      anon_sym_then,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(746), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(754), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(758), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(334), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [13535] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(144), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13591] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(762), 1,
      anon_sym_else,
    ACTIONS(522), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13649] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13705] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(520), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13761] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(372), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13817] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13873] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(116), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(118), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13929] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [13985] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(346), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(348), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14045] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14101] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14157] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14213] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(440), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(444), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(512), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14381] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 1,
      anon_sym_then,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(746), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(754), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(758), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(298), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [14455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(124), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14511] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 1,
      anon_sym_then,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(746), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(754), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(758), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(352), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(354), 24,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [14585] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(496), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14641] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 1,
      anon_sym_then,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(746), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(754), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(758), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(338), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(340), 24,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [14715] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(752), 1,
      anon_sym_then,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(746), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(754), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(758), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(306), 24,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [14789] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(748), 1,
      anon_sym_STAR,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    ACTIONS(756), 1,
      anon_sym_SLASH,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(760), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(344), 31,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [14855] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(334), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(558), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [14971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(628), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15027] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(716), 1,
      anon_sym_LPAREN,
    ACTIONS(190), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15085] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(750), 1,
      anon_sym_LBRACK,
    STATE(233), 1,
      sym_subscript,
    ACTIONS(298), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15145] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(122), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15201] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(406), 35,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(144), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15312] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(462), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(692), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15422] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15477] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(516), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(512), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15587] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(496), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(440), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15697] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(738), 1,
      anon_sym_LPAREN,
    ACTIONS(190), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15754] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15809] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15864] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(122), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15919] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [15974] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16084] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(148), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16139] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(628), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16194] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(124), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(558), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16414] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16469] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(372), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(520), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16579] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16634] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16689] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(406), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16744] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16799] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(444), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16854] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(116), 13,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(118), 34,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_as,
      anon_sym_let,
      anon_sym_if,
      anon_sym_then,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16909] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_failed,
    ACTIONS(766), 1,
      sym_handler_propagation,
    STATE(306), 1,
      sym_handler,
    STATE(338), 1,
      sym_handler_failed,
    ACTIONS(136), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(138), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [16966] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_failed,
    ACTIONS(766), 1,
      sym_handler_propagation,
    STATE(327), 1,
      sym_handler,
    STATE(338), 1,
      sym_handler_failed,
    ACTIONS(144), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17023] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_failed,
    ACTIONS(766), 1,
      sym_handler_propagation,
    STATE(325), 1,
      sym_handler,
    STATE(338), 1,
      sym_handler_failed,
    ACTIONS(148), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17080] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_failed,
    ACTIONS(766), 1,
      sym_handler_propagation,
    STATE(324), 1,
      sym_handler,
    STATE(338), 1,
      sym_handler_failed,
    ACTIONS(124), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17137] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(764), 1,
      anon_sym_failed,
    ACTIONS(766), 1,
      sym_handler_propagation,
    STATE(321), 1,
      sym_handler,
    STATE(338), 1,
      sym_handler_failed,
    ACTIONS(132), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(134), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17194] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LPAREN,
    ACTIONS(770), 1,
      anon_sym_EQ,
    STATE(970), 1,
      sym_subscript,
    ACTIONS(190), 10,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17249] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(768), 1,
      anon_sym_LPAREN,
    ACTIONS(772), 1,
      anon_sym_EQ,
    STATE(1041), 1,
      sym_subscript,
    ACTIONS(190), 10,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17304] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [17350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [17396] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [17442] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(326), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17492] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(778), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [17538] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [17584] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 10,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 22,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [17640] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(330), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(332), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17690] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 10,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(328), 22,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [17746] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [17792] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [17838] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(334), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(336), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17888] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(298), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(300), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [17938] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [17984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18030] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18076] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18214] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(786), 1,
      anon_sym_else,
    ACTIONS(522), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18262] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    ACTIONS(790), 1,
      anon_sym_then,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(788), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(792), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(334), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(794), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(336), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18326] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    ACTIONS(790), 1,
      anon_sym_then,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(788), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(792), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(304), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(794), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(306), 15,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18390] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    ACTIONS(790), 1,
      anon_sym_then,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(788), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(792), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(352), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(794), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(354), 15,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18454] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18500] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18546] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    ACTIONS(790), 1,
      anon_sym_then,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(788), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(792), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(338), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(794), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(340), 15,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18610] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 10,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(344), 22,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_is,
      sym_variable,
  [18666] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18712] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18758] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    ACTIONS(790), 1,
      anon_sym_then,
    ACTIONS(796), 1,
      anon_sym_SEMI,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(788), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(304), 4,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(792), 4,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(794), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(306), 15,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18916] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [18962] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    ACTIONS(780), 1,
      anon_sym_STAR,
    ACTIONS(782), 1,
      anon_sym_SLASH,
    ACTIONS(790), 1,
      anon_sym_then,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(784), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(788), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(792), 3,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(298), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(794), 5,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(300), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19026] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(774), 1,
      anon_sym_LBRACK,
    STATE(326), 1,
      sym_subscript,
    ACTIONS(346), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(348), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [19076] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19168] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19214] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 30,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19352] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(516), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [19397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(148), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(150), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [19442] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(798), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(800), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(802), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(804), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19532] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(806), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(808), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19577] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(812), 1,
      anon_sym_SEMI,
    ACTIONS(810), 7,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(814), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19624] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(816), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(818), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19669] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(820), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(822), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19714] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(824), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(826), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19759] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(828), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(830), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(832), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(834), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19849] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(836), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(838), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [19894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(556), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(558), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [19939] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(372), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [19984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(690), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(692), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(628), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20074] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(144), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(146), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20119] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(840), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(842), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [20164] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(844), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(846), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [20209] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(512), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20254] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(124), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(126), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20299] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(496), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(406), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20389] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(372), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [20434] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(444), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20524] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(462), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20569] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20614] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20659] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20704] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(440), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20749] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(768), 1,
      anon_sym_LPAREN,
    ACTIONS(190), 11,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(196), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20796] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(848), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(850), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [20841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(520), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20886] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(852), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(854), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [20931] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [20976] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21021] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21066] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(626), 8,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(628), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [21111] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21156] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(120), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(122), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21201] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21246] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(116), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(118), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21291] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21336] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21381] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21426] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 12,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 25,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_GT,
      anon_sym_LT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      sym_variable,
  [21471] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(856), 7,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      sym_preprocessor_directive,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(858), 29,
      anon_sym_main,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_pub,
      anon_sym_fun,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_import,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [21515] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(860), 1,
      anon_sym_RBRACE,
    ACTIONS(862), 1,
      anon_sym_else,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [21580] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(872), 1,
      anon_sym_RBRACE,
    ACTIONS(874), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [21645] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(876), 1,
      anon_sym_RBRACE,
    ACTIONS(878), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [21710] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(880), 1,
      anon_sym_RBRACE,
    ACTIONS(882), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [21775] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(884), 1,
      anon_sym_RBRACE,
    ACTIONS(886), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [21840] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(888), 1,
      anon_sym_RBRACE,
    ACTIONS(890), 1,
      anon_sym_else,
    STATE(353), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [21905] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(892), 1,
      anon_sym_RBRACE,
    ACTIONS(894), 1,
      anon_sym_else,
    STATE(355), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [21970] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(896), 1,
      anon_sym_RBRACE,
    ACTIONS(898), 1,
      anon_sym_else,
    STATE(366), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22035] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 1,
      anon_sym_RBRACE,
    ACTIONS(902), 1,
      anon_sym_LPAREN,
    ACTIONS(905), 1,
      anon_sym_LBRACK,
    ACTIONS(908), 1,
      anon_sym_else,
    ACTIONS(919), 1,
      sym_variable,
    ACTIONS(922), 1,
      anon_sym_DQUOTE,
    ACTIONS(925), 1,
      anon_sym_DOLLAR,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(910), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(913), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(916), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22100] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(928), 1,
      anon_sym_RBRACE,
    ACTIONS(930), 1,
      anon_sym_else,
    STATE(374), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22165] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(932), 1,
      anon_sym_RBRACE,
    ACTIONS(934), 1,
      anon_sym_else,
    STATE(357), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22230] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(936), 1,
      anon_sym_RBRACE,
    ACTIONS(938), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22295] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(940), 1,
      anon_sym_RBRACE,
    ACTIONS(942), 1,
      anon_sym_else,
    STATE(368), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22360] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(944), 1,
      anon_sym_RBRACE,
    ACTIONS(946), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22425] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(948), 1,
      anon_sym_RBRACE,
    ACTIONS(950), 1,
      anon_sym_else,
    STATE(356), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22490] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(952), 1,
      anon_sym_RBRACE,
    ACTIONS(954), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22555] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(956), 1,
      anon_sym_RBRACE,
    ACTIONS(958), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22620] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(960), 1,
      anon_sym_RBRACE,
    ACTIONS(962), 1,
      anon_sym_else,
    STATE(364), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22685] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(964), 1,
      anon_sym_RBRACE,
    ACTIONS(966), 1,
      anon_sym_else,
    STATE(369), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22750] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(968), 1,
      anon_sym_RBRACE,
    ACTIONS(970), 1,
      anon_sym_else,
    STATE(354), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22815] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(972), 1,
      anon_sym_RBRACE,
    ACTIONS(974), 1,
      anon_sym_else,
    STATE(375), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22880] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(976), 1,
      anon_sym_RBRACE,
    ACTIONS(978), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [22945] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(980), 1,
      anon_sym_RBRACE,
    ACTIONS(982), 1,
      anon_sym_else,
    STATE(361), 1,
      aux_sym_if_chain_repeat1,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(864), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(698), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23010] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [23051] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [23092] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(984), 1,
      anon_sym_RBRACK,
    STATE(777), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(986), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(706), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23151] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(988), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(990), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(681), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23210] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(992), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(994), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(686), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23269] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(996), 1,
      anon_sym_RBRACK,
    STATE(777), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(998), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(689), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23328] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1000), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1002), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(691), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23387] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1004), 1,
      anon_sym_RBRACK,
    STATE(777), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1006), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(694), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23446] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1008), 1,
      anon_sym_RBRACK,
    STATE(777), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1010), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(712), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23505] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1012), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1014), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(724), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23564] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1016), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1018), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(727), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23623] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1020), 1,
      anon_sym_RBRACK,
    STATE(777), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1022), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(729), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23682] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1024), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1026), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(737), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23741] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1028), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1030), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(711), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23800] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1032), 1,
      anon_sym_RBRACK,
    STATE(777), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1034), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(725), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23859] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1036), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1038), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(703), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23918] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1040), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1042), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(692), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [23977] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1044), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1046), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(719), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24036] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1048), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1050), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(720), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24095] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1052), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1054), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(722), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24154] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1056), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1058), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(728), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24213] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1056), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1060), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(732), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24272] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1062), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1064), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(742), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24331] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1056), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1066), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(707), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24390] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1068), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1070), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(684), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24449] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1072), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1074), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(723), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24508] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1076), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1078), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(715), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24567] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1000), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1080), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(683), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24626] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1082), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1084), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(685), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24685] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1086), 1,
      anon_sym_RPAREN,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1088), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(717), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [24744] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [24785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [24826] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [24867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [24908] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1090), 1,
      anon_sym_else,
    ACTIONS(522), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [24951] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [24992] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25074] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    ACTIONS(1092), 1,
      anon_sym_LBRACE,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1094), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(716), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25133] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25174] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25256] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 26,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25297] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1096), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(217), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25353] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25393] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1100), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(195), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25449] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1102), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(196), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25505] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1104), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(750), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25561] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1108), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(206), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25617] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25657] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1110), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(756), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25753] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1112), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(103), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25809] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1116), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(700), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [25865] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25905] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25945] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [25985] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1118), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(761), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26041] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1120), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(623), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26097] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1122), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(653), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26153] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1124), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(284), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26209] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1128), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(738), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26265] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1130), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(778), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26321] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [26361] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1138), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(297), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26417] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1140), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(610), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26473] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1142), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(697), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26529] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1144), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(770), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26585] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1146), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(290), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26641] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1148), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(695), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26697] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1150), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(739), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26753] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1152), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(699), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26809] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1154), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(54), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26865] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1158), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(60), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26921] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1160), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(197), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [26977] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(609), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [27073] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1164), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(275), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27129] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1166), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(682), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27185] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1168), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(172), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27241] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1172), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(714), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27297] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1140), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(610), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27353] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1174), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(658), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27409] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(609), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27465] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1176), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(657), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27521] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1178), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(767), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27577] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1180), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(276), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27633] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1182), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(213), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27689] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1184), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(168), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [27785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [27825] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1186), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(178), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27881] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1188), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(170), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27937] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1190), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(180), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [27993] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1192), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(179), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28049] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1194), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(176), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28105] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(778), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [28145] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1196), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(286), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28201] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1198), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(604), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28257] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1200), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(726), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28313] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [28353] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(744), 1,
      anon_sym_SEMI,
    ACTIONS(304), 6,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(306), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [28395] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1202), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(744), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28451] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1204), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(745), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28507] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1206), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(701), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28563] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1208), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(702), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28619] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1210), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(735), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28675] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1212), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(736), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28731] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1214), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(690), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28787] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1216), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(688), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28843] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1218), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(768), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28899] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1220), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(746), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [28955] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1222), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(755), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29011] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1224), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(757), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29067] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1226), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(752), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29123] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1228), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(174), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29179] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1230), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(721), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29235] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1232), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(52), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29291] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1234), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(59), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29347] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1198), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(604), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29403] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1236), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(289), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29459] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1238), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(718), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29515] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1240), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(606), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29571] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1242), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(747), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29627] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1244), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(607), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29683] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1246), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(603), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29739] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1250), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(109), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29795] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1252), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(748), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29851] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1254), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(51), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29907] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1256), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(57), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [29963] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1258), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(270), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30019] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1260), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(774), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30075] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1262), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(602), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30131] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1264), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(687), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30187] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1266), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(183), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30243] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1240), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(606), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30299] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1268), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(710), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30355] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1270), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(705), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30411] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1244), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(607), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30467] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1272), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(224), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30523] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1274), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(69), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30579] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1276), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(93), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30635] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1278), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(771), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30691] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1280), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(769), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30747] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1282), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(753), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30803] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1284), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(267), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30859] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1286), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(776), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30915] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1288), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(775), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [30971] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1290), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(220), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31027] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1292), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(763), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31083] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1294), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(177), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31139] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1296), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(169), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31195] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1298), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(759), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31251] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1300), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(760), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31307] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1302), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(754), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31363] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1304), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(271), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31419] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1306), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(762), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31475] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1308), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(731), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31531] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1310), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(764), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31587] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1312), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(298), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31643] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 1,
      anon_sym_LPAREN,
    ACTIONS(470), 1,
      anon_sym_LBRACK,
    ACTIONS(490), 1,
      anon_sym_DQUOTE,
    ACTIONS(492), 1,
      anon_sym_DOLLAR,
    ACTIONS(1126), 1,
      sym_variable,
    STATE(345), 1,
      sym_type_name_symbol,
    ACTIONS(484), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1314), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(486), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(272), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31699] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1316), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(191), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31755] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1318), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(655), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 7,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_shebang,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 25,
      anon_sym_echo,
      anon_sym_exit,
      anon_sym_return,
      anon_sym_fail,
      anon_sym_let,
      anon_sym_if,
      anon_sym_loop,
      anon_sym_for,
      anon_sym_break,
      anon_sym_continue,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [31851] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1320), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(166), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31907] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1322), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(734), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [31963] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1324), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(219), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32019] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1326), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(733), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32075] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1328), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(56), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32131] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1330), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(50), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32187] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1198), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(604), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32243] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1332), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(644), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32299] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(609), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32355] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1334), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(645), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32411] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1140), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(610), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32467] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1336), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(77), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32523] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1338), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(126), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32579] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1340), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(49), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32635] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1342), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(713), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32691] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(544), 1,
      anon_sym_DOLLAR,
    ACTIONS(1106), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1344), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(540), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(648), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32747] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1346), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(48), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32803] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1348), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(708), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32859] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1350), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(696), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32915] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1352), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(693), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [32971] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1354), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(773), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33027] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1356), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(741), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33083] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1358), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(740), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33139] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1360), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(758), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33195] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1362), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(730), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33251] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1364), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(704), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33307] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1366), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(611), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33363] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1368), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(45), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33419] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1370), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(61), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33475] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1372), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(108), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33531] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(1134), 1,
      sym_variable,
    ACTIONS(1136), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1374), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(1132), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(765), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33587] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1376), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(106), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33643] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1378), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(105), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33699] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1198), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(604), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33755] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1380), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(608), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33811] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1382), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(751), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33867] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1162), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(609), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33923] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(868), 1,
      sym_variable,
    ACTIONS(870), 1,
      anon_sym_DOLLAR,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1384), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(866), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(772), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [33979] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(9), 1,
      anon_sym_LPAREN,
    ACTIONS(25), 1,
      anon_sym_LBRACK,
    ACTIONS(45), 1,
      anon_sym_DQUOTE,
    ACTIONS(47), 1,
      anon_sym_DOLLAR,
    ACTIONS(1114), 1,
      sym_variable,
    STATE(5), 1,
      sym_type_name_symbol,
    ACTIONS(39), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1386), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(41), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(94), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [34035] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1388), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(53), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [34091] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1390), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(613), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [34147] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(374), 1,
      anon_sym_LPAREN,
    ACTIONS(380), 1,
      anon_sym_LBRACK,
    ACTIONS(400), 1,
      anon_sym_DQUOTE,
    ACTIONS(402), 1,
      anon_sym_DOLLAR,
    ACTIONS(1248), 1,
      sym_variable,
    STATE(631), 1,
      sym_type_name_symbol,
    ACTIONS(394), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1140), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(396), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(610), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [34203] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 1,
      anon_sym_LBRACK,
    ACTIONS(434), 1,
      anon_sym_DQUOTE,
    ACTIONS(436), 1,
      anon_sym_DOLLAR,
    ACTIONS(1170), 1,
      sym_variable,
    STATE(225), 1,
      sym_type_name_symbol,
    ACTIONS(428), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1392), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(430), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(173), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [34259] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(640), 1,
      anon_sym_LPAREN,
    ACTIONS(646), 1,
      anon_sym_LBRACK,
    ACTIONS(666), 1,
      anon_sym_DQUOTE,
    ACTIONS(668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1156), 1,
      sym_variable,
    STATE(91), 1,
      sym_type_name_symbol,
    ACTIONS(660), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1394), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(662), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(55), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [34315] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(158), 1,
      anon_sym_LPAREN,
    ACTIONS(166), 1,
      anon_sym_LBRACK,
    ACTIONS(186), 1,
      anon_sym_DQUOTE,
    ACTIONS(188), 1,
      anon_sym_DOLLAR,
    ACTIONS(1098), 1,
      sym_variable,
    STATE(238), 1,
      sym_type_name_symbol,
    ACTIONS(180), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
    ACTIONS(1396), 4,
      sym_boolean,
      sym_null,
      sym_number,
      sym_status,
    ACTIONS(182), 6,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
    STATE(215), 12,
      sym_subscript_expression,
      sym_parentheses,
      sym_if_ternary,
      sym_type_name,
      sym_array,
      sym_function_call,
      sym_unop,
      sym_binop,
      sym_keyword_binop,
      sym_string,
      sym_command,
      sym__expression,
  [34371] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      anon_sym_failed,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    STATE(641), 1,
      sym_handler_failed,
    STATE(654), 1,
      sym_handler,
    ACTIONS(126), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(124), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34416] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      anon_sym_failed,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    STATE(641), 1,
      sym_handler_failed,
    STATE(652), 1,
      sym_handler,
    ACTIONS(150), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(148), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34461] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      anon_sym_failed,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    STATE(641), 1,
      sym_handler_failed,
    STATE(651), 1,
      sym_handler,
    ACTIONS(146), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(144), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34506] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      anon_sym_failed,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    STATE(641), 1,
      sym_handler_failed,
    STATE(647), 1,
      sym_handler,
    ACTIONS(138), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(136), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34551] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1398), 1,
      anon_sym_failed,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    STATE(641), 1,
      sym_handler_failed,
    STATE(642), 1,
      sym_handler,
    ACTIONS(134), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(132), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34596] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1402), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(642), 1,
      sym_handler,
    ACTIONS(134), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(132), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34640] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1402), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(654), 1,
      sym_handler,
    ACTIONS(126), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(124), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34684] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1402), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(652), 1,
      sym_handler,
    ACTIONS(150), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(148), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34728] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1402), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(651), 1,
      sym_handler,
    ACTIONS(146), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(144), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34772] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1402), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(647), 1,
      sym_handler,
    ACTIONS(138), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(136), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34816] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1404), 1,
      anon_sym_LPAREN,
    ACTIONS(1406), 1,
      anon_sym_EQ,
    STATE(1049), 1,
      sym_subscript,
    ACTIONS(196), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(190), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34860] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1408), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(654), 1,
      sym_handler,
    ACTIONS(126), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(124), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34903] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1408), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(652), 1,
      sym_handler,
    ACTIONS(150), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(148), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34946] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1410), 1,
      anon_sym_LPAREN,
    ACTIONS(1412), 1,
      anon_sym_EQ,
    STATE(1045), 1,
      sym_subscript,
    ACTIONS(196), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(190), 20,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [34989] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1408), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(651), 1,
      sym_handler,
    ACTIONS(146), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(144), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35032] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1408), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(647), 1,
      sym_handler,
    ACTIONS(138), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(136), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35075] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1408), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(642), 1,
      sym_handler,
    ACTIONS(134), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(132), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35118] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1420), 1,
      anon_sym_then,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1414), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1426), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1422), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(352), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_else,
  [35168] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1420), 1,
      anon_sym_then,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1414), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1426), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1422), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(338), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_else,
  [35218] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(348), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(346), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35256] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1420), 1,
      anon_sym_then,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1414), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1426), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1422), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(304), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_else,
  [35306] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(336), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(334), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35344] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(300), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(298), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35382] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(328), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 18,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [35426] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(332), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(330), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35464] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(328), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(326), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35502] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(344), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 18,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [35546] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1404), 1,
      anon_sym_LPAREN,
    ACTIONS(196), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(190), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35582] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(332), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 18,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [35626] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1430), 1,
      anon_sym_else,
    ACTIONS(524), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(522), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35661] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1436), 1,
      anon_sym_then,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1432), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1442), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(304), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(1438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35710] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(634), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(632), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35743] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(638), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(636), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35776] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(672), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(670), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35809] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(676), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(674), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35842] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(680), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(678), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35875] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(684), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(682), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35908] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(778), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(776), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [35941] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1436), 1,
      anon_sym_then,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1432), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1442), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(338), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(1438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35990] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(688), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(686), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(620), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(618), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36056] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(610), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(606), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36122] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(604), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(602), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36155] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1436), 1,
      anon_sym_then,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    ACTIONS(1446), 1,
      anon_sym_SEMI,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1432), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1442), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(304), 6,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(1438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36206] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(118), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(116), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(122), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36272] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(558), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(556), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36305] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1446), 1,
      anon_sym_SEMI,
    ACTIONS(306), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(304), 21,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36340] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(628), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(626), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36373] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(624), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(622), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36406] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(494), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36439] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(444), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(442), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36472] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(438), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36505] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(522), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36538] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(370), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36571] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(520), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(518), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36604] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(146), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(144), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36637] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1410), 1,
      anon_sym_LPAREN,
    ACTIONS(196), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(190), 21,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36672] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(328), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 17,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [36715] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(332), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 17,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [36758] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(692), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(690), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36791] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(150), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(148), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36824] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(344), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 17,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [36867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(514), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36900] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(460), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36933] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(404), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36966] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(126), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(124), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [36999] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1436), 1,
      anon_sym_then,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1432), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1442), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(352), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(1438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [37048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(510), 22,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37081] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(344), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [37123] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1454), 1,
      anon_sym_LPAREN,
    ACTIONS(196), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(190), 20,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37157] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(328), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [37199] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(332), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 16,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COLON,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [37241] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1404), 1,
      anon_sym_LPAREN,
    ACTIONS(1456), 1,
      anon_sym_EQ,
    STATE(1047), 1,
      sym_subscript,
    ACTIONS(196), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(190), 16,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37280] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(618), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(620), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37310] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(606), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(608), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37340] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(610), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(612), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37370] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1458), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(651), 1,
      sym_handler,
    ACTIONS(146), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(144), 15,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37408] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(622), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(624), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37438] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(632), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(634), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37468] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(636), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(638), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37498] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(670), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(672), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37528] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(674), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(676), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37558] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(678), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(680), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37588] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(682), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(684), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37618] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(776), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(778), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37648] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1410), 1,
      anon_sym_LPAREN,
    ACTIONS(1460), 1,
      anon_sym_EQ,
    STATE(1026), 1,
      sym_subscript,
    ACTIONS(196), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(190), 15,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(686), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(688), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37716] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(796), 1,
      anon_sym_SEMI,
    ACTIONS(304), 5,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(306), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37748] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(602), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(604), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37778] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1458), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(647), 1,
      sym_handler,
    ACTIONS(138), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(136), 15,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37816] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 6,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(524), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [37846] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1458), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(642), 1,
      sym_handler,
    ACTIONS(134), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(132), 15,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37884] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1458), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(654), 1,
      sym_handler,
    ACTIONS(126), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(124), 15,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37922] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1400), 1,
      sym_handler_propagation,
    ACTIONS(1458), 1,
      anon_sym_failed,
    STATE(641), 1,
      sym_handler_failed,
    STATE(652), 1,
      sym_handler,
    ACTIONS(150), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(148), 15,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [37960] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1462), 1,
      anon_sym_RPAREN,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    STATE(636), 1,
      sym_subscript,
    STATE(858), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38009] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1474), 1,
      anon_sym_COLON,
    STATE(303), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38058] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1478), 1,
      anon_sym_COLON,
    STATE(636), 1,
      sym_subscript,
    STATE(836), 1,
      sym_block,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38107] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1480), 1,
      anon_sym_LBRACE,
    ACTIONS(1482), 1,
      anon_sym_COLON,
    STATE(409), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38156] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1484), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_COLON,
    STATE(295), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38205] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1488), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    STATE(830), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38254] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1490), 1,
      anon_sym_LBRACE,
    ACTIONS(1492), 1,
      anon_sym_COLON,
    STATE(425), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38303] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1494), 1,
      anon_sym_LBRACE,
    ACTIONS(1496), 1,
      anon_sym_COLON,
    STATE(187), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38352] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1498), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    STATE(877), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38401] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1494), 1,
      anon_sym_LBRACE,
    ACTIONS(1496), 1,
      anon_sym_COLON,
    STATE(192), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38450] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1484), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_COLON,
    STATE(283), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38499] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1500), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    STATE(862), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38548] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1502), 1,
      anon_sym_COLON,
    STATE(628), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38597] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1504), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    STATE(825), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38646] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1478), 1,
      anon_sym_COLON,
    STATE(628), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38695] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1502), 1,
      anon_sym_COLON,
    STATE(626), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38744] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1478), 1,
      anon_sym_COLON,
    STATE(626), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38793] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1506), 1,
      anon_sym_LBRACE,
    ACTIONS(1508), 1,
      anon_sym_COLON,
    STATE(636), 1,
      sym_subscript,
    STATE(709), 1,
      sym_block,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38842] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1510), 1,
      anon_sym_COLON,
    STATE(626), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38891] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1510), 1,
      anon_sym_COLON,
    STATE(628), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38940] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1512), 1,
      anon_sym_LBRACE,
    ACTIONS(1514), 1,
      anon_sym_COLON,
    STATE(100), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [38989] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1512), 1,
      anon_sym_LBRACE,
    ACTIONS(1514), 1,
      anon_sym_COLON,
    STATE(97), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39038] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1516), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    STATE(895), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39087] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1518), 1,
      anon_sym_LBRACE,
    ACTIONS(1520), 1,
      anon_sym_COLON,
    STATE(140), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39136] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1506), 1,
      anon_sym_LBRACE,
    ACTIONS(1522), 1,
      anon_sym_COLON,
    STATE(636), 1,
      sym_subscript,
    STATE(675), 1,
      sym_block,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39185] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1524), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    STATE(852), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39234] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1502), 1,
      anon_sym_COLON,
    STATE(614), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39283] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1526), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39328] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(900), 5,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_DQUOTE,
      anon_sym_DOLLAR,
    ACTIONS(908), 16,
      anon_sym_else,
      sym_boolean,
      sym_null,
      sym_number,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
      sym_status,
      anon_sym_DASH,
      anon_sym_not,
      anon_sym_unsafe,
      anon_sym_trust,
      anon_sym_silent,
      anon_sym_nameof,
      sym_variable,
  [39357] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1506), 1,
      anon_sym_LBRACE,
    ACTIONS(1522), 1,
      anon_sym_COLON,
    STATE(636), 1,
      sym_subscript,
    STATE(662), 1,
      sym_block,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39406] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1528), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    STATE(869), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39455] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1530), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    STATE(864), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39504] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    STATE(303), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39553] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1474), 1,
      anon_sym_COLON,
    STATE(302), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39602] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1506), 1,
      anon_sym_LBRACE,
    ACTIONS(1522), 1,
      anon_sym_COLON,
    STATE(636), 1,
      sym_subscript,
    STATE(677), 1,
      sym_block,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39651] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1480), 1,
      anon_sym_LBRACE,
    ACTIONS(1482), 1,
      anon_sym_COLON,
    STATE(410), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39700] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1532), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    STATE(887), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39749] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1480), 1,
      anon_sym_LBRACE,
    ACTIONS(1482), 1,
      anon_sym_COLON,
    STATE(418), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39798] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1494), 1,
      anon_sym_LBRACE,
    ACTIONS(1496), 1,
      anon_sym_COLON,
    STATE(185), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39847] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1534), 1,
      anon_sym_LBRACE,
    ACTIONS(1536), 1,
      anon_sym_COLON,
    STATE(351), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39896] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    STATE(302), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39945] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1512), 1,
      anon_sym_LBRACE,
    ACTIONS(1514), 1,
      anon_sym_COLON,
    STATE(82), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [39994] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1512), 1,
      anon_sym_LBRACE,
    ACTIONS(1514), 1,
      anon_sym_COLON,
    STATE(124), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40043] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1538), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    STATE(850), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40092] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1540), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    STATE(838), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40141] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1480), 1,
      anon_sym_LBRACE,
    ACTIONS(1482), 1,
      anon_sym_COLON,
    STATE(417), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40190] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1542), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    STATE(842), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40239] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1478), 1,
      anon_sym_COLON,
    STATE(636), 1,
      sym_subscript,
    STATE(639), 1,
      sym_block,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40288] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1544), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    STATE(897), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40337] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1518), 1,
      anon_sym_LBRACE,
    ACTIONS(1520), 1,
      anon_sym_COLON,
    STATE(150), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40386] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1490), 1,
      anon_sym_LBRACE,
    ACTIONS(1492), 1,
      anon_sym_COLON,
    STATE(430), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40435] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1502), 1,
      anon_sym_COLON,
    STATE(636), 1,
      sym_subscript,
    STATE(639), 1,
      sym_block,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40484] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1546), 1,
      anon_sym_LBRACE,
    ACTIONS(1548), 1,
      anon_sym_COLON,
    STATE(240), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40533] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1546), 1,
      anon_sym_LBRACE,
    ACTIONS(1548), 1,
      anon_sym_COLON,
    STATE(236), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40582] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1534), 1,
      anon_sym_LBRACE,
    ACTIONS(1536), 1,
      anon_sym_COLON,
    STATE(348), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40631] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1534), 1,
      anon_sym_LBRACE,
    ACTIONS(1536), 1,
      anon_sym_COLON,
    STATE(350), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40680] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1550), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    STATE(823), 1,
      aux_sym_array_repeat1,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40729] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1484), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_COLON,
    STATE(296), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40778] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1484), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_COLON,
    STATE(287), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40827] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1420), 1,
      anon_sym_then,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1414), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1426), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(298), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_else,
    ACTIONS(1422), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40872] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1420), 1,
      anon_sym_then,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1414), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1426), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(334), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_else,
    ACTIONS(1422), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40917] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1494), 1,
      anon_sym_LBRACE,
    ACTIONS(1496), 1,
      anon_sym_COLON,
    STATE(199), 1,
      sym_block,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [40966] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 1,
      anon_sym_else,
    ACTIONS(1416), 1,
      anon_sym_STAR,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1420), 1,
      anon_sym_then,
    ACTIONS(1424), 1,
      anon_sym_SLASH,
    ACTIONS(1446), 1,
      anon_sym_SEMI,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1414), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1426), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1428), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1422), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41012] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1552), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41056] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1554), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41100] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1556), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41144] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1558), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41188] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1436), 1,
      anon_sym_then,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(334), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(1432), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1442), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41232] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 1,
      anon_sym_RBRACE,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1436), 1,
      anon_sym_then,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    ACTIONS(1560), 1,
      anon_sym_SEMI,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1432), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1442), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41278] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1434), 1,
      anon_sym_STAR,
    ACTIONS(1436), 1,
      anon_sym_then,
    ACTIONS(1440), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(298), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(1432), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1442), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1444), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1438), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41322] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1562), 1,
      anon_sym_RBRACE,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41365] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1568), 1,
      anon_sym_else,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41408] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1580), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41451] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1582), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41494] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1584), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41537] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1586), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41580] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1588), 1,
      anon_sym_RBRACE,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41623] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    ACTIONS(1590), 1,
      anon_sym_else,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41666] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    ACTIONS(1592), 1,
      anon_sym_else,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41709] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    ACTIONS(1594), 1,
      anon_sym_else,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41752] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1596), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41795] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1598), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41838] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1600), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41881] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    ACTIONS(1602), 1,
      anon_sym_else,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41924] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    ACTIONS(1604), 1,
      anon_sym_else,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [41967] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1606), 1,
      anon_sym_LPAREN,
    ACTIONS(196), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(190), 15,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [41996] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(328), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(326), 11,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [42033] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1608), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [42076] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    ACTIONS(1610), 1,
      anon_sym_else,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [42119] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(332), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(330), 11,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [42156] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1612), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [42199] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1614), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [42242] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    ACTIONS(1616), 1,
      anon_sym_else,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [42285] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1618), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [42328] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1570), 1,
      anon_sym_then,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    ACTIONS(1620), 1,
      anon_sym_else,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1564), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1576), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1572), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [42371] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1448), 1,
      anon_sym_STAR,
    ACTIONS(1450), 1,
      anon_sym_SLASH,
    ACTIONS(1468), 1,
      anon_sym_then,
    ACTIONS(1622), 1,
      anon_sym_RBRACK,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(1452), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1466), 2,
      anon_sym_as,
      anon_sym_is,
    ACTIONS(1472), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1470), 7,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [42414] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(122), 3,
      anon_sym_SLASH,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(120), 16,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_STAR,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
  [42441] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1418), 1,
      anon_sym_LBRACK,
    ACTIONS(1566), 1,
      anon_sym_STAR,
    ACTIONS(1574), 1,
      anon_sym_SLASH,
    STATE(636), 1,
      sym_subscript,
    ACTIONS(344), 2,
      anon_sym_GT,
      anon_sym_LT,
    ACTIONS(1578), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(342), 11,
      anon_sym_as,
      anon_sym_else,
      anon_sym_then,
      anon_sym_DASH,
      anon_sym_PLUS,
      anon_sym_PERCENT,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_is,
  [42478] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1630), 1,
      anon_sym_DOLLAR,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42499] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1634), 1,
      anon_sym_DOLLAR,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42520] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    STATE(5), 1,
      sym_type_name_symbol,
    STATE(870), 1,
      sym_type_name,
    ACTIONS(1638), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
  [42539] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1636), 1,
      anon_sym_LBRACK,
    STATE(5), 1,
      sym_type_name_symbol,
    STATE(857), 1,
      sym_type_name,
    ACTIONS(1638), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
  [42558] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1642), 1,
      sym_command_content,
    ACTIONS(1644), 1,
      anon_sym_DOLLAR,
    ACTIONS(1640), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(795), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42579] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1648), 1,
      sym_command_content,
    ACTIONS(1650), 1,
      anon_sym_DOLLAR,
    ACTIONS(1646), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(779), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42600] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1652), 1,
      anon_sym_DOLLAR,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42621] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1654), 1,
      anon_sym_DOLLAR,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42642] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1658), 1,
      sym_command_content,
    ACTIONS(1660), 1,
      anon_sym_DOLLAR,
    ACTIONS(1656), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(786), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42663] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1662), 1,
      anon_sym_DOLLAR,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42684] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1666), 1,
      sym_command_content,
    ACTIONS(1668), 1,
      anon_sym_DOLLAR,
    ACTIONS(1664), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(791), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42705] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1672), 1,
      sym_command_content,
    ACTIONS(1674), 1,
      anon_sym_DOLLAR,
    ACTIONS(1670), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(788), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42726] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1676), 1,
      anon_sym_DOLLAR,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42747] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1680), 1,
      sym_command_content,
    ACTIONS(1682), 1,
      anon_sym_DOLLAR,
    ACTIONS(1678), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(780), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42768] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1684), 1,
      anon_sym_DOLLAR,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42789] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1688), 1,
      sym_command_content,
    ACTIONS(1690), 1,
      anon_sym_DOLLAR,
    ACTIONS(1686), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(785), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42810] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1692), 1,
      anon_sym_DOLLAR,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42831] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1628), 1,
      sym_command_content,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1694), 1,
      anon_sym_DOLLAR,
    ACTIONS(1626), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42852] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1698), 1,
      sym_command_content,
    ACTIONS(1700), 1,
      anon_sym_DOLLAR,
    ACTIONS(1696), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(796), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42873] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1702), 1,
      anon_sym_LBRACE,
    ACTIONS(1708), 1,
      sym_command_content,
    ACTIONS(1711), 1,
      anon_sym_DOLLAR,
    ACTIONS(1705), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(798), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42894] = 6,
    ACTIONS(1624), 1,
      anon_sym_LBRACE,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1715), 1,
      sym_command_content,
    ACTIONS(1717), 1,
      anon_sym_DOLLAR,
    ACTIONS(1713), 2,
      sym_escape_sequence,
      sym_command_option,
    STATE(793), 2,
      sym_interpolation,
      aux_sym_command_repeat1,
  [42915] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1721), 1,
      sym_string_content,
    ACTIONS(1723), 1,
      anon_sym_DQUOTE,
    ACTIONS(1725), 1,
      sym_escape_sequence,
    STATE(810), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [42935] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1727), 1,
      sym_string_content,
    ACTIONS(1729), 1,
      anon_sym_DQUOTE,
    ACTIONS(1731), 1,
      sym_escape_sequence,
    STATE(811), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [42955] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1733), 1,
      sym_string_content,
    ACTIONS(1735), 1,
      anon_sym_DQUOTE,
    ACTIONS(1737), 1,
      sym_escape_sequence,
    STATE(804), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [42975] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1739), 1,
      sym_string_content,
    ACTIONS(1741), 1,
      anon_sym_DQUOTE,
    ACTIONS(1743), 1,
      sym_escape_sequence,
    STATE(809), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [42995] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1727), 1,
      sym_string_content,
    ACTIONS(1731), 1,
      sym_escape_sequence,
    ACTIONS(1745), 1,
      anon_sym_DQUOTE,
    STATE(811), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43015] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1747), 1,
      sym_string_content,
    ACTIONS(1749), 1,
      anon_sym_DQUOTE,
    ACTIONS(1751), 1,
      sym_escape_sequence,
    STATE(808), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43035] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1753), 1,
      sym_string_content,
    ACTIONS(1755), 1,
      anon_sym_DQUOTE,
    ACTIONS(1757), 1,
      sym_escape_sequence,
    STATE(814), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43055] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1759), 1,
      sym_string_content,
    ACTIONS(1761), 1,
      anon_sym_DQUOTE,
    ACTIONS(1763), 1,
      sym_escape_sequence,
    STATE(813), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43075] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1727), 1,
      sym_string_content,
    ACTIONS(1731), 1,
      sym_escape_sequence,
    ACTIONS(1765), 1,
      anon_sym_DQUOTE,
    STATE(811), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43095] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1727), 1,
      sym_string_content,
    ACTIONS(1731), 1,
      sym_escape_sequence,
    ACTIONS(1767), 1,
      anon_sym_DQUOTE,
    STATE(811), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43115] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1727), 1,
      sym_string_content,
    ACTIONS(1731), 1,
      sym_escape_sequence,
    ACTIONS(1769), 1,
      anon_sym_DQUOTE,
    STATE(811), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43135] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1771), 1,
      anon_sym_LBRACE,
    ACTIONS(1774), 1,
      sym_string_content,
    ACTIONS(1777), 1,
      anon_sym_DQUOTE,
    ACTIONS(1779), 1,
      sym_escape_sequence,
    STATE(811), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43155] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1782), 1,
      sym_string_content,
    ACTIONS(1784), 1,
      anon_sym_DQUOTE,
    ACTIONS(1786), 1,
      sym_escape_sequence,
    STATE(801), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43175] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1727), 1,
      sym_string_content,
    ACTIONS(1731), 1,
      sym_escape_sequence,
    ACTIONS(1788), 1,
      anon_sym_DQUOTE,
    STATE(811), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43195] = 6,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1719), 1,
      anon_sym_LBRACE,
    ACTIONS(1727), 1,
      sym_string_content,
    ACTIONS(1731), 1,
      sym_escape_sequence,
    ACTIONS(1790), 1,
      anon_sym_DQUOTE,
    STATE(811), 2,
      sym_interpolation,
      aux_sym_string_repeat1,
  [43215] = 3,
    ACTIONS(3), 1,
      sym_comment,
    STATE(998), 1,
      sym_type_name_symbol,
    ACTIONS(1638), 4,
      anon_sym_Text,
      anon_sym_Num,
      anon_sym_Bool,
      anon_sym_Null,
  [43228] = 3,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1794), 1,
      sym_command_content,
    ACTIONS(1792), 4,
      anon_sym_LBRACE,
      sym_escape_sequence,
      anon_sym_DOLLAR,
      sym_command_option,
  [43241] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1796), 1,
      anon_sym_COMMA,
    STATE(817), 1,
      aux_sym_array_repeat1,
    ACTIONS(1526), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [43255] = 3,
    ACTIONS(1632), 1,
      sym_comment,
    ACTIONS(1794), 1,
      sym_string_content,
    ACTIONS(1792), 3,
      anon_sym_LBRACE,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [43267] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1799), 1,
      anon_sym_COLON,
    ACTIONS(1803), 1,
      anon_sym_EQ,
    ACTIONS(1801), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [43281] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    ACTIONS(1805), 1,
      anon_sym_LPAREN,
    STATE(316), 1,
      sym_block,
  [43297] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1807), 1,
      anon_sym_RPAREN,
    ACTIONS(1809), 1,
      sym_reference,
    ACTIONS(1811), 1,
      sym_variable,
    STATE(919), 1,
      sym_function_parameter_list_item,
  [43313] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1813), 1,
      anon_sym_COLON,
    ACTIONS(1817), 1,
      anon_sym_EQ,
    ACTIONS(1815), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [43327] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1819), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43340] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(995), 1,
      sym_block,
  [43353] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1823), 1,
      anon_sym_RBRACK,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43366] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1546), 1,
      anon_sym_LBRACE,
    ACTIONS(1548), 1,
      anon_sym_COLON,
    STATE(247), 1,
      sym_block,
  [43379] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1546), 1,
      anon_sym_LBRACE,
    ACTIONS(1548), 1,
      anon_sym_COLON,
    STATE(228), 1,
      sym_block,
  [43392] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1825), 1,
      anon_sym_EQ,
    STATE(1056), 1,
      sym_subscript,
  [43405] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1827), 1,
      anon_sym_EQ,
    STATE(1036), 1,
      sym_subscript,
  [43418] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1829), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43431] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    STATE(274), 1,
      sym_block,
  [43444] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1831), 1,
      anon_sym_EQ,
    STATE(1049), 1,
      sym_subscript,
  [43457] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1518), 1,
      anon_sym_LBRACE,
    ACTIONS(1520), 1,
      anon_sym_COLON,
    STATE(147), 1,
      sym_block,
  [43470] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1833), 1,
      anon_sym_EQ,
    STATE(1047), 1,
      sym_subscript,
  [43483] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1478), 1,
      anon_sym_COLON,
    STATE(620), 1,
      sym_block,
  [43496] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1835), 1,
      anon_sym_else,
    ACTIONS(522), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
  [43507] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1837), 1,
      anon_sym_EQ,
    STATE(1041), 1,
      sym_subscript,
  [43520] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1839), 1,
      anon_sym_RBRACK,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43533] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1518), 1,
      anon_sym_LBRACE,
    ACTIONS(1520), 1,
      anon_sym_COLON,
    STATE(151), 1,
      sym_block,
  [43546] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1546), 1,
      anon_sym_LBRACE,
    ACTIONS(1548), 1,
      anon_sym_COLON,
    STATE(241), 1,
      sym_block,
  [43559] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1490), 1,
      anon_sym_LBRACE,
    ACTIONS(1492), 1,
      anon_sym_COLON,
    STATE(431), 1,
      sym_block,
  [43572] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1841), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43585] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1474), 1,
      anon_sym_COLON,
    STATE(274), 1,
      sym_block,
  [43598] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1843), 1,
      anon_sym_COLON,
    STATE(650), 1,
      sym_block,
  [43611] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1494), 1,
      anon_sym_LBRACE,
    ACTIONS(1496), 1,
      anon_sym_COLON,
    STATE(184), 1,
      sym_block,
  [43624] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1512), 1,
      anon_sym_LBRACE,
    ACTIONS(1514), 1,
      anon_sym_COLON,
    STATE(118), 1,
      sym_block,
  [43637] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1845), 1,
      anon_sym_EQ,
    STATE(1026), 1,
      sym_subscript,
  [43650] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1847), 1,
      anon_sym_EQ,
    STATE(1024), 1,
      sym_subscript,
  [43663] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1849), 1,
      anon_sym_RBRACE,
    ACTIONS(1851), 1,
      sym_variable,
    STATE(874), 1,
      sym_import_item,
  [43676] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1853), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43689] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1490), 1,
      anon_sym_LBRACE,
    ACTIONS(1492), 1,
      anon_sym_COLON,
    STATE(465), 1,
      sym_block,
  [43702] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1855), 1,
      anon_sym_RBRACK,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43715] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1857), 1,
      anon_sym_EQ,
    STATE(1029), 1,
      sym_subscript,
  [43728] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1510), 1,
      anon_sym_COLON,
    STATE(650), 1,
      sym_block,
  [43741] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1512), 1,
      anon_sym_LBRACE,
    ACTIONS(1514), 1,
      anon_sym_COLON,
    STATE(73), 1,
      sym_block,
  [43754] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1859), 1,
      anon_sym_EQ,
    STATE(992), 1,
      sym_subscript,
  [43767] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1861), 1,
      anon_sym_EQ,
    ACTIONS(1556), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [43778] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1863), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43791] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1534), 1,
      anon_sym_LBRACE,
    ACTIONS(1536), 1,
      anon_sym_COLON,
    STATE(333), 1,
      sym_block,
  [43804] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1480), 1,
      anon_sym_LBRACE,
    ACTIONS(1482), 1,
      anon_sym_COLON,
    STATE(412), 1,
      sym_block,
  [43817] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1510), 1,
      anon_sym_COLON,
    STATE(620), 1,
      sym_block,
  [43830] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1865), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43843] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1494), 1,
      anon_sym_LBRACE,
    ACTIONS(1496), 1,
      anon_sym_COLON,
    STATE(207), 1,
      sym_block,
  [43856] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1867), 1,
      anon_sym_RBRACK,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43869] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1869), 1,
      anon_sym_RPAREN,
    ACTIONS(1871), 1,
      anon_sym_COMMA,
    STATE(865), 1,
      aux_sym_function_parameter_list_repeat1,
  [43882] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1874), 1,
      anon_sym_EQ,
    STATE(977), 1,
      sym_subscript,
  [43895] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1474), 1,
      anon_sym_COLON,
    STATE(301), 1,
      sym_block,
  [43908] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1851), 1,
      sym_variable,
    ACTIONS(1876), 1,
      anon_sym_RBRACE,
    STATE(905), 1,
      sym_import_item,
  [43921] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1878), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [43934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1880), 1,
      anon_sym_EQ,
    ACTIONS(1558), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [43945] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1882), 1,
      anon_sym_EQ,
    STATE(982), 1,
      sym_subscript,
  [43958] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1884), 1,
      anon_sym_COLON,
    STATE(323), 1,
      sym_block,
  [43971] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1888), 1,
      anon_sym_as,
    ACTIONS(1886), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [43982] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1876), 1,
      anon_sym_RBRACE,
    ACTIONS(1890), 1,
      anon_sym_COMMA,
    STATE(912), 1,
      aux_sym_import_statement_repeat1,
  [43995] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1032), 1,
      sym_block,
  [44008] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(986), 1,
      sym_block,
  [44021] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1892), 1,
      anon_sym_RBRACK,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [44034] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1502), 1,
      anon_sym_COLON,
    STATE(620), 1,
      sym_block,
  [44047] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1502), 1,
      anon_sym_COLON,
    STATE(650), 1,
      sym_block,
  [44060] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1894), 1,
      anon_sym_RBRACE,
    ACTIONS(1896), 1,
      anon_sym_COMMA,
    STATE(880), 1,
      aux_sym_import_statement_repeat1,
  [44073] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1038), 1,
      sym_block,
  [44086] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1510), 1,
      anon_sym_COLON,
    STATE(625), 1,
      sym_block,
  [44099] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1899), 1,
      anon_sym_RPAREN,
    ACTIONS(1901), 1,
      anon_sym_COMMA,
    STATE(865), 1,
      aux_sym_function_parameter_list_repeat1,
  [44112] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1809), 1,
      sym_reference,
    ACTIONS(1811), 1,
      sym_variable,
    STATE(968), 1,
      sym_function_parameter_list_item,
  [44125] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
    ACTIONS(1903), 1,
      anon_sym_COLON,
    STATE(650), 1,
      sym_block,
  [44138] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1890), 1,
      anon_sym_COMMA,
    ACTIONS(1905), 1,
      anon_sym_RBRACE,
    STATE(880), 1,
      aux_sym_import_statement_repeat1,
  [44151] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1907), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [44164] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1484), 1,
      anon_sym_LBRACE,
    ACTIONS(1486), 1,
      anon_sym_COLON,
    STATE(281), 1,
      sym_block,
  [44177] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1506), 1,
      anon_sym_LBRACE,
    ACTIONS(1522), 1,
      anon_sym_COLON,
    STATE(669), 1,
      sym_block,
  [44190] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1534), 1,
      anon_sym_LBRACE,
    ACTIONS(1536), 1,
      anon_sym_COLON,
    STATE(331), 1,
      sym_block,
  [44203] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1909), 1,
      anon_sym_COLON,
    STATE(308), 1,
      sym_block,
  [44216] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1057), 1,
      sym_block,
  [44229] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1050), 1,
      sym_block,
  [44242] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1518), 1,
      anon_sym_LBRACE,
    ACTIONS(1520), 1,
      anon_sym_COLON,
    STATE(145), 1,
      sym_block,
  [44255] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1911), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [44268] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1913), 1,
      anon_sym_EQ,
    STATE(1059), 1,
      sym_subscript,
  [44281] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1464), 1,
      anon_sym_COMMA,
    ACTIONS(1915), 1,
      anon_sym_RBRACK,
    STATE(817), 1,
      aux_sym_array_repeat1,
  [44294] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    STATE(315), 1,
      sym_block,
  [44307] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(194), 1,
      anon_sym_COLON,
    STATE(301), 1,
      sym_block,
  [44320] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(996), 1,
      sym_block,
  [44333] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(985), 1,
      sym_block,
  [44346] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1917), 1,
      anon_sym_COLON,
    STATE(314), 1,
      sym_block,
  [44359] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(979), 1,
      sym_block,
  [44372] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1919), 1,
      anon_sym_EQ,
    STATE(970), 1,
      sym_subscript,
  [44385] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1890), 1,
      anon_sym_COMMA,
    ACTIONS(1921), 1,
      anon_sym_RBRACE,
    STATE(886), 1,
      aux_sym_import_statement_repeat1,
  [44398] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(997), 1,
      sym_block,
  [44411] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1037), 1,
      sym_block,
  [44424] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1022), 1,
      sym_block,
  [44437] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1027), 1,
      sym_block,
  [44450] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1040), 1,
      sym_block,
  [44463] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1048), 1,
      sym_block,
  [44476] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1890), 1,
      anon_sym_COMMA,
    ACTIONS(1921), 1,
      anon_sym_RBRACE,
    STATE(880), 1,
      aux_sym_import_statement_repeat1,
  [44489] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1052), 1,
      sym_block,
  [44502] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1054), 1,
      sym_block,
  [44515] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1039), 1,
      sym_block,
  [44528] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(978), 1,
      sym_block,
  [44541] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(984), 1,
      sym_block,
  [44554] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(204), 1,
      anon_sym_LBRACK,
    ACTIONS(1923), 1,
      anon_sym_EQ,
    STATE(1045), 1,
      sym_subscript,
  [44567] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1901), 1,
      anon_sym_COMMA,
    ACTIONS(1925), 1,
      anon_sym_RPAREN,
    STATE(883), 1,
      aux_sym_function_parameter_list_repeat1,
  [44580] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1033), 1,
      sym_block,
  [44593] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(192), 1,
      anon_sym_LBRACE,
    ACTIONS(1821), 1,
      anon_sym_COLON,
    STATE(1034), 1,
      sym_block,
  [44606] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1927), 1,
      anon_sym_DQUOTE,
    STATE(309), 1,
      sym_string,
  [44616] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1929), 1,
      anon_sym_pub,
    ACTIONS(1931), 1,
      anon_sym_fun,
  [44626] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1933), 1,
      sym_variable,
    STATE(621), 1,
      sym_variable_assignment,
  [44636] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1935), 1,
      anon_sym_COMMA,
    ACTIONS(1937), 1,
      anon_sym_in,
  [44646] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1939), 1,
      sym_variable,
    STATE(621), 1,
      sym_variable_assignment,
  [44656] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1851), 1,
      sym_variable,
    STATE(966), 1,
      sym_import_item,
  [44666] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1931), 1,
      anon_sym_fun,
    ACTIONS(1941), 1,
      anon_sym_import,
  [44676] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1943), 1,
      anon_sym_LBRACE,
    ACTIONS(1945), 1,
      anon_sym_STAR,
  [44686] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1947), 1,
      anon_sym_COMMA,
    ACTIONS(1949), 1,
      anon_sym_in,
  [44696] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1951), 1,
      anon_sym_COMMA,
    ACTIONS(1953), 1,
      anon_sym_in,
  [44706] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1955), 1,
      sym_variable,
    STATE(273), 1,
      sym_variable_assignment,
  [44716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1957), 1,
      sym_variable,
    STATE(119), 1,
      sym_variable_assignment,
  [44726] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1959), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
  [44734] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1961), 1,
      anon_sym_COMMA,
    ACTIONS(1963), 1,
      anon_sym_in,
  [44744] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1965), 1,
      sym_variable,
    STATE(411), 1,
      sym_variable_assignment,
  [44754] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1927), 1,
      anon_sym_DQUOTE,
    STATE(313), 1,
      sym_string,
  [44764] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1967), 1,
      sym_variable,
    STATE(670), 1,
      sym_variable_assignment,
  [44774] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(304), 1,
      anon_sym_RBRACE,
    ACTIONS(1560), 1,
      anon_sym_SEMI,
  [44784] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1969), 1,
      anon_sym_COMMA,
    ACTIONS(1971), 1,
      anon_sym_in,
  [44794] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1973), 1,
      sym_variable,
    STATE(332), 1,
      sym_variable_assignment,
  [44804] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1849), 1,
      anon_sym_STAR,
    ACTIONS(1975), 1,
      anon_sym_LBRACE,
  [44814] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1977), 1,
      anon_sym_LPAREN,
    STATE(872), 1,
      sym_function_parameter_list,
  [44824] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1979), 1,
      anon_sym_COMMA,
    ACTIONS(1981), 1,
      anon_sym_in,
  [44834] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1983), 1,
      anon_sym_COMMA,
    ACTIONS(1985), 1,
      anon_sym_in,
  [44844] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1987), 1,
      sym_variable,
    STATE(621), 1,
      sym_variable_assignment,
  [44854] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1989), 1,
      sym_variable,
    STATE(466), 1,
      sym_variable_assignment,
  [44864] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1991), 1,
      anon_sym_COMMA,
    ACTIONS(1993), 1,
      anon_sym_in,
  [44874] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1995), 1,
      sym_variable,
    STATE(208), 1,
      sym_variable_assignment,
  [44884] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1997), 1,
      anon_sym_COMMA,
    ACTIONS(1999), 1,
      anon_sym_in,
  [44894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1977), 1,
      anon_sym_LPAREN,
    STATE(902), 1,
      sym_function_parameter_list,
  [44904] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1977), 1,
      anon_sym_LPAREN,
    STATE(891), 1,
      sym_function_parameter_list,
  [44914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1927), 1,
      anon_sym_DQUOTE,
    STATE(322), 1,
      sym_string,
  [44924] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2001), 1,
      anon_sym_COMMA,
    ACTIONS(2003), 1,
      anon_sym_in,
  [44934] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2005), 1,
      anon_sym_COMMA,
    ACTIONS(2007), 1,
      anon_sym_in,
  [44944] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2009), 1,
      anon_sym_COMMA,
    ACTIONS(2011), 1,
      anon_sym_in,
  [44954] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2013), 1,
      sym_variable,
    STATE(237), 1,
      sym_variable_assignment,
  [44964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2015), 1,
      anon_sym_COMMA,
    ACTIONS(2017), 1,
      anon_sym_in,
  [44974] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1927), 1,
      anon_sym_DQUOTE,
    STATE(307), 1,
      sym_string,
  [44984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2019), 1,
      sym_variable,
    STATE(157), 1,
      sym_variable_assignment,
  [44994] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2021), 1,
      sym_variable,
    STATE(280), 1,
      sym_variable_assignment,
  [45004] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2023), 1,
      anon_sym_COMMA,
    ACTIONS(2025), 1,
      anon_sym_in,
  [45014] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2027), 1,
      sym_variable,
    STATE(273), 1,
      sym_variable_assignment,
  [45024] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2029), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
  [45032] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2031), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [45040] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1894), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [45048] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1927), 1,
      anon_sym_DQUOTE,
    STATE(312), 1,
      sym_string,
  [45058] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1869), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [45066] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2033), 2,
      anon_sym_LBRACE,
      anon_sym_COLON,
  [45074] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2035), 1,
      anon_sym_EQ,
  [45081] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2037), 1,
      sym_variable,
  [45088] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2039), 1,
      sym_variable,
  [45095] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2041), 1,
      anon_sym_in,
  [45102] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2043), 1,
      anon_sym_in,
  [45109] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2045), 1,
      sym_variable,
  [45116] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2047), 1,
      anon_sym_from,
  [45123] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2049), 1,
      anon_sym_EQ,
  [45130] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2051), 1,
      anon_sym_RBRACE,
  [45137] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2053), 1,
      anon_sym_RBRACE,
  [45144] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2055), 1,
      anon_sym_in,
  [45151] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2057), 1,
      anon_sym_from,
  [45158] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2059), 1,
      anon_sym_EQ,
  [45165] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2061), 1,
      anon_sym_from,
  [45172] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2063), 1,
      anon_sym_RBRACE,
  [45179] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2065), 1,
      anon_sym_RBRACE,
  [45186] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2067), 1,
      anon_sym_RBRACE,
  [45193] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2069), 1,
      anon_sym_in,
  [45200] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2071), 1,
      sym_variable,
  [45207] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2073), 1,
      sym_variable,
  [45214] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2075), 1,
      sym_variable,
  [45221] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2077), 1,
      anon_sym_RPAREN,
  [45228] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2079), 1,
      anon_sym_EQ,
  [45235] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2081), 1,
      anon_sym_in,
  [45242] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2083), 1,
      anon_sym_in,
  [45249] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2085), 1,
      anon_sym_RBRACE,
  [45256] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2087), 1,
      anon_sym_RBRACE,
  [45263] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2089), 1,
      anon_sym_RBRACE,
  [45270] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2091), 1,
      anon_sym_RBRACK,
  [45277] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2093), 1,
      anon_sym_from,
  [45284] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2095), 1,
      sym_variable,
  [45291] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2097), 1,
      sym_variable,
  [45298] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2099), 1,
      sym_variable,
  [45305] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2101), 1,
      sym_variable,
  [45312] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2103), 1,
      sym_variable,
  [45319] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2105), 1,
      sym_variable,
  [45326] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2107), 1,
      sym_variable,
  [45333] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2109), 1,
      sym_variable,
  [45340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2111), 1,
      sym_variable,
  [45347] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2113), 1,
      sym_variable,
  [45354] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2115), 1,
      sym_variable,
  [45361] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2117), 1,
      sym_variable,
  [45368] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2119), 1,
      sym_variable,
  [45375] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2121), 1,
      sym_variable,
  [45382] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2123), 1,
      sym_variable,
  [45389] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2125), 1,
      sym_variable,
  [45396] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2127), 1,
      sym_variable,
  [45403] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2129), 1,
      sym_variable,
  [45410] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2131), 1,
      sym_variable,
  [45417] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2133), 1,
      sym_variable,
  [45424] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2135), 1,
      sym_variable,
  [45431] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2137), 1,
      sym_variable,
  [45438] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2139), 1,
      anon_sym_RBRACE,
  [45445] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2141), 1,
      anon_sym_in,
  [45452] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2143), 1,
      anon_sym_EQ,
  [45459] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2145), 1,
      anon_sym_from,
  [45466] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2147), 1,
      anon_sym_EQ,
  [45473] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2149), 1,
      anon_sym_RBRACE,
  [45480] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2151), 1,
      anon_sym_in,
  [45487] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2153), 1,
      anon_sym_EQ,
  [45494] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2155), 1,
      anon_sym_in,
  [45501] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2157), 1,
      sym_variable,
  [45508] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2159), 1,
      anon_sym_RBRACE,
  [45515] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2161), 1,
      anon_sym_RBRACE,
  [45522] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2163), 1,
      anon_sym_RBRACE,
  [45529] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2165), 1,
      anon_sym_fun,
  [45536] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2167), 1,
      anon_sym_EQ,
  [45543] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2169), 1,
      anon_sym_RBRACE,
  [45550] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2171), 1,
      anon_sym_RBRACE,
  [45557] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2173), 1,
      anon_sym_RBRACE,
  [45564] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2175), 1,
      anon_sym_RBRACE,
  [45571] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2177), 1,
      anon_sym_EQ,
  [45578] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2179), 1,
      sym_variable,
  [45585] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2181), 1,
      ts_builtin_sym_end,
  [45592] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2183), 1,
      anon_sym_in,
  [45599] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2185), 1,
      anon_sym_EQ,
  [45606] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2187), 1,
      anon_sym_in,
  [45613] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2189), 1,
      anon_sym_EQ,
  [45620] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2191), 1,
      anon_sym_RBRACE,
  [45627] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2193), 1,
      anon_sym_EQ,
  [45634] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2195), 1,
      anon_sym_RBRACE,
  [45641] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2197), 1,
      sym_variable,
  [45648] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2199), 1,
      anon_sym_RBRACE,
  [45655] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2201), 1,
      anon_sym_in,
  [45662] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2203), 1,
      anon_sym_RBRACE,
  [45669] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2205), 1,
      sym_variable,
  [45676] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2207), 1,
      anon_sym_EQ,
  [45683] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2209), 1,
      anon_sym_RBRACE,
  [45690] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2211), 1,
      sym_variable,
  [45697] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2213), 1,
      anon_sym_EQ,
  [45704] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2215), 1,
      anon_sym_in,
  [45711] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2217), 1,
      sym_variable,
  [45718] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(2219), 1,
      anon_sym_in,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(12)] = 0,
  [SMALL_STATE(13)] = 72,
  [SMALL_STATE(14)] = 144,
  [SMALL_STATE(15)] = 216,
  [SMALL_STATE(16)] = 288,
  [SMALL_STATE(17)] = 360,
  [SMALL_STATE(18)] = 461,
  [SMALL_STATE(19)] = 530,
  [SMALL_STATE(20)] = 599,
  [SMALL_STATE(21)] = 700,
  [SMALL_STATE(22)] = 771,
  [SMALL_STATE(23)] = 872,
  [SMALL_STATE(24)] = 973,
  [SMALL_STATE(25)] = 1074,
  [SMALL_STATE(26)] = 1175,
  [SMALL_STATE(27)] = 1276,
  [SMALL_STATE(28)] = 1377,
  [SMALL_STATE(29)] = 1478,
  [SMALL_STATE(30)] = 1579,
  [SMALL_STATE(31)] = 1680,
  [SMALL_STATE(32)] = 1781,
  [SMALL_STATE(33)] = 1882,
  [SMALL_STATE(34)] = 1983,
  [SMALL_STATE(35)] = 2084,
  [SMALL_STATE(36)] = 2185,
  [SMALL_STATE(37)] = 2286,
  [SMALL_STATE(38)] = 2355,
  [SMALL_STATE(39)] = 2456,
  [SMALL_STATE(40)] = 2557,
  [SMALL_STATE(41)] = 2658,
  [SMALL_STATE(42)] = 2759,
  [SMALL_STATE(43)] = 2860,
  [SMALL_STATE(44)] = 2961,
  [SMALL_STATE(45)] = 3032,
  [SMALL_STATE(46)] = 3098,
  [SMALL_STATE(47)] = 3178,
  [SMALL_STATE(48)] = 3248,
  [SMALL_STATE(49)] = 3320,
  [SMALL_STATE(50)] = 3386,
  [SMALL_STATE(51)] = 3458,
  [SMALL_STATE(52)] = 3538,
  [SMALL_STATE(53)] = 3618,
  [SMALL_STATE(54)] = 3684,
  [SMALL_STATE(55)] = 3756,
  [SMALL_STATE(56)] = 3822,
  [SMALL_STATE(57)] = 3888,
  [SMALL_STATE(58)] = 3968,
  [SMALL_STATE(59)] = 4038,
  [SMALL_STATE(60)] = 4118,
  [SMALL_STATE(61)] = 4197,
  [SMALL_STATE(62)] = 4262,
  [SMALL_STATE(63)] = 4323,
  [SMALL_STATE(64)] = 4418,
  [SMALL_STATE(65)] = 4479,
  [SMALL_STATE(66)] = 4574,
  [SMALL_STATE(67)] = 4635,
  [SMALL_STATE(68)] = 4696,
  [SMALL_STATE(69)] = 4791,
  [SMALL_STATE(70)] = 4862,
  [SMALL_STATE(71)] = 4959,
  [SMALL_STATE(72)] = 5056,
  [SMALL_STATE(73)] = 5117,
  [SMALL_STATE(74)] = 5178,
  [SMALL_STATE(75)] = 5273,
  [SMALL_STATE(76)] = 5334,
  [SMALL_STATE(77)] = 5429,
  [SMALL_STATE(78)] = 5508,
  [SMALL_STATE(79)] = 5569,
  [SMALL_STATE(80)] = 5630,
  [SMALL_STATE(81)] = 5691,
  [SMALL_STATE(82)] = 5752,
  [SMALL_STATE(83)] = 5813,
  [SMALL_STATE(84)] = 5908,
  [SMALL_STATE(85)] = 6003,
  [SMALL_STATE(86)] = 6064,
  [SMALL_STATE(87)] = 6161,
  [SMALL_STATE(88)] = 6256,
  [SMALL_STATE(89)] = 6319,
  [SMALL_STATE(90)] = 6416,
  [SMALL_STATE(91)] = 6511,
  [SMALL_STATE(92)] = 6572,
  [SMALL_STATE(93)] = 6667,
  [SMALL_STATE(94)] = 6732,
  [SMALL_STATE(95)] = 6811,
  [SMALL_STATE(96)] = 6872,
  [SMALL_STATE(97)] = 6967,
  [SMALL_STATE(98)] = 7028,
  [SMALL_STATE(99)] = 7089,
  [SMALL_STATE(100)] = 7150,
  [SMALL_STATE(101)] = 7211,
  [SMALL_STATE(102)] = 7308,
  [SMALL_STATE(103)] = 7369,
  [SMALL_STATE(104)] = 7448,
  [SMALL_STATE(105)] = 7509,
  [SMALL_STATE(106)] = 7580,
  [SMALL_STATE(107)] = 7645,
  [SMALL_STATE(108)] = 7706,
  [SMALL_STATE(109)] = 7777,
  [SMALL_STATE(110)] = 7842,
  [SMALL_STATE(111)] = 7903,
  [SMALL_STATE(112)] = 7998,
  [SMALL_STATE(113)] = 8095,
  [SMALL_STATE(114)] = 8156,
  [SMALL_STATE(115)] = 8217,
  [SMALL_STATE(116)] = 8312,
  [SMALL_STATE(117)] = 8373,
  [SMALL_STATE(118)] = 8434,
  [SMALL_STATE(119)] = 8495,
  [SMALL_STATE(120)] = 8556,
  [SMALL_STATE(121)] = 8617,
  [SMALL_STATE(122)] = 8678,
  [SMALL_STATE(123)] = 8775,
  [SMALL_STATE(124)] = 8870,
  [SMALL_STATE(125)] = 8933,
  [SMALL_STATE(126)] = 9012,
  [SMALL_STATE(127)] = 9077,
  [SMALL_STATE(128)] = 9137,
  [SMALL_STATE(129)] = 9197,
  [SMALL_STATE(130)] = 9257,
  [SMALL_STATE(131)] = 9325,
  [SMALL_STATE(132)] = 9385,
  [SMALL_STATE(133)] = 9453,
  [SMALL_STATE(134)] = 9513,
  [SMALL_STATE(135)] = 9573,
  [SMALL_STATE(136)] = 9641,
  [SMALL_STATE(137)] = 9701,
  [SMALL_STATE(138)] = 9769,
  [SMALL_STATE(139)] = 9829,
  [SMALL_STATE(140)] = 9889,
  [SMALL_STATE(141)] = 9949,
  [SMALL_STATE(142)] = 10011,
  [SMALL_STATE(143)] = 10071,
  [SMALL_STATE(144)] = 10131,
  [SMALL_STATE(145)] = 10191,
  [SMALL_STATE(146)] = 10251,
  [SMALL_STATE(147)] = 10311,
  [SMALL_STATE(148)] = 10371,
  [SMALL_STATE(149)] = 10431,
  [SMALL_STATE(150)] = 10491,
  [SMALL_STATE(151)] = 10551,
  [SMALL_STATE(152)] = 10611,
  [SMALL_STATE(153)] = 10671,
  [SMALL_STATE(154)] = 10731,
  [SMALL_STATE(155)] = 10791,
  [SMALL_STATE(156)] = 10859,
  [SMALL_STATE(157)] = 10919,
  [SMALL_STATE(158)] = 10979,
  [SMALL_STATE(159)] = 11039,
  [SMALL_STATE(160)] = 11106,
  [SMALL_STATE(161)] = 11173,
  [SMALL_STATE(162)] = 11240,
  [SMALL_STATE(163)] = 11307,
  [SMALL_STATE(164)] = 11374,
  [SMALL_STATE(165)] = 11440,
  [SMALL_STATE(166)] = 11506,
  [SMALL_STATE(167)] = 11581,
  [SMALL_STATE(168)] = 11646,
  [SMALL_STATE(169)] = 11721,
  [SMALL_STATE(170)] = 11796,
  [SMALL_STATE(171)] = 11857,
  [SMALL_STATE(172)] = 11932,
  [SMALL_STATE(173)] = 11993,
  [SMALL_STATE(174)] = 12054,
  [SMALL_STATE(175)] = 12121,
  [SMALL_STATE(176)] = 12186,
  [SMALL_STATE(177)] = 12261,
  [SMALL_STATE(178)] = 12322,
  [SMALL_STATE(179)] = 12389,
  [SMALL_STATE(180)] = 12450,
  [SMALL_STATE(181)] = 12517,
  [SMALL_STATE(182)] = 12593,
  [SMALL_STATE(183)] = 12649,
  [SMALL_STATE(184)] = 12709,
  [SMALL_STATE(185)] = 12765,
  [SMALL_STATE(186)] = 12821,
  [SMALL_STATE(187)] = 12877,
  [SMALL_STATE(188)] = 12933,
  [SMALL_STATE(189)] = 12989,
  [SMALL_STATE(190)] = 13045,
  [SMALL_STATE(191)] = 13101,
  [SMALL_STATE(192)] = 13167,
  [SMALL_STATE(193)] = 13223,
  [SMALL_STATE(194)] = 13279,
  [SMALL_STATE(195)] = 13335,
  [SMALL_STATE(196)] = 13395,
  [SMALL_STATE(197)] = 13461,
  [SMALL_STATE(198)] = 13535,
  [SMALL_STATE(199)] = 13591,
  [SMALL_STATE(200)] = 13649,
  [SMALL_STATE(201)] = 13705,
  [SMALL_STATE(202)] = 13761,
  [SMALL_STATE(203)] = 13817,
  [SMALL_STATE(204)] = 13873,
  [SMALL_STATE(205)] = 13929,
  [SMALL_STATE(206)] = 13985,
  [SMALL_STATE(207)] = 14045,
  [SMALL_STATE(208)] = 14101,
  [SMALL_STATE(209)] = 14157,
  [SMALL_STATE(210)] = 14213,
  [SMALL_STATE(211)] = 14269,
  [SMALL_STATE(212)] = 14325,
  [SMALL_STATE(213)] = 14381,
  [SMALL_STATE(214)] = 14455,
  [SMALL_STATE(215)] = 14511,
  [SMALL_STATE(216)] = 14585,
  [SMALL_STATE(217)] = 14641,
  [SMALL_STATE(218)] = 14715,
  [SMALL_STATE(219)] = 14789,
  [SMALL_STATE(220)] = 14855,
  [SMALL_STATE(221)] = 14915,
  [SMALL_STATE(222)] = 14971,
  [SMALL_STATE(223)] = 15027,
  [SMALL_STATE(224)] = 15085,
  [SMALL_STATE(225)] = 15145,
  [SMALL_STATE(226)] = 15201,
  [SMALL_STATE(227)] = 15257,
  [SMALL_STATE(228)] = 15312,
  [SMALL_STATE(229)] = 15367,
  [SMALL_STATE(230)] = 15422,
  [SMALL_STATE(231)] = 15477,
  [SMALL_STATE(232)] = 15532,
  [SMALL_STATE(233)] = 15587,
  [SMALL_STATE(234)] = 15642,
  [SMALL_STATE(235)] = 15697,
  [SMALL_STATE(236)] = 15754,
  [SMALL_STATE(237)] = 15809,
  [SMALL_STATE(238)] = 15864,
  [SMALL_STATE(239)] = 15919,
  [SMALL_STATE(240)] = 15974,
  [SMALL_STATE(241)] = 16029,
  [SMALL_STATE(242)] = 16084,
  [SMALL_STATE(243)] = 16139,
  [SMALL_STATE(244)] = 16194,
  [SMALL_STATE(245)] = 16249,
  [SMALL_STATE(246)] = 16304,
  [SMALL_STATE(247)] = 16359,
  [SMALL_STATE(248)] = 16414,
  [SMALL_STATE(249)] = 16469,
  [SMALL_STATE(250)] = 16524,
  [SMALL_STATE(251)] = 16579,
  [SMALL_STATE(252)] = 16634,
  [SMALL_STATE(253)] = 16689,
  [SMALL_STATE(254)] = 16744,
  [SMALL_STATE(255)] = 16799,
  [SMALL_STATE(256)] = 16854,
  [SMALL_STATE(257)] = 16909,
  [SMALL_STATE(258)] = 16966,
  [SMALL_STATE(259)] = 17023,
  [SMALL_STATE(260)] = 17080,
  [SMALL_STATE(261)] = 17137,
  [SMALL_STATE(262)] = 17194,
  [SMALL_STATE(263)] = 17249,
  [SMALL_STATE(264)] = 17304,
  [SMALL_STATE(265)] = 17350,
  [SMALL_STATE(266)] = 17396,
  [SMALL_STATE(267)] = 17442,
  [SMALL_STATE(268)] = 17492,
  [SMALL_STATE(269)] = 17538,
  [SMALL_STATE(270)] = 17584,
  [SMALL_STATE(271)] = 17640,
  [SMALL_STATE(272)] = 17690,
  [SMALL_STATE(273)] = 17746,
  [SMALL_STATE(274)] = 17792,
  [SMALL_STATE(275)] = 17838,
  [SMALL_STATE(276)] = 17888,
  [SMALL_STATE(277)] = 17938,
  [SMALL_STATE(278)] = 17984,
  [SMALL_STATE(279)] = 18030,
  [SMALL_STATE(280)] = 18076,
  [SMALL_STATE(281)] = 18122,
  [SMALL_STATE(282)] = 18168,
  [SMALL_STATE(283)] = 18214,
  [SMALL_STATE(284)] = 18262,
  [SMALL_STATE(285)] = 18326,
  [SMALL_STATE(286)] = 18390,
  [SMALL_STATE(287)] = 18454,
  [SMALL_STATE(288)] = 18500,
  [SMALL_STATE(289)] = 18546,
  [SMALL_STATE(290)] = 18610,
  [SMALL_STATE(291)] = 18666,
  [SMALL_STATE(292)] = 18712,
  [SMALL_STATE(293)] = 18758,
  [SMALL_STATE(294)] = 18824,
  [SMALL_STATE(295)] = 18870,
  [SMALL_STATE(296)] = 18916,
  [SMALL_STATE(297)] = 18962,
  [SMALL_STATE(298)] = 19026,
  [SMALL_STATE(299)] = 19076,
  [SMALL_STATE(300)] = 19122,
  [SMALL_STATE(301)] = 19168,
  [SMALL_STATE(302)] = 19214,
  [SMALL_STATE(303)] = 19260,
  [SMALL_STATE(304)] = 19306,
  [SMALL_STATE(305)] = 19352,
  [SMALL_STATE(306)] = 19397,
  [SMALL_STATE(307)] = 19442,
  [SMALL_STATE(308)] = 19487,
  [SMALL_STATE(309)] = 19532,
  [SMALL_STATE(310)] = 19577,
  [SMALL_STATE(311)] = 19624,
  [SMALL_STATE(312)] = 19669,
  [SMALL_STATE(313)] = 19714,
  [SMALL_STATE(314)] = 19759,
  [SMALL_STATE(315)] = 19804,
  [SMALL_STATE(316)] = 19849,
  [SMALL_STATE(317)] = 19894,
  [SMALL_STATE(318)] = 19939,
  [SMALL_STATE(319)] = 19984,
  [SMALL_STATE(320)] = 20029,
  [SMALL_STATE(321)] = 20074,
  [SMALL_STATE(322)] = 20119,
  [SMALL_STATE(323)] = 20164,
  [SMALL_STATE(324)] = 20209,
  [SMALL_STATE(325)] = 20254,
  [SMALL_STATE(326)] = 20299,
  [SMALL_STATE(327)] = 20344,
  [SMALL_STATE(328)] = 20389,
  [SMALL_STATE(329)] = 20434,
  [SMALL_STATE(330)] = 20479,
  [SMALL_STATE(331)] = 20524,
  [SMALL_STATE(332)] = 20569,
  [SMALL_STATE(333)] = 20614,
  [SMALL_STATE(334)] = 20659,
  [SMALL_STATE(335)] = 20704,
  [SMALL_STATE(336)] = 20749,
  [SMALL_STATE(337)] = 20796,
  [SMALL_STATE(338)] = 20841,
  [SMALL_STATE(339)] = 20886,
  [SMALL_STATE(340)] = 20931,
  [SMALL_STATE(341)] = 20976,
  [SMALL_STATE(342)] = 21021,
  [SMALL_STATE(343)] = 21066,
  [SMALL_STATE(344)] = 21111,
  [SMALL_STATE(345)] = 21156,
  [SMALL_STATE(346)] = 21201,
  [SMALL_STATE(347)] = 21246,
  [SMALL_STATE(348)] = 21291,
  [SMALL_STATE(349)] = 21336,
  [SMALL_STATE(350)] = 21381,
  [SMALL_STATE(351)] = 21426,
  [SMALL_STATE(352)] = 21471,
  [SMALL_STATE(353)] = 21515,
  [SMALL_STATE(354)] = 21580,
  [SMALL_STATE(355)] = 21645,
  [SMALL_STATE(356)] = 21710,
  [SMALL_STATE(357)] = 21775,
  [SMALL_STATE(358)] = 21840,
  [SMALL_STATE(359)] = 21905,
  [SMALL_STATE(360)] = 21970,
  [SMALL_STATE(361)] = 22035,
  [SMALL_STATE(362)] = 22100,
  [SMALL_STATE(363)] = 22165,
  [SMALL_STATE(364)] = 22230,
  [SMALL_STATE(365)] = 22295,
  [SMALL_STATE(366)] = 22360,
  [SMALL_STATE(367)] = 22425,
  [SMALL_STATE(368)] = 22490,
  [SMALL_STATE(369)] = 22555,
  [SMALL_STATE(370)] = 22620,
  [SMALL_STATE(371)] = 22685,
  [SMALL_STATE(372)] = 22750,
  [SMALL_STATE(373)] = 22815,
  [SMALL_STATE(374)] = 22880,
  [SMALL_STATE(375)] = 22945,
  [SMALL_STATE(376)] = 23010,
  [SMALL_STATE(377)] = 23051,
  [SMALL_STATE(378)] = 23092,
  [SMALL_STATE(379)] = 23151,
  [SMALL_STATE(380)] = 23210,
  [SMALL_STATE(381)] = 23269,
  [SMALL_STATE(382)] = 23328,
  [SMALL_STATE(383)] = 23387,
  [SMALL_STATE(384)] = 23446,
  [SMALL_STATE(385)] = 23505,
  [SMALL_STATE(386)] = 23564,
  [SMALL_STATE(387)] = 23623,
  [SMALL_STATE(388)] = 23682,
  [SMALL_STATE(389)] = 23741,
  [SMALL_STATE(390)] = 23800,
  [SMALL_STATE(391)] = 23859,
  [SMALL_STATE(392)] = 23918,
  [SMALL_STATE(393)] = 23977,
  [SMALL_STATE(394)] = 24036,
  [SMALL_STATE(395)] = 24095,
  [SMALL_STATE(396)] = 24154,
  [SMALL_STATE(397)] = 24213,
  [SMALL_STATE(398)] = 24272,
  [SMALL_STATE(399)] = 24331,
  [SMALL_STATE(400)] = 24390,
  [SMALL_STATE(401)] = 24449,
  [SMALL_STATE(402)] = 24508,
  [SMALL_STATE(403)] = 24567,
  [SMALL_STATE(404)] = 24626,
  [SMALL_STATE(405)] = 24685,
  [SMALL_STATE(406)] = 24744,
  [SMALL_STATE(407)] = 24785,
  [SMALL_STATE(408)] = 24826,
  [SMALL_STATE(409)] = 24867,
  [SMALL_STATE(410)] = 24908,
  [SMALL_STATE(411)] = 24951,
  [SMALL_STATE(412)] = 24992,
  [SMALL_STATE(413)] = 25033,
  [SMALL_STATE(414)] = 25074,
  [SMALL_STATE(415)] = 25133,
  [SMALL_STATE(416)] = 25174,
  [SMALL_STATE(417)] = 25215,
  [SMALL_STATE(418)] = 25256,
  [SMALL_STATE(419)] = 25297,
  [SMALL_STATE(420)] = 25353,
  [SMALL_STATE(421)] = 25393,
  [SMALL_STATE(422)] = 25449,
  [SMALL_STATE(423)] = 25505,
  [SMALL_STATE(424)] = 25561,
  [SMALL_STATE(425)] = 25617,
  [SMALL_STATE(426)] = 25657,
  [SMALL_STATE(427)] = 25713,
  [SMALL_STATE(428)] = 25753,
  [SMALL_STATE(429)] = 25809,
  [SMALL_STATE(430)] = 25865,
  [SMALL_STATE(431)] = 25905,
  [SMALL_STATE(432)] = 25945,
  [SMALL_STATE(433)] = 25985,
  [SMALL_STATE(434)] = 26041,
  [SMALL_STATE(435)] = 26097,
  [SMALL_STATE(436)] = 26153,
  [SMALL_STATE(437)] = 26209,
  [SMALL_STATE(438)] = 26265,
  [SMALL_STATE(439)] = 26321,
  [SMALL_STATE(440)] = 26361,
  [SMALL_STATE(441)] = 26417,
  [SMALL_STATE(442)] = 26473,
  [SMALL_STATE(443)] = 26529,
  [SMALL_STATE(444)] = 26585,
  [SMALL_STATE(445)] = 26641,
  [SMALL_STATE(446)] = 26697,
  [SMALL_STATE(447)] = 26753,
  [SMALL_STATE(448)] = 26809,
  [SMALL_STATE(449)] = 26865,
  [SMALL_STATE(450)] = 26921,
  [SMALL_STATE(451)] = 26977,
  [SMALL_STATE(452)] = 27033,
  [SMALL_STATE(453)] = 27073,
  [SMALL_STATE(454)] = 27129,
  [SMALL_STATE(455)] = 27185,
  [SMALL_STATE(456)] = 27241,
  [SMALL_STATE(457)] = 27297,
  [SMALL_STATE(458)] = 27353,
  [SMALL_STATE(459)] = 27409,
  [SMALL_STATE(460)] = 27465,
  [SMALL_STATE(461)] = 27521,
  [SMALL_STATE(462)] = 27577,
  [SMALL_STATE(463)] = 27633,
  [SMALL_STATE(464)] = 27689,
  [SMALL_STATE(465)] = 27745,
  [SMALL_STATE(466)] = 27785,
  [SMALL_STATE(467)] = 27825,
  [SMALL_STATE(468)] = 27881,
  [SMALL_STATE(469)] = 27937,
  [SMALL_STATE(470)] = 27993,
  [SMALL_STATE(471)] = 28049,
  [SMALL_STATE(472)] = 28105,
  [SMALL_STATE(473)] = 28145,
  [SMALL_STATE(474)] = 28201,
  [SMALL_STATE(475)] = 28257,
  [SMALL_STATE(476)] = 28313,
  [SMALL_STATE(477)] = 28353,
  [SMALL_STATE(478)] = 28395,
  [SMALL_STATE(479)] = 28451,
  [SMALL_STATE(480)] = 28507,
  [SMALL_STATE(481)] = 28563,
  [SMALL_STATE(482)] = 28619,
  [SMALL_STATE(483)] = 28675,
  [SMALL_STATE(484)] = 28731,
  [SMALL_STATE(485)] = 28787,
  [SMALL_STATE(486)] = 28843,
  [SMALL_STATE(487)] = 28899,
  [SMALL_STATE(488)] = 28955,
  [SMALL_STATE(489)] = 29011,
  [SMALL_STATE(490)] = 29067,
  [SMALL_STATE(491)] = 29123,
  [SMALL_STATE(492)] = 29179,
  [SMALL_STATE(493)] = 29235,
  [SMALL_STATE(494)] = 29291,
  [SMALL_STATE(495)] = 29347,
  [SMALL_STATE(496)] = 29403,
  [SMALL_STATE(497)] = 29459,
  [SMALL_STATE(498)] = 29515,
  [SMALL_STATE(499)] = 29571,
  [SMALL_STATE(500)] = 29627,
  [SMALL_STATE(501)] = 29683,
  [SMALL_STATE(502)] = 29739,
  [SMALL_STATE(503)] = 29795,
  [SMALL_STATE(504)] = 29851,
  [SMALL_STATE(505)] = 29907,
  [SMALL_STATE(506)] = 29963,
  [SMALL_STATE(507)] = 30019,
  [SMALL_STATE(508)] = 30075,
  [SMALL_STATE(509)] = 30131,
  [SMALL_STATE(510)] = 30187,
  [SMALL_STATE(511)] = 30243,
  [SMALL_STATE(512)] = 30299,
  [SMALL_STATE(513)] = 30355,
  [SMALL_STATE(514)] = 30411,
  [SMALL_STATE(515)] = 30467,
  [SMALL_STATE(516)] = 30523,
  [SMALL_STATE(517)] = 30579,
  [SMALL_STATE(518)] = 30635,
  [SMALL_STATE(519)] = 30691,
  [SMALL_STATE(520)] = 30747,
  [SMALL_STATE(521)] = 30803,
  [SMALL_STATE(522)] = 30859,
  [SMALL_STATE(523)] = 30915,
  [SMALL_STATE(524)] = 30971,
  [SMALL_STATE(525)] = 31027,
  [SMALL_STATE(526)] = 31083,
  [SMALL_STATE(527)] = 31139,
  [SMALL_STATE(528)] = 31195,
  [SMALL_STATE(529)] = 31251,
  [SMALL_STATE(530)] = 31307,
  [SMALL_STATE(531)] = 31363,
  [SMALL_STATE(532)] = 31419,
  [SMALL_STATE(533)] = 31475,
  [SMALL_STATE(534)] = 31531,
  [SMALL_STATE(535)] = 31587,
  [SMALL_STATE(536)] = 31643,
  [SMALL_STATE(537)] = 31699,
  [SMALL_STATE(538)] = 31755,
  [SMALL_STATE(539)] = 31811,
  [SMALL_STATE(540)] = 31851,
  [SMALL_STATE(541)] = 31907,
  [SMALL_STATE(542)] = 31963,
  [SMALL_STATE(543)] = 32019,
  [SMALL_STATE(544)] = 32075,
  [SMALL_STATE(545)] = 32131,
  [SMALL_STATE(546)] = 32187,
  [SMALL_STATE(547)] = 32243,
  [SMALL_STATE(548)] = 32299,
  [SMALL_STATE(549)] = 32355,
  [SMALL_STATE(550)] = 32411,
  [SMALL_STATE(551)] = 32467,
  [SMALL_STATE(552)] = 32523,
  [SMALL_STATE(553)] = 32579,
  [SMALL_STATE(554)] = 32635,
  [SMALL_STATE(555)] = 32691,
  [SMALL_STATE(556)] = 32747,
  [SMALL_STATE(557)] = 32803,
  [SMALL_STATE(558)] = 32859,
  [SMALL_STATE(559)] = 32915,
  [SMALL_STATE(560)] = 32971,
  [SMALL_STATE(561)] = 33027,
  [SMALL_STATE(562)] = 33083,
  [SMALL_STATE(563)] = 33139,
  [SMALL_STATE(564)] = 33195,
  [SMALL_STATE(565)] = 33251,
  [SMALL_STATE(566)] = 33307,
  [SMALL_STATE(567)] = 33363,
  [SMALL_STATE(568)] = 33419,
  [SMALL_STATE(569)] = 33475,
  [SMALL_STATE(570)] = 33531,
  [SMALL_STATE(571)] = 33587,
  [SMALL_STATE(572)] = 33643,
  [SMALL_STATE(573)] = 33699,
  [SMALL_STATE(574)] = 33755,
  [SMALL_STATE(575)] = 33811,
  [SMALL_STATE(576)] = 33867,
  [SMALL_STATE(577)] = 33923,
  [SMALL_STATE(578)] = 33979,
  [SMALL_STATE(579)] = 34035,
  [SMALL_STATE(580)] = 34091,
  [SMALL_STATE(581)] = 34147,
  [SMALL_STATE(582)] = 34203,
  [SMALL_STATE(583)] = 34259,
  [SMALL_STATE(584)] = 34315,
  [SMALL_STATE(585)] = 34371,
  [SMALL_STATE(586)] = 34416,
  [SMALL_STATE(587)] = 34461,
  [SMALL_STATE(588)] = 34506,
  [SMALL_STATE(589)] = 34551,
  [SMALL_STATE(590)] = 34596,
  [SMALL_STATE(591)] = 34640,
  [SMALL_STATE(592)] = 34684,
  [SMALL_STATE(593)] = 34728,
  [SMALL_STATE(594)] = 34772,
  [SMALL_STATE(595)] = 34816,
  [SMALL_STATE(596)] = 34860,
  [SMALL_STATE(597)] = 34903,
  [SMALL_STATE(598)] = 34946,
  [SMALL_STATE(599)] = 34989,
  [SMALL_STATE(600)] = 35032,
  [SMALL_STATE(601)] = 35075,
  [SMALL_STATE(602)] = 35118,
  [SMALL_STATE(603)] = 35168,
  [SMALL_STATE(604)] = 35218,
  [SMALL_STATE(605)] = 35256,
  [SMALL_STATE(606)] = 35306,
  [SMALL_STATE(607)] = 35344,
  [SMALL_STATE(608)] = 35382,
  [SMALL_STATE(609)] = 35426,
  [SMALL_STATE(610)] = 35464,
  [SMALL_STATE(611)] = 35502,
  [SMALL_STATE(612)] = 35546,
  [SMALL_STATE(613)] = 35582,
  [SMALL_STATE(614)] = 35626,
  [SMALL_STATE(615)] = 35661,
  [SMALL_STATE(616)] = 35710,
  [SMALL_STATE(617)] = 35743,
  [SMALL_STATE(618)] = 35776,
  [SMALL_STATE(619)] = 35809,
  [SMALL_STATE(620)] = 35842,
  [SMALL_STATE(621)] = 35875,
  [SMALL_STATE(622)] = 35908,
  [SMALL_STATE(623)] = 35941,
  [SMALL_STATE(624)] = 35990,
  [SMALL_STATE(625)] = 36023,
  [SMALL_STATE(626)] = 36056,
  [SMALL_STATE(627)] = 36089,
  [SMALL_STATE(628)] = 36122,
  [SMALL_STATE(629)] = 36155,
  [SMALL_STATE(630)] = 36206,
  [SMALL_STATE(631)] = 36239,
  [SMALL_STATE(632)] = 36272,
  [SMALL_STATE(633)] = 36305,
  [SMALL_STATE(634)] = 36340,
  [SMALL_STATE(635)] = 36373,
  [SMALL_STATE(636)] = 36406,
  [SMALL_STATE(637)] = 36439,
  [SMALL_STATE(638)] = 36472,
  [SMALL_STATE(639)] = 36505,
  [SMALL_STATE(640)] = 36538,
  [SMALL_STATE(641)] = 36571,
  [SMALL_STATE(642)] = 36604,
  [SMALL_STATE(643)] = 36637,
  [SMALL_STATE(644)] = 36672,
  [SMALL_STATE(645)] = 36715,
  [SMALL_STATE(646)] = 36758,
  [SMALL_STATE(647)] = 36791,
  [SMALL_STATE(648)] = 36824,
  [SMALL_STATE(649)] = 36867,
  [SMALL_STATE(650)] = 36900,
  [SMALL_STATE(651)] = 36933,
  [SMALL_STATE(652)] = 36966,
  [SMALL_STATE(653)] = 36999,
  [SMALL_STATE(654)] = 37048,
  [SMALL_STATE(655)] = 37081,
  [SMALL_STATE(656)] = 37123,
  [SMALL_STATE(657)] = 37157,
  [SMALL_STATE(658)] = 37199,
  [SMALL_STATE(659)] = 37241,
  [SMALL_STATE(660)] = 37280,
  [SMALL_STATE(661)] = 37310,
  [SMALL_STATE(662)] = 37340,
  [SMALL_STATE(663)] = 37370,
  [SMALL_STATE(664)] = 37408,
  [SMALL_STATE(665)] = 37438,
  [SMALL_STATE(666)] = 37468,
  [SMALL_STATE(667)] = 37498,
  [SMALL_STATE(668)] = 37528,
  [SMALL_STATE(669)] = 37558,
  [SMALL_STATE(670)] = 37588,
  [SMALL_STATE(671)] = 37618,
  [SMALL_STATE(672)] = 37648,
  [SMALL_STATE(673)] = 37686,
  [SMALL_STATE(674)] = 37716,
  [SMALL_STATE(675)] = 37748,
  [SMALL_STATE(676)] = 37778,
  [SMALL_STATE(677)] = 37816,
  [SMALL_STATE(678)] = 37846,
  [SMALL_STATE(679)] = 37884,
  [SMALL_STATE(680)] = 37922,
  [SMALL_STATE(681)] = 37960,
  [SMALL_STATE(682)] = 38009,
  [SMALL_STATE(683)] = 38058,
  [SMALL_STATE(684)] = 38107,
  [SMALL_STATE(685)] = 38156,
  [SMALL_STATE(686)] = 38205,
  [SMALL_STATE(687)] = 38254,
  [SMALL_STATE(688)] = 38303,
  [SMALL_STATE(689)] = 38352,
  [SMALL_STATE(690)] = 38401,
  [SMALL_STATE(691)] = 38450,
  [SMALL_STATE(692)] = 38499,
  [SMALL_STATE(693)] = 38548,
  [SMALL_STATE(694)] = 38597,
  [SMALL_STATE(695)] = 38646,
  [SMALL_STATE(696)] = 38695,
  [SMALL_STATE(697)] = 38744,
  [SMALL_STATE(698)] = 38793,
  [SMALL_STATE(699)] = 38842,
  [SMALL_STATE(700)] = 38891,
  [SMALL_STATE(701)] = 38940,
  [SMALL_STATE(702)] = 38989,
  [SMALL_STATE(703)] = 39038,
  [SMALL_STATE(704)] = 39087,
  [SMALL_STATE(705)] = 39136,
  [SMALL_STATE(706)] = 39185,
  [SMALL_STATE(707)] = 39234,
  [SMALL_STATE(708)] = 39283,
  [SMALL_STATE(709)] = 39328,
  [SMALL_STATE(710)] = 39357,
  [SMALL_STATE(711)] = 39406,
  [SMALL_STATE(712)] = 39455,
  [SMALL_STATE(713)] = 39504,
  [SMALL_STATE(714)] = 39553,
  [SMALL_STATE(715)] = 39602,
  [SMALL_STATE(716)] = 39651,
  [SMALL_STATE(717)] = 39700,
  [SMALL_STATE(718)] = 39749,
  [SMALL_STATE(719)] = 39798,
  [SMALL_STATE(720)] = 39847,
  [SMALL_STATE(721)] = 39896,
  [SMALL_STATE(722)] = 39945,
  [SMALL_STATE(723)] = 39994,
  [SMALL_STATE(724)] = 40043,
  [SMALL_STATE(725)] = 40092,
  [SMALL_STATE(726)] = 40141,
  [SMALL_STATE(727)] = 40190,
  [SMALL_STATE(728)] = 40239,
  [SMALL_STATE(729)] = 40288,
  [SMALL_STATE(730)] = 40337,
  [SMALL_STATE(731)] = 40386,
  [SMALL_STATE(732)] = 40435,
  [SMALL_STATE(733)] = 40484,
  [SMALL_STATE(734)] = 40533,
  [SMALL_STATE(735)] = 40582,
  [SMALL_STATE(736)] = 40631,
  [SMALL_STATE(737)] = 40680,
  [SMALL_STATE(738)] = 40729,
  [SMALL_STATE(739)] = 40778,
  [SMALL_STATE(740)] = 40827,
  [SMALL_STATE(741)] = 40872,
  [SMALL_STATE(742)] = 40917,
  [SMALL_STATE(743)] = 40966,
  [SMALL_STATE(744)] = 41012,
  [SMALL_STATE(745)] = 41056,
  [SMALL_STATE(746)] = 41100,
  [SMALL_STATE(747)] = 41144,
  [SMALL_STATE(748)] = 41188,
  [SMALL_STATE(749)] = 41232,
  [SMALL_STATE(750)] = 41278,
  [SMALL_STATE(751)] = 41322,
  [SMALL_STATE(752)] = 41365,
  [SMALL_STATE(753)] = 41408,
  [SMALL_STATE(754)] = 41451,
  [SMALL_STATE(755)] = 41494,
  [SMALL_STA