{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Gtk.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "C-docs-url Gtk https://docs.gtk.org/gtk4"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (out caller-allocates), but it is just a pointer to a GValue."
 , "set-attr Gtk/TreeModelFilterModifyFunc/@parameters/value direction in"
 , "set-attr Gtk/TreeModelFilterModifyFunc/@parameters/value caller-allocates 0"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (inout transfer=full), but it is just a pointer to a GtkTreeIter."
 , "set-attr Gtk/TreeStore/remove/@parameters/iter direction in"
 , "set-attr Gtk/TreeStore/remove/@parameters/iter transfer-ownership none"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (inout transfer=full), but it is just a pointer to a GtkTreeIter."
 , "set-attr Gtk/TreeModel/iter_next/@parameters/iter direction in"
 , "set-attr Gtk/TreeModel/iter_next/@parameters/iter transfer-ownership none"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (inout transfer=full), but it is just a pointer to a GtkTreeIter."
 , "set-attr Gtk/TreeModel/iter_previous/@parameters/iter direction in"
 , "set-attr Gtk/TreeModel/iter_previous/@parameters/iter transfer-ownership none"
 , ""
 , "# The introspection annotation marks the parameters as"
 , "# (out caller-allocates), but it is just a pointer to a GtkTreeIter."
 , "set-attr Gtk/TreeModel/iter_nth_child/@parameters/iter direction in"
 , "set-attr Gtk/TreeModel/iter_nth_child/@parameters/iter caller-allocates 0"
 , ""
 , "# It is useful to expose these class structs when deriving new types"
 , "set-attr Gtk/WidgetClass haskell-gi-force-visible 1"
 , "set-attr Gtk/ContainerClass haskell-gi-force-visible 1"
 , ""
 , "# The returned value is nullable, but it is not marked as such in the"
 , "# introspection data."
 , "set-attr Gtk/PrintOperation/get_default_page_setup/@return-value nullable 1"]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Gtk.Config"
 , "GI.Gtk"
 , "GI.Gtk.Callbacks"
 , "GI.Gtk.Constants"
 , "GI.Gtk.Enums"
 , "GI.Gtk.Flags"
 , "GI.Gtk.Functions"
 , "GI.Gtk.Interfaces"
 , "GI.Gtk.Interfaces.Accessible"
 , "GI.Gtk.Interfaces.AccessibleRange"
 , "GI.Gtk.Interfaces.AccessibleText"
 , "GI.Gtk.Interfaces.Actionable"
 , "GI.Gtk.Interfaces.AppChooser"
 , "GI.Gtk.Interfaces.Buildable"
 , "GI.Gtk.Interfaces.BuilderScope"
 , "GI.Gtk.Interfaces.CellEditable"
 , "GI.Gtk.Interfaces.CellLayout"
 , "GI.Gtk.Interfaces.ColorChooser"
 , "GI.Gtk.Interfaces.ConstraintTarget"
 , "GI.Gtk.Interfaces.Editable"
 , "GI.Gtk.Interfaces.FileChooser"
 , "GI.Gtk.Interfaces.FontChooser"
 , "GI.Gtk.Interfaces.Native"
 , "GI.Gtk.Interfaces.Orientable"
 , "GI.Gtk.Interfaces.PrintOperationPreview"
 , "GI.Gtk.Interfaces.Root"
 , "GI.Gtk.Interfaces.Scrollable"
 , "GI.Gtk.Interfaces.SectionModel"
 , "GI.Gtk.Interfaces.SelectionModel"
 , "GI.Gtk.Interfaces.ShortcutManager"
 , "GI.Gtk.Interfaces.StyleProvider"
 , "GI.Gtk.Interfaces.SymbolicPaintable"
 , "GI.Gtk.Interfaces.TreeDragDest"
 , "GI.Gtk.Interfaces.TreeDragSource"
 , "GI.Gtk.Interfaces.TreeModel"
 , "GI.Gtk.Interfaces.TreeSortable"
 , "GI.Gtk.Objects"
 , "GI.Gtk.Objects.ATContext"
 , "GI.Gtk.Objects.AboutDialog"
 , "GI.Gtk.Objects.ActionBar"
 , "GI.Gtk.Objects.ActivateAction"
 , "GI.Gtk.Objects.Adjustment"
 , "GI.Gtk.Objects.AlertDialog"
 , "GI.Gtk.Objects.AlternativeTrigger"
 , "GI.Gtk.Objects.AnyFilter"
 , "GI.Gtk.Objects.AppChooserButton"
 , "GI.Gtk.Objects.AppChooserDialog"
 , "GI.Gtk.Objects.AppChooserWidget"
 , "GI.Gtk.Objects.Application"
 , "GI.Gtk.Objects.ApplicationWindow"
 , "GI.Gtk.Objects.AspectFrame"
 , "GI.Gtk.Objects.Assistant"
 , "GI.Gtk.Objects.AssistantPage"
 , "GI.Gtk.Objects.BinLayout"
 , "GI.Gtk.Objects.BookmarkList"
 , "GI.Gtk.Objects.BoolFilter"
 , "GI.Gtk.Objects.Box"
 , "GI.Gtk.Objects.BoxLayout"
 , "GI.Gtk.Objects.Builder"
 , "GI.Gtk.Objects.BuilderCScope"
 , "GI.Gtk.Objects.BuilderListItemFactory"
 , "GI.Gtk.Objects.Button"
 , "GI.Gtk.Objects.CClosureExpression"
 , "GI.Gtk.Objects.Calendar"
 , "GI.Gtk.Objects.CallbackAction"
 , "GI.Gtk.Objects.CellArea"
 , "GI.Gtk.Objects.CellAreaBox"
 , "GI.Gtk.Objects.CellAreaContext"
 , "GI.Gtk.Objects.CellRenderer"
 , "GI.Gtk.Objects.CellRendererAccel"
 , "GI.Gtk.Objects.CellRendererCombo"
 , "GI.Gtk.Objects.CellRendererPixbuf"
 , "GI.Gtk.Objects.CellRendererProgress"
 , "GI.Gtk.Objects.CellRendererSpin"
 , "GI.Gtk.Objects.CellRendererSpinner"
 , "GI.Gtk.Objects.CellRendererText"
 , "GI.Gtk.Objects.CellRendererToggle"
 , "GI.Gtk.Objects.CellView"
 , "GI.Gtk.Objects.CenterBox"
 , "GI.Gtk.Objects.CenterLayout"
 , "GI.Gtk.Objects.CheckButton"
 , "GI.Gtk.Objects.ClosureExpression"
 , "GI.Gtk.Objects.ColorButton"
 , "GI.Gtk.Objects.ColorChooserDialog"
 , "GI.Gtk.Objects.ColorChooserWidget"
 , "GI.Gtk.Objects.ColorDialog"
 , "GI.Gtk.Objects.ColorDialogButton"
 , "GI.Gtk.Objects.ColumnView"
 , "GI.Gtk.Objects.ColumnViewCell"
 , "GI.Gtk.Objects.ColumnViewColumn"
 , "GI.Gtk.Objects.ColumnViewRow"
 , "GI.Gtk.Objects.ColumnViewSorter"
 , "GI.Gtk.Objects.ComboBox"
 , "GI.Gtk.Objects.ComboBoxText"
 , "GI.Gtk.Objects.ConstantExpression"
 , "GI.Gtk.Objects.Constraint"
 , "GI.Gtk.Objects.ConstraintGuide"
 , "GI.Gtk.Objects.ConstraintLayout"
 , "GI.Gtk.Objects.ConstraintLayoutChild"
 , "GI.Gtk.Objects.CssProvider"
 , "GI.Gtk.Objects.CustomFilter"
 , "GI.Gtk.Objects.CustomLayout"
 , "GI.Gtk.Objects.CustomSorter"
 , "GI.Gtk.Objects.Dialog"
 , "GI.Gtk.Objects.DirectoryList"
 , "GI.Gtk.Objects.DragIcon"
 , "GI.Gtk.Objects.DragSource"
 , "GI.Gtk.Objects.DrawingArea"
 , "GI.Gtk.Objects.DropControllerMotion"
 , "GI.Gtk.Objects.DropDown"
 , "GI.Gtk.Objects.DropTarget"
 , "GI.Gtk.Objects.DropTargetAsync"
 , "GI.Gtk.Objects.EditableLabel"
 , "GI.Gtk.Objects.EmojiChooser"
 , "GI.Gtk.Objects.Entry"
 , "GI.Gtk.Objects.EntryBuffer"
 , "GI.Gtk.Objects.EntryCompletion"
 , "GI.Gtk.Objects.EventController"
 , "GI.Gtk.Objects.EventControllerFocus"
 , "GI.Gtk.Objects.EventControllerKey"
 , "GI.Gtk.Objects.EventControllerLegacy"
 , "GI.Gtk.Objects.EventControllerMotion"
 , "GI.Gtk.Objects.EventControllerScroll"
 , "GI.Gtk.Objects.EveryFilter"
 , "GI.Gtk.Objects.Expander"
 , "GI.Gtk.Objects.Expression"
 , "GI.Gtk.Objects.FileChooserDialog"
 , "GI.Gtk.Objects.FileChooserNative"
 , "GI.Gtk.Objects.FileChooserWidget"
 , "GI.Gtk.Objects.FileDialog"
 , "GI.Gtk.Objects.FileFilter"
 , "GI.Gtk.Objects.FileLauncher"
 , "GI.Gtk.Objects.Filter"
 , "GI.Gtk.Objects.FilterListModel"
 , "GI.Gtk.Objects.Fixed"
 , "GI.Gtk.Objects.FixedLayout"
 , "GI.Gtk.Objects.FixedLayoutChild"
 , "GI.Gtk.Objects.FlattenListModel"
 , "GI.Gtk.Objects.FlowBox"
 , "GI.Gtk.Objects.FlowBoxChild"
 , "GI.Gtk.Objects.FontButton"
 , "GI.Gtk.Objects.FontChooserDialog"
 , "GI.Gtk.Objects.FontChooserWidget"
 , "GI.Gtk.Objects.FontDialog"
 , "GI.Gtk.Objects.FontDialogButton"
 , "GI.Gtk.Objects.Frame"
 , "GI.Gtk.Objects.GLArea"
 , "GI.Gtk.Objects.Gesture"
 , "GI.Gtk.Objects.GestureClick"
 , "GI.Gtk.Objects.GestureDrag"
 , "GI.Gtk.Objects.GestureLongPress"
 , "GI.Gtk.Objects.GesturePan"
 , "GI.Gtk.Objects.GestureRotate"
 , "GI.Gtk.Objects.GestureSingle"
 , "GI.Gtk.Objects.GestureStylus"
 , "GI.Gtk.Objects.GestureSwipe"
 , "GI.Gtk.Objects.GestureZoom"
 , "GI.Gtk.Objects.GraphicsOffload"
 , "GI.Gtk.Objects.Grid"
 , "GI.Gtk.Objects.GridLayout"
 , "GI.Gtk.Objects.GridLayoutChild"
 , "GI.Gtk.Objects.GridView"
 , "GI.Gtk.Objects.HeaderBar"
 , "GI.Gtk.Objects.IMContext"
 , "GI.Gtk.Objects.IMContextSimple"
 , "GI.Gtk.Objects.IMMulticontext"
 , "GI.Gtk.Objects.IconPaintable"
 , "GI.Gtk.Objects.IconTheme"
 , "GI.Gtk.Objects.IconView"
 , "GI.Gtk.Objects.Image"
 , "GI.Gtk.Objects.InfoBar"
 , "GI.Gtk.Objects.Inscription"
 , "GI.Gtk.Objects.KeyvalTrigger"
 , "GI.Gtk.Objects.Label"
 , "GI.Gtk.Objects.LayoutChild"
 , "GI.Gtk.Objects.LayoutManager"
 , "GI.Gtk.Objects.LevelBar"
 , "GI.Gtk.Objects.LinkButton"
 , "GI.Gtk.Objects.ListBase"
 , "GI.Gtk.Objects.ListBox"
 , "GI.Gtk.Objects.ListBoxRow"
 , "GI.Gtk.Objects.ListHeader"
 , "GI.Gtk.Objects.ListItem"
 , "GI.Gtk.Objects.ListItemFactory"
 , "GI.Gtk.Objects.ListStore"
 , "GI.Gtk.Objects.ListView"
 , "GI.Gtk.Objects.LockButton"
 , "GI.Gtk.Objects.MapListModel"
 , "GI.Gtk.Objects.MediaControls"
 , "GI.Gtk.Objects.MediaFile"
 , "GI.Gtk.Objects.MediaStream"
 , "GI.Gtk.Objects.MenuButton"
 , "GI.Gtk.Objects.MessageDialog"
 , "GI.Gtk.Objects.MnemonicAction"
 , "GI.Gtk.Objects.MnemonicTrigger"
 , "GI.Gtk.Objects.MountOperation"
 , "GI.Gtk.Objects.MultiFilter"
 , "GI.Gtk.Objects.MultiSelection"
 , "GI.Gtk.Objects.MultiSorter"
 , "GI.Gtk.Objects.NamedAction"
 , "GI.Gtk.Objects.NativeDialog"
 , "GI.Gtk.Objects.NeverTrigger"
 , "GI.Gtk.Objects.NoSelection"
 , "GI.Gtk.Objects.Notebook"
 , "GI.Gtk.Objects.NotebookPage"
 , "GI.Gtk.Objects.NothingAction"
 , "GI.Gtk.Objects.NumericSorter"
 , "GI.Gtk.Objects.ObjectExpression"
 , "GI.Gtk.Objects.Overlay"
 , "GI.Gtk.Objects.OverlayLayout"
 , "GI.Gtk.Objects.OverlayLayoutChild"
 , "GI.Gtk.Objects.PadController"
 , "GI.Gtk.Objects.PageSetup"
 , "GI.Gtk.Objects.PageSetupUnixDialog"
 , "GI.Gtk.Objects.Paned"
 , "GI.Gtk.Objects.ParamSpecExpression"
 , "GI.Gtk.Objects.PasswordEntry"
 , "GI.Gtk.Objects.PasswordEntryBuffer"
 , "GI.Gtk.Objects.Picture"
 , "GI.Gtk.Objects.Popover"
 , "GI.Gtk.Objects.PopoverMenu"
 , "GI.Gtk.Objects.PopoverMenuBar"
 , "GI.Gtk.Objects.PrintContext"
 , "GI.Gtk.Objects.PrintDialog"
 , "GI.Gtk.Objects.PrintJob"
 , "GI.Gtk.Objects.PrintOperation"
 , "GI.Gtk.Objects.PrintSettings"
 , "GI.Gtk.Objects.PrintUnixDialog"
 , "GI.Gtk.Objects.Printer"
 , "GI.Gtk.Objects.ProgressBar"
 , "GI.Gtk.Objects.PropertyExpression"
 , "GI.Gtk.Objects.Range"
 , "GI.Gtk.Objects.RecentManager"
 , "GI.Gtk.Objects.Revealer"
 , "GI.Gtk.Objects.Scale"
 , "GI.Gtk.Objects.ScaleButton"
 , "GI.Gtk.Objects.Scrollbar"
 , "GI.Gtk.Objects.ScrolledWindow"
 , "GI.Gtk.Objects.SearchBar"
 , "GI.Gtk.Objects.SearchEntry"
 , "GI.Gtk.Objects.SelectionFilterModel"
 , "GI.Gtk.Objects.Separator"
 , "GI.Gtk.Objects.Settings"
 , "GI.Gtk.Objects.Shortcut"
 , "GI.Gtk.Objects.ShortcutAction"
 , "GI.Gtk.Objects.ShortcutController"
 , "GI.Gtk.Objects.ShortcutLabel"
 , "GI.Gtk.Objects.ShortcutTrigger"
 , "GI.Gtk.Objects.ShortcutsGroup"
 , "GI.Gtk.Objects.ShortcutsSection"
 , "GI.Gtk.Objects.ShortcutsShortcut"
 , "GI.Gtk.Objects.ShortcutsWindow"
 , "GI.Gtk.Objects.SignalAction"
 , "GI.Gtk.Objects.SignalListItemFactory"
 , "GI.Gtk.Objects.SingleSelection"
 , "GI.Gtk.Objects.SizeGroup"
 , "GI.Gtk.Objects.SliceListModel"
 , "GI.Gtk.Objects.Snapshot"
 , "GI.Gtk.Objects.SortListModel"
 , "GI.Gtk.Objects.Sorter"
 , "GI.Gtk.Objects.SpinButton"
 , "GI.Gtk.Objects.Spinner"
 , "GI.Gtk.Objects.Stack"
 , "GI.Gtk.Objects.StackPage"
 , "GI.Gtk.Objects.StackSidebar"
 , "GI.Gtk.Objects.StackSwitcher"
 , "GI.Gtk.Objects.Statusbar"
 , "GI.Gtk.Objects.StringFilter"
 , "GI.Gtk.Objects.StringList"
 , "GI.Gtk.Objects.StringObject"
 , "GI.Gtk.Objects.StringSorter"
 , "GI.Gtk.Objects.StyleContext"
 , "GI.Gtk.Objects.Switch"
 , "GI.Gtk.Objects.Text"
 , "GI.Gtk.Objects.TextBuffer"
 , "GI.Gtk.Objects.TextChildAnchor"
 , "GI.Gtk.Objects.TextMark"
 , "GI.Gtk.Objects.TextTag"
 , "GI.Gtk.Objects.TextTagTable"
 , "GI.Gtk.Objects.TextView"
 , "GI.Gtk.Objects.ToggleButton"
 , "GI.Gtk.Objects.Tooltip"
 , "GI.Gtk.Objects.TreeExpander"
 , "GI.Gtk.Objects.TreeListModel"
 , "GI.Gtk.Objects.TreeListRow"
 , "GI.Gtk.Objects.TreeListRowSorter"
 , "GI.Gtk.Objects.TreeModelFilter"
 , "GI.Gtk.Objects.TreeModelSort"
 , "GI.Gtk.Objects.TreeSelection"
 , "GI.Gtk.Objects.TreeStore"
 , "GI.Gtk.Objects.TreeView"
 , "GI.Gtk.Objects.TreeViewColumn"
 , "GI.Gtk.Objects.UriLauncher"
 , "GI.Gtk.Objects.Video"
 , "GI.Gtk.Objects.Viewport"
 , "GI.Gtk.Objects.VolumeButton"
 , "GI.Gtk.Objects.Widget"
 , "GI.Gtk.Objects.WidgetPaintable"
 , "GI.Gtk.Objects.Window"
 , "GI.Gtk.Objects.WindowControls"
 , "GI.Gtk.Objects.WindowGroup"
 , "GI.Gtk.Objects.WindowHandle"
 , "GI.Gtk.Structs"
 , "GI.Gtk.Structs.AccessibleList"
 , "GI.Gtk.Structs.AccessibleTextRange"
 , "GI.Gtk.Structs.Bitset"
 , "GI.Gtk.Structs.BitsetIter"
 , "GI.Gtk.Structs.Border"
 , "GI.Gtk.Structs.BuildableParseContext"
 , "GI.Gtk.Structs.BuildableParser"
 , "GI.Gtk.Structs.CssLocation"
 , "GI.Gtk.Structs.CssSection"
 , "GI.Gtk.Structs.CssStyleChange"
 , "GI.Gtk.Structs.ExpressionWatch"
 , "GI.Gtk.Structs.PadActionEntry"
 , "GI.Gtk.Structs.PageRange"
 , "GI.Gtk.Structs.PaperSize"
 , "GI.Gtk.Structs.PrintBackend"
 , "GI.Gtk.Structs.PrintSetup"
 , "GI.Gtk.Structs.RecentData"
 , "GI.Gtk.Structs.RecentInfo"
 , "GI.Gtk.Structs.RequestedSize"
 , "GI.Gtk.Structs.Requisition"
 , "GI.Gtk.Structs.ScrollInfo"
 , "GI.Gtk.Structs.TextIter"
 , "GI.Gtk.Structs.TreeIter"
 , "GI.Gtk.Structs.TreePath"
 , "GI.Gtk.Structs.TreeRowReference"
 , "GI.Gtk.Structs.WidgetClass"]
