{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A range inside the text of an accessible object.
-- 
-- /Since: 4.14/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Structs.AccessibleTextRange
    ( 

-- * Exported types
    AccessibleTextRange(..)                 ,
    newZeroAccessibleTextRange              ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveAccessibleTextRangeMethod        ,
#endif



 -- * Properties


-- ** length #attr:length#
-- | the length of the range, in characters

#if defined(ENABLE_OVERLOADING)
    accessibleTextRange_length              ,
#endif
    getAccessibleTextRangeLength            ,
    setAccessibleTextRangeLength            ,


-- ** start #attr:start#
-- | the start of the range, in characters

#if defined(ENABLE_OVERLOADING)
    accessibleTextRange_start               ,
#endif
    getAccessibleTextRangeStart             ,
    setAccessibleTextRangeStart             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype AccessibleTextRange = AccessibleTextRange (SP.ManagedPtr AccessibleTextRange)
    deriving (Eq)

instance SP.ManagedPtrNewtype AccessibleTextRange where
    toManagedPtr (AccessibleTextRange p) = p

instance BoxedPtr AccessibleTextRange where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr AccessibleTextRange)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr AccessibleTextRange where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'AccessibleTextRange' struct initialized to zero.
newZeroAccessibleTextRange :: MonadIO m => m AccessibleTextRange
newZeroAccessibleTextRange = liftIO $ boxedPtrCalloc >>= wrapPtr AccessibleTextRange

instance tag ~ 'AttrSet => Constructible AccessibleTextRange tag where
    new _ attrs = do
        o <- newZeroAccessibleTextRange
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' accessibleTextRange #start
-- @
getAccessibleTextRangeStart :: MonadIO m => AccessibleTextRange -> m FCT.CSize
getAccessibleTextRangeStart s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO FCT.CSize
    return val

-- | Set the value of the “@start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' accessibleTextRange [ #start 'Data.GI.Base.Attributes.:=' value ]
-- @
setAccessibleTextRangeStart :: MonadIO m => AccessibleTextRange -> FCT.CSize -> m ()
setAccessibleTextRangeStart s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data AccessibleTextRangeStartFieldInfo
instance AttrInfo AccessibleTextRangeStartFieldInfo where
    type AttrBaseTypeConstraint AccessibleTextRangeStartFieldInfo = (~) AccessibleTextRange
    type AttrAllowedOps AccessibleTextRangeStartFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AccessibleTextRangeStartFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint AccessibleTextRangeStartFieldInfo = (~)FCT.CSize
    type AttrTransferType AccessibleTextRangeStartFieldInfo = FCT.CSize
    type AttrGetType AccessibleTextRangeStartFieldInfo = FCT.CSize
    type AttrLabel AccessibleTextRangeStartFieldInfo = "start"
    type AttrOrigin AccessibleTextRangeStartFieldInfo = AccessibleTextRange
    attrGet = getAccessibleTextRangeStart
    attrSet = setAccessibleTextRangeStart
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.AccessibleTextRange.start"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-AccessibleTextRange.html#g:attr:start"
        })

accessibleTextRange_start :: AttrLabelProxy "start"
accessibleTextRange_start = AttrLabelProxy

#endif


-- | Get the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' accessibleTextRange #length
-- @
getAccessibleTextRangeLength :: MonadIO m => AccessibleTextRange -> m FCT.CSize
getAccessibleTextRangeLength s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO FCT.CSize
    return val

-- | Set the value of the “@length@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' accessibleTextRange [ #length 'Data.GI.Base.Attributes.:=' value ]
-- @
setAccessibleTextRangeLength :: MonadIO m => AccessibleTextRange -> FCT.CSize -> m ()
setAccessibleTextRangeLength s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FCT.CSize)

#if defined(ENABLE_OVERLOADING)
data AccessibleTextRangeLengthFieldInfo
instance AttrInfo AccessibleTextRangeLengthFieldInfo where
    type AttrBaseTypeConstraint AccessibleTextRangeLengthFieldInfo = (~) AccessibleTextRange
    type AttrAllowedOps AccessibleTextRangeLengthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint AccessibleTextRangeLengthFieldInfo = (~) FCT.CSize
    type AttrTransferTypeConstraint AccessibleTextRangeLengthFieldInfo = (~)FCT.CSize
    type AttrTransferType AccessibleTextRangeLengthFieldInfo = FCT.CSize
    type AttrGetType AccessibleTextRangeLengthFieldInfo = FCT.CSize
    type AttrLabel AccessibleTextRangeLengthFieldInfo = "length"
    type AttrOrigin AccessibleTextRangeLengthFieldInfo = AccessibleTextRange
    attrGet = getAccessibleTextRangeLength
    attrSet = setAccessibleTextRangeLength
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Structs.AccessibleTextRange.length"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Structs-AccessibleTextRange.html#g:attr:length"
        })

accessibleTextRange_length :: AttrLabelProxy "length"
accessibleTextRange_length = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AccessibleTextRange
type instance O.AttributeList AccessibleTextRange = AccessibleTextRangeAttributeList
type AccessibleTextRangeAttributeList = ('[ '("start", AccessibleTextRangeStartFieldInfo), '("length", AccessibleTextRangeLengthFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveAccessibleTextRangeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAccessibleTextRangeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAccessibleTextRangeMethod t AccessibleTextRange, O.OverloadedMethod info AccessibleTextRange p) => OL.IsLabel t (AccessibleTextRange -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAccessibleTextRangeMethod t AccessibleTextRange, O.OverloadedMethod info AccessibleTextRange p, R.HasField t AccessibleTextRange p) => R.HasField t AccessibleTextRange p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAccessibleTextRangeMethod t AccessibleTextRange, O.OverloadedMethodInfo info AccessibleTextRange) => OL.IsLabel t (O.MethodProxy info AccessibleTextRange) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


