{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Implements titlebar functionality for a window.
-- 
-- When added into a window, it can be dragged to move the window,
-- and it implements the right click, double click and middle click
-- behaviors that are expected of a titlebar.
-- 
-- = CSS nodes
-- 
-- @GtkWindowHandle@ has a single CSS node with the name @windowhandle@.
-- 
-- = Accessibility
-- 
-- Until GTK 4.10, @GtkWindowHandle@ used the 'GI.Gtk.Enums.AccessibleRoleGroup' role.
-- 
-- Starting from GTK 4.12, @GtkWindowHandle@ uses the 'GI.Gtk.Enums.AccessibleRoleGeneric'
-- role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.WindowHandle
    ( 

-- * Exported types
    WindowHandle(..)                        ,
    IsWindowHandle                          ,
    toWindowHandle                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.WindowHandle#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.WindowHandle#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveWindowHandleMethod               ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    WindowHandleGetChildMethodInfo          ,
#endif
    windowHandleGetChild                    ,


-- ** new #method:new#

    windowHandleNew                         ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    WindowHandleSetChildMethodInfo          ,
#endif
    windowHandleSetChild                    ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    WindowHandleChildPropertyInfo           ,
#endif
    clearWindowHandleChild                  ,
    constructWindowHandleChild              ,
    getWindowHandleChild                    ,
    setWindowHandleChild                    ,
#if defined(ENABLE_OVERLOADING)
    windowHandleChild                       ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype WindowHandle = WindowHandle (SP.ManagedPtr WindowHandle)
    deriving (Eq)

instance SP.ManagedPtrNewtype WindowHandle where
    toManagedPtr (WindowHandle p) = p

foreign import ccall "gtk_window_handle_get_type"
    c_gtk_window_handle_get_type :: IO B.Types.GType

instance B.Types.TypedObject WindowHandle where
    glibType = c_gtk_window_handle_get_type

instance B.Types.GObject WindowHandle

-- | Type class for types which can be safely cast to t'WindowHandle', for instance with `toWindowHandle`.
class (SP.GObject o, O.IsDescendantOf WindowHandle o) => IsWindowHandle o
instance (SP.GObject o, O.IsDescendantOf WindowHandle o) => IsWindowHandle o

instance O.HasParentTypes WindowHandle
type instance O.ParentTypes WindowHandle = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'WindowHandle', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toWindowHandle :: (MIO.MonadIO m, IsWindowHandle o) => o -> m WindowHandle
toWindowHandle = MIO.liftIO . B.ManagedPtr.unsafeCastTo WindowHandle

-- | Convert t'WindowHandle' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe WindowHandle) where
    gvalueGType_ = c_gtk_window_handle_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr WindowHandle)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr WindowHandle)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject WindowHandle ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveWindowHandleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveWindowHandleMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveWindowHandleMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveWindowHandleMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveWindowHandleMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveWindowHandleMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveWindowHandleMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveWindowHandleMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveWindowHandleMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveWindowHandleMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveWindowHandleMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveWindowHandleMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveWindowHandleMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveWindowHandleMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveWindowHandleMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveWindowHandleMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveWindowHandleMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveWindowHandleMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveWindowHandleMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveWindowHandleMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveWindowHandleMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveWindowHandleMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveWindowHandleMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveWindowHandleMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveWindowHandleMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveWindowHandleMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveWindowHandleMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveWindowHandleMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveWindowHandleMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveWindowHandleMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveWindowHandleMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveWindowHandleMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveWindowHandleMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveWindowHandleMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveWindowHandleMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveWindowHandleMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveWindowHandleMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveWindowHandleMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveWindowHandleMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveWindowHandleMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveWindowHandleMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveWindowHandleMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveWindowHandleMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveWindowHandleMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveWindowHandleMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveWindowHandleMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveWindowHandleMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveWindowHandleMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveWindowHandleMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveWindowHandleMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveWindowHandleMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveWindowHandleMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveWindowHandleMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveWindowHandleMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveWindowHandleMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveWindowHandleMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveWindowHandleMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveWindowHandleMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveWindowHandleMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveWindowHandleMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveWindowHandleMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveWindowHandleMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveWindowHandleMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveWindowHandleMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveWindowHandleMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveWindowHandleMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveWindowHandleMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveWindowHandleMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveWindowHandleMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveWindowHandleMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveWindowHandleMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveWindowHandleMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveWindowHandleMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveWindowHandleMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveWindowHandleMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveWindowHandleMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveWindowHandleMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveWindowHandleMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveWindowHandleMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveWindowHandleMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveWindowHandleMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveWindowHandleMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveWindowHandleMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveWindowHandleMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveWindowHandleMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveWindowHandleMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveWindowHandleMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveWindowHandleMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveWindowHandleMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveWindowHandleMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveWindowHandleMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveWindowHandleMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveWindowHandleMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveWindowHandleMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveWindowHandleMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveWindowHandleMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveWindowHandleMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveWindowHandleMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveWindowHandleMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveWindowHandleMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveWindowHandleMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveWindowHandleMethod "getChild" o = WindowHandleGetChildMethodInfo
    ResolveWindowHandleMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveWindowHandleMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveWindowHandleMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveWindowHandleMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveWindowHandleMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveWindowHandleMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveWindowHandleMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveWindowHandleMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveWindowHandleMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveWindowHandleMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveWindowHandleMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveWindowHandleMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveWindowHandleMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveWindowHandleMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveWindowHandleMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveWindowHandleMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveWindowHandleMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveWindowHandleMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveWindowHandleMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveWindowHandleMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveWindowHandleMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveWindowHandleMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveWindowHandleMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveWindowHandleMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveWindowHandleMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveWindowHandleMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveWindowHandleMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveWindowHandleMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveWindowHandleMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveWindowHandleMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveWindowHandleMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveWindowHandleMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveWindowHandleMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveWindowHandleMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveWindowHandleMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveWindowHandleMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveWindowHandleMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveWindowHandleMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveWindowHandleMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveWindowHandleMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveWindowHandleMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveWindowHandleMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveWindowHandleMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveWindowHandleMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveWindowHandleMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveWindowHandleMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveWindowHandleMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveWindowHandleMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveWindowHandleMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveWindowHandleMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveWindowHandleMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveWindowHandleMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveWindowHandleMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveWindowHandleMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveWindowHandleMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveWindowHandleMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveWindowHandleMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveWindowHandleMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveWindowHandleMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveWindowHandleMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveWindowHandleMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveWindowHandleMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveWindowHandleMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveWindowHandleMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveWindowHandleMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveWindowHandleMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveWindowHandleMethod "setChild" o = WindowHandleSetChildMethodInfo
    ResolveWindowHandleMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveWindowHandleMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveWindowHandleMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveWindowHandleMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveWindowHandleMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveWindowHandleMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveWindowHandleMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveWindowHandleMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveWindowHandleMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveWindowHandleMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveWindowHandleMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveWindowHandleMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveWindowHandleMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveWindowHandleMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveWindowHandleMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveWindowHandleMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveWindowHandleMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveWindowHandleMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveWindowHandleMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveWindowHandleMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveWindowHandleMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveWindowHandleMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveWindowHandleMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveWindowHandleMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveWindowHandleMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveWindowHandleMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveWindowHandleMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveWindowHandleMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveWindowHandleMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveWindowHandleMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveWindowHandleMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveWindowHandleMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveWindowHandleMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveWindowHandleMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveWindowHandleMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveWindowHandleMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveWindowHandleMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveWindowHandleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveWindowHandleMethod t WindowHandle, O.OverloadedMethod info WindowHandle p) => OL.IsLabel t (WindowHandle -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveWindowHandleMethod t WindowHandle, O.OverloadedMethod info WindowHandle p, R.HasField t WindowHandle p) => R.HasField t WindowHandle p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveWindowHandleMethod t WindowHandle, O.OverloadedMethodInfo info WindowHandle) => OL.IsLabel t (O.MethodProxy info WindowHandle) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' windowHandle #child
-- @
getWindowHandleChild :: (MonadIO m, IsWindowHandle o) => o -> m (Maybe Gtk.Widget.Widget)
getWindowHandleChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' windowHandle [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setWindowHandleChild :: (MonadIO m, IsWindowHandle o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setWindowHandleChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructWindowHandleChild :: (IsWindowHandle o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructWindowHandleChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearWindowHandleChild :: (MonadIO m, IsWindowHandle o) => o -> m ()
clearWindowHandleChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data WindowHandleChildPropertyInfo
instance AttrInfo WindowHandleChildPropertyInfo where
    type AttrAllowedOps WindowHandleChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint WindowHandleChildPropertyInfo = IsWindowHandle
    type AttrSetTypeConstraint WindowHandleChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint WindowHandleChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType WindowHandleChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType WindowHandleChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel WindowHandleChildPropertyInfo = "child"
    type AttrOrigin WindowHandleChildPropertyInfo = WindowHandle
    attrGet = getWindowHandleChild
    attrSet = setWindowHandleChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructWindowHandleChild
    attrClear = clearWindowHandleChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowHandle.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-WindowHandle.html#g:attr:child"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList WindowHandle
type instance O.AttributeList WindowHandle = WindowHandleAttributeList
type WindowHandleAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", WindowHandleChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
windowHandleChild :: AttrLabelProxy "child"
windowHandleChild = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList WindowHandle = WindowHandleSignalList
type WindowHandleSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method WindowHandle::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "WindowHandle" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_handle_new" gtk_window_handle_new :: 
    IO (Ptr WindowHandle)

-- | Creates a new @GtkWindowHandle@.
windowHandleNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m WindowHandle
    -- ^ __Returns:__ a new @GtkWindowHandle@.
windowHandleNew  = liftIO $ do
    result <- gtk_window_handle_new
    checkUnexpectedReturnNULL "windowHandleNew" result
    result' <- (newObject WindowHandle) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method WindowHandle::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowHandle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWindowHandle`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_handle_get_child" gtk_window_handle_get_child :: 
    Ptr WindowHandle ->                     -- self : TInterface (Name {namespace = "Gtk", name = "WindowHandle"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@self@/.
windowHandleGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowHandle a) =>
    a
    -- ^ /@self@/: a @GtkWindowHandle@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@self@/
windowHandleGetChild self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gtk_window_handle_get_child self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data WindowHandleGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsWindowHandle a) => O.OverloadedMethod WindowHandleGetChildMethodInfo a signature where
    overloadedMethod = windowHandleGetChild

instance O.OverloadedMethodInfo WindowHandleGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowHandle.windowHandleGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-WindowHandle.html#v:windowHandleGetChild"
        })


#endif

-- method WindowHandle::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "WindowHandle" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkWindowHandle`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_window_handle_set_child" gtk_window_handle_set_child :: 
    Ptr WindowHandle ->                     -- self : TInterface (Name {namespace = "Gtk", name = "WindowHandle"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@self@/.
windowHandleSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsWindowHandle a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@self@/: a @GtkWindowHandle@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
windowHandleSetChild self child = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_window_handle_set_child self' maybeChild
    touchManagedPtr self
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data WindowHandleSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsWindowHandle a, Gtk.Widget.IsWidget b) => O.OverloadedMethod WindowHandleSetChildMethodInfo a signature where
    overloadedMethod = windowHandleSetChild

instance O.OverloadedMethodInfo WindowHandleSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.WindowHandle.windowHandleSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-WindowHandle.html#v:windowHandleSetChild"
        })


#endif


