{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Displays information about a program.
-- 
-- The shown information includes the programs\' logo, name, copyright,
-- website and license. It is also possible to give credits to the authors,
-- documenters, translators and artists who have worked on the program.
-- 
-- An about dialog is typically opened when the user selects the @About@
-- option from the @Help@ menu. All parts of the dialog are optional.
-- 
-- \<picture>
--   \<source srcset=\"aboutdialot-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkAboutDialog\" src=\"aboutdialog.png\">
-- \<\/picture>
-- 
-- About dialogs often contain links and email addresses. @GtkAboutDialog@
-- displays these as clickable links. By default, it calls 'GI.Gtk.Objects.FileLauncher.fileLauncherLaunch'
-- when a user clicks one. The behaviour can be overridden with the
-- [AboutDialog::activateLink]("GI.Gtk.Objects.AboutDialog#g:signal:activateLink") signal.
-- 
-- To specify a person with an email address, use a string like
-- @Edgar Allan Poe \<edgar\@poe.com>@. To specify a website with a title,
-- use a string like @GTK team https:\/\/www.gtk.org@.
-- 
-- To make constructing an about dialog as convenient as possible, you can
-- use the function @/Gtk.show_about_dialog/@ which constructs and shows
-- a dialog and keeps it around so that it can be shown again.
-- 
-- Note that GTK sets a default title of @_(\"About %s\")@ on the dialog
-- window (where @%s@ is replaced by the name of the application, but in
-- order to ensure proper translation of the title, applications should
-- set the title property explicitly when constructing an about dialog,
-- as shown in the following example:
-- 
-- 
-- === /c code/
-- >GFile *logo_file = g_file_new_for_path ("./logo.png");
-- >GdkTexture *example_logo = gdk_texture_new_from_file (logo_file, NULL);
-- >g_object_unref (logo_file);
-- >
-- >gtk_show_about_dialog (NULL,
-- >                       "program-name", "ExampleCode",
-- >                       "logo", example_logo,
-- >                       "title", _("About ExampleCode"),
-- >                       NULL);
-- 
-- 
-- == Shortcuts and Gestures
-- 
-- @GtkAboutDialog@ supports the following keyboard shortcuts:
-- 
-- * \<kbd>Escape\<\/kbd> closes the window.
-- 
-- 
-- == CSS nodes
-- 
-- @GtkAboutDialog@ has a single CSS node with the name @window@ and style
-- class @.aboutdialog@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.AboutDialog
    ( 

-- * Exported types
    AboutDialog(..)                         ,
    IsAboutDialog                           ,
    toAboutDialog                           ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCreditSection]("GI.Gtk.Objects.AboutDialog#g:method:addCreditSection"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [close]("GI.Gtk.Objects.Window#g:method:close"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [destroy]("GI.Gtk.Objects.Window#g:method:destroy"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [fullscreen]("GI.Gtk.Objects.Window#g:method:fullscreen"), [fullscreenOnMonitor]("GI.Gtk.Objects.Window#g:method:fullscreenOnMonitor"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasGroup]("GI.Gtk.Objects.Window#g:method:hasGroup"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isActive]("GI.Gtk.Objects.Window#g:method:isActive"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isFullscreen]("GI.Gtk.Objects.Window#g:method:isFullscreen"), [isMaximized]("GI.Gtk.Objects.Window#g:method:isMaximized"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isSuspended]("GI.Gtk.Objects.Window#g:method:isSuspended"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [maximize]("GI.Gtk.Objects.Window#g:method:maximize"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [minimize]("GI.Gtk.Objects.Window#g:method:minimize"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [present]("GI.Gtk.Objects.Window#g:method:present"), [presentWithTime]("GI.Gtk.Objects.Window#g:method:presentWithTime"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unfullscreen]("GI.Gtk.Objects.Window#g:method:unfullscreen"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unmaximize]("GI.Gtk.Objects.Window#g:method:unmaximize"), [unminimize]("GI.Gtk.Objects.Window#g:method:unminimize"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getApplication]("GI.Gtk.Objects.Window#g:method:getApplication"), [getArtists]("GI.Gtk.Objects.AboutDialog#g:method:getArtists"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getAuthors]("GI.Gtk.Objects.AboutDialog#g:method:getAuthors"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.Window#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getComments]("GI.Gtk.Objects.AboutDialog#g:method:getComments"), [getCopyright]("GI.Gtk.Objects.AboutDialog#g:method:getCopyright"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDecorated]("GI.Gtk.Objects.Window#g:method:getDecorated"), [getDefaultSize]("GI.Gtk.Objects.Window#g:method:getDefaultSize"), [getDefaultWidget]("GI.Gtk.Objects.Window#g:method:getDefaultWidget"), [getDeletable]("GI.Gtk.Objects.Window#g:method:getDeletable"), [getDestroyWithParent]("GI.Gtk.Objects.Window#g:method:getDestroyWithParent"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getDocumenters]("GI.Gtk.Objects.AboutDialog#g:method:getDocumenters"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocus]("GI.Gtk.Objects.Window#g:method:getFocus"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusVisible]("GI.Gtk.Objects.Window#g:method:getFocusVisible"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getGravity]("GI.Gtk.Objects.Window#g:method:getGravity"), [getGroup]("GI.Gtk.Objects.Window#g:method:getGroup"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:getHandleMenubarAccel"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHideOnClose]("GI.Gtk.Objects.Window#g:method:getHideOnClose"), [getIconName]("GI.Gtk.Objects.Window#g:method:getIconName"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLicense]("GI.Gtk.Objects.AboutDialog#g:method:getLicense"), [getLicenseType]("GI.Gtk.Objects.AboutDialog#g:method:getLicenseType"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getLogo]("GI.Gtk.Objects.AboutDialog#g:method:getLogo"), [getLogoIconName]("GI.Gtk.Objects.AboutDialog#g:method:getLogoIconName"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:getMnemonicsVisible"), [getModal]("GI.Gtk.Objects.Window#g:method:getModal"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getProgramName]("GI.Gtk.Objects.AboutDialog#g:method:getProgramName"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRenderer]("GI.Gtk.Interfaces.Native#g:method:getRenderer"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getResizable]("GI.Gtk.Objects.Window#g:method:getResizable"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getSurface]("GI.Gtk.Interfaces.Native#g:method:getSurface"), [getSurfaceTransform]("GI.Gtk.Interfaces.Native#g:method:getSurfaceTransform"), [getSystemInformation]("GI.Gtk.Objects.AboutDialog#g:method:getSystemInformation"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTitle]("GI.Gtk.Objects.Window#g:method:getTitle"), [getTitlebar]("GI.Gtk.Objects.Window#g:method:getTitlebar"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getTransientFor]("GI.Gtk.Objects.Window#g:method:getTransientFor"), [getTranslatorCredits]("GI.Gtk.Objects.AboutDialog#g:method:getTranslatorCredits"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVersion]("GI.Gtk.Objects.AboutDialog#g:method:getVersion"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getWebsite]("GI.Gtk.Objects.AboutDialog#g:method:getWebsite"), [getWebsiteLabel]("GI.Gtk.Objects.AboutDialog#g:method:getWebsiteLabel"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth"), [getWrapLicense]("GI.Gtk.Objects.AboutDialog#g:method:getWrapLicense").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setApplication]("GI.Gtk.Objects.Window#g:method:setApplication"), [setArtists]("GI.Gtk.Objects.AboutDialog#g:method:setArtists"), [setAuthors]("GI.Gtk.Objects.AboutDialog#g:method:setAuthors"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.Window#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setComments]("GI.Gtk.Objects.AboutDialog#g:method:setComments"), [setCopyright]("GI.Gtk.Objects.AboutDialog#g:method:setCopyright"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDecorated]("GI.Gtk.Objects.Window#g:method:setDecorated"), [setDefaultSize]("GI.Gtk.Objects.Window#g:method:setDefaultSize"), [setDefaultWidget]("GI.Gtk.Objects.Window#g:method:setDefaultWidget"), [setDeletable]("GI.Gtk.Objects.Window#g:method:setDeletable"), [setDestroyWithParent]("GI.Gtk.Objects.Window#g:method:setDestroyWithParent"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setDisplay]("GI.Gtk.Objects.Window#g:method:setDisplay"), [setDocumenters]("GI.Gtk.Objects.AboutDialog#g:method:setDocumenters"), [setFocus]("GI.Gtk.Objects.Window#g:method:setFocus"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusVisible]("GI.Gtk.Objects.Window#g:method:setFocusVisible"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setGravity]("GI.Gtk.Objects.Window#g:method:setGravity"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHandleMenubarAccel]("GI.Gtk.Objects.Window#g:method:setHandleMenubarAccel"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setHideOnClose]("GI.Gtk.Objects.Window#g:method:setHideOnClose"), [setIconName]("GI.Gtk.Objects.Window#g:method:setIconName"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLicense]("GI.Gtk.Objects.AboutDialog#g:method:setLicense"), [setLicenseType]("GI.Gtk.Objects.AboutDialog#g:method:setLicenseType"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setLogo]("GI.Gtk.Objects.AboutDialog#g:method:setLogo"), [setLogoIconName]("GI.Gtk.Objects.AboutDialog#g:method:setLogoIconName"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMnemonicsVisible]("GI.Gtk.Objects.Window#g:method:setMnemonicsVisible"), [setModal]("GI.Gtk.Objects.Window#g:method:setModal"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setProgramName]("GI.Gtk.Objects.AboutDialog#g:method:setProgramName"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setResizable]("GI.Gtk.Objects.Window#g:method:setResizable"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStartupId]("GI.Gtk.Objects.Window#g:method:setStartupId"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setSystemInformation]("GI.Gtk.Objects.AboutDialog#g:method:setSystemInformation"), [setTitle]("GI.Gtk.Objects.Window#g:method:setTitle"), [setTitlebar]("GI.Gtk.Objects.Window#g:method:setTitlebar"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setTransientFor]("GI.Gtk.Objects.Window#g:method:setTransientFor"), [setTranslatorCredits]("GI.Gtk.Objects.AboutDialog#g:method:setTranslatorCredits"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVersion]("GI.Gtk.Objects.AboutDialog#g:method:setVersion"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible"), [setWebsite]("GI.Gtk.Objects.AboutDialog#g:method:setWebsite"), [setWebsiteLabel]("GI.Gtk.Objects.AboutDialog#g:method:setWebsiteLabel"), [setWrapLicense]("GI.Gtk.Objects.AboutDialog#g:method:setWrapLicense").

#if defined(ENABLE_OVERLOADING)
    ResolveAboutDialogMethod                ,
#endif

-- ** addCreditSection #method:addCreditSection#

#if defined(ENABLE_OVERLOADING)
    AboutDialogAddCreditSectionMethodInfo   ,
#endif
    aboutDialogAddCreditSection             ,


-- ** getArtists #method:getArtists#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetArtistsMethodInfo         ,
#endif
    aboutDialogGetArtists                   ,


-- ** getAuthors #method:getAuthors#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetAuthorsMethodInfo         ,
#endif
    aboutDialogGetAuthors                   ,


-- ** getComments #method:getComments#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetCommentsMethodInfo        ,
#endif
    aboutDialogGetComments                  ,


-- ** getCopyright #method:getCopyright#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetCopyrightMethodInfo       ,
#endif
    aboutDialogGetCopyright                 ,


-- ** getDocumenters #method:getDocumenters#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetDocumentersMethodInfo     ,
#endif
    aboutDialogGetDocumenters               ,


-- ** getLicense #method:getLicense#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetLicenseMethodInfo         ,
#endif
    aboutDialogGetLicense                   ,


-- ** getLicenseType #method:getLicenseType#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetLicenseTypeMethodInfo     ,
#endif
    aboutDialogGetLicenseType               ,


-- ** getLogo #method:getLogo#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetLogoMethodInfo            ,
#endif
    aboutDialogGetLogo                      ,


-- ** getLogoIconName #method:getLogoIconName#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetLogoIconNameMethodInfo    ,
#endif
    aboutDialogGetLogoIconName              ,


-- ** getProgramName #method:getProgramName#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetProgramNameMethodInfo     ,
#endif
    aboutDialogGetProgramName               ,


-- ** getSystemInformation #method:getSystemInformation#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetSystemInformationMethodInfo,
#endif
    aboutDialogGetSystemInformation         ,


-- ** getTranslatorCredits #method:getTranslatorCredits#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetTranslatorCreditsMethodInfo,
#endif
    aboutDialogGetTranslatorCredits         ,


-- ** getVersion #method:getVersion#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetVersionMethodInfo         ,
#endif
    aboutDialogGetVersion                   ,


-- ** getWebsite #method:getWebsite#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetWebsiteMethodInfo         ,
#endif
    aboutDialogGetWebsite                   ,


-- ** getWebsiteLabel #method:getWebsiteLabel#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetWebsiteLabelMethodInfo    ,
#endif
    aboutDialogGetWebsiteLabel              ,


-- ** getWrapLicense #method:getWrapLicense#

#if defined(ENABLE_OVERLOADING)
    AboutDialogGetWrapLicenseMethodInfo     ,
#endif
    aboutDialogGetWrapLicense               ,


-- ** new #method:new#

    aboutDialogNew                          ,


-- ** setArtists #method:setArtists#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetArtistsMethodInfo         ,
#endif
    aboutDialogSetArtists                   ,


-- ** setAuthors #method:setAuthors#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetAuthorsMethodInfo         ,
#endif
    aboutDialogSetAuthors                   ,


-- ** setComments #method:setComments#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetCommentsMethodInfo        ,
#endif
    aboutDialogSetComments                  ,


-- ** setCopyright #method:setCopyright#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetCopyrightMethodInfo       ,
#endif
    aboutDialogSetCopyright                 ,


-- ** setDocumenters #method:setDocumenters#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetDocumentersMethodInfo     ,
#endif
    aboutDialogSetDocumenters               ,


-- ** setLicense #method:setLicense#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetLicenseMethodInfo         ,
#endif
    aboutDialogSetLicense                   ,


-- ** setLicenseType #method:setLicenseType#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetLicenseTypeMethodInfo     ,
#endif
    aboutDialogSetLicenseType               ,


-- ** setLogo #method:setLogo#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetLogoMethodInfo            ,
#endif
    aboutDialogSetLogo                      ,


-- ** setLogoIconName #method:setLogoIconName#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetLogoIconNameMethodInfo    ,
#endif
    aboutDialogSetLogoIconName              ,


-- ** setProgramName #method:setProgramName#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetProgramNameMethodInfo     ,
#endif
    aboutDialogSetProgramName               ,


-- ** setSystemInformation #method:setSystemInformation#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetSystemInformationMethodInfo,
#endif
    aboutDialogSetSystemInformation         ,


-- ** setTranslatorCredits #method:setTranslatorCredits#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetTranslatorCreditsMethodInfo,
#endif
    aboutDialogSetTranslatorCredits         ,


-- ** setVersion #method:setVersion#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetVersionMethodInfo         ,
#endif
    aboutDialogSetVersion                   ,


-- ** setWebsite #method:setWebsite#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetWebsiteMethodInfo         ,
#endif
    aboutDialogSetWebsite                   ,


-- ** setWebsiteLabel #method:setWebsiteLabel#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetWebsiteLabelMethodInfo    ,
#endif
    aboutDialogSetWebsiteLabel              ,


-- ** setWrapLicense #method:setWrapLicense#

#if defined(ENABLE_OVERLOADING)
    AboutDialogSetWrapLicenseMethodInfo     ,
#endif
    aboutDialogSetWrapLicense               ,




 -- * Properties


-- ** artists #attr:artists#
-- | The people who contributed artwork to the program.
-- 
-- Each string may contain email addresses and URLs, which will be displayed
-- as links.

#if defined(ENABLE_OVERLOADING)
    AboutDialogArtistsPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogArtists                      ,
#endif
    constructAboutDialogArtists             ,
    getAboutDialogArtists                   ,
    setAboutDialogArtists                   ,


-- ** authors #attr:authors#
-- | The authors of the program.
-- 
-- Each string may contain email addresses and URLs, which will be displayed
-- as links, see the introduction for more details.

#if defined(ENABLE_OVERLOADING)
    AboutDialogAuthorsPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogAuthors                      ,
#endif
    constructAboutDialogAuthors             ,
    getAboutDialogAuthors                   ,
    setAboutDialogAuthors                   ,


-- ** comments #attr:comments#
-- | Comments about the program.
-- 
-- This string is displayed in a label in the main dialog, thus it
-- should be a short explanation of the main purpose of the program,
-- not a detailed list of features.

#if defined(ENABLE_OVERLOADING)
    AboutDialogCommentsPropertyInfo         ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogComments                     ,
#endif
    clearAboutDialogComments                ,
    constructAboutDialogComments            ,
    getAboutDialogComments                  ,
    setAboutDialogComments                  ,


-- ** copyright #attr:copyright#
-- | Copyright information for the program.

#if defined(ENABLE_OVERLOADING)
    AboutDialogCopyrightPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogCopyright                    ,
#endif
    clearAboutDialogCopyright               ,
    constructAboutDialogCopyright           ,
    getAboutDialogCopyright                 ,
    setAboutDialogCopyright                 ,


-- ** documenters #attr:documenters#
-- | The people documenting the program.
-- 
-- Each string may contain email addresses and URLs, which will be displayed
-- as links, see the introduction for more details.

#if defined(ENABLE_OVERLOADING)
    AboutDialogDocumentersPropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogDocumenters                  ,
#endif
    constructAboutDialogDocumenters         ,
    getAboutDialogDocumenters               ,
    setAboutDialogDocumenters               ,


-- ** license #attr:license#
-- | The license of the program, as free-form text.
-- 
-- This string is displayed in a text view in a secondary dialog, therefore
-- it is fine to use a long multi-paragraph text. Note that the text is only
-- wrapped in the text view if the \"wrap-license\" property is set to @TRUE@;
-- otherwise the text itself must contain the intended linebreaks.
-- 
-- When setting this property to a non-@NULL@ value, the
-- [AboutDialog:licenseType]("GI.Gtk.Objects.AboutDialog#g:attr:licenseType") property is set to
-- 'GI.Gtk.Enums.LicenseCustom' as a side effect.
-- 
-- The text may contain links in this format @\<http:\/\/www.some.place\/>@
-- and email references in the form @\<mail-to\@some.body>@, and these will
-- be converted into clickable links.

#if defined(ENABLE_OVERLOADING)
    AboutDialogLicensePropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogLicense                      ,
#endif
    clearAboutDialogLicense                 ,
    constructAboutDialogLicense             ,
    getAboutDialogLicense                   ,
    setAboutDialogLicense                   ,


-- ** licenseType #attr:licenseType#
-- | The license of the program.
-- 
-- The @GtkAboutDialog@ will automatically fill out a standard disclaimer
-- and link the user to the appropriate online resource for the license
-- text.
-- 
-- If 'GI.Gtk.Enums.LicenseUnknown' is used, the link used will be the same
-- specified in the [AboutDialog:website]("GI.Gtk.Objects.AboutDialog#g:attr:website") property.
-- 
-- If 'GI.Gtk.Enums.LicenseCustom' is used, the current contents of the
-- [AboutDialog:license]("GI.Gtk.Objects.AboutDialog#g:attr:license") property are used.
-- 
-- For any other t'GI.Gtk.Enums.License' value, the contents of the
-- [AboutDialog:license]("GI.Gtk.Objects.AboutDialog#g:attr:license") property are also set by
-- this property as a side effect.

#if defined(ENABLE_OVERLOADING)
    AboutDialogLicenseTypePropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogLicenseType                  ,
#endif
    constructAboutDialogLicenseType         ,
    getAboutDialogLicenseType               ,
    setAboutDialogLicenseType               ,


-- ** logo #attr:logo#
-- | A logo for the about box.
-- 
-- If it is @NULL@, the default window icon set with
-- 'GI.Gtk.Objects.Window.windowSetDefaultIconName' will be used.

#if defined(ENABLE_OVERLOADING)
    AboutDialogLogoPropertyInfo             ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogLogo                         ,
#endif
    clearAboutDialogLogo                    ,
    constructAboutDialogLogo                ,
    getAboutDialogLogo                      ,
    setAboutDialogLogo                      ,


-- ** logoIconName #attr:logoIconName#
-- | A named icon to use as the logo for the about box.
-- 
-- This property overrides the [AboutDialog:logo]("GI.Gtk.Objects.AboutDialog#g:attr:logo") property.

#if defined(ENABLE_OVERLOADING)
    AboutDialogLogoIconNamePropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogLogoIconName                 ,
#endif
    clearAboutDialogLogoIconName            ,
    constructAboutDialogLogoIconName        ,
    getAboutDialogLogoIconName              ,
    setAboutDialogLogoIconName              ,


-- ** programName #attr:programName#
-- | The name of the program.
-- 
-- If this is not set, it defaults to the value returned by
-- 'GI.GLib.Functions.getApplicationName'.

#if defined(ENABLE_OVERLOADING)
    AboutDialogProgramNamePropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogProgramName                  ,
#endif
    clearAboutDialogProgramName             ,
    constructAboutDialogProgramName         ,
    getAboutDialogProgramName               ,
    setAboutDialogProgramName               ,


-- ** systemInformation #attr:systemInformation#
-- | Information about the system on which the program is running.
-- 
-- This information is displayed in a separate page, therefore it is fine
-- to use a long multi-paragraph text. Note that the text should contain
-- the intended linebreaks.
-- 
-- The text may contain links in this format @\<http:\/\/www.some.place\/>@
-- and email references in the form @\<mail-to\@some.body>@, and these will
-- be converted into clickable links.

#if defined(ENABLE_OVERLOADING)
    AboutDialogSystemInformationPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogSystemInformation            ,
#endif
    clearAboutDialogSystemInformation       ,
    constructAboutDialogSystemInformation   ,
    getAboutDialogSystemInformation         ,
    setAboutDialogSystemInformation         ,


-- ** translatorCredits #attr:translatorCredits#
-- | Credits to the translators.
-- 
-- This string should be marked as translatable.
-- 
-- The string may contain email addresses and URLs, which will be displayed
-- as links, see the introduction for more details.

#if defined(ENABLE_OVERLOADING)
    AboutDialogTranslatorCreditsPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogTranslatorCredits            ,
#endif
    clearAboutDialogTranslatorCredits       ,
    constructAboutDialogTranslatorCredits   ,
    getAboutDialogTranslatorCredits         ,
    setAboutDialogTranslatorCredits         ,


-- ** version #attr:version#
-- | The version of the program.

#if defined(ENABLE_OVERLOADING)
    AboutDialogVersionPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogVersion                      ,
#endif
    clearAboutDialogVersion                 ,
    constructAboutDialogVersion             ,
    getAboutDialogVersion                   ,
    setAboutDialogVersion                   ,


-- ** website #attr:website#
-- | The URL for the link to the website of the program.
-- 
-- This should be a string starting with @http:\/\/@ or @https:\/\/@.

#if defined(ENABLE_OVERLOADING)
    AboutDialogWebsitePropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogWebsite                      ,
#endif
    clearAboutDialogWebsite                 ,
    constructAboutDialogWebsite             ,
    getAboutDialogWebsite                   ,
    setAboutDialogWebsite                   ,


-- ** websiteLabel #attr:websiteLabel#
-- | The label for the link to the website of the program.

#if defined(ENABLE_OVERLOADING)
    AboutDialogWebsiteLabelPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogWebsiteLabel                 ,
#endif
    constructAboutDialogWebsiteLabel        ,
    getAboutDialogWebsiteLabel              ,
    setAboutDialogWebsiteLabel              ,


-- ** wrapLicense #attr:wrapLicense#
-- | Whether to wrap the text in the license dialog.

#if defined(ENABLE_OVERLOADING)
    AboutDialogWrapLicensePropertyInfo      ,
#endif
#if defined(ENABLE_OVERLOADING)
    aboutDialogWrapLicense                  ,
#endif
    constructAboutDialogWrapLicense         ,
    getAboutDialogWrapLicense               ,
    setAboutDialogWrapLicense               ,




 -- * Signals


-- ** activateLink #signal:activateLink#

    AboutDialogActivateLinkCallback         ,
#if defined(ENABLE_OVERLOADING)
    AboutDialogActivateLinkSignalInfo       ,
#endif
    afterAboutDialogActivateLink            ,
    onAboutDialogActivateLink               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Flags as Gio.Flags
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.ActionMap as Gio.ActionMap
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Objects.Application as Gio.Application
import qualified GI.Gio.Objects.Menu as Gio.Menu
import qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Application as Gtk.Application
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window
import {-# SOURCE #-} qualified GI.Gtk.Objects.WindowGroup as Gtk.WindowGroup
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ShortcutManager as Gtk.ShortcutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Window as Gtk.Window

#endif

-- | Memory-managed wrapper type.
newtype AboutDialog = AboutDialog (SP.ManagedPtr AboutDialog)
    deriving (Eq)

instance SP.ManagedPtrNewtype AboutDialog where
    toManagedPtr (AboutDialog p) = p

foreign import ccall "gtk_about_dialog_get_type"
    c_gtk_about_dialog_get_type :: IO B.Types.GType

instance B.Types.TypedObject AboutDialog where
    glibType = c_gtk_about_dialog_get_type

instance B.Types.GObject AboutDialog

-- | Type class for types which can be safely cast to t'AboutDialog', for instance with `toAboutDialog`.
class (SP.GObject o, O.IsDescendantOf AboutDialog o) => IsAboutDialog o
instance (SP.GObject o, O.IsDescendantOf AboutDialog o) => IsAboutDialog o

instance O.HasParentTypes AboutDialog
type instance O.ParentTypes AboutDialog = '[Gtk.Window.Window, Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget, Gtk.Native.Native, Gtk.Root.Root, Gtk.ShortcutManager.ShortcutManager]

-- | Cast to t'AboutDialog', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAboutDialog :: (MIO.MonadIO m, IsAboutDialog o) => o -> m AboutDialog
toAboutDialog = MIO.liftIO . B.ManagedPtr.unsafeCastTo AboutDialog

-- | Convert t'AboutDialog' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AboutDialog) where
    gvalueGType_ = c_gtk_about_dialog_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AboutDialog)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AboutDialog)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AboutDialog ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAboutDialogMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAboutDialogMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveAboutDialogMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveAboutDialogMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveAboutDialogMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveAboutDialogMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveAboutDialogMethod "addCreditSection" o = AboutDialogAddCreditSectionMethodInfo
    ResolveAboutDialogMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveAboutDialogMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveAboutDialogMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveAboutDialogMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveAboutDialogMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveAboutDialogMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAboutDialogMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAboutDialogMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveAboutDialogMethod "close" o = Gtk.Window.WindowCloseMethodInfo
    ResolveAboutDialogMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveAboutDialogMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveAboutDialogMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveAboutDialogMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveAboutDialogMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveAboutDialogMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveAboutDialogMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveAboutDialogMethod "destroy" o = Gtk.Window.WindowDestroyMethodInfo
    ResolveAboutDialogMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveAboutDialogMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveAboutDialogMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveAboutDialogMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAboutDialogMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAboutDialogMethod "fullscreen" o = Gtk.Window.WindowFullscreenMethodInfo
    ResolveAboutDialogMethod "fullscreenOnMonitor" o = Gtk.Window.WindowFullscreenOnMonitorMethodInfo
    ResolveAboutDialogMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAboutDialogMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveAboutDialogMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveAboutDialogMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveAboutDialogMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveAboutDialogMethod "hasGroup" o = Gtk.Window.WindowHasGroupMethodInfo
    ResolveAboutDialogMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveAboutDialogMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveAboutDialogMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveAboutDialogMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveAboutDialogMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveAboutDialogMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveAboutDialogMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveAboutDialogMethod "isActive" o = Gtk.Window.WindowIsActiveMethodInfo
    ResolveAboutDialogMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveAboutDialogMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveAboutDialogMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAboutDialogMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveAboutDialogMethod "isFullscreen" o = Gtk.Window.WindowIsFullscreenMethodInfo
    ResolveAboutDialogMethod "isMaximized" o = Gtk.Window.WindowIsMaximizedMethodInfo
    ResolveAboutDialogMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveAboutDialogMethod "isSuspended" o = Gtk.Window.WindowIsSuspendedMethodInfo
    ResolveAboutDialogMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveAboutDialogMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveAboutDialogMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveAboutDialogMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveAboutDialogMethod "maximize" o = Gtk.Window.WindowMaximizeMethodInfo
    ResolveAboutDialogMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveAboutDialogMethod "minimize" o = Gtk.Window.WindowMinimizeMethodInfo
    ResolveAboutDialogMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveAboutDialogMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAboutDialogMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAboutDialogMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveAboutDialogMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveAboutDialogMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveAboutDialogMethod "present" o = Gtk.Window.WindowPresentMethodInfo
    ResolveAboutDialogMethod "presentWithTime" o = Gtk.Window.WindowPresentWithTimeMethodInfo
    ResolveAboutDialogMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveAboutDialogMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveAboutDialogMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveAboutDialogMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveAboutDialogMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAboutDialogMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAboutDialogMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveAboutDialogMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveAboutDialogMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveAboutDialogMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveAboutDialogMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveAboutDialogMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveAboutDialogMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveAboutDialogMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAboutDialogMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveAboutDialogMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveAboutDialogMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveAboutDialogMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveAboutDialogMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAboutDialogMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAboutDialogMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAboutDialogMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveAboutDialogMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveAboutDialogMethod "unfullscreen" o = Gtk.Window.WindowUnfullscreenMethodInfo
    ResolveAboutDialogMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveAboutDialogMethod "unmaximize" o = Gtk.Window.WindowUnmaximizeMethodInfo
    ResolveAboutDialogMethod "unminimize" o = Gtk.Window.WindowUnminimizeMethodInfo
    ResolveAboutDialogMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveAboutDialogMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveAboutDialogMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAboutDialogMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveAboutDialogMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveAboutDialogMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveAboutDialogMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveAboutDialogMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveAboutDialogMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveAboutDialogMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAboutDialogMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveAboutDialogMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveAboutDialogMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveAboutDialogMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveAboutDialogMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveAboutDialogMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveAboutDialogMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveAboutDialogMethod "getApplication" o = Gtk.Window.WindowGetApplicationMethodInfo
    ResolveAboutDialogMethod "getArtists" o = AboutDialogGetArtistsMethodInfo
    ResolveAboutDialogMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveAboutDialogMethod "getAuthors" o = AboutDialogGetAuthorsMethodInfo
    ResolveAboutDialogMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveAboutDialogMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveAboutDialogMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveAboutDialogMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveAboutDialogMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveAboutDialogMethod "getChild" o = Gtk.Window.WindowGetChildMethodInfo
    ResolveAboutDialogMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveAboutDialogMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveAboutDialogMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveAboutDialogMethod "getComments" o = AboutDialogGetCommentsMethodInfo
    ResolveAboutDialogMethod "getCopyright" o = AboutDialogGetCopyrightMethodInfo
    ResolveAboutDialogMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveAboutDialogMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveAboutDialogMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveAboutDialogMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAboutDialogMethod "getDecorated" o = Gtk.Window.WindowGetDecoratedMethodInfo
    ResolveAboutDialogMethod "getDefaultSize" o = Gtk.Window.WindowGetDefaultSizeMethodInfo
    ResolveAboutDialogMethod "getDefaultWidget" o = Gtk.Window.WindowGetDefaultWidgetMethodInfo
    ResolveAboutDialogMethod "getDeletable" o = Gtk.Window.WindowGetDeletableMethodInfo
    ResolveAboutDialogMethod "getDestroyWithParent" o = Gtk.Window.WindowGetDestroyWithParentMethodInfo
    ResolveAboutDialogMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveAboutDialogMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveAboutDialogMethod "getDocumenters" o = AboutDialogGetDocumentersMethodInfo
    ResolveAboutDialogMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveAboutDialogMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveAboutDialogMethod "getFocus" o = Gtk.Window.WindowGetFocusMethodInfo
    ResolveAboutDialogMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveAboutDialogMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveAboutDialogMethod "getFocusVisible" o = Gtk.Window.WindowGetFocusVisibleMethodInfo
    ResolveAboutDialogMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveAboutDialogMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveAboutDialogMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveAboutDialogMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveAboutDialogMethod "getGravity" o = Gtk.Window.WindowGetGravityMethodInfo
    ResolveAboutDialogMethod "getGroup" o = Gtk.Window.WindowGetGroupMethodInfo
    ResolveAboutDialogMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveAboutDialogMethod "getHandleMenubarAccel" o = Gtk.Window.WindowGetHandleMenubarAccelMethodInfo
    ResolveAboutDialogMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveAboutDialogMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveAboutDialogMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveAboutDialogMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveAboutDialogMethod "getHideOnClose" o = Gtk.Window.WindowGetHideOnCloseMethodInfo
    ResolveAboutDialogMethod "getIconName" o = Gtk.Window.WindowGetIconNameMethodInfo
    ResolveAboutDialogMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveAboutDialogMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveAboutDialogMethod "getLicense" o = AboutDialogGetLicenseMethodInfo
    ResolveAboutDialogMethod "getLicenseType" o = AboutDialogGetLicenseTypeMethodInfo
    ResolveAboutDialogMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveAboutDialogMethod "getLogo" o = AboutDialogGetLogoMethodInfo
    ResolveAboutDialogMethod "getLogoIconName" o = AboutDialogGetLogoIconNameMethodInfo
    ResolveAboutDialogMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveAboutDialogMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveAboutDialogMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveAboutDialogMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveAboutDialogMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveAboutDialogMethod "getMnemonicsVisible" o = Gtk.Window.WindowGetMnemonicsVisibleMethodInfo
    ResolveAboutDialogMethod "getModal" o = Gtk.Window.WindowGetModalMethodInfo
    ResolveAboutDialogMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveAboutDialogMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveAboutDialogMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveAboutDialogMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveAboutDialogMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveAboutDialogMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveAboutDialogMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveAboutDialogMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveAboutDialogMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveAboutDialogMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveAboutDialogMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveAboutDialogMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveAboutDialogMethod "getProgramName" o = AboutDialogGetProgramNameMethodInfo
    ResolveAboutDialogMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAboutDialogMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAboutDialogMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveAboutDialogMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveAboutDialogMethod "getRenderer" o = Gtk.Native.NativeGetRendererMethodInfo
    ResolveAboutDialogMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveAboutDialogMethod "getResizable" o = Gtk.Window.WindowGetResizableMethodInfo
    ResolveAboutDialogMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveAboutDialogMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveAboutDialogMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveAboutDialogMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveAboutDialogMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveAboutDialogMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveAboutDialogMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveAboutDialogMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveAboutDialogMethod "getSurface" o = Gtk.Native.NativeGetSurfaceMethodInfo
    ResolveAboutDialogMethod "getSurfaceTransform" o = Gtk.Native.NativeGetSurfaceTransformMethodInfo
    ResolveAboutDialogMethod "getSystemInformation" o = AboutDialogGetSystemInformationMethodInfo
    ResolveAboutDialogMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveAboutDialogMethod "getTitle" o = Gtk.Window.WindowGetTitleMethodInfo
    ResolveAboutDialogMethod "getTitlebar" o = Gtk.Window.WindowGetTitlebarMethodInfo
    ResolveAboutDialogMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveAboutDialogMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveAboutDialogMethod "getTransientFor" o = Gtk.Window.WindowGetTransientForMethodInfo
    ResolveAboutDialogMethod "getTranslatorCredits" o = AboutDialogGetTranslatorCreditsMethodInfo
    ResolveAboutDialogMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveAboutDialogMethod "getVersion" o = AboutDialogGetVersionMethodInfo
    ResolveAboutDialogMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveAboutDialogMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveAboutDialogMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveAboutDialogMethod "getWebsite" o = AboutDialogGetWebsiteMethodInfo
    ResolveAboutDialogMethod "getWebsiteLabel" o = AboutDialogGetWebsiteLabelMethodInfo
    ResolveAboutDialogMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveAboutDialogMethod "getWrapLicense" o = AboutDialogGetWrapLicenseMethodInfo
    ResolveAboutDialogMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveAboutDialogMethod "setApplication" o = Gtk.Window.WindowSetApplicationMethodInfo
    ResolveAboutDialogMethod "setArtists" o = AboutDialogSetArtistsMethodInfo
    ResolveAboutDialogMethod "setAuthors" o = AboutDialogSetAuthorsMethodInfo
    ResolveAboutDialogMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveAboutDialogMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveAboutDialogMethod "setChild" o = Gtk.Window.WindowSetChildMethodInfo
    ResolveAboutDialogMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveAboutDialogMethod "setComments" o = AboutDialogSetCommentsMethodInfo
    ResolveAboutDialogMethod "setCopyright" o = AboutDialogSetCopyrightMethodInfo
    ResolveAboutDialogMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveAboutDialogMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveAboutDialogMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveAboutDialogMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAboutDialogMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAboutDialogMethod "setDecorated" o = Gtk.Window.WindowSetDecoratedMethodInfo
    ResolveAboutDialogMethod "setDefaultSize" o = Gtk.Window.WindowSetDefaultSizeMethodInfo
    ResolveAboutDialogMethod "setDefaultWidget" o = Gtk.Window.WindowSetDefaultWidgetMethodInfo
    ResolveAboutDialogMethod "setDeletable" o = Gtk.Window.WindowSetDeletableMethodInfo
    ResolveAboutDialogMethod "setDestroyWithParent" o = Gtk.Window.WindowSetDestroyWithParentMethodInfo
    ResolveAboutDialogMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveAboutDialogMethod "setDisplay" o = Gtk.Window.WindowSetDisplayMethodInfo
    ResolveAboutDialogMethod "setDocumenters" o = AboutDialogSetDocumentersMethodInfo
    ResolveAboutDialogMethod "setFocus" o = Gtk.Window.WindowSetFocusMethodInfo
    ResolveAboutDialogMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveAboutDialogMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveAboutDialogMethod "setFocusVisible" o = Gtk.Window.WindowSetFocusVisibleMethodInfo
    ResolveAboutDialogMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveAboutDialogMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveAboutDialogMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveAboutDialogMethod "setGravity" o = Gtk.Window.WindowSetGravityMethodInfo
    ResolveAboutDialogMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveAboutDialogMethod "setHandleMenubarAccel" o = Gtk.Window.WindowSetHandleMenubarAccelMethodInfo
    ResolveAboutDialogMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveAboutDialogMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveAboutDialogMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveAboutDialogMethod "setHideOnClose" o = Gtk.Window.WindowSetHideOnCloseMethodInfo
    ResolveAboutDialogMethod "setIconName" o = Gtk.Window.WindowSetIconNameMethodInfo
    ResolveAboutDialogMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveAboutDialogMethod "setLicense" o = AboutDialogSetLicenseMethodInfo
    ResolveAboutDialogMethod "setLicenseType" o = AboutDialogSetLicenseTypeMethodInfo
    ResolveAboutDialogMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveAboutDialogMethod "setLogo" o = AboutDialogSetLogoMethodInfo
    ResolveAboutDialogMethod "setLogoIconName" o = AboutDialogSetLogoIconNameMethodInfo
    ResolveAboutDialogMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveAboutDialogMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveAboutDialogMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveAboutDialogMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveAboutDialogMethod "setMnemonicsVisible" o = Gtk.Window.WindowSetMnemonicsVisibleMethodInfo
    ResolveAboutDialogMethod "setModal" o = Gtk.Window.WindowSetModalMethodInfo
    ResolveAboutDialogMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveAboutDialogMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveAboutDialogMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveAboutDialogMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveAboutDialogMethod "setProgramName" o = AboutDialogSetProgramNameMethodInfo
    ResolveAboutDialogMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAboutDialogMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveAboutDialogMethod "setResizable" o = Gtk.Window.WindowSetResizableMethodInfo
    ResolveAboutDialogMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveAboutDialogMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveAboutDialogMethod "setStartupId" o = Gtk.Window.WindowSetStartupIdMethodInfo
    ResolveAboutDialogMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveAboutDialogMethod "setSystemInformation" o = AboutDialogSetSystemInformationMethodInfo
    ResolveAboutDialogMethod "setTitle" o = Gtk.Window.WindowSetTitleMethodInfo
    ResolveAboutDialogMethod "setTitlebar" o = Gtk.Window.WindowSetTitlebarMethodInfo
    ResolveAboutDialogMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveAboutDialogMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveAboutDialogMethod "setTransientFor" o = Gtk.Window.WindowSetTransientForMethodInfo
    ResolveAboutDialogMethod "setTranslatorCredits" o = AboutDialogSetTranslatorCreditsMethodInfo
    ResolveAboutDialogMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveAboutDialogMethod "setVersion" o = AboutDialogSetVersionMethodInfo
    ResolveAboutDialogMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveAboutDialogMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveAboutDialogMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveAboutDialogMethod "setWebsite" o = AboutDialogSetWebsiteMethodInfo
    ResolveAboutDialogMethod "setWebsiteLabel" o = AboutDialogSetWebsiteLabelMethodInfo
    ResolveAboutDialogMethod "setWrapLicense" o = AboutDialogSetWrapLicenseMethodInfo
    ResolveAboutDialogMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAboutDialogMethod t AboutDialog, O.OverloadedMethod info AboutDialog p) => OL.IsLabel t (AboutDialog -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAboutDialogMethod t AboutDialog, O.OverloadedMethod info AboutDialog p, R.HasField t AboutDialog p) => R.HasField t AboutDialog p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAboutDialogMethod t AboutDialog, O.OverloadedMethodInfo info AboutDialog) => OL.IsLabel t (O.MethodProxy info AboutDialog) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal AboutDialog::activate-link
-- | Emitted every time a URL is activated.
-- 
-- Applications may connect to it to override the default behaviour,
-- which is to call 'GI.Gtk.Objects.FileLauncher.fileLauncherLaunch'.
type AboutDialogActivateLinkCallback =
    T.Text
    -- ^ /@uri@/: the URI that is activated
    -> IO Bool
    -- ^ __Returns:__ @TRUE@ if the link has been activated

type C_AboutDialogActivateLinkCallback =
    Ptr AboutDialog ->                      -- object
    CString ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_AboutDialogActivateLinkCallback`.
foreign import ccall "wrapper"
    mk_AboutDialogActivateLinkCallback :: C_AboutDialogActivateLinkCallback -> IO (FunPtr C_AboutDialogActivateLinkCallback)

wrap_AboutDialogActivateLinkCallback :: 
    GObject a => (a -> AboutDialogActivateLinkCallback) ->
    C_AboutDialogActivateLinkCallback
wrap_AboutDialogActivateLinkCallback gi'cb gi'selfPtr uri _ = do
    uri' <- cstringToText uri
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  uri'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [activateLink](#signal:activateLink) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' aboutDialog #activateLink callback
-- @
-- 
-- 
onAboutDialogActivateLink :: (IsAboutDialog a, MonadIO m) => a -> ((?self :: a) => AboutDialogActivateLinkCallback) -> m SignalHandlerId
onAboutDialogActivateLink obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AboutDialogActivateLinkCallback wrapped
    wrapped'' <- mk_AboutDialogActivateLinkCallback wrapped'
    connectSignalFunPtr obj "activate-link" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [activateLink](#signal:activateLink) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' aboutDialog #activateLink callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterAboutDialogActivateLink :: (IsAboutDialog a, MonadIO m) => a -> ((?self :: a) => AboutDialogActivateLinkCallback) -> m SignalHandlerId
afterAboutDialogActivateLink obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_AboutDialogActivateLinkCallback wrapped
    wrapped'' <- mk_AboutDialogActivateLinkCallback wrapped'
    connectSignalFunPtr obj "activate-link" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data AboutDialogActivateLinkSignalInfo
instance SignalInfo AboutDialogActivateLinkSignalInfo where
    type HaskellCallbackType AboutDialogActivateLinkSignalInfo = AboutDialogActivateLinkCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_AboutDialogActivateLinkCallback cb
        cb'' <- mk_AboutDialogActivateLinkCallback cb'
        connectSignalFunPtr obj "activate-link" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog::activate-link"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:signal:activateLink"})

#endif

-- VVV Prop "artists"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@artists@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #artists
-- @
getAboutDialogArtists :: (MonadIO m, IsAboutDialog o) => o -> m [T.Text]
getAboutDialogArtists obj = MIO.liftIO $ checkUnexpectedNothing "getAboutDialogArtists" $ B.Properties.getObjectPropertyStringArray obj "artists"

-- | Set the value of the “@artists@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #artists 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogArtists :: (MonadIO m, IsAboutDialog o) => o -> [T.Text] -> m ()
setAboutDialogArtists obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "artists" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@artists@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogArtists :: (IsAboutDialog o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructAboutDialogArtists val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "artists" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AboutDialogArtistsPropertyInfo
instance AttrInfo AboutDialogArtistsPropertyInfo where
    type AttrAllowedOps AboutDialogArtistsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AboutDialogArtistsPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogArtistsPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint AboutDialogArtistsPropertyInfo = (~) [T.Text]
    type AttrTransferType AboutDialogArtistsPropertyInfo = [T.Text]
    type AttrGetType AboutDialogArtistsPropertyInfo = [T.Text]
    type AttrLabel AboutDialogArtistsPropertyInfo = "artists"
    type AttrOrigin AboutDialogArtistsPropertyInfo = AboutDialog
    attrGet = getAboutDialogArtists
    attrSet = setAboutDialogArtists
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogArtists
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.artists"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:artists"
        })
#endif

-- VVV Prop "authors"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@authors@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #authors
-- @
getAboutDialogAuthors :: (MonadIO m, IsAboutDialog o) => o -> m [T.Text]
getAboutDialogAuthors obj = MIO.liftIO $ checkUnexpectedNothing "getAboutDialogAuthors" $ B.Properties.getObjectPropertyStringArray obj "authors"

-- | Set the value of the “@authors@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #authors 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogAuthors :: (MonadIO m, IsAboutDialog o) => o -> [T.Text] -> m ()
setAboutDialogAuthors obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "authors" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@authors@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogAuthors :: (IsAboutDialog o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructAboutDialogAuthors val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "authors" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AboutDialogAuthorsPropertyInfo
instance AttrInfo AboutDialogAuthorsPropertyInfo where
    type AttrAllowedOps AboutDialogAuthorsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AboutDialogAuthorsPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogAuthorsPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint AboutDialogAuthorsPropertyInfo = (~) [T.Text]
    type AttrTransferType AboutDialogAuthorsPropertyInfo = [T.Text]
    type AttrGetType AboutDialogAuthorsPropertyInfo = [T.Text]
    type AttrLabel AboutDialogAuthorsPropertyInfo = "authors"
    type AttrOrigin AboutDialogAuthorsPropertyInfo = AboutDialog
    attrGet = getAboutDialogAuthors
    attrSet = setAboutDialogAuthors
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogAuthors
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.authors"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:authors"
        })
#endif

-- VVV Prop "comments"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@comments@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #comments
-- @
getAboutDialogComments :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogComments obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "comments"

-- | Set the value of the “@comments@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #comments 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogComments :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogComments obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "comments" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@comments@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogComments :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogComments val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "comments" (P.Just val)

-- | Set the value of the “@comments@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #comments
-- @
clearAboutDialogComments :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogComments obj = liftIO $ B.Properties.setObjectPropertyString obj "comments" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogCommentsPropertyInfo
instance AttrInfo AboutDialogCommentsPropertyInfo where
    type AttrAllowedOps AboutDialogCommentsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogCommentsPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogCommentsPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogCommentsPropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogCommentsPropertyInfo = T.Text
    type AttrGetType AboutDialogCommentsPropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogCommentsPropertyInfo = "comments"
    type AttrOrigin AboutDialogCommentsPropertyInfo = AboutDialog
    attrGet = getAboutDialogComments
    attrSet = setAboutDialogComments
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogComments
    attrClear = clearAboutDialogComments
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.comments"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:comments"
        })
#endif

-- VVV Prop "copyright"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@copyright@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #copyright
-- @
getAboutDialogCopyright :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogCopyright obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "copyright"

-- | Set the value of the “@copyright@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #copyright 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogCopyright :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogCopyright obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "copyright" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@copyright@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogCopyright :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogCopyright val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "copyright" (P.Just val)

-- | Set the value of the “@copyright@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #copyright
-- @
clearAboutDialogCopyright :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogCopyright obj = liftIO $ B.Properties.setObjectPropertyString obj "copyright" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogCopyrightPropertyInfo
instance AttrInfo AboutDialogCopyrightPropertyInfo where
    type AttrAllowedOps AboutDialogCopyrightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogCopyrightPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogCopyrightPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogCopyrightPropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogCopyrightPropertyInfo = T.Text
    type AttrGetType AboutDialogCopyrightPropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogCopyrightPropertyInfo = "copyright"
    type AttrOrigin AboutDialogCopyrightPropertyInfo = AboutDialog
    attrGet = getAboutDialogCopyright
    attrSet = setAboutDialogCopyright
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogCopyright
    attrClear = clearAboutDialogCopyright
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.copyright"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:copyright"
        })
#endif

-- VVV Prop "documenters"
   -- Type: TCArray True (-1) (-1) (TBasicType TUTF8)
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@documenters@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #documenters
-- @
getAboutDialogDocumenters :: (MonadIO m, IsAboutDialog o) => o -> m [T.Text]
getAboutDialogDocumenters obj = MIO.liftIO $ checkUnexpectedNothing "getAboutDialogDocumenters" $ B.Properties.getObjectPropertyStringArray obj "documenters"

-- | Set the value of the “@documenters@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #documenters 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogDocumenters :: (MonadIO m, IsAboutDialog o) => o -> [T.Text] -> m ()
setAboutDialogDocumenters obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyStringArray obj "documenters" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@documenters@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogDocumenters :: (IsAboutDialog o, MIO.MonadIO m) => [T.Text] -> m (GValueConstruct o)
constructAboutDialogDocumenters val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyStringArray "documenters" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AboutDialogDocumentersPropertyInfo
instance AttrInfo AboutDialogDocumentersPropertyInfo where
    type AttrAllowedOps AboutDialogDocumentersPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AboutDialogDocumentersPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogDocumentersPropertyInfo = (~) [T.Text]
    type AttrTransferTypeConstraint AboutDialogDocumentersPropertyInfo = (~) [T.Text]
    type AttrTransferType AboutDialogDocumentersPropertyInfo = [T.Text]
    type AttrGetType AboutDialogDocumentersPropertyInfo = [T.Text]
    type AttrLabel AboutDialogDocumentersPropertyInfo = "documenters"
    type AttrOrigin AboutDialogDocumentersPropertyInfo = AboutDialog
    attrGet = getAboutDialogDocumenters
    attrSet = setAboutDialogDocumenters
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogDocumenters
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.documenters"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:documenters"
        })
#endif

-- VVV Prop "license"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@license@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #license
-- @
getAboutDialogLicense :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogLicense obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "license"

-- | Set the value of the “@license@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #license 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogLicense :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogLicense obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "license" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@license@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogLicense :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogLicense val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "license" (P.Just val)

-- | Set the value of the “@license@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #license
-- @
clearAboutDialogLicense :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogLicense obj = liftIO $ B.Properties.setObjectPropertyString obj "license" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogLicensePropertyInfo
instance AttrInfo AboutDialogLicensePropertyInfo where
    type AttrAllowedOps AboutDialogLicensePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogLicensePropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogLicensePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogLicensePropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogLicensePropertyInfo = T.Text
    type AttrGetType AboutDialogLicensePropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogLicensePropertyInfo = "license"
    type AttrOrigin AboutDialogLicensePropertyInfo = AboutDialog
    attrGet = getAboutDialogLicense
    attrSet = setAboutDialogLicense
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogLicense
    attrClear = clearAboutDialogLicense
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.license"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:license"
        })
#endif

-- VVV Prop "license-type"
   -- Type: TInterface (Name {namespace = "Gtk", name = "License"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@license-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #licenseType
-- @
getAboutDialogLicenseType :: (MonadIO m, IsAboutDialog o) => o -> m Gtk.Enums.License
getAboutDialogLicenseType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "license-type"

-- | Set the value of the “@license-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #licenseType 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogLicenseType :: (MonadIO m, IsAboutDialog o) => o -> Gtk.Enums.License -> m ()
setAboutDialogLicenseType obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "license-type" val

-- | Construct a t'GValueConstruct' with valid value for the “@license-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogLicenseType :: (IsAboutDialog o, MIO.MonadIO m) => Gtk.Enums.License -> m (GValueConstruct o)
constructAboutDialogLicenseType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "license-type" val

#if defined(ENABLE_OVERLOADING)
data AboutDialogLicenseTypePropertyInfo
instance AttrInfo AboutDialogLicenseTypePropertyInfo where
    type AttrAllowedOps AboutDialogLicenseTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AboutDialogLicenseTypePropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogLicenseTypePropertyInfo = (~) Gtk.Enums.License
    type AttrTransferTypeConstraint AboutDialogLicenseTypePropertyInfo = (~) Gtk.Enums.License
    type AttrTransferType AboutDialogLicenseTypePropertyInfo = Gtk.Enums.License
    type AttrGetType AboutDialogLicenseTypePropertyInfo = Gtk.Enums.License
    type AttrLabel AboutDialogLicenseTypePropertyInfo = "license-type"
    type AttrOrigin AboutDialogLicenseTypePropertyInfo = AboutDialog
    attrGet = getAboutDialogLicenseType
    attrSet = setAboutDialogLicenseType
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogLicenseType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.licenseType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:licenseType"
        })
#endif

-- VVV Prop "logo"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Paintable"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@logo@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #logo
-- @
getAboutDialogLogo :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe Gdk.Paintable.Paintable)
getAboutDialogLogo obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "logo" Gdk.Paintable.Paintable

-- | Set the value of the “@logo@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #logo 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogLogo :: (MonadIO m, IsAboutDialog o, Gdk.Paintable.IsPaintable a) => o -> a -> m ()
setAboutDialogLogo obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "logo" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@logo@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogLogo :: (IsAboutDialog o, MIO.MonadIO m, Gdk.Paintable.IsPaintable a) => a -> m (GValueConstruct o)
constructAboutDialogLogo val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "logo" (P.Just val)

-- | Set the value of the “@logo@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #logo
-- @
clearAboutDialogLogo :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogLogo obj = liftIO $ B.Properties.setObjectPropertyObject obj "logo" (Nothing :: Maybe Gdk.Paintable.Paintable)

#if defined(ENABLE_OVERLOADING)
data AboutDialogLogoPropertyInfo
instance AttrInfo AboutDialogLogoPropertyInfo where
    type AttrAllowedOps AboutDialogLogoPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogLogoPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogLogoPropertyInfo = Gdk.Paintable.IsPaintable
    type AttrTransferTypeConstraint AboutDialogLogoPropertyInfo = Gdk.Paintable.IsPaintable
    type AttrTransferType AboutDialogLogoPropertyInfo = Gdk.Paintable.Paintable
    type AttrGetType AboutDialogLogoPropertyInfo = (Maybe Gdk.Paintable.Paintable)
    type AttrLabel AboutDialogLogoPropertyInfo = "logo"
    type AttrOrigin AboutDialogLogoPropertyInfo = AboutDialog
    attrGet = getAboutDialogLogo
    attrSet = setAboutDialogLogo
    attrTransfer _ v = do
        unsafeCastTo Gdk.Paintable.Paintable v
    attrConstruct = constructAboutDialogLogo
    attrClear = clearAboutDialogLogo
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.logo"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:logo"
        })
#endif

-- VVV Prop "logo-icon-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@logo-icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #logoIconName
-- @
getAboutDialogLogoIconName :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogLogoIconName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "logo-icon-name"

-- | Set the value of the “@logo-icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #logoIconName 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogLogoIconName :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogLogoIconName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "logo-icon-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@logo-icon-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogLogoIconName :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogLogoIconName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "logo-icon-name" (P.Just val)

-- | Set the value of the “@logo-icon-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #logoIconName
-- @
clearAboutDialogLogoIconName :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogLogoIconName obj = liftIO $ B.Properties.setObjectPropertyString obj "logo-icon-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogLogoIconNamePropertyInfo
instance AttrInfo AboutDialogLogoIconNamePropertyInfo where
    type AttrAllowedOps AboutDialogLogoIconNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogLogoIconNamePropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogLogoIconNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogLogoIconNamePropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogLogoIconNamePropertyInfo = T.Text
    type AttrGetType AboutDialogLogoIconNamePropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogLogoIconNamePropertyInfo = "logo-icon-name"
    type AttrOrigin AboutDialogLogoIconNamePropertyInfo = AboutDialog
    attrGet = getAboutDialogLogoIconName
    attrSet = setAboutDialogLogoIconName
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogLogoIconName
    attrClear = clearAboutDialogLogoIconName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.logoIconName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:logoIconName"
        })
#endif

-- VVV Prop "program-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@program-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #programName
-- @
getAboutDialogProgramName :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogProgramName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "program-name"

-- | Set the value of the “@program-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #programName 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogProgramName :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogProgramName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "program-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@program-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogProgramName :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogProgramName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "program-name" (P.Just val)

-- | Set the value of the “@program-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #programName
-- @
clearAboutDialogProgramName :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogProgramName obj = liftIO $ B.Properties.setObjectPropertyString obj "program-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogProgramNamePropertyInfo
instance AttrInfo AboutDialogProgramNamePropertyInfo where
    type AttrAllowedOps AboutDialogProgramNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogProgramNamePropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogProgramNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogProgramNamePropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogProgramNamePropertyInfo = T.Text
    type AttrGetType AboutDialogProgramNamePropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogProgramNamePropertyInfo = "program-name"
    type AttrOrigin AboutDialogProgramNamePropertyInfo = AboutDialog
    attrGet = getAboutDialogProgramName
    attrSet = setAboutDialogProgramName
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogProgramName
    attrClear = clearAboutDialogProgramName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.programName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:programName"
        })
#endif

-- VVV Prop "system-information"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@system-information@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #systemInformation
-- @
getAboutDialogSystemInformation :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogSystemInformation obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "system-information"

-- | Set the value of the “@system-information@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #systemInformation 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogSystemInformation :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogSystemInformation obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "system-information" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@system-information@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogSystemInformation :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogSystemInformation val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "system-information" (P.Just val)

-- | Set the value of the “@system-information@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #systemInformation
-- @
clearAboutDialogSystemInformation :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogSystemInformation obj = liftIO $ B.Properties.setObjectPropertyString obj "system-information" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogSystemInformationPropertyInfo
instance AttrInfo AboutDialogSystemInformationPropertyInfo where
    type AttrAllowedOps AboutDialogSystemInformationPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogSystemInformationPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogSystemInformationPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogSystemInformationPropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogSystemInformationPropertyInfo = T.Text
    type AttrGetType AboutDialogSystemInformationPropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogSystemInformationPropertyInfo = "system-information"
    type AttrOrigin AboutDialogSystemInformationPropertyInfo = AboutDialog
    attrGet = getAboutDialogSystemInformation
    attrSet = setAboutDialogSystemInformation
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogSystemInformation
    attrClear = clearAboutDialogSystemInformation
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.systemInformation"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:systemInformation"
        })
#endif

-- VVV Prop "translator-credits"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@translator-credits@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #translatorCredits
-- @
getAboutDialogTranslatorCredits :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogTranslatorCredits obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "translator-credits"

-- | Set the value of the “@translator-credits@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #translatorCredits 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogTranslatorCredits :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogTranslatorCredits obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "translator-credits" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@translator-credits@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogTranslatorCredits :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogTranslatorCredits val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "translator-credits" (P.Just val)

-- | Set the value of the “@translator-credits@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #translatorCredits
-- @
clearAboutDialogTranslatorCredits :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogTranslatorCredits obj = liftIO $ B.Properties.setObjectPropertyString obj "translator-credits" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogTranslatorCreditsPropertyInfo
instance AttrInfo AboutDialogTranslatorCreditsPropertyInfo where
    type AttrAllowedOps AboutDialogTranslatorCreditsPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogTranslatorCreditsPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogTranslatorCreditsPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogTranslatorCreditsPropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogTranslatorCreditsPropertyInfo = T.Text
    type AttrGetType AboutDialogTranslatorCreditsPropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogTranslatorCreditsPropertyInfo = "translator-credits"
    type AttrOrigin AboutDialogTranslatorCreditsPropertyInfo = AboutDialog
    attrGet = getAboutDialogTranslatorCredits
    attrSet = setAboutDialogTranslatorCredits
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogTranslatorCredits
    attrClear = clearAboutDialogTranslatorCredits
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.translatorCredits"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:translatorCredits"
        })
#endif

-- VVV Prop "version"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@version@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #version
-- @
getAboutDialogVersion :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogVersion obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "version"

-- | Set the value of the “@version@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #version 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogVersion :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogVersion obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "version" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@version@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogVersion :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogVersion val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "version" (P.Just val)

-- | Set the value of the “@version@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #version
-- @
clearAboutDialogVersion :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogVersion obj = liftIO $ B.Properties.setObjectPropertyString obj "version" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogVersionPropertyInfo
instance AttrInfo AboutDialogVersionPropertyInfo where
    type AttrAllowedOps AboutDialogVersionPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogVersionPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogVersionPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogVersionPropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogVersionPropertyInfo = T.Text
    type AttrGetType AboutDialogVersionPropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogVersionPropertyInfo = "version"
    type AttrOrigin AboutDialogVersionPropertyInfo = AboutDialog
    attrGet = getAboutDialogVersion
    attrSet = setAboutDialogVersion
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogVersion
    attrClear = clearAboutDialogVersion
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.version"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:version"
        })
#endif

-- VVV Prop "website"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@website@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #website
-- @
getAboutDialogWebsite :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogWebsite obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "website"

-- | Set the value of the “@website@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #website 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogWebsite :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogWebsite obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "website" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@website@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogWebsite :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogWebsite val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "website" (P.Just val)

-- | Set the value of the “@website@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #website
-- @
clearAboutDialogWebsite :: (MonadIO m, IsAboutDialog o) => o -> m ()
clearAboutDialogWebsite obj = liftIO $ B.Properties.setObjectPropertyString obj "website" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AboutDialogWebsitePropertyInfo
instance AttrInfo AboutDialogWebsitePropertyInfo where
    type AttrAllowedOps AboutDialogWebsitePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AboutDialogWebsitePropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogWebsitePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogWebsitePropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogWebsitePropertyInfo = T.Text
    type AttrGetType AboutDialogWebsitePropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogWebsitePropertyInfo = "website"
    type AttrOrigin AboutDialogWebsitePropertyInfo = AboutDialog
    attrGet = getAboutDialogWebsite
    attrSet = setAboutDialogWebsite
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogWebsite
    attrClear = clearAboutDialogWebsite
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.website"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:website"
        })
#endif

-- VVV Prop "website-label"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just False)

-- | Get the value of the “@website-label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #websiteLabel
-- @
getAboutDialogWebsiteLabel :: (MonadIO m, IsAboutDialog o) => o -> m (Maybe T.Text)
getAboutDialogWebsiteLabel obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "website-label"

-- | Set the value of the “@website-label@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #websiteLabel 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogWebsiteLabel :: (MonadIO m, IsAboutDialog o) => o -> T.Text -> m ()
setAboutDialogWebsiteLabel obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "website-label" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@website-label@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogWebsiteLabel :: (IsAboutDialog o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAboutDialogWebsiteLabel val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "website-label" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AboutDialogWebsiteLabelPropertyInfo
instance AttrInfo AboutDialogWebsiteLabelPropertyInfo where
    type AttrAllowedOps AboutDialogWebsiteLabelPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AboutDialogWebsiteLabelPropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogWebsiteLabelPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AboutDialogWebsiteLabelPropertyInfo = (~) T.Text
    type AttrTransferType AboutDialogWebsiteLabelPropertyInfo = T.Text
    type AttrGetType AboutDialogWebsiteLabelPropertyInfo = (Maybe T.Text)
    type AttrLabel AboutDialogWebsiteLabelPropertyInfo = "website-label"
    type AttrOrigin AboutDialogWebsiteLabelPropertyInfo = AboutDialog
    attrGet = getAboutDialogWebsiteLabel
    attrSet = setAboutDialogWebsiteLabel
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogWebsiteLabel
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.websiteLabel"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:websiteLabel"
        })
#endif

-- VVV Prop "wrap-license"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@wrap-license@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' aboutDialog #wrapLicense
-- @
getAboutDialogWrapLicense :: (MonadIO m, IsAboutDialog o) => o -> m Bool
getAboutDialogWrapLicense obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "wrap-license"

-- | Set the value of the “@wrap-license@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' aboutDialog [ #wrapLicense 'Data.GI.Base.Attributes.:=' value ]
-- @
setAboutDialogWrapLicense :: (MonadIO m, IsAboutDialog o) => o -> Bool -> m ()
setAboutDialogWrapLicense obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "wrap-license" val

-- | Construct a t'GValueConstruct' with valid value for the “@wrap-license@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAboutDialogWrapLicense :: (IsAboutDialog o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAboutDialogWrapLicense val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "wrap-license" val

#if defined(ENABLE_OVERLOADING)
data AboutDialogWrapLicensePropertyInfo
instance AttrInfo AboutDialogWrapLicensePropertyInfo where
    type AttrAllowedOps AboutDialogWrapLicensePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint AboutDialogWrapLicensePropertyInfo = IsAboutDialog
    type AttrSetTypeConstraint AboutDialogWrapLicensePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AboutDialogWrapLicensePropertyInfo = (~) Bool
    type AttrTransferType AboutDialogWrapLicensePropertyInfo = Bool
    type AttrGetType AboutDialogWrapLicensePropertyInfo = Bool
    type AttrLabel AboutDialogWrapLicensePropertyInfo = "wrap-license"
    type AttrOrigin AboutDialogWrapLicensePropertyInfo = AboutDialog
    attrGet = getAboutDialogWrapLicense
    attrSet = setAboutDialogWrapLicense
    attrTransfer _ v = do
        return v
    attrConstruct = constructAboutDialogWrapLicense
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.wrapLicense"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#g:attr:wrapLicense"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AboutDialog
type instance O.AttributeList AboutDialog = AboutDialogAttributeList
type AboutDialogAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("application", Gtk.Window.WindowApplicationPropertyInfo), '("artists", AboutDialogArtistsPropertyInfo), '("authors", AboutDialogAuthorsPropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", Gtk.Window.WindowChildPropertyInfo), '("comments", AboutDialogCommentsPropertyInfo), '("copyright", AboutDialogCopyrightPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("decorated", Gtk.Window.WindowDecoratedPropertyInfo), '("defaultHeight", Gtk.Window.WindowDefaultHeightPropertyInfo), '("defaultWidget", Gtk.Window.WindowDefaultWidgetPropertyInfo), '("defaultWidth", Gtk.Window.WindowDefaultWidthPropertyInfo), '("deletable", Gtk.Window.WindowDeletablePropertyInfo), '("destroyWithParent", Gtk.Window.WindowDestroyWithParentPropertyInfo), '("display", Gtk.Window.WindowDisplayPropertyInfo), '("documenters", AboutDialogDocumentersPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusVisible", Gtk.Window.WindowFocusVisiblePropertyInfo), '("focusWidget", Gtk.Window.WindowFocusWidgetPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("fullscreened", Gtk.Window.WindowFullscreenedPropertyInfo), '("gravity", Gtk.Window.WindowGravityPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("handleMenubarAccel", Gtk.Window.WindowHandleMenubarAccelPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hideOnClose", Gtk.Window.WindowHideOnClosePropertyInfo), '("iconName", Gtk.Window.WindowIconNamePropertyInfo), '("isActive", Gtk.Window.WindowIsActivePropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("license", AboutDialogLicensePropertyInfo), '("licenseType", AboutDialogLicenseTypePropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("logo", AboutDialogLogoPropertyInfo), '("logoIconName", AboutDialogLogoIconNamePropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maximized", Gtk.Window.WindowMaximizedPropertyInfo), '("mnemonicsVisible", Gtk.Window.WindowMnemonicsVisiblePropertyInfo), '("modal", Gtk.Window.WindowModalPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("programName", AboutDialogProgramNamePropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("resizable", Gtk.Window.WindowResizablePropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("startupId", Gtk.Window.WindowStartupIdPropertyInfo), '("suspended", Gtk.Window.WindowSuspendedPropertyInfo), '("systemInformation", AboutDialogSystemInformationPropertyInfo), '("title", Gtk.Window.WindowTitlePropertyInfo), '("titlebar", Gtk.Window.WindowTitlebarPropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("transientFor", Gtk.Window.WindowTransientForPropertyInfo), '("translatorCredits", AboutDialogTranslatorCreditsPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("version", AboutDialogVersionPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("website", AboutDialogWebsitePropertyInfo), '("websiteLabel", AboutDialogWebsiteLabelPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("wrapLicense", AboutDialogWrapLicensePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
aboutDialogArtists :: AttrLabelProxy "artists"
aboutDialogArtists = AttrLabelProxy

aboutDialogAuthors :: AttrLabelProxy "authors"
aboutDialogAuthors = AttrLabelProxy

aboutDialogComments :: AttrLabelProxy "comments"
aboutDialogComments = AttrLabelProxy

aboutDialogCopyright :: AttrLabelProxy "copyright"
aboutDialogCopyright = AttrLabelProxy

aboutDialogDocumenters :: AttrLabelProxy "documenters"
aboutDialogDocumenters = AttrLabelProxy

aboutDialogLicense :: AttrLabelProxy "license"
aboutDialogLicense = AttrLabelProxy

aboutDialogLicenseType :: AttrLabelProxy "licenseType"
aboutDialogLicenseType = AttrLabelProxy

aboutDialogLogo :: AttrLabelProxy "logo"
aboutDialogLogo = AttrLabelProxy

aboutDialogLogoIconName :: AttrLabelProxy "logoIconName"
aboutDialogLogoIconName = AttrLabelProxy

aboutDialogProgramName :: AttrLabelProxy "programName"
aboutDialogProgramName = AttrLabelProxy

aboutDialogSystemInformation :: AttrLabelProxy "systemInformation"
aboutDialogSystemInformation = AttrLabelProxy

aboutDialogTranslatorCredits :: AttrLabelProxy "translatorCredits"
aboutDialogTranslatorCredits = AttrLabelProxy

aboutDialogVersion :: AttrLabelProxy "version"
aboutDialogVersion = AttrLabelProxy

aboutDialogWebsite :: AttrLabelProxy "website"
aboutDialogWebsite = AttrLabelProxy

aboutDialogWebsiteLabel :: AttrLabelProxy "websiteLabel"
aboutDialogWebsiteLabel = AttrLabelProxy

aboutDialogWrapLicense :: AttrLabelProxy "wrapLicense"
aboutDialogWrapLicense = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AboutDialog = AboutDialogSignalList
type AboutDialogSignalList = ('[ '("activateDefault", Gtk.Window.WindowActivateDefaultSignalInfo), '("activateFocus", Gtk.Window.WindowActivateFocusSignalInfo), '("activateLink", AboutDialogActivateLinkSignalInfo), '("closeRequest", Gtk.Window.WindowCloseRequestSignalInfo), '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("enableDebugging", Gtk.Window.WindowEnableDebuggingSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("keysChanged", Gtk.Window.WindowKeysChangedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AboutDialog::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "AboutDialog" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_new" gtk_about_dialog_new :: 
    IO (Ptr AboutDialog)

-- | Creates a new @GtkAboutDialog@.
aboutDialogNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m AboutDialog
    -- ^ __Returns:__ a newly created @GtkAboutDialog@
aboutDialogNew  = liftIO $ do
    result <- gtk_about_dialog_new
    checkUnexpectedReturnNULL "aboutDialogNew" result
    result' <- (newObject AboutDialog) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method AboutDialog::add_credit_section
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "section_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The name of the section"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "people"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the people who belong to that section"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_add_credit_section" gtk_about_dialog_add_credit_section :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- section_name : TBasicType TUTF8
    Ptr CString ->                          -- people : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Creates a new section in the \"Credits\" page.
aboutDialogAddCreditSection ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> T.Text
    -- ^ /@sectionName@/: The name of the section
    -> [T.Text]
    -- ^ /@people@/: the people who belong to that section
    -> m ()
aboutDialogAddCreditSection about sectionName people = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    sectionName' <- textToCString sectionName
    people' <- packZeroTerminatedUTF8CArray people
    gtk_about_dialog_add_credit_section about' sectionName' people'
    touchManagedPtr about
    freeMem sectionName'
    mapZeroTerminatedCArray freeMem people'
    freeMem people'
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogAddCreditSectionMethodInfo
instance (signature ~ (T.Text -> [T.Text] -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogAddCreditSectionMethodInfo a signature where
    overloadedMethod = aboutDialogAddCreditSection

instance O.OverloadedMethodInfo AboutDialogAddCreditSectionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogAddCreditSection",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogAddCreditSection"
        })


#endif

-- method AboutDialog::get_artists
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_artists" gtk_about_dialog_get_artists :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO (Ptr CString)

-- | Returns the names of the artists which are displayed
-- in the credits page.
aboutDialogGetArtists ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m [T.Text]
    -- ^ __Returns:__ A
    --   @NULL@-terminated string array containing the artists
aboutDialogGetArtists about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_artists about'
    checkUnexpectedReturnNULL "aboutDialogGetArtists" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr about
    return result'

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetArtistsMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetArtistsMethodInfo a signature where
    overloadedMethod = aboutDialogGetArtists

instance O.OverloadedMethodInfo AboutDialogGetArtistsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetArtists",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetArtists"
        })


#endif

-- method AboutDialog::get_authors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_authors" gtk_about_dialog_get_authors :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO (Ptr CString)

-- | Returns the names of the authors which are displayed
-- in the credits page.
aboutDialogGetAuthors ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m [T.Text]
    -- ^ __Returns:__ A
    --   @NULL@-terminated string array containing the authors
aboutDialogGetAuthors about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_authors about'
    checkUnexpectedReturnNULL "aboutDialogGetAuthors" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr about
    return result'

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetAuthorsMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetAuthorsMethodInfo a signature where
    overloadedMethod = aboutDialogGetAuthors

instance O.OverloadedMethodInfo AboutDialogGetAuthorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetAuthors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetAuthors"
        })


#endif

-- method AboutDialog::get_comments
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_comments" gtk_about_dialog_get_comments :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the comments string.
aboutDialogGetComments ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The comments
aboutDialogGetComments about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_comments about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetCommentsMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetCommentsMethodInfo a signature where
    overloadedMethod = aboutDialogGetComments

instance O.OverloadedMethodInfo AboutDialogGetCommentsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetComments",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetComments"
        })


#endif

-- method AboutDialog::get_copyright
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_copyright" gtk_about_dialog_get_copyright :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the copyright string.
aboutDialogGetCopyright ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The copyright string
aboutDialogGetCopyright about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_copyright about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetCopyrightMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetCopyrightMethodInfo a signature where
    overloadedMethod = aboutDialogGetCopyright

instance O.OverloadedMethodInfo AboutDialogGetCopyrightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetCopyright",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetCopyright"
        })


#endif

-- method AboutDialog::get_documenters
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TCArray True (-1) (-1) (TBasicType TUTF8))
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_documenters" gtk_about_dialog_get_documenters :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO (Ptr CString)

-- | Returns the name of the documenters which are displayed
-- in the credits page.
aboutDialogGetDocumenters ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m [T.Text]
    -- ^ __Returns:__ A
    --   @NULL@-terminated string array containing the documenters
aboutDialogGetDocumenters about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_documenters about'
    checkUnexpectedReturnNULL "aboutDialogGetDocumenters" result
    result' <- unpackZeroTerminatedUTF8CArray result
    touchManagedPtr about
    return result'

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetDocumentersMethodInfo
instance (signature ~ (m [T.Text]), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetDocumentersMethodInfo a signature where
    overloadedMethod = aboutDialogGetDocumenters

instance O.OverloadedMethodInfo AboutDialogGetDocumentersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetDocumenters",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetDocumenters"
        })


#endif

-- method AboutDialog::get_license
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_license" gtk_about_dialog_get_license :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the license information.
aboutDialogGetLicense ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The license information
aboutDialogGetLicense about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_license about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetLicenseMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetLicenseMethodInfo a signature where
    overloadedMethod = aboutDialogGetLicense

instance O.OverloadedMethodInfo AboutDialogGetLicenseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetLicense",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetLicense"
        })


#endif

-- method AboutDialog::get_license_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "License" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_license_type" gtk_about_dialog_get_license_type :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CUInt

-- | Retrieves the license type.
aboutDialogGetLicenseType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m Gtk.Enums.License
    -- ^ __Returns:__ a t'GI.Gtk.Enums.License' value
aboutDialogGetLicenseType about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_license_type about'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr about
    return result'

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetLicenseTypeMethodInfo
instance (signature ~ (m Gtk.Enums.License), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetLicenseTypeMethodInfo a signature where
    overloadedMethod = aboutDialogGetLicenseType

instance O.OverloadedMethodInfo AboutDialogGetLicenseTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetLicenseType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetLicenseType"
        })


#endif

-- method AboutDialog::get_logo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Paintable" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_logo" gtk_about_dialog_get_logo :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO (Ptr Gdk.Paintable.Paintable)

-- | Returns the paintable displayed as logo in the about dialog.
aboutDialogGetLogo ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe Gdk.Paintable.Paintable)
    -- ^ __Returns:__ the paintable displayed as
    --   logo or @NULL@ if the logo is unset or has been set via
    --   'GI.Gtk.Objects.AboutDialog.aboutDialogSetLogoIconName'
aboutDialogGetLogo about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_logo about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Paintable.Paintable) result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetLogoMethodInfo
instance (signature ~ (m (Maybe Gdk.Paintable.Paintable)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetLogoMethodInfo a signature where
    overloadedMethod = aboutDialogGetLogo

instance O.OverloadedMethodInfo AboutDialogGetLogoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetLogo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetLogo"
        })


#endif

-- method AboutDialog::get_logo_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_logo_icon_name" gtk_about_dialog_get_logo_icon_name :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the icon name displayed as logo in the about dialog.
aboutDialogGetLogoIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the icon name displayed as logo,
    --   or @NULL@ if the logo has been set via 'GI.Gtk.Objects.AboutDialog.aboutDialogSetLogo'
aboutDialogGetLogoIconName about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_logo_icon_name about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetLogoIconNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetLogoIconNameMethodInfo a signature where
    overloadedMethod = aboutDialogGetLogoIconName

instance O.OverloadedMethodInfo AboutDialogGetLogoIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetLogoIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetLogoIconName"
        })


#endif

-- method AboutDialog::get_program_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_program_name" gtk_about_dialog_get_program_name :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the program name displayed in the about dialog.
aboutDialogGetProgramName ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the program name
aboutDialogGetProgramName about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_program_name about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetProgramNameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetProgramNameMethodInfo a signature where
    overloadedMethod = aboutDialogGetProgramName

instance O.OverloadedMethodInfo AboutDialogGetProgramNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetProgramName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetProgramName"
        })


#endif

-- method AboutDialog::get_system_information
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_system_information" gtk_about_dialog_get_system_information :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the system information that is shown in the about dialog.
aboutDialogGetSystemInformation ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the system information
aboutDialogGetSystemInformation about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_system_information about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetSystemInformationMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetSystemInformationMethodInfo a signature where
    overloadedMethod = aboutDialogGetSystemInformation

instance O.OverloadedMethodInfo AboutDialogGetSystemInformationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetSystemInformation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetSystemInformation"
        })


#endif

-- method AboutDialog::get_translator_credits
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_translator_credits" gtk_about_dialog_get_translator_credits :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the translator credits string which is displayed
-- in the credits page.
aboutDialogGetTranslatorCredits ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The translator credits string
aboutDialogGetTranslatorCredits about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_translator_credits about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetTranslatorCreditsMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetTranslatorCreditsMethodInfo a signature where
    overloadedMethod = aboutDialogGetTranslatorCredits

instance O.OverloadedMethodInfo AboutDialogGetTranslatorCreditsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetTranslatorCredits",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetTranslatorCredits"
        })


#endif

-- method AboutDialog::get_version
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_version" gtk_about_dialog_get_version :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the version string.
aboutDialogGetVersion ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The version string
aboutDialogGetVersion about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_version about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetVersionMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetVersionMethodInfo a signature where
    overloadedMethod = aboutDialogGetVersion

instance O.OverloadedMethodInfo AboutDialogGetVersionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetVersion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetVersion"
        })


#endif

-- method AboutDialog::get_website
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_website" gtk_about_dialog_get_website :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the website URL.
aboutDialogGetWebsite ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The website URL
aboutDialogGetWebsite about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_website about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetWebsiteMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetWebsiteMethodInfo a signature where
    overloadedMethod = aboutDialogGetWebsite

instance O.OverloadedMethodInfo AboutDialogGetWebsiteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetWebsite",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetWebsite"
        })


#endif

-- method AboutDialog::get_website_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_website_label" gtk_about_dialog_get_website_label :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CString

-- | Returns the label used for the website link.
aboutDialogGetWebsiteLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m (Maybe T.Text)
    -- ^ __Returns:__ The label used for the website link
aboutDialogGetWebsiteLabel about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_website_label about'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr about
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetWebsiteLabelMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetWebsiteLabelMethodInfo a signature where
    overloadedMethod = aboutDialogGetWebsiteLabel

instance O.OverloadedMethodInfo AboutDialogGetWebsiteLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetWebsiteLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetWebsiteLabel"
        })


#endif

-- method AboutDialog::get_wrap_license
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_get_wrap_license" gtk_about_dialog_get_wrap_license :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    IO CInt

-- | Returns whether the license text in the about dialog is
-- automatically wrapped.
aboutDialogGetWrapLicense ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> m Bool
    -- ^ __Returns:__ @TRUE@ if the license text is wrapped
aboutDialogGetWrapLicense about = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    result <- gtk_about_dialog_get_wrap_license about'
    let result' = (/= 0) result
    touchManagedPtr about
    return result'

#if defined(ENABLE_OVERLOADING)
data AboutDialogGetWrapLicenseMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogGetWrapLicenseMethodInfo a signature where
    overloadedMethod = aboutDialogGetWrapLicense

instance O.OverloadedMethodInfo AboutDialogGetWrapLicenseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogGetWrapLicense",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogGetWrapLicense"
        })


#endif

-- method AboutDialog::set_artists
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "artists"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the authors of the artwork\n  of the application"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_artists" gtk_about_dialog_set_artists :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    Ptr CString ->                          -- artists : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the names of the artists to be displayed
-- in the \"Credits\" page.
aboutDialogSetArtists ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> [T.Text]
    -- ^ /@artists@/: the authors of the artwork
    --   of the application
    -> m ()
aboutDialogSetArtists about artists = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    artists' <- packZeroTerminatedUTF8CArray artists
    gtk_about_dialog_set_artists about' artists'
    touchManagedPtr about
    mapZeroTerminatedCArray freeMem artists'
    freeMem artists'
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetArtistsMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetArtistsMethodInfo a signature where
    overloadedMethod = aboutDialogSetArtists

instance O.OverloadedMethodInfo AboutDialogSetArtistsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetArtists",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetArtists"
        })


#endif

-- method AboutDialog::set_authors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "authors"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the authors of the application"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_authors" gtk_about_dialog_set_authors :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    Ptr CString ->                          -- authors : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the names of the authors which are displayed
-- in the \"Credits\" page of the about dialog.
aboutDialogSetAuthors ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> [T.Text]
    -- ^ /@authors@/: the authors of the application
    -> m ()
aboutDialogSetAuthors about authors = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    authors' <- packZeroTerminatedUTF8CArray authors
    gtk_about_dialog_set_authors about' authors'
    touchManagedPtr about
    mapZeroTerminatedCArray freeMem authors'
    freeMem authors'
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetAuthorsMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetAuthorsMethodInfo a signature where
    overloadedMethod = aboutDialogSetAuthors

instance O.OverloadedMethodInfo AboutDialogSetAuthorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetAuthors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetAuthors"
        })


#endif

-- method AboutDialog::set_comments
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "comments"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a comments string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_comments" gtk_about_dialog_set_comments :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- comments : TBasicType TUTF8
    IO ()

-- | Sets the comments string to display in the about dialog.
-- 
-- This should be a short string of one or two lines.
aboutDialogSetComments ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@comments@/: a comments string
    -> m ()
aboutDialogSetComments about comments = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeComments <- case comments of
        Nothing -> return FP.nullPtr
        Just jComments -> do
            jComments' <- textToCString jComments
            return jComments'
    gtk_about_dialog_set_comments about' maybeComments
    touchManagedPtr about
    freeMem maybeComments
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetCommentsMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetCommentsMethodInfo a signature where
    overloadedMethod = aboutDialogSetComments

instance O.OverloadedMethodInfo AboutDialogSetCommentsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetComments",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetComments"
        })


#endif

-- method AboutDialog::set_copyright
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "copyright"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the copyright string"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_copyright" gtk_about_dialog_set_copyright :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- copyright : TBasicType TUTF8
    IO ()

-- | Sets the copyright string to display in the about dialog.
-- 
-- This should be a short string of one or two lines.
aboutDialogSetCopyright ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@copyright@/: the copyright string
    -> m ()
aboutDialogSetCopyright about copyright = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeCopyright <- case copyright of
        Nothing -> return FP.nullPtr
        Just jCopyright -> do
            jCopyright' <- textToCString jCopyright
            return jCopyright'
    gtk_about_dialog_set_copyright about' maybeCopyright
    touchManagedPtr about
    freeMem maybeCopyright
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetCopyrightMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetCopyrightMethodInfo a signature where
    overloadedMethod = aboutDialogSetCopyright

instance O.OverloadedMethodInfo AboutDialogSetCopyrightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetCopyright",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetCopyright"
        })


#endif

-- method AboutDialog::set_documenters
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "documenters"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the authors of the documentation\n  of the application"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_documenters" gtk_about_dialog_set_documenters :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    Ptr CString ->                          -- documenters : TCArray True (-1) (-1) (TBasicType TUTF8)
    IO ()

-- | Sets the names of the documenters which are displayed
-- in the \"Credits\" page.
aboutDialogSetDocumenters ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> [T.Text]
    -- ^ /@documenters@/: the authors of the documentation
    --   of the application
    -> m ()
aboutDialogSetDocumenters about documenters = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    documenters' <- packZeroTerminatedUTF8CArray documenters
    gtk_about_dialog_set_documenters about' documenters'
    touchManagedPtr about
    mapZeroTerminatedCArray freeMem documenters'
    freeMem documenters'
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetDocumentersMethodInfo
instance (signature ~ ([T.Text] -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetDocumentersMethodInfo a signature where
    overloadedMethod = aboutDialogSetDocumenters

instance O.OverloadedMethodInfo AboutDialogSetDocumentersMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetDocumenters",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetDocumenters"
        })


#endif

-- method AboutDialog::set_license
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "license"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the license information"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_license" gtk_about_dialog_set_license :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- license : TBasicType TUTF8
    IO ()

-- | Sets the license information to be displayed in the
-- about dialog.
-- 
-- If @license@ is @NULL@, the license page is hidden.
aboutDialogSetLicense ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@license@/: the license information
    -> m ()
aboutDialogSetLicense about license = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeLicense <- case license of
        Nothing -> return FP.nullPtr
        Just jLicense -> do
            jLicense' <- textToCString jLicense
            return jLicense'
    gtk_about_dialog_set_license about' maybeLicense
    touchManagedPtr about
    freeMem maybeLicense
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetLicenseMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetLicenseMethodInfo a signature where
    overloadedMethod = aboutDialogSetLicense

instance O.OverloadedMethodInfo AboutDialogSetLicenseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetLicense",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetLicense"
        })


#endif

-- method AboutDialog::set_license_type
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "license_type"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "License" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the type of license"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_license_type" gtk_about_dialog_set_license_type :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CUInt ->                                -- license_type : TInterface (Name {namespace = "Gtk", name = "License"})
    IO ()

-- | Sets the license of the application showing the about dialog
-- from a list of known licenses.
-- 
-- This function overrides the license set using
-- 'GI.Gtk.Objects.AboutDialog.aboutDialogSetLicense'.
aboutDialogSetLicenseType ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Gtk.Enums.License
    -- ^ /@licenseType@/: the type of license
    -> m ()
aboutDialogSetLicenseType about licenseType = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    let licenseType' = (fromIntegral . fromEnum) licenseType
    gtk_about_dialog_set_license_type about' licenseType'
    touchManagedPtr about
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetLicenseTypeMethodInfo
instance (signature ~ (Gtk.Enums.License -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetLicenseTypeMethodInfo a signature where
    overloadedMethod = aboutDialogSetLicenseType

instance O.OverloadedMethodInfo AboutDialogSetLicenseTypeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetLicenseType",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetLicenseType"
        })


#endif

-- method AboutDialog::set_logo
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "logo"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Paintable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkPaintable`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_logo" gtk_about_dialog_set_logo :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    Ptr Gdk.Paintable.Paintable ->          -- logo : TInterface (Name {namespace = "Gdk", name = "Paintable"})
    IO ()

-- | Sets the logo in the about dialog.
aboutDialogSetLogo ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a, Gdk.Paintable.IsPaintable b) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (b)
    -- ^ /@logo@/: a @GdkPaintable@
    -> m ()
aboutDialogSetLogo about logo = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeLogo <- case logo of
        Nothing -> return FP.nullPtr
        Just jLogo -> do
            jLogo' <- unsafeManagedPtrCastPtr jLogo
            return jLogo'
    gtk_about_dialog_set_logo about' maybeLogo
    touchManagedPtr about
    whenJust logo touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetLogoMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsAboutDialog a, Gdk.Paintable.IsPaintable b) => O.OverloadedMethod AboutDialogSetLogoMethodInfo a signature where
    overloadedMethod = aboutDialogSetLogo

instance O.OverloadedMethodInfo AboutDialogSetLogoMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetLogo",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetLogo"
        })


#endif

-- method AboutDialog::set_logo_icon_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an icon name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_logo_icon_name" gtk_about_dialog_set_logo_icon_name :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- icon_name : TBasicType TUTF8
    IO ()

-- | Sets the icon name to be displayed as logo in the about dialog.
aboutDialogSetLogoIconName ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@iconName@/: an icon name
    -> m ()
aboutDialogSetLogoIconName about iconName = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeIconName <- case iconName of
        Nothing -> return FP.nullPtr
        Just jIconName -> do
            jIconName' <- textToCString jIconName
            return jIconName'
    gtk_about_dialog_set_logo_icon_name about' maybeIconName
    touchManagedPtr about
    freeMem maybeIconName
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetLogoIconNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetLogoIconNameMethodInfo a signature where
    overloadedMethod = aboutDialogSetLogoIconName

instance O.OverloadedMethodInfo AboutDialogSetLogoIconNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetLogoIconName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetLogoIconName"
        })


#endif

-- method AboutDialog::set_program_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the program name" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_program_name" gtk_about_dialog_set_program_name :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- name : TBasicType TUTF8
    IO ()

-- | Sets the name to display in the about dialog.
-- 
-- If @name@ is not set, the string returned
-- by @g_get_application_name()@ is used.
aboutDialogSetProgramName ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@name@/: the program name
    -> m ()
aboutDialogSetProgramName about name = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeName <- case name of
        Nothing -> return FP.nullPtr
        Just jName -> do
            jName' <- textToCString jName
            return jName'
    gtk_about_dialog_set_program_name about' maybeName
    touchManagedPtr about
    freeMem maybeName
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetProgramNameMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetProgramNameMethodInfo a signature where
    overloadedMethod = aboutDialogSetProgramName

instance O.OverloadedMethodInfo AboutDialogSetProgramNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetProgramName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetProgramName"
        })


#endif

-- method AboutDialog::set_system_information
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "system_information"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "system information" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_system_information" gtk_about_dialog_set_system_information :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- system_information : TBasicType TUTF8
    IO ()

-- | Sets the system information to be displayed in the about
-- dialog.
-- 
-- If @system_information@ is @NULL@, the system information
-- page is hidden.
-- 
-- See [AboutDialog:systemInformation]("GI.Gtk.Objects.AboutDialog#g:attr:systemInformation").
aboutDialogSetSystemInformation ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@systemInformation@/: system information
    -> m ()
aboutDialogSetSystemInformation about systemInformation = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeSystemInformation <- case systemInformation of
        Nothing -> return FP.nullPtr
        Just jSystemInformation -> do
            jSystemInformation' <- textToCString jSystemInformation
            return jSystemInformation'
    gtk_about_dialog_set_system_information about' maybeSystemInformation
    touchManagedPtr about
    freeMem maybeSystemInformation
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetSystemInformationMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetSystemInformationMethodInfo a signature where
    overloadedMethod = aboutDialogSetSystemInformation

instance O.OverloadedMethodInfo AboutDialogSetSystemInformationMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetSystemInformation",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetSystemInformation"
        })


#endif

-- method AboutDialog::set_translator_credits
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "translator_credits"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the translator credits"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_translator_credits" gtk_about_dialog_set_translator_credits :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- translator_credits : TBasicType TUTF8
    IO ()

-- | Sets the translator credits string which is displayed in
-- the credits page.
-- 
-- The intended use for this string is to display the translator
-- of the language which is currently used in the user interface.
-- Using @gettext()@, a simple way to achieve that is to mark the
-- string for translation:
-- 
-- 
-- === /c code/
-- >GtkWidget *about = gtk_about_dialog_new ();
-- > gtk_about_dialog_set_translator_credits (GTK_ABOUT_DIALOG (about),
-- >                                          _("translator-credits"));
-- 
-- 
-- It is a good idea to use the customary @msgid@ “translator-credits”
-- for this purpose, since translators will already know the purpose of
-- that @msgid@, and since @GtkAboutDialog@ will detect if “translator-credits”
-- is untranslated and omit translator credits.
aboutDialogSetTranslatorCredits ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@translatorCredits@/: the translator credits
    -> m ()
aboutDialogSetTranslatorCredits about translatorCredits = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeTranslatorCredits <- case translatorCredits of
        Nothing -> return FP.nullPtr
        Just jTranslatorCredits -> do
            jTranslatorCredits' <- textToCString jTranslatorCredits
            return jTranslatorCredits'
    gtk_about_dialog_set_translator_credits about' maybeTranslatorCredits
    touchManagedPtr about
    freeMem maybeTranslatorCredits
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetTranslatorCreditsMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetTranslatorCreditsMethodInfo a signature where
    overloadedMethod = aboutDialogSetTranslatorCredits

instance O.OverloadedMethodInfo AboutDialogSetTranslatorCreditsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetTranslatorCredits",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetTranslatorCredits"
        })


#endif

-- method AboutDialog::set_version
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "version"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the version string" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_version" gtk_about_dialog_set_version :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- version : TBasicType TUTF8
    IO ()

-- | Sets the version string to display in the about dialog.
aboutDialogSetVersion ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@version@/: the version string
    -> m ()
aboutDialogSetVersion about version = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeVersion <- case version of
        Nothing -> return FP.nullPtr
        Just jVersion -> do
            jVersion' <- textToCString jVersion
            return jVersion'
    gtk_about_dialog_set_version about' maybeVersion
    touchManagedPtr about
    freeMem maybeVersion
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetVersionMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetVersionMethodInfo a signature where
    overloadedMethod = aboutDialogSetVersion

instance O.OverloadedMethodInfo AboutDialogSetVersionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetVersion",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetVersion"
        })


#endif

-- method AboutDialog::set_website
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "website"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a URL string starting with `http://`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_website" gtk_about_dialog_set_website :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- website : TBasicType TUTF8
    IO ()

-- | Sets the URL to use for the website link.
aboutDialogSetWebsite ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Maybe (T.Text)
    -- ^ /@website@/: a URL string starting with @http:\/\/@
    -> m ()
aboutDialogSetWebsite about website = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    maybeWebsite <- case website of
        Nothing -> return FP.nullPtr
        Just jWebsite -> do
            jWebsite' <- textToCString jWebsite
            return jWebsite'
    gtk_about_dialog_set_website about' maybeWebsite
    touchManagedPtr about
    freeMem maybeWebsite
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetWebsiteMethodInfo
instance (signature ~ (Maybe (T.Text) -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetWebsiteMethodInfo a signature where
    overloadedMethod = aboutDialogSetWebsite

instance O.OverloadedMethodInfo AboutDialogSetWebsiteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetWebsite",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetWebsite"
        })


#endif

-- method AboutDialog::set_website_label
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "website_label"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the label used for the website link"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_website_label" gtk_about_dialog_set_website_label :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CString ->                              -- website_label : TBasicType TUTF8
    IO ()

-- | Sets the label to be used for the website link.
aboutDialogSetWebsiteLabel ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> T.Text
    -- ^ /@websiteLabel@/: the label used for the website link
    -> m ()
aboutDialogSetWebsiteLabel about websiteLabel = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    websiteLabel' <- textToCString websiteLabel
    gtk_about_dialog_set_website_label about' websiteLabel'
    touchManagedPtr about
    freeMem websiteLabel'
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetWebsiteLabelMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetWebsiteLabelMethodInfo a signature where
    overloadedMethod = aboutDialogSetWebsiteLabel

instance O.OverloadedMethodInfo AboutDialogSetWebsiteLabelMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetWebsiteLabel",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetWebsiteLabel"
        })


#endif

-- method AboutDialog::set_wrap_license
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "about"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AboutDialog" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "an about dialog" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "wrap_license"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to wrap the license"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_about_dialog_set_wrap_license" gtk_about_dialog_set_wrap_license :: 
    Ptr AboutDialog ->                      -- about : TInterface (Name {namespace = "Gtk", name = "AboutDialog"})
    CInt ->                                 -- wrap_license : TBasicType TBoolean
    IO ()

-- | Sets whether the license text in the about dialog should be
-- automatically wrapped.
aboutDialogSetWrapLicense ::
    (B.CallStack.HasCallStack, MonadIO m, IsAboutDialog a) =>
    a
    -- ^ /@about@/: an about dialog
    -> Bool
    -- ^ /@wrapLicense@/: whether to wrap the license
    -> m ()
aboutDialogSetWrapLicense about wrapLicense = liftIO $ do
    about' <- unsafeManagedPtrCastPtr about
    let wrapLicense' = (P.fromIntegral . P.fromEnum) wrapLicense
    gtk_about_dialog_set_wrap_license about' wrapLicense'
    touchManagedPtr about
    return ()

#if defined(ENABLE_OVERLOADING)
data AboutDialogSetWrapLicenseMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsAboutDialog a) => O.OverloadedMethod AboutDialogSetWrapLicenseMethodInfo a signature where
    overloadedMethod = aboutDialogSetWrapLicense

instance O.OverloadedMethodInfo AboutDialogSetWrapLicenseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AboutDialog.aboutDialogSetWrapLicense",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AboutDialog.html#v:aboutDialogSetWrapLicense"
        })


#endif


