{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Builds the uniforms data for a @GskGLShader@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Structs.ShaderArgsBuilder
    ( 

-- * Exported types
    ShaderArgsBuilder(..)                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [ref]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:ref"), [toArgs]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:toArgs"), [unref]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- [setBool]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:setBool"), [setFloat]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:setFloat"), [setInt]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:setInt"), [setUint]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:setUint"), [setVec2]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:setVec2"), [setVec3]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:setVec3"), [setVec4]("GI.Gsk.Structs.ShaderArgsBuilder#g:method:setVec4").

#if defined(ENABLE_OVERLOADING)
    ResolveShaderArgsBuilderMethod          ,
#endif

-- ** new #method:new#

    shaderArgsBuilderNew                    ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderRefMethodInfo          ,
#endif
    shaderArgsBuilderRef                    ,


-- ** setBool #method:setBool#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderSetBoolMethodInfo      ,
#endif
    shaderArgsBuilderSetBool                ,


-- ** setFloat #method:setFloat#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderSetFloatMethodInfo     ,
#endif
    shaderArgsBuilderSetFloat               ,


-- ** setInt #method:setInt#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderSetIntMethodInfo       ,
#endif
    shaderArgsBuilderSetInt                 ,


-- ** setUint #method:setUint#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderSetUintMethodInfo      ,
#endif
    shaderArgsBuilderSetUint                ,


-- ** setVec2 #method:setVec2#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderSetVec2MethodInfo      ,
#endif
    shaderArgsBuilderSetVec2                ,


-- ** setVec3 #method:setVec3#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderSetVec3MethodInfo      ,
#endif
    shaderArgsBuilderSetVec3                ,


-- ** setVec4 #method:setVec4#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderSetVec4MethodInfo      ,
#endif
    shaderArgsBuilderSetVec4                ,


-- ** toArgs #method:toArgs#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderToArgsMethodInfo       ,
#endif
    shaderArgsBuilderToArgs                 ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    ShaderArgsBuilderUnrefMethodInfo        ,
#endif
    shaderArgsBuilderUnref                  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Objects.Renderer as Gsk.Renderer

#else
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import {-# SOURCE #-} qualified GI.Gsk.Objects.GLShader as Gsk.GLShader

#endif

-- | Memory-managed wrapper type.
newtype ShaderArgsBuilder = ShaderArgsBuilder (SP.ManagedPtr ShaderArgsBuilder)
    deriving (Eq)

instance SP.ManagedPtrNewtype ShaderArgsBuilder where
    toManagedPtr (ShaderArgsBuilder p) = p

foreign import ccall "gsk_shader_args_builder_get_type" c_gsk_shader_args_builder_get_type :: 
    IO GType

type instance O.ParentTypes ShaderArgsBuilder = '[]
instance O.HasParentTypes ShaderArgsBuilder

instance B.Types.TypedObject ShaderArgsBuilder where
    glibType = c_gsk_shader_args_builder_get_type

instance B.Types.GBoxed ShaderArgsBuilder

-- | Convert t'ShaderArgsBuilder' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ShaderArgsBuilder) where
    gvalueGType_ = c_gsk_shader_args_builder_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ShaderArgsBuilder)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ShaderArgsBuilder)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ShaderArgsBuilder ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ShaderArgsBuilder
type instance O.AttributeList ShaderArgsBuilder = ShaderArgsBuilderAttributeList
type ShaderArgsBuilderAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method ShaderArgsBuilder::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "shader"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "GLShader" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskGLShader`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "initial_values"
--           , argType = TInterface Name { namespace = "GLib" , name = "Bytes" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional `GBytes` with initial values"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gsk" , name = "ShaderArgsBuilder" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_new" gsk_shader_args_builder_new :: 
    Ptr Gsk.GLShader.GLShader ->            -- shader : TInterface (Name {namespace = "Gsk", name = "GLShader"})
    Ptr GLib.Bytes.Bytes ->                 -- initial_values : TInterface (Name {namespace = "GLib", name = "Bytes"})
    IO (Ptr ShaderArgsBuilder)

{-# DEPRECATED shaderArgsBuilderNew ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Allocates a builder that can be used to construct a new uniform data
-- chunk.
shaderArgsBuilderNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.GLShader.IsGLShader a) =>
    a
    -- ^ /@shader@/: a @GskGLShader@
    -> Maybe (GLib.Bytes.Bytes)
    -- ^ /@initialValues@/: optional @GBytes@ with initial values
    -> m ShaderArgsBuilder
    -- ^ __Returns:__ The newly allocated builder, free with
    --     'GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderUnref'
shaderArgsBuilderNew shader initialValues = liftIO $ do
    shader' <- unsafeManagedPtrCastPtr shader
    maybeInitialValues <- case initialValues of
        Nothing -> return FP.nullPtr
        Just jInitialValues -> do
            jInitialValues' <- unsafeManagedPtrGetPtr jInitialValues
            return jInitialValues'
    result <- gsk_shader_args_builder_new shader' maybeInitialValues
    checkUnexpectedReturnNULL "shaderArgsBuilderNew" result
    result' <- (wrapBoxed ShaderArgsBuilder) result
    touchManagedPtr shader
    whenJust initialValues touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ShaderArgsBuilder::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gsk" , name = "ShaderArgsBuilder" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_ref" gsk_shader_args_builder_ref :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    IO (Ptr ShaderArgsBuilder)

{-# DEPRECATED shaderArgsBuilderRef ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Increases the reference count of a @GskShaderArgsBuilder@ by one.
shaderArgsBuilderRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> m ShaderArgsBuilder
    -- ^ __Returns:__ the passed in @GskShaderArgsBuilder@
shaderArgsBuilderRef builder = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    result <- gsk_shader_args_builder_ref builder'
    checkUnexpectedReturnNULL "shaderArgsBuilderRef" result
    result' <- (wrapBoxed ShaderArgsBuilder) result
    touchManagedPtr builder
    return result'

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderRefMethodInfo
instance (signature ~ (m ShaderArgsBuilder), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderRefMethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderRef

instance O.OverloadedMethodInfo ShaderArgsBuilderRefMethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderRef"
        })


#endif

-- method ShaderArgsBuilder::set_bool
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "index of the uniform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "value to set the uniform to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_set_bool" gsk_shader_args_builder_set_bool :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    Int32 ->                                -- idx : TBasicType TInt
    CInt ->                                 -- value : TBasicType TBoolean
    IO ()

{-# DEPRECATED shaderArgsBuilderSetBool ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Sets the value of the uniform /@idx@/.
-- 
-- The uniform must be of bool type.
shaderArgsBuilderSetBool ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> Int32
    -- ^ /@idx@/: index of the uniform
    -> Bool
    -- ^ /@value@/: value to set the uniform to
    -> m ()
shaderArgsBuilderSetBool builder idx value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    let value' = (P.fromIntegral . P.fromEnum) value
    gsk_shader_args_builder_set_bool builder' idx value'
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderSetBoolMethodInfo
instance (signature ~ (Int32 -> Bool -> m ()), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderSetBoolMethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderSetBool

instance O.OverloadedMethodInfo ShaderArgsBuilderSetBoolMethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderSetBool",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderSetBool"
        })


#endif

-- method ShaderArgsBuilder::set_float
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "index of the uniform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "value to set the uniform to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_set_float" gsk_shader_args_builder_set_float :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    Int32 ->                                -- idx : TBasicType TInt
    CFloat ->                               -- value : TBasicType TFloat
    IO ()

-- | Sets the value of the uniform /@idx@/.
-- 
-- The uniform must be of float type.
shaderArgsBuilderSetFloat ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> Int32
    -- ^ /@idx@/: index of the uniform
    -> Float
    -- ^ /@value@/: value to set the uniform to
    -> m ()
shaderArgsBuilderSetFloat builder idx value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    let value' = realToFrac value
    gsk_shader_args_builder_set_float builder' idx value'
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderSetFloatMethodInfo
instance (signature ~ (Int32 -> Float -> m ()), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderSetFloatMethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderSetFloat

instance O.OverloadedMethodInfo ShaderArgsBuilderSetFloatMethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderSetFloat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderSetFloat"
        })


#endif

-- method ShaderArgsBuilder::set_int
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "index of the uniform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "value to set the uniform to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_set_int" gsk_shader_args_builder_set_int :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    Int32 ->                                -- idx : TBasicType TInt
    Int32 ->                                -- value : TBasicType TInt32
    IO ()

{-# DEPRECATED shaderArgsBuilderSetInt ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Sets the value of the uniform /@idx@/.
-- 
-- The uniform must be of int type.
shaderArgsBuilderSetInt ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> Int32
    -- ^ /@idx@/: index of the uniform
    -> Int32
    -- ^ /@value@/: value to set the uniform to
    -> m ()
shaderArgsBuilderSetInt builder idx value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    gsk_shader_args_builder_set_int builder' idx value
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderSetIntMethodInfo
instance (signature ~ (Int32 -> Int32 -> m ()), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderSetIntMethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderSetInt

instance O.OverloadedMethodInfo ShaderArgsBuilderSetIntMethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderSetInt",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderSetInt"
        })


#endif

-- method ShaderArgsBuilder::set_uint
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "index of the uniform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TBasicType TUInt32
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "value to set the uniform to"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_set_uint" gsk_shader_args_builder_set_uint :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    Int32 ->                                -- idx : TBasicType TInt
    Word32 ->                               -- value : TBasicType TUInt32
    IO ()

{-# DEPRECATED shaderArgsBuilderSetUint ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Sets the value of the uniform /@idx@/.
-- 
-- The uniform must be of uint type.
shaderArgsBuilderSetUint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> Int32
    -- ^ /@idx@/: index of the uniform
    -> Word32
    -- ^ /@value@/: value to set the uniform to
    -> m ()
shaderArgsBuilderSetUint builder idx value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    gsk_shader_args_builder_set_uint builder' idx value
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderSetUintMethodInfo
instance (signature ~ (Int32 -> Word32 -> m ()), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderSetUintMethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderSetUint

instance O.OverloadedMethodInfo ShaderArgsBuilderSetUintMethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderSetUint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderSetUint"
        })


#endif

-- method ShaderArgsBuilder::set_vec2
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "index of the uniform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec2" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "value to set the uniform too"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_set_vec2" gsk_shader_args_builder_set_vec2 :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    Int32 ->                                -- idx : TBasicType TInt
    Ptr Graphene.Vec2.Vec2 ->               -- value : TInterface (Name {namespace = "Graphene", name = "Vec2"})
    IO ()

{-# DEPRECATED shaderArgsBuilderSetVec2 ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Sets the value of the uniform /@idx@/.
-- 
-- The uniform must be of vec2 type.
shaderArgsBuilderSetVec2 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: A @GskShaderArgsBuilder@
    -> Int32
    -- ^ /@idx@/: index of the uniform
    -> Graphene.Vec2.Vec2
    -- ^ /@value@/: value to set the uniform too
    -> m ()
shaderArgsBuilderSetVec2 builder idx value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    value' <- unsafeManagedPtrGetPtr value
    gsk_shader_args_builder_set_vec2 builder' idx value'
    touchManagedPtr builder
    touchManagedPtr value
    return ()

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderSetVec2MethodInfo
instance (signature ~ (Int32 -> Graphene.Vec2.Vec2 -> m ()), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderSetVec2MethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderSetVec2

instance O.OverloadedMethodInfo ShaderArgsBuilderSetVec2MethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderSetVec2",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderSetVec2"
        })


#endif

-- method ShaderArgsBuilder::set_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "index of the uniform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "value to set the uniform too"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_set_vec3" gsk_shader_args_builder_set_vec3 :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    Int32 ->                                -- idx : TBasicType TInt
    Ptr Graphene.Vec3.Vec3 ->               -- value : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO ()

{-# DEPRECATED shaderArgsBuilderSetVec3 ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Sets the value of the uniform /@idx@/.
-- 
-- The uniform must be of vec3 type.
shaderArgsBuilderSetVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> Int32
    -- ^ /@idx@/: index of the uniform
    -> Graphene.Vec3.Vec3
    -- ^ /@value@/: value to set the uniform too
    -> m ()
shaderArgsBuilderSetVec3 builder idx value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    value' <- unsafeManagedPtrGetPtr value
    gsk_shader_args_builder_set_vec3 builder' idx value'
    touchManagedPtr builder
    touchManagedPtr value
    return ()

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderSetVec3MethodInfo
instance (signature ~ (Int32 -> Graphene.Vec3.Vec3 -> m ()), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderSetVec3MethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderSetVec3

instance O.OverloadedMethodInfo ShaderArgsBuilderSetVec3MethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderSetVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderSetVec3"
        })


#endif

-- method ShaderArgsBuilder::set_vec4
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "idx"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "index of the uniform"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec4" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "value to set the uniform too"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_set_vec4" gsk_shader_args_builder_set_vec4 :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    Int32 ->                                -- idx : TBasicType TInt
    Ptr Graphene.Vec4.Vec4 ->               -- value : TInterface (Name {namespace = "Graphene", name = "Vec4"})
    IO ()

{-# DEPRECATED shaderArgsBuilderSetVec4 ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Sets the value of the uniform /@idx@/.
-- 
-- The uniform must be of vec4 type.
shaderArgsBuilderSetVec4 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> Int32
    -- ^ /@idx@/: index of the uniform
    -> Graphene.Vec4.Vec4
    -- ^ /@value@/: value to set the uniform too
    -> m ()
shaderArgsBuilderSetVec4 builder idx value = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    value' <- unsafeManagedPtrGetPtr value
    gsk_shader_args_builder_set_vec4 builder' idx value'
    touchManagedPtr builder
    touchManagedPtr value
    return ()

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderSetVec4MethodInfo
instance (signature ~ (Int32 -> Graphene.Vec4.Vec4 -> m ()), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderSetVec4MethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderSetVec4

instance O.OverloadedMethodInfo ShaderArgsBuilderSetVec4MethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderSetVec4",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderSetVec4"
        })


#endif

-- method ShaderArgsBuilder::to_args
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "GLib" , name = "Bytes" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_to_args" gsk_shader_args_builder_to_args :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    IO (Ptr GLib.Bytes.Bytes)

{-# DEPRECATED shaderArgsBuilderToArgs ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Creates a new @GBytes@ args from the current state of the
-- given /@builder@/.
-- 
-- Any uniforms of the shader that have not been explicitly set on
-- the /@builder@/ are zero-initialized.
-- 
-- The given @GskShaderArgsBuilder@ is reset once this function returns;
-- you cannot call this function multiple times on the same /@builder@/ instance.
-- 
-- This function is intended primarily for bindings. C code should use
-- t'GI.Gsk.Structs.ShaderArgsBuilder.ShaderArgsBuilder'.@/free_to_args/@().
shaderArgsBuilderToArgs ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> m GLib.Bytes.Bytes
    -- ^ __Returns:__ the newly allocated buffer with
    --   all the args added to /@builder@/
shaderArgsBuilderToArgs builder = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    result <- gsk_shader_args_builder_to_args builder'
    checkUnexpectedReturnNULL "shaderArgsBuilderToArgs" result
    result' <- (wrapBoxed GLib.Bytes.Bytes) result
    touchManagedPtr builder
    return result'

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderToArgsMethodInfo
instance (signature ~ (m GLib.Bytes.Bytes), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderToArgsMethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderToArgs

instance O.OverloadedMethodInfo ShaderArgsBuilderToArgsMethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderToArgs",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderToArgs"
        })


#endif

-- method ShaderArgsBuilder::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "builder"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "ShaderArgsBuilder" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskShaderArgsBuilder`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_shader_args_builder_unref" gsk_shader_args_builder_unref :: 
    Ptr ShaderArgsBuilder ->                -- builder : TInterface (Name {namespace = "Gsk", name = "ShaderArgsBuilder"})
    IO ()

{-# DEPRECATED shaderArgsBuilderUnref ["(Since version 4.16)","GTK\\'s new Vulkan-focused rendering","  does not support this feature. Use <http://developer.gnome.org/gsk/stable/../gtk4/class.GLArea.html GtkGLArea>","  for OpenGL rendering."] #-}
-- | Decreases the reference count of a @GskShaderArgBuilder@ by one.
-- 
-- If the resulting reference count is zero, frees the builder.
shaderArgsBuilderUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ShaderArgsBuilder
    -- ^ /@builder@/: a @GskShaderArgsBuilder@
    -> m ()
shaderArgsBuilderUnref builder = liftIO $ do
    builder' <- unsafeManagedPtrGetPtr builder
    gsk_shader_args_builder_unref builder'
    touchManagedPtr builder
    return ()

#if defined(ENABLE_OVERLOADING)
data ShaderArgsBuilderUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ShaderArgsBuilderUnrefMethodInfo ShaderArgsBuilder signature where
    overloadedMethod = shaderArgsBuilderUnref

instance O.OverloadedMethodInfo ShaderArgsBuilderUnrefMethodInfo ShaderArgsBuilder where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Structs.ShaderArgsBuilder.shaderArgsBuilderUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Structs-ShaderArgsBuilder.html#v:shaderArgsBuilderUnref"
        })


#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveShaderArgsBuilderMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveShaderArgsBuilderMethod "ref" o = ShaderArgsBuilderRefMethodInfo
    ResolveShaderArgsBuilderMethod "toArgs" o = ShaderArgsBuilderToArgsMethodInfo
    ResolveShaderArgsBuilderMethod "unref" o = ShaderArgsBuilderUnrefMethodInfo
    ResolveShaderArgsBuilderMethod "setBool" o = ShaderArgsBuilderSetBoolMethodInfo
    ResolveShaderArgsBuilderMethod "setFloat" o = ShaderArgsBuilderSetFloatMethodInfo
    ResolveShaderArgsBuilderMethod "setInt" o = ShaderArgsBuilderSetIntMethodInfo
    ResolveShaderArgsBuilderMethod "setUint" o = ShaderArgsBuilderSetUintMethodInfo
    ResolveShaderArgsBuilderMethod "setVec2" o = ShaderArgsBuilderSetVec2MethodInfo
    ResolveShaderArgsBuilderMethod "setVec3" o = ShaderArgsBuilderSetVec3MethodInfo
    ResolveShaderArgsBuilderMethod "setVec4" o = ShaderArgsBuilderSetVec4MethodInfo
    ResolveShaderArgsBuilderMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveShaderArgsBuilderMethod t ShaderArgsBuilder, O.OverloadedMethod info ShaderArgsBuilder p) => OL.IsLabel t (ShaderArgsBuilder -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveShaderArgsBuilderMethod t ShaderArgsBuilder, O.OverloadedMethod info ShaderArgsBuilder p, R.HasField t ShaderArgsBuilder p) => R.HasField t ShaderArgsBuilder p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveShaderArgsBuilderMethod t ShaderArgsBuilder, O.OverloadedMethodInfo info ShaderArgsBuilder) => OL.IsLabel t (O.MethodProxy info ShaderArgsBuilder) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


