{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A point with three components: X, Y, and Z.
-- 
-- /Since: 1.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Graphene.Structs.Point3D
    ( 

-- * Exported types
    Point3D(..)                             ,
    newZeroPoint3D                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [cross]("GI.Graphene.Structs.Point3D#g:method:cross"), [distance]("GI.Graphene.Structs.Point3D#g:method:distance"), [dot]("GI.Graphene.Structs.Point3D#g:method:dot"), [equal]("GI.Graphene.Structs.Point3D#g:method:equal"), [free]("GI.Graphene.Structs.Point3D#g:method:free"), [init]("GI.Graphene.Structs.Point3D#g:method:init"), [initFromPoint]("GI.Graphene.Structs.Point3D#g:method:initFromPoint"), [initFromVec3]("GI.Graphene.Structs.Point3D#g:method:initFromVec3"), [interpolate]("GI.Graphene.Structs.Point3D#g:method:interpolate"), [length]("GI.Graphene.Structs.Point3D#g:method:length"), [near]("GI.Graphene.Structs.Point3D#g:method:near"), [normalize]("GI.Graphene.Structs.Point3D#g:method:normalize"), [normalizeViewport]("GI.Graphene.Structs.Point3D#g:method:normalizeViewport"), [scale]("GI.Graphene.Structs.Point3D#g:method:scale"), [toVec3]("GI.Graphene.Structs.Point3D#g:method:toVec3").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolvePoint3DMethod                    ,
#endif

-- ** alloc #method:alloc#

    point3DAlloc                            ,


-- ** cross #method:cross#

#if defined(ENABLE_OVERLOADING)
    Point3DCrossMethodInfo                  ,
#endif
    point3DCross                            ,


-- ** distance #method:distance#

#if defined(ENABLE_OVERLOADING)
    Point3DDistanceMethodInfo               ,
#endif
    point3DDistance                         ,


-- ** dot #method:dot#

#if defined(ENABLE_OVERLOADING)
    Point3DDotMethodInfo                    ,
#endif
    point3DDot                              ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    Point3DEqualMethodInfo                  ,
#endif
    point3DEqual                            ,


-- ** free #method:free#

#if defined(ENABLE_OVERLOADING)
    Point3DFreeMethodInfo                   ,
#endif
    point3DFree                             ,


-- ** init #method:init#

#if defined(ENABLE_OVERLOADING)
    Point3DInitMethodInfo                   ,
#endif
    point3DInit                             ,


-- ** initFromPoint #method:initFromPoint#

#if defined(ENABLE_OVERLOADING)
    Point3DInitFromPointMethodInfo          ,
#endif
    point3DInitFromPoint                    ,


-- ** initFromVec3 #method:initFromVec3#

#if defined(ENABLE_OVERLOADING)
    Point3DInitFromVec3MethodInfo           ,
#endif
    point3DInitFromVec3                     ,


-- ** interpolate #method:interpolate#

#if defined(ENABLE_OVERLOADING)
    Point3DInterpolateMethodInfo            ,
#endif
    point3DInterpolate                      ,


-- ** length #method:length#

#if defined(ENABLE_OVERLOADING)
    Point3DLengthMethodInfo                 ,
#endif
    point3DLength                           ,


-- ** near #method:near#

#if defined(ENABLE_OVERLOADING)
    Point3DNearMethodInfo                   ,
#endif
    point3DNear                             ,


-- ** normalize #method:normalize#

#if defined(ENABLE_OVERLOADING)
    Point3DNormalizeMethodInfo              ,
#endif
    point3DNormalize                        ,


-- ** normalizeViewport #method:normalizeViewport#

#if defined(ENABLE_OVERLOADING)
    Point3DNormalizeViewportMethodInfo      ,
#endif
    point3DNormalizeViewport                ,


-- ** scale #method:scale#

#if defined(ENABLE_OVERLOADING)
    Point3DScaleMethodInfo                  ,
#endif
    point3DScale                            ,


-- ** toVec3 #method:toVec3#

#if defined(ENABLE_OVERLOADING)
    Point3DToVec3MethodInfo                 ,
#endif
    point3DToVec3                           ,


-- ** zero #method:zero#

    point3DZero                             ,




 -- * Properties


-- ** x #attr:x#
-- | the X coordinate

    getPoint3DX                             ,
#if defined(ENABLE_OVERLOADING)
    point3D_x                               ,
#endif
    setPoint3DX                             ,


-- ** y #attr:y#
-- | the Y coordinate

    getPoint3DY                             ,
#if defined(ENABLE_OVERLOADING)
    point3D_y                               ,
#endif
    setPoint3DY                             ,


-- ** z #attr:z#
-- | the Z coordinate

    getPoint3DZ                             ,
#if defined(ENABLE_OVERLOADING)
    point3D_z                               ,
#endif
    setPoint3DZ                             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Graphene.Structs.Point as Graphene.Point
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Size as Graphene.Size
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec2 as Graphene.Vec2
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4

#else
import {-# SOURCE #-} qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3

#endif

-- | Memory-managed wrapper type.
newtype Point3D = Point3D (SP.ManagedPtr Point3D)
    deriving (Eq)

instance SP.ManagedPtrNewtype Point3D where
    toManagedPtr (Point3D p) = p

foreign import ccall "graphene_point3d_get_type" c_graphene_point3d_get_type :: 
    IO GType

type instance O.ParentTypes Point3D = '[]
instance O.HasParentTypes Point3D

instance B.Types.TypedObject Point3D where
    glibType = c_graphene_point3d_get_type

instance B.Types.GBoxed Point3D

-- | Convert t'Point3D' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Point3D) where
    gvalueGType_ = c_graphene_point3d_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Point3D)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Point3D)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Point3D ptr
        else return P.Nothing
        
    

-- | Construct a t'Point3D' struct initialized to zero.
newZeroPoint3D :: MonadIO m => m Point3D
newZeroPoint3D = liftIO $ callocBoxedBytes 12 >>= wrapBoxed Point3D

instance tag ~ 'AttrSet => Constructible Point3D tag where
    new _ attrs = do
        o <- newZeroPoint3D
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' point3D #x
-- @
getPoint3DX :: MonadIO m => Point3D -> m Float
getPoint3DX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' point3D [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setPoint3DX :: MonadIO m => Point3D -> Float -> m ()
setPoint3DX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data Point3DXFieldInfo
instance AttrInfo Point3DXFieldInfo where
    type AttrBaseTypeConstraint Point3DXFieldInfo = (~) Point3D
    type AttrAllowedOps Point3DXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint Point3DXFieldInfo = (~) Float
    type AttrTransferTypeConstraint Point3DXFieldInfo = (~)Float
    type AttrTransferType Point3DXFieldInfo = Float
    type AttrGetType Point3DXFieldInfo = Float
    type AttrLabel Point3DXFieldInfo = "x"
    type AttrOrigin Point3DXFieldInfo = Point3D
    attrGet = getPoint3DX
    attrSet = setPoint3DX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#g:attr:x"
        })

point3D_x :: AttrLabelProxy "x"
point3D_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' point3D #y
-- @
getPoint3DY :: MonadIO m => Point3D -> m Float
getPoint3DY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' point3D [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setPoint3DY :: MonadIO m => Point3D -> Float -> m ()
setPoint3DY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 4) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data Point3DYFieldInfo
instance AttrInfo Point3DYFieldInfo where
    type AttrBaseTypeConstraint Point3DYFieldInfo = (~) Point3D
    type AttrAllowedOps Point3DYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint Point3DYFieldInfo = (~) Float
    type AttrTransferTypeConstraint Point3DYFieldInfo = (~)Float
    type AttrTransferType Point3DYFieldInfo = Float
    type AttrGetType Point3DYFieldInfo = Float
    type AttrLabel Point3DYFieldInfo = "y"
    type AttrOrigin Point3DYFieldInfo = Point3D
    attrGet = getPoint3DY
    attrSet = setPoint3DY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#g:attr:y"
        })

point3D_y :: AttrLabelProxy "y"
point3D_y = AttrLabelProxy

#endif


-- | Get the value of the “@z@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' point3D #z
-- @
getPoint3DZ :: MonadIO m => Point3D -> m Float
getPoint3DZ s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CFloat
    let val' = realToFrac val
    return val'

-- | Set the value of the “@z@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' point3D [ #z 'Data.GI.Base.Attributes.:=' value ]
-- @
setPoint3DZ :: MonadIO m => Point3D -> Float -> m ()
setPoint3DZ s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 8) (val' :: CFloat)

#if defined(ENABLE_OVERLOADING)
data Point3DZFieldInfo
instance AttrInfo Point3DZFieldInfo where
    type AttrBaseTypeConstraint Point3DZFieldInfo = (~) Point3D
    type AttrAllowedOps Point3DZFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint Point3DZFieldInfo = (~) Float
    type AttrTransferTypeConstraint Point3DZFieldInfo = (~)Float
    type AttrTransferType Point3DZFieldInfo = Float
    type AttrGetType Point3DZFieldInfo = Float
    type AttrLabel Point3DZFieldInfo = "z"
    type AttrOrigin Point3DZFieldInfo = Point3D
    attrGet = getPoint3DZ
    attrSet = setPoint3DZ
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.z"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#g:attr:z"
        })

point3D_z :: AttrLabelProxy "z"
point3D_z = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Point3D
type instance O.AttributeList Point3D = Point3DAttributeList
type Point3DAttributeList = ('[ '("x", Point3DXFieldInfo), '("y", Point3DYFieldInfo), '("z", Point3DZFieldInfo)] :: [(Symbol, DK.Type)])
#endif

-- method Point3D::alloc
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Point3D" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_alloc" graphene_point3d_alloc :: 
    IO (Ptr Point3D)

-- | Allocates a t'GI.Graphene.Structs.Point3D.Point3D' structure.
-- 
-- /Since: 1.0/
point3DAlloc ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Point3D
    -- ^ __Returns:__ the newly allocated structure.
    --   Use 'GI.Graphene.Structs.Point3D.point3DFree' to free the resources
    --   allocated by this function.
point3DAlloc  = liftIO $ do
    result <- graphene_point3d_alloc
    checkUnexpectedReturnNULL "point3DAlloc" result
    result' <- (wrapBoxed Point3D) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method Point3D::cross
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the cross\n  product"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_cross" graphene_point3d_cross :: 
    Ptr Point3D ->                          -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- res : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Computes the cross product of the two given t'GI.Graphene.Structs.Point3D.Point3D'.
-- 
-- /Since: 1.0/
point3DCross ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Point3D
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m (Point3D)
point3DCross a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    res <- SP.callocBoxedBytes 12 :: IO (Ptr Point3D)
    graphene_point3d_cross a' b' res
    res' <- (wrapBoxed Point3D) res
    touchManagedPtr a
    touchManagedPtr b
    return res'

#if defined(ENABLE_OVERLOADING)
data Point3DCrossMethodInfo
instance (signature ~ (Point3D -> m (Point3D)), MonadIO m) => O.OverloadedMethod Point3DCrossMethodInfo Point3D signature where
    overloadedMethod = point3DCross

instance O.OverloadedMethodInfo Point3DCrossMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DCross",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DCross"
        })


#endif

-- method Point3D::distance
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "delta"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for the distance\n  components on the X, Y, and Z axis"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_distance" graphene_point3d_distance :: 
    Ptr Point3D ->                          -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Vec3.Vec3 ->               -- delta : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO CFloat

-- | Computes the distance between the two given t'GI.Graphene.Structs.Point3D.Point3D'.
-- 
-- /Since: 1.4/
point3DDistance ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Point3D
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m ((Float, Graphene.Vec3.Vec3))
    -- ^ __Returns:__ the distance between two points
point3DDistance a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    delta <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    result <- graphene_point3d_distance a' b' delta
    let result' = realToFrac result
    delta' <- (wrapBoxed Graphene.Vec3.Vec3) delta
    touchManagedPtr a
    touchManagedPtr b
    return (result', delta')

#if defined(ENABLE_OVERLOADING)
data Point3DDistanceMethodInfo
instance (signature ~ (Point3D -> m ((Float, Graphene.Vec3.Vec3))), MonadIO m) => O.OverloadedMethod Point3DDistanceMethodInfo Point3D signature where
    overloadedMethod = point3DDistance

instance O.OverloadedMethodInfo Point3DDistanceMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DDistance",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DDistance"
        })


#endif

-- method Point3D::dot
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_dot" graphene_point3d_dot :: 
    Ptr Point3D ->                          -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CFloat

-- | Computes the dot product of the two given t'GI.Graphene.Structs.Point3D.Point3D'.
-- 
-- /Since: 1.0/
point3DDot ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Point3D
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Float
    -- ^ __Returns:__ the value of the dot product
point3DDot a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_point3d_dot a' b'
    let result' = realToFrac result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data Point3DDotMethodInfo
instance (signature ~ (Point3D -> m Float), MonadIO m) => O.OverloadedMethod Point3DDotMethodInfo Point3D signature where
    overloadedMethod = point3DDot

instance O.OverloadedMethodInfo Point3DDotMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DDot",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DDot"
        })


#endif

-- method Point3D::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_equal" graphene_point3d_equal :: 
    Ptr Point3D ->                          -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CInt

-- | Checks whether two given points are equal.
-- 
-- /Since: 1.0/
point3DEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Point3D
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Bool
    -- ^ __Returns:__ @true@ if the points are equal
point3DEqual a b = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    result <- graphene_point3d_equal a' b'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data Point3DEqualMethodInfo
instance (signature ~ (Point3D -> m Bool), MonadIO m) => O.OverloadedMethod Point3DEqualMethodInfo Point3D signature where
    overloadedMethod = point3DEqual

instance O.OverloadedMethodInfo Point3DEqualMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DEqual"
        })


#endif

-- method Point3D::free
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_free" graphene_point3d_free :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Frees the resources allocated via 'GI.Graphene.Structs.Point3D.point3DAlloc'.
-- 
-- /Since: 1.0/
point3DFree ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m ()
point3DFree p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    graphene_point3d_free p'
    touchManagedPtr p
    return ()

#if defined(ENABLE_OVERLOADING)
data Point3DFreeMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod Point3DFreeMethodInfo Point3D signature where
    overloadedMethod = point3DFree

instance O.OverloadedMethodInfo Point3DFreeMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DFree",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DFree"
        })


#endif

-- method Point3D::init
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the #graphene_point3d_t to initialize"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "x"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the X coordinate of the point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "y"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the Y coordinate of the point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "z"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the Z coordinate of the point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Point3D" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_init" graphene_point3d_init :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    CFloat ->                               -- x : TBasicType TFloat
    CFloat ->                               -- y : TBasicType TFloat
    CFloat ->                               -- z : TBasicType TFloat
    IO (Ptr Point3D)

-- | Initializes a t'GI.Graphene.Structs.Point3D.Point3D' with the given coordinates.
-- 
-- /Since: 1.0/
point3DInit ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: the t'GI.Graphene.Structs.Point3D.Point3D' to initialize
    -> Float
    -- ^ /@x@/: the X coordinate of the point
    -> Float
    -- ^ /@y@/: the Y coordinate of the point
    -> Float
    -- ^ /@z@/: the Z coordinate of the point
    -> m Point3D
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Point3D.Point3D'
point3DInit p x y z = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    let x' = realToFrac x
    let y' = realToFrac y
    let z' = realToFrac z
    result <- graphene_point3d_init p' x' y' z'
    checkUnexpectedReturnNULL "point3DInit" result
    result' <- (newBoxed Point3D) result
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data Point3DInitMethodInfo
instance (signature ~ (Float -> Float -> Float -> m Point3D), MonadIO m) => O.OverloadedMethod Point3DInitMethodInfo Point3D signature where
    overloadedMethod = point3DInit

instance O.OverloadedMethodInfo Point3DInitMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DInit",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DInit"
        })


#endif

-- method Point3D::init_from_point
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "src"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Point3D" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_init_from_point" graphene_point3d_init_from_point :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- src : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO (Ptr Point3D)

-- | Initializes a t'GI.Graphene.Structs.Point3D.Point3D' using the coordinates of
-- another t'GI.Graphene.Structs.Point3D.Point3D'.
-- 
-- /Since: 1.0/
point3DInitFromPoint ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Point3D
    -- ^ /@src@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Point3D
    -- ^ __Returns:__ the initialized point
point3DInitFromPoint p src = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    src' <- unsafeManagedPtrGetPtr src
    result <- graphene_point3d_init_from_point p' src'
    checkUnexpectedReturnNULL "point3DInitFromPoint" result
    result' <- (newBoxed Point3D) result
    touchManagedPtr p
    touchManagedPtr src
    return result'

#if defined(ENABLE_OVERLOADING)
data Point3DInitFromPointMethodInfo
instance (signature ~ (Point3D -> m Point3D), MonadIO m) => O.OverloadedMethod Point3DInitFromPointMethodInfo Point3D signature where
    overloadedMethod = point3DInitFromPoint

instance O.OverloadedMethodInfo Point3DInitFromPointMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DInitFromPoint",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DInitFromPoint"
        })


#endif

-- method Point3D::init_from_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "v"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_vec3_t" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Point3D" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_init_from_vec3" graphene_point3d_init_from_vec3 :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Vec3.Vec3 ->               -- v : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO (Ptr Point3D)

-- | Initializes a t'GI.Graphene.Structs.Point3D.Point3D' using the components
-- of a t'GI.Graphene.Structs.Vec3.Vec3'.
-- 
-- /Since: 1.0/
point3DInitFromVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Graphene.Vec3.Vec3
    -- ^ /@v@/: a t'GI.Graphene.Structs.Vec3.Vec3'
    -> m Point3D
    -- ^ __Returns:__ the initialized t'GI.Graphene.Structs.Point3D.Point3D'
point3DInitFromVec3 p v = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    v' <- unsafeManagedPtrGetPtr v
    result <- graphene_point3d_init_from_vec3 p' v'
    checkUnexpectedReturnNULL "point3DInitFromVec3" result
    result' <- (newBoxed Point3D) result
    touchManagedPtr p
    touchManagedPtr v
    return result'

#if defined(ENABLE_OVERLOADING)
data Point3DInitFromVec3MethodInfo
instance (signature ~ (Graphene.Vec3.Vec3 -> m Point3D), MonadIO m) => O.OverloadedMethod Point3DInitFromVec3MethodInfo Point3D signature where
    overloadedMethod = point3DInitFromVec3

instance O.OverloadedMethodInfo Point3DInitFromVec3MethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DInitFromVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DInitFromVec3"
        })


#endif

-- method Point3D::interpolate
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TDouble
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the interpolation factor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the return location for the\n  interpolated #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_interpolate" graphene_point3d_interpolate :: 
    Ptr Point3D ->                          -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    CDouble ->                              -- factor : TBasicType TDouble
    Ptr Point3D ->                          -- res : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Linearly interpolates each component of /@a@/ and /@b@/ using the
-- provided /@factor@/, and places the result in /@res@/.
-- 
-- /Since: 1.0/
point3DInterpolate ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Point3D
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Double
    -- ^ /@factor@/: the interpolation factor
    -> m (Point3D)
point3DInterpolate a b factor = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    let factor' = realToFrac factor
    res <- SP.callocBoxedBytes 12 :: IO (Ptr Point3D)
    graphene_point3d_interpolate a' b' factor' res
    res' <- (wrapBoxed Point3D) res
    touchManagedPtr a
    touchManagedPtr b
    return res'

#if defined(ENABLE_OVERLOADING)
data Point3DInterpolateMethodInfo
instance (signature ~ (Point3D -> Double -> m (Point3D)), MonadIO m) => O.OverloadedMethod Point3DInterpolateMethodInfo Point3D signature where
    overloadedMethod = point3DInterpolate

instance O.OverloadedMethodInfo Point3DInterpolateMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DInterpolate",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DInterpolate"
        })


#endif

-- method Point3D::length
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TFloat)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_length" graphene_point3d_length :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO CFloat

-- | Computes the length of the vector represented by the
-- coordinates of the given t'GI.Graphene.Structs.Point3D.Point3D'.
-- 
-- /Since: 1.0/
point3DLength ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m Float
    -- ^ __Returns:__ the length of the vector represented by the point
point3DLength p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    result <- graphene_point3d_length p'
    let result' = realToFrac result
    touchManagedPtr p
    return result'

#if defined(ENABLE_OVERLOADING)
data Point3DLengthMethodInfo
instance (signature ~ (m Float), MonadIO m) => O.OverloadedMethod Point3DLengthMethodInfo Point3D signature where
    overloadedMethod = point3DLength

instance O.OverloadedMethodInfo Point3DLengthMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DLength",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DLength"
        })


#endif

-- method Point3D::near
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "a"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "b"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "epsilon"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "fuzzyness factor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_near" graphene_point3d_near :: 
    Ptr Point3D ->                          -- a : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- b : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    CFloat ->                               -- epsilon : TBasicType TFloat
    IO CInt

-- | Checks whether the two points are near each other, within
-- an /@epsilon@/ factor.
-- 
-- /Since: 1.0/
point3DNear ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@a@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Point3D
    -- ^ /@b@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Float
    -- ^ /@epsilon@/: fuzzyness factor
    -> m Bool
    -- ^ __Returns:__ @true@ if the points are near each other
point3DNear a b epsilon = liftIO $ do
    a' <- unsafeManagedPtrGetPtr a
    b' <- unsafeManagedPtrGetPtr b
    let epsilon' = realToFrac epsilon
    result <- graphene_point3d_near a' b' epsilon'
    let result' = (/= 0) result
    touchManagedPtr a
    touchManagedPtr b
    return result'

#if defined(ENABLE_OVERLOADING)
data Point3DNearMethodInfo
instance (signature ~ (Point3D -> Float -> m Bool), MonadIO m) => O.OverloadedMethod Point3DNearMethodInfo Point3D signature where
    overloadedMethod = point3DNear

instance O.OverloadedMethodInfo Point3DNearMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DNear",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DNear"
        })


#endif

-- method Point3D::normalize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for the normalized\n  #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_normalize" graphene_point3d_normalize :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Point3D ->                          -- res : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Computes the normalization of the vector represented by the
-- coordinates of the given t'GI.Graphene.Structs.Point3D.Point3D'.
-- 
-- /Since: 1.0/
point3DNormalize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m (Point3D)
point3DNormalize p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    res <- SP.callocBoxedBytes 12 :: IO (Ptr Point3D)
    graphene_point3d_normalize p' res
    res' <- (wrapBoxed Point3D) res
    touchManagedPtr p
    return res'

#if defined(ENABLE_OVERLOADING)
data Point3DNormalizeMethodInfo
instance (signature ~ (m (Point3D)), MonadIO m) => O.OverloadedMethod Point3DNormalizeMethodInfo Point3D signature where
    overloadedMethod = point3DNormalize

instance O.OverloadedMethodInfo Point3DNormalizeMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DNormalize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DNormalize"
        })


#endif

-- method Point3D::normalize_viewport
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "viewport"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_rect_t representing a viewport"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "z_near"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the coordinate of the near clipping plane, or 0 for\n  the default near clipping plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "z_far"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the coordinate of the far clipping plane, or 1 for the\n  default far clipping plane"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the return location for the\n  normalized #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_normalize_viewport" graphene_point3d_normalize_viewport :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Rect.Rect ->               -- viewport : TInterface (Name {namespace = "Graphene", name = "Rect"})
    CFloat ->                               -- z_near : TBasicType TFloat
    CFloat ->                               -- z_far : TBasicType TFloat
    Ptr Point3D ->                          -- res : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Normalizes the coordinates of a t'GI.Graphene.Structs.Point3D.Point3D' using the
-- given viewport and clipping planes.
-- 
-- The coordinates of the resulting t'GI.Graphene.Structs.Point3D.Point3D' will be
-- in the [ -1, 1 ] range.
-- 
-- /Since: 1.4/
point3DNormalizeViewport ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Graphene.Rect.Rect
    -- ^ /@viewport@/: a t'GI.Graphene.Structs.Rect.Rect' representing a viewport
    -> Float
    -- ^ /@zNear@/: the coordinate of the near clipping plane, or 0 for
    --   the default near clipping plane
    -> Float
    -- ^ /@zFar@/: the coordinate of the far clipping plane, or 1 for the
    --   default far clipping plane
    -> m (Point3D)
point3DNormalizeViewport p viewport zNear zFar = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    viewport' <- unsafeManagedPtrGetPtr viewport
    let zNear' = realToFrac zNear
    let zFar' = realToFrac zFar
    res <- SP.callocBoxedBytes 12 :: IO (Ptr Point3D)
    graphene_point3d_normalize_viewport p' viewport' zNear' zFar' res
    res' <- (wrapBoxed Point3D) res
    touchManagedPtr p
    touchManagedPtr viewport
    return res'

#if defined(ENABLE_OVERLOADING)
data Point3DNormalizeViewportMethodInfo
instance (signature ~ (Graphene.Rect.Rect -> Float -> Float -> m (Point3D)), MonadIO m) => O.OverloadedMethod Point3DNormalizeViewportMethodInfo Point3D signature where
    overloadedMethod = point3DNormalizeViewport

instance O.OverloadedMethodInfo Point3DNormalizeViewportMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DNormalizeViewport",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DNormalizeViewport"
        })


#endif

-- method Point3D::scale
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "factor"
--           , argType = TBasicType TFloat
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the scaling factor" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "res"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the scaled point"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_scale" graphene_point3d_scale :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    CFloat ->                               -- factor : TBasicType TFloat
    Ptr Point3D ->                          -- res : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    IO ()

-- | Scales the coordinates of the given t'GI.Graphene.Structs.Point3D.Point3D' by
-- the given /@factor@/.
-- 
-- /Since: 1.0/
point3DScale ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> Float
    -- ^ /@factor@/: the scaling factor
    -> m (Point3D)
point3DScale p factor = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    let factor' = realToFrac factor
    res <- SP.callocBoxedBytes 12 :: IO (Ptr Point3D)
    graphene_point3d_scale p' factor' res
    res' <- (wrapBoxed Point3D) res
    touchManagedPtr p
    return res'

#if defined(ENABLE_OVERLOADING)
data Point3DScaleMethodInfo
instance (signature ~ (Float -> m (Point3D)), MonadIO m) => O.OverloadedMethod Point3DScaleMethodInfo Point3D signature where
    overloadedMethod = point3DScale

instance O.OverloadedMethodInfo Point3DScaleMethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DScale",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DScale"
        })


#endif

-- method Point3D::to_vec3
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "p"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point3D" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #graphene_point3d_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "v"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Vec3" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for a #graphene_vec3_t"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = True
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_to_vec3" graphene_point3d_to_vec3 :: 
    Ptr Point3D ->                          -- p : TInterface (Name {namespace = "Graphene", name = "Point3D"})
    Ptr Graphene.Vec3.Vec3 ->               -- v : TInterface (Name {namespace = "Graphene", name = "Vec3"})
    IO ()

-- | Stores the coordinates of a t'GI.Graphene.Structs.Point3D.Point3D' into a
-- t'GI.Graphene.Structs.Vec3.Vec3'.
-- 
-- /Since: 1.0/
point3DToVec3 ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Point3D
    -- ^ /@p@/: a t'GI.Graphene.Structs.Point3D.Point3D'
    -> m (Graphene.Vec3.Vec3)
point3DToVec3 p = liftIO $ do
    p' <- unsafeManagedPtrGetPtr p
    v <- SP.callocBoxedBytes 16 :: IO (Ptr Graphene.Vec3.Vec3)
    graphene_point3d_to_vec3 p' v
    v' <- (wrapBoxed Graphene.Vec3.Vec3) v
    touchManagedPtr p
    return v'

#if defined(ENABLE_OVERLOADING)
data Point3DToVec3MethodInfo
instance (signature ~ (m (Graphene.Vec3.Vec3)), MonadIO m) => O.OverloadedMethod Point3DToVec3MethodInfo Point3D signature where
    overloadedMethod = point3DToVec3

instance O.OverloadedMethodInfo Point3DToVec3MethodInfo Point3D where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Graphene.Structs.Point3D.point3DToVec3",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-graphene-1.0.8/docs/GI-Graphene-Structs-Point3D.html#v:point3DToVec3"
        })


#endif

-- method Point3D::zero
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Graphene" , name = "Point3D" })
-- throws : False
-- Skip return : False

foreign import ccall "graphene_point3d_zero" graphene_point3d_zero :: 
    IO (Ptr Point3D)

-- | Retrieves a constant point with all three coordinates set to 0.
-- 
-- /Since: 1.0/
point3DZero ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m Point3D
    -- ^ __Returns:__ a zero point
point3DZero  = liftIO $ do
    result <- graphene_point3d_zero
    checkUnexpectedReturnNULL "point3DZero" result
    result' <- (newBoxed Point3D) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePoint3DMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePoint3DMethod "cross" o = Point3DCrossMethodInfo
    ResolvePoint3DMethod "distance" o = Point3DDistanceMethodInfo
    ResolvePoint3DMethod "dot" o = Point3DDotMethodInfo
    ResolvePoint3DMethod "equal" o = Point3DEqualMethodInfo
    ResolvePoint3DMethod "free" o = Point3DFreeMethodInfo
    ResolvePoint3DMethod "init" o = Point3DInitMethodInfo
    ResolvePoint3DMethod "initFromPoint" o = Point3DInitFromPointMethodInfo
    ResolvePoint3DMethod "initFromVec3" o = Point3DInitFromVec3MethodInfo
    ResolvePoint3DMethod "interpolate" o = Point3DInterpolateMethodInfo
    ResolvePoint3DMethod "length" o = Point3DLengthMethodInfo
    ResolvePoint3DMethod "near" o = Point3DNearMethodInfo
    ResolvePoint3DMethod "normalize" o = Point3DNormalizeMethodInfo
    ResolvePoint3DMethod "normalizeViewport" o = Point3DNormalizeViewportMethodInfo
    ResolvePoint3DMethod "scale" o = Point3DScaleMethodInfo
    ResolvePoint3DMethod "toVec3" o = Point3DToVec3MethodInfo
    ResolvePoint3DMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePoint3DMethod t Point3D, O.OverloadedMethod info Point3D p) => OL.IsLabel t (Point3D -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePoint3DMethod t Point3D, O.OverloadedMethod info Point3D p, R.HasField t Point3D p) => R.HasField t Point3D p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePoint3DMethod t Point3D, O.OverloadedMethodInfo info Point3D) => OL.IsLabel t (O.MethodProxy info Point3D) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


