{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- An AtkObject which purports to implement all ATK interfaces.
-- 
-- An AtkNoOpObject is an AtkObject which purports to implement all
-- ATK interfaces. It is the type of AtkObject which is created if an
-- accessible object is requested for an object type for which no
-- factory type is specified.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Atk.Objects.NoOpObject
    ( 

-- * Exported types
    NoOpObject(..)                          ,
    IsNoOpObject                            ,
    toNoOpObject                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addColumnSelection]("GI.Atk.Interfaces.Table#g:method:addColumnSelection"), [addRelationship]("GI.Atk.Objects.Object#g:method:addRelationship"), [addRowSelection]("GI.Atk.Interfaces.Table#g:method:addRowSelection"), [addSelection]("GI.Atk.Interfaces.Selection#g:method:addSelection"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [clearSelection]("GI.Atk.Interfaces.Selection#g:method:clearSelection"), [contains]("GI.Atk.Interfaces.Component#g:method:contains"), [copyText]("GI.Atk.Interfaces.EditableText#g:method:copyText"), [cutText]("GI.Atk.Interfaces.EditableText#g:method:cutText"), [deleteText]("GI.Atk.Interfaces.EditableText#g:method:deleteText"), [doAction]("GI.Atk.Interfaces.Action#g:method:doAction"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Atk.Interfaces.Component#g:method:grabFocus"), [initialize]("GI.Atk.Objects.Object#g:method:initialize"), [insertText]("GI.Atk.Interfaces.EditableText#g:method:insertText"), [isChildSelected]("GI.Atk.Interfaces.Selection#g:method:isChildSelected"), [isColumnSelected]("GI.Atk.Interfaces.Table#g:method:isColumnSelected"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isRowSelected]("GI.Atk.Interfaces.Table#g:method:isRowSelected"), [isSelected]("GI.Atk.Interfaces.Table#g:method:isSelected"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [notifyStateChange]("GI.Atk.Objects.Object#g:method:notifyStateChange"), [pasteText]("GI.Atk.Interfaces.EditableText#g:method:pasteText"), [peekParent]("GI.Atk.Objects.Object#g:method:peekParent"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refAccessibleAtPoint]("GI.Atk.Interfaces.Component#g:method:refAccessibleAtPoint"), [refAccessibleChild]("GI.Atk.Objects.Object#g:method:refAccessibleChild"), [refAt]("GI.Atk.Interfaces.Table#g:method:refAt"), [refRelationSet]("GI.Atk.Objects.Object#g:method:refRelationSet"), [refSelection]("GI.Atk.Interfaces.Selection#g:method:refSelection"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [refStateSet]("GI.Atk.Objects.Object#g:method:refStateSet"), [removeColumnSelection]("GI.Atk.Interfaces.Table#g:method:removeColumnSelection"), [removeFocusHandler]("GI.Atk.Interfaces.Component#g:method:removeFocusHandler"), [removePropertyChangeHandler]("GI.Atk.Objects.Object#g:method:removePropertyChangeHandler"), [removeRelationship]("GI.Atk.Objects.Object#g:method:removeRelationship"), [removeRowSelection]("GI.Atk.Interfaces.Table#g:method:removeRowSelection"), [removeSelection]("GI.Atk.Interfaces.Selection#g:method:removeSelection"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [scrollSubstringTo]("GI.Atk.Interfaces.Text#g:method:scrollSubstringTo"), [scrollSubstringToPoint]("GI.Atk.Interfaces.Text#g:method:scrollSubstringToPoint"), [scrollTo]("GI.Atk.Interfaces.Component#g:method:scrollTo"), [scrollToPoint]("GI.Atk.Interfaces.Component#g:method:scrollToPoint"), [selectAllSelection]("GI.Atk.Interfaces.Selection#g:method:selectAllSelection"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleId]("GI.Atk.Objects.Object#g:method:getAccessibleId"), [getAlpha]("GI.Atk.Interfaces.Component#g:method:getAlpha"), [getAttributeValue]("GI.Atk.Interfaces.Document#g:method:getAttributeValue"), [getAttributes]("GI.Atk.Objects.Object#g:method:getAttributes"), [getBoundedRanges]("GI.Atk.Interfaces.Text#g:method:getBoundedRanges"), [getCaption]("GI.Atk.Interfaces.Table#g:method:getCaption"), [getCaretOffset]("GI.Atk.Interfaces.Text#g:method:getCaretOffset"), [getCharacterAtOffset]("GI.Atk.Interfaces.Text#g:method:getCharacterAtOffset"), [getCharacterCount]("GI.Atk.Interfaces.Text#g:method:getCharacterCount"), [getCharacterExtents]("GI.Atk.Interfaces.Text#g:method:getCharacterExtents"), [getColumnAtIndex]("GI.Atk.Interfaces.Table#g:method:getColumnAtIndex"), [getColumnDescription]("GI.Atk.Interfaces.Table#g:method:getColumnDescription"), [getColumnExtentAt]("GI.Atk.Interfaces.Table#g:method:getColumnExtentAt"), [getColumnHeader]("GI.Atk.Interfaces.Table#g:method:getColumnHeader"), [getColumnHeaderCells]("GI.Atk.Interfaces.TableCell#g:method:getColumnHeaderCells"), [getColumnSpan]("GI.Atk.Interfaces.TableCell#g:method:getColumnSpan"), [getCurrentPageNumber]("GI.Atk.Interfaces.Document#g:method:getCurrentPageNumber"), [getCurrentValue]("GI.Atk.Interfaces.Value#g:method:getCurrentValue"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultAttributes]("GI.Atk.Interfaces.Text#g:method:getDefaultAttributes"), [getDescription]("GI.Atk.Objects.Object#g:method:getDescription"), [getDocument]("GI.Atk.Interfaces.Document#g:method:getDocument"), [getDocumentType]("GI.Atk.Interfaces.Document#g:method:getDocumentType"), [getExtents]("GI.Atk.Interfaces.Component#g:method:getExtents"), [getHelpText]("GI.Atk.Objects.Object#g:method:getHelpText"), [getImageDescription]("GI.Atk.Interfaces.Image#g:method:getImageDescription"), [getImageLocale]("GI.Atk.Interfaces.Image#g:method:getImageLocale"), [getImagePosition]("GI.Atk.Interfaces.Image#g:method:getImagePosition"), [getImageSize]("GI.Atk.Interfaces.Image#g:method:getImageSize"), [getIncrement]("GI.Atk.Interfaces.Value#g:method:getIncrement"), [getIndexAt]("GI.Atk.Interfaces.Table#g:method:getIndexAt"), [getIndexInParent]("GI.Atk.Objects.Object#g:method:getIndexInParent"), [getKeybinding]("GI.Atk.Interfaces.Action#g:method:getKeybinding"), [getLayer]("GI.Atk.Objects.Object#g:method:getLayer"), [getLink]("GI.Atk.Interfaces.Hypertext#g:method:getLink"), [getLinkIndex]("GI.Atk.Interfaces.Hypertext#g:method:getLinkIndex"), [getLocale]("GI.Atk.Interfaces.Document#g:method:getLocale"), [getLocalizedName]("GI.Atk.Interfaces.Action#g:method:getLocalizedName"), [getMaximumValue]("GI.Atk.Interfaces.Value#g:method:getMaximumValue"), [getMdiZorder]("GI.Atk.Objects.Object#g:method:getMdiZorder"), [getMinimumIncrement]("GI.Atk.Interfaces.Value#g:method:getMinimumIncrement"), [getMinimumValue]("GI.Atk.Interfaces.Value#g:method:getMinimumValue"), [getNAccessibleChildren]("GI.Atk.Objects.Object#g:method:getNAccessibleChildren"), [getNActions]("GI.Atk.Interfaces.Action#g:method:getNActions"), [getNColumns]("GI.Atk.Interfaces.Table#g:method:getNColumns"), [getNLinks]("GI.Atk.Interfaces.Hypertext#g:method:getNLinks"), [getNRows]("GI.Atk.Interfaces.Table#g:method:getNRows"), [getNSelections]("GI.Atk.Interfaces.Text#g:method:getNSelections"), [getName]("GI.Atk.Objects.Object#g:method:getName"), [getObjectLocale]("GI.Atk.Objects.Object#g:method:getObjectLocale"), [getOffsetAtPoint]("GI.Atk.Interfaces.Text#g:method:getOffsetAtPoint"), [getPageCount]("GI.Atk.Interfaces.Document#g:method:getPageCount"), [getParent]("GI.Atk.Objects.Object#g:method:getParent"), [getPosition]("GI.Atk.Interfaces.Component#g:method:getPosition"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRange]("GI.Atk.Interfaces.Value#g:method:getRange"), [getRangeExtents]("GI.Atk.Interfaces.Text#g:method:getRangeExtents"), [getRole]("GI.Atk.Objects.Object#g:method:getRole"), [getRowAtIndex]("GI.Atk.Interfaces.Table#g:method:getRowAtIndex"), [getRowColumnSpan]("GI.Atk.Interfaces.TableCell#g:method:getRowColumnSpan"), [getRowDescription]("GI.Atk.Interfaces.Table#g:method:getRowDescription"), [getRowExtentAt]("GI.Atk.Interfaces.Table#g:method:getRowExtentAt"), [getRowHeader]("GI.Atk.Interfaces.Table#g:method:getRowHeader"), [getRowHeaderCells]("GI.Atk.Interfaces.TableCell#g:method:getRowHeaderCells"), [getRowSpan]("GI.Atk.Interfaces.TableCell#g:method:getRowSpan"), [getRunAttributes]("GI.Atk.Interfaces.Text#g:method:getRunAttributes"), [getSelectedColumns]("GI.Atk.Interfaces.Table#g:method:getSelectedColumns"), [getSelectedRows]("GI.Atk.Interfaces.Table#g:method:getSelectedRows"), [getSelection]("GI.Atk.Interfaces.Text#g:method:getSelection"), [getSelectionCount]("GI.Atk.Interfaces.Selection#g:method:getSelectionCount"), [getSize]("GI.Atk.Interfaces.Component#g:method:getSize"), [getStringAtOffset]("GI.Atk.Interfaces.Text#g:method:getStringAtOffset"), [getSubRanges]("GI.Atk.Interfaces.Value#g:method:getSubRanges"), [getSummary]("GI.Atk.Interfaces.Table#g:method:getSummary"), [getTable]("GI.Atk.Interfaces.TableCell#g:method:getTable"), [getText]("GI.Atk.Interfaces.Text#g:method:getText"), [getTextAfterOffset]("GI.Atk.Interfaces.Text#g:method:getTextAfterOffset"), [getTextAtOffset]("GI.Atk.Interfaces.Text#g:method:getTextAtOffset"), [getTextBeforeOffset]("GI.Atk.Interfaces.Text#g:method:getTextBeforeOffset"), [getTextSelections]("GI.Atk.Interfaces.Document#g:method:getTextSelections"), [getValueAndText]("GI.Atk.Interfaces.Value#g:method:getValueAndText").
-- 
-- ==== Setters
-- [setAccessibleId]("GI.Atk.Objects.Object#g:method:setAccessibleId"), [setAttributeValue]("GI.Atk.Interfaces.Document#g:method:setAttributeValue"), [setCaption]("GI.Atk.Interfaces.Table#g:method:setCaption"), [setCaretOffset]("GI.Atk.Interfaces.Text#g:method:setCaretOffset"), [setColumnDescription]("GI.Atk.Interfaces.Table#g:method:setColumnDescription"), [setColumnHeader]("GI.Atk.Interfaces.Table#g:method:setColumnHeader"), [setCurrentValue]("GI.Atk.Interfaces.Value#g:method:setCurrentValue"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDescription]("GI.Atk.Objects.Object#g:method:setDescription"), [setExtents]("GI.Atk.Interfaces.Component#g:method:setExtents"), [setHelpText]("GI.Atk.Objects.Object#g:method:setHelpText"), [setImageDescription]("GI.Atk.Interfaces.Image#g:method:setImageDescription"), [setName]("GI.Atk.Objects.Object#g:method:setName"), [setParent]("GI.Atk.Objects.Object#g:method:setParent"), [setPosition]("GI.Atk.Interfaces.Component#g:method:setPosition"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRole]("GI.Atk.Objects.Object#g:method:setRole"), [setRowDescription]("GI.Atk.Interfaces.Table#g:method:setRowDescription"), [setRowHeader]("GI.Atk.Interfaces.Table#g:method:setRowHeader"), [setRunAttributes]("GI.Atk.Interfaces.EditableText#g:method:setRunAttributes"), [setSelection]("GI.Atk.Interfaces.Text#g:method:setSelection"), [setSize]("GI.Atk.Interfaces.Component#g:method:setSize"), [setSummary]("GI.Atk.Interfaces.Table#g:method:setSummary"), [setTextContents]("GI.Atk.Interfaces.EditableText#g:method:setTextContents"), [setTextSelections]("GI.Atk.Interfaces.Document#g:method:setTextSelections"), [setValue]("GI.Atk.Interfaces.Value#g:method:setValue").

#if defined(ENABLE_OVERLOADING)
    ResolveNoOpObjectMethod                 ,
#endif

-- ** new #method:new#

    noOpObjectNew                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import {-# SOURCE #-} qualified GI.Atk.Enums as Atk.Enums
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Action as Atk.Action
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Component as Atk.Component
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Document as Atk.Document
import {-# SOURCE #-} qualified GI.Atk.Interfaces.EditableText as Atk.EditableText
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Hypertext as Atk.Hypertext
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Image as Atk.Image
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Selection as Atk.Selection
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Table as Atk.Table
import {-# SOURCE #-} qualified GI.Atk.Interfaces.TableCell as Atk.TableCell
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Text as Atk.Text
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Value as Atk.Value
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Window as Atk.Window
import {-# SOURCE #-} qualified GI.Atk.Objects.Hyperlink as Atk.Hyperlink
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import {-# SOURCE #-} qualified GI.Atk.Objects.Relation as Atk.Relation
import {-# SOURCE #-} qualified GI.Atk.Objects.RelationSet as Atk.RelationSet
import {-# SOURCE #-} qualified GI.Atk.Objects.StateSet as Atk.StateSet
import {-# SOURCE #-} qualified GI.Atk.Structs.PropertyValues as Atk.PropertyValues
import {-# SOURCE #-} qualified GI.Atk.Structs.Range as Atk.Range
import {-# SOURCE #-} qualified GI.Atk.Structs.Rectangle as Atk.Rectangle
import {-# SOURCE #-} qualified GI.Atk.Structs.TextRange as Atk.TextRange
import {-# SOURCE #-} qualified GI.Atk.Structs.TextRectangle as Atk.TextRectangle
import {-# SOURCE #-} qualified GI.Atk.Structs.TextSelection as Atk.TextSelection
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.ValueArray as GObject.ValueArray

#else
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Action as Atk.Action
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Component as Atk.Component
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Document as Atk.Document
import {-# SOURCE #-} qualified GI.Atk.Interfaces.EditableText as Atk.EditableText
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Hypertext as Atk.Hypertext
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Image as Atk.Image
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Selection as Atk.Selection
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Table as Atk.Table
import {-# SOURCE #-} qualified GI.Atk.Interfaces.TableCell as Atk.TableCell
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Text as Atk.Text
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Value as Atk.Value
import {-# SOURCE #-} qualified GI.Atk.Interfaces.Window as Atk.Window
import {-# SOURCE #-} qualified GI.Atk.Objects.Object as Atk.Object
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- | Memory-managed wrapper type.
newtype NoOpObject = NoOpObject (SP.ManagedPtr NoOpObject)
    deriving (Eq)

instance SP.ManagedPtrNewtype NoOpObject where
    toManagedPtr (NoOpObject p) = p

foreign import ccall "atk_no_op_object_get_type"
    c_atk_no_op_object_get_type :: IO B.Types.GType

instance B.Types.TypedObject NoOpObject where
    glibType = c_atk_no_op_object_get_type

instance B.Types.GObject NoOpObject

-- | Type class for types which can be safely cast to t'NoOpObject', for instance with `toNoOpObject`.
class (SP.GObject o, O.IsDescendantOf NoOpObject o) => IsNoOpObject o
instance (SP.GObject o, O.IsDescendantOf NoOpObject o) => IsNoOpObject o

instance O.HasParentTypes NoOpObject
type instance O.ParentTypes NoOpObject = '[Atk.Object.Object, GObject.Object.Object, Atk.Action.Action, Atk.Component.Component, Atk.Document.Document, Atk.EditableText.EditableText, Atk.Hypertext.Hypertext, Atk.Image.Image, Atk.Selection.Selection, Atk.Table.Table, Atk.TableCell.TableCell, Atk.Text.Text, Atk.Value.Value, Atk.Window.Window]

-- | Cast to t'NoOpObject', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toNoOpObject :: (MIO.MonadIO m, IsNoOpObject o) => o -> m NoOpObject
toNoOpObject = MIO.liftIO . B.ManagedPtr.unsafeCastTo NoOpObject

-- | Convert t'NoOpObject' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe NoOpObject) where
    gvalueGType_ = c_atk_no_op_object_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr NoOpObject)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr NoOpObject)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject NoOpObject ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveNoOpObjectMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveNoOpObjectMethod "addColumnSelection" o = Atk.Table.TableAddColumnSelectionMethodInfo
    ResolveNoOpObjectMethod "addRelationship" o = Atk.Object.ObjectAddRelationshipMethodInfo
    ResolveNoOpObjectMethod "addRowSelection" o = Atk.Table.TableAddRowSelectionMethodInfo
    ResolveNoOpObjectMethod "addSelection" o = Atk.Selection.SelectionAddSelectionMethodInfo
    ResolveNoOpObjectMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveNoOpObjectMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveNoOpObjectMethod "clearSelection" o = Atk.Selection.SelectionClearSelectionMethodInfo
    ResolveNoOpObjectMethod "contains" o = Atk.Component.ComponentContainsMethodInfo
    ResolveNoOpObjectMethod "copyText" o = Atk.EditableText.EditableTextCopyTextMethodInfo
    ResolveNoOpObjectMethod "cutText" o = Atk.EditableText.EditableTextCutTextMethodInfo
    ResolveNoOpObjectMethod "deleteText" o = Atk.EditableText.EditableTextDeleteTextMethodInfo
    ResolveNoOpObjectMethod "doAction" o = Atk.Action.ActionDoActionMethodInfo
    ResolveNoOpObjectMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveNoOpObjectMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveNoOpObjectMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveNoOpObjectMethod "grabFocus" o = Atk.Component.ComponentGrabFocusMethodInfo
    ResolveNoOpObjectMethod "initialize" o = Atk.Object.ObjectInitializeMethodInfo
    ResolveNoOpObjectMethod "insertText" o = Atk.EditableText.EditableTextInsertTextMethodInfo
    ResolveNoOpObjectMethod "isChildSelected" o = Atk.Selection.SelectionIsChildSelectedMethodInfo
    ResolveNoOpObjectMethod "isColumnSelected" o = Atk.Table.TableIsColumnSelectedMethodInfo
    ResolveNoOpObjectMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveNoOpObjectMethod "isRowSelected" o = Atk.Table.TableIsRowSelectedMethodInfo
    ResolveNoOpObjectMethod "isSelected" o = Atk.Table.TableIsSelectedMethodInfo
    ResolveNoOpObjectMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveNoOpObjectMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveNoOpObjectMethod "notifyStateChange" o = Atk.Object.ObjectNotifyStateChangeMethodInfo
    ResolveNoOpObjectMethod "pasteText" o = Atk.EditableText.EditableTextPasteTextMethodInfo
    ResolveNoOpObjectMethod "peekParent" o = Atk.Object.ObjectPeekParentMethodInfo
    ResolveNoOpObjectMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveNoOpObjectMethod "refAccessibleAtPoint" o = Atk.Component.ComponentRefAccessibleAtPointMethodInfo
    ResolveNoOpObjectMethod "refAccessibleChild" o = Atk.Object.ObjectRefAccessibleChildMethodInfo
    ResolveNoOpObjectMethod "refAt" o = Atk.Table.TableRefAtMethodInfo
    ResolveNoOpObjectMethod "refRelationSet" o = Atk.Object.ObjectRefRelationSetMethodInfo
    ResolveNoOpObjectMethod "refSelection" o = Atk.Selection.SelectionRefSelectionMethodInfo
    ResolveNoOpObjectMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveNoOpObjectMethod "refStateSet" o = Atk.Object.ObjectRefStateSetMethodInfo
    ResolveNoOpObjectMethod "removeColumnSelection" o = Atk.Table.TableRemoveColumnSelectionMethodInfo
    ResolveNoOpObjectMethod "removeFocusHandler" o = Atk.Component.ComponentRemoveFocusHandlerMethodInfo
    ResolveNoOpObjectMethod "removePropertyChangeHandler" o = Atk.Object.ObjectRemovePropertyChangeHandlerMethodInfo
    ResolveNoOpObjectMethod "removeRelationship" o = Atk.Object.ObjectRemoveRelationshipMethodInfo
    ResolveNoOpObjectMethod "removeRowSelection" o = Atk.Table.TableRemoveRowSelectionMethodInfo
    ResolveNoOpObjectMethod "removeSelection" o = Atk.Selection.SelectionRemoveSelectionMethodInfo
    ResolveNoOpObjectMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveNoOpObjectMethod "scrollSubstringTo" o = Atk.Text.TextScrollSubstringToMethodInfo
    ResolveNoOpObjectMethod "scrollSubstringToPoint" o = Atk.Text.TextScrollSubstringToPointMethodInfo
    ResolveNoOpObjectMethod "scrollTo" o = Atk.Component.ComponentScrollToMethodInfo
    ResolveNoOpObjectMethod "scrollToPoint" o = Atk.Component.ComponentScrollToPointMethodInfo
    ResolveNoOpObjectMethod "selectAllSelection" o = Atk.Selection.SelectionSelectAllSelectionMethodInfo
    ResolveNoOpObjectMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveNoOpObjectMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveNoOpObjectMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveNoOpObjectMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveNoOpObjectMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveNoOpObjectMethod "getAccessibleId" o = Atk.Object.ObjectGetAccessibleIdMethodInfo
    ResolveNoOpObjectMethod "getAlpha" o = Atk.Component.ComponentGetAlphaMethodInfo
    ResolveNoOpObjectMethod "getAttributeValue" o = Atk.Document.DocumentGetAttributeValueMethodInfo
    ResolveNoOpObjectMethod "getAttributes" o = Atk.Object.ObjectGetAttributesMethodInfo
    ResolveNoOpObjectMethod "getBoundedRanges" o = Atk.Text.TextGetBoundedRangesMethodInfo
    ResolveNoOpObjectMethod "getCaption" o = Atk.Table.TableGetCaptionMethodInfo
    ResolveNoOpObjectMethod "getCaretOffset" o = Atk.Text.TextGetCaretOffsetMethodInfo
    ResolveNoOpObjectMethod "getCharacterAtOffset" o = Atk.Text.TextGetCharacterAtOffsetMethodInfo
    ResolveNoOpObjectMethod "getCharacterCount" o = Atk.Text.TextGetCharacterCountMethodInfo
    ResolveNoOpObjectMethod "getCharacterExtents" o = Atk.Text.TextGetCharacterExtentsMethodInfo
    ResolveNoOpObjectMethod "getColumnAtIndex" o = Atk.Table.TableGetColumnAtIndexMethodInfo
    ResolveNoOpObjectMethod "getColumnDescription" o = Atk.Table.TableGetColumnDescriptionMethodInfo
    ResolveNoOpObjectMethod "getColumnExtentAt" o = Atk.Table.TableGetColumnExtentAtMethodInfo
    ResolveNoOpObjectMethod "getColumnHeader" o = Atk.Table.TableGetColumnHeaderMethodInfo
    ResolveNoOpObjectMethod "getColumnHeaderCells" o = Atk.TableCell.TableCellGetColumnHeaderCellsMethodInfo
    ResolveNoOpObjectMethod "getColumnSpan" o = Atk.TableCell.TableCellGetColumnSpanMethodInfo
    ResolveNoOpObjectMethod "getCurrentPageNumber" o = Atk.Document.DocumentGetCurrentPageNumberMethodInfo
    ResolveNoOpObjectMethod "getCurrentValue" o = Atk.Value.ValueGetCurrentValueMethodInfo
    ResolveNoOpObjectMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveNoOpObjectMethod "getDefaultAttributes" o = Atk.Text.TextGetDefaultAttributesMethodInfo
    ResolveNoOpObjectMethod "getDescription" o = Atk.Object.ObjectGetDescriptionMethodInfo
    ResolveNoOpObjectMethod "getDocument" o = Atk.Document.DocumentGetDocumentMethodInfo
    ResolveNoOpObjectMethod "getDocumentType" o = Atk.Document.DocumentGetDocumentTypeMethodInfo
    ResolveNoOpObjectMethod "getExtents" o = Atk.Component.ComponentGetExtentsMethodInfo
    ResolveNoOpObjectMethod "getHelpText" o = Atk.Object.ObjectGetHelpTextMethodInfo
    ResolveNoOpObjectMethod "getImageDescription" o = Atk.Image.ImageGetImageDescriptionMethodInfo
    ResolveNoOpObjectMethod "getImageLocale" o = Atk.Image.ImageGetImageLocaleMethodInfo
    ResolveNoOpObjectMethod "getImagePosition" o = Atk.Image.ImageGetImagePositionMethodInfo
    ResolveNoOpObjectMethod "getImageSize" o = Atk.Image.ImageGetImageSizeMethodInfo
    ResolveNoOpObjectMethod "getIncrement" o = Atk.Value.ValueGetIncrementMethodInfo
    ResolveNoOpObjectMethod "getIndexAt" o = Atk.Table.TableGetIndexAtMethodInfo
    ResolveNoOpObjectMethod "getIndexInParent" o = Atk.Object.ObjectGetIndexInParentMethodInfo
    ResolveNoOpObjectMethod "getKeybinding" o = Atk.Action.ActionGetKeybindingMethodInfo
    ResolveNoOpObjectMethod "getLayer" o = Atk.Object.ObjectGetLayerMethodInfo
    ResolveNoOpObjectMethod "getLink" o = Atk.Hypertext.HypertextGetLinkMethodInfo
    ResolveNoOpObjectMethod "getLinkIndex" o = Atk.Hypertext.HypertextGetLinkIndexMethodInfo
    ResolveNoOpObjectMethod "getLocale" o = Atk.Document.DocumentGetLocaleMethodInfo
    ResolveNoOpObjectMethod "getLocalizedName" o = Atk.Action.ActionGetLocalizedNameMethodInfo
    ResolveNoOpObjectMethod "getMaximumValue" o = Atk.Value.ValueGetMaximumValueMethodInfo
    ResolveNoOpObjectMethod "getMdiZorder" o = Atk.Object.ObjectGetMdiZorderMethodInfo
    ResolveNoOpObjectMethod "getMinimumIncrement" o = Atk.Value.ValueGetMinimumIncrementMethodInfo
    ResolveNoOpObjectMethod "getMinimumValue" o = Atk.Value.ValueGetMinimumValueMethodInfo
    ResolveNoOpObjectMethod "getNAccessibleChildren" o = Atk.Object.ObjectGetNAccessibleChildrenMethodInfo
    ResolveNoOpObjectMethod "getNActions" o = Atk.Action.ActionGetNActionsMethodInfo
    ResolveNoOpObjectMethod "getNColumns" o = Atk.Table.TableGetNColumnsMethodInfo
    ResolveNoOpObjectMethod "getNLinks" o = Atk.Hypertext.HypertextGetNLinksMethodInfo
    ResolveNoOpObjectMethod "getNRows" o = Atk.Table.TableGetNRowsMethodInfo
    ResolveNoOpObjectMethod "getNSelections" o = Atk.Text.TextGetNSelectionsMethodInfo
    ResolveNoOpObjectMethod "getName" o = Atk.Object.ObjectGetNameMethodInfo
    ResolveNoOpObjectMethod "getObjectLocale" o = Atk.Object.ObjectGetObjectLocaleMethodInfo
    ResolveNoOpObjectMethod "getOffsetAtPoint" o = Atk.Text.TextGetOffsetAtPointMethodInfo
    ResolveNoOpObjectMethod "getPageCount" o = Atk.Document.DocumentGetPageCountMethodInfo
    ResolveNoOpObjectMethod "getParent" o = Atk.Object.ObjectGetParentMethodInfo
    ResolveNoOpObjectMethod "getPosition" o = Atk.Component.ComponentGetPositionMethodInfo
    ResolveNoOpObjectMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveNoOpObjectMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveNoOpObjectMethod "getRange" o = Atk.Value.ValueGetRangeMethodInfo
    ResolveNoOpObjectMethod "getRangeExtents" o = Atk.Text.TextGetRangeExtentsMethodInfo
    ResolveNoOpObjectMethod "getRole" o = Atk.Object.ObjectGetRoleMethodInfo
    ResolveNoOpObjectMethod "getRowAtIndex" o = Atk.Table.TableGetRowAtIndexMethodInfo
    ResolveNoOpObjectMethod "getRowColumnSpan" o = Atk.TableCell.TableCellGetRowColumnSpanMethodInfo
    ResolveNoOpObjectMethod "getRowDescription" o = Atk.Table.TableGetRowDescriptionMethodInfo
    ResolveNoOpObjectMethod "getRowExtentAt" o = Atk.Table.TableGetRowExtentAtMethodInfo
    ResolveNoOpObjectMethod "getRowHeader" o = Atk.Table.TableGetRowHeaderMethodInfo
    ResolveNoOpObjectMethod "getRowHeaderCells" o = Atk.TableCell.TableCellGetRowHeaderCellsMethodInfo
    ResolveNoOpObjectMethod "getRowSpan" o = Atk.TableCell.TableCellGetRowSpanMethodInfo
    ResolveNoOpObjectMethod "getRunAttributes" o = Atk.Text.TextGetRunAttributesMethodInfo
    ResolveNoOpObjectMethod "getSelectedColumns" o = Atk.Table.TableGetSelectedColumnsMethodInfo
    ResolveNoOpObjectMethod "getSelectedRows" o = Atk.Table.TableGetSelectedRowsMethodInfo
    ResolveNoOpObjectMethod "getSelection" o = Atk.Text.TextGetSelectionMethodInfo
    ResolveNoOpObjectMethod "getSelectionCount" o = Atk.Selection.SelectionGetSelectionCountMethodInfo
    ResolveNoOpObjectMethod "getSize" o = Atk.Component.ComponentGetSizeMethodInfo
    ResolveNoOpObjectMethod "getStringAtOffset" o = Atk.Text.TextGetStringAtOffsetMethodInfo
    ResolveNoOpObjectMethod "getSubRanges" o = Atk.Value.ValueGetSubRangesMethodInfo
    ResolveNoOpObjectMethod "getSummary" o = Atk.Table.TableGetSummaryMethodInfo
    ResolveNoOpObjectMethod "getTable" o = Atk.TableCell.TableCellGetTableMethodInfo
    ResolveNoOpObjectMethod "getText" o = Atk.Text.TextGetTextMethodInfo
    ResolveNoOpObjectMethod "getTextAfterOffset" o = Atk.Text.TextGetTextAfterOffsetMethodInfo
    ResolveNoOpObjectMethod "getTextAtOffset" o = Atk.Text.TextGetTextAtOffsetMethodInfo
    ResolveNoOpObjectMethod "getTextBeforeOffset" o = Atk.Text.TextGetTextBeforeOffsetMethodInfo
    ResolveNoOpObjectMethod "getTextSelections" o = Atk.Document.DocumentGetTextSelectionsMethodInfo
    ResolveNoOpObjectMethod "getValueAndText" o = Atk.Value.ValueGetValueAndTextMethodInfo
    ResolveNoOpObjectMethod "setAccessibleId" o = Atk.Object.ObjectSetAccessibleIdMethodInfo
    ResolveNoOpObjectMethod "setAttributeValue" o = Atk.Document.DocumentSetAttributeValueMethodInfo
    ResolveNoOpObjectMethod "setCaption" o = Atk.Table.TableSetCaptionMethodInfo
    ResolveNoOpObjectMethod "setCaretOffset" o = Atk.Text.TextSetCaretOffsetMethodInfo
    ResolveNoOpObjectMethod "setColumnDescription" o = Atk.Table.TableSetColumnDescriptionMethodInfo
    ResolveNoOpObjectMethod "setColumnHeader" o = Atk.Table.TableSetColumnHeaderMethodInfo
    ResolveNoOpObjectMethod "setCurrentValue" o = Atk.Value.ValueSetCurrentValueMethodInfo
    ResolveNoOpObjectMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveNoOpObjectMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveNoOpObjectMethod "setDescription" o = Atk.Object.ObjectSetDescriptionMethodInfo
    ResolveNoOpObjectMethod "setExtents" o = Atk.Component.ComponentSetExtentsMethodInfo
    ResolveNoOpObjectMethod "setHelpText" o = Atk.Object.ObjectSetHelpTextMethodInfo
    ResolveNoOpObjectMethod "setImageDescription" o = Atk.Image.ImageSetImageDescriptionMethodInfo
    ResolveNoOpObjectMethod "setName" o = Atk.Object.ObjectSetNameMethodInfo
    ResolveNoOpObjectMethod "setParent" o = Atk.Object.ObjectSetParentMethodInfo
    ResolveNoOpObjectMethod "setPosition" o = Atk.Component.ComponentSetPositionMethodInfo
    ResolveNoOpObjectMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveNoOpObjectMethod "setRole" o = Atk.Object.ObjectSetRoleMethodInfo
    ResolveNoOpObjectMethod "setRowDescription" o = Atk.Table.TableSetRowDescriptionMethodInfo
    ResolveNoOpObjectMethod "setRowHeader" o = Atk.Table.TableSetRowHeaderMethodInfo
    ResolveNoOpObjectMethod "setRunAttributes" o = Atk.EditableText.EditableTextSetRunAttributesMethodInfo
    ResolveNoOpObjectMethod "setSelection" o = Atk.Text.TextSetSelectionMethodInfo
    ResolveNoOpObjectMethod "setSize" o = Atk.Component.ComponentSetSizeMethodInfo
    ResolveNoOpObjectMethod "setSummary" o = Atk.Table.TableSetSummaryMethodInfo
    ResolveNoOpObjectMethod "setTextContents" o = Atk.EditableText.EditableTextSetTextContentsMethodInfo
    ResolveNoOpObjectMethod "setTextSelections" o = Atk.Document.DocumentSetTextSelectionsMethodInfo
    ResolveNoOpObjectMethod "setValue" o = Atk.Value.ValueSetValueMethodInfo
    ResolveNoOpObjectMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveNoOpObjectMethod t NoOpObject, O.OverloadedMethod info NoOpObject p) => OL.IsLabel t (NoOpObject -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveNoOpObjectMethod t NoOpObject, O.OverloadedMethod info NoOpObject p, R.HasField t NoOpObject p) => R.HasField t NoOpObject p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveNoOpObjectMethod t NoOpObject, O.OverloadedMethodInfo info NoOpObject) => OL.IsLabel t (O.MethodProxy info NoOpObject) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList NoOpObject
type instance O.AttributeList NoOpObject = NoOpObjectAttributeList
type NoOpObjectAttributeList = ('[ '("accessibleComponentLayer", Atk.Object.ObjectAccessibleComponentLayerPropertyInfo), '("accessibleComponentMdiZorder", Atk.Object.ObjectAccessibleComponentMdiZorderPropertyInfo), '("accessibleDescription", Atk.Object.ObjectAccessibleDescriptionPropertyInfo), '("accessibleHelpText", Atk.Object.ObjectAccessibleHelpTextPropertyInfo), '("accessibleHypertextNlinks", Atk.Object.ObjectAccessibleHypertextNlinksPropertyInfo), '("accessibleId", Atk.Object.ObjectAccessibleIdPropertyInfo), '("accessibleName", Atk.Object.ObjectAccessibleNamePropertyInfo), '("accessibleParent", Atk.Object.ObjectAccessibleParentPropertyInfo), '("accessibleRole", Atk.Object.ObjectAccessibleRolePropertyInfo), '("accessibleTableCaption", Atk.Object.ObjectAccessibleTableCaptionPropertyInfo), '("accessibleTableCaptionObject", Atk.Object.ObjectAccessibleTableCaptionObjectPropertyInfo), '("accessibleTableColumnDescription", Atk.Object.ObjectAccessibleTableColumnDescriptionPropertyInfo), '("accessibleTableColumnHeader", Atk.Object.ObjectAccessibleTableColumnHeaderPropertyInfo), '("accessibleTableRowDescription", Atk.Object.ObjectAccessibleTableRowDescriptionPropertyInfo), '("accessibleTableRowHeader", Atk.Object.ObjectAccessibleTableRowHeaderPropertyInfo), '("accessibleTableSummary", Atk.Object.ObjectAccessibleTableSummaryPropertyInfo), '("accessibleValue", Atk.Object.ObjectAccessibleValuePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList NoOpObject = NoOpObjectSignalList
type NoOpObjectSignalList = ('[ '("activate", Atk.Window.WindowActivateSignalInfo), '("activeDescendantChanged", Atk.Object.ObjectActiveDescendantChangedSignalInfo), '("announcement", Atk.Object.ObjectAnnouncementSignalInfo), '("attributeChanged", Atk.Object.ObjectAttributeChangedSignalInfo), '("boundsChanged", Atk.Component.ComponentBoundsChangedSignalInfo), '("childrenChanged", Atk.Object.ObjectChildrenChangedSignalInfo), '("columnDeleted", Atk.Table.TableColumnDeletedSignalInfo), '("columnInserted", Atk.Table.TableColumnInsertedSignalInfo), '("columnReordered", Atk.Table.TableColumnReorderedSignalInfo), '("create", Atk.Window.WindowCreateSignalInfo), '("deactivate", Atk.Window.WindowDeactivateSignalInfo), '("destroy", Atk.Window.WindowDestroySignalInfo), '("documentAttributeChanged", Atk.Document.DocumentDocumentAttributeChangedSignalInfo), '("focusEvent", Atk.Object.ObjectFocusEventSignalInfo), '("linkSelected", Atk.Hypertext.HypertextLinkSelectedSignalInfo), '("loadComplete", Atk.Document.DocumentLoadCompleteSignalInfo), '("loadStopped", Atk.Document.DocumentLoadStoppedSignalInfo), '("maximize", Atk.Window.WindowMaximizeSignalInfo), '("minimize", Atk.Window.WindowMinimizeSignalInfo), '("modelChanged", Atk.Table.TableModelChangedSignalInfo), '("move", Atk.Window.WindowMoveSignalInfo), '("notification", Atk.Object.ObjectNotificationSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("pageChanged", Atk.Document.DocumentPageChangedSignalInfo), '("propertyChange", Atk.Object.ObjectPropertyChangeSignalInfo), '("reload", Atk.Document.DocumentReloadSignalInfo), '("resize", Atk.Window.WindowResizeSignalInfo), '("restore", Atk.Window.WindowRestoreSignalInfo), '("rowDeleted", Atk.Table.TableRowDeletedSignalInfo), '("rowInserted", Atk.Table.TableRowInsertedSignalInfo), '("rowReordered", Atk.Table.TableRowReorderedSignalInfo), '("selectionChanged", Atk.Selection.SelectionSelectionChangedSignalInfo), '("stateChange", Atk.Object.ObjectStateChangeSignalInfo), '("textAttributesChanged", Atk.Text.TextTextAttributesChangedSignalInfo), '("textCaretMoved", Atk.Text.TextTextCaretMovedSignalInfo), '("textChanged", Atk.Text.TextTextChangedSignalInfo), '("textInsert", Atk.Text.TextTextInsertSignalInfo), '("textRemove", Atk.Text.TextTextRemoveSignalInfo), '("textSelectionChanged", Atk.Text.TextTextSelectionChangedSignalInfo), '("valueChanged", Atk.Value.ValueValueChangedSignalInfo), '("visibleDataChanged", Atk.Object.ObjectVisibleDataChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method NoOpObject::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "obj"
--           , argType =
--               TInterface Name { namespace = "GObject" , name = "Object" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GObject" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Atk" , name = "NoOpObject" })
-- throws : False
-- Skip return : False

foreign import ccall "atk_no_op_object_new" atk_no_op_object_new :: 
    Ptr GObject.Object.Object ->            -- obj : TInterface (Name {namespace = "GObject", name = "Object"})
    IO (Ptr NoOpObject)

-- | Provides a default (non-functioning stub) t'GI.Atk.Objects.Object.Object'.
-- Application maintainers should not use this method.
noOpObjectNew ::
    (B.CallStack.HasCallStack, MonadIO m, GObject.Object.IsObject a) =>
    a
    -- ^ /@obj@/: a t'GI.GObject.Objects.Object.Object'
    -> m NoOpObject
    -- ^ __Returns:__ a default (non-functioning stub) t'GI.Atk.Objects.Object.Object'
noOpObjectNew obj = liftIO $ do
    obj' <- unsafeManagedPtrCastPtr obj
    result <- atk_no_op_object_new obj'
    checkUnexpectedReturnNULL "noOpObjectNew" result
    result' <- (wrapObject NoOpObject) result
    touchManagedPtr obj
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


