/*  gtk2fontsel
 *  Copyright (C) 2002 Jason Petrone <jp@demonseed.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>
#include <string.h> /* for strlen */
#include <stdio.h>

GtkWidget *fontsel, *win, *w, *selection;

char *seltext = "";
  
void getsel(GtkWidget *w, GtkSelectionData *selection_data, guint info,
      guint time_stamp, gpointer data){
  gtk_selection_data_set_text(selection_data, seltext, strlen(seltext));
}

void btn(GtkDialog *win, gint resp, gpointer data){
  if (resp == GTK_RESPONSE_ACCEPT){
    gtk_selection_owner_set(selection, GDK_SELECTION_PRIMARY, GDK_CURRENT_TIME);
    seltext = gtk_font_selection_get_font_name(GTK_FONT_SELECTION(fontsel));
  }
  else if (resp == GTK_RESPONSE_DELETE_EVENT){
    gtk_main_quit();
  }
}
    
int main(int argc, char **argv){
  gtk_init(&argc, &argv);

  win = gtk_dialog_new_with_buttons("Select Font", NULL, 0, 
                                    GTK_STOCK_COPY, GTK_RESPONSE_ACCEPT,
                                    GTK_STOCK_QUIT, GTK_RESPONSE_DELETE_EVENT,
                                    NULL);
  g_signal_connect(G_OBJECT(win), "destroy", gtk_main_quit, NULL);
  g_signal_connect_swapped(GTK_OBJECT(win),"response",G_CALLBACK(btn),NULL);
  gtk_window_set_default_size(GTK_WINDOW(win), 700, 640);
  
  fontsel = gtk_font_selection_new();
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), fontsel, TRUE, TRUE, 0);

  gtk_container_set_border_width(GTK_CONTAINER(win), 10);

  selection = gtk_invisible_new();
  g_signal_connect(G_OBJECT(selection), "selection_get", G_CALLBACK(getsel),
                    NULL);
  gtk_selection_add_target(selection, GDK_SELECTION_PRIMARY,
                           GDK_SELECTION_TYPE_STRING, 1);
  
  gtk_widget_show_all(win);
  gtk_main();  
  return 0;
}
