/* ValidatedEntry.c generated by valac 0.56.17, the Vala compiler
 * generated from ValidatedEntry.vala, do not modify */

/*
 * Copyright 2020 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "granite-7.h"
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_VALIDATED_ENTRY_0_PROPERTY,
	GRANITE_VALIDATED_ENTRY_IS_VALID_PROPERTY,
	GRANITE_VALIDATED_ENTRY_MIN_LENGTH_PROPERTY,
	GRANITE_VALIDATED_ENTRY_REGEX_PROPERTY,
	GRANITE_VALIDATED_ENTRY_NUM_PROPERTIES
};
static GParamSpec* granite_validated_entry_properties[GRANITE_VALIDATED_ENTRY_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _GraniteValidatedEntryPrivate {
	gboolean _is_valid;
	gint _min_length;
	GRegex* _regex;
};

static gint GraniteValidatedEntry_private_offset;
static gpointer granite_validated_entry_parent_class = NULL;

static void granite_validated_entry_check_validity (GraniteValidatedEntry* self);
static GObject * granite_validated_entry_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _granite_validated_entry___lambda42_ (GraniteValidatedEntry* self);
static void __granite_validated_entry___lambda42__gtk_editable_changed (GtkEditable* _sender,
                                                                 gpointer self);
static void _granite_validated_entry___lambda43_ (GraniteValidatedEntry* self);
static void __granite_validated_entry___lambda43__gtk_editable_changed (GtkEditable* _sender,
                                                                 gpointer self);
static void granite_validated_entry_finalize (GObject * obj);
static GType granite_validated_entry_get_type_once (void);
static void _vala_granite_validated_entry_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_granite_validated_entry_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
granite_validated_entry_get_instance_private (GraniteValidatedEntry* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteValidatedEntry_private_offset);
}

gboolean
granite_validated_entry_get_is_valid (GraniteValidatedEntry* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_valid;
	return result;
}

void
granite_validated_entry_set_is_valid (GraniteValidatedEntry* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_validated_entry_get_is_valid (self);
	if (old_value != value) {
		self->priv->_is_valid = value;
		g_object_notify_by_pspec ((GObject *) self, granite_validated_entry_properties[GRANITE_VALIDATED_ENTRY_IS_VALID_PROPERTY]);
	}
}

gint
granite_validated_entry_get_min_length (GraniteValidatedEntry* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_min_length;
	return result;
}

void
granite_validated_entry_set_min_length (GraniteValidatedEntry* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_validated_entry_get_min_length (self);
	if (old_value != value) {
		self->priv->_min_length = value;
		g_object_notify_by_pspec ((GObject *) self, granite_validated_entry_properties[GRANITE_VALIDATED_ENTRY_MIN_LENGTH_PROPERTY]);
	}
}

GRegex*
granite_validated_entry_get_regex (GraniteValidatedEntry* self)
{
	GRegex* result;
	GRegex* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_regex;
	result = _tmp0_;
	return result;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

void
granite_validated_entry_set_regex (GraniteValidatedEntry* self,
                                   GRegex* value)
{
	GRegex* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_validated_entry_get_regex (self);
	if (old_value != value) {
		GRegex* _tmp0_;
		_tmp0_ = _g_regex_ref0 (value);
		_g_regex_unref0 (self->priv->_regex);
		self->priv->_regex = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_validated_entry_properties[GRANITE_VALIDATED_ENTRY_REGEX_PROPERTY]);
	}
}

GraniteValidatedEntry*
granite_validated_entry_construct_from_regex (GType object_type,
                                              GRegex* regex_arg)
{
	GraniteValidatedEntry * self = NULL;
	g_return_val_if_fail (regex_arg != NULL, NULL);
	self = (GraniteValidatedEntry*) g_object_new (object_type, "regex", regex_arg, NULL);
	return self;
}

GraniteValidatedEntry*
granite_validated_entry_new_from_regex (GRegex* regex_arg)
{
	return granite_validated_entry_construct_from_regex (GRANITE_TYPE_VALIDATED_ENTRY, regex_arg);
}

static void
granite_validated_entry_check_validity (GraniteValidatedEntry* self)
{
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_min_length;
	granite_validated_entry_set_is_valid (self, ((gint) gtk_entry_get_text_length ((GtkEntry*) self)) >= _tmp0_);
	_tmp2_ = self->priv->_is_valid;
	if (_tmp2_) {
		GRegex* _tmp3_;
		_tmp3_ = self->priv->_regex;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GRegex* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->_regex;
		_tmp5_ = gtk_editable_get_text ((GtkEditable*) self);
		_tmp6_ = _tmp5_;
		granite_validated_entry_set_is_valid (self, g_regex_match (_tmp4_, _tmp6_, 0, NULL));
	}
}

GraniteValidatedEntry*
granite_validated_entry_construct (GType object_type)
{
	GraniteValidatedEntry * self = NULL;
	self = (GraniteValidatedEntry*) g_object_new (object_type, NULL);
	return self;
}

GraniteValidatedEntry*
granite_validated_entry_new (void)
{
	return granite_validated_entry_construct (GRANITE_TYPE_VALIDATED_ENTRY);
}

static void
_granite_validated_entry___lambda42_ (GraniteValidatedEntry* self)
{
	granite_validated_entry_check_validity (self);
}

static void
__granite_validated_entry___lambda42__gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self)
{
	_granite_validated_entry___lambda42_ ((GraniteValidatedEntry*) self);
}

static void
_granite_validated_entry___lambda43_ (GraniteValidatedEntry* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	_tmp0_ = gtk_editable_get_text ((GtkEditable*) self);
	_tmp1_ = _tmp0_;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		g_object_set ((GtkEntry*) self, "secondary-icon-name", NULL, NULL);
		gtk_widget_remove_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_ERROR);
	} else {
		gboolean _tmp2_;
		_tmp2_ = self->priv->_is_valid;
		if (_tmp2_) {
			g_object_set ((GtkEntry*) self, "secondary-icon-name", "process-completed-symbolic", NULL);
			gtk_widget_remove_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_ERROR);
		} else {
			g_object_set ((GtkEntry*) self, "secondary-icon-name", "process-error-symbolic", NULL);
			gtk_widget_add_css_class ((GtkWidget*) self, GRANITE_STYLE_CLASS_ERROR);
		}
	}
	_tmp3_ = self->priv->_is_valid;
	gtk_accessible_update_state ((GtkAccessible*) self, GTK_ACCESSIBLE_STATE_INVALID, !_tmp3_, -1, -1);
}

static void
__granite_validated_entry___lambda43__gtk_editable_changed (GtkEditable* _sender,
                                                            gpointer self)
{
	_granite_validated_entry___lambda43_ ((GraniteValidatedEntry*) self);
}

static GObject *
granite_validated_entry_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteValidatedEntry * self;
	parent_class = G_OBJECT_CLASS (granite_validated_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_VALIDATED_ENTRY, GraniteValidatedEntry);
	gtk_entry_set_activates_default ((GtkEntry*) self, TRUE);
	g_signal_connect_object ((GtkEditable*) self, "changed", (GCallback) __granite_validated_entry___lambda42__gtk_editable_changed, self, 0);
	g_signal_connect_object ((GtkEditable*) self, "changed", (GCallback) __granite_validated_entry___lambda43__gtk_editable_changed, self, G_CONNECT_AFTER);
	return obj;
}

static void
granite_validated_entry_class_init (GraniteValidatedEntryClass * klass,
                                    gpointer klass_data)
{
	granite_validated_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteValidatedEntry_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_validated_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_validated_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_validated_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_validated_entry_finalize;
	/**
	     * Whether or not text is considered valid input
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_VALIDATED_ENTRY_IS_VALID_PROPERTY, granite_validated_entry_properties[GRANITE_VALIDATED_ENTRY_IS_VALID_PROPERTY] = g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_VALIDATED_ENTRY_MIN_LENGTH_PROPERTY, granite_validated_entry_properties[GRANITE_VALIDATED_ENTRY_MIN_LENGTH_PROPERTY] = g_param_spec_int ("min-length", "min-length", "min-length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_VALIDATED_ENTRY_REGEX_PROPERTY, granite_validated_entry_properties[GRANITE_VALIDATED_ENTRY_REGEX_PROPERTY] = g_param_spec_boxed ("regex", "regex", "regex", G_TYPE_REGEX, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
granite_validated_entry_instance_init (GraniteValidatedEntry * self,
                                       gpointer klass)
{
	self->priv = granite_validated_entry_get_instance_private (self);
	self->priv->_is_valid = FALSE;
	self->priv->_min_length = 0;
	self->priv->_regex = NULL;
}

static void
granite_validated_entry_finalize (GObject * obj)
{
	GraniteValidatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_VALIDATED_ENTRY, GraniteValidatedEntry);
	_g_regex_unref0 (self->priv->_regex);
	G_OBJECT_CLASS (granite_validated_entry_parent_class)->finalize (obj);
}

/**
 * ValidatedEntry is a {@link Gtk.Entry} subclass that is meant to be used in
 * forms where input must be validated before the form can be submitted. It
 * provides feedback to users about the state of input validation and keeps
 * track of its own validation state. By default, input is considered invalid.
 *
 * ''Example''<<BR>>
 * {{{
 *   var validated_entry = new Granite.ValidatedEntry ();
 *   username_entry.changed.connect (() => {
 *       username_entry.is_valid = username_entry.text == "valid input";
 *   });
 * }}}
 *
 * If the ValidatedEntry.from_regex () constructor is used then the entry automatically
 * sets its validity status. A valid regex must be passed to this constructor.
 *
 * ''Example''<<BR>>
 * {{{
 *   Regex? regex = null;
 *   ValidatedEntry only_lower_case_letters_entry;
 *   try {
 *       regex = new Regex ("^[a-z]*$");
 *       only_lower_case_letters_entry = new ValidatedEntry.from_regex (regex);
 *   } catch (Error e) {
 *       critical (e.message);
 *       // Provide a fallback entry
 *   }
 * }}}

 */
static GType
granite_validated_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteValidatedEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_validated_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteValidatedEntry), 0, (GInstanceInitFunc) granite_validated_entry_instance_init, NULL };
	GType granite_validated_entry_type_id;
	granite_validated_entry_type_id = g_type_register_static (gtk_entry_get_type (), "GraniteValidatedEntry", &g_define_type_info, 0);
	GraniteValidatedEntry_private_offset = g_type_add_instance_private (granite_validated_entry_type_id, sizeof (GraniteValidatedEntryPrivate));
	return granite_validated_entry_type_id;
}

GType
granite_validated_entry_get_type (void)
{
	static volatile gsize granite_validated_entry_type_id__once = 0;
	if (g_once_init_enter (&granite_validated_entry_type_id__once)) {
		GType granite_validated_entry_type_id;
		granite_validated_entry_type_id = granite_validated_entry_get_type_once ();
		g_once_init_leave (&granite_validated_entry_type_id__once, granite_validated_entry_type_id);
	}
	return granite_validated_entry_type_id__once;
}

static void
_vala_granite_validated_entry_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GraniteValidatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_VALIDATED_ENTRY, GraniteValidatedEntry);
	switch (property_id) {
		case GRANITE_VALIDATED_ENTRY_IS_VALID_PROPERTY:
		g_value_set_boolean (value, granite_validated_entry_get_is_valid (self));
		break;
		case GRANITE_VALIDATED_ENTRY_MIN_LENGTH_PROPERTY:
		g_value_set_int (value, granite_validated_entry_get_min_length (self));
		break;
		case GRANITE_VALIDATED_ENTRY_REGEX_PROPERTY:
		g_value_set_boxed (value, granite_validated_entry_get_regex (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_validated_entry_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GraniteValidatedEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_VALIDATED_ENTRY, GraniteValidatedEntry);
	switch (property_id) {
		case GRANITE_VALIDATED_ENTRY_IS_VALID_PROPERTY:
		granite_validated_entry_set_is_valid (self, g_value_get_boolean (value));
		break;
		case GRANITE_VALIDATED_ENTRY_MIN_LENGTH_PROPERTY:
		granite_validated_entry_set_min_length (self, g_value_get_int (value));
		break;
		case GRANITE_VALIDATED_ENTRY_REGEX_PROPERTY:
		granite_validated_entry_set_regex (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

