/* ModeSwitch.c generated by valac 0.56.17, the Vala compiler
 * generated from ModeSwitch.vala, do not modify */

/*
 * Copyright 2018-2021 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "granite-7.h"
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_MODE_SWITCH_0_PROPERTY,
	GRANITE_MODE_SWITCH_ACTIVE_PROPERTY,
	GRANITE_MODE_SWITCH_PRIMARY_ICON_GICON_PROPERTY,
	GRANITE_MODE_SWITCH_PRIMARY_ICON_NAME_PROPERTY,
	GRANITE_MODE_SWITCH_PRIMARY_ICON_TOOLTIP_TEXT_PROPERTY,
	GRANITE_MODE_SWITCH_SECONDARY_ICON_GICON_PROPERTY,
	GRANITE_MODE_SWITCH_SECONDARY_ICON_NAME_PROPERTY,
	GRANITE_MODE_SWITCH_SECONDARY_ICON_TOOLTIP_TEXT_PROPERTY,
	GRANITE_MODE_SWITCH_NUM_PROPERTIES
};
static GParamSpec* granite_mode_switch_properties[GRANITE_MODE_SWITCH_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;

struct _GraniteModeSwitchPrivate {
	gboolean _active;
	GIcon* _primary_icon_gicon;
	gchar* _primary_icon_name;
	gchar* _primary_icon_tooltip_text;
	GIcon* _secondary_icon_gicon;
	gchar* _secondary_icon_name;
	gchar* _secondary_icon_tooltip_text;
};

struct _Block5Data {
	int _ref_count_;
	GraniteModeSwitch* self;
	GtkSwitch* mode_switch;
};

static gint GraniteModeSwitch_private_offset;
static gpointer granite_mode_switch_parent_class = NULL;

static GObject * granite_mode_switch_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void _granite_mode_switch___lambda18_ (Block5Data* _data5_);
static void __granite_mode_switch___lambda18__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _granite_mode_switch___lambda19_ (Block5Data* _data5_);
static void __granite_mode_switch___lambda19__g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void _granite_mode_switch___lambda20_ (GraniteModeSwitch* self);
static void __granite_mode_switch___lambda20__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                   gint n_press,
                                                                   gdouble x,
                                                                   gdouble y,
                                                                   gpointer self);
static void _granite_mode_switch___lambda21_ (GraniteModeSwitch* self);
static void __granite_mode_switch___lambda21__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                   gint n_press,
                                                                   gdouble x,
                                                                   gdouble y,
                                                                   gpointer self);
static void granite_mode_switch_finalize (GObject * obj);
static GType granite_mode_switch_get_type_once (void);
static void _vala_granite_mode_switch_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_granite_mode_switch_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
granite_mode_switch_get_instance_private (GraniteModeSwitch* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteModeSwitch_private_offset);
}

gboolean
granite_mode_switch_get_active (GraniteModeSwitch* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}

void
granite_mode_switch_set_active (GraniteModeSwitch* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_mode_switch_get_active (self);
	if (old_value != value) {
		self->priv->_active = value;
		g_object_notify_by_pspec ((GObject *) self, granite_mode_switch_properties[GRANITE_MODE_SWITCH_ACTIVE_PROPERTY]);
	}
}

GIcon*
granite_mode_switch_get_primary_icon_gicon (GraniteModeSwitch* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_icon_gicon;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
granite_mode_switch_set_primary_icon_gicon (GraniteModeSwitch* self,
                                            GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_mode_switch_get_primary_icon_gicon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_primary_icon_gicon);
		self->priv->_primary_icon_gicon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_mode_switch_properties[GRANITE_MODE_SWITCH_PRIMARY_ICON_GICON_PROPERTY]);
	}
}

const gchar*
granite_mode_switch_get_primary_icon_name (GraniteModeSwitch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_icon_name;
	result = _tmp0_;
	return result;
}

void
granite_mode_switch_set_primary_icon_name (GraniteModeSwitch* self,
                                           const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_mode_switch_get_primary_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_primary_icon_name);
		self->priv->_primary_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_mode_switch_properties[GRANITE_MODE_SWITCH_PRIMARY_ICON_NAME_PROPERTY]);
	}
}

const gchar*
granite_mode_switch_get_primary_icon_tooltip_text (GraniteModeSwitch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_primary_icon_tooltip_text;
	result = _tmp0_;
	return result;
}

void
granite_mode_switch_set_primary_icon_tooltip_text (GraniteModeSwitch* self,
                                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_mode_switch_get_primary_icon_tooltip_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_primary_icon_tooltip_text);
		self->priv->_primary_icon_tooltip_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_mode_switch_properties[GRANITE_MODE_SWITCH_PRIMARY_ICON_TOOLTIP_TEXT_PROPERTY]);
	}
}

GIcon*
granite_mode_switch_get_secondary_icon_gicon (GraniteModeSwitch* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_secondary_icon_gicon;
	result = _tmp0_;
	return result;
}

void
granite_mode_switch_set_secondary_icon_gicon (GraniteModeSwitch* self,
                                              GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_mode_switch_get_secondary_icon_gicon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_secondary_icon_gicon);
		self->priv->_secondary_icon_gicon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_mode_switch_properties[GRANITE_MODE_SWITCH_SECONDARY_ICON_GICON_PROPERTY]);
	}
}

const gchar*
granite_mode_switch_get_secondary_icon_name (GraniteModeSwitch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_secondary_icon_name;
	result = _tmp0_;
	return result;
}

void
granite_mode_switch_set_secondary_icon_name (GraniteModeSwitch* self,
                                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_mode_switch_get_secondary_icon_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_secondary_icon_name);
		self->priv->_secondary_icon_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_mode_switch_properties[GRANITE_MODE_SWITCH_SECONDARY_ICON_NAME_PROPERTY]);
	}
}

const gchar*
granite_mode_switch_get_secondary_icon_tooltip_text (GraniteModeSwitch* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_secondary_icon_tooltip_text;
	result = _tmp0_;
	return result;
}

void
granite_mode_switch_set_secondary_icon_tooltip_text (GraniteModeSwitch* self,
                                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_mode_switch_get_secondary_icon_tooltip_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_secondary_icon_tooltip_text);
		self->priv->_secondary_icon_tooltip_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, granite_mode_switch_properties[GRANITE_MODE_SWITCH_SECONDARY_ICON_TOOLTIP_TEXT_PROPERTY]);
	}
}

/**
     * Constructs a new {@link Granite.ModeSwitch} using {@link GLib.Icon}s.
     *
     * @param primary_icon_gicon The {@link GLib.Icon} to use for the primary icon for the switch.
     * @param secondary_icon_gicon The {@link GLib.Icon} to use for the secondary icon for the switch.
     */
GraniteModeSwitch*
granite_mode_switch_construct (GType object_type,
                               GIcon* primary_icon_gicon,
                               GIcon* secondary_icon_gicon)
{
	GraniteModeSwitch * self = NULL;
	g_return_val_if_fail (primary_icon_gicon != NULL, NULL);
	g_return_val_if_fail (secondary_icon_gicon != NULL, NULL);
	self = (GraniteModeSwitch*) g_object_new (object_type, "primary-icon-gicon", primary_icon_gicon, "secondary-icon-gicon", secondary_icon_gicon, NULL);
	return self;
}

GraniteModeSwitch*
granite_mode_switch_new (GIcon* primary_icon_gicon,
                         GIcon* secondary_icon_gicon)
{
	return granite_mode_switch_construct (GRANITE_TYPE_MODE_SWITCH, primary_icon_gicon, secondary_icon_gicon);
}

/**
     * Constructs a new {@link Granite.ModeSwitch} from icon names.
     *
     * @param primary_icon_name The icon name to use for the primary icon for the switch.
     * @param secondary_icon_name The icon name to use for the secondary icon for the switch.
     */
GraniteModeSwitch*
granite_mode_switch_construct_from_icon_name (GType object_type,
                                              const gchar* primary_icon_name,
                                              const gchar* secondary_icon_name)
{
	GraniteModeSwitch * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	g_return_val_if_fail (primary_icon_name != NULL, NULL);
	g_return_val_if_fail (secondary_icon_name != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new (primary_icon_name);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new (secondary_icon_name);
	_tmp3_ = _tmp2_;
	self = (GraniteModeSwitch*) g_object_new (object_type, "primary-icon-gicon", _tmp1_, "secondary-icon-gicon", _tmp3_, "primary-icon-name", primary_icon_name, "secondary-icon-name", secondary_icon_name, NULL);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	return self;
}

GraniteModeSwitch*
granite_mode_switch_new_from_icon_name (const gchar* primary_icon_name,
                                        const gchar* secondary_icon_name)
{
	return granite_mode_switch_construct_from_icon_name (GRANITE_TYPE_MODE_SWITCH, primary_icon_name, secondary_icon_name);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GraniteModeSwitch* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->mode_switch);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
_granite_mode_switch___lambda18_ (Block5Data* _data5_)
{
	GraniteModeSwitch* self;
	self = _data5_->self;
	if ((gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_DIR_RTL) == GTK_STATE_FLAG_DIR_RTL) {
		GtkSwitch* _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = _data5_->mode_switch;
		_tmp1_ = self->priv->_active;
		gtk_switch_set_active (_tmp0_, !_tmp1_);
	} else {
		GtkSwitch* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = _data5_->mode_switch;
		_tmp3_ = self->priv->_active;
		gtk_switch_set_active (_tmp2_, _tmp3_);
	}
}

static void
__granite_mode_switch___lambda18__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_granite_mode_switch___lambda18_ (self);
}

static void
_granite_mode_switch___lambda19_ (Block5Data* _data5_)
{
	GraniteModeSwitch* self;
	self = _data5_->self;
	if ((gtk_widget_get_state_flags ((GtkWidget*) self) & GTK_STATE_FLAG_DIR_RTL) == GTK_STATE_FLAG_DIR_RTL) {
		GtkSwitch* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp0_ = _data5_->mode_switch;
		_tmp1_ = gtk_switch_get_active (_tmp0_);
		_tmp2_ = _tmp1_;
		granite_mode_switch_set_active (self, !_tmp2_);
	} else {
		GtkSwitch* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = _data5_->mode_switch;
		_tmp4_ = gtk_switch_get_active (_tmp3_);
		_tmp5_ = _tmp4_;
		granite_mode_switch_set_active (self, _tmp5_);
	}
}

static void
__granite_mode_switch___lambda19__g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	_granite_mode_switch___lambda19_ (self);
}

static void
_granite_mode_switch___lambda20_ (GraniteModeSwitch* self)
{
	granite_mode_switch_set_active (self, FALSE);
}

static void
__granite_mode_switch___lambda20__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                              gint n_press,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self)
{
	_granite_mode_switch___lambda20_ ((GraniteModeSwitch*) self);
}

static void
_granite_mode_switch___lambda21_ (GraniteModeSwitch* self)
{
	granite_mode_switch_set_active (self, TRUE);
}

static void
__granite_mode_switch___lambda21__gtk_gesture_click_released (GtkGestureClick* _sender,
                                                              gint n_press,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self)
{
	_granite_mode_switch___lambda21_ ((GraniteModeSwitch*) self);
}

static GObject *
granite_mode_switch_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteModeSwitch * self;
	Block5Data* _data5_;
	GtkGestureClick* primary_click_controller = NULL;
	GtkGestureClick* _tmp0_;
	GtkImage* primary_icon = NULL;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkGestureClick* _tmp3_;
	GtkEventController* _tmp4_;
	GtkImage* _tmp5_;
	GtkSwitch* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkSwitch* _tmp8_;
	GtkGestureClick* secondary_click_controller = NULL;
	GtkGestureClick* _tmp9_;
	GtkImage* secondary_icon = NULL;
	GtkImage* _tmp10_;
	GtkImage* _tmp11_;
	GtkGestureClick* _tmp12_;
	GtkEventController* _tmp13_;
	GtkImage* _tmp14_;
	GtkImage* _tmp15_;
	GtkSwitch* _tmp16_;
	GtkImage* _tmp17_;
	GtkImage* _tmp18_;
	GtkImage* _tmp19_;
	GtkImage* _tmp20_;
	GtkImage* _tmp21_;
	GtkImage* _tmp22_;
	GtkImage* _tmp23_;
	GtkSwitch* _tmp24_;
	GtkGestureClick* _tmp25_;
	GtkGestureClick* _tmp26_;
	parent_class = G_OBJECT_CLASS (granite_mode_switch_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_MODE_SWITCH, GraniteModeSwitch);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	primary_click_controller = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp1_);
	primary_icon = _tmp1_;
	_tmp2_ = primary_icon;
	_tmp3_ = primary_click_controller;
	_tmp4_ = _g_object_ref0 ((GtkEventController*) _tmp3_);
	gtk_widget_add_controller ((GtkWidget*) _tmp2_, _tmp4_);
	_tmp5_ = primary_icon;
	gtk_image_set_pixel_size (_tmp5_, 16);
	_tmp6_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp6_);
	_data5_->mode_switch = _tmp6_;
	_tmp7_ = _data5_->mode_switch;
	gtk_widget_set_valign ((GtkWidget*) _tmp7_, GTK_ALIGN_CENTER);
	_tmp8_ = _data5_->mode_switch;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, GRANITE_STYLE_CLASS_MODE_SWITCH);
	_tmp9_ = (GtkGestureClick*) gtk_gesture_click_new ();
	secondary_click_controller = _tmp9_;
	_tmp10_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp10_);
	secondary_icon = _tmp10_;
	_tmp11_ = secondary_icon;
	_tmp12_ = secondary_click_controller;
	_tmp13_ = _g_object_ref0 ((GtkEventController*) _tmp12_);
	gtk_widget_add_controller ((GtkWidget*) _tmp11_, _tmp13_);
	_tmp14_ = secondary_icon;
	gtk_image_set_pixel_size (_tmp14_, 16);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	_tmp15_ = primary_icon;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp15_);
	_tmp16_ = _data5_->mode_switch;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp16_);
	_tmp17_ = secondary_icon;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp17_);
	_tmp18_ = primary_icon;
	g_object_bind_property_with_closures ((GObject*) self, "primary-icon-gicon", (GObject*) _tmp18_, "gicon", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp19_ = primary_icon;
	g_object_bind_property_with_closures ((GObject*) self, "primary-icon-name", (GObject*) _tmp19_, "icon-name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp20_ = primary_icon;
	g_object_bind_property_with_closures ((GObject*) self, "primary-icon-tooltip-text", (GObject*) _tmp20_, "tooltip-text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp21_ = secondary_icon;
	g_object_bind_property_with_closures ((GObject*) self, "secondary-icon-gicon", (GObject*) _tmp21_, "gicon", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp22_ = secondary_icon;
	g_object_bind_property_with_closures ((GObject*) self, "secondary-icon-name", (GObject*) _tmp22_, "icon_name", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp23_ = secondary_icon;
	g_object_bind_property_with_closures ((GObject*) self, "secondary-icon-tooltip-text", (GObject*) _tmp23_, "tooltip-text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GObject*) self, "notify::active", (GCallback) __granite_mode_switch___lambda18__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp24_ = _data5_->mode_switch;
	g_signal_connect_data ((GObject*) _tmp24_, "notify::active", (GCallback) __granite_mode_switch___lambda19__g_object_notify, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp25_ = primary_click_controller;
	g_signal_connect_object (_tmp25_, "released", (GCallback) __granite_mode_switch___lambda20__gtk_gesture_click_released, self, 0);
	_tmp26_ = secondary_click_controller;
	g_signal_connect_object (_tmp26_, "released", (GCallback) __granite_mode_switch___lambda21__gtk_gesture_click_released, self, 0);
	_g_object_unref0 (secondary_icon);
	_g_object_unref0 (secondary_click_controller);
	_g_object_unref0 (primary_icon);
	_g_object_unref0 (primary_click_controller);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return obj;
}

static void
granite_mode_switch_class_init (GraniteModeSwitchClass * klass,
                                gpointer klass_data)
{
	granite_mode_switch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteModeSwitch_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_mode_switch_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_mode_switch_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_mode_switch_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_mode_switch_finalize;
	/**
	     * Whether the {@link Gtk.Switch} widget is pointing to the secondary icon or not.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MODE_SWITCH_ACTIVE_PROPERTY, granite_mode_switch_properties[GRANITE_MODE_SWITCH_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The {@link GLib.Icon} to use for the primary icon for the switch.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MODE_SWITCH_PRIMARY_ICON_GICON_PROPERTY, granite_mode_switch_properties[GRANITE_MODE_SWITCH_PRIMARY_ICON_GICON_PROPERTY] = g_param_spec_object ("primary-icon-gicon", "primary-icon-gicon", "primary-icon-gicon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The icon name to use for the primary icon for the switch.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MODE_SWITCH_PRIMARY_ICON_NAME_PROPERTY, granite_mode_switch_properties[GRANITE_MODE_SWITCH_PRIMARY_ICON_NAME_PROPERTY] = g_param_spec_string ("primary-icon-name", "primary-icon-name", "primary-icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The contents of the tooltip on the primary icon.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MODE_SWITCH_PRIMARY_ICON_TOOLTIP_TEXT_PROPERTY, granite_mode_switch_properties[GRANITE_MODE_SWITCH_PRIMARY_ICON_TOOLTIP_TEXT_PROPERTY] = g_param_spec_string ("primary-icon-tooltip-text", "primary-icon-tooltip-text", "primary-icon-tooltip-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The {@link GLib.Icon} to use for the secondary icon for the switch.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MODE_SWITCH_SECONDARY_ICON_GICON_PROPERTY, granite_mode_switch_properties[GRANITE_MODE_SWITCH_SECONDARY_ICON_GICON_PROPERTY] = g_param_spec_object ("secondary-icon-gicon", "secondary-icon-gicon", "secondary-icon-gicon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The icon name to use for the secondary icon for the switch.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MODE_SWITCH_SECONDARY_ICON_NAME_PROPERTY, granite_mode_switch_properties[GRANITE_MODE_SWITCH_SECONDARY_ICON_NAME_PROPERTY] = g_param_spec_string ("secondary-icon-name", "secondary-icon-name", "secondary-icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	     * The contents of the tooltip on the secondary icon.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_MODE_SWITCH_SECONDARY_ICON_TOOLTIP_TEXT_PROPERTY, granite_mode_switch_properties[GRANITE_MODE_SWITCH_SECONDARY_ICON_TOOLTIP_TEXT_PROPERTY] = g_param_spec_string ("secondary-icon-tooltip-text", "secondary-icon-tooltip-text", "secondary-icon-tooltip-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
granite_mode_switch_instance_init (GraniteModeSwitch * self,
                                   gpointer klass)
{
	self->priv = granite_mode_switch_get_instance_private (self);
}

static void
granite_mode_switch_finalize (GObject * obj)
{
	GraniteModeSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_MODE_SWITCH, GraniteModeSwitch);
	_g_object_unref0 (self->priv->_primary_icon_gicon);
	_g_free0 (self->priv->_primary_icon_name);
	_g_free0 (self->priv->_primary_icon_tooltip_text);
	_g_object_unref0 (self->priv->_secondary_icon_gicon);
	_g_free0 (self->priv->_secondary_icon_name);
	_g_free0 (self->priv->_secondary_icon_tooltip_text);
	G_OBJECT_CLASS (granite_mode_switch_parent_class)->finalize (obj);
}

/**
 * ModeSwitch is a selection control for choosing between two options that can be described with an icon.
 *
 * ''Example''<<BR>>
 * {{{
 *   var gtk_settings = Gtk.Settings.get_default ();
 *
 *   var mode_switch = new ModeSwitch.from_icon_name ("display-brightness-symbolic", "weather-clear-night-symbolic");
 *   mode_switch.primary_icon_tooltip_text = _("Light background");
 *   mode_switch.secondary_icon_tooltip_text = _("Dark background");
 *   mode_switch.bind_property ("active", gtk_settings, "gtk_application_prefer_dark_theme");
 * }}}
 */
static GType
granite_mode_switch_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteModeSwitchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_mode_switch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteModeSwitch), 0, (GInstanceInitFunc) granite_mode_switch_instance_init, NULL };
	GType granite_mode_switch_type_id;
	granite_mode_switch_type_id = g_type_register_static (gtk_box_get_type (), "GraniteModeSwitch", &g_define_type_info, 0);
	GraniteModeSwitch_private_offset = g_type_add_instance_private (granite_mode_switch_type_id, sizeof (GraniteModeSwitchPrivate));
	return granite_mode_switch_type_id;
}

GType
granite_mode_switch_get_type (void)
{
	static volatile gsize granite_mode_switch_type_id__once = 0;
	if (g_once_init_enter (&granite_mode_switch_type_id__once)) {
		GType granite_mode_switch_type_id;
		granite_mode_switch_type_id = granite_mode_switch_get_type_once ();
		g_once_init_leave (&granite_mode_switch_type_id__once, granite_mode_switch_type_id);
	}
	return granite_mode_switch_type_id__once;
}

static void
_vala_granite_mode_switch_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GraniteModeSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_MODE_SWITCH, GraniteModeSwitch);
	switch (property_id) {
		case GRANITE_MODE_SWITCH_ACTIVE_PROPERTY:
		g_value_set_boolean (value, granite_mode_switch_get_active (self));
		break;
		case GRANITE_MODE_SWITCH_PRIMARY_ICON_GICON_PROPERTY:
		g_value_set_object (value, granite_mode_switch_get_primary_icon_gicon (self));
		break;
		case GRANITE_MODE_SWITCH_PRIMARY_ICON_NAME_PROPERTY:
		g_value_set_string (value, granite_mode_switch_get_primary_icon_name (self));
		break;
		case GRANITE_MODE_SWITCH_PRIMARY_ICON_TOOLTIP_TEXT_PROPERTY:
		g_value_set_string (value, granite_mode_switch_get_primary_icon_tooltip_text (self));
		break;
		case GRANITE_MODE_SWITCH_SECONDARY_ICON_GICON_PROPERTY:
		g_value_set_object (value, granite_mode_switch_get_secondary_icon_gicon (self));
		break;
		case GRANITE_MODE_SWITCH_SECONDARY_ICON_NAME_PROPERTY:
		g_value_set_string (value, granite_mode_switch_get_secondary_icon_name (self));
		break;
		case GRANITE_MODE_SWITCH_SECONDARY_ICON_TOOLTIP_TEXT_PROPERTY:
		g_value_set_string (value, granite_mode_switch_get_secondary_icon_tooltip_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_mode_switch_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GraniteModeSwitch * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_MODE_SWITCH, GraniteModeSwitch);
	switch (property_id) {
		case GRANITE_MODE_SWITCH_ACTIVE_PROPERTY:
		granite_mode_switch_set_active (self, g_value_get_boolean (value));
		break;
		case GRANITE_MODE_SWITCH_PRIMARY_ICON_GICON_PROPERTY:
		granite_mode_switch_set_primary_icon_gicon (self, g_value_get_object (value));
		break;
		case GRANITE_MODE_SWITCH_PRIMARY_ICON_NAME_PROPERTY:
		granite_mode_switch_set_primary_icon_name (self, g_value_get_string (value));
		break;
		case GRANITE_MODE_SWITCH_PRIMARY_ICON_TOOLTIP_TEXT_PROPERTY:
		granite_mode_switch_set_primary_icon_tooltip_text (self, g_value_get_string (value));
		break;
		case GRANITE_MODE_SWITCH_SECONDARY_ICON_GICON_PROPERTY:
		granite_mode_switch_set_secondary_icon_gicon (self, g_value_get_object (value));
		break;
		case GRANITE_MODE_SWITCH_SECONDARY_ICON_NAME_PROPERTY:
		granite_mode_switch_set_secondary_icon_name (self, g_value_get_string (value));
		break;
		case GRANITE_MODE_SWITCH_SECONDARY_ICON_TOOLTIP_TEXT_PROPERTY:
		granite_mode_switch_set_secondary_icon_tooltip_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

