/* Init.c generated by valac 0.56.17, the Vala compiler
 * generated from Init.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include <glib.h>
#include <gtk/gtk.h>
#include "granite-7.h"
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define GRANITE_GETTEXT_PACKAGE "granite-7"
#define GRANITE_LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Block1Data {
	int _ref_count_;
	GtkSettings* gtk_settings;
	GdkDisplay* display;
};

VALA_EXTERN gboolean granite_initialized;
gboolean granite_initialized = FALSE;
VALA_EXTERN GtkCssProvider* granite_base_provider;
GtkCssProvider* granite_base_provider = NULL;
VALA_EXTERN GtkCssProvider* granite_dark_provider;
GtkCssProvider* granite_dark_provider = NULL;
VALA_EXTERN GtkCssProvider* granite_app_provider;
GtkCssProvider* granite_app_provider = NULL;

 G_GNUC_INTERNAL void granite_register_display (GdkDisplay* display);
static void _granite_register_display_gdk_display_manager_display_opened (GdkDisplayManager* _sender,
                                                                   GdkDisplay* display,
                                                                   gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda7_ (Block1Data* _data1_);
 G_GNUC_INTERNAL void granite_set_provider_for_display (GdkDisplay* display,
                                       gboolean prefer_dark_style);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
 G_GNUC_INTERNAL GtkCssProvider* granite_init_provider_from_file (GFile* file);

/**
     * Initializes Granite.
     * If Granite has already been initialized, the function will return.
     * Makes sure translations and types for Granite are set up properly.
     * @since 7.2.0
     */
static void
_granite_register_display_gdk_display_manager_display_opened (GdkDisplayManager* _sender,
                                                              GdkDisplay* display,
                                                              gpointer self)
{
	granite_register_display (display);
}

void
granite_init (void)
{
	GdkDisplayManager* display_manager = NULL;
	GdkDisplayManager* _tmp0_;
	GdkDisplayManager* _tmp1_;
	GdkDisplayManager* _tmp2_;
	GSList* _tmp3_;
	if (granite_initialized) {
		return;
	}
	g_type_ensure (GRANITE_TYPE_SETTINGS);
	_tmp0_ = gdk_display_manager_get ();
	display_manager = _tmp0_;
	_tmp1_ = display_manager;
	g_signal_connect (_tmp1_, "display-opened", (GCallback) _granite_register_display_gdk_display_manager_display_opened, NULL);
	_tmp2_ = display_manager;
	_tmp3_ = gdk_display_manager_list_displays (_tmp2_);
	{
		GSList* display_collection = NULL;
		GSList* display_it = NULL;
		display_collection = _tmp3_;
		for (display_it = display_collection; display_it != NULL; display_it = display_it->next) {
			GdkDisplay* display = NULL;
			display = (GdkDisplay*) display_it->data;
			{
				GdkDisplay* _tmp4_;
				_tmp4_ = display;
				granite_register_display (_tmp4_);
			}
		}
		(display_collection == NULL) ? NULL : (display_collection = (g_slist_free (display_collection), NULL));
	}
	bindtextdomain (GRANITE_GETTEXT_PACKAGE, GRANITE_LOCALEDIR);
	bind_textdomain_codeset (GRANITE_GETTEXT_PACKAGE, "UTF-8");
	granite_initialized = TRUE;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->gtk_settings);
		_g_object_unref0 (_data1_->display);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda7_ (Block1Data* _data1_)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_object_get (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	granite_set_provider_for_display (_data1_->display, _tmp1_);
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ (self);
}

 G_GNUC_INTERNAL void
granite_register_display (GdkDisplay* display)
{
	Block1Data* _data1_;
	GdkDisplay* _tmp0_;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp5_;
	GtkIconTheme* _tmp6_;
	g_return_if_fail (display != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (display);
	_g_object_unref0 (_data1_->display);
	_data1_->display = _tmp0_;
	_tmp1_ = gtk_settings_get_for_display (_data1_->display);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data1_->gtk_settings = _tmp2_;
	g_signal_connect_data ((GObject*) _data1_->gtk_settings, "notify::gtk-application-prefer-dark-theme", (GCallback) ___lambda7__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_object_get (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	granite_set_provider_for_display (_data1_->display, _tmp4_);
	_tmp5_ = gtk_icon_theme_get_for_display (_data1_->display);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	icon_theme = _tmp6_;
	gtk_icon_theme_add_resource_path (icon_theme, "/io/elementary/granite");
	_g_object_unref0 (icon_theme);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

 G_GNUC_INTERNAL void
granite_set_provider_for_display (GdkDisplay* display,
                                  gboolean prefer_dark_style)
{
	GtkCssProvider* _tmp0_;
	g_return_if_fail (display != NULL);
	_tmp0_ = granite_app_provider;
	if (_tmp0_ == NULL) {
		gchar* base_path = NULL;
		GApplication* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		GtkCssProvider* _tmp14_;
		_tmp1_ = g_application_get_default ();
		_tmp2_ = g_application_get_resource_base_path (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		base_path = _tmp4_;
		_tmp5_ = base_path;
		if (_tmp5_ != NULL) {
			gchar* base_uri = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			GFile* base_file = NULL;
			const gchar* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp12_;
			GtkCssProvider* _tmp13_;
			_tmp6_ = base_path;
			_tmp7_ = g_strconcat ("resource://", _tmp6_, NULL);
			base_uri = _tmp7_;
			_tmp8_ = base_uri;
			_tmp9_ = g_file_new_for_uri (_tmp8_);
			base_file = _tmp9_;
			_tmp10_ = base_file;
			_tmp11_ = g_file_get_child (_tmp10_, "Application.css");
			_tmp12_ = _tmp11_;
			_tmp13_ = granite_init_provider_from_file (_tmp12_);
			_g_object_unref0 (granite_app_provider);
			granite_app_provider = _tmp13_;
			_g_object_unref0 (_tmp12_);
			_g_object_unref0 (base_file);
			_g_free0 (base_uri);
		}
		_tmp14_ = granite_app_provider;
		if (_tmp14_ != NULL) {
			GtkCssProvider* _tmp15_;
			_tmp15_ = granite_app_provider;
			gtk_style_context_add_provider_for_display (display, (GtkStyleProvider*) _tmp15_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		}
		_g_free0 (base_path);
	}
	if (prefer_dark_style) {
		GtkCssProvider* _tmp16_;
		GtkCssProvider* _tmp18_;
		GtkCssProvider* _tmp21_;
		_tmp16_ = granite_base_provider;
		if (_tmp16_ != NULL) {
			GtkCssProvider* _tmp17_;
			_tmp17_ = granite_base_provider;
			gtk_style_context_remove_provider_for_display (display, (GtkStyleProvider*) _tmp17_);
		}
		_tmp18_ = granite_dark_provider;
		if (_tmp18_ == NULL) {
			GtkCssProvider* _tmp19_;
			GtkCssProvider* _tmp20_;
			_tmp19_ = gtk_css_provider_new ();
			_g_object_unref0 (granite_dark_provider);
			granite_dark_provider = _tmp19_;
			_tmp20_ = granite_dark_provider;
			gtk_css_provider_load_from_resource (_tmp20_, "/io/elementary/granite/Granite-dark.css");
		}
		_tmp21_ = granite_dark_provider;
		gtk_style_context_add_provider_for_display (display, (GtkStyleProvider*) _tmp21_, (guint) GTK_STYLE_PROVIDER_PRIORITY_THEME);
	} else {
		GtkCssProvider* _tmp22_;
		GtkCssProvider* _tmp24_;
		GtkCssProvider* _tmp27_;
		_tmp22_ = granite_dark_provider;
		if (_tmp22_ != NULL) {
			GtkCssProvider* _tmp23_;
			_tmp23_ = granite_dark_provider;
			gtk_style_context_remove_provider_for_display (display, (GtkStyleProvider*) _tmp23_);
		}
		_tmp24_ = granite_base_provider;
		if (_tmp24_ == NULL) {
			GtkCssProvider* _tmp25_;
			GtkCssProvider* _tmp26_;
			_tmp25_ = gtk_css_provider_new ();
			_g_object_unref0 (granite_base_provider);
			granite_base_provider = _tmp25_;
			_tmp26_ = granite_base_provider;
			gtk_css_provider_load_from_resource (_tmp26_, "/io/elementary/granite/Granite.css");
		}
		_tmp27_ = granite_base_provider;
		gtk_style_context_add_provider_for_display (display, (GtkStyleProvider*) _tmp27_, (guint) GTK_STYLE_PROVIDER_PRIORITY_THEME);
	}
}

 G_GNUC_INTERNAL GtkCssProvider*
granite_init_provider_from_file (GFile* file)
{
	GtkCssProvider* result;
	g_return_val_if_fail (file != NULL, NULL);
	if (g_file_query_exists (file, NULL)) {
		GtkCssProvider* provider = NULL;
		GtkCssProvider* _tmp0_;
		GtkCssProvider* _tmp1_;
		_tmp0_ = gtk_css_provider_new ();
		provider = _tmp0_;
		_tmp1_ = provider;
		gtk_css_provider_load_from_file (_tmp1_, file);
		result = provider;
		return result;
	}
	result = NULL;
	return result;
}

