/* HyperTextView.c generated by valac 0.56.17, the Vala compiler
 * generated from HyperTextView.vala, do not modify */

/*
 *  Copyright 2021 elementary, Inc.
 *
 *  This program or library is free software; you can redistribute it
 *  and/or modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General
 *  Public License along with this library; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301 USA.
 */

#include "granite.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#define GRANITE_HYPER_TEXT_VIEW_FORCE_FULL_BUFFER_RESCAN_CHANGE_START_OFFSET -1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_HYPER_TEXT_VIEW_0_PROPERTY,
	GRANITE_HYPER_TEXT_VIEW_NUM_PROPERTIES
};
static GParamSpec* granite_hyper_text_view_properties[GRANITE_HYPER_TEXT_VIEW_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GraniteHyperTextViewUpdateTagsInBufferForRangeData GraniteHyperTextViewUpdateTagsInBufferForRangeData;

struct _GraniteHyperTextViewPrivate {
	guint buffer_changed_debounce_timeout_id;
	gint buffer_cursor_position_when_change_started;
	GHashTable* uri_text_tags;
	GRecMutex __lock_uri_text_tags;
	GRegex* uri_regex;
	gboolean is_control_key_pressed;
};

struct _GraniteHyperTextViewUpdateTagsInBufferForRangeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GraniteHyperTextView* self;
	gint buffer_start_offset;
	gint buffer_end_offset;
	GtkTextIter buffer_start_iter;
	GtkTextIter buffer_end_iter;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	GtkTextIter _tmp5_;
	GHashTable* _tmp6_;
	GHashTable* _tmp7_;
	GList* _tmp8_;
	GList* tag_key_collection;
	GList* tag_key_it;
	const gchar* tag_key;
	gint tag_start_offset;
	gint tag_end_offset;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* _tmp16_;
	GtkTextTagTable* _tmp17_;
	GtkTextTagTable* _tmp18_;
	GHashTable* _tmp19_;
	const gchar* _tmp20_;
	gpointer _tmp21_;
	GtkTextTag* _tmp22_;
	GHashTable* _tmp23_;
	gint buffer_start_index;
	GtkTextBuffer* _tmp24_;
	GtkTextBuffer* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gint _tmp29_;
	gint buffer_end_index;
	GtkTextBuffer* _tmp30_;
	GtkTextBuffer* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gint _tmp35_;
	gchar* buffer_substring;
	GtkTextBuffer* _tmp36_;
	GtkTextBuffer* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gboolean _tmp46_;
	GMatchInfo* match_info;
	GRegex* _tmp47_;
	const gchar* _tmp48_;
	GMatchInfo* _tmp49_;
	GMatchInfo* _tmp50_;
	gchar* match_text;
	GMatchInfo* _tmp51_;
	gchar* _tmp52_;
	gint match_start_index;
	gint match_end_index;
	GMatchInfo* _tmp53_;
	gint _tmp54_;
	gint _tmp55_;
	gint match_start_offset;
	gint match_end_offset;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	const gchar* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gint buffer_match_start_offset;
	gint buffer_match_end_offset;
	GtkTextIter buffer_match_start_iter;
	GtkTextIter buffer_match_end_iter;
	GtkTextBuffer* _tmp62_;
	GtkTextBuffer* _tmp63_;
	GtkTextIter _tmp64_;
	GtkTextBuffer* _tmp65_;
	GtkTextBuffer* _tmp66_;
	GtkTextIter _tmp67_;
	GtkTextTag* tag;
	GtkTextBuffer* _tmp68_;
	GtkTextBuffer* _tmp69_;
	GtkTextTag* _tmp70_;
	GtkTextTag* _tmp71_;
	gboolean _tmp72_;
	gboolean _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	GtkTextTag* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	GtkTextBuffer* _tmp82_;
	GtkTextBuffer* _tmp83_;
	GtkTextTag* _tmp84_;
	GtkTextIter _tmp85_;
	GtkTextIter _tmp86_;
	GHashTable* _tmp87_;
	GHashTable* _tmp88_;
	gchar* _tmp89_;
	GtkTextTag* _tmp90_;
	GtkTextTag* _tmp91_;
	GHashTable* _tmp92_;
	GMatchInfo* _tmp93_;
	GError* e;
	GError* _tmp94_;
	const gchar* _tmp95_;
	GError* _inner_error0_;
};

static gint GraniteHyperTextView_private_offset;
static gpointer granite_hyper_text_view_parent_class = NULL;

static void granite_hyper_text_view_buffer_connect (GraniteHyperTextView* self,
                                             GtkTextBuffer* buffer);
static void granite_hyper_text_view_on_buffer_cursor_position_changed (GraniteHyperTextView* self);
static void _granite_hyper_text_view_on_buffer_cursor_position_changed_g_object_notify (GObject* _sender,
                                                                                 GParamSpec* pspec,
                                                                                 gpointer self);
static void granite_hyper_text_view_on_paste_done (GraniteHyperTextView* self,
                                            GtkClipboard* clipboard);
static void _granite_hyper_text_view_on_paste_done_gtk_text_buffer_paste_done (GtkTextBuffer* _sender,
                                                                        GtkClipboard* clipboard,
                                                                        gpointer self);
static void granite_hyper_text_view_on_after_buffer_changed (GraniteHyperTextView* self);
static void _granite_hyper_text_view_on_after_buffer_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                               gpointer self);
static gboolean __lambda58_ (GraniteHyperTextView* self);
static void granite_hyper_text_view_update_tags_in_buffer_for_range (GraniteHyperTextView* self,
                                                              gint buffer_start_offset,
                                                              gint buffer_end_offset,
                                                              GAsyncReadyCallback _callback_,
                                                              gpointer _user_data_);
static void granite_hyper_text_view_update_tags_in_buffer_for_range_finish (GraniteHyperTextView* self,
                                                                     GAsyncResult* _res_);
static gboolean ___lambda58__gsource_func (gpointer self);
static void granite_hyper_text_view_update_tags_in_buffer_for_range_data_free (gpointer _data);
static gboolean granite_hyper_text_view_update_tags_in_buffer_for_range_co (GraniteHyperTextViewUpdateTagsInBufferForRangeData* _data_);
static gboolean granite_hyper_text_view_on_key_press_event (GraniteHyperTextView* self,
                                                     GdkEventKey* event);
static gchar* granite_hyper_text_view_get_uri_at_location (GraniteHyperTextView* self,
                                                    gint location_x,
                                                    gint location_y);
static gboolean granite_hyper_text_view_on_key_release_event (GraniteHyperTextView* self,
                                                       GdkEventKey* event);
static gboolean granite_hyper_text_view_on_button_release_event (GraniteHyperTextView* self);
static gboolean granite_hyper_text_view_on_motion_notify_event (GraniteHyperTextView* self,
                                                         GtkWidget* widget,
                                                         GdkEventMotion* event);
static gboolean granite_hyper_text_view_on_focus_out_event (GraniteHyperTextView* self,
                                                     GdkEventFocus* event);
static GObject * granite_hyper_text_view_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _granite_hyper_text_view___lambda61_ (GraniteHyperTextView* self);
static void __granite_hyper_text_view___lambda61__g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static gboolean _granite_hyper_text_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                           GdkEventButton* event,
                                                                                           gpointer self);
static gboolean _granite_hyper_text_view_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                         GdkEventMotion* event,
                                                                                         gpointer self);
static gboolean _granite_hyper_text_view_on_focus_out_event_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                                 GdkEventFocus* event,
                                                                                 gpointer self);
static gboolean _granite_hyper_text_view_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                                 GdkEventKey* event,
                                                                                 gpointer self);
static gboolean _granite_hyper_text_view_on_key_release_event_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                                     GdkEventKey* event,
                                                                                     gpointer self);
static void granite_hyper_text_view_finalize (GObject * obj);
static GType granite_hyper_text_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
granite_hyper_text_view_get_instance_private (GraniteHyperTextView* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteHyperTextView_private_offset);
}

static void
_granite_hyper_text_view_on_buffer_cursor_position_changed_g_object_notify (GObject* _sender,
                                                                            GParamSpec* pspec,
                                                                            gpointer self)
{
	granite_hyper_text_view_on_buffer_cursor_position_changed ((GraniteHyperTextView*) self);
}

static void
_granite_hyper_text_view_on_paste_done_gtk_text_buffer_paste_done (GtkTextBuffer* _sender,
                                                                   GtkClipboard* clipboard,
                                                                   gpointer self)
{
	granite_hyper_text_view_on_paste_done ((GraniteHyperTextView*) self, clipboard);
}

static void
_granite_hyper_text_view_on_after_buffer_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                          gpointer self)
{
	granite_hyper_text_view_on_after_buffer_changed ((GraniteHyperTextView*) self);
}

static void
granite_hyper_text_view_buffer_connect (GraniteHyperTextView* self,
                                        GtkTextBuffer* buffer)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_signal_connect_object ((GObject*) buffer, "notify::cursor-position", (GCallback) _granite_hyper_text_view_on_buffer_cursor_position_changed_g_object_notify, self, 0);
	g_signal_connect_object (buffer, "paste-done", (GCallback) _granite_hyper_text_view_on_paste_done_gtk_text_buffer_paste_done, self, 0);
	g_signal_connect_object (buffer, "changed", (GCallback) _granite_hyper_text_view_on_after_buffer_changed_gtk_text_buffer_changed, self, G_CONNECT_AFTER);
}

static void
granite_hyper_text_view_on_buffer_cursor_position_changed (GraniteHyperTextView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->buffer_cursor_position_when_change_started == 0) {
		GtkTextBuffer* _tmp0_;
		GtkTextBuffer* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp1_ = _tmp0_;
		g_object_get (_tmp1_, "cursor-position", &_tmp2_, NULL);
		_tmp3_ = _tmp2_;
		self->priv->buffer_cursor_position_when_change_started = _tmp3_;
	}
}

static void
granite_hyper_text_view_on_paste_done (GraniteHyperTextView* self,
                                       GtkClipboard* clipboard)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (clipboard != NULL);
	self->priv->buffer_cursor_position_when_change_started = GRANITE_HYPER_TEXT_VIEW_FORCE_FULL_BUFFER_RESCAN_CHANGE_START_OFFSET;
}

static gboolean
__lambda58_ (GraniteHyperTextView* self)
{
	gint change_start_offset = 0;
	gint change_end_offset = 0;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean result;
	self->priv->buffer_changed_debounce_timeout_id = (guint) 0;
	change_start_offset = self->priv->buffer_cursor_position_when_change_started;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "cursor-position", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	change_end_offset = _tmp3_;
	self->priv->buffer_cursor_position_when_change_started = 0;
	if (change_start_offset == GRANITE_HYPER_TEXT_VIEW_FORCE_FULL_BUFFER_RESCAN_CHANGE_START_OFFSET) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = change_start_offset == change_end_offset;
	}
	if (_tmp4_) {
		GtkTextBuffer* _tmp5_;
		GtkTextBuffer* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		change_start_offset = 0;
		_tmp5_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp6_ = _tmp5_;
		g_object_get (_tmp6_, "text", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		change_end_offset = _tmp11_;
		_g_free0 (_tmp9_);
	}
	granite_hyper_text_view_update_tags_in_buffer_for_range (self, MIN (change_start_offset, change_end_offset), MAX (change_start_offset, change_end_offset), NULL, NULL);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda58__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda58_ ((GraniteHyperTextView*) self);
	return result;
}

static void
granite_hyper_text_view_on_after_buffer_changed (GraniteHyperTextView* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->buffer_changed_debounce_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->buffer_changed_debounce_timeout_id);
		self->priv->buffer_changed_debounce_timeout_id = (guint) 0;
	}
	self->priv->buffer_changed_debounce_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ___lambda58__gsource_func, g_object_ref (self), g_object_unref);
}

static void
granite_hyper_text_view_update_tags_in_buffer_for_range_data_free (gpointer _data)
{
	GraniteHyperTextViewUpdateTagsInBufferForRangeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GraniteHyperTextViewUpdateTagsInBufferForRangeData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
granite_hyper_text_view_update_tags_in_buffer_for_range (GraniteHyperTextView* self,
                                                         gint buffer_start_offset,
                                                         gint buffer_end_offset,
                                                         GAsyncReadyCallback _callback_,
                                                         gpointer _user_data_)
{
	GraniteHyperTextViewUpdateTagsInBufferForRangeData* _data_;
	GraniteHyperTextView* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GraniteHyperTextViewUpdateTagsInBufferForRangeData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, granite_hyper_text_view_update_tags_in_buffer_for_range_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->buffer_start_offset = buffer_start_offset;
	_data_->buffer_end_offset = buffer_end_offset;
	granite_hyper_text_view_update_tags_in_buffer_for_range_co (_data_);
}

static void
granite_hyper_text_view_update_tags_in_buffer_for_range_finish (GraniteHyperTextView* self,
                                                                GAsyncResult* _res_)
{
	GraniteHyperTextViewUpdateTagsInBufferForRangeData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gpointer
_vala_g_hash_table_take (GHashTable* self,
                         gconstpointer key,
                         gboolean* exists)
{
	gboolean _vala_exists = FALSE;
	GHashTable* ht = NULL;
	void** htp = NULL;
	gconstpointer _tmp0_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	ht = NULL;
	htp = &ht;
	_tmp0_ = g_hash_table_lookup (self, key);
	*htp = _tmp0_;
	_vala_exists = g_hash_table_steal (self, key);
	result = ht;
	if (exists) {
		*exists = _vala_exists;
	}
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
granite_hyper_text_view_update_tags_in_buffer_for_range_co (GraniteHyperTextViewUpdateTagsInBufferForRangeData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->buffer_start_offset == _data_->buffer_end_offset) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	memset (&_data_->_tmp2_, 0, sizeof (GtkTextIter));
	gtk_text_buffer_get_iter_at_offset (_data_->_tmp1_, &_data_->_tmp2_, _data_->buffer_start_offset);
	_data_->buffer_start_iter = _data_->_tmp2_;
	gtk_text_iter_backward_line (&_data_->buffer_start_iter);
	_data_->buffer_start_offset = gtk_text_iter_get_offset (&_data_->buffer_start_iter);
	_data_->_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	memset (&_data_->_tmp5_, 0, sizeof (GtkTextIter));
	gtk_text_buffer_get_iter_at_offset (_data_->_tmp4_, &_data_->_tmp5_, _data_->buffer_end_offset);
	_data_->buffer_end_iter = _data_->_tmp5_;
	gtk_text_iter_forward_line (&_data_->buffer_end_iter);
	_data_->buffer_end_offset = gtk_text_iter_get_offset (&_data_->buffer_end_iter);
	{
		_data_->_tmp6_ = _data_->self->priv->uri_text_tags;
		g_rec_mutex_lock (&_data_->self->priv->__lock_uri_text_tags);
		{
			_data_->_tmp7_ = _data_->self->priv->uri_text_tags;
			_data_->_tmp8_ = g_hash_table_get_keys (_data_->_tmp7_);
			{
				_data_->tag_key_collection = _data_->_tmp8_;
				for (_data_->tag_key_it = _data_->tag_key_collection; _data_->tag_key_it != NULL; _data_->tag_key_it = _data_->tag_key_it->next) {
					_data_->tag_key = (const gchar*) _data_->tag_key_it->data;
					{
						_data_->_tmp9_ = _data_->tag_key;
						_data_->_tmp10_ = 0;
						_data_->_tmp11_ = 0;
						sscanf (_data_->_tmp9_, "[%i,%i]", &_data_->_tmp10_, &_data_->_tmp11_);
						_data_->tag_start_offset = _data_->_tmp10_;
						_data_->tag_end_offset = _data_->_tmp11_;
						if (_data_->tag_start_offset > _data_->buffer_start_offset) {
							_data_->_tmp13_ = _data_->tag_start_offset < _data_->buffer_end_offset;
						} else {
							_data_->_tmp13_ = FALSE;
						}
						if (_data_->_tmp13_) {
							_data_->_tmp12_ = TRUE;
						} else {
							if (_data_->tag_end_offset > _data_->buffer_start_offset) {
								_data_->_tmp14_ = _data_->tag_end_offset < _data_->buffer_end_offset;
							} else {
								_data_->_tmp14_ = FALSE;
							}
							_data_->_tmp12_ = _data_->_tmp14_;
						}
						if (_data_->_tmp12_) {
							_data_->_tmp15_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
							_data_->_tmp16_ = _data_->_tmp15_;
							_data_->_tmp17_ = gtk_text_buffer_get_tag_table (_data_->_tmp16_);
							_data_->_tmp18_ = _data_->_tmp17_;
							_data_->_tmp19_ = _data_->self->priv->uri_text_tags;
							_data_->_tmp20_ = _data_->tag_key;
							_data_->_tmp21_ = _vala_g_hash_table_take (_data_->_tmp19_, _data_->_tmp20_, NULL);
							_data_->_tmp22_ = (GtkTextTag*) _data_->_tmp21_;
							gtk_text_tag_table_remove (_data_->_tmp18_, _data_->_tmp22_);
							_g_object_unref0 (_data_->_tmp22_);
						}
					}
				}
				(_data_->tag_key_collection == NULL) ? NULL : (_data_->tag_key_collection = (g_list_free (_data_->tag_key_collection), NULL));
			}
		}
		__finally0:
		{
			_data_->_tmp23_ = _data_->self->priv->uri_text_tags;
			g_rec_mutex_unlock (&_data_->self->priv->__lock_uri_text_tags);
		}
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp24_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
	_data_->_tmp25_ = _data_->_tmp24_;
	g_object_get (_data_->_tmp25_, "text", &_data_->_tmp26_, NULL);
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = string_index_of_nth_char (_data_->_tmp28_, (glong) _data_->buffer_start_offset);
	_g_free0 (_data_->_tmp28_);
	_data_->buffer_start_index = _data_->_tmp29_;
	_data_->_tmp30_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
	_data_->_tmp31_ = _data_->_tmp30_;
	g_object_get (_data_->_tmp31_, "text", &_data_->_tmp32_, NULL);
	_data_->_tmp33_ = _data_->_tmp32_;
	_data_->_tmp34_ = _data_->_tmp33_;
	_data_->_tmp35_ = string_index_of_nth_char (_data_->_tmp34_, (glong) _data_->buffer_end_offset);
	_g_free0 (_data_->_tmp34_);
	_data_->buffer_end_index = _data_->_tmp35_;
	_data_->_tmp36_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
	_data_->_tmp37_ = _data_->_tmp36_;
	g_object_get (_data_->_tmp37_, "text", &_data_->_tmp38_, NULL);
	_data_->_tmp39_ = _data_->_tmp38_;
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = string_substring (_data_->_tmp40_, (glong) _data_->buffer_start_index, (glong) (_data_->buffer_end_index - _data_->buffer_start_index));
	_data_->_tmp42_ = _data_->_tmp41_;
	_g_free0 (_data_->_tmp40_);
	_data_->buffer_substring = _data_->_tmp42_;
	_data_->_tmp43_ = _data_->buffer_substring;
	_data_->_tmp44_ = string_strip (_data_->_tmp43_);
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->_tmp46_ = g_strcmp0 (_data_->_tmp45_, "") == 0;
	_g_free0 (_data_->_tmp45_);
	if (_data_->_tmp46_) {
		_g_free0 (_data_->buffer_substring);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp47_ = _data_->self->priv->uri_regex;
	_data_->_tmp48_ = _data_->buffer_substring;
	_data_->_tmp49_ = NULL;
	g_regex_match (_data_->_tmp47_, _data_->_tmp48_, 0, &_data_->_tmp49_);
	_g_match_info_unref0 (_data_->match_info);
	_data_->match_info = _data_->_tmp49_;
	while (TRUE) {
		_data_->_tmp50_ = _data_->match_info;
		if (!g_match_info_matches (_data_->_tmp50_)) {
			break;
		}
		_data_->_tmp51_ = _data_->match_info;
		_data_->_tmp52_ = g_match_info_fetch (_data_->_tmp51_, 0);
		_data_->match_text = _data_->_tmp52_;
		_data_->_tmp53_ = _data_->match_info;
		_data_->_tmp54_ = 0;
		_data_->_tmp55_ = 0;
		g_match_info_fetch_pos (_data_->_tmp53_, 0, &_data_->_tmp54_, &_data_->_tmp55_);
		_data_->match_start_index = _data_->_tmp54_;
		_data_->match_end_index = _data_->_tmp55_;
		_data_->_tmp56_ = _data_->buffer_substring;
		_data_->_tmp57_ = string_substring (_data_->_tmp56_, (glong) 0, (glong) _data_->match_start_index);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->match_start_offset = g_utf8_strlen (_data_->_tmp58_, (gssize) -1);
		_g_free0 (_data_->_tmp58_);
		_data_->_tmp59_ = _data_->buffer_substring;
		_data_->_tmp60_ = string_substring (_data_->_tmp59_, (glong) 0, (glong) _data_->match_end_index);
		_data_->_tmp61_ = _data_->_tmp60_;
		_data_->match_end_offset = g_utf8_strlen (_data_->_tmp61_, (gssize) -1);
		_g_free0 (_data_->_tmp61_);
		_data_->buffer_match_start_offset = _data_->buffer_start_offset + _data_->match_start_offset;
		_data_->buffer_match_end_offset = _data_->buffer_start_offset + _data_->match_end_offset;
		_data_->_tmp62_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
		_data_->_tmp63_ = _data_->_tmp62_;
		memset (&_data_->_tmp64_, 0, sizeof (GtkTextIter));
		gtk_text_buffer_get_iter_at_offset (_data_->_tmp63_, &_data_->_tmp64_, _data_->buffer_match_start_offset);
		_data_->buffer_match_start_iter = _data_->_tmp64_;
		_data_->_tmp65_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
		_data_->_tmp66_ = _data_->_tmp65_;
		memset (&_data_->_tmp67_, 0, sizeof (GtkTextIter));
		gtk_text_buffer_get_iter_at_offset (_data_->_tmp66_, &_data_->_tmp67_, _data_->buffer_match_end_offset);
		_data_->buffer_match_end_iter = _data_->_tmp67_;
		_data_->_tmp68_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
		_data_->_tmp69_ = _data_->_tmp68_;
		_data_->_tmp70_ = gtk_text_buffer_create_tag (_data_->_tmp69_, NULL, "underline", PANGO_UNDERLINE_SINGLE, NULL);
		_data_->_tmp71_ = _g_object_ref0 (_data_->_tmp70_);
		_data_->tag = _data_->_tmp71_;
		_data_->_tmp74_ = _data_->match_text;
		if (!string_contains (_data_->_tmp74_, "://")) {
			_data_->_tmp75_ = _data_->match_text;
			_data_->_tmp73_ = string_contains (_data_->_tmp75_, "@");
		} else {
			_data_->_tmp73_ = FALSE;
		}
		if (_data_->_tmp73_) {
			_data_->_tmp76_ = _data_->match_text;
			_data_->_tmp72_ = !g_str_has_prefix (_data_->_tmp76_, "mailto:");
		} else {
			_data_->_tmp72_ = FALSE;
		}
		if (_data_->_tmp72_) {
			_data_->_tmp77_ = _data_->match_text;
			_data_->_tmp78_ = g_strconcat ("mailto:", _data_->_tmp77_, NULL);
			_g_free0 (_data_->match_text);
			_data_->match_text = _data_->_tmp78_;
		}
		_data_->_tmp79_ = _data_->tag;
		_data_->_tmp80_ = _data_->match_text;
		_data_->_tmp81_ = g_strdup (_data_->_tmp80_);
		g_object_set_data_full ((GObject*) _data_->_tmp79_, "uri", _data_->_tmp81_, g_free);
		_data_->_tmp82_ = gtk_text_view_get_buffer ((GtkTextView*) _data_->self);
		_data_->_tmp83_ = _data_->_tmp82_;
		_data_->_tmp84_ = _data_->tag;
		_data_->_tmp85_ = _data_->buffer_match_start_iter;
		_data_->_tmp86_ = _data_->buffer_match_end_iter;
		gtk_text_buffer_apply_tag (_data_->_tmp83_, _data_->_tmp84_, &_data_->_tmp85_, &_data_->_tmp86_);
		{
			_data_->_tmp87_ = _data_->self->priv->uri_text_tags;
			g_rec_mutex_lock (&_data_->self->priv->__lock_uri_text_tags);
			{
				_data_->_tmp88_ = _data_->self->priv->uri_text_tags;
				_data_->_tmp89_ = g_strdup_printf ("[%i,%i]", _data_->buffer_match_start_offset, _data_->buffer_match_end_offset);
				_data_->_tmp90_ = _data_->tag;
				_data_->_tmp91_ = _g_object_ref0 (_data_->_tmp90_);
				g_hash_table_insert (_data_->_tmp88_, _data_->_tmp89_, _data_->_tmp91_);
			}
			__finally1:
			{
				_data_->_tmp92_ = _data_->self->priv->uri_text_tags;
				g_rec_mutex_unlock (&_data_->self->priv->__lock_uri_text_tags);
			}
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_object_unref0 (_data_->tag);
				_g_free0 (_data_->match_text);
				_g_match_info_unref0 (_data_->match_info);
				_g_free0 (_data_->buffer_substring);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		{
			_data_->_tmp93_ = _data_->match_info;
			g_match_info_next (_data_->_tmp93_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				if (_data_->_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch2_g_regex_error;
				}
				_g_object_unref0 (_data_->tag);
				_g_free0 (_data_->match_text);
				_g_match_info_unref0 (_data_->match_info);
				_g_free0 (_data_->buffer_substring);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		goto __finally2;
		__catch2_g_regex_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp94_ = _data_->e;
			_data_->_tmp95_ = _data_->_tmp94_->message;
			g_warning ("HyperTextView.vala:213: RegexError while scanning for the next URI mat" \
"ch: %s", _data_->_tmp95_);
			_g_error_free0 (_data_->e);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->tag);
			_g_free0 (_data_->match_text);
			_g_match_info_unref0 (_data_->match_info);
			_g_free0 (_data_->buffer_substring);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->tag);
		_g_free0 (_data_->match_text);
	}
	_g_match_info_unref0 (_data_->match_info);
	_g_free0 (_data_->buffer_substring);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
granite_hyper_text_view_on_key_press_event (GraniteHyperTextView* self,
                                            GdkEventKey* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == GDK_KEY_Control_L) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event->keyval == GDK_KEY_Control_R;
	}
	if (_tmp0_) {
		GdkWindow* window = NULL;
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		GdkWindow* _tmp3_;
		_tmp1_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		window = _tmp2_;
		_tmp3_ = window;
		if (_tmp3_ != NULL) {
			GdkDevice* pointer_device = NULL;
			GdkWindow* _tmp4_;
			GdkDisplay* _tmp5_;
			GdkSeat* _tmp6_;
			GdkDevice* _tmp7_;
			GdkDevice* _tmp8_;
			GdkDevice* _tmp9_;
			_tmp4_ = window;
			_tmp5_ = gdk_window_get_display (_tmp4_);
			_tmp6_ = gdk_display_get_default_seat (_tmp5_);
			_tmp7_ = gdk_seat_get_pointer (_tmp6_);
			_tmp8_ = _g_object_ref0 (_tmp7_);
			pointer_device = _tmp8_;
			_tmp9_ = pointer_device;
			if (_tmp9_ != NULL) {
				gint pointer_x = 0;
				gint pointer_y = 0;
				GdkWindow* _tmp10_;
				GdkDevice* _tmp11_;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gchar* uri_hovering_over = NULL;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp10_ = window;
				_tmp11_ = pointer_device;
				gdk_window_get_device_position (_tmp10_, _tmp11_, &_tmp12_, &_tmp13_, NULL);
				pointer_x = _tmp12_;
				pointer_y = _tmp13_;
				_tmp14_ = granite_hyper_text_view_get_uri_at_location (self, pointer_x, pointer_y);
				uri_hovering_over = _tmp14_;
				_tmp15_ = uri_hovering_over;
				if (_tmp15_ != NULL) {
					GdkWindow* _tmp16_;
					GdkDisplay* _tmp17_;
					GdkCursor* _tmp18_;
					GdkCursor* _tmp19_;
					_tmp16_ = window;
					_tmp17_ = gtk_widget_get_display ((GtkWidget*) self);
					_tmp18_ = gdk_cursor_new_from_name (_tmp17_, "pointer");
					_tmp19_ = _tmp18_;
					gdk_window_set_cursor (_tmp16_, _tmp19_);
					_g_object_unref0 (_tmp19_);
				}
				_g_free0 (uri_hovering_over);
			}
			_g_object_unref0 (pointer_device);
		}
		self->priv->is_control_key_pressed = TRUE;
		_g_object_unref0 (window);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
granite_hyper_text_view_on_key_release_event (GraniteHyperTextView* self,
                                              GdkEventKey* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->keyval == GDK_KEY_Control_L) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = event->keyval == GDK_KEY_Control_R;
	}
	if (_tmp0_) {
		GdkWindow* window = NULL;
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		window = _tmp2_;
		if (self->priv->is_control_key_pressed) {
			GdkWindow* _tmp4_;
			_tmp4_ = window;
			_tmp3_ = _tmp4_ != NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GdkWindow* _tmp5_;
			GdkDisplay* _tmp6_;
			GdkCursor* _tmp7_;
			GdkCursor* _tmp8_;
			_tmp5_ = window;
			_tmp6_ = gtk_widget_get_display ((GtkWidget*) self);
			_tmp7_ = gdk_cursor_new_from_name (_tmp6_, "text");
			_tmp8_ = _tmp7_;
			gdk_window_set_cursor (_tmp5_, _tmp8_);
			_g_object_unref0 (_tmp8_);
		}
		self->priv->is_control_key_pressed = FALSE;
		_g_object_unref0 (window);
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
granite_hyper_text_view_on_button_release_event (GraniteHyperTextView* self)
{
	GtkTextIter text_iter = {0};
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GSList* tags = NULL;
	GSList* _tmp6_;
	GSList* _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->is_control_key_pressed) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_text_buffer_get_insert (_tmp3_);
	gtk_text_buffer_get_iter_at_mark (_tmp1_, &_tmp5_, _tmp4_);
	text_iter = _tmp5_;
	_tmp6_ = gtk_text_iter_get_tags (&text_iter);
	tags = _tmp6_;
	_tmp7_ = tags;
	{
		GSList* tag_collection = NULL;
		GSList* tag_it = NULL;
		tag_collection = _tmp7_;
		for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
			GtkTextTag* tag = NULL;
			tag = (GtkTextTag*) tag_it->data;
			{
				GtkTextTag* _tmp8_;
				gconstpointer _tmp9_;
				_tmp8_ = tag;
				_tmp9_ = g_object_get_data ((GObject*) _tmp8_, "uri");
				if (((const gchar*) _tmp9_) != NULL) {
					gchar* uri = NULL;
					GtkTextTag* _tmp10_;
					gconstpointer _tmp11_;
					gchar* _tmp12_;
					_tmp10_ = tag;
					_tmp11_ = g_object_get_data ((GObject*) _tmp10_, "uri");
					_tmp12_ = g_strdup ((const gchar*) _tmp11_);
					uri = _tmp12_;
					{
						const gchar* _tmp13_;
						_tmp13_ = uri;
						g_app_info_launch_default_for_uri (_tmp13_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp14_;
						GError* _tmp15_;
						const gchar* _tmp16_;
						GraniteMessageDialog* error_dialog = NULL;
						GError* _tmp17_;
						const gchar* _tmp18_;
						GThemedIcon* _tmp19_;
						GThemedIcon* _tmp20_;
						GraniteMessageDialog* _tmp21_;
						GraniteMessageDialog* _tmp22_;
						GraniteMessageDialog* _tmp23_;
						GraniteMessageDialog* _tmp24_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp14_ = uri;
						_tmp15_ = e;
						_tmp16_ = _tmp15_->message;
						g_warning ("HyperTextView.vala:264: Could not open URI '%s': %s", _tmp14_, _tmp16_);
						_tmp17_ = e;
						_tmp18_ = _tmp17_->message;
						_tmp19_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
						_tmp20_ = _tmp19_;
						_tmp21_ = granite_message_dialog_new (_ ("Could not open URI"), _tmp18_, (GIcon*) _tmp20_, GTK_BUTTONS_CLOSE);
						g_object_ref_sink (_tmp21_);
						_tmp22_ = _tmp21_;
						_g_object_unref0 (_tmp20_);
						error_dialog = _tmp22_;
						_tmp23_ = error_dialog;
						gtk_dialog_run ((GtkDialog*) _tmp23_);
						_tmp24_ = error_dialog;
						gtk_widget_destroy ((GtkWidget*) _tmp24_);
						_g_object_unref0 (error_dialog);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp25_ = FALSE;
						_g_free0 (uri);
						(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp25_;
					}
					_g_free0 (uri);
					break;
				}
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static gboolean
granite_hyper_text_view_on_motion_notify_event (GraniteHyperTextView* self,
                                                GtkWidget* widget,
                                                GdkEventMotion* event)
{
	gchar* uri_hovering_over = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = granite_hyper_text_view_get_uri_at_location (self, (gint) event->x, (gint) event->y);
	uri_hovering_over = _tmp0_;
	_tmp2_ = uri_hovering_over;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = gtk_widget_get_has_tooltip ((GtkWidget*) self);
		_tmp4_ = _tmp3_;
		_tmp1_ = !_tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gtk_widget_set_has_tooltip ((GtkWidget*) self, TRUE);
		_tmp5_ = g_strdup (_ ("Follow Link"));
		_tmp6_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _ ("Control + Click"));
		_tmp7_ = g_new0 (gchar*, 2 + 1);
		_tmp7_[0] = _tmp5_;
		_tmp7_[1] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 2;
		_tmp9_ = _vala_g_strjoinv ("\n", _tmp8_, (gint) 2);
		_tmp10_ = _tmp9_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) self, _tmp10_);
		_g_free0 (_tmp10_);
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	} else {
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		_tmp12_ = uri_hovering_over;
		if (_tmp12_ == NULL) {
			gboolean _tmp13_;
			gboolean _tmp14_;
			_tmp13_ = gtk_widget_get_has_tooltip ((GtkWidget*) self);
			_tmp14_ = _tmp13_;
			_tmp11_ = _tmp14_;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			gtk_widget_set_has_tooltip ((GtkWidget*) self, FALSE);
		}
	}
	result = GDK_EVENT_PROPAGATE;
	_g_free0 (uri_hovering_over);
	return result;
}

static gchar*
granite_hyper_text_view_get_uri_at_location (GraniteHyperTextView* self,
                                             gint location_x,
                                             gint location_y)
{
	gchar* uri = NULL;
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GdkWindow* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	uri = NULL;
	_tmp0_ = gtk_text_view_get_window ((GtkTextView*) self, GTK_TEXT_WINDOW_WIDGET);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = window;
	if (_tmp2_ != NULL) {
		gint x = 0;
		gint y = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GtkTextIter text_iter = {0};
		GtkTextIter _tmp5_ = {0};
		gboolean _tmp6_;
		gtk_text_view_window_to_buffer_coords ((GtkTextView*) self, GTK_TEXT_WINDOW_TEXT, location_x, location_y, &_tmp3_, &_tmp4_);
		x = _tmp3_;
		y = _tmp4_;
		_tmp6_ = gtk_text_view_get_iter_at_location ((GtkTextView*) self, &_tmp5_, x, y);
		text_iter = _tmp5_;
		if (_tmp6_) {
			GSList* tags = NULL;
			GSList* _tmp7_;
			GSList* _tmp8_;
			_tmp7_ = gtk_text_iter_get_tags (&text_iter);
			tags = _tmp7_;
			_tmp8_ = tags;
			{
				GSList* tag_collection = NULL;
				GSList* tag_it = NULL;
				tag_collection = _tmp8_;
				for (tag_it = tag_collection; tag_it != NULL; tag_it = tag_it->next) {
					GtkTextTag* tag = NULL;
					tag = (GtkTextTag*) tag_it->data;
					{
						GtkTextTag* _tmp9_;
						gconstpointer _tmp10_;
						_tmp9_ = tag;
						_tmp10_ = g_object_get_data ((GObject*) _tmp9_, "uri");
						if (((const gchar*) _tmp10_) != NULL) {
							GtkTextTag* _tmp11_;
							gconstpointer _tmp12_;
							gchar* _tmp13_;
							_tmp11_ = tag;
							_tmp12_ = g_object_get_data ((GObject*) _tmp11_, "uri");
							_tmp13_ = g_strdup ((const gchar*) _tmp12_);
							_g_free0 (uri);
							uri = _tmp13_;
							break;
						}
					}
				}
			}
			(tags == NULL) ? NULL : (tags = (g_slist_free (tags), NULL));
		}
	}
	result = uri;
	_g_object_unref0 (window);
	return result;
}

static gboolean
granite_hyper_text_view_on_focus_out_event (GraniteHyperTextView* self,
                                            GdkEventFocus* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->is_control_key_pressed = FALSE;
	result = GDK_EVENT_PROPAGATE;
	return result;
}

GraniteHyperTextView*
granite_hyper_text_view_construct (GType object_type)
{
	GraniteHyperTextView * self = NULL;
	self = (GraniteHyperTextView*) g_object_new (object_type, NULL);
	return self;
}

GraniteHyperTextView*
granite_hyper_text_view_new (void)
{
	return granite_hyper_text_view_construct (GRANITE_TYPE_HYPER_TEXT_VIEW);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_granite_hyper_text_view___lambda61_ (GraniteHyperTextView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	granite_hyper_text_view_buffer_connect (self, _tmp1_);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (_tmp3_, "changed");
}

static void
__granite_hyper_text_view___lambda61__g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	_granite_hyper_text_view___lambda61_ ((GraniteHyperTextView*) self);
}

static gboolean
_granite_hyper_text_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                  GdkEventButton* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = granite_hyper_text_view_on_button_release_event ((GraniteHyperTextView*) self);
	return result;
}

static gboolean
_granite_hyper_text_view_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                                GdkEventMotion* event,
                                                                                gpointer self)
{
	gboolean result;
	result = granite_hyper_text_view_on_motion_notify_event ((GraniteHyperTextView*) self, _sender, event);
	return result;
}

static gboolean
_granite_hyper_text_view_on_focus_out_event_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                        GdkEventFocus* event,
                                                                        gpointer self)
{
	gboolean result;
	result = granite_hyper_text_view_on_focus_out_event ((GraniteHyperTextView*) self, event);
	return result;
}

static gboolean
_granite_hyper_text_view_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                        GdkEventKey* event,
                                                                        gpointer self)
{
	gboolean result;
	result = granite_hyper_text_view_on_key_press_event ((GraniteHyperTextView*) self, event);
	return result;
}

static gboolean
_granite_hyper_text_view_on_key_release_event_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                            GdkEventKey* event,
                                                                            gpointer self)
{
	gboolean result;
	result = granite_hyper_text_view_on_key_release_event ((GraniteHyperTextView*) self, event);
	return result;
}

static GObject *
granite_hyper_text_view_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteHyperTextView * self;
	gchar* http_charset = NULL;
	gchar* _tmp0_;
	gchar* email_charset = NULL;
	gchar* _tmp1_;
	gchar* email_tld_charset = NULL;
	gchar* _tmp2_;
	gchar* http_match_str = NULL;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* email_match_str = NULL;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* uri_regex_str = NULL;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GHashFunc _tmp25_;
	GEqualFunc _tmp26_;
	GHashTable* _tmp27_;
	GtkTextBuffer* _tmp34_;
	GtkTextBuffer* _tmp35_;
	GList* toplevel_windows = NULL;
	GList* _tmp36_;
	GList* _tmp37_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (granite_hyper_text_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_HYPER_TEXT_VIEW, GraniteHyperTextView);
	_tmp0_ = g_strdup ("[\\w\\/\\-\\+\\.:@\\?&%=#]");
	http_charset = _tmp0_;
	_tmp1_ = g_strdup ("[\\w\\-\\.]");
	email_charset = _tmp1_;
	_tmp2_ = g_strdup ("[\\w\\-]");
	email_tld_charset = _tmp2_;
	_tmp3_ = http_charset;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = http_charset;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = g_strconcat ("https?:\\/\\/", _tmp4_, "+\\.", _tmp6_, "+", NULL);
	http_match_str = _tmp7_;
	_tmp8_ = email_charset;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = email_charset;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = email_tld_charset;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = g_strconcat ("(mailto:)?", _tmp9_, "+@", _tmp11_, "+\\.", _tmp13_, "+", NULL);
	email_match_str = _tmp14_;
	_tmp15_ = http_match_str;
	_tmp16_ = g_strconcat ("(?:(", _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strconcat (_tmp17_, ")|(", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = email_match_str;
	_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strconcat (_tmp22_, "))", NULL);
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp22_);
	_g_free0 (_tmp19_);
	_g_free0 (_tmp17_);
	uri_regex_str = _tmp24_;
	_tmp25_ = g_str_hash;
	_tmp26_ = g_direct_equal;
	_tmp27_ = g_hash_table_new_full (_tmp25_, _tmp26_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->uri_text_tags);
	self->priv->uri_text_tags = _tmp27_;
	{
		GRegex* _tmp28_ = NULL;
		const gchar* _tmp29_;
		GRegex* _tmp30_;
		GRegex* _tmp31_;
		_tmp29_ = uri_regex_str;
		_tmp30_ = g_regex_new (_tmp29_, 0, 0, &_inner_error0_);
		_tmp28_ = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_free0 (uri_regex_str);
			_g_free0 (email_match_str);
			_g_free0 (http_match_str);
			_g_free0 (email_tld_charset);
			_g_free0 (email_charset);
			_g_free0 (http_charset);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp31_ = _tmp28_;
		_tmp28_ = NULL;
		_g_regex_unref0 (self->priv->uri_regex);
		self->priv->uri_regex = _tmp31_;
		_g_regex_unref0 (_tmp28_);
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_critical ("HyperTextView.vala:54: RegexError while constructing URI regex: %s", _tmp33_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (uri_regex_str);
		_g_free0 (email_match_str);
		_g_free0 (http_match_str);
		_g_free0 (email_tld_charset);
		_g_free0 (email_charset);
		_g_free0 (http_charset);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp34_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp35_ = _tmp34_;
	granite_hyper_text_view_buffer_connect (self, _tmp35_);
	g_signal_connect_object ((GObject*) self, "notify::buffer", (GCallback) __granite_hyper_text_view___lambda61__g_object_notify, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _granite_hyper_text_view_on_button_release_event_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _granite_hyper_text_view_on_motion_notify_event_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _granite_hyper_text_view_on_focus_out_event_gtk_widget_focus_out_event, self, 0);
	_tmp36_ = gtk_window_list_toplevels ();
	toplevel_windows = _tmp36_;
	_tmp37_ = toplevel_windows;
	if (g_list_length (_tmp37_) != ((guint) 0)) {
		GList* _tmp38_;
		_tmp38_ = toplevel_windows;
		{
			GList* toplevel_window_collection = NULL;
			GList* toplevel_window_it = NULL;
			toplevel_window_collection = _tmp38_;
			for (toplevel_window_it = toplevel_window_collection; toplevel_window_it != NULL; toplevel_window_it = toplevel_window_it->next) {
				GtkWindow* toplevel_window = NULL;
				toplevel_window = (GtkWindow*) toplevel_window_it->data;
				{
					GtkWindow* _tmp39_;
					GtkWindow* _tmp40_;
					_tmp39_ = toplevel_window;
					g_signal_connect_object ((GtkWidget*) _tmp39_, "key-press-event", (GCallback) _granite_hyper_text_view_on_key_press_event_gtk_widget_key_press_event, self, 0);
					_tmp40_ = toplevel_window;
					g_signal_connect_object ((GtkWidget*) _tmp40_, "key-release-event", (GCallback) _granite_hyper_text_view_on_key_release_event_gtk_widget_key_release_event, self, 0);
				}
			}
		}
	} else {
		g_warning ("HyperTextView.vala:81: Could not bind key-press events to top-level wi" \
"ndow, Control + Click may not always behave correctly.");
		g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _granite_hyper_text_view_on_key_press_event_gtk_widget_key_press_event, self, 0);
		g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _granite_hyper_text_view_on_key_release_event_gtk_widget_key_release_event, self, 0);
	}
	(toplevel_windows == NULL) ? NULL : (toplevel_windows = (g_list_free (toplevel_windows), NULL));
	_g_free0 (uri_regex_str);
	_g_free0 (email_match_str);
	_g_free0 (http_match_str);
	_g_free0 (email_tld_charset);
	_g_free0 (email_charset);
	_g_free0 (http_charset);
	return obj;
}

static void
granite_hyper_text_view_class_init (GraniteHyperTextViewClass * klass,
                                    gpointer klass_data)
{
	granite_hyper_text_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteHyperTextView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = granite_hyper_text_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_hyper_text_view_finalize;
}

static void
granite_hyper_text_view_instance_init (GraniteHyperTextView * self,
                                       gpointer klass)
{
	self->priv = granite_hyper_text_view_get_instance_private (self);
	self->priv->buffer_changed_debounce_timeout_id = (guint) 0;
	self->priv->buffer_cursor_position_when_change_started = 0;
	g_rec_mutex_init (&self->priv->__lock_uri_text_tags);
	self->priv->is_control_key_pressed = FALSE;
}

static void
granite_hyper_text_view_finalize (GObject * obj)
{
	GraniteHyperTextView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_HYPER_TEXT_VIEW, GraniteHyperTextView);
	g_rec_mutex_clear (&self->priv->__lock_uri_text_tags);
	_g_hash_table_unref0 (self->priv->uri_text_tags);
	_g_regex_unref0 (self->priv->uri_regex);
	G_OBJECT_CLASS (granite_hyper_text_view_parent_class)->finalize (obj);
}

/**
* This class enables navigatable URLs in Gtk.TextView
 * @since 6.1.3
 */
static GType
granite_hyper_text_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteHyperTextViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_hyper_text_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteHyperTextView), 0, (GInstanceInitFunc) granite_hyper_text_view_instance_init, NULL };
	GType granite_hyper_text_view_type_id;
	granite_hyper_text_view_type_id = g_type_register_static (gtk_text_view_get_type (), "GraniteHyperTextView", &g_define_type_info, 0);
	GraniteHyperTextView_private_offset = g_type_add_instance_private (granite_hyper_text_view_type_id, sizeof (GraniteHyperTextViewPrivate));
	return granite_hyper_text_view_type_id;
}

GType
granite_hyper_text_view_get_type (void)
{
	static volatile gsize granite_hyper_text_view_type_id__once = 0;
	if (g_once_init_enter (&granite_hyper_text_view_type_id__once)) {
		GType granite_hyper_text_view_type_id;
		granite_hyper_text_view_type_id = granite_hyper_text_view_get_type_once ();
		g_once_init_leave (&granite_hyper_text_view_type_id__once, granite_hyper_text_view_type_id);
	}
	return granite_hyper_text_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

