/* CollapsiblePaned.c generated by valac 0.56.17, the Vala compiler
 * generated from CollapsiblePaned.vala, do not modify */

/*
 * Copyright 2011-2013 Mathijs Henquet
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "granite.h"
#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRANITE_WIDGETS_COLLAPSIBLE_PANED_0_PROPERTY,
	GRANITE_WIDGETS_COLLAPSIBLE_PANED_COLLAPSE_MODE_PROPERTY,
	GRANITE_WIDGETS_COLLAPSIBLE_PANED_NUM_PROPERTIES
};
static GParamSpec* granite_widgets_collapsible_paned_properties[GRANITE_WIDGETS_COLLAPSIBLE_PANED_NUM_PROPERTIES];

struct _GraniteWidgetsCollapsiblePanedPrivate {
	GraniteCollapseMode _collapse_mode;
	gint saved_state;
	guint last_click_time;
};

static gint GraniteWidgetsCollapsiblePaned_private_offset;
static gpointer granite_widgets_collapsible_paned_parent_class = NULL;

static gboolean granite_widgets_collapsible_paned_detect_toggle (GraniteWidgetsCollapsiblePaned* self,
                                                          GdkEventButton* event);
static GObject * granite_widgets_collapsible_paned_constructor (GType type,
                                                         guint n_construct_properties,
                                                         GObjectConstructParam * construct_properties);
static gboolean _granite_widgets_collapsible_paned_detect_toggle_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                         GdkEventButton* event,
                                                                                         gpointer self);
static void granite_widgets_collapsible_paned_finalize (GObject * obj);
static GType granite_widgets_collapsible_paned_get_type_once (void);
static void _vala_granite_widgets_collapsible_paned_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec);
static void _vala_granite_widgets_collapsible_paned_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec);

static GType
granite_collapse_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_COLLAPSE_MODE_NONE, "GRANITE_COLLAPSE_MODE_NONE", "none"}, {GRANITE_COLLAPSE_MODE_LEFT, "GRANITE_COLLAPSE_MODE_LEFT", "left"}, {GRANITE_COLLAPSE_MODE_TOP, "GRANITE_COLLAPSE_MODE_TOP", "top"}, {GRANITE_COLLAPSE_MODE_FIRST, "GRANITE_COLLAPSE_MODE_FIRST", "first"}, {GRANITE_COLLAPSE_MODE_RIGHT, "GRANITE_COLLAPSE_MODE_RIGHT", "right"}, {GRANITE_COLLAPSE_MODE_BOTTOM, "GRANITE_COLLAPSE_MODE_BOTTOM", "bottom"}, {GRANITE_COLLAPSE_MODE_LAST, "GRANITE_COLLAPSE_MODE_LAST", "last"}, {0, NULL, NULL}};
	GType granite_collapse_mode_type_id;
	granite_collapse_mode_type_id = g_enum_register_static ("GraniteCollapseMode", values);
	return granite_collapse_mode_type_id;
}

GType
granite_collapse_mode_get_type (void)
{
	static volatile gsize granite_collapse_mode_type_id__once = 0;
	if (g_once_init_enter (&granite_collapse_mode_type_id__once)) {
		GType granite_collapse_mode_type_id;
		granite_collapse_mode_type_id = granite_collapse_mode_get_type_once ();
		g_once_init_leave (&granite_collapse_mode_type_id__once, granite_collapse_mode_type_id);
	}
	return granite_collapse_mode_type_id__once;
}

static inline gpointer
granite_widgets_collapsible_paned_get_instance_private (GraniteWidgetsCollapsiblePaned* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteWidgetsCollapsiblePaned_private_offset);
}

GraniteCollapseMode
granite_widgets_collapsible_paned_get_collapse_mode (GraniteWidgetsCollapsiblePaned* self)
{
	GraniteCollapseMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_collapse_mode;
	return result;
}

void
granite_widgets_collapsible_paned_set_collapse_mode (GraniteWidgetsCollapsiblePaned* self,
                                                     GraniteCollapseMode value)
{
	GraniteCollapseMode old_value;
	g_return_if_fail (self != NULL);
	old_value = granite_widgets_collapsible_paned_get_collapse_mode (self);
	if (old_value != value) {
		self->priv->_collapse_mode = value;
		g_object_notify_by_pspec ((GObject *) self, granite_widgets_collapsible_paned_properties[GRANITE_WIDGETS_COLLAPSIBLE_PANED_COLLAPSE_MODE_PROPERTY]);
	}
}

GraniteWidgetsCollapsiblePaned*
granite_widgets_collapsible_paned_construct (GType object_type,
                                             GtkOrientation orientation)
{
	GraniteWidgetsCollapsiblePaned * self = NULL;
	self = (GraniteWidgetsCollapsiblePaned*) g_object_new (object_type, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, orientation);
	return self;
}

GraniteWidgetsCollapsiblePaned*
granite_widgets_collapsible_paned_new (GtkOrientation orientation)
{
	return granite_widgets_collapsible_paned_construct (GRANITE_WIDGETS_TYPE_COLLAPSIBLE_PANED, orientation);
}

static gboolean
granite_widgets_collapsible_paned_detect_toggle (GraniteWidgetsCollapsiblePaned* self,
                                                 GdkEventButton* event)
{
	GraniteCollapseMode _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkSettings* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_collapse_mode;
	if (_tmp0_ == GRANITE_COLLAPSE_MODE_NONE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = gtk_settings_get_default ();
	g_object_get (_tmp2_, "gtk-double-click-time", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (event->time < ((guint32) (self->priv->last_click_time + _tmp4_))) {
		_tmp1_ = event->type != GDK_2BUTTON_PRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	if (event->type == GDK_2BUTTON_PRESS) {
		GdkWindow* _tmp6_;
		GdkWindow* _tmp7_;
		_tmp6_ = event->window;
		_tmp7_ = gtk_paned_get_handle_window ((GtkPaned*) self);
		_tmp5_ = _tmp6_ == _tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gboolean _tmp8_ = FALSE;
		gint current_position = 0;
		GraniteCollapseMode _tmp9_;
		gint requested_position = 0;
		GraniteCollapseMode _tmp12_;
		g_signal_emit_by_name ((GtkPaned*) self, "accept-position", &_tmp8_);
		current_position = gtk_paned_get_position ((GtkPaned*) self);
		_tmp9_ = self->priv->_collapse_mode;
		if (_tmp9_ == GRANITE_COLLAPSE_MODE_LAST) {
			gint _tmp10_;
			gint _tmp11_;
			g_object_get ((GtkPaned*) self, "max-position", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			current_position = _tmp11_ - current_position;
		}
		if (current_position == 0) {
			g_debug ("CollapsiblePaned.vala:56: [CollapsablePaned] expand");
			requested_position = self->priv->saved_state;
		} else {
			self->priv->saved_state = current_position;
			g_debug ("CollapsiblePaned.vala:61: [CollapsablePaned] shrink");
			requested_position = 0;
		}
		_tmp12_ = self->priv->_collapse_mode;
		if (_tmp12_ == GRANITE_COLLAPSE_MODE_LAST) {
			gint _tmp13_;
			gint _tmp14_;
			g_object_get ((GtkPaned*) self, "max-position", &_tmp13_, NULL);
			_tmp14_ = _tmp13_;
			requested_position = _tmp14_ - requested_position;
		}
		gtk_paned_set_position ((GtkPaned*) self, requested_position);
		result = TRUE;
		return result;
	}
	self->priv->last_click_time = (guint) event->time;
	result = FALSE;
	return result;
}

static gboolean
_granite_widgets_collapsible_paned_detect_toggle_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                GdkEventButton* event,
                                                                                gpointer self)
{
	gboolean result;
	result = granite_widgets_collapsible_paned_detect_toggle ((GraniteWidgetsCollapsiblePaned*) self, event);
	return result;
}

static GObject *
granite_widgets_collapsible_paned_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GraniteWidgetsCollapsiblePaned * self;
	parent_class = G_OBJECT_CLASS (granite_widgets_collapsible_paned_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_COLLAPSIBLE_PANED, GraniteWidgetsCollapsiblePaned);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _granite_widgets_collapsible_paned_detect_toggle_gtk_widget_button_press_event, self, 0);
	return obj;
}

static void
granite_widgets_collapsible_paned_class_init (GraniteWidgetsCollapsiblePanedClass * klass,
                                              gpointer klass_data)
{
	granite_widgets_collapsible_paned_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteWidgetsCollapsiblePaned_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_widgets_collapsible_paned_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_widgets_collapsible_paned_set_property;
	G_OBJECT_CLASS (klass)->constructor = granite_widgets_collapsible_paned_constructor;
	G_OBJECT_CLASS (klass)->finalize = granite_widgets_collapsible_paned_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_WIDGETS_COLLAPSIBLE_PANED_COLLAPSE_MODE_PROPERTY, granite_widgets_collapsible_paned_properties[GRANITE_WIDGETS_COLLAPSIBLE_PANED_COLLAPSE_MODE_PROPERTY] = g_param_spec_enum ("collapse-mode", "collapse-mode", "collapse-mode", GRANITE_TYPE_COLLAPSE_MODE, GRANITE_COLLAPSE_MODE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
granite_widgets_collapsible_paned_instance_init (GraniteWidgetsCollapsiblePaned * self,
                                                 gpointer klass)
{
	self->priv = granite_widgets_collapsible_paned_get_instance_private (self);
	self->priv->_collapse_mode = GRANITE_COLLAPSE_MODE_NONE;
	self->priv->saved_state = 10;
	self->priv->last_click_time = (guint) 0;
}

static void
granite_widgets_collapsible_paned_finalize (GObject * obj)
{
	GraniteWidgetsCollapsiblePaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_WIDGETS_TYPE_COLLAPSIBLE_PANED, GraniteWidgetsCollapsiblePaned);
	G_OBJECT_CLASS (granite_widgets_collapsible_paned_parent_class)->finalize (obj);
}

/**
     * A paned that can be easily collapsed by double-clicking over the pane separator.
     * If it was previously collapsed, it is expanded, and vice-versa.
     */
static GType
granite_widgets_collapsible_paned_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteWidgetsCollapsiblePanedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_widgets_collapsible_paned_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteWidgetsCollapsiblePaned), 0, (GInstanceInitFunc) granite_widgets_collapsible_paned_instance_init, NULL };
	GType granite_widgets_collapsible_paned_type_id;
	granite_widgets_collapsible_paned_type_id = g_type_register_static (gtk_paned_get_type (), "GraniteWidgetsCollapsiblePaned", &g_define_type_info, 0);
	GraniteWidgetsCollapsiblePaned_private_offset = g_type_add_instance_private (granite_widgets_collapsible_paned_type_id, sizeof (GraniteWidgetsCollapsiblePanedPrivate));
	return granite_widgets_collapsible_paned_type_id;
}

GType
granite_widgets_collapsible_paned_get_type (void)
{
	static volatile gsize granite_widgets_collapsible_paned_type_id__once = 0;
	if (g_once_init_enter (&granite_widgets_collapsible_paned_type_id__once)) {
		GType granite_widgets_collapsible_paned_type_id;
		granite_widgets_collapsible_paned_type_id = granite_widgets_collapsible_paned_get_type_once ();
		g_once_init_leave (&granite_widgets_collapsible_paned_type_id__once, granite_widgets_collapsible_paned_type_id);
	}
	return granite_widgets_collapsible_paned_type_id__once;
}

static void
_vala_granite_widgets_collapsible_paned_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec)
{
	GraniteWidgetsCollapsiblePaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_COLLAPSIBLE_PANED, GraniteWidgetsCollapsiblePaned);
	switch (property_id) {
		case GRANITE_WIDGETS_COLLAPSIBLE_PANED_COLLAPSE_MODE_PROPERTY:
		g_value_set_enum (value, granite_widgets_collapsible_paned_get_collapse_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_widgets_collapsible_paned_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec)
{
	GraniteWidgetsCollapsiblePaned * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_WIDGETS_TYPE_COLLAPSIBLE_PANED, GraniteWidgetsCollapsiblePaned);
	switch (property_id) {
		case GRANITE_WIDGETS_COLLAPSIBLE_PANED_COLLAPSE_MODE_PROPERTY:
		granite_widgets_collapsible_paned_set_collapse_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

