package forbidigo

// Code generated by github.com/launchdarkly/go-options.  DO NOT EDIT.

import "fmt"

import "github.com/google/go-cmp/cmp"

type ApplyOptionFunc func(c *config) error

func (f ApplyOptionFunc) apply(c *config) error {
	return f(c)
}

func newConfig(options ...Option) (config, error) {
	var c config
	err := applyConfigOptions(&c, options...)
	return c, err
}

func applyConfigOptions(c *config, options ...Option) error {
	c.ExcludeGodocExamples = true
	for _, o := range options {
		if err := o.apply(c); err != nil {
			return err
		}
	}
	return nil
}

type Option interface {
	apply(*config) error
}

type optionExcludeGodocExamplesImpl struct {
	o bool
}

func (o optionExcludeGodocExamplesImpl) apply(c *config) error {
	c.ExcludeGodocExamples = o.o
	return nil
}

func (o optionExcludeGodocExamplesImpl) Equal(v optionExcludeGodocExamplesImpl) bool {
	switch {
	case !cmp.Equal(o.o, v.o):
		return false
	}
	return true
}

func (o optionExcludeGodocExamplesImpl) String() string {
	name := "OptionExcludeGodocExamples"

	// hack to avoid go vet error about passing a function to Sprintf
	var value interface{} = o.o
	return fmt.Sprintf("%s: %+v", name, value)
}

// OptionExcludeGodocExamples don't check inside Godoc examples (see https://blog.golang.org/examples)
func OptionExcludeGodocExamples(o bool) Option {
	return optionExcludeGodocExamplesImpl{
		o: o,
	}
}

type optionIgnorePermitDirectivesImpl struct {
	o bool
}

func (o optionIgnorePermitDirectivesImpl) apply(c *config) error {
	c.IgnorePermitDirectives = o.o
	return nil
}

func (o optionIgnorePermitDirectivesImpl) Equal(v optionIgnorePermitDirectivesImpl) bool {
	switch {
	case !cmp.Equal(o.o, v.o):
		return false
	}
	return true
}

func (o optionIgnorePermitDirectivesImpl) String() string {
	name := "OptionIgnorePermitDirectives"

	// hack to avoid go vet error about passing a function to Sprintf
	var value interface{} = o.o
	return fmt.Sprintf("%s: %+v", name, value)
}

// OptionIgnorePermitDirectives don't check for `permit` directives(for example, in favor of `nolint`)
func OptionIgnorePermitDirectives(o bool) Option {
	return optionIgnorePermitDirectivesImpl{
		o: o,
	}
}

type optionAnalyzeTypesImpl struct {
	o bool
}

func (o optionAnalyzeTypesImpl) apply(c *config) error {
	c.AnalyzeTypes = o.o
	return nil
}

func (o optionAnalyzeTypesImpl) Equal(v optionAnalyzeTypesImpl) bool {
	switch {
	case !cmp.Equal(o.o, v.o):
		return false
	}
	return true
}

func (o optionAnalyzeTypesImpl) String() string {
	name := "OptionAnalyzeTypes"

	// hack to avoid go vet error about passing a function to Sprintf
	var value interface{} = o.o
	return fmt.Sprintf("%s: %+v", name, value)
}

// OptionAnalyzeTypes enable to match canonical names for types and interfaces using type info
func OptionAnalyzeTypes(o bool) Option {
	return optionAnalyzeTypesImpl{
		o: o,
	}
}
