/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, iio, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_iio_attr_source = R"doc(Generic reader for attributes of IIO devices.

This block allow for reading of any IIO attribute that is readable. This includes channel, device, device buffer, device debug, and direct register attributes.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::attr_source.

Args:
    uri : String of the context uri
    device : String of device name
    channel : String of device name
    attribute : String of attribute name
    update_interval_ms : Integer number of milliseconds between attribute reads
    samples_per_update : Integer number of samples to collect before block returns
    data_type : Enum which selects what data type to output for received data: 0: double 1: float 2: long long 3: int 4: uint8
    attr_type : Enum determining attribute type: 0: Channel attribute 1: Device attribute 2: Device debug attribute
    output : Boolean when True if channel attribute is an output
    address : uint32 register address of register to be read)doc";

static const char* __doc_gr_iio_attr_source_make = R"doc(Generic reader for attributes of IIO devices.

This block allow for reading of any IIO attribute that is readable. This includes channel, device, device buffer, device debug, and direct register attributes.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of iio::attr_source.

Args:
    uri : String of the context uri
    device : String of device name
    channel : String of device name
    attribute : String of attribute name
    update_interval_ms : Integer number of milliseconds between attribute reads
    samples_per_update : Integer number of samples to collect before block returns
    data_type : Enum which selects what data type to output for received data: 0: double 1: float 2: long long 3: int 4: uint8
    attr_type : Enum determining attribute type: 0: Channel attribute 1: Device attribute 2: Device debug attribute
    output : Boolean when True if channel attribute is an output
    address : uint32 register address of register to be read)doc";
