/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_filter_delay_fc = R"doc(Filter-Delay Combination Block.

The purpose of this block is to compensate the delay that a linear-phase filter introduces.


It does that by introducing a delay of half the length of the FIR tap vector on passed-through samples.


The block takes one or two float stream and outputs a stream composed of pairs of floats. (In GNU Radio, pairs of floats are identical to complex numbers, where the real and imaginary parts are the first and second element, respectively.)


If only one float stream is input, the first element of each output item is a delayed version of this input and the second element is the filtered output.


If two floats are connected to the input, then the first element of each output item is the delayed version of the first input, and the second element is the filtered second input.


The delay in the first elements of the output accounts for the group delay introduced by the filter in the second elements path under the assumption of linear-phase filtering. The filter taps need to be calculated before initializing this block.

Constructor Specific Documentation:

Build a filter with delay block.

Args:
    taps : the vector of real-valued tags. Half of the length of this vector is the delay introduced by this block.)doc";


static const char* __doc_gr_filter_filter_delay_fc_filter_delay_fc = R"doc()doc";


static const char* __doc_gr_filter_filter_delay_fc_make = R"doc(Filter-Delay Combination Block.

The purpose of this block is to compensate the delay that a linear-phase filter introduces.


It does that by introducing a delay of half the length of the FIR tap vector on passed-through samples.


The block takes one or two float stream and outputs a stream composed of pairs of floats. (In GNU Radio, pairs of floats are identical to complex numbers, where the real and imaginary parts are the first and second element, respectively.)


If only one float stream is input, the first element of each output item is a delayed version of this input and the second element is the filtered output.


If two floats are connected to the input, then the first element of each output item is the delayed version of the first input, and the second element is the filtered second input.


The delay in the first elements of the output accounts for the group delay introduced by the filter in the second elements path under the assumption of linear-phase filtering. The filter taps need to be calculated before initializing this block.

Constructor Specific Documentation:

Build a filter with delay block.

Args:
    taps : the vector of real-valued tags. Half of the length of this vector is the delay introduced by this block.)doc";
