/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This is GNU Go, a Go program. Contact gnugo@gnu.org, or see       *
 * http://www.gnu.org/software/gnugo/ for more information.          *
 *                                                                   *
 * Copyright 1999, 2000, 2001, 2002, 2003, 2004, 2005 and 2006       *
 * by the Free Software Foundation.                                  *
 *                                                                   *
 * This program is free software; you can redistribute it and/or     *
 * modify it under the terms of the GNU General Public License as    *
 * published by the Free Software Foundation - version 3             *
 * or (at your option) any later version.                            *
 *                                                                   *
 * This program is distributed in the hope that it will be useful,   *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *
 * GNU General Public License in file COPYING for more details.      *
 *                                                                   *
 * You should have received a copy of the GNU General Public         *
 * License along with this program; if not, write to the Free        *
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,       *
 * Boston, MA 02111, USA.                                            *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h> /* for NULL */
#include "liberty.h"
#include "patterns.h"

struct fullboard_pattern fuseki19[] = {
  {{{0x0}},0,"F-H0-1",900,3977},
  {{{0x0}},0,"F-H0-2",899,1136},
  {{{0x0}},0,"F-H0-3",863,201},
  {{{0x0}},0,"F-H0-4",684,158},
  {{{0x0}},0,"F-H0-5",938,137},
  {{{0x0}},0,"F-H0-6",936,101},
  {{{0x0}},0,"F-H0-7",864,46},
  {{{0x6464808c9b2c92f6}},1,"F-H0-8",468,2591},
  {{{0x776ccd9cbc9f75f6}},1,"F-H0-9",468,1353},
  {{{0x6464808c9b2c92f6}},1,"F-H0-10",455,847},
  {{{0x85c45c93d8c1e826}},1,"F-H0-11",899,429},
  {{{0x6464808c9b2c92f6}},1,"F-H0-12",492,156},
  {{{0x6464808c9b2c92f6}},1,"F-H0-13",913,146},
  {{{0x6464808c9b2c92f6}},1,"F-H0-14",505,143},
  {{{0x6464808c9b2c92f6}},1,"F-H0-15",493,127},
  {{{0x6464808c9b2c92f6}},1,"F-H0-16",432,79},
  {{{0xe9b9224eee5dad9c}},1,"F-H0-17",948,78},
  {{{0x6464808c9b2c92f6}},1,"F-H0-18",939,64},
  {{{0xe9b9224eee5dad9c}},1,"F-H0-19",901,57},
  {{{0x6464808c9b2c92f6}},1,"F-H0-20",418,57},
  {{{0x6464808c9b2c92f6}},1,"F-H0-21",684,51},
  {{{0x6464808c9b2c92f6}},1,"F-H0-22",876,29},
  {{{0x6464808c9b2c92f6}},1,"F-H0-23",504,27},
  {{{0xa97a45135638fbd1}},2,"F-H0-24",913,1505},
  {{{0xa97a45135638fbd1}},2,"F-H0-25",912,1452},
  {{{0xa97a45135638fbd1}},2,"F-H0-26",949,541},
  {{{0xa97a45135638fbd1}},2,"F-H0-27",876,145},
  {{{0xa97a45135638fbd1}},2,"F-H0-28",875,115},
  {{{0xa97a45135638fbd1}},2,"F-H0-29",543,103},
  {{{0xa97a45135638fbd1}},2,"F-H0-30",911,44},
  {{{0x33d2749d11affa49}},2,"F-H0-31",936,36},
  {{{0xa97a45135638fbd1}},2,"F-H0-32",492,32},
  {{{0x33d2749d11affa49}},2,"F-H0-33",684,17},
  {{{0xc71d88e91ceb9bea}},3,"F-H0-34",468,1207},
  {{{0xc4f4108d08f93a1a}},3,"F-H0-35",455,1113},
  {{{0xc71d88e91ceb9bea}},3,"F-H0-36",506,193},
  {{{0x40c3675db865564d}},3,"F-H0-37",875,139},
  {{{0xc4f4108d08f93a1a}},3,"F-H0-38",419,115},
  {{{0xc4f4108d08f93a1a}},3,"F-H0-39",839,52},
  {{{0xc71d88e91ceb9bea}},3,"F-H0-40",432,46},
  {{{0xc4f4108d08f93a1a}},3,"F-H0-41",457,41},
  {{{0xde16888feaa78e27}},3,"F-H0-42",839,17},
  {{{0xc71d88e91ceb9bea}},3,"F-H0-43",943,14},
  {{{0xc4f4108d08f93a1a}},3,"F-H0-44",420,14},
  {{{0x5a21ff5f5a3be270}},3,"F-H0-45",825,14},
  {{{0xc4f4108d08f93a1a}},3,"F-H0-46",825,13},
  {{{0xc5073bce60a4be6b}},2,"F-H0-47",913,893},
  {{{0x5faf0a402733bff3}},2,"F-H0-48",900,860},
  {{{0xc5073bce60a4be6b}},2,"F-H0-49",949,286},
  {{{0x3e457fd3c1177086}},2,"F-H0-50",900,276},
  {{{0x5faf0a402733bff3}},2,"F-H0-51",419,114},
  {{{0x5bd2d41c32666601}},2,"F-H0-52",420,61},
  {{{0x5bd2d41c32666601}},2,"F-H0-53",431,55},
  {{{0xc5073bce60a4be6b}},2,"F-H0-54",875,46},
  {{{0xb0714575a074ee1c}},2,"F-H0-55",911,23},
  {{{0x5bd2d41c32666601}},2,"F-H0-56",432,18},
  {{{0xc5073bce60a4be6b}},2,"F-H0-57",948,18},
  {{{0xc5073bce60a4be6b}},2,"F-H0-58",911,15},
  {{{0x5bd2d41c32666601}},2,"F-H0-59",947,15},
  {{{0x51d1996ae39994cc}},2,"F-H0-60",543,12},
  {{{0xc5073bce60a4be6b}},2,"F-H0-61",950,11},
  {{{0x987ac0fd17344af8}},1,"F-H0-62",468,952},
  {{{0x26209e2762b3f6e3}},1,"F-H0-63",456,671},
  {{{0x987ac0fd17344af8}},1,"F-H0-64",949,296},
  {{{0x987ac0fd17344af8}},1,"F-H0-65",456,209},
  {{{0x26209e2762b3f6e3}},1,"F-H0-66",431,65},
  {{{0xb9ee36ee3af4574f}},1,"F-H0-67",899,56},
  {{{0x26209e2762b3f6e3}},1,"F-H0-68",863,47},
  {{{0x26209e2762b3f6e3}},1,"F-H0-69",492,45},
  {{{0x987ac0fd17344af8}},1,"F-H0-70",911,42},
  {{{0x26209e2762b3f6e3}},1,"F-H0-71",913,34},
  {{{0x987ac0fd17344af8}},1,"F-H0-72",913,34},
  {{{0x26209e2762b3f6e3}},1,"F-H0-73",949,29},
  {{{0x26209e2762b3f6e3}},1,"F-H0-74",826,28},
  {{{0x28cb8bf042771001}},1,"F-H0-75",936,21},
  {{{0x987ac0fd17344af8}},1,"F-H0-76",505,17},
  {{{0x26209e2762b3f6e3}},1,"F-H0-77",505,15},
  {{{0x26209e2762b3f6e3}},1,"F-H0-78",418,15},
  {{{0x987ac0fd17344af8}},1,"F-H0-79",684,14},
  {{{0x26209e2762b3f6e3}},1,"F-H0-80",862,13},
  {{{0x26209e2762b3f6e3}},1,"F-H0-81",457,12},
  {{{0x26209e2762b3f6e3}},1,"F-H0-82",950,11},
  {{{0xbe97c927e3433c81}},3,"F-H0-83",456,1087},
  {{{0xbe97c927e3433c81}},3,"F-H0-84",455,461},
  {{{0xf861e7fda7752d14}},3,"F-H0-85",875,129},
  {{{0xbe97c927e3433c81}},3,"F-H0-86",492,114},
  {{{0xbe97c927e3433c81}},3,"F-H0-87",419,72},
  {{{0xbe97c927e3433c81}},3,"F-H0-88",493,71},
  {{{0xbe97c927e3433c81}},3,"F-H0-89",910,43},
  {{{0xbe97c927e3433c81}},3,"F-H0-90",418,37},
  {{{0xbe97c927e3433c81}},3,"F-H0-91",948,29},
  {{{0xbe97c927e3433c81}},3,"F-H0-92",457,22},
  {{{0x5d09045f18db9fa}},3,"F-H0-93",876,12},
  {{{0x49d47f4cd125d571}},4,"F-H0-94",543,793},
  {{{0x49d47f4cd125d571}},4,"F-H0-95",944,283},
  {{{0x49d47f4cd125d571}},4,"F-H0-96",907,267},
  {{{0xde8b4177fde1536e}},4,"F-H0-97",939,190},
  {{{0x8e3638f6f0b333e9}},4,"F-H0-98",876,100},
  {{{0xde8b4177fde1536e}},4,"F-H0-99",677,34},
  {{{0x49d47f4cd125d571}},4,"F-H0-100",690,33},
  {{{0x49d47f4cd125d571}},4,"F-H0-101",429,25},
  {{{0x49d47f4cd125d571}},4,"F-H0-102",421,18},
  {{{0x49d47f4cd125d571}},4,"F-H0-103",911,12},
  {{{0x8a828ad776fd246d}},4,"F-H0-104",529,10},
  {{{0x9aa8318e47970198}},4,"F-H0-105",543,755},
  {{{0x804aa98ca5c9b5a5}},4,"F-H0-106",690,461},
  {{{0x9aa8318e47970198}},4,"F-H0-107",429,49},
  {{{0x10e1d57433a146f0}},4,"F-H0-108",943,35},
  {{{0x9aa8318e47970198}},4,"F-H0-109",684,24},
  {{{0x9aa8318e47970198}},4,"F-H0-110",678,12},
  {{{0x804aa98ca5c9b5a5}},4,"F-H0-111",458,12},
  {{{0x9aa8318e47970198}},4,"F-H0-112",943,12},
  {{{0x9aa8318e47970198}},4,"F-H0-113",462,10},
  {{{0x9aa8318e47970198}},4,"F-H0-114",691,9},
  {{{0xa46472fdc62de63f}},2,"F-H0-115",912,640},
  {{{0xdaf349ab786fae77}},2,"F-H0-116",455,544},
  {{{0x7da5bb6e7fb4c532}},2,"F-H0-117",468,358},
  {{{0xf2a0dd23bd8547d4}},2,"F-H0-118",937,169},
  {{{0x7da5bb6e7fb4c532}},2,"F-H0-119",469,99},
  {{{0x7da5bb6e7fb4c532}},2,"F-H0-120",431,79},
  {{{0x4c6f05042c6c3612}},2,"F-H0-121",901,57},
  {{{0xa46472fdc62de63f}},2,"F-H0-122",876,32},
  {{{0xa46472fdc62de63f}},2,"F-H0-123",875,30},
  {{{0xa46472fdc62de63f}},2,"F-H0-124",467,20},
  {{{0x7da5bb6e7fb4c532}},2,"F-H0-125",838,16},
  {{{0xa46472fdc62de63f}},2,"F-H0-126",420,11},
  {{{0x6dfbf31701ac2ba5}},2,"F-H0-127",863,11},
  {{{0xa46472fdc62de63f}},2,"F-H0-128",430,11},
  {{{0xa46472fdc62de63f}},2,"F-H0-129",950,10},
  {{{0xa46472fdc62de63f}},2,"F-H0-130",432,9},
  {{{0xa46472fdc62de63f}},2,"F-H0-131",948,9},
  {{{0xc20eb7275c56d1b0}},4,"F-H0-132",863,602},
  {{{0x37a7e6eddd21f9bf}},4,"F-H0-133",906,345},
  {{{0xfbcb78bde11e59cc}},4,"F-H0-134",543,259},
  {{{0x2c7422049c2d51fe}},4,"F-H0-135",876,84},
  {{{0xfbcb78bde11e59cc}},4,"F-H0-136",458,59},
  {{{0xfbcb78bde11e59cc}},4,"F-H0-137",421,51},
  {{{0xdfbbc6960e7fee2f}},4,"F-H0-138",825,21},
  {{{0x2c7422049c2d51fe}},4,"F-H0-139",684,21},
  {{{0x2c7422049c2d51fe}},4,"F-H0-140",691,14},
  {{{0xc20eb7275c56d1b0}},4,"F-H0-141",691,11},
  {{{0xfbcb78bde11e59cc}},4,"F-H0-142",690,10},
  {{{0xfbcb78bde11e59cc}},4,"F-H0-143",678,9},
  {{{0x37a7e6eddd21f9bf}},4,"F-H0-144",691,8},
  {{{0xcd686213c31143a7}},2,"F-H0-145",949,366},
  {{{0x79fd13b184d3eecb}},2,"F-H0-146",912,113},
  {{{0xa7601aca46fb2fd4}},2,"F-H0-147",913,112},
  {{{0xa7601aca46fb2fd4}},2,"F-H0-148",949,106},
  {{{0xe0ae3a5f871d2ea0}},2,"F-H0-149",900,89},
  {{{0xcd686213c31143a7}},2,"F-H0-150",492,20},
  {{{0x79fd13b184d3eecb}},2,"F-H0-151",950,15},
  {{{0x79fd13b184d3eecb}},2,"F-H0-152",876,11},
  {{{0x79fd13b184d3eecb}},2,"F-H0-153",429,10},
  {{{0x79fd13b184d3eecb}},2,"F-H0-154",457,9},
  {{{0x3daee5e744d57c05}},2,"F-H0-155",432,8},
  {{{0xa7601aca46fb2fd4}},2,"F-H0-156",948,7},
  {{{0x1eb986e09fda8b23}},2,"F-H0-157",420,6},
  {{{0x79fd13b184d3eecb}},2,"F-H0-158",911,6},
  {{{0x79fd13b184d3eecb}},2,"F-H0-159",543,5},
  {{{0x79fd13b184d3eecb}},2,"F-H0-160",949,5},
  {{{0xa7601aca46fb2fd4}},2,"F-H0-161",911,5},
  {{{0x79fd13b184d3eecb}},2,"F-H0-162",948,4},
  {{{0x884e2f062441074}},5,"F-H0-163",429,335},
  {{{0xa627d007a384ae0c}},5,"F-H0-164",941,230},
  {{{0x884e2f062441074}},5,"F-H0-165",466,158},
  {{{0x88c1fc6d9a947226}},5,"F-H0-166",907,147},
  {{{0x88c1fc6d9a947226}},5,"F-H0-167",906,58},
  {{{0xa627d007a384ae0c}},5,"F-H0-168",942,26},
  {{{0xa627d007a384ae0c}},5,"F-H0-169",902,21},
  {{{0x884e2f062441074}},5,"F-H0-170",825,19},
  {{{0x3ef64baac60105f7}},5,"F-H0-171",946,17},
  {{{0x884e2f062441074}},5,"F-H0-172",616,15},
  {{{0x88c1fc6d9a947226}},5,"F-H0-173",943,12},
  {{{0x88c1fc6d9a947226}},5,"F-H0-174",690,12},
  {{{0xa627d007a384ae0c}},5,"F-H0-175",947,9},
  {{{0x4d13d4d4f2456c67}},5,"F-H0-176",939,8},
  {{{0x884e2f062441074}},5,"F-H0-177",939,6},
  {{{0x884e2f062441074}},5,"F-H0-178",541,5},
  {{{0xc83afaaca7f89db5}},5,"F-H0-179",677,4},
  {{{0xbd7e5143f7519d71}},3,"F-H0-180",468,584},
  {{{0xbd7e5143f7519d71}},3,"F-H0-181",469,106},
  {{{0xbd7e5143f7519d71}},3,"F-H0-182",431,102},
  {{{0xbd7e5143f7519d71}},3,"F-H0-183",911,93},
  {{{0xbd7e5143f7519d71}},3,"F-H0-184",506,56},
  {{{0xbd7e5143f7519d71}},3,"F-H0-185",505,52},
  {{{0xbd7e5143f7519d71}},3,"F-H0-186",910,20},
  {{{0xbd7e5143f7519d71}},3,"F-H0-187",432,19},
  {{{0xbd7e5143f7519d71}},3,"F-H0-188",948,14},
  {{{0x38ea50fc84e1e214}},3,"F-H0-189",457,11},
  {{{0xca3b8412d44209}},3,"F-H0-190",862,7},
  {{{0xd775613d6fe74a3b}},3,"F-H0-191",543,7},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-192",429,297},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-193",617,169},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-194",911,167},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-195",653,165},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-196",466,161},
  {{{0x97cb95b60c4ec63f}},5,"F-H0-197",462,68},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-198",910,31},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-199",948,18},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-200",542,16},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-201",616,13},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-202",691,13},
  {{{0x72e73b5a89fe16ef}},5,"F-H0-203",462,12},
  {{{0x97cb95b60c4ec63f}},5,"F-H0-204",939,11},
  {{{0x1e3eeb519cf570f3}},5,"F-H0-205",566,10},
  {{{0x8050bf75ee560d3f}},5,"F-H0-206",942,9},
  {{{0xe2837fff452b9929}},3,"F-H0-207",456,449},
  {{{0xe2837fff452b9929}},3,"F-H0-208",455,268},
  {{{0xe2837fff452b9929}},3,"F-H0-209",875,137},
  {{{0xe2837fff452b9929}},3,"F-H0-210",876,62},
  {{{0x8bb28395c5b0191d}},3,"F-H0-211",938,32},
  {{{0xe2837fff452b9929}},3,"F-H0-212",838,30},
  {{{0xe2837fff452b9929}},3,"F-H0-213",493,24},
  {{{0x85599642e574ffff}},3,"F-H0-214",431,16},
  {{{0xe2837fff452b9929}},3,"F-H0-215",418,10},
  {{{0xe2837fff452b9929}},3,"F-H0-216",457,8},
  {{{0x59ca656bdff9eef3}},3,"F-H0-217",431,251},
  {{{0x7add066c04f619d5}},3,"F-H0-218",468,224},
  {{{0x59ca656bdff9eef3}},3,"F-H0-219",469,86},
  {{{0x59ca656bdff9eef3}},3,"F-H0-220",430,80},
  {{{0x7add066c04f619d5}},3,"F-H0-221",505,32},
  {{{0x7add066c04f619d5}},3,"F-H0-222",432,26},
  {{{0x7add066c04f619d5}},3,"F-H0-223",430,22},
  {{{0x59ca656bdff9eef3}},3,"F-H0-224",939,12},
  {{{0x656a66cc5fdcc686}},3,"F-H0-225",901,11},
  {{{0x7add066c04f619d5}},3,"F-H0-226",839,10},
  {{{0x7add066c04f619d5}},3,"F-H0-227",943,7},
  {{{0x59ca656bdff9eef3}},3,"F-H0-228",825,5},
  {{{0xba04af8f7f8e3651}},3,"F-H0-229",939,3},
  {{{0xcff564ce0cacddd5}},5,"F-H0-230",908,271},
  {{{0xdb60db41bdc2f71f}},5,"F-H0-231",506,263},
  {{{0x8c4ac698bef2a394}},5,"F-H0-232",788,120},
  {{{0x6dc502188b8ae98b}},5,"F-H0-233",530,83},
  {{{0x95803e629ffc18f5}},5,"F-H0-234",874,35},
  {{{0x6dc502188b8ae98b}},5,"F-H0-235",459,26},
  {{{0x6dc502188b8ae98b}},5,"F-H0-236",825,16},
  {{{0x6dc502188b8ae98b}},5,"F-H0-237",529,14},
  {{{0x3840563b94a86352}},5,"F-H0-238",463,13},
  {{{0xcff564ce0cacddd5}},5,"F-H0-239",529,12},
  {{{0x6dc502188b8ae98b}},5,"F-H0-240",567,10},
  {{{0xcff564ce0cacddd5}},5,"F-H0-241",429,8},
  {{{0x8c4ac698bef2a394}},5,"F-H0-242",900,4},
  {{{0x6dc502188b8ae98b}},5,"F-H0-243",947,4},
  {{{0x6dc502188b8ae98b}},5,"F-H0-244",566,3},
  {{{0x6dc502188b8ae98b}},5,"F-H0-245",424,3},
  {{{0x15806d6cb24fab71}},2,"F-H0-246",913,355},
  {{{0x15806d6cb24fab71}},2,"F-H0-247",431,100},
  {{{0x15806d6cb24fab71}},2,"F-H0-248",912,92},
  {{{0xec1117effb8416f3}},2,"F-H0-249",912,41},
  {{{0x15806d6cb24fab71}},2,"F-H0-250",529,26},
  {{{0x15806d6cb24fab71}},2,"F-H0-251",469,19},
  {{{0x15806d6cb24fab71}},2,"F-H0-252",432,12},
  {{{0x15806d6cb24fab71}},2,"F-H0-253",862,10},
  {{{0x40b5c0d1b6607ccd}},2,"F-H0-254",862,7},
  {{{0x15806d6cb24fab71}},2,"F-H0-255",949,6},
  {{{0x15806d6cb24fab71}},2,"F-H0-256",950,6},
  {{{0x15806d6cb24fab71}},2,"F-H0-257",911,6},
  {{{0x15806d6cb24fab71}},2,"F-H0-258",876,6},
  {{{0x15806d6cb24fab71}},2,"F-H0-259",825,5},
  {{{0x55c88bc522a5b204}},2,"F-H0-260",505,5},
  {{{0x55c88bc522a5b204}},2,"F-H0-261",457,5},
  {{{0x28b7367f77ac8d25}},4,"F-H0-262",543,283},
  {{{0x28b7367f77ac8d25}},4,"F-H0-263",457,182},
  {{{0x28b7367f77ac8d25}},4,"F-H0-264",907,115},
  {{{0xd1c757ec5b056863}},4,"F-H0-265",728,112},
  {{{0x28b7367f77ac8d25}},4,"F-H0-266",420,34},
  {{{0xacf5e5a53b2f875e}},4,"F-H0-267",492,30},
  {{{0xacf5e5a53b2f875e}},4,"F-H0-268",839,18},
  {{{0x28b7367f77ac8d25}},4,"F-H0-269",690,12},
  {{{0xd742825bc006c254}},4,"F-H0-270",910,12},
  {{{0x28b7367f77ac8d25}},4,"F-H0-271",911,5},
  {{{0x39bdb934cde22dba}},4,"F-H0-272",906,4},
  {{{0x39bdb934cde22dba}},4,"F-H0-273",690,4},
  {{{0xe6ae71a9e12158be}},4,"F-H0-274",465,4},
  {{{0x33662001f09d99b5}},5,"F-H0-275",947,510},
  {{{0xc1a2e0c09058beb5}},5,"F-H0-276",462,76},
  {{{0xc1a2e0c09058beb5}},5,"F-H0-277",678,43},
  {{{0x33662001f09d99b5}},5,"F-H0-278",684,18},
  {{{0xc1a2e0c09058beb5}},5,"F-H0-279",838,10},
  {{{0x94d4a0f412ed87d4}},4,"F-H0-280",543,286},
  {{{0x94d4a0f412ed87d4}},4,"F-H0-281",876,154},
  {{{0x4a2f672c957c1482}},4,"F-H0-282",825,45},
  {{{0xb7c3c3f3c9e270f2}},4,"F-H0-283",424,18},
  {{{0x4a2f672c957c1482}},4,"F-H0-284",863,15},
  {{{0x4a2f672c957c1482}},4,"F-H0-285",543,12},
  {{{0x4a2f672c957c1482}},4,"F-H0-286",906,4},
  {{{0x5336e74e337b614c}},4,"F-H0-287",942,3},
  {{{0xfcd3d78c1adc5894}},3,"F-H0-288",456,343},
  {{{0xfcd3d78c1adc5894}},3,"F-H0-289",455,174},
  {{{0xf9ced0347d9561f4}},3,"F-H0-290",901,61},
  {{{0xf9ced0347d9561f4}},3,"F-H0-291",948,19},
  {{{0x556e309e3dc3d533}},3,"F-H0-292",875,19},
  {{{0xf9ced0347d9561f4}},3,"F-H0-293",911,16},
  {{{0xfcd3d78c1adc5894}},3,"F-H0-294",826,14},
  {{{0x7491a389d59554fe}},3,"F-H0-295",432,12},
  {{{0xfcd3d78c1adc5894}},3,"F-H0-296",862,10},
  {{{0xfcd3d78c1adc5894}},3,"F-H0-297",419,9},
  {{{0xfcd3d78c1adc5894}},3,"F-H0-298",948,4},
  {{{0x995329ee03cec06b}},4,"F-H0-299",862,225},
  {{{0x995329ee03cec06b}},4,"F-H0-300",529,162},
  {{{0x995329ee03cec06b}},4,"F-H0-301",825,52},
  {{{0x674495511b0965e8}},4,"F-H0-302",947,40},
  {{{0x995329ee03cec06b}},4,"F-H0-303",863,21},
  {{{0x995329ee03cec06b}},4,"F-H0-304",714,12},
  {{{0xee90add7e3d49c1b}},4,"F-H0-305",939,11},
  {{{0xf3e0b30a73942204}},4,"F-H0-306",943,7},
  {{{0x9aceff2d022e53d1}},4,"F-H0-307",421,6},
  {{{0x995329ee03cec06b}},4,"F-H0-308",826,5},
  {{{0x995329ee03cec06b}},4,"F-H0-309",677,5},
  {{{0x995329ee03cec06b}},4,"F-H0-310",462,3},
  {{{0x4f869d60387e97e2}},2,"F-H0-311",912,243},
  {{{0x95502f6eb40d44b8}},2,"F-H0-312",913,203},
  {{{0x4759270cc8e03f6}},2,"F-H0-313",912,127},
  {{{0x4759270cc8e03f6}},2,"F-H0-314",913,64},
  {{{0x4759270cc8e03f6}},2,"F-H0-315",455,49},
  {{{0x4759270cc8e03f6}},2,"F-H0-316",949,31},
  {{{0x4759270cc8e03f6}},2,"F-H0-317",467,24},
  {{{0x95502f6eb40d44b8}},2,"F-H0-318",875,16},
  {{{0x4759270cc8e03f6}},2,"F-H0-319",420,15},
  {{{0x4759270cc8e03f6}},2,"F-H0-320",430,5},
  {{{0x95502f6eb40d44b8}},2,"F-H0-321",948,4},
  {{{0x4759270cc8e03f6}},2,"F-H0-322",876,4},
  {{{0x6c231b87ba19a1c3}},2,"F-H0-323",467,4},
  {{{0x4759270cc8e03f6}},2,"F-H0-324",466,3},
  {{{0x95502f6eb40d44b8}},2,"F-H0-325",684,3},
  {{{0xa3264e206df86841}},6,"F-H0-326",765,199},
  {{{0x44b7464753119ed1}},6,"F-H0-327",902,76},
  {{{0xa3264e206df86841}},6,"F-H0-328",678,57},
  {{{0x858ef8c0d1d7d9db}},6,"F-H0-329",910,32},
  {{{0xa3264e206df86841}},6,"F-H0-330",727,25},
  {{{0x44b7464753119ed1}},6,"F-H0-331",864,25},
  {{{0x6ea4430a44645daa}},6,"F-H0-332",906,16},
  {{{0x44b7464753119ed1}},6,"F-H0-333",827,16},
  {{{0xa3264e206df86841}},6,"F-H0-334",529,8},
  {{{0xa3264e206df86841}},6,"F-H0-335",947,6},
  {{{0x44b7464753119ed1}},6,"F-H0-336",714,4},
  {{{0x6ea4430a44645daa}},6,"F-H0-337",904,4},
  {{{0xff3a4fe80ecef964}},3,"F-H0-338",468,348},
  {{{0xff3a4fe80ecef964}},3,"F-H0-339",863,88},
  {{{0xff3a4fe80ecef964}},3,"F-H0-340",862,88},
  {{{0xff3a4fe80ecef964}},3,"F-H0-341",469,76},
  {{{0x1e9d3f8ec9334127}},3,"F-H0-342",838,24},
  {{{0xb23ddf248965f5e0}},3,"F-H0-343",949,15},
  {{{0xff3a4fe80ecef964}},3,"F-H0-344",911,13},
  {{{0xff3a4fe80ecef964}},3,"F-H0-345",506,12},
  {{{0xf459db7aad2deb3b}},3,"F-H0-346",432,11},
  {{{0xff3a4fe80ecef964}},3,"F-H0-347",505,10},
  {{{0xf459db7aad2deb3b}},3,"F-H0-348",505,4},
  {{{0xbf525fc2e72fb2fe}},5,"F-H0-349",839,321},
  {{{0x7c626e4588453c8a}},5,"F-H0-350",839,143},
  {{{0x7c626e4588453c8a}},5,"F-H0-351",461,30},
  {{{0x7c626e4588453c8a}},5,"F-H0-352",678,26},
  {{{0x8466dc6fd2d66f40}},5,"F-H0-353",728,11},
  {{{0xe3e176a322768caf}},5,"F-H0-354",862,10},
  {{{0x7c626e4588453c8a}},5,"F-H0-355",690,9},
  {{{0xbf525fc2e72fb2fe}},5,"F-H0-356",467,6},
  {{{0x7c626e4588453c8a}},5,"F-H0-357",728,4},
  {{{0x7c626e4588453c8a}},5,"F-H0-358",715,4},
  {{{0x4092ffff9559ed2}},3,"F-H0-359",900,134},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-360",431,107},
  {{{0x4092ffff9559ed2}},3,"F-H0-361",899,104},
  {{{0x63b0a71744fb579}},3,"F-H0-362",430,47},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-363",911,37},
  {{{0x63b0a71744fb579}},3,"F-H0-364",432,28},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-365",505,19},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-366",430,15},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-367",948,14},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-368",825,8},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-369",467,5},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-370",910,5},
  {{{0x461aeffef396ee5f}},3,"F-H0-371",943,2},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-372",947,2},
  {{{0xbedfc6ef4c1f4e}},3,"F-H0-373",420,2},
  {{{0x86b00e26f1665e0f}},3,"F-H0-374",456,284},
  {{{0x86b00e26f1665e0f}},3,"F-H0-375",455,162},
  {{{0x86b00e26f1665e0f}},3,"F-H0-376",863,63},
  {{{0x36d5bd222c0a30eb}},3,"F-H0-377",430,22},
  {{{0xa63fbf2ed6233a7e}},3,"F-H0-378",902,16},
  {{{0x36d5bd222c0a30eb}},3,"F-H0-379",467,15},
  {{{0xe16ae79b513938d9}},3,"F-H0-380",876,9},
  {{{0xe16ae79b513938d9}},3,"F-H0-381",431,8},
  {{{0xe16ae79b513938d9}},3,"F-H0-382",432,6},
  {{{0xe16ae79b513938d9}},3,"F-H0-383",467,6},
  {{{0x86b00e26f1665e0f}},3,"F-H0-384",947,3},
  {{{0xe16ae79b513938d9}},3,"F-H0-385",430,3},
  {{{0x56cedd4cbde64443}},1,"F-H0-386",468,201},
  {{{0x73ef5a30f0eb6af9}},1,"F-H0-387",456,93},
  {{{0x56cedd4cbde64443}},1,"F-H0-388",456,44},
  {{{0x56cedd4cbde64443}},1,"F-H0-389",455,30},
  {{{0x56cedd4cbde64443}},1,"F-H0-390",949,28},
  {{{0x56cedd4cbde64443}},1,"F-H0-391",937,15},
  {{{0x73ef5a30f0eb6af9}},1,"F-H0-392",492,15},
  {{{0x56cedd4cbde64443}},1,"F-H0-393",505,11},
  {{{0x56cedd4cbde64443}},1,"F-H0-394",492,10},
  {{{0x56cedd4cbde64443}},1,"F-H0-395",493,8},
  {{{0x56513c4dd07e29e9}},1,"F-H0-396",899,7},
  {{{0x86211b82dd8908a4}},1,"F-H0-397",505,6},
  {{{0x73ef5a30f0eb6af9}},1,"F-H0-398",431,5},
  {{{0x56cedd4cbde64443}},1,"F-H0-399",684,5},
  {{{0x56cedd4cbde64443}},1,"F-H0-400",913,5},
  {{{0x73ef5a30f0eb6af9}},1,"F-H0-401",430,4},
  {{{0x73ef5a30f0eb6af9}},1,"F-H0-402",862,4},
  {{{0x73ef5a30f0eb6af9}},1,"F-H0-403",900,3},
  {{{0x73ef5a30f0eb6af9}},1,"F-H0-404",505,3},
  {{{0x35b71bb6e965ab49}},3,"F-H0-405",456,122},
  {{{0x8875976360a88405}},3,"F-H0-406",913,101},
  {{{0x35b71bb6e965ab49}},3,"F-H0-407",455,58},
  {{{0x35b71bb6e965ab49}},3,"F-H0-408",418,43},
  {{{0x8875976360a88405}},3,"F-H0-409",876,28},
  {{{0x8875976360a88405}},3,"F-H0-410",948,20},
  {{{0x8875976360a88405}},3,"F-H0-411",911,16},
  {{{0x35b71bb6e965ab49}},3,"F-H0-412",543,13},
  {{{0x35b71bb6e965ab49}},3,"F-H0-413",457,11},
  {{{0xbc71a98bccf81f98}},3,"F-H0-414",529,6},
  {{{0x8875976360a88405}},3,"F-H0-415",421,3},
  {{{0x35b71bb6e965ab49}},3,"F-H0-416",542,2},
  {{{0xb5446c757a59924b}},5,"F-H0-417",429,163},
  {{{0xd6001496c2bc94ed}},5,"F-H0-418",945,80},
  {{{0xb5446c757a59924b}},5,"F-H0-419",466,65},
  {{{0xb5446c757a59924b}},5,"F-H0-420",653,64},
  {{{0xf293d78eac2bda80}},5,"F-H0-421",462,30},
  {{{0x26a617a6048678ac}},5,"F-H0-422",943,9},
  {{{0xa1b0d0f6e5a278e}},5,"F-H0-423",826,9},
  {{{0xd6001496c2bc94ed}},5,"F-H0-424",802,9},
  {{{0xb5446c757a59924b}},5,"F-H0-425",654,9},
  {{{0xb5446c757a59924b}},5,"F-H0-426",947,5},
  {{{0xb5446c757a59924b}},5,"F-H0-427",825,4},
  {{{0xb5446c757a59924b}},5,"F-H0-428",616,4},
  {{{0xb5446c757a59924b}},5,"F-H0-429",839,3},
  {{{0xb5446c757a59924b}},5,"F-H0-430",728,3},
  {{{0x26a617a6048678ac}},5,"F-H0-431",691,2},
  {{{0x73406574700c475f}},6,"F-H0-432",690,190},
  {{{0xc628687fcbab730a}},6,"F-H0-433",454,157},
  {{{0x73406574700c475f}},6,"F-H0-434",529,24},
  {{{0xa30d057ed726795}},6,"F-H0-435",461,16},
  {{{0x73406574700c475f}},6,"F-H0-436",691,11},
  {{{0xc628687fcbab730a}},6,"F-H0-437",714,10},
  {{{0x4713ee9c7b7ca3fc}},6,"F-H0-438",873,7},
  {{{0x73406574700c475f}},6,"F-H0-439",906,5},
  {{{0x73406574700c475f}},6,"F-H0-440",802,5},
  {{{0x73406574700c475f}},6,"F-H0-441",654,4},
  {{{0x1a12b053d26715be}},6,"F-H0-442",751,2},
  {{{0x73406574700c475f}},6,"F-H0-443",465,2},
  {{{0x44e39769c2979754}},5,"F-H0-444",947,139},
  {{{0x96ef2cbc463462f9}},5,"F-H0-445",801,135},
  {{{0xa245d8aa8218c9a8}},5,"F-H0-446",462,54},
  {{{0x96ef2cbc463462f9}},5,"F-H0-447",462,34},
  {{{0x96ef2cbc463462f9}},5,"F-H0-448",764,25},
  {{{0xa245d8aa8218c9a8}},5,"F-H0-449",425,16},
  {{{0x6e86050dc6c04a95}},5,"F-H0-450",875,12},
  {{{0x6e86050dc6c04a95}},5,"F-H0-451",944,11},
  {{{0x88b2cecf705da510}},5,"F-H0-452",715,10},
  {{{0x96ef2cbc463462f9}},5,"F-H0-453",839,9},
  {{{0x96ef2cbc463462f9}},5,"F-H0-454",678,8},
  {{{0x96ef2cbc463462f9}},5,"F-H0-455",580,8},
  {{{0x96ef2cbc463462f9}},5,"F-H0-456",838,7},
  {{{0x96ef2cbc463462f9}},5,"F-H0-457",939,5},
  {{{0x96ef2cbc463462f9}},5,"F-H0-458",870,4},
  {{{0x96ef2cbc463462f9}},5,"F-H0-459",948,3},
  {{{0xa245d8aa8218c9a8}},5,"F-H0-460",529,2},
  {{{0xa245d8aa8218c9a8}},5,"F-H0-461",903,2},
  {{{0x6e86050dc6c04a95}},5,"F-H0-462",684,2},
  {{{0x96ef2cbc463462f9}},5,"F-H0-463",910,2},
  {{{0x96ef2cbc463462f9}},5,"F-H0-464",425,2},
  {{{0x96ef2cbc463462f9}},5,"F-H0-465",826,2},
  {{{0xa245d8aa8218c9a8}},5,"F-H0-466",943,2},
  {{{0x96ef2cbc463462f9}},5,"F-H0-467",906,2},
  {{{0x96ef2cbc463462f9}},5,"F-H0-468",869,2},
  {{{0x74e3245f14c6f325}},2,"F-H0-469",913,168},
  {{{0xd03b7d9219b1a99a}},2,"F-H0-470",913,55},
  {{{0x74e3245f14c6f325}},2,"F-H0-471",468,48},
  {{{0x73bfe4b76f771137}},2,"F-H0-472",431,36},
  {{{0x73bfe4b76f771137}},2,"F-H0-473",456,34},
  {{{0x74e3245f14c6f325}},2,"F-H0-474",457,10},
  {{{0x74e3245f14c6f325}},2,"F-H0-475",862,8},
  {{{0x73bfe4b76f771137}},2,"F-H0-476",506,7},
  {{{0x74e3245f14c6f325}},2,"F-H0-477",420,7},
  {{{0x74e3245f14c6f325}},2,"F-H0-478",875,4},
  {{{0x74e3245f14c6f325}},2,"F-H0-479",950,3},
  {{{0x74e3245f14c6f325}},2,"F-H0-480",458,3},
  {{{0x74e3245f14c6f325}},2,"F-H0-481",949,2},
  {{{0x74e3245f14c6f325}},2,"F-H0-482",876,2},
  {{{0xfcdc4c59e8ffc198}},2,"F-H0-483",418,2},
  {{{0x8432a150204748bc}},2,"F-H0-484",863,2},
  {{{0x74e3245f14c6f325}},2,"F-H0-485",467,2},
  {{{0x74e3245f14c6f325}},2,"F-H0-486",948,2},
  {{{0x74e3245f14c6f325}},2,"F-H0-487",825,2},
  {{{0x73ac93f866d24486}},1,"F-H0-488",468,237},
  {{{0x73ac93f866d24486}},1,"F-H0-489",913,29},
  {{{0x73ac93f866d24486}},1,"F-H0-490",901,23},
  {{{0x73ac93f866d24486}},1,"F-H0-491",690,13},
  {{{0x73ac93f866d24486}},1,"F-H0-492",721,12},
  {{{0x73ac93f866d24486}},1,"F-H0-493",682,11},
  {{{0x73ac93f866d24486}},1,"F-H0-494",876,8},
  {{{0x73ac93f866d24486}},1,"F-H0-495",504,7},
  {{{0x73ac93f866d24486}},1,"F-H0-496",759,6},
  {{{0x73ac93f866d24486}},1,"F-H0-497",950,5},
  {{{0x73ac93f866d24486}},1,"F-H0-498",910,4},
  {{{0x73ac93f866d24486}},1,"F-H0-499",687,3},
  {{{0x105e48797e18ee97}},4,"F-H0-500",875,170},
  {{{0x105e48797e18ee97}},4,"F-H0-501",678,113},
  {{{0x56c4afde7ba8a1eb}},4,"F-H0-502",425,31},
  {{{0x56c4afde7ba8a1eb}},4,"F-H0-503",420,23},
  {{{0x56c4afde7ba8a1eb}},4,"F-H0-504",458,18},
  {{{0x56c4afde7ba8a1eb}},4,"F-H0-505",462,13},
  {{{0x56c4afde7ba8a1eb}},4,"F-H0-506",421,8},
  {{{0x56c4afde7ba8a1eb}},4,"F-H0-507",684,4},
  {{{0x56c4afde7ba8a1eb}},4,"F-H0-508",788,2},
  {{{0x105e48797e18ee97}},4,"F-H0-509",943,2},
  {{{0x56c4afde7ba8a1eb}},4,"F-H0-510",690,2},
  {{{0xa03c2bb6e6be93b6}},6,"F-H0-511",690,215},
  {{{0xa03c2bb6e6be93b6}},6,"F-H0-512",653,98},
  {{{0xa03c2bb6e6be93b6}},6,"F-H0-513",470,40},
  {{{0xa03c2bb6e6be93b6}},6,"F-H0-514",529,9},
  {{{0xa03c2bb6e6be93b6}},6,"F-H0-515",907,5},
  {{{0xa03c2bb6e6be93b6}},6,"F-H0-516",947,4},
  {{{0xa03c2bb6e6be93b6}},6,"F-H0-517",948,3},
  {{{0x2ef38d822f96b347}},5,"F-H0-518",429,105},
  {{{0xdc4409ad483ea897}},5,"F-H0-519",941,81},
  {{{0x2ef38d822f96b347}},5,"F-H0-520",875,61},
  {{{0xf57ca7f0bda0872}},5,"F-H0-521",641,61},
  {{{0x2ef38d822f96b347}},5,"F-H0-522",466,40},
  {{{0x2ef38d822f96b347}},5,"F-H0-523",838,26},
  {{{0x2ef38d822f96b347}},5,"F-H0-524",690,21},
  {{{0x2ef38d822f96b347}},5,"F-H0-525",876,12},
  {{{0x2ef38d822f96b347}},5,"F-H0-526",616,7},
  {{{0x2ef38d822f96b347}},5,"F-H0-527",825,6},
  {{{0x2ef38d822f96b347}},5,"F-H0-528",691,6},
  {{{0x2ef38d822f96b347}},5,"F-H0-529",654,5},
  {{{0xdc4409ad483ea897}},5,"F-H0-530",902,4},
  {{{0xf57ca7f0bda0872}},5,"F-H0-531",825,3},
  {{{0x2ef38d822f96b347}},5,"F-H0-532",428,3},
  {{{0x2ef38d822f96b347}},5,"F-H0-533",728,2},
  {{{0x215a9c25b562e0e8}},5,"F-H0-534",825,149},
  {{{0x215a9c25b562e0e8}},5,"F-H0-535",801,102},
  {{{0x215a9c25b562e0e8}},5,"F-H0-536",690,47},
  {{{0x215a9c25b562e0e8}},5,"F-H0-537",462,29},
  {{{0x215a9c25b562e0e8}},5,"F-H0-538",764,20},
  {{{0x215a9c25b562e0e8}},5,"F-H0-539",691,17},
  {{{0x215a9c25b562e0e8}},5,"F-H0-540",839,14},
  {{{0x215a9c25b562e0e8}},5,"F-H0-541",678,10},
  {{{0x215a9c25b562e0e8}},5,"F-H0-542",838,10},
  {{{0x215a9c25b562e0e8}},5,"F-H0-543",911,10},
  {{{0x215a9c25b562e0e8}},5,"F-H0-544",939,9},
  {{{0x215a9c25b562e0e8}},5,"F-H0-545",728,7},
  {{{0x6c368f1a2c34a181}},5,"F-H0-546",715,6},
  {{{0x215a9c25b562e0e8}},5,"F-H0-547",580,5},
  {{{0x215a9c25b562e0e8}},5,"F-H0-548",684,5},
  {{{0x7d4450e2a67b0222}},5,"F-H0-549",903,4},
  {{{0x215a9c25b562e0e8}},5,"F-H0-550",677,3},
  {{{0x215a9c25b562e0e8}},5,"F-H0-551",942,2},
  {{{0x6c368f1a2c34a181}},5,"F-H0-552",838,2},
  {{{0xf5b4593eebbac16f}},5,"F-H0-553",876,2},
  {{{0x215a9c25b562e0e8}},5,"F-H0-554",425,2},
  {{{0x809a84f1fc824f36}},2,"F-H0-555",825,68},
  {{{0x809a84f1fc824f36}},2,"F-H0-556",826,38},
  {{{0x809a84f1fc824f36}},2,"F-H0-557",941,24},
  {{{0xcf996a197eaf8b9e}},2,"F-H0-558",456,19},
  {{{0x809a84f1fc824f36}},2,"F-H0-559",912,17},
  {{{0x809a84f1fc824f36}},2,"F-H0-560",902,13},
  {{{0x89e7c459fabc567d}},2,"F-H0-561",912,12},
  {{{0x6f716bc33186e108}},2,"F-H0-562",940,7},
  {{{0x6f716bc33186e108}},2,"F-H0-563",913,6},
  {{{0x6f716bc33186e108}},2,"F-H0-564",678,5},
  {{{0x809a84f1fc824f36}},2,"F-H0-565",905,4},
  {{{0x6f716bc33186e108}},2,"F-H0-566",861,3},
  {{{0x809a84f1fc824f36}},2,"F-H0-567",431,3},
  {{{0x809a84f1fc824f36}},2,"F-H0-568",942,3},
  {{{0x809a84f1fc824f36}},2,"F-H0-570",493,2},
  {{{0x809a84f1fc824f36}},2,"F-H0-571",949,2},
  {{{0x809a84f1fc824f36}},2,"F-H0-572",904,2},
  {{{0x809a84f1fc824f36}},2,"F-H0-573",865,2},
  {{{0x7e352cf77e6453ba}},2,"F-H0-574",506,2},
  {{{0xc7cae66b2848bdce}},6,"F-H0-575",945,98},
  {{{0x48d32c7809b6fe99}},6,"F-H0-576",826,42},
  {{{0xe299943f74e9066}},6,"F-H0-577",727,34},
  {{{0x25d40f74f598c685}},6,"F-H0-578",690,25},
  {{{0xc7cae66b2848bdce}},6,"F-H0-579",910,22},
  {{{0x25d40f74f598c685}},6,"F-H0-580",864,15},
  {{{0x48d32c7809b6fe99}},6,"F-H0-581",865,13},
  {{{0xe299943f74e9066}},6,"F-H0-582",690,12},
  {{{0x25d40f74f598c685}},6,"F-H0-583",457,10},
  {{{0x25d40f74f598c685}},6,"F-H0-584",939,4},
  {{{0xe299943f74e9066}},6,"F-H0-585",876,2},
  {{{0x24d1405d2d4cee3b}},3,"F-H0-586",949,164},
  {{{0x84cabad31c31bc56}},3,"F-H0-587",468,66},
  {{{0x9a35f87650d1dcd1}},3,"F-H0-588",492,20},
  {{{0x479c4f48bbe94d4a}},3,"F-H0-589",825,17},
  {{{0xd00cd756fa645a22}},3,"F-H0-590",457,13},
  {{{0x9a35f87650d1dcd1}},3,"F-H0-591",457,4},
  {{{0x9a35f87650d1dcd1}},3,"F-H0-592",825,4},
  {{{0x24d1405d2d4cee3b}},3,"F-H0-593",913,3},
  {{{0x9a35f87650d1dcd1}},3,"F-H0-594",939,3},
  {{{0x84cabad31c31bc56}},3,"F-H0-595",432,3},
  {{{0xf5b7e9c7b464df80}},4,"F-H0-596",543,157},
  {{{0x91b4ac818430d3c1}},4,"F-H0-597",420,79},
  {{{0xf5b7e9c7b464df80}},4,"F-H0-598",839,30},
  {{{0xf5b7e9c7b464df80}},4,"F-H0-599",457,29},
  {{{0xf5b7e9c7b464df80}},4,"F-H0-600",728,12},
  {{{0xe720b04f0fcaeca5}},4,"F-H0-601",863,3},
  {{{0xcc7885498cd3ac6}},4,"F-H0-602",492,3},
  {{{0xf5b7e9c7b464df80}},4,"F-H0-603",458,3},
  {{{0xf5b7e9c7b464df80}},4,"F-H0-604",421,2},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-605",468,157},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-606",456,106},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-607",912,27},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-608",455,20},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-609",493,14},
  {{{0x821189cf6775a01b}},1,"F-H0-610",938,11},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-611",899,10},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-612",949,7},
  {{{0xdd41a1ab59909a6b}},1,"F-H0-613",913,7},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-614",431,6},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-615",467,6},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-616",863,6},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-617",911,4},
  {{{0x821189cf6775a01b}},1,"F-H0-618",467,3},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-619",469,3},
  {{{0xdd41a1ab59909a6b}},1,"F-H0-620",900,2},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-621",505,2},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-622",864,2},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-623",457,2},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-624",432,2},
  {{{0xdd41a1ab59909a6b}},1,"F-H0-625",950,2},
  {{{0x9023b4a44657f9dd}},1,"F-H0-626",876,2},
  {{{0x54f1ad373ffd9f98}},1,"F-H0-627",948,2},
  {{{0x3bcb8accbc1f2d05}},3,"F-H0-628",456,153},
  {{{0x3bcb8accbc1f2d05}},3,"F-H0-629",455,98},
  {{{0x35b519e678b5063a}},3,"F-H0-630",911,16},
  {{{0x3bcb8accbc1f2d05}},3,"F-H0-631",492,15},
  {{{0x3bcb8accbc1f2d05}},3,"F-H0-632",418,14},
  {{{0x3bcb8accbc1f2d05}},3,"F-H0-633",939,8},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-634",912,117},
  {{{0xb6ad13d22380ba41}},2,"F-H0-635",419,81},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-636",468,76},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-637",949,24},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-638",431,15},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-639",419,14},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-640",430,8},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-641",469,7},
  {{{0xb6ad13d22380ba41}},2,"F-H0-642",505,6},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-643",875,5},
  {{{0xb6ad13d22380ba41}},2,"F-H0-644",912,5},
  {{{0xb6ad13d22380ba41}},2,"F-H0-645",420,4},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-646",911,3},
  {{{0xd2798d1aa73326da}},2,"F-H0-647",950,2},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-648",950,2},
  {{{0xbc9dad24c8aeea2a}},2,"F-H0-649",505,2},
  {{{0xb6ad13d22380ba41}},2,"F-H0-650",492,2},
  {{{0xb6ad13d22380ba41}},2,"F-H0-651",875,2},
  {{{0xb1d22c00fb764c31}},6,"F-H0-652",543,228},
  {{{0xf89afc828c66bd0f}},6,"F-H0-653",468,49},
  {{{0xb1d22c00fb764c31}},6,"F-H0-654",542,4},
  {{{0xcf27b5df91e394d0}},5,"F-H0-655",429,99},
  {{{0xcf27b5df91e394d0}},5,"F-H0-656",653,48},
  {{{0xcf27b5df91e394d0}},5,"F-H0-657",617,45},
  {{{0xcf27b5df91e394d0}},5,"F-H0-658",466,40},
  {{{0xcf27b5df91e394d0}},5,"F-H0-659",911,39},
  {{{0xcf27b5df91e394d0}},5,"F-H0-660",690,18},
  {{{0xcf27b5df91e394d0}},5,"F-H0-661",948,8},
  {{{0xcf27b5df91e394d0}},5,"F-H0-662",825,7},
  {{{0xcf27b5df91e394d0}},5,"F-H0-663",910,6},
  {{{0xd178d44954db9f}},5,"F-H0-664",788,5},
  {{{0xcf27b5df91e394d0}},5,"F-H0-665",616,4},
  {{{0xcf27b5df91e394d0}},5,"F-H0-666",691,4},
  {{{0xd178d44954db9f}},5,"F-H0-667",839,4},
  {{{0xcf27b5df91e394d0}},5,"F-H0-668",542,4},
  {{{0xcffd2ba7092ab822}},5,"F-H0-669",640,3},
  {{{0xcf27b5df91e394d0}},5,"F-H0-670",461,2},
  {{{0x489973b8951e9dd6}},5,"F-H0-671",901,163},
  {{{0xf587b3de7814be15}},5,"F-H0-672",943,72},
  {{{0xf587b3de7814be15}},5,"F-H0-673",947,34},
  {{{0xf587b3de7814be15}},5,"F-H0-674",948,17},
  {{{0xf587b3de7814be15}},5,"F-H0-675",910,16},
  {{{0xf587b3de7814be15}},5,"F-H0-676",462,16},
  {{{0xf587b3de7814be15}},5,"F-H0-677",944,13},
  {{{0x77542bd0bd9aa9b9}},5,"F-H0-678",714,6},
  {{{0xf587b3de7814be15}},5,"F-H0-679",906,5},
  {{{0xf587b3de7814be15}},5,"F-H0-680",690,4},
  {{{0xe82a193e920db6e5}},5,"F-H0-681",458,3},
  {{{0x489973b8951e9dd6}},5,"F-H0-682",677,2},
  {{{0xd510aef047f5a598}},6,"F-H0-683",432,154},
  {{{0xb8d52bcc5de883b7}},6,"F-H0-684",865,86},
  {{{0xc6c4ea399aaeda91}},6,"F-H0-685",838,13},
  {{{0xd510aef047f5a598}},6,"F-H0-686",429,13},
  {{{0xd6aa82f375782426}},6,"F-H0-687",604,10},
  {{{0xd510aef047f5a598}},6,"F-H0-688",421,7},
  {{{0xd510aef047f5a598}},6,"F-H0-689",529,6},
  {{{0xd510aef047f5a598}},6,"F-H0-690",578,2},
  {{{0x202a6ee8603a29cc}},6,"F-H0-691",801,134},
  {{{0xb60bdacab2640f37}},6,"F-H0-692",865,49},
  {{{0xa8429e55881a2369}},6,"F-H0-693",948,32},
  {{{0xa8429e55881a2369}},6,"F-H0-694",910,28},
  {{{0x11962efb119a84a6}},6,"F-H0-695",568,15},
  {{{0x8d20fb630d7a03c9}},6,"F-H0-696",432,13},
  {{{0xa8429e55881a2369}},6,"F-H0-697",908,7},
  {{{0x8cf8bfcde21c489f}},6,"F-H0-698",678,4},
  {{{0xa8429e55881a2369}},6,"F-H0-699",429,3},
  {{{0x11962efb119a84a6}},6,"F-H0-700",429,3},
  {{{0x11962efb119a84a6}},6,"F-H0-701",463,2},
  {{{0xb96cc8c91b0e20cc}},6,"F-H0-702",690,123},
  {{{0xb96cc8c91b0e20cc}},6,"F-H0-703",470,67},
  {{{0x455b702912b1d555}},6,"F-H0-704",641,11},
  {{{0xb96cc8c91b0e20cc}},6,"F-H0-705",529,8},
  {{{0x7102c38e8e4cf3d8}},6,"F-H0-706",945,5},
  {{{0xb96cc8c91b0e20cc}},6,"F-H0-707",541,4},
  {{{0x7b89f2306ba878dc}},6,"F-H0-708",425,4},
  {{{0xb96cc8c91b0e20cc}},6,"F-H0-709",728,4},
  {{{0x455b702912b1d555}},6,"F-H0-710",906,3},
  {{{0xdc1841626e235824}},6,"F-H0-711",942,3},
  {{{0xcff43d9cae986716}},6,"F-H0-712",905,2},
  {{{0x817bf567069ba9d9}},4,"F-H0-713",467,181},
  {{{0xa36dfe14fadf89e4}},4,"F-H0-714",690,52},
  {{{0x817bf567069ba9d9}},4,"F-H0-715",430,32},
  {{{0x817bf567069ba9d9}},4,"F-H0-716",875,19},
  {{{0x685689f77697a235}},4,"F-H0-717",530,12},
  {{{0x685689f77697a235}},4,"F-H0-718",684,5},
  {{{0x817bf567069ba9d9}},4,"F-H0-719",429,4},
  {{{0xa36dfe14fadf89e4}},4,"F-H0-720",425,3},
  {{{0xc7e112c0032be6a5}},4,"F-H0-721",678,2},
  {{{0xc7e112c0032be6a5}},4,"F-H0-722",943,2},
  {{{0x685689f77697a235}},4,"F-H0-723",430,2},
  {{{0x685689f77697a235}},4,"F-H0-724",466,2},
  {{{0x685689f77697a235}},4,"F-H0-725",425,2},
  {{{0x37700d7e19ff6afc}},5,"F-H0-726",421,97},
  {{{0x9a0dba7a41b11165}},5,"F-H0-727",941,61},
  {{{0x463ee5e33126ca9}},5,"F-H0-728",530,48},
  {{{0x9a0dba7a41b11165}},5,"F-H0-729",905,34},
  {{{0x37700d7e19ff6afc}},5,"F-H0-730",911,17},
  {{{0xf49aa281ee5cc87a}},5,"F-H0-731",690,14},
  {{{0x9a0dba7a41b11165}},5,"F-H0-732",942,7},
  {{{0xd7309377312229ac}},5,"F-H0-733",492,5},
  {{{0x9a0dba7a41b11165}},5,"F-H0-734",902,5},
  {{{0x37700d7e19ff6afc}},5,"F-H0-735",825,3},
  {{{0x37700d7e19ff6afc}},5,"F-H0-736",422,3},
  {{{0xd7309377312229ac}},5,"F-H0-737",943,3},
  {{{0x9a0dba7a41b11165}},5,"F-H0-738",839,2},
  {{{0x4c4c4f07e1256177}},2,"F-H0-739",456,33},
  {{{0xbee4de08857bfca7}},2,"F-H0-740",456,29},
  {{{0x4c4c4f07e1256177}},2,"F-H0-741",947,22},
  {{{0xbee4de08857bfca7}},2,"F-H0-742",690,17},
  {{{0x4c4c4f07e1256177}},2,"F-H0-743",910,8},
  {{{0xbee4de08857bfca7}},2,"F-H0-744",901,7},
  {{{0x5f440217c6968677}},2,"F-H0-745",936,6},
  {{{0x5f440217c6968677}},2,"F-H0-746",911,5},
  {{{0xbee4de08857bfca7}},2,"F-H0-747",913,5},
  {{{0x5f440217c6968677}},2,"F-H0-748",948,4},
  {{{0xd299a0d5b3e7b91d}},2,"F-H0-749",690,3},
  {{{0xbee4de08857bfca7}},2,"F-H0-750",864,2},
  {{{0xbee4de08857bfca7}},2,"F-H0-751",937,2},
  {{{0x5f440217c6968677}},2,"F-H0-752",494,2},
  {{{0x5f440217c6968677}},2,"F-H0-754",466,2},
  {{{0x5f440217c6968677}},2,"F-H0-755",789,2},
  {{{0x5f440217c6968677}},2,"F-H0-756",864,2},
  {{{0x5f440217c6968677}},2,"F-H0-757",457,2},
  {{{0xe332a764ef9d55d9}},4,"F-H0-758",419,77},
  {{{0xe332a764ef9d55d9}},4,"F-H0-759",906,77},
  {{{0xad0f0a80a1d02e62}},4,"F-H0-760",529,59},
  {{{0xad0f0a80a1d02e62}},4,"F-H0-761",467,32},
  {{{0xad0f0a80a1d02e62}},4,"F-H0-762",421,13},
  {{{0xe332a764ef9d55d9}},4,"F-H0-763",425,9},
  {{{0x89ab5906955540db}},4,"F-H0-764",506,7},
  {{{0xe332a764ef9d55d9}},4,"F-H0-765",684,6},
  {{{0xe332a764ef9d55d9}},4,"F-H0-766",418,5},
  {{{0xa9c4f453f11d4e6d}},4,"F-H0-767",900,4},
  {{{0xe332a764ef9d55d9}},4,"F-H0-768",677,4},
  {{{0xe332a764ef9d55d9}},4,"F-H0-769",424,4},
  {{{0xb0df84370118b8cb}},4,"F-H0-770",462,3},
  {{{0xe59c9127e84b931d}},4,"F-H0-771",580,2},
  {{{0x89ab5906955540db}},4,"F-H0-772",462,2},
  {{{0xb285cf557f8ddf1e}},7,"F-H0-773",936,112},
  {{{0xb285cf557f8ddf1e}},7,"F-H0-774",865,100},
  {{{0x4bdb49fa04ac9799}},7,"F-H0-775",947,28},
  {{{0x4bdb49fa04ac9799}},7,"F-H0-776",764,25},
  {{{0x4bdb49fa04ac9799}},7,"F-H0-777",910,10},
  {{{0x4bdb49fa04ac9799}},7,"F-H0-778",825,4},
  {{{0xb48733c9190645d8}},5,"F-H0-779",943,195},
  {{{0xb48733c9190645d8}},5,"F-H0-780",825,39},
  {{{0xb48733c9190645d8}},5,"F-H0-781",944,26},
  {{{0xb48733c9190645d8}},5,"F-H0-782",462,11},
  {{{0xb48733c9190645d8}},5,"F-H0-783",906,6},
  {{{0xaa6e07956b92d2f0}},5,"F-H0-784",714,6},
  {{{0x8fe46a7493aeb88e}},5,"F-H0-785",947,6},
  {{{0x8fe46a7493aeb88e}},5,"F-H0-786",826,5},
  {{{0x8fe46a7493aeb88e}},5,"F-H0-787",690,3},
  {{{0xb48733c9190645d8}},5,"F-H0-788",986,2},
  {{{0x14e13c6e9b24792d}},5,"F-H0-789",530,2},
  {{{0xaa9f020253701b53}},2,"F-H0-790",456,106},
  {{{0xa9840ce30f193d2c}},2,"F-H0-791",431,82},
  {{{0xaa9f020253701b53}},2,"F-H0-792",468,53},
  {{{0x87f4946189ad7bd7}},2,"F-H0-793",949,14},
  {{{0x87f4946189ad7bd7}},2,"F-H0-794",467,9},
  {{{0xaa9f020253701b53}},2,"F-H0-795",469,8},
  {{{0xaa9f020253701b53}},2,"F-H0-796",457,5},
  {{{0xaa9f020253701b53}},2,"F-H0-797",913,5},
  {{{0x87f4946189ad7bd7}},2,"F-H0-798",876,4},
  {{{0xcc4a5b094005f606}},2,"F-H0-799",938,3},
  {{{0xcc4a5b094005f606}},2,"F-H0-800",899,2},
  {{{0xa9840ce30f193d2c}},2,"F-H0-801",900,2},
  {{{0x9167f0ef22361a55}},7,"F-H0-802",469,222},
  {{{0xd62913fda8ac98de}},7,"F-H0-803",383,8},
  {{{0x318954ded313eff7}},3,"F-H0-804",456,164},
  {{{0x318954ded313eff7}},3,"F-H0-805",455,74},
  {{{0x318954ded313eff7}},3,"F-H0-806",493,14},
  {{{0x318954ded313eff7}},3,"F-H0-807",949,13},
  {{{0x318954ded313eff7}},3,"F-H0-808",492,9},
  {{{0x318954ded313eff7}},3,"F-H0-809",419,5},
  {{{0x318954ded313eff7}},3,"F-H0-810",418,4},
  {{{0x318954ded313eff7}},3,"F-H0-811",911,3},
  {{{0x318954ded313eff7}},3,"F-H0-812",939,3},
  {{{0x318954ded313eff7}},3,"F-H0-813",912,3},
  {{{0x318954ded313eff7}},3,"F-H0-814",825,2},
  {{{0x318954ded313eff7}},3,"F-H0-815",948,2},
  {{{0x318954ded313eff7}},3,"F-H0-816",950,2},
  {{{0xcfa682f54ca031ca}},8,"F-H0-817",458,126},
  {{{0xcfa682f54ca031ca}},8,"F-H0-818",459,48},
  {{{0x3881a02a8cab32e7}},8,"F-H0-819",947,44},
  {{{0x271e3fc8fe6c387b}},8,"F-H0-820",543,15},
  {{{0x3881a02a8cab32e7}},8,"F-H0-821",539,11},
  {{{0xf83060dda547983f}},4,"F-H0-822",862,109},
  {{{0xa2efba7c2bec535b}},4,"F-H0-823",875,48},
  {{{0xf83060dda547983f}},4,"F-H0-824",825,18},
  {{{0xf83060dda547983f}},4,"F-H0-825",420,15},
  {{{0xf83060dda547983f}},4,"F-H0-826",543,15},
  {{{0xf83060dda547983f}},4,"F-H0-827",863,7},
  {{{0xf83060dda547983f}},4,"F-H0-828",421,5},
  {{{0xf83060dda547983f}},4,"F-H0-829",677,4},
  {{{0xf83060dda547983f}},4,"F-H0-830",458,3},
  {{{0x753413d5e0600ee9}},5,"F-H0-831",421,64},
  {{{0x753413d5e0600ee9}},5,"F-H0-832",603,43},
  {{{0x2b2ed306bd3af1a2}},5,"F-H0-833",907,42},
  {{{0x753413d5e0600ee9}},5,"F-H0-834",863,39},
  {{{0x753413d5e0600ee9}},5,"F-H0-835",458,26},
  {{{0x2b2ed306bd3af1a2}},5,"F-H0-836",902,19},
  {{{0x753413d5e0600ee9}},5,"F-H0-837",678,11},
  {{{0x753413d5e0600ee9}},5,"F-H0-838",862,6},
  {{{0x753413d5e0600ee9}},5,"F-H0-839",640,5},
  {{{0x753413d5e0600ee9}},5,"F-H0-840",604,3},
  {{{0x753413d5e0600ee9}},5,"F-H0-841",911,3},
  {{{0x753413d5e0600ee9}},5,"F-H0-842",462,2},
  {{{0x2b2ed306bd3af1a2}},5,"F-H0-843",943,2},
  {{{0x8b5582bee08d731b}},2,"F-H0-844",455,83},
  {{{0x8b5582bee08d731b}},2,"F-H0-845",456,42},
  {{{0x8b5582bee08d731b}},2,"F-H0-846",419,36},
  {{{0xcb1d641770676a6e}},2,"F-H0-847",468,24},
  {{{0x8b5582bee08d731b}},2,"F-H0-848",431,24},
  {{{0x8b5582bee08d731b}},2,"F-H0-849",469,18},
  {{{0x8b5582bee08d731b}},2,"F-H0-850",420,9},
  {{{0x8cd34482b1816b1a}},2,"F-H0-851",420,4},
  {{{0x8b5582bee08d731b}},2,"F-H0-852",432,3},
  {{{0x8b5582bee08d731b}},2,"F-H0-853",947,3},
  {{{0x8b5582bee08d731b}},2,"F-H0-854",492,2},
  {{{0x8b5582bee08d731b}},2,"F-H0-855",505,2},
  {{{0x42923563cb81c6f5}},7,"F-H0-856",947,129},
  {{{0x42923563cb81c6f5}},7,"F-H0-857",910,30},
  {{{0x42923563cb81c6f5}},7,"F-H0-858",911,27},
  {{{0x42923563cb81c6f5}},7,"F-H0-859",825,24},
  {{{0x42923563cb81c6f5}},7,"F-H0-860",948,8},
  {{{0x42923563cb81c6f5}},7,"F-H0-861",939,6},
  {{{0xd2b1063729cc78a0}},7,"F-H0-862",691,6},
  {{{0x42923563cb81c6f5}},7,"F-H0-863",944,5},
  {{{0x42923563cb81c6f5}},7,"F-H0-864",678,3},
  {{{0x706094dc3a45f456}},4,"F-H0-865",911,144},
  {{{0x706094dc3a45f456}},4,"F-H0-866",678,44},
  {{{0x706094dc3a45f456}},4,"F-H0-867",948,20},
  {{{0xe129e0bf0340edf1}},4,"F-H0-868",939,20},
  {{{0xc5595e94ec215a12}},4,"F-H0-869",530,9},
  {{{0xa70c9a154b490aea}},4,"F-H0-870",429,4},
  {{{0xc5595e94ec215a12}},4,"F-H0-871",425,2},
  {{{0x43e0c4bdbea3b5b4}},4,"F-H0-872",875,143},
  {{{0x43e0c4bdbea3b5b4}},4,"F-H0-873",876,62},
  {{{0x4f4e2fc55f84ed3}},4,"F-H0-874",839,13},
  {{{0x3a66c4d558c74d0d}},4,"F-H0-875",684,9},
  {{{0x43e0c4bdbea3b5b4}},4,"F-H0-876",838,8},
  {{{0xad9a519e7ed835fa}},4,"F-H0-877",543,8},
  {{{0x13c00f440b5f89e1}},4,"F-H0-878",939,5},
  {{{0x86e7ff73de070bdf}},2,"F-H0-879",456,101},
  {{{0x21b10db6d9dc609a}},2,"F-H0-880",419,74},
  {{{0x21b10db6d9dc609a}},2,"F-H0-881",468,26},
  {{{0x21b10db6d9dc609a}},2,"F-H0-882",455,14},
  {{{0x21b10db6d9dc609a}},2,"F-H0-883",911,13},
  {{{0x21b10db6d9dc609a}},2,"F-H0-884",431,12},
  {{{0x21b10db6d9dc609a}},2,"F-H0-885",420,4},
  {{{0x21b10db6d9dc609a}},2,"F-H0-886",469,3},
  {{{0x6385603dc506009a}},2,"F-H0-887",901,3},
  {{{0x21b10db6d9dc609a}},2,"F-H0-888",432,2},
  {{{0x21b10db6d9dc609a}},2,"F-H0-889",418,2},
  {{{0x21b10db6d9dc609a}},2,"F-H0-890",492,2},
  {{{0x21b10db6d9dc609a}},2,"F-H0-891",948,2},
  {{{0x149d5c029599324c}},4,"F-H0-892",505,143},
  {{{0x149d5c029599324c}},4,"F-H0-893",506,36},
  {{{0x149d5c029599324c}},4,"F-H0-894",944,28},
  {{{0x149d5c029599324c}},4,"F-H0-895",907,17},
  {{{0x1fa32c6a1997f79}},4,"F-H0-896",875,12},
  {{{0x149d5c029599324c}},4,"F-H0-897",542,10},
  {{{0x1fa32c6a1997f79}},4,"F-H0-898",876,5},
  {{{0x149d5c029599324c}},4,"F-H0-899",947,3},
  {{{0x95069cf03999a641}},4,"F-H0-900",420,3},
  {{{0x2dd9179dd71db06d}},4,"F-H0-901",939,2},
  {{{0x149d5c029599324c}},4,"F-H0-902",421,2},
  {{{0x149d5c029599324c}},4,"F-H0-903",690,2},
  {{{0x6e6d63143906b302}},6,"F-H0-904",908,44},
  {{{0x6e6d63143906b302}},6,"F-H0-905",429,44},
  {{{0xce8a33a349d0fb8}},6,"F-H0-906",466,40},
  {{{0x6e6d63143906b302}},6,"F-H0-907",874,38},
  {{{0x6e6d63143906b302}},6,"F-H0-908",948,34},
  {{{0x6e6d63143906b302}},6,"F-H0-909",946,19},
  {{{0x93caa1cc84bcf0a1}},6,"F-H0-910",825,4},
  {{{0x6e6d63143906b302}},6,"F-H0-911",466,3},
  {{{0x6e6d63143906b302}},6,"F-H0-912",909,3},
  {{{0x6e6d63143906b302}},6,"F-H0-913",801,2},
  {{{0x38f1ecc9203bc06e}},7,"F-H0-914",947,95},
  {{{0x90cb4836597fc869}},7,"F-H0-915",839,45},
  {{{0xd1ba85bb0468b4f4}},7,"F-H0-916",677,39},
  {{{0x38f1ecc9203bc06e}},7,"F-H0-917",939,12},
  {{{0x38f1ecc9203bc06e}},7,"F-H0-918",678,2},
  {{{0x38f1ecc9203bc06e}},7,"F-H0-919",470,2},
  {{{0x90cb4836597fc869}},7,"F-H0-920",906,2},
  {{{0x5b793bb85c3ebc9e}},7,"F-H0-921",458,2},
  {{{0x428989566f5be48f}},3,"F-H0-922",456,131},
  {{{0x4a0385a0d8aa5720}},3,"F-H0-923",431,35},
  {{{0x416011327b49457f}},3,"F-H0-924",431,9},
  {{{0x428989566f5be48f}},3,"F-H0-925",911,8},
  {{{0x428989566f5be48f}},3,"F-H0-926",492,7},
  {{{0x47948eee0812ddef}},3,"F-H0-927",826,5},
  {{{0x47948eee0812ddef}},3,"F-H0-928",863,4},
  {{{0x428989566f5be48f}},3,"F-H0-929",493,4},
  {{{0x47948eee0812ddef}},3,"F-H0-930",950,2},
  {{{0x47948eee0812ddef}},3,"F-H0-931",875,2},
  {{{0x428989566f5be48f}},3,"F-H0-932",910,2},
  {{{0x47948eee0812ddef}},3,"F-H0-933",677,2},
  {{{0x7aef25cd5e873a1e}},2,"F-H0-934",912,86},
  {{{0x295583b6cedab786}},2,"F-H0-935",912,50},
  {{{0x7aef25cd5e873a1e}},2,"F-H0-936",913,41},
  {{{0x295583b6cedab786}},2,"F-H0-937",913,38},
  {{{0x7aef25cd5e873a1e}},2,"F-H0-938",875,7},
  {{{0x7aef25cd5e873a1e}},2,"F-H0-939",876,7},
  {{{0x7aef25cd5e873a1e}},2,"F-H0-940",949,7},
  {{{0x7aef25cd5e873a1e}},2,"F-H0-941",457,5},
  {{{0x295583b6cedab786}},2,"F-H0-942",949,5},
  {{{0x7121db32f8a63ff5}},2,"F-H0-943",419,5},
  {{{0x7aef25cd5e873a1e}},2,"F-H0-944",948,3},
  {{{0xa41307addfa1b7e3}},2,"F-H0-945",948,3},
  {{{0x7121db32f8a63ff5}},2,"F-H0-946",505,2},
  {{{0xb52892f92009aba}},2,"F-H0-947",457,29},
  {{{0xb52892f92009aba}},2,"F-H0-948",875,17},
  {{{0x513f124ef45ac968}},2,"F-H0-949",468,17},
  {{{0xb52892f92009aba}},2,"F-H0-950",911,16},
  {{{0x6986e5d1b5472c40}},2,"F-H0-951",468,11},
  {{{0xb52892f92009aba}},2,"F-H0-952",913,7},
  {{{0xde84496bfa1a0674}},2,"F-H0-953",876,7},
  {{{0xde84496bfa1a0674}},2,"F-H0-954",913,7},
  {{{0xb52892f92009aba}},2,"F-H0-955",876,7},
  {{{0xde84496bfa1a0674}},2,"F-H0-956",543,5},
  {{{0xb52892f92009aba}},2,"F-H0-957",492,5},
  {{{0xb52892f92009aba}},2,"F-H0-958",948,4},
  {{{0x6986e5d1b5472c40}},2,"F-H0-959",431,3},
  {{{0x6986e5d1b5472c40}},2,"F-H0-961",467,2},
  {{{0xde84496bfa1a0674}},2,"F-H0-962",429,2},
  {{{0xb52892f92009aba}},2,"F-H0-963",874,2},
  {{{0x38a92c587970b6a7}},3,"F-H0-964",431,66},
  {{{0xf840b12486115244}},3,"F-H0-965",456,53},
  {{{0x5caa691e4924bae6}},3,"F-H0-966",875,30},
  {{{0x5caa691e4924bae6}},3,"F-H0-967",506,15},
  {{{0x5caa691e4924bae6}},3,"F-H0-968",505,8},
  {{{0x5caa691e4924bae6}},3,"F-H0-969",431,8},
  {{{0x5caa691e4924bae6}},3,"F-H0-970",432,8},
  {{{0x38a92c587970b6a7}},3,"F-H0-971",420,7},
  {{{0x38a92c587970b6a7}},3,"F-H0-972",458,3},
  {{{0x3a9b09d6f46a9d0c}},3,"F-H0-973",938,3},
  {{{0xbf045bcd26ee65e9}},4,"F-H0-974",506,44},
  {{{0x7c391c2c71a1b569}},4,"F-H0-975",455,42},
  {{{0x264c4680e2f17049}},4,"F-H0-976",908,38},
  {{{0x264c4680e2f17049}},4,"F-H0-977",838,26},
  {{{0x7c391c2c71a1b569}},4,"F-H0-978",802,20},
  {{{0x264c4680e2f17049}},4,"F-H0-979",456,19},
  {{{0x264c4680e2f17049}},4,"F-H0-980",909,11},
  {{{0x264c4680e2f17049}},4,"F-H0-981",874,10},
  {{{0x264c4680e2f17049}},4,"F-H0-982",839,3},
  {{{0x264c4680e2f17049}},4,"F-H0-983",457,2},
  {{{0x264c4680e2f17049}},4,"F-H0-984",429,2},
  {{{0x42fac16d16d37b5b}},3,"F-H0-985",468,59},
  {{{0x42fac16d16d37b5b}},3,"F-H0-986",469,40},
  {{{0x42fac16d16d37b5b}},3,"F-H0-987",862,38},
  {{{0x42fac16d16d37b5b}},3,"F-H0-988",863,17},
  {{{0x606d808cbe444d6c}},3,"F-H0-989",419,13},
  {{{0x42fac16d16d37b5b}},3,"F-H0-990",432,10},
  {{{0x42fac16d16d37b5b}},3,"F-H0-991",505,7},
  {{{0x42fac16d16d37b5b}},3,"F-H0-992",506,5},
  {{{0x42fac16d16d37b5b}},3,"F-H0-993",911,4},
  {{{0xa8030dcb6a50e93f}},4,"F-H0-994",543,51},
  {{{0xa8030dcb6a50e93f}},4,"F-H0-995",949,37},
  {{{0xa8030dcb6a50e93f}},4,"F-H0-996",529,11},
  {{{0xa8030dcb6a50e93f}},4,"F-H0-997",421,5},
  {{{0x957f94c3d2fa2024}},4,"F-H0-998",943,4},
  {{{0xa8030dcb6a50e93f}},4,"F-H0-999",911,4},
  {{{0x4ded553066bec225}},4,"F-H0-1000",543,4},
  {{{0xa8030dcb6a50e93f}},4,"F-H0-1001",462,3},
  {{{0xa8030dcb6a50e93f}},4,"F-H0-1002",874,2},
  {{{0xc56597f68ae710f4}},4,"F-H0-1003",906,2},
  {{{0xa8030dcb6a50e93f}},4,"F-H0-1004",542,2},
  {{{0x5d793910576a1ced}},1,"F-H0-1005",468,107},
  {{{0x5d793910576a1ced}},1,"F-H0-1006",456,60},
  {{{0x8cd54c4add43bb2f}},1,"F-H0-1007",912,17},
  {{{0xd5ec0ad0366ccb47}},1,"F-H0-1008",431,14},
  {{{0x5d793910576a1ced}},1,"F-H0-1009",431,11},
  {{{0x5d793910576a1ced}},1,"F-H0-1010",913,6},
  {{{0x5d793910576a1ced}},1,"F-H0-1011",493,5},
  {{{0x5d793910576a1ced}},1,"F-H0-1012",504,3},
  {{{0x8cd54c4add43bb2f}},1,"F-H0-1013",430,3},
  {{{0x5d793910576a1ced}},1,"F-H0-1014",467,2},
  {{{0x8cd54c4add43bb2f}},1,"F-H0-1015",432,2},
  {{{0xae962dfdaa258581}},5,"F-H0-1016",908,70},
  {{{0x17a6dbb26030ef10}},5,"F-H0-1017",420,57},
  {{{0x17a6dbb26030ef10}},5,"F-H0-1018",422,32},
  {{{0x17a6dbb26030ef10}},5,"F-H0-1019",530,17},
  {{{0x17a6dbb26030ef10}},5,"F-H0-1020",494,10},
  {{{0x17a6dbb26030ef10}},5,"F-H0-1021",911,9},
  {{{0xca715178344a437f}},5,"F-H0-1022",801,5},
  {{{0x17a6dbb26030ef10}},5,"F-H0-1023",947,4},
  {{{0x17a6dbb26030ef10}},5,"F-H0-1024",948,4},
  {{{0x17a6dbb26030ef10}},5,"F-H0-1025",567,2},
  {{{0xca715178344a437f}},5,"F-H0-1026",947,2},
  {{{0x66ce032d1477171}},6,"F-H0-1027",432,117},
  {{{0x1643bc9b4845cf8b}},6,"F-H0-1028",873,54},
  {{{0x66ce032d1477171}},6,"F-H0-1029",429,13},
  {{{0xb6a9bab6089205fb}},6,"F-H0-1030",826,11},
  {{{0x66ce032d1477171}},6,"F-H0-1031",616,5},
  {{{0x66ce032d1477171}},6,"F-H0-1032",948,5},
  {{{0x66ce032d1477171}},6,"F-H0-1033",529,3},
  {{{0x66ce032d1477171}},6,"F-H0-1034",421,3},
  {{{0xd85b9e21ae9ec424}},4,"F-H0-1035",906,58},
  {{{0xd85b9e21ae9ec424}},4,"F-H0-1036",543,50},
  {{{0xa917d22beba2357d}},4,"F-H0-1037",455,48},
  {{{0x224b88b4156b9045}},4,"F-H0-1038",947,13},
  {{{0xa917d22beba2357d}},4,"F-H0-1039",677,10},
  {{{0x7c3b1e7ce071181a}},4,"F-H0-1040",691,5},
  {{{0x1a87f72bdf754dcf}},4,"F-H0-1041",430,4},
  {{{0xfb4e9b68b0e98f9f}},4,"F-H0-1042",690,2},
  {{{0xa917d22beba2357d}},4,"F-H0-1043",684,2},
  {{{0xd9962da8d9403302}},4,"F-H0-1044",432,2},
  {{{0xd9962da8d9403302}},4,"F-H0-1045",462,2},
  {{{0xe05621dcbb6bda4a}},3,"F-H0-1046",455,102},
  {{{0xe05621dcbb6bda4a}},3,"F-H0-1047",456,39},
  {{{0xf12778cccc071b03}},3,"F-H0-1048",457,18},
  {{{0x7b202f4786fab5b1}},3,"F-H0-1049",948,8},
  {{{0xe05621dcbb6bda4a}},3,"F-H0-1050",493,7},
  {{{0xe05621dcbb6bda4a}},3,"F-H0-1051",910,4},
  {{{0xe05621dcbb6bda4a}},3,"F-H0-1052",948,4},
  {{{0x7b202f4786fab5b1}},3,"F-H0-1053",875,3},
  {{{0x6597abcff3711687}},4,"F-H0-1054",839,157},
  {{{0x6597abcff3711687}},4,"F-H0-1055",684,9},
  {{{0x6597abcff3711687}},4,"F-H0-1056",678,5},
  {{{0x6597abcff3711687}},4,"F-H0-1057",944,3},
  {{{0xefde4f35874751ef}},4,"F-H0-1058",542,2},
  {{{0x6597abcff3711687}},4,"F-H0-1059",691,2},
  {{{0x6597abcff3711687}},4,"F-H0-1060",429,2},
  {{{0xd11efe8ba067b1e7}},6,"F-H0-1061",945,69},
  {{{0x9456ec3db64a9f58}},6,"F-H0-1062",543,22},
  {{{0x371efecf22dace19}},6,"F-H0-1063",691,21},
  {{{0xd11efe8ba067b1e7}},6,"F-H0-1064",941,12},
  {{{0x56dab683cae7397f}},6,"F-H0-1065",422,9},
  {{{0xd11efe8ba067b1e7}},6,"F-H0-1066",421,8},
  {{{0x371efecf22dace19}},6,"F-H0-1067",429,6},
  {{{0x9456ec3db64a9f58}},6,"F-H0-1068",421,2},
  {{{0xd11efe8ba067b1e7}},6,"F-H0-1069",677,2},
  {{{0x6a10860b8dbcf425}},6,"F-H0-1070",690,126},
  {{{0x6a10860b8dbcf425}},6,"F-H0-1071",653,39},
  {{{0xdff0302de1b36ab}},6,"F-H0-1072",394,15},
  {{{0x6a10860b8dbcf425}},6,"F-H0-1073",654,2},
  {{{0x6a10860b8dbcf425}},6,"F-H0-1074",944,2},
  {{{0x6a10860b8dbcf425}},6,"F-H0-1075",691,2},
  {{{0x64e3e7b1d1204ea1}},7,"F-H0-1076",432,60},
  {{{0x64e3e7b1d1204ea1}},7,"F-H0-1077",947,32},
  {{{0xbbf0505757e11717}},7,"F-H0-1078",939,20},
  {{{0x64e3e7b1d1204ea1}},7,"F-H0-1079",839,20},
  {{{0x8bc82992d1fcbc19}},7,"F-H0-1080",802,17},
  {{{0x799d4fc9e6eaeb26}},7,"F-H0-1081",941,13},
  {{{0x64e3e7b1d1204ea1}},7,"F-H0-1082",943,6},
  {{{0x149c78eea4067dbc}},7,"F-H0-1083",947,4},
  {{{0xeffd7d4bed50c60}},6,"F-H0-1084",541,59},
  {{{0xeffd7d4bed50c60}},6,"F-H0-1085",432,54},
  {{{0x2513aa7b4795cfd1}},6,"F-H0-1086",939,51},
  {{{0xeffd7d4bed50c60}},6,"F-H0-1087",466,9},
  {{{0xeffd7d4bed50c60}},6,"F-H0-1088",615,3},
  {{{0xeffd7d4bed50c60}},6,"F-H0-1089",727,3},
  {{{0x2513aa7b4795cfd1}},6,"F-H0-1090",420,2},
  {{{0xa895044397930710}},6,"F-H0-1091",873,78},
  {{{0xa895044397930710}},6,"F-H0-1092",950,59},
  {{{0xcbda5c2f2165e09c}},6,"F-H0-1093",947,42},
  {{{0xdd8399162867d889}},6,"F-H0-1094",466,6},
  {{{0xdd8399162867d889}},6,"F-H0-1095",727,4},
  {{{0xa895044397930710}},6,"F-H0-1096",871,3},
  {{{0xcbda5c2f2165e09c}},6,"F-H0-1097",836,3},
  {{{0x4cc03251cc90a250}},6,"F-H0-1098",714,3},
  {{{0x3b564334ab59f04c}},4,"F-H0-1099",839,57},
  {{{0x1b6714cd84061acc}},4,"F-H0-1100",430,45},
  {{{0x521ec1b09f5ad3d0}},4,"F-H0-1101",825,21},
  {{{0xb510fd6d219a039d}},4,"F-H0-1102",825,11},
  {{{0x6b8df416e3b2c282}},4,"F-H0-1103",839,5},
  {{{0x521ec1b09f5ad3d0}},4,"F-H0-1104",939,4},
  {{{0xb510fd6d219a039d}},4,"F-H0-1105",863,3},
  {{{0x1335bd1afcfde5c0}},5,"F-H0-1106",420,54},
  {{{0xcb41d699c7d4fe3e}},5,"F-H0-1107",764,47},
  {{{0x8580d8be8cb5e16d}},5,"F-H0-1108",428,16},
  {{{0x1335bd1afcfde5c0}},5,"F-H0-1109",494,12},
  {{{0xcb41d699c7d4fe3e}},5,"F-H0-1110",910,12},
  {{{0xcb41d699c7d4fe3e}},5,"F-H0-1111",801,11},
  {{{0x8580d8be8cb5e16d}},5,"F-H0-1112",420,6},
  {{{0x1335bd1afcfde5c0}},5,"F-H0-1113",429,3},
  {{{0xcb41d699c7d4fe3e}},5,"F-H0-1114",947,2},
  {{{0xcb41d699c7d4fe3e}},5,"F-H0-1115",939,2},
  {{{0xa82edb85db2964f0}},3,"F-H0-1116",456,112},
  {{{0xa82edb85db2964f0}},3,"F-H0-1117",455,68},
  {{{0xf5b7d5293a214d5f}},3,"F-H0-1118",937,10},
  {{{0x737c84f8145062a8}},3,"F-H0-1119",911,8},
  {{{0xa82edb85db2964f0}},3,"F-H0-1120",492,7},
  {{{0xa82edb85db2964f0}},3,"F-H0-1121",418,3},
  {{{0xa82edb85db2964f0}},3,"F-H0-1122",419,2},
  {{{0xa82edb85db2964f0}},3,"F-H0-1123",948,2},
  {{{0x93330307378b3178}},5,"F-H0-1124",429,43},
  {{{0x5cc5ce0cef3c7e37}},5,"F-H0-1125",905,42},
  {{{0xa72522e5540b43ad}},5,"F-H0-1126",427,37},
  {{{0x93330307378b3178}},5,"F-H0-1127",875,32},
  {{{0x93330307378b3178}},5,"F-H0-1128",690,12},
  {{{0x93330307378b3178}},5,"F-H0-1129",838,11},
  {{{0x93330307378b3178}},5,"F-H0-1130",466,10},
  {{{0x5cc5ce0cef3c7e37}},5,"F-H0-1131",429,3},
  {{{0x93330307378b3178}},5,"F-H0-1132",691,2},
  {{{0x55ea6215c5ec7c04}},5,"F-H0-1133",492,2},
  {{{0x93330307378b3178}},5,"F-H0-1134",428,2},
  {{{0x93330307378b3178}},5,"F-H0-1135",616,2},
  {{{0x93330307378b3178}},5,"F-H0-1136",728,2},
  {{{0x99f739b9a80b953}},3,"F-H0-1137",912,97},
  {{{0x16d8dd55d63e5efa}},3,"F-H0-1138",899,35},
  {{{0x96c45daf26a9d522}},3,"F-H0-1139",467,17},
  {{{0xc9ab5997f4adde34}},3,"F-H0-1140",913,16},
  {{{0x99f739b9a80b953}},3,"F-H0-1141",950,13},
  {{{0x96c45daf26a9d522}},3,"F-H0-1142",420,7},
  {{{0x96c45daf26a9d522}},3,"F-H0-1143",430,5},
  {{{0x96c45daf26a9d522}},3,"F-H0-1144",492,2},
  {{{0xc9ab5997f4adde34}},3,"F-H0-1145",902,2},
  {{{0x9925e6f3f05bb8e7}},4,"F-H0-1146",468,38},
  {{{0x66db842e93ff0154}},4,"F-H0-1147",876,32},
  {{{0x66db842e93ff0154}},4,"F-H0-1148",419,30},
  {{{0x66db842e93ff0154}},4,"F-H0-1149",764,29},
  {{{0x66db842e93ff0154}},4,"F-H0-1150",802,22},
  {{{0x66db842e93ff0154}},4,"F-H0-1151",910,13},
  {{{0x66db842e93ff0154}},4,"F-H0-1152",457,7},
  {{{0x66db842e93ff0154}},4,"F-H0-1153",455,6},
  {{{0x66db842e93ff0154}},4,"F-H0-1154",874,5},
  {{{0x9925e6f3f05bb8e7}},4,"F-H0-1155",430,2},
  {{{0x304ee9a6792f8130}},4,"F-H0-1156",543,65},
  {{{0x304ee9a6792f8130}},4,"F-H0-1157",419,40},
  {{{0x304ee9a6792f8130}},4,"F-H0-1158",907,28},
  {{{0x67fd4d19671bf82d}},4,"F-H0-1159",640,27},
  {{{0xee1e6ccc59305e00}},4,"F-H0-1160",863,9},
  {{{0x585c1fa2f0561122}},4,"F-H0-1161",420,9},
  {{{0x304ee9a6792f8130}},4,"F-H0-1162",425,7},
  {{{0x304ee9a6792f8130}},4,"F-H0-1163",429,6},
  {{{0x2cc8fd92763ca174}},4,"F-H0-1164",492,3},
  {{{0x304ee9a6792f8130}},4,"F-H0-1165",418,3},
  {{{0x304ee9a6792f8130}},4,"F-H0-1166",684,2},
  {{{0x2b4c2e1f33f54cd6}},4,"F-H0-1167",862,67},
  {{{0x2b4c2e1f33f54cd6}},4,"F-H0-1168",457,62},
  {{{0x39db7797885b7ff3}},4,"F-H0-1169",839,22},
  {{{0x8be9a98e2bd7cf9b}},4,"F-H0-1170",506,8},
  {{{0x39db7797885b7ff3}},4,"F-H0-1171",529,8},
  {{{0x39db7797885b7ff3}},4,"F-H0-1172",728,7},
  {{{0x39db7797885b7ff3}},4,"F-H0-1173",429,6},
  {{{0x2b4c2e1f33f54cd6}},4,"F-H0-1174",863,4},
  {{{0x1172f9e5cae40559}},4,"F-H0-1175",903,2},
  {{{0x39db7797885b7ff3}},4,"F-H0-1176",466,2},
  {{{0x226e7ddd8cee85fb}},4,"F-H0-1177",906,2},
  {{{0xabfdea95e5831968}},3,"F-H0-1178",429,75},
  {{{0xabfdea95e5831968}},3,"F-H0-1179",617,27},
  {{{0xabfdea95e5831968}},3,"F-H0-1180",912,21},
  {{{0xabfdea95e5831968}},3,"F-H0-1181",456,14},
  {{{0xabfdea95e5831968}},3,"F-H0-1182",466,14},
  {{{0xabfdea95e5831968}},3,"F-H0-1183",653,10},
  {{{0xabfdea95e5831968}},3,"F-H0-1184",616,6},
  {{{0xabfdea95e5831968}},3,"F-H0-1185",690,5},
  {{{0xabfdea95e5831968}},3,"F-H0-1186",949,4},
  {{{0xabfdea95e5831968}},3,"F-H0-1187",913,4},
  {{{0xabfdea95e5831968}},3,"F-H0-1188",542,4},
  {{{0xabfdea95e5831968}},3,"F-H0-1189",455,3},
  {{{0xabfdea95e5831968}},3,"F-H0-1190",506,2},
  {{{0x14be8228d85a82ff}},7,"F-H0-1191",469,135},
  {{{0x14be8228d85a82ff}},7,"F-H0-1192",431,18},
  {{{0xa697bbb957ba164b}},5,"F-H0-1193",428,47},
  {{{0xf60b293c33b78675}},5,"F-H0-1194",506,44},
  {{{0x8bd61437b6da8f23}},5,"F-H0-1195",908,41},
  {{{0x45da2036e480f43b}},5,"F-H0-1196",458,9},
  {{{0xa697bbb957ba164b}},5,"F-H0-1197",504,9},
  {{{0x8178f9b96d6178cd}},5,"F-H0-1198",543,5},
  {{{0x8bd61437b6da8f23}},5,"F-H0-1199",909,5},
  {{{0xf60b293c33b78675}},5,"F-H0-1200",653,4},
  {{{0xf7778f3e96d59a91}},5,"F-H0-1201",839,3},
  {{{0x8178f9b96d6178cd}},5,"F-H0-1202",947,2},
  {{{0x45da2036e480f43b}},5,"F-H0-1203",640,2},
  {{{0xcf9df4a2be288428}},5,"F-H0-1204",543,2},
  {{{0xc2450713cb713015}},6,"F-H0-1205",765,69},
  {{{0xc2450713cb713015}},6,"F-H0-1206",910,18},
  {{{0xc2450713cb713015}},6,"F-H0-1207",678,14},
  {{{0xc2450713cb713015}},6,"F-H0-1208",838,12},
  {{{0xc2450713cb713015}},6,"F-H0-1209",727,12},
  {{{0xc2450713cb713015}},6,"F-H0-1210",837,6},
  {{{0xc2450713cb713015}},6,"F-H0-1211",690,4},
  {{{0xc2450713cb713015}},6,"F-H0-1212",764,3},
  {{{0xc2450713cb713015}},6,"F-H0-1213",874,3},
  {{{0xc2450713cb713015}},6,"F-H0-1214",457,2},
  {{{0xc2450713cb713015}},6,"F-H0-1215",677,2},
  {{{0xee07c2ac61c29c35}},5,"F-H0-1216",429,62},
  {{{0x2b2fa2395e29e0c6}},5,"F-H0-1217",801,34},
  {{{0x2b2fa2395e29e0c6}},5,"F-H0-1218",690,14},
  {{{0x2b2fa2395e29e0c6}},5,"F-H0-1219",691,7},
  {{{0x2b2fa2395e29e0c6}},5,"F-H0-1220",461,7},
  {{{0x2b2fa2395e29e0c6}},5,"F-H0-1221",764,6},
  {{{0xee07c2ac61c29c35}},5,"F-H0-1222",944,5},
  {{{0xee07c2ac61c29c35}},5,"F-H0-1223",907,5},
  {{{0xf64271cd072aa95b}},5,"F-H0-1224",690,4},
  {{{0x2b2fa2395e29e0c6}},5,"F-H0-1225",424,3},
  {{{0x2b2fa2395e29e0c6}},5,"F-H0-1226",839,3},
  {{{0x2b2fa2395e29e0c6}},5,"F-H0-1227",421,2},
  {{{0xee07c2ac61c29c35}},5,"F-H0-1228",875,2},
  {{{0xc7c9836f28786cb8}},5,"F-H0-1229",529,73},
  {{{0x4b80351106d15580}},5,"F-H0-1230",910,19},
  {{{0x4b80351106d15580}},5,"F-H0-1231",727,18},
  {{{0x4b80351106d15580}},5,"F-H0-1232",765,13},
  {{{0x4b80351106d15580}},5,"F-H0-1233",946,9},
  {{{0x4b80351106d15580}},5,"F-H0-1234",690,8},
  {{{0x4b80351106d15580}},5,"F-H0-1235",654,5},
  {{{0xb22c4e9546a37b78}},5,"F-H0-1236",530,4},
  {{{0x4b80351106d15580}},5,"F-H0-1237",728,2},
  {{{0x4b80351106d15580}},5,"F-H0-1238",684,2},
  {{{0xa28f91d2a4c1f36c}},5,"F-H0-1239",876,40},
  {{{0x6458ffd5d995fc7}},5,"F-H0-1240",530,23},
  {{{0x2acc9bd7099b56a4}},5,"F-H0-1241",945,11},
  {{{0x6458ffd5d995fc7}},5,"F-H0-1242",839,10},
  {{{0xa28f91d2a4c1f36c}},5,"F-H0-1243",913,9},
  {{{0x6458ffd5d995fc7}},5,"F-H0-1244",825,8},
  {{{0x6458ffd5d995fc7}},5,"F-H0-1245",567,7},
  {{{0xa28f91d2a4c1f36c}},5,"F-H0-1246",727,4},
  {{{0xa28f91d2a4c1f36c}},5,"F-H0-1247",837,3},
  {{{0x50e6abec361afaca}},5,"F-H0-1248",654,3},
  {{{0x6458ffd5d995fc7}},5,"F-H0-1249",462,3},
  {{{0x6458ffd5d995fc7}},5,"F-H0-1250",943,2},
  {{{0x6458ffd5d995fc7}},5,"F-H0-1251",947,2},
  {{{0x6ada1ddeaab10d2c}},3,"F-H0-1252",456,101},
  {{{0x4bdb6d30631fdd46}},3,"F-H0-1253",913,16},
  {{{0x4bdb6d30631fdd46}},3,"F-H0-1254",863,15},
  {{{0x4bdb6d30631fdd46}},3,"F-H0-1255",950,14},
  {{{0x6ada1ddeaab10d2c}},3,"F-H0-1256",938,11},
  {{{0x4bdb6d30631fdd46}},3,"F-H0-1257",876,5},
  {{{0x4bdb6d30631fdd46}},3,"F-H0-1258",949,3},
  {{{0x4bdb6d30631fdd46}},3,"F-H0-1259",911,3},
  {{{0x4bdb6d30631fdd46}},3,"F-H0-1260",505,3},
  {{{0x4bdb6d30631fdd46}},3,"F-H0-1261",875,2},
  {{{0x284afb7cdb015d24}},3,"F-H0-1262",900,84},
  {{{0xc7d5cabd3007f50b}},3,"F-H0-1263",419,23},
  {{{0x7e1e0b15e2a926c}},3,"F-H0-1264",505,19},
  {{{0x77f1074d812a622f}},3,"F-H0-1265",862,10},
  {{{0xc7d5cabd3007f50b}},3,"F-H0-1266",418,7},
  {{{0x98bace85e203fe1d}},3,"F-H0-1267",913,7},
  {{{0xc7d5cabd3007f50b}},3,"F-H0-1268",420,3},
  {{{0x77f1074d812a622f}},3,"F-H0-1269",826,2},
  {{{0xa27195a22af66da9}},6,"F-H0-1270",862,80},
  {{{0x6c018d949dceca54}},6,"F-H0-1271",908,36},
  {{{0x1e1cf8b20f0865a}},6,"F-H0-1272",940,23},
  {{{0x6c018d949dceca54}},6,"F-H0-1273",874,4},
  {{{0x6c018d949dceca54}},6,"F-H0-1274",838,2},
  {{{0x12232c47d6851f0b}},6,"F-H0-1275",690,67},
  {{{0x12232c47d6851f0b}},6,"F-H0-1276",470,41},
  {{{0x6b27bf1c511d8b2d}},6,"F-H0-1277",641,7},
  {{{0x3d0176ceaed5bc18}},6,"F-H0-1278",875,7},
  {{{0x45e3df4979d14e34}},6,"F-H0-1279",865,4},
  {{{0x12232c47d6851f0b}},6,"F-H0-1280",728,3},
  {{{0x12232c47d6851f0b}},6,"F-H0-1281",802,2},
  {{{0x12232c47d6851f0b}},6,"F-H0-1282",420,2},
  {{{0x12232c47d6851f0b}},6,"F-H0-1283",906,2},
  {{{0x45c5659ba9304e1}},9,"F-H0-1284",467,133},
  {{{0x5cddf8238fd80e46}},9,"F-H0-1285",395,3},
  {{{0x2f85e4f21772301}},8,"F-H0-1286",431,141},
  {{{0x75fe153133106a18}},4,"F-H0-1287",505,107},
  {{{0x75fe153133106a18}},4,"F-H0-1288",506,24},
  {{{0x722878877cabebe7}},4,"F-H0-1289",728,12},
  {{{0x75fe153133106a18}},4,"F-H0-1290",907,12},
  {{{0x75fe153133106a18}},4,"F-H0-1291",543,9},
  {{{0x75fe153133106a18}},4,"F-H0-1292",542,8},
  {{{0x75fe153133106a18}},4,"F-H0-1293",529,4},
  {{{0x75fe153133106a18}},4,"F-H0-1294",653,2},
  {{{0xa151a90b6028aef0}},3,"F-H0-1295",505,32},
  {{{0xeaf20c8901dec9b4}},3,"F-H0-1296",901,27},
  {{{0x355b92c26f765b9e}},3,"F-H0-1297",468,19},
  {{{0x355b92c26f765b9e}},3,"F-H0-1298",431,11},
  {{{0xe2ebab617c5d3726}},3,"F-H0-1299",876,8},
  {{{0xa151a90b6028aef0}},3,"F-H0-1300",430,5},
  {{{0xe2ebab617c5d3726}},3,"F-H0-1301",874,4},
  {{{0x355b92c26f765b9e}},3,"F-H0-1302",939,4},
  {{{0xa151a90b6028aef0}},3,"F-H0-1303",542,3},
  {{{0x26902186d1892149}},3,"F-H0-1304",458,2},
  {{{0xa5f87afa92a0ffc8}},8,"F-H0-1305",911,82},
  {{{0x5b24c8a45e0eb32c}},8,"F-H0-1306",455,58},
  {{{0xa5f87afa92a0ffc8}},8,"F-H0-1307",945,4},
  {{{0xa5f87afa92a0ffc8}},8,"F-H0-1308",529,3},
  {{{0xa5f87afa92a0ffc8}},8,"F-H0-1309",908,2},
  {{{0xb9301d5403364f3e}},7,"F-H0-1310",909,105},
  {{{0x2b3fc767f8310a2f}},7,"F-H0-1311",863,7},
  {{{0xfe3c9953ec8232ed}},3,"F-H0-1312",974,7},
  {{{0xa718b9288205c5c8}},3,"F-H0-1313",456,5},
  {{{0x3a7c6e76161c24c7}},3,"F-H0-1314",899,4},
  {{{0xfe3c9953ec8232ed}},3,"F-H0-1315",751,4},
  {{{0xfe3c9953ec8232ed}},3,"F-H0-1316",936,3},
  {{{0xfe3c9953ec8232ed}},3,"F-H0-1317",937,3},
  {{{0xfe3c9953ec8232ed}},3,"F-H0-1318",911,3},
  {{{0xfe3c9953ec8232ed}},3,"F-H0-1319",906,2},
  {{{0xfe3c9953ec8232ed}},3,"F-H0-1320",905,2},
  {{{0xa718b9288205c5c8}},3,"F-H0-1321",903,2},
  {{{0xa718b9288205c5c8}},3,"F-H0-1322",865,2},
  {{{0xa718b9288205c5c8}},3,"F-H0-1323",949,2},
  {{{0x63c35b95a6e67fac}},3,"F-H0-1324",431,2},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1325",468,46},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1326",456,35},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1327",455,8},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1328",900,8},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1329",493,5},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1330",469,4},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1331",684,4},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1332",504,3},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1333",875,3},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1334",937,3},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1335",505,3},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1336",948,2},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1337",913,2},
  {{{0x95bc4f15fca74ddd}},1,"F-H0-1338",458,2},
  {{{0xa921036cdc0e90ea}},13,"F-H0-1339",506,127},
  {{{0xd40b82e8ecaf5a47}},13,"F-H0-1340",528,7},
  {{{0x2b0ba1950fd919b7}},12,"F-H0-1341",433,139},
  {{{0xdd94d764866b3139}},10,"F-H0-1342",470,139},
  {{{0xa87a62daa7c6ffd6}},11,"F-H0-1343",507,133},
  {{{0xfa14d8dbbd72fcbf}},5,"F-H0-1344",876,42},
  {{{0xfa14d8dbbd72fcbf}},5,"F-H0-1345",764,32},
  {{{0xba831a75cc7c8da2}},5,"F-H0-1346",946,30},
  {{{0xba831a75cc7c8da2}},5,"F-H0-1347",838,17},
  {{{0xba831a75cc7c8da2}},5,"F-H0-1348",874,7},
  {{{0xba831a75cc7c8da2}},5,"F-H0-1349",839,4},
  {{{0xc41505752711ef6f}},5,"F-H0-1350",939,4},
  {{{0x92fa98593f6cfe94}},5,"F-H0-1351",939,4},
  {{{0x92fa98593f6cfe94}},5,"F-H0-1352",567,3},
  {{{0x92fa98593f6cfe94}},5,"F-H0-1353",461,2},
  {{{0xba831a75cc7c8da2}},5,"F-H0-1354",543,2},
  {{{0x92fa98593f6cfe94}},5,"F-H0-1355",429,2},
  {{{0xb80e383280440166}},5,"F-H0-1356",677,55},
  {{{0xae65abcbfb58f1e5}},5,"F-H0-1357",944,49},
  {{{0xb08c9f9789cc66cd}},5,"F-H0-1358",543,22},
  {{{0xf091068c7562e9dd}},5,"F-H0-1359",690,22},
  {{{0xf091068c7562e9dd}},5,"F-H0-1360",462,5},
  {{{0xb80e383280440166}},5,"F-H0-1361",947,2},
  {{{0xf091068c7562e9dd}},5,"F-H0-1362",910,2},
  {{{0xf091068c7562e9dd}},5,"F-H0-1363",580,2},
  {{{0xb08c9f9789cc66cd}},5,"F-H0-1364",426,2},
  {{{0xb80e383280440166}},5,"F-H0-1365",943,2},
  {{{0xf091068c7562e9dd}},5,"F-H0-1366",543,2},
  {{{0x7cf2b30fb8f61403}},14,"F-H0-1367",429,135},
  {{{0x43214b83bbbddcc4}},15,"F-H0-1368",939,54},
  {{{0xb3334c66102e0334}},15,"F-H0-1369",839,53},
  {{{0x1e4282131242c93f}},15,"F-H0-1370",426,11},
  {{{0x43214b83bbbddcc4}},15,"F-H0-1371",496,7},
  {{{0xb3334c66102e0334}},15,"F-H0-1372",825,5},
  {{{0xb5c9c8e019ea0cbf}},15,"F-H0-1373",902,2},
  {{{0xb3334c66102e0334}},15,"F-H0-1374",939,2},
  {{{0x96921b98d15ca2c0}},6,"F-H0-1375",902,81},
  {{{0x213933fc31e91d85}},6,"F-H0-1376",941,13},
  {{{0x8a685aaecb7f1b0d}},6,"F-H0-1378",678,6},
  {{{0x213933fc31e91d85}},6,"F-H0-1379",905,5},
  {{{0x4b74f8afecc6f364}},6,"F-H0-1380",939,2},
  {{{0x96921b98d15ca2c0}},6,"F-H0-1381",940,2},
  {{{0xd5d1611672015cf4}},8,"F-H0-1382",827,18},
  {{{0x438367cf887c14f2}},8,"F-H0-1384",948,5},
  {{{0x7dc726cfe69df266}},7,"F-H0-1385",432,42},
  {{{0xaef8d83b5d713275}},7,"F-H0-1386",940,10},
  {{{0xf2a4e113e0ec33fe}},7,"F-H0-1387",839,8},
  {{{0xaef8d83b5d713275}},7,"F-H0-1388",941,7},
  {{{0xf2a4e113e0ec33fe}},7,"F-H0-1389",825,2},
  {{{0x7dc726cfe69df266}},7,"F-H0-1390",578,2},
  {{{0x7dc726cfe69df266}},7,"F-H0-1391",615,2},
  {{{0x29d9c5a942d3a99c}},9,"F-H0-1392",529,132},
  {{{0x8d863dfb815fa72c}},9,"F-H0-1393",505,5},
  {{{0xeeae93ac86a23514}},6,"F-H0-1394",936,69},
  {{{0xeeae93ac86a23514}},6,"F-H0-1395",827,64},
  {{{0x8ff06a9bf547a0f9}},6,"F-H0-1396",909,6},
  {{{0x6798962b49daa0f3}},6,"F-H0-1397",383,6},
  {{{0x6798962b49daa0f3}},6,"F-H0-1398",456,5},
  {{{0x6798962b49daa0f3}},6,"F-H0-1399",543,4},
  {{{0xfa84aa9450605c4f}},6,"F-H0-1400",457,2},
  {{{0x6798962b49daa0f3}},6,"F-H0-1401",429,2},
  {{{0x6798962b49daa0f3}},6,"F-H0-1402",419,2},
  {{{0x6798962b49daa0f3}},6,"F-H0-1403",906,2},
  {{{0xe6b8b04b986944a1}},6,"F-H0-1404",429,2},
  {{{0xadc3493e5e7fcea7}},7,"F-H0-1405",494,112},
  {{{0xe206530edc376d8d}},7,"F-H0-1406",912,18},
  {{{0xe206530edc376d8d}},7,"F-H0-1407",837,15},
  {{{0x330385c96c38a05}},7,"F-H0-1408",939,3},
  {{{0x514b1c696ed1ad0b}},2,"F-H0-1409",938,17},
  {{{0xaaf7926ee1f442ae}},2,"F-H0-1410",913,12},
  {{{0xaaf7926ee1f442ae}},2,"F-H0-1411",902,9},
  {{{0x514b1c696ed1ad0b}},2,"F-H0-1412",912,8},
  {{{0xa93112958373d391}},2,"F-H0-1413",460,6},
  {{{0xaaf7926ee1f442ae}},2,"F-H0-1414",788,5},
  {{{0x514b1c696ed1ad0b}},2,"F-H0-1415",456,5},
  {{{0x514b1c696ed1ad0b}},2,"F-H0-1416",468,4},
  {{{0x8f360393b4c98b98}},2,"F-H0-1417",909,4},
  {{{0xaaf7926ee1f442ae}},2,"F-H0-1418",455,4},
  {{{0x514b1c696ed1ad0b}},2,"F-H0-1419",825,4},
  {{{0x514b1c696ed1ad0b}},2,"F-H0-1420",469,2},
  {{{0xaaf7926ee1f442ae}},2,"F-H0-1421",864,2},
  {{{0xaaf7926ee1f442ae}},2,"F-H0-1422",469,2},
  {{{0x7e973b56be424848}},4,"F-H0-1423",911,83},
  {{{0x7e973b56be424848}},4,"F-H0-1424",948,42},
  {{{0x1c11aba71515ee3e}},4,"F-H0-1425",838,5},
  {{{0x1c11aba71515ee3e}},4,"F-H0-1426",684,3},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1427",825,46},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1428",801,37},
  {{{0x7338c198f301846e}},5,"F-H0-1429",462,12},
  {{{0x7338c198f301846e}},5,"F-H0-1430",460,6},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1431",728,6},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1432",691,5},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1433",678,4},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1434",461,4},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1435",727,4},
  {{{0x7338c198f301846e}},5,"F-H0-1436",421,4},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1437",424,3},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1438",838,3},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1439",715,3},
  {{{0x75359e9f4cb817cf}},5,"F-H0-1440",875,3},
  {{{0x12c630185b43adca}},5,"F-H0-1441",938,2},
  {{{0x9c9a12a0ad7f62d7}},5,"F-H0-1442",580,2},
  {{{0xf6db88c42b102461}},2,"F-H0-1443",912,77},
  {{{0xf6db88c42b102461}},2,"F-H0-1444",913,44},
  {{{0xf6db88c42b102461}},2,"F-H0-1445",468,18},
  {{{0xf6db88c42b102461}},2,"F-H0-1446",949,13},
  {{{0xf6db88c42b102461}},2,"F-H0-1447",875,8},
  {{{0xf6db88c42b102461}},2,"F-H0-1448",876,6},
  {{{0xd517fccceef269e8}},5,"F-H0-1449",946,36},
  {{{0x3b2a9f3493f7f870}},5,"F-H0-1450",604,35},
  {{{0x3b2a9f3493f7f870}},5,"F-H0-1451",492,26},
  {{{0x4bcba7b92baa044a}},5,"F-H0-1452",466,10},
  {{{0x3b2a9f3493f7f870}},5,"F-H0-1453",494,7},
  {{{0xd517fccceef269e8}},5,"F-H0-1454",839,5},
  {{{0xd517fccceef269e8}},5,"F-H0-1455",909,3},
  {{{0x4bcba7b92baa044a}},5,"F-H0-1456",947,3},
  {{{0x3b2a9f3493f7f870}},5,"F-H0-1457",825,2},
  {{{0x90df8fd8d91a3837}},4,"F-H0-1458",505,35},
  {{{0x2b5cc22a4c1e1a5a}},4,"F-H0-1459",911,32},
  {{{0x90df8fd8d91a3837}},4,"F-H0-1460",641,26},
  {{{0x85b8e11ced1a7502}},4,"F-H0-1461",944,18},
  {{{0x85b8e11ced1a7502}},4,"F-H0-1462",948,15},
  {{{0x93834947a29a0c76}},4,"F-H0-1463",906,8},
  {{{0x2b5cc22a4c1e1a5a}},4,"F-H0-1464",910,5},
  {{{0x2b5cc22a4c1e1a5a}},4,"F-H0-1465",948,5},
  {{{0xc0d91edbacf3fb8d}},4,"F-H0-1466",876,5},
  {{{0x85b8e11ced1a7502}},4,"F-H0-1467",425,5},
  {{{0x90df8fd8d91a3837}},4,"F-H0-1468",690,2},
  {{{0xe86cf3ad2374942e}},4,"F-H0-1469",939,2},
  {{{0x2b5cc22a4c1e1a5a}},4,"F-H0-1470",690,2},
  {{{0xa3e462d340f1adb8}},10,"F-H0-1471",462,70},
  {{{0xa3e462d340f1adb8}},10,"F-H0-1472",425,44},
  {{{0xf8ba0a7a6bf07787}},10,"F-H0-1473",939,7},
  {{{0xa3e462d340f1adb8}},10,"F-H0-1474",426,3},
  {{{0xa3e462d340f1adb8}},10,"F-H0-1475",463,2},
  {{{0x47ce2095c1e60174}},4,"F-H0-1476",543,44},
  {{{0x47ce2095c1e60174}},4,"F-H0-1477",938,28},
  {{{0x5a05dc75a4163177}},4,"F-H0-1478",691,12},
  {{{0x47ce2095c1e60174}},4,"F-H0-1479",421,9},
  {{{0x47ce2095c1e60174}},4,"F-H0-1480",911,7},
  {{{0x47ce2095c1e60174}},4,"F-H0-1481",943,4},
  {{{0x5a05dc75a4163177}},4,"F-H0-1482",678,3},
  {{{0x5a05dc75a4163177}},4,"F-H0-1483",825,2},
  {{{0x2f26d1ec6927a4f3}},7,"F-H0-1484",873,52},
  {{{0x1495093ce8703c29}},7,"F-H0-1485",432,51},
  {{{0x7a66c720314255bf}},7,"F-H0-1486",939,16},
  {{{0x7a66c720314255bf}},7,"F-H0-1487",752,8},
  {{{0x7a66c720314255bf}},7,"F-H0-1488",902,6},
  {{{0x21d52db717867ca9}},7,"F-H0-1489",947,33},
  {{{0x21d52db717867ca9}},7,"F-H0-1490",825,32},
  {{{0x21d52db717867ca9}},7,"F-H0-1491",943,18},
  {{{0x21d52db717867ca9}},7,"F-H0-1492",470,6},
  {{{0x21d52db717867ca9}},7,"F-H0-1493",939,4},
  {{{0x66698df5b7cd9bce}},7,"F-H0-1494",691,4},
  {{{0xcf59d694d0b484e5}},7,"F-H0-1495",462,2},
  {{{0x21d52db717867ca9}},7,"F-H0-1496",615,2},
  {{{0x21d52db717867ca9}},7,"F-H0-1497",462,2},
  {{{0x1df2548cb20a1e74}},2,"F-H0-1498",876,13},
  {{{0x1df2548cb20a1e74}},2,"F-H0-1499",492,9},
  {{{0x156c2ce18ad3d60e}},2,"F-H0-1500",863,8},
  {{{0x1df2548cb20a1e74}},2,"F-H0-1501",913,7},
  {{{0xf6b7e36b9b48eabd}},2,"F-H0-1502",876,6},
  {{{0xf6b7e36b9b48eabd}},2,"F-H0-1503",912,6},
  {{{0x1df2548cb20a1e74}},2,"F-H0-1504",912,6},
  {{{0xf6b7e36b9b48eabd}},2,"F-H0-1505",913,6},
  {{{0x1df2548cb20a1e74}},2,"F-H0-1506",911,5},
  {{{0x1df2548cb20a1e74}},2,"F-H0-1507",948,4},
  {{{0xf6b7e36b9b48eabd}},2,"F-H0-1508",911,4},
  {{{0xf6b7e36b9b48eabd}},2,"F-H0-1509",875,3},
  {{{0x1df2548cb20a1e74}},2,"F-H0-1510",949,2},
  {{{0xf6b7e36b9b48eabd}},2,"F-H0-1511",949,2},
  {{{0x3c671df0b57509e6}},6,"F-H0-1512",902,56},
  {{{0x2d6f34cad1a7e717}},6,"F-H0-1513",941,26},
  {{{0x3c671df0b57509e6}},6,"F-H0-1514",715,15},
  {{{0x3c671df0b57509e6}},6,"F-H0-1515",939,11},
  {{{0x3b4d9e688b772af4}},6,"F-H0-1516",466,4},
  {{{0x3c671df0b57509e6}},6,"F-H0-1517",690,3},
  {{{0x3c671df0b57509e6}},6,"F-H0-1518",752,3},
  {{{0x3c671df0b57509e6}},6,"F-H0-1519",940,2},
  {{{0x3c671df0b57509e6}},6,"F-H0-1520",714,2},
  {{{0x3b4d9e688b772af4}},6,"F-H0-1521",462,2},
  {{{0x3c671df0b57509e6}},6,"F-H0-1522",827,2},
  {{{0x3c671df0b57509e6}},6,"F-H0-1523",677,2},
  {{{0xc64c15098f27da43}},4,"F-H0-1524",543,47},
  {{{0xc64c15098f27da43}},4,"F-H0-1525",529,19},
  {{{0xc64c15098f27da43}},4,"F-H0-1526",425,8},
  {{{0xe2a7cf5f403c8684}},4,"F-H0-1527",690,7},
  {{{0x3880fdb283af60f3}},4,"F-H0-1528",640,3},
  {{{0xe2a7cf5f403c8684}},4,"F-H0-1529",727,3},
  {{{0xc0fca0c2e37fd791}},4,"F-H0-1530",543,3},
  {{{0xc0fca0c2e37fd791}},4,"F-H0-1531",464,2},
  {{{0xc0fca0c2e37fd791}},4,"F-H0-1532",418,2},
  {{{0x3880fdb283af60f3}},4,"F-H0-1533",530,2},
  {{{0xc64c15098f27da43}},4,"F-H0-1534",944,2},
  {{{0x9ee7a69d47af763f}},4,"F-H0-1535",506,2},
  {{{0xc64c15098f27da43}},4,"F-H0-1536",421,2},
  {{{0x8c68f096d80d80ee}},5,"F-H0-1537",911,25},
  {{{0xd100e04cdb0739a2}},5,"F-H0-1538",904,25},
  {{{0x8c68f096d80d80ee}},5,"F-H0-1539",506,25},
  {{{0x8c68f096d80d80ee}},5,"F-H0-1540",580,24},
  {{{0x8c68f096d80d80ee}},5,"F-H0-1541",948,10},
  {{{0x8c68f096d80d80ee}},5,"F-H0-1542",466,8},
  {{{0x8c68f096d80d80ee}},5,"F-H0-1543",504,6},
  {{{0xaefebd9118a1dc7c}},5,"F-H0-1544",458,4},
  {{{0x8c68f096d80d80ee}},5,"F-H0-1545",653,3},
  {{{0x8c68f096d80d80ee}},5,"F-H0-1546",654,2},
  {{{0xe4dba82f4b932d56}},4,"F-H0-1547",467,38},
  {{{0xe4dba82f4b932d56}},4,"F-H0-1548",944,19},
  {{{0xf5d12764f1dd8dc9}},4,"F-H0-1549",543,17},
  {{{0xe4dba82f4b932d56}},4,"F-H0-1550",907,14},
  {{{0xe4dba82f4b932d56}},4,"F-H0-1551",466,9},
  {{{0xb6a8e0aa94c89b04}},4,"F-H0-1552",492,8},
  {{{0xfcf374a64ec644e4}},4,"F-H0-1553",876,7},
  {{{0xe4dba82f4b932d56}},4,"F-H0-1554",690,6},
  {{{0xe4dba82f4b932d56}},4,"F-H0-1555",429,3},
  {{{0xe4dba82f4b932d56}},4,"F-H0-1556",543,2},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1557",911,36},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1558",947,32},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1559",825,23},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1560",910,11},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1561",948,8},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1562",462,5},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1563",470,5},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1564",425,3},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1565",906,3},
  {{{0x8aed91ba918d5e25}},7,"F-H0-1566",568,2},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1567",943,2},
  {{{0x5bb6f41dfc3c7a32}},7,"F-H0-1568",944,2},
  {{{0xb845ce54834bf923}},3,"F-H0-1569",911,42},
  {{{0xb52d0964233b364}},3,"F-H0-1570",468,15},
  {{{0xda591f9cea9ff980}},3,"F-H0-1571",492,11},
  {{{0xda591f9cea9ff980}},3,"F-H0-1572",420,9},
  {{{0xde2655d2e6bbeb6}},3,"F-H0-1573",469,9},
  {{{0xde2655d2e6bbeb6}},3,"F-H0-1574",467,6},
  {{{0x40f1751423c5d420}},3,"F-H0-1575",899,4},
  {{{0xde2655d2e6bbeb6}},3,"F-H0-1576",825,3},
  {{{0xde2655d2e6bbeb6}},3,"F-H0-1577",943,3},
  {{{0xda591f9cea9ff980}},3,"F-H0-1578",838,2},
  {{{0x1a0aa8089015053d}},6,"F-H0-1579",911,44},
  {{{0x69af0972e8076b07}},6,"F-H0-1580",906,29},
  {{{0x1a0aa8089015053d}},6,"F-H0-1581",727,24},
  {{{0x1a0aa8089015053d}},6,"F-H0-1582",875,9},
  {{{0x29d72559f9315fe1}},6,"F-H0-1583",939,3},
  {{{0x1a0aa8089015053d}},6,"F-H0-1584",728,2},
  {{{0xaea55b6c19bb0ee7}},6,"F-H0-1585",458,2},
  {{{0x1a0aa8089015053d}},6,"F-H0-1586",874,2},
  {{{0xdaa734948afe898b}},5,"F-H0-1587",939,87},
  {{{0xdaa734948afe898b}},5,"F-H0-1588",906,6},
  {{{0x292d147ff3230c1}},5,"F-H0-1589",430,5},
  {{{0xdaa734948afe898b}},5,"F-H0-1590",691,4},
  {{{0xdaa734948afe898b}},5,"F-H0-1591",684,3},
  {{{0xdaa734948afe898b}},5,"F-H0-1592",543,2},
  {{{0x48473d5b60093c2a}},5,"F-H0-1593",911,71},
  {{{0x7967a253df22549}},5,"F-H0-1594",691,21},
  {{{0x48473d5b60093c2a}},5,"F-H0-1595",947,17},
  {{{0x7967a253df22549}},5,"F-H0-1596",838,8},
  {{{0x48473d5b60093c2a}},5,"F-H0-1597",948,6},
  {{{0x48473d5b60093c2a}},5,"F-H0-1598",944,5},
  {{{0x7928baaae8e02ff5}},5,"F-H0-1599",714,3},
  {{{0x48473d5b60093c2a}},5,"F-H0-1600",420,2},
  {{{0x7928baaae8e02ff5}},5,"F-H0-1601",727,2},
  {{{0xb027e102a979f76f}},8,"F-H0-1602",937,105},
  {{{0x30290856fd99ee35}},8,"F-H0-1603",937,5},
  {{{0x6ce826eac36794b2}},5,"F-H0-1604",616,58},
  {{{0xc27b13997c693f2}},5,"F-H0-1605",911,17},
  {{{0xc27b13997c693f2}},5,"F-H0-1606",802,14},
  {{{0xe666bcdb436efbce}},5,"F-H0-1607",424,10},
  {{{0xe666bcdb436efbce}},5,"F-H0-1608",423,6},
  {{{0xe666bcdb436efbce}},5,"F-H0-1609",459,6},
  {{{0xc043c36068a94a05}},5,"F-H0-1610",543,4},
  {{{0x1aa13e7330aaddb0}},5,"F-H0-1611",458,4},
  {{{0xc27b13997c693f2}},5,"F-H0-1612",727,2},
  {{{0x1aa13e7330aaddb0}},5,"F-H0-1613",493,2},
  {{{0xc043c36068a94a05}},5,"F-H0-1614",937,2},
  {{{0xc27b13997c693f2}},5,"F-H0-1615",825,2},
  {{{0x7c5ba7f5a847dbc}},5,"F-H0-1616",947,2},
  {{{0xac354821df9e5cd4}},3,"F-H0-1617",506,26},
  {{{0x7108ac6d11ff44f8}},3,"F-H0-1618",431,18},
  {{{0xac354821df9e5cd4}},3,"F-H0-1619",468,16},
  {{{0x7108ac6d11ff44f8}},3,"F-H0-1620",506,14},
  {{{0x7108ac6d11ff44f8}},3,"F-H0-1621",467,12},
  {{{0x84bd144be4a9fac8}},3,"F-H0-1622",901,8},
  {{{0xac354821df9e5cd4}},3,"F-H0-1623",825,5},
  {{{0xac354821df9e5cd4}},3,"F-H0-1624",947,2},
  {{{0x5f128a78e82b5771}},2,"F-H0-1625",912,53},
  {{{0x5f128a78e82b5771}},2,"F-H0-1626",468,30},
  {{{0x5f128a78e82b5771}},2,"F-H0-1627",913,21},
  {{{0xa9c7c52b99201353}},2,"F-H0-1628",937,6},
  {{{0xa450ce654998999c}},2,"F-H0-1629",875,3},
  {{{0xa9c7c52b99201353}},2,"F-H0-1630",467,3},
  {{{0xa450ce654998999c}},2,"F-H0-1631",462,3},
  {{{0x5f128a78e82b5771}},2,"F-H0-1632",876,3},
  {{{0xa450ce654998999c}},2,"F-H0-1633",647,2},
  {{{0x5f128a78e82b5771}},2,"F-H0-1634",648,2},
  {{{0x32d9f90f539f5a83}},4,"F-H0-1635",506,32},
  {{{0x4a31385dd46d35f3}},4,"F-H0-1636",908,26},
  {{{0x4a31385dd46d35f3}},4,"F-H0-1637",431,20},
  {{{0xa40c5ba5a968a46b}},4,"F-H0-1638",458,19},
  {{{0x4a31385dd46d35f3}},4,"F-H0-1639",468,17},
  {{{0xee4162949e212f8}},4,"F-H0-1640",940,9},
  {{{0x4a31385dd46d35f3}},4,"F-H0-1641",909,7},
  {{{0x4a31385dd46d35f3}},4,"F-H0-1642",874,3},
  {{{0x4a31385dd46d35f3}},4,"F-H0-1643",802,2},
  {{{0x4a31385dd46d35f3}},4,"F-H0-1644",839,2},
  {{{0x98b8ccd573d3536e}},3,"F-H0-1645",456,44},
  {{{0x98b8ccd573d3536e}},3,"F-H0-1646",419,35},
  {{{0x98b8ccd573d3536e}},3,"F-H0-1647",467,10},
  {{{0x98b8ccd573d3536e}},3,"F-H0-1648",418,9},
  {{{0xaaf3daa5d3329df9}},3,"F-H0-1649",419,7},
  {{{0xb45ffd1e829d3b6c}},3,"F-H0-1650",876,7},
  {{{0x68286257a14952b1}},3,"F-H0-1651",938,3},
  {{{0x492a9e3653af0894}},3,"F-H0-1652",911,3},
  {{{0xb45ffd1e829d3b6c}},3,"F-H0-1653",506,2},
  {{{0x98b8ccd573d3536e}},3,"F-H0-1654",876,2},
  {{{0xb45ffd1e829d3b6c}},3,"F-H0-1655",911,2},
  {{{0xcc6c43b307597636}},4,"F-H0-1656",906,44},
  {{{0xcc6c43b307597636}},4,"F-H0-1657",457,40},
  {{{0xcc6c43b307597636}},4,"F-H0-1658",431,13},
  {{{0xcc6c43b307597636}},4,"F-H0-1659",467,10},
  {{{0xcc6c43b307597636}},4,"F-H0-1660",458,6},
  {{{0xd3a72df91aa748f6}},4,"F-H0-1661",948,4},
  {{{0xcc6c43b307597636}},4,"F-H0-1662",421,4},
  {{{0xcc6c43b307597636}},4,"F-H0-1663",425,3},
  {{{0xd3a72df91aa748f6}},4,"F-H0-1664",684,2},
  {{{0xcc6c43b307597636}},4,"F-H0-1665",426,2},
  {{{0xcc6c43b307597636}},4,"F-H0-1666",690,2},
  {{{0xd3a72df91aa748f6}},4,"F-H0-1667",906,2},
  {{{0xec2b365f03467198}},3,"F-H0-1668",418,35},
  {{{0xec2b365f03467198}},3,"F-H0-1669",455,28},
  {{{0x44676b361bc470f7}},3,"F-H0-1670",468,9},
  {{{0xec2b365f03467198}},3,"F-H0-1671",492,5},
  {{{0x44676b361bc470f7}},3,"F-H0-1672",431,3},
  {{{0xa5c7b72958290a27}},3,"F-H0-1673",690,2},
  {{{0xce21e5410342bfa2}},3,"F-H0-1674",947,2},
  {{{0x72fed98d5184a9f2}},3,"F-H0-1675",911,2},
  {{{0xdd0fa3cc2cf00311}},9,"F-H0-1676",899,111},
  {{{0xa96538d90f2c80a0}},11,"F-H0-1677",824,95},
  {{{0x6092ea6a00dece86}},11,"F-H0-1678",987,11},
  {{{0x6092ea6a00dece86}},11,"F-H0-1679",838,8},
  {{{0xd4646edde25fbb7a}},10,"F-H0-1680",863,105},
  {{{0x6edd5b8233e08464}},7,"F-H0-1681",469,97},
  {{{0x6edd5b8233e08464}},7,"F-H0-1682",431,10},
  {{{0xa41296ef3ee854bc}},5,"F-H0-1683",677,80},
  {{{0x947bd4c011bc7e7}},5,"F-H0-1684",944,10},
  {{{0xf114d576e4d9b4c5}},5,"F-H0-1685",839,8},
  {{{0x947bd4c011bc7e7}},5,"F-H0-1686",939,7},
  {{{0xa41296ef3ee854bc}},5,"F-H0-1687",678,6},
  {{{0xf114d576e4d9b4c5}},5,"F-H0-1688",463,3},
  {{{0x947bd4c011bc7e7}},5,"F-H0-1689",421,2},
  {{{0x947bd4c011bc7e7}},5,"F-H0-1690",942,2},
  {{{0x4856c7aa11129db8}},8,"F-H0-1691",826,84},
  {{{0x3d688124a0bdbc64}},8,"F-H0-1692",801,3},
  {{{0x257a4000fa1e7c22}},3,"F-H0-1693",430,28},
  {{{0x99d71cb0b501420}},3,"F-H0-1694",456,23},
  {{{0x257a4000fa1e7c22}},3,"F-H0-1695",949,21},
  {{{0x257a4000fa1e7c22}},3,"F-H0-1696",467,13},
  {{{0x257a4000fa1e7c22}},3,"F-H0-1697",950,10},
  {{{0x257a4000fa1e7c22}},3,"F-H0-1698",913,7},
  {{{0x99d71cb0b501420}},3,"F-H0-1699",542,2},
  {{{0xf770c0ec2628b48f}},3,"F-H0-1700",543,2},
  {{{0x257a4000fa1e7c22}},3,"F-H0-1701",948,2},
  {{{0x257a4000fa1e7c22}},3,"F-H0-1702",876,2},
  {{{0x7d3cf40e2576c113}},6,"F-H0-1703",728,98},
  {{{0x7d3cf40e2576c113}},6,"F-H0-1704",470,8},
  {{{0x7d3cf40e2576c113}},6,"F-H0-1705",765,3},
  {{{0x7d3cf40e2576c113}},6,"F-H0-1706",690,3},
  {{{0xbeacaed9a6be3b66}},9,"F-H0-1707",905,81},
  {{{0x49380fee4e781239}},9,"F-H0-1708",986,6},
  {{{0xb380fdb4e5932b1e}},9,"F-H0-1709",829,4},
  {{{0x8eac31870db33d3a}},9,"F-H0-1710",950,2},
  {{{0xb380fdb4e5932b1e}},9,"F-H0-1711",753,2},
  {{{0x8eac31870db33d3a}},9,"F-H0-1712",691,2},
  {{{0x2414d3a8245fb1ca}},5,"F-H0-1713",947,33},
  {{{0x5891865431906ee0}},5,"F-H0-1714",427,22},
  {{{0x49cc3f356e800032}},5,"F-H0-1715",902,14},
  {{{0x368cacff35ec5d59}},5,"F-H0-1716",906,8},
  {{{0x2414d3a8245fb1ca}},5,"F-H0-1717",727,7},
  {{{0x49cc3f356e800032}},5,"F-H0-1718",714,3},
  {{{0x38f6192e9c9e7ba7}},5,"F-H0-1719",825,2},
  {{{0xb473e7c3e17cfdcc}},6,"F-H0-1720",432,41},
  {{{0xfaee8044789b65f8}},6,"F-H0-1721",873,27},
  {{{0xe72444d6f65ed83d}},6,"F-H0-1722",825,5},
  {{{0xe72444d6f65ed83d}},6,"F-H0-1723",904,5},
  {{{0xb473e7c3e17cfdcc}},6,"F-H0-1724",466,4},
  {{{0xb473e7c3e17cfdcc}},6,"F-H0-1725",457,2},
  {{{0x4961456eed9f8e8b}},8,"F-H0-1726",495,101},
  {{{0x4961456eed9f8e8b}},8,"F-H0-1727",493,2},
  {{{0xc15f62854037cbe2}},6,"F-H0-1728",690,72},
  {{{0xc15f62854037cbe2}},6,"F-H0-1729",653,19},
  {{{0xbd80b16f09d76ab8}},6,"F-H0-1730",394,14},
  {{{0xc15f62854037cbe2}},6,"F-H0-1731",907,2},
  {{{0xc15f62854037cbe2}},6,"F-H0-1732",947,2},
  {{{0xf0e1537d9d4722f6}},4,"F-H0-1733",911,54},
  {{{0xf0e1537d9d4722f6}},4,"F-H0-1734",429,23},
  {{{0x162510567a938efb}},4,"F-H0-1735",944,12},
  {{{0xf0e1537d9d4722f6}},4,"F-H0-1736",948,12},
  {{{0x162510567a938efb}},4,"F-H0-1737",948,9},
  {{{0x162510567a938efb}},4,"F-H0-1738",907,9},
  {{{0x2c5574ddbd492eae}},4,"F-H0-1739",826,2},
  {{{0x162510567a938efb}},4,"F-H0-1740",690,2},
  {{{0x2295010671f98b60}},4,"F-H0-1741",939,2},
  {{{0x80d554a7f6f26e1e}},7,"F-H0-1742",826,78},
  {{{0xad827f282547bc9}},7,"F-H0-1743",429,16},
  {{{0xc375b999e7c6fb38}},4,"F-H0-1744",948,21},
  {{{0x34822b60ad36683c}},4,"F-H0-1745",899,20},
  {{{0xc375b999e7c6fb38}},4,"F-H0-1746",456,14},
  {{{0xc375b999e7c6fb38}},4,"F-H0-1747",945,9},
  {{{0xc375b999e7c6fb38}},4,"F-H0-1748",838,8},
  {{{0xc375b999e7c6fb38}},4,"F-H0-1749",949,3},
  {{{0x88291467b6c997ce}},4,"F-H0-1750",839,2},
  {{{0xc375b999e7c6fb38}},4,"F-H0-1751",944,2},
  {{{0xc375b999e7c6fb38}},4,"F-H0-1752",907,2},
  {{{0xd184108db7c5f7e8}},8,"F-H0-1753",431,107},
  {{{0x1f7bf3f37c4dd473}},9,"F-H0-1754",531,111},
  {{{0x2513096c9ab91306}},9,"F-H0-1755",875,52},
  {{{0x34f9ce74c5c57198}},9,"F-H0-1756",908,14},
  {{{0x34f9ce74c5c57198}},9,"F-H0-1757",946,11},
  {{{0x34f9ce74c5c57198}},9,"F-H0-1758",871,4},
  {{{0xb611c8483e7a1cdd}},9,"F-H0-1759",938,3},
  {{{0x9f2b9cc4a180d74}},9,"F-H0-1760",455,2},
  {{{0x7e3f8ff35129027a}},9,"F-H0-1761",467,95},
  {{{0xba9e7bf61c8df2b5}},9,"F-H0-1762",862,2},
  {{{0x7e3f8ff35129027a}},9,"F-H0-1763",433,2},
  {{{0x94b401232a89d9fd}},7,"F-H0-1764",678,57},
  {{{0xda616424b5a7e5b6}},7,"F-H0-1765",382,41},
  {{{0xda616424b5a7e5b6}},7,"F-H0-1766",461,4},
  {{{0x94b401232a89d9fd}},7,"F-H0-1767",801,3},
  {{{0x94b401232a89d9fd}},7,"F-H0-1768",714,2},
  {{{0xa67b9a28808f3336}},10,"F-H0-1769",456,96},
  {{{0xa67b9a28808f3336}},10,"F-H0-1770",532,4},
  {{{0xa67b9a28808f3336}},10,"F-H0-1771",418,2},
  {{{0xb27d0e3382c10cd}},4,"F-H0-1772",543,35},
  {{{0xb27d0e3382c10cd}},4,"F-H0-1773",419,21},
  {{{0xb27d0e3382c10cd}},4,"F-H0-1774",907,20},
  {{{0xb27d0e3382c10cd}},4,"F-H0-1775",944,18},
  {{{0xc1fb90f9f86c9a25}},4,"F-H0-1776",943,5},
  {{{0xc1fb90f9f86c9a25}},4,"F-H0-1777",420,4},
  {{{0x7bcf5cc917eb593f}},4,"F-H0-1778",943,3},
  {{{0xb27d0e3382c10cd}},4,"F-H0-1779",420,2},
  {{{0x74f94605eb8341f0}},6,"F-H0-1780",941,36},
  {{{0x74f94605eb8341f0}},6,"F-H0-1781",826,19},
  {{{0x74f94605eb8341f0}},6,"F-H0-1782",905,13},
  {{{0x983b897183fee644}},6,"F-H0-1783",910,10},
  {{{0x6f4ad07051c7c832}},6,"F-H0-1784",837,7},
  {{{0x6f4ad07051c7c832}},6,"F-H0-1785",678,7},
  {{{0x6f4ad07051c7c832}},6,"F-H0-1786",874,5},
  {{{0x88dbd8176f2e3ea2}},6,"F-H0-1787",678,3},
  {{{0xf0ca172e36c72066}},6,"F-H0-1788",505,3},
  {{{0x157d4b1494c5cec9}},4,"F-H0-1789",430,38},
  {{{0xebd1159679b2e556}},4,"F-H0-1790",529,32},
  {{{0x81628f7209e80739}},4,"F-H0-1791",543,10},
  {{{0xebd1159679b2e556}},4,"F-H0-1792",825,6},
  {{{0xebd1159679b2e556}},4,"F-H0-1793",863,4},
  {{{0xebd1159679b2e556}},4,"F-H0-1794",714,2},
  {{{0xebd1159679b2e556}},4,"F-H0-1795",684,2},
  {{{0x9d44f756b0b91a4b}},7,"F-H0-1796",947,34},
  {{{0x9d44f756b0b91a4b}},7,"F-H0-1797",911,28},
  {{{0x9d44f756b0b91a4b}},7,"F-H0-1798",910,23},
  {{{0x9d44f756b0b91a4b}},7,"F-H0-1799",825,6},
  {{{0x9d44f756b0b91a4b}},7,"F-H0-1800",943,4},
  {{{0x3924e9810b276b50}},7,"F-H0-1801",424,3},
  {{{0x3924e9810b276b50}},7,"F-H0-1802",430,2},
  {{{0x9d44f756b0b91a4b}},7,"F-H0-1803",939,2},
  {{{0x9d44f756b0b91a4b}},7,"F-H0-1804",948,2},
  {{{0xee899a610d9e5d0}},10,"F-H0-1805",470,105},
  {{{0xd342dac637b49671}},13,"F-H0-1806",506,94},
  {{{0xd342dac637b49671}},13,"F-H0-1807",544,2},
  {{{0xf877ef57996bcd5e}},12,"F-H0-1808",433,105},
  {{{0xd219bb704c7cf94d}},11,"F-H0-1809",507,95},
  {{{0xaf8efdcd2e44c0ea}},14,"F-H0-1810",429,105},
  {{{0xf4a6983516c31549}},7,"F-H0-1811",939,70},
  {{{0x6879c77824ac6b33}},7,"F-H0-1812",788,33},
  {{{0xc95095ccfb9405af}},15,"F-H0-1813",911,40},
  {{{0xc95095ccfb9405af}},15,"F-H0-1814",948,29},
  {{{0xc95095ccfb9405af}},15,"F-H0-1815",728,11},
  {{{0xe1f2739e270c3f0a}},15,"F-H0-1816",939,5},
  {{{0xbf3f0bf237a504ca}},15,"F-H0-1817",496,4},
  {{{0xb093e1df69482889}},15,"F-H0-1818",543,3},
  {{{0xc95095ccfb9405af}},15,"F-H0-1819",910,3},
  {{{0xc95095ccfb9405af}},15,"F-H0-1820",947,2},
  {{{0xc95095ccfb9405af}},15,"F-H0-1821",939,2},
  {{{0xad9ec6fc66056ca8}},4,"F-H0-1822",420,34},
  {{{0x58b83ea42ed227a7}},4,"F-H0-1823",467,31},
  {{{0xad9ec6fc66056ca8}},4,"F-H0-1824",421,15},
  {{{0x58b83ea42ed227a7}},4,"F-H0-1825",457,9},
  {{{0x58b83ea42ed227a7}},4,"F-H0-1826",728,5},
  {{{0x8643f97ca943b4f1}},4,"F-H0-1827",420,3},
  {{{0x58b83ea42ed227a7}},4,"F-H0-1828",425,2},
  {{{0x7684343804122b21}},8,"F-H0-1829",945,61},
  {{{0x7684343804122b21}},8,"F-H0-1830",839,12},
  {{{0x239ccffdf8087c67}},8,"F-H0-1831",838,7},
  {{{0x7684343804122b21}},8,"F-H0-1832",907,7},
  {{{0x7684343804122b21}},8,"F-H0-1833",838,7},
  {{{0xa28f66035e30dc6d}},8,"F-H0-1834",904,3},
  {{{0x990c99556ffa3cb5}},8,"F-H0-1835",714,2},
  {{{0xec5a40692ecf3eb3}},2,"F-H0-1836",912,36},
  {{{0xa7fa9fc9cbb31613}},2,"F-H0-1837",469,17},
  {{{0xec5a40692ecf3eb3}},2,"F-H0-1838",468,11},
  {{{0x51dd461ff2c3d5be}},2,"F-H0-1839",419,10},
  {{{0x37081f14e1b638eb}},2,"F-H0-1840",949,4},
  {{{0x37081f14e1b638eb}},2,"F-H0-1841",469,3},
  {{{0x718f2a5184965bce}},2,"F-H0-1842",876,15},
  {{{0x718f2a5184965bce}},2,"F-H0-1843",911,10},
  {{{0xf79f5d331735def4}},2,"F-H0-1844",469,6},
  {{{0x3af959a220ec53f2}},2,"F-H0-1845",900,6},
  {{{0x718f2a5184965bce}},2,"F-H0-1846",948,6},
  {{{0x718f2a5184965bce}},2,"F-H0-1847",431,4},
  {{{0x718f2a5184965bce}},2,"F-H0-1848",430,3},
  {{{0x41f7264ff16776d}},2,"F-H0-1849",457,3},
  {{{0x41f7264ff16776d}},2,"F-H0-1850",505,2},
  {{{0x718f2a5184965bce}},2,"F-H0-1851",469,2},
  {{{0x155426bd5d19a7e3}},6,"F-H0-1852",678,40},
  {{{0x155426bd5d19a7e3}},6,"F-H0-1853",454,28},
  {{{0x44d358a88a4ff375}},6,"F-H0-1854",421,10},
  {{{0x44d358a88a4ff375}},6,"F-H0-1855",944,3},
  {{{0xcbf14f1e31ec0a31}},6,"F-H0-1856",463,3},
  {{{0x155426bd5d19a7e3}},6,"F-H0-1857",531,2},
  {{{0x7d5a3aad60cf935a}},6,"F-H0-1858",691,2},
  {{{0x814a3db51d6d8a66}},2,"F-H0-1859",432,34},
  {{{0xb94d28ddbfddca54}},2,"F-H0-1860",913,15},
  {{{0xb94d28ddbfddca54}},2,"F-H0-1861",912,8},
  {{{0xb94d28ddbfddca54}},2,"F-H0-1862",949,7},
  {{{0x814a3db51d6d8a66}},2,"F-H0-1863",505,2},
  {{{0xb94d28ddbfddca54}},2,"F-H0-1864",543,2},
  {{{0x9b47fbc3bfd9046e}},2,"F-H0-1865",466,2},
  {{{0xb94d28ddbfddca54}},2,"F-H0-1866",876,2},
  {{{0xf9521350b895d8b0}},2,"F-H0-1867",912,49},
  {{{0xa06b55ca53baa8d8}},2,"F-H0-1868",419,28},
  {{{0x5b2911d7f2096635}},2,"F-H0-1869",900,15},
  {{{0x896cfce96c326007}},2,"F-H0-1870",900,8},
  {{{0xf9521350b895d8b0}},2,"F-H0-1871",949,6},
  {{{0xa06b55ca53baa8d8}},2,"F-H0-1872",469,2},
  {{{0xec7975a1b6043}},2,"F-H0-1873",418,2},
  {{{0xf9521350b895d8b0}},2,"F-H0-1874",876,2},
  {{{0xb2f937b6cc8643ce}},2,"F-H0-1875",875,23},
  {{{0xf9fa1820f65e076a}},2,"F-H0-1876",468,6},
  {{{0x3d426c93c2c68cd2}},2,"F-H0-1877",900,5},
  {{{0xf9fa1820f65e076a}},2,"F-H0-1878",505,5},
  {{{0xf9fa1820f65e076a}},2,"F-H0-1879",419,5},
  {{{0xb2f937b6cc8643ce}},2,"F-H0-1880",430,5},
  {{{0xb2f937b6cc8643ce}},2,"F-H0-1881",876,4},
  {{{0x3d426c93c2c68cd2}},2,"F-H0-1882",455,3},
  {{{0xb2f937b6cc8643ce}},2,"F-H0-1883",948,3},
  {{{0xb2f937b6cc8643ce}},2,"F-H0-1884",838,2},
  {{{0xb2f937b6cc8643ce}},2,"F-H0-1885",911,2},
  {{{0xf9fa1820f65e076a}},2,"F-H0-1886",494,2},
  {{{0x7a8ea8c192f4cb40}},2,"F-H0-1887",431,2},
  {{{0xb0ffae60f43cae1b}},6,"F-H0-1888",911,40},
  {{{0xb0ffae60f43cae1b}},6,"F-H0-1889",690,20},
  {{{0xb0ffae60f43cae1b}},6,"F-H0-1890",875,14},
  {{{0xb0ffae60f43cae1b}},6,"F-H0-1891",727,11},
  {{{0xa2f35c5af9f5f475}},6,"F-H0-1892",947,4},
  {{{0xb0ffae60f43cae1b}},6,"F-H0-1893",728,4},
  {{{0xb0ffae60f43cae1b}},6,"F-H0-1894",910,3},
  {{{0xb0ffae60f43cae1b}},6,"F-H0-1895",838,3},
  {{{0xb0ffae60f43cae1b}},6,"F-H0-1896",874,2},
  {{{0xf2dc9f5d78244a47}},12,"F-H0-1897",790,88},
  {{{0xf2dc9f5d78244a47}},12,"F-H0-1898",826,9},
  {{{0xa721d4c997a16142}},11,"F-H0-1899",529,88},
  {{{0xd3dd5880466514a6}},11,"F-H0-1900",911,11},
  {{{0xd3dd5880466514a6}},11,"F-H0-1901",948,7},
  {{{0x4b0df0678be1e2df}},5,"F-H0-1902",505,23},
  {{{0x31a87e13c01002d1}},5,"F-H0-1903",616,18},
  {{{0x31a87e13c01002d1}},5,"F-H0-1904",506,16},
  {{{0x31a87e13c01002d1}},5,"F-H0-1905",948,14},
  {{{0x31a87e13c01002d1}},5,"F-H0-1906",580,12},
  {{{0x31a87e13c01002d1}},5,"F-H0-1907",910,5},
  {{{0x31a87e13c01002d1}},5,"F-H0-1908",466,4},
  {{{0x31a87e13c01002d1}},5,"F-H0-1909",947,4},
  {{{0x31a87e13c01002d1}},5,"F-H0-1910",504,3},
  {{{0x2ad25163129249c7}},2,"F-H0-1911",912,40},
  {{{0x2ad25163129249c7}},2,"F-H0-1912",913,24},
  {{{0x2ad25163129249c7}},2,"F-H0-1913",949,13},
  {{{0x2ad25163129249c7}},2,"F-H0-1914",419,11},
  {{{0x9edd7e1db07fd42b}},2,"F-H0-1915",912,8},
  {{{0x4e06cfab9621d55c}},2,"F-H0-1916",913,4},
  {{{0x830df0aa10b74282}},2,"F-H0-1917",948,2},
  {{{0x9edd7e1db07fd42b}},2,"F-H0-1918",493,2},
  {{{0x9edd7e1db07fd42b}},2,"F-H0-1919",457,2},
  {{{0x912cb1f9972068d4}},2,"F-H0-1920",862,2},
  {{{0x9edd7e1db07fd42b}},2,"F-H0-1921",949,2},
  {{{0xbbfd6d29815c5e12}},7,"F-H0-1922",825,83},
  {{{0xd712898ccf6a7357}},7,"F-H0-1923",912,19},
  {{{0x6511c9c51666134e}},7,"F-H0-1924",943,61},
  {{{0x6511c9c51666134e}},7,"F-H0-1925",825,29},
  {{{0x126915b7bc3ba73b}},7,"F-H0-1926",901,4},
  {{{0x6511c9c51666134e}},7,"F-H0-1927",906,2},
  {{{0x126915b7bc3ba73b}},7,"F-H0-1928",789,2},
  {{{0x6511c9c51666134e}},7,"F-H0-1929",678,2},
  {{{0x6511c9c51666134e}},7,"F-H0-1930",944,2},
  {{{0xbcefeffa62105eb}},4,"F-H0-1931",906,31},
  {{{0x6bb0c4c08bb6e015}},4,"F-H0-1932",949,22},
  {{{0xb54ce6a00a906de8}},4,"F-H0-1933",949,14},
  {{{0x7b615dcd280bc3c8}},4,"F-H0-1934",691,8},
  {{{0xd532dc9f27078816}},4,"F-H0-1935",714,7},
  {{{0xd532dc9f27078816}},4,"F-H0-1936",943,5},
  {{{0xbcefeffa62105eb}},4,"F-H0-1937",420,4},
  {{{0xbcefeffa62105eb}},4,"F-H0-1938",506,3},
  {{{0xbcefeffa62105eb}},4,"F-H0-1939",691,3},
  {{{0xbcefeffa62105eb}},4,"F-H0-1940",684,2},
  {{{0x70a2ee925256706b}},10,"F-H0-1941",942,40},
  {{{0x85a0d77162f7b698}},10,"F-H0-1942",908,27},
  {{{0x70a2ee925256706b}},10,"F-H0-1943",938,10},
  {{{0x70a2ee925256706b}},10,"F-H0-1944",943,2},
  {{{0xc96a7337aff835a4}},6,"F-H0-1945",418,91},
  {{{0xc9e3b4cb73d15e25}},6,"F-H0-1946",873,3},
  {{{0xc96a7337aff835a4}},6,"F-H0-1947",424,3},
  {{{0xbf604cc97a542bb8}},6,"F-H0-1948",690,49},
  {{{0xbf604cc97a542bb8}},6,"F-H0-1949",529,30},
  {{{0xbf604cc97a542bb8}},6,"F-H0-1950",684,11},
  {{{0xfbe5b30c177d6a13}},6,"F-H0-1951",943,2},
  {{{0x345cfe8d9978384c}},4,"F-H0-1952",862,36},
  {{{0x345cfe8d9978384c}},4,"F-H0-1953",529,22},
  {{{0xfbadb61ea4a70b85}},4,"F-H0-1954",457,12},
  {{{0x345cfe8d9978384c}},4,"F-H0-1955",430,6},
  {{{0x345cfe8d9978384c}},4,"F-H0-1956",825,5},
  {{{0x4133fa2356dbc6db}},4,"F-H0-1957",457,2},
  {{{0x345cfe8d9978384c}},4,"F-H0-1958",826,2},
  {{{0xa14c90caa67dd4d0}},3,"F-H0-1959",839,22},
  {{{0xd99bf0f18b6173c}},3,"F-H0-1960",910,18},
  {{{0xa14c90caa67dd4d0}},3,"F-H0-1961",802,5},
  {{{0x1cddf83b5754a58e}},3,"F-H0-1962",826,4},
  {{{0xf33617099a500bb0}},3,"F-H0-1963",941,4},
  {{{0xbc35f9e1187dcf18}},3,"F-H0-1964",456,3},
  {{{0xf33617099a500bb0}},3,"F-H0-1965",865,3},
  {{{0xf33617099a500bb0}},3,"F-H0-1966",905,3},
  {{{0xa14c90caa67dd4d0}},3,"F-H0-1967",900,3},
  {{{0xa14c90caa67dd4d0}},3,"F-H0-1968",874,2},
  {{{0x690259f4bb2d97a1}},13,"F-H0-1969",839,62},
  {{{0xe03cf9292c584c07}},13,"F-H0-1970",906,15},
  {{{0x690259f4bb2d97a1}},13,"F-H0-1971",947,5},
  {{{0xe9ecbaa9fef5f677}},13,"F-H0-1972",677,3},
  {{{0x1eece8b296a3bc}},8,"F-H0-1973",654,38},
  {{{0xd956d67ebad031e3}},8,"F-H0-1974",462,3},
  {{{0x824a2d709c4b8022}},8,"F-H0-1975",463,2},
  {{{0xc1d6d4d6829fb226}},4,"F-H0-1976",431,49},
  {{{0xf16654ac8b065e56}},4,"F-H0-1977",456,11},
  {{{0x55ad24aa810287d6}},4,"F-H0-1978",904,11},
  {{{0xc1d6d4d6829fb226}},4,"F-H0-1979",901,7},
  {{{0xc1d6d4d6829fb226}},4,"F-H0-1980",789,4},
  {{{0xc1d6d4d6829fb226}},4,"F-H0-1981",788,2},
  {{{0xc1d6d4d6829fb226}},4,"F-H0-1982",902,2},
  {{{0xf5a448781fcb136c}},8,"F-H0-1983",653,54},
  {{{0x705d62996f1a7941}},8,"F-H0-1984",986,9},
  {{{0xb4fc4a4084db67cf}},8,"F-H0-1985",791,6},
  {{{0xb4fc4a4084db67cf}},8,"F-H0-1986",867,3},
  {{{0x705d62996f1a7941}},8,"F-H0-1987",942,2},
  {{{0x4186d69ba9de2a7d}},5,"F-H0-1988",420,27},
  {{{0x74394f0d4610f9d}},5,"F-H0-1989",908,18},
  {{{0x74394f0d4610f9d}},5,"F-H0-1990",946,11},
  {{{0x4186d69ba9de2a7d}},5,"F-H0-1991",530,8},
  {{{0x4186d69ba9de2a7d}},5,"F-H0-1992",494,5},
  {{{0x74394f0d4610f9d}},5,"F-H0-1993",429,4},
  {{{0x74394f0d4610f9d}},5,"F-H0-1994",907,4},
  {{{0x4186d69ba9de2a7d}},5,"F-H0-1995",948,2},
  {{{0x2dfdf72f3d1d9b0f}},9,"F-H0-1996",986,76},
  {{{0x2dfdf72f3d1d9b0f}},9,"F-H0-1997",910,3},
  {{{0x95c2ee8aa4b0cceb}},3,"F-H0-1998",457,14},
  {{{0x6c8eee541c245ff}},3,"F-H0-1999",912,14},
  {{{0xdb3270a18b92a86b}},3,"F-H0-2000",911,14},
  {{{0xdb3270a18b92a86b}},3,"F-H0-2001",467,11},
  {{{0x6aaafdd8c4c00014}},3,"F-H0-2002",430,7},
  {{{0xdb3270a18b92a86b}},3,"F-H0-2003",469,4},
  {{{0xdb3270a18b92a86b}},3,"F-H0-2004",825,3},
  {{{0xdb3270a18b92a86b}},3,"F-H0-2005",910,2},
  {{{0x3260ccbac7014e07}},3,"F-H0-2006",468,61},
  {{{0x7dd131aaca453287}},3,"F-H0-2007",455,23},
  {{{0x3260ccbac7014e07}},3,"F-H0-2008",949,9},
  {{{0x3260ccbac7014e07}},3,"F-H0-2009",911,3},
  {{{0xf54831750c0cfa22}},3,"F-H0-2010",469,2},
  {{{0x6ab4d2e4feeaef1e}},3,"F-H0-2011",911,2},
  {{{0xa041f63a2db50b9d}},7,"F-H0-2012",690,61},
  {{{0xa041f63a2db50b9d}},7,"F-H0-2013",914,16},
  {{{0xa041f63a2db50b9d}},7,"F-H0-2014",825,8},
  {{{0xc3f9cd5ffce505b1}},7,"F-H0-2015",715,4},
  {{{0xa041f63a2db50b9d}},7,"F-H0-2016",950,2},
  {{{0x71d916a949cd2475}},7,"F-H0-2017",495,2},
  {{{0x69b74bf6d1dd5a24}},7,"F-H0-2018",909,72},
  {{{0x7e7344423762fa8b}},4,"F-H0-2019",431,29},
  {{{0x7e7344423762fa8b}},4,"F-H0-2020",944,11},
  {{{0x7e7344423762fa8b}},4,"F-H0-2021",529,8},
  {{{0x92a9ea73257967b}},4,"F-H0-2022",839,8},
  {{{0x14047ad6e900cc52}},4,"F-H0-2023",901,7},
  {{{0x92a9ea73257967b}},4,"F-H0-2024",641,7},
  {{{0x7e7344423762fa8b}},4,"F-H0-2025",948,7},
  {{{0x7e7344423762fa8b}},4,"F-H0-2026",425,4},
  {{{0x92a9ea73257967b}},4,"F-H0-2027",462,3},
  {{{0x7e7344423762fa8b}},4,"F-H0-2028",432,2},
  {{{0x7e7344423762fa8b}},4,"F-H0-2029",426,2},
  {{{0xb29bbd76c3f8e02d}},3,"F-H0-2030",765,9},
  {{{0x3836686250c67f77}},3,"F-H0-2031",936,4},
  {{{0x3836686250c67f77}},3,"F-H0-2032",974,3},
  {{{0x663fad13f79129f2}},3,"F-H0-2033",492,2},
  {{{0x3836686250c67f77}},3,"F-H0-2034",911,2},
  {{{0xb29bbd76c3f8e02d}},3,"F-H0-2035",764,2},
  {{{0x26f19c1422f95d90}},5,"F-H0-2036",826,19},
  {{{0xe34509d1e854e617}},5,"F-H0-2037",529,15},
  {{{0xcd8158e8b53f77d8}},5,"F-H0-2038",457,11},
  {{{0xabfbe5c66990ea8f}},5,"F-H0-2039",839,9},
  {{{0x2c91a22de80e776b}},5,"F-H0-2040",728,6},
  {{{0xcd8158e8b53f77d8}},5,"F-H0-2041",459,6},
  {{{0x89aa0cfac163e082}},5,"F-H0-2042",580,6},
  {{{0xcd8158e8b53f77d8}},5,"F-H0-2043",677,3},
  {{{0xcd8158e8b53f77d8}},5,"F-H0-2044",640,3},
  {{{0xcd8158e8b53f77d8}},5,"F-H0-2045",939,2},
  {{{0x89aa0cfac163e082}},5,"F-H0-2046",459,2},
  {{{0x1c7796471e370e7}},8,"F-H0-2048",873,5},
  {{{0x1c7796471e370e7}},8,"F-H0-2049",948,5},
  {{{0x4a59a83166e96c0e}},4,"F-H0-2050",431,34},
  {{{0x926fa9b0a89b1483}},4,"F-H0-2051",506,22},
  {{{0x72b3d3ad4e1472b7}},4,"F-H0-2052",904,14},
  {{{0x4a59a83166e96c0e}},4,"F-H0-2053",468,7},
  {{{0x4a59a83166e96c0e}},4,"F-H0-2054",902,6},
  {{{0x68c1dbf7833cd551}},4,"F-H0-2055",802,4},
  {{{0x4a59a83166e96c0e}},4,"F-H0-2056",864,2},
  {{{0xc2f33b35cc9684bd}},4,"F-H0-2057",543,2},
  {{{0xf543816d92008e6a}},9,"F-H0-2058",543,15},
  {{{0xd835d90950fc838e}},9,"F-H0-2059",939,14},
  {{{0xf02eede23335be0e}},9,"F-H0-2060",425,3},
  {{{0xf02eede23335be0e}},9,"F-H0-2061",943,3},
  {{{0xf02eede23335be0e}},9,"F-H0-2062",939,2},
  {{{0x95b29ad1977ae09f}},7,"F-H0-2063",417,74},
  {{{0x1e2c60db87b77546}},8,"F-H0-2064",419,90},
  {{{0xc909f638d76ed4e1}},7,"F-H0-2065",947,25},
  {{{0x979f2962da68de32}},7,"F-H0-2067",902,10},
  {{{0x979f2962da68de32}},7,"F-H0-2068",617,10},
  {{{0xeb955e44d947fc7e}},7,"F-H0-2069",906,5},
  {{{0xc909f638d76ed4e1}},7,"F-H0-2070",462,3},
  {{{0x979f2962da68de32}},7,"F-H0-2071",903,3},
  {{{0xc909f638d76ed4e1}},7,"F-H0-2072",874,2},
  {{{0xeb955e44d947fc7e}},7,"F-H0-2073",429,2},
  {{{0xeb955e44d947fc7e}},7,"F-H0-2074",421,2},
  {{{0xeb955e44d947fc7e}},7,"F-H0-2075",428,2},
  {{{0x8cd100daad0ae9ee}},7,"F-H0-2076",936,2},
  {{{0x979f2962da68de32}},7,"F-H0-2077",947,2},
  {{{0xf7f152ab77d5fa94}},6,"F-H0-2078",902,41},
  {{{0x148597b54770a8ee}},6,"F-H0-2079",463,4},
  {{{0x148597b54770a8ee}},6,"F-H0-2080",466,4},
  {{{0x148597b54770a8ee}},6,"F-H0-2081",427,3},
  {{{0xaa8a2008532d798b}},5,"F-H0-2082",825,36},
  {{{0xaa8a2008532d798b}},5,"F-H0-2083",839,17},
  {{{0x7488384747dca95d}},5,"F-H0-2084",455,13},
  {{{0xab316393a171ac2a}},5,"F-H0-2085",461,3},
  {{{0x443ca1777103d861}},5,"F-H0-2086",728,2},
  {{{0x443ca1777103d861}},5,"F-H0-2087",678,2},
  {{{0x92cd5819d6009dcd}},8,"F-H0-2088",899,68},
  {{{0xf61bc77f1cb115a6}},7,"F-H0-2089",950,40},
  {{{0xf61bc77f1cb115a6}},7,"F-H0-2090",837,22},
  {{{0xf61bc77f1cb115a6}},7,"F-H0-2091",947,11},
  {{{0xf61bc77f1cb115a6}},7,"F-H0-2092",764,5},
  {{{0xec4427ae27a539d5}},7,"F-H0-2093",826,3},
  {{{0x4cdf0901fd3a1f15}},9,"F-H0-2094",789,48},
  {{{0x4cdf0901fd3a1f15}},9,"F-H0-2095",826,25},
  {{{0x6f47f2ac1532f0cc}},9,"F-H0-2096",974,12},
  {{{0xf70f699731fbb4d1}},9,"F-H0-2097",491,65},
  {{{0xf70f699731fbb4d1}},9,"F-H0-2098",380,6},
  {{{0xf70f699731fbb4d1}},9,"F-H0-2099",460,3},
  {{{0x7101e58f1b8f40bb}},9,"F-H0-2100",421,2},
  {{{0x23bb69b5f231b631}},3,"F-H0-2101",912,49},
  {{{0x298bd743191fe65a}},3,"F-H0-2102",455,21},
  {{{0x23bb69b5f231b631}},3,"F-H0-2103",911,4},
  {{{0x298bd743191fe65a}},3,"F-H0-2104",875,4},
  {{{0x298bd743191fe65a}},3,"F-H0-2105",913,2},
  {{{0x23bb69b5f231b631}},3,"F-H0-2106",948,2},
  {{{0x2f9c5e717a33654b}},12,"F-H0-2107",532,44},
  {{{0x37b314376cb2cc93}},12,"F-H0-2108",936,38},
  {{{0xc96044f8ccd9b16b}},4,"F-H0-2109",949,20},
  {{{0xc96044f8ccd9b16b}},4,"F-H0-2110",457,18},
  {{{0xc96044f8ccd9b16b}},4,"F-H0-2111",543,15},
  {{{0xc96044f8ccd9b16b}},4,"F-H0-2112",420,5},
  {{{0x22838d8e182aede0}},4,"F-H0-2113",875,51},
  {{{0x22838d8e182aede0}},4,"F-H0-2114",420,33},
  {{{0x2fea6539e96a3688}},4,"F-H0-2115",902,5},
  {{{0xccbc38c7f041cd9a}},7,"F-H0-2116",838,66},
  {{{0xb9e264a679244a74}},7,"F-H0-2117",429,5},
  {{{0x679929945005f7f5}},7,"F-H0-2118",580,2},
  {{{0xefedd214bbcac4b7}},6,"F-H0-2119",382,36},
  {{{0x758656eaf0e9f1f4}},6,"F-H0-2120",906,29},
  {{{0x2ca276919e6e06d1}},6,"F-H0-2121",543,3},
  {{{0xefedd214bbcac4b7}},6,"F-H0-2122",839,3},
  {{{0xefedd214bbcac4b7}},6,"F-H0-2123",424,2},
  {{{0x6fe70c4fa97fe7f9}},6,"F-H0-2124",654,2},
  {{{0xabc541b15eeb6873}},3,"F-H0-2125",876,18},
  {{{0xb8f23e27808c0097}},3,"F-H0-2126",949,10},
  {{{0xcd559219185f4167}},3,"F-H0-2127",530,8},
  {{{0xcd559219185f4167}},3,"F-H0-2128",460,7},
  {{{0xcd559219185f4167}},3,"F-H0-2129",949,7},
  {{{0xdd9b5ff25d6b3758}},3,"F-H0-2130",864,6},
  {{{0xcd559219185f4167}},3,"F-H0-2131",468,5},
  {{{0xabc541b15eeb6873}},3,"F-H0-2132",802,5},
  {{{0x656f0d1ed91c323c}},3,"F-H0-2133",900,5},
  {{{0xabc541b15eeb6873}},3,"F-H0-2134",947,4},
  {{{0x8831134e34dc8d4e}},3,"F-H0-2135",938,3},
  {{{0xcd559219185f4167}},3,"F-H0-2136",913,3},
  {{{0x7a1ad32a43cf2a4c}},3,"F-H0-2137",862,2},
  {{{0xabc541b15eeb6873}},3,"F-H0-2138",909,2},
  {{{0xdd9b5ff25d6b3758}},3,"F-H0-2139",419,2},
  {{{0xb07db7b806eee9b3}},6,"F-H0-2140",945,28},
  {{{0x116991bd6f086d2a}},6,"F-H0-2141",875,18},
  {{{0xb07db7b806eee9b3}},6,"F-H0-2142",940,6},
  {{{0x2e67de1b543332c5}},6,"F-H0-2143",492,5},
  {{{0x116991bd6f086d2a}},6,"F-H0-2144",839,5},
  {{{0xb07db7b806eee9b3}},6,"F-H0-2145",941,5},
  {{{0xb07db7b806eee9b3}},6,"F-H0-2146",429,3},
  {{{0xb07db7b806eee9b3}},6,"F-H0-2147",543,2},
  {{{0xb07db7b806eee9b3}},6,"F-H0-2148",462,2},
  {{{0xc0344ee9d2b40b6a}},3,"F-H0-2149",456,50},
  {{{0xc0344ee9d2b40b6a}},3,"F-H0-2150",455,18},
  {{{0xd0d59b9de1154d9a}},3,"F-H0-2151",901,8},
  {{{0x407ee765777dbecf}},3,"F-H0-2152",421,3},
  {{{0xdad6d6eb30eabf57}},3,"F-H0-2153",420,2},
  {{{0x8531624c38264251}},7,"F-H0-2154",947,42},
  {{{0x8531624c38264251}},7,"F-H0-2155",825,19},
  {{{0x8531624c38264251}},7,"F-H0-2156",943,16},
  {{{0xee3bf7342e08c422}},7,"F-H0-2157",947,5},
  {{{0x8531624c38264251}},7,"F-H0-2158",678,2},
  {{{0x8531624c38264251}},7,"F-H0-2159",470,2},
  {{{0xa69a106a9ee2e461}},10,"F-H0-2160",945,40},
  {{{0xa69a106a9ee2e461}},10,"F-H0-2161",910,24},
  {{{0xa69a106a9ee2e461}},10,"F-H0-2162",908,12},
  {{{0x409211e961a3bd16}},4,"F-H0-2163",949,30},
  {{{0x409211e961a3bd16}},4,"F-H0-2164",470,7},
  {{{0x409211e961a3bd16}},4,"F-H0-2165",913,5},
  {{{0x409211e961a3bd16}},4,"F-H0-2166",912,4},
  {{{0xb80f11d964c01637}},4,"F-H0-2167",912,3},
  {{{0x6f522d6c9d9388db}},4,"F-H0-2168",423,3},
  {{{0x409211e961a3bd16}},4,"F-H0-2169",690,2},
  {{{0xa72f5c3a29ae8217}},4,"F-H0-2170",543,29},
  {{{0xa72f5c3a29ae8217}},4,"F-H0-2171",457,14},
  {{{0xa72f5c3a29ae8217}},4,"F-H0-2172",949,5},
  {{{0xa72f5c3a29ae8217}},4,"F-H0-2173",654,3},
  {{{0xe68bcfb0aead74a2}},4,"F-H0-2174",876,3},
  {{{0xa72f5c3a29ae8217}},4,"F-H0-2175",906,3},
  {{{0xa72f5c3a29ae8217}},4,"F-H0-2176",458,2},
  {{{0xdb6c3f8a128f23d4}},6,"F-H0-2177",839,30},
  {{{0xdb6c3f8a128f23d4}},6,"F-H0-2178",432,27},
  {{{0x6ba9650ecb5a575e}},6,"F-H0-2179",865,13},
  {{{0xdb6c3f8a128f23d4}},6,"F-H0-2180",876,7},
  {{{0x62dd451a793313c}},6,"F-H0-2181",421,4},
  {{{0x2ef9c377ba491f72}},3,"F-H0-2182",468,12},
  {{{0xd656918b34245a4f}},3,"F-H0-2183",469,10},
  {{{0xd656918b34245a4f}},3,"F-H0-2184",911,8},
  {{{0x2ef9c377ba491f72}},3,"F-H0-2185",505,7},
  {{{0xd656918b34245a4f}},3,"F-H0-2186",910,5},
  {{{0x2ef9c377ba491f72}},3,"F-H0-2187",506,4},
  {{{0x2ef9c377ba491f72}},3,"F-H0-2188",467,4},
  {{{0xd656918b34245a4f}},3,"F-H0-2189",948,4},
  {{{0xd656918b34245a4f}},3,"F-H0-2190",431,3},
  {{{0xd656918b34245a4f}},3,"F-H0-2191",506,3},
  {{{0xbd74114b65ba84c0}},3,"F-H0-2192",839,2},
  {{{0xd80f81fabd877898}},6,"F-H0-2193",690,31},
  {{{0xab09abd134cb4338}},6,"F-H0-2194",394,15},
  {{{0xd80f81fabd877898}},6,"F-H0-2195",802,3},
  {{{0xd80f81fabd877898}},6,"F-H0-2196",906,2},
  {{{0x68d92141b4a6fb6f}},6,"F-H0-2197",827,2},
  {{{0xd80f81fabd877898}},6,"F-H0-2198",653,2},
  {{{0xe614c33705c0657c}},6,"F-H0-2199",936,29},
  {{{0xe614c33705c0657c}},6,"F-H0-2200",865,17},
  {{{0x5d6cc31e3caf0cf}},6,"F-H0-2201",421,8},
  {{{0x46452d983dac0c31}},6,"F-H0-2202",908,6},
  {{{0x5d6cc31e3caf0cf}},6,"F-H0-2203",458,2},
  {{{0x387a09cbd85178ff}},4,"F-H0-2204",839,13},
  {{{0x1bb160ec011e3a72}},4,"F-H0-2205",465,5},
  {{{0xb1b21971230527e6}},4,"F-H0-2206",425,4},
  {{{0x5a6d9b61665a53d2}},4,"F-H0-2207",567,4},
  {{{0xb1b21971230527e6}},4,"F-H0-2208",678,4},
  {{{0x1bb160ec011e3a72}},4,"F-H0-2209",429,3},
  {{{0x5a6d9b61665a53d2}},4,"F-H0-2210",905,3},
  {{{0xb1b21971230527e6}},4,"F-H0-2211",462,3},
  {{{0x5a6d9b61665a53d2}},4,"F-H0-2212",684,3},
  {{{0xb1b21971230527e6}},4,"F-H0-2213",862,2},
  {{{0xb1b21971230527e6}},4,"F-H0-2214",949,2},
  {{{0xb1b21971230527e6}},4,"F-H0-2215",542,2},
  {{{0x62d46cfe2747b6fa}},4,"F-H0-2216",839,2},
  {{{0x6ac6540cb2ce949f}},5,"F-H0-2217",529,24},
  {{{0x1b4b5aa534024e62}},5,"F-H0-2218",945,13},
  {{{0x1b4b5aa534024e62}},5,"F-H0-2219",901,11},
  {{{0x77aa5f6ce4e4eae9}},5,"F-H0-2220",727,10},
  {{{0x77aa5f6ce4e4eae9}},5,"F-H0-2221",910,8},
  {{{0x6ac6540cb2ce949f}},5,"F-H0-2222",466,5},
  {{{0x77aa5f6ce4e4eae9}},5,"F-H0-2223",690,3},
  {{{0x77aa5f6ce4e4eae9}},5,"F-H0-2224",764,2},
  {{{0x188f795ae56ad81c}},3,"F-H0-2225",431,21},
  {{{0xd49dae73c8984685}},3,"F-H0-2226",456,19},
  {{{0xca3189c89937e010}},3,"F-H0-2227",863,10},
  {{{0xca3189c89937e010}},3,"F-H0-2228",949,7},
  {{{0xc9a95bc7657d7347}},3,"F-H0-2229",938,7},
  {{{0xc9a95bc7657d7347}},3,"F-H0-2230",418,4},
  {{{0xca3189c89937e010}},3,"F-H0-2231",826,2},
  {{{0xca3189c89937e010}},3,"F-H0-2232",911,2},
  {{{0xca778ccb6e714993}},5,"F-H0-2233",943,57},
  {{{0x3224e4f18bb33ab1}},5,"F-H0-2234",942,8},
  {{{0xf4afef6e33ba343b}},5,"F-H0-2235",506,5},
  {{{0x3224e4f18bb33ab1}},5,"F-H0-2236",839,4},
  {{{0xf4afef6e33ba343b}},5,"F-H0-2237",678,4},
  {{{0x26d9d5b04356747f}},5,"F-H0-2238",529,3},
  {{{0xf4afef6e33ba343b}},5,"F-H0-2239",653,2},
  {{{0xca778ccb6e714993}},5,"F-H0-2240",426,2},
  {{{0x57653c04d3d050d4}},8,"F-H0-2241",941,28},
  {{{0x57653c04d3d050d4}},8,"F-H0-2242",826,10},
  {{{0x57653c04d3d050d4}},8,"F-H0-2243",825,9},
  {{{0x57653c04d3d050d4}},8,"F-H0-2244",788,4},
  {{{0x9c73c0fd325c9562}},3,"F-H0-2245",455,22},
  {{{0x389918c7fd697dc0}},3,"F-H0-2246",431,18},
  {{{0xa5d4251a53e136fd}},3,"F-H0-2247",468,17},
  {{{0xa5d4251a53e136fd}},3,"F-H0-2248",901,8},
  {{{0x389918c7fd697dc0}},3,"F-H0-2249",862,8},
  {{{0x389918c7fd697dc0}},3,"F-H0-2250",506,7},
  {{{0x9c73c0fd325c9562}},3,"F-H0-2251",418,3},
  {{{0x92c8c022ffe5e1ac}},5,"F-H0-2252",943,53},
  {{{0x116ab99c7541d01a}},5,"F-H0-2253",839,11},
  {{{0x116ab99c7541d01a}},5,"F-H0-2254",462,9},
  {{{0xc93e2ce5ac7fd0a6}},5,"F-H0-2255",640,4},
  {{{0x92c8c022ffe5e1ac}},5,"F-H0-2256",906,4},
  {{{0xc93e2ce5ac7fd0a6}},5,"F-H0-2257",825,2},
  {{{0x5e9dd92ebbc0c104}},3,"F-H0-2258",912,16},
  {{{0x5e9dd92ebbc0c104}},3,"F-H0-2259",949,8},
  {{{0x1d75d2b027630142}},3,"F-H0-2260",420,8},
  {{{0x5e9dd92ebbc0c104}},3,"F-H0-2261",913,7},
  {{{0x1d75d2b027630142}},3,"F-H0-2262",457,6},
  {{{0x5e9dd92ebbc0c104}},3,"F-H0-2263",948,6},
  {{{0xccb7f3f89cd363a4}},3,"F-H0-2264",901,5},
  {{{0x1d75d2b027630142}},3,"F-H0-2265",939,4},
  {{{0xfdf9a6a3b9aec599}},5,"F-H0-2266",429,31},
  {{{0xfdf9a6a3b9aec599}},5,"F-H0-2267",466,22},
  {{{0xa1bc955c3a6a7d8c}},5,"F-H0-2268",461,11},
  {{{0xfdf9a6a3b9aec599}},5,"F-H0-2269",690,5},
  {{{0xfdf9a6a3b9aec599}},5,"F-H0-2270",617,5},
  {{{0xfdf9a6a3b9aec599}},5,"F-H0-2271",911,4},
  {{{0xfdf9a6a3b9aec599}},5,"F-H0-2272",654,3},
  {{{0xb854d1d63e457f48}},5,"F-H0-2273",943,2},
  {{{0x634d468c55730276}},5,"F-H0-2274",825,22},
  {{{0x634d468c55730276}},5,"F-H0-2275",943,21},
  {{{0x634d468c55730276}},5,"F-H0-2276",678,13},
  {{{0x79afde8eb72db64b}},5,"F-H0-2277",690,13},
  {{{0xf3e63a74c31bf123}},5,"F-H0-2278",690,6},
  {{{0x634d468c55730276}},5,"F-H0-2279",947,3},
  {{{0x634d468c55730276}},5,"F-H0-2280",838,2},
  {{{0xabc743e1cf3bc500}},3,"F-H0-2281",468,46},
  {{{0xabc743e1cf3bc500}},3,"F-H0-2282",469,13},
  {{{0xabc743e1cf3bc500}},3,"F-H0-2283",506,7},
  {{{0xabc743e1cf3bc500}},3,"F-H0-2284",949,6},
  {{{0x4daa25e331fc1a7f}},3,"F-H0-2285",911,5},
  {{{0xf65e4d4d2e33ecaf}},3,"F-H0-2286",419,3},
  {{{0x7eeb8fb6c4e8e867}},3,"F-H0-2287",492,2},
  {{{0xa6fd19109fa66743}},4,"F-H0-2288",543,24},
  {{{0xc509fc593abfde28}},4,"F-H0-2289",468,19},
  {{{0xbc1f81127df8d37e}},4,"F-H0-2290",690,16},
  {{{0xa6fd19109fa66743}},4,"F-H0-2291",530,9},
  {{{0xa6fd19109fa66743}},4,"F-H0-2292",429,4},
  {{{0xa6fd19109fa66743}},4,"F-H0-2293",684,4},
  {{{0xc509fc593abfde28}},4,"F-H0-2294",543,3},
  {{{0xc509fc593abfde28}},4,"F-H0-2295",425,2},
  {{{0x86e266de9b9b9948}},6,"F-H0-2296",825,41},
  {{{0x3b8a915483dad899}},6,"F-H0-2297",432,21},
  {{{0xd12915e1c5edd0de}},6,"F-H0-2298",541,12},
  {{{0xd12915e1c5edd0de}},6,"F-H0-2299",466,5},
  {{{0xbecae9b581ff2825}},7,"F-H0-2300",839,31},
  {{{0xff52bbe6d39c44ca}},7,"F-H0-2301",911,20},
  {{{0xff52bbe6d39c44ca}},7,"F-H0-2302",825,9},
  {{{0x80377bdbfaa46932}},7,"F-H0-2303",530,5},
  {{{0xff52bbe6d39c44ca}},7,"F-H0-2304",948,3},
  {{{0x612b8dbe128a35f3}},4,"F-H0-2305",947,18},
  {{{0xbc1669f2dceb2ddf}},4,"F-H0-2306",543,7},
  {{{0xbc1669f2dceb2ddf}},4,"F-H0-2307",838,3},
  {{{0xbc1669f2dceb2ddf}},4,"F-H0-2308",876,2},
  {{{0x612b8dbe128a35f3}},4,"F-H0-2309",839,2},
  {{{0x2e202011a3a5e43d}},4,"F-H0-2310",906,2},
  {{{0xe46f40bc46f112f4}},6,"F-H0-2311",421,23},
  {{{0x2555b23535f0437}},6,"F-H0-2312",432,16},
  {{{0x320ea10c59135fd6}},6,"F-H0-2313",873,14},
  {{{0x320ea10c59135fd6}},6,"F-H0-2314",838,5},
  {{{0x889ef7a4cee11f04}},6,"F-H0-2315",904,3},
  {{{0x2555b23535f0437}},6,"F-H0-2316",802,3},
  {{{0x2555b23535f0437}},6,"F-H0-2317",765,2},
  {{{0x2555b23535f0437}},6,"F-H0-2318",465,2},
  {{{0x2555b23535f0437}},6,"F-H0-2319",470,2},
  {{{0x2555b23535f0437}},6,"F-H0-2320",617,2},
  {{{0xe55628cff7eaa1cf}},11,"F-H0-2321",427,37},
  {{{0xe55628cff7eaa1cf}},11,"F-H0-2322",943,17},
  {{{0xe55628cff7eaa1cf}},11,"F-H0-2323",428,8},
  {{{0xe55628cff7eaa1cf}},11,"F-H0-2324",839,5},
  {{{0xe55628cff7eaa1cf}},11,"F-H0-2325",947,4},
  {{{0xe55628cff7eaa1cf}},11,"F-H0-2326",939,3},
  {{{0xe55628cff7eaa1cf}},11,"F-H0-2327",906,2},
  {{{0x9d2fda8ee8af17ea}},9,"F-H0-2328",863,43},
  {{{0xc1bf2595966c2b6}},9,"F-H0-2330",464,9},
  {{{0xc1bf2595966c2b6}},9,"F-H0-2331",428,4},
  {{{0x3dff96e250534bd1}},3,"F-H0-2332",469,19},
  {{{0xdb3bd5c9b787e7dc}},3,"F-H0-2333",468,17},
  {{{0xdb3bd5c9b787e7dc}},3,"F-H0-2334",493,7},
  {{{0xdb3bd5c9b787e7dc}},3,"F-H0-2335",492,5},
  {{{0x3dff96e250534bd1}},3,"F-H0-2336",825,4},
  {{{0x662bb807dcc904df}},3,"F-H0-2337",493,3},
  {{{0x3dff96e250534bd1}},3,"F-H0-2338",910,2},
  {{{0xdb3bd5c9b787e7dc}},3,"F-H0-2339",505,2},
  {{{0xc5d3701f8ff2b2f9}},6,"F-H0-2340",714,41},
  {{{0xc5d3701f8ff2b2f9}},6,"F-H0-2341",715,8},
  {{{0x7631c19b29f1880e}},6,"F-H0-2342",421,6},
  {{{0xc5d3701f8ff2b2f9}},6,"F-H0-2343",454,5},
  {{{0xc5d3701f8ff2b2f9}},6,"F-H0-2344",678,2},
  {{{0xf990148a299ad37a}},6,"F-H0-2345",825,2},
  {{{0xc381bd0c929e4cef}},7,"F-H0-2346",466,62},
  {{{0xc12d4e2e13f008fd}},7,"F-H0-2347",825,6},
  {{{0xa7eec122ec9b8baf}},5,"F-H0-2348",825,34},
  {{{0x94b7420465ca2a96}},5,"F-H0-2349",939,17},
  {{{0x44982c795cbf6410}},5,"F-H0-2350",899,5},
  {{{0xa7eec122ec9b8baf}},5,"F-H0-2351",462,3},
  {{{0xa7eec122ec9b8baf}},5,"F-H0-2352",690,2},
  {{{0xe8f72bc66259da2d}},5,"F-H0-2353",424,2},
  {{{0x23c6d1cb4928a5e6}},5,"F-H0-2354",727,2},
  {{{0xbce0d0258eee80dd}},6,"F-H0-2355",541,22},
  {{{0xbce0d0258eee80dd}},6,"F-H0-2356",432,18},
  {{{0xbce0d0258eee80dd}},6,"F-H0-2357",429,7},
  {{{0x86e5b715552383b4}},6,"F-H0-2358",826,2},
  {{{0xbce0d0258eee80dd}},6,"F-H0-2359",457,2},
  {{{0x645e29f8b1944e9e}},5,"F-H0-2360",429,35},
  {{{0x645e29f8b1944e9e}},5,"F-H0-2361",466,19},
  {{{0x645e29f8b1944e9e}},5,"F-H0-2362",653,11},
  {{{0x645e29f8b1944e9e}},5,"F-H0-2363",617,5},
  {{{0x576a0619c292d35e}},5,"F-H0-2364",906,5},
  {{{0x9f4a26d1f1538a29}},5,"F-H0-2365",899,4},
  {{{0x645e29f8b1944e9e}},5,"F-H0-2366",654,3},
  {{{0x82a518f743f2f053}},3,"F-H0-2367",900,40},
  {{{0x65028c7a5637ad8}},3,"F-H0-2368",455,27},
  {{{0x65028c7a5637ad8}},3,"F-H0-2369",493,3},
  {{{0x65028c7a5637ad8}},3,"F-H0-2370",492,2},
  {{{0x65028c7a5637ad8}},3,"F-H0-2371",912,2},
  {{{0x65028c7a5637ad8}},3,"F-H0-2372",838,2},
  {{{0x65028c7a5637ad8}},3,"F-H0-2373",419,2},
  {{{0x65028c7a5637ad8}},3,"F-H0-2374",900,2},
  {{{0x86b97f66bdb0824a}},2,"F-H0-2375",874,12},
  {{{0xba9ad2729907b010}},2,"F-H0-2376",530,4},
  {{{0x86b97f66bdb0824a}},2,"F-H0-2377",911,3},
  {{{0x5ef2f145def6e51b}},2,"F-H0-2378",863,3},
  {{{0x86b97f66bdb0824a}},2,"F-H0-2379",504,2},
  {{{0x86b97f66bdb0824a}},2,"F-H0-2380",948,2},
  {{{0x86b97f66bdb0824a}},2,"F-H0-2381",910,2},
  {{{0x86b97f66bdb0824a}},2,"F-H0-2382",876,2},
  {{{0x6a531ecaa2c539ac}},7,"F-H0-2383",899,31},
  {{{0x6a531ecaa2c539ac}},7,"F-H0-2384",973,24},
  {{{0x544bb7a38bbd786b}},7,"F-H0-2385",456,6},
  {{{0x189675278232f56f}},7,"F-H0-2386",502,2},
  {{{0xf61be3b57b025f79}},3,"F-H0-2387",913,28},
  {{{0xf61be3b57b025f79}},3,"F-H0-2388",912,18},
  {{{0xf61be3b57b025f79}},3,"F-H0-2389",950,10},
  {{{0xce8ca2d6893bd74}},3,"F-H0-2390",948,3},
  {{{0xf61be3b57b025f79}},3,"F-H0-2391",949,3},
  {{{0x96d9b0d831072290}},3,"F-H0-2392",505,3},
  {{{0xf61be3b57b025f79}},3,"F-H0-2393",911,3},
  {{{0xf61be3b57b025f79}},3,"F-H0-2394",862,2},
  {{{0x1e0c8ce36227a4c0}},8,"F-H0-2395",986,53},
  {{{0xd53db98327a63c46}},8,"F-H0-2396",791,8},
  {{{0xb647e329bf0421f5}},8,"F-H0-2397",715,6},
  {{{0xfd377f9e70596e7d}},8,"F-H0-2398",728,2},
  {{{0x8348eabd85c53f76}},6,"F-H0-2399",579,41},
  {{{0x28c359f42f18f5c9}},6,"F-H0-2400",948,10},
  {{{0x9deae06d7827abf3}},6,"F-H0-2401",838,9},
  {{{0xc2ea60398728504f}},6,"F-H0-2402",531,8},
  {{{0xe8ca3231ea4ce9fc}},6,"F-H0-2403",936,5},
  {{{0xe8ca3231ea4ce9fc}},6,"F-H0-2404",866,4},
  {{{0xe6a67f0ac2396034}},4,"F-H0-2405",493,27},
  {{{0xa46ab56a9c36867c}},4,"F-H0-2406",906,16},
  {{{0xa46ab56a9c36867c}},4,"F-H0-2407",468,16},
  {{{0xa46ab56a9c36867c}},4,"F-H0-2408",458,5},
  {{{0xa46ab56a9c36867c}},4,"F-H0-2409",420,4},
  {{{0xa46ab56a9c36867c}},4,"F-H0-2410",542,2},
  {{{0xa46ab56a9c36867c}},4,"F-H0-2411",677,2},
  {{{0xc0677625943430ca}},3,"F-H0-2412",455,22},
  {{{0xc0677625943430ca}},3,"F-H0-2413",419,14},
  {{{0xc0677625943430ca}},3,"F-H0-2414",456,11},
  {{{0xc0677625943430ca}},3,"F-H0-2415",493,4},
  {{{0x86c3461d88eec1db}},3,"F-H0-2416",432,3},
  {{{0xc0677625943430ca}},3,"F-H0-2417",492,3},
  {{{0xc0677625943430ca}},3,"F-H0-2418",420,2},
  {{{0x3d107bbfc9d4b9ff}},4,"F-H0-2419",875,28},
  {{{0x5a350a070dd0a818}},4,"F-H0-2420",839,19},
  {{{0xcf7324c7ca200506}},4,"F-H0-2421",948,10},
  {{{0xc2505ff7baf37f68}},4,"F-H0-2422",492,8},
  {{{0xcf7324c7ca200506}},4,"F-H0-2423",421,2},
  {{{0x72061477c4095573}},9,"F-H0-2424",640,43},
  {{{0xfac74e4311d9456e}},9,"F-H0-2425",906,16},
  {{{0xf558982ec6c7fd5d}},4,"F-H0-2426",456,19},
  {{{0xf2e3c689b115b590}},4,"F-H0-2427",420,13},
  {{{0xf558982ec6c7fd5d}},4,"F-H0-2428",455,12},
  {{{0xf558982ec6c7fd5d}},4,"F-H0-2429",752,9},
  {{{0xaa6faf3a56344ee}},4,"F-H0-2430",874,6},
  {{{0xaa6faf3a56344ee}},4,"F-H0-2431",506,5},
  {{{0xf558982ec6c7fd5d}},4,"F-H0-2432",788,4},
  {{{0xaa6faf3a56344ee}},4,"F-H0-2433",801,2},
  {{{0xf2e3c689b115b590}},4,"F-H0-2434",530,2},
  {{{0xfa09a61080cfacbd}},10,"F-H0-2435",424,44},
  {{{0xfa09a61080cfacbd}},10,"F-H0-2436",423,30},
  {{{0x65e627ef750e7a5}},10,"F-H0-2437",425,2},
  {{{0xd62c4a73b479200}},6,"F-H0-2438",948,33},
  {{{0xd62c4a73b479200}},6,"F-H0-2439",946,15},
  {{{0xd62c4a73b479200}},6,"F-H0-2440",908,13},
  {{{0xd62c4a73b479200}},6,"F-H0-2441",907,2},
  {{{0x472aa2ff20f84bb1}},6,"F-H0-2442",947,24},
  {{{0x1b353fc074860545}},6,"F-H0-2443",430,15},
  {{{0xf883d926bd4f4d3}},6,"F-H0-2444",751,14},
  {{{0xe799a86df031db03}},6,"F-H0-2445",751,9},
  {{{0x472aa2ff20f84bb1}},6,"F-H0-2446",543,5},
  {{{0x472aa2ff20f84bb1}},6,"F-H0-2447",529,4},
  {{{0xd864ac0f2623d40f}},6,"F-H0-2448",802,2},
  {{{0x853697ab8483f998}},5,"F-H0-2449",419,42},
  {{{0x2661395646e762ab}},5,"F-H0-2450",427,11},
  {{{0x853697ab8483f998}},5,"F-H0-2451",825,8},
  {{{0x853697ab8483f998}},5,"F-H0-2452",457,6},
  {{{0x853697ab8483f998}},5,"F-H0-2453",420,2},
  {{{0x853697ab8483f998}},5,"F-H0-2454",424,2},
  {{{0x853697ab8483f998}},5,"F-H0-2455",461,2},
  {{{0x63b35780b54877b8}},5,"F-H0-2456",764,26},
  {{{0xa6b10ba5bc8c2cb0}},5,"F-H0-2457",875,10},
  {{{0xa6b10ba5bc8c2cb0}},5,"F-H0-2458",946,9},
  {{{0x63b35780b54877b8}},5,"F-H0-2459",728,7},
  {{{0x63b35780b54877b8}},5,"F-H0-2460",910,7},
  {{{0x63b35780b54877b8}},5,"F-H0-2461",727,4},
  {{{0xa6b10ba5bc8c2cb0}},5,"F-H0-2462",945,2},
  {{{0xbfa50139b0ee9cff}},3,"F-H0-2463",456,42},
  {{{0x41d6d938329ab41d}},3,"F-H0-2464",949,13},
  {{{0x41d6d938329ab41d}},3,"F-H0-2465",911,3},
  {{{0xbfa50139b0ee9cff}},3,"F-H0-2466",948,2},
  {{{0x2ce8102084d550c}},3,"F-H0-2467",899,2},
  {{{0xefa8db691719f5e9}},5,"F-H0-2468",838,30},
  {{{0xefa8db691719f5e9}},5,"F-H0-2469",950,16},
  {{{0x4826cbbfabab2259}},5,"F-H0-2470",492,5},
  {{{0xefa8db691719f5e9}},5,"F-H0-2471",801,4},
  {{{0x4b6bd291d0250aec}},5,"F-H0-2472",429,3},
  {{{0xefa8db691719f5e9}},5,"F-H0-2473",421,3},
  {{{0xc0e5b9c20a8985fc}},5,"F-H0-2474",825,3},
  {{{0xd1bcaa655a7dab0e}},16,"F-H0-2475",947,23},
  {{{0xd1bcaa655a7dab0e}},16,"F-H0-2476",910,20},
  {{{0xf40ee1c6e9850b02}},16,"F-H0-2477",910,5},
  {{{0xd1bcaa655a7dab0e}},16,"F-H0-2478",727,3},
  {{{0x45d779cc66e651a2}},2,"F-H0-2479",913,35},
  {{{0x45d779cc66e651a2}},2,"F-H0-2480",912,14},
  {{{0xa6fcda9dc4dd7f3}},2,"F-H0-2481",949,7},
  {{{0x64da5f4a74608db8}},2,"F-H0-2482",468,5},
  {{{0x317622624f099ba9}},2,"F-H0-2483",492,4},
  {{{0x45d779cc66e651a2}},2,"F-H0-2484",419,2},
  {{{0x672fae4b74aff6de}},3,"F-H0-2485",493,18},
  {{{0x5926ec1f59ea1e24}},3,"F-H0-2486",456,11},
  {{{0x5926ec1f59ea1e24}},3,"F-H0-2487",493,5},
  {{{0x53f9380404763320}},3,"F-H0-2488",876,4},
  {{{0x5926ec1f59ea1e24}},3,"F-H0-2489",939,3},
  {{{0xff4af4524a352366}},3,"F-H0-2490",949,3},
  {{{0x5926ec1f59ea1e24}},3,"F-H0-2491",494,2},
  {{{0x5926ec1f59ea1e24}},3,"F-H0-2492",492,2},
  {{{0x53f9380404763320}},3,"F-H0-2493",950,2},
  {{{0x750eff011e94cffb}},10,"F-H0-2494",826,5},
  {{{0x24cc13c45833761c}},10,"F-H0-2495",945,4},
  {{{0x24cc13c45833761c}},10,"F-H0-2496",907,3},
  {{{0x24cc13c45833761c}},10,"F-H0-2497",427,2},
  {{{0x750eff011e94cffb}},10,"F-H0-2498",902,2},
  {{{0x1f100d7191eba2df}},4,"F-H0-2499",431,21},
  {{{0x2f5df1d57f853548}},4,"F-H0-2500",875,17},
  {{{0x6e67a37c02bacac9}},4,"F-H0-2501",424,10},
  {{{0x1f100d7191eba2df}},4,"F-H0-2502",907,8},
  {{{0x2f5df1d57f853548}},4,"F-H0-2503",876,4},
  {{{0x1f100d7191eba2df}},4,"F-H0-2504",948,4},
  {{{0x6e67a37c02bacac9}},4,"F-H0-2505",901,3},
  {{{0x1f100d7191eba2df}},4,"F-H0-2506",432,2},
  {{{0x1f100d7191eba2df}},4,"F-H0-2507",691,2},
  {{{0x7d1af91816a6eb92}},6,"F-H0-2508",421,49},
  {{{0xa86b1e3e6b18ab4b}},6,"F-H0-2509",912,16},
  {{{0x58dbce03574ec8ee}},16,"F-H0-2510",947,57},
  {{{0x7d6985a0e4b668e2}},16,"F-H0-2511",802,5},
  {{{0xb1e74758a498b87b}},16,"F-H0-2512",751,3},
  {{{0x5ca683e585d1a544}},16,"F-H0-2513",905,2},
  {{{0x5ca683e585d1a544}},16,"F-H0-2514",826,2},
  {{{0xd0686863acff47a6}},4,"F-H0-2515",418,19},
  {{{0x5f201b3fb9ec0a1c}},4,"F-H0-2516",940,4},
  {{{0x5f201b3fb9ec0a1c}},4,"F-H0-2517",941,3},
  {{{0x2b161422b91b0e74}},4,"F-H0-2518",906,3},
  {{{0x5f201b3fb9ec0a1c}},4,"F-H0-2519",456,2},
  {{{0x5d04539e5b8da0cf}},8,"F-H0-2520",940,20},
  {{{0x5d04539e5b8da0cf}},8,"F-H0-2521",944,15},
  {{{0x5d04539e5b8da0cf}},8,"F-H0-2522",907,13},
  {{{0x5d04539e5b8da0cf}},8,"F-H0-2523",941,7},
  {{{0xd927f3e427cae26e}},8,"F-H0-2524",825,5},
  {{{0x5d04539e5b8da0cf}},8,"F-H0-2525",529,4},
  {{{0x5d04539e5b8da0cf}},8,"F-H0-2526",945,3},
  {{{0x651dc854a7448018}},3,"F-H0-2527",430,23},
  {{{0xe5df3e0b2e247f3c}},3,"F-H0-2528",455,9},
  {{{0xe5df3e0b2e247f3c}},3,"F-H0-2529",457,7},
  {{{0xf44b76c25c57b3e8}},3,"F-H0-2530",948,4},
  {{{0x651dc854a7448018}},3,"F-H0-2531",467,4},
  {{{0x81db2ef727d79f4b}},3,"F-H0-2532",456,3},
  {{{0x2301b1bad9df5bec}},7,"F-H0-2533",678,39},
  {{{0x2116b80c6d91efa3}},7,"F-H0-2534",974,19},
  {{{0x2301b1bad9df5bec}},7,"F-H0-2535",715,6},
  {{{0x250fc78854ebbf4d}},5,"F-H0-2536",505,24},
  {{{0x3f52c287fb0ca317}},5,"F-H0-2537",876,8},
  {{{0x3f52c287fb0ca317}},5,"F-H0-2538",838,6},
  {{{0x201a9bf8b76462e1}},5,"F-H0-2539",947,5},
  {{{0x201a9bf8b76462e1}},5,"F-H0-2540",427,4},
  {{{0x9aadd204bd9e70fe}},5,"F-H0-2541",940,2},
  {{{0x201a9bf8b76462e1}},5,"F-H0-2542",825,2},
  {{{0x1ce9e76a60f9dbe}},5,"F-H0-2543",765,2},
  {{{0x9468f4286a2f9c00}},6,"F-H0-2544",909,25},
  {{{0x9468f4286a2f9c00}},6,"F-H0-2545",948,11},
  {{{0xec31fc57338fb327}},6,"F-H0-2546",541,8},
  {{{0xbc99f9988b2c7c81}},6,"F-H0-2547",568,7},
  {{{0xbc99f9988b2c7c81}},6,"F-H0-2548",530,5},
  {{{0x9468f4286a2f9c00}},6,"F-H0-2549",950,5},
  {{{0xec31fc57338fb327}},6,"F-H0-2550",457,3},
  {{{0xec31fc57338fb327}},6,"F-H0-2551",616,2},
  {{{0xe9fab5d019d254bd}},6,"F-H0-2552",529,2},
  {{{0x2624d6ec507529b4}},4,"F-H0-2553",456,13},
  {{{0x801b42a22a4aef67}},4,"F-H0-2554",938,13},
  {{{0x2624d6ec507529b4}},4,"F-H0-2555",455,11},
  {{{0x801b42a22a4aef67}},4,"F-H0-2556",913,6},
  {{{0x2624d6ec507529b4}},4,"F-H0-2557",752,6},
  {{{0x801b42a22a4aef67}},4,"F-H0-2558",864,5},
  {{{0x801b42a22a4aef67}},4,"F-H0-2559",826,4},
  {{{0x2624d6ec507529b4}},4,"F-H0-2560",492,2},
  {{{0x4a5d5b5b1403d12e}},14,"F-H0-2561",765,32},
  {{{0xec54ad35f50ca521}},14,"F-H0-2562",826,14},
  {{{0xec54ad35f50ca521}},14,"F-H0-2563",902,7},
  {{{0x4a5d5b5b1403d12e}},14,"F-H0-2564",837,7},
  {{{0xec54ad35f50ca521}},14,"F-H0-2565",715,2},
  {{{0x2e4b315ce6ebba94}},8,"F-H0-2566",470,43},
  {{{0x2e4b315ce6ebba94}},8,"F-H0-2567",539,4},
  {{{0x2e4b315ce6ebba94}},8,"F-H0-2568",727,4},
  {{{0xf1582bb68e35d2fe}},16,"F-H0-2569",941,49},
  {{{0x469da516f3e07371}},16,"F-H0-2570",654,3},
  {{{0x813c7e114479d028}},6,"F-H0-2571",906,6},
  {{{0xbdcd9f2a95371203}},6,"F-H0-2572",839,5},
  {{{0x813c7e114479d028}},6,"F-H0-2573",429,5},
  {{{0x813c7e114479d028}},6,"F-H0-2574",457,5},
  {{{0x813c7e114479d028}},6,"F-H0-2575",543,3},
  {{{0x813c7e114479d028}},6,"F-H0-2576",425,2},
  {{{0x813c7e114479d028}},6,"F-H0-2577",426,2},
  {{{0xfc5f2a808caecbaa}},9,"F-H0-2578",654,32},
  {{{0x88efd3dc29b41d65}},9,"F-H0-2579",908,22},
  {{{0xfc5f2a808caecbaa}},9,"F-H0-2580",506,5},
  {{{0xae106df46ca95d52}},4,"F-H0-2581",457,17},
  {{{0xae106df46ca95d52}},4,"F-H0-2582",420,16},
  {{{0x62e114a56262e275}},4,"F-H0-2583",875,15},
  {{{0x62e114a56262e275}},4,"F-H0-2584",430,10},
  {{{0x62e114a56262e275}},4,"F-H0-2585",876,3},
  {{{0x2056d3ade66aae83}},4,"F-H0-2586",543,3},
  {{{0x42cc75210a5f5e7a}},4,"F-H0-2587",542,2},
  {{{0x2efaa1ba4808c21f}},6,"F-H0-2588",429,23},
  {{{0x2efaa1ba4808c21f}},6,"F-H0-2589",802,21},
  {{{0x2efaa1ba4808c21f}},6,"F-H0-2590",764,15},
  {{{0x2efaa1ba4808c21f}},6,"F-H0-2591",910,4},
  {{{0x2efaa1ba4808c21f}},6,"F-H0-2592",801,2},
  {{{0xd9236934c93dcc9e}},7,"F-H0-2593",432,25},
  {{{0x2feb2c4e5a2a8b63}},7,"F-H0-2594",422,11},
  {{{0xd9236934c93dcc9e}},7,"F-H0-2595",825,10},
  {{{0xd9236934c93dcc9e}},7,"F-H0-2596",947,9},
  {{{0xd9236934c93dcc9e}},7,"F-H0-2597",839,4},
  {{{0xd9236934c93dcc9e}},7,"F-H0-2598",617,3},
  {{{0x30e0479145560c87}},9,"F-H0-2599",839,22},
  {{{0x9ad8262165136410}},9,"F-H0-2600",428,12},
  {{{0x9ad8262165136410}},9,"F-H0-2601",653,9},
  {{{0x9ad8262165136410}},9,"F-H0-2602",617,5},
  {{{0x9ad8262165136410}},9,"F-H0-2603",466,3},
  {{{0x9ad8262165136410}},9,"F-H0-2604",458,3},
  {{{0x9ad8262165136410}},9,"F-H0-2605",690,2},
  {{{0x9c4764f31e7bb74a}},6,"F-H0-2606",531,22},
  {{{0xa6896cd68270cd7}},6,"F-H0-2607",825,16},
  {{{0xc19b7971a4afed40}},6,"F-H0-2608",429,7},
  {{{0xd3ff086c7d1d5ec5}},6,"F-H0-2609",432,7},
  {{{0xd3ff086c7d1d5ec5}},6,"F-H0-2610",728,7},
  {{{0xd3ff086c7d1d5ec5}},6,"F-H0-2611",466,5},
  {{{0xd3ff086c7d1d5ec5}},6,"F-H0-2612",615,4},
  {{{0xd3ff086c7d1d5ec5}},6,"F-H0-2613",876,3},
  {{{0x6b0960369efbd681}},5,"F-H0-2614",911,32},
  {{{0x6b0960369efbd681}},5,"F-H0-2615",947,12},
  {{{0x6b0960369efbd681}},5,"F-H0-2616",943,9},
  {{{0x6b0960369efbd681}},5,"F-H0-2617",910,6},
  {{{0x6b0960369efbd681}},5,"F-H0-2618",944,4},
  {{{0x35a48857b77388a2}},5,"F-H0-2619",906,3},
  {{{0x6b0960369efbd681}},5,"F-H0-2620",948,2},
  {{{0x6b0960369efbd681}},5,"F-H0-2621",942,2},
  {{{0xc9fbb9e949c79926}},4,"F-H0-2622",431,20},
  {{{0xc9fbb9e949c79926}},4,"F-H0-2623",944,13},
  {{{0xd641c1f8be5d1021}},4,"F-H0-2624",543,10},
  {{{0xc9fbb9e949c79926}},4,"F-H0-2625",907,6},
  {{{0x5917ea097e42e5a2}},4,"F-H0-2626",492,5},
  {{{0x9f8b06310d76127a}},4,"F-H0-2627",943,4},
  {{{0x2bc9cdca62029a85}},4,"F-H0-2628",906,2},
  {{{0xc9fbb9e949c79926}},4,"F-H0-2629",911,2},
  {{{0x3268a0d89cf8e761}},7,"F-H0-2630",949,50},
  {{{0x9f25eea0b2a9d843}},7,"F-H0-2631",899,10},
  {{{0x3dc0139a84301e5d}},8,"F-H0-2632",902,20},
  {{{0x3dc0139a84301e5d}},8,"F-H0-2633",715,13},
  {{{0x9f9a92af09c0f026}},8,"F-H0-2634",945,10},
  {{{0xaaf58156addd84c3}},8,"F-H0-2635",838,5},
  {{{0xaaf58156addd84c3}},8,"F-H0-2636",947,5},
  {{{0xf2d4274c7fbaf31d}},8,"F-H0-2637",462,3},
  {{{0xf233d52d9911e5f1}},8,"F-H0-2638",543,21},
  {{{0xf233d52d9911e5f1}},8,"F-H0-2639",690,18},
  {{{0xf233d52d9911e5f1}},8,"F-H0-2640",421,4},
  {{{0xe5278ff6fcf3f51f}},8,"F-H0-2641",905,4},
  {{{0x4847356f42d9376c}},8,"F-H0-2642",691,2},
  {{{0x1fab0a2bb5460d2f}},8,"F-H0-2643",640,2},
  {{{0x23e38c947b45462a}},4,"F-H0-2644",826,15},
  {{{0xd74f69e4285ca86b}},4,"F-H0-2645",456,11},
  {{{0x6178de2374c9dfba}},4,"F-H0-2646",910,9},
  {{{0xd74f69e4285ca86b}},4,"F-H0-2647",765,7},
  {{{0x23e38c947b45462a}},4,"F-H0-2648",469,7},
  {{{0xd74f69e4285ca86b}},4,"F-H0-2649",947,4},
  {{{0x6178de2374c9dfba}},4,"F-H0-2650",690,4},
  {{{0xd74f69e4285ca86b}},4,"F-H0-2651",690,4},
  {{{0xd74f69e4285ca86b}},4,"F-H0-2652",837,3},
  {{{0xca324155d994c42f}},8,"F-H0-2653",654,54},
  {{{0x5dc65e7c809a504c}},8,"F-H0-2654",531,2},
  {{{0x5c2f0bae75c1364d}},8,"F-H0-2655",906,2},
  {{{0xf845575da26232b9}},4,"F-H0-2656",543,16},
  {{{0x6c4f6c94ad3cc7d7}},4,"F-H0-2657",947,10},
  {{{0xf845575da26232b9}},4,"F-H0-2658",943,3},
  {{{0x622e98877cb9aef6}},4,"F-H0-2659",431,3},
  {{{0xf845575da26232b9}},4,"F-H0-2660",905,2},
  {{{0xf845575da26232b9}},4,"F-H0-2661",579,2},
  {{{0xf845575da26232b9}},4,"F-H0-2662",690,2},
  {{{0xf845575da26232b9}},4,"F-H0-2663",942,2},
  {{{0x2f811cb372158d9e}},5,"F-H0-2664",420,22},
  {{{0x1e373949d97ac061}},5,"F-H0-2665",464,13},
  {{{0x2f811cb372158d9e}},5,"F-H0-2666",863,9},
  {{{0x1e373949d97ac061}},5,"F-H0-2667",542,8},
  {{{0x1e373949d97ac061}},5,"F-H0-2668",428,6},
  {{{0x1e373949d97ac061}},5,"F-H0-2669",876,3},
  {{{0x1e373949d97ac061}},5,"F-H0-2670",465,2},
  {{{0xf4364b866b6ae832}},9,"F-H0-2671",950,46},
  {{{0xf4364b866b6ae832}},9,"F-H0-2672",873,9},
  {{{0xf4364b866b6ae832}},9,"F-H0-2673",839,4},
  {{{0xf4364b866b6ae832}},9,"F-H0-2674",908,2},
  {{{0x36e51ea513c17e63}},8,"F-H0-2675",678,37},
  {{{0x201688f21b5cd9e0}},8,"F-H0-2676",543,11},
  {{{0x201688f21b5cd9e0}},8,"F-H0-2677",421,3},
  {{{0x201688f21b5cd9e0}},8,"F-H0-2678",425,3},
  {{{0x35b9c69369ef4748}},3,"F-H0-2679",456,42},
  {{{0x35b9c69369ef4748}},3,"F-H0-2680",455,21},
  {{{0x35b9c69369ef4748}},3,"F-H0-2681",913,2},
  {{{0x30a325f1706172fa}},5,"F-H0-2682",429,18},
  {{{0x6bd5d5c780561e31}},5,"F-H0-2683",463,12},
  {{{0x30a325f1706172fa}},5,"F-H0-2684",911,11},
  {{{0x6bd5d5c780561e31}},5,"F-H0-2685",542,9},
  {{{0x6bd5d5c780561e31}},5,"F-H0-2686",901,3},
  {{{0x30a325f1706172fa}},5,"F-H0-2687",617,3},
  {{{0x30a325f1706172fa}},5,"F-H0-2688",690,3},
  {{{0xabe6abf5c5824e67}},5,"F-H0-2689",690,3},
  {{{0xabe6abf5c5824e67}},5,"F-H0-2690",910,2},
  {{{0x645d32fb774f7668}},5,"F-H0-2691",948,2},
  {{{0x96273eeb840301bc}},6,"F-H0-2692",678,29},
  {{{0x75f5634a3ed2fe90}},6,"F-H0-2693",382,18},
  {{{0x96273eeb840301bc}},6,"F-H0-2694",543,2},
  {{{0xb77697100bcdf4c9}},6,"F-H0-2695",728,2},
  {{{0x19cffb924a8bd1d1}},5,"F-H0-2696",466,15},
  {{{0x19cffb924a8bd1d1}},5,"F-H0-2697",653,11},
  {{{0x19cffb924a8bd1d1}},5,"F-H0-2698",429,10},
  {{{0x19cffb924a8bd1d1}},5,"F-H0-2699",911,6},
  {{{0x19cffb924a8bd1d1}},5,"F-H0-2700",690,3},
  {{{0x19cffb924a8bd1d1}},5,"F-H0-2701",910,3},
  {{{0x19cffb924a8bd1d1}},5,"F-H0-2702",617,2},
  {{{0x6d03894a07efb0fb}},1,"F-H0-2703",468,23},
  {{{0x6d03894a07efb0fb}},1,"F-H0-2704",456,17},
  {{{0x8e6dea9bcbfba9a4}},1,"F-H0-2705",912,6},
  {{{0x85c58372033bbf65}},1,"F-H0-2706",874,3},
  {{{0x85c58372033bbf65}},1,"F-H0-2707",911,3},
  {{{0x6d03894a07efb0fb}},1,"F-H0-2708",948,2},
  {{{0x85c58372033bbf65}},1,"F-H0-2709",900,2},
  {{{0x85c58372033bbf65}},1,"F-H0-2710",455,2},
  {{{0xb3f54a2909fc8140}},4,"F-H0-2711",906,22},
  {{{0x66d9867e022fac27}},4,"F-H0-2712",949,19},
  {{{0xb3f54a2909fc8140}},4,"F-H0-2713",543,18},
  {{{0xb3f54a2909fc8140}},4,"F-H0-2714",426,2},
  {{{0xb3f54a2909fc8140}},4,"F-H0-2715",492,2},
  {{{0xff7c0b759bc58a53}},4,"F-H0-2716",419,20},
  {{{0x8be8e9451daf3a05}},4,"F-H0-2717",912,17},
  {{{0xff7c0b759bc58a53}},4,"F-H0-2718",764,9},
  {{{0xff7c0b759bc58a53}},4,"F-H0-2719",911,8},
  {{{0xff7c0b759bc58a53}},4,"F-H0-2720",455,3},
  {{{0x8be8e9451daf3a05}},4,"F-H0-2721",423,2},
  {{{0x8be8e9451daf3a05}},4,"F-H0-2722",419,2},
  {{{0xff7c0b759bc58a53}},4,"F-H0-2723",728,2},
  {{{0xff7c0b759bc58a53}},4,"F-H0-2724",802,2},
  {{{0xeada8bdf35517e4e}},6,"F-H0-2725",542,19},
  {{{0xb2d494f351bd6dcf}},6,"F-H0-2726",541,9},
  {{{0xb2d494f351bd6dcf}},6,"F-H0-2727",504,9},
  {{{0x9c87db09945b9112}},6,"F-H0-2728",493,7},
  {{{0x9c87db09945b9112}},6,"F-H0-2729",456,3},
  {{{0x9c87db09945b9112}},6,"F-H0-2730",418,2},
  {{{0x647950471eb336aa}},6,"F-H0-2731",802,2},
  {{{0x1439e4d47239c012}},14,"F-H0-2732",943,50},
  {{{0x752cfd0bfc81b6c5}},5,"F-H0-2733",826,28},
  {{{0x8e0b1f6d77746545}},5,"F-H0-2734",429,16},
  {{{0x52c453bd49f59664}},5,"F-H0-2735",418,6},
  {{{0x8db52fe59c34b8bb}},5,"F-H0-2736",948,5},
  {{{0x8e0b1f6d77746545}},5,"F-H0-2737",543,3},
  {{{0x8db52fe59c34b8bb}},5,"F-H0-2738",825,2},
  {{{0x4b5379b345fe1348}},7,"F-H0-2739",431,60},
  {{{0xd3304b1533c35b82}},9,"F-H0-2740",421,35},
  {{{0x99288b2b356ff8fb}},9,"F-H0-2741",838,12},
  {{{0x700dab480c1aef45}},9,"F-H0-2742",432,11},
  {{{0xd3304b1533c35b82}},9,"F-H0-2743",454,2},
  {{{0xd530560089418fee}},2,"F-H0-2744",432,11},
  {{{0xed3743682bf1cfdc}},2,"F-H0-2745",936,10},
  {{{0xd530560089418fee}},2,"F-H0-2746",913,6},
  {{{0xed3743682bf1cfdc}},2,"F-H0-2747",901,3},
  {{{0x4be5b9d2db835784}},2,"F-H0-2748",455,3},
  {{{0x330ba6aaa75b0501}},2,"F-H0-2749",949,3},
  {{{0xd530560089418fee}},2,"F-H0-2750",912,3},
  {{{0x4be5b9d2db835784}},2,"F-H0-2751",420,2},
  {{{0xd530560089418fee}},2,"F-H0-2752",469,2},
  {{{0xd530560089418fee}},2,"F-H0-2753",430,2},
  {{{0x968897f199d8375a}},8,"F-H0-2754",506,49},
  {{{0xba35e7b4e407ba55}},17,"F-H0-2755",872,40},
  {{{0x9232f0541e5828ed}},17,"F-H0-2756",909,3},
  {{{0xba35e7b4e407ba55}},17,"F-H0-2757",862,3},
  {{{0xf551336e0cd474f2}},17,"F-H0-2758",825,2},
  {{{0x9579554a5eab823}},17,"F-H0-2759",604,2},
  {{{0xf551336e0cd474f2}},17,"F-H0-2760",800,2},
  {{{0xe9b1da5f6eec9ac2}},3,"F-H0-2761",912,39},
  {{{0xbc4c995da4fc3d0f}},3,"F-H0-2762",469,6},
  {{{0xbc4c995da4fc3d0f}},3,"F-H0-2763",506,6},
  {{{0x7139b534f2591fd}},3,"F-H0-2764",493,4},
  {{{0x4c41d276e2223ed2}},3,"F-H0-2765",937,2},
  {{{0x7139b534f2591fd}},3,"F-H0-2766",942,2},
  {{{0xc88d9563131e0ab3}},5,"F-H0-2767",603,14},
  {{{0x63ac2238a131d74a}},5,"F-H0-2768",466,13},
  {{{0x63ac2238a131d74a}},5,"F-H0-2769",653,12},
  {{{0xc88d9563131e0ab3}},5,"F-H0-2770",421,7},
  {{{0x613bedd20b71149b}},5,"F-H0-2771",690,6},
  {{{0xa9ead2ebbc493700}},5,"F-H0-2772",802,2},
  {{{0x63ac2238a131d74a}},5,"F-H0-2773",654,2},
  {{{0x51fbba66fe1eff50}},4,"F-H0-2774",790,7},
  {{{0x51fbba66fe1eff50}},4,"F-H0-2775",828,6},
  {{{0x49ca6c885f676c61}},4,"F-H0-2776",691,5},
  {{{0x51fbba66fe1eff50}},4,"F-H0-2777",640,4},
  {{{0x49ca6c885f676c61}},4,"F-H0-2778",945,4},
  {{{0x51fbba66fe1eff50}},4,"F-H0-2779",456,2},
  {{{0x49ca6c885f676c61}},4,"F-H0-2780",506,2},
  {{{0x61017dc40781f6f1}},4,"F-H0-2781",912,28},
  {{{0x6c96768ad7397c3e}},4,"F-H0-2782",678,4},
  {{{0x7be3e5c6e5df42cc}},4,"F-H0-2783",911,3},
  {{{0xffd4921655432e9b}},4,"F-H0-2784",455,3},
  {{{0xe5360a14b71d9aa6}},4,"F-H0-2785",947,2},
  {{{0x7be3e5c6e5df42cc}},4,"F-H0-2786",948,2},
  {{{0x17411e3f68ef26b9}},15,"F-H0-2787",905,53},
  {{{0xbc4297041d037fe2}},3,"F-H0-2788",455,27},
  {{{0x45b2096e8bc5b66f}},3,"F-H0-2789",457,14},
  {{{0x45b2096e8bc5b66f}},3,"F-H0-2790",912,6},
  {{{0xcfb55ee5c13818dd}},3,"F-H0-2791",492,6},
  {{{0x45b2096e8bc5b66f}},3,"F-H0-2792",950,3},
  {{{0x45b2096e8bc5b66f}},3,"F-H0-2793",948,2},
  {{{0x9f946dc0987e91e8}},8,"F-H0-2794",838,42},
  {{{0x1c5fbd3d83ff9947}},6,"F-H0-2795",728,47},
  {{{0x1c5fbd3d83ff9947}},6,"F-H0-2796",470,4},
  {{{0x1c5fbd3d83ff9947}},6,"F-H0-2797",727,3},
  {{{0x80c1f84bb6c83e27}},6,"F-H0-2798",462,2},
  {{{0xb84eda7ebd9f894b}},6,"F-H0-2799",691,2},
  {{{0x41359a9e40e3f6d7}},4,"F-H0-2800",948,18},
  {{{0x41359a9e40e3f6d7}},4,"F-H0-2801",911,16},
  {{{0x9341c8e5ac5d5f41}},4,"F-H0-2802",492,7},
  {{{0xd473b45e87135bc9}},4,"F-H0-2803",947,4},
  {{{0x6e34abcd7d6f6cb9}},4,"F-H0-2804",542,2},
  {{{0x41359a9e40e3f6d7}},4,"F-H0-2805",543,2},
  {{{0x35a7c6fe77b3acb0}},5,"F-H0-2806",911,34},
  {{{0x35a7c6fe77b3acb0}},5,"F-H0-2807",948,8},
  {{{0x35a7c6fe77b3acb0}},5,"F-H0-2808",902,4},
  {{{0x35a7c6fe77b3acb0}},5,"F-H0-2809",910,4},
  {{{0x35a7c6fe77b3acb0}},5,"F-H0-2810",505,3},
  {{{0xdde718d6c890b5d9}},7,"F-H0-2811",469,53},
  {{{0xb95281d2ff7b7b70}},7,"F-H0-2812",899,3},
  {{{0xf05c8e857ac43171}},9,"F-H0-2813",727,47},
  {{{0x36960b91aa2c75c}},6,"F-H0-2814",421,50},
  {{{0xb40976fde37d5527}},6,"F-H0-2815",912,8},
  {{{0x670fa90177ce2925}},6,"F-H0-2816",432,34},
  {{{0xe958d5aca3245e71}},6,"F-H0-2817",865,13},
  {{{0x670fa90177ce2925}},6,"F-H0-2818",429,4},
  {{{0x670fa90177ce2925}},6,"F-H0-2819",616,2},
  {{{0x8f25ce336003bb43}},16,"F-H0-2820",454,30},
  {{{0x496cfa64a22bb94e}},16,"F-H0-2821",417,24},
  {{{0xe90a2c9c048802c9}},9,"F-H0-2822",947,32},
  {{{0xe90a2c9c048802c9}},9,"F-H0-2823",825,17},
  {{{0xe90a2c9c048802c9}},9,"F-H0-2824",943,5},
  {{{0xe90a2c9c048802c9}},9,"F-H0-2825",939,2},
  {{{0x8ef97b2b05e6cee1}},5,"F-H0-2826",429,19},
  {{{0x8ef97b2b05e6cee1}},5,"F-H0-2827",466,11},
  {{{0x95748ddcc8bd4db9}},5,"F-H0-2828",945,10},
  {{{0x8ef97b2b05e6cee1}},5,"F-H0-2829",911,9},
  {{{0x95748ddcc8bd4db9}},5,"F-H0-2830",907,6},
  {{{0x8ef97b2b05e6cee1}},5,"F-H0-2831",910,3},
  {{{0x9d6c3580758f5fc6}},5,"F-H0-2832",543,35},
  {{{0x9c02f375543df1c3}},5,"F-H0-2833",912,7},
  {{{0x64f056b6886b5121}},9,"F-H0-2834",950,48},
  {{{0xcca1a099fdfda866}},9,"F-H0-2835",579,3},
  {{{0x64f056b6886b5121}},9,"F-H0-2836",799,2},
  {{{0xdc8efb6a019c0af0}},7,"F-H0-2837",566,18},
  {{{0x983d0ecb950be4a0}},7,"F-H0-2838",790,12},
  {{{0xc043b0b1f8048f0a}},7,"F-H0-2839",910,12},
  {{{0xc043b0b1f8048f0a}},7,"F-H0-2840",913,5},
  {{{0xdc8efb6a019c0af0}},7,"F-H0-2841",461,5},
  {{{0x983d0ecb950be4a0}},7,"F-H0-2842",903,2},
  {{{0x71addf4e6e17c08c}},7,"F-H0-2843",690,2},
  {{{0xb6c279331647aefd}},9,"F-H0-2844",432,49},
  {{{0xc9f24612ed059484}},9,"F-H0-2845",903,2},
  {{{0x7f2718c0e1afbd33}},6,"F-H0-2846",543,28},
  {{{0x46b3418de531a116}},6,"F-H0-2847",825,6},
  {{{0x7f2718c0e1afbd33}},6,"F-H0-2848",839,3},
  {{{0x6b7429031ddbdd72}},6,"F-H0-2849",765,3},
  {{{0x2dfc66cdc0847a24}},6,"F-H0-2850",690,2},
  {{{0x6b7429031ddbdd72}},6,"F-H0-2851",425,2},
  {{{0x2828cf8b7a09f381}},3,"F-H0-2852",468,8},
  {{{0x2828cf8b7a09f381}},3,"F-H0-2853",906,7},
  {{{0x2828cf8b7a09f381}},3,"F-H0-2854",825,5},
  {{{0x2828cf8b7a09f381}},3,"F-H0-2855",455,4},
  {{{0xb6fd205928cb2beb}},3,"F-H0-2856",948,3},
  {{{0xc988139439e48951}},3,"F-H0-2857",678,2},
  {{{0x2828cf8b7a09f381}},3,"F-H0-2858",939,2},
  {{{0xec3804ac4f413b47}},6,"F-H0-2859",529,14},
  {{{0x3505d640d5a806d2}},6,"F-H0-2860",460,12},
  {{{0xec3804ac4f413b47}},6,"F-H0-2861",678,11},
  {{{0xec3804ac4f413b47}},6,"F-H0-2862",429,6},
  {{{0xec3804ac4f413b47}},6,"F-H0-2863",425,4},
  {{{0xec3804ac4f413b47}},6,"F-H0-2864",765,3},
  {{{0x4aca9377be2306db}},6,"F-H0-2865",465,3},
  {{{0x29748fa632945bc2}},7,"F-H0-2866",678,38},
  {{{0x97a16737bac71c73}},7,"F-H0-2867",914,5},
  {{{0x29748fa632945bc2}},7,"F-H0-2868",715,4},
  {{{0xd917276bd8578af9}},8,"F-H0-2869",431,51},
  {{{0xa6a23bd5bb20cd2d}},7,"F-H0-2870",826,40},
  {{{0x92db696dd33d3a15}},7,"F-H0-2871",839,11},
  {{{0xa236ebdb0ae722c2}},7,"F-H0-2872",826,42},
  {{{0x4ff2dab26f48aa5f}},7,"F-H0-2873",466,7},
  {{{0x4ff2dab26f48aa5f}},7,"F-H0-2874",504,2},
  {{{0xcd05cca7aa5933c7}},9,"F-H0-2875",467,51},
  {{{0x1fa3abf1b07e0a08}},9,"F-H0-2876",395,2},
  {{{0x2b52716e72e46da7}},4,"F-H0-2877",908,18},
  {{{0x73c25b3efb1c7de6}},4,"F-H0-2878",900,11},
  {{{0x2b52716e72e46da7}},4,"F-H0-2879",431,10},
  {{{0x827b34d7e4ba0758}},4,"F-H0-2880",492,9},
  {{{0x827b34d7e4ba0758}},4,"F-H0-2881",458,5},
  {{{0x827b34d7e4ba0758}},4,"F-H0-2882",566,4},
  {{{0x2b52716e72e46da7}},4,"F-H0-2883",801,2},
  {{{0xbca899856f104cb2}},8,"F-H0-2884",945,25},
  {{{0xbca899856f104cb2}},8,"F-H0-2885",839,6},
  {{{0xbca899856f104cb2}},8,"F-H0-2886",838,6},
  {{{0xbca899856f104cb2}},8,"F-H0-2887",906,3},
  {{{0xe5963ecc444c31fd}},8,"F-H0-2888",838,3},
  {{{0xbca899856f104cb2}},8,"F-H0-2889",907,2},
  {{{0x3e153de5f24856da}},3,"F-H0-2890",543,9},
  {{{0x97cb78320a123b32}},3,"F-H0-2891",900,3},
  {{{0x97cb78320a123b32}},3,"F-H0-2892",937,2},
  {{{0xf4eaf217f0dbe547}},5,"F-H0-2893",421,20},
  {{{0x596603d7111e3de5}},5,"F-H0-2894",421,8},
  {{{0x9f63083bc870587e}},5,"F-H0-2895",543,8},
  {{{0x41232761375a6815}},5,"F-H0-2896",492,5},
  {{{0x9f63083bc870587e}},5,"F-H0-2897",462,3},
  {{{0x4f0f9de4f12c6a7e}},10,"F-H0-2898",714,44},
  {{{0xddf5af4cfe17948d}},10,"F-H0-2899",825,5},
  {{{0xedda26295a0b4a95}},10,"F-H0-2900",837,9},
  {{{0xf46833c6fc47022b}},5,"F-H0-2901",542,18},
  {{{0xb059b473bcafae63}},5,"F-H0-2902",493,15},
  {{{0xba866068e1338367}},5,"F-H0-2903",418,9},
  {{{0xd9adeb8e88dcfaf9}},5,"F-H0-2904",947,4},
  {{{0xb3afb4f67baa6e37}},5,"F-H0-2905",430,4},
  {{{0xf634fed4d8e354d2}},5,"F-H0-2906",948,3},
  {{{0xb059b473bcafae63}},5,"F-H0-2907",530,2},
  {{{0x63da5302d9cb179a}},11,"F-H0-2908",876,25},
  {{{0xa201ab8a88b3dd0f}},11,"F-H0-2909",469,17},
  {{{0xfe7e2a216e3884b8}},11,"F-H0-2910",874,10},
  {{{0x6c1afb861a45ff30}},2,"F-H0-2911",913,17},
  {{{0x6c1afb861a45ff30}},2,"F-H0-2912",468,10},
  {{{0x6c1afb861a45ff30}},2,"F-H0-2913",431,6},
  {{{0xb8b74c0b33436e44}},2,"F-H0-2914",456,5},
  {{{0x6c1afb861a45ff30}},2,"F-H0-2915",862,4},
  {{{0x6c1afb861a45ff30}},2,"F-H0-2916",469,4},
  {{{0xb8b74c0b33436e44}},2,"F-H0-2917",913,3},
  {{{0xb8b74c0b33436e44}},2,"F-H0-2918",457,2},
  {{{0x8fa0423fdf1ccc38}},3,"F-H0-2919",468,20},
  {{{0x8fa0423fdf1ccc38}},3,"F-H0-2920",469,12},
  {{{0x8fa0423fdf1ccc38}},3,"F-H0-2921",949,8},
  {{{0xfb34a00f59767c6e}},3,"F-H0-2922",469,6},
  {{{0xfb34a00f59767c6e}},3,"F-H0-2923",493,2},
  {{{0xfb34a00f59767c6e}},3,"F-H0-2924",432,2},
  {{{0x3218ea8bd323ecc}},3,"F-H0-2925",493,2},
  {{{0x2fab526fc91fb49f}},2,"F-H0-2926",419,27},
  {{{0x2fab526fc91fb49f}},2,"F-H0-2927",456,7},
  {{{0x916dd8ec7e74c9c4}},2,"F-H0-2928",456,4},
  {{{0x6df9f147907c86d6}},2,"F-H0-2929",419,3},
  {{{0x4a71027619f9f0fb}},2,"F-H0-2930",492,2},
  {{{0xe501108f12c7a988}},10,"F-H0-2931",728,24},
  {{{0xe501108f12c7a988}},10,"F-H0-2932",764,13},
  {{{0xaab1c743556d694e}},10,"F-H0-2933",862,8},
  {{{0x1b718520a491ae8f}},5,"F-H0-2934",908,20},
  {{{0x1b718520a491ae8f}},5,"F-H0-2935",946,8},
  {{{0xca256858613a3838}},5,"F-H0-2936",493,6},
  {{{0x1b718520a491ae8f}},5,"F-H0-2937",944,5},
  {{{0xca256858613a3838}},5,"F-H0-2938",530,2},
  {{{0xca256858613a3838}},5,"F-H0-2939",461,2},
  {{{0x8e5e9f3d728ab8cb}},7,"F-H0-2940",838,26},
  {{{0x54930651f0b8be}},7,"F-H0-2941",825,12},
  {{{0xa71dca2b41d6bdfb}},14,"F-H0-2942",429,49},
  {{{0x6123f824b70cc8f0}},11,"F-H0-2943",507,51},
  {{{0x67bae407f4b98c1}},10,"F-H0-2944",470,49},
  {{{0x60789992ccc4a7cc}},13,"F-H0-2945",506,51},
  {{{0x7a6ad69800e43412}},15,"F-H0-2946",911,22},
  {{{0x7a6ad69800e43412}},15,"F-H0-2947",948,7},
  {{{0x7a6ad69800e43412}},15,"F-H0-2948",839,6},
  {{{0x7a6ad69800e43412}},15,"F-H0-2949",502,5},
  {{{0x7a6ad69800e43412}},15,"F-H0-2950",542,4},
  {{{0x7a6ad69800e43412}},15,"F-H0-2951",802,3},
  {{{0x7a6ad69800e43412}},15,"F-H0-2952",765,3},
  {{{0x7a6ad69800e43412}},15,"F-H0-2953",466,2},
  {{{0xa4855ddb43b3cf56}},2,"F-H0-2954",419,27},
  {{{0x5773c2c35b466ecd}},2,"F-H0-2955",912,10},
  {{{0xa4855ddb43b3cf56}},2,"F-H0-2956",468,8},
  {{{0x5773c2c35b466ecd}},2,"F-H0-2957",431,4},
  {{{0x5773c2c35b466ecd}},2,"F-H0-2958",862,3},
  {{{0x5773c2c35b466ecd}},2,"F-H0-2959",430,2},
  {{{0xa4855ddb43b3cf56}},2,"F-H0-2960",431,2},
  {{{0xf40a8adcc226b105}},5,"F-H0-2961",838,10},
  {{{0x987be6163d9467ae}},5,"F-H0-2962",911,9},
  {{{0xf40a8adcc226b105}},5,"F-H0-2963",493,7},
  {{{0xb7e281425e857143}},5,"F-H0-2964",421,5},
  {{{0xb7e281425e857143}},5,"F-H0-2965",459,4},
  {{{0xf40a8adcc226b105}},5,"F-H0-2966",492,3},
  {{{0xb7e281425e857143}},5,"F-H0-2967",677,2},
  {{{0xb7e281425e857143}},5,"F-H0-2968",825,2},
  {{{0xf40a8adcc226b105}},5,"F-H0-2969",530,2},
  {{{0x9739157d4f7339e4}},10,"F-H0-2970",655,35},
  {{{0x9739157d4f7339e4}},10,"F-H0-2971",539,2},
  {{{0x917db95695eef62f}},8,"F-H0-2972",913,51},
  {{{0xf95cd4c7e28eb8f3}},4,"F-H0-2973",906,21},
  {{{0xf95cd4c7e28eb8f3}},4,"F-H0-2974",456,18},
  {{{0xf95cd4c7e28eb8f3}},4,"F-H0-2975",542,3},
  {{{0xf95cd4c7e28eb8f3}},4,"F-H0-2976",425,3},
  {{{0xae1b0177cd0be3a4}},4,"F-H0-2977",690,2},
  {{{0xf0e4d8b1f6f9b04f}},12,"F-H0-2978",433,49},
  {{{0xc783f19a878ed9b7}},9,"F-H0-2979",873,36},
  {{{0xcc391a75eee2235b}},9,"F-H0-2980",978,10},
  {{{0x7a7eb2c4936db2e}},5,"F-H0-2981",939,25},
  {{{0x214b512395f487fd}},5,"F-H0-2982",862,12},
  {{{0x5e21f8263a6b0e90}},5,"F-H0-2983",947,10},
  {{{0x5e21f8263a6b0e90}},5,"F-H0-2984",906,3},
  {{{0xfa96636da5a1630b}},5,"F-H0-2985",429,2},
  {{{0x65dd59db04f5a5b7}},15,"F-H0-2986",765,46},
  {{{0x5d0454c313fc51b2}},6,"F-H0-2987",902,23},
  {{{0x5d0454c313fc51b2}},6,"F-H0-2988",751,8},
  {{{0xb185bb89c754424}},6,"F-H0-2989",825,4},
  {{{0x5d0454c313fc51b2}},6,"F-H0-2990",715,3},
  {{{0x5d0454c313fc51b2}},6,"F-H0-2991",690,3},
  {{{0x5d0454c313fc51b2}},6,"F-H0-2992",864,2},
  {{{0xe121b8f5dfa46458}},6,"F-H0-2993",873,2},
  {{{0xeb70734761554595}},9,"F-H0-2994",875,45},
  {{{0xb766150d41e3355c}},9,"F-H0-2995",433,4},
  {{{0xbfb96f6043e4fdc1}},17,"F-H0-2996",914,42},
  {{{0xfe23ef8cbaad5205}},17,"F-H0-2997",765,3},
  {{{0x47d4565ea56f7e80}},5,"F-H0-2998",764,15},
  {{{0x9c8609236a1678d8}},5,"F-H0-2999",420,11},
  {{{0x9c8609236a1678d8}},5,"F-H0-3000",422,5},
  {{{0x9c8609236a1678d8}},5,"F-H0-3001",530,5},
  {{{0x47d4565ea56f7e80}},5,"F-H0-3002",420,3},
  {{{0x47d4565ea56f7e80}},5,"F-H0-3003",421,2},
  {{{0x17694bb7b1a33b86}},5,"F-H0-3004",939,2},
  {{{0x47d4565ea56f7e80}},5,"F-H0-3005",874,2},
  {{{0x9c8609236a1678d8}},5,"F-H0-3006",529,2},
  {{{0x5064a3c143d314c7}},6,"F-H0-3007",503,23},
  {{{0xb7e36484d228a23}},6,"F-H0-3008",432,16},
  {{{0xb7e36484d228a23}},6,"F-H0-3009",507,5},
  {{{0x46636fefb70c0da}},6,"F-H0-3010",789,4},
  {{{0x3f3e1082521b70db}},6,"F-H0-3011",419,3},
  {{{0xff4d632a3424800a}},4,"F-H0-3012",457,26},
  {{{0x7fb5ec236692d36f}},4,"F-H0-3013",876,17},
  {{{0xff4d632a3424800a}},4,"F-H0-3014",912,11},
  {{{0x7521a6d87a4a527c}},16,"F-H0-3015",800,33},
  {{{0x7521a6d87a4a527c}},16,"F-H0-3016",578,3},
  {{{0x650e9d1dc127f812}},16,"F-H0-3017",752,3},
  {{{0x7521a6d87a4a527c}},16,"F-H0-3018",539,2},
  {{{0xa2123f7742f4be5f}},3,"F-H0-3019",455,20},
  {{{0xa2123f7742f4be5f}},3,"F-H0-3020",456,19},
  {{{0x9df5604b7a233677}},3,"F-H0-3021",875,3},
  {{{0xa2123f7742f4be5f}},3,"F-H0-3022",492,2},
  {{{0x9df5604b7a233677}},3,"F-H0-3023",876,2},
  {{{0xa2123f7742f4be5f}},3,"F-H0-3024",911,2},
  {{{0x9df5604b7a233677}},3,"F-H0-3025",432,2},
  {{{0x17d6c7240eafc4d3}},11,"F-H0-3026",839,13},
  {{{0x17d6c7240eafc4d3}},11,"F-H0-3027",943,12},
  {{{0x4237f3e4c2651c4b}},11,"F-H0-3028",751,11},
  {{{0x6686ad07db8aeb71}},11,"F-H0-3029",947,5},
  {{{0x17d6c7240eafc4d3}},11,"F-H0-3030",947,5},
  {{{0x17d6c7240eafc4d3}},11,"F-H0-3031",428,4},
  {{{0xbf5f55452cab752a}},2,"F-H0-3032",431,18},
  {{{0x1147759b60567129}},2,"F-H0-3033",913,11},
  {{{0x9b4a70b7a4ce90bd}},2,"F-H0-3034",913,9},
  {{{0xd4f2c4d21e6516ec}},2,"F-H0-3035",912,7},
  {{{0xbf5f55452cab752a}},2,"F-H0-3036",900,5},
  {{{0xd4f2c4d21e6516ec}},2,"F-H0-3037",418,2},
  {{{0x690f07a2c3da96af}},7,"F-H0-3038",690,48},
  {{{0x690f07a2c3da96af}},7,"F-H0-3039",691,3},
  {{{0x690f07a2c3da96af}},7,"F-H0-3040",653,2},
  {{{0x7c1129e83ad149c0}},6,"F-H0-3041",945,23},
  {{{0xb3494b2c0ef7170}},6,"F-H0-3042",505,10},
  {{{0x7c1129e83ad149c0}},6,"F-H0-3043",430,8},
  {{{0xf535a50e10c3c70c}},6,"F-H0-3044",421,6},
  {{{0x7c1129e83ad149c0}},6,"F-H0-3045",940,3},
  {{{0x8e2068e6d80bd764}},14,"F-H0-3046",418,44},
  {{{0x78b530ff2aee538c}},5,"F-H0-3047",420,10},
  {{{0x78b530ff2aee538c}},5,"F-H0-3048",423,5},
  {{{0x78b530ff2aee538c}},5,"F-H0-3049",430,4},
  {{{0x78b530ff2aee538c}},5,"F-H0-3050",839,3},
  {{{0x5e9a3a9663607c86}},5,"F-H0-3051",529,2},
  {{{0x78b530ff2aee538c}},5,"F-H0-3052",495,2},
  {{{0x24d6c40e195882a1}},5,"F-H0-3053",838,2},
  {{{0xb71059b34e74a680}},6,"F-H0-3054",728,38},
  {{{0xb71059b34e74a680}},6,"F-H0-3055",470,5},
  {{{0xc1ee6245be5bb313}},6,"F-H0-3056",906,3},
  {{{0xf640fa0f8918ccd}},6,"F-H0-3057",905,3},
  {{{0xaf95ad025a38d5e1}},8,"F-H0-3058",469,49},
  {{{0x20bf850190d0732c}},16,"F-H0-3059",948,16},
  {{{0x20bf850190d0732c}},16,"F-H0-3060",839,15},
  {{{0x20bf850190d0732c}},16,"F-H0-3061",838,12},
  {{{0x20bf850190d0732c}},16,"F-H0-3062",802,6},
  {{{0x20bf850190d0732c}},16,"F-H0-3063",946,3},
  {{{0x20bf850190d0732c}},16,"F-H0-3064",908,2},
  {{{0x6ec8c3121e87256e}},5,"F-H0-3065",466,13},
  {{{0x6ec8c3121e87256e}},5,"F-H0-3066",617,11},
  {{{0x6ec8c3121e87256e}},5,"F-H0-3067",653,8},
  {{{0x6ec8c3121e87256e}},5,"F-H0-3068",690,6},
  {{{0xaf77e5df2b357734}},5,"F-H0-3069",421,4},
  {{{0x6ec8c3121e87256e}},5,"F-H0-3070",428,3},
  {{{0x6ec8c3121e87256e}},5,"F-H0-3071",825,2},
  {{{0xaad79c7f420dae94}},5,"F-H0-3072",425,2},
  {{{0xac4aca5743169e45}},7,"F-H0-3073",419,42},
  {{{0xac4aca5743169e45}},7,"F-H0-3074",383,2},
  {{{0x55e2c51999af8b05}},5,"F-H0-3075",420,13},
  {{{0x366f1109b8529b71}},5,"F-H0-3076",764,11},
  {{{0x55e2c51999af8b05}},5,"F-H0-3077",863,8},
  {{{0xca03754fb77d1a66}},5,"F-H0-3078",902,7},
  {{{0x55e2c51999af8b05}},5,"F-H0-3079",494,4},
  {{{0x366f1109b8529b71}},5,"F-H0-3080",802,4},
  {{{0x366f1109b8529b71}},5,"F-H0-3081",909,2},
  {{{0xa105e4446edf7d37}},9,"F-H0-3082",529,45},
  {{{0x85175ad4fb07002e}},9,"F-H0-3083",906,3},
  {{{0xa105e4446edf7d37}},9,"F-H0-3084",495,2},
  {{{0x758157d20914b3aa}},4,"F-H0-3085",543,23},
  {{{0xe796f8eb31a7dd75}},4,"F-H0-3086",654,9},
  {{{0x758157d20914b3aa}},4,"F-H0-3087",456,9},
  {{{0x758157d20914b3aa}},4,"F-H0-3088",907,6},
  {{{0x758157d20914b3aa}},4,"F-H0-3089",530,3},
  {{{0x758157d20914b3aa}},4,"F-H0-3090",429,3},
  {{{0x8525d6037e3c3867}},4,"F-H0-3091",906,2},
  {{{0x384f596c31df7f48}},7,"F-H0-3092",801,12},
  {{{0x384f596c31df7f48}},7,"F-H0-3093",876,11},
  {{{0x384f596c31df7f48}},7,"F-H0-3094",837,7},
  {{{0x384f596c31df7f48}},7,"F-H0-3095",653,3},
  {{{0x384f596c31df7f48}},7,"F-H0-3096",838,3},
  {{{0x4660324fa617fa8}},7,"F-H0-3097",872,3},
  {{{0x73eaf68bf103b3}},6,"F-H0-3098",914,15},
  {{{0x8bdd6544756fec7e}},6,"F-H0-3099",421,4},
  {{{0x10d248550f2cd3a8}},6,"F-H0-3100",424,2},
  {{{0x73eaf68bf103b3}},6,"F-H0-3101",691,2},
  {{{0xbf77797338f153ff}},10,"F-H0-3102",467,49},
  {{{0xcdbaffe68f79dea2}},6,"F-H0-3103",839,20},
  {{{0xf7f356eaef46b588}},6,"F-H0-3104",543,12},
  {{{0xef28eef71a0fdab0}},6,"F-H0-3105",543,6},
  {{{0xf7f356eaef46b588}},6,"F-H0-3106",421,6},
  {{{0x9a9b7202bca9ae09}},6,"F-H0-3107",942,3},
  {{{0xf7f356eaef46b588}},6,"F-H0-3108",425,2},
  {{{0xf7f356eaef46b588}},6,"F-H0-3109",802,2},
  {{{0xc45635bfe1f91884}},10,"F-H0-3110",981,39},
  {{{0x44455bbfd9c1ed0d}},10,"F-H0-3111",728,4},
  {{{0x2da9d52af43502b3}},10,"F-H0-3112",533,3},
  {{{0x1c1170a829eea888}},11,"F-H0-3113",392,29},
  {{{0x14a5b65c1731029f}},11,"F-H0-3114",973,14},
  {{{0x97dcff8ef6265dcc}},11,"F-H0-3115",902,4},
  {{{0x14a5b65c1731029f}},11,"F-H0-3116",974,2},
  {{{0xc37df9838ef2bab0}},9,"F-H0-3117",431,50},
  {{{0xcc9a688d38ba75e9}},13,"F-H0-3118",568,50},
  {{{0xcc9a688d38ba75e9}},13,"F-H0-3119",458,2},
  {{{0xd5365e9a3d074e36}},13,"F-H0-3120",691,46},
  {{{0x869e2d9445852603}},4,"F-H0-3121",974,18},
  {{{0x869e2d9445852603}},4,"F-H0-3122",752,3},
  {{{0x57eee983c9a7d71a}},4,"F-H0-3123",714,2},
  {{{0x869e2d9445852603}},4,"F-H0-3124",975,2},
  {{{0xa8083df2187ca0}},14,"F-H0-3125",727,44},
  {{{0x553fb7be3ff16018}},4,"F-H0-3126",862,30},
  {{{0x553fb7be3ff16018}},4,"F-H0-3127",457,5},
  {{{0x553fb7be3ff16018}},4,"F-H0-3128",825,4},
  {{{0x10427e04397ab818}},4,"F-H0-3129",493,4},
  {{{0x553fb7be3ff16018}},4,"F-H0-3130",420,2},
  {{{0x553fb7be3ff16018}},4,"F-H0-3131",458,2},
  {{{0x553fb7be3ff16018}},4,"F-H0-3132",421,2},
  {{{0xd28d09dce0b3087}},6,"F-H0-3133",690,32},
  {{{0xb4a5af1ac92c7db8}},6,"F-H0-3134",825,9},
  {{{0x351dd5ec78b059ce}},6,"F-H0-3135",427,3},
  {{{0x13c3ebcf95e6f92e}},6,"F-H0-3136",690,2},
  {{{0x13c3ebcf95e6f92e}},6,"F-H0-3137",839,2},
  {{{0x5c4698954d73e61d}},6,"F-H0-3138",947,2},
  {{{0x15893cc158b786a3}},7,"F-H0-3139",529,32},
  {{{0x88febedb1311d647}},7,"F-H0-3140",940,21},
  {{{0x7acfca8c7a58b347}},15,"F-H0-3141",420,40},
  {{{0xd4c0fefe01ffcd8b}},15,"F-H0-3142",454,11},
  {{{0x1d212c46e68b537f}},4,"F-H0-3143",876,17},
  {{{0x2d1b963fd9dae35a}},4,"F-H0-3144",863,14},
  {{{0x11ee2dbc0808c419}},4,"F-H0-3145",938,3},
  {{{0x1cdacc37da12e523}},8,"F-H0-3146",458,22},
  {{{0x383a4fe36b499e8b}},8,"F-H0-3147",789,12},
  {{{0x1cdacc37da12e523}},8,"F-H0-3148",543,10},
  {{{0x1cdacc37da12e523}},8,"F-H0-3149",429,3},
  {{{0x3b25667c17013868}},6,"F-H0-3150",945,16},
  {{{0x887df7109e91963c}},6,"F-H0-3151",543,6},
  {{{0x887df7109e91963c}},6,"F-H0-3152",946,4},
  {{{0x3b25667c17013868}},6,"F-H0-3153",543,3},
  {{{0x3b25667c17013868}},6,"F-H0-3154",425,3},
  {{{0x29df2d2019d3711d}},6,"F-H0-3155",765,2},
  {{{0x3b25667c17013868}},6,"F-H0-3156",944,2},
  {{{0xf24cab8905470f1a}},11,"F-H0-3157",911,28},
  {{{0xf24cab8905470f1a}},11,"F-H0-3158",948,4},
  {{{0xf24cab8905470f1a}},11,"F-H0-3159",425,3},
  {{{0xf24cab8905470f1a}},11,"F-H0-3160",825,3},
  {{{0x17632b71136550eb}},11,"F-H0-3161",839,2},
  {{{0xf3f62b3577d374cf}},5,"F-H0-3162",456,16},
  {{{0xf3f62b3577d374cf}},5,"F-H0-3163",455,15},
  {{{0xf3f62b3577d374cf}},5,"F-H0-3164",838,7},
  {{{0xf23ef99adcf2dcf}},5,"F-H0-3165",863,4},
  {{{0xf3f62b3577d374cf}},5,"F-H0-3166",839,2},
  {{{0x2eac38413af8f0a7}},5,"F-H0-3167",616,16},
  {{{0x53d6de233c70c878}},5,"F-H0-3168",802,7},
  {{{0x9c056571a8d4fd55}},5,"F-H0-3169",911,6},
  {{{0x9c056571a8d4fd55}},5,"F-H0-3170",493,5},
  {{{0x9c056571a8d4fd55}},5,"F-H0-3171",459,4},
  {{{0x53d6de233c70c878}},5,"F-H0-3172",727,3},
  {{{0x9c056571a8d4fd55}},5,"F-H0-3173",939,2},
  {{{0x53d6de233c70c878}},5,"F-H0-3174",728,2},
  {{{0x9c056571a8d4fd55}},5,"F-H0-3175",530,2},
  {{{0xa8d9acffdfdb9495}},7,"F-H0-3176",419,47},
  {{{0xf5037063b91a88a3}},6,"F-H0-3177",469,37},
  {{{0xb73cf382b35ac71}},6,"F-H0-3178",690,36},
  {{{0xb73cf382b35ac71}},6,"F-H0-3179",653,9},
  {{{0xb73cf382b35ac71}},6,"F-H0-3180",470,6},
  {{{0x9c15a3320f9bfe96}},7,"F-H0-3181",825,17},
  {{{0x9c15a3320f9bfe96}},7,"F-H0-3182",947,16},
  {{{0x9c15a3320f9bfe96}},7,"F-H0-3183",943,5},
  {{{0xa0b59de52416ea72}},4,"F-H0-3184",431,32},
  {{{0xa0b59de52416ea72}},4,"F-H0-3185",468,7},
  {{{0xa0b59de52416ea72}},4,"F-H0-3186",752,4},
  {{{0x73da4bd8ccd024e5}},4,"F-H0-3187",863,4},
  {{{0xa0b59de52416ea72}},4,"F-H0-3188",863,3},
  {{{0xa0b59de52416ea72}},4,"F-H0-3189",457,2},
  {{{0xc4762d5197a02142}},18,"F-H0-3190",950,38},
  {{{0xc4762d5197a02142}},18,"F-H0-3191",946,5},
  {{{0xede5ac3b40b37100}},18,"F-H0-3192",944,4},
  {{{0xc4762d5197a02142}},18,"F-H0-3193",691,3},
  {{{0xcbe8658a70c9d07a}},4,"F-H0-3194",529,2},
  {{{0x5085a4c2517e4651}},4,"F-H0-3195",690,2},
  {{{0x4ccd46c24650d71c}},4,"F-H0-3196",826,2},
  {{{0x3382caec604cd6bb}},4,"F-H0-3197",947,2},
  {{{0xd30555305bf065e3}},8,"F-H0-3198",945,22},
  {{{0x9571ee265fc9bdf2}},8,"F-H0-3199",947,14},
  {{{0x59b7ed39d1ee0b99}},8,"F-H0-3200",617,6},
  {{{0xd30555305bf065e3}},8,"F-H0-3201",946,6},
  {{{0xa75e160e4493fcc9}},9,"F-H0-3202",603,18},
  {{{0xf380d8bc71852ead}},9,"F-H0-3203",690,7},
  {{{0xa75e160e4493fcc9}},9,"F-H0-3204",939,7},
  {{{0x321f33253a679d6f}},9,"F-H0-3205",580,5},
  {{{0xa75e160e4493fcc9}},9,"F-H0-3206",567,4},
  {{{0x3dbb340431db8c00}},9,"F-H0-3207",947,3},
  {{{0xa75e160e4493fcc9}},9,"F-H0-3208",825,2},
  {{{0x143fb9aa02522110}},7,"F-H0-3209",542,18},
  {{{0x245788558e657258}},7,"F-H0-3210",909,9},
  {{{0x245788558e657258}},7,"F-H0-3211",825,4},
  {{{0xb107fa851c2ba55a}},7,"F-H0-3212",529,2},
  {{{0x4110e3114eaf0f31}},7,"F-H0-3213",911,13},
  {{{0x4110e3114eaf0f31}},7,"F-H0-3214",943,9},
  {{{0x4110e3114eaf0f31}},7,"F-H0-3215",944,9},
  {{{0xf82232fc788cc2b0}},7,"F-H0-3216",826,7},
  {{{0x4110e3114eaf0f31}},7,"F-H0-3217",947,5},
  {{{0x4110e3114eaf0f31}},7,"F-H0-3218",948,2},
  {{{0x83dca7d393e15e0f}},10,"F-H0-3219",986,46},
  {{{0xf72fa1d759eb038}},15,"F-H0-3220",939,26},
  {{{0x90f32eb5e3289}},15,"F-H0-3221",542,6},
  {{{0x90f32eb5e3289}},15,"F-H0-3222",947,4},
  {{{0x90f32eb5e3289}},15,"F-H0-3223",502,4},
  {{{0xce15744bf6b653b3}},15,"F-H0-3224",458,2},
  {{{0x9635b892d6f6c925}},11,"F-H0-3225",531,25},
  {{{0x203031e613bfbce}},11,"F-H0-3226",825,7},
  {{{0x9635b892d6f6c925}},11,"F-H0-3227",642,5},
  {{{0x203031e613bfbce}},11,"F-H0-3228",837,2},
  {{{0xfea34b4b84dfdfe5}},10,"F-H0-3229",827,12},
  {{{0xd61b5b834052b6c6}},11,"F-H0-3230",985,44},
  {{{0xd8d147400e7b9171}},7,"F-H0-3231",943,26},
  {{{0xd8d147400e7b9171}},7,"F-H0-3232",825,12},
  {{{0xd8d147400e7b9171}},7,"F-H0-3233",939,3},
  {{{0xd8d147400e7b9171}},7,"F-H0-3234",875,2},
  {{{0x65e69aae6ad585fd}},7,"F-H0-3235",678,29},
  {{{0x65e69aae6ad585fd}},7,"F-H0-3236",825,12},
  {{{0x65e69aae6ad585fd}},7,"F-H0-3237",684,6},
  {{{0x65e69aae6ad585fd}},7,"F-H0-3238",839,2},
  {{{0x1dfc5f5cbff596f8}},12,"F-H0-3239",987,46},
  {{{0x99320a36b9e34ab6}},10,"F-H0-3240",939,37},
  {{{0x26e3b38e6a6517af}},10,"F-H0-3241",906,3},
  {{{0xf7ecbe27ef3279ce}},8,"F-H0-3242",902,20},
  {{{0xc25c5c62e91958d6}},8,"F-H0-3243",429,11},
  {{{0xbc7b4ecbd08decfa}},8,"F-H0-3244",905,8},
  {{{0xbc7b4ecbd08decfa}},8,"F-H0-3245",941,4},
  {{{0x2986990074c7229c}},8,"F-H0-3246",838,4},
  {{{0x62a95596d616c9ed}},8,"F-H0-3247",467,23},
  {{{0x62a95596d616c9ed}},8,"F-H0-3248",458,17},
  {{{0x2907e01173060976}},8,"F-H0-3249",465,9},
  {{{0x7ce8cea83d9ba8c8}},6,"F-H0-3250",503,16},
  {{{0x6e29c9760512298}},6,"F-H0-3251",801,15},
  {{{0x4930a8520a5b548e}},6,"F-H0-3252",530,9},
  {{{0x3b8ea6ee4ebcbb15}},6,"F-H0-3253",506,3},
  {{{0x3b8ea6ee4ebcbb15}},6,"F-H0-3254",578,3},
  {{{0x6e29c9760512298}},6,"F-H0-3255",873,2},
  {{{0xd14335b4a3f9f845}},1,"F-H0-3256",468,24},
  {{{0xa50e49922655ca9}},1,"F-H0-3257",690,5},
  {{{0xa50e49922655ca9}},1,"F-H0-3258",431,4},
  {{{0xa50e49922655ca9}},1,"F-H0-3259",899,3},
  {{{0x39656d7721626b78}},1,"F-H0-3260",912,3},
  {{{0xa50e49922655ca9}},1,"F-H0-3261",684,3},
  {{{0x9e8229007389a1f8}},14,"F-H0-3262",839,46},
  {{{0xbcae2623c2caa497}},11,"F-H0-3263",862,26},
  {{{0xbcae2623c2caa497}},11,"F-H0-3264",899,17},
  {{{0xbcae2623c2caa497}},11,"F-H0-3265",864,5},
  {{{0x57f98e969086cfc5}},13,"F-H0-3266",948,43},
  {{{0x945626d48ad9fa2b}},3,"F-H0-3267",912,25},
  {{{0x945626d48ad9fa2b}},3,"F-H0-3268",913,12},
  {{{0x945626d48ad9fa2b}},3,"F-H0-3269",467,5},
  {{{0xcd9714af5f0b37f9}},3,"F-H0-3270",949,3},
  {{{0xcd9714af5f0b37f9}},3,"F-H0-3271",938,2},
  {{{0x5efb7cb803c4e166}},11,"F-H0-3272",910,36},
  {{{0x5efb7cb803c4e166}},11,"F-H0-3273",950,6},
  {{{0x6f9c9ee7185c5434}},6,"F-H0-3274",541,21},
  {{{0x6f9c9ee7185c5434}},6,"F-H0-3275",432,15},
  {{{0x6f9c9ee7185c5434}},6,"F-H0-3276",429,14},
  {{{0x6f9c9ee7185c5434}},6,"F-H0-3277",466,2},
  {{{0xd4959c6a09da7a23}},4,"F-H0-3278",906,15},
  {{{0xd4959c6a09da7a23}},4,"F-H0-3279",431,15},
  {{{0x64d49ec884b39c9b}},4,"F-H0-3280",691,9},
  {{{0xd4959c6a09da7a23}},4,"F-H0-3281",467,6},
  {{{0xd4959c6a09da7a23}},4,"F-H0-3282",462,3},
  {{{0xaeaf904fe98cb3ec}},2,"F-H0-3283",456,25},
  {{{0x67f9feaae62b2cf6}},2,"F-H0-3284",913,8},
  {{{0xaeaf904fe98cb3ec}},2,"F-H0-3285",468,4},
  {{{0xaeaf904fe98cb3ec}},2,"F-H0-3286",431,3},
  {{{0x67f9feaae62b2cf6}},2,"F-H0-3287",949,2},
  {{{0x34de4b5a6af757ba}},6,"F-H0-3288",903,35},
  {{{0x401a19cbcb97e730}},6,"F-H0-3289",543,51},
  {{{0x8ae693d645443262}},5,"F-H0-3290",946,14},
  {{{0x4149469e784dfeeb}},5,"F-H0-3291",492,8},
  {{{0x4149469e784dfeeb}},5,"F-H0-3292",604,7},
  {{{0x4149469e784dfeeb}},5,"F-H0-3293",458,5},
  {{{0x4149469e784dfeeb}},5,"F-H0-3294",911,4},
  {{{0x8ae693d645443262}},5,"F-H0-3295",839,2},
  {{{0x4149469e784dfeeb}},5,"F-H0-3296",947,2},
  {{{0xf1365b140b377580}},2,"F-H0-3297",455,17},
  {{{0xf1365b140b377580}},2,"F-H0-3298",456,12},
  {{{0xf1365b140b377580}},2,"F-H0-3299",468,6},
  {{{0xf1365b140b377580}},2,"F-H0-3300",431,4},
  {{{0xf1365b140b377580}},2,"F-H0-3301",419,3},
  {{{0xf1365b140b377580}},2,"F-H0-3302",948,2},
  {{{0xf1365b140b377580}},2,"F-H0-3303",862,2},
  {{{0xe882389f281ea5b2}},7,"F-H0-3304",418,21},
  {{{0x1e803e1b3a9a483a}},7,"F-H0-3305",911,12},
  {{{0x1e803e1b3a9a483a}},7,"F-H0-3306",825,5},
  {{{0xe4013f4dfc574c9d}},7,"F-H0-3307",428,4},
  {{{0x5fea20bbab384815}},7,"F-H0-3308",838,3},
  {{{0xe4013f4dfc574c9d}},7,"F-H0-3309",529,2},
  {{{0x83716bd77d8ffae5}},13,"F-H0-3310",976,36},
  {{{0xc3fc9c60b87e6598}},13,"F-H0-3311",910,8},
  {{{0x83716bd77d8ffae5}},13,"F-H0-3312",935,4},
  {{{0x88029d7340907805}},12,"F-H0-3313",911,46},
  {{{0x260e9c3b205205b5}},6,"F-H0-3314",873,16},
  {{{0x4f3b2a3188c963a3}},6,"F-H0-3315",421,10},
  {{{0x4f3b2a3188c963a3}},6,"F-H0-3316",418,8},
  {{{0x4f3b2a3188c963a3}},6,"F-H0-3317",458,3},
  {{{0x4f3b2a3188c963a3}},6,"F-H0-3318",825,3},
  {{{0xdde557b56dde8ac0}},6,"F-H0-3319",728,2},
  {{{0xbc0c0292ac436b3f}},7,"F-H0-3320",469,40},
  {{{0x18309b825c1ca667}},7,"F-H0-3321",393,3},
  {{{0xd47a9f0a245a75c0}},5,"F-H0-3322",839,19},
  {{{0xf9fc2ff2691e5a5e}},5,"F-H0-3323",839,13},
  {{{0xf9fc2ff2691e5a5e}},5,"F-H0-3324",431,9},
  {{{0xd47a9f0a245a75c0}},5,"F-H0-3325",690,3},
  {{{0x46cd02c42b689061}},6,"F-H0-3326",678,17},
  {{{0x46cd02c42b689061}},6,"F-H0-3327",529,9},
  {{{0x46cd02c42b689061}},6,"F-H0-3328",764,9},
  {{{0x46cd02c42b689061}},6,"F-H0-3329",801,3},
  {{{0xa27ef8fc2abffaa1}},6,"F-H0-3330",939,2},
  {{{0x46cd02c42b689061}},6,"F-H0-3331",429,2},
  {{{0x91ca404bcf7fbca5}},11,"F-H0-3332",949,48},
  {{{0x5cfb02cc630da4e4}},3,"F-H0-3333",865,7},
  {{{0x5cfb02cc630da4e4}},3,"F-H0-3334",936,4},
  {{{0xca7cc3edd8a34c26}},3,"F-H0-3335",429,3},
  {{{0x5cfb02cc630da4e4}},3,"F-H0-3336",904,2},
  {{{0x9512f299171914c4}},6,"F-H0-3337",950,19},
  {{{0xd1f51a91965d64d8}},6,"F-H0-3338",837,17},
  {{{0x8211587a91c85a0b}},7,"F-H0-3339",504,19},
  {{{0x8211587a91c85a0b}},7,"F-H0-3340",466,16},
  {{{0x8211587a91c85a0b}},7,"F-H0-3341",542,10},
  {{{0x3bf049f77c642a57}},10,"F-H0-3342",426,41},
  {{{0x37653b1fb3774a4d}},10,"F-H0-3343",421,2},
  {{{0xffe142da94929031}},4,"F-H0-3344",875,14},
  {{{0x7be4be1879fc159b}},4,"F-H0-3345",906,12},
  {{{0xffe142da94929031}},4,"F-H0-3346",469,10},
  {{{0x7be4be1879fc159b}},4,"F-H0-3347",430,3},
  {{{0x80255e0d6c69c014}},4,"F-H0-3348",691,3},
  {{{0x80255e0d6c69c014}},4,"F-H0-3349",943,3},
  {{{0x7be4be1879fc159b}},4,"F-H0-3350",421,3},
  {{{0xd5519a933121e5d5}},6,"F-H0-3351",825,13},
  {{{0xd5519a933121e5d5}},6,"F-H0-3352",418,12},
  {{{0xd5519a933121e5d5}},6,"F-H0-3353",862,5},
  {{{0x485f72412d6fd834}},6,"F-H0-3354",873,4},
  {{{0xd5519a933121e5d5}},6,"F-H0-3355",421,2},
  {{{0xd5519a933121e5d5}},6,"F-H0-3356",604,2},
  {{{0xc51c1bc8b138266c}},4,"F-H0-3357",912,4},
  {{{0xc51c1bc8b138266c}},4,"F-H0-3358",911,3},
  {{{0x15ceced4ba63046}},4,"F-H0-3359",986,3},
  {{{0xc51c1bc8b138266c}},4,"F-H0-3360",906,2},
  {{{0x78636ccda5b4ebda}},4,"F-H0-3361",457,13},
  {{{0x78636ccda5b4ebda}},4,"F-H0-3362",469,10},
  {{{0x78636ccda5b4ebda}},4,"F-H0-3363",505,8},
  {{{0x78636ccda5b4ebda}},4,"F-H0-3364",906,7},
  {{{0x78636ccda5b4ebda}},4,"F-H0-3365",506,3},
  {{{0x1bd3190a7a6a7e04}},4,"F-H0-3366",425,2},
  {{{0x1bd3190a7a6a7e04}},4,"F-H0-3367",462,2},
  {{{0x5a7942525cde647a}},5,"F-H0-3368",825,25},
  {{{0x1925adf5b6de0024}},5,"F-H0-3369",691,7},
  {{{0x37a20567272888d9}},5,"F-H0-3370",945,4},
  {{{0x5a7942525cde647a}},5,"F-H0-3371",947,3},
  {{{0x5a7942525cde647a}},5,"F-H0-3372",428,3},
  {{{0x5a7942525cde647a}},5,"F-H0-3373",421,2},
  {{{0xa97e0cadc04700c0}},7,"F-H0-3374",469,38},
  {{{0xa97e0cadc04700c0}},7,"F-H0-3375",431,2},
  {{{0x93f9556b61ad0c98}},7,"F-H0-3376",541,12},
  {{{0x301c954be95c36dc}},7,"F-H0-3377",420,6},
  {{{0x661e8a40f79f86b6}},7,"F-H0-3378",866,4},
  {{{0x79fccc505f29b988}},2,"F-H0-3379",468,8},
  {{{0x79fccc505f29b988}},2,"F-H0-3380",456,7},
  {{{0x79fccc505f29b988}},2,"F-H0-3381",913,7},
  {{{0x79fccc505f29b988}},2,"F-H0-3382",902,7},
  {{{0x79fccc505f29b988}},2,"F-H0-3383",431,5},
  {{{0x4fa7cf1399d57709}},2,"F-H0-3384",938,5},
  {{{0x4fa7cf1399d57709}},2,"F-H0-3385",456,3},
  {{{0x79fccc505f29b988}},2,"F-H0-3386",827,2},
  {{{0x79fccc505f29b988}},2,"F-H0-3387",493,2},
  {{{0xf3542872460758ee}},4,"F-H0-3388",875,17},
  {{{0x7716fba80a845295}},4,"F-H0-3389",907,10},
  {{{0x7716fba80a845295}},4,"F-H0-3390",944,5},
  {{{0xf3542872460758ee}},4,"F-H0-3391",492,4},
  {{{0x7716fba80a845295}},4,"F-H0-3392",542,4},
  {{{0x7716fba80a845295}},4,"F-H0-3393",468,3},
  {{{0xf3542872460758ee}},4,"F-H0-3394",876,3},
  {{{0x7716fba80a845295}},4,"F-H0-3395",543,2},
  {{{0x89825e0116331ea6}},8,"F-H0-3396",579,28},
  {{{0x89825e0116331ea6}},8,"F-H0-3397",432,12},
  {{{0x794142958c7f2250}},8,"F-H0-3398",863,2},
  {{{0xd00e278cd89d2dfc}},10,"F-H0-3399",913,44},
  {{{0xa4e4c7bac81a0081}},8,"F-H0-3400",947,14},
  {{{0x57426239d72eed1f}},8,"F-H0-3401",939,12},
  {{{0x9be9f57fab700ab1}},8,"F-H0-3402",678,10},
  {{{0xa4e4c7bac81a0081}},8,"F-H0-3403",691,5},
  {{{0xc777403bd7b6db8f}},10,"F-H0-3404",838,14},
  {{{0x7197b8a486a690c6}},10,"F-H0-3405",825,7},
  {{{0xf4509fcfe46c3794}},7,"F-H0-3406",827,22},
  {{{0x6469d699f5eb1492}},7,"F-H0-3407",950,10},
  {{{0xf4509fcfe46c3794}},7,"F-H0-3408",939,5},
  {{{0xf4509fcfe46c3794}},7,"F-H0-3409",753,4},
  {{{0x6469d699f5eb1492}},7,"F-H0-3410",910,2},
  {{{0x28dbfbb6b8564e50}},4,"F-H0-3411",678,14},
  {{{0x28dbfbb6b8564e50}},4,"F-H0-3412",691,11},
  {{{0x28dbfbb6b8564e50}},4,"F-H0-3413",913,8},
  {{{0x58745884367c8873}},4,"F-H0-3414",691,3},
  {{{0x58745884367c8873}},4,"F-H0-3415",420,3},
  {{{0x58745884367c8873}},4,"F-H0-3416",684,2},
  {{{0x28dbfbb6b8564e50}},4,"F-H0-3417",462,2},
  {{{0x4e9143bcc6bbceaf}},4,"F-H0-3418",788,2},
  {{{0xbe9af2a42f1d6a2a}},11,"F-H0-3419",906,43},
  {{{0x3155e3302eab175c}},11,"F-H0-3420",764,2},
  {{{0xeaa8919cb2c5cef2}},7,"F-H0-3421",939,15},
  {{{0xeaa8919cb2c5cef2}},7,"F-H0-3422",911,15},
  {{{0xeaa8919cb2c5cef2}},7,"F-H0-3423",947,11},
  {{{0xeaa8919cb2c5cef2}},7,"F-H0-3424",910,6},
  {{{0xeaa8919cb2c5cef2}},7,"F-H0-3425",948,2},
  {{{0xc4efacb8ac231860}},7,"F-H0-3426",943,2},
  {{{0xdeb7a3a2be4596c0}},6,"F-H0-3427",503,37},
  {{{0x9798ae10d9b68e8c}},6,"F-H0-3428",418,12},
  {{{0xee574dd64f6cb0dc}},6,"F-H0-3429",912,2},
  {{{0xb99cd8dca28e86de}},9,"F-H0-3430",467,37},
  {{{0x308796662eb1dded}},18,"F-H0-3431",429,18},
  {{{0xa416b0afd265c619}},18,"F-H0-3432",946,9},
  {{{0xa416b0afd265c619}},18,"F-H0-3433",691,7},
  {{{0xd28ef0dfb87b8808}},18,"F-H0-3434",872,7},
  {{{0x9b914dcfe1fa2fa5}},4,"F-H0-3435",690,16},
  {{{0x609ab314ab37e7cf}},4,"F-H0-3436",469,8},
  {{{0x609ab314ab37e7cf}},4,"F-H0-3437",505,5},
  {{{0x7cd61d554ebf9536}},4,"F-H0-3438",469,5},
  {{{0xd0dbb1b6265e0177}},4,"F-H0-3439",875,2},
  {{{0xd0dbb1b6265e0177}},4,"F-H0-3440",430,2},
  {{{0xd0dbb1b6265e0177}},4,"F-H0-3441",462,2},
  {{{0xbb7377b2bea877}},7,"F-H0-3442",418,24},
  {{{0x1ed6d049bae74ab}},7,"F-H0-3443",752,11},
  {{{0x6c03d85598b8e093}},7,"F-H0-3444",454,2},
  {{{0x1ed6d049bae74ab}},7,"F-H0-3445",939,2},
  {{{0x1ed6d049bae74ab}},7,"F-H0-3446",937,2},
  {{{0x31f3a9b813b00da}},7,"F-H0-3447",728,2},
  {{{0x639b177c87fe7b55}},8,"F-H0-3448",431,39},
  {{{0xba80db3ad1a1e183}},8,"F-H0-3449",905,30},
  {{{0xf4c7a27c1d9838ab}},8,"F-H0-3450",425,4},
  {{{0xba80db3ad1a1e183}},8,"F-H0-3451",974,4},
  {{{0x26d806ba8979c785}},8,"F-H0-3452",728,3},
  {{{0x26d806ba8979c785}},8,"F-H0-3453",539,2},
  {{{0x7411ee69d9ee1f9a}},2,"F-H0-3454",494,7},
  {{{0x7411ee69d9ee1f9a}},2,"F-H0-3455",493,4},
  {{{0xeac401bb8b2cc7f0}},2,"F-H0-3456",913,3},
  {{{0xeac401bb8b2cc7f0}},2,"F-H0-3457",504,2},
  {{{0xeac401bb8b2cc7f0}},2,"F-H0-3458",505,2},
  {{{0xeac401bb8b2cc7f0}},2,"F-H0-3459",838,2},
  {{{0x7411ee69d9ee1f9a}},2,"F-H0-3460",468,2},
  {{{0x8bf57c58055331fe}},2,"F-H0-3461",468,2},
  {{{0xc94995e1bc4a99e6}},8,"F-H0-3462",542,40},
  {{{0xc94995e1bc4a99e6}},8,"F-H0-3463",579,9},
  {{{0xc480f126f84ca2fa}},7,"F-H0-3464",937,33},
  {{{0x80f833eb983662fe}},7,"F-H0-3465",937,3},
  {{{0xa004f1be9303a586}},11,"F-H0-3466",428,28},
  {{{0xa004f1be9303a586}},11,"F-H0-3467",947,5},
  {{{0xa004f1be9303a586}},11,"F-H0-3468",839,5},
  {{{0xa004f1be9303a586}},11,"F-H0-3469",943,2},
  {{{0xef3c2e30833810b}},15,"F-H0-3470",947,13},
  {{{0xef3c2e30833810b}},15,"F-H0-3471",839,10},
  {{{0xef3c2e30833810b}},15,"F-H0-3472",825,8},
  {{{0x3dd1f481cccad08f}},15,"F-H0-3473",943,3},
  {{{0xb07f8dfed9c0e2cc}},15,"F-H0-3474",578,2},
  {{{0xb29c415fdb940691}},6,"F-H0-3475",429,15},
  {{{0xb29c415fdb940691}},6,"F-H0-3476",839,9},
  {{{0x5599f9d7c391575d}},6,"F-H0-3477",865,9},
  {{{0xb29c415fdb940691}},6,"F-H0-3478",432,8},
  {{{0xb29c415fdb940691}},6,"F-H0-3479",466,2},
  {{{0xb29c415fdb940691}},6,"F-H0-3480",728,2},
  {{{0x14e18de9c41312d5}},13,"F-H0-3481",506,37},
  {{{0x15baec5fbfdb7de9}},11,"F-H0-3482",507,37},
  {{{0x4a68e8a6a95041e3}},12,"F-H0-3483",433,39},
  {{{0x538e78adb688e062}},5,"F-H0-3484",677,19},
  {{{0x538e78adb688e062}},5,"F-H0-3485",939,12},
  {{{0x538e78adb688e062}},5,"F-H0-3486",690,5},
  {{{0x538e78adb688e062}},5,"F-H0-3487",825,3},
  {{{0x538e78adb688e062}},5,"F-H0-3488",640,2},
  {{{0xbcf79e5720e2696d}},10,"F-H0-3489",470,39},
  {{{0xf58331ba8748cc2e}},3,"F-H0-3490",506,12},
  {{{0x673e5eab03811837}},3,"F-H0-3491",912,11},
  {{{0x673e5eab03811837}},3,"F-H0-3492",467,7},
  {{{0x673e5eab03811837}},3,"F-H0-3493",949,3},
  {{{0x673e5eab03811837}},3,"F-H0-3494",913,2},
  {{{0x673e5eab03811837}},3,"F-H0-3495",950,2},
  {{{0xefddab0f4790da46}},12,"F-H0-3496",948,31},
  {{{0xefddab0f4790da46}},12,"F-H0-3497",873,5},
  {{{0x803c3dd0359711a3}},5,"F-H0-3498",838,27},
  {{{0xe221c95cbeba5cf1}},5,"F-H0-3499",950,6},
  {{{0xe19ff9d455fa810f}},5,"F-H0-3500",529,5},
  {{{0x803c3dd0359711a3}},5,"F-H0-3501",801,3},
  {{{0xe221c95cbeba5cf1}},5,"F-H0-3502",429,2},
  {{{0xd8343481193c82c1}},7,"F-H0-3503",906,33},
  {{{0x7e3943dae4f8878e}},7,"F-H0-3504",715,8},
  {{{0xdeb149385ac207d6}},7,"F-H0-3505",914,6},
  {{{0x6c5734cd92cebd6}},3,"F-H0-3506",468,25},
  {{{0x6c5734cd92cebd6}},3,"F-H0-3507",469,10},
  {{{0x6c5734cd92cebd6}},3,"F-H0-3508",506,6},
  {{{0x6c5734cd92cebd6}},3,"F-H0-3509",863,2},
  {{{0xd24440ff3782e331}},5,"F-H0-3510",910,15},
  {{{0xd24440ff3782e331}},5,"F-H0-3511",493,14},
  {{{0x28a78a17a24f90ff}},5,"F-H0-3512",910,3},
  {{{0xd24440ff3782e331}},5,"F-H0-3513",948,2},
  {{{0xb22175109541da2c}},5,"F-H0-3514",506,2},
  {{{0xcfd52a7ff816e0f}},12,"F-H0-3515",580,22},
  {{{0xaca7056f053af883}},12,"F-H0-3516",943,9},
  {{{0x3d5b7f96fd553fd5}},12,"F-H0-3517",839,5},
  {{{0x40551a25c0d21abc}},12,"F-H0-3518",421,2},
  {{{0x8ab49e9bd33ca108}},12,"F-H0-3519",947,2},
  {{{0x2e5a008ebb9a3b3f}},5,"F-H0-3520",901,22},
  {{{0xc842acba7efbdcb7}},5,"F-H0-3521",902,12},
  {{{0xc842acba7efbdcb7}},5,"F-H0-3522",505,8},
  {{{0xc842acba7efbdcb7}},5,"F-H0-3523",938,2},
  {{{0xdebab73b308c14be}},7,"F-H0-3524",690,42},
  {{{0xdebab73b308c14be}},7,"F-H0-3525",825,2},
  {{{0x91b668a18acfcd7c}},11,"F-H0-3526",640,45},
  {{{0x1c53c3357474bbca}},6,"F-H0-3527",789,20},
  {{{0x1d8b879b9b12f09c}},6,"F-H0-3528",503,11},
  {{{0x1c53c3357474bbca}},6,"F-H0-3529",826,5},
  {{{0x1d8b879b9b12f09c}},6,"F-H0-3530",432,5},
  {{{0x509010b85a1767a6}},6,"F-H0-3531",420,3},
  {{{0x1d91fa3c1e7f4c57}},14,"F-H0-3532",429,39},
  {{{0x96505f836d1005cb}},8,"F-H0-3533",495,9},
  {{{0x58c6d345fd384ed7}},8,"F-H0-3534",690,20},
  {{{0x58c6d345fd384ed7}},8,"F-H0-3535",543,12},
  {{{0x58c6d345fd384ed7}},8,"F-H0-3536",653,2},
  {{{0x58c6d345fd384ed7}},8,"F-H0-3537",421,2},
  {{{0xddd2cc9f3d64c095}},8,"F-H0-3538",911,30},
  {{{0xddd2cc9f3d64c095}},8,"F-H0-3539",949,5},
  {{{0xf227c20f1ffe5a1b}},8,"F-H0-3540",617,2},
  {{{0x44bdd0b5819af3f8}},5,"F-H0-3541",691,20},
  {{{0x619742d55bf4295a}},5,"F-H0-3542",426,13},
  {{{0x44bdd0b5819af3f8}},5,"F-H0-3543",939,6},
  {{{0xaa4570711e90b4d0}},5,"F-H0-3544",947,3},
  {{{0x44bdd0b5819af3f8}},5,"F-H0-3545",690,3},
  {{{0xcccb39007f729d9f}},4,"F-H0-3546",911,19},
  {{{0xbb2ac735e02576dc}},4,"F-H0-3547",944,8},
  {{{0xad116f6eafa50fa8}},4,"F-H0-3548",420,5},
  {{{0xbb2ac735e02576dc}},4,"F-H0-3549",907,5},
  {{{0xbb2ac735e02576dc}},4,"F-H0-3550",467,3},
  {{{0xc9fb4d1913e832a0}},4,"F-H0-3551",542,2},
  {{{0x846036288704a68c}},7,"F-H0-3552",911,15},
  {{{0x846036288704a68c}},7,"F-H0-3553",825,9},
  {{{0x846036288704a68c}},7,"F-H0-3554",947,8},
  {{{0x846036288704a68c}},7,"F-H0-3555",470,3},
  {{{0x846036288704a68c}},7,"F-H0-3556",910,3},
  {{{0x846036288704a68c}},7,"F-H0-3557",944,2},
  {{{0x4cf19a48c57d10f8}},5,"F-H0-3558",506,20},
  {{{0x23d35c7ea26b4d4f}},5,"F-H0-3559",863,13},
  {{{0xb8a390c40d822bf6}},5,"F-H0-3560",691,3},
  {{{0x23d35c7ea26b4d4f}},5,"F-H0-3561",426,3},
  {{{0x4cf19a48c57d10f8}},5,"F-H0-3562",542,2},
  {{{0x4cf19a48c57d10f8}},5,"F-H0-3563",543,2},
  {{{0xa0c37ef9b36aeeef}},9,"F-H0-3564",863,32},
  {{{0x847ceb9564bf53ef}},9,"F-H0-3565",935,2},
  {{{0xa9fa795a03fcf939}},7,"F-H0-3566",432,33},
  {{{0x8aa501741087c75b}},7,"F-H0-3567",715,4},
  {{{0xe6d8a27ec78bb29e}},7,"F-H0-3568",617,2},
  {{{0xe6d8a27ec78bb29e}},7,"F-H0-3569",466,2},
  {{{0xe6d8a27ec78bb29e}},7,"F-H0-3570",429,2},
  {{{0xa508489aa33d2ecf}},8,"F-H0-3571",765,21},
  {{{0x240ec9ddc48dc7ca}},8,"F-H0-3572",825,7},
  {{{0x18dc85f04320343a}},8,"F-H0-3573",838,5},
  {{{0x18dc85f04320343a}},8,"F-H0-3574",907,4},
  {{{0x18dc85f04320343a}},8,"F-H0-3575",432,3},
  {{{0x18dc85f04320343a}},8,"F-H0-3576",910,2},
  {{{0x18dc85f04320343a}},8,"F-H0-3577",802,2},
  {{{0x1b6595fbec1242d1}},12,"F-H0-3578",904,30},
  {{{0x1b6595fbec1242d1}},12,"F-H0-3579",943,8},
  {{{0x2c2cd8649e449ba4}},2,"F-H0-3580",493,11},
  {{{0x672ff7f2a49cdf00}},2,"F-H0-3581",875,4},
  {{{0x672ff7f2a49cdf00}},2,"F-H0-3582",467,4},
  {{{0xd63d6497dcb7db06}},2,"F-H0-3583",875,3},
  {{{0x2c2cd8649e449ba4}},2,"F-H0-3584",947,3},
  {{{0x672ff7f2a49cdf00}},2,"F-H0-3585",876,3},
  {{{0x2c2cd8649e449ba4}},2,"F-H0-3586",506,3},
  {{{0xdce2b08c812bf602}},2,"F-H0-3587",468,2},
  {{{0x2a624f270d0d47aa}},3,"F-H0-3588",468,28},
  {{{0x2a624f270d0d47aa}},3,"F-H0-3589",469,9},
  {{{0x2a624f270d0d47aa}},3,"F-H0-3590",506,3},
  {{{0x2a624f270d0d47aa}},3,"F-H0-3591",913,2},
  {{{0x2a624f270d0d47aa}},3,"F-H0-3592",467,2},
  {{{0xe5f0e23da35e89b0}},5,"F-H0-3593",825,18},
  {{{0xe5f0e23da35e89b0}},5,"F-H0-3594",941,10},
  {{{0x9c393bb66809121e}},5,"F-H0-3595",838,4},
  {{{0x7ad53b537c775701}},5,"F-H0-3596",727,4},
  {{{0xc94df894c982d692}},5,"F-H0-3597",678,2},
  {{{0xe5f0e23da35e89b0}},5,"F-H0-3598",942,2},
  {{{0x73e0f43d8b51f812}},14,"F-H0-3599",949,8},
  {{{0x1098ac67af47d78d}},8,"F-H0-3600",949,42},
  {{{0xcc423a435d09a004}},5,"F-H0-3601",421,18},
  {{{0xb6448dc6aeb4b645}},5,"F-H0-3602",945,6},
  {{{0x35ee41c71d7b8efc}},5,"F-H0-3603",863,6},
  {{{0x35ee41c71d7b8efc}},5,"F-H0-3604",727,5},
  {{{0xcc423a435d09a004}},5,"F-H0-3605",678,4},
  {{{0x35ee41c71d7b8efc}},5,"F-H0-3606",542,4},
  {{{0xcc423a435d09a004}},5,"F-H0-3607",863,4},
  {{{0xb6448dc6aeb4b645}},5,"F-H0-3608",838,2},
  {{{0xfcbd295e006fb1ed}},8,"F-H0-3609",899,28},
  {{{0xe58ee2ee6a9f2a44}},7,"F-H0-3610",418,13},
  {{{0x912ab19033a20824}},7,"F-H0-3611",765,3},
  {{{0x2b5b2cafc189e442}},7,"F-H0-3612",825,2},
  {{{0xf4489b494748bdf4}},7,"F-H0-3613",421,2},
  {{{0xe58ee2ee6a9f2a44}},7,"F-H0-3614",943,2},
  {{{0x2b5b2cafc189e442}},7,"F-H0-3615",428,2},
  {{{0xa19ee3897a0a6a75}},15,"F-H0-3616",904,22},
  {{{0x97ba9eed77f0903d}},15,"F-H0-3617",950,19},
  {{{0x88e73c90de275e39}},17,"F-H0-3618",839,15},
  {{{0x88e73c90de275e39}},17,"F-H0-3619",943,14},
  {{{0x19b3b85ec2fcf3a7}},17,"F-H0-3620",800,4},
  {{{0x485b3966ea1112be}},17,"F-H0-3621",788,4},
  {{{0x1ab178afde793d5b}},7,"F-H0-3622",418,19},
  {{{0x1609a970c4640f6c}},7,"F-H0-3623",839,9},
  {{{0x1609a970c4640f6c}},7,"F-H0-3624",421,7},
  {{{0xfebe5729112cec6e}},7,"F-H0-3625",543,3},
  {{{0x1ab178afde793d5b}},7,"F-H0-3626",825,2},
  {{{0xfebe5729112cec6e}},7,"F-H0-3627",802,2},
  {{{0xff97671bf7f8ca6f}},8,"F-H0-3628",727,29},
  {{{0x56170e76d58dcaeb}},8,"F-H0-3629",942,3},
  {{{0x5dfff508723d697a}},8,"F-H0-3630",946,2},
  {{{0x9648eff5e8fc7703}},3,"F-H0-3631",418,13},
  {{{0x319743a0f7093f9c}},3,"F-H0-3632",913,11},
  {{{0x2d0fb697fa32f278}},3,"F-H0-3633",912,3},
  {{{0xa76aa3927fde7c85}},3,"F-H0-3634",863,2},
  {{{0xb924e706b42edbd5}},7,"F-H0-3635",985,20},
  {{{0xb924e706b42edbd5}},7,"F-H0-3636",912,13},
  {{{0xb924e706b42edbd5}},7,"F-H0-3637",911,12},
  {{{0xcff37a6a1ecce499}},9,"F-H0-3638",913,39},
  {{{0xc9807ff852ea7579}},10,"F-H0-3639",875,42},
  {{{0x51592d9b34f22864}},6,"F-H0-3640",421,36},
  {{{0x477e3f26ee9499a1}},6,"F-H0-3641",912,6},
  {{{0x3a7e57509201d15b}},4,"F-H0-3642",419,12},
  {{{0x3a7e57509201d15b}},4,"F-H0-3643",908,8},
  {{{0x3a7e57509201d15b}},4,"F-H0-3644",946,7},
  {{{0x3a7e57509201d15b}},4,"F-H0-3645",945,3},
  {{{0xe59e9377799b3e6e}},4,"F-H0-3646",910,3},
  {{{0x8201e6ec8245959a}},4,"F-H0-3647",468,2},
  {{{0x3a7e57509201d15b}},4,"F-H0-3648",907,2},
  {{{0x3a7e57509201d15b}},4,"F-H0-3649",944,2},
  {{{0x2ed74dbc2950fc48}},5,"F-H0-3650",640,5},
  {{{0xb80122ae4b24111e}},5,"F-H0-3651",973,2},
  {{{0x49845bdc5bf6e859}},11,"F-H0-3652",839,14},
  {{{0x40f87e2390cd3bf5}},11,"F-H0-3653",947,7},
  {{{0x49845bdc5bf6e859}},11,"F-H0-3654",424,7},
  {{{0x40f87e2390cd3bf5}},11,"F-H0-3655",839,5},
  {{{0x40f87e2390cd3bf5}},11,"F-H0-3656",939,2},
  {{{0x40f87e2390cd3bf5}},11,"F-H0-3657",943,2},
  {{{0x287e47e454b42287}},3,"F-H0-3658",468,18},
  {{{0x287e47e454b42287}},3,"F-H0-3659",456,11},
  {{{0x227d0a92854bd04a}},3,"F-H0-3660",913,4},
  {{{0x287e47e454b42287}},3,"F-H0-3661",906,2},
  {{{0xcda345a7020c81a5}},3,"F-H0-3662",430,2},
  {{{0xbf2fd1e8c035d7b2}},7,"F-H0-3663",801,26},
  {{{0xbf2fd1e8c035d7b2}},7,"F-H0-3664",837,9},
  {{{0xbf2fd1e8c035d7b2}},7,"F-H0-3665",876,4},
  {{{0xbf2fd1e8c035d7b2}},7,"F-H0-3666",838,2},
  {{{0x93509c1e3f98bda5}},8,"F-H0-3667",690,14},
  {{{0xb2a4dd482ff0f508}},8,"F-H0-3668",529,12},
  {{{0x7af6a1a5234df978}},8,"F-H0-3669",863,3},
  {{{0x93509c1e3f98bda5}},8,"F-H0-3670",425,2},
  {{{0x93509c1e3f98bda5}},8,"F-H0-3671",653,2},
  {{{0x13e63ae4fc9b119b}},6,"F-H0-3672",764,11},
  {{{0xeaf0b0a5f66541c}},6,"F-H0-3673",458,9},
  {{{0xf0e2a279f8feb56}},6,"F-H0-3674",948,9},
  {{{0xf0e2a279f8feb56}},6,"F-H0-3675",429,5},
  {{{0x592e752b77d249a3}},6,"F-H0-3676",864,5},
  {{{0xf0e2a279f8feb56}},6,"F-H0-3677",839,2},
  {{{0x78fe7f670b62e4ef}},6,"F-H0-3678",902,2},
  {{{0x507201083e80dbad}},7,"F-H0-3679",947,37},
  {{{0x507201083e80dbad}},7,"F-H0-3680",912,6},
  {{{0x3fdbb8217fa7ca59}},6,"F-H0-3681",902,20},
  {{{0x3fdbb8217fa7ca59}},6,"F-H0-3682",751,8},
  {{{0x3fdbb8217fa7ca59}},6,"F-H0-3683",939,5},
  {{{0x9d02a2f057631276}},6,"F-H0-3684",727,4},
  {{{0x3d2dd0adfb1bca90}},6,"F-H0-3685",751,18},
  {{{0x3d2dd0adfb1bca90}},6,"F-H0-3686",902,7},
  {{{0x83db84c4558281ea}},6,"F-H0-3687",902,5},
  {{{0x9481752e8bbf47bb}},6,"F-H0-3688",678,4},
  {{{0x3d2dd0adfb1bca90}},6,"F-H0-3689",715,3},
  {{{0x3d2dd0adfb1bca90}},6,"F-H0-3690",864,2},
  {{{0x4c17e1ab5c076b32}},11,"F-H0-3691",392,29},
  {{{0xdd5264ef18c34cb9}},11,"F-H0-3692",987,8},
  {{{0xdd5264ef18c34cb9}},11,"F-H0-3693",838,2},
  {{{0x402f09cfc1e9f1b6}},7,"F-H0-3694",874,31},
  {{{0xc0fbc17daf1f09dc}},7,"F-H0-3695",939,4},
  {{{0x1e83bf97673f80a}},7,"F-H0-3696",948,4},
  {{{0xfe003175d0ad15f1}},3,"F-H0-3697",468,27},
  {{{0x3f4d915b6925f4c3}},3,"F-H0-3698",455,16},
  {{{0x17e77d0ba29b7375}},8,"F-H0-3699",945,22},
  {{{0x17e77d0ba29b7375}},8,"F-H0-3700",910,5},
  {{{0x7c6da0e753be27ed}},8,"F-H0-3701",690,3},
  {{{0x17e77d0ba29b7375}},8,"F-H0-3702",838,3},
  {{{0x17e77d0ba29b7375}},8,"F-H0-3703",907,2},
  {{{0x17e77d0ba29b7375}},8,"F-H0-3704",839,2},
  {{{0x521ad8c12e6bb77b}},13,"F-H0-3705",938,30},
  {{{0xae685b4207155cdc}},13,"F-H0-3706",528,2},
  {{{0x9eb7905ed797d2a6}},11,"F-H0-3707",975,32},
  {{{0x88d7b24b23b3325c}},10,"F-H0-3708",974,26},
  {{{0xee118160f7624871}},7,"F-H0-3709",875,16},
  {{{0x8d6a4d2737713102}},11,"F-H0-3710",871,33},
  {{{0x6effa1444fbc7b27}},7,"F-H0-3711",418,15},
  {{{0x6effa1444fbc7b27}},7,"F-H0-3712",911,12},
  {{{0x98fda7c05d3896af}},7,"F-H0-3713",902,3},
  {{{0x45b725b404df544f}},7,"F-H0-3714",839,3},
  {{{0x45b725b404df544f}},7,"F-H0-3715",940,2},
  {{{0x644e9e8ba185b6d}},6,"F-H0-3716",826,8},
  {{{0x644e9e8ba185b6d}},6,"F-H0-3717",751,7},
  {{{0x23098885f51a2416}},6,"F-H0-3718",910,5},
  {{{0x23098885f51a2416}},6,"F-H0-3719",678,3},
  {{{0xec2885a6a2d0b690}},6,"F-H0-3720",504,3},
  {{{0x644e9e8ba185b6d}},6,"F-H0-3721",827,2},
  {{{0xae56b3aed1d589b4}},12,"F-H0-3722",973,26},
  {{{0xaf08c744d15abe82}},4,"F-H0-3723",468,10},
  {{{0xaf08c744d15abe82}},4,"F-H0-3724",948,9},
  {{{0x282d553abcb02d44}},4,"F-H0-3725",913,7},
  {{{0x1008c553bee6c8fa}},4,"F-H0-3726",826,5},
  {{{0xaf08c744d15abe82}},4,"F-H0-3727",945,2},
  {{{0x282d553abcb02d44}},4,"F-H0-3728",876,2},
  {{{0x1008c553bee6c8fa}},4,"F-H0-3729",864,2},
  {{{0xaf08c744d15abe82}},4,"F-H0-3730",949,2},
  {{{0xaf08c744d15abe82}},4,"F-H0-3731",505,2},
  {{{0x8b770cdc0f63b25e}},5,"F-H0-3732",911,16},
  {{{0x5790eb26481be6f3}},5,"F-H0-3733",691,10},
  {{{0xe6568844c77730a9}},5,"F-H0-3734",862,5},
  {{{0xe6568844c77730a9}},5,"F-H0-3735",727,2},
  {{{0xf559fd3d8d031fe9}},5,"F-H0-3736",939,2},
  {{{0xe2abc3f77f1a0573}},6,"F-H0-3737",949,17},
  {{{0xb7703aad286fdb15}},6,"F-H0-3738",751,8},
  {{{0xa24f8ecb0fc5a3f1}},6,"F-H0-3739",728,4},
  {{{0xe2abc3f77f1a0573}},6,"F-H0-3740",911,3},
  {{{0xe2abc3f77f1a0573}},6,"F-H0-3741",943,2},
  {{{0xe2abc3f77f1a0573}},6,"F-H0-3742",543,2},
  {{{0x311cf317cf59a197}},8,"F-H0-3743",678,17},
  {{{0x311cf317cf59a197}},8,"F-H0-3744",529,11},
  {{{0x88828cf7e0741d4d}},8,"F-H0-3745",691,3},
  {{{0x311cf317cf59a197}},8,"F-H0-3746",425,2},
  {{{0x311cf317cf59a197}},8,"F-H0-3747",429,2},
  {{{0x1dbdf98e22040e3d}},5,"F-H0-3748",943,11},
  {{{0xf92e192f102f60eb}},5,"F-H0-3749",429,8},
  {{{0xa928882c65c6a351}},5,"F-H0-3750",906,7},
  {{{0xde8dc8094d6e8049}},5,"F-H0-3751",906,3},
  {{{0xde8dc8094d6e8049}},5,"F-H0-3752",947,2},
  {{{0xa928882c65c6a351}},5,"F-H0-3753",839,2},
  {{{0xb746b1cf8595280c}},5,"F-H0-3754",542,6},
  {{{0x687c8d89a0709f35}},5,"F-H0-3755",976,2},
  {{{0x82d58e180d845f13}},5,"F-H0-3756",789,2},
  {{{0xc6d104fea8b572ea}},4,"F-H0-3757",469,16},
  {{{0x3591031884f2acc4}},7,"F-H0-3758",542,29},
  {{{0xcb76ebf580a9f379}},7,"F-H0-3759",910,11},
  {{{0xa5794393e1fb7f02}},4,"F-H0-3760",862,14},
  {{{0xc8e7c2a5ae063f28}},4,"F-H0-3761",875,10},
  {{{0x1d274cfbf0b36373}},4,"F-H0-3762",948,4},
  {{{0xa5794393e1fb7f02}},4,"F-H0-3763",825,3},
  {{{0xc53f9037a998085b}},4,"F-H0-3764",543,3},
  {{{0xa85a3c171f5498f0}},4,"F-H0-3765",641,9},
  {{{0xa85a3c171f5498f0}},4,"F-H0-3766",913,6},
  {{{0xe05de06cd84d2bb9}},4,"F-H0-3767",654,6},
  {{{0xb0e099edd51f4b3e}},4,"F-H0-3768",899,6},
  {{{0x8b081646a0ce5c9a}},4,"F-H0-3769",425,5},
  {{{0xa85a3c171f5498f0}},4,"F-H0-3770",943,2},
  {{{0x52ceb28cd3e4a26}},3,"F-H0-3771",456,26},
  {{{0x52ceb28cd3e4a26}},3,"F-H0-3772",455,9},
  {{{0x52ceb28cd3e4a26}},3,"F-H0-3773",493,3},
  {{{0x52ceb28cd3e4a26}},3,"F-H0-3774",492,2},
  {{{0x59f3c7f76ec6bd19}},12,"F-H0-3775",944,25},
  {{{0x3ad8e262cdba7333}},12,"F-H0-3776",868,5},
  {{{0xdba7a83951976e48}},14,"F-H0-3777",950,27},
  {{{0xdba7a83951976e48}},14,"F-H0-3778",983,4},
  {{{0x684e4b18f1e6358a}},13,"F-H0-3779",985,33},
  {{{0x5dbf364f1f8146ef}},8,"F-H0-3780",418,21},
  {{{0x659325c9fb3804c0}},8,"F-H0-3781",543,7},
  {{{0x659325c9fb3804c0}},8,"F-H0-3782",751,3},
  {{{0x659325c9fb3804c0}},8,"F-H0-3783",690,3},
  {{{0x882f7223eefd0981}},11,"F-H0-3784",947,11},
  {{{0x882f7223eefd0981}},11,"F-H0-3785",825,10},
  {{{0xfbbb8239fb9055f0}},11,"F-H0-3786",691,5},
  {{{0x882f7223eefd0981}},11,"F-H0-3787",839,3},
  {{{0x15a089ef2aaaae85}},11,"F-H0-3788",424,3},
  {{{0x882f7223eefd0981}},11,"F-H0-3789",462,2},
  {{{0xfbbb8239fb9055f0}},11,"F-H0-3790",577,2},
  {{{0x8ecd16dc77fa1f37}},7,"F-H0-3791",873,27},
  {{{0x8ecd16dc77fa1f37}},7,"F-H0-3792",950,11},
  {{{0x42238f917f1265c9}},5,"F-H0-3793",430,13},
  {{{0x42238f917f1265c9}},5,"F-H0-3794",464,10},
  {{{0x91db426907923185}},5,"F-H0-3795",422,6},
  {{{0x8491b45b1674ac95}},5,"F-H0-3796",466,4},
  {{{0x42238f917f1265c9}},5,"F-H0-3797",911,2},
  {{{0xde417bda514b9940}},5,"F-H0-3798",460,7},
  {{{0xde417bda514b9940}},5,"F-H0-3799",863,5},
  {{{0xde417bda514b9940}},5,"F-H0-3800",459,4},
  {{{0xde417bda514b9940}},5,"F-H0-3801",493,3},
  {{{0xde417bda514b9940}},5,"F-H0-3802",422,3},
  {{{0xde417bda514b9940}},5,"F-H0-3803",424,3},
  {{{0xde417bda514b9940}},5,"F-H0-3804",911,2},
  {{{0xafc89e52b0681076}},5,"F-H0-3805",910,2},
  {{{0x40be7996ae701051}},5,"F-H0-3806",493,18},
  {{{0x40be7996ae701051}},5,"F-H0-3807",942,6},
  {{{0xc26de1986bfe07fd}},5,"F-H0-3808",948,4},
  {{{0xddc6c99b1b773e7}},5,"F-H0-3809",425,3},
  {{{0x40be7996ae701051}},5,"F-H0-3810",530,3},
  {{{0x40be7996ae701051}},5,"F-H0-3811",529,3},
  {{{0x924fc1b6196d4e8c}},5,"F-H0-3812",906,2},
  {{{0x40be7996ae701051}},5,"F-H0-3813",462,2},
  {{{0x5b04e250cd569585}},5,"F-H0-3814",789,11},
  {{{0xf43fab115b625526}},5,"F-H0-3815",837,8},
  {{{0xf43fab115b625526}},5,"F-H0-3816",838,6},
  {{{0xf43fab115b625526}},5,"F-H0-3817",876,3},
  {{{0xf43fab115b625526}},5,"F-H0-3818",455,2},
  {{{0x5ef148a23c29a9fd}},14,"F-H0-3819",899,9},
  {{{0xa1c034b36429297f}},14,"F-H0-3820",936,2},
  {{{0x2571c176fcd70254}},5,"F-H0-3821",752,13},
  {{{0x3be00d3da6a8e343}},5,"F-H0-3822",911,6},
  {{{0x3be00d3da6a8e343}},5,"F-H0-3823",948,5},
  {{{0x3be00d3da6a8e343}},5,"F-H0-3824",466,4},
  {{{0x3be00d3da6a8e343}},5,"F-H0-3825",467,3},
  {{{0xb5d0a181ffed0bed}},5,"F-H0-3826",429,2},
  {{{0x3be00d3da6a8e343}},5,"F-H0-3827",654,2},
  {{{0x3be00d3da6a8e343}},5,"F-H0-3828",653,2},
  {{{0xcd1cf809e5a221b5}},14,"F-H0-3829",825,24},
  {{{0xdd4ba346e1ff47e8}},7,"F-H0-3830",839,13},
  {{{0x7c3508bb21dbaf89}},7,"F-H0-3831",943,6},
  {{{0x7c3508bb21dbaf89}},7,"F-H0-3832",939,4},
  {{{0x7c3508bb21dbaf89}},7,"F-H0-3833",875,2},
  {{{0x89e3a29dfbdfb3d6}},15,"F-H0-3834",947,13},
  {{{0x394292295007da5f}},15,"F-H0-3835",911,8},
  {{{0x4f2d0c179c36db3a}},15,"F-H0-3836",947,4},
  {{{0x4f2d0c179c36db3a}},15,"F-H0-3837",728,3},
  {{{0x394292295007da5f}},15,"F-H0-3838",948,3},
  {{{0xd5f608228a7857c3}},5,"F-H0-3839",904,15},
  {{{0xe85b43af6ad18f5f}},5,"F-H0-3840",422,8},
  {{{0x536896f357dda46c}},5,"F-H0-3841",542,6},
  {{{0xe85b43af6ad18f5f}},5,"F-H0-3842",420,3},
  {{{0xe85b43af6ad18f5f}},5,"F-H0-3843",431,2},
  {{{0xb4ab10e4b9215dd3}},5,"F-H0-3844",691,2},
  {{{0x536896f357dda46c}},5,"F-H0-3845",947,2},
  {{{0x91b2cc3c9208e3cd}},4,"F-H0-3846",862,15},
  {{{0x8ab25ca5df3bbd02}},4,"F-H0-3847",457,11},
  {{{0x91b2cc3c9208e3cd}},4,"F-H0-3848",506,4},
  {{{0x8ab25ca5df3bbd02}},4,"F-H0-3849",420,3},
  {{{0x91b2cc3c9208e3cd}},4,"F-H0-3850",529,2},
  {{{0x8ab25ca5df3bbd02}},4,"F-H0-3851",543,2},
  {{{0xe963ed3a7834b2f1}},11,"F-H0-3852",616,30},
  {{{0xc525f0ff354b606e}},11,"F-H0-3853",943,3},
  {{{0xf20b4ad20a115d3c}},10,"F-H0-3854",690,32},
  {{{0xeb92727569568b56}},16,"F-H0-3855",617,26},
  {{{0xd47f43c3374d6fc9}},16,"F-H0-3856",640,2},
  {{{0xeb92727569568b56}},16,"F-H0-3857",876,2},
  {{{0xbb4410793f31e66f}},4,"F-H0-3858",943,8},
  {{{0x1a0dc676a2b48e08}},4,"F-H0-3859",421,6},
  {{{0x38071568a2b04032}},4,"F-H0-3860",421,2},
  {{{0x38071568a2b04032}},4,"F-H0-3861",943,2},
  {{{0x38071568a2b04032}},4,"F-H0-3862",906,2},
  {{{0x38071568a2b04032}},4,"F-H0-3863",567,2},
  {{{0x37d86cd7c08c9502}},7,"F-H0-3864",542,16},
  {{{0x5e4fc8bcfad09276}},7,"F-H0-3865",826,12},
  {{{0x37d86cd7c08c9502}},7,"F-H0-3866",504,8},
  {{{0x640aa14c7d694780}},14,"F-H0-3867",691,28},
  {{{0xe17e99241b76577c}},8,"F-H0-3868",908,21},
  {{{0xe17e99241b76577c}},8,"F-H0-3869",948,5},
  {{{0xf02de6cd1579980f}},8,"F-H0-3870",826,4},
  {{{0xe17e99241b76577c}},8,"F-H0-3871",946,3},
  {{{0xe17e99241b76577c}},8,"F-H0-3872",839,3},
  {{{0x4cd45bf3fcc436fa}},5,"F-H0-3873",943,28},
  {{{0xfad37e1466c0b277}},5,"F-H0-3874",640,3},
  {{{0xfad37e1466c0b277}},5,"F-H0-3875",939,3},
  {{{0x77b7024e766ccbac}},5,"F-H0-3876",838,3},
  {{{0xa35a42664a8e5e79}},2,"F-H0-3877",901,9},
  {{{0xb3fae9e6156ee149}},2,"F-H0-3878",912,3},
  {{{0x362f96ad0a9f67ec}},2,"F-H0-3879",906,2},
  {{{0x20e0fe6358cb161a}},6,"F-H0-3880",429,10},
  {{{0xbb0a61099d2bcbed}},6,"F-H0-3881",788,10},
  {{{0xbb0a61099d2bcbed}},6,"F-H0-3882",752,9},
  {{{0x1e3956f0bdc0cfcf}},6,"F-H0-3883",938,3},
  {{{0xaeb0aff6d822f3ce}},6,"F-H0-3884",459,2},
  {{{0xbb0a61099d2bcbed}},6,"F-H0-3885",864,2},
  {{{0xaeb0aff6d822f3ce}},6,"F-H0-3886",424,2},
  {{{0x662fb60846238e1e}},4,"F-H0-3887",505,6},
  {{{0x7c72b307e9c49244}},4,"F-H0-3888",429,5},
  {{{0x26ad69a6676f5920}},4,"F-H0-3889",938,5},
  {{{0x662fb60846238e1e}},4,"F-H0-3890",543,4},
  {{{0x7c72b307e9c49244}},4,"F-H0-3891",876,4},
  {{{0x26ad69a6676f5920}},4,"F-H0-3892",458,4},
  {{{0x7c72b307e9c49244}},4,"F-H0-3893",863,2},
  {{{0xeac1f7f65b50f953}},4,"F-H0-3894",421,2},
  {{{0x9d6a0392b455d73f}},4,"F-H0-3895",429,6},
  {{{0xa61952127a933d3a}},4,"F-H0-3896",949,4},
  {{{0x539aabe87a38d85}},4,"F-H0-3897",947,4},
  {{{0x539aabe87a38d85}},4,"F-H0-3898",839,3},
  {{{0x1619d9341c55c41d}},4,"F-H0-3899",425,2},
  {{{0x539aabe87a38d85}},4,"F-H0-3900",939,2},
  {{{0xc63c02464d89a66a}},13,"F-H0-3901",938,34},
  {{{0xc63c02464d89a66a}},13,"F-H0-3902",974,6},
  {{{0xa705eff181d526ae}},10,"F-H0-3903",838,18},
  {{{0x8c9ad8fb55f8a484}},10,"F-H0-3904",470,6},
  {{{0x5b11f61ca9b53304}},10,"F-H0-3905",906,6},
  {{{0x5b11f61ca9b53304}},10,"F-H0-3906",678,3},
  {{{0xfee46011037e64e5}},10,"F-H0-3907",936,2},
  {{{0xa511047f4185f279}},5,"F-H0-3908",839,13},
  {{{0x79145e1492e4698}},5,"F-H0-3909",911,8},
  {{{0x473b90bfea87bc2c}},5,"F-H0-3910",751,7},
  {{{0x79145e1492e4698}},5,"F-H0-3911",466,3},
  {{{0xfbe3e912ca4dd3d1}},5,"F-H0-3912",506,2},
  {{{0xce2f3b35766fb480}},4,"F-H0-3913",421,17},
  {{{0x7d885c22733b3b78}},4,"F-H0-3914",862,10},
  {{{0xed4e361ebae7d395}},4,"F-H0-3915",419,5},
  {{{0xed4e361ebae7d395}},4,"F-H0-3916",839,4},
  {{{0x2c93d81fa7d36ca8}},9,"F-H0-3917",862,25},
  {{{0x146f9cd22d912698}},9,"F-H0-3918",433,4},
  {{{0xbd2444534fa88dd4}},9,"F-H0-3919",987,2},
  {{{0x4a5d271ff68a5d9e}},8,"F-H0-3920",900,36},
  {{{0x90a7f81847ec35d6}},12,"F-H0-3921",906,24},
  {{{0xa5dfa801d4728a67}},12,"F-H0-3922",753,4},
  {{{0xe377a368b271ef36}},12,"F-H0-3923",947,3},
  {{{0x90a7f81847ec35d6}},12,"F-H0-3924",691,3},
  {{{0xe377a368b271ef36}},12,"F-H0-3925",839,3},
  {{{0x53e761a9f9792b13}},5,"F-H0-3926",947,8},
  {{{0x53e761a9f9792b13}},5,"F-H0-3927",911,6},
  {{{0x53e761a9f9792b13}},5,"F-H0-3928",944,6},
  {{{0xfd3717b03fd4a9bb}},5,"F-H0-3929",941,5},
  {{{0x53e761a9f9792b13}},5,"F-H0-3930",825,5},
  {{{0x53e761a9f9792b13}},5,"F-H0-3931",910,4},
  {{{0x8e315fc6a5f00a32}},5,"F-H0-3932",906,2},
  {{{0x67a3be5b9845a9b9}},5,"F-H0-3933",678,2},
  {{{0x666ee48fb0c1445d}},4,"F-H0-3934",911,18},
  {{{0xe11e01d9382c2729}},4,"F-H0-3935",876,9},
  {{{0xf189a6af8e129b3e}},4,"F-H0-3936",949,7},
  {{{0x666ee48fb0c1445d}},4,"F-H0-3937",457,3},
  {{{0xa06c131ae3a3b027}},5,"F-H0-3938",421,16},
  {{{0xf15b6a87329e2667}},5,"F-H0-3939",838,6},
  {{{0x3811cf4bc6951d1a}},5,"F-H0-3940",653,5},
  {{{0xf15b6a87329e2667}},5,"F-H0-3941",945,5},
  {{{0xa06c131ae3a3b027}},5,"F-H0-3942",678,3},
  {{{0x6bc5b3c003ea1cba}},4,"F-H0-3943",876,7},
  {{{0x6bc5b3c003ea1cba}},4,"F-H0-3944",468,6},
  {{{0x6bc5b3c003ea1cba}},4,"F-H0-3945",764,5},
  {{{0x6bc5b3c003ea1cba}},4,"F-H0-3946",469,5},
  {{{0x6bc5b3c003ea1cba}},4,"F-H0-3947",802,4},
  {{{0xc0b92a541b2da9b2}},4,"F-H0-3948",949,4},
  {{{0x6bc5b3c003ea1cba}},4,"F-H0-3949",910,4},
  {{{0xceca7a3228748153}},6,"F-H0-3950",752,16},
  {{{0xceca7a3228748153}},6,"F-H0-3951",901,8},
  {{{0xceca7a3228748153}},6,"F-H0-3952",789,4},
  {{{0xceca7a3228748153}},6,"F-H0-3953",908,3},
  {{{0x5cf3f82c3a3327d2}},3,"F-H0-3954",457,7},
  {{{0x5cf3f82c3a3327d2}},3,"F-H0-3955",456,7},
  {{{0x8f9feb850b57d0b1}},3,"F-H0-3956",457,7},
  {{{0x5cf3f82c3a3327d2}},3,"F-H0-3957",492,5},
  {{{0x1b7d9f5413eb7a60}},3,"F-H0-3958",493,3},
  {{{0x5cf3f82c3a3327d2}},3,"F-H0-3959",455,2},
  {{{0x5cf3f82c3a3327d2}},3,"F-H0-3960",948,2},
  {{{0x5b52ea15e92c9fd8}},7,"F-H0-3961",529,35},
  {{{0x6ad20709d777f168}},7,"F-H0-3962",912,5},
  {{{0xc99d83ba565160e9}},4,"F-H0-3963",505,13},
  {{{0xc99d83ba565160e9}},4,"F-H0-3964",506,11},
  {{{0x3cbb7be21e862be6}},4,"F-H0-3965",420,5},
  {{{0xc99d83ba565160e9}},4,"F-H0-3966",542,2},
  {{{0xb8d1df55a47cb72f}},4,"F-H0-3967",825,2},
  {{{0x283078a64b5571b7}},4,"F-H0-3968",529,11},
  {{{0x283078a64b5571b7}},4,"F-H0-3969",543,11},
  {{{0x8a9f5c40ae72301d}},4,"F-H0-3970",826,7},
  {{{0x1a3420b8381ac348}},4,"F-H0-3971",906,2},
  {{{0x283078a64b5571b7}},4,"F-H0-3972",425,2},
  {{{0x185de47b74066352}},14,"F-H0-3973",866,33},
  {{{0x102326ca586e015a}},14,"F-H0-3974",466,3},
  {{{0x9f4b53a9870592b7}},3,"F-H0-3975",900,25},
  {{{0x15455bbe638aad03}},3,"F-H0-3976",431,5},
  {{{0x36505ef77dfde6b8}},3,"F-H0-3977",506,2},
  {{{0x10e4a600aaec26ce}},15,"F-H0-3978",653,29},
  {{{0x1607cd64d726473f}},3,"F-H0-3979",468,17},
  {{{0x1607cd64d726473f}},3,"F-H0-3980",469,9},
  {{{0xcef6fe213044ce1f}},3,"F-H0-3981",431,5},
  {{{0x1607cd64d726473f}},3,"F-H0-3982",506,4},
  {{{0x1607cd64d726473f}},3,"F-H0-3983",431,3},
  {{{0x8822fe871161e86d}},5,"F-H0-3984",456,4},
  {{{0x8822fe871161e86d}},5,"F-H0-3985",947,3},
  {{{0x8822fe871161e86d}},5,"F-H0-3986",911,3},
  {{{0x5b5728c2bb8b87fd}},5,"F-H0-3987",429,2},
  {{{0x8822fe871161e86d}},5,"F-H0-3988",455,2},
  {{{0x5e0df68ad051832}},5,"F-H0-3989",837,12},
  {{{0x5e0df68ad051832}},5,"F-H0-3990",950,9},
  {{{0x5e0df68ad051832}},5,"F-H0-3991",877,5},
  {{{0x410737602c41682e}},5,"F-H0-3992",909,2},
  {{{0x5e0df68ad051832}},5,"F-H0-3993",948,2},
  {{{0x3b460b0007adf897}},7,"F-H0-3994",839,9},
  {{{0x2f2bcb8e3f839f5d}},7,"F-H0-3995",418,8},
  {{{0x249e2208c3de873d}},7,"F-H0-3996",678,4},
  {{{0x87f50f271108e564}},7,"F-H0-3997",728,3},
  {{{0x3b460b0007adf897}},7,"F-H0-3998",715,3},
  {{{0x3b460b0007adf897}},7,"F-H0-3999",827,2},
  {{{0x87f50f271108e564}},7,"F-H0-4000",914,2},
  {{{0x87f50f271108e564}},7,"F-H0-4001",764,2},
  {{{0x9b6d0a963f8513ca}},9,"F-H0-4002",429,29},
  {{{0xe848583e03f08069}},9,"F-H0-4003",911,4},
  {{{0x247956d03973ee41}},19,"F-H0-4004",944,31},
  {{{0xc1d56867663cedb0}},15,"F-H0-4005",983,13},
  {{{0xc1d56867663cedb0}},15,"F-H0-4006",836,11},
  {{{0xc1d56867663cedb0}},15,"F-H0-4007",873,4},
  {{{0xc1d56867663cedb0}},15,"F-H0-4008",908,3},
  {{{0xe61d8464151cb53c}},5,"F-H0-4009",839,34},
  {{{0xd99ea77da989cca1}},5,"F-H0-4010",466,11},
  {{{0xd99ea77da989cca1}},5,"F-H0-4011",429,10},
  {{{0xd99ea77da989cca1}},5,"F-H0-4012",653,7},
  {{{0xb0c3d2d64e209da5}},5,"F-H0-4013",946,4},
  {{{0xd99ea77da989cca1}},5,"F-H0-4014",617,4},
  {{{0xb537a5464a8fe741}},12,"F-H0-4015",865,2},
  {{{0x2a45949cc05cba49}},6,"F-H0-4016",913,32},
  {{{0xe9e96233276af0ac}},7,"F-H0-4017",838,23},
  {{{0x8494c552943ad245}},7,"F-H0-4018",579,5},
  {{{0xe9e96233276af0ac}},7,"F-H0-4019",456,3},
  {{{0xe9e96233276af0ac}},7,"F-H0-4020",455,3},
  {{{0xf788b45688ce1eca}},4,"F-H0-4021",579,3},
  {{{0xf788b45688ce1eca}},4,"F-H0-4022",948,2},
  {{{0xf788b45688ce1eca}},4,"F-H0-4023",543,2},
  {{{0x8b549c0d3c313873}},6,"F-H0-4024",948,11},
  {{{0x8b549c0d3c313873}},6,"F-H0-4025",429,9},
  {{{0x8b549c0d3c313873}},6,"F-H0-4026",874,7},
  {{{0xafd9ca5e52deaad1}},6,"F-H0-4027",458,4},
  {{{0x8b549c0d3c313873}},6,"F-H0-4028",949,3},
  {{{0xafd9ca5e52deaad1}},6,"F-H0-4029",531,2},
  {{{0x8b549c0d3c313873}},6,"F-H0-4030",945,2},
  {{{0x8b549c0d3c313873}},6,"F-H0-4031",690,2},
  {{{0x14ab1ab8f53d23f5}},5,"F-H0-4032",466,6},
  {{{0x14ab1ab8f53d23f5}},5,"F-H0-4033",617,6},
  {{{0x69c0e72930d78d56}},5,"F-H0-4034",461,5},
  {{{0x14ab1ab8f53d23f5}},5,"F-H0-4035",429,5},
  {{{0x14ab1ab8f53d23f5}},5,"F-H0-4036",911,3},
  {{{0x4aaf52c1dcd62863}},5,"F-H0-4037",906,2},
  {{{0x14ab1ab8f53d23f5}},5,"F-H0-4038",504,2},
  {{{0xc900861f62f80b0}},7,"F-H0-4039",911,16},
  {{{0xc900861f62f80b0}},7,"F-H0-4040",939,8},
  {{{0xddcb6dc69b9ea4a7}},7,"F-H0-4041",902,3},
  {{{0xc900861f62f80b0}},7,"F-H0-4042",948,3},
  {{{0x6d451116f81917a9}},6,"F-H0-4043",543,12},
  {{{0x6d451116f81917a9}},6,"F-H0-4044",690,8},
  {{{0x6d451116f81917a9}},6,"F-H0-4045",529,7},
  {{{0x9544f16cc9287dd}},6,"F-H0-4046",905,3},
  {{{0x6d451116f81917a9}},6,"F-H0-4047",677,2},
  {{{0x9544f16cc9287dd}},6,"F-H0-4048",424,2},
  {{{0x24ace1f6f5906d9e}},9,"F-H0-4049",763,16},
  {{{0x17e92553826cdd2}},9,"F-H0-4050",789,7},
  {{{0x1efa9d4a934a7967}},4,"F-H0-4051",906,10},
  {{{0x7d09d662b3dcb864}},4,"F-H0-4052",911,7},
  {{{0x7d09d662b3dcb864}},4,"F-H0-4053",910,3},
  {{{0x1efa9d4a934a7967}},4,"F-H0-4054",677,2},
  {{{0xac5be4a104cf1da9}},4,"F-H0-4055",431,2},
  {{{0x285e1863e9a19803}},4,"F-H0-4056",421,2},
  {{{0xcff0e4320b16208}},2,"F-H0-4057",912,18},
  {{{0xcff0e4320b16208}},2,"F-H0-4058",913,9},
  {{{0xcff0e4320b16208}},2,"F-H0-4059",949,3},
  {{{0xcff0e4320b16208}},2,"F-H0-4060",875,2},
  {{{0xcff0e4320b16208}},2,"F-H0-4061",876,2},
  {{{0x565e2216b2cef3bc}},3,"F-H0-4062",875,12},
  {{{0xa03ac6360125ff1b}},3,"F-H0-4063",456,7},
  {{{0xe7b4a14e28fda2a9}},3,"F-H0-4064",493,6},
  {{{0xa03ac6360125ff1b}},3,"F-H0-4065",455,4},
  {{{0x6ca13bdf9fc26191}},11,"F-H0-4066",903,4},
  {{{0x8534331775ed5ec5}},8,"F-H0-4067",910,28},
  {{{0x8534331775ed5ec5}},8,"F-H0-4068",909,7},
  {{{0x21e23d7ae31024a7}},6,"F-H0-4069",506,8},
  {{{0x6f02d859c12ecb4d}},6,"F-H0-4070",802,4},
  {{{0x6f02d859c12ecb4d}},6,"F-H0-4071",910,3},
  {{{0xfb15d22b19a2cc3}},6,"F-H0-4072",908,2},
  {{{0xfb15d22b19a2cc3}},6,"F-H0-4073",874,2},
  {{{0x9a0b4d922daa577d}},6,"F-H0-4074",424,19},
  {{{0x9a0b4d922daa577d}},6,"F-H0-4075",462,11},
  {{{0x291689bc1c4a8fc1}},7,"F-H0-4076",419,37},
  {{{0x9a33385a62d50f13}},8,"F-H0-4077",949,30},
  {{{0xbc1657add7a2aeca}},5,"F-H0-4078",505,11},
  {{{0x9bfc207ebe408794}},5,"F-H0-4079",902,7},
  {{{0xbc1657add7a2aeca}},5,"F-H0-4080",939,7},
  {{{0x9bfc207ebe408794}},5,"F-H0-4081",948,5},
  {{{0x9bfc207ebe408794}},5,"F-H0-4082",936,5},
  {{{0xe6767a98e421f80d}},7,"F-H0-4083",911,12},
  {{{0xe6767a98e421f80d}},7,"F-H0-4084",947,11},
  {{{0xe6767a98e421f80d}},7,"F-H0-4085",825,4},
  {{{0xe6767a98e421f80d}},7,"F-H0-4086",910,3},
  {{{0xe6767a98e421f80d}},7,"F-H0-4087",424,2},
  {{{0xe6767a98e421f80d}},7,"F-H0-4088",948,2},
  {{{0xf683c925679cf515}},7,"F-H0-4089",504,33},
  {{{0x3f1a522174f6356c}},7,"F-H0-4090",865,3},
  {{{0x8b3aa2b98c1764ba}},9,"F-H0-4091",838,12},
  {{{0x8b3aa2b98c1764ba}},9,"F-H0-4092",801,12},
  {{{0xe8277a28e4d85836}},9,"F-H0-4093",825,4},
  {{{0xe8277a28e4d85836}},9,"F-H0-4094",617,3},
  {{{0xe8277a28e4d85836}},9,"F-H0-4095",429,3},
  {{{0x994973d533b4ea0e}},5,"F-H0-4096",429,13},
  {{{0xeac4147ca1598835}},5,"F-H0-4097",529,9},
  {{{0x994973d533b4ea0e}},5,"F-H0-4098",943,4},
  {{{0x994973d533b4ea0e}},5,"F-H0-4099",430,3},
  {{{0x994973d533b4ea0e}},5,"F-H0-4100",947,2},
  {{{0x994973d533b4ea0e}},5,"F-H0-4101",427,2},
  {{{0x1c0d3d255b7b42c6}},4,"F-H0-4102",419,12},
  {{{0x1c0d3d255b7b42c6}},4,"F-H0-4103",839,7},
  {{{0x90eaef9c289bc36a}},4,"F-H0-4104",421,6},
  {{{0x88e86c01e297cac7}},4,"F-H0-4105",875,5},
  {{{0x90eaef9c289bc36a}},4,"F-H0-4106",912,3},
  {{{0xd64b71573f31f573}},7,"F-H0-4107",912,15},
  {{{0xd64b71573f31f573}},7,"F-H0-4108",911,9},
  {{{0xd64b71573f31f573}},7,"F-H0-4109",874,7},
  {{{0xd64b71573f31f573}},7,"F-H0-4110",617,2},
  {{{0xb3f96ac5e502bf34}},7,"F-H0-4111",464,2},
  {{{0xafc75a7e980fa09e}},3,"F-H0-4112",421,14},
  {{{0xafc75a7e980fa09e}},3,"F-H0-4113",912,7},
  {{{0xafc75a7e980fa09e}},3,"F-H0-4114",458,3},
  {{{0xafc75a7e980fa09e}},3,"F-H0-4115",641,3},
  {{{0xafc75a7e980fa09e}},3,"F-H0-4116",603,3},
  {{{0xafc75a7e980fa09e}},3,"F-H0-4117",468,2},
  {{{0xafc75a7e980fa09e}},3,"F-H0-4118",826,2},
  {{{0x4a9ac3cfd79bdaae}},3,"F-H0-4119",901,2},
  {{{0xf2174b9b838c6b12}},4,"F-H0-4120",949,7},
  {{{0x84527127efbbaeba}},4,"F-H0-4121",906,3},
  {{{0xe571920e46851e31}},4,"F-H0-4122",906,2},
  {{{0x84527127efbbaeba}},4,"F-H0-4123",426,2},
  {{{0x84527127efbbaeba}},4,"F-H0-4124",467,2},
  {{{0xf22b351a462547b1}},9,"F-H0-4125",986,24},
  {{{0xf22b351a462547b1}},9,"F-H0-4126",944,4},
  {{{0xf22b351a462547b1}},9,"F-H0-4127",910,2},
  {{{0x7211319d06c4a1a1}},8,"F-H0-4128",875,23},
  {{{0xc49b33c93429a79c}},8,"F-H0-4129",949,10},
  {{{0xc7d678ecaa94c723}},6,"F-H0-4130",873,15},
  {{{0xc7d678ecaa94c723}},6,"F-H0-4131",909,9},
  {{{0x555c1053a0ea79bb}},6,"F-H0-4132",838,3},
  {{{0xeea9b4baa57c93b9}},6,"F-H0-4133",492,3},
  {{{0xe238b6d472dfbf99}},7,"F-H0-4134",936,20},
  {{{0xe238b6d472dfbf99}},7,"F-H0-4135",865,11},
  {{{0x4967822463559f4}},7,"F-H0-4136",939,2},
  {{{0xb06ec72657bee2e2}},7,"F-H0-4137",616,2},
  {{{0x36c6421d3bdfa0fd}},6,"F-H0-4138",421,9},
  {{{0x3847d4c473655119}},6,"F-H0-4139",837,8},
  {{{0xba0f76b9b4067b80}},6,"F-H0-4140",432,7},
  {{{0xba0f76b9b4067b80}},6,"F-H0-4141",876,5},
  {{{0xba0f76b9b4067b80}},6,"F-H0-4142",429,3},
  {{{0xd31dd5072bfd065b}},7,"F-H0-4143",469,30},
  {{{0xd31dd5072bfd065b}},7,"F-H0-4144",431,2},
  {{{0xa7242b16be2afca1}},6,"F-H0-4145",908,11},
  {{{0x6d2f04f19a897523}},6,"F-H0-4146",910,7},
  {{{0xa7242b16be2afca1}},6,"F-H0-4147",874,6},
  {{{0x63e1edab6be109d9}},6,"F-H0-4148",492,6},
  {{{0xa7242b16be2afca1}},6,"F-H0-4149",466,2},
  {{{0xa7242b16be2afca1}},6,"F-H0-4150",909,2},
  {{{0xeee0be793331118f}},10,"F-H0-4151",945,12},
  {{{0xeee0be793331118f}},10,"F-H0-4152",838,10},
  {{{0xf67de757c78e69a4}},10,"F-H0-4153",905,4},
  {{{0xf67de757c78e69a4}},10,"F-H0-4154",938,2},
  {{{0xf67de757c78e69a4}},10,"F-H0-4155",902,2},
  {{{0x420f3314f8db6809}},10,"F-H0-4156",861,2},
  {{{0x450707b90a4057e8}},12,"F-H0-4157",909,15},
  {{{0x5e7384ead70ec33c}},12,"F-H0-4158",459,11},
  {{{0x8d6ecd49d9e2df45}},12,"F-H0-4159",543,3},
  {{{0x4342ed2b7793aa76}},12,"F-H0-4160",466,2},
  {{{0x8e51bfcc4bd2af34}},3,"F-H0-4161",468,10},
  {{{0xade9b2987fef64c5}},3,"F-H0-4162",468,9},
  {{{0x9d35a31268faf2e4}},3,"F-H0-4163",912,8},
  {{{0x1c48b6a8dfa2de0a}},3,"F-H0-4164",949,4},
  {{{0x8e51bfcc4bd2af34}},3,"F-H0-4165",678,3},
  {{{0xb7f9493aa019d8aa}},7,"F-H0-4166",947,13},
  {{{0x2a5fa7e7c2755c0d}},7,"F-H0-4167",678,6},
  {{{0xd210e821f5220f25}},7,"F-H0-4168",495,5},
  {{{0x2a5fa7e7c2755c0d}},7,"F-H0-4169",617,4},
  {{{0x2a5fa7e7c2755c0d}},7,"F-H0-4170",902,3},
  {{{0x2a5fa7e7c2755c0d}},7,"F-H0-4171",950,2},
  {{{0xb7f9493aa019d8aa}},7,"F-H0-4172",463,2},
  {{{0x996d1e21e9f113b5}},3,"F-H0-4173",468,18},
  {{{0x9a848645fde3b245}},3,"F-H0-4174",455,9},
  {{{0x9a848645fde3b245}},3,"F-H0-4175",493,2},
  {{{0x465e23636af5da7}},3,"F-H0-4176",691,2},
  {{{0x22f25ffeda2a687b}},5,"F-H0-4177",543,19},
  {{{0x22f25ffeda2a687b}},5,"F-H0-4178",427,5},
  {{{0x3f2cb30ce27c3e3c}},5,"F-H0-4179",838,3},
  {{{0x22f25ffeda2a687b}},5,"F-H0-4180",425,2},
  {{{0xc7def1125f9ab8ab}},5,"F-H0-4181",653,2},
  {{{0x22f25ffeda2a687b}},5,"F-H0-4182",911,2},
  {{{0xe5613c4ead9427b8}},5,"F-H0-4183",427,10},
  {{{0xbc4acd7971702a2}},5,"F-H0-4184",421,6},
  {{{0xe5613c4ead9427b8}},5,"F-H0-4185",542,4},
  {{{0xbc4acd7971702a2}},5,"F-H0-4186",641,4},
  {{{0xbc4acd7971702a2}},5,"F-H0-4187",863,3},
  {{{0x8ba18c6c7ba378b9}},17,"F-H0-4188",578,19},
  {{{0xb44976ceb17d3c19}},17,"F-H0-4189",903,3},
  {{{0xb44976ceb17d3c19}},17,"F-H0-4190",908,3},
  {{{0xb44976ceb17d3c19}},17,"F-H0-4191",791,2},
  {{{0xb4971bd1bdf73a1c}},17,"F-H0-4192",790,2},
  {{{0x96456481f3ebe3d0}},3,"F-H0-4193",948,11},
  {{{0x405cd775911ba7ec}},3,"F-H0-4194",455,8},
  {{{0x7fbb8849a9cc2fc4}},3,"F-H0-4195",863,6},
  {{{0x272595b83b9f3fd2}},3,"F-H0-4196",468,6},
  {{{0x50e812c8fabf242a}},20,"F-H0-4197",529,17},
  {{{0x50e812c8fabf242a}},20,"F-H0-4198",728,10},
  {{{0x50e812c8fabf242a}},20,"F-H0-4199",691,9},
  {{{0x77a8a7df49a1b9fc}},7,"F-H0-4200",839,17},
  {{{0x6ff4d277ed99df76}},7,"F-H0-4201",543,6},
  {{{0x9bab81a80ca66ba6}},7,"F-H0-4202",462,4},
  {{{0x4d879272e0eb9019}},7,"F-H0-4203",421,2},
  {{{0x3a7a525716a9e1f5}},4,"F-H0-4204",875,17},
  {{{0xe98b2532441e9293}},4,"F-H0-4205",913,7},
  {{{0xe98b2532441e9293}},4,"F-H0-4206",420,6},
  {{{0xe98b2532441e9293}},4,"F-H0-4207",875,3},
  {{{0x3a7a525716a9e1f5}},4,"F-H0-4208",684,2},
  {{{0xe37bf0ce2fd9be8d}},15,"F-H0-4209",950,12},
  {{{0xe37bf0ce2fd9be8d}},15,"F-H0-4210",837,11},
  {{{0xe37bf0ce2fd9be8d}},15,"F-H0-4211",947,9},
  {{{0x65c7e9f9c02e30db}},5,"F-H0-4212",543,27},
  {{{0x454c01f42e36e1c}},5,"F-H0-4213",912,6},
  {{{0xd19ce75352b5f64f}},6,"F-H0-4214",690,10},
  {{{0xd19ce75352b5f64f}},6,"F-H0-4215",727,7},
  {{{0xd19ce75352b5f64f}},6,"F-H0-4216",911,7},
  {{{0xd19ce75352b5f64f}},6,"F-H0-4217",875,5},
  {{{0x4183d4974d12e5d8}},5,"F-H0-4218",616,9},
  {{{0x4183d4974d12e5d8}},5,"F-H0-4219",654,7},
  {{{0x4183d4974d12e5d8}},5,"F-H0-4220",467,5},
  {{{0x97e405e7c62a2e31}},5,"F-H0-4221",946,4},
  {{{0x4183d4974d12e5d8}},5,"F-H0-4222",579,3},
  {{{0xf6aacf171baf6592}},5,"F-H0-4223",463,3},
  {{{0x7eb31973a58365c6}},5,"F-H0-4224",939,2},
  {{{0x4183d4974d12e5d8}},5,"F-H0-4225",617,2},
  {{{0x7eb31973a58365c6}},5,"F-H0-4226",458,2},
  {{{0x927dd03ca8692b51}},7,"F-H0-4227",838,23},
  {{{0x422ea236139c84b}},7,"F-H0-4228",429,2},
  {{{0x1725b7e0a2f26a9d}},5,"F-H0-4229",424,6},
  {{{0xde73d905ad55f587}},5,"F-H0-4230",764,6},
  {{{0xde73d905ad55f587}},5,"F-H0-4231",911,6},
  {{{0xde73d905ad55f587}},5,"F-H0-4232",420,2},
  {{{0xde73d905ad55f587}},5,"F-H0-4233",802,2},
  {{{0x1725b7e0a2f26a9d}},5,"F-H0-4234",461,2},
  {{{0xd26278672adcf056}},8,"F-H0-4235",429,22},
  {{{0x651d3efccb149e14}},8,"F-H0-4236",875,2},
  {{{0xafe272f32f70ec39}},15,"F-H0-4237",904,24},
  {{{0xee72b836ddb1a414}},15,"F-H0-4238",432,10},
  {{{0x75729851700452bc}},3,"F-H0-4239",493,5},
  {{{0xa5b95fad7f57f712}},3,"F-H0-4240",902,3},
  {{{0xa5b95fad7f57f712}},3,"F-H0-4241",938,2},
  {{{0x75729851700452bc}},3,"F-H0-4242",789,2},
  {{{0x4fee1047d13b1033}},3,"F-H0-4243",938,2},
  {{{0x323091ef5d93942}},3,"F-H0-4244",456,17},
  {{{0x323091ef5d93942}},3,"F-H0-4245",455,10},
  {{{0x323091ef5d93942}},3,"F-H0-4246",492,4},
  {{{0x323091ef5d93942}},3,"F-H0-4247",493,3},
  {{{0x323091ef5d93942}},3,"F-H0-4248",949,2},
  {{{0x7b69e13b369c5d69}},6,"F-H0-4249",690,11},
  {{{0x7b69e13b369c5d69}},6,"F-H0-4250",911,10},
  {{{0x365e666843b1308d}},6,"F-H0-4251",907,8},
  {{{0x1d872a2fd5cfb69c}},8,"F-H0-4252",605,22},
  {{{0xd612f0d59640f605}},8,"F-H0-4253",936,10},
  {{{0x1d872a2fd5cfb69c}},8,"F-H0-4254",463,2},
  {{{0x41e4e3481d5291be}},5,"F-H0-4255",425,12},
  {{{0x4d5188096d7f6be2}},5,"F-H0-4256",728,8},
  {{{0x63f0d1551f7eb224}},5,"F-H0-4257",543,5},
  {{{0x4d5188096d7f6be2}},5,"F-H0-4258",943,3},
  {{{0x4d5188096d7f6be2}},5,"F-H0-4259",690,3},
  {{{0x4d5188096d7f6be2}},5,"F-H0-4260",461,2},
  {{{0xbae646684db2fb85}},7,"F-H0-4261",505,21},
  {{{0xbae646684db2fb85}},7,"F-H0-4262",541,10},
  {{{0x64cbec102158754}},2,"F-H0-4263",911,6},
  {{{0x64cbec102158754}},2,"F-H0-4264",875,6},
  {{{0x64cbec102158754}},2,"F-H0-4265",876,4},
  {{{0xa5bb716d3963897}},2,"F-H0-4266",505,3},
  {{{0x9ea6ae2778b49217}},2,"F-H0-4267",457,2},
  {{{0x9ea6ae2778b49217}},2,"F-H0-4268",468,2},
  {{{0x64cbec102158754}},2,"F-H0-4269",430,2},
  {{{0x64cbec102158754}},2,"F-H0-4270",913,2},
  {{{0xe7373c1d6fbc096b}},5,"F-H0-4271",975,2},
  {{{0xa97b9af28dc2ac92}},2,"F-H0-4272",902,12},
  {{{0x41bd90ca8916a30c}},2,"F-H0-4273",939,3},
  {{{0x41bd90ca8916a30c}},2,"F-H0-4274",456,2},
  {{{0x41bd90ca8916a30c}},2,"F-H0-4275",912,2},
  {{{0x3f75f8323289cdc7}},2,"F-H0-4276",913,11},
  {{{0xf1af8b813471b42d}},2,"F-H0-4277",469,5},
  {{{0xaa7e2d24d6ee323a}},2,"F-H0-4278",912,5},
  {{{0xad22edccad5fd028}},2,"F-H0-4279",468,4},
  {{{0xad22edccad5fd028}},2,"F-H0-4280",431,3},
  {{{0xad22edccad5fd028}},2,"F-H0-4281",469,3},
  {{{0xb0e759be114cafbc}},8,"F-H0-4282",431,32},
  {{{0xe1b00cfa3b730a1f}},6,"F-H0-4283",429,13},
  {{{0x4990114afc71b5ab}},7,"F-H0-4284",827,16},
  {{{0x4990114afc71b5ab}},7,"F-H0-4285",936,10},
  {{{0x1a99699b829c18d9}},7,"F-H0-4286",947,7},
  {{{0x4990114afc71b5ab}},7,"F-H0-4287",753,2},
  {{{0xea93dde623d2c4ce}},5,"F-H0-4288",431,19},
  {{{0xea93dde623d2c4ce}},5,"F-H0-4289",467,3},
  {{{0xc3ff017649348045}},9,"F-H0-4290",467,26},
  {{{0x3a1fbc57bb8f2415}},9,"F-H0-4291",973,4},
  {{{0x7145c1462ccbb195}},9,"F-H0-4292",912,31},
  {{{0x46fb69953650393f}},4,"F-H0-4293",456,14},
  {{{0xb04d881027b6d5e}},4,"F-H0-4294",949,5},
  {{{0xb04d881027b6d5e}},4,"F-H0-4295",464,4},
  {{{0x40ccfe406f23b78a}},4,"F-H0-4296",901,3},
  {{{0x46fb69953650393f}},4,"F-H0-4297",838,2},
  {{{0x8aed2521430e2ad9}},5,"F-H0-4298",616,10},
  {{{0xcd653be94177e63e}},5,"F-H0-4299",492,9},
  {{{0xffe30114670fe7f6}},5,"F-H0-4300",428,6},
  {{{0xffe30114670fe7f6}},5,"F-H0-4301",465,2},
  {{{0x8aed2521430e2ad9}},5,"F-H0-4302",466,2},
  {{{0x87d530f4a6bd3ef5}},6,"F-H0-4303",865,16},
  {{{0x87d530f4a6bd3ef5}},6,"F-H0-4304",936,9},
  {{{0x761ad2aa397862a3}},6,"F-H0-4305",947,4},
  {{{0x9fbc7c935a2276b9}},6,"F-H0-4306",458,3},
  {{{0x2c32eeb22423a953}},9,"F-H0-4307",837,9},
  {{{0xbbfaf19f4527da6b}},9,"F-H0-4308",505,4},
  {{{0xe630bafc6b95daf7}},6,"F-H0-4309",425,9},
  {{{0xa9feae46427a57be}},6,"F-H0-4310",906,2},
  {{{0xa23ed602dcf643ca}},6,"F-H0-4311",839,2},
  {{{0xccb628bf55ae4bd5}},3,"F-H0-4312",468,12},
  {{{0xf4dd58f344778330}},3,"F-H0-4313",469,5},
  {{{0xf4dd58f344778330}},3,"F-H0-4314",432,2},
  {{{0x8d9be8ff94f12c71}},15,"F-H0-4315",839,19},
  {{{0xf3d9828c774b958a}},15,"F-H0-4316",945,6},
  {{{0xe58c407e9dc41667}},15,"F-H0-4317",939,3},
  {{{0x8d9be8ff94f12c71}},15,"F-H0-4318",690,3},
  {{{0x6a23607a5c44fd82}},9,"F-H0-4319",469,33},
  {{{0xcbaf9ea85b3e66d0}},5,"F-H0-4320",827,11},
  {{{0xf15cfbaf0b462178}},5,"F-H0-4321",903,8},
  {{{0x66b5c3ae511cebbe}},5,"F-H0-4322",948,5},
  {{{0xd11fe02a0c36674e}},5,"F-H0-4323",912,2},
  {{{0x66b5c3ae511cebbe}},5,"F-H0-4324",910,2},
  {{{0xb0bf727aa71af170}},8,"F-H0-4325",418,15},
  {{{0xe05edb62125b4e56}},8,"F-H0-4326",865,6},
  {{{0x79b29d85237817b4}},8,"F-H0-4327",460,2},
  {{{0xcd8b5d7d4774ae4a}},5,"F-H0-4328",529,16},
  {{{0xcd8b5d7d4774ae4a}},5,"F-H0-4329",461,7},
  {{{0xcd8b5d7d4774ae4a}},5,"F-H0-4330",423,6},
  {{{0xcd8b5d7d4774ae4a}},5,"F-H0-4331",530,3},
  {{{0xcd8b5d7d4774ae4a}},5,"F-H0-4332",911,2},
  {{{0xcd8b5d7d4774ae4a}},5,"F-H0-4333",566,2},
  {{{0x4048be213342331f}},8,"F-H0-4334",911,23},
  {{{0xa6899df492d0b81c}},10,"F-H0-4335",393,32},
  {{{0x3dc0566d86a04315}},4,"F-H0-4336",939,5},
  {{{0x3dc0566d86a04315}},4,"F-H0-4337",902,4},
  {{{0x3dc0566d86a04315}},4,"F-H0-4338",468,4},
  {{{0xc6615939c2c2c19f}},4,"F-H0-4339",678,2},
  {{{0x594e3e63697e519}},4,"F-H0-4340",941,2},
  {{{0x594e3e63697e519}},4,"F-H0-4341",905,2},
  {{{0x55d5ffa75e55d823}},2,"F-H0-4342",912,20},
  {{{0xf774a25cd4833282}},2,"F-H0-4343",912,5},
  {{{0x55d5ffa75e55d823}},2,"F-H0-4344",468,2},
  {{{0x55d5ffa75e55d823}},2,"F-H0-4345",906,2},
  {{{0x496616b00ede9776}},7,"F-H0-4346",939,28},
  {{{0x496616b00ede9776}},7,"F-H0-4347",940,5},
  {{{0x8fa243bd95da221d}},10,"F-H0-4348",838,15},
  {{{0x15548457a3b02c6f}},10,"F-H0-4349",495,7},
  {{{0x8fa243bd95da221d}},10,"F-H0-4350",876,3},
  {{{0xdee02a5d8ddbcc26}},6,"F-H0-4351",948,24},
  {{{0xdee02a5d8ddbcc26}},6,"F-H0-4352",839,6},
  {{{0xdee02a5d8ddbcc26}},6,"F-H0-4353",429,2},
  {{{0x2fa441f3b8bc9c84}},6,"F-H0-4354",690,8},
  {{{0x2fa441f3b8bc9c84}},6,"F-H0-4355",470,7},
  {{{0x2fa441f3b8bc9c84}},6,"F-H0-4356",653,5},
  {{{0x2fa441f3b8bc9c84}},6,"F-H0-4357",691,4},
  {{{0x2fa441f3b8bc9c84}},6,"F-H0-4358",654,2},
  {{{0xc6b9904ec5d43f8b}},8,"F-H0-4359",395,34},
  {{{0x52203500b964caf2}},7,"F-H0-4360",801,27},
  {{{0x84e3cd3afb08b651}},4,"F-H0-4361",876,11},
  {{{0xf8b72e0499be64ad}},4,"F-H0-4362",529,6},
  {{{0x2490f0e57980ad27}},8,"F-H0-4363",939,12},
  {{{0x2490f0e57980ad27}},8,"F-H0-4364",902,10},
  {{{0x2490f0e57980ad27}},8,"F-H0-4365",751,5},
  {{{0x2490f0e57980ad27}},8,"F-H0-4366",715,2},
  {{{0x52762eb0ebf64539}},14,"F-H0-4367",540,25},
  {{{0xe8d0ccf300130b61}},14,"F-H0-4368",382,3},
  {{{0xe8d0ccf300130b61}},14,"F-H0-4369",421,3},
  {{{0x5fcbcd4e34537179}},14,"F-H0-4370",789,2},
  {{{0xd50992a83fbe58fb}},12,"F-H0-4371",502,32},
  {{{0xa2a5257b90ba9c14}},12,"F-H0-4372",458,2},
  {{{0x485c216530b9bc40}},10,"F-H0-4373",871,4},
  {{{0xd787c554e8f02c91}},10,"F-H0-4374",495,2},
  {{{0x180dc81efb9a3faf}},13,"F-H0-4375",867,31},
  {{{0x3c8d94d1e020d23e}},16,"F-H0-4376",802,13},
  {{{0x3c8d94d1e020d23e}},16,"F-H0-4377",908,9},
  {{{0x3c8d94d1e020d23e}},16,"F-H0-4378",946,4},
  {{{0x3c8d94d1e020d23e}},16,"F-H0-4379",875,3},
  {{{0x3c8d94d1e020d23e}},16,"F-H0-4380",838,3},
  {{{0x3c8d94d1e020d23e}},16,"F-H0-4381",944,2},
  {{{0xb943ce330efd4835}},5,"F-H0-4382",825,12},
  {{{0xe9393c7f7ba880ba}},5,"F-H0-4383",825,6},
  {{{0xb943ce330efd4835}},5,"F-H0-4384",690,3},
  {{{0xb943ce330efd4835}},5,"F-H0-4385",419,2},
  {{{0xa71f14c382fb25d5}},9,"F-H0-4386",567,18},
  {{{0x9293c1d706a19d96}},9,"F-H0-4387",458,11},
  {{{0xd2877c290d2f72f3}},9,"F-H0-4388",974,6},
  {{{0x2ed0582d3445bbc6}},4,"F-H0-4389",948,11},
  {{{0x68304754332ef07c}},4,"F-H0-4390",493,8},
  {{{0xc41a0aa047722756}},4,"F-H0-4391",506,5},
  {{{0xc41a0aa047722756}},4,"F-H0-4392",863,2},
  {{{0xa483642a568d34af}},6,"F-H0-4393",837,17},
  {{{0xa483642a568d34af}},6,"F-H0-4394",950,10},
  {{{0xfa8614203597f08e}},6,"F-H0-4395",985,5},
  {{{0xfc99b1c4b9cc4408}},3,"F-H0-4396",504,10},
  {{{0x3a9671c945da77ed}},3,"F-H0-4397",466,3},
  {{{0xcdf61fee2598c5e6}},3,"F-H0-4398",457,3},
  {{{0xfc99b1c4b9cc4408}},3,"F-H0-4399",469,2},
  {{{0xcdf61fee2598c5e6}},3,"F-H0-4400",458,2},
  {{{0xcdf61fee2598c5e6}},3,"F-H0-4401",456,2},
  {{{0xe56549e5995e4091}},6,"F-H0-4402",418,15},
  {{{0x3d9099daa2fcdcaf}},6,"F-H0-4403",865,11},
  {{{0x1f20b4da64c58501}},6,"F-H0-4404",839,3},
  {{{0x735c3b137fba5c6a}},8,"F-H0-4405",455,29},
  {{{0xce6bcb807543bb9e}},8,"F-H0-4406",948,18},
  {{{0xce6bcb807543bb9e}},8,"F-H0-4407",838,4},
  {{{0xce6bcb807543bb9e}},8,"F-H0-4408",949,4},
  {{{0xce6bcb807543bb9e}},8,"F-H0-4409",945,4},
  {{{0x2a9deac3d8d4ac65}},8,"F-H0-4410",494,3},
  {{{0xce6bcb807543bb9e}},8,"F-H0-4411",907,2},
  {{{0xce6bcb807543bb9e}},8,"F-H0-4412",873,2},
  {{{0x8eb26ab3b5a99873}},6,"F-H0-4413",678,13},
  {{{0xbc7b8b3c6e8db0d8}},6,"F-H0-4414",801,5},
  {{{0x8eb26ab3b5a99873}},6,"F-H0-4415",543,5},
  {{{0x18191b448e7009c4}},6,"F-H0-4416",906,3},
  {{{0x8eb26ab3b5a99873}},6,"F-H0-4417",684,2},
  {{{0x9772c9553874f01b}},10,"F-H0-4418",690,26},
  {{{0x9772c9553874f01b}},10,"F-H0-4419",691,6},
  {{{0xf6e92f1c0b705065}},10,"F-H0-4420",461,3},
  {{{0x71d5fe8189d87ee5}},12,"F-H0-4421",615,28},
  {{{0x695664b01747e35b}},5,"F-H0-4422",420,7},
  {{{0xa08c7224bae65184}},5,"F-H0-4423",908,7},
  {{{0x695664b01747e35b}},5,"F-H0-4424",530,3},
  {{{0x695664b01747e35b}},5,"F-H0-4425",494,3},
  {{{0x94b0b9836c62a5b4}},5,"F-H0-4426",492,3},
  {{{0x94b0b9836c62a5b4}},5,"F-H0-4427",802,3},
  {{{0x695664b01747e35b}},5,"F-H0-4428",430,2},
  {{{0x2f084ea7e7f86393}},5,"F-H0-4429",943,24},
  {{{0x2f084ea7e7f86393}},5,"F-H0-4430",825,4},
  {{{0x3ffb9f979b9337e0}},5,"F-H0-4431",654,4},
  {{{0x6f9a069e0236dc51}},5,"F-H0-4432",906,2},
  {{{0x13d5135c2ac548ed}},8,"F-H0-4433",862,19},
  {{{0xca56c8346f86b44c}},8,"F-H0-4434",802,8},
  {{{0xf97743a0000d526f}},8,"F-H0-4435",503,35},
  {{{0x63cfc9fd7c673a21}},11,"F-H0-4436",617,25},
  {{{0x682099e9731e73a8}},11,"F-H0-4437",728,6},
  {{{0xc32ea88e028409cd}},5,"F-H0-4438",431,28},
  {{{0x537882fcdfb00fb2}},8,"F-H0-4439",908,14},
  {{{0x537882fcdfb00fb2}},8,"F-H0-4440",874,10},
  {{{0x537882fcdfb00fb2}},8,"F-H0-4441",948,3},
  {{{0x537882fcdfb00fb2}},8,"F-H0-4442",909,3},
  {{{0x537882fcdfb00fb2}},8,"F-H0-4443",838,2},
  {{{0xfd9e12ba22479ab0}},4,"F-H0-4444",913,12},
  {{{0x3da4767837b8dd37}},4,"F-H0-4445",678,10},
  {{{0x3856f4eac1189305}},4,"F-H0-4446",493,5},
  {{{0x3856f4eac1189305}},4,"F-H0-4447",678,2},
  {{{0xfd3af0c94f34a37d}},3,"F-H0-4448",909,9},
  {{{0xd0f0625a541270e9}},3,"F-H0-4449",901,2},
  {{{0x608904eb9f4e55a9}},4,"F-H0-4450",455,13},
  {{{0x608904eb9f4e55a9}},4,"F-H0-4451",543,13},
  {{{0x608904eb9f4e55a9}},4,"F-H0-4452",944,2},
  {{{0x608904eb9f4e55a9}},4,"F-H0-4453",948,2},
  {{{0x608904eb9f4e55a9}},4,"F-H0-4454",907,2},
  {{{0x94da7dd192676bd5}},4,"F-H0-4455",913,10},
  {{{0x276404601a78d33b}},4,"F-H0-4456",839,9},
  {{{0x276404601a78d33b}},4,"F-H0-4457",947,6},
  {{{0x6ff189901fa51db8}},4,"F-H0-4458",425,2},
  {{{0x1ebaf2215b2886f1}},8,"F-H0-4459",800,7},
  {{{0x4c008c7990ac4b54}},8,"F-H0-4460",503,4},
  {{{0x2cafcf8350a80b6d}},9,"F-H0-4461",943,7},
  {{{0x4a04e51e866c48ed}},9,"F-H0-4462",690,6},
  {{{0x2cafcf8350a80b6d}},9,"F-H0-4463",939,3},
  {{{0x4a04e51e866c48ed}},9,"F-H0-4464",838,2},
  {{{0xc7b0177e9c30bc8f}},6,"F-H0-4465",690,17},
  {{{0xc7b0177e9c30bc8f}},6,"F-H0-4466",543,7},
  {{{0xc7b0177e9c30bc8f}},6,"F-H0-4467",678,3},
  {{{0xc7b0177e9c30bc8f}},6,"F-H0-4468",529,2},
  {{{0xcda01a5922587669}},4,"F-H0-4469",911,9},
  {{{0xcb25cfeeb95bdc5e}},4,"F-H0-4470",543,8},
  {{{0xcda01a5922587669}},4,"F-H0-4471",420,8},
  {{{0x76050d517749abeb}},4,"F-H0-4472",825,3},
  {{{0x76050d517749abeb}},4,"F-H0-4473",506,2},
  {{{0x36ee671a69c40e9a}},7,"F-H0-4474",911,13},
  {{{0x36ee671a69c40e9a}},7,"F-H0-4475",874,7},
  {{{0x36ee671a69c40e9a}},7,"F-H0-4476",912,7},
  {{{0xd997219b05984f05}},4,"F-H0-4477",455,10},
  {{{0x51d42b9ea8c2eacd}},4,"F-H0-4478",456,8},
  {{{0x51d42b9ea8c2eacd}},4,"F-H0-4479",455,4},
  {{{0x51d42b9ea8c2eacd}},4,"F-H0-4480",876,4},
  {{{0x51d42b9ea8c2eacd}},4,"F-H0-4481",910,3},
  {{{0x51d42b9ea8c2eacd}},4,"F-H0-4482",909,2},
  {{{0x51d42b9ea8c2eacd}},4,"F-H0-4483",765,2},
  {{{0xc8bce3196d976764}},12,"F-H0-4484",502,30},
  {{{0x4f99e889ee819a4b}},6,"F-H0-4485",429,13},
  {{{0x4f99e889ee819a4b}},6,"F-H0-4486",802,10},
  {{{0x4f99e889ee819a4b}},6,"F-H0-4487",764,8},
  {{{0xa292fb2cf8f7a606}},6,"F-H0-4488",941,2},
  {{{0xf956b95d9f106d9d}},12,"F-H0-4489",908,9},
  {{{0xf956b95d9f106d9d}},12,"F-H0-4490",946,5},
  {{{0xf956b95d9f106d9d}},12,"F-H0-4491",948,5},
  {{{0xf956b95d9f106d9d}},12,"F-H0-4492",838,4},
  {{{0xf956b95d9f106d9d}},12,"F-H0-4493",874,4},
  {{{0x4cf2063ab1f71235}},7,"F-H0-4494",542,12},
  {{{0x4cf2063ab1f71235}},7,"F-H0-4495",728,7},
  {{{0x4cf2063ab1f71235}},7,"F-H0-4496",943,6},
  {{{0x4cf2063ab1f71235}},7,"F-H0-4497",506,4},
  {{{0x4cf2063ab1f71235}},7,"F-H0-4498",466,2},
  {{{0xad5321091042a161}},17,"F-H0-4499",690,9},
  {{{0xc21295a42cd06879}},17,"F-H0-4500",825,8},
  {{{0x34908a0d4a43d5c3}},17,"F-H0-4501",424,7},
  {{{0xc21295a42cd06879}},17,"F-H0-4502",677,5},
  {{{0x96cc204eaf36d17e}},7,"F-H0-4503",678,4},
  {{{0xe97ded7b01ab41f1}},7,"F-H0-4504",912,3},
  {{{0x4542d5e675277652}},7,"F-H0-4505",948,2},
  {{{0x96cc204eaf36d17e}},7,"F-H0-4506",640,2},
  {{{0x4542d5e675277652}},7,"F-H0-4507",751,2},
  {{{0x96cc204eaf36d17e}},7,"F-H0-4508",677,2},
  {{{0xa8b64b9b2872847f}},2,"F-H0-4509",902,11},
  {{{0xa8b64b9b2872847f}},2,"F-H0-4510",938,5},
  {{{0xa8b64b9b2872847f}},2,"F-H0-4511",903,2},
  {{{0x6fd4d747f9a2985b}},8,"F-H0-4512",911,20},
  {{{0x6fd4d747f9a2985b}},8,"F-H0-4513",949,8},
  {{{0xc16c1cf768f5ed45}},8,"F-H0-4514",429,2},
  {{{0x6fd4d747f9a2985b}},8,"F-H0-4515",907,2},
  {{{0xbba29f3421e3d402}},10,"F-H0-4516",825,29},
  {{{0xad9eb79143336e81}},6,"F-H0-4517",495,8},
  {{{0x9d7c3987690aad0a}},6,"F-H0-4518",460,4},
  {{{0xd76f98be6557448e}},6,"F-H0-4519",936,3},
  {{{0x63361210f5d65c63}},6,"F-H0-4520",429,3},
  {{{0x63361210f5d65c63}},6,"F-H0-4521",466,2},
  {{{0x8fde1c59f3b28572}},7,"F-H0-4522",945,7},
  {{{0x171f6798a53c412}},7,"F-H0-4523",458,6},
  {{{0x171f6798a53c412}},7,"F-H0-4524",690,5},
  {{{0x8fde1c59f3b28572}},7,"F-H0-4525",907,4},
  {{{0xcf251a98cede6ae1}},7,"F-H0-4526",939,3},
  {{{0x1b3e36edfbc22fd7}},7,"F-H0-4527",838,2},
  {{{0x44e6c05d1a52b801}},7,"F-H0-4528",690,2},
  {{{0x4175c1c1bdd581b4}},8,"F-H0-4529",690,15},
  {{{0x433e9288c7b30690}},8,"F-H0-4530",947,6},
  {{{0x4175c1c1bdd581b4}},8,"F-H0-4531",421,4},
  {{{0x21ad2aeb7a86d470}},8,"F-H0-4532",875,2},
  {{{0x4c7708e48d2fc628}},8,"F-H0-4533",907,10},
  {{{0x4c7708e48d2fc628}},8,"F-H0-4534",986,5},
  {{{0xeb0d255a2f6d3c45}},8,"F-H0-4535",791,3},
  {{{0xd1ca29d73936badd}},7,"F-H0-4536",542,17},
  {{{0x88020cf52ba62e89}},7,"F-H0-4537",751,4},
  {{{0xe62ae4dda565e9b4}},7,"F-H0-4538",905,3},
  {{{0x6a9b125371a9ef89}},7,"F-H0-4539",529,2},
  {{{0xd1ca29d73936badd}},7,"F-H0-4540",466,2},
  {{{0x3d12fa89a1c0e1e2}},12,"F-H0-4541",904,21},
  {{{0x5156ee812de12a6d}},12,"F-H0-4542",691,2},
  {{{0xed128af85cd754f5}},9,"F-H0-4543",950,12},
  {{{0x4e6c538be5b4b039}},9,"F-H0-4544",865,5},
  {{{0xed128af85cd754f5}},9,"F-H0-4545",908,3},
  {{{0xed128af85cd754f5}},9,"F-H0-4546",839,2},
  {{{0x13f2ef3b352dee22}},4,"F-H0-4547",948,5},
  {{{0x13f2ef3b352dee22}},4,"F-H0-4548",419,3},
  {{{0x13f2ef3b352dee22}},4,"F-H0-4549",949,2},
  {{{0x13f2ef3b352dee22}},4,"F-H0-4550",456,2},
  {{{0x2b3af431df482eff}},6,"F-H0-4551",421,26},
  {{{0x2b3af431df482eff}},6,"F-H0-4552",456,4},
  {{{0x78ff4417cd429db0}},6,"F-H0-4553",902,10},
  {{{0x4fe826b597165a9a}},6,"F-H0-4554",947,6},
  {{{0x78ff4417cd429db0}},6,"F-H0-4555",939,4},
  {{{0xcb5a58e255d59ac4}},6,"F-H0-4556",423,4},
  {{{0x1c8b1c548e620c9a}},4,"F-H0-4557",543,10},
  {{{0x1220f348abced349}},4,"F-H0-4558",947,7},
  {{{0x1c8b1c548e620c9a}},4,"F-H0-4559",425,3},
  {{{0x236ab047dfeeff36}},4,"F-H0-4560",466,2},
  {{{0x4e86b2b3bcd6b366}},8,"F-H0-4561",684,21},
  {{{0xb87facfd1372dcec}},8,"F-H0-4562",543,7},
  {{{0xb87facfd1372dcec}},8,"F-H0-4563",542,3},
  {{{0xb4e4d8e9df68741a}},6,"F-H0-4564",495,15},
  {{{0x5a3d78350515bdf1}},6,"F-H0-4565",936,12},
  {{{0xb06f7b57de8ad3df}},6,"F-H0-4566",861,4},
  {{{0x4fa55c3259dc1b17}},11,"F-H0-4567",690,22},
  {{{0x702a96b9b515c330}},6,"F-H0-4568",908,9},
  {{{0xe60230662fb0d90c}},6,"F-H0-4569",862,8},
  {{{0x702a96b9b515c330}},6,"F-H0-4570",946,4},
  {{{0xebda577c97960fd5}},6,"F-H0-4571",826,2},
  {{{0x7425d976be866dc2}},9,"F-H0-4572",541,32},
  {{{0x279b2f5ca3a9c24e}},13,"F-H0-4573",906,29},
  {{{0x30441eba56da266b}},7,"F-H0-4574",825,13},
  {{{0x7f0402ac888b31c0}},7,"F-H0-4575",678,4},
  {{{0x30441eba56da266b}},7,"F-H0-4576",684,3},
  {{{0x30441eba56da266b}},7,"F-H0-4577",617,2},
  {{{0xc6bd00f4f97e49e1}},7,"F-H0-4578",566,2},
  {{{0xbcf2b60b90411d7f}},8,"F-H0-4579",950,9},
  {{{0x26542a53ae1f03cc}},8,"F-H0-4580",865,5},
  {{{0xeecb7351bae37df8}},10,"F-H0-4581",468,31},
  {{{0x7507d4ea163de7df}},10,"F-H0-4582",418,4},
  {{{0x3c671aadfd04f89b}},8,"F-H0-4583",944,8},
  {{{0x3c671aadfd04f89b}},8,"F-H0-4584",907,8},
  {{{0x3c671aadfd04f89b}},8,"F-H0-4585",940,5},
  {{{0x3c671aadfd04f89b}},8,"F-H0-4586",945,4},
  {{{0x3c671aadfd04f89b}},8,"F-H0-4587",939,3},
  {{{0x3df2c0e4af7d576c}},8,"F-H0-4588",945,2},
  {{{0x99367ca61f588b58}},13,"F-H0-4589",462,12},
  {{{0x472577150414e6de}},13,"F-H0-4590",947,11},
  {{{0x1723e61671fd2564}},13,"F-H0-4591",947,12},
  {{{0x542c342ce6e87448}},13,"F-H0-4592",678,9},
  {{{0x542c342ce6e87448}},13,"F-H0-4593",715,5},
  {{{0xcf267b4d85c59d9b}},13,"F-H0-4594",907,2},
  {{{0x98b8464b50603c66}},5,"F-H0-4595",460,12},
  {{{0x98b8464b50603c66}},5,"F-H0-4596",420,10},
  {{{0x98b8464b50603c66}},5,"F-H0-4597",422,3},
  {{{0x98b8464b50603c66}},5,"F-H0-4598",530,3},
  {{{0xb174cce4af55286c}},6,"F-H0-4599",948,16},
  {{{0x954b8d3d9615d54}},6,"F-H0-4600",529,4},
  {{{0xbe4243f552971a21}},6,"F-H0-4601",529,4},
  {{{0x2b523499707430ef}},8,"F-H0-4602",908,12},
  {{{0x2b523499707430ef}},8,"F-H0-4603",874,4},
  {{{0x9208223743abd558}},8,"F-H0-4604",801,4},
  {{{0x2b523499707430ef}},8,"F-H0-4605",838,3},
  {{{0xad9c44e598bef19b}},8,"F-H0-4606",492,3},
  {{{0xddb06ee2560867ad}},6,"F-H0-4607",430,30},
  {{{0x9e5612edf86420fe}},9,"F-H0-4608",942,14},
  {{{0x863cf32a6714cd31}},9,"F-H0-4609",616,10},
  {{{0x9e5612edf86420fe}},9,"F-H0-4610",938,4},
  {{{0x911d6d16ccbdc8fc}},6,"F-H0-4611",426,12},
  {{{0xe990a49cada6710f}},6,"F-H0-4612",454,7},
  {{{0xe990a49cada6710f}},6,"F-H0-4613",678,3},
  {{{0x3126e4b4f1570132}},6,"F-H0-4614",421,2},
  {{{0x796be627d0accbd4}},1,"F-H0-4615",912,15},
  {{{0x251cb1de1eb2d6e2}},1,"F-H0-4616",900,5},
  {{{0x796be627d0accbd4}},1,"F-H0-4617",721,3},
  {{{0xdbcabbdc5a7a2175}},1,"F-H0-4618",419,2},
  {{{0xd1d6a54c7019fe6b}},6,"F-H0-4619",876,15},
  {{{0x23da3224d8fed506}},6,"F-H0-4620",939,10},
  {{{0xf66b22926d874a4b}},6,"F-H0-4621",493,2},
  {{{0xd1d6a54c7019fe6b}},6,"F-H0-4622",543,2},
  {{{0x20aa8a00dfaccf6}},7,"F-H0-4623",395,24},
  {{{0xb47f03084e312907}},5,"F-H0-4624",506,7},
  {{{0xa3f7b7ccc167425e}},5,"F-H0-4625",875,6},
  {{{0xa3f7b7ccc167425e}},5,"F-H0-4626",464,5},
  {{{0xa3f7b7ccc167425e}},5,"F-H0-4627",504,3},
  {{{0xa3f7b7ccc167425e}},5,"F-H0-4628",876,3},
  {{{0xb47f03084e312907}},5,"F-H0-4629",466,2},
  {{{0xa3f7b7ccc167425e}},5,"F-H0-4630",465,2},
  {{{0xa3f7b7ccc167425e}},5,"F-H0-4631",428,2},
  {{{0x1c2f15a45b259ccc}},11,"F-H0-4632",826,21},
  {{{0x9778dbbddc0a11a1}},11,"F-H0-4633",976,4},
  {{{0xbc0b583dd2f5d04d}},5,"F-H0-4634",493,7},
  {{{0xbc0b583dd2f5d04d}},5,"F-H0-4635",492,5},
  {{{0xbc0b583dd2f5d04d}},5,"F-H0-4636",530,5},
  {{{0xbc0b583dd2f5d04d}},5,"F-H0-4637",911,5},
  {{{0xbc0b583dd2f5d04d}},5,"F-H0-4638",910,4},
  {{{0xbc0b583dd2f5d04d}},5,"F-H0-4639",945,3},
  {{{0xbc0b583dd2f5d04d}},5,"F-H0-4640",529,2},
  {{{0x35ff54cd84ced6f6}},7,"F-H0-4641",504,10},
  {{{0x35ff54cd84ced6f6}},7,"F-H0-4642",505,9},
  {{{0x35ff54cd84ced6f6}},7,"F-H0-4643",393,3},
  {{{0xf85ca601447811f1}},11,"F-H0-4644",800,6},
  {{{0x3ee097f32b07446f}},11,"F-H0-4645",384,2},
  {{{0x3ee097f32b07446f}},11,"F-H0-4646",532,2},
  {{{0x8867487b6fae2e8f}},5,"F-H0-4647",911,15},
  {{{0x8867487b6fae2e8f}},5,"F-H0-4648",948,11},
  {{{0x8867487b6fae2e8f}},5,"F-H0-4649",901,2},
  {{{0xfaf950791ceff7d6}},6,"F-H0-4650",912,7},
  {{{0x7e434bb11141380}},6,"F-H0-4651",456,6},
  {{{0x7e434bb11141380}},6,"F-H0-4652",419,3},
  {{{0xf433e8d3f997d579}},6,"F-H0-4653",906,2},
  {{{0xd2351045c8da307c}},4,"F-H0-4654",421,9},
  {{{0x3ea0f2a9d21f75c4}},4,"F-H0-4655",751,6},
  {{{0x3ea0f2a9d21f75c4}},4,"F-H0-4656",902,3},
  {{{0xdf358eb1dbb1f0c5}},4,"F-H0-4657",456,3},
  {{{0xdf358eb1dbb1f0c5}},4,"F-H0-4658",902,2},
  {{{0x3ea0f2a9d21f75c4}},4,"F-H0-4659",913,2},
  {{{0x90ed58460e0e1c43}},13,"F-H0-4660",865,3},
  {{{0x56f27b8703b471f0}},5,"F-H0-4661",466,11},
  {{{0x56f27b8703b471f0}},5,"F-H0-4662",911,8},
  {{{0x56f27b8703b471f0}},5,"F-H0-4663",654,2},
  {{{0x56f27b8703b471f0}},5,"F-H0-4664",948,2},
  {{{0xf91d5430cc5f8884}},5,"F-H0-4665",567,2},
  {{{0x6aeee08824ed2da7}},15,"F-H0-4666",940,2},
  {{{0xf6680f34e455afd5}},6,"F-H0-4667",873,13},
  {{{0x706c67cf78ea3e89}},6,"F-H0-4668",910,4},
  {{{0x60741d1372de72f2}},7,"F-H0-4669",837,15},
  {{{0x80ab218a58c5b292}},7,"F-H0-4670",936,12},
  {{{0x10f5d59b55485e87}},7,"F-H0-4671",985,2},
  {{{0x5c73328c6f5de1ab}},4,"F-H0-4672",420,15},
  {{{0x7c42657540020b2b}},4,"F-H0-4673",875,11},
  {{{0x90824bdd61965e8c}},4,"F-H0-4674",911,3},
  {{{0xf9d26209e59963ff}},9,"F-H0-4675",839,26},
  {{{0xd6e65fe8f635be83}},9,"F-H0-4676",493,3},
  {{{0x2aa85003ad3698f0}},5,"F-H0-4677",950,18},
  {{{0x1df67132488922cf}},5,"F-H0-4678",419,2},
  {{{0x6e8254432fa9144e}},13,"F-H0-4679",506,26},
  {{{0x9914a6643fe2950a}},12,"F-H0-4680",433,27},
  {{{0x4c7f550be98d682c}},7,"F-H0-4681",394,21},
  {{{0xa4fea927a46a39c1}},7,"F-H0-4682",456,6},
  {{{0xb2464faf2b1c0272}},5,"F-H0-4683",466,13},
  {{{0xa4c1fe874f1691e8}},5,"F-H0-4684",505,5},
  {{{0xb2464faf2b1c0272}},5,"F-H0-4685",421,4},
  {{{0xa4c1fe874f1691e8}},5,"F-H0-4686",825,3},
  {{{0xa4c1fe874f1691e8}},5,"F-H0-4687",579,2},
  {{{0xc1cfb4f040d20881}},15,"F-H0-4688",901,11},
  {{{0x74901b49e3898790}},15,"F-H0-4689",728,3},
  {{{0x74901b49e3898790}},15,"F-H0-4690",948,3},
  {{{0x74901b49e3898790}},15,"F-H0-4691",825,2},
  {{{0x74901b49e3898790}},15,"F-H0-4692",839,2},
  {{{0x74901b49e3898790}},15,"F-H0-4693",502,2},
  {{{0x4ef9e24352c20772}},8,"F-H0-4694",469,12},
  {{{0x1d7260db9c581194}},6,"F-H0-4695",945,12},
  {{{0x583a726d8a753f2b}},6,"F-H0-4696",467,8},
  {{{0x1d7260db9c581194}},6,"F-H0-4697",467,4},
  {{{0x1d7260db9c581194}},6,"F-H0-4698",940,2},
  {{{0x32c9ed5a958821cc}},7,"F-H0-4699",469,26},
  {{{0x9c488f861c447dc2}},7,"F-H0-4700",469,5},
  {{{0xceedb4fe88cd98be}},14,"F-H0-4701",429,27},
  {{{0x6c4b99ae688268d3}},6,"F-H0-4702",690,11},
  {{{0x6c4b99ae688268d3}},6,"F-H0-4703",543,6},
  {{{0x6c4b99ae688268d3}},6,"F-H0-4704",457,3},
  {{{0xcec676b022967b23}},6,"F-H0-4705",616,2},
  {{{0x93128e1057baff71}},6,"F-H0-4706",430,2},
  {{{0x41eb59315dcbaff8}},6,"F-H0-4707",653,18},
  {{{0x41eb59315dcbaff8}},6,"F-H0-4708",690,8},
  {{{0xe7230e2bededea3f}},6,"F-H0-4709",529,32},
  {{{0x4a725ced761727d6}},5,"F-H0-4710",825,11},
  {{{0xe9a8ceadcd6fc755}},5,"F-H0-4711",431,4},
  {{{0x4a725ced761727d6}},5,"F-H0-4712",690,3},
  {{{0x4a725ced761727d6}},5,"F-H0-4713",801,3},
  {{{0x4a725ced761727d6}},5,"F-H0-4714",727,2},
  {{{0xb25a41785cfbf187}},5,"F-H0-4715",943,2},
  {{{0xcfb62412effdc5c4}},13,"F-H0-4716",913,24},
  {{{0xcfb62412effdc5c4}},13,"F-H0-4717",764,2},
  {{{0x78ded2a1cc6bb7c9}},6,"F-H0-4718",469,25},
  {{{0xbe6f63138fbe89e2}},6,"F-H0-4719",985,2},
  {{{0x6fd935f554617b72}},11,"F-H0-4720",507,26},
  {{{0x6f8bd095b650bd84}},10,"F-H0-4721",470,27},
  {{{0xb1197dc48bce5eb2}},5,"F-H0-4722",838,8},
  {{{0xe3fa372779438bc7}},5,"F-H0-4723",421,4},
  {{{0xe3fa372779438bc7}},5,"F-H0-4724",945,3},
  {{{0xe3fa372779438bc7}},5,"F-H0-4725",909,3},
  {{{0xb1197dc48bce5eb2}},5,"F-H0-4726",875,3},
  {{{0x73ee75297e3c1542}},5,"F-H0-4727",947,2},
  {{{0xaee2e71de7ca5c74}},2,"F-H0-4728",912,12},
  {{{0xa2d3f31b4502ba53}},2,"F-H0-4729",913,5},
  {{{0xa2d3f31b4502ba53}},2,"F-H0-4730",419,4},
  {{{0xa2d3f31b4502ba53}},2,"F-H0-4731",912,2},
  {{{0xaee2e71de7ca5c74}},2,"F-H0-4732",468,2},
  {{{0xf734c097506522c0}},3,"F-H0-4733",456,13},
  {{{0xf734c097506522c0}},3,"F-H0-4734",455,9},
  {{{0xf734c097506522c0}},3,"F-H0-4735",493,3},
  {{{0xf734c097506522c0}},3,"F-H0-4736",492,2},
  {{{0xd9e59ba5aa3e6933}},7,"F-H0-4737",455,25},
  {{{0x2f5e10163d04369}},3,"F-H0-4738",468,17},
  {{{0x90aef664dba3eec7}},3,"F-H0-4739",937,4},
  {{{0x132e440e56e0bb5f}},3,"F-H0-4740",949,4},
  {{{0x4c6d1052ceb0f2bf}},3,"F-H0-4741",430,2},
  {{{0x33cef207313e0a5}},3,"F-H0-4742",530,8},
  {{{0xd6270f5bfbe44268}},4,"F-H0-4743",543,11},
  {{{0xd6270f5bfbe44268}},4,"F-H0-4744",876,10},
  {{{0xd6270f5bfbe44268}},4,"F-H0-4745",728,2},
  {{{0xfcbad9dd4773ceba}},4,"F-H0-4746",529,2},
  {{{0xc9a43300ecdfc3f8}},12,"F-H0-4747",874,7},
  {{{0x45dbd2a25e5a3430}},7,"F-H0-4748",865,14},
  {{{0x45dbd2a25e5a3430}},7,"F-H0-4749",936,8},
  {{{0x45dbd2a25e5a3430}},7,"F-H0-4750",904,3},
  {{{0x275e35400c6589dd}},7,"F-H0-4751",939,3},
  {{{0x275e35400c6589dd}},7,"F-H0-4752",902,2},
  {{{0x4326204cbd2db6cf}},3,"F-H0-4753",468,17},
  {{{0xbbe44c6924fd6152}},3,"F-H0-4754",419,6},
  {{{0x6074c9e833e385a8}},3,"F-H0-4755",839,2},
  {{{0x68013f3723f630cb}},6,"F-H0-4756",751,7},
  {{{0x68013f3723f630cb}},6,"F-H0-4757",421,5},
  {{{0xd5858a4ac415cd}},6,"F-H0-4758",906,2},
  {{{0x68013f3723f630cb}},6,"F-H0-4759",862,2},
  {{{0xd5858a4ac415cd}},6,"F-H0-4760",826,2},
  {{{0xbadfd2232df7431a}},3,"F-H0-4761",432,12},
  {{{0x3e04b29cf07e766c}},3,"F-H0-4762",468,8},
  {{{0x65ed281563253a14}},3,"F-H0-4763",899,5},
  {{{0x3e04b29cf07e766c}},3,"F-H0-4764",948,2},
  {{{0xeebc5d581282cab4}},8,"F-H0-4765",939,13},
  {{{0xeebc5d581282cab4}},8,"F-H0-4766",902,11},
  {{{0xaaf25475ed91c57a}},8,"F-H0-4767",905,3},
  {{{0x4295c08477247d3c}},5,"F-H0-4768",529,9},
  {{{0x7be5bcb28fe9ea40}},5,"F-H0-4769",765,7},
  {{{0x7be5bcb28fe9ea40}},5,"F-H0-4770",910,3},
  {{{0xf3402d5cde439e4f}},5,"F-H0-4771",906,3},
  {{{0x4295c08477247d3c}},5,"F-H0-4772",461,2},
  {{{0x16715964aee0b9e3}},13,"F-H0-4773",867,19},
  {{{0x9b395e5e136f6a4e}},3,"F-H0-4774",949,5},
  {{{0xe8b2afdcac6d0d56}},3,"F-H0-4775",912,4},
  {{{0xe8b2afdcac6d0d56}},3,"F-H0-4776",506,4},
  {{{0x9b395e5e136f6a4e}},3,"F-H0-4777",419,3},
  {{{0xe8b2afdcac6d0d56}},3,"F-H0-4778",876,3},
  {{{0xd48f40fab610452d}},3,"F-H0-4779",904,3},
  {{{0xde5ddf093feca667}},3,"F-H0-4780",863,2},
  {{{0xab27644ab8576a51}},8,"F-H0-4781",875,16},
  {{{0xab27644ab8576a51}},8,"F-H0-4782",837,11},
  {{{0x2f2f64212d65aa03}},7,"F-H0-4783",690,10},
  {{{0x2f2f64212d65aa03}},7,"F-H0-4784",825,4},
  {{{0x884920f471af2e95}},7,"F-H0-4785",686,2},
  {{{0x884920f471af2e95}},7,"F-H0-4786",687,2},
  {{{0xff0cfba41242dc45}},4,"F-H0-4787",505,10},
  {{{0xf0d1850f3481bb99}},4,"F-H0-4788",862,8},
  {{{0xf0d1850f3481bb99}},4,"F-H0-4789",420,6},
  {{{0xd39a7e856a0f1b9a}},2,"F-H0-4790",875,9},
  {{{0xd39a7e856a0f1b9a}},2,"F-H0-4791",430,4},
  {{{0xd39a7e856a0f1b9a}},2,"F-H0-4792",467,4},
  {{{0xdf8d7752bb8ca459}},2,"F-H0-4793",493,2},
  {{{0xdf8d7752bb8ca459}},2,"F-H0-4794",875,2},
  {{{0xdf8d7752bb8ca459}},2,"F-H0-4795",876,2},
  {{{0xe6c2da6d565a5fd1}},4,"F-H0-4796",456,3},
  {{{0xe0eb6faab1eef0b7}},4,"F-H0-4797",460,3},
  {{{0xe08ab8fe9d788ed}},4,"F-H0-4798",432,3},
  {{{0xe6c2da6d565a5fd1}},4,"F-H0-4799",419,2},
  {{{0xe6c2da6d565a5fd1}},4,"F-H0-4800",913,2},
  {{{0xe6c2da6d565a5fd1}},4,"F-H0-4801",429,2},
  {{{0xe6c2da6d565a5fd1}},4,"F-H0-4802",541,2},
  {{{0xe6c2da6d565a5fd1}},4,"F-H0-4803",912,2},
  {{{0xa5f56d490f78cceb}},3,"F-H0-4804",462,7},
  {{{0xda805e841e576e51}},3,"F-H0-4805",939,6},
  {{{0xda805e841e576e51}},3,"F-H0-4806",912,4},
  {{{0xda805e841e576e51}},3,"F-H0-4807",911,3},
  {{{0xda805e841e576e51}},3,"F-H0-4808",542,2},
  {{{0xa01f2c71b7e39deb}},6,"F-H0-4809",938,5},
  {{{0xa01f2c71b7e39deb}},6,"F-H0-4810",937,4},
  {{{0xa01f2c71b7e39deb}},6,"F-H0-4811",936,4},
  {{{0x9ce881119d27f6c7}},6,"F-H0-4812",715,2},
  {{{0xa01f2c71b7e39deb}},6,"F-H0-4813",468,2},
  {{{0x305d461064a1cbc4}},16,"F-H0-4814",825,15},
  {{{0xd92f9d8335efd61f}},16,"F-H0-4815",910,9},
  {{{0x2927dc75f13d8d0c}},16,"F-H0-4816",826,2},
  {{{0xab5108667f1d9c7b}},8,"F-H0-4817",654,17},
  {{{0x807ae44c450bdbe1}},6,"F-H0-4818",837,8},
  {{{0x49912ab9e7d60b66}},6,"F-H0-4819",418,6},
  {{{0x3ddadf12f87872a4}},6,"F-H0-4820",543,3},
  {{{0x45bbd208d19d56cd}},6,"F-H0-4821",839,2},
  {{{0x487d7ecb3d939e0d}},11,"F-H0-4822",421,16},
  {{{0xf6ee857d0c1bc43f}},11,"F-H0-4823",939,5},
  {{{0xf6ee857d0c1bc43f}},11,"F-H0-4824",943,4},
  {{{0x487d7ecb3d939e0d}},11,"F-H0-4825",939,3},
  {{{0xf6ee857d0c1bc43f}},11,"F-H0-4826",947,2},
  {{{0x1675b29bac0d0ac1}},4,"F-H0-4827",542,9},
  {{{0xd52347000bd5fbdd}},4,"F-H0-4828",947,6},
  {{{0x1675b29bac0d0ac1}},4,"F-H0-4829",907,3},
  {{{0x213d9a0262c8290e}},4,"F-H0-4830",862,2},
  {{{0x95a8eba0250a8462}},4,"F-H0-4831",426,2},
  {{{0x1675b29bac0d0ac1}},4,"F-H0-4832",421,2},
  {{{0x1675b29bac0d0ac1}},4,"F-H0-4833",468,2},
  {{{0x1e3c33454308c263}},2,"F-H0-4834",722,14},
  {{{0x1e3c33454308c263}},2,"F-H0-4835",683,5},
  {{{0xfcf90e8510435a74}},3,"F-H0-4836",493,6},
  {{{0x99766e0a720dcc7e}},3,"F-H0-4837",468,6},
  {{{0x96b4bda948d8d81a}},3,"F-H0-4838",901,4},
  {{{0x96b4bda948d8d81a}},3,"F-H0-4839",505,3},
  {{{0x99766e0a720dcc7e}},3,"F-H0-4840",506,2},
  {{{0x99766e0a720dcc7e}},3,"F-H0-4841",862,2},
  {{{0x343f5960066321ef}},6,"F-H0-4842",837,9},
  {{{0x982717f601229ca9}},6,"F-H0-4843",909,8},
  {{{0x94ca6d104ec69522}},6,"F-H0-4844",492,4},
  {{{0x343f5960066321ef}},6,"F-H0-4845",950,4},
  {{{0x343f5960066321ef}},6,"F-H0-4846",838,2},
  {{{0x623aa51a5afe4b61}},9,"F-H0-4847",393,21},
  {{{0xbb80c926f2342497}},9,"F-H0-4848",946,2},
  {{{0x5be0f7bd681745ca}},3,"F-H0-4849",912,10},
  {{{0x5be0f7bd681745ca}},3,"F-H0-4850",949,7},
  {{{0x5be0f7bd681745ca}},3,"F-H0-4851",875,3},
  {{{0xb598dd137187e71e}},3,"F-H0-4852",431,3},
  {{{0x5be0f7bd681745ca}},3,"F-H0-4853",913,3},
  {{{0xeaa0d5ae5763ba8f}},8,"F-H0-4854",910,27},
  {{{0x1b6ef0fd863a5032}},8,"F-H0-4855",567,3},
  {{{0x1b6ef0fd863a5032}},8,"F-H0-4856",533,2},
  {{{0x5afe10c38081ca4f}},8,"F-H0-4857",579,17},
  {{{0x5afe10c38081ca4f}},8,"F-H0-4858",432,13},
  {{{0xdeb0a60f3126db3c}},10,"F-H0-4859",945,10},
  {{{0xdeb0a60f3126db3c}},10,"F-H0-4860",910,8},
  {{{0xdeb0a60f3126db3c}},10,"F-H0-4861",948,5},
  {{{0xdeb0a60f3126db3c}},10,"F-H0-4862",908,3},
  {{{0xdeb0a60f3126db3c}},10,"F-H0-4863",985,2},
  {{{0x3606753775590880}},8,"F-H0-4864",941,12},
  {{{0x3606753775590880}},8,"F-H0-4865",825,4},
  {{{0x3606753775590880}},8,"F-H0-4866",938,3},
  {{{0x3606753775590880}},8,"F-H0-4867",826,3},
  {{{0x36b78259177e3061}},5,"F-H0-4868",911,11},
  {{{0x36b78259177e3061}},5,"F-H0-4869",948,4},
  {{{0x36b78259177e3061}},5,"F-H0-4870",947,3},
  {{{0x36b78259177e3061}},5,"F-H0-4871",944,2},
  {{{0x27e95251b0c8c93e}},5,"F-H0-4872",677,2},
  {{{0x5fce7447b8013ec8}},4,"F-H0-4873",419,19},
  {{{0x5fce7447b8013ec8}},4,"F-H0-4874",456,4},
  {{{0x9952f60fd8349728}},4,"F-H0-4875",862,2},
  {{{0x9952f60fd8349728}},4,"F-H0-4876",827,2},
  {{{0xefff7ce674362a62}},3,"F-H0-4877",875,6},
  {{{0x524b162191b3f51a}},3,"F-H0-4878",906,4},
  {{{0xefff7ce674362a62}},3,"F-H0-4879",456,4},
  {{{0xf5a279e9dbd13638}},3,"F-H0-4880",542,2},
  {{{0x46b169377d866a6}},5,"F-H0-4881",943,19},
  {{{0x2d20bc92113ccedf}},5,"F-H0-4882",825,3},
  {{{0xf15da6589b372303}},5,"F-H0-4883",728,2},
  {{{0xfbbb3cdd93a0752}},5,"F-H0-4884",943,2},
  {{{0x46b169377d866a6}},5,"F-H0-4885",462,2},
  {{{0x31080b3b3b9f0c77}},5,"F-H0-4886",466,8},
  {{{0x3cfbf9b386915df2}},5,"F-H0-4887",418,6},
  {{{0x31080b3b3b9f0c77}},5,"F-H0-4888",911,4},
  {{{0xc3f0ee81273be6a3}},5,"F-H0-4889",876,2},
  {{{0x31080b3b3b9f0c77}},5,"F-H0-4890",947,2},
  {{{0x31080b3b3b9f0c77}},5,"F-H0-4891",910,2},
  {{{0x31080b3b3b9f0c77}},5,"F-H0-4892",430,2},
  {{{0x4a97f8cf108f95ac}},5,"F-H0-4893",825,4},
  {{{0x75ee4ac20601060d}},5,"F-H0-4894",801,4},
  {{{0xd2c9f6d2a01543af}},5,"F-H0-4895",430,3},
  {{{0xd2c9f6d2a01543af}},5,"F-H0-4896",462,3},
  {{{0x75ee4ac20601060d}},5,"F-H0-4897",825,3},
  {{{0xd2c9f6d2a01543af}},5,"F-H0-4898",425,3},
  {{{0x75ee4ac20601060d}},5,"F-H0-4899",764,3},
  {{{0xbe8b80f5fb3ca532}},5,"F-H0-4900",529,11},
  {{{0xdeec1f8f5632b075}},5,"F-H0-4901",427,3},
  {{{0x39a1a21976768e55}},5,"F-H0-4902",946,2},
  {{{0x859aefb9a605dcbe}},5,"F-H0-4903",466,2},
  {{{0x859aefb9a605dcbe}},5,"F-H0-4904",653,2},
  {{{0x2984b80312c32d88}},5,"F-H0-4905",825,14},
  {{{0x1ab131ed11c41a59}},5,"F-H0-4906",943,6},
  {{{0x51099c3806304de0}},5,"F-H0-4907",825,3},
  {{{0x1ab131ed11c41a59}},5,"F-H0-4908",603,2},
  {{{0x5a61d6ce7de4ebd1}},13,"F-H0-4909",899,20},
  {{{0x96806faa3c5e871c}},13,"F-H0-4910",875,3},
  {{{0x4f8486a0e8a48fc4}},13,"F-H0-4911",464,3},
  {{{0xf18a7024c06dc900}},4,"F-H0-4912",420,10},
  {{{0x17664462d1c0f3bf}},4,"F-H0-4913",825,6},
  {{{0x8f61aabe16587ddc}},4,"F-H0-4914",467,5},
  {{{0xf18a7024c06dc900}},4,"F-H0-4915",948,4},
  {{{0x417a45638c68b743}},8,"F-H0-4916",826,15},
  {{{0xf5a5fcffebd0f375}},8,"F-H0-4917",874,6},
  {{{0xf5a5fcffebd0f375}},8,"F-H0-4918",950,4},
  {{{0xf5a5fcffebd0f375}},8,"F-H0-4919",910,2},
  {{{0x3ac7d7bb166c09eb}},12,"F-H0-4920",864,8},
  {{{0xe0c9bf04abc4942a}},4,"F-H0-4921",862,12},
  {{{0x69e712c077d82c28}},4,"F-H0-4922",913,10},
  {{{0xe0c9bf04abc4942a}},4,"F-H0-4923",457,3},
  {{{0x41f2ba544d557a0c}},8,"F-H0-4924",874,18},
  {{{0x41f2ba544d557a0c}},8,"F-H0-4925",912,3},
  {{{0x41f2ba544d557a0c}},8,"F-H0-4926",837,2},
  {{{0x53099df0574a7c93}},11,"F-H0-4927",543,25},
  {{{0x8c2c379aedd34f2c}},11,"F-H0-4928",911,4},
  {{{0xbc90f1cbcc932f95}},7,"F-H0-4929",826,10},
  {{{0xec9465d3b7f34e0d}},7,"F-H0-4930",579,7},
  {{{0xbc90f1cbcc932f95}},7,"F-H0-4931",529,4},
  {{{0xbc90f1cbcc932f95}},7,"F-H0-4932",829,2},
  {{{0xd67035624b2e3915}},7,"F-H0-4933",939,2},
  {{{0x5be2b9665853cbed}},6,"F-H0-4934",825,10},
  {{{0xc29ca590625827b}},6,"F-H0-4935",839,9},
  {{{0xc29ca590625827b}},6,"F-H0-4936",541,4},
  {{{0xc29ca590625827b}},6,"F-H0-4937",432,3},
  {{{0xb3c11534844ddb71}},8,"F-H0-4938",902,15},
  {{{0x99a9594ad4e22265}},8,"F-H0-4939",947,5},
  {{{0xb3c11534844ddb71}},8,"F-H0-4940",751,5},
  {{{0xb3c11534844ddb71}},8,"F-H0-4941",940,3},
  {{{0x191efaf8bdceeb34}},3,"F-H0-4942",456,19},
  {{{0x1af7629ca9dc4ac4}},3,"F-H0-4943",469,6},
  {{{0xf8c704de35e3e9b7}},5,"F-H0-4944",838,5},
  {{{0x571b0fb827c40498}},5,"F-H0-4945",802,5},
  {{{0x571b0fb827c40498}},5,"F-H0-4946",467,5},
  {{{0x571b0fb827c40498}},5,"F-H0-4947",764,5},
  {{{0xf8c704de35e3e9b7}},5,"F-H0-4948",862,5},
  {{{0x380b4504ab093761}},5,"F-H0-4949",492,3},
  {{{0x2062d17133ae8ebb}},5,"F-H0-4950",420,8},
  {{{0x2062d17133ae8ebb}},5,"F-H0-4951",422,7},
  {{{0x39f9f9aacb5366bf}},5,"F-H0-4952",908,5},
  {{{0x796e3b04ba5d17a2}},5,"F-H0-4953",947,2},
  {{{0x2062d17133ae8ebb}},5,"F-H0-4954",461,2},
  {{{0xe18a2ed41d4d3169}},7,"F-H0-4955",466,14},
  {{{0xf6a52b38c60e6b6}},7,"F-H0-4956",494,4},
  {{{0xf6a52b38c60e6b6}},7,"F-H0-4957",382,2},
  {{{0x8dcc74c1ab2027f0}},10,"F-H0-4958",906,17},
  {{{0x53a9b8718dd0f854}},10,"F-H0-4959",691,5},
  {{{0x8dcc74c1ab2027f0}},10,"F-H0-4960",905,2},
  {{{0x4bb26d6ac6584ab8}},5,"F-H0-4961",420,7},
  {{{0x5babde9c9a134ad6}},5,"F-H0-4962",566,5},
  {{{0x4bb26d6ac6584ab8}},5,"F-H0-4963",460,5},
  {{{0x4bb26d6ac6584ab8}},5,"F-H0-4964",876,4},
  {{{0x4bb26d6ac6584ab8}},5,"F-H0-4965",530,4},
  {{{0x7a0448906d370747}},5,"F-H0-4966",863,2},
  {{{0xdfb4fb66c2f8b1e7}},8,"F-H0-4967",503,3},
  {{{0xbeac2294e1b5b0eb}},6,"F-H0-4968",837,15},
  {{{0xbeac2294e1b5b0eb}},6,"F-H0-4969",950,8},
  {{{0x5e36167eda552b6d}},8,"F-H0-4970",872,8},
  {{{0x19bdff464e3efc87}},8,"F-H0-4971",827,4},
  {{{0x2e9ac6d66a093504}},4,"F-H0-4972",640,9},
  {{{0x2a209a05743c6c1a}},4,"F-H0-4973",948,5},
  {{{0x2a209a05743c6c1a}},4,"F-H0-4974",542,4},
  {{{0x2a209a05743c6c1a}},4,"F-H0-4975",907,3},
  {{{0x2a209a05743c6c1a}},4,"F-H0-4976",911,2},
  {{{0x7e9c57d51fe0f6be}},4,"F-H0-4977",691,2},
  {{{0x2a209a05743c6c1a}},4,"F-H0-4978",468,2},
  {{{0xd871e6dda94eb8c4}},3,"F-H0-4979",455,10},
  {{{0xe5a9f3e0bab8e402}},3,"F-H0-4980",468,7},
  {{{0xe5a9f3e0bab8e402}},3,"F-H0-4981",457,4},
  {{{0x19f50e0a73352986}},6,"F-H0-4982",429,12},
  {{{0x19f50e0a73352986}},6,"F-H0-4983",765,6},
  {{{0x8054422bedc6c36d}},6,"F-H0-4984",905,3},
  {{{0x19f50e0a73352986}},6,"F-H0-4985",691,2},
  {{{0x19f50e0a73352986}},6,"F-H0-4986",876,2},
  {{{0x6d1d8e6de177a257}},17,"F-H0-4987",542,11},
  {{{0xebd4ce05edeaa14a}},17,"F-H0-4988",678,6},
  {{{0xebd4ce05edeaa14a}},17,"F-H0-4989",825,4},
  {{{0xebd4ce05edeaa14a}},17,"F-H0-4990",677,4},
  {{{0xebd4ce05edeaa14a}},17,"F-H0-4991",714,2},
  {{{0x7e08cf399c62603d}},5,"F-H0-4992",911,11},
  {{{0x7e08cf399c62603d}},5,"F-H0-4993",947,4},
  {{{0x7e08cf399c62603d}},5,"F-H0-4994",943,3},
  {{{0x7e08cf399c62603d}},5,"F-H0-4995",948,2},
  {{{0x7e08cf399c62603d}},5,"F-H0-4996",677,2},
  {{{0x7e08cf399c62603d}},5,"F-H0-4997",462,2},
  {{{0xa6680051a9f48f24}},4,"F-H0-4998",826,13},
  {{{0xa6680051a9f48f24}},4,"F-H0-4999",825,2},
  {{{0x1688027e302cc358}},8,"F-H0-5000",458,21},
  {{{0x82211c71ca57ae77}},8,"F-H0-5001",837,2},
  {{{0x4452a5aa9c8c7cdf}},9,"F-H0-5002",466,6},
  {{{0x4fcb26dc51157205}},9,"F-H0-5003",945,5},
  {{{0x2bb766eee03a618f}},9,"F-H0-5004",462,4},
  {{{0x4452a5aa9c8c7cdf}},9,"F-H0-5005",429,4},
  {{{0x4452a5aa9c8c7cdf}},9,"F-H0-5006",653,4},
  {{{0x4452a5aa9c8c7cdf}},9,"F-H0-5007",542,2},
  {{{0x7aed32f380efd2b2}},3,"F-H0-5008",468,9},
  {{{0x8223688e6dab54df}},3,"F-H0-5009",455,6},
  {{{0xa70f38cf25bd873f}},3,"F-H0-5010",901,5},
  {{{0x7aed32f380efd2b2}},3,"F-H0-5011",430,3},
  {{{0xe0752080f18b8e68}},3,"F-H0-5012",948,2},
  {{{0xd6704a4593ab622a}},4,"F-H0-5013",949,7},
  {{{0xadf6e1a8030ae15c}},4,"F-H0-5014",426,5},
  {{{0xfbe09a6c8f091568}},4,"F-H0-5015",431,3},
  {{{0xfbe09a6c8f091568}},4,"F-H0-5016",462,3},
  {{{0xd8b2b03d3093d102}},4,"F-H0-5017",907,2},
  {{{0xfbe09a6c8f091568}},4,"F-H0-5018",728,2},
  {{{0x6d0436050af45754}},2,"F-H0-5019",938,9},
  {{{0x9aca9db6add4af07}},2,"F-H0-5020",912,5},
  {{{0x9aca9db6add4af07}},2,"F-H0-5021",430,2},
  {{{0x9aca9db6add4af07}},2,"F-H0-5022",875,2},
  {{{0xef5ac583d65483a4}},2,"F-H0-5023",420,2},
  {{{0x59645c5b04391866}},4,"F-H0-5024",420,12},
  {{{0x59645c5b04391866}},4,"F-H0-5025",457,4},
  {{{0x59645c5b04391866}},4,"F-H0-5026",906,2},
  {{{0x59645c5b04391866}},4,"F-H0-5027",421,2},
  {{{0xd7866d2849ea4b22}},4,"F-H0-5028",543,3},
  {{{0x8076b82e24ece36f}},4,"F-H0-5029",948,2},
  {{{0xe9368c5776df8c84}},7,"F-H0-5030",909,18},
  {{{0x98d387e982a49139}},9,"F-H0-5031",875,15},
  {{{0x98d387e982a49139}},9,"F-H0-5032",802,3},
  {{{0xb47809d562c7a738}},9,"F-H0-5033",871,2},
  {{{0x654b5f7f6bec68d4}},7,"F-H0-5034",465,5},
  {{{0xdb9ec663896d1732}},3,"F-H0-5035",456,14},
  {{{0xdb9ec663896d1732}},3,"F-H0-5036",455,8},
  {{{0xdb9ec663896d1732}},3,"F-H0-5037",875,4},
  {{{0xa852c8f626cafd18}},5,"F-H0-5038",863,6},
  {{{0xa852c8f626cafd18}},5,"F-H0-5039",943,6},
  {{{0xa852c8f626cafd18}},5,"F-H0-5040",913,4},
  {{{0xa852c8f626cafd18}},5,"F-H0-5041",906,3},
  {{{0xa852c8f626cafd18}},5,"F-H0-5042",715,2},
  {{{0xa852c8f626cafd18}},5,"F-H0-5043",690,2},
  {{{0xa852c8f626cafd18}},5,"F-H0-5044",899,2},
  {{{0x238e00287b3bc7ad}},9,"F-H0-5045",678,14},
  {{{0x238e00287b3bc7ad}},9,"F-H0-5046",947,2},
  {{{0x238e00287b3bc7ad}},9,"F-H0-5047",898,2},
  {{{0x47154bc472e1c0d1}},10,"F-H0-5048",503,5},
  {{{0x22f5fbdc3ead1dbf}},10,"F-H0-5049",530,3},
  {{{0x513fb893498a6098}},12,"F-H0-5050",824,25},
  {{{0x6734247df4dc7a0e}},12,"F-H0-5051",430,3},
  {{{0xb27d829e28365c4e}},11,"F-H0-5052",910,4},
  {{{0xc699a511b2ef4fd9}},6,"F-H0-5053",531,21},
  {{{0x65ac9183555988f2}},6,"F-H0-5054",950,4},
  {{{0xb409aa35fdebf7d6}},8,"F-H0-5055",765,12},
  {{{0x9dd675f1df6ed23}},8,"F-H0-5056",839,5},
  {{{0xb409aa35fdebf7d6}},8,"F-H0-5057",432,4},
  {{{0xb409aa35fdebf7d6}},8,"F-H0-5058",727,2},
  {{{0xb409aa35fdebf7d6}},8,"F-H0-5059",764,2},
  {{{0x936657095d2533d9}},6,"F-H0-5060",543,25},
  {{{0xcec728a9f0de3bc9}},6,"F-H0-5061",468,2},
  {{{0x860781a83e31e840}},9,"F-H0-5062",948,4},
  {{{0x84fb80d61964e5ef}},5,"F-H0-5063",939,7},
  {{{0x29681d4b71817a7d}},5,"F-H0-5064",455,4},
  {{{0xfdc7ec748541a5c7}},5,"F-H0-5065",801,4},
  {{{0xfdc7ec748541a5c7}},5,"F-H0-5066",690,3},
  {{{0xfdc7ec748541a5c7}},5,"F-H0-5067",727,2},
  {{{0x19237a2145de0271}},6,"F-H0-5068",939,7},
  {{{0xcf0cac7cede1d51c}},6,"F-H0-5069",826,5},
  {{{0xcf0cac7cede1d51c}},6,"F-H0-5070",904,3},
  {{{0xcf0cac7cede1d51c}},6,"F-H0-5071",906,2},
  {{{0x2830841544435d57}},9,"F-H0-5072",839,17},
  {{{0xdec99a5bebe732dd}},9,"F-H0-5073",687,4},
  {{{0x2830841544435d57}},9,"F-H0-5074",838,4},
  {{{0xa2f4cc839c57bed8}},7,"F-H0-5075",543,9},
  {{{0x28fa1aa001aafa3}},7,"F-H0-5076",912,4},
  {{{0xc22605ce7f0ee41e}},8,"F-H0-5077",530,16},
  {{{0x4afac11e13fc204e}},8,"F-H0-5078",459,8},
  {{{0x177bb66b775487bb}},8,"F-H0-5079",493,2},
  {{{0xa950006bc63a36c7}},7,"F-H0-5080",904,9},
  {{{0xac0b31d8ceacc730}},7,"F-H0-5081",420,8},
  {{{0x452676400f75ac18}},7,"F-H0-5082",802,5},
  {{{0xac0b31d8ceacc730}},7,"F-H0-5083",494,3},
  {{{0x286927e6f24019f1}},13,"F-H0-5084",652,12},
  {{{0x9e0061630245769e}},13,"F-H0-5085",462,6},
  {{{0x14fc4e2a62453c5}},13,"F-H0-5086",425,2},
  {{{0x5e07e760bf899d01}},2,"F-H0-5087",912,12},
  {{{0x681204066afa7edb}},2,"F-H0-5088",468,4},
  {{{0x681204066afa7edb}},2,"F-H0-5089",419,4},
  {{{0xd7e4a7de4d56aea6}},6,"F-H0-5090",838,6},
  {{{0xd7e4a7de4d56aea6}},6,"F-H0-5091",911,6},
  {{{0xd7e4a7de4d56aea6}},6,"F-H0-5092",839,5},
  {{{0xd7e4a7de4d56aea6}},6,"F-H0-5093",690,3},
  {{{0x79aad086bacec598}},6,"F-H0-5094",906,2},
  {{{0x6621920d2f741202}},6,"F-H0-5095",579,20},
  {{{0x867b65d883ff7863}},12,"F-H0-5096",500,17},
  {{{0x830ab866f49dbbe6}},12,"F-H0-5097",678,7},
  {{{0x79bfce4627c7beb7}},6,"F-H0-5098",950,13},
  {{{0xd802788adb905eca}},6,"F-H0-5099",541,12},
  {{{0x2b20568f6da114ad}},8,"F-H0-5100",506,18},
  {{{0x2b20568f6da114ad}},8,"F-H0-5101",469,2},
  {{{0xa999602e4fe3f45f}},6,"F-H0-5102",873,17},
  {{{0x110f2efcde6366dd}},6,"F-H0-5103",910,5},
  {{{0x110f2efcde6366dd}},6,"F-H0-5104",874,4},
  {{{0x63b8414820bd860d}},6,"F-H0-5105",496,2},
  {{{0x454506d5cc025f7b}},6,"F-H0-5106",862,9},
  {{{0x454506d5cc025f7b}},6,"F-H0-5107",864,4},
  {{{0x4fba839fef8d15e2}},6,"F-H0-5108",910,3},
  {{{0x454506d5cc025f7b}},6,"F-H0-5109",752,2},
  {{{0x8f15c479d306fa25}},6,"F-H0-5110",422,2},
  {{{0x454506d5cc025f7b}},6,"F-H0-5111",939,2},
  {{{0x454506d5cc025f7b}},6,"F-H0-5112",838,2},
  {{{0xa7871d408be335c4}},9,"F-H0-5113",914,17},
  {{{0x903d79aa25001930}},9,"F-H0-5114",910,5},
  {{{0x4e12a3a2ce089333}},10,"F-H0-5115",985,9},
  {{{0x11c796577c2e299}},3,"F-H0-5116",456,15},
  {{{0x11c796577c2e299}},3,"F-H0-5117",492,3},
  {{{0x11c796577c2e299}},3,"F-H0-5118",949,3},
  {{{0x11c796577c2e299}},3,"F-H0-5119",455,2},
  {{{0x11c796577c2e299}},3,"F-H0-5120",419,2},
  {{{0x4a5ab5067ecbf4a3}},6,"F-H0-5121",418,2},
  {{{0x7d098ff090ba90d6}},3,"F-H0-5122",456,20},
  {{{0x7d098ff090ba90d6}},3,"F-H0-5123",455,4},
  {{{0x81770e5e582efc19}},10,"F-H0-5124",802,16},
  {{{0x87d29f5d90b8ad9b}},10,"F-H0-5125",902,2},
  {{{0x14de694f038f610}},10,"F-H0-5126",868,2},
  {{{0x6eda1d3d0fa4cbb3}},8,"F-H0-5127",899,27},
  {{{0x50ae6ea445ae181e}},12,"F-H0-5128",429,20},
  {{{0xfd4d32ea5c3bbee8}},12,"F-H0-5129",542,2},
  {{{0xf229888dadcac399}},7,"F-H0-5130",429,13},
  {{{0x8cdde714b76342dc}},7,"F-H0-5131",641,4},
  {{{0xf229888dadcac399}},7,"F-H0-5132",466,4},
  {{{0x8cdde714b76342dc}},7,"F-H0-5133",603,4},
  {{{0x844280c5c2f73f3}},12,"F-H0-5134",909,8},
  {{{0xdd9b54cf57e08e6c}},12,"F-H0-5135",566,2},
  {{{0x46a0684956e814a6}},6,"F-H0-5136",714,16},
  {{{0x46a0684956e814a6}},6,"F-H0-5137",454,4},
  {{{0x416fa5e4195965b3}},6,"F-H0-5138",906,3},
  {{{0x23f7eef4d12eecd6}},7,"F-H0-5139",827,9},
  {{{0xc9902d15c7b8325c}},7,"F-H0-5140",950,9},
  {{{0xc9902d15c7b8325c}},7,"F-H0-5141",877,3},
  {{{0x8d3329e662b262ce}},4,"F-H0-5142",939,9},
  {{{0x7b3aa4de1117d51d}},4,"F-H0-5143",839,4},
  {{{0xc7bf67f3374977ec}},4,"F-H0-5144",421,4},
  {{{0x7b3aa4de1117d51d}},4,"F-H0-5145",947,3},
  {{{0xb33a6bb24ff78a34}},4,"F-H0-5146",949,2},
  {{{0x78be406a64dfac89}},9,"F-H0-5147",424,26},
  {{{0x54caa2191c9580f6}},9,"F-H0-5148",947,11},
  {{{0x54caa2191c9580f6}},9,"F-H0-5149",825,9},
  {{{0xfa6ac77e8af85b28}},7,"F-H0-5150",419,22},
  {{{0xfeb25a9fd6ef9f0}},8,"F-H0-5151",947,16},
  {{{0xfeb25a9fd6ef9f0}},8,"F-H0-5152",911,5},
  {{{0x23141efc298ecb84}},5,"F-H0-5153",421,7},
  {{{0xca6ad1e9fcf968d6}},5,"F-H0-5154",765,5},
  {{{0xca6ad1e9fcf968d6}},5,"F-H0-5155",505,4},
  {{{0x64bac576e7b412d3}},5,"F-H0-5156",430,2},
  {{{0x5eebacf6d2402cab}},8,"F-H0-5157",653,7},
  {{{0x2d07d46b932971df}},8,"F-H0-5158",867,4},
  {{{0xd736cce7ce8145a8}},4,"F-H0-5159",462,9},
  {{{0x34e9ea66c8a6ef42}},4,"F-H0-5160",691,5},
  {{{0x631d61c1777f198e}},4,"F-H0-5161",419,4},
  {{{0x631d61c1777f198e}},4,"F-H0-5162",462,3},
  {{{0x631d61c1777f198e}},4,"F-H0-5163",431,2},
  {{{0x631d61c1777f198e}},4,"F-H0-5164",684,2},
  {{{0x2df92963ab2962a5}},5,"F-H0-5165",939,10},
  {{{0xe26aada2da086e9c}},5,"F-H0-5166",801,3},
  {{{0xe26aada2da086e9c}},5,"F-H0-5167",430,2},
  {{{0x2df92963ab2962a5}},5,"F-H0-5168",462,2},
  {{{0x2df92963ab2962a5}},5,"F-H0-5169",461,2},
  {{{0xe26aada2da086e9c}},5,"F-H0-5170",462,2},
  {{{0xa4aaa08cd96fe9e3}},7,"F-H0-5171",939,8},
  {{{0x826e3b8205ba6541}},7,"F-H0-5172",503,7},
  {{{0x82ce133dec8443ad}},7,"F-H0-5173",936,5},
  {{{0xfa3c7fd6d469e330}},7,"F-H0-5174",910,3},
  {{{0x5e77b86b87c09f0e}},9,"F-H0-5175",430,3},
  {{{0xa67b7ea1b9a0ae0}},10,"F-H0-5176",431,3},
  {{{0x53d237034ff263a7}},7,"F-H0-5177",432,11},
  {{{0x888fb74910a39146}},7,"F-H0-5178",940,6},
  {{{0xebaa1626cf4ebf0}},7,"F-H0-5179",901,3},
  {{{0x13110cd76f241884}},15,"F-H0-5180",502,22},
  {{{0xa64b676cf6fb057a}},15,"F-H0-5181",458,3},
  {{{0xa64b676cf6fb057a}},15,"F-H0-5182",417,2},
  {{{0x48cfd8abad517e78}},2,"F-H0-5183",468,6},
  {{{0x48cfd8abad517e78}},2,"F-H0-5184",899,3},
  {{{0x2096840f32f53f9d}},2,"F-H0-5185",906,3},
  {{{0xbd01991980331c25}},2,"F-H0-5186",837,2},
  {{{0x2096840f32f53f9d}},2,"F-H0-5187",493,2},
  {{{0xfbc4db72fd8c39c5}},2,"F-H0-5188",492,2},
  {{{0xdba08641eac705d7}},4,"F-H0-5189",862,13},
  {{{0xdba08641eac705d7}},4,"F-H0-5190",419,4},
  {{{0xdba08641eac705d7}},4,"F-H0-5191",543,4},
  {{{0x17ffd441c254cce0}},10,"F-H0-5192",432,12},
  {{{0x171f70b22d33bf22}},10,"F-H0-5193",948,10},
  {{{0x17ffd441c254cce0}},10,"F-H0-5194",469,5},
  {{{0x372be2d7bc154729}},6,"F-H0-5195",911,8},
  {{{0x8079ea005ef71a34}},6,"F-H0-5196",942,6},
  {{{0xed11cee80d1801b5}},6,"F-H0-5197",802,5},
  {{{0x8079ea005ef71a34}},6,"F-H0-5198",425,5},
  {{{0x8079ea005ef71a34}},6,"F-H0-5199",940,4},
  {{{0x8079ea005ef71a34}},6,"F-H0-5200",529,2},
  {{{0x1814591973388590}},2,"F-H0-5201",462,5},
  {{{0xbfef5e915b7f8650}},2,"F-H0-5202",906,3},
  {{{0x692b8421d06f390b}},2,"F-H0-5203",641,2},
  {{{0xe921a51df2c53928}},5,"F-H0-5204",904,8},
  {{{0x3304eae3d3a20f40}},5,"F-H0-5205",422,5},
  {{{0x81c95832b7023f6}},5,"F-H0-5206",466,4},
  {{{0xeb708160e88b14be}},5,"F-H0-5207",876,4},
  {{{0x3304eae3d3a20f40}},5,"F-H0-5208",494,2},
  {{{0x7122144467e49860}},10,"F-H0-5209",462,11},
  {{{0xb877887b963edc8b}},10,"F-H0-5210",947,7},
  {{{0x5d8a10455505710}},10,"F-H0-5211",905,2},
  {{{0x632e88ccb5455c64}},8,"F-H0-5212",874,14},
  {{{0x632e88ccb5455c64}},8,"F-H0-5213",838,5},
  {{{0xe5dcdf9b6a2969ed}},8,"F-H0-5214",902,4},
  {{{0x99835564a12db021}},5,"F-H0-5215",677,17},
  {{{0xd25a881b1a2b5e6e}},5,"F-H0-5216",942,2},
  {{{0x6ec0f0e37eefdeb}},3,"F-H0-5217",456,17},
  {{{0x6ec0f0e37eefdeb}},3,"F-H0-5218",455,3},
  {{{0xd2e74fc01f5dc332}},9,"F-H0-5219",911,8},
  {{{0xd2e74fc01f5dc332}},9,"F-H0-5220",617,6},
  {{{0xd2e74fc01f5dc332}},9,"F-H0-5221",462,5},
  {{{0xaca79d4f8ffe3fd}},9,"F-H0-5222",566,4},
  {{{0xd2e74fc01f5dc332}},9,"F-H0-5223",579,2},
  {{{0xd704fb4c0527f9a1}},4,"F-H0-5224",506,6},
  {{{0xf1db8c68fd0405e7}},4,"F-H0-5225",940,5},
  {{{0xf1db8c68fd0405e7}},4,"F-H0-5226",456,3},
  {{{0xd704fb4c0527f9a1}},4,"F-H0-5227",616,2},
  {{{0xc59238a7be7b44cd}},9,"F-H0-5228",940,15},
  {{{0xc59238a7be7b44cd}},9,"F-H0-5229",975,8},
  {{{0x7ee1e17852ff2a61}},6,"F-H0-5230",421,14},
  {{{0xf6e66df8d91c3b43}},6,"F-H0-5231",468,11},
  {{{0x9bb7719219f84ac1}},7,"F-H0-5232",939,9},
  {{{0x8e99b94e9d3072d9}},7,"F-H0-5233",566,7},
  {{{0x9bb7719219f84ac1}},7,"F-H0-5234",423,4},
  {{{0x8909acc3d8d383b9}},17,"F-H0-5235",974,13},
  {{{0xf37d6d920ba24d9}},17,"F-H0-5236",463,6},
  {{{0xb943ebe64a20f24a}},17,"F-H0-5237",825,2},
  {{{0xb943ebe64a20f24a}},17,"F-H0-5238",913,2},
  {{{0xa6d51ffcce4cf72b}},3,"F-H0-5239",912,4},
  {{{0xa6d51ffcce4cf72b}},3,"F-H0-5240",420,3},
  {{{0x9ccaee0165d683ea}},3,"F-H0-5241",469,3},
  {{{0xa6d51ffcce4cf72b}},3,"F-H0-5242",469,2},
  {{{0x9ccaee0165d683ea}},3,"F-H0-5243",468,2},
  {{{0xa6d51ffcce4cf72b}},3,"F-H0-5244",948,2},
  {{{0xa6d51ffcce4cf72b}},3,"F-H0-5245",530,2},
  {{{0xd48f6d296ca1b6b3}},9,"F-H0-5246",541,27},
  {{{0x175da752478f24db}},7,"F-H0-5247",874,18},
  {{{0xec1c0cd7ccf4b988}},7,"F-H0-5248",837,4},
  {{{0x175da752478f24db}},7,"F-H0-5249",912,2},
  {{{0x3aaac1564c867b6a}},9,"F-H0-5250",678,12},
  {{{0x3aaac1564c867b6a}},9,"F-H0-5251",898,6},
  {{{0x3aaac1564c867b6a}},9,"F-H0-5252",640,2},
  {{{0x35ac9d324b01e55a}},10,"F-H0-5253",939,25},
  {{{0x8a56273761b41902}},7,"F-H0-5254",939,20},
  {{{0xb684d850d4c273d4}},7,"F-H0-5255",946,7},
  {{{0x46fe8996ed2e4c8c}},3,"F-H0-5256",826,4},
  {{{0x46fe8996ed2e4c8c}},3,"F-H0-5257",862,2},
  {{{0x7b0a4da8bd372}},2,"F-H0-5258",456,12},
  {{{0x87dacd8cf8dc88ff}},2,"F-H0-5259",468,6},
  {{{0xb4e4b906f7f45ecf}},2,"F-H0-5260",912,2},
  {{{0x5c66801ec0bd8181}},7,"F-H0-5261",641,13},
  {{{0x5c66801ec0bd8181}},7,"F-H0-5262",603,6},
  {{{0x82fe9b2b2affc244}},7,"F-H0-5263",466,2},
  {{{0x82fe9b2b2affc244}},7,"F-H0-5264",690,2},
  {{{0x7f35825b286bd922}},14,"F-H0-5265",973,25},
  {{{0xfea93ed988585ade}},6,"F-H0-5266",906,11},
  {{{0x74d4a7fc8abc28a8}},6,"F-H0-5267",425,4},
  {{{0xfea93ed988585ade}},6,"F-H0-5268",939,3},
  {{{0xc66fdb3847f96da4}},7,"F-H0-5269",469,22},
  {{{0xc66fdb3847f96da4}},7,"F-H0-5270",507,2},
  {{{0xaf94806aab297c21}},6,"F-H0-5271",465,8},
  {{{0x4dde3d558ab8660c}},6,"F-H0-5272",827,4},
  {{{0xe103f11dd7ab78c6}},6,"F-H0-5273",902,4},
  {{{0x4dde3d558ab8660c}},6,"F-H0-5274",936,3},
  {{{0x4dde3d558ab8660c}},6,"F-H0-5275",790,2},
  {{{0xbb0f614fe9be6db5}},6,"F-H0-5276",506,2},
  {{{0xf7f6496d401d3ac0}},3,"F-H0-5277",825,10},
  {{{0xb8f5a785c230fe68}},3,"F-H0-5278",456,5},
  {{{0xb68483be5b8302a0}},3,"F-H0-5279",945,5},
  {{{0xb68483be5b8302a0}},3,"F-H0-5280",456,3},
  {{{0xdb61b026eccfd63f}},13,"F-H0-5281",839,21},
  {{{0xd22bf575689fb2a4}},13,"F-H0-5282",943,2},
  {{{0x7c4b4c3ff80dd1}},7,"F-H0-5283",502,6},
  {{{0x5cc62d33e062b1e6}},7,"F-H0-5284",469,4},
  {{{0xa4a8a6808f7051b6}},7,"F-H0-5285",838,4},
  {{{0x5cc62d33e062b1e6}},7,"F-H0-5286",428,4},
  {{{0x7c4b4c3ff80dd1}},7,"F-H0-5287",463,3},
  {{{0x2226e69e80121ba9}},8,"F-H0-5288",986,17},
  {{{0x9c5436add6d03629}},8,"F-H0-5289",539,2},
  {{{0xc3c02bf5b56cdc1}},13,"F-H0-5290",935,20},
  {{{0x862083b8beb5617c}},5,"F-H0-5291",948,5},
  {{{0x862083b8beb5617c}},5,"F-H0-5292",616,4},
  {{{0x862083b8beb5617c}},5,"F-H0-5293",911,3},
  {{{0x862083b8beb5617c}},5,"F-H0-5294",467,3},
  {{{0x862083b8beb5617c}},5,"F-H0-5295",653,2},
  {{{0x8b61f3b7679dacef}},5,"F-H0-5296",946,2},
  {{{0xa7273177e563b854}},5,"F-H0-5297",542,2},
  {{{0x305d5e594d563356}},4,"F-H0-5298",505,7},
  {{{0xebc39434c9a752ca}},4,"F-H0-5299",469,5},
  {{{0xebc39434c9a752ca}},4,"F-H0-5300",906,4},
  {{{0x517ebd70e46883dd}},4,"F-H0-5301",431,3},
  {{{0x305d5e594d563356}},4,"F-H0-5302",506,2},
  {{{0x964684b0c71787b5}},9,"F-H0-5303",839,19},
  {{{0x9c7bf31ece45a238}},9,"F-H0-5304",457,2},
  {{{0xc461090a0e649863}},3,"F-H0-5305",456,13},
  {{{0x21c91fdc2195328d}},5,"F-H0-5306",421,8},
  {{{0x21c91fdc2195328d}},5,"F-H0-5307",603,6},
  {{{0x21c91fdc2195328d}},5,"F-H0-5308",641,5},
  {{{0x21c91fdc2195328d}},5,"F-H0-5309",458,3},
  {{{0x59488568600abf30}},5,"F-H0-5310",826,2},
  {{{0x21c91fdc2195328d}},5,"F-H0-5311",948,2},
  {{{0x98a4334228c85405}},7,"F-H0-5312",940,22},
  {{{0x210978c549296379}},16,"F-H0-5313",833,4},
  {{{0x61655eb990bff50f}},16,"F-H0-5314",936,3},
  {{{0x61655eb990bff50f}},16,"F-H0-5315",867,2},
  {{{0xad1af6ee1ddfb74}},11,"F-H0-5316",529,18},
  {{{0xab1804af7dfac3d0}},11,"F-H0-5317",420,2},
  {{{0x2f33e66fc75f00e8}},11,"F-H0-5318",947,2},
  {{{0x31ff6af8984c7dc8}},5,"F-H0-5319",492,9},
  {{{0x451a24ca8035a209}},5,"F-H0-5320",460,5},
  {{{0xf302547b9dd4889}},5,"F-H0-5321",939,3},
  {{{0x451a24ca8035a209}},5,"F-H0-5322",461,2},
  {{{0x451a24ca8035a209}},5,"F-H0-5323",422,2},
  {{{0x31ff6af8984c7dc8}},5,"F-H0-5324",458,2},
  {{{0x8fe7e7283d2ba254}},11,"F-H0-5325",425,15},
  {{{0x58c6a7575f889178}},11,"F-H0-5326",678,9},
  {{{0x9fbce7a1c59e79a7}},3,"F-H0-5327",492,9},
  {{{0x804ed1f210d6df2e}},3,"F-H0-5328",949,4},
  {{{0x9fbce7a1c59e79a7}},3,"F-H0-5329",493,3},
  {{{0x9fbce7a1c59e79a7}},3,"F-H0-5330",948,2},
  {{{0x9fbce7a1c59e79a7}},3,"F-H0-5331",420,2},
  {{{0x9fbce7a1c59e79a7}},3,"F-H0-5332",456,2},
  {{{0xad878b83ba9aa296}},7,"F-H0-5333",458,11},
  {{{0xb14f83c3b0fb1bff}},7,"F-H0-5334",910,8},
  {{{0x7838a7ceb7023145}},7,"F-H0-5335",864,3},
  {{{0xea45c30aa84aa39e}},8,"F-H0-5336",455,10},
  {{{0xeb420ccf58ce59}},8,"F-H0-5337",899,3},
  {{{0xec387f208892ede7}},5,"F-H0-5338",943,16},
  {{{0xec387f208892ede7}},5,"F-H0-5339",944,2},
  {{{0xacaa37196d5c5225}},5,"F-H0-5340",461,2},
  {{{0xa86c979fd7f326cf}},5,"F-H0-5341",714,2},
  {{{0x265cde66f9fb317b}},2,"F-H0-5342",913,9},
  {{{0x265cde66f9fb317b}},2,"F-H0-5343",912,4},
  {{{0xf8c1d71d3bd3f064}},2,"F-H0-5344",913,4},
  {{{0xf8c1d71d3bd3f064}},2,"F-H0-5345",912,3},
  {{{0x265cde66f9fb317b}},2,"F-H0-5346",420,2},
  {{{0xfce010b3ec81b1a2}},12,"F-H0-5347",418,15},
  {{{0x21521948c44cf666}},12,"F-H0-5348",540,12},
  {{{0xc84cf35740da54d}},8,"F-H0-5349",431,20},
  {{{0x8a422753924cffe7}},3,"F-H0-5350",875,4},
  {{{0x8a422753924cffe7}},3,"F-H0-5351",506,3},
  {{{0x106be55eb7761cac}},3,"F-H0-5352",458,2},
  {{{0x8a422753924cffe7}},3,"F-H0-5353",876,2},
  {{{0x106be55eb7761cac}},3,"F-H0-5354",506,2},
  {{{0x8a422753924cffe7}},3,"F-H0-5355",467,2},
  {{{0x32e4f91103d38db}},3,"F-H0-5356",455,2},
  {{{0x8a422753924cffe7}},3,"F-H0-5357",468,2},
  {{{0xb40f205016135a7a}},10,"F-H0-5358",871,21},
  {{{0x99a3ae4aed1d73f1}},15,"F-H0-5359",861,19},
  {{{0xeb3576bfb2e9f3be}},2,"F-H0-5360",838,6},
  {{{0xeb3576bfb2e9f3be}},2,"F-H0-5361",530,3},
  {{{0x3df96fb408083a8a}},2,"F-H0-5362",838,2},
  {{{0xd72bad9a014d992f}},2,"F-H0-5363",757,5},
  {{{0x735110a9a56a468e}},2,"F-H0-5364",468,4},
  {{{0x8e589faccd6c0431}},2,"F-H0-5365",832,2},
  {{{0x550a87be96a19d41}},2,"F-H0-5366",678,2},
  {{{0xd72bad9a014d992f}},2,"F-H0-5367",645,2},
  {{{0x73d5f344da53b691}},5,"F-H0-5368",466,7},
  {{{0x73d5f344da53b691}},5,"F-H0-5369",429,6},
  {{{0x73d5f344da53b691}},5,"F-H0-5370",653,3},
  {{{0x8ef45f0ab599c780}},5,"F-H0-5371",678,2},
  {{{0xaa1c92ea93ff1736}},9,"F-H0-5372",430,10},
  {{{0xaa1c92ea93ff1736}},9,"F-H0-5373",458,6},
  {{{0x7a2bbb6ba826cf57}},9,"F-H0-5374",908,4},
  {{{0x8b23440cbd14626e}},9,"F-H0-5375",690,2},
  {{{0x3bc0b163d38260a5}},5,"F-H0-5376",617,3},
  {{{0xe29f362d5d54009a}},5,"F-H0-5377",529,3},
  {{{0xe29f362d5d54009a}},5,"F-H0-5378",462,2},
  {{{0xe99a8cc18a170a03}},7,"F-H0-5379",541,7},
  {{{0xc36ff360b6989b5}},7,"F-H0-5380",420,7},
  {{{0xe99a8cc18a170a03}},7,"F-H0-5381",578,2},
  {{{0x471231cbdd6d563c}},16,"F-H0-5382",831,6},
  {{{0x634d666eb0b6076c}},16,"F-H0-5383",871,3},
  {{{0x634d666eb0b6076c}},16,"F-H0-5384",950,3},
  {{{0x53ba1c03a969af07}},9,"F-H0-5385",529,24},
  {{{0xd3e8461ed311b775}},10,"F-H0-5386",470,20},
  {{{0x9a9b61d85eb993d9}},5,"F-H0-5387",908,7},
  {{{0x5b1d38310e1788c4}},5,"F-H0-5388",493,4},
  {{{0x9fad17f13950afb6}},5,"F-H0-5389",901,3},
  {{{0x9fad17f13950afb6}},5,"F-H0-5390",938,3},
  {{{0x9a9b61d85eb993d9}},5,"F-H0-5391",907,2},
  {{{0x22e78f910803e98d}},3,"F-H0-5392",940,4},
  {{{0x22e78f910803e98d}},3,"F-H0-5393",826,3},
  {{{0x22e78f910803e98d}},3,"F-H0-5394",904,3},
  {{{0x22e78f910803e98d}},3,"F-H0-5395",938,2},
  {{{0xd95b019687260628}},3,"F-H0-5396",864,2},
  {{{0xe0aa5b49a8ddb59c}},11,"F-H0-5397",936,4},
  {{{0x8f566c1e91dc33d9}},13,"F-H0-5398",506,24},
  {{{0xf7d633754f70f4d6}},5,"F-H0-5399",838,7},
  {{{0xf7d633754f70f4d6}},5,"F-H0-5400",801,6},
  {{{0xf7d633754f70f4d6}},5,"F-H0-5401",837,5},
  {{{0x9d8ed52797030e81}},5,"F-H0-5402",420,2},
  {{{0xcde5790703362b6d}},3,"F-H0-5403",421,4},
  {{{0x1be648c14f4bc88e}},3,"F-H0-5404",839,3},
  {{{0x7c50e9c54ce1ecff}},3,"F-H0-5405",903,2},
  {{{0xfc435a12550f67e7}},5,"F-H0-5406",616,10},
  {{{0xfc435a12550f67e7}},5,"F-H0-5407",579,3},
  {{{0xc925ed1c9e02c8fa}},5,"F-H0-5408",875,3},
  {{{0xdd7520c17a62758b}},4,"F-H0-5409",457,9},
  {{{0x2d6c14986f5a7083}},4,"F-H0-5410",910,3},
  {{{0xdd7520c17a62758b}},4,"F-H0-5411",690,2},
  {{{0x8e0d0da8ea145ce5}},11,"F-H0-5412",507,25},
  {{{0xcb01cf5142114ef1}},8,"F-H0-5413",875,6},
  {{{0xcb01cf5142114ef1}},8,"F-H0-5414",873,3},
  {{{0xcb01cf5142114ef1}},8,"F-H0-5415",839,2},
  {{{0xcb01cf5142114ef1}},8,"F-H0-5416",984,2},
  {{{0x8a172e96a3e6d8ef}},16,"F-H0-5417",938,10},
  {{{0x8a172e96a3e6d8ef}},16,"F-H0-5418",787,9},
  {{{0x8bc90319abadc2fb}},16,"F-H0-5419",503,3},
  {{{0xbf9a27a157ff1b6a}},16,"F-H0-5420",346,2},
  {{{0x2653c610781a067b}},4,"F-H0-5421",862,6},
  {{{0x2653c610781a067b}},4,"F-H0-5422",456,6},
  {{{0x3da955439e5eaf77}},4,"F-H0-5423",469,3},
  {{{0x2653c610781a067b}},4,"F-H0-5424",492,2},
  {{{0x759103c0262863d6}},10,"F-H0-5425",579,21},
  {{{0x1a444ff93b37317d}},7,"F-H0-5426",469,21},
  {{{0x6ca94823c4d001aa}},7,"F-H0-5427",913,2},
  {{{0x222b392bf741a7d2}},9,"F-H0-5428",467,25},
  {{{0x68a6a4c7a3fbee25}},6,"F-H0-5429",911,9},
  {{{0xe85270d796544ccf}},6,"F-H0-5430",678,5},
  {{{0xe5651d93d94e1d18}},6,"F-H0-5431",677,4},
  {{{0xe85270d796544ccf}},6,"F-H0-5432",458,2},
  {{{0x4bbecf68c9a88dd1}},4,"F-H0-5433",949,14},
  {{{0x4bbecf68c9a88dd1}},4,"F-H0-5434",425,4},
  {{{0x4bbecf68c9a88dd1}},4,"F-H0-5435",950,2},
  {{{0xbd870676dc0ceb0d}},4,"F-H0-5436",690,2},
  {{{0x8bfe012f656bfb69}},5,"F-H0-5437",466,7},
  {{{0xa01edabf912b39a4}},5,"F-H0-5438",839,6},
  {{{0xa01edabf912b39a4}},5,"F-H0-5439",945,4},
  {{{0xa01edabf912b39a4}},5,"F-H0-5440",906,2},
  {{{0x80762bde28a0cb0a}},9,"F-H0-5441",898,18},
  {{{0xd111cc6050b9e6a3}},9,"F-H0-5442",908,3},
  {{{0x80762bde28a0cb0a}},9,"F-H0-5443",829,2},
  {{{0x728e2275ed8c924f}},14,"F-H0-5444",429,21},
  {{{0x61efaa304e446728}},6,"F-H0-5445",423,10},
  {{{0x28edf0dd4debe458}},6,"F-H0-5446",902,4},
  {{{0xfe6f6d6e29448f7c}},6,"F-H0-5447",837,2},
  {{{0x28edf0dd4debe458}},6,"F-H0-5448",906,2},
  {{{0xfe6f6d6e29448f7c}},6,"F-H0-5449",874,2},
  {{{0x2661d7abf6795a5f}},6,"F-H0-5450",907,2},
  {{{0x2a740d59527ef26f}},8,"F-H0-5451",899,23},
  {{{0xbd977b0435f12faa}},8,"F-H0-5452",913,2},
  {{{0x989603d93419f785}},5,"F-H0-5453",460,12},
  {{{0x989603d93419f785}},5,"F-H0-5454",493,3},
  {{{0xd5bdac10c0a092b4}},5,"F-H0-5455",428,3},
  {{{0x989603d93419f785}},5,"F-H0-5456",424,2},
  {{{0x8e33dfbbb6fd386}},8,"F-H0-5457",465,19},
  {{{0xd74978068acb2a8c}},8,"F-H0-5458",542,5},
  {{{0xa898f0daef4ec172}},4,"F-H0-5459",457,10},
  {{{0xa898f0daef4ec172}},4,"F-H0-5460",431,7},
  {{{0xa898f0daef4ec172}},4,"F-H0-5461",944,3},
  {{{0xa898f0daef4ec172}},4,"F-H0-5462",907,3},
  {{{0xa898f0daef4ec172}},4,"F-H0-5463",948,2},
  {{{0x703eb80a668d9964}},17,"F-H0-5464",986,9},
  {{{0x703eb80a668d9964}},17,"F-H0-5465",907,4},
  {{{0x417a661cd70067c0}},17,"F-H0-5466",423,3},
  {{{0x954423145dfca007}},15,"F-H0-5467",875,16},
  {{{0x954423145dfca007}},15,"F-H0-5468",876,5},
  {{{0x16555284222b8d1}},15,"F-H0-5469",839,2},
  {{{0x718471a9fab5a85d}},8,"F-H0-5470",531,15},
  {{{0xf935b0d89a2c1be4}},8,"F-H0-5471",393,5},
  {{{0x257730ef5aa39ffb}},12,"F-H0-5472",433,20},
  {{{0x1f02476a4f5bac0f}},5,"F-H0-5473",950,8},
  {{{0x5be5af62ce1fdc13}},5,"F-H0-5474",873,7},
  {{{0x5be5af62ce1fdc13}},5,"F-H0-5475",985,2},
  {{{0xe6ef6bfb78f6f4cd}},8,"F-H0-5476",902,16},
  {{{0xabe3f517fe281375}},8,"F-H0-5477",909,4},
  {{{0x3cd55a31b3c1d254}},8,"F-H0-5478",902,18},
  {{{0x8bc7f48c36c9c86b}},6,"F-H0-5479",653,10},
  {{{0x8bc7f48c36c9c86b}},6,"F-H0-5480",690,8},
  {{{0xaeca51020693382e}},6,"F-H0-5481",467,17},
  {{{0x17be411c9c19c05c}},6,"F-H0-5482",863,3},
  {{{0xe7d7afe064d7cf3a}},4,"F-H0-5483",899,6},
  {{{0xab1f220f33063f33}},4,"F-H0-5484",907,4},
  {{{0xab1f220f33063f33}},4,"F-H0-5485",505,4},
  {{{0xab1f220f33063f33}},4,"F-H0-5486",944,3},
  {{{0x9b52deabdd68a8a4}},4,"F-H0-5487",492,2},
  {{{0xe555c936ac74633a}},4,"F-H0-5488",862,2},
  {{{0x7474b15d074d3234}},4,"F-H0-5489",947,4},
  {{{0xf333b521ae39153e}},4,"F-H0-5490",684,2},
  {{{0x6be516d47ce4c9ed}},8,"F-H0-5491",469,7},
  {{{0x6552ff59ec0b4123}},9,"F-H0-5492",617,7},
  {{{0x6552ff59ec0b4123}},9,"F-H0-5493",462,4},
  {{{0x6552ff59ec0b4123}},9,"F-H0-5494",911,3},
  {{{0x6552ff59ec0b4123}},9,"F-H0-5495",580,2},
  {{{0x186ae6a2bb3e1fb1}},11,"F-H0-5496",946,22},
  {{{0x186ae6a2bb3e1fb1}},11,"F-H0-5497",950,2},
  {{{0x44b7db749afc12d6}},5,"F-H0-5498",542,8},
  {{{0xf266fcfb2efcc04f}},5,"F-H0-5499",429,3},
  {{{0xf266fcfb2efcc04f}},5,"F-H0-5500",653,2},
  {{{0xf266fcfb2efcc04f}},5,"F-H0-5501",617,2},
  {{{0xf266fcfb2efcc04f}},5,"F-H0-5502",911,2},
  {{{0x235d34a856fe32f3}},6,"F-H0-5503",427,5},
  {{{0xf749f82c2b3e981b}},6,"F-H0-5504",467,3},
  {{{0xf749f82c2b3e981b}},6,"F-H0-5505",944,2},
  {{{0x69305e04887b66e6}},6,"F-H0-5506",875,2},
  {{{0xf749f82c2b3e981b}},6,"F-H0-5507",430,2},
  {{{0xb6417de5da8784c3}},8,"F-H0-5508",948,10},
  {{{0xb6417de5da8784c3}},8,"F-H0-5509",874,8},
  {{{0xb6417de5da8784c3}},8,"F-H0-5510",873,2},
  {{{0x83722ae36e263233}},9,"F-H0-5511",469,10},
  {{{0x4fa6fd1b56479022}},2,"F-H0-5512",468,9},
  {{{0xb768df99f81de72e}},2,"F-H0-5513",468,8},
  {{{0x4fa6fd1b56479022}},2,"F-H0-5514",419,3},
  {{{0x4fa6fd1b56479022}},2,"F-H0-5515",912,2},
  {{{0x2e8793e884c2a0c8}},8,"F-H0-5516",874,17},
  {{{0xd26199c032b2ade1}},8,"F-H0-5517",420,3},
  {{{0x78d047352ffe90ff}},9,"F-H0-5518",939,12},
  {{{0x78d047352ffe90ff}},9,"F-H0-5519",940,5},
  {{{0x6a0725cd9cc81e2a}},5,"F-H0-5520",839,12},
  {{{0xa02bae101e57432d}},5,"F-H0-5521",943,2},
  {{{0x40a3deb6a899678c}},4,"F-H0-5522",865,5},
  {{{0x40a3deb6a899678c}},4,"F-H0-5523",866,3},
  {{{0x14ed9c3d99045d7f}},4,"F-H0-5524",948,2},
  {{{0xeb42998af0c91b76}},5,"F-H0-5525",862,2},
  {{{0xb76ad06e044e0e83}},11,"F-H0-5526",801,15},
  {{{0xafdce762ccb9382d}},11,"F-H0-5527",418,2},
  {{{0xfb41369b06341ba4}},11,"F-H0-5528",470,2},
  {{{0x4798c5420396c41b}},6,"F-H0-5529",423,8},
  {{{0x14c79aa0afde5b31}},6,"F-H0-5530",902,6},
  {{{0x1b46295df8a7c55b}},6,"F-H0-5531",902,3},
  {{{0x4798c5420396c41b}},6,"F-H0-5532",906,2},
  {{{0x1b46295df8a7c55b}},6,"F-H0-5533",715,2},
  {{{0xe258927889aec3ba}},10,"F-H0-5534",906,16},
  {{{0xf61180669efda84f}},10,"F-H0-5535",691,6},
  {{{0xe258927889aec3ba}},10,"F-H0-5536",942,2},
  {{{0xc647622518a3a4f5}},6,"F-H0-5537",908,7},
  {{{0xc647622518a3a4f5}},6,"F-H0-5538",874,7},
  {{{0xc647622518a3a4f5}},6,"F-H0-5539",948,6},
  {{{0xa4e9ba3f1293f6fd}},6,"F-H0-5540",466,2},
  {{{0x94b1fe385dd08a4}},7,"F-H0-5541",939,13},
  {{{0x6176ece0816bcac4}},7,"F-H0-5542",456,6},
  {{{0x6613e5dad40fbfb9}},7,"F-H0-5543",949,5},
  {{{0x49533195eddc29e3}},4,"F-H0-5544",838,5},
  {{{0x49533195eddc29e3}},4,"F-H0-5545",543,4},
  {{{0x49533195eddc29e3}},4,"F-H0-5546",457,4},
  {{{0x49533195eddc29e3}},4,"F-H0-5547",421,4},
  {{{0x49533195eddc29e3}},4,"F-H0-5548",420,2},
  {{{0xca974148d36c58d4}},6,"F-H0-5549",418,10},
  {{{0x87dbf9783ee01cf5}},6,"F-H0-5550",503,8},
  {{{0xca974148d36c58d4}},6,"F-H0-5551",383,2},
  {{{0xfa694e7bd758b77d}},7,"F-H0-5552",872,6},
  {{{0xdaa128b31a5a3b37}},7,"F-H0-5553",946,4},
  {{{0xe106a3b6f87f33d9}},7,"F-H0-5554",466,2},
  {{{0xfa694e7bd758b77d}},7,"F-H0-5555",906,2},
  {{{0xeb650399ca691702}},4,"F-H0-5556",947,9},
  {{{0x35270448b9f40cb}},4,"F-H0-5557",468,4},
  {{{0xcd3d33139a5d5717}},4,"F-H0-5558",463,3},
  {{{0x62acb61c2c1fb88b}},9,"F-H0-5559",459,4},
  {{{0xdff9301fcc14979e}},9,"F-H0-5560",530,4},
  {{{0x2ba740a9eb8ac00e}},9,"F-H0-5561",947,2},
  {{{0x439e54d4e99d035a}},8,"F-H0-5562",874,14},
  {{{0x439e54d4e99d035a}},8,"F-H0-5563",912,3},
  {{{0x70982c11d6437951}},10,"F-H0-5564",462,13},
  {{{0x70982c11d6437951}},10,"F-H0-5565",425,9},
  {{{0x9ec13f3fc1c2d9d3}},7,"F-H0-5566",678,18},
  {{{0x9ec13f3fc1c2d9d3}},7,"F-H0-5567",715,3},
  {{{0x9ec13f3fc1c2d9d3}},7,"F-H0-5568",898,3},
  {{{0x258fc477e72e1c1a}},5,"F-H0-5569",825,10},
  {{{0xb86e908729afb98a}},5,"F-H0-5570",458,6},
  {{{0xb86e908729afb98a}},5,"F-H0-5571",603,4},
  {{{0x2b83b45da7697c64}},12,"F-H0-5572",899,2},
  {{{0x8246007084bc70c1}},12,"F-H0-5573",949,2},
  {{{0x5d6c9319bbb1176}},6,"F-H0-5574",529,4},
  {{{0x9d07529cfe3eba8d}},6,"F-H0-5575",906,3},
  {{{0x5d6c9319bbb1176}},6,"F-H0-5576",838,3},
  {{{0x33a4606b3ffe04f5}},6,"F-H0-5577",617,3},
  {{{0xe247c156a552e7e6}},6,"F-H0-5578",906,2},
  {{{0x9d07529cfe3eba8d}},6,"F-H0-5579",466,2},
  {{{0xe247c156a552e7e6}},6,"F-H0-5580",715,2},
  {{{0x5d6c9319bbb1176}},6,"F-H0-5581",837,2},
  {{{0x71c73f4d848b7d4c}},4,"F-H0-5582",505,7},
  {{{0x50cdaa8f0e61118}},4,"F-H0-5583",949,6},
  {{{0xa406dec52c6e48a0}},4,"F-H0-5584",906,2},
  {{{0x50cdaa8f0e61118}},4,"F-H0-5585",529,2},
  {{{0x4c082944da86982d}},8,"F-H0-5586",765,12},
  {{{0x5db0fc42ead6cb72}},8,"F-H0-5587",905,3},
  {{{0x3f24a83c4c27b56}},8,"F-H0-5588",839,3},
  {{{0x5db0fc42ead6cb72}},8,"F-H0-5589",906,2},
  {{{0x5189c155e1c7bf62}},10,"F-H0-5590",691,7},
  {{{0xe5f978663430581c}},10,"F-H0-5591",714,5},
  {{{0x5189c155e1c7bf62}},10,"F-H0-5592",578,5},
  {{{0x282cb2e7ff420e3d}},16,"F-H0-5593",838,7},
  {{{0x282cb2e7ff420e3d}},16,"F-H0-5594",839,7},
  {{{0x282cb2e7ff420e3d}},16,"F-H0-5595",802,3},
  {{{0x171dabdfae6ac10f}},16,"F-H0-5596",938,2},
  {{{0x58a12b86e3dd3897}},6,"F-H0-5597",394,16},
  {{{0x25cd8bd34fd92a95}},11,"F-H0-5598",950,17},
  {{{0x692c2b4ec37fbde}},11,"F-H0-5599",865,2},
  {{{0xfa9f694d18c9dfc0}},5,"F-H0-5600",902,8},
  {{{0xfa9f694d18c9dfc0}},5,"F-H0-5601",457,5},
  {{{0x3ca4093f7d375533}},3,"F-H0-5602",468,14},
  {{{0x3ca4093f7d375533}},3,"F-H0-5603",469,6},
  {{{0xca9f268cef62b5e4}},3,"F-H0-5604",839,4},
  {{{0xca9f268cef62b5e4}},3,"F-H0-5605",825,4},
  {{{0xca9f268cef62b5e4}},3,"F-H0-5606",947,3},
  {{{0xca9f268cef62b5e4}},3,"F-H0-5607",910,2},
  {{{0x551a34796a4ed98f}},6,"F-H0-5608",875,5},
  {{{0x5a462f4fb188603c}},6,"F-H0-5609",945,5},
  {{{0x5a462f4fb188603c}},6,"F-H0-5610",421,4},
  {{{0x2572207304276e1b}},6,"F-H0-5611",430,2},
  {{{0x6b9b338be04c1508}},6,"F-H0-5612",802,2},
  {{{0x5a462f4fb188603c}},6,"F-H0-5613",946,2},
  {{{0x637adcff69f36acb}},9,"F-H0-5614",945,6},
  {{{0x8fdfbda0227a1f50}},9,"F-H0-5615",461,5},
  {{{0xd9aea90c33e4f082}},9,"F-H0-5616",567,2},
  {{{0xd9aea90c33e4f082}},9,"F-H0-5617",467,2},
  {{{0x8fdfbda0227a1f50}},9,"F-H0-5618",580,2},
  {{{0x8fdfbda0227a1f50}},9,"F-H0-5619",684,2},
  {{{0x63050de1ad115e41}},7,"F-H0-5620",426,8},
  {{{0x63050de1ad115e41}},7,"F-H0-5621",566,4},
  {{{0x63050de1ad115e41}},7,"F-H0-5622",839,4},
  {{{0x63050de1ad115e41}},7,"F-H0-5623",943,3},
  {{{0x63050de1ad115e41}},7,"F-H0-5624",825,2},
  {{{0xdafed02e1b9c9a08}},3,"F-H0-5625",912,8},
  {{{0xfbffa0c0d2324a62}},3,"F-H0-5626",505,4},
  {{{0xfbffa0c0d2324a62}},3,"F-H0-5627",938,3},
  {{{0xdafed02e1b9c9a08}},3,"F-H0-5628",950,3},
  {{{0xdafed02e1b9c9a08}},3,"F-H0-5629",875,2},
  {{{0x46cb026702f7d713}},9,"F-H0-5630",937,19},
  {{{0xeb32f5021ba9f3cf}},5,"F-H0-5631",466,6},
  {{{0xeb32f5021ba9f3cf}},5,"F-H0-5632",911,4},
  {{{0xd827f29a3faf3d44}},5,"F-H0-5633",579,3},
  {{{0x515a0e20d86f6aaa}},5,"F-H0-5634",939,2},
  {{{0xeb32f5021ba9f3cf}},5,"F-H0-5635",948,2},
  {{{0x5603298da49d94e1}},4,"F-H0-5636",431,6},
  {{{0x82023c57d8426938}},4,"F-H0-5637",422,3},
  {{{0x9f6562e0e86b3596}},4,"F-H0-5638",604,3},
  {{{0x9f6562e0e86b3596}},4,"F-H0-5639",457,2},
  {{{0x9f6562e0e86b3596}},4,"F-H0-5640",468,2},
  {{{0xf773594ab7b6c829}},3,"F-H0-5641",949,2},
  {{{0xb15a3ae14c0af0a1}},3,"F-H0-5642",901,2},
  {{{0x474bd354e9ca3af}},6,"F-H0-5643",914,13},
  {{{0x9e54f0733d10dbfe}},6,"F-H0-5644",462,8},
  {{{0x194e0f974f2610c6}},8,"F-H0-5645",654,13},
  {{{0x53dc01a590598449}},8,"F-H0-5646",678,3},
  {{{0xf62e1ce26422c861}},8,"F-H0-5647",461,2},
  {{{0xf0da1501afb5e070}},6,"F-H0-5648",974,9},
  {{{0xc59c76feabb61739}},6,"F-H0-5649",875,2},
  {{{0x6b08209ae86c0644}},8,"F-H0-5650",431,15},
  {{{0x8b08bb2904bd9c66}},11,"F-H0-5651",640,18},
  {{{0x54bcc35a258516e4}},11,"F-H0-5652",870,2},
  {{{0x3d163cfbe4eddff9}},8,"F-H0-5653",543,14},
  {{{0x3d163cfbe4eddff9}},8,"F-H0-5654",691,5},
  {{{0x9e8c3feff85aef54}},5,"F-H0-5655",466,14},
  {{{0x3caaf6b3749f732e}},5,"F-H0-5656",529,4},
  {{{0x9e8c3feff85aef54}},5,"F-H0-5657",839,2},
  {{{0x9e8c3feff85aef54}},5,"F-H0-5658",617,2},
  {{{0x4bdd664bbe19d86}},7,"F-H0-5659",949,14},
  {{{0xff60066ca271caef}},7,"F-H0-5660",395,3},
  {{{0xa3a2dbed6fb440f2}},11,"F-H0-5661",840,14},
  {{{0xa3a2dbed6fb440f2}},11,"F-H0-5662",987,5},
  {{{0xe0a9bb9fd248f123}},5,"F-H0-5663",910,13},
  {{{0x81943f25e2a52fb0}},5,"F-H0-5664",839,3},
  {{{0x87fbfcc303f1324e}},5,"F-H0-5665",947,8},
  {{{0xc472148604ecfef4}},5,"F-H0-5666",905,3},
  {{{0x87fbfcc303f1324e}},5,"F-H0-5667",901,3},
  {{{0x87fbfcc303f1324e}},5,"F-H0-5668",765,3},
  {{{0x87fbfcc303f1324e}},5,"F-H0-5669",946,2},
  {{{0x1a35db232af84d0f}},8,"F-H0-5670",542,17},
  {{{0x1a35db232af84d0f}},8,"F-H0-5671",579,5},
  {{{0xf3e4e6f3721ec20a}},9,"F-H0-5672",950,9},
  {{{0x2c03faae5c274bae}},9,"F-H0-5673",418,8},
  {{{0xf3e4e6f3721ec20a}},9,"F-H0-5674",947,2},
  {{{0x2c03faae5c274bae}},9,"F-H0-5675",865,2},
  {{{0x1a662cfd00c4cf20}},4,"F-H0-5676",948,7},
  {{{0x58edd12fce8af868}},4,"F-H0-5677",530,6},
  {{{0x1a662cfd00c4cf20}},4,"F-H0-5678",456,2},
  {{{0x93cb5b7296e7ffcb}},9,"F-H0-5679",946,18},
  {{{0x93cb5b7296e7ffcb}},9,"F-H0-5680",909,3},
  {{{0x5667a3238d2e3cad}},9,"F-H0-5681",876,15},
  {{{0xf56512a79d1b4566}},9,"F-H0-5682",936,5},
  {{{0x39e6ef66184066ad}},5,"F-H0-5683",504,14},
  {{{0x37987c4cdcea4d92}},5,"F-H0-5684",542,5},
  {{{0x9cfafcf264ce023a}},5,"F-H0-5685",902,2},
  {{{0x934d7092a77f3eff}},10,"F-H0-5686",906,6},
  {{{0x934d7092a77f3eff}},10,"F-H0-5687",421,4},
  {{{0x934d7092a77f3eff}},10,"F-H0-5688",943,4},
  {{{0x8242fcf27c51466c}},9,"F-H0-5689",873,20},
  {{{0xe00cacf61ae51759}},7,"F-H0-5690",504,10},
  {{{0xe00cacf61ae51759}},7,"F-H0-5691",466,7},
  {{{0xe00cacf61ae51759}},7,"F-H0-5692",542,3},
  {{{0xbf2d0dffa5e3677b}},11,"F-H0-5693",429,17},
  {{{0x5ea5745e71ff2433}},11,"F-H0-5694",503,2},
  {{{0x30270f6846770cbd}},7,"F-H0-5695",946,22},
  {{{0x99261e6e04eb6aed}},4,"F-H0-5696",457,10},
  {{{0x99261e6e04eb6aed}},4,"F-H0-5697",690,3},
  {{{0x4a3803e6e0ee64e4}},4,"F-H0-5698",429,3},
  {{{0x111e962b441d1395}},9,"F-H0-5699",837,7},
  {{{0x111e962b441d1395}},9,"F-H0-5700",801,6},
  {{{0x111e962b441d1395}},9,"F-H0-5701",876,5},
  {{{0x111e962b441d1395}},9,"F-H0-5702",950,2},
  {{{0x111e962b441d1395}},9,"F-H0-5703",875,2},
  {{{0xe81f93be31436eb2}},5,"F-H0-5704",825,7},
  {{{0x3572404a6840272f}},5,"F-H0-5705",789,6},
  {{{0xe81f93be31436eb2}},5,"F-H0-5706",690,3},
  {{{0x3572404a6840272f}},5,"F-H0-5707",461,2},
  {{{0x2c742e8837609f64}},8,"F-H0-5708",910,10},
  {{{0x6203fc5ad1c71455}},8,"F-H0-5709",941,5},
  {{{0x398bd7d08ade99c0}},8,"F-H0-5710",529,3},
  {{{0x5398a252c3020146}},8,"F-H0-5711",678,2},
  {{{0x5398a252c3020146}},8,"F-H0-5712",432,2},
  {{{0xabc217a0c4c9a487}},8,"F-H0-5713",429,4},
  {{{0x991e883965c40da}},8,"F-H0-5714",753,2},
  {{{0x71179255721fa43b}},8,"F-H0-5715",726,2},
  {{{0x8f1eda8279ab9af3}},8,"F-H0-5716",677,2},
  {{{0xd868821e376ff9c9}},6,"F-H0-5717",469,22},
  {{{0x55bbec70a13affdf}},12,"F-H0-5718",839,14},
  {{{0xadb5096a3a8184d}},12,"F-H0-5719",863,3},
  {{{0xf19dd8858ed1fdf2}},5,"F-H0-5720",429,5},
  {{{0xf19dd8858ed1fdf2}},5,"F-H0-5721",466,5},
  {{{0xf19dd8858ed1fdf2}},5,"F-H0-5722",911,5},
  {{{0xf19dd8858ed1fdf2}},5,"F-H0-5723",617,3},
  {{{0xc8287fc7a929c58}},6,"F-H0-5724",529,4},
  {{{0xc8287fc7a929c58}},6,"F-H0-5725",945,4},
  {{{0x22052f6eeb6414a5}},6,"F-H0-5726",691,3},
  {{{0xc8287fc7a929c58}},6,"F-H0-5727",678,2},
  {{{0xc8287fc7a929c58}},6,"F-H0-5728",869,2},
  {{{0x6159c0c9016470fb}},6,"F-H0-5729",838,2},
  {{{0x6159c0c9016470fb}},6,"F-H0-5730",906,2},
  {{{0x336cbf0215aebf05}},9,"F-H0-5731",727,14},
  {{{0x47496584066434fc}},9,"F-H0-5732",454,6},
  {{{0xe5f78c6132b38a11}},7,"F-H0-5733",542,16},
  {{{0x5bcf5fd761f95094}},7,"F-H0-5734",789,2},
  {{{0x4d32f65a6ab28d88}},8,"F-H0-5735",424,17},
  {{{0x33bbed17574fd207}},8,"F-H0-5736",905,3},
  {{{0x84b8bd0acc04a35f}},10,"F-H0-5737",837,18},
  {{{0xd824f54ca9a7adab}},11,"F-H0-5738",912,20},
  {{{0xa3739bfaf4aaa82e}},4,"F-H0-5739",876,8},
  {{{0xa3739bfaf4aaa82e}},4,"F-H0-5740",839,6},
  {{{0x33b5f1c63d7640c3}},4,"F-H0-5741",419,5},
  {{{0xdff976a67a109c22}},9,"F-H0-5742",603,17},
  {{{0xdff976a67a109c22}},9,"F-H0-5743",420,2},
  {{{0x6ca4004b456ef4c7}},5,"F-H0-5744",543,20},
  {{{0xd9a5570f59aae3ea}},9,"F-H0-5745",939,10},
  {{{0xd9a5570f59aae3ea}},9,"F-H0-5746",462,4},
  {{{0xd9a5570f59aae3ea}},9,"F-H0-5747",603,4},
  {{{0x33c8350c2819f37d}},9,"F-H0-5748",947,2},
  {{{0xd9a5570f59aae3ea}},9,"F-H0-5749",567,2},
  {{{0xb04a5cd26364888a}},6,"F-H0-5750",429,9},
  {{{0xd91309c4302dc2c2}},6,"F-H0-5751",826,4},
  {{{0xb04a5cd26364888a}},6,"F-H0-5752",432,3},
  {{{0xdabcd8cac5f23c00}},6,"F-H0-5753",765,10},
  {{{0xed0c577a00ceefbc}},6,"F-H0-5754",902,4},
  {{{0xdabcd8cac5f23c00}},6,"F-H0-5755",727,2},
  {{{0xdabcd8cac5f23c00}},6,"F-H0-5756",874,2},
  {{{0xed0c577a00ceefbc}},6,"F-H0-5757",462,2},
  {{{0x419fa40594b34995}},9,"F-H0-5758",654,9},
  {{{0xd62e3b27719cfbae}},9,"F-H0-5759",908,5},
  {{{0x419fa40594b34995}},9,"F-H0-5760",506,4},
  {{{0x2ef0d527aef7c37e}},10,"F-H0-5761",901,23},
  {{{0x2b3ae102c060345a}},4,"F-H0-5762",431,8},
  {{{0x2b3ae102c060345a}},4,"F-H0-5763",468,4},
  {{{0x2b3ae102c060345a}},4,"F-H0-5764",862,4},
  {{{0x2b3ae102c060345a}},4,"F-H0-5765",752,3},
  {{{0x2b3ae102c060345a}},4,"F-H0-5766",902,2},
  {{{0x296c6ab7f3b36636}},18,"F-H0-5767",580,10},
  {{{0x573402f5af95e4e9}},18,"F-H0-5768",789,2},
  {{{0x573402f5af95e4e9}},18,"F-H0-5769",790,2},
  {{{0x29646e0ebde69a80}},18,"F-H0-5770",825,2},
  {{{0x725f72c449f61210}},6,"F-H0-5771",908,5},
  {{{0xee8b63b1719128e2}},6,"F-H0-5772",788,4},
  {{{0x13b15d3d53b766d2}},6,"F-H0-5773",543,3},
  {{{0xb4d456cb4baa05c0}},6,"F-H0-5774",863,3},
  {{{0x725f72c449f61210}},6,"F-H0-5775",945,2},
  {{{0x725f72c449f61210}},6,"F-H0-5776",838,2},
  {{{0xe62338ebf5d39d72}},9,"F-H0-5777",875,8},
  {{{0x64ff5f77b02cb222}},9,"F-H0-5778",908,6},
  {{{0xc9a4138a3c837c97}},5,"F-H0-5779",943,10},
  {{{0xda52b448443cb004}},5,"F-H0-5780",802,4},
  {{{0xc9a4138a3c837c97}},5,"F-H0-5781",825,4},
  {{{0xc9a4138a3c837c97}},5,"F-H0-5782",939,2},
  {{{0xbc2de38183b3f694}},7,"F-H0-5783",936,12},
  {{{0x78f7411fa1e652c4}},7,"F-H0-5784",904,6},
  {{{0xbc2de38183b3f694}},7,"F-H0-5785",839,2},
  {{{0x93dde35159f4644f}},8,"F-H0-5786",469,20},
  {{{0x376060be0214ccb5}},4,"F-H0-5787",431,8},
  {{{0x376060be0214ccb5}},4,"F-H0-5788",946,3},
  {{{0x376060be0214ccb5}},4,"F-H0-5789",909,2},
  {{{0x376060be0214ccb5}},4,"F-H0-5790",911,2},
  {{{0x376060be0214ccb5}},4,"F-H0-5791",908,2},
  {{{0xfb88d69b5245ec47}},5,"F-H0-5792",950,6},
  {{{0xfb88d69b5245ec47}},5,"F-H0-5793",421,4},
  {{{0xfb88d69b5245ec47}},5,"F-H0-5794",939,4},
  {{{0x99ad764e4c6d5dac}},8,"F-H0-5795",875,18},
  {{{0x1fcbf33b6f9e925}},8,"F-H0-5796",530,2},
  {{{0xa6e91e24fb0c786b}},4,"F-H0-5797",939,5},
  {{{0x59e3128238c0e4f4}},4,"F-H0-5798",911,4},
  {{{0xa6e91e24fb0c786b}},4,"F-H0-5799",421,3},
  {{{0x59e3128238c0e4f4}},4,"F-H0-5800",425,3},
  {{{0x59e3128238c0e4f4}},4,"F-H0-5801",948,2},
  {{{0x3e804ceae7f00e49}},5,"F-H0-5802",431,12},
  {{{0x52fd3237d16c4bf3}},5,"F-H0-5803",455,4},
  {{{0x5aa8ce45919be350}},6,"F-H0-5804",542,5},
  {{{0xa6ee22b357b9f285}},6,"F-H0-5805",678,4},
  {{{0x6dfcd21d9148131}},6,"F-H0-5806",905,4},
  {{{0xa6ee22b357b9f285}},6,"F-H0-5807",939,2},
  {{{0xa6ee22b357b9f285}},6,"F-H0-5808",751,2},
  {{{0xcef7c9590da02475}},6,"F-H0-5809",465,12},
  {{{0xcef7c9590da02475}},6,"F-H0-5810",503,5},
  {{{0xcef7c9590da02475}},6,"F-H0-5811",430,2},
  {{{0xb464a9b14f70147c}},10,"F-H0-5812",470,14},
  {{{0x3ef012deac37ad7b}},4,"F-H0-5813",912,4},
  {{{0x21b7bc10e0894ad2}},4,"F-H0-5814",937,4},
  {{{0x85b74bbcbef92800}},4,"F-H0-5815",911,2},
  {{{0xc3416566facf3995}},4,"F-H0-5816",876,2},
  {{{0x968ff71449bb219a}},8,"F-H0-5817",902,6},
  {{{0x9a0c21b99d5f4fc9}},8,"F-H0-5818",825,3},
  {{{0x968ff71449bb219a}},8,"F-H0-5819",751,2},
  {{{0x26bfb1caf640de49}},6,"F-H0-5820",466,8},
  {{{0x999b1297fcabc378}},6,"F-H0-5821",905,3},
  {{{0xf6ce03a00ad45c1c}},6,"F-H0-5822",543,2},
  {{{0x999b1297fcabc378}},6,"F-H0-5823",906,2},
  {{{0xf6ce03a00ad45c1c}},6,"F-H0-5824",939,2},
  {{{0xa8da1c6cbc0927a0}},6,"F-H0-5825",765,2},
  {{{0xa92987b66d835c0f}},14,"F-H0-5826",765,15},
  {{{0xa92987b66d835c0f}},14,"F-H0-5827",727,5},
  {{{0x3f88e5c574c974ff}},8,"F-H0-5828",653,14},
  {{{0xaf5e4bdddff601dc}},8,"F-H0-5829",454,2},
  {{{0x1588c4289c668f84}},5,"F-H0-5830",543,7},
  {{{0xf0a30d5e3af757e3}},5,"F-H0-5831",801,4},
  {{{0x624da5280359bf69}},8,"F-H0-5832",877,16},
  {{{0x624da5280359bf69}},8,"F-H0-5833",988,2},
  {{{0xefee02f567853fab}},6,"F-H0-5834",950,10},
  {{{0xefee02f567853fab}},6,"F-H0-5835",837,9},
  {{{0xb9313e2b51dd2880}},6,"F-H0-5836",951,19},
  {{{0x77b30fa95f44c427}},6,"F-H0-5837",765,6},
  {{{0x77b30fa95f44c427}},6,"F-H0-5838",838,4},
  {{{0x1273347a13dfe97f}},6,"F-H0-5839",902,3},
  {{{0x1273347a13dfe97f}},6,"F-H0-5840",715,3},
  {{{0x77b30fa95f44c427}},6,"F-H0-5841",837,2},
  {{{0x3ebaedaeb4ed7e91}},7,"F-H0-5842",458,18},
  {{{0x9f950bd434f6e947}},7,"F-H0-5843",429,3},
  {{{0x1be75e82bb992c33}},5,"F-H0-5844",825,6},
  {{{0x88052551c546c6d4}},5,"F-H0-5845",617,5},
  {{{0x1b46b46e314a495c}},5,"F-H0-5846",542,5},
  {{{0x13d23c2faa6d8aac}},5,"F-H0-5847",641,2},
  {{{0xf631436fede37e6d}},5,"F-H0-5848",421,2},
  {{{0xd4804304df36b137}},3,"F-H0-5849",456,14},
  {{{0xd4804304df36b137}},3,"F-H0-5850",419,5},
  {{{0x878a70bb2f05b29a}},3,"F-H0-5851",456,9},
  {{{0x878a70bb2f05b29a}},3,"F-H0-5852",455,7},
  {{{0x878a70bb2f05b29a}},3,"F-H0-5853",419,3},
  {{{0xfe45cc0710bc31d9}},7,"F-H0-5854",529,16},
  {{{0xfe45cc0710bc31d9}},7,"F-H0-5855",566,4},
  {{{0x26475fed6687218e}},3,"F-H0-5856",493,4},
  {{{0x9a32bc468ef153cf}},3,"F-H0-5857",876,3},
  {{{0x9c72dccde1951569}},5,"F-H0-5858",543,14},
  {{{0x9c72dccde1951569}},5,"F-H0-5859",906,5},
  {{{0x163b383795a35201}},5,"F-H0-5860",943,3},
  {{{0xb456f1f96d3e14f6}},5,"F-H0-5861",467,5},
  {{{0x5f993dfd577dc8d1}},5,"F-H0-5862",764,5},
  {{{0x5aaf4bd43094f4be}},5,"F-H0-5863",902,4},
  {{{0xb456f1f96d3e14f6}},5,"F-H0-5864",493,3},
  {{{0x919b20f2db349c0c}},15,"F-H0-5865",945,20},
  {{{0x78d987696b3edc2a}},9,"F-H0-5866",506,5},
  {{{0x271004955f1758b9}},9,"F-H0-5867",902,3},
  {{{0x8c641c9494c9c59b}},6,"F-H0-5868",429,12},
  {{{0x8c641c9494c9c59b}},6,"F-H0-5869",425,3},
  {{{0x6d482d11ffa7f66}},6,"F-H0-5870",543,3},
  {{{0xb7b567d4817f74de}},6,"F-H0-5871",945,2},
  {{{0xc007a84afe807059}},7,"F-H0-5872",432,9},
  {{{0x25fc963b13ebe61}},7,"F-H0-5873",939,4},
  {{{0xc007a84afe807059}},7,"F-H0-5874",580,3},
  {{{0x8ba91567ebc39368}},7,"F-H0-5875",458,16},
  {{{0xbcff3eda14c7d177}},7,"F-H0-5876",825,2},
  {{{0xbd3123d44cdb9c65}},6,"F-H0-5877",941,7},
  {{{0xbd3123d44cdb9c65}},6,"F-H0-5878",902,5},
  {{{0xe1d5e18f84f1adfd}},6,"F-H0-5879",727,3},
  {{{0xe1d5e18f84f1adfd}},6,"F-H0-5880",910,2},
  {{{0xe1d5e18f84f1adfd}},6,"F-H0-5881",678,2},
  {{{0x7d11a1b6297f0580}},6,"F-H0-5882",838,8},
  {{{0x7d11a1b6297f0580}},6,"F-H0-5883",911,3},
  {{{0x75fcd7b05a803f0a}},6,"F-H0-5884",421,3},
  {{{0x7d11a1b6297f0580}},6,"F-H0-5885",653,2},
  {{{0x5fccf7faca136f5c}},9,"F-H0-5886",873,11},
  {{{0x87339a1da42f1eec}},9,"F-H0-5887",788,2},
  {{{0xb45618998970d15c}},3,"F-H0-5888",826,4},
  {{{0xb45618998970d15c}},3,"F-H0-5889",936,3},
  {{{0xd1eda4bad60e856f}},3,"F-H0-5890",505,2},
  {{{0x13f41fa399cd4458}},3,"F-H0-5891",492,2},
  {{{0xd1eda4bad60e856f}},3,"F-H0-5892",456,2},
  {{{0xaa69b8859feb763}},9,"F-H0-5893",467,20},
  {{{0xb4ec07646c16e608}},6,"F-H0-5894",543,6},
  {{{0xc852a72e15320f88}},6,"F-H0-5895",788,3},
  {{{0xc852a72e15320f88}},6,"F-H0-5896",751,2},
  {{{0x473c1799f453799f}},8,"F-H0-5897",432,18},
  {{{0xb016077da10131b9}},7,"F-H0-5898",949,18},
  {{{0xb5d0d74a2d89be9}},5,"F-H0-5899",825,8},
  {{{0xdf0fefd1723e7d2f}},5,"F-H0-5900",825,5},
  {{{0xb5d0d74a2d89be9}},5,"F-H0-5901",826,2},
  {{{0xbdef15f0193f5545}},4,"F-H0-5902",942,8},
  {{{0x9a411f92d99a14be}},4,"F-H0-5903",469,4},
  {{{0xaad4c72ee1f683a}},4,"F-H0-5904",641,4},
  {{{0x9a411f92d99a14be}},4,"F-H0-5905",529,2},
  {{{0x515762edd71b28cb}},6,"F-H0-5906",876,14},
  {{{0x515762edd71b28cb}},6,"F-H0-5907",429,3},
  {{{0x515762edd71b28cb}},6,"F-H0-5908",947,2},
  {{{0x57c87bddf6e21d5d}},12,"F-H0-5909",907,8},
  {{{0x57c87bddf6e21d5d}},12,"F-H0-5910",909,7},
  {{{0x57c87bddf6e21d5d}},12,"F-H0-5911",908,4},
  {{{0x57c87bddf6e21d5d}},12,"F-H0-5912",987,2},
  {{{0xaa830b5cf0645782}},4,"F-H0-5913",420,9},
  {{{0x94112d75fd5b545c}},4,"F-H0-5914",493,3},
  {{{0x94112d75fd5b545c}},4,"F-H0-5915",947,3},
  {{{0x133b739ff648877a}},4,"F-H0-5916",506,2},
  {{{0x94112d75fd5b545c}},4,"F-H0-5917",839,2},
  {{{0x4980b27c6e8866b7}},5,"F-H0-5918",421,14},
  {{{0x495a2c04f6414a45}},5,"F-H0-5919",690,2},
  {{{0x518f5d40704b89a6}},5,"F-H0-5920",838,2},
  {{{0x92b698194c6a9c65}},12,"F-H0-5921",945,11},
  {{{0x78bef34ba4decd12}},12,"F-H0-5922",458,5},
  {{{0x6d8fcc7f1de39a}},12,"F-H0-5923",902,2},
  {{{0x92b698194c6a9c65}},12,"F-H0-5924",839,2},
  {{{0xdf18cd190da8eab0}},4,"F-H0-5925",505,16},
  {{{0xf3c880ac7eef4640}},4,"F-H0-5926",678,3},
  {{{0xdf18cd190da8eab0}},4,"F-H0-5927",506,2},
  {{{0x4a735ddb5aafd6aa}},4,"F-H0-5928",913,2},
  {{{0x5f6bf6536ffc9db9}},3,"F-H0-5929",900,13},
  {{{0xd19998a0fae2c8b1}},3,"F-H0-5930",913,5},
  {{{0xcc283a65e9f6171c}},9,"F-H0-5931",802,8},
  {{{0xe5887913661778d}},9,"F-H0-5932",939,4},
  {{{0xcc283a65e9f6171c}},9,"F-H0-5933",677,2},
  {{{0xe5887913661778d}},9,"F-H0-5934",679,2},
  {{{0x8017122ccc8cb0dc}},7,"F-H0-5935",418,9},
  {{{0x4e6746b21ddb5c38}},7,"F-H0-5936",427,3},
  {{{0x7f7cfd064908b517}},7,"F-H0-5937",493,2},
  {{{0x88c738b90b563565}},7,"F-H0-5938",568,2},
  {{{0x61e19f77b54e4ea7}},12,"F-H0-5939",678,20},
  {{{0x2ac1cdf304bd2011}},6,"F-H0-5940",616,11},
  {{{0x2ac1cdf304bd2011}},6,"F-H0-5941",653,2},
  {{{0x2ac1cdf304bd2011}},6,"F-H0-5942",467,2},
  {{{0x2ac1cdf304bd2011}},6,"F-H0-5943",466,2},
  {{{0x7e4133898a83ced0}},7,"F-H0-5944",466,21},
  {{{0x27849742251b5a5a}},7,"F-H0-5945",874,5},
  {{{0x97c02c973782c5b1}},7,"F-H0-5946",788,4},
  {{{0x39935b09fe0cc347}},7,"F-H0-5947",839,2},
  {{{0xa680af0b44ab4c54}},11,"F-H0-5948",507,19},
  {{{0x42fbdf40c6c23cf2}},12,"F-H0-5949",433,14},
  {{{0x26bb368bf414b9c}},3,"F-H0-5950",937,13},
  {{{0xa7dbcebd3f632368}},13,"F-H0-5951",506,19},
  {{{0xbe199257931860b0}},16,"F-H0-5952",872,14},
  {{{0xa65de81aecf88695}},16,"F-H0-5953",764,3},
  {{{0xa65de81aecf88695}},16,"F-H0-5954",579,2},
  {{{0x7d47dcf59ddb194e}},8,"F-H0-5955",469,21},
  {{{0x384b01931f9423f1}},12,"F-H0-5956",910,8},
  {{{0x384b01931f9423f1}},12,"F-H0-5957",691,4},
  {{{0x384b01931f9423f1}},12,"F-H0-5958",914,3},
  {{{0xb977fd6dd8de942b}},12,"F-H0-5959",789,2},
  {{{0x4e0f0d6833f6f79d}},6,"F-H0-5960",936,17},
  {{{0xd08f13eb7248a199}},7,"F-H0-5961",431,19},
  {{{0x27f6bf4c3c1009b9}},7,"F-H0-5962",864,13},
  {{{0x27f6bf4c3c1009b9}},7,"F-H0-5963",900,3},
  {{{0xb28313bc65323ae}},6,"F-H0-5964",529,8},
  {{{0xb84a7c9c476663c7}},6,"F-H0-5965",428,2},
  {{{0xb28313bc65323ae}},6,"F-H0-5966",764,2},
  {{{0xd2b03f2cf76cbbb5}},6,"F-H0-5967",690,2},
  {{{0xd4a909a2b80628ad}},9,"F-H0-5968",799,10},
  {{{0xe3b99d7316a422ac}},9,"F-H0-5969",678,4},
  {{{0xe3b99d7316a422ac}},9,"F-H0-5970",936,3},
  {{{0xc7e8e45de717e42}},9,"F-H0-5971",603,2},
  {{{0x5ca35aa922b94609}},8,"F-H0-5972",715,4},
  {{{0x7fa5635376b7ce4}},8,"F-H0-5973",838,3},
  {{{0x5ca35aa922b94609}},8,"F-H0-5974",678,3},
  {{{0x5ca35aa922b94609}},8,"F-H0-5975",902,3},
  {{{0xddde8c04f05f9433}},8,"F-H0-5976",945,2},
  {{{0x71792d7d475d8a49}},9,"F-H0-5977",505,19},
  {{{0x4716bdc7c9a1d5f2}},5,"F-H0-5978",825,9},
  {{{0x4716bdc7c9a1d5f2}},5,"F-H0-5979",801,3},
  {{{0x8e52be11f544bad2}},5,"F-H0-5980",678,3},
  {{{0xadecfc29287333da}},14,"F-H0-5981",907,20},
  {{{0xae26746ff67d47b3}},6,"F-H0-5982",690,9},
  {{{0x17157f9f0e956046}},6,"F-H0-5983",429,3},
  {{{0xae26746ff67d47b3}},6,"F-H0-5984",470,3},
  {{{0xcb825b4f198a7ba7}},11,"F-H0-5985",838,15},
  {{{0xaf0736deee7a393b}},8,"F-H0-5986",947,3},
  {{{0xaf0736deee7a393b}},8,"F-H0-5987",838,2},
  {{{0x73cd4a752a8c8be2}},3,"F-H0-5988",456,12},
  {{{0x4c17a4a50aca8e3}},3,"F-H0-5989",949,4},
  {{{0x6bc99c3ecaf18f12}},5,"F-H0-5990",429,4},
  {{{0x6bc99c3ecaf18f12}},5,"F-H0-5991",420,3},
  {{{0x6bc99c3ecaf18f12}},5,"F-H0-5992",825,3},
  {{{0x6bc99c3ecaf18f12}},5,"F-H0-5993",427,3},
  {{{0x6bc99c3ecaf18f12}},5,"F-H0-5994",943,2},
  {{{0x2a1b65ee3253f417}},7,"F-H0-5995",529,9},
  {{{0x2a1b65ee3253f417}},7,"F-H0-5996",566,7},
  {{{0x2a1b65ee3253f417}},7,"F-H0-5997",494,2},
  {{{0x1502cdda71ed3146}},14,"F-H0-5998",429,13},
  {{{0x5138f5052a33e2d9}},7,"F-H0-5999",432,8},
  {{{0x32548a91a46d76e8}},7,"F-H0-6000",566,5},
  {{{0x5138f5052a33e2d9}},7,"F-H0-6001",911,5},
  {{{0x2649ebcc867113e5}},6,"F-H0-6002",947,7},
  {{{0x2649ebcc867113e5}},6,"F-H0-6003",941,4},
  {{{0x2649ebcc867113e5}},6,"F-H0-6004",457,3},
  {{{0x29ff52e0260657e0}},6,"F-H0-6005",492,2},
  {{{0x2649ebcc867113e5}},6,"F-H0-6006",420,2},
  {{{0x8795c3158d958f85}},6,"F-H0-6007",765,2},
  {{{0x7f8e8f55df0de0f0}},4,"F-H0-6008",429,10},
  {{{0x7f8e8f55df0de0f0}},4,"F-H0-6009",456,4},
  {{{0x49d30413db78ed2f}},4,"F-H0-6010",913,2},
  {{{0x7f8e8f55df0de0f0}},4,"F-H0-6011",493,2},
  {{{0x7b9a462196976b87}},4,"F-H0-6012",839,7},
  {{{0xcdadf1e6ca021c56}},4,"F-H0-6013",765,4},
  {{{0xfc4b1e846f0071d7}},4,"F-H0-6014",542,3},
  {{{0xb348f06ced2db57f}},4,"F-H0-6015",468,2},
  {{{0x1e83a7506718ec48}},3,"F-H0-6016",469,13},
  {{{0xc7b0da4c8b311354}},11,"F-H0-6017",984,8},
  {{{0xd93391fa35a25fd5}},3,"F-H0-6018",468,6},
  {{{0xf4580799ef7f3f51}},3,"F-H0-6019",912,3},
  {{{0xd93391fa35a25fd5}},3,"F-H0-6020",419,2},
  {{{0x7b2e80021ff341c}},3,"F-H0-6021",456,14},
  {{{0xb70c2fdef5939e37}},3,"F-H0-6022",431,5},
  {{{0xbfeb6574d9cc111c}},13,"F-H0-6023",943,19},
  {{{0x5b93280515ff7073}},13,"F-H0-6024",504,8},
  {{{0x5b93280515ff7073}},13,"F-H0-6025",542,6},
  {{{0x5b93280515ff7073}},13,"F-H0-6026",466,5},
  {{{0x58bb657ba30ef552}},9,"F-H0-6027",654,4},
  {{{0x58bb657ba30ef552}},9,"F-H0-6028",506,2},
  {{{0x58bb657ba30ef552}},9,"F-H0-6029",616,2},
  {{{0x25c0c5c957580f86}},8,"F-H0-6030",418,18},
  {{{0xcc00fc3a65530f59}},8,"F-H0-6031",464,4},
  {{{0x61fec1cecc677762}},7,"F-H0-6032",874,8},
  {{{0x61fec1cecc677762}},7,"F-H0-6033",912,7},
  {{{0x61fec1cecc677762}},7,"F-H0-6034",911,5},
  {{{0x61fec1cecc677762}},7,"F-H0-6035",617,2},
  {{{0x8c2730c8db63781b}},8,"F-H0-6036",690,9},
  {{{0x1c49237c4bcf83d6}},8,"F-H0-6037",947,2},
  {{{0x354c1cedbb9a2449}},4,"F-H0-6038",839,7},
  {{{0xcbe0426f56ed0fd6}},4,"F-H0-6039",430,6},
  {{{0xcbe0426f56ed0fd6}},4,"F-H0-6040",839,6},
  {{{0x74c978bdcf7356de}},7,"F-H0-6041",947,9},
  {{{0x74c978bdcf7356de}},7,"F-H0-6042",837,3},
  {{{0xb554b6bf816f1ab5}},7,"F-H0-6043",826,2},
  {{{0xbdfaaf35e0dfe554}},5,"F-H0-6044",469,10},
  {{{0x7a2214e5dad30071}},5,"F-H0-6045",419,9},
  {{{0x237e327efa59ccd1}},6,"F-H0-6046",690,8},
  {{{0x4fee715061a9f46b}},6,"F-H0-6047",950,7},
  {{{0xc0a459ee3512b692}},6,"F-H0-6048",382,3},
  {{{0xfa1466260ad1e360}},6,"F-H0-6049",947,2},
  {{{0x208479d3a8a49874}},7,"F-H0-6050",911,8},
  {{{0x208479d3a8a49874}},7,"F-H0-6051",947,5},
  {{{0x208479d3a8a49874}},7,"F-H0-6052",910,4},
  {{{0x49f6c50373776a0d}},9,"F-H0-6053",950,12},
  {{{0x49f6c50373776a0d}},9,"F-H0-6054",873,5},
  {{{0x49f6c50373776a0d}},9,"F-H0-6055",908,2},
  {{{0x89d30516a6262057}},5,"F-H0-6056",949,12},
  {{{0x87973eb1874b26c5}},11,"F-H0-6057",873,11},
  {{{0x14665c2e0edb4f91}},11,"F-H0-6058",800,5},
  {{{0x1912224ab747a5db}},11,"F-H0-6059",827,3},
  {{{0x9c389d639e1d9767}},8,"F-H0-6060",911,17},
  {{{0x3d124a6821927c50}},8,"F-H0-6061",825,2},
  {{{0xff3d7715f118ebb}},5,"F-H0-6062",943,6},
  {{{0xff3d7715f118ebb}},5,"F-H0-6063",825,5},
  {{{0xff3d7715f118ebb}},5,"F-H0-6064",939,3},
  {{{0xad17dc498a2895ee}},5,"F-H0-6065",945,2},
  {{{0xff3d7715f118ebb}},5,"F-H0-6066",906,2},
  {{{0x6df99e302ad9daaa}},3,"F-H0-6067",456,9},
  {{{0xf38b7e31a3dc17af}},3,"F-H0-6068",949,4},
  {{{0x856db2d6ff7b4e8}},3,"F-H0-6069",875,2},
  {{{0xbb62f6fa0572eb8}},13,"F-H0-6070",862,17},
  {{{0x37b88a54dc5c3cd9}},5,"F-H0-6071",456,3},
  {{{0x37b88a54dc5c3cd9}},5,"F-H0-6072",872,2},
  {{{0xaa68736f8c6c2f04}},2,"F-H0-6073",913,5},
  {{{0xaa68736f8c6c2f04}},2,"F-H0-6074",456,4},
  {{{0x274fdc6fde196383}},2,"F-H0-6075",913,4},
  {{{0xaa68736f8c6c2f04}},2,"F-H0-6076",455,2},
  {{{0xaa68736f8c6c2f04}},2,"F-H0-6077",469,2},
  {{{0xaa68736f8c6c2f04}},2,"F-H0-6078",912,2},
  {{{0xf181cf8c22ce2487}},6,"F-H0-6079",506,5},
  {{{0xabf237c411eca3cd}},6,"F-H0-6080",936,4},
  {{{0xd8847741788ac73}},6,"F-H0-6081",567,4},
  {{{0xf181cf8c22ce2487}},6,"F-H0-6082",542,3},
  {{{0xabf237c411eca3cd}},6,"F-H0-6083",865,2},
  {{{0xf9d2d5141c31a29c}},2,"F-H0-6084",913,5},
  {{{0xf9d2d5141c31a29c}},2,"F-H0-6085",455,4},
  {{{0xc9f341f8c976ae78}},2,"F-H0-6086",468,3},
  {{{0x74f57a144e44ee1b}},2,"F-H0-6087",913,2},
  {{{0x74f57a144e44ee1b}},2,"F-H0-6088",912,2},
  {{{0x868a9bc0360a4f7b}},9,"F-H0-6089",838,11},
  {{{0x868a9bc0360a4f7b}},9,"F-H0-6090",579,2},
  {{{0x868a9bc0360a4f7b}},9,"F-H0-6091",950,2},
  {{{0x69bd04e5432ed77b}},9,"F-H0-6092",949,2},
  {{{0x2b459e3f8aacb831}},5,"F-H0-6093",947,8},
  {{{0x2b459e3f8aacb831}},5,"F-H0-6094",429,5},
  {{{0xd1a0a45c85c56c6e}},10,"F-H0-6095",394,20},
  {{{0xdcfe8058350f2956}},9,"F-H0-6096",543,7},
  {{{0xdcfe8058350f2956}},9,"F-H0-6097",903,5},
  {{{0xdcfe8058350f2956}},9,"F-H0-6098",802,4},
  {{{0xdcfe8058350f2956}},9,"F-H0-6099",573,2},
  {{{0xdcfe8058350f2956}},9,"F-H0-6100",910,2},
  {{{0x2620485790f22602}},3,"F-H0-6101",429,8},
  {{{0x9866892f0f4bd34b}},3,"F-H0-6102",468,3},
  {{{0x1a51ac7be548c14c}},3,"F-H0-6103",910,3},
  {{{0xb6dc1e5675bbfedc}},7,"F-H0-6104",678,11},
  {{{0xb6dc1e5675bbfedc}},7,"F-H0-6105",714,4},
  {{{0xb6dc1e5675bbfedc}},7,"F-H0-6106",898,3},
  {{{0xd3661f76d84d3f4a}},7,"F-H0-6107",461,2},
  {{{0x34d936510aa027c8}},9,"F-H0-6108",986,17},
  {{{0x34d936510aa027c8}},9,"F-H0-6109",910,3},
  {{{0x3f3a9bf841ea116f}},10,"F-H0-6110",544,16},
  {{{0xf10e3ddf49ba573b}},10,"F-H0-6111",951,4},
  {{{0x745deba2f2727657}},5,"F-H0-6112",943,11},
  {{{0x8d9a8a55d540cbc3}},5,"F-H0-6113",900,6},
  {{{0x8d9a8a55d540cbc3}},5,"F-H0-6114",462,2},
  {{{0x43a8a6733a376985}},8,"F-H0-6115",902,7},
  {{{0x43a8a6733a376985}},8,"F-H0-6116",543,4},
  {{{0xe0bd8346d1781c68}},8,"F-H0-6117",466,2},
  {{{0x43a8a6733a376985}},8,"F-H0-6118",684,2},
  {{{0xe959b7d250f12bb}},4,"F-H0-6119",912,11},
  {{{0xeb0857e1a53984}},4,"F-H0-6120",939,3},
  {{{0xbe213508751da364}},4,"F-H0-6121",939,5},
  {{{0xc49c0734d03242c}},4,"F-H0-6122",456,2},
  {{{0x7fea2d3c4f0bc8f1}},4,"F-H0-6123",617,2},
  {{{0xc49c0734d03242c}},4,"F-H0-6124",455,2},
  {{{0x5509925a67baed73}},4,"F-H0-6125",901,11},
  {{{0xe471f45c4cab7b4d}},4,"F-H0-6126",906,3},
  {{{0x4f28786f4062e2c0}},8,"F-H0-6127",470,19},
  {{{0x93c66529e13fda02}},7,"F-H0-6128",825,4},
  {{{0x93c66529e13fda02}},7,"F-H0-6129",677,2},
  {{{0xe0d23f9ea503aea9}},19,"F-H0-6130",838,4},
  {{{0x4b4fa6c9c1b9d837}},19,"F-H0-6131",866,3},
  {{{0x4b4fa6c9c1b9d837}},19,"F-H0-6132",874,3},
  {{{0x49508bf4319f6851}},19,"F-H0-6133",677,2},
  {{{0x991308576b27e191}},19,"F-H0-6134",899,2},
  {{{0x2f1461bfb2761f5f}},5,"F-H0-6135",839,8},
  {{{0xde1add87c1d695a5}},11,"F-H0-6136",876,7},
  {{{0x444d46e2aaf76b52}},11,"F-H0-6137",419,6},
  {{{0xde1add87c1d695a5}},11,"F-H0-6138",874,2},
  {{{0xac2b0952ea7078f8}},8,"F-H0-6139",837,19},
  {{{0x7ffcb6ed58c8d978}},12,"F-H0-6140",864,9},
  {{{0x307a2f59f7d3619e}},5,"F-H0-6141",900,5},
  {{{0x307a2f59f7d3619e}},5,"F-H0-6142",839,3},
  {{{0x990249677c3a0615}},5,"F-H0-6143",580,4},
  {{{0x25cbe87abba3c7ad}},5,"F-H0-6144",907,3},
  {{{0xe0c9b45fb2679ca5}},5,"F-H0-6145",764,3},
  {{{0x17a37ff3d7f01698}},5,"F-H0-6146",863,3},
  {{{0xe0c9b45fb2679ca5}},5,"F-H0-6147",728,2},
  {{{0xff554e016f39ff03}},5,"F-H0-6148",419,13},
  {{{0xff554e016f39ff03}},5,"F-H0-6149",457,4},
  {{{0x125a6aaf80e9c93d}},7,"F-H0-6150",911,7},
  {{{0x125a6aaf80e9c93d}},7,"F-H0-6151",949,4},
  {{{0x125a6aaf80e9c93d}},7,"F-H0-6152",825,4},
  {{{0x125a6aaf80e9c93d}},7,"F-H0-6153",874,2},
  {{{0x125a6aaf80e9c93d}},7,"F-H0-6154",939,2},
  {{{0x4dd2c8fea24c3d8e}},7,"F-H0-6155",944,12},
  {{{0x4dd2c8fea24c3d8e}},7,"F-H0-6156",906,3},
  {{{0x4dd2c8fea24c3d8e}},7,"F-H0-6157",943,2},
  {{{0xca73054678cbd4e3}},4,"F-H0-6158",913,5},
  {{{0x8f2b336a8a7309ac}},4,"F-H0-6159",904,3},
  {{{0x8f2b336a8a7309ac}},4,"F-H0-6160",938,3},
  {{{0xca73054678cbd4e3}},4,"F-H0-6161",912,2},
  {{{0xca73054678cbd4e3}},4,"F-H0-6162",788,2},
  {{{0x6464d9354b1fbb28}},4,"F-H0-6163",529,10},
  {{{0x6464d9354b1fbb28}},4,"F-H0-6164",906,4},
  {{{0xf52f88d2eea8d292}},4,"F-H0-6165",455,4},
  {{{0xf52f88d2eea8d292}},4,"F-H0-6166",456,4},
  {{{0xf52f88d2eea8d292}},4,"F-H0-6167",862,3},
  {{{0x793b40f52f83e927}},4,"F-H0-6168",839,11},
  {{{0x1e444e2e9f5054b4}},4,"F-H0-6169",947,5},
  {{{0x1e444e2e9f5054b4}},4,"F-H0-6170",909,3},
  {{{0xd84b8e2363466751}},4,"F-H0-6171",948,2},
  {{{0x940af1b4d2a754b3}},5,"F-H0-6172",543,7},
  {{{0x55df1d3b295eec8d}},5,"F-H0-6173",801,3},
  {{{0x55df1d3b295eec8d}},5,"F-H0-6174",690,3},
  {{{0x55df1d3b295eec8d}},5,"F-H0-6175",839,2},
  {{{0x14c42cc51ebd19d3}},13,"F-H0-6176",567,2},
  {{{0x784541e18a2bc05a}},10,"F-H0-6177",912,18},
  {{{0xb548bcbeed4fa92f}},9,"F-H0-6178",505,17},
  {{{0xe2065f18afa0b08d}},16,"F-H0-6179",902,7},
  {{{0xe2065f18afa0b08d}},16,"F-H0-6180",751,5},
  {{{0xe1b708e986c82a10}},16,"F-H0-6181",727,4},
  {{{0xe1b708e986c82a10}},16,"F-H0-6182",946,2},
  {{{0x33c53f3625e1f161}},6,"F-H0-6183",947,9},
  {{{0x33c53f3625e1f161}},6,"F-H0-6184",529,4},
  {{{0x6b69767c02ac8847}},6,"F-H0-6185",529,2},
  {{{0x6b69767c02ac8847}},6,"F-H0-6186",941,2},
  {{{0x33c53f3625e1f161}},6,"F-H0-6187",678,2},
  {{{0x1929f88d30f20270}},8,"F-H0-6188",945,9},
  {{{0x1929f88d30f20270}},8,"F-H0-6189",529,5},
  {{{0x1929f88d30f20270}},8,"F-H0-6190",946,2},
  {{{0x4a16bdf0576d76e9}},5,"F-H0-6191",801,7},
  {{{0x4a16bdf0576d76e9}},5,"F-H0-6192",876,2},
  {{{0x2daf59fd5cc8d45f}},4,"F-H0-6193",945,5},
  {{{0x316eaf90d7c6bf6}},4,"F-H0-6194",911,2},
  {{{0x316eaf90d7c6bf6}},4,"F-H0-6195",910,2},
  {{{0xd89271dcf416c31c}},9,"F-H0-6196",911,6},
  {{{0xd89271dcf416c31c}},9,"F-H0-6197",617,3},
  {{{0xd89271dcf416c31c}},9,"F-H0-6198",910,2},
  {{{0x60505c630314e4ce}},9,"F-H0-6199",873,18},
  {{{0x7c803e67d3b328a3}},3,"F-H0-6200",468,4},
  {{{0x1cd9c785425fa511}},3,"F-H0-6201",913,4},
  {{{0x7c803e67d3b328a3}},3,"F-H0-6202",948,3},
  {{{0xdf54d6c35542cef5}},3,"F-H0-6203",467,3},
  {{{0xe16b92c1ab7bd94c}},3,"F-H0-6204",493,2},
  {{{0x2a6aa5dc2333ad47}},11,"F-H0-6205",825,12},
  {{{0x1a69b28e430cb6d0}},11,"F-H0-6206",939,7},
  {{{0x1c6d4e160921e7e}},12,"F-H0-6207",504,7},
  {{{0x2b4c5ed67ec67da1}},13,"F-H0-6208",506,17},
  {{{0x9ad98d8d079840e9}},6,"F-H0-6209",529,5},
  {{{0x7e7e7b71ab2f7bfa}},6,"F-H0-6210",765,3},
  {{{0x6a9e84edd204ded}},6,"F-H0-6211",463,3},
  {{{0x9ad98d8d079840e9}},6,"F-H0-6212",910,2},
  {{{0x7e7e7b71ab2f7bfa}},6,"F-H0-6213",420,2},
  {{{0x75875f1a65d6639f}},3,"F-H0-6214",468,6},
  {{{0x53096dadc9db5791}},3,"F-H0-6215",913,6},
  {{{0x7fffce84ad17f180}},4,"F-H0-6216",949,7},
  {{{0xeb2aba2857aa47ec}},4,"F-H0-6217",948,4},
  {{{0xeb2aba2857aa47ec}},4,"F-H0-6218",492,2},
  {{{0xeb2aba2857aa47ec}},4,"F-H0-6219",493,2},
  {{{0xd6c9eeb386e654be}},5,"F-H0-6220",911,9},
  {{{0x81fd8aeca566ecac}},5,"F-H0-6221",529,4},
  {{{0xd6c9eeb386e654be}},5,"F-H0-6222",943,3},
  {{{0xd6c9eeb386e654be}},5,"F-H0-6223",910,2},
  {{{0x89e786d38d9c87a}},4,"F-H0-6224",826,2},
  {{{0x7624e3b4a23d333e}},4,"F-H0-6225",839,2},
  {{{0x89e786d38d9c87a}},4,"F-H0-6226",906,2},
  {{{0xe521fec7332847e3}},8,"F-H0-6227",465,16},
  {{{0xbdc981b7f343b0b6}},15,"F-H0-6228",839,13},
  {{{0xbdc981b7f343b0b6}},15,"F-H0-6229",542,3},
  {{{0x2e70730e986d5eed}},6,"F-H0-6230",430,10},
  {{{0xf4d706b7d253218f}},6,"F-H0-6231",421,8},
  {{{0x66f20cd2efa71ecc}},5,"F-H0-6232",429,7},
  {{{0x66f20cd2efa71ecc}},5,"F-H0-6233",466,4},
  {{{0x993b6e02a3b04d10}},5,"F-H0-6234",863,2},
  {{{0x993b6e02a3b04d10}},5,"F-H0-6235",907,2},
  {{{0x15933538b01bc264}},6,"F-H0-6236",950,10},
  {{{0x331a7c54248c3c9b}},6,"F-H0-6237",531,6},
  {{{0xf5505667bdca0a}},6,"F-H0-6238",861,2},
  {{{0x331a7c54248c3c9b}},6,"F-H0-6239",567,2},
  {{{0xa3d08a6ebe7a7e90}},5,"F-H0-6240",429,10},
  {{{0x54bd489783fa7708}},5,"F-H0-6241",839,5},
  {{{0x2b227fdefc9a92a4}},16,"F-H0-6242",764,7},
  {{{0x3e03c5a08eb4f703}},16,"F-H0-6243",395,2},
  {{{0x8cb96f1afc8212c1}},10,"F-H0-6244",837,6},
  {{{0xfa6aeb674966a8f3}},8,"F-H0-6245",941,15},
  {{{0xfa6aeb674966a8f3}},8,"F-H0-6246",825,3},
  {{{0x9e13d2fbba76cf70}},5,"F-H0-6247",862,7},
  {{{0x9e13d2fbba76cf70}},5,"F-H0-6248",863,3},
  {{{0x9e13d2fbba76cf70}},5,"F-H0-6249",420,3},
  {{{0x43cdcdfcb65c04ad}},11,"F-H0-6250",872,9},
  {{{0x38c17494f3bd4725}},11,"F-H0-6251",976,2},
  {{{0xcd57bd355d08feb4}},10,"F-H0-6252",911,5},
  {{{0xac957ffe876c953c}},8,"F-H0-6253",904,7},
  {{{0xd713a3960daf679b}},8,"F-H0-6254",605,5},
  {{{0xd713a3960daf679b}},8,"F-H0-6255",418,4},
  {{{0xd6bde56f1c38b8cb}},8,"F-H0-6256",461,2},
  {{{0x8d1cb07b1e4df26d}},11,"F-H0-6257",947,16},
  {{{0xd9d16bcbe0d66d09}},11,"F-H0-6258",493,2},
  {{{0x86f5dc7a4114640a}},7,"F-H0-6259",906,15},
  {{{0xc9fcd8938f8bc5}},7,"F-H0-6260",898,2},
  {{{0xc9fcd8938f8bc5}},7,"F-H0-6261",715,2},
  {{{0x636bf2dbe21ae7db}},5,"F-H0-6262",862,3},
  {{{0x7c265657b623595c}},5,"F-H0-6263",530,3},
  {{{0x7c265657b623595c}},5,"F-H0-6264",423,2},
  {{{0x4bafd2e4af120ef0}},5,"F-H0-6265",543,2},
  {{{0xa611d9bbd7c3fe11}},13,"F-H0-6266",836,10},
  {{{0xa611d9bbd7c3fe11}},13,"F-H0-6267",950,7},
  {{{0x2c7ecc33ef0d1316}},7,"F-H0-6268",466,6},
  {{{0xb0067d32c735ecda}},7,"F-H0-6269",911,5},
  {{{0xb0067d32c735ecda}},7,"F-H0-6270",421,2},
  {{{0x50d26340ba3e409c}},5,"F-H0-6271",905,3},
  {{{0x50d26340ba3e409c}},5,"F-H0-6272",791,3},
  {{{0xd32e273027afe7a}},5,"F-H0-6273",986,2},
  {{{0x486aadcdefbe1752}},12,"F-H0-6274",949,12},
  {{{0x486aadcdefbe1752}},12,"F-H0-6275",913,6},
  {{{0xea86597a3478e085}},14,"F-H0-6276",543,20},
  {{{0x3c1f94ebfbb98191}},3,"F-H0-6277",910,3},
  {{{0x6d11c8e926eadf34}},3,"F-H0-6278",912,2},
  {{{0x557e97bf284784d0}},10,"F-H0-6279",941,15},
  {{{0x4f8c250c1d5a8d25}},11,"F-H0-6280",911,10},
  {{{0x4f8c250c1d5a8d25}},11,"F-H0-6281",424,2},
  {{{0x4f8c250c1d5a8d25}},11,"F-H0-6282",579,2},
  {{{0x4f8c250c1d5a8d25}},11,"F-H0-6283",825,2},
  {{{0x363920764cffc837}},6,"F-H0-6284",432,8},
  {{{0x363920764cffc837}},6,"F-H0-6285",429,7},
  {{{0x7d158d451c4d2e37}},13,"F-H0-6286",430,19},
  {{{0x83c88ac4d9935d27}},6,"F-H0-6287",949,8},
  {{{0x83c88ac4d9935d27}},6,"F-H0-6288",945,7},
  {{{0x93a7c9da443fe08f}},15,"F-H0-6289",466,7},
  {{{0x24060fdaf200b4f}},15,"F-H0-6290",911,4},
  {{{0x24060fdaf200b4f}},15,"F-H0-6291",502,3},
  {{{0x45db4d4aece37479}},5,"F-H0-6292",429,5},
  {{{0x45db4d4aece37479}},5,"F-H0-6293",690,3},
  {{{0x3b9347d00044d218}},5,"F-H0-6294",461,2},
  {{{0x9baa11ebff7f987f}},5,"F-H0-6295",941,2},
  {{{0x45db4d4aece37479}},5,"F-H0-6296",838,2},
  {{{0xf2ca03337658d4c9}},9,"F-H0-6297",690,14},
  {{{0xf2ca03337658d4c9}},9,"F-H0-6298",455,2},
  {{{0x2183d8e249a53029}},4,"F-H0-6299",543,3},
  {{{0x30de618316b55efb}},4,"F-H0-6300",456,3},
  {{{0x30de618316b55efb}},4,"F-H0-6301",826,2},
  {{{0x30de618316b55efb}},4,"F-H0-6302",902,2},
  {{{0x30de618316b55efb}},4,"F-H0-6303",751,2},
  {{{0x4a317daad6fd68bb}},8,"F-H0-6304",908,11},
  {{{0x4a317daad6fd68bb}},8,"F-H0-6305",946,2},
  {{{0x8beb2b97d56c52a8}},8,"F-H0-6306",494,2},
  {{{0x4a317daad6fd68bb}},8,"F-H0-6307",948,2},
  {{{0xfd5c6ed3351730d4}},4,"F-H0-6308",543,5},
  {{{0xb20c362bcc28f9da}},4,"F-H0-6309",425,4},
  {{{0x465cdae320b020}},9,"F-H0-6310",839,9},
  {{{0x465cdae320b020}},9,"F-H0-6311",939,4},
  {{{0x79a1506492e0f19c}},9,"F-H0-6312",825,2},
  {{{0x6ce5f98e2a04d10e}},4,"F-H0-6313",468,7},
  {{{0xf6cb1022301a6553}},4,"F-H0-6314",455,3},
  {{{0x58be9573ddf5edbe}},4,"F-H0-6315",604,3},
  {{{0x8938728d98f94125}},6,"F-H0-6316",948,6},
  {{{0x717acb9c942b968f}},6,"F-H0-6317",715,3},
  {{{0x8938728d98f94125}},6,"F-H0-6318",838,3},
  {{{0x8938728d98f94125}},6,"F-H0-6319",949,2},
  {{{0x8938728d98f94125}},6,"F-H0-6320",945,2},
  {{{0x98e7012d302103e3}},10,"F-H0-6321",421,14},
  {{{0x4780fabdccec4ffb}},10,"F-H0-6322",906,2},
  {{{0xb1be00c18822b5b2}},10,"F-H0-6323",947,12},
  {{{0xb1be00c18822b5b2}},10,"F-H0-6324",950,3},
  {{{0xc3f2dbd95646b986}},10,"F-H0-6325",382,2},
  {{{0x45ede87ec33952e6}},4,"F-H0-6326",899,5},
  {{{0xb171a574a1fb4860}},13,"F-H0-6327",470,7},
  {{{0xb171a574a1fb4860}},13,"F-H0-6328",506,2},
  {{{0xf4cf49b89c13c772}},13,"F-H0-6329",906,2},
  {{{0xb20d6c1bde549a97}},8,"F-H0-6330",424,9},
  {{{0x70339c44ed3e6b46}},6,"F-H0-6331",908,5},
  {{{0x29fee945ce80b381}},6,"F-H0-6332",714,4},
  {{{0x70339c44ed3e6b46}},6,"F-H0-6333",909,3},
  {{{0x70339c44ed3e6b46}},6,"F-H0-6334",875,2},
  {{{0x70339c44ed3e6b46}},6,"F-H0-6335",943,2},
  {{{0x52274768dbbee96}},9,"F-H0-6336",873,10},
  {{{0x195227599ed854b}},7,"F-H0-6337",910,12},
  {{{0x35d3c6d569172950}},7,"F-H0-6338",543,3},
  {{{0x35d3c6d569172950}},7,"F-H0-6339",463,2},
  {{{0x868685851fb07aa8}},7,"F-H0-6340",936,9},
  {{{0x868685851fb07aa8}},7,"F-H0-6341",752,3},
  {{{0x868685851fb07aa8}},7,"F-H0-6342",678,2},
  {{{0xe588ec4ed3befb17}},6,"F-H0-6343",470,6},
  {{{0xbef527b18bd66b05}},6,"F-H0-6344",906,5},
  {{{0xe588ec4ed3befb17}},6,"F-H0-6345",691,2},
  {{{0xe588ec4ed3befb17}},6,"F-H0-6346",653,2},
  {{{0xe588ec4ed3befb17}},6,"F-H0-6347",949,2},
  {{{0xa6b531df0c1d9f77}},6,"F-H0-6348",909,9},
  {{{0xaad7f490b5c2231}},6,"F-H0-6349",837,6},
  {{{0xc210d2c95223f07a}},4,"F-H0-6350",876,9},
  {{{0x121cb8f1c09a61d7}},4,"F-H0-6351",875,4},
  {{{0xc210d2c95223f07a}},4,"F-H0-6352",467,2},
  {{{0x772e42e979208b57}},6,"F-H0-6353",421,15},
  {{{0x780878a40130a6d4}},7,"F-H0-6354",495,10},
  {{{0xce45084de5f7f14d}},7,"F-H0-6355",947,4},
  {{{0x780878a40130a6d4}},7,"F-H0-6356",418,4},
  {{{0x5c627db1c1d5f247}},9,"F-H0-6357",876,19},
  {{{0x97af4ed234ce4b54}},6,"F-H0-6358",801,4},
  {{{0x3fba369ff65a4cd7}},6,"F-H0-6359",543,3},
  {{{0x87446bebf6c6d639}},6,"F-H0-6360",500,2},
  {{{0x3fba369ff65a4cd7}},6,"F-H0-6361",947,2},
  {{{0x83dc44624caedc24}},9,"F-H0-6362",431,11},
  {{{0x83dc44624caedc24}},9,"F-H0-6363",506,4},
  {{{0x3f1ece5302c648e1}},3,"F-H0-6364",685,9},
  {{{0x5f447dc8584d0551}},11,"F-H0-6365",912,10},
  {{{0xf469d77fccb80d6c}},6,"F-H0-6366",715,4},
  {{{0xf469d77fccb80d6c}},6,"F-H0-6367",902,4},
  {{{0xf469d77fccb80d6c}},6,"F-H0-6368",604,2},
  {{{0xf469d77fccb80d6c}},6,"F-H0-6369",751,2},
  {{{0x806cc5c2572411dc}},6,"F-H0-6370",653,2},
  {{{0x806cc5c2572411dc}},6,"F-H0-6371",467,2},
  {{{0xf469d77fccb80d6c}},6,"F-H0-6372",939,2},
  {{{0x1f4cdcb5af72609b}},8,"F-H0-6373",567,15},
  {{{0xef347cf360def61e}},8,"F-H0-6374",803,3},
  {{{0x1f4cdcb5af72609b}},8,"F-H0-6375",530,2},
  {{{0xfee94a21e4f37c87}},5,"F-H0-6376",910,5},
  {{{0xbb7d463be2b754d7}},5,"F-H0-6377",950,4},
  {{{0xfee94a21e4f37c87}},5,"F-H0-6378",911,4},
  {{{0x10ec6362221f039a}},2,"F-H0-6379",948,3},
  {{{0x10ec6362221f039a}},2,"F-H0-6380",912,3},
  {{{0x22681d16b2c4d45e}},2,"F-H0-6381",469,2},
  {{{0xf2051e3afbac6b8d}},6,"F-H0-6382",543,17},
  {{{0xf2051e3afbac6b8d}},6,"F-H0-6383",468,3},
  {{{0xc9e114bc08d60ef8}},7,"F-H0-6384",504,5},
  {{{0xcfd669ef671ffeff}},7,"F-H0-6385",493,3},
  {{{0xdbe5d93dd127f96a}},7,"F-H0-6386",874,7},
  {{{0xdbe5d93dd127f96a}},7,"F-H0-6387",875,5},
  {{{0xd1abdabd0f094a9c}},5,"F-H0-6388",908,6},
  {{{0xa051a41c12ab1633}},5,"F-H0-6389",420,3},
  {{{0xe2ab5d09bc6dc328}},5,"F-H0-6390",566,3},
  {{{0xbdfac09d0a33cc57}},5,"F-H0-6391",874,2},
  {{{0xb02f7b60e5a2cc2}},9,"F-H0-6392",432,20},
  {{{0x96b3ecca74d4a875}},11,"F-H0-6393",393,19},
  {{{0x3a31be4dd043b7ea}},9,"F-H0-6394",950,15},
  {{{0x71612e1ce5e02a59}},9,"F-H0-6395",580,2},
  {{{0x168d9d97afca1cc0}},5,"F-H0-6396",431,7},
  {{{0xf9c934ee03526d26}},5,"F-H0-6397",429,5},
  {{{0xf9c934ee03526d26}},5,"F-H0-6398",466,5},
  {{{0x5a980e6899829468}},5,"F-H0-6399",603,3},
  {{{0xf03a386ab68373bf}},5,"F-H0-6400",715,2},
  {{{0xf65a5c4ee9fa61b0}},10,"F-H0-6401",655,19},
  {{{0xec09a0d6b53dcfb4}},8,"F-H0-6402",394,14},
  {{{0xec09a0d6b53dcfb4}},8,"F-H0-6403",462,2},
  {{{0x42a088e9ba6c48d0}},7,"F-H0-6404",469,13},
  {{{0x42a088e9ba6c48d0}},7,"F-H0-6405",395,3},
  {{{0x66283cb7f4670789}},5,"F-H0-6406",862,9},
  {{{0xae1b35f4bf68aca9}},5,"F-H0-6407",493,3},
  {{{0x66283cb7f4670789}},5,"F-H0-6408",825,2},
  {{{0x35d8c522cee4ab5d}},10,"F-H0-6409",457,5},
  {{{0x64a8cdd3847e824c}},10,"F-H0-6410",788,3},
  {{{0x35d8c522cee4ab5d}},10,"F-H0-6411",497,2},
  {{{0x7bfa1ac3118c904a}},12,"F-H0-6412",950,12},
  {{{0x7bfa1ac3118c904a}},12,"F-H0-6413",800,2},
  {{{0x86d4538a68ccda09}},10,"F-H0-6414",837,14},
  {{{0xd9a6bd5c4eb4c7f7}},6,"F-H0-6415",690,11},
  {{{0xd9a6bd5c4eb4c7f7}},6,"F-H0-6416",653,6},
  {{{0xd4277b2d1d6cd4a9}},5,"F-H0-6417",908,5},
  {{{0x3fb9f99c0f3af2a0}},5,"F-H0-6418",492,5},
  {{{0xd4277b2d1d6cd4a9}},5,"F-H0-6419",493,2},
  {{{0xe7b84ea745dfc430}},8,"F-H0-6420",949,18},
  {{{0x8e260459df04ce5c}},11,"F-H0-6421",942,9},
  {{{0x8e260459df04ce5c}},11,"F-H0-6422",976,6},
  {{{0x11948e9f675c7cb1}},9,"F-H0-6423",529,11},
  {{{0x1a4b93b1233eb064}},9,"F-H0-6424",984,8},
  {{{0x117aab1c108be1cd}},5,"F-H0-6425",418,17},
  {{{0x679fee3e0f995720}},12,"F-H0-6426",728,17},
  {{{0xb07f82e2fa6f8e5f}},4,"F-H0-6427",939,11},
  {{{0x59c283512b40705c}},4,"F-H0-6428",456,5},
  {{{0x97955d1fa4a2f67d}},7,"F-H0-6429",873,10},
  {{{0x67331fe206788c24}},7,"F-H0-6430",950,7},
  {{{0x70bb7d14345586ac}},6,"F-H0-6431",690,8},
  {{{0x95ed81c454c61d8e}},6,"F-H0-6432",394,2},
  {{{0xdb704b21bc1714a7}},7,"F-H0-6433",826,16},
  {{{0xcfd4646099a57454}},10,"F-H0-6434",936,15},
  {{{0xa7287aec0a454173}},7,"F-H0-6435",911,7},
  {{{0xa7287aec0a454173}},7,"F-H0-6436",943,3},
  {{{0xa7287aec0a454173}},7,"F-H0-6437",690,2},
  {{{0xa7287aec0a454173}},7,"F-H0-6438",947,2},
  {{{0x4ff13ab2cb29ed8a}},7,"F-H0-6439",691,2},
  {{{0x76708105f16efc83}},10,"F-H0-6440",432,6},
  {{{0x76708105f16efc83}},10,"F-H0-6441",458,5},
  {{{0xa479b981f9f3b7cd}},5,"F-H0-6442",530,6},
  {{{0x6313b86181ce3b3a}},5,"F-H0-6443",950,3},
  {{{0x94a6f1e22c085546}},5,"F-H0-6444",901,3},
  {{{0xa479b981f9f3b7cd}},5,"F-H0-6445",529,2},
  {{{0x1124601032dbbdc4}},4,"F-H0-6446",529,3},
  {{{0x1124601032dbbdc4}},4,"F-H0-6447",543,2},
  {{{0x674f21b28418a126}},6,"F-H0-6448",418,14},
  {{{0x57d702f005f28689}},12,"F-H0-6449",839,13},
  {{{0x8d85d46d84d8625c}},7,"F-H0-6450",936,9},
  {{{0xa759e71e9a819ae6}},7,"F-H0-6451",947,5},
  {{{0xa759e71e9a819ae6}},7,"F-H0-6452",837,4},
  {{{0xf5ccd6a67cbfcfff}},9,"F-H0-6453",944,7},
  {{{0xf5ccd6a67cbfcfff}},9,"F-H0-6454",945,7},
  {{{0x851ee64b4fefdba0}},7,"F-H0-6455",825,7},
  {{{0x851ee64b4fefdba0}},7,"F-H0-6456",678,6},
  {{{0xec74ff87afa3ca8c}},7,"F-H0-6457",425,2},
  {{{0xdf0e3e2cc61dca48}},9,"F-H0-6458",419,18},
  {{{0x4e9ca92fb40af50c}},9,"F-H0-6459",420,7},
  {{{0x547be41d6aa02360}},9,"F-H0-6460",540,5},
  {{{0x547be41d6aa02360}},9,"F-H0-6461",839,3},
  {{{0xc8aaefba018fce79}},6,"F-H0-6462",543,5},
  {{{0xc8aaefba018fce79}},6,"F-H0-6463",678,4},
  {{{0x12c57d6d4841e8be}},6,"F-H0-6464",690,3},
  {{{0xa721033820d1790d}},6,"F-H0-6465",684,2},
  {{{0x1d8178bf35a889a2}},7,"F-H0-6466",690,12},
  {{{0x1d8178bf35a889a2}},7,"F-H0-6467",914,3},
  {{{0x81e389d19f87a809}},10,"F-H0-6468",910,11},
  {{{0x81e389d19f87a809}},10,"F-H0-6469",907,5},
  {{{0x438a80dd5f90f9ab}},5,"F-H0-6470",493,9},
  {{{0x438a80dd5f90f9ab}},5,"F-H0-6471",492,4},
  {{{0xdc04db893b7cbaef}},5,"F-H0-6472",906,2},
  {{{0xceb5aa3c313c41df}},7,"F-H0-6473",909,12},
  {{{0xa41197d3bd602d23}},12,"F-H0-6474",395,20},
  {{{0x941c302270cb080d}},5,"F-H0-6475",950,9},
  {{{0xa0185581d3681940}},5,"F-H0-6476",543,3},
  {{{0x77068fe9e7973319}},5,"F-H0-6477",543,2},
  {{{0x9065a5ef4a3ffa3d}},6,"F-H0-6478",863,6},
  {{{0xe57bebfebb13776d}},9,"F-H0-6479",654,5},
  {{{0xe57bebfebb13776d}},9,"F-H0-6480",616,4},
  {{{0xe57bebfebb13776d}},9,"F-H0-6481",506,4},
  {{{0xce6674526bc32c1a}},11,"F-H0-6482",839,14},
  {{{0x38643adbd31e78cd}},7,"F-H0-6483",939,7},
  {{{0xbe2a0303a28d2c56}},7,"F-H0-6484",947,3},
  {{{0x38643adbd31e78cd}},7,"F-H0-6485",825,3},
  {{{0xe7272efc5b031cd0}},7,"F-H0-6486",943,3},
  {{{0xafd75608da8a6b40}},7,"F-H0-6487",800,4},
  {{{0xafd75608da8a6b40}},7,"F-H0-6488",946,4},
  {{{0x23b1612bb57a1def}},7,"F-H0-6489",419,4},
  {{{0x23b1612bb57a1def}},7,"F-H0-6490",462,2},
  {{{0x5238eedbd67d8566}},6,"F-H0-6491",543,5},
  {{{0x5238eedbd67d8566}},6,"F-H0-6492",948,4},
  {{{0x5238eedbd67d8566}},6,"F-H0-6493",690,3},
  {{{0x80ee9d52b800df8a}},6,"F-H0-6494",462,2},
  {{{0x5fdfc97c62d96fe7}},9,"F-H0-6495",838,14},
  {{{0xdad85d1e8fc3d95f}},13,"F-H0-6496",984,9},
  {{{0xdad85d1e8fc3d95f}},13,"F-H0-6497",910,3},
  {{{0x17fe650e67873973}},10,"F-H0-6498",867,6},
  {{{0xc6f3ab7ee5cde7be}},10,"F-H0-6499",429,3},
  {{{0xc37914fb65d7b8ca}},10,"F-H0-6500",462,2},
  {{{0xc4839a8354e61809}},10,"F-H0-6501",432,9},
  {{{0xc4839a8354e61809}},10,"F-H0-6502",506,6},
  {{{0xc4839a8354e61809}},10,"F-H0-6503",469,2},
  {{{0x898977e4eabb9772}},12,"F-H0-6504",949,9},
  {{{0x4e733111d3f13b16}},12,"F-H0-6505",788,6},
  {{{0x4e733111d3f13b16}},12,"F-H0-6506",789,2},
  {{{0x889f43159c15eb65}},11,"F-H0-6507",910,14},
  {{{0xc0905c25f1b73a92}},10,"F-H0-6508",827,7},
  {{{0xd1f84a0c60faa388}},10,"F-H0-6509",838,5},
  {{{0xc0905c25f1b73a92}},10,"F-H0-6510",902,3},
  {{{0xc0905c25f1b73a92}},10,"F-H0-6511",543,2},
  {{{0x3a977973430076ab}},6,"F-H0-6512",495,14},
  {{{0x3a977973430076ab}},6,"F-H0-6513",418,5},
  {{{0xf2888067c60d28e8}},13,"F-H0-6514",946,8},
  {{{0xf2888067c60d28e8}},13,"F-H0-6515",910,5},
  {{{0xa48f0aceba259eb9}},4,"F-H0-6516",430,6},
  {{{0x49d1149e57e521cb}},4,"F-H0-6517",466,2},
  {{{0x49d1149e57e521cb}},4,"F-H0-6518",580,2},
  {{{0x49d1149e57e521cb}},4,"F-H0-6519",616,2},
  {{{0x8d43ec329d22e491}},14,"F-H0-6520",421,2},
  {{{0xd992c93979ffb223}},6,"F-H0-6521",908,7},
  {{{0xd992c93979ffb223}},6,"F-H0-6522",492,5},
  {{{0xd992c93979ffb223}},6,"F-H0-6523",838,2},
  {{{0x492034a914404302}},9,"F-H0-6524",503,15},
  {{{0x8eba10be162884a5}},8,"F-H0-6525",640,16},
  {{{0x833bb52049ab7d3}},8,"F-H0-6526",903,13},
  {{{0x44000bb1336076cf}},8,"F-H0-6527",936,3},
  {{{0x9ec5ea9462de97a}},4,"F-H0-6528",505,12},
  {{{0x9ec5ea9462de97a}},4,"F-H0-6529",542,2},
  {{{0x16ee77c6b59485e6}},8,"F-H0-6530",458,9},
  {{{0x16ee77c6b59485e6}},8,"F-H0-6531",459,4},
  {{{0x29e990427a6b8465}},8,"F-H0-6532",457,2},
  {{{0x823cee6ce0cb5bcc}},6,"F-H0-6533",492,5},
  {{{0xb3f60408e1ddcee0}},6,"F-H0-6534",752,4},
  {{{0x823cee6ce0cb5bcc}},6,"F-H0-6535",567,3},
  {{{0x59d9330876a4ff82}},6,"F-H0-6536",838,2},
  {{{0x5ac796e43e195279}},18,"F-H0-6537",678,4},
  {{{0x58ca47533339e93f}},18,"F-H0-6538",838,3},
  {{{0x58ca47533339e93f}},18,"F-H0-6539",910,2},
  {{{0xba2a6083384492ba}},5,"F-H0-6540",466,4},
  {{{0xe259b3784f604aee}},5,"F-H0-6541",764,3},
  {{{0xba2a6083384492ba}},5,"F-H0-6542",461,3},
  {{{0xba2a6083384492ba}},5,"F-H0-6543",467,2},
  {{{0xe259b3784f604aee}},5,"F-H0-6544",728,2},
  {{{0xc7fe211b7c5158c1}},12,"F-H0-6545",947,5},
  {{{0xc7fe211b7c5158c1}},12,"F-H0-6546",910,4},
  {{{0xc7fe211b7c5158c1}},12,"F-H0-6547",765,3},
  {{{0xc7fe211b7c5158c1}},12,"F-H0-6548",727,2},
  {{{0xc6d9e4319ed9a371}},9,"F-H0-6549",839,9},
  {{{0xc6d9e4319ed9a371}},9,"F-H0-6550",838,4},
  {{{0xc6d9e4319ed9a371}},9,"F-H0-6551",985,2},
  {{{0xc6d9e4319ed9a371}},9,"F-H0-6552",986,2},
  {{{0x7cc1185bc7c65774}},9,"F-H0-6553",948,14},
  {{{0xeb5a7ffe12970659}},5,"F-H0-6554",802,5},
  {{{0x92389a05816b89c4}},5,"F-H0-6555",460,3},
  {{{0xeb5a7ffe12970659}},5,"F-H0-6556",876,2},
  {{{0xc10e5af707783273}},6,"F-H0-6557",948,10},
  {{{0xc10e5af707783273}},6,"F-H0-6558",908,5},
  {{{0x8bce3a8de994d173}},6,"F-H0-6559",566,2},
  {{{0x6456a32dc15db13d}},4,"F-H0-6560",420,9},
  {{{0x8dcc8837c75d13e}},4,"F-H0-6561",825,3},
  {{{0x14fb66518a0fcb83}},4,"F-H0-6562",529,2},
  {{{0x469d5a04406455ac}},5,"F-H0-6563",946,5},
  {{{0xc63eb2a65f4743d6}},5,"F-H0-6564",543,4},
  {{{0xbc2f4f3b37ca1c54}},5,"F-H0-6565",752,4},
  {{{0x3ff54f3aa5da06b3}},5,"F-H0-6566",420,2},
  {{{0x7513fbd1ea6161d9}},3,"F-H0-6567",456,8},
  {{{0xe70af2b57e1110e7}},3,"F-H0-6568",468,6},
  {{{0x9edc3b767ce85314}},3,"F-H0-6569",468,2},
  {{{0x6677e70fc9493c09}},3,"F-H0-6570",419,2},
  {{{0x732c0f86e44bb1cb}},10,"F-H0-6571",380,8},
  {{{0x732c0f86e44bb1cb}},10,"F-H0-6572",496,7},
  {{{0xd2e783063651c77c}},3,"F-H0-6573",901,5},
  {{{0x94128f20cdbb3e5a}},3,"F-H0-6574",468,3},
  {{{0x94128f20cdbb3e5a}},3,"F-H0-6575",430,2},
  {{{0x94128f20cdbb3e5a}},3,"F-H0-6576",469,2},
  {{{0x66c0b58b6def34ef}},8,"F-H0-6577",454,14},
  {{{0xf34beee42523e831}},8,"F-H0-6578",764,3},
  {{{0xccd325a6b8a664ba}},10,"F-H0-6579",839,7},
  {{{0xa5a499dbb31324f3}},10,"F-H0-6580",902,6},
  {{{0xcf6623a19f11afe6}},8,"F-H0-6581",936,10},
  {{{0xcf6623a19f11afe6}},8,"F-H0-6582",543,3},
  {{{0xcf6623a19f11afe6}},8,"F-H0-6583",690,3},
  {{{0x25b03cf62f527b6e}},8,"F-H0-6584",940,2},
  {{{0x742702c339a31219}},9,"F-H0-6585",911,5},
  {{{0x742702c339a31219}},9,"F-H0-6586",947,5},
  {{{0x742702c339a31219}},9,"F-H0-6587",905,3},
  {{{0x742702c339a31219}},9,"F-H0-6588",939,3},
  {{{0x2171513f262956eb}},13,"F-H0-6589",836,5},
  {{{0x2171513f262956eb}},13,"F-H0-6590",950,5},
  {{{0x95afe59768c50c94}},3,"F-H0-6591",468,11},
  {{{0xf4ca01ad8aec73b8}},3,"F-H0-6592",467,3},
  {{{0xf4ca01ad8aec73b8}},3,"F-H0-6593",431,2},
  {{{0xacfa4f8c1564e5fb}},8,"F-H0-6594",912,14},
  {{{0x276a18c64930098d}},7,"F-H0-6595",419,11},
  {{{0x2f7b0dd7513a5fb}},6,"F-H0-6596",616,7},
  {{{0x5718f2eefffa68ad}},6,"F-H0-6597",428,3},
  {{{0xbb62f1652faf9210}},6,"F-H0-6598",948,3},
  {{{0xbb62f1652faf9210}},6,"F-H0-6599",421,2},
  {{{0x99542f41b4b26821}},8,"F-H0-6600",874,9},
  {{{0x99542f41b4b26821}},8,"F-H0-6601",908,5},
  {{{0x99542f41b4b26821}},8,"F-H0-6602",909,2},
  {{{0xd98853d3c1ca87bf}},8,"F-H0-6603",530,2},
  {{{0xabe7ecb33f934367}},14,"F-H0-6604",727,5},
  {{{0x90f4cb8b729a3aa7}},6,"F-H0-6605",423,3},
  {{{0x90f4cb8b729a3aa7}},6,"F-H0-6606",458,3},
  {{{0x422e30ce2b921f96}},12,"F-H0-6607",911,17},
  {{{0x47b7088261528d24}},13,"F-H0-6608",943,13},
  {{{0x7a70c4cc331f57b4}},2,"F-H0-6609",901,9},
  {{{0x5c4a4d51227b5f71}},2,"F-H0-6610",949,4},
  {{{0x7a70c4cc331f57b4}},2,"F-H0-6611",864,3},
  {{{0x3df4ab1191041f9}},10,"F-H0-6612",947,17},
  {{{0xa8eef83f0d6ec11f}},10,"F-H0-6613",765,14},
  {{{0xc7f95959386bbc35}},10,"F-H0-6614",908,2},
  {{{0xbdebe19d531ecfb1}},5,"F-H0-6615",839,11},
  {{{0x936c490fc2e8474c}},5,"F-H0-6616",690,3},
  {{{0x936c490fc2e8474c}},5,"F-H0-6617",943,2},
  {{{0x1a163df5394ae14d}},6,"F-H0-6618",418,16},
  {{{0xde6e4256b7c16dbb}},16,"F-H0-6619",800,4},
  {{{0xde6e4256b7c16dbb}},16,"F-H0-6620",764,2},
  {{{0x9413624506d69c8a}},7,"F-H0-6621",825,2},
  {{{0x9413624506d69c8a}},7,"F-H0-6622",427,2},
  {{{0xc13916202b559b4f}},15,"F-H0-6623",765,5},
  {{{0x71d2116112a770ce}},13,"F-H0-6624",691,5},
  {{{0xa7c6dc51adf639e9}},9,"F-H0-6625",948,13},
  {{{0x974ebfb4f73032a6}},6,"F-H0-6626",467,14},
  {{{0x27cd0f3c4753d5f8}},9,"F-H0-6627",529,6},
  {{{0xc86c0145f4fa7650}},9,"F-H0-6628",690,4},
  {{{0x9c356854fb9dcf6b}},9,"F-H0-6629",727,2},
  {{{0xcacd428536c71a84}},9,"F-H0-6630",427,2},
  {{{0xe91d3a98d45ad124}},9,"F-H0-6631",714,2},
  {{{0x86a970082e4932cb}},5,"F-H0-6632",908,6},
  {{{0xd0be86f2c6f39a81}},5,"F-H0-6633",530,4},
  {{{0x86a970082e4932cb}},5,"F-H0-6634",946,3},
  {{{0x86a970082e4932cb}},5,"F-H0-6635",505,2},
  {{{0x691ad216bda71748}},5,"F-H0-6636",492,2},
  {{{0xff098a1aa4a9813c}},8,"F-H0-6637",429,17},
  {{{0x88ee8135f8c20062}},11,"F-H0-6638",949,12},
  {{{0x5108d5a1f8e88374}},2,"F-H0-6639",912,4},
  {{{0x8f95dcda3ac0426b}},2,"F-H0-6640",913,3},
  {{{0x5108d5a1f8e88374}},2,"F-H0-6641",468,2},
  {{{0xa7bb5451cc5a951f}},2,"F-H0-6642",864,2},
  {{{0x5108d5a1f8e88374}},2,"F-H0-6643",456,2},
  {{{0xd4903001ab4dc06e}},11,"F-H0-6644",713,15},
  {{{0xd4903001ab4dc06e}},11,"F-H0-6645",829,2},
  {{{0xaeecb483871bb028}},9,"F-H0-6646",541,17},
  {{{0x7f05bd8c7cfeaa3a}},12,"F-H0-6647",840,17},
  {{{0xbbccd0d5b68de3ec}},9,"F-H0-6648",690,11},
  {{{0xed44342fa400cc7}},9,"F-H0-6649",456,2},
  {{{0x33c86e59801cfe4b}},6,"F-H0-6650",690,2},
  {{{0x682004b80e6b43fc}},6,"F-H0-6651",906,2},
  {{{0xc6f2e4397ee61fdb}},4,"F-H0-6652",862,6},
  {{{0xc6f2e4397ee61fdb}},4,"F-H0-6653",529,5},
  {{{0xc6f2e4397ee61fdb}},4,"F-H0-6654",468,4},
  {{{0xff5eb45c25f417db}},9,"F-H0-6655",579,7},
  {{{0xf5b31ccb973577e}},9,"F-H0-6656",836,5},
  {{{0xf5b31ccb973577e}},9,"F-H0-6657",910,5},
  {{{0x6a14d431059dd98a}},3,"F-H0-6658",912,9},
  {{{0x8e3edecc040aad46}},3,"F-H0-6659",456,4},
  {{{0xca8a07ab4f38821}},3,"F-H0-6660",913,2},
  {{{0x69b38679bf02ef5f}},6,"F-H0-6661",941,6},
  {{{0xba0f0b3da71bdbad}},6,"F-H0-6662",788,2},
  {{{0x15fe536275f8f684}},4,"F-H0-6663",431,3},
  {{{0x78845b69b8bbfc25}},4,"F-H0-6664",543,2},
  {{{0xde1d19d3df04b039}},10,"F-H0-6665",430,12},
  {{{0xde1d19d3df04b039}},10,"F-H0-6666",431,2},
  {{{0xde1d19d3df04b039}},10,"F-H0-6667",432,2},
  {{{0x1a228a31b39f4a6f}},10,"F-H0-6668",913,17},
  {{{0xe50241e747914198}},21,"F-H0-6669",421,9},
  {{{0xe50241e747914198}},21,"F-H0-6670",603,8},
  {{{0x7ecd7ad6da6d7020}},8,"F-H0-6671",433,9},
  {{{0x817c19481ed01229}},8,"F-H0-6672",418,4},
  {{{0x446e995effaccb57}},9,"F-H0-6673",911,9},
  {{{0x1d730a30ac274dd3}},9,"F-H0-6674",839,3},
  {{{0x446e995effaccb57}},9,"F-H0-6675",947,3},
  {{{0xfbf07c59b10630ca}},7,"F-H0-6676",902,16},
  {{{0x11fc910585ab761}},5,"F-H0-6677",460,7},
  {{{0x11fc910585ab761}},5,"F-H0-6678",420,4},
  {{{0x11fc910585ab761}},5,"F-H0-6679",949,2},
  {{{0xbcdd45c5d197982d}},5,"F-H0-6680",802,2},
  {{{0x6772f2c23f5df333}},5,"F-H0-6681",826,2},
  {{{0xd885b664be6afabe}},8,"F-H0-6682",908,4},
  {{{0xd885b664be6afabe}},8,"F-H0-6683",838,3},
  {{{0xd885b664be6afabe}},8,"F-H0-6684",946,3},
  {{{0xd885b664be6afabe}},8,"F-H0-6685",948,3},
  {{{0x39a59a765bb11683}},8,"F-H0-6686",690,13},
  {{{0x39a59a765bb11683}},8,"F-H0-6687",543,2},
  {{{0xe096300350d75f4d}},6,"F-H0-6688",454,4},
  {{{0xe096300350d75f4d}},6,"F-H0-6689",678,4},
  {{{0x339bad3e2f5d1127}},10,"F-H0-6690",876,18},
  {{{0x6120463434693c94}},8,"F-H0-6691",874,12},
  {{{0x7f0f5cdbc3cf8ff3}},8,"F-H0-6692",948,16},
  {{{0x8ef878ca28bf712f}},3,"F-H0-6693",939,4},
  {{{0x3837b7838b3c2834}},3,"F-H0-6694",543,3},
  {{{0x55ddf6725ae089fb}},7,"F-H0-6695",913,18},
  {{{0x6d38f8252fd9336b}},9,"F-H0-6696",421,12},
  {{{0x59a112a60876a6a}},9,"F-H0-6697",493,2},
  {{{0x468c4136ca6fc6b5}},6,"F-H0-6698",873,8},
  {{{0x4ffb95cb02e945fb}},6,"F-H0-6699",493,4},
  {{{0x3a5ddd7de7ba6b54}},6,"F-H0-6700",542,3},
  {{{0x4ffb95cb02e945fb}},6,"F-H0-6701",494,3},
  {{{0xe79458dc02a8d307}},6,"F-H0-6702",825,7},
  {{{0xbc953974eed25d73}},6,"F-H0-6703",839,6},
  {{{0xbc953974eed25d73}},6,"F-H0-6704",950,3},
  {{{0xc05b9e95e49a59df}},9,"F-H0-6705",948,5},
  {{{0xc05b9e95e49a59df}},9,"F-H0-6706",950,4},
  {{{0x6cb6bdd7f5e083f2}},10,"F-H0-6707",945,8},
  {{{0x6cb6bdd7f5e083f2}},10,"F-H0-6708",908,4},
  {{{0x6cb6bdd7f5e083f2}},10,"F-H0-6709",910,4},
  {{{0x5ba7ae3b4b7557c8}},10,"F-H0-6710",913,13},
  {{{0xaaa542d34a84500c}},12,"F-H0-6711",836,11},
  {{{0xaaa542d34a84500c}},12,"F-H0-6712",950,6},
  {{{0x636a97ebf372f136}},11,"F-H0-6713",507,13},
  {{{0xba6751d6effa6a77}},8,"F-H0-6714",765,9},
  {{{0xba6751d6effa6a77}},8,"F-H0-6715",838,2},
  {{{0xddcbd0b6c99914e6}},8,"F-H0-6716",838,2},
  {{{0xf65a24d7803f19b7}},5,"F-H0-6717",939,7},
  {{{0x458af02935eb90fc}},5,"F-H0-6718",499,3},
  {{{0xf65a24d7803f19b7}},5,"F-H0-6719",690,2},
  {{{0x26457c11dc4417bc}},7,"F-H0-6720",801,6},
  {{{0x26457c11dc4417bc}},7,"F-H0-6721",462,3},
  {{{0x3126724fde6daa57}},7,"F-H0-6722",493,2},
  {{{0x3126724fde6daa57}},7,"F-H0-6723",945,2},
  {{{0xd056331da13e40ab}},7,"F-H0-6724",973,16},
  {{{0x4050b0f352b1d9c9}},6,"F-H0-6725",381,17},
  {{{0x8d63ab74687cf0c5}},5,"F-H0-6726",429,3},
  {{{0x8d63ab74687cf0c5}},5,"F-H0-6727",653,3},
  {{{0x8d63ab74687cf0c5}},5,"F-H0-6728",911,3},
  {{{0x65a944bdd52c987d}},5,"F-H0-6729",542,2},
  {{{0x8d63ab74687cf0c5}},5,"F-H0-6730",863,2},
  {{{0x8d63ab74687cf0c5}},5,"F-H0-6731",690,2},
  {{{0x1a8ed2098ba22f2}},4,"F-H0-6732",906,5},
  {{{0x3f2d7ade311e9841}},4,"F-H0-6733",529,4},
  {{{0x1a8ed2098ba22f2}},4,"F-H0-6734",456,3},
  {{{0x1a8ed2098ba22f2}},4,"F-H0-6735",419,2},
  {{{0x1a8ed2098ba22f2}},4,"F-H0-6736",677,2},
  {{{0x196a2e09c1726bdc}},7,"F-H0-6737",936,7},
  {{{0x196a2e09c1726bdc}},7,"F-H0-6738",827,5},
  {{{0x196a2e09c1726bdc}},7,"F-H0-6739",939,4},
  {{{0x84ccc0d4a31eef7b}},7,"F-H0-6740",909,2},
  {{{0xdfae77198cee8c1f}},7,"F-H0-6741",469,14},
  {{{0x67102db280978e44}},7,"F-H0-6742",838,13},
  {{{0x1ef12361b39cacda}},7,"F-H0-6743",825,2},
  {{{0x39b202af497d17c5}},9,"F-H0-6744",641,5},
  {{{0x39b202af497d17c5}},9,"F-H0-6745",421,4},
  {{{0x39b202af497d17c5}},9,"F-H0-6746",678,2},
  {{{0x3501dd1190de0731}},9,"F-H0-6747",838,2},
  {{{0x39b202af497d17c5}},9,"F-H0-6748",603,2},
  {{{0x2850ca9afc02bd9f}},3,"F-H0-6749",912,10},
  {{{0x2850ca9afc02bd9f}},3,"F-H0-6750",862,3},
  {{{0x1f9fd2674faf520c}},2,"F-H0-6751",949,15},
  {{{0xa9686dafd94bebf6}},7,"F-H0-6752",939,6},
  {{{0xa9686dafd94bebf6}},7,"F-H0-6753",827,6},
  {{{0xa9686dafd94bebf6}},7,"F-H0-6754",936,3},
  {{{0x241a2161fd276fb9}},7,"F-H0-6755",826,2},
  {{{0xfeeb53e2044fee5}},11,"F-H0-6756",763,17},
  {{{0xa1c0dd23f7e0f3fc}},5,"F-H0-6757",462,5},
  {{{0xbe41cff4169853e}},5,"F-H0-6758",974,3},
  {{{0x1be1f86595c01bfc}},5,"F-H0-6759",765,2},
  {{{0xc546a576705620ee}},5,"F-H0-6760",839,2},
  {{{0xa1e2a4e3945a2f09}},5,"F-H0-6761",426,2},
  {{{0xb7514c67f58e97c4}},6,"F-H0-6762",714,8},
  {{{0xe1a1b21623bc1428}},6,"F-H0-6763",914,5},
  {{{0x98dac83958613d9}},5,"F-H0-6764",911,8},
  {{{0xdd5997e6d8efdc6a}},5,"F-H0-6765",466,3},
  {{{0x98dac83958613d9}},5,"F-H0-6766",910,3},
  {{{0x1fe47756f55b53c9}},5,"F-H0-6767",938,2},
  {{{0x33b9469cf2e5a9de}},5,"F-H0-6768",462,3},
  {{{0xe3795d49f4293dff}},5,"F-H0-6769",421,3},
  {{{0x33b9469cf2e5a9de}},5,"F-H0-6770",542,2},
  {{{0x53ffd2e0282f4ec}},5,"F-H0-6771",727,2},
  {{{0xbd6858997dc51d73}},5,"F-H0-6772",423,2},
  {{{0xa4d789fc3555455d}},11,"F-H0-6773",838,8},
  {{{0x5398871ff62585f8}},11,"F-H0-6774",984,5},
  {{{0x337c85fe6d9f9e72}},2,"F-H0-6775",911,4},
  {{{0xf93e949924addfe3}},2,"F-H0-6776",862,2},
  {{{0xa0ac88e79bd1d614}},10,"F-H0-6777",941,11},
  {{{0xa0ac88e79bd1d614}},10,"F-H0-6778",945,2},
  {{{0xb3a8dd83083ef0b2}},11,"F-H0-6779",691,7},
  {{{0x27c8fd32fc49b861}},11,"F-H0-6780",496,4},
  {{{0xcc2f1f3325fc55fd}},11,"F-H0-6781",426,2},
  {{{0x53f0c8240e4bf9ab}},8,"F-H0-6782",678,8},
  {{{0xb7b67816797538d1}},8,"F-H0-6783",936,6},
  {{{0x2dc296b1a9fd4560}},8,"F-H0-6784",421,2},
  {{{0xf5b934e234ee3381}},4,"F-H0-6785",420,7},
  {{{0xf5b934e234ee3381}},4,"F-H0-6786",457,6},
  {{{0x44dc2ba4aea9ae85}},4,"F-H0-6787",456,8},
  {{{0x5816a25dcc7abde}},4,"F-H0-6788",456,3},
  {{{0x5816a25dcc7abde}},4,"F-H0-6789",907,2},
  {{{0xdaac16ab9dbc26fd}},10,"F-H0-6790",876,12},
  {{{0x6e290565dfb05f8e}},10,"F-H0-6791",504,5},
  {{{0x8726c6792dfa0dc3}},3,"F-H0-6792",468,6},
  {{{0x8726c6792dfa0dc3}},3,"F-H0-6793",505,4},
  {{{0xe10ed33cd43f1551}},9,"F-H0-6794",429,14},
  {{{0xe10ed33cd43f1551}},9,"F-H0-6795",467,2},
  {{{0x86c3009360c59cf4}},7,"F-H0-6796",455,16},
  {{{0x5d3c0210bf817a5e}},8,"F-H0-6797",899,4},
  {{{0x5d3c0210bf817a5e}},8,"F-H0-6798",715,3},
  {{{0x1ba7f888f87bf1ed}},9,"F-H0-6799",431,14},
  {{{0x40392826a1b347a6}},5,"F-H0-6800",429,11},
  {{{0x40392826a1b347a6}},5,"F-H0-6801",690,2},
  {{{0x40392826a1b347a6}},5,"F-H0-6802",653,2},
  {{{0xa1dd3753a27a8888}},6,"F-H0-6803",678,6},
  {{{0xa1dd3753a27a8888}},6,"F-H0-6804",529,5},
  {{{0xe17664997619e544}},6,"F-H0-6805",529,2},
  {{{0xa1dd3753a27a8888}},6,"F-H0-6806",765,2},
  {{{0xa1dd3753a27a8888}},6,"F-H0-6807",425,2},
  {{{0x93cf4123fba174c9}},12,"F-H0-6808",429,12},
  {{{0x93cf4123fba174c9}},12,"F-H0-6809",945,2},
  {{{0x913c18137e073b81}},5,"F-H0-6810",802,4},
  {{{0xb444c025a410d2d3}},5,"F-H0-6811",420,3},
  {{{0xf6be39300ad607c8}},5,"F-H0-6812",604,3},
  {{{0x3a21b0f8c2676b}},5,"F-H0-6813",431,14},
  {{{0xfed167950434871e}},5,"F-H0-6814",937,2},
  {{{0xe1ecc5c140ec1c71}},7,"F-H0-6815",507,10},
  {{{0xe1ecc5c140ec1c71}},7,"F-H0-6816",469,2},
  {{{0xa2d6c7e09d5e9fc8}},15,"F-H0-6817",941,11},
  {{{0xe5df778c3d697af4}},15,"F-H0-6818",492,2},
  {{{0x9b4f0fa2f35d894e}},7,"F-H0-6819",419,15},
  {{{0xe0a6c24e07ac19fe}},4,"F-H0-6820",431,5},
  {{{0x5d4a126b6e2d1ee}},4,"F-H0-6821",905,4},
  {{{0xd2e96bdef020b13d}},7,"F-H0-6822",939,13},
  {{{0xd2e96bdef020b13d}},7,"F-H0-6823",940,5},
  {{{0x39795762df6af9bb}},10,"F-H0-6824",418,9},
  {{{0x39795762df6af9bb}},10,"F-H0-6825",463,3},
  {{{0xd5bdab9c35dd82ae}},8,"F-H0-6826",431,16},
  {{{0x561cc359870e28b2}},7,"F-H0-6827",428,14},
  {{{0x8bfc51787f8eda8d}},8,"F-H0-6828",974,10},
  {{{0x653badeb29b6f51c}},8,"F-H0-6829",533,2},
  {{{0xe25f5f1d137ece88}},8,"F-H0-6830",505,17},
  {{{0x57297aab35a4a5d7}},9,"F-H0-6831",529,13},
  {{{0x57297aab35a4a5d7}},9,"F-H0-6832",493,3},
  {{{0xad122b792c19096}},10,"F-H0-6833",470,16},
  {{{0x5054005b72b5fc30}},6,"F-H0-6834",429,5},
  {{{0x583d8331e26dddce}},6,"F-H0-6835",678,4},
  {{{0x5054005b72b5fc30}},6,"F-H0-6836",466,3},
  {{{0x5054005b72b5fc30}},6,"F-H0-6837",541,2},
  {{{0x5054005b72b5fc30}},6,"F-H0-6838",529,2},
  {{{0xd2cb122b65c570c2}},5,"F-H0-6839",943,13},
  {{{0xd2cb122b65c570c2}},5,"F-H0-6840",838,2},
  {{{0xba5a1cace91a65ef}},7,"F-H0-6841",910,9},
  {{{0x3cdd16cbfc242ba9}},2,"F-H0-6842",913,8},
  {{{0x3cdd16cbfc242ba9}},2,"F-H0-6843",431,3},
  {{{0xff79c69b57c6a73f}},9,"F-H0-6844",543,9},
  {{{0xff79c69b57c6a73f}},9,"F-H0-6845",939,3},
  {{{0xfcd43cdae7c81c4f}},9,"F-H0-6846",907,17},
  {{{0x3f9ff5b5ea41da34}},17,"F-H0-6847",909,6},
  {{{0xa771bf6809d99866}},5,"F-H0-6848",943,5},
  {{{0xa771bf6809d99866}},5,"F-H0-6849",939,5},
  {{{0xa771bf6809d99866}},5,"F-H0-6850",604,2},
  {{{0x4f32755aa45c3cf7}},3,"F-H0-6851",912,10},
  {{{0x61ff771e0baed224}},3,"F-H0-6852",949,3},
  {{{0x8deb7cf85380901f}},3,"F-H0-6853",506,2},
  {{{0xef2152a45ca34f25}},11,"F-H0-6854",906,15},
  {{{0xef2152a45ca34f25}},11,"F-H0-6855",908,2},
  {{{0x86ab404c7f829d79}},7,"F-H0-6856",542,12},
  {{{0x3f2b60754ec14484}},7,"F-H0-6857",542,2},
  {{{0x711a793a723a7a67}},11,"F-H0-6858",907,9},
  {{{0xc0107bf937d1c723}},11,"F-H0-6859",974,6},
  {{{0x131f69d64ae0a093}},9,"F-H0-6860",466,6},
  {{{0x131f69d64ae0a093}},9,"F-H0-6861",653,4},
  {{{0x131f69d64ae0a093}},9,"F-H0-6862",429,2},
  {{{0x131f69d64ae0a093}},9,"F-H0-6863",690,2},
  {{{0xad355b1e4d55dcb8}},7,"F-H0-6864",873,13},
  {{{0xad355b1e4d55dcb8}},7,"F-H0-6865",950,4},
  {{{0x120e1935abb8f2a8}},14,"F-H0-6866",905,10},
  {{{0x8a55d5f289f28502}},10,"F-H0-6867",945,15},
  {{{0x82118413c9740ea1}},6,"F-H0-6868",898,11},
  {{{0x710ae74dd348dacc}},13,"F-H0-6869",907,7},
  {{{0xebc5af9e4ceac8ed}},17,"F-H0-6870",947,9},
  {{{0xebc5af9e4ceac8ed}},17,"F-H0-6871",912,5},
  {{{0x3f4a0623173457af}},4,"F-H0-6872",530,6},
  {{{0x7eee95a99037a11a}},4,"F-H0-6873",909,3},
  {{{0x611f927f9445875}},4,"F-H0-6874",950,3},
  {{{0x7eee95a99037a11a}},4,"F-H0-6875",457,2},
  {{{0x64eb32701878ec93}},9,"F-H0-6876",950,14},
  {{{0x64eb32701878ec93}},9,"F-H0-6877",986,2},
  {{{0x302e03d5ebc5e299}},5,"F-H0-6878",948,2},
  {{{0xbc2b3112d39da58e}},5,"F-H0-6879",939,2},
  {{{0xab830ad55bf04959}},6,"F-H0-6880",902,7},
  {{{0x1fd1004a3a53491d}},6,"F-H0-6881",825,3},
  {{{0xab830ad55bf04959}},6,"F-H0-6882",939,3},
  {{{0xab830ad55bf04959}},6,"F-H0-6883",751,2},
  {{{0x58aa2b9c71660b52}},8,"F-H0-6884",838,9},
  {{{0x20190c502ae1ef17}},8,"F-H0-6885",864,3},
  {{{0x20190c502ae1ef17}},8,"F-H0-6886",902,2},
  {{{0x32037ec9b02ec62b}},18,"F-H0-6887",873,4},
  {{{0xb5a186aabab7e76b}},6,"F-H0-6888",541,10},
  {{{0xc9af0e1295393a19}},6,"F-H0-6889",418,4},
  {{{0xf707e5e6cbc22c24}},8,"F-H0-6890",950,10},
  {{{0xca88a1c576ba7de3}},8,"F-H0-6891",605,5},
  {{{0x3e82d4390817deb3}},4,"F-H0-6892",468,5},
  {{{0x10689440186e2b8f}},4,"F-H0-6893",862,4},
  {{{0x10689440186e2b8f}},4,"F-H0-6894",529,3},
  {{{0x2928638a4cf4a812}},4,"F-H0-6895",839,2},
  {{{0xc29252efef34b9d2}},6,"F-H0-6896",789,7},
  {{{0x429553109391e628}},6,"F-H0-6897",728,5},
  {{{0xa70550e382198cfa}},7,"F-H0-6898",946,6},
  {{{0xa70550e382198cfa}},7,"F-H0-6899",947,5},
  {{{0x6115184324b583f9}},7,"F-H0-6900",457,2},
  {{{0x66e30fd01d409d14}},7,"F-H0-6901",504,2},
  {{{0x245efec7cd87ff9}},2,"F-H0-6902",468,6},
  {{{0x317066027fdf4828}},2,"F-H0-6903",912,4},
  {{{0xea63b72ffe43ecc4}},2,"F-H0-6904",832,2},
  {{{0xd0d15042858c7fb2}},4,"F-H0-6905",458,2},
  {{{0xf7624c02fcecabf5}},4,"F-H0-6906",567,2},
  {{{0xf9922b2f8491fee0}},9,"F-H0-6907",653,5},
  {{{0xf9922b2f8491fee0}},9,"F-H0-6908",617,4},
  {{{0xc71c623a30609d19}},9,"F-H0-6909",458,3},
  {{{0xf75421c46ac1f8e0}},9,"F-H0-6910",678,2},
  {{{0xf9922b2f8491fee0}},9,"F-H0-6911",429,2},
  {{{0xcf4ca368ee270a01}},9,"F-H0-6912",467,14},
  {{{0xd2240c7e6d3cf445}},4,"F-H0-6913",863,5},
  {{{0x1acc1490535488d5}},4,"F-H0-6914",430,3},
  {{{0x15de08363eca4f08}},4,"F-H0-6915",825,3},
  {{{0x7e7acb052a862053}},4,"F-H0-6916",938,3},
  {{{0xc9b03f2397128886}},7,"F-H0-6917",468,14},
  {{{0xb2661c03fd793db7}},8,"F-H0-6918",945,6},
  {{{0xb2661c03fd793db7}},8,"F-H0-6919",457,4},
  {{{0xa158a10ec18be6f7}},8,"F-H0-6920",421,2},
  {{{0xb3068154121b1ec1}},8,"F-H0-6921",566,2},
  {{{0xd05d5f42424fc465}},12,"F-H0-6922",728,10},
  {{{0x1caf8d108068d000}},12,"F-H0-6923",868,3},
  {{{0x564e8bc088e0e01b}},4,"F-H0-6924",469,4},
  {{{0x58c292095f063e7f}},4,"F-H0-6925",505,3},
  {{{0x58c292095f063e7f}},4,"F-H0-6926",906,2},
  {{{0x58c292095f063e7f}},4,"F-H0-6927",690,2},
  {{{0x2a00071b7531b66d}},9,"F-H0-6928",431,8},
  {{{0x992129a1dc3594d6}},9,"F-H0-6929",417,7},
  {{{0xce7b83f9baf0093a}},8,"F-H0-6930",899,17},
  {{{0x3c2c83050414e68}},5,"F-H0-6931",420,5},
  {{{0x3c2c83050414e68}},5,"F-H0-6932",863,4},
  {{{0x3b69fe8d3654b0f4}},5,"F-H0-6933",908,3},
  {{{0x655b182b09694413}},5,"F-H0-6934",542,2},
  {{{0x3b69fe8d3654b0f4}},5,"F-H0-6935",946,2},
  {{{0xc4df86754f275336}},13,"F-H0-6936",914,8},
  {{{0xe2da0f75ea74d331}},13,"F-H0-6937",946,5},
  {{{0x5faa2327c215eca3}},5,"F-H0-6938",825,8},
  {{{0x5faa2327c215eca3}},5,"F-H0-6939",764,2},
  {{{0x5faa2327c215eca3}},5,"F-H0-6940",801,2},
  {{{0x7f971570bd803dca}},9,"F-H0-6941",975,14},
  {{{0x830f3d6851da3ce}},9,"F-H0-6942",380,2},
  {{{0x3719d0e969c42ed}},15,"F-H0-6943",789,15},
  {{{0x90e0321709214ce0}},5,"F-H0-6944",943,12},
  {{{0xc27b0f4450c43528}},5,"F-H0-6945",825,4},
  {{{0x53bedbc51023affd}},5,"F-H0-6946",458,4},
  {{{0x53bedbc51023affd}},5,"F-H0-6947",421,3},
  {{{0x6aa5cd6643e46975}},5,"F-H0-6948",907,3},
  {{{0xc27b0f4450c43528}},5,"F-H0-6949",690,2},
  {{{0x53bedbc51023affd}},5,"F-H0-6950",603,2},
  {{{0xfdf04f13a7b5495e}},17,"F-H0-6951",802,12},
  {{{0x5c2a75a420e1a5b}},17,"F-H0-6952",914,2},
  {{{0x253f4c2a5a9fd696}},17,"F-H0-6953",901,2},
  {{{0x3c5421544eef4be7}},8,"F-H0-6954",873,8},
  {{{0x4f14334ab649446}},5,"F-H0-6955",947,9},
  {{{0x4f14334ab649446}},5,"F-H0-6956",714,2},
  {{{0x44d934045f57780a}},7,"F-H0-6957",458,13},
  {{{0x6f5317acd7ef4e1e}},7,"F-H0-6958",839,4},
  {{{0x522f7253664200fc}},7,"F-H0-6959",825,9},
  {{{0x9870363f6815bf3}},7,"F-H0-6960",949,5},
  {{{0x9870363f6815bf3}},7,"F-H0-6961",912,4},
  {{{0xcefffb3e0ea65dae}},7,"F-H0-6962",825,2},
  {{{0x6c7f4179f3f22dd2}},8,"F-H0-6963",789,17},
  {{{0xc0d2ab69c8e1d12a}},6,"F-H0-6964",765,8},
  {{{0xc0d2ab69c8e1d12a}},6,"F-H0-6965",910,2},
  {{{0xc03d6f03f8ccde88}},6,"F-H0-6966",466,2},
  {{{0xec82130d47ef1b98}},10,"F-H0-6967",947,13},
  {{{0x2ef5f6dd828558d}},7,"F-H0-6968",801,9},
  {{{0x4ca36dd95b9b28fa}},7,"F-H0-6969",530,2},
  {{{0x2ef5f6dd828558d}},7,"F-H0-6970",876,2},
  {{{0x77b24eafc947645f}},7,"F-H0-6971",865,8},
  {{{0x77b24eafc947645f}},7,"F-H0-6972",950,6},
  {{{0x77b24eafc947645f}},7,"F-H0-6973",790,2},
  {{{0x874808628475b604}},2,"F-H0-6974",838,5},
  {{{0xcf51febb6c56a75a}},2,"F-H0-6975",504,2},
  {{{0x8d6cb03dda41b24a}},9,"F-H0-6976",491,12},
  {{{0x8d6cb03dda41b24a}},9,"F-H0-6977",460,2},
  {{{0x7b7d7551e89e3870}},5,"F-H0-6978",908,8},
  {{{0x4cee2c9ead57acad}},5,"F-H0-6979",420,3},
  {{{0x760a5c74f34ecce5}},5,"F-H0-6980",903,2},
  {{{0x760a5c74f34ecce5}},5,"F-H0-6981",977,2},
  {{{0xbc5e02ca93531135}},5,"F-H0-6982",421,6},
  {{{0xca3253c2739db79a}},5,"F-H0-6983",945,5},
  {{{0xaf22313f05732a8}},5,"F-H0-6984",902,2},
  {{{0x2f076c235be04d75}},14,"F-H0-6985",901,2},
  {{{0x962ab11f8db7c04f}},6,"F-H0-6986",945,5},
  {{{0x962ab11f8db7c04f}},6,"F-H0-6987",467,3},
  {{{0xe91ebe233818ce68}},6,"F-H0-6988",421,3},
  {{{0xe91ebe233818ce68}},6,"F-H0-6989",420,2},
  {{{0x3f3272bd2596dbbd}},6,"F-H0-6990",948,6},
  {{{0x22f214da74df679a}},6,"F-H0-6991",939,3},
  {{{0x22f214da74df679a}},6,"F-H0-6992",420,2},
  {{{0x5625d9ac39a39fd2}},14,"F-H0-6993",943,5},
  {{{0x3d54b53de9005ac8}},14,"F-H0-6994",939,3},
  {{{0xa5cb3bef68160b77}},14,"F-H0-6995",543,2},
  {{{0xa5cb3bef68160b77}},14,"F-H0-6996",788,2},
  {{{0xea42da89bea94881}},12,"F-H0-6997",800,17},
  {{{0xa5df4bd4bc9125c8}},16,"F-H0-6998",948,4},
  {{{0xa5df4bd4bc9125c8}},16,"F-H0-6999",946,3},
  {{{0x5bace7f083158663}},16,"F-H0-7000",752,2},
  {{{0x6abdbf1af0c8356c}},4,"F-H0-7001",875,11},
  {{{0x682e29f486281039}},4,"F-H0-7002",949,3},
  {{{0xdf6be71a0c3a9eb5}},7,"F-H0-7003",875,5},
  {{{0xa340b09e2287ca05}},7,"F-H0-7004",580,4},
  {{{0xea7dae37a92dcad1}},7,"F-H0-7005",432,3},
  {{{0x6231f65d88ba9e0a}},13,"F-H0-7006",506,13},
  {{{0x99050b9708f1c33e}},6,"F-H0-7007",492,7},
  {{{0x99050b9708f1c33e}},6,"F-H0-7008",566,5},
  {{{0x8f7d54156182a3d8}},6,"F-H0-7009",908,3},
  {{{0xa701e3b561dbaae}},16,"F-H0-7010",872,2},
  {{{0x84f7bee9e5a02d32}},12,"F-H0-7011",984,2},
  {{{0xfdbe4dfe16e0fc40}},12,"F-H0-7012",788,2},
  {{{0x2623fc741c221b8d}},7,"F-H0-7013",826,11},
  {{{0xcd7b70dd71f3ff6d}},7,"F-H0-7014",429,2},
  {{{0x944a64d628965802}},7,"F-H0-7015",504,11},
  {{{0xa77778ed9b12df19}},7,"F-H0-7016",827,3},
  {{{0xa62523f766413f7b}},7,"F-H0-7017",912,2},
  {{{0x3a4ea6913f22cc4e}},11,"F-H0-7018",947,4},
  {{{0x2698550460e9a865}},11,"F-H0-7019",691,2},
  {{{0x3a4ea6913f22cc4e}},11,"F-H0-7020",462,2},
  {{{0x3a4ea6913f22cc4e}},11,"F-H0-7021",422,2},
  {{{0x7823b957449a0dd4}},15,"F-H0-7022",839,9},
  {{{0xd5fc42ac4773fae}},15,"F-H0-7023",530,2},
  {{{0xb0dee2ca1330641a}},9,"F-H0-7024",903,9},
  {{{0x9bf4a14be2b53a01}},9,"F-H0-7025",936,5},
  {{{0xfc4e54461b73b818}},12,"F-H0-7026",433,15},
  {{{0x69baed3e8ee31444}},7,"F-H0-7027",427,12},
  {{{0x2adc8b2e919f7803}},13,"F-H0-7028",825,10},
  {{{0xabb746dcac5cb5ac}},14,"F-H0-7029",429,15},
  {{{0x1ada411c0df8843a}},8,"F-H0-7030",910,9},
  {{{0xdb9d4a1745a62193}},8,"F-H0-7031",543,4},
  {{{0x45866a77b47ddd26}},5,"F-H0-7032",913,6},
  {{{0xc0b552112ca18a9c}},5,"F-H0-7033",939,5},
  {{{0x45866a77b47ddd26}},5,"F-H0-7034",875,2},
  {{{0x45866a77b47ddd26}},5,"F-H0-7035",690,2},
  {{{0x57b0503fc959de7f}},4,"F-H0-7036",455,5},
  {{{0x646f939b566f494c}},4,"F-H0-7037",457,4},
  {{{0xa2f60dc274d8c046}},8,"F-H0-7038",943,5},
  {{{0xdf924c4646db921}},8,"F-H0-7039",529,3},
  {{{0x4c5c29ecea32d500}},6,"F-H0-7040",906,8},
  {{{0xc0f65e23b304748d}},6,"F-H0-7041",470,4},
  {{{0xd40cf15e11631316}},3,"F-H0-7042",418,10},
  {{{0xc609eaa1d95724d1}},3,"F-H0-7043",420,2},
  {{{0xd40cf15e11631316}},3,"F-H0-7044",456,2},
  {{{0x9f469fc7ccb06db8}},5,"F-H0-7045",543,7},
  {{{0x9f469fc7ccb06db8}},5,"F-H0-7046",580,4},
  {{{0xe30dbf535c5fad3}},8,"F-H0-7047",877,12},
  {{{0xa1cd8f632dab0bc9}},8,"F-H0-7048",380,3},
  {{{0x10a18d6b75409266}},4,"F-H0-7049",910,4},
  {{{0x10a18d6b75409266}},4,"F-H0-7050",946,2},
  {{{0xb25bf3d192f5421b}},4,"F-H0-7051",912,2},
  {{{0xb25bf3d192f5421b}},4,"F-H0-7052",876,2},
  {{{0x76cde8950b14ec1f}},7,"F-H0-7053",910,8},
  {{{0x76cde8950b14ec1f}},7,"F-H0-7054",947,2},
  {{{0x98cacdb9e5152d0c}},9,"F-H0-7055",678,9},
  {{{0x98cacdb9e5152d0c}},9,"F-H0-7056",898,3},
  {{{0x63537436becd54e6}},6,"F-H0-7057",542,4},
  {{{0x900988b56b938e39}},6,"F-H0-7058",459,3},
  {{{0x76cfa6a21df5acb7}},6,"F-H0-7059",469,2},
  {{{0xefd1437b7cc0e604}},7,"F-H0-7060",417,15},
  {{{0x60312215de67df93}},16,"F-H0-7061",939,4},
  {{{0x60312215de67df93}},16,"F-H0-7062",902,4},
  {{{0xaacf093db1adedc9}},16,"F-H0-7063",910,3},
  {{{0xaacf093db1adedc9}},16,"F-H0-7064",945,2},
  {{{0xcb8ffae8740cb102}},15,"F-H0-7065",976,2},
  {{{0x90ed0a0d2c48a35b}},13,"F-H0-7066",943,7},
  {{{0x90ed0a0d2c48a35b}},13,"F-H0-7067",947,3},
  {{{0x9772e4e6ea89a39e}},13,"F-H0-7068",421,3},
  {{{0x532b40e4c821841c}},13,"F-H0-7069",943,2},
  {{{0xcd502e191105a1af}},8,"F-H0-7070",419,16},
  {{{0x4701668727d3d6cc}},9,"F-H0-7071",493,12},
  {{{0x166c7d7b40fb7059}},9,"F-H0-7072",395,3},
  {{{0xc123e076a7b29c2d}},10,"F-H0-7073",690,10},
  {{{0xc58d76b2666a3de}},10,"F-H0-7074",493,2},
  {{{0x6d92d6a09651f4b7}},2,"F-H0-7075",432,4},
  {{{0xb4531f332fc8d7ba}},2,"F-H0-7076",950,3},
  {{{0x4ed381dc9183d119}},2,"F-H0-7077",469,2},
  {{{0x4038940bb14737fb}},2,"F-H0-7078",900,2},
  {{{0x2479c0162cbda828}},4,"F-H0-7079",683,10},
  {{{0x2479c0162cbda828}},4,"F-H0-7080",759,5},
  {{{0x18293c71fa90b321}},9,"F-H0-7081",617,3},
  {{{0x18293c71fa90b321}},9,"F-H0-7082",839,2},
  {{{0xaac531d33ba1c1d0}},7,"F-H0-7083",873,7},
  {{{0xaac531d33ba1c1d0}},7,"F-H0-7084",909,5},
  {{{0xaac531d33ba1c1d0}},7,"F-H0-7085",910,2},
  {{{0xf6ef337e8301823b}},3,"F-H0-7086",455,7},
  {{{0x214101489b722770}},3,"F-H0-7087",456,4},
  {{{0xd8c3bfa63276ee3}},3,"F-H0-7088",948,2},
  {{{0x48e8baad4fa4a2ca}},3,"F-H0-7089",901,2},
  {{{0x227b73a2326159b4}},11,"F-H0-7090",905,6},
  {{{0x227b73a2326159b4}},11,"F-H0-7091",906,4},
  {{{0x153e032263e1ce49}},11,"F-H0-7092",427,2},
  {{{0x153e032263e1ce49}},11,"F-H0-7093",426,2},
  {{{0x450d9c314c147142}},8,"F-H0-7094",914,4},
  {{{0xb0e4d285a7ee6a5d}},8,"F-H0-7095",461,2},
  {{{0xdcbfe7f2f980b259}},6,"F-H0-7096",876,10},
  {{{0x5ecfecf815398071}},6,"F-H0-7097",839,5},
  {{{0x37130e7ed043c61d}},6,"F-H0-7098",421,7},
  {{{0xd65f1f5f96c9f9cf}},6,"F-H0-7099",865,5},
  {{{0x9bba0f350022509c}},3,"F-H0-7100",913,2},
  {{{0x4a659dae1d0612a3}},3,"F-H0-7101",802,2},
  {{{0xeb52831f2fe5196e}},3,"F-H0-7102",839,2},
  {{{0xeb52831f2fe5196e}},3,"F-H0-7103",431,2},
  {{{0xe75b51030d48d36e}},5,"F-H0-7104",913,14},
  {{{0xa791ad0ad86f478f}},4,"F-H0-7105",862,4},
  {{{0x73e639804afd8549}},4,"F-H0-7106",863,3},
  {{{0xa791ad0ad86f478f}},4,"F-H0-7107",420,2},
  {{{0xeaf0a26483592c83}},4,"F-H0-7108",949,7},
  {{{0xeaf0a26483592c83}},4,"F-H0-7109",543,5},
  {{{0x3a4a7df3e630cc9a}},7,"F-H0-7110",936,9},
  {{{0x969ba22ad994667d}},7,"F-H0-7111",428,2},
  {{{0x886176f398a55c2d}},5,"F-H0-7112",862,4},
  {{{0x886176f398a55c2d}},5,"F-H0-7113",460,4},
  {{{0x1f2cd0509e527916}},5,"F-H0-7114",727,2},
  {{{0x657b499cc3762597}},4,"F-H0-7115",460,3},
  {{{0x8c297f23d64f04f}},4,"F-H0-7116",948,3},
  {{{0x8c297f23d64f04f}},4,"F-H0-7117",838,2},
  {{{0x8c297f23d64f04f}},4,"F-H0-7118",431,2},
  {{{0xf87c5fc203cca7ed}},10,"F-H0-7119",981,11},
  {{{0xa68504aabb07ad1a}},10,"F-H0-7120",423,2},
  {{{0x82ba15e9c959992f}},14,"F-H0-7121",941,5},
  {{{0x82ba15e9c959992f}},14,"F-H0-7122",945,4},
  {{{0xfa6466bd23210b42}},14,"F-H0-7123",940,2},
  {{{0x82ba15e9c959992f}},14,"F-H0-7124",503,2},
  {{{0x74f14b77092b860f}},5,"F-H0-7125",425,7},
  {{{0xeca3175c059248cf}},5,"F-H0-7126",690,3},
  {{{0xeca3175c059248cf}},5,"F-H0-7127",943,2},
  {{{0x33c2bd3d73e9e9d5}},5,"F-H0-7128",426,2},
  {{{0xe15b60878dcf389a}},4,"F-H0-7129",429,11},
  {{{0xe7b9ccd744c3e645}},5,"F-H0-7130",421,7},
  {{{0x5043601658c34078}},5,"F-H0-7131",939,2},
  {{{0x39b85abe37eb5cdc}},5,"F-H0-7132",941,2},
  {{{0xe4de4ba5b19a5c30}},5,"F-H0-7133",425,2},
  {{{0xe7b9ccd744c3e645}},5,"F-H0-7134",839,2},
  {{{0xb8d3515029222aed}},6,"F-H0-7135",418,9},
  {{{0xa27005b194321a73}},6,"F-H0-7136",873,3},
  {{{0xb8d3515029222aed}},6,"F-H0-7137",425,2},
  {{{0xb009325eac57e1c4}},8,"F-H0-7138",419,14},
  {{{0x3b7f78fe6c5bd97}},6,"F-H0-7139",493,5},
  {{{0x5f7e10406b855f02}},6,"F-H0-7140",678,4},
  {{{0x5cefc9c4edf7e5ce}},6,"F-H0-7141",839,2},
  {{{0x79410c98c310f624}},15,"F-H0-7142",418,6},
  {{{0x2a7a10686fed1202}},15,"F-H0-7143",764,5},
  {{{0xc44ca0fa11f31eb5}},7,"F-H0-7144",543,5},
  {{{0x7dfdf30e9eb54371}},7,"F-H0-7145",678,3},
  {{{0x6bc741f64f124c2e}},7,"F-H0-7146",654,2},
  {{{0x6bc741f64f124c2e}},7,"F-H0-7147",691,2},
  {{{0x6bc741f64f124c2e}},7,"F-H0-7148",543,2},
  {{{0x4beb043ae46ef9dd}},5,"F-H0-7149",529,10},
  {{{0x4beb043ae46ef9dd}},5,"F-H0-7150",945,3},
  {{{0xa8f9adb9a59b0166}},5,"F-H0-7151",906,3},
  {{{0xe2ae77aa3ff508fd}},5,"F-H0-7152",876,7},
  {{{0xe2ae77aa3ff508fd}},5,"F-H0-7153",910,2},
  {{{0xbea1403343c0b404}},5,"F-H0-7154",839,2},
  {{{0x3f79fd606b8fa492}},5,"F-H0-7155",948,2},
  {{{0x7b5692108c71155b}},8,"F-H0-7156",542,11},
  {{{0x7b5692108c71155b}},8,"F-H0-7157",579,6},
  {{{0xa6ed22c0ea260c6b}},7,"F-H0-7158",566,6},
  {{{0xa6ed22c0ea260c6b}},7,"F-H0-7159",496,4},
  {{{0x9d4930587a1843bc}},6,"F-H0-7160",506,7},
  {{{0xef7dd4f00a451adb}},6,"F-H0-7161",788,5},
  {{{0x7c5305f01391260}},12,"F-H0-7162",947,7},
  {{{0x7c5305f01391260}},12,"F-H0-7163",946,2},
  {{{0xd571500d8441d3d1}},12,"F-H0-7164",902,2},
  {{{0xd571500d8441d3d1}},12,"F-H0-7165",715,2},
  {{{0xd571500d8441d3d1}},12,"F-H0-7166",714,2},
  {{{0x1fc653b1bd906caf}},6,"F-H0-7167",941,5},
  {{{0xa54f322bb71a4ce}},6,"F-H0-7168",838,4},
  {{{0x7baf55bd5fe4ef9b}},7,"F-H0-7169",469,13},
  {{{0x68aa762e1e4ffa47}},8,"F-H0-7170",908,3},
  {{{0x68aa762e1e4ffa47}},8,"F-H0-7171",946,3},
  {{{0x68aa762e1e4ffa47}},8,"F-H0-7172",907,3},
  {{{0xd846b5d8d6540386}},8,"F-H0-7173",492,2},
  {{{0x4459effad8f5dd16}},13,"F-H0-7174",937,2},
  {{{0xed1be3c423b513fa}},6,"F-H0-7175",765,4},
  {{{0xed1be3c423b513fa}},6,"F-H0-7176",727,3},
  {{{0xed1be3c423b513fa}},6,"F-H0-7177",678,2},
  {{{0x134bf9e88fea4513}},6,"F-H0-7178",864,13},
  {{{0xea8963d9cc1bb547}},6,"F-H0-7179",418,2},
  {{{0x719c24a693b99d94}},6,"F-H0-7180",863,5},
  {{{0xafa933018efdd907}},6,"F-H0-7181",948,3},
  {{{0xafa933018efdd907}},6,"F-H0-7182",752,3},
  {{{0x719c24a693b99d94}},6,"F-H0-7183",458,2},
  {{{0x8dc8953f01634a6d}},10,"F-H0-7184",838,4},
  {{{0x8dc8953f01634a6d}},10,"F-H0-7185",801,3},
  {{{0xb22594b996d8629b}},10,"F-H0-7186",936,7},
  {{{0x61596f2623efd3e5}},10,"F-H0-7187",430,7},
  {{{0xf106c129b865fcac}},10,"F-H0-7188",937,2},
  {{{0x42d8031f977755a8}},5,"F-H0-7189",825,5},
  {{{0x42d8031f977755a8}},5,"F-H0-7190",839,5},
  {{{0xb01cc3def7b272a8}},5,"F-H0-7191",462,3},
  {{{0x519862b780dd3908}},3,"F-H0-7192",949,9},
  {{{0x18c17d8bce1bf30}},3,"F-H0-7193",468,3},
  {{{0x79e3245138529db6}},3,"F-H0-7194",419,2},
  {{{0x4422297e0c22170}},8,"F-H0-7195",455,15},
  {{{0xf9058d46fd3ee0b3}},9,"F-H0-7196",531,14},
  {{{0xb2c9a57799952f10}},9,"F-H0-7197",978,2},
  {{{0x49dfd3090dfe4188}},6,"F-H0-7198",395,13},
  {{{0xc25bfa5bf557841c}},5,"F-H0-7199",543,6},
  {{{0xc25bfa5bf557841c}},5,"F-H0-7200",506,4},
  {{{0xbddd506ea3666d47}},5,"F-H0-7201",947,3},
  {{{0xc25bfa5bf557841c}},5,"F-H0-7202",801,3},
  {{{0x3be0f2f646a5d697}},5,"F-H0-7203",911,6},
  {{{0x3be0f2f646a5d697}},5,"F-H0-7204",462,3},
  {{{0x3be0f2f646a5d697}},5,"F-H0-7205",948,2},
  {{{0x70ec03688151bdc2}},2,"F-H0-7206",455,6},
  {{{0xf7484c89a8560cb5}},2,"F-H0-7207",469,2},
  {{{0x70ec03688151bdc2}},2,"F-H0-7208",456,2},
  {{{0xc65229b1cc93e393}},7,"F-H0-7209",421,5},
  {{{0xc65229b1cc93e393}},7,"F-H0-7210",458,3},
  {{{0x75e61d016b039ba5}},7,"F-H0-7211",906,2},
  {{{0x25b1098632a0a396}},7,"F-H0-7212",728,2},
  {{{0xc65229b1cc93e393}},7,"F-H0-7213",641,2},
  {{{0x3e5d4c5c119df0ce}},7,"F-H0-7214",422,9},
  {{{0xa3c6cf1baec3a30}},7,"F-H0-7215",691,3},
  {{{0x2030095480818c0}},14,"F-H0-7216",455,6},
  {{{0x92679dbd7093a617}},7,"F-H0-7217",417,9},
  {{{0xcf29efeddbc05053}},9,"F-H0-7218",827,11},
  {{{0x1d87409698b36b19}},8,"F-H0-7219",462,10},
  {{{0xec7a16a227637993}},8,"F-H0-7220",467,3},
  {{{0x7f9b74deed4a0623}},5,"F-H0-7221",825,4},
  {{{0x7f9b74deed4a0623}},5,"F-H0-7222",506,3},
  {{{0x3b4efe0d10c0e69}},5,"F-H0-7223",459,2},
  {{{0x7f9b74deed4a0623}},5,"F-H0-7224",543,2},
  {{{0x5950221a08d5875d}},12,"F-H0-7225",467,8},
  {{{0xb8a39b167ab967fe}},12,"F-H0-7226",543,2},
  {{{0x31c51aa71bb35c3b}},12,"F-H0-7227",569,2},
  {{{0xd11a46a826604a3e}},10,"F-H0-7228",714,11},
  {{{0x5363c513429bba2}},10,"F-H0-7229",423,4},
  {{{0x10f3a6bdb175ffa9}},7,"F-H0-7230",418,10},
  {{{0x10f3a6bdb175ffa9}},7,"F-H0-7231",422,3},
  {{{0xbab687475802b0cf}},10,"F-H0-7232",906,13},
  {{{0x8ab9b26e5f1a7d2b}},10,"F-H0-7233",752,2},
  {{{0x68c96927305348bd}},8,"F-H0-7234",876,4},
  {{{0xdd7701ecfdcd4746}},8,"F-H0-7235",908,4},
  {{{0x3a5751ca85b71a17}},8,"F-H0-7236",458,2},
  {{{0x64eed6dbe63d0995}},11,"F-H0-7237",654,2},
  {{{0x2af3d9fdf9035980}},11,"F-H0-7238",578,13},
  {{{0x2af3d9fdf9035980}},11,"F-H0-7239",542,2},
  {{{0x2719e9752758af99}},8,"F-H0-7240",502,5},
  {{{0x9722ceb99b089948}},8,"F-H0-7241",827,3},
  {{{0x21db844b163a1eb7}},3,"F-H0-7242",468,9},
  {{{0x27ef067e45407bb6}},3,"F-H0-7243",431,4},
  {{{0x505a7617815cd7d7}},4,"F-H0-7244",913,4},
  {{{0xb3e6fdd63d853326}},4,"F-H0-7245",505,3},
  {{{0xb3e6fdd63d853326}},4,"F-H0-7246",907,2},
  {{{0x4345b6f0933373f0}},16,"F-H0-7247",945,14},
  {{{0x811fb7764d9b20d}},5,"F-H0-7248",466,7},
  {{{0x811fb7764d9b20d}},5,"F-H0-7249",653,4},
  {{{0x811fb7764d9b20d}},5,"F-H0-7250",617,3},
  {{{0xa590386163909f3c}},12,"F-H0-7251",529,6},
  {{{0xa590386163909f3c}},12,"F-H0-7252",530,5},
  {{{0xff633acf6851ca83}},10,"F-H0-7253",837,5},
  {{{0x1409475164917dcd}},10,"F-H0-7254",578,3},
  {{{0xcad1243c4bbdf678}},8,"F-H0-7255",942,7},
  {{{0x465e1c2231968d61}},8,"F-H0-7256",425,3},
  {{{0xcad1243c4bbdf678}},8,"F-H0-7257",543,2},
  {{{0xcad1243c4bbdf678}},8,"F-H0-7258",421,2},
  {{{0x20e36771e8dfc374}},5,"F-H0-7259",506,4},
  {{{0x20e36771e8dfc374}},5,"F-H0-7260",580,3},
  {{{0x8e5572bf99bcbc40}},5,"F-H0-7261",504,3},
  {{{0x8e5572bf99bcbc40}},5,"F-H0-7262",464,3},
  {{{0x8abebc540aa1da85}},4,"F-H0-7263",949,7},
  {{{0xb84cd4b093668e4b}},16,"F-H0-7264",910,3},
  {{{0xdd8162ef0a7ec1dd}},16,"F-H0-7265",543,3},
  {{{0x47a1499dc5b83e61}},4,"F-H0-7266",906,5},
  {{{0x47505b0eb5ae03e7}},4,"F-H0-7267",678,4},
  {{{0x382568c3a481a15d}},4,"F-H0-7268",678,2},
  {{{0x542cf495ab2f383f}},10,"F-H0-7269",424,9},
  {{{0x542cf495ab2f383f}},10,"F-H0-7270",423,4},
  {{{0x4eca832888a10528}},12,"F-H0-7271",765,7},
  {{{0x80a13360b1c79bb5}},12,"F-H0-7272",425,4},
  {{{0x9214947a613e8000}},14,"F-H0-7273",872,11},
  {{{0xdcbae9a07ae5379c}},14,"F-H0-7274",542,4},
  {{{0x2a16a9656418585a}},4,"F-H0-7275",913,7},
  {{{0xe97079768091972b}},4,"F-H0-7276",911,6},
  {{{0x45078a5b2dfe6b88}},5,"F-H0-7277",863,4},
  {{{0x7dacbce64beb9514}},5,"F-H0-7278",530,4},
  {{{0x7dacbce64beb9514}},5,"F-H0-7279",420,3},
  {{{0xd79ac81980c6d238}},5,"F-H0-7280",764,2},
  {{{0x876c088de00d4d67}},12,"F-H0-7281",826,13},
  {{{0x876c088de00d4d67}},12,"F-H0-7282",974,2},
  {{{0x18d6a55e2800cb5}},9,"F-H0-7283",827,12},
  {{{0xcf4f13a00832df71}},10,"F-H0-7284",469,11},
  {{{0xeb828b4f17549270}},8,"F-H0-7285",505,3},
  {{{0xbc412cd11c1f4074}},8,"F-H0-7286",867,3},
  {{{0xd9ca303e4a71ae0}},8,"F-H0-7287",908,2},
  {{{0xbc412cd11c1f4074}},8,"F-H0-7288",940,2},
  {{{0x29d545f26a7ecdaa}},2,"F-H0-7289",913,8},
  {{{0xae710a1343797cdd}},2,"F-H0-7290",468,3},
  {{{0xae710a1343797cdd}},2,"F-H0-7291",456,2},
  {{{0x32bec2a901d960c7}},5,"F-H0-7292",458,5},
  {{{0xc46f037f4b1e0ec5}},5,"F-H0-7293",939,5},
  {{{0xc46f037f4b1e0ec5}},5,"F-H0-7294",875,2},
  {{{0x7561c903c120e00e}},10,"F-H0-7295",429,7},
  {{{0x6f883466d8114360}},10,"F-H0-7296",902,4},
  {{{0x6f883466d8114360}},10,"F-H0-7297",751,2},
  {{{0xff511d49905e736a}},8,"F-H0-7298",641,8},
  {{{0xea3da2bbdcf38104}},8,"F-H0-7299",974,3},
  {{{0x5db6130215488a00}},8,"F-H0-7300",902,11},
  {{{0x5d40966a3a91c0af}},15,"F-H0-7301",417,9},
  {{{0xe6bc112b20f0c086}},15,"F-H0-7302",985,3},
  {{{0xc85e0ffa24471032}},6,"F-H0-7303",418,7},
  {{{0xa74a5359a8e3eade}},6,"F-H0-7304",938,2},
  {{{0xb12fea0e3fadd960}},6,"F-H0-7305",837,2},
  {{{0xc85e0ffa24471032}},6,"F-H0-7306",529,2},
  {{{0x82c1562da7d48817}},14,"F-H0-7307",945,7},
  {{{0x8d37e4065385fd75}},14,"F-H0-7308",902,2},
  {{{0x8d37e4065385fd75}},14,"F-H0-7309",826,2},
  {{{0x8d37e4065385fd75}},14,"F-H0-7310",827,2},
  {{{0xf0da6efbd612f259}},9,"F-H0-7311",491,9},
  {{{0x1853383bd56b9d70}},5,"F-H0-7312",950,5},
  {{{0x432daa2d824a3706}},7,"F-H0-7313",690,14},
  {{{0xc6e7170de32caa53}},6,"F-H0-7314",616,4},
  {{{0xf13a9990d2ecd092}},6,"F-H0-7315",904,3},
  {{{0xc6e7170de32caa53}},6,"F-H0-7316",506,2},
  {{{0x74100897b6a45dfa}},6,"F-H0-7317",946,2},
  {{{0x6b8bffd2272c774c}},7,"F-H0-7318",912,6},
  {{{0x6b8bffd2272c774c}},7,"F-H0-7319",911,6},
  {{{0x6b8bffd2272c774c}},7,"F-H0-7320",874,2},
  {{{0x45fe436501bd490d}},11,"F-H0-7321",825,6},
  {{{0x41a36ffc657f0636}},11,"F-H0-7322",839,4},
  {{{0x41a36ffc657f0636}},11,"F-H0-7323",943,3},
  {{{0xa934ca1eec47e2eb}},7,"F-H0-7324",839,9},
  {{{0xa95c8934fd57303b}},7,"F-H0-7325",428,6},
  {{{0x222a7af479bbf7f4}},11,"F-H0-7326",506,6},
  {{{0x222a7af479bbf7f4}},11,"F-H0-7327",505,5},
  {{{0x7149bfb82bc7c0b5}},12,"F-H0-7328",908,10},
  {{{0x7149bfb82bc7c0b5}},12,"F-H0-7329",939,3},
  {{{0x6ccc534a8ae7d398}},5,"F-H0-7330",431,3},
  {{{0x5884670605b1b90c}},5,"F-H0-7331",530,2},
  {{{0x3db6a55b30bd4935}},9,"F-H0-7332",898,11},
  {{{0xdfee11e68b83b27a}},9,"F-H0-7333",616,2},
  {{{0x3db6a55b30bd4935}},9,"F-H0-7334",829,2},
  {{{0xf8d44693bae2c280}},9,"F-H0-7335",690,3},
  {{{0x3dfc82321fbac71}},6,"F-H0-7336",531,5},
  {{{0x3dfc82321fbac71}},6,"F-H0-7337",876,3},
  {{{0x88b1c01190f249f9}},6,"F-H0-7338",580,2},
  {{{0x88b1c01190f249f9}},6,"F-H0-7339",912,2},
  {{{0xdc8128bb240d1d06}},4,"F-H0-7340",462,4},
  {{{0xbc936ab392b58a69}},4,"F-H0-7341",419,4},
  {{{0xbc936ab392b58a69}},4,"F-H0-7342",425,2},
  {{{0xbc936ab392b58a69}},4,"F-H0-7343",457,2},
  {{{0x12e64dce5de9d071}},8,"F-H0-7344",947,10},
  {{{0xf92acd7ab590fce2}},8,"F-H0-7345",640,2},
  {{{0xdb838e23d0907844}},4,"F-H0-7346",912,5},
  {{{0xdb838e23d0907844}},4,"F-H0-7347",457,2},
  {{{0x48e1364c2693ed3a}},4,"F-H0-7348",419,2},
  {{{0x48e1364c2693ed3a}},4,"F-H0-7349",467,2},
  {{{0x9933007101139a9d}},16,"F-H0-7350",394,10},
  {{{0x9a10b4a634996da7}},16,"F-H0-7351",417,6},
  {{{0x23b3366165e7a0cf}},9,"F-H0-7352",838,4},
  {{{0x5900f1478a751bf1}},9,"F-H0-7353",461,4},
  {{{0xab38148e5ec76a}},9,"F-H0-7354",678,3},
  {{{0xab38148e5ec76a}},9,"F-H0-7355",421,2},
  {{{0xc6c99c8e93f82732}},10,"F-H0-7356",947,9},
  {{{0x248f5d0ecead6ef9}},10,"F-H0-7357",838,2},
  {{{0x3ea2dfb88a2307fd}},7,"F-H0-7358",947,9},
  {{{0x3ea2dfb88a2307fd}},7,"F-H0-7359",946,5},
  {{{0xd413945fd946050b}},16,"F-H0-7360",910,12},
  {{{0x1e745429eb9c4eb6}},4,"F-H0-7361",826,2},
  {{{0xa8ed5fa8f4f9c8ed}},14,"F-H0-7362",951,12},
  {{{0xa4395ead496ee44c}},16,"F-H0-7363",983,9},
  {{{0xa4395ead496ee44c}},16,"F-H0-7364",801,2},
  {{{0x65c6a2713ac357c4}},7,"F-H0-7365",617,8},
  {{{0x65c6a2713ac357c4}},7,"F-H0-7366",506,4},
  {{{0x602847afe1de0231}},16,"F-H0-7367",802,5},
  {{{0x602847afe1de0231}},16,"F-H0-7368",910,4},
  {{{0x602847afe1de0231}},16,"F-H0-7369",876,3},
  {{{0x602847afe1de0231}},16,"F-H0-7370",764,2},
  {{{0x66ddc8682c053382}},6,"F-H0-7371",541,10},
  {{{0x66ddc8682c053382}},6,"F-H0-7372",432,4},
  {{{0x367e1a235a0eabce}},9,"F-H0-7373",801,11},
  {{{0x427eacb8816a495e}},13,"F-H0-7374",986,11},
  {{{0xf8a270f18d5d78bf}},8,"F-H0-7375",865,15},
  {{{0x7c3992186974e35b}},13,"F-H0-7376",492,11},
  {{{0x1902f2322ec13dd8}},13,"F-H0-7377",914,5},
  {{{0x71c72090d9930f1a}},2,"F-H0-7378",899,14},
  {{{0x8ad0cb404f4dafa9}},5,"F-H0-7379",839,3},
  {{{0x481f195f5464110c}},5,"F-H0-7380",457,3},
  {{{0x481f195f5464110c}},5,"F-H0-7381",458,2},
  {{{0xb264dff97f069968}},5,"F-H0-7382",393,5},
  {{{0xb264dff97f069968}},5,"F-H0-7383",431,4},
  {{{0xba080f8c04930f7f}},6,"F-H0-7384",861,5},
  {{{0xb9734e98f0f9d5fc}},9,"F-H0-7385",873,9},
  {{{0x71f994f0f6ffa164}},9,"F-H0-7386",978,4},
  {{{0x4d73e68584f23f35}},7,"F-H0-7387",789,11},
  {{{0xf080639d2d084d3a}},12,"F-H0-7388",839,7},
  {{{0x738c131f7d3144c2}},12,"F-H0-7389",826,6},
  {{{0x9f74279cf5fdb788}},14,"F-H0-7390",945,8},
  {{{0x2b3e1268b28a897a}},14,"F-H0-7391",838,2},
  {{{0xd52e0513fdd1ade2}},14,"F-H0-7392",865,2},
  {{{0x404fc575d7dfa6ed}},11,"F-H0-7393",865,10},
  {{{0x440e8797aec624f2}},10,"F-H0-7394",690,14},
  {{{0xa5060170dbffa6b0}},4,"F-H0-7395",862,5},
  {{{0x38e558866621ba58}},4,"F-H0-7396",421,2},
  {{{0x34eab629a715099c}},4,"F-H0-7397",421,2},
  {{{0xd62bc8321ea2e0}},7,"F-H0-7398",911,6},
  {{{0x785e6c20032880df}},7,"F-H0-7399",825,2},
  {{{0x785e6c20032880df}},7,"F-H0-7400",457,2},
  {{{0xd62bc8321ea2e0}},7,"F-H0-7401",862,2},
  {{{0x8fa1331352faf2d8}},5,"F-H0-7402",460,7},
  {{{0x6ddda8f2c894bcbe}},5,"F-H0-7403",946,2},
  {{{0x8fa1331352faf2d8}},5,"F-H0-7404",530,2},
  {{{0xb98dbd925837c43e}},5,"F-H0-7405",506,2},
  {{{0x1575158664fde8a1}},5,"F-H0-7406",654,3},
  {{{0x9200909234657f24}},5,"F-H0-7407",943,2},
  {{{0x9200909234657f24}},5,"F-H0-7408",825,2},
  {{{0x3a91c2a829fa84d1}},5,"F-H0-7409",469,2},
  {{{0xee5523ddc1a7c705}},5,"F-H0-7410",943,5},
  {{{0xee5523ddc1a7c705}},5,"F-H0-7411",942,4},
  {{{0xee5523ddc1a7c705}},5,"F-H0-7412",906,2},
  {{{0xbb4c9adfac596690}},11,"F-H0-7413",838,13},
  {{{0x421d7b4d5cd09485}},6,"F-H0-7414",690,7},
  {{{0xdc63095447034053}},6,"F-H0-7415",432,2},
  {{{0xb9ac909a4fc803e9}},3,"F-H0-7416",463,3},
  {{{0xb9ac909a4fc803e9}},3,"F-H0-7417",543,2},
  {{{0xb9ac909a4fc803e9}},3,"F-H0-7418",427,2},
  {{{0xe9e98304296852e1}},9,"F-H0-7419",493,11},
  {{{0xaa11842f898b1d87}},9,"F-H0-7420",789,3},
  {{{0xca78de1989880c29}},6,"F-H0-7421",467,12},
  {{{0xca78de1989880c29}},6,"F-H0-7422",466,2},
  {{{0x219fefa220bff680}},3,"F-H0-7423",912,11},
  {{{0xf459133dc580d039}},3,"F-H0-7424",950,2},
  {{{0x2be6b2401ad469e6}},6,"F-H0-7425",429,10},
  {{{0x2be6b2401ad469e6}},6,"F-H0-7426",468,6},
  {{{0xf1e03a278e6872ba}},8,"F-H0-7427",751,6},
  {{{0xf1e03a278e6872ba}},8,"F-H0-7428",902,3},
  {{{0xf1e03a278e6872ba}},8,"F-H0-7429",864,2},
  {{{0x56549c346d0bc218}},8,"F-H0-7430",579,14},
  {{{0x71278f7f2765f770}},7,"F-H0-7431",946,7},
  {{{0x8b8d8449adbcd47}},7,"F-H0-7432",939,5},
  {{{0xe48ac05b311d18cb}},7,"F-H0-7433",492,3},
  {{{0xcac44a9c97c00742}},9,"F-H0-7434",873,7},
  {{{0xcac44a9c97c00742}},9,"F-H0-7435",950,2},
  {{{0xcac44a9c97c00742}},9,"F-H0-7436",875,2},
  {{{0x295d41da65a25c65}},4,"F-H0-7437",826,7},
  {{{0x295d41da65a25c65}},4,"F-H0-7438",825,4},
  {{{0x1c0acc93423f30b6}},16,"F-H0-7439",839,9},
  {{{0x1c0acc93423f30b6}},16,"F-H0-7440",945,2},
  {{{0x1c0acc93423f30b6}},16,"F-H0-7441",802,2},
  {{{0x977df75edd0ffcfc}},16,"F-H0-7442",866,7},
  {{{0x9d413ec5e3997917}},4,"F-H0-7443",944,4},
  {{{0x5bd72764852e4744}},4,"F-H0-7444",505,3},
  {{{0xb1ef03d6f286058a}},4,"F-H0-7445",899,2},
  {{{0xa4425fd37c4ec92c}},4,"F-H0-7446",938,2},
  {{{0x9d413ec5e3997917}},4,"F-H0-7447",907,2},
  {{{0x8953c3e4b0dd5d2a}},3,"F-H0-7448",418,8},
  {{{0x8953c3e4b0dd5d2a}},3,"F-H0-7449",455,3},
  {{{0x7d328a64d41c6704}},16,"F-H0-7450",827,9},
  {{{0x7d328a64d41c6704}},16,"F-H0-7451",862,2},
  {{{0xab465b25203c58de}},5,"F-H0-7452",911,7},
  {{{0x3b5657fc04bf620c}},5,"F-H0-7453",825,2},
  {{{0x3b5657fc04bf620c}},5,"F-H0-7454",826,2},
  {{{0x83284e99e40728d9}},6,"F-H0-7455",429,4},
  {{{0x5627dce8f2ae09cb}},6,"F-H0-7456",418,3},
  {{{0x83284e99e40728d9}},6,"F-H0-7457",690,3},
  {{{0x83284e99e40728d9}},6,"F-H0-7458",906,2},
  {{{0xa5464dece0b19c59}},11,"F-H0-7459",714,14},
  {{{0x2c03736bf18760c1}},17,"F-H0-7460",839,3},
  {{{0x674ae45a7adba84a}},9,"F-H0-7461",678,11},
  {{{0x5a902c4118f8bc82}},9,"F-H0-7462",914,3},
  {{{0xae26e2efd13d8dc8}},7,"F-H0-7463",542,12},
  {{{0xae26e2efd13d8dc8}},7,"F-H0-7464",466,3},
  {{{0x4d06e1ed1cb6078a}},3,"F-H0-7465",458,3},
  {{{0xcc3b4e066971b883}},3,"F-H0-7466",825,2},
  {{{0xd0103d998e58cc35}},3,"F-H0-7467",876,2},
  {{{0x26e8dcf5820b0ac6}},3,"F-H0-7468",505,2},
  {{{0xe5c5eb162b43fc51}},18,"F-H0-7469",940,7},
  {{{0x519e099ed2106411}},18,"F-H0-7470",427,3},
  {{{0x519e099ed2106411}},18,"F-H0-7471",578,2},
  {{{0x78ddb0fedca09b0b}},12,"F-H0-7472",690,2},
  {{{0x33a1370b1a0867a9}},5,"F-H0-7473",728,4},
  {{{0x1f250bb3457a7775}},5,"F-H0-7474",462,3},
  {{{0x33a1370b1a0867a9}},5,"F-H0-7475",467,2},
  {{{0x33a1370b1a0867a9}},5,"F-H0-7476",420,2},
  {{{0x33a1370b1a0867a9}},5,"F-H0-7477",825,2},
  {{{0x849729acaca7fc06}},8,"F-H0-7478",986,10},
  {{{0x57489a813b60a9ef}},16,"F-H0-7479",382,5},
  {{{0x57489a813b60a9ef}},16,"F-H0-7480",421,4},
  {{{0x4449859830905f12}},16,"F-H0-7481",829,2},
  {{{0xe67684a1b2fc4857}},16,"F-H0-7482",987,2},
  {{{0x296d8edf2ef809fb}},10,"F-H0-7483",728,8},
  {{{0x4c8884efb063cf02}},10,"F-H0-7484",904,7},
  {{{0x8d5b4d9fe9c86313}},6,"F-H0-7485",764,4},
  {{{0x8d5b4d9fe9c86313}},6,"F-H0-7486",801,3},
  {{{0x8d5b4d9fe9c86313}},6,"F-H0-7487",429,2},
  {{{0x8d5b4d9fe9c86313}},6,"F-H0-7488",678,2},
  {{{0x76ae2970fc691fcd}},8,"F-H0-7489",715,9},
  {{{0xabd8578c384849b0}},6,"F-H0-7490",543,4},
  {{{0xabd8578c384849b0}},6,"F-H0-7491",906,4},
  {{{0xabd8578c384849b0}},6,"F-H0-7492",542,2},
  {{{0xd7ec9560089873ec}},9,"F-H0-7493",801,5},
  {{{0xd7ec9560089873ec}},9,"F-H0-7494",837,4},
  {{{0xd7ec9560089873ec}},9,"F-H0-7495",876,4},
  {{{0x63500587c126a389}},8,"F-H0-7496",495,2},
  {{{0x1cb86d69ac4b50e7}},8,"F-H0-7497",950,2},
  {{{0x9f35f1651c50a754}},11,"F-H0-7498",427,8},
  {{{0x7d36988ccaf31138}},11,"F-H0-7499",839,2},
  {{{0x3e7f9254456aa564}},11,"F-H0-7500",457,2},
  {{{0x75cca320ea8109f7}},7,"F-H0-7501",678,7},
  {{{0xc88147fb5161ede2}},7,"F-H0-7502",603,2},
  {{{0xa51faec0fe4d302f}},10,"F-H0-7503",615,2},
  {{{0x9369f536ef320452}},9,"F-H0-7504",911,10},
  {{{0x72e0f3f03c05189}},9,"F-H0-7505",429,3},
  {{{0x9369f536ef320452}},9,"F-H0-7506",948,2},
  {{{0xfcf3f4c20fac3e70}},7,"F-H0-7507",839,7},
  {{{0xfcf3f4c20fac3e70}},7,"F-H0-7508",913,3},
  {{{0xf8005e878b1952ac}},6,"F-H0-7509",906,7},
  {{{0x370dade76f8eb010}},6,"F-H0-7510",454,3},
  {{{0x862f8539abc37ca6}},3,"F-H0-7511",949,7},
  {{{0x862f8539abc37ca6}},3,"F-H0-7512",911,3},
  {{{0x6f48bc258b3b093c}},3,"F-H0-7513",456,2},
  {{{0x8fcd827a7a53bbd9}},3,"F-H0-7514",862,2},
  {{{0xf232543777552860}},7,"F-H0-7515",542,12},
  {{{0xf232543777552860}},7,"F-H0-7516",466,2},
  {{{0xaf484e54d63a7df5}},4,"F-H0-7517",506,4},
  {{{0xb6e9b22d622a5147}},4,"F-H0-7518",911,4},
  {{{0xb6e9b22d622a5147}},4,"F-H0-7519",948,2},
  {{{0xaf484e54d63a7df5}},4,"F-H0-7520",949,2},
  {{{0xa10e0b605161bc14}},10,"F-H0-7521",862,7},
  {{{0xfcaa2a6842a9e909}},10,"F-H0-7522",975,5},
  {{{0xfcaa2a6842a9e909}},10,"F-H0-7523",973,2},
  {{{0x9a0937666351cc3e}},9,"F-H0-7524",752,10},
  {{{0x8ff63d7e03f80e08}},6,"F-H0-7525",458,5},
  {{{0x417f2ad469500415}},6,"F-H0-7526",947,4},
  {{{0x82ec9c0a0450e0a7}},6,"F-H0-7527",910,2},
  {{{0xaf95d6ecb78bd72c}},6,"F-H0-7528",941,2},
  {{{0x81b637a42cf2536f}},18,"F-H0-7529",936,8},
  {{{0x6482c85d4d8012e0}},18,"F-H0-7530",529,3},
  {{{0x60279653d08d37e6}},7,"F-H0-7531",469,12},
  {{{0x60279653d08d37e6}},7,"F-H0-7532",431,2},
  {{{0xcb972eacbfdfb04e}},8,"F-H0-7533",579,11},
  {{{0xd2804dd4fc145a2e}},13,"F-H0-7534",946,5},
  {{{0xc396236a47a72ffb}},7,"F-H0-7535",976,2},
  {{{0x91245c26ec677f4a}},12,"F-H0-7536",579,7},
  {{{0x91245c26ec677f4a}},12,"F-H0-7537",502,3},
  {{{0x3ff2852ff909385c}},8,"F-H0-7538",824,5},
  {{{0x6e25e31fad3deb46}},6,"F-H0-7539",947,3},
  {{{0x6e25e31fad3deb46}},6,"F-H0-7540",727,2},
  {{{0x6e25e31fad3deb46}},6,"F-H0-7541",910,2},
  {{{0x824367d8a46f5ba3}},4,"F-H0-7542",455,6},
  {{{0x9e27bbcc2929e9ac}},4,"F-H0-7543",901,2},
  {{{0xf660688455f2d738}},4,"F-H0-7544",422,2},
  {{{0xd48a1ae50d4a9e6d}},17,"F-H0-7545",905,8},
  {{{0xe4f40f4fbc2f5c9e}},17,"F-H0-7546",872,12},
  {{{0x4891bdeb14c9f6cd}},17,"F-H0-7547",616,2},
  {{{0x8f39d961a6bb0652}},10,"F-H0-7548",506,3},
  {{{0xb1d4266672a8dcdf}},10,"F-H0-7549",940,3},
  {{{0x62b7b35359f57e6d}},3,"F-H0-7550",949,2},
  {{{0x62b7b35359f57e6d}},3,"F-H0-7551",506,2},
  {{{0x62b7b35359f57e6d}},3,"F-H0-7552",912,2},
  {{{0x6e6836e53a9071a7}},9,"F-H0-7553",506,13},
  {{{0x4e63af926e59f7e7}},5,"F-H0-7554",764,4},
  {{{0x121efb3f33071610}},5,"F-H0-7555",428,2},
  {{{0x331949f068d1cf38}},5,"F-H0-7556",617,2},
  {{{0x83a575573a0af52}},9,"F-H0-7557",801,5},
  {{{0x83a575573a0af52}},9,"F-H0-7558",950,2},
  {{{0x6b43c26a15912264}},4,"F-H0-7559",467,5},
  {{{0x6b43c26a15912264}},4,"F-H0-7560",430,3},
  {{{0xc116c987ec192db5}},4,"F-H0-7561",530,2},
  {{{0xd7c2c91237e93346}},7,"F-H0-7562",825,9},
  {{{0xd588dfe860056534}},17,"F-H0-7563",950,9},
  {{{0xd588dfe860056534}},17,"F-H0-7564",944,2},
  {{{0xd588dfe860056534}},17,"F-H0-7565",837,2},
  {{{0xaef412e0e589ef91}},4,"F-H0-7566",862,6},
  {{{0xaef412e0e589ef91}},4,"F-H0-7567",529,4},
  {{{0xaef412e0e589ef91}},4,"F-H0-7568",431,2},
  {{{0xfaa7cca7a6d77900}},4,"F-H0-7569",862,6},
  {{{0xfaa7cca7a6d77900}},4,"F-H0-7570",456,2},
  {{{0xfaa7cca7a6d77900}},4,"F-H0-7571",714,2},
  {{{0xfaa7cca7a6d77900}},4,"F-H0-7572",530,2},
  {{{0xca5c592d4e94d2ab}},3,"F-H0-7573",418,6},
  {{{0xca5c592d4e94d2ab}},3,"F-H0-7574",455,4},
  {{{0xc88eae929a5aa44c}},13,"F-H0-7575",543,12},
  {{{0xc88eae929a5aa44c}},13,"F-H0-7576",580,2},
  {{{0xa42da670ee33bb2b}},4,"F-H0-7577",906,4},
  {{{0xa42da670ee33bb2b}},4,"F-H0-7578",425,3},
  {{{0xa42da670ee33bb2b}},4,"F-H0-7579",468,2},
  {{{0xea92babb1d6f49e4}},4,"F-H0-7580",678,2},
  {{{0x138a10e125b6a064}},6,"F-H0-7581",653,7},
  {{{0x138a10e125b6a064}},6,"F-H0-7582",690,5},
  {{{0x138a10e125b6a064}},6,"F-H0-7583",470,2},
  {{{0x58b0178d58adafcc}},10,"F-H0-7584",949,13},
  {{{0x6e10e796aafc61fb}},9,"F-H0-7585",603,5},
  {{{0x6e10e796aafc61fb}},9,"F-H0-7586",939,5},
  {{{0xdfc09110f719c7d6}},10,"F-H0-7587",419,6},
  {{{0xdfc09110f719c7d6}},10,"F-H0-7588",456,2},
  {{{0xdfc09110f719c7d6}},10,"F-H0-7589",420,2},
  {{{0x6bf17bbc23b03ab9}},5,"F-H0-7590",466,6},
  {{{0x262505a14e26d562}},7,"F-H0-7591",455,12},
  {{{0x262505a14e26d562}},7,"F-H0-7592",419,2},
  {{{0x71f328c1c8820884}},8,"F-H0-7593",826,5},
  {{{0x71f328c1c8820884}},8,"F-H0-7594",941,5},
  {{{0xb2259a72be77096}},8,"F-H0-7595",421,2},
  {{{0xde59bb1e37f1e243}},10,"F-H0-7596",900,14},
  {{{0x6209593fe74687e8}},5,"F-H0-7597",691,4},
  {{{0x8249c736cf9bc4b8}},5,"F-H0-7598",939,3},
  {{{0x882a58201dbb5591}},5,"F-H0-7599",678,3},
  {{{0x8249c736cf9bc4b8}},5,"F-H0-7600",424,2},
  {{{0xde1b2729c9752545}},4,"F-H0-7601",456,8},
  {{{0xb26659f4ffe960ff}},4,"F-H0-7602",467,2},
  {{{0xb26659f4ffe960ff}},4,"F-H0-7603",431,2},
  {{{0xc7f41b24e61bf255}},3,"F-H0-7604",862,6},
  {{{0xd48e9f1b6dea126e}},3,"F-H0-7605",825,4},
  {{{0x952ae3c202301023}},17,"F-H0-7606",974,5},
  {{{0xa79a8b2b150c3f7}},17,"F-H0-7607",825,4},
  {{{0xa79a8b2b150c3f7}},17,"F-H0-7608",837,2},
  {{{0xa4190ffc806d8cc8}},6,"F-H0-7609",432,4},
  {{{0xa4190ffc806d8cc8}},6,"F-H0-7610",541,3},
  {{{0xa4190ffc806d8cc8}},6,"F-H0-7611",429,3},
  {{{0xaca5db4cc36589ee}},9,"F-H0-7612",541,15},
  {{{0x48cebc7385ad28bb}},5,"F-H0-7613",462,3},
  {{{0x48cebc7385ad28bb}},5,"F-H0-7614",943,3},
  {{{0x48cebc7385ad28bb}},5,"F-H0-7615",875,3},
  {{{0xe1b29625d2e4575b}},5,"F-H0-7616",899,2},
  {{{0xba8e0653315538b3}},8,"F-H0-7617",936,5},
  {{{0x526d2725ef13b75e}},8,"F-H0-7618",579,5},
  {{{0x526d2725ef13b75e}},8,"F-H0-7619",431,2},
  {{{0x93cb923c04d78b0f}},5,"F-H0-7620",911,3},
  {{{0x93cb923c04d78b0f}},5,"F-H0-7621",943,2},
  {{{0x93cb923c04d78b0f}},5,"F-H0-7622",947,2},
  {{{0x15b94d03586f9a98}},5,"F-H0-7623",714,2},
  {{{0x6d707b6daabd918c}},2,"F-H0-7624",647,4},
  {{{0xce5df64ac44a8309}},2,"F-H0-7625",429,2},
  {{{0x8ebee23ce1198212}},12,"F-H0-7626",948,12},
  {{{0xda5fb625e0695d2d}},12,"F-H0-7627",837,2},
  {{{0x5d038f651a051dac}},11,"F-H0-7628",913,14},
  {{{0xa881886acadce10f}},4,"F-H0-7629",543,8},
  {{{0xa881886acadce10f}},4,"F-H0-7630",876,2},
  {{{0x21b25248f9889756}},5,"F-H0-7631",420,6},
  {{{0x68cb8735e2d45e4a}},5,"F-H0-7632",839,2},
  {{{0x1cf31b6c4697c3c9}},5,"F-H0-7633",493,2},
  {{{0x68cb8735e2d45e4a}},5,"F-H0-7634",466,2},
  {{{0x48fad0cccd8bb4ca}},5,"F-H0-7635",529,2},
  {{{0x183820341a561f58}},7,"F-H0-7636",949,10},
  {{{0x183820341a561f58}},7,"F-H0-7637",951,2},
  {{{0xd17bdd059640c54b}},11,"F-H0-7638",911,5},
  {{{0xd17bdd059640c54b}},11,"F-H0-7639",910,4},
  {{{0x5520c0744a6ba0fe}},11,"F-H0-7640",529,2},
  {{{0xe46e4807896e9e2b}},13,"F-H0-7641",939,10},
  {{{0x83b220cc90b1b85a}},8,"F-H0-7642",902,5},
  {{{0x83b220cc90b1b85a}},8,"F-H0-7643",827,2},
  {{{0x1146c9f83aab373b}},6,"F-H0-7644",432,14},
  {{{0xb7eabd1b75475fa}},7,"F-H0-7645",911,7},
  {{{0xb7eabd1b75475fa}},7,"F-H0-7646",948,2},
  {{{0xb7eabd1b75475fa}},7,"F-H0-7647",939,2},
  {{{0xb7eabd1b75475fa}},7,"F-H0-7648",943,2},
  {{{0xb909fcf73a6c167c}},10,"F-H0-7649",543,11},
  {{{0xdc96c6f72ba00cba}},8,"F-H0-7650",468,12},
  {{{0x15d38b627a8a1f45}},9,"F-H0-7651",432,11},
  {{{0x15d38b627a8a1f45}},9,"F-H0-7652",428,2},
  {{{0x6029613967c9db36}},8,"F-H0-7653",949,10},
  {{{0x6029613967c9db36}},8,"F-H0-7654",875,3},
  {{{0xacc3f1e99eee023b}},12,"F-H0-7655",875,7},
  {{{0x21365316665b42e8}},12,"F-H0-7656",940,5},
  {{{0x530c3dbd54373585}},12,"F-H0-7657",492,3},
  {{{0xe74ef49c5b827a}},3,"F-H0-7658",875,5},
  {{{0xe315b7a099b7cae5}},3,"F-H0-7659",505,4},
  {{{0xd38b5d5dad3f7519}},3,"F-H0-7660",493,2},
  {{{0x9abbefb603713917}},9,"F-H0-7661",914,6},
  {{{0x9abbefb603713917}},9,"F-H0-7662",690,2},
  {{{0xeebb5b0da47559f}},10,"F-H0-7663",462,7},
  {{{0x2d1366543a65ada7}},10,"F-H0-7664",677,4},
  {{{0xeebb5b0da47559f}},10,"F-H0-7665",467,3},
  {{{0xbacd016444e4a632}},7,"F-H0-7666",936,9},
  {{{0xed6c5a3770f50133}},7,"F-H0-7667",617,2},
  {{{0xed6c5a3770f50133}},7,"F-H0-7668",421,2},
  {{{0x3418268e0bbb6b36}},7,"F-H0-7669",421,8},
  {{{0xa3029bd8a41a65fa}},7,"F-H0-7670",913,3},
  {{{0x79976bc42c6b39c0}},7,"F-H0-7671",468,3},
  {{{0xb9025695725e5e2a}},2,"F-H0-7672",863,7},
  {{{0xc82ec4471e1c8432}},5,"F-H0-7673",543,6},
  {{{0x609c5ad4d6039e90}},5,"F-H0-7674",906,3},
  {{{0xc82ec4471e1c8432}},5,"F-H0-7675",801,2},
  {{{0xdffd01b3c672149a}},4,"F-H0-7676",543,5},
  {{{0xa788f1256f1223d5}},4,"F-H0-7677",543,4},
  {{{0x75f88b2a286fa7b0}},6,"F-H0-7678",690,7},
  {{{0x75f88b2a286fa7b0}},6,"F-H0-7679",425,2},
  {{{0xc6a246f4a8789be1}},4,"F-H0-7680",862,7},
  {{{0xfefb0ca48d84f6f3}},4,"F-H0-7681",911,4},
  {{{0xd597dc783e468137}},4,"F-H0-7682",876,2},
  {{{0x19a23645107ee535}},9,"F-H0-7683",427,7},
  {{{0x30aa682a0fc3696b}},9,"F-H0-7684",421,3},
  {{{0x19a23645107ee535}},9,"F-H0-7685",463,2},
  {{{0x19a23645107ee535}},9,"F-H0-7686",542,2},
  {{{0x8f83f74a95b849db}},10,"F-H0-7687",945,6},
  {{{0xd629d27e7b6eae69}},4,"F-H0-7688",419,9},
  {{{0x1485dfeee7b8db2a}},2,"F-H0-7689",505,2},
  {{{0x1485dfeee7b8db2a}},2,"F-H0-7690",457,2},
  {{{0x73cf29196306c1d}},17,"F-H0-7691",936,9},
  {{{0x10927dfb8de4e3d7}},17,"F-H0-7692",947,2},
  {{{0x10927dfb8de4e3d7}},17,"F-H0-7693",906,2},
  {{{0x437f3f23a46414c1}},8,"F-H0-7694",872,6},
  {{{0x48647ca886e41b7d}},8,"F-H0-7695",946,4},
  {{{0xa5f4b56d6840659a}},8,"F-H0-7696",826,3},
  {{{0x82db50a00ca89af5}},8,"F-H0-7697",802,8},
  {{{0x5bf6ae3267705ce1}},8,"F-H0-7698",838,2},
  {{{0x5bf6ae3267705ce1}},8,"F-H0-7699",948,2},
  {{{0x201eb476a6783b56}},8,"F-H0-7700",838,2},
  {{{0xe10db9fd933f0bdc}},6,"F-H0-7701",418,7},
  {{{0xac8a381aeffff1d9}},6,"F-H0-7702",541,5},
  {{{0x8b3f2205e0fc27e3}},5,"F-H0-7703",865,5},
  {{{0x945ef1b2f0883d5a}},5,"F-H0-7704",789,2},
  {{{0x7a5b877d3fc3a3f}},3,"F-H0-7705",911,13},
  {{{0x3e1cc8c5f382f718}},17,"F-H0-7706",543,2},
  {{{0x9013ba5a2ae63577}},17,"F-H0-7707",906,2},
  {{{0x3e1cc8c5f382f718}},17,"F-H0-7708",950,2},
  {{{0x3e1cc8c5f382f718}},17,"F-H0-7709",905,2},
  {{{0x3e1cc8c5f382f718}},17,"F-H0-7710",429,2},
  {{{0x38fe65c079583043}},17,"F-H0-7711",689,2},
  {{{0x7cccd782b28fd226}},11,"F-H0-7712",825,8},
  {{{0x7cccd782b28fd226}},11,"F-H0-7713",863,4},
  {{{0x1584af4f92b5430f}},4,"F-H0-7714",862,11},
  {{{0x7543f8ee251a3e0b}},4,"F-H0-7715",901,3},
  {{{0xf0d286c2ef87f69d}},7,"F-H0-7716",825,3},
  {{{0xd905972e0ede7571}},7,"F-H0-7717",462,3},
  {{{0xd905972e0ede7571}},7,"F-H0-7718",678,2},
  {{{0xc3e70f2cec80c14c}},7,"F-H0-7719",825,2},
  {{{0xd905972e0ede7571}},7,"F-H0-7720",466,2},
  {{{0x81a8c412a5000d38}},12,"F-H0-7721",801,10},
  {{{0xdf9b4aa113145379}},12,"F-H0-7722",790,4},
  {{{0x10b252f1643b0a56}},6,"F-H0-7723",505,9},
  {{{0x745b406a9a16ca05}},6,"F-H0-7724",911,2},
  {{{0xcb6a9aca0614dd01}},5,"F-H0-7725",911,6},
  {{{0xcb6a9aca0614dd01}},5,"F-H0-7726",910,2},
  {{{0x819a94cddae33479}},7,"F-H0-7727",395,10},
  {{{0xdbf615978b9cff76}},6,"F-H0-7728",911,10},
  {{{0xdbf615978b9cff76}},6,"F-H0-7729",727,2},
  {{{0x4b618c43149e9e5e}},9,"F-H0-7730",944,11},
  {{{0x6b1d1b7231d8981}},9,"F-H0-7731",603,14},
  {{{0xe571b4207a17ba09}},8,"F-H0-7732",905,7},
  {{{0x47bb4f892ff09fd1}},8,"F-H0-7733",539,2},
  {{{0x47bb4f892ff09fd1}},8,"F-H0-7734",470,2},
  {{{0x28aa46ebb2c54506}},4,"F-H0-7735",429,8},
  {{{0xf65f0884b2a1e6bc}},4,"F-H0-7736",543,3},
  {{{0x3e2a73347d0728d4}},4,"F-H0-7737",907,2},
  {{{0xc8291674b96c105e}},10,"F-H0-7738",432,6},
  {{{0xc8291674b96c105e}},10,"F-H0-7739",469,4},
  {{{0xc8291674b96c105e}},10,"F-H0-7740",506,4},
  {{{0xa8e608e30025bf6e}},4,"F-H0-7741",419,6},
  {{{0xa8e608e30025bf6e}},4,"F-H0-7742",949,5},
  {{{0xa8e608e30025bf6e}},4,"F-H0-7743",945,3},
  {{{0x10b449fb8c01bb18}},9,"F-H0-7744",788,9},
  {{{0x8f118cb2e1c02572}},3,"F-H0-7745",420,5},
  {{{0xa7f88658b6d131c3}},3,"F-H0-7746",419,2},
  {{{0xf284e53a359d58a2}},17,"F-H0-7747",802,5},
  {{{0xcae4077f046c895f}},17,"F-H0-7748",790,4},
  {{{0x4ae24cd07857968c}},17,"F-H0-7749",728,2},
  {{{0xcb204a70665c5468}},6,"F-H0-7750",541,2},
  {{{0xe7862516a5c43575}},10,"F-H0-7751",873,4},
  {{{0xb1e76d8bf18c479b}},11,"F-H0-7752",566,6},
  {{{0x4ccd27a44a4a162d}},6,"F-H0-7753",457,5},
  {{{0x4ccd27a44a4a162d}},6,"F-H0-7754",493,5},
  {{{0xc9b512157d02eaf4}},5,"F-H0-7755",529,9},
  {{{0xf640bb941eccd7bf}},5,"F-H0-7756",765,2},
  {{{0x714e930aad796f2}},5,"F-H0-7757",950,11},
  {{{0x66cccab4a85a3d98}},5,"F-H0-7758",469,3},
  {{{0x399c746133920b18}},7,"F-H0-7759",429,2},
  {{{0x5118191c783bff13}},15,"F-H0-7760",950,6},
  {{{0xeab4773590be84b6}},15,"F-H0-7761",865,5},
  {{{0x5118191c783bff13}},15,"F-H0-7762",947,2},
  {{{0xf2bfb0764d6d373e}},8,"F-H0-7763",645,3},
  {{{0xad4b256b37b28897}},8,"F-H0-7764",796,2},
  {{{0xf2754f7f5c928bdf}},8,"F-H0-7765",760,2},
  {{{0x7c99f8faaab2e9f}},8,"F-H0-7766",755,2},
  {{{0x9bb5302a01dd3cfd}},6,"F-H0-7767",949,5},
  {{{0x9bb5302a01dd3cfd}},6,"F-H0-7768",951,4},
  {{{0xd29fd0d865133380}},8,"F-H0-7769",469,14},
  {{{0x815bd7839a928c8b}},7,"F-H0-7770",912,8},
  {{{0x815bd7839a928c8b}},7,"F-H0-7771",911,3},
  {{{0x815bd7839a928c8b}},7,"F-H0-7772",874,2},
  {{{0x880a5c9b0807f267}},9,"F-H0-7773",936,9},
  {{{0xbf0fb7e987a90da9}},9,"F-H0-7774",424,2},
  {{{0x8ac0febf596cbb35}},12,"F-H0-7775",838,9},
  {{{0xfb1df188fb268e9f}},12,"F-H0-7776",938,2},
  {{{0x405cd079b906c79a}},6,"F-H0-7777",458,5},
  {{{0x5d0ebe75da068f47}},10,"F-H0-7778",616,11},
  {{{0xd976f1673eb8e3b}},10,"F-H0-7779",493,3},
  {{{0x637872454d00565c}},5,"F-H0-7780",421,11},
  {{{0xe5532e431cbc4ce2}},10,"F-H0-7781",640,10},
  {{{0x397f64c6a3b49e48}},10,"F-H0-7782",425,2},
  {{{0x6f27c1450740410d}},9,"F-H0-7783",911,6},
  {{{0x6f27c1450740410d}},9,"F-H0-7784",617,3},
  {{{0x6f27c1450740410d}},9,"F-H0-7785",579,2},
  {{{0xda7573f5685305e7}},6,"F-H0-7786",909,3},
  {{{0xda7573f5685305e7}},6,"F-H0-7787",908,3},
  {{{0xda7573f5685305e7}},6,"F-H0-7788",838,2},
  {{{0xda7573f5685305e7}},6,"F-H0-7789",875,2},
  {{{0xda7573f5685305e7}},6,"F-H0-7790",944,2},
  {{{0xba141729e3035859}},5,"F-H0-7791",505,3},
  {{{0xb6a769fac0ea24b4}},5,"F-H0-7792",764,3},
  {{{0x788ff42a9a6c749b}},5,"F-H0-7793",580,3},
  {{{0x8b233371cfd23be2}},9,"F-H0-7794",939,12},
  {{{0x5b39ac2f4e6e1e87}},4,"F-H0-7795",912,4},
  {{{0xf173943e48f55a92}},4,"F-H0-7796",455,2},
  {{{0xbe67e861162d3db6}},6,"F-H0-7797",945,4},
  {{{0x33a257ef89e14bba}},6,"F-H0-7798",529,3},
  {{{0xea25759cba4eb396}},6,"F-H0-7799",467,2},
  {{{0xc1eec71fbde37830}},6,"F-H0-7800",862,2},
  {{{0x9c4292f5e6e250cb}},3,"F-H0-7801",468,10},
  {{{0xffd530aedf6714c5}},3,"F-H0-7802",419,2},
  {{{0xceaa6fd69d78d5ef}},12,"F-H0-7803",543,5},
  {{{0x273e7a88d030a837}},10,"F-H0-7804",974,4},
  {{{0xf7577fe09334a36a}},10,"F-H0-7805",421,5},
  {{{0x82e1180bbf24c9e0}},10,"F-H0-7806",493,3},
  {{{0x82e1180bbf24c9e0}},10,"F-H0-7807",678,2},
  {{{0xc0efc2e2ca853e95}},4,"F-H0-7808",506,5},
  {{{0x27323c535c377c17}},4,"F-H0-7809",456,4},
  {{{0xc0efc2e2ca853e95}},4,"F-H0-7810",838,2},
  {{{0xc0efc2e2ca853e95}},4,"F-H0-7811",543,2},
  {{{0xe1aa99778de7b3ee}},9,"F-H0-7812",393,7},
  {{{0x3eeb4bf2173457d2}},9,"F-H0-7813",380,2},
  {{{0x9dcfdbbf2a25481f}},4,"F-H0-7814",862,5},
  {{{0x62d83d90d5123cbe}},4,"F-H0-7815",543,4},
  {{{0x9dcfdbbf2a25481f}},4,"F-H0-7816",684,2},
  {{{0x33abaeb77c6761b2}},4,"F-H0-7817",838,4},
  {{{0x24cd4b4f74e57ed}},4,"F-H0-7818",506,4},
  {{{0x33abaeb77c6761b2}},4,"F-H0-7819",908,2},
  {{{0x49739c6bb88e782b}},4,"F-H0-7820",469,2},
  {{{0x33abaeb77c6761b2}},4,"F-H0-7821",468,2},
  {{{0xebfc087a8ab0ff6}},6,"F-H0-7822",906,2},
  {{{0x945a05dd4ea45ccc}},6,"F-H0-7823",462,2},
  {{{0x810dd869a6442108}},9,"F-H0-7824",418,11},
  {{{0x810dd869a6442108}},9,"F-H0-7825",567,2},
  {{{0xcdb4594e895dd344}},6,"F-H0-7826",382,4},
  {{{0x57fa2770bc27bc8d}},8,"F-H0-7827",906,5},
  {{{0x57fa2770bc27bc8d}},8,"F-H0-7828",425,3},
  {{{0x453e53438bff0f1d}},8,"F-H0-7829",543,2},
  {{{0x453e53438bff0f1d}},8,"F-H0-7830",493,2},
  {{{0xfb9f6766f207e570}},6,"F-H0-7831",690,11},
  {{{0xc574b68c8a539902}},6,"F-H0-7832",454,2},
  {{{0x7985fb9e39f69d72}},6,"F-H0-7833",789,8},
  {{{0x2bea8a25ccb0917f}},6,"F-H0-7834",873,3},
  {{{0x2bea8a25ccb0917f}},6,"F-H0-7835",910,3},
  {{{0x4900349d3e73d9e3}},4,"F-H0-7836",714,4},
  {{{0x4900349d3e73d9e3}},4,"F-H0-7837",913,3},
  {{{0x4900349d3e73d9e3}},4,"F-H0-7838",912,3},
  {{{0x6104cd676fbc1c57}},4,"F-H0-7839",911,3},
  {{{0xaeebd25453b9ad6}},4,"F-H0-7840",947,2},
  {{{0x1ec65e3aef92628}},4,"F-H0-7841",875,2},
  {{{0x788969f188a0aaa0}},4,"F-H0-7842",875,2},
  {{{0xdfb6f3abdd36927b}},4,"F-H0-7843",906,2},
  {{{0x788969f188a0aaa0}},4,"F-H0-7844",909,2},
  {{{0x3710f7488106b40a}},16,"F-H0-7845",529,6},
  {{{0x4e3bdbfdf95f44fc}},16,"F-H0-7846",429,3},
  {{{0x7e117b5f78ce909b}},5,"F-H0-7847",908,5},
  {{{0xb481ee7a433d4f34}},5,"F-H0-7848",876,3},
  {{{0x44dfd1ebbfb26dfc}},5,"F-H0-7849",901,2},
  {{{0x229f820b5569abe6}},5,"F-H0-7850",974,4},
  {{{0x8812dcce735d528c}},11,"F-H0-7851",763,4},
  {{{0xdb2c869ec7497b4e}},12,"F-H0-7852",381,13},
  {{{0x221c761002ed4c95}},8,"F-H0-7853",872,6},
  {{{0x221c761002ed4c95}},8,"F-H0-7854",802,5},
  {{{0x8321a035169e059f}},6,"F-H0-7855",942,2},
  {{{0x8321a035169e059f}},6,"F-H0-7856",973,2},
  {{{0x22cbef409cbe31d1}},8,"F-H0-7857",902,6},
  {{{0xf375051b46d6a975}},8,"F-H0-7858",947,2},
  {{{0x246f1d4ba5649ced}},11,"F-H0-7859",542,9},
  {{{0x246f1d4ba5649ced}},11,"F-H0-7860",544,4},
  {{{0xc6dde40ac4d3b785}},10,"F-H0-7861",382,13},
  {{{0x5390d4be96b24b76}},19,"F-H0-7862",910,6},
  {{{0x5390d4be96b24b76}},19,"F-H0-7863",909,4},
  {{{0x48bfac605355865d}},5,"F-H0-7864",875,3},
  {{{0x48bfac605355865d}},5,"F-H0-7865",653,2},
  {{{0x48bfac605355865d}},5,"F-H0-7866",617,2},
  {{{0x16bbe4197abe8dcb}},5,"F-H0-7867",906,2},
  {{{0x16bbe4197abe8dcb}},5,"F-H0-7868",942,2},
  {{{0x39967b6df899dca0}},8,"F-H0-7869",913,14},
  {{{0x1dbfba85e5558f88}},4,"F-H0-7870",910,3},
  {{{0x1dbfba85e5558f88}},4,"F-H0-7871",468,2},
  {{{0xd38601cec5a9e3b5}},4,"F-H0-7872",457,2},
  {{{0x1dbfba85e5558f88}},4,"F-H0-7873",431,2},
  {{{0x96467df37cd7ad64}},3,"F-H0-7874",456,8},
  {{{0xf95d0ae35a54f977}},3,"F-H0-7875",948,2},
  {{{0xb767f9b19cc1df19}},6,"F-H0-7876",543,8},
  {{{0x247edeb875ac30f7}},6,"F-H0-7877",788,5},
  {{{0x846de8bec27969eb}},5,"F-H0-7878",910,9},
  {{{0xdd8b7a9184cb1617}},8,"F-H0-7879",937,6},
  {{{0x4f718d82f9728c0}},8,"F-H0-7880",987,4},
  {{{0x3bc9261ee51d1870}},9,"F-H0-7881",865,12},
  {{{0x585f2bf37bc0751e}},10,"F-H0-7882",913,9},
  {{{0xcf7c8423e6d65126}},10,"F-H0-7883",900,4},
  {{{0xf5c9deb691e4e14c}},6,"F-H0-7884",950,14},
  {{{0x9e40e8f5f505a42d}},6,"F-H0-7885",495,6},
  {{{0xef28a55305a0302e}},6,"F-H0-7886",429,4},
  {{{0x1c1d15dc73a1e2b5}},6,"F-H0-7887",950,3},
  {{{0xe6b1d66e3631f5cf}},10,"F-H0-7888",788,7},
  {{{0xf8d22d414430b653}},9,"F-H0-7889",392,7},
  {{{0x961dc07534f15d74}},5,"F-H0-7890",456,5},
  {{{0x5e6a0d869645a448}},5,"F-H0-7891",456,4},
  {{{0xbb1e2cd4bfff75ac}},5,"F-H0-7892",505,7},
  {{{0x1686d5a03821dae1}},5,"F-H0-7893",948,3},
  {{{0xe9a2525504e91002}},7,"F-H0-7894",504,9},
  {{{0xe9a2525504e91002}},7,"F-H0-7895",503,2},
  {{{0xdf56a89b5fde7553}},7,"F-H0-7896",507,12},
  {{{0x8ed10d6612d90eb7}},4,"F-H0-7897",492,3},
  {{{0x372c28642a0cf74}},4,"F-H0-7898",825,2},
  {{{0xf92c355998556387}},14,"F-H0-7899",529,13},
  {{{0x80fcb0e7f373d95b}},5,"F-H0-7900",902,5},
  {{{0x4f2e1e3f240ca4d6}},5,"F-H0-7901",430,3},
  {{{0x80fcb0e7f373d95b}},5,"F-H0-7902",938,2},
  {{{0x4f2e1e3f240ca4d6}},5,"F-H0-7903",950,2},
  {{{0x4f2e1e3f240ca4d6}},5,"F-H0-7904",467,2},
  {{{0x6cba5bdaffb4e806}},5,"F-H0-7905",837,9},
  {{{0x6cba5bdaffb4e806}},5,"F-H0-7906",950,3},
  {{{0x74a0c5dc22d3e7ca}},13,"F-H0-7907",420,12},
  {{{0xfe0e60c9833a5cbd}},3,"F-H0-7908",456,4},
  {{{0x49999db8dd9d5206}},3,"F-H0-7909",863,2},
  {{{0x49999db8dd9d5206}},3,"F-H0-7910",469,2},
  {{{0x60e71c18b2905077}},10,"F-H0-7911",501,4},
  {{{0xa183fcec926d855}},10,"F-H0-7912",873,2},
  {{{0x2fa2b7c9f6d32af1}},18,"F-H0-7913",801,7},
  {{{0x2fa2b7c9f6d32af1}},18,"F-H0-7914",908,2},
  {{{0x801dd017bdff0f28}},8,"F-H0-7915",908,6},
  {{{0x801dd017bdff0f28}},8,"F-H0-7916",909,4},
  {{{0x4da90e4c38ae8b31}},4,"F-H0-7917",877,9},
  {{{0xd73be1d050c9dc90}},4,"F-H0-7918",899,3},
  {{{0x4da90e4c38ae8b31}},4,"F-H0-7919",984,2},
  {{{0xcee303358f5b7169}},4,"F-H0-7920",431,3},
  {{{0x65de8ec67b218177}},4,"F-H0-7921",937,11},
  {{{0xbc2942c62cbd8ab6}},11,"F-H0-7922",910,10},
  {{{0xd4c0ce08cd2503b0}},11,"F-H0-7923",974,2},
  {{{0x39a5683605d80b93}},7,"F-H0-7924",826,10},
  {{{0xa22e195fadf73ae8}},6,"F-H0-7925",839,6},
  {{{0x1ca2df4fbb97dcf6}},6,"F-H0-7926",421,4},
  {{{0x1ca2df4fbb97dcf6}},6,"F-H0-7927",947,3},
  {{{0x1f21d4579e4b24d0}},8,"F-H0-7928",458,5},
  {{{0x85412eaf94b6b0d8}},8,"F-H0-7929",839,4},
  {{{0x4618385880f5d76e}},8,"F-H0-7930",529,4},
  {{{0x1192bb7e37a240ef}},10,"F-H0-7931",974,2},
  {{{0x1192bb7e37a240ef}},10,"F-H0-7932",905,2},
  {{{0xf0d5fb9c2d6157b5}},10,"F-H0-7933",690,2},
  {{{0x832ae3cdd6b092a4}},10,"F-H0-7934",677,2},
  {{{0x9e4e8ead63264592}},9,"F-H0-7935",678,9},
  {{{0x19c17e7aa23ca732}},3,"F-H0-7936",493,2},
  {{{0x9dfba04342ffe0b1}},3,"F-H0-7937",948,2},
  {{{0x3aeca74e0cf2db92}},3,"F-H0-7938",431,2},
  {{{0xbcbe1cd0203b4fed}},9,"F-H0-7939",753,8},
  {{{0x1d288cc8a7c8e21}},9,"F-H0-7940",653,4},
  {{{0x1d288cc8a7c8e21}},9,"F-H0-7941",429,3},
  {{{0x1d288cc8a7c8e21}},9,"F-H0-7942",617,3},
  {{{0x23347e296bc0fe53}},9,"F-H0-7943",542,2},
  {{{0x17f7f5fe910ce743}},6,"F-H0-7944",429,4},
  {{{0x17f7f5fe910ce743}},6,"F-H0-7945",838,3},
  {{{0x17f7f5fe910ce743}},6,"F-H0-7946",466,2},
  {{{0x3c7d8e81904c02d6}},6,"F-H0-7947",616,2},
  {{{0x7f5a73146c198b1e}},4,"F-H0-7948",911,5},
  {{{0xc77a1b21dc1a656e}},4,"F-H0-7949",543,3},
  {{{0x858fd7e929c2fd77}},7,"F-H0-7950",837,5},
  {{{0x858fd7e929c2fd77}},7,"F-H0-7951",801,4},
  {{{0x858fd7e929c2fd77}},7,"F-H0-7952",876,2},
  {{{0x84e7c4855d63a908}},7,"F-H0-7953",910,2},
  {{{0x5dcc227302f89566}},7,"F-H0-7954",466,10},
  {{{0x5dcc227302f89566}},7,"F-H0-7955",542,3},
  {{{0xf15b143e21c496d}},8,"F-H0-7956",678,7},
  {{{0xf15b143e21c496d}},8,"F-H0-7957",425,2},
  {{{0xf15b143e21c496d}},8,"F-H0-7958",529,2},
  {{{0xcbd3b1b8a0ab1d44}},7,"F-H0-7959",939,6},
  {{{0x9919e6142e02379d}},7,"F-H0-7960",462,2},
  {{{0x9919e6142e02379d}},7,"F-H0-7961",678,2},
  {{{0x56dffbd812582a6d}},6,"F-H0-7962",432,13},
  {{{0x44aab2b549760ba0}},4,"F-H0-7963",529,3},
  {{{0x6f613be8a758c9f3}},15,"F-H0-7964",529,4},
  {{{0xfe80d8da57c10c17}},6,"F-H0-7965",949,8},
  {{{0xfe80d8da57c10c17}},6,"F-H0-7966",945,3},
  {{{0x2178ee8905829c86}},2,"F-H0-7967",913,5},
  {{{0x7655eb6ea1c7586a}},2,"F-H0-7968",904,2},
  {{{0x260559b42b07871a}},7,"F-H0-7969",603,4},
  {{{0x260559b42b07871a}},7,"F-H0-7970",641,3},
  {{{0x260559b42b07871a}},7,"F-H0-7971",458,2},
  {{{0x45d63ef16e44f6af}},7,"F-H0-7972",911,4},
  {{{0x45d63ef16e44f6af}},7,"F-H0-7973",943,3},
  {{{0x45d63ef16e44f6af}},7,"F-H0-7974",944,2},
  {{{0x45d63ef16e44f6af}},7,"F-H0-7975",947,2},
  {{{0x29191428ed7eb6b4}},7,"F-H0-7976",902,11},
  {{{0x9808e1dc0db5247c}},12,"F-H0-7977",529,2},
  {{{0xc097343feb04fa7c}},3,"F-H0-7978",937,4},
  {{{0xee27ef2ce164a92c}},5,"F-H0-7979",825,3},
  {{{0xee27ef2ce164a92c}},5,"F-H0-7980",947,3},
  {{{0xee27ef2ce164a92c}},5,"F-H0-7981",944,2},
  {{{0xee27ef2ce164a92c}},5,"F-H0-7982",948,2},
  {{{0xee27ef2ce164a92c}},5,"F-H0-7983",911,2},
  {{{0xb5bcfb49fb5de006}},8,"F-H0-7984",454,10},
  {{{0x57865796b5482637}},8,"F-H0-7985",678,4},
  {{{0x57865796b5482637}},8,"F-H0-7986",429,3},
  {{{0xff50cf1973ecd590}},9,"F-H0-7987",985,9},
  {{{0x15da05871c0e0a31}},9,"F-H0-7988",396,2},
  {{{0x83e8b178fe8026e5}},6,"F-H0-7989",506,6},
  {{{0x164db674de68e062}},6,"F-H0-7990",942,4},
  {{{0x6150c32d809221bd}},6,"F-H0-7991",529,3},
  {{{0xf421d6932353d8b7}},6,"F-H0-7992",949,5},
  {{{0xaf3f3af91428667c}},6,"F-H0-7993",973,4},
  {{{0xb85bf1dec7af5fc4}},6,"F-H0-7994",678,6},
  {{{0x46085f86419785cc}},6,"F-H0-7995",382,4},
  {{{0xd3468b88deddc8aa}},5,"F-H0-7996",429,5},
  {{{0x166eeb1de136b459}},5,"F-H0-7997",801,3},
  {{{0x166eeb1de136b459}},5,"F-H0-7998",529,2},
  {{{0x8324886503dbbfb2}},6,"F-H0-7999",826,3},
  {{{0xaceb172d51f4d2be}},6,"F-H0-8000",427,2},
  {{{0xf1a5605d3eb102b2}},6,"F-H0-8001",906,2},
  {{{0x490fd76c9233c4c5}},6,"F-H0-8002",419,10},
  {{{0xc5e455953a310d39}},6,"F-H0-8003",861,2},
  {{{0x8d4db8512dbed405}},6,"F-H0-8004",529,8},
  {{{0xad9dafbac44dfe88}},6,"F-H0-8005",456,5},
  {{{0xfdd10ee5dd5590d0}},9,"F-H0-8006",950,8},
  {{{0xc86ef0d6930201a6}},6,"F-H0-8007",503,7},
  {{{0x1ce69b59dee308c1}},6,"F-H0-8008",864,3},
  {{{0x9ae0b55bd7b2a7f1}},6,"F-H0-8009",496,2},
  {{{0xbedcf7db1de9dcf0}},3,"F-H0-8010",948,7},
  {{{0xbedcf7db1de9dcf0}},3,"F-H0-8011",949,2},
  {{{0x946d0d565133fccb}},7,"F-H0-8012",419,13},
  {{{0x5cb7ecf7b54a811a}},11,"F-H0-8013",383,12},
  {{{0xad4480e54ffdd067}},4,"F-H0-8014",422,4},
  {{{0x5af1ee5371cabe3d}},4,"F-H0-8015",419,3},
  {{{0x8851cda602aca28c}},4,"F-H0-8016",938,2},
  {{{0x5af1ee5371cabe3d}},4,"F-H0-8017",456,2},
  {{{0xd6731080e8fdfed4}},6,"F-H0-8018",728,12},
  {{{0xd6731080e8fdfed4}},6,"F-H0-8019",839,2},
  {{{0xb5ae51013c106a30}},7,"F-H0-8020",427,7},
  {{{0xd42b91eb1c57c9aa}},7,"F-H0-8021",906,2},
  {{{0xb5ae51013c106a30}},7,"F-H0-8022",543,2},
  {{{0x26c169222fa92202}},7,"F-H0-8023",910,2},
  {{{0x861fa2158ad04c2e}},11,"F-H0-8024",873,12},
  {{{0x5c390189f66eb826}},6,"F-H0-8025",457,4},
  {{{0x5c390189f66eb826}},6,"F-H0-8026",801,3},
  {{{0x5c390189f66eb826}},6,"F-H0-8027",543,2},
  {{{0x5c390189f66eb826}},6,"F-H0-8028",421,2},
  {{{0xfcc899e694389be2}},7,"F-H0-8029",542,11},
  {{{0xa18d07d7decfff14}},7,"F-H0-8030",493,8},
  {{{0xa18d07d7decfff14}},7,"F-H0-8031",531,4},
  {{{0x6b4888c408e1d000}},4,"F-H0-8032",457,2},
  {{{0xda9877f8a0e0d3b7}},6,"F-H0-8033",723,8},
  {{{0xd035b479b179b1ea}},6,"F-H0-8034",645,2},
  {{{0xb9db06a84d12705}},8,"F-H0-8035",826,14},
  {{{0x716feaa69d89c9fe}},6,"F-H0-8036",580,3},
  {{{0xb6cf1d96d3e2f0a}},6,"F-H0-8037",492,2},
  {{{0x68221947c654fce8}},6,"F-H0-8038",788,2},
  {{{0x716feaa69d89c9fe}},6,"F-H0-8039",908,2},
  {{{0x9b6299ccdc5dc562}},3,"F-H0-8040",911,5},
  {{{0x35c5a25c3c4edc38}},3,"F-H0-8041",467,2},
  {{{0x35c5a25c3c4edc38}},3,"F-H0-8042",862,2},
  {{{0x895c500fc1a69137}},11,"F-H0-8043",910,14},
  {{{0xa480b9fceb767653}},12,"F-H0-8044",910,3},
  {{{0xf6243fb059470d86}},12,"F-H0-8045",902,3},
  {{{0xa480b9fceb767653}},12,"F-H0-8046",945,2},
  {{{0x96a14f01c1678ec1}},8,"F-H0-8047",579,9},
  {{{0x96a14f01c1678ec1}},8,"F-H0-8048",543,2},
  {{{0x1d785b1711b4f0f9}},6,"F-H0-8049",751,4},
  {{{0xfce901f475c27839}},6,"F-H0-8050",530,3},
  {{{0x46d21ed0ff2e5482}},6,"F-H0-8051",429,3},
  {{{0x9cf37825cd22f805}},11,"F-H0-8052",431,11},
  {{{0xa25226740a335441}},4,"F-H0-8053",456,7},
  {{{0x85888310114a3af9}},10,"F-H0-8054",938,8},
  {{{0x77eeae87777917b0}},10,"F-H0-8055",418,5},
  {{{0xb0dfe356fcf4f35a}},16,"F-H0-8056",947,5},
  {{{0x6226c2178ba9a92c}},16,"F-H0-8057",826,3},
  {{{0xabff8edc42335088}},16,"F-H0-8058",802,2},
  {{{0xad0917427db6962e}},17,"F-H0-8059",951,10},
  {{{0xc103871f44e250df}},17,"F-H0-8060",974,2},
  {{{0xdef0c512c4af78ed}},6,"F-H0-8061",457,7},
  {{{0xdef0c512c4af78ed}},6,"F-H0-8062",420,4},
  {{{0xdef0c512c4af78ed}},6,"F-H0-8063",422,2},
  {{{0xf3e715336fdafece}},9,"F-H0-8064",617,4},
  {{{0xf3e715336fdafece}},9,"F-H0-8065",690,2},
  {{{0xf3e715336fdafece}},9,"F-H0-8066",466,2},
  {{{0xa32ef930a8a65ccc}},3,"F-H0-8067",468,4},
  {{{0xa0c76154bcb4fd3c}},3,"F-H0-8068",455,4},
  {{{0xf1d15a3f2e0a1f86}},3,"F-H0-8069",430,2},
  {{{0xa0c76154bcb4fd3c}},3,"F-H0-8070",875,2},
  {{{0xe0a2c6ef2fbab439}},18,"F-H0-8071",869,3},
  {{{0x7cec76472294b6e7}},18,"F-H0-8072",507,2},
  {{{0x49f2b32e8769d048}},9,"F-H0-8073",905,8},
  {{{0x49f2b32e8769d048}},9,"F-H0-8074",974,5},
  {{{0x6a3199a5e4baeb30}},3,"F-H0-8075",430,4},
  {{{0x6a3199a5e4baeb30}},3,"F-H0-8076",468,2},
  {{{0xb170158f6721481}},3,"F-H0-8077",948,2},
  {{{0x6a3199a5e4baeb30}},3,"F-H0-8078",467,2},
  {{{0x8e07b236ba2b95d4}},9,"F-H0-8079",641,4},
  {{{0x8e07b236ba2b95d4}},9,"F-H0-8080",603,4},
  {{{0x8e07b236ba2b95d4}},9,"F-H0-8081",421,2},
  {{{0x8e07b236ba2b95d4}},9,"F-H0-8082",458,2},
  {{{0x748b1db79f4479aa}},5,"F-H0-8083",801,5},
  {{{0xeb442c9390ee3534}},5,"F-H0-8084",677,2},
  {{{0xeb442c9390ee3534}},5,"F-H0-8085",543,2},
  {{{0x272602e268f182ee}},12,"F-H0-8086",873,7},
  {{{0x272602e268f182ee}},12,"F-H0-8087",948,5},
  {{{0xf591698446201244}},11,"F-H0-8088",904,11},
  {{{0xc761224fac0e52a7}},9,"F-H0-8089",941,6},
  {{{0xd7c094acd9557714}},9,"F-H0-8090",826,3},
  {{{0xc761224fac0e52a7}},9,"F-H0-8091",825,2},
  {{{0xbaa919c36f2e815f}},15,"F-H0-8092",429,6},
  {{{0xa587fc7511b71b1e}},15,"F-H0-8093",800,2},
  {{{0xc243737d16f8a921}},15,"F-H0-8094",458,2},
  {{{0x9be55d13931ea8da}},6,"F-H0-8095",873,6},
  {{{0x9be55d13931ea8da}},6,"F-H0-8096",950,4},
  {{{0x61e191a06b9a5663}},10,"F-H0-8097",690,4},
  {{{0x5961dd2fcc7d596c}},10,"F-H0-8098",944,2},
  {{{0x5961dd2fcc7d596c}},10,"F-H0-8099",421,2},
  {{{0x5961dd2fcc7d596c}},10,"F-H0-8100",943,2},
  {{{0x931820f47e527b21}},5,"F-H0-8101",910,7},
  {{{0xb92dc8baa3b8ca98}},5,"F-H0-8102",430,2},
  {{{0xadf92db844f5cc64}},5,"F-H0-8103",459,2},
  {{{0x8d16c14a408c6823}},8,"F-H0-8104",791,13},
  {{{0xe13e186b5f75032d}},8,"F-H0-8105",826,8},
  {{{0xe13e186b5f75032d}},8,"F-H0-8106",864,3},
  {{{0x3c45b2a2deb56af1}},6,"F-H0-8107",424,5},
  {{{0x3c45b2a2deb56af1}},6,"F-H0-8108",459,2},
  {{{0xf8977a5e130a4092}},6,"F-H0-8109",945,2},
  {{{0xc8f84d112a1c27f1}},10,"F-H0-8110",902,7},
  {{{0xdc986fc71c1068e1}},10,"F-H0-8111",825,3},
  {{{0xa6140908713f83db}},10,"F-H0-8112",948,2},
  {{{0xbb56b3156562c46a}},7,"F-H0-8113",950,9},
  {{{0xbb56b3156562c46a}},7,"F-H0-8114",802,2},
  {{{0xc5a0d8e9090f1331}},6,"F-H0-8115",492,5},
  {{{0xe2fbf07c38fc23de}},6,"F-H0-8116",908,3},
  {{{0xc5a0d8e9090f1331}},6,"F-H0-8117",908,3},
  {{{0xf89d4281c145c4df}},7,"F-H0-8118",617,4},
  {{{0xf89d4281c145c4df}},7,"F-H0-8119",653,2},
  {{{0xdd42d2f585dc27cd}},7,"F-H0-8120",530,2},
  {{{0xf89d4281c145c4df}},7,"F-H0-8121",911,2},
  {{{0xeb32a72145cc384b}},7,"F-H0-8122",987,12},
  {{{0xd07c464e7e652546}},5,"F-H0-8123",580,4},
  {{{0xc7f4f28af1334e1f}},5,"F-H0-8124",464,3},
  {{{0xd07c464e7e652546}},5,"F-H0-8125",506,2},
  {{{0x6719a379fe5df89a}},2,"F-H0-8126",901,4},
  {{{0xcaf29a7afdad000a}},4,"F-H0-8127",467,6},
  {{{0xc6483db9b1a3e59}},4,"F-H0-8128",944,4},
  {{{0xfab68d0d1d486885}},7,"F-H0-8129",826,10},
  {{{0x2caf4880cf86d8fa}},7,"F-H0-8130",429,4},
  {{{0xb23cd177011b4eac}},4,"F-H0-8131",466,3},
  {{{0xec57b0a5b27ca04}},4,"F-H0-8132",939,3},
  {{{0x3be87c40eb561335}},4,"F-H0-8133",427,3},
  {{{0x75ac0cad67fdf74b}},4,"F-H0-8134",641,2},
  {{{0x79b8dc6a57397b6}},5,"F-H0-8135",758,6},
  {{{0xda515e0ab849b585}},4,"F-H0-8136",947,3},
  {{{0x53148df282d3f80a}},4,"F-H0-8137",458,2},
  {{{0x9dd1b6e08c03a6dc}},4,"F-H0-8138",456,2},
  {{{0x64f52017e3150d72}},5,"F-H0-8139",904,4},
  {{{0x80bac5d69a6c35cb}},5,"F-H0-8140",420,4},
  {{{0x4634a2f7b395000f}},5,"F-H0-8141",911,5},
  {{{0x3b56fdb2ea799afa}},5,"F-H0-8142",936,2},
  {{{0x498bb91edd9d6b25}},6,"F-H0-8143",543,5},
  {{{0x4e47a0519a552ed2}},6,"F-H0-8144",950,3},
  {{{0x1d5a46d143e96f88}},6,"F-H0-8145",382,2},
  {{{0xcadf21b0419e9086}},3,"F-H0-8146",838,8},
  {{{0x2a3d24fe82633038}},3,"F-H0-8147",543,2},
  {{{0xbac4e10af71e361c}},14,"F-H0-8148",950,11},
  {{{0x91727e521213b5a6}},14,"F-H0-8149",875,11},
  {{{0xd1d15864a113ad21}},14,"F-H0-8150",874,2},
  {{{0xbc693632d4b43f2}},7,"F-H0-8151",506,5},
  {{{0x9768686544043a66}},7,"F-H0-8152",460,4},
  {{{0xd43d34ff27833c95}},4,"F-H0-8153",900,3},
  {{{0xeb95f85e3eb8694c}},4,"F-H0-8154",530,3},
  {{{0xeb95f85e3eb8694c}},4,"F-H0-8155",492,2},
  {{{0xf9bf9dc8a714dabf}},9,"F-H0-8156",431,9},
  {{{0xf9bf9dc8a714dabf}},9,"F-H0-8157",506,3},
  {{{0xc4ad3139015e50a4}},10,"F-H0-8158",529,2},
  {{{0xf7d752368c3f723c}},7,"F-H0-8159",542,9},
  {{{0xd6b7785fcb35f348}},7,"F-H0-8160",566,3},
  {{{0xa68409e8861c2205}},9,"F-H0-8161",899,12},
  {{{0xf9b803892888dda1}},9,"F-H0-8162",457,11},
  {{{0x7be44ae823d3be1d}},4,"F-H0-8163",505,8},
  {{{0x206605df4fac37ec}},4,"F-H0-8164",948,2},
  {{{0x2975e8d2167d7854}},10,"F-H0-8165",424,7},
  {{{0xe04f48ea5cc648bf}},10,"F-H0-8166",751,5},
  {{{0x17ad407bc6e24b1d}},14,"F-H0-8167",875,7},
  {{{0xaa3b99ddb5bb47dc}},14,"F-H0-8168",617,2},
  {{{0xbdfe26b952e52171}},8,"F-H0-8169",459,6},
  {{{0x704227b2f08f9f98}},8,"F-H0-8170",910,3},
  {{{0xd4ab1f62a20cf4f0}},9,"F-H0-8171",912,12},
  {{{0x182566cd4a652042}},12,"F-H0-8172",950,10},
  {{{0xb518727181278868}},12,"F-H0-8173",540,2},
  {{{0xc695ed21b1da9931}},4,"F-H0-8174",467,8},
  {{{0xf54a2e852eec0e02}},4,"F-H0-8175",506,3},
  {{{0xe500f4e7cf8cc645}},18,"F-H0-8176",580,4},
  {{{0x983cdad230507970}},18,"F-H0-8177",866,2},
  {{{0x9b589ca593aa449a}},18,"F-H0-8178",529,2},
  {{{0xe500f4e7cf8cc645}},18,"F-H0-8179",801,2},
  {{{0x983cdad230507970}},18,"F-H0-8180",691,2},
  {{{0x932f437db5baedc}},6,"F-H0-8181",802,3},
  {{{0x2d5223ab0cab0eb2}},12,"F-H0-8182",801,3},
  {{{0x2d5223ab0cab0eb2}},12,"F-H0-8183",984,2},
  {{{0x2d5223ab0cab0eb2}},12,"F-H0-8184",765,2},
  {{{0xd77ee1c16c0024c4}},12,"F-H0-8185",691,8},
  {{{0x65bc950b7bd7cbb4}},12,"F-H0-8186",462,3},
  {{{0x65bc950b7bd7cbb4}},12,"F-H0-8187",424,2},
  {{{0x659f4df507c88828}},3,"F-H0-8188",468,8},
  {{{0xde32af7ae399dacf}},6,"F-H0-8189",945,3},
  {{{0x1b3693a2e9607318}},11,"F-H0-8190",975,8},
  {{{0x5986fbfeb76c379b}},6,"F-H0-8191",873,8},
  {{{0xf702c2f609d63f4a}},18,"F-H0-8192",942,7},
  {{{0xa175d297f18ae8c0}},18,"F-H0-8193",764,3},
  {{{0x641cb10059475a5a}},14,"F-H0-8194",801,4},
  {{{0x641cb10059475a5a}},14,"F-H0-8195",529,2},
  {{{0x641cb10059475a5a}},14,"F-H0-8196",825,2},
  {{{0x5cb84e022f7da18}},10,"F-H0-8197",863,6},
  {{{0x5cb84e022f7da18}},10,"F-H0-8198",788,3},
  {{{0x70c54222b244b1f8}},9,"F-H0-8199",467,11},
  {{{0x8e40c3c7e45b8edd}},13,"F-H0-8200",907,13},
  {{{0x61880b3f69d1960d}},8,"F-H0-8201",937,10},
  {{{0xba69408a222731f6}},11,"F-H0-8202",654,8},
  {{{0xba69408a222731f6}},11,"F-H0-8203",652,2},
  {{{0x7dbeb8c781d1d99f}},8,"F-H0-8204",690,5},
  {{{0x7dbeb8c781d1d99f}},8,"F-H0-8205",470,3},
  {{{0x97e3015faefc6024}},6,"F-H0-8206",432,7},
  {{{0x44f868076e4f4754}},6,"F-H0-8207",495,3},
  {{{0xb75d2ee140324918}},6,"F-H0-8208",429,4},
  {{{0xb75d2ee140324918}},6,"F-H0-8209",728,3},
  {{{0xb75d2ee140324918}},6,"F-H0-8210",802,2},
  {{{0xb75d2ee140324918}},6,"F-H0-8211",765,2},
  {{{0xe3f9532cefefc12c}},6,"F-H0-8212",752,2},
  {{{0x56884af1b2c009}},10,"F-H0-8213",985,11},
  {{{0x93ed5124496e745b}},6,"F-H0-8214",945,8},
  {{{0x13ab0c21cc3e644d}},7,"F-H0-8215",617,5},
  {{{0x13ab0c21cc3e644d}},7,"F-H0-8216",466,3},
  {{{0x13ab0c21cc3e644d}},7,"F-H0-8217",690,2},
  {{{0x686bb02865ffc6a6}},6,"F-H0-8218",503,7},
  {{{0x686bb02865ffc6a6}},6,"F-H0-8219",432,4},
  {{{0xbeb972722c5eccd9}},5,"F-H0-8220",604,6},
  {{{0x24c28491eef4bb0c}},5,"F-H0-8221",424,2},
  {{{0x24c28491eef4bb0c}},5,"F-H0-8222",493,2},
  {{{0xbf3dbd5b1a8def6a}},13,"F-H0-8223",951,8},
  {{{0xeb79e745f2bc00f}},8,"F-H0-8224",911,6},
  {{{0xeb5b7ac989c2ef3f}},8,"F-H0-8225",455,5},
  {{{0xc23195059bee31f9}},12,"F-H0-8226",840,10},
  {{{0x9ab66eff068620e9}},4,"F-H0-8227",431,5},
  {{{0x9ab66eff068620e9}},4,"F-H0-8228",908,2},
  {{{0x9ab66eff068620e9}},4,"F-H0-8229",948,2},
  {{{0x76ce1a9a12b6cad7}},9,"F-H0-8230",947,12},
  {{{0x9b7d2a5e4f4ae5ab}},7,"F-H0-8231",827,7},
  {{{0xe69f4de1509d5016}},7,"F-H0-8232",938,3},
  {{{0x81001c89ab10c53e}},17,"F-H0-8233",940,4},
  {{{0x3527b215c63adc06}},17,"F-H0-8234",839,3},
  {{{0x3527b215c63adc06}},17,"F-H0-8235",578,2},
  {{{0x572fcecd4b2a5015}},11,"F-H0-8236",950,12},
  {{{0x9f6e4c70f3ab6b20}},6,"F-H0-8237",765,7},
  {{{0x9f6e4c70f3ab6b20}},6,"F-H0-8238",727,2},
  {{{0x515697f1524520c2}},6,"F-H0-8239",943,2},
  {{{0xcae467d06d9c7437}},18,"F-H0-8240",653,2},
  {{{0x2d5c9a1d22350b7b}},6,"F-H0-8241",678,5},
  {{{0x6db01195ae8db9ed}},6,"F-H0-8242",728,2},
  {{{0x2d5c9a1d22350b7b}},6,"F-H0-8243",677,2},
  {{{0x848595c6b0035fc8}},10,"F-H0-8244",873,5},
  {{{0xa6dbd3be1f808a63}},13,"F-H0-8245",824,11},
  {{{0x90eb85d9ff330bcc}},7,"F-H0-8246",827,8},
  {{{0x90eb85d9ff330bcc}},7,"F-H0-8247",936,2},
  {{{0x9ada5aea7a39ffba}},7,"F-H0-8248",825,2},
  {{{0xf9fc27a28cc2fa3f}},20,"F-H0-8249",691,2},
  {{{0x2fb6c0a283f7a17b}},5,"F-H0-8250",947,5},
  {{{0x2fb6c0a283f7a17b}},5,"F-H0-8251",421,4},
  {{{0x98f4068bcca2b116}},8,"F-H0-8252",506,11},
  {{{0x35effca6f6e08bbe}},11,"F-H0-8253",825,4},
  {{{0xd3f332a2ac124122}},11,"F-H0-8254",939,2},
  {{{0xf67f68fb60b3103e}},5,"F-H0-8255",939,12},
  {{{0xd29a74134e2107fd}},5,"F-H0-8256",911,9},
  {{{0xd29a74134e2107fd}},5,"F-H0-8257",948,2},
  {{{0xc6afeaba9fd3743c}},19,"F-H0-8258",689,2},
  {{{0xc54deb63cf4ec86b}},9,"F-H0-8259",395,4},
  {{{0xa8663f1c4156e7f3}},14,"F-H0-8260",691,12},
  {{{0x1c21bdfd8c85e54a}},12,"F-H0-8261",867,12},
  {{{0x78964739d5bc71d2}},6,"F-H0-8262",429,6},
  {{{0xb648075388a2ebf7}},6,"F-H0-8263",945,3},
  {{{0x82806a21eea7c013}},9,"F-H0-8264",467,3},
  {{{0xda8ef70edcaad99d}},9,"F-H0-8265",422,2},
  {{{0x9e065f4e513527d9}},5,"F-H0-8266",839,5},
  {{{0x9e065f4e513527d9}},5,"F-H0-8267",678,4},
  {{{0x8b2df93cf850d8d0}},10,"F-H0-8268",494,12},
  {{{0xe3ad4fade7044033}},6,"F-H0-8269",912,2},
  {{{0xcecafa7705b51d70}},6,"F-H0-8270",418,2},
  {{{0xcecafa7705b51d70}},6,"F-H0-8271",493,2},
  {{{0xcecafa7705b51d70}},6,"F-H0-8272",496,2},
  {{{0xc006ca14a2c22553}},17,"F-H0-8273",984,9},
  {{{0xc1eedf5c2ef031c0}},8,"F-H0-8274",427,3},
  {{{0x7d355357ed749f84}},8,"F-H0-8275",935,3},
  {{{0xc1eedf5c2ef031c0}},8,"F-H0-8276",464,2},
  {{{0x2953bcca155a2391}},8,"F-H0-8277",531,2},
  {{{0x5311c6975e783b9c}},6,"F-H0-8278",911,6},
  {{{0x5311c6975e783b9c}},6,"F-H0-8279",874,3},
  {{{0x5311c6975e783b9c}},6,"F-H0-8280",727,2},
  {{{0x7750dadc0068a1a0}},6,"F-H0-8281",826,3},
  {{{0x5a2941ceb3d69db6}},6,"F-H0-8282",751,2},
  {{{0xd30510c7596038ab}},4,"F-H0-8283",468,9},
  {{{0x75120fb929338ed9}},6,"F-H0-8284",505,10},
  {{{0x4b223754bbf9fae}},8,"F-H0-8285",937,13},
  {{{0xb6e7aefc0813c383}},8,"F-H0-8286",942,5},
  {{{0xd2b68b78311d505f}},8,"F-H0-8287",912,11},
  {{{0xa9a9d48487360c86}},11,"F-H0-8288",874,10},
  {{{0x2c33a972decf280f}},6,"F-H0-8289",457,2},
  {{{0xb4762070c69168a6}},6,"F-H0-8290",875,2},
  {{{0xadacd90bc609335f}},11,"F-H0-8291",985,9},
  {{{0xadacd90bc609335f}},11,"F-H0-8292",909,3},
  {{{0x1e673072a9e7f947}},5,"F-H0-8293",429,4},
  {{{0xf2b8292d55b7f8c}},5,"F-H0-8294",421,3},
  {{{0xca40866e73e2a314}},5,"F-H0-8295",691,2},
  {{{0xb39b22d1fe0d7815}},6,"F-H0-8296",457,4},
  {{{0xb39b22d1fe0d7815}},6,"F-H0-8297",901,4},
  {{{0xb39b22d1fe0d7815}},6,"F-H0-8298",946,2},
  {{{0xb1a224df3a849536}},5,"F-H0-8299",678,3},
  {{{0x192e9f26bec904ed}},5,"F-H0-8300",911,3},
  {{{0xa9cdab3566681833}},12,"F-H0-8301",984,10},
  {{{0x95156022e289519f}},8,"F-H0-8302",470,5},
  {{{0x3328df6ae6adb9bc}},8,"F-H0-8303",533,2},
  {{{0x3328df6ae6adb9bc}},8,"F-H0-8304",678,2},
  {{{0xa300f36f9652082}},14,"F-H0-8305",987,9},
  {{{0x857a3a8322e4174e}},12,"F-H0-8306",941,7},
  {{{0xd99fd80f7e1dbc13}},12,"F-H0-8307",429,2},
  {{{0x49770350bb188394}},6,"F-H0-8308",424,8},
  {{{0x6f17f97b1a5e41cf}},6,"F-H0-8309",906,4},
  {{{0x6b64bba6bf97cf54}},5,"F-H0-8310",603,3},
  {{{0x4ac0fc5b9bdb7461}},5,"F-H0-8311",653,2},
  {{{0x610724b06db75e7d}},5,"F-H0-8312",947,2},
  {{{0x4ac0fc5b9bdb7461}},5,"F-H0-8313",466,2},
  {{{0xb818d6eebb7e33b3}},5,"F-H0-8314",429,3},
  {{{0x28e1d3cdba7b0d60}},5,"F-H0-8315",863,3},
  {{{0xb818d6eebb7e33b3}},5,"F-H0-8316",910,2},
  {{{0xcaed0ca582b534d3}},3,"F-H0-8317",863,4},
  {{{0xefcc8bd9cfb81a69}},3,"F-H0-8318",899,3},
  {{{0xb6aa55029399a2be}},5,"F-H0-8319",421,4},
  {{{0x31995b6cae029e6f}},5,"F-H0-8320",617,3},
  {{{0x2a363341e30632c}},5,"F-H0-8321",727,3},
  {{{0x23fb5d66500b2d0d}},8,"F-H0-8322",911,12},
  {{{0xce215faf2ff3a443}},8,"F-H0-8323",874,6},
  {{{0x84bf96a8cca031b9}},8,"F-H0-8324",902,3},
  {{{0x8f0b8b33362ec19d}},6,"F-H0-8325",939,5},
  {{{0x6d4a836aa0acda2f}},6,"F-H0-8326",432,2},
  {{{0xb8746e587eded2ad}},8,"F-H0-8327",431,13},
  {{{0x35e1c88a73721457}},8,"F-H0-8328",579,9},
  {{{0x35e1c88a73721457}},8,"F-H0-8329",432,3},
  {{{0x832e241ec07c6d3f}},6,"F-H0-8330",579,9},
  {{{0x83f94517d1a2e410}},7,"F-H0-8331",865,5},
  {{{0xd9a9581cedf696ad}},7,"F-H0-8332",950,5},
  {{{0xd9a9581cedf696ad}},7,"F-H0-8333",763,2},
  {{{0x793724105c8a6dbf}},7,"F-H0-8334",939,6},
  {{{0x4366a6b75bb4b07d}},7,"F-H0-8335",943,3},
  {{{0x4c87edf11480faea}},7,"F-H0-8336",542,10},
  {{{0x76c061bbab8af4a3}},12,"F-H0-8337",910,11},
  {{{0xf4981ab4711cb517}},7,"F-H0-8338",690,8},
  {{{0x2edabf93b4240707}},10,"F-H0-8339",838,10},
  {{{0xcdcb5376703bae60}},10,"F-H0-8340",691,6},
  {{{0xcdcb5376703bae60}},10,"F-H0-8341",876,2},
  {{{0xc4dc2fb5c3f5d019}},6,"F-H0-8342",529,10},
  {{{0xf1c77a0dfd3ce0cb}},6,"F-H0-8343",456,3},
  {{{0x409bda50be80d047}},5,"F-H0-8344",947,3},
  {{{0x409bda50be80d047}},5,"F-H0-8345",690,2},
  {{{0x409bda50be80d047}},5,"F-H0-8346",691,2},
  {{{0xce948d949bd13561}},5,"F-H0-8347",939,2},
  {{{0xda67281478b9a31d}},11,"F-H0-8348",428,5},
  {{{0xda67281478b9a31d}},11,"F-H0-8349",911,4},
  {{{0x29efdeb35afac61f}},8,"F-H0-8350",393,12},
  {{{0x1c2536c64da4dbaa}},13,"F-H0-8351",913,11},
  {{{0x82fcdfece506c3e1}},8,"F-H0-8352",496,3},
  {{{0x258aafa0ee645e4a}},7,"F-H0-8353",459,4},
  {{{0xd1592efec4bce8b2}},12,"F-H0-8354",801,5},
  {{{0xd1592efec4bce8b2}},12,"F-H0-8355",909,5},
  {{{0xdce453fded2d956b}},15,"F-H0-8356",838,2},
  {{{0xdce453fded2d956b}},15,"F-H0-8357",982,2},
  {{{0x620ae931316472f}},8,"F-H0-8358",839,4},
  {{{0xd22bfca84934b063}},8,"F-H0-8359",905,2},
  {{{0xd22bfca84934b063}},8,"F-H0-8360",941,2},
  {{{0xc90b935304abb957}},8,"F-H0-8361",468,12},
  {{{0xe7007ab53414dce5}},14,"F-H0-8362",615,3},
  {{{0x977f1f96e07e1c6a}},14,"F-H0-8363",788,3},
  {{{0x977f1f96e07e1c6a}},14,"F-H0-8364",974,2},
  {{{0x3c251d7bec02e925}},14,"F-H0-8365",467,2},
  {{{0x733b894eca5eb509}},11,"F-H0-8366",418,6},
  {{{0x980d055657c4a8aa}},11,"F-H0-8367",839,2},
  {{{0xb84bc994ef241188}},8,"F-H0-8368",432,7},
  {{{0xb84bc994ef241188}},8,"F-H0-8369",466,2},
  {{{0x6cb8def8a1d494cd}},6,"F-H0-8370",950,7},
  {{{0x6cb8def8a1d494cd}},6,"F-H0-8371",837,5},
  {{{0x7f8b6e8d5d74a516}},6,"F-H0-8372",913,5},
  {{{0x7f8b6e8d5d74a516}},6,"F-H0-8373",987,4},
  {{{0x4858e1152dcc7d37}},7,"F-H0-8374",900,10},
  {{{0x70cb86a1b9d4ed5c}},6,"F-H0-8375",462,3},
  {{{0x70cb86a1b9d4ed5c}},6,"F-H0-8376",543,3},
  {{{0x820f4660d911ca5c}},6,"F-H0-8377",617,2},
  {{{0xdd2c048ca574db01}},10,"F-H0-8378",615,11},
  {{{0x300ba853bcf2a770}},5,"F-H0-8379",907,3},
  {{{0xda92282545ee60f4}},5,"F-H0-8380",423,2},
  {{{0x3ab9dcb9c6397250}},5,"F-H0-8381",728,2},
  {{{0xe0bbff8b8ea9628b}},9,"F-H0-8382",429,5},
  {{{0xe0bbff8b8ea9628b}},9,"F-H0-8383",617,2},
  {{{0x801f2b79b072f4f1}},6,"F-H0-8384",789,10},
  {{{0x84eba57d7537a343}},6,"F-H0-8385",690,7},
  {{{0x84eba57d7537a343}},6,"F-H0-8386",691,2},
  {{{0x4721ce1b9ece1989}},16,"F-H0-8387",914,5},
  {{{0x4721ce1b9ece1989}},16,"F-H0-8388",876,4},
  {{{0xd58ec59de9fbb7b5}},13,"F-H0-8389",985,11},
  {{{0x4665d84ccce4314a}},9,"F-H0-8390",467,6},
  {{{0x4665d84ccce4314a}},9,"F-H0-8391",464,2},
  {{{0x716bb9e0472970cd}},6,"F-H0-8392",418,8},
  {{{0xfd20106da3876716}},6,"F-H0-8393",906,3},
  {{{0x290999ff5f8395e7}},11,"F-H0-8394",383,6},
  {{{0x574eeb31c21d05ca}},16,"F-H0-8395",902,3},
  {{{0x574eeb31c21d05ca}},16,"F-H0-8396",939,3},
  {{{0xe55076e55ee6dd9}},14,"F-H0-8397",983,2},
  {{{0x3dfcb3552d8a939c}},5,"F-H0-8398",838,4},
  {{{0x7e87873e6ba15592}},5,"F-H0-8399",418,3},
  {{{0x3dfcb3552d8a939c}},5,"F-H0-8400",543,2},
  {{{0x3dfcb3552d8a939c}},5,"F-H0-8401",420,2},
  {{{0x6efe81ea616db552}},9,"F-H0-8402",974,8},
  {{{0x6efe81ea616db552}},9,"F-H0-8403",865,2},
  {{{0xab05fedc3d853c0d}},9,"F-H0-8404",752,2},
  {{{0xd3d49787c586a8ba}},15,"F-H0-8405",653,11},
  {{{0x96fa7d1e1cdba316}},11,"F-H0-8406",426,4},
  {{{0xd3af431d42e288de}},9,"F-H0-8407",936,10},
  {{{0x56f47438975e982b}},5,"F-H0-8408",429,4},
  {{{0x84ff66c7ca2d1291}},5,"F-H0-8409",941,2},
  {{{0x1363421c075fe438}},5,"F-H0-8410",458,2},
  {{{0xb6175d76bf380af1}},5,"F-H0-8411",907,2},
  {{{0x402df77e2fa064dc}},14,"F-H0-8412",800,9},
  {{{0x41dccc3236592b78}},16,"F-H0-8413",948,5},
  {{{0x2078cc1e8d34bf5e}},16,"F-H0-8414",788,3},
  {{{0xb6be4cd3475b3a5b}},16,"F-H0-8415",910,2},
  {{{0x5ff04b5827cafab2}},20,"F-H0-8416",906,3},
  {{{0x3daecbb7bbc72716}},20,"F-H0-8417",906,3},
  {{{0x597d5cb31271e107}},20,"F-H0-8418",947,3},
  {{{0x45d124cac82eb62e}},20,"F-H0-8419",421,2},
  {{{0xf53a0d3d31b80c44}},5,"F-H0-8420",838,4},
  {{{0x91512ca8f013f554}},5,"F-H0-8421",728,2},
  {{{0x91512ca8f013f554}},5,"F-H0-8422",839,2},
  {{{0x87d69d80941966ce}},5,"F-H0-8423",543,2},
  {{{0x3d7d2cdcbf8273dd}},7,"F-H0-8424",456,9},
  {{{0x3d7d2cdcbf8273dd}},7,"F-H0-8425",469,2},
  {{{0x2fe23cf15431e244}},10,"F-H0-8426",950,10},
  {{{0xd2a25c0722c48325}},8,"F-H0-8427",902,6},
  {{{0x4266d43c52543783}},8,"F-H0-8428",543,3},
  {{{0xd2a25c0722c48325}},8,"F-H0-8429",751,2},
  {{{0xd2a25c0722c48325}},8,"F-H0-8430",906,2},
  {{{0xa26cff48db57f7a4}},19,"F-H0-8431",863,2},
  {{{0xd2ae5a8a1a533b78}},4,"F-H0-8432",826,3},
  {{{0x1e50b0f1c920defd}},4,"F-H0-8433",939,3},
  {{{0x1e50b0f1c920defd}},4,"F-H0-8434",468,2},
  {{{0x537c7259b3aa589b}},6,"F-H0-8435",838,9},
  {{{0x18b2ad1b81b8f068}},6,"F-H0-8436",876,2},
  {{{0x5e24a47aa0a0ec97}},7,"F-H0-8437",423,2},
  {{{0x9c89d40cad1b439}},7,"F-H0-8438",902,7},
  {{{0x9c89d40cad1b439}},7,"F-H0-8439",903,3},
  {{{0xc08b09f21819b935}},15,"F-H0-8440",950,5},
  {{{0xae4d7c8458287ea}},8,"F-H0-8441",419,10},
  {{{0xd2113c3a095f5a7c}},7,"F-H0-8442",913,5},
  {{{0x2abb08a1fcca7420}},7,"F-H0-8443",417,4},
  {{{0x5d6f0ce8b5e1a1de}},17,"F-H0-8444",950,9},
  {{{0x5d6f0ce8b5e1a1de}},17,"F-H0-8445",765,2},
  {{{0x7a75c2a388b01935}},6,"F-H0-8446",902,2},
  {{{0x327cb1dd2f7ff6bd}},6,"F-H0-8447",765,2},
  {{{0xa39928878b4be3d9}},6,"F-H0-8448",466,2},
  {{{0x522610d9f76dbf9c}},6,"F-H0-8449",950,5},
  {{{0xf0027cbc6ceb1838}},6,"F-H0-8450",690,4},
  {{{0x9e65b1156d3a5059}},6,"F-H0-8451",461,2},
  {{{0xaa162410c94c0030}},4,"F-H0-8452",876,7},
  {{{0xaa162410c94c0030}},4,"F-H0-8453",542,2},
  {{{0xaa162410c94c0030}},4,"F-H0-8454",839,2},
  {{{0x24fbbec3d750fcdc}},3,"F-H0-8455",876,3},
  {{{0x3b09889002185a55}},3,"F-H0-8456",492,2},
  {{{0x334cb2c6e86020ed}},3,"F-H0-8457",505,2},
  {{{0xf6fcea582fbfaca3}},9,"F-H0-8458",902,7},
  {{{0x9d3b1236eabc70c9}},9,"F-H0-8459",567,5},
  {{{0xc4487b57fae3b85a}},7,"F-H0-8460",421,5},
  {{{0xc4487b57fae3b85a}},7,"F-H0-8461",458,3},
  {{{0xc4487b57fae3b85a}},7,"F-H0-8462",603,2},
  {{{0x75e14f238ab8915f}},9,"F-H0-8463",986,5},
  {{{0x75e14f238ab8915f}},9,"F-H0-8464",944,4},
  {{{0xb0c31d434c12cb70}},9,"F-H0-8465",939,5},
  {{{0x4bf0c16d4bbb6e05}},9,"F-H0-8466",950,5},
  {{{0xb0c31d434c12cb70}},9,"F-H0-8467",902,2},
  {{{0xa52866abfb0be497}},8,"F-H0-8468",421,4},
  {{{0xa52866abfb0be497}},8,"F-H0-8469",531,3},
  {{{0xa52866abfb0be497}},8,"F-H0-8470",906,2},
  {{{0xf12c77e8384cfd25}},6,"F-H0-8471",904,2},
  {{{0x9abe50fbdd27cb82}},6,"F-H0-8472",529,2},
  {{{0x2a71c50d96260f8c}},11,"F-H0-8473",432,5},
  {{{0x1b877cc3fc6faf0d}},11,"F-H0-8474",871,4},
  {{{0xe60faee7d1c7a46}},8,"F-H0-8475",950,8},
  {{{0xe60faee7d1c7a46}},8,"F-H0-8476",764,4},
  {{{0xd362a22a24247755}},8,"F-H0-8477",654,5},
  {{{0x2cbead13b495682}},8,"F-H0-8478",463,2},
  {{{0xd0af19f349432216}},8,"F-H0-8479",678,2},
  {{{0x2d5341558eca6807}},17,"F-H0-8480",690,2},
  {{{0xd79bdb3d109c16c5}},13,"F-H0-8481",939,8},
  {{{0x16a146d799a64533}},5,"F-H0-8482",567,6},
  {{{0x13716d0ba76f042d}},5,"F-H0-8483",431,2},
  {{{0x13716d0ba76f042d}},5,"F-H0-8484",825,2},
  {{{0x13716d0ba76f042d}},5,"F-H0-8485",839,2},
  {{{0xdfe1d95ea929d887}},7,"F-H0-8486",943,5},
  {{{0xdfe1d95ea929d887}},7,"F-H0-8487",947,5},
  {{{0x6475403ba8692cb2}},7,"F-H0-8488",429,3},
  {{{0xe04fcf093bcec9b6}},16,"F-H0-8489",873,11},
  {{{0xbab6bda965d38ab3}},11,"F-H0-8490",493,6},
  {{{0xd26f6a38c432f9fb}},11,"F-H0-8491",543,2},
  {{{0x567ac43a41c84c76}},9,"F-H0-8492",429,8},
  {{{0x567ac43a41c84c76}},9,"F-H0-8493",432,2},
  {{{0x2603e00f3dd00b2a}},9,"F-H0-8494",753,8},
  {{{0x71ff7fc1104e518}},9,"F-H0-8495",579,3},
  {{{0x55f3fc55d4ee40aa}},8,"F-H0-8496",912,6},
  {{{0x55f3fc55d4ee40aa}},8,"F-H0-8497",875,3},
  {{{0x3515d07deeeacfc1}},14,"F-H0-8498",904,5},
  {{{0x2d0b3b308204d97f}},14,"F-H0-8499",941,2},
  {{{0x8302d0bd4f5bfecd}},8,"F-H0-8500",945,8},
  {{{0xbd5ea4f364b6d95b}},8,"F-H0-8501",788,3},
  {{{0xbd5ea4f364b6d95b}},8,"F-H0-8502",825,2},
  {{{0x55e950d4629083df}},10,"F-H0-8503",871,2},
  {{{0x55e950d4629083df}},10,"F-H0-8504",873,2},
  {{{0x90d5087162ce8a83}},6,"F-H0-8505",432,9},
  {{{0xe56eaa57965584a4}},9,"F-H0-8506",874,10},
  {{{0xc0d1c4c048fa82ec}},9,"F-H0-8507",420,3},
  {{{0xf5e23c1d2d361fef}},6,"F-H0-8508",765,4},
  {{{0x902207ce61ad32b7}},6,"F-H0-8509",690,2},
  {{{0x13743b4000ac3251}},6,"F-H0-8510",421,2},
  {{{0x81ee0cc7d2a891cb}},9,"F-H0-8511",678,6},
  {{{0x81ee0cc7d2a891cb}},9,"F-H0-8512",910,2},
  {{{0x8b28c6c7ad68955d}},4,"F-H0-8513",947,2},
  {{{0x5079006ed96e37c}},4,"F-H0-8514",906,2},
  {{{0xecf4ab07e27ba016}},8,"F-H0-8515",653,7},
  {{{0x283de73b6815a8b1}},8,"F-H0-8516",943,3},
  {{{0x7a207fdb394e6f16}},5,"F-H0-8517",604,3},
  {{{0x7a207fdb394e6f16}},5,"F-H0-8518",911,3},
  {{{0x96d4820635b49370}},5,"F-H0-8519",946,2},
  {{{0x1bf7b6d225613df}},12,"F-H0-8520",973,4},
  {{{0xcf8834cb8872d2ab}},7,"F-H0-8521",466,12},
  {{{0x6d2416c1082cb07b}},7,"F-H0-8522",431,12},
  {{{0x546949a040767328}},17,"F-H0-8523",939,4},
  {{{0x546949a040767328}},17,"F-H0-8524",838,3},
  {{{0x546949a040767328}},17,"F-H0-8525",728,2},
  {{{0xb96131b97d19069e}},6,"F-H0-8526",432,8},
  {{{0xb96131b97d19069e}},6,"F-H0-8527",541,2},
  {{{0x88b2cbb18f9d0e57}},7,"F-H0-8528",469,12},
  {{{0x4a8c9aa88aa9f405}},9,"F-H0-8529",950,6},
  {{{0x424119fe8b681d8a}},14,"F-H0-8530",800,8},
  {{{0x80cb2a3228a92fc3}},7,"F-H0-8531",946,8},
  {{{0x80cb2a3228a92fc3}},7,"F-H0-8532",947,4},
  {{{0x7c15e6e27e216f8f}},15,"F-H0-8533",983,7},
  {{{0x7c15e6e27e216f8f}},15,"F-H0-8534",836,4},
  {{{0xdd2abdf87330cf62}},8,"F-H0-8535",949,8},
  {{{0x37aa4b198683665d}},8,"F-H0-8536",987,2},
  {{{0xee9a4e8b45d4678d}},9,"F-H0-8537",950,4},
  {{{0xee9a4e8b45d4678d}},9,"F-H0-8538",617,2},
  {{{0x2b8488680cde0a36}},5,"F-H0-8539",430,3},
  {{{0xf53a1f3974a21fe8}},5,"F-H0-8540",466,2},
  {{{0x9b78031d64c5490a}},5,"F-H0-8541",901,2},
  {{{0x792de026cfcbd4e1}},5,"F-H0-8542",948,2},
  {{{0xfca88100aa79aaa0}},15,"F-H0-8543",825,4},
  {{{0xddb81717d4d925f3}},13,"F-H0-8544",506,11},
  {{{0x15262afcc5872697}},15,"F-H0-8545",529,9},
  {{{0x15262afcc5872697}},15,"F-H0-8546",493,2},
  {{{0x655f3808643a032}},11,"F-H0-8547",986,11},
  {{{0xca7c6b3c958f6767}},4,"F-H0-8548",469,3},
  {{{0x371319d1320f3b74}},4,"F-H0-8549",901,2},
  {{{0xca7c6b3c958f6767}},4,"F-H0-8550",907,2},
  {{{0x89eecbb8996eafd2}},2,"F-H0-8551",468,2},
  {{{0x89eecbb8996eafd2}},2,"F-H0-8552",431,2},
  {{{0x2c53e154c2483a3}},2,"F-H0-8553",899,2},
  {{{0x91f0cc882f1295ad}},7,"F-H0-8554",911,5},
  {{{0x91f0cc882f1295ad}},7,"F-H0-8555",939,4},
  {{{0xc3defa4d49dffea2}},13,"F-H0-8556",690,11},
  {{{0x5994375e3a94ea4d}},7,"F-H0-8557",827,8},
  {{{0x5994375e3a94ea4d}},7,"F-H0-8558",936,2},
  {{{0xf1b10ae2f4ea2fa4}},10,"F-H0-8559",454,6},
  {{{0xe49cd9548aa5cf00}},10,"F-H0-8560",976,3},
  {{{0x432d43811737d224}},7,"F-H0-8561",468,9},
  {{{0xb154d68c126d1d18}},3,"F-H0-8562",937,6},
  {{{0x7bfb52ebd483c0fa}},3,"F-H0-8563",949,4},
  {{{0xe46cb98a17b460e3}},16,"F-H0-8564",948,3},
  {{{0xe46cb98a17b460e3}},16,"F-H0-8565",529,3},
  {{{0xadabaa0bb403f79c}},4,"F-H0-8566",455,4},
  {{{0xadabaa0bb403f79c}},4,"F-H0-8567",752,3},
  {{{0x4057735325ba4f88}},8,"F-H0-8568",912,12},
  {{{0xf612ef5294a170e3}},5,"F-H0-8569",460,2},
  {{{0x5fc002881734511e}},18,"F-H0-8570",690,3},
  {{{0x5fc002881734511e}},18,"F-H0-8571",910,3},
  {{{0x3189de40f0a080ff}},5,"F-H0-8572",420,4},
  {{{0xc61c9da5e766830c}},5,"F-H0-8573",938,3},
  {{{0xf61c56a546f7443e}},14,"F-H0-8574",974,4},
  {{{0x9d63a31fdfaeda7e}},14,"F-H0-8575",615,2},
  {{{0x2f169b4aab02428d}},14,"F-H0-8576",906,2},
  {{{0xb67fb9d900529b5}},17,"F-H0-8577",787,8},
  {{{0x1a59ededb79e8d49}},4,"F-H0-8578",457,7},
  {{{0x882e75e22f718c94}},4,"F-H0-8579",430,2},
  {{{0xf85c184dfb13c044}},8,"F-H0-8580",506,7},
  {{{0x2899cf0525e9edeb}},6,"F-H0-8581",432,6},
  {{{0x3ece6d7a724591fd}},6,"F-H0-8582",531,2},
  {{{0x944436860adeafb7}},5,"F-H0-8583",825,4},
  {{{0x629c6319952ea041}},5,"F-H0-8584",543,4},
  {{{0x944436860adeafb7}},5,"F-H0-8585",943,3},
  {{{0x94c6b5cc4d59ab21}},8,"F-H0-8586",838,7},
  {{{0x94c6b5cc4d59ab21}},8,"F-H0-8587",910,2},
  {{{0x811169e779a163b7}},8,"F-H0-8588",432,7},
  {{{0x811169e779a163b7}},8,"F-H0-8589",579,3},
  {{{0xe1446079ae04dcdc}},6,"F-H0-8590",529,10},
  {{{0x4a85fb73bc5d31b2}},6,"F-H0-8591",468,2},
  {{{0x6718e773d9c2c095}},10,"F-H0-8592",470,12},
  {{{0x52ed29635d55eaf8}},5,"F-H0-8593",825,4},
  {{{0x52ed29635d55eaf8}},5,"F-H0-8594",462,3},
  {{{0x52ed29635d55eaf8}},5,"F-H0-8595",939,3},
  {{{0x21020b80f2284b3}},3,"F-H0-8596",456,5},
  {{{0xbdd831324023613}},3,"F-H0-8597",949,3},
  {{{0xbdd831324023613}},3,"F-H0-8598",950,3},
  {{{0xbcec9062e6c0b180}},9,"F-H0-8599",580,2},
  {{{0x7c33f260575abf51}},9,"F-H0-8600",839,2},
  {{{0x1a545e854c20058}},9,"F-H0-8601",945,2},
  {{{0xaef9a8cc8279c9a8}},19,"F-H0-8602",789,8},
  {{{0x595077b2ac7d1e00}},6,"F-H0-8603",875,6},
  {{{0xa176030bb528526}},6,"F-H0-8604",429,4},
  {{{0x4873488373779b9e}},6,"F-H0-8605",603,2},
  {{{0x7a243530d56936d1}},10,"F-H0-8606",876,11},
  {{{0xd4e1de4fcb03cf3d}},18,"F-H0-8607",949,11},
  {{{0xd7ace31ab0d6a6d4}},4,"F-H0-8608",456,3},
  {{{0xf5d1a48e866a6a7c}},4,"F-H0-8609",913,2},
  {{{0xf5d1a48e866a6a7c}},4,"F-H0-8610",457,2},
  {{{0xf5d1a48e866a6a7c}},4,"F-H0-8611",788,2},
  {{{0x708edf3f47a0a74e}},8,"F-H0-8612",394,11},
  {{{0x153b8feddbfd3051}},14,"F-H0-8613",458,11},
  {{{0xc67e8318e75fe5af}},14,"F-H0-8614",429,12},
  {{{0x5fe147d9a6a7dece}},5,"F-H0-8615",910,6},
  {{{0x5fe147d9a6a7dece}},5,"F-H0-8616",950,3},
  {{{0xb16d6ebf7e1475a8}},10,"F-H0-8617",913,11},
  {{{0x57b8f41c239981c4}},7,"F-H0-8618",456,5},
  {{{0x57b8f41c239981c4}},7,"F-H0-8619",417,2},
  {{{0x3cdb9581336a7622}},7,"F-H0-8620",466,2},
  {{{0xf532be6c23576285}},5,"F-H0-8621",974,3},
  {{{0x2b3539f03289fdfc}},5,"F-H0-8622",910,2},
  {{{0x9dca02eea47eead4}},9,"F-H0-8623",506,9},
  {{{0x50f3c1e238d049bb}},17,"F-H0-8624",908,10},
  {{{0x50f3c1e238d049bb}},17,"F-H0-8625",872,2},
  {{{0x25aba2e30675f0fa}},9,"F-H0-8626",381,9},
  {{{0x7a71f727a3398d1b}},6,"F-H0-8627",467,3},
  {{{0x5df4f192e5a19582}},6,"F-H0-8628",495,3},
  {{{0xfcf5799ab144bae3}},12,"F-H0-8629",951,10},
  {{{0x31d77e3543bbbcd9}},3,"F-H0-8630",827,4},
  {{{0x7742fcd5d3f1d2d7}},6,"F-H0-8631",420,11},
  {{{0x41e83eea70f100e}},7,"F-H0-8632",973,3},
  {{{0x1e8f1a9ff220bb02}},10,"F-H0-8633",466,10},
  {{{0xe719efc2c64a5065}},10,"F-H0-8634",458,2},
  {{{0x8bcede77db981e93}},13,"F-H0-8635",578,10},
  {{{0x4253fc2c5a29bb94}},6,"F-H0-8636",911,8},
  {{{0xf19df3699dd3662a}},8,"F-H0-8637",470,6},
  {{{0x54107f0e7e4ce91c}},8,"F-H0-8638",799,3},
  {{{0xf19df3699dd3662a}},8,"F-H0-8639",764,2},
  {{{0xbe0f1c88e2b15bd0}},10,"F-H0-8640",380,5},
  {{{0xbe0f1c88e2b15bd0}},10,"F-H0-8641",492,2},
  {{{0x2d562631a223490f}},11,"F-H0-8642",505,3},
  {{{0xbce3ba59ddb32c9}},6,"F-H0-8643",690,3},
  {{{0xa60596002120b933}},6,"F-H0-8644",462,3},
  {{{0xd4bce525ff2f39e9}},6,"F-H0-8645",543,2},
  {{{0x1bd7a87be779171d}},17,"F-H0-8646",947,4},
  {{{0x4cc8e27dffbcaa}},2,"F-H0-8647",826,3},
  {{{0x4113d1a300ac6d97}},8,"F-H0-8648",802,4},
  {{{0x4113d1a300ac6d97}},8,"F-H0-8649",838,3},
  {{{0xec2c45e9fe8a38c9}},13,"F-H0-8650",492,11},
  {{{0xcd6c8b181d7fc8f7}},5,"F-H0-8651",429,6},
  {{{0xcd6c8b181d7fc8f7}},5,"F-H0-8652",466,3},
  {{{0xcd6c8b181d7fc8f7}},5,"F-H0-8653",653,2},
  {{{0x6955ff85fe4c6d6b}},11,"F-H0-8654",491,11},
  {{{0xa948d7592ab7cf13}},8,"F-H0-8655",495,5},
  {{{0xb15786cb1d85e441}},15,"F-H0-8656",837,4},
  {{{0xf043c18d28fb9ee7}},15,"F-H0-8657",541,3},
  {{{0xa8ac929b1bb2fbe4}},4,"F-H0-8658",862,2},
  {{{0x9f3106ba2e0fc6fd}},4,"F-H0-8659",947,3},
  {{{0x9f3106ba2e0fc6fd}},4,"F-H0-8660",909,2},
  {{{0x72c404966b153fe6}},4,"F-H0-8661",543,2},
  {{{0x44520cfa7bdcc203}},7,"F-H0-8662",911,3},
  {{{0x44520cfa7bdcc203}},7,"F-H0-8663",429,3},
  {{{0x44520cfa7bdcc203}},7,"F-H0-8664",617,2},
  {{{0x2527f47939bcb2b5}},10,"F-H0-8665",947,8},
  {{{0x8f8908524f06ad67}},10,"F-H0-8666",457,2},
  {{{0x618e809038af9a07}},10,"F-H0-8667",466,2},
  {{{0xf846afc056d2e0b3}},4,"F-H0-8668",752,2},
  {{{0xf846afc056d2e0b3}},4,"F-H0-8669",431,2},
  {{{0xd4457b7ea4c40724}},4,"F-H0-8670",826,2},
  {{{0x364a4a6424d9d20e}},3,"F-H0-8671",949,5},
  {{{0x1b39cac436f02b4f}},3,"F-H0-8672",468,3},
  {{{0xe33d4905506faf9d}},10,"F-H0-8673",426,11},
  {{{0x617da5db141ffbe8}},8,"F-H0-8674",654,3},
  {{{0x31389a53edcf06bd}},3,"F-H0-8675",912,6},
  {{{0xde6e8e985269fb45}},7,"F-H0-8676",648,5},
  {{{0xc1f5863e39c62db6}},7,"F-H0-8677",943,3},
  {{{0xc1f5863e39c62db6}},7,"F-H0-8678",825,3},
  {{{0xbb432a010c41bb37}},9,"F-H0-8679",948,10},
  {{{0x6cfb0394639a5e91}},8,"F-H0-8680",939,10},
  {{{0x26342fcefaa8b83e}},9,"F-H0-8681",789,9},
  {{{0x41fc79a19cbd0acb}},4,"F-H0-8682",912,4},
  {{{0x74c4f1d9eba910f8}},4,"F-H0-8683",604,2},
  {{{0x74c4f1d9eba910f8}},4,"F-H0-8684",566,2},
  {{{0xa835c46d4565fccd}},4,"F-H0-8685",863,2},
  {{{0x619a55ba36c580f7}},6,"F-H0-8686",432,4},
  {{{0x7765413e16df5821}},6,"F-H0-8687",429,4},
  {{{0x7765413e16df5821}},6,"F-H0-8688",541,3},
  {{{0x9880f02f703536b6}},16,"F-H0-8689",949,11},
  {{{0xf866ca87f3c6a1dc}},7,"F-H0-8690",506,5},
  {{{0xd0f2246d0403bb56}},7,"F-H0-8691",677,3},
  {{{0xf866ca87f3c6a1dc}},7,"F-H0-8692",505,3},
  {{{0xf33d63260398dead}},5,"F-H0-8693",429,5},
  {{{0xb1dc45f156d2fc3d}},5,"F-H0-8694",945,2},
  {{{0xf33d63260398dead}},5,"F-H0-8695",466,2},
  {{{0x8cd9bd47f779bdd7}},12,"F-H0-8696",976,7},
  {{{0x106458387ec83192}},11,"F-H0-8697",908,2},
  {{{0x571e1bcb7dc12b}},16,"F-H0-8698",428,9},
  {{{0x791f713bfeb44414}},16,"F-H0-8699",380,2},
  {{{0x8ee6a35d373fc25f}},5,"F-H0-8700",910,6},
  {{{0xe66e4f99da8e5237}},5,"F-H0-8701",467,3},
  {{{0x34f55c881ab7ce17}},8,"F-H0-8702",383,5},
  {{{0xed81cc870def643}},8,"F-H0-8703",912,4},
  {{{0xed81cc870def643}},8,"F-H0-8704",875,3},
  {{{0xbd8038cf18e882}},4,"F-H0-8705",456,9},
  {{{0x729c600ce5f9080}},4,"F-H0-8706",462,2},
  {{{0x805d802d71efbc10}},9,"F-H0-8707",903,2},
  {{{0x85de770f044acdcc}},7,"F-H0-8708",542,7},
  {{{0x11a063c5dd59b0da}},7,"F-H0-8709",495,2},
  {{{0xd0405b1dec56f8de}},7,"F-H0-8710",874,2},
  {{{0x16d3f641c445c7b}},9,"F-H0-8711",801,2},
  {{{0x2f2fd27731b1eb}},10,"F-H0-8712",947,12},
  {{{0x2a6ed03270a7c9c8}},8,"F-H0-8713",950,4},
  {{{0xd0bb634452c2889e}},8,"F-H0-8714",616,3},
  {{{0x13d06c3539051ae1}},6,"F-H0-8715",838,4},
  {{{0x33180afdf40796ab}},6,"F-H0-8716",800,2},
  {{{0xb100aef45f5dcb3b}},6,"F-H0-8717",461,2},
  {{{0x8d522ea0dba2ffd3}},6,"F-H0-8718",677,2},
  {{{0xff4f57aa7ac2d0e8}},11,"F-H0-8719",493,4},
  {{{0xff4f57aa7ac2d0e8}},11,"F-H0-8720",939,4},
  {{{0xa1b517a6acfc4a1f}},4,"F-H0-8721",913,5},
  {{{0x70d7f62d88ab1c2c}},4,"F-H0-8722",457,3},
  {{{0xc832535e2babe792}},19,"F-H0-8723",840,9},
  {{{0xc832535e2babe792}},19,"F-H0-8724",987,3},
  {{{0x107bf6603194c28b}},4,"F-H0-8725",429,2},
  {{{0xebfcb370151db41a}},4,"F-H0-8726",421,2},
  {{{0xc8564ad09fe40e46}},4,"F-H0-8727",678,2},
  {{{0xd1068ed513341fe0}},7,"F-H0-8728",939,5},
  {{{0xde5ca32697f4368f}},7,"F-H0-8729",939,4},
  {{{0x8290654aef5691eb}},16,"F-H0-8730",948,6},
  {{{0x8290654aef5691eb}},16,"F-H0-8731",803,3},
  {{{0xfd83b834ec8ee32e}},6,"F-H0-8732",825,5},
  {{{0xa082e6fb4595556c}},6,"F-H0-8733",902,3},
  {{{0x91f63e962309b450}},15,"F-H0-8734",877,8},
  {{{0xb409d7cc32fa45f4}},6,"F-H0-8735",937,12},
  {{{0x3953ab1243561065}},9,"F-H0-8736",395,9},
  {{{0x30cc5dccc690a2e6}},9,"F-H0-8737",944,8},
  {{{0x815e6236afbec9f4}},9,"F-H0-8738",617,2},
  {{{0xa5c6508f6135cf8f}},6,"F-H0-8739",764,2},
  {{{0x900b92c9705c6798}},6,"F-H0-8740",948,2},
  {{{0x900b92c9705c6798}},6,"F-H0-8741",789,2},
  {{{0xc9bd1472f8f1499d}},6,"F-H0-8742",467,2},
  {{{0x900b92c9705c6798}},6,"F-H0-8743",715,2},
  {{{0xf30712953dda7be0}},9,"F-H0-8744",838,4},
  {{{0xb280f945a2292303}},9,"F-H0-8745",579,2},
  {{{0xe8428434bab738a}},15,"F-H0-8746",986,11},
  {{{0x1370054f5bd2da88}},7,"F-H0-8747",431,10},
  {{{0x7b068c82a998be4a}},15,"F-H0-8748",863,8},
  {{{0xb0be9a7788d3a026}},15,"F-H0-8749",938,2},
  {{{0xe226a581ac4bb7d6}},7,"F-H0-8750",678,5},
  {{{0xe226a581ac4bb7d6}},7,"F-H0-8751",898,5},
  {{{0x93f37d36461c7794}},6,"F-H0-8752",714,5},
  {{{0x5045ad8757de5966}},6,"F-H0-8753",914,2},
  {{{0x36a3895a8f0e3a90}},5,"F-H0-8754",949,3},
  {{{0x36a3895a8f0e3a90}},5,"F-H0-8755",825,2},
  {{{0xff12beee1215b91b}},4,"F-H0-8756",863,4},
  {{{0xda934ddb2da44fb2}},17,"F-H0-8757",913,12},
  {{{0xf9e3bf20b5e0a1fc}},7,"F-H0-8758",418,4},
  {{{0x4844c27641886fc7}},7,"F-H0-8759",946,2},
  {{{0xcaecf874cef821a8}},10,"F-H0-8760",419,6},
  {{{0x4e7ca9b0d6bc1bab}},9,"F-H0-8761",864,3},
  {{{0xfe6af04ccb2acef8}},9,"F-H0-8762",530,3},
  {{{0xfe6af04ccb2acef8}},9,"F-H0-8763",462,2},
  {{{0x61fa272a1c13e1aa}},6,"F-H0-8764",910,2},
  {{{0xbb5859dbf47ba10c}},6,"F-H0-8765",910,2},
  {{{0xc84fa4e1f08980a1}},6,"F-H0-8766",461,2},
  {{{0xb5ebed6163c8d430}},7,"F-H0-8767",466,10},
  {{{0xec46d53ad758c586}},10,"F-H0-8768",544,10},
  {{{0x24f17e8f3aacc0d1}},14,"F-H0-8769",421,10},
  {{{0x7dfae3146f23c7d4}},13,"F-H0-8770",950,9},
  {{{0x1f5528ff946937e9}},14,"F-H0-8771",677,6},
  {{{0xeb447bee49b8d322}},14,"F-H0-8772",543,3},
  {{{0x3796a9b279a99b3d}},7,"F-H0-8773",939,9},
  {{{0x3796a9b279a99b3d}},7,"F-H0-8774",940,2},
  {{{0x42bde4a11d473559}},5,"F-H0-8775",873,8},
  {{{0x42bde4a11d473559}},5,"F-H0-8776",950,2},
  {{{0x7f094566ed5859e5}},14,"F-H0-8777",899,4},
  {{{0x5bf3d3395455aef7}},14,"F-H0-8778",826,3},
  {{{0xcf2b651406f5afb4}},9,"F-H0-8779",505,10},
  {{{0x7570f70806d8400b}},20,"F-H0-8780",529,10},
  {{{0x733f80dade910acd}},13,"F-H0-8781",872,10},
  {{{0x20881002fb42f7ac}},6,"F-H0-8782",653,5},
  {{{0x20881002fb42f7ac}},6,"F-H0-8783",690,3},
  {{{0x20881002fb42f7ac}},6,"F-H0-8784",470,2},
  {{{0xd1c3e785c4780af1}},9,"F-H0-8785",911,3},
  {{{0xa33da13d7cd74e2a}},9,"F-H0-8786",506,3},
  {{{0xf12f02a2550d131b}},9,"F-H0-8787",947,2},
  {{{0xa2974e1327d929ea}},13,"F-H0-8788",985,9},
  {{{0xb9b81139f97e24ef}},13,"F-H0-8789",530,2},
  {{{0xe7e50ffdec063d1e}},7,"F-H0-8790",985,6},
  {{{0x798822a1300ff01f}},7,"F-H0-8791",900,3},
  {{{0x31880c6a0eed6935}},6,"F-H0-8792",531,5},
  {{{0xd3b7ddc0f734359b}},6,"F-H0-8793",466,5},
  {{{0x94a6c5f284d42f82}},10,"F-H0-8794",948,6},
  {{{0x94a6c5f284d42f82}},10,"F-H0-8795",469,3},
  {{{0x9e948c7979ee00e4}},10,"F-H0-8796",454,10},
  {{{0x104c34179cc51d9e}},19,"F-H0-8797",875,3},
  {{{0xcf3fa1f129e031ed}},11,"F-H0-8798",752,4},
  {{{0xbb1f54bfd3b0a4c7}},11,"F-H0-8799",430,4},
  {{{0xcf3fa1f129e031ed}},11,"F-H0-8800",788,2},
  {{{0xb4c4d97d99cd590f}},2,"F-H0-8801",862,4},
  {{{0xb4c4d97d99cd590f}},2,"F-H0-8802",936,4},
  {{{0xa9e87a7ec4ae514}},2,"F-H0-8803",901,2},
  {{{0x1f3d915ac495ec00}},4,"F-H0-8804",752,4},
  {{{0x1f3d915ac495ec00}},4,"F-H0-8805",912,2},
  {{{0x608c06e77b829a0c}},4,"F-H0-8806",455,2},
  {{{0x4f1d714f57920726}},11,"F-H0-8807",910,9},
  {{{0x8cd1c07e3a8b033e}},11,"F-H0-8808",950,5},
  {{{0x8cd1c07e3a8b033e}},11,"F-H0-8809",907,4},
  {{{0x8cd1c07e3a8b033e}},11,"F-H0-8810",909,2},
  {{{0x56eafce39a7eac05}},7,"F-H0-8811",530,8},
  {{{0xb90cb9dde783dba5}},7,"F-H0-8812",838,3},
  {{{0xd760db81cc009c40}},10,"F-H0-8813",906,5},
  {{{0xc6a09cfaadb3447}},10,"F-H0-8814",943,2},
  {{{0xe8e11732b0ba46f2}},8,"F-H0-8815",579,7},
  {{{0xe8e11732b0ba46f2}},8,"F-H0-8816",432,3},
  {{{0x8b2db886cc64478b}},12,"F-H0-8817",531,6},
  {{{0x3a3e2a3457821333}},6,"F-H0-8818",505,10},
  {{{0x82ffcdad37e088b2}},6,"F-H0-8819",503,6},
  {{{0xde7881766c3e197a}},6,"F-H0-8820",429,4},
  {{{0x779cdaa835a13030}},6,"F-H0-8821",462,9},
  {{{0xae67941d1664e724}},6,"F-H0-8822",862,9},
  {{{0x13daa690abc38c7d}},19,"F-H0-8823",839,11},
  {{{0x7f01cc39f2cbfae}},8,"F-H0-8824",762,2},
  {{{0xce2b076770b325a1}},4,"F-H0-8825",949,4},
  {{{0xc372c4cb5248868}},4,"F-H0-8826",900,3},
  {{{0xce2b076770b325a1}},4,"F-H0-8827",506,2},
  {{{0x56b31003299232d6}},14,"F-H0-8828",839,11},
  {{{0x2dfb8383e3c03ff6}},18,"F-H0-8829",948,11},
  {{{0x4cdea8306f27221c}},7,"F-H0-8830",940,5},
  {{{0x22adc004a28d7ea0}},7,"F-H0-8831",567,5},
  {{{0xbc995ba6d5cea97c}},6,"F-H0-8832",825,8},
  {{{0x8f5cca4033dea7f8}},6,"F-H0-8833",457,3},
  {{{0x2905faff090fc94f}},6,"F-H0-8834",975,11},
  {{{0x8b7ce3e97487a38}},2,"F-H0-8835",457,3},
  {{{0xf00a9819258f8672}},2,"F-H0-8836",430,2},
  {{{0xf00a9819258f8672}},2,"F-H0-8837",467,2},
  {{{0xee0ba3094a4f502f}},12,"F-H0-8838",985,8},
  {{{0x810ca518e96da2ce}},5,"F-H0-8839",460,3},
  {{{0x97c98624bd263dc6}},5,"F-H0-8840",505,3},
  {{{0x67f4bbe500c046eb}},5,"F-H0-8841",617,2},
  {{{0x447663d1e41dc0d}},8,"F-H0-8842",948,5},
  {{{0x447663d1e41dc0d}},8,"F-H0-8843",911,2},
  {{{0x447663d1e41dc0d}},8,"F-H0-8844",874,2},
  {{{0x57604582e8b18c8d}},13,"F-H0-8845",874,10},
  {{{0x1dc9725f84b893d6}},8,"F-H0-8846",913,10},
  {{{0xcb37559de893a55a}},10,"F-H0-8847",541,5},
  {{{0xd814b45e7e57cc7f}},12,"F-H0-8848",898,5},
  {{{0xd814b45e7e57cc7f}},12,"F-H0-8849",902,3},
  {{{0x7582223f66e65e88}},5,"F-H0-8850",911,4},
  {{{0x7582223f66e65e88}},5,"F-H0-8851",910,2},
  {{{0x89aed40898fb9324}},5,"F-H0-8852",826,2},
  {{{0xe38fbf8911e53e33}},11,"F-H0-8853",826,7},
  {{{0x18c812e72bc7911f}},3,"F-H0-8854",468,6},
  {{{0x98bbf63e7ff8699e}},3,"F-H0-8855",455,5},
  {{{0x815bcbb2c9c0f8f}},2,"F-H0-8856",876,3},
  {{{0xbc31c7a1edc820ea}},2,"F-H0-8857",899,2},
  {{{0xec6b2f8f8df67dbd}},11,"F-H0-8858",421,6},
  {{{0xec6b2f8f8df67dbd}},11,"F-H0-8859",839,3},
  {{{0xd61845d07ccf4b54}},8,"F-H0-8860",468,9},
  {{{0x2e52cd4ab06cc340}},10,"F-H0-8861",639,11},
  {{{0x26d9062d3fdb21cc}},6,"F-H0-8862",909,5},
  {{{0x26d9062d3fdb21cc}},6,"F-H0-8863",873,5},
  {{{0x84b87a17fb8c5dbb}},16,"F-H0-8864",464,5},
  {{{0x7bdb5ae9e8aa1a48}},8,"F-H0-8865",914,8},
  {{{0x1c4861ad37730244}},3,"F-H0-8866",455,8},
  {{{0x997fcb624e1883c9}},3,"F-H0-8867",468,3},
  {{{0x90a4d0cc67bfbb7d}},17,"F-H0-8868",987,11},
  {{{0x18358b5c5889ec51}},6,"F-H0-8869",865,3},
  {{{0x92fe27dbc537f762}},6,"F-H0-8870",432,3},
  {{{0x602774399f919b54}},12,"F-H0-8871",417,10},
  {{{0x46692ee0743b8576}},8,"F-H0-8872",470,7},
  {{{0x46692ee0743b8576}},8,"F-H0-8873",690,2},
  {{{0x46692ee0743b8576}},8,"F-H0-8874",539,2},
  {{{0xdfda860794edf189}},3,"F-H0-8875",456,3},
  {{{0x2a83f74bdbb20936}},3,"F-H0-8876",826,3},
  {{{0x7d8d5991b86f8ba0}},5,"F-H0-8877",506,3},
  {{{0xc2db8e10a4eaa9c5}},5,"F-H0-8878",458,3},
  {{{0x419823b08d989442}},18,"F-H0-8879",875,11},
  {{{0x4634b212fffa0e85}},4,"F-H0-8880",468,3},
  {{{0xfa0776359f542662}},4,"F-H0-8881",457,3},
  {{{0x8db9c2fb3542af42}},4,"F-H0-8882",506,3},
  {{{0x9f66707c80a01ea9}},11,"F-H0-8883",825,5},
  {{{0x6f137348f58a1e1a}},11,"F-H0-8884",422,3},
  {{{0x6f137348f58a1e1a}},11,"F-H0-8885",825,2},
  {{{0xfcf2b06e90e30654}},5,"F-H0-8886",936,2},
  {{{0xfbfeb32791441164}},5,"F-H0-8887",876,2},
  {{{0x1c12ec8796fdcf57}},7,"F-H0-8888",466,6},
  {{{0xd3b50a33059e4122}},7,"F-H0-8889",494,3},
  {{{0xd430bcda1e771b9f}},7,"F-H0-8890",910,2},
  {{{0x21a1020026dabf26}},7,"F-H0-8891",801,8},
  {{{0x21a1020026dabf26}},7,"F-H0-8892",837,2},
  {{{0x21a1020026dabf26}},7,"F-H0-8893",838,2},
  {{{0x6cab86793ded88d9}},5,"F-H0-8894",429,3},
  {{{0xbed52a8f4b1eefe8}},6,"F-H0-8895",874,6},
  {{{0x15b6f99878fda258}},6,"F-H0-8896",493,4},
  {{{0xc7aa581d18f9b62d}},15,"F-H0-8897",911,6},
  {{{0xc7aa581d18f9b62d}},15,"F-H0-8898",542,2},
  {{{0x166db058bb1e8307}},5,"F-H0-8899",839,6},
  {{{0x1043920a1e8f299}},5,"F-H0-8900",459,2},
  {{{0x1043920a1e8f299}},5,"F-H0-8901",939,2},
  {{{0x1119be91465dd5f8}},4,"F-H0-8902",529,2},
  {{{0x4f436922052cbc69}},4,"F-H0-8903",457,2},
  {{{0x32c3841835a7087}},6,"F-H0-8904",950,8},
  {{{0x8f28195346621ba7}},6,"F-H0-8905",865,2},
  {{{0x509957e3634bc5e4}},9,"F-H0-8906",428,5},
  {{{0x21c0a31232728cb5}},9,"F-H0-8907",677,3},
  {{{0x85d407e5a70e2c92}},9,"F-H0-8908",640,6},
  {{{0xf6254ec268ad6e0f}},9,"F-H0-8909",945,6},
  {{{0x65b4b909bcdced4d}},6,"F-H0-8910",906,5},
  {{{0xc95c75d54d921f83}},6,"F-H0-8911",789,2},
  {{{0x40a1ad93cf46b0a6}},8,"F-H0-8912",469,11},
  {{{0xae9593d0f5df6f61}},4,"F-H0-8913",469,4},
  {{{0x30eb356f8ff2d9e3}},5,"F-H0-8914",802,4},
  {{{0xce1ebcdef7dc254f}},5,"F-H0-8915",460,2},
  {{{0xce1ebcdef7dc254f}},5,"F-H0-8916",530,2},
  {{{0x6f8e62751d30a65e}},18,"F-H0-8917",827,10},
  {{{0xac02e478f8457852}},11,"F-H0-8918",506,10},
  {{{0x9eaf7316bb61792b}},5,"F-H0-8919",911,4},
  {{{0x9eaf7316bb61792b}},5,"F-H0-8920",947,2},
  {{{0xe6d5881c1f98805f}},7,"F-H0-8921",985,5},
  {{{0xe6d5881c1f98805f}},7,"F-H0-8922",912,3},
  {{{0xe6d5881c1f98805f}},7,"F-H0-8923",911,3},
  {{{0xb850bc1750a2e072}},5,"F-H0-8924",542,5},
  {{{0xb16933924f311322}},5,"F-H0-8925",950,5},
  {{{0x47eb8176e9f311cf}},15,"F-H0-8926",950,9},
  {{{0x918791825070e81b}},12,"F-H0-8927",433,12},
  {{{0x9d48528e2bf6419b}},10,"F-H0-8928",936,6},
  {{{0x3cb4000bc9a9b606}},10,"F-H0-8929",459,3},
  {{{0xac94a9531567a391}},10,"F-H0-8930",463,2},
  {{{0x27ae4bf78de1c835}},6,"F-H0-8931",764,5},
  {{{0x1f24be0478345f73}},6,"F-H0-8932",875,3},
  {{{0x27ae4bf78de1c835}},6,"F-H0-8933",678,2},
  {{{0xa7a2bc372f5de5a}},5,"F-H0-8934",839,5},
  {{{0xdfaff301da7382e6}},5,"F-H0-8935",943,4},
  {{{0x642ff90bbf357d71}},5,"F-H0-8936",839,6},
  {{{0x29baf5ab08f401cb}},7,"F-H0-8937",910,3},
  {{{0x29baf5ab08f401cb}},7,"F-H0-8938",947,3},
  {{{0x5f6fcb69b39c2b34}},9,"F-H0-8939",936,4},
  {{{0x149ca550189e87f0}},8,"F-H0-8940",876,4},
  {{{0x450a855137462ff4}},8,"F-H0-8941",946,2},
  {{{0x69e40a77403a9a63}},6,"F-H0-8942",421,4},
  {{{0x82bdb776ef55d34b}},6,"F-H0-8943",902,3},
  {{{0x82bdb776ef55d34b}},6,"F-H0-8944",690,2},
  {{{0x2bc19d20b81cacab}},6,"F-H0-8945",727,2},
  {{{0xcf5c43c3f8bd12ff}},9,"F-H0-8946",950,9},
  {{{0xbb163ac6ceda5db3}},6,"F-H0-8947",909,3},
  {{{0x80e49f021e32a058}},6,"F-H0-8948",863,2},
  {{{0xf4888baa92b3fe24}},6,"F-H0-8949",764,2},
  {{{0xbb163ac6ceda5db3}},6,"F-H0-8950",946,2},
  {{{0xbb163ac6ceda5db3}},6,"F-H0-8951",466,2},
  {{{0xda13cc2aa78d569}},6,"F-H0-8952",503,4},
  {{{0x5edad1ea174d2587}},6,"F-H0-8953",838,2},
  {{{0x5e2efba603b43f9a}},6,"F-H0-8954",579,2},
  {{{0x55b47687143b69fc}},3,"F-H0-8955",912,6},
  {{{0x77fdd8389070235d}},3,"F-H0-8956",493,2},
  {{{0x77fdd8389070235d}},3,"F-H0-8957",863,2},
  {{{0xd55ce05185a493c6}},8,"F-H0-8958",943,3},
  {{{0x3d332c10e271b586}},8,"F-H0-8959",875,2},
  {{{0xd55ce05185a493c6}},8,"F-H0-8960",949,2},
  {{{0xdce376a1af114acf}},11,"F-H0-8961",507,11},
  {{{0x81d2b3f8df57dd14}},8,"F-H0-8962",418,3},
  {{{0x5938df28ada4410b}},8,"F-H0-8963",911,2},
  {{{0x971563031e8dac35}},10,"F-H0-8964",945,10},
  {{{0x971563031e8dac35}},10,"F-H0-8965",908,2},
  {{{0x438b7a8bc4aa90e0}},10,"F-H0-8966",866,5},
  {{{0xac195696331446f5}},16,"F-H0-8967",985,11},
  {{{0x995d9e6562e7b218}},7,"F-H0-8968",913,8},
  {{{0x55463f4035a990b5}},13,"F-H0-8969",840,7},
  {{{0x26a5f4990bd8b77d}},7,"F-H0-8970",578,3},
  {{{0x26a5f4990bd8b77d}},7,"F-H0-8971",428,2},
  {{{0x752bea4343c878b1}},7,"F-H0-8972",504,7},
  {{{0x752bea4343c878b1}},7,"F-H0-8973",466,4},
  {{{0x454d209b3a0660df}},16,"F-H0-8974",876,8},
  {{{0xa06d13c4a1f16a27}},6,"F-H0-8975",948,8},
  {{{0xd321bbdbfac1e73d}},7,"F-H0-8976",913,6},
  {{{0x9638561e9932d70e}},7,"F-H0-8977",935,6},
  {{{0x26eefd19ac9c4f5e}},2,"F-H0-8978",456,4},
  {{{0xe30e3ba4de903cad}},2,"F-H0-8979",506,2},
  {{{0xfdfd2c342d00ebb2}},2,"F-H0-8980",419,2},
  {{{0x3262ceea56d1e374}},3,"F-H0-8981",455,2},
  {{{0x70fbbb79104f566b}},9,"F-H0-8982",418,2},
  {{{0xce01e96e6ba1543b}},11,"F-H0-8983",420,11},
  {{{0x1d5d733b64995788}},6,"F-H0-8984",678,4},
  {{{0xc40cb2af56e27f30}},6,"F-H0-8985",529,3},
  {{{0xc40cb2af56e27f30}},6,"F-H0-8986",543,2},
  {{{0xbbab0b693d5a73b2}},7,"F-H0-8987",466,11},
  {{{0x233d12be3c5d6c01}},6,"F-H0-8988",530,2},
  {{{0x6cccd0c62335ffdc}},6,"F-H0-8989",459,2},
  {{{0x9883eccbb98b715b}},8,"F-H0-8990",459,11},
  {{{0x9002369cc3e62312}},7,"F-H0-8991",503,6},
  {{{0x9002369cc3e62312}},7,"F-H0-8992",542,4},
  {{{0xd1eeb82d33d923b6}},6,"F-H0-8993",751,3},
  {{{0x9e551c8395e443db}},6,"F-H0-8994",910,2},
  {{{0x856742a05de8753d}},2,"F-H0-8995",949,3},
  {{{0x1442ffbe256b3273}},2,"F-H0-8996",418,2},
  {{{0x856742a05de8753d}},2,"F-H0-8997",912,2},
  {{{0x2d874eee388fcc0b}},11,"F-H0-8998",911,4},
  {{{0x2d874eee388fcc0b}},11,"F-H0-8999",863,4},
  {{{0x1eb561180c968b41}},2,"F-H0-9000",875,3},
  {{{0xc1531faa8fa247e4}},2,"F-H0-9001",505,2},
  {{{0xc1531faa8fa247e4}},2,"F-H0-9002",493,2},
  {{{0xa8f470dbdd29f8c8}},9,"F-H0-9003",974,10},
  {{{0xdc3e4f4bd47af55d}},7,"F-H0-9004",911,4},
  {{{0x628473f7941bf2f2}},7,"F-H0-9005",494,3},
  {{{0xdc3e4f4bd47af55d}},7,"F-H0-9006",912,2},
  {{{0x8c3d94e7c589ea34}},3,"F-H0-9007",456,5},
  {{{0x8c3d94e7c589ea34}},3,"F-H0-9008",455,3},
  {{{0x3aedc6cb07ffe580}},3,"F-H0-9009",468,9},
  {{{0xd5e020d6c8c143d6}},6,"F-H0-9010",939,2},
  {{{0xd5e020d6c8c143d6}},6,"F-H0-9011",940,2},
  {{{0x8129b9dd7fb81b12}},6,"F-H0-9012",727,2},
  {{{0xcc6f26f932c6d494}},6,"F-H0-9013",826,2},
  {{{0xf61bbdf117ff6c8a}},5,"F-H0-9014",839,3},
  {{{0xb2ee4cc9f8a40c28}},5,"F-H0-9015",603,2},
  {{{0xb2ee4cc9f8a40c28}},5,"F-H0-9016",458,2},
  {{{0x5181109ae74299d9}},18,"F-H0-9017",949,4},
  {{{0x9db1abc856946c25}},19,"F-H0-9018",946,2},
  {{{0xdca086610a219729}},19,"F-H0-9019",909,2},
  {{{0x7024d2113e9e2a12}},3,"F-H0-9020",468,5},
  {{{0x7024d2113e9e2a12}},3,"F-H0-9021",469,4},
  {{{0xb128d0dd0677034b}},12,"F-H0-9022",828,6},
  {{{0x7b456e34b7dc3896}},12,"F-H0-9023",418,4},
  {{{0x3163d08029de5fd1}},14,"F-H0-9024",977,3},
  {{{0x43c14690bec45a95}},14,"F-H0-9025",421,2},
  {{{0x227f98ae0a2a368f}},5,"F-H0-9026",939,4},
  {{{0xa4244c39287cd8dd}},5,"F-H0-9027",603,3},
  {{{0x2c0aceced7623e9a}},11,"F-H0-9028",949,11},
  {{{0x371bd2231b5b09ee}},8,"F-H0-9029",470,3},
  {{{0x76da4841e9b457e4}},5,"F-H0-9030",865,8},
  {{{0x5728ec55b898255a}},5,"F-H0-9031",902,2},
  {{{0x3b399ed5f4ba5098}},6,"F-H0-9032",906,5},
  {{{0x1e4e4eae2f147c59}},9,"F-H0-9033",433,6},
  {{{0x812dbe8d78fc3dd8}},11,"F-H0-9034",910,8},
  {{{0x6d58caf68ac61832}},13,"F-H0-9035",839,3},
  {{{0x6d58caf68ac61832}},13,"F-H0-9036",424,2},
  {{{0xaeff76326f077aa3}},21,"F-H0-9037",507,11},
  {{{0xb8e4c9bfbd6666bd}},13,"F-H0-9038",801,5},
  {{{0xb8e4c9bfbd6666bd}},13,"F-H0-9039",837,3},
  {{{0xfc4a5fc6a75af205}},8,"F-H0-9040",530,11},
  {{{0xeea619424197289d}},10,"F-H0-9041",940,8},
  {{{0x295a09cd7b894591}},10,"F-H0-9042",837,2},
  {{{0xfeafa80682e61c8c}},4,"F-H0-9043",905,3},
  {{{0x339b63baeac8ca23}},4,"F-H0-9044",900,3},
  {{{0xfeafa80682e61c8c}},4,"F-H0-9045",947,2},
  {{{0x89b4eb7893d41dd6}},6,"F-H0-9046",902,3},
  {{{0x530e527c35672d1d}},7,"F-H0-9047",432,6},
  {{{0xf8cff0e92a8683b8}},24,"F-H0-9048",945,9},
  {{{0x2ba3a1cf2dac5d9a}},9,"F-H0-9049",937,3},
  {{{0x6ef812302b2a4058}},6,"F-H0-9050",865,3},
  {{{0xec94ec8f24c625e8}},5,"F-H0-9051",505,3},
  {{{0xec94ec8f24c625e8}},5,"F-H0-9052",420,2},
  {{{0xc4ed6ea3d7d656de}},5,"F-H0-9053",862,2},
  {{{0xee78b73567a8cd6b}},12,"F-H0-9054",641,5},
  {{{0xee3f448ef725b959}},12,"F-H0-9055",419,3},
  {{{0x79bfccc3e5a96c6e}},8,"F-H0-9056",838,4},
  {{{0x89011ebe5e3b3fed}},8,"F-H0-9057",941,4},
  {{{0xcfb2b541f52530b8}},4,"F-H0-9058",421,2},
  {{{0x33428931798eae04}},4,"F-H0-9059",421,2},
  {{{0x3bd42a694e03715a}},10,"F-H0-9060",825,3},
  {{{0xf12a7949c1fb8f28}},10,"F-H0-9061",463,2},
  {{{0xc4c7d0e8159a7ca7}},10,"F-H0-9062",902,2},
  {{{0xf3dc96b3054a1d3}},13,"F-H0-9063",942,7},
  {{{0xda973d10d8cf185d}},6,"F-H0-9064",456,3},
  {{{0x52200fe680acba1b}},8,"F-H0-9065",825,3},
  {{{0x5cba4680d644927a}},8,"F-H0-9066",678,3},
  {{{0x5cba4680d644927a}},8,"F-H0-9067",715,2},
  {{{0xf22e39a101f666ab}},10,"F-H0-9068",420,2},
  {{{0xf81a0f8b7c684073}},10,"F-H0-9069",394,2},
  {{{0x874b25bc44becc95}},19,"F-H0-9070",542,2},
  {{{0x884fccb813d15269}},12,"F-H0-9071",421,10},
  {{{0xe8aadef2c9f47a19}},11,"F-H0-9072",911,4},
  {{{0xe8aadef2c9f47a19}},11,"F-H0-9073",907,4},
  {{{0x7ed7e4c922b12375}},4,"F-H0-9074",455,2},
  {{{0x27847204425ecca6}},4,"F-H0-9075",940,2},
  {{{0x5b8f40e472254980}},4,"F-H0-9076",862,4},
  {{{0x5b8f40e472254980}},4,"F-H0-9077",431,2},
  {{{0x5b8f40e472254980}},4,"F-H0-9078",419,2},
  {{{0x3e885df1e86a815e}},5,"F-H0-9079",456,3},
  {{{0x8d84903f4ec7a454}},7,"F-H0-9080",825,8},
  {{{0xe64114bfe934b5e7}},6,"F-H0-9081",421,7},
  {{{0xb4152960a4c5af85}},6,"F-H0-9082",432,2},
  {{{0xccc5c3c425830027}},11,"F-H0-9083",457,9},
  {{{0x74af0a1d26ef7002}},20,"F-H0-9084",580,9},
  {{{0x4f7097aeb187c231}},7,"F-H0-9085",457,3},
  {{{0x3ff0bbfceb9f15fb}},7,"F-H0-9086",912,10},
  {{{0x38fee0a0e01c3714}},5,"F-H0-9087",825,4},
  {{{0xcbaff3b49e3319d7}},5,"F-H0-9088",910,4},
  {{{0x808613556069adcd}},5,"F-H0-9089",603,2},
  {{{0x5090005712b95f1b}},11,"F-H0-9090",578,9},
  {{{0x17df06e90e8168a9}},11,"F-H0-9091",691,6},
  {{{0xfed121f10af001e4}},11,"F-H0-9092",462,5},
  {{{0x7cdcf3b643dcd7dc}},4,"F-H0-9093",947,2},
  {{{0x7cdcf3b643dcd7dc}},4,"F-H0-9094",909,2},
  {{{0xdd2b48cef3b60da4}},17,"F-H0-9095",862,5},
  {{{0xd91323bdf6b62332}},17,"F-H0-9096",936,3},
  {{{0xfec71a17a65b15b9}},17,"F-H0-9097",913,2},
  {{{0x7de76cbc8ebdb0b4}},8,"F-H0-9098",937,9},
  {{{0xef5d8a5166a9adba}},4,"F-H0-9099",900,2},
  {{{0x2cfd5c767bef9712}},11,"F-H0-9100",986,10},
  {{{0x7ae49261e433136b}},10,"F-H0-9101",765,4},
  {{{0x81bddc2843538c41}},4,"F-H0-9102",420,5},
  {{{0x217404d83eba35a4}},4,"F-H0-9103",875,2},
  {{{0x6ee6226efe4d6183}},4,"F-H0-9104",876,2},
  {{{0x48ed030d7748fb4c}},4,"F-H0-9105",937,2},
  {{{0x6d1b3f333e438348}},4,"F-H0-9106",913,2},
  {{{0x6ee6226efe4d6183}},4,"F-H0-9107",506,2},
  {{{0xd61995786d152d36}},6,"F-H0-9108",911,4},
  {{{0xd61995786d152d36}},6,"F-H0-9109",529,3},
  {{{0x19f4ac21c9eeaa67}},6,"F-H0-9110",529,2},
  {{{0x8c2e7a60707abde}},11,"F-H0-9111",904,2},
  {{{0x14bbb2d19859a71a}},11,"F-H0-9112",431,10},
  {{{0xcc129fe40abaf2f1}},13,"F-H0-9113",691,9},
  {{{0x197cef4b9b2c8c3c}},4,"F-H0-9114",862,6},
  {{{0x197cef4b9b2c8c3c}},4,"F-H0-9115",529,2},
  {{{0x5f19e8d23f50f202}},10,"F-H0-9116",529,11},
  {{{0x40c918fca73c7df1}},9,"F-H0-9117",678,3},
  {{{0x40c918fca73c7df1}},9,"F-H0-9118",898,3},
  {{{0x40c918fca73c7df1}},9,"F-H0-9119",715,2},
  {{{0x7e3c12e5a063e7a7}},13,"F-H0-9120",984,7},
  {{{0x7e3c12e5a063e7a7}},13,"F-H0-9121",910,3},
  {{{0xcb4b4cebc3aaab1e}},7,"F-H0-9122",913,11},
  {{{0x3c14fcc2856ce751}},6,"F-H0-9123",469,2},
  {{{0xe8f2db2ac19c44d8}},11,"F-H0-9124",943,2},
  {{{0x3019a46223b75d1a}},14,"F-H0-9125",380,8},
  {{{0xe3941f96b7f6f0d2}},8,"F-H0-9126",874,7},
  {{{0x884ca20a4c5b2247}},10,"F-H0-9127",677,2},
  {{{0xca84a580991a1b33}},14,"F-H0-9128",727,10},
  {{{0xe8e64b4ae705be5e}},10,"F-H0-9129",654,7},
  {{{0xf216b1411c76a3ff}},10,"F-H0-9130",902,3},
  {{{0xe9b9f43e1c1c7d7d}},3,"F-H0-9131",912,2},
  {{{0x41b10ff3cb74d60c}},8,"F-H0-9132",503,9},
  {{{0x6ca75b654b25ab0d}},7,"F-H0-9133",653,3},
  {{{0x6ca75b654b25ab0d}},7,"F-H0-9134",617,3},
  {{{0x6ca75b654b25ab0d}},7,"F-H0-9135",466,2},
  {{{0xf3920e4d21763923}},3,"F-H0-9136",467,5},
  {{{0xf3920e4d21763923}},3,"F-H0-9137",949,2},
  {{{0x4f7d8f1978b80196}},8,"F-H0-9138",506,2},
  {{{0x2b715131e340f122}},13,"F-H0-9139",500,2},
  {{{0x81288d1759291bfe}},5,"F-H0-9140",861,3},
  {{{0xaeb72d533f2c2c00}},10,"F-H0-9141",936,7},
  {{{0xcdc1ea85d828f97e}},10,"F-H0-9142",979,6},
  {{{0xbe8c751247991efb}},7,"F-H0-9143",947,5},
  {{{0xd154aa6b80346e86}},8,"F-H0-9144",906,6},
  {{{0x3df37652a4dcf8f}},8,"F-H0-9145",531,2},
  {{{0xc3e63df6f4984c34}},23,"F-H0-9146",907,7},
  {{{0xc7d15b96b9d60897}},19,"F-H0-9147",949,9},
  {{{0x8fdf519cb69bcfa8}},4,"F-H0-9148",468,3},
  {{{0xd120ecf9e17500bd}},4,"F-H0-9149",466,2},
  {{{0xfa02674edc987064}},21,"F-H0-9150",825,7},
  {{{0x1ed7d54c5f66f65e}},9,"F-H0-9151",942,7},
  {{{0x9e8adb7dae0ac124}},10,"F-H0-9152",430,6},
  {{{0x9e8adb7dae0ac124}},10,"F-H0-9153",431,3},
  {{{0x9e8adb7dae0ac124}},10,"F-H0-9154",432,2},
  {{{0x8ee099fcdd9c71fc}},3,"F-H0-9155",950,3},
  {{{0x621004445616d3c4}},3,"F-H0-9156",875,2},
  {{{0x621004445616d3c4}},3,"F-H0-9157",469,2},
  {{{0x3a375971057eb192}},14,"F-H0-9158",914,8},
  {{{0x97b215c1ffad6fe1}},14,"F-H0-9159",541,2},
  {{{0xd512a067cef44dfc}},9,"F-H0-9160",941,7},
  {{{0x16c277f698e53730}},4,"F-H0-9161",986,4},
  {{{0x9987623fec98ccf9}},4,"F-H0-9162",531,2},
  {{{0x9987623fec98ccf9}},4,"F-H0-9163",912,2},
  {{{0x88944120d0bb4a5c}},23,"F-H0-9164",544,11},
  {{{0x521d8e9e203a7679}},6,"F-H0-9165",936,6},
  {{{0x521d8e9e203a7679}},6,"F-H0-9166",865,2},
  {{{0x563c3a055c3f185e}},7,"F-H0-9167",603,3},
  {{{0x563c3a055c3f185e}},7,"F-H0-9168",690,2},
  {{{0x70e29f017eb93d86}},7,"F-H0-9169",874,2},
  {{{0xe961d440e6192051}},12,"F-H0-9170",911,11},
  {{{0xd91eba9c3f5a1df3}},13,"F-H0-9171",454,4},
  {{{0xd91eba9c3f5a1df3}},13,"F-H0-9172",492,2},
  {{{0xd51812ac54048a0c}},13,"F-H0-9173",877,2},
  {{{0xf66039f6e29ebebb}},19,"F-H0-9174",543,11},
  {{{0xe93ee457921be531}},11,"F-H0-9175",465,9},
  {{{0xeccf72460957d656}},11,"F-H0-9176",946,2},
  {{{0x56cf04c522492c68}},8,"F-H0-9177",465,9},
  {{{0x418c617ad2ce3617}},8,"F-H0-9178",911,2},
  {{{0x628e52774ec8d506}},9,"F-H0-9179",543,4},
  {{{0xde710ce748a94484}},17,"F-H0-9180",825,8},
  {{{0xde710ce748a94484}},17,"F-H0-9181",839,2},
  {{{0x8a120938c3906b3c}},8,"F-H0-9182",949,9},
  {{{0xcfd52e4daf89c7aa}},11,"F-H0-9183",544,9},
  {{{0x5cce5db9cc22976e}},9,"F-H0-9184",429,7},
  {{{0x31b9f8567bcf38d7}},8,"F-H0-9185",791,3},
  {{{0x959f78610500c1c5}},8,"F-H0-9186",617,2},
  {{{0x31b9f8567bcf38d7}},8,"F-H0-9187",974,2},
  {{{0xe4f5150e451348a5}},5,"F-H0-9188",863,4},
  {{{0xcebc80e32ffe8f9f}},5,"F-H0-9189",764,3},
  {{{0xe4f5150e451348a5}},5,"F-H0-9190",862,2},
  {{{0x429488c39cf2ed92}},7,"F-H0-9191",432,4},
  {{{0x429488c39cf2ed92}},7,"F-H0-9192",580,2},
  {{{0x429488c39cf2ed92}},7,"F-H0-9193",875,2},
  {{{0xbabe08bc3dc77479}},2,"F-H0-9194",949,2},
  {{{0xd1129b5f2a5c7bb}},2,"F-H0-9195",876,2},
  {{{0xabf1c0f6429bcea7}},9,"F-H0-9196",911,2},
  {{{0xabf1c0f6429bcea7}},9,"F-H0-9197",939,2},
  {{{0xabf1c0f6429bcea7}},9,"F-H0-9198",943,2},
  {{{0x849ccf3c67ec50de}},9,"F-H0-9199",939,2},
  {{{0x4a39cac58cbb6b41}},10,"F-H0-9200",655,8},
  {{{0x8f394e268f20d740}},13,"F-H0-9201",940,8},
  {{{0xc5b5c2d12f9d3484}},3,"F-H0-9202",936,5},
  {{{0x80608f48579aec87}},13,"F-H0-9203",906,2},
  {{{0xad01b2f57507bd2}},13,"F-H0-9204",947,2},
  {{{0xf9382aeed9b8551c}},7,"F-H0-9205",529,5},
  {{{0xa23cec29fe1ebd0d}},7,"F-H0-9206",427,3},
  {{{0xbf8f9fe42d065bd0}},9,"F-H0-9207",495,10},
  {{{0x710bdd73bee773db}},4,"F-H0-9208",506,5},
  {{{0x710bdd73bee773db}},4,"F-H0-9209",457,2},
  {{{0x113387f650bccd97}},5,"F-H0-9210",942,5},
  {{{0x11599ac91000f139}},5,"F-H0-9211",425,2},
  {{{0x149c07b1e54ab204}},7,"F-H0-9212",429,6},
  {{{0x149c07b1e54ab204}},7,"F-H0-9213",428,5},
  {{{0x8fe9f9188f1e1559}},22,"F-H0-9214",506,9},
  {{{0xbfd0156c73b09833}},5,"F-H0-9215",458,4},
  {{{0xb653193df3e5a4d6}},5,"F-H0-9216",467,4},
  {{{0x1d6d928cfbf2cf5}},5,"F-H0-9217",505,5},
  {{{0x1d6d928cfbf2cf5}},5,"F-H0-9218",838,3},
  {{{0xc53dc885e668615f}},5,"F-H0-9219",936,2},
  {{{0x46a8f59611e7c721}},6,"F-H0-9220",987,10},
  {{{0x58296ab234217834}},5,"F-H0-9221",677,5},
  {{{0x6ce50c0ad39bdc7a}},5,"F-H0-9222",947,2},
  {{{0x570f222e24a0face}},10,"F-H0-9223",876,6},
  {{{0x5d03835f3158f2fe}},10,"F-H0-9224",950,4},
  {{{0xe23122abc6c5078a}},7,"F-H0-9225",902,5},
  {{{0x25b7e645cb837de}},7,"F-H0-9226",902,4},
  {{{0x2922426a9e38cf99}},11,"F-H0-9227",714,4},
  {{{0x472d794f77247d7d}},11,"F-H0-9228",825,3},
  {{{0x5b1ea96f679b552}},11,"F-H0-9229",825,2},
  {{{0x22861142d4adef87}},5,"F-H0-9230",543,4},
  {{{0x22861142d4adef87}},5,"F-H0-9231",427,3},
  {{{0xd6bfb56f287e0ea8}},22,"F-H0-9232",943,9},
  {{{0x69e33ba64a594c6d}},4,"F-H0-9233",506,3},
  {{{0x69e33ba64a594c6d}},4,"F-H0-9234",469,2},
  {{{0x69e33ba64a594c6d}},4,"F-H0-9235",468,2},
  {{{0x3bac823196a1df88}},14,"F-H0-9236",532,10},
  {{{0xa5b63c69422636fe}},8,"F-H0-9237",465,11},
  {{{0x4b49e65bd8ae0b99}},8,"F-H0-9238",431,5},
  {{{0x4b49e65bd8ae0b99}},8,"F-H0-9239",579,5},
  {{{0x911fe5cd1aff3fdf}},7,"F-H0-9240",678,4},
  {{{0x6c303fad25911f0c}},7,"F-H0-9241",939,2},
  {{{0x111dd79cf8c19074}},7,"F-H0-9242",393,5},
  {{{0x1788f11362956941}},7,"F-H0-9243",913,3},
  {{{0x64be66a97178bc0c}},20,"F-H0-9244",877,10},
  {{{0xf440b5efd11159e}},7,"F-H0-9245",456,6},
  {{{0xf440b5efd11159e}},7,"F-H0-9246",492,3},
  {{{0x9ccd8b9fadd3d7dc}},6,"F-H0-9247",421,4},
  {{{0x9ccd8b9fadd3d7dc}},6,"F-H0-9248",456,3},
  {{{0x44324a19eb6cc052}},9,"F-H0-9249",939,5},
  {{{0x44324a19eb6cc052}},9,"F-H0-9250",603,3},
  {{{0x5866e1048f7bb619}},9,"F-H0-9251",690,2},
  {{{0xa196d72a57d84c23}},3,"F-H0-9252",912,7},
  {{{0xf4aed0999b17043a}},10,"F-H0-9253",420,4},
  {{{0xf23179ae2244dca0}},10,"F-H0-9254",940,3},
  {{{0x8e102acb058b6390}},8,"F-H0-9255",690,7},
  {{{0xd5143c75c08f71af}},5,"F-H0-9256",458,3},
  {{{0xe89382d4bb92ca81}},5,"F-H0-9257",863,3},
  {{{0x92d68363929ffd60}},5,"F-H0-9258",653,2},
  {{{0x1d6a1a59deb86170}},12,"F-H0-9259",466,9},
  {{{0x5fce74dee7778c12}},4,"F-H0-9260",838,3},
  {{{0x1fc967dbfd38dc37}},10,"F-H0-9261",469,7},
  {{{0x9ed58230beb07fb5}},10,"F-H0-9262",913,2},
  {{{0xad57c6e5244827a4}},5,"F-H0-9263",936,4},
  {{{0xa8365a5f92feb764}},5,"F-H0-9264",506,2},
  {{{0x3c3563b0201d5160}},5,"F-H0-9265",825,2},
  {{{0xd3da4041845e2578}},5,"F-H0-9266",947,2},
  {{{0x3c3563b0201d5160}},5,"F-H0-9267",419,2},
  {{{0x138d287dfc6f9624}},6,"F-H0-9268",432,4},
  {{{0xcdc2d6ed213594f0}},12,"F-H0-9269",543,4},
  {{{0x77421ccce950d6d6}},9,"F-H0-9270",873,8},
  {{{0x20f38932c7d950a7}},7,"F-H0-9271",950,3},
  {{{0x20f38932c7d950a7}},7,"F-H0-9272",837,3},
  {{{0x20f38932c7d950a7}},7,"F-H0-9273",947,2},
  {{{0x2629e6c5bbc0e615}},7,"F-H0-9274",938,3},
  {{{0xbccf96b09769def4}},6,"F-H0-9275",902,3},
  {{{0x5b5e9ed7a9802864}},6,"F-H0-9276",765,2},
  {{{0xe1ea8016d4f10936}},6,"F-H0-9277",944,2},
  {{{0xadfcf6f0ef9ab70}},7,"F-H0-9278",678,3},
  {{{0xadfcf6f0ef9ab70}},7,"F-H0-9279",466,2},
  {{{0xa6a9af588ec1e59a}},6,"F-H0-9280",910,2},
  {{{0x51d8f6595cf8cbec}},6,"F-H0-9281",765,2},
  {{{0xb329a23377dc0482}},11,"F-H0-9282",947,4},
  {{{0xc915fc4cd5be6239}},11,"F-H0-9283",948,2},
  {{{0xb17f2b010bf12d32}},10,"F-H0-9284",788,8},
  {{{0xd6ae64c1176a75ff}},8,"F-H0-9285",678,5},
  {{{0x64e6f895a3356ec0}},8,"F-H0-9286",903,2},
  {{{0xc5ac24c3fc828815}},12,"F-H0-9287",428,2},
  {{{0x39a0b8ad9f1924b3}},7,"F-H0-9288",911,2},
  {{{0x39a0b8ad9f1924b3}},7,"F-H0-9289",948,2},
  {{{0x39a0b8ad9f1924b3}},7,"F-H0-9290",947,2},
  {{{0xcb254063ce2d9216}},10,"F-H0-9291",462,5},
  {{{0xcb254063ce2d9216}},10,"F-H0-9292",568,2},
  {{{0xcb254063ce2d9216}},10,"F-H0-9293",543,2},
  {{{0x4ec708c01e35c4d0}},6,"F-H0-9294",691,3},
  {{{0x4ec708c01e35c4d0}},6,"F-H0-9295",470,2},
  {{{0x4ec708c01e35c4d0}},6,"F-H0-9296",690,2},
  {{{0xad944ff987518d5d}},10,"F-H0-9297",429,10},
  {{{0x478ecebc0ca094d3}},13,"F-H0-9298",544,9},
  {{{0x3151829a9faba344}},5,"F-H0-9299",419,4},
  {{{0x3151829a9faba344}},5,"F-H0-9300",428,2},
  {{{0x7f14dfea2b648312}},5,"F-H0-9301",421,2},
  {{{0x1b12be1405b0d54f}},6,"F-H0-9302",503,3},
  {{{0x1b12be1405b0d54f}},6,"F-H0-9303",542,2},
  {{{0x1b12be1405b0d54f}},6,"F-H0-9304",504,2},
  {{{0xb3e55df9cedf84dd}},8,"F-H0-9305",864,3},
  {{{0xdd1640a84fa2a4f7}},10,"F-H0-9306",417,8},
  {{{0x39e936b9dbce9b36}},4,"F-H0-9307",838,4},
  {{{0x39e936b9dbce9b36}},4,"F-H0-9308",468,2},
  {{{0x39e936b9dbce9b36}},4,"F-H0-9309",906,2},
  {{{0x906d01dff9420aa2}},4,"F-H0-9310",839,3},
  {{{0x7f5494c9732b00ad}},8,"F-H0-9311",684,2},
  {{{0x547b39e9f666a1b1}},8,"F-H0-9312",505,2},
  {{{0x502b9c7cf2e5a76e}},5,"F-H0-9313",458,6},
  {{{0x502b9c7cf2e5a76e}},5,"F-H0-9314",900,2},
  {{{0x3be83d947b896339}},12,"F-H0-9315",909,6},
  {{{0xa38d1e5cfe535115}},14,"F-H0-9316",950,10},
  {{{0x5d4b5a1841c2fdc3}},5,"F-H0-9317",938,3},
  {{{0xf3d4c4609a92bb7d}},5,"F-H0-9318",985,2},
  {{{0x26cea515ba88ef77}},6,"F-H0-9319",941,4},
  {{{0x26cea515ba88ef77}},6,"F-H0-9320",425,3},
  {{{0x9497e0c0c4e59d78}},7,"F-H0-9321",839,4},
  {{{0x5487f229b564aa1f}},7,"F-H0-9322",825,3},
  {{{0xc06967806e44b7fa}},7,"F-H0-9323",691,2},
  {{{0x34b07dde94c7229a}},10,"F-H0-9324",417,3},
  {{{0x699f79d29fae566b}},10,"F-H0-9325",577,2},
  {{{0x34cb008c9f3909a6}},10,"F-H0-9326",943,2},
  {{{0x50d2047d44cad6ca}},9,"F-H0-9327",950,4},
  {{{0xc5a1b80fe3427b69}},9,"F-H0-9328",947,2},
  {{{0x50d2047d44cad6ca}},9,"F-H0-9329",873,2},
  {{{0xc5a1b80fe3427b69}},9,"F-H0-9330",764,2},
  {{{0xe44f74b1e62319f6}},7,"F-H0-9331",429,5},
  {{{0x39e28ac07fb9e433}},7,"F-H0-9332",912,4},
  {{{0x97f71d6ae854e51b}},12,"F-H0-9333",948,10},
  {{{0x785dbf30d690d624}},6,"F-H0-9334",430,2},
  {{{0x923e3a8b553036b0}},6,"F-H0-9335",567,2},
  {{{0xc6c092a0602ce949}},7,"F-H0-9336",801,6},
  {{{0xc6c092a0602ce949}},7,"F-H0-9337",876,2},
  {{{0xc6c092a0602ce949}},7,"F-H0-9338",837,2},
  {{{0x4460de6c29c193ed}},15,"F-H0-9339",531,6},
  {{{0x4460de6c29c193ed}},15,"F-H0-9340",567,3},
  {{{0xd14866402e3b9101}},11,"F-H0-9341",505,5},
  {{{0xd14866402e3b9101}},11,"F-H0-9342",503,2},
  {{{0x80df0518557c2fc0}},13,"F-H0-9343",939,10},
  {{{0xb5fad9d06bbd2d6d}},9,"F-H0-9344",876,4},
  {{{0xb5fad9d06bbd2d6d}},9,"F-H0-9345",801,4},
  {{{0xb829c98d6d6bd877}},4,"F-H0-9346",905,4},
  {{{0x3a297a385e833bd6}},7,"F-H0-9347",653,7},
  {{{0xe11aa333f87e4260}},6,"F-H0-9348",946,4},
  {{{0xe11aa333f87e4260}},6,"F-H0-9349",942,2},
  {{{0x6614e4b03fa1d28}},7,"F-H0-9350",902,10},
  {{{0x542ed982873ef291}},9,"F-H0-9351",690,6},
  {{{0xe2a914130eaf2b97}},9,"F-H0-9352",715,3},
  {{{0x52ca9dae27c72afa}},8,"F-H0-9353",985,10},
  {{{0xb0612f03e1cdcd67}},4,"F-H0-9354",419,3},
  {{{0xb4682dc76fa439e2}},4,"F-H0-9355",469,2},
  {{{0xa27b02874a9cbe85}},4,"F-H0-9356",912,6},
  {{{0xd326f378f3ea6589}},13,"F-H0-9357",949,9},
  {{{0x5abfc893d8279da4}},12,"F-H0-9358",431,11},
  {{{0x91e4e7d09486ba53}},6,"F-H0-9359",948,4},
  {{{0x91e4e7d09486ba53}},6,"F-H0-9360",908,3},
  {{{0x91e4e7d09486ba53}},6,"F-H0-9361",946,2},
  {{{0x36b483475c8a3a60}},18,"F-H0-9362",579,9},
  {{{0xdc88eb64dc8eed81}},5,"F-H0-9363",567,5},
  {{{0xf2b563cb1f548088}},5,"F-H0-9364",865,3},
  {{{0x4c3630dcf0a42420}},6,"F-H0-9365",418,8},
  {{{0x39e0458080a6569f}},10,"F-H0-9366",466,7},
  {{{0xb2395c98be54d0de}},10,"F-H0-9367",427,2},
  {{{0x856dfad4077bc10a}},11,"F-H0-9368",899,5},
  {{{0xf54f22286f13a0ae}},11,"F-H0-9369",863,3},
  {{{0x34fc631a0a8278e0}},9,"F-H0-9370",503,10},
  {{{0x888d2a6d2350e8db}},10,"F-H0-9371",429,5},
  {{{0x888d2a6d2350e8db}},10,"F-H0-9372",466,2},
  {{{0x53edb7f6e4feeafe}},8,"F-H0-9373",909,10},
  {{{0x982c978fd435116f}},7,"F-H0-9374",458,10},
  {{{0x2f74fa75007b1062}},3,"F-H0-9375",912,5},
  {{{0x586f05d122fa6727}},5,"F-H0-9376",901,3},
  {{{0x5fba34382d25ccad}},10,"F-H0-9377",941,5},
  {{{0x3765a5e11faa6b12}},10,"F-H0-9378",950,4},
  {{{0x616edad04ebd1393}},9,"F-H0-9379",950,6},
  {{{0x616edad04ebd1393}},9,"F-H0-9380",873,4},
  {{{0x7450a390dfa5b063}},7,"F-H0-9381",837,5},
  {{{0x7450a390dfa5b063}},7,"F-H0-9382",950,4},
  {{{0x370dba9eda19afa4}},4,"F-H0-9383",505,3},
  {{{0x370dba9eda19afa4}},4,"F-H0-9384",944,2},
  {{{0xd6c08baa8d5da118}},4,"F-H0-9385",430,2},
  {{{0xe7acb4756efe5233}},6,"F-H0-9386",911,5},
  {{{0x965ab53bb51b3996}},13,"F-H0-9387",839,6},
  {{{0x9ba136de4e20e952}},9,"F-H0-9388",901,10},
  {{{0xbd7658fbb7972a09}},13,"F-H0-9389",429,7},
  {{{0x54ebedd69abcb348}},13,"F-H0-9390",751,2},
  {{{0x485c141b17d0dbc4}},13,"F-H0-9391",765,2},
  {{{0x7ee803b53d58d3b}},5,"F-H0-9392",911,3},
  {{{0x7ee803b53d58d3b}},5,"F-H0-9393",506,3},
  {{{0x7ee803b53d58d3b}},5,"F-H0-9394",466,2},
  {{{0xa3cac4d27697b3a6}},13,"F-H0-9395",603,4},
  {{{0x6517aece82e3e67a}},11,"F-H0-9396",714,7},
  {{{0x8f46f2f46444a067}},11,"F-H0-9397",840,2},
  {{{0xbeea35b6ebeda618}},6,"F-H0-9398",908,5},
  {{{0x520bc2a5bef581e2}},8,"F-H0-9399",826,10},
  {{{0xd4731ca31b60cbd9}},14,"F-H0-9400",432,11},
  {{{0x3c071f0d6cba7f1a}},4,"F-H0-9401",466,3},
  {{{0xcde2972c736aca7f}},4,"F-H0-9402",431,2},
  {{{0x5f950f23eb85cba2}},4,"F-H0-9403",506,2},
  {{{0x92eb4c6fd6763066}},4,"F-H0-9404",913,2},
  {{{0xf621f434e037ffcf}},6,"F-H0-9405",495,5},
  {{{0x7e6bb0c329b16b9e}},10,"F-H0-9406",937,8},
  {{{0x5dafd0832be94a07}},10,"F-H0-9407",615,2},
  {{{0xe999ae112a758cb3}},16,"F-H0-9408",826,4},
  {{{0x1cdee984922b4a1a}},16,"F-H0-9409",910,3},
  {{{0x1cdee984922b4a1a}},16,"F-H0-9410",950,2},
  {{{0x9fde6f4b8cc6a29d}},4,"F-H0-9411",462,6},
  {{{0x2b2d25d38332465d}},4,"F-H0-9412",462,2},
  {{{0x97ea45042f07d609}},5,"F-H0-9413",949,5},
  {{{0x97ea45042f07d609}},5,"F-H0-9414",913,5},
  {{{0xc983d51b452afb02}},7,"F-H0-9415",494,7},
  {{{0x45cb4b00cc05aafc}},7,"F-H0-9416",948,2},
  {{{0xbbf7140326ac011}},6,"F-H0-9417",874,9},
  {{{0x7640d7619cb0b2ff}},8,"F-H0-9418",902,7},
  {{{0x77e7aa655a325088}},9,"F-H0-9419",714,7},
  {{{0x77e7aa655a325088}},9,"F-H0-9420",715,3},
  {{{0x20383365c9330552}},14,"F-H0-9421",751,5},
  {{{0x8631c50b283c715d}},14,"F-H0-9422",910,3},
  {{{0x20383365c9330552}},14,"F-H0-9423",826,2},
  {{{0xa0b1c4d8263c950b}},5,"F-H0-9424",460,4},
  {{{0xa0b1c4d8263c950b}},5,"F-H0-9425",863,2},
  {{{0xc35287d0797aeb9}},7,"F-H0-9426",914,3},
  {{{0xc35287d0797aeb9}},7,"F-H0-9427",690,3},
  {{{0xc35287d0797aeb9}},7,"F-H0-9428",423,2},
  {{{0xee11d758abec5be1}},9,"F-H0-9429",905,8},
  {{{0xeb3c4e3db8c4767d}},7,"F-H0-9430",751,3},
  {{{0xeb3c4e3db8c4767d}},7,"F-H0-9431",529,2},
  {{{0x6c0e6070f4e6f98d}},10,"F-H0-9432",418,8},
  {{{0xbc5905c3c3a2e4d7}},10,"F-H0-9433",862,2},
  {{{0x329b868ecb89336c}},7,"F-H0-9434",530,8},
  {{{0xc144fc6608c47ad2}},7,"F-H0-9435",421,2},
  {{{0xc5dd08150f1491da}},5,"F-H0-9436",543,5},
  {{{0xaeb1e38ebf728612}},5,"F-H0-9437",431,5},
  {{{0x94babb7b5bcaf99}},14,"F-H0-9438",950,10},
  {{{0xadcb0a85e543d581}},3,"F-H0-9439",685,2},
  {{{0x1d2988ff64ebf94b}},3,"F-H0-9440",646,2},
  {{{0x425a49b103e87f65}},5,"F-H0-9441",458,4},
  {{{0x425a49b103e87f65}},5,"F-H0-9442",529,3},
  {{{0x5d3745505b9aa1c2}},5,"F-H0-9443",458,2},
  {{{0x77a8ece7a3799871}},24,"F-H0-9444",581,9},
  {{{0x8a791287849a6760}},12,"F-H0-9445",984,10},
  {{{0x633306fa75bea64}},3,"F-H0-9446",911,2},
  {{{0xf1c7e8bcbceed1bc}},9,"F-H0-9447",691,5},
  {{{0xb51685a3d2ae832e}},9,"F-H0-9448",873,2},
  {{{0x796566682b0f31b1}},13,"F-H0-9449",420,9},
  {{{0x52869d5846c8190b}},8,"F-H0-9450",497,5},
  {{{0x557d0c89340f63f5}},8,"F-H0-9451",690,3},
  {{{0x1e03aa521d04310e}},15,"F-H0-9452",983,6},
  {{{0xe6a0dce4b6ba616}},8,"F-H0-9453",715,2},
  {{{0x952f43618a440df2}},8,"F-H0-9454",944,8},
  {{{0xee51ed8b39c822c0}},4,"F-H0-9455",429,3},
  {{{0xee51ed8b39c822c0}},4,"F-H0-9456",455,2},
  {{{0x7ff720b753f81a44}},8,"F-H0-9457",949,10},
  {{{0x5b7a769437ea8d68}},8,"F-H0-9458",943,4},
  {{{0x5b7a769437ea8d68}},8,"F-H0-9459",543,2},
  {{{0xfb6e01c34dfe2793}},9,"F-H0-9460",418,10},
  {{{0xc907a7530cfe2beb}},12,"F-H0-9461",493,8},
  {{{0x212853e6e4c9c29f}},5,"F-H0-9462",899,3},
  {{{0x45c8d70b65189059}},5,"F-H0-9463",677,3},
  {{{0x999ec98c1b02cf9d}},5,"F-H0-9464",942,2},
  {{{0xfce8323d7281eab1}},12,"F-H0-9465",941,8},
  {{{0xfce8323d7281eab1}},12,"F-H0-9466",425,2},
  {{{0x9c3fc4e37668c6c4}},8,"F-H0-9467",567,7},
  {{{0x542e844571efa62c}},8,"F-H0-9468",902,2},
  {{{0xa8895f9d6e21a1f8}},9,"F-H0-9469",678,5},
  {{{0xd3fc6b21ce8dc611}},9,"F-H0-9470",825,2},
  {{{0xa8895f9d6e21a1f8}},9,"F-H0-9471",677,2},
  {{{0xe2df54d30ad3b7ce}},12,"F-H0-9472",948,6},
  {{{0x30c25109e97e6fdd}},5,"F-H0-9473",425,6},
  {{{0x8227a3d2a40b8e6a}},5,"F-H0-9474",640,3},
  {{{0xbc784c028bb6daba}},10,"F-H0-9475",432,3},
  {{{0x1fcbe36eba203d2d}},10,"F-H0-9476",765,2},
  {{{0xa46e5aea513b77c0}},6,"F-H0-9477",825,10},
  {{{0x3ea05ec98e4ba830}},9,"F-H0-9478",457,7},
  {{{0xf96b79ccd2caf29}},5,"F-H0-9479",939,2},
  {{{0xf96b79ccd2caf29}},5,"F-H0-9480",936,2},
  {{{0xc3ae0697999e0741}},6,"F-H0-9481",382,7},
  {{{0x1b8699f390fa5beb}},8,"F-H0-9482",873,4},
  {{{0xb8203559fc02e629}},8,"F-H0-9483",467,3},
  {{{0xa6280780a29ae8ea}},4,"F-H0-9484",467,4},
  {{{0xa6280780a29ae8ea}},4,"F-H0-9485",944,3},
  {{{0x3306316073d3c96}},9,"F-H0-9486",935,11},
  {{{0xd17dd07397f826d4}},15,"F-H0-9487",506,7},
  {{{0xe57481b26a32cc5d}},15,"F-H0-9488",394,3},
  {{{0x61bd80c19311403}},15,"F-H0-9489",948,6},
  {{{0x76241508f4f43197}},15,"F-H0-9490",974,3},
  {{{0x7cf998a533481970}},15,"F-H0-9491",765,8},
  {{{0xb798892d8adee934}},13,"F-H0-9492",985,8},
  {{{0xe85eea12b4a0ecca}},3,"F-H0-9493",456,9},
  {{{0x223ec35a1372fe35}},3,"F-H0-9494",913,2},
  {{{0x5c428fb791af97b9}},18,"F-H0-9495",950,8},
  {{{0xf28030971198aedb}},8,"F-H0-9496",941,4},
  {{{0xbb57d6371c64d736}},8,"F-H0-9497",838,2},
  {{{0x93d9cad21a2e3e13}},3,"F-H0-9498",505,6},
  {{{0x9c88d406ea9c94d9}},5,"F-H0-9499",420,5},
  {{{0x9c88d406ea9c94d9}},5,"F-H0-9500",460,4},
  {{{0xbfc2fdaa23fc2be5}},18,"F-H0-9501",951,11},
  {{{0xd4cf8927dbc71490}},7,"F-H0-9502",690,10},
  {{{0x3f4db295a53d67ce}},6,"F-H0-9503",579,3},
  {{{0x2bd653b0e7aa765a}},6,"F-H0-9504",503,2},
  {{{0x3f4db295a53d67ce}},6,"F-H0-9505",542,2},
  {{{0xca917ae1cb98b2}},3,"F-H0-9506",468,6},
  {{{0x110bfaa219956c6d}},3,"F-H0-9507",455,3},
  {{{0x45fd8b1a1d7f5da7}},6,"F-H0-9508",902,6},
  {{{0x45fd8b1a1d7f5da7}},6,"F-H0-9509",715,2},
  {{{0x32fbeb61658b5912}},8,"F-H0-9510",902,3},
  {{{0x32fbeb61658b5912}},8,"F-H0-9511",751,2},
  {{{0x2f34efe1f24e0992}},8,"F-H0-9512",678,2},
  {{{0xeae4ac2d8ac914ad}},7,"F-H0-9513",493,4},
  {{{0xeae4ac2d8ac914ad}},7,"F-H0-9514",530,2},
  {{{0xb80b68b6a08e2070}},5,"F-H0-9515",908,5},
  {{{0xd5764a503334bf2e}},4,"F-H0-9516",543,5},
  {{{0x25db56f8ee396cbf}},4,"F-H0-9517",801,2},
  {{{0x8167bd91e0d70352}},6,"F-H0-9518",541,4},
  {{{0x8167bd91e0d70352}},6,"F-H0-9519",432,2},
  {{{0x67dfa3e036abeb8c}},13,"F-H0-9520",950,7},
  {{{0x7cc52beea293c6f}},13,"F-H0-9521",904,2},
  {{{0x67dfa3e036abeb8c}},13,"F-H0-9522",838,2},
  {{{0xa18d509fe024647f}},6,"F-H0-9523",944,2},
  {{{0x1e2f45130951abcc}},6,"F-H0-9524",947,2},
  {{{0x6de1cecfdc1bc40c}},6,"F-H0-9525",945,2},
  {{{0x6de1cecfdc1bc40c}},6,"F-H0-9526",462,2},
  {{{0xc744b581eb64df18}},4,"F-H0-9527",863,3},
  {{{0xc744b581eb64df18}},4,"F-H0-9528",902,3},
  {{{0x9883aa38583bed57}},4,"F-H0-9529",939,2},
  {{{0x640ad9d29d7f2020}},6,"F-H0-9530",690,7},
  {{{0x42afc3269ede4be2}},11,"F-H0-9531",907,7},
  {{{0xaa8b2cb9d640882e}},4,"F-H0-9532",458,2},
  {{{0x2b3dc0259f6d0e50}},9,"F-H0-9533",503,7},
  {{{0x817d80984108c7ef}},9,"F-H0-9534",461,9},
  {{{0xf1ca64602aab8cc8}},9,"F-H0-9535",432,8},
  {{{0xf1ca64602aab8cc8}},9,"F-H0-9536",428,2},
  {{{0xb9310b543acfb49a}},2,"F-H0-9537",456,4},
  {{{0x6fd12fac62478b19}},2,"F-H0-9538",900,2},
  {{{0x6fd12fac62478b19}},2,"F-H0-9539",456,2},
  {{{0x3d4cca78c1d14eb1}},2,"F-H0-9540",504,2},
  {{{0xa27e446876eb06bb}},7,"F-H0-9541",566,3},
  {{{0x9e82584aa02c69c1}},7,"F-H0-9542",800,2},
  {{{0x18bcc96a32093200}},7,"F-H0-9543",902,2},
  {{{0xfa70c7c4eb2d5fcb}},11,"F-H0-9544",654,7},
  {{{0xfa70c7c4eb2d5fcb}},11,"F-H0-9545",543,2},
  {{{0x3fe05c1339d8037a}},7,"F-H0-9546",911,2},
  {{{0x3fe05c1339d8037a}},7,"F-H0-9547",947,2},
  {{{0x6d9532d47159f488}},11,"F-H0-9548",943,4},
  {{{0xd89ace92a34f38cf}},9,"F-H0-9549",529,6},
  {{{0x31ae5f1b43d0edb2}},5,"F-H0-9550",910,3},
  {{{0xe1c28c6b976bb42e}},5,"F-H0-9551",457,2},
  {{{0x31ae5f1b43d0edb2}},5,"F-H0-9552",909,2},
  {{{0xa6d51b6bbea584c9}},12,"F-H0-9553",494,6},
  {{{0x49524c3b6cfc7552}},18,"F-H0-9554",945,6},
  {{{0x49524c3b6cfc7552}},18,"F-H0-9555",940,2},
  {{{0x55bbfd6b5ac20ef0}},10,"F-H0-9556",975,3},
  {{{0x55bbfd6b5ac20ef0}},10,"F-H0-9557",938,2},
  {{{0xce1e0fa2ea662c62}},7,"F-H0-9558",912,4},
  {{{0x7fdbe3f1630d095e}},7,"F-H0-9559",529,3},
  {{{0x7fdbe3f1630d095e}},7,"F-H0-9560",455,2},
  {{{0x63517121fad43a64}},6,"F-H0-9561",936,4},
  {{{0x9fa1737bc3c753a1}},6,"F-H0-9562",839,3},
  {{{0xa79977a93f9fa1a6}},7,"F-H0-9563",468,10},
  {{{0xc57d266a4ef2d79a}},10,"F-H0-9564",468,7},
  {{{0x62cf61546a23ff10}},5,"F-H0-9565",825,5},
  {{{0x6602ed640ba67413}},5,"F-H0-9566",462,2},
  {{{0xf31c0d3c7f827bd4}},16,"F-H0-9567",802,5},
  {{{0xff613fface6414d0}},16,"F-H0-9568",942,2},
  {{{0x5440b5da190c58ac}},5,"F-H0-9569",909,9},
  {{{0x608b72cad0faa05e}},7,"F-H0-9570",874,8},
  {{{0x7985c2119e255cbe}},7,"F-H0-9571",529,2},
  {{{0x8fbb5b250e40cf1c}},4,"F-H0-9572",543,2},
  {{{0x9b8ec0941088ffee}},7,"F-H0-9573",419,7},
  {{{0x6fef247104075e80}},4,"F-H0-9574",457,3},
  {{{0x6fef247104075e80}},4,"F-H0-9575",419,2},
  {{{0x6fef247104075e80}},4,"F-H0-9576",542,2},
  {{{0xebe2c29f2417b07f}},9,"F-H0-9577",825,3},
  {{{0xbe3d4dee60043453}},14,"F-H0-9578",910,7},
  {{{0xbe3d4dee60043453}},14,"F-H0-9579",947,2},
  {{{0xa63abed265e5e1c2}},11,"F-H0-9580",910,6},
  {{{0x27536036da02e28b}},11,"F-H0-9581",862,2},
  {{{0x2d3fcbe7917dfe5e}},7,"F-H0-9582",455,9},
  {{{0x10b6b7b22f5126b1}},12,"F-H0-9583",615,8},
  {{{0x6cae789a155aadb2}},8,"F-H0-9584",839,10},
  {{{0x82f865bcf7f73d8a}},4,"F-H0-9585",430,3},
  {{{0x28b25dadf16c799f}},4,"F-H0-9586",913,2},
  {{{0x9191d68c5995a1b7}},6,"F-H0-9587",566,5},
  {{{0xd58f4e57ca9fbe5c}},6,"F-H0-9588",543,3},
  {{{0xae913b2a28c0fefe}},18,"F-H0-9589",949,5},
  {{{0xae913b2a28c0fefe}},18,"F-H0-9590",951,5},
  {{{0x9f329a5f6cc2e5a5}},6,"F-H0-9591",939,4},
  {{{0x9f329a5f6cc2e5a5}},6,"F-H0-9592",862,3},
  {{{0x32c629255e3cb92c}},10,"F-H0-9593",464,5},
  {{{0x662a4570f16baf5b}},2,"F-H0-9594",456,2},
  {{{0x662a4570f16baf5b}},2,"F-H0-9595",455,2},
  {{{0x83680e1a8469a4ac}},8,"F-H0-9596",874,4},
  {{{0x9e364d850c33b723}},8,"F-H0-9597",838,3},
  {{{0xe895b234a9c84dbd}},8,"F-H0-9598",827,2},
  {{{0x5182ed8eab8fd2e4}},5,"F-H0-9599",470,2},
  {{{0x90455ff60adf2daf}},5,"F-H0-9600",455,2},
  {{{0x5330fbfb9bf4f19c}},8,"F-H0-9601",605,4},
  {{{0x7eee260b1a998bf2}},5,"F-H0-9602",431,7},
  {{{0xaaf68c46964dd2be}},5,"F-H0-9603",580,3},
  {{{0x217b9f302a2a4230}},3,"F-H0-9604",542,4},
  {{{0x217b9f302a2a4230}},3,"F-H0-9605",466,3},
  {{{0x444654d42307a357}},6,"F-H0-9606",751,2},
  {{{0x8be2d05a4f45ce82}},15,"F-H0-9607",950,4},
  {{{0x6fa3392b89a69711}},10,"F-H0-9608",431,7},
  {{{0x6183a5bf71c05a47}},7,"F-H0-9609",912,8},
  {{{0xc4c7173972a722ac}},4,"F-H0-9610",906,6},
  {{{0xc4c7173972a722ac}},4,"F-H0-9611",678,2},
  {{{0x79ff1a2988fbd283}},14,"F-H0-9612",432,10},
  {{{0x3c670a8242508104}},10,"F-H0-9613",949,4},
  {{{0xa359ce090a90bb86}},6,"F-H0-9614",432,10},
  {{{0x4cd355510f749017}},21,"F-H0-9615",603,2},
  {{{0x4cd355510f749017}},21,"F-H0-9616",641,2},
  {{{0x4cd355510f749017}},21,"F-H0-9617",458,2},
  {{{0x2faa3f7878be777d}},7,"F-H0-9618",455,7},
  {{{0x9e993cc46ca63bfe}},11,"F-H0-9619",949,10},
  {{{0x15a6e9cc677ffa8a}},6,"F-H0-9620",728,6},
  {{{0x15a6e9cc677ffa8a}},6,"F-H0-9621",910,2},
  {{{0x5d3b856a318e7463}},9,"F-H0-9622",950,6},
  {{{0x5d3b856a318e7463}},9,"F-H0-9623",948,4},
  {{{0x3dc60f9e4ccc9941}},4,"F-H0-9624",875,3},
  {{{0x5efe0683c5720993}},4,"F-H0-9625",839,2},
  {{{0x8c9ce7b4ab534fd5}},3,"F-H0-9626",456,9},
  {{{0x8db901b0fcb1aa96}},8,"F-H0-9627",875,8},
  {{{0x9b4356a78d73cb92}},13,"F-H0-9628",875,5},
  {{{0xcae2b5ad8452c2e1}},13,"F-H0-9629",826,4},
  {{{0x9efd2cd13ef102}},9,"F-H0-9630",543,3},
  {{{0x842627877cc4448a}},6,"F-H0-9631",432,2},
  {{{0xab2699e3a611358a}},6,"F-H0-9632",865,2},
  {{{0xc4d5755ae4af6eaa}},8,"F-H0-9633",465,9},
  {{{0xc2802251e80326d7}},9,"F-H0-9634",469,9},
  {{{0xc15b4cc3ee0c306c}},15,"F-H0-9635",802,8},
  {{{0xfbf3cbd5f71d0faf}},8,"F-H0-9636",947,4},
  {{{0x22b2418390d1ee27}},8,"F-H0-9637",418,3},
  {{{0x32deec1647085492}},6,"F-H0-9638",947,6},
  {{{0xd551a9734206c946}},6,"F-H0-9639",826,2},
  {{{0x1ba30cd01d109ea7}},9,"F-H0-9640",429,3},
  {{{0xf63a021185817d64}},9,"F-H0-9641",530,3},
  {{{0x66e164de3753346}},9,"F-H0-9642",684,2},
  {{{0x4639c3e22944b0dd}},7,"F-H0-9643",395,8},
  {{{0xbd7e5a166f2a1c30}},8,"F-H0-9644",825,4},
  {{{0xbd7e5a166f2a1c30}},8,"F-H0-9645",941,2},
  {{{0xbd7e5a166f2a1c30}},8,"F-H0-9646",826,2},
  {{{0xf8485c2dba3a2dda}},10,"F-H0-9647",431,9},
  {{{0xcd99cb6d7ff9eb8e}},5,"F-H0-9648",908,3},
  {{{0x8841bcbb382ea7b0}},18,"F-H0-9649",872,9},
  {{{0xb07c05b0a3fddc37}},6,"F-H0-9650",838,3},
  {{{0xb07c05b0a3fddc37}},6,"F-H0-9651",908,3},
  {{{0xb07c05b0a3fddc37}},6,"F-H0-9652",948,2},
  {{{0x2a615cd1c135fcab}},9,"F-H0-9653",873,4},
  {{{0x2a615cd1c135fcab}},9,"F-H0-9654",875,3},
  {{{0x2a615cd1c135fcab}},9,"F-H0-9655",950,2},
  {{{0x7c01e79820605830}},8,"F-H0-9656",790,3},
  {{{0x7b392f692ff055e0}},8,"F-H0-9657",946,3},
  {{{0x7b392f692ff055e0}},8,"F-H0-9658",913,2},
  {{{0x23fe25e71f89e599}},8,"F-H0-9659",838,2},
  {{{0x64edbdddb31faed3}},9,"F-H0-9660",425,8},
  {{{0xe2274d03eac5ce2b}},9,"F-H0-9661",640,2},
  {{{0x514d61789c5a796f}},17,"F-H0-9662",839,5},
  {{{0xb8714c0ec76a6ee2}},17,"F-H0-9663",677,2},
  {{{0xb8714c0ec76a6ee2}},17,"F-H0-9664",714,2},
  {{{0xcb21a5a6781e7894}},4,"F-H0-9665",939,6},
  {{{0x908be0619684dcef}},4,"F-H0-9666",913,2},
  {{{0xbad1dcf3b8f01275}},12,"F-H0-9667",872,10},
  {{{0xb233b93a3852cfc2}},5,"F-H0-9668",543,5},
  {{{0xafd803032286570c}},8,"F-H0-9669",937,8},
  {{{0xf53b188938ca65cd}},9,"F-H0-9670",949,5},
  {{{0xf53b188938ca65cd}},9,"F-H0-9671",939,5},
  {{{0x6318da03ead3ff9e}},8,"F-H0-9672",788,10},
  {{{0xfa8abc4c0df952e5}},8,"F-H0-9673",457,2},
  {{{0xfa8abc4c0df952e5}},8,"F-H0-9674",678,2},
  {{{0xfa8abc4c0df952e5}},8,"F-H0-9675",425,2},
  {{{0xdc28bec61d4103e1}},15,"F-H0-9676",568,8},
  {{{0xe78e24ca8121cb7d}},13,"F-H0-9677",987,6},
  {{{0xc0943a02e656e3f5}},13,"F-H0-9678",491,3},
  {{{0xdb73795f4530f423}},10,"F-H0-9679",617,5},
  {{{0xdb73795f4530f423}},10,"F-H0-9680",654,5},
  {{{0x6c81c64e4419e797}},6,"F-H0-9681",456,2},
  {{{0x6c81c64e4419e797}},6,"F-H0-9682",493,2},
  {{{0xa3ae9ebd2d6e6d23}},6,"F-H0-9683",907,2},
  {{{0xddacdf8331e086a0}},6,"F-H0-9684",902,2},
  {{{0xb4453472a6c02955}},5,"F-H0-9685",825,3},
  {{{0xb4453472a6c02955}},5,"F-H0-9686",801,2},
  {{{0xb4453472a6c02955}},5,"F-H0-9687",764,2},
  {{{0x2ceb69fb02aae6ef}},4,"F-H0-9688",911,4},
  {{{0xb879324f59fadf52}},4,"F-H0-9689",906,2},
  {{{0xee5be5da660419eb}},4,"F-H0-9690",419,2},
  {{{0x3a980feba179a41c}},6,"F-H0-9691",950,4},
  {{{0x25795bad63aa15b0}},6,"F-H0-9692",462,2},
  {{{0x4208cbeb529aa1b7}},7,"F-H0-9693",542,3},
  {{{0x4208cbeb529aa1b7}},7,"F-H0-9694",943,2},
  {{{0x543ae91fb420f8e1}},4,"F-H0-9695",468,7},
  {{{0x8157ab18f1167732}},4,"F-H0-9696",906,3},
  {{{0x79796fcbd7acac23}},16,"F-H0-9697",462,9},
  {{{0x5c25563ae33c8b45}},5,"F-H0-9698",939,2},
  {{{0xa8554ec33c880b2e}},6,"F-H0-9699",863,7},
  {{{0xd830a38f1f75d909}},6,"F-H0-9700",875,2},
  {{{0xbc89cb9b4802f1ac}},12,"F-H0-9701",942,4},
  {{{0xbc89cb9b4802f1ac}},12,"F-H0-9702",904,4},
  {{{0xa6eff328ae55b8b0}},10,"F-H0-9703",875,10},
  {{{0x6c42ecc6d4833da3}},6,"F-H0-9704",467,3},
  {{{0x4a35e88d28cfa9de}},6,"F-H0-9705",838,3},
  {{{0x9fb16966dcf8c2c4}},6,"F-H0-9706",493,2},
  {{{0xafb1d2a9c07da29f}},5,"F-H0-9707",948,2},
  {{{0x8a5fd86b921a71c0}},6,"F-H0-9708",381,10},
  {{{0x3fc9d4da7711792e}},14,"F-H0-9709",870,5},
  {{{0x3fc9d4da7711792e}},14,"F-H0-9710",825,3},
  {{{0x9728fe23308fc75c}},8,"F-H0-9711",940,3},
  {{{0x9728fe23308fc75c}},8,"F-H0-9712",945,2},
  {{{0x9728fe23308fc75c}},8,"F-H0-9713",941,2},
  {{{0xf993073f6b83b7a5}},4,"F-H0-9714",909,2},
  {{{0x14a9ab2f6cb760d3}},4,"F-H0-9715",864,6},
  {{{0x96c27b3aef47192b}},6,"F-H0-9716",950,6},
  {{{0x876bfebc184a574}},6,"F-H0-9717",541,2},
  {{{0x44e4e0d24f045a65}},6,"F-H0-9718",495,8},
  {{{0x32d302d3a567c175}},6,"F-H0-9719",429,3},
  {{{0x7c33d46f6940193f}},6,"F-H0-9720",420,2},
  {{{0xcb9b8cdc69a01b19}},10,"F-H0-9721",863,8},
  {{{0x2909e4fe49374f06}},12,"F-H0-9722",949,4},
  {{{0x9913a0cc53dadc87}},12,"F-H0-9723",419,2},
  {{{0x2050f38177f3bab2}},3,"F-H0-9724",431,3},
  {{{0x97a2c1a21510c595}},3,"F-H0-9725",468,3},
  {{{0x97a2c1a21510c595}},3,"F-H0-9726",913,2},
  {{{0x3c8bd43dec6892c1}},8,"F-H0-9727",424,8},
  {{{0x9b09a254efeff0a7}},8,"F-H0-9728",941,7},
  {{{0xe8719527aa683070}},8,"F-H0-9729",939,3},
  {{{0x9f07e421d4a098ea}},12,"F-H0-9730",948,6},
  {{{0x4ff957e5107c533c}},12,"F-H0-9731",394,2},
  {{{0x729abe51151f81f7}},6,"F-H0-9732",943,2},
  {{{0xfbdb4f2f80379ba2}},9,"F-H0-9733",987,10},
  {{{0xb3de83ab7d53836c}},8,"F-H0-9734",427,4},
  {{{0xca9cae2381b3ca85}},8,"F-H0-9735",910,3},
  {{{0xefc49e5e6b54432f}},12,"F-H0-9736",939,4},
  {{{0xefc49e5e6b54432f}},12,"F-H0-9737",678,3},
  {{{0xefc49e5e6b54432f}},12,"F-H0-9738",751,2},
  {{{0x28d8d053bf0f712d}},11,"F-H0-9739",428,3},
  {{{0x28d8d053bf0f712d}},11,"F-H0-9740",947,2},
  {{{0x4371042db4d21b93}},19,"F-H0-9741",907,9},
  {{{0xe06dca6fb99d5620}},6,"F-H0-9742",947,4},
  {{{0x6378feb2aa9da055}},6,"F-H0-9743",531,3},
  {{{0x6b6810548755713d}},4,"F-H0-9744",975,2},
  {{{0x2fa90770bdaa1876}},4,"F-H0-9745",492,2},
  {{{0x6b6810548755713d}},4,"F-H0-9746",936,2},
  {{{0xc14adfac79c6a566}},5,"F-H0-9747",939,2},
  {{{0x9ab18f82b3b6dc60}},5,"F-H0-9748",691,2},
  {{{0xab736fa02d4dde7c}},5,"F-H0-9749",839,2},
  {{{0xadf585b33ae07e2d}},6,"F-H0-9750",949,7},
  {{{0xf5c2eab9b940f443}},5,"F-H0-9751",420,2},
  {{{0x7041643c905912db}},5,"F-H0-9752",604,2},
  {{{0xf5c2eab9b940f443}},5,"F-H0-9753",911,2},
  {{{0x145532111e5df24}},4,"F-H0-9754",875,3},
  {{{0xa18c8bd16c0c66c1}},4,"F-H0-9755",506,3},
  {{{0xa18c8bd16c0c66c1}},4,"F-H0-9756",912,2},
  {{{0xad03910722bf9b1b}},5,"F-H0-9757",911,3},
  {{{0xad03910722bf9b1b}},5,"F-H0-9758",947,2},
  {{{0x228e4a91686ba6f}},8,"F-H0-9759",944,3},
  {{{0x228e4a91686ba6f}},8,"F-H0-9760",911,2},
  {{{0xd3306e69a185ec8b}},7,"F-H0-9761",455,7},
  {{{0xee42ee5268959529}},5,"F-H0-9762",429,3},
  {{{0xb86308c3683b8ebc}},5,"F-H0-9763",463,3},
  {{{0x4e69455a5e460cd}},7,"F-H0-9764",381,3},
  {{{0x5b4cb97e1057c60c}},7,"F-H0-9765",949,2},
  {{{0x5b4cb97e1057c60c}},7,"F-H0-9766",912,2},
  {{{0x196cefe1922146e7}},9,"F-H0-9767",541,7},
  {{{0x196cefe1922146e7}},9,"F-H0-9768",506,3},
  {{{0xc4a091bde115edbf}},6,"F-H0-9769",457,8},
  {{{0x962d8eb021edeee5}},9,"F-H0-9770",984,3},
  {{{0x6754c8499378b80f}},9,"F-H0-9771",861,2},
  {{{0x7ef8c4ede194358e}},7,"F-H0-9772",465,8},
  {{{0xd38cf2c27871a7d8}},6,"F-H0-9773",941,3},
  {{{0xd38cf2c27871a7d8}},6,"F-H0-9774",938,3},
  {{{0x1c1ef8138d8abcb6}},9,"F-H0-9775",974,2},
  {{{0x56e302c2c0765e8b}},5,"F-H0-9776",825,2},
  {{{0xb4c3088489f4116a}},5,"F-H0-9777",677,2},
  {{{0xe9a84b96ef6d8d94}},5,"F-H0-9778",947,2},
  {{{0x8bbefa8d9c850b9d}},4,"F-H0-9779",542,3},
  {{{0x8bbefa8d9c850b9d}},4,"F-H0-9780",912,2},
  {{{0xb5b33da5fc2265e9}},4,"F-H0-9781",788,2},
  {{{0xb5b33da5fc2265e9}},4,"F-H0-9782",752,2},
  {{{0x708171ffb78dc087}},7,"F-H0-9783",714,8},
  {{{0xaa640156e5532520}},19,"F-H0-9784",908,5},
  {{{0xca4cca12a69d41b6}},19,"F-H0-9785",727,3},
  {{{0x3e55cdbced8e2ae}},6,"F-H0-9786",462,6},
  {{{0xba97d0a95f57e13f}},6,"F-H0-9787",470,2},
  {{{0x3f7982c0edc2d437}},8,"F-H0-9788",876,8},
  {{{0xcc5fc13eb1c9c0da}},10,"F-H0-9789",752,6},
  {{{0xd8fb3e2b5de4d538}},10,"F-H0-9790",948,2},
  {{{0xd9a9c79a70be2ec4}},17,"F-H0-9791",943,9},
  {{{0xc668401b5b02df71}},9,"F-H0-9792",392,7},
  {{{0xe5a8b260f0f3ac92}},8,"F-H0-9793",938,10},
  {{{0xd419f5590bf48dc2}},7,"F-H0-9794",908,5},
  {{{0xb025c37dbe4a4ccb}},7,"F-H0-9795",420,2},
  {{{0x4ee353bdc753a79c}},8,"F-H0-9796",839,6},
  {{{0x4ee353bdc753a79c}},8,"F-H0-9797",802,3},
  {{{0xf2c1f1bd237d443c}},10,"F-H0-9798",791,4},
  {{{0xb7c365884ddd84c5}},10,"F-H0-9799",714,3},
  {{{0xb7c365884ddd84c5}},10,"F-H0-9800",677,2},
  {{{0x73ec60b8398f66c4}},5,"F-H0-9801",616,2},
  {{{0x73ec60b8398f66c4}},5,"F-H0-9802",911,2},
  {{{0xb0405a8256e1383}},5,"F-H0-9803",530,2},
  {{{0x5eb9886ed6e1b85c}},3,"F-H0-9804",468,3},
  {{{0xd7d45ab41d805bb5}},3,"F-H0-9805",913,3},
  {{{0x6a16d661944d74f9}},3,"F-H0-9806",457,2},
  {{{0x5eb9886ed6e1b85c}},3,"F-H0-9807",469,2},
  {{{0x3d5a48ba50e7e072}},6,"F-H0-9808",801,3},
  {{{0x3d5a48ba50e7e072}},6,"F-H0-9809",678,2},
  {{{0x936803e1ac980568}},10,"F-H0-9810",690,8},
  {{{0xd783e50875a70fd1}},9,"F-H0-9811",974,4},
  {{{0x37d7e2f49be3b3bf}},9,"F-H0-9812",677,3},
  {{{0x499c5a6429851bc3}},7,"F-H0-9813",947,8},
  {{{0xd8ad465946b15c44}},7,"F-H0-9814",900,2},
  {{{0x225ccb0580a8ef95}},9,"F-H0-9815",950,4},
  {{{0x1ab2e10ccd8be145}},9,"F-H0-9816",837,4},
  {{{0x132c83abedc5896f}},8,"F-H0-9817",458,8},
  {{{0xfae845f290256e23}},7,"F-H0-9818",939,7},
  {{{0xa9e2368eb81d7f1c}},7,"F-H0-9819",912,2},
  {{{0x24d4e6c08893ae37}},10,"F-H0-9820",430,6},
  {{{0x680996e92bf5237b}},10,"F-H0-9821",874,2},
  {{{0xdf373813aba57683}},12,"F-H0-9822",862,5},
  {{{0x2d5edbb975361a6}},12,"F-H0-9823",837,4},
  {{{0xa05ef5f8e17d268e}},9,"F-H0-9824",949,8},
  {{{0x3b58403da2bf11c8}},10,"F-H0-9825",913,9},
  {{{0xe910eac191e0a1c4}},8,"F-H0-9826",579,10},
  {{{0xd4bc469884e9cf21}},19,"F-H0-9827",906,6},
  {{{0x8ce860d2d45647a9}},11,"F-H0-9828",417,10},
  {{{0xf82e6ee5e3509000}},10,"F-H0-9829",728,8},
  {{{0x7e94b25f5c7ccc5a}},6,"F-H0-9830",751,5},
  {{{0x7e94b25f5c7ccc5a}},6,"F-H0-9831",902,2},
  {{{0x7010c12dd2603f7d}},5,"F-H0-9832",825,3},
  {{{0x7010c12dd2603f7d}},5,"F-H0-9833",690,2},
  {{{0x5e0934d9b7404b02}},6,"F-H0-9834",837,2},
  {{{0x5e0934d9b7404b02}},6,"F-H0-9835",950,2},
  {{{0xf00b83a0894aa995}},6,"F-H0-9836",902,4},
  {{{0xf00b83a0894aa995}},6,"F-H0-9837",751,3},
  {{{0x9ae58e46f29d710f}},6,"F-H0-9838",839,7},
  {{{0xff361e5d333abad}},6,"F-H0-9839",948,6},
  {{{0xe17ccdb6ea6b1bca}},7,"F-H0-9840",543,5},
  {{{0xe17ccdb6ea6b1bca}},7,"F-H0-9841",542,2},
  {{{0x2609ce587e40374a}},9,"F-H0-9842",393,5},
  {{{0xffe9924e08839970}},10,"F-H0-9843",430,5},
  {{{0xffe9924e08839970}},10,"F-H0-9844",431,3},
  {{{0xffe9924e08839970}},10,"F-H0-9845",432,2},
  {{{0xaa58129b958edae1}},12,"F-H0-9846",426,6},
  {{{0x820b8a4d6468f6d1}},21,"F-H0-9847",945,5},
  {{{0x820b8a4d6468f6d1}},21,"F-H0-9848",944,4},
  {{{0x4b7e659dfa714d46}},11,"F-H0-9849",422,5},
  {{{0x6f2e1c78bddd238b}},11,"F-H0-9850",973,3},
  {{{0x4d0e1158b56df998}},5,"F-H0-9851",900,10},
  {{{0x7aac97e0b9c51994}},10,"F-H0-9852",462,6},
  {{{0x1bd9f1936abbcc69}},3,"F-H0-9853",936,4},
  {{{0x734fb642a5ddb946}},3,"F-H0-9854",912,2},
  {{{0xd669c2cc059b35fb}},3,"F-H0-9855",456,5},
  {{{0x66f36ce1fe94afb8}},8,"F-H0-9856",909,8},
  {{{0x639700dbdfb467ac}},8,"F-H0-9857",899,2},
  {{{0x401f1fdd549110b7}},7,"F-H0-9858",939,3},
  {{{0x44fd67f67279eb80}},7,"F-H0-9859",839,3},
  {{{0x8019d837376bcf44}},7,"F-H0-9860",690,3},
  {{{0xc0d2e51e0c04027e}},7,"F-H0-9861",939,2},
  {{{0x8019d837376bcf44}},7,"F-H0-9862",910,2},
  {{{0xd3de937943211a31}},7,"F-H0-9863",530,4},
  {{{0xd3de937943211a31}},7,"F-H0-9864",494,2},
  {{{0xf42255052da1b5de}},12,"F-H0-9865",506,10},
  {{{0xde3ce5c28caacadd}},4,"F-H0-9866",939,3},
  {{{0x5d7fe0d3112b6c80}},4,"F-H0-9867",684,3},
  {{{0x13db8ff2d516619b}},4,"F-H0-9868",420,5},
  {{{0xf72045bdb7f43ebf}},4,"F-H0-9869",839,2},
  {{{0x279e9696ffb2cd69}},16,"F-H0-9870",950,5},
  {{{0xb4820bb4b50b916f}},16,"F-H0-9871",581,3},
  {{{0x35f6904cf0b9d229}},16,"F-H0-9872",419,2},
  {{{0xc16b15d3603284c5}},10,"F-H0-9873",543,3},
  {{{0xc16b15d3603284c5}},10,"F-H0-9874",457,2},
  {{{0xc16b15d3603284c5}},10,"F-H0-9875",456,2},
  {{{0xc16b15d3603284c5}},10,"F-H0-9876",419,2},
  {{{0x341ea3378fb2af2f}},16,"F-H0-9877",908,2},
  {{{0x341ea3378fb2af2f}},16,"F-H0-9878",802,2},
  {{{0x6030df7257efec7e}},16,"F-H0-9879",505,2},
  {{{0x79fcc2a980ddc54f}},9,"F-H0-9880",469,10},
  {{{0x1e30a56dc9bf9bd2}},19,"F-H0-9881",690,4},
  {{{0x1e30a56dc9bf9bd2}},19,"F-H0-9882",910,2},
  {{{0x538781eeb3473096}},19,"F-H0-9883",839,2},
  {{{0x14d239f084c8d6ce}},7,"F-H0-9884",939,2},
  {{{0x59edd9829081c136}},9,"F-H0-9885",678,6},
  {{{0x59edd9829081c136}},9,"F-H0-9886",715,2},
  {{{0x5ecd90f02f794042}},10,"F-H0-9887",945,2},
  {{{0x5ecd90f02f794042}},10,"F-H0-9888",987,2},
  {{{0x9b93998aa2f931b3}},10,"F-H0-9889",539,2},
  {{{0x8fb7ec9e5fdf2ca5}},5,"F-H0-9890",641,2},
  {{{0xca20dabacfde50b6}},5,"F-H0-9891",654,2},
  {{{0x23f9c06bf70bf65}},5,"F-H0-9892",941,2},
  {{{0x1aa07ddc460ce1d9}},10,"F-H0-9893",939,7},
  {{{0x1aa07ddc460ce1d9}},10,"F-H0-9894",543,2},
  {{{0x6080d7295528bf3d}},8,"F-H0-9895",469,10},
  {{{0xaf81d1fa086bfccb}},5,"F-H0-9896",911,4},
  {{{0x400817dc5bba76c4}},5,"F-H0-9897",838,3},
  {{{0x37d0e97d08c343c5}},7,"F-H0-9898",567,4},
  {{{0x2b8476a81b458ed}},7,"F-H0-9899",458,3},
  {{{0x6f5b8a00dc0d3df0}},8,"F-H0-9900",839,4},
  {{{0x288deb9aab76f135}},8,"F-H0-9901",425,2},
  {{{0x3daa795017c5f0d6}},13,"F-H0-9902",464,5},
  {{{0x469016fa91cb1a17}},13,"F-H0-9903",494,3},
  {{{0xae724a23889465e7}},5,"F-H0-9904",825,2},
  {{{0x5d816b8cf796e5ad}},9,"F-H0-9905",913,9},
  {{{0x9cc5b99fb7920df0}},20,"F-H0-9906",904,7},
  {{{0x2391ae7d2e2092d0}},13,"F-H0-9907",691,8},
  {{{0x2391ae7d2e2092d0}},13,"F-H0-9908",654,2},
  {{{0xa1df7b68417e05e0}},19,"F-H0-9909",764,4},
  {{{0xcf34173e7f75a04a}},19,"F-H0-9910",905,2},
  {{{0x9b053647cb9b3d7e}},4,"F-H0-9911",505,5},
  {{{0x9b053647cb9b3d7e}},4,"F-H0-9912",653,2},
  {{{0x46818d017c9b97b6}},10,"F-H0-9913",640,4},
  {{{0xb248189a5bee655b}},10,"F-H0-9914",752,3},
  {{{0xcd9ba0ecbd151304}},10,"F-H0-9915",430,2},
  {{{0x4707c0c609c4c751}},9,"F-H0-9916",944,7},
  {{{0x4707c0c609c4c751}},9,"F-H0-9917",906,2},
  {{{0xd5cefa15cb9481a5}},7,"F-H0-9918",910,7},
  {{{0xbf0b917f082cba4a}},7,"F-H0-9919",839,3},
  {{{0xa39c7bfb8045a95}},7,"F-H0-9920",947,3},
  {{{0x54af18e5b5025046}},7,"F-H0-9921",430,2},
  {{{0xdc6c795ba0588969}},7,"F-H0-9922",495,2},
  {{{0x9fe130aeef51f48f}},10,"F-H0-9923",506,9},
  {{{0x177207485a8270d3}},7,"F-H0-9924",876,7},
  {{{0x56789b10bdd251ba}},8,"F-H0-9925",470,2},
  {{{0x1c50b64209837636}},9,"F-H0-9926",947,3},
  {{{0xc7e963d06d471e30}},9,"F-H0-9927",950,2},
  {{{0x5f08ebbfb23d6503}},15,"F-H0-9928",431,3},
  {{{0x5f08ebbfb23d6503}},15,"F-H0-9929",939,3},
  {{{0x5f08ebbfb23d6503}},15,"F-H0-9930",825,2},
  {{{0xb336bed847570a41}},10,"F-H0-9931",946,4},
  {{{0xb336bed847570a41}},10,"F-H0-9932",948,2},
  {{{0xfce6128d6bafffe3}},9,"F-H0-9933",942,7},
  {{{0xedb28f8d269d5992}},7,"F-H0-9934",947,5},
  {{{0xedb28f8d269d5992}},7,"F-H0-9935",912,3},
  {{{0x8f13a39ea4979aa1}},10,"F-H0-9936",911,5},
  {{{0xf4ee4ba96a06c6ab}},5,"F-H0-9937",603,3},
  {{{0xf4ee4ba96a06c6ab}},5,"F-H0-9938",421,2},
  {{{0x8cd9fcfbe040a133}},5,"F-H0-9939",943,5},
  {{{0x8cd9fcfbe040a133}},5,"F-H0-9940",431,3},
  {{{0x6bc2e7fbed00a3c0}},8,"F-H0-9941",383,6},
  {{{0x25719391f16cf6c5}},8,"F-H0-9942",802,4},
  {{{0xfc84afaa74b4d5e5}},7,"F-H0-9943",431,10},
  {{{0xf6a55702c914404a}},6,"F-H0-9944",764,3},
  {{{0x13834cf2c16a8dd1}},6,"F-H0-9945",875,2},
  {{{0x13834cf2c16a8dd1}},6,"F-H0-9946",946,2},
  {{{0xa1db5b8412603648}},5,"F-H0-9947",825,4},
  {{{0xa1db5b8412603648}},5,"F-H0-9948",529,2},
  {{{0xa1db5b8412603648}},5,"F-H0-9949",492,2},
  {{{0xfb2256a17f134cea}},4,"F-H0-9950",944,3},
  {{{0xfb2256a17f134cea}},4,"F-H0-9951",907,2},
  {{{0xf4e20b6fbba3dc2a}},10,"F-H0-9952",825,4},
  {{{0xd0b54de42ca2c553}},10,"F-H0-9953",418,3},
  {{{0x7864abb997689e10}},10,"F-H0-9954",577,2},
  {{{0xd9092abac1085273}},3,"F-H0-9955",457,3},
  {{{0xd9092abac1085273}},3,"F-H0-9956",493,2},
  {{{0x806c58da0cc9f2ef}},3,"F-H0-9957",876,2},
  {{{0x57a19e9bb4958d31}},15,"F-H0-9958",980,6},
  {{{0xd119bf62bb717f30}},7,"F-H0-9959",874,8},
  {{{0xf261e455cbdc6612}},11,"F-H0-9960",982,5},
  {{{0xf261e455cbdc6612}},11,"F-H0-9961",908,2},
  {{{0x691e16d8e2144351}},11,"F-H0-9962",467,9},
  {{{0x9d55ff95e658de26}},5,"F-H0-9963",862,3},
  {{{0x1d099eafc5d366d1}},8,"F-H0-9964",863,5},
  {{{0xfa7baed3e5b4dd9f}},8,"F-H0-9965",466,3},
  {{{0xbea710e41a8962c9}},3,"F-H0-9966",900,4},
  {{{0xbea710e41a8962c9}},3,"F-H0-9967",912,2},
  {{{0x21989b9e0aa48c65}},5,"F-H0-9968",943,4},
  {{{0x21989b9e0aa48c65}},5,"F-H0-9969",944,2},
  {{{0x4114b25fffd59e70}},9,"F-H0-9970",907,7},
  {{{0x5339fb23f9de613a}},9,"F-H0-9971",899,10},
  {{{0x15114f73bd4f3a86}},5,"F-H0-9972",909,3},
  {{{0xbbc1396a7be2b82e}},5,"F-H0-9973",948,2},
  {{{0xbbc1396a7be2b82e}},5,"F-H0-9974",825,2},
  {{{0xa0ee62f44ac02439}},8,"F-H0-9975",467,9},
  {{{0x9164b72706dfa664}},8,"F-H0-9976",874,7},
  {{{0xaf35963d863e7be}},9,"F-H0-9977",728,7},
  {{{0xaf35963d863e7be}},9,"F-H0-9978",765,2},
  {{{0xd2f86be258842041}},6,"F-H0-9979",901,5},
  {{{0xd2f86be258842041}},6,"F-H0-9980",789,2},
  {{{0xf13288bfa9ea900a}},7,"F-H0-9981",542,6},
  {{{0x613681e55e72450e}},7,"F-H0-9982",949,2},
  {{{0xf6a102c60c831c61}},9,"F-H0-9983",944,9},
  {{{0x3b8aa2dba621d9bc}},6,"F-H0-9984",457,2},
  {{{0x6a53d481575c676e}},6,"F-H0-9985",876,2},
  {{{0x2d0b5980841c688}},7,"F-H0-9986",950,6},
  {{{0x7bcdeb251a303837}},7,"F-H0-9987",531,3},
  {{{0xc01a1df1198206e7}},5,"F-H0-9988",691,3},
  {{{0xbe07bb724c9d3626}},5,"F-H0-9989",939,2},
  {{{0x2257299e98ccbbd6}},5,"F-H0-9990",866,2},
  {{{0x84b6fc7c27a91764}},5,"F-H0-9991",872,2},
  {{{0x84b6fc7c27a91764}},5,"F-H0-9992",468,2},
  {{{0x323c6c3b6365187b}},7,"F-H0-9993",426,4},
  {{{0x323c6c3b6365187b}},7,"F-H0-9994",464,2},
  {{{0x4d37a5530660f81}},8,"F-H0-9995",905,5},
  {{{0x790b001767c5fd25}},8,"F-H0-9996",936,2},
  {{{0x8103897f2e5414e6}},8,"F-H0-9997",615,2},
  {{{0x9288b10af9b2babe}},7,"F-H0-9998",910,6},
  {{{0x916fc605d79b5ac5}},7,"F-H0-9999",429,4},
  {{{0xbca8b5bc5c12f2c0}},9,"F-H0-10000",690,6},
  {{{0xd874bd7fd085c51f}},10,"F-H0-10001",826,3},
  {{{0x6b880f001fcd491d}},10,"F-H0-10002",948,3},
  {{{0x88ac75f911afe76a}},3,"F-H0-10003",456,9},
  {{{0xb36ade006bf1a2d}},5,"F-H0-10004",454,5},
  {{{0xa0a397b5e98bb05a}},5,"F-H0-10005",906,5},
  {{{0xfbc02447b86ee123}},4,"F-H0-10006",950,5},
  {{{0xb93a8db2432ab232}},3,"F-H0-10007",468,4},
  {{{0x1f1731c36ab252d6}},3,"F-H0-10008",949,3},
  {{{0x6bb3a8b13068c1e4}},5,"F-H0-10009",839,4},
  {{{0x689e541f9641b812}},5,"F-H0-10010",492,2},
  {{{0xb795c644ce22c37d}},3,"F-H0-10011",494,3},
  {{{0xb795c644ce22c37d}},3,"F-H0-10012",457,2},
  {{{0xb795c644ce22c37d}},3,"F-H0-10013",492,2},
  {{{0xbf0d0b65114835ef}},16,"F-H0-10014",800,7},
  {{{0xbf0d0b65114835ef}},16,"F-H0-10015",764,2},
  {{{0xb223b9538a596937}},12,"F-H0-10016",950,6},
  {{{0x46acd0084b1b8d34}},12,"F-H0-10017",529,2},
  {{{0x8f4ba15818f87a46}},9,"F-H0-10018",873,6},
  {{{0x4585e787b1363393}},5,"F-H0-10019",838,2},
  {{{0x4585e787b1363393}},5,"F-H0-10020",505,2},
  {{{0xd0c199eb06e41c71}},7,"F-H0-10021",939,6},
  {{{0xd0c199eb06e41c71}},7,"F-H0-10022",940,4},
  {{{0xdf0d8d424c460c96}},6,"F-H0-10023",690,5},
  {{{0xdf0d8d424c460c96}},6,"F-H0-10024",543,3},
  {{{0x1fc51a27c3c8562a}},3,"F-H0-10025",862,2},
  {{{0x7414405c846282ad}},3,"F-H0-10026",468,4},
  {{{0x7414405c846282ad}},3,"F-H0-10027",469,2},
  {{{0xa524e5bccd8d5f99}},5,"F-H0-10028",529,6},
  {{{0x934a9b5e64b711b7}},11,"F-H0-10029",872,4},
  {{{0x934a9b5e64b711b7}},11,"F-H0-10030",946,3},
  {{{0x61468ac2187abf1e}},7,"F-H0-10031",839,2},
  {{{0xd05cf4c053eafda7}},7,"F-H0-10032",617,2},
  {{{0xb09e0c59c495665f}},7,"F-H0-10033",943,2},
  {{{0x61468ac2187abf1e}},7,"F-H0-10034",825,2},
  {{{0xc5ca781f3442282f}},4,"F-H0-10035",900,4},
  {{{0xb18bba92e603e113}},4,"F-H0-10036",912,3},
  {{{0x68dca77c15444ade}},6,"F-H0-10037",714,5},
  {{{0x87e2f30be5431cd5}},7,"F-H0-10038",506,3},
  {{{0xec7e62479bc208ef}},7,"F-H0-10039",641,9},
  {{{0x96fd4ea087708c6f}},9,"F-H0-10040",503,10},
  {{{0xfeceacce9d5fa2bd}},7,"F-H0-10041",950,8},
  {{{0x800907aa1692002e}},5,"F-H0-10042",950,5},
  {{{0xce5a07a5906353e5}},15,"F-H0-10043",914,5},
  {{{0xce5a07a5906353e5}},15,"F-H0-10044",950,2},
  {{{0xc79aefd456e747bd}},5,"F-H0-10045",432,3},
  {{{0xc79aefd456e747bd}},5,"F-H0-10046",456,2},
  {{{0xf9897431d783f3bd}},6,"F-H0-10047",838,8},
  {{{0x2578d30dc88ce5fe}},12,"F-H0-10048",865,3},
  {{{0x2578d30dc88ce5fe}},12,"F-H0-10049",828,2},
  {{{0x934866d0d5554799}},7,"F-H0-10050",690,9},
  {{{0x3891d163a8226a14}},8,"F-H0-10051",567,6},
  {{{0x90074f223188ee7a}},8,"F-H0-10052",458,4},
  {{{0x9b9455162f85efa0}},7,"F-H0-10053",839,4},
  {{{0x65b60c6582951d84}},7,"F-H0-10054",949,2},
  {{{0x65b60c6582951d84}},7,"F-H0-10055",911,2},
  {{{0x96b8e02bc91d1852}},10,"F-H0-10056",899,2},
  {{{0xba843d6c97339d9d}},9,"F-H0-10057",911,3},
  {{{0x808d481a4477de17}},9,"F-H0-10058",788,2},
  {{{0x9168ca932fc3f1c1}},6,"F-H0-10059",902,4},
  {{{0x9168ca932fc3f1c1}},6,"F-H0-10060",715,2},
  {{{0xdbe7067a8a72222d}},9,"F-H0-10061",567,6},
  {{{0x8340a9deba13612e}},9,"F-H0-10062",580,2},
  {{{0x8e02e49c479231ef}},3,"F-H0-10063",456,8},
  {{{0xdfd170e0ae0f24d5}},10,"F-H0-10064",986,5},
  {{{0x84a508b49dffc81c}},10,"F-H0-10065",826,2},
  {{{0xdfd170e0ae0f24d5}},10,"F-H0-10066",876,2},
  {{{0x4d207b4a4b32cdd}},7,"F-H0-10067",824,3},
  {{{0xe344327873f958fd}},7,"F-H0-10068",913,4},
  {{{0xe344327873f958fd}},7,"F-H0-10069",987,4},
  {{{0x81bad7befab87149}},7,"F-H0-10070",456,2},
  {{{0x6260ba5a07dd4fee}},13,"F-H0-10071",420,6},
  {{{0x9b18e7e0433d85cb}},8,"F-H0-10072",466,5},
  {{{0x9b18e7e0433d85cb}},8,"F-H0-10073",529,3},
  {{{0xf799696a2c872d61}},8,"F-H0-10074",801,2},
  {{{0x88518d9d9cef2efb}},7,"F-H0-10075",542,5},
  {{{0x2dd8cdc78fab9d0c}},7,"F-H0-10076",542,4},
  {{{0x4f11f8929f101a99}},14,"F-H0-10077",985,6},
  {{{0xbd89db535c86070c}},4,"F-H0-10078",543,3},
  {{{0xdb1908fb1a322e18}},4,"F-H0-10079",420,3},
  {{{0xdb1908fb1a322e18}},4,"F-H0-10080",421,2},
  {{{0x9541f492c625358b}},10,"F-H0-10081",543,5},
  {{{0x79a174204d339093}},14,"F-H0-10082",948,5},
  {{{0x79a174204d339093}},14,"F-H0-10083",529,2},
  {{{0x76a9c3aa872f3cc1}},7,"F-H0-10084",863,5},
  {{{0x4ae98a9b86c1d81}},6,"F-H0-10085",839,8},
  {{{0x9835f06e399935c9}},12,"F-H0-10086",908,4},
  {{{0x147f537a32b38ded}},12,"F-H0-10087",458,4},
  {{{0x8b07d8095862811e}},13,"F-H0-10088",987,9},
  {{{0x7b088fa15cf9cfb3}},4,"F-H0-10089",876,5},
  {{{0x5a2dd10a3abef05d}},10,"F-H0-10090",876,5},
  {{{0x26eba977b9af860}},10,"F-H0-10091",494,3},
  {{{0xc54e3fbc07c8a0b6}},8,"F-H0-10092",467,8},
  {{{0x66b8ca2ebd9df5a5}},9,"F-H0-10093",898,4},
  {{{0x757f6e1419ebc894}},9,"F-H0-10094",690,4},
  {{{0x4a56f824c47e07b4}},7,"F-H0-10095",949,8},
  {{{0x710313ffefb55450}},6,"F-H0-10096",911,6},
  {{{0x710313ffefb55450}},6,"F-H0-10097",838,2},
  {{{0xd35c1b1644a3551a}},7,"F-H0-10098",944,7},
  {{{0x61f4864b18432c38}},9,"F-H0-10099",940,7},
  {{{0xf253ed6a42e4cf4e}},9,"F-H0-10100",947,2},
  {{{0x808a34db688a928b}},7,"F-H0-10101",418,5},
  {{{0xe546ee1ba6a8d444}},7,"F-H0-10102",905,2},
  {{{0x75982f622c8693d7}},4,"F-H0-10103",431,5},
  {{{0x75982f622c8693d7}},4,"F-H0-10104",876,4},
  {{{0x44e32f6943524a6e}},8,"F-H0-10105",459,5},
  {{{0x44e32f6943524a6e}},8,"F-H0-10106",532,4},
  {{{0xd0bc625f73e07836}},7,"F-H0-10107",763,2},
  {{{0xf911f349859c34a8}},9,"F-H0-10108",469,5},
  {{{0xf5a69fe9a71a1556}},5,"F-H0-10109",457,2},
  {{{0xf5a69fe9a71a1556}},5,"F-H0-10110",862,2},
  {{{0xf5a69fe9a71a1556}},5,"F-H0-10111",458,2},
  {{{0x678004821269b326}},8,"F-H0-10112",905,4},
  {{{0x7e473d407fd9ad44}},8,"F-H0-10113",943,3},
  {{{0xfbd8d9024ab19520}},8,"F-H0-10114",470,2},
  {{{0x7abd537855d0882}},8,"F-H0-10115",432,9},
  {{{0x96fc11b6c43dd10f}},12,"F-H0-10116",544,7},
  {{{0x43e36109a2b0d03a}},17,"F-H0-10117",986,8},
  {{{0x29af785a05e069f5}},7,"F-H0-10118",418,7},
  {{{0xa8da2f844499f36d}},7,"F-H0-10119",764,2},
  {{{0x578655b75933212c}},5,"F-H0-10120",943,4},
  {{{0x3406f468be049378}},5,"F-H0-10121",825,3},
  {{{0x79124957fd200619}},5,"F-H0-10122",677,2},
  {{{0x1192549a232e519e}},14,"F-H0-10123",979,4},
  {{{0x7c40ac3709e11279}},3,"F-H0-10124",432,4},
  {{{0x7c40ac3709e11279}},3,"F-H0-10125",469,2},
  {{{0xf5ce1d5af82da0a2}},16,"F-H0-10126",935,5},
  {{{0x95c75631825d0f7e}},16,"F-H0-10127",454,3},
  {{{0x1fdaf92a8608d348}},13,"F-H0-10128",543,9},
  {{{0xc6cb1c25a5802ff}},3,"F-H0-10129",456,6},
  {{{0xc7c4c615752a8578}},5,"F-H0-10130",430,5},
  {{{0x3542d268b12f46f3}},5,"F-H0-10131",460,3},
  {{{0x1fc33d4f89d7a989}},7,"F-H0-10132",690,5},
  {{{0x32ab56d2bcb959b1}},7,"F-H0-10133",825,3},
  {{{0x4fddf56629cd05dd}},8,"F-H0-10134",422,7},
  {{{0x4fddf56629cd05dd}},8,"F-H0-10135",421,3},
  {{{0x54a363bf602930ce}},11,"F-H0-10136",616,9},
  {{{0x6f95fb64ed70aa1}},16,"F-H0-10137",947,5},
  {{{0xaac6e35faa219302}},16,"F-H0-10138",826,2},
  {{{0x6027ec82c660911b}},15,"F-H0-10139",985,9},
  {{{0x133c3bf7ef7f4a44}},6,"F-H0-10140",875,3},
  {{{0x133c3bf7ef7f4a44}},6,"F-H0-10141",908,3},
  {{{0x133c3bf7ef7f4a44}},6,"F-H0-10142",909,2},
  {{{0xbb4b73114882374b}},16,"F-H0-10143",876,7},
  {{{0xbd94d732d715443d}},16,"F-H0-10144",503,2},
  {{{0xfcb1ec5abb9edf9d}},6,"F-H0-10145",876,7},
  {{{0x563a9fab273ebf5f}},6,"F-H0-10146",429,2},
  {{{0x9a93eeb3c21f60b4}},11,"F-H0-10147",826,4},
  {{{0x9a93eeb3c21f60b4}},11,"F-H0-10148",862,3},
  {{{0x85d53173d79e3a90}},5,"F-H0-10149",986,2},
  {{{0x7d90a6b9fa40c9c9}},18,"F-H0-10150",902,3},
  {{{0xcd1b776b864f1726}},5,"F-H0-10151",910,3},
  {{{0xcd1b776b864f1726}},5,"F-H0-10152",429,2},
  {{{0x8c617a739ab45529}},6,"F-H0-10153",939,2},
  {{{0xd722e9a41dc365e}},11,"F-H0-10154",428,7},
  {{{0x2f3bb93f7991577d}},11,"F-H0-10155",491,3},
  {{{0x1edddd362a1d69e7}},7,"F-H0-10156",939,4},
  {{{0xfb1ba929d944a433}},7,"F-H0-10157",936,3},
  {{{0xfb1ba929d944a433}},7,"F-H0-10158",865,2},
  {{{0x1939d4ccdd9ad942}},14,"F-H0-10159",877,9},
  {{{0x82f58f9777756b8b}},10,"F-H0-10160",691,4},
  {{{0x75cbb5e5a39ce825}},10,"F-H0-10161",427,2},
  {{{0x90f745a22255c6d}},10,"F-H0-10162",866,2},
  {{{0x26341679c0ab5555}},9,"F-H0-10163",469,10},
  {{{0x4ee7893ca17f5868}},5,"F-H0-10164",468,7},
  {{{0xf983476599c2b9fb}},14,"F-H0-10165",951,10},
  {{{0x6950be84b3504251}},11,"F-H0-10166",713,9},
  {{{0x2091f367ebdc2258}},8,"F-H0-10167",874,5},
  {{{0x2091f367ebdc2258}},8,"F-H0-10168",912,2},
  {{{0x2091f367ebdc2258}},8,"F-H0-10169",837,2},
  {{{0x2608a9103d29265a}},7,"F-H0-10170",874,9},
  {{{0xbba8c8b164815d15}},13,"F-H0-10171",838,5},
  {{{0x69a91960be051134}},13,"F-H0-10172",577,5},
  {{{0x7887c1e752e4b628}},5,"F-H0-10173",839,4},
  {{{0x7887c1e752e4b628}},5,"F-H0-10174",937,3},
  {{{0xaae0ac4d552ee6bd}},6,"F-H0-10175",421,8},
  {{{0x9175f314e9f067ab}},10,"F-H0-10176",684,2},
  {{{0x243c59278a63fa4}},6,"F-H0-10177",876,5},
  {{{0x70001636365ab79a}},6,"F-H0-10178",429,2},
  {{{0xfc581cab6f38682e}},9,"F-H0-10179",901,4},
  {{{0xdb8d0e1bd019e335}},9,"F-H0-10180",948,3},
  {{{0x26503f7e3956aa16}},9,"F-H0-10181",529,2},
  {{{0x1db83f57129a7bf5}},7,"F-H0-10182",826,7},
  {{{0x225585512ceb6b78}},7,"F-H0-10183",429,2},
  {{{0x2784285026d7f00e}},10,"F-H0-10184",838,8},
  {{{0xc892e789f97e83a6}},5,"F-H0-10185",469,5},
  {{{0xfbc628a9f3f4f5d3}},5,"F-H0-10186",423,2},
  {{{0x1302e097bd92375f}},5,"F-H0-10187",432,7},
  {{{0xaf0882b3d3cae3ca}},8,"F-H0-10188",838,3},
  {{{0xaf0882b3d3cae3ca}},8,"F-H0-10189",948,2},
  {{{0x4a662e48d7c9552}},6,"F-H0-10190",728,6},
  {{{0x8f5b99422859e793}},12,"F-H0-10191",936,2},
  {{{0x88254a2df426e513}},10,"F-H0-10192",871,4},
  {{{0xd42096a26e89c9fc}},12,"F-H0-10193",507,7},
  {{{0x125eb1078578db47}},8,"F-H0-10194",873,5},
  {{{0xe2472c96986de68d}},8,"F-H0-10195",395,2},
  {{{0x18926950c519d753}},5,"F-H0-10196",421,4},
  {{{0x18926950c519d753}},5,"F-H0-10197",950,3},
  {{{0xe3db8978719040ff}},4,"F-H0-10198",907,3},
  {{{0xe7d28bbcfff9b47a}},4,"F-H0-10199",431,2},
  {{{0x223912567be53ece}},17,"F-H0-10200",938,7},
  {{{0x8fc71deb7ca31f81}},17,"F-H0-10201",988,2},
  {{{0xc7bc2497c006c30f}},11,"F-H0-10202",946,9},
  {{{0x55d813a1c70f6587}},9,"F-H0-10203",458,7},
  {{{0x71bbd86c933488b7}},10,"F-H0-10204",827,7},
  {{{0x54fb430c66ed39ea}},10,"F-H0-10205",530,2},
  {{{0x84c3b661eac0b356}},9,"F-H0-10206",503,7},
  {{{0x92f185d593b3e4e2}},7,"F-H0-10207",865,6},
  {{{0x165f1837d86a9176}},6,"F-H0-10208",864,6},
  {{{0xbac7f5e513a4dbb1}},6,"F-H0-10209",912,2},
  {{{0xd27f49a02392786c}},5,"F-H0-10210",506,6},
  {{{0xd27f49a02392786c}},5,"F-H0-10211",505,2},
  {{{0x345f40e97b5f3ed6}},6,"F-H0-10212",529,8},
  {{{0x799e1e253b4d6582}},5,"F-H0-10213",506,2},
  {{{0x799e1e253b4d6582}},5,"F-H0-10214",466,2},
  {{{0xc9dc4b81c49dcdcd}},17,"F-H0-10215",947,9},
  {{{0xc2c31b8e0c151708}},5,"F-H0-10216",947,7},
  {{{0x49d72552850a3bc1}},12,"F-H0-10217",432,8},
  {{{0x3717d0cf6ffa251}},7,"F-H0-10218",801,4},
  {{{0xb25636560ba77156}},6,"F-H0-10219",944,2},
  {{{0x2d8113872c75dcb0}},10,"F-H0-10220",459,5},
  {{{0x6d6e4cb35051bc9}},10,"F-H0-10221",838,4},
  {{{0x7e4a6ebb53610354}},10,"F-H0-10222",396,4},
  {{{0x4f92dbffd4b29d5f}},10,"F-H0-10223",912,4},
  {{{0xb9ccc830abda8852}},5,"F-H0-10224",950,5},
  {{{0x10bd572d898a90c1}},5,"F-H0-10225",939,3},
  {{{0x488de64a9358e928}},10,"F-H0-10226",938,4},
  {{{0x41cd4f316906ea}},5,"F-H0-10227",419,5},
  {{{0xf0cf683adc4ba07c}},7,"F-H0-10228",825,4},
  {{{0x89306190680ce58d}},8,"F-H0-10229",902,3},
  {{{0x89306190680ce58d}},8,"F-H0-10230",827,2},
  {{{0x341455dedfb10cd4}},8,"F-H0-10231",945,2},
  {{{0x1e452873c341d801}},8,"F-H0-10232",495,7},
  {{{0x668518a72e05189e}},21,"F-H0-10233",825,4},
  {{{0x668518a72e05189e}},21,"F-H0-10234",542,2},
  {{{0xcac9e540c2e11b84}},20,"F-H0-10235",429,2},
  {{{0xc29af2125796ed74}},6,"F-H0-10236",506,6},
  {{{0x29b117ac54222163}},6,"F-H0-10237",421,2},
  {{{0x4fe02e10668a118f}},11,"F-H0-10238",904,3},
  {{{0x96315588d49443a5}},7,"F-H0-10239",504,6},
  {{{0x96315588d49443a5}},7,"F-H0-10240",466,2},
  {{{0x502dcf80e8bc0f8f}},4,"F-H0-10241",876,2},
  {{{0xbfd683e3272d8e02}},4,"F-H0-10242",543,2},
  {{{0x40590a3bc6b31419}},4,"F-H0-10243",455,2},
  {{{0xaee595e577c270ec}},16,"F-H0-10244",977,2},
  {{{0x323873b0457ef3c4}},7,"F-H0-10245",974,4},
  {{{0x901c8cf26c6bc55d}},5,"F-H0-10246",947,5},
  {{{0x901c8cf26c6bc55d}},5,"F-H0-10247",691,2},
  {{{0x7d378af523f7b852}},5,"F-H0-10248",947,2},
  {{{0xfbabbe1eebf521d5}},16,"F-H0-10249",914,5},
  {{{0xe4632d07389d4169}},16,"F-H0-10250",417,4},
  {{{0x7522dc09320340fa}},13,"F-H0-10251",985,8},
  {{{0x951b7533a04bcc6f}},4,"F-H0-10252",420,3},
  {{{0x5608c9fe63060e3f}},4,"F-H0-10253",462,2},
  {{{0x91a7e3686ca08bcd}},5,"F-H0-10254",912,3},
  {{{0xee2eb05b2b0adfd0}},7,"F-H0-10255",936,7},
  {{{0x93348fb532f02f3f}},9,"F-H0-10256",912,9},
  {{{0x6db51e8ee515c248}},11,"F-H0-10257",911,3},
  {{{0x6db51e8ee515c248}},11,"F-H0-10258",948,2},
  {{{0x42369309862cd460}},11,"F-H0-10259",421,2},
  {{{0x6bc2f4a5cdfe5863}},13,"F-H0-10260",867,3},
  {{{0xcec12dcbae54b85d}},10,"F-H0-10261",936,5},
  {{{0x60b43046dd73961b}},6,"F-H0-10262",455,9},
  {{{0xc2d35c431cc96e16}},5,"F-H0-10263",936,3},
  {{{0x3a6838dc4fb4a2d2}},20,"F-H0-10264",942,7},
  {{{0xe0242bdcfbab8102}},13,"F-H0-10265",914,6},
  {{{0x754ed7220be10a3d}},9,"F-H0-10266",949,4},
  {{{0xf60e4dd30b55783f}},7,"F-H0-10267",950,4},
  {{{0xf60e4dd30b55783f}},7,"F-H0-10268",763,2},
  {{{0xfee7e8d8382b294}},8,"F-H0-10269",825,5},
  {{{0x926fcd1542991b2d}},8,"F-H0-10270",691,2},
  {{{0x3f249574b9f77ca4}},2,"F-H0-10271",937,3},
  {{{0xeaf25530d1ede06a}},2,"F-H0-10272",901,2},
  {{{0xc1aafba300212cfa}},15,"F-H0-10273",951,9},
  {{{0xe3de5fe3e6cf19c4}},6,"F-H0-10274",873,7},
  {{{0x861b6e9168a77df5}},9,"F-H0-10275",950,5},
  {{{0xb6798d26c8ab9a45}},10,"F-H0-10276",865,7},
  {{{0xebd96e78c7555c18}},8,"F-H0-10277",908,2},
  {{{0xebd96e78c7555c18}},8,"F-H0-10278",946,2},
  {{{0xebd96e78c7555c18}},8,"F-H0-10279",948,2},
  {{{0xf7ceabb3a720f853}},4,"F-H0-10280",529,5},
  {{{0xf96544af828c2780}},4,"F-H0-10281",690,2},
  {{{0x7cf219260686c128}},8,"F-H0-10282",899,9},
  {{{0x1317e380e52d06e}},7,"F-H0-10283",938,4},
  {{{0x1317e380e52d06e}},7,"F-H0-10284",903,3},
  {{{0x7bf2273d4d435d44}},7,"F-H0-10285",825,6},
  {{{0xedb4b383b4e67e}},7,"F-H0-10286",913,2},
  {{{0x355b5574d2d49124}},9,"F-H0-10287",541,9},
  {{{0x43815945a3797ba2}},8,"F-H0-10288",947,4},
  {{{0x25a14ad98efc6255}},7,"F-H0-10289",839,4},
  {{{0xbe2318192d21d15d}},7,"F-H0-10290",946,3},
  {{{0xf012467bba51bfb1}},7,"F-H0-10291",944,5},
  {{{0xf012467bba51bfb1}},7,"F-H0-10292",906,3},
  {{{0x6fc35045c110a81e}},11,"F-H0-10293",911,2},
  {{{0x6fc35045c110a81e}},11,"F-H0-10294",948,2},
  {{{0xd3e2e7ebc824cb1}},11,"F-H0-10295",677,2},
  {{{0xad896e5d28b9585a}},5,"F-H0-10296",466,2},
  {{{0x5f3eea724f11438a}},5,"F-H0-10297",941,2},
  {{{0xad896e5d28b9585a}},5,"F-H0-10298",428,2},
  {{{0x424532073c875441}},11,"F-H0-10299",905,5},
  {{{0xae4da2c5588f18fa}},11,"F-H0-10300",491,7},
  {{{0xedc23b478f083ebe}},12,"F-H0-10301",466,7},
  {{{0xd3e6e6e6e550afeb}},12,"F-H0-10302",865,2},
  {{{0x999add802eea4767}},7,"F-H0-10303",530,8},
  {{{0x5b01b9d2082342d5}},6,"F-H0-10304",947,6},
  {{{0x52d473d7d7438de5}},6,"F-H0-10305",653,2},
  {{{0xcad64931aca97e20}},17,"F-H0-10306",615,5},
  {{{0xf35f3435f925fc44}},9,"F-H0-10307",503,9},
  {{{0x224d5a0f4bd2462e}},5,"F-H0-10308",506,4},
  {{{0x224d5a0f4bd2462e}},5,"F-H0-10309",505,3},
  {{{0x176de96febc9adfe}},1,"F-H0-10310",456,3},
  {{{0x6d2d46596d270c70}},1,"F-H0-10311",469,2},
  {{{0x2f99bf670c97c0a0}},4,"F-H0-10312",431,4},
  {{{0x2f99bf670c97c0a0}},4,"F-H0-10313",908,2},
  {{{0xf01e1eed707025a7}},11,"F-H0-10314",875,4},
  {{{0xb107b18628080918}},11,"F-H0-10315",948,3},
  {{{0x22d4285660fe165f}},12,"F-H0-10316",906,4},
  {{{0xe5fb253e73a2cc34}},5,"F-H0-10317",429,3},
  {{{0xe5fb253e73a2cc34}},5,"F-H0-10318",653,2},
  {{{0x8e3281424495de36}},5,"F-H0-10319",875,4},
  {{{0x585a4d8b149e6121}},6,"F-H0-10320",541,2},
  {{{0x585a4d8b149e6121}},6,"F-H0-10321",653,2},
  {{{0xbc7c062def2ab4fa}},4,"F-H0-10322",431,5},
  {{{0x1f05e752f69040bd}},10,"F-H0-10323",948,4},
  {{{0x1f05e752f69040bd}},10,"F-H0-10324",873,3},
  {{{0xf4b27e60f630ed60}},4,"F-H0-10325",419,2},
  {{{0x1b6916a56e5732d9}},5,"F-H0-10326",418,5},
  {{{0x1b6916a56e5732d9}},5,"F-H0-10327",456,2},
  {{{0x6845ef62d25d969e}},9,"F-H0-10328",432,2},
  {{{0x9145d1b02f62d84a}},7,"F-H0-10329",753,3},
  {{{0x8bcaff8ded7fa422}},7,"F-H0-10330",432,2},
  {{{0xf41eb7cbcf874f68}},7,"F-H0-10331",690,2},
  {{{0x9a02cbe35d6a6603}},9,"F-H0-10332",900,8},
  {{{0xcc46f432200fc1c5}},6,"F-H0-10333",826,4},
  {{{0xef088d727956f681}},6,"F-H0-10334",715,2},
  {{{0xf9e4c0ff3a5190ba}},6,"F-H0-10335",911,5},
  {{{0xf9e4c0ff3a5190ba}},6,"F-H0-10336",874,2},
  {{{0x530b6ffd580bfae2}},3,"F-H0-10337",456,3},
  {{{0x530b6ffd580bfae2}},3,"F-H0-10338",419,2},
  {{{0x8e0bb0459bc3a847}},3,"F-H0-10339",418,2},
  {{{0x3d7bd25df836c4f9}},10,"F-H0-10340",421,3},
  {{{0x3d7bd25df836c4f9}},10,"F-H0-10341",911,3},
  {{{0xbe8fad1358d70f5b}},10,"F-H0-10342",431,3},
  {{{0xbe8fad1358d70f5b}},10,"F-H0-10343",432,3},
  {{{0x77f339f2836fe02d}},11,"F-H0-10344",825,4},
  {{{0x9276e0367f9c06b2}},6,"F-H0-10345",690,3},
  {{{0x9276e0367f9c06b2}},6,"F-H0-10346",653,3},
  {{{0x9bc827952534a465}},7,"F-H0-10347",874,6},
  {{{0x2eee9e05becd7114}},5,"F-H0-10348",801,5},
  {{{0xce3ee11219fc21ff}},5,"F-H0-10349",949,2},
  {{{0x4652e8a566a27075}},5,"F-H0-10350",899,4},
  {{{0xc24590d0c6b1f991}},8,"F-H0-10351",899,6},
  {{{0xd0152e7b8c1013b5}},6,"F-H0-10352",421,9},
  {{{0xd1999b21c25abd7e}},4,"F-H0-10353",419,3},
  {{{0xd1999b21c25abd7e}},4,"F-H0-10354",457,2},
  {{{0x91f4aab127c5fded}},4,"F-H0-10355",469,2},
  {{{0xbb09cd6b8051e8f}},6,"F-H0-10356",837,5},
  {{{0xa775412c2d621293}},6,"F-H0-10357",872,2},
  {{{0x958afa1308987a9e}},6,"F-H0-10358",492,2},
  {{{0xa165bb1e2e54c0e6}},4,"F-H0-10359",906,3},
  {{{0x2f245bcf31752c6d}},3,"F-H0-10360",493,5},
  {{{0x4ea7fdcfbc4dffa9}},3,"F-H0-10361",913,2},
  {{{0x10f4f197202fc892}},10,"F-H0-10362",826,5},
  {{{0x6a7897584d0023a8}},10,"F-H0-10363",948,2},
  {{{0x2127a68f964f04cb}},4,"F-H0-10364",947,4},
  {{{0x9d7cda9da312ea64}},8,"F-H0-10365",899,9},
  {{{0x37e0d13a7ee36579}},18,"F-H0-10366",418,4},
  {{{0x5d8e45428c55e58b}},5,"F-H0-10367",947,2},
  {{{0x9a9ebbc514780be2}},7,"F-H0-10368",827,6},
  {{{0x9a9ebbc514780be2}},7,"F-H0-10369",939,2},
  {{{0x8a5a6c1777dbb94b}},7,"F-H0-10370",530,5},
  {{{0x1ceb1511d5b2632c}},4,"F-H0-10371",862,3},
  {{{0x17e804e34c356a91}},12,"F-H0-10372",948,3},
  {{{0x17e804e34c356a91}},12,"F-H0-10373",839,2},
  {{{0xad75cae9707f5519}},5,"F-H0-10374",617,4},
  {{{0x78993177142602b3}},5,"F-H0-10375",939,4},
  {{{0xdab6719035f58188}},20,"F-H0-10376",909,7},
  {{{0x4d488d1df8ce5d05}},4,"F-H0-10377",529,6},
  {{{0x4d488d1df8ce5d05}},4,"F-H0-10378",684,2},
  {{{0x71e799283fc56182}},7,"F-H0-10379",641,2},
  {{{0x71e799283fc56182}},7,"F-H0-10380",801,2},
  {{{0x71e799283fc56182}},7,"F-H0-10381",678,2},
  {{{0xac39ef9afcdc778e}},5,"F-H0-10382",943,4},
  {{{0xc7e1fd86060f48ac}},5,"F-H0-10383",825,2},
  {{{0x4b2327129243737}},3,"F-H0-10384",430,2},
  {{{0x4b2327129243737}},3,"F-H0-10385",912,2},
  {{{0xc006bc83a8fe89b8}},11,"F-H0-10386",875,4},
  {{{0xeb686af732fab3dd}},11,"F-H0-10387",910,2},
  {{{0x57fbb9a82f077db9}},13,"F-H0-10388",872,8},
  {{{0xe1793e8532ea19bf}},4,"F-H0-10389",937,3},
  {{{0x7e9d2a89f68aeca}},4,"F-H0-10390",419,2},
  {{{0x49f29eda3b195b00}},21,"F-H0-10391",762,6},
  {{{0xf204db2ccac1f8fa}},4,"F-H0-10392",420,4},
  {{{0xf204db2ccac1f8fa}},4,"F-H0-10393",457,2},
  {{{0xf570b8ca972c8459}},11,"F-H0-10394",383,5},
  {{{0xf570b8ca972c8459}},11,"F-H0-10395",419,2},
  {{{0xd0eae42531335473}},8,"F-H0-10396",419,6},
  {{{0x5456e02e823131b2}},5,"F-H0-10397",456,5},
  {{{0x98dd7a18f14424b8}},5,"F-H0-10398",427,2},
  {{{0x5b77606e19ce2ef4}},5,"F-H0-10399",902,2},
  {{{0x60376d14d912c2ea}},13,"F-H0-10400",470,7},
  {{{0xd724ce054c111618}},6,"F-H0-10401",505,2},
  {{{0x25d95df036763539}},6,"F-H0-10402",950,2},
  {{{0x39f52d1b5aa961ae}},6,"F-H0-10403",494,2},
  {{{0xe479a441e2312eea}},17,"F-H0-10404",427,8},
  {{{0xc686fea949b744a6}},13,"F-H0-10405",949,6},
  {{{0x7276aa97f7e047fb}},13,"F-H0-10406",911,2},
  {{{0xa6144453ffeabf25}},9,"F-H0-10407",873,7},
  {{{0xf408adffd7c1727f}},17,"F-H0-10408",986,2},
  {{{0x52e1dc2144becd1a}},11,"F-H0-10409",906,6},
  {{{0xe4225d5d68e1e972}},9,"F-H0-10410",986,4},
  {{{0xe4225d5d68e1e972}},9,"F-H0-10411",906,2},
  {{{0xcac3dc3a1b5a3710}},8,"F-H0-10412",789,5},
  {{{0x1d4bd9c8ce98f790}},8,"F-H0-10413",974,8},
  {{{0xfe15978d2dab3db6}},8,"F-H0-10414",567,4},
  {{{0x5c7778fcffd0635b}},8,"F-H0-10415",432,4},
  {{{0xc46343ed8489d75a}},15,"F-H0-10416",506,8},
  {{{0x233fcb5dbdadce12}},8,"F-H0-10417",605,6},
  {{{0xf5efd442566995db}},8,"F-H0-10418",801,3},
  {{{0x8ee8728e3c300116}},6,"F-H0-10419",914,4},
  {{{0xba5440720e59b0bc}},6,"F-H0-10420",863,4},
  {{{0xdd3659e94be6b897}},11,"F-H0-10421",465,7},
  {{{0x3eabe4290e619e29}},9,"F-H0-10422",903,8},
  {{{0x231d195d8922ed6d}},18,"F-H0-10423",537,2},
  {{{0x231d195d8922ed6d}},18,"F-H0-10424",499,2},
  {{{0x6b8c17d0b77c948c}},8,"F-H0-10425",899,5},
  {{{0xb39bbee76fc7ba37}},8,"F-H0-10426",913,2},
  {{{0x80fb82fc1150d048}},16,"F-H0-10427",430,4},
  {{{0x80fb82fc1150d048}},16,"F-H0-10428",581,2},
  {{{0xee3877b35b177331}},6,"F-H0-10429",949,7},
  {{{0xf9e276a55c354fad}},5,"F-H0-10430",947,3},
  {{{0xee524f54e6bf877f}},7,"F-H0-10431",491,6},
  {{{0xa25f4a7a1c9c22b9}},7,"F-H0-10432",419,2},
  {{{0xcef6c230b042e091}},7,"F-H0-10433",714,2},
  {{{0x22025d49ba77955a}},7,"F-H0-10434",466,2},
  {{{0xcef6c230b042e091}},7,"F-H0-10435",911,2},
  {{{0xc538225bff41b866}},13,"F-H0-10436",507,9},
  {{{0xf540c08a00f9ef4}},8,"F-H0-10437",382,5},
  {{{0xae1820de4cfd0403}},4,"F-H0-10438",901,3},
  {{{0xec3c2d40cc6d3efc}},4,"F-H0-10439",430,2},
  {{{0xc4a872dcce9f5323}},14,"F-H0-10440",543,2},
  {{{0xdf0457469055747}},14,"F-H0-10441",542,2},
  {{{0xc4a872dcce9f5323}},14,"F-H0-10442",457,2},
  {{{0x7948b09878530cbf}},12,"F-H0-10443",936,4},
  {{{0x7948b09878530cbf}},12,"F-H0-10444",867,2},
  {{{0x7948b09878530cbf}},12,"F-H0-10445",905,2},
  {{{0x18e662958e72c980}},9,"F-H0-10446",640,5},
  {{{0x18e662958e72c980}},9,"F-H0-10447",604,3},
  {{{0x159246733ed77f27}},5,"F-H0-10448",913,3},
  {{{0x159246733ed77f27}},5,"F-H0-10449",899,2},
  {{{0xba2e0ebe4bc80f04}},5,"F-H0-10450",911,3},
  {{{0xba2e0ebe4bc80f04}},5,"F-H0-10451",506,2},
  {{{0x4045a2d9d8f01169}},8,"F-H0-10452",947,3},
  {{{0x4045a2d9d8f01169}},8,"F-H0-10453",839,3},
  {{{0x4045a2d9d8f01169}},8,"F-H0-10454",431,3},
  {{{0xf0917a48f0101d5e}},11,"F-H0-10455",876,4},
  {{{0xb310dc6b1bb11303}},11,"F-H0-10456",936,3},
  {{{0xde17cfad457ffca9}},4,"F-H0-10457",937,4},
  {{{0x1c76dafa276fde75}},5,"F-H0-10458",421,2},
  {{{0x507fba2469d0f9c3}},8,"F-H0-10459",429,2},
  {{{0x507fba2469d0f9c3}},8,"F-H0-10460",457,2},
  {{{0xd930b2ab68e7b562}},7,"F-H0-10461",912,4},
  {{{0xd930b2ab68e7b562}},7,"F-H0-10462",874,4},
  {{{0xc2d1dff2f99b1bb8}},6,"F-H0-10463",542,4},
  {{{0x7683d56d98381bfc}},6,"F-H0-10464",429,3},
  {{{0x944bbe054cc9ed9f}},4,"F-H0-10465",429,3},
  {{{0xa3ad03e3b354fe4e}},4,"F-H0-10466",900,2},
  {{{0x51341410f091918e}},4,"F-H0-10467",902,2},
  {{{0x62873be6974a71f1}},11,"F-H0-10468",429,7},
  {{{0x62873be6974a71f1}},11,"F-H0-10469",467,2},
  {{{0x3ea0553ecfafd2b2}},19,"F-H0-10470",835,7},
  {{{0x6f8c7285d73e5394}},6,"F-H0-10471",939,2},
  {{{0x9ae9ff873faa46b2}},6,"F-H0-10472",690,2},
  {{{0x49997c7b6cca9a77}},2,"F-H0-10473",874,2},
  {{{0xb7d8e4b3638d3aa9}},6,"F-H0-10474",973,4},
  {{{0xbdeb111ef390416d}},11,"F-H0-10475",427,2},
  {{{0x7c20060b51c4dce7}},4,"F-H0-10476",937,5},
  {{{0xb33b12567af9866d}},7,"F-H0-10477",939,4},
  {{{0xb33b12567af9866d}},7,"F-H0-10478",949,2},
  {{{0xb33b12567af9866d}},7,"F-H0-10479",825,2},
  {{{0xefb92717b6177679}},11,"F-H0-10480",988,5},
  {{{0x6e03d882dc835aab}},11,"F-H0-10481",393,4},
  {{{0x8cc885be23828e48}},5,"F-H0-10482",911,3},
  {{{0x8cc885be23828e48}},5,"F-H0-10483",432,2},
  {{{0xe7a1d30dfb14bbf8}},5,"F-H0-10484",542,2},
  {{{0x5d88c72281e0dbb6}},14,"F-H0-10485",395,7},
  {{{0xc14e95ffbb58aa11}},5,"F-H0-10486",419,7},
  {{{0x70efaf5d25cba20}},10,"F-H0-10487",826,5},
  {{{0x691f83002159743c}},9,"F-H0-10488",543,8},
  {{{0xb0fd5824016bc42}},10,"F-H0-10489",421,9},
  {{{0x3fdaba1eae2ee42f}},15,"F-H0-10490",433,6},
  {{{0x5795c255068f58be}},8,"F-H0-10491",426,8},
  {{{0x195f2380d7ecd42e}},8,"F-H0-10492",951,4},
  {{{0x195f2380d7ecd42e}},8,"F-H0-10493",944,2},
  {{{0x195f2380d7ecd42e}},8,"F-H0-10494",714,2},
  {{{0xb1ee65396ec2534b}},6,"F-H0-10495",937,3},
  {{{0xb0b021b4f49cf59}},9,"F-H0-10496",913,3},
  {{{0x4650c6f1a708ada7}},14,"F-H0-10497",433,6},
  {{{0xe30641de63a0a91a}},6,"F-H0-10498",875,5},
  {{{0xe30641de63a0a91a}},6,"F-H0-10499",837,4},
  {{{0x61a8ac88b958ab9}},11,"F-H0-10500",974,5},
  {{{0x61a8ac88b958ab9}},11,"F-H0-10501",905,4},
  {{{0x7bf4f2b51e8a0797}},7,"F-H0-10502",566,8},
  {{{0xd4fec0e7fbc5738b}},8,"F-H0-10503",866,5},
  {{{0x9e2a8202905394e6}},7,"F-H0-10504",566,6},
  {{{0x9e2a8202905394e6}},7,"F-H0-10505",494,2},
  {{{0xee554fbc4e919063}},17,"F-H0-10506",950,5},
  {{{0x2e6c73fa54f44832}},17,"F-H0-10507",603,2},
  {{{0x45c35c1baf909aae}},14,"F-H0-10508",544,5},
  {{{0x45c35c1baf909aae}},14,"F-H0-10509",581,2},
  {{{0xcf5551a2fb6d519d}},20,"F-H0-10510",800,8},
  {{{0xd80ca4181e54bf59}},7,"F-H0-10511",567,4},
  {{{0x9a7e9eb4826a5197}},7,"F-H0-10512",910,2},
  {{{0x8fdf146bb40b92e0}},8,"F-H0-10513",902,5},
  {{{0x8fdf146bb40b92e0}},8,"F-H0-10514",939,2},
  {{{0x9a86c8f415d26156}},6,"F-H0-10515",432,6},
  {{{0x33ec08a0f7865ae3}},6,"F-H0-10516",865,2},
  {{{0x82f5cfc748f03069}},3,"F-H0-10517",468,4},
  {{{0xe9835d4a36a4a115}},3,"F-H0-10518",863,2},
  {{{0xa561c8762a84108a}},5,"F-H0-10519",543,2},
  {{{0xa561c8762a84108a}},5,"F-H0-10520",463,2},
  {{{0x4dee63672b283c31}},9,"F-H0-10521",825,3},
  {{{0x88ea327d4b14bf8d}},9,"F-H0-10522",677,2},
  {{{0x41670c6233f9b3ad}},15,"F-H0-10523",507,8},
  {{{0xad853d113d6c2228}},7,"F-H0-10524",825,7},
  {{{0xf6762a30b804f461}},10,"F-H0-10525",945,6},
  {{{0xf6762a30b804f461}},10,"F-H0-10526",908,2},
  {{{0xc7abc9553d3c736e}},17,"F-H0-10527",912,3},
  {{{0xc7abc9553d3c736e}},17,"F-H0-10528",874,2},
  {{{0xd92d80e3fea7c8a}},11,"F-H0-10529",504,9},
  {{{0x73c9d327b2a43e9b}},4,"F-H0-10530",468,2},
  {{{0xe585d8f732e5206a}},6,"F-H0-10531",839,3},
  {{{0x60773ccd29c56707}},6,"F-H0-10532",908,2},
  {{{0xedf2e101de20dffa}},7,"F-H0-10533",903,7},
  {{{0xa192af09cbafdf2}},12,"F-H0-10534",678,4},
  {{{0x268b71e0137a5e16}},12,"F-H0-10535",690,2},
  {{{0xa82c253c7a220b8f}},9,"F-H0-10536",899,5},
  {{{0xbc5b2d7fe4f228ba}},15,"F-H0-10537",951,8},
  {{{0x414c039dd580df63}},21,"F-H0-10538",832,3},
  {{{0x414c039dd580df63}},21,"F-H0-10539",566,2},
  {{{0x14b97255b718482c}},9,"F-H0-10540",973,4},
  {{{0x2c26d3a1d1d6f024}},5,"F-H0-10541",469,6},
  {{{0x19f9ac04f5b9c2da}},5,"F-H0-10542",911,2},
  {{{0x35ef35f92de647b3}},12,"F-H0-10543",529,3},
  {{{0xe5c0a54a3269d052}},13,"F-H0-10544",505,6},
  {{{0x89e1ef414d422598}},5,"F-H0-10545",469,5},
  {{{0x89e1ef414d422598}},5,"F-H0-10546",468,2},
  {{{0xb474b5ff487b31bc}},5,"F-H0-10547",946,3},
  {{{0x1d5df046de255b43}},5,"F-H0-10548",492,2},
  {{{0xb474b5ff487b31bc}},5,"F-H0-10549",838,2},
  {{{0x9f7036b9c16e1d35}},6,"F-H0-10550",541,5},
  {{{0x9f7036b9c16e1d35}},6,"F-H0-10551",432,3},
  {{{0xbaeedc448aeaaaec}},7,"F-H0-10552",910,7},
  {{{0xe24f4e253f8f17f4}},7,"F-H0-10553",459,2},
  {{{0x1730ee388741ca5c}},7,"F-H0-10554",543,2},
  {{{0x51eeb84526b1e778}},7,"F-H0-10555",421,2},
  {{{0x51eeb84526b1e778}},7,"F-H0-10556",420,2},
  {{{0x5c33cd302c6473a4}},16,"F-H0-10557",913,6},
  {{{0x5c33cd302c6473a4}},16,"F-H0-10558",837,2},
  {{{0xf7e66c28b7e28427}},6,"F-H0-10559",949,6},
  {{{0xf7e66c28b7e28427}},6,"F-H0-10560",951,2},
  {{{0x4f96d0d78f69d831}},5,"F-H0-10561",906,3},
  {{{0x9101878654ad401a}},4,"F-H0-10562",468,5},
  {{{0xf140d68aabb66b63}},4,"F-H0-10563",462,2},
  {{{0x89d27b2394f51861}},8,"F-H0-10564",541,9},
  {{{0x8fadb6cb46bd8c2}},5,"F-H0-10565",873,5},
  {{{0x8fadb6cb46bd8c2}},5,"F-H0-10566",874,2},
  {{{0x7bd01591c783b004}},8,"F-H0-10567",899,6},
  {{{0x9e1f52a1e0cf78b2}},8,"F-H0-10568",469,2},
  {{{0xa7d2ba17dadf02f}},11,"F-H0-10569",944,5},
  {{{0x457af9c28867d9dc}},12,"F-H0-10570",872,3},
  {{{0x9dbe917f4d6ca309}},6,"F-H0-10571",937,4},
  {{{0xd6613dd213ff7ec9}},11,"F-H0-10572",506,8},
  {{{0xe5dbf54810ae0c83}},18,"F-H0-10573",935,3},
  {{{0x5d9eaf27e6ec92ef}},18,"F-H0-10574",678,2},
  {{{0xba53814d1838c7b1}},8,"F-H0-10575",432,7},
  {{{0xd068a9869a78ec3f}},7,"F-H0-10576",865,5},
  {{{0xa1ea6847559ce29a}},7,"F-H0-10577",936,3},
  {{{0xbb54e63767bb4afb}},7,"F-H0-10578",762,2},
  {{{0xb7a1a9d8e0f3b46}},6,"F-H0-10579",908,3},
  {{{0x726f8ddb14307d46}},4,"F-H0-10580",541,3},
  {{{0x770905a888843161}},4,"F-H0-10581",457,2},
  {{{0x47dfbdc634795da1}},11,"F-H0-10582",910,6},
  {{{0x47dfbdc634795da1}},11,"F-H0-10583",950,2},
  {{{0x71c420515b45289f}},12,"F-H0-10584",902,4},
  {{{0x71c420515b45289f}},12,"F-H0-10585",976,2},
  {{{0x43a1849be643a6cd}},10,"F-H0-10586",910,4},
  {{{0x43a1849be643a6cd}},10,"F-H0-10587",874,2},
  {{{0xe4a75c042b4ab1f}},8,"F-H0-10588",837,6},
  {{{0x7570d7969a963993}},11,"F-H0-10589",876,3},
  {{{0x2b2d223e1849f722}},18,"F-H0-10590",947,3},
  {{{0x340f3063675a679f}},18,"F-H0-10591",751,3},
  {{{0xb6ffdd82fd0c7d6e}},9,"F-H0-10592",801,7},
  {{{0xd6f79fcc4a9905c5}},8,"F-H0-10593",714,7},
  {{{0x28561959f232a44c}},4,"F-H0-10594",419,2},
  {{{0x86239c081fdd2ca1}},4,"F-H0-10595",604,2},
  {{{0x86239c081fdd2ca1}},4,"F-H0-10596",492,2},
  {{{0x9553aaa7cbf6e2da}},6,"F-H0-10597",947,5},
  {{{0xaa6699020dcfc248}},9,"F-H0-10598",419,2},
  {{{0x532012f3be745db9}},17,"F-H0-10599",974,2},
  {{{0x1ff62764de0545c2}},10,"F-H0-10600",839,6},
  {{{0x3a647acea838b93a}},10,"F-H0-10601",948,2},
  {{{0x580c3706da0d7de3}},5,"F-H0-10602",950,4},
  {{{0x34c5c57f795062c1}},5,"F-H0-10603",827,3},
  {{{0xb0bb34c350e2c2e3}},8,"F-H0-10604",864,2},
  {{{0x2010483bc68a31b6}},8,"F-H0-10605",826,2},
  {{{0x784a1bae7900af54}},9,"F-H0-10606",873,6},
  {{{0x784a1bae7900af54}},9,"F-H0-10607",950,2},
  {{{0x3ffad3cd911857f3}},12,"F-H0-10608",904,3},
  {{{0xbc86b634dc3023f1}},12,"F-H0-10609",948,2},
  {{{0x9b9c8317bd58d138}},7,"F-H0-10610",455,7},
  {{{0x6347ca67e3f4ede2}},10,"F-H0-10611",729,5},
  {{{0x1150d5774bb73312}},6,"F-H0-10612",908,3},
  {{{0x1150d5774bb73312}},6,"F-H0-10613",946,2},
  {{{0x2192c2e13bbbbd27}},18,"F-H0-10614",947,3},
  {{{0xddf35c4562afc249}},18,"F-H0-10615",463,2},
  {{{0xd7e984f5dc852259}},5,"F-H0-10616",937,6},
  {{{0xce72324df8e425d5}},4,"F-H0-10617",468,3},
  {{{0x6415d43ab962f307}},4,"F-H0-10618",765,2},
  {{{0xd69251ae7950eac3}},4,"F-H0-10619",431,2},
  {{{0x637a39be28919681}},7,"F-H0-10620",690,9},
  {{{0xa7845e3e45a5f207}},6,"F-H0-10621",506,2},
  {{{0x9531bdd432ba8977}},14,"F-H0-10622",986,8},
  {{{0x6df3e3d1ce65dbb2}},10,"F-H0-10623",432,5},
  {{{0x6df3e3d1ce65dbb2}},10,"F-H0-10624",431,2},
  {{{0xff9585962acb23db}},8,"F-H0-10625",837,8},
  {{{0xb0cfb0002eba8529}},12,"F-H0-10626",470,6},
  {{{0x983658027198e76f}},9,"F-H0-10627",429,8},
  {{{0x1e97d1e0569e4dd7}},9,"F-H0-10628",936,6},
  {{{0xfe688b4089983c85}},7,"F-H0-10629",543,6},
  {{{0xfe688b4089983c85}},7,"F-H0-10630",580,2},
  {{{0x6ae3bcca74bcd750}},6,"F-H0-10631",454,2},
  {{{0xe0a44f714a67d7b5}},6,"F-H0-10632",426,2},
  {{{0x6d04a50b4cf83c4b}},6,"F-H0-10633",678,2},
  {{{0x31b176dc8269aac3}},4,"F-H0-10634",429,3},
  {{{0xb8af3b171b4d2ca4}},4,"F-H0-10635",640,2},
  {{{0x4b326688d33629e7}},6,"F-H0-10636",949,4},
  {{{0xf88c4e79a520cafb}},6,"F-H0-10637",935,3},
  {{{0x41dbdae5b4bc5007}},7,"F-H0-10638",949,7},
  {{{0xccbe9d639ee56d09}},7,"F-H0-10639",417,2},
  {{{0x233769fd5fbe85c3}},6,"F-H0-10640",529,3},
  {{{0x8c4bae85aeae802a}},6,"F-H0-10641",943,3},
  {{{0x233769fd5fbe85c3}},6,"F-H0-10642",678,2},
  {{{0x401bf4f060435b99}},9,"F-H0-10643",383,5},
  {{{0xa6ac3898757c81f}},6,"F-H0-10644",948,7},
  {{{0xbea86e4ab275aed}},8,"F-H0-10645",690,4},
  {{{0x2182029ecb7680e9}},8,"F-H0-10646",529,4},
  {{{0xda9954b5063be50f}},17,"F-H0-10647",422,6},
  {{{0x8d16278404eb9a89}},8,"F-H0-10648",417,2},
  {{{0x750f473b94398f09}},5,"F-H0-10649",431,4},
  {{{0x6eb35cb46ef552d4}},5,"F-H0-10650",424,2},
  {{{0x750f473b94398f09}},5,"F-H0-10651",943,2},
  {{{0x962e4d41c65f03a3}},5,"F-H0-10652",430,3},
  {{{0x962e4d41c65f03a3}},5,"F-H0-10653",911,2},
  {{{0x962e4d41c65f03a3}},5,"F-H0-10654",427,2},
  {{{0x35b4b2ca145927d0}},6,"F-H0-10655",462,3},
  {{{0x5ace9234a934af66}},5,"F-H0-10656",765,3},
  {{{0xc70b8133967f1be8}},5,"F-H0-10657",529,2},
  {{{0xc70b8133967f1be8}},5,"F-H0-10658",462,2},
  {{{0x722b7c22506e9aa4}},21,"F-H0-10659",867,6},
  {{{0x9618ed3ed60b969d}},11,"F-H0-10660",949,9},
  {{{0x4fcec607864b8016}},6,"F-H0-10661",837,8},
  {{{0x2a0b0b17e7f22476}},10,"F-H0-10662",604,2},
  {{{0xbd8137be7077be08}},10,"F-H0-10663",506,2},
  {{{0xf042f66fecee928}},10,"F-H0-10664",946,2},
  {{{0x5c97376c37e4a462}},6,"F-H0-10665",543,2},
  {{{0x5c97376c37e4a462}},6,"F-H0-10666",690,2},
  {{{0x752370b03f3381e5}},8,"F-H0-10667",690,2},
  {{{0xaf7da95ab6d28cd9}},8,"F-H0-10668",899,2},
  {{{0xaf7da95ab6d28cd9}},8,"F-H0-10669",790,2},
  {{{0x8392cb902f0104b}},7,"F-H0-10670",432,3},
  {{{0x8392cb902f0104b}},7,"F-H0-10671",825,2},
  {{{0x88d099d787fc9674}},7,"F-H0-10672",543,2},
  {{{0x22c8973d867c881a}},15,"F-H0-10673",837,2},
  {{{0x9bb0ffb424ea09fc}},15,"F-H0-10674",828,2},
  {{{0x1015e54af04e5c74}},11,"F-H0-10675",394,3},
  {{{0xb06c95be25eb4a40}},5,"F-H0-10676",874,4},
  {{{0x98071b0ac11debe6}},13,"F-H0-10677",433,8},
  {{{0x72c5977f70e0a2f2}},7,"F-H0-10678",690,3},
  {{{0xccb4fd681b0b9bab}},5,"F-H0-10679",863,7},
  {{{0x256dcea4084f7ca6}},10,"F-H0-10680",690,9},
  {{{0x54ebdaec4524f85c}},7,"F-H0-10681",566,4},
  {{{0x9e15f3f25b843e48}},22,"F-H0-10682",939,5},
  {{{0x9e15f3f25b843e48}},22,"F-H0-10683",751,2},
  {{{0x6402b6f333791fd4}},7,"F-H0-10684",864,4},
  {{{0x6402b6f333791fd4}},7,"F-H0-10685",862,4},
  {{{0x46c0c6d505165504}},2,"F-H0-10686",937,7},
  {{{0x958c637305298fc8}},9,"F-H0-10687",456,6},
  {{{0xb1fa299de69478f6}},3,"F-H0-10688",948,2},
  {{{0xb1fa299de69478f6}},3,"F-H0-10689",912,2},
  {{{0x763d9c0964bb8960}},11,"F-H0-10690",394,3},
  {{{0xf390681ca2fce70f}},3,"F-H0-10691",901,7},
  {{{0x61f4a01cf43f73fd}},6,"F-H0-10692",801,6},
  {{{0xe89bbf74aff85509}},11,"F-H0-10693",801,7},
  {{{0x24415ace75830554}},5,"F-H0-10694",529,9},
  {{{0xe5eab9bab2551acf}},12,"F-H0-10695",984,7},
  {{{0x1595cf63411b89e4}},5,"F-H0-10696",825,5},
  {{{0x54d4faa72b72a6d1}},5,"F-H0-10697",462,2},
  {{{0x542b27c1f3eb9e84}},7,"F-H0-10698",825,3},
  {{{0x542b27c1f3eb9e84}},7,"F-H0-10699",950,3},
  {{{0x542b27c1f3eb9e84}},7,"F-H0-10700",949,2},
  {{{0xa5246cc964edf555}},11,"F-H0-10701",429,6},
  {{{0x5ad4f4a23825dacd}},11,"F-H0-10702",457,3},
  {{{0xbc1ed1c20f5bcbdb}},15,"F-H0-10703",825,3},
  {{{0xbc1ed1c20f5bcbdb}},15,"F-H0-10704",939,3},
  {{{0x77d5e3eec70bc957}},10,"F-H0-10705",913,9},
  {{{0xb9faa616471a1a0}},10,"F-H0-10706",496,3},
  {{{0x3291900dd1d81b8c}},10,"F-H0-10707",940,3},
  {{{0x86207c735eb854a8}},5,"F-H0-10708",911,4},
  {{{0x832a499d48844d9a}},8,"F-H0-10709",543,4},
  {{{0xd1d126e5cb023a3a}},8,"F-H0-10710",541,2},
  {{{0xf917bbb84951ad6d}},11,"F-H0-10711",430,6},
  {{{0x5849a35e9201f16f}},11,"F-H0-10712",505,2},
  {{{0x3802b7508565f205}},5,"F-H0-10713",939,5},
  {{{0xd2ba75553461920e}},7,"F-H0-10714",419,6},
  {{{0x76f2df0b828e575}},7,"F-H0-10715",469,4},
  {{{0x555a0bab71b63e81}},7,"F-H0-10716",456,3},
  {{{0x555a0bab71b63e81}},7,"F-H0-10717",421,2},
  {{{0x92c687cb728d73c5}},7,"F-H0-10718",825,3},
  {{{0x9676b5789e2402b7}},12,"F-H0-10719",800,3},
  {{{0x4faf8148e6c03f4a}},12,"F-H0-10720",691,2},
  {{{0xfece0eedd908c302}},9,"F-H0-10721",457,6},
  {{{0xc952860be706c4f8}},7,"F-H0-10722",873,9},
  {{{0xe84457c0ff6bfad}},6,"F-H0-10723",914,3},
  {{{0xc99abd66f6186784}},6,"F-H0-10724",462,3},
  {{{0x1149df8a139c9b64}},6,"F-H0-10725",948,3},
  {{{0x1149df8a139c9b64}},6,"F-H0-10726",908,2},
  {{{0x1149df8a139c9b64}},6,"F-H0-10727",946,2},
  {{{0x98642defed272247}},6,"F-H0-10728",604,2},
  {{{0x98642defed272247}},6,"F-H0-10729",492,2},
  {{{0x546a8789b6bfa220}},10,"F-H0-10730",863,4},
  {{{0x4905cd819abd5cbb}},6,"F-H0-10731",941,5},
  {{{0x38805bb19e49bca0}},4,"F-H0-10732",911,3},
  {{{0xf918713e50ba23e1}},4,"F-H0-10733",493,2},
  {{{0xa5e0b72b8635e24b}},8,"F-H0-10734",678,2},
  {{{0x83ab05d9d39421de}},8,"F-H0-10735",868,2},
  {{{0x24dc1ff13cc0430}},8,"F-H0-10736",838,4},
  {{{0x24dc1ff13cc0430}},8,"F-H0-10737",910,3},
  {{{0x6cbb53808e5d4774}},11,"F-H0-10738",947,3},
  {{{0xcb9ea1f55ddd04ff}},4,"F-H0-10739",900,3},
  {{{0x85b34a07b4fbf881}},8,"F-H0-10740",465,7},
  {{{0xbbdd17d0efcd6127}},6,"F-H0-10741",541,5},
  {{{0xbbdd17d0efcd6127}},6,"F-H0-10742",432,2},
  {{{0x4d57591d6002ed98}},11,"F-H0-10743",986,4},
  {{{0x84bf945482e971a}},11,"F-H0-10744",677,3},
  {{{0xe4976f4cbd270229}},9,"F-H0-10745",910,5},
  {{{0xe4976f4cbd270229}},9,"F-H0-10746",469,2},
  {{{0x2fe2cdb859262200}},12,"F-H0-10747",909,4},
  {{{0x2fe2cdb859262200}},12,"F-H0-10748",907,2},
  {{{0x54862191a4fca8de}},18,"F-H0-10749",396,6},
  {{{0x54862191a4fca8de}},18,"F-H0-10750",391,3},
  {{{0xeb369cc12f7bdd56}},10,"F-H0-10751",945,7},
  {{{0x300ed71e214f3493}},7,"F-H0-10752",423,4},
  {{{0xa41ebcb83f68e65c}},7,"F-H0-10753",466,2},
  {{{0x8f19119973c19218}},10,"F-H0-10754",429,3},
  {{{0x1d4c763ca702fbd3}},10,"F-H0-10755",906,2},
  {{{0x6f9ce1e780597ed}},5,"F-H0-10756",863,3},
  {{{0x6f9ce1e780597ed}},5,"F-H0-10757",862,3},
  {{{0x6f9ce1e780597ed}},5,"F-H0-10758",654,2},
  {{{0x48e5e7be8925ba15}},5,"F-H0-10759",421,4},
  {{{0x48e5e7be8925ba15}},5,"F-H0-10760",677,3},
  {{{0xb77a1bbbb5f0ed37}},4,"F-H0-10761",913,3},
  {{{0x5e2b76778c3ecc93}},7,"F-H0-10762",430,2},
  {{{0xb372408c2ab175ad}},9,"F-H0-10763",493,8},
  {{{0xb6f0eabcbf249b66}},9,"F-H0-10764",419,2},
  {{{0xb4cfc32d7ef0c590}},5,"F-H0-10765",839,4},
  {{{0xb4cfc32d7ef0c590}},5,"F-H0-10766",943,2},
  {{{0xd2ee92fda5c0a1b4}},11,"F-H0-10767",973,4},
  {{{0xe24d7f54ec6eea6c}},11,"F-H0-10768",939,8},
  {{{0x82e64981008222c8}},10,"F-H0-10769",466,7},
  {{{0xcb209962999ae80c}},8,"F-H0-10770",458,6},
  {{{0xcb209962999ae80c}},8,"F-H0-10771",459,2},
  {{{0xbd1150aa96a69b16}},5,"F-H0-10772",419,6},
  {{{0xbd1150aa96a69b16}},5,"F-H0-10773",423,2},
  {{{0xc42e3115a10a4fa0}},13,"F-H0-10774",914,9},
  {{{0x801aebba969693f9}},5,"F-H0-10775",543,7},
  {{{0xb4f8718d46a8aeda}},8,"F-H0-10776",567,6},
  {{{0xdd8ff307c066d6d6}},6,"F-H0-10777",901,2},
  {{{0xae17bd61eedb032b}},5,"F-H0-10778",466,4},
  {{{0x4d8733774ea13b1e}},8,"F-H0-10779",419,9},
  {{{0x8bcb66e30573499d}},5,"F-H0-10780",468,4},
  {{{0xb5ffbdb64dfe08bb}},5,"F-H0-10781",529,3},
  {{{0x5b766235693ed463}},10,"F-H0-10782",979,8},
  {{{0x1612c4ab11b7182b}},8,"F-H0-10783",493,6},
  {{{0xf83bda594e3dd50f}},7,"F-H0-10784",942,3},
  {{{0xf83bda594e3dd50f}},7,"F-H0-10785",825,2},
  {{{0xcb2fd2e779e914ea}},14,"F-H0-10786",877,9},
  {{{0x9ef42e285171923b}},8,"F-H0-10787",727,5},
  {{{0x9ce3f6186f2e4db8}},12,"F-H0-10788",417,8},
  {{{0x8b116bae52014746}},11,"F-H0-10789",899,6},
  {{{0x9601db4ffcc0f3a5}},11,"F-H0-10790",950,3},
  {{{0xbd5de4f81cc27af8}},8,"F-H0-10791",432,5},
  {{{0xdf236a5e8adb5931}},8,"F-H0-10792",421,3},
  {{{0xe6d2126f37670df4}},8,"F-H0-10793",455,8},
  {{{0xa30f84dd509c672a}},7,"F-H0-10794",937,9},
  {{{0xd8c96e1d73d550da}},5,"F-H0-10795",939,2},
  {{{0x7aa17eeedafa378f}},5,"F-H0-10796",906,2},
  {{{0x351f63e7d2db5f1a}},6,"F-H0-10797",457,3},
  {{{0xd9a0f387755b3b45}},6,"F-H0-10798",467,3},
  {{{0x3a6b1bd68a0ddf92}},12,"F-H0-10799",429,3},
  {{{0x3a6b1bd68a0ddf92}},12,"F-H0-10800",947,3},
  {{{0x3a6b1bd68a0ddf92}},12,"F-H0-10801",765,2},
  {{{0x487fbbb69f04861a}},7,"F-H0-10802",455,9},
  {{{0x66290afb7baa8367}},16,"F-H0-10803",876,9},
  {{{0x7762219b7ec95b27}},10,"F-H0-10804",468,9},
  {{{0x2ceae626a6568e28}},7,"F-H0-10805",504,7},
  {{{0x2ceae626a6568e28}},7,"F-H0-10806",468,2},
  {{{0xc684b39768356b8}},22,"F-H0-10807",454,7},
  {{{0xc684b39768356b8}},22,"F-H0-10808",678,2},
  {{{0xeb3c238f2a384a6f}},6,"F-H0-10809",542,4},
  {{{0xeb3c238f2a384a6f}},6,"F-H0-10810",876,2},
  {{{0x991d0f0021068a93}},3,"F-H0-10811",864,2},
  {{{0x991d0f0021068a93}},3,"F-H0-10812",862,2},
  {{{0x991d0f0021068a93}},3,"F-H0-10813",899,2},
  {{{0xd3833812718648ee}},14,"F-H0-10814",395,8},
  {{{0xee1ab287997025}},12,"F-H0-10815",690,8},
  {{{0xe85b3bbe3e701971}},6,"F-H0-10816",948,2},
  {{{0x2fef160afed2b042}},6,"F-H0-10817",463,2},
  {{{0x8420aed56aa48cf5}},8,"F-H0-10818",975,4},
  {{{0x62f5c27c7c4f3ec0}},17,"F-H0-10819",428,8},
  {{{0x2b3418a958494d58}},13,"F-H0-10820",492,7},
  {{{0xaae789e073e97298}},9,"F-H0-10821",458,6},
  {{{0xa50d167b1a2441fb}},9,"F-H0-10822",789,2},
  {{{0x8a18e252d891173d}},7,"F-H0-10823",466,4},
  {{{0x8a18e252d891173d}},7,"F-H0-10824",542,3},
  {{{0x1cf32451d33e46c7}},7,"F-H0-10825",504,2},
  {{{0x5f8e71f0a60ac14d}},6,"F-H0-10826",466,7},
  {{{0x4604c4fef740bb7e}},6,"F-H0-10827",838,2},
  {{{0xcef5761eb33b1942}},8,"F-H0-10828",837,9},
  {{{0x7100468746696e08}},8,"F-H0-10829",530,7},
  {{{0xcc30c097185fa24d}},5,"F-H0-10830",466,5},
  {{{0xcc30c097185fa24d}},5,"F-H0-10831",430,2},
  {{{0x251df92ff0a24f6b}},7,"F-H0-10832",838,7},
  {{{0x1a8703db855ae649}},4,"F-H0-10833",505,4},
  {{{0x1c4c6fa2ad998885}},4,"F-H0-10834",948,3},
  {{{0xef0abf31144ad2ca}},10,"F-H0-10835",655,2},
  {{{0x3c72ca2dbf9875a3}},6,"F-H0-10836",940,3},
  {{{0x3c72ca2dbf9875a3}},6,"F-H0-10837",420,3},
  {{{0x3c72ca2dbf9875a3}},6,"F-H0-10838",457,2},
  {{{0xa517812eece1bf91}},7,"F-H0-10839",530,5},
  {{{0x4e5a28bf6294c131}},2,"F-H0-10840",456,3},
  {{{0x4e5a28bf6294c131}},2,"F-H0-10841",455,2},
  {{{0x4e5a28bf6294c131}},2,"F-H0-10842",419,2},
  {{{0xcbc251ecdc3cf428}},10,"F-H0-10843",905,2},
  {{{0xe42253e165c04e17}},10,"F-H0-10844",429,2},
  {{{0xcbc251ecdc3cf428}},10,"F-H0-10845",906,2},
  {{{0xcbc251ecdc3cf428}},10,"F-H0-10846",907,2},
  {{{0xf03ee7de623658}},5,"F-H0-10847",875,5},
  {{{0xa186cb601f598999}},7,"F-H0-10848",381,6},
  {{{0xbe3a41395d212d52}},16,"F-H0-10849",460,5},
  {{{0x2fd959115f069cae}},12,"F-H0-10850",911,9},
  {{{0x5cb0fadc4fbb0e2d}},5,"F-H0-10851",906,2},
  {{{0xc72ab1b3ddfa890}},11,"F-H0-10852",972,7},
  {{{0x8f117f9edfb5ef}},6,"F-H0-10853",936,4},
  {{{0x8f117f9edfb5ef}},6,"F-H0-10854",940,2},
  {{{0xab9c42caa715c611}},10,"F-H0-10855",506,4},
  {{{0xab9c42caa715c611}},10,"F-H0-10856",432,4},
  {{{0x3a5e8ce5a267dfa2}},7,"F-H0-10857",913,7},
  {{{0xcdfb045b98204615}},9,"F-H0-10858",529,2},
  {{{0xe3d0add59ecccac8}},8,"F-H0-10859",615,3},
  {{{0x76fd5cfb21614a02}},12,"F-H0-10860",506,2},
  {{{0x1b06c01c1bca058c}},4,"F-H0-10861",825,6},
  {{{0xf0ec36030342512c}},4,"F-H0-10862",419,2},
  {{{0xfea06fcb017ab5cd}},9,"F-H0-10863",503,9},
  {{{0xa8c77a334a569bac}},12,"F-H0-10864",874,4},
  {{{0xf18f53712dec5cf0}},6,"F-H0-10865",678,5},
  {{{0xeca7592fc8778c2f}},6,"F-H0-10866",458,5},
  {{{0xeca7592fc8778c2f}},6,"F-H0-10867",382,4},
  {{{0x3d61a46681e34732}},4,"F-H0-10868",456,5},
  {{{0x746b7c2f940f92e0}},4,"F-H0-10869",690,3},
  {{{0x62500e588951d608}},10,"F-H0-10870",454,8},
  {{{0x45d6b53f43f5820c}},10,"F-H0-10871",938,6},
  {{{0x9fed3b4481252cdf}},7,"F-H0-10872",418,4},
  {{{0x9fed3b4481252cdf}},7,"F-H0-10873",911,2},
  {{{0x1966d44b46ab58da}},7,"F-H0-10874",911,5},
  {{{0x1966d44b46ab58da}},7,"F-H0-10875",426,3},
  {{{0xdef70daf986e352}},12,"F-H0-10876",947,2},
  {{{0xd835fcaeca13163d}},14,"F-H0-10877",421,8},
  {{{0x541a68d5265dbae5}},6,"F-H0-10878",827,4},
  {{{0x731a9e8911972106}},6,"F-H0-10879",432,2},
  {{{0x37602549008491fd}},8,"F-H0-10880",945,2},
  {{{0x37602549008491fd}},8,"F-H0-10881",946,2},
  {{{0x37602549008491fd}},8,"F-H0-10882",909,2},
  {{{0x37602549008491fd}},8,"F-H0-10883",908,2},
  {{{0x5462dcd01cf4923d}},7,"F-H0-10884",504,7},
  {{{0x3a6ef004317492aa}},12,"F-H0-10885",824,6},
  {{{0x49cd4aca78f08922}},11,"F-H0-10886",493,4},
  {{{0x49cd4aca78f08922}},11,"F-H0-10887",529,2},
  {{{0xa6e8b136f1ea66d}},9,"F-H0-10888",946,7},
  {{{0xb5df4b97f54f11d3}},10,"F-H0-10889",542,3},
  {{{0x524a69bb94dee97d}},7,"F-H0-10890",677,3},
  {{{0x89cc4b8aa9739134}},7,"F-H0-10891",429,2},
  {{{0xf69e5d085af4d2c2}},5,"F-H0-10892",460,4},
  {{{0xf69e5d085af4d2c2}},5,"F-H0-10893",862,2},
  {{{0xd2fb8edab9dbcb7b}},7,"F-H0-10894",460,3},
  {{{0x1be79ebb575d4ad3}},7,"F-H0-10895",802,2},
  {{{0x601cd4a509104ca5}},7,"F-H0-10896",912,6},
  {{{0x8f0963df8d95a3f3}},7,"F-H0-10897",469,8},
  {{{0xff58645a1d279b68}},23,"F-H0-10898",394,6},
  {{{0x33cd832df209deda}},11,"F-H0-10899",507,8},
  {{{0xb344f9846b524d5e}},18,"F-H0-10900",945,7},
  {{{0x6a1b25dd30cbbfc4}},13,"F-H0-10901",429,5},
  {{{0x33cb91e86f69e77a}},5,"F-H0-10902",902,4},
  {{{0x33cb91e86f69e77a}},5,"F-H0-10903",429,2},
  {{{0x103a770f3eff6c4e}},17,"F-H0-10904",950,6},
  {{{0xf2bb3aa9ff15a29}},12,"F-H0-10905",467,7},
  {{{0x98ec87256398adee}},11,"F-H0-10906",939,3},
  {{{0x9aed1b2e32a60699}},7,"F-H0-10907",873,4},
  {{{0x9aed1b2e32a60699}},7,"F-H0-10908",617,3},
  {{{0x538bb8c217529c39}},6,"F-H0-10909",458,2},
  {{{0x538bb8c217529c39}},6,"F-H0-10910",462,2},
  {{{0x688c484f5e962a51}},18,"F-H0-10911",653,2},
  {{{0x688c484f5e962a51}},18,"F-H0-10912",429,2},
  {{{0xc6c188222943e7d6}},6,"F-H0-10913",839,5},
  {{{0x8d9389371b787136}},8,"F-H0-10914",945,4},
  {{{0x8d9389371b787136}},8,"F-H0-10915",874,2},
  {{{0x9f43c6b7913bbaf8}},8,"F-H0-10916",862,2},
  {{{0xb4ac89a35a0ee378}},7,"F-H0-10917",910,3},
  {{{0xb4ac89a35a0ee378}},7,"F-H0-10918",801,2},
  {{{0xc08132502e499318}},7,"F-H0-10919",947,6},
  {{{0x80b5730567cb3d92}},7,"F-H0-10920",566,2},
  {{{0x4c102e00a53bb90f}},6,"F-H0-10921",911,4},
  {{{0x7b001c2578316b76}},7,"F-H0-10922",801,6},
  {{{0xc183fabe9a8730aa}},6,"F-H0-10923",899,3},
  {{{0x17996f6120acf811}},6,"F-H0-10924",935,2},
  {{{0xc8222f1304d37418}},12,"F-H0-10925",433,8},
  {{{0x17dcdf7f77a73956}},6,"F-H0-10926",457,8},
  {{{0x304779782418bdb}},10,"F-H0-10927",910,5},
  {{{0x304779782418bdb}},10,"F-H0-10928",907,2},
  {{{0x5105522179b2e64f}},9,"F-H0-10929",873,8},
  {{{0xd4a869e4cc6ca944}},7,"F-H0-10930",911,3},
  {{{0xc497489131420953}},7,"F-H0-10931",492,2},
  {{{0xd4a869e4cc6ca944}},7,"F-H0-10932",825,2},
  {{{0x7c2ff75e6c018456}},15,"F-H0-10933",950,3},
  {{{0x50612e6243a5a513}},15,"F-H0-10934",529,2},
  {{{0x837bec08400a9886}},15,"F-H0-10935",867,8},
  {{{0x6a4b780860da7bfa}},6,"F-H0-10936",678,3},
  {{{0x6a4b780860da7bfa}},6,"F-H0-10937",457,2},
  {{{0xfd86429dcb8109ee}},9,"F-H0-10938",752,5},
  {{{0x563a0aa4369f52cb}},10,"F-H0-10939",456,4},
  {{{0xa46a416ab538e5c7}},10,"F-H0-10940",837,4},
  {{{0xa46a416ab538e5c7}},10,"F-H0-10941",875,3},
  {{{0xf70072de83c6f65e}},5,"F-H0-10942",617,3},
  {{{0xf70072de83c6f65e}},5,"F-H0-10943",466,2},
  {{{0xba1838cb1a0a9230}},10,"F-H0-10944",470,8},
  {{{0x7b4c706d69a79803}},7,"F-H0-10945",827,3},
  {{{0x689a005a8fb2379e}},10,"F-H0-10946",975,8},
  {{{0x5205b3dd711e7af}},10,"F-H0-10947",935,6},
  {{{0xe75ada76b582a7c1}},10,"F-H0-10948",911,2},
  {{{0xaa44a82c3e3e083e}},8,"F-H0-10949",864,6},
  {{{0x315abb7de6799629}},9,"F-H0-10950",428,3},
  {{{0x656d868aa8c8c834}},9,"F-H0-10951",901,2},
  {{{0x2884ad9145e12238}},15,"F-H0-10952",875,4},
  {{{0x2884ad9145e12238}},15,"F-H0-10953",876,2},
  {{{0x11a9d46b1027a013}},16,"F-H0-10954",429,5},
  {{{0x734440df82e72669}},7,"F-H0-10955",492,3},
  {{{0xcd8ca89afbd11583}},7,"F-H0-10956",943,2},
  {{{0xcd8ca89afbd11583}},7,"F-H0-10957",825,2},
  {{{0x7d11e4e786fda346}},9,"F-H0-10958",950,2},
  {{{0xd5fb06da19655b60}},11,"F-H0-10959",454,3},
  {{{0xb3118ce981bfc85a}},17,"F-H0-10960",907,5},
  {{{0x62f3e80583432e3a}},13,"F-H0-10961",581,4},
  {{{0x842c676aaeb2102c}},6,"F-H0-10962",874,5},
  {{{0x6c9a6df7c2e4e175}},8,"F-H0-10963",420,2},
  {{{0xf632b34ae493313d}},15,"F-H0-10964",862,4},
  {{{0xda6020312a9449b4}},15,"F-H0-10965",875,2},
  {{{0xf632b34ae493313d}},15,"F-H0-10966",530,2},
  {{{0x80e4ec9055b0d5af}},8,"F-H0-10967",751,4},
  {{{0xe4c1c5bdb5fec92a}},15,"F-H0-10968",947,5},
  {{{0x228188c9d3f99eaf}},5,"F-H0-10969",458,3},
  {{{0x2d27f373ace63ff6}},5,"F-H0-10970",839,3},
  {{{0x22a20fa3184d02c1}},14,"F-H0-10971",787,6},
  {{{0x90d7502e9613a567}},5,"F-H0-10972",911,4},
  {{{0x7649027b5386f9eb}},14,"F-H0-10973",826,3},
  {{{0x7649027b5386f9eb}},14,"F-H0-10974",751,3},
  {{{0xecf64f5cce7b6a33}},7,"F-H0-10975",467,3},
  {{{0x2431abea8ea08e9c}},7,"F-H0-10976",541,3},
  {{{0x6dde72fa5d83b656}},12,"F-H0-10977",825,5},
  {{{0x325734f7c97803a2}},10,"F-H0-10978",912,6},
  {{{0x703301987b380e71}},13,"F-H0-10979",453,7},
  {{{0x9d3a70d111de8a1e}},12,"F-H0-10980",764,5},
  {{{0x9d3a70d111de8a1e}},12,"F-H0-10981",691,3},
  {{{0xdfb663bced97b7bc}},6,"F-H0-10982",874,5},
  {{{0x162685eae2fd54ed}},4,"F-H0-10983",420,5},
  {{{0x825107e9ced74d14}},10,"F-H0-10984",949,4},
  {{{0x9e6226913b064827}},10,"F-H0-10985",837,3},
  {{{0xd08e213c4c3d18c}},14,"F-H0-10986",949,5},
  {{{0x7a24ddc97516479f}},13,"F-H0-10987",950,7},
  {{{0xd7e452295120a40d}},7,"F-H0-10988",458,5},
  {{{0xd7e452295120a40d}},7,"F-H0-10989",494,2},
  {{{0x6dea3de01d7a1e09}},6,"F-H0-10990",751,6},
  {{{0x2cd1f4fa142c1450}},9,"F-H0-10991",467,8},
  {{{0xb4bfaf50b237429f}},5,"F-H0-10992",943,5},
  {{{0xb4bfaf50b237429f}},5,"F-H0-10993",825,2},
  {{{0xe6d469d700e8dcf5}},11,"F-H0-10994",937,7},
  {{{0x6a2cca2c81357e5}},7,"F-H0-10995",838,3},
  {{{0xa7b67f6350206ecf}},7,"F-H0-10996",504,2},
  {{{0x8cc5eeca8a45a765}},12,"F-H0-10997",800,3},
  {{{0x22b32d4fc9273e39}},12,"F-H0-10998",789,2},
  {{{0xaa2447dc87bcac80}},9,"F-H0-10999",643,4},
  {{{0xaa2447dc87bcac80}},9,"F-H0-11000",492,2},
  {{{0x41960093edec80d5}},11,"F-H0-11001",827,5},
  {{{0x1705bf5623bc43ef}},7,"F-H0-11002",909,4},
  {{{0x6aeb262963946fe4}},5,"F-H0-11003",505,6},
  {{{0xca7e02718597f480}},8,"F-H0-11004",940,4},
  {{{0xca7e02718597f480}},8,"F-H0-11005",864,2},
  {{{0xe614227a2804d849}},13,"F-H0-11006",566,6},
  {{{0x688ceafb686141c3}},15,"F-H0-11007",910,7},
  {{{0x6e8bbd18af83c51f}},7,"F-H0-11008",950,5},
  {{{0x39f6bd5d89d70c3c}},7,"F-H0-11009",501,3},
  {{{0xbe67cb0b88908e83}},11,"F-H0-11010",469,7},
  {{{0x61187a21b381b7be}},13,"F-H0-11011",492,8},
  {{{0x300d7593cdd5ea51}},6,"F-H0-11012",910,5},
  {{{0xbfd24b9c263cc3f}},10,"F-H0-11013",690,5},
  {{{0x748c18c4c3ca910c}},10,"F-H0-11014",677,2},
  {{{0xcf6d228ea0cda5f0}},13,"F-H0-11015",506,7},
  {{{0x54dfe32f816a1ee2}},7,"F-H0-11016",837,5},
  {{{0x54dfe32f816a1ee2}},7,"F-H0-11017",947,3},
  {{{0x5b5da4e5c87349a4}},12,"F-H0-11018",506,6},
  {{{0x5bb58c687d4e2d8c}},12,"F-H0-11019",421,2},
  {{{0xf88e3090aec82783}},10,"F-H0-11020",654,4},
  {{{0x6085911aa55d4d5b}},9,"F-H0-11021",421,5},
  {{{0x26c01f1f882f324}},11,"F-H0-11022",873,7},
  {{{0x6d1ecc0111ccd0f6}},12,"F-H0-11023",541,4},
  {{{0x4ea97cbb4046cd44}},4,"F-H0-11024",862,4},
  {{{0x7036baa73689697}},4,"F-H0-11025",839,2},
  {{{0x3a9ed926ee6f953c}},12,"F-H0-11026",874,6},
  {{{0x91578be7ccbff8fb}},9,"F-H0-11027",939,3},
  {{{0xa675c1295e592aa9}},9,"F-H0-11028",543,3},
  {{{0x74c9a1af04c534c3}},12,"F-H0-11029",902,3},
  {{{0x74c9a1af04c534c3}},12,"F-H0-11030",939,2},
  {{{0x908e676afc6a019c}},8,"F-H0-11031",419,8},
  {{{0xa8f143afe9ccb362}},5,"F-H0-11032",908,2},
  {{{0xce2cee3d2192e4fb}},5,"F-H0-11033",580,2},
  {{{0xe85119b7982e5596}},6,"F-H0-11034",874,7},
  {{{0x1b7e5ca02497b70a}},14,"F-H0-11035",429,8},
  {{{0xf1eb2e076960f5b9}},4,"F-H0-11036",431,2},
  {{{0xcf88d5b18dde7b77}},4,"F-H0-11037",901,2},
  {{{0x6e4d17efd97e136c}},8,"F-H0-11038",690,4},
  {{{0x6e4d17efd97e136c}},8,"F-H0-11039",653,2},
  {{{0x321bcbcf793957e6}},8,"F-H0-11040",908,3},
  {{{0x321bcbcf793957e6}},8,"F-H0-11041",909,2},
  {{{0x321bcbcf793957e6}},8,"F-H0-11042",874,2},
  {{{0x8966f57232a13d41}},10,"F-H0-11043",914,6},
  {{{0x5195c35f0df43c93}},13,"F-H0-11044",492,7},
  {{{0x5082783a6beb6d7}},6,"F-H0-11045",567,6},
  {{{0x7510ae25e122c4e4}},11,"F-H0-11046",943,4},
  {{{0x7510ae25e122c4e4}},11,"F-H0-11047",904,3},
  {{{0xa30a8c08c721100a}},6,"F-H0-11048",836,4},
  {{{0x2eabc0943b701a44}},7,"F-H0-11049",728,4},
  {{{0x7b6ecb83b7e9e788}},15,"F-H0-11050",947,4},
  {{{0x14cd84552a39f8a6}},13,"F-H0-11051",863,2},
  {{{0xc64298d381605107}},13,"F-H0-11052",824,2},
  {{{0xcb0f4075a0455eb3}},11,"F-H0-11053",529,4},
  {{{0xcb0f4075a0455eb3}},11,"F-H0-11054",425,2},
  {{{0xe8ea7789c2fd1006}},6,"F-H0-11055",503,6},
  {{{0x1442757cdeb85fa}},6,"F-H0-11056",432,2},
  {{{0xad8b28467177d7cb}},10,"F-H0-11057",387,5},
  {{{0x33c33edbcee3384f}},4,"F-H0-11058",431,3},
  {{{0x33c33edbcee3384f}},4,"F-H0-11059",862,2},
  {{{0xa6235c3851f2a858}},14,"F-H0-11060",947,3},
  {{{0x1024f2dc5e2ddd34}},14,"F-H0-11061",939,3},
  {{{0xe3e38f3d2664f9a9}},9,"F-H0-11062",944,7},
  {{{0x53e69c16fa723}},5,"F-H0-11063",430,2},
  {{{0xaf0406018734b197}},5,"F-H0-11064",825,2},
  {{{0x9b702330d8eb64c2}},8,"F-H0-11065",419,8},
  {{{0x29815cb7c553006b}},21,"F-H0-11066",392,6},
  {{{0x3eb8f4a6e79c69e3}},8,"F-H0-11067",419,7},
  {{{0x9d3c3e2f8506d89d}},5,"F-H0-11068",943,3},
  {{{0x836a140ce1167b24}},5,"F-H0-11069",939,2},
  {{{0x8d4630c74c8bbec1}},9,"F-H0-11070",529,7},
  {{{0xb5650501fb174499}},7,"F-H0-11071",950,5},
  {{{0xb5650501fb174499}},7,"F-H0-11072",837,3},
  {{{0x51a2739c6868977f}},4,"F-H0-11073",914,2},
  {{{0xd196c300c364ab9}},4,"F-H0-11074",900,2},
  {{{0xaf613a522610a949}},5,"F-H0-11075",420,3},
  {{{0x28528a99a206b2fd}},5,"F-H0-11076",788,2},
  {{{0x7fad6f1d73e385c2}},5,"F-H0-11077",911,3},
  {{{0x3a5a0db73e0107eb}},4,"F-H0-11078",839,3},
  {{{0xe009ea78122a7053}},4,"F-H0-11079",839,2},
  {{{0xe009ea78122a7053}},4,"F-H0-11080",421,2},
  {{{0xdcec4a7af6f12034}},6,"F-H0-11081",875,2},
  {{{0xdcec4a7af6f12034}},6,"F-H0-11082",908,2},
  {{{0xdcec4a7af6f12034}},6,"F-H0-11083",909,2},
  {{{0x96ff9e94e6d2d270}},10,"F-H0-11084",426,5},
  {{{0x96ff9e94e6d2d270}},10,"F-H0-11085",467,2},
  {{{0xe177db13b30440ff}},5,"F-H0-11086",529,2},
  {{{0x20a8f5d9c5a492be}},5,"F-H0-11087",690,2},
  {{{0xc0a8295ee7113622}},9,"F-H0-11088",432,6},
  {{{0x6574b1e0bd168008}},8,"F-H0-11089",431,8},
  {{{0xba07c121b6f583c0}},16,"F-H0-11090",839,4},
  {{{0xb90ae6cbdb674f49}},15,"F-H0-11091",951,8},
  {{{0x62aeb8dd47c5ffd0}},13,"F-H0-11092",839,2},
  {{{0x84a7914cca0169d2}},18,"F-H0-11093",382,2},
  {{{0x7eebbd8645160bab}},18,"F-H0-11094",461,2},
  {{{0x9d03d0e29ad314eb}},6,"F-H0-11095",469,5},
  {{{0xeba3b78cffe5e361}},12,"F-H0-11096",838,7},
  {{{0x33be35ed0238ae80}},10,"F-H0-11097",503,2},
  {{{0xa386420f41846fa8}},7,"F-H0-11098",455,7},
  {{{0x7c3e1d5e33d3be2d}},7,"F-H0-11099",678,6},
  {{{0xe461c04db347e21c}},11,"F-H0-11100",491,8},
  {{{0xe293f4a10cdf4087}},20,"F-H0-11101",877,4},
  {{{0x756d5c239df78c5c}},11,"F-H0-11102",604,3},
  {{{0x503fad25af9d8f09}},6,"F-H0-11103",495,4},
  {{{0x48bf96e330a962f3}},6,"F-H0-11104",950,3},
  {{{0x74b6524cd2d3ccb0}},6,"F-H0-11105",906,2},
  {{{0x9bac205331c01949}},10,"F-H0-11106",825,3},
  {{{0x9bac205331c01949}},10,"F-H0-11107",826,3},
  {{{0x189cb28e37712958}},7,"F-H0-11108",543,5},
  {{{0x33df8c41a0f38ffd}},7,"F-H0-11109",690,5},
  {{{0xa8d10d973f90c28f}},7,"F-H0-11110",715,2},
  {{{0xb44d22068d9b91e6}},5,"F-H0-11111",911,4},
  {{{0xb44d22068d9b91e6}},5,"F-H0-11112",948,2},
  {{{0xc6bf0a345ae6ba10}},15,"F-H0-11113",939,4},
  {{{0xd81b8caed35bc40a}},15,"F-H0-11114",825,2},
  {{{0x501f7b87a19676d}},13,"F-H0-11115",913,4},
  {{{0x4b463a4107370c13}},8,"F-H0-11116",418,2},
  {{{0xd7981f9c700088a7}},8,"F-H0-11117",463,2},
  {{{0xeb04cf759b43da08}},11,"F-H0-11118",417,7},
  {{{0x4382f498ade8ea97}},8,"F-H0-11119",539,3},
  {{{0x75145fdb2ab07c05}},9,"F-H0-11120",427,4},
  {{{0x3e58ce67d9cd1bb1}},9,"F-H0-11121",950,2},
  {{{0xba9d9261e3d6bddb}},7,"F-H0-11122",943,2},
  {{{0xba9d9261e3d6bddb}},7,"F-H0-11123",801,2},
  {{{0x5d4df52249b0a89c}},12,"F-H0-11124",580,4},
  {{{0x5d4df52249b0a89c}},12,"F-H0-11125",825,2},
  {{{0x72f2a3caa499b7e5}},7,"F-H0-11126",469,7},
  {{{0xfb7bdd62b68e46ea}},12,"F-H0-11127",950,8},
  {{{0xac4f700798cbddfc}},8,"F-H0-11128",690,3},
  {{{0xac4f700798cbddfc}},8,"F-H0-11129",543,2},
  {{{0x75debbf189868367}},7,"F-H0-11130",899,4},
  {{{0x9f6778cb6f62f485}},10,"F-H0-11131",470,7},
  {{{0xec21e80b71a32da3}},5,"F-H0-11132",642,2},
  {{{0xec21e80b71a32da3}},5,"F-H0-11133",862,2},
  {{{0xc942a03d68e1c1d1}},16,"F-H0-11134",947,3},
  {{{0xffb681cb92087383}},16,"F-H0-11135",802,2},
  {{{0x63f37b350d3df4d1}},7,"F-H0-11136",418,4},
  {{{0x5b9c64faa4713da9}},10,"F-H0-11137",432,5},
  {{{0x88dfa3ca96be15fe}},10,"F-H0-11138",941,2},
  {{{0x8d58a42edc01302a}},9,"F-H0-11139",456,6},
  {{{0x4d9ab0ca214dc186}},5,"F-H0-11140",910,2},
  {{{0xe27a6be9d15684ec}},5,"F-H0-11141",948,2},
  {{{0xfb27cbc6f550075d}},3,"F-H0-11142",543,4},
  {{{0xe343cce287d8530}},10,"F-H0-11143",907,2},
  {{{0xbc7630298e44e167}},3,"F-H0-11144",456,3},
  {{{0xbc7630298e44e167}},3,"F-H0-11145",429,2},
  {{{0xe2e90658845653e}},9,"F-H0-11146",418,5},
  {{{0x6c21e08e519a16b5}},5,"F-H0-11147",529,3},
  {{{0xcc76a7558f1ec3c5}},9,"F-H0-11148",912,8},
  {{{0x4697eddd13584d6}},5,"F-H0-11149",464,2},
  {{{0x4697eddd13584d6}},5,"F-H0-11150",428,2},
  {{{0xe9f3f7481dd445eb}},10,"F-H0-11151",912,2},
  {{{0x9c947927c80939c1}},6,"F-H0-11152",465,3},
  {{{0xc381387025d73c69}},6,"F-H0-11153",468,2},
  {{{0xa55a65ea78cbf19b}},19,"F-H0-11154",948,8},
  {{{0x17fe61225666a706}},8,"F-H0-11155",911,7},
  {{{0xd4e2a26601a3e9d4}},6,"F-H0-11156",862,6},
  {{{0x85f6fff187bf124b}},7,"F-H0-11157",864,6},
  {{{0x68b7612f397a8736}},7,"F-H0-11158",912,2},
  {{{0xa43748c5764e5243}},12,"F-H0-11159",939,8},
  {{{0x830788b790edc278}},3,"F-H0-11160",913,2},
  {{{0x830788b790edc278}},3,"F-H0-11161",874,2},
  {{{0x9d34bc0269aac04e}},16,"F-H0-11162",943,7},
  {{{0x791bf2cd42b10a}},8,"F-H0-11163",945,4},
  {{{0x17a57755c6c5a2ff}},8,"F-H0-11164",802,2},
  {{{0x8474cdf7eec67f21}},8,"F-H0-11165",949,6},
  {{{0xb01495dc117985ca}},6,"F-H0-11166",862,3},
  {{{0x9fb115ca9b6f98e0}},5,"F-H0-11167",467,2},
  {{{0x66194a3ab708f793}},5,"F-H0-11168",902,2},
  {{{0xf8456902a92bb1ac}},5,"F-H0-11169",506,2},
  {{{0xca8df9ccc0df3c8d}},4,"F-H0-11170",462,2},
  {{{0x783511cf4bc07d81}},14,"F-H0-11171",653,7},
  {{{0x131bf88898842e23}},5,"F-H0-11172",460,5},
  {{{0x8a966367e15c914c}},12,"F-H0-11173",905,5},
  {{{0xa94220d53e9f2e3}},5,"F-H0-11174",943,4},
  {{{0xecc5dca461af6470}},9,"F-H0-11175",873,6},
  {{{0x69f80e3ae6d0dc0b}},12,"F-H0-11176",433,7},
  {{{0x906cacdc1cfa1672}},8,"F-H0-11177",902,8},
  {{{0x7ee7cf808e8cc8d7}},6,"F-H0-11178",432,6},
  {{{0xfd4c88f46b86f66e}},8,"F-H0-11179",946,6},
  {{{0xde4d7d7a8333605f}},15,"F-H0-11180",568,2},
  {{{0x96901fd949cfeddc}},6,"F-H0-11181",420,3},
  {{{0x96901fd949cfeddc}},6,"F-H0-11182",429,2},
  {{{0x96901fd949cfeddc}},6,"F-H0-11183",543,2},
  {{{0xb8e604cb1e8806cf}},10,"F-H0-11184",429,3},
  {{{0xb8e604cb1e8806cf}},10,"F-H0-11185",543,2},
  {{{0xb277e523a4de0a5c}},10,"F-H0-11186",529,2},
  {{{0x2cdc55215f0bdb25}},17,"F-H0-11187",836,2},
  {{{0x9496790e14bed2f}},7,"F-H0-11188",542,4},
  {{{0xe779814aeaad5680}},7,"F-H0-11189",465,2},
  {{{0x6543d2d70346e32}},4,"F-H0-11190",419,2},
  {{{0x6543d2d70346e32}},4,"F-H0-11191",875,2},
  {{{0x8a0fec833ef4d71c}},12,"F-H0-11192",910,8},
  {{{0xce0ca0fc461ffebc}},9,"F-H0-11193",455,7},
  {{{0x1480c1f9d7e03397}},9,"F-H0-11194",899,6},
  {{{0x20f2dd76da03504a}},11,"F-H0-11195",909,6},
  {{{0xf71dca7a9090efa2}},9,"F-H0-11196",417,4},
  {{{0xf662310453cd0f44}},6,"F-H0-11197",690,5},
  {{{0xf662310453cd0f44}},6,"F-H0-11198",543,2},
  {{{0x42a71bf3ed65eb44}},8,"F-H0-11199",901,7},
  {{{0xb83c7f649f59ac0a}},6,"F-H0-11200",876,3},
  {{{0x43cf38447236ef1e}},6,"F-H0-11201",945,2},
  {{{0x43cf7243bf7ff2ff}},1,"F-H0-11202",468,6},
  {{{0x37b3a27066cec44b}},8,"F-H0-11203",948,3},
  {{{0xa08758a9c30cc544}},16,"F-H0-11204",945,3},
  {{{0xa08758a9c30cc544}},16,"F-H0-11205",910,2},
  {{{0x17e7203ded8ab665}},9,"F-H0-11206",419,8},
  {{{0x67e81eca6e73185e}},9,"F-H0-11207",875,2},
  {{{0x4bd18249a9f24a99}},7,"F-H0-11208",900,6},
  {{{0xd14b021400bbdc77}},9,"F-H0-11209",467,7},
  {{{0xa2365167c9b5337e}},7,"F-H0-11210",458,2},
  {{{0x74701d91719d9167}},13,"F-H0-11211",946,4},
  {{{0xf86748b95341eb29}},4,"F-H0-11212",641,2},
  {{{0xa09255d5c3e79109}},10,"F-H0-11213",800,2},
  {{{0xa09255d5c3e79109}},10,"F-H0-11214",837,2},
  {{{0x1c8291d5e073e699}},11,"F-H0-11215",907,3},
  {{{0xf36f30cbb4b5c407}},11,"F-H0-11216",911,2},
  {{{0xe39090dd513d470}},7,"F-H0-11217",825,3},
  {{{0xe39090dd513d470}},7,"F-H0-11218",943,2},
  {{{0xf5ddb2e28af3ce6c}},19,"F-H0-11219",837,4},
  {{{0xf5ddb2e28af3ce6c}},19,"F-H0-11220",838,2},
  {{{0x6252361a3a6a8a5b}},9,"F-H0-11221",911,7},
  {{{0xdb4cbd1413af7727}},9,"F-H0-11222",491,7},
  {{{0xcaf0b329c63f91d2}},13,"F-H0-11223",984,8},
  {{{0x79d935fdd98541be}},10,"F-H0-11224",492,3},
  {{{0x6affeb9dfdb16c31}},10,"F-H0-11225",942,2},
  {{{0x7be1020cfdb9169}},10,"F-H0-11226",752,2},
  {{{0xcb523ddff055daa7}},7,"F-H0-11227",943,3},
  {{{0xab218f26e67b6a69}},7,"F-H0-11228",939,3},
  {{{0xcb523ddff055daa7}},7,"F-H0-11229",825,2},
  {{{0x3ea74652c0d8a817}},4,"F-H0-11230",901,6},
  {{{0x650857c3c22ddd1b}},8,"F-H0-11231",824,6},
  {{{0x9acc4cf8031ba8d1}},6,"F-H0-11232",678,4},
  {{{0x9acc4cf8031ba8d1}},6,"F-H0-11233",641,2},
  {{{0x437857fc0a48b7fe}},7,"F-H0-11234",469,5},
  {{{0x441479dcfc2ac7af}},12,"F-H0-11235",433,7},
  {{{0x1597ec1ec3f61fd9}},20,"F-H0-11236",391,7},
  {{{0x4401853fdbf6d9fb}},9,"F-H0-11237",457,7},
  {{{0x5ffa02b7b369b6c2}},6,"F-H0-11238",530,2},
  {{{0xf7cad3e9163074fb}},6,"F-H0-11239",839,6},
  {{{0x22bb34cf6b8e3422}},6,"F-H0-11240",456,2},
  {{{0xd4ec79330d326931}},11,"F-H0-11241",491,7},
  {{{0x648735ade8768d52}},17,"F-H0-11242",912,8},
  {{{0xf4293b7cc35ce603}},3,"F-H0-11243",467,3},
  {{{0xa4f6b319d6906e6c}},3,"F-H0-11244",467,2},
  {{{0xf4293b7cc35ce603}},3,"F-H0-11245",418,2},
  {{{0xd3a8cc6a6bf2ed8e}},10,"F-H0-11246",838,6},
  {{{0xded2fd671fb93a}},9,"F-H0-11247",912,8},
  {{{0x25dc585d4d951abc}},2,"F-H0-11248",467,2},
  {{{0x25dc585d4d951abc}},2,"F-H0-11249",876,2},
  {{{0xe2b8f619e074767}},16,"F-H0-11250",428,7},
  {{{0x98f8754c3fa69ed5}},13,"F-H0-11251",506,5},
  {{{0x6e321876f11dd634}},16,"F-H0-11252",802,3},
  {{{0xa5b7dbb80e157c35}},16,"F-H0-11253",862,2},
  {{{0x11b9c6153d8f0375}},10,"F-H0-11254",753,2},
  {{{0xfca09fb76354c740}},3,"F-H0-11255",468,2},
  {{{0x84104df0ab5081b5}},10,"F-H0-11256",458,3},
  {{{0x1a038c710d4904af}},10,"F-H0-11257",801,3},
  {{{0x84104df0ab5081b5}},10,"F-H0-11258",543,2},
  {{{0x1dd1d42c1e2c8b7b}},9,"F-H0-11259",825,5},
  {{{0xc510c9b037e312c0}},9,"F-H0-11260",940,2},
  {{{0x398cb2579b0d8694}},8,"F-H0-11261",839,2},
  {{{0xc1bb1e9bedc9b0d}},10,"F-H0-11262",948,4},
  {{{0x819dcef6d88a4fee}},10,"F-H0-11263",864,4},
  {{{0xf64bb71096069f08}},8,"F-H0-11264",944,4},
  {{{0x3d3242fa8a3e63ad}},7,"F-H0-11265",492,2},
  {{{0x3d3242fa8a3e63ad}},7,"F-H0-11266",530,2},
  {{{0x81809dbd7c2b0d51}},7,"F-H0-11267",494,4},
  {{{0xf8c27ec318ace772}},5,"F-H0-11268",863,2},
  {{{0x4c47f40230b7766d}},5,"F-H0-11269",493,2},
  {{{0xec5edbecd01c35bd}},5,"F-H0-11270",902,2},
  {{{0x36433fc07ac93b3d}},16,"F-H0-11271",901,2},
  {{{0x9ddb3838e915c12c}},16,"F-H0-11272",690,2},
  {{{0xeb319f8bd5cb9e03}},11,"F-H0-11273",431,6},
  {{{0x4add04e85b22b75a}},9,"F-H0-11274",900,7},
  {{{0x748c3c41658352d6}},9,"F-H0-11275",457,8},
  {{{0x51c7fae40acf8f20}},18,"F-H0-11276",875,6},
  {{{0x7463edc0ebc7b231}},16,"F-H0-11277",836,6},
  {{{0xfb9cdae77ab4c098}},11,"F-H0-11278",491,3},
  {{{0xfb9cdae77ab4c098}},11,"F-H0-11279",461,2},
  {{{0xfb9cdae77ab4c098}},11,"F-H0-11280",425,2},
  {{{0x3ac48554812781b8}},8,"F-H0-11281",912,8},
  {{{0xfac118922c8437a5}},13,"F-H0-11282",825,4},
  {{{0x8bf476528389fc68}},13,"F-H0-11283",423,2},
  {{{0xa538ac6ed5f2c62a}},3,"F-H0-11284",456,3},
  {{{0xa538ac6ed5f2c62a}},3,"F-H0-11285",901,2},
  {{{0x33ecb79563d6807d}},9,"F-H0-11286",949,3},
  {{{0x33ecb79563d6807d}},9,"F-H0-11287",801,3},
  {{{0xf26bdfe23574b4ee}},5,"F-H0-11288",839,3},
  {{{0x6cb9b8812f903b47}},5,"F-H0-11289",943,2},
  {{{0xeae825dabd6147c}},8,"F-H0-11290",945,2},
  {{{0x9ef6cca58c427b8f}},8,"F-H0-11291",837,8},
  {{{0xef0522dbc1819abb}},7,"F-H0-11292",429,4},
  {{{0xef0522dbc1819abb}},7,"F-H0-11293",653,2},
  {{{0x81aca1cf72b1805b}},13,"F-H0-11294",506,8},
  {{{0x745ae15ea2298449}},4,"F-H0-11295",765,3},
  {{{0xeebc18af101297fc}},4,"F-H0-11296",431,2},
  {{{0xaa70eab38cf55279}},4,"F-H0-11297",942,3},
  {{{0xd88e80b193a24b8d}},4,"F-H0-11298",467,2},
  {{{0xe11a039d8a12ecbb}},13,"F-H0-11299",938,2},
  {{{0xc7db5052cc02eb03}},13,"F-H0-11300",906,7},
  {{{0x5f7cef61e7fa28ed}},5,"F-H0-11301",973,3},
  {{{0x5f7cef61e7fa28ed}},5,"F-H0-11302",974,2},
  {{{0xe547e85df3b4eb45}},10,"F-H0-11303",906,7},
  {{{0x9f7cc369d00250e1}},6,"F-H0-11304",603,2},
  {{{0x13ed6b464b05ca1b}},14,"F-H0-11305",429,7},
  {{{0x3320260fd68c2732}},24,"F-H0-11306",543,7},
  {{{0x79db93a1fa62cbbc}},10,"F-H0-11307",430,2},
  {{{0xa492e045e1cbc359}},10,"F-H0-11308",418,2},
  {{{0xa492e045e1cbc359}},10,"F-H0-11309",455,2},
  {{{0x8e18164fb8af8126}},8,"F-H0-11310",910,4},
  {{{0x4c4f01918ddce7e4}},8,"F-H0-11311",751,3},
  {{{0x506506e94f0978be}},4,"F-H0-11312",505,2},
  {{{0x9a67a5fc665735b3}},9,"F-H0-11313",873,3},
  {{{0xc307c83d79ebfbda}},9,"F-H0-11314",910,2},
  {{{0xc307c83d79ebfbda}},9,"F-H0-11315",950,2},
  {{{0x538cc54fbaeb406c}},11,"F-H0-11316",578,5},
  {{{0xe58084095d81ee05}},4,"F-H0-11317",876,4},
  {{{0xa591af0ea26f305d}},4,"F-H0-11318",826,2},
  {{{0xd6fa3f116366ff1c}},8,"F-H0-11319",942,5},
  {{{0x3b05b2dd39447438}},11,"F-H0-11320",839,4},
  {{{0x9760d9400b21333a}},7,"F-H0-11321",946,6},
  {{{0xe4495ba87be9927d}},7,"F-H0-11322",529,2},
  {{{0x4703b4e389e5562c}},10,"F-H0-11323",948,3},
  {{{0x4703b4e389e5562c}},10,"F-H0-11324",836,3},
  {{{0x7ef4938899460346}},12,"F-H0-11325",580,4},
  {{{0x58349285191396f3}},5,"F-H0-11326",839,7},
  {{{0x28ae82fa589bc5cf}},4,"F-H0-11327",939,3},
  {{{0xa1308ca10c48fe31}},5,"F-H0-11328",462,3},
  {{{0xa1308ca10c48fe31}},5,"F-H0-11329",943,2},
  {{{0x506074c3c1b6ea18}},15,"F-H0-11330",717,2},
  {{{0x18930bc7cf672d3}},11,"F-H0-11331",947,5},
  {{{0x92b474f01866925d}},3,"F-H0-11332",912,4},
  {{{0x92b474f01866925d}},3,"F-H0-11333",469,3},
  {{{0xbe9bce2d834446a7}},14,"F-H0-11334",421,8},
  {{{0xc91a24c91ac9c198}},5,"F-H0-11335",874,2},
  {{{0xc91a24c91ac9c198}},5,"F-H0-11336",873,2},
  {{{0xc02f0b1cee518eae}},7,"F-H0-11337",950,4},
  {{{0xc2dd5c83f4c4fadf}},7,"F-H0-11338",752,2},
  {{{0xb529232312784132}},6,"F-H0-11339",466,5},
  {{{0x96c5797788cb8a57}},4,"F-H0-11340",418,5},
  {{{0xa2b23be942d0d9b}},9,"F-H0-11341",950,3},
  {{{0xb9d4efb4ff5c556b}},9,"F-H0-11342",862,3},
  {{{0x5b1b10920e0154f4}},7,"F-H0-11343",947,3},
  {{{0x235106e8dd2ae7ec}},7,"F-H0-11344",567,2},
  {{{0x91526e7e5851f142}},9,"F-H0-11345",789,4},
  {{{0x89c386514e95494d}},12,"F-H0-11346",431,8},
  {{{0xcaeec90af24b2539}},8,"F-H0-11347",875,8},
  {{{0x82fd4bcaf6b03958}},7,"F-H0-11348",837,3},
  {{{0x6ae07748e8d58650}},7,"F-H0-11349",950,3},
  {{{0x3ebd59e28d615c96}},10,"F-H0-11350",470,8},
  {{{0x102af68b8d4e98e1}},12,"F-H0-11351",908,5},
  {{{0x102af68b8d4e98e1}},12,"F-H0-11352",939,3},
  {{{0x186dfc80b62c6505}},12,"F-H0-11353",678,2},
  {{{0xd374c71ec41c5e70}},5,"F-H0-11354",910,3},
  {{{0x9b47df108bad1754}},5,"F-H0-11355",432,2},
  {{{0xd5bc3f1313377ff5}},5,"F-H0-11356",939,2},
  {{{0xd7bf9455b973f365}},3,"F-H0-11357",456,5},
  {{{0xd7bf9455b973f365}},3,"F-H0-11358",912,2},
  {{{0xf02e025e5912eac0}},7,"F-H0-11359",801,2},
  {{{0x9a2a85e904bc515}},2,"F-H0-11360",912,2},
  {{{0x9a2a85e904bc515}},2,"F-H0-11361",468,2},
  {{{0xff9d2ffb819a2b62}},7,"F-H0-11362",946,8},
  {{{0x91c3fdeee99ae2fe}},17,"F-H0-11363",802,3},
  {{{0x91c3fdeee99ae2fe}},17,"F-H0-11364",839,2},
  {{{0x4df202feb871fc47}},10,"F-H0-11365",495,4},
  {{{0x87544d29e2834}},10,"F-H0-11366",542,2},
  {{{0xf91f1fb8dc3ccf0a}},9,"F-H0-11367",531,7},
  {{{0x5a4267c96c090cba}},7,"F-H0-11368",825,2},
  {{{0xdbaf9e330c82adb9}},5,"F-H0-11369",425,4},
  {{{0x86586449606c548}},5,"F-H0-11370",825,2},
  {{{0xc183db9c57c5c4c3}},8,"F-H0-11371",678,5},
  {{{0xe7acf72cca8559a5}},8,"F-H0-11372",825,2},
  {{{0x80f7c0790979ef67}},11,"F-H0-11373",507,8},
  {{{0xdd35cd5eff6a7312}},3,"F-H0-11374",912,2},
  {{{0xdd35cd5eff6a7312}},3,"F-H0-11375",949,2},
  {{{0xdd35cd5eff6a7312}},3,"F-H0-11376",875,2},
  {{{0xc812be3f108884db}},8,"F-H0-11377",567,5},
  {{{0x40313e5031cdea16}},10,"F-H0-11378",943,3},
  {{{0x40313e5031cdea16}},10,"F-H0-11379",421,2},
  {{{0x3e011ca051ffd1bf}},14,"F-H0-11380",429,7},
  {{{0xfdaf7d99f992e60}},9,"F-H0-11381",873,4},
  {{{0xfdaf7d99f992e60}},9,"F-H0-11382",950,3},
  {{{0xe763df259ff3a26e}},3,"F-H0-11383",875,3},
  {{{0x1eb7e687c3ac43c7}},3,"F-H0-11384",493,2},
  {{{0x854e1468afeb98f0}},9,"F-H0-11385",653,3},
  {{{0xeb65f179595ffd9f}},7,"F-H0-11386",530,4},
  {{{0x190453174c240403}},5,"F-H0-11387",825,3},
  {{{0x190453174c240403}},5,"F-H0-11388",727,2},
  {{{0x400bf1e0c87ee6bd}},8,"F-H0-11389",431,7},
  {{{0x5b76c566cc45e98e}},18,"F-H0-11390",939,3},
  {{{0x5b76c566cc45e98e}},18,"F-H0-11391",715,2},
  {{{0x4c70659ce3f6331b}},11,"F-H0-11392",678,5},
  {{{0x9019c3b9dd2540df}},11,"F-H0-11393",691,2},
  {{{0x21b6b8796634eae6}},10,"F-H0-11394",837,5},
  {{{0x185991a80f3c0348}},6,"F-H0-11395",944,3},
  {{{0xc79496f3626bc58f}},6,"F-H0-11396",788,2},
  {{{0xb302d5c71580a62d}},10,"F-H0-11397",714,5},
  {{{0x33699952c795cad6}},10,"F-H0-11398",904,2},
  {{{0x26f9eeeeda92659a}},11,"F-H0-11399",430,8},
  {{{0x9d9197a9ec6b1103}},5,"F-H0-11400",421,2},
  {{{0x6043e6ec38a483b2}},5,"F-H0-11401",418,2},
  {{{0xc22bf61f918be4e7}},5,"F-H0-11402",913,2},
  {{{0x6fe81a6ddecefe8e}},12,"F-H0-11403",877,2},
  {{{0x14f70bc8d581a749}},14,"F-H0-11404",751,3},
  {{{0x14f70bc8d581a749}},14,"F-H0-11405",875,2},
  {{{0x7e51b7cd65276b0d}},10,"F-H0-11406",948,8},
  {{{0x7229b0ca947ed4e9}},5,"F-H0-11407",505,5},
  {{{0x7229b0ca947ed4e9}},5,"F-H0-11408",542,2},
  {{{0xcc53dbd1ea0cdca8}},4,"F-H0-11409",949,2},
  {{{0x4741c02a1a52461b}},4,"F-H0-11410",876,3},
  {{{0x113cd26935671b9c}},12,"F-H0-11411",500,5},
  {{{0x63f3debfcf8ec13e}},17,"F-H0-11412",421,4},
  {{{0x1b6025473e1071b3}},5,"F-H0-11413",908,4},
  {{{0x1b6025473e1071b3}},5,"F-H0-11414",946,2},
  {{{0x3296e29b89c1b1e6}},13,"F-H0-11415",506,8},
  {{{0x7026a17ca043517b}},12,"F-H0-11416",455,7},
  {{{0xbb328b35af5b1b94}},13,"F-H0-11417",840,6},
  {{{0x8b718b61dedede5b}},13,"F-H0-11418",864,2},
  {{{0xab02dc763c8c757e}},16,"F-H0-11419",951,8},
  {{{0xd70a5797cbe331c4}},7,"F-H0-11420",868,3},
  {{{0x7c3657216626487c}},13,"F-H0-11421",506,7},
  {{{0x43dbb6dad15ee13f}},12,"F-H0-11422",543,2},
  {{{0x43dbb6dad15ee13f}},12,"F-H0-11423",907,2},
  {{{0x8670682924cb6a43}},11,"F-H0-11424",950,3},
  {{{0xe5d078df67e48f04}},8,"F-H0-11425",421,7},
  {{{0x1f0bb0088ab53dc}},8,"F-H0-11426",876,5},
  {{{0x40a68e7c35944759}},11,"F-H0-11427",947,8},
  {{{0x3b0d76c27996dcc1}},10,"F-H0-11428",910,6},
  {{{0x51ec2ef8379210b}},10,"F-H0-11429",503,2},
  {{{0xd3d07b310f46e114}},7,"F-H0-11430",542,2},
  {{{0x182c403651a94116}},7,"F-H0-11431",690,2},
  {{{0xdcbd3fdc0b5f866b}},11,"F-H0-11432",690,4},
  {{{0x6de0882d2c55adb6}},11,"F-H0-11433",504,7},
  {{{0xf286d6257f174f64}},10,"F-H0-11434",419,8},
  {{{0x701699f5eae65fce}},9,"F-H0-11435",580,6},
  {{{0x85bc393cd17e2399}},17,"F-H0-11436",867,5},
  {{{0xa004e0b9de3e7e94}},10,"F-H0-11437",938,5},
  {{{0xa004e0b9de3e7e94}},10,"F-H0-11438",788,2},
  {{{0x4c0239d7d4b108f1}},10,"F-H0-11439",950,7},
  {{{0x576f1458d464c2cb}},10,"F-H0-11440",876,3},
  {{{0x576f1458d464c2cb}},10,"F-H0-11441",838,2},
  {{{0x4154e8bdf5e46fd1}},8,"F-H0-11442",941,3},
  {{{0xbe58d202d9be9bfc}},8,"F-H0-11443",902,2},
  {{{0xe24deb75fd80b601}},12,"F-H0-11444",493,4},
  {{{0x417771d3a958150}},12,"F-H0-11445",950,3},
  {{{0xb28b0f2d7598ef21}},10,"F-H0-11446",470,7},
  {{{0x666aea4dbc135ddd}},6,"F-H0-11447",462,6},
  {{{0x539c49e882299f24}},14,"F-H0-11448",948,6},
  {{{0xcec569933e70004a}},14,"F-H0-11449",865,2},
  {{{0x38fec58d81e64699}},8,"F-H0-11450",505,5},
  {{{0xd926876725c2a177}},3,"F-H0-11451",911,4},
  {{{0xfc2e70eea74d5ab3}},3,"F-H0-11452",492,2},
  {{{0x9febb7aeef5c25ed}},9,"F-H0-11453",467,8},
  {{{0x3f9a03fb9d8f10b0}},12,"F-H0-11454",528,6},
  {{{0x4c2010ba6b9856c9}},14,"F-H0-11455",909,6},
  {{{0x8c620eeb4a972eff}},5,"F-H0-11456",801,2},
  {{{0x8c620eeb4a972eff}},5,"F-H0-11457",455,2},
  {{{0x8bb41f1d68fc32e7}},5,"F-H0-11458",947,2},
  {{{0x5d67875d258ae74a}},5,"F-H0-11459",467,2},
  {{{0xefb21767627e6d15}},10,"F-H0-11460",421,3},
  {{{0x9b9b2b01922492ad}},7,"F-H0-11461",899,5},
  {{{0x8503dfc649cbcc74}},7,"F-H0-11462",395,2},
  {{{0x781fa6783da5d468}},4,"F-H0-11463",431,3},
  {{{0x781fa6783da5d468}},4,"F-H0-11464",862,2},
  {{{0x43e09de8d207b2ab}},8,"F-H0-11465",899,7},
  {{{0xc5d347b6845f1653}},11,"F-H0-11466",544,4},
  {{{0xa1008217061d6c06}},13,"F-H0-11467",864,2},
  {{{0x4180037db7566d3c}},6,"F-H0-11468",678,2},
  {{{0xb1531e20142a3c33}},6,"F-H0-11469",941,2},
  {{{0xb1531e20142a3c33}},6,"F-H0-11470",905,2},
  {{{0xf91cb74b5b7c68ca}},8,"F-H0-11471",948,5},
  {{{0xf91cb74b5b7c68ca}},8,"F-H0-11472",911,2},
  {{{0x8a84207132c8c507}},19,"F-H0-11473",949,6},
  {{{0x4e1545c531045124}},14,"F-H0-11474",987,8},
  {{{0xc7bc1f88edb6269f}},9,"F-H0-11475",727,4},
  {{{0xbeedc939bbf430a}},9,"F-H0-11476",569,2},
  {{{0x3119727ef85d230c}},5,"F-H0-11477",943,3},
  {{{0x3119727ef85d230c}},5,"F-H0-11478",825,2},
  {{{0xab74c486706b2a3}},5,"F-H0-11479",462,2},
  {{{0x80f1fd57d0962f72}},3,"F-H0-11480",418,4},
  {{{0x80f1fd57d0962f72}},3,"F-H0-11481",455,2},
  {{{0xdb47781f95fbad10}},10,"F-H0-11482",728,6},
  {{{0xdb47781f95fbad10}},10,"F-H0-11483",802,2},
  {{{0x55b459afc4193c17}},7,"F-H0-11484",423,3},
  {{{0x87718c48724f9e0e}},7,"F-H0-11485",947,2},
  {{{0xe66197411e6d25c1}},13,"F-H0-11486",788,7},
  {{{0xb2aff07b64c533fc}},8,"F-H0-11487",949,2},
  {{{0xb2aff07b64c533fc}},8,"F-H0-11488",946,2},
  {{{0x440369a7e498cc7b}},10,"F-H0-11489",951,7},
  {{{0xdd5af9795677de7f}},9,"F-H0-11490",869,3},
  {{{0xb64be3cf024c1187}},9,"F-H0-11491",872,2},
  {{{0xc20ecb33afe38dd9}},17,"F-H0-11492",427,6},
  {{{0x812c863a9d4791e2}},16,"F-H0-11493",873,8},
  {{{0x235457ae73464d33}},7,"F-H0-11494",419,8},
  {{{0x45424160f7003d46}},7,"F-H0-11495",458,2},
  {{{0x45424160f7003d46}},7,"F-H0-11496",641,2},
  {{{0x1d8fc3a22adc12d4}},13,"F-H0-11497",986,7},
  {{{0x547b57573d8f755d}},12,"F-H0-11498",417,7},
  {{{0xdd3274bb22d856f7}},18,"F-H0-11499",939,4},
  {{{0xc4a10fc93314682b}},15,"F-H0-11500",874,8},
  {{{0xe31f89db948ec09c}},13,"F-H0-11501",462,3},
  {{{0x67630846f19490f6}},13,"F-H0-11502",689,2},
  {{{0x27d3e920509aefb9}},7,"F-H0-11503",418,5},
  {{{0xf172faeb4a9d9e86}},4,"F-H0-11504",913,4},
  {{{0x81f9bdee262968e4}},13,"F-H0-11505",617,5},
  {{{0x7ca3a5eb0dd2bea8}},10,"F-H0-11506",936,5},
  {{{0x590d22726161b123}},9,"F-H0-11507",873,8},
  {{{0x4c874e3a93b8babe}},12,"F-H0-11508",433,8},
  {{{0xac28c0449deb1c84}},7,"F-H0-11509",865,4},
  {{{0x25c278aef02fccd3}},7,"F-H0-11510",936,3},
  {{{0xe5c51519f0acbd92}},10,"F-H0-11511",640,5},
  {{{0xba10306ce3b9ac77}},10,"F-H0-11512",617,2},
  {{{0xfe79034c4696e32e}},7,"F-H0-11513",465,2},
  {{{0x92e4475afb7eafec}},3,"F-H0-11514",862,4},
  {{{0x39fb5fb9e918f0e6}},17,"F-H0-11515",463,4},
  {{{0x39fb5fb9e918f0e6}},17,"F-H0-11516",432,3},
  {{{0x32e602a8d2fdcf0b}},5,"F-H0-11517",763,4},
  {{{0xd8b6fd965eecce6}},5,"F-H0-11518",616,5},
  {{{0xff364b2f81981786}},9,"F-H0-11519",494,3},
  {{{0xab113a69032d5a15}},7,"F-H0-11520",455,8},
  {{{0xed334f6720cdcb84}},17,"F-H0-11521",908,7},
  {{{0xa535714eaf064121}},16,"F-H0-11522",985,7},
  {{{0x9312b936e55f5722}},3,"F-H0-11523",456,4},
  {{{0xead2ea4b406ec808}},5,"F-H0-11524",456,2},
  {{{0xead2ea4b406ec808}},5,"F-H0-11525",506,2},
  {{{0xb08bd56057a994d4}},5,"F-H0-11526",938,2},
  {{{0x9e3577af0463e6ad}},12,"F-H0-11527",945,3},
  {{{0xfbfd70af2d44ace}},12,"F-H0-11528",826,2},
  {{{0x6f2881f2f8fcc5a}},12,"F-H0-11529",942,7},
  {{{0xd672da8162b68207}},6,"F-H0-11530",765,2},
  {{{0x504ee41a5d3d4025}},6,"F-H0-11531",826,2},
  {{{0x6de78606d284fd19}},8,"F-H0-11532",431,7},
  {{{0xe1b1f56449175a2b}},9,"F-H0-11533",946,8},
  {{{0xfa4dc49b26791d22}},12,"F-H0-11534",417,8},
  {{{0xf24282182f4c47f4}},12,"F-H0-11535",542,5},
  {{{0x683d95a6c83147de}},20,"F-H0-11536",946,4},
  {{{0x21843c276dbe7af2}},20,"F-H0-11537",872,2},
  {{{0x8ee47740aaf12864}},10,"F-H0-11538",604,5},
  {{{0xaac8af17dbf0eeed}},10,"F-H0-11539",454,7},
  {{{0x470f2622cbe6905}},5,"F-H0-11540",904,2},
  {{{0x470f2622cbe6905}},5,"F-H0-11541",936,2},
  {{{0x470f2622cbe6905}},5,"F-H0-11542",940,2},
  {{{0x1b67592c50f680b9}},13,"F-H0-11543",462,5},
  {{{0xffa6aa20bdac9106}},5,"F-H0-11544",468,3},
  {{{0x99488ac12d118e64}},8,"F-H0-11545",949,2},
  {{{0xb9f14e52b52e2369}},7,"F-H0-11546",417,8},
  {{{0xa3214db483b908d5}},7,"F-H0-11547",459,4},
  {{{0x7affab6535649ea}},7,"F-H0-11548",802,3},
  {{{0xdd85ee059524115f}},9,"F-H0-11549",839,4},
  {{{0xdd85ee059524115f}},9,"F-H0-11550",912,2},
  {{{0xc25e9921b5bda8dc}},11,"F-H0-11551",862,4},
  {{{0x7f67ba910ec2dde3}},11,"F-H0-11552",469,3},
  {{{0xadbad207d96068c}},7,"F-H0-11553",943,2},
  {{{0xbf517ea5c7af8f3c}},11,"F-H0-11554",867,7},
  {{{0xc1a9d66562725a69}},7,"F-H0-11555",469,7},
  {{{0xcc348fd682c17ff0}},5,"F-H0-11556",936,4},
  {{{0x9bbeeec5be911385}},15,"F-H0-11557",875,5},
  {{{0xcd93f805eb59e55c}},15,"F-H0-11558",466,2},
  {{{0xbd0a1ffff9d61a8d}},3,"F-H0-11559",469,3},
  {{{0x430d5ede4bf06020}},14,"F-H0-11560",381,7},
  {{{0x2949fd4d7ddac7c8}},19,"F-H0-11561",507,6},
  {{{0x7d6d36971dee2740}},11,"F-H0-11562",507,7},
  {{{0xe6ccdf36d28c883e}},7,"F-H0-11563",529,4},
  {{{0xe6ccdf36d28c883e}},7,"F-H0-11564",423,3},
  {{{0xfe07bacbce343755}},8,"F-H0-11565",911,2},
  {{{0xd916be2144b755c0}},8,"F-H0-11566",943,2},
  {{{0x45c423f90db8c254}},9,"F-H0-11567",430,6},
  {{{0xd57f6d846ced362e}},15,"F-H0-11568",947,4},
  {{{0xd57f6d846ced362e}},15,"F-H0-11569",839,2},
  {{{0x6c038ca825cf771f}},7,"F-H0-11570",936,4},
  {{{0x31d78d35e9a8d19a}},6,"F-H0-11571",945,3},
  {{{0xbf5d4ecf1c6cc472}},11,"F-H0-11572",420,8},
  {{{0x83a93091ee5dd216}},2,"F-H0-11573",902,3},
  {{{0x6d1953f4b624b54}},10,"F-H0-11574",948,4},
  {{{0x38ebeada1002b180}},10,"F-H0-11575",948,2},
  {{{0x5626bf7326b0dc4e}},7,"F-H0-11576",530,2},
  {{{0x4077ffb3a71865c2}},7,"F-H0-11577",765,2},
  {{{0x63569bbf90751b26}},14,"F-H0-11578",543,4},
  {{{0x89d12b16967a8864}},14,"F-H0-11579",543,2},
  {{{0x328064ba9853047a}},14,"F-H0-11580",751,2},
  {{{0xa515646231297916}},18,"F-H0-11581",950,5},
  {{{0x97d6ae6b627ba41f}},9,"F-H0-11582",987,4},
  {{{0xbba94f4c83b32ffd}},10,"F-H0-11583",615,5},
  {{{0x417ae5f4008144e1}},16,"F-H0-11584",983,3},
  {{{0xb2bf8a2eb7481d64}},16,"F-H0-11585",531,2},
  {{{0xd74a50a6f7c9ceb0}},9,"F-H0-11586",987,7},
  {{{0x1dd152a4fb231836}},8,"F-H0-11587",419,5},
  {{{0xce84b70d52f7cb64}},5,"F-H0-11588",690,2},
  {{{0xcdeeedcefd2dc8a4}},5,"F-H0-11589",974,2},
  {{{0xc2331cc0970639d}},17,"F-H0-11590",1016,3},
  {{{0x92eab9d76a002053}},7,"F-H0-11591",939,7},
  {{{0x3c33208b76e5924e}},7,"F-H0-11592",469,8},
  {{{0x38660bb99197bb6b}},9,"F-H0-11593",839,6},
  {{{0xc3c841bc847fe202}},5,"F-H0-11594",947,3},
  {{{0x3d484f0602c1426b}},5,"F-H0-11595",863,2},
  {{{0xc3c841bc847fe202}},5,"F-H0-11596",943,2},
  {{{0x6624182baa06dba2}},15,"F-H0-11597",542,3},
  {{{0x6624182baa06dba2}},15,"F-H0-11598",802,2},
  {{{0x5059e21f623d22d2}},15,"F-H0-11599",866,2},
  {{{0x1422b80ba000fd23}},7,"F-H0-11600",947,4},
  {{{0x1422b80ba000fd23}},7,"F-H0-11601",912,3},
  {{{0x295f9eb50f287e41}},14,"F-H0-11602",984,8},
  {{{0x39ef6fa25e5bd76e}},18,"F-H0-11603",951,6},
  {{{0xe5ca271964292d7}},8,"F-H0-11604",469,4},
  {{{0x73e27f96685a5488}},8,"F-H0-11605",937,2},
  {{{0x54d493612acdb4e}},6,"F-H0-11606",909,4},
  {{{0xaa8fd0bfafceebac}},6,"F-H0-11607",827,2},
  {{{0xca5156269da7e066}},11,"F-H0-11608",492,3},
  {{{0x4d6eabb2db08e8c1}},10,"F-H0-11609",838,4},
  {{{0x4c8fbd3d639bdeca}},8,"F-H0-11610",839,5},
  {{{0x4c8fbd3d639bdeca}},8,"F-H0-11611",802,2},
  {{{0x8c956db536b69563}},11,"F-H0-11612",690,7},
  {{{0x6f28104ad17452e3}},6,"F-H0-11613",906,2},
  {{{0xf69b5fe8ae758fc8}},7,"F-H0-11614",494,6},
  {{{0xf69b5fe8ae758fc8}},7,"F-H0-11615",529,2},
  {{{0x252923eae42cbdd}},9,"F-H0-11616",530,3},
  {{{0x252923eae42cbdd}},9,"F-H0-11617",461,2},
  {{{0xa51e617f4202f5c4}},7,"F-H0-11618",493,5},
  {{{0x6c29361de399424f}},7,"F-H0-11619",827,3},
  {{{0x5d3297afa5b9ab01}},5,"F-H0-11620",945,2},
  {{{0x95e7f089d4060}},6,"F-H0-11621",875,4},
  {{{0x3a772d08141970de}},6,"F-H0-11622",690,2},
  {{{0x9ce5c8b3626862}},2,"F-H0-11623",937,4},
  {{{0x943196fe0d0581e4}},7,"F-H0-11624",491,4},
  {{{0x9ba697cd809dad84}},11,"F-H0-11625",429,2},
  {{{0x9ba697cd809dad84}},11,"F-H0-11626",427,2},
  {{{0x9ba697cd809dad84}},11,"F-H0-11627",430,2},
  {{{0xb1d51b5440a41d04}},8,"F-H0-11628",458,5},
  {{{0xb1d51b5440a41d04}},8,"F-H0-11629",467,2},
  {{{0xcf975bd34300b7c5}},4,"F-H0-11630",862,4},
  {{{0x4fe3cdbc0068692}},10,"F-H0-11631",454,8},
  {{{0x682aea8faf7a23c4}},14,"F-H0-11632",937,2},
  {{{0xe1d1d0c92a7d4eae}},8,"F-H0-11633",431,8},
  {{{0xce364338db05cacc}},11,"F-H0-11634",507,7},
  {{{0x86635b36c753f438}},6,"F-H0-11635",801,6},
  {{{0xa9b311559d9b3e30}},7,"F-H0-11636",426,3},
  {{{0xbc4e6ec853ee205f}},7,"F-H0-11637",616,2},
  {{{0xd8e9dd88781204b7}},7,"F-H0-11638",566,2},
  {{{0xf07cf2bb0eff33fd}},8,"F-H0-11639",503,4},
  {{{0x345d16a072d78c3b}},13,"F-H0-11640",392,5},
  {{{0x94008a6b79843a00}},11,"F-H0-11641",911,3},
  {{{0xd4b5cf7369e7b89b}},5,"F-H0-11642",430,2},
  {{{0x4ac141cfd4e075b4}},5,"F-H0-11643",691,2},
  {{{0x10ad5de198b22ed8}},14,"F-H0-11644",421,7},
  {{{0x199de7b0d6b76e6e}},2,"F-H0-11645",530,3},
  {{{0x6127c2083a90341b}},2,"F-H0-11646",530,2},
  {{{0x1fb691cdb096c375}},5,"F-H0-11647",874,3},
  {{{0x1fb691cdb096c375}},5,"F-H0-11648",909,2},
  {{{0x5d4940c3ae9879ac}},5,"F-H0-11649",825,3},
  {{{0x4544161ea32d7742}},5,"F-H0-11650",529,2},
  {{{0xecc36bf013c4a42e}},22,"F-H0-11651",390,7},
  {{{0x92affae6db2f9053}},10,"F-H0-11652",382,7},
  {{{0xeb88e9ac6edf5cb2}},15,"F-H0-11653",984,7},
  {{{0xa0e4e2973ad49b30}},19,"F-H0-11654",872,5},
  {{{0x3ded1716e71a9248}},13,"F-H0-11655",580,2},
  {{{0x3ded1716e71a9248}},13,"F-H0-11656",544,2},
  {{{0x4c429f78400233ac}},13,"F-H0-11657",568,2},
  {{{0x3ded1716e71a9248}},13,"F-H0-11658",427,2},
  {{{0xe17d9b9c3bc85c71}},14,"F-H0-11659",618,4},
  {{{0x5afab0ebf1862e92}},18,"F-H0-11660",396,7},
  {{{0xb9446496ec0bac50}},8,"F-H0-11661",973,3},
  {{{0x242365e6ca03525a}},8,"F-H0-11662",495,2},
  {{{0x6a146aea27fddff}},6,"F-H0-11663",874,6},
  {{{0xf6a91eecde424ec2}},6,"F-H0-11664",456,2},
  {{{0xd1dfbfe93e2b75ae}},7,"F-H0-11665",950,2},
  {{{0xd1dfbfe93e2b75ae}},7,"F-H0-11666",911,2},
  {{{0x53e9b1233f55c3ec}},8,"F-H0-11667",948,6},
  {{{0x53e9b1233f55c3ec}},8,"F-H0-11668",911,2},
  {{{0x9b65eae22d310e42}},8,"F-H0-11669",432,3},
  {{{0x8ad9f83beb51c3bc}},8,"F-H0-11670",943,2},
  {{{0x183e8331a9521efc}},10,"F-H0-11671",838,5},
  {{{0x183e8331a9521efc}},10,"F-H0-11672",949,2},
  {{{0xecd10bb5e17f073}},13,"F-H0-11673",909,5},
  {{{0xecd10bb5e17f073}},13,"F-H0-11674",950,3},
  {{{0xcfc685aaea3beca9}},7,"F-H0-11675",872,2},
  {{{0x4b9c65a942e4f714}},11,"F-H0-11676",950,5},
  {{{0x3f37fc76ec91f655}},9,"F-H0-11677",865,5},
  {{{0xa4e85442d25f3863}},5,"F-H0-11678",455,5},
  {{{0x3e1e98b59a25c88e}},5,"F-H0-11679",530,2},
  {{{0x5dd9a179658e7368}},8,"F-H0-11680",874,4},
  {{{0x5ce4883111b03b99}},8,"F-H0-11681",429,6},
  {{{0x4a988416ec19c32d}},10,"F-H0-11682",912,8},
  {{{0x6ff04888208487a3}},10,"F-H0-11683",464,4},
  {{{0xb3a6fa1786fa5e2}},7,"F-H0-11684",529,4},
  {{{0xb3a6fa1786fa5e2}},7,"F-H0-11685",566,4},
  {{{0x3e6248fc4fbc3d49}},5,"F-H0-11686",420,3},
  {{{0xc9e2be03f563b22a}},4,"F-H0-11687",936,6},
  {{{0x3837542b1942c39d}},6,"F-H0-11688",468,7},
  {{{0x3a9ff9f67fec075e}},11,"F-H0-11689",973,2},
  {{{0x28802163d8e86b3d}},5,"F-H0-11690",542,4},
  {{{0x1e7e6d235b61d97}},5,"F-H0-11691",429,2},
  {{{0x20ae32ff812d2bf7}},15,"F-H0-11692",750,7},
  {{{0x9fdb3d89b3fc79ac}},14,"F-H0-11693",429,8},
  {{{0xc3e0cefaf34d629f}},11,"F-H0-11694",421,4},
  {{{0x7b7f9f7ed0818d24}},11,"F-H0-11695",825,3},
  {{{0x424d237b42dd804c}},5,"F-H0-11696",839,3},
  {{{0xa91c139b8884c48e}},3,"F-H0-11697",456,6},
  {{{0xa4552d42e2fcbe8f}},7,"F-H0-11698",901,3},
  {{{0xa4552d42e2fcbe8f}},7,"F-H0-11699",458,2},
  {{{0xd0d991dbb239c258}},13,"F-H0-11700",947,7},
  {{{0x83a4bf54821cb64a}},5,"F-H0-11701",765,2},
  {{{0x83dbce4abcc23913}},5,"F-H0-11702",420,2},
  {{{0x30155dce4e57356e}},9,"F-H0-11703",862,7},
  {{{0x30e60736b7deed99}},9,"F-H0-11704",431,3},
  {{{0x30e60736b7deed99}},9,"F-H0-11705",506,3},
  {{{0xe030c1097a1c497f}},9,"F-H0-11706",987,4},
  {{{0x24f963a31d6c03e4}},9,"F-H0-11707",419,3},
  {{{0x8acdb19b7b52ce8e}},10,"F-H0-11708",468,8},
  {{{0x3a9ba7897b773d6e}},11,"F-H0-11709",911,3},
  {{{0x5b9446f9aca9d14}},6,"F-H0-11710",531,6},
  {{{0x4e1cdf5a282d6595}},6,"F-H0-11711",432,2},
  {{{0xfd0dbeb06167d96d}},8,"F-H0-11712",458,2},
  {{{0x5b5ed3ef7911d235}},14,"F-H0-11713",875,2},
  {{{0x4ae36028a4d3f3e5}},3,"F-H0-11714",901,4},
  {{{0x4e42cf70ee1ba26d}},6,"F-H0-11715",530,2},
  {{{0xd4d21a78de56806a}},6,"F-H0-11716",506,2},
  {{{0x34ada45e746c0070}},7,"F-H0-11717",949,4},
  {{{0xfb1dad264e3fc708}},10,"F-H0-11718",543,2},
  {{{0xba0302f273e527c9}},10,"F-H0-11719",425,2},
  {{{0xe922f5889ea7ffe4}},18,"F-H0-11720",872,7},
  {{{0x3497768334fb3679}},7,"F-H0-11721",950,5},
  {{{0xe05be4b4cdb29f39}},7,"F-H0-11722",428,2},
  {{{0x5443d3cf2eb9232a}},3,"F-H0-11723",468,3},
  {{{0x8c895ebd1d8ab625}},3,"F-H0-11724",901,2},
  {{{0xad28da939cc842f2}},3,"F-H0-11725",876,2},
  {{{0x621077bbc65031fb}},9,"F-H0-11726",467,7},
  {{{0x9eab130134efa2df}},7,"F-H0-11727",603,2},
  {{{0xb69f7391aaefe3ce}},7,"F-H0-11728",690,2},
  {{{0x52061bde6521b429}},17,"F-H0-11729",454,5},
  {{{0xce934eeb16cd168c}},17,"F-H0-11730",950,3},
  {{{0x1ceaa1b5c8500194}},22,"F-H0-11731",458,2},
  {{{0x1ceaa1b5c8500194}},22,"F-H0-11732",421,2},
  {{{0x1ceaa1b5c8500194}},22,"F-H0-11733",604,2},
  {{{0x48612495e878993c}},9,"F-H0-11734",936,7},
  {{{0x7fba36eca2f2c767}},10,"F-H0-11735",426,8},
  {{{0x90b543ff0d2f0f59}},11,"F-H0-11736",470,3},
  {{{0x90b543ff0d2f0f59}},11,"F-H0-11737",466,3},
  {{{0xdb50295945a0e47c}},8,"F-H0-11738",949,7},
  {{{0x83e1ee1e1db81336}},6,"F-H0-11739",788,6},
  {{{0xde1d30dfb7f4d11}},9,"F-H0-11740",421,8},
  {{{0xe089484a67f7c7c3}},9,"F-H0-11741",603,7},
  {{{0xad1994fa9f36c9af}},4,"F-H0-11742",937,2},
  {{{0x6feae56bb30d8038}},7,"F-H0-11743",566,4},
  {{{0x6feae56bb30d8038}},7,"F-H0-11744",529,4},
  {{{0xd89cd54f5d13c871}},5,"F-H0-11745",909,3},
  {{{0xd89cd54f5d13c871}},5,"F-H0-11746",873,2},
  {{{0x4afded7fd4f3bb97}},7,"F-H0-11747",419,2},
  {{{0x6b01d3be71df2ca3}},7,"F-H0-11748",825,2},
  {{{0xf36d907cfccee0ff}},7,"F-H0-11749",943,2},
  {{{0xae581d51a32faab2}},11,"F-H0-11750",875,4},
  {{{0xa18d131bfeda0a1}},10,"F-H0-11751",419,4},
  {{{0xa18d131bfeda0a1}},10,"F-H0-11752",940,2},
  {{{0xf5fb24212d20bc56}},6,"F-H0-11753",542,3},
  {{{0x1dd6f7d77c6b8195}},9,"F-H0-11754",580,6},
  {{{0x906d902a557f41c6}},8,"F-H0-11755",949,5},
  {{{0x549013d69ec9749d}},8,"F-H0-11756",937,7},
  {{{0xbcd327d1f0813ff9}},6,"F-H0-11757",430,7},
  {{{0x96c1892fb1f16edb}},4,"F-H0-11758",949,3},
  {{{0x96c1892fb1f16edb}},4,"F-H0-11759",542,2},
  {{{0x237e9d3c1d942f84}},6,"F-H0-11760",948,2},
  {{{0x5d1c45b0a02c530}},6,"F-H0-11761",826,2},
  {{{0x237e9d3c1d942f84}},6,"F-H0-11762",838,2},
  {{{0x5786c8e25d0e0de9}},6,"F-H0-11763",530,4},
  {{{0x5786c8e25d0e0de9}},6,"F-H0-11764",543,2},
  {{{0xf01992fdd3517985}},5,"F-H0-11765",866,2},
  {{{0xae4cf6757f4c16ff}},9,"F-H0-11766",541,6},
  {{{0x43f4fc5c01f81927}},13,"F-H0-11767",914,3},
  {{{0x43f4fc5c01f81927}},13,"F-H0-11768",825,2},
  {{{0x6afb7d6373efc7b8}},8,"F-H0-11769",567,4},
  {{{0xfeff1f4794fd018c}},8,"F-H0-11770",950,5},
  {{{0xb645e1f32dc70a56}},12,"F-H0-11771",429,2},
  {{{0xb645e1f32dc70a56}},12,"F-H0-11772",569,2},
  {{{0x19f6da84dff49d1c}},3,"F-H0-11773",900,3},
  {{{0x2c9d62111469b192}},3,"F-H0-11774",949,3},
  {{{0xf1bfdb8ef190ea13}},7,"F-H0-11775",394,5},
  {{{0xf1bfdb8ef190ea13}},7,"F-H0-11776",468,2},
  {{{0xc8fa291de96aac0b}},6,"F-H0-11777",873,3},
  {{{0x98165c8a9b711f4d}},12,"F-H0-11778",469,5},
  {{{0x53ed415ca854da82}},12,"F-H0-11779",788,2},
  {{{0xbf07f0221a3f6c94}},10,"F-H0-11780",902,4},
  {{{0xbf07f0221a3f6c94}},10,"F-H0-11781",824,3},
  {{{0x192a86f6f93460a5}},8,"F-H0-11782",948,7},
  {{{0x5392a57767fd9a82}},5,"F-H0-11783",826,6},
  {{{0xd138c42dc33b54a1}},6,"F-H0-11784",837,4},
  {{{0xa5895e7131865536}},6,"F-H0-11785",529,2},
  {{{0xafe29dedd1bbd167}},5,"F-H0-11786",455,2},
  {{{0xafe29dedd1bbd167}},5,"F-H0-11787",911,2},
  {{{0x10690bbcec187857}},6,"F-H0-11788",948,3},
  {{{0xa3926c7186ff0b3e}},8,"F-H0-11789",765,5},
  {{{0xe8b13210327c4035}},8,"F-H0-11790",541,7},
  {{{0x2ba265f01ec69592}},13,"F-H0-11791",876,6},
  {{{0xabe2252382632bcd}},8,"F-H0-11792",949,4},
  {{{0xabe2252382632bcd}},8,"F-H0-11793",945,2},
  {{{0xd1b83ac7e8204df6}},12,"F-H0-11794",938,4},
  {{{0x11404f18a0190e15}},21,"F-H0-11795",944,6},
  {{{0x1bb6be43f416efab}},9,"F-H0-11796",616,2},
  {{{0x1bb6be43f416efab}},9,"F-H0-11797",654,2},
  {{{0xa5874d4f24cc9cd0}},17,"F-H0-11798",946,4},
  {{{0xa5874d4f24cc9cd0}},17,"F-H0-11799",988,3},
  {{{0xc2034e2519254569}},6,"F-H0-11800",567,3},
  {{{0x56bcd3c653671cd4}},8,"F-H0-11801",615,6},
  {{{0xcbd24740ca564fcb}},7,"F-H0-11802",690,4},
  {{{0x2ded9648971e98b}},7,"F-H0-11803",715,2},
  {{{0xa012f71e7c28280e}},8,"F-H0-11804",911,7},
  {{{0x72278383b5d2211c}},17,"F-H0-11805",837,3},
  {{{0xa762794495cb747e}},10,"F-H0-11806",425,2},
  {{{0xa762794495cb747e}},10,"F-H0-11807",462,2},
  {{{0x647e16c0faf7ceac}},9,"F-H0-11808",529,6},
  {{{0x4d740d2dd4811a28}},6,"F-H0-11809",938,6},
  {{{0x3238e0cc01ab1425}},17,"F-H0-11810",788,3},
  {{{0x3238e0cc01ab1425}},17,"F-H0-11811",825,3},
  {{{0x3778e352703525d3}},2,"F-H0-11812",875,2},
  {{{0x5b0b71efe93dfa86}},20,"F-H0-11813",942,3},
  {{{0x5b0b71efe93dfa86}},20,"F-H0-11814",541,3},
  {{{0x5e45feb9d558bbb8}},8,"F-H0-11815",862,5},
  {{{0xff4a8e0b1a53d004}},7,"F-H0-11816",875,3},
  {{{0xf641a61a0c882203}},12,"F-H0-11817",910,5},
  {{{0x86a4bdec1c85021f}},11,"F-H0-11818",877,6},
  {{{0x2564bdc730d5d63a}},7,"F-H0-11819",940,7},
  {{{0x46f9a7233d1ff48}},10,"F-H0-11820",901,2},
  {{{0xdb89ab9d13ce45e8}},10,"F-H0-11821",429,3},
  {{{0xf33811baa6bc9960}},13,"F-H0-11822",936,5},
  {{{0x972262341c41bd91}},6,"F-H0-11823",495,2},
  {{{0x898d6615f53bf679}},12,"F-H0-11824",540,4},
  {{{0x898d6615f53bf679}},12,"F-H0-11825",432,3},
  {{{0x71a6cc1d2ea70eeb}},7,"F-H0-11826",824,5},
  {{{0x502913b487ec7aa6}},7,"F-H0-11827",939,2},
  {{{0x297660def4f00ad6}},9,"F-H0-11828",937,7},
  {{{0x93fa91f0380c098d}},7,"F-H0-11829",604,4},
  {{{0x161476912186d5fb}},9,"F-H0-11830",431,6},
  {{{0x351d76f259d55798}},4,"F-H0-11831",838,3},
  {{{0x1066173277b342ab}},14,"F-H0-11832",911,6},
  {{{0xe6d288786d0fce6a}},13,"F-H0-11833",986,3},
  {{{0x8a6c55c8b2a80f0f}},13,"F-H0-11834",905,2},
  {{{0x1bb5974e667f4430}},9,"F-H0-11835",494,6},
  {{{0xcbd29122c29651c2}},14,"F-H0-11836",914,5},
  {{{0x1235c55ffeee5ca0}},7,"F-H0-11837",728,5},
  {{{0x14a280ac1408362}},8,"F-H0-11838",949,4},
  {{{0x80fbe71f01eac4aa}},10,"F-H0-11839",457,5},
  {{{0x5c1e281f35e3b172}},10,"F-H0-11840",837,2},
  {{{0xa04ada76ef0bd836}},6,"F-H0-11841",945,3},
  {{{0x5b648750e8dc63d7}},8,"F-H0-11842",382,4},
  {{{0x827050422b2b6f7f}},3,"F-H0-11843",456,4},
  {{{0xaab642370aaf4b01}},3,"F-H0-11844",468,2},
  {{{0x84948fe65736bf2c}},14,"F-H0-11845",947,6},
  {{{0x63eefd7db9359d71}},20,"F-H0-11846",839,6},
  {{{0xef5c61029312f199}},7,"F-H0-11847",913,7},
  {{{0x673a25f81d0005b6}},17,"F-H0-11848",495,6},
  {{{0xa7a8b46c7024a23c}},7,"F-H0-11849",901,2},
  {{{0x3f7c4c00da55fdb6}},5,"F-H0-11850",826,2},
  {{{0x2b63c08ee1a62ace}},12,"F-H0-11851",899,2},
  {{{0x9041fe2ab765fa0c}},5,"F-H0-11852",939,3},
  {{{0x7bf3c7c356218aa0}},9,"F-H0-11853",835,7},
  {{{0xc7671d5c3d9d757e}},8,"F-H0-11854",457,5},
  {{{0x3acf8fd084232f9c}},13,"F-H0-11855",826,7},
  {{{0x9950978ae1e9c6f1}},6,"F-H0-11856",529,7},
  {{{0x996c6f73ed8defa1}},9,"F-H0-11857",801,3},
  {{{0x996c6f73ed8defa1}},9,"F-H0-11858",763,2},
  {{{0x24f6c52f1f865d5e}},9,"F-H0-11859",906,3},
  {{{0x24f6c52f1f865d5e}},9,"F-H0-11860",943,2},
  {{{0xf658bb9e2c80570c}},11,"F-H0-11861",874,5},
  {{{0x6a44ab0c64b528a9}},6,"F-H0-11862",948,2},
  {{{0xb306b524ddd734a4}},14,"F-H0-11863",543,2},
  {{{0x688129218425a23b}},14,"F-H0-11864",940,2},
  {{{0xc70a1543c59d96f2}},15,"F-H0-11865",603,3},
  {{{0x47ae308ccd056b50}},10,"F-H0-11866",942,5},
  {{{0xa00f90ae229b2fe6}},10,"F-H0-11867",421,2},
  {{{0xaba4421d8aab025f}},14,"F-H0-11868",432,3},
  {{{0xaba4421d8aab025f}},14,"F-H0-11869",616,3},
  {{{0x79af8dfa53038cfa}},5,"F-H0-11870",838,3},
  {{{0x79af8dfa53038cfa}},5,"F-H0-11871",939,2},
  {{{0x90856162589760df}},13,"F-H0-11872",827,5},
  {{{0xbec7faace808ad2b}},6,"F-H0-11873",421,2},
  {{{0x6555587198be512d}},14,"F-H0-11874",502,6},
  {{{0x6e942c0febe9ebfe}},15,"F-H0-11875",465,3},
  {{{0xb67638a621e2d1f3}},15,"F-H0-11876",503,3},
  {{{0x41633262474f3c88}},12,"F-H0-11877",862,3},
  {{{0x72f3655f7a6f7df8}},12,"F-H0-11878",454,3},
  {{{0xd70c930316c17867}},19,"F-H0-11879",972,7},
  {{{0xdbe441593aac0d38}},15,"F-H0-11880",950,3},
  {{{0x52289d495fef1d7d}},15,"F-H0-11881",827,2},
  {{{0x6fdde0792f0fdb0d}},10,"F-H0-11882",936,5},
  {{{0x94582e9ec5b2c2b9}},7,"F-H0-11883",948,2},
  {{{0x3e5afbc775bfdf03}},7,"F-H0-11884",939,2},
  {{{0xbdf88279ff1beeb5}},7,"F-H0-11885",939,2},
  {{{0x7979f4aa1c580cfe}},6,"F-H0-11886",938,4},
  {{{0x7979f4aa1c580cfe}},6,"F-H0-11887",941,3},
  {{{0xe7d76de1f179ad63}},17,"F-H0-11888",678,5},
  {{{0x1406d7a5444b5ff8}},10,"F-H0-11889",466,2},
  {{{0x3c9b5906828f0eb4}},7,"F-H0-11890",911,3},
  {{{0x3c9b5906828f0eb4}},7,"F-H0-11891",912,2},
  {{{0x3c9b5906828f0eb4}},7,"F-H0-11892",874,2},
  {{{0x163180ecc93a0a27}},16,"F-H0-11893",943,4},
  {{{0xce29b777ef73270e}},16,"F-H0-11894",904,3},
  {{{0x6f08cfae4bf5a59d}},10,"F-H0-11895",901,5},
  {{{0x987887242cb6537b}},12,"F-H0-11896",950,5},
  {{{0x1393771a1caa0b92}},12,"F-H0-11897",836,2},
  {{{0xe5d4a027e117bd66}},8,"F-H0-11898",949,7},
  {{{0x5af128d763892290}},12,"F-H0-11899",540,5},
  {{{0x4e9fbab0e1387e7b}},9,"F-H0-11900",503,7},
  {{{0x3ce9cae749820b2}},14,"F-H0-11901",986,4},
  {{{0xbea1cbab3b5bb9e2}},14,"F-H0-11902",565,2},
  {{{0xea8d5e4e5520e338}},11,"F-H0-11903",936,2},
  {{{0xb5b136c113ed1f43}},10,"F-H0-11904",530,3},
  {{{0x9cd3166d1f4c65}},10,"F-H0-11905",422,2},
  {{{0x395b70f4acb5bfc7}},14,"F-H0-11906",872,6},
  {{{0x279308337e410e8d}},14,"F-H0-11907",543,7},
  {{{0xe004f4a2465e5b06}},6,"F-H0-11908",541,3},
  {{{0x78835dc60fc7546f}},8,"F-H0-11909",949,5},
  {{{0xa714ed528bd8842}},7,"F-H0-11910",910,4},
  {{{0x6a10359a0ef80b7}},10,"F-H0-11911",874,5},
  {{{0x8396066adf0bc0e0}},11,"F-H0-11912",943,3},
  {{{0xefc1781cd7320341}},11,"F-H0-11913",421,2},
  {{{0x66d4014199dd104e}},10,"F-H0-11914",913,6},
  {{{0xa8c4cafcb828227b}},11,"F-H0-11915",383,7},
  {{{0xec24a43467ac448b}},6,"F-H0-11916",826,6},
  {{{0x7243f9ea5e194f17}},6,"F-H0-11917",423,2},
  {{{0x2f2717ac6352c214}},6,"F-H0-11918",429,2},
  {{{0xb2d72443a394d0c8}},5,"F-H0-11919",839,3},
  {{{0x710d07b7eccd4be5}},5,"F-H0-11920",943,2},
  {{{0x419f8bb0f3c3660b}},7,"F-H0-11921",906,2},
  {{{0xcc5d7a1459d08eef}},7,"F-H0-11922",827,6},
  {{{0x8fb3d1a4614e80b4}},8,"F-H0-11923",949,2},
  {{{0xb02ea569451229ce}},8,"F-H0-11924",899,2},
  {{{0xe7e49e282a1356b}},12,"F-H0-11925",422,4},
  {{{0x6d756d0d2defbeba}},12,"F-H0-11926",678,2},
  {{{0x99f055f269f3968e}},6,"F-H0-11927",424,4},
  {{{0x4b6bd3a735c2bb3a}},7,"F-H0-11928",494,3},
  {{{0xd1f72c6ac588c4a5}},10,"F-H0-11929",690,6},
  {{{0x795eeee2a5b9d18a}},14,"F-H0-11930",529,4},
  {{{0xccab1b5a1daf1aa3}},7,"F-H0-11931",973,6},
  {{{0x5aa75939410a632f}},9,"F-H0-11932",826,4},
  {{{0x5aa75939410a632f}},9,"F-H0-11933",789,2},
  {{{0x46b4b6afb7263bd7}},18,"F-H0-11934",430,6},
  {{{0xcadc675103e07010}},8,"F-H0-11935",949,5},
  {{{0xcadc675103e07010}},8,"F-H0-11936",875,2},
  {{{0xbedfb41e992682e5}},7,"F-H0-11937",950,3},
  {{{0xd59a4111bdff2dc}},7,"F-H0-11938",936,4},
  {{{0xd59a4111bdff2dc}},7,"F-H0-11939",827,3},
  {{{0xa6a075cc580966c2}},11,"F-H0-11940",935,3},
  {{{0x8c10448e9ef3c3f9}},11,"F-H0-11941",838,3},
  {{{0x696c7eae750b789e}},10,"F-H0-11942",654,3},
  {{{0x696c7eae750b789e}},10,"F-H0-11943",617,2},
  {{{0x8ce23fc4938a5e1b}},12,"F-H0-11944",951,6},
  {{{0xf84347ae3fc9ddf1}},13,"F-H0-11945",942,6},
  {{{0x555063eda3a965f2}},8,"F-H0-11946",912,7},
  {{{0x2e7e454b2f200044}},2,"F-H0-11947",912,3},
  {{{0x71b029f9e40a6dc1}},9,"F-H0-11948",950,7},
  {{{0x70bc16c5e543adeb}},7,"F-H0-11949",678,3},
  {{{0x827669ebb0ca20d5}},2,"F-H0-11950",826,5},
  {{{0x677192a828193b79}},4,"F-H0-11951",493,3},
  {{{0x96bf12d939224e47}},14,"F-H0-11952",544,6},
  {{{0x7f55e5fbdf93bd39}},10,"F-H0-11953",423,3},
  {{{0x7f55e5fbdf93bd39}},10,"F-H0-11954",424,3},
  {{{0xffc8456e4a872388}},7,"F-H0-11955",506,2},
  {{{0xffc8456e4a872388}},7,"F-H0-11956",542,2},
  {{{0x9588e51d104229b8}},10,"F-H0-11957",824,4},
  {{{0x80fa245f1953af2e}},10,"F-H0-11958",788,2},
  {{{0xce8d1c4a44c396bf}},3,"F-H0-11959",467,3},
  {{{0x98855424e3c84a30}},6,"F-H0-11960",542,3},
  {{{0xbd1f9fc2c591302}},6,"F-H0-11961",874,3},
  {{{0x5b689368487f3243}},21,"F-H0-11962",943,4},
  {{{0xf61a350171430bca}},9,"F-H0-11963",419,7},
  {{{0x9865796c940af6eb}},16,"F-H0-11964",873,7},
  {{{0x46d6906f1c75a103}},7,"F-H0-11965",825,2},
  {{{0x6c30315208e8cf41}},16,"F-H0-11966",911,7},
  {{{0x95a856cbc3caf75f}},13,"F-H0-11967",801,2},
  {{{0xa59821617ceeecf7}},7,"F-H0-11968",872,3},
  {{{0x331e86419d067b59}},8,"F-H0-11969",752,3},
  {{{0x660e7dcf1db957bf}},6,"F-H0-11970",901,5},
  {{{0x2beb17d911980f12}},6,"F-H0-11971",906,2},
  {{{0x4c66a4f90eec4295}},13,"F-H0-11972",905,5},
  {{{0x6d036aede94e1002}},11,"F-H0-11973",911,2},
  {{{0xa51ed9b7eb861c21}},9,"F-H0-11974",937,6},
  {{{0x8f2503d743e89505}},17,"F-H0-11975",908,6},
  {{{0x470438bc0a2c0255}},14,"F-H0-11976",529,6},
  {{{0x13988d0bf317958d}},6,"F-H0-11977",429,4},
  {{{0x13988d0bf317958d}},6,"F-H0-11978",428,2},
  {{{0x8ad71cd66eb14cf9}},8,"F-H0-11979",874,5},
  {{{0x5a52153f24952060}},8,"F-H0-11980",903,3},
  {{{0x44accc28c7ca360d}},8,"F-H0-11981",912,7},
  {{{0xcb0f93c7b26d7bb}},10,"F-H0-11982",503,2},
  {{{0x769c9d7264dd94b4}},10,"F-H0-11983",506,4},
  {{{0x769c9d7264dd94b4}},10,"F-H0-11984",432,2},
  {{{0x990d03e1c1c58562}},10,"F-H0-11985",947,3},
  {{{0x3fe6ee51a11e4f74}},8,"F-H0-11986",826,3},
  {{{0x626a6eb04d2f8cc4}},11,"F-H0-11987",384,6},
  {{{0x282af2a5c4a2d71e}},16,"F-H0-11988",902,2},
  {{{0x57af00839004631c}},12,"F-H0-11989",905,2},
  {{{0x62e107054ef85d59}},13,"F-H0-11990",426,4},
  {{{0x7be963e291e9ebe0}},13,"F-H0-11991",428,2},
  {{{0x483542baeb2c388f}},9,"F-H0-11992",837,6},
  {{{0x77764152423f9a2b}},7,"F-H0-11993",419,7},
  {{{0xea37d53e9ab86027}},6,"F-H0-11994",948,2},
  {{{0xea37d53e9ab86027}},6,"F-H0-11995",429,2},
  {{{0xea37d53e9ab86027}},6,"F-H0-11996",874,2},
  {{{0x174bb9147fc8c59e}},11,"F-H0-11997",382,2},
  {{{0x6938a23ba33d9b01}},14,"F-H0-11998",715,6},
  {{{0xf061246f3bd75059}},9,"F-H0-11999",839,5},
  {{{0x70ca11ab79a7919c}},9,"F-H0-12000",837,2},
  {{{0xa3c2b946d81b615f}},10,"F-H0-12001",457,7},
  {{{0x4084c0889b693eca}},8,"F-H0-12002",495,6},
  {{{0x585e95acf8e01260}},7,"F-H0-12003",802,4},
  {{{0xb2768445ba208ffc}},4,"F-H0-12004",875,2},
  {{{0x3429c90d9e5d92ca}},4,"F-H0-12005",457,2},
  {{{0x91b9e85e8978c8f1}},6,"F-H0-12006",567,5},
  {{{0xf1c92144f3dd9858}},9,"F-H0-12007",909,4},
  {{{0xf1c92144f3dd9858}},9,"F-H0-12008",910,2},
  {{{0x77a48f4e5c2789d3}},3,"F-H0-12009",468,4},
  {{{0xd7eeccb410e86425}},6,"F-H0-12010",506,2},
  {{{0xbe48dd10c6b20f06}},6,"F-H0-12011",727,2},
  {{{0x3148aedad9722d69}},6,"F-H0-12012",908,2},
  {{{0xbe2a0d59d880b3c6}},12,"F-H0-12013",578,5},
  {{{0xaf2083bb38d823a3}},13,"F-H0-12014",467,6},
  {{{0x7a7bc009262520fd}},15,"F-H0-12015",462,2},
  {{{0x7506747fdf1668b5}},5,"F-H0-12016",911,3},
  {{{0x3db94264f2e743e6}},9,"F-H0-12017",420,4},
  {{{0xed6311e7dab03ea9}},9,"F-H0-12018",950,2},
  {{{0xc63349464e3c089f}},9,"F-H0-12019",835,5},
  {{{0x223a82d92bebf1b}},15,"F-H0-12020",949,7},
  {{{0x6964f109a968d4e3}},6,"F-H0-12021",938,6},
  {{{0x115c4924e79a84db}},10,"F-H0-12022",615,5},
  {{{0xea4ca6d97f59395d}},8,"F-H0-12023",947,6},
  {{{0x64b7ad356848550d}},7,"F-H0-12024",428,6},
  {{{0xf0b2749b856df2af}},12,"F-H0-12025",837,2},
  {{{0xf0b2749b856df2af}},12,"F-H0-12026",906,2},
  {{{0x3e6c1cc80caa318f}},14,"F-H0-12027",429,5},
  {{{0xb5badebe29b3b17c}},13,"F-H0-12028",677,2},
  {{{0x99eeec03a01e574}},6,"F-H0-12029",462,3},
  {{{0xc1444ecdf23490f4}},6,"F-H0-12030",420,2},
  {{{0xb631558342ea315b}},19,"F-H0-12031",904,4},
  {{{0x8ca33b2e6eca7ebf}},19,"F-H0-12032",766,2},
  {{{0xc247f294df772a37}},7,"F-H0-12033",788,3},
  {{{0x9a16dc30cf2b4bb4}},7,"F-H0-12034",764,3},
  {{{0xfbc2d2bf0a27c1f9}},17,"F-H0-12035",876,2},
  {{{0x9af552cebeb3c76f}},17,"F-H0-12036",803,2},
  {{{0xfbc2d2bf0a27c1f9}},17,"F-H0-12037",1022,2},
  {{{0x9152c4bb38554d3b}},9,"F-H0-12038",949,6},
  {{{0x3927a1f772d63aae}},6,"F-H0-12039",942,2},
  {{{0xe8c42131cd13c2ed}},6,"F-H0-12040",432,4},
  {{{0xe8c42131cd13c2ed}},6,"F-H0-12041",503,3},
  {{{0xe52d5622f25b5e52}},6,"F-H0-12042",873,5},
  {{{0x144d44b2faa2e609}},7,"F-H0-12043",465,2},
  {{{0x4d6141424460902e}},16,"F-H0-12044",494,7},
  {{{0xe90eecb799e2b99}},5,"F-H0-12045",939,3},
  {{{0xab38287796b1c5a9}},9,"F-H0-12046",493,7},
  {{{0x4e8db9b79c0d1336}},5,"F-H0-12047",837,5},
  {{{0x4e8db9b79c0d1336}},5,"F-H0-12048",950,2},
  {{{0x776d608145877382}},10,"F-H0-12049",506,4},
  {{{0x30207a2ba20121a1}},10,"F-H0-12050",432,2},
  {{{0x297964885ddb71d3}},8,"F-H0-12051",455,7},
  {{{0xd5d256de281ea64b}},12,"F-H0-12052",914,4},
  {{{0xdd76fd0d36f363e3}},7,"F-H0-12053",455,5},
  {{{0xa849b1be49d80e75}},3,"F-H0-12054",468,4},
  {{{0x9303f1165a5757c0}},15,"F-H0-12055",983,6},
  {{{0xb5982d25b6f9858}},11,"F-H0-12056",936,4},
  {{{0x99886c667f7b7e55}},19,"F-H0-12057",939,7},
  {{{0xa400e117e57fd1fe}},12,"F-H0-12058",492,2},
  {{{0xa400e117e57fd1fe}},12,"F-H0-12059",458,2},
  {{{0x6635fb2b58162166}},16,"F-H0-12060",985,2},
  {{{0xd1401b52c6e8eef2}},6,"F-H0-12061",492,4},
  {{{0x2d0eb93ff91be51e}},6,"F-H0-12062",468,3},
  {{{0x67c20f9d04f685ab}},6,"F-H0-12063",874,5},
  {{{0xd36cc86ddaf995fb}},11,"F-H0-12064",431,3},
  {{{0x89802659c21a791d}},11,"F-H0-12065",948,2},
  {{{0x49a8484284d3e1e1}},5,"F-H0-12066",911,4},
  {{{0x7eb9350eb4fad5a9}},13,"F-H0-12067",790,5},
  {{{0x4b58a84be2b3a986}},11,"F-H0-12068",948,5},
  {{{0x2df0fbc0ad2b45a}},11,"F-H0-12069",493,2},
  {{{0x252bb8d589c45cc8}},7,"F-H0-12070",543,5},
  {{{0xa33b8276d10edbec}},7,"F-H0-12071",875,6},
  {{{0x57d54683519de080}},4,"F-H0-12072",875,2},
  {{{0x38bfdaf65f158623}},4,"F-H0-12073",469,2},
  {{{0x96b4f0a52b18d40f}},8,"F-H0-12074",543,4},
  {{{0xebe4ef79e5e6692d}},17,"F-H0-12075",905,4},
  {{{0x434cfa111f293b73}},17,"F-H0-12076",950,2},
  {{{0x25f106b22c92bdd5}},12,"F-H0-12077",948,5},
  {{{0xd2559741c56b3773}},12,"F-H0-12078",530,3},
  {{{0x8be90930874e94d3}},12,"F-H0-12079",751,3},
  {{{0xdfded5322748fb9d}},6,"F-H0-12080",900,3},
  {{{0xac097d443a1f5e06}},15,"F-H0-12081",728,4},
  {{{0xac097d443a1f5e06}},15,"F-H0-12082",729,2},
  {{{0xc5cbf3d2b9670452}},16,"F-H0-12083",543,4},
  {{{0x2e06adc7410ab547}},16,"F-H0-12084",530,3},
  {{{0xd9beb0da9c19fbfc}},3,"F-H0-12085",868,2},
  {{{0x70583f3a7e65c108}},10,"F-H0-12086",788,6},
  {{{0xd2d4a3e20e08f61b}},4,"F-H0-12087",543,4},
  {{{0xc586a29e9063184a}},7,"F-H0-12088",901,4},
  {{{0xc0aff74af5164bdb}},8,"F-H0-12089",684,3},
  {{{0xc0aff74af5164bdb}},8,"F-H0-12090",543,3},
  {{{0x16483ed13c8db107}},7,"F-H0-12091",939,2},
  {{{0xe7af0a9603c14c10}},7,"F-H0-12092",431,2},
  {{{0xe7af0a9603c14c10}},7,"F-H0-12093",427,2},
  {{{0xcf298eb41f4b9461}},20,"F-H0-12094",941,5},
  {{{0x716f3709935dc4e5}},17,"F-H0-12095",423,5},
  {{{0xca1eb74d2f30ac8e}},7,"F-H0-12096",865,2},
  {{{0xf66c379e73ccdd75}},7,"F-H0-12097",825,2},
  {{{0xa493d2e809d88640}},10,"F-H0-12098",684,2},
  {{{0xd98f176bea8c44c0}},5,"F-H0-12099",862,2},
  {{{0xc1be5a6bcb4ff92a}},5,"F-H0-12100",825,2},
  {{{0xc1be5a6bcb4ff92a}},5,"F-H0-12101",937,2},
  {{{0x39fe34282972b155}},16,"F-H0-12102",913,5},
  {{{0x44ea9772492a91d2}},5,"F-H0-12103",839,5},
  {{{0x887122d8295aeb00}},18,"F-H0-12104",863,4},
  {{{0x6fe0bf53b4bd3cd5}},10,"F-H0-12105",902,3},
  {{{0xeb5101036835b9cd}},11,"F-H0-12106",678,5},
  {{{0xb213b1f9f286d906}},3,"F-H0-12107",912,3},
  {{{0xb213b1f9f286d906}},3,"F-H0-12108",456,2},
  {{{0x55fb0493a47ca24}},9,"F-H0-12109",986,4},
  {{{0x5870b4736d6a4b6a}},9,"F-H0-12110",579,2},
  {{{0x43c073f640ed1292}},4,"F-H0-12111",464,3},
  {{{0x3a7b3c8214c125e1}},4,"F-H0-12112",455,2},
  {{{0xa45f2fa80e5360d5}},5,"F-H0-12113",424,3},
  {{{0xb2eb0c17cd46fdb3}},5,"F-H0-12114",948,2},
  {{{0x1d790a8005be06d0}},13,"F-H0-12115",867,3},
  {{{0x631e8dbc9ce07935}},6,"F-H0-12116",495,4},
  {{{0x631e8dbc9ce07935}},6,"F-H0-12117",418,3},
  {{{0x54aea45d733404d8}},17,"F-H0-12118",803,4},
  {{{0xb683d494394fa76a}},3,"F-H0-12119",493,4},
  {{{0x80d3e3d72fb144ab}},13,"F-H0-12120",420,7},
  {{{0x18e9c25b7354e4b9}},11,"F-H0-12121",457,2},
  {{{0x18e9c25b7354e4b9}},11,"F-H0-12122",420,2},
  {{{0xc8384ab0b4288913}},6,"F-H0-12123",728,3},
  {{{0xe37808a2e92af28}},12,"F-H0-12124",839,6},
  {{{0x92ab7eeb4624e57a}},14,"F-H0-12125",421,2},
  {{{0x5cdc68601dfad8d2}},6,"F-H0-12126",466,4},
  {{{0xf05e7c8fe57e3bed}},7,"F-H0-12127",419,7},
  {{{0x9ca7c618cfeac72d}},19,"F-H0-12128",907,5},
  {{{0x1043df50df9d74eb}},10,"F-H0-12129",690,4},
  {{{0x97c9a0ef632447bf}},18,"F-H0-12130",421,5},
  {{{0x52d83dbe5ad32214}},9,"F-H0-12131",910,4},
  {{{0x1842d6db2d0fcbaa}},4,"F-H0-12132",937,3},
  {{{0xce6b8e7777d3e6d6}},4,"F-H0-12133",468,2},
  {{{0x63a86b09102caa51}},12,"F-H0-12134",506,4},
  {{{0x33fc23f675cca70}},15,"F-H0-12135",838,4},
  {{{0x42179ded2465c8fa}},15,"F-H0-12136",578,2},
  {{{0xdc46be2959fe883e}},11,"F-H0-12137",974,4},
  {{{0xed91af252041a2bc}},10,"F-H0-12138",543,4},
  {{{0xed91af252041a2bc}},10,"F-H0-12139",542,2},
  {{{0xc47ce7f358c4687b}},10,"F-H0-12140",615,5},
  {{{0xd46ff9e1eec3668b}},18,"F-H0-12141",902,7},
  {{{0x314d6c695077d363}},7,"F-H0-12142",902,3},
  {{{0xd60c548a7ef9b295}},7,"F-H0-12143",542,2},
  {{{0x7a3b1e7e2590b0e8}},5,"F-H0-12144",764,4},
  {{{0xad08c0c9a7bb75ad}},5,"F-H0-12145",946,2},
  {{{0x853fafc5d1e38990}},4,"F-H0-12146",467,3},
  {{{0x853fafc5d1e38990}},4,"F-H0-12147",430,2},
  {{{0x45b58d3dbfd1daf5}},5,"F-H0-12148",945,3},
  {{{0x2d6e955c1545517}},5,"F-H0-12149",420,2},
  {{{0x120c7bf94b90d7fc}},12,"F-H0-12150",381,3},
  {{{0xe7d72e3e88c25865}},18,"F-H0-12151",948,2},
  {{{0xfdec05e88dae3751}},4,"F-H0-12152",495,2},
  {{{0x49da9f36195faf45}},5,"F-H0-12153",543,2},
  {{{0x2d2661214b07c433}},5,"F-H0-12154",802,2},
  {{{0xde9d708d4fd03f5a}},7,"F-H0-12155",382,6},
  {{{0x50157406e5bf6626}},17,"F-H0-12156",951,4},
  {{{0x50157406e5bf6626}},17,"F-H0-12157",984,2},
  {{{0xad5e2bb587a94451}},14,"F-H0-12158",529,7},
  {{{0x1f66f8b04d6ca452}},6,"F-H0-12159",690,3},
  {{{0x8d7f45e46a7de1dc}},7,"F-H0-12160",874,6},
  {{{0xec8c353c3ca9e71a}},7,"F-H0-12161",432,4},
  {{{0xf6e4e7c0f85ec744}},6,"F-H0-12162",529,4},
  {{{0x53bc1401c5aa45ef}},7,"F-H0-12163",466,3},
  {{{0xb734d9f8d1c3fcf}},7,"F-H0-12164",910,2},
  {{{0x2015b1b2f61ad68b}},15,"F-H0-12165",936,4},
  {{{0x2015b1b2f61ad68b}},15,"F-H0-12166",752,3},
  {{{0xaaecd14c11407433}},13,"F-H0-12167",467,3},
  {{{0x950acdafe766fe87}},8,"F-H0-12168",542,2},
  {{{0x65970ecaa297ff4a}},8,"F-H0-12169",839,2},
  {{{0xa8a6086bf413d6f}},8,"F-H0-12170",914,6},
  {{{0xcb0a91430dc1116d}},7,"F-H0-12171",543,4},
  {{{0xcb0a91430dc1116d}},7,"F-H0-12172",468,2},
  {{{0xafe67ee9c7e30ba}},19,"F-H0-12173",839,3},
  {{{0x678454c9354403}},4,"F-H0-12174",420,3},
  {{{0x678454c9354403}},4,"F-H0-12175",457,2},
  {{{0x678454c9354403}},4,"F-H0-12176",911,2},
  {{{0x97867d3a3db275fe}},24,"F-H0-12177",640,6},
  {{{0x32aa0de19f3e62d4}},9,"F-H0-12178",903,4},
  {{{0xa25a4eed42dfa786}},9,"F-H0-12179",603,3},
  {{{0x57c074d22b65d363}},7,"F-H0-12180",801,3},
  {{{0xe4aca7bf9e71972c}},7,"F-H0-12181",900,2},
  {{{0xfb37f7c68ec60751}},16,"F-H0-12182",951,5},
  {{{0xef2da7e6454868c7}},5,"F-H0-12183",825,2},
  {{{0xef2da7e6454868c7}},5,"F-H0-12184",461,2},
  {{{0xba038663632748b2}},7,"F-H0-12185",837,2},
  {{{0x68bebca0634a175b}},8,"F-H0-12186",899,5},
  {{{0x46d5185daf1af3bd}},8,"F-H0-12187",529,5},
  {{{0x3d733048e58526f4}},13,"F-H0-12188",432,6},
  {{{0x103868df647b34c3}},10,"F-H0-12189",751,3},
  {{{0xf229525bab6688cc}},10,"F-H0-12190",947,2},
  {{{0x242b312205867783}},10,"F-H0-12191",424,2},
  {{{0xd807e405dbe1b4dc}},19,"F-H0-12192",908,4},
  {{{0xfe0d054355223374}},6,"F-H0-12193",765,2},
  {{{0x167b355b2dd39142}},4,"F-H0-12194",421,4},
  {{{0x167b355b2dd39142}},4,"F-H0-12195",431,2},
  {{{0x17a33cbf1668bfde}},6,"F-H0-12196",789,3},
  {{{0x39ff0935e6f430f}},8,"F-H0-12197",690,3},
  {{{0x39ff0935e6f430f}},8,"F-H0-12198",727,2},
  {{{0x651d695c8a3e7cfc}},8,"F-H0-12199",530,5},
  {{{0x560b78721254d346}},8,"F-H0-12200",909,2},
  {{{0x8b3024a44b9b0e95}},5,"F-H0-12201",542,3},
  {{{0x898011b2500207ba}},17,"F-H0-12202",987,3},
  {{{0x42fdfd2865c92163}},6,"F-H0-12203",911,5},
  {{{0xe2e2f7603a092f4d}},4,"F-H0-12204",875,4},
  {{{0x42f17cc60155a3b1}},13,"F-H0-12205",947,3},
  {{{0x42f17cc60155a3b1}},13,"F-H0-12206",825,2},
  {{{0xfa020202299ecc63}},6,"F-H0-12207",454,2},
  {{{0x7b71f96074ee4dea}},6,"F-H0-12208",906,2},
  {{{0xfd069c235f5c55b5}},9,"F-H0-12209",986,4},
  {{{0xfd069c235f5c55b5}},9,"F-H0-12210",944,2},
  {{{0x193ea061bc0fea1c}},4,"F-H0-12211",826,2},
  {{{0x1740334b78a5c123}},4,"F-H0-12212",864,2},
  {{{0x8ff902857659dfae}},11,"F-H0-12213",876,5},
  {{{0xa9e492a28391a75c}},11,"F-H0-12214",937,2},
  {{{0x98ec8cbf351c2e90}},6,"F-H0-12215",420,7},
  {{{0xc9530aad753b4e99}},8,"F-H0-12216",543,3},
  {{{0x4cae91222a0ac497}},8,"F-H0-12217",428,2},
  {{{0x2fac15050b27339b}},7,"F-H0-12218",542,3},
  {{{0x42ea8be0da5f8db1}},7,"F-H0-12219",910,2},
  {{{0x5c7575c8426487ad}},8,"F-H0-12220",420,3},
  {{{0x5c7575c8426487ad}},8,"F-H0-12221",457,2},
  {{{0x96be341334c61c7e}},12,"F-H0-12222",945,3},
  {{{0x8cd35647cb8c19f6}},12,"F-H0-12223",947,2},
  {{{0xcd8253953e140b09}},7,"F-H0-12224",873,5},
  {{{0xcd8253953e140b09}},7,"F-H0-12225",950,2},
  {{{0x8b7704f6af5f2bcf}},8,"F-H0-12226",678,3},
  {{{0x141523f41676309c}},11,"F-H0-12227",543,4},
  {{{0xde1fa08e65cbb72}},17,"F-H0-12228",974,4},
  {{{0xdc2a974d4eae059e}},17,"F-H0-12229",502,2},
  {{{0x901a7dc34643bd19}},8,"F-H0-12230",948,7},
  {{{0x7cf69ae0fc79b41a}},11,"F-H0-12231",875,4},
  {{{0xfb23ede2090d41}},6,"F-H0-12232",837,3},
  {{{0x9aed647b7164df8f}},6,"F-H0-12233",529,2},
  {{{0xb7ce08f38e3e75e7}},7,"F-H0-12234",690,4},
  {{{0x2a127a9dc5bca0fc}},8,"F-H0-12235",949,4},
  {{{0xf496c2c19cdb4a48}},8,"F-H0-12236",470,3},
  {{{0x59b0985b1aa2b325}},8,"F-H0-12237",974,5},
  {{{0x817f8332688afd00}},14,"F-H0-12238",939,3},
  {{{0x3430b30999f64e3e}},3,"F-H0-12239",912,5},
  {{{0x7f2166e0bf6abb2c}},7,"F-H0-12240",974,6},
  {{{0xf0f391c4a833a3cd}},6,"F-H0-12241",417,3},
  {{{0xa61c0ce8b04eb236}},6,"F-H0-12242",839,2},
  {{{0x518feb24576a22db}},6,"F-H0-12243",728,2},
  {{{0xf78b6b28634523eb}},2,"F-H0-12244",900,2},
  {{{0x66b29cbc9b755489}},17,"F-H0-12245",950,3},
  {{{0xca48d00e5bd0bf1}},10,"F-H0-12246",529,4},
  {{{0xf2623c9b0bd097bd}},4,"F-H0-12247",764,2},
  {{{0xfeed24a89a57b539}},7,"F-H0-12248",690,5},
  {{{0xfcadbef0b888ac7a}},11,"F-H0-12249",865,6},
  {{{0x8f5e9872d8b55c98}},12,"F-H0-12250",381,7},
  {{{0x3b9dccfb4bea5ae7}},6,"F-H0-12251",902,5},
  {{{0xda243d7322ef13bd}},10,"F-H0-12252",912,6},
  {{{0xf06b0ade97ea98ed}},18,"F-H0-12253",872,7},
  {{{0x591e12448ba9ca7}},6,"F-H0-12254",420,4},
  {{{0x50a21459ef07268a}},6,"F-H0-12255",911,2},
  {{{0x502be7e97ffb753d}},6,"F-H0-12256",908,2},
  {{{0x502be7e97ffb753d}},6,"F-H0-12257",505,2},
  {{{0x502be7e97ffb753d}},6,"F-H0-12258",874,2},
  {{{0xe092896196681b4}},3,"F-H0-12259",468,4},
  {{{0xc00d7fee0de27d1b}},5,"F-H0-12260",908,4},
  {{{0xf617c0817a502bed}},12,"F-H0-12261",381,7},
  {{{0x95a729bd3b673058}},8,"F-H0-12262",947,4},
  {{{0xb125902ee7532ffa}},8,"F-H0-12263",802,2},
  {{{0x7cb056d2b972046d}},7,"F-H0-12264",460,4},
  {{{0x7c686a98a8675e32}},7,"F-H0-12265",802,2},
  {{{0xca97d31e91b8ef73}},11,"F-H0-12266",943,3},
  {{{0xa3ace327d1bb8f3a}},11,"F-H0-12267",714,2},
  {{{0x61f28ed7b17fe4ac}},18,"F-H0-12268",911,5},
  {{{0xfa97acf7afe985c6}},9,"F-H0-12269",874,5},
  {{{0xfa97acf7afe985c6}},9,"F-H0-12270",950,2},
  {{{0x60aadd9fecd0a2ea}},9,"F-H0-12271",617,5},
  {{{0xa6ea147d00252a5a}},5,"F-H0-12272",825,3},
  {{{0x7047afb82841faf1}},5,"F-H0-12273",493,2},
  {{{0xd47ac31623181dae}},14,"F-H0-12274",948,5},
  {{{0x8092eb4d52ea783}},7,"F-H0-12275",429,5},
  {{{0x40a6f48cba56c18b}},6,"F-H0-12276",429,4},
  {{{0x40a6f48cba56c18b}},6,"F-H0-12277",432,2},
  {{{0xa19871ba97ec7a1a}},12,"F-H0-12278",431,6},
  {{{0x2b978f1ec6162831}},10,"F-H0-12279",951,4},
  {{{0x57d5ea70c5816915}},10,"F-H0-12280",492,3},
  {{{0x733c6c190d6910af}},4,"F-H0-12281",764,3},
  {{{0x1964184391fc3c8c}},7,"F-H0-12282",542,6},
  {{{0x47e8da58ad93a20a}},10,"F-H0-12283",913,6},
  {{{0x6cc58e5dbd052d98}},9,"F-H0-12284",986,4},
  {{{0xcc8daee4cbede724}},10,"F-H0-12285",874,5},
  {{{0xd08c149d15a3157d}},9,"F-H0-12286",898,3},
  {{{0xa679e4081d1600cb}},7,"F-H0-12287",653,2},
  {{{0xa679e4081d1600cb}},7,"F-H0-12288",825,2},
  {{{0x89e4b367a27a6b2b}},5,"F-H0-12289",986,3},
  {{{0x709b59e0279776a6}},10,"F-H0-12290",899,4},
  {{{0x3c0f93d882a480f3}},5,"F-H0-12291",424,2},
  {{{0x3c0f93d882a480f3}},5,"F-H0-12292",875,2},
  {{{0xff1b0ac1dda30606}},10,"F-H0-12293",618,5},
  {{{0xf9118d0345b40026}},8,"F-H0-12294",503,7},
  {{{0x59f947c077ee9192}},5,"F-H0-12295",429,5},
  {{{0x59f947c077ee9192}},5,"F-H0-12296",468,2},
  {{{0x3e14008ab1a2f9b7}},7,"F-H0-12297",543,3},
  {{{0x3e14008ab1a2f9b7}},7,"F-H0-12298",691,2},
  {{{0xebe6a21579cae726}},10,"F-H0-12299",382,7},
  {{{0x7c5fbf6ebeb5699c}},8,"F-H0-12300",455,7},
  {{{0xf092bf28188ad2f}},9,"F-H0-12301",865,4},
  {{{0x293a4c889c66370c}},11,"F-H0-12302",431,6},
  {{{0x3b9e152819323a48}},12,"F-H0-12303",866,7},
  {{{0x47498ebcbb5fa070}},12,"F-H0-12304",458,3},
  {{{0x31d8c6172d7e7c94}},12,"F-H0-12305",949,2},
  {{{0x1f0dec94cecb3fb7}},6,"F-H0-12306",914,3},
  {{{0x1f0dec94cecb3fb7}},6,"F-H0-12307",690,2},
  {{{0x11a39b07ae77b7cc}},5,"F-H0-12308",825,3},
  {{{0x448a7b4a7b1656af}},9,"F-H0-12309",984,4},
  {{{0x6f64319d102b70fa}},9,"F-H0-12310",529,2},
  {{{0x1fc984204d949d0b}},8,"F-H0-12311",907,3},
  {{{0x2a997a886e9a9508}},8,"F-H0-12312",914,2},
  {{{0xf1d3e116b37a5434}},4,"F-H0-12313",466,3},
  {{{0x6a1e692ed2429e69}},12,"F-H0-12314",975,3},
  {{{0x909ebb83fc7af1cc}},11,"F-H0-12315",454,4},
  {{{0x41c830397968cfc6}},11,"F-H0-12316",987,3},
  {{{0xd2b362dbb469f167}},6,"F-H0-12317",462,2},
  {{{0xa4dcfd546deda028}},6,"F-H0-12318",986,2},
  {{{0x1a4fa85e2c8b08eb}},5,"F-H0-12319",468,3},
  {{{0xae939c3b142f5f66}},5,"F-H0-12320",938,2},
  {{{0xd01ad08cf48f73f7}},8,"F-H0-12321",418,2},
  {{{0xfd4c0ba7ae436a0d}},8,"F-H0-12322",985,2},
  {{{0xd3ce7033bd87eada}},8,"F-H0-12323",939,2},
  {{{0x81caf2ac74c1a977}},5,"F-H0-12324",910,3},
  {{{0x81caf2ac74c1a977}},5,"F-H0-12325",909,2},
  {{{0x523d857865dfb530}},5,"F-H0-12326",950,2},
  {{{0x4a82b2ee107fccc6}},5,"F-H0-12327",752,2},
  {{{0x30a47a87be60e31b}},8,"F-H0-12328",432,7},
  {{{0xddce0162d3b13bd5}},7,"F-H0-12329",543,3},
  {{{0x5d4bd6b78546ba7a}},3,"F-H0-12330",949,5},
  {{{0x23298630ae342540}},7,"F-H0-12331",530,2},
  {{{0x795dca020fdb46a8}},10,"F-H0-12332",838,3},
  {{{0x737c0df5d5be6a0e}},7,"F-H0-12333",728,3},
  {{{0xe24a0153dfb16d8a}},5,"F-H0-12334",505,4},
  {{{0xb526015fd0b17a10}},5,"F-H0-12335",901,2},
  {{{0xd0c12846a3564859}},5,"F-H0-12336",641,2},
  {{{0x817fd8a5345170dc}},5,"F-H0-12337",947,2},
  {{{0x81344a0d192a2116}},5,"F-H0-12338",616,3},
  {{{0x81344a0d192a2116}},5,"F-H0-12339",580,2},
  {{{0xc8ac1660ad08da2d}},11,"F-H0-12340",902,3},
  {{{0xcb1a93bc7572c8ca}},11,"F-H0-12341",543,3},
  {{{0x43524d8247d6ceac}},10,"F-H0-12342",913,4},
  {{{0xa2b584723399e01c}},5,"F-H0-12343",469,4},
  {{{0x2b16f2082b26b6a7}},8,"F-H0-12344",432,6},
  {{{0xece1d402008e5497}},10,"F-H0-12345",942,6},
  {{{0xc2dea2cd9f9df036}},19,"F-H0-12346",902,2},
  {{{0x50e8da3d7e0da869}},19,"F-H0-12347",941,2},
  {{{0xb5fc6283d826129f}},8,"F-H0-12348",690,4},
  {{{0x2f98ec7658b43159}},9,"F-H0-12349",862,5},
  {{{0x723e35886175f5ac}},7,"F-H0-12350",429,5},
  {{{0x77df79f1ffda545f}},10,"F-H0-12351",865,2},
  {{{0xf189b51ea81fc956}},10,"F-H0-12352",530,2},
  {{{0x9be3aaba36c0a146}},5,"F-H0-12353",949,2},
  {{{0x9be3aaba36c0a146}},5,"F-H0-12354",912,2},
  {{{0xc1bd1e549202b864}},9,"F-H0-12355",495,5},
  {{{0x83ec0a20dd247e27}},7,"F-H0-12356",900,6},
  {{{0xc3927cb4a8574ee8}},5,"F-H0-12357",906,3},
  {{{0xb074080f2580c72f}},5,"F-H0-12358",727,2},
  {{{0x40785c81528bfe63}},2,"F-H0-12359",949,3},
  {{{0xf1ffb82bd769899c}},2,"F-H0-12360",863,2},
  {{{0xa3ad40300de3591c}},8,"F-H0-12361",948,5},
  {{{0x9bf8a84f0b6c3bfb}},6,"F-H0-12362",542,3},
  {{{0x836f543406ea93ef}},6,"F-H0-12363",942,2},
  {{{0xabbf83afaa4e29ce}},15,"F-H0-12364",950,3},
  {{{0x29a3376df5033c69}},15,"F-H0-12365",939,2},
  {{{0xde830868da51c1ba}},10,"F-H0-12366",910,3},
  {{{0xde830868da51c1ba}},10,"F-H0-12367",948,2},
  {{{0xc9659d85883b4e70}},10,"F-H0-12368",506,3},
  {{{0xc9659d85883b4e70}},10,"F-H0-12369",469,2},
  {{{0xebd61e58658d97e0}},9,"F-H0-12370",691,3},
  {{{0x2b25b0d2b89c0703}},9,"F-H0-12371",421,2},
  {{{0x9399bae04651cba8}},4,"F-H0-12372",913,2},
  {{{0x3b9a54a8e133d152}},7,"F-H0-12373",914,3},
  {{{0x26d1982c6532bb5}},7,"F-H0-12374",906,2},
  {{{0x4119501a32be36c5}},8,"F-H0-12375",911,2},
  {{{0x4119501a32be36c5}},8,"F-H0-12376",875,2},
  {{{0xf114d1e57ca00177}},10,"F-H0-12377",431,3},
  {{{0xf114d1e57ca00177}},10,"F-H0-12378",432,3},
  {{{0x5547bf5d99a6ee53}},8,"F-H0-12379",913,5},
  {{{0xbfc749bc6c15476c}},8,"F-H0-12380",951,2},
  {{{0x66c098ef8c5f0ed8}},6,"F-H0-12381",529,2},
  {{{0x66c098ef8c5f0ed8}},6,"F-H0-12382",467,2},
  {{{0x66c098ef8c5f0ed8}},6,"F-H0-12383",579,2},
  {{{0x712f6f0a5291e32e}},8,"F-H0-12384",455,6},
  {{{0xeb0ff4647198fb76}},9,"F-H0-12385",986,5},
  {{{0x512af9859cd5638f}},9,"F-H0-12386",530,2},
  {{{0xf8cc7dec89613c20}},5,"F-H0-12387",461,4},
  {{{0x931a182edea7e826}},5,"F-H0-12388",839,2},
  {{{0x327736df3e36ac3a}},13,"F-H0-12389",765,3},
  {{{0x9807f6a1a81a0c8b}},13,"F-H0-12390",429,2},
  {{{0xdb02f535303f5abd}},9,"F-H0-12391",876,6},
  {{{0xf6f4ac1699581bc0}},14,"F-H0-12392",421,3},
  {{{0xbbd85b622592a034}},14,"F-H0-12393",828,2},
  {{{0xa47cf80dd8a17db8}},13,"F-H0-12394",422,7},
  {{{0x84809a142b581476}},7,"F-H0-12395",950,4},
  {{{0x923ae5534b75d439}},10,"F-H0-12396",949,3},
  {{{0xb6a5f9290dbe50ac}},10,"F-H0-12397",941,2},
  {{{0x83f27b4e80788513}},4,"F-H0-12398",901,5},
  {{{0xbc8deddd11d25043}},23,"F-H0-12399",418,7},
  {{{0x694fe3ac74bc348c}},9,"F-H0-12400",541,7},
  {{{0x4031801eebcc7e02}},13,"F-H0-12401",949,7},
  {{{0xe886b1c52db4128a}},13,"F-H0-12402",840,6},
  {{{0xbeac0a1c23383bd3}},10,"F-H0-12403",426,5},
  {{{0x860377fd29b8273b}},13,"F-H0-12404",936,3},
  {{{0x55d12df0436e12d0}},13,"F-H0-12405",429,2},
  {{{0x55d12df0436e12d0}},13,"F-H0-12406",541,2},
  {{{0xc7fd35ae0684786e}},16,"F-H0-12407",800,5},
  {{{0xe05e228adc3bab28}},13,"F-H0-12408",947,7},
  {{{0x81f3ae0e6ef81071}},7,"F-H0-12409",469,6},
  {{{0xa284cc00cb4839}},6,"F-H0-12410",604,2},
  {{{0xe3ef00ec6951c800}},14,"F-H0-12411",789,4},
  {{{0x1192c088c5efac6d}},5,"F-H0-12412",911,2},
  {{{0x601b250024cc255b}},5,"F-H0-12413",460,2},
  {{{0x8539e057c33f4617}},6,"F-H0-12414",690,4},
  {{{0x8539e057c33f4617}},6,"F-H0-12415",470,2},
  {{{0x6074ad2db6ac38f6}},17,"F-H0-12416",943,5},
  {{{0x4ea779c4bace8cd5}},15,"F-H0-12417",987,7},
  {{{0x524210d9865ad104}},10,"F-H0-12418",938,3},
  {{{0x12075c359ccda73f}},15,"F-H0-12419",984,7},
  {{{0xa08ea0d077eca4a0}},7,"F-H0-12420",458,3},
  {{{0xb378525f90acc259}},7,"F-H0-12421",827,6},
  {{{0x6f69111d5f2dc26d}},15,"F-H0-12422",825,3},
  {{{0x6ff84b89dad09e4}},10,"F-H0-12423",912,6},
  {{{0xaada5c83fa57b4aa}},7,"F-H0-12424",913,3},
  {{{0xc378eed7c4017eaf}},7,"F-H0-12425",947,3},
  {{{0x8b24c82c7178d22}},13,"F-H0-12426",640,2},
  {{{0x5130746d54f211ef}},13,"F-H0-12427",432,7},
  {{{0xc39c470d41eb3ab4}},10,"F-H0-12428",839,4},
  {{{0xc39c470d41eb3ab4}},10,"F-H0-12429",802,2},
  {{{0x7719a1a851334c3b}},12,"F-H0-12430",393,7},
  {{{0xae0d7f90b8f72cf1}},8,"F-H0-12431",899,3},
  {{{0xa25a0fe874a3a74b}},8,"F-H0-12432",419,3},
  {{{0x9f8885001a68fc8d}},19,"F-H0-12433",872,2},
  {{{0xff713fba436b6b72}},8,"F-H0-12434",431,5},
  {{{0x88629200f54661dc}},3,"F-H0-12435",462,2},
  {{{0x88629200f54661dc}},3,"F-H0-12436",912,2},
  {{{0x1406c8bfc6a118bb}},14,"F-H0-12437",936,6},
  {{{0x4cf34f8f438679f0}},15,"F-H0-12438",836,5},
  {{{0x79398565f961a470}},14,"F-H0-12439",507,5},
  {{{0xa876ebbe4f36df30}},12,"F-H0-12440",641,3},
  {{{0x1b3779d237be83fd}},12,"F-H0-12441",788,2},
  {{{0x18e4e24c7cf0776a}},11,"F-H0-12442",429,7},
  {{{0x629266b4627bf274}},7,"F-H0-12443",825,2},
  {{{0xe17319edd64004b1}},7,"F-H0-12444",911,2},
  {{{0xd632d7a28e90e476}},14,"F-H0-12445",839,4},
  {{{0x4aadb1ca5eac1652}},6,"F-H0-12446",456,3},
  {{{0x4aadb1ca5eac1652}},6,"F-H0-12447",903,2},
  {{{0xb08ea2070428927f}},11,"F-H0-12448",383,7},
  {{{0x305a04d0cd5d49fc}},5,"F-H0-12449",943,7},
  {{{0xa5f59f9fd5d2240}},7,"F-H0-12450",799,2},
  {{{0x56d99d8223500873}},13,"F-H0-12451",976,5},
  {{{0x69a410fd8f21feb}},15,"F-H0-12452",765,7},
  {{{0x5c998d06485be223}},8,"F-H0-12453",873,6},
  {{{0x28c64be702e20ccc}},3,"F-H0-12454",456,5},
  {{{0x3ff8964cfcd9614a}},14,"F-H0-12455",941,4},
  {{{0xbd1e372a9002faab}},9,"F-H0-12456",950,2},
  {{{0xbd1e372a9002faab}},9,"F-H0-12457",763,2},
  {{{0x171e300737700a52}},7,"F-H0-12458",429,4},
  {{{0xf03e1040364e531c}},7,"F-H0-12459",456,3},
  {{{0xa4c4dd925439863c}},5,"F-H0-12460",825,4},
  {{{0x7a2173031e12ca93}},5,"F-H0-12461",943,4},
  {{{0x1907c4645ea7ce3a}},5,"F-H0-12462",939,2},
  {{{0xff0255ae2b65ff45}},6,"F-H0-12463",492,2},
  {{{0x8e6dcddc8fa3f91e}},6,"F-H0-12464",940,2},
  {{{0x5c62c4d6f5c849ad}},6,"F-H0-12465",432,2},
  {{{0xf8939540e27ac4aa}},6,"F-H0-12466",839,2},
  {{{0xba0e053d7389f22d}},11,"F-H0-12467",469,4},
  {{{0xed40eb3b3a6d3f94}},4,"F-H0-12468",943,2},
  {{{0x9b4a2cdb221a0f27}},14,"F-H0-12469",543,5},
  {{{0x2058aa79f442ef89}},10,"F-H0-12470",937,3},
  {{{0x3576d59237b35284}},10,"F-H0-12471",456,3},
  {{{0xeb4a8aed67e6936}},3,"F-H0-12472",950,3},
  {{{0xcfea96bb108cd2c5}},6,"F-H0-12473",764,3},
  {{{0xcfea96bb108cd2c5}},6,"F-H0-12474",530,2},
  {{{0xac615d5e5a5f6a80}},4,"F-H0-12475",912,4},
  {{{0xabac63b052e5e2fb}},8,"F-H0-12476",465,5},
  {{{0x27234fc0d12bc634}},15,"F-H0-12477",417,6},
  {{{0xd4cab071ac2f7070}},7,"F-H0-12478",678,3},
  {{{0x110627d1008c282b}},7,"F-H0-12479",947,2},
  {{{0x44a4a3c53c838bbd}},7,"F-H0-12480",678,3},
  {{{0xb671464ee100f46a}},13,"F-H0-12481",691,7},
  {{{0x8a4edc0855a08239}},6,"F-H0-12482",865,3},
  {{{0xa66097bbf4daea6b}},6,"F-H0-12483",863,2},
  {{{0xaef4bb625ec96df9}},5,"F-H0-12484",838,3},
  {{{0x541c32e81cdb35b9}},5,"F-H0-12485",909,2},
  {{{0xe3a22f4180078a12}},4,"F-H0-12486",939,3},
  {{{0xe3a22f4180078a12}},4,"F-H0-12487",715,2},
  {{{0xe3a22f4180078a12}},4,"F-H0-12488",902,2},
  {{{0x1ad5a3f6c9393c24}},11,"F-H0-12489",790,3},
  {{{0x6e8f8d5a858f174e}},11,"F-H0-12490",567,2},
  {{{0x8673f237ab181d22}},4,"F-H0-12491",541,4},
  {{{0xc2e464903b3d7c6b}},9,"F-H0-12492",457,7},
  {{{0xf0fdd703ad033f32}},7,"F-H0-12493",946,3},
  {{{0xf0fdd703ad033f32}},7,"F-H0-12494",948,2},
  {{{0xcdbb21a9da859b52}},7,"F-H0-12495",902,2},
  {{{0x2d17deab8e0e2758}},5,"F-H0-12496",911,2},
  {{{0x6addf345614b868}},7,"F-H0-12497",617,6},
  {{{0x372214435c2c424f}},8,"F-H0-12498",873,5},
  {{{0xf0d8d3b77a368fb8}},8,"F-H0-12499",432,2},
  {{{0x6db70f1a6f90d4dc}},9,"F-H0-12500",678,4},
  {{{0xc1da138f19dab786}},8,"F-H0-12501",543,4},
  {{{0x9adeb14de671ba44}},8,"F-H0-12502",838,2},
  {{{0xf748d69f1aed0231}},5,"F-H0-12503",899,6},
  {{{0xcaaec56d148c1aac}},3,"F-H0-12504",901,6},
  {{{0xdc62ec103aaaab89}},8,"F-H0-12505",911,4},
  {{{0xdc62ec103aaaab89}},8,"F-H0-12506",949,3},
  {{{0x6528bd882c1b55be}},6,"F-H0-12507",909,2},
  {{{0x26028e62b8d417f8}},3,"F-H0-12508",456,6},
  {{{0x40cabb5ec65dc49}},8,"F-H0-12509",542,4},
  {{{0xfede8c7067df82fb}},5,"F-H0-12510",469,7},
  {{{0x67597f5f047b4224}},9,"F-H0-12511",948,4},
  {{{0x275ba3725049a7a7}},6,"F-H0-12512",913,6},
  {{{0x88458ccd0277d34f}},4,"F-H0-12513",936,3},
  {{{0x6c7145a787fae106}},16,"F-H0-12514",800,6},
  {{{0x4bfa82c645b898f4}},5,"F-H0-12515",429,3},
  {{{0xdff172a2937ed28f}},5,"F-H0-12516",826,3},
  {{{0xf1123422ddf3b9d2}},6,"F-H0-12517",529,4},
  {{{0x68622acedb159173}},6,"F-H0-12518",462,2},
  {{{0xfba9d4850b5df753}},2,"F-H0-12519",948,2},
  {{{0xc92daaf19b862097}},2,"F-H0-12520",493,2},
  {{{0xbebf95183b0e8d04}},6,"F-H0-12521",421,3},
  {{{0x9714ab250046338e}},6,"F-H0-12522",941,3},
  {{{0xceae2a99785ee2b3}},14,"F-H0-12523",801,5},
  {{{0x12aa5307ec79788d}},14,"F-H0-12524",690,2},
  {{{0x17a0e93d7c16cf4d}},15,"F-H0-12525",986,3},
  {{{0x160168a8d8400373}},10,"F-H0-12526",468,7},
  {{{0xaa633ff9680690fd}},16,"F-H0-12527",422,7},
  {{{0xf943dbe535b7d493}},8,"F-H0-12528",530,3},
  {{{0xf943dbe535b7d493}},8,"F-H0-12529",531,2},
  {{{0x95e2fd2b448aa1f0}},8,"F-H0-12530",467,3},
  {{{0xd33082faea344aa4}},7,"F-H0-12531",948,6},
  {{{0x8c31a39c8241f7ad}},5,"F-H0-12532",911,4},
  {{{0x8e14f0e06c02289}},15,"F-H0-12533",690,4},
  {{{0x8e14f0e06c02289}},15,"F-H0-12534",727,2},
  {{{0x12d302835629135b}},7,"F-H0-12535",936,2},
  {{{0x12d302835629135b}},7,"F-H0-12536",862,2},
  {{{0x449a32f7094f1853}},11,"F-H0-12537",715,7},
  {{{0x5fdb9ce2e135b2e2}},6,"F-H0-12538",421,3},
  {{{0x5fdb9ce2e135b2e2}},6,"F-H0-12539",862,2},
  {{{0x2a65cdf7aeb96d3d}},6,"F-H0-12540",543,4},
  {{{0x978524cb7f956317}},6,"F-H0-12541",468,3},
  {{{0xa9e7fc04e97f0eb6}},7,"F-H0-12542",418,3},
  {{{0xb7beafcc44cfc57c}},7,"F-H0-12543",467,2},
  {{{0x59bb2622415770c7}},18,"F-H0-12544",902,2},
  {{{0xa056876142ad8c9e}},15,"F-H0-12545",902,2},
  {{{0x803918461b9ff997}},5,"F-H0-12546",838,4},
  {{{0x23fb55fec6f6939d}},20,"F-H0-12547",860,4},
  {{{0x18135b5a1053f9a3}},20,"F-H0-12548",423,3},
  {{{0xccfe3d0fe9fd158}},14,"F-H0-12549",937,5},
  {{{0xae2ce74cb99c79b5}},6,"F-H0-12550",531,2},
  {{{0xd02489eb5ce2dce9}},4,"F-H0-12551",948,3},
  {{{0x3c6df7467c8fd713}},10,"F-H0-12552",616,3},
  {{{0x71bfff7ea8b9e348}},15,"F-H0-12553",458,2},
  {{{0x19698a3548459327}},15,"F-H0-12554",839,2},
  {{{0x57b46732abfd552c}},11,"F-H0-12555",986,3},
  {{{0x2a7615381da155f7}},11,"F-H0-12556",678,2},
  {{{0x7694216c2de69f08}},13,"F-H0-12557",910,7},
  {{{0x8b75eba6478900db}},11,"F-H0-12558",862,4},
  {{{0x45b8136db01b01cb}},3,"F-H0-12559",456,2},
  {{{0x9f217435e0148f69}},3,"F-H0-12560",456,4},
  {{{0x9f217435e0148f69}},3,"F-H0-12561",455,3},
  {{{0x8243491031ad8671}},4,"F-H0-12562",949,2},
  {{{0x19f8eb420fa8cfda}},14,"F-H0-12563",727,7},
  {{{0x7fc91d2b4d2d54f1}},7,"F-H0-12564",837,4},
  {{{0x204222941d5ee440}},7,"F-H0-12565",493,2},
  {{{0xb672d3df57952cfb}},16,"F-H0-12566",790,6},
  {{{0x3070f2d8e50f829}},7,"F-H0-12567",801,4},
  {{{0x3070f2d8e50f829}},7,"F-H0-12568",836,2},
  {{{0x5a368f8e166a870a}},5,"F-H0-12569",429,4},
  {{{0x5a368f8e166a870a}},5,"F-H0-12570",466,3},
  {{{0x253311a46907f3e2}},8,"F-H0-12571",825,7},
  {{{0xb3d2ee412ceacce4}},10,"F-H0-12572",910,3},
  {{{0xb3d2ee412ceacce4}},10,"F-H0-12573",947,2},
  {{{0x492fe2ca2b715e33}},7,"F-H0-12574",825,2},
  {{{0x77e977b5ed2b808f}},7,"F-H0-12575",912,2},
  {{{0xa01a26a0d56eb937}},6,"F-H0-12576",421,7},
  {{{0x42024d2e3b6d66d0}},10,"F-H0-12577",788,3},
  {{{0xb8c551c2f82d4d48}},10,"F-H0-12578",948,2},
  {{{0x4806fbe75a4b206e}},9,"F-H0-12579",566,3},
  {{{0x46b625e64a766a7d}},5,"F-H0-12580",839,5},
  {{{0x46b625e64a766a7d}},5,"F-H0-12581",945,2},
  {{{0x234988498278d9fb}},5,"F-H0-12582",837,7},
  {{{0x1fba0442f36119c1}},12,"F-H0-12583",825,3},
  {{{0x6bcfc9e8e080824f}},3,"F-H0-12584",455,4},
  {{{0xd1ffca20f5e835b7}},3,"F-H0-12585",468,3},
  {{{0x392ee85a7a85dbaa}},4,"F-H0-12586",462,2},
  {{{0x8318898a0587e2fd}},11,"F-H0-12587",910,2},
  {{{0x6decc7a24cc788d2}},8,"F-H0-12588",506,2},
  {{{0x6decc7a24cc788d2}},8,"F-H0-12589",468,2},
  {{{0x4fb2fbef41f7d1cf}},8,"F-H0-12590",912,6},
  {{{0x3f42d60942e362e1}},8,"F-H0-12591",418,3},
  {{{0x3f42d60942e362e1}},8,"F-H0-12592",531,2},
  {{{0xfe063f59de09dd36}},3,"F-H0-12593",975,4},
  {{{0x97da6f2041411146}},5,"F-H0-12594",542,3},
  {{{0x40206f5091e51297}},6,"F-H0-12595",427,5},
  {{{0x145453c2da160a6e}},6,"F-H0-12596",382,4},
  {{{0x14d220bb81c3216d}},6,"F-H0-12597",906,3},
  {{{0xa4bd1757536b158c}},6,"F-H0-12598",825,4},
  {{{0x1990cbd88c17528f}},6,"F-H0-12599",906,4},
  {{{0x846a29aad278d34}},6,"F-H0-12600",429,2},
  {{{0xe3ffd01007f3b323}},9,"F-H0-12601",939,3},
  {{{0x2ed89429e7e61fd8}},9,"F-H0-12602",427,2},
  {{{0xcee6ff1bf3bc0394}},4,"F-H0-12603",947,2},
  {{{0xf01be235a4e8db1b}},20,"F-H0-12604",505,4},
  {{{0x9f18325450a971f6}},9,"F-H0-12605",654,4},
  {{{0x9f18325450a971f6}},9,"F-H0-12606",616,3},
  {{{0x15e317cb5c4fd378}},12,"F-H0-12607",906,2},
  {{{0x16f5bc852ee41f39}},12,"F-H0-12608",690,2},
  {{{0xeb39ffce8f379a92}},6,"F-H0-12609",839,4},
  {{{0x2d9e1204d15ea9ae}},6,"F-H0-12610",421,2},
  {{{0xe03166c436589e67}},9,"F-H0-12611",423,6},
  {{{0x4ba778f5ec53c212}},4,"F-H0-12612",876,2},
  {{{0x60930d6e2f72ff75}},8,"F-H0-12613",678,6},
  {{{0xabd8622acde1d8a5}},15,"F-H0-12614",529,4},
  {{{0xab358107c90fec18}},8,"F-H0-12615",948,5},
  {{{0x75f9cb6e30f4af1f}},8,"F-H0-12616",899,7},
  {{{0x3f1fb23c0e215642}},15,"F-H0-12617",862,5},
  {{{0x3c2e829ffa4c2e7a}},4,"F-H0-12618",457,4},
  {{{0x37fb11071f5fb633}},4,"F-H0-12619",493,2},
  {{{0x8a4d3448d88fb895}},9,"F-H0-12620",425,2},
  {{{0x8a4d3448d88fb895}},9,"F-H0-12621",943,2},
  {{{0x7e444e7425d83511}},6,"F-H0-12622",466,4},
  {{{0xec5107a3af936b99}},5,"F-H0-12623",604,3},
  {{{0x5f21afc956d8f56e}},8,"F-H0-12624",567,4},
  {{{0x90a69f7f218ea261}},8,"F-H0-12625",432,2},
  {{{0x993613c08612640f}},11,"F-H0-12626",839,5},
  {{{0x636a3d37011167c2}},9,"F-H0-12627",975,6},
  {{{0x5b3942e756e2e43a}},7,"F-H0-12628",949,3},
  {{{0xecd666d63abde0ef}},5,"F-H0-12629",457,5},
  {{{0xf84248d240f54055}},9,"F-H0-12630",987,3},
  {{{0x343c8bad90e59ab8}},14,"F-H0-12631",913,7},
  {{{0x1acd468feadcc83}},6,"F-H0-12632",617,5},
  {{{0x3965c2ba8be6ed4c}},4,"F-H0-12633",906,2},
  {{{0xf0150ef20517cf99}},11,"F-H0-12634",459,4},
  {{{0xf0150ef20517cf99}},11,"F-H0-12635",425,3},
  {{{0x7ac24f5a5218be4f}},11,"F-H0-12636",867,3},
  {{{0x4fa16ad0d3c1e42d}},11,"F-H0-12637",982,4},
  {{{0x4fa16ad0d3c1e42d}},11,"F-H0-12638",908,2},
  {{{0x90614c03de083d}},18,"F-H0-12639",873,7},
  {{{0x41b0c20ded9f6c64}},8,"F-H0-12640",827,5},
  {{{0xe14c1124a1a47024}},15,"F-H0-12641",751,7},
  {{{0x98998b2c93b1f4af}},13,"F-H0-12642",420,6},
  {{{0x6e4819e46a7a4087}},6,"F-H0-12643",913,6},
  {{{0xc7780a78eb8c5215}},17,"F-H0-12644",983,7},
  {{{0x38303a4984a1c14c}},4,"F-H0-12645",543,2},
  {{{0x37328ad9a3e9c27b}},5,"F-H0-12646",865,7},
  {{{0x4c083138f4e8db39}},11,"F-H0-12647",947,3},
  {{{0x4c083138f4e8db39}},11,"F-H0-12648",943,3},
  {{{0x39dd9f1672c01ca9}},9,"F-H0-12649",789,2},
  {{{0x5e85a76207971720}},8,"F-H0-12650",826,5},
  {{{0xd0d7b40aa2a05353}},7,"F-H0-12651",825,2},
  {{{0x4bd8991bd8e36c85}},7,"F-H0-12652",640,2},
  {{{0xfca4a240f80da37d}},13,"F-H0-12653",677,7},
  {{{0xafa2bbf2b02aac2f}},10,"F-H0-12654",529,2},
  {{{0x188f4b309e59db55}},10,"F-H0-12655",456,2},
  {{{0x7a3b752e5da2f57}},13,"F-H0-12656",986,2},
  {{{0xfc8783f710d0b7f1}},6,"F-H0-12657",765,3},
  {{{0x6f53c3beeba649f6}},5,"F-H0-12658",837,5},
  {{{0x15feec2c1e8860}},5,"F-H0-12659",457,2},
  {{{0x83811b39fc5f3e2d}},5,"F-H0-12660",838,2},
  {{{0x89b9748763db086}},5,"F-H0-12661",543,2},
  {{{0x3fe77ee66cf4c096}},5,"F-H0-12662",460,2},
  {{{0x210466127f015f08}},7,"F-H0-12663",465,3},
  {{{0x8055520f27251e3e}},7,"F-H0-12664",873,2},
  {{{0xfeb18aa8accf99ac}},19,"F-H0-12665",907,6},
  {{{0xd44588b745021404}},7,"F-H0-12666",382,3},
  {{{0xc467e8b37a17662f}},7,"F-H0-12667",906,2},
  {{{0x935fce9651b9cc0e}},7,"F-H0-12668",468,4},
  {{{0xf9fa0500b40a2669}},7,"F-H0-12669",429,3},
  {{{0x1565dd4d8c8bb750}},15,"F-H0-12670",980,2},
  {{{0x1565dd4d8c8bb750}},15,"F-H0-12671",825,2},
  {{{0x1565dd4d8c8bb750}},15,"F-H0-12672",867,2},
  {{{0x31d23d8cc1ea1be7}},8,"F-H0-12673",494,7},
  {{{0x220b8c0ec4959c5e}},13,"F-H0-12674",950,5},
  {{{0x17f61bef2503245f}},18,"F-H0-12675",799,3},
  {{{0xa3fc01a595a7ba88}},12,"F-H0-12676",911,2},
  {{{0xc4e7b13ad3acf053}},12,"F-H0-12677",945,2},
  {{{0x1cabd597a59bc8ad}},11,"F-H0-12678",690,4},
  {{{0xd2457e890af272f0}},11,"F-H0-12679",914,2},
  {{{0x7dab01c2e1f884fb}},6,"F-H0-12680",911,6},
  {{{0xe528c27c42d20f89}},10,"F-H0-12681",392,3},
  {{{0x555e429a3c59476b}},10,"F-H0-12682",422,2},
  {{{0x6b2b0edec29a9b2d}},12,"F-H0-12683",945,2},
  {{{0xf6bc6d9217e11cb1}},9,"F-H0-12684",839,5},
  {{{0xc548c83ce73c5059}},9,"F-H0-12685",936,2},
  {{{0x4eda3fc8624c223e}},15,"F-H0-12686",429,6},
  {{{0xf8eba2b43bb38ede}},14,"F-H0-12687",421,6},
  {{{0x838b335a9d4c517}},10,"F-H0-12688",789,5},
  {{{0x6882131e4459f9a}},11,"F-H0-12689",875,6},
  {{{0x7580df3d0ef454ab}},14,"F-H0-12690",942,2},
  {{{0xcb756d236fc55864}},4,"F-H0-12691",876,4},
  {{{0xcb756d236fc55864}},4,"F-H0-12692",542,2},
  {{{0xac264de8dfe221f5}},6,"F-H0-12693",936,6},
  {{{0x2fbe22bd359ee083}},13,"F-H0-12694",945,6},
  {{{0x52b81bea1d15a320}},11,"F-H0-12695",936,4},
  {{{0x5ae7a079431e9eef}},7,"F-H0-12696",947,3},
  {{{0xd9448540690a9f47}},16,"F-H0-12697",421,3},
  {{{0x2636fdd2e8219bc8}},16,"F-H0-12698",428,3},
  {{{0xf419ebf92c8990d}},7,"F-H0-12699",907,5},
  {{{0x565ea3fdb560f61e}},19,"F-H0-12700",909,7},
  {{{0x3a36b6bf27bf7c6c}},3,"F-H0-12701",912,3},
  {{{0x24ad90a4f1ec918a}},3,"F-H0-12702",469,3},
  {{{0xcbe95a87f3aeed63}},15,"F-H0-12703",543,4},
  {{{0x162450fca0b64d13}},11,"F-H0-12704",840,4},
  {{{0x162450fca0b64d13}},11,"F-H0-12705",948,2},
  {{{0xee1edb97eb509a15}},17,"F-H0-12706",949,4},
  {{{0xdb95525b192a720d}},14,"F-H0-12707",876,5},
  {{{0x1656240b35c198}},5,"F-H0-12708",431,4},
  {{{0xc77289007d1c9d8d}},5,"F-H0-12709",863,2},
  {{{0x3a3703990a1d19c1}},14,"F-H0-12710",948,7},
  {{{0xd58144473a01d7fc}},5,"F-H0-12711",456,3},
  {{{0x4d67f132545049da}},5,"F-H0-12712",469,2},
  {{{0xd58144473a01d7fc}},5,"F-H0-12713",492,2},
  {{{0x56ebaf4466916c95}},7,"F-H0-12714",936,3},
  {{{0xf211c96374022d9b}},12,"F-H0-12715",529,3},
  {{{0x9a9b0fee1a88f9e7}},12,"F-H0-12716",765,2},
  {{{0x12ab24657cb1452d}},4,"F-H0-12717",543,4},
  {{{0x5b39458f5ed8e673}},5,"F-H0-12718",825,3},
  {{{0x5b39458f5ed8e673}},5,"F-H0-12719",839,3},
  {{{0x8ec46131d3a8dda7}},9,"F-H0-12720",418,4},
  {{{0x29f3445b7ba31f90}},9,"F-H0-12721",986,2},
  {{{0xbc2807bc9c514328}},19,"F-H0-12722",984,3},
  {{{0x15c057477fdb6e79}},4,"F-H0-12723",468,2},
  {{{0xde6f820f42d2a2f0}},4,"F-H0-12724",469,2},
  {{{0xb687eeedebdff6f2}},6,"F-H0-12725",911,4},
  {{{0x2a17b19c4a4fab30}},6,"F-H0-12726",542,3},
  {{{0x2a17b19c4a4fab30}},6,"F-H0-12727",466,2},
  {{{0x53d00390664bc294}},5,"F-H0-12728",943,2},
  {{{0xd3684242d5207a79}},13,"F-H0-12729",825,5},
  {{{0x3d4b1da3974c6c9c}},6,"F-H0-12730",567,6},
  {{{0x552118a644820937}},5,"F-H0-12731",727,2},
  {{{0xdb9215d66dcf9644}},11,"F-H0-12732",467,4},
  {{{0xa38d2ae8592f1747}},9,"F-H0-12733",827,6},
  {{{0xb5d9e238b05e4f70}},7,"F-H0-12734",911,2},
  {{{0x3e5f4b7da52e4582}},8,"F-H0-12735",690,2},
  {{{0x3e5f4b7da52e4582}},8,"F-H0-12736",467,2},
  {{{0xf7cf55b5a5f2eec5}},12,"F-H0-12737",938,5},
  {{{0xebb455e5c83814ad}},8,"F-H0-12738",874,6},
  {{{0xc207071075284c3d}},13,"F-H0-12739",382,4},
  {{{0x5251db2707c956b1}},17,"F-H0-12740",802,3},
  {{{0xae6cd5fa5dcd458}},5,"F-H0-12741",466,2},
  {{{0x581e4e882347765d}},11,"F-H0-12742",529,4},
  {{{0xae3067186c56b3e0}},7,"F-H0-12743",913,6},
  {{{0xe2beef252a787d47}},11,"F-H0-12744",383,6},
  {{{0x15f7f717a5eb7869}},12,"F-H0-12745",496,5},
  {{{0x9696eb3dbd46f5e9}},8,"F-H0-12746",715,2},
  {{{0xf84df6ff39d6bed0}},6,"F-H0-12747",617,2},
  {{{0xf6416faafd27074a}},6,"F-H0-12748",826,2},
  {{{0xcfe86d2a809413a}},9,"F-H0-12749",801,6},
  {{{0x2a699fc68c5c3ed4}},17,"F-H0-12750",951,3},
  {{{0x2a699fc68c5c3ed4}},17,"F-H0-12751",986,2},
  {{{0xd20168cc3a0dd77b}},17,"F-H0-12752",876,3},
  {{{0xd04b9872a61611a5}},17,"F-H0-12753",977,2},
  {{{0xb9df8a8f8c29f70}},6,"F-H0-12754",801,3},
  {{{0xe2bffa8a46be2262}},22,"F-H0-12755",390,4},
  {{{0xe2bffa8a46be2262}},22,"F-H0-12756",543,2},
  {{{0xcfe2d56b7fa66aa3}},6,"F-H0-12757",455,2},
  {{{0x580d77e9fa1320d4}},6,"F-H0-12758",910,2},
  {{{0xbab2bcaaf557550d}},9,"F-H0-12759",906,3},
  {{{0xe5842086e2ba9011}},5,"F-H0-12760",493,2},
  {{{0xfee7d6b80e1ca5eb}},13,"F-H0-12761",506,4},
  {{{0x307ca83ab47c76d2}},5,"F-H0-12762",949,3},
  {{{0x9156be4ef1f3d9a9}},7,"F-H0-12763",494,5},
  {{{0xf49c4bf92554248b}},6,"F-H0-12764",950,2},
  {{{0x2398309e8646f061}},15,"F-H0-12765",939,4},
  {{{0xfa2bea20a4be2afe}},11,"F-H0-12766",528,5},
  {{{0x7c815663cc264abf}},22,"F-H0-12767",529,2},
  {{{0x33fe9e6814324b64}},7,"F-H0-12768",949,6},
  {{{0x3f827277644cc453}},9,"F-H0-12769",873,5},
  {{{0x2c73bb31f879824b}},11,"F-H0-12770",873,5},
  {{{0x932912ccbc579ffe}},7,"F-H0-12771",603,2},
  {{{0x863bc50184826eb5}},9,"F-H0-12772",901,2},
  {{{0x3a3d53b0ee861420}},15,"F-H0-12773",978,4},
  {{{0xbb8f83b57a73c4fb}},10,"F-H0-12774",900,6},
  {{{0x868557a5db01c3f6}},9,"F-H0-12775",936,3},
  {{{0x42b172b61b093fe}},7,"F-H0-12776",837,2},
  {{{0x7c604d50948c1bee}},9,"F-H0-12777",690,3},
  {{{0xdff28263d5973fc9}},6,"F-H0-12778",678,2},
  {{{0xe0fb0bef2993f65c}},9,"F-H0-12779",948,3},
  {{{0xe0fb0bef2993f65c}},9,"F-H0-12780",950,2},
  {{{0xe2a0d0d0a2abf468}},9,"F-H0-12781",987,6},
  {{{0x4c558552f1322340}},8,"F-H0-12782",949,4},
  {{{0xe0e8c39dcc6e435c}},9,"F-H0-12783",876,5},
  {{{0xcb5aaa91c41d0be6}},3,"F-H0-12784",912,2},
  {{{0x4bd96f60f2cf7035}},3,"F-H0-12785",418,2},
  {{{0xa83218dfbf6010de}},10,"F-H0-12786",530,6},
  {{{0xc4a1248612d4d283}},6,"F-H0-12787",504,3},
  {{{0x972226995bae5f1e}},6,"F-H0-12788",751,3},
  {{{0x3a847b791f534aa0}},6,"F-H0-12789",678,2},
  {{{0x3a847b791f534aa0}},6,"F-H0-12790",690,2},
  {{{0xe085edcdfeed352e}},12,"F-H0-12791",825,3},
  {{{0x982281a1238455a6}},14,"F-H0-12792",421,6},
  {{{0xf22c25a0e1ed73fc}},13,"F-H0-12793",825,3},
  {{{0x45f4d9330f6ae3b3}},8,"F-H0-12794",506,6},
  {{{0xc614e92805eb9e67}},9,"F-H0-12795",455,2},
  {{{0x6d19a7ce8d09ef90}},12,"F-H0-12796",911,6},
  {{{0x330002985826a1b6}},17,"F-H0-12797",825,2},
  {{{0x91797c46676000b0}},15,"F-H0-12798",870,4},
  {{{0x5ce714f4b5146d}},4,"F-H0-12799",467,2},
  {{{0xd897192c18064bf1}},9,"F-H0-12800",678,2},
  {{{0xca4f454d9871d233}},12,"F-H0-12801",462,5},
  {{{0xdd4ed9be15871768}},9,"F-H0-12802",898,6},
  {{{0xd4ecc81b69aa8880}},12,"F-H0-12803",950,6},
  {{{0x716a8a66c65b894d}},13,"F-H0-12804",985,5},
  {{{0xf07eb1a32912adea}},9,"F-H0-12805",900,6},
  {{{0x1ea0040adadcb9e5}},6,"F-H0-12806",462,3},
  {{{0x1da73821799c76e}},6,"F-H0-12807",986,3},
  {{{0x572774f2b2727506}},7,"F-H0-12808",876,6},
  {{{0x2992c31aeb810f6b}},14,"F-H0-12809",457,4},
  {{{0x6cb0dea4f0043857}},3,"F-H0-12810",826,2},
  {{{0x241bbdbf6d27583c}},6,"F-H0-12811",905,3},
  {{{0xe4bd3026bdb38617}},6,"F-H0-12812",939,2},
  {{{0x55072b1a154dac8a}},12,"F-H0-12813",500,3},
  {{{0xeeadbdf2ff5a2fb1}},10,"F-H0-12814",468,5},
  {{{0x41fbd968aaec1787}},9,"F-H0-12815",802,4},
  {{{0x1bd1573ecfde7c2e}},13,"F-H0-12816",950,3},
  {{{0x1bd1573ecfde7c2e}},13,"F-H0-12817",836,2},
  {{{0x388e862bbfd46f7f}},10,"F-H0-12818",945,3},
  {{{0xe4460738953a3152}},10,"F-H0-12819",424,3},
  {{{0xb2bb1934c0ba5824}},4,"F-H0-12820",937,5},
  {{{0xd9f9bcdbbde20b5b}},14,"F-H0-12821",876,5},
  {{{0x6fab40f62d28fa98}},14,"F-H0-12822",429,3},
  {{{0x1c6aae09bf7eb190}},11,"F-H0-12823",432,6},
  {{{0xb92d541119e05fe1}},6,"F-H0-12824",678,2},
  {{{0x42b0e3de77433803}},18,"F-H0-12825",380,6},
  {{{0xd4177346254c3324}},14,"F-H0-12826",529,6},
  {{{0x414aab301251f452}},11,"F-H0-12827",690,3},
  {{{0x5046ef7f8f43ec64}},9,"F-H0-12828",529,3},
  {{{0xfc9eccec06390666}},10,"F-H0-12829",469,6},
  {{{0xe495733ae92de67c}},5,"F-H0-12830",974,2},
  {{{0xd802f5de81b7565e}},4,"F-H0-12831",493,4},
  {{{0x1597d74faadd386}},4,"F-H0-12832",421,2},
  {{{0x901c81073fc1ada}},6,"F-H0-12833",432,5},
  {{{0x865da7ca85e8d1e8}},17,"F-H0-12834",837,4},
  {{{0x3a7ebfae61e85251}},9,"F-H0-12835",763,6},
  {{{0x318660783039511f}},2,"F-H0-12836",432,4},
  {{{0xb0747e13e818127d}},10,"F-H0-12837",948,5},
  {{{0x27c7accf24bdb72b}},11,"F-H0-12838",975,4},
  {{{0xe58eabaca5220d46}},5,"F-H0-12839",939,3},
  {{{0x57c637f8117d1679}},5,"F-H0-12840",939,2},
  {{{0xfef53eb66a8266fc}},17,"F-H0-12841",987,5},
  {{{0x4d9e2bc7a0955418}},19,"F-H0-12842",542,5},
  {{{0x6a298756ba5bfc72}},10,"F-H0-12843",382,6},
  {{{0x2ca713713fb6f51f}},12,"F-H0-12844",801,4},
  {{{0xbef80392b59d0b2d}},12,"F-H0-12845",790,2},
  {{{0x381763dedcf3a982}},10,"F-H0-12846",530,2},
  {{{0x5c3f609948fad1dc}},14,"F-H0-12847",988,4},
  {{{0xfccd65d347050222}},15,"F-H0-12848",949,4},
  {{{0x181da876fa2aefd2}},9,"F-H0-12849",941,2},
  {{{0x7299f4a3c0cb19d6}},7,"F-H0-12850",939,4},
  {{{0x520c4d5c356a7fcc}},11,"F-H0-12851",840,3},
  {{{0x8d513153c8f0263c}},14,"F-H0-12852",875,4},
  {{{0x37f470f291e7afe0}},8,"F-H0-12853",678,3},
  {{{0xde529ebbc4aaf427}},8,"F-H0-12854",469,5},
  {{{0xcfe9e99d32dae102}},13,"F-H0-12855",875,4},
  {{{0x79d901745f85ad60}},7,"F-H0-12856",903,2},
  {{{0xd57737ba18462de5}},7,"F-H0-12857",495,2},
  {{{0x4fadfbb620830fc5}},5,"F-H0-12858",421,3},
  {{{0x2adf580567158cea}},9,"F-H0-12859",752,2},
  {{{0xc62dd9b6519cf07c}},9,"F-H0-12860",728,2},
  {{{0x7d8b48eaa6fe51fc}},19,"F-H0-12861",839,5},
  {{{0x5d4fc39dd3885f77}},10,"F-H0-12862",838,2},
  {{{0x4b61df716cd35f4d}},10,"F-H0-12863",945,3},
  {{{0xf7534ecfd54abc24}},10,"F-H0-12864",543,2},
  {{{0xa8b641cb9e4a6a87}},8,"F-H0-12865",455,6},
  {{{0x1faf2bac1240217e}},5,"F-H0-12866",421,3},
  {{{0xf75888d517cb1294}},6,"F-H0-12867",873,5},
  {{{0x1f452b27d5cba04}},10,"F-H0-12868",949,4},
  {{{0x88d6ba61f4ee8613}},5,"F-H0-12869",902,2},
  {{{0x88d6ba61f4ee8613}},5,"F-H0-12870",903,2},
  {{{0x6c2d514f1eeac11d}},20,"F-H0-12871",877,4},
  {{{0x6dfe5bd2bf3d98fa}},6,"F-H0-12872",457,3},
  {{{0xfd30acb97a7afbba}},8,"F-H0-12873",727,4},
  {{{0x60bc8052f97e5e3e}},7,"F-H0-12874",432,5},
  {{{0x8b799d6100af7b89}},8,"F-H0-12875",617,3},
  {{{0xb1f08b6f921cf3ca}},7,"F-H0-12876",939,3},
  {{{0x5078bc44d9e9f28c}},7,"F-H0-12877",566,2},
  {{{0xd7b10bc9327a72c0}},8,"F-H0-12878",950,5},
  {{{0xc8eb64c65bd5fa8e}},7,"F-H0-12879",504,3},
  {{{0xc8eb64c65bd5fa8e}},7,"F-H0-12880",466,2},
  {{{0x3861e3f66e5c751d}},5,"F-H0-12881",427,2},
  {{{0x526c0a52048cbde9}},5,"F-H0-12882",429,2},
  {{{0x98b1ab6e98e0a345}},20,"F-H0-12883",762,2},
  {{{0x2c0fdd403bc203f}},11,"F-H0-12884",824,3},
  {{{0xbbc1b2628e7a66b9}},12,"F-H0-12885",837,5},
  {{{0xe8ee2f2653b2ae2d}},12,"F-H0-12886",432,5},
  {{{0xf91bd475bc776e69}},13,"F-H0-12887",908,4},
  {{{0xe24d6d2d66f5356b}},6,"F-H0-12888",579,4},
  {{{0x6c1eaf3a59c7699b}},6,"F-H0-12889",604,2},
  {{{0xa2c34dd40ae4fd4b}},14,"F-H0-12890",677,6},
  {{{0x48594a1f1ab67ead}},14,"F-H0-12891",825,4},
  {{{0x897e18a61edca6c6}},8,"F-H0-12892",604,3},
  {{{0x815836f75cf22186}},8,"F-H0-12893",950,2},
  {{{0x25dd4003cb68ecab}},18,"F-H0-12894",837,5},
  {{{0x4d6e384b7350e7cf}},8,"F-H0-12895",431,5},
  {{{0x4c2d770960512c92}},5,"F-H0-12896",906,2},
  {{{0xf562bf2a05bf841f}},5,"F-H0-12897",529,2},
  {{{0x7b4c19b1a6b4b5ee}},4,"F-H0-12898",429,2},
  {{{0x308ebcdac0c16549}},4,"F-H0-12899",714,2},
  {{{0x8e0d6801da743379}},7,"F-H0-12900",946,3},
  {{{0x707baf2cc298196d}},7,"F-H0-12901",938,2},
  {{{0xe1583734a871bb6c}},11,"F-H0-12902",825,4},
  {{{0xdd58950c73abf597}},5,"F-H0-12903",947,2},
  {{{0x4b5796bc3f9b82a0}},4,"F-H0-12904",467,5},
  {{{0x201db691e477794a}},10,"F-H0-12905",470,5},
  {{{0xe2da914e53d0c073}},10,"F-H0-12906",395,4},
  {{{0xd219a799fa9cb61a}},7,"F-H0-12907",433,5},
  {{{0x1706cc7628409b90}},10,"F-H0-12908",456,3},
  {{{0xc4607132082f3770}},10,"F-H0-12909",428,2},
  {{{0x342a2fdf927388d5}},6,"F-H0-12910",946,3},
  {{{0x6d60ff177a6e4006}},10,"F-H0-12911",866,3},
  {{{0x99b9d855216e6c7e}},19,"F-H0-12912",944,6},
  {{{0xbbcbaf298b481cc0}},6,"F-H0-12913",543,3},
  {{{0x141cead081ba0829}},8,"F-H0-12914",974,3},
  {{{0x5a93a7b699c97519}},6,"F-H0-12915",468,6},
  {{{0x84db00d3f9ef335a}},7,"F-H0-12916",469,6},
  {{{0x417f8d31b9fd85c}},8,"F-H0-12917",431,6},
  {{{0xed8d83423b8ba4c8}},5,"F-H0-12918",421,3},
  {{{0xdf6900e8c1536fd}},11,"F-H0-12919",458,4},
  {{{0x9339d45569ba1b70}},7,"F-H0-12920",690,3},
  {{{0x73cb47c8e39adffc}},8,"F-H0-12921",462,4},
  {{{0x32c59efb140c8ba0}},7,"F-H0-12922",950,5},
  {{{0x2b3c34eef94b98a6}},7,"F-H0-12923",788,4},
  {{{0xb956169446afb10a}},18,"F-H0-12924",899,4},
  {{{0x4bffa2092f39a5b2}},8,"F-H0-12925",459,5},
  {{{0x9f37a5b91082ec71}},9,"F-H0-12926",839,3},
  {{{0x2a28a5b3585e389e}},9,"F-H0-12927",428,2},
  {{{0x86db0794e3569c64}},8,"F-H0-12928",949,5},
  {{{0x980e45b3ca9e46d}},11,"F-H0-12929",875,5},
  {{{0xc105576efb5e63c2}},12,"F-H0-12930",421,3},
  {{{0x31d8cc823923ac6c}},18,"F-H0-12931",948,4},
  {{{0x6c48dec0d61b17dd}},14,"F-H0-12932",543,3},
  {{{0x6a8f5d185a7f7f24}},14,"F-H0-12933",491,2},
  {{{0x640311f002c7c3da}},9,"F-H0-12934",454,3},
  {{{0x30805d0ee66a0584}},5,"F-H0-12935",541,2},
  {{{0x34d8a54307b3a78b}},12,"F-H0-12936",839,5},
  {{{0xbe891373685e3e11}},9,"F-H0-12937",801,5},
  {{{0x5449e2cc355d84c8}},12,"F-H0-12938",949,4},
  {{{0xc98863f0a449c853}},5,"F-H0-12939",465,2},
  {{{0x4310d57a832c0b4b}},5,"F-H0-12940",752,2},
  {{{0xe1915dbd8dbd9fc9}},5,"F-H0-12941",530,2},
  {{{0xe1915dbd8dbd9fc9}},5,"F-H0-12942",493,2},
  {{{0x554e682fbc2d6725}},5,"F-H0-12943",949,5},
  {{{0x868fa852a8693ca2}},4,"F-H0-12944",579,5},
  {{{0x39cdd58c9bc39d46}},9,"F-H0-12945",456,5},
  {{{0x2a24f75f8f634515}},10,"F-H0-12946",909,5},
  {{{0xd375919ba8e1c4ba}},15,"F-H0-12947",988,4},
  {{{0x388b5457ee1eb302}},9,"F-H0-12948",421,4},
  {{{0x624dfa68ed833a7a}},13,"F-H0-12949",470,6},
  {{{0xd92e585efe208baa}},11,"F-H0-12950",654,4},
  {{{0x7c5091839cce0720}},3,"F-H0-12951",948,2},
  {{{0x517c56feea930a02}},11,"F-H0-12952",641,3},
  {{{0x3df7bf9b93d135f8}},11,"F-H0-12953",942,2},
  {{{0x13b304a085d8919d}},9,"F-H0-12954",837,6},
  {{{0x91b9ed3ea69b2384}},16,"F-H0-12955",542,3},
  {{{0x84c9d368831c4548}},8,"F-H0-12956",466,3},
  {{{0xdb4971551ef8dc63}},8,"F-H0-12957",941,2},
  {{{0x1ebe7600f48b14c9}},10,"F-H0-12958",467,4},
  {{{0xf007fe14a056fe30}},8,"F-H0-12959",874,5},
  {{{0xdea2272da4ac9773}},5,"F-H0-12960",505,2},
  {{{0xbfe43abba10797e8}},6,"F-H0-12961",788,2},
  {{{0x3ed8bbbe01d045b7}},12,"F-H0-12962",911,5},
  {{{0x27ffb8128e77c4c8}},10,"F-H0-12963",458,2},
  {{{0x315f8f85502b47bf}},11,"F-H0-12964",863,3},
  {{{0x6aa94d5fecb5ff}},11,"F-H0-12965",837,2},
  {{{0x5bb2fc56abef1f9a}},6,"F-H0-12966",495,3},
  {{{0x8d82d8c6a497518b}},6,"F-H0-12967",468,3},
  {{{0xdbb44f954afdfa1e}},15,"F-H0-12968",641,3},
  {{{0xe1a2f334d9c87078}},9,"F-H0-12969",876,5},
  {{{0x3d271b547c5f8b4}},10,"F-H0-12970",690,6},
  {{{0xb751ca4c4c6e56f4}},18,"F-H0-12971",951,5},
  {{{0xc3b3fafd94925600}},11,"F-H0-12972",913,6},
  {{{0xe5c9576326392c21}},7,"F-H0-12973",839,2},
  {{{0x564a401e96816072}},9,"F-H0-12974",975,4},
  {{{0xcf28ae9623ded65f}},9,"F-H0-12975",460,2},
  {{{0x2e28cc9156b64e38}},9,"F-H0-12976",640,5},
  {{{0x25afbe37d79d88fa}},10,"F-H0-12977",431,4},
  {{{0x7d16a4b902e8566e}},7,"F-H0-12978",494,5},
  {{{0xd68b0c0f55d475ec}},4,"F-H0-12979",492,2},
  {{{0xf5d9265eea4eb186}},4,"F-H0-12980",908,2},
  {{{0x59509ee74f47c210}},9,"F-H0-12981",566,6},
  {{{0xe88725ffe81b1c1c}},13,"F-H0-12982",948,6},
  {{{0xd94e92439bf09a98}},8,"F-H0-12983",419,6},
  {{{0xbaa3d9f5ba084e83}},6,"F-H0-12984",456,6},
  {{{0xdce803603ffa19a5}},10,"F-H0-12985",541,4},
  {{{0x12c81cf54d2fc644}},13,"F-H0-12986",502,5},
  {{{0xe2112ada53719619}},6,"F-H0-12987",429,4},
  {{{0x1134d3a350f79f64}},7,"F-H0-12988",543,2},
  {{{0xe6da5ae992045783}},8,"F-H0-12989",825,4},
  {{{0xf292b41578350f05}},8,"F-H0-12990",678,2},
  {{{0xf63b66844d8902c4}},5,"F-H0-12991",468,5},
  {{{0x7a090dea3065ee87}},5,"F-H0-12992",419,3},
  {{{0xffbdaea5eff0cb57}},7,"F-H0-12993",542,5},
  {{{0x5bfae387de5ae500}},8,"F-H0-12994",902,5},
  {{{0xcd9fd3a7d0ebef4c}},10,"F-H0-12995",801,2},
  {{{0xcd9fd3a7d0ebef4c}},10,"F-H0-12996",765,2},
  {{{0x363e0371f2da24f0}},5,"F-H0-12997",913,2},
  {{{0x5c7218a0caf9d564}},5,"F-H0-12998",461,2},
  {{{0x91bb2ca2d30487a4}},6,"F-H0-12999",839,3},
  {{{0x903aa279acaaa829}},6,"F-H0-13000",418,2},
  {{{0xf7378f5789fa9eb}},7,"F-H0-13001",827,3},
  {{{0xf7378f5789fa9eb}},7,"F-H0-13002",936,3},
  {{{0x7e6f457754872ab5}},11,"F-H0-13003",951,5},
  {{{0xb5799e74845e355a}},11,"F-H0-13004",950,5},
  {{{0x6982c9f2591974f6}},6,"F-H0-13005",495,3},
  {{{0x1b90d431a6e8c5ff}},6,"F-H0-13006",950,3},
  {{{0x549a9d3347783db8}},5,"F-H0-13007",430,2},
  {{{0x549a9d3347783db8}},5,"F-H0-13008",464,2},
  {{{0xcaa9c60ebde11b97}},13,"F-H0-13009",420,6},
  {{{0x3c47e5b19d285cf3}},12,"F-H0-13010",751,4},
  {{{0xc825d72f1461792}},6,"F-H0-13011",945,2},
  {{{0xa7828386ebc65fcb}},11,"F-H0-13012",529,2},
  {{{0xd3d41c4548684766}},11,"F-H0-13013",947,2},
  {{{0x788aee5d3c1d3b29}},11,"F-H0-13014",943,2},
  {{{0xe3bb956190c03024}},8,"F-H0-13015",493,5},
  {{{0x7b3a16fcca11e3c1}},6,"F-H0-13016",495,2},
  {{{0xaa8ed9b57393d0b1}},11,"F-H0-13017",542,6},
  {{{0x1b449293f359d12c}},15,"F-H0-13018",825,3},
  {{{0xe9c123ccb0bbb37e}},11,"F-H0-13019",987,6},
  {{{0x6f3173f11a32d54b}},13,"F-H0-13020",912,4},
  {{{0x5845577a14cdde40}},14,"F-H0-13021",836,6},
  {{{0x8af1b12aa9a8b794}},6,"F-H0-13022",505,2},
  {{{0xc9d6204b84191252}},20,"F-H0-13023",421,3},
  {{{0xd3d3044b0c604e04}},8,"F-H0-13024",937,6},
  {{{0xb2c05c8ea1b036d1}},12,"F-H0-13025",800,5},
  {{{0x8743fb9a1a7e4635}},12,"F-H0-13026",951,5},
  {{{0xb409152a5356fbb}},19,"F-H0-13027",825,5},
  {{{0x6c44ed75dcbccdef}},7,"F-H0-13028",904,2},
  {{{0x35d99d084c522bd5}},11,"F-H0-13029",986,5},
  {{{0xea7360c238094194}},7,"F-H0-13030",874,3},
  {{{0xd77d7b544f09347e}},7,"F-H0-13031",542,3},
  {{{0xd77d7b544f09347e}},7,"F-H0-13032",943,2},
  {{{0xba7107a09f021b3c}},4,"F-H0-13033",862,2},
  {{{0xa14069ef56606856}},4,"F-H0-13034",505,2},
  {{{0xa312116ed5441933}},8,"F-H0-13035",495,3},
  {{{0x5d4119462a36d332}},14,"F-H0-13036",423,4},
  {{{0xcef9b228ab62dfdf}},5,"F-H0-13037",431,3},
  {{{0xdb2ea3881b4854a4}},9,"F-H0-13038",426,2},
  {{{0xedc5fb458598525e}},6,"F-H0-13039",826,2},
  {{{0x900d8b126e750bfb}},6,"F-H0-13040",463,2},
  {{{0xc4ec4d50fcedf7b6}},15,"F-H0-13041",935,5},
  {{{0x132c3a069f063217}},9,"F-H0-13042",541,5},
  {{{0x7268e36541f1480e}},11,"F-H0-13043",976,5},
  {{{0x131d851333d247e}},8,"F-H0-13044",872,5},
  {{{0xeacaa53927216f32}},12,"F-H0-13045",950,4},
  {{{0x89cd7106a6e38fd4}},11,"F-H0-13046",654,2},
  {{{0x68e61dbd3258fc1a}},10,"F-H0-13047",912,4},
  {{{0x68e61dbd3258fc1a}},10,"F-H0-13048",875,2},
  {{{0xc64e73f6fe3dd41d}},6,"F-H0-13049",424,3},
  {{{0x778622476cc0fa84}},8,"F-H0-13050",950,3},
  {{{0xdcaaba7afd269b00}},9,"F-H0-13051",950,3},
  {{{0xdcaaba7afd269b00}},9,"F-H0-13052",837,2},
  {{{0xb2ff335c1634425d}},7,"F-H0-13053",910,3},
  {{{0x3c6c2f4a6aac0264}},13,"F-H0-13054",506,6},
  {{{0x7469b8f8f51e7e3b}},5,"F-H0-13055",950,4},
  {{{0xc386734682e1776b}},5,"F-H0-13056",913,2},
  {{{0x5bf6e05f180bea7a}},4,"F-H0-13057",861,2},
  {{{0x2be2ef5950489697}},11,"F-H0-13058",542,2},
  {{{0x494ffbd459cb5669}},16,"F-H0-13059",838,3},
  {{{0xba127cbc34dc3928}},16,"F-H0-13060",788,2},
  {{{0xd428521d5781470f}},11,"F-H0-13061",506,5},
  {{{0x157b26adf86648a}},8,"F-H0-13062",941,4},
  {{{0x65d1cb2340073083}},15,"F-H0-13063",470,2},
  {{{0xff21966ac0c87b7f}},6,"F-H0-13064",529,2},
  {{{0x3aed01ca6c6b2324}},6,"F-H0-13065",941,2},
  {{{0x72531ed71e94fcaa}},17,"F-H0-13066",542,2},
  {{{0x72531ed71e94fcaa}},17,"F-H0-13067",825,2},
  {{{0x8e5a5f9925f45f8f}},7,"F-H0-13068",826,3},
  {{{0x42296398cdeae9d2}},11,"F-H0-13069",937,2},
  {{{0x3130a019ae4415d3}},7,"F-H0-13070",431,4},
  {{{0xa2207ffab24d0bf5}},5,"F-H0-13071",825,2},
  {{{0xa2207ffab24d0bf5}},5,"F-H0-13072",678,2},
  {{{0x784f1cd8cd5419cc}},14,"F-H0-13073",877,4},
  {{{0xdb1c841cfdc0fdec}},7,"F-H0-13074",529,4},
  {{{0xaefdcac46f734dac}},7,"F-H0-13075",912,2},
  {{{0x6626e95225292a5c}},6,"F-H0-13076",579,4},
  {{{0xb2402edd375e44e0}},9,"F-H0-13077",456,6},
  {{{0x631560a0af617a7b}},9,"F-H0-13078",936,2},
  {{{0x631560a0af617a7b}},9,"F-H0-13079",939,2},
  {{{0x2e602ad3108c1c96}},12,"F-H0-13080",426,2},
  {{{0xcee8cf56b98391a0}},9,"F-H0-13081",432,3},
  {{{0xcee8cf56b98391a0}},9,"F-H0-13082",579,2},
  {{{0xc161d2b26e9c06fb}},8,"F-H0-13083",950,3},
  {{{0x2b8231fa7488e28b}},7,"F-H0-13084",947,2},
  {{{0x2b8231fa7488e28b}},7,"F-H0-13085",765,2},
  {{{0xe761525d2b279e77}},4,"F-H0-13086",827,4},
  {{{0x6a761eeea297fa0b}},17,"F-H0-13087",838,2},
  {{{0x6a761eeea297fa0b}},17,"F-H0-13088",801,2},
  {{{0xcda67ae434604665}},4,"F-H0-13089",876,3},
  {{{0xcda67ae434604665}},4,"F-H0-13090",875,2},
  {{{0xfc7a91e925709da3}},15,"F-H0-13091",839,4},
  {{{0xfd9c9f678bedce7b}},15,"F-H0-13092",495,2},
  {{{0xc25f1cff49286b13}},11,"F-H0-13093",834,4},
  {{{0xfb66f47547346616}},7,"F-H0-13094",877,4},
  {{{0x397cda7abccd4d49}},7,"F-H0-13095",462,5},
  {{{0xc60875099014e770}},10,"F-H0-13096",840,5},
  {{{0x3b3300a4101e1afb}},17,"F-H0-13097",837,2},
  {{{0xa194c66a632fc318}},17,"F-H0-13098",458,2},
  {{{0xa4ae0edf7cf4e0e4}},14,"F-H0-13099",973,4},
  {{{0x30575d235618c9da}},4,"F-H0-13100",912,2},
  {{{0x46266b08350f6c6a}},6,"F-H0-13101",948,3},
  {{{0x99f4336db58318c6}},6,"F-H0-13102",909,2},
  {{{0xd0dd49f22eabede6}},10,"F-H0-13103",947,5},
  {{{0x386e45b6a53a6506}},9,"F-H0-13104",871,4},
  {{{0x65b87fd1d3d8363b}},7,"F-H0-13105",913,6},
  {{{0xe32aaa7fd80eec95}},5,"F-H0-13106",420,2},
  {{{0xe32aaa7fd80eec95}},5,"F-H0-13107",429,2},
  {{{0xfe9a882d9e427afb}},9,"F-H0-13108",728,6},
  {{{0x8472720b2119bd5}},6,"F-H0-13109",937,3},
  {{{0x506bf30e37329f83}},6,"F-H0-13110",937,2},
  {{{0x6cbc6a0087d4aa6}},11,"F-H0-13111",911,4},
  {{{0xb07ab40de7eb594e}},6,"F-H0-13112",690,3},
  {{{0xead69a55e69509c2}},11,"F-H0-13113",466,3},
  {{{0xe558653be3bca2af}},11,"F-H0-13114",421,2},
  {{{0x5a0f5a54b192581f}},8,"F-H0-13115",418,2},
  {{{0x3a70cfc9efa3662e}},8,"F-H0-13116",543,2},
  {{{0x3fbf7b066d8f4a59}},7,"F-H0-13117",902,2},
  {{{0x75966dfbca5d965f}},8,"F-H0-13118",428,4},
  {{{0x6046d05443d0b120}},8,"F-H0-13119",939,2},
  {{{0xe2458c2ab88c1894}},13,"F-H0-13120",799,6},
  {{{0x2194cc5e3f7f6501}},8,"F-H0-13121",910,3},
  {{{0x3c54a0358cbd0e59}},6,"F-H0-13122",543,2},
  {{{0x2e6a4eff771452d2}},8,"F-H0-13123",912,6},
  {{{0x5f950f2d823f63cb}},9,"F-H0-13124",429,4},
  {{{0xad6ff178e1699b}},9,"F-H0-13125",939,4},
  {{{0x4d487f6210381d43}},10,"F-H0-13126",528,4},
  {{{0x2ea5ca3487b3e6d9}},16,"F-H0-13127",428,5},
  {{{0x256648b5f32c1d37}},8,"F-H0-13128",902,6},
  {{{0x4351e207269eb8fb}},12,"F-H0-13129",834,3},
  {{{0x45c14c40a69bca23}},5,"F-H0-13130",899,5},
  {{{0x390a5e203e51b43d}},3,"F-H0-13131",912,2},
  {{{0x584ccefb85d99458}},15,"F-H0-13132",825,2},
  {{{0xf36b57fde386203a}},15,"F-H0-13133",690,2},
  {{{0xe12c680d93c83dc4}},15,"F-H0-13134",427,2},
  {{{0xd04ca33d99248134}},6,"F-H0-13135",764,2},
  {{{0x5a8763351278e6ed}},4,"F-H0-13136",467,2},
  {{{0x5ecbd038c6601646}},4,"F-H0-13137",690,2},
  {{{0xa53d341a35d02f6}},16,"F-H0-13138",911,3},
  {{{0x779129f3ba353aae}},8,"F-H0-13139",902,2},
  {{{0x779129f3ba353aae}},8,"F-H0-13140",826,2},
  {{{0x29363aa42d9b79ef}},7,"F-H0-13141",940,6},
  {{{0xb7f5ced180f9afae}},2,"F-H0-13142",912,2},
  {{{0x7df0cdb70b66c777}},7,"F-H0-13143",937,4},
  {{{0xcc010af200860052}},8,"F-H0-13144",951,6},
  {{{0x3b63a3a2e3be3ab5}},6,"F-H0-13145",948,2},
  {{{0x579ff996a22e1c3d}},7,"F-H0-13146",491,4},
  {{{0x80bf6d182125d213}},9,"F-H0-13147",469,4},
  {{{0x8aa6dab7a5aa7a35}},9,"F-H0-13148",937,2},
  {{{0xf56348aeb9f94a5d}},6,"F-H0-13149",690,4},
  {{{0xdce03df3bd47fd5d}},13,"F-H0-13150",836,3},
  {{{0xe0de1463a3ac1b25}},16,"F-H0-13151",430,4},
  {{{0xb337546753c6682a}},10,"F-H0-13152",507,5},
  {{{0x799535ea2cfc8c8c}},5,"F-H0-13153",458,3},
  {{{0x7df08c9ca966aed5}},4,"F-H0-13154",431,2},
  {{{0xa6c962ae1eb484dd}},5,"F-H0-13155",789,2},
  {{{0x9f2061e97f0b1971}},5,"F-H0-13156",430,2},
  {{{0x57bd70a19c9bf310}},10,"F-H0-13157",939,5},
  {{{0xf1c8bfbdecf55906}},11,"F-H0-13158",943,2},
  {{{0x54b12111bfcaf5db}},9,"F-H0-13159",466,4},
  {{{0x7c08fcea98ff2c99}},10,"F-H0-13160",429,2},
  {{{0x56f9a85933ffb2f8}},9,"F-H0-13161",950,4},
  {{{0x56f9a85933ffb2f8}},9,"F-H0-13162",908,2},
  {{{0xbfc38d9b792679f1}},11,"F-H0-13163",873,4},
  {{{0xbfc38d9b792679f1}},11,"F-H0-13164",825,2},
  {{{0xc759ddd0108f8557}},8,"F-H0-13165",431,6},
  {{{0x18c4a609bdd1b731}},9,"F-H0-13166",493,2},
  {{{0x18c4a609bdd1b731}},9,"F-H0-13167",901,2},
  {{{0x4670d638f9c1186b}},8,"F-H0-13168",543,3},
  {{{0xc69d77316f780fd3}},10,"F-H0-13169",454,4},
  {{{0xe9edf2862b15375e}},16,"F-H0-13170",840,4},
  {{{0x8aadd92c4733faa6}},14,"F-H0-13171",838,5},
  {{{0x6361ab74ef6e263c}},4,"F-H0-13172",862,2},
  {{{0xb6ca45aed08f91fe}},5,"F-H0-13173",431,3},
  {{{0xf12349e59c3c2f87}},7,"F-H0-13174",987,5},
  {{{0x801e1d8b4cc295ca}},10,"F-H0-13175",541,2},
  {{{0x5bb8340801fe129a}},2,"F-H0-13176",912,2},
  {{{0xc33ead2e6c12fbbb}},5,"F-H0-13177",825,2},
  {{{0xc3eb41f0232e04ac}},8,"F-H0-13178",837,6},
  {{{0xcc19aa558675c867}},13,"F-H0-13179",861,5},
  {{{0x6cf1476434197baf}},11,"F-H0-13180",421,2},
  {{{0x67e64ade942e2b2a}},16,"F-H0-13181",986,5},
  {{{0xba3aa4a721900933}},7,"F-H0-13182",802,5},
  {{{0x44f841d8f3dedf93}},14,"F-H0-13183",976,4},
  {{{0x549d661da1f52048}},8,"F-H0-13184",948,5},
  {{{0xeea6e9d1b633bfcb}},15,"F-H0-13185",873,3},
  {{{0xa7d9e80c0e94038a}},15,"F-H0-13186",495,2},
  {{{0xda8a6adf62c62a75}},9,"F-H0-13187",678,6},
  {{{0x466d313fc455faa8}},9,"F-H0-13188",873,5},
  {{{0x516399d91d8fcaf0}},5,"F-H0-13189",825,2},
  {{{0x36bea73fc00838ba}},6,"F-H0-13190",975,6},
  {{{0x941e50dd29eeb030}},6,"F-H0-13191",457,4},
  {{{0x8b3312059d9517f8}},7,"F-H0-13192",617,2},
  {{{0xdc16fbae03061a9e}},7,"F-H0-13193",912,5},
  {{{0x3eb30de2b1b9ca5e}},5,"F-H0-13194",419,3},
  {{{0x5a025664886e722f}},8,"F-H0-13195",604,2},
  {{{0xe685e02cb689f5fd}},5,"F-H0-13196",862,3},
  {{{0xe685e02cb689f5fd}},5,"F-H0-13197",863,2},
  {{{0x7a1d1593821eef5e}},14,"F-H0-13198",429,6},
  {{{0xb7a36148564f51c1}},13,"F-H0-13199",424,5},
  {{{0x761ffdb7f0ce6d96}},4,"F-H0-13200",876,2},
  {{{0x178e2fd4fcc47cb8}},4,"F-H0-13201",421,2},
  {{{0x560063c23fa200f4}},6,"F-H0-13202",939,2},
  {{{0xea727c1fd2693d96}},5,"F-H0-13203",429,3},
  {{{0xea727c1fd2693d96}},5,"F-H0-13204",466,2},
  {{{0xda3ff941b4d877d3}},16,"F-H0-13205",529,3},
  {{{0x362da20264945d9e}},16,"F-H0-13206",715,2},
  {{{0xd056d3c8f18cbc11}},6,"F-H0-13207",428,2},
  {{{0x77426d512a778123}},6,"F-H0-13208",941,2},
  {{{0xf31a573f51c052b}},11,"F-H0-13209",947,4},
  {{{0xf31a573f51c052b}},11,"F-H0-13210",949,2},
  {{{0xeeba85f8c58cbec1}},4,"F-H0-13211",839,2},
  {{{0x67c8a63d1a51c02a}},8,"F-H0-13212",684,2},
  {{{0x6a5af122913fe0fd}},8,"F-H0-13213",543,2},
  {{{0x79d8a03386e274ff}},7,"F-H0-13214",507,3},
  {{{0x53096c126a556f99}},6,"F-H0-13215",825,3},
  {{{0x2de407093531e2ea}},12,"F-H0-13216",433,6},
  {{{0xed01a3424c947c85}},11,"F-H0-13217",836,4},
  {{{0xaf9ae42a98f44b02}},7,"F-H0-13218",825,3},
  {{{0xaf9ae42a98f44b02}},7,"F-H0-13219",949,2},
  {{{0x3175171c24489c0c}},10,"F-H0-13220",951,6},
  {{{0x90d7533593cbeec1}},8,"F-H0-13221",431,6},
  {{{0x70fbe75e748eb59e}},6,"F-H0-13222",941,4},
  {{{0xef394b707e7849e8}},8,"F-H0-13223",909,3},
  {{{0xf7ce0e211697136e}},8,"F-H0-13224",497,2},
  {{{0x1956720cd8aca475}},3,"F-H0-13225",455,5},
  {{{0x69f52fff06386038}},15,"F-H0-13226",492,2},
  {{{0xa0ae1a23d4e5ad28}},13,"F-H0-13227",380,2},
  {{{0xcbc0d656a3041d42}},17,"F-H0-13228",1021,6},
  {{{0x201037cacaf6b10}},7,"F-H0-13229",691,3},
  {{{0x6350b7fc8d6fdb61}},7,"F-H0-13230",839,2},
  {{{0x62c42929afbca07c}},7,"F-H0-13231",529,5},
  {{{0xafd660c3edb0d27}},11,"F-H0-13232",426,2},
  {{{0xe1c47ee47cbdaaea}},11,"F-H0-13233",840,3},
  {{{0xe1c47ee47cbdaaea}},11,"F-H0-13234",838,2},
  {{{0x63055451a2459d9e}},9,"F-H0-13235",938,4},
  {{{0x88325eb38f14c439}},5,"F-H0-13236",838,3},
  {{{0x9674e200376ef6bc}},8,"F-H0-13237",728,4},
  {{{0xf5bfc0eec21b57eb}},10,"F-H0-13238",949,6},
  {{{0xe2e3393f5c1ec7cb}},9,"F-H0-13239",948,5},
  {{{0x976347d9508d71e2}},8,"F-H0-13240",865,4},
  {{{0x1848bcbc29469a9b}},5,"F-H0-13241",911,2},
  {{{0x6bcebcc1c7a71307}},11,"F-H0-13242",835,4},
  {{{0xcd313f287a23a302}},11,"F-H0-13243",531,5},
  {{{0x200b7232f4df3382}},8,"F-H0-13244",950,2},
  {{{0x8644d0d4dc2a39bb}},8,"F-H0-13245",501,2},
  {{{0x5f4fa1934afeca38}},8,"F-H0-13246",465,3},
  {{{0xd0a0718ea8a21ffc}},8,"F-H0-13247",505,2},
  {{{0xafc5069e606bcd11}},7,"F-H0-13248",567,2},
  {{{0x1a1025fd00028e8a}},16,"F-H0-13249",839,4},
  {{{0x90123a96fb6c926b}},19,"F-H0-13250",801,4},
  {{{0x68f0a4097a460e2c}},17,"F-H0-13251",913,6},
  {{{0x8e7b0673b3a73613}},7,"F-H0-13252",950,3},
  {{{0x8e7b0673b3a73613}},7,"F-H0-13253",873,2},
  {{{0xc21ed0f99d348312}},10,"F-H0-13254",466,4},
  {{{0x4b783a273e75a911}},14,"F-H0-13255",974,3},
  {{{0x4b783a273e75a911}},14,"F-H0-13256",938,3},
  {{{0xfbe863f95d059c46}},9,"F-H0-13257",422,3},
  {{{0x1ec3b457eaec1035}},9,"F-H0-13258",909,3},
  {{{0x7019f269994fd8c1}},5,"F-H0-13259",943,2},
  {{{0x7019f269994fd8c1}},5,"F-H0-13260",911,2},
  {{{0xdbe2f3774f80ecff}},14,"F-H0-13261",465,6},
  {{{0x1003de426de2bc}},12,"F-H0-13262",914,3},
  {{{0x1003de426de2bc}},12,"F-H0-13263",910,2},
  {{{0xc25c86b4efb51383}},9,"F-H0-13264",947,4},
  {{{0x690005b1eda57655}},10,"F-H0-13265",429,2},
  {{{0xd45ec441e82cd8d2}},10,"F-H0-13266",838,2},
  {{{0x48ed2c46fa776bd2}},6,"F-H0-13267",911,3},
  {{{0x48ed2c46fa776bd2}},6,"F-H0-13268",466,2},
  {{{0xc47606ff77ab7471}},7,"F-H0-13269",542,5},
  {{{0x5b179251fb160572}},7,"F-H0-13270",421,4},
  {{{0x7d08799318c0b4df}},8,"F-H0-13271",866,4},
  {{{0x92c185cd2ba2df3c}},6,"F-H0-13272",875,3},
  {{{0x87da8cb6e0a9c649}},6,"F-H0-13273",945,3},
  {{{0x17cd4d3cdb17ef48}},19,"F-H0-13274",491,5},
  {{{0x61b43d9b1da40f5d}},7,"F-H0-13275",838,2},
  {{{0x5d55f1a29dbd0168}},4,"F-H0-13276",949,2},
  {{{0xe506bb4a03d1330d}},4,"F-H0-13277",468,2},
  {{{0x27423b2caae39328}},14,"F-H0-13278",470,2},
  {{{0xca9cfd735d53d785}},5,"F-H0-13279",617,2},
  {{{0xa5bf12cdbc7d08b2}},7,"F-H0-13280",493,5},
  {{{0xd33e0f6f7970376d}},9,"F-H0-13281",974,4},
  {{{0x9173a2420bfba78}},17,"F-H0-13282",906,4},
  {{{0x7bf42cc209b5bb97}},16,"F-H0-13283",949,6},
  {{{0x73164a742cad199c}},8,"F-H0-13284",872,3},
  {{{0x43e2de830199a950}},8,"F-H0-13285",865,2},
  {{{0xdaf3ec0b441d13be}},15,"F-H0-13286",641,6},
  {{{0x17912271cdf8271b}},9,"F-H0-13287",938,3},
  {{{0xa27e0ef4f7522113}},15,"F-H0-13288",765,6},
  {{{0x47798deb6c6d7b10}},9,"F-H0-13289",462,2},
  {{{0xdb7b71f8bc83ca64}},10,"F-H0-13290",470,6},
  {{{0xaeee079d62f6a023}},8,"F-H0-13291",826,4},
  {{{0xb981acb45ec1880e}},6,"F-H0-13292",912,3},
  {{{0xb981acb45ec1880e}},6,"F-H0-13293",949,2},
  {{{0xa4cbfcd965f8c9b2}},5,"F-H0-13294",947,4},
  {{{0xf2f820c1564aece7}},7,"F-H0-13295",678,3},
  {{{0x364c3d6fc0ffaed0}},7,"F-H0-13296",653,2},
  {{{0xfa78f1b6acc09db7}},8,"F-H0-13297",830,4},
  {{{0xfb67e9830c0e1624}},10,"F-H0-13298",871,3},
  {{{0x2b1301b82ec1d6ac}},12,"F-H0-13299",973,4},
  {{{0xe9f156b7c948c137}},8,"F-H0-13300",429,2},
  {{{0xdee8587c125ec846}},8,"F-H0-13301",905,2},
  {{{0x21677aa15d43befb}},8,"F-H0-13302",751,2},
  {{{0xba661cf313ca285f}},16,"F-H0-13303",837,5},
  {{{0xc4e3a64921fb4ded}},11,"F-H0-13304",946,5},
  {{{0x267e6040a68c91ba}},15,"F-H0-13305",875,3},
  {{{0xbf6270c1d0df0edd}},7,"F-H0-13306",838,4},
  {{{0x27f39bee888e7300}},3,"F-H0-13307",542,4},
  {{{0x24d96891361fb5a2}},7,"F-H0-13308",688,3},
  {{{0x5a83d00e055e6aaa}},10,"F-H0-13309",876,4},
  {{{0xd56d65f53045fa71}},7,"F-H0-13310",465,5},
  {{{0x2fc1590b476d2be6}},4,"F-H0-13311",911,5},
  {{{0xcc3d0685b2c39f0f}},8,"F-H0-13312",495,6},
  {{{0x7fa628c726afaed8}},6,"F-H0-13313",566,2},
  {{{0xba6471e0153a76c2}},7,"F-H0-13314",432,4},
  {{{0x9d68b16de97ad029}},13,"F-H0-13315",901,5},
  {{{0x539a838d688131e0}},9,"F-H0-13316",467,4},
  {{{0x1b4cb2f0775c846e}},7,"F-H0-13317",678,2},
  {{{0x427216e12d2f1b81}},5,"F-H0-13318",429,2},
  {{{0x5abed975d981cf3c}},10,"F-H0-13319",912,2},
  {{{0x333827705e191785}},9,"F-H0-13320",531,4},
  {{{0x60b55ba3425549fd}},19,"F-H0-13321",876,5},
  {{{0xe2cf84190fb7560a}},6,"F-H0-13322",690,4},
  {{{0xe2cf84190fb7560a}},6,"F-H0-13323",470,2},
  {{{0x838922880c34e420}},14,"F-H0-13324",799,4},
  {{{0x47fa0c18a8e5b95c}},3,"F-H0-13325",456,2},
  {{{0xea81b87ab4fce232}},11,"F-H0-13326",873,5},
  {{{0xbd6827012925e549}},9,"F-H0-13327",912,4},
  {{{0xf98b66738a3f1d13}},7,"F-H0-13328",973,6},
  {{{0x2c8b9bd3b6b4bf5f}},5,"F-H0-13329",862,2},
  {{{0x2c8b9bd3b6b4bf5f}},5,"F-H0-13330",421,2},
  {{{0xd318df564651f8c}},9,"F-H0-13331",580,2},
  {{{0x99eb271c8a36494a}},6,"F-H0-13332",906,5},
  {{{0x26e73e268719c222}},4,"F-H0-13333",912,3},
  {{{0x761091e3ef93a51c}},10,"F-H0-13334",839,6},
  {{{0x2327d9c3dfd322b2}},10,"F-H0-13335",456,6},
  {{{0xeca3685e6c9b78d6}},7,"F-H0-13336",543,3},
  {{{0x56670f748fd5bd93}},7,"F-H0-13337",466,2},
  {{{0xfd000854853c0cca}},20,"F-H0-13338",950,3},
  {{{0xfd000854853c0cca}},20,"F-H0-13339",947,2},
  {{{0x593a24c94cd66669}},6,"F-H0-13340",907,2},
  {{{0x2dad930676522ac7}},6,"F-H0-13341",911,2},
  {{{0x2be7ed236ebfb4f8}},12,"F-H0-13342",382,3},
  {{{0xbb7da9611aa33a2f}},7,"F-H0-13343",937,6},
  {{{0x183554fbb793976f}},10,"F-H0-13344",392,4},
  {{{0x31460a8214909723}},10,"F-H0-13345",542,2},
  {{{0xc77b673a4a8976c2}},7,"F-H0-13346",801,3},
  {{{0x37c5a74c8dd9c69b}},8,"F-H0-13347",838,2},
  {{{0x1830f7bfd3ee2754}},7,"F-H0-13348",903,6},
  {{{0x951369a0b0224841}},6,"F-H0-13349",948,2},
  {{{0xf91c60dc301bd7db}},6,"F-H0-13350",530,2},
  {{{0x8cafeb510e7cd4cf}},7,"F-H0-13351",428,2},
  {{{0x86399345130bff95}},10,"F-H0-13352",987,6},
  {{{0x852e471d32d734ca}},9,"F-H0-13353",431,6},
  {{{0xc176b56f911a34eb}},11,"F-H0-13354",910,4},
  {{{0xd8f1a91951815177}},15,"F-H0-13355",836,2},
  {{{0x2acae47691de246}},9,"F-H0-13356",938,2},
  {{{0x7274d8bc4099062b}},13,"F-H0-13357",913,5},
  {{{0xee9f675d679eb220}},7,"F-H0-13358",457,3},
  {{{0xee9f675d679eb220}},7,"F-H0-13359",495,2},
  {{{0xcdcc514777a0a0aa}},16,"F-H0-13360",603,6},
  {{{0xbbb65182b15b21a}},9,"F-H0-13361",543,2},
  {{{0x55e7f4adfcc5da09}},9,"F-H0-13362",909,2},
  {{{0x9381ad66b80e300a}},9,"F-H0-13363",764,2},
  {{{0xe9b2d8acc331966f}},9,"F-H0-13364",825,2},
  {{{0xeea691d06ecaa64d}},6,"F-H0-13365",432,3},
  {{{0xc53a15a9769f806d}},6,"F-H0-13366",947,2},
  {{{0x7b28d738138dbe3c}},8,"F-H0-13367",492,2},
  {{{0x46d8d6e451286743}},11,"F-H0-13368",950,4},
  {{{0x46d8d6e451286743}},11,"F-H0-13369",837,2},
  {{{0xaf47c3b7886bc9fb}},5,"F-H0-13370",875,2},
  {{{0xaf47c3b7886bc9fb}},5,"F-H0-13371",838,2},
  {{{0x40d0c8291274be}},8,"F-H0-13372",801,3},
  {{{0x6e7d66f4a6d51e7e}},8,"F-H0-13373",420,2},
  {{{0x971fd6807f080ed5}},9,"F-H0-13374",714,3},
  {{{0x971fd6807f080ed5}},9,"F-H0-13375",715,2},
  {{{0x378e8c9a8d04c4be}},4,"F-H0-13376",911,2},
  {{{0x56905733de4c923a}},15,"F-H0-13377",467,4},
  {{{0x25429970051c5bfa}},8,"F-H0-13378",949,6},
  {{{0xcb2e54ca5f27b387}},12,"F-H0-13379",937,5},
  {{{0x488ff721cb0186e0}},13,"F-H0-13380",940,3},
  {{{0x9edb59a6ea921740}},8,"F-H0-13381",899,6},
  {{{0x1539233cbd868359}},5,"F-H0-13382",839,2},
  {{{0x82b691f502c432db}},5,"F-H0-13383",875,4},
  {{{0xd23713dc4ae4f8e0}},9,"F-H0-13384",936,5},
  {{{0x411dfa5bdac1c72}},7,"F-H0-13385",462,3},
  {{{0xd11e4dd4ab053d60}},7,"F-H0-13386",529,2},
  {{{0x8997368859953104}},6,"F-H0-13387",903,3},
  {{{0xcf5ef1aaef763b41}},21,"F-H0-13388",944,3},
  {{{0xd29d488540d659a3}},13,"F-H0-13389",945,2},
  {{{0xf2be08d181edc2b9}},13,"F-H0-13390",911,2},
  {{{0x2a1ebb2209a65afc}},13,"F-H0-13391",862,2},
  {{{0xa48a0a911ad455e5}},12,"F-H0-13392",531,2},
  {{{0xa1e47bf930ac1a1c}},12,"F-H0-13393",907,2},
  {{{0x5bafb31281b7c924}},9,"F-H0-13394",901,3},
  {{{0x336b41c52f3c2094}},10,"F-H0-13395",418,2},
  {{{0x253989b488234f00}},4,"F-H0-13396",826,2},
  {{{0x60602af70143408f}},4,"F-H0-13397",906,2},
  {{{0x60602af70143408f}},4,"F-H0-13398",425,2},
  {{{0x83fb30534250d843}},17,"F-H0-13399",427,2},
  {{{0x8cd0431531251c43}},9,"F-H0-13400",826,5},
  {{{0xbdf3410862fd6fc1}},6,"F-H0-13401",464,3},
  {{{0x32b5e29f7bd5ddba}},10,"F-H0-13402",909,5},
  {{{0x3fe7cdedab555179}},7,"F-H0-13403",418,2},
  {{{0x63b4a79366c01281}},12,"F-H0-13404",946,4},
  {{{0x63b4a79366c01281}},12,"F-H0-13405",906,2},
  {{{0xbe8ff63eb0c00cf6}},8,"F-H0-13406",908,4},
  {{{0xc32099119cb5b319}},3,"F-H0-13407",469,3},
  {{{0xc32099119cb5b319}},3,"F-H0-13408",506,2},
  {{{0x95f975fdf7fae257}},16,"F-H0-13409",986,6},
  {{{0xae36b4aab49a1b0a}},6,"F-H0-13410",913,3},
  {{{0x1b34f78ba6dfea5d}},6,"F-H0-13411",951,3},
  {{{0xdbebbbedc7b4e508}},6,"F-H0-13412",949,2},
  {{{0x5a42ce3695cb26f2}},11,"F-H0-13413",392,4},
  {{{0x97dc46c884dcb023}},15,"F-H0-13414",935,5},
  {{{0x46ac60ef65531b46}},12,"F-H0-13415",838,5},
  {{{0x2a78ee0ad3a62bc1}},9,"F-H0-13416",465,4},
  {{{0x2a7405819f719472}},9,"F-H0-13417",615,2},
  {{{0xe9afe9b180d0e67e}},17,"F-H0-13418",568,3},
  {{{0x8a5b6d641dd8d922}},15,"F-H0-13419",430,4},
  {{{0xa29ab938111225a8}},15,"F-H0-13420",914,2},
  {{{0x2ec08aa63cec2a45}},7,"F-H0-13421",911,2},
  {{{0x4eedd072cb0a19dd}},6,"F-H0-13422",940,3},
  {{{0x1f3d5bb10dcab868}},8,"F-H0-13423",910,4},
  {{{0x13cac0ca55bf17af}},13,"F-H0-13424",466,4},
  {{{0x89a8c261966a1c0c}},11,"F-H0-13425",713,5},
  {{{0xcc6351413834d43f}},13,"F-H0-13426",422,2},
  {{{0x67db80573eb7b065}},4,"F-H0-13427",865,4},
  {{{0xc1b1b5b1ddd72e59}},7,"F-H0-13428",947,4},
  {{{0x5878755571b727b2}},11,"F-H0-13429",836,3},
  {{{0x70e43552d590e2dc}},11,"F-H0-13430",936,2},
  {{{0xbd575af57eb8a2bd}},16,"F-H0-13431",877,4},
  {{{0xef63cc2462ac73fd}},5,"F-H0-13432",863,2},
  {{{0x133d4441776ecf93}},7,"F-H0-13433",947,6},
  {{{0x44253372bbd59640}},9,"F-H0-13434",456,4},
  {{{0x8031ab5134a216cb}},13,"F-H0-13435",906,3},
  {{{0x8031ab5134a216cb}},13,"F-H0-13436",974,2},
  {{{0xbecf512b6247d790}},8,"F-H0-13437",948,3},
  {{{0x1f21f8b7a91f36bc}},5,"F-H0-13438",876,3},
  {{{0x36e2ec43702ba9a3}},5,"F-H0-13439",949,2},
  {{{0xdecc973f0920c9d4}},11,"F-H0-13440",825,4},
  {{{0x695291e782432cdc}},11,"F-H0-13441",467,2},
  {{{0xa2f83f6b6c077cb4}},8,"F-H0-13442",424,3},
  {{{0x83cf9d1ec434dbd}},6,"F-H0-13443",467,5},
  {{{0xb55dc6d0e1a06fde}},20,"F-H0-13444",385,6},
  {{{0x43dad1bdb73c7688}},8,"F-H0-13445",579,3},
  {{{0xd825d43921426723}},8,"F-H0-13446",913,2},
  {{{0x77d8e5c2b9c130b9}},12,"F-H0-13447",381,6},
  {{{0xd1a41da5320ae7ca}},5,"F-H0-13448",428,2},
  {{{0xe6b5cf5b0b6f0373}},10,"F-H0-13449",420,3},
  {{{0xe6b5cf5b0b6f0373}},10,"F-H0-13450",494,2},
  {{{0xd682c0606dc551c4}},12,"F-H0-13451",433,5},
  {{{0x169034de0c375167}},17,"F-H0-13452",897,5},
  {{{0xb7908b9447460211}},10,"F-H0-13453",863,6},
  {{{0xc73ea1294a71dec1}},16,"F-H0-13454",800,5},
  {{{0xf7112748b7495e0a}},4,"F-H0-13455",975,2},
  {{{0x12c4edfb86ea9f08}},6,"F-H0-13456",495,5},
  {{{0xfbd5623ba29f25f5}},8,"F-H0-13457",874,2},
  {{{0xfb13a80ea2e31442}},9,"F-H0-13458",579,2},
  {{{0x4a9aa9fe063145e1}},21,"F-H0-13459",603,3},
  {{{0x1f22f6c41596e547}},5,"F-H0-13460",943,5},
  {{{0x8a4ea674bdc8fffd}},6,"F-H0-13461",531,2},
  {{{0x8a4ea674bdc8fffd}},6,"F-H0-13462",418,2},
  {{{0xe0c75dfde7961de2}},13,"F-H0-13463",466,3},
  {{{0xa554a14aac998efb}},11,"F-H0-13464",765,3},
  {{{0x8e19f2da3c3e9cd8}},11,"F-H0-13465",911,2},
  {{{0x6d151518f908cfa5}},3,"F-H0-13466",937,3},
  {{{0x4836563523d7075}},17,"F-H0-13467",914,3},
  {{{0x749df90217639c68}},8,"F-H0-13468",945,4},
  {{{0xcb2d8f9b29f7934d}},8,"F-H0-13469",871,3},
  {{{0x93a3fc415c36abe6}},6,"F-H0-13470",580,3},
  {{{0x9e5cf345d8b0e181}},6,"F-H0-13471",839,2},
  {{{0xc0ee9f9e16166c9f}},15,"F-H0-13472",541,5},
  {{{0x7505151da85217c5}},11,"F-H0-13473",837,5},
  {{{0x3803525ba337e254}},13,"F-H0-13474",876,6},
  {{{0x817bd2fadaea5c70}},14,"F-H0-13475",429,5},
  {{{0xacddbfa502d1085}},9,"F-H0-13476",875,4},
  {{{0xab06463248c17d48}},18,"F-H0-13477",949,6},
  {{{0xd00f8a3d3510c159}},8,"F-H0-13478",539,6},
  {{{0x7f54cdef3b0a8115}},10,"F-H0-13479",939,6},
  {{{0x5685a0b3d40eed01}},15,"F-H0-13480",948,4},
  {{{0xe7bb92b56a324d3f}},6,"F-H0-13481",541,3},
  {{{0xe7bb92b56a324d3f}},6,"F-H0-13482",432,2},
  {{{0xe61f8b623a946846}},6,"F-H0-13483",425,2},
  {{{0x759c1d1a19cb6946}},10,"F-H0-13484",950,5},
  {{{0xffbcb70e75d4cad7}},11,"F-H0-13485",507,4},
  {{{0x95b1210881769f1f}},14,"F-H0-13486",677,6},
  {{{0xfd03b91a49da65f2}},15,"F-H0-13487",423,3},
  {{{0x8a201827c341987c}},15,"F-H0-13488",541,2},
  {{{0x8a201827c341987c}},15,"F-H0-13489",465,2},
  {{{0x91b717af0650a7d1}},17,"F-H0-13490",678,3},
  {{{0xbd8b4a53997341f1}},10,"F-H0-13491",541,2},
  {{{0x808f87a617e83703}},10,"F-H0-13492",950,2},
  {{{0x88819c1f98d21efd}},5,"F-H0-13493",901,2},
  {{{0xfcad991b44cd14ce}},6,"F-H0-13494",654,4},
  {{{0x449f4f9d384eb4cd}},6,"F-H0-13495",432,3},
  {{{0xf2443823bae4206a}},8,"F-H0-13496",937,6},
  {{{0x5462bfa794cce747}},6,"F-H0-13497",690,2},
  {{{0x5627047274872483}},6,"F-H0-13498",765,2},
  {{{0x95a04c82a8bfc018}},7,"F-H0-13499",530,3},
  {{{0x12a0aca89755987b}},7,"F-H0-13500",874,3},
  {{{0xb820aad7fd42afba}},15,"F-H0-13501",530,2},
  {{{0x30939e0c08f5d65b}},15,"F-H0-13502",947,2},
  {{{0x88354fd3cdd5276a}},5,"F-H0-13503",764,3},
  {{{0xebb89bc3ec28371e}},5,"F-H0-13504",420,2},
  {{{0xd2e575389e85cfc9}},7,"F-H0-13505",456,2},
  {{{0xe3cc9caa783f16c8}},5,"F-H0-13506",456,4},
  {{{0xc3afcbf24c9aa88a}},11,"F-H0-13507",951,4},
  {{{0x52fecd508a3dba94}},14,"F-H0-13508",567,2},
  {{{0x52fecd508a3dba94}},14,"F-H0-13509",568,2},
  {{{0xbaadfcf2f8190da0}},8,"F-H0-13510",973,4},
  {{{0xe37aacb3100dce78}},17,"F-H0-13511",470,3},
  {{{0x15c2f9a4379b582a}},9,"F-H0-13512",789,4},
  {{{0xdf6e1971fdfb8d02}},9,"F-H0-13513",950,2},
  {{{0x3dd8cc5aaf06bb99}},8,"F-H0-13514",801,5},
  {{{0x694913c44838b6df}},4,"F-H0-13515",938,4},
  {{{0x4cade8f8ba63676d}},11,"F-H0-13516",950,4},
  {{{0xadf48d3772b6f932}},7,"F-H0-13517",912,5},
  {{{0x111dedc7354dac8c}},7,"F-H0-13518",432,4},
  {{{0x25bca987b4b430ce}},15,"F-H0-13519",937,3},
  {{{0x168fae358ebc3363}},20,"F-H0-13520",943,2},
  {{{0xa27a47e642e1cef8}},3,"F-H0-13521",901,2},
  {{{0x282921cf9cf3a4b2}},6,"F-H0-13522",875,4},
  {{{0xcc430990fe227359}},13,"F-H0-13523",976,3},
  {{{0xcd871e0ff4016ccd}},13,"F-H0-13524",380,2},
  {{{0x4ca6189751b59653}},9,"F-H0-13525",579,4},
  {{{0xe6015cc4f1d7de91}},6,"F-H0-13526",418,5},
  {{{0x38af610dad2a9e74}},5,"F-H0-13527",875,3},
  {{{0x88016ae84f773b6e}},7,"F-H0-13528",429,3},
  {{{0xb10ad1e6c66b4d9a}},5,"F-H0-13529",469,4},
  {{{0x5444bf572cb08f4a}},5,"F-H0-13530",949,2},
  {{{0x5d91324c6ec51912}},15,"F-H0-13531",715,6},
  {{{0xd5c19708bfe495fe}},7,"F-H0-13532",495,2},
  {{{0x5f12aaf27474b973}},15,"F-H0-13533",542,4},
  {{{0x6e01c4ccbb636101}},7,"F-H0-13534",910,2},
  {{{0x606f2f996b3f2658}},7,"F-H0-13535",839,2},
  {{{0x2d974cd21fdce85c}},3,"F-H0-13536",912,3},
  {{{0x8d1700b4c3513061}},8,"F-H0-13537",875,5},
  {{{0x2023a0d2aaf4c889}},7,"F-H0-13538",903,5},
  {{{0xfeee8ca9460fb557}},11,"F-H0-13539",431,4},
  {{{0x53602825ae475403}},5,"F-H0-13540",939,2},
  {{{0x693f1e72ff2f46f4}},8,"F-H0-13541",903,6},
  {{{0x7042dd1026098936}},7,"F-H0-13542",873,5},
  {{{0xb8f65b8304495c1e}},6,"F-H0-13543",946,3},
  {{{0xd7307b7fb7dfab8c}},9,"F-H0-13544",380,4},
  {{{0xf50042f8ec3933fc}},13,"F-H0-13545",469,2},
  {{{0xf50042f8ec3933fc}},13,"F-H0-13546",470,2},
  {{{0x1a698bb0b7e80771}},7,"F-H0-13547",912,3},
  {{{0x1a698bb0b7e80771}},7,"F-H0-13548",911,2},
  {{{0x7e5dc17af936894}},16,"F-H0-13549",975,4},
  {{{0x7377a7f277e82f2c}},6,"F-H0-13550",506,2},
  {{{0x41836a9ba084cab5}},6,"F-H0-13551",419,5},
  {{{0x7615b28f2d8f698c}},13,"F-H0-13552",912,4},
  {{{0x8a5f6abc8cb1123b}},6,"F-H0-13553",542,2},
  {{{0x8a5f6abc8cb1123b}},6,"F-H0-13554",764,2},
  {{{0x9dc9635be420b15d}},10,"F-H0-13555",975,2},
  {{{0x5a397dfe0b7053}},15,"F-H0-13556",837,4},
  {{{0xeae64df7e99fe990}},9,"F-H0-13557",875,5},
  {{{0x6eddcdb6682b424c}},14,"F-H0-13558",898,5},
  {{{0x9d4274fcb0dab988}},5,"F-H0-13559",900,2},
  {{{0xc5ec464ec6bc5d4b}},9,"F-H0-13560",495,5},
  {{{0x77a03091181afc7}},5,"F-H0-13561",457,2},
  {{{0xe63d336b77ebf446}},7,"F-H0-13562",690,2},
  {{{0x7c1f7e4727b120a4}},8,"F-H0-13563",493,2},
  {{{0xc0f7fab1687e9190}},13,"F-H0-13564",725,2},
  {{{0xc0f7fab1687e9190}},13,"F-H0-13565",799,2},
  {{{0x3b2d3b16b2d68686}},9,"F-H0-13566",641,5},
  {{{0xcf9b9cc977046281}},10,"F-H0-13567",950,2},
  {{{0xcf9b9cc977046281}},10,"F-H0-13568",946,2},
  {{{0xea4252bf57943e63}},4,"F-H0-13569",862,2},
  {{{0x7ef4f89130f06822}},14,"F-H0-13570",430,5},
  {{{0x9caf3c270178177a}},14,"F-H0-13571",691,4},
  {{{0x7fa8f37d624c0c12}},14,"F-H0-13572",640,2},
  {{{0x175681951ebe8778}},5,"F-H0-13573",943,6},
  {{{0xecd9992a0ce8768e}},8,"F-H0-13574",420,2},
  {{{0xbd148937eef678c}},8,"F-H0-13575",946,2},
  {{{0xc8861b1daef3fcff}},13,"F-H0-13576",943,5},
  {{{0xf3e923f300864fb}},19,"F-H0-13577",507,6},
  {{{0xb4d3b34606840baa}},7,"F-H0-13578",876,4},
  {{{0x7e8bb53c0f2bbfea}},10,"F-H0-13579",874,6},
  {{{0x28e329a464b53199}},6,"F-H0-13580",690,4},
  {{{0xe5dbf4396a8dfb0b}},10,"F-H0-13581",837,5},
  {{{0x482971721aaa9cd2}},7,"F-H0-13582",678,4},
  {{{0x91117a7f0c31966f}},9,"F-H0-13583",467,6},
  {{{0x125db57b3ea2f98d}},14,"F-H0-13584",462,2},
  {{{0xf049832bd03d4956}},14,"F-H0-13585",986,2},
  {{{0x70858c6b4a63af0d}},8,"F-H0-13586",457,5},
  {{{0x4b8850e3372e5a6d}},6,"F-H0-13587",494,4},
  {{{0x4b8850e3372e5a6d}},6,"F-H0-13588",495,2},
  {{{0xe5f0d45780951b77}},6,"F-H0-13589",946,2},
  {{{0xe5f0d45780951b77}},6,"F-H0-13590",948,2},
  {{{0xafde75ba2b1a942f}},5,"F-H0-13591",464,2},
  {{{0xb6a4f6e06b71a32c}},8,"F-H0-13592",383,5},
  {{{0x74f235eda8c59eef}},10,"F-H0-13593",468,3},
  {{{0x74f235eda8c59eef}},10,"F-H0-13594",431,2},
  {{{0x9c42420206605bc7}},6,"F-H0-13595",911,2},
  {{{0xcc814391dd0c80f4}},6,"F-H0-13596",838,2},
  {{{0x8b664546e1c1331a}},11,"F-H0-13597",949,3},
  {{{0x8d00a07a5ae742c}},4,"F-H0-13598",469,2},
  {{{0x561a16e1b36ed9ec}},10,"F-H0-13599",801,3},
  {{{0xcb530f8c2356e3f4}},8,"F-H0-13600",976,5},
  {{{0xaac01d9a256f74cf}},12,"F-H0-13601",418,5},
  {{{0x4ea5bf6830a2716e}},14,"F-H0-13602",421,2},
  {{{0xab42523cf6df20cb}},7,"F-H0-13603",455,6},
  {{{0x7a8de035116a0995}},7,"F-H0-13604",825,3},
  {{{0x7a8de035116a0995}},7,"F-H0-13605",690,2},
  {{{0x35220ad004af4873}},5,"F-H0-13606",417,6},
  {{{0xacde18ae5c0091aa}},9,"F-H0-13607",837,2},
  {{{0xd4c2cf991c3ebf3f}},6,"F-H0-13608",541,3},
  {{{0xd4c2cf991c3ebf3f}},6,"F-H0-13609",432,3},
  {{{0x2e11d64300789a57}},7,"F-H0-13610",530,6},
  {{{0xffdc0833595ae66f}},3,"F-H0-13611",419,3},
  {{{0xffdc0833595ae66f}},3,"F-H0-13612",456,2},
  {{{0x5c3b0026a7b4e2e3}},5,"F-H0-13613",911,2},
  {{{0x7bc0c4f02516d516}},7,"F-H0-13614",505,4},
  {{{0xcf9c43db5d9e86da}},8,"F-H0-13615",727,2},
  {{{0x673510c9b53dc516}},8,"F-H0-13616",382,2},
  {{{0xa3755f4b718674e9}},5,"F-H0-13617",421,2},
  {{{0x56e11f04ea2d0cf9}},17,"F-H0-13618",384,2},
  {{{0xbf2bfeb0534d2e12}},16,"F-H0-13619",751,5},
  {{{0x635c3f71b3a0faf7}},16,"F-H0-13620",544,5},
  {{{0x49ef091b23ad6093}},9,"F-H0-13621",543,2},
  {{{0xb2cb8559cd7bb5da}},10,"F-H0-13622",838,2},
  {{{0x2df23fd66adf39a8}},12,"F-H0-13623",985,5},
  {{{0x92a1d4589b923fa3}},7,"F-H0-13624",395,5},
  {{{0x8caa5bf77e8dfbdc}},9,"F-H0-13625",467,5},
  {{{0x4eb0f28557ab658a}},10,"F-H0-13626",836,3},
  {{{0x4eb0f28557ab658a}},10,"F-H0-13627",949,2},
  {{{0x5e033630b0ae5cec}},7,"F-H0-13628",837,5},
  {{{0xfdb4b7b029ae9222}},5,"F-H0-13629",939,3},
  {{{0xef3eb1df994896ec}},5,"F-H0-13630",543,2},
  {{{0x9bb58741c56df083}},5,"F-H0-13631",653,3},
  {{{0xf017fe8ada99cdb5}},5,"F-H0-13632",422,2},
  {{{0xf017fe8ada99cdb5}},5,"F-H0-13633",420,2},
  {{{0x1a1b8d726f0fe0d8}},9,"F-H0-13634",950,6},
  {{{0xe9fffc2c113e3378}},8,"F-H0-13635",898,3},
  {{{0x575adca635447cd8}},8,"F-H0-13636",987,2},
  {{{0x7a51ba8c7c49a60c}},19,"F-H0-13637",838,2},
  {{{0x7a51ba8c7c49a60c}},19,"F-H0-13638",840,2},
  {{{0x7a51ba8c7c49a60c}},19,"F-H0-13639",987,2},
  {{{0x620d1277cc622d2c}},7,"F-H0-13640",912,5},
  {{{0x290bf6ba44233f95}},6,"F-H0-13641",911,6},
  {{{0xeb6ae450dd41d2f6}},13,"F-H0-13642",938,4},
  {{{0xb03a1997e9f7d56f}},16,"F-H0-13643",985,4},
  {{{0xe54121ddaa1cc25c}},9,"F-H0-13644",985,5},
  {{{0x5af003deb6a25de9}},14,"F-H0-13645",801,6},
  {{{0x58d08626cc68ddd0}},8,"F-H0-13646",940,2},
  {{{0x4b6dca4ab328dc7a}},8,"F-H0-13647",876,2},
  {{{0x3e28ffef717cd0b8}},6,"F-H0-13648",494,2},
  {{{0xa2ecff5df4181963}},18,"F-H0-13649",875,6},
  {{{0xb00d8f9135fbab55}},8,"F-H0-13650",950,5},
  {{{0xcfc376b7f47e7f89}},8,"F-H0-13651",945,2},
  {{{0xf291d9e2cc96b834}},9,"F-H0-13652",393,5},
  {{{0x2a2fe44c8c28ce2}},7,"F-H0-13653",838,6},
  {{{0xdf8ec46f689ea901}},8,"F-H0-13654",456,3},
  {{{0x8919b8d412bda5f7}},9,"F-H0-13655",986,4},
  {{{0x8919b8d412bda5f7}},9,"F-H0-13656",910,2},
  {{{0x2f5691a97d88bde0}},7,"F-H0-13657",910,2},
  {{{0xba48b6fecd9ac767}},8,"F-H0-13658",947,3},
  {{{0x60770a43f2878afe}},8,"F-H0-13659",876,6},
  {{{0xb49fdeadcc44c8a8}},10,"F-H0-13660",912,4},
  {{{0x6a67d4053533ad5a}},10,"F-H0-13661",466,2},
  {{{0x6a67d4053533ad5a}},10,"F-H0-13662",503,2},
  {{{0x616224b63f3363e2}},10,"F-H0-13663",503,3},
  {{{0x78caa84fe3c95a5e}},12,"F-H0-13664",950,3},
  {{{0x2a248572ed8686ac}},12,"F-H0-13665",836,2},
  {{{0xdd756397046cfdb9}},13,"F-H0-13666",984,6},
  {{{0xb6e7e3ae085181a}},14,"F-H0-13667",691,4},
  {{{0xbbaa98063ca264ac}},6,"F-H0-13668",492,3},
  {{{0x48ffabd060364c81}},10,"F-H0-13669",617,2},
  {{{0x63adb8d7e33520cf}},8,"F-H0-13670",951,4},
  {{{0x17e382d5a164a546}},5,"F-H0-13671",911,3},
  {{{0x6dcfc6fae032f1f4}},5,"F-H0-13672",913,4},
  {{{0x5a1ef9c7b06b9a41}},11,"F-H0-13673",948,6},
  {{{0x6e76f87044951139}},8,"F-H0-13674",457,2},
  {{{0x5e2276d374841e8a}},5,"F-H0-13675",911,2},
  {{{0xfb507169c45c5747}},8,"F-H0-13676",949,5},
  {{{0x360ebfa256540cf6}},8,"F-H0-13677",763,5},
  {{{0x14bb1a0eb13b117}},5,"F-H0-13678",421,4},
  {{{0x9e42df596641232b}},6,"F-H0-13679",690,2},
  {{{0xec819a39dc5cb83}},20,"F-H0-13680",529,5},
  {{{0xa5e0d3b0f26f405d}},10,"F-H0-13681",432,2},
  {{{0xa5e0d3b0f26f405d}},10,"F-H0-13682",469,2},
  {{{0xf9086555b8e12a91}},9,"F-H0-13683",493,6},
  {{{0x1ab510a6e8ae11de}},6,"F-H0-13684",466,4},
  {{{0x9161358fca62406c}},6,"F-H0-13685",690,3},
  {{{0xa94d9f3130381847}},22,"F-H0-13686",386,5},
  {{{0x76aa66c12060a38e}},9,"F-H0-13687",899,4},
  {{{0xad8ebb3026d558d1}},12,"F-H0-13688",460,6},
  {{{0x62ae0aace273c91}},7,"F-H0-13689",940,4},
  {{{0xa117ee26875a4847}},21,"F-H0-13690",865,5},
  {{{0x32bb82f60be87e2}},9,"F-H0-13691",566,5},
  {{{0x3d374efc11646d58}},11,"F-H0-13692",507,6},
  {{{0x421596168df69c79}},5,"F-H0-13693",939,4},
  {{{0x1100f3ce16bdd685}},22,"F-H0-13694",826,4},
  {{{0x13cd69a4599b2b1e}},22,"F-H0-13695",836,2},
  {{{0xdb5b0742fe2d3a75}},5,"F-H0-13696",469,4},
  {{{0xd6a277f451bdf153}},5,"F-H0-13697",863,2},
  {{{0x773c9b6045b1a7b}},11,"F-H0-13698",492,3},
  {{{0x9c7a9ba4abc3e77}},12,"F-H0-13699",837,5},
  {{{0xbf5e3b6788c9d7b6}},7,"F-H0-13700",900,3},
  {{{0x714e0ea43e95be5e}},7,"F-H0-13701",429,2},
  {{{0xf678e54f78c2626a}},8,"F-H0-13702",539,4},
  {{{0xf385a3ddfeb2d6f8}},18,"F-H0-13703",875,2},
  {{{0x1dcbabe993bb6657}},9,"F-H0-13704",949,5},
  {{{0x310808e2fa4b4aaa}},6,"F-H0-13705",617,2},
  {{{0x5cfa71e30a329bd4}},8,"F-H0-13706",421,4},
  {{{0x4838a2afe274911}},10,"F-H0-13707",502,2},
  {{{0xaca634cba520dc78}},10,"F-H0-13708",827,2},
  {{{0xe1c27a53174ec3e1}},12,"F-H0-13709",457,2},
  {{{0x1c5dbdc8a75e0963}},12,"F-H0-13710",492,2},
  {{{0xbf722eb262542d64}},10,"F-H0-13711",418,2},
  {{{0xbf722eb262542d64}},10,"F-H0-13712",420,2},
  {{{0x204cb96c8acaa8a2}},13,"F-H0-13713",678,3},
  {{{0x384ade10009a9899}},7,"F-H0-13714",940,3},
  {{{0x36996e431aaee4d9}},8,"F-H0-13715",458,2},
  {{{0x68ca19b9300383db}},7,"F-H0-13716",865,5},
  {{{0xa98b2bb466205262}},12,"F-H0-13717",906,3},
  {{{0x4f154deaa83d2184}},6,"F-H0-13718",690,2},
  {{{0x18b2234b06547c4c}},6,"F-H0-13719",986,2},
  {{{0x6f6b7d0058259a7b}},8,"F-H0-13720",424,3},
  {{{0x997a9e13a3d04308}},9,"F-H0-13721",861,4},
  {{{0x4c959d4fc6862abe}},9,"F-H0-13722",566,2},
  {{{0x6d0daf30c339aa2}},5,"F-H0-13723",466,4},
  {{{0xdf773abb52890898}},11,"F-H0-13724",945,6},
  {{{0x38eaad755044de7}},20,"F-H0-13725",939,4},
  {{{0x177d91f1520297bb}},10,"F-H0-13726",988,6},
  {{{0x19b3426840408b62}},9,"F-H0-13727",863,4},
  {{{0x90a244d69077697a}},15,"F-H0-13728",503,5},
  {{{0x2c52c37956e4df52}},8,"F-H0-13729",899,6},
  {{{0x60e2318403b4428a}},5,"F-H0-13730",912,4},
  {{{0xff41b79d14828944}},6,"F-H0-13731",462,2},
  {{{0xa6ff24deead1193e}},6,"F-H0-13732",543,2},
  {{{0x4a7f5d4ab82dc274}},6,"F-H0-13733",912,2},
  {{{0x4a7f5d4ab82dc274}},6,"F-H0-13734",911,2},
  {{{0x4a7f5d4ab82dc274}},6,"F-H0-13735",985,2},
  {{{0xdc7858e1f25a7712}},2,"F-H0-13736",457,2},
  {{{0xdc7858e1f25a7712}},2,"F-H0-13737",913,2},
  {{{0xb9ad1a4559f44a58}},5,"F-H0-13738",942,2},
  {{{0x6ac25a4c08acd601}},9,"F-H0-13739",428,3},
  {{{0x4b45216ff631ac2d}},9,"F-H0-13740",947,2},
  {{{0xeeb80fd4d8b4f77c}},9,"F-H0-13741",898,3},
  {{{0xeeb80fd4d8b4f77c}},9,"F-H0-13742",715,3},
  {{{0xd45c08c4013f6db}},4,"F-H0-13743",901,4},
  {{{0x19bef9cd7a29c35f}},12,"F-H0-13744",690,5},
  {{{0x61a8bcaced46cc7a}},6,"F-H0-13745",950,2},
  {{{0x1fa581456e4f4e35}},7,"F-H0-13746",903,4},
  {{{0xba6d3debca33e225}},12,"F-H0-13747",948,2},
  {{{0x353277cd55f6e3c2}},12,"F-H0-13748",566,2},
  {{{0x3b9be93bf50f5be2}},6,"F-H0-13749",901,3},
  {{{0xa09bdf6d69424095}},9,"F-H0-13750",677,3},
  {{{0xa7eaf1a794ddbf69}},11,"F-H0-13751",939,5},
  {{{0x6817388c530ef468}},8,"F-H0-13752",903,3},
  {{{0x35577a4fcfc43e8c}},11,"F-H0-13753",873,4},
  {{{0x25460c706c6f7513}},7,"F-H0-13754",419,6},
  {{{0x3eb7ca5eb5c1e96c}},11,"F-H0-13755",985,5},
  {{{0xe611597bbcfefc88}},5,"F-H0-13756",529,2},
  {{{0x63bd8aa535c29bb9}},5,"F-H0-13757",825,2},
  {{{0x6bcb99631d354d22}},7,"F-H0-13758",900,2},
  {{{0x9e9c2969eab062f7}},6,"F-H0-13759",904,3},
  {{{0x2447a194a633e9ca}},4,"F-H0-13760",468,2},
  {{{0x119f1f084d59dc1c}},4,"F-H0-13761",431,2},
  {{{0x44441993894e3fbe}},8,"F-H0-13762",764,5},
  {{{0x4dc6686731726c0d}},4,"F-H0-13763",862,4},
  {{{0x4dc6686731726c0d}},4,"F-H0-13764",467,2},
  {{{0x9e7124ef3429358f}},12,"F-H0-13765",825,4},
  {{{0x2f53710e36a50d7f}},7,"F-H0-13766",838,3},
  {{{0x3b9d59f02608921b}},8,"F-H0-13767",579,5},
  {{{0x5739c970146b712c}},6,"F-H0-13768",381,6},
  {{{0x5f18ae89b07799bf}},8,"F-H0-13769",950,2},
  {{{0xdaff5f88e3be1899}},8,"F-H0-13770",460,2},
  {{{0xff633c58881a358}},21,"F-H0-13771",392,6},
  {{{0xd66776e4d948bb37}},10,"F-H0-13772",936,6},
  {{{0x2655fcd5e1f38017}},8,"F-H0-13773",826,3},
  {{{0xadb413e289f7f4a}},8,"F-H0-13774",826,3},
  {{{0x99ec691315f3e138}},11,"F-H0-13775",899,5},
  {{{0xc2c3205c06c6c3ee}},5,"F-H0-13776",911,2},
  {{{0xe48c292149010f5d}},5,"F-H0-13777",938,2},
  {{{0x1e9cc4334a00889}},11,"F-H0-13778",910,3},
  {{{0x1e9cc4334a00889}},11,"F-H0-13779",914,2},
  {{{0xd6f1ef3398347b6d}},11,"F-H0-13780",544,5},
  {{{0xce29915af841a078}},14,"F-H0-13781",948,6},
  {{{0x227531366f981222}},9,"F-H0-13782",937,6},
  {{{0x55d85605e6dd2870}},14,"F-H0-13783",529,6},
  {{{0xad166b0e56aec17f}},10,"F-H0-13784",431,3},
  {{{0x34f235dd7a6ca050}},10,"F-H0-13785",468,2},
  {{{0x80fce27f2de4e72d}},11,"F-H0-13786",939,3},
  {{{0xf821a0d1820c22e7}},7,"F-H0-13787",908,5},
  {{{0xddd5a6c9bb9a6854}},7,"F-H0-13788",504,2},
  {{{0xdd10c985bd5e60cc}},7,"F-H0-13789",466,2},
  {{{0x5225f3ca8c812864}},3,"F-H0-13790",865,2},
  {{{0xd303140e2ea81ebe}},17,"F-H0-13791",581,4},
  {{{0x583751f30352a1ec}},8,"F-H0-13792",913,5},
  {{{0x4c437e9469e4fb78}},7,"F-H0-13793",947,6},
  {{{0x233af58c87aa907d}},7,"F-H0-13794",579,3},
  {{{0x233af58c87aa907d}},7,"F-H0-13795",542,2},
  {{{0xe4f599b2c23c3635}},15,"F-H0-13796",839,3},
  {{{0x2b654a3ee3a54b61}},6,"F-H0-13797",493,5},
  {{{0x118b05843a9509db}},14,"F-H0-13798",950,5},
  {{{0x20f3adf8a06a1a78}},3,"F-H0-13799",876,2},
  {{{0xd594c334cf2ef4f4}},9,"F-H0-13800",899,4},
  {{{0xba3512d3ddbf3afb}},8,"F-H0-13801",865,5},
  {{{0x935eb74034350af1}},9,"F-H0-13802",802,3},
  {{{0x935eb74034350af1}},9,"F-H0-13803",839,3},
  {{{0x1da660a454a135ad}},13,"F-H0-13804",914,2},
  {{{0x1da660a454a135ad}},13,"F-H0-13805",690,2},
  {{{0xae2d276ac3c8d5ec}},12,"F-H0-13806",905,3},
  {{{0xd92005ddca76d44}},10,"F-H0-13807",974,4},
  {{{0x2e9aa92f56261445}},5,"F-H0-13808",495,2},
  {{{0x79f89b48ff7beef5}},8,"F-H0-13809",899,4},
  {{{0x1beb7d64968c9995}},20,"F-H0-13810",391,6},
  {{{0x10b486f64a9581e1}},6,"F-H0-13811",382,2},
  {{{0x1fdf26a759f34a69}},5,"F-H0-13812",911,2},
  {{{0xec9290269850f1b6}},11,"F-H0-13813",937,4},
  {{{0xec9290269850f1b6}},11,"F-H0-13814",898,2},
  {{{0x5908f609c13682fa}},8,"F-H0-13815",421,5},
  {{{0x986ee2e604766fc1}},9,"F-H0-13816",949,6},
  {{{0x651ff1f6bf3b75f3}},5,"F-H0-13817",908,2},
  {{{0xb44b1c8e7a90e344}},5,"F-H0-13818",506,2},
  {{{0xb05f226e4715df00}},6,"F-H0-13819",678,3},
  {{{0xa6e72e2e7a0e9de}},9,"F-H0-13820",429,3},
  {{{0xb30384141e881250}},7,"F-H0-13821",566,2},
  {{{0x9d74485ac0df5e07}},8,"F-H0-13822",865,6},
  {{{0xf3b2db216441ea2c}},16,"F-H0-13823",824,5},
  {{{0x6bceadccf5104ea3}},8,"F-H0-13824",913,5},
  {{{0x6953b809dc3bd391}},20,"F-H0-13825",529,4},
  {{{0x8efad89755bf8a2e}},18,"F-H0-13826",788,2},
  {{{0x42428eb9e0709d8f}},20,"F-H0-13827",942,3},
  {{{0x42428eb9e0709d8f}},20,"F-H0-13828",726,2},
  {{{0xe6a16eb1d67e31a0}},6,"F-H0-13829",690,3},
  {{{0xb158a0f88198a0e4}},6,"F-H0-13830",678,2},
  {{{0xd3d50865ad80b271}},7,"F-H0-13831",949,5},
  {{{0x1caf131e43e03b03}},5,"F-H0-13832",936,5},
  {{{0x5826e639f8a1b038}},13,"F-H0-13833",728,6},
  {{{0xdf210ac6f41e4275}},6,"F-H0-13834",876,4},
  {{{0x48c627d7dd50b7ce}},12,"F-H0-13835",678,4},
  {{{0x777b90eaeb09e737}},7,"F-H0-13836",873,5},
  {{{0xe713502579a86a0e}},7,"F-H0-13837",864,2},
  {{{0xaf2ac62fed3ae814}},8,"F-H0-13838",913,6},
  {{{0x486339a39e773776}},7,"F-H0-13839",765,6},
  {{{0xf1548b012c042384}},17,"F-H0-13840",543,2},
  {{{0xeba024440220e465}},17,"F-H0-13841",943,2},
  {{{0x3349b67535a7a50a}},6,"F-H0-13842",690,4},
  {{{0x925a6b45b52c13e8}},6,"F-H0-13843",837,2},
  {{{0xd3c87bb2a0b63d0e}},6,"F-H0-13844",421,2},
  {{{0x65e47bc9b1ba2f94}},11,"F-H0-13845",912,5},
  {{{0x6a976bcd6160528b}},4,"F-H0-13846",826,2},
  {{{0xa4c50eac2e5e402b}},6,"F-H0-13847",678,2},
  {{{0xf9e035c8c83b3e66}},6,"F-H0-13848",654,3},
  {{{0x31fb12b78250626a}},19,"F-H0-13849",801,3},
  {{{0x38ad77a06f5f7838}},4,"F-H0-13850",901,2},
  {{{0xfcc0b851cd5b4d2}},6,"F-H0-13851",417,5},
  {{{0xc3eb040721be59e4}},12,"F-H0-13852",837,5},
  {{{0xc0ffc01fe2841042}},12,"F-H0-13853",530,4},
  {{{0x35e8fcdafc6027f4}},12,"F-H0-13854",690,2},
  {{{0x6bd37ce27fcd296c}},12,"F-H0-13855",836,5},
  {{{0x48b464f72595a2e8}},8,"F-H0-13856",899,5},
  {{{0xa205e880f164f2ee}},8,"F-H0-13857",432,6},
  {{{0x7da069294ddc7de3}},5,"F-H0-13858",654,3},
  {{{0x7da069294ddc7de3}},5,"F-H0-13859",691,2},
  {{{0x18e003fd31e336ca}},7,"F-H0-13860",802,4},
  {{{0xe4ca37fab92b17f0}},7,"F-H0-13861",529,2},
  {{{0x228ee052c77e1f0e}},5,"F-H0-13862",913,2},
  {{{0x4786174cd61a33f3}},6,"F-H0-13863",839,3},
  {{{0x1b27c26056864709}},11,"F-H0-13864",873,3},
  {{{0x667332ad4b32ab6b}},13,"F-H0-13865",950,4},
  {{{0xa950285e3035bf2b}},5,"F-H0-13866",949,4},
  {{{0xd19092e2391e975}},6,"F-H0-13867",690,2},
  {{{0xd19092e2391e975}},6,"F-H0-13868",543,2},
  {{{0x23f330676d7211e7}},11,"F-H0-13869",913,6},
  {{{0x5aa089113a0b8927}},7,"F-H0-13870",714,4},
  {{{0x3a7cdf772f14c840}},6,"F-H0-13871",426,3},
  {{{0x3a7cdf772f14c840}},6,"F-H0-13872",543,2},
  {{{0x74eb18c242a6392a}},19,"F-H0-13873",949,5},
  {{{0xd4841464bdaa9efa}},6,"F-H0-13874",506,6},
  {{{0x36163f0ef50ef297}},9,"F-H0-13875",420,6},
  {{{0xae591916d2996d23}},6,"F-H0-13876",874,2},
  {{{0x5c67cc3caf5a8f65}},6,"F-H0-13877",458,2},
  {{{0x656139618cf4445d}},12,"F-H0-13878",938,3},
  {{{0x1794e53eb51fa7d7}},10,"F-H0-13879",432,3},
  {{{0x8b62004ab5f5a2b4}},11,"F-H0-13880",529,4},
  {{{0x3ac8884cca68d398}},10,"F-H0-13881",714,5},
  {{{0xf70f2dff30b96940}},9,"F-H0-13882",869,2},
  {{{0x42261e627d664991}},7,"F-H0-13883",530,6},
  {{{0xae06bc6ebe31e6ac}},12,"F-H0-13884",935,4},
  {{{0x5f5f2211170a1e70}},4,"F-H0-13885",912,2},
  {{{0x38cab66a6b6baf55}},2,"F-H0-13886",505,3},
  {{{0x3d6df042263cc983}},6,"F-H0-13887",908,2},
  {{{0x662bc1f62c3c3554}},14,"F-H0-13888",951,4},
  {{{0xd7d3e771ed480ad8}},14,"F-H0-13889",579,5},
  {{{0xcd0f8bbadf757ed3}},11,"F-H0-13890",506,4},
  {{{0xad5a6e562f1e11f7}},9,"F-H0-13891",876,6},
  {{{0x6ea0849b4b379150}},6,"F-H0-13892",938,5},
  {{{0x198ff96ab9e37bad}},9,"F-H0-13893",421,4},
  {{{0x60945bcfd3358aa6}},8,"F-H0-13894",751,3},
  {{{0xd613bf86b654ce24}},13,"F-H0-13895",949,4},
  {{{0xfbceee2d6481955d}},11,"F-H0-13896",466,4},
  {{{0xe81c6c4c42384d7a}},14,"F-H0-13897",863,2},
  {{{0x67ea3c876d3c087}},14,"F-H0-13898",977,2},
  {{{0x516404c5e0aecc9c}},14,"F-H0-13899",836,2},
  {{{0xf549abc04a5cb174}},15,"F-H0-13900",985,6},
  {{{0x6dbc08f8d46cf478}},8,"F-H0-13901",947,2},
  {{{0xeff0710a65d5453b}},8,"F-H0-13902",689,2},
  {{{0x60d5c6394696ae0b}},15,"F-H0-13903",986,5},
  {{{0xb7e248071493fe2b}},11,"F-H0-13904",579,5},
  {{{0xe38ec767c762bcc4}},5,"F-H0-13905",543,3},
  {{{0x7bbcd56656d62dd6}},8,"F-H0-13906",462,3},
  {{{0x997f8152dcb645db}},4,"F-H0-13907",973,6},
  {{{0x422104c7d962c751}},7,"F-H0-13908",939,2},
  {{{0xf83e35be2446316b}},8,"F-H0-13909",838,5},
  {{{0x13eb93d7055c8e11}},7,"F-H0-13910",654,2},
  {{{0xd91205a786d3f111}},21,"F-H0-13911",384,5},
  {{{0xbfd17dfe251cea80}},10,"F-H0-13912",837,5},
  {{{0xf8a5e9f10a7d63fb}},14,"F-H0-13913",432,5},
  {{{0x3219396b437018e4}},8,"F-H0-13914",949,6},
  {{{0xeaee5a0f2fae98b}},14,"F-H0-13915",908,3},
  {{{0x92aa9632735656d5}},9,"F-H0-13916",950,4},
  {{{0x81f95a72a4cc36a}},6,"F-H0-13917",875,3},
  {{{0xcc34b6e5c5a898b7}},6,"F-H0-13918",945,2},
  {{{0x80f14d3128de4493}},8,"F-H0-13919",506,3},
  {{{0x784d9f8f7337cbaf}},3,"F-H0-13920",900,3},
  {{{0x4c62fc9a17965a36}},6,"F-H0-13921",728,2},
  {{{0x1a32ddd09367c9c2}},6,"F-H0-13922",459,2},
  {{{0x58f907a7791cc081}},6,"F-H0-13923",911,2},
  {{{0x2d645e497fa23942}},17,"F-H0-13924",987,5},
  {{{0x8ae1c1eaec43fe12}},6,"F-H0-13925",541,3},
  {{{0x8ae1c1eaec43fe12}},6,"F-H0-13926",432,2},
  {{{0x432e022c5e123768}},11,"F-H0-13927",431,3},
  {{{0xa63a85430e0edf2b}},15,"F-H0-13928",506,4},
  {{{0x6c275bac1c4590c}},11,"F-H0-13929",678,5},
  {{{0x20c6ca5a12f1dc0f}},4,"F-H0-13930",839,2},
  {{{0xf2bc0592a360909d}},6,"F-H0-13931",432,3},
  {{{0xadec2af159db1daf}},6,"F-H0-13932",873,2},
  {{{0x3157f10f1bbbc2c8}},7,"F-H0-13933",466,3},
  {{{0xc7b62ea87747e3cf}},12,"F-H0-13934",947,3},
  {{{0x6b9e15134e488ce8}},12,"F-H0-13935",678,2},
  {{{0xcc47880d077aa833}},10,"F-H0-13936",938,3},
  {{{0xbc59b09ee0278140}},10,"F-H0-13937",432,2},
  {{{0x3b19bfb63cba615b}},17,"F-H0-13938",715,2},
  {{{0x4c14d27784b8260d}},17,"F-H0-13939",986,2},
  {{{0xdfae454405e77f6e}},7,"F-H0-13940",466,3},
  {{{0x39e9de45075b0ae3}},12,"F-H0-13941",936,3},
  {{{0x482909542d20dcb4}},6,"F-H0-13942",986,3},
  {{{0xb690b47780f56cb5}},11,"F-H0-13943",418,2},
  {{{0x817d1d71e385602e}},14,"F-H0-13944",469,2},
  {{{0x9229813dbe437437}},9,"F-H0-13945",542,2},
  {{{0x25464951c9388c8e}},9,"F-H0-13946",986,2},
  {{{0x7bcc66c86999e1f0}},15,"F-H0-13947",653,5},
  {{{0x96c96d49af96a568}},10,"F-H0-13948",825,5},
  {{{0xbdfb26f4ba9930b5}},10,"F-H0-13949",826,4},
  {{{0x476ebe3967ad1aa9}},9,"F-H0-13950",950,5},
  {{{0xd2cd3286209a7eaf}},8,"F-H0-13951",945,2},
  {{{0x7db48ff848991429}},7,"F-H0-13952",939,2},
  {{{0x7db48ff848991429}},7,"F-H0-13953",913,2},
  {{{0x5d26e306f4a9728e}},12,"F-H0-13954",469,4},
  {{{0x3f084eb5596ab44}},5,"F-H0-13955",825,2},
  {{{0x91bc98c5e89610ef}},12,"F-H0-13956",870,3},
  {{{0x748e7c00f0c15b63}},4,"F-H0-13957",837,2},
  {{{0xcda1ccf8f87bd3c4}},6,"F-H0-13958",936,2},
  {{{0x5592d98ff730a0c6}},11,"F-H0-13959",427,3},
  {{{0x525194b0e43c0969}},12,"F-H0-13960",751,4},
  {{{0xd3d1bbcb4b391619}},12,"F-H0-13961",542,2},
  {{{0x6d705e773c51b5a4}},12,"F-H0-13962",876,2},
  {{{0x8e55922c80d0eea9}},9,"F-H0-13963",950,5},
  {{{0xfb7cef47bebcc8d4}},7,"F-H0-13964",837,2},
  {{{0xb0e7b1c4610a09f5}},13,"F-H0-13965",912,4},
  {{{0x3a3590ce2e90078f}},10,"F-H0-13966",911,5},
  {{{0x933e8eb1bae21847}},6,"F-H0-13967",457,2},
  {{{0x8ff41ce00d32fa43}},6,"F-H0-13968",839,2},
  {{{0xc568efefc2181bd6}},9,"F-H0-13969",950,4},
  {{{0x65dadaa137647bea}},11,"F-H0-13970",911,3},
  {{{0x65dadaa137647bea}},11,"F-H0-13971",617,2},
  {{{0x92a78e0e07c7d9c8}},21,"F-H0-13972",951,4},
  {{{0xc675ae84974cbb7c}},9,"F-H0-13973",432,3},
  {{{0xf390e4266ad449c1}},13,"F-H0-13974",394,3},
  {{{0x7727fa408e73cc17}},13,"F-H0-13975",505,2},
  {{{0x60d4b1d1f83c399}},18,"F-H0-13976",913,3},
  {{{0x56c9022a200a3e09}},8,"F-H0-13977",987,4},
  {{{0x91a89b528875b441}},9,"F-H0-13978",914,4},
  {{{0x805c951fed650de8}},13,"F-H0-13979",872,4},
  {{{0xb01895ef282f6a2c}},11,"F-H0-13980",825,2},
  {{{0xd2710852a75254cf}},11,"F-H0-13981",838,2},
  {{{0x706cc480d24a6229}},11,"F-H0-13982",839,3},
  {{{0x63128a8887a072aa}},11,"F-H0-13983",939,2},
  {{{0x39ce6684d1282961}},9,"F-H0-13984",542,3},
  {{{0xb90fcbb3a7f0f50a}},9,"F-H0-13985",461,2},
  {{{0xde5deb37e4b8b11e}},6,"F-H0-13986",467,2},
  {{{0x3e7a712f2cd390e5}},6,"F-H0-13987",863,2},
  {{{0xfd9935b2f0a48915}},13,"F-H0-13988",431,5},
  {{{0x30fe67667e98ec90}},6,"F-H0-13989",429,2},
  {{{0x30fe67667e98ec90}},6,"F-H0-13990",432,2},
  {{{0x61cc13fc57d34c8a}},5,"F-H0-13991",492,2},
  {{{0xba4e6e76f317bd7}},4,"F-H0-13992",911,2},
  {{{0x2a9d00657f38146a}},7,"F-H0-13993",432,2},
  {{{0xdfaefec681b8cfe6}},6,"F-H0-13994",801,3},
  {{{0xd2dfe0784aef6a03}},8,"F-H0-13995",494,5},
  {{{0x341dde8c8ecedc84}},10,"F-H0-13996",941,2},
  {{{0x5ed377da184e0c39}},15,"F-H0-13997",603,4},
  {{{0xff3302ca8ddaa1ef}},6,"F-H0-13998",616,3},
  {{{0x6f29e55be83d3302}},7,"F-H0-13999",939,4},
  {{{0x888a8d552220bf8a}},8,"F-H0-14000",951,3},
  {{{0xeeed15fb6ab7c410}},8,"F-H0-14001",455,2},
  {{{0x61f0e73a4121bcf7}},7,"F-H0-14002",466,3},
  {{{0x5b91ed3165a58642}},11,"F-H0-14003",836,3},
  {{{0xe2829beeb7270c6c}},11,"F-H0-14004",418,2},
  {{{0x95737deb6ee33b26}},10,"F-H0-14005",976,5},
  {{{0x2bf02f8c1ef048af}},11,"F-H0-14006",691,2},
  {{{0xa650fddf5930fe5e}},11,"F-H0-14007",867,2},
  {{{0x5716416ea832896a}},9,"F-H0-14008",432,4},
  {{{0x90b0d7510e55c600}},13,"F-H0-14009",939,3},
  {{{0x4c8d1a5d4bb388db}},10,"F-H0-14010",431,3},
  {{{0xfcc8607e3d778688}},12,"F-H0-14011",947,5},
  {{{0x3aa8b5d5fcc93033}},19,"F-H0-14012",871,2},
  {{{0xef2a3a553e5e372b}},7,"F-H0-14013",467,3},
  {{{0x84a40a696fd42ced}},4,"F-H0-14014",910,2},
  {{{0xfa210f18f310888c}},4,"F-H0-14015",825,2},
  {{{0xeba3651e0e0e70cf}},9,"F-H0-14016",947,4},
  {{{0x20025f05c31f3e18}},6,"F-H0-14017",641,2},
  {{{0x20025f05c31f3e18}},6,"F-H0-14018",678,2},
  {{{0xe54f2e59083b4878}},6,"F-H0-14019",839,3},
  {{{0x6292a47dfe2b5490}},13,"F-H0-14020",899,5},
  {{{0xb8273ad12fb2d7fd}},11,"F-H0-14021",532,2},
  {{{0xb8273ad12fb2d7fd}},11,"F-H0-14022",418,2},
  {{{0xf9e000ea3c902692}},5,"F-H0-14023",943,3},
  {{{0xf15b5a0a7d77744c}},5,"F-H0-14024",421,2},
  {{{0xa83939158005f4f3}},12,"F-H0-14025",913,4},
  {{{0x1957445fd0ad5db}},7,"F-H0-14026",529,3},
  {{{0x5dff4c165abbbcfa}},8,"F-H0-14027",495,5},
  {{{0x721a7c92db0c4b15}},12,"F-H0-14028",861,2},
  {{{0xcdd5ec528f13706d}},7,"F-H0-14029",950,2},
  {{{0x56cffb29a2af3a90}},11,"F-H0-14030",470,4},
  {{{0xc2b56b8154791675}},8,"F-H0-14031",469,4},
  {{{0x983dc14369de5540}},7,"F-H0-14032",468,5},
  {{{0x807ac86d7a25d561}},12,"F-H0-14033",529,2},
  {{{0x10b18ac7f5643a42}},12,"F-H0-14034",947,4},
  {{{0xd67a87de567fb235}},8,"F-H0-14035",432,4},
  {{{0x587ad2c036865974}},5,"F-H0-14036",898,2},
  {{{0x729e753417de4bc5}},10,"F-H0-14037",941,2},
  {{{0x197a4d4742b108da}},9,"F-H0-14038",948,2},
  {{{0xf0720ec03c025fa}},9,"F-H0-14039",950,2},
  {{{0xd8c609e14c5b3caf}},13,"F-H0-14040",863,2},
  {{{0xe5ab73b642ac3e65}},7,"F-H0-14041",910,5},
  {{{0x1a5ffe07f42f9ab1}},12,"F-H0-14042",973,5},
  {{{0x63a7f1a5d3a5854}},9,"F-H0-14043",503,3},
  {{{0x6bb2bf3f7787e60a}},10,"F-H0-14044",938,3},
  {{{0xc78cba1b08dce0e4}},10,"F-H0-14045",875,5},
  {{{0x2a29c9ffc951ad62}},6,"F-H0-14046",906,2},
  {{{0xb08c6f0bc8521476}},19,"F-H0-14047",876,5},
  {{{0x2c756df6d43c6946}},18,"F-H0-14048",947,4},
  {{{0xa11089923a54a89d}},12,"F-H0-14049",421,2},
  {{{0x16443bcf6ca1573f}},8,"F-H0-14050",530,5},
  {{{0x46aa26a44f48c53f}},11,"F-H0-14051",912,5},
  {{{0xcdbc2fae92a1a73b}},12,"F-H0-14052",491,4},
  {{{0x65e1def13303ac35}},10,"F-H0-14053",874,2},
  {{{0xb0e9901e4cbe0d27}},15,"F-H0-14054",653,3},
  {{{0x47438b46d4a9e200}},6,"F-H0-14055",911,2},
  {{{0x2fa03ae8fbeb6a9b}},7,"F-H0-14056",419,5},
  {{{0xfb3b4a2fd2eff93a}},9,"F-H0-14057",457,5},
  {{{0xea5335afc5ee6ee7}},4,"F-H0-14058",467,2},
  {{{0x5887ff681081df3e}},4,"F-H0-14059",937,2},
  {{{0xaafc0956e096ff9c}},9,"F-H0-14060",950,5},
  {{{0x980d612fdc0ddb36}},15,"F-H0-14061",463,3},
  {{{0x980d612fdc0ddb36}},15,"F-H0-14062",431,2},
  {{{0xcec8541e3f25cf2b}},9,"F-H0-14063",801,3},
  {{{0xc4bce9daeb5866ab}},11,"F-H0-14064",838,3},
  {{{0x8304c39b98e4ced5}},15,"F-H0-14065",981,3},
  {{{0x28d1b2f5f15673b7}},8,"F-H0-14066",912,5},
  {{{0xac6ae9b7dc80acb6}},9,"F-H0-14067",876,4},
  {{{0xdef44ebce474a9cd}},11,"F-H0-14068",943,2},
  {{{0x18f4577f56bfdfe1}},6,"F-H0-14069",757,2},
  {{{0xd3f669099770d665}},3,"F-H0-14070",430,3},
  {{{0xe2c498af0ed1aa10}},4,"F-H0-14071",826,3},
  {{{0x20139427f7edada4}},14,"F-H0-14072",429,2},
  {{{0x916c3b63812ba19d}},16,"F-H0-14073",418,3},
  {{{0x916c3b63812ba19d}},16,"F-H0-14074",531,2},
  {{{0x9e89d7ffc46b1a71}},9,"F-H0-14075",567,3},
  {{{0xcff4ae20ac928da4}},14,"F-H0-14076",566,2},
  {{{0x37a0ab83862c7451}},12,"F-H0-14077",974,3},
  {{{0xf1820414b2d5c03}},6,"F-H0-14078",418,5},
  {{{0x49ae6d31392fd89e}},16,"F-H0-14079",506,4},
  {{{0xd0d020216d7efa1f}},24,"F-H0-14080",914,3},
  {{{0x28dd4b8505ded408}},6,"F-H0-14081",985,3},
  {{{0xdd7c0ed7e163dc01}},7,"F-H0-14082",432,2},
  {{{0xdd7c0ed7e163dc01}},7,"F-H0-14083",542,2},
  {{{0x5e01f1e2878e9660}},20,"F-H0-14084",911,3},
  {{{0x657ee587651db26d}},14,"F-H0-14085",433,3},
  {{{0x2a28363ba50119c1}},6,"F-H0-14086",691,2},
  {{{0xfe7988ffddcda4f}},5,"F-H0-14087",865,3},
  {{{0x999374ee54cb32a3}},5,"F-H0-14088",506,2},
  {{{0xbfe967af338445db}},13,"F-H0-14089",985,5},
  {{{0xfbf94d67315932e2}},7,"F-H0-14090",395,3},
  {{{0x696a0f233d4bc679}},7,"F-H0-14091",456,3},
  {{{0x101bf4c44b2b3a27}},7,"F-H0-14092",542,4},
  {{{0x3131c9199f18c76c}},21,"F-H0-14093",944,2},
  {{{0x3131c9199f18c76c}},21,"F-H0-14094",945,2},
  {{{0xbc7d8494119a4fca}},9,"F-H0-14095",947,5},
  {{{0xb4d64ec13a00fc0b}},7,"F-H0-14096",947,3},
  {{{0x102416d60420798b}},6,"F-H0-14097",531,3},
  {{{0x83963c13db82d32e}},6,"F-H0-14098",462,2},
  {{{0x86a791ade7edf7bc}},18,"F-H0-14099",421,3},
  {{{0x9dd4ec4832637eba}},9,"F-H0-14100",875,3},
  {{{0xdf47fa6b50c5184e}},8,"F-H0-14101",529,3},
  {{{0xd255670158ad9b43}},19,"F-H0-14102",949,2},
  {{{0x2612f14c0aa02470}},9,"F-H0-14103",950,5},
  {{{0x79e9a8e43447e27}},11,"F-H0-14104",829,2},
  {{{0x646ccae7d2df8b22}},16,"F-H0-14105",939,2},
  {{{0x552cf319acd86308}},5,"F-H0-14106",420,2},
  {{{0x47ca913fd55629d7}},5,"F-H0-14107",505,2},
  {{{0xdcd453db37eb897d}},15,"F-H0-14108",951,3},
  {{{0x7923ce4f4b42b770}},9,"F-H0-14109",947,5},
  {{{0xda2e3048273fcdf3}},14,"F-H0-14110",877,5},
  {{{0xefdc7a6f7bc63603}},6,"F-H0-14111",945,3},
  {{{0xa7a39648f6bba8a3}},7,"F-H0-14112",432,2},
  {{{0xfc4540d383b41e38}},5,"F-H0-14113",455,5},
  {{{0xb871e8b005eb77fc}},17,"F-H0-14114",951,5},
  {{{0x366b1032691c0321}},8,"F-H0-14115",505,4},
  {{{0xceb12b0cdcca3c4}},22,"F-H0-14116",940,4},
  {{{0x1583e1fe3ae3b16f}},7,"F-H0-14117",421,3},
  {{{0xc864dad34f3b0765}},4,"F-H0-14118",875,3},
  {{{0xe401beb658bfcc81}},6,"F-H0-14119",418,3},
  {{{0xe401beb658bfcc81}},6,"F-H0-14120",531,2},
  {{{0xf866a47b24398d86}},9,"F-H0-14121",419,5},
  {{{0x4fb9f6a012ad5f53}},10,"F-H0-14122",838,4},
  {{{0x76ddb8b8fa429e4e}},9,"F-H0-14123",423,5},
  {{{0xea8e35f3c2d8f672}},9,"F-H0-14124",948,4},
  {{{0x629334b5f70131e6}},6,"F-H0-14125",910,3},
  {{{0x80247525a9a7796d}},7,"F-H0-14126",912,3},
  {{{0x63681acb16c2dbc1}},7,"F-H0-14127",492,3},
  {{{0x230466732a500719}},5,"F-H0-14128",531,2},
  {{{0x3e0ef8b846a3d24d}},12,"F-H0-14129",506,3},
  {{{0x4906ae6c37ad7f4f}},16,"F-H0-14130",765,3},
  {{{0x1f2421cda442c13d}},11,"F-H0-14131",824,3},
  {{{0x15f02963750c9442}},12,"F-H0-14132",468,4},
  {{{0xb6edfccdba5fbbe}},10,"F-H0-14133",383,5},
  {{{0x6d4491f8dd176649}},9,"F-H0-14134",898,2},
  {{{0xaed8aa3a0281e53b}},9,"F-H0-14135",580,2},
  {{{0x2530623919a343df}},9,"F-H0-14136",939,2},
  {{{0x772eff4778e1b836}},6,"F-H0-14137",942,2},
  {{{0xe6ae8709f7fb91f0}},11,"F-H0-14138",911,3},
  {{{0x36a4f4485374480b}},14,"F-H0-14139",579,5},
  {{{0xc38f811f4d6aafd2}},24,"F-H0-14140",529,4},
  {{{0x8aa079e8fe0a9b2}},4,"F-H0-14141",788,2},
  {{{0xdaad8eabb0776791}},8,"F-H0-14142",429,2},
  {{{0xde23d8e57efd49ec}},10,"F-H0-14143",380,3},
  {{{0x74205e746256170c}},9,"F-H0-14144",423,4},
  {{{0xa6ed684413f5d9d8}},15,"F-H0-14145",976,2},
  {{{0x41e0904d450cb02c}},10,"F-H0-14146",872,4},
  {{{0xa515adc883948349}},7,"F-H0-14147",381,5},
  {{{0x598c1e18b3568da1}},8,"F-H0-14148",690,4},
  {{{0xac77c32b7a587eb8}},9,"F-H0-14149",909,3},
  {{{0xa2b18b38ab48084}},14,"F-H0-14150",544,5},
  {{{0xabe04dbc3bb88148}},11,"F-H0-14151",901,3},
  {{{0x23ee0483d3c1c37d}},9,"F-H0-14152",531,5},
  {{{0xaf4ad8695ec8f82c}},14,"F-H0-14153",948,5},
  {{{0xb1de7ab9e48bbae0}},8,"F-H0-14154",799,5},
  {{{0x126ba561d2cb5cc8}},3,"F-H0-14155",647,2},
  {{{0x47d9b7d3ea98e51a}},3,"F-H0-14156",646,2},
  {{{0x26347fb79abe2ecb}},3,"F-H0-14157",431,3},
  {{{0x37f16854c5af3215}},12,"F-H0-14158",565,3},
  {{{0xa9f11fcc4d4f79b}},15,"F-H0-14159",914,2},
  {{{0x84723ffb6f3fd069}},15,"F-H0-14160",417,2},
  {{{0x1e155ada956fefed}},7,"F-H0-14161",905,5},
  {{{0xcdb256f2fffcba20}},5,"F-H0-14162",677,2},
  {{{0xc99d6527ea6ff468}},5,"F-H0-14163",910,2},
  {{{0x2b3a82b8d441fe4d}},10,"F-H0-14164",727,2},
  {{{0xa1e5b84355b95995}},13,"F-H0-14165",913,5},
  {{{0x29484b1e54ee8d8f}},7,"F-H0-14166",456,3},
  {{{0x29484b1e54ee8d8f}},7,"F-H0-14167",458,2},
  {{{0x21e112d817938b40}},9,"F-H0-14168",825,2},
  {{{0x9faada070db3f85c}},10,"F-H0-14169",950,2},
  {{{0x681e9f3d538c1eb0}},7,"F-H0-14170",492,3},
  {{{0x681e9f3d538c1eb0}},7,"F-H0-14171",418,2},
  {{{0x928e6a432bf93315}},7,"F-H0-14172",468,3},
  {{{0x928e6a432bf93315}},7,"F-H0-14173",470,2},
  {{{0xe69d16b9498d60ce}},17,"F-H0-14174",905,3},
  {{{0x946f6161712455b0}},17,"F-H0-14175",914,2},
  {{{0x77aed265b23d7e71}},17,"F-H0-14176",943,4},
  {{{0xd670da63c3ea0128}},7,"F-H0-14177",529,4},
  {{{0xa0a42865e8cef63c}},12,"F-H0-14178",986,3},
  {{{0x70e677a68c5e0190}},12,"F-H0-14179",986,2},
  {{{0x44a9f7cef9aebb1b}},8,"F-H0-14180",505,5},
  {{{0x42343bbb4afc3781}},11,"F-H0-14181",911,2},
  {{{0x42343bbb4afc3781}},11,"F-H0-14182",875,2},
  {{{0xb4aa7d17b99b18df}},10,"F-H0-14183",901,2},
  {{{0x93e19376ecaf9ae3}},12,"F-H0-14184",470,3},
  {{{0x8cacdc4334193648}},8,"F-H0-14185",432,2},
  {{{0x4240b56872dcf4c2}},8,"F-H0-14186",902,5},
  {{{0x149785f6508bc650}},8,"F-H0-14187",431,5},
  {{{0xd0dc336685ea2be0}},5,"F-H0-14188",466,2},
  {{{0xd56778c745b4f3b8}},10,"F-H0-14189",899,2},
  {{{0x6f7419b8ababe7ef}},7,"F-H0-14190",461,2},
  {{{0x4225c731f4c510ce}},7,"F-H0-14191",690,2},
  {{{0x903e8bd16f0353ea}},8,"F-H0-14192",838,5},
  {{{0x2a5967a13d3b0cda}},12,"F-H0-14193",948,3},
  {{{0xc8dfadb635602a1d}},10,"F-H0-14194",506,3},
  {{{0xd695e521bd45381f}},10,"F-H0-14195",864,2},
  {{{0x4febbb9f5e38c58e}},9,"F-H0-14196",986,4},
  {{{0x6d03c3bd0e1eaede}},9,"F-H0-14197",947,5},
  {{{0xb77ea80834c039ec}},2,"F-H0-14198",913,3},
  {{{0x3fd1d6ff89d5d834}},7,"F-H0-14199",504,3},
  {{{0xa6d3d0c579c08937}},7,"F-H0-14200",458,2},
  {{{0x17887fe7e6ef339}},3,"F-H0-14201",468,4},
  {{{0x13bbcc3949bfee51}},21,"F-H0-14202",945,3},
  {{{0x13bbcc3949bfee51}},21,"F-H0-14203",944,2},
  {{{0x3d1f8b9d4d61adff}},13,"F-H0-14204",939,3},
  {{{0x6e19bfa64c2a365a}},9,"F-H0-14205",424,3},
  {{{0xcba98d4322d6fc05}},9,"F-H0-14206",678,2},
  {{{0x68936337550db24f}},3,"F-H0-14207",455,2},
  {{{0xa9c02c75465525e7}},5,"F-H0-14208",838,2},
  {{{0xe1215e590cafcb1d}},14,"F-H0-14209",873,3},
  {{{0x9d428fbf2536a006}},5,"F-H0-14210",462,2},
  {{{0x8df062b604fe75a0}},7,"F-H0-14211",950,4},
  {{{0x847f80f1208be7ac}},7,"F-H0-14212",495,5},
  {{{0x7a917e0d3c193d26}},7,"F-H0-14213",457,2},
  {{{0xf6925979a7bdbb0}},7,"F-H0-14214",839,2},
  {{{0x5b731741c060512}},10,"F-H0-14215",950,3},
  {{{0x3e74f68dd2366331}},7,"F-H0-14216",910,4},
  {{{0x39c6d4a080e13451}},18,"F-H0-14217",873,5},
  {{{0xc1661645511ca6df}},4,"F-H0-14218",939,3},
  {{{0xbdf52206a4c014a6}},15,"F-H0-14219",914,5},
  {{{0x1f91d6584208bad6}},12,"F-H0-14220",502,2},
  {{{0x1f91d6584208bad6}},12,"F-H0-14221",507,2},
  {{{0xd345fb616125a988}},6,"F-H0-14222",911,4},
  {{{0xfa26d9ed357f6157}},5,"F-H0-14223",789,2},
  {{{0xbd889799362b3c9d}},10,"F-H0-14224",988,4},
  {{{0x4990f75d89e1f6bb}},12,"F-H0-14225",839,2},
  {{{0xb971bd410abcaba4}},11,"F-H0-14226",380,2},
  {{{0x3bcbbd8941c8d9c4}},6,"F-H0-14227",604,2},
  {{{0xace671bf5d4ae78}},7,"F-H0-14228",839,2},
  {{{0x722967182ac7633d}},13,"F-H0-14229",875,5},
  {{{0xbf476756b7fa2100}},7,"F-H0-14230",936,3},
  {{{0x320c988d4308f76c}},7,"F-H0-14231",865,2},
  {{{0x1f063a6645f16781}},5,"F-H0-14232",418,2},
  {{{0xc94cdec526f7678c}},7,"F-H0-14233",911,3},
  {{{0x1ccb43b3f8901750}},7,"F-H0-14234",825,2},
  {{{0x93cd585b56a255d0}},7,"F-H0-14235",491,2},
  {{{0x9a414e0fbf35d650}},14,"F-H0-14236",391,4},
  {{{0xb917b4089abbfc64}},17,"F-H0-14237",945,3},
  {{{0x507a9304430759b0}},19,"F-H0-14238",899,2},
  {{{0x3a90b6c84f5666a0}},8,"F-H0-14239",459,4},
  {{{0xa952ee73190736ad}},12,"F-H0-14240",579,5},
  {{{0xbc988d545c9eaeb}},9,"F-H0-14241",943,2},
  {{{0x4fa77835870fd5f4}},7,"F-H0-14242",494,4},
  {{{0x1a282af5b1832e95}},6,"F-H0-14243",431,5},
  {{{0x4f9d1b88efe095aa}},10,"F-H0-14244",837,5},
  {{{0x4f3688966c32cc7d}},19,"F-H0-14245",949,5},
  {{{0xc1de9be49fdbf69}},4,"F-H0-14246",911,2},
  {{{0xa8d6c80a18ce3350}},11,"F-H0-14247",944,4},
  {{{0x5518f3875737cd1d}},12,"F-H0-14248",948,3},
  {{{0xcabb1e6ff3146508}},7,"F-H0-14249",873,5},
  {{{0x89662019c918cb56}},10,"F-H0-14250",678,4},
  {{{0xd039297cdb4120fa}},6,"F-H0-14251",949,2},
  {{{0x856cad6b73ce1009}},11,"F-H0-14252",944,3},
  {{{0x856cad6b73ce1009}},11,"F-H0-14253",872,2},
  {{{0xedce35a62ee81c18}},6,"F-H0-14254",910,2},
  {{{0x4134b87c442b55df}},6,"F-H0-14255",504,2},
  {{{0xee0e024fd8919479}},5,"F-H0-14256",727,2},
  {{{0x82f4cc5322333c81}},5,"F-H0-14257",579,2},
  {{{0xa04f7f745aa6abe9}},8,"F-H0-14258",910,2},
  {{{0x17aa2697ff91d787}},7,"F-H0-14259",948,4},
  {{{0xbd999abab15a0356}},9,"F-H0-14260",937,5},
  {{{0x96760ec75ac31ec1}},13,"F-H0-14261",840,4},
  {{{0x177e4c3bfd5aead7}},10,"F-H0-14262",541,3},
  {{{0x231f73c9c9ba9f11}},7,"F-H0-14263",825,4},
  {{{0x1ba504070a5acd3e}},9,"F-H0-14264",469,4},
  {{{0xc83ca8f6bc1c3885}},21,"F-H0-14265",839,3},
  {{{0xa7cdc7c983a5d8a0}},11,"F-H0-14266",542,4},
  {{{0xd0e41bc2327710ae}},10,"F-H0-14267",421,4},
  {{{0x9439d4a29b26b544}},9,"F-H0-14268",467,4},
  {{{0x61862621bd484ffb}},6,"F-H0-14269",690,2},
  {{{0xc7aeefd2b80b7c4}},12,"F-H0-14270",911,5},
  {{{0x6a284d04b53c1907}},10,"F-H0-14271",938,5},
  {{{0x9ad9e588610b7cd}},7,"F-H0-14272",873,3},
  {{{0x9ad9e588610b7cd}},7,"F-H0-14273",950,2},
  {{{0x8343e3e7392f5be0}},6,"F-H0-14274",495,3},
  {{{0xc83e514297abb453}},6,"F-H0-14275",950,2},
  {{{0xfc5ce5e867c4af51}},12,"F-H0-14276",653,2},
  {{{0x1bb96a8d050b82f4}},7,"F-H0-14277",653,3},
  {{{0xa68bd4202c1fcc5d}},5,"F-H0-14278",839,2},
  {{{0xa68bd4202c1fcc5d}},5,"F-H0-14279",945,2},
  {{{0xe688749eaac812c2}},14,"F-H0-14280",945,2},
  {{{0xe688749eaac812c2}},14,"F-H0-14281",948,2},
  {{{0x474a29c0668c4a26}},11,"F-H0-14282",898,3},
  {{{0x956bad5229fe78d9}},12,"F-H0-14283",949,3},
  {{{0x6296b278c97fe21c}},7,"F-H0-14284",947,3},
  {{{0xe2537440eb3d4526}},7,"F-H0-14285",506,3},
  {{{0xdaf8891a659af322}},10,"F-H0-14286",985,2},
  {{{0x784ab1be967b5a24}},8,"F-H0-14287",945,4},
  {{{0x1c0b388111a3116f}},11,"F-H0-14288",912,3},
  {{{0x1c0b388111a3116f}},11,"F-H0-14289",950,2},
  {{{0xf76bdf40ca116139}},13,"F-H0-14290",459,3},
  {{{0x918dfbacb87a5594}},8,"F-H0-14291",543,2},
  {{{0x7b8ea4d40dfd83d3}},8,"F-H0-14292",425,2},
  {{{0xb8fd5567a1ade2ef}},12,"F-H0-14293",494,2},
  {{{0x294817a12440704a}},8,"F-H0-14294",579,3},
  {{{0x9e15462157191038}},10,"F-H0-14295",871,3},
  {{{0xdb2b38a2096b0ee1}},10,"F-H0-14296",913,4},
  {{{0x99fe132fe5923d68}},20,"F-H0-14297",602,2},
  {{{0x99fe132fe5923d68}},20,"F-H0-14298",422,2},
  {{{0x35e57cb15d2a0b38}},9,"F-H0-14299",458,2},
  {{{0x35e57cb15d2a0b38}},9,"F-H0-14300",495,2},
  {{{0xd6ab06102b28122a}},8,"F-H0-14301",876,3},
  {{{0x53ea4da3071526a1}},5,"F-H0-14302",529,2},
  {{{0xa750e0b55f5f3302}},6,"F-H0-14303",945,3},
  {{{0xde25cacfc23d5c68}},13,"F-H0-14304",987,4},
  {{{0x24264fe66a8b072f}},6,"F-H0-14305",902,2},
  {{{0xe3dff21a9228dad6}},14,"F-H0-14306",838,3},
  {{{0xa615756c6c9607df}},14,"F-H0-14307",493,2},
  {{{0xd751b77bdaa3a902}},10,"F-H0-14308",802,2},
  {{{0xf98fc8f4e9e48936}},16,"F-H0-14309",911,2},
  {{{0x9b4ebfe60cfb2128}},5,"F-H0-14310",825,2},
  {{{0x60a02756b06b32ab}},15,"F-H0-14311",825,2},
  {{{0x6709d2c680b6fa27}},7,"F-H0-14312",825,2},
  {{{0x6c2b207391bbf1a}},5,"F-H0-14313",944,2},
  {{{0x82624392433104af}},6,"F-H0-14314",690,3},
  {{{0x1c06e965211ddb46}},3,"F-H0-14315",431,3},
  {{{0x1c06e965211ddb46}},3,"F-H0-14316",467,2},
  {{{0x9856f9eb3ca543b0}},8,"F-H0-14317",541,3},
  {{{0xe49ff39007d5d403}},10,"F-H0-14318",838,4},
  {{{0x6ceb8d161fc64d9}},5,"F-H0-14319",460,2},
  {{{0x6ceb8d161fc64d9}},5,"F-H0-14320",467,2},
  {{{0xfd099679bf21ffce}},9,"F-H0-14321",678,4},
  {{{0x95ef7616c0459d27}},8,"F-H0-14322",986,2},
  {{{0xaf710c211b34b86a}},11,"F-H0-14323",974,2},
  {{{0x6cf148884f0341cd}},13,"F-H0-14324",899,3},
  {{{0x99f9efcc3f43d4d}},3,"F-H0-14325",938,2},
  {{{0x99f9efcc3f43d4d}},3,"F-H0-14326",937,2},
  {{{0x8ddb65c680654541}},7,"F-H0-14327",617,2},
  {{{0x8ddb65c680654541}},7,"F-H0-14328",466,2},
  {{{0x6da88343d6ab91c7}},10,"F-H0-14329",972,4},
  {{{0xf1d4fa00e880c17f}},9,"F-H0-14330",910,2},
  {{{0xf1d4fa00e880c17f}},9,"F-H0-14331",909,2},
  {{{0xbefa0488953e0966}},9,"F-H0-14332",506,2},
  {{{0x884a51274670c502}},7,"F-H0-14333",466,3},
  {{{0xc8910948a35bc2e4}},10,"F-H0-14334",838,4},
  {{{0x716b82b0ac19ed54}},21,"F-H0-14335",913,3},
  {{{0x418dabc89e536bc6}},7,"F-H0-14336",677,2},
  {{{0xadd3914bc4c10db9}},6,"F-H0-14337",826,3},
  {{{0x372876878ae6a8e1}},6,"F-H0-14338",567,2},
  {{{0xd7fa5a6a1769e606}},9,"F-H0-14339",580,4},
  {{{0x78282a22c9eb635b}},10,"F-H0-14340",949,3},
  {{{0x3910811bd54ff6fb}},10,"F-H0-14341",949,2},
  {{{0x4a047a3c182769c1}},10,"F-H0-14342",951,4},
  {{{0x2f4b7609279acaf}},6,"F-H0-14343",677,2},
  {{{0x2c82bdfbe8356b48}},6,"F-H0-14344",425,2},
  {{{0xbae2727548a13201}},22,"F-H0-14345",654,2},
  {{{0x2d8c5cc17c2a608b}},11,"F-H0-14346",873,3},
  {{{0x964e58eb72dfa45d}},6,"F-H0-14347",948,4},
  {{{0x91aafeb2b740da03}},7,"F-H0-14348",543,2},
  {{{0x309e34d53f49bd0c}},7,"F-H0-14349",911,2},
  {{{0x4f3134a4cbc3ca3}},16,"F-H0-14350",839,3},
  {{{0xcc43cd693dadc2d6}},3,"F-H0-14351",900,2},
  {{{0x75691010d806b947}},12,"F-H0-14352",839,2},
  {{{0xd30f0bfd57365975}},5,"F-H0-14353",426,4},
  {{{0x58fe04ea3da4d265}},7,"F-H0-14354",530,4},
  {{{0x204f48559335e5cf}},9,"F-H0-14355",641,2},
  {{{0x64e37835e93067a3}},9,"F-H0-14356",974,2},
  {{{0xe830109b4b1dbdb0}},10,"F-H0-14357",431,5},
  {{{0x17e30a439588e1f8}},7,"F-H0-14358",913,2},
  {{{0xf60a312a8726ec31}},8,"F-H0-14359",837,2},
  {{{0x88cae9229cde7818}},7,"F-H0-14360",455,3},
  {{{0x302fc8ef879a0d0e}},7,"F-H0-14361",801,2},
  {{{0x91287a14dd3df32c}},12,"F-H0-14362",790,4},
  {{{0x7c50df262e073ed5}},6,"F-H0-14363",466,2},
  {{{0x421dd40fbb1d77d0}},6,"F-H0-14364",948,2},
  {{{0x32f95643039b67cb}},8,"F-H0-14365",826,4},
  {{{0x93efc416f6962e89}},5,"F-H0-14366",908,2},
  {{{0x6a5dbb1b677baed7}},20,"F-H0-14367",839,5},
  {{{0x78a6b8cdbfb75897}},3,"F-H0-14368",758,2},
  {{{0xc056ed4783cd7506}},8,"F-H0-14369",466,2},
  {{{0xa9971498a4bfb54a}},12,"F-H0-14370",430,4},
  {{{0x972ce921221b3156}},13,"F-H0-14371",910,4},
  {{{0x499fcb6c5e1e049a}},14,"F-H0-14372",907,5},
  {{{0x2f4c1ee3489f45d7}},18,"F-H0-14373",978,2},
  {{{0x3230af9f6c319d64}},11,"F-H0-14374",421,2},
  {{{0x443c2af56f6e7d7f}},11,"F-H0-14375",947,2},
  {{{0x70d3b660c60546fe}},18,"F-H0-14376",543,2},
  {{{0x92c1e32332233b1b}},8,"F-H0-14377",912,5},
  {{{0xcc7dcbbdb32992ef}},6,"F-H0-14378",506,4},
  {{{0x4adc203635ee0f69}},11,"F-H0-14379",976,3},
  {{{0x6c16ffca18550a88}},11,"F-H0-14380",417,2},
  {{{0xdd19f2c0fe8760ee}},6,"F-H0-14381",877,2},
  {{{0xdd19f2c0fe8760ee}},6,"F-H0-14382",837,2},
  {{{0x40610b9a2c4b0e4e}},9,"F-H0-14383",873,4},
  {{{0xc1d82c5c7cce3770}},6,"F-H0-14384",690,2},
  {{{0x30b86beafb7e3b26}},7,"F-H0-14385",420,3},
  {{{0x34d25ee682d706b1}},13,"F-H0-14386",753,5},
  {{{0x743d97173a9b011a}},6,"F-H0-14387",911,4},
  {{{0x93d719d98f2a20be}},19,"F-H0-14388",914,3},
  {{{0xf6e5ccb2f73a86bf}},8,"F-H0-14389",913,2},
  {{{0x50896c7361809a4f}},9,"F-H0-14390",911,5},
  {{{0xd47b3486506864b4}},10,"F-H0-14391",541,4},
  {{{0xabb26d0fed34ae2c}},8,"F-H0-14392",942,3},
  {{{0xabb26d0fed34ae2c}},8,"F-H0-14393",420,2},
  {{{0x6a332ae39bc289d2}},12,"F-H0-14394",937,2},
  {{{0x23ad2c34fe52f336}},6,"F-H0-14395",838,4},
  {{{0xe8730b0db6724b0}},14,"F-H0-14396",641,2},
  {{{0x5eacfecc1fdb5fc5}},11,"F-H0-14397",506,5},
  {{{0x2d57b8cce572f3d}},6,"F-H0-14398",492,4},
  {{{0xdcfad56d8b0d938f}},18,"F-H0-14399",910,4},
  {{{0x73964344a0b1af56}},20,"F-H0-14400",983,5},
  {{{0x307d03bd97cb1fc5}},4,"F-H0-14401",431,3},
  {{{0x799660999e757205}},13,"F-H0-14402",910,3},
  {{{0x8975629b35b03677}},13,"F-H0-14403",539,2},
  {{{0x3287f71dd232bfd9}},16,"F-H0-14404",429,3},
  {{{0x90dd17d126e28ecf}},9,"F-H0-14405",912,5},
  {{{0xf2ee90ba3c1126e9}},5,"F-H0-14406",467,2},
  {{{0x9fad32fb4a5cb85e}},5,"F-H0-14407",530,2},
  {{{0x8f6e90948d45cfb9}},7,"F-H0-14408",827,4},
  {{{0x39a850c3651fdf15}},7,"F-H0-14409",910,4},
  {{{0xf8dc7183bea55689}},13,"F-H0-14410",507,5},
  {{{0xedeb986bdb251a}},6,"F-H0-14411",948,5},
  {{{0x90c721c4a0bc002e}},2,"F-H0-14412",419,3},
  {{{0x63718266adfb145d}},8,"F-H0-14413",431,5},
  {{{0x6510d1acf58e7a7d}},21,"F-H0-14414",909,4},
  {{{0xa1cbb60409be9350}},11,"F-H0-14415",912,3},
  {{{0x397e5eeac5b1275a}},23,"F-H0-14416",898,2},
  {{{0xc70f183ffa292d82}},23,"F-H0-14417",462,2},
  {{{0x5c723492268d0844}},7,"F-H0-14418",904,2},
  {{{0xa6a567d5ef06a841}},19,"F-H0-14419",876,2},
  {{{0xa2c61ec18278a624}},19,"F-H0-14420",752,2},
  {{{0xbd1786139d69a944}},16,"F-H0-14421",803,4},
  {{{0xc7684a85ff1f1d89}},3,"F-H0-14422",862,2},
  {{{0xd4a2e3f9f357684a}},17,"F-H0-14423",947,3},
  {{{0x80d023ff0a863712}},7,"F-H0-14424",950,2},
  {{{0xfa38c44f157b83b8}},7,"F-H0-14425",801,5},
  {{{0x4c98cab0454967a2}},18,"F-H0-14426",948,4},
  {{{0x8a0a71baa81b14b9}},10,"F-H0-14427",942,4},
  {{{0x68d3e6748ef0583b}},6,"F-H0-14428",802,3},
  {{{0x68d3e6748ef0583b}},6,"F-H0-14429",839,2},
  {{{0xcd094d3b29de5842}},11,"F-H0-14430",576,4},
  {{{0x36603dff5d289bb}},7,"F-H0-14431",876,3},
  {{{0x879ffce19a26fa8d}},9,"F-H0-14432",801,2},
  {{{0xa83183be11bbe025}},9,"F-H0-14433",605,2},
  {{{0xf2d9166a8f036033}},7,"F-H0-14434",946,3},
  {{{0x2daefbc04a92e42d}},7,"F-H0-14435",529,2},
  {{{0x7e8f167de55f3741}},5,"F-H0-14436",419,3},
  {{{0x7e8f167de55f3741}},5,"F-H0-14437",423,2},
  {{{0xd14fa22f3ceaf939}},13,"F-H0-14438",491,5},
  {{{0xdea512608b0bf96f}},9,"F-H0-14439",466,2},
  {{{0x6736d56278ff2cf4}},8,"F-H0-14440",900,5},
  {{{0x8e8f1d53c9e4f43d}},7,"F-H0-14441",938,4},
  {{{0x1accb2ebd76b7ce2}},10,"F-H0-14442",533,2},
  {{{0x65c93709c3e7c537}},6,"F-H0-14443",826,2},
  {{{0x5e93671f3995efdd}},6,"F-H0-14444",908,2},
  {{{0xcf2ada93eb50e998}},9,"F-H0-14445",825,4},
  {{{0x63f8fd6ca2359d1a}},5,"F-H0-14446",460,2},
  {{{0x536a32256f26b6f1}},12,"F-H0-14447",940,2},
  {{{0xcb042af05f7a1997}},3,"F-H0-14448",912,2},
  {{{0xd27952a8efa98e95}},9,"F-H0-14449",507,3},
  {{{0x2ed3bd7c42f3d12a}},10,"F-H0-14450",466,3},
  {{{0x93f3f1ef5a45e5d3}},5,"F-H0-14451",839,2},
  {{{0x53428e2294302656}},5,"F-H0-14452",947,2},
  {{{0xc70b5dbadb1433dc}},6,"F-H0-14453",801,2},
  {{{0x936cd808c54937b3}},7,"F-H0-14454",825,3},
  {{{0x15fac5e9a8b4f4ba}},6,"F-H0-14455",506,2},
  {{{0x873a3b1e1105a711}},13,"F-H0-14456",947,5},
  {{{0xe1160948a9f20e81}},8,"F-H0-14457",862,2},
  {{{0xed2b11f2e5dcd867}},8,"F-H0-14458",904,2},
  {{{0xc806e6d0511e4f1a}},17,"F-H0-14459",874,3},
  {{{0x34d5ed7d522f8d70}},11,"F-H0-14460",914,2},
  {{{0x1ccc2f1a9abe2ef8}},9,"F-H0-14461",873,5},
  {{{0x3c2825c487fae68e}},8,"F-H0-14462",946,3},
  {{{0x9456335b79c4b6cc}},7,"F-H0-14463",826,4},
  {{{0x9a7675a858927c5c}},7,"F-H0-14464",936,3},
  {{{0x418cf9b2a32bbcc9}},9,"F-H0-14465",950,2},
  {{{0x4a8c97a948b97d6a}},11,"F-H0-14466",579,2},
  {{{0x276fdc7830c68272}},8,"F-H0-14467",455,5},
  {{{0x325c675d20d9d723}},12,"F-H0-14468",825,2},
  {{{0x7dd0f57c2fcc451c}},11,"F-H0-14469",905,5},
  {{{0x9fd27608654236ea}},5,"F-H0-14470",937,3},
  {{{0x32e58daf64e092bc}},6,"F-H0-14471",494,5},
  {{{0x17339f5418c4efb2}},9,"F-H0-14472",455,5},
  {{{0xcc8231d51b3716b7}},10,"F-H0-14473",902,2},
  {{{0xcc8231d51b3716b7}},10,"F-H0-14474",938,2},
  {{{0x83f6ba0df661a4be}},10,"F-H0-14475",459,2},
  {{{0xe619f152538db08e}},7,"F-H0-14476",690,3},
  {{{0x890588b3524b9bd5}},4,"F-H0-14477",468,2},
  {{{0xf33e6c568bec30a9}},7,"F-H0-14478",531,3},
  {{{0xc7883837b8a4c92a}},5,"F-H0-14479",825,2},
  {{{0x4872eff5213957b0}},14,"F-H0-14480",985,5},
  {{{0x14cb306d4a8dfcdd}},8,"F-H0-14481",951,5},
  {{{0x59f9e02792df43c3}},4,"F-H0-14482",429,2},
  {{{0x59f9e02792df43c3}},4,"F-H0-14483",456,2},
  {{{0xaeca4c5120130871}},9,"F-H0-14484",876,4},
  {{{0x881e40949f00ae6d}},15,"F-H0-14485",947,5},
  {{{0xab88e7f0e1c8ccbd}},8,"F-H0-14486",838,3},
  {{{0x3ddde7ef2d3f3b51}},4,"F-H0-14487",911,3},
  {{{0xe05203a0bb226308}},4,"F-H0-14488",419,2},
  {{{0xbe55809e9b1bd3d5}},9,"F-H0-14489",531,4},
  {{{0xd80ba6602087942e}},17,"F-H0-14490",910,4},
  {{{0x7a0b47c7c8401b5d}},7,"F-H0-14491",837,2},
  {{{0x2711a96354e0eb90}},6,"F-H0-14492",911,4},
  {{{0x35252644b888bd2b}},11,"F-H0-14493",947,2},
  {{{0x3d3af10fc070ff6d}},3,"F-H0-14494",865,2},
  {{{0x3d3af10fc070ff6d}},3,"F-H0-14495",828,2},
  {{{0xedd41abc84486981}},6,"F-H0-14496",941,2},
  {{{0xa29a8c237528c045}},8,"F-H0-14497",838,4},
  {{{0x206c20e660a671b7}},3,"F-H0-14498",902,2},
  {{{0xe1c28941abbe05cd}},10,"F-H0-14499",950,4},
  {{{0x14c3081c3ee7294e}},16,"F-H0-14500",877,4},
  {{{0x135c01d47ef636e0}},14,"F-H0-14501",950,3},
  {{{0x135c01d47ef636e0}},14,"F-H0-14502",983,2},
  {{{0x75c668554903cd25}},17,"F-H0-14503",874,5},
  {{{0xfe282ab7fbdcdffb}},9,"F-H0-14504",529,3},
  {{{0xcee7707ea4ecfd42}},9,"F-H0-14505",877,3},
  {{{0x44889258fc8e5149}},9,"F-H0-14506",380,2},
  {{{0x934b972951d31961}},16,"F-H0-14507",947,4},
  {{{0xb54c81bc81e5f3db}},10,"F-H0-14508",677,4},
  {{{0x4a2a06e806b72c2b}},9,"F-H0-14509",431,5},
  {{{0x91ade28a4ff167e1}},8,"F-H0-14510",909,3},
  {{{0x57a6b6982f83fc48}},8,"F-H0-14511",940,2},
  {{{0xb47d07668934b20}},11,"F-H0-14512",467,4},
  {{{0x3bc4296acb9acbe3}},7,"F-H0-14513",419,5},
  {{{0x74918a01c64c42d3}},17,"F-H0-14514",802,2},
  {{{0x6eb51f1eb0fc4685}},15,"F-H0-14515",988,5},
  {{{0x2282bb2b02494d96}},21,"F-H0-14516",458,2},
  {{{0x9b744e4db9b1f64f}},9,"F-H0-14517",727,5},
  {{{0x1a5a665a89790db4}},8,"F-H0-14518",946,2},
  {{{0x1a5a665a89790db4}},8,"F-H0-14519",800,2},
  {{{0x2aa14c9a326a939d}},10,"F-H0-14520",913,2},
  {{{0xb44f3797ca28e260}},5,"F-H0-14521",506,3},
  {{{0x75bf61ac2dc6bcf6}},16,"F-H0-14522",429,3},
  {{{0x27f2f2bfd0b697ac}},10,"F-H0-14523",826,3},
  {{{0x27f2f2bfd0b697ac}},10,"F-H0-14524",902,2},
  {{{0xac3ed2a2d77325de}},21,"F-H0-14525",908,5},
  {{{0x3bca0c16ac947111}},6,"F-H0-14526",946,4},
  {{{0xff4efb033eeba5d6}},10,"F-H0-14527",938,4},
  {{{0xbf9ab226f7ce167d}},3,"F-H0-14528",937,2},
  {{{0x6a56af8464e4af0d}},3,"F-H0-14529",418,2},
  {{{0xf9c70a118ec730d7}},6,"F-H0-14530",826,2},
  {{{0x7baa10ca14f9fe4c}},19,"F-H0-14531",801,3},
  {{{0xc0be7e6004f3d0dc}},6,"F-H0-14532",678,2},
  {{{0xc0be7e6004f3d0dc}},6,"F-H0-14533",457,2},
  {{{0xa761e4f575c6b017}},13,"F-H0-14534",507,4},
  {{{0x6d4c9a180dbe9742}},9,"F-H0-14535",898,4},
  {{{0xd99d6c4c0af426a4}},12,"F-H0-14536",529,3},
  {{{0x41b6370373150e56}},7,"F-H0-14537",566,2},
  {{{0x455dc9e987548305}},14,"F-H0-14538",493,2},
  {{{0x89f48a778f457e43}},6,"F-H0-14539",541,2},
  {{{0xda384d1fb81db096}},6,"F-H0-14540",936,2},
  {{{0x84407f6957bc06e3}},11,"F-H0-14541",910,2},
  {{{0x84407f6957bc06e3}},11,"F-H0-14542",939,2},
  {{{0x1022860456cc8188}},6,"F-H0-14543",418,4},
  {{{0x94021821cb62ad61}},9,"F-H0-14544",455,3},
  {{{0xc516e335449fd545}},7,"F-H0-14545",936,2},
  {{{0x75409a225198c73}},6,"F-H0-14546",902,2},
  {{{0x8fc6084240f64693}},8,"F-H0-14547",902,2},
  {{{0x3cdeffe206492159}},10,"F-H0-14548",974,5},
  {{{0x1413be3ba051185f}},20,"F-H0-14549",457,2},
  {{{0xdb1d2fe6de8543ee}},12,"F-H0-14550",913,4},
  {{{0xaf460dbad9a6c388}},8,"F-H0-14551",465,4},
  {{{0xf49b5cf60931af0d}},16,"F-H0-14552",470,3},
  {{{0x8434d443add27d06}},16,"F-H0-14553",421,2},
  {{{0x4f446bbf2d80da9d}},17,"F-H0-14554",839,2},
  {{{0x5478a017b535a8da}},9,"F-H0-14555",529,4},
  {{{0x32e0586abaa82541}},12,"F-H0-14556",947,4},
  {{{0x82afa879e016a536}},15,"F-H0-14557",824,2},
  {{{0x41fcb04f12aa2519}},8,"F-H0-14558",903,4},
  {{{0xf71d1d0992a3e690}},6,"F-H0-14559",394,2},
  {{{0x3ec7d770b6b7b975}},12,"F-H0-14560",642,3},
  {{{0x8e6de47049c12b3d}},9,"F-H0-14561",507,5},
  {{{0x50c07e883c641661}},6,"F-H0-14562",940,4},
  {{{0xe2d5327e224e0861}},10,"F-H0-14563",690,2},
  {{{0x1fa465d4aa752f6c}},5,"F-H0-14564",418,2},
  {{{0xbbc9c989a10a3bfd}},5,"F-H0-14565",837,2},
  {{{0x174e35c808c9dce9}},9,"F-H0-14566",949,4},
  {{{0x7a42fff16244e19e}},2,"F-H0-14567",419,2},
  {{{0xa1ab5403396fcb30}},7,"F-H0-14568",492,3},
  {{{0xcc23e4a92682e114}},17,"F-H0-14569",493,3},
  {{{0xff2b7eb174ce5551}},8,"F-H0-14570",504,4},
  {{{0x805d376246d28868}},8,"F-H0-14571",531,5},
  {{{0x857d6fcbfb324a83}},7,"F-H0-14572",492,2},
  {{{0x5ab1ebcd9624b9e7}},17,"F-H0-14573",839,3},
  {{{0x266baa05102223ff}},8,"F-H0-14574",462,3},
  {{{0x81cbe6f852ae123d}},10,"F-H0-14575",877,2},
  {{{0x81cbe6f852ae123d}},10,"F-H0-14576",912,2},
  {{{0x56a061a486358a1d}},17,"F-H0-14577",837,4},
  {{{0xfd1985215f0018ed}},7,"F-H0-14578",911,3},
  {{{0xfbadbfbadc487897}},9,"F-H0-14579",873,4},
  {{{0x9a256ead08f7496a}},6,"F-H0-14580",727,3},
  {{{0xbb0130bfeca40825}},5,"F-H0-14581",543,2},
  {{{0x6b7fba6b5f4f4783}},5,"F-H0-14582",466,2},
  {{{0xb5e086f1e9f59ec5}},5,"F-H0-14583",543,2},
  {{{0xede488eb712ab5e7}},13,"F-H0-14584",901,2},
  {{{0x672df507562ab2f}},11,"F-H0-14585",801,5},
  {{{0x66f40c9a64afab74}},8,"F-H0-14586",951,5},
  {{{0x209b962e1bcf78c6}},9,"F-H0-14587",909,5},
  {{{0xf53298cded89a3e4}},10,"F-H0-14588",459,3},
  {{{0x7f634af1303e1364}},5,"F-H0-14589",543,3},
  {{{0x362bb9c1e2319941}},11,"F-H0-14590",909,5},
  {{{0x62dbb30303138c73}},10,"F-H0-14591",936,4},
  {{{0x508324a197d3421d}},15,"F-H0-14592",528,3},
  {{{0x2c35cb903861e37d}},16,"F-H0-14593",947,2},
  {{{0xb9c954c03f2945ae}},9,"F-H0-14594",466,2},
  {{{0xb9c954c03f2945ae}},9,"F-H0-14595",429,2},
  {{{0xfdd984f611013230}},16,"F-H0-14596",428,4},
  {{{0x622b6516c2fc9c00}},5,"F-H0-14597",825,3},
  {{{0xac19d4dc8757bd76}},7,"F-H0-14598",939,3},
  {{{0x280a0bb8322d1b40}},7,"F-H0-14599",946,2},
  {{{0xd38b3e2fd7a597a3}},12,"F-H0-14600",531,4},
  {{{0xddc17b024bed1eaf}},3,"F-H0-14601",900,2},
  {{{0x6e4365de519dd58c}},7,"F-H0-14602",462,2},
  {{{0x89c532441893f1de}},16,"F-H0-14603",945,4},
  {{{0x1529a2569978f000}},11,"F-H0-14604",604,4},
  {{{0x72f2972ac184ab54}},12,"F-H0-14605",466,3},
  {{{0xb77b4fb59bd63750}},12,"F-H0-14606",826,2},
  {{{0x8a3ff5e077d4990c}},11,"F-H0-14607",950,5},
  {{{0x426ac1b653937c42}},6,"F-H0-14608",765,4},
  {{{0xf0113761b49aedf2}},14,"F-H0-14609",875,4},
  {{{0x5db25d78453b1307}},9,"F-H0-14610",936,2},
  {{{0x5db25d78453b1307}},9,"F-H0-14611",827,2},
  {{{0x9e9e626f658b1d0f}},7,"F-H0-14612",910,5},
  {{{0xfcfc064ecc1aab38}},9,"F-H0-14613",873,2},
  {{{0xfcfc064ecc1aab38}},9,"F-H0-14614",912,2},
  {{{0x3d0eb44c92f33fb6}},8,"F-H0-14615",837,4},
  {{{0xaabbe345afaeb45b}},6,"F-H0-14616",529,2},
  {{{0xf2eed4a06bba3aa9}},6,"F-H0-14617",825,2},
  {{{0xc2606b8e50381d78}},7,"F-H0-14618",912,4},
  {{{0x8e508a6e87b2302b}},4,"F-H0-14619",900,4},
  {{{0x2b2f6dc4ee04d297}},13,"F-H0-14620",428,2},
  {{{0xd9cac1d7a2226864}},7,"F-H0-14621",542,5},
  {{{0x12e04cee0134fbcc}},8,"F-H0-14622",838,2},
  {{{0x12e04cee0134fbcc}},8,"F-H0-14623",945,2},
  {{{0x1e946984f5714210}},8,"F-H0-14624",949,5},
  {{{0xb66bba0c5dfbee8f}},4,"F-H0-14625",939,3},
  {{{0xba1c7bffba198855}},14,"F-H0-14626",909,5},
  {{{0x558021cf830bd3c8}},7,"F-H0-14627",910,2},
  {{{0x2e88aeda21da844e}},7,"F-H0-14628",947,2},
  {{{0xaaaf81e3d541d9ce}},6,"F-H0-14629",912,2},
  {{{0x8de781ed5e6a8e82}},7,"F-H0-14630",946,5},
  {{{0xa4c1cba3e4296b96}},7,"F-H0-14631",567,3},
  {{{0xfb548cd2c33e71b9}},5,"F-H0-14632",943,4},
  {{{0x37fb9381ce6cac6b}},6,"F-H0-14633",874,3},
  {{{0x788ab0a8d6aec110}},6,"F-H0-14634",826,2},
  {{{0xa68abfe30dc9cb28}},5,"F-H0-14635",432,3},
  {{{0x38379c6b6ee91f00}},4,"F-H0-14636",492,2},
  {{{0x99d467373f373cf9}},4,"F-H0-14637",862,5},
  {{{0xcec61cf0ba79ac61}},6,"F-H0-14638",420,2},
  {{{0x96324d83bf13a1a8}},5,"F-H0-14639",950,2},
  {{{0x9946217254097863}},13,"F-H0-14640",505,5},
  {{{0xa362d37ee3d55ecd}},10,"F-H0-14641",715,2},
  {{{0x266830115ebccf29}},10,"F-H0-14642",950,2},
  {{{0xe40836ade46a1c83}},8,"F-H0-14643",542,4},
  {{{0xb2e5935037ab0147}},10,"F-H0-14644",456,4},
  {{{0xd77755e2c6059ab1}},6,"F-H0-14645",906,2},
  {{{0x21f77ceb4652f71f}},20,"F-H0-14646",910,4},
  {{{0xa088cbdbe66def8b}},6,"F-H0-14647",873,3},
  {{{0xb447e420908d1707}},6,"F-H0-14648",418,2},
  {{{0x41c1b8cdb2bfaeb8}},9,"F-H0-14649",469,5},
  {{{0x54fcada3f55d89a9}},5,"F-H0-14650",943,3},
  {{{0x4da640c7e246f0c4}},8,"F-H0-14651",579,3},
  {{{0x4da640c7e246f0c4}},8,"F-H0-14652",432,2},
  {{{0x7f209b2e4a06a076}},3,"F-H0-14653",458,2},
  {{{0x540bcb102d197612}},8,"F-H0-14654",640,2},
  {{{0xdbda8692dc7844d0}},7,"F-H0-14655",900,3},
  {{{0x72fdf0a51aad8d5e}},5,"F-H0-14656",764,3},
  {{{0x566fb026184c63c0}},13,"F-H0-14657",948,5},
  {{{0x3969cbfed4158719}},10,"F-H0-14658",800,3},
  {{{0xc649b5dab3a93f87}},8,"F-H0-14659",543,2},
  {{{0xede7206f6bc437cd}},11,"F-H0-14660",826,3},
  {{{0xe3cc4a6456c31849}},11,"F-H0-14661",544,2},
  {{{0x1dc9bc9b6e9f6a6d}},5,"F-H0-14662",541,3},
  {{{0x955792a4e244b2d9}},9,"F-H0-14663",876,3},
  {{{0x4d81f6a02077a979}},10,"F-H0-14664",531,2},
  {{{0xb8885ddcba0e7cbc}},11,"F-H0-14665",938,2},
  {{{0xb75b13b8b06d9bdb}},11,"F-H0-14666",684,2},
  {{{0xb75b13b8b06d9bdb}},11,"F-H0-14667",466,2},
  {{{0x1eac51c5a25830bb}},4,"F-H0-14668",911,2},
  {{{0x719aedb1fb17eafd}},7,"F-H0-14669",530,3},
  {{{0x71f8bc5e912e0a7}},7,"F-H0-14670",503,2},
  {{{0x19cd59edbb88efe4}},6,"F-H0-14671",906,2},
  {{{0xf6cc07e192471300}},6,"F-H0-14672",457,2},
  {{{0xaeece87b6cf21d20}},18,"F-H0-14673",902,2},
  {{{0xaeece87b6cf21d20}},18,"F-H0-14674",715,2},
  {{{0xb9b8565d3339f203}},8,"F-H0-14675",912,5},
  {{{0x79ab18d815313ff7}},18,"F-H0-14676",801,4},
  {{{0xd0393c6540f494f}},9,"F-H0-14677",936,3},
  {{{0xefb9cd362e40452}},7,"F-H0-14678",949,2},
  {{{0xefb9cd362e40452}},7,"F-H0-14679",825,2},
  {{{0x9368eef902cf15ea}},15,"F-H0-14680",457,2},
  {{{0xe6fd0e3bc04bf656}},10,"F-H0-14681",503,3},
  {{{0x64f052964d5dfc7d}},15,"F-H0-14682",986,4},
  {{{0xfc566c8548b7f5b6}},7,"F-H0-14683",939,3},
  {{{0x20dfb02a41043120}},14,"F-H0-14684",862,2},
  {{{0x4901a6e0e5197c4e}},6,"F-H0-14685",910,5},
  {{{0xe322d48ba87bec48}},9,"F-H0-14686",432,3},
  {{{0xfb59c331733dd3e6}},9,"F-H0-14687",492,2},
  {{{0xf5584cdfd36bd108}},19,"F-H0-14688",909,5},
  {{{0x89614e223420b54f}},9,"F-H0-14689",462,2},
  {{{0x3b8470cc34e9f871}},20,"F-H0-14690",876,4},
  {{{0xbf3358d720ecfb8c}},11,"F-H0-14691",542,4},
  {{{0xc91fcf73f2f67865}},6,"F-H0-14692",941,2},
  {{{0x19357d795e91097e}},8,"F-H0-14693",419,2},
  {{{0x4a9d8a0708756cc3}},6,"F-H0-14694",468,3},
  {{{0xbfbb6c8e9c1d9950}},15,"F-H0-14695",871,3},
  {{{0x62574c3648e9b3d2}},15,"F-H0-14696",419,2},
  {{{0x410817638c2519dd}},7,"F-H0-14697",542,4},
  {{{0xbbed78fcfabbb2d9}},10,"F-H0-14698",423,4},
  {{{0x85ac1b94bfe86be4}},12,"F-H0-14699",873,4},
  {{{0x5230a5df598aa14a}},8,"F-H0-14700",905,3},
  {{{0x4e37e32c6cb25b16}},6,"F-H0-14701",567,3},
  {{{0x3b91b14f62f60d42}},8,"F-H0-14702",874,5},
  {{{0x2800d8af636b2541}},12,"F-H0-14703",938,4},
  {{{0x765fef426fd3efa4}},13,"F-H0-14704",945,2},
  {{{0xc8b144662c85ef57}},5,"F-H0-14705",580,3},
  {{{0xfdc8da1ee54d226a}},5,"F-H0-14706",948,2},
  {{{0x1a8fb26583c2f268}},6,"F-H0-14707",425,2},
  {{{0xe7aa746227c1593e}},6,"F-H0-14708",603,2},
  {{{0x141689d5e4a7817f}},10,"F-H0-14709",947,2},
  {{{0xb0b85d5dc37d49d5}},8,"F-H0-14710",678,3},
  {{{0x583de7e005b5f101}},8,"F-H0-14711",382,2},
  {{{0x100f088a682c910f}},3,"F-H0-14712",863,2},
  {{{0xa5a3443f5a26f296}},3,"F-H0-14713",467,2},
  {{{0xf3d455b5aa6dcef4}},15,"F-H0-14714",942,2},
  {{{0x28e43336a190a1ac}},8,"F-H0-14715",837,5},
  {{{0xb917f44c760c9d4b}},10,"F-H0-14716",979,2},
  {{{0xdbf940a7de9e64c9}},9,"F-H0-14717",943,2},
  {{{0xdbf940a7de9e64c9}},9,"F-H0-14718",949,2},
  {{{0xd813c979078d57a4}},11,"F-H0-14719",865,2},
  {{{0x2cf142fa26dd8b3}},9,"F-H0-14720",912,5},
  {{{0x6c0d7afe1b59e01c}},9,"F-H0-14721",494,3},
  {{{0xf950f7b8cbfd734f}},9,"F-H0-14722",900,2},
  {{{0xa0db3053c6c5e5af}},8,"F-H0-14723",454,3},
  {{{0x5a843c03af91da4c}},7,"F-H0-14724",944,2},
  {{{0x1a2b24eb22a45d15}},6,"F-H0-14725",789,4},
  {{{0x98cf16bb7685ee08}},8,"F-H0-14726",691,2},
  {{{0x9c73d0ab8cdfdd5c}},9,"F-H0-14727",382,3},
  {{{0x14249822df0f5fd4}},11,"F-H0-14728",603,3},
  {{{0x847caa5e0e1f67ae}},11,"F-H0-14729",944,2},
  {{{0xab4cfa9bcf1d72c3}},8,"F-H0-14730",800,4},
  {{{0x324f8fa81da36f42}},11,"F-H0-14731",898,5},
  {{{0x851d8ea46e35176e}},5,"F-H0-14732",455,5},
  {{{0x542eb079878e7f37}},10,"F-H0-14733",875,4},
  {{{0x6f99614bf6617711}},14,"F-H0-14734",801,5},
  {{{0x3687903d08362c40}},10,"F-H0-14735",912,4},
  {{{0xdd5bedd49732c7a9}},9,"F-H0-14736",862,5},
  {{{0xe182345f419273cd}},12,"F-H0-14737",799,2},
  {{{0x1e7c88b1ec78d830}},22,"F-H0-14738",728,2},
  {{{0x7728e854257c5a7e}},16,"F-H0-14739",876,5},
  {{{0x348dec234c69ba17}},9,"F-H0-14740",940,3},
  {{{0x6e9340318b2ebfdf}},9,"F-H0-14741",914,2},
  {{{0xe0da3d00e72498ad}},7,"F-H0-14742",566,4},
  {{{0x2e8f80a8bfb658cf}},11,"F-H0-14743",429,3},
  {{{0x45eb22d806545e90}},6,"F-H0-14744",875,3},
  {{{0x387978ef05ab10c8}},6,"F-H0-14745",752,2},
  {{{0x142d567963180c90}},11,"F-H0-14746",898,3},
  {{{0xe3f47dd9a4426b96}},9,"F-H0-14747",949,4},
  {{{0x1d58a2d1be420012}},12,"F-H0-14748",977,5},
  {{{0x822f304a22a61e9}},10,"F-H0-14749",426,4},
  {{{0x75bbc7332745e73d}},9,"F-H0-14750",936,2},
  {{{0xf435ea66a3b46c56}},9,"F-H0-14751",949,4},
  {{{0x785e92eeadcae3fd}},11,"F-H0-14752",423,4},
  {{{0x50110c001b611a81}},10,"F-H0-14753",950,4},
  {{{0x8a44c233284f6344}},7,"F-H0-14754",939,2},
  {{{0x268ad04022d92b28}},6,"F-H0-14755",455,2},
  {{{0x67a1d59eff7a4b12}},6,"F-H0-14756",466,4},
  {{{0x5973fa3951119fce}},8,"F-H0-14757",873,2},
  {{{0x85690aa6a31f411a}},12,"F-H0-14758",431,3},
  {{{0x85690aa6a31f411a}},12,"F-H0-14759",580,2},
  {{{0x40a858ec8517b82f}},11,"F-H0-14760",901,3},
  {{{0x3584b75e16254432}},8,"F-H0-14761",826,5},
  {{{0x1b490fc5d2bf2603}},7,"F-H0-14762",950,2},
  {{{0x796fb349f31fe683}},10,"F-H0-14763",986,2},
  {{{0x90bf948fabcc8137}},10,"F-H0-14764",506,2},
  {{{0xe9fdc0ad92011002}},8,"F-H0-14765",910,5},
  {{{0x1feabf8144e002ea}},6,"F-H0-14766",567,2},
  {{{0x1520c26a40a5eb6d}},10,"F-H0-14767",949,5},
  {{{0x5c2dd8865950e518}},9,"F-H0-14768",943,2},
  {{{0xae251f6cc6b84a89}},5,"F-H0-14769",457,3},
  {{{0xae251f6cc6b84a89}},5,"F-H0-14770",419,2},
  {{{0x911133497b2a3bd4}},4,"F-H0-14771",505,2},
  {{{0xb5d925b0aeff32ed}},4,"F-H0-14772",789,2},
  {{{0xc0d353151cee4daa}},9,"F-H0-14773",939,2},
  {{{0xc0d353151cee4daa}},9,"F-H0-14774",566,2},
  {{{0x23c0efe61a58f4a1}},13,"F-H0-14775",461,2},
  {{{0x7c43743b829ab295}},6,"F-H0-14776",899,3},
  {{{0xf949e73a49234e9f}},13,"F-H0-14777",935,5},
  {{{0x342b8567a24bb7c}},10,"F-H0-14778",936,5},
  {{{0x1a326123fd3f60f1}},12,"F-H0-14779",425,3},
  {{{0xa91d84fa90a04271}},7,"F-H0-14780",468,3},
  {{{0x9a26bf1a32982a38}},9,"F-H0-14781",946,4},
  {{{0xe67b15d49e928545}},7,"F-H0-14782",466,3},
  {{{0x1d28051ad1fac47}},5,"F-H0-14783",943,4},
  {{{0xee4c4adfd541c3d}},15,"F-H0-14784",863,2},
  {{{0xee4c4adfd541c3d}},15,"F-H0-14785",862,2},
  {{{0xdcefdf6cd5874e65}},11,"F-H0-14786",677,2},
  {{{0xfbc87829b6e116b7}},7,"F-H0-14787",875,2},
  {{{0xf3a19cdb77ab8ebf}},4,"F-H0-14788",950,3},
  {{{0xf3a19cdb77ab8ebf}},4,"F-H0-14789",468,2},
  {{{0xf1b23fbe4556b48d}},9,"F-H0-14790",616,2},
  {{{0xfe0623c0f74554c4}},9,"F-H0-14791",911,2},
  {{{0x1be46b29312142bb}},14,"F-H0-14792",617,2},
  {{{0x8b9ed62d5164f059}},9,"F-H0-14793",947,5},
  {{{0xc9e82ddd2e10976f}},19,"F-H0-14794",565,5},
  {{{0x60f3eafdd902ca8f}},8,"F-H0-14795",455,5},
  {{{0x37d0e6ab9d25c37e}},7,"F-H0-14796",678,4},
  {{{0x6e4cda89cf6b700e}},11,"F-H0-14797",714,4},
  {{{0x9924ce667886c33a}},13,"F-H0-14798",863,4},
  {{{0x63518d11c8687554}},13,"F-H0-14799",936,2},
  {{{0xc23f5f35146147aa}},10,"F-H0-14800",913,5},
  {{{0xa3573b147fe41c7e}},8,"F-H0-14801",529,2},
  {{{0xf17dd1303aebf810}},8,"F-H0-14802",684,2},
  {{{0xf1d1f7378a84d66d}},1,"F-H0-14803",468,2},
  {{{0xb57856c182c64f78}},7,"F-H0-14804",901,2},
  {{{0xcfc9a6eceb60d5b8}},11,"F-H0-14805",901,4},
  {{{0x9819713a72a34f70}},5,"F-H0-14806",911,2},
  {{{0x9819713a72a34f70}},5,"F-H0-14807",948,2},
  {{{0xf2a88023e0d641ad}},13,"F-H0-14808",944,2},
  {{{0x77d7342a65af2c0f}},9,"F-H0-14809",458,2},
  {{{0x16c72a10bc112ce}},6,"F-H0-14810",432,4},
  {{{0xc7ac1606729203c6}},15,"F-H0-14811",943,4},
  {{{0xe891336c07549796}},10,"F-H0-14812",910,4},
  {{{0x270d192d4a9f4a3f}},7,"F-H0-14813",801,2},
  {{{0xf055c8f23886f1a9}},7,"F-H0-14814",530,2},
  {{{0xfb52e146565f0006}},10,"F-H0-14815",947,2},
  {{{0x30e9f3aed3f9e9e0}},7,"F-H0-14816",494,3},
  {{{0x507b70e2bf1f719b}},15,"F-H0-14817",466,3},
  {{{0x507b70e2bf1f719b}},15,"F-H0-14818",690,2},
  {{{0xee474c94b08051ad}},8,"F-H0-14819",615,3},
  {{{0x6fa44a3417d1e9}},9,"F-H0-14820",432,5},
  {{{0x3e78e401eb3f5536}},11,"F-H0-14821",944,4},
  {{{0xbc28ca49c22e4cf5}},17,"F-H0-14822",943,2},
  {{{0xe89864262a14b6f1}},9,"F-H0-14823",837,3},
  {{{0x95c505e850fe3657}},18,"F-H0-14824",984,5},
  {{{0x252750a02fc767ea}},8,"F-H0-14825",764,4},
  {{{0xa1d35b19b8e9b5a6}},8,"F-H0-14826",470,4},
  {{{0x220878ec92de2f30}},9,"F-H0-14827",865,5},
  {{{0x5b6a818d475660f8}},5,"F-H0-14828",863,5},
  {{{0x65283cbe9467d2eb}},7,"F-H0-14829",458,4},
  {{{0x25e8e8faf212390c}},6,"F-H0-14830",863,2},
  {{{0x585c35e9761f8715}},3,"F-H0-14831",948,2},
  {{{0xd49626007ab8ce03}},9,"F-H0-14832",419,3},
  {{{0x80a25fedc895ceda}},6,"F-H0-14833",467,2},
  {{{0x524473aa57be482}},13,"F-H0-14834",837,2},
  {{{0x38550d46e3f509c5}},6,"F-H0-14835",976,3},
  {{{0x8531aa74c589f874}},4,"F-H0-14836",492,2},
  {{{0x9893a627e4dfaa3b}},10,"F-H0-14837",837,4},
  {{{0x878f3a55f9182fad}},6,"F-H0-14838",913,3},
  {{{0x4d167a79f83cb014}},6,"F-H0-14839",973,2},
  {{{0xf653a630d72cec6d}},7,"F-H0-14840",939,3},
  {{{0xb4cd212713722df7}},7,"F-H0-14841",493,2},
  {{{0x24045b6feb42d19a}},4,"F-H0-14842",543,3},
  {{{0x2c63fecfe4b0c81e}},13,"F-H0-14843",492,3},
  {{{0x945b5b15c2c289ba}},10,"F-H0-14844",976,3},
  {{{0x7085f5e367ad61c9}},6,"F-H0-14845",506,3},
  {{{0xd8804ade0754e8c4}},6,"F-H0-14846",543,2},
  {{{0xae1a2815b3de0e42}},19,"F-H0-14847",839,5},
  {{{0xdfd6771d19f996bf}},11,"F-H0-14848",985,3},
  {{{0x3b9fc8bad37915fb}},6,"F-H0-14849",429,2},
  {{{0x47ce75543659117b}},6,"F-H0-14850",566,3},
  {{{0x1d9037a6d56313c1}},14,"F-H0-14851",691,5},
  {{{0x99334600e7e6963e}},14,"F-H0-14852",861,3},
  {{{0x74da6cf9af5b1f55}},13,"F-H0-14853",861,4},
  {{{0xdfff2c9dafdf5354}},7,"F-H0-14854",463,2},
  {{{0xed18405f578bb13e}},12,"F-H0-14855",862,5},
  {{{0xb87133f0d4f61167}},11,"F-H0-14856",942,3},
  {{{0xfd4480c0f3c61f2c}},13,"F-H0-14857",936,5},
  {{{0x110e4be315014082}},9,"F-H0-14858",839,2},
  {{{0xa6ad2364df4a65fa}},8,"F-H0-14859",752,2},
  {{{0xcb93c70bb26cd10a}},15,"F-H0-14860",836,2},
  {{{0x7317d63272844170}},9,"F-H0-14861",911,2},
  {{{0x4b20fd9fe98be387}},20,"F-H0-14862",529,2},
  {{{0x4b20fd9fe98be387}},20,"F-H0-14863",943,2},
  {{{0x92c67b225aa4d2}},8,"F-H0-14864",420,2},
  {{{0x92c67b225aa4d2}},8,"F-H0-14865",566,2},
  {{{0xeb178c1421e6390c}},9,"F-H0-14866",418,2},
  {{{0xeb178c1421e6390c}},9,"F-H0-14867",421,2},
  {{{0x81bb9ce3a998e19f}},10,"F-H0-14868",907,3},
  {{{0x9223e4ccbd631e4e}},7,"F-H0-14869",456,2},
  {{{0x9223e4ccbd631e4e}},7,"F-H0-14870",529,2},
  {{{0x65118abe266858db}},4,"F-H0-14871",543,2},
  {{{0xd15f1c34fd84110}},6,"F-H0-14872",421,3},
  {{{0x497ee313f804f041}},6,"F-H0-14873",468,2},
  {{{0x5496fcac150acdd5}},9,"F-H0-14874",839,2},
  {{{0x780062113de8e69a}},8,"F-H0-14875",543,2},
  {{{0xfbbda2930da33be5}},6,"F-H0-14876",421,4},
  {{{0x36d6e21938923155}},4,"F-H0-14877",913,3},
  {{{0xc312c6b74368af48}},14,"F-H0-14878",938,2},
  {{{0xda5c1501af487a}},11,"F-H0-14879",506,3},
  {{{0x536b53bcd60ab5ab}},4,"F-H0-14880",529,3},
  {{{0x996527eee7860521}},6,"F-H0-14881",950,2},
  {{{0xd22d463d2bb724f}},9,"F-H0-14882",431,2},
  {{{0x86a1053646d9ac7d}},9,"F-H0-14883",540,2},
  {{{0xf0193d734592601c}},10,"F-H0-14884",911,5},
  {{{0x1e3113ecda1f328c}},12,"F-H0-14885",910,5},
  {{{0x1a1c91ffce23eece}},19,"F-H0-14886",951,2},
  {{{0x304b8797c7b35014}},12,"F-H0-14887",874,2},
  {{{0x4df402d3ce0423c}},15,"F-H0-14888",946,4},
  {{{0x6be39e651680ad3c}},17,"F-H0-14889",987,5},
  {{{0xf7e5e4516ae5a1b7}},9,"F-H0-14890",543,5},
  {{{0xe9ff5bb9c5a07198}},7,"F-H0-14891",466,4},
  {{{0x8b214e667378c6cd}},21,"F-H0-14892",942,4},
  {{{0x7cf563ed48f6a8b}},7,"F-H0-14893",462,4},
  {{{0xb0685c41fd547572}},6,"F-H0-14894",567,2},
  {{{0x7ca869c93d82cc30}},4,"F-H0-14895",543,2},
  {{{0x702853aa3684b798}},10,"F-H0-14896",950,4},
  {{{0xaaa599feb1243d8c}},6,"F-H0-14897",910,4},
  {{{0xa66df0610f4f4470}},9,"F-H0-14898",678,3},
  {{{0x31039d3bff1bf8d4}},9,"F-H0-14899",914,2},
  {{{0x80af695bd2beb086}},9,"F-H0-14900",429,3},
  {{{0x244eef4c2305e760}},13,"F-H0-14901",580,4},
  {{{0xb7a703fc74dc63b7}},15,"F-H0-14902",418,2},
  {{{0x94e577043ef76ef4}},4,"F-H0-14903",426,2},
  {{{0x598eef77d1ccc632}},20,"F-H0-14904",543,2},
  {{{0x3ac5ff7164dc4ba1}},10,"F-H0-14905",910,5},
  {{{0x8b2b018fcac3d193}},4,"F-H0-14906",788,2},
  {{{0x734c1590c2006862}},5,"F-H0-14907",466,2},
  {{{0xa30d2d5deae1311d}},8,"F-H0-14908",789,2},
  {{{0xa30d2d5deae1311d}},8,"F-H0-14909",936,2},
  {{{0x47e0e7977dcd3dd6}},8,"F-H0-14910",568,2},
  {{{0x5b6fac4c1504326d}},8,"F-H0-14911",567,3},
  {{{0xa398aa6d71be1c52}},11,"F-H0-14912",986,4},
  {{{0x4192560bf2a9f7a6}},8,"F-H0-14913",429,4},
  {{{0xdf5b00ecd97a1722}},9,"F-H0-14914",467,4},
  {{{0x60ad0f3fad51cf18}},5,"F-H0-14915",456,3},
  {{{0x60ad0f3fad51cf18}},5,"F-H0-14916",455,2},
  {{{0x50e12df38eb03275}},6,"F-H0-14917",491,4},
  {{{0x1377f6494d87f32}},12,"F-H0-14918",905,2},
  {{{0xbb475aafdf7e45aa}},9,"F-H0-14919",464,4},
  {{{0x75eda0297a446917}},20,"F-H0-14920",988,5},
  {{{0x37eff027f83a453a}},7,"F-H0-14921",418,3},
  {{{0xbad5db2a44fa6141}},12,"F-H0-14922",871,2},
  {{{0x7baec4416a4e0f85}},12,"F-H0-14923",580,2},
  {{{0xfea6283243a93242}},7,"F-H0-14924",825,2},
  {{{0xfea6283243a93242}},7,"F-H0-14925",947,2},
  {{{0x2c37538a60b7cc9e}},8,"F-H0-14926",974,4},
  {{{0xe8e1e6efbf3acd57}},15,"F-H0-14927",950,2},
  {{{0xac2b88e3cd21992c}},19,"F-H0-14928",873,5},
  {{{0xa7d946416c80aa53}},9,"F-H0-14929",839,4},
  {{{0xcc8bd10965e10c5a}},6,"F-H0-14930",421,4},
  {{{0xb344a6c653b6f1b5}},15,"F-H0-14931",986,5},
  {{{0x76519ec3a21979a1}},13,"F-H0-14932",430,3},
  {{{0x20c73da89389b5a4}},13,"F-H0-14933",914,2},
  {{{0x746d5f12a0ec8805}},8,"F-H0-14934",505,3},
  {{{0xa763915d056c910a}},8,"F-H0-14935",529,2},
  {{{0x3b32144bd1785089}},8,"F-H0-14936",911,3},
  {{{0xa840db6813c716b9}},12,"F-H0-14937",838,4},
  {{{0xc14f824ea6193a8d}},6,"F-H0-14938",714,2},
  {{{0xfbf7e68f091f292b}},5,"F-H0-14939",466,4},
  {{{0xcae10c90bf3c8a5c}},18,"F-H0-14940",943,2},
  {{{0xda4e4f23769631f4}},6,"F-H0-14941",529,2},
  {{{0x2891e65db3526a01}},6,"F-H0-14942",492,2},
  {{{0x690938cd78db1f60}},6,"F-H0-14943",950,2},
  {{{0xfb83507272a5a1f8}},6,"F-H0-14944",909,2},
  {{{0xed0c19d1c570cd16}},9,"F-H0-14945",949,5},
  {{{0xfe019e48d0895097}},6,"F-H0-14946",948,2},
  {{{0x819327d1bf7f39ce}},15,"F-H0-14947",716,2},
  {{{0x337a0c433bcc1225}},10,"F-H0-14948",865,2},
  {{{0x5a28d96499a740c4}},10,"F-H0-14949",684,2},
  {{{0xd14cd830130da70e}},7,"F-H0-14950",460,3},
  {{{0xe51eeca89f96e112}},7,"F-H0-14951",458,4},
  {{{0x6d71f8c3ba54e09c}},8,"F-H0-14952",491,5},
  {{{0x8363a71d5e80c007}},13,"F-H0-14953",763,4},
  {{{0xabf77bc10fbcb4e2}},11,"F-H0-14954",836,2},
  {{{0xabf77bc10fbcb4e2}},11,"F-H0-14955",909,2},
  {{{0x46427ce5b14f51c}},11,"F-H0-14956",420,4},
  {{{0x41c527fb2721089e}},7,"F-H0-14957",902,3},
  {{{0x5cd80e3a93e2d25}},7,"F-H0-14958",429,2},
  {{{0xd8c4f8c0278262f7}},14,"F-H0-14959",876,2},
  {{{0xa674b21d256af408}},14,"F-H0-14960",421,2},
  {{{0x4cdea00d62c1ca76}},4,"F-H0-14961",505,2},
  {{{0x9de4cac4b659efa5}},6,"F-H0-14962",910,3},
  {{{0xb3dbea61d69ee04f}},9,"F-H0-14963",541,3},
  {{{0x17897a00f8ba64a2}},11,"F-H0-14964",430,2},
  {{{0x38c58d6837978141}},13,"F-H0-14965",948,2},
  {{{0x505b812df153299e}},13,"F-H0-14966",899,2},
  {{{0xbcb185ac9bed98c1}},8,"F-H0-14967",911,4},
  {{{0x32a29d2dc5ca4010}},10,"F-H0-14968",654,3},
  {{{0x44c53ea07e626b10}},7,"F-H0-14969",950,4},
  {{{0x7841e78ccfad36f2}},7,"F-H0-14970",543,3},
  {{{0xff8892a370f66f7a}},16,"F-H0-14971",902,2},
  {{{0xd07bf3ef0a3156c}},12,"F-H0-14972",837,4},
  {{{0xd4ce18ed04f9649}},19,"F-H0-14973",876,3},
  {{{0xa6884e0ad722cddc}},11,"F-H0-14974",873,2},
  {{{0x8c24b3c3ad9af3c0}},12,"F-H0-14975",684,2},
  {{{0xc0bff22183fbbaf9}},12,"F-H0-14976",421,4},
  {{{0x85c9e7b3bf8b1738}},7,"F-H0-14977",752,2},
  {{{0x3e7c12c7883d5696}},9,"F-H0-14978",529,2},
  {{{0xe57e77e087f1ec8d}},19,"F-H0-14979",871,3},
  {{{0x6705b585fece2383}},19,"F-H0-14980",943,3},
  {{{0x732e861c18186171}},8,"F-H0-14981",912,5},
  {{{0xa337cdf59439d8ff}},13,"F-H0-14982",825,2},
  {{{0x49a5026e65012c5a}},13,"F-H0-14983",947,2},
  {{{0x166526a0bc445d35}},17,"F-H0-14984",835,2},
  {{{0xf3b9764f868eb638}},17,"F-H0-14985",497,2},
  {{{0xdfbf9958d2cd0f33}},12,"F-H0-14986",939,4},
  {{{0x9a30ee2e40980901}},5,"F-H0-14987",936,2},
  {{{0x920a2ced7bd1ba9e}},12,"F-H0-14988",752,5},
  {{{0xa72d85f2c8626741}},13,"F-H0-14989",825,2},
  {{{0xf0fe07cb5a66692f}},17,"F-H0-14990",950,3},
  {{{0xda3b7d65f0df56c}},4,"F-H0-14991",468,3},
  {{{0xadb2575b55ae10a5}},4,"F-H0-14992",906,2},
  {{{0x2b3c6ad04c791899}},10,"F-H0-14993",876,4},
  {{{0x93b7600532d119d5}},8,"F-H0-14994",911,3},
  {{{0xc650cc023845fc3}},8,"F-H0-14995",949,2},
  {{{0x49677c9ca1fba403}},8,"F-H0-14996",492,4},
  {{{0x855d980adc15bd82}},7,"F-H0-14997",838,2},
  {{{0xcddd6703d671b911}},7,"F-H0-14998",603,2},
  {{{0x738b59b9e8990078}},10,"F-H0-14999",839,4},
  {{{0xf8c8d3585d860b95}},9,"F-H0-15000",913,5},
  {{{0xc32bc3b1d3ce7d10}},7,"F-H0-15001",836,2},
  {{{0xc32bc3b1d3ce7d10}},7,"F-H0-15002",909,2},
  {{{0xcf9501dea4f8a119}},7,"F-H0-15003",455,4},
  {{{0x2c6b5d2929d49b75}},12,"F-H0-15004",491,2},
  {{{0x97a1d254d9287e94}},9,"F-H0-15005",873,3},
  {{{0x97a1d254d9287e94}},9,"F-H0-15006",875,2},
  {{{0xcfc02717bafe7474}},8,"F-H0-15007",492,5},
  {{{0x483d78310e1f3021}},9,"F-H0-15008",421,3},
  {{{0x9a712b903d92ba71}},4,"F-H0-15009",467,2},
  {{{0xd7623bd9303cd0e7}},4,"F-H0-15010",901,2},
  {{{0x3df5378a7f9de648}},3,"F-H0-15011",466,2},
  {{{0xec92df38f01e5801}},11,"F-H0-15012",531,5},
  {{{0xafa9301958dfb23e}},7,"F-H0-15013",948,5},
  {{{0xf2e6d071c85318fa}},8,"F-H0-15014",874,2},
  {{{0xcc1acf20be037bde}},7,"F-H0-15015",566,2},
  {{{0xed12ae50210eebc8}},6,"F-H0-15016",837,2},
  {{{0xc0ef83290c4e023e}},3,"F-H0-15017",468,2},
  {{{0xe5df430a4d30e091}},4,"F-H0-15018",468,4},
  {{{0xeaf3e05ca4bf29be}},8,"F-H0-15019",381,5},
  {{{0x227d7b6167a3619c}},9,"F-H0-15020",615,3},
  {{{0xfc31fabf12e2199}},4,"F-H0-15021",911,3},
  {{{0x7658a2e14aac955c}},11,"F-H0-15022",936,3},
  {{{0xaa652a31ffe64622}},9,"F-H0-15023",418,3},
  {{{0xaa652a31ffe64622}},9,"F-H0-15024",459,2},
  {{{0xfb85ed955eeb6982}},15,"F-H0-15025",950,3},
  {{{0xa80baacb8471247}},3,"F-H0-15026",936,2},
  {{{0x504892cfdaef65bc}},3,"F-H0-15027",865,2},
  {{{0x306c162dc37df947}},9,"F-H0-15028",420,3},
  {{{0xe9bb6a9872bda15f}},9,"F-H0-15029",421,2},
  {{{0xb7a96cccfcb8cfd4}},17,"F-H0-15030",950,2},
  {{{0x1a3276df272ec8e8}},19,"F-H0-15031",1023,5},
  {{{0xfbf1208c44ebdf0a}},19,"F-H0-15032",944,2},
  {{{0x5b22cae0bf343ccf}},7,"F-H0-15033",426,3},
  {{{0x5b22cae0bf343ccf}},7,"F-H0-15034",863,2},
  {{{0x8ee31285e930ee1}},17,"F-H0-15035",984,4},
  {{{0x70ada1ec5ef8e8ab}},5,"F-H0-15036",431,2},
  {{{0xfefd5d45bac70859}},10,"F-H0-15037",458,2},
  {{{0x8657236a9207cd69}},10,"F-H0-15038",429,2},
  {{{0x52384b8ae137d5d9}},6,"F-H0-15039",874,3},
  {{{0xa3c82670f3834fdb}},8,"F-H0-15040",468,4},
  {{{0x1cd0a1e361216f4d}},10,"F-H0-15041",384,3},
  {{{0x4a258ac5e2d5c461}},10,"F-H0-15042",839,2},
  {{{0xdab494e622e1e7cf}},7,"F-H0-15043",653,2},
  {{{0xdab494e622e1e7cf}},7,"F-H0-15044",678,2},
  {{{0xfff1a4ff11592242}},10,"F-H0-15045",381,3},
  {{{0xbe4f618269790ee4}},4,"F-H0-15046",455,2},
  {{{0x63fa279199eecf24}},14,"F-H0-15047",796,3},
  {{{0x63fa279199eecf24}},14,"F-H0-15048",870,2},
  {{{0xf85e775b73feaabe}},6,"F-H0-15049",543,2},
  {{{0x9ead1c8dac27497f}},9,"F-H0-15050",457,2},
  {{{0x9ead1c8dac27497f}},9,"F-H0-15051",419,2},
  {{{0x61a7869a66c20f7d}},9,"F-H0-15052",424,2},
  {{{0x6932424a3f750fe}},5,"F-H0-15053",947,2},
  {{{0x3cf28f6862a5b125}},10,"F-H0-15054",458,2},
  {{{0xe6fff40a406161d7}},4,"F-H0-15055",455,2},
  {{{0xb74acdc91c367458}},4,"F-H0-15056",457,2},
  {{{0xb9c5d0003ca4bec3}},18,"F-H0-15057",876,4},
  {{{0x3b91476be4575b7f}},17,"F-H0-15058",950,2},
  {{{0x3b91476be4575b7f}},17,"F-H0-15059",728,2},
  {{{0x754d83953cc58524}},3,"F-H0-15060",418,5},
  {{{0x5492dbee42253221}},5,"F-H0-15061",466,4},
  {{{0xa28808c385a75cf8}},8,"F-H0-15062",837,5},
  {{{0x9b904ae379161dcf}},10,"F-H0-15063",876,4},
  {{{0xe7be73fad4fcb9aa}},16,"F-H0-15064",568,2},
  {{{0x28bc9a3aab7719dc}},6,"F-H0-15065",395,3},
  {{{0xd78d6533c8981ac3}},11,"F-H0-15066",985,5},
  {{{0xdf3e26be5185763a}},9,"F-H0-15067",863,5},
  {{{0x8c47253db1576670}},11,"F-H0-15068",939,3},
  {{{0x7942c71533605644}},9,"F-H0-15069",913,3},
  {{{0xb69b9eedd07c330c}},9,"F-H0-15070",469,2},
  {{{0xb6fa7972792f2373}},9,"F-H0-15071",974,3},
  {{{0xb6fa7972792f2373}},9,"F-H0-15072",911,2},
  {{{0xc23a873aac19e3d2}},6,"F-H0-15073",432,5},
  {{{0x2b65101db51a6e1e}},9,"F-H0-15074",569,3},
  {{{0x6038d1ff4f9c4051}},7,"F-H0-15075",529,3},
  {{{0x236ced705ab652e7}},7,"F-H0-15076",940,2},
  {{{0x86ae97ecb88176a}},4,"F-H0-15077",900,4},
  {{{0xb7612de65ed6b50e}},8,"F-H0-15078",529,2},
  {{{0xb7612de65ed6b50e}},8,"F-H0-15079",946,2},
  {{{0x9255546acd409a41}},9,"F-H0-15080",429,2},
  {{{0x9255546acd409a41}},9,"F-H0-15081",493,2},
  {{{0xb11342caecfb3f62}},18,"F-H0-15082",418,5},
  {{{0x59c13937f8e0e33}},10,"F-H0-15083",947,3},
  {{{0xe8496cbdc5218d88}},8,"F-H0-15084",986,3},
  {{{0x921ce23cb3c2d4e8}},13,"F-H0-15085",455,3},
  {{{0x1cba60a53a96853b}},8,"F-H0-15086",912,5},
  {{{0x3d72b91139b807b0}},9,"F-H0-15087",530,2},
  {{{0x3e3b679ca005f731}},18,"F-H0-15088",803,4},
  {{{0x3983f4896f1c91c6}},11,"F-H0-15089",529,4},
  {{{0x4ec0872fe73d9ca6}},7,"F-H0-15090",395,4},
  {{{0xd1a3a7cb3c274701}},21,"F-H0-15091",911,3},
  {{{0xdf5301f8f6c04bb1}},6,"F-H0-15092",542,3},
  {{{0x58307b5aeaee3775}},15,"F-H0-15093",986,4},
  {{{0xb0a23c050d59799a}},12,"F-H0-15094",419,4},
  {{{0xbf9591678c15fbd7}},10,"F-H0-15095",690,3},
  {{{0x8e9dcb641a1cb87d}},9,"F-H0-15096",541,4},
  {{{0x15262796c7a92c8e}},11,"F-H0-15097",902,3},
  {{{0x3656e9045ab22451}},8,"F-H0-15098",529,3},
  {{{0x3656e9045ab22451}},8,"F-H0-15099",764,2},
  {{{0xaac73306096dc41b}},6,"F-H0-15100",902,2},
  {{{0xf7a2097413532633}},6,"F-H0-15101",941,2},
  {{{0xe897c34429cc2617}},6,"F-H0-15102",541,2},
  {{{0xe897c34429cc2617}},6,"F-H0-15103",432,2},
  {{{0xec6062fd6278940b}},19,"F-H0-15104",912,5},
  {{{0x1f9b1f30c370fdeb}},10,"F-H0-15105",421,5},
  {{{0x2b1ba1f75d0529c8}},4,"F-H0-15106",911,4},
  {{{0x1cf98e48f94a42bb}},11,"F-H0-15107",943,2},
  {{{0x1cb95ac2391f41c7}},8,"F-H0-15108",911,4},
  {{{0xfee5bc78307120d}},7,"F-H0-15109",867,2},
  {{{0xc3324bcac7664f30}},9,"F-H0-15110",507,4},
  {{{0xc1556397135dd866}},16,"F-H0-15111",983,4},
  {{{0x695afa0c840fc9af}},11,"F-H0-15112",874,5},
  {{{0x3f9ea833ef25ea3d}},6,"F-H0-15113",910,2},
  {{{0x9362b6b2cda6ae7d}},11,"F-H0-15114",799,2},
  {{{0xe766e66b667e207a}},11,"F-H0-15115",715,2},
  {{{0xf3a594bff87f49e6}},2,"F-H0-15116",647,2},
  {{{0x9208e49fc15cdf17}},16,"F-H0-15117",617,4},
  {{{0x5f19b6aeddf933a5}},9,"F-H0-15118",899,5},
  {{{0xe041e509ef8b6792}},9,"F-H0-15119",913,5},
  {{{0xad326608e35283c7}},11,"F-H0-15120",825,2},
  {{{0x14ca8967628e7c27}},22,"F-H0-15121",910,3},
  {{{0x110368b090ad40da}},15,"F-H0-15122",839,4},
  {{{0xb0075892c15796cb}},19,"F-H0-15123",947,5},
  {{{0x694c4845dac9262d}},6,"F-H0-15124",801,2},
  {{{0x694c4845dac9262d}},6,"F-H0-15125",530,2},
  {{{0x836300b41a9d32b7}},6,"F-H0-15126",801,3},
  {{{0x6972b24d6f09f18f}},17,"F-H0-15127",830,2},
  {{{0x5bb049bdab4f5155}},7,"F-H0-15128",432,3},
  {{{0x5bb049bdab4f5155}},7,"F-H0-15129",825,2},
  {{{0x98e895b65288a8e8}},9,"F-H0-15130",421,3},
  {{{0xbeb291e534fef92a}},15,"F-H0-15131",542,2},
  {{{0x430e224b85422082}},7,"F-H0-15132",950,3},
  {{{0xae4ff0b82a968697}},7,"F-H0-15133",458,2},
  {{{0x7fdbcdee830b5887}},10,"F-H0-15134",392,3},
  {{{0xdf10a7a96beeb685}},11,"F-H0-15135",567,2},
  {{{0xc58c5b90eb16a7e2}},8,"F-H0-15136",727,3},
  {{{0xa6be6d5541578321}},17,"F-H0-15137",939,2},
  {{{0xfdf4c16aab8ef291}},7,"F-H0-15138",542,4},
  {{{0x5a28d01cf367caaf}},8,"F-H0-15139",455,5},
  {{{0x2954ba3f4b286d82}},14,"F-H0-15140",421,2},
  {{{0x5083e174f5d715f0}},10,"F-H0-15141",973,3},
  {{{0x5fe62b04b45635e9}},7,"F-H0-15142",678,3},
  {{{0xe960d84784af2475}},7,"F-H0-15143",974,2},
  {{{0xa12229b4729c8043}},16,"F-H0-15144",826,5},
  {{{0x9a5c61f27064edde}},12,"F-H0-15145",836,2},
  {{{0x9f69a1da502434e3}},12,"F-H0-15146",418,2},
  {{{0xeda40daa89a09ad}},7,"F-H0-15147",898,2},
  {{{0x38c894615a5984f9}},4,"F-H0-15148",788,4},
  {{{0x6b655fb74d9b5a11}},9,"F-H0-15149",456,5},
  {{{0xd86b650ece77187b}},8,"F-H0-15150",862,3},
  {{{0x8582405161bad686}},7,"F-H0-15151",419,5},
  {{{0x97c0720e30fbf58}},7,"F-H0-15152",911,2},
  {{{0x30ea9ccd6b76433a}},6,"F-H0-15153",837,2},
  {{{0xef3f0c3f24483290}},6,"F-H0-15154",876,5},
  {{{0x2dc912afda1628bd}},6,"F-H0-15155",948,5},
  {{{0x70c39343f21eb8a1}},7,"F-H0-15156",542,2},
  {{{0x3631df5326713330}},8,"F-H0-15157",949,3},
  {{{0x660e25d33b657b07}},5,"F-H0-15158",947,2},
  {{{0x20b42d84678f57d6}},3,"F-H0-15159",912,2},
  {{{0x6ef9bbac879f5042}},3,"F-H0-15160",455,2},
  {{{0xd106640a0d63d5be}},11,"F-H0-15161",543,5},
  {{{0xe854e15c34027cc6}},6,"F-H0-15162",462,2},
  {{{0x2626b005a9753be6}},23,"F-H0-15163",948,5},
  {{{0xe89505a65ac46f96}},9,"F-H0-15164",506,2},
  {{{0x8928f792027e24cc}},15,"F-H0-15165",987,4},
  {{{0x514cbbb924b46525}},7,"F-H0-15166",432,4},
  {{{0xabc9b110cedaf703}},7,"F-H0-15167",458,2},
  {{{0x31ec8170b53fd441}},3,"F-H0-15168",912,4},
  {{{0x2bd3e486baea6ed1}},22,"F-H0-15169",984,5},
  {{{0x5a04f942f8087c22}},14,"F-H0-15170",899,2},
  {{{0xc5c2d290d5d9b248}},6,"F-H0-15171",874,3},
  {{{0xbd9e9327677b8f8a}},9,"F-H0-15172",948,3},
  {{{0xbd9e9327677b8f8a}},9,"F-H0-15173",950,2},
  {{{0x9bb618ce8d9a9a93}},10,"F-H0-15174",947,2},
  {{{0x53866a9d8fe17bc7}},10,"F-H0-15175",384,2},
  {{{0x21e9996d7bc9a64}},18,"F-H0-15176",876,3},
  {{{0xe080c0e2390ef05d}},10,"F-H0-15177",907,4},
  {{{0x61b7710295d50eac}},11,"F-H0-15178",948,2},
  {{{0x626e2c483f7b25f2}},8,"F-H0-15179",875,5},
  {{{0xba3e34ad0f98efd3}},9,"F-H0-15180",936,2},
  {{{0x323f6934bce39d49}},9,"F-H0-15181",939,2},
  {{{0x6ab6e72c33423454}},14,"F-H0-15182",495,4},
  {{{0x22fd8e68f87bb3a9}},8,"F-H0-15183",432,3},
  {{{0x50c4484cdd0c140d}},8,"F-H0-15184",947,5},
  {{{0x7668195ec52d88b5}},16,"F-H0-15185",825,2},
  {{{0xe9db0a144a3d5473}},22,"F-H0-15186",825,3},
  {{{0xe9db0a144a3d5473}},22,"F-H0-15187",826,2},
  {{{0xd950996d96c0ea27}},13,"F-H0-15188",914,3},
  {{{0x7a3d94638b1d06e8}},10,"F-H0-15189",432,4},
  {{{0x65f374edf95ebd0}},13,"F-H0-15190",910,2},
  {{{0x65f374edf95ebd0}},13,"F-H0-15191",911,2},
  {{{0xe388e91b24c37f52}},17,"F-H0-15192",936,2},
  {{{0x7e241c50005055d}},17,"F-H0-15193",837,2},
  {{{0xce2a8b5a0a86c3aa}},8,"F-H0-15194",678,4},
  {{{0x56036c7aa60dc9a9}},8,"F-H0-15195",946,3},
  {{{0xe21ca81bfa3fce15}},5,"F-H0-15196",505,2},
  {{{0x20a0102d966a780b}},5,"F-H0-15197",837,4},
  {{{0x85b5d63495c9c26c}},10,"F-H0-15198",457,5},
  {{{0xd3b3bf89d131d96d}},7,"F-H0-15199",938,2},
  {{{0xe774f0c8445e025f}},10,"F-H0-15200",531,3},
  {{{0xb7c05bce05f16f15}},6,"F-H0-15201",947,3},
  {{{0xa0d21a12c51c7a1c}},7,"F-H0-15202",875,5},
  {{{0xefa092f55fc107ab}},8,"F-H0-15203",421,2},
  {{{0xefa092f55fc107ab}},8,"F-H0-15204",690,2},
  {{{0xaf482a053c4749b3}},6,"F-H0-15205",973,4},
  {{{0x3c1504498de48578}},9,"F-H0-15206",947,4},
  {{{0x49c6f349e7544b24}},11,"F-H0-15207",938,3},
  {{{0x46c8727b14abe927}},8,"F-H0-15208",543,4},
  {{{0xae80c900800e8d51}},10,"F-H0-15209",827,3},
  {{{0x90a243224236ec85}},11,"F-H0-15210",912,4},
  {{{0x70cf72d9ed8f1226}},17,"F-H0-15211",616,2},
  {{{0x9c8bbfc87f7b9612}},17,"F-H0-15212",937,2},
  {{{0xe2cd3412c0f537a4}},4,"F-H0-15213",469,2},
  {{{0xf03583ea1808a10a}},14,"F-H0-15214",911,4},
  {{{0xda73db2821fa38e4}},6,"F-H0-15215",837,3},
  {{{0xd538afaeaaf4149e}},7,"F-H0-15216",466,5},
  {{{0x6effde1b0ef0b49f}},7,"F-H0-15217",429,2},
  {{{0x6effde1b0ef0b49f}},7,"F-H0-15218",428,2},
  {{{0x15551c79167a4a97}},17,"F-H0-15219",827,3},
  {{{0x7ff4eb295b7f2b68}},17,"F-H0-15220",838,2},
  {{{0xefdd43bf433d9c92}},3,"F-H0-15221",949,5},
  {{{0x8350e39f3c963a03}},15,"F-H0-15222",392,2},
  {{{0x376cf0ab68d0ce5b}},7,"F-H0-15223",874,5},
  {{{0x6091371f0f9d83f8}},10,"F-H0-15224",678,5},
  {{{0x9c6903283e8ff56d}},6,"F-H0-15225",470,2},
  {{{0x9c6903283e8ff56d}},6,"F-H0-15226",690,2},
  {{{0x6a367c25f34913b1}},13,"F-H0-15227",691,3},
  {{{0x96ddcf184db16530}},12,"F-H0-15228",542,2},
  {{{0x9cdb9d8fcae6c5a4}},7,"F-H0-15229",899,5},
  {{{0x2588e2d40feacf29}},14,"F-H0-15230",421,2},
  {{{0xb0574c33a009491a}},14,"F-H0-15231",836,2},
  {{{0xb754ac884bf470dc}},5,"F-H0-15232",943,3},
  {{{0xb754ac884bf470dc}},5,"F-H0-15233",939,2},
  {{{0xfbd527cca00f78bd}},4,"F-H0-15234",431,3},
  {{{0xd0e56ef6d811ddc2}},4,"F-H0-15235",802,2},
  {{{0x699a274224a86ad8}},9,"F-H0-15236",945,3},
  {{{0x8d19234a0a2065f7}},11,"F-H0-15237",469,3},
  {{{0x71e8b4e0f1eb9523}},9,"F-H0-15238",678,2},
  {{{0x71e8b4e0f1eb9523}},9,"F-H0-15239",802,2},
  {{{0x1eb6bd6c99cdb243}},8,"F-H0-15240",903,4},
  {{{0x5eaa9de9d198217a}},14,"F-H0-15241",825,3},
  {{{0xba71b8e355f0f58f}},23,"F-H0-15242",382,4},
  {{{0x58a59d9326686c05}},18,"F-H0-15243",873,5},
  {{{0x3d0e42aa279f59a1}},6,"F-H0-15244",874,3},
  {{{0x1fe858fdb5fc0a3f}},20,"F-H0-15245",876,5},
  {{{0x409435d8e0dbaf4b}},20,"F-H0-15246",910,4},
  {{{0x45f000dc5d255a6b}},8,"F-H0-15247",949,4},
  {{{0x8ccf9fb9085370e5}},8,"F-H0-15248",543,4},
  {{{0x3e82c39ebe94710c}},5,"F-H0-15249",861,5},
  {{{0x5df10eb8aea857a7}},7,"F-H0-15250",678,2},
  {{{0x7e2f159b44e31148}},6,"F-H0-15251",837,3},
  {{{0x94b0c4c6c7dfdfa0}},10,"F-H0-15252",539,3},
  {{{0xf698f09bc40134b5}},6,"F-H0-15253",839,3},
  {{{0x2b0622601a99eb69}},9,"F-H0-15254",764,3},
  {{{0x5127b5ae4dba0293}},6,"F-H0-15255",826,2},
  {{{0xbd8bd8aaeb354034}},10,"F-H0-15256",986,5},
  {{{0xf77afae0e19a636c}},11,"F-H0-15257",469,2},
  {{{0xf77afae0e19a636c}},11,"F-H0-15258",430,2},
  {{{0xdb81ae1afefb13ed}},6,"F-H0-15259",690,3},
  {{{0xd8a4967cdbe28a36}},12,"F-H0-15260",580,3},
  {{{0x2f2e251786e6e727}},13,"F-H0-15261",652,3},
  {{{0x2de78086cc842fae}},13,"F-H0-15262",938,5},
  {{{0x8e7d6ad6206e98d}},7,"F-H0-15263",727,2},
  {{{0x8594cdf4c9a049f0}},7,"F-H0-15264",690,2},
  {{{0xdf2d2359b912c021}},8,"F-H0-15265",394,5},
  {{{0x2a2eaf4b480e2315}},12,"F-H0-15266",939,2},
  {{{0x2a2eaf4b480e2315}},12,"F-H0-15267",421,2},
  {{{0xe3ed61f3d450e1e2}},12,"F-H0-15268",947,2},
  {{{0xb587865fdbf972a7}},7,"F-H0-15269",801,2},
  {{{0x155ede249c12594e}},6,"F-H0-15270",911,4},
  {{{0xdafe69adf26e5688}},16,"F-H0-15271",543,2},
  {{{0x26466cde6ad3b485}},7,"F-H0-15272",542,2},
  {{{0x67b8285c0094c982}},4,"F-H0-15273",901,3},
  {{{0x1b9a7864aac8317b}},13,"F-H0-15274",544,2},
  {{{0xa07b6b912e2df68c}},9,"F-H0-15275",432,4},
  {{{0x52d82a86ebe9f098}},6,"F-H0-15276",838,2},
  {{{0xdc41c80a434b0847}},9,"F-H0-15277",905,4},
  {{{0xcd7a1fa5959d1ea1}},16,"F-H0-15278",985,4},
  {{{0x5fe69639c34a706d}},10,"F-H0-15279",466,3},
  {{{0x6412a5388aa09ca2}},13,"F-H0-15280",948,4},
  {{{0x70be89482d66da51}},12,"F-H0-15281",986,3},
  {{{0xcfa5f9cb2c560af7}},13,"F-H0-15282",833,4},
  {{{0x23ab2025c72188c3}},12,"F-H0-15283",987,5},
  {{{0x3c9726adfb9e0aff}},6,"F-H0-15284",949,3},
  {{{0x8995658ce9dbfba8}},6,"F-H0-15285",987,2},
  {{{0x70fadc02f84604d2}},5,"F-H0-15286",458,2},
  {{{0xb044bbe3b9f8d0e4}},5,"F-H0-15287",505,2},
  {{{0x4607aeda53493f5d}},6,"F-H0-15288",678,3},
  {{{0xf2e0fb8ce984cfb2}},11,"F-H0-15289",802,2},
  {{{0xe46351b1b5686cff}},11,"F-H0-15290",826,2},
  {{{0x3827e76f61133aaf}},10,"F-H0-15291",690,5},
  {{{0x372694e4e2ff915}},10,"F-H0-15292",949,2},
  {{{0x372694e4e2ff915}},10,"F-H0-15293",912,2},
  {{{0x7751e8b278816fc2}},4,"F-H0-15294",907,2},
  {{{0xb45352404547af2f}},4,"F-H0-15295",654,2},
  {{{0x2d4aa301de1ea34c}},9,"F-H0-15296",529,3},
  {{{0x2f7e639d717fbb1b}},10,"F-H0-15297",899,3},
  {{{0x79db016462ef78ec}},5,"F-H0-15298",494,2},
  {{{0x5f09a10c962a6099}},5,"F-H0-15299",469,2},
  {{{0x584594086ff1b9f3}},5,"F-H0-15300",838,2},
  {{{0x47621e1fbf5c64d9}},6,"F-H0-15301",493,2},
  {{{0x47621e1fbf5c64d9}},6,"F-H0-15302",457,2},
  {{{0x6dd29047ba4c44ea}},12,"F-H0-15303",862,3},
  {{{0x2cbbbfefb6231f32}},7,"F-H0-15304",911,2},
  {{{0x1e7db2e0417d5039}},10,"F-H0-15305",937,3},
  {{{0xa7f08f350e67d734}},9,"F-H0-15306",828,2},
  {{{0xc8156afd6d9c75bb}},5,"F-H0-15307",908,2},
  {{{0x2530bf65668fca9a}},4,"F-H0-15308",457,2},
  {{{0xf33697d9587291dd}},16,"F-H0-15309",728,4},
  {{{0x905948a0bd698d8f}},20,"F-H0-15310",943,2},
  {{{0x9e676c5cc4879fb8}},6,"F-H0-15311",837,4},
  {{{0xb91b11b47004e0ea}},8,"F-H0-15312",826,5},
  {{{0x8bfac1ca9512b995}},7,"F-H0-15313",727,2},
  {{{0x8bfac1ca9512b995}},7,"F-H0-15314",914,2},
  {{{0x3e8b0fef3c5a9c4c}},11,"F-H0-15315",909,5},
  {{{0x5b289997887123da}},6,"F-H0-15316",431,4},
  {{{0xdae90d105ca0fc6f}},4,"F-H0-15317",876,2},
  {{{0x17db1888bf65c98b}},7,"F-H0-15318",937,2},
  {{{0xd8fe36d726c0eac9}},11,"F-H0-15319",801,5},
  {{{0x9d8397a28c52774}},16,"F-H0-15320",876,3},
  {{{0x371e8cae1d07e544}},8,"F-H0-15321",543,3},
  {{{0x26b6f976d5f9bd05}},8,"F-H0-15322",875,2},
  {{{0x8432a5f354afd123}},16,"F-H0-15323",939,3},
  {{{0x79d1bb0d5bab6b7b}},6,"F-H0-15324",973,5},
  {{{0xfe8d3a8bac3879c0}},5,"F-H0-15325",937,2},
  {{{0xad00b70e087aae93}},5,"F-H0-15326",939,5},
  {{{0x549ff2ef40f891bf}},13,"F-H0-15327",867,2},
  {{{0xa80277212f86da15}},9,"F-H0-15328",789,3},
  {{{0x5331536e158fb802}},7,"F-H0-15329",876,5},
  {{{0x4dc437779660f490}},14,"F-H0-15330",500,3},
  {{{0xa97ff227414cb8f6}},14,"F-H0-15331",907,2},
  {{{0x2dea4a01a3e4ad14}},13,"F-H0-15332",986,5},
  {{{0xd317583fa59633d0}},19,"F-H0-15333",904,3},
  {{{0xd317583fa59633d0}},19,"F-H0-15334",865,2},
  {{{0xb42036e6ea324d0e}},9,"F-H0-15335",936,5},
  {{{0x9d8b7b0ed408b2e5}},12,"F-H0-15336",941,3},
  {{{0x431340f8972a78dd}},8,"F-H0-15337",913,5},
  {{{0xefe7d9de21cf8eee}},18,"F-H0-15338",936,5},
  {{{0xe31d54be7574150e}},10,"F-H0-15339",691,4},
  {{{0x25118c766ae199d0}},9,"F-H0-15340",944,4},
  {{{0x37049af1b71caf5a}},6,"F-H0-15341",424,3},
  {{{0x2527f81b753406dc}},6,"F-H0-15342",431,3},
  {{{0x735e31dcf00471e6}},7,"F-H0-15343",947,2},
  {{{0xd74eb0f2f646c316}},14,"F-H0-15344",904,3},
  {{{0x26a434f2b13e01b4}},16,"F-H0-15345",790,2},
  {{{0x2438d1a220d66081}},16,"F-H0-15346",951,2},
  {{{0xa0d556790b5dbfc3}},14,"F-H0-15347",839,5},
  {{{0x90cea2c4cd1c1e1}},5,"F-H0-15348",937,2},
  {{{0x22754ef69ee9d34f}},9,"F-H0-15349",947,4},
  {{{0x2e0bd5f78efa7df4}},9,"F-H0-15350",946,5},
  {{{0x868677eca125bdbb}},5,"F-H0-15351",875,4},
  {{{0x584b3efb3627ac73}},8,"F-H0-15352",456,3},
  {{{0x723a3905b35bde5d}},12,"F-H0-15353",862,3},
  {{{0x537134398efacc8}},12,"F-H0-15354",939,2},
  {{{0x1e38741cc6f297e6}},7,"F-H0-15355",801,3},
  {{{0x8e1e9dc3accc428f}},6,"F-H0-15356",420,2},
  {{{0x8e1e9dc3accc428f}},6,"F-H0-15357",788,2},
  {{{0x3e0e2f2f754a0a4f}},20,"F-H0-15358",947,3},
  {{{0x33cc8ef56672b135}},13,"F-H0-15359",755,3},
  {{{0xe16bf5e73c71f405}},16,"F-H0-15360",945,2},
  {{{0xe16bf5e73c71f405}},16,"F-H0-15361",529,2},
  {{{0x5433488afa22d636}},8,"F-H0-15362",949,5},
  {{{0x16b12f20fffa638f}},7,"F-H0-15363",542,2},
  {{{0xc2eb27e4d297815d}},11,"F-H0-15364",876,2},
  {{{0x85217ffd2d1d0cec}},6,"F-H0-15365",826,4},
  {{{0x12f53787ac12f28e}},5,"F-H0-15366",825,2},
  {{{0x51357d23aa4ed468}},5,"F-H0-15367",424,2},
  {{{0xf846cc7a42f32aa4}},10,"F-H0-15368",764,2},
  {{{0xb23359f4470c0c84}},5,"F-H0-15369",943,2},
  {{{0x422a02182364f34e}},12,"F-H0-15370",421,4},
  {{{0x5d2c5d1bbeb0b462}},2,"F-H0-15371",875,2},
  {{{0x91b4ae8110bd9176}},3,"F-H0-15372",900,3},
  {{{0x4e28af69a3c766ea}},3,"F-H0-15373",455,2},
  {{{0x1aced69546ebc983}},5,"F-H0-15374",456,3},
  {{{0xcb2074d8d08ee1c4}},7,"F-H0-15375",530,3},
  {{{0x3411b7b3b7ecd21}},20,"F-H0-15376",641,3},
  {{{0xa44dd5630c92db50}},20,"F-H0-15377",943,2},
  {{{0xea7f0cd4fb934b27}},4,"F-H0-15378",939,4},
  {{{0x4d5c75491891b356}},8,"F-H0-15379",987,5},
  {{{0x34358660321b2b58}},9,"F-H0-15380",603,4},
  {{{0x59b994f934ee70e9}},8,"F-H0-15381",903,4},
  {{{0xd78097f24384a954}},9,"F-H0-15382",838,5},
  {{{0x811b1341534ee3e4}},6,"F-H0-15383",944,3},
  {{{0x2a199f31a09a2636}},13,"F-H0-15384",454,2},
  {{{0x5953ec1c35bfc83d}},13,"F-H0-15385",948,2},
  {{{0x40563c43676d4dd5}},3,"F-H0-15386",912,3},
  {{{0xdb0555c0b543700b}},16,"F-H0-15387",837,5},
  {{{0x37358703b7b183ef}},12,"F-H0-15388",866,2},
  {{{0xd23d8dfe9005e33d}},4,"F-H0-15389",906,2},
  {{{0x15f98f1d51e0d890}},9,"F-H0-15390",543,3},
  {{{0xe14ac81935784a73}},11,"F-H0-15391",975,5},
  {{{0xfab31a38bd09b0ea}},10,"F-H0-15392",691,2},
  {{{0x70fa7fca32bb1240}},19,"F-H0-15393",691,2},
  {{{0xc495501c926b25bc}},4,"F-H0-15394",493,2},
  {{{0xe27ed89df8ba9b0e}},3,"F-H0-15395",455,2},
  {{{0xb59477d19c443cc3}},10,"F-H0-15396",420,5},
  {{{0xd5c493a9cf26cba2}},5,"F-H0-15397",826,3},
  {{{0xb8d123d4b1b1b726}},10,"F-H0-15398",877,4},
  {{{0x5b40c975b6fdfc96}},11,"F-H0-15399",616,5},
  {{{0xbbf9533ce2da1976}},12,"F-H0-15400",615,5},
  {{{0x2f064fde1f72de2e}},13,"F-H0-15401",764,5},
  {{{0xb684b4ac133e2c69}},11,"F-H0-15402",422,2},
  {{{0x1194e723ef514047}},6,"F-H0-15403",800,2},
  {{{0xb2db5a2d2151bbc3}},11,"F-H0-15404",506,5},
  {{{0xeadccd4b1c47ddd9}},12,"F-H0-15405",937,3},
  {{{0x2cd8224b28981136}},15,"F-H0-15406",827,3},
  {{{0xe90712602e077dbf}},7,"F-H0-15407",466,4},
  {{{0x14e4f7f4173ad009}},10,"F-H0-15408",950,4},
  {{{0x71f1551658be9cd5}},5,"F-H0-15409",865,4},
  {{{0x98a18bce3b63213a}},8,"F-H0-15410",455,5},
  {{{0xdefcc51ad153b07b}},7,"F-H0-15411",603,2},
  {{{0x8aab452adb8807e}},10,"F-H0-15412",838,3},
  {{{0x44f5356cff942a08}},10,"F-H0-15413",422,2},
  {{{0x662ca60174a329e9}},5,"F-H0-15414",939,2},
  {{{0x2457c372f79d1280}},9,"F-H0-15415",838,2},
  {{{0x24fd41cdabf633b6}},16,"F-H0-15416",653,2},
  {{{0x5131a5da4ec183e4}},9,"F-H0-15417",910,3},
  {{{0xb8d457aeb98fc98c}},3,"F-H0-15418",862,2},
  {{{0x2c88332db1651255}},8,"F-H0-15419",468,3},
  {{{0xb1fc9df2b3d8346}},14,"F-H0-15420",872,5},
  {{{0x584f95a7bc7594b2}},5,"F-H0-15421",938,3},
  {{{0x4b105374309222a7}},5,"F-H0-15422",493,4},
  {{{0xd065e016199d5234}},17,"F-H0-15423",469,5},
  {{{0xe2d7a63e7b1d90d7}},10,"F-H0-15424",940,2},
  {{{0x66960116908603ea}},24,"F-H0-15425",943,5},
  {{{0xc04fc4b6cd8bf9f}},6,"F-H0-15426",690,5},
  {{{0xa5d31d8dabe2b15d}},7,"F-H0-15427",603,3},
  {{{0x507d3f130e36af80}},7,"F-H0-15428",907,2},
  {{{0x9c3f6212f0efcbb3}},4,"F-H0-15429",456,2},
  {{{0x9c3f6212f0efcbb3}},4,"F-H0-15430",542,2},
  {{{0x9f460823743bd217}},7,"F-H0-15431",433,5},
  {{{0xaa5a2a96376cfb1f}},7,"F-H0-15432",936,3},
  {{{0xd887ed702628b624}},6,"F-H0-15433",950,3},
  {{{0xd6a10bb48e2b611}},15,"F-H0-15434",939,5},
  {{{0x690b8889cc553d2c}},6,"F-H0-15435",429,3},
  {{{0x6a7e6a2d57ec8e17}},6,"F-H0-15436",531,2},
  {{{0x220ec6f11bda8782}},8,"F-H0-15437",950,2},
  {{{0x4aefbaf2675bd21b}},13,"F-H0-15438",946,5},
  {{{0xf3a2e94e1900de70}},20,"F-H0-15439",945,5},
  {{{0xa44bf787f1ce4b4f}},13,"F-H0-15440",906,3},
  {{{0xc1df6eeab742dbf9}},7,"F-H0-15441",801,4},
  {{{0xfddf7e60e086e20d}},10,"F-H0-15442",837,3},
  {{{0x8fd0249b08910068}},9,"F-H0-15443",974,5},
  {{{0xdbf31a67a0ab2466}},5,"F-H0-15444",543,3},
  {{{0xebcd9094c2ab7d91}},6,"F-H0-15445",875,4},
  {{{0xf563deaf0eb2ba0d}},5,"F-H0-15446",529,3},
  {{{0xa2a8734677e0ad69}},11,"F-H0-15447",454,2},
  {{{0x56849f15f4d042f6}},12,"F-H0-15448",951,3},
  {{{0xd18ad05ba12670c3}},6,"F-H0-15449",432,2},
  {{{0xc5e02d19f0046cfb}},6,"F-H0-15450",837,2},
  {{{0xbdaf94c9467ca660}},7,"F-H0-15451",839,3},
  {{{0x294eaa780b9cb4e7}},8,"F-H0-15452",419,5},
  {{{0x8a9efb2993d9ec08}},15,"F-H0-15453",946,3},
  {{{0x6f2b6ce989c11890}},7,"F-H0-15454",937,3},
  {{{0x1b24640d3386193}},7,"F-H0-15455",901,2},
  {{{0x3307faebb5497351}},18,"F-H0-15456",465,3},
  {{{0x83ba23431ef6afc3}},15,"F-H0-15457",825,3},
  {{{0xa855554a311490ad}},9,"F-H0-15458",640,3},
  {{{0x11864febe7d477c3}},11,"F-H0-15459",502,3},
  {{{0x2decf40ec512869e}},8,"F-H0-15460",839,4},
  {{{0xf470652053f11e9b}},16,"F-H0-15461",865,2},
  {{{0x225eaea3a1db7663}},10,"F-H0-15462",941,4},
  {{{0x4efdeda31b855c92}},5,"F-H0-15463",429,3},
  {{{0x1891b2afd8f1b9f2}},7,"F-H0-15464",942,2},
  {{{0x8f3b34138c92e005}},6,"F-H0-15465",543,2},
  {{{0x80695dbdbe9f28c8}},6,"F-H0-15466",506,2},
  {{{0x5dbb9124c10cf2f6}},10,"F-H0-15467",462,3},
  {{{0x4ace8af3ace016db}},18,"F-H0-15468",801,4},
  {{{0xb204f89b6626d0fa}},8,"F-H0-15469",946,4},
  {{{0x53abddf178da5d76}},8,"F-H0-15470",691,2},
  {{{0xc5d79ace94097002}},7,"F-H0-15471",458,3},
  {{{0x88fa509b52a13696}},12,"F-H0-15472",839,3},
  {{{0x67573d83f4d8ebf1}},15,"F-H0-15473",835,5},
  {{{0x5605211b54f74ad2}},17,"F-H0-15474",947,3},
  {{{0x5605211b54f74ad2}},17,"F-H0-15475",912,2},
  {{{0x38ce3a1f17ca9892}},8,"F-H0-15476",987,2},
  {{{0xeb576c2123a4e6bf}},14,"F-H0-15477",899,2},
  {{{0xadfe3d0a503279bd}},10,"F-H0-15478",425,2},
  {{{0x934972544678d4ea}},10,"F-H0-15479",462,2},
  {{{0x149c0bb25a24bcaf}},10,"F-H0-15480",910,2},
  {{{0xff0a3b88bb6fa1d}},12,"F-H0-15481",579,4},
  {{{0xd586f25258fd730b}},5,"F-H0-15482",910,2},
  {{{0xd586f25258fd730b}},5,"F-H0-15483",950,2},
  {{{0x10188f143405c3bb}},17,"F-H0-15484",763,3},
  {{{0xe2e74fab49c33178}},9,"F-H0-15485",418,2},
  {{{0x62e74ed468272794}},9,"F-H0-15486",827,2},
  {{{0xda7c95213f2d1d1}},7,"F-H0-15487",421,4},
  {{{0x77939d93ef892789}},9,"F-H0-15488",873,4},
  {{{0xd1b39e889d690e57}},12,"F-H0-15489",579,3},
  {{{0xd1b39e889d690e57}},12,"F-H0-15490",502,2},
  {{{0x2a3d24b5a83dbb25}},9,"F-H0-15491",567,2},
  {{{0x69876e79bee2aeca}},10,"F-H0-15492",463,2},
  {{{0xddf30520e45c97f2}},13,"F-H0-15493",543,2},
  {{{0xefc3fe2dd3c1cd9b}},13,"F-H0-15494",949,5},
  {{{0xe0a3d608ed4128b5}},15,"F-H0-15495",690,2},
  {{{0x3875e487c7d92e1d}},15,"F-H0-15496",568,2},
  {{{0xbacbf0f40cab30b9}},9,"F-H0-15497",432,3},
  {{{0xbacbf0f40cab30b9}},9,"F-H0-15498",580,2},
  {{{0x12e8557d4c800564}},14,"F-H0-15499",839,4},
  {{{0x86af27adb23951d6}},6,"F-H0-15500",678,2},
  {{{0x38071058ad3e3d59}},10,"F-H0-15501",529,5},
  {{{0x6bff40a45d7c936c}},10,"F-H0-15502",605,2},
  {{{0xdea311f3ed75a91}},20,"F-H0-15503",987,5},
  {{{0x817581210e39bc1a}},13,"F-H0-15504",418,2},
  {{{0xad46dd34dfa5897e}},6,"F-H0-15505",911,3},
  {{{0xb2861ab2321f28be}},8,"F-H0-15506",943,2},
  {{{0x15f9df34e98cdaca}},5,"F-H0-15507",911,4},
  {{{0x2efe52bb4969cdfe}},10,"F-H0-15508",837,5},
  {{{0xf1c885faf0309041}},17,"F-H0-15509",837,4},
  {{{0x5645ae95558d92fe}},6,"F-H0-15510",690,3},
  {{{0x29f8e456c6d288a6}},6,"F-H0-15511",531,3},
  {{{0x69e407511ca026bf}},6,"F-H0-15512",418,2},
  {{{0x967c83ceea562752}},5,"F-H0-15513",460,2},
  {{{0x79a413965f378756}},5,"F-H0-15514",580,2},
  {{{0xa43e4f540bcb7902}},10,"F-H0-15515",937,5},
  {{{0x593e1d712eb15e8d}},10,"F-H0-15516",985,4},
  {{{0x16d8dc1f350a92ba}},10,"F-H0-15517",539,5},
  {{{0x9d16fc4db32a46b4}},10,"F-H0-15518",752,3},
  {{{0x9c9b8665bacdfdc9}},10,"F-H0-15519",728,2},
  {{{0xdd3c4b2777889361}},6,"F-H0-15520",908,2},
  {{{0xc67e850a5ff8d360}},4,"F-H0-15521",876,2},
  {{{0x91873ae7264b1a8e}},13,"F-H0-15522",868,3},
  {{{0xceef94830d58acec}},10,"F-H0-15523",421,3},
  {{{0x5075051e17ad9503}},14,"F-H0-15524",802,4},
  {{{0xb1a87beb4db648d8}},6,"F-H0-15525",432,3},
  {{{0xb1a87beb4db648d8}},6,"F-H0-15526",503,2},
  {{{0x214eeb3875cc9592}},4,"F-H0-15527",421,4},
  {{{0x20f2d3c092010}},8,"F-H0-15528",871,2},
  {{{0x190483b997c1ee18}},7,"F-H0-15529",494,2},
  {{{0x1605edf6c375fdde}},10,"F-H0-15530",396,5},
  {{{0x2b43006e31dbab4}},12,"F-H0-15531",543,5},
  {{{0xa0c33d53fa269c59}},10,"F-H0-15532",910,4},
  {{{0x69e3a173f6e8f8f3}},2,"F-H0-15533",949,2},
  {{{0x585f2abbe38842d4}},5,"F-H0-15534",720,3},
  {{{0xa9f4090ad1506fa6}},11,"F-H0-15535",939,2},
  {{{0x2119df28551c1201}},10,"F-H0-15536",530,3},
  {{{0xeac18983f1de3b03}},10,"F-H0-15537",905,2},
  {{{0x97085003a843a73d}},4,"F-H0-15538",911,2},
  {{{0x97085003a843a73d}},4,"F-H0-15539",430,2},
  {{{0x8f69f7c698871ced}},13,"F-H0-15540",898,3},
  {{{0x4589f156bc43de8d}},6,"F-H0-15541",973,3},
  {{{0xf8407e01f502b93d}},7,"F-H0-15542",906,2},
  {{{0xdd97fb724cf58176}},10,"F-H0-15543",466,2},
  {{{0xdd97fb724cf58176}},10,"F-H0-15544",467,2},
  {{{0x950af8ce8229557}},8,"F-H0-15545",938,4},
  {{{0x918d655dee480c7c}},10,"F-H0-15546",862,2},
  {{{0x79e07f989d3f9e0}},10,"F-H0-15547",469,2},
  {{{0x840685ae41090c00}},7,"F-H0-15548",543,2},
  {{{0xf0472c444f890e36}},11,"F-H0-15549",616,5},
  {{{0xd194324a688494c4}},11,"F-H0-15550",754,3},
  {{{0x90cd357e6a60d3ae}},9,"F-H0-15551",728,3},
  {{{0x343c2ecceaaa02aa}},11,"F-H0-15552",901,2},
  {{{0xd6109d604715161a}},8,"F-H0-15553",975,4},
  {{{0x7915b5a0c05832b0}},14,"F-H0-15554",825,5},
  {{{0x146efc7a33027400}},12,"F-H0-15555",950,5},
  {{{0x65308bab11f93d92}},6,"F-H0-15556",506,5},
  {{{0x169eb0beca2bd5a0}},8,"F-H0-15557",907,2},
  {{{0xc779b911d6772ca7}},14,"F-H0-15558",951,5},
  {{{0x4e18f50306a120ee}},9,"F-H0-15559",987,4},
  {{{0xf18e5a18e26db373}},6,"F-H0-15560",862,3},
  {{{0x94fbf6875e397f9d}},10,"F-H0-15561",461,2},
  {{{0x729af6d56ca2ad48}},8,"F-H0-15562",457,2},
  {{{0x8f07029e4e27d195}},9,"F-H0-15563",974,4},
  {{{0xc05093263a0f5110}},7,"F-H0-15564",566,4},
  {{{0x56c3503fd062ad25}},10,"F-H0-15565",753,2},
  {{{0xff739f9611979874}},9,"F-H0-15566",421,3},
  {{{0x54d9e41f07fe59fb}},10,"F-H0-15567",615,2},
  {{{0x54d9e41f07fe59fb}},10,"F-H0-15568",652,2},
  {{{0xdf3fd1899d8252c6}},15,"F-H0-15569",984,4},
  {{{0xfe69d360c9bf60d7}},5,"F-H0-15570",506,3},
  {{{0xebf6379af8edd4eb}},5,"F-H0-15571",458,3},
  {{{0xebf6379af8edd4eb}},5,"F-H0-15572",421,2},
  {{{0x19a75a9305dba8b2}},7,"F-H0-15573",825,4},
  {{{0x9dd76d7bb6471bf1}},5,"F-H0-15574",466,2},
  {{{0xdf0a7a2441b1d90d}},12,"F-H0-15575",425,2},
  {{{0xc905143a4efda6d}},12,"F-H0-15576",507,5},
  {{{0x90822b607030dbf8}},6,"F-H0-15577",425,2},
  {{{0x434c1fb36b376af0}},5,"F-H0-15578",839,3},
  {{{0xe78b2d0125968b}},8,"F-H0-15579",422,3},
  {{{0xe78b2d0125968b}},8,"F-H0-15580",492,2},
  {{{0x6078537dde35a603}},7,"F-H0-15581",943,3},
  {{{0x2fdb527ff720edd0}},9,"F-H0-15582",949,5},
  {{{0x2457799563f0f3a0}},10,"F-H0-15583",913,4},
  {{{0x7cc5faf36bd57015}},9,"F-H0-15584",948,3},
  {{{0x73633471921ab8a2}},10,"F-H0-15585",425,5},
  {{{0x2fce89ff0ed197e2}},8,"F-H0-15586",913,4},
  {{{0x8063bb2a2fac427e}},21,"F-H0-15587",951,2},
  {{{0xf068e0884ea63c3d}},13,"F-H0-15588",945,4},
  {{{0xfd06bf902d2be938}},10,"F-H0-15589",826,5},
  {{{0xd019ca8a5c40a008}},10,"F-H0-15590",389,5},
  {{{0x11045f06645686f1}},15,"F-H0-15591",836,3},
  {{{0x4eddd5202b0584b9}},8,"F-H0-15592",913,5},
  {{{0xbc1f05cb388b6bce}},15,"F-H0-15593",543,2},
  {{{0x6bf7be82766a275b}},15,"F-H0-15594",423,2},
  {{{0xfbd19ac5bfd1151f}},8,"F-H0-15595",420,3},
  {{{0xfbd19ac5bfd1151f}},8,"F-H0-15596",460,2},
  {{{0xd2d611dd737456b4}},5,"F-H0-15597",913,4},
  {{{0x8395ebe7a276d9cb}},6,"F-H0-15598",457,2},
  {{{0xface0af0e1ac836b}},7,"F-H0-15599",765,2},
  {{{0x44f8a46bc1a5d723}},7,"F-H0-15600",419,2},
  {{{0x8f3df7b9b199ebd9}},9,"F-H0-15601",728,3},
  {{{0x253338d1a8d0d618}},16,"F-H0-15602",505,4},
  {{{0xc5dc2848fc1a2870}},9,"F-H0-15603",935,2},
  {{{0xf452a9314c3ca4a4}},11,"F-H0-15604",985,4},
  {{{0x2d350d3d54d5c706}},8,"F-H0-15605",866,3},
  {{{0x569e069c8ba3a79b}},13,"F-H0-15606",543,4},
  {{{0x30d657b99f27da6}},8,"F-H0-15607",837,3},
  {{{0x30d657b99f27da6}},8,"F-H0-15608",875,2},
  {{{0x6b9ddb02bb4ccd89}},9,"F-H0-15609",529,5},
  {{{0xe11b8dd1e195729d}},9,"F-H0-15610",801,3},
  {{{0x39c0bc0cbbd8e740}},10,"F-H0-15611",580,3},
  {{{0x5d85a9cf9027d37e}},10,"F-H0-15612",942,2},
  {{{0xe96665b133dcc3de}},7,"F-H0-15613",874,2},
  {{{0xc79d3a0781f53cd2}},6,"F-H0-15614",939,3},
  {{{0xc79d3a0781f53cd2}},6,"F-H0-15615",906,2},
  {{{0x47258d46f3bc6115}},6,"F-H0-15616",864,2},
  {{{0x719a5cd5852d627a}},10,"F-H0-15617",839,2},
  {{{0x1e1b5ce62216d69b}},15,"F-H0-15618",950,3},
  {{{0x1e1b5ce62216d69b}},15,"F-H0-15619",984,2},
  {{{0x39cd4df983d00eb4}},7,"F-H0-15620",910,2},
  {{{0x7971dd971ca18fed}},3,"F-H0-15621",899,2},
  {{{0x7971dd971ca18fed}},3,"F-H0-15622",936,2},
  {{{0x15550981b824aebd}},7,"F-H0-15623",939,2},
  {{{0xd4a58e9d4f8bddc5}},14,"F-H0-15624",874,3},
  {{{0xd4a58e9d4f8bddc5}},14,"F-H0-15625",912,2},
  {{{0xcf6098b8380c87ab}},12,"F-H0-15626",908,3},
  {{{0x691c665c54db8087}},23,"F-H0-15627",984,2},
  {{{0x8668b07cab99fc5e}},3,"F-H0-15628",455,2},
  {{{0xcc5588e9c04a7439}},3,"F-H0-15629",468,2},
  {{{0x30f3a7637aafe0f1}},4,"F-H0-15630",429,2},
  {{{0xdd71552cccd8ae93}},19,"F-H0-15631",983,3},
  {{{0xdd71552cccd8ae93}},19,"F-H0-15632",988,2},
  {{{0x6ac2e318e3443a39}},14,"F-H0-15633",839,4},
  {{{0xd2165244e1fa9447}},3,"F-H0-15634",456,4},
  {{{0x3af4f2612c9d3c95}},17,"F-H0-15635",838,3},
  {{{0x51fcbd8152f807ba}},10,"F-H0-15636",988,3},
  {{{0xb72289cb7add1f6b}},13,"F-H0-15637",431,2},
  {{{0x6e78e854287aa2bf}},11,"F-H0-15638",421,2},
  {{{0xe4229e87efc83c1a}},8,"F-H0-15639",394,2},
  {{{0x3da07722011ba408}},10,"F-H0-15640",901,2},
  {{{0xf8d5321c74449c1b}},19,"F-H0-15641",978,2},
  {{{0xbb3703cf5c4e215d}},3,"F-H0-15642",949,2},
  {{{0xfdeaf4f84b528540}},3,"F-H0-15643",468,2},
  {{{0x99ae84500a5c3be}},5,"F-H0-15644",691,2},
  {{{0x64d99415f5d61a61}},12,"F-H0-15645",987,4},
  {{{0xa8293187d2bb4d74}},7,"F-H0-15646",418,2},
  {{{0xbb7c629449000180}},7,"F-H0-15647",947,4},
  {{{0xb0adfee3701979c4}},9,"F-H0-15648",641,3},
  {{{0xe5212ca9479d6492}},8,"F-H0-15649",432,2},
  {{{0xcaf530615c95e33d}},4,"F-H0-15650",494,2},
  {{{0x9efcbd5b65c53256}},8,"F-H0-15651",826,3},
  {{{0xa603c6a509fdec1}},12,"F-H0-15652",800,4},
  {{{0xeb54f62f6320a4bf}},5,"F-H0-15653",456,2},
  {{{0x149c5aad477edce2}},7,"F-H0-15654",678,2},
  {{{0x7cdaba41cd2a0730}},5,"F-H0-15655",503,2},
  {{{0xf9fe9f19211dc03c}},5,"F-H0-15656",950,2},
  {{{0xb13e0857b014c305}},9,"F-H0-15657",801,4},
  {{{0x7dc0594181f7bd27}},7,"F-H0-15658",678,3},
  {{{0xf4cfd20e0856d240}},12,"F-H0-15659",470,3},
  {{{0x1d66359c3a682225}},10,"F-H0-15660",392,3},
  {{{0x19e3d007f6a01e2f}},6,"F-H0-15661",940,2},
  {{{0xc55a179eefe7bc18}},16,"F-H0-15662",983,4},
  {{{0x3171c11c3fe7c234}},19,"F-H0-15663",948,4},
  {{{0xed0aaf5f03f3e57d}},12,"F-H0-15664",873,3},
  {{{0x54395e2f55e6299f}},20,"F-H0-15665",985,4},
  {{{0x9c793764199a553e}},7,"F-H0-15666",938,4},
  {{{0x33a12068038ff5d0}},6,"F-H0-15667",950,2},
  {{{0x79d29f9fec9aca0e}},6,"F-H0-15668",944,2},
  {{{0xd2980e45adf5d788}},10,"F-H0-15669",939,2},
  {{{0x30f07b4dd004e2b5}},9,"F-H0-15670",898,2},
  {{{0xfdd57509de401ba8}},12,"F-H0-15671",801,2},
  {{{0xafe7519690cfd456}},18,"F-H0-15672",579,3},
  {{{0x31c15d6a498e7ede}},6,"F-H0-15673",467,3},
  {{{0xf381e6747497f017}},13,"F-H0-15674",470,2},
  {{{0x42b50da0a9c266ba}},6,"F-H0-15675",429,2},
  {{{0xd61140348206ba1a}},12,"F-H0-15676",939,4},
  {{{0xeefcf0156e2e43c2}},5,"F-H0-15677",420,2},
  {{{0xeefcf0156e2e43c2}},5,"F-H0-15678",425,2},
  {{{0x4034281243e79370}},7,"F-H0-15679",690,3},
  {{{0x68d3f60d5cbb8db7}},10,"F-H0-15680",899,3},
  {{{0x673b9f8416f6d5ab}},16,"F-H0-15681",391,2},
  {{{0xf3d53f36e46da26b}},12,"F-H0-15682",579,3},
  {{{0xffcd44ac4d08c83c}},6,"F-H0-15683",690,4},
  {{{0x5aecb9c35d7b03e3}},8,"F-H0-15684",429,3},
  {{{0xebc789b519fd6dac}},6,"F-H0-15685",506,2},
  {{{0x8245054e6a0f40b7}},7,"F-H0-15686",424,2},
  {{{0xf9a0386e83361779}},12,"F-H0-15687",788,2},
  {{{0x405b361763c6c444}},18,"F-H0-15688",987,4},
  {{{0x7de3947a86f3285c}},15,"F-H0-15689",825,3},
  {{{0x68a33779de48a84c}},20,"F-H0-15690",382,4},
  {{{0x9d1c4df692889459}},8,"F-H0-15691",418,4},
  {{{0xbf2faa7f65976d6a}},9,"F-H0-15692",875,2},
  {{{0x100ca3953b0091aa}},6,"F-H0-15693",948,2},
  {{{0x6871cd26a841fa5b}},17,"F-H0-15694",875,2},
  {{{0x94c1dcf4f218fd02}},11,"F-H0-15695",974,3},
  {{{0x345be865f8d62c8a}},9,"F-H0-15696",837,2},
  {{{0x1ab72878c7be9344}},10,"F-H0-15697",419,3},
  {{{0x7c37f97345e9d583}},6,"F-H0-15698",420,4},
  {{{0x19eb8cc2a50e09b}},6,"F-H0-15699",419,2},
  {{{0x14d848ab4f558bc8}},8,"F-H0-15700",913,3},
  {{{0xd27c4e37060b4846}},8,"F-H0-15701",826,2},
  {{{0xa42a90a249ef5037}},15,"F-H0-15702",935,4},
  {{{0x19a6b4a2c222f17e}},13,"F-H0-15703",939,4},
  {{{0x48f4ad799ff1a4e0}},11,"F-H0-15704",466,4},
  {{{0xc642fae28aebf56e}},21,"F-H0-15705",914,3},
  {{{0x12f7d827a88cc2eb}},6,"F-H0-15706",418,4},
  {{{0x8897f4cad7d9bcb3}},11,"F-H0-15707",873,4},
  {{{0xe8edb3e9c043358e}},7,"F-H0-15708",470,3},
  {{{0x4379a5903190801e}},15,"F-H0-15709",382,2},
  {{{0xbdfa27a051b807c}},15,"F-H0-15710",420,4},
  {{{0x667e545f23ccac56}},8,"F-H0-15711",579,4},
  {{{0x68f8212bb2e996a1}},7,"F-H0-15712",466,3},
  {{{0x16a8b1e4b52bce37}},9,"F-H0-15713",910,2},
  {{{0x27517aca961747e1}},9,"F-H0-15714",567,2},
  {{{0xa8303324126bb554}},20,"F-H0-15715",948,2},
  {{{0xcc1f3bf5bcd922cd}},22,"F-H0-15716",941,2},
  {{{0x778b404cb2cbe18}},7,"F-H0-15717",877,3},
  {{{0x8e88bf507313416b}},6,"F-H0-15718",495,3},
  {{{0x26fb49d7ede82506}},18,"F-H0-15719",910,2},
  {{{0x9630d15309f8c775}},9,"F-H0-15720",765,2},
  {{{0x9870bbf330feb639}},6,"F-H0-15721",418,4},
  {{{0xfb88d00ba7b22c3e}},7,"F-H0-15722",458,3},
  {{{0xc38a03d599764ad5}},14,"F-H0-15723",948,2},
  {{{0xc38a03d599764ad5}},14,"F-H0-15724",986,2},
  {{{0x16d5a18625c3e5cb}},7,"F-H0-15725",543,2},
  {{{0xdfa5865ac4a02e0b}},15,"F-H0-15726",386,4},
  {{{0xff2f6e81b6307cff}},10,"F-H0-15727",801,3},
  {{{0x9f5f8d7726ede00f}},12,"F-H0-15728",429,2},
  {{{0x81b046bb7c8ae8cf}},7,"F-H0-15729",936,2},
  {{{0xaefd04dc1c9c6853}},7,"F-H0-15730",827,2},
  {{{0xec7f2dbd5420c527}},5,"F-H0-15731",677,2},
  {{{0xc24011382d257db5}},5,"F-H0-15732",493,2},
  {{{0x7846c37f92e13f17}},5,"F-H0-15733",946,2},
  {{{0x742d9bfbca022387}},6,"F-H0-15734",432,3},
  {{{0xa07d770b3a198c02}},5,"F-H0-15735",825,2},
  {{{0x246e64d73375a994}},12,"F-H0-15736",418,3},
  {{{0xbbcdff5f9f3b031b}},11,"F-H0-15737",947,3},
  {{{0x87040df2390a2ed7}},7,"F-H0-15738",901,3},
  {{{0x4f03eee8822dc4a8}},4,"F-H0-15739",419,2},
  {{{0x74b9d8ab73dcef6a}},6,"F-H0-15740",420,4},
  {{{0xae7d33e945d55154}},9,"F-H0-15741",936,4},
  {{{0x3d9b3e27b9a7e07f}},14,"F-H0-15742",501,3},
  {{{0x6e5c4346842a0cc9}},9,"F-H0-15743",728,3},
  {{{0x159395d355ebe86b}},12,"F-H0-15744",906,3},
  {{{0xdf4340e01043d63c}},13,"F-H0-15745",828,3},
  {{{0xe6ed163b7bc4cb4f}},5,"F-H0-15746",949,2},
  {{{0x9588b7fa64b63bc4}},8,"F-H0-15747",873,2},
  {{{0x4a61a9974cfad282}},11,"F-H0-15748",542,3},
  {{{0x851b5456b3e897e9}},6,"F-H0-15749",951,4},
  {{{0xf3a5790483415ef5}},11,"F-H0-15750",873,3},
  {{{0xf94f024feae1d8ab}},17,"F-H0-15751",942,2},
  {{{0xde7b02104f655bae}},16,"F-H0-15752",461,2},
  {{{0x80073c2693806aa7}},4,"F-H0-15753",876,2},
  {{{0x85dd6834f2fa87da}},5,"F-H0-15754",469,3},
  {{{0xf8ff6f8c3654a6cb}},14,"F-H0-15755",874,2},
  {{{0xf2db9da75243fa8f}},9,"F-H0-15756",950,2},
  {{{0xba356a6ae9d6751a}},11,"F-H0-15757",867,4},
  {{{0x210ace1a3950ef0f}},10,"F-H0-15758",418,2},
  {{{0x1fa110440098087d}},8,"F-H0-15759",950,4},
  {{{0xc7c1c3df6b9b9933}},9,"F-H0-15760",800,2},
  {{{0x7427ab93def3acc5}},11,"F-H0-15761",911,2},
  {{{0x815da5ad3e586355}},8,"F-H0-15762",506,2},
  {{{0x815da5ad3e586355}},8,"F-H0-15763",616,2},
  {{{0x83328939c19f973c}},8,"F-H0-15764",825,2},
  {{{0xab4ef2422b1c8ac1}},6,"F-H0-15765",641,2},
  {{{0x1e26ff4990bbbe94}},6,"F-H0-15766",529,2},
  {{{0xfc4de8d4773e5aec}},10,"F-H0-15767",938,2},
  {{{0xf02a110433f9c30a}},11,"F-H0-15768",939,3},
  {{{0x73ae360ea18571be}},18,"F-H0-15769",902,3},
  {{{0xaf801c8dd8a9b7d1}},7,"F-H0-15770",466,2},
  {{{0xad5807009be794c3}},7,"F-H0-15771",494,2},
  {{{0xddc8af9b343fd1ac}},15,"F-H0-15772",790,4},
  {{{0x51de138ebf437369}},12,"F-H0-15773",543,3},
  {{{0xef33e35a963891a4}},15,"F-H0-15774",420,3},
  {{{0xdcdd85b67ba41de2}},4,"F-H0-15775",912,3},
  {{{0xcff64e3f4db8bf0c}},3,"F-H0-15776",862,2},
  {{{0xab1215274bd5885d}},10,"F-H0-15777",457,4},
  {{{0xead24d61f7b101c}},18,"F-H0-15778",579,3},
  {{{0x728895cdc6d9aa92}},3,"F-H0-15779",901,2},
  {{{0xc6161d7afc6eff42}},22,"F-H0-15780",951,2},
  {{{0xc6161d7afc6eff42}},22,"F-H0-15781",840,2},
  {{{0xd693f60f0e044f75}},15,"F-H0-15782",432,4},
  {{{0xfa590e61172a447}},8,"F-H0-15783",937,2},
  {{{0xed007ab93daabce4}},12,"F-H0-15784",950,2},
  {{{0x74c09ddbf3c41fcd}},12,"F-H0-15785",502,3},
  {{{0xfe2d44bc8d2d25ca}},10,"F-H0-15786",875,3},
  {{{0xfe5c4dd1383141e0}},8,"F-H0-15787",949,3},
  {{{0x3ae989dad5740d99}},12,"F-H0-15788",420,2},
  {{{0x4913750db94e30a6}},13,"F-H0-15789",910,4},
  {{{0x7be815b8a8c6bd6}},6,"F-H0-15790",541,4},
  {{{0x9e2bbd54b261ddd4}},13,"F-H0-15791",616,3},
  {{{0x72870c119b429199}},8,"F-H0-15792",418,2},
  {{{0xdbeb658b36bf85fd}},5,"F-H0-15793",543,2},
  {{{0xbcf232807573014a}},19,"F-H0-15794",947,2},
  {{{0xff6f4da386c3c9dd}},11,"F-H0-15795",907,3},
  {{{0xa118d3c6dcccf667}},10,"F-H0-15796",948,4},
  {{{0x14ed9340dc8c5364}},8,"F-H0-15797",459,4},
  {{{0xf42fe8e4a0b2b933}},7,"F-H0-15798",947,2},
  {{{0x48c5e62ef7d6493a}},6,"F-H0-15799",469,2},
  {{{0x4411dbb7df24939b}},5,"F-H0-15800",641,2},
  {{{0x263da78e9cac2b27}},9,"F-H0-15801",937,3},
  {{{0x75f4c722bc6e946e}},6,"F-H0-15802",911,3},
  {{{0xe7bfbdb19b32d61a}},7,"F-H0-15803",466,3},
  {{{0x30cb76a62ebbd873}},9,"F-H0-15804",875,2},
  {{{0xdf2b1b38daac1063}},9,"F-H0-15805",615,2},
  {{{0x2a4992aa2e3c0041}},21,"F-H0-15806",983,3},
  {{{0xccadca25dbfd4523}},17,"F-H0-15807",827,4},
  {{{0xc9872be069bade6}},6,"F-H0-15808",494,3},
  {{{0xe6ca0594a0d54a94}},22,"F-H0-15809",914,3},
  {{{0xdb4299ea5be5bd72}},6,"F-H0-15810",900,3},
  {{{0xf799a1a51dfde07b}},4,"F-H0-15811",864,2},
  {{{0x79f8c09c7e77e75c}},16,"F-H0-15812",839,3},
  {{{0xb8b839acb68388db}},6,"F-H0-15813",425,2},
  {{{0xda587dcb17834c61}},6,"F-H0-15814",912,2},
  {{{0xc1b50254652a13a8}},6,"F-H0-15815",505,4},
  {{{0x10ef1f3927b09f6e}},19,"F-H0-15816",870,2},
  {{{0xb73bd27691485da3}},13,"F-H0-15817",950,3},
  {{{0x9b31551dd7105132}},6,"F-H0-15818",949,2},
  {{{0x9b31551dd7105132}},6,"F-H0-15819",945,2},
  {{{0x498b0086ccbaddd8}},15,"F-H0-15820",908,2},
  {{{0xcd3ede7b1823a9bf}},7,"F-H0-15821",504,3},
  {{{0x3d5cb77583f6a17e}},24,"F-H0-15822",426,3},
  {{{0xff9846b2d22329f1}},8,"F-H0-15823",862,2},
  {{{0xddeac41e3309a5de}},12,"F-H0-15824",503,3},
  {{{0x54d44f31bc2f3b9a}},8,"F-H0-15825",949,3},
  {{{0x824f139159b4ec3b}},7,"F-H0-15826",530,2},
  {{{0x4b1b9a9683c55f58}},16,"F-H0-15827",418,4},
  {{{0xbe98fd8100698269}},2,"F-H0-15828",432,2},
  {{{0x1c5659af4fc5ce1c}},3,"F-H0-15829",912,2},
  {{{0x14e99f633066d874}},11,"F-H0-15830",908,4},
  {{{0x8bdb112a55261e2d}},20,"F-H0-15831",870,3},
  {{{0xe2089f72daebddf3}},9,"F-H0-15832",458,3},
  {{{0x9feedd765c4b9da4}},5,"F-H0-15833",543,2},
  {{{0x6b90aeb90d3ac698}},18,"F-H0-15834",678,2},
  {{{0x3f3dc54feeadbb67}},7,"F-H0-15835",837,2},
  {{{0x405880b8cb487de5}},6,"F-H0-15836",862,3},
  {{{0xc0dd0ebead2a8f51}},6,"F-H0-15837",603,2},
  {{{0xd731140c73ab216d}},8,"F-H0-15838",458,3},
  {{{0x4545e5c24ed17a11}},11,"F-H0-15839",529,3},
  {{{0x6137084dabff28ab}},11,"F-H0-15840",544,4},
  {{{0x40b838008b536e37}},9,"F-H0-15841",617,4},
  {{{0xb1913e8e80b53922}},10,"F-H0-15842",939,2},
  {{{0xdfccf16019259957}},9,"F-H0-15843",455,4},
  {{{0xd4a1eae1c686f86a}},13,"F-H0-15844",826,3},
  {{{0xea26a3b2fbb77778}},22,"F-H0-15845",389,2},
  {{{0xf10ed919f3f61992}},8,"F-H0-15846",949,3},
  {{{0xdbd92641701adb5f}},13,"F-H0-15847",951,4},
  {{{0xa26ccc6a90889dc9}},19,"F-H0-15848",430,4},
  {{{0x4f71a9e143360d38}},8,"F-H0-15849",987,3},
  {{{0x50ac5bb2ceef9fd3}},19,"F-H0-15850",839,2},
  {{{0x98f0ecbc01bec1e0}},9,"F-H0-15851",939,2},
  {{{0x98f0ecbc01bec1e0}},9,"F-H0-15852",940,2},
  {{{0xf11335504ee09169}},9,"F-H0-15853",529,2},
  {{{0x52b5f588d30d20b4}},20,"F-H0-15854",529,2},
  {{{0x1d9a269177d0e3c4}},11,"F-H0-15855",603,3},
  {{{0x6e783b746d987d67}},19,"F-H0-15856",987,2},
  {{{0xd58da6352e10cb16}},8,"F-H0-15857",456,4},
  {{{0x60b51e768a1e85fa}},7,"F-H0-15858",910,4},
  {{{0x5dbbc0f7c8c2ca1c}},5,"F-H0-15859",494,3},
  {{{0x2d74dc231acf0bd1}},6,"F-H0-15860",906,2},
  {{{0x84089e11698b22a7}},8,"F-H0-15861",949,3},
  {{{0xfbb53a95a7319aaf}},8,"F-H0-15862",459,3},
  {{{0x8691d65d24d325a6}},9,"F-H0-15863",986,2},
  {{{0xfcbd6313a2886d3d}},7,"F-H0-15864",424,3},
  {{{0xa398c8b5b57db9b8}},11,"F-H0-15865",938,4},
  {{{0xacf368502c4f1102}},8,"F-H0-15866",493,2},
  {{{0xaa49c72130f51261}},9,"F-H0-15867",421,3},
  {{{0xcda49ac9c0eb53df}},11,"F-H0-15868",865,4},
  {{{0x5dacec08b3fc2848}},18,"F-H0-15869",910,2},
  {{{0x513aa99013cc5a4b}},20,"F-H0-15870",529,2},
  {{{0x6345a11451a9945d}},9,"F-H0-15871",936,2},
  {{{0x8b4acb4f367b625}},9,"F-H0-15872",677,3},
  {{{0x8ebfa4f52660e9ff}},18,"F-H0-15873",421,3},
  {{{0xe09a8860084e5e31}},8,"F-H0-15874",382,2},
  {{{0xe6db4e2d5b9e4e7}},5,"F-H0-15875",421,2},
  {{{0x6808c53d02eaa558}},17,"F-H0-15876",837,3},
  {{{0x33f633d0ab8e22e3}},10,"F-H0-15877",950,3},
  {{{0xf6f3c76bd7eef2f4}},14,"F-H0-15878",942,4},
  {{{0xd91268e2d52fb476}},4,"F-H0-15879",421,3},
  {{{0x14aff810cf2ce471}},9,"F-H0-15880",906,2},
  {{{0x911039a082cbc649}},11,"F-H0-15881",505,2},
  {{{0x95a6ea4a9dc35f9f}},12,"F-H0-15882",690,2},
  {{{0xd402acbb213efdc3}},10,"F-H0-15883",938,3},
  {{{0xaff6e76f096aee67}},8,"F-H0-15884",909,4},
  {{{0xa5d171ffb107f661}},13,"F-H0-15885",580,3},
  {{{0x1d436f908aab493e}},8,"F-H0-15886",902,2},
  {{{0xe4ec5d335b54b7eb}},16,"F-H0-15887",876,3},
  {{{0x41e2c974747ad49d}},9,"F-H0-15888",839,2},
  {{{0x97c800d88cdaf1cc}},12,"F-H0-15889",864,3},
  {{{0xdf37e10d6ddeb546}},7,"F-H0-15890",950,2},
  {{{0x455e31cf9291cccc}},3,"F-H0-15891",684,2},
  {{{0x2ca4986e1a54c21b}},18,"F-H0-15892",945,3},
  {{{0x781c17aa401b8d0b}},7,"F-H0-15893",877,4},
  {{{0x5e0eacfd3b05e08a}},3,"F-H0-15894",838,2},
  {{{0xe10bcddc13dc7fe1}},6,"F-H0-15895",420,2},
  {{{0x37896be505cea575}},6,"F-H0-15896",458,2},
  {{{0x478ead79804ce7d2}},6,"F-H0-15897",949,3},
  {{{0x520f17b11e3f648a}},20,"F-H0-15898",393,3},
  {{{0x9202b160d44cf5f7}},10,"F-H0-15899",470,4},
  {{{0x1bf7932fd2da8c8a}},12,"F-H0-15900",863,2},
  {{{0x622d41385d4bed42}},11,"F-H0-15901",976,4},
  {{{0x67bdb73106683ef9}},9,"F-H0-15902",678,2},
  {{{0x5e73e30c8049bb3e}},9,"F-H0-15903",912,2},
  {{{0xcc48e5a6564cb357}},17,"F-H0-15904",690,2},
  {{{0xb462a2c03e518db3}},12,"F-H0-15905",838,3},
  {{{0x372ecb1f8c90cb6a}},19,"F-H0-15906",541,4},
  {{{0xbc8c1000db7d9230}},19,"F-H0-15907",913,4},
  {{{0xb722d6ac69a116f9}},14,"F-H0-15908",837,3},
  {{{0xa4aec6780b0e3123}},13,"F-H0-15909",420,3},
  {{{0xdbe55efcc58448fb}},9,"F-H0-15910",875,2},
  {{{0x2b7e17bded53941}},8,"F-H0-15911",765,2},
  {{{0x912a68a3be4b0c17}},7,"F-H0-15912",504,3},
  {{{0xcaf4b3e4dfdf7d96}},10,"F-H0-15913",912,2},
  {{{0x33cd6e4e49ff43e5}},11,"F-H0-15914",384,4},
  {{{0x975195cc00d7fc37}},6,"F-H0-15915",905,2},
  {{{0x5a8b74a7dd003b6d}},12,"F-H0-15916",909,4},
  {{{0x4f705d4a5ab67edf}},8,"F-H0-15917",579,3},
  {{{0xb28081ae350abb91}},12,"F-H0-15918",578,2},
  {{{0xb28081ae350abb91}},12,"F-H0-15919",617,2},
  {{{0x5099f97039153a03}},10,"F-H0-15920",950,2},
  {{{0x45d64665c34665b5}},13,"F-H0-15921",987,4},
  {{{0x15c5b128a98974fc}},15,"F-H0-15922",492,4},
  {{{0xac2bb8c81ba34f1e}},9,"F-H0-15923",913,4},
  {{{0x2dc71580a9807d52}},8,"F-H0-15924",529,3},
  {{{0xc4c242d30c404fe2}},10,"F-H0-15925",431,4},
  {{{0x892f4b270196941d}},9,"F-H0-15926",902,3},
  {{{0x6d90e329dc19d60}},9,"F-H0-15927",944,3},
  {{{0x199c0d246bcbc5e4}},6,"F-H0-15928",715,2},
  {{{0xe63bed352b4c8109}},17,"F-H0-15929",906,4},
  {{{0x7f74fe1e6a38e211}},9,"F-H0-15930",727,2},
  {{{0x5ef60fb54fecaddc}},9,"F-H0-15931",865,3},
  {{{0xf5024fd1863cfa35}},6,"F-H0-15932",647,3},
  {{{0x108fb64313b56f8f}},5,"F-H0-15933",863,2},
  {{{0xc097a715a41ab291}},7,"F-H0-15934",950,2},
  {{{0xf79ebfc0d9f5cbfe}},7,"F-H0-15935",908,2},
  {{{0xd5d82ecff2c814e2}},8,"F-H0-15936",949,4},
  {{{0x919dac1f644160d1}},12,"F-H0-15937",431,2},
  {{{0x682381d23043710d}},12,"F-H0-15938",984,4},
  {{{0x993fb901c755b1c6}},14,"F-H0-15939",938,2},
  {{{0x774a5bc853d479f4}},8,"F-H0-15940",421,3},
  {{{0x47fcf153cc74610f}},7,"F-H0-15941",950,2},
  {{{0x9cf426eae0e5e0e4}},9,"F-H0-15942",825,2},
  {{{0x2ee42be990a67a8c}},14,"F-H0-15943",763,3},
  {{{0x568a923aba9e4d89}},11,"F-H0-15944",910,4},
  {{{0xb040812a8f2fa3cb}},9,"F-H0-15945",653,2},
  {{{0xa9582ed8d99f1fcf}},7,"F-H0-15946",802,2},
  {{{0x7064ad6e0e1ba27f}},7,"F-H0-15947",421,2},
  {{{0x87433c6b9f9165ae}},8,"F-H0-15948",862,2},
  {{{0x4ec1fefa505a72a5}},18,"F-H0-15949",801,2},
  {{{0x2f4ee4c633e4b12a}},7,"F-H0-15950",468,3},
  {{{0xd2f1fd74022f5774}},13,"F-H0-15951",912,4},
  {{{0xcd67f87490f5b30}},12,"F-H0-15952",872,4},
  {{{0x8c398475fcedbacf}},12,"F-H0-15953",940,2},
  {{{0x3005c89c2c3dbef7}},6,"F-H0-15954",457,2},
  {{{0x730dfa99678f5667}},8,"F-H0-15955",429,2},
  {{{0x9770c942b9a5909c}},8,"F-H0-15956",543,2},
  {{{0x546bc8d823ccbf0a}},10,"F-H0-15957",690,3},
  {{{0x9fb5dea67176e8ba}},14,"F-H0-15958",677,2},
  {{{0xd640495e0db9cef6}},5,"F-H0-15959",529,2},
  {{{0x77e4e73c21a9e67}},16,"F-H0-15960",800,3},
  {{{0xd9072d62ba172076}},3,"F-H0-15961",900,3},
  {{{0xb4ee92dc885cf9ed}},9,"F-H0-15962",543,2},
  {{{0xbf635b0e026bbe2b}},6,"F-H0-15963",950,3},
  {{{0x24da1a7aac3d6d61}},7,"F-H0-15964",542,3},
  {{{0x1375f50e20050b3c}},7,"F-H0-15965",603,2},
  {{{0x6f29ec82d2b46b70}},16,"F-H0-15966",469,3},
  {{{0x9a8d69e779043e60}},9,"F-H0-15967",752,2},
  {{{0x2113454275428520}},9,"F-H0-15968",422,2},
  {{{0xcaf6f1a86aad2fe9}},11,"F-H0-15969",506,3},
  {{{0xe7a20598fc458353}},6,"F-H0-15970",903,4},
  {{{0x348f7fbb508d0dfd}},14,"F-H0-15971",422,4},
  {{{0x9bd72579cf8e8610}},9,"F-H0-15972",419,2},
  {{{0x9bd72579cf8e8610}},9,"F-H0-15973",461,2},
  {{{0x1db0a5193dac0957}},8,"F-H0-15974",418,2},
  {{{0xbfbdb8084031a18c}},5,"F-H0-15975",466,2},
  {{{0x144fbc50ca24fe02}},8,"F-H0-15976",914,4},
  {{{0xa7b7a5653cfe37f}},12,"F-H0-15977",826,3},
  {{{0x62fd82272c0c4e8d}},4,"F-H0-15978",947,2},
  {{{0x70185b8658e6d2bc}},13,"F-H0-15979",458,2},
  {{{0x402868d97e4eeede}},12,"F-H0-15980",506,2},
  {{{0x929b908dfa8171f6}},11,"F-H0-15981",421,2},
  {{{0xb1bb75187151aaa6}},11,"F-H0-15982",939,2},
  {{{0x2566e2b4c104b173}},17,"F-H0-15983",897,4},
  {{{0x739bfdc6dbc736f8}},8,"F-H0-15984",937,3},
  {{{0xb2d50e77d39d18dd}},17,"F-H0-15985",417,3},
  {{{0x802bea9a905c48e8}},6,"F-H0-15986",493,3},
  {{{0x2bfabbe38df68a0a}},12,"F-H0-15987",901,4},
  {{{0x41e82e54cd578c7f}},9,"F-H0-15988",640,3},
  {{{0x153cb2ab4146be9c}},8,"F-H0-15989",469,4},
  {{{0x180d20367f4908bb}},7,"F-H0-15990",469,3},
  {{{0x3589b9a7f70f05ca}},13,"F-H0-15991",936,3},
  {{{0xca8ef7c648e3a0f}},17,"F-H0-15992",678,2},
  {{{0x3cdf903f64080b3a}},6,"F-H0-15993",908,2},
  {{{0x294c6c94c16ace93}},12,"F-H0-15994",984,3},
  {{{0x2afdc41cebb7adcf}},10,"F-H0-15995",420,2},
  {{{0x364b45a3ba1e785d}},11,"F-H0-15996",507,3},
  {{{0x23daffd36b58a0b}},17,"F-H0-15997",986,3},
  {{{0x795f368a98a9e63e}},3,"F-H0-15998",530,2},
  {{{0x58014743b0bcfc7}},16,"F-H0-15999",948,4},
  {{{0xf2b5ae950e824793}},7,"F-H0-16000",684,2},
  {{{0xf2b5ae950e824793}},7,"F-H0-16001",690,2},
  {{{0xdcf786c8b3e2aa94}},11,"F-H0-16002",544,4},
  {{{0xa7af01105c9b50d}},8,"F-H0-16003",876,2},
  {{{0x14e27dc8c83a376}},11,"F-H0-16004",950,2},
  {{{0x83375376f236a98c}},5,"F-H0-16005",939,2},
  {{{0xdbbc15439d4ba86a}},11,"F-H0-16006",691,2},
  {{{0xccde4fe1c4a0756e}},7,"F-H0-16007",865,3},
  {{{0x6efaa74c8de5c49f}},9,"F-H0-16008",462,2},
  {{{0x4764a94d4468099a}},10,"F-H0-16009",870,2},
  {{{0x445c3abdc30ed75c}},3,"F-H0-16010",948,3},
  {{{0x40a1320350362950}},9,"F-H0-16011",836,2},
  {{{0xade000e69c0922c7}},7,"F-H0-16012",839,2},
  {{{0x67b5a598d18418f5}},7,"F-H0-16013",690,2},
  {{{0x9872c430e33d5872}},8,"F-H0-16014",503,4},
  {{{0x6a98928d72ffdd37}},14,"F-H0-16015",836,2},
  {{{0xcfbfb8f72a4935b}},13,"F-H0-16016",950,4},
  {{{0xf6b0638d828aac4b}},15,"F-H0-16017",578,2},
  {{{0x79995f0bf50a94a3}},10,"F-H0-16018",653,3},
  {{{0x76c4a76f3acc906a}},11,"F-H0-16019",937,4},
  {{{0xbcb15fa55df0735a}},8,"F-H0-16020",542,3},
  {{{0xbee1db5d6bf2c609}},8,"F-H0-16021",751,2},
  {{{0xbee1db5d6bf2c609}},8,"F-H0-16022",838,2},
  {{{0xf058c3fb418cb590}},17,"F-H0-16023",986,2},
  {{{0xcd2e316c05910652}},8,"F-H0-16024",950,2},
  {{{0x963285a25ee1d6e1}},10,"F-H0-16025",875,2},
  {{{0x963285a25ee1d6e1}},10,"F-H0-16026",837,2},
  {{{0xbd75bda546d13cd6}},8,"F-H0-16027",465,4},
  {{{0xdbc61453d8941adb}},7,"F-H0-16028",428,3},
  {{{0xf758151467199656}},10,"F-H0-16029",939,2},
  {{{0x6d1023c8938df1b2}},3,"F-H0-16030",468,2},
  {{{0x344a24adf3d02439}},9,"F-H0-16031",395,4},
  {{{0x6be61f395a54e852}},10,"F-H0-16032",863,2},
  {{{0x18dbed1fc8b1de9e}},7,"F-H0-16033",912,4},
  {{{0xed064d28a1e44a67}},21,"F-H0-16034",839,2},
  {{{0x1149610eafd25ac7}},8,"F-H0-16035",543,4},
  {{{0xc6cf3c63e14d7a25}},5,"F-H0-16036",874,3},
  {{{0x3989573bd3ae1bd5}},6,"F-H0-16037",862,2},
  {{{0xbb95000e9581ccd8}},13,"F-H0-16038",506,3},
  {{{0xb64cc569874be97b}},6,"F-H0-16039",506,4},
  {{{0xa7bd35ff7593c4eb}},9,"F-H0-16040",419,4},
  {{{0x87be312b79f5d06e}},9,"F-H0-16041",763,2},
  {{{0xa68baaafdf0a8230}},11,"F-H0-16042",949,4},
  {{{0xd1e86232d54283a0}},21,"F-H0-16043",874,2},
  {{{0xecfeb425c0ad2b94}},6,"F-H0-16044",874,2},
  {{{0x54cd25daeb0ec313}},8,"F-H0-16045",506,2},
  {{{0x81b29a9dbebf6ff3}},14,"F-H0-16046",715,2},
  {{{0x6ebe248c09215295}},14,"F-H0-16047",941,2},
  {{{0x1e17139db742fef6}},2,"F-H0-16048",492,4},
  {{{0x2d7abf0aa9828c7b}},6,"F-H0-16049",908,2},
  {{{0x88c54d09adfed633}},9,"F-H0-16050",393,3},
  {{{0x71c86c1ffd3861c2}},17,"F-H0-16051",947,4},
  {{{0x3444c23dea52c072}},7,"F-H0-16052",421,3},
  {{{0x5752e62a82ce7c4e}},24,"F-H0-16053",529,4},
  {{{0xd8691f375caa3278}},5,"F-H0-16054",492,2},
  {{{0x34e622ce838696ec}},13,"F-H0-16055",655,2},
  {{{0x1ac5de669a040ec5}},7,"F-H0-16056",946,2},
  {{{0xd6582e8989546c18}},5,"F-H0-16057",863,3},
  {{{0x816a78366c82f111}},5,"F-H0-16058",457,3},
  {{{0x26545c8d186d7f61}},10,"F-H0-16059",456,4},
  {{{0x74881c855eda8274}},10,"F-H0-16060",872,3},
  {{{0x927a3419b7ee3ffd}},17,"F-H0-16061",939,4},
  {{{0x84fd382878e1722c}},14,"F-H0-16062",871,3},
  {{{0x60276e646b62ddae}},6,"F-H0-16063",541,3},
  {{{0x53962cbd4f170716}},9,"F-H0-16064",943,2},
  {{{0x9dcc8177e876bc3f}},9,"F-H0-16065",460,2},
  {{{0xf8e511646110edad}},7,"F-H0-16066",678,2},
  {{{0x8398c2e8b6c4d8c6}},10,"F-H0-16067",942,3},
  {{{0x93a6c120412ce0f2}},19,"F-H0-16068",790,2},
  {{{0x9ce04af6163edfcf}},18,"F-H0-16069",531,3},
  {{{0x3059c3b93731c10f}},4,"F-H0-16070",838,2},
  {{{0x93afd4c47d96f691}},11,"F-H0-16071",567,2},
  {{{0x6d8ba7cf7f8af762}},9,"F-H0-16072",458,4},
  {{{0x2764c5e3c9bae58c}},7,"F-H0-16073",419,4},
  {{{0x2bc155cae4dd719a}},11,"F-H0-16074",949,2},
  {{{0x7824a6b6b2bd79c1}},10,"F-H0-16075",914,3},
  {{{0xca3e9698c9a2f4f8}},12,"F-H0-16076",422,4},
  {{{0x2ca8a01d432b0843}},7,"F-H0-16077",678,2},
  {{{0xc18d43391b13bf00}},16,"F-H0-16078",727,2},
  {{{0x9951f9e8d6673b2b}},21,"F-H0-16079",462,2},
  {{{0x78e8c3a19591cedf}},14,"F-H0-16080",418,4},
  {{{0x483940fedd001dc5}},10,"F-H0-16081",802,3},
  {{{0xb80f064bb6d88d8f}},9,"F-H0-16082",913,4},
  {{{0x4d778d5740b68f}},6,"F-H0-16083",902,3},
  {{{0x69d3598ade88c415}},11,"F-H0-16084",427,2},
  {{{0x78b9aabe96aa8545}},15,"F-H0-16085",429,2},
  {{{0x78b9aabe96aa8545}},15,"F-H0-16086",503,2},
  {{{0xaa6abc95184d5cda}},17,"F-H0-16087",973,2},
  {{{0xe014476dfea7a44d}},10,"F-H0-16088",802,2},
  {{{0x6e977b00302f7529}},13,"F-H0-16089",432,3},
  {{{0x4b534b87f7d45ebf}},13,"F-H0-16090",678,3},
  {{{0x14cad114af4b972a}},6,"F-H0-16091",432,2},
  {{{0x950b2f4479d8953b}},17,"F-H0-16092",986,3},
  {{{0xb5fe5bf43b712146}},12,"F-H0-16093",837,3},
  {{{0xc94db5ada269293b}},12,"F-H0-16094",863,2},
  {{{0x131b248ffb1644e6}},12,"F-H0-16095",430,2},
  {{{0x5915486ea3240679}},8,"F-H0-16096",543,2},
  {{{0x667fdd9f0ceb58fe}},12,"F-H0-16097",985,4},
  {{{0xbb05fdc9c13169e9}},3,"F-H0-16098",468,2},
  {{{0xf45bf469e1011307}},21,"F-H0-16099",466,4},
  {{{0x8b3b477ea172935f}},12,"F-H0-16100",495,2},
  {{{0xe5a4f7ffb68de925}},9,"F-H0-16101",789,4},
  {{{0x85bb20d21e02f2e9}},9,"F-H0-16102",690,3},
  {{{0xf44ec6c9ed128f68}},7,"F-H0-16103",462,2},
  {{{0x659549174801ed9d}},8,"F-H0-16104",947,2},
  {{{0xcda11d6a1e159df0}},14,"F-H0-16105",949,2},
  {{{0xe0f4f9058f2317ab}},11,"F-H0-16106",838,3},
  {{{0x63903ee2381f517c}},6,"F-H0-16107",911,2},
  {{{0x672583dccf656a49}},7,"F-H0-16108",973,3},
  {{{0x9d7e9bf37c928181}},9,"F-H0-16109",873,3},
  {{{0x563a21177e89a44c}},8,"F-H0-16110",421,2},
  {{{0x92ad5f96d1446a46}},8,"F-H0-16111",504,3},
  {{{0x816aa8ff0197501a}},14,"F-H0-16112",974,3},
  {{{0xb0488b765b327c8b}},7,"F-H0-16113",912,2},
  {{{0xa20c7803f078033b}},7,"F-H0-16114",466,2},
  {{{0x426425b0fe262eb2}},13,"F-H0-16115",947,3},
  {{{0x74c659f39f92f303}},11,"F-H0-16116",942,3},
  {{{0xe047f24213c80aff}},7,"F-H0-16117",468,2},
  {{{0x8b0f0a7892e8c992}},8,"F-H0-16118",421,4},
  {{{0x3e1ccae754b35e1b}},9,"F-H0-16119",431,2},
  {{{0x3e1ccae754b35e1b}},9,"F-H0-16120",506,2},
  {{{0x24047f7086dcad8d}},9,"F-H0-16121",465,3},
  {{{0x721b1c9aeed0a2be}},9,"F-H0-16122",865,3},
  {{{0x79e0c7c5807bef5d}},9,"F-H0-16123",937,3},
  {{{0x1a2b24f7a838c248}},12,"F-H0-16124",972,3},
  {{{0x7d340588c0b4de90}},21,"F-H0-16125",764,4},
  {{{0xd48a24f856c01140}},3,"F-H0-16126",912,3},
  {{{0x267519e6886642bb}},14,"F-H0-16127",530,3},
  {{{0xd1ec2f080da8a459}},7,"F-H0-16128",976,3},
  {{{0x249923e869f622be}},12,"F-H0-16129",938,4},
  {{{0xe636a029d55ce823}},14,"F-H0-16130",393,2},
  {{{0x1263aab9c7718d6}},14,"F-H0-16131",869,2},
  {{{0xe578d3af985bf59e}},7,"F-H0-16132",827,4},
  {{{0x649dc7915dfedd79}},12,"F-H0-16133",433,4},
  {{{0x96b218d3c6080987}},7,"F-H0-16134",939,2},
  {{{0x978a5ddbadcd132b}},13,"F-H0-16135",975,4},
  {{{0x2b499aeba10f71c4}},18,"F-H0-16136",577,3},
  {{{0xa7b4d0ad9309f1c4}},10,"F-H0-16137",531,3},
  {{{0x7d1e406afdb68429}},10,"F-H0-16138",418,3},
  {{{0x2e91916034d2a958}},15,"F-H0-16139",418,2},
  {{{0xfb0fc1bd5dccf519}},21,"F-H0-16140",426,2},
  {{{0x578ee4bb7dcc0b75}},4,"F-H0-16141",947,2},
  {{{0xbe2f9dd80c0fa1f9}},7,"F-H0-16142",875,2},
  {{{0x9a4c790d9a1a2e2e}},3,"F-H0-16143",913,3},
  {{{0x6fe22a1216414c9c}},9,"F-H0-16144",529,3},
  {{{0xdc7c7073538db1c5}},7,"F-H0-16145",947,3},
  {{{0x4f8b49ec76b0146f}},12,"F-H0-16146",875,2},
  {{{0x4ad3f1bd55f055c5}},11,"F-H0-16147",715,3},
  {{{0x8b66435f48c226cb}},9,"F-H0-16148",541,3},
  {{{0x34ff70855fb0f397}},9,"F-H0-16149",420,2},
  {{{0x1c7d53ea1c25802d}},7,"F-H0-16150",865,4},
  {{{0xa8a9442f75ce617}},8,"F-H0-16151",529,3},
  {{{0xdf4cacd275719353}},7,"F-H0-16152",529,2},
  {{{0x774199ba0633c9a7}},8,"F-H0-16153",902,2},
  {{{0xe07220d4df283be3}},8,"F-H0-16154",432,3},
  {{{0x1a8de6183a5d9969}},8,"F-H0-16155",825,2},
  {{{0xa1ab932186d38eb4}},12,"F-H0-16156",862,4},
  {{{0x468d7fa13d82ee22}},7,"F-H0-16157",504,3},
  {{{0x16a61d263c5cc7fe}},6,"F-H0-16158",904,2},
  {{{0xed984e6d4ba12649}},8,"F-H0-16159",462,2},
  {{{0x23dcefb5acc71276}},16,"F-H0-16160",467,3},
  {{{0x748ce99b1638a139}},17,"F-H0-16161",871,2},
  {{{0xe4edbc58d37bc768}},6,"F-H0-16162",939,2},
  {{{0xc71e68eca54ede7f}},7,"F-H0-16163",950,3},
  {{{0x25cba2cad4b895a6}},12,"F-H0-16164",543,2},
  {{{0x6c0aa752212b38e2}},7,"F-H0-16165",542,2},
  {{{0x7b2a79bf4cf7f775}},16,"F-H0-16166",914,4},
  {{{0x5b464f8ab029adbe}},6,"F-H0-16167",876,2},
  {{{0x591efbd237e83ddd}},6,"F-H0-16168",903,2},
  {{{0x817128684d9c349b}},6,"F-H0-16169",690,2},
  {{{0x85d48c76a05f98e9}},7,"F-H0-16170",429,2},
  {{{0x70b701585b781132}},16,"F-H0-16171",465,2},
  {{{0xf59610bea25bbc12}},20,"F-H0-16172",841,3},
  {{{0x443a3d4d98d4c74a}},6,"F-H0-16173",986,2},
  {{{0x34ebe5bd4a19bd68}},11,"F-H0-16174",567,2},
  {{{0x6145e669c6105cd0}},21,"F-H0-16175",898,4},
  {{{0xe8308a4828ce4f47}},19,"F-H0-16176",903,3},
  {{{0x768453c55d3ed6d6}},14,"F-H0-16177",987,2},
  {{{0xa3378e4c5ae9b1a4}},10,"F-H0-16178",942,3},
  {{{0xcfb7ab6e18096b34}},10,"F-H0-16179",988,2},
  {{{0xc5dc992f58060f34}},7,"F-H0-16180",877,4},
  {{{0xd01785d709dc7038}},6,"F-H0-16181",839,3},
  {{{0x1e695f3606c25cf8}},16,"F-H0-16182",495,2},
  {{{0xf88511e2844892bc}},10,"F-H0-16183",910,2},
  {{{0x9ea8cfc3306e087a}},11,"F-H0-16184",910,3},
  {{{0x7c3a168b98afe3af}},13,"F-H0-16185",914,4},
  {{{0xd9d237b6f4ff48}},4,"F-H0-16186",419,3},
  {{{0x69cc0912add544cf}},14,"F-H0-16187",946,4},
  {{{0x65671ed3ee6c2c67}},3,"F-H0-16188",493,2},
  {{{0x16cd10e270f14f13}},8,"F-H0-16189",568,2},
  {{{0xe960fcfff2a88714}},10,"F-H0-16190",912,3},
  {{{0x42c6c35d12e1b56b}},16,"F-H0-16191",947,2},
  {{{0xbd1f188b49ef40db}},4,"F-H0-16192",466,2},
  {{{0xd938dad40b9fb88b}},11,"F-H0-16193",604,3},
  {{{0x9b81677e5c86cf6f}},3,"F-H0-16194",937,2},
  {{{0xace5cbd7df03517e}},7,"F-H0-16195",541,4},
  {{{0x4fa2840ef5aaf24a}},16,"F-H0-16196",432,4},
  {{{0xa65af6e1b2d5b344}},13,"F-H0-16197",544,3},
  {{{0xe6d2bfd4c9f537a1}},6,"F-H0-16198",418,4},
  {{{0xa65692a54b22a659}},6,"F-H0-16199",909,2},
  {{{0xeac1a237acefe95c}},6,"F-H0-16200",566,4},
  {{{0xfb9d23871cde83fc}},7,"F-H0-16201",492,4},
  {{{0x9ea14c4da5c09d6a}},8,"F-H0-16202",418,3},
  {{{0x320510a40e9ef59a}},8,"F-H0-16203",876,4},
  {{{0x1c53adeebddbe10}},7,"F-H0-16204",421,2},
  {{{0x46386a574e0ee917}},9,"F-H0-16205",801,2},
  {{{0x15d6b8db9b839bfb}},9,"F-H0-16206",873,2},
  {{{0x366f3edb68a82468}},9,"F-H0-16207",566,4},
  {{{0xdeb234cd8395b2d4}},10,"F-H0-16208",837,4},
  {{{0x9697172356e4c69a}},8,"F-H0-16209",615,3},
  {{{0xd8fbac19d0370ea6}},15,"F-H0-16210",430,3},
  {{{0x4cebbe5831dfe53}},9,"F-H0-16211",464,2},
  {{{0x1fbc40cfd0221354}},5,"F-H0-16212",939,2},
  {{{0x169af1937d8d9120}},9,"F-H0-16213",913,4},
  {{{0x39aa1ed46a0c2074}},8,"F-H0-16214",826,4},
  {{{0xecfd6d37d7e3822b}},8,"F-H0-16215",874,2},
  {{{0xecfd6d37d7e3822b}},8,"F-H0-16216",912,2},
  {{{0x74542570030d3f7f}},7,"F-H0-16217",458,2},
  {{{0x224df56e4f026f3}},3,"F-H0-16218",937,2},
  {{{0xb8793e26a96c5917}},3,"F-H0-16219",468,2},
  {{{0xafdd849fdf35f561}},6,"F-H0-16220",543,2},
  {{{0x3e7b34631d53b8fc}},11,"F-H0-16221",466,3},
  {{{0x737058ad0d0cdd84}},7,"F-H0-16222",838,3},
  {{{0xf367f741a2d30eea}},15,"F-H0-16223",987,3},
  {{{0x7f4e1a252d4aadb7}},3,"F-H0-16224",901,2},
  {{{0xa15e39782f3cf595}},9,"F-H0-16225",861,2},
  {{{0x241717b148c0fff2}},16,"F-H0-16226",503,3},
  {{{0x133d44bfda3b159d}},8,"F-H0-16227",939,3},
  {{{0x8513cf806cceb62c}},6,"F-H0-16228",906,2},
  {{{0x1ef684d6e56eada}},9,"F-H0-16229",974,2},
  {{{0x69867f58230aff73}},8,"F-H0-16230",914,2},
  {{{0x502f190e0d76db4b}},13,"F-H0-16231",652,2},
  {{{0x78d3af8e784a09fe}},12,"F-H0-16232",936,3},
  {{{0xe44e066b4e246530}},16,"F-H0-16233",502,2},
  {{{0xc54b1eec7a60b941}},11,"F-H0-16234",945,3},
  {{{0x9ba45353af15a87a}},11,"F-H0-16235",874,4},
  {{{0x39448197fdbb214f}},13,"F-H0-16236",506,4},
  {{{0x19590e2c299a0855}},7,"F-H0-16237",910,4},
  {{{0x31945106207b05ee}},10,"F-H0-16238",728,2},
  {{{0x5f91582ca76c48c2}},20,"F-H0-16239",867,4},
  {{{0x50973d8c873aaae7}},8,"F-H0-16240",653,2},
  {{{0x5eb9c3d047876bfa}},7,"F-H0-16241",542,3},
  {{{0xcd0b3f01869697de}},4,"F-H0-16242",863,2},
  {{{0xb675a3670574c3e1}},5,"F-H0-16243",943,2},
  {{{0xf54d5b37616f7fb5}},6,"F-H0-16244",567,3},
  {{{0xeedbf2cf541652a}},8,"F-H0-16245",678,2},
  {{{0x53c1d41e63431844}},10,"F-H0-16246",654,2},
  {{{0xae810e1e0a5488a6}},8,"F-H0-16247",949,4},
  {{{0xb201eb1982ad2f01}},8,"F-H0-16248",616,2},
  {{{0xb201eb1982ad2f01}},8,"F-H0-16249",654,2},
  {{{0xb556ead78bf62915}},5,"F-H0-16250",838,2},
  {{{0x5f6ad72b0f4e77a8}},8,"F-H0-16251",429,2},
  {{{0x45bafcab8888ebee}},9,"F-H0-16252",984,3},
  {{{0x24644e8aacc90fbc}},12,"F-H0-16253",909,3},
  {{{0xa982f31ee3f9a8c4}},7,"F-H0-16254",936,3},
  {{{0xed54ed85e91e15a9}},16,"F-H0-16255",429,3},
  {{{0x56eb0f1473463257}},3,"F-H0-16256",493,2},
  {{{0x56eb0f1473463257}},3,"F-H0-16257",494,2},
  {{{0x60b3225e825ee706}},7,"F-H0-16258",912,4},
  {{{0x4a998034714abc6a}},9,"F-H0-16259",974,2},
  {{{0xee17c34f2cad944}},6,"F-H0-16260",837,3},
  {{{0x2334c1f884129f10}},7,"F-H0-16261",690,3},
  {{{0x4cd5b4c1d8deb547}},12,"F-H0-16262",951,4},
  {{{0x961a2ea521b24df0}},10,"F-H0-16263",942,3},
  {{{0x3d7b8899833e4432}},7,"F-H0-16264",530,4},
  {{{0x109570e019b7c51b}},10,"F-H0-16265",985,3},
  {{{0xe2d59e97eaff07a0}},12,"F-H0-16266",839,2},
  {{{0x6c59ae58da08983d}},9,"F-H0-16267",950,2},
  {{{0x6580659b3bafb513}},4,"F-H0-16268",875,2},
  {{{0x19e7125a1e32a471}},4,"F-H0-16269",543,2},
  {{{0x76bb46473f599b51}},11,"F-H0-16270",677,2},
  {{{0xb5cbf06a3fc02c87}},8,"F-H0-16271",716,2},
  {{{0x467f40915031db8d}},5,"F-H0-16272",492,2},
  {{{0xcd94df06a3d745b8}},8,"F-H0-16273",454,3},
  {{{0xce1c9764b9c752b3}},6,"F-H0-16274",789,2},
  {{{0xda4cd86a8efb7900}},7,"F-H0-16275",457,4},
  {{{0x988d78d240225ce6}},9,"F-H0-16276",503,2},
  {{{0xe766d769f19ac84e}},9,"F-H0-16277",491,4},
  {{{0xe584f14fcec6fa04}},9,"F-H0-16278",727,3},
  {{{0x997a9aa5e71277b7}},8,"F-H0-16279",937,4},
  {{{0x381fe02186734e73}},11,"F-H0-16280",507,4},
  {{{0xb875bb8fdc9e3532}},6,"F-H0-16281",873,3},
  {{{0xd3ff032c69ff6c1b}},21,"F-H0-16282",977,2},
  {{{0x23471cadc5d68f71}},5,"F-H0-16283",418,3},
  {{{0xb750dbfd0b1fa460}},9,"F-H0-16284",911,4},
  {{{0x5d2b1385a63863b4}},3,"F-H0-16285",900,3},
  {{{0x281259c7f483ef49}},5,"F-H0-16286",455,3},
  {{{0xa9c370ba56b7b532}},13,"F-H0-16287",912,3},
  {{{0xc6c518209e946440}},7,"F-H0-16288",825,2},
  {{{0xa2d7477181c5cd24}},23,"F-H0-16289",868,2},
  {{{0xb97402ecfdc70772}},4,"F-H0-16290",874,2},
  {{{0xf1a9595fbc17b76f}},17,"F-H0-16291",765,4},
  {{{0x2b5a83f62a323315}},10,"F-H0-16292",655,4},
  {{{0xb966c9f9992b1072}},10,"F-H0-16293",910,2},
  {{{0xe5b3e9a5fa04c7d9}},13,"F-H0-16294",875,2},
  {{{0xe5b3e9a5fa04c7d9}},13,"F-H0-16295",838,2},
  {{{0xb93dffd1a6d8b53d}},5,"F-H0-16296",469,2},
  {{{0x3680a6382f035a4}},6,"F-H0-16297",876,4},
  {{{0xd5222cbc61e2334c}},10,"F-H0-16298",427,2},
  {{{0x5858838ccc4f8ef2}},8,"F-H0-16299",872,2},
  {{{0xc400d01bf9f25a0a}},9,"F-H0-16300",902,4},
  {{{0x723f479765ef58ff}},12,"F-H0-16301",910,2},
  {{{0x193f22b8590161ef}},12,"F-H0-16302",950,4},
  {{{0x54680730b06d0f12}},9,"F-H0-16303",936,4},
  {{{0x3970c6d0464f4735}},11,"F-H0-16304",765,4},
  {{{0x7ddff63f53999760}},10,"F-H0-16305",538,3},
  {{{0x2c2c5369e8be0265}},20,"F-H0-16306",950,3},
  {{{0x960657bb224b12dc}},8,"F-H0-16307",941,3},
  {{{0x1be76b7e319ffaf0}},3,"F-H0-16308",456,3},
  {{{0xda55fd377c1e06d5}},9,"F-H0-16309",714,4},
  {{{0x5373c07a9f64a11a}},9,"F-H0-16310",876,2},
  {{{0xb154de1f6c9593e5}},10,"F-H0-16311",949,3},
  {{{0x70ce94b0dd6f64b9}},7,"F-H0-16312",913,2},
  {{{0x3ee11a55cfe0565c}},7,"F-H0-16313",433,2},
  {{{0x64ce4aa08cc83be7}},2,"F-H0-16314",912,4},
  {{{0xa20de006916359e5}},8,"F-H0-16315",912,4},
  {{{0x496d31c83ff800f5}},16,"F-H0-16316",905,2},
  {{{0x496d31c83ff800f5}},16,"F-H0-16317",825,2},
  {{{0x6568f72413483ad7}},6,"F-H0-16318",862,2},
  {{{0x4d5f8ee5add936e2}},15,"F-H0-16319",714,2},
  {{{0x1a85cc225b66109}},13,"F-H0-16320",455,2},
  {{{0x51c733b418e9bb4f}},8,"F-H0-16321",432,3},
  {{{0xc333f462187d4e29}},10,"F-H0-16322",825,2},
  {{{0x24f897eb9c79d870}},5,"F-H0-16323",764,2},
  {{{0xf5a82b5409c3339e}},10,"F-H0-16324",942,3},
  {{{0x8ea7d76dcddd1b7b}},12,"F-H0-16325",715,2},
  {{{0xa1d6ebd4ab327d47}},12,"F-H0-16326",530,2},
  {{{0x97a92fc28a5a22ae}},14,"F-H0-16327",988,4},
  {{{0xb3c8eae56af3ec83}},8,"F-H0-16328",431,3},
  {{{0x53d6abacdd5c85ee}},10,"F-H0-16329",909,3},
  {{{0xd20ed077a4765325}},10,"F-H0-16330",947,3},
  {{{0xf4098153626e9854}},5,"F-H0-16331",421,2},
  {{{0x447205644943733d}},6,"F-H0-16332",690,2},
  {{{0x10881cec7c5bb9b8}},6,"F-H0-16333",898,2},
  {{{0xae738a259dc513a2}},9,"F-H0-16334",837,3},
  {{{0xc914688d01d733b3}},14,"F-H0-16335",836,3},
  {{{0xcb4f248d4168f15}},8,"F-H0-16336",875,2},
  {{{0xa60f88b0c51cbb5e}},14,"F-H0-16337",579,3},
  {{{0x732c852b6d73d580}},10,"F-H0-16338",579,2},
  {{{0x564c95df1ae536c}},6,"F-H0-16339",912,2},
  {{{0x1d2a985aa52b3283}},8,"F-H0-16340",503,2},
  {{{0x19d720ed35234a25}},9,"F-H0-16341",492,4},
  {{{0xaed2ab40cb122d17}},11,"F-H0-16342",469,2},
  {{{0x8ba4901682d8b07f}},9,"F-H0-16343",865,2},
  {{{0x8ba4901682d8b07f}},9,"F-H0-16344",936,2},
  {{{0x379a7e1c4d3ae0e1}},5,"F-H0-16345",504,2},
  {{{0xcc6edf26ec9111a1}},6,"F-H0-16346",493,2},
  {{{0xcadf6a8d2f650c2c}},11,"F-H0-16347",910,3},
  {{{0x394f6f7b7b31e3b4}},14,"F-H0-16348",983,4},
  {{{0x8f5ebc3850eaae1a}},13,"F-H0-16349",836,3},
  {{{0x2db212f2e6622975}},5,"F-H0-16350",454,2},
  {{{0x62bc013bdadbebe5}},9,"F-H0-16351",947,3},
  {{{0xb0c03d07d44c781}},8,"F-H0-16352",502,2},
  {{{0xe8b271afab8225c0}},8,"F-H0-16353",420,2},
  {{{0x32cd25924b6875c1}},8,"F-H0-16354",938,4},
  {{{0xf4c5044b3de62dc4}},10,"F-H0-16355",654,3},
  {{{0xc00c608eea5d06dd}},19,"F-H0-16356",872,3},
  {{{0xfc1147260f9c9289}},11,"F-H0-16357",937,4},
  {{{0xc2ecec1267da53da}},9,"F-H0-16358",948,2},
  {{{0xc2ecec1267da53da}},9,"F-H0-16359",874,2},
  {{{0x53d2e53b99232b26}},13,"F-H0-16360",458,3},
  {{{0x8169be379f3edf0b}},18,"F-H0-16361",946,3},
  {{{0x64d9385f36e67354}},11,"F-H0-16362",835,3},
  {{{0xd1f3df8508d2df59}},10,"F-H0-16363",949,4},
  {{{0xba62d8e609156c1e}},8,"F-H0-16364",429,4},
  {{{0xa9ee1ff0cfae8319}},10,"F-H0-16365",837,3},
  {{{0x61e02059a9d3bcbc}},5,"F-H0-16366",949,2},
  {{{0x2e2dacc26038a319}},10,"F-H0-16367",950,2},
  {{{0x2e2dacc26038a319}},10,"F-H0-16368",875,2},
  {{{0xef4b18f047ba5eef}},6,"F-H0-16369",950,2},
  {{{0xef4b18f047ba5eef}},6,"F-H0-16370",910,2},
  {{{0xf004bbab471a5023}},6,"F-H0-16371",531,2},
  {{{0xdcc8ee0f6e54666e}},8,"F-H0-16372",949,2},
  {{{0xdcc8ee0f6e54666e}},8,"F-H0-16373",951,2},
  {{{0x2cb029975b5a6912}},9,"F-H0-16374",939,2},
  {{{0x88c6825128defd7}},4,"F-H0-16375",421,2},
  {{{0x7373da79f475bce7}},16,"F-H0-16376",839,4},
  {{{0xec627bb21039109e}},10,"F-H0-16377",459,2},
  {{{0x15ac4c75e00f9fd9}},12,"F-H0-16378",457,3},
  {{{0xfd39157aac343ba2}},10,"F-H0-16379",863,4},
  {{{0x2c9d2cd15e1b348f}},8,"F-H0-16380",470,3},
  {{{0xcc62b9e3d672cd28}},11,"F-H0-16381",788,2},
  {{{0x78a694b909628b53}},7,"F-H0-16382",900,2},
  {{{0x6038bc326028cd2e}},6,"F-H0-16383",464,3},
  {{{0x32bdf35a95b8c93c}},7,"F-H0-16384",421,3},
  {{{0xf9b2b4f28954b00}},5,"F-H0-16385",950,3},
  {{{0xfb41937d41544892}},13,"F-H0-16386",867,4},
  {{{0xf2ae99c7089c4de5}},3,"F-H0-16387",949,2},
  {{{0x1bb9ffc5527c49e9}},3,"F-H0-16388",863,2},
  {{{0xa5a6ac50a7fc134e}},8,"F-H0-16389",424,3},
  {{{0x5e6d7e633a2ee57}},8,"F-H0-16390",579,3},
  {{{0x186338d7ddf6a563}},3,"F-H0-16391",838,3},
  {{{0xa506110b13aa60a0}},7,"F-H0-16392",531,2},
  {{{0xa6bc3d082127e11e}},7,"F-H0-16393",432,2},
  {{{0xb8e2faf395a66ca9}},9,"F-H0-16394",873,4},
  {{{0x1a83034f598a15f6}},6,"F-H0-16395",751,2},
  {{{0x2ba56ec3fd8e7d82}},8,"F-H0-16396",863,4},
  {{{0x8ff9a09e6bd40a64}},14,"F-H0-16397",985,4},
  {{{0x4c282cbd3c80990e}},9,"F-H0-16398",567,2},
  {{{0xec645f0bf0602484}},6,"F-H0-16399",457,2},
  {{{0x737b4828f46fb787}},6,"F-H0-16400",530,2},
  {{{0x2e0ccaa0efae3a92}},11,"F-H0-16401",949,4},
  {{{0x21940d0087bb5bf2}},10,"F-H0-16402",424,2},
  {{{0xe5020d8e3394da8}},19,"F-H0-16403",838,2},
  {{{0xd8e1c50ff8f121cb}},9,"F-H0-16404",865,4},
  {{{0x2b86b95598ea5d6a}},8,"F-H0-16405",899,4},
  {{{0x6cbca9ea9905b15d}},16,"F-H0-16406",421,4},
  {{{0x52caf4981939192}},18,"F-H0-16407",905,2},
  {{{0x569ad192ce1368d}},7,"F-H0-16408",641,2},
  {{{0xa9f334583c24b51e}},8,"F-H0-16409",913,4},
  {{{0x69b1238d25fc2c9b}},13,"F-H0-16410",764,4},
  {{{0x30425e28eca156d5}},11,"F-H0-16411",988,3},
  {{{0x2a2aaf687e2753cd}},8,"F-H0-16412",431,3},
  {{{0xe72bb1f1974c2566}},9,"F-H0-16413",909,3},
  {{{0x8812e63bff6e3f4e}},10,"F-H0-16414",529,2},
  {{{0x215c45af55321a96}},8,"F-H0-16415",543,2},
  {{{0x8c9123618623c465}},13,"F-H0-16416",913,4},
  {{{0xab8d48bb39c62d06}},7,"F-H0-16417",469,2},
  {{{0x52e2b3e817cdde81}},8,"F-H0-16418",947,2},
  {{{0xc3d1e7ee50c84ba2}},3,"F-H0-16419",912,2},
  {{{0xc3d1e7ee50c84ba2}},3,"F-H0-16420",456,2},
  {{{0x9e790699daa784c}},11,"F-H0-16421",469,4},
  {{{0xe1842b8cfe7acd2d}},18,"F-H0-16422",790,2},
  {{{0x3247bbb5f2dbd589}},13,"F-H0-16423",898,2},
  {{{0x49675dc469512bef}},5,"F-H0-16424",541,2},
  {{{0xefb8133111b70c70}},8,"F-H0-16425",765,2},
  {{{0x1c12f54b899c4cc3}},23,"F-H0-16426",982,4},
  {{{0x822aff33a24c1c67}},7,"F-H0-16427",838,4},
  {{{0x4811b786afa80a85}},10,"F-H0-16428",827,2},
  {{{0xeb5bdfc5d7ea76e0}},10,"F-H0-16429",838,2},
  {{{0x11be87bcb670224f}},16,"F-H0-16430",383,3},
  {{{0xcabb3c3faaa4ccd5}},10,"F-H0-16431",839,4},
  {{{0xfcd63966011b283a}},4,"F-H0-16432",678,2},
  {{{0x332e42b719294d51}},12,"F-H0-16433",504,2},
  {{{0x2b1f899fcf44f6cb}},8,"F-H0-16434",901,4},
  {{{0xa8a5ae2931a03f23}},9,"F-H0-16435",950,2},
  {{{0x9e301f0d037b1058}},16,"F-H0-16436",654,2},
  {{{0x8e39c3f239caf912}},17,"F-H0-16437",837,3},
  {{{0x46ca9bfe828268c9}},12,"F-H0-16438",433,3},
  {{{0xfebf03fa1867f983}},2,"F-H0-16439",900,2},
  {{{0x41bd2e591e52f888}},3,"F-H0-16440",455,3},
  {{{0x9c84378dc272844e}},9,"F-H0-16441",825,2},
  {{{0x5eeb3d17356a29ee}},10,"F-H0-16442",567,3},
  {{{0x5ce0efa7c8688191}},9,"F-H0-16443",903,3},
  {{{0x7d7780c40900a9b8}},6,"F-H0-16444",899,2},
  {{{0x10c999c765ab1411}},17,"F-H0-16445",951,2},
  {{{0xaf270f4c232f5abc}},9,"F-H0-16446",950,2},
  {{{0xfa79ba49c94f1237}},16,"F-H0-16447",946,3},
  {{{0x5d84e9ea7e71d48b}},5,"F-H0-16448",944,2},
  {{{0x64b2dc3603f5747a}},18,"F-H0-16449",950,4},
  {{{0xd1784c256561eec8}},6,"F-H0-16450",616,2},
  {{{0xd1784c256561eec8}},6,"F-H0-16451",466,2},
  {{{0x1870c79b0002628f}},8,"F-H0-16452",986,2},
  {{{0x69097a2ca49cb61f}},5,"F-H0-16453",906,2},
  {{{0xfbe22061ef423d98}},17,"F-H0-16454",502,4},
  {{{0x62a464b562f90423}},8,"F-H0-16455",432,3},
  {{{0x14b9cef5e3b83f04}},16,"F-H0-16456",875,2},
  {{{0x3194ac38e1ba7743}},8,"F-H0-16457",419,4},
  {{{0x4db1ffc4f1631a6a}},11,"F-H0-16458",949,2},
  {{{0x492264bbc272237d}},4,"F-H0-16459",876,2},
  {{{0x1a4e942441242e83}},8,"F-H0-16460",827,2},
  {{{0x605f4167a6d6f97d}},8,"F-H0-16461",863,2},
  {{{0xb9ff74e33e421352}},21,"F-H0-16462",766,2},
  {{{0x2972645eb94c6c85}},11,"F-H0-16463",865,2},
  {{{0xfb2b1a4ef37ab9b0}},7,"F-H0-16464",939,2},
  {{{0x2bf7949f57f5a683}},7,"F-H0-16465",466,2},
  {{{0x1783b4e34362aa88}},11,"F-H0-16466",391,2},
  {{{0xc8e4a5b1d3db1728}},9,"F-H0-16467",975,3},
  {{{0x1847c3ca3cd11eef}},17,"F-H0-16468",946,3},
  {{{0x7af2fd8bc076cf2c}},19,"F-H0-16469",906,2},
  {{{0xae7f656bc3ae2daf}},9,"F-H0-16470",420,2},
  {{{0x6a83c29e71423479}},11,"F-H0-16471",947,3},
  {{{0xb0ffaf559a22ec9e}},22,"F-H0-16472",835,4},
  {{{0x6b6aef41a2767c3e}},17,"F-H0-16473",494,3},
  {{{0xf00eb8f4539dac2}},14,"F-H0-16474",876,3},
  {{{0x87870dcef05fed03}},10,"F-H0-16475",495,2},
  {{{0xfa3eab8d492e8d61}},17,"F-H0-16476",898,2},
  {{{0x603f608c191351d4}},21,"F-H0-16477",839,4},
  {{{0x42b97b177e778d52}},6,"F-H0-16478",939,2},
  {{{0xcefb64ed437d6275}},8,"F-H0-16479",605,3},
  {{{0x8b99d8680e24d2ad}},24,"F-H0-16480",986,3},
  {{{0x90bc0b44a94f215e}},13,"F-H0-16481",491,4},
  {{{0xc76495e87e83c16a}},8,"F-H0-16482",419,4},
  {{{0x15a83d43e8353019}},8,"F-H0-16483",901,3},
  {{{0xea1973dbbce372e}},14,"F-H0-16484",542,2},
  {{{0x6bf740afae356189}},14,"F-H0-16485",939,2},
  {{{0xe0ff1fe7d7ec4ed0}},9,"F-H0-16486",837,2},
  {{{0xb64e94773bb9d510}},5,"F-H0-16487",802,2},
  {{{0x61869e283869b53b}},7,"F-H0-16488",939,3},
  {{{0x85db242f571b9c00}},7,"F-H0-16489",417,4},
  {{{0x4bcde58f5e4617d5}},11,"F-H0-16490",874,4},
  {{{0x18a17f38117136d6}},10,"F-H0-16491",655,3},
  {{{0x343ec081d1080eb7}},23,"F-H0-16492",907,2},
  {{{0x2c33638d1e73e521}},9,"F-H0-16493",940,2},
  {{{0x905db96943ec540d}},11,"F-H0-16494",467,4},
  {{{0x8b0faf8dcbadd7d7}},5,"F-H0-16495",912,3},
  {{{0xb4d83e35f24464d5}},12,"F-H0-16496",580,3},
  {{{0x9c43f60409b5a18f}},22,"F-H0-16497",751,4},
  {{{0x5b4f9ffef475d5cb}},8,"F-H0-16498",579,4},
  {{{0x696cb1b09e9fa494}},9,"F-H0-16499",384,3},
  {{{0xc8a8a77a084bd8e0}},8,"F-H0-16500",838,4},
  {{{0x62b7578027467357}},7,"F-H0-16501",419,3},
  {{{0x5f186e62240c93cf}},9,"F-H0-16502",418,2},
  {{{0x4eefec8c48152b0}},14,"F-H0-16503",834,4},
  {{{0xb63a57c02e5b4ba4}},6,"F-H0-16504",825,3},
  {{{0xf13b8211ebf282b7}},11,"F-H0-16505",825,4},
  {{{0x3f11c42e26197962}},7,"F-H0-16506",678,3},
  {{{0x9d3fe7f5a626ae37}},9,"F-H0-16507",876,4},
  {{{0x67d109abb789d35c}},14,"F-H0-16508",877,4},
  {{{0xcb6834b240a007b0}},12,"F-H0-16509",908,2},
  {{{0xc17f6fe7f2986038}},8,"F-H0-16510",912,4},
  {{{0x6cf13cae0fb5dbb7}},5,"F-H0-16511",466,4},
  {{{0x4c42452d633eb804}},9,"F-H0-16512",899,3},
  {{{0x96ce10f71a0e149a}},6,"F-H0-16513",678,3},
  {{{0xa416b72fc92928f}},9,"F-H0-16514",873,2},
  {{{0x70480248b556431d}},18,"F-H0-16515",910,2},
  {{{0x50c884b068c49407}},10,"F-H0-16516",528,4},
  {{{0xd8d75fd176665777}},7,"F-H0-16517",949,3},
  {{{0x2447ff4d8fafe193}},6,"F-H0-16518",418,2},
  {{{0x2447ff4d8fafe193}},6,"F-H0-16519",529,2},
  {{{0x9ad6a5686bc756c1}},10,"F-H0-16520",938,2},
  {{{0x138c78f0675194c0}},9,"F-H0-16521",541,3},
  {{{0xb2927efd71066523}},9,"F-H0-16522",876,2},
  {{{0x47da9bce195d457d}},9,"F-H0-16523",418,2},
  {{{0xa4875a8b26294fbc}},9,"F-H0-16524",466,2},
  {{{0x3b487c036918d656}},6,"F-H0-16525",425,3},
  {{{0x3aab662e7afb36d0}},5,"F-H0-16526",943,3},
  {{{0x1569ecfa92da564e}},10,"F-H0-16527",935,4},
  {{{0x5395c139568c125c}},17,"F-H0-16528",950,2},
  {{{0xea8f2dde565ab7dc}},10,"F-H0-16529",839,4},
  {{{0x7429ab95ba9de3f2}},8,"F-H0-16530",530,3},
  {{{0xc11f1ed85f658d61}},13,"F-H0-16531",431,2},
  {{{0x62cca1d46ec887ae}},8,"F-H0-16532",945,2},
  {{{0xd372873a05f0118c}},9,"F-H0-16533",875,2},
  {{{0x6fc36e8f0c074300}},15,"F-H0-16534",871,3},
  {{{0xd8a96838d28e086e}},7,"F-H0-16535",905,2},
  {{{0xff9cc1ebe9fc1ec3}},7,"F-H0-16536",678,2},
  {{{0xcbff8f7ad0185e99}},18,"F-H0-16537",866,4},
  {{{0x130148a8b1d4d6b5}},6,"F-H0-16538",911,4},
  {{{0x60981b896bb677a8}},5,"F-H0-16539",911,3},
  {{{0xe9a5ae3361185b22}},9,"F-H0-16540",460,2},
  {{{0x60b1dba9d4c52cac}},19,"F-H0-16541",988,3},
  {{{0xe352e5f756394d32}},22,"F-H0-16542",984,3},
  {{{0xb08fdfa2357a8f5a}},6,"F-H0-16543",727,2},
  {{{0x7b41c3021516123b}},10,"F-H0-16544",913,3},
  {{{0xa737ec19b1c1c8fb}},3,"F-H0-16545",468,2},
  {{{0xa0703c2343d996dd}},8,"F-H0-16546",874,4},
  {{{0xdc3dedc0c23f810f}},8,"F-H0-16547",941,2},
  {{{0xdc3dedc0c23f810f}},8,"F-H0-16548",788,2},
  {{{0x2c18c8158f9f2c}},5,"F-H0-16549",949,2},
  {{{0xe3a0a75f6faaf170}},7,"F-H0-16550",906,2},
  {{{0xfa1a9c6949572afa}},22,"F-H0-16551",1021,4},
  {{{0xbdcfb06e04e04945}},11,"F-H0-16552",678,4},
  {{{0xbace61b8ee49a3e4}},11,"F-H0-16553",507,3},
  {{{0x1b89ea17b118af85}},7,"F-H0-16554",902,3},
  {{{0xfe503cef92184b34}},20,"F-H0-16555",835,2},
  {{{0xefae1d80305006ef}},4,"F-H0-16556",938,2},
  {{{0xaa608f03dc3acc25}},11,"F-H0-16557",713,4},
  {{{0x822d27ac38ac9eb7}},13,"F-H0-16558",937,2},
  {{{0xd52b66140a4ce2fc}},7,"F-H0-16559",873,2},
  {{{0x60bdc7e116467b5e}},6,"F-H0-16560",580,2},
  {{{0xb2d2ed6e7eabb094}},13,"F-H0-16561",950,3},
  {{{0x1a5fe1f2008d4fb5}},16,"F-H0-16562",394,4},
  {{{0x22ac9b1498832f67}},11,"F-H0-16563",424,2},
  {{{0x99dbcacd8feb6c8d}},14,"F-H0-16564",838,4},
  {{{0x8131847d4728a3fd}},9,"F-H0-16565",604,3},
  {{{0x5754420906c187d6}},18,"F-H0-16566",578,2},
  {{{0xb49180a17ac3470c}},7,"F-H0-16567",936,2},
  {{{0xe6867cd67f899994}},10,"F-H0-16568",876,3},
  {{{0xaa19beec161fccbe}},5,"F-H0-16569",913,3},
  {{{0x16afa57fb156a637}},6,"F-H0-16570",678,3},
  {{{0x80a1014d89ab5c88}},8,"F-H0-16571",945,2},
  {{{0xb5d5a99ba5fbd808}},19,"F-H0-16572",911,3},
  {{{0x128f8a1613ed4585}},5,"F-H0-16573",492,2},
  {{{0x673d206a74ac00f1}},10,"F-H0-16574",541,3},
  {{{0xaa15a2c62620ab2d}},7,"F-H0-16575",838,3},
  {{{0x7a3d28e234e8f8a5}},12,"F-H0-16576",433,2},
  {{{0x9cdab4f673fc2ca3}},18,"F-H0-16577",464,2},
  {{{0x90de6ab8b7be63e8}},5,"F-H0-16578",863,2},
  {{{0xdd7bb6218f050210}},13,"F-H0-16579",835,4},
  {{{0x5e389143d0398ef2}},7,"F-H0-16580",937,2},
  {{{0x111445d37e0a822d}},4,"F-H0-16581",468,4},
  {{{0xbc5f0214d101cb35}},6,"F-H0-16582",908,2},
  {{{0xafd002c4d031cf15}},7,"F-H0-16583",466,2},
  {{{0x5d25625028a03a94}},6,"F-H0-16584",616,2},
  {{{0xfd4ae374e6a418e4}},7,"F-H0-16585",837,2},
  {{{0xb24eb5aa750bc601}},9,"F-H0-16586",877,3},
  {{{0x818bba53b6bf9add}},9,"F-H0-16587",459,4},
  {{{0x7fc0dc6498465de}},3,"F-H0-16588",456,3},
  {{{0x4a74ed7d7c82c7db}},9,"F-H0-16589",491,4},
  {{{0x98ec3efbe3293a10}},5,"F-H0-16590",458,3},
  {{{0xbca06c84583af394}},14,"F-H0-16591",465,3},
  {{{0x9a7d97bcc1173554}},8,"F-H0-16592",458,2},
  {{{0xe9bceaf930374daa}},10,"F-H0-16593",941,3},
  {{{0x17b296973bb6832e}},13,"F-H0-16594",905,3},
  {{{0xdafe3147c18f58ac}},4,"F-H0-16595",874,2},
  {{{0x1fd7bbe910aece8e}},9,"F-H0-16596",467,2},
  {{{0x54fb04b7841acb0e}},14,"F-H0-16597",948,2},
  {{{0x97891c2f3621827e}},21,"F-H0-16598",983,4},
  {{{0x6cb01aad0762d176}},9,"F-H0-16599",949,4},
  {{{0x44c5c45fbfa2fdc7}},13,"F-H0-16600",984,3},
  {{{0xde4b0e6cb1f9346e}},22,"F-H0-16601",875,2},
  {{{0xde4b0e6cb1f9346e}},22,"F-H0-16602",578,2},
  {{{0xe1a3896e74c13a4d}},6,"F-H0-16603",455,2},
  {{{0x9b9b12f5817ec19d}},6,"F-H0-16604",951,2},
  {{{0xe8d49c9368f1ebb1}},11,"F-H0-16605",875,4},
  {{{0x8c57ddc5e4db56da}},6,"F-H0-16606",945,3},
  {{{0x28b7b713391662a0}},8,"F-H0-16607",418,2},
  {{{0x7b448fa339896c62}},5,"F-H0-16608",542,2},
  {{{0x7eac93ade3b02bfd}},4,"F-H0-16609",456,2},
  {{{0x6736a91f6ce96d3b}},6,"F-H0-16610",541,2},
  {{{0xcf2eacad22f63ff1}},7,"F-H0-16611",690,3},
  {{{0x81ae61051c1a260f}},10,"F-H0-16612",949,2},
  {{{0x81ae61051c1a260f}},10,"F-H0-16613",945,2},
  {{{0x22a993c7858509f}},13,"F-H0-16614",690,2},
  {{{0x6cb69ca27bb56424}},13,"F-H0-16615",974,3},
  {{{0x9ed8e4594a80009a}},9,"F-H0-16616",905,4},
  {{{0x5944ae5cc79a62fb}},10,"F-H0-16617",690,4},
  {{{0x39223fcba6e9da02}},12,"F-H0-16618",912,2},
  {{{0x96473de5ef9a8e07}},12,"F-H0-16619",948,4},
  {{{0x2d7eea0c0494ad5}},12,"F-H0-16620",906,3},
  {{{0x5026ee0a851e1885}},9,"F-H0-16621",417,3},
  {{{0xc00f6202645c81b0}},15,"F-H0-16622",935,2},
  {{{0xedf68b034166fdfe}},8,"F-H0-16623",420,4},
  {{{0x464f2cc687b5a08c}},5,"F-H0-16624",943,2},
  {{{0xaf7b96022cba0325}},6,"F-H0-16625",678,2},
  {{{0x68506ea6b84b30a5}},11,"F-H0-16626",911,2},
  {{{0x5f28be6a525095ae}},20,"F-H0-16627",949,4},
  {{{0x9ac2807b28421dc1}},15,"F-H0-16628",984,2},
  {{{0x5ccead25ccea91fa}},15,"F-H0-16629",872,2},
  {{{0x6c52622735493ca0}},12,"F-H0-16630",946,2},
  {{{0x3e1126539999cec5}},14,"F-H0-16631",978,4},
  {{{0x39b3ab6a88ff82d9}},7,"F-H0-16632",837,3},
  {{{0xa659e6f90d7f87e4}},5,"F-H0-16633",839,2},
  {{{0x5ab5cb333aea2f7d}},11,"F-H0-16634",839,4},
  {{{0x5730dd9e939a77b8}},7,"F-H0-16635",541,2},
  {{{0x68f59528d0b8ab4c}},13,"F-H0-16636",972,2},
  {{{0x6174a70696df9865}},15,"F-H0-16637",714,3},
  {{{0x938599426eda40ae}},8,"F-H0-16638",874,2},
  {{{0xfc11833e8aaf9683}},7,"F-H0-16639",939,3},
  {{{0x377a911e1b809622}},8,"F-H0-16640",533,4},
  {{{0x62eb8d7039077377}},18,"F-H0-16641",983,2},
  {{{0xc2ce0903ab6a0148}},8,"F-H0-16642",948,2},
  {{{0x9d3b799bbc4e6e06}},6,"F-H0-16643",466,2},
  {{{0x16e8553bf31c58d3}},9,"F-H0-16644",467,3},
  {{{0x2d02a304af234a9d}},6,"F-H0-16645",728,3},
  {{{0xc49e02bab407935d}},11,"F-H0-16646",873,2},
  {{{0x9e5e578411f1f170}},15,"F-H0-16647",617,4},
  {{{0x96fc9afebab339d}},18,"F-H0-16648",507,3},
  {{{0xf47d446947764414}},6,"F-H0-16649",420,2},
  {{{0x3d29980f92093866}},12,"F-H0-16650",914,2},
  {{{0xbeb818e53585cf2d}},9,"F-H0-16651",873,3},
  {{{0x936da9ca6a5e7692}},5,"F-H0-16652",505,3},
  {{{0x24766cbf7436914e}},13,"F-H0-16653",421,3},
  {{{0xda2845f2c17c6899}},9,"F-H0-16654",616,3},
  {{{0x96068b17fa28a0bd}},11,"F-H0-16655",909,4},
  {{{0xe6196dbbe6e114ba}},15,"F-H0-16656",986,3},
  {{{0xbcc7a9d361d96c7}},5,"F-H0-16657",943,2},
  {{{0xa2884d34873701b0}},12,"F-H0-16658",837,4},
  {{{0x57723b24657584d2}},9,"F-H0-16659",690,2},
  {{{0xb7d106c224cf7cbf}},15,"F-H0-16660",603,2},
  {{{0x159b1b7e35c49e15}},6,"F-H0-16661",948,3},
  {{{0x24b2e7c144ac27f7}},15,"F-H0-16662",455,4},
  {{{0x4321362fa1858049}},6,"F-H0-16663",938,2},
  {{{0x859a04d18ae3787c}},6,"F-H0-16664",466,2},
  {{{0x93c4290857eb56}},6,"F-H0-16665",543,3},
  {{{0x880f3bbff3f4c276}},18,"F-H0-16666",910,2},
  {{{0x98ebcd1b1e170d9f}},7,"F-H0-16667",431,3},
  {{{0xa20bb12179781939}},5,"F-H0-16668",876,3},
  {{{0xdf5beb014e18c77b}},7,"F-H0-16669",492,4},
  {{{0x465e492a59ea9d8}},11,"F-H0-16670",909,2},
  {{{0xfb71e37ffde64370}},21,"F-H0-16671",840,3},
  {{{0xb98733a1e55d1351}},8,"F-H0-16672",567,2},
  {{{0x21aa2a6b4cd6f5b2}},11,"F-H0-16673",944,2},
  {{{0x3e0a59a5753c99c8}},8,"F-H0-16674",579,2},
  {{{0x3e0a59a5753c99c8}},8,"F-H0-16675",505,2},
  {{{0x68b2e62771406ce}},10,"F-H0-16676",950,2},
  {{{0xf282935d48a4e4a0}},6,"F-H0-16677",421,3},
  {{{0x2c487990f77caa84}},23,"F-H0-16678",951,2},
  {{{0x1e9afb57bf84c534}},8,"F-H0-16679",837,3},
  {{{0xe60f7dad35f558e2}},17,"F-H0-16680",788,4},
  {{{0xaa89a7ee447e1de0}},10,"F-H0-16681",901,3},
  {{{0x67c24a6a0666d8e3}},10,"F-H0-16682",874,4},
  {{{0xa4a1ab988efbc236}},14,"F-H0-16683",876,2},
  {{{0xe777857118209352}},7,"F-H0-16684",580,2},
  {{{0x8a802682007c9053}},8,"F-H0-16685",951,4},
  {{{0xf85f9d6adc96dde7}},8,"F-H0-16686",946,2},
  {{{0xe954bfb3aa1ad088}},11,"F-H0-16687",801,2},
  {{{0x8e69c000474ce1c9}},6,"F-H0-16688",543,2},
  {{{0xb659dc21f0287aa7}},6,"F-H0-16689",939,2},
  {{{0x7c522a4a5c8696b9}},10,"F-H0-16690",913,4},
  {{{0xff821a797bfeff9d}},4,"F-H0-16691",456,3},
  {{{0x8c2d26a6e0707c7}},12,"F-H0-16692",504,2},
  {{{0xb9e0307622a4c6}},7,"F-H0-16693",838,3},
  {{{0xdb1ef7b1387b6e6d}},7,"F-H0-16694",493,2},
  {{{0x22fd1de74f145b0e}},8,"F-H0-16695",874,4},
  {{{0x262dce1ca566d28b}},13,"F-H0-16696",941,2},
  {{{0xe4b020950b7a4544}},7,"F-H0-16697",911,2},
  {{{0xd87480f0216c0324}},7,"F-H0-16698",825,2},
  {{{0xccec833d9ddbf60c}},9,"F-H0-16699",936,2},
  {{{0x33d698235216592c}},8,"F-H0-16700",495,2},
  {{{0x33b406af32b5d446}},13,"F-H0-16701",467,3},
  {{{0xee5c9c8921845bb}},4,"F-H0-16702",456,2},
  {{{0xe4f5b92b3d2d576b}},11,"F-H0-16703",949,4},
  {{{0xfa4abd32e7b211c4}},9,"F-H0-16704",653,2},
  {{{0x60f89ebcdf079393}},12,"F-H0-16705",949,4},
  {{{0x61bb90906421246e}},9,"F-H0-16706",497,3},
  {{{0xc10a46cc3955384a}},10,"F-H0-16707",605,3},
  {{{0xdb8fec191b6a1789}},15,"F-H0-16708",714,3},
  {{{0x986fce6ec66e671f}},17,"F-H0-16709",986,3},
  {{{0xdc3408ce005eae07}},9,"F-H0-16710",939,2},
  {{{0xdc3408ce005eae07}},9,"F-H0-16711",940,2},
  {{{0x686cc5224947b0a8}},7,"F-H0-16712",910,2},
  {{{0xd43fe8308f600b5}},7,"F-H0-16713",947,3},
  {{{0x7592b46d97655f9c}},9,"F-H0-16714",948,4},
  {{{0xa285a4166f99fb66}},10,"F-H0-16715",906,2},
  {{{0xc65346401324a002}},9,"F-H0-16716",380,2},
  {{{0x7eeffe625240f3be}},6,"F-H0-16717",765,2},
  {{{0x4dcc878731ba8afb}},13,"F-H0-16718",944,4},
  {{{0x854b5b8129087e29}},7,"F-H0-16719",985,3},
  {{{0x3112ac6cb986c35f}},8,"F-H0-16720",875,4},
  {{{0x5a0453c4632a3d60}},20,"F-H0-16721",543,2},
  {{{0x5a0453c4632a3d60}},20,"F-H0-16722",529,2},
  {{{0x8327825d91665b18}},12,"F-H0-16723",911,4},
  {{{0x6532d982dee1d0c3}},16,"F-H0-16724",945,4},
  {{{0x50aa478b5eff4bed}},16,"F-H0-16725",543,2},
  {{{0xa13791e07c487fdd}},11,"F-H0-16726",947,2},
  {{{0x18d3058b4515285a}},9,"F-H0-16727",677,2},
  {{{0x4dc7d15dbcdd9a4f}},18,"F-H0-16728",945,4},
  {{{0xaddc7895a3f3d9cc}},13,"F-H0-16729",975,4},
  {{{0xbe1a8690c64061b8}},9,"F-H0-16730",503,4},
  {{{0x876bc962967bee70}},18,"F-H0-16731",541,3},
  {{{0x8a65cfa5d386f1aa}},7,"F-H0-16732",419,4},
  {{{0xbf1bc845cab7412e}},6,"F-H0-16733",432,2},
  {{{0x34fd9d57c2e65427}},5,"F-H0-16734",419,4},
  {{{0x14b0e9c47575a65}},16,"F-H0-16735",802,2},
  {{{0xe57babc5dafeb2cd}},9,"F-H0-16736",383,3},
  {{{0x55741b77ea690c48}},9,"F-H0-16737",873,4},
  {{{0x2e7bea0ff1a55736}},11,"F-H0-16738",542,2},
  {{{0x9eb1585510d8a544}},10,"F-H0-16739",429,2},
  {{{0x8c52cddef0d14dcf}},13,"F-H0-16740",983,2},
  {{{0x8c52cddef0d14dcf}},13,"F-H0-16741",906,2},
  {{{0x1f06676cd685de05}},12,"F-H0-16742",421,2},
  {{{0x7bee5f1575a3ff30}},12,"F-H0-16743",906,2},
  {{{0xbd7e60551bb6eac9}},12,"F-H0-16744",577,3},
  {{{0xd83162101322220c}},7,"F-H0-16745",950,2},
  {{{0x6e5550111d1d9330}},7,"F-H0-16746",865,2},
  {{{0x6470fbb091680bf4}},9,"F-H0-16747",949,4},
  {{{0xc783811b6bae93a1}},7,"F-H0-16748",492,2},
  {{{0xf04fd6e80092765d}},9,"F-H0-16749",542,2},
  {{{0x3e5b3f6238914db2}},4,"F-H0-16750",912,2},
  {{{0xbaf96036a2377882}},6,"F-H0-16751",529,3},
  {{{0xf0af12bc34d999a6}},5,"F-H0-16752",863,2},
  {{{0x86aebaa9bdde8fef}},8,"F-H0-16753",825,3},
  {{{0x7e57840626a1dfba}},11,"F-H0-16754",908,2},
  {{{0xe376213d5dd0ac87}},11,"F-H0-16755",902,4},
  {{{0x61057e8752d06c3e}},17,"F-H0-16756",866,2},
  {{{0xa2b17b94bbcd2cd6}},6,"F-H0-16757",654,2},
  {{{0x6bf4aa76495ad2f5}},8,"F-H0-16758",542,2},
  {{{0x7c170714130e7402}},6,"F-H0-16759",941,2},
  {{{0xb6487b5435c6b174}},11,"F-H0-16760",616,2},
  {{{0x2899d33ba3ad3eeb}},7,"F-H0-16761",947,3},
  {{{0x4740ef0e7fc20126}},23,"F-H0-16762",394,4},
  {{{0xa7544b28ddc12ec4}},9,"F-H0-16763",941,3},
  {{{0x7e6a2dd81a86e1ed}},8,"F-H0-16764",543,2},
  {{{0x64c62acd0672582}},9,"F-H0-16765",491,4},
  {{{0xad4be426a95502eb}},8,"F-H0-16766",459,3},
  {{{0x9e6beec49bb7c44e}},14,"F-H0-16767",837,2},
  {{{0x8ca0fabd85da2b31}},8,"F-H0-16768",826,3},
  {{{0x5d4780eebc3d4bd9}},13,"F-H0-16769",875,2},
  {{{0xa6886c9efcf6c12c}},8,"F-H0-16770",874,2},
  {{{0xa6886c9efcf6c12c}},8,"F-H0-16771",948,2},
  {{{0xe50b455977e2965e}},16,"F-H0-16772",393,4},
  {{{0x5e010925cb0117d3}},9,"F-H0-16773",691,3},
  {{{0xc96e8dae451c8c5d}},5,"F-H0-16774",419,2},
  {{{0x837c8d7442ecfc1a}},8,"F-H0-16775",580,3},
  {{{0x83ba58de567686a0}},9,"F-H0-16776",714,2},
  {{{0xe0b3ac44b92b6b46}},17,"F-H0-16777",419,4},
  {{{0x3023e448952d349a}},11,"F-H0-16778",947,4},
  {{{0x44f217ce08b7e825}},8,"F-H0-16779",910,3},
  {{{0x639672ea1ec3526c}},6,"F-H0-16780",751,2},
  {{{0x97bcf9aca3b918f2}},7,"F-H0-16781",874,2},
  {{{0xc24da6f7da3913c5}},7,"F-H0-16782",395,4},
  {{{0x4571085a4915d27d}},17,"F-H0-16783",431,4},
  {{{0x79bedc3d398480f5}},15,"F-H0-16784",951,4},
  {{{0x38ac23ee6bd39236}},11,"F-H0-16785",944,3},
  {{{0x4e194d285df9ab5f}},4,"F-H0-16786",913,4},
  {{{0xab5b6ca92cf32b5a}},7,"F-H0-16787",936,2},
  {{{0xac72a099de40e5a4}},9,"F-H0-16788",617,3},
  {{{0x17f04e781e70264d}},9,"F-H0-16789",899,4},
  {{{0x161a4349e19a5826}},8,"F-H0-16790",419,4},
  {{{0xb37cf6b11a81a5f2}},13,"F-H0-16791",800,2},
  {{{0x92b993d9791bdd67}},8,"F-H0-16792",465,4},
  {{{0xaf45b28729c1f186}},19,"F-H0-16793",972,2},
  {{{0xbcdf2c8b129953ca}},9,"F-H0-16794",827,2},
  {{{0x36aaa3f4b6c5b2ed}},9,"F-H0-16795",936,2},
  {{{0xb0c07a827018204d}},8,"F-H0-16796",543,2},
  {{{0x67a27a621fdaa384}},12,"F-H0-16797",838,3},
  {{{0x1f4e8fad5608f195}},10,"F-H0-16798",838,2},
  {{{0x1f4ea9b376527574}},6,"F-H0-16799",949,2},
  {{{0x557187aa2dfee894}},18,"F-H0-16800",825,4},
  {{{0xe564a88defe0cc8f}},12,"F-H0-16801",908,2},
  {{{0xd446c6c62d024c12}},5,"F-H0-16802",457,3},
  {{{0xc213f2c26c831055}},7,"F-H0-16803",947,2},
  {{{0xef7c3a2231fef0c8}},6,"F-H0-16804",654,3},
  {{{0x7e8af02a819c19ba}},3,"F-H0-16805",542,2},
  {{{0xc3e86eb3394808b9}},4,"F-H0-16806",421,3},
  {{{0x6a9abeb596e6d7c}},6,"F-H0-16807",899,3},
  {{{0x390f20701034c169}},19,"F-H0-16808",529,2},
  {{{0x5911e044fc5b2126}},16,"F-H0-16809",876,3},
  {{{0xb1c82a63fbd37b3a}},20,"F-H0-16810",872,4},
  {{{0x24aa45f7e3bbdce0}},16,"F-H0-16811",803,2},
  {{{0xe402fb88431fb2aa}},12,"F-H0-16812",798,2},
  {{{0x65914c5fa362cfae}},18,"F-H0-16813",678,2},
  {{{0x4e1a04e176cbab7}},21,"F-H0-16814",838,2},
  {{{0x7765c8242af84443}},7,"F-H0-16815",911,4},
  {{{0xe92f0c31c9d7f4f6}},8,"F-H0-16816",901,3},
  {{{0x58b18a8e2cb47053}},9,"F-H0-16817",801,3},
  {{{0x5fc280d1820b9a94}},7,"F-H0-16818",937,3},
  {{{0x5bc1917158743e62}},13,"F-H0-16819",947,3},
  {{{0x3273140a4ab4a8c6}},6,"F-H0-16820",603,2},
  {{{0x69da7a917151e80d}},19,"F-H0-16821",873,3},
  {{{0xdddbebdcf3fc9958}},9,"F-H0-16822",986,4},
  {{{0x6db9a319e0b853c3}},5,"F-H0-16823",912,2},
  {{{0xc34eda11e5cad7d8}},7,"F-H0-16824",876,3},
  {{{0xa47ae2889c6dd8cd}},7,"F-H0-16825",864,3},
  {{{0x18352d9aabad903b}},12,"F-H0-16826",493,2},
  {{{0xb01f1eb8af091b00}},4,"F-H0-16827",505,3},
  {{{0xd5bb770654cd3c81}},12,"F-H0-16828",580,2},
  {{{0x656ca30ffb9784df}},8,"F-H0-16829",947,2},
  {{{0x176c98bb83168a4}},13,"F-H0-16830",875,2},
  {{{0xa306048fdd69430c}},5,"F-H0-16831",825,3},
  {{{0xc508dec98cc211b2}},14,"F-H0-16832",543,3},
  {{{0x68851dfe7468cd9f}},12,"F-H0-16833",615,4},
  {{{0x98a4a16ced67f6e2}},12,"F-H0-16834",950,4},
  {{{0xf3cd24f567ebd77c}},20,"F-H0-16835",909,2},
  {{{0xe898e6c926a09b70}},13,"F-H0-16836",939,2},
  {{{0x19e0caf9968d8fa9}},5,"F-H0-16837",824,2},
  {{{0x8dbe22ca3b1624de}},3,"F-H0-16838",455,2},
  {{{0x9bb423b9382d764c}},11,"F-H0-16839",529,3},
  {{{0x3857758a18c1c64e}},8,"F-H0-16840",469,3},
  {{{0xe4efe64513e0e9cf}},5,"F-H0-16841",466,2},
  {{{0xcf8ca23154ced8a}},9,"F-H0-16842",458,4},
  {{{0xa4f099f0b4dfada8}},8,"F-H0-16843",432,3},
  {{{0x1f22bdcc99c007d8}},6,"F-H0-16844",462,2},
  {{{0xdd94dd8d279ce789}},6,"F-H0-16845",906,2},
  {{{0x672bca44fa43d532}},16,"F-H0-16846",976,3},
  {{{0x750ff40d5d62c0af}},6,"F-H0-16847",617,2},
  {{{0xa27dab4d8d3d9452}},9,"F-H0-16848",393,3},
  {{{0x7a0c1cf00ba5adc5}},22,"F-H0-16849",939,2},
  {{{0x9115bce7d56049f}},14,"F-H0-16850",466,4},
  {{{0xc0ec474b5f187929}},7,"F-H0-16851",542,3},
  {{{0x30d583581d29afe}},5,"F-H0-16852",566,2},
  {{{0x2bd9a7339ccfb712}},14,"F-H0-16853",432,4},
  {{{0x51a782b6d7f75dca}},11,"F-H0-16854",492,2},
  {{{0x6926782679d8c898}},11,"F-H0-16855",429,2},
  {{{0xb19d698a88b5d25}},19,"F-H0-16856",909,3},
  {{{0x44133077461e32d}},15,"F-H0-16857",838,3},
  {{{0x94645a326046e590}},16,"F-H0-16858",910,4},
  {{{0xbffa2c3c533a3a3d}},6,"F-H0-16859",678,2},
  {{{0x948b9b7a1572649}},5,"F-H0-16860",579,3},
  {{{0xe275bc87c3e8a786}},10,"F-H0-16861",947,4},
  {{{0xab136ed41fc92f20}},10,"F-H0-16862",424,4},
  {{{0xeab489847da9a3fc}},5,"F-H0-16863",943,2},
  {{{0xf9f2be70c4966d4e}},10,"F-H0-16864",423,2},
  {{{0x33330628ca749c56}},10,"F-H0-16865",714,2},
  {{{0xda1689ac66d41ce3}},16,"F-H0-16866",580,2},
  {{{0xf7f1319de30c4344}},6,"F-H0-16867",945,3},
  {{{0xca80bc2458a14b21}},8,"F-H0-16868",910,2},
  {{{0xfd6b319bc77b95a1}},18,"F-H0-16869",868,2},
  {{{0xe454ce7547eb72cd}},8,"F-H0-16870",641,2},
  {{{0x8dea1d7e09c0b9f}},11,"F-H0-16871",950,3},
  {{{0xcf7d43ee495aa1fa}},9,"F-H0-16872",876,2},
  {{{0x7c495e5fed89a9d9}},9,"F-H0-16873",839,2},
  {{{0xbaad7c554b6784a9}},11,"F-H0-16874",946,2},
  {{{0xa92b87600b4d5258}},11,"F-H0-16875",939,2},
  {{{0xf99482fdcc7a91cf}},8,"F-H0-16876",567,2},
  {{{0xe9b08522aeacfcec}},10,"F-H0-16877",507,3},
  {{{0x7215a0c8b7944595}},11,"F-H0-16878",544,3},
  {{{0xcfd7eaf34fa4c499}},4,"F-H0-16879",467,2},
  {{{0xfcac928c8cac104b}},4,"F-H0-16880",947,2},
  {{{0x5ffba86b0f0310b4}},7,"F-H0-16881",825,2},
  {{{0x5ffba86b0f0310b4}},7,"F-H0-16882",690,2},
  {{{0x621003a5290c184c}},8,"F-H0-16883",949,4},
  {{{0x9defdeb0e57871c}},6,"F-H0-16884",421,4},
  {{{0x68c73b65f2e9177a}},7,"F-H0-16885",900,2},
  {{{0x93b64bd24863b06b}},10,"F-H0-16886",543,4},
  {{{0x9b07cd46e91e85e7}},16,"F-H0-16887",908,4},
  {{{0xe692d6b0475b26cf}},5,"F-H0-16888",458,2},
  {{{0x92fcc3a29ba6ef9}},5,"F-H0-16889",863,2},
  {{{0x99c8c6feaa36b87e}},10,"F-H0-16890",947,4},
  {{{0x4f4c58585c6d0a78}},10,"F-H0-16891",985,2},
  {{{0x3fe2dc113466bd96}},13,"F-H0-16892",984,3},
  {{{0x42a900ade62bf666}},10,"F-H0-16893",419,4},
  {{{0x7527d2f416ab1305}},7,"F-H0-16894",492,2},
  {{{0x7527d2f416ab1305}},7,"F-H0-16895",456,2},
  {{{0xac31acaa538b90}},7,"F-H0-16896",939,2},
  {{{0x4dd411ae8a77e22a}},6,"F-H0-16897",427,2},
  {{{0xe8ab69a2596558b2}},13,"F-H0-16898",542,2},
  {{{0x93bd60c9e52662be}},7,"F-H0-16899",422,4},
  {{{0x1534fe5ec5347af7}},9,"F-H0-16900",974,3},
  {{{0x9062f4aaf57ddd06}},7,"F-H0-16901",383,2},
  {{{0x527f8e2532e97ef2}},8,"F-H0-16902",541,2},
  {{{0x9d11f3cb8fdd320}},11,"F-H0-16903",543,2},
  {{{0xff08da97c6b4898a}},8,"F-H0-16904",910,4},
  {{{0xe05fcc14cc167560}},5,"F-H0-16905",911,2},
  {{{0x1415811652e279f}},13,"F-H0-16906",942,2},
  {{{0xa065d01d7da9c61}},13,"F-H0-16907",689,2},
  {{{0x2a8402769f252dfa}},10,"F-H0-16908",912,3},
  {{{0xf275c07d5f88050a}},11,"F-H0-16909",678,3},
  {{{0x53910c64c4748f94}},9,"F-H0-16910",430,3},
  {{{0x8ca25e13bd5ad02b}},10,"F-H0-16911",470,2},
  {{{0x5af2f87cc47f5516}},8,"F-H0-16912",874,3},
  {{{0xe0e5dc7eac47d637}},5,"F-H0-16913",505,2},
  {{{0xafe1dfc6884b05ba}},14,"F-H0-16914",421,4},
  {{{0x8c6341baf2333ec9}},7,"F-H0-16915",457,2},
  {{{0xa6b88179d3b548d3}},9,"F-H0-16916",873,4},
  {{{0xbc026fe5332261c}},6,"F-H0-16917",751,2},
  {{{0x9201c33d25938765}},20,"F-H0-16918",390,4},
  {{{0xb2ee641ab1ac3e6}},6,"F-H0-16919",530,2},
  {{{0xe538e9f67112835f}},11,"F-H0-16920",950,2},
  {{{0x928e415c87413f6b}},11,"F-H0-16921",763,2},
  {{{0x4f4b3e01f1bb98ed}},10,"F-H0-16922",418,3},
  {{{0x71afa337dda7905c}},5,"F-H0-16923",911,2},
  {{{0xc7e4534c6d0bc5a0}},13,"F-H0-16924",950,3},
  {{{0x3acd0fd777442608}},8,"F-H0-16925",949,4},
  {{{0x10e7fd08ce82b94}},8,"F-H0-16926",838,2},
  {{{0xced29d331f6e5a4f}},15,"F-H0-16927",950,4},
  {{{0x745b789eefbb85db}},13,"F-H0-16928",430,3},
  {{{0x4bb8abd9d030fe1a}},9,"F-H0-16929",419,2},
  {{{0x104073657709d37a}},7,"F-H0-16930",837,3},
  {{{0x340f8a210e0eb6a2}},9,"F-H0-16931",865,2},
  {{{0x9eb1c3c220e1e536}},15,"F-H0-16932",867,4},
  {{{0x6895b8167669329c}},6,"F-H0-16933",837,3},
  {{{0xc042e6d5839a3551}},10,"F-H0-16934",654,2},
  {{{0x3b06c101694a7c6b}},8,"F-H0-16935",465,4},
  {{{0x85e50efc56ac85cc}},6,"F-H0-16936",912,2},
  {{{0x1dfd65883ab860c}},6,"F-H0-16937",529,2},
  {{{0x993e29437bbd0d62}},5,"F-H0-16938",462,2},
  {{{0x41298e815d190e34}},9,"F-H0-16939",503,4},
  {{{0xb4b59d79ab514113}},6,"F-H0-16940",418,2},
  {{{0xca09bbfc7a231d5f}},19,"F-H0-16941",875,4},
  {{{0x51e94e364c59a1f9}},12,"F-H0-16942",506,2},
  {{{0x4c6b2d0103d0bdc5}},3,"F-H0-16943",913,2},
  {{{0xd80b351f6ab2cf99}},12,"F-H0-16944",901,2},
  {{{0xb82ed9d573673f3d}},7,"F-H0-16945",419,4},
  {{{0x458c1aebc3c2d240}},6,"F-H0-16946",950,2},
  {{{0xcd8ffb47111ad635}},17,"F-H0-16947",678,2},
  {{{0x3204a7e58bb4957}},11,"F-H0-16948",974,3},
  {{{0x476c6721d447496c}},6,"F-H0-16949",945,2},
  {{{0x80ebc5357892ec26}},15,"F-H0-16950",946,3},
  {{{0x180751152236d7f0}},8,"F-H0-16951",905,3},
  {{{0x61da41d58fdf217e}},8,"F-H0-16952",429,2},
  {{{0x545a0244920a883c}},7,"F-H0-16953",506,3},
  {{{0x46cb018da0645dd6}},13,"F-H0-16954",690,3},
  {{{0xcc598e6ac5e14d3f}},6,"F-H0-16955",825,2},
  {{{0x6f4b700bbbb3f182}},9,"F-H0-16956",875,3},
  {{{0x844410bc2f6d31e2}},8,"F-H0-16957",507,4},
  {{{0x23da0277253170fe}},7,"F-H0-16958",432,4},
  {{{0x7b0cddaec78f645c}},9,"F-H0-16959",789,2},
  {{{0xf61fbc4dc261d83c}},3,"F-H0-16960",937,2},
  {{{0x2d393776c2ef3d4}},15,"F-H0-16961",973,4},
  {{{0xc99907fa979dac7c}},7,"F-H0-16962",902,3},
  {{{0x5cfe7492f3278510}},5,"F-H0-16963",457,2},
  {{{0xc8451be8889447ea}},10,"F-H0-16964",424,2},
  {{{0xa1bd1a813ccf25e9}},7,"F-H0-16965",530,4},
  {{{0xbdecbbbb3faa7503}},18,"F-H0-16966",950,3},
  {{{0xeed7ef86f929d772}},7,"F-H0-16967",949,4},
  {{{0x3a31c2e68f8bd329}},4,"F-H0-16968",468,2},
  {{{0x8476c37ceeda8c95}},12,"F-H0-16969",950,4},
  {{{0x67a2ac6d05e60e13}},8,"F-H0-16970",431,3},
  {{{0xe6108c3e97ecb8fc}},6,"F-H0-16971",690,3},
  {{{0x144c2234401f3956}},11,"F-H0-16972",912,4},
  {{{0xb2a80e6dc7dface}},3,"F-H0-16973",456,3},
  {{{0x6a4272f7e99193bb}},6,"F-H0-16974",946,3},
  {{{0xcd2c39343e4285a8}},8,"F-H0-16975",690,4},
  {{{0x709bde044eb6182b}},7,"F-H0-16976",429,2},
  {{{0x1f09d8c22140290d}},11,"F-H0-16977",986,2},
  {{{0x9e9e4af282dec92a}},12,"F-H0-16978",839,3},
  {{{0x6d8df1c9c9af78ad}},20,"F-H0-16979",538,3},
  {{{0x8fba119382738f4c}},6,"F-H0-16980",949,4},
  {{{0x5a23663da17ebb11}},16,"F-H0-16981",906,2},
  {{{0x6a0ae877c711ef6d}},10,"F-H0-16982",943,2},
  {{{0xf5d2bbc15cc2d57c}},7,"F-H0-16983",542,3},
  {{{0x7b7806001be67c0b}},8,"F-H0-16984",640,3},
  {{{0x5592f19e3ea9d41b}},12,"F-H0-16985",975,2},
  {{{0xef020da53214d408}},20,"F-H0-16986",877,4},
  {{{0xbfd3ef3c97af8368}},10,"F-H0-16987",910,2},
  {{{0xbfd3ef3c97af8368}},10,"F-H0-16988",908,2},
  {{{0x13627c59def75050}},11,"F-H0-16989",875,2},
  {{{0x36bce5518139b41e}},11,"F-H0-16990",542,2},
  {{{0x738b1c4eea095d30}},14,"F-H0-16991",876,2},
  {{{0x738b1c4eea095d30}},14,"F-H0-16992",839,2},
  {{{0x890c6820f934d2}},8,"F-H0-16993",975,3},
  {{{0x5c9df56b2b1cad7f}},7,"F-H0-16994",947,2},
  {{{0x5c9df56b2b1cad7f}},7,"F-H0-16995",912,2},
  {{{0x73995e9d59936a1}},16,"F-H0-16996",382,2},
  {{{0xf4b5c76e0d9c7721}},18,"F-H0-16997",803,2},
  {{{0xf4b5c76e0d9c7721}},18,"F-H0-16998",988,2},
  {{{0xdec85a497c38b79a}},10,"F-H0-16999",950,3},
  {{{0x6a7a3a454df1e19e}},8,"F-H0-17000",541,2},
  {{{0x913b152883c2dad9}},6,"F-H0-17001",901,2},
  {{{0x3172f9f3f6312e7b}},14,"F-H0-17002",421,2},
  {{{0xb62b6fa54ce8ec71}},7,"F-H0-17003",690,2},
  {{{0xb62b6fa54ce8ec71}},7,"F-H0-17004",684,2},
  {{{0x69a0da64249f4207}},3,"F-H0-17005",901,2},
  {{{0xc0f241137a63ddfd}},8,"F-H0-17006",947,2},
  {{{0xaf63fb50f33334e4}},10,"F-H0-17007",950,3},
  {{{0xa513012b92a77118}},20,"F-H0-17008",826,2},
  {{{0xfc137b6a97aadb9}},18,"F-H0-17009",872,2},
  {{{0xc69d3dc687a306dd}},16,"F-H0-17010",945,3},
  {{{0x4e1e9b53bd60e120}},8,"F-H0-17011",837,2},
  {{{0xe582d04ae19711ca}},13,"F-H0-17012",385,2},
  {{{0xa1c0c3843d02aaa3}},5,"F-H0-17013",839,2},
  {{{0x53fd06c846fd2e87}},5,"F-H0-17014",456,2},
  {{{0xe66860ffb4306c2}},13,"F-H0-17015",873,2},
  {{{0xe66860ffb4306c2}},13,"F-H0-17016",950,2},
  {{{0xe11725fda42a0102}},11,"F-H0-17017",529,2},
  {{{0xa7e3fe665f75b5cc}},9,"F-H0-17018",875,4},
  {{{0xc514b2285b613694}},21,"F-H0-17019",872,3},
  {{{0xcc46339204d575f4}},10,"F-H0-17020",418,2},
  {{{0x2a6d815ab7e1963c}},5,"F-H0-17021",874,2},
  {{{0x30f25284921a0c6c}},7,"F-H0-17022",393,2},
  {{{0x6ae44cdf772b2e3e}},7,"F-H0-17023",469,2},
  {{{0x6be906b56b5448cd}},8,"F-H0-17024",946,3},
  {{{0x44d9e7dbd4518631}},17,"F-H0-17025",873,4},
  {{{0xd4e62599755c61af}},8,"F-H0-17026",942,2},
  {{{0x9a54bef5284f5f05}},16,"F-H0-17027",951,4},
  {{{0xd01fb3834c7720a4}},7,"F-H0-17028",906,2},
  {{{0x8624fa2e6826e23b}},23,"F-H0-17029",936,2},
  {{{0x81248084519ff81a}},3,"F-H0-17030",911,2},
  {{{0x85f58b398342f713}},16,"F-H0-17031",459,2},
  {{{0x1b46bba11214b394}},10,"F-H0-17032",839,4},
  {{{0xf42e019311e0a00}},12,"F-H0-17033",654,3},
  {{{0x3c4f02ddf924b7f7}},11,"F-H0-17034",907,2},
  {{{0xd19bb9efa8a5ddf8}},18,"F-H0-17035",838,2},
  {{{0x5aed209205e02a63}},18,"F-H0-17036",825,2},
  {{{0xab8e74f91696002e}},17,"F-H0-17037",945,4},
  {{{0x3f13ce604e48e984}},13,"F-H0-17038",836,4},
  {{{0xc8f0edb6df21a3cc}},6,"F-H0-17039",875,3},
  {{{0x6d2ceb9bfc4ffe54}},9,"F-H0-17040",641,2},
  {{{0xb09646fd533de02c}},3,"F-H0-17041",826,3},
  {{{0x4e9b05f77bd232f5}},13,"F-H0-17042",430,2},
  {{{0x4e9b05f77bd232f5}},13,"F-H0-17043",431,2},
  {{{0xa98574cd95372abd}},10,"F-H0-17044",430,3},
  {{{0xd92f0b2850f5385b}},23,"F-H0-17045",394,4},
  {{{0xddb1d18efc4a2d5a}},19,"F-H0-17046",729,4},
  {{{0x230bcbb415563c2d}},9,"F-H0-17047",903,4},
  {{{0x73c02b39e022e134}},12,"F-H0-17048",789,3},
  {{{0x49f2c84990f1a624}},7,"F-H0-17049",529,2},
  {{{0xb28bb75813f1d905}},21,"F-H0-17050",793,2},
  {{{0x9b9162846cc5bf3b}},6,"F-H0-17051",838,2},
  {{{0x9b9162846cc5bf3b}},6,"F-H0-17052",839,2},
  {{{0x1bd9d4302d1baf96}},14,"F-H0-17053",951,4},
  {{{0xdd5f4e45369dba6}},10,"F-H0-17054",908,2},
  {{{0xa77a18ed8b298608}},9,"F-H0-17055",871,2},
  {{{0x15273cdeec1b5d73}},12,"F-H0-17056",836,2},
  {{{0xd4fee8764bf525f3}},12,"F-H0-17057",936,2},
  {{{0x3c15f856f1231265}},8,"F-H0-17058",801,3},
  {{{0xdc66819a5d1fce0a}},13,"F-H0-17059",949,4},
  {{{0xd9163660c5af549}},10,"F-H0-17060",941,2},
  {{{0xbf3f066260000e8f}},10,"F-H0-17061",543,2},
  {{{0x1b5c9f5371f453b6}},9,"F-H0-17062",764,4},
  {{{0x91bbd768531f4e21}},10,"F-H0-17063",418,2},
  {{{0x73c4831b7f4b5539}},9,"F-H0-17064",528,2},
  {{{0xff0e8e3c6c63d572}},10,"F-H0-17065",431,3},
  {{{0x687e2045d1c944eb}},5,"F-H0-17066",691,2},
  {{{0x687e2045d1c944eb}},5,"F-H0-17067",900,2},
  {{{0x1d8a7b4e1041581}},7,"F-H0-17068",950,2},
  {{{0x98e178fee7c7653a}},12,"F-H0-17069",873,2},
  {{{0xff86f83fccec2df2}},6,"F-H0-17070",910,2},
  {{{0xb48369e56e481b82}},6,"F-H0-17071",939,2},
  {{{0xea2972218030a1e2}},12,"F-H0-17072",947,4},
  {{{0x7ef108b70112419f}},11,"F-H0-17073",949,4},
  {{{0xcd8c5efc5cc909b7}},15,"F-H0-17074",463,2},
  {{{0xaa7a4fbf7914ceec}},4,"F-H0-17075",457,2},
  {{{0xfe811ee75ff35ada}},7,"F-H0-17076",943,2},
  {{{0xbdd659ac03f24a61}},9,"F-H0-17077",901,3},
  {{{0x2b13350215a162b4}},14,"F-H0-17078",827,4},
  {{{0x7635d1deb34271fb}},13,"F-H0-17079",690,3},
  {{{0x958a29cf4343883c}},14,"F-H0-17080",826,3},
  {{{0xc2a79cf9b7bd373e}},13,"F-H0-17081",839,3},
  {{{0x69675dac3e5589c2}},12,"F-H0-17082",431,2},
  {{{0xbf215ef0cb185315}},10,"F-H0-17083",943,2},
  {{{0x4c737ecdd453da2d}},14,"F-H0-17084",876,2},
  {{{0x645f43b75b5795a4}},8,"F-H0-17085",426,3},
  {{{0x2c5abedb9f8ad386}},16,"F-H0-17086",423,3},
  {{{0xa16e721912e39bcf}},9,"F-H0-17087",949,4},
  {{{0xc7f8cb96e6e056a5}},12,"F-H0-17088",874,2},
  {{{0xc7f8cb96e6e056a5}},12,"F-H0-17089",873,2},
  {{{0xa4a3d7db54c241a2}},8,"F-H0-17090",455,4},
  {{{0x69b46ae0e3cd5642}},11,"F-H0-17091",910,3},
  {{{0x53ced7381a46c213}},8,"F-H0-17092",431,2},
  {{{0x22010e7dc435aba4}},17,"F-H0-17093",825,2},
  {{{0x52dc895412adcea7}},13,"F-H0-17094",605,4},
  {{{0xadd6223d3ca5ab70}},6,"F-H0-17095",530,2},
  {{{0x7a258570089ab6bb}},9,"F-H0-17096",911,2},
  {{{0x57a36f5d9557c586}},11,"F-H0-17097",466,2},
  {{{0x75d1ce4fbcb3fe4}},7,"F-H0-17098",943,2},
  {{{0x7ab5a47508c7f78c}},13,"F-H0-17099",948,2},
  {{{0x274b4f11ff3c6312}},21,"F-H0-17100",383,4},
  {{{0xa38b8dbe546d584b}},13,"F-H0-17101",418,2},
  {{{0x90789171f61b2df0}},11,"F-H0-17102",910,4},
  {{{0x1451bdd2ee9fbd4f}},13,"F-H0-17103",459,4},
  {{{0x703f00174113dc8f}},10,"F-H0-17104",615,2},
  {{{0xab0d3e5d24972934}},9,"F-H0-17105",944,2},
  {{{0xab0d3e5d24972934}},9,"F-H0-17106",945,2},
  {{{0x683ad8ae7ed050a8}},12,"F-H0-17107",469,3},
  {{{0xedaa0511d79bc7f9}},6,"F-H0-17108",945,3},
  {{{0xc83fa06271b00f69}},9,"F-H0-17109",912,2},
  {{{0x61620f933db94ca}},12,"F-H0-17110",948,4},
  {{{0x351f0d3326d63b2e}},20,"F-H0-17111",396,3},
  {{{0xaf28c9a8e37f3811}},11,"F-H0-17112",873,3},
  {{{0x889f0ad0dada9420}},8,"F-H0-17113",938,2},
  {{{0x52c9722ede6f8a65}},9,"F-H0-17114",899,3},
  {{{0xc202c7f10d97dc8f}},8,"F-H0-17115",838,3},
  {{{0xdf4ed702e8c01895}},12,"F-H0-17116",540,3},
  {{{0x98b6e321d3132f5c}},14,"F-H0-17117",692,2},
  {{{0xc431ea1e15a77dd}},6,"F-H0-17118",421,2},
  {{{0x6127d989376bf7e}},4,"F-H0-17119",493,2},
  {{{0x3a89b149ef9d92c5}},10,"F-H0-17120",455,2},
  {{{0x29cd8ec0a38219c7}},5,"F-H0-17121",877,2},
  {{{0x37396ce78b4f4677}},10,"F-H0-17122",421,2},
  {{{0xc83afd9e8946c6cf}},7,"F-H0-17123",941,4},
  {{{0xd5d6c24752248375}},7,"F-H0-17124",429,3},
  {{{0x64f37b17ee736179}},5,"F-H0-17125",839,3},
  {{{0x5056075fde369973}},8,"F-H0-17126",543,2},
  {{{0x75cb3ec9c28510a7}},11,"F-H0-17127",677,2},
  {{{0x1cfadf1eb96e8819}},10,"F-H0-17128",466,3},
  {{{0x3fa8835dc6cdf08f}},7,"F-H0-17129",876,2},
  {{{0x134d0664d49e0d2d}},10,"F-H0-17130",985,3},
  {{{0x5937f3edf9125a51}},9,"F-H0-17131",947,2},
  {{{0xe58790aead531ea8}},11,"F-H0-17132",464,2},
  {{{0x4b8d906097bdf8a5}},10,"F-H0-17133",459,4},
  {{{0x4a824517861e8d4}},18,"F-H0-17134",936,2},
  {{{0x5e57688b0c7b8497}},13,"F-H0-17135",384,2},
  {{{0x9b76f8b70d33e722}},8,"F-H0-17136",541,2},
  {{{0xb154374bf24835e}},11,"F-H0-17137",463,2},
  {{{0x9b10d471b5d1ef45}},20,"F-H0-17138",951,3},
  {{{0x55dcc488b6f7c838}},6,"F-H0-17139",714,2},
  {{{0x403606159fd34e2f}},9,"F-H0-17140",976,2},
  {{{0x403606159fd34e2f}},9,"F-H0-17141",903,2},
  {{{0x64c1804ffdd27b4}},10,"F-H0-17142",948,3},
  {{{0x71e053bf139718cb}},20,"F-H0-17143",838,4},
  {{{0x8ccaaa2d2158b6f1}},9,"F-H0-17144",873,3},
  {{{0xdd925a45166b69bf}},7,"F-H0-17145",566,4},
  {{{0xc8f0ef29a14ff9f1}},12,"F-H0-17146",876,2},
  {{{0x9a4d0b45bfd7f9fa}},21,"F-H0-17147",825,2},
  {{{0x10416684455dba7b}},14,"F-H0-17148",898,4},
  {{{0x4df0c6d40b10b791}},12,"F-H0-17149",876,2},
  {{{0xc72635e792f44d1c}},7,"F-H0-17150",936,2},
  {{{0x8150b755ebd2350}},3,"F-H0-17151",906,3},
  {{{0x8d02bca4c364db1c}},19,"F-H0-17152",801,3},
  {{{0xe1763cf9b624f368}},7,"F-H0-17153",420,2},
  {{{0xf7fa70d2847ad283}},16,"F-H0-17154",839,2},
  {{{0xd745e2dce9d688a6}},7,"F-H0-17155",913,3},
  {{{0x50869ecc20ae2829}},10,"F-H0-17156",906,4},
  {{{0x527c02a468facae6}},14,"F-H0-17157",867,2},
  {{{0x562add3277b90cd9}},14,"F-H0-17158",765,2},
  {{{0x7194cb6b237dd7d1}},5,"F-H0-17159",838,4},
  {{{0xe222cee07eba91fa}},6,"F-H0-17160",432,3},
  {{{0xe24fba74094c7634}},7,"F-H0-17161",864,4},
  {{{0xae607e7e692a8ac1}},8,"F-H0-17162",765,3},
  {{{0x7c90bd4756ce3061}},11,"F-H0-17163",433,3},
  {{{0x377df5b5dc68b919}},16,"F-H0-17164",908,2},
  {{{0xe83b6a8a47fb27ad}},9,"F-H0-17165",544,2},
  {{{0x8e970a164456846}},8,"F-H0-17166",470,2},
  {{{0x2edd9c1c1ef786b}},8,"F-H0-17167",464,2},
  {{{0x812ee93a5228989a}},8,"F-H0-17168",455,4},
  {{{0x25e585dc3e324157}},10,"F-H0-17169",865,4},
  {{{0x782af8fd7b71058f}},9,"F-H0-17170",936,3},
  {{{0x25f6c1d36679b3fe}},15,"F-H0-17171",791,3},
  {{{0x4d7d2765c960c882}},6,"F-H0-17172",911,2},
  {{{0x68dcc1f13ff00943}},8,"F-H0-17173",913,4},
  {{{0x591f990cb51e6762}},10,"F-H0-17174",910,2},
  {{{0x1be148f9c5a533d3}},10,"F-H0-17175",902,2},
  {{{0xa5b8f0402a3e6328}},4,"F-H0-17176",456,2},
  {{{0x5f640426056cf08b}},8,"F-H0-17177",949,3},
  {{{0xd7a48e64fea8f707}},4,"F-H0-17178",456,2},
  {{{0x9d0150f40fcf9bdc}},8,"F-H0-17179",802,4},
  {{{0x3cabde69759b2a2b}},9,"F-H0-17180",837,2},
  {{{0x49152154f1992742}},8,"F-H0-17181",432,3},
  {{{0x3364d50bead1d0cd}},14,"F-H0-17182",429,4},
  {{{0x630a163893fc2f36}},9,"F-H0-17183",985,4},
  {{{0xdca2a88c54d30e8e}},10,"F-H0-17184",950,2},
  {{{0x622e9f63939e3045}},9,"F-H0-17185",914,4},
  {{{0xf4fdece92212067c}},4,"F-H0-17186",431,2},
  {{{0x388369a79d732096}},20,"F-H0-17187",940,4},
  {{{0xe3f9b533a501784a}},6,"F-H0-17188",543,2},
  {{{0x48b9d22819bf9e28}},16,"F-H0-17189",543,2},
  {{{0x955d668502040df3}},9,"F-H0-17190",430,2},
  {{{0x430d216b8d5905a1}},6,"F-H0-17191",462,2},
  {{{0x2bea36f0a60b57e9}},11,"F-H0-17192",492,2},
  {{{0x358a0f020f663f89}},11,"F-H0-17193",874,2},
  {{{0xec45a68a8334e5a7}},7,"F-H0-17194",420,3},
  {{{0xccac01b4e05f747c}},7,"F-H0-17195",469,3},
  {{{0xc31f5b762b2ba8c3}},9,"F-H0-17196",799,2},
  {{{0xc31f5b762b2ba8c3}},9,"F-H0-17197",762,2},
  {{{0xc1bedc688582f763}},8,"F-H0-17198",986,2},
  {{{0xc1bedc688582f763}},8,"F-H0-17199",912,2},
  {{{0xacd6d61ccf4b397b}},6,"F-H0-17200",951,4},
  {{{0x3828de3840e23bb5}},11,"F-H0-17201",974,3},
  {{{0x1deda94fde7538ba}},7,"F-H0-17202",393,4},
  {{{0x5e67cf55e16c0000}},8,"F-H0-17203",877,4},
  {{{0x94562555b2618fe4}},4,"F-H0-17204",456,2},
  {{{0x738fa7a82fc5b27c}},9,"F-H0-17205",689,2},
  {{{0xc0c596e1d1115f72}},12,"F-H0-17206",908,4},
  {{{0xf55666c20accf98b}},15,"F-H0-17207",984,4},
  {{{0x40f14d9691977d19}},19,"F-H0-17208",653,3},
  {{{0xb6ff0138784cf587}},8,"F-H0-17209",529,4},
  {{{0x75fab2468b2415f3}},16,"F-H0-17210",839,4},
  {{{0xd59f7e6e347897b0}},12,"F-H0-17211",839,2},
  {{{0x3a448b5d978fbbe7}},7,"F-H0-17212",467,4},
  {{{0xdf7d147a78b5dcd3}},12,"F-H0-17213",690,2},
  {{{0x426908af7a51fe3e}},5,"F-H0-17214",950,3},
  {{{0xf1563aefcaeb93b8}},9,"F-H0-17215",506,2},
  {{{0x955f15d801e693cc}},4,"F-H0-17216",876,2},
  {{{0x3f4086d26a4c5077}},11,"F-H0-17217",531,3},
  {{{0x7db3a0378638ed98}},15,"F-H0-17218",866,4},
  {{{0xf6efa71e3368b8f4}},12,"F-H0-17219",910,3},
  {{{0x444eeb7ec993cfd6}},7,"F-H0-17220",430,2},
  {{{0x4d5a5ffc5676b026}},13,"F-H0-17221",976,4},
  {{{0xc092b276e49536f9}},14,"F-H0-17222",974,3},
  {{{0x34bb4e52609850e6}},10,"F-H0-17223",910,4},
  {{{0x255cc7f538db92e1}},8,"F-H0-17224",506,2},
  {{{0x6a193ddae9950e79}},8,"F-H0-17225",937,2},
  {{{0x41fec1932a1fe1de}},17,"F-H0-17226",865,3},
  {{{0x552fced65276769d}},15,"F-H0-17227",898,2},
  {{{0xd4951899bd4db25c}},11,"F-H0-17228",429,4},
  {{{0xa34fedac858da9f8}},10,"F-H0-17229",938,2},
  {{{0x139462eff1e64ddd}},10,"F-H0-17230",752,2},
  {{{0x443ac3d0bff3a338}},5,"F-H0-17231",492,3},
  {{{0xaba9a881a533edb9}},15,"F-H0-17232",829,4},
  {{{0x6e5d18e059013132}},7,"F-H0-17233",937,2},
  {{{0xdf1c69d1cfdbaa79}},12,"F-H0-17234",940,3},
  {{{0x293f7580b900915d}},9,"F-H0-17235",947,3},
  {{{0x61970bf452f143fe}},16,"F-H0-17236",457,3},
  {{{0xbfae70e278e89a5a}},3,"F-H0-17237",838,2},
  {{{0x263cbd2b851947c4}},9,"F-H0-17238",937,3},
  {{{0x1718adeb3e02e9dd}},13,"F-H0-17239",876,3},
  {{{0x4f4e6389c35af989}},6,"F-H0-17240",949,2},
  {{{0xfb9d4210bf4206b5}},15,"F-H0-17241",947,2},
  {{{0x5565240ba5b71a5d}},15,"F-H0-17242",788,2},
  {{{0x9dfbf73b68e9e3e9}},13,"F-H0-17243",430,3},
  {{{0x264a9eb1e6b2c0ec}},15,"F-H0-17244",951,2},
  {{{0x9b69f158b7f3d7d3}},8,"F-H0-17245",470,3},
  {{{0xcf1abdca23ffd966}},8,"F-H0-17246",901,2},
  {{{0x2bb3e46c54be93ff}},8,"F-H0-17247",542,3},
  {{{0xb89f924dc400da8d}},3,"F-H0-17248",431,2},
  {{{0x34a41e0189a87529}},8,"F-H0-17249",542,2},
  {{{0xca6bd393810bfa41}},8,"F-H0-17250",715,2},
  {{{0xc716e24dfa82b3e8}},6,"F-H0-17251",418,3},
  {{{0x73ceff1f3c0ab413}},22,"F-H0-17252",529,2},
  {{{0xc9a486e5df66415f}},15,"F-H0-17253",836,2},
  {{{0xc9a486e5df66415f}},15,"F-H0-17254",873,2},
  {{{0x4c9e65f91b77e0ec}},14,"F-H0-17255",384,4},
  {{{0x93e6f1066caeec83}},11,"F-H0-17256",421,2},
  {{{0xa37d6336d4e01b68}},13,"F-H0-17257",454,3},
  {{{0x5d4b1d18b803144a}},9,"F-H0-17258",603,2},
  {{{0x5d4b1d18b803144a}},9,"F-H0-17259",641,2},
  {{{0xe83650c2274cd2ed}},6,"F-H0-17260",751,2},
  {{{0xffef7c3f4b462873}},13,"F-H0-17261",861,4},
  {{{0xb1be00c0c66cfc7d}},9,"F-H0-17262",835,2},
  {{{0x847af475033a2f89}},12,"F-H0-17263",532,2},
  {{{0xd0a3c430ced57254}},12,"F-H0-17264",418,2},
  {{{0x918d29f85fd1285b}},14,"F-H0-17265",432,3},
  {{{0x10d9652e7d8b4cb1}},15,"F-H0-17266",974,3},
  {{{0x54cbb9d6f168914e}},15,"F-H0-17267",911,3},
  {{{0xd171c150c8a7b27f}},11,"F-H0-17268",529,4},
  {{{0x5e5cf7b3afc013d7}},7,"F-H0-17269",432,2},
  {{{0xc44ed02f8cee4263}},8,"F-H0-17270",654,4},
  {{{0xb6a57a5c8c4281e0}},9,"F-H0-17271",541,4},
  {{{0x9cef1b6dc05135eb}},8,"F-H0-17272",984,2},
  {{{0x56e8a2a08cda3daa}},8,"F-H0-17273",465,2},
  {{{0xcd2b0638423bd039}},7,"F-H0-17274",936,2},
  {{{0x62ec56c845c9ddb5}},12,"F-H0-17275",899,2},
  {{{0xdcd94c4e0b596d05}},11,"F-H0-17276",937,3},
  {{{0x62ac2ca1b8b05da2}},15,"F-H0-17277",837,2},
  {{{0xa756406b1a9dbdb}},9,"F-H0-17278",651,3},
  {{{0x99c28af7ec34e5a8}},7,"F-H0-17279",466,2},
  {{{0x72c1ac9c7a9618fd}},8,"F-H0-17280",801,3},
  {{{0xad2de782311218ed}},11,"F-H0-17281",947,4},
  {{{0x1d275b763625916b}},12,"F-H0-17282",496,4},
  {{{0x79c49c247b370a27}},11,"F-H0-17283",466,2},
  {{{0x79c49c247b370a27}},11,"F-H0-17284",469,2},
  {{{0x617122d948e64e7e}},8,"F-H0-17285",424,4},
  {{{0x5e12f3dfbe5f5457}},16,"F-H0-17286",902,2},
  {{{0xd2b9ad9585d1869f}},11,"F-H0-17287",640,3},
  {{{0x8062a5a886e9d7ff}},8,"F-H0-17288",826,4},
  {{{0xf94f2eecb7fecb98}},10,"F-H0-17289",543,3},
  {{{0xd98319ea07df36b}},7,"F-H0-17290",900,3},
  {{{0xac24313a56aae9c1}},16,"F-H0-17291",543,2},
  {{{0xefc6da5566296d54}},9,"F-H0-17292",765,3},
  {{{0x797f30454397e9dd}},21,"F-H0-17293",764,2},
  {{{0xa22fe1583293b921}},12,"F-H0-17294",839,3},
  {{{0xc5b1cbcb80c38209}},8,"F-H0-17295",419,4},
  {{{0xcb1ac6c4f1a9d5db}},5,"F-H0-17296",865,3},
  {{{0xc622562e697f96a2}},13,"F-H0-17297",543,3},
  {{{0xab422b27712ba7ea}},11,"F-H0-17298",912,4},
  {{{0x79f1206363908f07}},5,"F-H0-17299",458,2},
  {{{0x1a850e8211d1edb0}},7,"F-H0-17300",839,2},
  {{{0x681ec8c4c2e389ad}},8,"F-H0-17301",459,2},
  {{{0x818232a012139dd2}},6,"F-H0-17302",906,2},
  {{{0x934ad77f1858e014}},9,"F-H0-17303",429,2},
  {{{0xd2eeb77308a10da5}},5,"F-H0-17304",910,2},
  {{{0x965d6cc1edff4327}},17,"F-H0-17305",502,2},
  {{{0x7c26ce7340812ef7}},19,"F-H0-17306",948,3},
  {{{0xf04b992c1683461c}},10,"F-H0-17307",948,3},
  {{{0xfdb9d72939040ec7}},5,"F-H0-17308",939,2},
  {{{0x28c91e3bda039395}},7,"F-H0-17309",417,4},
  {{{0xaef2d17e209aa086}},12,"F-H0-17310",431,3},
  {{{0x3df5998276d082d8}},10,"F-H0-17311",945,2},
  {{{0xeac6d24fe121bb3e}},10,"F-H0-17312",976,2},
  {{{0xd5b16af3e6c2aeb8}},10,"F-H0-17313",424,3},
  {{{0x81ccef23ccb6e38d}},11,"F-H0-17314",910,4},
  {{{0xaa8fcbb514e02250}},12,"F-H0-17315",765,2},
  {{{0xa10418991281e05a}},12,"F-H0-17316",419,2},
  {{{0x6140d3622ef622e3}},10,"F-H0-17317",728,2},
  {{{0x565660ebb2a148ba}},8,"F-H0-17318",543,2},
  {{{0x35f21122d438e2b9}},6,"F-H0-17319",801,2},
  {{{0x2d274d672c9eb804}},6,"F-H0-17320",492,2},
  {{{0xcbe85e6e90b4725}},6,"F-H0-17321",827,3},
  {{{0x7d805743aff53bbb}},12,"F-H0-17322",912,3},
  {{{0x31f474bf21b3f2b3}},8,"F-H0-17323",653,3},
  {{{0x59d080037d417593}},7,"F-H0-17324",914,3},
  {{{0x6ef2029e4f63b6f5}},13,"F-H0-17325",909,3},
  {{{0x5002de0df6aeeeca}},8,"F-H0-17326",454,2},
  {{{0x5289d1a3da7d6c1e}},12,"F-H0-17327",423,2},
  {{{0xf7e0815c78b6fb85}},7,"F-H0-17328",911,2},
  {{{0xd66032ab3a60e3cb}},7,"F-H0-17329",429,2},
  {{{0x4bcd514dd3bb4d29}},5,"F-H0-17330",902,2},
  {{{0x64bbbaac4e81073e}},4,"F-H0-17331",875,3},
  {{{0x5f0b01639aa7f7cd}},15,"F-H0-17332",950,3},
  {{{0x1b1eb01a04c0daaa}},7,"F-H0-17333",454,4},
  {{{0x18c3116938390fc9}},3,"F-H0-17334",910,2},
  {{{0xf4e9ac9c76ba0793}},5,"F-H0-17335",432,3},
  {{{0x7540363346752b54}},5,"F-H0-17336",468,2},
  {{{0xc8540dd6afaf72cf}},12,"F-H0-17337",975,4},
  {{{0x91a18731d5f4bde8}},7,"F-H0-17338",641,2},
  {{{0x8c10a442ddc15933}},7,"F-H0-17339",839,2},
  {{{0x66751923df554cb4}},12,"F-H0-17340",605,3},
  {{{0xb4a718816429d879}},10,"F-H0-17341",874,4},
  {{{0x7b8bf733b2f1bc0b}},14,"F-H0-17342",947,4},
  {{{0x9193ad08d76d7d57}},10,"F-H0-17343",395,2},
  {{{0x9bc3a77419ad5c77}},8,"F-H0-17344",826,4},
  {{{0xe3d3c36e0d0b001}},5,"F-H0-17345",456,2},
  {{{0x543e26a721f638f8}},14,"F-H0-17346",469,2},
  {{{0x286aa35c3c38ead8}},14,"F-H0-17347",417,4},
  {{{0x99111235a15a55ef}},15,"F-H0-17348",876,3},
  {{{0xad74694595acb45c}},7,"F-H0-17349",641,3},
  {{{0x74b02157c7690325}},6,"F-H0-17350",454,3},
  {{{0x83c1975a55d38db7}},9,"F-H0-17351",431,3},
  {{{0x2747c90604f84662}},13,"F-H0-17352",826,2},
  {{{0xdf00868036e8b020}},10,"F-H0-17353",945,4},
  {{{0x48ef390b5f967ed0}},6,"F-H0-17354",864,2},
  {{{0xc95cce4019ec958c}},6,"F-H0-17355",531,3},
  {{{0xb69f37013edb91dc}},11,"F-H0-17356",944,3},
  {{{0x9f0b9bb56d983f07}},18,"F-H0-17357",905,3},
  {{{0x106e37b496ce21e}},9,"F-H0-17358",529,4},
  {{{0xad528efaa5efe332}},9,"F-H0-17359",417,2},
  {{{0x72941f9e57054bdc}},9,"F-H0-17360",764,2},
  {{{0xe2cef92587db63c9}},11,"F-H0-17361",800,2},
  {{{0x2bf3852b2d430a22}},6,"F-H0-17362",901,2},
  {{{0x276d266e16653f12}},12,"F-H0-17363",914,4},
  {{{0x3cd5b4d76879c24d}},8,"F-H0-17364",420,4},
  {{{0xc7c5686e9ef3323c}},8,"F-H0-17365",432,2},
  {{{0x4dd6dc2546305fc5}},11,"F-H0-17366",506,4},
  {{{0x663c27a143379246}},13,"F-H0-17367",914,4},
  {{{0x56ef04130ca247e0}},5,"F-H0-17368",466,2},
  {{{0x337a6cfdd8ef963c}},12,"F-H0-17369",944,2},
  {{{0x727e929fe6975249}},8,"F-H0-17370",640,4},
  {{{0x5cc2d0305654e928}},18,"F-H0-17371",945,2},
  {{{0xb86df6da2ee4bd8a}},18,"F-H0-17372",429,3},
  {{{0xbf2bfabc3c27c84a}},10,"F-H0-17373",788,3},
  {{{0x7dc64491badfa76c}},17,"F-H0-17374",984,4},
  {{{0x2cda704abff4501c}},9,"F-H0-17375",911,2},
  {{{0xe7b71ab9ce45825d}},10,"F-H0-17376",837,4},
  {{{0xcbbd7610f49ec6ad}},9,"F-H0-17377",950,2},
  {{{0xc2ae15cac07c32b4}},5,"F-H0-17378",462,2},
  {{{0x7484622d267b197b}},6,"F-H0-17379",455,2},
  {{{0xbb69deda6186fdee}},16,"F-H0-17380",901,2},
  {{{0xb2b2f2f8edb04e4d}},12,"F-H0-17381",430,2},
  {{{0x6d062107478dfcdc}},12,"F-H0-17382",466,2},
  {{{0xec3e98cbd451b608}},8,"F-H0-17383",418,3},
  {{{0x29e765e03c391cda}},6,"F-H0-17384",910,2},
  {{{0x1ea9dfddb284805d}},13,"F-H0-17385",973,3},
  {{{0x2460d418f26930cd}},3,"F-H0-17386",467,2},
  {{{0x46ad0e98bed1c17e}},19,"F-H0-17387",426,2},
  {{{0xd8935c167f085d1d}},13,"F-H0-17388",985,4},
  {{{0xa2002fe9aa2fb91d}},11,"F-H0-17389",825,3},
  {{{0x88b04fc8d8dff632}},6,"F-H0-17390",941,2},
  {{{0x6aa36fcdf5bb7e48}},6,"F-H0-17391",715,2},
  {{{0xcd3adc6be3242a4}},9,"F-H0-17392",939,2},
  {{{0xcd3adc6be3242a4}},9,"F-H0-17393",940,2},
  {{{0xeebf2e2662f9b462}},10,"F-H0-17394",899,2},
  {{{0x21aa5e8ee15d602}},10,"F-H0-17395",533,2},
  {{{0x4c32dbee848860db}},6,"F-H0-17396",838,2},
  {{{0x4c32dbee848860db}},6,"F-H0-17397",543,2},
  {{{0xa56680db5953ed6b}},7,"F-H0-17398",429,3},
  {{{0x8231acc4f0b01566}},22,"F-H0-17399",984,3},
  {{{0xc223b883856843c7}},10,"F-H0-17400",877,4},
  {{{0x8898c2fe2aa9cdf2}},12,"F-H0-17401",874,3},
  {{{0x16c4501dc807a738}},9,"F-H0-17402",541,2},
  {{{0x2dbc86b596d9aaa5}},14,"F-H0-17403",987,4},
  {{{0x33cdfd2096684af3}},10,"F-H0-17404",877,3},
  {{{0x49e75fa18d8fdd88}},10,"F-H0-17405",381,3},
  {{{0xbdb13c268ba227f1}},5,"F-H0-17406",801,3},
  {{{0x46fed549b1db372}},8,"F-H0-17407",605,2},
  {{{0xe0a945286ed89e96}},11,"F-H0-17408",877,4},
  {{{0x80394e6e6c8ea274}},5,"F-H0-17409",947,2},
  {{{0x2d08f05c7c314bbe}},8,"F-H0-17410",678,2},
  {{{0x140e25b118cbe8b1}},19,"F-H0-17411",869,4},
  {{{0xe048050e124bb65d}},22,"F-H0-17412",950,3},
  {{{0x29d2e631c2bfcc57}},18,"F-H0-17413",985,2},
  {{{0x71ed1fdfe578012a}},12,"F-H0-17414",837,4},
  {{{0x74f62a8c2cf8b2f3}},9,"F-H0-17415",985,3},
  {{{0x855963955bdb5bf}},12,"F-H0-17416",947,2},
  {{{0x84d8aaaa0411083f}},10,"F-H0-17417",875,4},
  {{{0x66c27bb02822d882}},9,"F-H0-17418",876,3},
  {{{0xb3565c1968d8b2b6}},13,"F-H0-17419",530,3},
  {{{0x5ce7e65db6b198d4}},10,"F-H0-17420",936,3},
  {{{0x5bed05bae0a90ebf}},9,"F-H0-17421",466,3},
  {{{0xd74e1bf6e5ecaef6}},8,"F-H0-17422",469,4},
  {{{0xb30b4c4e34e25ace}},13,"F-H0-17423",418,4},
  {{{0x22f2e6e808b320cb}},6,"F-H0-17424",950,3},
  {{{0x446eec101f03112c}},11,"F-H0-17425",871,3},
  {{{0xd59dd93e38f20fb2}},12,"F-H0-17426",907,4},
  {{{0x3fdb17ed5ec558c6}},6,"F-H0-17427",382,3},
  {{{0x546b651dd2f3971b}},14,"F-H0-17428",542,2},
  {{{0xbedf1728561f366e}},19,"F-H0-17429",495,3},
  {{{0x882c20cfe47840c8}},15,"F-H0-17430",458,2},
  {{{0xff6a8f9b4cc8679f}},5,"F-H0-17431",947,2},
  {{{0x8c4c75ff717c4a57}},8,"F-H0-17432",826,2},
  {{{0x8c4c75ff717c4a57}},8,"F-H0-17433",825,2},
  {{{0x9a2a1fb953c2a1ee}},7,"F-H0-17434",913,4},
  {{{0xa0ee4ea588465daa}},14,"F-H0-17435",839,3},
  {{{0x27f2cb72b0e1ec39}},6,"F-H0-17436",421,2},
  {{{0x77aa4d1f9dcfae92}},8,"F-H0-17437",877,3},
  {{{0x86f0e185fc6e5ee7}},6,"F-H0-17438",906,2},
  {{{0x37e02d60fa2cbee}},6,"F-H0-17439",530,2},
  {{{0xa6c714bff326abd6}},6,"F-H0-17440",470,2},
  {{{0x7740e53bd1cf81e}},14,"F-H0-17441",751,4},
  {{{0xc262242308a31f64}},9,"F-H0-17442",865,3},
  {{{0xbf1e57e1916c6bb4}},7,"F-H0-17443",678,3},
  {{{0xc94e83cb757dc2dc}},8,"F-H0-17444",495,4},
  {{{0xe437344d6a0bd47c}},10,"F-H0-17445",950,3},
  {{{0x2401a861ddd4371a}},9,"F-H0-17446",802,2},
  {{{0x9463b6709def4f7f}},6,"F-H0-17447",495,3},
  {{{0xc9e89ab94815393}},5,"F-H0-17448",943,2},
  {{{0x1b88aeef37467933}},7,"F-H0-17449",899,4},
  {{{0x3c88a3e50fe576e9}},7,"F-H0-17450",986,3},
  {{{0xe396e9803ce77d0a}},12,"F-H0-17451",873,2},
  {{{0xa009321e7682e852}},5,"F-H0-17452",541,2},
  {{{0xe151ce8c33fb4756}},4,"F-H0-17453",678,3},
  {{{0xf2ecdd4979cee87c}},9,"F-H0-17454",640,3},
  {{{0x9f64ef3c6f7caafb}},15,"F-H0-17455",910,2},
  {{{0xdcf1ef60d3b75a1b}},11,"F-H0-17456",579,3},
  {{{0xf5c663a68a505c2}},23,"F-H0-17457",420,4},
  {{{0xbb88127f68e6696}},9,"F-H0-17458",801,2},
  {{{0xbc2ab2476038fd45}},11,"F-H0-17459",542,2},
  {{{0x3c8c2da33b16cb45}},11,"F-H0-17460",914,2},
  {{{0xfcfe02b74da4303e}},10,"F-H0-17461",431,4},
  {{{0x245c14872a6ba50d}},3,"F-H0-17462",418,2},
  {{{0x25d02afcdd5faf8f}},11,"F-H0-17463",469,3},
  {{{0xb5c787fa6c1f16a5}},4,"F-H0-17464",529,2},
  {{{0xc3a660da0cb6528c}},4,"F-H0-17465",938,2},
  {{{0xa838d34124879b5d}},16,"F-H0-17466",422,3},
  {{{0xde0c4090619398ba}},14,"F-H0-17467",945,3},
  {{{0xca4be71072c23d57}},10,"F-H0-17468",714,3},
  {{{0xea8ed3a7c7f2a5c0}},13,"F-H0-17469",911,3},
  {{{0x78ce442065a6d3c0}},7,"F-H0-17470",429,2},
  {{{0xcb939f3c0cf5edf8}},18,"F-H0-17471",945,2},
  {{{0xcb939f3c0cf5edf8}},18,"F-H0-17472",529,2},
  {{{0x3a2e64db994a40f1}},5,"F-H0-17473",529,2},
  {{{0x7e88405703c5ce6f}},22,"F-H0-17474",541,2},
  {{{0x56bce7c32eb48cba}},18,"F-H0-17475",839,4},
  {{{0xeb85848e22717480}},5,"F-H0-17476",469,2},
  {{{0x42b2ff47e00dcad6}},11,"F-H0-17477",947,2},
  {{{0xf769dec08f8f4a5d}},10,"F-H0-17478",838,2},
  {{{0x89340bdc832b43eb}},11,"F-H0-17479",729,3},
  {{{0x773ee38a6a3a39f7}},8,"F-H0-17480",948,2},
  {{{0xccf68c5ef372b9b}},11,"F-H0-17481",396,2},
  {{{0xa93f6cbaa1620796}},6,"F-H0-17482",715,2},
  {{{0xf92fb1f8dc78abba}},12,"F-H0-17483",826,4},
  {{{0x1a6a238b01f190f5}},10,"F-H0-17484",947,2},
  {{{0x1a6a238b01f190f5}},10,"F-H0-17485",988,2},
  {{{0x2c9e26932966333e}},6,"F-H0-17486",427,2},
  {{{0xab6a4770e9acf9cd}},5,"F-H0-17487",901,2},
  {{{0xb1822ce824cd5eb6}},9,"F-H0-17488",874,3},
  {{{0x573fcf576a63b267}},7,"F-H0-17489",901,2},
  {{{0xcf18e37667d5674f}},5,"F-H0-17490",937,3},
  {{{0xdc4f75bc9e1d84d}},12,"F-H0-17491",465,3},
  {{{0xbb2f00f58132b720}},2,"F-H0-17492",690,3},
  {{{0xa001a1c844d8f8fc}},9,"F-H0-17493",905,4},
  {{{0x84dbb95744f90e61}},14,"F-H0-17494",909,2},
  {{{0x727a1c6459145926}},8,"F-H0-17495",936,3},
  {{{0x1e0b43d8ff1dbc7a}},19,"F-H0-17496",947,3},
  {{{0xfb8e6caa4779c2f5}},6,"F-H0-17497",432,3},
  {{{0x74c2af847bdad42}},7,"F-H0-17498",825,3},
  {{{0x1ef0de4482d014cc}},11,"F-H0-17499",421,4},
  {{{0x34983888bbaf0718}},9,"F-H0-17500",459,3},
  {{{0x6f0f8cbe9e77f40f}},7,"F-H0-17501",505,3},
  {{{0xa56dc88526823673}},7,"F-H0-17502",837,3},
  {{{0xd14ff866241cd57e}},5,"F-H0-17503",543,2},
  {{{0x8b4f6d0344afdec8}},12,"F-H0-17504",940,2},
  {{{0x639ad56d3daca5fc}},11,"F-H0-17505",826,2},
  {{{0x7e3fe57be2b80d1c}},11,"F-H0-17506",840,2},
  {{{0x64d9944dccfafc13}},10,"F-H0-17507",907,3},
  {{{0x19e0ac05b4de1f7a}},12,"F-H0-17508",947,4},
  {{{0xa0212a7419f882da}},3,"F-H0-17509",938,3},
  {{{0xd81567623a3ed714}},8,"F-H0-17510",421,2},
  {{{0x4514c73a835f3014}},12,"F-H0-17511",941,2},
  {{{0x3cfdc5616da534c4}},19,"F-H0-17512",493,4},
  {{{0xee896b01805439db}},9,"F-H0-17513",762,3},
  {{{0x64f191ea76e671cc}},7,"F-H0-17514",417,4},
  {{{0xf038b4cef662dfb9}},15,"F-H0-17515",394,2},
  {{{0xf038b4cef662dfb9}},15,"F-H0-17516",430,2},
  {{{0x742db3e89fd4a56}},6,"F-H0-17517",579,4},
  {{{0xd36ec26002f941bd}},12,"F-H0-17518",432,4},
  {{{0x59299723a613c0cd}},7,"F-H0-17519",940,4},
  {{{0xc1beafb206c7045c}},8,"F-H0-17520",462,2},
  {{{0xfacea88650fb44c2}},5,"F-H0-17521",543,2},
  {{{0xcf054c8fe0638a8a}},10,"F-H0-17522",874,4},
  {{{0xeaa5a561e3e6e901}},8,"F-H0-17523",567,4},
  {{{0x19b533c7ceb4e66b}},7,"F-H0-17524",910,3},
  {{{0x92283e7b778cddbf}},14,"F-H0-17525",836,3},
  {{{0xa7a3c5cdda9785ca}},8,"F-H0-17526",466,2},
  {{{0xc085a5cafb0a6125}},8,"F-H0-17527",898,2},
  {{{0xfd1fc2f8a53dcf20}},9,"F-H0-17528",531,4},
  {{{0x8b153bc5f83f0da5}},12,"F-H0-17529",940,4},
  {{{0xb0d1937bfffffa5}},10,"F-H0-17530",503,2},
  {{{0x3b54e106c2d928d1}},21,"F-H0-17531",678,2},
  {{{0xcb982c6452b11763}},11,"F-H0-17532",936,3},
  {{{0x52501e17323ab86}},14,"F-H0-17533",936,3},
  {{{0x1bdb81d7ae8aa336}},10,"F-H0-17534",690,4},
  {{{0x428671a179a3a612}},16,"F-H0-17535",423,2},
  {{{0xadc152ca82d0a8f2}},13,"F-H0-17536",580,2},
  {{{0x7063389d7027f8fe}},15,"F-H0-17537",939,2},
  {{{0x5c11b65fba693112}},8,"F-H0-17538",432,2},
  {{{0xfdee8fed69f2fc45}},8,"F-H0-17539",419,2},
  {{{0xfc71709f4854238d}},4,"F-H0-17540",864,2},
  {{{0xb25945a59565688a}},4,"F-H0-17541",431,2},
  {{{0x7e952760b3721643}},8,"F-H0-17542",835,3},
  {{{0xfbfbfb5c672f9b51}},8,"F-H0-17543",913,3},
  {{{0x4ae3c7ae59abacaf}},12,"F-H0-17544",837,2},
  {{{0xbd2c6b30c039a9c2}},11,"F-H0-17545",947,2},
  {{{0x647cc1a16e51ba7c}},9,"F-H0-17546",506,2},
  {{{0x5c2a45d4a7f71dbf}},18,"F-H0-17547",907,4},
  {{{0x746a514772a8954e}},8,"F-H0-17548",715,2},
  {{{0xf8c59753f92ccb26}},7,"F-H0-17549",901,2},
  {{{0x3ebee9d0c7d75540}},8,"F-H0-17550",465,4},
  {{{0x5915098a975ae904}},16,"F-H0-17551",945,4},
  {{{0x9fa85b8e1e046bf0}},6,"F-H0-17552",941,4},
  {{{0x9fb1d68b9b3a5421}},11,"F-H0-17553",505,2},
  {{{0x8a24f5eea43308ad}},11,"F-H0-17554",616,4},
  {{{0xa5937a43910231d1}},6,"F-H0-17555",493,4},
  {{{0xe031803db6b5d598}},7,"F-H0-17556",678,2},
  {{{0xd6e9be588172fbf3}},7,"F-H0-17557",949,4},
  {{{0xdd41f8bc494e6625}},3,"F-H0-17558",505,2},
  {{{0x1f68f348e0471a66}},8,"F-H0-17559",567,3},
  {{{0x761b9373c26ee4c0}},11,"F-H0-17560",873,4},
  {{{0x3ffe734e4276fa67}},11,"F-H0-17561",867,3},
  {{{0x51830ea2e3df54d3}},9,"F-H0-17562",802,2},
  {{{0xbcaf495328c1c723}},9,"F-H0-17563",653,2},
  {{{0xbb44e111aee5db13}},6,"F-H0-17564",906,2},
  {{{0x699b8fa7d6205f8}},6,"F-H0-17565",543,2},
  {{{0x9c80edfdee1e1242}},6,"F-H0-17566",874,2},
  {{{0x3fe3f5cf4cfee7a7}},5,"F-H0-17567",947,2},
  {{{0x8fcef4c159d377e5}},10,"F-H0-17568",468,3},
  {{{0x25f5a8c971dc138a}},8,"F-H0-17569",913,3},
  {{{0x2c22f389d6c8e53d}},17,"F-H0-17570",873,4},
  {{{0xeb5ba9adf7a1ee46}},10,"F-H0-17571",690,4},
  {{{0x9b9152ad883ab52}},9,"F-H0-17572",417,3},
  {{{0x404f89b2dc9e9db6}},11,"F-H0-17573",837,2},
  {{{0x58e3c612c514eb25}},6,"F-H0-17574",543,4},
  {{{0x29a9be12b11a6845}},14,"F-H0-17575",765,4},
  {{{0x2c9e13bd6e81598e}},11,"F-H0-17576",825,2},
  {{{0xfde5c93a5071860}},10,"F-H0-17577",580,2},
  {{{0xfde5c93a5071860}},10,"F-H0-17578",950,2},
  {{{0x6c8446f47509f7a4}},6,"F-H0-17579",504,2},
  {{{0xaef672ee5d4475b0}},15,"F-H0-17580",985,4},
  {{{0x1eada5db2e3af53}},16,"F-H0-17581",470,3},
  {{{0xaf145690954c9692}},17,"F-H0-17582",422,2},
  {{{0x6639ce22c683e6f6}},9,"F-H0-17583",949,2},
  {{{0x5910badde0c76c24}},7,"F-H0-17584",496,2},
  {{{0x324aa317e7dd826}},5,"F-H0-17585",975,2},
  {{{0xedb52035e4dc893d}},10,"F-H0-17586",802,2},
  {{{0xd184d567f7365513}},17,"F-H0-17587",939,2},
  {{{0x4371fba6253fb970}},13,"F-H0-17588",604,2},
  {{{0xe2f9dd7e47831db0}},15,"F-H0-17589",913,2},
  {{{0xdb6c41996d7ce4a}},7,"F-H0-17590",466,3},
  {{{0x8222dc6c0409fe6}},19,"F-H0-17591",905,2},
  {{{0x8222dc6c0409fe6}},19,"F-H0-17592",974,2},
  {{{0x418718d7be8315a7}},10,"F-H0-17593",529,2},
  {{{0xf38236eba6f82303}},5,"F-H0-17594",469,4},
  {{{0x2160e89045315f15}},7,"F-H0-17595",456,3},
  {{{0xef761a9240ebf45}},21,"F-H0-17596",429,2},
  {{{0xf966c05aad386a70}},21,"F-H0-17597",947,2},
  {{{0xbd0cc8f282986cdf}},5,"F-H0-17598",788,2},
  {{{0xef11b984ea3d03fa}},10,"F-H0-17599",616,3},
  {{{0x70feacc64d83f68}},22,"F-H0-17600",392,3},
  {{{0xbc74cf2018a5091d}},5,"F-H0-17601",862,2},
  {{{0xcdd97cec81525afe}},5,"F-H0-17602",910,2},
  {{{0xe4896e77c49c37c0}},7,"F-H0-17603",906,2},
  {{{0x86ed47d2e7e5d478}},11,"F-H0-17604",939,3},
  {{{0x9e06066e7e79a446}},12,"F-H0-17605",974,2},
  {{{0xa23d3ed3f99d3a09}},14,"F-H0-17606",950,3},
  {{{0xa1b7266ffc651cef}},10,"F-H0-17607",539,2},
  {{{0x83cbbd8a4af92cad}},15,"F-H0-17608",906,4},
  {{{0xf6fe3f285cd61b1}},14,"F-H0-17609",973,2},
  {{{0x5c483b754eb16a39}},21,"F-H0-17610",948,3},
  {{{0x256891834180637a}},7,"F-H0-17611",941,3},
  {{{0xb9d99c2ad921a4f7}},4,"F-H0-17612",938,2},
  {{{0x26ca674437bb6af0}},8,"F-H0-17613",432,2},
  {{{0x82ef7843fe9bf27f}},17,"F-H0-17614",825,2},
  {{{0xc3f7fd3e3ff4974f}},17,"F-H0-17615",825,2},
  {{{0xfacae80b5ba441a9}},11,"F-H0-17616",872,2},
  {{{0xe2b85ee7b707252c}},4,"F-H0-17617",418,3},
  {{{0x1a19d3471e899a99}},10,"F-H0-17618",506,3},
  {{{0x82f7f75ef83edae3}},9,"F-H0-17619",950,3},
  {{{0xcbcccf3819606d27}},15,"F-H0-17620",467,3},
  {{{0x2427f6d743816843}},12,"F-H0-17621",862,3},
  {{{0x2dc43a7883c7f511}},14,"F-H0-17622",429,2},
  {{{0x2121a139de5cc68}},12,"F-H0-17623",950,3},
  {{{0x609442b41ad85f28}},7,"F-H0-17624",987,4},
  {{{0x7c0c6f6bc6cc26a5}},11,"F-H0-17625",875,3},
  {{{0xa6823bc60d05d694}},10,"F-H0-17626",504,4},
  {{{0x869c78d9d0e274fb}},8,"F-H0-17627",941,4},
  {{{0xf0bb47aff773caa9}},22,"F-H0-17628",429,2},
  {{{0x58c47601e851c6f5}},5,"F-H0-17629",604,2},
  {{{0x2b5eccbd4438735d}},5,"F-H0-17630",604,2},
  {{{0x1035cebbd5c3bb46}},6,"F-H0-17631",543,3},
  {{{0xdf972cff83ec0f44}},13,"F-H0-17632",977,4},
  {{{0xe0aa11e0b9208b3b}},6,"F-H0-17633",493,3},
  {{{0xe9b23adceff3779d}},16,"F-H0-17634",802,4},
  {{{0x64f2f95c78c9993}},11,"F-H0-17635",504,2},
  {{{0x4a80b25ae44b083b}},5,"F-H0-17636",949,2},
  {{{0x46f9395cab293508}},6,"F-H0-17637",877,2},
  {{{0x3bd5de2b3c5c097f}},9,"F-H0-17638",951,4},
  {{{0x355c5d9f9756f434}},16,"F-H0-17639",418,3},
  {{{0xfef851f01f1ed25d}},6,"F-H0-17640",911,4},
  {{{0xde563635fe3ee9e9}},18,"F-H0-17641",939,2},
  {{{0xa21adba54108b099}},9,"F-H0-17642",678,2},
  {{{0xc2f48b91161d57cf}},6,"F-H0-17643",430,2},
  {{{0x26d961114e1d8911}},9,"F-H0-17644",864,3},
  {{{0x9fbb9c2ff4170b2f}},8,"F-H0-17645",457,2},
  {{{0xe9a5a8a30f94f09c}},10,"F-H0-17646",764,2},
  {{{0x60e9204e6a70a6b1}},15,"F-H0-17647",432,2},
  {{{0xe43e55af411d8011}},8,"F-H0-17648",423,3},
  {{{0x99c433c17f82850}},7,"F-H0-17649",422,2},
  {{{0xac6cbe92194baede}},6,"F-H0-17650",690,2},
  {{{0xddbd6dc3bf5ba1e2}},24,"F-H0-17651",425,2},
  {{{0x99fe2b820d4de599}},4,"F-H0-17652",899,2},
  {{{0x7cea45bcc8ee88cd}},4,"F-H0-17653",468,2},
  {{{0x1f468b7a57f29af3}},5,"F-H0-17654",936,3},
  {{{0x2b6733c31479b7cc}},7,"F-H0-17655",465,3},
  {{{0xc52d4100f714daf0}},17,"F-H0-17656",914,4},
  {{{0x99d71cba02e2f102}},16,"F-H0-17657",945,3},
  {{{0x8f33d0d4a4644793}},6,"F-H0-17658",470,2},
  {{{0xc302669df62849a2}},7,"F-H0-17659",826,3},
  {{{0x6cf8459fd4351c33}},7,"F-H0-17660",944,2},
  {{{0xf14763740c9d78d5}},7,"F-H0-17661",542,3},
  {{{0x71dfe1db9cea36b0}},10,"F-H0-17662",506,4},
  {{{0x53bdc35c190622fa}},10,"F-H0-17663",381,2},
  {{{0xc21472df1b4b5d94}},7,"F-H0-17664",973,2},
  {{{0xdd41aff2bca5fe13}},10,"F-H0-17665",939,3},
  {{{0x36518acfa50ed9df}},7,"F-H0-17666",949,3},
  {{{0x207deed8f7914286}},9,"F-H0-17667",460,2},
  {{{0x7048b6e924260c45}},16,"F-H0-17668",986,2},
  {{{0xd56ae3065b62af82}},8,"F-H0-17669",765,3},
  {{{0x86ad8b90a55219c3}},14,"F-H0-17670",763,2},
  {{{0x88d8efa61b68133c}},6,"F-H0-17671",421,2},
  {{{0x4619f273b87dd1e7}},6,"F-H0-17672",603,3},
  {{{0x9d20b0e8522d4032}},6,"F-H0-17673",825,4},
  {{{0x8ef371452a3d17ae}},17,"F-H0-17674",1011,4},
  {{{0xd87a729d8a3a0d12}},10,"F-H0-17675",838,2},
  {{{0xeee83b265886dd75}},11,"F-H0-17676",950,2},
  {{{0xeee83b265886dd75}},11,"F-H0-17677",836,2},
  {{{0x5121517dbcdbc77}},9,"F-H0-17678",939,2},
  {{{0x8ec99ce94f8fa06b}},2,"F-H0-17679",455,2},
  {{{0x57c8af3b5fdc2c69}},9,"F-H0-17680",839,4},
  {{{0x1fa1b9aa866bfb19}},5,"F-H0-17681",421,3},
  {{{0x299e1b08084a7f88}},8,"F-H0-17682",492,3},
  {{{0xda1620fcf7b09c23}},7,"F-H0-17683",873,2},
  {{{0xb706e243aacde0a5}},5,"F-H0-17684",604,2},
  {{{0x76f36550cf16f2d7}},5,"F-H0-17685",506,2},
  {{{0xbbd04019df4da078}},9,"F-H0-17686",839,2},
  {{{0x84b7e914479ee532}},8,"F-H0-17687",949,4},
  {{{0xf7265a4045d9b526}},9,"F-H0-17688",985,3},
  {{{0x4217baec3e9c0917}},17,"F-H0-17689",833,3},
  {{{0x5579b5ed48e9706b}},11,"F-H0-17690",428,3},
  {{{0x2bda7154db3f3175}},4,"F-H0-17691",875,2},
  {{{0x8f2b0a93413125b2}},6,"F-H0-17692",493,2},
  {{{0xfb5e7f7981b2810d}},17,"F-H0-17693",431,4},
  {{{0x4de261139a1f866d}},16,"F-H0-17694",395,3},
  {{{0xc8143d0031a662a3}},11,"F-H0-17695",939,3},
  {{{0xb01af57da29d88be}},7,"F-H0-17696",839,2},
  {{{0xa8d07f8d27831212}},5,"F-H0-17697",825,3},
  {{{0x4a12c2f01aa00907}},16,"F-H0-17698",839,3},
  {{{0xd8253299a7e4f804}},9,"F-H0-17699",874,3},
  {{{0x7095a99ceb3bf3a}},4,"F-H0-17700",468,2},
  {{{0x374a27bb17f226f9}},4,"F-H0-17701",462,2},
  {{{0x7de074443c76ea20}},4,"F-H0-17702",455,2},
  {{{0xae4cc8f515bace72}},20,"F-H0-17703",949,3},
  {{{0x249169cc0a93e79a}},13,"F-H0-17704",899,4},
  {{{0xa512e466bc9eeb76}},5,"F-H0-17705",864,3},
  {{{0x862dc0049077e4d0}},13,"F-H0-17706",905,3},
  {{{0x3668bd03293f2b4}},13,"F-H0-17707",985,2},
  {{{0xf84a4254872264fb}},11,"F-H0-17708",949,4},
  {{{0x17c65b759c6074be}},7,"F-H0-17709",529,2},
  {{{0x892121df1aedf4a6}},10,"F-H0-17710",862,2},
  {{{0xf87969828b9dae18}},9,"F-H0-17711",873,4},
  {{{0xf324d68e181e9eab}},5,"F-H0-17712",801,2},
  {{{0x7f0fa4c8cf92c517}},7,"F-H0-17713",801,3},
  {{{0x5b13c1d97516e0e3}},10,"F-H0-17714",988,2},
  {{{0xe97992db4dfbfc8}},4,"F-H0-17715",543,2},
  {{{0x59cc226b536aca06}},4,"F-H0-17716",431,2},
  {{{0x8dbc64f082fbf0f5}},11,"F-H0-17717",950,2},
  {{{0x8b910f19c43b765}},11,"F-H0-17718",876,2},
  {{{0x2c3263ed5b66240f}},10,"F-H0-17719",838,2},
  {{{0x62087c3ff2dbfbb3}},9,"F-H0-17720",431,3},
  {{{0x749e5dee29287be1}},6,"F-H0-17721",914,2},
  {{{0xa2a676355571266d}},6,"F-H0-17722",690,2},
  {{{0xb0d353d0e4beead}},7,"F-H0-17723",907,3},
  {{{0xf739383fb7ea0822}},9,"F-H0-17724",910,2},
  {{{0xfe5f4ba62f4e546}},9,"F-H0-17725",491,3},
  {{{0x4d87a2c157948c09}},11,"F-H0-17726",616,3},
  {{{0xb3efeb797c316ffa}},11,"F-H0-17727",432,3},
  {{{0x428f35d8e1f78466}},9,"F-H0-17728",789,2},
  {{{0x428f35d8e1f78466}},9,"F-H0-17729",936,2},
  {{{0x7036d152a8575e6a}},6,"F-H0-17730",505,2},
  {{{0x5eea7f55eec62d95}},6,"F-H0-17731",578,2},
  {{{0xe860da0f301ce4ef}},7,"F-H0-17732",503,3},
  {{{0xa82373a36d4205c4}},11,"F-H0-17733",984,4},
  {{{0xf9f2c49cf371426d}},9,"F-H0-17734",939,3},
  {{{0x48de35c323491e12}},15,"F-H0-17735",950,2},
  {{{0x3230551fbc910cc8}},20,"F-H0-17736",949,3},
  {{{0x88528ff0ee6fccbb}},8,"F-H0-17737",604,2},
  {{{0xb51f1188063bbc72}},8,"F-H0-17738",902,2},
  {{{0xa9a95fa5ec256ecb}},8,"F-H0-17739",727,2},
  {{{0x18c4fe2ce196094c}},7,"F-H0-17740",902,3},
  {{{0x60a814a91d5decd}},7,"F-H0-17741",469,3},
  {{{0xe0894ca4b8d6bf87}},17,"F-H0-17742",578,2},
  {{{0x78d5f97b0d3678b2}},6,"F-H0-17743",838,2},
  {{{0xc724db09b961bc69}},6,"F-H0-17744",728,2},
  {{{0x98a3074e4050cbdd}},9,"F-H0-17745",654,2},
  {{{0x37dd97a72e7cf3b0}},19,"F-H0-17746",579,4},
  {{{0xa4f99afd0eb56d4d}},4,"F-H0-17747",937,4},
  {{{0xcb97bca8c504e930}},15,"F-H0-17748",765,2},
  {{{0x53939aeb0dd6c5cd}},15,"F-H0-17749",875,4},
  {{{0x69322ea9278f51e8}},7,"F-H0-17750",951,3},
  {{{0xa2fe2faa60d7483a}},6,"F-H0-17751",466,2},
  {{{0x89252237d1b293de}},6,"F-H0-17752",426,4},
  {{{0x763fb090482345ac}},7,"F-H0-17753",678,2},
  {{{0x7fb86f28baa3236d}},9,"F-H0-17754",530,4},
  {{{0xcd05bbac8e0675}},9,"F-H0-17755",574,2},
  {{{0xd93ccf5d6a252920}},12,"F-H0-17756",950,4},
  {{{0xc2611a2c55f40409}},13,"F-H0-17757",975,4},
  {{{0x398621ce3bae1c8e}},9,"F-H0-17758",640,3},
  {{{0xf26e5d769a94adb5}},7,"F-H0-17759",939,3},
  {{{0x832e3c6e311e910f}},19,"F-H0-17760",568,2},
  {{{0x28d9974a6cc54852}},9,"F-H0-17761",457,3},
  {{{0xb9c17bf3ee1e1c80}},12,"F-H0-17762",764,2},
  {{{0xe2eda10a5cdbc247}},5,"F-H0-17763",425,2},
  {{{0x77687e00a5dcc2ed}},7,"F-H0-17764",987,4},
  {{{0x3cb07052804cc44c}},13,"F-H0-17765",541,3},
  {{{0x78ca0a726ca0a02e}},9,"F-H0-17766",425,2},
  {{{0x42591d697a1c6fbb}},9,"F-H0-17767",542,3},
  {{{0xb4cc8146a145cb63}},8,"F-H0-17768",640,2},
  {{{0x5af0a52ca00d74f8}},16,"F-H0-17769",493,3},
  {{{0xffa98d17396023dd}},7,"F-H0-17770",950,2},
  {{{0xa15f4c03ad048ead}},5,"F-H0-17771",943,3},
  {{{0xab43f6c6e82f4115}},15,"F-H0-17772",466,2},
  {{{0x6d5807fcc475b108}},7,"F-H0-17773",417,3},
  {{{0xdf0d8d658652bca7}},11,"F-H0-17774",939,2},
  {{{0xb7f253e44eaf1eea}},10,"F-H0-17775",425,2},
  {{{0x2dccd3d25491eca}},15,"F-H0-17776",867,2},
  {{{0x851f473a0cafa134}},10,"F-H0-17777",949,4},
  {{{0x755255edddd26487}},22,"F-H0-17778",381,4},
  {{{0x82b63e47bd5560f}},7,"F-H0-17779",466,4},
  {{{0xc6ce57f4882d9974}},9,"F-H0-17780",530,4},
  {{{0x6ba37edcc7a54119}},6,"F-H0-17781",427,2},
  {{{0x5f0cb487c735bdb3}},12,"F-H0-17782",948,2},
  {{{0x3f9a2a0f0dbfad5e}},16,"F-H0-17783",839,4},
  {{{0x149bc2198ee6ffe4}},6,"F-H0-17784",690,2},
  {{{0x211a317c4479bac5}},10,"F-H0-17785",945,4},
  {{{0xe72886a482061d45}},8,"F-H0-17786",504,2},
  {{{0xd6d95b1cda477168}},12,"F-H0-17787",454,4},
  {{{0x919f518ae31fc535}},9,"F-H0-17788",876,3},
  {{{0x54fb5eebd67439da}},11,"F-H0-17789",939,3},
  {{{0x5da6019604ac1274}},7,"F-H0-17790",752,3},
  {{{0xd475d0b231f1b8e5}},12,"F-H0-17791",948,3},
  {{{0x3ed64bd341291310}},6,"F-H0-17792",949,2},
  {{{0xa7b1b60d4554c420}},6,"F-H0-17793",912,3},
  {{{0x4b4e4dc26b91ae36}},12,"F-H0-17794",604,4},
  {{{0x748f130f2d7b809e}},8,"F-H0-17795",455,4},
  {{{0x30090262e2a62e2b}},6,"F-H0-17796",458,3},
  {{{0xe7eef7c2d17e5775}},9,"F-H0-17797",728,3},
  {{{0xd6e1dc56e00a65fe}},19,"F-H0-17798",907,4},
  {{{0x22de119160238c3c}},15,"F-H0-17799",825,2},
  {{{0x4fe9b4271c64bb47}},15,"F-H0-17800",908,3},
  {{{0xf1e2fefb155af229}},7,"F-H0-17801",429,2},
  {{{0xcfbff31c91709d82}},9,"F-H0-17802",492,4},
  {{{0xded3dc8c919a6fc}},11,"F-H0-17803",911,4},
  {{{0x47aa0a1dc8a4ea3c}},7,"F-H0-17804",493,2},
  {{{0x39dc2877621e874d}},7,"F-H0-17805",421,2},
  {{{0xfd880fb3eb8513d1}},9,"F-H0-17806",949,2},
  {{{0xfd880fb3eb8513d1}},9,"F-H0-17807",910,2},
  {{{0x4f519618fa06297f}},19,"F-H0-17808",944,3},
  {{{0xfa8d1c08736a386}},7,"F-H0-17809",419,3},
  {{{0x4bc160e4aa934ce2}},13,"F-H0-17810",383,4},
  {{{0xf6f24a68335b9567}},4,"F-H0-17811",826,2},
  {{{0x95973a8bcff11819}},14,"F-H0-17812",492,2},
  {{{0x31104f9b74e88870}},8,"F-H0-17813",838,2},
  {{{0x4f4a23481f704950}},5,"F-H0-17814",467,2},
  {{{0xe1a684074bc3ab23}},8,"F-H0-17815",752,2},
  {{{0x186c916c0c22993}},23,"F-H0-17816",789,2},
  {{{0xea889e35e955dad2}},17,"F-H0-17817",872,3},
  {{{0x68abc55fa695c0df}},13,"F-H0-17818",502,4},
  {{{0x5ed56ff34b7e66b}},4,"F-H0-17819",911,3},
  {{{0x80d74feb56b016a9}},10,"F-H0-17820",985,4},
  {{{0xeaa1ce88017d45e0}},8,"F-H0-17821",567,4},
  {{{0xa0500969eb566656}},13,"F-H0-17822",603,3},
  {{{0x1306a84832a184e7}},7,"F-H0-17823",725,2},
  {{{0x5dbe2efb5120b002}},18,"F-H0-17824",827,2},
  {{{0x132f70e9142a3e8c}},11,"F-H0-17825",763,3},
  {{{0xa101177a11cb8202}},5,"F-H0-17826",899,3},
  {{{0xa113a36a79076eba}},7,"F-H0-17827",909,3},
  {{{0x83ba5edad72de4db}},13,"F-H0-17828",835,4},
  {{{0x22192e8a5d1264f8}},6,"F-H0-17829",461,2},
  {{{0x7156f3e49e89038f}},7,"F-H0-17830",913,2},
  {{{0x1cb3df32bb1fb492}},6,"F-H0-17831",913,2},
  {{{0x3dfad5ff80ff4f28}},7,"F-H0-17832",910,2},
  {{{0x1cd7c1d0a763dad9}},22,"F-H0-17833",799,3},
  {{{0x707af7a2e0d48dac}},4,"F-H0-17834",467,2},
  {{{0x43481b29b6e49989}},9,"F-H0-17835",752,2},
  {{{0x2e40dc7ef2fa79e8}},9,"F-H0-17836",874,2},
  {{{0xe71b5e99da4b122f}},6,"F-H0-17837",529,3},
  {{{0x51f7487f8b9194}},11,"F-H0-17838",457,4},
  {{{0x902a099bafc27ebe}},20,"F-H0-17839",567,3},
  {{{0x88895c2ecf587e91}},9,"F-H0-17840",543,2},
  {{{0x4a482bd7a02714bb}},3,"F-H0-17841",468,2},
  {{{0x43faea00b8ba2038}},13,"F-H0-17842",936,2},
  {{{0x1ee4cbb782307972}},20,"F-H0-17843",868,2},
  {{{0xdab0702f74060b92}},8,"F-H0-17844",529,2},
  {{{0xc480f093bc4e5d2c}},16,"F-H0-17845",462,2},
  {{{0x1e39e1af3a1e769}},8,"F-H0-17846",469,4},
  {{{0x8140b5d5c7c74602}},9,"F-H0-17847",431,3},
  {{{0xf85b6312f14ef81a}},8,"F-H0-17848",506,3},
  {{{0xd456d4b52b094aa5}},15,"F-H0-17849",462,2},
  {{{0xb8321e7541564336}},10,"F-H0-17850",875,2},
  {{{0x24de1481b742f3ef}},7,"F-H0-17851",947,2},
  {{{0x88ddd17b6a57c422}},13,"F-H0-17852",825,2},
  {{{0xf96b3cb4e7930a64}},12,"F-H0-17853",906,4},
  {{{0x706ae6bfd1f888ee}},17,"F-H0-17854",984,3},
  {{{0xfcbd60c77607c270}},10,"F-H0-17855",943,4},
  {{{0xe284f34d4050876e}},11,"F-H0-17856",912,3},
  {{{0xbc2ea4c4cceeb745}},11,"F-H0-17857",469,4},
  {{{0x9bc940dd665db575}},9,"F-H0-17858",393,2},
  {{{0x2fd8d633829ea0f}},7,"F-H0-17859",949,3},
  {{{0xa83951b1f19158f5}},5,"F-H0-17860",911,2},
  {{{0xa83951b1f19158f5}},5,"F-H0-17861",947,2},
  {{{0xa46d5be9fbe1c523}},15,"F-H0-17862",507,2},
  {{{0x56d941450f67c4d5}},15,"F-H0-17863",951,2},
  {{{0x3b80ffcd32071742}},12,"F-H0-17864",836,2},
  {{{0xbc26ea552514f424}},6,"F-H0-17865",421,3},
  {{{0x8e43b434ff922425}},7,"F-H0-17866",466,2},
  {{{0x8e43b434ff922425}},7,"F-H0-17867",504,2},
  {{{0xf2a51436c46d5d1d}},5,"F-H0-17868",947,2},
  {{{0x81a464447d5b2471}},6,"F-H0-17869",949,3},
  {{{0x139893d4bb32288d}},11,"F-H0-17870",825,2},
  {{{0x2341532379fb1891}},10,"F-H0-17871",424,4},
  {{{0xf016f915ed2fe564}},12,"F-H0-17872",454,2},
  {{{0x6497051eed8987e7}},12,"F-H0-17873",641,2},
  {{{0x4f36a81f18b1f6db}},8,"F-H0-17874",419,4},
  {{{0x464d0457273b655f}},8,"F-H0-17875",906,2},
  {{{0xa36a6c72bd8e1b89}},5,"F-H0-17876",911,3},
  {{{0x50acc9f677de1442}},14,"F-H0-17877",544,3},
  {{{0x1464344d52e477a8}},7,"F-H0-17878",948,4},
  {{{0xc24fccb8b0cf61aa}},15,"F-H0-17879",947,2},
  {{{0xdd2541da2fa33b17}},6,"F-H0-17880",908,2},
  {{{0xdd2541da2fa33b17}},6,"F-H0-17881",948,2},
  {{{0xb5187db5f6e13ce0}},10,"F-H0-17882",429,2},
  {{{0xc8de9bc1c3df546}},10,"F-H0-17883",912,4},
  {{{0x4f4ee5f1c6b1fb4d}},10,"F-H0-17884",950,2},
  {{{0xdac5544814f0accc}},7,"F-H0-17885",950,4},
  {{{0xfa52b199eb01238d}},6,"F-H0-17886",691,2},
  {{{0x9939dcfdb94c86f3}},10,"F-H0-17887",948,3},
  {{{0xeda42d445bce96f8}},6,"F-H0-17888",432,2},
  {{{0x35d3bc70c0b12658}},11,"F-H0-17889",910,2},
  {{{0xc7dc244667a0a260}},10,"F-H0-17890",469,3},
  {{{0xe342595b00171e17}},7,"F-H0-17891",462,2},
  {{{0xd2e754f466e2dae7}},11,"F-H0-17892",939,2},
  {{{0xe4efde74790f0874}},17,"F-H0-17893",395,4},
  {{{0xf383a0be2631bb86}},12,"F-H0-17894",423,3},
  {{{0xba2314fe184e00a5}},8,"F-H0-17895",861,3},
  {{{0x45caa824acd5ef3e}},8,"F-H0-17896",939,4},
  {{{0xca20db718509df68}},11,"F-H0-17897",912,3},
  {{{0x31028674542fa5cb}},15,"F-H0-17898",871,4},
  {{{0x2972842252b5706b}},20,"F-H0-17899",728,2},
  {{{0x693bc59a16edda3c}},5,"F-H0-17900",425,2},
  {{{0x3b4c9cb3cc66e8d7}},10,"F-H0-17901",949,2},
  {{{0x63632c86c5675071}},11,"F-H0-17902",430,2},
  {{{0x270a67d3d2b2dd22}},8,"F-H0-17903",470,3},
  {{{0xb87f4bd02a9790f7}},13,"F-H0-17904",987,4},
  {{{0xdb11606b45feec8f}},13,"F-H0-17905",950,2},
  {{{0x733ac2d14c31dad4}},5,"F-H0-17906",456,3},
  {{{0x7df209b639bc5bfb}},14,"F-H0-17907",788,4},
  {{{0x366c10299450ffef}},6,"F-H0-17908",424,2},
  {{{0x468731ef55e633da}},7,"F-H0-17909",839,2},
  {{{0xdcb3745ec903d971}},7,"F-H0-17910",839,2},
  {{{0x4eb83411768554c7}},12,"F-H0-17911",940,2},
  {{{0x69587feea5c021ad}},10,"F-H0-17912",728,2},
  {{{0xbadd412443900f0}},14,"F-H0-17913",457,2},
  {{{0x42ab6a12162ad3d2}},10,"F-H0-17914",946,2},
  {{{0x8ca1069791a6007a}},10,"F-H0-17915",975,2},
  {{{0xc77ee6af210bced0}},5,"F-H0-17916",943,2},
  {{{0xc77ee6af210bced0}},5,"F-H0-17917",505,2},
  {{{0xab154dde875f31ca}},6,"F-H0-17918",913,2},
  {{{0xb24df2f369f5a583}},18,"F-H0-17919",873,3},
  {{{0xad8f95e2f5e7cb58}},16,"F-H0-17920",752,3},
  {{{0xca4a031e3544fd7a}},12,"F-H0-17921",432,3},
  {{{0xac39f9dbf373781f}},15,"F-H0-17922",910,3},
  {{{0x5271dc96f321d80e}},12,"F-H0-17923",678,2},
  {{{0xaa102aad2b92baab}},5,"F-H0-17924",827,2},
  {{{0x609470cb917b9c2}},5,"F-H0-17925",950,2},
  {{{0xe6d4b02c79c2f0d8}},11,"F-H0-17926",502,2},
  {{{0x82cd461e8c575092}},9,"F-H0-17927",902,3},
  {{{0x39be41820e5d7927}},13,"F-H0-17928",874,3},
  {{{0x9ce8d343a088f89f}},10,"F-H0-17929",875,2},
  {{{0x15eba42b344fb2a8}},8,"F-H0-17930",428,3},
  {{{0x68610a2c09fd9c9f}},8,"F-H0-17931",948,3},
  {{{0x46fa680a8e9439b8}},18,"F-H0-17932",427,4},
  {{{0x51f299b1d91fc07d}},6,"F-H0-17933",462,2},
  {{{0xc18dfb4519d8b7a7}},13,"F-H0-17934",905,4},
  {{{0x5fd6b891ce2fb29f}},11,"F-H0-17935",988,4},
  {{{0x6e045caec6133d9f}},10,"F-H0-17936",421,2},
  {{{0x6de3d9d635015c34}},6,"F-H0-17937",529,2},
  {{{0xf355d396af33b61c}},8,"F-H0-17938",459,2},
  {{{0xcfe380332687d505}},10,"F-H0-17939",827,3},
  {{{0x58747f463547d6ec}},12,"F-H0-17940",543,2},
  {{{0xadb8e82c4ebc41bb}},12,"F-H0-17941",691,2},
  {{{0x6165d6d8cb300dc4}},11,"F-H0-17942",908,2},
  {{{0x90968bb06b40cfcd}},8,"F-H0-17943",864,2},
  {{{0x291a6f871661b5fd}},3,"F-H0-17944",457,2},
  {{{0xa3d38183f727a28}},10,"F-H0-17945",728,3},
  {{{0xab64b364373457d6}},4,"F-H0-17946",913,2},
  {{{0xdaa261dd295cd8a1}},3,"F-H0-17947",911,2},
  {{{0x9905b0fb6a1f97f6}},10,"F-H0-17948",839,3},
  {{{0x52374cd9961f86ff}},8,"F-H0-17949",912,4},
  {{{0x4d7e1e3abeccea83}},21,"F-H0-17950",713,2},
  {{{0xc9bf7ab3c47825de}},7,"F-H0-17951",913,4},
  {{{0x7c5f2ca9fd25ca2f}},14,"F-H0-17952",529,4},
  {{{0xd48a7e16a646df66}},7,"F-H0-17953",726,4},
  {{{0x60070f317cff0bb7}},9,"F-H0-17954",912,2},
  {{{0xac31ba1eae125f53}},9,"F-H0-17955",529,2},
  {{{0xc617a7feace310c2}},13,"F-H0-17956",581,3},
  {{{0xcad7d1b7b5ca44d1}},16,"F-H0-17957",876,4},
  {{{0x572ada786e91de30}},4,"F-H0-17958",419,2},
  {{{0xed6fe337bd0d65b}},6,"F-H0-17959",908,3},
  {{{0x8e03f0e2eba845fd}},8,"F-H0-17960",421,2},
  {{{0xf8cc34ea0540fb03}},6,"F-H0-17961",470,2},
  {{{0x3f4cb1abbea32ccc}},15,"F-H0-17962",460,4},
  {{{0x25909c853aa98d8b}},10,"F-H0-17963",951,4},
  {{{0xb4561f3dab167859}},7,"F-H0-17964",505,2},
  {{{0x70d3b5dbb200afdc}},17,"F-H0-17965",950,4},
  {{{0x771430efef1d5e79}},5,"F-H0-17966",902,2},
  {{{0x7fc4f4945f5ab3e4}},10,"F-H0-17967",426,4},
  {{{0x2cac581cde416d99}},16,"F-H0-17968",837,2},
  {{{0xa91fb4a212d74a3b}},14,"F-H0-17969",985,2},
  {{{0x662a350e849d27d7}},13,"F-H0-17970",466,2},
  {{{0xfc45af043dd97208}},10,"F-H0-17971",462,2},
  {{{0xeeb1ce61e1eabae9}},7,"F-H0-17972",728,2},
  {{{0xe1ab7966401051e5}},9,"F-H0-17973",987,2},
  {{{0x9c76bcc558af592d}},6,"F-H0-17974",838,2},
  {{{0x5cf55ac616731dc}},9,"F-H0-17975",950,2},
  {{{0x5cf55ac616731dc}},9,"F-H0-17976",870,2},
  {{{0x7b022a02a1a16f83}},10,"F-H0-17977",690,3},
  {{{0xb9df172b22edab67}},8,"F-H0-17978",603,2},
  {{{0x4ac649300b7101a4}},4,"F-H0-17979",529,3},
  {{{0x6eda58e6a09f64ac}},6,"F-H0-17980",950,3},
  {{{0xcdf8cfecfb3e6cef}},8,"F-H0-17981",936,2},
  {{{0xb1d82a77f44bd0ca}},8,"F-H0-17982",616,3},
  {{{0xf5447fcf7207e22e}},8,"F-H0-17983",901,4},
  {{{0x4c2627bcf182b59a}},15,"F-H0-17984",947,2},
  {{{0x4c9fd7c9cfb4b799}},15,"F-H0-17985",940,2},
  {{{0xddf8b565b7012690}},9,"F-H0-17986",456,3},
  {{{0xf1ece06d6b24888e}},6,"F-H0-17987",939,2},
  {{{0x35810ca3d74818ad}},6,"F-H0-17988",837,2},
  {{{0xf5796c32e49e9478}},10,"F-H0-17989",837,2},
  {{{0xc2897b1b4263048b}},10,"F-H0-17990",502,2},
  {{{0xf023b82cc96af04f}},14,"F-H0-17991",381,4},
  {{{0x2191580e1b4fbabe}},19,"F-H0-17992",839,3},
  {{{0xb13500263d2f3058}},7,"F-H0-17993",466,3},
  {{{0xdeb8db077222c75}},10,"F-H0-17994",939,2},
  {{{0xb4928df5625575c4}},16,"F-H0-17995",910,3},
  {{{0x8110677ff51c8c65}},20,"F-H0-17996",802,3},
  {{{0xf716f8cf080a1854}},9,"F-H0-17997",495,3},
  {{{0xe6dc5e18bd669755}},12,"F-H0-17998",431,4},
  {{{0x9a5a31c867ce3459}},5,"F-H0-17999",826,3},
  {{{0xd127bb9e76355a35}},5,"F-H0-18000",943,2},
  {{{0x83e6fe6b69c7daa0}},5,"F-H0-18001",826,2},
  {{{0xd9e1e7f823014f50}},5,"F-H0-18002",418,2},
  {{{0x23928b9ceab82206}},12,"F-H0-18003",392,4},
  {{{0x67c209c83afe111}},15,"F-H0-18004",432,3},
  {{{0x65c091b48c3454ee}},11,"F-H0-18005",910,3},
  {{{0xa6095342f7d3d4a4}},13,"F-H0-18006",876,3},
  {{{0xdfed65c26e1d90a9}},4,"F-H0-18007",456,2},
  {{{0x7b06ec304541f31f}},10,"F-H0-18008",866,4},
  {{{0xfe13a4de57da2437}},12,"F-H0-18009",950,2},
  {{{0x418cee7a5d79d713}},9,"F-H0-18010",394,3},
  {{{0xad2d3fa28788c74f}},6,"F-H0-18011",899,3},
  {{{0xe742752dc761637d}},11,"F-H0-18012",465,2},
  {{{0x3a261585668bb1}},10,"F-H0-18013",430,2},
  {{{0xbe7d6e5102cc5dc6}},6,"F-H0-18014",875,2},
  {{{0x21edc61d52cc72c}},14,"F-H0-18015",876,3},
  {{{0xce2efbac6621977d}},5,"F-H0-18016",902,2},
  {{{0xfe606d0db294101c}},6,"F-H0-18017",975,4},
  {{{0x9ab8e342350d7045}},14,"F-H0-18018",801,2},
  {{{0x9ab8e342350d7045}},14,"F-H0-18019",837,2},
  {{{0x1c287caedaace4}},8,"F-H0-18020",418,2},
  {{{0x37e81fe6e6e87b14}},10,"F-H0-18021",529,2},
  {{{0xf426114ae0d36bb4}},13,"F-H0-18022",464,4},
  {{{0x46d537e7fe685c31}},9,"F-H0-18023",986,2},
  {{{0xf9c7b609ec2c7f91}},9,"F-H0-18024",913,4},
  {{{0x100807f6c256a9da}},9,"F-H0-18025",457,3},
  {{{0xeaaba0f984a2bb55}},8,"F-H0-18026",941,2},
  {{{0xde7558e0a8707391}},1,"F-H0-18027",900,2},
  {{{0xb6bd7a28119e2039}},20,"F-H0-18028",947,2},
  {{{0xa6c8f1965a39435f}},16,"F-H0-18029",947,2},
  {{{0xf6f77dc7394a227f}},16,"F-H0-18030",567,2},
  {{{0x89ff55970ea52eb3}},9,"F-H0-18031",876,4},
  {{{0xe9376747eb5c1e39}},7,"F-H0-18032",825,3},
  {{{0xaa3cf1e4fa593eb9}},18,"F-H0-18033",455,4},
  {{{0x59964462eb984c0e}},10,"F-H0-18034",566,2},
  {{{0x8d2e70134937121b}},16,"F-H0-18035",824,4},
  {{{0xaad67dce92af0cb0}},11,"F-H0-18036",873,2},
  {{{0x6043ca479867e751}},8,"F-H0-18037",910,2},
  {{{0x2908e5efc0de0b25}},6,"F-H0-18038",986,2},
  {{{0x97abbe7758d41c7d}},8,"F-H0-18039",691,3},
  {{{0x11d67f1fd764c141}},6,"F-H0-18040",911,2},
  {{{0x11d67f1fd764c141}},6,"F-H0-18041",873,2},
  {{{0xbc46d21357fcf906}},4,"F-H0-18042",456,2},
  {{{0x210f618e370d29c9}},4,"F-H0-18043",826,2},
  {{{0xa1b27f3eac21ed5f}},16,"F-H0-18044",615,2},
  {{{0x501d14419d4e1db4}},17,"F-H0-18045",467,4},
  {{{0xf03cd9ad742b27bb}},12,"F-H0-18046",911,4},
  {{{0xd04f8a803d83b8d3}},6,"F-H0-18047",910,2},
  {{{0x6976b87ea8a0605f}},7,"F-H0-18048",825,3},
  {{{0x323a6f6aca6d9a14}},4,"F-H0-18049",429,2},
  {{{0x83aba4efe3a85aa2}},15,"F-H0-18050",907,2},
  {{{0x29de11eeda97d52b}},8,"F-H0-18051",394,3},
  {{{0xaab1d811641f0996}},14,"F-H0-18052",914,4},
  {{{0x64cc6e4f9bf3d75f}},7,"F-H0-18053",652,2},
  {{{0xac7e45dcea934867}},18,"F-H0-18054",948,2},
  {{{0xa6dd78d3d22569ca}},13,"F-H0-18055",902,2},
  {{{0x5cfac86f7a267867}},8,"F-H0-18056",654,4},
  {{{0x2b39e9fc4449664}},9,"F-H0-18057",940,2},
  {{{0x2b39e9fc4449664}},9,"F-H0-18058",939,2},
  {{{0xa81652683abfed3e}},6,"F-H0-18059",493,2},
  {{{0x4db3e704979d8cb8}},8,"F-H0-18060",913,2},
  {{{0x953ed3dc174052d9}},6,"F-H0-18061",429,3},
  {{{0xff54064684ef6fad}},7,"F-H0-18062",875,2},
  {{{0xa1f46a74edd6bcce}},12,"F-H0-18063",910,2},
  {{{0xe1a0dc1f43ed7ad0}},2,"F-H2-1",949,386},
  {{{0xe1a0dc1f43ed7ad0}},2,"F-H2-2",912,264},
  {{{0xe1a0dc1f43ed7ad0}},2,"F-H2-3",948,137},
  {{{0xe1a0dc1f43ed7ad0}},2,"F-H2-4",493,128},
  {{{0xe1a0dc1f43ed7ad0}},2,"F-H2-5",543,12},
  {{{0xe1a0dc1f43ed7ad0}},2,"F-H2-7",950,9},
  {{{0xe1a0dc1f43ed7ad0}},2,"F-H2-8",684,8},
  {{{0xaa59e6f350fe1828}},3,"F-H2-10",456,412},
  {{{0xaa59e6f350fe1828}},3,"F-H2-11",455,153},
  {{{0xaa59e6f350fe1828}},3,"F-H2-12",875,151},
  {{{0xf64d502bf696bd80}},3,"F-H2-13",455,148},
  {{{0xaa59e6f350fe1828}},3,"F-H2-14",876,43},
  {{{0xaa59e6f350fe1828}},3,"F-H2-15",457,22},
  {{{0xf64d502bf696bd80}},3,"F-H2-16",457,21},
  {{{0xaa59e6f350fe1828}},3,"F-H2-17",838,20},
  {{{0xf64d502bf696bd80}},3,"F-H2-18",492,18},
  {{{0xaa59e6f350fe1828}},3,"F-H2-19",492,14},
  {{{0xaa59e6f350fe1828}},3,"F-H2-20",684,11},
  {{{0xaa59e6f350fe1828}},3,"F-H2-21",418,10},
  {{{0xf64d502bf696bd80}},3,"F-H2-22",494,7},
  {{{0xf64d502bf696bd80}},3,"F-H2-23",947,5},
  {{{0xdc0e39f8073806d5}},4,"F-H2-24",543,210},
  {{{0xdc0e39f8073806d5}},4,"F-H2-25",939,49},
  {{{0xff195affdc37f1f3}},4,"F-H2-26",839,43},
  {{{0x10ee640c4f05470}},4,"F-H2-27",421,28},
  {{{0xdc0e39f8073806d5}},4,"F-H2-28",839,17},
  {{{0xdc0e39f8073806d5}},4,"F-H2-29",876,13},
  {{{0xdc0e39f8073806d5}},4,"F-H2-30",728,6},
  {{{0xdc0e39f8073806d5}},4,"F-H2-31",425,3},
  {{{0x10ee640c4f05470}},4,"F-H2-32",825,3},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-33",456,257},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-34",455,143},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-35",493,33},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-36",839,32},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-37",492,18},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-38",494,6},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-39",418,6},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-40",684,5},
  {{{0x8c2e89811d2cbb1b}},3,"F-H2-41",458,4},
  {{{0x6629148e3a433246}},5,"F-H2-42",429,100},
  {{{0x6629148e3a433246}},5,"F-H2-43",466,96},
  {{{0x6629148e3a433246}},5,"F-H2-44",653,55},
  {{{0x8e7c08a3bfb59dab}},5,"F-H2-45",941,51},
  {{{0x6629148e3a433246}},5,"F-H2-46",875,33},
  {{{0x6629148e3a433246}},5,"F-H2-47",690,17},
  {{{0x8e7c08a3bfb59dab}},5,"F-H2-48",910,11},
  {{{0x6629148e3a433246}},5,"F-H2-49",462,8},
  {{{0xe1832a9314a444e0}},5,"F-H2-50",466,8},
  {{{0x8e7c08a3bfb59dab}},5,"F-H2-51",462,6},
  {{{0x8e7c08a3bfb59dab}},5,"F-H2-52",948,5},
  {{{0x6629148e3a433246}},5,"F-H2-53",728,3},
  {{{0x6629148e3a433246}},5,"F-H2-54",469,2},
  {{{0x8e7c08a3bfb59dab}},5,"F-H2-55",943,2},
  {{{0x8e7c08a3bfb59dab}},5,"F-H2-56",788,2},
  {{{0x6629148e3a433246}},5,"F-H2-57",506,2},
  {{{0x6629148e3a433246}},5,"F-H2-58",616,2},
  {{{0x6629148e3a433246}},5,"F-H2-59",839,2},
  {{{0xd272a88252428099}},4,"F-H2-60",543,130},
  {{{0x42d9d47ac42a73cc}},4,"F-H2-61",947,60},
  {{{0xd272a88252428099}},4,"F-H2-62",429,15},
  {{{0xd272a88252428099}},4,"F-H2-63",425,4},
  {{{0xd272a88252428099}},4,"F-H2-64",579,3},
  {{{0xd272a88252428099}},4,"F-H2-65",459,3},
  {{{0xd272a88252428099}},4,"F-H2-66",678,2},
  {{{0xd272a88252428099}},4,"F-H2-67",906,2},
  {{{0x61514e4f0cca675b}},3,"F-H2-68",456,160},
  {{{0x61514e4f0cca675b}},3,"F-H2-69",455,55},
  {{{0x61514e4f0cca675b}},3,"F-H2-70",419,35},
  {{{0x7953cdd2c6c66ef6}},3,"F-H2-71",949,18},
  {{{0x61514e4f0cca675b}},3,"F-H2-72",875,14},
  {{{0x7953cdd2c6c66ef6}},3,"F-H2-73",457,8},
  {{{0x7953cdd2c6c66ef6}},3,"F-H2-74",493,7},
  {{{0x61514e4f0cca675b}},3,"F-H2-75",492,6},
  {{{0x61514e4f0cca675b}},3,"F-H2-76",418,2},
  {{{0x61514e4f0cca675b}},3,"F-H2-77",912,2},
  {{{0x61514e4f0cca675b}},3,"F-H2-78",420,2},
  {{{0x61514e4f0cca675b}},3,"F-H2-79",494,2},
  {{{0x5008c9fca6e7a6cd}},3,"F-H2-80",912,139},
  {{{0xe0f44289cefce5f1}},3,"F-H2-81",419,41},
  {{{0xe0f44289cefce5f1}},3,"F-H2-82",455,32},
  {{{0x5008c9fca6e7a6cd}},3,"F-H2-83",419,17},
  {{{0x3ba61df40185e3a9}},3,"F-H2-84",911,12},
  {{{0x7d635f9f7c3ac649}},3,"F-H2-85",492,8},
  {{{0x7d635f9f7c3ac649}},3,"F-H2-86",493,6},
  {{{0x7d635f9f7c3ac649}},3,"F-H2-87",420,6},
  {{{0x7d635f9f7c3ac649}},3,"F-H2-88",458,3},
  {{{0x3ba61df40185e3a9}},3,"F-H2-89",950,3},
  {{{0x3ba61df40185e3a9}},3,"F-H2-90",874,3},
  {{{0x7d635f9f7c3ac649}},3,"F-H2-91",690,2},
  {{{0x7d635f9f7c3ac649}},3,"F-H2-92",684,2},
  {{{0x405e7bfc77919175}},5,"F-H2-93",466,76},
  {{{0xf41fd109540f9b30}},5,"F-H2-94",825,66},
  {{{0x405e7bfc77919175}},5,"F-H2-95",617,25},
  {{{0xf41fd109540f9b30}},5,"F-H2-96",905,15},
  {{{0x405e7bfc77919175}},5,"F-H2-97",542,6},
  {{{0xf41fd109540f9b30}},5,"F-H2-98",906,6},
  {{{0x8b5f42c30f63c65b}},5,"F-H2-99",940,3},
  {{{0x8b5f42c30f63c65b}},5,"F-H2-100",690,2},
  {{{0xf41fd109540f9b30}},5,"F-H2-101",678,2},
  {{{0x80e063a0b22d1cb4}},5,"F-H2-102",503,2},
  {{{0xf41fd109540f9b30}},5,"F-H2-103",839,2},
  {{{0x5eff895a6f460ffa}},4,"F-H2-104",493,73},
  {{{0xb83bca718892a3f7}},4,"F-H2-105",948,38},
  {{{0xbd6d70cba1b15e81}},4,"F-H2-106",543,17},
  {{{0xbd6d70cba1b15e81}},4,"F-H2-107",458,15},
  {{{0xbd6d70cba1b15e81}},4,"F-H2-108",421,10},
  {{{0xbd6d70cba1b15e81}},4,"F-H2-109",939,3},
  {{{0x5eff895a6f460ffa}},4,"F-H2-110",947,2},
  {{{0x4891ce8ac09ea941}},4,"F-H2-111",460,37},
  {{{0x2e011d22862a8055}},4,"F-H2-112",802,25},
  {{{0x2e011d22862a8055}},4,"F-H2-113",419,25},
  {{{0x6e96df8cf724f148}},4,"F-H2-114",456,21},
  {{{0x2e011d22862a8055}},4,"F-H2-115",455,14},
  {{{0x2e011d22862a8055}},4,"F-H2-116",876,12},
  {{{0x2e011d22862a8055}},4,"F-H2-117",420,11},
  {{{0x6e96df8cf724f148}},4,"F-H2-118",838,7},
  {{{0x2e011d22862a8055}},4,"F-H2-119",874,6},
  {{{0x6e96df8cf724f148}},4,"F-H2-120",493,6},
  {{{0x2e011d22862a8055}},4,"F-H2-121",492,5},
  {{{0x2e011d22862a8055}},4,"F-H2-122",727,4},
  {{{0x2e011d22862a8055}},4,"F-H2-123",543,3},
  {{{0x6e96df8cf724f148}},4,"F-H2-124",839,2},
  {{{0x2e011d22862a8055}},4,"F-H2-125",493,2},
  {{{0x2e011d22862a8055}},4,"F-H2-126",801,2},
  {{{0x606daf7362790c24}},4,"F-H2-127",457,54},
  {{{0x606daf7362790c24}},4,"F-H2-128",420,41},
  {{{0x83ff56e2ac8e5d5f}},4,"F-H2-129",543,21},
  {{{0x606daf7362790c24}},4,"F-H2-130",458,17},
  {{{0x606daf7362790c24}},4,"F-H2-131",543,6},
  {{{0x83ff56e2ac8e5d5f}},4,"F-H2-132",529,5},
  {{{0x29f114b2075fb4f2}},4,"F-H2-133",825,58},
  {{{0xf4ccf0fec93eacde}},4,"F-H2-134",543,35},
  {{{0xf4ccf0fec93eacde}},4,"F-H2-135",529,13},
  {{{0xf4ccf0fec93eacde}},4,"F-H2-136",421,11},
  {{{0xe0d994c77f85683e}},4,"F-H2-137",825,3},
  {{{0xf4ccf0fec93eacde}},4,"F-H2-138",425,3},
  {{{0xe0d994c77f85683e}},4,"F-H2-139",429,3},
  {{{0xf4ccf0fec93eacde}},4,"F-H2-140",913,3},
  {{{0xf4ccf0fec93eacde}},4,"F-H2-141",838,2},
  {{{0xf4ccf0fec93eacde}},4,"F-H2-142",874,2},
  {{{0xb09fce51b7b7b3b8}},4,"F-H2-143",939,50},
  {{{0x2495f598b8e946d6}},4,"F-H2-144",429,32},
  {{{0xb09fce51b7b7b3b8}},4,"F-H2-145",529,17},
  {{{0xb09fce51b7b7b3b8}},4,"F-H2-146",421,14},
  {{{0xb09fce51b7b7b3b8}},4,"F-H2-147",903,7},
  {{{0x8e968c059af25b42}},4,"F-H2-148",949,3},
  {{{0xb09fce51b7b7b3b8}},4,"F-H2-149",425,3},
  {{{0x882639cef6aa5690}},4,"F-H2-150",939,2},
  {{{0x8e968c059af25b42}},4,"F-H2-151",425,2},
  {{{0x8e968c059af25b42}},4,"F-H2-152",948,2},
  {{{0x8d83c798f9f4db13}},4,"F-H2-153",493,48},
  {{{0xb311e1b1f4cbd8cd}},4,"F-H2-154",420,30},
  {{{0xb311e1b1f4cbd8cd}},4,"F-H2-155",458,14},
  {{{0xb311e1b1f4cbd8cd}},4,"F-H2-156",543,14},
  {{{0x8d83c798f9f4db13}},4,"F-H2-157",543,11},
  {{{0xb311e1b1f4cbd8cd}},4,"F-H2-158",421,8},
  {{{0xb311e1b1f4cbd8cd}},4,"F-H2-159",429,2},
  {{{0xffcac0bf5ba12781}},6,"F-H2-160",728,70},
  {{{0x5d5c0eae0f1ab9f1}},6,"F-H2-161",543,10},
  {{{0x5d5c0eae0f1ab9f1}},6,"F-H2-162",907,7},
  {{{0xc0033e440f951e68}},6,"F-H2-163",715,6},
  {{{0xffcac0bf5ba12781}},6,"F-H2-164",470,5},
  {{{0xffcac0bf5ba12781}},6,"F-H2-165",690,5},
  {{{0x5d5c0eae0f1ab9f1}},6,"F-H2-166",751,3},
  {{{0x35e66d0230a34012}},6,"F-H2-167",728,65},
  {{{0x35e66d0230a34012}},6,"F-H2-168",939,13},
  {{{0x9b56ff9fb35ef46b}},6,"F-H2-169",974,9},
  {{{0x35e66d0230a34012}},6,"F-H2-170",727,6},
  {{{0x35e66d0230a34012}},6,"F-H2-171",690,5},
  {{{0x9b56ff9fb35ef46b}},6,"F-H2-172",421,2},
  {{{0x702c8022894bfaa6}},5,"F-H2-173",529,34},
  {{{0xc01b65618f41f327}},5,"F-H2-174",838,23},
  {{{0x702c8022894bfaa6}},5,"F-H2-175",423,18},
  {{{0x5c94dd8e790ed66}},5,"F-H2-176",641,11},
  {{{0xc01b65618f41f327}},5,"F-H2-177",906,9},
  {{{0x5c94dd8e790ed66}},5,"F-H2-178",530,7},
  {{{0x5c94dd8e790ed66}},5,"F-H2-179",677,3},
  {{{0x702c8022894bfaa6}},5,"F-H2-180",566,2},
  {{{0x34ef91b7340e2e88}},7,"F-H2-181",678,37},
  {{{0x34ef91b7340e2e88}},7,"F-H2-182",906,17},
  {{{0x34ef91b7340e2e88}},7,"F-H2-183",425,12},
  {{{0x34ef91b7340e2e88}},7,"F-H2-184",943,10},
  {{{0x34ef91b7340e2e88}},7,"F-H2-185",462,3},
  {{{0xca2c1be6f1536d95}},7,"F-H2-186",801,3},
  {{{0x34ef91b7340e2e88}},7,"F-H2-187",470,3},
  {{{0xf1b651c50edba1cd}},6,"F-H2-188",690,41},
  {{{0x4082f9e5a897c8c8}},6,"F-H2-189",429,11},
  {{{0x8e20406c99a86d18}},6,"F-H2-190",905,6},
  {{{0xc5a45daf6ccc610a}},6,"F-H2-191",394,6},
  {{{0x8e20406c99a86d18}},6,"F-H2-192",640,5},
  {{{0x8e20406c99a86d18}},6,"F-H2-193",943,5},
  {{{0xf1b651c50edba1cd}},6,"F-H2-194",427,5},
  {{{0x8e20406c99a86d18}},6,"F-H2-195",421,4},
  {{{0xf1b651c50edba1cd}},6,"F-H2-196",728,2},
  {{{0x8e20406c99a86d18}},6,"F-H2-197",529,2},
  {{{0x565bef50c4995995}},5,"F-H2-198",529,27},
  {{{0x7faa94720c2aebfd}},5,"F-H2-199",603,24},
  {{{0xdad03979703689f}},5,"F-H2-200",910,15},
  {{{0x7faa94720c2aebfd}},5,"F-H2-201",641,13},
  {{{0x7faa94720c2aebfd}},5,"F-H2-202",911,7},
  {{{0x7faa94720c2aebfd}},5,"F-H2-203",678,4},
  {{{0x7faa94720c2aebfd}},5,"F-H2-204",530,2},
  {{{0x565bef50c4995995}},5,"F-H2-205",838,2},
  {{{0x2dcb50c903b3924f}},7,"F-H2-206",943,27},
  {{{0x1d498c144ac8b4c6}},7,"F-H2-207",462,25},
  {{{0x2dcb50c903b3924f}},7,"F-H2-208",906,11},
  {{{0x1d498c144ac8b4c6}},7,"F-H2-209",801,9},
  {{{0x2dcb50c903b3924f}},7,"F-H2-210",944,7},
  {{{0x2dcb50c903b3924f}},7,"F-H2-211",875,3},
  {{{0x2dcb50c903b3924f}},7,"F-H2-212",947,2},
  {{{0x2dcb50c903b3924f}},7,"F-H2-213",940,2},
  {{{0x993df926d987fea}},5,"F-H2-214",604,33},
  {{{0x368f466d38dcbb9}},5,"F-H2-215",420,24},
  {{{0x993df926d987fea}},5,"F-H2-216",566,15},
  {{{0x368f466d38dcbb9}},5,"F-H2-217",530,6},
  {{{0x368f466d38dcbb9}},5,"F-H2-218",876,4},
  {{{0x993df926d987fea}},5,"F-H2-219",911,4},
  {{{0x368f466d38dcbb9}},5,"F-H2-220",494,2},
  {{{0x368f466d38dcbb9}},5,"F-H2-221",838,2},
  {{{0xf2c5d429a769921a}},5,"F-H2-222",902,42},
  {{{0xb5233fafac7b4498}},5,"F-H2-223",429,33},
  {{{0xb5233fafac7b4498}},5,"F-H2-224",690,3},
  {{{0xb5233fafac7b4498}},5,"F-H2-225",653,3},
  {{{0x196016c745e94770}},5,"F-H2-226",902,2},
  {{{0x196016c745e94770}},5,"F-H2-227",875,2},
  {{{0xb5233fafac7b4498}},5,"F-H2-228",428,2},
  {{{0xb5233fafac7b4498}},5,"F-H2-229",617,2},
  {{{0xd268be7b19dd3803}},5,"F-H2-230",826,25},
  {{{0xea3c0bf0a9ea9e0f}},5,"F-H2-231",939,22},
  {{{0xd268be7b19dd3803}},5,"F-H2-232",875,12},
  {{{0xd268be7b19dd3803}},5,"F-H2-233",941,8},
  {{{0x3a3da2569c2b97ee}},5,"F-H2-234",653,4},
  {{{0xd268be7b19dd3803}},5,"F-H2-235",876,2},
  {{{0x5f7c42be75e56e11}},5,"F-H2-236",420,29},
  {{{0x5f7c42be75e56e11}},5,"F-H2-237",460,21},
  {{{0x5f7c42be75e56e11}},5,"F-H2-238",422,12},
  {{{0xfcae2cf35daeb0bd}},5,"F-H2-239",838,6},
  {{{0x5f7c42be75e56e11}},5,"F-H2-240",911,5},
  {{{0x5f7c42be75e56e11}},5,"F-H2-241",948,5},
  {{{0x482ab15d25ec2082}},6,"F-H2-242",906,26},
  {{{0x482ab15d25ec2082}},6,"F-H2-243",543,12},
  {{{0x482ab15d25ec2082}},6,"F-H2-244",974,6},
  {{{0x482ab15d25ec2082}},6,"F-H2-245",421,6},
  {{{0x3b9afc7865d9c65e}},6,"F-H2-246",654,5},
  {{{0x3b9afc7865d9c65e}},6,"F-H2-247",653,3},
  {{{0x482ab15d25ec2082}},6,"F-H2-248",429,2},
  {{{0x3b9afc7865d9c65e}},6,"F-H2-249",728,2},
  {{{0x482ab15d25ec2082}},6,"F-H2-250",943,2},
  {{{0xd4dffc7dbd017c54}},5,"F-H2-251",460,24},
  {{{0x6eee500f8af34bbf}},5,"F-H2-252",457,11},
  {{{0xd4dffc7dbd017c54}},5,"F-H2-253",911,10},
  {{{0x6eee500f8af34bbf}},5,"F-H2-254",566,10},
  {{{0xd4dffc7dbd017c54}},5,"F-H2-255",459,5},
  {{{0xd4dffc7dbd017c54}},5,"F-H2-256",948,5},
  {{{0x6eee500f8af34bbf}},5,"F-H2-257",603,3},
  {{{0xe09c3d232d5e11af}},5,"F-H2-258",944,2},
  {{{0xd4dffc7dbd017c54}},5,"F-H2-259",461,2},
  {{{0x93b6a686075aa2d5}},6,"F-H2-260",541,17},
  {{{0x93b6a686075aa2d5}},6,"F-H2-261",429,9},
  {{{0x93b6a686075aa2d5}},6,"F-H2-262",432,8},
  {{{0x93b6a686075aa2d5}},6,"F-H2-263",839,7},
  {{{0x93b6a686075aa2d5}},6,"F-H2-264",466,7},
  {{{0x399164003cd16262}},6,"F-H2-265",904,5},
  {{{0x93b6a686075aa2d5}},6,"F-H2-266",578,2},
  {{{0x93b6a686075aa2d5}},6,"F-H2-267",939,2},
  {{{0x93b6a686075aa2d5}},6,"F-H2-268",421,2},
  {{{0x251f9b149e5f688a}},5,"F-H2-269",460,30},
  {{{0x73f0063886227971}},5,"F-H2-270",492,21},
  {{{0x251f9b149e5f688a}},5,"F-H2-271",422,13},
  {{{0x73f0063886227971}},5,"F-H2-272",458,6},
  {{{0x73f0063886227971}},5,"F-H2-273",494,5},
  {{{0x73f0063886227971}},5,"F-H2-274",421,3},
  {{{0xdd5aa76e8a2999f4}},5,"F-H2-275",801,3},
  {{{0xb7a692798e100b52}},4,"F-H2-276",456,14},
  {{{0xb7a692798e100b52}},4,"F-H2-277",764,13},
  {{{0xb7a692798e100b52}},4,"F-H2-278",419,13},
  {{{0xb7a692798e100b52}},4,"F-H2-279",728,6},
  {{{0xb7a692798e100b52}},4,"F-H2-280",727,5},
  {{{0xb7a692798e100b52}},4,"F-H2-281",455,4},
  {{{0xb7a692798e100b52}},4,"F-H2-282",457,4},
  {{{0xb7a692798e100b52}},4,"F-H2-283",801,3},
  {{{0xb7a692798e100b52}},4,"F-H2-284",802,3},
  {{{0xc3327049087abb04}},4,"F-H2-285",493,2},
  {{{0xb7a692798e100b52}},4,"F-H2-286",939,2},
  {{{0x2c84b0f4a441cf9f}},5,"F-H2-287",466,29},
  {{{0x55207173519e662}},5,"F-H2-288",825,25},
  {{{0x2c84b0f4a441cf9f}},5,"F-H2-289",653,4},
  {{{0x55207173519e662}},5,"F-H2-290",906,3},
  {{{0x55207173519e662}},5,"F-H2-291",788,2},
  {{{0x2c84b0f4a441cf9f}},5,"F-H2-292",462,2},
  {{{0x55207173519e662}},5,"F-H2-293",913,2},
  {{{0x690fb4bb0253fda8}},7,"F-H2-294",947,20},
  {{{0x9d61d79a273fb1d9}},7,"F-H2-295",462,16},
  {{{0x690fb4bb0253fda8}},7,"F-H2-296",425,8},
  {{{0x9d61d79a273fb1d9}},7,"F-H2-297",678,3},
  {{{0x88cb4aa51b69d9fc}},5,"F-H2-298",460,25},
  {{{0xde0e1b0a20611271}},5,"F-H2-299",875,7},
  {{{0xde0e1b0a20611271}},5,"F-H2-300",493,5},
  {{{0x259e6106249a4aa7}},5,"F-H2-301",802,4},
  {{{0x88cb4aa51b69d9fc}},5,"F-H2-302",459,3},
  {{{0x88cb4aa51b69d9fc}},5,"F-H2-303",424,3},
  {{{0x88cb4aa51b69d9fc}},5,"F-H2-304",530,3},
  {{{0x88cb4aa51b69d9fc}},5,"F-H2-305",876,2},
  {{{0x9b25916068c8dfc4}},6,"F-H2-306",429,21},
  {{{0x585097c39fac39eb}},6,"F-H2-307",865,16},
  {{{0x9b25916068c8dfc4}},6,"F-H2-308",728,5},
  {{{0x585097c39fac39eb}},6,"F-H2-309",826,5},
  {{{0x9b25916068c8dfc4}},6,"F-H2-310",839,3},
  {{{0x9b25916068c8dfc4}},6,"F-H2-311",432,3},
  {{{0xb113ade21687ec27}},5,"F-H2-312",466,17},
  {{{0xc213cc0f5b24d908}},5,"F-H2-313",543,14},
  {{{0xb113ade21687ec27}},5,"F-H2-314",653,8},
  {{{0xc213cc0f5b24d908}},5,"F-H2-315",427,4},
  {{{0xb113ade21687ec27}},5,"F-H2-316",690,3},
  {{{0x95afb9cd6fb7f48a}},4,"F-H2-317",457,21},
  {{{0x95afb9cd6fb7f48a}},4,"F-H2-318",420,10},
  {{{0x95afb9cd6fb7f48a}},4,"F-H2-319",939,10},
  {{{0x7f54159698d145bf}},4,"F-H2-320",947,4},
  {{{0x95afb9cd6fb7f48a}},4,"F-H2-321",458,3},
  {{{0x95afb9cd6fb7f48a}},4,"F-H2-322",543,2},
  {{{0xc6110b56a4452cbc}},5,"F-H2-323",838,25},
  {{{0x9a9ed9f322576230}},5,"F-H2-324",493,11},
  {{{0x9a9ed9f322576230}},5,"F-H2-325",950,8},
  {{{0xc6110b56a4452cbc}},5,"F-H2-326",420,2},
  {{{0xc6110b56a4452cbc}},5,"F-H2-327",876,2},
  {{{0x78a8b75f678093b5}},8,"F-H2-328",939,24},
  {{{0x78a8b75f678093b5}},8,"F-H2-329",421,8},
  {{{0x78a8b75f678093b5}},8,"F-H2-330",424,7},
  {{{0x79cd60f426267b29}},8,"F-H2-331",751,5},
  {{{0x79cd60f426267b29}},8,"F-H2-332",690,2},
  {{{0xc31d6d80231c496a}},6,"F-H2-333",653,14},
  {{{0xc31d6d80231c496a}},6,"F-H2-334",690,14},
  {{{0x2baa392d6be20ff6}},6,"F-H2-335",429,8},
  {{{0xda12592eea3060ad}},5,"F-H2-336",943,19},
  {{{0xda12592eea3060ad}},5,"F-H2-337",944,8},
  {{{0xda12592eea3060ad}},5,"F-H2-338",462,8},
  {{{0xda12592eea3060ad}},5,"F-H2-339",678,7},
  {{{0xda12592eea3060ad}},5,"F-H2-340",906,6},
  {{{0xad21bc3266774d35}},5,"F-H2-341",466,15},
  {{{0x162955a8fe54edd}},5,"F-H2-342",825,11},
  {{{0xad21bc3266774d35}},5,"F-H2-343",617,9},
  {{{0xad21bc3266774d35}},5,"F-H2-344",653,3},
  {{{0xad21bc3266774d35}},5,"F-H2-345",875,2},
  {{{0xad21bc3266774d35}},5,"F-H2-346",462,2},
  {{{0xad21bc3266774d35}},5,"F-H2-347",690,2},
  {{{0xfb2fd3251c290041}},4,"F-H2-348",939,11},
  {{{0xb3940264a53c0e9e}},4,"F-H2-349",913,11},
  {{{0x9081072dbb4b4525}},4,"F-H2-350",939,9},
  {{{0xfb2fd3251c290041}},4,"F-H2-351",825,2},
  {{{0x9081072dbb4b4525}},4,"F-H2-352",425,2},
  {{{0xfb2fd3251c290041}},4,"F-H2-353",429,2},
  {{{0xd167e31f314400c8}},4,"F-H2-354",493,21},
  {{{0xd1fc8762113eebec}},4,"F-H2-355",458,7},
  {{{0xd1fc8762113eebec}},4,"F-H2-356",420,7},
  {{{0xf245e0641d10500b}},4,"F-H2-357",429,2},
  {{{0xf245e0641d10500b}},4,"F-H2-358",825,2},
  {{{0xa4f598862f1fc3d}},5,"F-H2-359",530,16},
  {{{0x23be22aaaa424e55}},5,"F-H2-360",603,6},
  {{{0xa4f598862f1fc3d}},5,"F-H2-361",462,6},
  {{{0xa4f598862f1fc3d}},5,"F-H2-362",529,4},
  {{{0x23be22aaaa424e55}},5,"F-H2-363",641,3},
  {{{0xa1782c5229c8ab73}},5,"F-H2-364",457,3},
  {{{0xa4f598862f1fc3d}},5,"F-H2-365",948,2},
  {{{0xa772426502cc74e8}},5,"F-H2-366",838,23},
  {{{0xa772426502cc74e8}},5,"F-H2-367",876,6},
  {{{0xc56fb6e989e139ba}},5,"F-H2-368",950,6},
  {{{0xa772426502cc74e8}},5,"F-H2-369",529,5},
  {{{0xc56fb6e989e139ba}},5,"F-H2-370",909,3},
  {{{0x2e6f5aa244c96abf}},5,"F-H2-371",909,14},
  {{{0xbce5321d4eb7d427}},5,"F-H2-372",837,12},
  {{{0x99c5792619e3e64f}},5,"F-H2-373",492,4},
  {{{0x2e6f5aa244c96abf}},5,"F-H2-374",910,3},
  {{{0xbce5321d4eb7d427}},5,"F-H2-375",800,2},
  {{{0xbce5321d4eb7d427}},5,"F-H2-376",456,2},
  {{{0x9f95f0e83d89296a}},4,"F-H2-377",947,9},
  {{{0x9f95f0e83d89296a}},4,"F-H2-378",910,6},
  {{{0x3340df2d8342ea86}},4,"F-H2-379",456,5},
  {{{0x1da2d5bcd78a3b6d}},4,"F-H2-380",461,5},
  {{{0x9f95f0e83d89296a}},4,"F-H2-381",765,4},
  {{{0x9f95f0e83d89296a}},4,"F-H2-382",690,3},
  {{{0x3340df2d8342ea86}},4,"F-H2-383",455,2},
  {{{0x9f95f0e83d89296a}},4,"F-H2-384",728,2},
  {{{0x805cd116ccd2eb54}},6,"F-H2-385",906,17},
  {{{0x22ca1f0798697524}},6,"F-H2-386",653,9},
  {{{0x22ca1f0798697524}},6,"F-H2-387",427,2},
  {{{0xfd427760b08a4af7}},6,"F-H2-388",429,2},
  {{{0x662038b65ddd431e}},6,"F-H2-389",429,13},
  {{{0x36ed60581f1c67d5}},6,"F-H2-390",422,11},
  {{{0x662038b65ddd431e}},6,"F-H2-391",764,11},
  {{{0xcb36c776d970324e}},6,"F-H2-392",459,18},
  {{{0x5730268d513583eb}},6,"F-H2-393",568,5},
  {{{0xcb36c776d970324e}},6,"F-H2-394",420,3},
  {{{0x5730268d513583eb}},6,"F-H2-395",530,3},
  {{{0x5730268d513583eb}},6,"F-H2-396",604,2},
  {{{0x5730268d513583eb}},6,"F-H2-397",531,2},
  {{{0x5808d1591af952a9}},6,"F-H2-398",382,11},
  {{{0x5808d1591af952a9}},6,"F-H2-399",462,7},
  {{{0xfc977906ea922fd}},6,"F-H2-400",939,5},
  {{{0x5808d1591af952a9}},6,"F-H2-401",426,2},
  {{{0x5808d1591af952a9}},6,"F-H2-402",543,2},
  {{{0x4a0440689ca4688a}},7,"F-H2-403",839,25},
  {{{0x4a0440689ca4688a}},7,"F-H2-404",462,6},
  {{{0x4a0440689ca4688a}},7,"F-H2-405",690,2},
  {{{0x702b75c535ee416f}},7,"F-H2-406",943,2},
  {{{0xa40cffda2f6861ee}},5,"F-H2-407",910,14},
  {{{0x3c69a5c311f2b456}},5,"F-H2-408",875,7},
  {{{0xa40cffda2f6861ee}},5,"F-H2-409",948,4},
  {{{0xa40cffda2f6861ee}},5,"F-H2-410",950,3},
  {{{0x3c69a5c311f2b456}},5,"F-H2-411",876,3},
  {{{0x4d3a4664b8d09933}},5,"F-H2-412",950,16},
  {{{0x133f366edbca5d12}},5,"F-H2-413",873,14},
  {{{0x4d3a4664b8d09933}},5,"F-H2-414",877,3},
  {{{0xeaed2ac2aa63b68b}},6,"F-H2-415",865,12},
  {{{0x44dd7d1f7d2d1af9}},6,"F-H2-416",936,10},
  {{{0x9dca37fc52202499}},6,"F-H2-417",429,4},
  {{{0xeaed2ac2aa63b68b}},6,"F-H2-418",904,2},
  {{{0x88eed7e5c7618a6b}},3,"F-H2-419",456,14},
  {{{0x88eed7e5c7618a6b}},3,"F-H2-420",949,5},
  {{{0x88eed7e5c7618a6b}},3,"F-H2-421",758,2},
  {{{0xad527542c66b7a16}},6,"F-H2-422",939,9},
  {{{0xad527542c66b7a16}},6,"F-H2-423",690,6},
  {{{0xeccd26bf7c5d5e39}},6,"F-H2-424",905,4},
  {{{0xad527542c66b7a16}},6,"F-H2-425",691,3},
  {{{0xeccd26bf7c5d5e39}},6,"F-H2-426",421,3},
  {{{0xeccd26bf7c5d5e39}},6,"F-H2-427",974,3},
  {{{0xf553425f4953860d}},4,"F-H2-428",455,22},
  {{{0xf553425f4953860d}},4,"F-H2-429",543,6},
  {{{0xf553425f4953860d}},4,"F-H2-430",939,4},
  {{{0xea8d2d161e76e3cc}},6,"F-H2-431",429,10},
  {{{0x931c03d481e2ef9}},6,"F-H2-432",653,9},
  {{{0x6e94e921be900cc5}},6,"F-H2-433",906,5},
  {{{0x81baddf4d90c306a}},4,"F-H2-434",457,12},
  {{{0xab3d9fe46288f754}},4,"F-H2-435",530,6},
  {{{0xab3d9fe46288f754}},4,"F-H2-436",529,6},
  {{{0xab3d9fe46288f754}},4,"F-H2-437",939,5},
  {{{0xab3d9fe46288f754}},4,"F-H2-438",492,3},
  {{{0xab3d9fe46288f754}},4,"F-H2-439",543,2},
  {{{0xbfc791c59a6236b3}},8,"F-H2-440",543,25},
  {{{0xb2841ae20c82f426}},8,"F-H2-441",906,3},
  {{{0xaebc25d756bb7acf}},5,"F-H2-442",460,18},
  {{{0xaebc25d756bb7acf}},5,"F-H2-443",493,4},
  {{{0xaebc25d756bb7acf}},5,"F-H2-444",530,4},
  {{{0xaebc25d756bb7acf}},5,"F-H2-446",459,2},
  {{{0xaebc25d756bb7acf}},5,"F-H2-447",424,2},
  {{{0x48993f7dc721e88c}},5,"F-H2-448",566,2},
  {{{0xd9aab1e8a42802b4}},8,"F-H2-449",429,11},
  {{{0x15deca924e5821ce}},8,"F-H2-450",677,7},
  {{{0x15deca924e5821ce}},8,"F-H2-451",908,6},
  {{{0x15deca924e5821ce}},8,"F-H2-452",529,3},
  {{{0x15deca924e5821ce}},8,"F-H2-453",909,2},
  {{{0x28539de78a9bd4a8}},4,"F-H2-454",455,17},
  {{{0x28539de78a9bd4a8}},4,"F-H2-455",939,5},
  {{{0x28539de78a9bd4a8}},4,"F-H2-456",543,2},
  {{{0x28539de78a9bd4a8}},4,"F-H2-457",677,2},
  {{{0x35c0601403736a93}},6,"F-H2-458",421,20},
  {{{0x35c0601403736a93}},6,"F-H2-459",456,7},
  {{{0x68e87983059e7df5}},5,"F-H2-460",420,14},
  {{{0x68e87983059e7df5}},5,"F-H2-461",875,5},
  {{{0x68e87983059e7df5}},5,"F-H2-462",423,4},
  {{{0x68e87983059e7df5}},5,"F-H2-463",495,3},
  {{{0xef6ea14b1c01e832}},4,"F-H2-464",493,8},
  {{{0xeff5c5363c7b0316}},4,"F-H2-465",458,7},
  {{{0x5ef62c325353404d}},4,"F-H2-466",948,4},
  {{{0xef6ea14b1c01e832}},4,"F-H2-467",543,3},
  {{{0xef6ea14b1c01e832}},4,"F-H2-468",939,2},
  {{{0x4d0c553df61f71ce}},6,"F-H2-469",418,9},
  {{{0x4d0c553df61f71ce}},6,"F-H2-470",421,5},
  {{{0xf3722cfa7790c2b}},6,"F-H2-471",530,3},
  {{{0x4d0c553df61f71ce}},6,"F-H2-472",455,2},
  {{{0x594cb7f7044f05a7}},6,"F-H2-473",531,9},
  {{{0x594cb7f7044f05a7}},6,"F-H2-474",567,7},
  {{{0x594cb7f7044f05a7}},6,"F-H2-475",492,4},
  {{{0x567440234f83d4e5}},6,"F-H2-476",382,13},
  {{{0x567440234f83d4e5}},6,"F-H2-477",462,3},
  {{{0x567440234f83d4e5}},6,"F-H2-478",425,2},
  {{{0x5d8ebfb148cc26e2}},6,"F-H2-479",751,2},
  {{{0xe3277399f0569869}},3,"F-H2-480",429,7},
  {{{0xb88d365e1ecc3c12}},3,"F-H2-481",902,7},
  {{{0x5766d96cd3c8922c}},3,"F-H2-482",456,4},
  {{{0x5766d96cd3c8922c}},3,"F-H2-483",941,4},
  {{{0xe3277399f0569869}},3,"F-H2-484",912,3},
  {{{0x50489fcba19581ef}},9,"F-H2-485",826,9},
  {{{0x50489fcba19581ef}},9,"F-H2-486",905,5},
  {{{0x4f683b7b7b596b21}},9,"F-H2-487",617,4},
  {{{0x4f683b7b7b596b21}},9,"F-H2-488",690,4},
  {{{0x872ea490bb4de617}},6,"F-H2-489",906,8},
  {{{0xd81e92507645454}},6,"F-H2-490",454,7},
  {{{0xd81e92507645454}},6,"F-H2-491",825,3},
  {{{0x29b1f33e9c234de0}},6,"F-H2-492",603,2},
  {{{0x6475d18cda5359fb}},7,"F-H2-493",466,12},
  {{{0xe8c0bfacc0bb3836}},6,"F-H2-494",421,26},
  {{{0xe8c0bfacc0bb3836}},6,"F-H2-495",456,3},
  {{{0xb302400e5f641421}},8,"F-H2-496",653,8},
  {{{0x35b8058ce5e2861a}},8,"F-H2-497",791,4},
  {{{0xb302400e5f641421}},8,"F-H2-498",727,3},
  {{{0xb302400e5f641421}},8,"F-H2-499",728,2},
  {{{0xc652265c66c6c06a}},6,"F-H2-500",530,9},
  {{{0xc652265c66c6c06a}},6,"F-H2-501",495,8},
  {{{0xda21d37fd4f4965f}},6,"F-H2-502",567,4},
  {{{0x980dac89c0c2b272}},9,"F-H2-503",617,12},
  {{{0x496c5eb596283d28}},9,"F-H2-504",826,4},
  {{{0x496c5eb596283d28}},9,"F-H2-505",905,4},
  {{{0x496c5eb596283d28}},9,"F-H2-506",864,2},
  {{{0x980dac89c0c2b272}},9,"F-H2-507",690,2},
  {{{0xd4524d0aff4915d8}},5,"F-H2-508",460,11},
  {{{0xd4524d0aff4915d8}},5,"F-H2-509",420,10},
  {{{0x1f2acd3055f2279b}},5,"F-H2-510",566,5},
  {{{0xd4524d0aff4915d8}},5,"F-H2-511",530,2},
  {{{0x7210cc7173cc4fa}},6,"F-H2-512",531,7},
  {{{0x7210cc7173cc4fa}},6,"F-H2-513",458,7},
  {{{0x7210cc7173cc4fa}},6,"F-H2-514",496,2},
  {{{0x1b52f9e4a50e92cf}},6,"F-H2-515",459,2},
  {{{0xfc5daac50cd3c4d9}},5,"F-H2-516",943,9},
  {{{0xb84b9f8060b768dc}},5,"F-H2-517",728,6},
  {{{0xfc5daac50cd3c4d9}},5,"F-H2-518",906,3},
  {{{0xfc5daac50cd3c4d9}},5,"F-H2-519",678,3},
  {{{0x5400553bcfc76422}},8,"F-H2-520",543,7},
  {{{0x5dc8f88bc695577f}},8,"F-H2-521",567,7},
  {{{0x5400553bcfc76422}},8,"F-H2-522",429,3},
  {{{0x5400553bcfc76422}},8,"F-H2-523",458,3},
  {{{0x5400553bcfc76422}},8,"F-H2-524",569,2},
  {{{0x6dcdf55ceee01fa3}},6,"F-H2-525",420,15},
  {{{0x2bfa3dd48013cf18}},6,"F-H2-526",839,5},
  {{{0x2bfa3dd48013cf18}},6,"F-H2-527",429,2},
  {{{0xb884e583f0abbaec}},7,"F-H2-528",419,21},
  {{{0x3c65635bc51ea6cd}},6,"F-H2-529",678,9},
  {{{0xe8e6b2baf36b12b7}},6,"F-H2-530",653,5},
  {{{0xe8e6b2baf36b12b7}},6,"F-H2-531",470,3},
  {{{0x465620277096a6ce}},6,"F-H2-532",543,2},
  {{{0x136c6d11e9e9fb33}},7,"F-H2-533",678,6},
  {{{0xbb16b8e86aed12ea}},7,"F-H2-534",875,5},
  {{{0x136c6d11e9e9fb33}},7,"F-H2-535",947,3},
  {{{0xe490535b56c31f44}},7,"F-H2-536",419,23},
  {{{0x89008a830c0f3687}},8,"F-H2-537",543,9},
  {{{0x80c82733055d05da}},8,"F-H2-538",825,6},
  {{{0x80c82733055d05da}},8,"F-H2-539",530,5},
  {{{0xd2042841f3a43b45}},8,"F-H2-540",801,3},
  {{{0x4e9f16f1484cdec6}},5,"F-H2-541",420,10},
  {{{0x4e9f16f1484cdec6}},5,"F-H2-542",530,4},
  {{{0xf4f1a81ec648248f}},5,"F-H2-543",603,3},
  {{{0x4e9f16f1484cdec6}},5,"F-H2-544",839,2},
  {{{0x5b3cf566dcf58ef6}},7,"F-H2-545",542,20},
  {{{0xa9c87d57468d05f6}},7,"F-H2-546",826,4},
  {{{0x5b3cf566dcf58ef6}},7,"F-H2-547",504,2},
  {{{0xf4849bc686869034}},5,"F-H2-548",603,9},
  {{{0x1cf64b2a5a9ba44c}},5,"F-H2-549",530,6},
  {{{0xf4849bc686869034}},5,"F-H2-550",678,4},
  {{{0x1cf64b2a5a9ba44c}},5,"F-H2-551",529,2},
  {{{0xf6a9b1f167fd5699}},8,"F-H2-552",939,7},
  {{{0xabe83d2ba46b4738}},8,"F-H2-553",529,6},
  {{{0xf6a9b1f167fd5699}},8,"F-H2-554",424,2},
  {{{0x3e5ead3411c7aa20}},8,"F-H2-555",945,8},
  {{{0x71a4cef30f83495b}},8,"F-H2-556",727,4},
  {{{0x3e5ead3411c7aa20}},8,"F-H2-557",839,3},
  {{{0x3e5ead3411c7aa20}},8,"F-H2-558",838,2},
  {{{0x71a4cef30f83495b}},8,"F-H2-559",728,2},
  {{{0x963ab351980e4d27}},6,"F-H2-560",839,11},
  {{{0x990c3c4065cc7f6a}},6,"F-H2-561",876,7},
  {{{0xe6a8d32f9d41e4e6}},5,"F-H2-562",466,7},
  {{{0x33bc8626a7a81f94}},5,"F-H2-563",825,5},
  {{{0xdad2bca3f1af1b9d}},5,"F-H2-564",493,3},
  {{{0xe6a8d32f9d41e4e6}},5,"F-H2-565",653,2},
  {{{0xe6a8d32f9d41e4e6}},5,"F-H2-566",617,2},
  {{{0xcdec0ea791567899}},5,"F-H2-567",419,16},
  {{{0xcdec0ea791567899}},5,"F-H2-568",423,5},
  {{{0x9e701bff60ada527}},6,"F-H2-569",418,7},
  {{{0x14bb3b5f2038a67}},6,"F-H2-570",495,5},
  {{{0x14bb3b5f2038a67}},6,"F-H2-571",460,4},
  {{{0x14bb3b5f2038a67}},6,"F-H2-572",529,2},
  {{{0x2ac7d78ec01913a3}},6,"F-H2-573",543,12},
  {{{0x2ac7d78ec01913a3}},6,"F-H2-574",421,2},
  {{{0x677ed8ffad691d85}},6,"F-H2-575",470,2},
  {{{0x677ed8ffad691d85}},6,"F-H2-576",691,2},
  {{{0x677ed8ffad691d85}},6,"F-H2-577",690,2},
  {{{0x708c6de6d4cd1204}},4,"F-H2-578",939,6},
  {{{0xabe83e68fa48d4d8}},4,"F-H2-579",419,5},
  {{{0xabe83e68fa48d4d8}},4,"F-H2-580",457,4},
  {{{0xabe83e68fa48d4d8}},4,"F-H2-581",425,2},
  {{{0xdbe99a0b225eb079}},5,"F-H2-582",429,10},
  {{{0xdbe99a0b225eb079}},5,"F-H2-583",466,6},
  {{{0xdbe99a0b225eb079}},5,"F-H2-584",838,2},
  {{{0xdbe99a0b225eb079}},5,"F-H2-585",617,2},
  {{{0xc8605cda8fb9b4ca}},5,"F-H2-586",420,8},
  {{{0xc8605cda8fb9b4ca}},5,"F-H2-587",460,6},
  {{{0xc8605cda8fb9b4ca}},5,"F-H2-588",422,4},
  {{{0x3f33a0a47da87a74}},5,"F-H2-589",455,3},
  {{{0xe5b17550419dc536}},4,"F-H2-590",458,10},
  {{{0x5429f8290ecf6d49}},4,"F-H2-591",456,3},
  {{{0x5429f8290ecf6d49}},4,"F-H2-592",801,2},
  {{{0xf4d1c131c720514c}},5,"F-H2-593",493,5},
  {{{0xa32cae96ed3855ea}},5,"F-H2-594",421,4},
  {{{0xa32cae96ed3855ea}},5,"F-H2-595",457,4},
  {{{0xf4d1c131c720514c}},5,"F-H2-596",492,3},
  {{{0x7f8462d3acc03cd7}},8,"F-H2-597",691,4},
  {{{0xa3bb6672e61c3759}},8,"F-H2-598",424,4},
  {{{0xa3bb6672e61c3759}},8,"F-H2-599",529,3},
  {{{0xa3bb6672e61c3759}},8,"F-H2-600",825,3},
  {{{0xa3bb6672e61c3759}},8,"F-H2-601",908,2},
  {{{0xf8b0754e917e57c7}},8,"F-H2-602",529,2},
  {{{0x587b146760951367}},4,"F-H2-603",910,6},
  {{{0x587b146760951367}},4,"F-H2-604",543,4},
  {{{0x107ac6867046722f}},4,"F-H2-605",455,3},
  {{{0xfa816add8720c31a}},4,"F-H2-606",493,2},
  {{{0xe8b68a16f6763126}},5,"F-H2-607",458,8},
  {{{0xe8b68a16f6763126}},5,"F-H2-608",603,5},
  {{{0x8551c47152a12f4b}},5,"F-H2-609",529,4},
  {{{0xe8b68a16f6763126}},5,"F-H2-610",678,3},
  {{{0xe8b68a16f6763126}},5,"F-H2-611",641,3},
  {{{0x9dab868afd8fed1}},6,"F-H2-612",825,14},
  {{{0x44f3535513f0037a}},6,"F-H2-613",765,2},
  {{{0x9dab868afd8fed1}},6,"F-H2-614",865,2},
  {{{0x190eb292bd176bcc}},4,"F-H2-615",419,4},
  {{{0x190eb292bd176bcc}},4,"F-H2-616",456,3},
  {{{0x8baf2095f2137a39}},4,"F-H2-617",948,2},
  {{{0x190eb292bd176bcc}},4,"F-H2-618",837,2},
  {{{0x190eb292bd176bcc}},4,"F-H2-619",910,2},
  {{{0x8baf2095f2137a39}},4,"F-H2-620",945,2},
  {{{0x8161563ce85d87f4}},5,"F-H2-621",529,9},
  {{{0x8161563ce85d87f4}},5,"F-H2-622",530,5},
  {{{0x8161563ce85d87f4}},5,"F-H2-623",423,3},
  {{{0x8161563ce85d87f4}},5,"F-H2-624",913,2},
  {{{0xbfee599b45b0a3c1}},3,"F-H2-625",456,11},
  {{{0xbfee599b45b0a3c1}},3,"F-H2-626",455,4},
  {{{0x855bc1e4a0eaf6d9}},5,"F-H2-627",457,7},
  {{{0xab20ae2b6c960ac6}},5,"F-H2-628",421,5},
  {{{0xab20ae2b6c960ac6}},5,"F-H2-629",946,2},
  {{{0xab20ae2b6c960ac6}},5,"F-H2-630",947,2},
  {{{0x6019c0f83acd74c8}},6,"F-H2-631",909,8},
  {{{0x8a30f93592fdd14e}},6,"F-H2-632",531,3},
  {{{0x163618ce1ab860eb}},6,"F-H2-633",458,3},
  {{{0xf47200897ac5cdb3}},8,"F-H2-634",945,7},
  {{{0xf47200897ac5cdb3}},8,"F-H2-635",839,4},
  {{{0xb7ae3fc2b3c704c1}},8,"F-H2-636",690,3},
  {{{0xa016a6b2e0480639}},8,"F-H2-637",461,2},
  {{{0x7d41f5a957603670}},7,"F-H2-638",494,16},
  {{{0xc36ebf400678ec95}},7,"F-H2-639",456,3},
  {{{0xaff99727f8386b3e}},6,"F-H2-640",529,18},
  {{{0xd286c76c8b9a87bc}},5,"F-H2-641",492,6},
  {{{0xd286c76c8b9a87bc}},5,"F-H2-642",876,3},
  {{{0xd286c76c8b9a87bc}},5,"F-H2-643",458,3},
  {{{0xd286c76c8b9a87bc}},5,"F-H2-644",604,2},
  {{{0x34fccf5ba3f6d85d}},5,"F-H2-645",495,2},
  {{{0x789470aa6cfa0031}},4,"F-H2-646",419,8},
  {{{0x7ef0fc9c81b79448}},4,"F-H2-647",543,6},
  {{{0x7ef0fc9c81b79448}},4,"F-H2-648",939,2},
  {{{0x7ef0fc9c81b79448}},4,"F-H2-649",493,2},
  {{{0x6791738d0f6eab27}},5,"F-H2-650",910,9},
  {{{0x6791738d0f6eab27}},5,"F-H2-651",493,2},
  {{{0xdee8d48faac620a9}},5,"F-H2-652",950,2},
  {{{0xef638ee287cac288}},5,"F-H2-653",567,2},
  {{{0x73ffff7002d4b969}},6,"F-H2-654",945,5},
  {{{0x73ffff7002d4b969}},6,"F-H2-655",825,4},
  {{{0x73ffff7002d4b969}},6,"F-H2-656",529,2},
  {{{0x1c5818b5c02ecd02}},8,"F-H2-657",432,10},
  {{{0x1c5818b5c02ecd02}},8,"F-H2-658",579,8},
  {{{0xc79a766704d6d765}},6,"F-H2-659",457,4},
  {{{0xc79a766704d6d765}},6,"F-H2-660",429,4},
  {{{0xc79a766704d6d765}},6,"F-H2-661",543,3},
  {{{0xc79a766704d6d765}},6,"F-H2-662",421,2},
  {{{0x877c1bf95975b0cb}},8,"F-H2-663",458,6},
  {{{0x53b469f193efd133}},8,"F-H2-664",825,4},
  {{{0x877c1bf95975b0cb}},8,"F-H2-665",543,4},
  {{{0x53b469f193efd133}},8,"F-H2-666",567,4},
  {{{0xadde3bcf677af5d3}},7,"F-H2-667",542,12},
  {{{0xadde3bcf677af5d3}},7,"F-H2-668",862,2},
  {{{0x5447d5aad5231f18}},7,"F-H2-669",542,2},
  {{{0x913f02a9bfebe832}},7,"F-H2-670",455,20},
  {{{0x701e105436d96d99}},7,"F-H2-671",875,4},
  {{{0x96641a9cef24d52b}},7,"F-H2-672",690,3},
  {{{0x701e105436d96d99}},7,"F-H2-673",974,2},
  {{{0x9c72f0e8d9b92845}},7,"F-H2-674",425,2},
  {{{0x104b1f582445efe1}},5,"F-H2-675",427,5},
  {{{0x64b4adf1c2676865}},5,"F-H2-676",825,5},
  {{{0x104b1f582445efe1}},5,"F-H2-677",462,3},
  {{{0x935b3716eb2e92ec}},6,"F-H2-678",690,5},
  {{{0x935b3716eb2e92ec}},6,"F-H2-679",653,3},
  {{{0x935b3716eb2e92ec}},6,"F-H2-680",939,2},
  {{{0x12a3db5e490be57b}},5,"F-H2-681",947,6},
  {{{0x12a3db5e490be57b}},5,"F-H2-682",839,3},
  {{{0x12a3db5e490be57b}},5,"F-H2-683",422,2},
  {{{0x12a3db5e490be57b}},5,"F-H2-684",427,2},
  {{{0xcf01f9f842139869}},7,"F-H2-685",826,15},
  {{{0xcf01f9f842139869}},7,"F-H2-686",825,3},
  {{{0x832242586eb8c64b}},7,"F-H2-687",429,4},
  {{{0x832242586eb8c64b}},7,"F-H2-688",617,3},
  {{{0xe56a85c366f776d6}},7,"F-H2-689",826,3},
  {{{0xe56a85c366f776d6}},7,"F-H2-690",902,2},
  {{{0xfc260a3af495cbcf}},6,"F-H2-691",640,3},
  {{{0xfc260a3af495cbcf}},6,"F-H2-692",839,3},
  {{{0x58dcff2de9342806}},6,"F-H2-693",423,3},
  {{{0x40204260a1be59c3}},5,"F-H2-694",838,6},
  {{{0xf8b60cb2303ecb41}},5,"F-H2-695",837,5},
  {{{0x40204260a1be59c3}},5,"F-H2-696",456,2},
  {{{0xd766e59f4ff7f7b8}},6,"F-H2-697",421,6},
  {{{0xe32f56077129527b}},6,"F-H2-698",495,4},
  {{{0xe32f56077129527b}},6,"F-H2-699",530,3},
  {{{0xd766e59f4ff7f7b8}},6,"F-H2-700",418,2},
  {{{0x102bf33419208db2}},8,"F-H2-701",531,16},
  {{{0xa8f40dc0a3097c20}},9,"F-H2-702",495,15},
  {{{0xdff2672f255a465d}},8,"F-H2-703",825,4},
  {{{0xdff2672f255a465d}},8,"F-H2-704",529,4},
  {{{0x1fa040d9186c4f2e}},8,"F-H2-705",801,3},
  {{{0xdff2672f255a465d}},8,"F-H2-706",424,2},
  {{{0xc0dfbc5dd09347d5}},5,"F-H2-707",466,9},
  {{{0x49df5f8c4c12190f}},5,"F-H2-708",825,3},
  {{{0x8523d3b95a194017}},5,"F-H2-709",751,2},
  {{{0x92f2dcfed4a9e998}},9,"F-H2-710",616,3},
  {{{0x92f2dcfed4a9e998}},9,"F-H2-711",654,2},
  {{{0x8b23149032980876}},7,"F-H2-712",418,8},
  {{{0x262538485a69fa26}},7,"F-H2-713",566,3},
  {{{0x262538485a69fa26}},7,"F-H2-714",911,2},
  {{{0x4f78dbc94f815e9b}},7,"F-H2-715",678,3},
  {{{0xe7020e30cc85b742}},7,"F-H2-716",677,2},
  {{{0xc31deab12b25d5e5}},7,"F-H2-717",825,8},
  {{{0xc31deab12b25d5e5}},7,"F-H2-718",826,3},
  {{{0x454915656e35e725}},7,"F-H2-719",493,2},
  {{{0xf9419bf28502c0d0}},7,"F-H2-720",653,2},
  {{{0x27cd6244c959cbac}},6,"F-H2-721",462,4},
  {{{0xdefda7e791d680bd}},6,"F-H2-722",454,4},
  {{{0x9efa4c0561da44db}},6,"F-H2-723",429,2},
  {{{0x9d5347ec98ad26e6}},5,"F-H2-724",423,6},
  {{{0x9d5347ec98ad26e6}},5,"F-H2-725",462,4},
  {{{0x9d5347ec98ad26e6}},5,"F-H2-726",529,2},
  {{{0x9d5347ec98ad26e6}},5,"F-H2-727",530,2},
  {{{0x3751f78148a12417}},6,"F-H2-728",913,5},
  {{{0x3751f78148a12417}},6,"F-H2-729",987,4},
  {{{0xbf3cf524a2370526}},6,"F-H2-730",912,3},
  {{{0x152e689ef0741483}},6,"F-H2-731",530,9},
  {{{0xd45d4205818e1013}},6,"F-H2-732",531,6},
  {{{0x8b2cd901091eed02}},6,"F-H2-733",825,6},
  {{{0xcaeb25f0a80378d2}},6,"F-H2-734",827,5},
  {{{0x9559001a3db25988}},6,"F-H2-735",432,3},
  {{{0x39fb84f5435e9042}},7,"F-H2-736",421,7},
  {{{0xa48ac6fde5447f4}},7,"F-H2-737",906,2},
  {{{0x6c732f1ad176cbb9}},7,"F-H2-738",462,2},
  {{{0xd70809b995a78d8a}},6,"F-H2-739",690,7},
  {{{0xd70809b995a78d8a}},6,"F-H2-740",653,2},
  {{{0xd70809b995a78d8a}},6,"F-H2-741",939,2},
  {{{0xbc8b7c29b46f85bf}},6,"F-H2-742",974,2},
  {{{0x7d99ab7f0205ef84}},7,"F-H2-743",462,2},
  {{{0xa594af12af325294}},4,"F-H2-744",419,6},
  {{{0xa594af12af325294}},4,"F-H2-745",543,6},
  {{{0xa594af12af325294}},4,"F-H2-746",457,2},
  {{{0x16bb74f03f0c9b87}},6,"F-H2-747",948,10},
  {{{0x24ccb2c57dd1fd55}},6,"F-H2-748",947,2},
  {{{0x59779aab802cf57f}},6,"F-H2-749",690,5},
  {{{0x14ce95daed5cfb59}},6,"F-H2-750",543,2},
  {{{0x43a432dda281f4fb}},7,"F-H2-751",911,5},
  {{{0x21943fff06adaaa3}},7,"F-H2-752",678,3},
  {{{0x21943fff06adaaa3}},7,"F-H2-753",690,2},
  {{{0x43a432dda281f4fb}},7,"F-H2-754",678,2},
  {{{0x9473f4754a528559}},11,"F-H2-755",421,11},
  {{{0xc98c22b7cfa64370}},11,"F-H2-756",493,3},
  {{{0xc98c22b7cfa64370}},11,"F-H2-757",492,2},
  {{{0x1ce1b059a0dc2cc3}},10,"F-H2-758",456,15},
  {{{0xfd9ef5796f8c134a}},5,"F-H2-759",429,6},
  {{{0xfd9ef5796f8c134a}},5,"F-H2-760",466,4},
  {{{0xfd9ef5796f8c134a}},5,"F-H2-761",617,2},
  {{{0xd2d1d49e387fd67c}},6,"F-H2-762",424,5},
  {{{0x71ce394e9223611e}},6,"F-H2-763",678,3},
  {{{0x99c2b5f6f9dc3360}},4,"F-H2-764",455,7},
  {{{0x99c2b5f6f9dc3360}},4,"F-H2-765",939,4},
  {{{0x5d49ac34a5ce4365}},6,"F-H2-766",950,8},
  {{{0x7bc0e5583159bd9a}},6,"F-H2-767",531,6},
  {{{0x41e86d3bce8e2fdd}},6,"F-H2-768",838,6},
  {{{0x41e86d3bce8e2fdd}},6,"F-H2-769",872,2},
  {{{0x41e86d3bce8e2fdd}},6,"F-H2-770",949,2},
  {{{0x7bc293f1e1d217aa}},6,"F-H2-771",946,2},
  {{{0x6a16628f5d4ecac}},7,"F-H2-772",421,8},
  {{{0x6a16628f5d4ecac}},7,"F-H2-773",456,4},
  {{{0x6a16628f5d4ecac}},7,"F-H2-774",419,3},
  {{{0x24fa5fb1ac6a7e34}},10,"F-H2-775",906,10},
  {{{0x5a0999b37abf5a7d}},10,"F-H2-776",653,4},
  {{{0xfacdbdfc0a919909}},6,"F-H2-777",382,6},
  {{{0x3fd785f521ed218}},6,"F-H2-778",678,6},
  {{{0xfacdbdfc0a919909}},6,"F-H2-779",825,2},
  {{{0xfacdbdfc0a919909}},6,"F-H2-780",425,2},
  {{{0xf6dbfb12b905d9d1}},5,"F-H2-781",690,2},
  {{{0xf6dbfb12b905d9d1}},5,"F-H2-782",910,2},
  {{{0x3860c4e02a9aed96}},8,"F-H2-783",939,9},
  {{{0xd2f3f8bad73dce56}},8,"F-H2-784",421,3},
  {{{0x6322ec956d89e8ee}},7,"F-H2-785",543,5},
  {{{0x6e5d85967f5e1a0b}},7,"F-H2-786",653,3},
  {{{0x6322ec956d89e8ee}},7,"F-H2-787",542,3},
  {{{0x6997cbcf8d1e50ca}},8,"F-H2-788",825,5},
  {{{0x6997cbcf8d1e50ca}},8,"F-H2-789",677,4},
  {{{0x3eba847f2d3a1a5d}},8,"F-H2-790",421,3},
  {{{0x50637f6aab3302e2}},7,"F-H2-791",826,8},
  {{{0x50637f6aab3302e2}},7,"F-H2-792",902,6},
  {{{0xd7fbed39f5c10e68}},3,"F-H2-793",456,8},
  {{{0xd7fbed39f5c10e68}},3,"F-H2-794",419,2},
  {{{0xf21d6ce906715ab0}},6,"F-H2-795",874,10},
  {{{0xf21d6ce906715ab0}},6,"F-H2-796",912,2},
  {{{0xd444ad25cf70a192}},7,"F-H2-797",542,4},
  {{{0xb9381264c4c5c358}},7,"F-H2-798",653,2},
  {{{0xa4a098425df4c54f}},5,"F-H2-799",826,6},
  {{{0xfcb94553f2131456}},5,"F-H2-800",939,5},
  {{{0xa8d635fa0f309658}},7,"F-H2-801",466,8},
  {{{0xa8d635fa0f309658}},7,"F-H2-802",542,3},
  {{{0x5479f64f469fdd93}},8,"F-H2-803",974,11},
  {{{0x5479f64f469fdd93}},8,"F-H2-804",908,2},
  {{{0x461b884e8fb7efcf}},4,"F-H2-805",456,8},
  {{{0x9b1b57f64c7fbd6a}},4,"F-H2-806",419,3},
  {{{0x9b1b57f64c7fbd6a}},4,"F-H2-807",455,3},
  {{{0xeb9b61d5dc84dbaa}},5,"F-H2-808",419,6},
  {{{0xeb9b61d5dc84dbaa}},5,"F-H2-809",423,3},
  {{{0xeb9b61d5dc84dbaa}},5,"F-H2-810",875,2},
  {{{0x48f64238736908a5}},10,"F-H2-811",615,6},
  {{{0x9a98a6ade703d9a4}},12,"F-H2-812",654,4},
  {{{0x41aab5dd9452351}},6,"F-H2-813",421,4},
  {{{0xed53c77d2453d437}},6,"F-H2-814",495,3},
  {{{0xed53c77d2453d437}},6,"F-H2-815",530,2},
  {{{0xed53c77d2453d437}},6,"F-H2-816",418,2},
  {{{0x512f970666e0a887}},6,"F-H2-817",765,6},
  {{{0xbb816947d49f8541}},6,"F-H2-818",825,4},
  {{{0x512f970666e0a887}},6,"F-H2-819",910,2},
  {{{0xbd7ed1740a1e926d}},8,"F-H2-820",653,7},
  {{{0xbd7ed1740a1e926d}},8,"F-H2-821",691,3},
  {{{0xbd7ed1740a1e926d}},8,"F-H2-822",539,2},
  {{{0xd062df4745b5bd67}},5,"F-H2-823",460,4},
  {{{0xe457f32a532dbca8}},5,"F-H2-824",948,4},
  {{{0x9e8fc1f697c4a531}},5,"F-H2-825",566,2},
  {{{0x726f94460faebb19}},7,"F-H2-826",429,5},
  {{{0x726f94460faebb19}},7,"F-H2-827",617,4},
  {{{0x726f94460faebb19}},7,"F-H2-828",653,2},
  {{{0xaea76f5e919a155f}},11,"F-H2-829",652,2},
  {{{0xda8bac797c852cf}},9,"F-H2-830",826,4},
  {{{0x1825f707ad35b76d}},9,"F-H2-831",617,2},
  {{{0x61c7a4cdd467c484}},7,"F-H2-832",530,8},
  {{{0x6c3d424482c2a5e}},4,"F-H2-833",913,5},
  {{{0x6c3d424482c2a5e}},4,"F-H2-834",802,4},
  {{{0x9e7980c71bf6ec40}},4,"F-H2-835",494,4},
  {{{0x2f420f275c0f21f2}},6,"F-H2-836",495,8},
  {{{0x2f420f275c0f21f2}},6,"F-H2-837",418,5},
  {{{0x7fcfe586f50bafe5}},7,"F-H2-838",899,9},
  {{{0xaa929a55edf228af}},7,"F-H2-839",899,3},
  {{{0xaec71d6800c9343d}},5,"F-H2-840",839,12},
  {{{0xd2ed55a901795b22}},7,"F-H2-841",826,8},
  {{{0x92b9186682bc13f1}},8,"F-H2-842",419,9},
  {{{0x63cb78221206887f}},11,"F-H2-843",491,10},
  {{{0x6c8d11599bb0f359}},7,"F-H2-844",910,7},
  {{{0xa133fb3f32bf71ad}},7,"F-H2-845",801,3},
  {{{0x2bdf94edb8c4df40}},7,"F-H2-846",426,7},
  {{{0x2bdf94edb8c4df40}},7,"F-H2-847",429,2},
  {{{0x2bdf94edb8c4df40}},7,"F-H2-848",947,2},
  {{{0xbde2a8344d273fa8}},6,"F-H2-849",529,5},
  {{{0x7ad438004cc6ded7}},6,"F-H2-850",838,3},
  {{{0x79474b6c801b2e49}},6,"F-H2-851",836,2},
  {{{0xe6b2c24e12c0dddd}},13,"F-H2-852",492,10},
  {{{0x6c943d7bed094ff}},10,"F-H2-853",454,9},
  {{{0xeb531caf3d366a37}},5,"F-H2-854",913,5},
  {{{0xeb531caf3d366a37}},5,"F-H2-855",530,4},
  {{{0xeb531caf3d366a37}},5,"F-H2-856",567,2},
  {{{0xc7a7cd19745722d9}},6,"F-H2-857",946,4},
  {{{0xc7a7cd19745722d9}},6,"F-H2-858",460,2},
  {{{0xc7a7cd19745722d9}},6,"F-H2-859",420,2},
  {{{0xd1df929b1d24423f}},6,"F-H2-860",825,2},
  {{{0xd1df929b1d24423f}},6,"F-H2-861",874,2},
  {{{0xbf522d5a9d1b9fcb}},4,"F-H2-862",543,2},
  {{{0xbf522d5a9d1b9fcb}},4,"F-H2-863",421,2},
  {{{0x43c3e219475da68f}},5,"F-H2-864",460,8},
  {{{0x2301b1740d58db66}},5,"F-H2-865",946,2},
  {{{0x779708577cf075c2}},3,"F-H2-866",456,8},
  {{{0x7a818d18082bc825}},6,"F-H2-867",543,3},
  {{{0x7a818d18082bc825}},6,"F-H2-868",944,2},
  {{{0xf07f0ebb9a0092b3}},10,"F-H2-869",541,8},
  {{{0x8a1b98a2f4a3c234}},10,"F-H2-870",826,2},
  {{{0xf326842ec4c238b5}},9,"F-H2-871",457,10},
  {{{0xeab71a41b17b7b17}},6,"F-H2-872",946,6},
  {{{0x4c7401a5adb99c80}},6,"F-H2-873",839,5},
  {{{0x629f0d90d5893b48}},6,"F-H2-874",913,11},
  {{{0xf87abb9758af0f4f}},12,"F-H2-875",417,9},
  {{{0x99c46787b5b230e6}},6,"F-H2-876",945,4},
  {{{0x99c46787b5b230e6}},6,"F-H2-877",825,2},
  {{{0x99c46787b5b230e6}},6,"F-H2-878",677,2},
  {{{0x71980b2545d25b5e}},15,"F-H2-879",911,8},
  {{{0x3ee03cbd668fbe6c}},5,"F-H2-880",826,5},
  {{{0x3ee03cbd668fbe6c}},5,"F-H2-881",902,3},
  {{{0x2cbb8206a26c3076}},7,"F-H2-882",455,10},
  {{{0xbcacb121fd9254ca}},14,"F-H2-883",421,9},
  {{{0x10840ca0ed359361}},7,"F-H2-884",802,6},
  {{{0x10840ca0ed359361}},7,"F-H2-885",801,6},
  {{{0xfc3e41e5cabdf51b}},6,"F-H2-886",495,6},
  {{{0xa6c03ae0f291ef3f}},6,"F-H2-887",418,4},
  {{{0xfc3e41e5cabdf51b}},6,"F-H2-888",383,2},
  {{{0x3ba1d124e1ba3686}},6,"F-H2-889",567,4},
  {{{0x3ba1d124e1ba3686}},6,"F-H2-890",492,3},
  {{{0xccbaaf2492d1278d}},7,"F-H2-891",910,2},
  {{{0xccbaaf2492d1278d}},7,"F-H2-892",678,2},
  {{{0x75b7694e33e94882}},6,"F-H2-893",908,5},
  {{{0x75b7694e33e94882}},6,"F-H2-894",946,2},
  {{{0xc78cf5128409b2d8}},13,"F-H2-895",506,8},
  {{{0x7b83b9997c5d8852}},5,"F-H2-896",530,4},
  {{{0x7b83b9997c5d8852}},5,"F-H2-897",462,2},
  {{{0x6af1a027e29426d3}},9,"F-H2-898",467,8},
  {{{0x9b32df12c6c43674}},10,"F-H2-899",470,8},
  {{{0xf6f1a80dbd3673f0}},7,"F-H2-900",875,5},
  {{{0x5a80f3a3953c483c}},7,"F-H2-901",906,3},
  {{{0x5a80f3a3953c483c}},7,"F-H2-902",949,2},
  {{{0xfd8745c3ac1347ea}},6,"F-H2-903",579,8},
  {{{0x20280d1a303bb245}},13,"F-H2-904",655,2},
  {{{0xc9e6e71d51ac5129}},6,"F-H2-905",939,2},
  {{{0xc9e6e71d51ac5129}},6,"F-H2-906",457,2},
  {{{0xc9e6e71d51ac5129}},6,"F-H2-907",429,2},
  {{{0xc9e6e71d51ac5129}},6,"F-H2-908",421,2},
  {{{0x6b0e6ee692e97d39}},7,"F-H2-909",873,5},
  {{{0x814ab419d26db35d}},7,"F-H2-910",950,4},
  {{{0x5d53a5cd4d6207a2}},7,"F-H2-911",566,7},
  {{{0x5d53a5cd4d6207a2}},7,"F-H2-912",529,5},
  {{{0xe05b1166df09600e}},4,"F-H2-913",543,5},
  {{{0x3d5bcede1cc132ab}},4,"F-H2-914",947,5},
  {{{0x7a137456805da0cd}},7,"F-H2-915",469,8},
  {{{0xca43e718ca1f5292}},5,"F-H2-916",910,3},
  {{{0xb17850319433a1e2}},5,"F-H2-917",493,2},
  {{{0xca43e718ca1f5292}},5,"F-H2-918",457,2},
  {{{0xade4b92bc5314c4c}},8,"F-H2-919",690,3},
  {{{0xc7ff70300071da0e}},8,"F-H2-920",941,2},
  {{{0xe0e3b9fa34bb6d7e}},12,"F-H2-921",532,6},
  {{{0x693a56073a9c6206}},12,"F-H2-922",418,5},
  {{{0xd338669c420fd00f}},8,"F-H2-923",543,4},
  {{{0x49cf8905ca485820}},6,"F-H2-924",492,4},
  {{{0xdee22406d28d4f82}},6,"F-H2-925",825,3},
  {{{0xfd1273995b7b8a19}},6,"F-H2-926",839,2},
  {{{0x6dada9e34f761efa}},12,"F-H2-927",433,8},
  {{{0xdb23cc6774788d99}},7,"F-H2-928",541,3},
  {{{0xdb23cc6774788d99}},7,"F-H2-929",578,2},
  {{{0xe806b6322785bf4b}},7,"F-H2-930",542,9},
  {{{0xe806b6322785bf4b}},7,"F-H2-931",466,2},
  {{{0xe21fa8df2e7440d1}},7,"F-H2-932",873,4},
  {{{0xe21fa8df2e7440d1}},7,"F-H2-933",909,4},
  {{{0xc4d46a950794f40c}},7,"F-H2-934",876,2},
  {{{0xc6d794a4ffc1dde4}},11,"F-H2-935",507,8},
  {{{0x445e563961d8244c}},8,"F-H2-936",431,8},
  {{{0x3c12a34f069ce7c6}},9,"F-H2-937",542,7},
  {{{0x3c12a34f069ce7c6}},9,"F-H2-938",427,2},
  {{{0xfd18eabc8dbcbed8}},6,"F-H2-939",838,4},
  {{{0xf8a69cbcb6285d36}},6,"F-H2-940",948,2},
  {{{0x3a54bb79f859134e}},14,"F-H2-941",429,8},
  {{{0x26b7fa182cd33203}},6,"F-H2-942",908,4},
  {{{0x1e2f54f0a0a67f2d}},6,"F-H2-943",802,3},
  {{{0x50a5a7c31753d748}},6,"F-H2-944",939,2},
  {{{0x97126bb6ff13f88d}},9,"F-H2-945",431,8},
  {{{0x97126bb6ff13f88d}},9,"F-H2-946",506,3},
  {{{0xdd9eba1848292106}},15,"F-H2-947",875,5},
  {{{0xdd9eba1848292106}},15,"F-H2-948",876,4},
  {{{0x82bdd026e7340423}},5,"F-H2-949",604,4},
  {{{0x82bdd026e7340423}},5,"F-H2-950",566,3},
  {{{0x82bdd026e7340423}},5,"F-H2-951",492,2},
  {{{0x2e353c9996eea40}},10,"F-H2-952",655,9},
  {{{0x2245ddf99b9c802c}},5,"F-H2-953",420,3},
  {{{0x2245ddf99b9c802c}},5,"F-H2-954",530,3},
  {{{0x5bc7e00a75e59dd}},5,"F-H2-955",913,2},
  {{{0xfbe9d56a05fb8235}},15,"F-H2-956",947,3},
  {{{0xfbe9d56a05fb8235}},15,"F-H2-957",839,3},
  {{{0x72b9bbd6a307e915}},9,"F-H2-958",825,5},
  {{{0xa86166879b7ce38a}},9,"F-H2-959",428,3},
  {{{0x7b4b3df809829ef4}},9,"F-H2-960",901,9},
  {{{0xa33fe50b0d4098f5}},5,"F-H2-961",455,8},
  {{{0xa33fe50b0d4098f5}},5,"F-H2-962",875,2},
  {{{0xa4feb42cf57c3fba}},12,"F-H2-963",935,8},
  {{{0x50dd43adf4bdc734}},14,"F-H2-964",939,8},
  {{{0x7455c72cd6190512}},6,"F-H2-965",465,9},
  {{{0xba7e781ff539b2ff}},7,"F-H2-966",418,5},
  {{{0xf4587c5076d526d3}},7,"F-H2-967",422,2},
  {{{0xf4587c5076d526d3}},7,"F-H2-968",423,2},
  {{{0xef3ef0c5f11db70b}},13,"F-H2-969",862,9},
  {{{0xbdfb3c7d6b15cd3e}},11,"F-H2-970",861,9},
  {{{0xc7def1c4bce60410}},9,"F-H2-971",936,11},
  {{{0xad547be27f4aab45}},7,"F-H2-972",418,6},
  {{{0xad547be27f4aab45}},7,"F-H2-973",947,2},
  {{{0x5c46e1e2b1d3fcbd}},7,"F-H2-974",603,2},
  {{{0xb40757442dd4f7f2}},7,"F-H2-975",902,6},
  {{{0x2ab24640912c5de9}},7,"F-H2-976",503,4},
  {{{0xfd54a31539aa2eaa}},7,"F-H2-977",506,2},
  {{{0xfd54a31539aa2eaa}},7,"F-H2-978",578,2},
  {{{0xfc9d7d2c85589606}},6,"F-H2-979",531,4},
  {{{0x5daf97323ab351bc}},6,"F-H2-980",530,2},
  {{{0xfc9d7d2c85589606}},6,"F-H2-981",421,2},
  {{{0xfc9d7d2c85589606}},6,"F-H2-982",418,2},
  {{{0xed6ca56557f3b7ff}},8,"F-H2-983",465,10},
  {{{0x588f352afb43835f}},9,"F-H2-984",826,5},
  {{{0x588f352afb43835f}},9,"F-H2-985",788,2},
  {{{0x162ca7d8c4968e47}},7,"F-H2-986",837,10},
  {{{0x39369958d2a5ab06}},11,"F-H2-987",462,2},
  {{{0xe02ec9ac0d057273}},8,"F-H2-988",937,8},
  {{{0x6ff8dcbea1fc1e67}},10,"F-H2-989",898,8},
  {{{0x63e759298ab88f51}},9,"F-H2-990",503,7},
  {{{0xb6cf0e81387ebcb7}},8,"F-H2-991",418,4},
  {{{0xd0c46368f25fd8e6}},8,"F-H2-992",459,2},
  {{{0xd140448c3b3fc666}},7,"F-H2-993",530,8},
  {{{0x4972742c8d6fa3f3}},4,"F-H2-994",939,6},
  {{{0xf4ab646d9efb9dda}},8,"F-H2-995",424,8},
  {{{0x90948fb5829a94fb}},7,"F-H2-996",941,2},
  {{{0xef2d94608e73306f}},7,"F-H2-997",462,2},
  {{{0xa50a03b4b435624a}},7,"F-H2-998",429,2},
  {{{0xa50a03b4b435624a}},7,"F-H2-999",466,2},
  {{{0xdaa6f6aa396a2a38}},6,"F-H2-1000",825,4},
  {{{0xdaa6f6aa396a2a38}},6,"F-H2-1001",936,2},
  {{{0xdaa6f6aa396a2a38}},6,"F-H2-1002",865,2},
  {{{0x713813cc6a6c6532}},7,"F-H2-1003",947,5},
  {{{0x53cfac467f044d5e}},7,"F-H2-1004",456,2},
  {{{0x13a3a2b449eb3d9f}},7,"F-H2-1005",941,3},
  {{{0xbca36d443c72f2f5}},7,"F-H2-1006",947,2},
  {{{0xd811d13a4caa4968}},7,"F-H2-1007",947,2},
  {{{0x6eebaaa4bb279212}},9,"F-H2-1008",875,7},
  {{{0x8451480570348d5b}},6,"F-H2-1009",421,6},
  {{{0x8451480570348d5b}},6,"F-H2-1010",456,2},
  {{{0xc242ef6ba4cd36e5}},9,"F-H2-1011",912,8},
  {{{0xc242ef6ba4cd36e5}},9,"F-H2-1012",950,2},
  {{{0xc4a7908518e8afe1}},6,"F-H2-1013",944,5},
  {{{0x1e8f85c6b66c23d4}},14,"F-H2-1014",830,3},
  {{{0xd6504271bbdf4025}},10,"F-H2-1015",430,5},
  {{{0xd6504271bbdf4025}},10,"F-H2-1016",431,3},
  {{{0x51c6976dfadbd881}},7,"F-H2-1017",936,5},
  {{{0x2298ebfbfc4412ba}},6,"F-H2-1018",946,2},
  {{{0x2298ebfbfc4412ba}},6,"F-H2-1019",939,2},
  {{{0x470ee556d81525bf}},4,"F-H2-1020",419,3},
  {{{0x470ee556d81525bf}},4,"F-H2-1021",492,2},
  {{{0xf75415d461231727}},7,"F-H2-1022",491,7},
  {{{0xfd781a1cb2ffada8}},7,"F-H2-1023",875,2},
  {{{0xc90558bb1fbde7f9}},4,"F-H2-1024",457,4},
  {{{0xc90558bb1fbde7f9}},4,"F-H2-1025",419,2},
  {{{0xafbe74dd470de009}},8,"F-H2-1026",906,4},
  {{{0xafbe74dd470de009}},8,"F-H2-1027",728,4},
  {{{0x60eae1aa5e80f0b6}},4,"F-H2-1028",939,4},
  {{{0x60eae1aa5e80f0b6}},4,"F-H2-1029",529,3},
  {{{0x2f0643442d7e884}},7,"F-H2-1030",941,4},
  {{{0xe5af6af635ed7f63}},7,"F-H2-1031",428,2},
  {{{0x8f280597ad214e40}},16,"F-H2-1032",829,2},
  {{{0x5eb7b9bfa1c4189b}},7,"F-H2-1033",874,8},
  {{{0x9f7a0998a010493d}},7,"F-H2-1034",456,2},
  {{{0x555db5d270e57803}},6,"F-H2-1035",654,3},
  {{{0xfeb913fb6e92f077}},6,"F-H2-1036",825,2},
  {{{0xaba4dbca4d271d1b}},6,"F-H2-1037",494,4},
  {{{0x351dbfc3f3487367}},7,"F-H2-1038",432,6},
  {{{0xc58e46efa4a82f94}},6,"F-H2-1039",429,3},
  {{{0xc58e46efa4a82f94}},6,"F-H2-1040",466,3},
  {{{0x851097d842ea9aa5}},8,"F-H2-1041",873,9},
  {{{0x452dce0156b56a4e}},8,"F-H2-1042",801,2},
  {{{0x44b9de19b0c88a1d}},8,"F-H2-1043",942,2},
  {{{0xc88828dbf26e2427}},8,"F-H2-1044",911,2},
  {{{0xc88828dbf26e2427}},8,"F-H2-1045",727,2},
  {{{0xd27f5c86281718fc}},8,"F-H2-1046",911,2},
  {{{0xc88828dbf26e2427}},8,"F-H2-1047",690,2},
  {{{0xdd918b5987552c06}},4,"F-H2-1048",939,4},
  {{{0xa22a3b68968cad82}},4,"F-H2-1049",939,3},
  {{{0xdd918b5987552c06}},4,"F-H2-1050",455,2},
  {{{0x865e2e0147224a65}},5,"F-H2-1051",914,6},
  {{{0xfcaf212e284be03}},16,"F-H2-1052",382,5},
  {{{0xfcaf212e284be03}},16,"F-H2-1053",417,4},
  {{{0xaff81fa84c98978f}},5,"F-H2-1054",492,4},
  {{{0x57fb61bbbccab7bd}},5,"F-H2-1055",947,3},
  {{{0x7e38754f65fe28a2}},5,"F-H2-1056",912,2},
  {{{0x9253f0eb28ccae2a}},5,"F-H2-1057",825,4},
  {{{0xe9b22410ea96f57a}},5,"F-H2-1058",715,3},
  {{{0x8aa196484511b429}},5,"F-H2-1059",466,3},
  {{{0xc984ef6031eee8e6}},4,"F-H2-1060",455,4},
  {{{0x33b8c360e0cedb6b}},7,"F-H2-1061",458,6},
  {{{0x36df023e451368e9}},8,"F-H2-1062",987,4},
  {{{0xc7da113e5e7f1564}},8,"F-H2-1063",425,2},
  {{{0x8aae1eee367ffa82}},6,"F-H2-1064",567,7},
  {{{0xef43095f3f21354c}},6,"F-H2-1065",457,2},
  {{{0x66f59697e5456bfb}},6,"F-H2-1066",429,2},
  {{{0xae473edfa56dfa47}},6,"F-H2-1067",690,2},
  {{{0xff87b7ed55e7c819}},6,"F-H2-1068",728,3},
  {{{0x428a878ea158af22}},6,"F-H2-1069",825,2},
  {{{0x428a878ea158af22}},6,"F-H2-1070",908,2},
  {{{0x194f9ca74286c07f}},11,"F-H2-1071",677,4},
  {{{0xe682845db6fa2bb3}},11,"F-H2-1072",875,2},
  {{{0xf3b868693a7a1311}},6,"F-H2-1073",421,4},
  {{{0x3ae5b78aff0c6188}},6,"F-H2-1074",543,3},
  {{{0x3ae5b78aff0c6188}},6,"F-H2-1075",462,2},
  {{{0x3ae5b78aff0c6188}},6,"F-H2-1076",382,2},
  {{{0x83aae6a74a453b55}},10,"F-H2-1077",802,5},
  {{{0x83aae6a74a453b55}},10,"F-H2-1078",910,2},
  {{{0x14cb2f53afbcb013}},8,"F-H2-1079",432,5},
  {{{0xd4a52f00400e6c81}},6,"F-H2-1080",939,4},
  {{{0xd4a52f00400e6c81}},6,"F-H2-1081",421,2},
  {{{0xa4bfc3a3f2ebaa16}},4,"F-H2-1082",939,5},
  {{{0x3dd31215720f612c}},7,"F-H2-1083",530,3},
  {{{0x15cfac12ad1c7858}},7,"F-H2-1084",455,2},
  {{{0xbb746f80c95c08de}},6,"F-H2-1085",429,3},
  {{{0xbb746f80c95c08de}},6,"F-H2-1086",541,3},
  {{{0x9454626614498bf1}},7,"F-H2-1087",566,4},
  {{{0x9454626614498bf1}},7,"F-H2-1088",496,3},
  {{{0x76db3e6a27d8314f}},9,"F-H2-1089",689,5},
  {{{0xba4dd782ce14b28f}},9,"F-H2-1090",678,2},
  {{{0x76db3e6a27d8314f}},9,"F-H2-1091",911,2},
  {{{0x17187ea0b3cb98f5}},9,"F-H2-1092",950,5},
  {{{0xed05d2d8a944a4c9}},16,"F-H2-1093",946,6},
  {{{0x7c5fcd4cea3e4be4}},16,"F-H2-1094",764,2},
  {{{0xbcecd28a7ebf6933}},9,"F-H2-1095",950,6},
  {{{0xd237fd7764b15e8e}},6,"F-H2-1096",418,2},
  {{{0xd237fd7764b15e8e}},6,"F-H2-1097",529,2},
  {{{0xeab6abde5c27d3c2}},6,"F-H2-1098",802,2},
  {{{0xf475d05f3d144622}},9,"F-H2-1099",429,6},
  {{{0xa03bafa5f0177c0b}},6,"F-H2-1100",728,4},
  {{{0x56d85bac49d636ed}},7,"F-H2-1101",455,6},
  {{{0x56d85bac49d636ed}},7,"F-H2-1102",419,2},
  {{{0xd47bcee07cd1e079}},9,"F-H2-1103",423,5},
  {{{0xd47bcee07cd1e079}},9,"F-H2-1104",425,3},
  {{{0x8470737513b521e8}},7,"F-H2-1105",678,3},
  {{{0x572982130a124e8e}},7,"F-H2-1106",678,2},
  {{{0xa8628141105b6dff}},18,"F-H2-1107",978,2},
  {{{0xaa3cae83a1d28e69}},7,"F-H2-1108",531,4},
  {{{0x622494451ed703e0}},7,"F-H2-1109",496,2},
  {{{0x87300fb7055953c4}},6,"F-H2-1110",764,4},
  {{{0x87300fb7055953c4}},6,"F-H2-1111",543,2},
  {{{0xf2e31a791af23c54}},6,"F-H2-1112",458,3},
  {{{0xf2e31a791af23c54}},6,"F-H2-1113",531,2},
  {{{0xf7b466c9d8476aa9}},6,"F-H2-1114",541,3},
  {{{0xf7b466c9d8476aa9}},6,"F-H2-1115",615,3},
  {{{0x579de8b97dc0e06f}},8,"F-H2-1116",492,7},
  {{{0xc146e23cc86be283}},9,"F-H2-1117",939,3},
  {{{0xc146e23cc86be283}},9,"F-H2-1118",530,2},
  {{{0xe581edcaebc5b154}},5,"F-H2-1119",838,4},
  {{{0xf6405330c7339130}},6,"F-H2-1120",987,7},
  {{{0x5cf357e5bda21488}},9,"F-H2-1121",421,6},
  {{{0xf26c61fe5ebe7604}},4,"F-H2-1122",543,3},
  {{{0xf1eba7274408a981}},6,"F-H2-1123",951,6},
  {{{0x4eb6793ec492f070}},6,"F-H2-1124",541,3},
  {{{0xe491bbb8ff1930c7}},6,"F-H2-1125",936,2},
  {{{0xbcf5200321eb6dfb}},5,"F-H2-1126",910,5},
  {{{0xcae02b0bd3df888a}},8,"F-H2-1127",939,3},
  {{{0xcae02b0bd3df888a}},8,"F-H2-1128",677,3},
  {{{0x29ba428ee55fd88e}},9,"F-H2-1129",873,8},
  {{{0xbfd2c0ef295aa394}},5,"F-H2-1130",420,3},
  {{{0x822592f514491f44}},10,"F-H2-1131",432,3},
  {{{0xd7b0821ee6c10fc5}},10,"F-H2-1132",938,3},
  {{{0x822592f514491f44}},10,"F-H2-1133",469,2},
  {{{0x8166a3db54f83c3d}},7,"F-H2-1134",913,3},
  {{{0x8166a3db54f83c3d}},7,"F-H2-1135",678,2},
  {{{0x250b5e012fc8b22f}},8,"F-H2-1136",429,4},
  {{{0xb661c24e2ae728ba}},8,"F-H2-1137",529,2},
  {{{0x3ae641ddd3ba5a59}},7,"F-H2-1138",417,5},
  {{{0x3ae641ddd3ba5a59}},7,"F-H2-1139",419,2},
  {{{0x9a51698b20d2d9cf}},11,"F-H2-1140",466,8},
  {{{0x5eb72954aecb0206}},5,"F-H2-1141",530,2},
  {{{0x5eb72954aecb0206}},5,"F-H2-1142",421,2},
  {{{0x2b3fb1599c187813}},6,"F-H2-1143",678,3},
  {{{0x676153073960e21d}},9,"F-H2-1144",458,7},
  {{{0x4289f36a4229334}},7,"F-H2-1145",542,5},
  {{{0x85032f0e6e7ff55a}},7,"F-H2-1146",691,2},
  {{{0xe3fbf1802f50c1d4}},4,"F-H2-1147",941,2},
  {{{0x8165e3bfd1ada4df}},7,"F-H2-1148",913,8},
  {{{0xe1890bb3cdacdc18}},9,"F-H2-1149",418,4},
  {{{0xc105583b8a23c0c7}},9,"F-H2-1150",827,8},
  {{{0xe5917d2abc8083ea}},8,"F-H2-1151",459,2},
  {{{0xe5917d2abc8083ea}},8,"F-H2-1152",458,2},
  {{{0x48671934dacd6983}},4,"F-H2-1153",456,7},
  {{{0x23339fb97e81c9cc}},8,"F-H2-1154",946,3},
  {{{0x64406e27f0b392cf}},8,"F-H2-1155",877,2},
  {{{0x84888e574763c17}},4,"F-H2-1156",949,3},
  {{{0x585a3d82ba929030}},8,"F-H2-1157",837,6},
  {{{0x8c347531dac92892}},10,"F-H2-1158",912,3},
  {{{0x8c347531dac92892}},10,"F-H2-1159",950,2},
  {{{0x5a955514de2f0cd5}},10,"F-H2-1160",469,5},
  {{{0x85dc20952afc7aa3}},6,"F-H2-1161",424,3},
  {{{0x7fb2a834c759e752}},6,"F-H2-1162",640,3},
  {{{0x1ad9a5caecd0295}},6,"F-H2-1163",462,2},
  {{{0xd621e4b9cdc66ef6}},8,"F-H2-1164",419,8},
  {{{0xc00276aa0ebd923d}},6,"F-H2-1165",421,5},
  {{{0x9d52ab62d5ff8399}},6,"F-H2-1166",456,3},
  {{{0x48c475e4a74322bd}},8,"F-H2-1167",654,4},
  {{{0x242828e20463c930}},9,"F-H2-1168",431,7},
  {{{0xd0cbe833c23e2447}},12,"F-H2-1169",653,7},
  {{{0x3d1d4a0fa29b0502}},10,"F-H2-1170",936,5},
  {{{0xf4832992f5f20041}},10,"F-H2-1171",431,3},
  {{{0xe3479fcfc7b14a4b}},8,"F-H2-1172",789,8},
  {{{0xc04142fddf1c921a}},9,"F-H2-1173",541,8},
  {{{0x222a1b8f4c87d8d8}},7,"F-H2-1174",542,7},
  {{{0xed22e3f687757ec9}},8,"F-H2-1175",949,3},
  {{{0xdcf13c0c8dc1683c}},8,"F-H2-1176",457,3},
  {{{0x46254ed8ab008d61}},6,"F-H2-1177",541,2},
  {{{0x46254ed8ab008d61}},6,"F-H2-1178",429,2},
  {{{0xa594ac51f111c174}},8,"F-H2-1179",543,3},
  {{{0xc8a3730c4b229b35}},6,"F-H2-1180",942,2},
  {{{0xbf29cfe6fa933489}},6,"F-H2-1181",543,2},
  {{{0x78c04626e319a135}},5,"F-H2-1182",875,4},
  {{{0x253ebd4f17a18f8f}},7,"F-H2-1183",419,7},
  {{{0x6272c90fb8e319f1}},5,"F-H2-1184",950,8},
  {{{0xebd802d4b1cfe4fb}},7,"F-H2-1185",912,4},
  {{{0xebd802d4b1cfe4fb}},7,"F-H2-1186",839,4},
  {{{0x66edb354f45177be}},6,"F-H2-1187",939,5},
  {{{0x66edb354f45177be}},6,"F-H2-1188",529,3},
  {{{0x685c7bc05fb38c06}},10,"F-H2-1189",947,7},
  {{{0x6fbe5cefdc6f648d}},7,"F-H2-1190",419,8},
  {{{0x38b97f14f00751f2}},7,"F-H2-1191",422,7},
  {{{0xdd6b446214f8d798}},8,"F-H2-1192",942,6},
  {{{0x28f2dea3f40b8330}},16,"F-H2-1193",764,3},
  {{{0x28f2dea3f40b8330}},16,"F-H2-1194",876,2},
  {{{0x2aab92d02a749084}},6,"F-H2-1195",950,4},
  {{{0x2aab92d02a749084}},6,"F-H2-1196",456,3},
  {{{0xe9bb2d63d2548d8c}},7,"F-H2-1197",871,3},
  {{{0x19a0a17f10345c07}},8,"F-H2-1198",543,3},
  {{{0x61e027c196415a42}},8,"F-H2-1199",947,2},
  {{{0x85de16743176e2e0}},11,"F-H2-1200",505,4},
  {{{0x85de16743176e2e0}},11,"F-H2-1201",506,3},
  {{{0x9ada404a3fe2d6ec}},6,"F-H2-1202",456,3},
  {{{0x9ada404a3fe2d6ec}},6,"F-H2-1203",491,2},
  {{{0x36e45520ca06d35d}},11,"F-H2-1204",506,7},
  {{{0x5ed7383d0cce1072}},10,"F-H2-1205",462,3},
  {{{0xb213ab7bf0dc84f1}},6,"F-H2-1206",492,6},
  {{{0xe9c66617c725aac4}},11,"F-H2-1207",950,4},
  {{{0xe9c66617c725aac4}},11,"F-H2-1208",873,2},
  {{{0xf8cc9e71b4d4b0b8}},7,"F-H2-1209",949,7},
  {{{0x5d1679871399ad29}},12,"F-H2-1210",421,2},
  {{{0x13222f691a95414}},12,"F-H2-1211",421,2},
  {{{0x3cbe0403314b7fa9}},5,"F-H2-1212",943,3},
  {{{0x3cbe0403314b7fa9}},5,"F-H2-1213",678,2},
  {{{0x3e47705fc04566d1}},6,"F-H2-1214",543,4},
  {{{0x3e47705fc04566d1}},6,"F-H2-1215",493,2},
  {{{0xd01d446f936f578}},5,"F-H2-1216",429,3},
  {{{0xd01d446f936f578}},5,"F-H2-1217",466,2},
  {{{0x73112485541d58c5}},6,"F-H2-1218",640,3},
  {{{0x73112485541d58c5}},6,"F-H2-1219",825,2},
  {{{0x6de2cc1a182f0aa2}},8,"F-H2-1220",543,5},
  {{{0xd3aba4fdad37036d}},7,"F-H2-1221",826,4},
  {{{0x916da3e65be54faa}},7,"F-H2-1222",826,2},
  {{{0x6475568f457d8a6c}},9,"F-H2-1223",906,4},
  {{{0x2bb7350e4888cf51}},9,"F-H2-1224",425,3},
  {{{0x6ef63975f5256a35}},9,"F-H2-1225",422,2},
  {{{0x5b4565370b134d35}},9,"F-H2-1226",603,2},
  {{{0xaafc3c8db99e36d7}},7,"F-H2-1227",462,2},
  {{{0xb6f90cfa2ec919b5}},7,"F-H2-1228",943,2},
  {{{0xb6f90cfa2ec919b5}},7,"F-H2-1229",909,2},
  {{{0x6f6c8ff6e2916775}},6,"F-H2-1230",678,2},
  {{{0x902b8e95223c11d}},9,"F-H2-1231",690,2},
  {{{0x87a7dae25c8f20fb}},9,"F-H2-1232",678,2},
  {{{0x4483e5178d35b8f7}},5,"F-H2-1233",941,2},
  {{{0xf31639e9bfa55a7f}},11,"F-H2-1234",532,5},
  {{{0x10a2ec596462a6b3}},11,"F-H2-1235",950,2},
  {{{0xacd6f93a08c3171a}},5,"F-H2-1236",653,2},
  {{{0xb485b38c997b4aab}},9,"F-H2-1237",616,4},
  {{{0xb485b38c997b4aab}},9,"F-H2-1238",654,2},
  {{{0x9fc93a9a187ae69a}},8,"F-H2-1239",605,4},
  {{{0x4229c06fcdb666bf}},9,"F-H2-1240",728,3},
  {{{0xbd164faa696a4efe}},9,"F-H2-1241",945,3},
  {{{0x520662f2b1bd71c4}},10,"F-H2-1242",469,4},
  {{{0x41c556a4140ec718}},8,"F-H2-1243",419,5},
  {{{0xd0191aaf798d490a}},14,"F-H2-1244",544,5},
  {{{0xc3197ef7bee61c40}},11,"F-H2-1245",420,6},
  {{{0x1abdc48fd029b60c}},6,"F-H2-1246",839,2},
  {{{0xee37bbccfff38d6a}},7,"F-H2-1247",496,3},
  {{{0xee37bbccfff38d6a}},7,"F-H2-1248",530,3},
  {{{0x198e6fd0d7aef8cf}},5,"F-H2-1249",492,5},
  {{{0x198e6fd0d7aef8cf}},5,"F-H2-1250",603,2},
  {{{0xe2223b08f1137ceb}},8,"F-H2-1251",985,7},
  {{{0x5ff1f3c937ad079d}},5,"F-H2-1252",460,5},
  {{{0x2a973c24168c3e68}},8,"F-H2-1253",877,6},
  {{{0x5b2124a8259ffe4f}},6,"F-H2-1254",429,2},
  {{{0x2dc55d39f820249e}},6,"F-H2-1255",942,2},
  {{{0x882cc46cf8f2666c}},10,"F-H2-1256",470,2},
  {{{0xaafb591fac17bb18}},10,"F-H2-1257",906,2},
  {{{0x6eb15152ca206c}},6,"F-H2-1258",944,4},
  {{{0xdcad45e46d055030}},6,"F-H2-1259",462,2},
  {{{0xfbf879dc2c8e0e2a}},8,"F-H2-1260",462,2},
  {{{0xedcd9f7ba0c10e33}},5,"F-H2-1261",914,3},
  {{{0x49d9f96b624b2ec0}},5,"F-H2-1262",906,2},
  {{{0x6189b35002ae8952}},10,"F-H2-1263",421,7},
  {{{0x5db2c1233d34cb7e}},9,"F-H2-1264",603,3},
  {{{0x5db2c1233d34cb7e}},9,"F-H2-1265",641,2},
  {{{0x9a33f2d2e5f5303c}},7,"F-H2-1266",869,3},
  {{{0x9a33f2d2e5f5303c}},7,"F-H2-1267",678,2},
  {{{0xe519d0324baa4fa6}},7,"F-H2-1268",494,5},
  {{{0x70bd5a66ac5f516e}},10,"F-H2-1269",984,3},
  {{{0x70bd5a66ac5f516e}},10,"F-H2-1270",640,2},
  {{{0xdefee2d98010cd4}},8,"F-H2-1271",579,5},
  {{{0xecafde6debf70035}},8,"F-H2-1272",936,2},
  {{{0xb2230d14599b28c2}},7,"F-H2-1273",566,3},
  {{{0xa3f40334ec4bc3d3}},7,"F-H2-1274",568,2},
  {{{0x8cd97201d86443d9}},5,"F-H2-1275",839,3},
  {{{0xacd7b0f8c3041d30}},8,"F-H2-1276",462,3},
  {{{0xf10e8a9e81d4f4fb}},13,"F-H2-1277",505,7},
  {{{0x6cd664f92e2869ac}},13,"F-H2-1278",654,3},
  {{{0x6cd664f92e2869ac}},13,"F-H2-1279",616,3},
  {{{0x89455d842f783e2e}},9,"F-H2-1280",457,5},
  {{{0x64322c0ee1700017}},10,"F-H2-1281",906,4},
  {{{0xf8d5208b3287d0d5}},8,"F-H2-1282",906,2},
  {{{0x2dc7a7f0dec11f15}},8,"F-H2-1283",839,6},
  {{{0xee792ddfeb947548}},8,"F-H2-1284",867,2},
  {{{0xa358124302811371}},8,"F-H2-1285",505,2},
  {{{0x136ad0b1be9ad054}},7,"F-H2-1286",432,4},
  {{{0xb8f474ee26e03f0f}},9,"F-H2-1287",425,4},
  {{{0xb8f474ee26e03f0f}},9,"F-H2-1288",947,2},
  {{{0x56c076556740cdc2}},8,"F-H2-1289",493,3},
  {{{0xd614b04c448d7cc}},6,"F-H2-1290",541,4},
  {{{0x21c70cc88d0202ae}},5,"F-H2-1291",466,3},
  {{{0xe554c86b7cc05a95}},5,"F-H2-1292",941,2},
  {{{0xac93c2a46e3c137c}},7,"F-H2-1293",566,4},
  {{{0x1ae9477348299a47}},8,"F-H2-1294",946,4},
  {{{0x5b9680e3036b2ed8}},8,"F-H2-1295",948,3},
  {{{0x977969a050e3137c}},9,"F-H2-1296",728,6},
  {{{0x56c17c284b2a5fdc}},7,"F-H2-1297",913,7},
  {{{0xb363f71c8bb619e7}},7,"F-H2-1298",543,2},
  {{{0xfb86774444dacb4a}},13,"F-H2-1299",530,5},
  {{{0xfad7f517cb811b96}},8,"F-H2-1300",424,5},
  {{{0x41fad016b8941a58}},12,"F-H2-1301",507,5},
  {{{0x7beea0d79518981}},5,"F-H2-1302",462,2},
  {{{0xf0fc9fdb1e96f15b}},10,"F-H2-1303",690,3},
  {{{0x594e17937289fdb0}},9,"F-H2-1304",528,4},
  {{{0xb9858c1120f49f8a}},9,"F-H2-1305",839,3},
  {{{0x4ecb9aa86626d0bd}},9,"F-H2-1306",426,6},
  {{{0xfd462c01e3234ef4}},12,"F-H2-1307",458,7},
  {{{0x27f5ebc9697fa620}},6,"F-H2-1308",495,2},
  {{{0x5c747b4476344911}},7,"F-H2-1309",530,4},
  {{{0x7ff2ef8b9f3329e0}},6,"F-H2-1310",567,4},
  {{{0x91d53b7cc0dc3406}},8,"F-H2-1311",939,2},
  {{{0x81b0ea3bba2db4a5}},6,"F-H2-1312",418,6},
  {{{0x3c51dd30b7b9c1ea}},13,"F-H2-1313",840,4},
  {{{0x1190c264ff6abcb7}},9,"F-H2-1314",839,2},
  {{{0x11451a7179f85319}},6,"F-H2-1315",950,5},
  {{{0x44b693906a54d625}},7,"F-H2-1316",566,3},
  {{{0x44b693906a54d625}},7,"F-H2-1317",529,2},
  {{{0x9cd11be4f97adb46}},13,"F-H2-1318",492,5},
  {{{0x76c1949160314790}},6,"F-H2-1319",987,4},
  {{{0xd1fde519547c4fb7}},9,"F-H2-1320",422,5},
  {{{0x68f7bdccdac9c7f2}},13,"F-H2-1321",492,4},
  {{{0x19a8a188f9bc8ee4}},11,"F-H2-1322",491,5},
  {{{0x99e1d166e2eb91d0}},5,"F-H2-1323",825,4},
  {{{0x99e1d166e2eb91d0}},5,"F-H2-1324",826,2},
  {{{0x98d4be80cd48acfd}},10,"F-H2-1325",913,6},
  {{{0xbb253b9623d1e418}},9,"F-H2-1326",678,2},
  {{{0xa645fe51724b3321}},7,"F-H2-1327",495,4},
  {{{0xe7bf87512c72479b}},7,"F-H2-1328",838,4},
  {{{0xb5756ffcd82db2fc}},7,"F-H2-1329",567,2},
  {{{0x6007d289100b5509}},6,"F-H2-1330",985,4},
  {{{0x14bc1912d5680080}},7,"F-H2-1331",458,2},
  {{{0xb350b9869062ad98}},7,"F-H2-1332",423,2},
  {{{0x33e3b6653a25d4e1}},8,"F-H2-1333",946,2},
  {{{0xbc6b47292a5c41ad}},12,"F-H2-1334",875,5},
  {{{0xfbd96f11a2634965}},10,"F-H2-1335",418,2},
  {{{0x984262a5634580fa}},7,"F-H2-1336",906,2},
  {{{0xccebf831174b76e3}},7,"F-H2-1337",462,2},
  {{{0x41ac1094c513d76a}},15,"F-H2-1338",914,3},
  {{{0x41ac1094c513d76a}},15,"F-H2-1339",987,2},
  {{{0xa3982851904bca00}},8,"F-H2-1340",728,2},
  {{{0x7a3ffeb5186c5831}},8,"F-H2-1341",678,2},
  {{{0x7d067bd0e38e265f}},9,"F-H2-1342",838,2},
  {{{0x6fd0ffe36b208023}},14,"F-H2-1343",421,5},
  {{{0x241f1751a8d0ac99}},9,"F-H2-1344",906,3},
  {{{0x9711701a7d3140a7}},9,"F-H2-1345",914,3},
  {{{0xe128d6c7e479c0dd}},7,"F-H2-1346",839,4},
  {{{0xc01da1b51e83b464}},7,"F-H2-1347",418,2},
  {{{0xc01da1b51e83b464}},7,"F-H2-1348",603,2},
  {{{0xf8ed2b4d39014797}},6,"F-H2-1349",543,2},
  {{{0xf8ed2b4d39014797}},6,"F-H2-1350",579,2},
  {{{0x56f6f9d79262f447}},8,"F-H2-1351",419,6},
  {{{0xce5ceee0b4f03cba}},5,"F-H2-1352",875,3},
  {{{0x44ffff7a31f824e2}},5,"F-H2-1353",876,2},
  {{{0x4d63dd638f1f1c15}},6,"F-H2-1354",531,5},
  {{{0x2ba0347242150d9}},5,"F-H2-1355",422,2},
  {{{0x2ba0347242150d9}},5,"F-H2-1356",419,2},
  {{{0x185e27b54592a419}},7,"F-H2-1357",751,4},
  {{{0x63932d07e45eb0d0}},7,"F-H2-1358",457,2},
  {{{0xc9fd5123a45d190b}},6,"F-H2-1359",543,3},
  {{{0x657394b6d7f1e359}},10,"F-H2-1360",949,5},
  {{{0xb3b73b368c60b4b4}},6,"F-H2-1361",728,2},
  {{{0xb3b73b368c60b4b4}},6,"F-H2-1362",764,2},
  {{{0x2ba54ec71161de1a}},7,"F-H2-1363",936,4},
  {{{0x6e9ee6f6db95eb41}},6,"F-H2-1364",529,3},
  {{{0x6e9ee6f6db95eb41}},6,"F-H2-1365",418,2},
  {{{0x12d8cf689dbbf32e}},8,"F-H2-1366",463,3},
  {{{0x12d8cf689dbbf32e}},8,"F-H2-1367",429,2},
  {{{0xab8a9e55b466a01e}},8,"F-H2-1368",459,3},
  {{{0xbc7c013903169448}},7,"F-H2-1369",869,3},
  {{{0xb3f1c94fe34eabd8}},5,"F-H2-1370",826,3},
  {{{0x2b76bb34b4e4564b}},5,"F-H2-1371",429,2},
  {{{0x93d12e8baccd4dd8}},8,"F-H2-1372",417,6},
  {{{0xd2e589577815d20}},6,"F-H2-1373",495,3},
  {{{0x71e745934bbccb35}},7,"F-H2-1374",801,3},
  {{{0xb7ef626030042c7c}},7,"F-H2-1375",422,3},
  {{{0xbfd5f09b242e35d0}},9,"F-H2-1376",491,6},
  {{{0x4a566b9a00cbd90e}},9,"F-H2-1377",876,5},
  {{{0x61035ca55706289d}},9,"F-H2-1378",529,5},
  {{{0x5f91a1a4a4dfeef3}},10,"F-H2-1379",714,5},
  {{{0x571500da0fe81d77}},5,"F-H2-1380",950,2},
  {{{0x2eb8c0b45b404ec6}},5,"F-H2-1381",873,2},
  {{{0x3b84a8d0e5d1f0e7}},7,"F-H2-1382",947,3},
  {{{0xff0a2e16f0b9ab21}},7,"F-H2-1383",462,2},
  {{{0xb2d33f1c951a2dbc}},10,"F-H2-1384",423,5},
  {{{0xa2379ef360bd57db}},13,"F-H2-1385",568,5},
  {{{0x2b06f555ce1ddba6}},12,"F-H2-1386",417,5},
  {{{0x60e8de793b947040}},10,"F-H2-1387",459,5},
  {{{0xfa297447e2acb395}},6,"F-H2-1388",493,4},
  {{{0x590ce613c2b14040}},6,"F-H2-1389",873,2},
  {{{0x5d57fb3d183a342}},7,"F-H2-1390",678,3},
  {{{0x6c2c01844629cc8b}},7,"F-H2-1391",677,2},
  {{{0xd910d947daaa3da4}},11,"F-H2-1392",949,6},
  {{{0x9c036882c6fb17e7}},10,"F-H2-1393",690,4},
  {{{0xeed6f20cc76819a7}},10,"F-H2-1394",905,2},
  {{{0x8d5666146134f89f}},4,"F-H2-1395",457,3},
  {{{0xfc75fe103acebfc1}},7,"F-H2-1396",902,6},
  {{{0x68d7a721136d1550}},11,"F-H2-1397",788,3},
  {{{0x8fcc7b41ef5732e9}},6,"F-H2-1398",418,5},
  {{{0xffdc1c9058ed393b}},5,"F-H2-1399",913,2},
  {{{0x5048f05cd0cc5652}},5,"F-H2-1400",950,4},
  {{{0xbfbd28fae685dc5}},15,"F-H2-1401",947,5},
  {{{0x68374db75174e786}},5,"F-H2-1402",455,3},
  {{{0x6081f5119a1b4102}},6,"F-H2-1403",825,6},
  {{{0xf52d93f3223176cf}},8,"F-H2-1404",801,5},
  {{{0xe0bdee4069a8cdcf}},14,"F-H2-1405",906,2},
  {{{0xe0bdee4069a8cdcf}},14,"F-H2-1406",939,2},
  {{{0x4cc7e1a7b68abb89}},7,"F-H2-1407",461,4},
  {{{0xb714b04ba26241a7}},7,"F-H2-1408",714,3},
  {{{0xe3e0dcd8ee470e88}},9,"F-H2-1409",426,2},
  {{{0x6ec40a719869991b}},7,"F-H2-1410",825,3},
  {{{0x5af9b54bc3509e0a}},6,"F-H2-1411",470,2},
  {{{0x17dbde478e5a7b08}},6,"F-H2-1412",906,2},
  {{{0x741617fac1fc8b8b}},5,"F-H2-1413",458,2},
  {{{0x9ea9898cfd287fd5}},6,"F-H2-1414",728,3},
  {{{0x71a4d2ef6e69026d}},8,"F-H2-1415",678,4},
  {{{0xf318dcd471c736d5}},6,"F-H2-1416",801,2},
  {{{0x2da8e86b5cc9a141}},6,"F-H2-1417",874,2},
  {{{0x8e3ba5fa9d6f2048}},7,"F-H2-1418",418,5},
  {{{0x339b70283294a46a}},11,"F-H2-1419",462,2},
  {{{0xd50df477a3929af0}},5,"F-H2-1420",466,2},
  {{{0xb96055aca5f6bd15}},4,"F-H2-1421",429,3},
  {{{0xee27801c8a73e642}},4,"F-H2-1422",456,2},
  {{{0xde3164693b92c79f}},4,"F-H2-1423",457,2},
  {{{0xb747e85989e6d684}},9,"F-H2-1424",691,5},
  {{{0x94ea6d60688ebbcc}},17,"F-H2-1425",950,4},
  {{{0x94ea6d60688ebbcc}},17,"F-H2-1426",873,2},
  {{{0xc0039dba5342081c}},8,"F-H2-1427",867,3},
  {{{0xc0039dba5342081c}},8,"F-H2-1428",903,2},
  {{{0x905a252dff282a58}},9,"F-H2-1429",865,5},
  {{{0xdd6803dd82af619e}},7,"F-H2-1430",417,6},
  {{{0xbeb557527fabcfca}},7,"F-H2-1431",941,4},
  {{{0xf55417a2a67307b1}},19,"F-H2-1432",765,5},
  {{{0x87fd2cd3843615d1}},5,"F-H2-1433",429,3},
  {{{0x859e7334e1670495}},10,"F-H2-1434",429,2},
  {{{0x859e7334e1670495}},10,"F-H2-1435",910,2},
  {{{0x6a8776c3f5544eae}},6,"F-H2-1436",946,2},
  {{{0x6bab6cd826bc31}},5,"F-H2-1437",912,2},
  {{{0x6bab6cd826bc31}},5,"F-H2-1438",950,2},
  {{{0xb688219bfcf17078}},7,"F-H2-1439",677,2},
  {{{0xcf9be824f12844d2}},5,"F-H2-1440",905,2},
  {{{0x2ef0c3b5b1b669ca}},11,"F-H2-1441",913,5},
  {{{0xc0d8047f5545f904}},12,"F-H2-1442",911,6},
  {{{0xd5b50d1528624016}},10,"F-H2-1443",454,5},
  {{{0xb345fe6ae7d26471}},6,"F-H2-1444",690,2},
  {{{0x913fc9338e60cee6}},9,"F-H2-1445",950,3},
  {{{0x913fc9338e60cee6}},9,"F-H2-1446",910,2},
  {{{0xd6f01b0e858615e7}},7,"F-H2-1447",566,6},
  {{{0xcf4060f516ae6e3e}},9,"F-H2-1448",466,3},
  {{{0xe06bf80e302e6d13}},5,"F-H2-1449",826,5},
  {{{0xbed4d4df1e80f93e}},7,"F-H2-1450",763,4},
  {{{0xbcc42ec7da52ce69}},7,"F-H2-1451",950,2},
  {{{0xe6dad4a3df92e9f0}},7,"F-H2-1452",504,5},
  {{{0xb8195f7c36545d5}},8,"F-H2-1453",903,6},
  {{{0xb6cf45df2e5c0aea}},7,"F-H2-1454",905,5},
  {{{0x687a892183bff90a}},5,"F-H2-1455",837,6},
  {{{0x8b26056cadabe499}},13,"F-H2-1456",984,4},
  {{{0xb9ef360975a3db42}},11,"F-H2-1457",678,2},
  {{{0x936d4ca5b3ee5df0}},7,"F-H2-1458",458,2},
  {{{0xa5a6bece2e7efec2}},7,"F-H2-1459",950,2},
  {{{0xa5a6bece2e7efec2}},7,"F-H2-1460",908,2},
  {{{0xb0ff969b93408001}},7,"F-H2-1461",530,3},
  {{{0xe55d128faf4f2397}},7,"F-H2-1462",494,2},
  {{{0xfa35b6ac15d7ac3f}},6,"F-H2-1463",944,3},
  {{{0x966fdf264c557712}},8,"F-H2-1464",640,5},
  {{{0x12610b3531382125}},4,"F-H2-1465",455,2},
  {{{0xf70c1aef32f80f03}},4,"F-H2-1466",543,2},
  {{{0x31dcfc1208a16e1b}},7,"F-H2-1467",714,5},
  {{{0x6028fa86548ad233}},6,"F-H2-1468",418,3},
  {{{0x489cc5d6f6f53121}},9,"F-H2-1469",947,4},
  {{{0xd05c1bf961a7762d}},7,"F-H2-1470",419,3},
  {{{0x9b59f75ff55c37cb}},5,"F-H2-1471",802,2},
  {{{0x3bf7fdd529b11cb3}},7,"F-H2-1472",456,3},
  {{{0x3bf7fdd529b11cb3}},7,"F-H2-1473",419,2},
  {{{0xed74f54363ee413d}},6,"F-H2-1474",764,3},
  {{{0x1c912eaf9e68f96a}},7,"F-H2-1475",417,3},
  {{{0x1c912eaf9e68f96a}},7,"F-H2-1476",419,2},
  {{{0xb63415a553da3456}},11,"F-H2-1477",431,4},
  {{{0x96b2c3e51835650b}},10,"F-H2-1478",906,2},
  {{{0x73616143b999c786}},9,"F-H2-1479",839,4},
  {{{0xacbf63da74d74a4b}},17,"F-H2-1480",677,2},
  {{{0xacbf63da74d74a4b}},17,"F-H2-1481",678,2},
  {{{0x51be814f8429bd8d}},7,"F-H2-1482",542,3},
  {{{0x808e60098b047447}},6,"F-H2-1483",677,2},
  {{{0xd1ccd96117e279eb}},9,"F-H2-1484",425,2},
  {{{0xaad4014a93492fad}},11,"F-H2-1485",875,4},
  {{{0xe559d9b5f39b8689}},7,"F-H2-1486",530,5},
  {{{0x25c7a8762fed4b8b}},18,"F-H2-1487",727,5},
  {{{0x84f556303105826f}},9,"F-H2-1488",765,2},
  {{{0x6da05392cc78922b}},5,"F-H2-1489",764,3},
  {{{0xc96d68ecb034e6a9}},9,"F-H2-1490",910,4},
  {{{0xe170aa0824a0371}},8,"F-H2-1491",942,5},
  {{{0xead1282d6cad9838}},5,"F-H2-1492",876,5},
  {{{0xe2e52fbe64df2796}},8,"F-H2-1493",949,5},
  {{{0x7095c060240afe49}},7,"F-H2-1494",837,3},
  {{{0x358a07f0a4e4b686}},10,"F-H2-1495",496,5},
  {{{0x31f133b98873a9b6}},11,"F-H2-1496",677,2},
  {{{0xc4d3b22285589785}},7,"F-H2-1497",529,2},
  {{{0xc4d3b22285589785}},7,"F-H2-1498",455,2},
  {{{0x21f6c6dc3cdcfe2e}},10,"F-H2-1499",865,4},
  {{{0xbecd91e164cf844c}},8,"F-H2-1500",898,2},
  {{{0xb5ede692658cef7c}},8,"F-H2-1501",539,2},
  {{{0x5e1ec911ddd22639}},9,"F-H2-1502",541,2},
  {{{0x1685b9590e43ccda}},6,"F-H2-1503",825,2},
  {{{0xf3d4270017350d06}},9,"F-H2-1504",751,4},
  {{{0x777a8f51b137eb2e}},8,"F-H2-1505",910,2},
  {{{0xaaf09d42dbfb7dca}},8,"F-H2-1506",942,3},
  {{{0x6be78bb22988ed00}},6,"F-H2-1507",492,3},
  {{{0x56f1026cd1e507f}},9,"F-H2-1508",905,2},
  {{{0xb8ce4383fbd18960}},6,"F-H2-1509",418,2},
  {{{0xb8ce4383fbd18960}},6,"F-H2-1510",531,2},
  {{{0x492a220c9d7ed2dd}},8,"F-H2-1511",987,3},
  {{{0x1c47ff11b420a149}},8,"F-H2-1512",948,2},
  {{{0xc0175415c7c44cf9}},7,"F-H2-1513",457,2},
  {{{0x1f20be7ca9f23d8c}},8,"F-H2-1514",939,4},
  {{{0x29609064275a728a}},10,"F-H2-1515",429,2},
  {{{0xa63a277526e4908e}},10,"F-H2-1516",945,3},
  {{{0x554920af63146387}},9,"F-H2-1517",677,3},
  {{{0x925e1786493ad28a}},7,"F-H2-1518",902,5},
  {{{0x63d35458ee82e874}},7,"F-H2-1519",951,5},
  {{{0xfaf1e9a52f774c2e}},7,"F-H2-1520",943,2},
  {{{0x9ac207e49b10ca58}},9,"F-H2-1521",420,4},
  {{{0x900bde4c1bae1070}},7,"F-H2-1522",906,2},
  {{{0xa1c24385c2099c8c}},8,"F-H2-1523",429,2},
  {{{0xf6788db1213ae75c}},8,"F-H2-1524",419,5},
  {{{0x1bbdc62f84a0f8a}},8,"F-H2-1525",495,5},
  {{{0xbeac2291387d47d7}},6,"F-H2-1526",566,2},
  {{{0xbeac2291387d47d7}},6,"F-H2-1527",531,2},
  {{{0x6f4376ec5e3ab880}},6,"F-H2-1528",765,2},
  {{{0x6bf31bce14d0ba2c}},9,"F-H2-1529",677,2},
  {{{0xb6982f7708fba1bc}},9,"F-H2-1530",875,2},
  {{{0x253ccfe2bc5d9274}},12,"F-H2-1531",418,2},
  {{{0x50428dd89cbce0a7}},6,"F-H2-1532",874,2},
  {{{0xac2f6baf8cb4b20a}},6,"F-H2-1533",839,2},
  {{{0x48cd0183ce9cfed0}},7,"F-H2-1534",457,3},
  {{{0x6a13ec898b57f14e}},8,"F-H2-1535",529,4},
  {{{0xfe08541effc35e8e}},7,"F-H2-1536",424,3},
  {{{0x306799c2771e6e11}},7,"F-H2-1537",690,2},
  {{{0xeb17d34643a46c5c}},7,"F-H2-1538",941,2},
  {{{0xeb17d34643a46c5c}},7,"F-H2-1539",826,2},
  {{{0x1b9423ea649262c}},17,"F-H2-1540",462,2},
  {{{0x8579387bb5ed8378}},17,"F-H2-1541",875,2},
  {{{0x430b60f0398c9203}},6,"F-H2-1542",874,3},
  {{{0xf224fc88a6b9b854}},6,"F-H2-1543",947,2},
  {{{0x1159e80297984d7b}},8,"F-H2-1544",801,2},
  {{{0x1159e80297984d7b}},8,"F-H2-1545",913,2},
  {{{0x99a29fe969fc96e3}},9,"F-H2-1546",491,5},
  {{{0x189753cf2b5d1d5f}},5,"F-H2-1547",826,3},
  {{{0x4e95b699d2591892}},11,"F-H2-1548",504,2},
  {{{0x64fcee858b676650}},9,"F-H2-1549",418,3},
  {{{0x77e671d714ed0cd1}},11,"F-H2-1550",974,3},
  {{{0xd8d0f2bcbec7a1b}},7,"F-H2-1551",936,5},
  {{{0xb957ac144f6ec434}},9,"F-H2-1552",580,5},
  {{{0xe35b13b758cf6a68}},14,"F-H2-1553",948,4},
  {{{0xe03c91ef15f03e6f}},4,"F-H2-1554",949,2},
  {{{0x1b6f19fc626d6185}},7,"F-H2-1555",870,3},
  {{{0xb8afcf5bbc067f9d}},9,"F-H2-1556",877,4},
  {{{0x98d430a57283f8f0}},9,"F-H2-1557",603,5},
  {{{0xc4f6ae96f806ce2d}},11,"F-H2-1558",947,3},
  {{{0x52c34a4b0b5c1b98}},10,"F-H2-1559",506,2},
  {{{0xfb1f6cafcf7dc2ad}},7,"F-H2-1560",417,5},
  {{{0xf83e4b89b23beb5c}},8,"F-H2-1561",461,2},
  {{{0xfd34d89635a333a1}},5,"F-H2-1562",543,3},
  {{{0xeffb4dc58274e043}},11,"F-H2-1563",529,3},
  {{{0x20e041a26b05d1a9}},12,"F-H2-1564",469,2},
  {{{0x1bcc0e0de81c561}},13,"F-H2-1565",418,5},
  {{{0x46b8e49ef239a4f1}},8,"F-H2-1566",654,4},
  {{{0x23755ea65da7aa4f}},5,"F-H2-1567",801,2},
  {{{0x28c64da91cc5cda4}},7,"F-H2-1568",912,5},
  {{{0x580da03f26b5a824}},7,"F-H2-1569",838,2},
  {{{0xbe341c7119ce453e}},11,"F-H2-1570",947,3},
  {{{0x504e0693a7bf6557}},20,"F-H2-1571",800,3},
  {{{0x504e0693a7bf6557}},20,"F-H2-1572",764,2},
  {{{0xeb3efbdf55242cb9}},10,"F-H2-1573",429,2},
  {{{0x563837b2164c2e37}},10,"F-H2-1574",677,2},
  {{{0xc8e69112aefc2748}},15,"F-H2-1575",568,5},
  {{{0xefd2aa01d232a26}},10,"F-H2-1576",840,4},
  {{{0xdefbbcdd6569fe8f}},10,"F-H2-1577",418,3},
  {{{0x3675ff8a2644df29}},10,"F-H2-1578",616,2},
  {{{0x9ccae18feeb94232}},10,"F-H2-1579",902,2},
  {{{0x63ad2080864adfe}},8,"F-H2-1580",764,4},
  {{{0x588a68adc718720b}},8,"F-H2-1581",419,5},
  {{{0xe1560ba159beba12}},6,"F-H2-1582",420,2},
  {{{0x89b84b23dba0b839}},6,"F-H2-1583",802,2},
  {{{0xf59dd4447b6ce2db}},7,"F-H2-1584",494,3},
  {{{0x738c4d3fac9fc59f}},7,"F-H2-1585",419,5},
  {{{0x81b2673498659bb0}},10,"F-H2-1586",421,2},
  {{{0x81b2673498659bb0}},10,"F-H2-1587",936,2},
  {{{0x9ac48f26911c9701}},8,"F-H2-1588",492,2},
  {{{0x9ac48f26911c9701}},8,"F-H2-1589",455,2},
  {{{0x7aa7ef67aa37d586}},6,"F-H2-1590",495,2},
  {{{0x7aa7ef67aa37d586}},6,"F-H2-1591",459,2},
  {{{0xe553f7513d6cd95b}},5,"F-H2-1592",429,3},
  {{{0x2ca5be2381963ac1}},8,"F-H2-1593",418,4},
  {{{0x4f6920383a35f2c8}},8,"F-H2-1594",430,3},
  {{{0x555db323c01a379d}},8,"F-H2-1595",605,4},
  {{{0x581299b2dbe9d036}},8,"F-H2-1596",424,5},
  {{{0x6a191f2c9bfc74b4}},4,"F-H2-1597",949,2},
  {{{0x178f0aad8ca4fe3d}},8,"F-H2-1598",419,5},
  {{{0x611547125f91120e}},7,"F-H2-1599",864,4},
  {{{0xe7711bd50d98a735}},6,"F-H2-1600",421,3},
  {{{0x5e97ae36dda2fe36}},8,"F-H2-1601",432,4},
  {{{0x73f7a21aa7030787}},9,"F-H2-1602",641,4},
  {{{0xe106c946455392b3}},5,"F-H2-1603",543,2},
  {{{0x9bf67497e053308a}},9,"F-H2-1604",940,3},
  {{{0xb6b024d6647b2332}},6,"F-H2-1605",531,2},
  {{{0xd586adeb8fb6a385}},9,"F-H2-1606",988,4},
  {{{0x57a16aff69985572}},9,"F-H2-1607",531,5},
  {{{0x2ef81b0ec66207f5}},8,"F-H2-1608",802,2},
  {{{0x4b3a29d5fa6ee1c0}},12,"F-H2-1609",496,5},
  {{{0x90d518f6a852f999}},6,"F-H2-1610",690,2},
  {{{0xc790e154b13bf764}},10,"F-H2-1611",567,3},
  {{{0xeea10324955ab237}},10,"F-H2-1612",456,5},
  {{{0xaeea23f07e405bf6}},6,"F-H2-1613",429,4},
  {{{0x9eb8f88c5d10edab}},11,"F-H2-1614",459,4},
  {{{0x2196d149cf1ca72c}},6,"F-H2-1615",764,3},
  {{{0x3da62e2f765d0bb1}},7,"F-H2-1616",462,2},
  {{{0xda03bd86aabb7ffc}},7,"F-H2-1617",425,2},
  {{{0xdedd46f00420b2e3}},11,"F-H2-1618",529,4},
  {{{0x787ee38babb5621a}},8,"F-H2-1619",432,3},
  {{{0xead8ec5e9ec43928}},7,"F-H2-1620",909,3},
  {{{0x8bfb4d0f75cffa50}},8,"F-H2-1621",949,5},
  {{{0xd39ffb737769622c}},5,"F-H2-1622",826,3},
  {{{0x44222072ca7f8a0e}},6,"F-H2-1623",455,2},
  {{{0xdd92c69acdd92719}},6,"F-H2-1624",947,2},
  {{{0x50461075dd493d92}},6,"F-H2-1625",802,2},
  {{{0x7310951ab941f010}},6,"F-H2-1626",874,2},
  {{{0xc1a481aa0b0927c7}},8,"F-H2-1627",604,2},
  {{{0x5df350c06f71c3fa}},10,"F-H2-1628",432,2},
  {{{0xae9618ed0bb2bafd}},10,"F-H2-1629",431,3},
  {{{0x45bf10e39f81ec30}},17,"F-H2-1630",691,5},
  {{{0x4776e00185710496}},9,"F-H2-1631",492,3},
  {{{0xce71d9406a571c78}},7,"F-H2-1632",466,2},
  {{{0xb424d10605e7c6bd}},7,"F-H2-1633",902,2},
  {{{0x3e51014ff8e95f6f}},9,"F-H2-1634",640,2},
  {{{0x4b5c95ed79d67ec1}},6,"F-H2-1635",462,2},
  {{{0xaec2b3b8302a25a2}},9,"F-H2-1636",421,4},
  {{{0xbcafae66c060abf0}},10,"F-H2-1637",423,3},
  {{{0xbcafae66c060abf0}},10,"F-H2-1638",424,2},
  {{{0x71a3ce6ecabf78ba}},10,"F-H2-1639",418,3},
  {{{0x5968baf1ed1f8bb0}},5,"F-H2-1640",943,2},
  {{{0x41a99e0e36e3bd64}},8,"F-H2-1641",456,4},
  {{{0xbed3da1c33d64690}},6,"F-H2-1642",764,2},
  {{{0x2a00a6c040890479}},7,"F-H2-1643",826,3},
  {{{0xb3c7342a5bea4609}},10,"F-H2-1644",425,2},
  {{{0x7146e1712b64536e}},10,"F-H2-1645",429,2},
  {{{0xe8b6874322508d0e}},9,"F-H2-1646",691,4},
  {{{0x137fd378c5f0dcf5}},8,"F-H2-1647",867,2},
  {{{0x585bb29b753b0e17}},9,"F-H2-1648",566,5},
  {{{0x976b97d9034bc378}},6,"F-H2-1649",418,2},
  {{{0xae76c48540bc0c2c}},14,"F-H2-1650",532,4},
  {{{0x5ea1bdf9d9a2279}},9,"F-H2-1651",826,3},
  {{{0xc886609098a4d029}},14,"F-H2-1652",418,5},
  {{{0xd59e6e5aa56c9b4a}},7,"F-H2-1653",911,3},
  {{{0xf4588f1d6f5bb2a8}},6,"F-H2-1654",418,2},
  {{{0xccac9c75c5e60c71}},7,"F-H2-1655",905,3},
  {{{0xba6d088059f8efb9}},15,"F-H2-1656",492,5},
  {{{0x6fc28c66fac9486c}},7,"F-H2-1657",902,4},
  {{{0x8dc545fa46190979}},6,"F-H2-1658",914,4},
  {{{0xb0d3d279dd22bf07}},16,"F-H2-1659",839,2},
  {{{0xccfa426453a440ff}},6,"F-H2-1660",678,2},
  {{{0x43ec5038d1d7e27c}},5,"F-H2-1661",530,4},
  {{{0x5d581c90ed29f782}},8,"F-H2-1662",419,2},
  {{{0x85595c70166a904f}},11,"F-H2-1663",937,3},
  {{{0x85595c70166a904f}},11,"F-H2-1664",862,2},
  {{{0x9723efaa6fc51d23}},9,"F-H2-1665",603,5},
  {{{0xa367f0a847a8da65}},7,"F-H2-1666",543,2},
  {{{0x458846ace09b2531}},9,"F-H2-1667",459,2},
  {{{0x271690d4185e6532}},9,"F-H2-1668",947,2},
  {{{0x61af71de03a8f955}},10,"F-H2-1669",424,3},
  {{{0xa9eb4f895ddc10a2}},9,"F-H2-1670",728,3},
  {{{0x1028bb8116594464}},7,"F-H2-1671",455,2},
  {{{0x1028bb8116594464}},7,"F-H2-1672",381,2},
  {{{0xddc75c0c0816d736}},6,"F-H2-1673",985,4},
  {{{0x215df775ab372fcb}},10,"F-H2-1674",418,3},
  {{{0x41ce3b215b0cac09}},6,"F-H2-1675",913,3},
  {{{0x6d713bef13a071fb}},9,"F-H2-1676",381,3},
  {{{0x31bfff643edab0b0}},13,"F-H2-1677",420,3},
  {{{0x45391d4f3d00bd8c}},15,"F-H2-1678",421,3},
  {{{0x8d6e2dae488a5bbc}},8,"F-H2-1679",903,2},
  {{{0x57cd9cbf79371c5}},8,"F-H2-1680",432,2},
  {{{0xbbe7fa2a164d5fac}},5,"F-H2-1681",466,3},
  {{{0x810f91f42d16b3d2}},8,"F-H2-1682",456,2},
  {{{0x86617fc5a4c93e6}},7,"F-H2-1683",494,2},
  {{{0xdcd5d08b21654d1d}},11,"F-H2-1684",530,3},
  {{{0x27307c67a6d80139}},7,"F-H2-1685",529,3},
  {{{0x88d0002cdc48b66c}},11,"F-H2-1686",652,2},
  {{{0x88d0002cdc48b66c}},11,"F-H2-1687",654,2},
  {{{0xd017e98dfc817ade}},8,"F-H2-1688",939,2},
  {{{0x96f7022526929f30}},10,"F-H2-1689",417,4},
  {{{0x32b473b74c7b1381}},9,"F-H2-1690",945,2},
  {{{0x883fd81025b50a5d}},8,"F-H2-1691",457,2},
  {{{0xedd656cb7209a96b}},10,"F-H2-1692",458,2},
  {{{0x35b4fb9174d902c5}},7,"F-H2-1693",912,4},
  {{{0xf45ba0a937b93c1b}},8,"F-H2-1694",418,2},
  {{{0x6d1a5cc5428d8e87}},8,"F-H2-1695",418,3},
  {{{0x2d07c0d7112024b6}},15,"F-H2-1696",765,3},
  {{{0x31926a43b1853a87}},5,"F-H2-1697",466,3},
  {{{0x3d3bd62f9f6d105e}},9,"F-H2-1698",986,3},
  {{{0xb5ca7711b76eb106}},10,"F-H2-1699",454,2},
  {{{0xf68161f18c32335d}},7,"F-H2-1700",458,4},
  {{{0x7140563fb62ece05}},7,"F-H2-1701",826,2},
  {{{0xdf63722c4e0c2874}},8,"F-H2-1702",985,3},
  {{{0x42cd83ac8c27c148}},9,"F-H2-1703",827,4},
  {{{0xbd96656cd33d8c7c}},13,"F-H2-1704",765,3},
  {{{0x70e83bc0bc1559a0}},6,"F-H2-1705",678,3},
  {{{0xa222e6e267ab4374}},8,"F-H2-1706",939,2},
  {{{0x6aa3ed1c373eba0e}},6,"F-H2-1707",382,3},
  {{{0xe5426aa5005eaaf5}},10,"F-H2-1708",425,2},
  {{{0xb15c63ceb500deaf}},11,"F-H2-1709",911,2},
  {{{0x6f9362aa341939ff}},10,"F-H2-1710",936,2},
  {{{0x99c86ae392d56961}},10,"F-H2-1711",503,2},
  {{{0x694e55522aaae400}},8,"F-H2-1712",910,3},
  {{{0xb5c1646e83956d88}},7,"F-H2-1713",530,4},
  {{{0x1cde220dfbade3e7}},7,"F-H2-1714",429,2},
  {{{0x86fcc7a1e34dc93f}},9,"F-H2-1715",456,4},
  {{{0x2e97a5676a3745a1}},9,"F-H2-1716",382,4},
  {{{0xca0e40994650f1e}},7,"F-H2-1717",949,3},
  {{{0x9ec2be8f4c7cbdcf}},7,"F-H2-1718",728,4},
  {{{0x4d8006968fd8af11}},12,"F-H2-1719",567,2},
  {{{0x619c3ca00356a75}},7,"F-H2-1720",491,2},
  {{{0xa989629cdd044773}},7,"F-H2-1721",494,4},
  {{{0x2b7745b5d60676b1}},9,"F-H2-1722",945,2},
  {{{0x349aaa67478485b9}},11,"F-H2-1723",421,2},
  {{{0xb238f955d94c89e}},7,"F-H2-1724",941,2},
  {{{0x7f6cd213c230fe77}},10,"F-H2-1725",530,2},
  {{{0xbdbba5500e90c045}},10,"F-H2-1726",543,2},
  {{{0xa33db5c0cf6b0d10}},9,"F-H2-1727",875,2},
  {{{0x31e4f4a3935ed59a}},6,"F-H2-1728",420,3},
  {{{0xab5be2b123caf213}},10,"F-H2-1729",418,2},
  {{{0xf6d67a5d79d47538}},10,"F-H2-1730",943,2},
  {{{0x9b66ba8f5453929}},11,"F-H2-1731",430,2},
  {{{0x468ad34226138ee9}},10,"F-H2-1732",615,4},
  {{{0x3418c94219d7fb1f}},10,"F-H2-1733",690,3},
  {{{0xb39e394e185db9e4}},6,"F-H2-1734",529,2},
  {{{0x396ab0f5f1dfecc0}},9,"F-H2-1735",950,2},
  {{{0x2dba60dce661f275}},8,"F-H2-1736",529,2},
  {{{0x81dd3e5f192baaea}},12,"F-H2-1737",493,2},
  {{{0x15918414add6954b}},9,"F-H2-1738",603,2},
  {{{0x15918414add6954b}},9,"F-H2-1739",421,2},
  {{{0x3e9eb7f7f768e50e}},6,"F-H2-1740",906,2},
  {{{0x45c3902236446874}},6,"F-H2-1741",543,2},
  {{{0x8c4c5236e3d07fbe}},9,"F-H2-1742",951,3},
  {{{0xf115b5df9fe68db4}},7,"F-H2-1743",911,3},
  {{{0x841f5ac830568126}},11,"F-H2-1744",457,3},
  {{{0x1a5aae3b31113340}},8,"F-H2-1745",603,2},
  {{{0xac65648a03cf23eb}},8,"F-H2-1746",501,2},
  {{{0xa372219ddf8b8679}},5,"F-H2-1747",837,3},
  {{{0x581f6e5b24a0eac2}},13,"F-H2-1748",461,3},
  {{{0x97bfd1069620290}},8,"F-H2-1749",422,3},
  {{{0x485d83df74ba69a0}},7,"F-H2-1750",458,4},
  {{{0x1fe0d83d79bde2b8}},8,"F-H2-1751",541,2},
  {{{0x850f755e9ac6f16c}},7,"F-H2-1752",873,3},
  {{{0xd93f5e5fbbcc4cc2}},4,"F-H2-1753",865,4},
  {{{0xf796809f9bbe2088}},13,"F-H2-1754",493,2},
  {{{0x3e529875e0e7145e}},9,"F-H2-1755",466,2},
  {{{0xf9cf0cd73fc7b59e}},5,"F-H2-1756",906,2},
  {{{0xcd9d4f08e1dd9412}},12,"F-H2-1757",497,4},
  {{{0x7e2236021217a476}},17,"F-H2-1758",491,3},
  {{{0x18b9318700be837a}},9,"F-H2-1759",530,3},
  {{{0xc3d80584783fdc50}},7,"F-H2-1760",427,3},
  {{{0x79531e4296197834}},11,"F-H2-1761",493,4},
  {{{0x55ab64a7c2570a17}},14,"F-H2-1762",454,4},
  {{{0x34c0420d2c483c7b}},8,"F-H2-1763",528,2},
  {{{0x344c0119ac888436}},8,"F-H2-1764",948,3},
  {{{0xf7e37fef77b0060f}},12,"F-H2-1765",421,2},
  {{{0xb21dd74f040cc46f}},9,"F-H2-1766",944,4},
  {{{0x96749cc2be089c47}},12,"F-H2-1767",949,3},
  {{{0xa3fea866098bf614}},8,"F-H2-1768",459,2},
  {{{0xba3c497ddd8699fb}},8,"F-H2-1769",874,3},
  {{{0xee6b5074623e1204}},20,"F-H2-1770",985,3},
  {{{0x6df0a4c3b690f10a}},8,"F-H2-1771",462,3},
  {{{0x6ba4ab72ef8c4dd0}},6,"F-H2-1772",939,2},
  {{{0xc88806bafb5548f6}},9,"F-H2-1773",728,4},
  {{{0x9d8be9f4a7a4c501}},7,"F-H2-1774",825,3},
  {{{0x40596843bae08ed1}},9,"F-H2-1775",950,2},
  {{{0x8a9eeff6a3e6286}},9,"F-H2-1776",764,2},
  {{{0x7172c9cf70ca5e14}},7,"F-H2-1777",910,2},
  {{{0x2b74d7c860e13485}},7,"F-H2-1778",543,2},
  {{{0xd844228fe9af70cd}},11,"F-H2-1779",454,4},
  {{{0x42a429f293947731}},9,"F-H2-1780",914,3},
  {{{0x5f2cdebeaaba0959}},9,"F-H2-1781",726,2},
  {{{0x4934b68e4fd2d10a}},22,"F-H2-1782",983,3},
  {{{0xd202bf2d70c6e511}},9,"F-H2-1783",466,2},
  {{{0x2b32db40a8602338}},21,"F-H2-1784",876,4},
  {{{0xb32faac74b74620c}},6,"F-H2-1785",802,2},
  {{{0x1a00bad664787313}},17,"F-H2-1786",984,4},
  {{{0x54b64fffc3c0201}},18,"F-H2-1787",987,3},
  {{{0x303bd10d51039ea2}},8,"F-H2-1788",789,4},
  {{{0xee6104cd3429d1eb}},10,"F-H2-1789",936,2},
  {{{0xa1c2e5a712776645}},8,"F-H2-1790",906,2},
  {{{0xdc5cdd4d9da7f86b}},6,"F-H2-1791",420,2},
  {{{0xe67027053250e610}},13,"F-H2-1792",876,2},
  {{{0xf0108f6fa01b1ab7}},10,"F-H2-1793",567,4},
  {{{0xc432f9dec183c6a8}},11,"F-H2-1794",417,4},
  {{{0x4913e97964afa211}},9,"F-H2-1795",495,4},
  {{{0xff610acc484ee6ee}},9,"F-H2-1796",431,3},
  {{{0x308b1fe3b9b73fc0}},8,"F-H2-1797",456,3},
  {{{0xca11fc93feca111}},6,"F-H2-1798",424,2},
  {{{0x9076fcec396fd5e0}},7,"F-H2-1799",947,2},
  {{{0x33e5646172fd7c33}},7,"F-H2-1800",493,2},
  {{{0x3d4ce758b38190fc}},10,"F-H2-1801",458,4},
  {{{0x4f34e7ce08376a9d}},12,"F-H2-1802",948,3},
  {{{0xa901aab182b96b8c}},6,"F-H2-1803",906,3},
  {{{0x650f27ef24b5efa6}},18,"F-H2-1804",987,2},
  {{{0x3caff870fc5750a7}},18,"F-H2-1805",949,2},
  {{{0xb2cdb064f7c58d71}},8,"F-H2-1806",936,2},
  {{{0x10690cb362e62b25}},8,"F-H2-1807",465,2},
  {{{0xb703628373870bfb}},18,"F-H2-1808",492,2},
  {{{0xdae8717945256c97}},9,"F-H2-1809",456,3},
  {{{0xe1300a5932ee7e86}},10,"F-H2-1810",764,2},
  {{{0xe1300a5932ee7e86}},10,"F-H2-1811",432,2},
  {{{0x7c46c61e5604512a}},7,"F-H2-1812",530,2},
  {{{0xe42ce48383b9a16b}},9,"F-H2-1813",838,2},
  {{{0x1d028aadd2dae486}},9,"F-H2-1814",459,2},
  {{{0x7ea2219f9f2b800b}},11,"F-H2-1815",495,2},
  {{{0x7ea2219f9f2b800b}},11,"F-H2-1816",496,2},
  {{{0xe2c54a245891bbab}},7,"F-H2-1817",906,2},
  {{{0xa6e5dd82e2f03858}},12,"F-H2-1818",463,2},
  {{{0x5d80515582a65c41}},7,"F-H2-1819",494,2},
  {{{0x8047c4f5e06b0527}},12,"F-H2-1820",418,3},
  {{{0x9fc575bc7730db5}},6,"F-H2-1821",418,4},
  {{{0x3cbc40311918c043}},9,"F-H2-1822",950,3},
  {{{0xa403e38d6ac44005}},9,"F-H2-1823",419,2},
  {{{0x1454062c2abc32f4}},7,"F-H2-1824",494,2},
  {{{0x317e7551aaef3383}},5,"F-H2-1825",911,2},
  {{{0xfe7f6025186bd1ad}},10,"F-H2-1826",455,4},
  {{{0x11356e905c33842d}},11,"F-H2-1827",826,4},
  {{{0xad810886f964cecf}},9,"F-H2-1828",615,3},
  {{{0xf3f7d55945372d8b}},5,"F-H2-1829",419,3},
  {{{0x32a6353b5ca98472}},14,"F-H2-1830",800,3},
  {{{0xe24117197850fc80}},9,"F-H2-1831",465,3},
  {{{0xb199eec79f7cb553}},5,"F-H2-1832",949,3},
  {{{0xc4fc1368ac29ff91}},11,"F-H2-1833",420,4},
  {{{0xcbb1517928dc3f3b}},7,"F-H2-1834",838,2},
  {{{0xb894e7fedc51fdc3}},9,"F-H2-1835",950,2},
  {{{0xa4da6f0e7a8b3087}},8,"F-H2-1836",569,2},
  {{{0x61aac54f6cc15a3}},8,"F-H2-1837",641,2},
  {{{0x7403cc3f1a31ef24}},13,"F-H2-1838",492,3},
  {{{0xa044c77ed2a650fe}},9,"F-H2-1839",422,4},
  {{{0xca9c4f3178fa869a}},7,"F-H2-1840",530,3},
  {{{0x8f33245891d49138}},12,"F-H2-1841",529,3},
  {{{0x64d6bc54e4f87826}},11,"F-H2-1842",462,2},
  {{{0xb3af16b4b7c3b9a0}},9,"F-H2-1843",951,3},
  {{{0xd9cb7aab4c14746}},6,"F-H2-1844",492,2},
  {{{0x2f07fe82efe09ef2}},12,"F-H2-1845",877,4},
  {{{0x9056878397d3a598}},15,"F-H2-1846",947,4},
  {{{0xf8740223c8a89d1e}},9,"F-H2-1847",543,2},
  {{{0xc151cdb9f3cc8439}},16,"F-H2-1848",910,3},
  {{{0x811afee6b8e38ea}},11,"F-H2-1849",826,4},
  {{{0x62a3fca95611aa4b}},8,"F-H2-1850",985,4},
  {{{0x10e2a0cb1fe96692}},14,"F-H2-1851",872,3},
  {{{0xce5eecb0252091c9}},5,"F-H2-1852",691,3},
  {{{0x2fe0bcf408d584b7}},17,"F-H2-1853",495,3},
  {{{0x48340e458f97d8d8}},7,"F-H2-1854",836,2},
  {{{0x8c1476f450469028}},7,"F-H2-1855",458,4},
  {{{0x56e18d05f9ce54dd}},11,"F-H2-1856",568,2},
  {{{0x350b1eecf1f3b918}},7,"F-H2-1857",837,4},
  {{{0x33be942e1035df41}},16,"F-H2-1858",382,4},
  {{{0xeeb7696d1a9ac571}},9,"F-H2-1859",942,2},
  {{{0x68535a0146155c02}},7,"F-H2-1860",913,3},
  {{{0xcd646f3f1ec9ad06}},8,"F-H2-1861",765,4},
  {{{0xd739f798a9b8e02c}},13,"F-H2-1862",825,2},
  {{{0x95ccd9a45a7725f6}},10,"F-H2-1863",417,2},
  {{{0x886cf201451a1a3d}},6,"F-H2-1864",493,2},
  {{{0x102c05afd633ce68}},6,"F-H2-1865",936,2},
  {{{0xe59dcb4e29f7ae2}},6,"F-H2-1866",541,2},
  {{{0x64eca37286e28f4f}},7,"F-H2-1867",942,2},
  {{{0xfbf21b948ef0067a}},7,"F-H2-1868",678,3},
  {{{0xcb011a14782cc5af}},6,"F-H2-1869",987,3},
  {{{0x82ebc407165c78d4}},13,"F-H2-1870",495,2},
  {{{0x350f96f7a81f3828}},14,"F-H2-1871",948,3},
  {{{0x71945dcc86be523e}},5,"F-H2-1872",826,3},
  {{{0x9969078488bc8f56}},12,"F-H2-1873",579,2},
  {{{0xb3bafd69a32826b2}},11,"F-H2-1874",381,3},
  {{{0x61b1fea661775998}},8,"F-H2-1875",789,4},
  {{{0x43b41e971c7452e4}},10,"F-H2-1876",530,3},
  {{{0x7107f74a5b9b7f2b}},6,"F-H2-1877",947,3},
  {{{0x9b5cf048d65b13ef}},6,"F-H2-1878",529,4},
  {{{0xcba47603c1412ec}},15,"F-H2-1879",531,3},
  {{{0x9ad4023671a051c6}},7,"F-H2-1880",428,3},
  {{{0x82d4319e89c1d7a6}},12,"F-H2-1881",380,4},
  {{{0x36d44caaec9240a8}},12,"F-H2-1882",543,2},
  {{{0x89c864dafbc05570}},8,"F-H2-1883",459,3},
  {{{0xca8e9de659341808}},7,"F-H2-1884",950,2},
  {{{0x1e4343c00f7757a8}},11,"F-H2-1885",603,2},
  {{{0xbb6681916199c65c}},9,"F-H2-1886",827,3},
  {{{0xcfadeaa30799c33e}},5,"F-H2-1887",825,2},
  {{{0x7922e23258e8482}},8,"F-H2-1888",432,2},
  {{{0x4794a090187d5c44}},7,"F-H2-1889",906,2},
  {{{0x32a086da717500fa}},8,"F-H2-1890",459,2},
  {{{0xee4089668b376560}},10,"F-H2-1891",908,2},
  {{{0x6afdd3ab4984298f}},19,"F-H2-1892",458,2},
  {{{0xfbf648c62044ef57}},8,"F-H2-1893",765,3},
  {{{0x5eda923f107d91c4}},7,"F-H2-1894",470,2},
  {{{0x117d3c66d250823}},11,"F-H2-1895",493,3},
  {{{0xb24cd319453aa9b8}},7,"F-H2-1896",458,4},
  {{{0x63a6d56617f6b946}},6,"F-H2-1897",495,2},
  {{{0x63a6d56617f6b946}},6,"F-H2-1898",418,2},
  {{{0x6b3802618a15b03b}},6,"F-H2-1899",911,3},
  {{{0xd02edb02c5585bfb}},13,"F-H2-1900",912,4},
  {{{0x27a91a283839cb53}},9,"F-H2-1901",419,2},
  {{{0xa4798e501047c9ce}},5,"F-H2-1902",691,3},
  {{{0x3fb5eeac8ed35ac3}},8,"F-H2-1903",914,3},
  {{{0xf9a87ca3af92e2f8}},5,"F-H2-1904",429,2},
  {{{0xebda6b6157de99bd}},10,"F-H2-1905",865,4},
  {{{0x9eeb24a84f2d5186}},10,"F-H2-1906",945,2},
  {{{0x1d82f99987fed0e7}},11,"F-H2-1907",491,2},
  {{{0x9f8f6e41a48b43b6}},11,"F-H2-1908",421,3},
  {{{0x5bbd84e51b5112f}},16,"F-H2-1909",494,2},
  {{{0x553f07a8e67d58f8}},8,"F-H2-1910",457,3},
  {{{0xef51f312a57d251b}},8,"F-H2-1911",460,4},
  {{{0xc6b5fb3e66f67754}},8,"F-H2-1912",543,3},
  {{{0xac3463aa442f3688}},14,"F-H2-1913",836,2},
  {{{0x797ece835584785b}},8,"F-H2-1914",802,4},
  {{{0xa26c0dab01f8acd2}},10,"F-H2-1915",530,3},
  {{{0x1b980c2f2a3f4ead}},9,"F-H2-1916",426,2},
  {{{0x9f9d5d53005e26f9}},8,"F-H2-1917",802,3},
  {{{0x4ad5dcd28117f630}},15,"F-H2-1918",872,4},
  {{{0xd5922cf2366fc477}},8,"F-H2-1919",913,4},
  {{{0xfee11a5ba9a304e4}},12,"F-H2-1920",544,2},
  {{{0xda4cc757ad609728}},8,"F-H2-1921",429,2},
  {{{0xb15551f8fc310837}},16,"F-H2-1922",764,2},
  {{{0xad8b91dd3c586dde}},5,"F-H2-1923",463,2},
  {{{0x4fd457fb85bb2b0a}},10,"F-H2-1924",419,3},
  {{{0x7401750941713929}},6,"F-H2-1925",944,2},
  {{{0xa5e6f8b3d6c734cc}},5,"F-H2-1926",640,2},
  {{{0xa5e6f8b3d6c734cc}},5,"F-H2-1927",875,2},
  {{{0xb05fab9a11ba6f0c}},8,"F-H2-1928",875,2},
  {{{0xbfeb2b66045d16d1}},10,"F-H2-1929",899,3},
  {{{0xd6d8baf20b044681}},10,"F-H2-1930",945,2},
  {{{0xbf9e0b8029190afa}},9,"F-H2-1931",493,3},
  {{{0x94be157b0b506bdd}},12,"F-H2-1932",426,4},
  {{{0xaaaa2283a9ac15}},8,"F-H2-1933",456,2},
  {{{0xb545310f2af3e0d8}},11,"F-H2-1934",420,2},
  {{{0x69faef347920ad88}},19,"F-H2-1935",951,4},
  {{{0x5065cd09563dbb}},10,"F-H2-1936",425,2},
  {{{0xef3b6828b912b25e}},7,"F-H2-1937",458,2},
  {{{0x78c33d6e3662dc1b}},14,"F-H2-1938",380,2},
  {{{0x7f70d2159356e75c}},8,"F-H2-1939",987,3},
  {{{0xb7c67ed8ca3aef14}},10,"F-H2-1940",429,2},
  {{{0xb039ff0aa6ab20b7}},6,"F-H2-1941",458,2},
  {{{0x12883689e4f0f1e4}},9,"F-H2-1942",902,2},
  {{{0x90e9c91de33c1c4e}},23,"F-H2-1943",873,3},
  {{{0x6a09b4a0b66b5ee}},8,"F-H2-1944",913,4},
  {{{0x9301332e09c0456}},7,"F-H2-1945",913,4},
  {{{0x892f1f322c13acb7}},7,"F-H2-1946",420,2},
  {{{0x5a1a3bb768528496}},8,"F-H2-1947",727,2},
  {{{0xa2d568a3abfcc4f3}},10,"F-H2-1948",455,3},
  {{{0xce58bf63b6d1a0d4}},6,"F-H2-1949",458,2},
  {{{0x55ea0c8c16e975da}},10,"F-H2-1950",840,2},
  {{{0x7a843897f070b7bb}},9,"F-H2-1951",421,3},
  {{{0xe7f30aed8eed7dc5}},12,"F-H2-1952",907,2},
  {{{0x4e0c7dc720d09ac8}},10,"F-H2-1953",801,2},
  {{{0x51fb4954665d235}},10,"F-H2-1954",910,2},
  {{{0xa2963fd56a8cb85c}},8,"F-H2-1955",946,3},
  {{{0x95fb61739d71a968}},9,"F-H2-1956",801,2},
  {{{0xf8875fceb358b3f}},9,"F-H2-1957",425,2},
  {{{0x65720bb89d89237}},5,"F-H2-1958",837,2},
  {{{0xf1eee9618f8e252a}},7,"F-H2-1959",419,2},
  {{{0xdfdc530af9fc6a52}},13,"F-H2-1960",470,2},
  {{{0x819fe51adb0d74c}},3,"F-H3-1",949,259},
  {{{0x819fe51adb0d74c}},3,"F-H3-2",911,128},
  {{{0x819fe51adb0d74c}},3,"F-H3-3",912,121},
  {{{0x819fe51adb0d74c}},3,"F-H3-4",876,115},
  {{{0x819fe51adb0d74c}},3,"F-H3-7",543,6},
  {{{0x819fe51adb0d74c}},3,"F-H3-8",421,4},
  {{{0x819fe51adb0d74c}},3,"F-H3-9",684,3},
  {{{0x819fe51adb0d74c}},3,"F-H3-10",429,3},
  {{{0x7e4c230a6ba664c2}},4,"F-H3-11",875,435},
  {{{0x7e4c230a6ba664c2}},4,"F-H3-12",876,98},
  {{{0x225895d2cdcec16a}},4,"F-H3-13",462,53},
  {{{0x7e4c230a6ba664c2}},4,"F-H3-14",838,45},
  {{{0x7e4c230a6ba664c2}},4,"F-H3-15",462,42},
  {{{0x7e4c230a6ba664c2}},4,"F-H3-16",839,38},
  {{{0x225895d2cdcec16a}},4,"F-H3-17",684,8},
  {{{0x225895d2cdcec16a}},4,"F-H3-18",690,6},
  {{{0x225895d2cdcec16a}},4,"F-H3-19",912,6},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-20",764,88},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-21",802,73},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-22",876,43},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-23",543,37},
  {{{0x872ffdc219795cd4}},5,"F-H3-24",874,19},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-25",727,19},
  {{{0x872ffdc219795cd4}},5,"F-H3-26",838,12},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-27",421,9},
  {{{0x872ffdc219795cd4}},5,"F-H3-28",909,9},
  {{{0x872ffdc219795cd4}},5,"F-H3-29",421,5},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-30",429,4},
  {{{0x872ffdc219795cd4}},5,"F-H3-31",839,4},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-32",909,3},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-33",825,3},
  {{{0x69129e3a647ccd4c}},5,"F-H3-34",429,2},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-35",691,2},
  {{{0xc7b83f6c68772dc9}},5,"F-H3-36",728,2},
  {{{0x583b4c782674c7f1}},4,"F-H3-37",947,154},
  {{{0x583b4c782674c7f1}},4,"F-H3-38",678,78},
  {{{0x583b4c782674c7f1}},4,"F-H3-39",684,7},
  {{{0x583b4c782674c7f1}},4,"F-H3-40",838,5},
  {{{0x583b4c782674c7f1}},4,"F-H3-41",691,5},
  {{{0x583b4c782674c7f1}},4,"F-H3-42",939,3},
  {{{0x583b4c782674c7f1}},4,"F-H3-43",906,3},
  {{{0x583b4c782674c7f1}},4,"F-H3-44",677,3},
  {{{0x583b4c782674c7f1}},4,"F-H3-45",580,3},
  {{{0xc8903080b01c34a4}},4,"F-H3-46",459,2},
  {{{0x583b4c782674c7f1}},4,"F-H3-47",800,2},
  {{{0xad46082bfd9e121c}},4,"F-H3-48",949,77},
  {{{0xad46082bfd9e121c}},4,"F-H3-49",911,74},
  {{{0xad46082bfd9e121c}},4,"F-H3-50",678,57},
  {{{0xad46082bfd9e121c}},4,"F-H3-51",462,23},
  {{{0xb5448bb637921bb1}},4,"F-H3-53",690,8},
  {{{0xb5448bb637921bb1}},4,"F-H3-54",684,6},
  {{{0xad46082bfd9e121c}},4,"F-H3-55",944,5},
  {{{0xb5448bb637921bb1}},4,"F-H3-56",943,5},
  {{{0xb5448bb637921bb1}},4,"F-H3-57",691,5},
  {{{0xb5448bb637921bb1}},4,"F-H3-58",906,4},
  {{{0xb10aa66a181660e5}},4,"F-H3-60",458,3},
  {{{0xb5448bb637921bb1}},4,"F-H3-61",939,2},
  {{{0xb5448bb637921bb1}},4,"F-H3-62",950,2},
  {{{0xa9769a664762baa3}},4,"F-H3-63",913,87},
  {{{0xa9769a664762baa3}},4,"F-H3-64",462,58},
  {{{0x34e18770f5a4991b}},4,"F-H3-65",462,32},
  {{{0x34e18770f5a4991b}},4,"F-H3-66",906,22},
  {{{0x34e18770f5a4991b}},4,"F-H3-67",802,11},
  {{{0xa9769a664762baa3}},4,"F-H3-68",691,7},
  {{{0xa9769a664762baa3}},4,"F-H3-69",950,6},
  {{{0xa9769a664762baa3}},4,"F-H3-70",684,5},
  {{{0x34e18770f5a4991b}},4,"F-H3-71",939,4},
  {{{0x34e18770f5a4991b}},4,"F-H3-72",948,4},
  {{{0x8a639f2f5915f118}},4,"F-H3-73",677,4},
  {{{0xa9769a664762baa3}},4,"F-H3-74",906,4},
  {{{0x34e18770f5a4991b}},4,"F-H3-75",945,2},
  {{{0xa9769a664762baa3}},4,"F-H3-76",421,2},
  {{{0x34e18770f5a4991b}},4,"F-H3-77",580,2},
  {{{0xa9769a664762baa3}},4,"F-H3-78",944,2},
  {{{0x8a639f2f5915f118}},4,"F-H3-79",458,2},
  {{{0xdaf9fd636d1f471a}},5,"F-H3-80",839,24},
  {{{0xdaf9fd636d1f471a}},5,"F-H3-81",907,19},
  {{{0x762cd2a6d3d484f6}},5,"F-H3-82",765,18},
  {{{0xdaf9fd636d1f471a}},5,"F-H3-83",906,17},
  {{{0x762cd2a6d3d484f6}},5,"F-H3-84",910,15},
  {{{0x762cd2a6d3d484f6}},5,"F-H3-85",939,8},
  {{{0xdaf9fd636d1f471a}},5,"F-H3-86",939,7},
  {{{0x762cd2a6d3d484f6}},5,"F-H3-87",946,6},
  {{{0x762cd2a6d3d484f6}},5,"F-H3-88",691,4},
  {{{0x762cd2a6d3d484f6}},5,"F-H3-89",909,2},
  {{{0x762cd2a6d3d484f6}},5,"F-H3-90",429,2},
  {{{0x762cd2a6d3d484f6}},5,"F-H3-91",728,2},
  {{{0xfa7a9f5b7f911655}},6,"F-H3-92",909,71},
  {{{0xfa7a9f5b7f911655}},6,"F-H3-93",873,66},
  {{{0xfa7a9f5b7f911655}},6,"F-H3-94",910,16},
  {{{0x68f0f7e475efa8cd}},6,"F-H3-95",876,11},
  {{{0xfa7a9f5b7f911655}},6,"F-H3-96",872,6},
  {{{0x68f0f7e475efa8cd}},6,"F-H3-97",950,3},
  {{{0xfa7a9f5b7f911655}},6,"F-H3-98",837,2},
  {{{0xfa7a9f5b7f911655}},6,"F-H3-99",690,2},
  {{{0x992f839d8388e5d9}},6,"F-H3-100",950,79},
  {{{0x992f839d8388e5d9}},6,"F-H3-101",837,75},
  {{{0xc72af397e09221f8}},6,"F-H3-102",985,9},
  {{{0xc72af397e09221f8}},6,"F-H3-103",876,3},
  {{{0xc72af397e09221f8}},6,"F-H3-104",462,2},
  {{{0xb25e339845b5dd4e}},6,"F-H3-105",458,2},
  {{{0x992f839d8388e5d9}},6,"F-H3-106",912,2},
  {{{0x5e1fb037604da6ce}},5,"F-H3-107",764,36},
  {{{0x5e1fb037604da6ce}},5,"F-H3-108",727,22},
  {{{0x9b1dec126989fdc6}},5,"F-H3-109",944,22},
  {{{0x9b1dec126989fdc6}},5,"F-H3-110",909,8},
  {{{0x5e1fb037604da6ce}},5,"F-H3-111",543,7},
  {{{0x5e1fb037604da6ce}},5,"F-H3-112",802,5},
  {{{0x5e1fb037604da6ce}},5,"F-H3-113",691,3},
  {{{0x5e1fb037604da6ce}},5,"F-H3-114",765,3},
  {{{0x9b1dec126989fdc6}},5,"F-H3-115",421,2},
  {{{0x5e1fb037604da6ce}},5,"F-H3-116",429,2},
  {{{0xbd90da67e092c0d5}},5,"F-H3-117",838,30},
  {{{0xbd90da67e092c0d5}},5,"F-H3-118",801,17},
  {{{0xbd90da67e092c0d5}},5,"F-H3-119",939,14},
  {{{0xdf8d2eeb6bbf8d87}},5,"F-H3-120",950,4},
  {{{0xfc52b3be7ea358}},5,"F-H3-121",465,4},
  {{{0xdf8d2eeb6bbf8d87}},5,"F-H3-122",946,3},
  {{{0x92ddb8ccfd02b0c0}},5,"F-H3-123",839,3},
  {{{0xbd90da67e092c0d5}},5,"F-H3-124",529,2},
  {{{0xbd90da67e092c0d5}},5,"F-H3-125",543,2},
  {{{0xbd90da67e092c0d5}},5,"F-H3-126",876,2},
  {{{0x6a6ad04fc478c70f}},5,"F-H3-127",543,22},
  {{{0x6a6ad04fc478c70f}},5,"F-H3-128",939,17},
  {{{0xd8224c1b7027dc30}},5,"F-H3-129",421,14},
  {{{0xd8224c1b7027dc30}},5,"F-H3-130",425,6},
  {{{0x6a6ad04fc478c70f}},5,"F-H3-131",825,5},
  {{{0x66f88f45a20c609a}},5,"F-H3-132",949,23},
  {{{0xef7af66aa67187c2}},5,"F-H3-133",802,18},
  {{{0x66f88f45a20c609a}},5,"F-H3-134",874,16},
  {{{0xef7af66aa67187c2}},5,"F-H3-135",950,7},
  {{{0x66f88f45a20c609a}},5,"F-H3-136",909,3},
  {{{0xef7af66aa67187c2}},5,"F-H3-137",529,2},
  {{{0x7ad2d8913b9148d7}},6,"F-H3-138",839,65},
  {{{0x7ad2d8913b9148d7}},6,"F-H3-139",912,5},
  {{{0xb51b0f251a66df03}},6,"F-H3-140",530,2},
  {{{0xb1c236298ec8befb}},5,"F-H3-141",910,21},
  {{{0xf9c3e4c89e1bdfb3}},5,"F-H3-142",939,12},
  {{{0xb1c236298ec8befb}},5,"F-H3-143",947,3},
  {{{0xf9c3e4c89e1bdfb3}},5,"F-H3-144",875,3},
  {{{0xb1c236298ec8befb}},5,"F-H3-145",909,2},
  {{{0x9fb959e642b442e4}},5,"F-H3-146",714,2},
  {{{0xf9c3e4c89e1bdfb3}},5,"F-H3-147",529,2},
  {{{0xdee8d5cfa6fc898b}},7,"F-H3-148",987,17},
  {{{0x5685d76a4c6aa8ba}},7,"F-H3-149",949,15},
  {{{0x5685d76a4c6aa8ba}},7,"F-H3-150",912,10},
  {{{0x673b6ad7c364d57}},7,"F-H3-151",429,4},
  {{{0x2cbd4cf1b9d5536a}},7,"F-H3-152",383,2},
  {{{0xc375429ce5af7175}},7,"F-H3-153",422,15},
  {{{0x927bb1bf0f8fba36}},7,"F-H3-154",800,12},
  {{{0x927bb1bf0f8fba36}},7,"F-H3-155",913,10},
  {{{0xa8514f7520d38241}},7,"F-H3-156",838,6},
  {{{0x927bb1bf0f8fba36}},7,"F-H3-157",727,6},
  {{{0xa8514f7520d38241}},7,"F-H3-158",801,4},
  {{{0xa8514f7520d38241}},7,"F-H3-159",906,2},
  {{{0xc375429ce5af7175}},7,"F-H3-160",825,2},
  {{{0xaadcca02c9e2ec8c}},7,"F-H3-161",874,29},
  {{{0x1ba44ea7e82cf72c}},7,"F-H3-162",912,13},
  {{{0x1ba44ea7e82cf72c}},7,"F-H3-163",873,11},
  {{{0xfffb4830a9f4fb9b}},7,"F-H3-164",429,3},
  {{{0x8b262fde3bd496d4}},7,"F-H3-165",913,41},
  {{{0x75263ec609e70d47}},8,"F-H3-166",838,53},
  {{{0x75263ec609e70d47}},8,"F-H3-167",801,9},
  {{{0x75263ec609e70d47}},8,"F-H3-168",835,4},
  {{{0x4956f1f371b1650e}},8,"F-H3-169",906,2},
  {{{0xea89705e5de03497}},5,"F-H3-170",939,21},
  {{{0x4cd488335f04eb48}},5,"F-H3-171",939,17},
  {{{0x4cd488335f04eb48}},5,"F-H3-172",529,8},
  {{{0x4cd488335f04eb48}},5,"F-H3-173",825,3},
  {{{0xd474f988d092bb61}},5,"F-H3-174",789,2},
  {{{0xf0b790dc534ac650}},5,"F-H3-175",765,18},
  {{{0x621602db1c4ed7a5}},5,"F-H3-176",838,11},
  {{{0xf0b790dc534ac650}},5,"F-H3-177",876,10},
  {{{0xf0b790dc534ac650}},5,"F-H3-178",913,9},
  {{{0x621602db1c4ed7a5}},5,"F-H3-179",421,4},
  {{{0xf0b790dc534ac650}},5,"F-H3-180",837,4},
  {{{0xee13301c241690b2}},5,"F-H3-181",939,3},
  {{{0xf0b790dc534ac650}},5,"F-H3-182",543,3},
  {{{0xee13301c241690b2}},5,"F-H3-183",641,3},
  {{{0xf0b790dc534ac650}},5,"F-H3-184",421,2},
  {{{0x6416413591024143}},5,"F-H3-185",543,29},
  {{{0xb5e02d9e69508d9}},5,"F-H3-186",421,6},
  {{{0x6416413591024143}},5,"F-H3-187",939,5},
  {{{0x6416413591024143}},5,"F-H3-188",839,2},
  {{{0xe0a666da0d01be48}},6,"F-H3-189",617,17},
  {{{0xe0a666da0d01be48}},6,"F-H3-190",653,12},
  {{{0xe0a666da0d01be48}},6,"F-H3-191",950,11},
  {{{0xe0a666da0d01be48}},6,"F-H3-192",910,7},
  {{{0xe0a666da0d01be48}},6,"F-H3-193",691,6},
  {{{0xe0a666da0d01be48}},6,"F-H3-194",429,6},
  {{{0xe0a666da0d01be48}},6,"F-H3-195",466,3},
  {{{0x36fa38a3a5b2f95f}},6,"F-H3-196",876,2},
  {{{0xe0a666da0d01be48}},6,"F-H3-197",690,2},
  {{{0x887b69c218df42e}},5,"F-H3-198",543,19},
  {{{0x887b69c218df42e}},5,"F-H3-199",939,18},
  {{{0x84c6689cb89707eb}},5,"F-H3-200",421,11},
  {{{0x887b69c218df42e}},5,"F-H3-201",825,4},
  {{{0x1df098ef998b2dae}},5,"F-H3-202",465,2},
  {{{0x59650c7a5553aed5}},5,"F-H3-203",465,2},
  {{{0xde72b85433cac8b2}},6,"F-H3-204",873,61},
  {{{0xde72b85433cac8b2}},6,"F-H3-205",950,6},
  {{{0x30e380f5f26d68b}},7,"F-H3-206",946,33},
  {{{0xa5cd23eb43e4311c}},7,"F-H3-207",839,19},
  {{{0x524bebf87c7a368f}},6,"F-H3-208",690,28},
  {{{0x524bebf87c7a368f}},6,"F-H3-209",914,23},
  {{{0x941069713c204636}},6,"F-H3-210",640,3},
  {{{0x524bebf87c7a368f}},6,"F-H3-211",727,3},
  {{{0x941069713c204636}},6,"F-H3-212",714,2},
  {{{0xae889eeb06e6d56d}},9,"F-H3-213",947,33},
  {{{0xae889eeb06e6d56d}},9,"F-H3-214",911,6},
  {{{0x21032a642b73785d}},6,"F-H3-215",873,13},
  {{{0x21032a642b73785d}},6,"F-H3-216",948,12},
  {{{0x21032a642b73785d}},6,"F-H3-217",910,10},
  {{{0x21032a642b73785d}},6,"F-H3-218",950,7},
  {{{0x21032a642b73785d}},6,"F-H3-219",909,6},
  {{{0xd1063529bab0051d}},6,"F-H3-220",940,4},
  {{{0x21032a642b73785d}},6,"F-H3-221",654,3},
  {{{0x87c72df5f435cad3}},6,"F-H3-222",462,2},
  {{{0x5fb0467ae003994f}},6,"F-H3-223",427,2},
  {{{0x21032a642b73785d}},6,"F-H3-224",616,2},
  {{{0x21032a642b73785d}},6,"F-H3-225",653,2},
  {{{0xb9169e8d52ca13e6}},5,"F-H3-226",939,17},
  {{{0xb9169e8d52ca13e6}},5,"F-H3-227",529,13},
  {{{0xb9169e8d52ca13e6}},5,"F-H3-228",543,7},
  {{{0xd65edd61255d5a7c}},5,"F-H3-229",839,2},
  {{{0x4265fa9c98288587}},7,"F-H3-230",875,10},
  {{{0x4265fa9c98288587}},7,"F-H3-231",837,7},
  {{{0x6e055fc658d52922}},10,"F-H3-232",690,38},
  {{{0xf1dc63ddb77a9884}},10,"F-H3-233",425,8},
  {{{0xb06093767e25f686}},10,"F-H3-234",905,3},
  {{{0xfb080397e1ac6276}},6,"F-H3-235",617,13},
  {{{0xfb080397e1ac6276}},6,"F-H3-236",466,6},
  {{{0x46ff9bae58556e0d}},6,"F-H3-237",906,5},
  {{{0xfb080397e1ac6276}},6,"F-H3-238",542,3},
  {{{0xfb080397e1ac6276}},6,"F-H3-239",653,3},
  {{{0xfb080397e1ac6276}},6,"F-H3-240",678,2},
  {{{0x9c21cbbcb4cfa432}},8,"F-H3-241",801,39},
  {{{0x5fe49f44fd4380fb}},8,"F-H3-242",836,5},
  {{{0xbbd4f9042e6f8775}},8,"F-H3-243",458,3},
  {{{0x943587999ae62529}},6,"F-H3-244",873,17},
  {{{0x2ca3c94b0b66b7ab}},6,"F-H3-245",874,9},
  {{{0x943587999ae62529}},6,"F-H3-246",838,7},
  {{{0x943587999ae62529}},6,"F-H3-247",912,3},
  {{{0xfccf09c122aa0be}},6,"F-H3-248",457,2},
  {{{0x2ca3c94b0b66b7ab}},6,"F-H3-249",872,2},
  {{{0x3daee89ae90cf166}},8,"F-H3-250",871,12},
  {{{0xaf73b9c17b228cae}},8,"F-H3-251",764,12},
  {{{0x3daee89ae90cf166}},8,"F-H3-252",653,8},
  {{{0x3daee89ae90cf166}},8,"F-H3-253",950,8},
  {{{0x8cd82b537a50f91a}},6,"F-H3-254",948,23},
  {{{0x8cd82b537a50f91a}},6,"F-H3-255",839,12},
  {{{0xc2396221ffcef2ad}},8,"F-H3-257",837,40},
  {{{0x785043dc86ae02ba}},5,"F-H3-258",913,9},
  {{{0x785043dc86ae02ba}},5,"F-H3-259",543,8},
  {{{0x985b3a1fbad93f3}},5,"F-H3-260",945,7},
  {{{0x985b3a1fbad93f3}},5,"F-H3-261",911,5},
  {{{0x9faa127ba2cc8ffb}},5,"F-H3-262",678,2},
  {{{0x985b3a1fbad93f3}},5,"F-H3-263",944,2},
  {{{0xd70e96a57308cca4}},5,"F-H3-264",461,2},
  {{{0x6ca9b596acb73739}},9,"F-H3-265",873,28},
  {{{0x16572a929f954a0f}},10,"F-H3-266",912,38},
  {{{0xffbd3401c7dd2d4}},10,"F-H3-267",836,2},
  {{{0x20233f5cf5137ff6}},9,"F-H3-268",825,5},
  {{{0xc764358ec8dddc2a}},9,"F-H3-269",836,5},
  {{{0x7ea32a520c91eb4b}},11,"F-H3-270",429,18},
  {{{0x7ea32a520c91eb4b}},11,"F-H3-271",425,3},
  {{{0x17c6426bf6367c31}},11,"F-H3-272",421,2},
  {{{0x139b6ef292f4330a}},11,"F-H3-273",947,2},
  {{{0x368ef4c80cc81cd4}},5,"F-H3-274",543,20},
  {{{0xbacf2ac895d2ef11}},5,"F-H3-275",421,5},
  {{{0x368ef4c80cc81cd4}},5,"F-H3-276",939,5},
  {{{0xf5d6c02c1b10be93}},5,"F-H3-277",789,3},
  {{{0x44db9ac516d4a02d}},6,"F-H3-278",948,33},
  {{{0x44db9ac516d4a02d}},6,"F-H3-279",912,3},
  {{{0x81e5598eb1ee219a}},11,"F-H3-280",947,19},
  {{{0xbe959c26258d695f}},11,"F-H3-281",875,7},
  {{{0xbe959c26258d695f}},11,"F-H3-282",876,3},
  {{{0xf5fedd5f5a7d0cd5}},9,"F-H3-283",948,13},
  {{{0xbb5e96bb0e314a81}},9,"F-H3-284",417,2},
  {{{0xfec24e82e2efd0c7}},8,"F-H3-285",912,38},
  {{{0x28fc42bea5fd18b5}},7,"F-H3-286",986,14},
  {{{0x28fc42bea5fd18b5}},7,"F-H3-287",912,8},
  {{{0x63a5d36e62459a74}},6,"F-H3-288",947,9},
  {{{0x6036a002ae986aea}},6,"F-H3-289",873,6},
  {{{0x63a5d36e62459a74}},6,"F-H3-290",950,6},
  {{{0x6036a002ae986aea}},6,"F-H3-291",838,3},
  {{{0x2b3a084b11a7aacf}},12,"F-H3-292",427,21},
  {{{0x287da1cc6189356d}},12,"F-H3-293",905,3},
  {{{0x287da1cc6189356d}},12,"F-H3-294",826,3},
  {{{0x287da1cc6189356d}},12,"F-H3-295",906,2},
  {{{0x3000ab2bbd981d05}},6,"F-H3-296",466,7},
  {{{0x3000ab2bbd981d05}},6,"F-H3-297",617,6},
  {{{0x3000ab2bbd981d05}},6,"F-H3-298",653,5},
  {{{0xc9e106576805bd7b}},6,"F-H3-299",825,2},
  {{{0x3000ab2bbd981d05}},6,"F-H3-300",541,2},
  {{{0xd242e542b280eedd}},6,"F-H3-301",837,15},
  {{{0xd242e542b280eedd}},6,"F-H3-302",950,9},
  {{{0x94fceb376d25efad}},6,"F-H3-303",908,2},
  {{{0x844101de9e061740}},6,"F-H3-304",826,12},
  {{{0x844101de9e061740}},6,"F-H3-305",825,4},
  {{{0x844101de9e061740}},6,"F-H3-306",678,4},
  {{{0x844101de9e061740}},6,"F-H3-307",941,3},
  {{{0x844101de9e061740}},6,"F-H3-308",913,2},
  {{{0xf28d124f0761f53e}},10,"F-H3-309",799,30},
  {{{0x22e0bb1f376f986a}},6,"F-H3-310",912,10},
  {{{0xd47e6e95e37ec0db}},6,"F-H3-311",946,5},
  {{{0xd47e6e95e37ec0db}},6,"F-H3-312",873,4},
  {{{0xd47e6e95e37ec0db}},6,"F-H3-313",874,3},
  {{{0xd47e6e95e37ec0db}},6,"F-H3-314",950,3},
  {{{0x22e0bb1f376f986a}},6,"F-H3-315",875,2},
  {{{0xd47e6e95e37ec0db}},6,"F-H3-316",802,2},
  {{{0x3451de701d03ba2c}},11,"F-H3-317",835,4},
  {{{0x135d1fba645acd9b}},6,"F-H3-318",826,12},
  {{{0xaeaa8783dda3c1e0}},6,"F-H3-319",429,5},
  {{{0xaeaa8783dda3c1e0}},6,"F-H3-320",617,3},
  {{{0xd9e12974ef96362c}},6,"F-H3-321",906,2},
  {{{0xaeaa8783dda3c1e0}},6,"F-H3-322",875,2},
  {{{0x1a492b198fa84050}},6,"F-H3-323",875,23},
  {{{0x90ea3a830aa05808}},6,"F-H3-324",875,8},
  {{{0x4354f6ced3d98b47}},12,"F-H3-325",798,22},
  {{{0x4354f6ced3d98b47}},12,"F-H3-326",940,4},
  {{{0x8a5de22459dcf8f1}},6,"F-H3-327",876,11},
  {{{0x8a5de22459dcf8f1}},6,"F-H3-328",947,4},
  {{{0x8a5de22459dcf8f1}},6,"F-H3-329",874,3},
  {{{0x6f3643a4d0146c9d}},6,"F-H3-330",678,3},
  {{{0x6f3643a4d0146c9d}},6,"F-H3-331",462,2},
  {{{0x8300c52334b0619d}},6,"F-H3-332",837,16},
  {{{0xfaad054d6018322c}},6,"F-H3-333",950,7},
  {{{0x1ef8335f3b1b976c}},6,"F-H3-334",421,4},
  {{{0x5fd5b9b1390ba307}},5,"F-H3-335",543,6},
  {{{0x89faa32696d5d8c0}},5,"F-H3-336",429,6},
  {{{0x5fd5b9b1390ba307}},5,"F-H3-337",529,3},
  {{{0x9c8d8d552ed30140}},5,"F-H3-338",420,3},
  {{{0x89faa32696d5d8c0}},5,"F-H3-339",425,2},
  {{{0xc312b09ec4293d18}},7,"F-H3-340",950,6},
  {{{0xb7b6e3e09d141f78}},7,"F-H3-341",429,3},
  {{{0xc312b09ec4293d18}},7,"F-H3-342",802,2},
  {{{0xc312b09ec4293d18}},7,"F-H3-343",939,2},
  {{{0xc312b09ec4293d18}},7,"F-H3-344",429,2},
  {{{0xa607661fd9a3bad0}},7,"F-H3-345",429,6},
  {{{0xc2f34938aef4fd55}},7,"F-H3-346",943,4},
  {{{0x6ac1112625d885d4}},8,"F-H3-347",763,15},
  {{{0x6ac1112625d885d4}},8,"F-H3-348",950,5},
  {{{0x6ac1112625d885d4}},8,"F-H3-349",905,3},
  {{{0x6ac1112625d885d4}},8,"F-H3-350",764,2},
  {{{0xdd7f6ce5ac7ec145}},6,"F-H3-351",617,15},
  {{{0xdd7f6ce5ac7ec145}},6,"F-H3-352",466,4},
  {{{0x168f4749a49aabed}},6,"F-H3-353",690,3},
  {{{0x8daf670df96eb749}},6,"F-H3-354",462,2},
  {{{0xbeba1203b0642ea4}},10,"F-H3-355",947,24},
  {{{0xbeba1203b0642ea4}},10,"F-H3-356",876,2},
  {{{0xc4b729a05f3ada59}},12,"F-H3-357",836,17},
  {{{0xc4b729a05f3ada59}},12,"F-H3-358",950,9},
  {{{0xf1f9b23ba752ea77}},8,"F-H3-359",874,19},
  {{{0x805998cec53998dd}},8,"F-H3-360",458,2},
  {{{0x4f4c32a6ce044b21}},6,"F-H3-361",873,7},
  {{{0x4f4c32a6ce044b21}},6,"F-H3-362",874,3},
  {{{0x8aa3ccdf4b8338f7}},6,"F-H3-363",457,2},
  {{{0x4f4c32a6ce044b21}},6,"F-H3-364",910,2},
  {{{0x8aa3ccdf4b8338f7}},6,"F-H3-365",566,2},
  {{{0xd2a1b38865c28cfb}},6,"F-H3-366",566,2},
  {{{0xfe9c1467eb5bf077}},5,"F-H3-367",939,11},
  {{{0xfe9c1467eb5bf077}},5,"F-H3-368",421,6},
  {{{0x58c1ec0ae9bf2fa8}},5,"F-H3-369",939,4},
  {{{0xf8b22106a4a64cb7}},5,"F-H3-370",789,2},
  {{{0x693ec6108fe0cb00}},6,"F-H3-371",826,11},
  {{{0x693ec6108fe0cb00}},6,"F-H3-372",941,5},
  {{{0x693ec6108fe0cb00}},6,"F-H3-373",905,4},
  {{{0x88dde8f1907162d3}},6,"F-H3-374",429,4},
  {{{0x88dde8f1907162d3}},6,"F-H3-375",462,2},
  {{{0x1a0861101aeb0c4}},11,"F-H3-376",910,13},
  {{{0xec0d10f02080c45c}},11,"F-H3-377",840,3},
  {{{0xe5664cb0f46e98f5}},6,"F-H3-378",462,4},
  {{{0x826feb5520dac706}},6,"F-H3-379",457,4},
  {{{0x9cf2fb79f23e284c}},6,"F-H3-380",532,3},
  {{{0xe5664cb0f46e98f5}},6,"F-H3-381",950,3},
  {{{0x9cf2fb79f23e284c}},6,"F-H3-382",426,2},
  {{{0xe5664cb0f46e98f5}},6,"F-H3-383",678,2},
  {{{0x826feb5520dac706}},6,"F-H3-384",456,2},
  {{{0xca8abdf790dc6450}},9,"F-H3-385",946,12},
  {{{0xca8abdf790dc6450}},9,"F-H3-386",985,6},
  {{{0x55702646eaf5d835}},8,"F-H3-387",913,21},
  {{{0xf13a9ad6539150c6}},7,"F-H3-388",839,11},
  {{{0x342be4d423848a85}},7,"F-H3-389",949,6},
  {{{0x66202780fc305e0a}},7,"F-H3-390",456,3},
  {{{0x856305f2f3ddcdd5}},9,"F-H3-391",876,11},
  {{{0xc9fd1540a07e76c8}},11,"F-H3-392",838,11},
  {{{0xc153eee8ff6e1673}},12,"F-H3-393",949,8},
  {{{0xc153eee8ff6e1673}},12,"F-H3-394",946,7},
  {{{0xeae1b3bac1adf493}},12,"F-H3-395",801,4},
  {{{0xeae1b3bac1adf493}},12,"F-H3-396",877,2},
  {{{0xc4a3e8fff08c02eb}},10,"F-H3-397",839,19},
  {{{0x37481956def76922}},13,"F-H3-398",834,3},
  {{{0xb81e47d9bb423545}},14,"F-H3-399",797,13},
  {{{0xb81e47d9bb423545}},14,"F-H3-400",940,4},
  {{{0xb81e47d9bb423545}},14,"F-H3-401",759,3},
  {{{0x47167ab45e9726b4}},14,"F-H3-402",951,21},
  {{{0x4c4f657f425531d2}},4,"F-H3-403",912,5},
  {{{0x4c4f657f425531d2}},4,"F-H3-404",913,4},
  {{{0x4c4f657f425531d2}},4,"F-H3-405",462,3},
  {{{0x4c4f657f425531d2}},4,"F-H3-406",690,3},
  {{{0x6d20d4fbedce8bd}},7,"F-H3-407",912,17},
  {{{0x34ec2f5643cff82f}},12,"F-H3-408",984,21},
  {{{0xc5ba2f570e5e36fc}},13,"F-H3-409",987,13},
  {{{0x5e23b0e74957ae31}},10,"F-H3-410",948,16},
  {{{0x889417a56a3713c1}},10,"F-H3-411",874,7},
  {{{0xebaa94d10475b9a8}},8,"F-H3-412",911,23},
  {{{0x2c32bafbcd68bc17}},6,"F-H3-413",617,9},
  {{{0x2c32bafbcd68bc17}},6,"F-H3-414",466,6},
  {{{0x2c32bafbcd68bc17}},6,"F-H3-415",690,4},
  {{{0x8800a012681589c9}},7,"F-H3-416",541,7},
  {{{0x8800a012681589c9}},7,"F-H3-417",432,3},
  {{{0x6f16375fdd7ba479}},7,"F-H3-418",752,2},
  {{{0x8800a012681589c9}},7,"F-H3-419",466,2},
  {{{0x8800a012681589c9}},7,"F-H3-420",429,2},
  {{{0x6f16375fdd7ba479}},7,"F-H3-421",566,2},
  {{{0xcdd1941ad2f915c4}},6,"F-H3-422",826,8},
  {{{0xb1a5a7ed7fae9faf}},6,"F-H3-423",617,5},
  {{{0xb1a5a7ed7fae9faf}},6,"F-H3-424",541,2},
  {{{0xcdd1941ad2f915c4}},6,"F-H3-425",902,2},
  {{{0xcdd1941ad2f915c4}},6,"F-H3-426",905,2},
  {{{0x2e9a1bdc905c26f9}},15,"F-H3-427",985,12},
  {{{0x47d2b872cd9b6017}},7,"F-H3-428",728,7},
  {{{0x47d2b872cd9b6017}},7,"F-H3-429",690,2},
  {{{0x5a98401e9ca7b7cc}},9,"F-H3-430",913,17},
  {{{0x8c729d0e318e6b96}},8,"F-H3-431",799,21},
  {{{0x10770ed62ca9c44c}},6,"F-H3-432",941,4},
  {{{0x10770ed62ca9c44c}},6,"F-H3-433",905,4},
  {{{0x10770ed62ca9c44c}},6,"F-H3-434",826,3},
  {{{0x10770ed62ca9c44c}},6,"F-H3-435",875,3},
  {{{0xa651d6713b333850}},6,"F-H3-436",678,2},
  {{{0x10770ed62ca9c44c}},6,"F-H3-437",825,2},
  {{{0x23bc70a70d3e9d61}},8,"F-H3-438",531,5},
  {{{0x8a743cb4b928b710}},8,"F-H3-439",728,5},
  {{{0x8a743cb4b928b710}},8,"F-H3-440",910,3},
  {{{0x8a743cb4b928b710}},8,"F-H3-441",727,2},
  {{{0x23bc70a70d3e9d61}},8,"F-H3-442",462,2},
  {{{0x3eacefa641fa4e2}},8,"F-H3-443",985,2},
  {{{0xf893775d0ec91e06}},6,"F-H3-444",429,6},
  {{{0xf893775d0ec91e06}},6,"F-H3-445",466,3},
  {{{0xc451f065c59655e}},6,"F-H3-446",838,2},
  {{{0xc451f065c59655e}},6,"F-H3-447",906,2},
  {{{0xc451f065c59655e}},6,"F-H3-448",946,2},
  {{{0xf893775d0ec91e06}},6,"F-H3-449",876,2},
  {{{0xe28b836bd7c5bbcd}},6,"F-H3-450",603,8},
  {{{0xe28b836bd7c5bbcd}},6,"F-H3-451",530,2},
  {{{0x9ed87c5d2379aa33}},6,"F-H3-452",530,2},
  {{{0x907d061d3cfa0529}},6,"F-H3-453",690,2},
  {{{0x39d85a829b9972d9}},6,"F-H3-454",690,11},
  {{{0x39d85a829b9972d9}},6,"F-H3-455",914,6},
  {{{0x516c25ad039a1bc4}},6,"F-H3-456",873,14},
  {{{0x7767e464e4d3fa93}},6,"F-H3-457",911,6},
  {{{0x52272b21dfbc9aaa}},6,"F-H3-458",913,11},
  {{{0x2d5948fcb0d299da}},6,"F-H3-459",455,3},
  {{{0x2d5948fcb0d299da}},6,"F-H3-460",495,2},
  {{{0x4f5199e6688c1459}},6,"F-H3-461",418,2},
  {{{0x2b04ecb26ad50518}},13,"F-H3-462",865,5},
  {{{0x2b04ecb26ad50518}},13,"F-H3-463",936,4},
  {{{0xd9d1c4ceb37e9877}},13,"F-H3-464",543,2},
  {{{0x5de4ec08fd7a804}},16,"F-H3-465",876,12},
  {{{0x5de4ec08fd7a804}},16,"F-H3-466",873,5},
  {{{0xeda226afa0742e56}},16,"F-H3-467",385,3},
  {{{0x53618f152d6c206}},9,"F-H3-468",605,6},
  {{{0xba331b564f232bfb}},9,"F-H3-469",801,5},
  {{{0x9873100eeef6b652}},6,"F-H3-470",826,11},
  {{{0x9873100eeef6b652}},6,"F-H3-471",825,4},
  {{{0x9873100eeef6b652}},6,"F-H3-472",941,3},
  {{{0x8b356deab3952a83}},6,"F-H3-473",529,5},
  {{{0xda204853aeeb16dd}},6,"F-H3-474",906,5},
  {{{0x68d500c49be01618}},6,"F-H3-475",945,4},
  {{{0x8b356deab3952a83}},6,"F-H3-476",462,2},
  {{{0x8b356deab3952a83}},6,"F-H3-477",580,2},
  {{{0x68d500c49be01618}},6,"F-H3-478",946,2},
  {{{0x6104f037e118656a}},8,"F-H3-479",418,9},
  {{{0x77f8c4c7a0d33aba}},8,"F-H3-480",460,9},
  {{{0xb6670cf683bb651b}},6,"F-H3-481",950,18},
  {{{0xd475d827bd7b57ea}},6,"F-H3-482",423,11},
  {{{0xe8621da21e9150d3}},7,"F-H3-483",910,7},
  {{{0xe8621da21e9150d3}},7,"F-H3-484",947,3},
  {{{0x95b9d56dfe4bab80}},16,"F-H3-485",914,13},
  {{{0xc7ff573f75d63a42}},16,"F-H3-486",381,4},
  {{{0x18528569aa55041d}},7,"F-H3-487",951,10},
  {{{0x8d4e756c9fa5b0ee}},7,"F-H3-488",455,2},
  {{{0xae231f9b692c7f4}},15,"F-H3-489",948,13},
  {{{0xae6350cdbeb1f65f}},15,"F-H3-490",914,4},
  {{{0x4b610f22de113d69}},7,"F-H3-491",910,9},
  {{{0x6759c0c4a00225cc}},14,"F-H3-492",950,18},
  {{{0x121708c13662c48a}},7,"F-H3-493",874,14},
  {{{0xb8af132f6eab0900}},6,"F-H3-494",423,8},
  {{{0x98e85ac13c7fbd56}},6,"F-H3-495",421,4},
  {{{0x98e85ac13c7fbd56}},6,"F-H3-496",678,2},
  {{{0x9aa9b754571c5d8c}},7,"F-H3-497",874,6},
  {{{0xb9ff323b3314900e}},7,"F-H3-498",802,5},
  {{{0xcc12830c67d8a1da}},7,"F-H3-499",529,3},
  {{{0x7fc6692f7132d93a}},13,"F-H3-500",872,16},
  {{{0xa7e59533319db391}},6,"F-H3-501",876,13},
  {{{0xb2c9698878f698c9}},6,"F-H3-502",529,5},
  {{{0xb2c9698878f698c9}},6,"F-H3-503",423,2},
  {{{0x287958ea8a37c321}},10,"F-H3-504",801,7},
  {{{0xdc6e6ef67ebbd4bb}},10,"F-H3-505",950,5},
  {{{0x6e8c01053e22833a}},10,"F-H3-506",461,3},
  {{{0x1270bf2fc4c90623}},8,"F-H3-507",911,15},
  {{{0xdd9a42b362511721}},10,"F-H3-508",838,7},
  {{{0xce17614b745edfff}},10,"F-H3-509",873,5},
  {{{0xdd9a42b362511721}},10,"F-H3-510",876,3},
  {{{0x237dc048db4084a9}},9,"F-H3-511",912,14},
  {{{0xfabb2ce1b3b59e1c}},9,"F-H3-512",910,4},
  {{{0xb63b09ebbe0c224c}},9,"F-H3-513",907,3},
  {{{0x8414b1eae63c2375}},8,"F-H3-514",912,12},
  {{{0x8414b1eae63c2375}},8,"F-H3-515",909,2},
  {{{0x6801046bd8bc3d42}},8,"F-H3-516",838,2},
  {{{0xcf6259f6cec5ae49}},8,"F-H3-517",874,15},
  {{{0xf075072fd13915ed}},6,"F-H3-518",837,13},
  {{{0x6bfb9c627ee8df2b}},4,"F-H3-519",678,7},
  {{{0x6bfb9c627ee8df2b}},4,"F-H3-520",912,3},
  {{{0x6bfb9c627ee8df2b}},4,"F-H3-521",950,2},
  {{{0x6bfb9c627ee8df2b}},4,"F-H3-522",690,2},
  {{{0xc99c525d589e9d46}},11,"F-H3-523",874,14},
  {{{0xe65aa3cec9dab88f}},12,"F-H3-524",838,14},
  {{{0x6268d604a7cadb41}},12,"F-H3-525",495,2},
  {{{0xfd5d1f53ce2cf3a6}},7,"F-H3-526",801,2},
  {{{0x93570c7b39b673b9}},7,"F-H3-527",910,2},
  {{{0xed6b981480ec37de}},5,"F-H3-528",985,3},
  {{{0xb3f37d81a16dbd46}},5,"F-H3-529",531,2},
  {{{0xa6694a20f6b275c}},7,"F-H3-530",802,9},
  {{{0x8b7a95109f883b72}},7,"F-H3-531",459,4},
  {{{0xe680644125be5c3e}},8,"F-H3-532",947,9},
  {{{0xddf5235742d529aa}},9,"F-H3-533",948,10},
  {{{0x7e012af308450bb}},9,"F-H3-534",459,6},
  {{{0x7e012af308450bb}},9,"F-H3-535",458,4},
  {{{0x24dd4d71f094009a}},9,"F-H3-536",765,12},
  {{{0xd8b521f0af3d73f4}},8,"F-H3-537",949,15},
  {{{0x108660dd94ee06c9}},7,"F-H3-538",543,5},
  {{{0xc94d8919017915c3}},7,"F-H3-539",653,3},
  {{{0x108660dd94ee06c9}},7,"F-H3-540",906,3},
  {{{0x151f8f0a7