/* color.c generated by valac 0.56.18, the Vala compiler
 * generated from color.vala, do not modify */

/*///////////////////////////////////////////////////////////////////////*/
/* Copyright 2011-2021 Simon Schneegans*/
/**/
/* Permission is hereby granted, free of charge, to any person obtaining*/
/* a copy of this software and associated documentation files (the*/
/* "Software"), to deal in the Software without restriction, including*/
/* without limitation the rights to use, copy, modify, merge, publish,*/
/* distribute, sublicense, and/or sell copies of the Software, and to*/
/* permit persons to whom the Software is furnished to do so, subject to*/
/* the following conditions:*/
/* */
/* The above copyright notice and this permission notice shall be*/
/* included in all copies or substantial portions of the Software.*/
/* */
/* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,*/
/* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF*/
/* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.*/
/* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY*/
/* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,*/
/* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE*/
/* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
/*///////////////////////////////////////////////////////////////////////*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GNOME_PIE_TYPE_COLOR (gnome_pie_color_get_type ())
#define GNOME_PIE_COLOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_COLOR, GnomePieColor))
#define GNOME_PIE_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_COLOR, GnomePieColorClass))
#define GNOME_PIE_IS_COLOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_COLOR))
#define GNOME_PIE_IS_COLOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_COLOR))
#define GNOME_PIE_COLOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_COLOR, GnomePieColorClass))

typedef struct _GnomePieColor GnomePieColor;
typedef struct _GnomePieColorClass GnomePieColorClass;
typedef struct _GnomePieColorPrivate GnomePieColorPrivate;
enum  {
	GNOME_PIE_COLOR_0_PROPERTY,
	GNOME_PIE_COLOR_R_PROPERTY,
	GNOME_PIE_COLOR_G_PROPERTY,
	GNOME_PIE_COLOR_B_PROPERTY,
	GNOME_PIE_COLOR_A_PROPERTY,
	GNOME_PIE_COLOR_H_PROPERTY,
	GNOME_PIE_COLOR_S_PROPERTY,
	GNOME_PIE_COLOR_V_PROPERTY,
	GNOME_PIE_COLOR_NUM_PROPERTIES
};
static GParamSpec* gnome_pie_color_properties[GNOME_PIE_COLOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GNOME_PIE_TYPE_IMAGE (gnome_pie_image_get_type ())
#define GNOME_PIE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_PIE_TYPE_IMAGE, GnomePieImage))
#define GNOME_PIE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_PIE_TYPE_IMAGE, GnomePieImageClass))
#define GNOME_PIE_IS_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_PIE_TYPE_IMAGE))
#define GNOME_PIE_IS_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_PIE_TYPE_IMAGE))
#define GNOME_PIE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_PIE_TYPE_IMAGE, GnomePieImageClass))

typedef struct _GnomePieImage GnomePieImage;
typedef struct _GnomePieImageClass GnomePieImageClass;

struct _GnomePieColor {
	GObject parent_instance;
	GnomePieColorPrivate * priv;
};

struct _GnomePieColorClass {
	GObjectClass parent_class;
};

struct _GnomePieColorPrivate {
	gfloat _r;
	gfloat _g;
	gfloat _b;
	gfloat _a;
};

static gint GnomePieColor_private_offset;
static gpointer gnome_pie_color_parent_class = NULL;

VALA_EXTERN GType gnome_pie_color_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieColor, g_object_unref)
VALA_EXTERN GnomePieColor* gnome_pie_color_new (void);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct (GType object_type);
VALA_EXTERN GnomePieColor* gnome_pie_color_new_from_rgb (gfloat red,
                                             gfloat green,
                                             gfloat blue);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct_from_rgb (GType object_type,
                                                   gfloat red,
                                                   gfloat green,
                                                   gfloat blue);
VALA_EXTERN GnomePieColor* gnome_pie_color_new_from_rgba (gfloat red,
                                              gfloat green,
                                              gfloat blue,
                                              gfloat alpha);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct_from_rgba (GType object_type,
                                                    gfloat red,
                                                    gfloat green,
                                                    gfloat blue,
                                                    gfloat alpha);
VALA_EXTERN void gnome_pie_color_set_r (GnomePieColor* self,
                            gfloat value);
VALA_EXTERN void gnome_pie_color_set_g (GnomePieColor* self,
                            gfloat value);
VALA_EXTERN void gnome_pie_color_set_b (GnomePieColor* self,
                            gfloat value);
VALA_EXTERN void gnome_pie_color_set_a (GnomePieColor* self,
                            gfloat value);
VALA_EXTERN GnomePieColor* gnome_pie_color_new_from_gdk (GdkRGBA* color);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct_from_gdk (GType object_type,
                                                   GdkRGBA* color);
VALA_EXTERN GnomePieColor* gnome_pie_color_new_from_widget_style (GtkWidget* widget,
                                                      const gchar* style_name);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct_from_widget_style (GType object_type,
                                                            GtkWidget* widget,
                                                            const gchar* style_name);
VALA_EXTERN GnomePieColor* gnome_pie_color_new_from_string (const gchar* hex_string);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct_from_string (GType object_type,
                                                      const gchar* hex_string);
VALA_EXTERN GType gnome_pie_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GnomePieImage, g_object_unref)
VALA_EXTERN GnomePieColor* gnome_pie_color_new_from_icon (GnomePieImage* icon);
VALA_EXTERN GnomePieColor* gnome_pie_color_construct_from_icon (GType object_type,
                                                    GnomePieImage* icon);
VALA_EXTERN cairo_surface_t* gnome_pie_image_get_surface (GnomePieImage* self);
VALA_EXTERN gfloat gnome_pie_color_get_s (GnomePieColor* self);
VALA_EXTERN void gnome_pie_color_set_s (GnomePieColor* self,
                            gfloat value);
VALA_EXTERN void gnome_pie_color_set_v (GnomePieColor* self,
                            gfloat value);
VALA_EXTERN gchar* gnome_pie_color_to_hex_string (GnomePieColor* self);
VALA_EXTERN void gnome_pie_color_invert (GnomePieColor* self);
VALA_EXTERN gfloat gnome_pie_color_get_h (GnomePieColor* self);
VALA_EXTERN void gnome_pie_color_set_h (GnomePieColor* self,
                            gfloat value);
VALA_EXTERN gfloat gnome_pie_color_get_v (GnomePieColor* self);
static void gnome_pie_color_setHSV (GnomePieColor* self,
                             gfloat hue,
                             gfloat saturation,
                             gfloat val);
VALA_EXTERN gfloat gnome_pie_color_get_r (GnomePieColor* self);
VALA_EXTERN gfloat gnome_pie_color_get_g (GnomePieColor* self);
VALA_EXTERN gfloat gnome_pie_color_get_b (GnomePieColor* self);
VALA_EXTERN gfloat gnome_pie_color_get_a (GnomePieColor* self);
static void gnome_pie_color_finalize (GObject * obj);
static GType gnome_pie_color_get_type_once (void);
static void _vala_gnome_pie_color_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gnome_pie_color_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gnome_pie_color_get_instance_private (GnomePieColor* self)
{
	return G_STRUCT_MEMBER_P (self, GnomePieColor_private_offset);
}

GnomePieColor*
gnome_pie_color_construct (GType object_type)
{
	GnomePieColor * self = NULL;
	self = (GnomePieColor*) gnome_pie_color_construct_from_rgb (object_type, 1.0f, 1.0f, 1.0f);
	return self;
}

GnomePieColor*
gnome_pie_color_new (void)
{
	return gnome_pie_color_construct (GNOME_PIE_TYPE_COLOR);
}

GnomePieColor*
gnome_pie_color_construct_from_rgb (GType object_type,
                                    gfloat red,
                                    gfloat green,
                                    gfloat blue)
{
	GnomePieColor * self = NULL;
	self = (GnomePieColor*) gnome_pie_color_construct_from_rgba (object_type, red, green, blue, 1.0f);
	return self;
}

GnomePieColor*
gnome_pie_color_new_from_rgb (gfloat red,
                              gfloat green,
                              gfloat blue)
{
	return gnome_pie_color_construct_from_rgb (GNOME_PIE_TYPE_COLOR, red, green, blue);
}

GnomePieColor*
gnome_pie_color_construct_from_rgba (GType object_type,
                                     gfloat red,
                                     gfloat green,
                                     gfloat blue,
                                     gfloat alpha)
{
	GnomePieColor * self = NULL;
	self = (GnomePieColor*) g_object_new (object_type, NULL);
	gnome_pie_color_set_r (self, red);
	gnome_pie_color_set_g (self, green);
	gnome_pie_color_set_b (self, blue);
	gnome_pie_color_set_a (self, alpha);
	return self;
}

GnomePieColor*
gnome_pie_color_new_from_rgba (gfloat red,
                               gfloat green,
                               gfloat blue,
                               gfloat alpha)
{
	return gnome_pie_color_construct_from_rgba (GNOME_PIE_TYPE_COLOR, red, green, blue, alpha);
}

GnomePieColor*
gnome_pie_color_construct_from_gdk (GType object_type,
                                    GdkRGBA* color)
{
	GnomePieColor * self = NULL;
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	g_return_val_if_fail (color != NULL, NULL);
	_tmp0_ = *color;
	_tmp1_ = *color;
	_tmp2_ = *color;
	_tmp3_ = *color;
	self = (GnomePieColor*) gnome_pie_color_construct_from_rgba (object_type, (gfloat) _tmp0_.red, (gfloat) _tmp1_.green, (gfloat) _tmp2_.blue, (gfloat) _tmp3_.alpha);
	return self;
}

GnomePieColor*
gnome_pie_color_new_from_gdk (GdkRGBA* color)
{
	return gnome_pie_color_construct_from_gdk (GNOME_PIE_TYPE_COLOR, color);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GnomePieColor*
gnome_pie_color_construct_from_widget_style (GType object_type,
                                             GtkWidget* widget,
                                             const gchar* style_name)
{
	GnomePieColor * self = NULL;
	GtkStyleContext* ctx = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	GdkRGBA color = {0};
	GtkStyleContext* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	gboolean _tmp4_;
	GdkRGBA _tmp9_;
	g_return_val_if_fail (widget != NULL, NULL);
	g_return_val_if_fail (style_name != NULL, NULL);
	_tmp0_ = gtk_widget_get_style_context (widget);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	_tmp4_ = gtk_style_context_lookup_color (_tmp2_, style_name, &_tmp3_);
	color = _tmp3_;
	if (!_tmp4_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = g_strconcat ("Failed to get style color for widget style \"", style_name, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, "\"!", NULL);
		_tmp8_ = _tmp7_;
		g_warning ("color.vala:93: %s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	_tmp9_ = color;
	self = (GnomePieColor*) gnome_pie_color_construct_from_gdk (object_type, &_tmp9_);
	_g_object_unref0 (ctx);
	return self;
}

GnomePieColor*
gnome_pie_color_new_from_widget_style (GtkWidget* widget,
                                       const gchar* style_name)
{
	return gnome_pie_color_construct_from_widget_style (GNOME_PIE_TYPE_COLOR, widget, style_name);
}

GnomePieColor*
gnome_pie_color_construct_from_string (GType object_type,
                                       const gchar* hex_string)
{
	GnomePieColor * self = NULL;
	GdkRGBA color = {0};
	GdkRGBA _tmp0_;
	g_return_val_if_fail (hex_string != NULL, NULL);
	memset (&color, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&color, hex_string);
	_tmp0_ = color;
	self = (GnomePieColor*) gnome_pie_color_construct_from_gdk (object_type, &_tmp0_);
	return self;
}

GnomePieColor*
gnome_pie_color_new_from_string (const gchar* hex_string)
{
	return gnome_pie_color_construct_from_string (GNOME_PIE_TYPE_COLOR, hex_string);
}

GnomePieColor*
gnome_pie_color_construct_from_icon (GType object_type,
                                     GnomePieImage* icon)
{
	GnomePieColor * self = NULL;
	guchar* data = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	guchar* _tmp2_;
	gint data_length1;
	gint _data_size_;
	guint width = 0U;
	cairo_surface_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	guint height = 0U;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp6_;
	guint row_bytes = 0U;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	gdouble total = 0.0;
	gdouble rtotal = 0.0;
	gdouble gtotal = 0.0;
	gdouble btotal = 0.0;
	gfloat _tmp21_;
	gfloat _tmp22_;
	g_return_val_if_fail (icon != NULL, NULL);
	_tmp0_ = gnome_pie_image_get_surface (icon);
	_tmp1_ = _tmp0_;
	_tmp2_ = cairo_image_surface_get_data (_tmp1_);
	data = _tmp2_;
	data_length1 = -1;
	_data_size_ = data_length1;
	_tmp3_ = gnome_pie_image_get_surface (icon);
	_tmp4_ = _tmp3_;
	width = (guint) cairo_image_surface_get_width (_tmp4_);
	_tmp5_ = gnome_pie_image_get_surface (icon);
	_tmp6_ = _tmp5_;
	height = (guint) cairo_image_surface_get_height (_tmp6_);
	_tmp7_ = gnome_pie_image_get_surface (icon);
	_tmp8_ = _tmp7_;
	row_bytes = (guint) cairo_image_surface_get_stride (_tmp8_);
	total = 0.0;
	rtotal = 0.0;
	gtotal = 0.0;
	btotal = 0.0;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				if (!_tmp9_) {
					guint _tmp10_;
					i = i + 1;
					_tmp10_ = i;
				}
				_tmp9_ = FALSE;
				if (!(i < width)) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp11_ = FALSE;
						_tmp11_ = TRUE;
						while (TRUE) {
							guint pixel = 0U;
							gdouble b = 0.0;
							guchar* _tmp13_;
							gint _tmp13__length1;
							guchar _tmp14_;
							gdouble g = 0.0;
							guchar* _tmp15_;
							gint _tmp15__length1;
							guchar _tmp16_;
							gdouble r = 0.0;
							guchar* _tmp17_;
							gint _tmp17__length1;
							guchar _tmp18_;
							gdouble a = 0.0;
							guchar* _tmp19_;
							gint _tmp19__length1;
							guchar _tmp20_;
							gdouble saturation = 0.0;
							gdouble relevance = 0.0;
							if (!_tmp11_) {
								guint _tmp12_;
								j = j + 1;
								_tmp12_ = j;
							}
							_tmp11_ = FALSE;
							if (!(j < height)) {
								break;
							}
							pixel = (j * row_bytes) + (i * 4);
							_tmp13_ = data;
							_tmp13__length1 = data_length1;
							_tmp14_ = _tmp13_[pixel + 0];
							b = _tmp14_ / 255.0;
							_tmp15_ = data;
							_tmp15__length1 = data_length1;
							_tmp16_ = _tmp15_[pixel + 1];
							g = _tmp16_ / 255.0;
							_tmp17_ = data;
							_tmp17__length1 = data_length1;
							_tmp18_ = _tmp17_[pixel + 2];
							r = _tmp18_ / 255.0;
							_tmp19_ = data;
							_tmp19__length1 = data_length1;
							_tmp20_ = _tmp19_[pixel + 3];
							a = _tmp20_ / 255.0;
							saturation = fmax (r, fmax (g, b)) - fmin (r, fmin (g, b));
							relevance = 0.1 + ((0.9 * a) * saturation);
							rtotal += r * relevance;
							gtotal += g * relevance;
							btotal += b * relevance;
							total += relevance;
						}
					}
				}
			}
		}
	}
	self = (GnomePieColor*) gnome_pie_color_construct_from_rgb (object_type, (gfloat) (rtotal / total), (gfloat) (gtotal / total), (gfloat) (btotal / total));
	_tmp21_ = gnome_pie_color_get_s (self);
	_tmp22_ = _tmp21_;
	if (_tmp22_ > 0.15f) {
		gnome_pie_color_set_s (self, 0.65f);
	}
	gnome_pie_color_set_v (self, 1.0f);
	return self;
}

GnomePieColor*
gnome_pie_color_new_from_icon (GnomePieImage* icon)
{
	return gnome_pie_color_construct_from_icon (GNOME_PIE_TYPE_COLOR, icon);
}

gchar*
gnome_pie_color_to_hex_string (GnomePieColor* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("#%02X%02X%02X", (guint) ((gint) (self->priv->_r * 255)), (guint) ((gint) (self->priv->_g * 255)), (guint) ((gint) (self->priv->_b * 255)));
	result = _tmp0_;
	return result;
}

void
gnome_pie_color_invert (GnomePieColor* self)
{
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gnome_pie_color_get_h (self);
	_tmp1_ = _tmp0_;
	gnome_pie_color_set_h (self, _tmp1_ + 180.0f);
	_tmp2_ = gnome_pie_color_get_v (self);
	_tmp3_ = _tmp2_;
	gnome_pie_color_set_v (self, 1.0f - _tmp3_);
}

static void
gnome_pie_color_setHSV (GnomePieColor* self,
                        gfloat hue,
                        gfloat saturation,
                        gfloat val)
{
	gint i = 0;
	gfloat f = 0.0F;
	g_return_if_fail (self != NULL);
	if (saturation == ((gfloat) 0)) {
		gnome_pie_color_set_r (self, val);
		gnome_pie_color_set_g (self, val);
		gnome_pie_color_set_b (self, val);
		return;
	}
	hue = fmodf (hue, (gfloat) 360);
	hue = hue / 60;
	i = (gint) floorf (hue);
	f = hue - i;
	switch (i) {
		case 0:
		{
			gnome_pie_color_set_r (self, val);
			gnome_pie_color_set_g (self, val * (1.0f - (saturation * (1.0f - f))));
			gnome_pie_color_set_b (self, val * (1.0f - saturation));
			break;
		}
		case 1:
		{
			gnome_pie_color_set_r (self, val * (1.0f - (saturation * f)));
			gnome_pie_color_set_g (self, val);
			gnome_pie_color_set_b (self, val * (1.0f - saturation));
			break;
		}
		case 2:
		{
			gnome_pie_color_set_r (self, val * (1.0f - saturation));
			gnome_pie_color_set_g (self, val);
			gnome_pie_color_set_b (self, val * (1.0f - (saturation * (1.0f - f))));
			break;
		}
		case 3:
		{
			gnome_pie_color_set_r (self, val * (1.0f - saturation));
			gnome_pie_color_set_g (self, val * (1.0f - (saturation * f)));
			gnome_pie_color_set_b (self, val);
			break;
		}
		case 4:
		{
			gnome_pie_color_set_r (self, val * (1.0f - (saturation * (1.0f - f))));
			gnome_pie_color_set_g (self, val * (1.0f - saturation));
			gnome_pie_color_set_b (self, val);
			break;
		}
		default:
		{
			gnome_pie_color_set_r (self, val);
			gnome_pie_color_set_g (self, val * (1.0f - saturation));
			gnome_pie_color_set_b (self, val * (1.0f - (saturation * f)));
			break;
		}
	}
}

gfloat
gnome_pie_color_get_r (GnomePieColor* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_r;
	return result;
}

void
gnome_pie_color_set_r (GnomePieColor* self,
                       gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value > 1.0f) {
		self->priv->_r = 1.0f;
	} else {
		if (value < 0.0f) {
			self->priv->_r = 0.0f;
		} else {
			self->priv->_r = value;
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gnome_pie_color_properties[GNOME_PIE_COLOR_R_PROPERTY]);
}

gfloat
gnome_pie_color_get_g (GnomePieColor* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_g;
	return result;
}

void
gnome_pie_color_set_g (GnomePieColor* self,
                       gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value > 1.0f) {
		self->priv->_g = 1.0f;
	} else {
		if (value < 0.0f) {
			self->priv->_g = 0.0f;
		} else {
			self->priv->_g = value;
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gnome_pie_color_properties[GNOME_PIE_COLOR_G_PROPERTY]);
}

gfloat
gnome_pie_color_get_b (GnomePieColor* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_b;
	return result;
}

void
gnome_pie_color_set_b (GnomePieColor* self,
                       gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value > 1.0f) {
		self->priv->_b = 1.0f;
	} else {
		if (value < 0.0f) {
			self->priv->_b = 0.0f;
		} else {
			self->priv->_b = value;
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gnome_pie_color_properties[GNOME_PIE_COLOR_B_PROPERTY]);
}

gfloat
gnome_pie_color_get_a (GnomePieColor* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_a;
	return result;
}

void
gnome_pie_color_set_a (GnomePieColor* self,
                       gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value > 1.0f) {
		self->priv->_a = 1.0f;
	} else {
		if (value < 0.0f) {
			self->priv->_a = 0.0f;
		} else {
			self->priv->_a = value;
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gnome_pie_color_properties[GNOME_PIE_COLOR_A_PROPERTY]);
}

gfloat
gnome_pie_color_get_h (GnomePieColor* self)
{
	gfloat result;
	gfloat _tmp0_;
	gfloat _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = gnome_pie_color_get_s (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ > 0.0f) {
		gfloat maxi = 0.0F;
		gfloat _tmp2_;
		gfloat _tmp3_;
		gfloat _tmp4_;
		gfloat _tmp5_;
		gfloat _tmp6_;
		gfloat _tmp7_;
		gfloat mini = 0.0F;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gfloat _tmp10_;
		gfloat _tmp11_;
		gfloat _tmp12_;
		gfloat _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		_tmp2_ = gnome_pie_color_get_r (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gnome_pie_color_get_g (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = gnome_pie_color_get_b (self);
		_tmp7_ = _tmp6_;
		maxi = fmaxf (fmaxf (_tmp3_, _tmp5_), _tmp7_);
		_tmp8_ = gnome_pie_color_get_r (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = gnome_pie_color_get_g (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = gnome_pie_color_get_b (self);
		_tmp13_ = _tmp12_;
		mini = fminf (fminf (_tmp9_, _tmp11_), _tmp13_);
		_tmp14_ = gnome_pie_color_get_r (self);
		_tmp15_ = _tmp14_;
		if (maxi == _tmp15_) {
			gfloat _tmp16_;
			gfloat _tmp17_;
			gfloat _tmp18_;
			gfloat _tmp19_;
			_tmp16_ = gnome_pie_color_get_g (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = gnome_pie_color_get_b (self);
			_tmp19_ = _tmp18_;
			result = fmodf ((60.0f * ((_tmp17_ - _tmp19_) / (maxi - mini))) + 360.0f, 360.0f);
			return result;
		} else {
			gfloat _tmp20_;
			gfloat _tmp21_;
			_tmp20_ = gnome_pie_color_get_g (self);
			_tmp21_ = _tmp20_;
			if (maxi == _tmp21_) {
				gfloat _tmp22_;
				gfloat _tmp23_;
				gfloat _tmp24_;
				gfloat _tmp25_;
				_tmp22_ = gnome_pie_color_get_b (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = gnome_pie_color_get_r (self);
				_tmp25_ = _tmp24_;
				result = fmodf ((60.0f * (2.0f + ((_tmp23_ - _tmp25_) / (maxi - mini)))) + 360.0f, 360.0f);
				return result;
			} else {
				gfloat _tmp26_;
				gfloat _tmp27_;
				gfloat _tmp28_;
				gfloat _tmp29_;
				_tmp26_ = gnome_pie_color_get_r (self);
				_tmp27_ = _tmp26_;
				_tmp28_ = gnome_pie_color_get_g (self);
				_tmp29_ = _tmp28_;
				result = fmodf ((60.0f * (4.0f + ((_tmp27_ - _tmp29_) / (maxi - mini)))) + 360.0f, 360.0f);
				return result;
			}
		}
	} else {
		result = 0.0f;
		return result;
	}
}

void
gnome_pie_color_set_h (GnomePieColor* self,
                       gfloat value)
{
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gnome_pie_color_get_s (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gnome_pie_color_get_v (self);
	_tmp3_ = _tmp2_;
	gnome_pie_color_setHSV (self, value, _tmp1_, _tmp3_);
	g_object_notify_by_pspec ((GObject *) self, gnome_pie_color_properties[GNOME_PIE_COLOR_H_PROPERTY]);
}

gfloat
gnome_pie_color_get_s (GnomePieColor* self)
{
	gfloat result;
	gfloat _tmp0_;
	gfloat _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = gnome_pie_color_get_v (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0.0f) {
		result = 0.0f;
		return result;
	} else {
		gfloat _tmp2_;
		gfloat _tmp3_;
		gfloat _tmp4_;
		gfloat _tmp5_;
		gfloat _tmp6_;
		gfloat _tmp7_;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gfloat _tmp10_;
		gfloat _tmp11_;
		_tmp2_ = gnome_pie_color_get_v (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = gnome_pie_color_get_r (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = gnome_pie_color_get_g (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = gnome_pie_color_get_b (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = gnome_pie_color_get_v (self);
		_tmp11_ = _tmp10_;
		result = (_tmp3_ - fminf (fminf (_tmp5_, _tmp7_), _tmp9_)) / _tmp11_;
		return result;
	}
}

void
gnome_pie_color_set_s (GnomePieColor* self,
                       gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value > 1.0f) {
		gfloat _tmp0_;
		gfloat _tmp1_;
		gfloat _tmp2_;
		gfloat _tmp3_;
		_tmp0_ = gnome_pie_color_get_h (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gnome_pie_color_get_v (self);
		_tmp3_ = _tmp2_;
		gnome_pie_color_setHSV (self, _tmp1_, 1.0f, _tmp3_);
	} else {
		if (value < 0.0f) {
			gfloat _tmp4_;
			gfloat _tmp5_;
			gfloat _tmp6_;
			gfloat _tmp7_;
			_tmp4_ = gnome_pie_color_get_h (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = gnome_pie_color_get_v (self);
			_tmp7_ = _tmp6_;
			gnome_pie_color_setHSV (self, _tmp5_, 0.0f, _tmp7_);
		} else {
			gfloat _tmp8_;
			gfloat _tmp9_;
			gfloat _tmp10_;
			gfloat _tmp11_;
			_tmp8_ = gnome_pie_color_get_h (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = gnome_pie_color_get_v (self);
			_tmp11_ = _tmp10_;
			gnome_pie_color_setHSV (self, _tmp9_, value, _tmp11_);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gnome_pie_color_properties[GNOME_PIE_COLOR_S_PROPERTY]);
}

gfloat
gnome_pie_color_get_v (GnomePieColor* self)
{
	gfloat result;
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = gnome_pie_color_get_r (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gnome_pie_color_get_g (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gnome_pie_color_get_b (self);
	_tmp5_ = _tmp4_;
	result = fmaxf (fmaxf (_tmp1_, _tmp3_), _tmp5_);
	return result;
}

void
gnome_pie_color_set_v (GnomePieColor* self,
                       gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value > ((gfloat) 1)) {
		gfloat _tmp0_;
		gfloat _tmp1_;
		gfloat _tmp2_;
		gfloat _tmp3_;
		_tmp0_ = gnome_pie_color_get_h (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gnome_pie_color_get_s (self);
		_tmp3_ = _tmp2_;
		gnome_pie_color_setHSV (self, _tmp1_, _tmp3_, 1.0f);
	} else {
		if (value < ((gfloat) 0)) {
			gfloat _tmp4_;
			gfloat _tmp5_;
			gfloat _tmp6_;
			gfloat _tmp7_;
			_tmp4_ = gnome_pie_color_get_h (self);
			_tmp5_ = _tmp4_;
			_tmp6_ = gnome_pie_color_get_s (self);
			_tmp7_ = _tmp6_;
			gnome_pie_color_setHSV (self, _tmp5_, _tmp7_, 0.0f);
		} else {
			gfloat _tmp8_;
			gfloat _tmp9_;
			gfloat _tmp10_;
			gfloat _tmp11_;
			_tmp8_ = gnome_pie_color_get_h (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = gnome_pie_color_get_s (self);
			_tmp11_ = _tmp10_;
			gnome_pie_color_setHSV (self, _tmp9_, _tmp11_, value);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, gnome_pie_color_properties[GNOME_PIE_COLOR_V_PROPERTY]);
}

static void
gnome_pie_color_class_init (GnomePieColorClass * klass,
                            gpointer klass_data)
{
	gnome_pie_color_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GnomePieColor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gnome_pie_color_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gnome_pie_color_set_property;
	G_OBJECT_CLASS (klass)->finalize = gnome_pie_color_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_COLOR_R_PROPERTY, gnome_pie_color_properties[GNOME_PIE_COLOR_R_PROPERTY] = g_param_spec_float ("r", "r", "r", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_COLOR_G_PROPERTY, gnome_pie_color_properties[GNOME_PIE_COLOR_G_PROPERTY] = g_param_spec_float ("g", "g", "g", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_COLOR_B_PROPERTY, gnome_pie_color_properties[GNOME_PIE_COLOR_B_PROPERTY] = g_param_spec_float ("b", "b", "b", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_COLOR_A_PROPERTY, gnome_pie_color_properties[GNOME_PIE_COLOR_A_PROPERTY] = g_param_spec_float ("a", "a", "a", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_COLOR_H_PROPERTY, gnome_pie_color_properties[GNOME_PIE_COLOR_H_PROPERTY] = g_param_spec_float ("h", "h", "h", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_COLOR_S_PROPERTY, gnome_pie_color_properties[GNOME_PIE_COLOR_S_PROPERTY] = g_param_spec_float ("s", "s", "s", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_PIE_COLOR_V_PROPERTY, gnome_pie_color_properties[GNOME_PIE_COLOR_V_PROPERTY] = g_param_spec_float ("v", "v", "v", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gnome_pie_color_instance_init (GnomePieColor * self,
                               gpointer klass)
{
	self->priv = gnome_pie_color_get_instance_private (self);
}

static void
gnome_pie_color_finalize (GObject * obj)
{
	GnomePieColor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_PIE_TYPE_COLOR, GnomePieColor);
	G_OBJECT_CLASS (gnome_pie_color_parent_class)->finalize (obj);
}

static GType
gnome_pie_color_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GnomePieColorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_pie_color_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomePieColor), 0, (GInstanceInitFunc) gnome_pie_color_instance_init, NULL };
	GType gnome_pie_color_type_id;
	gnome_pie_color_type_id = g_type_register_static (G_TYPE_OBJECT, "GnomePieColor", &g_define_type_info, 0);
	GnomePieColor_private_offset = g_type_add_instance_private (gnome_pie_color_type_id, sizeof (GnomePieColorPrivate));
	return gnome_pie_color_type_id;
}

GType
gnome_pie_color_get_type (void)
{
	static volatile gsize gnome_pie_color_type_id__once = 0;
	if (g_once_init_enter (&gnome_pie_color_type_id__once)) {
		GType gnome_pie_color_type_id;
		gnome_pie_color_type_id = gnome_pie_color_get_type_once ();
		g_once_init_leave (&gnome_pie_color_type_id__once, gnome_pie_color_type_id);
	}
	return gnome_pie_color_type_id__once;
}

static void
_vala_gnome_pie_color_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GnomePieColor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_COLOR, GnomePieColor);
	switch (property_id) {
		case GNOME_PIE_COLOR_R_PROPERTY:
		g_value_set_float (value, gnome_pie_color_get_r (self));
		break;
		case GNOME_PIE_COLOR_G_PROPERTY:
		g_value_set_float (value, gnome_pie_color_get_g (self));
		break;
		case GNOME_PIE_COLOR_B_PROPERTY:
		g_value_set_float (value, gnome_pie_color_get_b (self));
		break;
		case GNOME_PIE_COLOR_A_PROPERTY:
		g_value_set_float (value, gnome_pie_color_get_a (self));
		break;
		case GNOME_PIE_COLOR_H_PROPERTY:
		g_value_set_float (value, gnome_pie_color_get_h (self));
		break;
		case GNOME_PIE_COLOR_S_PROPERTY:
		g_value_set_float (value, gnome_pie_color_get_s (self));
		break;
		case GNOME_PIE_COLOR_V_PROPERTY:
		g_value_set_float (value, gnome_pie_color_get_v (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gnome_pie_color_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GnomePieColor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GNOME_PIE_TYPE_COLOR, GnomePieColor);
	switch (property_id) {
		case GNOME_PIE_COLOR_R_PROPERTY:
		gnome_pie_color_set_r (self, g_value_get_float (value));
		break;
		case GNOME_PIE_COLOR_G_PROPERTY:
		gnome_pie_color_set_g (self, g_value_get_float (value));
		break;
		case GNOME_PIE_COLOR_B_PROPERTY:
		gnome_pie_color_set_b (self, g_value_get_float (value));
		break;
		case GNOME_PIE_COLOR_A_PROPERTY:
		gnome_pie_color_set_a (self, g_value_get_float (value));
		break;
		case GNOME_PIE_COLOR_H_PROPERTY:
		gnome_pie_color_set_h (self, g_value_get_float (value));
		break;
		case GNOME_PIE_COLOR_S_PROPERTY:
		gnome_pie_color_set_s (self, g_value_get_float (value));
		break;
		case GNOME_PIE_COLOR_V_PROPERTY:
		gnome_pie_color_set_v (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

