/* contacts-avatar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-avatar.vala, do not modify */

/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <adwaita.h>
#include <glib-object.h>
#include <folks/folks.h>
#include "contactscore.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_AVATAR (contacts_avatar_get_type ())
#define CONTACTS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatar))
#define CONTACTS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))
#define CONTACTS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_AVATAR))
#define CONTACTS_IS_AVATAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_AVATAR))
#define CONTACTS_AVATAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_AVATAR, ContactsAvatarClass))

typedef struct _ContactsAvatar ContactsAvatar;
typedef struct _ContactsAvatarClass ContactsAvatarClass;
typedef struct _ContactsAvatarPrivate ContactsAvatarPrivate;
enum  {
	CONTACTS_AVATAR_0_PROPERTY,
	CONTACTS_AVATAR_INDIVIDUAL_PROPERTY,
	CONTACTS_AVATAR_CONTACT_PROPERTY,
	CONTACTS_AVATAR_AVATAR_SIZE_PROPERTY,
	CONTACTS_AVATAR_NUM_PROPERTIES
};
static GParamSpec* contacts_avatar_properties[CONTACTS_AVATAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ContactsAvatarLoadAvatarData ContactsAvatarLoadAvatarData;

struct _ContactsAvatar {
	AdwBin parent_instance;
	ContactsAvatarPrivate * priv;
};

struct _ContactsAvatarClass {
	AdwBinClass parent_class;
};

struct _ContactsAvatarPrivate {
	FolksIndividual* _individual;
	ContactsContact* _contact;
	gint _avatar_size;
};

struct _Block7Data {
	int _ref_count_;
	ContactsAvatar* self;
	ContactsAvatarChunk* avatar_chunk;
};

struct _ContactsAvatarLoadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsAvatar* self;
	GLoadableIcon* icon;
	GInputStream* stream;
	gint _tmp0_;
	GInputStream* _tmp1_;
	GdkPixbuf* pixbuf;
	GInputStream* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkTexture* _tmp7_;
	GdkTexture* _tmp8_;
	GError* e;
	FolksIndividual* _tmp9_;
	FolksIndividual* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	GError* _inner_error0_;
};

static gint ContactsAvatar_private_offset;
static gpointer contacts_avatar_parent_class = NULL;

VALA_EXTERN GType contacts_avatar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsAvatar, g_object_unref)
VALA_EXTERN ContactsAvatar* contacts_avatar_new (gint size,
                                     FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct (GType object_type,
                                           gint size,
                                           FolksIndividual* individual);
VALA_EXTERN ContactsAvatar* contacts_avatar_new_for_contact (gint size,
                                                 ContactsContact* contact);
VALA_EXTERN ContactsAvatar* contacts_avatar_construct_for_contact (GType object_type,
                                                       gint size,
                                                       ContactsContact* contact);
static void contacts_avatar_update_individual (ContactsAvatar* self);
VALA_EXTERN ContactsContact* contacts_avatar_get_contact (ContactsAvatar* self);
VALA_EXTERN FolksIndividual* contacts_avatar_get_individual (ContactsAvatar* self);
static gchar* contacts_avatar_find_display_name (ContactsAvatar* self);
static void contacts_avatar_load_avatar (ContactsAvatar* self,
                                  GLoadableIcon* icon,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
static void contacts_avatar_load_avatar_finish (ContactsAvatar* self,
                                         GAsyncResult* _res_);
static void contacts_avatar_update_contact (ContactsAvatar* self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda7_ (Block7Data* _data7_,
                 GObject* obj,
                 GParamSpec* pspec);
static void ___lambda7__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void contacts_avatar_load_avatar_data_free (gpointer _data);
static gboolean contacts_avatar_load_avatar_co (ContactsAvatarLoadAvatarData* _data_);
VALA_EXTERN void contacts_avatar_set_paintable (ContactsAvatar* self,
                                    GdkPaintable* paintable);
VALA_EXTERN gint contacts_avatar_get_avatar_size (ContactsAvatar* self);
static void contacts_avatar_load_avatar_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_);
static const gchar* contacts_avatar_look_up_alias_for_display_name (ContactsAvatar* self,
                                                             FolksPersona* p);
static gchar* contacts_avatar_look_up_name_details_for_display_name (ContactsAvatar* self,
                                                              FolksPersona* p);
VALA_EXTERN void contacts_avatar_set_individual (ContactsAvatar* self,
                                     FolksIndividual* value);
VALA_EXTERN void contacts_avatar_set_contact (ContactsAvatar* self,
                                  ContactsContact* value);
VALA_EXTERN void contacts_avatar_set_avatar_size (ContactsAvatar* self,
                                      gint value);
static GObject * contacts_avatar_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void contacts_avatar_finalize (GObject * obj);
static GType contacts_avatar_get_type_once (void);
static void _vala_contacts_avatar_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_contacts_avatar_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
contacts_avatar_get_instance_private (ContactsAvatar* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsAvatar_private_offset);
}

ContactsAvatar*
contacts_avatar_construct (GType object_type,
                           gint size,
                           FolksIndividual* individual)
{
	ContactsAvatar * self = NULL;
	self = (ContactsAvatar*) g_object_new (object_type, "avatar-size", size, "individual", individual, NULL);
	return self;
}

ContactsAvatar*
contacts_avatar_new (gint size,
                     FolksIndividual* individual)
{
	return contacts_avatar_construct (CONTACTS_TYPE_AVATAR, size, individual);
}

ContactsAvatar*
contacts_avatar_construct_for_contact (GType object_type,
                                       gint size,
                                       ContactsContact* contact)
{
	ContactsAvatar * self = NULL;
	g_return_val_if_fail (contact != NULL, NULL);
	self = (ContactsAvatar*) g_object_new (object_type, "avatar-size", size, "contact", contact, NULL);
	return self;
}

ContactsAvatar*
contacts_avatar_new_for_contact (gint size,
                                 ContactsContact* contact)
{
	return contacts_avatar_construct_for_contact (CONTACTS_TYPE_AVATAR, size, contact);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_avatar_update_individual (ContactsAvatar* self)
{
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	gboolean show_initials = FALSE;
	FolksIndividual* _tmp3_;
	FolksIndividual* _tmp4_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
	const gchar* _tmp16_;
	GLoadableIcon* _tmp17_ = NULL;
	FolksIndividual* _tmp18_;
	FolksIndividual* _tmp19_;
	GLoadableIcon* icon = NULL;
	GLoadableIcon* _tmp24_;
	GLoadableIcon* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = contacts_avatar_get_contact (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		return;
	}
	_tmp2_ = g_strdup ("");
	name = _tmp2_;
	show_initials = FALSE;
	_tmp3_ = contacts_avatar_get_individual (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = contacts_avatar_find_display_name (self);
		_g_free0 (name);
		name = _tmp5_;
		_tmp6_ = name;
		if (g_strcmp0 (_tmp6_, "") == 0) {
			FolksIndividual* _tmp7_;
			FolksIndividual* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = contacts_avatar_get_individual (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = folks_individual_get_display_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (name);
			name = _tmp11_;
		} else {
			show_initials = TRUE;
		}
	}
	_tmp12_ = adw_bin_get_child ((AdwBin*) self);
	_tmp13_ = _tmp12_;
	adw_avatar_set_show_initials (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, adw_avatar_get_type (), AdwAvatar), show_initials);
	_tmp14_ = adw_bin_get_child ((AdwBin*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = name;
	adw_avatar_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, adw_avatar_get_type (), AdwAvatar), _tmp16_);
	_tmp18_ = contacts_avatar_get_individual (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		FolksIndividual* _tmp20_;
		FolksIndividual* _tmp21_;
		GLoadableIcon* _tmp22_;
		GLoadableIcon* _tmp23_;
		_tmp20_ = contacts_avatar_get_individual (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp17_ = _tmp23_;
	} else {
		_tmp17_ = NULL;
	}
	_tmp24_ = _g_object_ref0 (_tmp17_);
	icon = _tmp24_;
	_tmp25_ = icon;
	contacts_avatar_load_avatar (self, _tmp25_, NULL, NULL);
	_g_object_unref0 (icon);
	_g_free0 (name);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ContactsAvatar* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda7_ (Block7Data* _data7_,
            GObject* obj,
            GParamSpec* pspec)
{
	ContactsAvatar* self;
	ContactsAvatarChunk* _tmp0_;
	GLoadableIcon* _tmp1_;
	GLoadableIcon* _tmp2_;
	self = _data7_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = _data7_->avatar_chunk;
	_tmp1_ = contacts_avatar_chunk_get_avatar (_tmp0_);
	_tmp2_ = _tmp1_;
	contacts_avatar_load_avatar (self, _tmp2_, NULL, NULL);
}

static void
___lambda7__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda7_ (self, _sender, pspec);
}

static void
contacts_avatar_update_contact (ContactsAvatar* self)
{
	Block7Data* _data7_;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	gboolean show_initials = FALSE;
	ContactsContact* _tmp3_;
	ContactsContact* _tmp4_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkWidget* _tmp14_;
	GtkWidget* _tmp15_;
	const gchar* _tmp16_;
	ContactsChunk* chunk = NULL;
	ContactsContact* _tmp17_;
	ContactsContact* _tmp18_;
	ContactsChunk* _tmp19_;
	ContactsChunk* _tmp20_;
	ContactsChunk* _tmp21_;
	ContactsChunk* _tmp26_;
	ContactsAvatarChunk* _tmp27_;
	ContactsAvatarChunk* _tmp28_;
	GLoadableIcon* _tmp29_;
	GLoadableIcon* _tmp30_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = contacts_avatar_get_individual (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return;
	}
	_tmp2_ = g_strdup ("");
	name = _tmp2_;
	show_initials = FALSE;
	_tmp3_ = contacts_avatar_get_contact (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ContactsContact* _tmp5_;
		ContactsContact* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = contacts_avatar_get_contact (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = contacts_contact_fetch_name (_tmp6_);
		_g_free0 (name);
		name = _tmp7_;
		_tmp8_ = name;
		if (_tmp8_ == NULL) {
			ContactsContact* _tmp9_;
			ContactsContact* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = contacts_avatar_get_contact (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = contacts_contact_fetch_display_name (_tmp10_);
			_g_free0 (name);
			name = _tmp11_;
		} else {
			show_initials = TRUE;
		}
	}
	_tmp12_ = adw_bin_get_child ((AdwBin*) self);
	_tmp13_ = _tmp12_;
	adw_avatar_set_show_initials (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, adw_avatar_get_type (), AdwAvatar), show_initials);
	_tmp14_ = adw_bin_get_child ((AdwBin*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = name;
	adw_avatar_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, adw_avatar_get_type (), AdwAvatar), _tmp16_);
	_tmp17_ = contacts_avatar_get_contact (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = contacts_contact_get_most_relevant_chunk (_tmp18_, "avatar", TRUE);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	chunk = _tmp20_;
	_tmp21_ = chunk;
	if (_tmp21_ == NULL) {
		ContactsContact* _tmp22_;
		ContactsContact* _tmp23_;
		ContactsChunk* _tmp24_;
		ContactsChunk* _tmp25_;
		_tmp22_ = contacts_avatar_get_contact (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = contacts_contact_create_chunk (_tmp23_, "avatar", NULL);
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_g_object_unref0 (chunk);
		chunk = _tmp25_;
	}
	_tmp26_ = chunk;
	_data7_->avatar_chunk = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, CONTACTS_TYPE_AVATAR_CHUNK, ContactsAvatarChunk);
	_tmp27_ = _data7_->avatar_chunk;
	g_signal_connect_data ((GObject*) _tmp27_, "notify::avatar", (GCallback) ___lambda7__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp28_ = _data7_->avatar_chunk;
	_tmp29_ = contacts_avatar_chunk_get_avatar (_tmp28_);
	_tmp30_ = _tmp29_;
	contacts_avatar_load_avatar (self, _tmp30_, NULL, NULL);
	_g_object_unref0 (chunk);
	_g_free0 (name);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
contacts_avatar_load_avatar_data_free (gpointer _data)
{
	ContactsAvatarLoadAvatarData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->icon);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsAvatarLoadAvatarData, _data_);
}

static void
contacts_avatar_load_avatar (ContactsAvatar* self,
                             GLoadableIcon* icon,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	ContactsAvatarLoadAvatarData* _data_;
	ContactsAvatar* _tmp0_;
	GLoadableIcon* _tmp1_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsAvatarLoadAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_avatar_load_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (icon);
	_g_object_unref0 (_data_->icon);
	_data_->icon = _tmp1_;
	contacts_avatar_load_avatar_co (_data_);
}

static void
contacts_avatar_load_avatar_finish (ContactsAvatar* self,
                                    GAsyncResult* _res_)
{
	ContactsAvatarLoadAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_avatar_load_avatar_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_)
{
	ContactsAvatarLoadAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_avatar_load_avatar_co (_data_);
}

static gboolean
contacts_avatar_load_avatar_co (ContactsAvatarLoadAvatarData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->icon == NULL) {
		contacts_avatar_set_paintable (_data_->self, NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp0_ = _data_->self->priv->_avatar_size;
		_data_->_state_ = 1;
		g_loadable_icon_load_async (_data_->icon, _data_->_tmp0_, NULL, contacts_avatar_load_avatar_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_loadable_icon_load_finish (_data_->icon, _data_->_res_, NULL, &_data_->_inner_error0_);
		_data_->stream = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->stream;
		_data_->_tmp3_ = _data_->self->priv->_avatar_size;
		_data_->_tmp4_ = _data_->self->priv->_avatar_size;
		_data_->_state_ = 2;
		gdk_pixbuf_new_from_stream_at_scale_async (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, TRUE, NULL, contacts_avatar_load_avatar_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp5_ = (GdkPixbuf*) gdk_pixbuf_new_from_stream_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->pixbuf = _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->stream);
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = _data_->pixbuf;
		_data_->_tmp7_ = gdk_texture_new_for_pixbuf (_data_->_tmp6_);
		_data_->_tmp8_ = _data_->_tmp7_;
		contacts_avatar_set_paintable (_data_->self, (GdkPaintable*) _data_->_tmp8_);
		_g_object_unref0 (_data_->_tmp8_);
		_g_object_unref0 (_data_->pixbuf);
		_g_object_unref0 (_data_->stream);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp9_ = contacts_avatar_get_individual (_data_->self);
		_data_->_tmp10_ = _data_->_tmp9_;
		_data_->_tmp11_ = folks_individual_get_display_name (_data_->_tmp10_);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = _data_->e;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_warning ("contacts-avatar.vala:121: Couldn't load avatar of '%s': %s", _data_->_tmp12_, _data_->_tmp14_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

/**
   * Manually set the avatar to the given paintable,
   * even if the contact has an avatar.
   */
void
contacts_avatar_set_paintable (ContactsAvatar* self,
                               GdkPaintable* paintable)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = adw_bin_get_child ((AdwBin*) self);
	_tmp1_ = _tmp0_;
	adw_avatar_set_custom_image (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, adw_avatar_get_type (), AdwAvatar), paintable);
}

static gchar*
contacts_avatar_find_display_name (ContactsAvatar* self)
{
	FolksPersona* primary_persona = NULL;
	const gchar* alias = NULL;
	FolksPersona* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp43_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	primary_persona = NULL;
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		FolksIndividual* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = contacts_avatar_get_individual (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = folks_individual_get_personas (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_p_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksPersona* _tmp8_;
			FolksPersonaStore* _tmp9_;
			FolksPersonaStore* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp5_ = _p_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = folks_persona_get_store (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = folks_persona_store_get_is_primary_store (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				FolksPersona* _tmp13_;
				_tmp13_ = p;
				primary_persona = _tmp13_;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp14_ = primary_persona;
	_tmp15_ = contacts_avatar_look_up_alias_for_display_name (self, _tmp14_);
	alias = _tmp15_;
	_tmp16_ = alias;
	if (g_strcmp0 (_tmp16_, "") != 0) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = alias;
		_tmp18_ = g_strdup (_tmp17_);
		result = _tmp18_;
		return result;
	}
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp19_;
		FolksIndividual* _tmp20_;
		GeeSet* _tmp21_;
		GeeSet* _tmp22_;
		GeeIterator* _tmp23_;
		_tmp19_ = contacts_avatar_get_individual (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = folks_individual_get_personas (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) _tmp22_);
		_p_it = _tmp23_;
		while (TRUE) {
			GeeIterator* _tmp24_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp25_;
			gpointer _tmp26_;
			FolksPersona* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp24_ = _p_it;
			if (!gee_iterator_next (_tmp24_)) {
				break;
			}
			_tmp25_ = _p_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			p = (FolksPersona*) _tmp26_;
			_tmp27_ = p;
			_tmp28_ = contacts_avatar_look_up_alias_for_display_name (self, _tmp27_);
			alias = _tmp28_;
			_tmp29_ = alias;
			if (g_strcmp0 (_tmp29_, "") != 0) {
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp30_ = alias;
				_tmp31_ = g_strdup (_tmp30_);
				result = _tmp31_;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp32_;
		FolksIndividual* _tmp33_;
		GeeSet* _tmp34_;
		GeeSet* _tmp35_;
		GeeIterator* _tmp36_;
		_tmp32_ = contacts_avatar_get_individual (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = folks_individual_get_personas (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = gee_iterable_iterator ((GeeIterable*) _tmp35_);
		_p_it = _tmp36_;
		while (TRUE) {
			GeeIterator* _tmp37_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp38_;
			gpointer _tmp39_;
			gchar* name = NULL;
			FolksPersona* _tmp40_;
			gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp37_ = _p_it;
			if (!gee_iterator_next (_tmp37_)) {
				break;
			}
			_tmp38_ = _p_it;
			_tmp39_ = gee_iterator_get (_tmp38_);
			p = (FolksPersona*) _tmp39_;
			_tmp40_ = p;
			_tmp41_ = contacts_avatar_look_up_name_details_for_display_name (self, _tmp40_);
			name = _tmp41_;
			_tmp42_ = name;
			if (g_strcmp0 (_tmp42_, "") != 0) {
				result = name;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_free0 (name);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp43_ = g_strdup ("");
	result = _tmp43_;
	return result;
}

static const gchar*
contacts_avatar_look_up_alias_for_display_name (ContactsAvatar* self,
                                                FolksPersona* p)
{
	FolksAliasDetails* a = NULL;
	gboolean _tmp0_ = FALSE;
	FolksAliasDetails* _tmp1_;
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	a = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_ALIAS_DETAILS) ? ((FolksAliasDetails*) p) : NULL;
	_tmp1_ = a;
	if (_tmp1_ != NULL) {
		FolksAliasDetails* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = a;
		_tmp3_ = folks_alias_details_get_alias (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		FolksAliasDetails* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = a;
		_tmp6_ = folks_alias_details_get_alias (_tmp5_);
		_tmp7_ = _tmp6_;
		result = _tmp7_;
		return result;
	}
	result = "";
	return result;
}

static gchar*
contacts_avatar_look_up_name_details_for_display_name (ContactsAvatar* self,
                                                       FolksPersona* p)
{
	FolksNameDetails* n = NULL;
	FolksNameDetails* _tmp0_;
	gchar* _tmp26_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	n = G_TYPE_CHECK_INSTANCE_TYPE (p, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) p) : NULL;
	_tmp0_ = n;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		FolksNameDetails* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = n;
		_tmp3_ = folks_name_details_get_full_name (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			FolksNameDetails* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = n;
			_tmp6_ = folks_name_details_get_full_name (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp1_ = g_strcmp0 (_tmp7_, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			FolksNameDetails* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp8_ = n;
			_tmp9_ = folks_name_details_get_full_name (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup (_tmp10_);
			result = _tmp11_;
			return result;
		} else {
			FolksNameDetails* _tmp12_;
			FolksStructuredName* _tmp13_;
			FolksStructuredName* _tmp14_;
			_tmp12_ = n;
			_tmp13_ = folks_name_details_get_structured_name (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				FolksNameDetails* _tmp15_;
				FolksStructuredName* _tmp16_;
				FolksStructuredName* _tmp17_;
				gchar* _tmp18_;
				_tmp15_ = n;
				_tmp16_ = folks_name_details_get_structured_name (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = folks_structured_name_to_string (_tmp17_);
				result = _tmp18_;
				return result;
			} else {
				FolksNameDetails* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp19_ = n;
				_tmp20_ = folks_name_details_get_nickname (_tmp19_);
				_tmp21_ = _tmp20_;
				if (g_strcmp0 (_tmp21_, "") != 0) {
					FolksNameDetails* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					gchar* _tmp25_;
					_tmp22_ = n;
					_tmp23_ = folks_name_details_get_nickname (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strdup (_tmp24_);
					result = _tmp25_;
					return result;
				}
			}
		}
	}
	_tmp26_ = g_strdup ("");
	result = _tmp26_;
	return result;
}

FolksIndividual*
contacts_avatar_get_individual (ContactsAvatar* self)
{
	FolksIndividual* result;
	FolksIndividual* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_individual;
	result = _tmp0_;
	return result;
}

void
contacts_avatar_set_individual (ContactsAvatar* self,
                                FolksIndividual* value)
{
	FolksIndividual* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual;
	if (_tmp0_ == value) {
		return;
	}
	self->priv->_individual = value;
	contacts_avatar_update_individual (self);
	g_object_notify_by_pspec ((GObject *) self, contacts_avatar_properties[CONTACTS_AVATAR_INDIVIDUAL_PROPERTY]);
}

ContactsContact*
contacts_avatar_get_contact (ContactsAvatar* self)
{
	ContactsContact* result;
	ContactsContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contact;
	result = _tmp0_;
	return result;
}

void
contacts_avatar_set_contact (ContactsAvatar* self,
                             ContactsContact* value)
{
	ContactsContact* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_contact;
	if (_tmp0_ == value) {
		return;
	}
	self->priv->_contact = value;
	contacts_avatar_update_contact (self);
	g_object_notify_by_pspec ((GObject *) self, contacts_avatar_properties[CONTACTS_AVATAR_CONTACT_PROPERTY]);
}

gint
contacts_avatar_get_avatar_size (ContactsAvatar* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_avatar_size;
	return result;
}

void
contacts_avatar_set_avatar_size (ContactsAvatar* self,
                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_avatar_get_avatar_size (self);
	if (old_value != value) {
		self->priv->_avatar_size = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_avatar_properties[CONTACTS_AVATAR_AVATAR_SIZE_PROPERTY]);
	}
}

static GObject *
contacts_avatar_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsAvatar * self;
	gint _tmp0_;
	AdwAvatar* _tmp1_;
	AdwAvatar* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	parent_class = G_OBJECT_CLASS (contacts_avatar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR, ContactsAvatar);
	_tmp0_ = self->priv->_avatar_size;
	_tmp1_ = (AdwAvatar*) adw_avatar_new (_tmp0_, "", FALSE);
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = adw_bin_get_child ((AdwBin*) self);
	_tmp4_ = _tmp3_;
	g_object_bind_property_with_closures ((GObject*) self, "avatar-size", (GObject*) _tmp4_, "size", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	return obj;
}

static void
contacts_avatar_class_init (ContactsAvatarClass * klass,
                            gpointer klass_data)
{
	contacts_avatar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsAvatar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_avatar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_avatar_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_avatar_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_avatar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_AVATAR_INDIVIDUAL_PROPERTY, contacts_avatar_properties[CONTACTS_AVATAR_INDIVIDUAL_PROPERTY] = g_param_spec_object ("individual", "individual", "individual", FOLKS_TYPE_INDIVIDUAL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_AVATAR_CONTACT_PROPERTY, contacts_avatar_properties[CONTACTS_AVATAR_CONTACT_PROPERTY] = g_param_spec_object ("contact", "contact", "contact", CONTACTS_TYPE_CONTACT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_AVATAR_AVATAR_SIZE_PROPERTY, contacts_avatar_properties[CONTACTS_AVATAR_AVATAR_SIZE_PROPERTY] = g_param_spec_int ("avatar-size", "avatar-size", "avatar-size", G_MININT, G_MAXINT, 48, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
contacts_avatar_instance_init (ContactsAvatar * self,
                               gpointer klass)
{
	self->priv = contacts_avatar_get_instance_private (self);
	self->priv->_individual = NULL;
	self->priv->_contact = NULL;
	self->priv->_avatar_size = 48;
}

static void
contacts_avatar_finalize (GObject * obj)
{
	ContactsAvatar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_AVATAR, ContactsAvatar);
	G_OBJECT_CLASS (contacts_avatar_parent_class)->finalize (obj);
}

/**
 * The Avatar of a Contact is responsible for showing an {@link Folks.Individual}'s
 * avatar, or a fallback if it's not available.
 */
 G_GNUC_NO_INLINE static GType
contacts_avatar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsAvatarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_avatar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAvatar), 0, (GInstanceInitFunc) contacts_avatar_instance_init, NULL };
	GType contacts_avatar_type_id;
	contacts_avatar_type_id = g_type_register_static (adw_bin_get_type (), "ContactsAvatar", &g_define_type_info, 0);
	ContactsAvatar_private_offset = g_type_add_instance_private (contacts_avatar_type_id, sizeof (ContactsAvatarPrivate));
	return contacts_avatar_type_id;
}

GType
contacts_avatar_get_type (void)
{
	static volatile gsize contacts_avatar_type_id__once = 0;
	if (g_once_init_enter (&contacts_avatar_type_id__once)) {
		GType contacts_avatar_type_id;
		contacts_avatar_type_id = contacts_avatar_get_type_once ();
		g_once_init_leave (&contacts_avatar_type_id__once, contacts_avatar_type_id);
	}
	return contacts_avatar_type_id__once;
}

static void
_vala_contacts_avatar_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	ContactsAvatar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_AVATAR, ContactsAvatar);
	switch (property_id) {
		case CONTACTS_AVATAR_INDIVIDUAL_PROPERTY:
		g_value_set_object (value, contacts_avatar_get_individual (self));
		break;
		case CONTACTS_AVATAR_CONTACT_PROPERTY:
		g_value_set_object (value, contacts_avatar_get_contact (self));
		break;
		case CONTACTS_AVATAR_AVATAR_SIZE_PROPERTY:
		g_value_set_int (value, contacts_avatar_get_avatar_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_avatar_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	ContactsAvatar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_AVATAR, ContactsAvatar);
	switch (property_id) {
		case CONTACTS_AVATAR_INDIVIDUAL_PROPERTY:
		contacts_avatar_set_individual (self, g_value_get_object (value));
		break;
		case CONTACTS_AVATAR_CONTACT_PROPERTY:
		contacts_avatar_set_contact (self, g_value_get_object (value));
		break;
		case CONTACTS_AVATAR_AVATAR_SIZE_PROPERTY:
		contacts_avatar_set_avatar_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

