/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "gdbo-modem.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringVariantFunc)
       (void *data1,
        const gchar *arg_name,
        GVariant *arg_value,
        void *data2);
  _GDbusCodegenMarshalVoid_StringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_variant (param_values + 2),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_property,
        GVariant *arg_value,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_variant (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_number,
        const gchar *arg_hide_callerid,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_string (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        guint arg_memory_location,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_uint (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_call,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.ofono.Modem
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GDBOModem
 * @title: GDBOModem
 * @short_description: Generated C code for the org.ofono.Modem D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ofono-Modem.top_of_page">org.ofono.Modem</link> D-Bus interface in C.
 */

enum
{
  GDBO__MODEM_PROPERTY_CHANGED,
};

static unsigned GDBO__MODEM_SIGNALS[1] = { 0 };

/* ---- Introspection data for org.ofono.Modem ---- */

static const _ExtendedGDBusArgInfo _gdbo_modem_method_info_get_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_modem_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_gdbo_modem_method_info_get_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_modem_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_gdbo_modem_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_modem_method_info_set_property_IN_ARG_property =
{
  {
    -1,
    (gchar *) "property",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_modem_method_info_set_property_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_modem_method_info_set_property_IN_ARG_pointers[] =
{
  &_gdbo_modem_method_info_set_property_IN_ARG_property.parent_struct,
  &_gdbo_modem_method_info_set_property_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_modem_method_info_set_property =
{
  {
    -1,
    (gchar *) "SetProperty",
    (GDBusArgInfo **) &_gdbo_modem_method_info_set_property_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-property",
  FALSE
};

static const GDBusMethodInfo * const _gdbo_modem_method_info_pointers[] =
{
  &_gdbo_modem_method_info_get_properties.parent_struct,
  &_gdbo_modem_method_info_set_property.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdbo_modem_signal_info_property_changed_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_modem_signal_info_property_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_modem_signal_info_property_changed_ARG_pointers[] =
{
  &_gdbo_modem_signal_info_property_changed_ARG_name.parent_struct,
  &_gdbo_modem_signal_info_property_changed_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdbo_modem_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_gdbo_modem_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const GDBusSignalInfo * const _gdbo_modem_signal_info_pointers[] =
{
  &_gdbo_modem_signal_info_property_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdbo_modem_interface_info =
{
  {
    -1,
    (gchar *) "org.ofono.Modem",
    (GDBusMethodInfo **) &_gdbo_modem_method_info_pointers,
    (GDBusSignalInfo **) &_gdbo_modem_signal_info_pointers,
    NULL,
    NULL
  },
  "modem",
};


/**
 * gdbo_modem_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ofono-Modem.top_of_page">org.ofono.Modem</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdbo_modem_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdbo_modem_interface_info.parent_struct;
}

/**
 * gdbo_modem_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GDBOModem interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdbo_modem_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdbo_modem_signal_marshal_property_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_modem_method_marshal_get_properties (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_modem_method_marshal_set_property (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GDBOModem:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Modem.top_of_page">org.ofono.Modem</link>.
 */

/**
 * GDBOModemIface:
 * @parent_iface: The parent interface.
 * @handle_get_properties: Handler for the #GDBOModem::handle-get-properties signal.
 * @handle_set_property: Handler for the #GDBOModem::handle-set-property signal.
 * @property_changed: Handler for the #GDBOModem::property-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Modem.top_of_page">org.ofono.Modem</link>.
 */

typedef GDBOModemIface GDBOModemInterface;
G_DEFINE_INTERFACE (GDBOModem, gdbo_modem, G_TYPE_OBJECT)

static void
gdbo_modem_default_init (GDBOModemIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GDBOModem::handle-get-properties:
   * @object: A #GDBOModem.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-Modem.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_modem_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOModemIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_modem_method_marshal_get_properties,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOModem::handle-set-property:
   * @object: A #GDBOModem.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_property: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-Modem.SetProperty">SetProperty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_modem_complete_set_property() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-property",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOModemIface, handle_set_property),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_modem_method_marshal_set_property,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject signals for received D-Bus signals: */
  /**
   * GDBOModem::property-changed:
   * @object: A #GDBOModem.
   * @arg_name: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-Modem.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDBO__MODEM_SIGNALS[GDBO__MODEM_PROPERTY_CHANGED] =
    g_signal_new ("property-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GDBOModemIface, property_changed),
      NULL,
      NULL,
      gdbo_modem_signal_marshal_property_changed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

}

/**
 * gdbo_modem_emit_property_changed:
 * @object: A #GDBOModem.
 * @arg_name: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-Modem.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
gdbo_modem_emit_property_changed (
    GDBOModem *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  g_signal_emit (object, GDBO__MODEM_SIGNALS[GDBO__MODEM_PROPERTY_CHANGED], 0, arg_name, arg_value);
}

/**
 * gdbo_modem_call_get_properties:
 * @proxy: A #GDBOModemProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-Modem.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_modem_call_get_properties_finish() to get the result of the operation.
 *
 * See gdbo_modem_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_modem_call_get_properties (
    GDBOModem *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_modem_call_get_properties_finish:
 * @proxy: A #GDBOModemProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_modem_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_modem_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_modem_call_get_properties_finish (
    GDBOModem *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_modem_call_get_properties_sync:
 * @proxy: A #GDBOModemProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-Modem.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_modem_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_modem_call_get_properties_sync (
    GDBOModem *proxy,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_modem_call_set_property:
 * @proxy: A #GDBOModemProxy.
 * @arg_property: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-Modem.SetProperty">SetProperty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_modem_call_set_property_finish() to get the result of the operation.
 *
 * See gdbo_modem_call_set_property_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_modem_call_set_property (
    GDBOModem *proxy,
    const gchar *arg_property,
    GVariant *arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetProperty",
    g_variant_new ("(s@v)",
                   arg_property,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_modem_call_set_property_finish:
 * @proxy: A #GDBOModemProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_modem_call_set_property().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_modem_call_set_property().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_modem_call_set_property_finish (
    GDBOModem *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_modem_call_set_property_sync:
 * @proxy: A #GDBOModemProxy.
 * @arg_property: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-Modem.SetProperty">SetProperty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_modem_call_set_property() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_modem_call_set_property_sync (
    GDBOModem *proxy,
    const gchar *arg_property,
    GVariant *arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetProperty",
    g_variant_new ("(s@v)",
                   arg_property,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_modem_complete_get_properties:
 * @object: A #GDBOModem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-Modem.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_modem_complete_get_properties (
    GDBOModem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   properties));
}

/**
 * gdbo_modem_complete_set_property:
 * @object: A #GDBOModem.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-Modem.SetProperty">SetProperty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_modem_complete_set_property (
    GDBOModem *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * GDBOModemProxy:
 *
 * The #GDBOModemProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GDBOModemProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GDBOModemProxy.
 */

struct _GDBOModemProxyPrivate
{
  GData *qdata;
};

static void gdbo_modem_proxy_iface_init (GDBOModemIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GDBOModemProxy, gdbo_modem_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GDBOModemProxy)
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_MODEM, gdbo_modem_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GDBOModemProxy, gdbo_modem_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_MODEM, gdbo_modem_proxy_iface_init))

#endif
static void
gdbo_modem_proxy_finalize (GObject *object)
{
  GDBOModemProxy *proxy = GDBO_MODEM_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdbo_modem_proxy_parent_class)->finalize (object);
}

static void
gdbo_modem_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdbo_modem_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdbo_modem_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdbo_modem_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDBO_TYPE_MODEM);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDBO_TYPE_MODEM);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdbo_modem_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GDBOModemProxy *proxy = GDBO_MODEM_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_modem_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_modem_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdbo_modem_proxy_init (GDBOModemProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdbo_modem_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDBO_TYPE_MODEM_PROXY, GDBOModemProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdbo_modem_interface_info ());
}

static void
gdbo_modem_proxy_class_init (GDBOModemProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdbo_modem_proxy_finalize;
  gobject_class->get_property = gdbo_modem_proxy_get_property;
  gobject_class->set_property = gdbo_modem_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdbo_modem_proxy_g_signal;
  proxy_class->g_properties_changed = gdbo_modem_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GDBOModemProxyPrivate));
#endif
}

static void
gdbo_modem_proxy_iface_init (GDBOModemIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdbo_modem_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Modem.top_of_page">org.ofono.Modem</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_modem_proxy_new_finish() to get the result of the operation.
 *
 * See gdbo_modem_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdbo_modem_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDBO_TYPE_MODEM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.Modem", NULL);
}

/**
 * gdbo_modem_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_modem_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdbo_modem_proxy_new().
 *
 * Returns: (transfer full) (type GDBOModemProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOModem *
gdbo_modem_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDBO_MODEM (ret);
  else
    return NULL;
}

/**
 * gdbo_modem_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Modem.top_of_page">org.ofono.Modem</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdbo_modem_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GDBOModemProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOModem *
gdbo_modem_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDBO_TYPE_MODEM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.Modem", NULL);
  if (ret != NULL)
    return GDBO_MODEM (ret);
  else
    return NULL;
}


/**
 * gdbo_modem_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdbo_modem_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_modem_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdbo_modem_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdbo_modem_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDBO_TYPE_MODEM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.Modem", NULL);
}

/**
 * gdbo_modem_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_modem_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdbo_modem_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GDBOModemProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOModem *
gdbo_modem_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDBO_MODEM (ret);
  else
    return NULL;
}

/**
 * gdbo_modem_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdbo_modem_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdbo_modem_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GDBOModemProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOModem *
gdbo_modem_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDBO_TYPE_MODEM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.Modem", NULL);
  if (ret != NULL)
    return GDBO_MODEM (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GDBOModemSkeleton:
 *
 * The #GDBOModemSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GDBOModemSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GDBOModemSkeleton.
 */

struct _GDBOModemSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdbo_modem_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GDBOModemSkeleton *skeleton = GDBO_MODEM_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDBO_TYPE_MODEM);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDBO_TYPE_MODEM);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdbo_modem_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GDBOModemSkeleton *skeleton = GDBO_MODEM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_modem_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdbo_modem_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GDBOModemSkeleton *skeleton = GDBO_MODEM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_modem_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdbo_modem_skeleton_vtable =
{
  _gdbo_modem_skeleton_handle_method_call,
  _gdbo_modem_skeleton_handle_get_property,
  _gdbo_modem_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdbo_modem_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdbo_modem_interface_info ();
}

static GDBusInterfaceVTable *
gdbo_modem_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdbo_modem_skeleton_vtable;
}

static GVariant *
gdbo_modem_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GDBOModemSkeleton *skeleton = GDBO_MODEM_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdbo_modem_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdbo_modem_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdbo_modem_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdbo_modem_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.Modem", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdbo_modem_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdbo_modem_on_signal_property_changed (
    GDBOModem *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  GDBOModemSkeleton *skeleton = GDBO_MODEM_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_name,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.Modem", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdbo_modem_skeleton_iface_init (GDBOModemIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GDBOModemSkeleton, gdbo_modem_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GDBOModemSkeleton)
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_MODEM, gdbo_modem_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GDBOModemSkeleton, gdbo_modem_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_MODEM, gdbo_modem_skeleton_iface_init))

#endif
static void
gdbo_modem_skeleton_finalize (GObject *object)
{
  GDBOModemSkeleton *skeleton = GDBO_MODEM_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdbo_modem_skeleton_parent_class)->finalize (object);
}

static void
gdbo_modem_skeleton_init (GDBOModemSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdbo_modem_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDBO_TYPE_MODEM_SKELETON, GDBOModemSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdbo_modem_skeleton_class_init (GDBOModemSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdbo_modem_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdbo_modem_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdbo_modem_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdbo_modem_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdbo_modem_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GDBOModemSkeletonPrivate));
#endif
}

static void
gdbo_modem_skeleton_iface_init (GDBOModemIface *iface)
{
  iface->property_changed = _gdbo_modem_on_signal_property_changed;
}

/**
 * gdbo_modem_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ofono-Modem.top_of_page">org.ofono.Modem</link>.
 *
 * Returns: (transfer full) (type GDBOModemSkeleton): The skeleton object.
 */
GDBOModem *
gdbo_modem_skeleton_new (void)
{
  return GDBO_MODEM (g_object_new (GDBO_TYPE_MODEM_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.ofono.VoiceCallManager
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:GDBOVoiceCallManager
 * @title: GDBOVoiceCallManager
 * @short_description: Generated C code for the org.ofono.VoiceCallManager D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-ofono-VoiceCallManager.top_of_page">org.ofono.VoiceCallManager</link> D-Bus interface in C.
 */

enum
{
  GDBO__VOICE_CALL_MANAGER_FORWARDED,
  GDBO__VOICE_CALL_MANAGER_BARRING_ACTIVE,
  GDBO__VOICE_CALL_MANAGER_PROPERTY_CHANGED,
  GDBO__VOICE_CALL_MANAGER_CALL_ADDED,
  GDBO__VOICE_CALL_MANAGER_CALL_REMOVED,
};

static unsigned GDBO__VOICE_CALL_MANAGER_SIGNALS[5] = { 0 };

/* ---- Introspection data for org.ofono.VoiceCallManager ---- */

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_get_properties_OUT_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_get_properties_OUT_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_get_properties_OUT_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_get_properties =
{
  {
    -1,
    (gchar *) "GetProperties",
    NULL,
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_get_properties_OUT_ARG_pointers,
    NULL
  },
  "handle-get-properties",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_dial_IN_ARG_number =
{
  {
    -1,
    (gchar *) "number",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_dial_IN_ARG_hide_callerid =
{
  {
    -1,
    (gchar *) "hide_callerid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_dial_IN_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_dial_IN_ARG_number.parent_struct,
  &_gdbo_voice_call_manager_method_info_dial_IN_ARG_hide_callerid.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_dial_OUT_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_dial_OUT_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_dial_OUT_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_dial =
{
  {
    -1,
    (gchar *) "Dial",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_dial_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_dial_OUT_ARG_pointers,
    NULL
  },
  "handle-dial",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_dial_last =
{
  {
    -1,
    (gchar *) "DialLast",
    NULL,
    NULL,
    NULL
  },
  "handle-dial-last",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_dial_memory_IN_ARG_memory_location =
{
  {
    -1,
    (gchar *) "memory_location",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_dial_memory_IN_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_dial_memory_IN_ARG_memory_location.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_dial_memory =
{
  {
    -1,
    (gchar *) "DialMemory",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_dial_memory_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-dial-memory",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_transfer =
{
  {
    -1,
    (gchar *) "Transfer",
    NULL,
    NULL,
    NULL
  },
  "handle-transfer",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_swap_calls =
{
  {
    -1,
    (gchar *) "SwapCalls",
    NULL,
    NULL,
    NULL
  },
  "handle-swap-calls",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_release_and_answer =
{
  {
    -1,
    (gchar *) "ReleaseAndAnswer",
    NULL,
    NULL,
    NULL
  },
  "handle-release-and-answer",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_release_and_swap =
{
  {
    -1,
    (gchar *) "ReleaseAndSwap",
    NULL,
    NULL,
    NULL
  },
  "handle-release-and-swap",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_hold_and_answer =
{
  {
    -1,
    (gchar *) "HoldAndAnswer",
    NULL,
    NULL,
    NULL
  },
  "handle-hold-and-answer",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_hangup_all =
{
  {
    -1,
    (gchar *) "HangupAll",
    NULL,
    NULL,
    NULL
  },
  "handle-hangup-all",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_private_chat_IN_ARG_call =
{
  {
    -1,
    (gchar *) "call",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_private_chat_IN_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_private_chat_IN_ARG_call.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_private_chat_OUT_ARG_calls =
{
  {
    -1,
    (gchar *) "calls",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_private_chat_OUT_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_private_chat_OUT_ARG_calls.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_private_chat =
{
  {
    -1,
    (gchar *) "PrivateChat",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_private_chat_IN_ARG_pointers,
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_private_chat_OUT_ARG_pointers,
    NULL
  },
  "handle-private-chat",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_create_multiparty_OUT_ARG_calls =
{
  {
    -1,
    (gchar *) "calls",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_create_multiparty_OUT_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_create_multiparty_OUT_ARG_calls.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_create_multiparty =
{
  {
    -1,
    (gchar *) "CreateMultiparty",
    NULL,
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_create_multiparty_OUT_ARG_pointers,
    NULL
  },
  "handle-create-multiparty",
  FALSE
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_hangup_multiparty =
{
  {
    -1,
    (gchar *) "HangupMultiparty",
    NULL,
    NULL,
    NULL
  },
  "handle-hangup-multiparty",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_send_tones_IN_ARG_SendTones =
{
  {
    -1,
    (gchar *) "SendTones",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_send_tones_IN_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_send_tones_IN_ARG_SendTones.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_send_tones =
{
  {
    -1,
    (gchar *) "SendTones",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_send_tones_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-send-tones",
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_method_info_get_calls_OUT_ARG_calls_with_properties =
{
  {
    -1,
    (gchar *) "calls_with_properties",
    (gchar *) "a(oa{sv})",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_method_info_get_calls_OUT_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_get_calls_OUT_ARG_calls_with_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _gdbo_voice_call_manager_method_info_get_calls =
{
  {
    -1,
    (gchar *) "GetCalls",
    NULL,
    (GDBusArgInfo **) &_gdbo_voice_call_manager_method_info_get_calls_OUT_ARG_pointers,
    NULL
  },
  "handle-get-calls",
  FALSE
};

static const GDBusMethodInfo * const _gdbo_voice_call_manager_method_info_pointers[] =
{
  &_gdbo_voice_call_manager_method_info_get_properties.parent_struct,
  &_gdbo_voice_call_manager_method_info_dial.parent_struct,
  &_gdbo_voice_call_manager_method_info_dial_last.parent_struct,
  &_gdbo_voice_call_manager_method_info_dial_memory.parent_struct,
  &_gdbo_voice_call_manager_method_info_transfer.parent_struct,
  &_gdbo_voice_call_manager_method_info_swap_calls.parent_struct,
  &_gdbo_voice_call_manager_method_info_release_and_answer.parent_struct,
  &_gdbo_voice_call_manager_method_info_release_and_swap.parent_struct,
  &_gdbo_voice_call_manager_method_info_hold_and_answer.parent_struct,
  &_gdbo_voice_call_manager_method_info_hangup_all.parent_struct,
  &_gdbo_voice_call_manager_method_info_private_chat.parent_struct,
  &_gdbo_voice_call_manager_method_info_create_multiparty.parent_struct,
  &_gdbo_voice_call_manager_method_info_hangup_multiparty.parent_struct,
  &_gdbo_voice_call_manager_method_info_send_tones.parent_struct,
  &_gdbo_voice_call_manager_method_info_get_calls.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_signal_info_forwarded_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_signal_info_forwarded_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_signal_info_forwarded_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdbo_voice_call_manager_signal_info_forwarded =
{
  {
    -1,
    (gchar *) "Forwarded",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_signal_info_forwarded_ARG_pointers,
    NULL
  },
  "forwarded"
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_signal_info_barring_active_ARG_type =
{
  {
    -1,
    (gchar *) "type",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_signal_info_barring_active_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_signal_info_barring_active_ARG_type.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdbo_voice_call_manager_signal_info_barring_active =
{
  {
    -1,
    (gchar *) "BarringActive",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_signal_info_barring_active_ARG_pointers,
    NULL
  },
  "barring-active"
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_signal_info_property_changed_ARG_name =
{
  {
    -1,
    (gchar *) "name",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_signal_info_property_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "v",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_signal_info_property_changed_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_signal_info_property_changed_ARG_name.parent_struct,
  &_gdbo_voice_call_manager_signal_info_property_changed_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdbo_voice_call_manager_signal_info_property_changed =
{
  {
    -1,
    (gchar *) "PropertyChanged",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_signal_info_property_changed_ARG_pointers,
    NULL
  },
  "property-changed"
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_signal_info_call_added_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_signal_info_call_added_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_signal_info_call_added_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_signal_info_call_added_ARG_path.parent_struct,
  &_gdbo_voice_call_manager_signal_info_call_added_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdbo_voice_call_manager_signal_info_call_added =
{
  {
    -1,
    (gchar *) "CallAdded",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_signal_info_call_added_ARG_pointers,
    NULL
  },
  "call-added"
};

static const _ExtendedGDBusArgInfo _gdbo_voice_call_manager_signal_info_call_removed_ARG_path =
{
  {
    -1,
    (gchar *) "path",
    (gchar *) "o",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _gdbo_voice_call_manager_signal_info_call_removed_ARG_pointers[] =
{
  &_gdbo_voice_call_manager_signal_info_call_removed_ARG_path.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _gdbo_voice_call_manager_signal_info_call_removed =
{
  {
    -1,
    (gchar *) "CallRemoved",
    (GDBusArgInfo **) &_gdbo_voice_call_manager_signal_info_call_removed_ARG_pointers,
    NULL
  },
  "call-removed"
};

static const GDBusSignalInfo * const _gdbo_voice_call_manager_signal_info_pointers[] =
{
  &_gdbo_voice_call_manager_signal_info_forwarded.parent_struct,
  &_gdbo_voice_call_manager_signal_info_barring_active.parent_struct,
  &_gdbo_voice_call_manager_signal_info_property_changed.parent_struct,
  &_gdbo_voice_call_manager_signal_info_call_added.parent_struct,
  &_gdbo_voice_call_manager_signal_info_call_removed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _gdbo_voice_call_manager_interface_info =
{
  {
    -1,
    (gchar *) "org.ofono.VoiceCallManager",
    (GDBusMethodInfo **) &_gdbo_voice_call_manager_method_info_pointers,
    (GDBusSignalInfo **) &_gdbo_voice_call_manager_signal_info_pointers,
    NULL,
    NULL
  },
  "voice-call-manager",
};


/**
 * gdbo_voice_call_manager_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-ofono-VoiceCallManager.top_of_page">org.ofono.VoiceCallManager</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
gdbo_voice_call_manager_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_gdbo_voice_call_manager_interface_info.parent_struct;
}

/**
 * gdbo_voice_call_manager_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #GDBOVoiceCallManager interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
gdbo_voice_call_manager_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
gdbo_voice_call_manager_signal_marshal_forwarded (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_signal_marshal_barring_active (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_signal_marshal_property_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_signal_marshal_call_added (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_signal_marshal_call_removed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  g_cclosure_marshal_VOID__STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_get_properties (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_dial (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_dial_last (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_dial_memory (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_transfer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_swap_calls (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_release_and_answer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_release_and_swap (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_hold_and_answer (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_hangup_all (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_private_chat (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_create_multiparty (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_hangup_multiparty (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_send_tones (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
gdbo_voice_call_manager_method_marshal_get_calls (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * GDBOVoiceCallManager:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCallManager.top_of_page">org.ofono.VoiceCallManager</link>.
 */

/**
 * GDBOVoiceCallManagerIface:
 * @parent_iface: The parent interface.
 * @handle_create_multiparty: Handler for the #GDBOVoiceCallManager::handle-create-multiparty signal.
 * @handle_dial: Handler for the #GDBOVoiceCallManager::handle-dial signal.
 * @handle_dial_last: Handler for the #GDBOVoiceCallManager::handle-dial-last signal.
 * @handle_dial_memory: Handler for the #GDBOVoiceCallManager::handle-dial-memory signal.
 * @handle_get_calls: Handler for the #GDBOVoiceCallManager::handle-get-calls signal.
 * @handle_get_properties: Handler for the #GDBOVoiceCallManager::handle-get-properties signal.
 * @handle_hangup_all: Handler for the #GDBOVoiceCallManager::handle-hangup-all signal.
 * @handle_hangup_multiparty: Handler for the #GDBOVoiceCallManager::handle-hangup-multiparty signal.
 * @handle_hold_and_answer: Handler for the #GDBOVoiceCallManager::handle-hold-and-answer signal.
 * @handle_private_chat: Handler for the #GDBOVoiceCallManager::handle-private-chat signal.
 * @handle_release_and_answer: Handler for the #GDBOVoiceCallManager::handle-release-and-answer signal.
 * @handle_release_and_swap: Handler for the #GDBOVoiceCallManager::handle-release-and-swap signal.
 * @handle_send_tones: Handler for the #GDBOVoiceCallManager::handle-send-tones signal.
 * @handle_swap_calls: Handler for the #GDBOVoiceCallManager::handle-swap-calls signal.
 * @handle_transfer: Handler for the #GDBOVoiceCallManager::handle-transfer signal.
 * @barring_active: Handler for the #GDBOVoiceCallManager::barring-active signal.
 * @call_added: Handler for the #GDBOVoiceCallManager::call-added signal.
 * @call_removed: Handler for the #GDBOVoiceCallManager::call-removed signal.
 * @forwarded: Handler for the #GDBOVoiceCallManager::forwarded signal.
 * @property_changed: Handler for the #GDBOVoiceCallManager::property-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCallManager.top_of_page">org.ofono.VoiceCallManager</link>.
 */

typedef GDBOVoiceCallManagerIface GDBOVoiceCallManagerInterface;
G_DEFINE_INTERFACE (GDBOVoiceCallManager, gdbo_voice_call_manager, G_TYPE_OBJECT)

static void
gdbo_voice_call_manager_default_init (GDBOVoiceCallManagerIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * GDBOVoiceCallManager::handle-get-properties:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.GetProperties">GetProperties()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_get_properties() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-properties",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_get_properties),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_get_properties,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-dial:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_number: Argument passed by remote caller.
   * @arg_hide_callerid: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.Dial">Dial()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_dial() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-dial",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_dial),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_dial,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRING);

  /**
   * GDBOVoiceCallManager::handle-dial-last:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.DialLast">DialLast()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_dial_last() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-dial-last",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_dial_last),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_dial_last,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-dial-memory:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_memory_location: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.DialMemory">DialMemory()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_dial_memory() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-dial-memory",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_dial_memory),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_dial_memory,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_UINT);

  /**
   * GDBOVoiceCallManager::handle-transfer:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.Transfer">Transfer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_transfer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-transfer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_transfer),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_transfer,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-swap-calls:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.SwapCalls">SwapCalls()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_swap_calls() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-swap-calls",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_swap_calls),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_swap_calls,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-release-and-answer:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.ReleaseAndAnswer">ReleaseAndAnswer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_release_and_answer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-and-answer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_release_and_answer),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_release_and_answer,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-release-and-swap:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.ReleaseAndSwap">ReleaseAndSwap()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_release_and_swap() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release-and-swap",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_release_and_swap),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_release_and_swap,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-hold-and-answer:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HoldAndAnswer">HoldAndAnswer()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_hold_and_answer() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hold-and-answer",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_hold_and_answer),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_hold_and_answer,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-hangup-all:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HangupAll">HangupAll()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_hangup_all() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hangup-all",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_hangup_all),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_hangup_all,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-private-chat:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_call: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.PrivateChat">PrivateChat()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_private_chat() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-private-chat",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_private_chat),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_private_chat,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GDBOVoiceCallManager::handle-create-multiparty:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.CreateMultiparty">CreateMultiparty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_create_multiparty() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-create-multiparty",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_create_multiparty),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_create_multiparty,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-hangup-multiparty:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HangupMultiparty">HangupMultiparty()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_hangup_multiparty() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-hangup-multiparty",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_hangup_multiparty),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_hangup_multiparty,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * GDBOVoiceCallManager::handle-send-tones:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_SendTones: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.SendTones">SendTones()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_send_tones() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-send-tones",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_send_tones),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_send_tones,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * GDBOVoiceCallManager::handle-get-calls:
   * @object: A #GDBOVoiceCallManager.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-ofono-VoiceCallManager.GetCalls">GetCalls()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call gdbo_voice_call_manager_complete_get_calls() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-calls",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, handle_get_calls),
    g_signal_accumulator_true_handled,
    NULL,
      gdbo_voice_call_manager_method_marshal_get_calls,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * GDBOVoiceCallManager::forwarded:
   * @object: A #GDBOVoiceCallManager.
   * @arg_type: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-VoiceCallManager.Forwarded">"Forwarded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_FORWARDED] =
    g_signal_new ("forwarded",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, forwarded),
      NULL,
      NULL,
      gdbo_voice_call_manager_signal_marshal_forwarded,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GDBOVoiceCallManager::barring-active:
   * @object: A #GDBOVoiceCallManager.
   * @arg_type: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-VoiceCallManager.BarringActive">"BarringActive"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_BARRING_ACTIVE] =
    g_signal_new ("barring-active",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, barring_active),
      NULL,
      NULL,
      gdbo_voice_call_manager_signal_marshal_barring_active,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

  /**
   * GDBOVoiceCallManager::property-changed:
   * @object: A #GDBOVoiceCallManager.
   * @arg_name: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-VoiceCallManager.PropertyChanged">"PropertyChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_PROPERTY_CHANGED] =
    g_signal_new ("property-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, property_changed),
      NULL,
      NULL,
      gdbo_voice_call_manager_signal_marshal_property_changed,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GDBOVoiceCallManager::call-added:
   * @object: A #GDBOVoiceCallManager.
   * @arg_path: Argument.
   * @arg_properties: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-VoiceCallManager.CallAdded">"CallAdded"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_CALL_ADDED] =
    g_signal_new ("call-added",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, call_added),
      NULL,
      NULL,
      gdbo_voice_call_manager_signal_marshal_call_added,
      G_TYPE_NONE,
      2, G_TYPE_STRING, G_TYPE_VARIANT);

  /**
   * GDBOVoiceCallManager::call-removed:
   * @object: A #GDBOVoiceCallManager.
   * @arg_path: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-ofono-VoiceCallManager.CallRemoved">"CallRemoved"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_CALL_REMOVED] =
    g_signal_new ("call-removed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (GDBOVoiceCallManagerIface, call_removed),
      NULL,
      NULL,
      gdbo_voice_call_manager_signal_marshal_call_removed,
      G_TYPE_NONE,
      1, G_TYPE_STRING);

}

/**
 * gdbo_voice_call_manager_emit_forwarded:
 * @object: A #GDBOVoiceCallManager.
 * @arg_type: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-VoiceCallManager.Forwarded">"Forwarded"</link> D-Bus signal.
 */
void
gdbo_voice_call_manager_emit_forwarded (
    GDBOVoiceCallManager *object,
    const gchar *arg_type)
{
  g_signal_emit (object, GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_FORWARDED], 0, arg_type);
}

/**
 * gdbo_voice_call_manager_emit_barring_active:
 * @object: A #GDBOVoiceCallManager.
 * @arg_type: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-VoiceCallManager.BarringActive">"BarringActive"</link> D-Bus signal.
 */
void
gdbo_voice_call_manager_emit_barring_active (
    GDBOVoiceCallManager *object,
    const gchar *arg_type)
{
  g_signal_emit (object, GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_BARRING_ACTIVE], 0, arg_type);
}

/**
 * gdbo_voice_call_manager_emit_property_changed:
 * @object: A #GDBOVoiceCallManager.
 * @arg_name: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-VoiceCallManager.PropertyChanged">"PropertyChanged"</link> D-Bus signal.
 */
void
gdbo_voice_call_manager_emit_property_changed (
    GDBOVoiceCallManager *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  g_signal_emit (object, GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_PROPERTY_CHANGED], 0, arg_name, arg_value);
}

/**
 * gdbo_voice_call_manager_emit_call_added:
 * @object: A #GDBOVoiceCallManager.
 * @arg_path: Argument to pass with the signal.
 * @arg_properties: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-VoiceCallManager.CallAdded">"CallAdded"</link> D-Bus signal.
 */
void
gdbo_voice_call_manager_emit_call_added (
    GDBOVoiceCallManager *object,
    const gchar *arg_path,
    GVariant *arg_properties)
{
  g_signal_emit (object, GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_CALL_ADDED], 0, arg_path, arg_properties);
}

/**
 * gdbo_voice_call_manager_emit_call_removed:
 * @object: A #GDBOVoiceCallManager.
 * @arg_path: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-ofono-VoiceCallManager.CallRemoved">"CallRemoved"</link> D-Bus signal.
 */
void
gdbo_voice_call_manager_emit_call_removed (
    GDBOVoiceCallManager *object,
    const gchar *arg_path)
{
  g_signal_emit (object, GDBO__VOICE_CALL_MANAGER_SIGNALS[GDBO__VOICE_CALL_MANAGER_CALL_REMOVED], 0, arg_path);
}

/**
 * gdbo_voice_call_manager_call_get_properties:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.GetProperties">GetProperties()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_get_properties_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_get_properties_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_get_properties (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_get_properties_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_get_properties().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_get_properties().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_get_properties_finish (
    GDBOVoiceCallManager *proxy,
    GVariant **out_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_get_properties_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @out_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.GetProperties">GetProperties()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_get_properties() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_get_properties_sync (
    GDBOVoiceCallManager *proxy,
    GVariant **out_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetProperties",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a{sv})",
                 out_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_dial:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @arg_number: Argument to pass with the method invocation.
 * @arg_hide_callerid: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.Dial">Dial()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_dial_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_dial_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_dial (
    GDBOVoiceCallManager *proxy,
    const gchar *arg_number,
    const gchar *arg_hide_callerid,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Dial",
    g_variant_new ("(ss)",
                   arg_number,
                   arg_hide_callerid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_dial_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_dial().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_dial().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_dial_finish (
    GDBOVoiceCallManager *proxy,
    gchar **out_path,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_dial_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @arg_number: Argument to pass with the method invocation.
 * @arg_hide_callerid: Argument to pass with the method invocation.
 * @out_path: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.Dial">Dial()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_dial() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_dial_sync (
    GDBOVoiceCallManager *proxy,
    const gchar *arg_number,
    const gchar *arg_hide_callerid,
    gchar **out_path,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Dial",
    g_variant_new ("(ss)",
                   arg_number,
                   arg_hide_callerid),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(o)",
                 out_path);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_dial_last:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.DialLast">DialLast()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_dial_last_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_dial_last_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_dial_last (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DialLast",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_dial_last_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_dial_last().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_dial_last().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_dial_last_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_dial_last_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.DialLast">DialLast()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_dial_last() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_dial_last_sync (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DialLast",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_dial_memory:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @arg_memory_location: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.DialMemory">DialMemory()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_dial_memory_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_dial_memory_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_dial_memory (
    GDBOVoiceCallManager *proxy,
    guint arg_memory_location,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "DialMemory",
    g_variant_new ("(u)",
                   arg_memory_location),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_dial_memory_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_dial_memory().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_dial_memory().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_dial_memory_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_dial_memory_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @arg_memory_location: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.DialMemory">DialMemory()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_dial_memory() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_dial_memory_sync (
    GDBOVoiceCallManager *proxy,
    guint arg_memory_location,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "DialMemory",
    g_variant_new ("(u)",
                   arg_memory_location),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_transfer:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.Transfer">Transfer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_transfer_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_transfer_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_transfer (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Transfer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_transfer_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_transfer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_transfer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_transfer_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_transfer_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.Transfer">Transfer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_transfer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_transfer_sync (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Transfer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_swap_calls:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.SwapCalls">SwapCalls()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_swap_calls_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_swap_calls_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_swap_calls (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SwapCalls",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_swap_calls_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_swap_calls().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_swap_calls().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_swap_calls_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_swap_calls_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.SwapCalls">SwapCalls()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_swap_calls() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_swap_calls_sync (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SwapCalls",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_release_and_answer:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.ReleaseAndAnswer">ReleaseAndAnswer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_release_and_answer_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_release_and_answer_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_release_and_answer (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseAndAnswer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_release_and_answer_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_release_and_answer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_release_and_answer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_release_and_answer_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_release_and_answer_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.ReleaseAndAnswer">ReleaseAndAnswer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_release_and_answer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_release_and_answer_sync (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseAndAnswer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_release_and_swap:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.ReleaseAndSwap">ReleaseAndSwap()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_release_and_swap_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_release_and_swap_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_release_and_swap (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReleaseAndSwap",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_release_and_swap_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_release_and_swap().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_release_and_swap().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_release_and_swap_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_release_and_swap_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.ReleaseAndSwap">ReleaseAndSwap()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_release_and_swap() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_release_and_swap_sync (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReleaseAndSwap",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_hold_and_answer:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HoldAndAnswer">HoldAndAnswer()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_hold_and_answer_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_hold_and_answer_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_hold_and_answer (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HoldAndAnswer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_hold_and_answer_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_hold_and_answer().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_hold_and_answer().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_hold_and_answer_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_hold_and_answer_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HoldAndAnswer">HoldAndAnswer()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_hold_and_answer() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_hold_and_answer_sync (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HoldAndAnswer",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_hangup_all:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HangupAll">HangupAll()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_hangup_all_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_hangup_all_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_hangup_all (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HangupAll",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_hangup_all_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_hangup_all().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_hangup_all().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_hangup_all_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_hangup_all_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HangupAll">HangupAll()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_hangup_all() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_hangup_all_sync (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HangupAll",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_private_chat:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @arg_call: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.PrivateChat">PrivateChat()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_private_chat_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_private_chat_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_private_chat (
    GDBOVoiceCallManager *proxy,
    const gchar *arg_call,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "PrivateChat",
    g_variant_new ("(o)",
                   arg_call),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_private_chat_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @out_calls: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_private_chat().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_private_chat().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_private_chat_finish (
    GDBOVoiceCallManager *proxy,
    gchar ***out_calls,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_calls);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_private_chat_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @arg_call: Argument to pass with the method invocation.
 * @out_calls: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.PrivateChat">PrivateChat()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_private_chat() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_private_chat_sync (
    GDBOVoiceCallManager *proxy,
    const gchar *arg_call,
    gchar ***out_calls,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "PrivateChat",
    g_variant_new ("(o)",
                   arg_call),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_calls);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_create_multiparty:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.CreateMultiparty">CreateMultiparty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_create_multiparty_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_create_multiparty_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_create_multiparty (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "CreateMultiparty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_create_multiparty_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @out_calls: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_create_multiparty().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_create_multiparty().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_create_multiparty_finish (
    GDBOVoiceCallManager *proxy,
    gchar ***out_calls,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_calls);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_create_multiparty_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @out_calls: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.CreateMultiparty">CreateMultiparty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_create_multiparty() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_create_multiparty_sync (
    GDBOVoiceCallManager *proxy,
    gchar ***out_calls,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "CreateMultiparty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^ao)",
                 out_calls);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_hangup_multiparty:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HangupMultiparty">HangupMultiparty()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_hangup_multiparty_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_hangup_multiparty_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_hangup_multiparty (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "HangupMultiparty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_hangup_multiparty_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_hangup_multiparty().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_hangup_multiparty().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_hangup_multiparty_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_hangup_multiparty_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HangupMultiparty">HangupMultiparty()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_hangup_multiparty() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_hangup_multiparty_sync (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "HangupMultiparty",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_send_tones:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @arg_SendTones: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.SendTones">SendTones()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_send_tones_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_send_tones_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_send_tones (
    GDBOVoiceCallManager *proxy,
    const gchar *arg_SendTones,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SendTones",
    g_variant_new ("(s)",
                   arg_SendTones),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_send_tones_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_send_tones().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_send_tones().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_send_tones_finish (
    GDBOVoiceCallManager *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_send_tones_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @arg_SendTones: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.SendTones">SendTones()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_send_tones() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_send_tones_sync (
    GDBOVoiceCallManager *proxy,
    const gchar *arg_SendTones,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SendTones",
    g_variant_new ("(s)",
                   arg_SendTones),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_get_calls:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.GetCalls">GetCalls()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_call_get_calls_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_call_get_calls_sync() for the synchronous, blocking version of this method.
 */
void
gdbo_voice_call_manager_call_get_calls (
    GDBOVoiceCallManager *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetCalls",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * gdbo_voice_call_manager_call_get_calls_finish:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @out_calls_with_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_call_get_calls().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with gdbo_voice_call_manager_call_get_calls().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_get_calls_finish (
    GDBOVoiceCallManager *proxy,
    GVariant **out_calls_with_properties,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(oa{sv}))",
                 out_calls_with_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_call_get_calls_sync:
 * @proxy: A #GDBOVoiceCallManagerProxy.
 * @out_calls_with_properties: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-ofono-VoiceCallManager.GetCalls">GetCalls()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_call_get_calls() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
gdbo_voice_call_manager_call_get_calls_sync (
    GDBOVoiceCallManager *proxy,
    GVariant **out_calls_with_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetCalls",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(@a(oa{sv}))",
                 out_calls_with_properties);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * gdbo_voice_call_manager_complete_get_properties:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.GetProperties">GetProperties()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_get_properties (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a{sv})",
                   properties));
}

/**
 * gdbo_voice_call_manager_complete_dial:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @path: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.Dial">Dial()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_dial (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *path)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(o)",
                   path));
}

/**
 * gdbo_voice_call_manager_complete_dial_last:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.DialLast">DialLast()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_dial_last (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_dial_memory:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.DialMemory">DialMemory()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_dial_memory (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_transfer:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.Transfer">Transfer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_transfer (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_swap_calls:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.SwapCalls">SwapCalls()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_swap_calls (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_release_and_answer:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.ReleaseAndAnswer">ReleaseAndAnswer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_release_and_answer (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_release_and_swap:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.ReleaseAndSwap">ReleaseAndSwap()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_release_and_swap (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_hold_and_answer:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HoldAndAnswer">HoldAndAnswer()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_hold_and_answer (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_hangup_all:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HangupAll">HangupAll()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_hangup_all (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_private_chat:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @calls: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.PrivateChat">PrivateChat()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_private_chat (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *calls)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   calls));
}

/**
 * gdbo_voice_call_manager_complete_create_multiparty:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @calls: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.CreateMultiparty">CreateMultiparty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_create_multiparty (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *calls)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^ao)",
                   calls));
}

/**
 * gdbo_voice_call_manager_complete_hangup_multiparty:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.HangupMultiparty">HangupMultiparty()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_hangup_multiparty (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_send_tones:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.SendTones">SendTones()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_send_tones (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * gdbo_voice_call_manager_complete_get_calls:
 * @object: A #GDBOVoiceCallManager.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @calls_with_properties: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-ofono-VoiceCallManager.GetCalls">GetCalls()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
gdbo_voice_call_manager_complete_get_calls (
    GDBOVoiceCallManager *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    GVariant *calls_with_properties)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(@a(oa{sv}))",
                   calls_with_properties));
}

/* ------------------------------------------------------------------------ */

/**
 * GDBOVoiceCallManagerProxy:
 *
 * The #GDBOVoiceCallManagerProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GDBOVoiceCallManagerProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GDBOVoiceCallManagerProxy.
 */

struct _GDBOVoiceCallManagerProxyPrivate
{
  GData *qdata;
};

static void gdbo_voice_call_manager_proxy_iface_init (GDBOVoiceCallManagerIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GDBOVoiceCallManagerProxy, gdbo_voice_call_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (GDBOVoiceCallManagerProxy)
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_VOICE_CALL_MANAGER, gdbo_voice_call_manager_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GDBOVoiceCallManagerProxy, gdbo_voice_call_manager_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_VOICE_CALL_MANAGER, gdbo_voice_call_manager_proxy_iface_init))

#endif
static void
gdbo_voice_call_manager_proxy_finalize (GObject *object)
{
  GDBOVoiceCallManagerProxy *proxy = GDBO_VOICE_CALL_MANAGER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (gdbo_voice_call_manager_proxy_parent_class)->finalize (object);
}

static void
gdbo_voice_call_manager_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdbo_voice_call_manager_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
gdbo_voice_call_manager_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_gdbo_voice_call_manager_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], GDBO_TYPE_VOICE_CALL_MANAGER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDBO_TYPE_VOICE_CALL_MANAGER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
gdbo_voice_call_manager_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  GDBOVoiceCallManagerProxy *proxy = GDBO_VOICE_CALL_MANAGER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_voice_call_manager_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_voice_call_manager_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
gdbo_voice_call_manager_proxy_init (GDBOVoiceCallManagerProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = gdbo_voice_call_manager_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, GDBO_TYPE_VOICE_CALL_MANAGER_PROXY, GDBOVoiceCallManagerProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), gdbo_voice_call_manager_interface_info ());
}

static void
gdbo_voice_call_manager_proxy_class_init (GDBOVoiceCallManagerProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = gdbo_voice_call_manager_proxy_finalize;
  gobject_class->get_property = gdbo_voice_call_manager_proxy_get_property;
  gobject_class->set_property = gdbo_voice_call_manager_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = gdbo_voice_call_manager_proxy_g_signal;
  proxy_class->g_properties_changed = gdbo_voice_call_manager_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GDBOVoiceCallManagerProxyPrivate));
#endif
}

static void
gdbo_voice_call_manager_proxy_iface_init (GDBOVoiceCallManagerIface *iface G_GNUC_UNUSED)
{
}

/**
 * gdbo_voice_call_manager_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCallManager.top_of_page">org.ofono.VoiceCallManager</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_proxy_new_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
gdbo_voice_call_manager_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDBO_TYPE_VOICE_CALL_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.VoiceCallManager", NULL);
}

/**
 * gdbo_voice_call_manager_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdbo_voice_call_manager_proxy_new().
 *
 * Returns: (transfer full) (type GDBOVoiceCallManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOVoiceCallManager *
gdbo_voice_call_manager_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDBO_VOICE_CALL_MANAGER (ret);
  else
    return NULL;
}

/**
 * gdbo_voice_call_manager_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCallManager.top_of_page">org.ofono.VoiceCallManager</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GDBOVoiceCallManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOVoiceCallManager *
gdbo_voice_call_manager_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDBO_TYPE_VOICE_CALL_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.ofono.VoiceCallManager", NULL);
  if (ret != NULL)
    return GDBO_VOICE_CALL_MANAGER (ret);
  else
    return NULL;
}


/**
 * gdbo_voice_call_manager_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like gdbo_voice_call_manager_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call gdbo_voice_call_manager_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See gdbo_voice_call_manager_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
gdbo_voice_call_manager_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (GDBO_TYPE_VOICE_CALL_MANAGER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.VoiceCallManager", NULL);
}

/**
 * gdbo_voice_call_manager_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to gdbo_voice_call_manager_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with gdbo_voice_call_manager_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type GDBOVoiceCallManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOVoiceCallManager *
gdbo_voice_call_manager_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return GDBO_VOICE_CALL_MANAGER (ret);
  else
    return NULL;
}

/**
 * gdbo_voice_call_manager_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like gdbo_voice_call_manager_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See gdbo_voice_call_manager_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type GDBOVoiceCallManagerProxy): The constructed proxy object or %NULL if @error is set.
 */
GDBOVoiceCallManager *
gdbo_voice_call_manager_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (GDBO_TYPE_VOICE_CALL_MANAGER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.ofono.VoiceCallManager", NULL);
  if (ret != NULL)
    return GDBO_VOICE_CALL_MANAGER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * GDBOVoiceCallManagerSkeleton:
 *
 * The #GDBOVoiceCallManagerSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * GDBOVoiceCallManagerSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #GDBOVoiceCallManagerSkeleton.
 */

struct _GDBOVoiceCallManagerSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_gdbo_voice_call_manager_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], GDBO_TYPE_VOICE_CALL_MANAGER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, GDBO_TYPE_VOICE_CALL_MANAGER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_gdbo_voice_call_manager_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_voice_call_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_gdbo_voice_call_manager_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_gdbo_voice_call_manager_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _gdbo_voice_call_manager_skeleton_vtable =
{
  _gdbo_voice_call_manager_skeleton_handle_method_call,
  _gdbo_voice_call_manager_skeleton_handle_get_property,
  _gdbo_voice_call_manager_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
gdbo_voice_call_manager_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return gdbo_voice_call_manager_interface_info ();
}

static GDBusInterfaceVTable *
gdbo_voice_call_manager_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_gdbo_voice_call_manager_skeleton_vtable;
}

static GVariant *
gdbo_voice_call_manager_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_gdbo_voice_call_manager_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _gdbo_voice_call_manager_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _gdbo_voice_call_manager_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _gdbo_voice_call_manager_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCallManager", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
gdbo_voice_call_manager_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_gdbo_voice_call_manager_on_signal_forwarded (
    GDBOVoiceCallManager *object,
    const gchar *arg_type)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_type));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCallManager", "Forwarded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdbo_voice_call_manager_on_signal_barring_active (
    GDBOVoiceCallManager *object,
    const gchar *arg_type)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s)",
                   arg_type));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCallManager", "BarringActive",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdbo_voice_call_manager_on_signal_property_changed (
    GDBOVoiceCallManager *object,
    const gchar *arg_name,
    GVariant *arg_value)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(s@v)",
                   arg_name,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCallManager", "PropertyChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdbo_voice_call_manager_on_signal_call_added (
    GDBOVoiceCallManager *object,
    const gchar *arg_path,
    GVariant *arg_properties)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o@a{sv})",
                   arg_path,
                   arg_properties));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCallManager", "CallAdded",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void
_gdbo_voice_call_manager_on_signal_call_removed (
    GDBOVoiceCallManager *object,
    const gchar *arg_path)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(o)",
                   arg_path));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.ofono.VoiceCallManager", "CallRemoved",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void gdbo_voice_call_manager_skeleton_iface_init (GDBOVoiceCallManagerIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (GDBOVoiceCallManagerSkeleton, gdbo_voice_call_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (GDBOVoiceCallManagerSkeleton)
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_VOICE_CALL_MANAGER, gdbo_voice_call_manager_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (GDBOVoiceCallManagerSkeleton, gdbo_voice_call_manager_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (GDBO_TYPE_VOICE_CALL_MANAGER, gdbo_voice_call_manager_skeleton_iface_init))

#endif
static void
gdbo_voice_call_manager_skeleton_finalize (GObject *object)
{
  GDBOVoiceCallManagerSkeleton *skeleton = GDBO_VOICE_CALL_MANAGER_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (gdbo_voice_call_manager_skeleton_parent_class)->finalize (object);
}

static void
gdbo_voice_call_manager_skeleton_init (GDBOVoiceCallManagerSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = gdbo_voice_call_manager_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, GDBO_TYPE_VOICE_CALL_MANAGER_SKELETON, GDBOVoiceCallManagerSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
gdbo_voice_call_manager_skeleton_class_init (GDBOVoiceCallManagerSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = gdbo_voice_call_manager_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = gdbo_voice_call_manager_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = gdbo_voice_call_manager_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = gdbo_voice_call_manager_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = gdbo_voice_call_manager_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (GDBOVoiceCallManagerSkeletonPrivate));
#endif
}

static void
gdbo_voice_call_manager_skeleton_iface_init (GDBOVoiceCallManagerIface *iface)
{
  iface->forwarded = _gdbo_voice_call_manager_on_signal_forwarded;
  iface->barring_active = _gdbo_voice_call_manager_on_signal_barring_active;
  iface->property_changed = _gdbo_voice_call_manager_on_signal_property_changed;
  iface->call_added = _gdbo_voice_call_manager_on_signal_call_added;
  iface->call_removed = _gdbo_voice_call_manager_on_signal_call_removed;
}

/**
 * gdbo_voice_call_manager_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-ofono-VoiceCallManager.top_of_page">org.ofono.VoiceCallManager</link>.
 *
 * Returns: (transfer full) (type GDBOVoiceCallManagerSkeleton): The skeleton object.
 */
GDBOVoiceCallManager *
gdbo_voice_call_manager_skeleton_new (void)
{
  return GDBO_VOICE_CALL_MANAGER (g_object_new (GDBO_TYPE_VOICE_CALL_MANAGER_SKELETON, NULL));
}

