/* math-converter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-converter.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include "calculator.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <langinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CURRENCY_DISPLAY_CODE,
	CURRENCY_DISPLAY_NAME,
	CURRENCY_DISPLAY_BOTH
} CurrencyDisplay;

#define TYPE_CURRENCY_DISPLAY (currency_display_get_type ())

#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
typedef struct _MathConverterPrivate MathConverterPrivate;
enum  {
	MATH_CONVERTER_0_PROPERTY,
	MATH_CONVERTER_EQUATION_PROPERTY,
	MATH_CONVERTER_SOURCE_UNITS_PROPERTY,
	MATH_CONVERTER_TARGET_UNITS_PROPERTY,
	MATH_CONVERTER_CURRENCY_DISPLAY_PROPERTY,
	MATH_CONVERTER_BOX_VISIBLE_PROPERTY,
	MATH_CONVERTER_NUM_PROPERTIES
};
static GParamSpec* math_converter_properties[MATH_CONVERTER_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _gtk_expression_unref0(var) ((var == NULL) ? NULL : (var = (gtk_expression_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GdkEventSequence_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventSequence_free (var), NULL)))
#define _gdk_event_unref0(var) ((var == NULL) ? NULL : (var = (gdk_event_unref (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
enum  {
	MATH_CONVERTER_CHANGED_SIGNAL,
	MATH_CONVERTER_NUM_SIGNALS
};
static guint math_converter_signals[MATH_CONVERTER_NUM_SIGNALS] = {0};

struct _MathConverter {
	GtkBox parent_instance;
	MathConverterPrivate * priv;
};

struct _MathConverterClass {
	GtkBoxClass parent_class;
};

struct _MathConverterPrivate {
	MathEquation* _equation;
	gchar* category;
	Number* from_number;
	Number* to_number;
	GHashTable* _source_units;
	GHashTable* _target_units;
	CurrencyDisplay _currency_display;
	GtkDropDown* category_combo;
	GtkDropDown* from_combo;
	GtkDropDown* to_combo;
	GtkTextView* from_entry;
	GtkTextView* to_entry;
	GtkPopoverMenu* from_context_menu;
	GtkPopoverMenu* to_context_menu;
	GtkStack* status_stack;
	Serializer* fixed_serializer;
	GtkSignalListItemFactory* from_currency_factory;
	GtkSignalListItemFactory* to_currency_factory;
	GtkEventControllerKey* from_event_controller;
	GtkEventControllerKey* to_event_controller;
	gulong from_combobox_changed;
	gulong from_entry_changed;
	gulong to_entry_changed;
	GSimpleActionGroup* action_group;
	gboolean _box_visible;
};

struct _Block5Data {
	int _ref_count_;
	MathConverter* self;
	GdkClipboard* clipboard;
};

struct _Block6Data {
	int _ref_count_;
	MathConverter* self;
	CurrencyManager* currency_manager;
};

struct _Block7Data {
	int _ref_count_;
	MathConverter* self;
	GtkWidget* box;
	Unit* unit;
	GtkDropDown* combo;
};

static gint MathConverter_private_offset;
static gpointer math_converter_parent_class = NULL;

VALA_EXTERN GType currency_display_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType math_converter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MathConverter, g_object_unref)
static void math_converter_popup_cb (MathConverter* self,
                              GSimpleAction* action,
                              GVariant* param);
static void _math_converter_popup_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void math_converter_copy_cb (MathConverter* self,
                             GSimpleAction* action,
                             GVariant* param);
static void _math_converter_copy_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void math_converter_paste_cb (MathConverter* self,
                              GSimpleAction* action,
                              GVariant* param);
static void _math_converter_paste_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void _g_free0_ (gpointer var);
VALA_EXTERN MathConverter* math_converter_new (MathEquation* equation);
VALA_EXTERN MathConverter* math_converter_construct (GType object_type,
                                         MathEquation* equation);
static void math_converter_construct_finish (MathConverter* self);
VALA_EXTERN MathEquation* math_converter_get_equation (MathConverter* self);
static void math_converter_update_visibility (MathConverter* self);
static void _math_converter_update_visibility_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void __lambda5_ (MathConverter* self);
static void math_converter_category_combobox_changed_cb (MathConverter* self);
static void ___lambda5__currency_manager_favorites_changed (CurrencyManager* _sender,
                                                     gpointer self);
static void math_converter_build_category_model (MathConverter* self);
static void math_converter_build_units_model (MathConverter* self);
static void math_converter_reformat_display (MathConverter* self);
static void _math_converter_reformat_display_math_equation_display_changed (MathEquation* _sender,
                                                                     Serializer* serializer,
                                                                     gpointer self);
static void math_converter_from_combobox_changed_cb (MathConverter* self);
static void _math_converter_from_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void math_converter_update_entry (MathConverter* self,
                                  GtkTextView* entry,
                                  Serializer* serializer);
static void math_converter_from_entry_changed_cb (MathConverter* self);
static void _math_converter_from_entry_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                    gpointer self);
static void math_converter_to_entry_changed_cb (MathConverter* self);
static void _math_converter_to_entry_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                                  gpointer self);
static void math_converter_setup_currency (MathConverter* self,
                                    GObject* item);
static void _math_converter_setup_currency_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                        GObject* object,
                                                                        gpointer self);
static void __lambda8_ (MathConverter* self,
                 GObject* item);
static void math_converter_bind_currency (MathConverter* self,
                                   GObject* item,
                                   GtkDropDown* combo);
static void ___lambda8__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                    GObject* object,
                                                    gpointer self);
static void __lambda10_ (MathConverter* self,
                  GObject* item);
static void math_converter_unbind_currency (MathConverter* self,
                                     GObject* item,
                                     GtkDropDown* combo);
static void ___lambda10__gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                       GObject* object,
                                                       gpointer self);
static void __lambda11_ (MathConverter* self,
                  GObject* item);
static void ___lambda11__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                     GObject* object,
                                                     gpointer self);
static void __lambda12_ (MathConverter* self,
                  GObject* item);
static void ___lambda12__gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                       GObject* object,
                                                       gpointer self);
static gint ____lambda7_ (MathConverter* self,
                   GObject* c1,
                   GObject* c2);
static gint _____lambda7__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void math_converter_load_selected_units (MathConverter* self,
                                         GHashTable* units,
                                         gchar** value,
                                         gint value_length1);
VALA_EXTERN void math_converter_set_category (MathConverter* self,
                                  const gchar* category);
VALA_EXTERN gchar* math_converter_get_category (MathConverter* self);
VALA_EXTERN gchar* math_converter_get_focus_unit (MathConverter* self);
VALA_EXTERN void math_converter_get_conversion (MathConverter* self,
                                    Unit** from_unit,
                                    Unit** to_unit);
VALA_EXTERN void math_converter_insert_text (MathConverter* self,
                                 const gchar* text,
                                 gboolean replace_zero);
VALA_EXTERN gboolean math_converter_get_box_visible (MathConverter* self);
VALA_EXTERN void math_converter_insert_numeric_point (MathConverter* self);
VALA_EXTERN void math_converter_insert_dms (MathConverter* self);
VALA_EXTERN void math_converter_change_sign (MathConverter* self);
VALA_EXTERN void math_converter_clear (MathConverter* self);
VALA_EXTERN void math_converter_swap_units (MathConverter* self);
static gboolean math_converter_set_active_unit (MathConverter* self,
                                         GtkDropDown* combo,
                                         Unit* unit);
static void math_converter_to_combobox_changed_cb (MathConverter* self);
static void math_converter_reformat_from_entry (MathConverter* self);
VALA_EXTERN void math_converter_backspace (MathConverter* self);
VALA_EXTERN void math_converter_paste (MathConverter* self);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda4_ (Block5Data* _data5_,
                 GObject* obj,
                 GAsyncResult* res);
static void math_converter_on_paste (MathConverter* self,
                              const gchar* text);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
VALA_EXTERN gboolean math_converter_refresh_rates (MathConverter* self);
static gboolean _math_converter_refresh_rates_gtk_label_activate_link (GtkLabel* _sender,
                                                                const gchar* uri,
                                                                gpointer self);
VALA_EXTERN void math_converter_set_box_visible (MathConverter* self,
                                     gboolean value);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gchar* math_converter_currency_item (Unit* unit);
static gint ___lambda6_ (Block6Data* _data6_,
                  GObject* a,
                  GObject* b);
static gint ____lambda6__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda9_ (Block7Data* _data7_);
static void ___lambda9__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void _math_converter_category_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static Number* math_converter_convert_equation (MathConverter* self,
                                         Number* x,
                                         Unit** source_unit,
                                         Unit** target_unit);
static void _math_converter_to_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void math_converter_from_entry_focus_cb (MathConverter* self);
static Number* math_converter_get_number_from_entry (MathConverter* self,
                                              GtkTextView* entry);
static void _math_converter_from_entry_focus_cb_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void math_converter_to_entry_focus_cb (MathConverter* self);
static void _math_converter_to_entry_focus_cb_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static gboolean math_converter_key_press_cb (MathConverter* self,
                                      GtkEventControllerKey* controller,
                                      guint keyval,
                                      guint keycode,
                                      GdkModifierType mod_state);
static gboolean _math_converter_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                            guint keyval,
                                                                            guint keycode,
                                                                            GdkModifierType state,
                                                                            gpointer self);
static void math_converter_from_entry_click_cb (MathConverter* self,
                                         GtkGestureClick* gesture,
                                         gint n_click,
                                         gdouble x,
                                         gdouble y);
static void _vala_GdkEventSequence_free (GdkEventSequence* self);
static void math_converter_show_context_menu (MathConverter* self,
                                       GtkTextView* entry,
                                       gdouble x,
                                       gdouble y);
static void _math_converter_from_entry_click_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                    gint n_press,
                                                                    gdouble x,
                                                                    gdouble y,
                                                                    gpointer self);
static void math_converter_to_entry_click_cb (MathConverter* self,
                                       GtkGestureClick* gesture,
                                       gint n_click,
                                       gdouble x,
                                       gdouble y);
static void _math_converter_to_entry_click_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                  gint n_press,
                                                                  gdouble x,
                                                                  gdouble y,
                                                                  gpointer self);
VALA_EXTERN void math_converter_set_equation (MathConverter* self,
                                  MathEquation* value);
VALA_EXTERN gchar** math_converter_get_source_units (MathConverter* self,
                                         gint* result_length1);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
VALA_EXTERN void math_converter_set_source_units (MathConverter* self,
                                      gchar** value,
                                      gint value_length1);
VALA_EXTERN gchar** math_converter_get_target_units (MathConverter* self,
                                         gint* result_length1);
static gchar** _vala_array_dup7 (gchar** self,
                          gssize length);
VALA_EXTERN void math_converter_set_target_units (MathConverter* self,
                                      gchar** value,
                                      gint value_length1);
VALA_EXTERN void math_converter_set_currency_display (MathConverter* self,
                                          CurrencyDisplay value);
static GObject * math_converter_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void _math_converter_construct_finish_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self);
static void math_converter_finalize (GObject * obj);
static GType math_converter_get_type_once (void);
static void _vala_math_converter_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_math_converter_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry MATH_CONVERTER_action_entries[3] = {{"popup", _math_converter_popup_cb_gsimple_action_activate_callback}, {"copy", _math_converter_copy_cb_gsimple_action_activate_callback}, {"paste", _math_converter_paste_cb_gsimple_action_activate_callback}};

static GType
currency_display_get_type_once (void)
{
	static const GEnumValue values[] = {{CURRENCY_DISPLAY_CODE, "CURRENCY_DISPLAY_CODE", "code"}, {CURRENCY_DISPLAY_NAME, "CURRENCY_DISPLAY_NAME", "name"}, {CURRENCY_DISPLAY_BOTH, "CURRENCY_DISPLAY_BOTH", "both"}, {0, NULL, NULL}};
	GType currency_display_type_id;
	currency_display_type_id = g_enum_register_static ("CurrencyDisplay", values);
	return currency_display_type_id;
}

GType
currency_display_get_type (void)
{
	static volatile gsize currency_display_type_id__once = 0;
	if (g_once_init_enter (&currency_display_type_id__once)) {
		GType currency_display_type_id;
		currency_display_type_id = currency_display_get_type_once ();
		g_once_init_leave (&currency_display_type_id__once, currency_display_type_id);
	}
	return currency_display_type_id__once;
}

static inline gpointer
math_converter_get_instance_private (MathConverter* self)
{
	return G_STRUCT_MEMBER_P (self, MathConverter_private_offset);
}

static void
_math_converter_popup_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	math_converter_popup_cb ((MathConverter*) self, action, parameter);
}

static void
_math_converter_copy_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	math_converter_copy_cb ((MathConverter*) self, action, parameter);
}

static void
_math_converter_paste_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	math_converter_paste_cb ((MathConverter*) self, action, parameter);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

MathConverter*
math_converter_construct (GType object_type,
                          MathEquation* equation)
{
	MathConverter * self = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathConverter*) g_object_new (object_type, "equation", equation, NULL);
	return self;
}

MathConverter*
math_converter_new (MathEquation* equation)
{
	return math_converter_construct (TYPE_MATH_CONVERTER, equation);
}

static void
_math_converter_update_visibility_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	math_converter_update_visibility ((MathConverter*) self);
}

static void
__lambda5_ (MathConverter* self)
{
	const gchar* _tmp0_;
	_tmp0_ = self->priv->category;
	if (g_strcmp0 (_tmp0_, "currency") == 0) {
		math_converter_category_combobox_changed_cb (self);
	}
}

static void
___lambda5__currency_manager_favorites_changed (CurrencyManager* _sender,
                                                gpointer self)
{
	__lambda5_ ((MathConverter*) self);
}

static void
_math_converter_reformat_display_math_equation_display_changed (MathEquation* _sender,
                                                                Serializer* serializer,
                                                                gpointer self)
{
	math_converter_reformat_display ((MathConverter*) self);
}

static void
_math_converter_from_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	math_converter_from_combobox_changed_cb ((MathConverter*) self);
}

static void
_math_converter_from_entry_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                               gpointer self)
{
	math_converter_from_entry_changed_cb ((MathConverter*) self);
}

static void
_math_converter_to_entry_changed_cb_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                             gpointer self)
{
	math_converter_to_entry_changed_cb ((MathConverter*) self);
}

static void
_math_converter_setup_currency_gtk_signal_list_item_factory_setup (GtkSignalListItemFactory* _sender,
                                                                   GObject* object,
                                                                   gpointer self)
{
	math_converter_setup_currency ((MathConverter*) self, object);
}

static void
__lambda8_ (MathConverter* self,
            GObject* item)
{
	GtkDropDown* _tmp0_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->from_combo;
	math_converter_bind_currency (self, item, _tmp0_);
}

static void
___lambda8__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                               GObject* object,
                                               gpointer self)
{
	__lambda8_ ((MathConverter*) self, object);
}

static void
__lambda10_ (MathConverter* self,
             GObject* item)
{
	GtkDropDown* _tmp0_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->from_combo;
	math_converter_unbind_currency (self, item, _tmp0_);
}

static void
___lambda10__gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                  GObject* object,
                                                  gpointer self)
{
	__lambda10_ ((MathConverter*) self, object);
}

static void
__lambda11_ (MathConverter* self,
             GObject* item)
{
	GtkDropDown* _tmp0_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->to_combo;
	math_converter_bind_currency (self, item, _tmp0_);
}

static void
___lambda11__gtk_signal_list_item_factory_bind (GtkSignalListItemFactory* _sender,
                                                GObject* object,
                                                gpointer self)
{
	__lambda11_ ((MathConverter*) self, object);
}

static void
__lambda12_ (MathConverter* self,
             GObject* item)
{
	GtkDropDown* _tmp0_;
	g_return_if_fail (item != NULL);
	_tmp0_ = self->priv->to_combo;
	math_converter_unbind_currency (self, item, _tmp0_);
}

static void
___lambda12__gtk_signal_list_item_factory_unbind (GtkSignalListItemFactory* _sender,
                                                  GObject* object,
                                                  gpointer self)
{
	__lambda12_ ((MathConverter*) self, object);
}

static void
math_converter_construct_finish (MathConverter* self)
{
	MathEquation* _tmp0_;
	CurrencyManager* _tmp1_;
	CurrencyManager* _tmp2_;
	CurrencyManager* _tmp3_;
	CurrencyManager* _tmp4_;
	MathEquation* _tmp5_;
	GtkDropDown* _tmp6_;
	gulong _tmp7_;
	MathEquation* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	Serializer* _tmp11_;
	Number* _tmp12_;
	Number* _tmp13_;
	GtkTextView* _tmp14_;
	MathEquation* _tmp15_;
	Serializer* _tmp16_;
	Serializer* _tmp17_;
	GtkTextView* _tmp18_;
	MathEquation* _tmp19_;
	Serializer* _tmp20_;
	Serializer* _tmp21_;
	GtkTextView* _tmp22_;
	GtkTextBuffer* _tmp23_;
	GtkTextBuffer* _tmp24_;
	gulong _tmp25_;
	GtkTextView* _tmp26_;
	GtkTextBuffer* _tmp27_;
	GtkTextBuffer* _tmp28_;
	gulong _tmp29_;
	GtkSignalListItemFactory* _tmp36_;
	GtkSignalListItemFactory* _tmp37_;
	GtkSignalListItemFactory* _tmp38_;
	GtkSignalListItemFactory* _tmp39_;
	GtkSignalListItemFactory* _tmp40_;
	GtkSignalListItemFactory* _tmp41_;
	GtkSignalListItemFactory* _tmp42_;
	GtkSignalListItemFactory* _tmp43_;
	GSettings* settings = NULL;
	GSettings* _tmp44_;
	GSettings* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = currency_manager_get_default (TRUE, TRUE);
	_tmp2_ = _tmp1_;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::loaded", (GCallback) _math_converter_update_visibility_g_object_notify, self, 0);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = currency_manager_get_default (TRUE, TRUE);
	_tmp4_ = _tmp3_;
	g_signal_connect_object (_tmp4_, "favorites-changed", (GCallback) ___lambda5__currency_manager_favorites_changed, self, 0);
	_g_object_unref0 (_tmp4_);
	math_converter_build_category_model (self);
	math_converter_update_visibility (self);
	math_converter_build_units_model (self);
	_tmp5_ = self->priv->_equation;
	g_signal_connect_object (_tmp5_, "display-changed", (GCallback) _math_converter_reformat_display_math_equation_display_changed, self, 0);
	_tmp6_ = self->priv->from_combo;
	_tmp7_ = g_signal_connect_object ((GObject*) _tmp6_, "notify::selected", (GCallback) _math_converter_from_combobox_changed_cb_g_object_notify, self, 0);
	self->priv->from_combobox_changed = _tmp7_;
	_tmp8_ = self->priv->_equation;
	_tmp9_ = math_equation_get_accuracy (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = serializer_new (DISPLAY_FORMAT_FIXED, 10, _tmp10_);
	_g_object_unref0 (self->priv->fixed_serializer);
	self->priv->fixed_serializer = _tmp11_;
	_tmp12_ = number_new_integer ((gint64) 0, (gint64) 0);
	_g_object_unref0 (self->priv->from_number);
	self->priv->from_number = _tmp12_;
	_tmp13_ = number_new_integer ((gint64) 0, (gint64) 0);
	_g_object_unref0 (self->priv->to_number);
	self->priv->to_number = _tmp13_;
	_tmp14_ = self->priv->from_entry;
	_tmp15_ = self->priv->_equation;
	_tmp16_ = math_equation_get_serializer (_tmp15_);
	_tmp17_ = _tmp16_;
	math_converter_update_entry (self, _tmp14_, _tmp17_);
	_tmp18_ = self->priv->to_entry;
	_tmp19_ = self->priv->_equation;
	_tmp20_ = math_equation_get_serializer (_tmp19_);
	_tmp21_ = _tmp20_;
	math_converter_update_entry (self, _tmp18_, _tmp21_);
	_tmp22_ = self->priv->from_entry;
	_tmp23_ = gtk_text_view_get_buffer (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_signal_connect_object (_tmp24_, "changed", (GCallback) _math_converter_from_entry_changed_cb_gtk_text_buffer_changed, self, 0);
	self->priv->from_entry_changed = _tmp25_;
	_tmp26_ = self->priv->to_entry;
	_tmp27_ = gtk_text_view_get_buffer (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_signal_connect_object (_tmp28_, "changed", (GCallback) _math_converter_to_entry_changed_cb_gtk_text_buffer_changed, self, 0);
	self->priv->to_entry_changed = _tmp29_;
	if (gtk_widget_get_default_direction () == GTK_TEXT_DIR_RTL) {
		GtkTextView* _tmp30_;
		GtkTextView* _tmp31_;
		GtkTextView* _tmp32_;
		GtkTextView* _tmp33_;
		GtkTextView* _tmp34_;
		GtkTextView* _tmp35_;
		_tmp30_ = self->priv->from_entry;
		gtk_text_view_set_justification (_tmp30_, GTK_JUSTIFY_RIGHT);
		_tmp31_ = self->priv->from_entry;
		gtk_widget_set_direction ((GtkWidget*) _tmp31_, GTK_TEXT_DIR_LTR);
		_tmp32_ = self->priv->from_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp32_);
		_tmp33_ = self->priv->to_entry;
		gtk_text_view_set_justification (_tmp33_, GTK_JUSTIFY_RIGHT);
		_tmp34_ = self->priv->to_entry;
		gtk_widget_set_direction ((GtkWidget*) _tmp34_, GTK_TEXT_DIR_LTR);
		_tmp35_ = self->priv->to_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp35_);
	}
	_tmp36_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	_g_object_unref0 (self->priv->from_currency_factory);
	self->priv->from_currency_factory = _tmp36_;
	_tmp37_ = self->priv->from_currency_factory;
	g_signal_connect_object (_tmp37_, "setup", (GCallback) _math_converter_setup_currency_gtk_signal_list_item_factory_setup, self, 0);
	_tmp38_ = self->priv->from_currency_factory;
	g_signal_connect_object (_tmp38_, "bind", (GCallback) ___lambda8__gtk_signal_list_item_factory_bind, self, 0);
	_tmp39_ = self->priv->from_currency_factory;
	g_signal_connect_object (_tmp39_, "unbind", (GCallback) ___lambda10__gtk_signal_list_item_factory_unbind, self, 0);
	_tmp40_ = (GtkSignalListItemFactory*) gtk_signal_list_item_factory_new ();
	_g_object_unref0 (self->priv->to_currency_factory);
	self->priv->to_currency_factory = _tmp40_;
	_tmp41_ = self->priv->to_currency_factory;
	g_signal_connect_object (_tmp41_, "setup", (GCallback) _math_converter_setup_currency_gtk_signal_list_item_factory_setup, self, 0);
	_tmp42_ = self->priv->to_currency_factory;
	g_signal_connect_object (_tmp42_, "bind", (GCallback) ___lambda11__gtk_signal_list_item_factory_bind, self, 0);
	_tmp43_ = self->priv->to_currency_factory;
	g_signal_connect_object (_tmp43_, "unbind", (GCallback) ___lambda12__gtk_signal_list_item_factory_unbind, self, 0);
	_tmp44_ = g_settings_new ("org.gnome.calculator");
	settings = _tmp44_;
	_tmp45_ = settings;
	g_settings_bind (_tmp45_, "currency-display", (GObject*) self, "currency_display", G_SETTINGS_BIND_GET);
	_g_object_unref0 (settings);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gint
____lambda7_ (MathConverter* self,
              GObject* c1,
              GObject* c2)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint result;
	g_return_val_if_fail (c1 != NULL, 0);
	g_return_val_if_fail (c2 != NULL, 0);
	_tmp0_ = unit_category_get_display_name (G_TYPE_CHECK_INSTANCE_TYPE (c1, TYPE_UNIT_CATEGORY) ? ((UnitCategory*) c1) : NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = unit_category_get_display_name (G_TYPE_CHECK_INSTANCE_TYPE (c2, TYPE_UNIT_CATEGORY) ? ((UnitCategory*) c2) : NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gint
_____lambda7__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = ____lambda7_ ((MathConverter*) self, (GObject*) a, (GObject*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
math_converter_build_category_model (MathConverter* self)
{
	GListStore* category_model = NULL;
	GListStore* _tmp0_;
	GtkPropertyExpression* expression = NULL;
	GtkPropertyExpression* _tmp1_;
	GList* categories = NULL;
	UnitManager* _tmp2_;
	UnitManager* _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	GtkDropDown* _tmp10_;
	GtkPropertyExpression* _tmp11_;
	GtkDropDown* _tmp12_;
	GListStore* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_store_new (TYPE_UNIT_CATEGORY);
	category_model = _tmp0_;
	_tmp1_ = (GtkPropertyExpression*) gtk_property_expression_new (TYPE_UNIT_CATEGORY, NULL, "display_name");
	expression = _tmp1_;
	_tmp2_ = unit_manager_get_default ();
	_tmp3_ = _tmp2_;
	_tmp4_ = unit_manager_get_categories (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	categories = _tmp5_;
	_tmp6_ = categories;
	{
		GList* category_collection = NULL;
		GList* category_it = NULL;
		category_collection = _tmp6_;
		for (category_it = category_collection; category_it != NULL; category_it = category_it->next) {
			UnitCategory* _tmp7_;
			UnitCategory* category = NULL;
			_tmp7_ = _g_object_ref0 ((UnitCategory*) category_it->data);
			category = _tmp7_;
			{
				GListStore* _tmp8_;
				UnitCategory* _tmp9_;
				_tmp8_ = category_model;
				_tmp9_ = category;
				g_list_store_insert_sorted (_tmp8_, (GObject*) _tmp9_, _____lambda7__gcompare_data_func, self);
				_g_object_unref0 (category);
			}
		}
	}
	_tmp10_ = self->priv->category_combo;
	_tmp11_ = expression;
	gtk_drop_down_set_expression (_tmp10_, (GtkExpression*) _tmp11_);
	_tmp12_ = self->priv->category_combo;
	_tmp13_ = category_model;
	gtk_drop_down_set_model (_tmp12_, (GListModel*) _tmp13_);
	(categories == NULL) ? NULL : (categories = (_g_list_free__g_object_unref0_ (categories), NULL));
	_gtk_expression_unref0 (expression);
	_g_object_unref0 (category_model);
}

static void
math_converter_load_selected_units (MathConverter* self,
                                    GHashTable* units,
                                    gchar** value,
                                    gint value_length1)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (units != NULL);
	{
		gchar** unit_collection = NULL;
		gint unit_collection_length1 = 0;
		gint _unit_collection_size_ = 0;
		gint unit_it = 0;
		unit_collection = value;
		unit_collection_length1 = value_length1;
		for (unit_it = 0; unit_it < unit_collection_length1; unit_it = unit_it + 1) {
			gchar* _tmp0_;
			gchar* unit = NULL;
			_tmp0_ = g_strdup (unit_collection[unit_it]);
			unit = _tmp0_;
			{
				UnitCategory* category = NULL;
				UnitManager* _tmp1_;
				UnitManager* _tmp2_;
				const gchar* _tmp3_;
				UnitCategory* _tmp4_;
				UnitCategory* _tmp5_;
				UnitCategory* _tmp6_;
				_tmp1_ = unit_manager_get_default ();
				_tmp2_ = _tmp1_;
				_tmp3_ = unit;
				_tmp4_ = unit_manager_get_category_of_unit (_tmp2_, _tmp3_);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (_tmp2_);
				category = _tmp5_;
				_tmp6_ = category;
				if (_tmp6_ != NULL) {
					UnitCategory* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					_tmp7_ = category;
					_tmp8_ = unit_category_get_name (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = unit;
					_tmp11_ = g_strdup (_tmp10_);
					g_hash_table_insert (units, _tmp9_, _tmp11_);
				}
				_g_object_unref0 (category);
				_g_free0 (unit);
			}
		}
	}
}

void
math_converter_set_category (MathConverter* self,
                             const gchar* category)
{
	const gchar* _tmp0_;
	UnitCategory* unit_category = NULL;
	UnitManager* _tmp1_;
	UnitManager* _tmp2_;
	UnitCategory* _tmp3_;
	UnitCategory* _tmp4_;
	UnitCategory* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	_tmp0_ = self->priv->category;
	if (g_strcmp0 (_tmp0_, category) == 0) {
		math_converter_category_combobox_changed_cb (self);
		return;
	}
	_tmp1_ = unit_manager_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = unit_manager_get_category (_tmp2_, category);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	unit_category = _tmp4_;
	_tmp5_ = unit_category;
	if (_tmp5_ != NULL) {
		gchar* _tmp6_;
		guint position = 0U;
		GListStore* model = NULL;
		GtkDropDown* _tmp7_;
		GListModel* _tmp8_;
		GListStore* _tmp9_;
		GListStore* _tmp10_;
		UnitCategory* _tmp11_;
		guint _tmp12_ = 0U;
		GtkDropDown* _tmp13_;
		_tmp6_ = g_strdup (category);
		_g_free0 (self->priv->category);
		self->priv->category = _tmp6_;
		position = (guint) 0;
		_tmp7_ = self->priv->category_combo;
		_tmp8_ = gtk_drop_down_get_model (_tmp7_);
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_list_store_get_type ()) ? ((GListStore*) _tmp8_) : NULL);
		model = _tmp9_;
		_tmp10_ = model;
		_tmp11_ = unit_category;
		g_list_store_find (_tmp10_, (GObject*) _tmp11_, &_tmp12_);
		position = _tmp12_;
		_tmp13_ = self->priv->category_combo;
		gtk_drop_down_set_selected (_tmp13_, position);
		_g_object_unref0 (model);
	} else {
		GtkDropDown* _tmp14_;
		_tmp14_ = self->priv->category_combo;
		gtk_drop_down_set_selected (_tmp14_, (guint) 0);
	}
	_g_object_unref0 (unit_category);
}

gchar*
math_converter_get_category (MathConverter* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->category;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
math_converter_get_focus_unit (MathConverter* self)
{
	GtkDropDown* _tmp0_ = NULL;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkDropDown* combo = NULL;
	GtkDropDown* _tmp6_;
	GObject* _tmp7_;
	GObject* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkDropDown* _tmp4_;
		_tmp4_ = self->priv->to_combo;
		_tmp0_ = _tmp4_;
	} else {
		GtkDropDown* _tmp5_;
		_tmp5_ = self->priv->from_combo;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	combo = _tmp6_;
	_tmp7_ = gtk_drop_down_get_selected_item (combo);
	_tmp8_ = _tmp7_;
	_tmp9_ = unit_get_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_UNIT) ? ((Unit*) _tmp8_) : NULL);
	_tmp10_ = _tmp9_;
	result = _tmp10_;
	_g_object_unref0 (combo);
	return result;
}

void
math_converter_get_conversion (MathConverter* self,
                               Unit** from_unit,
                               Unit** to_unit)
{
	Unit* _vala_from_unit = NULL;
	Unit* _vala_to_unit = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	Unit* _tmp3_;
	GtkDropDown* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	Unit* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->from_combo;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_UNIT) ? ((Unit*) _tmp2_) : NULL);
	_g_object_unref0 (_vala_from_unit);
	_vala_from_unit = _tmp3_;
	_tmp4_ = self->priv->to_combo;
	_tmp5_ = gtk_drop_down_get_selected_item (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_UNIT) ? ((Unit*) _tmp6_) : NULL);
	_g_object_unref0 (_vala_to_unit);
	_vala_to_unit = _tmp7_;
	if (from_unit) {
		*from_unit = _vala_from_unit;
	} else {
		_g_object_unref0 (_vala_from_unit);
	}
	if (to_unit) {
		*to_unit = _vala_to_unit;
	} else {
		_g_object_unref0 (_vala_to_unit);
	}
}

void
math_converter_insert_text (MathConverter* self,
                            const gchar* text,
                            gboolean replace_zero)
{
	gboolean _tmp0_;
	GtkTextView* _tmp1_ = NULL;
	GtkTextView* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkTextView* entry = NULL;
	GtkTextView* _tmp7_;
	GtkTextView* _tmp8_;
	GtkTextView* _tmp9_;
	gboolean _tmp11_ = FALSE;
	GtkTextView* _tmp29_;
	GtkTextBuffer* _tmp30_;
	GtkTextBuffer* _tmp31_;
	GtkTextView* _tmp32_;
	GtkTextBuffer* _tmp33_;
	GtkTextBuffer* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->_box_visible;
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp2_, "has-focus", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkTextView* _tmp5_;
		_tmp5_ = self->priv->to_entry;
		_tmp1_ = _tmp5_;
	} else {
		GtkTextView* _tmp6_;
		_tmp6_ = self->priv->from_entry;
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _g_object_ref0 (_tmp1_);
	entry = _tmp7_;
	_tmp8_ = entry;
	_tmp9_ = self->priv->from_entry;
	if (_tmp8_ == _tmp9_) {
		GtkTextView* _tmp10_;
		_tmp10_ = self->priv->from_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	if (replace_zero) {
		GtkTextView* _tmp12_;
		GtkTextBuffer* _tmp13_;
		GtkTextBuffer* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp12_ = entry;
		_tmp13_ = gtk_text_view_get_buffer (_tmp12_);
		_tmp14_ = _tmp13_;
		g_object_get (_tmp14_, "text", &_tmp15_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp11_ = g_strcmp0 (_tmp17_, "0") == 0;
		_g_free0 (_tmp17_);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkTextIter iter = {0};
		GtkTextView* _tmp18_;
		GtkTextBuffer* _tmp19_;
		GtkTextBuffer* _tmp20_;
		GtkTextView* _tmp21_;
		GtkTextBuffer* _tmp22_;
		GtkTextBuffer* _tmp23_;
		GtkTextMark* _tmp24_;
		GtkTextIter _tmp25_ = {0};
		_tmp18_ = entry;
		_tmp19_ = gtk_text_view_get_buffer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = entry;
		_tmp22_ = gtk_text_view_get_buffer (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = gtk_text_buffer_get_insert (_tmp23_);
		gtk_text_buffer_get_iter_at_mark (_tmp20_, &_tmp25_, _tmp24_);
		iter = _tmp25_;
		if (gtk_text_iter_is_end (&iter)) {
			GtkTextView* _tmp26_;
			GtkTextBuffer* _tmp27_;
			GtkTextBuffer* _tmp28_;
			_tmp26_ = entry;
			_tmp27_ = gtk_text_view_get_buffer (_tmp26_);
			_tmp28_ = _tmp27_;
			g_object_set (_tmp28_, "text", "", NULL);
		}
	}
	_tmp29_ = entry;
	_tmp30_ = gtk_text_view_get_buffer (_tmp29_);
	_tmp31_ = _tmp30_;
	gtk_text_buffer_delete_selection (_tmp31_, TRUE, TRUE);
	_tmp32_ = entry;
	_tmp33_ = gtk_text_view_get_buffer (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = strlen (text);
	_tmp36_ = _tmp35_;
	gtk_text_buffer_insert_at_cursor (_tmp34_, text, _tmp36_);
	_g_object_unref0 (entry);
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

void
math_converter_insert_numeric_point (MathConverter* self)
{
	Serializer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fixed_serializer;
	_tmp1_ = g_unichar_to_string (serializer_get_radix (_tmp0_));
	_tmp2_ = _tmp1_;
	math_converter_insert_text (self, _tmp2_, FALSE);
	_g_free0 (_tmp2_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

void
math_converter_insert_dms (MathConverter* self)
{
	GtkTextView* _tmp0_ = NULL;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkTextView* entry = NULL;
	GtkTextView* _tmp6_;
	GtkTextView* _tmp7_;
	GtkTextView* _tmp8_;
	gchar** dms = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint dms_length1;
	gint _dms_size_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkTextView* _tmp4_;
		_tmp4_ = self->priv->to_entry;
		_tmp0_ = _tmp4_;
	} else {
		GtkTextView* _tmp5_;
		_tmp5_ = self->priv->from_entry;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	entry = _tmp6_;
	_tmp7_ = entry;
	_tmp8_ = self->priv->from_entry;
	if (_tmp7_ == _tmp8_) {
		GtkTextView* _tmp9_;
		_tmp9_ = self->priv->from_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	}
	_tmp10_ = g_strdup ("°");
	_tmp11_ = g_strdup ("′");
	_tmp12_ = g_strdup ("″");
	_tmp13_ = g_new0 (gchar*, 3 + 1);
	_tmp13_[0] = _tmp10_;
	_tmp13_[1] = _tmp11_;
	_tmp13_[2] = _tmp12_;
	dms = _tmp13_;
	dms_length1 = 3;
	_dms_size_ = dms_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				GtkTextView* _tmp16_;
				GtkTextBuffer* _tmp17_;
				GtkTextBuffer* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				gboolean _tmp24_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				_tmp16_ = entry;
				_tmp17_ = gtk_text_view_get_buffer (_tmp16_);
				_tmp18_ = _tmp17_;
				g_object_get (_tmp18_, "text", &_tmp19_, NULL);
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_;
				_tmp22_ = dms;
				_tmp22__length1 = dms_length1;
				_tmp23_ = _tmp22_[i];
				_tmp24_ = !string_contains (_tmp21_, _tmp23_);
				_g_free0 (_tmp21_);
				if (_tmp24_) {
					GtkTextView* _tmp25_;
					GtkTextBuffer* _tmp26_;
					GtkTextBuffer* _tmp27_;
					GtkTextView* _tmp28_;
					GtkTextBuffer* _tmp29_;
					GtkTextBuffer* _tmp30_;
					gchar** _tmp31_;
					gint _tmp31__length1;
					const gchar* _tmp32_;
					gchar** _tmp33_;
					gint _tmp33__length1;
					const gchar* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					_tmp25_ = entry;
					_tmp26_ = gtk_text_view_get_buffer (_tmp25_);
					_tmp27_ = _tmp26_;
					gtk_text_buffer_delete_selection (_tmp27_, TRUE, TRUE);
					_tmp28_ = entry;
					_tmp29_ = gtk_text_view_get_buffer (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = dms;
					_tmp31__length1 = dms_length1;
					_tmp32_ = _tmp31_[i];
					_tmp33_ = dms;
					_tmp33__length1 = dms_length1;
					_tmp34_ = _tmp33_[i];
					_tmp35_ = strlen (_tmp34_);
					_tmp36_ = _tmp35_;
					gtk_text_buffer_insert_at_cursor (_tmp30_, _tmp32_, _tmp36_);
					dms = (_vala_array_free (dms, dms_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (entry);
					return;
				}
			}
		}
	}
	dms = (_vala_array_free (dms, dms_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (entry);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

void
math_converter_change_sign (MathConverter* self)
{
	GtkTextView* _tmp0_ = NULL;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkTextView* entry = NULL;
	GtkTextView* _tmp6_;
	GtkTextView* _tmp7_;
	GtkTextView* _tmp8_;
	gchar* text = NULL;
	GtkTextView* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkTextView* _tmp4_;
		_tmp4_ = self->priv->to_entry;
		_tmp0_ = _tmp4_;
	} else {
		GtkTextView* _tmp5_;
		_tmp5_ = self->priv->from_entry;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	entry = _tmp6_;
	_tmp7_ = entry;
	_tmp8_ = self->priv->from_entry;
	if (_tmp7_ == _tmp8_) {
		GtkTextView* _tmp9_;
		_tmp9_ = self->priv->from_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	}
	_tmp10_ = entry;
	_tmp11_ = gtk_text_view_get_buffer (_tmp10_);
	_tmp12_ = _tmp11_;
	g_object_get (_tmp12_, "text", &_tmp13_, NULL);
	_tmp14_ = _tmp13_;
	text = _tmp14_;
	_tmp15_ = text;
	if (g_strcmp0 (_tmp15_, "0") == 0) {
		GtkTextView* _tmp16_;
		GtkTextBuffer* _tmp17_;
		GtkTextBuffer* _tmp18_;
		_tmp16_ = entry;
		_tmp17_ = gtk_text_view_get_buffer (_tmp16_);
		_tmp18_ = _tmp17_;
		g_object_set (_tmp18_, "text", "−", NULL);
	} else {
		const gchar* _tmp19_;
		_tmp19_ = text;
		if (g_str_has_prefix (_tmp19_, "−")) {
			GtkTextView* _tmp20_;
			GtkTextBuffer* _tmp21_;
			GtkTextBuffer* _tmp22_;
			const gchar* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			const gchar* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			_tmp20_ = entry;
			_tmp21_ = gtk_text_view_get_buffer (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = text;
			_tmp24_ = strlen ("−");
			_tmp25_ = _tmp24_;
			_tmp26_ = text;
			_tmp27_ = strlen (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = string_slice (_tmp26_, (glong) _tmp25_, (glong) _tmp28_);
			_tmp30_ = _tmp29_;
			g_object_set (_tmp22_, "text", _tmp30_, NULL);
			_g_free0 (_tmp30_);
		} else {
			const gchar* _tmp31_;
			_tmp31_ = text;
			if (g_str_has_prefix (_tmp31_, "-")) {
				GtkTextView* _tmp32_;
				GtkTextBuffer* _tmp33_;
				GtkTextBuffer* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				const gchar* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				_tmp32_ = entry;
				_tmp33_ = gtk_text_view_get_buffer (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = text;
				_tmp36_ = strlen ("-");
				_tmp37_ = _tmp36_;
				_tmp38_ = text;
				_tmp39_ = strlen (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = string_slice (_tmp38_, (glong) _tmp37_, (glong) _tmp40_);
				_tmp42_ = _tmp41_;
				g_object_set (_tmp34_, "text", _tmp42_, NULL);
				_g_free0 (_tmp42_);
			} else {
				GtkTextView* _tmp43_;
				GtkTextBuffer* _tmp44_;
				GtkTextBuffer* _tmp45_;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp43_ = entry;
				_tmp44_ = gtk_text_view_get_buffer (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = text;
				_tmp47_ = g_strconcat ("−", _tmp46_, NULL);
				_tmp48_ = _tmp47_;
				g_object_set (_tmp45_, "text", _tmp48_, NULL);
				_g_free0 (_tmp48_);
			}
		}
	}
	_g_free0 (text);
	_g_object_unref0 (entry);
}

void
math_converter_clear (MathConverter* self)
{
	gboolean _tmp0_;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_box_visible;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->from_entry;
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkTextView* _tmp4_;
		GtkTextBuffer* _tmp5_;
		GtkTextBuffer* _tmp6_;
		_tmp4_ = self->priv->from_entry;
		_tmp5_ = gtk_text_view_get_buffer (_tmp4_);
		_tmp6_ = _tmp5_;
		g_object_set (_tmp6_, "text", "0", NULL);
	} else {
		GtkTextView* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->to_entry;
		g_object_get ((GtkWidget*) _tmp7_, "has-focus", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			GtkTextView* _tmp10_;
			GtkTextBuffer* _tmp11_;
			GtkTextBuffer* _tmp12_;
			_tmp10_ = self->priv->to_entry;
			_tmp11_ = gtk_text_view_get_buffer (_tmp10_);
			_tmp12_ = _tmp11_;
			g_object_set (_tmp12_, "text", "0", NULL);
		} else {
			Number* _tmp13_;
			GtkTextView* _tmp14_;
			MathEquation* _tmp15_;
			Serializer* _tmp16_;
			Serializer* _tmp17_;
			_tmp13_ = number_new_integer ((gint64) 0, (gint64) 0);
			_g_object_unref0 (self->priv->from_number);
			self->priv->from_number = _tmp13_;
			_tmp14_ = self->priv->from_entry;
			_tmp15_ = self->priv->_equation;
			_tmp16_ = math_equation_get_serializer (_tmp15_);
			_tmp17_ = _tmp16_;
			math_converter_update_entry (self, _tmp14_, _tmp17_);
		}
	}
}

void
math_converter_swap_units (MathConverter* self)
{
	gboolean _tmp0_;
	Unit* from_unit = NULL;
	GtkDropDown* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	Unit* _tmp4_;
	Unit* to_unit = NULL;
	GtkDropDown* _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	Unit* _tmp8_;
	GtkDropDown* _tmp9_;
	GtkDropDown* _tmp10_;
	Unit* _tmp11_;
	GtkDropDown* _tmp12_;
	GtkDropDown* _tmp13_;
	Unit* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_box_visible;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->from_combo;
	_tmp2_ = gtk_drop_down_get_selected_item (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_UNIT) ? ((Unit*) _tmp3_) : NULL);
	from_unit = _tmp4_;
	_tmp5_ = self->priv->to_combo;
	_tmp6_ = gtk_drop_down_get_selected_item (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_UNIT) ? ((Unit*) _tmp7_) : NULL);
	to_unit = _tmp8_;
	_tmp9_ = self->priv->from_combo;
	g_signal_handler_block (_tmp9_, self->priv->from_combobox_changed);
	_tmp10_ = self->priv->from_combo;
	_tmp11_ = to_unit;
	math_converter_set_active_unit (self, _tmp10_, _tmp11_);
	_tmp12_ = self->priv->from_combo;
	g_signal_handler_unblock (_tmp12_, self->priv->from_combobox_changed);
	_tmp13_ = self->priv->to_combo;
	_tmp14_ = from_unit;
	math_converter_set_active_unit (self, _tmp13_, _tmp14_);
	math_converter_to_combobox_changed_cb (self);
	math_converter_reformat_from_entry (self);
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
}

void
math_converter_backspace (MathConverter* self)
{
	gboolean _tmp0_;
	GtkTextView* _tmp1_ = NULL;
	GtkTextView* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkTextView* entry = NULL;
	GtkTextView* _tmp7_;
	GtkTextView* _tmp8_;
	GtkTextView* _tmp9_;
	GtkTextView* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_box_visible;
	if (!_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp2_, "has-focus", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkTextView* _tmp5_;
		_tmp5_ = self->priv->to_entry;
		_tmp1_ = _tmp5_;
	} else {
		GtkTextView* _tmp6_;
		_tmp6_ = self->priv->from_entry;
		_tmp1_ = _tmp6_;
	}
	_tmp7_ = _g_object_ref0 (_tmp1_);
	entry = _tmp7_;
	_tmp8_ = entry;
	_tmp9_ = self->priv->from_entry;
	if (_tmp8_ == _tmp9_) {
		GtkTextView* _tmp10_;
		_tmp10_ = self->priv->from_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	}
	_tmp11_ = entry;
	_tmp12_ = gtk_text_view_get_buffer (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = gtk_text_buffer_get_has_selection (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		GtkTextView* _tmp16_;
		GtkTextBuffer* _tmp17_;
		GtkTextBuffer* _tmp18_;
		_tmp16_ = entry;
		_tmp17_ = gtk_text_view_get_buffer (_tmp16_);
		_tmp18_ = _tmp17_;
		gtk_text_buffer_delete_selection (_tmp18_, TRUE, TRUE);
	} else {
		GtkTextIter iter = {0};
		GtkTextView* _tmp19_;
		GtkTextBuffer* _tmp20_;
		GtkTextBuffer* _tmp21_;
		GtkTextView* _tmp22_;
		GtkTextBuffer* _tmp23_;
		GtkTextBuffer* _tmp24_;
		GtkTextMark* _tmp25_;
		GtkTextIter _tmp26_ = {0};
		GtkTextView* _tmp27_;
		GtkTextBuffer* _tmp28_;
		GtkTextBuffer* _tmp29_;
		_tmp19_ = entry;
		_tmp20_ = gtk_text_view_get_buffer (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = entry;
		_tmp23_ = gtk_text_view_get_buffer (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gtk_text_buffer_get_insert (_tmp24_);
		gtk_text_buffer_get_iter_at_mark (_tmp21_, &_tmp26_, _tmp25_);
		iter = _tmp26_;
		_tmp27_ = entry;
		_tmp28_ = gtk_text_view_get_buffer (_tmp27_);
		_tmp29_ = _tmp28_;
		gtk_text_buffer_backspace (_tmp29_, &iter, TRUE, TRUE);
	}
	_g_object_unref0 (entry);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		MathConverter* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->clipboard);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda4_ (Block5Data* _data5_,
            GObject* obj,
            GAsyncResult* res)
{
	MathConverter* self;
	GError* _inner_error0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (res != NULL);
	{
		gchar* _tmp0_ = NULL;
		GdkClipboard* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = _data5_->clipboard;
		_tmp2_ = gdk_clipboard_read_text_finish (_tmp1_, res, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		math_converter_on_paste (self, _tmp0_);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		_tmp4_ = _tmp3_->message;
		g_print ("%s", _tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ (self, source_object, res);
	block5_data_unref (self);
}

void
math_converter_paste (MathConverter* self)
{
	Block5Data* _data5_;
	gboolean _tmp0_ = FALSE;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GdkDisplay* _tmp7_;
	GdkClipboard* _tmp8_;
	GdkClipboard* _tmp9_;
	GdkClipboard* _tmp10_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp1_ = self->priv->from_entry;
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		GtkTextView* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->to_entry;
		g_object_get ((GtkWidget*) _tmp4_, "has-focus", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		_tmp0_ = !_tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp7_ = gdk_display_get_default ();
	_tmp8_ = gdk_display_get_clipboard (_tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_data5_->clipboard = _tmp9_;
	_tmp10_ = _data5_->clipboard;
	gdk_clipboard_read_text_async (_tmp10_, NULL, ___lambda4__gasync_ready_callback, block5_data_ref (_data5_));
	block5_data_unref (_data5_);
	_data5_ = NULL;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

static void
math_converter_on_paste (MathConverter* self,
                         const gchar* text)
{
	g_return_if_fail (self != NULL);
	if (text != NULL) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = string_delimit (text, "\n", ' ');
		_tmp1_ = _tmp0_;
		math_converter_insert_text (self, _tmp1_, TRUE);
		_g_free0 (_tmp1_);
	}
}

gboolean
math_converter_refresh_rates (MathConverter* self)
{
	CurrencyManager* _tmp0_;
	CurrencyManager* _tmp1_;
	GtkStack* _tmp2_;
	GtkSelectionModel* _tmp3_;
	GtkSelectionModel* _tmp4_;
	GtkSelectionModel* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = currency_manager_get_default (TRUE, TRUE);
	_tmp1_ = _tmp0_;
	currency_manager_refresh_async (_tmp1_, TRUE);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->status_stack;
	_tmp3_ = gtk_stack_get_pages (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gtk_selection_model_select_item (_tmp5_, (guint) 1, TRUE);
	_g_object_unref0 (_tmp5_);
	result = TRUE;
	return result;
}

static gboolean
_math_converter_refresh_rates_gtk_label_activate_link (GtkLabel* _sender,
                                                       const gchar* uri,
                                                       gpointer self)
{
	gboolean result;
	result = math_converter_refresh_rates ((MathConverter*) self);
	return result;
}

static void
math_converter_update_visibility (MathConverter* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category;
	if (g_strcmp0 (_tmp0_, "currency") != 0) {
		math_converter_set_box_visible (self, TRUE);
	} else {
		CurrencyManager* _tmp1_;
		CurrencyManager* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = currency_manager_get_default (TRUE, TRUE);
		_tmp2_ = _tmp1_;
		_tmp3_ = currency_manager_get_loaded (_tmp2_);
		_tmp4_ = _tmp3_;
		math_converter_set_box_visible (self, _tmp4_);
		_g_object_unref0 (_tmp2_);
		_tmp5_ = self->priv->_box_visible;
		if (_tmp5_) {
			GtkStack* _tmp6_;
			GtkSelectionModel* _tmp7_;
			GtkSelectionModel* _tmp8_;
			GtkSelectionModel* _tmp9_;
			_tmp6_ = self->priv->status_stack;
			_tmp7_ = gtk_stack_get_pages (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			gtk_selection_model_select_item (_tmp9_, (guint) 0, TRUE);
			_g_object_unref0 (_tmp9_);
		}
	}
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		MathConverter* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->currency_manager);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static gint
___lambda6_ (Block6Data* _data6_,
             GObject* a,
             GObject* b)
{
	MathConverter* self;
	gboolean a_is_favorite = FALSE;
	CurrencyManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean b_is_favorite = FALSE;
	CurrencyManager* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint result;
	self = _data6_->self;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _data6_->currency_manager;
	_tmp1_ = unit_get_name (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_UNIT, Unit));
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = currency_manager_is_favorite (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	a_is_favorite = _tmp4_;
	_tmp5_ = _data6_->currency_manager;
	_tmp6_ = unit_get_name (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_UNIT, Unit));
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = currency_manager_is_favorite (_tmp5_, _tmp8_);
	_g_free0 (_tmp8_);
	b_is_favorite = _tmp9_;
	if (a_is_favorite) {
		_tmp10_ = !b_is_favorite;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = -1;
		return result;
	}
	if (!a_is_favorite) {
		_tmp11_ = b_is_favorite;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		result = 1;
		return result;
	}
	_tmp12_ = unit_get_name (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_UNIT, Unit));
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = unit_get_name (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_UNIT, Unit));
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = g_ascii_strcasecmp (_tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	result = _tmp18_;
	return result;
}

static gint
____lambda6__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = ___lambda6_ (self, (GObject*) a, (GObject*) b);
	return result;
}

static void
math_converter_build_units_model (MathConverter* self)
{
	Block6Data* _data6_;
	GListStore* unit_model = NULL;
	GListStore* _tmp0_;
	GtkExpression* expression = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GtkDropDown* _tmp7_;
	GtkExpression* _tmp8_;
	GtkDropDown* _tmp9_;
	GtkExpression* _tmp10_;
	const gchar* _tmp11_;
	CurrencyManager* _tmp16_;
	UnitCategory* c = NULL;
	UnitManager* _tmp17_;
	UnitManager* _tmp18_;
	const gchar* _tmp19_;
	UnitCategory* _tmp20_;
	UnitCategory* _tmp21_;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	gboolean _tmp43_ = FALSE;
	const gchar* _tmp44_;
	guint model_size = 0U;
	GListStore* _tmp46_;
	GtkDropDown* _tmp47_;
	GListStore* _tmp48_;
	GtkDropDown* _tmp49_;
	GtkDropDown* _tmp50_;
	GListStore* _tmp51_;
	GtkDropDown* _tmp52_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = g_list_store_new (TYPE_UNIT);
	unit_model = _tmp0_;
	expression = NULL;
	_tmp2_ = self->priv->category;
	if (g_strcmp0 (_tmp2_, "currency") != 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_currency_display == CURRENCY_DISPLAY_NAME;
	}
	if (_tmp1_) {
		GtkPropertyExpression* _tmp3_;
		_tmp3_ = (GtkPropertyExpression*) gtk_property_expression_new (TYPE_UNIT, NULL, "display_name");
		_gtk_expression_unref0 (expression);
		expression = (GtkExpression*) _tmp3_;
	} else {
		if (self->priv->_currency_display == CURRENCY_DISPLAY_CODE) {
			GtkPropertyExpression* _tmp4_;
			_tmp4_ = (GtkPropertyExpression*) gtk_property_expression_new (TYPE_UNIT, NULL, "name");
			_gtk_expression_unref0 (expression);
			expression = (GtkExpression*) _tmp4_;
		} else {
			GtkExpression** _tmp5_;
			GtkCClosureExpression* _tmp6_;
			_tmp5_ = g_new0 (GtkExpression*, 0 + 1);
			_tmp6_ = (GtkCClosureExpression*) gtk_cclosure_expression_new (G_TYPE_STRING, NULL, 0, _tmp5_, (GCallback) math_converter_currency_item, NULL, NULL);
			_gtk_expression_unref0 (expression);
			expression = (GtkExpression*) _tmp6_;
		}
	}
	_tmp7_ = self->priv->from_combo;
	_tmp8_ = expression;
	gtk_drop_down_set_expression (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->to_combo;
	_tmp10_ = expression;
	gtk_drop_down_set_expression (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->category;
	if (g_strcmp0 (_tmp11_, "currency") == 0) {
		GtkDropDown* _tmp12_;
		GtkSignalListItemFactory* _tmp13_;
		GtkDropDown* _tmp14_;
		GtkSignalListItemFactory* _tmp15_;
		_tmp12_ = self->priv->from_combo;
		_tmp13_ = self->priv->from_currency_factory;
		gtk_drop_down_set_list_factory (_tmp12_, (GtkListItemFactory*) _tmp13_);
		_tmp14_ = self->priv->to_combo;
		_tmp15_ = self->priv->to_currency_factory;
		gtk_drop_down_set_list_factory (_tmp14_, (GtkListItemFactory*) _tmp15_);
	}
	_tmp16_ = currency_manager_get_default (TRUE, TRUE);
	_data6_->currency_manager = _tmp16_;
	_tmp17_ = unit_manager_get_default ();
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->category;
	_tmp20_ = unit_manager_get_category (_tmp18_, _tmp19_);
	_tmp21_ = _tmp20_;
	_g_object_unref0 (_tmp18_);
	c = _tmp21_;
	_tmp23_ = self->priv->category;
	if (g_strcmp0 (_tmp23_, "currency") != 0) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = self->priv->_currency_display != CURRENCY_DISPLAY_NAME;
	}
	if (_tmp22_) {
		UnitCategory* _tmp24_;
		GList* _tmp25_;
		_tmp24_ = c;
		_tmp25_ = unit_category_get_units (_tmp24_);
		{
			GList* unit_collection = NULL;
			GList* unit_it = NULL;
			unit_collection = _tmp25_;
			for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
				Unit* _tmp26_;
				Unit* unit = NULL;
				_tmp26_ = _g_object_ref0 ((Unit*) unit_it->data);
				unit = _tmp26_;
				{
					GListStore* _tmp27_;
					Unit* _tmp28_;
					_tmp27_ = unit_model;
					_tmp28_ = unit;
					g_list_store_append (_tmp27_, (GObject*) _tmp28_);
					_g_object_unref0 (unit);
				}
			}
		}
	} else {
		gint i = 0;
		UnitCategory* _tmp29_;
		GList* _tmp30_;
		i = 0;
		_tmp29_ = c;
		_tmp30_ = unit_category_get_units (_tmp29_);
		{
			GList* unit_collection = NULL;
			GList* unit_it = NULL;
			unit_collection = _tmp30_;
			for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
				Unit* _tmp31_;
				Unit* unit = NULL;
				_tmp31_ = _g_object_ref0 ((Unit*) unit_it->data);
				unit = _tmp31_;
				{
					CurrencyManager* _tmp32_;
					Unit* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gboolean _tmp37_;
					_tmp32_ = _data6_->currency_manager;
					_tmp33_ = unit;
					_tmp34_ = unit_get_name (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = _tmp35_;
					_tmp37_ = currency_manager_is_favorite (_tmp32_, _tmp36_);
					_g_free0 (_tmp36_);
					if (_tmp37_) {
						GListStore* _tmp38_;
						Unit* _tmp39_;
						gint _tmp40_;
						_tmp38_ = unit_model;
						_tmp39_ = unit;
						g_list_store_insert (_tmp38_, (guint) i, (GObject*) _tmp39_);
						_tmp40_ = i;
						i = _tmp40_ + 1;
					} else {
						GListStore* _tmp41_;
						Unit* _tmp42_;
						_tmp41_ = unit_model;
						_tmp42_ = unit;
						g_list_store_append (_tmp41_, (GObject*) _tmp42_);
					}
					_g_object_unref0 (unit);
				}
			}
		}
	}
	_tmp44_ = self->priv->category;
	if (g_strcmp0 (_tmp44_, "currency") == 0) {
		_tmp43_ = self->priv->_currency_display != CURRENCY_DISPLAY_NAME;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		GListStore* _tmp45_;
		_tmp45_ = unit_model;
		g_list_store_sort (_tmp45_, ____lambda6__gcompare_data_func, _data6_);
	}
	_tmp46_ = unit_model;
	model_size = g_list_model_get_n_items ((GListModel*) _tmp46_);
	_tmp47_ = self->priv->to_combo;
	_tmp48_ = unit_model;
	gtk_drop_down_set_model (_tmp47_, (GListModel*) _tmp48_);
	_tmp49_ = self->priv->to_combo;
	gtk_drop_down_set_enable_search (_tmp49_, model_size > ((guint) 10));
	_tmp50_ = self->priv->from_combo;
	_tmp51_ = unit_model;
	gtk_drop_down_set_model (_tmp50_, (GListModel*) _tmp51_);
	_tmp52_ = self->priv->from_combo;
	gtk_drop_down_set_enable_search (_tmp52_, model_size > ((guint) 10));
	_g_object_unref0 (c);
	_gtk_expression_unref0 (expression);
	_g_object_unref0 (unit_model);
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static gchar*
math_converter_currency_item (Unit* unit)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (unit != NULL, NULL);
	_tmp0_ = unit_get_name (unit);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = unit_get_display_name (unit);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%s (%s)", _tmp2_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp7_;
	return result;
}

static void
math_converter_setup_currency (MathConverter* self,
                               GObject* item)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkImage* _tmp1_;
	GtkImage* _tmp2_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkImage* _tmp5_;
	GtkImage* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("starred-symbolic");
	g_object_ref_sink (_tmp1_);
	_tmp2_ = _tmp1_;
	gtk_box_append (box, (GtkWidget*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp3_);
	label = _tmp3_;
	_tmp4_ = _g_object_ref0 (label);
	g_object_set_data_full (item, "label", _tmp4_, g_object_unref);
	gtk_box_append (box, (GtkWidget*) label);
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("object-select-symbolic");
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	gtk_box_append (box, (GtkWidget*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	gtk_list_item_set_child (G_TYPE_CHECK_INSTANCE_TYPE (item, gtk_list_item_get_type ()) ? ((GtkListItem*) item) : NULL, (GtkWidget*) box);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		MathConverter* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->unit);
		_g_object_unref0 (_data7_->box);
		_g_object_unref0 (_data7_->combo);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda9_ (Block7Data* _data7_)
{
	MathConverter* self;
	gint _tmp0_ = 0;
	GObject* _tmp1_;
	GObject* _tmp2_;
	Unit* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	self = _data7_->self;
	_tmp1_ = gtk_drop_down_get_selected_item (_data7_->combo);
	_tmp2_ = _tmp1_;
	_tmp3_ = _data7_->unit;
	if (_tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_OBJECT, GObject)) {
		_tmp0_ = 1;
	} else {
		_tmp0_ = 0;
	}
	_tmp4_ = _data7_->box;
	_tmp5_ = gtk_widget_get_last_child (_tmp4_);
	gtk_widget_set_opacity (_tmp5_, (gdouble) _tmp0_);
}

static void
___lambda9__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda9_ (self);
}

static void
math_converter_bind_currency (MathConverter* self,
                              GObject* item,
                              GtkDropDown* combo)
{
	Block7Data* _data7_;
	GtkDropDown* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	Unit* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	CurrencyManager* _tmp9_;
	CurrencyManager* _tmp10_;
	Unit* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gulong handler = 0UL;
	gulong _tmp29_;
	gint _tmp30_ = 0;
	GObject* _tmp31_;
	GObject* _tmp32_;
	Unit* _tmp33_;
	GtkWidget* _tmp34_;
	GtkWidget* _tmp35_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (combo != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (combo);
	_g_object_unref0 (_data7_->combo);
	_data7_->combo = _tmp0_;
	_tmp1_ = gtk_list_item_get_child (G_TYPE_CHECK_INSTANCE_TYPE (item, gtk_list_item_get_type ()) ? ((GtkListItem*) item) : NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_data7_->box = _tmp3_;
	_tmp4_ = gtk_list_item_get_item (G_TYPE_CHECK_INSTANCE_TYPE (item, gtk_list_item_get_type ()) ? ((GtkListItem*) item) : NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, TYPE_UNIT) ? ((Unit*) _tmp5_) : NULL);
	_data7_->unit = _tmp6_;
	_tmp7_ = _data7_->box;
	_tmp8_ = gtk_widget_get_first_child (_tmp7_);
	_tmp9_ = currency_manager_get_default (TRUE, TRUE);
	_tmp10_ = _tmp9_;
	_tmp11_ = _data7_->unit;
	_tmp12_ = unit_get_name (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	gtk_widget_set_visible (_tmp8_, currency_manager_is_favorite (_tmp10_, _tmp14_));
	_g_free0 (_tmp14_);
	_g_object_unref0 (_tmp10_);
	switch (self->priv->_currency_display) {
		case CURRENCY_DISPLAY_CODE:
		{
			gconstpointer _tmp15_;
			Unit* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp15_ = g_object_get_data (item, "label");
			_tmp16_ = _data7_->unit;
			_tmp17_ = unit_get_name (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = _tmp18_;
			gtk_label_set_label ((GtkLabel*) _tmp15_, _tmp19_);
			_g_free0 (_tmp19_);
			break;
		}
		case CURRENCY_DISPLAY_BOTH:
		{
			gconstpointer _tmp20_;
			Unit* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp20_ = g_object_get_data (item, "label");
			_tmp21_ = _data7_->unit;
			_tmp22_ = math_converter_currency_item (_tmp21_);
			_tmp23_ = _tmp22_;
			gtk_label_set_label ((GtkLabel*) _tmp20_, _tmp23_);
			_g_free0 (_tmp23_);
			break;
		}
		default:
		{
			gconstpointer _tmp24_;
			Unit* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp24_ = g_object_get_data (item, "label");
			_tmp25_ = _data7_->unit;
			_tmp26_ = unit_get_display_name (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_;
			gtk_label_set_label ((GtkLabel*) _tmp24_, _tmp28_);
			_g_free0 (_tmp28_);
			break;
		}
	}
	_tmp29_ = g_signal_connect_data ((GObject*) _data7_->combo, "notify::selected", (GCallback) ___lambda9__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	handler = _tmp29_;
	g_object_set_data_full (item, "handler", (gpointer) ((guintptr) handler), NULL);
	_tmp31_ = gtk_drop_down_get_selected_item (_data7_->combo);
	_tmp32_ = _tmp31_;
	_tmp33_ = _data7_->unit;
	if (_tmp32_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, G_TYPE_OBJECT, GObject)) {
		_tmp30_ = 1;
	} else {
		_tmp30_ = 0;
	}
	_tmp34_ = _data7_->box;
	_tmp35_ = gtk_widget_get_last_child (_tmp34_);
	gtk_widget_set_opacity (_tmp35_, (gdouble) _tmp30_);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
math_converter_unbind_currency (MathConverter* self,
                                GObject* item,
                                GtkDropDown* combo)
{
	gconstpointer _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = g_object_get_data (item, "handler");
	g_signal_handler_disconnect ((GObject*) combo, (gulong) ((guintptr) _tmp0_));
}

static gboolean
math_converter_set_active_unit (MathConverter* self,
                                GtkDropDown* combo,
                                Unit* unit)
{
	guint position = 0U;
	GListStore* model = NULL;
	GListModel* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	guint _tmp3_ = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (combo != NULL, FALSE);
	g_return_val_if_fail (unit != NULL, FALSE);
	position = (guint) 0;
	_tmp0_ = gtk_drop_down_get_model (combo);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_list_store_get_type ()) ? ((GListStore*) _tmp0_) : NULL);
	model = _tmp1_;
	_tmp2_ = model;
	g_list_store_find (_tmp2_, (GObject*) unit, &_tmp3_);
	position = _tmp3_;
	if (position == ((guint) -1)) {
		result = FALSE;
		_g_object_unref0 (model);
		return result;
	}
	gtk_drop_down_set_selected (combo, position);
	result = TRUE;
	_g_object_unref0 (model);
	return result;
}

static void
math_converter_category_combobox_changed_cb (MathConverter* self)
{
	UnitCategory* category = NULL;
	GtkDropDown* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	UnitCategory* _tmp3_;
	UnitCategory* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* source_unit = NULL;
	GHashTable* _tmp8_;
	UnitCategory* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gconstpointer _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* target_unit = NULL;
	GHashTable* _tmp16_;
	UnitCategory* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gconstpointer _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp32_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category_combo;
	_tmp1_ = gtk_drop_down_get_selected_item (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_UNIT_CATEGORY) ? ((UnitCategory*) _tmp2_) : NULL);
	category = _tmp3_;
	_tmp4_ = category;
	_tmp5_ = unit_category_get_name (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (self->priv->category);
	self->priv->category = _tmp6_;
	math_converter_update_visibility (self);
	if (self->priv->from_combobox_changed > ((gulong) 0)) {
		GtkDropDown* _tmp7_;
		_tmp7_ = self->priv->from_combo;
		g_signal_handler_block (_tmp7_, self->priv->from_combobox_changed);
	}
	_tmp8_ = self->priv->_source_units;
	_tmp9_ = category;
	_tmp10_ = unit_category_get_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp13_ = g_hash_table_lookup (_tmp8_, _tmp12_);
	_tmp14_ = g_strdup ((const gchar*) _tmp13_);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp12_);
	source_unit = _tmp15_;
	_tmp16_ = self->priv->_target_units;
	_tmp17_ = category;
	_tmp18_ = unit_category_get_name (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = g_hash_table_lookup (_tmp16_, _tmp20_);
	_tmp22_ = g_strdup ((const gchar*) _tmp21_);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp20_);
	target_unit = _tmp23_;
	math_converter_build_units_model (self);
	_tmp24_ = source_unit;
	if (_tmp24_ == NULL) {
		GtkDropDown* _tmp25_;
		_tmp25_ = self->priv->from_combo;
		gtk_drop_down_set_selected (_tmp25_, (guint) 0);
	} else {
		GtkDropDown* _tmp26_;
		UnitManager* _tmp27_;
		UnitManager* _tmp28_;
		const gchar* _tmp29_;
		Unit* _tmp30_;
		Unit* _tmp31_;
		_tmp26_ = self->priv->from_combo;
		_tmp27_ = unit_manager_get_default ();
		_tmp28_ = _tmp27_;
		_tmp29_ = source_unit;
		_tmp30_ = unit_manager_get_unit_by_name (_tmp28_, _tmp29_);
		_tmp31_ = _tmp30_;
		math_converter_set_active_unit (self, _tmp26_, _tmp31_);
		_g_object_unref0 (_tmp31_);
		_g_object_unref0 (_tmp28_);
	}
	_tmp32_ = target_unit;
	if (_tmp32_ == NULL) {
		GtkDropDown* _tmp33_;
		_tmp33_ = self->priv->to_combo;
		gtk_drop_down_set_selected (_tmp33_, (guint) 0);
	} else {
		GtkDropDown* _tmp34_;
		UnitManager* _tmp35_;
		UnitManager* _tmp36_;
		const gchar* _tmp37_;
		Unit* _tmp38_;
		Unit* _tmp39_;
		_tmp34_ = self->priv->to_combo;
		_tmp35_ = unit_manager_get_default ();
		_tmp36_ = _tmp35_;
		_tmp37_ = target_unit;
		_tmp38_ = unit_manager_get_unit_by_name (_tmp36_, _tmp37_);
		_tmp39_ = _tmp38_;
		math_converter_set_active_unit (self, _tmp34_, _tmp39_);
		_g_object_unref0 (_tmp39_);
		_g_object_unref0 (_tmp36_);
	}
	if (self->priv->from_combobox_changed > ((gulong) 0)) {
		GtkDropDown* _tmp40_;
		_tmp40_ = self->priv->from_combo;
		g_signal_handler_unblock (_tmp40_, self->priv->from_combobox_changed);
	}
	math_converter_to_combobox_changed_cb (self);
	math_converter_reformat_from_entry (self);
	_g_free0 (target_unit);
	_g_free0 (source_unit);
	_g_object_unref0 (category);
}

static void
_math_converter_category_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	math_converter_category_combobox_changed_cb ((MathConverter*) self);
}

static void
math_converter_from_combobox_changed_cb (MathConverter* self)
{
	Number* _tmp0_;
	Unit* source_unit = NULL;
	Unit* target_unit = NULL;
	Number* _tmp1_;
	Unit* _tmp2_ = NULL;
	Unit* _tmp3_ = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	GtkTextView* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextView* _tmp10_;
	MathEquation* _tmp11_;
	Serializer* _tmp12_;
	Serializer* _tmp13_;
	GtkTextView* _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* _tmp16_;
	GHashTable* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	Unit* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->to_number;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->to_number;
	_tmp4_ = math_converter_convert_equation (self, _tmp1_, &_tmp2_, &_tmp3_);
	_g_object_unref0 (source_unit);
	source_unit = _tmp2_;
	_g_object_unref0 (target_unit);
	target_unit = _tmp3_;
	_g_object_unref0 (self->priv->from_number);
	self->priv->from_number = _tmp4_;
	_tmp5_ = self->priv->from_number;
	if (_tmp5_ == NULL) {
		Number* _tmp6_;
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		_g_object_unref0 (self->priv->from_number);
		self->priv->from_number = _tmp6_;
	}
	_tmp7_ = self->priv->from_entry;
	_tmp8_ = gtk_text_view_get_buffer (_tmp7_);
	_tmp9_ = _tmp8_;
	g_signal_handler_block (_tmp9_, self->priv->from_entry_changed);
	_tmp10_ = self->priv->from_entry;
	_tmp11_ = self->priv->_equation;
	_tmp12_ = math_equation_get_serializer (_tmp11_);
	_tmp13_ = _tmp12_;
	math_converter_update_entry (self, _tmp10_, _tmp13_);
	_tmp14_ = self->priv->from_entry;
	_tmp15_ = gtk_text_view_get_buffer (_tmp14_);
	_tmp16_ = _tmp15_;
	g_signal_handler_unblock (_tmp16_, self->priv->from_entry_changed);
	_tmp17_ = self->priv->_source_units;
	_tmp18_ = self->priv->category;
	_tmp19_ = g_strdup (_tmp18_);
	_tmp20_ = source_unit;
	_tmp21_ = unit_get_name (_tmp20_);
	_tmp22_ = _tmp21_;
	g_hash_table_insert (_tmp17_, _tmp19_, _tmp22_);
	g_signal_emit (self, math_converter_signals[MATH_CONVERTER_CHANGED_SIGNAL], 0);
	_g_object_unref0 (target_unit);
	_g_object_unref0 (source_unit);
}

static void
math_converter_to_combobox_changed_cb (MathConverter* self)
{
	Number* _tmp0_;
	Unit* source_unit = NULL;
	Unit* target_unit = NULL;
	Number* _tmp1_;
	Unit* _tmp2_ = NULL;
	Unit* _tmp3_ = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	GtkTextView* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextView* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GtkTextView* _tmp19_;
	GtkTextBuffer* _tmp20_;
	GtkTextBuffer* _tmp21_;
	GHashTable* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	Unit* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->from_number;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->from_number;
	_tmp4_ = math_converter_convert_equation (self, _tmp1_, &_tmp2_, &_tmp3_);
	_g_object_unref0 (source_unit);
	source_unit = _tmp2_;
	_g_object_unref0 (target_unit);
	target_unit = _tmp3_;
	_g_object_unref0 (self->priv->to_number);
	self->priv->to_number = _tmp4_;
	_tmp5_ = self->priv->to_number;
	if (_tmp5_ == NULL) {
		Number* _tmp6_;
		_tmp6_ = number_new_integer ((gint64) 0, (gint64) 0);
		_g_object_unref0 (self->priv->to_number);
		self->priv->to_number = _tmp6_;
	}
	_tmp7_ = self->priv->to_entry;
	_tmp8_ = gtk_text_view_get_buffer (_tmp7_);
	_tmp9_ = _tmp8_;
	g_signal_handler_block (_tmp9_, self->priv->to_entry_changed);
	_tmp10_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp10_, "has-focus", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		GtkTextView* _tmp13_;
		Serializer* _tmp14_;
		_tmp13_ = self->priv->to_entry;
		_tmp14_ = self->priv->fixed_serializer;
		math_converter_update_entry (self, _tmp13_, _tmp14_);
	} else {
		GtkTextView* _tmp15_;
		MathEquation* _tmp16_;
		Serializer* _tmp17_;
		Serializer* _tmp18_;
		_tmp15_ = self->priv->to_entry;
		_tmp16_ = self->priv->_equation;
		_tmp17_ = math_equation_get_serializer (_tmp16_);
		_tmp18_ = _tmp17_;
		math_converter_update_entry (self, _tmp15_, _tmp18_);
	}
	_tmp19_ = self->priv->to_entry;
	_tmp20_ = gtk_text_view_get_buffer (_tmp19_);
	_tmp21_ = _tmp20_;
	g_signal_handler_unblock (_tmp21_, self->priv->to_entry_changed);
	_tmp22_ = self->priv->_target_units;
	_tmp23_ = self->priv->category;
	_tmp24_ = g_strdup (_tmp23_);
	_tmp25_ = target_unit;
	_tmp26_ = unit_get_name (_tmp25_);
	_tmp27_ = _tmp26_;
	g_hash_table_insert (_tmp22_, _tmp24_, _tmp27_);
	g_signal_emit (self, math_converter_signals[MATH_CONVERTER_CHANGED_SIGNAL], 0);
	_g_object_unref0 (target_unit);
	_g_object_unref0 (source_unit);
}

static void
_math_converter_to_combobox_changed_cb_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	math_converter_to_combobox_changed_cb ((MathConverter*) self);
}

static void
math_converter_from_entry_focus_cb (MathConverter* self)
{
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextView* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkTextView* _tmp16_;
	GtkTextBuffer* _tmp17_;
	GtkTextBuffer* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->from_entry;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_handler_block (_tmp2_, self->priv->from_entry_changed);
	_tmp3_ = self->priv->from_entry;
	g_object_get ((GtkWidget*) _tmp3_, "has-focus", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		GtkTextView* _tmp6_;
		Serializer* _tmp7_;
		_tmp6_ = self->priv->from_entry;
		_tmp7_ = self->priv->fixed_serializer;
		math_converter_update_entry (self, _tmp6_, _tmp7_);
	} else {
		GtkTextView* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		GtkTextView* _tmp12_;
		MathEquation* _tmp13_;
		Serializer* _tmp14_;
		Serializer* _tmp15_;
		_tmp8_ = self->priv->from_entry;
		_tmp9_ = math_converter_get_number_from_entry (self, _tmp8_);
		_g_object_unref0 (self->priv->from_number);
		self->priv->from_number = _tmp9_;
		_tmp10_ = self->priv->from_number;
		if (_tmp10_ == NULL) {
			Number* _tmp11_;
			_tmp11_ = number_new_integer ((gint64) 0, (gint64) 0);
			_g_object_unref0 (self->priv->from_number);
			self->priv->from_number = _tmp11_;
			math_converter_to_combobox_changed_cb (self);
		}
		_tmp12_ = self->priv->from_entry;
		_tmp13_ = self->priv->_equation;
		_tmp14_ = math_equation_get_serializer (_tmp13_);
		_tmp15_ = _tmp14_;
		math_converter_update_entry (self, _tmp12_, _tmp15_);
	}
	_tmp16_ = self->priv->from_entry;
	_tmp17_ = gtk_text_view_get_buffer (_tmp16_);
	_tmp18_ = _tmp17_;
	g_signal_handler_unblock (_tmp18_, self->priv->from_entry_changed);
	g_signal_emit (self, math_converter_signals[MATH_CONVERTER_CHANGED_SIGNAL], 0);
}

static void
_math_converter_from_entry_focus_cb_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	math_converter_from_entry_focus_cb ((MathConverter*) self);
}

static void
math_converter_to_entry_focus_cb (MathConverter* self)
{
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextView* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GtkTextView* _tmp16_;
	GtkTextBuffer* _tmp17_;
	GtkTextBuffer* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->to_entry;
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	g_signal_handler_block (_tmp2_, self->priv->to_entry_changed);
	_tmp3_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp3_, "has-focus", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		GtkTextView* _tmp6_;
		Serializer* _tmp7_;
		_tmp6_ = self->priv->to_entry;
		_tmp7_ = self->priv->fixed_serializer;
		math_converter_update_entry (self, _tmp6_, _tmp7_);
	} else {
		GtkTextView* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		GtkTextView* _tmp12_;
		MathEquation* _tmp13_;
		Serializer* _tmp14_;
		Serializer* _tmp15_;
		_tmp8_ = self->priv->to_entry;
		_tmp9_ = math_converter_get_number_from_entry (self, _tmp8_);
		_g_object_unref0 (self->priv->to_number);
		self->priv->to_number = _tmp9_;
		_tmp10_ = self->priv->to_number;
		if (_tmp10_ == NULL) {
			Number* _tmp11_;
			_tmp11_ = number_new_integer ((gint64) 0, (gint64) 0);
			_g_object_unref0 (self->priv->to_number);
			self->priv->to_number = _tmp11_;
			math_converter_from_combobox_changed_cb (self);
		}
		_tmp12_ = self->priv->to_entry;
		_tmp13_ = self->priv->_equation;
		_tmp14_ = math_equation_get_serializer (_tmp13_);
		_tmp15_ = _tmp14_;
		math_converter_update_entry (self, _tmp12_, _tmp15_);
	}
	_tmp16_ = self->priv->to_entry;
	_tmp17_ = gtk_text_view_get_buffer (_tmp16_);
	_tmp18_ = _tmp17_;
	g_signal_handler_unblock (_tmp18_, self->priv->to_entry_changed);
	g_signal_emit (self, math_converter_signals[MATH_CONVERTER_CHANGED_SIGNAL], 0);
}

static void
_math_converter_to_entry_focus_cb_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	math_converter_to_entry_focus_cb ((MathConverter*) self);
}

static void
math_converter_from_entry_changed_cb (MathConverter* self)
{
	GtkTextView* _tmp0_;
	Number* _tmp1_;
	gboolean _error_ = FALSE;
	Number* _tmp2_;
	Unit* source_unit = NULL;
	Unit* target_unit = NULL;
	Number* _tmp4_;
	Unit* _tmp5_ = NULL;
	Unit* _tmp6_ = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	GtkTextView* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextView* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	GtkTextView* _tmp25_;
	GtkTextBuffer* _tmp26_;
	GtkTextBuffer* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->from_entry;
	_tmp1_ = math_converter_get_number_from_entry (self, _tmp0_);
	_g_object_unref0 (self->priv->from_number);
	self->priv->from_number = _tmp1_;
	_tmp2_ = self->priv->from_number;
	_error_ = _tmp2_ == NULL;
	if (_error_) {
		Number* _tmp3_;
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		_g_object_unref0 (self->priv->from_number);
		self->priv->from_number = _tmp3_;
	}
	_tmp4_ = self->priv->from_number;
	_tmp7_ = math_converter_convert_equation (self, _tmp4_, &_tmp5_, &_tmp6_);
	_g_object_unref0 (source_unit);
	source_unit = _tmp5_;
	_g_object_unref0 (target_unit);
	target_unit = _tmp6_;
	_g_object_unref0 (self->priv->to_number);
	self->priv->to_number = _tmp7_;
	_tmp8_ = self->priv->to_number;
	if (_tmp8_ == NULL) {
		Number* _tmp9_;
		_tmp9_ = number_new_integer ((gint64) 0, (gint64) 0);
		_g_object_unref0 (self->priv->to_number);
		self->priv->to_number = _tmp9_;
	}
	_tmp10_ = self->priv->to_entry;
	_tmp11_ = gtk_text_view_get_buffer (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_handler_block (_tmp12_, self->priv->to_entry_changed);
	_tmp13_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp13_, "has-focus", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		GtkTextView* _tmp16_;
		Serializer* _tmp17_;
		_tmp16_ = self->priv->to_entry;
		_tmp17_ = self->priv->fixed_serializer;
		math_converter_update_entry (self, _tmp16_, _tmp17_);
	} else {
		if (!_error_) {
			GtkTextView* _tmp18_;
			MathEquation* _tmp19_;
			Serializer* _tmp20_;
			Serializer* _tmp21_;
			_tmp18_ = self->priv->to_entry;
			_tmp19_ = self->priv->_equation;
			_tmp20_ = math_equation_get_serializer (_tmp19_);
			_tmp21_ = _tmp20_;
			math_converter_update_entry (self, _tmp18_, _tmp21_);
		} else {
			GtkTextView* _tmp22_;
			GtkTextBuffer* _tmp23_;
			GtkTextBuffer* _tmp24_;
			_tmp22_ = self->priv->to_entry;
			_tmp23_ = gtk_text_view_get_buffer (_tmp22_);
			_tmp24_ = _tmp23_;
			g_object_set (_tmp24_, "text", _ ("Error"), NULL);
		}
	}
	_tmp25_ = self->priv->to_entry;
	_tmp26_ = gtk_text_view_get_buffer (_tmp25_);
	_tmp27_ = _tmp26_;
	g_signal_handler_unblock (_tmp27_, self->priv->to_entry_changed);
	_g_object_unref0 (target_unit);
	_g_object_unref0 (source_unit);
}

static void
math_converter_to_entry_changed_cb (MathConverter* self)
{
	GtkTextView* _tmp0_;
	Number* _tmp1_;
	gboolean _error_ = FALSE;
	Number* _tmp2_;
	Unit* source_unit = NULL;
	Unit* target_unit = NULL;
	Number* _tmp4_;
	Unit* _tmp5_ = NULL;
	Unit* _tmp6_ = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	GtkTextView* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextView* _tmp20_;
	GtkTextBuffer* _tmp21_;
	GtkTextBuffer* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->to_entry;
	_tmp1_ = math_converter_get_number_from_entry (self, _tmp0_);
	_g_object_unref0 (self->priv->to_number);
	self->priv->to_number = _tmp1_;
	_tmp2_ = self->priv->to_number;
	_error_ = _tmp2_ == NULL;
	if (_error_) {
		Number* _tmp3_;
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		_g_object_unref0 (self->priv->to_number);
		self->priv->to_number = _tmp3_;
	}
	_tmp4_ = self->priv->to_number;
	_tmp7_ = math_converter_convert_equation (self, _tmp4_, &_tmp5_, &_tmp6_);
	_g_object_unref0 (source_unit);
	source_unit = _tmp5_;
	_g_object_unref0 (target_unit);
	target_unit = _tmp6_;
	_g_object_unref0 (self->priv->from_number);
	self->priv->from_number = _tmp7_;
	_tmp8_ = self->priv->from_number;
	if (_tmp8_ == NULL) {
		Number* _tmp9_;
		_tmp9_ = number_new_integer ((gint64) 0, (gint64) 0);
		_g_object_unref0 (self->priv->from_number);
		self->priv->from_number = _tmp9_;
	}
	_tmp10_ = self->priv->from_entry;
	_tmp11_ = gtk_text_view_get_buffer (_tmp10_);
	_tmp12_ = _tmp11_;
	g_signal_handler_block (_tmp12_, self->priv->from_entry_changed);
	if (!_error_) {
		GtkTextView* _tmp13_;
		MathEquation* _tmp14_;
		Serializer* _tmp15_;
		Serializer* _tmp16_;
		_tmp13_ = self->priv->from_entry;
		_tmp14_ = self->priv->_equation;
		_tmp15_ = math_equation_get_serializer (_tmp14_);
		_tmp16_ = _tmp15_;
		math_converter_update_entry (self, _tmp13_, _tmp16_);
	} else {
		GtkTextView* _tmp17_;
		GtkTextBuffer* _tmp18_;
		GtkTextBuffer* _tmp19_;
		_tmp17_ = self->priv->from_entry;
		_tmp18_ = gtk_text_view_get_buffer (_tmp17_);
		_tmp19_ = _tmp18_;
		g_object_set (_tmp19_, "text", _ ("Error"), NULL);
	}
	_tmp20_ = self->priv->from_entry;
	_tmp21_ = gtk_text_view_get_buffer (_tmp20_);
	_tmp22_ = _tmp21_;
	g_signal_handler_unblock (_tmp22_, self->priv->from_entry_changed);
	_g_object_unref0 (target_unit);
	_g_object_unref0 (source_unit);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static Number*
math_converter_get_number_from_entry (MathConverter* self,
                                      GtkTextView* entry)
{
	gchar* str = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	Serializer* _tmp7_;
	gint number_base = 0;
	const gchar* _tmp13_;
	const gchar* _tmp25_;
	const gchar* _tmp48_;
	Number* _tmp49_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry != NULL, NULL);
	_tmp0_ = gtk_text_view_get_buffer (entry);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "text", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = string_strip (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	str = _tmp6_;
	_tmp7_ = self->priv->fixed_serializer;
	if (serializer_get_radix (_tmp7_) != ((gunichar) '.')) {
		const gchar* _tmp8_;
		Serializer* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp8_ = str;
		_tmp9_ = self->priv->fixed_serializer;
		_tmp10_ = g_unichar_to_string (serializer_get_radix (_tmp9_));
		_tmp11_ = _tmp10_;
		_tmp12_ = string_replace (_tmp8_, _tmp11_, ".");
		_g_free0 (str);
		str = _tmp12_;
		_g_free0 (_tmp11_);
	}
	number_base = 10;
	_tmp13_ = self->priv->category;
	if (g_strcmp0 (_tmp13_, "numberbase") == 0) {
		GtkDropDown* _tmp14_ = NULL;
		GtkTextView* _tmp15_;
		GtkDropDown* combo = NULL;
		GtkDropDown* _tmp18_;
		GtkDropDown* _tmp19_;
		GObject* _tmp20_;
		GObject* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp15_ = self->priv->from_entry;
		if (entry == _tmp15_) {
			GtkDropDown* _tmp16_;
			_tmp16_ = self->priv->from_combo;
			_tmp14_ = _tmp16_;
		} else {
			GtkDropDown* _tmp17_;
			_tmp17_ = self->priv->to_combo;
			_tmp14_ = _tmp17_;
		}
		_tmp18_ = _g_object_ref0 (_tmp14_);
		combo = _tmp18_;
		_tmp19_ = combo;
		_tmp20_ = gtk_drop_down_get_selected_item (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = unit_get_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, TYPE_UNIT) ? ((Unit*) _tmp21_) : NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = _tmp23_;
		number_base = atoi (_tmp24_);
		_g_free0 (_tmp24_);
		_g_object_unref0 (combo);
	}
	_tmp25_ = str;
	if (g_str_has_suffix (_tmp25_, "π")) {
		const gchar* _tmp26_;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		Number* number = NULL;
		const gchar* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		Number* _tmp40_;
		Number* _tmp41_;
		Number* _tmp42_;
		Number* _tmp43_;
		Number* _tmp44_;
		Number* _tmp45_;
		Number* _tmp46_;
		Number* _tmp47_;
		_tmp26_ = str;
		if (g_strcmp0 (_tmp26_, "π") == 0) {
			Number* _tmp27_;
			_tmp27_ = number_new_pi ();
			result = _tmp27_;
			_g_free0 (str);
			return result;
		}
		_tmp29_ = str;
		if (g_strcmp0 (_tmp29_, "−π") == 0) {
			_tmp28_ = TRUE;
		} else {
			const gchar* _tmp30_;
			_tmp30_ = str;
			_tmp28_ = g_strcmp0 (_tmp30_, "-π") == 0;
		}
		if (_tmp28_) {
			Number* _tmp31_;
			Number* _tmp32_;
			Number* _tmp33_;
			Number* _tmp34_;
			_tmp31_ = number_new_pi ();
			_tmp32_ = _tmp31_;
			_tmp33_ = number_invert_sign (_tmp32_);
			_tmp34_ = _tmp33_;
			_g_object_unref0 (_tmp32_);
			result = _tmp34_;
			_g_free0 (str);
			return result;
		}
		_tmp35_ = str;
		_tmp36_ = strlen ("π");
		_tmp37_ = _tmp36_;
		_tmp38_ = string_slice (_tmp35_, (glong) 0, (glong) (-_tmp37_));
		_tmp39_ = _tmp38_;
		_tmp40_ = mp_set_from_string (_tmp39_, number_base, TRUE);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp39_);
		number = _tmp41_;
		_tmp42_ = number;
		if (_tmp42_ == NULL) {
			result = NULL;
			_g_object_unref0 (number);
			_g_free0 (str);
			return result;
		}
		_tmp43_ = number_new_pi ();
		_tmp44_ = _tmp43_;
		_tmp45_ = number;
		_tmp46_ = number_multiply (_tmp44_, _tmp45_);
		_tmp47_ = _tmp46_;
		_g_object_unref0 (_tmp44_);
		result = _tmp47_;
		_g_object_unref0 (number);
		_g_free0 (str);
		return result;
	}
	_tmp48_ = str;
	_tmp49_ = mp_set_from_string (_tmp48_, number_base, TRUE);
	result = _tmp49_;
	_g_free0 (str);
	return result;
}

static void
math_converter_update_entry (MathConverter* self,
                             GtkTextView* entry,
                             Serializer* serializer)
{
	Number* _tmp0_ = NULL;
	GtkTextView* _tmp1_;
	Number* number = NULL;
	Number* _tmp4_;
	GtkDropDown* _tmp5_ = NULL;
	GtkTextView* _tmp6_;
	GtkDropDown* combo = NULL;
	GtkDropDown* _tmp9_;
	GtkDropDown* _tmp10_;
	GObject* _tmp11_;
	GObject* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	g_return_if_fail (serializer != NULL);
	_tmp1_ = self->priv->from_entry;
	if (entry == _tmp1_) {
		Number* _tmp2_;
		_tmp2_ = self->priv->from_number;
		_tmp0_ = _tmp2_;
	} else {
		Number* _tmp3_;
		_tmp3_ = self->priv->to_number;
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _g_object_ref0 (_tmp0_);
	number = _tmp4_;
	_tmp6_ = self->priv->from_entry;
	if (entry == _tmp6_) {
		GtkDropDown* _tmp7_;
		_tmp7_ = self->priv->from_combo;
		_tmp5_ = _tmp7_;
	} else {
		GtkDropDown* _tmp8_;
		_tmp8_ = self->priv->to_combo;
		_tmp5_ = _tmp8_;
	}
	_tmp9_ = _g_object_ref0 (_tmp5_);
	combo = _tmp9_;
	_tmp10_ = combo;
	_tmp11_ = gtk_drop_down_get_selected_item (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = unit_get_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_UNIT) ? ((Unit*) _tmp12_) : NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strcmp0 (_tmp15_, "dms") == 0;
	_g_free0 (_tmp15_);
	if (_tmp16_) {
		gboolean _tmp17_ = FALSE;
		Serializer* _tmp18_;
		_tmp18_ = self->priv->fixed_serializer;
		if (serializer == _tmp18_) {
			Number* _tmp19_;
			_tmp19_ = number;
			_tmp17_ = number_is_zero (_tmp19_);
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			GtkTextBuffer* _tmp20_;
			GtkTextBuffer* _tmp21_;
			Number* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp20_ = gtk_text_view_get_buffer (entry);
			_tmp21_ = _tmp20_;
			_tmp22_ = number;
			_tmp23_ = serializer_to_string (serializer, _tmp22_);
			_tmp24_ = _tmp23_;
			g_object_set (_tmp21_, "text", _tmp24_, NULL);
			_g_free0 (_tmp24_);
		} else {
			GtkTextBuffer* _tmp25_;
			GtkTextBuffer* _tmp26_;
			Number* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp25_ = gtk_text_view_get_buffer (entry);
			_tmp26_ = _tmp25_;
			_tmp27_ = number;
			_tmp28_ = serializer_to_dms_string (serializer, _tmp27_);
			_tmp29_ = _tmp28_;
			g_object_set (_tmp26_, "text", _tmp29_, NULL);
			_g_free0 (_tmp29_);
		}
	} else {
		const gchar* _tmp30_;
		_tmp30_ = self->priv->category;
		if (g_strcmp0 (_tmp30_, "numberbase") == 0) {
			gint number_base = 0;
			GtkDropDown* _tmp31_;
			GObject* _tmp32_;
			GObject* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gint _tmp37_;
			gint original_base = 0;
			guint original_representation_base = 0U;
			gchar* str = NULL;
			Number* _tmp38_;
			gchar* _tmp39_;
			GtkTextBuffer* _tmp40_;
			GtkTextBuffer* _tmp41_;
			const gchar* _tmp42_;
			_tmp31_ = combo;
			_tmp32_ = gtk_drop_down_get_selected_item (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = unit_get_name (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, TYPE_UNIT) ? ((Unit*) _tmp33_) : NULL);
			_tmp35_ = _tmp34_;
			_tmp36_ = _tmp35_;
			_tmp37_ = atoi (_tmp36_);
			_g_free0 (_tmp36_);
			number_base = _tmp37_;
			original_base = serializer_get_base (serializer);
			original_representation_base = serializer_get_representation_base (serializer);
			serializer_set_base (serializer, number_base);
			serializer_set_representation_base (serializer, (guint) number_base);
			_tmp38_ = number;
			_tmp39_ = serializer_to_string (serializer, _tmp38_);
			str = _tmp39_;
			serializer_set_base (serializer, original_base);
			serializer_set_representation_base (serializer, original_representation_base);
			_tmp40_ = gtk_text_view_get_buffer (entry);
			_tmp41_ = _tmp40_;
			_tmp42_ = str;
			g_object_set (_tmp41_, "text", _tmp42_, NULL);
			_g_free0 (str);
		} else {
			GtkTextBuffer* _tmp43_;
			GtkTextBuffer* _tmp44_;
			Number* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp43_ = gtk_text_view_get_buffer (entry);
			_tmp44_ = _tmp43_;
			_tmp45_ = number;
			_tmp46_ = serializer_to_string (serializer, _tmp45_);
			_tmp47_ = _tmp46_;
			g_object_set (_tmp44_, "text", _tmp47_, NULL);
			_g_free0 (_tmp47_);
		}
	}
	_g_object_unref0 (combo);
	_g_object_unref0 (number);
}

static gboolean
math_converter_key_press_cb (MathConverter* self,
                             GtkEventControllerKey* controller,
                             guint keyval,
                             guint keycode,
                             GdkModifierType mod_state)
{
	GdkModifierType state = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint new_keyval = 0U;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (controller != NULL, FALSE);
	state = mod_state & (GDK_CONTROL_MASK | GDK_ALT_MASK);
	if (keyval == GDK_KEY_Escape) {
		_tmp1_ = state == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (keyval == GDK_KEY_Delete) {
			_tmp2_ = (mod_state & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		math_converter_clear (self);
		result = TRUE;
		return result;
	}
	new_keyval = (guint) 0;
	switch (keyval) {
		case GDK_KEY_KP_Insert:
		{
			new_keyval = GDK_KEY_0;
			break;
		}
		case GDK_KEY_KP_End:
		{
			new_keyval = GDK_KEY_1;
			break;
		}
		case GDK_KEY_KP_Down:
		{
			new_keyval = GDK_KEY_2;
			break;
		}
		case GDK_KEY_KP_Page_Down:
		{
			new_keyval = GDK_KEY_3;
			break;
		}
		case GDK_KEY_KP_Left:
		{
			new_keyval = GDK_KEY_4;
			break;
		}
		case GDK_KEY_KP_Begin:
		{
			new_keyval = GDK_KEY_5;
			break;
		}
		case GDK_KEY_KP_Right:
		{
			new_keyval = GDK_KEY_6;
			break;
		}
		case GDK_KEY_KP_Home:
		{
			new_keyval = GDK_KEY_7;
			break;
		}
		case GDK_KEY_KP_Up:
		{
			new_keyval = GDK_KEY_8;
			break;
		}
		case GDK_KEY_KP_Page_Up:
		{
			new_keyval = GDK_KEY_9;
			break;
		}
		case GDK_KEY_KP_Delete:
		{
			new_keyval = GDK_KEY_period;
			break;
		}
		default:
		break;
	}
	if (new_keyval != ((guint) 0)) {
		g_info ("math-converter.vala:740: forwarding\n");
		result = math_converter_key_press_cb (self, controller, new_keyval, keycode, mod_state);
		return result;
	}
	if (keyval == GDK_KEY_Return) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = keyval == GDK_KEY_KP_Enter;
	}
	if (_tmp3_) {
		result = TRUE;
		return result;
	}
	if (keyval == GDK_KEY_KP_Decimal) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = keyval == GDK_KEY_KP_Separator;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = keyval == GDK_KEY_period;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = keyval == GDK_KEY_decimalpoint;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = keyval == GDK_KEY_comma;
	}
	if (_tmp4_) {
		math_converter_insert_numeric_point (self);
		result = TRUE;
		return result;
	}
	if (state == 0) {
		guint32 c = 0U;
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp11_;
		c = gdk_keyval_to_unicode (keyval);
		if (c >= ((guint32) '0')) {
			_tmp8_ = c <= ((guint32) '9');
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp9_ = g_strdup_printf ("%c", c);
			_tmp10_ = _tmp9_;
			math_converter_insert_text (self, _tmp10_, TRUE);
			_g_free0 (_tmp10_);
			result = TRUE;
			return result;
		}
		_tmp11_ = self->priv->category;
		if (g_strcmp0 (_tmp11_, "numberbase") == 0) {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			if (c >= ((guint32) 'a')) {
				_tmp12_ = c <= ((guint32) 'f');
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				c = (c - 'a') + 'A';
			}
			if (c >= ((guint32) 'A')) {
				_tmp13_ = c <= ((guint32) 'F');
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = g_strdup_printf ("%c", c);
				_tmp15_ = _tmp14_;
				math_converter_insert_text (self, _tmp15_, TRUE);
				_g_free0 (_tmp15_);
				result = TRUE;
				return result;
			}
		}
		if (c == ((guint32) '-')) {
			math_converter_insert_text (self, "−", TRUE);
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '\'')) {
			math_converter_insert_text (self, "′", TRUE);
			result = TRUE;
			return result;
		}
		if (c == ((guint32) '"')) {
			math_converter_insert_text (self, "″", TRUE);
			result = TRUE;
			return result;
		}
	}
	if (state == GDK_CONTROL_MASK) {
		switch (keyval) {
			case GDK_KEY_p:
			{
				math_converter_insert_text (self, "π", TRUE);
				result = TRUE;
				return result;
			}
			case GDK_KEY_o:
			case GDK_KEY_apostrophe:
			{
				math_converter_insert_text (self, "°", FALSE);
				result = TRUE;
				return result;
			}
			default:
			break;
		}
	}
	result = FALSE;
	return result;
}

static gboolean
_math_converter_key_press_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                   guint keyval,
                                                                   guint keycode,
                                                                   GdkModifierType state,
                                                                   gpointer self)
{
	gboolean result;
	result = math_converter_key_press_cb ((MathConverter*) self, _sender, keyval, keycode, state);
	return result;
}

static gpointer
_gdk_event_ref0 (gpointer self)
{
	return self ? gdk_event_ref (self) : NULL;
}

static void
_vala_GdkEventSequence_free (GdkEventSequence* self)
{
	g_boxed_free (gdk_event_sequence_get_type (), self);
}

static void
math_converter_from_entry_click_cb (MathConverter* self,
                                    GtkGestureClick* gesture,
                                    gint n_click,
                                    gdouble x,
                                    gdouble y)
{
	GdkEvent* event = NULL;
	GdkEventSequence* _tmp0_;
	GdkEventSequence* _tmp1_;
	GdkEvent* _tmp2_;
	GdkEvent* _tmp3_;
	GdkEvent* _tmp4_;
	GdkEvent* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	_tmp0_ = gtk_gesture_single_get_current_sequence ((GtkGestureSingle*) gesture);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_gesture_get_last_event ((GtkGesture*) gesture, _tmp1_);
	_tmp3_ = _gdk_event_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	__vala_GdkEventSequence_free0 (_tmp1_);
	event = _tmp4_;
	_tmp5_ = event;
	if (gdk_event_triggers_context_menu (_tmp5_)) {
		GtkTextView* _tmp6_;
		_tmp6_ = self->priv->from_entry;
		math_converter_show_context_menu (self, _tmp6_, x, y);
		gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
	}
	_gdk_event_unref0 (event);
}

static void
_math_converter_from_entry_click_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                               gint n_press,
                                                               gdouble x,
                                                               gdouble y,
                                                               gpointer self)
{
	math_converter_from_entry_click_cb ((MathConverter*) self, _sender, n_press, x, y);
}

static void
math_converter_to_entry_click_cb (MathConverter* self,
                                  GtkGestureClick* gesture,
                                  gint n_click,
                                  gdouble x,
                                  gdouble y)
{
	GdkEvent* event = NULL;
	GdkEventSequence* _tmp0_;
	GdkEventSequence* _tmp1_;
	GdkEvent* _tmp2_;
	GdkEvent* _tmp3_;
	GdkEvent* _tmp4_;
	GdkEvent* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	_tmp0_ = gtk_gesture_single_get_current_sequence ((GtkGestureSingle*) gesture);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_gesture_get_last_event ((GtkGesture*) gesture, _tmp1_);
	_tmp3_ = _gdk_event_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	__vala_GdkEventSequence_free0 (_tmp1_);
	event = _tmp4_;
	_tmp5_ = event;
	if (gdk_event_triggers_context_menu (_tmp5_)) {
		GtkTextView* _tmp6_;
		_tmp6_ = self->priv->to_entry;
		math_converter_show_context_menu (self, _tmp6_, x, y);
		gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
	}
	_gdk_event_unref0 (event);
}

static void
_math_converter_to_entry_click_cb_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                             gint n_press,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self)
{
	math_converter_to_entry_click_cb ((MathConverter*) self, _sender, n_press, x, y);
}

static void
math_converter_show_context_menu (MathConverter* self,
                                  GtkTextView* entry,
                                  gdouble x,
                                  gdouble y)
{
	GdkClipboard* clipboard = NULL;
	GdkDisplay* _tmp0_;
	GdkClipboard* _tmp1_;
	GdkClipboard* _tmp2_;
	gboolean can_paste = FALSE;
	GdkClipboard* _tmp3_;
	GdkContentFormats* _tmp4_;
	GtkRoot* _tmp5_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextIter _tmp12_;
	GtkTextIter _tmp13_;
	GtkPopoverMenu* _tmp14_ = NULL;
	GtkTextView* _tmp15_;
	GtkPopoverMenu* context_menu = NULL;
	GtkPopoverMenu* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GtkPopoverMenu* _tmp23_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = gdk_display_get_clipboard (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clipboard = _tmp2_;
	_tmp3_ = clipboard;
	_tmp4_ = gdk_clipboard_get_formats (_tmp3_);
	can_paste = gdk_content_formats_contain_gtype (_tmp4_, G_TYPE_STRING);
	gtk_widget_action_set_enabled ((GtkWidget*) self, "context-menu.paste", can_paste);
	_tmp5_ = gtk_widget_get_root ((GtkWidget*) self);
	gtk_root_set_focus (_tmp5_, NULL);
	_tmp6_ = gtk_text_view_get_buffer (entry);
	_tmp7_ = _tmp6_;
	gtk_text_buffer_get_bounds (_tmp7_, &_tmp8_, &_tmp9_);
	start = _tmp8_;
	end = _tmp9_;
	_tmp10_ = gtk_text_view_get_buffer (entry);
	_tmp11_ = _tmp10_;
	_tmp12_ = start;
	_tmp13_ = end;
	gtk_text_buffer_select_range (_tmp11_, &_tmp12_, &_tmp13_);
	_tmp15_ = self->priv->from_entry;
	if (entry == _tmp15_) {
		GtkPopoverMenu* _tmp16_;
		_tmp16_ = self->priv->from_context_menu;
		_tmp14_ = _tmp16_;
	} else {
		GtkPopoverMenu* _tmp17_;
		_tmp17_ = self->priv->to_context_menu;
		_tmp14_ = _tmp17_;
	}
	_tmp18_ = _g_object_ref0 (_tmp14_);
	context_menu = _tmp18_;
	if (x != ((gdouble) -1)) {
		_tmp19_ = y != ((gdouble) -1);
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		GtkPopoverMenu* _tmp20_;
		GdkRectangle _tmp21_ = {0};
		_tmp20_ = context_menu;
		_tmp21_.x = (gint) x;
		_tmp21_.y = (gint) y;
		_tmp21_.width = 1;
		_tmp21_.height = 1;
		gtk_popover_set_pointing_to ((GtkPopover*) _tmp20_, &_tmp21_);
	} else {
		GtkPopoverMenu* _tmp22_;
		_tmp22_ = context_menu;
		gtk_popover_set_pointing_to ((GtkPopover*) _tmp22_, NULL);
	}
	_tmp23_ = context_menu;
	gtk_popover_popup ((GtkPopover*) _tmp23_);
	_g_object_unref0 (context_menu);
	_g_object_unref0 (clipboard);
}

static void
math_converter_popup_cb (MathConverter* self,
                         GSimpleAction* action,
                         GVariant* param)
{
	GtkTextView* _tmp0_ = NULL;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkTextView* entry = NULL;
	GtkTextView* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->priv->from_entry;
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkTextView* _tmp4_;
		_tmp4_ = self->priv->from_entry;
		_tmp0_ = _tmp4_;
	} else {
		GtkTextView* _tmp5_;
		_tmp5_ = self->priv->to_entry;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	entry = _tmp6_;
	math_converter_show_context_menu (self, entry, (gdouble) -1, (gdouble) -1);
	_g_object_unref0 (entry);
}

static void
math_converter_copy_cb (MathConverter* self,
                        GSimpleAction* action,
                        GVariant* param)
{
	GtkTextView* _tmp0_ = NULL;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkTextView* entry = NULL;
	GtkTextView* _tmp6_;
	gchar* tsep_string = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	GtkRoot* _tmp13_;
	GtkRoot* _tmp14_;
	gchar* text = NULL;
	GtkTextView* _tmp15_;
	GtkTextBuffer* _tmp16_;
	GtkTextBuffer* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GdkClipboard* clipboard = NULL;
	GdkDisplay* _tmp24_;
	GdkClipboard* _tmp25_;
	GdkClipboard* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->priv->from_entry;
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkTextView* _tmp4_;
		_tmp4_ = self->priv->from_entry;
		_tmp0_ = _tmp4_;
	} else {
		GtkTextView* _tmp5_;
		_tmp5_ = self->priv->to_entry;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	entry = _tmp6_;
	_tmp7_ = nl_langinfo (THOUSEP);
	_tmp8_ = g_strdup (_tmp7_);
	tsep_string = _tmp8_;
	_tmp10_ = tsep_string;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		const gchar* _tmp11_;
		_tmp11_ = tsep_string;
		_tmp9_ = g_strcmp0 (_tmp11_, "") == 0;
	}
	if (_tmp9_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup (" ");
		_g_free0 (tsep_string);
		tsep_string = _tmp12_;
	}
	_tmp13_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp14_ = _tmp13_;
	gtk_root_set_focus (_tmp14_, NULL);
	_tmp15_ = entry;
	_tmp16_ = gtk_text_view_get_buffer (_tmp15_);
	_tmp17_ = _tmp16_;
	g_object_get (_tmp17_, "text", &_tmp18_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = tsep_string;
	_tmp22_ = string_replace (_tmp20_, _tmp21_, "");
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp20_);
	text = _tmp23_;
	_tmp24_ = gdk_display_get_default ();
	_tmp25_ = gdk_display_get_clipboard (_tmp24_);
	_tmp26_ = _g_object_ref0 (_tmp25_);
	clipboard = _tmp26_;
	gdk_clipboard_set_text (clipboard, text);
	_g_object_unref0 (clipboard);
	_g_free0 (text);
	_g_free0 (tsep_string);
	_g_object_unref0 (entry);
}

static void
math_converter_paste_cb (MathConverter* self,
                         GSimpleAction* action,
                         GVariant* param)
{
	GtkTextView* _tmp0_ = NULL;
	GtkTextView* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkTextView* entry = NULL;
	GtkTextView* _tmp6_;
	GtkTextBuffer* _tmp7_;
	GtkTextBuffer* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp1_ = self->priv->from_entry;
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkTextView* _tmp4_;
		_tmp4_ = self->priv->from_entry;
		_tmp0_ = _tmp4_;
	} else {
		GtkTextView* _tmp5_;
		_tmp5_ = self->priv->to_entry;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp0_);
	entry = _tmp6_;
	_tmp7_ = gtk_text_view_get_buffer (entry);
	_tmp8_ = _tmp7_;
	g_object_set (_tmp8_, "text", "", NULL);
	math_converter_paste (self);
	_g_object_unref0 (entry);
}

static void
math_converter_reformat_display (MathConverter* self)
{
	Serializer* _tmp0_;
	MathEquation* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GtkTextView* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	GtkTextView* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->fixed_serializer;
	_tmp1_ = self->priv->_equation;
	_tmp2_ = math_equation_get_accuracy (_tmp1_);
	_tmp3_ = _tmp2_;
	if (serializer_get_trailing_digits (_tmp0_) != _tmp3_) {
		Serializer* _tmp4_;
		MathEquation* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->fixed_serializer;
		_tmp5_ = self->priv->_equation;
		_tmp6_ = math_equation_get_accuracy (_tmp5_);
		_tmp7_ = _tmp6_;
		serializer_set_trailing_digits (_tmp4_, _tmp7_);
	}
	_tmp8_ = self->priv->from_entry;
	g_object_get ((GtkWidget*) _tmp8_, "has-focus", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		GtkTextView* _tmp11_;
		GtkTextBuffer* _tmp12_;
		GtkTextBuffer* _tmp13_;
		GtkTextView* _tmp14_;
		MathEquation* _tmp15_;
		Serializer* _tmp16_;
		Serializer* _tmp17_;
		GtkTextView* _tmp18_;
		GtkTextBuffer* _tmp19_;
		GtkTextBuffer* _tmp20_;
		_tmp11_ = self->priv->from_entry;
		_tmp12_ = gtk_text_view_get_buffer (_tmp11_);
		_tmp13_ = _tmp12_;
		g_signal_handler_block (_tmp13_, self->priv->from_entry_changed);
		_tmp14_ = self->priv->from_entry;
		_tmp15_ = self->priv->_equation;
		_tmp16_ = math_equation_get_serializer (_tmp15_);
		_tmp17_ = _tmp16_;
		math_converter_update_entry (self, _tmp14_, _tmp17_);
		_tmp18_ = self->priv->from_entry;
		_tmp19_ = gtk_text_view_get_buffer (_tmp18_);
		_tmp20_ = _tmp19_;
		g_signal_handler_unblock (_tmp20_, self->priv->from_entry_changed);
	}
	_tmp21_ = self->priv->to_entry;
	g_object_get ((GtkWidget*) _tmp21_, "has-focus", &_tmp22_, NULL);
	_tmp23_ = _tmp22_;
	if (!_tmp23_) {
		GtkTextView* _tmp24_;
		GtkTextBuffer* _tmp25_;
		GtkTextBuffer* _tmp26_;
		GtkTextView* _tmp27_;
		MathEquation* _tmp28_;
		Serializer* _tmp29_;
		Serializer* _tmp30_;
		GtkTextView* _tmp31_;
		GtkTextBuffer* _tmp32_;
		GtkTextBuffer* _tmp33_;
		_tmp24_ = self->priv->to_entry;
		_tmp25_ = gtk_text_view_get_buffer (_tmp24_);
		_tmp26_ = _tmp25_;
		g_signal_handler_block (_tmp26_, self->priv->to_entry_changed);
		_tmp27_ = self->priv->to_entry;
		_tmp28_ = self->priv->_equation;
		_tmp29_ = math_equation_get_serializer (_tmp28_);
		_tmp30_ = _tmp29_;
		math_converter_update_entry (self, _tmp27_, _tmp30_);
		_tmp31_ = self->priv->to_entry;
		_tmp32_ = gtk_text_view_get_buffer (_tmp31_);
		_tmp33_ = _tmp32_;
		g_signal_handler_unblock (_tmp33_, self->priv->to_entry_changed);
	}
}

static void
math_converter_reformat_from_entry (MathConverter* self)
{
	Number* _tmp0_;
	GtkTextView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GtkTextView* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextBuffer* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->from_number;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->from_entry;
	_tmp2_ = gtk_text_view_get_buffer (_tmp1_);
	_tmp3_ = _tmp2_;
	g_signal_handler_block (_tmp3_, self->priv->from_entry_changed);
	_tmp4_ = self->priv->from_entry;
	g_object_get ((GtkWidget*) _tmp4_, "has-focus", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		GtkTextView* _tmp7_;
		Serializer* _tmp8_;
		_tmp7_ = self->priv->from_entry;
		_tmp8_ = self->priv->fixed_serializer;
		math_converter_update_entry (self, _tmp7_, _tmp8_);
	} else {
		GtkTextView* _tmp9_;
		MathEquation* _tmp10_;
		Serializer* _tmp11_;
		Serializer* _tmp12_;
		_tmp9_ = self->priv->from_entry;
		_tmp10_ = self->priv->_equation;
		_tmp11_ = math_equation_get_serializer (_tmp10_);
		_tmp12_ = _tmp11_;
		math_converter_update_entry (self, _tmp9_, _tmp12_);
	}
	_tmp13_ = self->priv->from_entry;
	_tmp14_ = gtk_text_view_get_buffer (_tmp13_);
	_tmp15_ = _tmp14_;
	g_signal_handler_unblock (_tmp15_, self->priv->from_entry_changed);
}

static Number*
math_converter_convert_equation (MathConverter* self,
                                 Number* x,
                                 Unit** source_unit,
                                 Unit** target_unit)
{
	Unit* _vala_source_unit = NULL;
	Unit* _vala_target_unit = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkDropDown* _tmp2_;
	UnitCategory* category = NULL;
	GtkDropDown* _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	UnitCategory* _tmp8_;
	GtkDropDown* _tmp9_;
	GObject* _tmp10_;
	GObject* _tmp11_;
	Unit* _tmp12_;
	GtkDropDown* _tmp13_;
	GObject* _tmp14_;
	GObject* _tmp15_;
	Unit* _tmp16_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	UnitCategory* _tmp19_;
	Number* _tmp22_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp2_ = self->priv->category_combo;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		GtkDropDown* _tmp3_;
		_tmp3_ = self->priv->from_combo;
		_tmp1_ = _tmp3_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		GtkDropDown* _tmp4_;
		_tmp4_ = self->priv->to_combo;
		_tmp0_ = _tmp4_ == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		if (source_unit) {
			*source_unit = _vala_source_unit;
		} else {
			_g_object_unref0 (_vala_source_unit);
		}
		if (target_unit) {
			*target_unit = _vala_target_unit;
		} else {
			_g_object_unref0 (_vala_target_unit);
		}
		return result;
	}
	_tmp5_ = self->priv->category_combo;
	_tmp6_ = gtk_drop_down_get_selected_item (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_UNIT_CATEGORY) ? ((UnitCategory*) _tmp7_) : NULL);
	category = _tmp8_;
	_tmp9_ = self->priv->from_combo;
	_tmp10_ = gtk_drop_down_get_selected_item (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, TYPE_UNIT) ? ((Unit*) _tmp11_) : NULL);
	_g_object_unref0 (_vala_source_unit);
	_vala_source_unit = _tmp12_;
	_tmp13_ = self->priv->to_combo;
	_tmp14_ = gtk_drop_down_get_selected_item (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, TYPE_UNIT) ? ((Unit*) _tmp15_) : NULL);
	_g_object_unref0 (_vala_target_unit);
	_vala_target_unit = _tmp16_;
	_tmp19_ = category;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		Unit* _tmp20_;
		_tmp20_ = _vala_source_unit;
		_tmp18_ = _tmp20_ == NULL;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		Unit* _tmp21_;
		_tmp21_ = _vala_target_unit;
		_tmp17_ = _tmp21_ == NULL;
	}
	if (_tmp17_) {
		result = NULL;
		_g_object_unref0 (category);
		if (source_unit) {
			*source_unit = _vala_source_unit;
		} else {
			_g_object_unref0 (_vala_source_unit);
		}
		if (target_unit) {
			*target_unit = _vala_target_unit;
		} else {
			_g_object_unref0 (_vala_target_unit);
		}
		return result;
	}
	_tmp22_ = self->priv->from_number;
	if (x == _tmp22_) {
		UnitCategory* _tmp23_;
		Unit* _tmp24_;
		Unit* _tmp25_;
		Number* _tmp26_;
		_tmp23_ = category;
		_tmp24_ = _vala_source_unit;
		_tmp25_ = _vala_target_unit;
		_tmp26_ = unit_category_convert (_tmp23_, x, _tmp24_, _tmp25_);
		result = _tmp26_;
		_g_object_unref0 (category);
		if (source_unit) {
			*source_unit = _vala_source_unit;
		} else {
			_g_object_unref0 (_vala_source_unit);
		}
		if (target_unit) {
			*target_unit = _vala_target_unit;
		} else {
			_g_object_unref0 (_vala_target_unit);
		}
		return result;
	} else {
		UnitCategory* _tmp27_;
		Unit* _tmp28_;
		Unit* _tmp29_;
		Number* _tmp30_;
		_tmp27_ = category;
		_tmp28_ = _vala_target_unit;
		_tmp29_ = _vala_source_unit;
		_tmp30_ = unit_category_convert (_tmp27_, x, _tmp28_, _tmp29_);
		result = _tmp30_;
		_g_object_unref0 (category);
		if (source_unit) {
			*source_unit = _vala_source_unit;
		} else {
			_g_object_unref0 (_vala_source_unit);
		}
		if (target_unit) {
			*target_unit = _vala_target_unit;
		} else {
			_g_object_unref0 (_vala_target_unit);
		}
		return result;
	}
}

MathEquation*
math_converter_get_equation (MathConverter* self)
{
	MathEquation* result;
	MathEquation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

void
math_converter_set_equation (MathConverter* self,
                             MathEquation* value)
{
	MathEquation* old_value;
	g_return_if_fail (self != NULL);
	old_value = math_converter_get_equation (self);
	if (old_value != value) {
		MathEquation* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_equation);
		self->priv->_equation = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, math_converter_properties[MATH_CONVERTER_EQUATION_PROPERTY]);
	}
}

static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
math_converter_get_source_units (MathConverter* self,
                                 gint* result_length1)
{
	gchar** result;
	GHashTable* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_units;
	_tmp1_ = g_hash_table_get_values_as_ptr_array (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->pdata;
	_tmp3__length1 = _tmp2_->len;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup6 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_g_ptr_array_unref0 (_tmp2_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
math_converter_set_source_units (MathConverter* self,
                                 gchar** value,
                                 gint value_length1)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_source_units;
	math_converter_load_selected_units (self, _tmp0_, value, (gint) value_length1);
	g_object_notify_by_pspec ((GObject *) self, math_converter_properties[MATH_CONVERTER_SOURCE_UNITS_PROPERTY]);
}

static gchar**
_vala_array_dup7 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
math_converter_get_target_units (MathConverter* self,
                                 gint* result_length1)
{
	gchar** result;
	GHashTable* _tmp0_;
	GPtrArray* _tmp1_;
	GPtrArray* _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_target_units;
	_tmp1_ = g_hash_table_get_values_as_ptr_array (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->pdata;
	_tmp3__length1 = _tmp2_->len;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup7 (_tmp3_, _tmp3__length1) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_g_ptr_array_unref0 (_tmp2_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
math_converter_set_target_units (MathConverter* self,
                                 gchar** value,
                                 gint value_length1)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_target_units;
	math_converter_load_selected_units (self, _tmp0_, value, (gint) value_length1);
	g_object_notify_by_pspec ((GObject *) self, math_converter_properties[MATH_CONVERTER_TARGET_UNITS_PROPERTY]);
}

void
math_converter_set_currency_display (MathConverter* self,
                                     CurrencyDisplay value)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->_currency_display == value) {
		return;
	}
	self->priv->_currency_display = value;
	_tmp0_ = self->priv->category;
	if (g_strcmp0 (_tmp0_, "currency") == 0) {
		math_converter_category_combobox_changed_cb (self);
	}
	g_object_notify_by_pspec ((GObject *) self, math_converter_properties[MATH_CONVERTER_CURRENCY_DISPLAY_PROPERTY]);
}

gboolean
math_converter_get_box_visible (MathConverter* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_box_visible;
	return result;
}

void
math_converter_set_box_visible (MathConverter* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = math_converter_get_box_visible (self);
	if (old_value != value) {
		self->priv->_box_visible = value;
		g_object_notify_by_pspec ((GObject *) self, math_converter_properties[MATH_CONVERTER_BOX_VISIBLE_PROPERTY]);
	}
}

static void
_math_converter_construct_finish_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self)
{
	math_converter_construct_finish ((MathConverter*) self);
}

static GObject *
math_converter_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MathConverter * self;
	GSimpleActionGroup* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	parent_class = G_OBJECT_CLASS (math_converter_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_CONVERTER, MathConverter);
	_tmp0_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp0_, MATH_CONVERTER_action_entries, (gint) G_N_ELEMENTS (MATH_CONVERTER_action_entries), self);
	_tmp1_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "context-menu", (GActionGroup*) _tmp1_);
	g_signal_connect_object ((GObject*) self, "notify::equation", (GCallback) _math_converter_construct_finish_g_object_notify, self, 0);
	return obj;
}

static void
math_converter_class_init (MathConverterClass * klass,
                           gpointer klass_data)
{
	math_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MathConverter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_math_converter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_math_converter_set_property;
	G_OBJECT_CLASS (klass)->constructor = math_converter_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_converter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_CONVERTER_EQUATION_PROPERTY, math_converter_properties[MATH_CONVERTER_EQUATION_PROPERTY] = g_param_spec_object ("equation", "equation", "equation", TYPE_MATH_EQUATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_CONVERTER_SOURCE_UNITS_PROPERTY, math_converter_properties[MATH_CONVERTER_SOURCE_UNITS_PROPERTY] = g_param_spec_boxed ("source-units", "source-units", "source-units", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_CONVERTER_TARGET_UNITS_PROPERTY, math_converter_properties[MATH_CONVERTER_TARGET_UNITS_PROPERTY] = g_param_spec_boxed ("target-units", "target-units", "target-units", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_CONVERTER_CURRENCY_DISPLAY_PROPERTY, math_converter_properties[MATH_CONVERTER_CURRENCY_DISPLAY_PROPERTY] = g_param_spec_enum ("currency-display", "currency-display", "currency-display", TYPE_CURRENCY_DISPLAY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MATH_CONVERTER_BOX_VISIBLE_PROPERTY, math_converter_properties[MATH_CONVERTER_BOX_VISIBLE_PROPERTY] = g_param_spec_boolean ("box-visible", "box-visible", "box-visible", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-converter.ui");
	math_converter_signals[MATH_CONVERTER_CHANGED_SIGNAL] = g_signal_new ("changed", TYPE_MATH_CONVERTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "category_combo", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, category_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_combo", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, from_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_combo", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, to_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_entry", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, from_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_entry", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, to_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_context_menu", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, from_context_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_context_menu", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, to_context_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "status_stack", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, status_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_event_controller", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, from_event_controller));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_event_controller", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, to_event_controller));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "refresh_rates", G_CALLBACK(_math_converter_refresh_rates_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "category_combobox_changed_cb", G_CALLBACK(_math_converter_category_combobox_changed_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "to_combobox_changed_cb", G_CALLBACK(_math_converter_to_combobox_changed_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "from_entry_focus_cb", G_CALLBACK(_math_converter_from_entry_focus_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "to_entry_focus_cb", G_CALLBACK(_math_converter_to_entry_focus_cb_g_object_notify));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_press_cb", G_CALLBACK(_math_converter_key_press_cb_gtk_event_controller_key_key_pressed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "from_entry_click_cb", G_CALLBACK(_math_converter_from_entry_click_cb_gtk_gesture_click_pressed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "to_entry_click_cb", G_CALLBACK(_math_converter_to_entry_click_cb_gtk_gesture_click_pressed));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "mathconverter");
}

static void
math_converter_instance_init (MathConverter * self,
                              gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GSimpleActionGroup* _tmp6_;
	self->priv = math_converter_get_instance_private (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	self->priv->_source_units = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, _g_free0_);
	self->priv->_target_units = _tmp5_;
	self->priv->from_combobox_changed = (gulong) 0;
	_tmp6_ = g_simple_action_group_new ();
	self->priv->action_group = _tmp6_;
	self->priv->_box_visible = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
math_converter_finalize (GObject * obj)
{
	MathConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_CONVERTER, MathConverter);
	_g_object_unref0 (self->priv->_equation);
	_g_free0 (self->priv->category);
	_g_object_unref0 (self->priv->from_number);
	_g_object_unref0 (self->priv->to_number);
	_g_hash_table_unref0 (self->priv->_source_units);
	_g_hash_table_unref0 (self->priv->_target_units);
	_g_object_unref0 (self->priv->fixed_serializer);
	_g_object_unref0 (self->priv->from_currency_factory);
	_g_object_unref0 (self->priv->to_currency_factory);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (math_converter_parent_class)->finalize (obj);
}

static GType
math_converter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MathConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathConverter), 0, (GInstanceInitFunc) math_converter_instance_init, NULL };
	GType math_converter_type_id;
	math_converter_type_id = g_type_register_static (gtk_box_get_type (), "MathConverter", &g_define_type_info, 0);
	MathConverter_private_offset = g_type_add_instance_private (math_converter_type_id, sizeof (MathConverterPrivate));
	return math_converter_type_id;
}

GType
math_converter_get_type (void)
{
	static volatile gsize math_converter_type_id__once = 0;
	if (g_once_init_enter (&math_converter_type_id__once)) {
		GType math_converter_type_id;
		math_converter_type_id = math_converter_get_type_once ();
		g_once_init_leave (&math_converter_type_id__once, math_converter_type_id);
	}
	return math_converter_type_id__once;
}

static void
_vala_math_converter_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	MathConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_CONVERTER, MathConverter);
	switch (property_id) {
		case MATH_CONVERTER_EQUATION_PROPERTY:
		g_value_set_object (value, math_converter_get_equation (self));
		break;
		case MATH_CONVERTER_SOURCE_UNITS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, math_converter_get_source_units (self, &length));
		}
		break;
		case MATH_CONVERTER_TARGET_UNITS_PROPERTY:
		{
			int length;
			g_value_take_boxed (value, math_converter_get_target_units (self, &length));
		}
		break;
		case MATH_CONVERTER_BOX_VISIBLE_PROPERTY:
		g_value_set_boolean (value, math_converter_get_box_visible (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_math_converter_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	MathConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MATH_CONVERTER, MathConverter);
	switch (property_id) {
		case MATH_CONVERTER_EQUATION_PROPERTY:
		math_converter_set_equation (self, g_value_get_object (value));
		break;
		case MATH_CONVERTER_SOURCE_UNITS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			math_converter_set_source_units (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case MATH_CONVERTER_TARGET_UNITS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			math_converter_set_target_units (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case MATH_CONVERTER_CURRENCY_DISPLAY_PROPERTY:
		math_converter_set_currency_display (self, g_value_get_enum (value));
		break;
		case MATH_CONVERTER_BOX_VISIBLE_PROPERTY:
		math_converter_set_box_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

