/* equation-parser.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from equation-parser.vala, do not modify */

/*
 * Copyright (C) 2012 Arth Patel
 * Copyright (C) 2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Operator Associativity. */

#include "calculator.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	PRECEDENCE_UNKNOWN = 0,
	PRECEDENCE_CONVERT = 0,
	PRECEDENCE_UNIT = 1,
	PRECEDENCE_TOP = 2,
	PRECEDENCE_ADD_SUBTRACT = 3,
	PRECEDENCE_MULTIPLY = 4,
	PRECEDENCE_MOD = 5,
	PRECEDENCE_DIVIDE = 5,
	PRECEDENCE_NOT = 6,
	PRECEDENCE_FUNCTION = 7,
	PRECEDENCE_BOOLEAN = 8,
	PRECEDENCE_SHIFT = 8,
	PRECEDENCE_PERCENTAGE = 9,
	PRECEDENCE_UNARY_MINUS = 10,
	PRECEDENCE_POWER = 10,
	PRECEDENCE_ROOT = 10,
	PRECEDENCE_FACTORIAL = 11,
	PRECEDENCE_NUMBER_VARIABLE = 12,
	PRECEDENCE_DEPTH
} Precedence;

#define TYPE_PRECEDENCE (precedence_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	PARSE_NODE_0_PROPERTY,
	PARSE_NODE_NUM_PROPERTIES
};
static GParamSpec* parse_node_properties[PARSE_NODE_NUM_PROPERTIES];
#define _parser_unref0(var) ((var == NULL) ? NULL : (var = (parser_unref (var), NULL)))
enum  {
	RNODE_0_PROPERTY,
	RNODE_NUM_PROPERTIES
};
static GParamSpec* rnode_properties[RNODE_NUM_PROPERTIES];
enum  {
	LR_NODE_0_PROPERTY,
	LR_NODE_NUM_PROPERTIES
};
static GParamSpec* lr_node_properties[LR_NODE_NUM_PROPERTIES];
enum  {
	CONSTANT_NODE_0_PROPERTY,
	CONSTANT_NODE_NUM_PROPERTIES
};
static GParamSpec* constant_node_properties[CONSTANT_NODE_NUM_PROPERTIES];
enum  {
	ASSIGN_NODE_0_PROPERTY,
	ASSIGN_NODE_NUM_PROPERTIES
};
static GParamSpec* assign_node_properties[ASSIGN_NODE_NUM_PROPERTIES];
enum  {
	ASSIGN_FUNCTION_NODE_0_PROPERTY,
	ASSIGN_FUNCTION_NODE_NUM_PROPERTIES
};
static GParamSpec* assign_function_node_properties[ASSIGN_FUNCTION_NODE_NUM_PROPERTIES];
enum  {
	NAME_NODE_0_PROPERTY,
	NAME_NODE_NUM_PROPERTIES
};
static GParamSpec* name_node_properties[NAME_NODE_NUM_PROPERTIES];
enum  {
	VARIABLE_NODE_0_PROPERTY,
	VARIABLE_NODE_NUM_PROPERTIES
};
static GParamSpec* variable_node_properties[VARIABLE_NODE_NUM_PROPERTIES];
enum  {
	VARIABLE_WITH_POWER_NODE_0_PROPERTY,
	VARIABLE_WITH_POWER_NODE_NUM_PROPERTIES
};
static GParamSpec* variable_with_power_node_properties[VARIABLE_WITH_POWER_NODE_NUM_PROPERTIES];
enum  {
	FUNCTION_NAME_NODE_0_PROPERTY,
	FUNCTION_NAME_NODE_NUM_PROPERTIES
};
static GParamSpec* function_name_node_properties[FUNCTION_NAME_NODE_NUM_PROPERTIES];
enum  {
	FUNCTION_ARGUMENTS_NODE_0_PROPERTY,
	FUNCTION_ARGUMENTS_NODE_NUM_PROPERTIES
};
static GParamSpec* function_arguments_node_properties[FUNCTION_ARGUMENTS_NODE_NUM_PROPERTIES];
enum  {
	FUNCTION_DESCRIPTION_NODE_0_PROPERTY,
	FUNCTION_DESCRIPTION_NODE_NUM_PROPERTIES
};
static GParamSpec* function_description_node_properties[FUNCTION_DESCRIPTION_NODE_NUM_PROPERTIES];
enum  {
	FUNCTION_NODE_0_PROPERTY,
	FUNCTION_NODE_NUM_PROPERTIES
};
static GParamSpec* function_node_properties[FUNCTION_NODE_NUM_PROPERTIES];
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	UNARY_MINUS_NODE_0_PROPERTY,
	UNARY_MINUS_NODE_NUM_PROPERTIES
};
static GParamSpec* unary_minus_node_properties[UNARY_MINUS_NODE_NUM_PROPERTIES];
enum  {
	ABSOLUTE_VALUE_NODE_0_PROPERTY,
	ABSOLUTE_VALUE_NODE_NUM_PROPERTIES
};
static GParamSpec* absolute_value_node_properties[ABSOLUTE_VALUE_NODE_NUM_PROPERTIES];
enum  {
	FLOOR_NODE_0_PROPERTY,
	FLOOR_NODE_NUM_PROPERTIES
};
static GParamSpec* floor_node_properties[FLOOR_NODE_NUM_PROPERTIES];
enum  {
	CEILING_NODE_0_PROPERTY,
	CEILING_NODE_NUM_PROPERTIES
};
static GParamSpec* ceiling_node_properties[CEILING_NODE_NUM_PROPERTIES];
enum  {
	FRACTIONAL_COMPONENT_NODE_0_PROPERTY,
	FRACTIONAL_COMPONENT_NODE_NUM_PROPERTIES
};
static GParamSpec* fractional_component_node_properties[FRACTIONAL_COMPONENT_NODE_NUM_PROPERTIES];
enum  {
	ROUND_NODE_0_PROPERTY,
	ROUND_NODE_NUM_PROPERTIES
};
static GParamSpec* round_node_properties[ROUND_NODE_NUM_PROPERTIES];
enum  {
	PERCENT_NODE_0_PROPERTY,
	PERCENT_NODE_NUM_PROPERTIES
};
static GParamSpec* percent_node_properties[PERCENT_NODE_NUM_PROPERTIES];
enum  {
	FACTORIAL_NODE_0_PROPERTY,
	FACTORIAL_NODE_NUM_PROPERTIES
};
static GParamSpec* factorial_node_properties[FACTORIAL_NODE_NUM_PROPERTIES];
enum  {
	ADD_NODE_0_PROPERTY,
	ADD_NODE_NUM_PROPERTIES
};
static GParamSpec* add_node_properties[ADD_NODE_NUM_PROPERTIES];
enum  {
	SUBTRACT_NODE_0_PROPERTY,
	SUBTRACT_NODE_NUM_PROPERTIES
};
static GParamSpec* subtract_node_properties[SUBTRACT_NODE_NUM_PROPERTIES];
enum  {
	MULTIPLY_NODE_0_PROPERTY,
	MULTIPLY_NODE_NUM_PROPERTIES
};
static GParamSpec* multiply_node_properties[MULTIPLY_NODE_NUM_PROPERTIES];
enum  {
	SHIFT_NODE_0_PROPERTY,
	SHIFT_NODE_NUM_PROPERTIES
};
static GParamSpec* shift_node_properties[SHIFT_NODE_NUM_PROPERTIES];
enum  {
	DIVIDE_NODE_0_PROPERTY,
	DIVIDE_NODE_NUM_PROPERTIES
};
static GParamSpec* divide_node_properties[DIVIDE_NODE_NUM_PROPERTIES];
enum  {
	MODULUS_DIVIDE_NODE_0_PROPERTY,
	MODULUS_DIVIDE_NODE_NUM_PROPERTIES
};
static GParamSpec* modulus_divide_node_properties[MODULUS_DIVIDE_NODE_NUM_PROPERTIES];
enum  {
	ROOT_NODE_0_PROPERTY,
	ROOT_NODE_NUM_PROPERTIES
};
static GParamSpec* root_node_properties[ROOT_NODE_NUM_PROPERTIES];
enum  {
	XPOW_YNODE_0_PROPERTY,
	XPOW_YNODE_NUM_PROPERTIES
};
static GParamSpec* xpow_ynode_properties[XPOW_YNODE_NUM_PROPERTIES];
enum  {
	XPOW_YINTEGER_NODE_0_PROPERTY,
	XPOW_YINTEGER_NODE_NUM_PROPERTIES
};
static GParamSpec* xpow_yinteger_node_properties[XPOW_YINTEGER_NODE_NUM_PROPERTIES];
enum  {
	NOT_NODE_0_PROPERTY,
	NOT_NODE_NUM_PROPERTIES
};
static GParamSpec* not_node_properties[NOT_NODE_NUM_PROPERTIES];
enum  {
	AND_NODE_0_PROPERTY,
	AND_NODE_NUM_PROPERTIES
};
static GParamSpec* and_node_properties[AND_NODE_NUM_PROPERTIES];
enum  {
	NAND_NODE_0_PROPERTY,
	NAND_NODE_NUM_PROPERTIES
};
static GParamSpec* nand_node_properties[NAND_NODE_NUM_PROPERTIES];
enum  {
	OR_NODE_0_PROPERTY,
	OR_NODE_NUM_PROPERTIES
};
static GParamSpec* or_node_properties[OR_NODE_NUM_PROPERTIES];
enum  {
	NOR_NODE_0_PROPERTY,
	NOR_NODE_NUM_PROPERTIES
};
static GParamSpec* nor_node_properties[NOR_NODE_NUM_PROPERTIES];
enum  {
	XOR_NODE_0_PROPERTY,
	XOR_NODE_NUM_PROPERTIES
};
static GParamSpec* xor_node_properties[XOR_NODE_NUM_PROPERTIES];
enum  {
	XNOR_NODE_0_PROPERTY,
	XNOR_NODE_NUM_PROPERTIES
};
static GParamSpec* xnor_node_properties[XNOR_NODE_NUM_PROPERTIES];
enum  {
	CONVERT_NODE_0_PROPERTY,
	CONVERT_NODE_NUM_PROPERTIES
};
static GParamSpec* convert_node_properties[CONVERT_NODE_NUM_PROPERTIES];
enum  {
	CONVERT_BASE_NODE_0_PROPERTY,
	CONVERT_BASE_NODE_NUM_PROPERTIES
};
static GParamSpec* convert_base_node_properties[CONVERT_BASE_NODE_NUM_PROPERTIES];
enum  {
	CONVERT_NUMBER_NODE_0_PROPERTY,
	CONVERT_NUMBER_NODE_NUM_PROPERTIES
};
static GParamSpec* convert_number_node_properties[CONVERT_NUMBER_NODE_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _ParamSpecParser ParamSpecParser;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RootNodePrivate {
	gint n;
	LexerToken* token_n;
};

struct _ParserPrivate {
	gchar* input;
	ParseNode* root;
	ParseNode* right_most;
	Lexer* lexer;
	guint depth_level;
	ErrorCode error;
	gchar* error_token;
	gint error_token_start;
	gint error_token_end;
	guint representation_base;
};

struct _ParamSpecParser {
	GParamSpec parent_instance;
};

static gpointer parse_node_parent_class = NULL;
static gpointer rnode_parent_class = NULL;
static gpointer lr_node_parent_class = NULL;
static gpointer constant_node_parent_class = NULL;
static gpointer assign_node_parent_class = NULL;
static gpointer assign_function_node_parent_class = NULL;
static gpointer name_node_parent_class = NULL;
static gpointer variable_node_parent_class = NULL;
static gpointer variable_with_power_node_parent_class = NULL;
static gpointer function_name_node_parent_class = NULL;
static gpointer function_arguments_node_parent_class = NULL;
static gpointer function_description_node_parent_class = NULL;
static gpointer function_node_parent_class = NULL;
static gpointer unary_minus_node_parent_class = NULL;
static gpointer absolute_value_node_parent_class = NULL;
static gpointer floor_node_parent_class = NULL;
static gpointer ceiling_node_parent_class = NULL;
static gpointer fractional_component_node_parent_class = NULL;
static gpointer round_node_parent_class = NULL;
static gpointer percent_node_parent_class = NULL;
static gpointer factorial_node_parent_class = NULL;
static gpointer add_node_parent_class = NULL;
static gpointer subtract_node_parent_class = NULL;
static gpointer multiply_node_parent_class = NULL;
static gpointer shift_node_parent_class = NULL;
static gpointer divide_node_parent_class = NULL;
static gpointer modulus_divide_node_parent_class = NULL;
static gint RootNode_private_offset;
static gpointer root_node_parent_class = NULL;
static gpointer xpow_ynode_parent_class = NULL;
static gpointer xpow_yinteger_node_parent_class = NULL;
static gpointer not_node_parent_class = NULL;
static gpointer and_node_parent_class = NULL;
static gpointer nand_node_parent_class = NULL;
static gpointer or_node_parent_class = NULL;
static gpointer nor_node_parent_class = NULL;
static gpointer xor_node_parent_class = NULL;
static gpointer xnor_node_parent_class = NULL;
static gpointer convert_node_parent_class = NULL;
static gpointer convert_base_node_parent_class = NULL;
static gpointer convert_number_node_parent_class = NULL;
static gint Parser_private_offset;
static gpointer parser_parent_class = NULL;
GHashTable* parser_CONSTANTS = NULL;
ConstantCategory* parser_CONSTANT_CATEGORIES = NULL;
gint parser_CONSTANT_CATEGORIES_length1 = 0;

VALA_EXTERN GType precedence_get_type (void) G_GNUC_CONST ;
static void _vala_Constant_array_free (Constant * array,
                                gssize array_length);
static Constant* _vala_array_dup1 (Constant* self,
                            gssize length);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static Number* parse_node_real_solve (ParseNode* self);
static void parse_node_finalize (GObject * obj);
static GType parse_node_get_type_once (void);
static Number* rnode_real_solve (ParseNode* base);
static Number* rnode_real_solve_r (RNode* self,
                            Number* r);
static GType rnode_get_type_once (void);
static Number* lr_node_real_solve (ParseNode* base);
static Number* lr_node_real_solve_lr (LRNode* self,
                               Number* left,
                               Number* r);
static void lr_node_finalize (GObject * obj);
static GType lr_node_get_type_once (void);
static Number* constant_node_real_solve (ParseNode* base);
static GType constant_node_get_type_once (void);
static Number* assign_node_real_solve_r (RNode* base,
                                  Number* r);
static GType assign_node_get_type_once (void);
static Number* assign_function_node_real_solve (ParseNode* base);
static GType assign_function_node_get_type_once (void);
static GType name_node_get_type_once (void);
static Number* variable_node_real_solve (ParseNode* base);
static GType variable_node_get_type_once (void);
static Number* variable_with_power_node_real_solve (ParseNode* base);
static GType variable_with_power_node_get_type_once (void);
static GType function_name_node_get_type_once (void);
static GType function_arguments_node_get_type_once (void);
static GType function_description_node_get_type_once (void);
static Number* function_node_real_solve (ParseNode* base);
static void _vala_array_add2 (Number** * array,
                       gint* length,
                       gint* size,
                       Number* value);
static void _vala_array_add3 (Number** * array,
                       gint* length,
                       gint* size,
                       Number* value);
static GType function_node_get_type_once (void);
static Number* unary_minus_node_real_solve_r (RNode* base,
                                       Number* r);
static GType unary_minus_node_get_type_once (void);
static Number* absolute_value_node_real_solve_r (RNode* base,
                                          Number* r);
static GType absolute_value_node_get_type_once (void);
static Number* floor_node_real_solve_r (RNode* base,
                                 Number* r);
static GType floor_node_get_type_once (void);
static Number* ceiling_node_real_solve_r (RNode* base,
                                   Number* r);
static GType ceiling_node_get_type_once (void);
static Number* fractional_component_node_real_solve_r (RNode* base,
                                                Number* r);
static GType fractional_component_node_get_type_once (void);
static Number* round_node_real_solve_r (RNode* base,
                                 Number* r);
static GType round_node_get_type_once (void);
static Number* percent_node_real_solve_r (RNode* base,
                                   Number* r);
static GType percent_node_get_type_once (void);
static Number* factorial_node_real_solve_r (RNode* base,
                                     Number* r);
static GType factorial_node_get_type_once (void);
static Number* add_node_real_solve_lr (LRNode* base,
                                Number* l,
                                Number* r);
static void add_node_finalize (GObject * obj);
static GType add_node_get_type_once (void);
static Number* subtract_node_real_solve_lr (LRNode* base,
                                     Number* l,
                                     Number* r);
static void subtract_node_finalize (GObject * obj);
static GType subtract_node_get_type_once (void);
static Number* multiply_node_real_solve_lr (LRNode* base,
                                     Number* l,
                                     Number* r);
static GType multiply_node_get_type_once (void);
static Number* shift_node_real_solve_lr (LRNode* base,
                                  Number* l,
                                  Number* r);
static GType shift_node_get_type_once (void);
static Number* divide_node_real_solve_lr (LRNode* base,
                                   Number* l,
                                   Number* r);
static GType divide_node_get_type_once (void);
static Number* modulus_divide_node_real_solve (ParseNode* base);
static Number* modulus_divide_node_real_solve_lr (LRNode* base,
                                           Number* l,
                                           Number* r);
static GType modulus_divide_node_get_type_once (void);
static Number* root_node_real_solve_r (RNode* base,
                                Number* r);
static void root_node_finalize (GObject * obj);
static GType root_node_get_type_once (void);
static Number* xpow_ynode_real_solve_lr (LRNode* base,
                                  Number* l,
                                  Number* r);
static GType xpow_ynode_get_type_once (void);
static Number* xpow_yinteger_node_real_solve (ParseNode* base);
static GType xpow_yinteger_node_get_type_once (void);
static Number* not_node_real_solve_r (RNode* base,
                               Number* r);
static GType not_node_get_type_once (void);
static Number* and_node_real_solve_lr (LRNode* base,
                                Number* l,
                                Number* r);
static GType and_node_get_type_once (void);
static Number* nand_node_real_solve_lr (LRNode* base,
                                 Number* l,
                                 Number* r);
static GType nand_node_get_type_once (void);
static Number* or_node_real_solve_lr (LRNode* base,
                               Number* l,
                               Number* r);
static GType or_node_get_type_once (void);
static Number* nor_node_real_solve_lr (LRNode* base,
                                Number* l,
                                Number* r);
static GType nor_node_get_type_once (void);
static Number* xor_node_real_solve_lr (LRNode* base,
                                Number* l,
                                Number* r);
static GType xor_node_get_type_once (void);
static Number* xnor_node_real_solve_lr (LRNode* base,
                                 Number* l,
                                 Number* r);
static GType xnor_node_get_type_once (void);
static Number* convert_node_real_solve_lr (LRNode* base,
                                    Number* l,
                                    Number* r);
static GType convert_node_get_type_once (void);
static Number* convert_base_node_real_solve (ParseNode* base);
static GType convert_base_node_get_type_once (void);
static Number* convert_number_node_real_solve (ParseNode* base);
static GType convert_number_node_get_type_once (void);
static gboolean parser_statement (Parser* self);
static gboolean parser_real_variable_is_defined (Parser* self,
                                          const gchar* name);
static Number* parser_real_get_variable (Parser* self,
                                  const gchar* name);
static void parser_real_set_variable (Parser* self,
                               const gchar* name,
                               Number* x);
static gboolean parser_real_function_is_defined (Parser* self,
                                          const gchar* name);
static gboolean parser_real_unit_is_defined (Parser* self,
                                      const gchar* name);
static gboolean parser_real_currency_is_defined (Parser* self,
                                          const gchar* name);
static gboolean parser_real_currency_has_rate (Parser* self,
                                        const gchar* name);
static gboolean parser_real_literal_base_is_defined (Parser* self,
                                              const gchar* name);
static Number* parser_real_convert (Parser* self,
                             Number* x,
                             const gchar* x_units,
                             const gchar* z_units,
                             Unit** x_unit,
                             Unit** z_unit);
static Precedence parser_get_precedence (Parser* self,
                                  LexerTokenType type);
static Associativity parser_get_associativity_p (Parser* self,
                                          Precedence type);
static Associativity parser_get_associativity (Parser* self,
                                        LexerToken* token);
static guint parser_make_precedence_p (Parser* self,
                                Precedence p);
static guint parser_make_precedence_t (Parser* self,
                                LexerTokenType type);
static gboolean parser_cmp_nodes (Parser* self,
                           ParseNode* left,
                           ParseNode* right);
static void parser_insert_into_tree_all (Parser* self,
                                  ParseNode* node,
                                  gboolean unary_function);
static void parser_insert_into_tree (Parser* self,
                              ParseNode* node);
static void parser_insert_into_tree_unary (Parser* self,
                                    ParseNode* node);
static void parser_destroy_all_nodes (Parser* self,
                               ParseNode* node);
static gboolean parser_check_variable (Parser* self,
                                const gchar* name);
static gboolean parser_expression (Parser* self);
static gboolean parser_function_definition (Parser* self);
static gboolean parser_conversion (Parser* self);
static gboolean parser_expression_1 (Parser* self);
static gboolean parser_expression_2 (Parser* self);
static gboolean parser_variable (Parser* self);
static gboolean parser_function_invocation (Parser* self);
static gboolean parser_term (Parser* self);
static gboolean parser_term_2 (Parser* self);
static void _g_free0_ (gpointer var);
static void parser_finalize (Parser * obj);
static GType parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static GType
associativity_get_type_once (void)
{
	static const GEnumValue values[] = {{ASSOCIATIVITY_LEFT, "ASSOCIATIVITY_LEFT", "left"}, {ASSOCIATIVITY_RIGHT, "ASSOCIATIVITY_RIGHT", "right"}, {0, NULL, NULL}};
	GType associativity_type_id;
	associativity_type_id = g_enum_register_static ("Associativity", values);
	return associativity_type_id;
}

GType
associativity_get_type (void)
{
	static volatile gsize associativity_type_id__once = 0;
	if (g_once_init_enter (&associativity_type_id__once)) {
		GType associativity_type_id;
		associativity_type_id = associativity_get_type_once ();
		g_once_init_leave (&associativity_type_id__once, associativity_type_id);
	}
	return associativity_type_id__once;
}

static GType
precedence_get_type_once (void)
{
	static const GEnumValue values[] = {{PRECEDENCE_UNKNOWN, "PRECEDENCE_UNKNOWN", "unknown"}, {PRECEDENCE_CONVERT, "PRECEDENCE_CONVERT", "convert"}, {PRECEDENCE_UNIT, "PRECEDENCE_UNIT", "unit"}, {PRECEDENCE_TOP, "PRECEDENCE_TOP", "top"}, {PRECEDENCE_ADD_SUBTRACT, "PRECEDENCE_ADD_SUBTRACT", "add-subtract"}, {PRECEDENCE_MULTIPLY, "PRECEDENCE_MULTIPLY", "multiply"}, {PRECEDENCE_MOD, "PRECEDENCE_MOD", "mod"}, {PRECEDENCE_DIVIDE, "PRECEDENCE_DIVIDE", "divide"}, {PRECEDENCE_NOT, "PRECEDENCE_NOT", "not"}, {PRECEDENCE_FUNCTION, "PRECEDENCE_FUNCTION", "function"}, {PRECEDENCE_BOOLEAN, "PRECEDENCE_BOOLEAN", "boolean"}, {PRECEDENCE_SHIFT, "PRECEDENCE_SHIFT", "shift"}, {PRECEDENCE_PERCENTAGE, "PRECEDENCE_PERCENTAGE", "percentage"}, {PRECEDENCE_UNARY_MINUS, "PRECEDENCE_UNARY_MINUS", "unary-minus"}, {PRECEDENCE_POWER, "PRECEDENCE_POWER", "power"}, {PRECEDENCE_ROOT, "PRECEDENCE_ROOT", "root"}, {PRECEDENCE_FACTORIAL, "PRECEDENCE_FACTORIAL", "factorial"}, {PRECEDENCE_NUMBER_VARIABLE, "PRECEDENCE_NUMBER_VARIABLE", "number-variable"}, {PRECEDENCE_DEPTH, "PRECEDENCE_DEPTH", "depth"}, {0, NULL, NULL}};
	GType precedence_type_id;
	precedence_type_id = g_enum_register_static ("Precedence", values);
	return precedence_type_id;
}

GType
precedence_get_type (void)
{
	static volatile gsize precedence_type_id__once = 0;
	if (g_once_init_enter (&precedence_type_id__once)) {
		GType precedence_type_id;
		precedence_type_id = precedence_get_type_once ();
		g_once_init_leave (&precedence_type_id__once, precedence_type_id);
	}
	return precedence_type_id__once;
}

static void
_vala_Constant_array_free (Constant * array,
                           gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			constant_destroy (&array[i]);
		}
	}
	g_free (array);
}

static Constant*
_vala_array_dup1 (Constant* self,
                  gssize length)
{
	if (length > 0) {
		Constant* result;
		gssize i;
		result = g_new0 (Constant, length);
		for (i = 0; i < length; i++) {
			Constant _tmp0_;
			Constant _tmp1_ = {0};
			_tmp0_ = self[i];
			constant_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

void
constant_category_copy (const ConstantCategory* self,
                        ConstantCategory* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	Constant* _tmp2_;
	gint _tmp2__length1;
	Constant* _tmp3_;
	gint _tmp3__length1;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).constants;
	_tmp2__length1 = (*self).constants_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup1 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).constants = (_vala_Constant_array_free ((*dest).constants, (*dest).constants_length1), NULL);
	(*dest).constants = _tmp3_;
	(*dest).constants_length1 = _tmp3__length1;
}

void
constant_category_destroy (ConstantCategory* self)
{
	_g_free0 ((*self).name);
	(*self).constants = (_vala_Constant_array_free ((*self).constants, (*self).constants_length1), NULL);
}

ConstantCategory*
constant_category_dup (const ConstantCategory* self)
{
	ConstantCategory* dup;
	dup = g_new0 (ConstantCategory, 1);
	constant_category_copy (self, dup);
	return dup;
}

void
constant_category_free (ConstantCategory* self)
{
	constant_category_destroy (self);
	g_free (self);
}

static GType
constant_category_get_type_once (void)
{
	GType constant_category_type_id;
	constant_category_type_id = g_boxed_type_register_static ("ConstantCategory", (GBoxedCopyFunc) constant_category_dup, (GBoxedFreeFunc) constant_category_free);
	return constant_category_type_id;
}

GType
constant_category_get_type (void)
{
	static volatile gsize constant_category_type_id__once = 0;
	if (g_once_init_enter (&constant_category_type_id__once)) {
		GType constant_category_type_id;
		constant_category_type_id = constant_category_get_type_once ();
		g_once_init_leave (&constant_category_type_id__once, constant_category_type_id);
	}
	return constant_category_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
constant_copy (const Constant* self,
               Constant* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).symbol;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).symbol);
	(*dest).symbol = _tmp3_;
	_tmp4_ = (*self).number;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).number);
	(*dest).number = _tmp5_;
}

void
constant_destroy (Constant* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).symbol);
	_g_object_unref0 ((*self).number);
}

Constant*
constant_dup (const Constant* self)
{
	Constant* dup;
	dup = g_new0 (Constant, 1);
	constant_copy (self, dup);
	return dup;
}

void
constant_free (Constant* self)
{
	constant_destroy (self);
	g_free (self);
}

static GType
constant_get_type_once (void)
{
	GType constant_type_id;
	constant_type_id = g_boxed_type_register_static ("Constant", (GBoxedCopyFunc) constant_dup, (GBoxedFreeFunc) constant_free);
	return constant_type_id;
}

GType
constant_get_type (void)
{
	static volatile gsize constant_type_id__once = 0;
	if (g_once_init_enter (&constant_type_id__once)) {
		GType constant_type_id;
		constant_type_id = constant_get_type_once ();
		g_once_init_leave (&constant_type_id__once, constant_type_id);
	}
	return constant_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

LexerToken*
parse_node_token (ParseNode* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	LexerToken* _tmp4_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->token_list;
	_vala_assert (g_list_length (_tmp0_) == ((guint) 1), "token_list.length() == 1");
	_tmp1_ = self->token_list;
	_tmp2_ = g_list_first (_tmp1_);
	_tmp3_ = _tmp2_->data;
	_tmp4_ = _g_object_ref0 ((LexerToken*) _tmp3_);
	result = _tmp4_;
	return result;
}

LexerToken*
parse_node_first_token (ParseNode* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	LexerToken* _tmp3_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->token_list;
	_tmp1_ = g_list_first (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((LexerToken*) _tmp2_);
	result = _tmp3_;
	return result;
}

LexerToken*
parse_node_last_token (ParseNode* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	LexerToken* _tmp3_;
	LexerToken* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->token_list;
	_tmp1_ = g_list_last (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((LexerToken*) _tmp2_);
	result = _tmp3_;
	return result;
}

static gpointer
_parser_ref0 (gpointer self)
{
	return self ? parser_ref (self) : NULL;
}

ParseNode*
parse_node_construct_WithList (GType object_type,
                               Parser* parser,
                               GList* token_list,
                               guint precedence,
                               Associativity associativity,
                               const gchar* value)
{
	ParseNode * self = NULL;
	Parser* _tmp0_;
	GList* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ParseNode*) g_object_new (object_type, NULL);
	_tmp0_ = _parser_ref0 (parser);
	_parser_unref0 (self->parser);
	self->parser = _tmp0_;
	_tmp1_ = g_list_copy_deep (token_list, (GCopyFunc) g_object_ref, NULL);
	(self->token_list == NULL) ? NULL : (self->token_list = (_g_list_free__g_object_unref0_ (self->token_list), NULL));
	self->token_list = _tmp1_;
	self->precedence = precedence;
	self->associativity = associativity;
	_tmp2_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp2_;
	return self;
}

ParseNode*
parse_node_new_WithList (Parser* parser,
                         GList* token_list,
                         guint precedence,
                         Associativity associativity,
                         const gchar* value)
{
	return parse_node_construct_WithList (TYPE_PARSE_NODE, parser, token_list, precedence, associativity, value);
}

ParseNode*
parse_node_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity,
                      const gchar* value)
{
	ParseNode * self = NULL;
	Parser* _tmp0_;
	LexerToken* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ParseNode*) g_object_new (object_type, NULL);
	_tmp0_ = _parser_ref0 (parser);
	_parser_unref0 (self->parser);
	self->parser = _tmp0_;
	(self->token_list == NULL) ? NULL : (self->token_list = (_g_list_free__g_object_unref0_ (self->token_list), NULL));
	self->token_list = NULL;
	_tmp1_ = _g_object_ref0 (token);
	self->token_list = g_list_insert (self->token_list, _tmp1_, 0);
	self->precedence = precedence;
	self->associativity = associativity;
	_tmp2_ = g_strdup (value);
	_g_free0 (self->value);
	self->value = _tmp2_;
	return self;
}

ParseNode*
parse_node_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity,
                const gchar* value)
{
	return parse_node_construct (TYPE_PARSE_NODE, parser, token, precedence, associativity, value);
}

static Number*
parse_node_real_solve (ParseNode* self)
{
	Number* result;
	result = NULL;
	return result;
}

Number*
parse_node_solve (ParseNode* self)
{
	ParseNodeClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PARSE_NODE_GET_CLASS (self);
	if (_klass_->solve) {
		return _klass_->solve (self);
	}
	return NULL;
}

static void
parse_node_class_init (ParseNodeClass * klass,
                       gpointer klass_data)
{
	parse_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) parse_node_real_solve;
	G_OBJECT_CLASS (klass)->finalize = parse_node_finalize;
}

static void
parse_node_instance_init (ParseNode * self,
                          gpointer klass)
{
	self->parent = NULL;
	self->left = NULL;
	self->right = NULL;
}

static void
parse_node_finalize (GObject * obj)
{
	ParseNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PARSE_NODE, ParseNode);
	_parser_unref0 (self->parser);
	_g_object_unref0 (self->parent);
	_g_object_unref0 (self->left);
	_g_object_unref0 (self->right);
	(self->token_list == NULL) ? NULL : (self->token_list = (_g_list_free__g_object_unref0_ (self->token_list), NULL));
	_g_free0 (self->value);
	G_OBJECT_CLASS (parse_node_parent_class)->finalize (obj);
}

static GType
parse_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ParseNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) parse_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ParseNode), 0, (GInstanceInitFunc) parse_node_instance_init, NULL };
	GType parse_node_type_id;
	parse_node_type_id = g_type_register_static (G_TYPE_OBJECT, "ParseNode", &g_define_type_info, 0);
	return parse_node_type_id;
}

GType
parse_node_get_type (void)
{
	static volatile gsize parse_node_type_id__once = 0;
	if (g_once_init_enter (&parse_node_type_id__once)) {
		GType parse_node_type_id;
		parse_node_type_id = parse_node_get_type_once ();
		g_once_init_leave (&parse_node_type_id__once, parse_node_type_id);
	}
	return parse_node_type_id__once;
}

RNode*
rnode_construct (GType object_type,
                 Parser* parser,
                 LexerToken* token,
                 guint precedence,
                 Associativity associativity)
{
	RNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (RNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}

static Number*
rnode_real_solve (ParseNode* base)
{
	RNode * self;
	Number* r = NULL;
	ParseNode* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* z = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	Number* result;
	self = (RNode*) base;
	_tmp0_ = ((ParseNode*) self)->right;
	_tmp1_ = parse_node_solve (_tmp0_);
	r = _tmp1_;
	_tmp2_ = r;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (r);
		return result;
	}
	_tmp3_ = r;
	_tmp4_ = rnode_solve_r (self, _tmp3_);
	z = _tmp4_;
	number_check_flags ();
	_tmp5_ = number_get_error ();
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp7_;
		ParseNode* _tmp8_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp9_;
		ParseNode* _tmp10_;
		Parser* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		ParseNode* _tmp24_;
		LexerToken* _tmp25_;
		LexerToken* _tmp26_;
		ParseNode* _tmp27_;
		LexerToken* _tmp28_;
		LexerToken* _tmp29_;
		_tmp7_ = ((ParseNode*) self)->right;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		tmpleft = _tmp8_;
		_tmp9_ = ((ParseNode*) self)->right;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		tmpright = _tmp10_;
		while (TRUE) {
			ParseNode* _tmp11_;
			ParseNode* _tmp12_;
			ParseNode* _tmp13_;
			ParseNode* _tmp14_;
			ParseNode* _tmp15_;
			_tmp11_ = tmpleft;
			_tmp12_ = _tmp11_->left;
			if (!(_tmp12_ != NULL)) {
				break;
			}
			_tmp13_ = tmpleft;
			_tmp14_ = _tmp13_->left;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp15_;
		}
		while (TRUE) {
			ParseNode* _tmp16_;
			ParseNode* _tmp17_;
			ParseNode* _tmp18_;
			ParseNode* _tmp19_;
			ParseNode* _tmp20_;
			_tmp16_ = tmpright;
			_tmp17_ = _tmp16_->right;
			if (!(_tmp17_ != NULL)) {
				break;
			}
			_tmp18_ = tmpright;
			_tmp19_ = _tmp18_->right;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp20_;
		}
		_tmp21_ = ((ParseNode*) self)->parser;
		_tmp22_ = number_get_error ();
		_tmp23_ = _tmp22_;
		_tmp24_ = tmpleft;
		_tmp25_ = parse_node_first_token (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = tmpright;
		_tmp28_ = parse_node_last_token (_tmp27_);
		_tmp29_ = _tmp28_;
		parser_set_error (_tmp21_, ERROR_CODE_MP, _tmp23_, _tmp26_->start_index, _tmp29_->end_index);
		_g_object_unref0 (_tmp29_);
		_g_object_unref0 (_tmp26_);
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = z;
	_g_object_unref0 (r);
	return result;
}

static Number*
rnode_real_solve_r (RNode* self,
                    Number* r)
{
	g_critical ("Type `%s' does not implement abstract method `rnode_solve_r'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

Number*
rnode_solve_r (RNode* self,
               Number* r)
{
	RNodeClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RNODE_GET_CLASS (self);
	if (_klass_->solve_r) {
		return _klass_->solve_r (self, r);
	}
	return NULL;
}

static void
rnode_class_init (RNodeClass * klass,
                  gpointer klass_data)
{
	rnode_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) rnode_real_solve;
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) rnode_real_solve_r;
}

static void
rnode_instance_init (RNode * self,
                     gpointer klass)
{
}

static GType
rnode_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rnode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RNode), 0, (GInstanceInitFunc) rnode_instance_init, NULL };
	GType rnode_type_id;
	rnode_type_id = g_type_register_static (TYPE_PARSE_NODE, "RNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return rnode_type_id;
}

GType
rnode_get_type (void)
{
	static volatile gsize rnode_type_id__once = 0;
	if (g_once_init_enter (&rnode_type_id__once)) {
		GType rnode_type_id;
		rnode_type_id = rnode_get_type_once ();
		g_once_init_leave (&rnode_type_id__once, rnode_type_id);
	}
	return rnode_type_id__once;
}

LRNode*
lr_node_construct (GType object_type,
                   Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	LRNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (LRNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}

gboolean
lr_node_is_repeatable (LRNode* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->repeatable;
	return result;
}

static Number*
lr_node_real_solve (ParseNode* base)
{
	LRNode * self;
	Number* l = NULL;
	ParseNode* _tmp0_;
	Number* _tmp1_;
	Number* r = NULL;
	ParseNode* _tmp2_;
	Number* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Number* _tmp5_;
	Number* z = NULL;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	Number* result;
	self = (LRNode*) base;
	_tmp0_ = ((ParseNode*) self)->left;
	_tmp1_ = parse_node_solve (_tmp0_);
	l = _tmp1_;
	_tmp2_ = ((ParseNode*) self)->right;
	_tmp3_ = parse_node_solve (_tmp2_);
	r = _tmp3_;
	_tmp5_ = l;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		Number* _tmp6_;
		_tmp6_ = r;
		_tmp4_ = _tmp6_ == NULL;
	}
	if (_tmp4_) {
		result = NULL;
		_g_object_unref0 (r);
		_g_object_unref0 (l);
		return result;
	}
	_tmp7_ = l;
	_tmp8_ = r;
	_tmp9_ = lr_node_solve_lr (self, _tmp7_, _tmp8_);
	z = _tmp9_;
	number_check_flags ();
	_tmp10_ = number_get_error ();
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp12_;
		ParseNode* _tmp13_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp14_;
		ParseNode* _tmp15_;
		Parser* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ParseNode* _tmp29_;
		LexerToken* _tmp30_;
		LexerToken* _tmp31_;
		ParseNode* _tmp32_;
		LexerToken* _tmp33_;
		LexerToken* _tmp34_;
		_tmp12_ = ((ParseNode*) self)->left;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		tmpleft = _tmp13_;
		_tmp14_ = ((ParseNode*) self)->right;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		tmpright = _tmp15_;
		while (TRUE) {
			ParseNode* _tmp16_;
			ParseNode* _tmp17_;
			ParseNode* _tmp18_;
			ParseNode* _tmp19_;
			ParseNode* _tmp20_;
			_tmp16_ = tmpleft;
			_tmp17_ = _tmp16_->left;
			if (!(_tmp17_ != NULL)) {
				break;
			}
			_tmp18_ = tmpleft;
			_tmp19_ = _tmp18_->left;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp20_;
		}
		while (TRUE) {
			ParseNode* _tmp21_;
			ParseNode* _tmp22_;
			ParseNode* _tmp23_;
			ParseNode* _tmp24_;
			ParseNode* _tmp25_;
			_tmp21_ = tmpright;
			_tmp22_ = _tmp21_->right;
			if (!(_tmp22_ != NULL)) {
				break;
			}
			_tmp23_ = tmpright;
			_tmp24_ = _tmp23_->right;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp25_;
		}
		_tmp26_ = ((ParseNode*) self)->parser;
		_tmp27_ = number_get_error ();
		_tmp28_ = _tmp27_;
		_tmp29_ = tmpleft;
		_tmp30_ = parse_node_first_token (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = tmpright;
		_tmp33_ = parse_node_last_token (_tmp32_);
		_tmp34_ = _tmp33_;
		parser_set_error (_tmp26_, ERROR_CODE_MP, _tmp28_, _tmp31_->start_index, _tmp34_->end_index);
		_g_object_unref0 (_tmp34_);
		_g_object_unref0 (_tmp31_);
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = z;
	_g_object_unref0 (r);
	_g_object_unref0 (l);
	return result;
}

static Number*
lr_node_real_solve_lr (LRNode* self,
                       Number* left,
                       Number* r)
{
	g_critical ("Type `%s' does not implement abstract method `lr_node_solve_lr'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

Number*
lr_node_solve_lr (LRNode* self,
                  Number* left,
                  Number* r)
{
	LRNodeClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = LR_NODE_GET_CLASS (self);
	if (_klass_->solve_lr) {
		return _klass_->solve_lr (self, left, r);
	}
	return NULL;
}

static void
lr_node_class_init (LRNodeClass * klass,
                    gpointer klass_data)
{
	lr_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) lr_node_real_solve;
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) lr_node_real_solve_lr;
	G_OBJECT_CLASS (klass)->finalize = lr_node_finalize;
}

static void
lr_node_instance_init (LRNode * self,
                       gpointer klass)
{
	self->repeatable = FALSE;
}

static void
lr_node_finalize (GObject * obj)
{
	LRNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LR_NODE, LRNode);
	G_OBJECT_CLASS (lr_node_parent_class)->finalize (obj);
}

static GType
lr_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LRNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lr_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LRNode), 0, (GInstanceInitFunc) lr_node_instance_init, NULL };
	GType lr_node_type_id;
	lr_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "LRNode", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return lr_node_type_id;
}

GType
lr_node_get_type (void)
{
	static volatile gsize lr_node_type_id__once = 0;
	if (g_once_init_enter (&lr_node_type_id__once)) {
		GType lr_node_type_id;
		lr_node_type_id = lr_node_get_type_once ();
		g_once_init_leave (&lr_node_type_id__once, lr_node_type_id);
	}
	return lr_node_type_id__once;
}

ConstantNode*
constant_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	ConstantNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ConstantNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}

ConstantNode*
constant_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	return constant_node_construct (TYPE_CONSTANT_NODE, parser, token, precedence, associativity);
}

static Number*
constant_node_real_solve (ParseNode* base)
{
	ConstantNode * self;
	LexerToken* _tmp0_;
	LexerToken* _tmp1_;
	const gchar* _tmp2_;
	Parser* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* result;
	self = (ConstantNode*) base;
	_tmp0_ = parse_node_token ((ParseNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->text;
	_tmp3_ = ((ParseNode*) self)->parser;
	_tmp4_ = mp_set_from_string (_tmp2_, _tmp3_->number_base, TRUE);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static void
constant_node_class_init (ConstantNodeClass * klass,
                          gpointer klass_data)
{
	constant_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) constant_node_real_solve;
}

static void
constant_node_instance_init (ConstantNode * self,
                             gpointer klass)
{
}

static GType
constant_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConstantNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) constant_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConstantNode), 0, (GInstanceInitFunc) constant_node_instance_init, NULL };
	GType constant_node_type_id;
	constant_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConstantNode", &g_define_type_info, 0);
	return constant_node_type_id;
}

GType
constant_node_get_type (void)
{
	static volatile gsize constant_node_type_id__once = 0;
	if (g_once_init_enter (&constant_node_type_id__once)) {
		GType constant_node_type_id;
		constant_node_type_id = constant_node_get_type_once ();
		g_once_init_leave (&constant_node_type_id__once, constant_node_type_id);
	}
	return constant_node_type_id__once;
}

AssignNode*
assign_node_construct (GType object_type,
                       Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity)
{
	AssignNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AssignNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

AssignNode*
assign_node_new (Parser* parser,
                 LexerToken* token,
                 guint precedence,
                 Associativity associativity)
{
	return assign_node_construct (TYPE_ASSIGN_NODE, parser, token, precedence, associativity);
}

static Number*
assign_node_real_solve_r (RNode* base,
                          Number* r)
{
	AssignNode * self;
	Parser* _tmp0_;
	ParseNode* _tmp1_;
	LexerToken* _tmp2_;
	LexerToken* _tmp3_;
	const gchar* _tmp4_;
	Number* _tmp5_;
	Number* result;
	self = (AssignNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = ((ParseNode*) self)->left;
	_tmp2_ = parse_node_token (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->text;
	parser_set_variable (_tmp0_, _tmp4_, r);
	_g_object_unref0 (_tmp3_);
	_tmp5_ = _g_object_ref0 (r);
	result = _tmp5_;
	return result;
}

static void
assign_node_class_init (AssignNodeClass * klass,
                        gpointer klass_data)
{
	assign_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) assign_node_real_solve_r;
}

static void
assign_node_instance_init (AssignNode * self,
                           gpointer klass)
{
}

static GType
assign_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AssignNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assign_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssignNode), 0, (GInstanceInitFunc) assign_node_instance_init, NULL };
	GType assign_node_type_id;
	assign_node_type_id = g_type_register_static (TYPE_RNODE, "AssignNode", &g_define_type_info, 0);
	return assign_node_type_id;
}

GType
assign_node_get_type (void)
{
	static volatile gsize assign_node_type_id__once = 0;
	if (g_once_init_enter (&assign_node_type_id__once)) {
		GType assign_node_type_id;
		assign_node_type_id = assign_node_get_type_once ();
		g_once_init_leave (&assign_node_type_id__once, assign_node_type_id);
	}
	return assign_node_type_id__once;
}

AssignFunctionNode*
assign_function_node_construct (GType object_type,
                                Parser* parser,
                                LexerToken* token,
                                guint precedence,
                                Associativity associativity)
{
	AssignFunctionNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AssignFunctionNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}

AssignFunctionNode*
assign_function_node_new (Parser* parser,
                          LexerToken* token,
                          guint precedence,
                          Associativity associativity)
{
	return assign_function_node_construct (TYPE_ASSIGN_FUNCTION_NODE, parser, token, precedence, associativity);
}

static Number*
assign_function_node_real_solve (ParseNode* base)
{
	AssignFunctionNode * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	ParseNode* _tmp3_;
	gchar* function_name = NULL;
	ParseNode* _tmp9_;
	ParseNode* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* arguments = NULL;
	ParseNode* _tmp13_;
	ParseNode* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* description = NULL;
	ParseNode* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp20_;
	FunctionManager* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	Parser* _tmp25_;
	Number* result;
	self = (AssignFunctionNode*) base;
	_tmp3_ = ((ParseNode*) self)->left;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ParseNode* _tmp4_;
		_tmp4_ = ((ParseNode*) self)->right;
		_tmp2_ = _tmp4_ == NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		ParseNode* _tmp5_;
		ParseNode* _tmp6_;
		_tmp5_ = ((ParseNode*) self)->left;
		_tmp6_ = _tmp5_->left;
		_tmp1_ = _tmp6_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ParseNode* _tmp7_;
		ParseNode* _tmp8_;
		_tmp7_ = ((ParseNode*) self)->left;
		_tmp8_ = _tmp7_->right;
		_tmp0_ = _tmp8_ == NULL;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp9_ = ((ParseNode*) self)->left;
	_tmp10_ = _tmp9_->left;
	_tmp11_ = _tmp10_->value;
	_tmp12_ = g_strdup (_tmp11_);
	function_name = _tmp12_;
	_tmp13_ = ((ParseNode*) self)->left;
	_tmp14_ = _tmp13_->right;
	_tmp15_ = _tmp14_->value;
	_tmp16_ = g_strdup (_tmp15_);
	arguments = _tmp16_;
	_tmp17_ = ((ParseNode*) self)->right;
	_tmp18_ = _tmp17_->value;
	_tmp19_ = g_strdup (_tmp18_);
	description = _tmp19_;
	_tmp20_ = function_manager_get_default_function_manager ();
	function_manager = _tmp20_;
	_tmp21_ = function_manager;
	_tmp22_ = function_name;
	_tmp23_ = arguments;
	_tmp24_ = description;
	_tmp25_ = ((ParseNode*) self)->parser;
	if (function_manager_add_function_with_properties (_tmp21_, _tmp22_, _tmp23_, _tmp24_, _tmp25_)) {
		Number* _tmp26_;
		_tmp26_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp26_;
		_g_object_unref0 (function_manager);
		_g_free0 (description);
		_g_free0 (arguments);
		_g_free0 (function_name);
		return result;
	}
	result = NULL;
	_g_object_unref0 (function_manager);
	_g_free0 (description);
	_g_free0 (arguments);
	_g_free0 (function_name);
	return result;
}

static void
assign_function_node_class_init (AssignFunctionNodeClass * klass,
                                 gpointer klass_data)
{
	assign_function_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) assign_function_node_real_solve;
}

static void
assign_function_node_instance_init (AssignFunctionNode * self,
                                    gpointer klass)
{
}

static GType
assign_function_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AssignFunctionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assign_function_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssignFunctionNode), 0, (GInstanceInitFunc) assign_function_node_instance_init, NULL };
	GType assign_function_node_type_id;
	assign_function_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "AssignFunctionNode", &g_define_type_info, 0);
	return assign_function_node_type_id;
}

GType
assign_function_node_get_type (void)
{
	static volatile gsize assign_function_node_type_id__once = 0;
	if (g_once_init_enter (&assign_function_node_type_id__once)) {
		GType assign_function_node_type_id;
		assign_function_node_type_id = assign_function_node_get_type_once ();
		g_once_init_leave (&assign_function_node_type_id__once, assign_function_node_type_id);
	}
	return assign_function_node_type_id__once;
}

NameNode*
name_node_construct (GType object_type,
                     Parser* parser,
                     LexerToken* token,
                     guint precedence,
                     Associativity associativity,
                     const gchar* text)
{
	NameNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (NameNode*) parse_node_construct (object_type, parser, token, precedence, associativity, text);
	return self;
}

NameNode*
name_node_new (Parser* parser,
               LexerToken* token,
               guint precedence,
               Associativity associativity,
               const gchar* text)
{
	return name_node_construct (TYPE_NAME_NODE, parser, token, precedence, associativity, text);
}

static void
name_node_class_init (NameNodeClass * klass,
                      gpointer klass_data)
{
	name_node_parent_class = g_type_class_peek_parent (klass);
}

static void
name_node_instance_init (NameNode * self,
                         gpointer klass)
{
}

static GType
name_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NameNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) name_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NameNode), 0, (GInstanceInitFunc) name_node_instance_init, NULL };
	GType name_node_type_id;
	name_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "NameNode", &g_define_type_info, 0);
	return name_node_type_id;
}

GType
name_node_get_type (void)
{
	static volatile gsize name_node_type_id__once = 0;
	if (g_once_init_enter (&name_node_type_id__once)) {
		GType name_node_type_id;
		name_node_type_id = name_node_get_type_once ();
		g_once_init_leave (&name_node_type_id__once, name_node_type_id);
	}
	return name_node_type_id__once;
}

VariableNode*
variable_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	VariableNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (VariableNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}

VariableNode*
variable_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	return variable_node_construct (TYPE_VARIABLE_NODE, parser, token, precedence, associativity);
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	g_unichar_to_utf8 (self, str);
	result = str;
	return result;
}

static Number*
variable_node_real_solve (ParseNode* base)
{
	VariableNode * self;
	Number* ans = NULL;
	Parser* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	const gchar* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* value = NULL;
	Number* _tmp7_;
	gint index = 0;
	gunichar c = 0U;
	Number* result;
	self = (VariableNode*) base;
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = parse_node_token ((ParseNode*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->text;
	_tmp4_ = parser_get_variable (_tmp0_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp2_);
	ans = _tmp5_;
	_tmp6_ = ans;
	if (_tmp6_ != NULL) {
		result = ans;
		return result;
	}
	_tmp7_ = number_new_integer ((gint64) 1, (gint64) 0);
	value = _tmp7_;
	index = 0;
	while (TRUE) {
		LexerToken* _tmp8_;
		LexerToken* _tmp9_;
		const gchar* _tmp10_;
		gunichar _tmp11_ = 0U;
		gboolean _tmp12_;
		gboolean _tmp13_;
		Number* t = NULL;
		Parser* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		Number* _tmp17_;
		Number* _tmp18_;
		Number* _tmp19_;
		Number* _tmp28_;
		Number* _tmp29_;
		Number* _tmp30_;
		_tmp8_ = parse_node_token ((ParseNode*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_->text;
		_tmp12_ = string_get_next_char (_tmp10_, &index, &_tmp11_);
		c = _tmp11_;
		_tmp13_ = !_tmp12_;
		_g_object_unref0 (_tmp9_);
		if (_tmp13_) {
			break;
		}
		_tmp14_ = ((ParseNode*) self)->parser;
		_tmp15_ = g_unichar_to_string (c);
		_tmp16_ = _tmp15_;
		_tmp17_ = parser_get_variable (_tmp14_, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		t = _tmp18_;
		_tmp19_ = t;
		if (_tmp19_ == NULL) {
			Parser* _tmp20_;
			LexerToken* _tmp21_;
			LexerToken* _tmp22_;
			const gchar* _tmp23_;
			LexerToken* _tmp24_;
			LexerToken* _tmp25_;
			LexerToken* _tmp26_;
			LexerToken* _tmp27_;
			_tmp20_ = ((ParseNode*) self)->parser;
			_tmp21_ = parse_node_token ((ParseNode*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = _tmp22_->text;
			_tmp24_ = parse_node_first_token ((ParseNode*) self);
			_tmp25_ = _tmp24_;
			_tmp26_ = parse_node_last_token ((ParseNode*) self);
			_tmp27_ = _tmp26_;
			parser_set_error (_tmp20_, ERROR_CODE_UNKNOWN_VARIABLE, _tmp23_, _tmp25_->start_index, _tmp27_->end_index);
			_g_object_unref0 (_tmp27_);
			_g_object_unref0 (_tmp25_);
			_g_object_unref0 (_tmp22_);
			result = NULL;
			_g_object_unref0 (t);
			_g_object_unref0 (value);
			_g_object_unref0 (ans);
			return result;
		}
		_tmp28_ = value;
		_tmp29_ = t;
		_tmp30_ = number_multiply (_tmp28_, _tmp29_);
		_g_object_unref0 (value);
		value = _tmp30_;
		_g_object_unref0 (t);
	}
	result = value;
	_g_object_unref0 (ans);
	return result;
}

static void
variable_node_class_init (VariableNodeClass * klass,
                          gpointer klass_data)
{
	variable_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) variable_node_real_solve;
}

static void
variable_node_instance_init (VariableNode * self,
                             gpointer klass)
{
}

static GType
variable_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VariableNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableNode), 0, (GInstanceInitFunc) variable_node_instance_init, NULL };
	GType variable_node_type_id;
	variable_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "VariableNode", &g_define_type_info, 0);
	return variable_node_type_id;
}

GType
variable_node_get_type (void)
{
	static volatile gsize variable_node_type_id__once = 0;
	if (g_once_init_enter (&variable_node_type_id__once)) {
		GType variable_node_type_id;
		variable_node_type_id = variable_node_get_type_once ();
		g_once_init_leave (&variable_node_type_id__once, variable_node_type_id);
	}
	return variable_node_type_id__once;
}

VariableWithPowerNode*
variable_with_power_node_construct (GType object_type,
                                    Parser* parser,
                                    LexerToken* token,
                                    guint precedence,
                                    Associativity associativity,
                                    const gchar* text)
{
	VariableWithPowerNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	self = (VariableWithPowerNode*) parse_node_construct (object_type, parser, token, precedence, associativity, text);
	return self;
}

VariableWithPowerNode*
variable_with_power_node_new (Parser* parser,
                              LexerToken* token,
                              guint precedence,
                              Associativity associativity,
                              const gchar* text)
{
	return variable_with_power_node_construct (TYPE_VARIABLE_WITH_POWER_NODE, parser, token, precedence, associativity, text);
}

static Number*
variable_with_power_node_real_solve (ParseNode* base)
{
	VariableWithPowerNode * self;
	gint pow = 0;
	const gchar* _tmp0_;
	Number* ans = NULL;
	Parser* _tmp1_;
	LexerToken* _tmp2_;
	LexerToken* _tmp3_;
	const gchar* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* value = NULL;
	Number* _tmp10_;
	gint index = 0;
	gunichar c = 0U;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	Number* result;
	self = (VariableWithPowerNode*) base;
	_tmp0_ = ((ParseNode*) self)->value;
	pow = super_atoi (_tmp0_);
	_g_free0 (((ParseNode*) self)->value);
	((ParseNode*) self)->value = NULL;
	_tmp1_ = ((ParseNode*) self)->parser;
	_tmp2_ = parse_node_token ((ParseNode*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->text;
	_tmp5_ = parser_get_variable (_tmp1_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	ans = _tmp6_;
	_tmp7_ = ans;
	if (_tmp7_ != NULL) {
		Number* _tmp8_;
		Number* _tmp9_;
		_tmp8_ = ans;
		_tmp9_ = number_xpowy_integer (_tmp8_, (gint64) pow);
		result = _tmp9_;
		_g_object_unref0 (ans);
		return result;
	}
	_tmp10_ = number_new_integer ((gint64) 1, (gint64) 0);
	value = _tmp10_;
	index = 0;
	while (TRUE) {
		LexerToken* _tmp11_;
		LexerToken* _tmp12_;
		const gchar* _tmp13_;
		gunichar _tmp14_ = 0U;
		gboolean _tmp15_;
		gboolean _tmp16_;
		Number* t = NULL;
		Parser* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		Number* _tmp20_;
		Number* _tmp21_;
		Number* _tmp22_;
		gint i = 0;
		gunichar next = 0U;
		LexerToken* _tmp31_;
		LexerToken* _tmp32_;
		const gchar* _tmp33_;
		gunichar _tmp34_ = 0U;
		gboolean _tmp35_;
		gboolean _tmp36_;
		Number* _tmp39_;
		Number* _tmp40_;
		Number* _tmp41_;
		_tmp11_ = parse_node_token ((ParseNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_->text;
		_tmp15_ = string_get_next_char (_tmp13_, &index, &_tmp14_);
		c = _tmp14_;
		_tmp16_ = !_tmp15_;
		_g_object_unref0 (_tmp12_);
		if (_tmp16_) {
			break;
		}
		_tmp17_ = ((ParseNode*) self)->parser;
		_tmp18_ = g_unichar_to_string (c);
		_tmp19_ = _tmp18_;
		_tmp20_ = parser_get_variable (_tmp17_, _tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		t = _tmp21_;
		_tmp22_ = t;
		if (_tmp22_ == NULL) {
			Parser* _tmp23_;
			LexerToken* _tmp24_;
			LexerToken* _tmp25_;
			const gchar* _tmp26_;
			LexerToken* _tmp27_;
			LexerToken* _tmp28_;
			LexerToken* _tmp29_;
			LexerToken* _tmp30_;
			_tmp23_ = ((ParseNode*) self)->parser;
			_tmp24_ = parse_node_token ((ParseNode*) self);
			_tmp25_ = _tmp24_;
			_tmp26_ = _tmp25_->text;
			_tmp27_ = parse_node_first_token ((ParseNode*) self);
			_tmp28_ = _tmp27_;
			_tmp29_ = parse_node_last_token ((ParseNode*) self);
			_tmp30_ = _tmp29_;
			parser_set_error (_tmp23_, ERROR_CODE_UNKNOWN_VARIABLE, _tmp26_, _tmp28_->start_index, _tmp30_->end_index);
			_g_object_unref0 (_tmp30_);
			_g_object_unref0 (_tmp28_);
			_g_object_unref0 (_tmp25_);
			result = NULL;
			_g_object_unref0 (t);
			_g_object_unref0 (value);
			_g_object_unref0 (ans);
			return result;
		}
		i = index;
		_tmp31_ = parse_node_token ((ParseNode*) self);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_->text;
		_tmp35_ = string_get_next_char (_tmp33_, &i, &_tmp34_);
		next = _tmp34_;
		_tmp36_ = !_tmp35_;
		_g_object_unref0 (_tmp32_);
		if (_tmp36_) {
			Number* _tmp37_;
			Number* _tmp38_;
			_tmp37_ = t;
			_tmp38_ = number_xpowy_integer (_tmp37_, (gint64) pow);
			_g_object_unref0 (t);
			t = _tmp38_;
		}
		_tmp39_ = value;
		_tmp40_ = t;
		_tmp41_ = number_multiply (_tmp39_, _tmp40_);
		_g_object_unref0 (value);
		value = _tmp41_;
		_g_object_unref0 (t);
	}
	number_check_flags ();
	_tmp42_ = number_get_error ();
	_tmp43_ = _tmp42_;
	if (_tmp43_ != NULL) {
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp44_;
		ParseNode* _tmp45_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp46_;
		ParseNode* _tmp47_;
		Parser* _tmp58_;
		const gchar* _tmp59_;
		const gchar* _tmp60_;
		ParseNode* _tmp61_;
		LexerToken* _tmp62_;
		LexerToken* _tmp63_;
		ParseNode* _tmp64_;
		LexerToken* _tmp65_;
		LexerToken* _tmp66_;
		_tmp44_ = ((ParseNode*) self)->left;
		_tmp45_ = _g_object_ref0 (_tmp44_);
		tmpleft = _tmp45_;
		_tmp46_ = ((ParseNode*) self)->right;
		_tmp47_ = _g_object_ref0 (_tmp46_);
		tmpright = _tmp47_;
		while (TRUE) {
			ParseNode* _tmp48_;
			ParseNode* _tmp49_;
			ParseNode* _tmp50_;
			ParseNode* _tmp51_;
			ParseNode* _tmp52_;
			_tmp48_ = tmpleft;
			_tmp49_ = _tmp48_->left;
			if (!(_tmp49_ != NULL)) {
				break;
			}
			_tmp50_ = tmpleft;
			_tmp51_ = _tmp50_->left;
			_tmp52_ = _g_object_ref0 (_tmp51_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp52_;
		}
		while (TRUE) {
			ParseNode* _tmp53_;
			ParseNode* _tmp54_;
			ParseNode* _tmp55_;
			ParseNode* _tmp56_;
			ParseNode* _tmp57_;
			_tmp53_ = tmpright;
			_tmp54_ = _tmp53_->right;
			if (!(_tmp54_ != NULL)) {
				break;
			}
			_tmp55_ = tmpright;
			_tmp56_ = _tmp55_->right;
			_tmp57_ = _g_object_ref0 (_tmp56_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp57_;
		}
		_tmp58_ = ((ParseNode*) self)->parser;
		_tmp59_ = number_get_error ();
		_tmp60_ = _tmp59_;
		_tmp61_ = tmpleft;
		_tmp62_ = parse_node_first_token (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = tmpright;
		_tmp65_ = parse_node_last_token (_tmp64_);
		_tmp66_ = _tmp65_;
		parser_set_error (_tmp58_, ERROR_CODE_MP, _tmp60_, _tmp63_->start_index, _tmp66_->end_index);
		_g_object_unref0 (_tmp66_);
		_g_object_unref0 (_tmp63_);
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = value;
	_g_object_unref0 (ans);
	return result;
}

static void
variable_with_power_node_class_init (VariableWithPowerNodeClass * klass,
                                     gpointer klass_data)
{
	variable_with_power_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) variable_with_power_node_real_solve;
}

static void
variable_with_power_node_instance_init (VariableWithPowerNode * self,
                                        gpointer klass)
{
}

static GType
variable_with_power_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VariableWithPowerNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) variable_with_power_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VariableWithPowerNode), 0, (GInstanceInitFunc) variable_with_power_node_instance_init, NULL };
	GType variable_with_power_node_type_id;
	variable_with_power_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "VariableWithPowerNode", &g_define_type_info, 0);
	return variable_with_power_node_type_id;
}

GType
variable_with_power_node_get_type (void)
{
	static volatile gsize variable_with_power_node_type_id__once = 0;
	if (g_once_init_enter (&variable_with_power_node_type_id__once)) {
		GType variable_with_power_node_type_id;
		variable_with_power_node_type_id = variable_with_power_node_get_type_once ();
		g_once_init_leave (&variable_with_power_node_type_id__once, variable_with_power_node_type_id);
	}
	return variable_with_power_node_type_id__once;
}

FunctionNameNode*
function_name_node_construct (GType object_type,
                              Parser* parser,
                              LexerToken* token,
                              guint precedence,
                              Associativity associativity,
                              const gchar* name)
{
	FunctionNameNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (FunctionNameNode*) name_node_construct (object_type, parser, token, precedence, associativity, name);
	return self;
}

FunctionNameNode*
function_name_node_new (Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity,
                        const gchar* name)
{
	return function_name_node_construct (TYPE_FUNCTION_NAME_NODE, parser, token, precedence, associativity, name);
}

static void
function_name_node_class_init (FunctionNameNodeClass * klass,
                               gpointer klass_data)
{
	function_name_node_parent_class = g_type_class_peek_parent (klass);
}

static void
function_name_node_instance_init (FunctionNameNode * self,
                                  gpointer klass)
{
}

static GType
function_name_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionNameNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_name_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionNameNode), 0, (GInstanceInitFunc) function_name_node_instance_init, NULL };
	GType function_name_node_type_id;
	function_name_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionNameNode", &g_define_type_info, 0);
	return function_name_node_type_id;
}

GType
function_name_node_get_type (void)
{
	static volatile gsize function_name_node_type_id__once = 0;
	if (g_once_init_enter (&function_name_node_type_id__once)) {
		GType function_name_node_type_id;
		function_name_node_type_id = function_name_node_get_type_once ();
		g_once_init_leave (&function_name_node_type_id__once, function_name_node_type_id);
	}
	return function_name_node_type_id__once;
}

FunctionArgumentsNode*
function_arguments_node_construct (GType object_type,
                                   Parser* parser,
                                   GList* token_list,
                                   guint precedence,
                                   Associativity associativity,
                                   const gchar* arguments)
{
	FunctionArgumentsNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (arguments != NULL, NULL);
	self = (FunctionArgumentsNode*) parse_node_construct_WithList (object_type, parser, token_list, precedence, associativity, arguments);
	return self;
}

FunctionArgumentsNode*
function_arguments_node_new (Parser* parser,
                             GList* token_list,
                             guint precedence,
                             Associativity associativity,
                             const gchar* arguments)
{
	return function_arguments_node_construct (TYPE_FUNCTION_ARGUMENTS_NODE, parser, token_list, precedence, associativity, arguments);
}

static void
function_arguments_node_class_init (FunctionArgumentsNodeClass * klass,
                                    gpointer klass_data)
{
	function_arguments_node_parent_class = g_type_class_peek_parent (klass);
}

static void
function_arguments_node_instance_init (FunctionArgumentsNode * self,
                                       gpointer klass)
{
}

static GType
function_arguments_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionArgumentsNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_arguments_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionArgumentsNode), 0, (GInstanceInitFunc) function_arguments_node_instance_init, NULL };
	GType function_arguments_node_type_id;
	function_arguments_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionArgumentsNode", &g_define_type_info, 0);
	return function_arguments_node_type_id;
}

GType
function_arguments_node_get_type (void)
{
	static volatile gsize function_arguments_node_type_id__once = 0;
	if (g_once_init_enter (&function_arguments_node_type_id__once)) {
		GType function_arguments_node_type_id;
		function_arguments_node_type_id = function_arguments_node_get_type_once ();
		g_once_init_leave (&function_arguments_node_type_id__once, function_arguments_node_type_id);
	}
	return function_arguments_node_type_id__once;
}

FunctionDescriptionNode*
function_description_node_construct (GType object_type,
                                     Parser* parser,
                                     LexerToken* token,
                                     guint precedence,
                                     Associativity associativity,
                                     const gchar* description)
{
	FunctionDescriptionNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (description != NULL, NULL);
	self = (FunctionDescriptionNode*) name_node_construct (object_type, parser, token, precedence, associativity, description);
	return self;
}

FunctionDescriptionNode*
function_description_node_new (Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity,
                               const gchar* description)
{
	return function_description_node_construct (TYPE_FUNCTION_DESCRIPTION_NODE, parser, token, precedence, associativity, description);
}

static void
function_description_node_class_init (FunctionDescriptionNodeClass * klass,
                                      gpointer klass_data)
{
	function_description_node_parent_class = g_type_class_peek_parent (klass);
}

static void
function_description_node_instance_init (FunctionDescriptionNode * self,
                                         gpointer klass)
{
}

static GType
function_description_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionDescriptionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_description_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionDescriptionNode), 0, (GInstanceInitFunc) function_description_node_instance_init, NULL };
	GType function_description_node_type_id;
	function_description_node_type_id = g_type_register_static (TYPE_NAME_NODE, "FunctionDescriptionNode", &g_define_type_info, 0);
	return function_description_node_type_id;
}

GType
function_description_node_get_type (void)
{
	static volatile gsize function_description_node_type_id__once = 0;
	if (g_once_init_enter (&function_description_node_type_id__once)) {
		GType function_description_node_type_id;
		function_description_node_type_id = function_description_node_get_type_once ();
		g_once_init_leave (&function_description_node_type_id__once, function_description_node_type_id);
	}
	return function_description_node_type_id__once;
}

FunctionNode*
function_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity,
                         const gchar* text)
{
	FunctionNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (FunctionNode*) parse_node_construct (object_type, parser, token, precedence, associativity, text);
	return self;
}

FunctionNode*
function_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity,
                   const gchar* text)
{
	return function_node_construct (TYPE_FUNCTION_NODE, parser, token, precedence, associativity, text);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_vala_array_add2 (Number** * array,
                  gint* length,
                  gint* size,
                  Number* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Number*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (Number** * array,
                  gint* length,
                  gint* size,
                  Number* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Number*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Number*
function_node_real_solve (ParseNode* base)
{
	FunctionNode * self;
	gboolean _tmp0_ = FALSE;
	ParseNode* _tmp1_;
	gchar* name = NULL;
	ParseNode* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint pow = 0;
	const gchar* _tmp9_;
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp11_;
	gboolean _tmp12_ = FALSE;
	Number** args = NULL;
	Number** _tmp19_;
	gint args_length1;
	gint _args_size_;
	ParseNode* _tmp20_;
	Number** _tmp78_;
	gint _tmp78__length1;
	Number* tmp = NULL;
	FunctionManager* _tmp89_;
	const gchar* _tmp90_;
	Number** _tmp91_;
	gint _tmp91__length1;
	Parser* _tmp92_;
	Number* _tmp93_;
	Number* _tmp94_;
	const gchar* _tmp97_;
	const gchar* _tmp98_;
	Number* result;
	self = (FunctionNode*) base;
	_tmp1_ = ((ParseNode*) self)->right;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ParseNode* _tmp2_;
		_tmp2_ = ((ParseNode*) self)->left;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		Parser* _tmp3_;
		_tmp3_ = ((ParseNode*) self)->parser;
		parser_set_error (_tmp3_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
		result = NULL;
		return result;
	}
	_tmp4_ = ((ParseNode*) self)->left;
	_tmp5_ = _tmp4_->value;
	_tmp6_ = g_strdup (_tmp5_);
	name = _tmp6_;
	_tmp7_ = name;
	if (_tmp7_ == NULL) {
		Parser* _tmp8_;
		_tmp8_ = ((ParseNode*) self)->parser;
		parser_set_error (_tmp8_, ERROR_CODE_UNKNOWN_FUNCTION, NULL, (guint) 0, (guint) 0);
		result = NULL;
		_g_free0 (name);
		return result;
	}
	pow = 1;
	_tmp9_ = ((ParseNode*) self)->value;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = ((ParseNode*) self)->value;
		pow = super_atoi (_tmp10_);
	}
	_tmp11_ = function_manager_get_default_function_manager ();
	function_manager = _tmp11_;
	if (pow < 0) {
		FunctionManager* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp13_ = function_manager;
		_tmp14_ = name;
		_tmp15_ = g_strconcat (_tmp14_, "⁻¹", NULL);
		_tmp16_ = _tmp15_;
		_tmp12_ = function_manager_is_function_defined (_tmp13_, _tmp16_);
		_g_free0 (_tmp16_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp17_ = name;
		_tmp18_ = g_strconcat (_tmp17_, "⁻¹", NULL);
		_g_free0 (name);
		name = _tmp18_;
		pow = -pow;
	}
	_tmp19_ = g_new0 (Number*, 0 + 1);
	args = _tmp19_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp20_ = ((ParseNode*) self)->right;
	if (IS_FUNCTION_ARGUMENTS_NODE (_tmp20_)) {
		gchar* argument_list = NULL;
		ParseNode* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* temp = NULL;
		gchar* _tmp24_;
		gint depth = 0;
		gchar** arguments = NULL;
		const gchar* _tmp42_;
		gchar** _tmp43_;
		gchar** _tmp44_;
		gint arguments_length1;
		gint _arguments_size_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		_tmp21_ = ((ParseNode*) self)->right;
		_tmp22_ = _tmp21_->value;
		_tmp23_ = g_strdup (_tmp22_);
		argument_list = _tmp23_;
		_tmp24_ = g_strdup ("");
		temp = _tmp24_;
		depth = 0;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp25_ = FALSE;
				_tmp25_ = TRUE;
				while (TRUE) {
					const gchar* _tmp27_;
					gint _tmp28_;
					gint _tmp29_;
					gchar* ss = NULL;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					if (!_tmp25_) {
						gint _tmp26_;
						_tmp26_ = i;
						i = _tmp26_ + 1;
					}
					_tmp25_ = FALSE;
					_tmp27_ = argument_list;
					_tmp28_ = strlen (_tmp27_);
					_tmp29_ = _tmp28_;
					if (!(i < _tmp29_)) {
						break;
					}
					_tmp30_ = argument_list;
					_tmp31_ = string_substring (_tmp30_, (glong) i, (glong) 1);
					ss = _tmp31_;
					_tmp32_ = ss;
					if (g_strcmp0 (_tmp32_, "(") == 0) {
						gint _tmp33_;
						_tmp33_ = depth;
						depth = _tmp33_ + 1;
					} else {
						const gchar* _tmp34_;
						_tmp34_ = ss;
						if (g_strcmp0 (_tmp34_, ")") == 0) {
							gint _tmp35_;
							_tmp35_ = depth;
							depth = _tmp35_ - 1;
						} else {
							gboolean _tmp36_ = FALSE;
							const gchar* _tmp37_;
							_tmp37_ = ss;
							if (g_strcmp0 (_tmp37_, ";") == 0) {
								_tmp36_ = depth != 0;
							} else {
								_tmp36_ = FALSE;
							}
							if (_tmp36_) {
								gchar* _tmp38_;
								_tmp38_ = g_strdup ("$");
								_g_free0 (ss);
								ss = _tmp38_;
							}
						}
					}
					_tmp39_ = temp;
					_tmp40_ = ss;
					_tmp41_ = g_strconcat (_tmp39_, _tmp40_, NULL);
					_g_free0 (temp);
					temp = _tmp41_;
					_g_free0 (ss);
				}
			}
		}
		_tmp42_ = temp;
		_tmp44_ = _tmp43_ = g_strsplit_set (_tmp42_, ";", 0);
		arguments = _tmp44_;
		arguments_length1 = _vala_array_length (_tmp43_);
		_arguments_size_ = arguments_length1;
		_tmp45_ = arguments;
		_tmp45__length1 = arguments_length1;
		{
			gchar** argument_collection = NULL;
			gint argument_collection_length1 = 0;
			gint _argument_collection_size_ = 0;
			gint argument_it = 0;
			argument_collection = _tmp45_;
			argument_collection_length1 = _tmp45__length1;
			for (argument_it = 0; argument_it < argument_collection_length1; argument_it = argument_it + 1) {
				gchar* _tmp46_;
				gchar* argument = NULL;
				_tmp46_ = g_strdup (argument_collection[argument_it]);
				argument = _tmp46_;
				{
					const gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					ExpressionParser* argument_parser = NULL;
					const gchar* _tmp51_;
					Parser* _tmp52_;
					ExpressionParser* _tmp53_;
					guint representation_base = 0U;
					ErrorCode error_code = 0;
					gchar* error_token = NULL;
					guint error_start = 0U;
					guint error_end = 0U;
					Number* ans = NULL;
					ExpressionParser* _tmp54_;
					guint _tmp55_ = 0U;
					ErrorCode _tmp56_ = 0;
					gchar* _tmp57_ = NULL;
					guint _tmp58_ = 0U;
					guint _tmp59_ = 0U;
					Number* _tmp60_;
					gboolean _tmp61_ = FALSE;
					_tmp47_ = argument;
					_tmp48_ = string_replace (_tmp47_, "$", ";");
					_tmp49_ = _tmp48_;
					_tmp50_ = string_strip (_tmp49_);
					_g_free0 (argument);
					argument = _tmp50_;
					_g_free0 (_tmp49_);
					_tmp51_ = argument;
					_tmp52_ = ((ParseNode*) self)->parser;
					_tmp53_ = expression_parser_new (_tmp51_, _tmp52_);
					argument_parser = _tmp53_;
					_tmp54_ = argument_parser;
					_tmp60_ = parser_parse ((Parser*) _tmp54_, &_tmp55_, &_tmp56_, &_tmp57_, &_tmp58_, &_tmp59_);
					representation_base = _tmp55_;
					error_code = _tmp56_;
					_g_free0 (error_token);
					error_token = _tmp57_;
					error_start = _tmp58_;
					error_end = _tmp59_;
					ans = _tmp60_;
					if (error_code == ERROR_CODE_NONE) {
						Number* _tmp62_;
						_tmp62_ = ans;
						_tmp61_ = _tmp62_ != NULL;
					} else {
						_tmp61_ = FALSE;
					}
					if (_tmp61_) {
						Number* _tmp63_;
						Number* _tmp64_;
						_tmp63_ = ans;
						_tmp64_ = _g_object_ref0 (_tmp63_);
						_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp64_);
					} else {
						Parser* _tmp65_;
						const gchar* _tmp66_;
						ParseNode* _tmp67_;
						LexerToken* _tmp68_;
						LexerToken* _tmp69_;
						ParseNode* _tmp70_;
						LexerToken* _tmp71_;
						LexerToken* _tmp72_;
						_tmp65_ = ((ParseNode*) self)->parser;
						_tmp66_ = error_token;
						_tmp67_ = ((ParseNode*) self)->right;
						_tmp68_ = parse_node_first_token (_tmp67_);
						_tmp69_ = _tmp68_;
						_tmp70_ = ((ParseNode*) self)->right;
						_tmp71_ = parse_node_last_token (_tmp70_);
						_tmp72_ = _tmp71_;
						parser_set_error (_tmp65_, error_code, _tmp66_, _tmp69_->start_index, _tmp72_->end_index);
						_g_object_unref0 (_tmp72_);
						_g_object_unref0 (_tmp69_);
						result = NULL;
						_g_object_unref0 (ans);
						_g_free0 (error_token);
						_parser_unref0 (argument_parser);
						_g_free0 (argument);
						arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (temp);
						_g_free0 (argument_list);
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
						_g_object_unref0 (function_manager);
						_g_free0 (name);
						return result;
					}
					_g_object_unref0 (ans);
					_g_free0 (error_token);
					_parser_unref0 (argument_parser);
					_g_free0 (argument);
				}
			}
		}
		arguments = (_vala_array_free (arguments, arguments_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (temp);
		_g_free0 (argument_list);
	} else {
		Number* ans = NULL;
		ParseNode* _tmp73_;
		Number* _tmp74_;
		Number* _tmp75_;
		_tmp73_ = ((ParseNode*) self)->right;
		_tmp74_ = parse_node_solve (_tmp73_);
		ans = _tmp74_;
		_tmp75_ = ans;
		if (_tmp75_ != NULL) {
			Number* _tmp76_;
			Number* _tmp77_;
			_tmp76_ = ans;
			_tmp77_ = _g_object_ref0 (_tmp76_);
			_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp77_);
		} else {
			result = NULL;
			_g_object_unref0 (ans);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (function_manager);
			_g_free0 (name);
			return result;
		}
		_g_object_unref0 (ans);
	}
	_tmp78_ = args;
	_tmp78__length1 = args_length1;
	if (_tmp78__length1 == 0) {
		gchar* _error_ = NULL;
		const gchar* _tmp79_;
		gchar* _tmp80_;
		Parser* _tmp81_;
		const gchar* _tmp82_;
		ParseNode* _tmp83_;
		LexerToken* _tmp84_;
		LexerToken* _tmp85_;
		ParseNode* _tmp86_;
		LexerToken* _tmp87_;
		LexerToken* _tmp88_;
		_tmp79_ = name;
		_tmp80_ = g_strdup_printf (_ ("Function “%s” is missing arguments"), _tmp79_);
		_error_ = _tmp80_;
		_tmp81_ = ((ParseNode*) self)->parser;
		_tmp82_ = _error_;
		_tmp83_ = ((ParseNode*) self)->left;
		_tmp84_ = parse_node_token (_tmp83_);
		_tmp85_ = _tmp84_;
		_tmp86_ = ((ParseNode*) self)->left;
		_tmp87_ = parse_node_token (_tmp86_);
		_tmp88_ = _tmp87_;
		parser_set_error (_tmp81_, ERROR_CODE_MP, _tmp82_, _tmp85_->start_index, _tmp88_->end_index);
		_g_object_unref0 (_tmp88_);
		_g_object_unref0 (_tmp85_);
		result = NULL;
		_g_free0 (_error_);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (function_manager);
		_g_free0 (name);
		return result;
	}
	_tmp89_ = function_manager;
	_tmp90_ = name;
	_tmp91_ = args;
	_tmp91__length1 = args_length1;
	_tmp92_ = ((ParseNode*) self)->parser;
	_tmp93_ = function_manager_evaluate_function (_tmp89_, _tmp90_, _tmp91_, (gint) _tmp91__length1, _tmp92_);
	tmp = _tmp93_;
	_tmp94_ = tmp;
	if (_tmp94_ != NULL) {
		Number* _tmp95_;
		Number* _tmp96_;
		_tmp95_ = tmp;
		_tmp96_ = number_xpowy_integer (_tmp95_, (gint64) pow);
		_g_object_unref0 (tmp);
		tmp = _tmp96_;
	}
	number_check_flags ();
	_tmp97_ = number_get_error ();
	_tmp98_ = _tmp97_;
	if (_tmp98_ != NULL) {
		Parser* _tmp99_;
		const gchar* _tmp100_;
		const gchar* _tmp101_;
		ParseNode* _tmp102_;
		LexerToken* _tmp103_;
		LexerToken* _tmp104_;
		ParseNode* _tmp105_;
		LexerToken* _tmp106_;
		LexerToken* _tmp107_;
		_tmp99_ = ((ParseNode*) self)->parser;
		_tmp100_ = number_get_error ();
		_tmp101_ = _tmp100_;
		_tmp102_ = ((ParseNode*) self)->right;
		_tmp103_ = parse_node_first_token (_tmp102_);
		_tmp104_ = _tmp103_;
		_tmp105_ = ((ParseNode*) self)->right;
		_tmp106_ = parse_node_last_token (_tmp105_);
		_tmp107_ = _tmp106_;
		parser_set_error (_tmp99_, ERROR_CODE_MP, _tmp101_, _tmp104_->start_index, _tmp107_->end_index);
		_g_object_unref0 (_tmp107_);
		_g_object_unref0 (_tmp104_);
		number_set_error (NULL);
	}
	result = tmp;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (function_manager);
	_g_free0 (name);
	return result;
}

static void
function_node_class_init (FunctionNodeClass * klass,
                          gpointer klass_data)
{
	function_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) function_node_real_solve;
}

static void
function_node_instance_init (FunctionNode * self,
                             gpointer klass)
{
}

static GType
function_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FunctionNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) function_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FunctionNode), 0, (GInstanceInitFunc) function_node_instance_init, NULL };
	GType function_node_type_id;
	function_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "FunctionNode", &g_define_type_info, 0);
	return function_node_type_id;
}

GType
function_node_get_type (void)
{
	static volatile gsize function_node_type_id__once = 0;
	if (g_once_init_enter (&function_node_type_id__once)) {
		GType function_node_type_id;
		function_node_type_id = function_node_get_type_once ();
		g_once_init_leave (&function_node_type_id__once, function_node_type_id);
	}
	return function_node_type_id__once;
}

UnaryMinusNode*
unary_minus_node_construct (GType object_type,
                            Parser* parser,
                            LexerToken* token,
                            guint precedence,
                            Associativity associativity)
{
	UnaryMinusNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (UnaryMinusNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

UnaryMinusNode*
unary_minus_node_new (Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	return unary_minus_node_construct (TYPE_UNARY_MINUS_NODE, parser, token, precedence, associativity);
}

static Number*
unary_minus_node_real_solve_r (RNode* base,
                               Number* r)
{
	UnaryMinusNode * self;
	Number* _tmp0_;
	Number* result;
	self = (UnaryMinusNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_invert_sign (r);
	result = _tmp0_;
	return result;
}

static void
unary_minus_node_class_init (UnaryMinusNodeClass * klass,
                             gpointer klass_data)
{
	unary_minus_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) unary_minus_node_real_solve_r;
}

static void
unary_minus_node_instance_init (UnaryMinusNode * self,
                                gpointer klass)
{
}

static GType
unary_minus_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UnaryMinusNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unary_minus_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnaryMinusNode), 0, (GInstanceInitFunc) unary_minus_node_instance_init, NULL };
	GType unary_minus_node_type_id;
	unary_minus_node_type_id = g_type_register_static (TYPE_RNODE, "UnaryMinusNode", &g_define_type_info, 0);
	return unary_minus_node_type_id;
}

GType
unary_minus_node_get_type (void)
{
	static volatile gsize unary_minus_node_type_id__once = 0;
	if (g_once_init_enter (&unary_minus_node_type_id__once)) {
		GType unary_minus_node_type_id;
		unary_minus_node_type_id = unary_minus_node_get_type_once ();
		g_once_init_leave (&unary_minus_node_type_id__once, unary_minus_node_type_id);
	}
	return unary_minus_node_type_id__once;
}

AbsoluteValueNode*
absolute_value_node_construct (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity)
{
	AbsoluteValueNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AbsoluteValueNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

AbsoluteValueNode*
absolute_value_node_new (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	return absolute_value_node_construct (TYPE_ABSOLUTE_VALUE_NODE, parser, token, precedence, associativity);
}

static Number*
absolute_value_node_real_solve_r (RNode* base,
                                  Number* r)
{
	AbsoluteValueNode * self;
	Number* _tmp0_;
	Number* result;
	self = (AbsoluteValueNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_abs (r);
	result = _tmp0_;
	return result;
}

static void
absolute_value_node_class_init (AbsoluteValueNodeClass * klass,
                                gpointer klass_data)
{
	absolute_value_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) absolute_value_node_real_solve_r;
}

static void
absolute_value_node_instance_init (AbsoluteValueNode * self,
                                   gpointer klass)
{
}

static GType
absolute_value_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AbsoluteValueNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) absolute_value_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AbsoluteValueNode), 0, (GInstanceInitFunc) absolute_value_node_instance_init, NULL };
	GType absolute_value_node_type_id;
	absolute_value_node_type_id = g_type_register_static (TYPE_RNODE, "AbsoluteValueNode", &g_define_type_info, 0);
	return absolute_value_node_type_id;
}

GType
absolute_value_node_get_type (void)
{
	static volatile gsize absolute_value_node_type_id__once = 0;
	if (g_once_init_enter (&absolute_value_node_type_id__once)) {
		GType absolute_value_node_type_id;
		absolute_value_node_type_id = absolute_value_node_get_type_once ();
		g_once_init_leave (&absolute_value_node_type_id__once, absolute_value_node_type_id);
	}
	return absolute_value_node_type_id__once;
}

FloorNode*
floor_node_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	FloorNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (FloorNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

FloorNode*
floor_node_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity)
{
	return floor_node_construct (TYPE_FLOOR_NODE, parser, token, precedence, associativity);
}

static Number*
floor_node_real_solve_r (RNode* base,
                         Number* r)
{
	FloorNode * self;
	Number* _tmp0_;
	Number* result;
	self = (FloorNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_floor (r);
	result = _tmp0_;
	return result;
}

static void
floor_node_class_init (FloorNodeClass * klass,
                       gpointer klass_data)
{
	floor_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) floor_node_real_solve_r;
}

static void
floor_node_instance_init (FloorNode * self,
                          gpointer klass)
{
}

static GType
floor_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FloorNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) floor_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FloorNode), 0, (GInstanceInitFunc) floor_node_instance_init, NULL };
	GType floor_node_type_id;
	floor_node_type_id = g_type_register_static (TYPE_RNODE, "FloorNode", &g_define_type_info, 0);
	return floor_node_type_id;
}

GType
floor_node_get_type (void)
{
	static volatile gsize floor_node_type_id__once = 0;
	if (g_once_init_enter (&floor_node_type_id__once)) {
		GType floor_node_type_id;
		floor_node_type_id = floor_node_get_type_once ();
		g_once_init_leave (&floor_node_type_id__once, floor_node_type_id);
	}
	return floor_node_type_id__once;
}

CeilingNode*
ceiling_node_construct (GType object_type,
                        Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity)
{
	CeilingNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (CeilingNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

CeilingNode*
ceiling_node_new (Parser* parser,
                  LexerToken* token,
                  guint precedence,
                  Associativity associativity)
{
	return ceiling_node_construct (TYPE_CEILING_NODE, parser, token, precedence, associativity);
}

static Number*
ceiling_node_real_solve_r (RNode* base,
                           Number* r)
{
	CeilingNode * self;
	Number* _tmp0_;
	Number* result;
	self = (CeilingNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_ceiling (r);
	result = _tmp0_;
	return result;
}

static void
ceiling_node_class_init (CeilingNodeClass * klass,
                         gpointer klass_data)
{
	ceiling_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) ceiling_node_real_solve_r;
}

static void
ceiling_node_instance_init (CeilingNode * self,
                            gpointer klass)
{
}

static GType
ceiling_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CeilingNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ceiling_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CeilingNode), 0, (GInstanceInitFunc) ceiling_node_instance_init, NULL };
	GType ceiling_node_type_id;
	ceiling_node_type_id = g_type_register_static (TYPE_RNODE, "CeilingNode", &g_define_type_info, 0);
	return ceiling_node_type_id;
}

GType
ceiling_node_get_type (void)
{
	static volatile gsize ceiling_node_type_id__once = 0;
	if (g_once_init_enter (&ceiling_node_type_id__once)) {
		GType ceiling_node_type_id;
		ceiling_node_type_id = ceiling_node_get_type_once ();
		g_once_init_leave (&ceiling_node_type_id__once, ceiling_node_type_id);
	}
	return ceiling_node_type_id__once;
}

FractionalComponentNode*
fractional_component_node_construct (GType object_type,
                                     Parser* parser,
                                     LexerToken* token,
                                     guint precedence,
                                     Associativity associativity)
{
	FractionalComponentNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (FractionalComponentNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

FractionalComponentNode*
fractional_component_node_new (Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity)
{
	return fractional_component_node_construct (TYPE_FRACTIONAL_COMPONENT_NODE, parser, token, precedence, associativity);
}

static Number*
fractional_component_node_real_solve_r (RNode* base,
                                        Number* r)
{
	FractionalComponentNode * self;
	Number* _tmp0_;
	Number* result;
	self = (FractionalComponentNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_fractional_part (r);
	result = _tmp0_;
	return result;
}

static void
fractional_component_node_class_init (FractionalComponentNodeClass * klass,
                                      gpointer klass_data)
{
	fractional_component_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) fractional_component_node_real_solve_r;
}

static void
fractional_component_node_instance_init (FractionalComponentNode * self,
                                         gpointer klass)
{
}

static GType
fractional_component_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FractionalComponentNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fractional_component_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FractionalComponentNode), 0, (GInstanceInitFunc) fractional_component_node_instance_init, NULL };
	GType fractional_component_node_type_id;
	fractional_component_node_type_id = g_type_register_static (TYPE_RNODE, "FractionalComponentNode", &g_define_type_info, 0);
	return fractional_component_node_type_id;
}

GType
fractional_component_node_get_type (void)
{
	static volatile gsize fractional_component_node_type_id__once = 0;
	if (g_once_init_enter (&fractional_component_node_type_id__once)) {
		GType fractional_component_node_type_id;
		fractional_component_node_type_id = fractional_component_node_get_type_once ();
		g_once_init_leave (&fractional_component_node_type_id__once, fractional_component_node_type_id);
	}
	return fractional_component_node_type_id__once;
}

RoundNode*
round_node_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	RoundNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (RoundNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

RoundNode*
round_node_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity)
{
	return round_node_construct (TYPE_ROUND_NODE, parser, token, precedence, associativity);
}

static Number*
round_node_real_solve_r (RNode* base,
                         Number* r)
{
	RoundNode * self;
	Number* _tmp0_;
	Number* result;
	self = (RoundNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_round (r);
	result = _tmp0_;
	return result;
}

static void
round_node_class_init (RoundNodeClass * klass,
                       gpointer klass_data)
{
	round_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) round_node_real_solve_r;
}

static void
round_node_instance_init (RoundNode * self,
                          gpointer klass)
{
}

static GType
round_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RoundNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) round_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RoundNode), 0, (GInstanceInitFunc) round_node_instance_init, NULL };
	GType round_node_type_id;
	round_node_type_id = g_type_register_static (TYPE_RNODE, "RoundNode", &g_define_type_info, 0);
	return round_node_type_id;
}

GType
round_node_get_type (void)
{
	static volatile gsize round_node_type_id__once = 0;
	if (g_once_init_enter (&round_node_type_id__once)) {
		GType round_node_type_id;
		round_node_type_id = round_node_get_type_once ();
		g_once_init_leave (&round_node_type_id__once, round_node_type_id);
	}
	return round_node_type_id__once;
}

PercentNode*
percent_node_construct (GType object_type,
                        Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity)
{
	PercentNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (PercentNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

PercentNode*
percent_node_new (Parser* parser,
                  LexerToken* token,
                  guint precedence,
                  Associativity associativity)
{
	return percent_node_construct (TYPE_PERCENT_NODE, parser, token, precedence, associativity);
}

static Number*
percent_node_real_solve_r (RNode* base,
                           Number* r)
{
	PercentNode * self;
	Number* _tmp0_;
	Number* result;
	self = (PercentNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_divide_integer (r, (gint64) 100);
	result = _tmp0_;
	return result;
}

static void
percent_node_class_init (PercentNodeClass * klass,
                         gpointer klass_data)
{
	percent_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) percent_node_real_solve_r;
}

static void
percent_node_instance_init (PercentNode * self,
                            gpointer klass)
{
}

static GType
percent_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PercentNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) percent_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PercentNode), 0, (GInstanceInitFunc) percent_node_instance_init, NULL };
	GType percent_node_type_id;
	percent_node_type_id = g_type_register_static (TYPE_RNODE, "PercentNode", &g_define_type_info, 0);
	return percent_node_type_id;
}

GType
percent_node_get_type (void)
{
	static volatile gsize percent_node_type_id__once = 0;
	if (g_once_init_enter (&percent_node_type_id__once)) {
		GType percent_node_type_id;
		percent_node_type_id = percent_node_get_type_once ();
		g_once_init_leave (&percent_node_type_id__once, percent_node_type_id);
	}
	return percent_node_type_id__once;
}

FactorialNode*
factorial_node_construct (GType object_type,
                          Parser* parser,
                          LexerToken* token,
                          guint precedence,
                          Associativity associativity)
{
	FactorialNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (FactorialNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

FactorialNode*
factorial_node_new (Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	return factorial_node_construct (TYPE_FACTORIAL_NODE, parser, token, precedence, associativity);
}

static Number*
factorial_node_real_solve_r (RNode* base,
                             Number* r)
{
	FactorialNode * self;
	Number* _tmp0_;
	Number* result;
	self = (FactorialNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_factorial (r);
	result = _tmp0_;
	return result;
}

static void
factorial_node_class_init (FactorialNodeClass * klass,
                           gpointer klass_data)
{
	factorial_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) factorial_node_real_solve_r;
}

static void
factorial_node_instance_init (FactorialNode * self,
                              gpointer klass)
{
}

static GType
factorial_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FactorialNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) factorial_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FactorialNode), 0, (GInstanceInitFunc) factorial_node_instance_init, NULL };
	GType factorial_node_type_id;
	factorial_node_type_id = g_type_register_static (TYPE_RNODE, "FactorialNode", &g_define_type_info, 0);
	return factorial_node_type_id;
}

GType
factorial_node_get_type (void)
{
	static volatile gsize factorial_node_type_id__once = 0;
	if (g_once_init_enter (&factorial_node_type_id__once)) {
		GType factorial_node_type_id;
		factorial_node_type_id = factorial_node_get_type_once ();
		g_once_init_leave (&factorial_node_type_id__once, factorial_node_type_id);
	}
	return factorial_node_type_id__once;
}

AddNode*
add_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	AddNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AddNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	((LRNode*) self)->repeatable = TRUE;
	return self;
}

AddNode*
add_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return add_node_construct (TYPE_ADD_NODE, parser, token, precedence, associativity);
}

static Number*
add_node_real_solve_lr (LRNode* base,
                        Number* l,
                        Number* r)
{
	AddNode * self;
	Number* result;
	self = (AddNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	if (self->do_percentage) {
		Number* per = NULL;
		Number* _tmp0_;
		Number* _tmp1_;
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		Number* _tmp5_;
		Number* _tmp6_;
		Number* _tmp7_;
		_tmp0_ = number_new_integer ((gint64) 100, (gint64) 0);
		_tmp1_ = _tmp0_;
		_tmp2_ = number_add (r, _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		per = _tmp3_;
		_tmp4_ = per;
		_tmp5_ = number_divide_integer (_tmp4_, (gint64) 100);
		_g_object_unref0 (per);
		per = _tmp5_;
		_tmp6_ = per;
		_tmp7_ = number_multiply (l, _tmp6_);
		result = _tmp7_;
		_g_object_unref0 (per);
		return result;
	} else {
		Number* _tmp8_;
		_tmp8_ = number_add (l, r);
		result = _tmp8_;
		return result;
	}
}

static void
add_node_class_init (AddNodeClass * klass,
                     gpointer klass_data)
{
	add_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) add_node_real_solve_lr;
	G_OBJECT_CLASS (klass)->finalize = add_node_finalize;
}

static void
add_node_instance_init (AddNode * self,
                        gpointer klass)
{
	self->do_percentage = FALSE;
}

static void
add_node_finalize (GObject * obj)
{
	AddNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ADD_NODE, AddNode);
	G_OBJECT_CLASS (add_node_parent_class)->finalize (obj);
}

static GType
add_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AddNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) add_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AddNode), 0, (GInstanceInitFunc) add_node_instance_init, NULL };
	GType add_node_type_id;
	add_node_type_id = g_type_register_static (TYPE_LR_NODE, "AddNode", &g_define_type_info, 0);
	return add_node_type_id;
}

GType
add_node_get_type (void)
{
	static volatile gsize add_node_type_id__once = 0;
	if (g_once_init_enter (&add_node_type_id__once)) {
		GType add_node_type_id;
		add_node_type_id = add_node_get_type_once ();
		g_once_init_leave (&add_node_type_id__once, add_node_type_id);
	}
	return add_node_type_id__once;
}

SubtractNode*
subtract_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	SubtractNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (SubtractNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	((LRNode*) self)->repeatable = TRUE;
	return self;
}

SubtractNode*
subtract_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	return subtract_node_construct (TYPE_SUBTRACT_NODE, parser, token, precedence, associativity);
}

static Number*
subtract_node_real_solve_lr (LRNode* base,
                             Number* l,
                             Number* r)
{
	SubtractNode * self;
	Number* result;
	self = (SubtractNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	if (self->do_percentage) {
		Number* per = NULL;
		Number* _tmp0_;
		Number* _tmp1_;
		Number* _tmp2_;
		Number* _tmp3_;
		Number* _tmp4_;
		Number* _tmp5_;
		Number* _tmp6_;
		Number* _tmp7_;
		_tmp0_ = number_new_integer ((gint64) -100, (gint64) 0);
		_tmp1_ = _tmp0_;
		_tmp2_ = number_add (r, _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		per = _tmp3_;
		_tmp4_ = per;
		_tmp5_ = number_divide_integer (_tmp4_, (gint64) -100);
		_g_object_unref0 (per);
		per = _tmp5_;
		_tmp6_ = per;
		_tmp7_ = number_multiply (l, _tmp6_);
		result = _tmp7_;
		_g_object_unref0 (per);
		return result;
	} else {
		Number* _tmp8_;
		_tmp8_ = number_subtract (l, r);
		result = _tmp8_;
		return result;
	}
}

static void
subtract_node_class_init (SubtractNodeClass * klass,
                          gpointer klass_data)
{
	subtract_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) subtract_node_real_solve_lr;
	G_OBJECT_CLASS (klass)->finalize = subtract_node_finalize;
}

static void
subtract_node_instance_init (SubtractNode * self,
                             gpointer klass)
{
	self->do_percentage = FALSE;
}

static void
subtract_node_finalize (GObject * obj)
{
	SubtractNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUBTRACT_NODE, SubtractNode);
	G_OBJECT_CLASS (subtract_node_parent_class)->finalize (obj);
}

static GType
subtract_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SubtractNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) subtract_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SubtractNode), 0, (GInstanceInitFunc) subtract_node_instance_init, NULL };
	GType subtract_node_type_id;
	subtract_node_type_id = g_type_register_static (TYPE_LR_NODE, "SubtractNode", &g_define_type_info, 0);
	return subtract_node_type_id;
}

GType
subtract_node_get_type (void)
{
	static volatile gsize subtract_node_type_id__once = 0;
	if (g_once_init_enter (&subtract_node_type_id__once)) {
		GType subtract_node_type_id;
		subtract_node_type_id = subtract_node_get_type_once ();
		g_once_init_leave (&subtract_node_type_id__once, subtract_node_type_id);
	}
	return subtract_node_type_id__once;
}

MultiplyNode*
multiply_node_construct (GType object_type,
                         Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	MultiplyNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (MultiplyNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	((LRNode*) self)->repeatable = token != NULL;
	return self;
}

MultiplyNode*
multiply_node_new (Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	return multiply_node_construct (TYPE_MULTIPLY_NODE, parser, token, precedence, associativity);
}

static Number*
multiply_node_real_solve_lr (LRNode* base,
                             Number* l,
                             Number* r)
{
	MultiplyNode * self;
	Number* _tmp0_;
	Number* result;
	self = (MultiplyNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_multiply (l, r);
	result = _tmp0_;
	return result;
}

static void
multiply_node_class_init (MultiplyNodeClass * klass,
                          gpointer klass_data)
{
	multiply_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) multiply_node_real_solve_lr;
}

static void
multiply_node_instance_init (MultiplyNode * self,
                             gpointer klass)
{
}

static GType
multiply_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MultiplyNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) multiply_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MultiplyNode), 0, (GInstanceInitFunc) multiply_node_instance_init, NULL };
	GType multiply_node_type_id;
	multiply_node_type_id = g_type_register_static (TYPE_LR_NODE, "MultiplyNode", &g_define_type_info, 0);
	return multiply_node_type_id;
}

GType
multiply_node_get_type (void)
{
	static volatile gsize multiply_node_type_id__once = 0;
	if (g_once_init_enter (&multiply_node_type_id__once)) {
		GType multiply_node_type_id;
		multiply_node_type_id = multiply_node_get_type_once ();
		g_once_init_leave (&multiply_node_type_id__once, multiply_node_type_id);
	}
	return multiply_node_type_id__once;
}

ShiftNode*
shift_node_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	ShiftNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ShiftNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	((LRNode*) self)->repeatable = TRUE;
	return self;
}

ShiftNode*
shift_node_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity)
{
	return shift_node_construct (TYPE_SHIFT_NODE, parser, token, precedence, associativity);
}

static Number*
shift_node_real_solve_lr (LRNode* base,
                          Number* l,
                          Number* r)
{
	ShiftNode * self;
	LexerToken* _tmp0_;
	LexerToken* _tmp1_;
	gboolean _tmp2_;
	Number* result;
	self = (ShiftNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = parse_node_first_token ((ParseNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->type == LEXER_TOKEN_TYPE_SHIFT_LEFT;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		Parser* _tmp3_;
		Number* _tmp4_;
		_tmp3_ = ((ParseNode*) self)->parser;
		_tmp4_ = number_left_shift (l, r, _tmp3_->wordlen);
		result = _tmp4_;
		return result;
	} else {
		LexerToken* _tmp5_;
		LexerToken* _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = parse_node_first_token ((ParseNode*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->type == LEXER_TOKEN_TYPE_SHIFT_RIGHT;
		_g_object_unref0 (_tmp6_);
		if (_tmp7_) {
			Parser* _tmp8_;
			Number* _tmp9_;
			_tmp8_ = ((ParseNode*) self)->parser;
			_tmp9_ = number_right_shift (l, r, _tmp8_->wordlen);
			result = _tmp9_;
			return result;
		} else {
			Parser* _tmp10_;
			Number* _tmp11_;
			_tmp10_ = ((ParseNode*) self)->parser;
			_tmp11_ = number_unsigned_right_shift (l, r, _tmp10_->wordlen);
			result = _tmp11_;
			return result;
		}
	}
}

static void
shift_node_class_init (ShiftNodeClass * klass,
                       gpointer klass_data)
{
	shift_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) shift_node_real_solve_lr;
}

static void
shift_node_instance_init (ShiftNode * self,
                          gpointer klass)
{
}

static GType
shift_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ShiftNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shift_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShiftNode), 0, (GInstanceInitFunc) shift_node_instance_init, NULL };
	GType shift_node_type_id;
	shift_node_type_id = g_type_register_static (TYPE_LR_NODE, "ShiftNode", &g_define_type_info, 0);
	return shift_node_type_id;
}

GType
shift_node_get_type (void)
{
	static volatile gsize shift_node_type_id__once = 0;
	if (g_once_init_enter (&shift_node_type_id__once)) {
		GType shift_node_type_id;
		shift_node_type_id = shift_node_get_type_once ();
		g_once_init_leave (&shift_node_type_id__once, shift_node_type_id);
	}
	return shift_node_type_id__once;
}

DivideNode*
divide_node_construct (GType object_type,
                       Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity)
{
	DivideNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (DivideNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	((LRNode*) self)->repeatable = TRUE;
	return self;
}

DivideNode*
divide_node_new (Parser* parser,
                 LexerToken* token,
                 guint precedence,
                 Associativity associativity)
{
	return divide_node_construct (TYPE_DIVIDE_NODE, parser, token, precedence, associativity);
}

static Number*
divide_node_real_solve_lr (LRNode* base,
                           Number* l,
                           Number* r)
{
	DivideNode * self;
	Number* z = NULL;
	Number* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	Number* result;
	self = (DivideNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_divide (l, r);
	z = _tmp0_;
	_tmp1_ = number_get_error ();
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		guint token_start = 0U;
		guint token_end = 0U;
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp3_;
		ParseNode* _tmp4_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp5_;
		ParseNode* _tmp6_;
		ParseNode* _tmp17_;
		LexerToken* _tmp18_;
		LexerToken* _tmp19_;
		gboolean _tmp20_;
		ParseNode* _tmp24_;
		LexerToken* _tmp25_;
		LexerToken* _tmp26_;
		gboolean _tmp27_;
		Parser* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		token_start = (guint) 0;
		token_end = (guint) 0;
		_tmp3_ = ((ParseNode*) self)->right;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		tmpleft = _tmp4_;
		_tmp5_ = ((ParseNode*) self)->right;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		tmpright = _tmp6_;
		while (TRUE) {
			ParseNode* _tmp7_;
			ParseNode* _tmp8_;
			ParseNode* _tmp9_;
			ParseNode* _tmp10_;
			ParseNode* _tmp11_;
			_tmp7_ = tmpleft;
			_tmp8_ = _tmp7_->left;
			if (!(_tmp8_ != NULL)) {
				break;
			}
			_tmp9_ = tmpleft;
			_tmp10_ = _tmp9_->left;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp11_;
		}
		while (TRUE) {
			ParseNode* _tmp12_;
			ParseNode* _tmp13_;
			ParseNode* _tmp14_;
			ParseNode* _tmp15_;
			ParseNode* _tmp16_;
			_tmp12_ = tmpright;
			_tmp13_ = _tmp12_->right;
			if (!(_tmp13_ != NULL)) {
				break;
			}
			_tmp14_ = tmpright;
			_tmp15_ = _tmp14_->right;
			_tmp16_ = _g_object_ref0 (_tmp15_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp16_;
		}
		_tmp17_ = tmpleft;
		_tmp18_ = parse_node_first_token (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_ != NULL;
		_g_object_unref0 (_tmp19_);
		if (_tmp20_) {
			ParseNode* _tmp21_;
			LexerToken* _tmp22_;
			LexerToken* _tmp23_;
			_tmp21_ = tmpleft;
			_tmp22_ = parse_node_first_token (_tmp21_);
			_tmp23_ = _tmp22_;
			token_start = _tmp23_->start_index;
			_g_object_unref0 (_tmp23_);
		}
		_tmp24_ = tmpright;
		_tmp25_ = parse_node_last_token (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_ != NULL;
		_g_object_unref0 (_tmp26_);
		if (_tmp27_) {
			ParseNode* _tmp28_;
			LexerToken* _tmp29_;
			LexerToken* _tmp30_;
			_tmp28_ = tmpright;
			_tmp29_ = parse_node_last_token (_tmp28_);
			_tmp30_ = _tmp29_;
			token_end = _tmp30_->end_index;
			_g_object_unref0 (_tmp30_);
		}
		_tmp31_ = ((ParseNode*) self)->parser;
		_tmp32_ = number_get_error ();
		_tmp33_ = _tmp32_;
		parser_set_error (_tmp31_, ERROR_CODE_MP, _tmp33_, token_start, token_end);
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = z;
	return result;
}

static void
divide_node_class_init (DivideNodeClass * klass,
                        gpointer klass_data)
{
	divide_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) divide_node_real_solve_lr;
}

static void
divide_node_instance_init (DivideNode * self,
                           gpointer klass)
{
}

static GType
divide_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DivideNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) divide_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DivideNode), 0, (GInstanceInitFunc) divide_node_instance_init, NULL };
	GType divide_node_type_id;
	divide_node_type_id = g_type_register_static (TYPE_LR_NODE, "DivideNode", &g_define_type_info, 0);
	return divide_node_type_id;
}

GType
divide_node_get_type (void)
{
	static volatile gsize divide_node_type_id__once = 0;
	if (g_once_init_enter (&divide_node_type_id__once)) {
		GType divide_node_type_id;
		divide_node_type_id = divide_node_get_type_once ();
		g_once_init_leave (&divide_node_type_id__once, divide_node_type_id);
	}
	return divide_node_type_id__once;
}

ModulusDivideNode*
modulus_divide_node_construct (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity)
{
	ModulusDivideNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ModulusDivideNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

ModulusDivideNode*
modulus_divide_node_new (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	return modulus_divide_node_construct (TYPE_MODULUS_DIVIDE_NODE, parser, token, precedence, associativity);
}

static Number*
modulus_divide_node_real_solve (ParseNode* base)
{
	ModulusDivideNode * self;
	ParseNode* _tmp0_;
	Number* result;
	self = (ModulusDivideNode*) base;
	_tmp0_ = ((ParseNode*) self)->left;
	if (IS_XPOW_YNODE (_tmp0_)) {
		Number* base_value = NULL;
		ParseNode* _tmp1_;
		ParseNode* _tmp2_;
		Number* _tmp3_;
		Number* exponent = NULL;
		ParseNode* _tmp4_;
		ParseNode* _tmp5_;
		Number* _tmp6_;
		Number* mod = NULL;
		ParseNode* _tmp7_;
		Number* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		Number* _tmp11_;
		Number* z = NULL;
		Number* _tmp14_;
		Number* _tmp15_;
		Number* _tmp16_;
		Number* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp1_ = ((ParseNode*) self)->left;
		_tmp2_ = _tmp1_->left;
		_tmp3_ = parse_node_solve (_tmp2_);
		base_value = _tmp3_;
		_tmp4_ = ((ParseNode*) self)->left;
		_tmp5_ = _tmp4_->right;
		_tmp6_ = parse_node_solve (_tmp5_);
		exponent = _tmp6_;
		_tmp7_ = ((ParseNode*) self)->right;
		_tmp8_ = parse_node_solve (_tmp7_);
		mod = _tmp8_;
		_tmp11_ = base_value;
		if (_tmp11_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			Number* _tmp12_;
			_tmp12_ = exponent;
			_tmp10_ = _tmp12_ == NULL;
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			Number* _tmp13_;
			_tmp13_ = mod;
			_tmp9_ = _tmp13_ == NULL;
		}
		if (_tmp9_) {
			result = NULL;
			_g_object_unref0 (mod);
			_g_object_unref0 (exponent);
			_g_object_unref0 (base_value);
			return result;
		}
		_tmp14_ = base_value;
		_tmp15_ = exponent;
		_tmp16_ = mod;
		_tmp17_ = number_modular_exponentiation (_tmp14_, _tmp15_, _tmp16_);
		z = _tmp17_;
		number_check_flags ();
		_tmp18_ = number_get_error ();
		_tmp19_ = _tmp18_;
		if (_tmp19_ != NULL) {
			ParseNode* tmpleft = NULL;
			ParseNode* _tmp20_;
			ParseNode* _tmp21_;
			ParseNode* tmpright = NULL;
			ParseNode* _tmp22_;
			ParseNode* _tmp23_;
			Parser* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			ParseNode* _tmp37_;
			LexerToken* _tmp38_;
			LexerToken* _tmp39_;
			ParseNode* _tmp40_;
			LexerToken* _tmp41_;
			LexerToken* _tmp42_;
			_tmp20_ = ((ParseNode*) self)->left;
			_tmp21_ = _g_object_ref0 (_tmp20_);
			tmpleft = _tmp21_;
			_tmp22_ = ((ParseNode*) self)->right;
			_tmp23_ = _g_object_ref0 (_tmp22_);
			tmpright = _tmp23_;
			while (TRUE) {
				ParseNode* _tmp24_;
				ParseNode* _tmp25_;
				ParseNode* _tmp26_;
				ParseNode* _tmp27_;
				ParseNode* _tmp28_;
				_tmp24_ = tmpleft;
				_tmp25_ = _tmp24_->left;
				if (!(_tmp25_ != NULL)) {
					break;
				}
				_tmp26_ = tmpleft;
				_tmp27_ = _tmp26_->left;
				_tmp28_ = _g_object_ref0 (_tmp27_);
				_g_object_unref0 (tmpleft);
				tmpleft = _tmp28_;
			}
			while (TRUE) {
				ParseNode* _tmp29_;
				ParseNode* _tmp30_;
				ParseNode* _tmp31_;
				ParseNode* _tmp32_;
				ParseNode* _tmp33_;
				_tmp29_ = tmpright;
				_tmp30_ = _tmp29_->right;
				if (!(_tmp30_ != NULL)) {
					break;
				}
				_tmp31_ = tmpright;
				_tmp32_ = _tmp31_->right;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				_g_object_unref0 (tmpright);
				tmpright = _tmp33_;
			}
			_tmp34_ = ((ParseNode*) self)->parser;
			_tmp35_ = number_get_error ();
			_tmp36_ = _tmp35_;
			_tmp37_ = tmpleft;
			_tmp38_ = parse_node_first_token (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = tmpright;
			_tmp41_ = parse_node_last_token (_tmp40_);
			_tmp42_ = _tmp41_;
			parser_set_error (_tmp34_, ERROR_CODE_MP, _tmp36_, _tmp39_->start_index, _tmp42_->end_index);
			_g_object_unref0 (_tmp42_);
			_g_object_unref0 (_tmp39_);
			number_set_error (NULL);
			_g_object_unref0 (tmpright);
			_g_object_unref0 (tmpleft);
		}
		result = z;
		_g_object_unref0 (mod);
		_g_object_unref0 (exponent);
		_g_object_unref0 (base_value);
		return result;
	} else {
		Number* l = NULL;
		ParseNode* _tmp43_;
		Number* _tmp44_;
		Number* r = NULL;
		ParseNode* _tmp45_;
		Number* _tmp46_;
		gboolean _tmp47_ = FALSE;
		Number* _tmp48_;
		Number* z = NULL;
		Number* _tmp50_;
		Number* _tmp51_;
		Number* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp43_ = ((ParseNode*) self)->left;
		_tmp44_ = parse_node_solve (_tmp43_);
		l = _tmp44_;
		_tmp45_ = ((ParseNode*) self)->right;
		_tmp46_ = parse_node_solve (_tmp45_);
		r = _tmp46_;
		_tmp48_ = l;
		if (_tmp48_ == NULL) {
			_tmp47_ = TRUE;
		} else {
			Number* _tmp49_;
			_tmp49_ = r;
			_tmp47_ = _tmp49_ == NULL;
		}
		if (_tmp47_) {
			result = NULL;
			_g_object_unref0 (r);
			_g_object_unref0 (l);
			return result;
		}
		_tmp50_ = l;
		_tmp51_ = r;
		_tmp52_ = lr_node_solve_lr ((LRNode*) self, _tmp50_, _tmp51_);
		z = _tmp52_;
		number_check_flags ();
		_tmp53_ = number_get_error ();
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ParseNode* tmpleft = NULL;
			ParseNode* _tmp55_;
			ParseNode* _tmp56_;
			ParseNode* tmpright = NULL;
			ParseNode* _tmp57_;
			ParseNode* _tmp58_;
			Parser* _tmp69_;
			const gchar* _tmp70_;
			const gchar* _tmp71_;
			ParseNode* _tmp72_;
			LexerToken* _tmp73_;
			LexerToken* _tmp74_;
			ParseNode* _tmp75_;
			LexerToken* _tmp76_;
			LexerToken* _tmp77_;
			_tmp55_ = ((ParseNode*) self)->left;
			_tmp56_ = _g_object_ref0 (_tmp55_);
			tmpleft = _tmp56_;
			_tmp57_ = ((ParseNode*) self)->right;
			_tmp58_ = _g_object_ref0 (_tmp57_);
			tmpright = _tmp58_;
			while (TRUE) {
				ParseNode* _tmp59_;
				ParseNode* _tmp60_;
				ParseNode* _tmp61_;
				ParseNode* _tmp62_;
				ParseNode* _tmp63_;
				_tmp59_ = tmpleft;
				_tmp60_ = _tmp59_->left;
				if (!(_tmp60_ != NULL)) {
					break;
				}
				_tmp61_ = tmpleft;
				_tmp62_ = _tmp61_->left;
				_tmp63_ = _g_object_ref0 (_tmp62_);
				_g_object_unref0 (tmpleft);
				tmpleft = _tmp63_;
			}
			while (TRUE) {
				ParseNode* _tmp64_;
				ParseNode* _tmp65_;
				ParseNode* _tmp66_;
				ParseNode* _tmp67_;
				ParseNode* _tmp68_;
				_tmp64_ = tmpright;
				_tmp65_ = _tmp64_->right;
				if (!(_tmp65_ != NULL)) {
					break;
				}
				_tmp66_ = tmpright;
				_tmp67_ = _tmp66_->right;
				_tmp68_ = _g_object_ref0 (_tmp67_);
				_g_object_unref0 (tmpright);
				tmpright = _tmp68_;
			}
			_tmp69_ = ((ParseNode*) self)->parser;
			_tmp70_ = number_get_error ();
			_tmp71_ = _tmp70_;
			_tmp72_ = tmpleft;
			_tmp73_ = parse_node_first_token (_tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = tmpright;
			_tmp76_ = parse_node_last_token (_tmp75_);
			_tmp77_ = _tmp76_;
			parser_set_error (_tmp69_, ERROR_CODE_MP, _tmp71_, _tmp74_->start_index, _tmp77_->end_index);
			_g_object_unref0 (_tmp77_);
			_g_object_unref0 (_tmp74_);
			number_set_error (NULL);
			_g_object_unref0 (tmpright);
			_g_object_unref0 (tmpleft);
		}
		result = z;
		_g_object_unref0 (r);
		_g_object_unref0 (l);
		return result;
	}
}

static Number*
modulus_divide_node_real_solve_lr (LRNode* base,
                                   Number* l,
                                   Number* r)
{
	ModulusDivideNode * self;
	Number* _tmp0_;
	Number* result;
	self = (ModulusDivideNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_modulus_divide (l, r);
	result = _tmp0_;
	return result;
}

static void
modulus_divide_node_class_init (ModulusDivideNodeClass * klass,
                                gpointer klass_data)
{
	modulus_divide_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) modulus_divide_node_real_solve;
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) modulus_divide_node_real_solve_lr;
}

static void
modulus_divide_node_instance_init (ModulusDivideNode * self,
                                   gpointer klass)
{
}

static GType
modulus_divide_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ModulusDivideNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) modulus_divide_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ModulusDivideNode), 0, (GInstanceInitFunc) modulus_divide_node_instance_init, NULL };
	GType modulus_divide_node_type_id;
	modulus_divide_node_type_id = g_type_register_static (TYPE_LR_NODE, "ModulusDivideNode", &g_define_type_info, 0);
	return modulus_divide_node_type_id;
}

GType
modulus_divide_node_get_type (void)
{
	static volatile gsize modulus_divide_node_type_id__once = 0;
	if (g_once_init_enter (&modulus_divide_node_type_id__once)) {
		GType modulus_divide_node_type_id;
		modulus_divide_node_type_id = modulus_divide_node_get_type_once ();
		g_once_init_leave (&modulus_divide_node_type_id__once, modulus_divide_node_type_id);
	}
	return modulus_divide_node_type_id__once;
}

static inline gpointer
root_node_get_instance_private (RootNode* self)
{
	return G_STRUCT_MEMBER_P (self, RootNode_private_offset);
}

RootNode*
root_node_construct (GType object_type,
                     Parser* parser,
                     LexerToken* token,
                     guint precedence,
                     Associativity associativity,
                     gint n)
{
	RootNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (RootNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	self->priv->n = n;
	_g_object_unref0 (self->priv->token_n);
	self->priv->token_n = NULL;
	return self;
}

RootNode*
root_node_new (Parser* parser,
               LexerToken* token,
               guint precedence,
               Associativity associativity,
               gint n)
{
	return root_node_construct (TYPE_ROOT_NODE, parser, token, precedence, associativity, n);
}

RootNode*
root_node_construct_WithToken (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity,
                               LexerToken* token_n)
{
	RootNode * self = NULL;
	LexerToken* _tmp0_;
	g_return_val_if_fail (parser != NULL, NULL);
	g_return_val_if_fail (token_n != NULL, NULL);
	self = (RootNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	self->priv->n = 0;
	_tmp0_ = _g_object_ref0 (token_n);
	_g_object_unref0 (self->priv->token_n);
	self->priv->token_n = _tmp0_;
	return self;
}

RootNode*
root_node_new_WithToken (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity,
                         LexerToken* token_n)
{
	return root_node_construct_WithToken (TYPE_ROOT_NODE, parser, token, precedence, associativity, token_n);
}

static Number*
root_node_real_solve_r (RNode* base,
                        Number* r)
{
	RootNode * self;
	gboolean _tmp0_ = FALSE;
	Number* _tmp13_;
	Number* result;
	self = (RootNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	if (self->priv->n == 0) {
		LexerToken* _tmp1_;
		_tmp1_ = self->priv->token_n;
		_tmp0_ = _tmp1_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp2_ = 0;
		LexerToken* _tmp3_;
		_tmp3_ = self->priv->token_n;
		if (_tmp3_->type == LEXER_TOKEN_TYPE_SUP_NUMBER) {
			LexerToken* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->priv->token_n;
			_tmp5_ = _tmp4_->text;
			_tmp2_ = super_atoi (_tmp5_);
		} else {
			LexerToken* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->priv->token_n;
			_tmp7_ = _tmp6_->text;
			_tmp2_ = sub_atoi (_tmp7_);
		}
		self->priv->n = _tmp2_;
	}
	if (self->priv->n == 0) {
		gchar* _error_ = NULL;
		gchar* _tmp8_;
		Parser* _tmp9_;
		const gchar* _tmp10_;
		LexerToken* _tmp11_;
		LexerToken* _tmp12_;
		_tmp8_ = g_strdup (_ ("The zeroth root of a number is undefined"));
		_error_ = _tmp8_;
		_tmp9_ = ((ParseNode*) self)->parser;
		_tmp10_ = _error_;
		_tmp11_ = self->priv->token_n;
		_tmp12_ = self->priv->token_n;
		parser_set_error (_tmp9_, ERROR_CODE_MP, _tmp10_, _tmp11_->start_index, _tmp12_->end_index);
		result = NULL;
		_g_free0 (_error_);
		return result;
	}
	_tmp13_ = number_root (r, (gint64) self->priv->n);
	result = _tmp13_;
	return result;
}

static void
root_node_class_init (RootNodeClass * klass,
                      gpointer klass_data)
{
	root_node_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RootNode_private_offset);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) root_node_real_solve_r;
	G_OBJECT_CLASS (klass)->finalize = root_node_finalize;
}

static void
root_node_instance_init (RootNode * self,
                         gpointer klass)
{
	self->priv = root_node_get_instance_private (self);
}

static void
root_node_finalize (GObject * obj)
{
	RootNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ROOT_NODE, RootNode);
	_g_object_unref0 (self->priv->token_n);
	G_OBJECT_CLASS (root_node_parent_class)->finalize (obj);
}

static GType
root_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RootNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) root_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RootNode), 0, (GInstanceInitFunc) root_node_instance_init, NULL };
	GType root_node_type_id;
	root_node_type_id = g_type_register_static (TYPE_RNODE, "RootNode", &g_define_type_info, 0);
	RootNode_private_offset = g_type_add_instance_private (root_node_type_id, sizeof (RootNodePrivate));
	return root_node_type_id;
}

GType
root_node_get_type (void)
{
	static volatile gsize root_node_type_id__once = 0;
	if (g_once_init_enter (&root_node_type_id__once)) {
		GType root_node_type_id;
		root_node_type_id = root_node_get_type_once ();
		g_once_init_leave (&root_node_type_id__once, root_node_type_id);
	}
	return root_node_type_id__once;
}

XPowYNode*
xpow_ynode_construct (GType object_type,
                      Parser* parser,
                      LexerToken* token,
                      guint precedence,
                      Associativity associativity)
{
	XPowYNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (XPowYNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

XPowYNode*
xpow_ynode_new (Parser* parser,
                LexerToken* token,
                guint precedence,
                Associativity associativity)
{
	return xpow_ynode_construct (TYPE_XPOW_YNODE, parser, token, precedence, associativity);
}

static Number*
xpow_ynode_real_solve_lr (LRNode* base,
                          Number* l,
                          Number* r)
{
	XPowYNode * self;
	Number* _tmp0_;
	Number* result;
	self = (XPowYNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_xpowy (l, r);
	result = _tmp0_;
	return result;
}

static void
xpow_ynode_class_init (XPowYNodeClass * klass,
                       gpointer klass_data)
{
	xpow_ynode_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) xpow_ynode_real_solve_lr;
}

static void
xpow_ynode_instance_init (XPowYNode * self,
                          gpointer klass)
{
}

static GType
xpow_ynode_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XPowYNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xpow_ynode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XPowYNode), 0, (GInstanceInitFunc) xpow_ynode_instance_init, NULL };
	GType xpow_ynode_type_id;
	xpow_ynode_type_id = g_type_register_static (TYPE_LR_NODE, "XPowYNode", &g_define_type_info, 0);
	return xpow_ynode_type_id;
}

GType
xpow_ynode_get_type (void)
{
	static volatile gsize xpow_ynode_type_id__once = 0;
	if (g_once_init_enter (&xpow_ynode_type_id__once)) {
		GType xpow_ynode_type_id;
		xpow_ynode_type_id = xpow_ynode_get_type_once ();
		g_once_init_leave (&xpow_ynode_type_id__once, xpow_ynode_type_id);
	}
	return xpow_ynode_type_id__once;
}

XPowYIntegerNode*
xpow_yinteger_node_construct (GType object_type,
                              Parser* parser,
                              LexerToken* token,
                              guint precedence,
                              Associativity associativity)
{
	XPowYIntegerNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (XPowYIntegerNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}

XPowYIntegerNode*
xpow_yinteger_node_new (Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity)
{
	return xpow_yinteger_node_construct (TYPE_XPOW_YINTEGER_NODE, parser, token, precedence, associativity);
}

static Number*
xpow_yinteger_node_real_solve (ParseNode* base)
{
	XPowYIntegerNode * self;
	Number* val = NULL;
	ParseNode* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	gint64 pow = 0LL;
	ParseNode* _tmp8_;
	LexerToken* _tmp9_;
	LexerToken* _tmp10_;
	gboolean _tmp11_;
	Number* _tmp19_;
	Number* z = NULL;
	Number* _tmp20_;
	Number* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	Number* result;
	self = (XPowYIntegerNode*) base;
	_tmp0_ = ((ParseNode*) self)->left;
	_tmp1_ = parse_node_solve (_tmp0_);
	val = _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ == NULL) {
		ParseNode* _tmp3_;
		LexerToken* _tmp4_;
		LexerToken* _tmp5_;
		const gchar* _tmp6_;
		Number* _tmp7_;
		_tmp3_ = ((ParseNode*) self)->left;
		_tmp4_ = parse_node_token (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->text;
		_tmp7_ = number_new_integer ((gint64) super_atoi (_tmp6_), (gint64) 0);
		_g_object_unref0 (val);
		val = _tmp7_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp8_ = ((ParseNode*) self)->right;
	_tmp9_ = parse_node_token (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_ != NULL;
	_g_object_unref0 (_tmp10_);
	if (_tmp11_) {
		ParseNode* _tmp12_;
		LexerToken* _tmp13_;
		LexerToken* _tmp14_;
		const gchar* _tmp15_;
		_tmp12_ = ((ParseNode*) self)->right;
		_tmp13_ = parse_node_token (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->text;
		pow = (gint64) super_atoi (_tmp15_);
		_g_object_unref0 (_tmp14_);
	} else {
		ParseNode* _tmp16_;
		Number* _tmp17_;
		Number* _tmp18_;
		_tmp16_ = ((ParseNode*) self)->right;
		_tmp17_ = parse_node_solve (_tmp16_);
		_tmp18_ = _tmp17_;
		pow = number_to_integer (_tmp18_);
		_g_object_unref0 (_tmp18_);
	}
	_tmp19_ = val;
	if (_tmp19_ == NULL) {
		result = NULL;
		_g_object_unref0 (val);
		return result;
	}
	_tmp20_ = val;
	_tmp21_ = number_xpowy_integer (_tmp20_, pow);
	z = _tmp21_;
	number_check_flags ();
	_tmp22_ = number_get_error ();
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		ParseNode* tmpleft = NULL;
		ParseNode* _tmp24_;
		ParseNode* _tmp25_;
		ParseNode* tmpright = NULL;
		ParseNode* _tmp26_;
		ParseNode* _tmp27_;
		Parser* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		ParseNode* _tmp41_;
		LexerToken* _tmp42_;
		LexerToken* _tmp43_;
		ParseNode* _tmp44_;
		LexerToken* _tmp45_;
		LexerToken* _tmp46_;
		_tmp24_ = ((ParseNode*) self)->left;
		_tmp25_ = _g_object_ref0 (_tmp24_);
		tmpleft = _tmp25_;
		_tmp26_ = ((ParseNode*) self)->right;
		_tmp27_ = _g_object_ref0 (_tmp26_);
		tmpright = _tmp27_;
		while (TRUE) {
			ParseNode* _tmp28_;
			ParseNode* _tmp29_;
			ParseNode* _tmp30_;
			ParseNode* _tmp31_;
			ParseNode* _tmp32_;
			_tmp28_ = tmpleft;
			_tmp29_ = _tmp28_->left;
			if (!(_tmp29_ != NULL)) {
				break;
			}
			_tmp30_ = tmpleft;
			_tmp31_ = _tmp30_->left;
			_tmp32_ = _g_object_ref0 (_tmp31_);
			_g_object_unref0 (tmpleft);
			tmpleft = _tmp32_;
		}
		while (TRUE) {
			ParseNode* _tmp33_;
			ParseNode* _tmp34_;
			ParseNode* _tmp35_;
			ParseNode* _tmp36_;
			ParseNode* _tmp37_;
			_tmp33_ = tmpright;
			_tmp34_ = _tmp33_->right;
			if (!(_tmp34_ != NULL)) {
				break;
			}
			_tmp35_ = tmpright;
			_tmp36_ = _tmp35_->right;
			_tmp37_ = _g_object_ref0 (_tmp36_);
			_g_object_unref0 (tmpright);
			tmpright = _tmp37_;
		}
		_tmp38_ = ((ParseNode*) self)->parser;
		_tmp39_ = number_get_error ();
		_tmp40_ = _tmp39_;
		_tmp41_ = tmpleft;
		_tmp42_ = parse_node_first_token (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = tmpright;
		_tmp45_ = parse_node_last_token (_tmp44_);
		_tmp46_ = _tmp45_;
		parser_set_error (_tmp38_, ERROR_CODE_MP, _tmp40_, _tmp43_->start_index, _tmp46_->end_index);
		_g_object_unref0 (_tmp46_);
		_g_object_unref0 (_tmp43_);
		number_set_error (NULL);
		_g_object_unref0 (tmpright);
		_g_object_unref0 (tmpleft);
	}
	result = z;
	_g_object_unref0 (val);
	return result;
}

static void
xpow_yinteger_node_class_init (XPowYIntegerNodeClass * klass,
                               gpointer klass_data)
{
	xpow_yinteger_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) xpow_yinteger_node_real_solve;
}

static void
xpow_yinteger_node_instance_init (XPowYIntegerNode * self,
                                  gpointer klass)
{
}

/**
 * This class is a XPowY in which the right token is an nsup number.
 */
static GType
xpow_yinteger_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XPowYIntegerNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xpow_yinteger_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XPowYIntegerNode), 0, (GInstanceInitFunc) xpow_yinteger_node_instance_init, NULL };
	GType xpow_yinteger_node_type_id;
	xpow_yinteger_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "XPowYIntegerNode", &g_define_type_info, 0);
	return xpow_yinteger_node_type_id;
}

GType
xpow_yinteger_node_get_type (void)
{
	static volatile gsize xpow_yinteger_node_type_id__once = 0;
	if (g_once_init_enter (&xpow_yinteger_node_type_id__once)) {
		GType xpow_yinteger_node_type_id;
		xpow_yinteger_node_type_id = xpow_yinteger_node_get_type_once ();
		g_once_init_leave (&xpow_yinteger_node_type_id__once, xpow_yinteger_node_type_id);
	}
	return xpow_yinteger_node_type_id__once;
}

NotNode*
not_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	NotNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (NotNode*) rnode_construct (object_type, parser, token, precedence, associativity);
	return self;
}

NotNode*
not_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return not_node_construct (TYPE_NOT_NODE, parser, token, precedence, associativity);
}

static Number*
not_node_real_solve_r (RNode* base,
                       Number* r)
{
	NotNode * self;
	Parser* _tmp0_;
	Number* _tmp1_;
	Number* result;
	self = (NotNode*) base;
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = number_not (r, _tmp0_->wordlen);
	result = _tmp1_;
	return result;
}

static void
not_node_class_init (NotNodeClass * klass,
                     gpointer klass_data)
{
	not_node_parent_class = g_type_class_peek_parent (klass);
	((RNodeClass *) klass)->solve_r = (Number* (*) (RNode*, Number*)) not_node_real_solve_r;
}

static void
not_node_instance_init (NotNode * self,
                        gpointer klass)
{
}

static GType
not_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NotNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) not_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotNode), 0, (GInstanceInitFunc) not_node_instance_init, NULL };
	GType not_node_type_id;
	not_node_type_id = g_type_register_static (TYPE_RNODE, "NotNode", &g_define_type_info, 0);
	return not_node_type_id;
}

GType
not_node_get_type (void)
{
	static volatile gsize not_node_type_id__once = 0;
	if (g_once_init_enter (&not_node_type_id__once)) {
		GType not_node_type_id;
		not_node_type_id = not_node_get_type_once ();
		g_once_init_leave (&not_node_type_id__once, not_node_type_id);
	}
	return not_node_type_id__once;
}

AndNode*
and_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	AndNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (AndNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

AndNode*
and_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return and_node_construct (TYPE_AND_NODE, parser, token, precedence, associativity);
}

static Number*
and_node_real_solve_lr (LRNode* base,
                        Number* l,
                        Number* r)
{
	AndNode * self;
	Number* _tmp0_;
	Number* result;
	self = (AndNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_and (l, r);
	result = _tmp0_;
	return result;
}

static void
and_node_class_init (AndNodeClass * klass,
                     gpointer klass_data)
{
	and_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) and_node_real_solve_lr;
}

static void
and_node_instance_init (AndNode * self,
                        gpointer klass)
{
}

static GType
and_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AndNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) and_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AndNode), 0, (GInstanceInitFunc) and_node_instance_init, NULL };
	GType and_node_type_id;
	and_node_type_id = g_type_register_static (TYPE_LR_NODE, "AndNode", &g_define_type_info, 0);
	return and_node_type_id;
}

GType
and_node_get_type (void)
{
	static volatile gsize and_node_type_id__once = 0;
	if (g_once_init_enter (&and_node_type_id__once)) {
		GType and_node_type_id;
		and_node_type_id = and_node_get_type_once ();
		g_once_init_leave (&and_node_type_id__once, and_node_type_id);
	}
	return and_node_type_id__once;
}

NandNode*
nand_node_construct (GType object_type,
                     Parser* parser,
                     LexerToken* token,
                     guint precedence,
                     Associativity associativity)
{
	NandNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (NandNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

NandNode*
nand_node_new (Parser* parser,
               LexerToken* token,
               guint precedence,
               Associativity associativity)
{
	return nand_node_construct (TYPE_NAND_NODE, parser, token, precedence, associativity);
}

static Number*
nand_node_real_solve_lr (LRNode* base,
                         Number* l,
                         Number* r)
{
	NandNode * self;
	Parser* _tmp0_;
	Number* _tmp1_;
	Number* result;
	self = (NandNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = number_nand (l, r, _tmp0_->wordlen);
	result = _tmp1_;
	return result;
}

static void
nand_node_class_init (NandNodeClass * klass,
                      gpointer klass_data)
{
	nand_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) nand_node_real_solve_lr;
}

static void
nand_node_instance_init (NandNode * self,
                         gpointer klass)
{
}

static GType
nand_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NandNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nand_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NandNode), 0, (GInstanceInitFunc) nand_node_instance_init, NULL };
	GType nand_node_type_id;
	nand_node_type_id = g_type_register_static (TYPE_LR_NODE, "NandNode", &g_define_type_info, 0);
	return nand_node_type_id;
}

GType
nand_node_get_type (void)
{
	static volatile gsize nand_node_type_id__once = 0;
	if (g_once_init_enter (&nand_node_type_id__once)) {
		GType nand_node_type_id;
		nand_node_type_id = nand_node_get_type_once ();
		g_once_init_leave (&nand_node_type_id__once, nand_node_type_id);
	}
	return nand_node_type_id__once;
}

OrNode*
or_node_construct (GType object_type,
                   Parser* parser,
                   LexerToken* token,
                   guint precedence,
                   Associativity associativity)
{
	OrNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (OrNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

OrNode*
or_node_new (Parser* parser,
             LexerToken* token,
             guint precedence,
             Associativity associativity)
{
	return or_node_construct (TYPE_OR_NODE, parser, token, precedence, associativity);
}

static Number*
or_node_real_solve_lr (LRNode* base,
                       Number* l,
                       Number* r)
{
	OrNode * self;
	Number* _tmp0_;
	Number* result;
	self = (OrNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_or (l, r);
	result = _tmp0_;
	return result;
}

static void
or_node_class_init (OrNodeClass * klass,
                    gpointer klass_data)
{
	or_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) or_node_real_solve_lr;
}

static void
or_node_instance_init (OrNode * self,
                       gpointer klass)
{
}

static GType
or_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OrNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) or_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OrNode), 0, (GInstanceInitFunc) or_node_instance_init, NULL };
	GType or_node_type_id;
	or_node_type_id = g_type_register_static (TYPE_LR_NODE, "OrNode", &g_define_type_info, 0);
	return or_node_type_id;
}

GType
or_node_get_type (void)
{
	static volatile gsize or_node_type_id__once = 0;
	if (g_once_init_enter (&or_node_type_id__once)) {
		GType or_node_type_id;
		or_node_type_id = or_node_get_type_once ();
		g_once_init_leave (&or_node_type_id__once, or_node_type_id);
	}
	return or_node_type_id__once;
}

NorNode*
nor_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	NorNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (NorNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

NorNode*
nor_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return nor_node_construct (TYPE_NOR_NODE, parser, token, precedence, associativity);
}

static Number*
nor_node_real_solve_lr (LRNode* base,
                        Number* l,
                        Number* r)
{
	NorNode * self;
	Parser* _tmp0_;
	Number* _tmp1_;
	Number* result;
	self = (NorNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = number_nor (l, r, _tmp0_->wordlen);
	result = _tmp1_;
	return result;
}

static void
nor_node_class_init (NorNodeClass * klass,
                     gpointer klass_data)
{
	nor_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) nor_node_real_solve_lr;
}

static void
nor_node_instance_init (NorNode * self,
                        gpointer klass)
{
}

static GType
nor_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NorNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nor_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NorNode), 0, (GInstanceInitFunc) nor_node_instance_init, NULL };
	GType nor_node_type_id;
	nor_node_type_id = g_type_register_static (TYPE_LR_NODE, "NorNode", &g_define_type_info, 0);
	return nor_node_type_id;
}

GType
nor_node_get_type (void)
{
	static volatile gsize nor_node_type_id__once = 0;
	if (g_once_init_enter (&nor_node_type_id__once)) {
		GType nor_node_type_id;
		nor_node_type_id = nor_node_get_type_once ();
		g_once_init_leave (&nor_node_type_id__once, nor_node_type_id);
	}
	return nor_node_type_id__once;
}

XorNode*
xor_node_construct (GType object_type,
                    Parser* parser,
                    LexerToken* token,
                    guint precedence,
                    Associativity associativity)
{
	XorNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (XorNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

XorNode*
xor_node_new (Parser* parser,
              LexerToken* token,
              guint precedence,
              Associativity associativity)
{
	return xor_node_construct (TYPE_XOR_NODE, parser, token, precedence, associativity);
}

static Number*
xor_node_real_solve_lr (LRNode* base,
                        Number* l,
                        Number* r)
{
	XorNode * self;
	Number* _tmp0_;
	Number* result;
	self = (XorNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = number_xor (l, r);
	result = _tmp0_;
	return result;
}

static void
xor_node_class_init (XorNodeClass * klass,
                     gpointer klass_data)
{
	xor_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) xor_node_real_solve_lr;
}

static void
xor_node_instance_init (XorNode * self,
                        gpointer klass)
{
}

static GType
xor_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XorNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xor_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XorNode), 0, (GInstanceInitFunc) xor_node_instance_init, NULL };
	GType xor_node_type_id;
	xor_node_type_id = g_type_register_static (TYPE_LR_NODE, "XorNode", &g_define_type_info, 0);
	return xor_node_type_id;
}

GType
xor_node_get_type (void)
{
	static volatile gsize xor_node_type_id__once = 0;
	if (g_once_init_enter (&xor_node_type_id__once)) {
		GType xor_node_type_id;
		xor_node_type_id = xor_node_get_type_once ();
		g_once_init_leave (&xor_node_type_id__once, xor_node_type_id);
	}
	return xor_node_type_id__once;
}

XnorNode*
xnor_node_construct (GType object_type,
                     Parser* parser,
                     LexerToken* token,
                     guint precedence,
                     Associativity associativity)
{
	XnorNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (XnorNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

XnorNode*
xnor_node_new (Parser* parser,
               LexerToken* token,
               guint precedence,
               Associativity associativity)
{
	return xnor_node_construct (TYPE_XNOR_NODE, parser, token, precedence, associativity);
}

static Number*
xnor_node_real_solve_lr (LRNode* base,
                         Number* l,
                         Number* r)
{
	XnorNode * self;
	Parser* _tmp0_;
	Number* _tmp1_;
	Number* result;
	self = (XnorNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->parser;
	_tmp1_ = number_xnor (l, r, _tmp0_->wordlen);
	result = _tmp1_;
	return result;
}

static void
xnor_node_class_init (XnorNodeClass * klass,
                      gpointer klass_data)
{
	xnor_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) xnor_node_real_solve_lr;
}

static void
xnor_node_instance_init (XnorNode * self,
                         gpointer klass)
{
}

static GType
xnor_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (XnorNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xnor_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XnorNode), 0, (GInstanceInitFunc) xnor_node_instance_init, NULL };
	GType xnor_node_type_id;
	xnor_node_type_id = g_type_register_static (TYPE_LR_NODE, "XnorNode", &g_define_type_info, 0);
	return xnor_node_type_id;
}

GType
xnor_node_get_type (void)
{
	static volatile gsize xnor_node_type_id__once = 0;
	if (g_once_init_enter (&xnor_node_type_id__once)) {
		GType xnor_node_type_id;
		xnor_node_type_id = xnor_node_get_type_once ();
		g_once_init_leave (&xnor_node_type_id__once, xnor_node_type_id);
	}
	return xnor_node_type_id__once;
}

ConvertNode*
convert_node_construct (GType object_type,
                        Parser* parser,
                        LexerToken* token,
                        guint precedence,
                        Associativity associativity)
{
	ConvertNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ConvertNode*) lr_node_construct (object_type, parser, token, precedence, associativity);
	return self;
}

ConvertNode*
convert_node_new (Parser* parser,
                  LexerToken* token,
                  guint precedence,
                  Associativity associativity)
{
	return convert_node_construct (TYPE_CONVERT_NODE, parser, token, precedence, associativity);
}

static Number*
convert_node_real_solve_lr (LRNode* base,
                            Number* l,
                            Number* r)
{
	ConvertNode * self;
	gchar* from = NULL;
	ParseNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* to = NULL;
	ParseNode* _tmp11_;
	const gchar* _tmp12_;
	Number* tmp = NULL;
	Number* _tmp22_;
	Number* ans = NULL;
	Parser* _tmp23_;
	Number* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	Number* _tmp27_;
	Number* _tmp28_;
	Number* result;
	self = (ConvertNode*) base;
	g_return_val_if_fail (l != NULL, NULL);
	g_return_val_if_fail (r != NULL, NULL);
	_tmp0_ = ((ParseNode*) self)->left;
	_tmp1_ = _tmp0_->value;
	if (_tmp1_ != NULL) {
		ParseNode* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		ParseNode* _tmp5_;
		_tmp2_ = ((ParseNode*) self)->left;
		_tmp3_ = _tmp2_->value;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (from);
		from = _tmp4_;
		_tmp5_ = ((ParseNode*) self)->left;
		_g_free0 (_tmp5_->value);
		_tmp5_->value = NULL;
	} else {
		ParseNode* _tmp6_;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = ((ParseNode*) self)->left;
		_tmp7_ = parse_node_token (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->text;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (from);
		from = _tmp10_;
		_g_object_unref0 (_tmp8_);
	}
	_tmp11_ = ((ParseNode*) self)->right;
	_tmp12_ = _tmp11_->value;
	if (_tmp12_ != NULL) {
		ParseNode* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		ParseNode* _tmp16_;
		_tmp13_ = ((ParseNode*) self)->right;
		_tmp14_ = _tmp13_->value;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (to);
		to = _tmp15_;
		_tmp16_ = ((ParseNode*) self)->right;
		_g_free0 (_tmp16_->value);
		_tmp16_->value = NULL;
	} else {
		ParseNode* _tmp17_;
		LexerToken* _tmp18_;
		LexerToken* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = ((ParseNode*) self)->right;
		_tmp18_ = parse_node_token (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_->text;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (to);
		to = _tmp21_;
		_g_object_unref0 (_tmp19_);
	}
	_tmp22_ = number_new_integer ((gint64) 1, (gint64) 0);
	tmp = _tmp22_;
	_tmp23_ = ((ParseNode*) self)->parser;
	_tmp24_ = tmp;
	_tmp25_ = from;
	_tmp26_ = to;
	_tmp27_ = parser_convert (_tmp23_, _tmp24_, _tmp25_, _tmp26_, NULL, NULL);
	ans = _tmp27_;
	_tmp28_ = ans;
	if (_tmp28_ == NULL) {
		Parser* _tmp29_;
		_tmp29_ = ((ParseNode*) self)->parser;
		parser_set_error (_tmp29_, ERROR_CODE_UNKNOWN_CONVERSION, NULL, (guint) 0, (guint) 0);
	}
	result = ans;
	_g_object_unref0 (tmp);
	_g_free0 (to);
	_g_free0 (from);
	return result;
}

static void
convert_node_class_init (ConvertNodeClass * klass,
                         gpointer klass_data)
{
	convert_node_parent_class = g_type_class_peek_parent (klass);
	((LRNodeClass *) klass)->solve_lr = (Number* (*) (LRNode*, Number*, Number*)) convert_node_real_solve_lr;
}

static void
convert_node_instance_init (ConvertNode * self,
                            gpointer klass)
{
}

static GType
convert_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConvertNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertNode), 0, (GInstanceInitFunc) convert_node_instance_init, NULL };
	GType convert_node_type_id;
	convert_node_type_id = g_type_register_static (TYPE_LR_NODE, "ConvertNode", &g_define_type_info, 0);
	return convert_node_type_id;
}

GType
convert_node_get_type (void)
{
	static volatile gsize convert_node_type_id__once = 0;
	if (g_once_init_enter (&convert_node_type_id__once)) {
		GType convert_node_type_id;
		convert_node_type_id = convert_node_get_type_once ();
		g_once_init_leave (&convert_node_type_id__once, convert_node_type_id);
	}
	return convert_node_type_id__once;
}

ConvertBaseNode*
convert_base_node_construct (GType object_type,
                             Parser* parser,
                             LexerToken* token,
                             guint precedence,
                             Associativity associativity,
                             const gchar* value)
{
	ConvertBaseNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ConvertBaseNode*) parse_node_construct (object_type, parser, token, precedence, associativity, value);
	return self;
}

ConvertBaseNode*
convert_base_node_new (Parser* parser,
                       LexerToken* token,
                       guint precedence,
                       Associativity associativity,
                       const gchar* value)
{
	return convert_base_node_construct (TYPE_CONVERT_BASE_NODE, parser, token, precedence, associativity, value);
}

static Number*
convert_base_node_real_solve (ParseNode* base)
{
	ConvertBaseNode * self;
	gchar* name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	ParseNode* _tmp34_;
	Number* _tmp35_;
	Number* result;
	self = (ConvertBaseNode*) base;
	_tmp0_ = ((ParseNode*) self)->value;
	_tmp1_ = g_strdup (_tmp0_);
	name = _tmp1_;
	_tmp3_ = name;
	if (_tmp3_ == NULL) {
		ParseNode* _tmp4_;
		_tmp4_ = ((ParseNode*) self)->right;
		_tmp2_ = _tmp4_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ParseNode* _tmp5_;
		LexerToken* _tmp6_;
		LexerToken* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = ((ParseNode*) self)->right;
		_tmp6_ = parse_node_token (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->text;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (name);
		name = _tmp9_;
		_g_object_unref0 (_tmp7_);
	}
	_tmp11_ = name;
	if (g_strcmp0 (_tmp11_, "hex") == 0) {
		_tmp10_ = TRUE;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = name;
		_tmp10_ = g_strcmp0 (_tmp12_, "hexadecimal") == 0;
	}
	if (_tmp10_) {
		Parser* _tmp13_;
		_tmp13_ = ((ParseNode*) self)->parser;
		parser_set_representation_base (_tmp13_, (guint) 16);
	} else {
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		_tmp15_ = name;
		if (g_strcmp0 (_tmp15_, "dec") == 0) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = name;
			_tmp14_ = g_strcmp0 (_tmp16_, "decimal") == 0;
		}
		if (_tmp14_) {
			Parser* _tmp17_;
			_tmp17_ = ((ParseNode*) self)->parser;
			parser_set_representation_base (_tmp17_, (guint) 10);
		} else {
			gboolean _tmp18_ = FALSE;
			const gchar* _tmp19_;
			_tmp19_ = name;
			if (g_strcmp0 (_tmp19_, "oct") == 0) {
				_tmp18_ = TRUE;
			} else {
				const gchar* _tmp20_;
				_tmp20_ = name;
				_tmp18_ = g_strcmp0 (_tmp20_, "octal") == 0;
			}
			if (_tmp18_) {
				Parser* _tmp21_;
				_tmp21_ = ((ParseNode*) self)->parser;
				parser_set_representation_base (_tmp21_, (guint) 8);
			} else {
				gboolean _tmp22_ = FALSE;
				const gchar* _tmp23_;
				_tmp23_ = name;
				if (g_strcmp0 (_tmp23_, "bin") == 0) {
					_tmp22_ = TRUE;
				} else {
					const gchar* _tmp24_;
					_tmp24_ = name;
					_tmp22_ = g_strcmp0 (_tmp24_, "binary") == 0;
				}
				if (_tmp22_) {
					Parser* _tmp25_;
					_tmp25_ = ((ParseNode*) self)->parser;
					parser_set_representation_base (_tmp25_, (guint) 2);
				} else {
					Parser* _tmp26_;
					LexerToken* _tmp27_;
					LexerToken* _tmp28_;
					const gchar* _tmp29_;
					LexerToken* _tmp30_;
					LexerToken* _tmp31_;
					LexerToken* _tmp32_;
					LexerToken* _tmp33_;
					_tmp26_ = ((ParseNode*) self)->parser;
					_tmp27_ = parse_node_token ((ParseNode*) self);
					_tmp28_ = _tmp27_;
					_tmp29_ = _tmp28_->text;
					_tmp30_ = parse_node_first_token ((ParseNode*) self);
					_tmp31_ = _tmp30_;
					_tmp32_ = parse_node_last_token ((ParseNode*) self);
					_tmp33_ = _tmp32_;
					parser_set_error (_tmp26_, ERROR_CODE_UNKNOWN_CONVERSION, _tmp29_, _tmp31_->start_index, _tmp33_->end_index);
					_g_object_unref0 (_tmp33_);
					_g_object_unref0 (_tmp31_);
					_g_object_unref0 (_tmp28_);
					result = NULL;
					_g_free0 (name);
					return result;
				}
			}
		}
	}
	_tmp34_ = ((ParseNode*) self)->left;
	_tmp35_ = parse_node_solve (_tmp34_);
	result = _tmp35_;
	_g_free0 (name);
	return result;
}

static void
convert_base_node_class_init (ConvertBaseNodeClass * klass,
                              gpointer klass_data)
{
	convert_base_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) convert_base_node_real_solve;
}

static void
convert_base_node_instance_init (ConvertBaseNode * self,
                                 gpointer klass)
{
}

static GType
convert_base_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConvertBaseNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_base_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertBaseNode), 0, (GInstanceInitFunc) convert_base_node_instance_init, NULL };
	GType convert_base_node_type_id;
	convert_base_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConvertBaseNode", &g_define_type_info, 0);
	return convert_base_node_type_id;
}

GType
convert_base_node_get_type (void)
{
	static volatile gsize convert_base_node_type_id__once = 0;
	if (g_once_init_enter (&convert_base_node_type_id__once)) {
		GType convert_base_node_type_id;
		convert_base_node_type_id = convert_base_node_get_type_once ();
		g_once_init_leave (&convert_base_node_type_id__once, convert_base_node_type_id);
	}
	return convert_base_node_type_id__once;
}

ConvertNumberNode*
convert_number_node_construct (GType object_type,
                               Parser* parser,
                               LexerToken* token,
                               guint precedence,
                               Associativity associativity)
{
	ConvertNumberNode * self = NULL;
	g_return_val_if_fail (parser != NULL, NULL);
	self = (ConvertNumberNode*) parse_node_construct (object_type, parser, token, precedence, associativity, NULL);
	return self;
}

ConvertNumberNode*
convert_number_node_new (Parser* parser,
                         LexerToken* token,
                         guint precedence,
                         Associativity associativity)
{
	return convert_number_node_construct (TYPE_CONVERT_NUMBER_NODE, parser, token, precedence, associativity);
}

static Number*
convert_number_node_real_solve (ParseNode* base)
{
	ConvertNumberNode * self;
	gchar* from = NULL;
	ParseNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* to = NULL;
	ParseNode* _tmp11_;
	const gchar* _tmp12_;
	Number* tmp = NULL;
	ParseNode* _tmp22_;
	ParseNode* _tmp23_;
	Number* _tmp24_;
	Number* _tmp25_;
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	Number* ans = NULL;
	Parser* _tmp26_;
	Number* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	Unit* _tmp30_ = NULL;
	Unit* _tmp31_ = NULL;
	Number* _tmp32_;
	Number* _tmp33_;
	Number* result;
	self = (ConvertNumberNode*) base;
	_tmp0_ = ((ParseNode*) self)->left;
	_tmp1_ = _tmp0_->value;
	if (_tmp1_ != NULL) {
		ParseNode* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		ParseNode* _tmp5_;
		_tmp2_ = ((ParseNode*) self)->left;
		_tmp3_ = _tmp2_->value;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (from);
		from = _tmp4_;
		_tmp5_ = ((ParseNode*) self)->left;
		_g_free0 (_tmp5_->value);
		_tmp5_->value = NULL;
	} else {
		ParseNode* _tmp6_;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = ((ParseNode*) self)->left;
		_tmp7_ = parse_node_token (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->text;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (from);
		from = _tmp10_;
		_g_object_unref0 (_tmp8_);
	}
	_tmp11_ = ((ParseNode*) self)->right;
	_tmp12_ = _tmp11_->value;
	if (_tmp12_ != NULL) {
		ParseNode* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		ParseNode* _tmp16_;
		_tmp13_ = ((ParseNode*) self)->right;
		_tmp14_ = _tmp13_->value;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (to);
		to = _tmp15_;
		_tmp16_ = ((ParseNode*) self)->right;
		_g_free0 (_tmp16_->value);
		_tmp16_->value = NULL;
	} else {
		ParseNode* _tmp17_;
		LexerToken* _tmp18_;
		LexerToken* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp17_ = ((ParseNode*) self)->right;
		_tmp18_ = parse_node_token (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_->text;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (to);
		to = _tmp21_;
		_g_object_unref0 (_tmp19_);
	}
	_tmp22_ = ((ParseNode*) self)->left;
	_tmp23_ = _tmp22_->left;
	_tmp24_ = parse_node_solve (_tmp23_);
	tmp = _tmp24_;
	_tmp25_ = tmp;
	if (_tmp25_ == NULL) {
		result = NULL;
		_g_object_unref0 (tmp);
		_g_free0 (to);
		_g_free0 (from);
		return result;
	}
	from_unit = NULL;
	to_unit = NULL;
	_tmp26_ = ((ParseNode*) self)->parser;
	_tmp27_ = tmp;
	_tmp28_ = from;
	_tmp29_ = to;
	_tmp32_ = parser_convert (_tmp26_, _tmp27_, _tmp28_, _tmp29_, &_tmp30_, &_tmp31_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp30_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp31_;
	ans = _tmp32_;
	_tmp33_ = ans;
	if (_tmp33_ == NULL) {
		Unit* _tmp34_;
		_tmp34_ = from_unit;
		if (_tmp34_ == NULL) {
			Parser* _tmp35_;
			const gchar* _tmp36_;
			ParseNode* _tmp37_;
			LexerToken* _tmp38_;
			LexerToken* _tmp39_;
			ParseNode* _tmp40_;
			LexerToken* _tmp41_;
			LexerToken* _tmp42_;
			_tmp35_ = ((ParseNode*) self)->parser;
			_tmp36_ = from;
			_tmp37_ = ((ParseNode*) self)->left;
			_tmp38_ = parse_node_token (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = ((ParseNode*) self)->left;
			_tmp41_ = parse_node_token (_tmp40_);
			_tmp42_ = _tmp41_;
			parser_set_error (_tmp35_, ERROR_CODE_UNKNOWN_UNIT, _tmp36_, _tmp39_->start_index, _tmp42_->end_index);
			_g_object_unref0 (_tmp42_);
			_g_object_unref0 (_tmp39_);
		} else {
			Unit* _tmp43_;
			_tmp43_ = to_unit;
			if (_tmp43_ == NULL) {
				Parser* _tmp44_;
				const gchar* _tmp45_;
				ParseNode* _tmp46_;
				LexerToken* _tmp47_;
				LexerToken* _tmp48_;
				ParseNode* _tmp49_;
				LexerToken* _tmp50_;
				LexerToken* _tmp51_;
				_tmp44_ = ((ParseNode*) self)->parser;
				_tmp45_ = to;
				_tmp46_ = ((ParseNode*) self)->right;
				_tmp47_ = parse_node_token (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = ((ParseNode*) self)->right;
				_tmp50_ = parse_node_token (_tmp49_);
				_tmp51_ = _tmp50_;
				parser_set_error (_tmp44_, ERROR_CODE_UNKNOWN_UNIT, _tmp45_, _tmp48_->start_index, _tmp51_->end_index);
				_g_object_unref0 (_tmp51_);
				_g_object_unref0 (_tmp48_);
			} else {
				gboolean _tmp52_ = FALSE;
				Unit* _tmp53_;
				_tmp53_ = from_unit;
				if (_tmp53_ != NULL) {
					Parser* _tmp54_;
					Unit* _tmp55_;
					gchar* _tmp56_;
					gchar* _tmp57_;
					gchar* _tmp58_;
					_tmp54_ = ((ParseNode*) self)->parser;
					_tmp55_ = from_unit;
					_tmp56_ = unit_get_name (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = _tmp57_;
					_tmp52_ = !parser_currency_has_rate (_tmp54_, _tmp58_);
					_g_free0 (_tmp58_);
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					Parser* _tmp59_;
					Unit* _tmp60_;
					gchar* _tmp61_;
					gchar* _tmp62_;
					gchar* _tmp63_;
					ParseNode* _tmp64_;
					LexerToken* _tmp65_;
					LexerToken* _tmp66_;
					ParseNode* _tmp67_;
					LexerToken* _tmp68_;
					LexerToken* _tmp69_;
					_tmp59_ = ((ParseNode*) self)->parser;
					_tmp60_ = from_unit;
					_tmp61_ = unit_get_display_name (_tmp60_);
					_tmp62_ = _tmp61_;
					_tmp63_ = _tmp62_;
					_tmp64_ = ((ParseNode*) self)->left;
					_tmp65_ = parse_node_token (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = ((ParseNode*) self)->left;
					_tmp68_ = parse_node_token (_tmp67_);
					_tmp69_ = _tmp68_;
					parser_set_error (_tmp59_, ERROR_CODE_UNKNOWN_RATE, _tmp63_, _tmp66_->start_index, _tmp69_->end_index);
					_g_object_unref0 (_tmp69_);
					_g_object_unref0 (_tmp66_);
					_g_free0 (_tmp63_);
				} else {
					gboolean _tmp70_ = FALSE;
					Unit* _tmp71_;
					_tmp71_ = to_unit;
					if (_tmp71_ != NULL) {
						Parser* _tmp72_;
						Unit* _tmp73_;
						gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						_tmp72_ = ((ParseNode*) self)->parser;
						_tmp73_ = to_unit;
						_tmp74_ = unit_get_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp76_ = _tmp75_;
						_tmp70_ = !parser_currency_has_rate (_tmp72_, _tmp76_);
						_g_free0 (_tmp76_);
					} else {
						_tmp70_ = FALSE;
					}
					if (_tmp70_) {
						Parser* _tmp77_;
						Unit* _tmp78_;
						gchar* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						ParseNode* _tmp82_;
						LexerToken* _tmp83_;
						LexerToken* _tmp84_;
						ParseNode* _tmp85_;
						LexerToken* _tmp86_;
						LexerToken* _tmp87_;
						_tmp77_ = ((ParseNode*) self)->parser;
						_tmp78_ = to_unit;
						_tmp79_ = unit_get_display_name (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = _tmp80_;
						_tmp82_ = ((ParseNode*) self)->right;
						_tmp83_ = parse_node_token (_tmp82_);
						_tmp84_ = _tmp83_;
						_tmp85_ = ((ParseNode*) self)->right;
						_tmp86_ = parse_node_token (_tmp85_);
						_tmp87_ = _tmp86_;
						parser_set_error (_tmp77_, ERROR_CODE_UNKNOWN_RATE, _tmp81_, _tmp84_->start_index, _tmp87_->end_index);
						_g_object_unref0 (_tmp87_);
						_g_object_unref0 (_tmp84_);
						_g_free0 (_tmp81_);
					} else {
						Parser* _tmp88_;
						_tmp88_ = ((ParseNode*) self)->parser;
						parser_set_error (_tmp88_, ERROR_CODE_UNKNOWN_CONVERSION, NULL, (guint) 0, (guint) 0);
					}
				}
			}
		}
	}
	result = ans;
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
	_g_object_unref0 (tmp);
	_g_free0 (to);
	_g_free0 (from);
	return result;
}

static void
convert_number_node_class_init (ConvertNumberNodeClass * klass,
                                gpointer klass_data)
{
	convert_number_node_parent_class = g_type_class_peek_parent (klass);
	((ParseNodeClass *) klass)->solve = (Number* (*) (ParseNode*)) convert_number_node_real_solve;
}

static void
convert_number_node_instance_init (ConvertNumberNode * self,
                                   gpointer klass)
{
}

static GType
convert_number_node_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ConvertNumberNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) convert_number_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConvertNumberNode), 0, (GInstanceInitFunc) convert_number_node_instance_init, NULL };
	GType convert_number_node_type_id;
	convert_number_node_type_id = g_type_register_static (TYPE_PARSE_NODE, "ConvertNumberNode", &g_define_type_info, 0);
	return convert_number_node_type_id;
}

GType
convert_number_node_get_type (void)
{
	static volatile gsize convert_number_node_type_id__once = 0;
	if (g_once_init_enter (&convert_number_node_type_id__once)) {
		GType convert_number_node_type_id;
		convert_number_node_type_id = convert_number_node_get_type_once ();
		g_once_init_leave (&convert_number_node_type_id__once, convert_number_node_type_id);
	}
	return convert_number_node_type_id__once;
}

static inline gpointer
parser_get_instance_private (Parser* self)
{
	return G_STRUCT_MEMBER_P (self, Parser_private_offset);
}

Parser*
parser_construct (GType object_type,
                  const gchar* input,
                  gint number_base,
                  gint wordlen,
                  AngleUnit angle_units)
{
	Parser* self = NULL;
	gchar* _tmp0_;
	Lexer* _tmp1_;
	g_return_val_if_fail (input != NULL, NULL);
	self = (Parser*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (input);
	_g_free0 (self->priv->input);
	self->priv->input = _tmp0_;
	_tmp1_ = lexer_new (input, self, number_base);
	_g_object_unref0 (self->priv->lexer);
	self->priv->lexer = _tmp1_;
	_g_object_unref0 (self->priv->root);
	self->priv->root = NULL;
	self->priv->depth_level = (guint) 0;
	_g_object_unref0 (self->priv->right_most);
	self->priv->right_most = NULL;
	self->number_base = number_base;
	self->priv->representation_base = (guint) number_base;
	self->wordlen = wordlen;
	self->angle_units = angle_units;
	self->priv->error = ERROR_CODE_NONE;
	_g_free0 (self->priv->error_token);
	self->priv->error_token = NULL;
	self->priv->error_token_start = 0;
	self->priv->error_token_end = 0;
	return self;
}

Parser*
parser_new (const gchar* input,
            gint number_base,
            gint wordlen,
            AngleUnit angle_units)
{
	return parser_construct (TYPE_PARSER, input, number_base, wordlen, angle_units);
}

gboolean
parser_create_parse_tree (Parser* self,
                          guint* representation_base,
                          ErrorCode* error_code,
                          gchar** error_token,
                          guint* error_start,
                          guint* error_end)
{
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint _vala_error_start = 0U;
	guint _vala_error_end = 0U;
	Lexer* _tmp0_;
	gboolean ret = FALSE;
	LexerToken* token = NULL;
	Lexer* _tmp1_;
	LexerToken* _tmp2_;
	LexerToken* _tmp3_;
	LexerToken* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_representation_base = (guint) self->number_base;
	_tmp0_ = self->priv->lexer;
	lexer_scan (_tmp0_);
	ret = parser_statement (self);
	_tmp1_ = self->priv->lexer;
	_tmp2_ = lexer_get_next_token (_tmp1_);
	token = _tmp2_;
	_tmp3_ = token;
	if (_tmp3_->type == LEXER_TOKEN_TYPE_ASSIGN) {
		Lexer* _tmp4_;
		LexerToken* _tmp5_;
		LexerToken* _tmp6_;
		_tmp4_ = self->priv->lexer;
		_tmp5_ = lexer_get_next_token (_tmp4_);
		_g_object_unref0 (token);
		token = _tmp5_;
		_tmp6_ = token;
		if (_tmp6_->type != LEXER_TOKEN_TYPE_PL_EOS) {
			const gchar* _tmp11_;
			gchar* _tmp12_;
			if (self->priv->error == ERROR_CODE_NONE) {
				LexerToken* _tmp7_;
				const gchar* _tmp8_;
				LexerToken* _tmp9_;
				LexerToken* _tmp10_;
				_tmp7_ = token;
				_tmp8_ = _tmp7_->text;
				_tmp9_ = token;
				_tmp10_ = token;
				parser_set_error (self, ERROR_CODE_INVALID, _tmp8_, _tmp9_->start_index, _tmp10_->end_index);
			}
			_vala_error_code = self->priv->error;
			_tmp11_ = self->priv->error_token;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_vala_error_token);
			_vala_error_token = _tmp12_;
			_vala_error_start = (guint) self->priv->error_token_start;
			_vala_error_end = (guint) self->priv->error_token_end;
			result = FALSE;
			_g_object_unref0 (token);
			if (representation_base) {
				*representation_base = _vala_representation_base;
			}
			if (error_code) {
				*error_code = _vala_error_code;
			}
			if (error_token) {
				*error_token = _vala_error_token;
			} else {
				_g_free0 (_vala_error_token);
			}
			if (error_start) {
				*error_start = _vala_error_start;
			}
			if (error_end) {
				*error_end = _vala_error_end;
			}
			return result;
		}
	}
	_tmp13_ = token;
	if (_tmp13_->type != LEXER_TOKEN_TYPE_PL_EOS) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		if (self->priv->error == ERROR_CODE_NONE) {
			LexerToken* _tmp14_;
			const gchar* _tmp15_;
			LexerToken* _tmp16_;
			LexerToken* _tmp17_;
			_tmp14_ = token;
			_tmp15_ = _tmp14_->text;
			_tmp16_ = token;
			_tmp17_ = token;
			parser_set_error (self, ERROR_CODE_INVALID, _tmp15_, _tmp16_->start_index, _tmp17_->end_index);
		}
		_vala_error_code = self->priv->error;
		_tmp18_ = self->priv->error_token;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (_vala_error_token);
		_vala_error_token = _tmp19_;
		_vala_error_start = (guint) self->priv->error_token_start;
		_vala_error_end = (guint) self->priv->error_token_end;
		result = FALSE;
		_g_object_unref0 (token);
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	if (!ret) {
		const gchar* _tmp20_;
		gchar* _tmp21_;
		if (self->priv->error == ERROR_CODE_NONE) {
			parser_set_error (self, ERROR_CODE_INVALID, NULL, (guint) 0, (guint) 0);
		}
		_vala_error_code = self->priv->error;
		_tmp20_ = self->priv->error_token;
		_tmp21_ = g_strdup (_tmp20_);
		_g_free0 (_vala_error_token);
		_vala_error_token = _tmp21_;
		_vala_error_start = (guint) self->priv->error_token_start;
		_vala_error_end = (guint) self->priv->error_token_end;
		result = FALSE;
		_g_object_unref0 (token);
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	_vala_error_code = ERROR_CODE_NONE;
	_g_free0 (_vala_error_token);
	_vala_error_token = NULL;
	_vala_error_start = (guint) 0;
	_vala_error_end = (guint) 0;
	result = TRUE;
	_g_object_unref0 (token);
	if (representation_base) {
		*representation_base = _vala_representation_base;
	}
	if (error_code) {
		*error_code = _vala_error_code;
	}
	if (error_token) {
		*error_token = _vala_error_token;
	} else {
		_g_free0 (_vala_error_token);
	}
	if (error_start) {
		*error_start = _vala_error_start;
	}
	if (error_end) {
		*error_end = _vala_error_end;
	}
	return result;
}

void
parser_set_error (Parser* self,
                  ErrorCode errorno,
                  const gchar* token,
                  guint token_start,
                  guint token_end)
{
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->error = errorno;
	_tmp0_ = g_strdup (token);
	_g_free0 (self->priv->error_token);
	self->priv->error_token = _tmp0_;
	_tmp1_ = self->priv->input;
	self->priv->error_token_start = g_utf8_strlen (_tmp1_, (gssize) token_start);
	_tmp2_ = self->priv->input;
	self->priv->error_token_end = g_utf8_strlen (_tmp2_, (gssize) token_end);
}

void
parser_set_representation_base (Parser* self,
                                guint new_base)
{
	g_return_if_fail (self != NULL);
	self->priv->representation_base = new_base;
}

static gboolean
parser_real_variable_is_defined (Parser* self,
                                 const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
parser_variable_is_defined (Parser* self,
                            const gchar* name)
{
	ParserClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->variable_is_defined) {
		return _klass_->variable_is_defined (self, name);
	}
	return FALSE;
}

static Number*
parser_real_get_variable (Parser* self,
                          const gchar* name)
{
	Number* result;
	g_return_val_if_fail (name != NULL, NULL);
	result = NULL;
	return result;
}

Number*
parser_get_variable (Parser* self,
                     const gchar* name)
{
	ParserClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->get_variable) {
		return _klass_->get_variable (self, name);
	}
	return NULL;
}

static void
parser_real_set_variable (Parser* self,
                          const gchar* name,
                          Number* x)
{
	g_return_if_fail (name != NULL);
	g_return_if_fail (x != NULL);
}

void
parser_set_variable (Parser* self,
                     const gchar* name,
                     Number* x)
{
	ParserClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->set_variable) {
		_klass_->set_variable (self, name, x);
	}
}

static gboolean
parser_real_function_is_defined (Parser* self,
                                 const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
parser_function_is_defined (Parser* self,
                            const gchar* name)
{
	ParserClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->function_is_defined) {
		return _klass_->function_is_defined (self, name);
	}
	return FALSE;
}

static gboolean
parser_real_unit_is_defined (Parser* self,
                             const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
parser_unit_is_defined (Parser* self,
                        const gchar* name)
{
	ParserClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->unit_is_defined) {
		return _klass_->unit_is_defined (self, name);
	}
	return FALSE;
}

static gboolean
parser_real_currency_is_defined (Parser* self,
                                 const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
parser_currency_is_defined (Parser* self,
                            const gchar* name)
{
	ParserClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->currency_is_defined) {
		return _klass_->currency_is_defined (self, name);
	}
	return FALSE;
}

static gboolean
parser_real_currency_has_rate (Parser* self,
                               const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
parser_currency_has_rate (Parser* self,
                          const gchar* name)
{
	ParserClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->currency_has_rate) {
		return _klass_->currency_has_rate (self, name);
	}
	return FALSE;
}

static gboolean
parser_real_literal_base_is_defined (Parser* self,
                                     const gchar* name)
{
	gboolean result;
	g_return_val_if_fail (name != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
parser_literal_base_is_defined (Parser* self,
                                const gchar* name)
{
	ParserClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->literal_base_is_defined) {
		return _klass_->literal_base_is_defined (self, name);
	}
	return FALSE;
}

static Number*
parser_real_convert (Parser* self,
                     Number* x,
                     const gchar* x_units,
                     const gchar* z_units,
                     Unit** x_unit,
                     Unit** z_unit)
{
	Unit* _vala_x_unit = NULL;
	Unit* _vala_z_unit = NULL;
	Number* result;
	g_return_val_if_fail (x != NULL, NULL);
	g_return_val_if_fail (x_units != NULL, NULL);
	g_return_val_if_fail (z_units != NULL, NULL);
	result = NULL;
	if (x_unit) {
		*x_unit = _vala_x_unit;
	} else {
		_g_object_unref0 (_vala_x_unit);
	}
	if (z_unit) {
		*z_unit = _vala_z_unit;
	} else {
		_g_object_unref0 (_vala_z_unit);
	}
	return result;
}

Number*
parser_convert (Parser* self,
                Number* x,
                const gchar* x_units,
                const gchar* z_units,
                Unit** x_unit,
                Unit** z_unit)
{
	ParserClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = PARSER_GET_CLASS (self);
	if (_klass_->convert) {
		return _klass_->convert (self, x, x_units, z_units, x_unit, z_unit);
	}
	return NULL;
}

gchar*
parser_get_last_operation (Parser* self,
                           Number** operand)
{
	Number* _vala_operand = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ParseNode* _tmp2_;
	ParseNode* _tmp6_;
	ParseNode* _tmp7_;
	Number* _tmp8_;
	ParseNode* _tmp9_;
	LexerToken* _tmp10_;
	LexerToken* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp2_ = self->priv->root;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ParseNode* _tmp3_;
		_tmp3_ = self->priv->root;
		_tmp1_ = !IS_LR_NODE (_tmp3_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ParseNode* _tmp4_;
		_tmp4_ = self->priv->root;
		_tmp0_ = !lr_node_is_repeatable (IS_LR_NODE (_tmp4_) ? ((LRNode*) _tmp4_) : NULL);
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		if (operand) {
			*operand = _vala_operand;
		} else {
			_g_object_unref0 (_vala_operand);
		}
		return result;
	}
	_tmp6_ = self->priv->root;
	_tmp7_ = ((ParseNode*) (IS_LR_NODE (_tmp6_) ? ((LRNode*) _tmp6_) : NULL))->right;
	_tmp8_ = parse_node_solve (_tmp7_);
	_g_object_unref0 (_vala_operand);
	_vala_operand = _tmp8_;
	_tmp9_ = self->priv->root;
	_tmp10_ = parse_node_last_token (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_->text;
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp11_);
	result = _tmp14_;
	if (operand) {
		*operand = _vala_operand;
	} else {
		_g_object_unref0 (_vala_operand);
	}
	return result;
}

Number*
parser_parse (Parser* self,
              guint* representation_base,
              ErrorCode* error_code,
              gchar** error_token,
              guint* error_start,
              guint* error_end)
{
	guint _vala_representation_base = 0U;
	ErrorCode _vala_error_code = 0;
	gchar* _vala_error_token = NULL;
	guint _vala_error_start = 0U;
	guint _vala_error_end = 0U;
	gboolean is_successfully_parsed = FALSE;
	guint _tmp0_ = 0U;
	ErrorCode _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gboolean _tmp5_;
	Number* ans = NULL;
	ParseNode* _tmp6_;
	Number* _tmp7_;
	gboolean _tmp8_ = FALSE;
	Number* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	Number* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp5_ = parser_create_parse_tree (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_vala_representation_base = _tmp0_;
	_vala_error_code = _tmp1_;
	_g_free0 (_vala_error_token);
	_vala_error_token = _tmp2_;
	_vala_error_start = _tmp3_;
	_vala_error_end = _tmp4_;
	is_successfully_parsed = _tmp5_;
	if (!is_successfully_parsed) {
		result = NULL;
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	_tmp6_ = self->priv->root;
	_tmp7_ = parse_node_solve (_tmp6_);
	ans = _tmp7_;
	_tmp9_ = ans;
	if (_tmp9_ == NULL) {
		_tmp8_ = self->priv->error == ERROR_CODE_NONE;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_vala_error_code = ERROR_CODE_INVALID;
		_g_free0 (_vala_error_token);
		_vala_error_token = NULL;
		_vala_error_start = (guint) self->priv->error_token_start;
		_vala_error_end = (guint) self->priv->error_token_end;
		result = NULL;
		_g_object_unref0 (ans);
		if (representation_base) {
			*representation_base = _vala_representation_base;
		}
		if (error_code) {
			*error_code = _vala_error_code;
		}
		if (error_token) {
			*error_token = _vala_error_token;
		} else {
			_g_free0 (_vala_error_token);
		}
		if (error_start) {
			*error_start = _vala_error_start;
		}
		if (error_end) {
			*error_end = _vala_error_end;
		}
		return result;
	}
	_vala_representation_base = self->priv->representation_base;
	_vala_error_code = self->priv->error;
	_tmp10_ = self->priv->error_token;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (_vala_error_token);
	_vala_error_token = _tmp11_;
	_vala_error_start = (guint) self->priv->error_token_start;
	_vala_error_end = (guint) self->priv->error_token_end;
	result = ans;
	if (representation_base) {
		*representation_base = _vala_representation_base;
	}
	if (error_code) {
		*error_code = _vala_error_code;
	}
	if (error_token) {
		*error_token = _vala_error_token;
	} else {
		_g_free0 (_vala_error_token);
	}
	if (error_start) {
		*error_start = _vala_error_start;
	}
	if (error_end) {
		*error_end = _vala_error_end;
	}
	return result;
}

static Precedence
parser_get_precedence (Parser* self,
                       LexerTokenType type)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	Precedence result;
	g_return_val_if_fail (self != NULL, 0);
	if (type == LEXER_TOKEN_TYPE_ADD) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == LEXER_TOKEN_TYPE_SUBTRACT;
	}
	if (_tmp0_) {
		result = PRECEDENCE_ADD_SUBTRACT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_MULTIPLY) {
		result = PRECEDENCE_MULTIPLY;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_MOD) {
		result = PRECEDENCE_MOD;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_DIVIDE) {
		result = PRECEDENCE_DIVIDE;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_NOT) {
		result = PRECEDENCE_NOT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_ROOT) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == LEXER_TOKEN_TYPE_ROOT_3;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == LEXER_TOKEN_TYPE_ROOT_4;
	}
	if (_tmp1_) {
		result = PRECEDENCE_ROOT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_FUNCTION) {
		result = PRECEDENCE_FUNCTION;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_AND) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = type == LEXER_TOKEN_TYPE_NAND;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = type == LEXER_TOKEN_TYPE_OR;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = type == LEXER_TOKEN_TYPE_NOR;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = type == LEXER_TOKEN_TYPE_XOR;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = type == LEXER_TOKEN_TYPE_XNOR;
	}
	if (_tmp3_) {
		result = PRECEDENCE_BOOLEAN;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_PERCENTAGE) {
		result = PRECEDENCE_PERCENTAGE;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_POWER) {
		result = PRECEDENCE_POWER;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_FACTORIAL) {
		result = PRECEDENCE_FACTORIAL;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_NUMBER) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = type == LEXER_TOKEN_TYPE_VARIABLE;
	}
	if (_tmp8_) {
		result = PRECEDENCE_NUMBER_VARIABLE;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_UNIT) {
		result = PRECEDENCE_UNIT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_IN) {
		result = PRECEDENCE_CONVERT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_SHIFT_LEFT) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = type == LEXER_TOKEN_TYPE_SHIFT_RIGHT;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = type == LEXER_TOKEN_TYPE_SHIFT_URIGHT;
	}
	if (_tmp9_) {
		result = PRECEDENCE_SHIFT;
		return result;
	}
	if (type == LEXER_TOKEN_TYPE_L_R_BRACKET) {
		_tmp11_ = TRUE;
	} else {
		_tmp11_ = type == LEXER_TOKEN_TYPE_R_R_BRACKET;
	}
	if (_tmp11_) {
		result = PRECEDENCE_DEPTH;
		return result;
	}
	result = PRECEDENCE_TOP;
	return result;
}

static Associativity
parser_get_associativity_p (Parser* self,
                            Precedence type)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Associativity result;
	g_return_val_if_fail (self != NULL, 0);
	if (type == PRECEDENCE_BOOLEAN) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = type == PRECEDENCE_DIVIDE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = type == PRECEDENCE_MOD;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = type == PRECEDENCE_MULTIPLY;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = type == PRECEDENCE_ADD_SUBTRACT;
	}
	if (_tmp0_) {
		result = ASSOCIATIVITY_LEFT;
		return result;
	}
	if (type == PRECEDENCE_POWER) {
		result = ASSOCIATIVITY_RIGHT;
		return result;
	}
	result = ASSOCIATIVITY_LEFT;
	return result;
}

static Associativity
parser_get_associativity (Parser* self,
                          LexerToken* token)
{
	Associativity result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (token != NULL, 0);
	result = parser_get_associativity_p (self, parser_get_precedence (self, token->type));
	return result;
}

static guint
parser_make_precedence_p (Parser* self,
                          Precedence p)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = p + (self->priv->depth_level * PRECEDENCE_DEPTH);
	return result;
}

static guint
parser_make_precedence_t (Parser* self,
                          LexerTokenType type)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = parser_get_precedence (self, type) + (self->priv->depth_level * PRECEDENCE_DEPTH);
	return result;
}

static gboolean
parser_cmp_nodes (Parser* self,
                  ParseNode* left,
                  ParseNode* right)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (left == NULL) {
		result = FALSE;
		return result;
	}
	if (left->precedence > right->precedence) {
		result = TRUE;
		return result;
	} else {
		if (left->precedence < right->precedence) {
			result = FALSE;
			return result;
		} else {
			result = right->associativity != ASSOCIATIVITY_RIGHT;
			return result;
		}
	}
}

static void
parser_insert_into_tree_all (Parser* self,
                             ParseNode* node,
                             gboolean unary_function)
{
	ParseNode* _tmp0_;
	ParseNode* tmp = NULL;
	ParseNode* _tmp4_;
	ParseNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->priv->root;
	if (_tmp0_ == NULL) {
		ParseNode* _tmp1_;
		ParseNode* _tmp2_;
		ParseNode* _tmp3_;
		_tmp1_ = _g_object_ref0 (node);
		_g_object_unref0 (self->priv->root);
		self->priv->root = _tmp1_;
		_tmp2_ = self->priv->root;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (self->priv->right_most);
		self->priv->right_most = _tmp3_;
		return;
	}
	_tmp4_ = self->priv->right_most;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	tmp = _tmp5_;
	while (TRUE) {
		ParseNode* _tmp6_;
		ParseNode* _tmp7_;
		ParseNode* _tmp8_;
		ParseNode* _tmp9_;
		_tmp6_ = tmp;
		if (!parser_cmp_nodes (self, _tmp6_, node)) {
			break;
		}
		_tmp7_ = tmp;
		_tmp8_ = _tmp7_->parent;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (tmp);
		tmp = _tmp9_;
	}
	if (unary_function) {
		ParseNode* _tmp10_;
		ParseNode* _tmp30_;
		_tmp10_ = tmp;
		if (_tmp10_ == NULL) {
			ParseNode* _tmp11_;
			ParseNode* _tmp12_;
			ParseNode* _tmp13_;
			ParseNode* _tmp14_;
			ParseNode* _tmp15_;
			_tmp11_ = self->priv->root;
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (node->right);
			node->right = _tmp12_;
			_tmp13_ = node->right;
			_tmp14_ = _g_object_ref0 (node);
			_g_object_unref0 (_tmp13_->parent);
			_tmp13_->parent = _tmp14_;
			_tmp15_ = _g_object_ref0 (node);
			_g_object_unref0 (self->priv->root);
			self->priv->root = _tmp15_;
		} else {
			ParseNode* _tmp16_;
			ParseNode* _tmp17_;
			ParseNode* _tmp18_;
			ParseNode* _tmp19_;
			ParseNode* _tmp22_;
			ParseNode* _tmp23_;
			ParseNode* _tmp24_;
			ParseNode* _tmp25_;
			_tmp16_ = tmp;
			_tmp17_ = _tmp16_->right;
			_tmp18_ = _g_object_ref0 (_tmp17_);
			_g_object_unref0 (node->right);
			node->right = _tmp18_;
			_tmp19_ = node->right;
			if (_tmp19_ != NULL) {
				ParseNode* _tmp20_;
				ParseNode* _tmp21_;
				_tmp20_ = node->right;
				_tmp21_ = _g_object_ref0 (node);
				_g_object_unref0 (_tmp20_->parent);
				_tmp20_->parent = _tmp21_;
			}
			_tmp22_ = tmp;
			_tmp23_ = _g_object_ref0 (node);
			_g_object_unref0 (_tmp22_->right);
			_tmp22_->right = _tmp23_;
			_tmp24_ = tmp;
			_tmp25_ = _tmp24_->right;
			if (_tmp25_ != NULL) {
				ParseNode* _tmp26_;
				ParseNode* _tmp27_;
				ParseNode* _tmp28_;
				ParseNode* _tmp29_;
				_tmp26_ = tmp;
				_tmp27_ = _tmp26_->right;
				_tmp28_ = tmp;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_g_object_unref0 (_tmp27_->parent);
				_tmp27_->parent = _tmp29_;
			}
		}
		_tmp30_ = _g_object_ref0 (node);
		_g_object_unref0 (self->priv->right_most);
		self->priv->right_most = _tmp30_;
		while (TRUE) {
			ParseNode* _tmp31_;
			ParseNode* _tmp32_;
			ParseNode* _tmp33_;
			ParseNode* _tmp34_;
			ParseNode* _tmp35_;
			_tmp31_ = self->priv->right_most;
			_tmp32_ = _tmp31_->right;
			if (!(_tmp32_ != NULL)) {
				break;
			}
			_tmp33_ = self->priv->right_most;
			_tmp34_ = _tmp33_->right;
			_tmp35_ = _g_object_ref0 (_tmp34_);
			_g_object_unref0 (self->priv->right_most);
			self->priv->right_most = _tmp35_;
		}
	} else {
		ParseNode* _tmp36_;
		ParseNode* _tmp56_;
		_tmp36_ = tmp;
		if (_tmp36_ == NULL) {
			ParseNode* _tmp37_;
			ParseNode* _tmp38_;
			ParseNode* _tmp39_;
			ParseNode* _tmp40_;
			ParseNode* _tmp41_;
			_tmp37_ = self->priv->root;
			_tmp38_ = _g_object_ref0 (_tmp37_);
			_g_object_unref0 (node->left);
			node->left = _tmp38_;
			_tmp39_ = node->left;
			_tmp40_ = _g_object_ref0 (node);
			_g_object_unref0 (_tmp39_->parent);
			_tmp39_->parent = _tmp40_;
			_tmp41_ = _g_object_ref0 (node);
			_g_object_unref0 (self->priv->root);
			self->priv->root = _tmp41_;
		} else {
			ParseNode* _tmp42_;
			ParseNode* _tmp43_;
			ParseNode* _tmp44_;
			ParseNode* _tmp45_;
			ParseNode* _tmp48_;
			ParseNode* _tmp49_;
			ParseNode* _tmp50_;
			ParseNode* _tmp51_;
			_tmp42_ = tmp;
			_tmp43_ = _tmp42_->right;
			_tmp44_ = _g_object_ref0 (_tmp43_);
			_g_object_unref0 (node->left);
			node->left = _tmp44_;
			_tmp45_ = node->left;
			if (_tmp45_ != NULL) {
				ParseNode* _tmp46_;
				ParseNode* _tmp47_;
				_tmp46_ = node->left;
				_tmp47_ = _g_object_ref0 (node);
				_g_object_unref0 (_tmp46_->parent);
				_tmp46_->parent = _tmp47_;
			}
			_tmp48_ = tmp;
			_tmp49_ = _g_object_ref0 (node);
			_g_object_unref0 (_tmp48_->right);
			_tmp48_->right = _tmp49_;
			_tmp50_ = tmp;
			_tmp51_ = _tmp50_->right;
			if (_tmp51_ != NULL) {
				ParseNode* _tmp52_;
				ParseNode* _tmp53_;
				ParseNode* _tmp54_;
				ParseNode* _tmp55_;
				_tmp52_ = tmp;
				_tmp53_ = _tmp52_->right;
				_tmp54_ = tmp;
				_tmp55_ = _g_object_ref0 (_tmp54_);
				_g_object_unref0 (_tmp53_->parent);
				_tmp53_->parent = _tmp55_;
			}
		}
		_tmp56_ = _g_object_ref0 (node);
		_g_object_unref0 (self->priv->right_most);
		self->priv->right_most = _tmp56_;
	}
	_g_object_unref0 (tmp);
}

static void
parser_insert_into_tree (Parser* self,
                         ParseNode* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	parser_insert_into_tree_all (self, node, FALSE);
}

static void
parser_insert_into_tree_unary (Parser* self,
                               ParseNode* node)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	parser_insert_into_tree_all (self, node, TRUE);
}

static void
parser_destroy_all_nodes (Parser* self,
                          ParseNode* node)
{
	ParseNode* _tmp0_;
	ParseNode* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (node == NULL) {
		return;
	}
	_tmp0_ = node->left;
	parser_destroy_all_nodes (self, _tmp0_);
	_tmp1_ = node->right;
	parser_destroy_all_nodes (self, _tmp1_);
}

static gboolean
parser_check_variable (Parser* self,
                       const gchar* name)
{
	gint index = 0;
	gunichar c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	if (parser_variable_is_defined (self, name)) {
		result = TRUE;
		return result;
	}
	index = 0;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = string_get_next_char (name, &index, &_tmp0_);
		c = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		_tmp2_ = g_unichar_to_string (c);
		_tmp3_ = _tmp2_;
		_tmp4_ = !parser_variable_is_defined (self, _tmp3_);
		_g_free0 (_tmp3_);
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
parser_statement (Parser* self)
{
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	gboolean _tmp2_ = FALSE;
	LexerToken* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp3_ = token;
	if (_tmp3_->type == LEXER_TOKEN_TYPE_VARIABLE) {
		_tmp2_ = TRUE;
	} else {
		LexerToken* _tmp4_;
		_tmp4_ = token;
		_tmp2_ = _tmp4_->type == LEXER_TOKEN_TYPE_FUNCTION;
	}
	if (_tmp2_) {
		LexerToken* token_old = NULL;
		LexerToken* _tmp5_;
		LexerToken* _tmp6_;
		Lexer* _tmp7_;
		LexerToken* _tmp8_;
		LexerToken* _tmp9_;
		_tmp5_ = token;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		token_old = _tmp6_;
		_tmp7_ = self->priv->lexer;
		_tmp8_ = lexer_get_next_token (_tmp7_);
		_g_object_unref0 (token);
		token = _tmp8_;
		_tmp9_ = token;
		if (_tmp9_->type == LEXER_TOKEN_TYPE_ASSIGN) {
			LexerToken* _tmp10_;
			LexerToken* _tmp11_;
			NameNode* _tmp12_;
			NameNode* _tmp13_;
			LexerToken* _tmp14_;
			LexerToken* _tmp15_;
			AssignNode* _tmp16_;
			AssignNode* _tmp17_;
			_tmp10_ = token_old;
			_tmp11_ = token_old;
			_tmp12_ = name_node_new (self, _tmp10_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity (self, _tmp11_), NULL);
			_tmp13_ = _tmp12_;
			parser_insert_into_tree (self, (ParseNode*) _tmp13_);
			_g_object_unref0 (_tmp13_);
			_tmp14_ = token;
			_tmp15_ = token;
			_tmp16_ = assign_node_new (self, _tmp14_, (guint) 0, parser_get_associativity (self, _tmp15_));
			_tmp17_ = _tmp16_;
			parser_insert_into_tree (self, (ParseNode*) _tmp17_);
			_g_object_unref0 (_tmp17_);
			if (!parser_expression (self)) {
				result = FALSE;
				_g_object_unref0 (token_old);
				_g_object_unref0 (token);
				return result;
			}
			result = TRUE;
			_g_object_unref0 (token_old);
			_g_object_unref0 (token);
			return result;
		} else {
			Lexer* _tmp18_;
			Lexer* _tmp19_;
			LexerToken* _tmp20_;
			_tmp18_ = self->priv->lexer;
			lexer_roll_back (_tmp18_);
			_tmp19_ = self->priv->lexer;
			lexer_roll_back (_tmp19_);
			_tmp20_ = token;
			if (_tmp20_->type == LEXER_TOKEN_TYPE_L_R_BRACKET) {
				if (parser_function_definition (self)) {
					result = TRUE;
					_g_object_unref0 (token_old);
					_g_object_unref0 (token);
					return result;
				}
			}
			if (!parser_expression (self)) {
				result = FALSE;
				_g_object_unref0 (token_old);
				_g_object_unref0 (token);
				return result;
			}
			result = TRUE;
			_g_object_unref0 (token_old);
			_g_object_unref0 (token);
			return result;
		}
		_g_object_unref0 (token_old);
	} else {
		Lexer* _tmp21_;
		_tmp21_ = self->priv->lexer;
		lexer_roll_back (_tmp21_);
		if (!parser_expression (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	}
}

static gboolean
parser_function_definition (Parser* self)
{
	gint num_token_parsed = 0;
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	gint _tmp2_;
	gchar* function_name = NULL;
	LexerToken* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	Lexer* _tmp6_;
	LexerToken* _tmp7_;
	LexerToken* _tmp8_;
	gint _tmp9_;
	Lexer* _tmp10_;
	LexerToken* _tmp11_;
	gint _tmp12_;
	gchar* argument_list = NULL;
	gchar* _tmp13_;
	GList* token_list = NULL;
	LexerToken* _tmp26_;
	LexerToken* assign_token = NULL;
	Lexer* _tmp29_;
	LexerToken* _tmp30_;
	gint _tmp31_;
	LexerToken* _tmp32_;
	gchar* expression = NULL;
	gchar* _tmp35_;
	Lexer* _tmp36_;
	LexerToken* _tmp37_;
	const gchar* _tmp45_;
	FunctionNameNode* _tmp46_;
	FunctionNameNode* _tmp47_;
	FunctionNode* _tmp48_;
	FunctionNode* _tmp49_;
	GList* _tmp50_;
	const gchar* _tmp51_;
	FunctionArgumentsNode* _tmp52_;
	FunctionArgumentsNode* _tmp53_;
	LexerToken* _tmp54_;
	LexerToken* _tmp55_;
	AssignFunctionNode* _tmp56_;
	AssignFunctionNode* _tmp57_;
	const gchar* _tmp58_;
	FunctionDescriptionNode* _tmp59_;
	FunctionDescriptionNode* _tmp60_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	num_token_parsed = 0;
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = num_token_parsed;
	num_token_parsed = _tmp2_ + 1;
	_tmp3_ = token;
	_tmp4_ = _tmp3_->text;
	_tmp5_ = g_strdup (_tmp4_);
	function_name = _tmp5_;
	_tmp6_ = self->priv->lexer;
	_tmp7_ = lexer_get_next_token (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	_tmp9_ = num_token_parsed;
	num_token_parsed = _tmp9_ + 1;
	_tmp10_ = self->priv->lexer;
	_tmp11_ = lexer_get_next_token (_tmp10_);
	_g_object_unref0 (token);
	token = _tmp11_;
	_tmp12_ = num_token_parsed;
	num_token_parsed = _tmp12_ + 1;
	_tmp13_ = g_strdup ("");
	argument_list = _tmp13_;
	token_list = NULL;
	while (TRUE) {
		gboolean _tmp14_ = FALSE;
		LexerToken* _tmp15_;
		LexerToken* _tmp17_;
		LexerToken* _tmp18_;
		const gchar* _tmp19_;
		LexerToken* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		Lexer* _tmp23_;
		LexerToken* _tmp24_;
		gint _tmp25_;
		_tmp15_ = token;
		if (_tmp15_->type != LEXER_TOKEN_TYPE_R_R_BRACKET) {
			LexerToken* _tmp16_;
			_tmp16_ = token;
			_tmp14_ = _tmp16_->type != LEXER_TOKEN_TYPE_PL_EOS;
		} else {
			_tmp14_ = FALSE;
		}
		if (!_tmp14_) {
			break;
		}
		_tmp17_ = token;
		_tmp18_ = _g_object_ref0 (_tmp17_);
		token_list = g_list_append (token_list, _tmp18_);
		_tmp19_ = argument_list;
		_tmp20_ = token;
		_tmp21_ = _tmp20_->text;
		_tmp22_ = g_strconcat (_tmp19_, _tmp21_, NULL);
		_g_free0 (argument_list);
		argument_list = _tmp22_;
		_tmp23_ = self->priv->lexer;
		_tmp24_ = lexer_get_next_token (_tmp23_);
		_g_object_unref0 (token);
		token = _tmp24_;
		_tmp25_ = num_token_parsed;
		num_token_parsed = _tmp25_ + 1;
	}
	_tmp26_ = token;
	if (_tmp26_->type == LEXER_TOKEN_TYPE_PL_EOS) {
		while (TRUE) {
			gint _tmp27_;
			Lexer* _tmp28_;
			_tmp27_ = num_token_parsed;
			num_token_parsed = _tmp27_ - 1;
			if (!(_tmp27_ > 0)) {
				break;
			}
			_tmp28_ = self->priv->lexer;
			lexer_roll_back (_tmp28_);
		}
		result = FALSE;
		(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
		_g_free0 (argument_list);
		_g_free0 (function_name);
		_g_object_unref0 (token);
		return result;
	}
	_tmp29_ = self->priv->lexer;
	_tmp30_ = lexer_get_next_token (_tmp29_);
	assign_token = _tmp30_;
	_tmp31_ = num_token_parsed;
	num_token_parsed = _tmp31_ + 1;
	_tmp32_ = assign_token;
	if (_tmp32_->type != LEXER_TOKEN_TYPE_ASSIGN) {
		while (TRUE) {
			gint _tmp33_;
			Lexer* _tmp34_;
			_tmp33_ = num_token_parsed;
			num_token_parsed = _tmp33_ - 1;
			if (!(_tmp33_ > 0)) {
				break;
			}
			_tmp34_ = self->priv->lexer;
			lexer_roll_back (_tmp34_);
		}
		result = FALSE;
		_g_object_unref0 (assign_token);
		(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
		_g_free0 (argument_list);
		_g_free0 (function_name);
		_g_object_unref0 (token);
		return result;
	}
	_tmp35_ = g_strdup ("");
	expression = _tmp35_;
	_tmp36_ = self->priv->lexer;
	_tmp37_ = lexer_get_next_token (_tmp36_);
	_g_object_unref0 (token);
	token = _tmp37_;
	while (TRUE) {
		LexerToken* _tmp38_;
		const gchar* _tmp39_;
		LexerToken* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		Lexer* _tmp43_;
		LexerToken* _tmp44_;
		_tmp38_ = token;
		if (!(_tmp38_->type != LEXER_TOKEN_TYPE_PL_EOS)) {
			break;
		}
		_tmp39_ = expression;
		_tmp40_ = token;
		_tmp41_ = _tmp40_->text;
		_tmp42_ = g_strconcat (_tmp39_, _tmp41_, NULL);
		_g_free0 (expression);
		expression = _tmp42_;
		_tmp43_ = self->priv->lexer;
		_tmp44_ = lexer_get_next_token (_tmp43_);
		_g_object_unref0 (token);
		token = _tmp44_;
	}
	_tmp45_ = function_name;
	_tmp46_ = function_name_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp45_);
	_tmp47_ = _tmp46_;
	parser_insert_into_tree (self, (ParseNode*) _tmp47_);
	_g_object_unref0 (_tmp47_);
	_tmp48_ = function_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_FUNCTION), parser_get_associativity_p (self, PRECEDENCE_FUNCTION), NULL);
	_tmp49_ = _tmp48_;
	parser_insert_into_tree (self, (ParseNode*) _tmp49_);
	_g_object_unref0 (_tmp49_);
	_tmp50_ = token_list;
	_tmp51_ = argument_list;
	_tmp52_ = function_arguments_node_new (self, _tmp50_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp51_);
	_tmp53_ = _tmp52_;
	parser_insert_into_tree (self, (ParseNode*) _tmp53_);
	_g_object_unref0 (_tmp53_);
	_tmp54_ = assign_token;
	_tmp55_ = assign_token;
	_tmp56_ = assign_function_node_new (self, _tmp54_, (guint) 0, parser_get_associativity (self, _tmp55_));
	_tmp57_ = _tmp56_;
	parser_insert_into_tree (self, (ParseNode*) _tmp57_);
	_g_object_unref0 (_tmp57_);
	_tmp58_ = expression;
	_tmp59_ = function_description_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp58_);
	_tmp60_ = _tmp59_;
	parser_insert_into_tree (self, (ParseNode*) _tmp60_);
	_g_object_unref0 (_tmp60_);
	result = TRUE;
	_g_free0 (expression);
	_g_object_unref0 (assign_token);
	(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
	_g_free0 (argument_list);
	_g_free0 (function_name);
	_g_object_unref0 (token);
	return result;
}

static gboolean
parser_conversion (Parser* self)
{
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_->type == LEXER_TOKEN_TYPE_IN) {
		LexerToken* token_in = NULL;
		LexerToken* _tmp3_;
		LexerToken* _tmp4_;
		Lexer* _tmp5_;
		LexerToken* _tmp6_;
		LexerToken* _tmp7_;
		_tmp3_ = token;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		token_in = _tmp4_;
		_tmp5_ = self->priv->lexer;
		_tmp6_ = lexer_get_next_token (_tmp5_);
		_g_object_unref0 (token);
		token = _tmp6_;
		_tmp7_ = token;
		if (_tmp7_->type == LEXER_TOKEN_TYPE_UNIT) {
			LexerToken* token_to = NULL;
			LexerToken* _tmp8_;
			LexerToken* _tmp9_;
			Lexer* _tmp10_;
			LexerToken* _tmp11_;
			LexerToken* _tmp12_;
			_tmp8_ = token;
			_tmp9_ = _g_object_ref0 (_tmp8_);
			token_to = _tmp9_;
			_tmp10_ = self->priv->lexer;
			_tmp11_ = lexer_get_next_token (_tmp10_);
			_g_object_unref0 (token);
			token = _tmp11_;
			_tmp12_ = token;
			if (_tmp12_->type == LEXER_TOKEN_TYPE_PL_EOS) {
				LexerToken* _tmp13_;
				LexerToken* _tmp14_;
				ConvertBaseNode* _tmp15_;
				ConvertBaseNode* _tmp16_;
				LexerToken* _tmp17_;
				LexerToken* _tmp18_;
				NameNode* _tmp19_;
				NameNode* _tmp20_;
				_tmp13_ = token_in;
				_tmp14_ = token_in;
				_tmp15_ = convert_base_node_new (self, _tmp13_, parser_make_precedence_p (self, PRECEDENCE_CONVERT), parser_get_associativity (self, _tmp14_), NULL);
				_tmp16_ = _tmp15_;
				parser_insert_into_tree (self, (ParseNode*) _tmp16_);
				_g_object_unref0 (_tmp16_);
				_tmp17_ = token_to;
				_tmp18_ = token_to;
				_tmp19_ = name_node_new (self, _tmp17_, parser_make_precedence_p (self, PRECEDENCE_UNIT), parser_get_associativity (self, _tmp18_), NULL);
				_tmp20_ = _tmp19_;
				parser_insert_into_tree (self, (ParseNode*) _tmp20_);
				_g_object_unref0 (_tmp20_);
				result = TRUE;
				_g_object_unref0 (token_to);
				_g_object_unref0 (token_in);
				_g_object_unref0 (token);
				return result;
			} else {
				Lexer* _tmp21_;
				Lexer* _tmp22_;
				Lexer* _tmp23_;
				_tmp21_ = self->priv->lexer;
				lexer_roll_back (_tmp21_);
				_tmp22_ = self->priv->lexer;
				lexer_roll_back (_tmp22_);
				_tmp23_ = self->priv->lexer;
				lexer_roll_back (_tmp23_);
				result = FALSE;
				_g_object_unref0 (token_to);
				_g_object_unref0 (token_in);
				_g_object_unref0 (token);
				return result;
			}
			_g_object_unref0 (token_to);
		} else {
			Lexer* _tmp24_;
			Lexer* _tmp25_;
			_tmp24_ = self->priv->lexer;
			lexer_roll_back (_tmp24_);
			_tmp25_ = self->priv->lexer;
			lexer_roll_back (_tmp25_);
			result = FALSE;
			_g_object_unref0 (token_in);
			_g_object_unref0 (token);
			return result;
		}
		_g_object_unref0 (token_in);
	} else {
		gboolean _tmp26_ = FALSE;
		LexerToken* _tmp27_;
		_tmp27_ = token;
		if (_tmp27_->type == LEXER_TOKEN_TYPE_UNIT) {
			_tmp26_ = TRUE;
		} else {
			LexerToken* _tmp28_;
			_tmp28_ = token;
			_tmp26_ = _tmp28_->type == LEXER_TOKEN_TYPE_CURRENCY;
		}
		if (_tmp26_) {
			LexerTokenType first_type = 0;
			LexerToken* _tmp29_;
			LexerToken* token_from = NULL;
			LexerToken* _tmp30_;
			LexerToken* _tmp31_;
			Lexer* _tmp32_;
			LexerToken* _tmp33_;
			LexerToken* _tmp34_;
			_tmp29_ = token;
			first_type = _tmp29_->type;
			_tmp30_ = token;
			_tmp31_ = _g_object_ref0 (_tmp30_);
			token_from = _tmp31_;
			_tmp32_ = self->priv->lexer;
			_tmp33_ = lexer_get_next_token (_tmp32_);
			_g_object_unref0 (token);
			token = _tmp33_;
			_tmp34_ = token;
			if (_tmp34_->type == LEXER_TOKEN_TYPE_IN) {
				LexerToken* token_in = NULL;
				LexerToken* _tmp35_;
				LexerToken* _tmp36_;
				Lexer* _tmp37_;
				LexerToken* _tmp38_;
				gboolean _tmp39_ = FALSE;
				LexerToken* _tmp40_;
				_tmp35_ = token;
				_tmp36_ = _g_object_ref0 (_tmp35_);
				token_in = _tmp36_;
				_tmp37_ = self->priv->lexer;
				_tmp38_ = lexer_get_next_token (_tmp37_);
				_g_object_unref0 (token);
				token = _tmp38_;
				_tmp40_ = token;
				if (_tmp40_->type == LEXER_TOKEN_TYPE_UNIT) {
					_tmp39_ = TRUE;
				} else {
					LexerToken* _tmp41_;
					_tmp41_ = token;
					_tmp39_ = _tmp41_->type == LEXER_TOKEN_TYPE_CURRENCY;
				}
				if (_tmp39_) {
					LexerToken* _tmp42_;
					LexerToken* _tmp43_;
					NameNode* _tmp44_;
					NameNode* _tmp45_;
					LexerToken* _tmp46_;
					LexerToken* _tmp47_;
					ConvertNumberNode* _tmp48_;
					ConvertNumberNode* _tmp49_;
					LexerToken* _tmp50_;
					LexerToken* _tmp51_;
					NameNode* _tmp52_;
					NameNode* _tmp53_;
					_tmp42_ = token_from;
					_tmp43_ = token_from;
					_tmp44_ = name_node_new (self, _tmp42_, parser_make_precedence_p (self, PRECEDENCE_UNIT), parser_get_associativity (self, _tmp43_), NULL);
					_tmp45_ = _tmp44_;
					parser_insert_into_tree (self, (ParseNode*) _tmp45_);
					_g_object_unref0 (_tmp45_);
					_tmp46_ = token_in;
					_tmp47_ = token_in;
					_tmp48_ = convert_number_node_new (self, _tmp46_, parser_make_precedence_p (self, PRECEDENCE_CONVERT), parser_get_associativity (self, _tmp47_));
					_tmp49_ = _tmp48_;
					parser_insert_into_tree (self, (ParseNode*) _tmp49_);
					_g_object_unref0 (_tmp49_);
					_tmp50_ = token;
					_tmp51_ = token;
					_tmp52_ = name_node_new (self, _tmp50_, parser_make_precedence_p (self, PRECEDENCE_UNIT), parser_get_associativity (self, _tmp51_), NULL);
					_tmp53_ = _tmp52_;
					parser_insert_into_tree (self, (ParseNode*) _tmp53_);
					_g_object_unref0 (_tmp53_);
					result = TRUE;
					_g_object_unref0 (token_in);
					_g_object_unref0 (token_from);
					_g_object_unref0 (token);
					return result;
				} else {
					Lexer* _tmp54_;
					Lexer* _tmp55_;
					Lexer* _tmp56_;
					_tmp54_ = self->priv->lexer;
					lexer_roll_back (_tmp54_);
					_tmp55_ = self->priv->lexer;
					lexer_roll_back (_tmp55_);
					_tmp56_ = self->priv->lexer;
					lexer_roll_back (_tmp56_);
					result = FALSE;
					_g_object_unref0 (token_in);
					_g_object_unref0 (token_from);
					_g_object_unref0 (token);
					return result;
				}
				_g_object_unref0 (token_in);
			} else {
				Lexer* _tmp57_;
				Lexer* _tmp58_;
				_tmp57_ = self->priv->lexer;
				lexer_roll_back (_tmp57_);
				_tmp58_ = self->priv->lexer;
				lexer_roll_back (_tmp58_);
				result = FALSE;
				_g_object_unref0 (token_from);
				_g_object_unref0 (token);
				return result;
			}
			_g_object_unref0 (token_from);
		} else {
			Lexer* _tmp59_;
			_tmp59_ = self->priv->lexer;
			lexer_roll_back (_tmp59_);
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
	}
}

static gboolean
parser_expression (Parser* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!parser_expression_1 (self)) {
		result = FALSE;
		return result;
	}
	if (!parser_expression_2 (self)) {
		result = FALSE;
		return result;
	}
	parser_conversion (self);
	result = TRUE;
	return result;
}

static gboolean
parser_expression_1 (Parser* self)
{
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	gboolean _tmp2_ = FALSE;
	LexerToken* _tmp3_;
	LexerToken* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp3_ = token;
	if (_tmp3_->type == LEXER_TOKEN_TYPE_PL_EOS) {
		_tmp2_ = TRUE;
	} else {
		LexerToken* _tmp4_;
		_tmp4_ = token;
		_tmp2_ = _tmp4_->type == LEXER_TOKEN_TYPE_ASSIGN;
	}
	if (_tmp2_) {
		Lexer* _tmp5_;
		_tmp5_ = self->priv->lexer;
		lexer_roll_back (_tmp5_);
		result = FALSE;
		_g_object_unref0 (token);
		return result;
	}
	_tmp6_ = token;
	if (_tmp6_->type == LEXER_TOKEN_TYPE_L_R_BRACKET) {
		guint _tmp7_;
		Lexer* _tmp8_;
		LexerToken* _tmp9_;
		LexerToken* _tmp10_;
		_tmp7_ = self->priv->depth_level;
		self->priv->depth_level = _tmp7_ + 1;
		if (!parser_expression (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		_tmp8_ = self->priv->lexer;
		_tmp9_ = lexer_get_next_token (_tmp8_);
		_g_object_unref0 (token);
		token = _tmp9_;
		_tmp10_ = token;
		if (_tmp10_->type == LEXER_TOKEN_TYPE_R_R_BRACKET) {
			guint _tmp11_;
			Lexer* _tmp12_;
			LexerToken* _tmp13_;
			Lexer* _tmp14_;
			LexerToken* _tmp15_;
			_tmp11_ = self->priv->depth_level;
			self->priv->depth_level = _tmp11_ - 1;
			_tmp12_ = self->priv->lexer;
			_tmp13_ = lexer_get_next_token (_tmp12_);
			_g_object_unref0 (token);
			token = _tmp13_;
			_tmp14_ = self->priv->lexer;
			lexer_roll_back (_tmp14_);
			_tmp15_ = token;
			if (_tmp15_->type == LEXER_TOKEN_TYPE_NUMBER) {
				MultiplyNode* _tmp16_;
				MultiplyNode* _tmp17_;
				_tmp16_ = multiply_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_MULTIPLY), parser_get_associativity_p (self, PRECEDENCE_MULTIPLY));
				_tmp17_ = _tmp16_;
				parser_insert_into_tree (self, (ParseNode*) _tmp17_);
				_g_object_unref0 (_tmp17_);
				if (!parser_expression (self)) {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				} else {
					result = TRUE;
					_g_object_unref0 (token);
					return result;
				}
			} else {
				result = TRUE;
				_g_object_unref0 (token);
				return result;
			}
		} else {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
	} else {
		LexerToken* _tmp18_;
		_tmp18_ = token;
		if (_tmp18_->type == LEXER_TOKEN_TYPE_L_S_BRACKET) {
			guint _tmp19_;
			LexerToken* _tmp20_;
			LexerToken* _tmp21_;
			RoundNode* _tmp22_;
			RoundNode* _tmp23_;
			Lexer* _tmp24_;
			LexerToken* _tmp25_;
			LexerToken* _tmp26_;
			_tmp19_ = self->priv->depth_level;
			self->priv->depth_level = _tmp19_ + 1;
			_tmp20_ = token;
			_tmp21_ = token;
			_tmp22_ = round_node_new (self, _tmp20_, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity (self, _tmp21_));
			_tmp23_ = _tmp22_;
			parser_insert_into_tree_unary (self, (ParseNode*) _tmp23_);
			_g_object_unref0 (_tmp23_);
			if (!parser_expression (self)) {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
			_tmp24_ = self->priv->lexer;
			_tmp25_ = lexer_get_next_token (_tmp24_);
			_g_object_unref0 (token);
			token = _tmp25_;
			_tmp26_ = token;
			if (_tmp26_->type == LEXER_TOKEN_TYPE_R_S_BRACKET) {
				guint _tmp27_;
				_tmp27_ = self->priv->depth_level;
				self->priv->depth_level = _tmp27_ - 1;
				result = TRUE;
				_g_object_unref0 (token);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
		} else {
			LexerToken* _tmp28_;
			_tmp28_ = token;
			if (_tmp28_->type == LEXER_TOKEN_TYPE_L_C_BRACKET) {
				guint _tmp29_;
				LexerToken* _tmp30_;
				LexerToken* _tmp31_;
				FractionalComponentNode* _tmp32_;
				FractionalComponentNode* _tmp33_;
				Lexer* _tmp34_;
				LexerToken* _tmp35_;
				LexerToken* _tmp36_;
				_tmp29_ = self->priv->depth_level;
				self->priv->depth_level = _tmp29_ + 1;
				_tmp30_ = token;
				_tmp31_ = token;
				_tmp32_ = fractional_component_node_new (self, _tmp30_, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity (self, _tmp31_));
				_tmp33_ = _tmp32_;
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp33_);
				_g_object_unref0 (_tmp33_);
				if (!parser_expression (self)) {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				}
				_tmp34_ = self->priv->lexer;
				_tmp35_ = lexer_get_next_token (_tmp34_);
				_g_object_unref0 (token);
				token = _tmp35_;
				_tmp36_ = token;
				if (_tmp36_->type == LEXER_TOKEN_TYPE_R_C_BRACKET) {
					guint _tmp37_;
					_tmp37_ = self->priv->depth_level;
					self->priv->depth_level = _tmp37_ - 1;
					result = TRUE;
					_g_object_unref0 (token);
					return result;
				} else {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				}
			} else {
				LexerToken* _tmp38_;
				_tmp38_ = token;
				if (_tmp38_->type == LEXER_TOKEN_TYPE_ABS) {
					guint _tmp39_;
					LexerToken* _tmp40_;
					LexerToken* _tmp41_;
					AbsoluteValueNode* _tmp42_;
					AbsoluteValueNode* _tmp43_;
					Lexer* _tmp44_;
					LexerToken* _tmp45_;
					LexerToken* _tmp46_;
					_tmp39_ = self->priv->depth_level;
					self->priv->depth_level = _tmp39_ + 1;
					_tmp40_ = token;
					_tmp41_ = token;
					_tmp42_ = absolute_value_node_new (self, _tmp40_, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity (self, _tmp41_));
					_tmp43_ = _tmp42_;
					parser_insert_into_tree_unary (self, (ParseNode*) _tmp43_);
					_g_object_unref0 (_tmp43_);
					if (!parser_expression (self)) {
						result = FALSE;
						_g_object_unref0 (token);
						return result;
					}
					_tmp44_ = self->priv->lexer;
					_tmp45_ = lexer_get_next_token (_tmp44_);
					_g_object_unref0 (token);
					token = _tmp45_;
					_tmp46_ = token;
					if (_tmp46_->type == LEXER_TOKEN_TYPE_ABS) {
						guint _tmp47_;
						_tmp47_ = self->priv->depth_level;
						self->priv->depth_level = _tmp47_ - 1;
						result = TRUE;
						_g_object_unref0 (token);
						return result;
					} else {
						result = FALSE;
						_g_object_unref0 (token);
						return result;
					}
				} else {
					LexerToken* _tmp48_;
					_tmp48_ = token;
					if (_tmp48_->type == LEXER_TOKEN_TYPE_NOT) {
						LexerToken* _tmp49_;
						LexerToken* _tmp50_;
						NotNode* _tmp51_;
						NotNode* _tmp52_;
						_tmp49_ = token;
						_tmp50_ = token;
						_tmp51_ = not_node_new (self, _tmp49_, parser_make_precedence_p (self, PRECEDENCE_NOT), parser_get_associativity (self, _tmp50_));
						_tmp52_ = _tmp51_;
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp52_);
						_g_object_unref0 (_tmp52_);
						if (!parser_expression (self)) {
							result = FALSE;
							_g_object_unref0 (token);
							return result;
						}
						result = TRUE;
						_g_object_unref0 (token);
						return result;
					} else {
						LexerToken* _tmp53_;
						_tmp53_ = token;
						if (_tmp53_->type == LEXER_TOKEN_TYPE_NUMBER) {
							LexerToken* _tmp54_;
							LexerToken* _tmp55_;
							LexerToken* _tmp56_;
							ConstantNode* _tmp57_;
							ConstantNode* _tmp58_;
							Lexer* _tmp59_;
							LexerToken* _tmp60_;
							Lexer* _tmp61_;
							gboolean _tmp62_ = FALSE;
							gboolean _tmp63_ = FALSE;
							gboolean _tmp64_ = FALSE;
							gboolean _tmp65_ = FALSE;
							gboolean _tmp66_ = FALSE;
							LexerToken* _tmp67_;
							_tmp54_ = token;
							_tmp55_ = token;
							_tmp56_ = token;
							_tmp57_ = constant_node_new (self, _tmp54_, parser_make_precedence_t (self, _tmp55_->type), parser_get_associativity (self, _tmp56_));
							_tmp58_ = _tmp57_;
							parser_insert_into_tree (self, (ParseNode*) _tmp58_);
							_g_object_unref0 (_tmp58_);
							_tmp59_ = self->priv->lexer;
							_tmp60_ = lexer_get_next_token (_tmp59_);
							_g_object_unref0 (token);
							token = _tmp60_;
							_tmp61_ = self->priv->lexer;
							lexer_roll_back (_tmp61_);
							_tmp67_ = token;
							if (_tmp67_->type == LEXER_TOKEN_TYPE_FUNCTION) {
								_tmp66_ = TRUE;
							} else {
								LexerToken* _tmp68_;
								_tmp68_ = token;
								_tmp66_ = _tmp68_->type == LEXER_TOKEN_TYPE_VARIABLE;
							}
							if (_tmp66_) {
								_tmp65_ = TRUE;
							} else {
								LexerToken* _tmp69_;
								_tmp69_ = token;
								_tmp65_ = _tmp69_->type == LEXER_TOKEN_TYPE_SUB_NUMBER;
							}
							if (_tmp65_) {
								_tmp64_ = TRUE;
							} else {
								LexerToken* _tmp70_;
								_tmp70_ = token;
								_tmp64_ = _tmp70_->type == LEXER_TOKEN_TYPE_ROOT;
							}
							if (_tmp64_) {
								_tmp63_ = TRUE;
							} else {
								LexerToken* _tmp71_;
								_tmp71_ = token;
								_tmp63_ = _tmp71_->type == LEXER_TOKEN_TYPE_ROOT_3;
							}
							if (_tmp63_) {
								_tmp62_ = TRUE;
							} else {
								LexerToken* _tmp72_;
								_tmp72_ = token;
								_tmp62_ = _tmp72_->type == LEXER_TOKEN_TYPE_ROOT_4;
							}
							if (_tmp62_) {
								MultiplyNode* _tmp73_;
								MultiplyNode* _tmp74_;
								_tmp73_ = multiply_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_MULTIPLY), parser_get_associativity_p (self, PRECEDENCE_MULTIPLY));
								_tmp74_ = _tmp73_;
								parser_insert_into_tree (self, (ParseNode*) _tmp74_);
								_g_object_unref0 (_tmp74_);
								if (!parser_variable (self)) {
									result = FALSE;
									_g_object_unref0 (token);
									return result;
								} else {
									result = TRUE;
									_g_object_unref0 (token);
									return result;
								}
							} else {
								result = TRUE;
								_g_object_unref0 (token);
								return result;
							}
						} else {
							LexerToken* _tmp75_;
							_tmp75_ = token;
							if (_tmp75_->type == LEXER_TOKEN_TYPE_L_FLOOR) {
								guint _tmp76_;
								FloorNode* _tmp77_;
								FloorNode* _tmp78_;
								Lexer* _tmp79_;
								LexerToken* _tmp80_;
								LexerToken* _tmp81_;
								_tmp76_ = self->priv->depth_level;
								self->priv->depth_level = _tmp76_ + 1;
								_tmp77_ = floor_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity_p (self, PRECEDENCE_TOP));
								_tmp78_ = _tmp77_;
								parser_insert_into_tree_unary (self, (ParseNode*) _tmp78_);
								_g_object_unref0 (_tmp78_);
								if (!parser_expression (self)) {
									result = FALSE;
									_g_object_unref0 (token);
									return result;
								}
								_tmp79_ = self->priv->lexer;
								_tmp80_ = lexer_get_next_token (_tmp79_);
								_g_object_unref0 (token);
								token = _tmp80_;
								_tmp81_ = token;
								if (_tmp81_->type == LEXER_TOKEN_TYPE_R_FLOOR) {
									guint _tmp82_;
									_tmp82_ = self->priv->depth_level;
									self->priv->depth_level = _tmp82_ - 1;
									result = TRUE;
									_g_object_unref0 (token);
									return result;
								} else {
									result = FALSE;
									_g_object_unref0 (token);
									return result;
								}
							} else {
								LexerToken* _tmp83_;
								_tmp83_ = token;
								if (_tmp83_->type == LEXER_TOKEN_TYPE_L_CEILING) {
									guint _tmp84_;
									CeilingNode* _tmp85_;
									CeilingNode* _tmp86_;
									Lexer* _tmp87_;
									LexerToken* _tmp88_;
									LexerToken* _tmp89_;
									_tmp84_ = self->priv->depth_level;
									self->priv->depth_level = _tmp84_ + 1;
									_tmp85_ = ceiling_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_TOP), parser_get_associativity_p (self, PRECEDENCE_TOP));
									_tmp86_ = _tmp85_;
									parser_insert_into_tree_unary (self, (ParseNode*) _tmp86_);
									_g_object_unref0 (_tmp86_);
									if (!parser_expression (self)) {
										result = FALSE;
										_g_object_unref0 (token);
										return result;
									}
									_tmp87_ = self->priv->lexer;
									_tmp88_ = lexer_get_next_token (_tmp87_);
									_g_object_unref0 (token);
									token = _tmp88_;
									_tmp89_ = token;
									if (_tmp89_->type == LEXER_TOKEN_TYPE_R_CEILING) {
										guint _tmp90_;
										_tmp90_ = self->priv->depth_level;
										self->priv->depth_level = _tmp90_ - 1;
										result = TRUE;
										_g_object_unref0 (token);
										return result;
									} else {
										result = FALSE;
										_g_object_unref0 (token);
										return result;
									}
								} else {
									LexerToken* _tmp91_;
									_tmp91_ = token;
									if (_tmp91_->type == LEXER_TOKEN_TYPE_SUBTRACT) {
										LexerToken* _tmp92_;
										UnaryMinusNode* _tmp93_;
										UnaryMinusNode* _tmp94_;
										_tmp92_ = token;
										_tmp93_ = unary_minus_node_new (self, _tmp92_, parser_make_precedence_p (self, PRECEDENCE_UNARY_MINUS), parser_get_associativity_p (self, PRECEDENCE_UNARY_MINUS));
										_tmp94_ = _tmp93_;
										parser_insert_into_tree_unary (self, (ParseNode*) _tmp94_);
										_g_object_unref0 (_tmp94_);
										if (!parser_expression_1 (self)) {
											result = FALSE;
											_g_object_unref0 (token);
											return result;
										}
										result = TRUE;
										_g_object_unref0 (token);
										return result;
									} else {
										LexerToken* _tmp95_;
										_tmp95_ = token;
										if (_tmp95_->type == LEXER_TOKEN_TYPE_ADD) {
											Lexer* _tmp96_;
											LexerToken* _tmp97_;
											LexerToken* _tmp98_;
											_tmp96_ = self->priv->lexer;
											_tmp97_ = lexer_get_next_token (_tmp96_);
											_g_object_unref0 (token);
											token = _tmp97_;
											_tmp98_ = token;
											if (_tmp98_->type == LEXER_TOKEN_TYPE_NUMBER) {
												LexerToken* _tmp99_;
												LexerToken* _tmp100_;
												LexerToken* _tmp101_;
												ConstantNode* _tmp102_;
												ConstantNode* _tmp103_;
												_tmp99_ = token;
												_tmp100_ = token;
												_tmp101_ = token;
												_tmp102_ = constant_node_new (self, _tmp99_, parser_make_precedence_t (self, _tmp100_->type), parser_get_associativity (self, _tmp101_));
												_tmp103_ = _tmp102_;
												parser_insert_into_tree (self, (ParseNode*) _tmp103_);
												_g_object_unref0 (_tmp103_);
												result = TRUE;
												_g_object_unref0 (token);
												return result;
											} else {
												result = FALSE;
												_g_object_unref0 (token);
												return result;
											}
										} else {
											Lexer* _tmp104_;
											_tmp104_ = self->priv->lexer;
											lexer_roll_back (_tmp104_);
											if (!parser_variable (self)) {
												result = FALSE;
												_g_object_unref0 (token);
												return result;
											} else {
												result = TRUE;
												_g_object_unref0 (token);
												return result;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

static gboolean
parser_expression_2 (Parser* self)
{
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_->type == LEXER_TOKEN_TYPE_L_R_BRACKET) {
		MultiplyNode* _tmp3_;
		MultiplyNode* _tmp4_;
		guint _tmp5_;
		Lexer* _tmp6_;
		LexerToken* _tmp7_;
		LexerToken* _tmp8_;
		_tmp3_ = multiply_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_MULTIPLY), parser_get_associativity_p (self, PRECEDENCE_MULTIPLY));
		_tmp4_ = _tmp3_;
		parser_insert_into_tree (self, (ParseNode*) _tmp4_);
		_g_object_unref0 (_tmp4_);
		_tmp5_ = self->priv->depth_level;
		self->priv->depth_level = _tmp5_ + 1;
		if (!parser_expression (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		_tmp6_ = self->priv->lexer;
		_tmp7_ = lexer_get_next_token (_tmp6_);
		_g_object_unref0 (token);
		token = _tmp7_;
		_tmp8_ = token;
		if (_tmp8_->type == LEXER_TOKEN_TYPE_R_R_BRACKET) {
			guint _tmp9_;
			_tmp9_ = self->priv->depth_level;
			self->priv->depth_level = _tmp9_ - 1;
			if (!parser_expression_2 (self)) {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
			result = TRUE;
			_g_object_unref0 (token);
			return result;
		} else {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
	} else {
		LexerToken* _tmp10_;
		_tmp10_ = token;
		if (_tmp10_->type == LEXER_TOKEN_TYPE_POWER) {
			LexerToken* _tmp11_;
			LexerToken* _tmp12_;
			LexerToken* _tmp13_;
			XPowYNode* _tmp14_;
			XPowYNode* _tmp15_;
			_tmp11_ = token;
			_tmp12_ = token;
			_tmp13_ = token;
			_tmp14_ = xpow_ynode_new (self, _tmp11_, parser_make_precedence_t (self, _tmp12_->type), parser_get_associativity (self, _tmp13_));
			_tmp15_ = _tmp14_;
			parser_insert_into_tree (self, (ParseNode*) _tmp15_);
			_g_object_unref0 (_tmp15_);
			if (!parser_expression_1 (self)) {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
			if (!parser_expression_2 (self)) {
				result = FALSE;
				_g_object_unref0 (token);
				return result;
			}
			result = TRUE;
			_g_object_unref0 (token);
			return result;
		} else {
			LexerToken* _tmp16_;
			_tmp16_ = token;
			if (_tmp16_->type == LEXER_TOKEN_TYPE_SUP_NUMBER) {
				XPowYIntegerNode* _tmp17_;
				XPowYIntegerNode* _tmp18_;
				LexerToken* _tmp19_;
				NameNode* _tmp20_;
				NameNode* _tmp21_;
				_tmp17_ = xpow_yinteger_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_POWER), parser_get_associativity_p (self, PRECEDENCE_POWER));
				_tmp18_ = _tmp17_;
				parser_insert_into_tree (self, (ParseNode*) _tmp18_);
				_g_object_unref0 (_tmp18_);
				_tmp19_ = token;
				_tmp20_ = name_node_new (self, _tmp19_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), NULL);
				_tmp21_ = _tmp20_;
				parser_insert_into_tree (self, (ParseNode*) _tmp21_);
				_g_object_unref0 (_tmp21_);
				if (!parser_expression_2 (self)) {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				}
				result = TRUE;
				_g_object_unref0 (token);
				return result;
			} else {
				LexerToken* _tmp22_;
				_tmp22_ = token;
				if (_tmp22_->type == LEXER_TOKEN_TYPE_NSUP_NUMBER) {
					XPowYIntegerNode* _tmp23_;
					XPowYIntegerNode* _tmp24_;
					LexerToken* _tmp25_;
					NameNode* _tmp26_;
					NameNode* _tmp27_;
					_tmp23_ = xpow_yinteger_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_POWER), parser_get_associativity_p (self, PRECEDENCE_POWER));
					_tmp24_ = _tmp23_;
					parser_insert_into_tree (self, (ParseNode*) _tmp24_);
					_g_object_unref0 (_tmp24_);
					_tmp25_ = token;
					_tmp26_ = name_node_new (self, _tmp25_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), NULL);
					_tmp27_ = _tmp26_;
					parser_insert_into_tree (self, (ParseNode*) _tmp27_);
					_g_object_unref0 (_tmp27_);
					if (!parser_expression_2 (self)) {
						result = FALSE;
						_g_object_unref0 (token);
						return result;
					}
					result = TRUE;
					_g_object_unref0 (token);
					return result;
				} else {
					LexerToken* _tmp28_;
					_tmp28_ = token;
					if (_tmp28_->type == LEXER_TOKEN_TYPE_FACTORIAL) {
						LexerToken* _tmp29_;
						LexerToken* _tmp30_;
						LexerToken* _tmp31_;
						FactorialNode* _tmp32_;
						FactorialNode* _tmp33_;
						_tmp29_ = token;
						_tmp30_ = token;
						_tmp31_ = token;
						_tmp32_ = factorial_node_new (self, _tmp29_, parser_make_precedence_t (self, _tmp30_->type), parser_get_associativity (self, _tmp31_));
						_tmp33_ = _tmp32_;
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp33_);
						_g_object_unref0 (_tmp33_);
						if (!parser_expression_2 (self)) {
							result = FALSE;
							_g_object_unref0 (token);
							return result;
						}
						result = TRUE;
						_g_object_unref0 (token);
						return result;
					} else {
						LexerToken* _tmp34_;
						_tmp34_ = token;
						if (_tmp34_->type == LEXER_TOKEN_TYPE_MULTIPLY) {
							LexerToken* _tmp35_;
							LexerToken* _tmp36_;
							LexerToken* _tmp37_;
							MultiplyNode* _tmp38_;
							MultiplyNode* _tmp39_;
							_tmp35_ = token;
							_tmp36_ = token;
							_tmp37_ = token;
							_tmp38_ = multiply_node_new (self, _tmp35_, parser_make_precedence_t (self, _tmp36_->type), parser_get_associativity (self, _tmp37_));
							_tmp39_ = _tmp38_;
							parser_insert_into_tree (self, (ParseNode*) _tmp39_);
							_g_object_unref0 (_tmp39_);
							if (!parser_expression_1 (self)) {
								result = FALSE;
								_g_object_unref0 (token);
								return result;
							}
							if (!parser_expression_2 (self)) {
								result = FALSE;
								_g_object_unref0 (token);
								return result;
							}
							result = TRUE;
							_g_object_unref0 (token);
							return result;
						} else {
							LexerToken* _tmp40_;
							_tmp40_ = token;
							if (_tmp40_->type == LEXER_TOKEN_TYPE_PERCENTAGE) {
								LexerToken* _tmp41_;
								LexerToken* _tmp42_;
								LexerToken* _tmp43_;
								PercentNode* _tmp44_;
								PercentNode* _tmp45_;
								_tmp41_ = token;
								_tmp42_ = token;
								_tmp43_ = token;
								_tmp44_ = percent_node_new (self, _tmp41_, parser_make_precedence_t (self, _tmp42_->type), parser_get_associativity (self, _tmp43_));
								_tmp45_ = _tmp44_;
								parser_insert_into_tree_unary (self, (ParseNode*) _tmp45_);
								_g_object_unref0 (_tmp45_);
								if (!parser_expression_2 (self)) {
									result = FALSE;
									_g_object_unref0 (token);
									return result;
								}
								result = TRUE;
								_g_object_unref0 (token);
								return result;
							} else {
								LexerToken* _tmp46_;
								_tmp46_ = token;
								if (_tmp46_->type == LEXER_TOKEN_TYPE_AND) {
									LexerToken* _tmp47_;
									LexerToken* _tmp48_;
									LexerToken* _tmp49_;
									AndNode* _tmp50_;
									AndNode* _tmp51_;
									_tmp47_ = token;
									_tmp48_ = token;
									_tmp49_ = token;
									_tmp50_ = and_node_new (self, _tmp47_, parser_make_precedence_t (self, _tmp48_->type), parser_get_associativity (self, _tmp49_));
									_tmp51_ = _tmp50_;
									parser_insert_into_tree (self, (ParseNode*) _tmp51_);
									_g_object_unref0 (_tmp51_);
									if (!parser_expression_1 (self)) {
										result = FALSE;
										_g_object_unref0 (token);
										return result;
									}
									if (!parser_expression_2 (self)) {
										result = FALSE;
										_g_object_unref0 (token);
										return result;
									}
									result = TRUE;
									_g_object_unref0 (token);
									return result;
								} else {
									LexerToken* _tmp52_;
									_tmp52_ = token;
									if (_tmp52_->type == LEXER_TOKEN_TYPE_NAND) {
										LexerToken* _tmp53_;
										LexerToken* _tmp54_;
										LexerToken* _tmp55_;
										NandNode* _tmp56_;
										NandNode* _tmp57_;
										_tmp53_ = token;
										_tmp54_ = token;
										_tmp55_ = token;
										_tmp56_ = nand_node_new (self, _tmp53_, parser_make_precedence_t (self, _tmp54_->type), parser_get_associativity (self, _tmp55_));
										_tmp57_ = _tmp56_;
										parser_insert_into_tree (self, (ParseNode*) _tmp57_);
										_g_object_unref0 (_tmp57_);
										if (!parser_expression_1 (self)) {
											result = FALSE;
											_g_object_unref0 (token);
											return result;
										}
										if (!parser_expression_2 (self)) {
											result = FALSE;
											_g_object_unref0 (token);
											return result;
										}
										result = TRUE;
										_g_object_unref0 (token);
										return result;
									} else {
										LexerToken* _tmp58_;
										_tmp58_ = token;
										if (_tmp58_->type == LEXER_TOKEN_TYPE_OR) {
											LexerToken* _tmp59_;
											LexerToken* _tmp60_;
											LexerToken* _tmp61_;
											OrNode* _tmp62_;
											OrNode* _tmp63_;
											_tmp59_ = token;
											_tmp60_ = token;
											_tmp61_ = token;
											_tmp62_ = or_node_new (self, _tmp59_, parser_make_precedence_t (self, _tmp60_->type), parser_get_associativity (self, _tmp61_));
											_tmp63_ = _tmp62_;
											parser_insert_into_tree (self, (ParseNode*) _tmp63_);
											_g_object_unref0 (_tmp63_);
											if (!parser_expression_1 (self)) {
												result = FALSE;
												_g_object_unref0 (token);
												return result;
											}
											if (!parser_expression_2 (self)) {
												result = FALSE;
												_g_object_unref0 (token);
												return result;
											}
											result = TRUE;
											_g_object_unref0 (token);
											return result;
										} else {
											LexerToken* _tmp64_;
											_tmp64_ = token;
											if (_tmp64_->type == LEXER_TOKEN_TYPE_NOR) {
												LexerToken* _tmp65_;
												LexerToken* _tmp66_;
												LexerToken* _tmp67_;
												NorNode* _tmp68_;
												NorNode* _tmp69_;
												_tmp65_ = token;
												_tmp66_ = token;
												_tmp67_ = token;
												_tmp68_ = nor_node_new (self, _tmp65_, parser_make_precedence_t (self, _tmp66_->type), parser_get_associativity (self, _tmp67_));
												_tmp69_ = _tmp68_;
												parser_insert_into_tree (self, (ParseNode*) _tmp69_);
												_g_object_unref0 (_tmp69_);
												if (!parser_expression_1 (self)) {
													result = FALSE;
													_g_object_unref0 (token);
													return result;
												}
												if (!parser_expression_2 (self)) {
													result = FALSE;
													_g_object_unref0 (token);
													return result;
												}
												result = TRUE;
												_g_object_unref0 (token);
												return result;
											} else {
												LexerToken* _tmp70_;
												_tmp70_ = token;
												if (_tmp70_->type == LEXER_TOKEN_TYPE_XOR) {
													LexerToken* _tmp71_;
													LexerToken* _tmp72_;
													LexerToken* _tmp73_;
													XorNode* _tmp74_;
													XorNode* _tmp75_;
													_tmp71_ = token;
													_tmp72_ = token;
													_tmp73_ = token;
													_tmp74_ = xor_node_new (self, _tmp71_, parser_make_precedence_t (self, _tmp72_->type), parser_get_associativity (self, _tmp73_));
													_tmp75_ = _tmp74_;
													parser_insert_into_tree (self, (ParseNode*) _tmp75_);
													_g_object_unref0 (_tmp75_);
													if (!parser_expression_1 (self)) {
														result = FALSE;
														_g_object_unref0 (token);
														return result;
													}
													if (!parser_expression_2 (self)) {
														result = FALSE;
														_g_object_unref0 (token);
														return result;
													}
													result = TRUE;
													_g_object_unref0 (token);
													return result;
												} else {
													LexerToken* _tmp76_;
													_tmp76_ = token;
													if (_tmp76_->type == LEXER_TOKEN_TYPE_XNOR) {
														LexerToken* _tmp77_;
														LexerToken* _tmp78_;
														LexerToken* _tmp79_;
														XnorNode* _tmp80_;
														XnorNode* _tmp81_;
														_tmp77_ = token;
														_tmp78_ = token;
														_tmp79_ = token;
														_tmp80_ = xnor_node_new (self, _tmp77_, parser_make_precedence_t (self, _tmp78_->type), parser_get_associativity (self, _tmp79_));
														_tmp81_ = _tmp80_;
														parser_insert_into_tree (self, (ParseNode*) _tmp81_);
														_g_object_unref0 (_tmp81_);
														if (!parser_expression_1 (self)) {
															result = FALSE;
															_g_object_unref0 (token);
															return result;
														}
														if (!parser_expression_2 (self)) {
															result = FALSE;
															_g_object_unref0 (token);
															return result;
														}
														result = TRUE;
														_g_object_unref0 (token);
														return result;
													} else {
														LexerToken* _tmp82_;
														_tmp82_ = token;
														if (_tmp82_->type == LEXER_TOKEN_TYPE_DIVIDE) {
															LexerToken* _tmp83_;
															LexerToken* _tmp84_;
															LexerToken* _tmp85_;
															DivideNode* _tmp86_;
															DivideNode* _tmp87_;
															_tmp83_ = token;
															_tmp84_ = token;
															_tmp85_ = token;
															_tmp86_ = divide_node_new (self, _tmp83_, parser_make_precedence_t (self, _tmp84_->type), parser_get_associativity (self, _tmp85_));
															_tmp87_ = _tmp86_;
															parser_insert_into_tree (self, (ParseNode*) _tmp87_);
															_g_object_unref0 (_tmp87_);
															if (!parser_expression_1 (self)) {
																result = FALSE;
																_g_object_unref0 (token);
																return result;
															}
															if (!parser_expression_2 (self)) {
																result = FALSE;
																_g_object_unref0 (token);
																return result;
															}
															result = TRUE;
															_g_object_unref0 (token);
															return result;
														} else {
															gboolean _tmp88_ = FALSE;
															gboolean _tmp89_ = FALSE;
															LexerToken* _tmp90_;
															_tmp90_ = token;
															if (_tmp90_->type == LEXER_TOKEN_TYPE_SHIFT_LEFT) {
																_tmp89_ = TRUE;
															} else {
																LexerToken* _tmp91_;
																_tmp91_ = token;
																_tmp89_ = _tmp91_->type == LEXER_TOKEN_TYPE_SHIFT_RIGHT;
															}
															if (_tmp89_) {
																_tmp88_ = TRUE;
															} else {
																LexerToken* _tmp92_;
																_tmp92_ = token;
																_tmp88_ = _tmp92_->type == LEXER_TOKEN_TYPE_SHIFT_URIGHT;
															}
															if (_tmp88_) {
																LexerToken* _tmp93_;
																LexerToken* _tmp94_;
																LexerToken* _tmp95_;
																ShiftNode* _tmp96_;
																ShiftNode* _tmp97_;
																_tmp93_ = token;
																_tmp94_ = token;
																_tmp95_ = token;
																_tmp96_ = shift_node_new (self, _tmp93_, parser_make_precedence_t (self, _tmp94_->type), parser_get_associativity (self, _tmp95_));
																_tmp97_ = _tmp96_;
																parser_insert_into_tree (self, (ParseNode*) _tmp97_);
																_g_object_unref0 (_tmp97_);
																if (!parser_expression_1 (self)) {
																	result = FALSE;
																	_g_object_unref0 (token);
																	return result;
																}
																if (!parser_expression_2 (self)) {
																	result = FALSE;
																	_g_object_unref0 (token);
																	return result;
																}
																result = TRUE;
																_g_object_unref0 (token);
																return result;
															} else {
																LexerToken* _tmp98_;
																_tmp98_ = token;
																if (_tmp98_->type == LEXER_TOKEN_TYPE_MOD) {
																	LexerToken* _tmp99_;
																	LexerToken* _tmp100_;
																	LexerToken* _tmp101_;
																	ModulusDivideNode* _tmp102_;
																	ModulusDivideNode* _tmp103_;
																	_tmp99_ = token;
																	_tmp100_ = token;
																	_tmp101_ = token;
																	_tmp102_ = modulus_divide_node_new (self, _tmp99_, parser_make_precedence_t (self, _tmp100_->type), parser_get_associativity (self, _tmp101_));
																	_tmp103_ = _tmp102_;
																	parser_insert_into_tree (self, (ParseNode*) _tmp103_);
																	_g_object_unref0 (_tmp103_);
																	if (!parser_expression_1 (self)) {
																		result = FALSE;
																		_g_object_unref0 (token);
																		return result;
																	}
																	if (!parser_expression_2 (self)) {
																		result = FALSE;
																		_g_object_unref0 (token);
																		return result;
																	}
																	result = TRUE;
																	_g_object_unref0 (token);
																	return result;
																} else {
																	LexerToken* _tmp104_;
																	_tmp104_ = token;
																	if (_tmp104_->type == LEXER_TOKEN_TYPE_ADD) {
																		AddNode* node = NULL;
																		LexerToken* _tmp105_;
																		LexerToken* _tmp106_;
																		LexerToken* _tmp107_;
																		AddNode* _tmp108_;
																		AddNode* _tmp109_;
																		Lexer* _tmp110_;
																		LexerToken* _tmp111_;
																		LexerToken* _tmp112_;
																		_tmp105_ = token;
																		_tmp106_ = token;
																		_tmp107_ = token;
																		_tmp108_ = add_node_new (self, _tmp105_, parser_make_precedence_t (self, _tmp106_->type), parser_get_associativity (self, _tmp107_));
																		node = _tmp108_;
																		_tmp109_ = node;
																		parser_insert_into_tree (self, (ParseNode*) _tmp109_);
																		if (!parser_expression_1 (self)) {
																			result = FALSE;
																			_g_object_unref0 (node);
																			_g_object_unref0 (token);
																			return result;
																		}
																		_tmp110_ = self->priv->lexer;
																		_tmp111_ = lexer_get_next_token (_tmp110_);
																		_g_object_unref0 (token);
																		token = _tmp111_;
																		_tmp112_ = token;
																		if (_tmp112_->type == LEXER_TOKEN_TYPE_PERCENTAGE) {
																			AddNode* _tmp113_;
																			ParseNode* _tmp114_;
																			_tmp113_ = node;
																			_tmp114_ = ((ParseNode*) _tmp113_)->right;
																			if (_tmp114_->precedence > ((guint) PRECEDENCE_PERCENTAGE)) {
																				LexerToken* next_token = NULL;
																				Lexer* _tmp115_;
																				LexerToken* _tmp116_;
																				Lexer* _tmp117_;
																				gboolean _tmp118_ = FALSE;
																				gboolean _tmp119_ = FALSE;
																				LexerToken* _tmp120_;
																				const gchar* _tmp121_;
																				AddNode* _tmp126_;
																				AddNode* _tmp127_;
																				_tmp115_ = self->priv->lexer;
																				_tmp116_ = lexer_get_next_token (_tmp115_);
																				next_token = _tmp116_;
																				_tmp117_ = self->priv->lexer;
																				lexer_roll_back (_tmp117_);
																				_tmp120_ = next_token;
																				_tmp121_ = _tmp120_->text;
																				if (g_strcmp0 (_tmp121_, "") != 0) {
																					LexerToken* _tmp122_;
																					const gchar* _tmp123_;
																					_tmp122_ = next_token;
																					_tmp123_ = _tmp122_->text;
																					_tmp119_ = g_strcmp0 (_tmp123_, "=") != 0;
																				} else {
																					_tmp119_ = FALSE;
																				}
																				if (_tmp119_) {
																					LexerToken* _tmp124_;
																					_tmp124_ = next_token;
																					_tmp118_ = parser_get_precedence (self, _tmp124_->type) < PRECEDENCE_PERCENTAGE;
																				} else {
																					_tmp118_ = FALSE;
																				}
																				if (_tmp118_) {
																					Lexer* _tmp125_;
																					_tmp125_ = self->priv->lexer;
																					lexer_roll_back (_tmp125_);
																					if (!parser_expression_2 (self)) {
																						result = TRUE;
																						_g_object_unref0 (next_token);
																						_g_object_unref0 (node);
																						_g_object_unref0 (token);
																						return result;
																					}
																				}
																				_tmp126_ = node;
																				((ParseNode*) _tmp126_)->precedence = parser_make_precedence_p (self, PRECEDENCE_PERCENTAGE);
																				_tmp127_ = node;
																				_tmp127_->do_percentage = TRUE;
																				result = TRUE;
																				_g_object_unref0 (next_token);
																				_g_object_unref0 (node);
																				_g_object_unref0 (token);
																				return result;
																			} else {
																				Lexer* _tmp128_;
																				_tmp128_ = self->priv->lexer;
																				lexer_roll_back (_tmp128_);
																				if (!parser_expression_2 (self)) {
																					result = TRUE;
																					_g_object_unref0 (node);
																					_g_object_unref0 (token);
																					return result;
																				}
																			}
																		} else {
																			Lexer* _tmp129_;
																			_tmp129_ = self->priv->lexer;
																			lexer_roll_back (_tmp129_);
																		}
																		if (!parser_expression_2 (self)) {
																			result = FALSE;
																			_g_object_unref0 (node);
																			_g_object_unref0 (token);
																			return result;
																		}
																		result = TRUE;
																		_g_object_unref0 (node);
																		_g_object_unref0 (token);
																		return result;
																	} else {
																		LexerToken* _tmp130_;
																		_tmp130_ = token;
																		if (_tmp130_->type == LEXER_TOKEN_TYPE_SUBTRACT) {
																			SubtractNode* node = NULL;
																			LexerToken* _tmp131_;
																			LexerToken* _tmp132_;
																			LexerToken* _tmp133_;
																			SubtractNode* _tmp134_;
																			SubtractNode* _tmp135_;
																			Lexer* _tmp136_;
																			LexerToken* _tmp137_;
																			LexerToken* _tmp138_;
																			_tmp131_ = token;
																			_tmp132_ = token;
																			_tmp133_ = token;
																			_tmp134_ = subtract_node_new (self, _tmp131_, parser_make_precedence_t (self, _tmp132_->type), parser_get_associativity (self, _tmp133_));
																			node = _tmp134_;
																			_tmp135_ = node;
																			parser_insert_into_tree (self, (ParseNode*) _tmp135_);
																			if (!parser_expression_1 (self)) {
																				result = FALSE;
																				_g_object_unref0 (node);
																				_g_object_unref0 (token);
																				return result;
																			}
																			_tmp136_ = self->priv->lexer;
																			_tmp137_ = lexer_get_next_token (_tmp136_);
																			_g_object_unref0 (token);
																			token = _tmp137_;
																			_tmp138_ = token;
																			if (_tmp138_->type == LEXER_TOKEN_TYPE_PERCENTAGE) {
																				SubtractNode* _tmp139_;
																				ParseNode* _tmp140_;
																				_tmp139_ = node;
																				_tmp140_ = ((ParseNode*) _tmp139_)->right;
																				if (_tmp140_->precedence > ((guint) PRECEDENCE_PERCENTAGE)) {
																					LexerToken* next_token = NULL;
																					Lexer* _tmp141_;
																					LexerToken* _tmp142_;
																					Lexer* _tmp143_;
																					gboolean _tmp144_ = FALSE;
																					gboolean _tmp145_ = FALSE;
																					LexerToken* _tmp146_;
																					const gchar* _tmp147_;
																					SubtractNode* _tmp152_;
																					SubtractNode* _tmp153_;
																					_tmp141_ = self->priv->lexer;
																					_tmp142_ = lexer_get_next_token (_tmp141_);
																					next_token = _tmp142_;
																					_tmp143_ = self->priv->lexer;
																					lexer_roll_back (_tmp143_);
																					_tmp146_ = next_token;
																					_tmp147_ = _tmp146_->text;
																					if (g_strcmp0 (_tmp147_, "") != 0) {
																						LexerToken* _tmp148_;
																						const gchar* _tmp149_;
																						_tmp148_ = next_token;
																						_tmp149_ = _tmp148_->text;
																						_tmp145_ = g_strcmp0 (_tmp149_, "=") != 0;
																					} else {
																						_tmp145_ = FALSE;
																					}
																					if (_tmp145_) {
																						LexerToken* _tmp150_;
																						_tmp150_ = next_token;
																						_tmp144_ = parser_get_precedence (self, _tmp150_->type) < PRECEDENCE_PERCENTAGE;
																					} else {
																						_tmp144_ = FALSE;
																					}
																					if (_tmp144_) {
																						Lexer* _tmp151_;
																						_tmp151_ = self->priv->lexer;
																						lexer_roll_back (_tmp151_);
																						if (!parser_expression_2 (self)) {
																							result = TRUE;
																							_g_object_unref0 (next_token);
																							_g_object_unref0 (node);
																							_g_object_unref0 (token);
																							return result;
																						}
																					}
																					_tmp152_ = node;
																					((ParseNode*) _tmp152_)->precedence = parser_make_precedence_p (self, PRECEDENCE_PERCENTAGE);
																					_tmp153_ = node;
																					_tmp153_->do_percentage = TRUE;
																					result = TRUE;
																					_g_object_unref0 (next_token);
																					_g_object_unref0 (node);
																					_g_object_unref0 (token);
																					return result;
																				} else {
																					Lexer* _tmp154_;
																					_tmp154_ = self->priv->lexer;
																					lexer_roll_back (_tmp154_);
																					if (!parser_expression_2 (self)) {
																						result = TRUE;
																						_g_object_unref0 (node);
																						_g_object_unref0 (token);
																						return result;
																					}
																				}
																			} else {
																				Lexer* _tmp155_;
																				_tmp155_ = self->priv->lexer;
																				lexer_roll_back (_tmp155_);
																			}
																			if (!parser_expression_2 (self)) {
																				result = FALSE;
																				_g_object_unref0 (node);
																				_g_object_unref0 (token);
																				return result;
																			}
																			result = TRUE;
																			_g_object_unref0 (node);
																			_g_object_unref0 (token);
																			return result;
																		} else {
																			Lexer* _tmp156_;
																			_tmp156_ = self->priv->lexer;
																			lexer_roll_back (_tmp156_);
																			result = TRUE;
																			_g_object_unref0 (token);
																			return result;
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

static gboolean
parser_variable (Parser* self)
{
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	gboolean _tmp2_ = FALSE;
	LexerToken* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp3_ = token;
	if (_tmp3_->type == LEXER_TOKEN_TYPE_FUNCTION) {
		_tmp2_ = TRUE;
	} else {
		LexerToken* _tmp4_;
		_tmp4_ = token;
		_tmp2_ = _tmp4_->type == LEXER_TOKEN_TYPE_MOD;
	}
	if (_tmp2_) {
		Lexer* _tmp5_;
		_tmp5_ = self->priv->lexer;
		lexer_roll_back (_tmp5_);
		if (!parser_function_invocation (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	} else {
		gboolean _tmp6_ = FALSE;
		LexerToken* _tmp7_;
		_tmp7_ = token;
		if (_tmp7_->type == LEXER_TOKEN_TYPE_SUB_NUMBER) {
			_tmp6_ = TRUE;
		} else {
			LexerToken* _tmp8_;
			_tmp8_ = token;
			_tmp6_ = _tmp8_->type == LEXER_TOKEN_TYPE_SUP_NUMBER;
		}
		if (_tmp6_) {
			LexerToken* token_old = NULL;
			LexerToken* _tmp9_;
			LexerToken* _tmp10_;
			Lexer* _tmp11_;
			LexerToken* _tmp12_;
			LexerToken* _tmp13_;
			_tmp9_ = token;
			_tmp10_ = _g_object_ref0 (_tmp9_);
			token_old = _tmp10_;
			_tmp11_ = self->priv->lexer;
			_tmp12_ = lexer_get_next_token (_tmp11_);
			_g_object_unref0 (token);
			token = _tmp12_;
			_tmp13_ = token;
			if (_tmp13_->type == LEXER_TOKEN_TYPE_ROOT) {
				LexerToken* _tmp14_;
				LexerToken* _tmp15_;
				LexerToken* _tmp16_;
				LexerToken* _tmp17_;
				RootNode* _tmp18_;
				RootNode* _tmp19_;
				_tmp14_ = token;
				_tmp15_ = token;
				_tmp16_ = token;
				_tmp17_ = token_old;
				_tmp18_ = root_node_new_WithToken (self, _tmp14_, parser_make_precedence_t (self, _tmp15_->type), parser_get_associativity (self, _tmp16_), _tmp17_);
				_tmp19_ = _tmp18_;
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp19_);
				_g_object_unref0 (_tmp19_);
				if (!parser_expression (self)) {
					result = FALSE;
					_g_object_unref0 (token_old);
					_g_object_unref0 (token);
					return result;
				}
				result = TRUE;
				_g_object_unref0 (token_old);
				_g_object_unref0 (token);
				return result;
			} else {
				result = FALSE;
				_g_object_unref0 (token_old);
				_g_object_unref0 (token);
				return result;
			}
			_g_object_unref0 (token_old);
		} else {
			LexerToken* _tmp20_;
			_tmp20_ = token;
			if (_tmp20_->type == LEXER_TOKEN_TYPE_ROOT) {
				LexerToken* _tmp21_;
				LexerToken* _tmp22_;
				LexerToken* _tmp23_;
				RootNode* _tmp24_;
				RootNode* _tmp25_;
				_tmp21_ = token;
				_tmp22_ = token;
				_tmp23_ = token;
				_tmp24_ = root_node_new (self, _tmp21_, parser_make_precedence_t (self, _tmp22_->type), parser_get_associativity (self, _tmp23_), 2);
				_tmp25_ = _tmp24_;
				parser_insert_into_tree_unary (self, (ParseNode*) _tmp25_);
				_g_object_unref0 (_tmp25_);
				if (!parser_expression (self)) {
					result = FALSE;
					_g_object_unref0 (token);
					return result;
				}
				result = TRUE;
				_g_object_unref0 (token);
				return result;
			} else {
				LexerToken* _tmp26_;
				_tmp26_ = token;
				if (_tmp26_->type == LEXER_TOKEN_TYPE_ROOT_3) {
					LexerToken* _tmp27_;
					LexerToken* _tmp28_;
					LexerToken* _tmp29_;
					RootNode* _tmp30_;
					RootNode* _tmp31_;
					_tmp27_ = token;
					_tmp28_ = token;
					_tmp29_ = token;
					_tmp30_ = root_node_new (self, _tmp27_, parser_make_precedence_t (self, _tmp28_->type), parser_get_associativity (self, _tmp29_), 3);
					_tmp31_ = _tmp30_;
					parser_insert_into_tree_unary (self, (ParseNode*) _tmp31_);
					_g_object_unref0 (_tmp31_);
					if (!parser_expression (self)) {
						result = FALSE;
						_g_object_unref0 (token);
						return result;
					}
					result = TRUE;
					_g_object_unref0 (token);
					return result;
				} else {
					LexerToken* _tmp32_;
					_tmp32_ = token;
					if (_tmp32_->type == LEXER_TOKEN_TYPE_ROOT_4) {
						LexerToken* _tmp33_;
						LexerToken* _tmp34_;
						LexerToken* _tmp35_;
						RootNode* _tmp36_;
						RootNode* _tmp37_;
						_tmp33_ = token;
						_tmp34_ = token;
						_tmp35_ = token;
						_tmp36_ = root_node_new (self, _tmp33_, parser_make_precedence_t (self, _tmp34_->type), parser_get_associativity (self, _tmp35_), 4);
						_tmp37_ = _tmp36_;
						parser_insert_into_tree_unary (self, (ParseNode*) _tmp37_);
						_g_object_unref0 (_tmp37_);
						if (!parser_expression (self)) {
							result = FALSE;
							_g_object_unref0 (token);
							return result;
						}
						result = TRUE;
						_g_object_unref0 (token);
						return result;
					} else {
						LexerToken* _tmp38_;
						_tmp38_ = token;
						if (_tmp38_->type == LEXER_TOKEN_TYPE_VARIABLE) {
							Lexer* _tmp39_;
							_tmp39_ = self->priv->lexer;
							lexer_roll_back (_tmp39_);
							if (!parser_term (self)) {
								result = FALSE;
								_g_object_unref0 (token);
								return result;
							}
							result = TRUE;
							_g_object_unref0 (token);
							return result;
						} else {
							result = FALSE;
							_g_object_unref0 (token);
							return result;
						}
					}
				}
			}
		}
	}
}

static gboolean
parser_function_invocation (Parser* self)
{
	guint _tmp0_;
	gint num_token_parsed = 0;
	LexerToken* fun_token = NULL;
	Lexer* _tmp1_;
	LexerToken* _tmp2_;
	gint _tmp3_;
	gchar* function_name = NULL;
	LexerToken* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	LexerToken* _tmp7_;
	const gchar* _tmp8_;
	FunctionNameNode* _tmp9_;
	FunctionNameNode* _tmp10_;
	LexerToken* token = NULL;
	Lexer* _tmp11_;
	LexerToken* _tmp12_;
	gint _tmp13_;
	gchar* power = NULL;
	gchar* log_base = NULL;
	gboolean _tmp14_ = FALSE;
	LexerToken* _tmp15_;
	LexerToken* _tmp23_;
	LexerToken* _tmp24_;
	LexerToken* _tmp25_;
	const gchar* _tmp26_;
	FunctionNode* _tmp27_;
	FunctionNode* _tmp28_;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_;
	LexerToken* _tmp41_;
	guint _tmp96_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->depth_level;
	self->priv->depth_level = _tmp0_ + 1;
	num_token_parsed = 0;
	_tmp1_ = self->priv->lexer;
	_tmp2_ = lexer_get_next_token (_tmp1_);
	fun_token = _tmp2_;
	_tmp3_ = num_token_parsed;
	num_token_parsed = _tmp3_ + 1;
	_tmp4_ = fun_token;
	_tmp5_ = _tmp4_->text;
	_tmp6_ = g_strdup (_tmp5_);
	function_name = _tmp6_;
	_tmp7_ = fun_token;
	_tmp8_ = function_name;
	_tmp9_ = function_name_node_new (self, _tmp7_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp8_);
	_tmp10_ = _tmp9_;
	parser_insert_into_tree (self, (ParseNode*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = self->priv->lexer;
	_tmp12_ = lexer_get_next_token (_tmp11_);
	token = _tmp12_;
	_tmp13_ = num_token_parsed;
	num_token_parsed = _tmp13_ + 1;
	power = NULL;
	log_base = NULL;
	_tmp15_ = token;
	if (_tmp15_->type == LEXER_TOKEN_TYPE_SUP_NUMBER) {
		_tmp14_ = TRUE;
	} else {
		LexerToken* _tmp16_;
		_tmp16_ = token;
		_tmp14_ = _tmp16_->type == LEXER_TOKEN_TYPE_NSUP_NUMBER;
	}
	if (_tmp14_) {
		LexerToken* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		Lexer* _tmp20_;
		LexerToken* _tmp21_;
		gint _tmp22_;
		_tmp17_ = token;
		_tmp18_ = _tmp17_->text;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (power);
		power = _tmp19_;
		_tmp20_ = self->priv->lexer;
		_tmp21_ = lexer_get_next_token (_tmp20_);
		_g_object_unref0 (token);
		token = _tmp21_;
		_tmp22_ = num_token_parsed;
		num_token_parsed = _tmp22_ + 1;
	}
	_tmp23_ = fun_token;
	_tmp24_ = fun_token;
	_tmp25_ = fun_token;
	_tmp26_ = power;
	_tmp27_ = function_node_new (self, _tmp23_, parser_make_precedence_t (self, _tmp24_->type), parser_get_associativity (self, _tmp25_), _tmp26_);
	_tmp28_ = _tmp27_;
	parser_insert_into_tree (self, (ParseNode*) _tmp28_);
	_g_object_unref0 (_tmp28_);
	_tmp30_ = function_name;
	_tmp31_ = g_utf8_strdown (_tmp30_, (gssize) -1);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_strcmp0 (_tmp32_, "log") == 0;
	_g_free0 (_tmp32_);
	if (_tmp33_) {
		LexerToken* _tmp34_;
		_tmp34_ = token;
		_tmp29_ = _tmp34_->type == LEXER_TOKEN_TYPE_NUMBER;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		LexerToken* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		Lexer* _tmp38_;
		LexerToken* _tmp39_;
		gint _tmp40_;
		_tmp35_ = token;
		_tmp36_ = _tmp35_->text;
		_tmp37_ = g_strdup (_tmp36_);
		_g_free0 (log_base);
		log_base = _tmp37_;
		_tmp38_ = self->priv->lexer;
		_tmp39_ = lexer_get_next_token (_tmp38_);
		_g_object_unref0 (token);
		token = _tmp39_;
		_tmp40_ = num_token_parsed;
		num_token_parsed = _tmp40_ + 1;
	}
	_tmp41_ = token;
	if (_tmp41_->type == LEXER_TOKEN_TYPE_L_R_BRACKET) {
		Lexer* _tmp42_;
		LexerToken* _tmp43_;
		gint _tmp44_;
		gint m_depth = 0;
		gchar* argument_list = NULL;
		gchar* _tmp45_;
		GList* token_list = NULL;
		LexerToken* _tmp72_;
		GList* _tmp76_;
		const gchar* _tmp77_;
		FunctionArgumentsNode* _tmp78_;
		FunctionArgumentsNode* _tmp79_;
		_tmp42_ = self->priv->lexer;
		_tmp43_ = lexer_get_next_token (_tmp42_);
		_g_object_unref0 (token);
		token = _tmp43_;
		_tmp44_ = num_token_parsed;
		num_token_parsed = _tmp44_ + 1;
		m_depth = 1;
		_tmp45_ = g_strdup ("");
		argument_list = _tmp45_;
		token_list = NULL;
		while (TRUE) {
			gboolean _tmp46_ = FALSE;
			LexerToken* _tmp47_;
			LexerToken* _tmp49_;
			const gchar* _tmp63_;
			LexerToken* _tmp64_;
			const gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			Lexer* _tmp69_;
			LexerToken* _tmp70_;
			gint _tmp71_;
			_tmp47_ = token;
			if (_tmp47_->type != LEXER_TOKEN_TYPE_PL_EOS) {
				LexerToken* _tmp48_;
				_tmp48_ = token;
				_tmp46_ = _tmp48_->type != LEXER_TOKEN_TYPE_ASSIGN;
			} else {
				_tmp46_ = FALSE;
			}
			if (!_tmp46_) {
				break;
			}
			_tmp49_ = token;
			if (_tmp49_->type == LEXER_TOKEN_TYPE_L_R_BRACKET) {
				gint _tmp50_;
				_tmp50_ = m_depth;
				m_depth = _tmp50_ + 1;
			} else {
				LexerToken* _tmp51_;
				_tmp51_ = token;
				if (_tmp51_->type == LEXER_TOKEN_TYPE_R_R_BRACKET) {
					gint _tmp52_;
					gboolean _tmp53_ = FALSE;
					const gchar* _tmp54_;
					_tmp52_ = m_depth;
					m_depth = _tmp52_ - 1;
					_tmp54_ = log_base;
					if (_tmp54_ != NULL) {
						const gchar* _tmp55_;
						_tmp55_ = argument_list;
						_tmp53_ = g_strcmp0 (_tmp55_, "") != 0;
					} else {
						_tmp53_ = FALSE;
					}
					if (_tmp53_) {
						const gchar* _tmp56_;
						const gchar* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						gchar* _tmp60_;
						_tmp56_ = argument_list;
						_tmp57_ = log_base;
						_tmp58_ = g_strconcat (";", _tmp57_, NULL);
						_tmp59_ = _tmp58_;
						_tmp60_ = g_strconcat (_tmp56_, _tmp59_, NULL);
						_g_free0 (argument_list);
						argument_list = _tmp60_;
						_g_free0 (_tmp59_);
					}
					if (m_depth == 0) {
						break;
					}
				} else {
					LexerToken* _tmp61_;
					LexerToken* _tmp62_;
					_tmp61_ = token;
					_tmp62_ = _g_object_ref0 (_tmp61_);
					token_list = g_list_append (token_list, _tmp62_);
				}
			}
			_tmp63_ = argument_list;
			_tmp64_ = token;
			_tmp65_ = _tmp64_->text;
			_tmp66_ = g_strconcat (" ", _tmp65_, NULL);
			_tmp67_ = _tmp66_;
			_tmp68_ = g_strconcat (_tmp63_, _tmp67_, NULL);
			_g_free0 (argument_list);
			argument_list = _tmp68_;
			_g_free0 (_tmp67_);
			_tmp69_ = self->priv->lexer;
			_tmp70_ = lexer_get_next_token (_tmp69_);
			_g_object_unref0 (token);
			token = _tmp70_;
			_tmp71_ = num_token_parsed;
			num_token_parsed = _tmp71_ + 1;
		}
		_tmp72_ = token;
		if (_tmp72_->type != LEXER_TOKEN_TYPE_R_R_BRACKET) {
			guint _tmp75_;
			while (TRUE) {
				gint _tmp73_;
				Lexer* _tmp74_;
				_tmp73_ = num_token_parsed;
				num_token_parsed = _tmp73_ - 1;
				if (!(_tmp73_ > 0)) {
					break;
				}
				_tmp74_ = self->priv->lexer;
				lexer_roll_back (_tmp74_);
			}
			_tmp75_ = self->priv->depth_level;
			self->priv->depth_level = _tmp75_ - 1;
			result = FALSE;
			(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
			_g_free0 (argument_list);
			_g_free0 (log_base);
			_g_free0 (power);
			_g_object_unref0 (token);
			_g_free0 (function_name);
			_g_object_unref0 (fun_token);
			return result;
		}
		_tmp76_ = token_list;
		_tmp77_ = argument_list;
		_tmp78_ = function_arguments_node_new (self, _tmp76_, parser_make_precedence_p (self, PRECEDENCE_NUMBER_VARIABLE), parser_get_associativity_p (self, PRECEDENCE_NUMBER_VARIABLE), _tmp77_);
		_tmp79_ = _tmp78_;
		parser_insert_into_tree (self, (ParseNode*) _tmp79_);
		_g_object_unref0 (_tmp79_);
		(token_list == NULL) ? NULL : (token_list = (_g_list_free__g_object_unref0_ (token_list), NULL));
		_g_free0 (argument_list);
	} else {
		Lexer* _tmp80_;
		const gchar* _tmp81_;
		Lexer* _tmp85_;
		LexerToken* _tmp86_;
		LexerToken* _tmp87_;
		guint _tmp94_;
		_tmp80_ = self->priv->lexer;
		lexer_roll_back (_tmp80_);
		_tmp81_ = log_base;
		if (_tmp81_ != NULL) {
			Lexer* _tmp82_;
			_tmp82_ = self->priv->lexer;
			lexer_roll_back (_tmp82_);
		}
		if (!parser_expression_1 (self)) {
			Lexer* _tmp83_;
			guint _tmp84_;
			_tmp83_ = self->priv->lexer;
			lexer_roll_back (_tmp83_);
			_tmp84_ = self->priv->depth_level;
			self->priv->depth_level = _tmp84_ - 1;
			result = FALSE;
			_g_free0 (log_base);
			_g_free0 (power);
			_g_object_unref0 (token);
			_g_free0 (function_name);
			_g_object_unref0 (fun_token);
			return result;
		}
		_tmp85_ = self->priv->lexer;
		_tmp86_ = lexer_get_next_token (_tmp85_);
		_g_object_unref0 (token);
		token = _tmp86_;
		_tmp87_ = token;
		if (_tmp87_->type == LEXER_TOKEN_TYPE_FACTORIAL) {
			LexerToken* _tmp88_;
			LexerToken* _tmp89_;
			LexerToken* _tmp90_;
			FactorialNode* _tmp91_;
			FactorialNode* _tmp92_;
			_tmp88_ = token;
			_tmp89_ = token;
			_tmp90_ = token;
			_tmp91_ = factorial_node_new (self, _tmp88_, parser_make_precedence_t (self, _tmp89_->type), parser_get_associativity (self, _tmp90_));
			_tmp92_ = _tmp91_;
			parser_insert_into_tree_unary (self, (ParseNode*) _tmp92_);
			_g_object_unref0 (_tmp92_);
		} else {
			Lexer* _tmp93_;
			_tmp93_ = self->priv->lexer;
			lexer_roll_back (_tmp93_);
		}
		_tmp94_ = self->priv->depth_level;
		self->priv->depth_level = _tmp94_ - 1;
		if (!parser_expression_2 (self)) {
			Lexer* _tmp95_;
			_tmp95_ = self->priv->lexer;
			lexer_roll_back (_tmp95_);
			result = FALSE;
			_g_free0 (log_base);
			_g_free0 (power);
			_g_object_unref0 (token);
			_g_free0 (function_name);
			_g_object_unref0 (fun_token);
			return result;
		}
		result = TRUE;
		_g_free0 (log_base);
		_g_free0 (power);
		_g_object_unref0 (token);
		_g_free0 (function_name);
		_g_object_unref0 (fun_token);
		return result;
	}
	_tmp96_ = self->priv->depth_level;
	self->priv->depth_level = _tmp96_ - 1;
	result = TRUE;
	_g_free0 (log_base);
	_g_free0 (power);
	_g_object_unref0 (token);
	_g_free0 (function_name);
	_g_object_unref0 (fun_token);
	return result;
}

static gboolean
parser_term (Parser* self)
{
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	LexerToken* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_->type == LEXER_TOKEN_TYPE_VARIABLE) {
		LexerToken* token_old = NULL;
		LexerToken* _tmp3_;
		LexerToken* _tmp4_;
		Lexer* _tmp5_;
		LexerToken* _tmp6_;
		LexerToken* _tmp7_;
		const gchar* _tmp8_;
		LexerToken* _tmp19_;
		_tmp3_ = token;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		token_old = _tmp4_;
		_tmp5_ = self->priv->lexer;
		_tmp6_ = lexer_get_next_token (_tmp5_);
		_g_object_unref0 (token);
		token = _tmp6_;
		_tmp7_ = token_old;
		_tmp8_ = _tmp7_->text;
		if (!parser_check_variable (self, _tmp8_)) {
			LexerToken* _tmp9_;
			const gchar* _tmp10_;
			_tmp9_ = token;
			_tmp10_ = _tmp9_->text;
			if (g_strcmp0 (_tmp10_, "(") == 0) {
				LexerToken* _tmp11_;
				const gchar* _tmp12_;
				LexerToken* _tmp13_;
				LexerToken* _tmp14_;
				_tmp11_ = token_old;
				_tmp12_ = _tmp11_->text;
				_tmp13_ = token_old;
				_tmp14_ = token_old;
				parser_set_error (self, ERROR_CODE_UNKNOWN_FUNCTION, _tmp12_, _tmp13_->start_index, _tmp14_->end_index);
			} else {
				LexerToken* _tmp15_;
				const gchar* _tmp16_;
				LexerToken* _tmp17_;
				LexerToken* _tmp18_;
				_tmp15_ = token_old;
				_tmp16_ = _tmp15_->text;
				_tmp17_ = token_old;
				_tmp18_ = token_old;
				parser_set_error (self, ERROR_CODE_UNKNOWN_VARIABLE, _tmp16_, _tmp17_->start_index, _tmp18_->end_index);
			}
			result = FALSE;
			_g_object_unref0 (token_old);
			_g_object_unref0 (token);
			return result;
		}
		_tmp19_ = token;
		if (_tmp19_->type == LEXER_TOKEN_TYPE_SUP_NUMBER) {
			LexerToken* _tmp20_;
			LexerToken* _tmp21_;
			LexerToken* _tmp22_;
			LexerToken* _tmp23_;
			const gchar* _tmp24_;
			VariableWithPowerNode* _tmp25_;
			VariableWithPowerNode* _tmp26_;
			_tmp20_ = token_old;
			_tmp21_ = token_old;
			_tmp22_ = token_old;
			_tmp23_ = token;
			_tmp24_ = _tmp23_->text;
			_tmp25_ = variable_with_power_node_new (self, _tmp20_, parser_make_precedence_t (self, _tmp21_->type), parser_get_associativity (self, _tmp22_), _tmp24_);
			_tmp26_ = _tmp25_;
			parser_insert_into_tree (self, (ParseNode*) _tmp26_);
			_g_object_unref0 (_tmp26_);
		} else {
			Lexer* _tmp27_;
			LexerToken* _tmp28_;
			LexerToken* _tmp29_;
			LexerToken* _tmp30_;
			VariableNode* _tmp31_;
			VariableNode* _tmp32_;
			_tmp27_ = self->priv->lexer;
			lexer_roll_back (_tmp27_);
			_tmp28_ = token_old;
			_tmp29_ = token_old;
			_tmp30_ = token_old;
			_tmp31_ = variable_node_new (self, _tmp28_, parser_make_precedence_t (self, _tmp29_->type), parser_get_associativity (self, _tmp30_));
			_tmp32_ = _tmp31_;
			parser_insert_into_tree (self, (ParseNode*) _tmp32_);
			_g_object_unref0 (_tmp32_);
		}
		if (!parser_term_2 (self)) {
			result = FALSE;
			_g_object_unref0 (token_old);
			_g_object_unref0 (token);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (token_old);
		_g_object_unref0 (token);
		return result;
	} else {
		result = FALSE;
		_g_object_unref0 (token);
		return result;
	}
}

static gboolean
parser_term_2 (Parser* self)
{
	LexerToken* token = NULL;
	Lexer* _tmp0_;
	LexerToken* _tmp1_;
	Lexer* _tmp2_;
	gboolean _tmp3_ = FALSE;
	LexerToken* _tmp4_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	LexerToken* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lexer;
	_tmp1_ = lexer_get_next_token (_tmp0_);
	token = _tmp1_;
	_tmp2_ = self->priv->lexer;
	lexer_roll_back (_tmp2_);
	_tmp4_ = token;
	if (_tmp4_->type == LEXER_TOKEN_TYPE_PL_EOS) {
		_tmp3_ = TRUE;
	} else {
		LexerToken* _tmp5_;
		_tmp5_ = token;
		_tmp3_ = _tmp5_->type == LEXER_TOKEN_TYPE_ASSIGN;
	}
	if (_tmp3_) {
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	}
	_tmp11_ = token;
	if (_tmp11_->type == LEXER_TOKEN_TYPE_FUNCTION) {
		_tmp10_ = TRUE;
	} else {
		LexerToken* _tmp12_;
		_tmp12_ = token;
		_tmp10_ = _tmp12_->type == LEXER_TOKEN_TYPE_VARIABLE;
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		LexerToken* _tmp13_;
		_tmp13_ = token;
		_tmp9_ = _tmp13_->type == LEXER_TOKEN_TYPE_SUB_NUMBER;
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		LexerToken* _tmp14_;
		_tmp14_ = token;
		_tmp8_ = _tmp14_->type == LEXER_TOKEN_TYPE_ROOT;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		LexerToken* _tmp15_;
		_tmp15_ = token;
		_tmp7_ = _tmp15_->type == LEXER_TOKEN_TYPE_ROOT_3;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		LexerToken* _tmp16_;
		_tmp16_ = token;
		_tmp6_ = _tmp16_->type == LEXER_TOKEN_TYPE_ROOT_4;
	}
	if (_tmp6_) {
		MultiplyNode* _tmp17_;
		MultiplyNode* _tmp18_;
		_tmp17_ = multiply_node_new (self, NULL, parser_make_precedence_p (self, PRECEDENCE_MULTIPLY), parser_get_associativity_p (self, PRECEDENCE_MULTIPLY));
		_tmp18_ = _tmp17_;
		parser_insert_into_tree (self, (ParseNode*) _tmp18_);
		_g_object_unref0 (_tmp18_);
		if (!parser_variable (self)) {
			result = FALSE;
			_g_object_unref0 (token);
			return result;
		}
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	} else {
		result = TRUE;
		_g_object_unref0 (token);
		return result;
	}
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
value_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		parser_unref (value->data[0].v_pointer);
	}
}

static void
value_parser_copy_value (const GValue* src_value,
                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_parser_collect_value (GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		Parser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_parser_lcopy_value (const GValue* value,
                          guint n_collect_values,
                          GTypeCValue* collect_values,
                          guint collect_flags)
{
	Parser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_parser (const gchar* name,
                   const gchar* nick,
                   const gchar* blurb,
                   GType object_type,
                   GParamFlags flags)
{
	ParamSpecParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_parser (GValue* value,
                  gpointer v_object)
{
	Parser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		parser_unref (old);
	}
}

void
value_take_parser (GValue* value,
                   gpointer v_object)
{
	Parser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		parser_unref (old);
	}
}

static void
parser_class_init (ParserClass * klass,
                   gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	Number* _tmp3_;
	Constant _tmp4_ = {0};
	gchar* _tmp5_;
	gchar* _tmp6_;
	Number* _tmp7_;
	Constant _tmp8_ = {0};
	gchar* _tmp9_;
	gchar* _tmp10_;
	Number* _tmp11_;
	Constant _tmp12_ = {0};
	gchar* _tmp13_;
	gchar* _tmp14_;
	Number* _tmp15_;
	Number* _tmp16_;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* _tmp19_;
	Number* _tmp20_;
	Number* _tmp21_;
	Number* _tmp22_;
	Number* _tmp23_;
	Constant _tmp24_ = {0};
	Constant* _tmp25_;
	ConstantCategory _tmp26_ = {0};
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	Number* _tmp30_;
	Constant _tmp31_ = {0};
	gchar* _tmp32_;
	gchar* _tmp33_;
	Number* _tmp34_;
	Constant _tmp35_ = {0};
	gchar* _tmp36_;
	gchar* _tmp37_;
	Number* _tmp38_;
	Constant _tmp39_ = {0};
	gchar* _tmp40_;
	gchar* _tmp41_;
	Number* _tmp42_;
	Constant _tmp43_ = {0};
	gchar* _tmp44_;
	gchar* _tmp45_;
	Number* _tmp46_;
	Constant _tmp47_ = {0};
	Constant* _tmp48_;
	ConstantCategory _tmp49_ = {0};
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	Number* _tmp53_;
	Constant _tmp54_ = {0};
	gchar* _tmp55_;
	gchar* _tmp56_;
	Number* _tmp57_;
	Constant _tmp58_ = {0};
	gchar* _tmp59_;
	gchar* _tmp60_;
	Number* _tmp61_;
	Constant _tmp62_ = {0};
	gchar* _tmp63_;
	gchar* _tmp64_;
	Number* _tmp65_;
	Constant _tmp66_ = {0};
	Constant* _tmp67_;
	ConstantCategory _tmp68_ = {0};
	gchar* _tmp69_;
	gchar* _tmp70_;
	gchar* _tmp71_;
	Number* _tmp72_;
	Constant _tmp73_ = {0};
	gchar* _tmp74_;
	gchar* _tmp75_;
	Number* _tmp76_;
	Constant _tmp77_ = {0};
	gchar* _tmp78_;
	gchar* _tmp79_;
	Number* _tmp80_;
	Constant _tmp81_ = {0};
	gchar* _tmp82_;
	gchar* _tmp83_;
	Number* _tmp84_;
	Constant _tmp85_ = {0};
	gchar* _tmp86_;
	gchar* _tmp87_;
	Number* _tmp88_;
	Constant _tmp89_ = {0};
	Constant* _tmp90_;
	ConstantCategory _tmp91_ = {0};
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	Number* _tmp95_;
	Constant _tmp96_ = {0};
	gchar* _tmp97_;
	gchar* _tmp98_;
	Number* _tmp99_;
	Constant _tmp100_ = {0};
	Constant* _tmp101_;
	ConstantCategory _tmp102_ = {0};
	ConstantCategory* _tmp103_;
	GHashFunc _tmp104_;
	GEqualFunc _tmp105_;
	GHashTable* _tmp106_;
	GHashTable* _tmp107_;
	gchar* _tmp108_;
	Number* _tmp109_;
	GHashTable* _tmp110_;
	gchar* _tmp111_;
	Number* _tmp112_;
	GHashTable* _tmp113_;
	gchar* _tmp114_;
	Number* _tmp115_;
	ConstantCategory* _tmp116_;
	gint _tmp116__length1;
	parser_parent_class = g_type_class_peek_parent (klass);
	((ParserClass *) klass)->finalize = parser_finalize;
	g_type_class_adjust_private_offset (klass, &Parser_private_offset);
	((ParserClass *) klass)->variable_is_defined = (gboolean (*) (Parser*, const gchar*)) parser_real_variable_is_defined;
	((ParserClass *) klass)->get_variable = (Number* (*) (Parser*, const gchar*)) parser_real_get_variable;
	((ParserClass *) klass)->set_variable = (void (*) (Parser*, const gchar*, Number*)) parser_real_set_variable;
	((ParserClass *) klass)->function_is_defined = (gboolean (*) (Parser*, const gchar*)) parser_real_function_is_defined;
	((ParserClass *) klass)->unit_is_defined = (gboolean (*) (Parser*, const gchar*)) parser_real_unit_is_defined;
	((ParserClass *) klass)->currency_is_defined = (gboolean (*) (Parser*, const gchar*)) parser_real_currency_is_defined;
	((ParserClass *) klass)->currency_has_rate = (gboolean (*) (Parser*, const gchar*)) parser_real_currency_has_rate;
	((ParserClass *) klass)->literal_base_is_defined = (gboolean (*) (Parser*, const gchar*)) parser_real_literal_base_is_defined;
	((ParserClass *) klass)->convert = (Number* (*) (Parser*, Number*, const gchar*, const gchar*, Unit**, Unit**)) parser_real_convert;
	_tmp0_ = g_strdup (_ ("Mathematics"));
	_tmp1_ = g_strdup (_ ("Euler’s Number"));
	_tmp2_ = g_strdup ("e");
	_tmp3_ = number_new_eulers ();
	memset (&_tmp4_, 0, sizeof (Constant));
	_g_free0 (_tmp4_.name);
	_tmp4_.name = _tmp1_;
	_g_free0 (_tmp4_.symbol);
	_tmp4_.symbol = _tmp2_;
	_g_object_unref0 (_tmp4_.number);
	_tmp4_.number = _tmp3_;
	_tmp5_ = g_strdup (_ ("Pi"));
	_tmp6_ = g_strdup ("π");
	_tmp7_ = number_new_pi ();
	memset (&_tmp8_, 0, sizeof (Constant));
	_g_free0 (_tmp8_.name);
	_tmp8_.name = _tmp5_;
	_g_free0 (_tmp8_.symbol);
	_tmp8_.symbol = _tmp6_;
	_g_object_unref0 (_tmp8_.number);
	_tmp8_.number = _tmp7_;
	_tmp9_ = g_strdup (_ ("Tau"));
	_tmp10_ = g_strdup ("τ");
	_tmp11_ = number_new_tau ();
	memset (&_tmp12_, 0, sizeof (Constant));
	_g_free0 (_tmp12_.name);
	_tmp12_.name = _tmp9_;
	_g_free0 (_tmp12_.symbol);
	_tmp12_.symbol = _tmp10_;
	_g_object_unref0 (_tmp12_.number);
	_tmp12_.number = _tmp11_;
	_tmp13_ = g_strdup (_ ("Golden Ratio"));
	_tmp14_ = g_strdup ("φ");
	_tmp15_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp16_ = _tmp15_;
	_tmp17_ = number_new_integer ((gint64) 5, (gint64) 0);
	_tmp18_ = _tmp17_;
	_tmp19_ = number_sqrt (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = number_add (_tmp16_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = number_divide_integer (_tmp22_, (gint64) 2);
	memset (&_tmp24_, 0, sizeof (Constant));
	_g_free0 (_tmp24_.name);
	_tmp24_.name = _tmp13_;
	_g_free0 (_tmp24_.symbol);
	_tmp24_.symbol = _tmp14_;
	_g_object_unref0 (_tmp24_.number);
	_tmp24_.number = _tmp23_;
	_tmp25_ = g_new0 (Constant, 4);
	_tmp25_[0] = _tmp4_;
	_tmp25_[1] = _tmp8_;
	_tmp25_[2] = _tmp12_;
	_tmp25_[3] = _tmp24_;
	memset (&_tmp26_, 0, sizeof (ConstantCategory));
	_g_free0 (_tmp26_.name);
	_tmp26_.name = _tmp0_;
	_tmp26_.constants = (_vala_Constant_array_free (_tmp26_.constants, _tmp26_.constants_length1), NULL);
	_tmp26_.constants = _tmp25_;
	_tmp26_.constants_length1 = 4;
	_tmp27_ = g_strdup (_ ("Electromagnetism"));
	_tmp28_ = g_strdup (_ ("Light Speed"));
	_tmp29_ = g_strdup ("c₀");
	_tmp30_ = number_new_integer ((gint64) 299792458, (gint64) 0);
	memset (&_tmp31_, 0, sizeof (Constant));
	_g_free0 (_tmp31_.name);
	_tmp31_.name = _tmp28_;
	_g_free0 (_tmp31_.symbol);
	_tmp31_.symbol = _tmp29_;
	_g_object_unref0 (_tmp31_.number);
	_tmp31_.number = _tmp30_;
	_tmp32_ = g_strdup (_ ("Elementary Charge"));
	_tmp33_ = g_strdup ("е");
	_tmp34_ = mp_set_from_string ("0.0000000000000000001602176634", 10, TRUE);
	memset (&_tmp35_, 0, sizeof (Constant));
	_g_free0 (_tmp35_.name);
	_tmp35_.name = _tmp32_;
	_g_free0 (_tmp35_.symbol);
	_tmp35_.symbol = _tmp33_;
	_g_object_unref0 (_tmp35_.number);
	_tmp35_.number = _tmp34_;
	_tmp36_ = g_strdup (_ ("Impedance of Vacuum"));
	_tmp37_ = g_strdup ("Z₀");
	_tmp38_ = mp_set_from_string ("376.730313412", 10, TRUE);
	memset (&_tmp39_, 0, sizeof (Constant));
	_g_free0 (_tmp39_.name);
	_tmp39_.name = _tmp36_;
	_g_free0 (_tmp39_.symbol);
	_tmp39_.symbol = _tmp37_;
	_g_object_unref0 (_tmp39_.number);
	_tmp39_.number = _tmp38_;
	_tmp40_ = g_strdup (_ ("Permeability of Vacuum"));
	_tmp41_ = g_strdup ("μ₀");
	_tmp42_ = mp_set_from_string ("0.00000125663706127", 10, TRUE);
	memset (&_tmp43_, 0, sizeof (Constant));
	_g_free0 (_tmp43_.name);
	_tmp43_.name = _tmp40_;
	_g_free0 (_tmp43_.symbol);
	_tmp43_.symbol = _tmp41_;
	_g_object_unref0 (_tmp43_.number);
	_tmp43_.number = _tmp42_;
	_tmp44_ = g_strdup (_ ("Permittivity of Vacuum"));
	_tmp45_ = g_strdup ("ε₀");
	_tmp46_ = mp_set_from_string ("0.0000000000088541878188", 10, TRUE);
	memset (&_tmp47_, 0, sizeof (Constant));
	_g_free0 (_tmp47_.name);
	_tmp47_.name = _tmp44_;
	_g_free0 (_tmp47_.symbol);
	_tmp47_.symbol = _tmp45_;
	_g_object_unref0 (_tmp47_.number);
	_tmp47_.number = _tmp46_;
	_tmp48_ = g_new0 (Constant, 5);
	_tmp48_[0] = _tmp31_;
	_tmp48_[1] = _tmp35_;
	_tmp48_[2] = _tmp39_;
	_tmp48_[3] = _tmp43_;
	_tmp48_[4] = _tmp47_;
	memset (&_tmp49_, 0, sizeof (ConstantCategory));
	_g_free0 (_tmp49_.name);
	_tmp49_.name = _tmp27_;
	_tmp49_.constants = (_vala_Constant_array_free (_tmp49_.constants, _tmp49_.constants_length1), NULL);
	_tmp49_.constants = _tmp48_;
	_tmp49_.constants_length1 = 5;
	_tmp50_ = g_strdup (_ ("Atomic & Nuclear"));
	_tmp51_ = g_strdup (_ ("Planck’s Constant"));
	_tmp52_ = g_strdup ("h");
	_tmp53_ = mp_set_from_string ("0.000000000000000000000000000000000662607015", 10, TRUE);
	memset (&_tmp54_, 0, sizeof (Constant));
	_g_free0 (_tmp54_.name);
	_tmp54_.name = _tmp51_;
	_g_free0 (_tmp54_.symbol);
	_tmp54_.symbol = _tmp52_;
	_g_object_unref0 (_tmp54_.number);
	_tmp54_.number = _tmp53_;
	_tmp55_ = g_strdup (_ ("Fine-Structure Constant"));
	_tmp56_ = g_strdup ("α");
	_tmp57_ = mp_set_from_string ("0.0072973525643", 10, TRUE);
	memset (&_tmp58_, 0, sizeof (Constant));
	_g_free0 (_tmp58_.name);
	_tmp58_.name = _tmp55_;
	_g_free0 (_tmp58_.symbol);
	_tmp58_.symbol = _tmp56_;
	_g_object_unref0 (_tmp58_.number);
	_tmp58_.number = _tmp57_;
	_tmp59_ = g_strdup (_ ("Electron Mass"));
	_tmp60_ = g_strdup ("mₑ");
	_tmp61_ = mp_set_from_string ("0.00000000000000000000000000000091093837139", 10, TRUE);
	memset (&_tmp62_, 0, sizeof (Constant));
	_g_free0 (_tmp62_.name);
	_tmp62_.name = _tmp59_;
	_g_free0 (_tmp62_.symbol);
	_tmp62_.symbol = _tmp60_;
	_g_object_unref0 (_tmp62_.number);
	_tmp62_.number = _tmp61_;
	_tmp63_ = g_strdup (_ ("Proton Mass"));
	_tmp64_ = g_strdup ("mₚ");
	_tmp65_ = mp_set_from_string ("0.00000000000000000000000000167262192595", 10, TRUE);
	memset (&_tmp66_, 0, sizeof (Constant));
	_g_free0 (_tmp66_.name);
	_tmp66_.name = _tmp63_;
	_g_free0 (_tmp66_.symbol);
	_tmp66_.symbol = _tmp64_;
	_g_object_unref0 (_tmp66_.number);
	_tmp66_.number = _tmp65_;
	_tmp67_ = g_new0 (Constant, 4);
	_tmp67_[0] = _tmp54_;
	_tmp67_[1] = _tmp58_;
	_tmp67_[2] = _tmp62_;
	_tmp67_[3] = _tmp66_;
	memset (&_tmp68_, 0, sizeof (ConstantCategory));
	_g_free0 (_tmp68_.name);
	_tmp68_.name = _tmp50_;
	_tmp68_.constants = (_vala_Constant_array_free (_tmp68_.constants, _tmp68_.constants_length1), NULL);
	_tmp68_.constants = _tmp67_;
	_tmp68_.constants_length1 = 4;
	_tmp69_ = g_strdup (_ ("Thermodynamics"));
	_tmp70_ = g_strdup (_ ("Boltzmann Constant"));
	_tmp71_ = g_strdup ("k");
	_tmp72_ = mp_set_from_string ("0.00000000000000000000001380649", 10, TRUE);
	memset (&_tmp73_, 0, sizeof (Constant));
	_g_free0 (_tmp73_.name);
	_tmp73_.name = _tmp70_;
	_g_free0 (_tmp73_.symbol);
	_tmp73_.symbol = _tmp71_;
	_g_object_unref0 (_tmp73_.number);
	_tmp73_.number = _tmp72_;
	_tmp74_ = g_strdup (_ ("Atomic Mass Unit"));
	_tmp75_ = g_strdup ("mᵤ");
	_tmp76_ = mp_set_from_string ("0.00000000000000000000000000166053906892", 10, TRUE);
	memset (&_tmp77_, 0, sizeof (Constant));
	_g_free0 (_tmp77_.name);
	_tmp77_.name = _tmp74_;
	_g_free0 (_tmp77_.symbol);
	_tmp77_.symbol = _tmp75_;
	_g_object_unref0 (_tmp77_.number);
	_tmp77_.number = _tmp76_;
	_tmp78_ = g_strdup (_ ("Molar Gas Constant"));
	_tmp79_ = g_strdup ("R");
	_tmp80_ = mp_set_from_string ("8.31446261815324", 10, TRUE);
	memset (&_tmp81_, 0, sizeof (Constant));
	_g_free0 (_tmp81_.name);
	_tmp81_.name = _tmp78_;
	_g_free0 (_tmp81_.symbol);
	_tmp81_.symbol = _tmp79_;
	_g_object_unref0 (_tmp81_.number);
	_tmp81_.number = _tmp80_;
	_tmp82_ = g_strdup (_ ("Stefan-Boltzmann Constant"));
	_tmp83_ = g_strdup ("σ");
	_tmp84_ = mp_set_from_string ("0.00000005670374419", 10, TRUE);
	memset (&_tmp85_, 0, sizeof (Constant));
	_g_free0 (_tmp85_.name);
	_tmp85_.name = _tmp82_;
	_g_free0 (_tmp85_.symbol);
	_tmp85_.symbol = _tmp83_;
	_g_object_unref0 (_tmp85_.number);
	_tmp85_.number = _tmp84_;
	_tmp86_ = g_strdup (_ ("Avogadro’s Number"));
	_tmp87_ = g_strdup ("Nᴀ");
	_tmp88_ = mp_set_from_string ("602214076000000000000000", 10, TRUE);
	memset (&_tmp89_, 0, sizeof (Constant));
	_g_free0 (_tmp89_.name);
	_tmp89_.name = _tmp86_;
	_g_free0 (_tmp89_.symbol);
	_tmp89_.symbol = _tmp87_;
	_g_object_unref0 (_tmp89_.number);
	_tmp89_.number = _tmp88_;
	_tmp90_ = g_new0 (Constant, 5);
	_tmp90_[0] = _tmp73_;
	_tmp90_[1] = _tmp77_;
	_tmp90_[2] = _tmp81_;
	_tmp90_[3] = _tmp85_;
	_tmp90_[4] = _tmp89_;
	memset (&_tmp91_, 0, sizeof (ConstantCategory));
	_g_free0 (_tmp91_.name);
	_tmp91_.name = _tmp69_;
	_tmp91_.constants = (_vala_Constant_array_free (_tmp91_.constants, _tmp91_.constants_length1), NULL);
	_tmp91_.constants = _tmp90_;
	_tmp91_.constants_length1 = 5;
	_tmp92_ = g_strdup (_ ("Gravitation"));
	_tmp93_ = g_strdup (_ ("Gravitational Constant"));
	_tmp94_ = g_strdup ("G");
	_tmp95_ = mp_set_from_string ("0.000000000066743", 10, TRUE);
	memset (&_tmp96_, 0, sizeof (Constant));
	_g_free0 (_tmp96_.name);
	_tmp96_.name = _tmp93_;
	_g_free0 (_tmp96_.symbol);
	_tmp96_.symbol = _tmp94_;
	_g_object_unref0 (_tmp96_.number);
	_tmp96_.number = _tmp95_;
	_tmp97_ = g_strdup (_ ("Earth Acceleration"));
	_tmp98_ = g_strdup ("g");
	_tmp99_ = mp_set_from_string ("9.80665", 10, TRUE);
	memset (&_tmp100_, 0, sizeof (Constant));
	_g_free0 (_tmp100_.name);
	_tmp100_.name = _tmp97_;
	_g_free0 (_tmp100_.symbol);
	_tmp100_.symbol = _tmp98_;
	_g_object_unref0 (_tmp100_.number);
	_tmp100_.number = _tmp99_;
	_tmp101_ = g_new0 (Constant, 2);
	_tmp101_[0] = _tmp96_;
	_tmp101_[1] = _tmp100_;
	memset (&_tmp102_, 0, sizeof (ConstantCategory));
	_g_free0 (_tmp102_.name);
	_tmp102_.name = _tmp92_;
	_tmp102_.constants = (_vala_Constant_array_free (_tmp102_.constants, _tmp102_.constants_length1), NULL);
	_tmp102_.constants = _tmp101_;
	_tmp102_.constants_length1 = 2;
	_tmp103_ = g_new0 (ConstantCategory, 5);
	_tmp103_[0] = _tmp26_;
	_tmp103_[1] = _tmp49_;
	_tmp103_[2] = _tmp68_;
	_tmp103_[3] = _tmp91_;
	_tmp103_[4] = _tmp102_;
	parser_CONSTANT_CATEGORIES = _tmp103_;
	parser_CONSTANT_CATEGORIES_length1 = 5;
	_tmp104_ = g_str_hash;
	_tmp105_ = g_str_equal;
	_tmp106_ = g_hash_table_new_full (_tmp104_, _tmp105_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (parser_CONSTANTS);
	parser_CONSTANTS = _tmp106_;
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (_tmp18_);
	_g_object_unref0 (_tmp16_);
	_tmp107_ = parser_CONSTANTS;
	_tmp108_ = g_strdup ("pi");
	_tmp109_ = number_new_pi ();
	g_hash_table_insert (_tmp107_, _tmp108_, _tmp109_);
	_tmp110_ = parser_CONSTANTS;
	_tmp111_ = g_strdup ("tau");
	_tmp112_ = number_new_tau ();
	g_hash_table_insert (_tmp110_, _tmp111_, _tmp112_);
	_tmp113_ = parser_CONSTANTS;
	_tmp114_ = g_strdup ("i");
	_tmp115_ = number_new_i ();
	g_hash_table_insert (_tmp113_, _tmp114_, _tmp115_);
	_tmp116_ = parser_CONSTANT_CATEGORIES;
	_tmp116__length1 = parser_CONSTANT_CATEGORIES_length1;
	{
		ConstantCategory* categoty_collection = NULL;
		gint categoty_collection_length1 = 0;
		gint _categoty_collection_size_ = 0;
		gint categoty_it = 0;
		categoty_collection = _tmp116_;
		categoty_collection_length1 = _tmp116__length1;
		for (categoty_it = 0; categoty_it < categoty_collection_length1; categoty_it = categoty_it + 1) {
			ConstantCategory _tmp117_;
			ConstantCategory _tmp118_ = {0};
			ConstantCategory categoty = {0};
			_tmp117_ = categoty_collection[categoty_it];
			constant_category_copy (&_tmp117_, &_tmp118_);
			categoty = _tmp118_;
			{
				ConstantCategory _tmp119_;
				Constant* _tmp120_;
				gint _tmp120__length1;
				_tmp119_ = categoty;
				_tmp120_ = _tmp119_.constants;
				_tmp120__length1 = _tmp119_.constants_length1;
				{
					Constant* constant_collection = NULL;
					gint constant_collection_length1 = 0;
					gint _constant_collection_size_ = 0;
					gint constant_it = 0;
					constant_collection = _tmp120_;
					constant_collection_length1 = _tmp120__length1;
					for (constant_it = 0; constant_it < constant_collection_length1; constant_it = constant_it + 1) {
						Constant _tmp121_;
						Constant _tmp122_ = {0};
						Constant constant = {0};
						_tmp121_ = constant_collection[constant_it];
						constant_copy (&_tmp121_, &_tmp122_);
						constant = _tmp122_;
						{
							GHashTable* _tmp123_;
							Constant _tmp124_;
							const gchar* _tmp125_;
							gchar* _tmp126_;
							Constant _tmp127_;
							Number* _tmp128_;
							Number* _tmp129_;
							_tmp123_ = parser_CONSTANTS;
							_tmp124_ = constant;
							_tmp125_ = _tmp124_.symbol;
							_tmp126_ = g_strdup (_tmp125_);
							_tmp127_ = constant;
							_tmp128_ = _tmp127_.number;
							_tmp129_ = _g_object_ref0 (_tmp128_);
							g_hash_table_insert (_tmp123_, _tmp126_, _tmp129_);
							constant_destroy (&constant);
						}
					}
				}
				constant_category_destroy (&categoty);
			}
		}
	}
}

static void
parser_instance_init (Parser * self,
                      gpointer klass)
{
	self->priv = parser_get_instance_private (self);
	self->ref_count = 1;
}

static void
parser_finalize (Parser * obj)
{
	Parser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PARSER, Parser);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->input);
	_g_object_unref0 (self->priv->root);
	_g_object_unref0 (self->priv->right_most);
	_g_object_unref0 (self->priv->lexer);
	_g_free0 (self->priv->error_token);
}

static GType
parser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_parser_init, value_parser_free_value, value_parser_copy_value, value_parser_peek_pointer, "p", value_parser_collect_value, "p", value_parser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Parser), 0, (GInstanceInitFunc) parser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType parser_type_id;
	parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Parser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	Parser_private_offset = g_type_add_instance_private (parser_type_id, sizeof (ParserPrivate));
	return parser_type_id;
}

GType
parser_get_type (void)
{
	static volatile gsize parser_type_id__once = 0;
	if (g_once_init_enter (&parser_type_id__once)) {
		GType parser_type_id;
		parser_type_id = parser_get_type_once ();
		g_once_init_leave (&parser_type_id__once, parser_type_id);
	}
	return parser_type_id__once;
}

gpointer
parser_ref (gpointer instance)
{
	Parser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
parser_unref (gpointer instance)
{
	Parser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

