/*
 * // Copyright (c) Radzivon Bartoshyk 6/2025. All rights reserved.
 * //
 * // Redistribution and use in source and binary forms, with or without modification,
 * // are permitted provided that the following conditions are met:
 * //
 * // 1.  Redistributions of source code must retain the above copyright notice, this
 * // list of conditions and the following disclaimer.
 * //
 * // 2.  Redistributions in binary form must reproduce the above copyright notice,
 * // this list of conditions and the following disclaimer in the documentation
 * // and/or other materials provided with the distribution.
 * //
 * // 3.  Neither the name of the copyright holder nor the names of its
 * // contributors may be used to endorse or promote products derived from
 * // this software without specific prior written permission.
 * //
 * // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * // AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * // DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * // DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * // SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * // CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * // OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
use crate::dyadic_float::{DyadicFloat128, DyadicSign};

pub(crate) static LOG_STEP_1: [DyadicFloat128; 128] = [
    // -log(r) with 128-bit precision generated by SageMath with:
    // for i in range(128):
    //   r = 2^-8 * ceil( 2^8 * (1 - 2^(-8)) / (1 + i*2^(-7)) );
    //   s, m, e = RealField(128)(r).log().sign_mantissa_exponent();
    //   print("{RationalSign::Pos,", e, ", format_hex(m), "},");
    /* .step_1= */
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: 0,
        mantissa: 0_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -134,
        mantissa: 0x8080abac_46f38946_662d417c_ed007a46_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -133,
        mantissa: 0x8102b2c4_9ac23a4f_91d082dc_e3ddcd38_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -133,
        mantissa: 0xc2492946_4655f45c_da5f3cc0_b3251dbd_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -132,
        mantissa: 0x820aec4f_3a222380_b9e3aea6_c444ef07_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -132,
        mantissa: 0xa33576a1_6f1f4c64_521016bd_904dc968_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -132,
        mantissa: 0xc4a550a4_fd9a19a8_be97660a_23cc540d_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -132,
        mantissa: 0xe65b9e6e_ed965c36_e09f5fe2_058d6006_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0x842cc5ac_f1d03445_1fecdfa8_19b96098_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0x8cb9de8a_32ab368a_a7c98595_30a45153_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0x9defad3e_8f73217a_976d3b5b_45f6ca0b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0xaf4ad26c_bc8e5be7_0e8b8b88_a14ff0ce_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0xb8069857_560707a3_6a677b4c_8bec22e1_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0xc99af2ea_ca4c4570_eaf51f66_692844ba_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0xdb56446d_6ad8deff_a8112e35_a60e6375_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0xe442c00d_e2591b47_196ab34c_e0bccd12_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0xf639cc18_5088fe5d_4066e87f_2c0f7340_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -131,
        mantissa: 0xff4489ce_deab2ca6_c17bd40d_8d9291ec_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0x88bc7411_3f23def1_9c5a0fe3_96f40f1e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0x8d515bf1_1fb94f1c_88713268_840cbcc0_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0x968b0864_3409ceb6_65c0da50_6a088484_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0x9b2fe580_ac80b17d_411a5b94_4aca8708_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xa489ec19_9dab06f2_a9fb6cf0_ecb411b7_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xa93f2f25_0dac67d1_cad2fb8d_48054ae0_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xb2ba75f4_6099cf8b_2c3c2e77_904afa78_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xb780945b_ab55dce4_34c7bc3d_32750fde_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xc11e0b2a_8d1e0ddb_9a631e83_0fd30904_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xc5f57f59_c7f46155_aa8b6997_a402bf30_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xcad2d6e7_b80bf914_2c507fb7_a3d0bf6a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xd49f69e4_56cf1b79_5f53bd2e_406e66e7_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xd98ec2ba_de71e539_58a98f2a_d65bee9b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xde8439c1_dec56877_4d57da94_5b5d0aaa_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xe881bf93_2af3dac0_c524848e_3443e040_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xed89ed86_a44a01aa_11d49f96_cb88317b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xf29877ff_38809091_3b020fa1_820c9492_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xf7ad6f26_e7ff2ef7_54d2238f_75f969b1_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -130,
        mantissa: 0xfcc8e365_9d9bcbec_ca0cdf30_1431b60f_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x8389c302_6ac3139b_62dda9d2_270fa1f4_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x86216b3b_0b17188b_163ceae8_8f720f1e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x88bc7411_3f23def1_9c5a0fe3_96f40f1e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x8b5ae65d_67db9acd_f7a51681_26a58b9a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x8dfccb1a_d35ca6ed_5147bdb6_ddcaf59c_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x934b1089_a6dc93c1_df5bb3b6_0554e152_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x95f783e6_e49a9cfa_4a5004f3_ef063313_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x98a78f0e_9ae71d85_2cdec347_84707839_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x9b5b3bb5_f088b766_d878bbe3_d392be25_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0x9e1293b9_998c1daa_5b035eae_273a855f_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xa0cda11e_af46390d_bb243827_3918db7e_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xa38c6e13_8e20d831_f698298a_dddd7f32_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xa64f04f0_b961df76_e4f5275c_2d15c21f_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xa9157039_c51ebe70_8164c759_686a2209_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xabdfba9e_468fd6f6_f72ea077_49ce6bd3_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xaeadeefa_caf97d35_7dd6e688_ebb13b03_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xb1801859_d56249dc_18ce51ff_f99479cd_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xb45641f4_e350a0d3_2756eba0_0bc33978_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xb7307735_78cb90b2_be1116c3_466beb6d_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xba0ec3b6_33dd8b09_49dc60b2_b059a60b_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xbcf13343_e7d9ec7d_2efd1778_1bb3afec_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xbfd7d1de_c0a8df6f_37eda996_244bccb0_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xc2c2abbb_6e5fd56f_33337789_d592e296_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xc5b1cd44_596fa51e_1a18fb8f_9f9ef280_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xc8a5431a_dfb44ca5_688ce7c1_a75e341a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xcb9d1a18_9ab56e76_2d7e9307_c70c0668_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xce995f50_af69d861_ef2f3f4f_861ad6a9_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xd19a2011_27d3c645_7f9d79f5_1dcc7301_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xd19a2011_27d3c645_7f9d79f5_1dcc7301_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xd49f69e4_56cf1b79_5f53bd2e_406e66e7_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xd7a94a92_466e833a_ad88bba7_d0cee8e0_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xdab7d022_31484a92_96c20cca_6efe2ac5_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xddcb08dc_0717d85b_f40a666c_87842843_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xe0e30349_fd1cec80_7fe8e180_2aba24d6_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xe0e30349_fd1cec80_7fe8e180_2aba24d6_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xe3ffce3a_2aa64922_3eadb651_b49ac53a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xe72178c0_323a1a0f_304e1653_e71d9973_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xea481236_f7d35baf_e9a767a8_0d6d97e8_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xed73aa42_64b0ade9_4f91cf4b_33e42998_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xf0a450d1_39366ca6_fc66eb64_08ff6433_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xf0a450d1_39366ca6_fc66eb64_08ff6433_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xf3da161e_ed6b9aaf_ac8d42f7_8d3e65d3_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xf7150ab5_a09f27f4_5a470250_d40ebe90_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xfa553f70_18c966f2_b780a545_a1b54dcf_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xfa553f70_18c966f2_b780a545_a1b54dcf_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -129,
        mantissa: 0xfd9ac57b_d244217e_8f05924d_258c14c5_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8072d72d_903d588b_89d1b09c_70c4010a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x821b05f3_b01d6774_030d58c3_f7e2ea1f_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x821b05f3_b01d6774_030d58c3_f7e2ea1f_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x83c5f829_9e2b4091_20f6fafe_8fbb68b9_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8573b716_82a7d21a_e21f9f89_c1ab80b2_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8573b716_82a7d21a_e21f9f89_c1ab80b2_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x87244c30_8e670a66_01e005d0_6dbfa8f8_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x88d7c11e_3ad53cdc_223111a7_07b6de2c_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x88d7c11e_3ad53cdc_223111a7_07b6de2c_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8a8e1fb7_94b09134_2eb628db_a173c82d_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8c477207_91e53313_be2ad194_15fe25a5_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8c477207_91e53313_be2ad194_15fe25a5_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8e03c24d_73003959_bddae1cc_ce247838_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8fc31afe_30b2c6de_9b00bf16_7e95da67_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x8fc31afe_30b2c6de_9b00bf16_7e95da67_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x918586c5_f5e4bf01_9b92199e_d1a4bab1_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x934b1089_a6dc93c1_df5bb3b6_0554e152_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x934b1089_a6dc93c1_df5bb3b6_0554e152_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x9513c368_76083695_f3cbc416_a2418012_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x96dfaabd_86fa1646_be1188fb_c94e2f15_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x96dfaabd_86fa1646_be1188fb_c94e2f15_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x98aed221_a03458b6_1d2f8932_1647b358_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x98aed221_a03458b6_1d2f8932_1647b358_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x9a81456c_ec642e0f_e549f9aa_ea3cb5e1_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x9c5710b8_cbb73a42_a2554b2d_d4619e63_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x9c5710b8_cbb73a42_a2554b2d_d4619e63_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x9e304061_b5fda919_30603d87_b6df81ad_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0x9e304061_b5fda919_30603d87_b6df81ad_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa00ce109_2e5498c3_67879c5a_30cd1242_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa1ecff97_c91e267b_0b7efae0_8e597e16_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa1ecff97_c91e267b_0b7efae0_8e597e16_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa3d0a93f_45169a4a_83594fab_088c0d65_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa3d0a93f_45169a4a_83594fab_088c0d65_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa5b7eb7c_b860fb88_af6a62a0_dec6e073_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa5b7eb7c_b860fb88_af6a62a0_dec6e073_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa7a2d41a_d270c9d7_49362382_a768847a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa7a2d41a_d270c9d7_49362382_a768847a_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa9917134_33c2b998_8ba4aea6_14d05701_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xa9917134_33c2b998_8ba4aea6_14d05701_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xab83d135_dc633301_7fe6607b_a902ef3c_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xab83d135_dc633301_7fe6607b_a902ef3c_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xad7a02e1_b24efd31_d60864fd_949b4bd3_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xad7a02e1_b24efd31_d60864fd_949b4bd3_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: -128,
        mantissa: 0xaf741551_20c9011c_066d235e_e63073dd_u128,
    },
    DyadicFloat128 {
        sign: DyadicSign::Pos,
        exponent: 0,
        mantissa: 0_u128,
    },
];

pub(crate) static LOG_STEP_2: [DyadicFloat128; 193] =
    // -log(r) for the second step, generated by SageMath with:
    //
    // for i in range(-2^6, 2^7 + 1):
    //   r = 2^-16 * round( 2^16 / (1 + i*2^(-14)) );
    //   s, m, e = RealField(128)(r).log().sign_mantissa_exponent();
    //   print("{RationalSign::Pos," if s == -1 else "{RationalSign::Neg,", e, ",
    //         format_hex(m), "},");
    /* .step_2 = */
    [
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -135,
            mantissa: 0x803faaca_c419abf2_a1c6f3fc_242ef8d0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xfc834da1_6f0d9f57_a225ebc0_2e6d9dd4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xf88735cc_c7433381_c33f6ad3_40ae18a9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xf48b0e17_1249b6bc_70b2a4d3_8a242244_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xf08ed67f_d190e280_1d548190_48b811b0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xec928f06_86828706_aee59837_01d2a02b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xe89637aa_b2828aed_40abb8ab_72afa2d2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xe499d06b_d6eeead5_deb547a0_d4a26ef9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xe09d5949_751fb909_39c5bdfb_cf6087a0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xdca0d243_0e671d18_53ea9bf1_52de635f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xd8a43b58_2411537e_25b82043_6f5f4352_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xd4a79488_3764ad41_3c2d13ea_1d0be058_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xd0aaddd2_c9a18f95_4f3cfa62_bcb3ce3a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xccae1737_5c02737c_d0fff6cd_f14a86c7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xc8b140b5_6fbbe56a_7587b5f0_453ac3d2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xc4b45a4c_85fc84e2_b358ad16_dfd0d085_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xc0b763fc_1fed041d_3c86fdce_5dbe7314_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xbcba5dc3_beb027a6_70764e46_ac18a96d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xb8bd47a2_e362c600_c63be62b_8f285882_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xb3c0d59a_244325a4_72e7b5a3_86e5e31b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xafc39bac_66434f27_c3ea2cd9_3f316b34_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xabc651d4_91a7b438_1dfb11a7_cc892843_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xa7c8f812_2773f38d_fc679a28_e9d9f212_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0xa3cb8e64_a8a5bbe6_e7bc977e_eec42254_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0x9fce14cb_9634cba6_b20f215b_d3b58c61_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0x9bd08b46_7112f078_abe28625_08d67a98_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0x97d2f1d4_ba2c06f0_d1aacedc_efe9d377_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0x93d54875_f265fa2c_f1eb25e7_7d05f58d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0x8fd78f29_9aa0c375_cbef6fac_33691e95_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0x8bd9c5ef_33b669e0_27206404_62a0f8ad_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0x87dbecc6_3e7b01ed_e2f17751_34c8da75_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -136,
            mantissa: 0x83de03ae_3bbcad2e_ff67e201_c8c50d67_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xffc0154d_588733c5_3c742a7c_76356396_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xf7c4035e_21a4052f_f90dd6b2_4aa686ec_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xefc7d18d_d4485b9e_ca47c52b_7d7ffce2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xe7cb7fdb_71e0db36_3703617a_d3d8311f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xdfcf0e45_fbce3e80_7e4cfbd8_30393b88_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xd7d27ccc_736555af_4f7a29cf_0fc2c38e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xcfd5cb6d_d9ef05dd_7370ae83_f9e72748_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xc7d8fa29_30a84850_671486eb_4cd76f65_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xbfdc08fd_78c229b9_e6dbb624_f9739782_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xb7def7e9_b361c979_6b866e09_e57d9079_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xafe1c6ec_e1a058dd_97fa2fd0_c9dc723e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0xa7e47606_048b1a65_983e8089_7cf1e60f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0x9fe70534_1d236102_7199cd06_ae5d39b3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0x97e97476_2c5e8f58_43cd18a7_2a051a96_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0x8febc3cb_332616ff_7b6d1248_c3e1fd40_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -137,
            mantissa: 0x87edf332_325777c5_f5572a88_14c703af_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -138,
            mantissa: 0xffe00554_55887de0_26828c92_649a3a39_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -138,
            mantissa: 0xefe3e464_3a640cf3_82c550bd_1216d82a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -138,
            mantissa: 0xdfe78392_14b4e8ae_da6959f7_f0e01bf0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -138,
            mantissa: 0xcfeae2db_e5d6736d_da93e2fa_85a8f214_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -138,
            mantissa: 0xbfee023f_af0c2480_b47505bf_a5a03b06_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -138,
            mantissa: 0xaff0e1bb_718186ad_b1475a51_80a43520_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -138,
            mantissa: 0x9ff3814d_2e4a36b2_a8740b91_c95df537_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -138,
            mantissa: 0x8ff5e0f2_e661e1c6_57d895d3_5921b59c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -139,
            mantissa: 0xfff00155_35588833_3c56c598_c659c2a3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -139,
            mantissa: 0xdff3c0e4_97ea4eb1_2ef8ec33_ed9d782a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -139,
            mantissa: 0xbff7008f_f5e0c257_379eba7e_6465ff63_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -139,
            mantissa: 0x9ff9c053_5073a370_3f972b78_3fcab757_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -140,
            mantissa: 0xfff80055_51558885_de026e27_1ee0549d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -140,
            mantissa: 0xbffb8023_febc0c25_eceb47ea_01f6c632_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -141,
            mantissa: 0xfffc0015_54d55888_7333c578_57e1ed52_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0xfffe0005_55455588_87dde026_fa704374_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: 0,
            mantissa: 0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -141,
            mantissa: 0x80010002_aab2aac4_44999abe_2fe2cc65_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -140,
            mantissa: 0x8002000a_aaeaac44_4eef3815_81464ccb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -140,
            mantissa: 0xc0048024_01440c26_dfeb4850_85f6f454_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -139,
            mantissa: 0x8004002a_acaac445_99abe3be_3a1c6e93_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -139,
            mantissa: 0xa0064053_5a37a37a_6bc1e20e_ac8448b4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -139,
            mantissa: 0xc0090090_0a20c275_979eedc0_64c242fd_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -139,
            mantissa: 0xe00c40e4_bd6e4efd_c72446cc_1bf728bd_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -138,
            mantissa: 0x800800aa_baac446e_f381b821_bbb569e5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -138,
            mantissa: 0x900a20f3_19a3e273_569b26aa_a485ea5c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -138,
            mantissa: 0xa00c814d_7c6a37f8_2dcf56c8_3c80b028_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -138,
            mantissa: 0xb00f21bb_e3e388ee_5f697682_84463b9b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -138,
            mantissa: 0xc0120240_510c284c_b48ea6c0_5e2773a1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -138,
            mantissa: 0xd01522dc_c4f87991_14d9d761_96d8043a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -138,
            mantissa: 0xe0188393_40d4f241_e016a611_a4415d72_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -138,
            mantissa: 0xf01c2465_c5e61b6f_661e135f_49a47c40_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0x801002ab_2ac4499a_be6bf0fa_435e8383_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0x88121333_7898871e_9a31ba0c_bc030353_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0x901443cc_cd362c9f_54b57dfe_0c4c840f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0x98169478_296fad41_7ad1e9c3_15328f7e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xa0190536_8e2389b3_1f3f686c_f3d6be22_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xa81b9608_fc3c50ec_f105b66e_c4703ede_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xb01e46f0_74b0a0f3_610848c6_8df4d233_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xb82117ed_f8832797_d6aef30c_d312169a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xc0240902_88c2a339_f3ac3796_08053d9d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xc8271a2f_2689e388_e6e2acf8_f4d4c24a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xd02a4b74_d2ffca44_ce6ae474_d860359f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xd82d9cd4_8f574c00_28bb3cd9_f2a65fb5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xe0310e4f_5ccf70e1_54f30dbe_f38a8066_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xe8349fe6_3cb35564_224a96f5_a7471c46_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xf038519a_305a2b1b_6ea92059_1aa02e1b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -137,
            mantissa: 0xf83c236c_39273972_d462b637_56c87e80_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0x80200aae_ac44ef38_338f7760_5fe77f2a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0x842213b7_47fec7bb_3ff51287_882500ed_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0x88242cd0_7084ed02_cc394b3e_f0ebeb12_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0x8c2655fa_a6a1323f_1ab9679b_55f78a6b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0x90288f36_6b237771_7025697d_10af0436_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0x942ad884_3ee1a9cd_17e4b7ac_6c600cb4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0x982d31e4_a2b7c418_7013925a_9a8da7f3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0x9c2f9b58_1787cf0d_fd1a09c8_48e3950e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xa03214df_1e39e1bd_84dd2de6_e3d90a37_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xa4349e7a_37bc21ed_318b2ddd_9d0a33b4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xa8373829_e502c47a_bc031e6f_5acfd4a8_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xac39e1ee_a7080dbc_9dd91e52_c79fd070_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xb03c9bc8_fecc51e3_4af78fa1_cb48a12d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xb43f65b9_6d55f55a_72de1d99_ce252efd_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xb74187bc_8ccffa84_efb1dbe7_21934877_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xbb446dd4_d9bca499_b4b080f2_30c87598_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xbf476404_a05f88f2_da6a7cd1_9c7fa4f2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xc34a6a4c_61d5cc3c_df00e378_3b50ecfb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xc74d80ac_9f42a52d_da2e5e02_ab4e183c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xcb50a725_d9cf5ce6_ea5f6ee9_9d30c626_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xcf53ddb8_92ab4f55_a96d5956_531d7d8b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xd3572465_4b0beb95_a8fc636e_b36afa75_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xd75a7b2c_842cb451_f67e2b82_7bfc4421_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xdb5de20e_bf4f4026_a6d8c817_516303e6_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xdf61590c_7dbb3a02_69b36ae5_962e85f4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xe364e026_40be6188_24693eec_2a831cc3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xe768775c_89ac8b70_94a339d5_6a55ab4a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xeb6c1eaf_d9dfa1eb_fa9998fb_f9703bf4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xef6fd620_b2b7a503_cafdc272_27b71eaa_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xf3739daf_959aaafc_688d4282_f6026aa3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xf777755d_03f4e0b6_e54e9e38_04464cdd_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xfb7b5d29_7f388a12_cb78b383_f4b59dce_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -136,
            mantissa: 0xff7f5515_88de024f_ee055fc5_15062c04_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x81c1ae90_d131de38_207812b4_3382acdd_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x83c3baa7_26a721cc_dc90c4c4_b61f3a87_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x85c5cece_05941dbc_1a03f13f_b2c978b1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x87c7eb05_aec1304f_b36f282e_83a7dc36_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x89ca0f4e_62f9c476_6ad14c3d_fa414391_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x8bcc3ba8_630c51f4_e8dd4ea0_d48b88e5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x8dce7013_efca5d96_c02515af_e8caeb90_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x8fd0ac91_4a08795f_741ceaf3_349f3cf1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x91d2f120_b29e44bb_83f7cd49_29d2c28c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x93d53dc2_6a666cb1_795d03eb_c2fd03fa_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x95d79276_b23eac12_faf74f1d_1ad16acc_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x97d9ef3d_cb07cbad_e2de134f_72fee429_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x99dc5417_f5a5a27d_58d8dba6_cadac5d5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x9bdec105_72ff15da_f07d90bc_5aae40a4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x9d609804_6659ea6b_1deaf79d_9fc40374_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0x9f631314_50b07988_7ba63e67_69b81999_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xa1659638_404d5f92_59ebfc93_35094e59_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xa3682170_7622f97a_16aae012_b5026f71_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xa56ab4bd_3326b378_ff5d4f2c_0e4b9cae_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xa76d501e_b8510941_855838b5_119dcb28_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xa96ff395_469d8630_75f70cbb_e9cf1603_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xab729f21_1f0ac57e_36a53ad4_d5541cc9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xad7552c2_829a7270_04c5934e_c32d20d9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xaf780e79_b2514889_3977e89a_ec59bfa2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xb17ad246_ef3713bc_913d4e3d_c55c3e6e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xb37d9e2a_7a56b09d_777b52a9_e70d8bcc_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xb5807224_94be0c91_55de916f_d30591de_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xb7834e35_7f7e2600_e79cfb37_be2861e4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xb986325d_7bab0c89_90983104_d3805389_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xbb891e9c_ca5be12e_b860504b_aa6f984d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xbd8c12f3_acaad68b_29178d6f_f5712b96_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xbf8f0f62_63b53102_7236fa47_ba19a198_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xc19213e9_309b46f2_4f34d64c_afcc50e3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xc3952088_548080e4_120cc62e_b0a8db3e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xc5983540_108b59be_11aa5084_779060e3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xc79b5210_a5e55ef5_1c35fd62_36c8dcf1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xc99e76fa_55bb30bd_ed4576a7_e4b878fe_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xcb20d7fa_3a336081_6caf4bb8_fd2c1131_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xcd240b10_753e78de_3f24a6cb_b09c654f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xcf274640_7e0ff09f_78bc003b_b81e40f3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xd12a898a_95dff002_56647301_edfd8e8b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xd32dd4ee_fde9b2ef_28fe1c4d_04ca4ed9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xd531286d_f76b892a_e1ea9ea6_cbf57379_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xd7348407_c3a6d688_a3832028_141a5cc2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xd937e7bc_a3e0131b_557421dd_379d3ead_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xdb3b538c_d95ecb67_3cff8e87_a99bcaf0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xdd3ec778_a56da093_99255ef3_4bd0801f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xdf424380_495a489c_42b33220_abfa15cd_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xe145c7a4_06758e83_503b378f_aa97dbc0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xe34953e4_1e135282_bdf2ca00_6f59b544_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xe54ce840_d18a8a3e_1979190a_f37ed16f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xe75084ba_623540f4_31863ff7_cf898c9c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xe9542951_117097b0_c983284f_60293647_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xeb57d605_209cc57e_510a969e_be03f804_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xed5b8ad6_d11d1797_9f53bffc_6d23fe30_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xef5f47c6_6457f199_b286c6e1_13337886_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xf0e21acd_d6e7d412_b6ed8085_2ae6fd63_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xf2e5e5f2_5450c5a2_df437fb0_f616082d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xf4e9b935_685dbe0b_f237cff1_acb306b3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xf6ed9497_5480b696_52dbfafb_4121a092_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xf8f17818_5a2ebfd9_0d816482_49cece4c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xfaf563b8_bae001eb_ad95e6b0_b96903d3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xfcf95778_b80fbc98_176cd568_87ac7fe9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -135,
            mantissa: 0xfefd5358_933c478c_65f4c739_7f1f478d_u128,
        },
    ];

pub(crate) static LOG_STEP_3: [DyadicFloat128; 161] =
    // -log(r) for the third step, generated by SageMath with:
    //
    // for i in range(-80, 81):
    //   r = 2^-21 * round( 2^21 / (1 + i*2^(-21)) );
    //   s, m, e = RealField(128)(r).log().sign_mantissa_exponent();
    //   print("{RationalSign::Pos," if (s == -1) else "{RationalSign::Neg,", e, ",
    //         format_hex(m), "},");
    /* .step_3 = */
    [
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x9fff3801_4d52e45a_374b2940_76d669c3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x9dff3cf9_40fad85a_7f6f05dc_dbeb776e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x9bff41e1_34f1cb36_3d55e21d_41bbadf9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x99ff46b9_2936bcf4_ccdba2d5_4aadbc5c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x97ff4b81_1dc8ad9d_71dd16d3_073f79b2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x95ff5039_12a69d37_5837f3df_1a58dd48_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x93ff54e1_07cf8bc9_93cad3bc_dd26fd6d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x91ff5978_fd42795b_2075312a_827f14fa_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x8fff5e00_f2fe65f2_e21764e1_39c98f60_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x8dff6278_e9025197_a492a295_51751b4c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x8bff66e0_df4d3c50_1bc8f5f6_58f1c3a2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x89ff6b38_d5de2622_e39d3faf_42340ed7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x87ff6f80_ccb40f16_7ff33266_82c02485_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x85ff73b8_c3cdf731_5caf4fbe_343cf928_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x83ff77e0_bb2ade79_cdb6e554_348f7fe8_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -142,
            mantissa: 0x81ff7bf8_b2c9c4f6_0ef009c2_457de25d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xffff0001_55535558_8883333c_57b57c74_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xfbff07f1_45931f44_f32668f3_9c70d183_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xf7ff0fc1_3650e7bd_459a73c6_a6486fe3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xf3ff1771_278aaecd_37b18cca_7dd3a29f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xefff1f01_193e7480_513f610d_21bcfc78_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xebff2671_0b6a38e1_ea190b95_c0690b7b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xe7ff2dc0_fe0bfbfd_2a150f64_f0ad1743_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xe3ff34f0_f121bddd_090b5174_e995e9d1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xdfff3c00_e4a97e8c_4ed512b9_b93ea2bf_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xdbff42f0_d8a13e15_934cea21_7ab794a2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xd7ff49c0_cd06fc83_3e4ebe94_8afd2c76_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xd3ff5070_c1d8b9df_87b7c0f5_bcfee2e1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xcfff5700_b7147634_77666622_8cb6371b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xcbff5d70_acb8318b_e53a60f3_514db358_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xc7ff63c0_a2c1ebef_79149c3b_6e57fa86_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xc3ff69f0_992fa568_aad734c9_8416df2a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xbfff7000_8fff5e00_c2657367_9ed28334_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xbbff75f0_872f15c0_d7a3c6db_6540809f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xb7ff7bc0_7ebcccb1_d277bde6_45fb1aad_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xb3ff8170_76a682dc_6ac80145_a4087793_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xafff8700_6eea3849_287c4db3_0271e265_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xabff8c70_6785ed00_637d6de4_2eeb151e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xa7ff91c0_6077a10a_43b5348b_6b898a8c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0xa3ff96f0_59bd546e_c10e7657_978bd7f6_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0x9fff9c00_53550735_a37503f4_57310e59_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0x9bffa0f0_4d3cb966_82d5a40a_3aa022ff_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0x97ffa5c0_47726b08_c71e0d3e_e3df5f4d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0x93ffaa70_41f41c23_a83ce035_2bdbd79b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0x8fffaf00_3cbfccbe_2e21a18d_4680e8e4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0x8bffb370_37d37cdf_30bcb3e4_e5dfbd28_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0x87ffb7c0_332d2c8d_57ff51d7_5c66d64a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -143,
            mantissa: 0x83ffbbf0_2ecadbcf_1bdb87fd_be299f43_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xffff8000_55551555_88885dde_02700703_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xf7ff87e0_4d94724c_d259ca80_3a0c1870_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xefff8f80_464fce8f_e5141308_51c7070a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xe7ff96e0_3f832a2a_30a16898_f3073a64_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xdfff9e00_392a8526_c4ed6451_7b2949ce_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xd7ffa4e0_3341df90_51e4fb4e_32cf6350_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xcfffab80_2dc53971_277672a8_8350bcce_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xc7ffb1e0_28b092d3_35915377_2a490f06_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xbfffb800_23ffebc0_0c265ece_6b481a0e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xb7ffbde0_1faf4440_db2781c0_3fa132f6_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xafffc380_1bba9c5e_7287c95c_845ada33_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0xa7ffc8e0_181df421_423b56b1_263e5a77_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0x9fffce00_14d54b91_5a3752ca_4c076fa3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0x97ffd2e0_11dca2b6_6a71e2b2_7eb3f573_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0x8fffd780_0f2ff997_c2e21b72_cff39d8f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -144,
            mantissa: 0x87ffdbe0_0ccb503c_537ff612_feb7ac9e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -145,
            mantissa: 0xffffc000_15554d55_58888733_33c57c18_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -145,
            mantissa: 0xefffc7c0_1193f9d1_fa514218_42311c42_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -145,
            mantissa: 0xdfffcf00_0e4aa5fa_2c4ed6de_475b942c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -145,
            mantissa: 0xcfffd5c0_0b7151d8_ce77678c_bb6fcb88_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -145,
            mantissa: 0xbfffdc00_08fffd78_00c26629_a679ed3b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -145,
            mantissa: 0xafffe1c0_06eea8e1_23287cb9_d3072728_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -145,
            mantissa: 0x9fffe700_0535541c_d5a37540_fd057315_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -145,
            mantissa: 0x8fffebc0_03cbff32_f82e21c1_fce36810_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -146,
            mantissa: 0xffffe000_05555455_5588887d_dde02702_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -146,
            mantissa: 0xdfffe780_0392aa14_9ac4ed72_adf5b295_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -146,
            mantissa: 0xbfffee00_023fffaf_000c2664_8066b482_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -146,
            mantissa: 0x9ffff380_014d552e_455a3754_b292c077_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -147,
            mantissa: 0xfffff000_01555535_55588888_33333c58_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -147,
            mantissa: 0xbffff700_008ffff5_e000c266_5736679f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -148,
            mantissa: 0xfffff800_00555551_55558888_85ddde02_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -149,
            mantissa: 0xfffffc00_00155554_d5555888_88733334_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: 0,
            mantissa: 0u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -148,
            mantissa: 0x80000200_000aaaaa_eaaaac44_444eeeef_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -147,
            mantissa: 0x80000400_002aaaac_aaaac444_459999ac_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -147,
            mantissa: 0xc0000900_0090000a_2000c266_7596679f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -146,
            mantissa: 0x80000800_00aaaaba_aaac4444_6eeef381_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -146,
            mantissa: 0xa0000c80_014d557c_655a3755_f81815cc_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -146,
            mantissa: 0xc0001200_02400051_000c2668_4c66b482_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -146,
            mantissa: 0xe0001880_0392ab40_bac4ed7c_40fb07eb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -145,
            mantissa: 0x80001000_02aaab2a_aac44449_999abe2c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -145,
            mantissa: 0x90001440_03cc00cd_082e21d7_9cbb6812_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -145,
            mantissa: 0xa0001900_0535568d_d5a37569_adb01dc3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -145,
            mantissa: 0xb0001e40_06eeac74_33287d01_e8c9d1d9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -145,
            mantissa: 0xc0002400_09000288_00c266a3_2679ed48_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -145,
            mantissa: 0xd0002a40_0b7158d1_de776851_22b2764b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -145,
            mantissa: 0xe0003100_0e4aaf5b_2c4ed810_a8063f03_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -145,
            mantissa: 0xf0003840_1194062e_0a5143e7_be891c8f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0x80002000_0aaaaeaa_ac4444ee_ef3813a1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0x88002420_0ccb5a6e_5b7ff7fe_1339025b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0x90002880_0f300668_42e21e26_caf39e33_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0x98002d20_11dcb29e_f271e66f_a5554bc6_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xa0003200_14d55f19_5a3757e0_615cc676_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xa8003720_181e0bde_ca3b5d82_10ca5cab_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xb0003c80_1bbab8f6_f287d25f_3cb032bb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xb8004220_1faf6669_e3278d84_0be28cdb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xc0004800_24001440_0c266dfe_6b482076_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xc8004e20_28b0c282_3d9166de_380a6d3d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xd0005480_2dc57139_a7768b35_6ba61e4b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xd8005b20_3342206f_d9e51a18_49db73c1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xe0006200_392ad02e_c4ed8a9d_907eb521_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xe8006920_3f838080_b8a197de_a928acd7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xf0007080_46503170_65144cf7_dcc72d3b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -144,
            mantissa: 0xf8007820_4d94e308_da5a1108_890d9f6a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0x80004000_2aaacaaa_c4445999_abe2ce2c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0x84004410_2ecb2431_1fdbbb4f_3bffc832_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0x88004840_332d7e1d_97ff8f39_ec91b4ee_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0x8c004c90_37d3d876_74bcfcf0_b3f0a95d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0x90005100_3cc03342_2e21f80c_a6813aff_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0x94005590_41f48e87_6c3d4629_170ce87f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0x98005a40_4772ea4d_071e84e3_b80a8881_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0x9c005f10_4d3d469a_06d62fdc_bdd6bec3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xa0006400_5355a375_a375a6b7_01dc77c0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xa4006910_59be00e7_450f3318_26ad6b05_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xa8006e40_60785ef6_83b60ea8_bd0aa459_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xac007390_6786bdab_277e6914_69dd13f5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xb0007900_6eeb1d0d_287d6e0a_0d1e25eb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xb4007e90_76a77d24_aec94b3b_e9b060f5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xb8008440_7ebdddfa_1279365f_ce280cce_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xbc008a10_87303f95_dba5732f_3e83e04a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xc0009000_9000a200_c2675967_9ed5b754_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xc4009610_99310543_aed95aca_5edb5109_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xc8009c40_a2c36967_b917091d_2687160f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xcc00a290_acb9ce76_293d1c2a_0378e75d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xd000a900_b7163478_776977bf_9766f5a7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xd400af90_c1da9b78_4bbb31b1_4776a18b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xd800b640_cd09037f_7e5297d7_6c8564ba_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xdc00bd10_d8a36c98_1751360f_8461c447_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xe000c400_e4abd6cc_4ed9dc3c_63f44c41_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xe400cb10_f1244226_8d10a446_6a5894d5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xe800d240_fe0eaeb1_6a1af81b_b4e6510e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xec00d991_0b6d1c77_ae1f97b0_542a677a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xf000e101_19418b84_51469efe_81d014cc_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xf400e891_278dfbe2_7bb98c06_d77a18b4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xf800f041_36546d9d_85a344d0_868bed17_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -143,
            mantissa: 0xfc00f811_4596e0c0_f7301d69_90e307cc_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x80008000_aaabaaac_4446eef3_8140138f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x82008408_b2cbe5b8_10f5e432_96105497_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x84008820_bb2d2189_edbd4f83_ef63f730_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x86008c48_c3d05e27_feb654fd_541c638e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x88009080_ccb69b98_7ffadeb8_882f7674_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x8a0094c8_d5e0d9e1_c5a59fd3_6bd44397_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x8c009920_df50190a_3bd21770_1b27dddb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x8e009d88_e9055918_669c93b5_0e4a2595_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x9000a200_f3019a12_e22234cd_39f29cd4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x9200a688_fd45dc00_6280efe8_307d41d9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x9400ab21_07d31ee7_b3d7923a_436f6fc4_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x9600afc9_12aa62cf_ba45c3fc_a574c5a0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x9800b481_1dcca7bf_71ec0b6d_8cd413d1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x9a00b949_293aedbd_eeebcfd0_565c5006_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x9c00be21_34f634d2_5d675c6d_a8c98fc3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0x9e00c309_40ff7d04_0181e393_98a2099a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -142,
            mantissa: 0xa000c801_4d57c65a_375f8195_cc8b1d29_u128,
        },
    ];

pub(crate) static LOG_STEP_4: [DyadicFloat128; 130] =
    // -log(r) for the fourth step, generated by SageMath with:
    //
    // for i in range(-65, 65):
    //   r = 2^-28 * round( 2^28 / (1 + i*2^(-28)) );
    //   s, m, e = RealField(128)(r).log().sign_mantissa_exponent();
    //   print("{RationalSign::Pos," if (s == -1) else "{RationalSign::Neg,", e, ",
    //         format_hex(m), "},");
    /* .step_4 = */
    [
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -149,
            mantissa: 0x81fffef7_f002cb2b_4cd24d68_ff2f11ae_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xfffffe00_00055555_45555588_8887ddde_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xfbfffe0f_e0051653_f0fa101f_52b3971f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xf7fffe1f_8004d94a_9c9329d6_59ed3734_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xf3fffe2e_e0049e31_4821006d_9b58462e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xeffffe3e_000464ff_f3a3f025_142f8c21_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xebfffe4c_e0042dae_9f1c53bc_c1c4b11c_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xe7fffe5b_8003f835_4a8a8474_a17fdd30_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xe3fffe69_e003c48b_f5eeda0c_b0df586d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xdffffe78_000392aa_a149aac4_ed772adf_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xdbfffe85_e0036289_4c9b4b5d_54f0bc96_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xd7fffe93_8003341f_f7e40f15_e50a759f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xd3fffea0_e0030766_a32447ae_9b975e05_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xcffffeae_0002dc55_4e5c4567_767ebdd5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xcbfffeba_e002b2e3_f98c5700_73bbbd19_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xc7fffec7_80028b0a_a4b4c9b9_915d03dd_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xc3fffed3_e00264c1_4fd5e952_cd845a28_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xbffffee0_00023fff_faf0000c_26664806_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xbbfffeeb_e0021cbe_a60356a5_9a49b57f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xb7fffef7_8001faf5_5110345f_27878a9b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xb3ffff02_e001da9b_fc16def8_cc8a4f61_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xafffff0e_0001bbaa_a7179ab2_87cdcbd8_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xabffff18_e0019e19_5212aa4c_57dea809_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xa7ffff23_800181df_fd084f06_3b5a0bf8_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0xa3ffff2d_e00166f6_a7f8c8a0_30ed3fab_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0x9fffff38_00014d55_52e4555a_37554b29_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0x9bffff41_e00134f3_fdcb31f4_4d5e9676_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0x97ffff4b_80011dca_a8ad99ae_71e48997_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0x93ffff54_e00107d1_538bc648_a3d12c90_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0x8fffff5e_0000f2ff_fe65f002_e21cc765_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0x8bffff66_e000df4e_a93c4d9d_2bcd821a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0x87ffff6f_8000ccb5_540f1457_7ff704b2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -150,
            mantissa: 0x83ffff77_e000bb2b_fede77f1_ddba1731_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xffffff00_00015555_53555558_88888333_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xf7ffff0f_c0013652_a8e7ba8d_659ed7dc_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xefffff1f_0001193f_fe747e02_5142fc61_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xe7ffff2d_c000fe0d_53fbfb37_4a1800c7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xdfffff3c_0000e4aa_a97e8aac_4ed77513_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xd7ffff49_c000cd07_fefc81e1_5e50a947_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xcfffff57_0000b715_54763356_7767ed66_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xc7ffff63_c000a2c2_a9ebee8b_9915d174_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xbfffff70_00008fff_ff5e0000_c2666573_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xb7ffff7b_c0007ebd_54ccb135_f2787966_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xafffff87_00006eea_aa3848ab_287cdd4e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0xa7ffff91_c0006077_ffa109e0_63b5a12d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0x9fffff9c_00005355_55073555_a3755504_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0x97ffffa5_c0004772_aa6b088a_e71e48d5_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0x8fffffaf_00003cbf_ffccbe00_2e21cca2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -151,
            mantissa: 0x87ffffb7_c000332d_552c8d35_77ff706a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -152,
            mantissa: 0xffffff80_00005555_55155555_8888885e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -152,
            mantissa: 0xefffff8f_8000464f_ffce8fc0_25142fe3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -152,
            mantissa: 0xdfffff9e_0000392a_aa8526aa_c4ed7764_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -152,
            mantissa: 0xcfffffab_80002dc5_55397115_67767ee3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -152,
            mantissa: 0xbfffffb8_000023ff_ffebc000_0c26665f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -152,
            mantissa: 0xafffffc3_80001bba_aa9c5e6a_b287cdd9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -152,
            mantissa: 0x9fffffce_000014d5_554b9155_5a375553_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -152,
            mantissa: 0x8fffffd7_80000f2f_fff997c0_02e21ccb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -153,
            mantissa: 0xffffffc0_00001555_554d5555_58888887_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -153,
            mantissa: 0xdfffffcf_00000e4a_aaa5fa2a_ac4ed777_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -153,
            mantissa: 0xbfffffdc_000008ff_fffd7800_00c26666_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -153,
            mantissa: 0x9fffffe7_00000535_55541cd5_55a37555_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -154,
            mantissa: 0xffffffe0_00000555_55545555_55888888_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -154,
            mantissa: 0xbfffffee_0000023f_ffffaf00_000c2666_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -155,
            mantissa: 0xfffffff0_00000155_55553555_55588889_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Neg,
            exponent: -156,
            mantissa: 0xfffffff8_00000055_55555155_55558889_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: 0,
            mantissa: 0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -155,
            mantissa: 0x80000004_0000002a_aaaaacaa_aaaac444_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -154,
            mantissa: 0x80000008_000000aa_aaaabaaa_aaac4444_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -154,
            mantissa: 0xc0000012_00000240_00005100_000c2666_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -153,
            mantissa: 0x80000010_000002aa_aaab2aaa_aac44444_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -153,
            mantissa: 0xa0000019_00000535_55568dd5_55a37555_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -153,
            mantissa: 0xc0000024_00000900_00028800_00c26667_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -153,
            mantissa: 0xe0000031_00000e4a_aaaf5b2a_ac4ed778_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -152,
            mantissa: 0x80000020_00000aaa_aaaeaaaa_ac444445_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -152,
            mantissa: 0x90000028_80000f30_00066840_02e21cce_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -152,
            mantissa: 0xa0000032_000014d5_555f1955_5a375558_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -152,
            mantissa: 0xb000003c_80001bba_aab8f6ea_b287cde2_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -152,
            mantissa: 0xc0000048_00002400_00144000_0c26666e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -152,
            mantissa: 0xd0000054_80002dc5_55713995_67767efb_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -152,
            mantissa: 0xe0000062_0000392a_aad02eaa_c4ed778b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -152,
            mantissa: 0xf0000070_80004650_00317040_2514301d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0x80000040_00002aaa_aacaaaaa_c444445a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0x88000048_4000332d_557e1d75_77ff70a7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0x90000051_00003cc0_00334200_2e21ccf8_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0x9800005a_40004772_aaea4cca_e71e494d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xa0000064_00005355_55a37555_a37555a7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xa800006e_40006078_005ef620_63b5a207_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xb0000079_00006eea_ab1d0cab_287cde6e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xb8000084_40007ebd_55ddf975_f2787ade_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xc0000090_00009000_00a20000_c2666759_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xc800009c_4000a2c2_ab6966cb_9915d3e1_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xd00000a9_0000b715_56347756_7767f078_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xd80000b6_4000cd08_01037e21_5e50ad20_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xe00000c4_0000e4aa_abd6caac_4ed779dc_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xe80000d2_4000fe0d_56aeaf77_4a1806b0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xf00000e1_00011940_018b8202_5143039f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -151,
            mantissa: 0xf80000f0_40013652_ac6d9acd_659ee0ad_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0x80000080_0000aaaa_abaaaaac_444446ef_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0x84000088_2000bb2c_01218811_ddba1d9b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0x88000090_8000ccb5_569b9657_7ff70c5f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0x8c000099_2000df4e_ac1907bd_2bcd8b3b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0x900000a2_0000f300_019a1002_e21cd235_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0x940000ab_200107d1_571ee468_a3d1394e_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0x980000b4_80011dca_aca7bbae_71e4988b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0x9c0000be_200134f4_0234ce14_4d5ea7f0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xa00000c8_00014d55_57c6555a_37555f82_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xa40000d2_200166f6_ad5c8cc0_30ed5744_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xa80000dc_800181e0_02f7b106_3b5a273b_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xac0000e7_20019e19_5898006c_57dec76f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xb00000f2_0001bbaa_ae3dbab2_87cdefe3_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xb40000fd_2001da9c_03e92118_cc8a789f_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xb8000108_8001faf5_599a765f_2787b9aa_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xbc000114_20021cbe_af51fec5_9a49eb0a_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xc0000120_00024000_0510000c_266684c6_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xc400012c_200264c1_5ad4c172_cd849ee9_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xc8000138_80028b0a_b0a08bb9_915d5179_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xcc000145_2002b2e4_0673a920_73bc1480_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xd0000152_0002dc55_5c4e6567_767f2009_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xd400015f_20030766_b2310dce_9b97cc1d_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xd800016c_80033420_081bf115_e50af0c7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xdc00017a_20036289_5e0f5f7d_54f14614_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xe0000188_000392aa_b40baac4_ed77c410_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xe4000196_2003c48c_0a11262c_b0e002c7_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xe80001a4_8003f835_60202674_a1809a47_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xec0001b3_20042dae_b63901dc_c1c582a0_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xf00001c2_00046500_0c5c1025_143073df_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xf40001d1_20049e31_6289aa8d_9b594616_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xf80001e0_8004d94a_b8c22bd6_59ee5155_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -150,
            mantissa: 0xfc0001f0_20051654_0f05f03f_52b4cdae_u128,
        },
        DyadicFloat128 {
            sign: DyadicSign::Pos,
            exponent: -149,
            mantissa: 0x80000100_0002aaaa_b2aaaac4_4444999a_u128,
        },
    ];
