/* gitg-diff-image-side-by-side.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-image-side-by-side.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2016 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include "libgitg.h"

#define GITG_DIFF_IMAGE_SIDE_BY_SIDE_TEXT_SPACING 6
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE (gitg_diff_image_side_by_side_get_type ())
#define GITG_DIFF_IMAGE_SIDE_BY_SIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySide))
#define GITG_DIFF_IMAGE_SIDE_BY_SIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySideClass))
#define GITG_IS_DIFF_IMAGE_SIDE_BY_SIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE))
#define GITG_IS_DIFF_IMAGE_SIDE_BY_SIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE))
#define GITG_DIFF_IMAGE_SIDE_BY_SIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySideClass))

typedef struct _GitgDiffImageSideBySide GitgDiffImageSideBySide;
typedef struct _GitgDiffImageSideBySideClass GitgDiffImageSideBySideClass;
typedef struct _GitgDiffImageSideBySidePrivate GitgDiffImageSideBySidePrivate;

#define GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE (gitg_diff_image_surface_cache_get_type ())
#define GITG_DIFF_IMAGE_SURFACE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE, GitgDiffImageSurfaceCache))
#define GITG_IS_DIFF_IMAGE_SURFACE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE))
#define GITG_DIFF_IMAGE_SURFACE_CACHE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE, GitgDiffImageSurfaceCacheIface))

typedef struct _GitgDiffImageSurfaceCache GitgDiffImageSurfaceCache;
typedef struct _GitgDiffImageSurfaceCacheIface GitgDiffImageSurfaceCacheIface;
enum  {
	GITG_DIFF_IMAGE_SIDE_BY_SIDE_0_PROPERTY,
	GITG_DIFF_IMAGE_SIDE_BY_SIDE_CACHE_PROPERTY,
	GITG_DIFF_IMAGE_SIDE_BY_SIDE_SPACING_PROPERTY,
	GITG_DIFF_IMAGE_SIDE_BY_SIDE_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_image_side_by_side_properties[GITG_DIFF_IMAGE_SIDE_BY_SIDE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_DIFF_IMAGE_SIDE_BY_SIDE_TYPE_SIZING (gitg_diff_image_side_by_side_sizing_get_type ())
typedef struct _GitgDiffImageSideBySideSizing GitgDiffImageSideBySideSizing;

#define GITG_DIFF_IMAGE_SIDE_BY_SIDE_TYPE_SIZE (gitg_diff_image_side_by_side_size_get_type ())
typedef struct _GitgDiffImageSideBySideSize GitgDiffImageSideBySideSize;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GitgDiffImageSideBySide {
	GtkDrawingArea parent_instance;
	GitgDiffImageSideBySidePrivate * priv;
};

struct _GitgDiffImageSideBySideClass {
	GtkDrawingAreaClass parent_class;
};

struct _GitgDiffImageSurfaceCacheIface {
	GTypeInterface parent_iface;
	cairo_surface_t* (*get_old_surface) (GitgDiffImageSurfaceCache* self, GdkWindow* window);
	cairo_surface_t* (*get_new_surface) (GitgDiffImageSurfaceCache* self, GdkWindow* window);
	GdkPixbuf* (*get_old_pixbuf) (GitgDiffImageSurfaceCache* self);
	void (*set_old_pixbuf) (GitgDiffImageSurfaceCache* self, GdkPixbuf* value);
	GdkPixbuf* (*get_new_pixbuf) (GitgDiffImageSurfaceCache* self);
	void (*set_new_pixbuf) (GitgDiffImageSurfaceCache* self, GdkPixbuf* value);
	GdkWindow* (*get_window) (GitgDiffImageSurfaceCache* self);
	void (*set_window) (GitgDiffImageSurfaceCache* self, GdkWindow* value);
};

struct _GitgDiffImageSideBySidePrivate {
	PangoLayout* d_old_size_layout;
	PangoLayout* d_new_size_layout;
	GitgDiffImageSurfaceCache* _cache;
	gint _spacing;
};

struct _GitgDiffImageSideBySideSize {
	gint width;
	gint image_width;
	gint image_height;
};

struct _GitgDiffImageSideBySideSizing {
	GitgDiffImageSideBySideSize old_size;
	GitgDiffImageSideBySideSize new_size;
};

static gint GitgDiffImageSideBySide_private_offset;
static gpointer gitg_diff_image_side_by_side_parent_class = NULL;

VALA_EXTERN GType gitg_diff_image_side_by_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_image_surface_cache_get_type (void) G_GNUC_CONST ;
static GType gitg_diff_image_side_by_side_sizing_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType gitg_diff_image_side_by_side_size_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgDiffImageSideBySideSize* gitg_diff_image_side_by_side_size_dup (const GitgDiffImageSideBySideSize* self);
static void gitg_diff_image_side_by_side_size_free (GitgDiffImageSideBySideSize* self);
static GitgDiffImageSideBySideSizing* gitg_diff_image_side_by_side_sizing_dup (const GitgDiffImageSideBySideSizing* self);
static void gitg_diff_image_side_by_side_sizing_free (GitgDiffImageSideBySideSizing* self);
static void gitg_diff_image_side_by_side_get_sizing (GitgDiffImageSideBySide* self,
                                              gint width,
                                              GitgDiffImageSideBySideSizing* result);
VALA_EXTERN GitgDiffImageSurfaceCache* gitg_diff_image_side_by_side_get_cache (GitgDiffImageSideBySide* self);
VALA_EXTERN GdkPixbuf* gitg_diff_image_surface_cache_get_old_pixbuf (GitgDiffImageSurfaceCache* self);
VALA_EXTERN GdkPixbuf* gitg_diff_image_surface_cache_get_new_pixbuf (GitgDiffImageSurfaceCache* self);
VALA_EXTERN cairo_surface_t* gitg_diff_image_surface_cache_get_old_surface (GitgDiffImageSurfaceCache* self,
                                                                GdkWindow* window);
VALA_EXTERN cairo_surface_t* gitg_diff_image_surface_cache_get_new_surface (GitgDiffImageSurfaceCache* self,
                                                                GdkWindow* window);
VALA_EXTERN gint gitg_diff_image_side_by_side_get_spacing (GitgDiffImageSideBySide* self);
static void gitg_diff_image_side_by_side_real_style_updated (GtkWidget* base);
static void gitg_diff_image_side_by_side_real_get_preferred_height_for_width (GtkWidget* base,
                                                                       gint width,
                                                                       gint* minimum_height,
                                                                       gint* natural_height);
static PangoLayout* gitg_diff_image_side_by_side_get_old_size_layout (GitgDiffImageSideBySide* self);
static PangoLayout* gitg_diff_image_side_by_side_get_new_size_layout (GitgDiffImageSideBySide* self);
static GtkSizeRequestMode gitg_diff_image_side_by_side_real_get_request_mode (GtkWidget* base);
static gboolean gitg_diff_image_side_by_side_real_draw (GtkWidget* base,
                                                 cairo_t* cr);
static void gitg_diff_image_side_by_side_real_realize (GtkWidget* base);
VALA_EXTERN GitgDiffImageSideBySide* gitg_diff_image_side_by_side_new (void);
VALA_EXTERN GitgDiffImageSideBySide* gitg_diff_image_side_by_side_construct (GType object_type);
VALA_EXTERN void gitg_diff_image_side_by_side_set_cache (GitgDiffImageSideBySide* self,
                                             GitgDiffImageSurfaceCache* value);
VALA_EXTERN void gitg_diff_image_side_by_side_set_spacing (GitgDiffImageSideBySide* self,
                                               gint value);
static void gitg_diff_image_side_by_side_finalize (GObject * obj);
static GType gitg_diff_image_side_by_side_get_type_once (void);
static void _vala_gitg_diff_image_side_by_side_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_gitg_diff_image_side_by_side_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);

static inline gpointer
gitg_diff_image_side_by_side_get_instance_private (GitgDiffImageSideBySide* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffImageSideBySide_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gitg_diff_image_side_by_side_get_sizing (GitgDiffImageSideBySide* self,
                                         gint width,
                                         GitgDiffImageSideBySideSizing* result)
{
	gdouble ow = 0.0;
	gdouble oh = 0.0;
	gdouble nw = 0.0;
	gdouble nh = 0.0;
	GdkPixbuf* old_pixbuf = NULL;
	GitgDiffImageSurfaceCache* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* new_pixbuf = NULL;
	GitgDiffImageSurfaceCache* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkWindow* window = NULL;
	GdkWindow* _tmp8_;
	GdkWindow* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp20_;
	gdouble tw = 0.0;
	gint _tmp30_;
	gdouble osw = 0.0;
	gdouble nsw = 0.0;
	gdouble oswi = 0.0;
	gdouble nswi = 0.0;
	gdouble oshi = 0.0;
	gdouble nshi = 0.0;
	GitgDiffImageSideBySideSize _tmp31_ = {0};
	GitgDiffImageSideBySideSize _tmp32_ = {0};
	GitgDiffImageSideBySideSizing _tmp33_ = {0};
	g_return_if_fail (self != NULL);
	ow = (gdouble) 0;
	oh = (gdouble) 0;
	nw = (gdouble) 0;
	nh = (gdouble) 0;
	_tmp0_ = self->priv->_cache;
	_tmp1_ = gitg_diff_image_surface_cache_get_old_pixbuf (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	old_pixbuf = _tmp3_;
	_tmp4_ = self->priv->_cache;
	_tmp5_ = gitg_diff_image_surface_cache_get_new_pixbuf (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	new_pixbuf = _tmp7_;
	_tmp8_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	window = _tmp9_;
	_tmp10_ = old_pixbuf;
	if (_tmp10_ != NULL) {
		gdouble xscale = 0.0;
		gdouble yscale = 0.0;
		GdkWindow* _tmp11_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		xscale = (gdouble) 1;
		yscale = (gdouble) 1;
		_tmp11_ = window;
		if (_tmp11_ != NULL) {
			GitgDiffImageSurfaceCache* _tmp12_;
			GdkWindow* _tmp13_;
			cairo_surface_t* _tmp14_;
			cairo_surface_t* _tmp15_;
			gdouble _tmp16_ = 0.0;
			gdouble _tmp17_ = 0.0;
			_tmp12_ = self->priv->_cache;
			_tmp13_ = gtk_widget_get_window ((GtkWidget*) self);
			_tmp14_ = gitg_diff_image_surface_cache_get_old_surface (_tmp12_, _tmp13_);
			_tmp15_ = _tmp14_;
			cairo_surface_get_device_scale (_tmp15_, &_tmp16_, &_tmp17_);
			xscale = _tmp16_;
			yscale = _tmp17_;
			_cairo_surface_destroy0 (_tmp15_);
		}
		_tmp18_ = old_pixbuf;
		ow = ((gdouble) gdk_pixbuf_get_width (_tmp18_)) / xscale;
		_tmp19_ = old_pixbuf;
		oh = ((gdouble) gdk_pixbuf_get_height (_tmp19_)) / yscale;
	}
	_tmp20_ = new_pixbuf;
	if (_tmp20_ != NULL) {
		gdouble xscale = 0.0;
		gdouble yscale = 0.0;
		GdkWindow* _tmp21_;
		GdkPixbuf* _tmp28_;
		GdkPixbuf* _tmp29_;
		xscale = (gdouble) 1;
		yscale = (gdouble) 1;
		_tmp21_ = window;
		if (_tmp21_ != NULL) {
			GitgDiffImageSurfaceCache* _tmp22_;
			GdkWindow* _tmp23_;
			cairo_surface_t* _tmp24_;
			cairo_surface_t* _tmp25_;
			gdouble _tmp26_ = 0.0;
			gdouble _tmp27_ = 0.0;
			_tmp22_ = self->priv->_cache;
			_tmp23_ = gtk_widget_get_window ((GtkWidget*) self);
			_tmp24_ = gitg_diff_image_surface_cache_get_new_surface (_tmp22_, _tmp23_);
			_tmp25_ = _tmp24_;
			cairo_surface_get_device_scale (_tmp25_, &_tmp26_, &_tmp27_);
			xscale = _tmp26_;
			yscale = _tmp27_;
			_cairo_surface_destroy0 (_tmp25_);
		}
		_tmp28_ = new_pixbuf;
		nw = ((gdouble) gdk_pixbuf_get_width (_tmp28_)) / xscale;
		_tmp29_ = new_pixbuf;
		nh = ((gdouble) gdk_pixbuf_get_height (_tmp29_)) / yscale;
	}
	tw = ow + nw;
	_tmp30_ = self->priv->_spacing;
	width = width - _tmp30_;
	osw = (gdouble) 0;
	nsw = (gdouble) 0;
	if (tw != ((gdouble) 0)) {
		if (ow != ((gdouble) 0)) {
			osw = width * (ow / tw);
		}
		if (nw != ((gdouble) 0)) {
			nsw = width * (nw / tw);
		}
	}
	oswi = MIN (osw, ow);
	nswi = MIN (nsw, nw);
	oshi = (gdouble) 0;
	nshi = (gdouble) 0;
	if (ow != ((gdouble) 0)) {
		oshi = (oswi / ow) * oh;
	}
	if (nw != ((gdouble) 0)) {
		nshi = (nswi / nw) * nh;
	}
	memset (&_tmp31_, 0, sizeof (GitgDiffImageSideBySideSize));
	_tmp31_.width = (gint) osw;
	_tmp31_.image_width = (gint) oswi;
	_tmp31_.image_height = (gint) oshi;
	memset (&_tmp32_, 0, sizeof (GitgDiffImageSideBySideSize));
	_tmp32_.width = (gint) nsw;
	_tmp32_.image_width = (gint) nswi;
	_tmp32_.image_height = (gint) nshi;
	memset (&_tmp33_, 0, sizeof (GitgDiffImageSideBySideSizing));
	_tmp33_.old_size = _tmp31_;
	_tmp33_.new_size = _tmp32_;
	*result = _tmp33_;
	_g_object_unref0 (window);
	_g_object_unref0 (new_pixbuf);
	_g_object_unref0 (old_pixbuf);
	return;
}

static void
gitg_diff_image_side_by_side_real_style_updated (GtkWidget* base)
{
	GitgDiffImageSideBySide * self;
	self = (GitgDiffImageSideBySide*) base;
	_g_object_unref0 (self->priv->d_old_size_layout);
	self->priv->d_old_size_layout = NULL;
	_g_object_unref0 (self->priv->d_new_size_layout);
	self->priv->d_new_size_layout = NULL;
}

static void
gitg_diff_image_side_by_side_real_get_preferred_height_for_width (GtkWidget* base,
                                                                  gint width,
                                                                  gint* minimum_height,
                                                                  gint* natural_height)
{
	GitgDiffImageSideBySide * self;
	gint _vala_minimum_height = 0;
	gint _vala_natural_height = 0;
	GitgDiffImageSideBySideSizing sizing = {0};
	GitgDiffImageSideBySideSizing _tmp0_ = {0};
	gdouble h = 0.0;
	GitgDiffImageSideBySideSizing _tmp1_;
	GitgDiffImageSideBySideSize _tmp2_;
	GitgDiffImageSideBySideSizing _tmp3_;
	GitgDiffImageSideBySideSize _tmp4_;
	PangoLayout* ol = NULL;
	PangoLayout* _tmp5_;
	PangoLayout* _tmp6_;
	PangoLayout* _tmp7_;
	PangoLayout* nl = NULL;
	PangoLayout* _tmp8_;
	PangoLayout* _tmp9_;
	PangoLayout* _tmp10_;
	gint osw = 0;
	gint osh = 0;
	gint nsw = 0;
	gint nsh = 0;
	PangoLayout* _tmp11_;
	PangoLayout* _tmp15_;
	self = (GitgDiffImageSideBySide*) base;
	gitg_diff_image_side_by_side_get_sizing (self, width, &_tmp0_);
	sizing = _tmp0_;
	_tmp1_ = sizing;
	_tmp2_ = _tmp1_.old_size;
	_tmp3_ = sizing;
	_tmp4_ = _tmp3_.new_size;
	h = MAX ((gdouble) _tmp2_.image_height, (gdouble) _tmp4_.image_height);
	_tmp5_ = gitg_diff_image_side_by_side_get_old_size_layout (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	ol = _tmp7_;
	_tmp8_ = gitg_diff_image_side_by_side_get_new_size_layout (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	nl = _tmp10_;
	osw = 0;
	osh = 0;
	nsw = 0;
	nsh = 0;
	_tmp11_ = ol;
	if (_tmp11_ != NULL) {
		PangoLayout* _tmp12_;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp12_ = ol;
		pango_layout_get_pixel_size (_tmp12_, &_tmp13_, &_tmp14_);
		osw = _tmp13_;
		osh = _tmp14_;
	}
	_tmp15_ = nl;
	if (_tmp15_ != NULL) {
		PangoLayout* _tmp16_;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		_tmp16_ = nl;
		pango_layout_get_pixel_size (_tmp16_, &_tmp17_, &_tmp18_);
		nsw = _tmp17_;
		nsh = _tmp18_;
	}
	h += (gdouble) (GITG_DIFF_IMAGE_SIDE_BY_SIDE_TEXT_SPACING + MAX (osh, nsh));
	_vala_minimum_height = (gint) h;
	_vala_natural_height = (gint) h;
	_g_object_unref0 (nl);
	_g_object_unref0 (ol);
	if (minimum_height) {
		*minimum_height = _vala_minimum_height;
	}
	if (natural_height) {
		*natural_height = _vala_natural_height;
	}
}

static GtkSizeRequestMode
gitg_diff_image_side_by_side_real_get_request_mode (GtkWidget* base)
{
	GitgDiffImageSideBySide * self;
	GtkSizeRequestMode result;
	self = (GitgDiffImageSideBySide*) base;
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}

static gboolean
gitg_diff_image_side_by_side_real_draw (GtkWidget* base,
                                        cairo_t* cr)
{
	GitgDiffImageSideBySide * self;
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp2_ = {0};
	GitgDiffImageSideBySideSizing sizing = {0};
	GtkAllocation _tmp3_;
	GitgDiffImageSideBySideSizing _tmp4_ = {0};
	cairo_surface_t* old_surface = NULL;
	GitgDiffImageSurfaceCache* _tmp5_;
	GdkWindow* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* new_surface = NULL;
	GitgDiffImageSurfaceCache* _tmp8_;
	GdkWindow* _tmp9_;
	cairo_surface_t* _tmp10_;
	GtkStyleContext* ctx = NULL;
	GtkStyleContext* _tmp11_;
	GtkStyleContext* _tmp12_;
	GtkStyleContext* _tmp13_;
	GtkAllocation _tmp14_;
	GtkAllocation _tmp15_;
	GtkAllocation _tmp16_;
	GtkAllocation _tmp17_;
	gdouble max_height = 0.0;
	GitgDiffImageSideBySideSizing _tmp18_;
	GitgDiffImageSideBySideSize _tmp19_;
	GitgDiffImageSideBySideSizing _tmp20_;
	GitgDiffImageSideBySideSize _tmp21_;
	gdouble spread_factor = 0.0;
	gboolean _tmp22_ = FALSE;
	cairo_surface_t* _tmp23_;
	cairo_surface_t* _tmp25_;
	cairo_surface_t* _tmp44_;
	gboolean result;
	self = (GitgDiffImageSideBySide*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = alloc;
	gitg_diff_image_side_by_side_get_sizing (self, _tmp3_.width, &_tmp4_);
	sizing = _tmp4_;
	_tmp5_ = self->priv->_cache;
	_tmp6_ = window;
	_tmp7_ = gitg_diff_image_surface_cache_get_old_surface (_tmp5_, _tmp6_);
	old_surface = _tmp7_;
	_tmp8_ = self->priv->_cache;
	_tmp9_ = window;
	_tmp10_ = gitg_diff_image_surface_cache_get_new_surface (_tmp8_, _tmp9_);
	new_surface = _tmp10_;
	_tmp11_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	ctx = _tmp12_;
	_tmp13_ = ctx;
	_tmp14_ = alloc;
	_tmp15_ = alloc;
	_tmp16_ = alloc;
	_tmp17_ = alloc;
	gtk_render_background (_tmp13_, cr, (gdouble) _tmp14_.x, (gdouble) _tmp15_.y, (gdouble) _tmp16_.width, (gdouble) _tmp17_.height);
	_tmp18_ = sizing;
	_tmp19_ = _tmp18_.old_size;
	_tmp20_ = sizing;
	_tmp21_ = _tmp20_.new_size;
	max_height = MAX ((gdouble) _tmp19_.image_height, (gdouble) _tmp21_.image_height);
	spread_factor = 0.5;
	_tmp23_ = old_surface;
	if (_tmp23_ != NULL) {
		cairo_surface_t* _tmp24_;
		_tmp24_ = new_surface;
		_tmp22_ = _tmp24_ != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		spread_factor = 2.0 / 3.0;
	}
	_tmp25_ = old_surface;
	if (_tmp25_ != NULL) {
		gdouble x = 0.0;
		GitgDiffImageSideBySideSizing _tmp26_;
		GitgDiffImageSideBySideSize _tmp27_;
		GitgDiffImageSideBySideSizing _tmp28_;
		GitgDiffImageSideBySideSize _tmp29_;
		gdouble y = 0.0;
		GitgDiffImageSideBySideSizing _tmp30_;
		GitgDiffImageSideBySideSize _tmp31_;
		cairo_surface_t* _tmp32_;
		PangoRectangle rect = {0};
		PangoLayout* _tmp33_;
		PangoLayout* _tmp34_;
		PangoRectangle _tmp35_ = {0};
		GtkStyleContext* _tmp36_;
		PangoRectangle _tmp37_;
		GitgDiffImageSideBySideSizing _tmp38_;
		GitgDiffImageSideBySideSize _tmp39_;
		PangoRectangle _tmp40_;
		PangoRectangle _tmp41_;
		PangoLayout* _tmp42_;
		PangoLayout* _tmp43_;
		_tmp26_ = sizing;
		_tmp27_ = _tmp26_.old_size;
		_tmp28_ = sizing;
		_tmp29_ = _tmp28_.old_size;
		x = (_tmp27_.width - _tmp29_.image_width) * spread_factor;
		_tmp30_ = sizing;
		_tmp31_ = _tmp30_.old_size;
		y = (max_height - _tmp31_.image_height) / 2;
		_tmp32_ = old_surface;
		cairo_set_source_surface (cr, _tmp32_, x, y);
		cairo_paint (cr);
		_tmp33_ = gitg_diff_image_side_by_side_get_old_size_layout (self);
		_tmp34_ = _tmp33_;
		pango_layout_get_pixel_extents (_tmp34_, NULL, &_tmp35_);
		rect = _tmp35_;
		_tmp36_ = ctx;
		_tmp37_ = rect;
		_tmp38_ = sizing;
		_tmp39_ = _tmp38_.old_size;
		_tmp40_ = rect;
		_tmp41_ = rect;
		_tmp42_ = gitg_diff_image_side_by_side_get_old_size_layout (self);
		_tmp43_ = _tmp42_;
		gtk_render_layout (_tmp36_, cr, (x + _tmp37_.x) + ((_tmp39_.image_width - _tmp40_.width) / 2), (_tmp41_.y + max_height) + GITG_DIFF_IMAGE_SIDE_BY_SIDE_TEXT_SPACING, _tmp43_);
	}
	_tmp44_ = new_surface;
	if (_tmp44_ != NULL) {
		gdouble x = 0.0;
		GitgDiffImageSideBySideSizing _tmp45_;
		GitgDiffImageSideBySideSize _tmp46_;
		GitgDiffImageSideBySideSizing _tmp47_;
		GitgDiffImageSideBySideSize _tmp48_;
		gdouble y = 0.0;
		GitgDiffImageSideBySideSizing _tmp49_;
		GitgDiffImageSideBySideSize _tmp50_;
		GitgDiffImageSurfaceCache* _tmp51_;
		GdkPixbuf* _tmp52_;
		GdkPixbuf* _tmp53_;
		cairo_surface_t* _tmp57_;
		PangoRectangle rect = {0};
		PangoLayout* _tmp58_;
		PangoLayout* _tmp59_;
		PangoRectangle _tmp60_ = {0};
		GtkStyleContext* _tmp61_;
		PangoRectangle _tmp62_;
		GitgDiffImageSideBySideSizing _tmp63_;
		GitgDiffImageSideBySideSize _tmp64_;
		PangoRectangle _tmp65_;
		PangoRectangle _tmp66_;
		PangoLayout* _tmp67_;
		PangoLayout* _tmp68_;
		_tmp45_ = sizing;
		_tmp46_ = _tmp45_.new_size;
		_tmp47_ = sizing;
		_tmp48_ = _tmp47_.new_size;
		x = (_tmp46_.width - _tmp48_.image_width) * (1.0 - spread_factor);
		_tmp49_ = sizing;
		_tmp50_ = _tmp49_.new_size;
		y = (max_height - _tmp50_.image_height) / 2;
		_tmp51_ = self->priv->_cache;
		_tmp52_ = gitg_diff_image_surface_cache_get_old_pixbuf (_tmp51_);
		_tmp53_ = _tmp52_;
		if (_tmp53_ != NULL) {
			GitgDiffImageSideBySideSizing _tmp54_;
			GitgDiffImageSideBySideSize _tmp55_;
			gint _tmp56_;
			_tmp54_ = sizing;
			_tmp55_ = _tmp54_.old_size;
			_tmp56_ = self->priv->_spacing;
			x += (gdouble) (_tmp55_.width + _tmp56_);
		}
		_tmp57_ = new_surface;
		cairo_set_source_surface (cr, _tmp57_, x, y);
		cairo_paint (cr);
		_tmp58_ = gitg_diff_image_side_by_side_get_new_size_layout (self);
		_tmp59_ = _tmp58_;
		pango_layout_get_pixel_extents (_tmp59_, NULL, &_tmp60_);
		rect = _tmp60_;
		_tmp61_ = ctx;
		_tmp62_ = rect;
		_tmp63_ = sizing;
		_tmp64_ = _tmp63_.new_size;
		_tmp65_ = rect;
		_tmp66_ = rect;
		_tmp67_ = gitg_diff_image_side_by_side_get_new_size_layout (self);
		_tmp68_ = _tmp67_;
		gtk_render_layout (_tmp61_, cr, (x + _tmp62_.x) + ((_tmp64_.image_width - _tmp65_.width) / 2), (_tmp66_.y + max_height) + GITG_DIFF_IMAGE_SIDE_BY_SIDE_TEXT_SPACING, _tmp68_);
	}
	result = TRUE;
	_g_object_unref0 (ctx);
	_cairo_surface_destroy0 (new_surface);
	_cairo_surface_destroy0 (old_surface);
	_g_object_unref0 (window);
	return result;
}

static void
gitg_diff_image_side_by_side_real_realize (GtkWidget* base)
{
	GitgDiffImageSideBySide * self;
	self = (GitgDiffImageSideBySide*) base;
	GTK_WIDGET_CLASS (gitg_diff_image_side_by_side_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea));
	gtk_widget_queue_resize ((GtkWidget*) self);
}

GitgDiffImageSideBySide*
gitg_diff_image_side_by_side_construct (GType object_type)
{
	GitgDiffImageSideBySide * self = NULL;
	self = (GitgDiffImageSideBySide*) g_object_new (object_type, NULL);
	return self;
}

GitgDiffImageSideBySide*
gitg_diff_image_side_by_side_new (void)
{
	return gitg_diff_image_side_by_side_construct (GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE);
}

static PangoLayout*
gitg_diff_image_side_by_side_get_old_size_layout (GitgDiffImageSideBySide* self)
{
	PangoLayout* result;
	gboolean _tmp0_ = FALSE;
	PangoLayout* _tmp1_;
	PangoLayout* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->d_old_size_layout;
	if (_tmp1_ == NULL) {
		GitgDiffImageSurfaceCache* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp2_ = self->priv->_cache;
		_tmp3_ = gitg_diff_image_surface_cache_get_old_pixbuf (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* message = NULL;
		GitgDiffImageSurfaceCache* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GitgDiffImageSurfaceCache* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GitgDiffImageSurfaceCache* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		_tmp5_ = self->priv->_cache;
		_tmp6_ = gitg_diff_image_surface_cache_get_old_pixbuf (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%i", gdk_pixbuf_get_width (_tmp7_));
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_cache;
		_tmp11_ = gitg_diff_image_surface_cache_get_old_pixbuf (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("%i", gdk_pixbuf_get_height (_tmp12_));
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp9_, " × ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp9_);
		message = _tmp16_;
		_tmp17_ = self->priv->_cache;
		_tmp18_ = gitg_diff_image_surface_cache_get_new_pixbuf (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ != NULL) {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			PangoLayout* _tmp23_;
			_tmp20_ = message;
			_tmp21_ = g_strdup_printf (_ ("before (%s)"), _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp22_);
			_g_object_unref0 (self->priv->d_old_size_layout);
			self->priv->d_old_size_layout = _tmp23_;
			_g_free0 (_tmp22_);
		} else {
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			PangoLayout* _tmp27_;
			_tmp24_ = message;
			_tmp25_ = g_strdup_printf (_ ("removed (%s)"), _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp26_);
			_g_object_unref0 (self->priv->d_old_size_layout);
			self->priv->d_old_size_layout = _tmp27_;
			_g_free0 (_tmp26_);
		}
		_g_free0 (message);
	}
	_tmp28_ = self->priv->d_old_size_layout;
	result = _tmp28_;
	return result;
}

static PangoLayout*
gitg_diff_image_side_by_side_get_new_size_layout (GitgDiffImageSideBySide* self)
{
	PangoLayout* result;
	gboolean _tmp0_ = FALSE;
	PangoLayout* _tmp1_;
	PangoLayout* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->d_new_size_layout;
	if (_tmp1_ == NULL) {
		GitgDiffImageSurfaceCache* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp2_ = self->priv->_cache;
		_tmp3_ = gitg_diff_image_surface_cache_get_new_pixbuf (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* message = NULL;
		GitgDiffImageSurfaceCache* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GitgDiffImageSurfaceCache* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GitgDiffImageSurfaceCache* _tmp17_;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		_tmp5_ = self->priv->_cache;
		_tmp6_ = gitg_diff_image_surface_cache_get_new_pixbuf (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%i", gdk_pixbuf_get_width (_tmp7_));
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_cache;
		_tmp11_ = gitg_diff_image_surface_cache_get_new_pixbuf (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup_printf ("%i", gdk_pixbuf_get_height (_tmp12_));
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp9_, " × ", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp9_);
		message = _tmp16_;
		_tmp17_ = self->priv->_cache;
		_tmp18_ = gitg_diff_image_surface_cache_get_old_pixbuf (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ != NULL) {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			PangoLayout* _tmp23_;
			_tmp20_ = message;
			_tmp21_ = g_strdup_printf (_ ("after (%s)"), _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp22_);
			_g_object_unref0 (self->priv->d_new_size_layout);
			self->priv->d_new_size_layout = _tmp23_;
			_g_free0 (_tmp22_);
		} else {
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			PangoLayout* _tmp27_;
			_tmp24_ = message;
			_tmp25_ = g_strdup_printf (_ ("added (%s)"), _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp26_);
			_g_object_unref0 (self->priv->d_new_size_layout);
			self->priv->d_new_size_layout = _tmp27_;
			_g_free0 (_tmp26_);
		}
		_g_free0 (message);
	}
	_tmp28_ = self->priv->d_new_size_layout;
	result = _tmp28_;
	return result;
}

GitgDiffImageSurfaceCache*
gitg_diff_image_side_by_side_get_cache (GitgDiffImageSideBySide* self)
{
	GitgDiffImageSurfaceCache* result;
	GitgDiffImageSurfaceCache* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cache;
	result = _tmp0_;
	return result;
}

void
gitg_diff_image_side_by_side_set_cache (GitgDiffImageSideBySide* self,
                                        GitgDiffImageSurfaceCache* value)
{
	GitgDiffImageSurfaceCache* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_image_side_by_side_get_cache (self);
	if (old_value != value) {
		GitgDiffImageSurfaceCache* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cache);
		self->priv->_cache = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_image_side_by_side_properties[GITG_DIFF_IMAGE_SIDE_BY_SIDE_CACHE_PROPERTY]);
	}
}

gint
gitg_diff_image_side_by_side_get_spacing (GitgDiffImageSideBySide* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_spacing;
	return result;
}

void
gitg_diff_image_side_by_side_set_spacing (GitgDiffImageSideBySide* self,
                                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_image_side_by_side_get_spacing (self);
	if (old_value != value) {
		self->priv->_spacing = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_image_side_by_side_properties[GITG_DIFF_IMAGE_SIDE_BY_SIDE_SPACING_PROPERTY]);
	}
}

static GitgDiffImageSideBySideSize*
gitg_diff_image_side_by_side_size_dup (const GitgDiffImageSideBySideSize* self)
{
	GitgDiffImageSideBySideSize* dup;
	dup = g_new0 (GitgDiffImageSideBySideSize, 1);
	memcpy (dup, self, sizeof (GitgDiffImageSideBySideSize));
	return dup;
}

static void
gitg_diff_image_side_by_side_size_free (GitgDiffImageSideBySideSize* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_image_side_by_side_size_get_type_once (void)
{
	GType gitg_diff_image_side_by_side_size_type_id;
	gitg_diff_image_side_by_side_size_type_id = g_boxed_type_register_static ("GitgDiffImageSideBySideSize", (GBoxedCopyFunc) gitg_diff_image_side_by_side_size_dup, (GBoxedFreeFunc) gitg_diff_image_side_by_side_size_free);
	return gitg_diff_image_side_by_side_size_type_id;
}

static GType
gitg_diff_image_side_by_side_size_get_type (void)
{
	static gsize gitg_diff_image_side_by_side_size_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_image_side_by_side_size_type_id__once)) {
		GType gitg_diff_image_side_by_side_size_type_id;
		gitg_diff_image_side_by_side_size_type_id = gitg_diff_image_side_by_side_size_get_type_once ();
		g_once_init_leave (&gitg_diff_image_side_by_side_size_type_id__once, gitg_diff_image_side_by_side_size_type_id);
	}
	return gitg_diff_image_side_by_side_size_type_id__once;
}

static GitgDiffImageSideBySideSizing*
gitg_diff_image_side_by_side_sizing_dup (const GitgDiffImageSideBySideSizing* self)
{
	GitgDiffImageSideBySideSizing* dup;
	dup = g_new0 (GitgDiffImageSideBySideSizing, 1);
	memcpy (dup, self, sizeof (GitgDiffImageSideBySideSizing));
	return dup;
}

static void
gitg_diff_image_side_by_side_sizing_free (GitgDiffImageSideBySideSizing* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_image_side_by_side_sizing_get_type_once (void)
{
	GType gitg_diff_image_side_by_side_sizing_type_id;
	gitg_diff_image_side_by_side_sizing_type_id = g_boxed_type_register_static ("GitgDiffImageSideBySideSizing", (GBoxedCopyFunc) gitg_diff_image_side_by_side_sizing_dup, (GBoxedFreeFunc) gitg_diff_image_side_by_side_sizing_free);
	return gitg_diff_image_side_by_side_sizing_type_id;
}

static GType
gitg_diff_image_side_by_side_sizing_get_type (void)
{
	static gsize gitg_diff_image_side_by_side_sizing_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_image_side_by_side_sizing_type_id__once)) {
		GType gitg_diff_image_side_by_side_sizing_type_id;
		gitg_diff_image_side_by_side_sizing_type_id = gitg_diff_image_side_by_side_sizing_get_type_once ();
		g_once_init_leave (&gitg_diff_image_side_by_side_sizing_type_id__once, gitg_diff_image_side_by_side_sizing_type_id);
	}
	return gitg_diff_image_side_by_side_sizing_type_id__once;
}

static void
gitg_diff_image_side_by_side_class_init (GitgDiffImageSideBySideClass * klass,
                                         gpointer klass_data)
{
	gitg_diff_image_side_by_side_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffImageSideBySide_private_offset);
	((GtkWidgetClass *) klass)->style_updated = (void (*) (GtkWidget*)) gitg_diff_image_side_by_side_real_style_updated;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*) (GtkWidget*, gint, gint*, gint*)) gitg_diff_image_side_by_side_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget*)) gitg_diff_image_side_by_side_real_get_request_mode;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) gitg_diff_image_side_by_side_real_draw;
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) gitg_diff_image_side_by_side_real_realize;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_image_side_by_side_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_image_side_by_side_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_image_side_by_side_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_IMAGE_SIDE_BY_SIDE_CACHE_PROPERTY, gitg_diff_image_side_by_side_properties[GITG_DIFF_IMAGE_SIDE_BY_SIDE_CACHE_PROPERTY] = g_param_spec_object ("cache", "cache", "cache", GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_IMAGE_SIDE_BY_SIDE_SPACING_PROPERTY, gitg_diff_image_side_by_side_properties[GITG_DIFF_IMAGE_SIDE_BY_SIDE_SPACING_PROPERTY] = g_param_spec_int ("spacing", "spacing", "spacing", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gitg_diff_image_side_by_side_instance_init (GitgDiffImageSideBySide * self,
                                            gpointer klass)
{
	self->priv = gitg_diff_image_side_by_side_get_instance_private (self);
}

static void
gitg_diff_image_side_by_side_finalize (GObject * obj)
{
	GitgDiffImageSideBySide * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySide);
	_g_object_unref0 (self->priv->d_old_size_layout);
	_g_object_unref0 (self->priv->d_new_size_layout);
	_g_object_unref0 (self->priv->_cache);
	G_OBJECT_CLASS (gitg_diff_image_side_by_side_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_image_side_by_side_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffImageSideBySideClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_image_side_by_side_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffImageSideBySide), 0, (GInstanceInitFunc) gitg_diff_image_side_by_side_instance_init, NULL };
	GType gitg_diff_image_side_by_side_type_id;
	gitg_diff_image_side_by_side_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GitgDiffImageSideBySide", &g_define_type_info, 0);
	GitgDiffImageSideBySide_private_offset = g_type_add_instance_private (gitg_diff_image_side_by_side_type_id, sizeof (GitgDiffImageSideBySidePrivate));
	return gitg_diff_image_side_by_side_type_id;
}

GType
gitg_diff_image_side_by_side_get_type (void)
{
	static gsize gitg_diff_image_side_by_side_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_image_side_by_side_type_id__once)) {
		GType gitg_diff_image_side_by_side_type_id;
		gitg_diff_image_side_by_side_type_id = gitg_diff_image_side_by_side_get_type_once ();
		g_once_init_leave (&gitg_diff_image_side_by_side_type_id__once, gitg_diff_image_side_by_side_type_id);
	}
	return gitg_diff_image_side_by_side_type_id__once;
}

static void
_vala_gitg_diff_image_side_by_side_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GitgDiffImageSideBySide * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySide);
	switch (property_id) {
		case GITG_DIFF_IMAGE_SIDE_BY_SIDE_CACHE_PROPERTY:
		g_value_set_object (value, gitg_diff_image_side_by_side_get_cache (self));
		break;
		case GITG_DIFF_IMAGE_SIDE_BY_SIDE_SPACING_PROPERTY:
		g_value_set_int (value, gitg_diff_image_side_by_side_get_spacing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_image_side_by_side_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	GitgDiffImageSideBySide * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_IMAGE_SIDE_BY_SIDE, GitgDiffImageSideBySide);
	switch (property_id) {
		case GITG_DIFF_IMAGE_SIDE_BY_SIDE_CACHE_PROPERTY:
		gitg_diff_image_side_by_side_set_cache (self, g_value_get_object (value));
		break;
		case GITG_DIFF_IMAGE_SIDE_BY_SIDE_SPACING_PROPERTY:
		gitg_diff_image_side_by_side_set_spacing (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

