/***************************************************
 * curveeditor_widget.h - a curve editor widget for GTK+
 * Copyright 2004-2016 by Shawn Freeman, Udi Fuchs
 * Modified 2016 Matteo Lucarelli
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 **************************************************/

// CurveData is defined in nikon_curve.h

// creates a new curvereditor widget
extern GtkWidget *curveeditor_widget_new(int height, int width, void (*callback)(), gpointer userdata);

// update the widjet if something has changed
extern void curveeditor_widget_update(GtkWidget *widget);

// set the curve to show
extern void curveeditor_widget_set_curve(GtkWidget *widget, CurveData *curve);

// get the shown curve
extern CurveData *curveeditor_widget_get_curve(GtkWidget *widget);

// get the coordinates of selected point
extern gboolean curveeditor_widget_get_coordinates(GtkWidget *widget, double *x, double *y);

// modify the width  
extern void curveeditor_widget_set_width(int width,GtkWidget *widget);
