/* imap-string-parameter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-string-parameter.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GEARY_IMAP_STRING_PARAMETER_0_PROPERTY,
	GEARY_IMAP_STRING_PARAMETER_ASCII_PROPERTY,
	GEARY_IMAP_STRING_PARAMETER_NULLABLE_ASCII_PROPERTY,
	GEARY_IMAP_STRING_PARAMETER_NUM_PROPERTIES
};
static GParamSpec* geary_imap_string_parameter_properties[GEARY_IMAP_STRING_PARAMETER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GearyImapStringParameterPrivate {
	gchar* _ascii;
};

static gint GearyImapStringParameter_private_offset;
static gpointer geary_imap_string_parameter_parent_class = NULL;

static void geary_imap_string_parameter_set_ascii (GearyImapStringParameter* self,
                                            const gchar* value);
static void geary_imap_string_parameter_finalize (GObject * obj);
static GType geary_imap_string_parameter_get_type_once (void);
static void _vala_geary_imap_string_parameter_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_geary_imap_string_parameter_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
geary_imap_string_parameter_get_instance_private (GearyImapStringParameter* self)
{
	return G_STRUCT_MEMBER_P (self, GearyImapStringParameter_private_offset);
}

const gchar*
geary_imap_string_parameter_get_ascii (GearyImapStringParameter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), NULL);
	_tmp0_ = self->priv->_ascii;
	result = _tmp0_;
	return result;
}

static void
geary_imap_string_parameter_set_ascii (GearyImapStringParameter* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self));
	old_value = geary_imap_string_parameter_get_ascii (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_ascii);
		self->priv->_ascii = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, geary_imap_string_parameter_properties[GEARY_IMAP_STRING_PARAMETER_ASCII_PROPERTY]);
	}
}

const gchar*
geary_imap_string_parameter_get_nullable_ascii (GearyImapStringParameter* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), NULL);
	_tmp1_ = self->priv->_ascii;
	if (geary_string_is_empty (_tmp1_)) {
		_tmp0_ = NULL;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = self->priv->_ascii;
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

GearyImapStringParameter*
geary_imap_string_parameter_construct (GType object_type,
                                       const gchar* ascii)
{
	GearyImapStringParameter * self = NULL;
	g_return_val_if_fail (ascii != NULL, NULL);
	self = (GearyImapStringParameter*) geary_imap_parameter_construct (object_type);
	geary_imap_string_parameter_set_ascii (self, ascii);
	return self;
}

/**
     * Returns a {@link StringParameter} appropriate for the contents of value.
     *
     * Will not return an {@link AtomParameter}, but rather an {@link UnquotedStringParameter} if
     * suitable.  Will not return a {@link NilParameter} for empty strings, but rather a
     * {@link QuotedStringParameter}.
     *
     * Because of these restrictions, should only be used when the context or syntax of the
     * Parameter is unknown or uncertain.
     *
     * @throws ImapError.NOT_SUPPORTED if the string must be represented as a {@link LiteralParameter}.
     * @see Parameter.get_for_string
     */
GearyImapStringParameter*
geary_imap_string_parameter_get_best_for (const gchar* value,
                                          GError** error)
{
	GError* _inner_error0_ = NULL;
	GearyImapStringParameter* result;
	g_return_val_if_fail (value != NULL, NULL);
	if (geary_imap_number_parameter_is_ascii_numeric (value, NULL)) {
		GearyImapNumberParameter* _tmp0_;
		_tmp0_ = geary_imap_number_parameter_new_from_ascii (value);
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
		return result;
	}
	switch (geary_imap_data_format_is_quoting_required (value)) {
		case GEARY_IMAP_DATA_FORMAT_QUOTING_REQUIRED:
		{
			GearyImapQuotedStringParameter* _tmp1_;
			_tmp1_ = geary_imap_quoted_string_parameter_new (value);
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
			return result;
		}
		case GEARY_IMAP_DATA_FORMAT_QUOTING_OPTIONAL:
		{
			GearyImapUnquotedStringParameter* _tmp2_;
			_tmp2_ = geary_imap_unquoted_string_parameter_new (value);
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
			return result;
		}
		case GEARY_IMAP_DATA_FORMAT_QUOTING_UNALLOWED:
		{
			GError* _tmp3_;
			_tmp3_ = g_error_new_literal (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_NOT_SUPPORTED, "String must be a literal parameter");
			_inner_error0_ = _tmp3_;
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

/**
     * Like {@link get_best_for} but the library will panic if the value cannot be turned into
     * a {@link StringParameter}.
     *
     * This should ''only'' be used with string constants that are guaranteed 7-bit ASCII.
     */
GearyImapStringParameter*
geary_imap_string_parameter_get_best_for_unchecked (const gchar* value)
{
	GError* _inner_error0_ = NULL;
	GearyImapStringParameter* result;
	g_return_val_if_fail (value != NULL, NULL);
	{
		GearyImapStringParameter* _tmp0_ = NULL;
		GearyImapStringParameter* _tmp1_;
		GearyImapStringParameter* _tmp2_;
		_tmp1_ = geary_imap_string_parameter_get_best_for (value, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				goto __catch0_geary_imap_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_geary_imap_error:
	{
		GError* ierr = NULL;
		const gchar* _tmp3_;
		ierr = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = ierr->message;
		g_error ("imap-string-parameter.vala:83: Unable to create StringParameter for \"" \
"%s\": %s", value, _tmp3_);
		_g_error_free0 (ierr);
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/**
     * Like {@link get_best_for} but returns null if the value cannot be stored as a
     * {@link StringParameter}.
     *
     * @see Parameter.get_for_string
     */
GearyImapStringParameter*
geary_imap_string_parameter_try_get_best_for (const gchar* value)
{
	GError* _inner_error0_ = NULL;
	GearyImapStringParameter* result;
	g_return_val_if_fail (value != NULL, NULL);
	{
		GearyImapStringParameter* _tmp0_ = NULL;
		GearyImapStringParameter* _tmp1_;
		GearyImapStringParameter* _tmp2_;
		_tmp1_ = geary_imap_string_parameter_get_best_for (value, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
				goto __catch0_geary_imap_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_geary_imap_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/**
     * Can be used by subclasses to properly serialize the string value according to quoting rules.
     *
     * NOTE: Literal data is not currently supported.
     */
void
geary_imap_string_parameter_serialize_string (GearyImapStringParameter* self,
                                              GearyImapSerializer* ser,
                                              GCancellable* cancellable,
                                              GError** error)
{
	const gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self));
	g_return_if_fail (GEARY_IMAP_IS_SERIALIZER (ser));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()));
	_tmp0_ = self->priv->_ascii;
	switch (geary_imap_data_format_is_quoting_required (_tmp0_)) {
		case GEARY_IMAP_DATA_FORMAT_QUOTING_REQUIRED:
		{
			const gchar* _tmp1_;
			_tmp1_ = self->priv->_ascii;
			geary_imap_serializer_push_quoted_string (ser, _tmp1_, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			break;
		}
		case GEARY_IMAP_DATA_FORMAT_QUOTING_OPTIONAL:
		{
			const gchar* _tmp2_;
			_tmp2_ = self->priv->_ascii;
			geary_imap_serializer_push_unquoted_string (ser, _tmp2_, cancellable, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			break;
		}
		case GEARY_IMAP_DATA_FORMAT_QUOTING_UNALLOWED:
		{
			g_error ("imap-string-parameter.vala:119: Unable to serialize literal data");
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

/**
     * Returns the string as a {@link Memory.Buffer}.
     */
GearyMemoryBuffer*
geary_imap_string_parameter_as_buffer (GearyImapStringParameter* self)
{
	const gchar* _tmp0_;
	GearyMemoryStringBuffer* _tmp1_;
	GearyMemoryBuffer* result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), NULL);
	_tmp0_ = self->priv->_ascii;
	_tmp1_ = geary_memory_string_buffer_new (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEARY_MEMORY_TYPE_BUFFER, GearyMemoryBuffer);
	return result;
}

/**
     * Returns true if the string is empty (zero-length).
     */
gboolean
geary_imap_string_parameter_is_empty (GearyImapStringParameter* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), FALSE);
	_tmp0_ = self->priv->_ascii;
	result = geary_string_is_empty (_tmp0_);
	return result;
}

/**
     * Case-sensitive comparison.
     */
gboolean
geary_imap_string_parameter_equals_cs (GearyImapStringParameter* self,
                                       const gchar* value)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = self->priv->_ascii;
	result = geary_ascii_str_equal (_tmp0_, value);
	return result;
}

/**
     * Case-insensitive comparison.
     */
gboolean
geary_imap_string_parameter_equals_ci (GearyImapStringParameter* self,
                                       const gchar* value)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	_tmp0_ = self->priv->_ascii;
	result = geary_ascii_stri_equal (_tmp0_, value);
	return result;
}

/**
     * Returns the string in lowercase.
     */
gchar*
geary_imap_string_parameter_as_lower (GearyImapStringParameter* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), NULL);
	_tmp0_ = self->priv->_ascii;
	_tmp1_ = geary_ascii_strdown (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * Returns the string uppercased.
     */
gchar*
geary_imap_string_parameter_as_upper (GearyImapStringParameter* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), NULL);
	_tmp0_ = self->priv->_ascii;
	_tmp1_ = geary_ascii_strup (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
     * Converts the {@link ascii} to a signed 32-bit integer, clamped between clamp_min and
     * clamp_max.
     *
     * @throws ImapError.INVALID if the {@link StringParameter} contains non-numeric values.  No
     * error is thrown if the numeric value is outside the clamped range.
     */
static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

gint32
geary_imap_string_parameter_as_int32 (GearyImapStringParameter* self,
                                      gint32 clamp_min,
                                      gint32 clamp_max,
                                      GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gint32 result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), 0);
	_tmp0_ = self->priv->_ascii;
	if (!geary_imap_number_parameter_is_ascii_numeric (_tmp0_, NULL)) {
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = self->priv->_ascii;
		_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Cannot convert \"%s\" to int32: not numeric", _tmp1_);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint32 _tmp3_ = -1;
			g_propagate_error (error, _inner_error0_);
			return _tmp3_;
		} else {
			gint32 _tmp4_ = -1;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	_tmp5_ = self->priv->_ascii;
	result = (gint32) CLAMP (int64_parse (_tmp5_, (guint) 0), (gint64) clamp_min, (gint64) clamp_max);
	return result;
}

/**
     * Converts the {@link ascii} to a signed 64-bit integer, clamped between clamp_min and
     * clamp_max.
     *
     * @throws ImapError.INVALID if the {@link StringParameter} contains non-numeric values.  No
     * error is thrown if the numeric value is outside the clamped range.
     */
gint64
geary_imap_string_parameter_as_int64 (GearyImapStringParameter* self,
                                      gint64 clamp_min,
                                      gint64 clamp_max,
                                      GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	gint64 result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), 0LL);
	_tmp0_ = self->priv->_ascii;
	if (!geary_imap_number_parameter_is_ascii_numeric (_tmp0_, NULL)) {
		const gchar* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = self->priv->_ascii;
		_tmp2_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_INVALID, "Cannot convert \"%s\" to int64: not numeric", _tmp1_);
		_inner_error0_ = _tmp2_;
		if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
			gint64 _tmp3_ = -1LL;
			g_propagate_error (error, _inner_error0_);
			return _tmp3_;
		} else {
			gint64 _tmp4_ = -1LL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	_tmp5_ = self->priv->_ascii;
	result = CLAMP (int64_parse (_tmp5_, (guint) 0), clamp_min, clamp_max);
	return result;
}

/**
     * Attempts to coerce a {@link StringParameter} into a {@link NumberParameter}.
     *
     * Returns null if unsuitable for a NumberParameter.
     *
     * @see NumberParameter.is_ascii_numeric
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GearyImapNumberParameter*
geary_imap_string_parameter_coerce_to_number_parameter (GearyImapStringParameter* self)
{
	GearyImapNumberParameter* numberp = NULL;
	GearyImapNumberParameter* _tmp0_;
	GearyImapNumberParameter* _tmp1_;
	const gchar* _tmp2_;
	GearyImapNumberParameter* result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (self), NULL);
	_tmp0_ = _g_object_ref0 (GEARY_IMAP_IS_NUMBER_PARAMETER (self) ? ((GearyImapNumberParameter*) self) : NULL);
	numberp = _tmp0_;
	_tmp1_ = numberp;
	if (_tmp1_ != NULL) {
		result = numberp;
		return result;
	}
	_tmp2_ = self->priv->_ascii;
	if (geary_imap_number_parameter_is_ascii_numeric (_tmp2_, NULL)) {
		const gchar* _tmp3_;
		GearyImapNumberParameter* _tmp4_;
		_tmp3_ = self->priv->_ascii;
		_tmp4_ = geary_imap_number_parameter_new_from_ascii (_tmp3_);
		result = _tmp4_;
		_g_object_unref0 (numberp);
		return result;
	}
	result = NULL;
	_g_object_unref0 (numberp);
	return result;
}

static void
geary_imap_string_parameter_class_init (GearyImapStringParameterClass * klass,
                                        gpointer klass_data)
{
	geary_imap_string_parameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearyImapStringParameter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_imap_string_parameter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_imap_string_parameter_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_imap_string_parameter_finalize;
	/**
	     * The unquoted, decoded string as 7-bit ASCII.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STRING_PARAMETER_ASCII_PROPERTY, geary_imap_string_parameter_properties[GEARY_IMAP_STRING_PARAMETER_ASCII_PROPERTY] = g_param_spec_string ("ascii", "ascii", "ascii", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * Returns {@link ascii} or null if value is empty (zero-length).
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_IMAP_STRING_PARAMETER_NULLABLE_ASCII_PROPERTY, geary_imap_string_parameter_properties[GEARY_IMAP_STRING_PARAMETER_NULLABLE_ASCII_PROPERTY] = g_param_spec_string ("nullable-ascii", "nullable-ascii", "nullable-ascii", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
geary_imap_string_parameter_instance_init (GearyImapStringParameter * self,
                                           gpointer klass)
{
	self->priv = geary_imap_string_parameter_get_instance_private (self);
}

static void
geary_imap_string_parameter_finalize (GObject * obj)
{
	GearyImapStringParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	_g_free0 (self->priv->_ascii);
	G_OBJECT_CLASS (geary_imap_string_parameter_parent_class)->finalize (obj);
}

/**
 * A base abstract representation of string (text) data in IMAP.
 *
 * Although they may be transmitted in various ways, most parameters in IMAP are strings or text
 * format, possibly with some quoting rules applied.  This class handles most issues with these
 * types of {@link Parameter}s.
 *
 * Although the IMAP specification doesn't list an atom as a "string", it is here because of the
 * common functionality that is needed for comparison and other operations.
 *
 * Note that {@link NilParameter} is ''not'' a StringParameter, to avoid type confusion.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-4.3]]
 */
 G_GNUC_NO_INLINE static GType
geary_imap_string_parameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearyImapStringParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_imap_string_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearyImapStringParameter), 0, (GInstanceInitFunc) geary_imap_string_parameter_instance_init, NULL };
	GType geary_imap_string_parameter_type_id;
	geary_imap_string_parameter_type_id = g_type_register_static (GEARY_IMAP_TYPE_PARAMETER, "GearyImapStringParameter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GearyImapStringParameter_private_offset = g_type_add_instance_private (geary_imap_string_parameter_type_id, sizeof (GearyImapStringParameterPrivate));
	return geary_imap_string_parameter_type_id;
}

GType
geary_imap_string_parameter_get_type (void)
{
	static gsize geary_imap_string_parameter_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_string_parameter_type_id__once)) {
		GType geary_imap_string_parameter_type_id;
		geary_imap_string_parameter_type_id = geary_imap_string_parameter_get_type_once ();
		g_once_init_leave (&geary_imap_string_parameter_type_id__once, geary_imap_string_parameter_type_id);
	}
	return geary_imap_string_parameter_type_id__once;
}

static void
_vala_geary_imap_string_parameter_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GearyImapStringParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	switch (property_id) {
		case GEARY_IMAP_STRING_PARAMETER_ASCII_PROPERTY:
		g_value_set_string (value, geary_imap_string_parameter_get_ascii (self));
		break;
		case GEARY_IMAP_STRING_PARAMETER_NULLABLE_ASCII_PROPERTY:
		g_value_set_string (value, geary_imap_string_parameter_get_nullable_ascii (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_imap_string_parameter_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GearyImapStringParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_IMAP_TYPE_STRING_PARAMETER, GearyImapStringParameter);
	switch (property_id) {
		case GEARY_IMAP_STRING_PARAMETER_ASCII_PROPERTY:
		geary_imap_string_parameter_set_ascii (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

