/* application-account-context.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from application-account-context.vala, do not modify */

/*
 * Copyright © 2020 Michael Gratton <mike@vee.net>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later). See the COPYING file in this distribution.
 */

#include "geary-client-46.0.h"
#include "geary-engine.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define APPLICATION_TYPE_CONTROLLER_COMMAND_STACK (application_controller_command_stack_get_type ())
#define APPLICATION_CONTROLLER_COMMAND_STACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), APPLICATION_TYPE_CONTROLLER_COMMAND_STACK, ApplicationControllerCommandStack))
#define APPLICATION_CONTROLLER_COMMAND_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), APPLICATION_TYPE_CONTROLLER_COMMAND_STACK, ApplicationControllerCommandStackClass))
#define APPLICATION_IS_CONTROLLER_COMMAND_STACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), APPLICATION_TYPE_CONTROLLER_COMMAND_STACK))
#define APPLICATION_IS_CONTROLLER_COMMAND_STACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), APPLICATION_TYPE_CONTROLLER_COMMAND_STACK))
#define APPLICATION_CONTROLLER_COMMAND_STACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), APPLICATION_TYPE_CONTROLLER_COMMAND_STACK, ApplicationControllerCommandStackClass))

typedef struct _ApplicationControllerCommandStack ApplicationControllerCommandStack;
typedef struct _ApplicationControllerCommandStackClass ApplicationControllerCommandStackClass;
enum  {
	APPLICATION_ACCOUNT_CONTEXT_0_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_ACCOUNT_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_EMAILS_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_CONTACTS_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_COMMANDS_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_CANCELLABLE_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_CONTROLLER_STACK_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_FAILED_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_PROMPTING_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_ATTEMPTS_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_FAILED_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_PROMPTING_PROPERTY,
	APPLICATION_ACCOUNT_CONTEXT_NUM_PROPERTIES
};
static GParamSpec* application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	APPLICATION_ACCOUNT_CONTEXT_FOLDERS_AVAILABLE_SIGNAL,
	APPLICATION_ACCOUNT_CONTEXT_FOLDERS_UNAVAILABLE_SIGNAL,
	APPLICATION_ACCOUNT_CONTEXT_NUM_SIGNALS
};
static guint application_account_context_signals[APPLICATION_ACCOUNT_CONTEXT_NUM_SIGNALS] = {0};

struct _ApplicationAccountContextPrivate {
	GearyAccount* _account;
	GearyAppEmailStore* _emails;
	ApplicationContactStore* _contacts;
	GCancellable* _cancellable;
	ApplicationControllerCommandStack* _controller_stack;
	gboolean _authentication_failed;
	gboolean _authentication_prompting;
	guint _authentication_attempts;
	gboolean _tls_validation_failed;
	gboolean _tls_validation_prompting;
	GeeMap* folders;
};

static gint ApplicationAccountContext_private_offset;
static gpointer application_account_context_parent_class = NULL;

VALA_EXTERN GType application_controller_command_stack_get_type (void) G_GNUC_CONST ;
static void application_account_context_set_account (ApplicationAccountContext* self,
                                              GearyAccount* value);
static void application_account_context_set_emails (ApplicationAccountContext* self,
                                             GearyAppEmailStore* value);
static void application_account_context_set_contacts (ApplicationAccountContext* self,
                                               ApplicationContactStore* value);
VALA_EXTERN ApplicationControllerCommandStack* application_account_context_get_controller_stack (ApplicationAccountContext* self);
static void application_account_context_set_cancellable (ApplicationAccountContext* self,
                                                  GCancellable* value);
VALA_EXTERN void application_account_context_set_controller_stack (ApplicationAccountContext* self,
                                                       ApplicationControllerCommandStack* value);
VALA_EXTERN ApplicationControllerCommandStack* application_controller_command_stack_new (void);
VALA_EXTERN ApplicationControllerCommandStack* application_controller_command_stack_construct (GType object_type);
VALA_EXTERN gboolean application_account_context_get_authentication_failed (ApplicationAccountContext* self);
VALA_EXTERN void application_account_context_set_authentication_failed (ApplicationAccountContext* self,
                                                            gboolean value);
VALA_EXTERN gboolean application_account_context_get_authentication_prompting (ApplicationAccountContext* self);
VALA_EXTERN void application_account_context_set_authentication_prompting (ApplicationAccountContext* self,
                                                               gboolean value);
VALA_EXTERN guint application_account_context_get_authentication_attempts (ApplicationAccountContext* self);
VALA_EXTERN void application_account_context_set_authentication_attempts (ApplicationAccountContext* self,
                                                              guint value);
VALA_EXTERN gboolean application_account_context_get_tls_validation_failed (ApplicationAccountContext* self);
VALA_EXTERN void application_account_context_set_tls_validation_failed (ApplicationAccountContext* self,
                                                            gboolean value);
VALA_EXTERN gboolean application_account_context_get_tls_validation_prompting (ApplicationAccountContext* self);
VALA_EXTERN void application_account_context_set_tls_validation_prompting (ApplicationAccountContext* self,
                                                               gboolean value);
static gboolean _vala_geary_client_service_status_array_contains (GearyClientServiceStatus * stack,
                                                           gssize stack_length,
                                                           const GearyClientServiceStatus needle);
static void application_account_context_finalize (GObject * obj);
static GType application_account_context_get_type_once (void);
static void _vala_application_account_context_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_application_account_context_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
application_account_context_get_instance_private (ApplicationAccountContext* self)
{
	return G_STRUCT_MEMBER_P (self, ApplicationAccountContext_private_offset);
}

GearyAccount*
application_account_context_get_account (ApplicationAccountContext* self)
{
	GearyAccount* result;
	GearyAccount* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
application_account_context_set_account (ApplicationAccountContext* self,
                                         GearyAccount* value)
{
	GearyAccount* old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_account (self);
	if (old_value != value) {
		GearyAccount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_ACCOUNT_PROPERTY]);
	}
}

GearyAppEmailStore*
application_account_context_get_emails (ApplicationAccountContext* self)
{
	GearyAppEmailStore* result;
	GearyAppEmailStore* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_emails;
	result = _tmp0_;
	return result;
}

static void
application_account_context_set_emails (ApplicationAccountContext* self,
                                        GearyAppEmailStore* value)
{
	GearyAppEmailStore* old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_emails (self);
	if (old_value != value) {
		GearyAppEmailStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_emails);
		self->priv->_emails = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_EMAILS_PROPERTY]);
	}
}

ApplicationContactStore*
application_account_context_get_contacts (ApplicationAccountContext* self)
{
	ApplicationContactStore* result;
	ApplicationContactStore* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_contacts;
	result = _tmp0_;
	return result;
}

static void
application_account_context_set_contacts (ApplicationAccountContext* self,
                                          ApplicationContactStore* value)
{
	ApplicationContactStore* old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_contacts (self);
	if (old_value != value) {
		ApplicationContactStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_contacts);
		self->priv->_contacts = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_CONTACTS_PROPERTY]);
	}
}

ApplicationCommandStack*
application_account_context_get_commands (ApplicationAccountContext* self)
{
	ApplicationCommandStack* result;
	ApplicationControllerCommandStack* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_controller_stack;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, APPLICATION_TYPE_COMMAND_STACK, ApplicationCommandStack);
	return result;
}

GCancellable*
application_account_context_get_cancellable (ApplicationAccountContext* self)
{
	GCancellable* result;
	GCancellable* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static void
application_account_context_set_cancellable (ApplicationAccountContext* self,
                                             GCancellable* value)
{
	GCancellable* old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_cancellable (self);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_CANCELLABLE_PROPERTY]);
	}
}

ApplicationControllerCommandStack*
application_account_context_get_controller_stack (ApplicationAccountContext* self)
{
	ApplicationControllerCommandStack* result;
	ApplicationControllerCommandStack* _tmp0_;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->_controller_stack;
	result = _tmp0_;
	return result;
}

void
application_account_context_set_controller_stack (ApplicationAccountContext* self,
                                                  ApplicationControllerCommandStack* value)
{
	ApplicationControllerCommandStack* old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_controller_stack (self);
	if (old_value != value) {
		ApplicationControllerCommandStack* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_controller_stack);
		self->priv->_controller_stack = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_CONTROLLER_STACK_PROPERTY]);
	}
}

gboolean
application_account_context_get_authentication_failed (ApplicationAccountContext* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), FALSE);
	result = self->priv->_authentication_failed;
	return result;
}

void
application_account_context_set_authentication_failed (ApplicationAccountContext* self,
                                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_authentication_failed (self);
	if (old_value != value) {
		self->priv->_authentication_failed = value;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_FAILED_PROPERTY]);
	}
}

gboolean
application_account_context_get_authentication_prompting (ApplicationAccountContext* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), FALSE);
	result = self->priv->_authentication_prompting;
	return result;
}

void
application_account_context_set_authentication_prompting (ApplicationAccountContext* self,
                                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_authentication_prompting (self);
	if (old_value != value) {
		self->priv->_authentication_prompting = value;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_PROMPTING_PROPERTY]);
	}
}

guint
application_account_context_get_authentication_attempts (ApplicationAccountContext* self)
{
	guint result;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), 0U);
	result = self->priv->_authentication_attempts;
	return result;
}

void
application_account_context_set_authentication_attempts (ApplicationAccountContext* self,
                                                         guint value)
{
	guint old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_authentication_attempts (self);
	if (old_value != value) {
		self->priv->_authentication_attempts = value;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_ATTEMPTS_PROPERTY]);
	}
}

gboolean
application_account_context_get_tls_validation_failed (ApplicationAccountContext* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), FALSE);
	result = self->priv->_tls_validation_failed;
	return result;
}

void
application_account_context_set_tls_validation_failed (ApplicationAccountContext* self,
                                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_tls_validation_failed (self);
	if (old_value != value) {
		self->priv->_tls_validation_failed = value;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_FAILED_PROPERTY]);
	}
}

gboolean
application_account_context_get_tls_validation_prompting (ApplicationAccountContext* self)
{
	gboolean result;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), FALSE);
	result = self->priv->_tls_validation_prompting;
	return result;
}

void
application_account_context_set_tls_validation_prompting (ApplicationAccountContext* self,
                                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	old_value = application_account_context_get_tls_validation_prompting (self);
	if (old_value != value) {
		self->priv->_tls_validation_prompting = value;
		g_object_notify_by_pspec ((GObject *) self, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_PROMPTING_PROPERTY]);
	}
}

ApplicationAccountContext*
application_account_context_construct (GType object_type,
                                       GearyAccount* account,
                                       GearyAppSearchFolder* search,
                                       GearyAppEmailStore* emails,
                                       ApplicationContactStore* contacts)
{
	ApplicationAccountContext * self = NULL;
	GearyAppSearchFolder* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (account, GEARY_TYPE_ACCOUNT), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (search, GEARY_APP_TYPE_SEARCH_FOLDER), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (emails, GEARY_APP_TYPE_EMAIL_STORE), NULL);
	g_return_val_if_fail (APPLICATION_IS_CONTACT_STORE (contacts), NULL);
	self = (ApplicationAccountContext*) geary_base_object_construct (object_type);
	application_account_context_set_account (self, account);
	_tmp0_ = _g_object_ref0 (search);
	_g_object_unref0 (self->search);
	self->search = _tmp0_;
	application_account_context_set_emails (self, emails);
	application_account_context_set_contacts (self, contacts);
	return self;
}

ApplicationAccountContext*
application_account_context_new (GearyAccount* account,
                                 GearyAppSearchFolder* search,
                                 GearyAppEmailStore* emails,
                                 ApplicationContactStore* contacts)
{
	return application_account_context_construct (APPLICATION_TYPE_ACCOUNT_CONTEXT, account, search, emails, contacts);
}

/** Returns the current effective status for the account. */
static gboolean
_vala_geary_client_service_status_array_contains (GearyClientServiceStatus * stack,
                                                  gssize stack_length,
                                                  const GearyClientServiceStatus needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

GearyAccountStatus
application_account_context_get_effective_status (ApplicationAccountContext* self)
{
	GearyAccountStatus current = 0U;
	GearyAccount* _tmp0_;
	GearyAccountStatus _tmp1_;
	GearyAccountStatus _tmp2_;
	GearyAccountStatus effective = 0U;
	GearyAccountStatus result;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), 0U);
	_tmp0_ = self->priv->_account;
	_tmp1_ = geary_account_get_current_status (_tmp0_);
	_tmp2_ = _tmp1_;
	current = _tmp2_;
	effective = 0;
	if (geary_account_status_is_online (current)) {
		effective |= GEARY_ACCOUNT_STATUS_ONLINE;
	}
	if (geary_account_status_has_service_problem (current)) {
		static const GearyClientServiceStatus SPECIALS[2] = {GEARY_CLIENT_SERVICE_STATUS_AUTHENTICATION_FAILED, GEARY_CLIENT_SERVICE_STATUS_TLS_VALIDATION_FAILED};
		gboolean _tmp3_ = FALSE;
		GearyAccount* _tmp4_;
		GearyClientService* _tmp5_;
		GearyClientService* _tmp6_;
		GearyClientServiceStatus _tmp7_;
		GearyClientServiceStatus _tmp8_;
		_tmp4_ = self->priv->_account;
		_tmp5_ = geary_account_get_incoming (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = geary_client_service_get_current_status (_tmp6_);
		_tmp8_ = _tmp7_;
		if (!_vala_geary_client_service_status_array_contains (SPECIALS, G_N_ELEMENTS (SPECIALS), _tmp8_)) {
			GearyAccount* _tmp9_;
			GearyClientService* _tmp10_;
			GearyClientService* _tmp11_;
			GearyClientServiceStatus _tmp12_;
			GearyClientServiceStatus _tmp13_;
			_tmp9_ = self->priv->_account;
			_tmp10_ = geary_account_get_outgoing (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = geary_client_service_get_current_status (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp3_ = !_vala_geary_client_service_status_array_contains (SPECIALS, G_N_ELEMENTS (SPECIALS), _tmp13_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			effective |= GEARY_ACCOUNT_STATUS_SERVICE_PROBLEM;
		}
	}
	result = effective;
	return result;
}

/**
     * Returns read-only collection of all known folder contexts.
     */
GeeCollection*
application_account_context_get_folders (ApplicationAccountContext* self)
{
	GeeMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* result;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), NULL);
	_tmp0_ = self->priv->folders;
	_tmp1_ = gee_map_get_values (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_read_only_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

/**
     * Returns context for a folder belonging to this context's account.
     */
ApplicationFolderContext*
application_account_context_get_folder (ApplicationAccountContext* self,
                                        GearyFolder* target)
{
	ApplicationFolderContext* context = NULL;
	GearyAccount* _tmp0_;
	GearyAccount* _tmp1_;
	GearyAccount* _tmp2_;
	ApplicationFolderContext* result;
	g_return_val_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (target, GEARY_TYPE_FOLDER), NULL);
	context = NULL;
	_tmp0_ = self->priv->_account;
	_tmp1_ = geary_folder_get_account (target);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		GeeMap* _tmp3_;
		GearyFolderPath* _tmp4_;
		GearyFolderPath* _tmp5_;
		gpointer _tmp6_;
		_tmp3_ = self->priv->folders;
		_tmp4_ = geary_folder_get_path (target);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_map_get (_tmp3_, _tmp5_);
		_g_object_unref0 (context);
		context = (ApplicationFolderContext*) _tmp6_;
	}
	result = context;
	return result;
}

/** Adds a context for a folder belonging to the account. */
void
application_account_context_add_folders (ApplicationAccountContext* self,
                                         GeeCollection* to_add)
{
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_add, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _context_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (to_add, GEE_TYPE_ITERABLE, GeeIterable));
		_context_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ApplicationFolderContext* context = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeMap* _tmp4_;
			ApplicationFolderContext* _tmp5_;
			GearyFolder* _tmp6_;
			GearyFolder* _tmp7_;
			GearyFolderPath* _tmp8_;
			GearyFolderPath* _tmp9_;
			ApplicationFolderContext* _tmp10_;
			_tmp1_ = _context_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _context_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			context = (ApplicationFolderContext*) _tmp3_;
			_tmp4_ = self->priv->folders;
			_tmp5_ = context;
			_tmp6_ = application_folder_context_get_folder (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = geary_folder_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = context;
			gee_map_set (_tmp4_, _tmp9_, _tmp10_);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
	g_signal_emit (self, application_account_context_signals[APPLICATION_ACCOUNT_CONTEXT_FOLDERS_AVAILABLE_SIGNAL], 0, to_add);
}

/** Adds a context for a folder belonging to the account. */
void
application_account_context_remove_folders (ApplicationAccountContext* self,
                                            GeeCollection* to_remove)
{
	g_return_if_fail (APPLICATION_IS_ACCOUNT_CONTEXT (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (to_remove, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _context_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (to_remove, GEE_TYPE_ITERABLE, GeeIterable));
		_context_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			ApplicationFolderContext* context = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			GeeMap* _tmp4_;
			ApplicationFolderContext* _tmp5_;
			GearyFolder* _tmp6_;
			GearyFolder* _tmp7_;
			GearyFolderPath* _tmp8_;
			GearyFolderPath* _tmp9_;
			_tmp1_ = _context_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _context_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			context = (ApplicationFolderContext*) _tmp3_;
			_tmp4_ = self->priv->folders;
			_tmp5_ = context;
			_tmp6_ = application_folder_context_get_folder (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = geary_folder_get_path (_tmp7_);
			_tmp9_ = _tmp8_;
			gee_map_unset (_tmp4_, _tmp9_, NULL);
			_g_object_unref0 (context);
		}
		_g_object_unref0 (_context_it);
	}
	g_signal_emit (self, application_account_context_signals[APPLICATION_ACCOUNT_CONTEXT_FOLDERS_UNAVAILABLE_SIGNAL], 0, to_remove);
}

static void
application_account_context_class_init (ApplicationAccountContextClass * klass,
                                        gpointer klass_data)
{
	application_account_context_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ApplicationAccountContext_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_application_account_context_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_application_account_context_set_property;
	G_OBJECT_CLASS (klass)->finalize = application_account_context_finalize;
	/** The account for this context. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_ACCOUNT_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", GEARY_TYPE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The account's email store */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_EMAILS_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_EMAILS_PROPERTY] = g_param_spec_object ("emails", "emails", "emails", GEARY_APP_TYPE_EMAIL_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The account's contact store */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_CONTACTS_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_CONTACTS_PROPERTY] = g_param_spec_object ("contacts", "contacts", "contacts", APPLICATION_TYPE_CONTACT_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The account's application command stack. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_COMMANDS_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_COMMANDS_PROPERTY] = g_param_spec_object ("commands", "commands", "commands", APPLICATION_TYPE_COMMAND_STACK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** A cancellable tied to the life-cycle of the account. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_CANCELLABLE_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** The account's application command stack. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_CONTROLLER_STACK_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_CONTROLLER_STACK_PROPERTY] = g_param_spec_object ("controller-stack", "controller-stack", "controller-stack", APPLICATION_TYPE_CONTROLLER_COMMAND_STACK, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if the account has an authentication problem. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_FAILED_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_FAILED_PROPERTY] = g_param_spec_boolean ("authentication-failed", "authentication-failed", "authentication-failed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if the account is prompting for a password. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_PROMPTING_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_PROMPTING_PROPERTY] = g_param_spec_boolean ("authentication-prompting", "authentication-prompting", "authentication-prompting", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if currently prompting for a password. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_ATTEMPTS_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_ATTEMPTS_PROPERTY] = g_param_spec_uint ("authentication-attempts", "authentication-attempts", "authentication-attempts", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if any TLS certificate errors have been seen. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_FAILED_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_FAILED_PROPERTY] = g_param_spec_boolean ("tls-validation-failed", "tls-validation-failed", "tls-validation-failed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Determines if currently prompting about TLS certificate errors. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_PROMPTING_PROPERTY, application_account_context_properties[APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_PROMPTING_PROPERTY] = g_param_spec_boolean ("tls-validation-prompting", "tls-validation-prompting", "tls-validation-prompting", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/** Emitted when folders contexts become available. */
	application_account_context_signals[APPLICATION_ACCOUNT_CONTEXT_FOLDERS_AVAILABLE_SIGNAL] = g_signal_new ("folders-available", APPLICATION_TYPE_ACCOUNT_CONTEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
	/** Emitted when folders contexts become available. */
	application_account_context_signals[APPLICATION_ACCOUNT_CONTEXT_FOLDERS_UNAVAILABLE_SIGNAL] = g_signal_new ("folders-unavailable", APPLICATION_TYPE_ACCOUNT_CONTEXT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GEE_TYPE_COLLECTION);
}

static void
application_account_context_instance_init (ApplicationAccountContext * self,
                                           gpointer klass)
{
	GCancellable* _tmp0_;
	ApplicationControllerCommandStack* _tmp1_;
	GeeHashMap* _tmp2_;
	self->priv = application_account_context_get_instance_private (self);
	self->inbox = NULL;
	self->search = NULL;
	_tmp0_ = g_cancellable_new ();
	self->priv->_cancellable = _tmp0_;
	_tmp1_ = application_controller_command_stack_new ();
	self->priv->_controller_stack = _tmp1_;
	self->priv->_authentication_failed = FALSE;
	self->priv->_authentication_prompting = FALSE;
	self->priv->_authentication_attempts = (guint) 0;
	self->priv->_tls_validation_failed = FALSE;
	self->priv->_tls_validation_prompting = FALSE;
	_tmp2_ = gee_hash_map_new (GEARY_TYPE_FOLDER_PATH, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, APPLICATION_TYPE_FOLDER_CONTEXT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->folders = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_MAP, GeeMap);
}

static void
application_account_context_finalize (GObject * obj)
{
	ApplicationAccountContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, APPLICATION_TYPE_ACCOUNT_CONTEXT, ApplicationAccountContext);
	_g_object_unref0 (self->priv->_account);
	_g_object_unref0 (self->inbox);
	_g_object_unref0 (self->search);
	_g_object_unref0 (self->priv->_emails);
	_g_object_unref0 (self->priv->_contacts);
	_g_object_unref0 (self->priv->_cancellable);
	_g_object_unref0 (self->priv->_controller_stack);
	_g_object_unref0 (self->priv->folders);
	G_OBJECT_CLASS (application_account_context_parent_class)->finalize (obj);
}

/**
 * Collects application state related to a single open account.
 */
static GType
application_account_context_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ApplicationAccountContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_account_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ApplicationAccountContext), 0, (GInstanceInitFunc) application_account_context_instance_init, NULL };
	GType application_account_context_type_id;
	application_account_context_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "ApplicationAccountContext", &g_define_type_info, 0);
	ApplicationAccountContext_private_offset = g_type_add_instance_private (application_account_context_type_id, sizeof (ApplicationAccountContextPrivate));
	return application_account_context_type_id;
}

GType
application_account_context_get_type (void)
{
	static volatile gsize application_account_context_type_id__once = 0;
	if (g_once_init_enter (&application_account_context_type_id__once)) {
		GType application_account_context_type_id;
		application_account_context_type_id = application_account_context_get_type_once ();
		g_once_init_leave (&application_account_context_type_id__once, application_account_context_type_id);
	}
	return application_account_context_type_id__once;
}

static void
_vala_application_account_context_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ApplicationAccountContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_ACCOUNT_CONTEXT, ApplicationAccountContext);
	switch (property_id) {
		case APPLICATION_ACCOUNT_CONTEXT_ACCOUNT_PROPERTY:
		g_value_set_object (value, application_account_context_get_account (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_EMAILS_PROPERTY:
		g_value_set_object (value, application_account_context_get_emails (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_CONTACTS_PROPERTY:
		g_value_set_object (value, application_account_context_get_contacts (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_COMMANDS_PROPERTY:
		g_value_set_object (value, application_account_context_get_commands (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_CANCELLABLE_PROPERTY:
		g_value_set_object (value, application_account_context_get_cancellable (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_CONTROLLER_STACK_PROPERTY:
		g_value_set_object (value, application_account_context_get_controller_stack (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_FAILED_PROPERTY:
		g_value_set_boolean (value, application_account_context_get_authentication_failed (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_PROMPTING_PROPERTY:
		g_value_set_boolean (value, application_account_context_get_authentication_prompting (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_ATTEMPTS_PROPERTY:
		g_value_set_uint (value, application_account_context_get_authentication_attempts (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_FAILED_PROPERTY:
		g_value_set_boolean (value, application_account_context_get_tls_validation_failed (self));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_PROMPTING_PROPERTY:
		g_value_set_boolean (value, application_account_context_get_tls_validation_prompting (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_application_account_context_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	ApplicationAccountContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, APPLICATION_TYPE_ACCOUNT_CONTEXT, ApplicationAccountContext);
	switch (property_id) {
		case APPLICATION_ACCOUNT_CONTEXT_ACCOUNT_PROPERTY:
		application_account_context_set_account (self, g_value_get_object (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_EMAILS_PROPERTY:
		application_account_context_set_emails (self, g_value_get_object (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_CONTACTS_PROPERTY:
		application_account_context_set_contacts (self, g_value_get_object (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_CANCELLABLE_PROPERTY:
		application_account_context_set_cancellable (self, g_value_get_object (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_CONTROLLER_STACK_PROPERTY:
		application_account_context_set_controller_stack (self, g_value_get_object (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_FAILED_PROPERTY:
		application_account_context_set_authentication_failed (self, g_value_get_boolean (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_PROMPTING_PROPERTY:
		application_account_context_set_authentication_prompting (self, g_value_get_boolean (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_AUTHENTICATION_ATTEMPTS_PROPERTY:
		application_account_context_set_authentication_attempts (self, g_value_get_uint (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_FAILED_PROPERTY:
		application_account_context_set_tls_validation_failed (self, g_value_get_boolean (value));
		break;
		case APPLICATION_ACCOUNT_CONTEXT_TLS_VALIDATION_PROMPTING_PROPERTY:
		application_account_context_set_tls_validation_prompting (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

