/* util-scheduler.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from util-scheduler.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <gee.h>
#include <glib-object.h>
#include "geary-engine.h"
#include <glib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE (geary_scheduler_scheduled_instance_get_type ())
#define GEARY_SCHEDULER_SCHEDULED_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, GearySchedulerScheduledInstance))
#define GEARY_SCHEDULER_SCHEDULED_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, GearySchedulerScheduledInstanceClass))
#define GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE))
#define GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE))
#define GEARY_SCHEDULER_SCHEDULED_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, GearySchedulerScheduledInstanceClass))

typedef struct _GearySchedulerScheduledInstance GearySchedulerScheduledInstance;
typedef struct _GearySchedulerScheduledInstanceClass GearySchedulerScheduledInstanceClass;
typedef struct _GearySchedulerScheduledInstancePrivate GearySchedulerScheduledInstancePrivate;
enum  {
	GEARY_SCHEDULER_SCHEDULED_INSTANCE_0_PROPERTY,
	GEARY_SCHEDULER_SCHEDULED_INSTANCE_MANUAL_REF_COUNT_PROPERTY,
	GEARY_SCHEDULER_SCHEDULED_INSTANCE_NUM_PROPERTIES
};
static GParamSpec* geary_scheduler_scheduled_instance_properties[GEARY_SCHEDULER_SCHEDULED_INSTANCE_NUM_PROPERTIES];
enum  {
	GEARY_SCHEDULER_SCHEDULED_INSTANCE_DEAD_SIGNAL,
	GEARY_SCHEDULER_SCHEDULED_INSTANCE_NUM_SIGNALS
};
static guint geary_scheduler_scheduled_instance_signals[GEARY_SCHEDULER_SCHEDULED_INSTANCE_NUM_SIGNALS] = {0};
enum  {
	GEARY_SCHEDULER_SCHEDULED_0_PROPERTY,
	GEARY_SCHEDULER_SCHEDULED_NUM_PROPERTIES
};
static GParamSpec* geary_scheduler_scheduled_properties[GEARY_SCHEDULER_SCHEDULED_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GearySchedulerSleepAsyncData GearySchedulerSleepAsyncData;
typedef struct _GearySchedulerSleepMsAsyncData GearySchedulerSleepMsAsyncData;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GearySchedulerScheduledInstance {
	GearyBaseObject parent_instance;
	GearySchedulerScheduledInstancePrivate * priv;
};

struct _GearySchedulerScheduledInstanceClass {
	GearyBaseObjectClass parent_class;
};

struct _GearySchedulerScheduledInstancePrivate {
	gint _manual_ref_count;
	GSourceFunc cb;
	gpointer cb_target;
	guint sched_id;
};

struct _GearySchedulerSleepAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	guint seconds;
	guint id;
};

struct _GearySchedulerSleepMsAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	guint milliseconds;
	guint id;
};

VALA_EXTERN GeeHashSet* geary_scheduler_scheduled_map;
GeeHashSet* geary_scheduler_scheduled_map = NULL;
static gint GearySchedulerScheduledInstance_private_offset;
static gpointer geary_scheduler_scheduled_instance_parent_class = NULL;
static GearyReferenceSemanticsIface * geary_scheduler_scheduled_instance_geary_reference_semantics_parent_iface = NULL;
static gpointer geary_scheduler_scheduled_parent_class = NULL;

VALA_EXTERN GType geary_scheduler_scheduled_instance_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GearySchedulerScheduledInstance* geary_scheduler_scheduled_instance_new_on_idle (GSourceFunc cb,
                                                                                 gpointer cb_target,
                                                                                 gint priority);
VALA_EXTERN GearySchedulerScheduledInstance* geary_scheduler_scheduled_instance_construct_on_idle (GType object_type,
                                                                                       GSourceFunc cb,
                                                                                       gpointer cb_target,
                                                                                       gint priority);
static gboolean geary_scheduler_scheduled_instance_on_callback (GearySchedulerScheduledInstance* self);
static gboolean _geary_scheduler_scheduled_instance_on_callback_gsource_func (gpointer self);
static void geary_scheduler_scheduled_instance_on_freed (GearySchedulerScheduledInstance* self);
static void _geary_scheduler_scheduled_instance_on_freed_geary_reference_semantics_freed (GearyReferenceSemantics* _sender,
                                                                                   gpointer self);
VALA_EXTERN GearySchedulerScheduledInstance* geary_scheduler_scheduled_instance_new_after_msec (guint msec,
                                                                                    GSourceFunc cb,
                                                                                    gpointer cb_target,
                                                                                    gint priority);
VALA_EXTERN GearySchedulerScheduledInstance* geary_scheduler_scheduled_instance_construct_after_msec (GType object_type,
                                                                                          guint msec,
                                                                                          GSourceFunc cb,
                                                                                          gpointer cb_target,
                                                                                          gint priority);
VALA_EXTERN GearySchedulerScheduledInstance* geary_scheduler_scheduled_instance_new_after_sec (guint sec,
                                                                                   GSourceFunc cb,
                                                                                   gpointer cb_target,
                                                                                   gint priority);
VALA_EXTERN GearySchedulerScheduledInstance* geary_scheduler_scheduled_instance_construct_after_sec (GType object_type,
                                                                                         guint sec,
                                                                                         GSourceFunc cb,
                                                                                         gpointer cb_target,
                                                                                         gint priority);
VALA_EXTERN void geary_scheduler_scheduled_instance_cancel (GearySchedulerScheduledInstance* self);
VALA_EXTERN GearySchedulerScheduledInstance* geary_scheduler_scheduled_instance_new (void);
VALA_EXTERN GearySchedulerScheduledInstance* geary_scheduler_scheduled_instance_construct (GType object_type);
static void geary_scheduler_scheduled_instance_finalize (GObject * obj);
static GType geary_scheduler_scheduled_instance_get_type_once (void);
static void _vala_geary_scheduler_scheduled_instance_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec);
static void _vala_geary_scheduler_scheduled_instance_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec);
VALA_EXTERN GearySchedulerScheduled* geary_scheduler_scheduled_new (GearySchedulerScheduledInstance* instance);
VALA_EXTERN GearySchedulerScheduled* geary_scheduler_scheduled_construct (GType object_type,
                                                              GearySchedulerScheduledInstance* instance);
static GType geary_scheduler_scheduled_get_type_once (void);
VALA_EXTERN GearySchedulerScheduled* geary_scheduler_schedule_instance (GearySchedulerScheduledInstance* inst);
VALA_EXTERN void geary_scheduler_on_scheduled_dead (GearySchedulerScheduledInstance* inst);
static void _geary_scheduler_on_scheduled_dead_geary_scheduler_scheduled_instance_dead (GearySchedulerScheduledInstance* _sender,
                                                                                 gpointer self);
static void geary_scheduler_sleep_async_data_free (gpointer _data);
static gboolean geary_scheduler_sleep_async_co (GearySchedulerSleepAsyncData* _data_);
static gboolean _geary_scheduler_sleep_async_co_gsource_func (gpointer self);
static void geary_scheduler_sleep_ms_async_data_free (gpointer _data);
static gboolean geary_scheduler_sleep_ms_async_co (GearySchedulerSleepMsAsyncData* _data_);
static gboolean _geary_scheduler_sleep_ms_async_co_gsource_func (gpointer self);

static inline gpointer
geary_scheduler_scheduled_instance_get_instance_private (GearySchedulerScheduledInstance* self)
{
	return G_STRUCT_MEMBER_P (self, GearySchedulerScheduledInstance_private_offset);
}

static gint
geary_scheduler_scheduled_instance_real_get_manual_ref_count (GearyReferenceSemantics* base)
{
	gint result;
	GearySchedulerScheduledInstance* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, GearySchedulerScheduledInstance);
	result = self->priv->_manual_ref_count;
	return result;
}

static void
geary_scheduler_scheduled_instance_real_set_manual_ref_count (GearyReferenceSemantics* base,
                                                              gint value)
{
	GearySchedulerScheduledInstance* self;
	gint old_value;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, GearySchedulerScheduledInstance);
	old_value = geary_scheduler_scheduled_instance_real_get_manual_ref_count (base);
	if (old_value != value) {
		self->priv->_manual_ref_count = value;
		g_object_notify_by_pspec ((GObject *) self, geary_scheduler_scheduled_instance_properties[GEARY_SCHEDULER_SCHEDULED_INSTANCE_MANUAL_REF_COUNT_PROPERTY]);
	}
}

static gboolean
_geary_scheduler_scheduled_instance_on_callback_gsource_func (gpointer self)
{
	gboolean result;
	result = geary_scheduler_scheduled_instance_on_callback ((GearySchedulerScheduledInstance*) self);
	return result;
}

static void
_geary_scheduler_scheduled_instance_on_freed_geary_reference_semantics_freed (GearyReferenceSemantics* _sender,
                                                                              gpointer self)
{
	geary_scheduler_scheduled_instance_on_freed ((GearySchedulerScheduledInstance*) self);
}

GearySchedulerScheduledInstance*
geary_scheduler_scheduled_instance_construct_on_idle (GType object_type,
                                                      GSourceFunc cb,
                                                      gpointer cb_target,
                                                      gint priority)
{
	GearySchedulerScheduledInstance * self = NULL;
	self = (GearySchedulerScheduledInstance*) geary_base_object_construct (object_type);
	self->priv->cb = cb;
	self->priv->cb_target = cb_target;
	self->priv->sched_id = g_idle_add_full (priority, _geary_scheduler_scheduled_instance_on_callback_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics), "freed", (GCallback) _geary_scheduler_scheduled_instance_on_freed_geary_reference_semantics_freed, self, 0);
	return self;
}

GearySchedulerScheduledInstance*
geary_scheduler_scheduled_instance_new_on_idle (GSourceFunc cb,
                                                gpointer cb_target,
                                                gint priority)
{
	return geary_scheduler_scheduled_instance_construct_on_idle (GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, cb, cb_target, priority);
}

GearySchedulerScheduledInstance*
geary_scheduler_scheduled_instance_construct_after_msec (GType object_type,
                                                         guint msec,
                                                         GSourceFunc cb,
                                                         gpointer cb_target,
                                                         gint priority)
{
	GearySchedulerScheduledInstance * self = NULL;
	self = (GearySchedulerScheduledInstance*) geary_base_object_construct (object_type);
	self->priv->cb = cb;
	self->priv->cb_target = cb_target;
	self->priv->sched_id = g_timeout_add_full (priority, msec, _geary_scheduler_scheduled_instance_on_callback_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics), "freed", (GCallback) _geary_scheduler_scheduled_instance_on_freed_geary_reference_semantics_freed, self, 0);
	return self;
}

GearySchedulerScheduledInstance*
geary_scheduler_scheduled_instance_new_after_msec (guint msec,
                                                   GSourceFunc cb,
                                                   gpointer cb_target,
                                                   gint priority)
{
	return geary_scheduler_scheduled_instance_construct_after_msec (GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, msec, cb, cb_target, priority);
}

GearySchedulerScheduledInstance*
geary_scheduler_scheduled_instance_construct_after_sec (GType object_type,
                                                        guint sec,
                                                        GSourceFunc cb,
                                                        gpointer cb_target,
                                                        gint priority)
{
	GearySchedulerScheduledInstance * self = NULL;
	self = (GearySchedulerScheduledInstance*) geary_base_object_construct (object_type);
	self->priv->cb = cb;
	self->priv->cb_target = cb_target;
	self->priv->sched_id = g_timeout_add_seconds_full (priority, sec, _geary_scheduler_scheduled_instance_on_callback_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics), "freed", (GCallback) _geary_scheduler_scheduled_instance_on_freed_geary_reference_semantics_freed, self, 0);
	return self;
}

GearySchedulerScheduledInstance*
geary_scheduler_scheduled_instance_new_after_sec (guint sec,
                                                  GSourceFunc cb,
                                                  gpointer cb_target,
                                                  gint priority)
{
	return geary_scheduler_scheduled_instance_construct_after_sec (GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, sec, cb, cb_target, priority);
}

void
geary_scheduler_scheduled_instance_cancel (GearySchedulerScheduledInstance* self)
{
	g_return_if_fail (GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE (self));
	if (self->priv->sched_id == ((guint) 0)) {
		return;
	}
	g_source_remove (self->priv->sched_id);
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->sched_id = (guint) 0;
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics), "release-now");
}

static gboolean
geary_scheduler_scheduled_instance_on_callback (GearySchedulerScheduledInstance* self)
{
	gboolean _tmp0_ = FALSE;
	GSourceFunc _tmp1_;
	gpointer _tmp1__target;
	gboolean again = FALSE;
	gboolean result;
	g_return_val_if_fail (GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE (self), FALSE);
	_tmp1_ = self->priv->cb;
	_tmp1__target = self->priv->cb_target;
	if (_tmp1_ != NULL) {
		GSourceFunc _tmp2_;
		gpointer _tmp2__target;
		_tmp2_ = self->priv->cb;
		_tmp2__target = self->priv->cb_target;
		_tmp0_ = _tmp2_ (_tmp2__target);
	} else {
		_tmp0_ = FALSE;
	}
	again = _tmp0_;
	if (!again) {
		self->priv->cb = NULL;
		self->priv->cb_target = NULL;
		self->priv->sched_id = (guint) 0;
		if (geary_reference_semantics_is_freed (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics))) {
			g_signal_emit (self, geary_scheduler_scheduled_instance_signals[GEARY_SCHEDULER_SCHEDULED_INSTANCE_DEAD_SIGNAL], 0);
		} else {
			g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics), "release-now");
		}
	}
	result = again;
	return result;
}

static void
geary_scheduler_scheduled_instance_on_freed (GearySchedulerScheduledInstance* self)
{
	g_return_if_fail (GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE (self));
	if (self->priv->sched_id == ((guint) 0)) {
		g_signal_emit (self, geary_scheduler_scheduled_instance_signals[GEARY_SCHEDULER_SCHEDULED_INSTANCE_DEAD_SIGNAL], 0);
	}
}

GearySchedulerScheduledInstance*
geary_scheduler_scheduled_instance_construct (GType object_type)
{
	GearySchedulerScheduledInstance * self = NULL;
	self = (GearySchedulerScheduledInstance*) geary_base_object_construct (object_type);
	return self;
}

GearySchedulerScheduledInstance*
geary_scheduler_scheduled_instance_new (void)
{
	return geary_scheduler_scheduled_instance_construct (GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE);
}

static void
geary_scheduler_scheduled_instance_class_init (GearySchedulerScheduledInstanceClass * klass,
                                               gpointer klass_data)
{
	geary_scheduler_scheduled_instance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GearySchedulerScheduledInstance_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_geary_scheduler_scheduled_instance_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_geary_scheduler_scheduled_instance_set_property;
	G_OBJECT_CLASS (klass)->finalize = geary_scheduler_scheduled_instance_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEARY_SCHEDULER_SCHEDULED_INSTANCE_MANUAL_REF_COUNT_PROPERTY, geary_scheduler_scheduled_instance_properties[GEARY_SCHEDULER_SCHEDULED_INSTANCE_MANUAL_REF_COUNT_PROPERTY] = g_param_spec_int ("manual-ref-count", "manual-ref-count", "manual-ref-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	geary_scheduler_scheduled_instance_signals[GEARY_SCHEDULER_SCHEDULED_INSTANCE_DEAD_SIGNAL] = g_signal_new ("dead", GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
geary_scheduler_scheduled_instance_geary_reference_semantics_interface_init (GearyReferenceSemanticsIface * iface,
                                                                             gpointer iface_data)
{
	geary_scheduler_scheduled_instance_geary_reference_semantics_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_manual_ref_count = geary_scheduler_scheduled_instance_real_get_manual_ref_count;
	iface->set_manual_ref_count = geary_scheduler_scheduled_instance_real_set_manual_ref_count;
}

static void
geary_scheduler_scheduled_instance_instance_init (GearySchedulerScheduledInstance * self,
                                                  gpointer klass)
{
	self->priv = geary_scheduler_scheduled_instance_get_instance_private (self);
}

static void
geary_scheduler_scheduled_instance_finalize (GObject * obj)
{
	GearySchedulerScheduledInstance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, GearySchedulerScheduledInstance);
	G_OBJECT_CLASS (geary_scheduler_scheduled_instance_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
geary_scheduler_scheduled_instance_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySchedulerScheduledInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_scheduler_scheduled_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySchedulerScheduledInstance), 0, (GInstanceInitFunc) geary_scheduler_scheduled_instance_instance_init, NULL };
	static const GInterfaceInfo geary_reference_semantics_info = { (GInterfaceInitFunc) geary_scheduler_scheduled_instance_geary_reference_semantics_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType geary_scheduler_scheduled_instance_type_id;
	geary_scheduler_scheduled_instance_type_id = g_type_register_static (GEARY_TYPE_BASE_OBJECT, "GearySchedulerScheduledInstance", &g_define_type_info, 0);
	g_type_add_interface_static (geary_scheduler_scheduled_instance_type_id, GEARY_TYPE_REFERENCE_SEMANTICS, &geary_reference_semantics_info);
	GearySchedulerScheduledInstance_private_offset = g_type_add_instance_private (geary_scheduler_scheduled_instance_type_id, sizeof (GearySchedulerScheduledInstancePrivate));
	return geary_scheduler_scheduled_instance_type_id;
}

GType
geary_scheduler_scheduled_instance_get_type (void)
{
	static gsize geary_scheduler_scheduled_instance_type_id__once = 0;
	if (g_once_init_enter (&geary_scheduler_scheduled_instance_type_id__once)) {
		GType geary_scheduler_scheduled_instance_type_id;
		geary_scheduler_scheduled_instance_type_id = geary_scheduler_scheduled_instance_get_type_once ();
		g_once_init_leave (&geary_scheduler_scheduled_instance_type_id__once, geary_scheduler_scheduled_instance_type_id);
	}
	return geary_scheduler_scheduled_instance_type_id__once;
}

static void
_vala_geary_scheduler_scheduled_instance_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec)
{
	GearySchedulerScheduledInstance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, GearySchedulerScheduledInstance);
	switch (property_id) {
		case GEARY_SCHEDULER_SCHEDULED_INSTANCE_MANUAL_REF_COUNT_PROPERTY:
		g_value_set_int (value, geary_reference_semantics_get_manual_ref_count (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_geary_scheduler_scheduled_instance_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec)
{
	GearySchedulerScheduledInstance * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, GearySchedulerScheduledInstance);
	switch (property_id) {
		case GEARY_SCHEDULER_SCHEDULED_INSTANCE_MANUAL_REF_COUNT_PROPERTY:
		geary_reference_semantics_set_manual_ref_count (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics), g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

GearySchedulerScheduled*
geary_scheduler_scheduled_construct (GType object_type,
                                     GearySchedulerScheduledInstance* instance)
{
	GearySchedulerScheduled * self = NULL;
	g_return_val_if_fail (GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE (instance), NULL);
	self = (GearySchedulerScheduled*) geary_smart_reference_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (instance, GEARY_TYPE_REFERENCE_SEMANTICS, GearyReferenceSemantics));
	return self;
}

GearySchedulerScheduled*
geary_scheduler_scheduled_new (GearySchedulerScheduledInstance* instance)
{
	return geary_scheduler_scheduled_construct (GEARY_SCHEDULER_TYPE_SCHEDULED, instance);
}

void
geary_scheduler_scheduled_cancel (GearySchedulerScheduled* self)
{
	GearySchedulerScheduledInstance* instance = NULL;
	GearyReferenceSemantics* _tmp0_;
	GearySchedulerScheduledInstance* _tmp1_;
	GearySchedulerScheduledInstance* _tmp2_;
	g_return_if_fail (GEARY_SCHEDULER_IS_SCHEDULED (self));
	_tmp0_ = geary_smart_reference_get_reference (G_TYPE_CHECK_INSTANCE_CAST (self, GEARY_TYPE_SMART_REFERENCE, GearySmartReference));
	_tmp1_ = GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE (_tmp0_) ? ((GearySchedulerScheduledInstance*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	instance = _tmp1_;
	_tmp2_ = instance;
	if (_tmp2_ != NULL) {
		GearySchedulerScheduledInstance* _tmp3_;
		_tmp3_ = instance;
		geary_scheduler_scheduled_instance_cancel (_tmp3_);
	}
	_g_object_unref0 (instance);
}

static void
geary_scheduler_scheduled_class_init (GearySchedulerScheduledClass * klass,
                                      gpointer klass_data)
{
	geary_scheduler_scheduled_parent_class = g_type_class_peek_parent (klass);
}

static void
geary_scheduler_scheduled_instance_init (GearySchedulerScheduled * self,
                                         gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
geary_scheduler_scheduled_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GearySchedulerScheduledClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) geary_scheduler_scheduled_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GearySchedulerScheduled), 0, (GInstanceInitFunc) geary_scheduler_scheduled_instance_init, NULL };
	GType geary_scheduler_scheduled_type_id;
	geary_scheduler_scheduled_type_id = g_type_register_static (GEARY_TYPE_SMART_REFERENCE, "GearySchedulerScheduled", &g_define_type_info, 0);
	return geary_scheduler_scheduled_type_id;
}

GType
geary_scheduler_scheduled_get_type (void)
{
	static gsize geary_scheduler_scheduled_type_id__once = 0;
	if (g_once_init_enter (&geary_scheduler_scheduled_type_id__once)) {
		GType geary_scheduler_scheduled_type_id;
		geary_scheduler_scheduled_type_id = geary_scheduler_scheduled_get_type_once ();
		g_once_init_leave (&geary_scheduler_scheduled_type_id__once, geary_scheduler_scheduled_type_id);
	}
	return geary_scheduler_scheduled_type_id__once;
}

GearySchedulerScheduled*
geary_scheduler_on_idle (GSourceFunc cb,
                         gpointer cb_target,
                         gint priority)
{
	GearySchedulerScheduledInstance* _tmp0_;
	GearySchedulerScheduledInstance* _tmp1_;
	GearySchedulerScheduled* _tmp2_;
	GearySchedulerScheduled* _tmp3_;
	GearySchedulerScheduled* result;
	_tmp0_ = geary_scheduler_scheduled_instance_new_on_idle (cb, cb_target, priority);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_scheduler_schedule_instance (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GearySchedulerScheduled*
geary_scheduler_after_msec (guint msec,
                            GSourceFunc cb,
                            gpointer cb_target,
                            gint priority)
{
	GearySchedulerScheduledInstance* _tmp0_;
	GearySchedulerScheduledInstance* _tmp1_;
	GearySchedulerScheduled* _tmp2_;
	GearySchedulerScheduled* _tmp3_;
	GearySchedulerScheduled* result;
	_tmp0_ = geary_scheduler_scheduled_instance_new_after_msec (msec, cb, cb_target, priority);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_scheduler_schedule_instance (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GearySchedulerScheduled*
geary_scheduler_after_sec (guint sec,
                           GSourceFunc cb,
                           gpointer cb_target,
                           gint priority)
{
	GearySchedulerScheduledInstance* _tmp0_;
	GearySchedulerScheduledInstance* _tmp1_;
	GearySchedulerScheduled* _tmp2_;
	GearySchedulerScheduled* _tmp3_;
	GearySchedulerScheduled* result;
	_tmp0_ = geary_scheduler_scheduled_instance_new_after_sec (sec, cb, cb_target, priority);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_scheduler_schedule_instance (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
_geary_scheduler_on_scheduled_dead_geary_scheduler_scheduled_instance_dead (GearySchedulerScheduledInstance* _sender,
                                                                            gpointer self)
{
	geary_scheduler_on_scheduled_dead (_sender);
}

GearySchedulerScheduled*
geary_scheduler_schedule_instance (GearySchedulerScheduledInstance* inst)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp2_;
	GearySchedulerScheduled* _tmp3_;
	GearySchedulerScheduled* result;
	g_return_val_if_fail (GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE (inst), NULL);
	g_signal_connect (inst, "dead", (GCallback) _geary_scheduler_on_scheduled_dead_geary_scheduler_scheduled_instance_dead, NULL);
	_tmp0_ = geary_scheduler_scheduled_map;
	if (_tmp0_ == NULL) {
		GeeHashSet* _tmp1_;
		_tmp1_ = gee_hash_set_new (GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (geary_scheduler_scheduled_map);
		geary_scheduler_scheduled_map = _tmp1_;
	}
	_tmp2_ = geary_scheduler_scheduled_map;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), inst);
	_tmp3_ = geary_scheduler_scheduled_new (inst);
	result = _tmp3_;
	return result;
}

void
geary_scheduler_on_scheduled_dead (GearySchedulerScheduledInstance* inst)
{
	guint _tmp0_;
	gboolean removed = FALSE;
	GeeHashSet* _tmp1_;
	g_return_if_fail (GEARY_SCHEDULER_IS_SCHEDULED_INSTANCE (inst));
	g_signal_parse_name ("dead", GEARY_SCHEDULER_TYPE_SCHEDULED_INSTANCE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (inst, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _geary_scheduler_on_scheduled_dead_geary_scheduler_scheduled_instance_dead, NULL);
	_tmp1_ = geary_scheduler_scheduled_map;
	removed = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), inst);
	_vala_assert (removed, "removed");
}

static void
geary_scheduler_sleep_async_data_free (gpointer _data)
{
	GearySchedulerSleepAsyncData* _data_;
	_data_ = _data;
	g_slice_free (GearySchedulerSleepAsyncData, _data_);
}

void
geary_scheduler_sleep_async (guint seconds,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	GearySchedulerSleepAsyncData* _data_;
	_data_ = g_slice_new0 (GearySchedulerSleepAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_scheduler_sleep_async_data_free);
	_data_->seconds = seconds;
	geary_scheduler_sleep_async_co (_data_);
}

void
geary_scheduler_sleep_finish (GAsyncResult* _res_)
{
	GearySchedulerSleepAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_geary_scheduler_sleep_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = geary_scheduler_sleep_async_co (self);
	return result;
}

static gboolean
geary_scheduler_sleep_async_co (GearySchedulerSleepAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->seconds, _geary_scheduler_sleep_async_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_source_remove (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
geary_scheduler_sleep_ms_async_data_free (gpointer _data)
{
	GearySchedulerSleepMsAsyncData* _data_;
	_data_ = _data;
	g_slice_free (GearySchedulerSleepMsAsyncData, _data_);
}

void
geary_scheduler_sleep_ms_async (guint milliseconds,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	GearySchedulerSleepMsAsyncData* _data_;
	_data_ = g_slice_new0 (GearySchedulerSleepMsAsyncData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, geary_scheduler_sleep_ms_async_data_free);
	_data_->milliseconds = milliseconds;
	geary_scheduler_sleep_ms_async_co (_data_);
}

void
geary_scheduler_sleep_ms_finish (GAsyncResult* _res_)
{
	GearySchedulerSleepMsAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_geary_scheduler_sleep_ms_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = geary_scheduler_sleep_ms_async_co (self);
	return result;
}

static gboolean
geary_scheduler_sleep_ms_async_co (GearySchedulerSleepMsAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->id = g_timeout_add_full (G_PRIORITY_DEFAULT, _data_->milliseconds, _geary_scheduler_sleep_ms_async_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_source_remove (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

